;
	include		mn_hp_smram.asm
;
	 ORG	  04C000H
		EXTEND
		IDX8
		MEM8
;
;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
;	 1985. 8.12	    V.1.0  Super Mario
;				   File name : SMFRDT
;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
;=========================================================== SMMAIN ==
;=========================================================== SMINIT ==
;........................................................... ( Obst set corde )
	 EXT	  OLD0,OHL0,OCM0,OMS0,OCO0,OBK0,OBK1
	 EXT	  OPB0,OPB1,OPB2,OEW0,OEP0,OCS0,OWT0
	 EXT	  OBG0,OBG1,OBG2,OCM2,OBCO,OBC1,OBC2,OST0
	 EXT	  OBBM,OBBW,OBBS,OLW0,OWC0,OSK0,OCH0,OSL0
	 EXT	  OSP0,OWD0,OBOD
	 EXT	  OCM1,OCM3,OPL0,OGN0,OBMS,BGCH,OSCO,OSMS
	 EXT	  SCOF,CSLP,SCON,SLON,ORBC,OBSM
	 EXT	  JFST,WFST,EXOF
	EXT	BGCL
	EXT	OKID,OCTL,OCTR,OCLC,OCRC,ONBK,ORCK
	EXT	OLBK
;=========================================================== SMPLAY ==
;=========================================================== SMFRDT ==
	 GLB	  RDCRDT,RDCOSS,FRDAST,COURSD,CROSID
	 GLB	  CORS00,CORS01,CORS02,CORS03
	 GLB	  CORS04,CORS05,CORS06,CORS07
;........................................................... ( Castle frame loop )
	 GLB	  CSFLDT
;=========================================================== SMENMY ==
;........................................................... ( Enemy kind No. )
	 EXT	  SHTR,BKTR,RDTR,TUTR
	 EXT	  FTR0,WTR0,WTR1
	 EXT	  FTR2,FTR6,FTR7,FLWR
	 EXT	  EXT0,EXT1,JFS0,EXFF
	 EXT	  ELP0,TMK0,BKF0
	 EXT	  BRG0,SST0,SST1,SST2,SST3,SST4,ESHP
	 EXT	  LFT0,LFT1,LFT2,LFT3,LFT4,LFT5,ELV0,ELV1
	 EXT	  GSHL,GFLG,BMUS,BWOD,FIEN
	 EXT	  IKTR,NOT1,YPVS,JPTR
	 EXT	  GIAL,LFT6
;
	 EXT	  FRW0,CFLG
;
	 EXT	  FREND,BKM0
	 EXT	  GRP0,GRP1,GRP2,GRP3,GRP4,GRP5,GRP6,GRP7
;=========================================================== SMEXST ==
;=========================================================== SMCSET ==
;=========================================================== SMCROS ==
;=========================================================== SMBGOT ==
;=========================================================== SMCOM ===
;
CSFLDT	 EQU	  $	      ;Castle frame loop data
	 BYTE	  DA001-FXOD01			   ; 0
	 BYTE	  DA002-FXOD01			   ; 1
	 BYTE	  DA003-FXOD04			   ; 2 (check-1)
	 BYTE	  DA003-FXOD04			   ; 3 (check-2)
	 BYTE	  DA003-FXOD04			   ; 4
	 BYTE	  DA004-FXOD04			   ; 5 (check-1)
	 BYTE	  DA004-FXOD04			   ; 6 (check-2)
	 BYTE	  DA004-FXOD04			   ; 7
	 BYTE	  DA005-FXOD05			   ; 8
	 BYTE	  DA006-FXOD05			   ; 9
	 BYTE	  DA007-FXOD05			   ; A
;
;
;
;
;
BOGD	 EQU	  01H
BCS1	 EQU	  01H
BCS2	 EQU	  01H
BCS4	 EQU	  01H
;#####################################################################
;#		  CORSNO -- Course No.				     #
;#		  CORSID -- Course index			     #
;#	 JSR	  RDCRDT    [ Read course data ]		     #
;#		  <ENVRFG -- Next environment value		      #
;#		  TRNPT0 --		     frame information data  #			#
;#####################################################################
RDCRDT	 EQU	  $
	PHB
	PHK
	PLB
;
	 JSL	  >RDCOSS		; Read course data
	 STA	  TRNPT0
;
RDCD40	 EQU	  $
	 AND	  #01100000B
	 ASL	  A
	 ROL	  A
	 ROL	  A
	 ROL	  A
	 STA	  <ENVRFG		; <ENVRFG <-- Environment set
;
	PLB
	 RTL
;
;#####################################################################
;#	 JSR	  RDCOSS    [ Read course data sub ]		     #
;#####################################################################
RDCOSS	 EQU	  $
	PHB
	PHK
	PLB
;
	 LDY	  CORSNO
		CPY	#008H
		BCC	RDCOSS_10		; course no. reset ?
;						; yes
		STZ	!CORSID
		STZ	!GOALCT
		LDY	#00000000B
		STY	!CORSNO
RDCOSS_10	EQU	$
	 LDA	  CROSID,Y
	 CLC
	 ADC	  CORSID
	 TAY
;
	 LDA	  COURSD,Y
;
	PLB
	 RTL
;
;*********************************************************************
;*		  TRNPT0 --		     frame information data  *			*
;*	 JSR	  FRDAST    [ Frame data address set ]		     *
;*********************************************************************
FRDAST	 EQU	  $
	PHB
	PHK
	PLB
;
	STZ	<KDVRFG
	 LDA	  TRNPT0
;;;;;	      JSR      RDCD40		    ; <ENVRFG <-- Environment set
	 AND	  #01100000B
	 ASL	  A
	 ROL	  A
	 ROL	  A
	 ROL	  A
	 STA	  <ENVRFG		; <ENVRFG <-- Environment set
	 TAY
;
	 LDA	  TRNPT0
	 AND	  #00011111B
	 STA	  ENVRID	       ; ENVRID <-- Environment index set
;
	 LDA	  FCAIDD,Y	  ; Fix pos chara data address set !
	 CLC
	 ADC	  ENVRID
	 TAY
;
	LDA	FCODA0,Y
	STA	<FXCDA0
	LDA	FCODA1,Y
	STA	<FXCDA0+1
	LDA	#BANK FCODA1
	STA	<FXCDA0+2		; FXCDA0 <-- Fix chara data address (L),(H),(B)
;
	LDY	<ENVRFG
	LDA	FOAIDD,Y
	CLC
	ADC	ENVRID
	TAY
	STA	<BG2COS
	CMP	#1CH
	BCS	FDAS13
	CMP	#19H
	BCS	FDAS12
	CMP	#03H
	BCS	FDAS11
	CMP	#02H
	BCC	FDAS10
FDAS13	EQU	$
	INC	<KDVRFG
FDAS12	EQU	$
	INC	<KDVRFG
FDAS11	EQU	$
	INC	<KDVRFG
FDAS10	EQU	$
;
	LDA	FOODA0,Y
	STA	<FXODA0
	LDA	FOODA1,Y
	STA	<FXODA0+1
	LDA	#BANK FOODA1
	STA	<FXODA0+2		; <FXODA0 <-- Fix obst data address (L),(H),(B)
;
	LDY	#00H			; Read	frame set sub data !
	LDA	[<FXODA0],Y
	PHA
	AND	#00000111B
	CMP	#00000100B
	BCC	FDAS20			; color ?
;					; yes
	AND	#04H
	STA	NIGTFG			; color flag set
	LDA	#00H
FDAS20	EQU	$
	STA	BBGFG0			; BG. environment flag set
;
	PLA
	PHA
	AND	#00111000B
	LSR	A
	LSR	A
	LSR	A
	STA	PLFPFG			; player start position set
;
	PLA
	AND	 #11000000B
	CLC
	ROL	A
	ROL	A
	ROL	A
	STA	PYGMTM			; time set
;
	INY
	LDA	[<FXODA0],Y
	PHA
	AND	#00001111B
	STA	FLRNO			; floor no. set
;
	PLA
	PHA
	AND	#00110000B
	LSR	A
	LSR	A
	LSR	A
	LSR	A
	CMP	#01H
	BNE	FDAS35
	LDA	#00H
FDAS35	EQU	$
	STA	BBGFG1			; BG. set
;
	PLA
	AND	#11000000B
	CLC
	ROL	A
	ROL	A
	ROL	A
	CMP	#00000011B
	BNE	FDAS40			; sky ?
;					; yes
	STA	SKYFLG			; sky flag set
	LDA	#00H
FDAS40	EQU	$
	STA	OBSTFG			; chara. change flag set
;
	JSR	SFGSET
;
	LDA	<FXODA0
	CLC
	ADC	#02H
	STA	<FXODA0
;
	LDA	<FXODA0+1
	ADC	#00H
	STA	<FXODA0+1		; next pointer set
FDAS90	EQU	$
;
	STZ	BSBGMT
	PLB
	RTL
;
SFGSET	EQU	$
	LDA	SKYFLG
	BNE	SFG050
	LDA	<BG2COS
	CMP	#12H
	BNE	SFG090
SFG050	EQU	$
	LDA	#1
	STA	WDSTFG
SFG090	EQU	$
	RTS
;
;#####################################################################
;#	 Course data						     #
;#####################################################################
;
;		  +------+------+
;	 CORSxx	  I x xx  xxxxx I
;		  +------+------+
;		    ^  ^    ^
;		    |  |    +------  Environment data No. ( 00H - 1FH )
;		       +-----------  00:Sky  01:Ground	10:Underground	11:Underwater
;
CROSID	 EQU	  $	    ; Course table index !
	 BYTE	  CORS00-COURSD	       ; Course-0
	 BYTE	  CORS01-COURSD	       ;       -1
	 BYTE	  CORS02-COURSD	       ;       -2
	 BYTE	  CORS03-COURSD	       ;       -3
	 BYTE	  CORS04-COURSD	       ;       -4
	 BYTE	  CORS05-COURSD	       ;       -5
	 BYTE	  CORS06-COURSD	       ;       -6
	 BYTE	  CORS07-COURSD	       ;       -7
;
COURSD	 EQU	  $	    ; Course data !
CORS00	 EQU	  $
;			0      v      1	     v	    2	   v	  3
	 BYTE	  00100000B+05H,00100000B+09H,11000000B+00H,00100000B+06H
	 BYTE	  01100000B+00H
;
CORS01	 EQU	  $
;2 COUSE		0      v      1	     v	    2	   v	  3
	 BYTE	  00100000B+08H,00100000B+09H,00000000B+01H,00100000B+07H
	 BYTE	  01100000B+02H
;
CORS02	 EQU	  $
;3 COUSE		0      v      1	     v	    2	   v	  3
	 BYTE	  00100000B+04H,00100000B+15H,00100000B+00H,01100000B+03H
;
CORS03	 EQU	  $
;4 COUSE		0      v      1	     v	    2	   v	  3
	 BYTE	  00100000B+02H,00100000B+09H,01000000B+01H,00100000B+0CH
	 BYTE	  01100000B+01H
;
CORS04	 EQU	  $
;5 COUSE		0      v      1	     v	    2	   v	  3
	 BYTE	  00100000B+0AH,00100000B+11H,00100000B+06H,01100000B+02H
;
CORS05	 EQU	  $
;6 COUSE		0      v      1	     v	    2	   v	  3
	 BYTE	  00100000B+0EH,00100000B+03H,00100000B+0DH,01100000B+00H
;
CORS06	 EQU	  $
;7 COUSE		0      v      1	     v	    2	   v	  3
	 BYTE	  00100000B+13H,00100000B+09H,00000000B+01H,00100000B+07H
	 BYTE	  01100000B+04H
;
CORS07	 EQU	  $
;8 COUNSE		0      v      1	     v	    2	   v	  3
	 BYTE	  00100000B+10H,00100000B+12H,00100000B+01H,01100000B+05H
;
;#####################################################################
;#	 Fix chara out position data address			     #
;#####################################################################
FCAIDD	 EQU	  $		  ; Fix out chara data address index !
	 BYTE	  UWC0L-FCODA0	       ; Underwater
	 BYTE	  GDC0L-FCODA0	       ; Ground
	 BYTE	  UGC0L-FCODA0	       ; Underground
	 BYTE	  CSC0L-FCODA0	       ; SHIRO
;
FCODA0	 EQU	  $
CSC0L	 EQU	  $	    ; Shiro
	 BYTE	  (FXCD00)&0FFH,(FXCD01)&0FFH,(FXCD02)&0FFH
	 BYTE	  (FXCD03)&0FFH,(FXCD04)&0FFH,(FXCD05)&0FFH
;
GDC0L	 EQU	  $	    ; Ground
	 BYTE	  (FXCD10)&0FFH,(FXCD11)&0FFH,(FXCD12)&0FFH,(FXCD13)&0FFH
	 BYTE	  (FXCD14)&0FFH,(FXCD15)&0FFH,(FXCD16)&0FFH,(FXCD17)&0FFH
	 BYTE	  (FXCD18)&0FFH,(FXCD19)&0FFH,(FXCD1A)&0FFH,(FXCD1B)&0FFH
	 BYTE	  (FXCD1C)&0FFH,(FXCD1D)&0FFH,(FXCD1E)&0FFH,(FXCD1F)&0FFH
	 BYTE	  (FXCD1G)&0FFH,(FXCD1H)&0FFH,(FXCD1I)&0FFH,(FXCD1J)&0FFH
	 BYTE	  (FXCD1K)&0FFH,(FXCD1L)&0FFH
;
UGC0L	 EQU	  $	    ; Underground
	 BYTE	  (FXCD20)&0FFH,(FXCD21)&0FFH,(FXCD22)&0FFH
;
UWC0L	 EQU	  $	    ; Underwater
	 BYTE	  (FXCD30)&0FFH,(FXCD31)&0FFH,(FXCD32)&0FFH
;
;
;
FCODA1	 EQU	  $
CSC0H	 EQU	  $
	 BYTE	  (FXCD00)/100H,(FXCD01)/100H,(FXCD02)/100H,(FXCD03)/100H
	 BYTE	  (FXCD04)/100H,(FXCD05)/100H
;
GDC0H	 EQU	  $
	 BYTE	  (FXCD10)/100H,(FXCD11)/100H,(FXCD12)/100H,(FXCD13)/100H
	 BYTE	  (FXCD14)/100H,(FXCD15)/100H,(FXCD16)/100H,(FXCD17)/100H
	 BYTE	  (FXCD18)/100H,(FXCD19)/100H,(FXCD1A)/100H,(FXCD1B)/100H
	 BYTE	  (FXCD1C)/100H,(FXCD1D)/100H,(FXCD1E)/100H,(FXCD1F)/100H
	 BYTE	  (FXCD1G)/100H,(FXCD1H)/100H,(FXCD1I)/100H,(FXCD1J)/100H
	 BYTE	  (FXCD1K)/100H,(FXCD1L)/100H
;
UGC0H	 EQU	  $
	 BYTE	  (FXCD20)/100H,(FXCD21)/100H,(FXCD22)/100H
;
UWC0H	 EQU	  $
	 BYTE	  (FXCD30)/100H,(FXCD31)/100H,(FXCD32)/100H
;
;
;#####################################################################
;#	 Fix out obstacle data address				     #
;#####################################################################
FOAIDD	 EQU	  $		  ; Fix out obstacle data address index !
	 BYTE	  UWO0L-FOODA0
	 BYTE	  GDO0L-FOODA0
	 BYTE	  UGO0L-FOODA0
	 BYTE	  CSO0L-FOODA0
;
FOODA0	 EQU	  $		  ; Fix pos obstacle data address-L !
UWO0L	 EQU	  $	    ; Underwater
	 BYTE	  (FXOD30)&0FFH,(FXOD31)&0FFH,(FXOD32)&0FFH
;
GDO0L	 EQU	  $	    ; Ground
	 BYTE	  (FXOD10)&0FFH,(FXOD11)&0FFH,(FXOD12)&0FFH,(FXOD13)&0FFH
	 BYTE	  (FXOD14)&0FFH,(FXOD15)&0FFH,(FXOD16)&0FFH,(FXOD17)&0FFH
	 BYTE	  (FXOD18)&0FFH,(FXOD19)&0FFH,(FXOD1A)&0FFH,(FXOD1B)&0FFH
	 BYTE	  (FXOD1C)&0FFH,(FXOD1D)&0FFH,(FXOD1E)&0FFH,(FXOD1F)&0FFH
	 BYTE	  (FXOD1G)&0FFH,(FXOD1H)&0FFH,(FXOD1I)&0FFH,(FXOD1J)&0FFH
	 BYTE	  (FXOD1K)&0FFH,(FXOD1L)&0FFH
;
UGO0L	 EQU	  $	    ; Underground
	 BYTE	  (FXOD20)&0FFH,(FXOD21)&0FFH,(FXOD22)&0FFH
;
CSO0L	 EQU	  $	    ; Shiro
	 BYTE	  (FXOD00)&0FFH,(FXOD01)&0FFH,(FXOD02)&0FFH,(FXOD03)&0FFH
	 BYTE	  (FXOD04)&0FFH,(FXOD05)&0FFH
;
FOODA1	 EQU	  $		  ; Fix pos obstacle data address-L !
UWO0H	 EQU	  $
	 BYTE	  (FXOD30)/100H,(FXOD31)/100H,(FXOD32)/100H
;
GDO0H	 EQU	  $
	 BYTE	  (FXOD10)/100H,(FXOD11)/100H,(FXOD12)/100H,(FXOD13)/100H
	 BYTE	  (FXOD14)/100H,(FXOD15)/100H,(FXOD16)/100H,(FXOD17)/100H
	 BYTE	  (FXOD18)/100H,(FXOD19)/100H,(FXOD1A)/100H,(FXOD1B)/100H
	 BYTE	  (FXOD1C)/100H,(FXOD1D)/100H,(FXOD1E)/100H,(FXOD1F)/100H
	 BYTE	  (FXOD1G)/100H,(FXOD1H)/100H,(FXOD1I)/100H,(FXOD1J)/100H
	 BYTE	  (FXOD1K)/100H,(FXOD1L)/100H
;
UGO0H	 EQU	  $
	 BYTE	  (FXOD20)/100H,(FXOD21)/100H,(FXOD22)/100H
;
CSO0H	 EQU	  $
	 BYTE	  (FXOD00)/100H,(FXOD01)/100H,(FXOD02)/100H,(FXOD03)/100H
	 BYTE	  (FXOD04)/100H,(FXOD05)/100H
;
;
;
;############################################################################################
;#	 Fix chara out position data							    #
;############################################################################################
;
;		 +------+------+------+------+------+-----+
;	 FXCDxx	 I xx	xxxxxx I xxxx | xxxx I x xx xxxxx I
;	     ^^	 +------+------+------+------+------+-----+
;	     ||	    ^	   ^	   ^	  ^    ^  ^   ^
;	     ||	    |	   |	   |	  |    |  |   |
;	     ||	    |	   |	   |	  |    |  |   +----  Enemy No. or Environment No.
;	     ||	    |	   |	   |	  |    |  +--------  00:Sky	     01:Ground
;	     ||	    |	   |	   |	  |    |	     10:Underground  11:Underwater
;	     ||	    |	   |	   |	  |    +-----------  0:Enemy data  1:Environment data
;	     ||	    |	   |	   |	  +-  (y)pos-L
;	     ||	    |	   |	   +--------  (x)pos-L
;	     ||	    |	   +------  (x)pos-H  ( FF : End crode )
;	     ||	    +-------------  00:Out  11:No out
;	     |+---  Kind corde
;	     +----  0:Sky  1:Ground  2:Underground  3:Underwater
;
;#####################################################################
;#	 Fix chara out pos data	 ( Castle )			     #
;#####################################################################
FXCD00	 EQU	  $	    ; Castle - 00 !
	 BYTE	  076H,11000000B+SST2,0BBH,01000000B+JPTR	     ; 1
	 BYTE	  0EAH,00000000B+SST2
;
	 BYTE	  01BH,11000000B+JPTR,056H,01000000B+SST2	     ; 2
;
	 BYTE	  016H,10000000B+SST2,0C6H,00000000B+SST2	     ; 3
;
	 BYTE	  036H,10000000B+SST2,0C9H,00000000B+SST2	     ; 4
;
	 BYTE	  004H,11000000B+SST0,049H,00000000B+SST2	     ; 5
	 BYTE	  084H,00000000B+SST0,0C9H,01000000B+SST2
;
	 BYTE	  088H,10000000B+BKF0				     ; 6
;
	 BYTE	  00FH,008H					     ; 8
;
	 BYTE	  030H,01000000B+JPTR,078H,00000000B+BKM0
	 BYTE	  0A6H,00000000B+LFT4
;
	 BYTE	  090H,10000000B+GIAL				     ; 9
;
	 BYTE	  0FFH
;
;
FXCD01	 EQU	  $	    ; Castle - 01 !
	 BYTE	  00FH,003H					     ; 3
;
	 BYTE	  056H,00000000B+SST0,0C9H,00000000B+SST0
;
	 BYTE	  00FH,007H					     ; 7
;
	 BYTE	  036H,00000000B+SST0,0AAH,00000000B+SST0
;
	 BYTE	  048H,10000000B+BKF0				     ; 8
;
	 BYTE	  00FH,00AH					     ; A
;
	 BYTE	  02AH,00000000B+SST0,05BH,00000000B+JPTR
	 BYTE	  078H,00000000B+BKM0
;
	 BYTE	  090H,10000000B+GIAL				     ; B
;
	 BYTE	  0FFH
;
;
FXCD02	 EQU	  $	    ; Castle - 02 !
	 BYTE	  00BH,10000000B+JPTR,04BH,01000000B+JPTR	     ; 1
	 BYTE	  077H,01000000B+SST4,0EBH,00000000B+JPTR
;
	 BYTE	  0BDH,11000000B+SST0				     ; 2
;
	 BYTE	  019H,10000000B+SST2,075H,00000000B+SST2	     ; 3
	 BYTE	  07DH,01000000B+SST0,0D9H,00000000B+SST2
;
	 BYTE	  03DH,11000000B+SST2,099H,00000000B+SST2	     ; 4
;
	 BYTE	  026H,10000000B+SST2,05AH,00000000B+ELV0	     ; 5
	 BYTE	  08AH,00000000B+ELV1,0CAH,00000000B+SST0
;
	 BYTE	  020H,10000000B+BKF0,07BH,01000000B+SST1	     ; 6
	 BYTE	  0DBH,01000000B+JPTR
;
	 BYTE	  01BH,11000000B+JPTR				     ; 7
;
	 BYTE	  03BH,11000000B+JPTR,078H,00000000B+BKM0	     ; 8
	 BYTE	  0A6H,00000000B+LFT4
;
	 BYTE	  090H,10000000B+GIAL				     ; 9
;
	 BYTE	  0FFH
;
;
FXCD03	 EQU	  $	    ; Castle - 03 !
	 BYTE	  00BH,10000000B+JPTR,03BH,00000000B+SST2	     ; 1
	 BYTE	  08BH,00000000B+SST2,0ABH,00000000B+JPTR
	 BYTE	  0DBH,00000000B+SST2
;
	 BYTE	  00FH,003H					     ; 3
;
	 BYTE	  065H,00000000B+SST2,06BH,00000000B+SST0
;
	 BYTE	  005H,10000000B+SST2,00BH,00000000B+SST0	     ; 4
;
	 BYTE	  005H,10000000B+SST0,00BH,00000000B+SST2	     ; 5
	 BYTE	  08BH,00000000B+JPTR
;
	 BYTE	  01BH,10000000B+JPTR,070H,00000000B+BKF0	     ; 6
	 BYTE	  07BH,00000000B+JPTR,0DBH,00000000B+JPTR
;
	 BYTE	  00FH,008H					     ; 8
;
	 BYTE	  078H,00000000B+BKM0,0A6H,00000000B+LFT4
;
	 BYTE	  090H,10000000B+GIAL				     ; 9
;
	 BYTE	  0FFH
;
;
FXCD04	 EQU	  $	    ; Castle - 04 !
	 BYTE	  027H,10000000B+LFT5,04BH,00000000B+JPTR	     ; 1
	 BYTE	  068H,00000000B+LFT5
;
	 BYTE	  00FH,006H					     ; 6
;
	 BYTE	  077H,00000000B+SST0				     ; 7
;
	 BYTE	  00FH,00BH					     ; B
;
	 BYTE	  060H,00000000B+BKF0
;
	 BYTE	  04BH,10000000B+JPTR,078H,00000000B+BKM0	     ; C
;
	 BYTE	  090H,10000000B+GIAL				     ; D
;
	 BYTE	  0FFH
;
;
FXCD05	 EQU	  $	    ; Castle - 05 !
	 BYTE	  00FH,003H					     ; 3
;
	 BYTE	  08EH,01100101B,11100001B  ;NEXT GOTO CASTLE-5 (F-1)
;
	 BYTE	  0BBH,00000000B+GRP1
;
	 BYTE	  06CH,10000000B+LFT4				     ; 4
;
	 BYTE	  03EH,11100101B,11100111B  ;NEXT GOTO CASTLE-5 (F-7); 5
;
	 BYTE	  00FH,008H					     ; 8
;
	 BYTE	  00BH,00000000B+BKTR,02BH,00000000B+BKTR
;
	 BYTE	  05EH,01100101B,11100001B  ;NEXT GOTO CASTLE-5 (F-1)
;
	 BYTE	  0BBH,00000000B+FTR2,0DBH,00000000B+FTR2
;
	 BYTE	  0BBH,10000000B+FTR2,0DBH,00000000B+FTR2	     ; 9
;
	 BYTE	  0FEH,01100101B,11101100B  ;NEXT GOTO CASTLE-5 (F-C)
;
	 BYTE	  00FH,00DH					     ; D
;
	 BYTE	  04EH,01100101B,11100001B  ;NEXT GOTO CASTLE-5 (F-1)
;
	 BYTE	  00FH,00EH					     ; E
;
	 BYTE	  04EH,00000010B,11100000B  ;NEXT GOTO Underwater-2 (Castle)
;
	 BYTE	  00FH,010H					     ;10
;
	 BYTE	  0FEH,11100101B,11100001B  ;NEXT GOTO CASTLE-5 (F-1)
;
	 BYTE	  01BH,10000000B+FIEN,07BH,00000000B+JPTR	     ;11
;
	 BYTE	  05BH,10000000B+BKF0,078H,00000000B+BKM0	     ;12
;
	 BYTE	  0D0H,10000000B+GIAL				     ;13
;
	 BYTE	  0FFH
;
;
;#####################################################################
;#	 Fix chara out pos data	 ( Ground )			     #
;#####################################################################
FXCD10	 EQU	  $	    ; Ground - 0 !		   / W 2 - 3 /
	 BYTE	  0A5H,10000000B+YPVS,0E4H,00000000B+LFT4	     ; 1
;
	 BYTE	  018H,10000000B+LFT4				     ; 2
;
	 BYTE	  045H,10000000B+TUTR,069H,00000000B+TUTR	     ; 3
	 BYTE	  0C6H,00000000B+LFT5
;
	 BYTE	  09BH,10000000B+TUTR				     ; 4
;
	 BYTE	  016H,10000000B+LFT0,088H,00000000B+LFT0	     ; 5
	 BYTE	  0E9H,00000000B+LFT4
;
	 BYTE	  005H,10000000B+LFT4,07BH,00000000B+LFT4	     ; 6
;
	 BYTE	  024H,10000000B+FTR6,0C8H,00000000B+TUTR	     ; 7
	 BYTE	  0E8H,00000000B+TUTR
;
	 BYTE	  046H,10000000B+LFT4
	 BYTE	  085H,00000000B+LFT0,0C8H,00000000B+LFT0	     ; 8
;
	 BYTE	  0FFH
;
;
FXCD11	 EQU	  $	    ; Ground - 1 !
	 BYTE	  0EBH,10000000B+FTR2				     ; 1
;
	 BYTE	  00FH,003H					     ; 3
;
	 BYTE	  0FBH,00000000B+FIEN
;
	 BYTE	  017H,10000000B+FIEN				     ; 4
;
	 BYTE	  0DBH,10000000B+FTR2				     ; 5
;
	 BYTE	  00FH,007H					     ; 7
;
	 BYTE	  057H,00000000B+FIEN,07BH,00000000B+FIEN
;
	 BYTE	  09BH,10000000B+SHTR				     ; 8
;
	 BYTE	  02BH,10000000B+FIEN,0FBH,00000000B+FIEN	     ; 9
;
	 BYTE	  00FH,00BH					     ; B
;
	 BYTE	  01BH,00000000B+FIEN,09BH,00000000B+FIEN
;
	 BYTE	  0FFH
;
;
FXCD12	 EQU	  $	    ; Ground - 2 !		   / W 4 - 1 /
	 BYTE	  02EH,11000010B,01100110B  ;NEXT GOTO UNDERGROUND-4 ; 1
;
	 BYTE	  0E2H,00000000B+ESHP
;
	 BYTE	  00FH,007H					     ; 7
	 BYTE	  002H,00000000B+ESHP
;
	 BYTE	  00FH,00CH					     ; C
;
	 BYTE	  012H,00000000B+ESHP
;
	 BYTE	  0FFH
;
;
FXCD13	 EQU	  $	    ; Ground - 3 !		   / W 6 - 2 /
	 BYTE	  00EH,11000010B,10101000B  ;NEXT GOTO UNDERGROUND-5
;
	 BYTE	  0ABH,00000000B+SHTR				     ; 1
;
	 BYTE	  0BBH,10000000B+FTR2				     ; 2
;
	 BYTE	  06BH,10000000B+BKTR				     ; 3
;
	 BYTE	  0DEH,00000000B,10100000B  ;NEXT GOTO UNDERWATER-0
;
	 BYTE	  033H,10000000B+YPVS,043H,00000000B+YPVS	     ; 4
;
	 BYTE	  03EH,10110100B,10100000B  ;NEXT GOTO SKY-A	     ; 5
;
	 BYTE	  0CBH,00000000B+BKTR
;
	 BYTE	  00FH,007H					     ; 7
;
	 BYTE	  07EH,01000010B,10100110B  ;NEXT GOTO UNDERGROUND-4
;
	 BYTE	  083H,00000000B+BKTR
;
	 BYTE	  00FH,00AH					     ; A
;
	 BYTE	  03BH,00000000B+BKTR,0CBH,00000000B+GRP0
;
	 BYTE	  00FH,00CH					     ; C
;
	 BYTE	  0E3H,00000000B+FTR2
;
	 BYTE	  0FFH
;
;
FXCD14	 EQU	  $	    ; Ground - 4 !		   / W 3 - 1 /
	 BYTE	  09BH,10000000B+FTR2,0CAH,00000000B+FTR2  ; 1
;
	 BYTE	  0EEH,01000010B,01000100B  ;NEXT GOTO UNDERGROUND-3
;
	 BYTE	  05BH,10000000B+YPVS			   ; 2
;
	 BYTE	  080H,10000000B+GRP1			   ; 3
;
	 BYTE	  01BH,10000000B+SHTR			   ; 4
;
	 BYTE	  050H,10000000B+GRP3			   ; 5
;
	 BYTE	  010H,10000000B+GRP0,05BH,00000000B+SHTR  ; 6
;
	 BYTE	  017H,10000000B+FIEN,04BH,00000000B+FIEN  ; 7
;
	 BYTE	  0FEH,00110100B,01000000B  ;NEXT GOTO SKY-A
;
	 BYTE	  0B7H,10000000B+YPVS,0C6H,00000000B+YPVS  ; 8
;
	 BYTE	  05BH,10000000B+SHTR,083H,00000000B+SHTR  ; 9
	 BYTE	  0D0H,00000000B+GRP1
;
	 BYTE	  05BH,10000000B+FTR2,08AH,00000000B+FTR2  ; A
	 BYTE	  0A6H,00000000B+SHTR,0BBH,00000000B+FTR2
;
	 BYTE	  0C5H,10000000B+SHTR,0F3H,00000000B+SHTR  ; B
;
	 BYTE	  0FFH
;
FXCD15	 EQU	  $	    ; Ground - 5 !		   / W 1 - 1 /
	 BYTE	  01EH,11000010B,00000000B  ;NEXT GOTO UNDERGROUND-1 ; 1
;
	 BYTE	  06BH,00000000B+YPVS
;
	 BYTE	  08BH,10000000B+YPVS				     ; 2
;
	 BYTE	  063H,10000000B+GRP0				     ; 3
;
	 BYTE	  00FH,005H					     ; 5
	 BYTE	  003H,00000000B+YPVS,023H,00000000B+YPVS
;
	 BYTE	  04BH,10000000B+GRP0				     ; 6
	 BYTE	  0BBH,00000000B+SHTR
;
	 BYTE	  05BH,10000000B+GRP0,0FBH,00000000B+GRP0	     ; 7
;
	 BYTE	  03BH,10000000B+GRP0				     ; 8
;
	 BYTE	  00FH,00BH					     ; B
;
	 BYTE	  01BH,00000000B+GRP0
;
	 BYTE	  0FFH
;
;
FXCD16	 EQU	  $	    ; Ground - 6 !  (ASURETIC)	   / W 1 - 3 /
	 BYTE	  02BH,11000000B+TMK0,0E3H,00000000B+TUTR	     ; 1
;
	 BYTE	  0C2H,10000000B+YPVS,0E2H,00000000B+YPVS	     ; 2
;
	 BYTE	  076H,10000000B+LFT1				     ; 3
;
	 BYTE	  0A3H,10000000B+FTR6				     ; 4
;
	 BYTE	  003H,10000000B+YPVS,02BH,01000000B+TMK0	     ; 5
	 BYTE	  068H,00000000B+LFT4,0E9H,00000000B+LFT4
;
	 BYTE	  0E5H,10000000B+TUTR				     ; 6
;
	 BYTE	  024H,10000000B+FTR6				     ; 7
;
	 BYTE	  036H,10000000B+LFT4,05BH,00000000B+TUTR	     ; 8
;
	 BYTE	  0FFH
;
;
FXCD17	 EQU	  $	    ; Ground - 7 !		   / W 3 - 3 /
	 BYTE	  00FH,002H
	 BYTE	  078H,01000000B+SHTR			   ; 2
;
	 BYTE	  048H,11000000B+FTR2			   ; 3
;
	 BYTE	  0F8H,11000000B+TUTR			   ; 4
;
	 BYTE	  0F8H,11000000B+TUTR			   ; 5
;
	 BYTE	  00FH,00000000B+000H+007H		   ; 7
	 BYTE	  07BH,01000000B+TUTR
;
	 BYTE	  0C6H,11000000B+FTR7			   ; 8
;
	 BYTE	  00FH,10000000B+000H+00AH		   ; A
	 BYTE	  0C8H,01000000B+FTR7
;
	 BYTE	  0FFH
;
;
FXCD18	 EQU	  $	    ; Ground - 8 !		   / W 2 - 1 /
	 BYTE	  085H,10000000B+YPVS				     ; 1
;
	 BYTE	  00BH,10000000B+SHTR,01BH,00000000B+SHTR	     ; 2
	 BYTE	  0DBH,00000000B+GRP0
;
	 BYTE	  077H,10000000B+SHTR,0EBH,00000000B+GRP0	     ; 3
;
	 BYTE	  0FEH,00101011B,00100000B  ;NEXT GOTO SKY-B
;
	 BYTE	  02BH,10000000B+SHTR,07BH,00000000B+GRP1	     ; 4
;
	 BYTE	  0ABH,10000000B+GRP1				     ; 5
;
	 BYTE	  077H,10000000B+YPVS				     ; 6
;
	 BYTE	  0FEH,01000010B,00100000B  ;NEXT GOTO UNDERGROUND-1
;
	 BYTE	  049H,10000000B+YPVS,08BH,00000000B+YPVS	     ; 7
;
	 BYTE	  09BH,10000000B+SHTR				     ; 8
;
	 BYTE	  07BH,10000000B+FTR2				     ; 9
;
	 BYTE	  05BH,10000000B+GRP0,09BH,00000000B+FTR2	     ; A
	 BYTE	  0BBH,00000000B+FTR2
;
	 BYTE	  09BH,10000000B+SHTR				     ; B
;
FXCD19	 EQU	  $	    ; Ground - 9 !	GOTO underground
;		  v	 0	     v	     1	       v
;
	 BYTE	  0FFH
;
;
FXCD1A	 EQU	  $	    ; Ground - A !		   / W 5 - 1 /
	 BYTE	  00BH,10000000B+SHTR,060H,00000000B+GRP1  ; 1
;
	 BYTE	  010H,10000000B+GRP1,0C0H,00000000B+GRP4  ; 2
;
	 BYTE	  0DBH,10000000B+FTR2			   ; 3
;
	 BYTE	  040H,10000000B+GRP1,0F0H,00000000B+GRP1  ; 4
;
	 BYTE	  07BH,10000000B+FTR2			   ; 5
;
	 BYTE	  0A0H,10000000B+GRP1			   ; 6
;
	 BYTE	  0C0H,10000000B+GRP1,0FBH,00000000B+SHTR  ; 7
;
	 BYTE	  0A0H,10000000B+GRP1			   ; 8
;
	 BYTE	  030H,10000000B+GRP4			   ; 9
;
	 BYTE	  0EEH,01000010B,10001000B  ;NEXT GOTO UNDERGROUND-5(W5-1)
;
	 BYTE	  00FH,00000000B+00BH			   ; B
	 BYTE	  02BH,00000000B+FTR2,067H,00000000B+FTR2
;
	 BYTE	  0FFH
;
;
;
FXCD1B	 EQU	  $	    ; Ground - B !  (SKY-B)	   / W	 -   /
	 BYTE	  00AH,10000000B+LFT6			   ; 1
	 BYTE	  00EH,00101000B,00101010B  ;NEXT GOTO BACK TO GROUND-8(W8-1)
;
	 BYTE	  00EH,00110001B,10001000B  ;NEXT GOTO BACK TO GROUND-H(W5-1)
;
	 BYTE	  0FFH
;
;
FXCD1C	 EQU	  $	    ; Ground - C !		   / W 4 - 3 /
;							   / W 6 - 3 /
	 BYTE	  0C7H,10000000B+TUTR,0D7H,00000000B+TUTR	     ; 1
;
	 BYTE	  042H,10000000B+FTR6,07AH,00000000B+TUTR  ; 2
;
	 BYTE	  005H,10000000B+LFT0,078H,00000000B+LFT0  ; 3
	 BYTE	  0A6H,00000000B+LFT1,0E4H,00000000B+LFT1
;
	 BYTE	  04BH,10000000B+TUTR,0E3H,00000000B+TUTR  ; 4
;
	 BYTE	  005H,10000000B+LFT0			   ; 5
	 BYTE	  089H,00000000B+LFT0,0B5H,00000000B+LFT0
;
	 BYTE	  009H,10000000B+LFT0,065H,00000000B+LFT0  ; 6
	 BYTE	  0C9H,00000000B+LFT0
;
	 BYTE	  00FH,00000000B+008H			   ; 8
;
	 BYTE	  085H,00000000B+LFT1
;
	 BYTE	  0FFH
;
;
FXCD1D	 EQU	  $	    ; Ground - D !		   / W 6 - 3 /
	 BYTE	  0CCH,10000000B+LFT1			   ; 1
;
	 BYTE	  0B5H,10000000B+LFT4			   ; 2
;
	 BYTE	  007H,10000000B+LFT4			   ; 3
	 BYTE	  076H,00000000B+LFT4,0CCH,00000000B+LFT1
;
	 BYTE	  065H,10000000B+LFT0,0A9H,00000000B+LFT0  ; 4
	 BYTE	  0E5H,00000000B+LFT0
;
	 BYTE	  019H,10000000B+LFT0			   ; 5
;
	 BYTE	  00FH,00000000B+007H			   ; 7
	 BYTE	  095H,00000000B+LFT4,0E6H,00000000B+LFT0
;
	 BYTE	  019H,10000000B+LFT0,0D7H,00000000B+LFT5  ; 8
;
	 BYTE	  016H,10000000B+LFT5,058H,00000000B+LFT5  ; 9
	 BYTE	  097H,00000000B+LFT5
;
	 BYTE	  0FFH
;
;
FXCD1E	 EQU	  $	    ; Ground - E !		   / W 6 - 1 /
	 BYTE	  00FH,002H				   ; 2
	 BYTE	  002H,00000000B+ESHP
;
	 BYTE	  00FH,00000000B+000H+007H		   ; 7
	 BYTE	  002H,00000000B+ESHP
;
	 BYTE	  0FFH
;
;
FXCD1F	 EQU	  $	    ; Ground - F !		   / W 4 - 2 /
;							     secret ground
	 BYTE	  0FFH					   ; end of data
;
;
FXCD1G	 EQU	  $	    ; Ground - G !		   / W 8 - 1 /
	 BYTE	  02BH,10000000B+BKTR,0ABH,00000000B+GRP1	     ; 1
;
	 BYTE	  0DEH,01000010B,11100010B  ;NEXT GOTO UNDERGROUND-2
;
	 BYTE	  01BH,10000000B+YPVS,0EBH,00000000B+GRP4	     ; 2
;
	 BYTE	  0DBH,10000000B+SHTR				     ; 3
;
	 BYTE	  08BH,10000000B+GRP1				     ; 4
;
	 BYTE	  01BH,10000000B+BKTR				     ; 5
;
	 BYTE	  0FBH,10000000B+GRP1				     ; 6
;
	 BYTE	  07BH,10000000B+SHTR,0FBH,00000000B+GRP5	     ; 7
;
	 BYTE	  05BH,10000000B+SHTR;;GRP5				   ; 8
;
	 BYTE	  07BH,10000000B+GRP1				     ; 9
;
	 BYTE	  01BH,10000000B+FTR2,0CBH,00000000B+FTR2	     ; A
;
	 BYTE	  01BH,10000000B+FTR2				     ; B
;
	 BYTE	  00FH,00DH					     ; D
	 BYTE	  02BH,00000000B+GRP4
;
	 BYTE	  0BBH,10000000B+GRP1				     ; E
;
	 BYTE	  0EBH,10000000B+BKTR				     ; F
;
	 BYTE	  04BH,10000000B+GRP1,0BBH,00000000B+GRP1	     ;10
;
	 BYTE	  03BH,10000000B+GRP0,0BBH,00000000B+BKTR	     ;11
;
	 BYTE	  00FH,013H					     ;13
;
	 BYTE	  01BH,00000000B+SHTR
;
	 BYTE	  0CBH,10000000B+SHTR				     ;14
;
	 BYTE	  06BH,10000000B+GRP5				     ;15
;
	 BYTE	  0FFH
;
;
FXCD1H	 EQU	  $	    ; Ground - H !		   / W 5 - 1 /
	 BYTE	  07BH,10000000B+SHTR				     ; 1
;
	 BYTE	  0AEH,00000000B,10000000B  ;NEXT GOTO UNDERWATER-0
;
	 BYTE	  08BH,10000000B+FTR2,0E8H,00000000B+FIEN	     ; 2
;
	 BYTE	  0F9H,10000000B+YPVS				     ; 3
;
	 BYTE	  017H,10000000B+YPVS				     ; 4
;
	 BYTE	  016H,10000000B+FIEN				     ; 5
;
	 BYTE	  04EH,00101011B,10000000B  ;NEXT GOTO SKY-B
;
	 BYTE	  0ABH,10000000B+FTR2				     ; 6
;
	 BYTE	  087H,10000000B+FIEN,0C3H,00000000B+FIEN	     ; 7
;
	 BYTE	  08BH,10000000B+BKTR,09BH,00000000B+BKTR	     ; 8
	 BYTE	  0ABH,00000000B+BKTR
;
	 BYTE	  0BBH,10000000B+YPVS,0CBH,00000000B+YPVS	     ; 9
	 BYTE	  0D3H,00000000B+TUTR
;
	 BYTE	  03BH,10000000B+FTR2,06BH,00000000B+FTR2	     ; A
;
	 BYTE	  0A7H,10000000B+FTR2				     ; B
;
	 BYTE	  0FFH
;
;
FXCD1I	 EQU	  $	    ; Ground - I !		   / W 8 - 2 /
	 BYTE	  029H,10000000B+FTR2,052H,00000000B+ESHP	     ; 1
	 BYTE	  083H,00000000B+FTR2
;
	 BYTE	  00FH,003H					     ; 3
;
	 BYTE	  09BH,00000000B+FTR2
;
	 BYTE	  02BH,10000000B+FTR2,05BH,00000000B+FTR2	     ; 4
;
	 BYTE	  0CBH,10000000B+FTR2,0FBH,00000000B+FTR2	     ; 5
;
	 BYTE	  0FBH,10000000B+BKTR				     ; 6
;
	 BYTE	  09BH,10000000B+BKTR,0BBH,00000000B+BKTR	     ; 7
;
	 BYTE	  0FEH,01000010B,11101000B  ;NEXT GOTO UNDERGROUND-3
;
	 BYTE	  0BBH,10000000B+FTR2				     ; 8
;
	 BYTE	  00FH,00AH					     ; A
;
	 BYTE	  0ABH,00000000B+FTR2,0CBH,00000000B+FTR2
	 BYTE	  0F9H,00000000B+FTR2
;
	 BYTE	  088H,10000000B+YPVS				     ; B
	 BYTE	  0A6H,00000000B+YPVS,0DBH,00000000B+BKTR
;
	 BYTE	  0B6H,10000000B+FTR2				     ; C
;
	 BYTE	  0FFH
;
;
FXCD1J	 EQU	  $	    ; Ground - J !		   / W 7 - 1 /
	 BYTE	  0ABH,11000000B+FTR2			   ; 1
;
	 BYTE	  0DEH,01000010B,11000000B  ;NEXT GOTO UNDERGROUND-1(W7-1)
;
	 BYTE	  0CBH,11000000B+FTR2			   ; 2
;
	 BYTE	  05BH,10000000B+FTR2			   ; 3
;
	 BYTE	  01BH,11000000B+FTR2			   ; 4
;
	 BYTE	  04BH,10000000B+FIEN,067H,01000000B+FIEN  ; 5
;
	 BYTE	  00FH,00000000B+000H+007H		   ; 7
	 BYTE	  02BH,00000000B+SHTR
;
	 BYTE	  07BH,10000000B+FIEN,097H,00000000B+FIEN  ; 8
;
	 BYTE	  00FH,00000000B+000H+00AH
	 BYTE	  092H,00000000B+BKTR
;
	 BYTE	  0FFH					   ; end
;
;
FXCD1K	 EQU	  $	    ; Ground - K !  (SKY-A)	   / W	 -   /
	 BYTE	  00AH,10000000B+LFT6			   ; 1
;
	 BYTE	  00EH,00100100B,01001010B  ;NEXT GOTO BACK TO GROUND-4(W3-1)
;
	 BYTE	  01EH,00100011B,10101010B  ;NEXT GOTO BACK TO GROUND-3(W6-2)
;
	 BYTE	  0FFH
;
;
FXCD1L	 EQU	  $	    ; Ground - L !		   / W 3 - 2 /
	 BYTE	  01BH,10000000B+SHTR,0BBH,00000000B+GRP1  ; 1
;
	 BYTE	  04BH,10000000B+GRP5,0EBH,00000000B+GRP4  ; 2
;
	 BYTE	  00FH,00000000B+004H			   ; 4
;
	 BYTE	  02BH,00000000B+SHTR,0ABH,00000000B+GRP1
	 BYTE	  0EBH,00000000B+SHTR
;
	 BYTE	  0CBH,10000000B+FTR2			   ; 5
;
	 BYTE	  0FBH,10000000B+SHTR			   ; 6
;
	 BYTE	  0ABH,10000000B+GRP1			   ; 7
;
	 BYTE	  06BH,10000000B+SHTR,0FBH,00000000B+GRP5  ; 8
;
	 BYTE	  09BH,10000000B+GRP4			   ; 9
;
	 BYTE	  05BH,10000000B+GRP5,0FBH,00000000B+SHTR  ; A
;
	 BYTE	  06BH,10000000B+GRP1,0FBH,00000000B+GRP1  ; B
;
	 BYTE	  0FFH					   ; end of data
;
;
;#####################################################################
;#	 Fix chara out pos data	 ( Underground )		     #
;#####################################################################
FXCD20	 EQU	  $	    ; Underground - 0 !		   / W 1 - 2 /
	 BYTE	  00BH,10000000B+YPVS,01AH,00000000B+YPVS  ; 1
	 BYTE	  0DBH,00000000B+YPVS
;
	 BYTE	  0DEH,11000010B,00000010B  ;NEXT GOTO UNDERGROUND-2 ; 2
;
	 BYTE	  0F0H,00000000B+GRP4
;
	 BYTE	  0BBH,10000000B+SHTR			   ; 3
	 BYTE	  0EBH,00000000B+YPVS
;
	 BYTE	  00BH,10000000B+YPVS
	 BYTE	  093H,00000000B+YPVS,0F0H,00000000B+GRP2  ; 4
;
	 BYTE	  00FH,00000000B+006H			   ; 6
	 BYTE	  060H,10000000B+GRP1
;
	 BYTE	  01BH,10000000B+YPVS			   ; 7
;
	 BYTE	  0A0H,10000000B+GRP2,0B7H,00000000B+LFT3  ; 8
	 BYTE	  0BDH,00000000B+LFT3
;
	 BYTE	  02BH,10000000B+TUTR,0A1H,00000000B+LFT2  ; 9
	 BYTE	  0A9H,00000000B+LFT2
;
	 BYTE	  0EEH,00100101B,00001011B  ;NEXT GOTO BACK GROUND-5
;
	 BYTE	  027H,10000000B+NOT1			   ; A
;
	 BYTE	  0FFH					   ; END
;
;
;
;
FXCD21	 EQU	  $	    ; Underground - 1 !		   / W 4 - 2 /
	 BYTE	  00FH,002H					     ; 2
;
	 BYTE	  01EH,00101111B,01100000B  ;NEXT GOTO GROUND-F
;
	 BYTE	  0E0H,00000000B+GRP3
;
	 BYTE	  0A5H,10000000B+LFT3				     ; 3
;
;;;;;;;	 BYTE	  080H,10000000B+GRP0
	 BYTE	  0DBH,10000000B+SHTR				     ; 4
;
	 BYTE	  03BH,10000000B+BKTR,08BH,00000000B+BKTR	     ; 5
;
	 BYTE	  0FEH,01000010B,01101000B  ;NEXT GOTO UNDERGROUND-5
;
	 BYTE	  070H,10000000B+GRP4				     ; 6
;
	 BYTE	  025H,10000000B+LFT3,02CH,00000000B+LFT3	     ; 7
	 BYTE	  0B2H,00000000B+LFT2,0B9H,00000000B+LFT2
;
	 BYTE	  09BH,10000000B+SHTR				     ; 8
;
	 BYTE	  0A8H,10000000B+BKTR				     ; 9
	 BYTE	  0B5H,00000000B+LFT3,0BCH,00000000B+LFT3
;
	 BYTE	  0B0H,10000000B+GRP4				     ; A
;
	 BYTE	  03BH,10000000B+BKTR				     ; B
	 BYTE	  087H,00000000B+NOT1
;
	 BYTE	  0EEH,00100101B,01101011B  ;NEXT GOTO BACK GROUND-5
;
	 BYTE	  0FFH
;
;
;
FXCD22	 EQU	  $	    ; Underground - 2 !		   / W	 -   /
;
; (UNDERGROUND-1)
	 BYTE	  01EH,10100101B,00001010B  ;NEXT GOTO BACK GROUND-5 (W1-1)
	 BYTE	  02EH,00101000B,00100111B  ;NEXT GOTO BACK GROUND-8 (W2-1)
	 BYTE	  02EH,00110011B,11000111B  ;NEXT GOTO BACK GROUND-J (W7-1)
;
; (UNDERGROUND-2)
	 BYTE	  00FH,003H
	 BYTE	  01EH,01000000B,00000111B  ;NEXT GOTO BACK UNDERGROUND-0 (W1-2)
	 BYTE	  02EH,00110000B,11100111B  ;NEXT GOTO BACK GROUND-G (W8-1)
;
; (UNDERGROUND-3)
	 BYTE	  00FH,005H
	 BYTE	  01EH,00100100B,01000100B  ;NEXT GOTO BACK GROUND-4 (W3-1)
;
; (UNDERGROUND-4)
	 BYTE	  00FH,007H
	 BYTE	  01EH,00100010B,01101010B  ;NEXT GOTO BACK GROUND-2 (W4-1)
	 BYTE	  02EH,00100011B,10101011B  ;NEXT GOTO BACK GROUND-3 (W3-2)
;
; (UNDERGROUND-5)
	 BYTE	  00FH,009H
	 BYTE	  01EH,01000001B,01101000B  ;NEXT GOTO BACK UNDERGROUND-1 (W4-2)
	 BYTE	  01EH,00101010B,10001010B  ;NEXT GOTO BACK GROUND-J (W5-2)
	 BYTE	  02EH,00100011B,10100010B  ;NEXT GOTO BACK GROUND-3 (W6-2)
	 BYTE	  02EH,00110010B,11101010B  ;NEXT GOTO BACK GROUND-I (W8-2)
	 BYTE	  0FFH
;
;
;
;#####################################################################
;#	 Fix chara out pos data	 ( Underwater )			     #
;#####################################################################
;
FXCD30	 EQU	  $	    ; Underwater - 0 !
;		  v	 0	     v	     1	       v
	 BYTE	  03BH,10000000B+IKTR,066H,00000000B+LFT3  ; 1
	 BYTE	  0CCH,00000000B+LFT3
;
	 BYTE	  0EEH,00110001B,10000111B  ;NEXT GOTO BACK GROUND-H (W5-1)
;
	 BYTE	  0EEH,00100011B,10100111B  ;NEXT GOTO BACK GROUND-3 (W6-1)
;
	 BYTE	  03BH,10000000B+IKTR,0DBH,00000000B+IKTR  ; 2
;
	 BYTE	  0FFH
;
;
FXCD31	 EQU	  $	    ; Underwater - 1 !		   / W 2 - 2 /
;		  v	 0	     v	     1	       v   / W 3 - 2 /
	 BYTE	  00FH,00000000B+001H			   ; 1
;
	 BYTE	  02EH,00100101B,00101011B  ;NEXT GOTO BACK GROUND-5
	 BYTE	  02EH,00100101B,01001011B  ;NEXT GOTO BACK GROUND-5
	 BYTE	  04EH,00100101B,11001011B  ;NEXT GOTO BACK GROUND-5
;
	 BYTE	  06BH,00000000B+IKTR,097H,01000000B+IKTR
;
	 BYTE	  0E9H,10000000B+IKTR			   ; 2
;
	 BYTE	  047H,11000000B+IKTR,07AH,00000000B+IKTR  ; 3
;
	 BYTE	  0D6H,11000000B+IKTR			   ; 4
;
	 BYTE	  078H,00000000B+IKTR			   ; 5
;
	 BYTE	  038H,10000000B+IKTR,0ABH,01000000B+IKTR  ; 6
	 BYTE	  0E3H,00000000B+IKTR
;
	 BYTE	  09BH,10000000B+IKTR			   ; 7
;
	 BYTE	  00FH,00000000B+009H			   ; 9
	 BYTE	  068H,01000000B+IKTR
;
	 BYTE	  0DBH,11000000B+IKTR			   ; A
;
	 BYTE	  03BH,11000000B+IKTR			   ; B
;
	 BYTE	  0FFH
;
;
FXCD32	 EQU	  $	    ; Underwater - 2 !		   / W 8 - 4 / (Castle)
	 BYTE	  047H,10000000B+SST0,0CBH,00000000B+IKTR	     ; 1
	 BYTE	  0FAH,00000000B+SST2
;
	 BYTE	  086H,10000000B+SST0				     ; 2
;
	 BYTE	  03AH,10000000B+IKTR,056H,00000000B+IKTR	     ; 3
	 BYTE	  088H,00000000B+SST0
;
	 BYTE	  007H,10000000B+SST2				     ; 4
;
	 BYTE	  02EH,01100101B,11110000B  ;NEXT GOTO CASTLE-5 (F-10)
;
	 BYTE	  0FFH
;
;
;############################################################################################
;#	 Fix obstacle out position data							    #
;############################################################################################
;
;		 +------+------+  +------+------+
;	 FXODxx	 I x xxx xxxxx I  I  xxx  xxxxx I
;	     ^^	 +------+------+  +------+------+
;	     ||	   ^  ^	   ^	      ^	    ^
;	     ||	   |  |	   |	      |	    |
;	     ||	   |  |	   |	      |	    |
;	     ||	   |  |	   |	      |	    |
;	     ||	   |  |	   |	      |	    +---  Floor display max loop
;	     ||	   |  |	   |	      +--------- Player start position data index
;	     ||	   |  |	   |
;	     ||	   |  |	   +------  Base BG environmen
;	     ||	   |  +-----------  Play farst base time
;	     ||	   +--------------  0:ON Floor	      1:OFF Floor
;	     ||
;	     ||	 +------+------+------+------+-----+-----+
;	     ||	 I x x	xxxxxx I xxxx | xxxx I xxxx|xxxx I
;	     ||	 +------+------+------+------+-----+-----+
;	     ||	   ^ ^	   ^	   ^	  ^	 ^    ^
;	     ||	   | |	   |	   |	  |	 |    |
;	     ||	   | |	   |	   |	  |	 |    +----  Obstacle display count
;	     ||	   | |	   |	   |	  |	 +---------  Obstacle kind No.
;	     ||	   | |	   |	   |	  +-  (y)pos-L	     F:BG environment change mode
;	     ||	   | |	   |	   +--------  (x)pos-L
;	     ||	   | |	   |
;	     ||	   | |	   +------  (x)pos-H  ( FF : End crode )
;	     ||	   | +------------  0:Floot length 1:Fix length
;	     ||	   |
;	     ||	   +--------  00:Out  11:No out
;	     ||
;	     |+---  Kind corde
;	     +----  0:Underwater 1:Ground  2:Underground  3:Castle
;
;#####################################################################
;#	 Fix obstacle out pos data  ( Castle )			     #
;#####################################################################
FXOD00	EQU	$		; Castle - 00 !
	BYTE	10011011B,00000111B
;
	BYTE	00FH,050H+002H,00000000B+OKID		; 0
	BYTE	00FH,060H+003H,00000000B+OKID
	BYTE	00FH,070H+004H,00000000B+OKID
;;;;;;;;	BYTE	005H,00000000B+OBK1+002H,006H,00000000B+OBK1+003H	; 0
;;;;;;;;	BYTE	007H,00000000B+OBK1+004H
;
	BYTE	0CFH,080H+000H,00000000B+OCTL
	BYTE	0CEH,00000011B
;
	BYTE	0DCH,00000000B+OWT0+001H
;
	BYTE	0EEH,00000111B
	BYTE	0FFH,080H+000H,00000000B+OCTR
;
;;;;;;;;	BYTE	073H,10000000B+OPB1+000H
	BYTE	07FH,030H+000H,10000000B+ONBK					; 1
	BYTE	074H,00000000B+000H+OSP0
;
	BYTE	07EH,00000110B
	BYTE	07FH,020H+000H,00000000B+ONBK
;
	BYTE	09FH,080H+000H,00000000B+OCTL
	BYTE	09EH,00001010B
;
	BYTE	0CEH,00000110B
	BYTE	0DFH,080H+000H,00000000B+OCTR
;
	BYTE	0E4H,00000000B+000H+OBMS,0E8H,00000000B+000H+OSP0
;
	BYTE	0FFH,080H+000H,00000000B+OCTL
	BYTE	0FEH,00001010B
;
	BYTE	02EH,10001001B						; 2
	BYTE	03FH,070H+000H,00000000B+OCTR
;
	BYTE	04EH,00001011B
	BYTE	05FH,010H+000H,00000000B+ONBK
;
	BYTE	054H,00000000B+OSP0+000H
;
	BYTE	014H,10000000B+000H+OSP0,0C4H,00000000B+000H+OSP0	; 3
;
	BYTE	034H,10000000B+000H+OSP0				; 4
;
	BYTE	07FH,070H+001H,00000000B+OCLC
	BYTE	07FH,020H+000H,00000000B+ONBK
	BYTE	07EH,00000110B
;
	BYTE	0C7H,00000000B+000H+OSP0
;
;;;;;;;;	BYTE	001H,10000000B+OPB1+000H
	BYTE	00FH,010H+000H,10000000B+ONBK				; 5
	BYTE	002H,00000000B+000H+OSP0
	BYTE	047H,00000000B+000H+OSP0
;;;;;;;;	BYTE	081H,00000000B+OPB1+000H
	BYTE	08FH,010H+000H,00000000B+ONBK
	BYTE	082H,00000000B+000H+OSP0
	BYTE	0C7H,00000000B+OSP0+000H
;
	BYTE	00EH,10000111B						; 6
	BYTE	01FH,010H+000H,00000000B+ONBK
;
	BYTE	07FH,020H+000H,00000000B+ONBK
	BYTE	07FH,0A0H+001H,00000000B+OCLC
	BYTE	07FH,080H+000H,00000000B+OCTL
	BYTE	07EH,00000010B
;
	BYTE	0A7H,00000000B+000H+OSCO,0B3H,00000000B+000H+OSCO
	BYTE	0D7H,00000000B+000H+OSCO,0E3H,00000000B+000H+OSCO
;
	BYTE	007H,10000000B+000H+OSCO,013H,00000000B+000H+OSCO	; 7
;
	BYTE	03EH,00000110B
	BYTE	03FH,0A0H+001H,00000000B+OCRC
	BYTE	04FH,080H+000H,00000000B+OCTR
;
	BYTE	07FH,0A0H+001H,00000000B+OCLC
	BYTE	07FH,080H+000H,00000000B+OCTL
	BYTE	07EH,00000010B
;
	BYTE	0AEH,00000111B
	BYTE	0AFH,0A0H+001H,00000000B+OCRC
	BYTE	0BFH,080H+000H,00000000B+OCTR
	BYTE	0BFH,010H+000H,00000000B+ONBK
;
	BYTE	0FEH,00001010B
	BYTE	0FFH,020H+000H,00000000B+ONBK
	BYTE	0FFH,080H+000H,00000000B+OCTL
;
	BYTE	00DH,10000000B+000H+OSL0,0CDH,00000000B+000H+OCH0	; 8
;
	BYTE	0CEH,00001001B
;
	BYTE	0DEH,00001011B
	BYTE	0DFH,070H+000H,00000000B+OCTR
;
	BYTE	0DDH,00000000B+000H+OSK0
	BYTE	0EFH,020H+000H,00000000B+ONBK
;
	BYTE	0FFH,020H+000H,00000000B+ONBK
	BYTE	0FFH,0A0H+001H,00000000B+OCLC
	BYTE	0FFH,070H+000H,00000000B+OCTL
	BYTE	0FEH,00000010B
;
	BYTE	05DH,10000000B+000H+SCOF				; 9
;
;
	BYTE	0FDH
;
;
;
FXOD01	EQU	$		; Castle - 01 !
	BYTE	01011011B,00000111B
;
	BYTE	00FH,050H+002H,00000000B+OKID		; 0
	BYTE	00FH,060H+003H,00000000B+OKID
	BYTE	00FH,070H+004H,00000000B+OKID
;;;;;;;;	BYTE	005H,00000000B+OBK1+002H,006H,00000000B+OBK1+003H	; 0
;;;;;;;;	BYTE	007H,00000000B+OBK1+004H
;
	BYTE	05EH,00001010B
	BYTE	05FH,020H+000H,00000000B+ONBK
	BYTE	06FH,080H+000H,00000000B+OCTL
;
	BYTE	068H,00000000B+OPB1+004H
	BYTE	09FH,080H+000H,00000000B+OCTR
	BYTE	0AFH,080H+000H,00000000B+OCTL
;;;;;;;;	BYTE	098H,00000000B+OPB1+004H
;;;;;;;;	BYTE	0A8H,00000000B+OPB1+004H
;
	BYTE	0CEH,00000110B
	BYTE	0DFH,080H+000H,00000000B+OCTR
;
	BYTE	0FFH,0A0H+001H,00000000B+OCLC
	BYTE	0FFH,080H+000H,00000000B+OCTL
DA001	EQU	$
	BYTE	0FEH,00000010B
;
	BYTE	00DH,001H						; 1
;
	BYTE	01EH,00001110B
	BYTE	024H,00000000B+OPB1+003H,034H,00000000B+OPB1+003H
	BYTE	044H,00000000B+OPB1+003H,054H,00000000B+OPB1+003H
	BYTE	064H,00000000B+OPB1+003H,074H,00000000B+OPB1+003H
;
	BYTE	07EH,00000010B
;
	BYTE	094H,00000000B+OPB1+003H,0B4H,00000000B+OPB1+003H
	BYTE	0D4H,00000000B+OPB1+003H,0F4H,00000000B+OPB1+003H
;
	BYTE	014H,10000000B+OPB1+003H				; 2
;
	BYTE	02EH,00001110B
	BYTE	034H,00000000B+OPB1+003H,044H,00000000B+OPB1+003H
	BYTE	054H,00000000B+OPB1+003H
;
	BYTE	05EH,00000010B
;
	BYTE	064H,00000000B+OBK1+005H,088H,00000000B+OCM2+002H
;
	BYTE	0BEH,00001110B
	BYTE	0C4H,00000000B+OPB1+003H,0D4H,00000000B+OPB1+003H
	BYTE	0E4H,00000000B+OPB1+003H,0F4H,00000000B+OPB1+003H
;
	BYTE	004H,10000000B+OPB1+003H,014H,00000000B+OPB1+003H	; 3
	BYTE	024H,00000000B+OPB1+003H,034H,00000000B+OPB1+003H
	BYTE	044H,00000000B+OPB1+003H,054H,00000000B+OPB1+003H
	BYTE	064H,00000000B+OPB1+003H,074H,00000000B+OPB1+003H
	BYTE	084H,00000000B+OPB1+003H,094H,00000000B+OPB1+003H
	BYTE	0A4H,00000000B+OPB1+003H,0B4H,00000000B+OPB1+003H
	BYTE	0C4H,00000000B+OPB1+003H,0D4H,00000000B+OPB1+003H
	BYTE	0E4H,00000000B+OPB1+003H,0F4H,00000000B+OPB1+003H
;
	BYTE	00DH,004H						; 4
;
	BYTE	004H,00000000B+OPB1+003H,014H,00000000B+OPB1+003H
	BYTE	024H,00000000B+OPB1+003H,034H,00000000B+OPB1+003H
	BYTE	044H,00000000B+OPB1+003H,054H,00000000B+OPB1+003H
	BYTE	064H,00000000B+OPB1+003H,074H,00000000B+OPB1+003H
	BYTE	084H,00000000B+OPB1+003H,094H,00000000B+OPB1+003H
	BYTE	0A4H,00000000B+OPB1+003H
;
	BYTE	0AEH,00000010B
;
	BYTE	0CEH,00001000B
	BYTE	0CFH,0A0H+001H,00000000B+OCRC
;
	BYTE	0CDH,00000000B+000H+CSLP
	BYTE	0DFH,010H+000H,00000000B+ONBK
	BYTE	0DFH,080H+000H,00000000B+OCTR
;
	BYTE	0FFH,0A0H+001H,00000000B+OCLC
	BYTE	0FFH,080H+000H,00000000B+OCTL
	BYTE	0FFH,020H+000H,00000000B+ONBK
DA002	EQU	$
	BYTE	0FEH,00000010B
;
	BYTE	00DH,005H						; 5
;
	BYTE	068H,00000000B+OBK1+001H
;
	BYTE	07EH,00001010B
	BYTE	07FH,0B0H+000H,00000000B+OCTL
;
	BYTE	096H,00000000B+OBK1+001H,0A9H,00000000B+OPB1+003H
	BYTE	0A8H,00000000B+OBK1+003H,0D5H,00000000B+OBK1+000H
;
	BYTE	0EEH,00000010B
;
	BYTE	0E6H,00000000B+OPB1+002H,0F4H,00000000B+OPB1+001H
	BYTE	0FFH,0B0H+000H,00000000B+OCTR
;
	BYTE	004H,10000000B+OBK1+001H,008H,00000000B+OBK1+00FH	; 6
	BYTE	044H,00000000B+OBK1+003H,094H,00000000B+OPB1+003H
	BYTE	0A4H,00000000B+OBK1+001H,0E4H,00000000B+OBK1+001H
;
	BYTE	004H,10000000B+OBK1+00FH,008H,00000000B+OBK1+00FH	; 7
;
	BYTE	004H,10000000B+OBK1+00FH,008H,00000000B+OBK1+00FH	; 8
	BYTE	0CDH,00000000B+000H+CSLP
;
	BYTE	003H,10000000B+OPB1+004H				; 9
;
	BYTE	00EH,00000011B
	BYTE	01FH,010H+000H,00000000B+ONBK
;
	BYTE	02EH,00000001B
	BYTE	02FH,010H+000H,00000000B+ONBK
;
	BYTE	07EH,00000110B
	BYTE	07FH,0A0H+001H,00000000B+OCRC
	BYTE	08FH,000H+000H,00000000B+ONBK
	BYTE	08FH,080H+000H,00000000B+OCTR
;
	BYTE	0BEH,00000010B
	BYTE	0BFH,0A0H+001H,00000000B+OCLC
	BYTE	0BFH,080H+000H,00000000B+OCTL
;
	BYTE	0DEH,00000110B
	BYTE	0DFH,0A0H+001H,00000000B+OCRC
	BYTE	0EFH,080H+000H,00000000B+OCTR
;
	BYTE	0FEH,00001010B
	BYTE	0FFH,080H+000H,00000000B+OCTL
;
	BYTE	00DH,10000000B+000H+OSL0,0CDH,00000000B+000H+OCH0	; A
;
	BYTE	0CEH,00001001B
;
	BYTE	0DFH,070H+000H,00000000B+OCTR
	BYTE	0DEH,00001011B
;
	BYTE	0DDH,00000000B+000H+OSK0
	BYTE	0EFH,020H+000H,00000000B+ONBK
	BYTE	0FFH,020H+000H,00000000B+ONBK
;
	BYTE	0FEH,00000010B
	BYTE	0FFH,0A0H+001H,00000000B+OCLC
	BYTE	0FFH,070H+000H,00000000B+OCTL
;
	BYTE	05DH,10000000B+000H+SCOF				; B
;
	BYTE	0FDH
;
;
;
FXOD02	EQU	$		; Castle - 02 !
	BYTE	10011011B,00000111B
;
	BYTE	00FH,050H+002H,00000000B+OKID				; 0
	BYTE	00FH,060H+003H,00000000B+OKID
	BYTE	00FH,070H+004H,00000000B+OKID
;;;;;;;;	BYTE	005H,00000000B+OBK1+002H,006H,00000000B+OBK1+003H	; 0
;;;;;;;;	BYTE	007H,00000000B+OBK1+004H
;
	BYTE	0FFH,080H+000H,00000000B+OCTL
	BYTE	0FFH,000H+000H,00000000B+ONBK
	BYTE	0FEH,00000000B
;
	BYTE	027H,10000000B+OBK1+001H,065H,00000000B+OBK1+002H	; 1
	BYTE	075H,00000000B+000H+OSP0,071H,00000000B+000H+OBMS
	BYTE	0B7H,00000000B+OBK1+001H
;
	BYTE	00FH,080H+000H,10000000B+OCTR				; 2
	BYTE	01FH,0A0H+001H,00000000B+OCLC
	BYTE	01FH,080H+000H,00000000B+OCTL
;;;;;;;;	BYTE	008H,10000000B+OPB1+004H,018H,00000000B+OPB1+004H	; 2
;
	BYTE	01EH,00000100B
	BYTE	02FH,000H+000H,00000000B+ONBK
;
	BYTE	057H,00000000B+OBK1+00BH,0BBH,00000000B+000H+OSP0
;
	BYTE	017H,10000000B+000H+OSP0,027H,00000000B+OBK1+00AH	; 3
	BYTE	06FH,030H+000H,00000000B+ONBK
	BYTE	073H,00000000B+000H+OSP0,07BH,00000000B+000H+OSP0
	BYTE	0D7H,00000000B+000H+OSP0,0E7H,00000000B+OBK1+00AH
;
	BYTE	03BH,10000000B+000H+OSP0,097H,00000000B+000H+OSP0	; 4
;
	BYTE	0FEH,00001000B
	BYTE	0FFH,0A0H+001H,00000000B+OCRC
;
	BYTE	00FH,080H+000H,10000000B+OCTR				; 5
	BYTE	024H,00000000B+000H+OSP0
;
	BYTE	02EH,00000000B
	BYTE	02FH,010H+000H,00000000B+ONBK
;
	BYTE	03EH,01000000B
	BYTE	03FH,080H+000H,00000000B+OCTL
;
	BYTE	038H,00000000B+OPB1+004H
	BYTE	06FH,0F0H+000H,00000000B+OEW0
;;;;;	      BYTE     06FH,00000000B+OEW0+000H
	BYTE	09FH,0F0H+000H,00000000B+OEW0
;;;;;	      BYTE     09FH,00000000B+OEW0+000H
;
	BYTE	0BEH,01000011B
;
	BYTE	0C8H,00000000B+000H+OSP0
	BYTE	0CFH,080H+000H,00000000B+OCTR
;;;;;;;;	BYTE	0C9H,00000000B+OPB1+003H
;
	BYTE	0CEH,00000111B
	BYTE	0DFH,010H+000H,00000000B+ONBK
;
	BYTE	0FEH,00000111B
;
	BYTE	02EH,10000001B						; 6
	BYTE	02FH,010H+000H,00000000B+ONBK
	BYTE	02FH,0A0H+001H,00000000B+OCLC
	BYTE	02FH,080H+000H,00000000B+OCTL
;
	BYTE	066H,00000000B+OCO0+002H,06AH,00000000B+OCO0+002H
	BYTE	079H,00000000B+000H+OSP0
;
	BYTE	0BEH,00000000B
;
	BYTE	0BFH,0B0H+000H,00000000B+OCTL
	BYTE	0C8H,00000000B+OPB1+004H,0F8H,00000000B+OPB1+004H
	BYTE	0FFH,080H+000H,00000000B+OCTR
;
	BYTE	00FH,080H+000H,10000000B+OCTL				; 7
	BYTE	008H,00000000B+OPB1+004H
;
	BYTE	02EH,00000111B
	BYTE	03FH,010H+000H,00000000B+ONBK
	BYTE	03FH,080H+000H,00000000B+OCTR
;
	BYTE	07FH,0A0H+001H,00000000B+OCLC
	BYTE	07FH,080H+000H,00000000B+OCTL
	BYTE	07EH,00000011B
;
	BYTE	09EH,00000111B
	BYTE	09FH,0A0H+001H,00000000B+OCRC
	BYTE	0AFH,080H+000H,00000000B+OCTR
;
	BYTE	0BFH,0A0H+001H,00000000B+OCLC
	BYTE	0BFH,080H+000H,00000000B+OCTL
	BYTE	0BEH,00000011B
;
	BYTE	0DEH,00000111B
	BYTE	0DFH,0A0H+001H,00000000B+OCRC
	BYTE	0EFH,080H+000H,00000000B+OCTR
;
	BYTE	0FEH,00001010B
	BYTE	0FFH,020H+000H,00000000B+ONBK
	BYTE	0FFH,080H+000H,00000000B+OCTL
;
	BYTE	003H,10000000B+OBK0+005H,00DH,00000000B+OSL0+000H	; 8
	BYTE	0CDH,00000000B+OCH0+000H
;
	BYTE	0CEH,00001001B
	BYTE	0DFH,070H+000H,00000000B+OCTR
;
	BYTE	0DDH,00000000B+OSK0+000H
;
	BYTE	0DEH,00001011B
	BYTE	0EFH,020H+000H,00000000B+ONBK
;
	BYTE	0FEH,00000010B
	BYTE	0FFH,020H+000H,00000000B+ONBK
	BYTE	0FFH,0A0H+001H,00000000B+OCLC
	BYTE	0FFH,070H+000H,00000000B+OCTL
;
	BYTE	05DH,10000000B+000H+SCOF				; 9
;
	BYTE	0FDH
;
;
FXOD03	EQU	$		; Castle - 03 !
	BYTE	10011011B,00000111B
;
	BYTE	00FH,050H+002H,00000000B+OKID		; 0
	BYTE	00FH,060H+003H,00000000B+OKID
	BYTE	00FH,070H+004H,00000000B+OKID
;;;;;;;;	BYTE	005H,00000000B+OBK1+002H,006H,00000000B+OBK1+003H	; 0
;;;;;;;;	BYTE	007H,00000000B+OBK1+004H
;
	BYTE	0FFH,020H+000H,00000000B+ONBK
	BYTE	0FFH,080H+000H,00000000B+OCTL
	BYTE	0FEH,00000110B
;
	BYTE	00CH,10000000B+OHL0+001H				; 1
	BYTE	00CH,00000000B+OWT0+001H
	BYTE	02FH,080H+000H,00000000B+OCTR
	BYTE	039H,00000000B+000H+OSP0
	BYTE	04FH,080H+000H,00000000B+OCTL
	BYTE	05CH,00000000B+OHL0+001H
	BYTE	05CH,00000000B+OWT0+001H
	BYTE	07FH,080H+000H,00000000B+OCTR
	BYTE	089H,00000000B+000H+OSP0
	BYTE	09FH,080H+000H,00000000B+OCTL
	BYTE	0ACH,00000000B+OHL0+001H
	BYTE	0ACH,00000000B+OWT0+001H
	BYTE	0CFH,080H+000H,00000000B+OCTR
	BYTE	0D9H,00000000B+000H+OSP0
	BYTE	0EFH,080H+000H,00000000B+OCTL
	BYTE	0FCH,00000000B+OHL0+001H
	BYTE	0FCH,00000000B+OWT0+001H
;
	BYTE	01FH,080H+000H,10000000B+OCTR				; 2
	BYTE	02EH,00000011B
	BYTE	03FH,010H+000H,00000000B+ONBK
	BYTE	03FH,0A0H+001H,00000000B+OCLC
	BYTE	03FH,080H+000H,00000000B+OCTL
;
	BYTE	0A7H,00000000B+000H+OBCO,0B7H,00000000B+000H+OBMS
	BYTE	0C7H,00000000B+000H+OBCO
;
	BYTE	0DFH,020H+000H,00000000B+ONBK
	BYTE	0DFH,0B0H+000H,00000000B+OCTL
;
	BYTE	0DEH,00001010B
;
	BYTE	0FEH,00000010B
;
	BYTE	00FH,0B0H+000H,10000000B+OCTR				; 3
	BYTE	04EH,00000011B
	BYTE	05FH,010H+000H,00000000B+ONBK
;
;;;;;;;;	BYTE	05AH,00000000B+OBK1+002H
	BYTE	05FH,0A0H+002H,00000000B+ONBK
	BYTE	063H,00000000B+000H+OSP0
	BYTE	069H,00000000B+000H+OSP0
;
	BYTE	07EH,00000010B
	BYTE	07FH,020H+000H,00000000B+ONBK
;
	BYTE	0EEH,00000011B
;
	BYTE	0FFH,010H+000H,00000000B+ONBK
	BYTE	0FFH,0A0H+002H,00000000B+ONBK
;;;;;;;;	BYTE	0FAH,00000000B+OBK1+002H
;
	BYTE	003H,10000000B+000H+OSP0,009H,00000000B+000H+OSP0	; 4
;
	BYTE	01EH,00000010B
	BYTE	01FH,020H+000H,00000000B+ONBK
;
	BYTE	0EEH,00000011B
	BYTE	0FFH,010H+000H,00000000B+ONBK
;
	BYTE	0FFH,0A0H+002H,00000000B+ONBK
;;;;;;;;	BYTE	0FAH,00000000B+OBK1+002H
;
	BYTE	003H,10000000B+000H+OSP0,009H,00000000B+000H+OSP0	; 5
	BYTE	014H,00000000B+OCO0+002H
;
	BYTE	01EH,00000010B
	BYTE	01FH,020H+000H,00000000B+ONBK
;
	BYTE	07FH,0B0H+000H,00000000B+OCTL
	BYTE	07EH,00001010B
;
	BYTE	09EH,00000111B
	BYTE	0AFH,020H+000H,00000000B+ONBK
	BYTE	0AFH,080H+000H,00000000B+OCTR
;
	BYTE	0FEH,00001010B
	BYTE	0FFH,020H+000H,00000000B+ONBK
	BYTE	0FFH,080H+000H,00000000B+OCTL
;
	BYTE	02EH,10000110B						; 6
	BYTE	03FH,080H+000H,00000000B+OCTR
;
	BYTE	05EH,00001010B
	BYTE	05FH,080H+000H,00000000B+OCTL
;
	BYTE	08EH,00000110B
	BYTE	09FH,080H+000H,00000000B+OCTR
;
	BYTE	0BEH,00001010B
	BYTE	0BFH,080H+000H,00000000B+OCTL
;
	BYTE	0EEH,00000111B
	BYTE	0EFH,080H+000H,00000000B+OCTR
	BYTE	0FFH,010H+000H,00000000B+ONBK
;
	BYTE	03EH,10000011B						; 7
	BYTE	03FH,0A0H+001H,00000000B+OCLC
	BYTE	03FH,080H+000H,00000000B+OCTL
;
	BYTE	05EH,00000111B
	BYTE	05FH,0A0H+001H,00000000B+OCRC
	BYTE	06FH,080H+000H,00000000B+OCTR
;
	BYTE	0FEH,00001010B
	BYTE	0FFH,020H+000H,00000000B+ONBK
	BYTE	0FFH,080H+000H,00000000B+OCTL
;
	BYTE	00DH,10000000B+000H+OSL0,041H,00000000B+OPB0+002H	; 8
	BYTE	051H,00000000B+OPB0+002H,0CDH,00000000B+000H+OCH0
;
	BYTE	0CEH,00001001B
	BYTE	0DFH,070H+000H,00000000B+OCTR
;
	BYTE	0DEH,00001011B
;
	BYTE	0DDH,00000000B+000H+OSK0
	BYTE	0EFH,020H+000H,00000000B+ONBK
;
	BYTE	0FEH,00000010B
	BYTE	0FFH,020H+000H,00000000B+ONBK
	BYTE	0FFH,0A0H+001H,00000000B+OCLC
	BYTE	0FFH,070H+000H,00000000B+OCTL
;
	BYTE	05DH,10000000B+000H+SCOF				; 9
;
	BYTE	0FDH
;
;
;
FXOD04	EQU	$		; Castle - 04 !
	BYTE	01011011B,00000111B
;
	BYTE	00FH,050H+002H,00000000B+OKID		; 0
	BYTE	00FH,060H+003H,00000000B+OKID
	BYTE	00FH,070H+004H,00000000B+OKID
;;;;;;;;	BYTE	005H,00000000B+OBK1+002H,006H,00000000B+OBK1+003H	; 0
;;;;;;;;	BYTE	007H,00000000B+OBK1+004H
;
	BYTE	0FEH,00001010B
	BYTE	0FFH,020H+000H,00000000B+ONBK
	BYTE	0FFH,080H+000H,00000000B+OCTL
;
	BYTE	0AEH,10000110B						; 1
	BYTE	0BFH,080H+000H,00000000B+OCTR
;
	BYTE	0BEH,00000111B
	BYTE	0CFH,020H+000H,00000000B+ONBK
;
	BYTE	0FFH,020H+000H,00000000B+ONBK
	BYTE	0FFH,0A0H+001H,00000000B+OCLC
	BYTE	0FFH,080H+000H,00000000B+OCTL
DA003	EQU	$
	BYTE	0FEH,00000010B
;
	BYTE	00DH,002H						; 2
;
	BYTE	027H,00000000B+OBK1+002H,046H,00000000B+OPB1+001H
	BYTE	055H,00000000B+OPB1+002H
;
	BYTE	05EH,00001110B
	BYTE	064H,00000000B+OBK1+009H,065H,00000000B+OBK1+009H
	BYTE	066H,00000000B+OBK1+009H,067H,00000000B+OBK1+009H
;
	BYTE	004H,10000000B+OPB1+003H				; 3
	BYTE	01EH,00000010B
	BYTE	014H,00000000B+OPB1+003H
;
	BYTE	068H,00000000B+OBK1+00CH,074H,00000000B+OBK1+00AH
	BYTE	07DH,00000000B+000H+CSLP
;
	BYTE	05EH,10001110B						; 4
	BYTE	064H,00000000B+OBK1+009H,065H,00000000B+OBK1+009H
	BYTE	066H,00000000B+OBK1+009H,067H,00000000B+OBK1+009H
;
	BYTE	07DH,00000000B+000H+CSLP
;
	BYTE	004H,10000000B+OBK1+007H,005H,00000000B+OBK1+007H	; 5
	BYTE	006H,00000000B+OBK1+007H,007H,00000000B+OBK1+007H
	BYTE	07EH,00000010B
;
	BYTE	084H,00000000B+OPB1+002H,094H,00000000B+OPB1+001H
	BYTE	0A4H,00000000B+OBK1+001H,0BDH,00000000B+000H+CSLP
;
	BYTE	0CEH,00000110B
	BYTE	0CFH,0A0H+001H,00000000B+OCRC
	BYTE	0DFH,080H+000H,00000000B+OCTR
;
	BYTE	0FFH,0A0H+001H,00000000B+OCLC
	BYTE	0FFH,080H+000H,00000000B+OCTL
DA004	EQU	$
	BYTE	0FEH,00000010B
;
	BYTE	00DH,006H						; 6
;
	BYTE	034H,00000000B+OBK1+001H
;
	BYTE	03EH,00001010B
	BYTE	03FH,0B0H+000H,00000000B+OCTL
;
	BYTE	064H,00000000B+OBK1+002H,075H,00000000B+000H+OSP0
	BYTE	07BH,00000000B+OPB1+001H,0A4H,00000000B+OBK1+003H
;
	BYTE	0AEH,00000010B
	BYTE	0BFH,0B0H+000H,00000000B+OCTR
;
	BYTE	0DEH,00001110B
	BYTE	0E4H,00000000B+OBK1+005H,0E5H,00000000B+OBK1+005H
	BYTE	0E6H,00000000B+OBK1+005H,0E7H,00000000B+OBK1+005H
;
	BYTE	03EH,10000010B						; 7
;
	BYTE	064H,00000000B+OBK1+002H,078H,00000000B+OBK1+002H
	BYTE	0B4H,00000000B+OBK1+006H,0C8H,00000000B+OBK1+006H
	BYTE	0DDH,00000000B+000H+CSLP
;
	BYTE	044H,10000000B+OBK1+002H,058H,00000000B+OBK1+002H	; 8
	BYTE	094H,00000000B+OPB1+003H,0A4H,00000000B+OBK1+00EH
	BYTE	0BAH,00000000B+OBK1+000H,0C9H,00000000B+OPB1+001H
;
	BYTE	0CEH,00000110B
	BYTE	0CFH,0A0H+001H,00000000B+OCRC
	BYTE	0DFH,080H+000H,00000000B+OCTR
;
	BYTE	0DDH,00000000B+000H+CSLP
;
	BYTE	0CEH,10000110B						; 9
;
	BYTE	0DDH,00000000B+000H+CSLP
;
	BYTE	0FEH,00000010B
	BYTE	0FFH,0A0H+001H,00000000B+OCLC
	BYTE	0FFH,080H+000H,00000000B+OCTL
;
	BYTE	02EH,10000110B						; A
	BYTE	02FH,0A0H+001H,00000000B+OCRC
	BYTE	03FH,080H+000H,00000000B+OCTR
;
	BYTE	05EH,00000010B
	BYTE	05FH,0A0H+001H,00000000B+OCLC
	BYTE	05FH,080H+000H,00000000B+OCTL
;
	BYTE	07EH,00000110B
	BYTE	07FH,0A0H+001H,00000000B+OCRC
	BYTE	08FH,080H+000H,00000000B+OCTR
;
	BYTE	0FEH,00000010B
	BYTE	0FFH,0A0H+001H,00000000B+OCLC
	BYTE	0FFH,080H+000H,00000000B+OCTL
;
	BYTE	01EH,10000110B						; B
	BYTE	01FH,0A0H+001H,00000000B+OCRC
	BYTE	02FH,080H+000H,00000000B+OCTR
;
	BYTE	03EH,00000010B
	BYTE	03FH,0A0H+001H,00000000B+OCLC
	BYTE	03FH,080H+000H,00000000B+OCTL
;
	BYTE	05EH,00000110B
	BYTE	05FH,0A0H+001H,00000000B+OCRC
	BYTE	06FH,080H+000H,00000000B+OCTR
;
	BYTE	07EH,00000010B
	BYTE	07FH,0A0H+001H,00000000B+OCLC
	BYTE	07FH,080H+000H,00000000B+OCTL
;
	BYTE	09EH,00000110B
	BYTE	09FH,0A0H+001H,00000000B+OCRC
	BYTE	0AFH,080H+000H,00000000B+OCTR
;
	BYTE	0FEH,00001010B
	BYTE	0FFH,080H+000H,00000000B+OCTL
;
	BYTE	00DH,10000000B+000H+OSL0,0CDH,00000000B+000H+OCH0	; C
;
	BYTE	0CEH,00001001B
;
	BYTE	0DEH,00001011B
;
	BYTE	0DDH,00000000B+000H+OSK0
	BYTE	0DFH,070H+000H,00000000B+OCTR
	BYTE	0EFH,020H+000H,00000000B+ONBK
;
	BYTE	0FEH,00000010B
	BYTE	0FFH,020H+000H,00000000B+ONBK
	BYTE	0FFH,0A0H+001H,00000000B+OCLC
	BYTE	0FFH,070H+000H,00000000B+OCTL
;
	BYTE	05DH,10000000B+000H+SCOF				; D
;
	BYTE	0FDH
;
;
;
FXOD05	EQU	$		; Castle - 05 !
	BYTE	01011011B,00000110B
;
	BYTE	00FH,050H+002H,00000000B+OKID		; 0
	BYTE	00FH,060H+003H,00000000B+OKID
	BYTE	00FH,070H+004H,00000000B+OKID
;;;;;;;;	BYTE	005H,00000000B+OBK1+002H,006H,00000000B+OBK1+003H	; 0
;;;;;;;;	BYTE	007H,00000000B+OBK1+004H
;
	BYTE	05FH,080H+000H,00000000B+OCTL
	BYTE	05EH,00001010B
;
	BYTE	0BFH,0B0H+000H,00000000B+OCTR
DA005	EQU	$
	BYTE	0BEH,00000010B
;
	BYTE	00DH,001H						; 1
;
	BYTE	02FH,0B0H+000H,00000000B+OCTL
	BYTE	039H,00000000B+OCM2+003H
	BYTE	05FH,0B0H+000H,00000000B+OCTR
;
	BYTE	00DH,003H						; 3
;
	BYTE	02FH,0B0H+000H,00000000B+OCTL
	BYTE	039H,00000000B+OCM0+003H,04DH,00000000B+000H+CSLP
	BYTE	05FH,0B0H+000H,00000000B+OCTR
;
	BYTE	0DEH,00000110B
	BYTE	0DFH,0A0H+001H,00000000B+OCRC
	BYTE	0EFH,080H+000H,00000000B+OCTR
;
	BYTE	01FH,080H+000H,10000000B+OCTL				; 4
	BYTE	01EH,00001010B
;
	BYTE	0AEH,00000110B
	BYTE	0BFH,080H+000H,00000000B+OCTR
;
	BYTE	0C4H,00000000B+OBK1+003H
;
	BYTE	00FH,080H+000H,10000000B+OCTL				; 5
	BYTE	016H,00000000B+OCM0+006H
	BYTE	03FH,080H+000H,00000000B+OCTR
	BYTE	09FH,080H+000H,00000000B+OCTL
	BYTE	0A5H,00000000B+OCM2+007H
	BYTE	0CFH,080H+000H,00000000B+OCTR
;
	BYTE	0FFH,0A0H+001H,00000000B+OCLC
	BYTE	0FFH,080H+000H,00000000B+OCTL
	BYTE	0FEH,00000010B
;
	BYTE	0FEH,10000010B						; 6
;
DA006	EQU	$
	BYTE	00DH,007H						; 7
;
	BYTE	02FH,0B0H+000H,00000000B+OCTL
	BYTE	039H,00000000B+OCM2+003H
	BYTE	05FH,0B0H+000H,00000000B+OCTR
	BYTE	09FH,0B0H+000H,00000000B+OCTL
	BYTE	0A8H,00000000B+OCM2+004H
	BYTE	0CFH,0B0H+000H,00000000B+OCTR
	BYTE	0EDH,00000000B+000H+CSLP
;
	BYTE	03FH,0B0H+000H,10000000B+OCTL				; 8
	BYTE	049H,00000000B+OCM0+003H
	BYTE	06FH,0B0H+000H,00000000B+OCTR
	BYTE	0DFH,0B0H+000H,00000000B+OCTL
	BYTE	0E8H,00000000B+OCM2+004H
;
	BYTE	0FEH,00001010B
;
	BYTE	02EH,10000010B						; 9
	BYTE	02FH,0B0H+000H,00000000B+OCTR
;
	BYTE	067H,00000000B+000H+OSCO
	BYTE	084H,00000000B+OCM0+002H,087H,00000000B+OBK1+001H
;
	BYTE	00DH,00BH						; B
;
	BYTE	0FEH,00000010B
;
DA007	EQU	$
	BYTE	00DH,00CH						; C
;
	BYTE	02FH,0B0H+000H,00000000B+OCTL
	BYTE	039H,00000000B+OCM2+003H
;
	BYTE	05EH,00000110B
	BYTE	05FH,0A0H+001H,00000000B+OCRC
	BYTE	05FH,0B0H+000H,00000000B+OCTR
	BYTE	06FH,080H+000H,00000000B+OCTR
;
	BYTE	0BFH,080H+000H,00000000B+OCTL
	BYTE	0C6H,00000000B+OCM2+006H
	BYTE	0EFH,080H+000H,00000000B+OCTR
;
	BYTE	03FH,080H+000H,10000000B+OCTL				; D
	BYTE	045H,00000000B+OCM0+007H
	BYTE	06FH,080H+000H,00000000B+OCTR
;
	BYTE	0BFH,080H+000H,00000000B+OCTL
	BYTE	0BEH,00001010B
;
	BYTE	0DDH,00000000B+000H+JFST
;
	BYTE	0FEH,00000110B
;
	BYTE	00FH,080H+000H,10000000B+OCTR				; E
	BYTE	03DH,00000000B+000H+CSLP
	BYTE	03FH,080H+000H,00000000B+OCTL
	BYTE	046H,00000000B+OCM0+006H
	BYTE	06FH,080H+000H,00000000B+OCTR
	BYTE	0ADH,00000000B+000H+EXOF
;
	BYTE	0FFH,0A0H+001H,10000000B+OCLC
	BYTE	0FFH,080H+000H,00000000B+OCTL
	BYTE	0FEH,00000010B						; F
;
	BYTE	02FH,0B0H+000H,10000000B+OCTL				; 10
	BYTE	039H,00000000B+OCM2+003H
	BYTE	05FH,0B0H+000H,00000000B+OCTR
	BYTE	09FH,0B0H+000H,00000000B+OCTL
	BYTE	0A9H,00000000B+OCM0+003H
	BYTE	0CFH,0B0H+000H,00000000B+OCTR
;
	BYTE	04EH,10001010B						;11
	BYTE	04FH,0B0H+000H,00000000B+OCTL
;
	BYTE	09EH,00000111B
	BYTE	0AFH,020H+000H,00000000B+ONBK
	BYTE	0AFH,080H+000H,00000000B+OCTR
;
	BYTE	0FEH,00001010B
	BYTE	0FFH,020H+000H,00000000B+ONBK
	BYTE	0FFH,080H+000H,00000000B+OCTL
;
	BYTE	00DH,10000000B+000H+OSL0,0CDH,00000000B+000H+OCH0	;12
;
	BYTE	0CEH,00001001B
	BYTE	0DFH,070H+000H,00000000B+OCTR
;
	BYTE	0DEH,00001011B
;
	BYTE	0DDH,00000000B+000H+OSK0
	BYTE	0EFH,020H+000H,00000000B+ONBK
;
	BYTE	0FEH,00000010B
	BYTE	0FFH,020H+000H,00000000B+ONBK
;;;;K;;;;	BYTE	0FFH,0A0H+001H,00000000B+OCLC
;;;;K;;;;	BYTE	0FFH,070H+000H,00000000B+OCTL
;
	BYTE	05DH,10000000B+000H+SCOF				;13
;
	BYTE	0FDH
;
;
;#####################################################################
;#	 Fix obstacle out pos data  ( Ground )			     #
;#####################################################################
FXOD10	EQU	$		; Ground - 0 !
	BYTE	10010100B,00010001B
;
	 BYTE	  00FH,0F0H+006H,00000000B+OCS0				; 0
;;;;;	      BYTE     00FH,00000000B+OCM0+006H
	BYTE	0FEH,00010000B
;
	BYTE	028H,10000000B+OLD0+004H,065H,00000000B+OLD0+005H	; 1
	BYTE	0EBH,00000000B+OLD0+002H,0FAH,00000000B+OCO0+001H
;
	BYTE	04AH,10000000B+OLD0+006H,054H,00000000B+OCO0+000H	; 2
	BYTE	0A4H,00000000B+OCO0+002H,0B7H,00000000B+OLD0+003H
	BYTE	0E9H,00000000B+OLD0+009H,0F5H,00000000B+OLD0+005H
;
	BYTE	011H,10000000B+000H+OBMS,047H,00000000B+OCO0+002H	; 3
	BYTE	071H,00000000B+OLD0+003H,080H,00000000B+OCO0+001H
;
	BYTE	015H,10000000B+OLD0+002H,01BH,00000000B+OLD0+00FH	; 4
	BYTE	024H,00000000B+OCO0+000H,055H,00000000B+OLD0+002H
	BYTE	064H,00000000B+OCO0+000H,095H,00000000B+OLD0+002H
	BYTE	0A4H,00000000B+OCO0+000H,0D2H,00000000B+OLD0+002H
	BYTE	0E1H,00000000B+OCO0+000H
;
	BYTE	013H,10000000B+OCO0+000H,02CH,00000000B+OEP0+007H	; 5
	BYTE	02FH,0F0H+002H,00000000B+OLW0
;;;;;	      BYTE     02FH,00000000B+OLW0+002H
	BYTE	049H,00000000B+OLD0+003H
	BYTE	083H,00000000B+OCO0+000H
	BYTE	09FH,0F0H+004H,00000000B+OLW0
;;;;;	      BYTE     09FH,00000000B+OLW0+004H
	BYTE	0A3H,00000000B+OCO0+000H
;
	BYTE	017H,10000000B+OLD0+002H,083H,00000000B+OLD0+003H	; 6
	BYTE	092H,00000000B+OCO0+001H,0B9H,00000000B+OLD0+004H
	BYTE	0C5H,00000000B+OLD0+002H,0C8H,00000000B+OCO0+000H
	BYTE	0D4H,00000000B+OCO0+000H
;
	BYTE	04BH,10000000B+OLD0+002H,078H,00000000B+OLD0+00BH	; 7
;
	BYTE	09CH,10000000B+OEP0+004H				; 8
	BYTE	09FH,0F0H+001H,00000000B+OLW0
;;;;;	      BYTE     09FH,00000000B+OLW0+001H
	BYTE	0DFH,0F0H+004H,00000000B+OLW0
;;;;;	      BYTE     0DFH,00000000B+OLW0+004H
	BYTE	0FEH,00010001B
;
	BYTE	07DH,10000000B+000H+OPL0				; 9
;
;;K;;	BYTE	09EH,01000010B
;
	BYTE	09FH,0F0H+000H,00000000B+OCS0
;;;;;	      BYTE     0CFH,00000000B+OCS0+000H
;
	BYTE	09DH,10000000B+000H+SCOF
;
	BYTE	0FDH
;
;
;
FXOD11	EQU	$		; Ground - 1 !	 (SHOUGAIBUTSU DATA)
	BYTE	10010000B,10110001B
;
	BYTE	00FH,0F0H+006H,00000000B+OCS0				; 0
;;;;;	      BYTE     00FH,00000000B+OST0+006H
;
	BYTE	029H,10000000B+OGN0+001H				; 1
;
;;K;;	BYTE	07EH,01000010B
;
;;K;;	BYTE	0FEH,01000000B
;
	BYTE	028H,10000000B+OGN0+002H				; 2
;
;;K;;	BYTE	04EH,01000010B
;
;;K;;	BYTE	02EH,11000000B						; 3
;
	BYTE	057H,10000000B+OCM2+003H				; 3
	BYTE	0C3H,00000000B+OBK0+005H,0C7H,00000000B+OBK0+007H
;
	BYTE	023H,10000000B+OBBM+000H,033H,00000000B+OBK0+000H	; 4
	BYTE	05CH,00000000B+OHL0+001H,077H,00000000B+OPB1+003H
	BYTE	088H,00000000B+OPB1+002H,099H,00000000B+OPB1+001H
	BYTE	0AAH,00000000B+OPB1+000H,0BCH,00000000B+OHL0+001H
;
;;K;;	BYTE	0EEH,01000010B
;
;;K;;	BYTE	04EH,11000000B						; 5
;
	BYTE	069H,10000000B+OGN0+001H				; 5
;
;;K;;	BYTE	07EH,01000010B
;;K;;	BYTE	0DEH,01000000B
;
	BYTE	0F8H,00000000B+OPB1+002H
;
;;K;;	BYTE	00EH,11000010B						; 6
;
;;K;;	BYTE	0AEH,01000000B
;
	BYTE	0D7H,10000000B+OPB1+003H				; 6
;
	BYTE	0E7H,00000000B+OPB1+003H
;
	BYTE	033H,10000000B+OBK0+007H,037H,00000000B+OBK0+007H	; 7
	BYTE	043H,00000000B+000H+OBBM
	BYTE	0CCH,00000000B+OHL0+001H,0E7H,00000000B+OCM2+003H
;
	BYTE	00CH,10000000B+OHL0+001H				; 8
;
;;K;;	BYTE	03EH,01000010B
;
	BYTE	00DH,00AH						; A
;
;;K;;	BYTE	05EH,01000000B
;
	BYTE	088H,00000000B+OCM2+002H
;
;;K;;	BYTE	0BEH,01000010B
;
	BYTE	0E7H,10000000B+000H+ORBC				; B
;
;;K;;	BYTE	0FEH,01000000B
;
	BYTE	039H,10000000B+OPB1+001H				; C
;
	BYTE	04EH,00000000B
;
	BYTE	069H,00000000B+OPB1+000H,087H,00000000B+OPB1+000H
	BYTE	0A5H,00000000B+OPB1+000H,0C3H,00000000B+OBK1+001H
;
	BYTE	0FEH,00110001B
;
	BYTE	06DH,10000000B+000H+OPL0				; D
;
;;K;;	BYTE	0BEH,01000010B
;
	BYTE	08FH,0F0H+000H,00000000B+OCS0
;;;;;	      BYTE     0EFH,00000000B+OCS0+000H
;
	BYTE	08DH,10000000B+000H+SCOF
;
	BYTE	0FDH
;
;
FXOD12	EQU	$		; Ground - 2 !
	BYTE	01010010B,00100001B
;
	BYTE	00FH,0F0H+000H,00000000B+OCS0				; 0
;;;;;	      BYTE     00FH,00000000B+OCS0+000H
;
	BYTE	06EH,01000000B
;
	BYTE	058H,10000000B+OCM2+002H,093H,00000000B+OBCO+000H	; 1
	BYTE	097H,00000000B+OBMS+000H
;
	BYTE	00CH,10000000B+OHL0+001H				; 2
	BYTE	097H,00000000B+OCO0+000H,0A6H,00000000B+OCO0+001H
	BYTE	0C7H,00000000B+OCO0+000H
;
	BYTE	00DH,00000000B+000H+004H				; 4
;
	BYTE	003H,00000000B+OBCO+000H,007H,00000000B+OBCO+000H
	BYTE	023H,00000000B+OBCO+000H,027H,00000000B+OBCO+000H
	BYTE	0ECH,00000000B+OHL0+003H
;
	BYTE	0ACH,10000000B+OBC2+003H,0C3H,00000000B+000H+OSMS	; 5
;
	BYTE	078H,10000000B+OPB1+002H,094H,00000000B+OCO0+003H	; 6
;
	BYTE	047H,10000000B+OCM2+003H,074H,00000000B+OCO0+003H	; 7
;
	BYTE	047H,10000000B+OCM0+003H,074H,00000000B+OCO0+003H	; 8
;
	BYTE	02CH,10000000B+OBC2+001H,04CH,00000000B+OBC1+003H	; 9
	BYTE	047H,00000000B+OBMS+000H,057H,00000000B+OBK0+001H
	BYTE	05CH,00000000B+OHL0+001H,07CH,00000000B+OBC2+002H
;
	BYTE	039H,10000000B+OCM2+001H,0ECH,00000000B+OHL0+002H	; A
;
	BYTE	04CH,10000000B+OHL0+001H,0D8H,00000000B+OPB1+002H	; B
	BYTE	0ECH,00000000B+OHL0+001H
;
	BYTE	00DH,00DH						; D
	BYTE	00FH,0F0H+008H,00000000B+OST0
;;;;;	      BYTE     00FH,00000000B+OST0+008H
	BYTE	0C7H,00000000B+000H+ORBC
	BYTE	0EDH,00000000B+000H+EXOF
;
	BYTE	01DH,10000000B+000H+OPL0				; E
	BYTE	05FH,0F0H+006H,00000000B+OCS0
;;;;;	      BYTE     05FH,00000000B+OCS0+006H
;
	BYTE	01DH,10000000B+000H+SCOF
;
	BYTE	0FDH
;
;
FXOD13	EQU	$		; Ground - 3 !
	BYTE	01010100B,00100001B
;
	BYTE	00FH,0F0H+006H,00000000B+OCS0				;0
;;;;;	      BYTE     00FH,00000000B+OCS0+006H
	BYTE	0A7H,00000000B+OBK0+002H
;
	BYTE	037H,10000000B+OCM0+003H,073H,00000000B+OBK0+000H	; 1
	BYTE	083H,00000000B+ORBC+000H,087H,00000000B+OSCO+000H
	BYTE	093H,00000000B+OBK0+000H,0C7H,00000000B+OCM2+003H
;
	BYTE	004H,10000000B+OCM2+001H,006H,00000000B+OBK1+001H	; 2
	BYTE	039H,00000000B+OCM2+001H,059H,00000000B+OCM2+001H
	BYTE	0E7H,00000000B+OCM2+003H
;
	BYTE	037H,10000000B+OBK0+000H,047H,00000000B+000H+OBBM	; 3
	BYTE	086H,00000000B+OCM0+004H,0E5H,00000000B+OCM2+001H
	BYTE	0E7H,00000000B+OBK1+001H
;
	BYTE	033H,10000000B+OBK0+004H,039H,00000000B+OCM2+001H	; 4
	BYTE	0A9H,00000000B+OCM2+001H,0D3H,00000000B+OBK0+003H
;
	BYTE	008H,10000000B+OCM2+002H,013H,00000000B+000H+OBBW	; 5
	BYTE	027H,00000000B+OSCO+000H
	BYTE	049H,00000000B+OCM2+001H,075H,00000000B+OCM2+005H
	BYTE	0E8H,00000000B+OCM2+002H
;
	BYTE	067H,10000000B+OCM2+003H,099H,00000000B+OCM2+001H	; 6
	BYTE	0E7H,00000000B+OBK0+000H,0F4H,00000000B+OCM2+002H
	BYTE	0F7H,00000000B+OBK1+001H
;
	BYTE	017H,10000000B+OBK0+000H,033H,00000000B+OBK0+000H	; 7
	BYTE	039H,00000000B+OCM2+001H,073H,00000000B+OBK0+008H
	BYTE	0BCH,00000000B+OHL0+005H
;
	BYTE	039H,10000000B+OCM2+001H,079H,00000000B+OCM2+001H	; 8
	BYTE	0A6H,00000000B+OBK0+001H,0C3H,00000000B+000H+OBBS
	BYTE	0D3H,00000000B+OBK0+000H,0DCH,00000000B+OHL0+000H
	BYTE	0FCH,00000000B+OHL0+000H
;
	BYTE	007H,10000000B+OBK0+002H,013H,00000000B+OBK0+001H	; 9
	BYTE	05FH,0F0H+002H,00000000B+OST0
;;;;;	      BYTE     05FH,00000000B+OST0+002H
	BYTE	08CH,00000000B+OHL0+000H
	BYTE	098H,00000000B+OCM0+002H,0C7H,00000000B+OPB1+003H
	BYTE	0D9H,00000000B+OPB1+001H
;
	BYTE	003H,10000000B+OBK0+002H,007H,00000000B+OBK0+002H	; A
	BYTE	074H,00000000B+OCM2+002H
	BYTE	077H,00000000B+OBK1+001H,0E7H,00000000B+OCM2+003H
;
	BYTE	039H,10000000B+OCM2+001H,058H,00000000B+OCM2+002H	; B
	BYTE	077H,00000000B+OCM2+003H,0D8H,00000000B+OCM2+002H
;
	BYTE	07FH,0F0H+006H,10000000B+OST0				; C
;;;;;	      BYTE     07FH,10000000B+OST0+001H
	BYTE	097H,00000000B+OCM2+003H
	BYTE	0B6H,00000000B+OPB1+004H,0C5H,00000000B+OPB1+005H
	BYTE	0D4H,00000000B+OPB1+006H,0E3H,00000000B+OPB1+007H
	BYTE	0F3H,00000000B+OPB1+007H
;
	BYTE	08DH,10000000B+000H+OPL0				; D
	BYTE	0CFH,0F0H+006H,00000000B+OCS0
;;;;;	      BYTE     0CFH,00000000B+OCS0+006H
;
	BYTE	09DH,10000000B+000H+SCOF
;
	BYTE	0FDH
;
;
FXOD14	EQU	$		; Ground - 4 !			 / W 3 - 1 /
	BYTE	01010010B,00110001B
;
	BYTE	00FH,0F0H+000H,00000000B+OCS0				; 0
;;;;;	      BYTE     00FH,00000000B+OCS0+000H
;
	BYTE	06EH,01100110B
;
	BYTE	007H,10000000B+OBCO+000H,036H,00000000B+OBCO+000H	; 1
	BYTE	066H,00000000B+OBMS+000H,0A7H,00000000B+OBK0+002H
;
	BYTE	008H,10000000B+OCM2+002H,067H,00000000B+OCM0+003H	; 2
	BYTE	0DCH,00000000B+OHL0+002H
;
	BYTE	098H,10000000B+OCM2+002H,0D7H,00000000B+OBK0+000H	; 3
;
	BYTE	039H,10000000B+OCM2+001H				; 4
	BYTE	09FH,0F0H+003H,00000000B+OST0
;;;;;	      BYTE     09FH,00000000B+OST0+003H
	BYTE	0DCH,00000000B+OBG0+007H,0DCH,00000000B+OWT0+007H
;
	BYTE	023H,10000000B+000H+OSMS,057H,00000000B+OPB1+004H	; 5
	BYTE	06CH,00000000B+OWT0+001H
	BYTE	087H,00000000B+OPB1+003H,099H,00000000B+OPB1+001H
	BYTE	0A3H,00000000B+OBBS+000H,0B3H,00000000B+OBK0+001H
;
	BYTE	077H,10000000B+OCM2+003H,0F3H,00000000B+OBK0+001H	; 6
	BYTE	0F7H,00000000B+OBK0+00AH
;
	BYTE	013H,10000000B+OBCO+000H,023H,00000000B+OBK0+002H	; 7
	BYTE	053H,00000000B+OBMS+000H,063H,00000000B+OBK0+002H
	BYTE	0E9H,00000000B+OBOD+000H
;
	BYTE	00CH,10000000B+OHL0+003H,013H,00000000B+OBK0+001H	; 8
	BYTE	016H,00000000B+OBK0+002H,033H,00000000B+OBBW+000H
	BYTE	08FH,0F0H+005H,00000000B+OST0
	BYTE	08FH,090H+000H,00000000B+BGCL
;;;;;	      BYTE     08FH,00000000B+OST0+005H
	BYTE	0ECH,00000000B+OHL0+001H
;
	BYTE	063H,10000000B+OBK0+000H,067H,00000000B+OBK0+000H	; 9
	BYTE	073H,00000000B+OBCO+000H,077H,00000000B+OBCO+000H
	BYTE	083H,00000000B+OBK0+000H,087H,00000000B+OBK0+000H
	BYTE	0B3H,00000000B+OBK0+000H,0B7H,00000000B+OBK0+000H
	BYTE	0C3H,00000000B+OBCO+000H,0C7H,00000000B+OBMS+000H
	BYTE	0D3H,00000000B+OBK0+000H,0D7H,00000000B+OBK0+000H
;
	BYTE	067H,10000000B+OBK0+000H,077H,00000000B+000H+ORBC	; A
	BYTE	087H,00000000B+OBK0+002H,0E8H,00000000B+OPB1+002H
	BYTE	0F5H,00000000B+OPB1+005H
;
	BYTE	01CH,10000000B+OHL0+002H				; B
	BYTE	07FH,0F0H+008H,00000000B+OST0
;;;;;	      BYTE     07FH,00000000B+OST0+008H
;
	BYTE	08DH,10000000B+000H+OPL0				; C
	BYTE	0CFH,0F0H+006H,00000000B+OCS0
;;;;;	      BYTE     0CFH,00000000B+OCS0+006H
;
	BYTE	08DH,10000000B+000H+SCOF
;
	BYTE	0FDH							; end
;
;
FXOD15	EQU	$		; Ground - 5 !
	BYTE	 01010000B,00100001B
;
	BYTE	007H,10000000B+000H+OBCO,047H,00000000B+OBK0+004H	; 1
	BYTE	057H,00000000B+000H+OBMS,063H,00000000B+000H+OBCO
	BYTE	077H,00000000B+000H+OBCO,0C9H,00000000B+OCM2+001H
;
	BYTE	068H,10000000B+OCM2+002H,0E7H,00000000B+OCM2+003H	; 2
;
	BYTE	097H,10000000B+OCM0+003H				; 3
;
	BYTE	006H,10000000B+000H+OSMS				; 4
	BYTE	05CH,00000000B+OHL0+001H,0D7H,00000000B+OBK0+002H
	BYTE	0E7H,00000000B+000H+OBMS
;
	BYTE	003H,10000000B+OBK0+007H,06CH,00000000B+OHL0+002H	; 5
	BYTE	0B3H,00000000B+OBK0+002H,0E3H,00000000B+000H+OBCO
	BYTE	0E7H,00000000B+000H+ORBC
;
	BYTE	047H,10000000B+OBK0+000H,057H,00000000B+000H+OBBS	; 6
	BYTE	0A7H,00000000B+000H+OBCO,0D3H,00000000B+000H+OBMS
	BYTE	0D7H,00000000B+000H+OBCO
;
	BYTE	007H,10000000B+000H+OBCO,067H,00000000B+OBK0+000H	; 7
	BYTE	093H,00000000B+OBK0+002H
;
	BYTE	003H,10000000B+OBK0+003H,01CH,00000000B+OBC1+001H	; 8
	BYTE	017H,00000000B+OBK0+001H
	BYTE	06FH,0F0H+003H,00000000B+OST0
;;;;;	      BYTE     06FH,00000000B+OST0+003H
	BYTE	0C7H,00000000B+OPB1+003H,0D8H,00000000B+OPB1+002H
	BYTE	0E9H,00000000B+OPB1+001H,0FAH,00000000B+OPB1+000H
;
;;;;;	      BYTE     04FH,10000000B+OST0+003H
	BYTE	04FH,0F0H+003H,10000000B+OST0				; 9
	BYTE	087H,00000000B+OPB1+003H
	BYTE	09CH,00000000B+OHL0+001H,0B7H,00000000B+OPB1+003H
	BYTE	0C8H,00000000B+OPB1+002H,0D9H,00000000B+OPB1+001H
	BYTE	0EAH,00000000B+OPB1+000H
;
	BYTE	039H,10000000B+OCM2+001H,087H,00000000B+OBK0+001H	; A
	BYTE	0A7H,00000000B+000H+OBCO,0B7H,00000000B+OBK0+000H
;
	BYTE	039H,10000000B+OCM2+001H				; B
	BYTE	05FH,0F0H+008H,00000000B+OST0
;;;;;	     BYTE    05FH,00000000B+OST0+008H  ; B
;
	BYTE	06DH,10000000B+000H+OPL0				; C
	BYTE	0AFH,0F0H+006H,00000000B+OCS0
;;;;;	     BYTE    0AFH,00000000B+OCS0+006H  ; C
;
	BYTE	07DH,10000000B+000H+SCOF
;
	BYTE	0FDH
;
;
FXOD16	EQU	$		; Ground - 6 !
	BYTE	10010000B,00010001B
;
	BYTE	00FH,0F0H+006H,00000000B+OCS0				; 0
;;;;;	     BYTE    00FH,00000000B+OCS0+006H
;
	BYTE	0FEH,00010000B
;
	BYTE	02AH,10000000B+OLD0+003H,087H,00000000B+OLD0+007H	; 1
	BYTE	0A3H,00000000B+OLD0+004H,0B2H,00000000B+OCO0+002H
;
	BYTE	00AH,10000000B+OLD0+002H,019H,00000000B+OCO0+000H	; 2
	BYTE	036H,00000000B+OLD0+004H,050H,00000000B+OCO0+001H
	BYTE	082H,00000000B+OLD0+006H
;
	BYTE	02BH,10000000B+OLD0+003H,024H,00000000B+OCO0+001H	; 3
	BYTE	0BBH,00000000B+OLD0+004H,0B8H,00000000B+OBMS+000H
	BYTE	0C2H,00000000B+OCO0+003H,0C3H,00000000B+OLD0+003H
;
	BYTE	01BH,10000000B+OLD0+004H				; 4
	BYTE	067H,00000000B+OLD0+002H,0C4H,00000000B+OLD0+005H
;
	BYTE	053H,10000000B+OCO0+001H,0D2H,00000000B+OCO0+001H	; 5
;
	BYTE	012H,10000000B+OCO0+001H,029H,00000000B+OLD0+003H	; 6
	BYTE	085H,00000000B+OLD0+007H
;
	BYTE	01BH,10000000B+OLD0+002H,01AH,00000000B+OCO0+002H	; 7
	BYTE	047H,00000000B+OLD0+003H,083H,00000000B+OCO0+001H
	BYTE	0A7H,00000000B+OLD0+003H
;
	BYTE	00EH,10010001B						; 8
;
	BYTE	0A7H,00000000B+OPB1+003H,0B7H,00000000B+OPB1+003H
	BYTE	0C5H,00000000B+OPB1+005H,0D5H,00000000B+OPB1+005H
	BYTE	0DDH,00000000B+000H+EXOF
	BYTE	0E3H,00000000B+OPB1+007H,0F3H,00000000B+OPB1+007H
;
	BYTE	08DH,10000000B+000H+OPL0				; 9
;
;;K;;	BYTE	0AEH,01000010B
;
	BYTE	0AFH,0F0H+000H,00000000B+OCS0
;;;;;	     BYTE    0DFH,00000000B+OCS0+000H
;
	BYTE	0ADH,10000000B+000H+SCOF
;
	BYTE	0FDH							; end
;
;
FXOD17	EQU	$		; Ground - 7 !
	BYTE	10010000B,00010001B
;
	BYTE	00FH,0F0H+006H,00000000B+OCS0				; 0
;;;;;	      BYTE     00FH,00000000B+OCS0+006H				  ; 0
	BYTE	06EH,00010000B
	BYTE	08BH,00000000B+OLD0+007H
	BYTE	0AFH,0F0H+002H,00000000B+OST0
;;;;;	      BYTE     0AFH,00000000B+OST0+002H
	BYTE	0D8H,00000000B+OPB1+002H
	BYTE	0E8H,00000000B+OPB1+002H,0FCH,00000000B+OBG1+00FH
;
	BYTE	0ADH,10000000B+JFST+000H				; 1
	BYTE	0F8H,00000000B+OPB1+004H
;
	BYTE	00CH,10000000B+OBG1+00EH,043H,00000000B+OCO0+003H	; 2
	BYTE	0F8H,00000000B+OPB1+004H
;
	BYTE	00CH,10000000B+OBG1+00EH,073H,00000000B+OCO0+000H	; 3
	BYTE	084H,00000000B+OCO0+000H,093H,00000000B+OCO0+000H
	BYTE	0A4H,00000000B+OCO0+000H,0B3H,00000000B+OCO0+000H
	BYTE	0F8H,00000000B+OPB1+004H
;
	BYTE	048H,10000000B+OPB1+004H,05CH,00000000B+OBG1+009H	; 4
	BYTE	083H,00000000B+OCO0+000H,092H,00000000B+OCO0+001H
	BYTE	0B3H,00000000B+OCO0+000H,0F8H,00000000B+OPB1+004H
;
	BYTE	048H,10000000B+OPB1+004H,05CH,00000000B+OBG1+009H	; 5
	BYTE	0F8H,00000000B+OPB1+004H
;
	BYTE	013H,10000000B+OCO0+002H,037H,00000000B+OPB1+005H	; 6
	BYTE	04CH,00000000B+OBG0+004H,063H,00000000B+000H+OBMS
	BYTE	097H,00000000B+OPB1+005H,0C3H,00000000B+OCO0+002H
;
	BYTE	00BH,10000000B+OLD0+007H,0ACH,00000000B+OBG1+002H	; 7
	BYTE	0F8H,00000000B+OPB1+004H
;
	BYTE	00CH,10000000B+OBG1+00EH,053H,00000000B+OCO0+005H	; 8
	BYTE	09DH,00000000B+JFST+000H
	BYTE	0F8H,00000000B+OPB1+004H
;
	BYTE	02AH,10000000B+OPB1+002H,03CH,00000000B+OBG2+007H	; 9
	BYTE	056H,00000000B+OCO0+003H,0BAH,00000000B+OPB1+002H
	BYTE	0F8H,00000000B+OPB1+004H
;
	BYTE	00CH,10000000B+OBG1+007H,088H,00000000B+OPB1+004H	; A
	BYTE	0BCH,00000000B+OBG1+001H,0D4H,00000000B+OCO0+005H
	BYTE	0FCH,00000000B+OBG1+001H
;
	BYTE	03CH,10000000B+OBG1+001H,078H,00000000B+OPB1+004H	; B
	BYTE	08CH,00000000B+OBG1+008H
;
	BYTE	00BH,10000000B+OLD0+00CH,01AH,00000000B+OBK1+003H	; C
	BYTE	018H,00000000B+OPB1+001H,028H,00000000B+OPB1+001H
	BYTE	039H,00000000B+OPB1+000H
	BYTE	05DH,00000000B+EXOF+000H
	BYTE	0EEH,00010001B
;
	BYTE	00FH,0F0H+008H,10000000B+OST0				; D
;;;;;	      BYTE     00FH,10000000B+OST0+008H				  ; D
;
	BYTE	01DH,10000000B+000H+OPL0				; E
;
;;K;;	BYTE	03EH,01000010B
;
	BYTE	03FH,0F0H+000H,00000000B+OCS0
;;;;;	      BYTE     06FH,00000000B+OCS0+000H
;
	BYTE	03DH,10000000B+000H+SCOF
;
	BYTE	0FDH
;
;
FXOD18	EQU	$		; Ground - 8 !		       / W 2 - 1 /
	BYTE	01010010B,00110001B
;
	BYTE	00FH,0F0H+000H,00000000B+OCS0				; 0
;;;;;	     BYTE    00FH,00000000B+OCS0+000H
	BYTE	06EH,01000000B
	BYTE	0F7H,00000000B+OBK0+000H
;
	BYTE	007H,10000000B+000H+OBBM,017H,00000000B+OBK0+000H	; 1
	BYTE	04FH,0F0H+004H,00000000B+OST0
	BYTE	05FH,080H+000H,00000000B+BGCL
;;;;;	     BYTE    04FH,00000000B+OST0+004H
	BYTE	0C3H,00000000B+000H+OSMS
	BYTE	0C7H,00000000B+000H+OSCO,0D3H,00000000B+OBK0+002H
;
	BYTE	027H,10000000B+OPB1+003H,039H,00000000B+OPB1+001H	; 2
	BYTE	0E7H,00000000B+OCM2+003H
;
	BYTE	05CH,10000000B+OBC1+004H,057H,00000000B+000H+OBMS	; 3
	BYTE	06CH,00000000B+OBC2+003H
;
	BYTE	047H,10000000B+OBK0+000H,053H,00000000B+000H+OBBS	; 4
	BYTE	063H,00000000B+OBK0+002H,0A7H,00000000B+OCM2+003H
	BYTE	0FCH,00000000B+OBC2+003H
;
	BYTE	013H,10000000B+OBK0+001H,033H,00000000B+000H+OBBW	; 5
	BYTE	043H,00000000B+OBK0+001H,05CH,00000000B+OBC2+002H
	BYTE	0C3H,00000000B+OBK0+003H,0CCH,00000000B+OHL0+003H
;
	BYTE	077H,10000000B+OCM0+003H,0ACH,00000000B+OHL0+002H	; 6
;
	BYTE	039H,10000000B+OCM2+001H,0A7H,00000000B+OCM2+003H	; 7
	BYTE	0D3H,00000000B+000H+OBBM,0E8H,00000000B+OCM2+002H
	BYTE	0E3H,00000000B+OBK0+002H
;
	BYTE	026H,10000000B+OCM2+004H,0BCH,00000000B+OHL0+002H	; 8
;
	BYTE	08CH,10000000B+OHL0+001H,0A8H,00000000B+OPB1+002H	; 9
;
	BYTE	017H,10000000B+ORBC+000H,043H,00000000B+OBK0+004H	; A
	BYTE	0A7H,00000000B+000H+OBCO,0C3H,00000000B+000H+OBBM
;
	BYTE	008H,10000000B+OCM2+002H,097H,00000000B+OBK0+001H	; B
	BYTE	0A3H,00000000B+OSCO+000H,0C9H,00000000B+OBOD+000H
	BYTE	0E1H,00000000B+OPB1+009H,0F1H,00000000B+OPB1+009H
;
	BYTE	08DH,10000000B+OPL0+000H				; C
	BYTE	0CFH,0F0H+006H,00000000B+OCS0
;;;;;	     BYTE    0CFH,00000000B+OCS0+006H
;
	BYTE	09DH,10000000B+000H+SCOF
;
	BYTE	0FDH							; end
;
;
FXOD19	EQU	$		; Ground - 9 !	; GOTO UNDER
	BYTE	00111000B,00010001B
;
	BYTE	00FH,0F0H+006H,00000000B+OCS0				; 0
;;;;;	      BYTE     00FH,00000000B+OCS0+006H				  ; 0
	BYTE	0ADH,00000000B+OCM3+000H
;
	BYTE	03DH,10000000B+SCOF	; SCROLL STOP
	BYTE	0FDH							; end
;
FXOD1A	EQU	$		; Ground - A !			 / W 5 - 1 /
	BYTE	10010101B,10110001B
	BYTE	00FH,0F0H+006H,00000000B+OCS0				; 0
;;;;;	      BYTE     00FH,00000000B+OCS0+006H
;
	BYTE	00DH,00000000B+002H					; 2
	BYTE	0C8H,00000000B+OCM2+002H
;
	BYTE	01CH,10000000B+OHL0+001H,038H,00000000B+OCM2+002H	; 3
;
	BYTE	00DH,00000000B+005H					; 5
	BYTE	097H,00000000B+OBK1+004H,098H,00000000B+OPB1+002H
	BYTE	0A3H,00000000B+OBK0+000H,0B3H,00000000B+OBBS+000H
	BYTE	0C3H,00000000B+OBK0+000H,0CCH,00000000B+OHL0+003H
;
	BYTE	0F9H,10000000B+OGN0+001H				; 6
;
	BYTE	02CH,10000000B+OHL0+001H,048H,00000000B+OPB1+002H	; 7
;
	BYTE	00DH,00000000B+009H					; 9
	BYTE	037H,00000000B+OPB1+003H,047H,00000000B+OSMS+000H
	BYTE	057H,00000000B+OBK0+001H,08CH,00000000B+OHL0+002H
	BYTE	0C5H,00000000B+OCM0+001H,0C7H,00000000B+OBK1+001H
	BYTE	0F9H,00000000B+OGN0+001H
;
	BYTE	039H,10000000B+OCM2+001H,0A9H,00000000B+OGN0+001H	; A
;
	BYTE	06FH,0F0H+004H,10000000B+OST0				; B
;;;;;	      BYTE     06FH,10000000B+OST0+004H
	BYTE	0D3H,00000000B+OPB1+005H
	BYTE	0E3H,00000000B+OPB1+005H
;
	BYTE	07DH,10000000B+OPL0+000H				; C
	BYTE	0BFH,0F0H+006H,00000000B+OCS0
;;;;;	      BYTE     0BFH,00000000B+OCS0+006H
;
	BYTE	08DH,10000000B+000H+SCOF
;
	BYTE	0FDH							; end of data
;
FXOD1B	EQU	$		; Ground - B !
	BYTE	00000000B,11000001B
;
	BYTE	04CH,00000000B+OHL0+000H,0F4H,00000000B+OCO0+00FH	; 0
;
	BYTE	00DH,002H						; 2
	BYTE	002H,00000000B+OCO0+002H,043H,00000000B+OCO0+00FH
;
	BYTE	052H,10000000B+OCO0+002H				; 3
	BYTE	0DEH,00000000B
;
	BYTE	05AH,10000000B+OCO0+002H				; 4
;
	BYTE	04DH,10000000B+000H+SCOF				; 5
;
	BYTE	0FDH
;
;
FXOD1C	EQU	$		; Ground - C !			  / W 4 - 3 /
	BYTE	10010000B,01010001B				; / W 6 - 3 /
;
	BYTE	00FH,0F0H+006H,00000000B+OCS0				; 0
;;;;;	      BYTE     00FH,00000000B+OCS0+006H
	BYTE	0EEH,00010000B
;
	BYTE	00BH,10000000B+OMS0+004H,033H,00000000B+OMS0+004H	; 1
	BYTE	042H,00000000B+OCO0+002H
	BYTE	077H,00000000B+OMS0+006H,086H,00000000B+OCO0+004H
;
	BYTE	002H,10000000B+OMS0+002H,04AH,00000000B+OMS0+006H	; 2
	BYTE	069H,00000000B+OCO0+002H,073H,00000000B+OMS0+004H
	BYTE	0B0H,00000000B+000H+OBMS,0C7H,00000000B+OMS0+002H
;
	BYTE	005H,10000000B+OCO0+000H				; 3
	BYTE	01CH,00000000B+OEP0+007H
	BYTE	01FH,0F0H+001H,00000000B+OLW0
;;;;;	      BYTE     01FH,00000000B+OLW0+001H
	BYTE	036H,00000000B+OMS0+002H
	BYTE	08FH,0F0H+004H,00000000B+OLW0
;;;;;	      BYTE     08FH,00000000B+OLW0+004H
	BYTE	091H,00000000B+OCO0+000H
;
	BYTE	01BH,10000000B+OMS0+004H,035H,00000000B+OMS0+002H	; 4
	BYTE	034H,00000000B+OCO0+002H,060H,00000000B+OCO0+002H
	BYTE	061H,00000000B+OMS0+002H,087H,00000000B+OMS0+002H
	BYTE	096H,00000000B+OCO0+000H,0A3H,00000000B+OMS0+004H
;
	BYTE	01CH,10000000B+OEP0+008H				; 5
	BYTE	01FH,0F0H+001H,00000000B+OLW0
;;;;;	      BYTE     01FH,00000000B+OLW0+001H
	BYTE	047H,00000000B+OMS0+002H
	BYTE	09FH,0F0H+005H,00000000B+OLW0
;;;;;	      BYTE     09FH,00000000B+OLW0+005H
	BYTE	0CCH,00000000B+OEP0+005H
	BYTE	0CFH,0F0H+001H,00000000B+OLW0
;;;;;	      BYTE     0CFH,00000000B+OLW0+001H
;
	BYTE	005H,10000000B+OCO0+000H				; 6
	BYTE	01FH,0F0H+005H,00000000B+OLW0
;;;;;	      BYTE     01FH,00000000B+OLW0+005H
	BYTE	039H,00000000B+OMS0+002H,07CH,00000000B+OEP0+006H
	BYTE	07FH,0F0H+001H,00000000B+OLW0
;;;;;	      BYTE     07FH,00000000B+OLW0+001H
	BYTE	082H,00000000B+OCO0+000H
	BYTE	098H,00000000B+OMS0+002H
	BYTE	0DFH,0F0H+005H,00000000B+OLW0
;;;;;	      BYTE     0DFH,00000000B+OLW0+005H
;
	BYTE	016H,10000000B+OCO0+004H,017H,00000000B+OMS0+004H	; 7
	BYTE	054H,00000000B+OMS0+002H,09BH,00000000B+OMS0+006H
;
	BYTE	028H,10000000B+OMS0+004H				; 8
;
	BYTE	0CEH,00000001B
;
	BYTE	03DH,10000000B+OPL0+000H				; 9
;
;;K;;	BYTE	05EH,01000010B
;
	BYTE	05FH,0F0H+000H,00000000B+OCS0
;;;;;	      BYTE     08FH,00000000B+OCS0+000H
;
	BYTE	05DH,10000000B+000H+SCOF
;
	BYTE	0FDH							; end
;
;
FXOD1D	EQU	$		; Ground - D !
	BYTE	10010111B,00010001B
;
	BYTE	00FH,0F0H+006H,00000000B+OCS0				; 0
;;;;;	      BYTE     00FH,00000000B+OCS0+006H
	BYTE	0FEH,00010000B
;
	BYTE	02BH,10000000B+OLD0+002H,057H,00000000B+OLD0+002H	; 1
	BYTE	08BH,00000000B+OLD0+002H,0C0H,00000000B+OCO0+001H
	BYTE	0F7H,00000000B+OLD0+003H
;
	BYTE	05BH,10000000B+OLD0+002H,069H,00000000B+OBOD+000H	; 2
	BYTE	0BBH,00000000B+OLD0+002H,0B2H,00000000B+OCO0+006H
;
	BYTE	019H,10000000B+OLD0+003H,071H,00000000B+OBMS+000H	; 3
;
	BYTE	017H,10000000B+OLD0+004H				; 4
	BYTE	07CH,00000000B+OEP0+004H
	BYTE	07FH,0F0H+001H,00000000B+OLW0
;;;;;	      BYTE     07FH,00000000B+OLW0+001H
	BYTE	093H,00000000B+OCO0+001H
	BYTE	0BFH,0F0H+005H,00000000B+OLW0
;;;;;	      BYTE     0BFH,00000000B+OLW0+005H
	BYTE	0FCH,00000000B+OEP0+003H
	BYTE	0FFH,0F0H+001H,00000000B+OLW0
;;;;;	      BYTE     0FFH,00000000B+OLW0+001H
;
	BYTE	02FH,0F0H+005H,10000000B+OLW0				; 5
;;;;;	      BYTE     02FH,10000000B+OLW0+005H
	BYTE	050H,00000000B+OCO0+002H
	BYTE	051H,00000000B+OLD0+002H,058H,00000000B+OLD0+004H
	BYTE	0A6H,00000000B+OLD0+002H,0DBH,00000000B+OLD0+002H
;
	BYTE	01BH,10000000B+OLD0+003H,046H,00000000B+OCO0+003H	; 6
	BYTE	07BH,00000000B+OLD0+002H,08DH,00000000B+WFST
	BYTE	0B7H,00000000B+OLD0+004H
;
	BYTE	01BH,10000000B+OLD0+004H,049H,00000000B+OBOD+000H	; 7
	BYTE	0BBH,00000000B+OLD0+002H
	BYTE	0FCH,00000000B+OEP0+003H
	BYTE	0FFH,0F0H+002H,00000000B+OLW0
;;;;;	      BYTE     0FFH,00000000B+OLW0+002H
;
	BYTE	003H,10000000B+OCO0+001H				; 8
	BYTE	02FH,0F0H+005H,00000000B+OLW0
;;;;;	      BYTE     02FH,00000000B+OLW0+005H
	BYTE	043H,00000000B+OLD0+002H,04BH,00000000B+OLD0+003H
	BYTE	077H,00000000B+OLD0+003H
	BYTE	09DH,00000000B+EXOF
;
	BYTE	015H,10000000B+OCO0+001H,0A1H,00000000B+OCO0+001H	; 9
	BYTE	0C3H,00000000B+OLD0+002H
	BYTE	0FEH,00000001B
;
	BYTE	07DH,10000000B+OPL0+000H				; A
;
;;K;;	BYTE	09EH,01000010B
;
	BYTE	09FH,0F0H+000H,00000000B+OCS0
;;;;;	      BYTE     0CFH,00000000B+OCS0+000H
;
	BYTE	09DH,10000000B+000H+SCOF
;
	BYTE	0FDH							; end
;
;
FXOD1E	EQU	$		; Ground - E !			 / W 6 - 1 /
	BYTE	01010010B,00100001B
;
	BYTE	00FH,0F0H+000H,00000000B+OCS0				; 0
;;;;;	      BYTE     00FH,00000000B+OCS0+000H
;
	BYTE	06EH,01000100B
;
	BYTE	00CH,10000000B+OBC2+001H,04CH,00000000B+OHL0+001H	; 1
	BYTE	0AAH,00000000B+OBK1+005H,0D9H,00000000B+OBK1+004H
	BYTE	0EEH,00100000B
;
	BYTE	008H,10000000B+OBK1+003H,037H,00000000B+OBK1+002H	; 2
	BYTE	043H,00000000B+OBBM+000H
	BYTE	04EH,00100001B
	BYTE	053H,00000000B+OBK0+000H,07CH,00000000B+OHL0+001H
	BYTE	097H,00000000B+OBK0+001H,0B7H,00000000B+ORBC+000H
;
	BYTE	09CH,10000000B+OHL0+001H,0E7H,00000000B+OCO0+002H	; 3
;
	BYTE	05FH,0F0H+003H,10000000B+OST0				; 4
;;;;;	      BYTE     05FH,10000000B+OST0+003H
	BYTE	097H,00000000B+OPB1+003H
	BYTE	0ACH,00000000B+OHL0+002H,0C5H,00000000B+OCO0+001H
;
	BYTE	049H,10000000B+OPB1+000H,058H,00000000B+OPB1+001H	; 5
	BYTE	076H,00000000B+OPB1+004H,085H,00000000B+OPB1+005H
	BYTE	094H,00000000B+OPB1+006H,0A4H,00000000B+OBK0+002H
	BYTE	0A6H,00000000B+OSMS+000H
	BYTE	0C8H,00000000B+OBK0+002H,0DCH,00000000B+OHL0+002H
;
	BYTE	068H,10000000B+OCM2+002H,096H,00000000B+OCO0+002H	; 6
;
	BYTE	013H,10000000B+OSCO+000H,017H,00000000B+OSCO+000H	; 7
	BYTE	0AFH,0F0H+004H,00000000B+OST0
;;;;;	      BYTE     0AFH,00000000B+OST0+004H
	BYTE	0F6H,00000000B+OBK0+001H
	BYTE	0FCH,00000000B+OHL0+006H
;
	BYTE	026H,10000000B+OBMS+000H,02AH,00000000B+OBK0+004H	; 8
	BYTE	036H,00000000B+OBCO+000H
	BYTE	08CH,00000000B+OHL0+000H
	BYTE	0FFH,0F0H+005H,00000000B+OST0
;;;;;	      BYTE     0FFH,00000000B+OST0+005H
;
	BYTE	04EH,10100000B						; 9
	BYTE	055H,00000000B+OBK0+001H
	BYTE	077H,00000000B+OBK0+000H,087H,00000000B+ORBC+000H
	BYTE	089H,00000000B+OBK0+002H
	BYTE	0AEH,00100001B
;
	BYTE	04CH,10000000B+OHL0+002H				; A
	BYTE	09FH,0F0H+004H,00000000B+OST0
;;;;;	      BYTE     09FH,00000000B+OST0+004H
	BYTE	0ECH,00000000B+OHL0+001H
;
	BYTE	003H,10000000B+OPB1+007H,013H,00000000B+OPB1+007H	; B
	BYTE	08DH,00000000B+000H+EXOF,0ADH,00000000B+OPL0+000H
	BYTE	0EFH,0F0H+006H,00000000B+OCS0
;;;;;	      BYTE     00FH,10000000B+OCS0+006H
;
	BYTE	0BDH,10000000B+000H+SCOF
;
	BYTE	0FDH
;
;
FXOD1F	EQU	$		; Ground - F !			/ W 4 - 2 /
	BYTE	00010000B,01010001B
;
	BYTE	04CH,00000000B+OHL0+000H				; 0
	BYTE	0C7H,00000000B+OMS0+002H,0C6H,00000000B+OCO0+002H
;
	BYTE	003H,10000000B+OMS0+002H,002H,00000000B+OCO0+002H	; 1
	BYTE	029H,00000000B+OMS0+002H,063H,00000000B+OMS0+002H
	BYTE	062H,00000000B+OCO0+002H,069H,00000000B+OMS0+004H
	BYTE	0A5H,00000000B+OMS0+002H,0A4H,00000000B+OCO0+002H
	BYTE	0E2H,00000000B+OMS0+004H,0E1H,00000000B+OCO0+004H
	BYTE	0F8H,00000000B+OMS0+006H
;
	BYTE	037H,10000000B+OCO0+001H				; 2
	BYTE	08FH,0F0H+008H,00000000B+OST0
;;;;;	      BYTE     08FH,00000000B+OST0+008H
;
	BYTE	002H,10000000B+OBK1+00BH,028H,00000000B+OCM0+002H	; 3
	BYTE	068H,00000000B+OCM0+002H,0A8H,00000000B+OCM0+002H
	BYTE	0E0H,00000000B+OPB1+00AH,0F0H,00000000B+OPB1+00AH
;
	BYTE	06DH,10000000B+SLON+000H				; 4
;
;
	BYTE	0FDH
;
;
FXOD1G	EQU	$		; Ground - G !
	BYTE	10010010B,00110001B
;
	BYTE	00FH,0F0H+000H,00000000B+OCS0				; 0
;;;;;	      BYTE     00FH,00000000B+OCS0+000H
;
	BYTE	06EH,01000000B
;
	BYTE	00DH,002H						; 2
;
	BYTE	037H,00000000B+OCM2+003H,0ECH,00000000B+OHL0+000H
;
	BYTE	00CH,10000000B+OHL0+000H,03CH,00000000B+OHL0+000H	; 3
	BYTE	06CH,00000000B+OHL0+000H,09CH,00000000B+OHL0+000H
;
	BYTE	006H,10000000B+OCO0+000H,0C7H,00000000B+OCM2+003H	; 4
;
	BYTE	006H,10000000B+OSMS+000H				; 5
	BYTE	028H,00000000B+OCM2+002H,096H,00000000B+OCO0+000H
	BYTE	0E7H,00000000B+OCM2+003H
;
	BYTE	026H,10000000B+OCO0+000H,087H,00000000B+OCM0+003H	; 6
	BYTE	0D2H,00000000B+OCO0+001H
;
	BYTE	039H,10000000B+OCM2+001H				; 7
;
	BYTE	0C8H,10000000B+OCM2+002H				; 8
;
	BYTE	097H,10000000B+OPB1+003H,0A3H,00000000B+OBK0+003H	; 9
	BYTE	0E7H,00000000B+OSCO+000H,0E3H,00000000B+ORBC+000H
	BYTE	0F3H,00000000B+OBK0+002H
;
	BYTE	037H,10000000B+OPB1+003H				; A
	BYTE	09CH,00000000B+OHL0+000H,0BCH,00000000B+OHL0+000H
	BYTE	0ECH,00000000B+OHL0+000H
;
	BYTE	00CH,10000000B+OHL0+000H,03CH,00000000B+OHL0+000H	; B
	BYTE	086H,00000000B+OBK0+001H,0A6H,00000000B+000H+OBBS
	BYTE	0B6H,00000000B+OBK0+004H
;
	BYTE	05CH,10000000B+OHL0+000H,07CH,00000000B+OHL0+000H	; C
	BYTE	09CH,00000000B+OHL0+000H
;
	BYTE	029H,10000000B+OPB1+001H				; D
	BYTE	0DCH,00000000B+OHL0+005H,0F6H,00000000B+OCO0+001H
;
	BYTE	0DCH,10000000B+OHL0+000H,0E8H,00000000B+OCM2+002H	; E
;
	BYTE	00CH,10000000B+OHL0+001H,027H,00000000B+OCM2+003H	; F
	BYTE	04CH,00000000B+OHL0+001H,066H,00000000B+OCM2+004H
;
	BYTE	00DH,011H						;11
;
	BYTE	03FH,0F0H+005H,00000000B+OST0
;;;;;	      BYTE     03FH,00000000B+OST0+005H
	BYTE	0B6H,00000000B+OCO0+001H
;
	BYTE	02CH,10000000B+OHL0+002H,036H,00000000B+OCO0+000H	;12
	BYTE	07CH,00000000B+OHL0+002H,086H,00000000B+OCO0+000H
	BYTE	0F9H,00000000B+OPB1+001H
;
	BYTE	039H,10000000B+OPB1+001H,0ACH,00000000B+OHL0+004H	;13
	BYTE	0C6H,00000000B+OCO0+001H
;
	BYTE	00CH,10000000B+OHL0+003H,016H,00000000B+OCO0+001H	;14
;
	BYTE	088H,10000000B+OCM2+002H				;15
;
	BYTE	039H,10000000B+OCM2+001H				;16
	BYTE	07CH,00000000B+OHL0+000H,089H,00000000B+OPB1+001H
	BYTE	09CH,00000000B+OHL0+000H,0A7H,00000000B+OPB1+003H
	BYTE	0BCH,00000000B+OHL0+000H,0C5H,00000000B+OPB1+005H
	BYTE	0DCH,00000000B+OHL0+000H,0E3H,00000000B+OPB1+007H
	BYTE	0F3H,00000000B+OPB1+007
;
	BYTE	08DH,10000000B+000H+OPL0				;17
	BYTE	0CFH,0F0H+006H,00000000B+OCS0
;;;;;	      BYTE     0CFH,00000000B+OCS0+006H
;
	BYTE	08DH,10000000B+000H+SCOF
;
	BYTE	0FDH
;
;
FXOD1H	EQU	$		; Ground - H !
	BYTE	01010101B,10110001B
;
	BYTE	00FH,0F0H+006H,00000000B+OCS0				; 0
;;;;;	      BYTE     00FH,00000000B+OCS0+006H
;
	BYTE	0CFH,0F0H+003H,00000000B+OST0
	BYTE	0DFH,080H+000H,00000000B+BGCL
;;;;;	      BYTE     0CFH,00000000B+OST0+003H
;
	BYTE	007H,10000000B+OBK1+002H,015H,00000000B+OGN0+001H	; 1
	BYTE	052H,00000000B+OCO0+002H,099H,00000000B+OBOD+000H
	BYTE	0ACH,00000000B+OHL0+002H
	BYTE	0D3H,00000000B+OBK0+004H,0D6H,00000000B+OCO0+002H
	BYTE	0D7H,00000000B+OBK0+005H
;
	BYTE	023H,10000000B+000H+OBBM				; 2
	BYTE	0CFH,0F0H+003H,00000000B+OST0
;;;;;	      BYTE     0CFH,00000000B+OST0+003H
;
	BYTE	007H,10000000B+OPB1+003H,019H,00000000B+OPB1+001H	; 3
	BYTE	078H,00000000B+OCM0+002H
	BYTE	0EFH,0F0H+003H,00000000B+OST0
;;;;;	      BYTE     0EFH,00000000B+OST0+003H
;
	BYTE	02CH,10000000B+OHL0+001H,046H,00000000B+OPB1+004H	; 4
	BYTE	055H,00000000B+OPB1+005H,065H,00000000B+OPB1+005H
	BYTE	0ECH,00000000B+OBC2+004H
;
	BYTE	047H,10000000B+000H+OSCO				; 5
	BYTE	053H,00000000B+000H+OBBW,063H,00000000B+OBK0+001H
	BYTE	062H,00000000B+OCO0+001H
	BYTE	096H,00000000B+OBK0+002H,09AH,00000000B+OCO0+001H
	BYTE	0CCH,00000000B+OHL0+003H
;
	BYTE	0B9H,10000000B+OGN0+001H				; 6
;
	BYTE	039H,10000000B+OCM2+001H,063H,00000000B+OBK0+006H	; 7
	BYTE	067H,00000000B+OBK0+007H,0D3H,00000000B+000H+OBBS
	BYTE	0FCH,00000000B+OHL0+001H
;
	BYTE	018H,10000000B+OPB1+002H				; 8
	BYTE	0D9H,00000000B+ORBC+000H,0E9H,00000000B+OBBM+000H
;
	BYTE	00CH,10000000B+OHL0+006H,037H,00000000B+OBK0+002H	; 9
	BYTE	093H,00000000B+OBK0+004H
;
	BYTE	087H,10000000B+000H+OBBM,0ACH,00000000B+OHL0+002H	; A
	BYTE	0C2H,00000000B+OCO0+001H,0C3H,00000000B+OBK0+003H
	BYTE	0D9H,00000000B+OCM2+001H,0FCH,00000000B+OHL0+001H
;
	BYTE	07FH,0F0H+001H,10000000B+OST0				; B
;;;;;	      BYTE     07FH,10000000B+OST0+001H
	BYTE	09CH,00000000B+OHL0+000H
	BYTE	0A7H,00000000B+OPB1+003H,0B6H,00000000B+OPB1+004H
	BYTE	0CCH,00000000B+OHL0+000H,0D4H,00000000B+OPB1+006H
	BYTE	0E3H,00000000B+OPB1+007H,0F3H,00000000B+OPB1+007H
;
	BYTE	08DH,10000000B+000H+OPL0				; C
	BYTE	0CFH,0F0H+006H,00000000B+OCS0
;;;;;	      BYTE     0CFH,00000000B+OCS0+006H
;
	BYTE	09DH,10000000B+000H+SCOF
;
	BYTE	0FDH
;
;
FXOD1I	EQU	$		; Ground - I !
	BYTE	01010000B,10110001B
;
	BYTE	00FH,0F0H+006H,00000000B+OCS0				; 0
;;;;;	      BYTE     00FH,00000000B+OCS0+006H
	BYTE	0FCH,00000000B+OHL0+000H
;
	BYTE	01FH,0F0H+003H,10000000B+OST0				; 1
;;;;;	      BYTE     01FH,10000000B+OST0+003H
	BYTE	05CH,00000000B+OHL0+000H
	BYTE	065H,00000000B+OPB1+005H,074H,00000000B+OPB1+006H
	BYTE	083H,00000000B+OPB1+007H,093H,00000000B+OPB1+007H
	BYTE	0DCH,00000000B+OBC2+003H
;
	BYTE	04CH,10000000B+OHL0+000H,0B3H,00000000B+OBK0+000H	; 2
	BYTE	0C9H,00000000B+000H+OBOD
	BYTE	0C3H,00000000B+000H+OBSM,0D3H,00000000B+OBK0+00FH
	BYTE	0DCH,00000000B+OHL0+000H
;
	BYTE	02CH,10000000B+OHL0+000H,04CH,00000000B+OHL0+000H	; 3
	BYTE	08CH,00000000B+OHL0+000H,0D3H,00000000B+OBK0+00EH
	BYTE	0EDH,00000000B+000H+EXOF,0FCH,00000000B+OHL0+000H
;
	BYTE	0D7H,10000000B+OBK0+001H,0ECH,00000000B+OHL0+001H	; 4
;
	BYTE	04CH,10000000B+OHL0+000H,059H,00000000B+OGN0+001H	; 5
	BYTE	0D8H,00000000B+OGN0+001H,0DAH,00000000B+OGN0+000H
;
	BYTE	037H,10000000B+OBK0+000H,047H,00000000B+000H+OBBM	; 6
	BYTE	099H,00000000B+OGN0+001H,0E7H,00000000B+OBK0+001H
;
	BYTE	03AH,10000000B+OGN0+000H,067H,00000000B+OBK0+000H	; 7
	BYTE	076H,00000000B+OGN0+000H,077H,00000000B+OPB1+000H
	BYTE	087H,00000000B+000H+ORBC,0D8H,00000000B+OGN0+002H
;
	BYTE	039H,10000000B+OCM2+001H,0ACH,00000000B+OHL0+000H	; 8
	BYTE	0E9H,00000000B+OCM2+001H
;
	BYTE	00CH,10000000B+OHL0+000H,02CH,00000000B+OHL0+000H	; 9
	BYTE	04CH,00000000B+OHL0+005H,0C7H,00000000B+OCM0+003H
;
	BYTE	039H,10000000B+OCM2+001H,0ECH,00000000B+OHL0+000H	; A
	BYTE	0F9H,00000000B+OGN0+001H
;
	BYTE	00CH,10000000B+OHL0+002H				; B
	BYTE	06FH,0F0H+004H,00000000B+OST0
;;;;;	      BYTE     06FH,00000000B+OST0+004H
	BYTE	0F8H,00000000B+OGN0+001H
	BYTE	0FAH,00000000B+OGN0+000H
;
	BYTE	07FH,0F0H+002H,10000000B+OST0; C
;;;;;	      BYTE     07FH,10000000B+OST0+002H
	BYTE	0ACH,00000000B+OHL0+000H
	BYTE	0B6H,00000000B+OPB1+004H,0CCH,00000000B+OHL0+001H
	BYTE	0E3H,00000000B+OPB1+007H,0F3H,00000000B+OPB1+007H
;
	BYTE	08DH,10000000B+000H+OPL0				; D
	BYTE	0CFH,0F0H+006H,00000000B+OCS0
;
	BYTE	08DH,10000000B+000H+SCOF
;
	BYTE	0FDH
;
;
FXOD1J	EQU	$		; Ground - J !			 / W 5 - 1 /
;								 / W 7 - 1 /
	BYTE	01010010B,10110001B
;
	BYTE	00FH,0F0H+000H,00000000B+OCS0				; 0
;;;;;	      BYTE     00FH,00000000B+OCS0+000H
;
	BYTE	06EH,01000101B
;
	BYTE	039H,10000000B+OGN0+001H,0B3H,00000000B+OBBM+000H	; 1
	BYTE	0C3H,00000000B+OBK0+001H,0C8H,00000000B+OGN0+001H
	BYTE	0CAH,00000000B+OGN0+000H
;
	BYTE	049H,10000000B+OGN0+001H,07CH,00000000B+OBC2+003H	; 2
	BYTE	0E8H,00000000B+OGN0+002H
;
	BYTE	088H,10000000B+OGN0+001H,08AH,00000000B+OGN0+000H	; 3
	BYTE	0E7H,00000000B+OBK0+001H
;
	BYTE	005H,10000000B+OGN0+001H,007H,00000000B+OBK1+000H	; 4
	BYTE	017H,00000000B+ORBC+000H,027H,00000000B+OBK0+000H
	BYTE	049H,00000000B+OGN0+001H
	BYTE	09CH,00000000B+OHL0+001H,0C8H,00000000B+OCM2+002H
;
	BYTE	023H,10000000B+OBK0+006H,027H,00000000B+OBK0+006H	; 5
	BYTE	0D3H,00000000B+000H+OSMS,0D8H,00000000B+OCM0+002H
;
	BYTE	089H,10000000B+OGN0+001H,0D8H,00000000B+OCM2+002H	; 6
;
	BYTE	039H,10000000B+OCM2+001H,0A9H,00000000B+OGN0+001H	; 7
;
	BYTE	009H,10000000B+OCM2+001H,063H,00000000B+OBK0+004H	; 8
	BYTE	067H,00000000B+OBK0+004H,0D8H,00000000B+OPB1+002H
;
	BYTE	028H,10000000B+OGN0+001H,02AH,00000000B+OGN0+000H	; 9
	BYTE	056H,00000000B+OBK0+001H,070H,00000000B+OBBM+000H
	BYTE	079H,00000000B+OBOD+000H,08CH,00000000B+OHL0+000H
	BYTE	094H,00000000B+OBK0+001H
	BYTE	09FH,0F0H+005H,00000000B+OST0
;;;;;	      BYTE     09FH,00000000B+OST0+005H
;
	BYTE	02FH,0F0H+008H,10000000B+OST0				; A
;;;;;	      BYTE     02FH,10000000B+OST0+008H
;
	BYTE	03DH,10000000B+OPL0+000H				; B
	BYTE	07FH,0F0H+006H,00000000B+OCS0
;;;;;	      BYTE     07FH,00000000B+OCS0+006H
;
	BYTE	03DH,10000000B+000H+SCOF
;
	BYTE	0FDH
;
;
FXOD1K	EQU	$		; Ground - K !
	BYTE	00000110B,11000001B
;
	BYTE	04CH,00000000B+OHL0+000H,0F4H,00000000B+OCO0+00FH	; 0
;
	BYTE	00DH,002H						; 2
	BYTE	006H,00000000B+OBK0+000H,024H,00000000B+OCO0+00FH
;
	BYTE	035H,10000000B+OBK0+000H,036H,00000000B+OBK0+000H	; 3
	BYTE	053H,00000000B+OCO0+006H
	BYTE	0D5H,00000000B+OBK0+000H,0D6H,00000000B+OBK0+000H
;
	BYTE	034H,10000000B+OBK0+001H,073H,00000000B+OCO0+009H	; 4
	BYTE	074H,00000000B+OBK0+000H,094H,00000000B+OBK0+000H
	BYTE	0B4H,00000000B+OBK0+000H,0D4H,00000000B+OBK0+000H
	BYTE	0F4H,00000000B+OBK0+000H
;
	BYTE	02EH,10000000B						; 5
	BYTE	059H,00000000B+OCO0+002H
;
	BYTE	04DH,10000000B+000H+SCOF				; 6
;
	BYTE	0FDH
;
;
FXOD1L	EQU	$		; Ground - L !			/ W 3 - 2 /
	BYTE	10010110B,00110001B
;
	BYTE	00FH,0F0H+006H,00000000B+OCS0				; 0
;;;;;	      BYTE     00FH,00000000B+OCS0+006H
;
	BYTE	00DH,003H						; 3
;
	BYTE	01AH,00000000B+OPB1+000H,077H,00000000B+OCO0+002H
	BYTE	0C4H,00000000B+OBMS+000H,0C8H,00000000B+OPB1+002H
;
	BYTE	0B9H,10000000B+OPB1+001H,0D3H,00000000B+OBBS+000H	; 4
	BYTE	0D7H,00000000B+000H+ORBC,0F9H,00000000B+OPB1+001H
;
	BYTE	00CH,10000000B+OHL0+001H				; 5
;
	BYTE	04EH,10110001B						; 6
;
	BYTE	08EH,10110001B						; 7
;
	BYTE	0BCH,00000000B+OHL0+001H,0E4H,00000000B+OPB0+000H
	BYTE	0E9H,00000000B+OPB1+001H
;
	BYTE	00CH,10000000B+OHL0+001H				; 8
;
	BYTE	00DH,00AH						; A
;
	BYTE	084H,00000000B+OCO0+003H,098H,00000000B+OCM2+002H
;
	BYTE	00DH,00CH						; C
;
	BYTE	00FH,0F0H+008H,00000000B+OST0
;;;;;	      BYTE     00FH,00000000B+OST0+008H
;
	BYTE	01DH,10000000B+OPL0+000H				; D
	BYTE	05FH,0F0H+006H,00000000B+OCS0
;;;;;	      BYTE     05FH,00000000B+OCS0+006H
;
	BYTE	01DH,10000000B+000H+SCOF
;
	BYTE	0FDH							; end of data
;
;
;#####################################################################
;#	 Fix obstacle out pos data  ( Underground )		     #
;#####################################################################
FXOD20	EQU	$		; Underground - 0 !	       / W 1 - 2 /
	BYTE	01001000B,00001111B
;
	BYTE	00EH,00000001B						; 0
	BYTE	05EH,00000010B
	BYTE	0A7H,00000000B+OBMS+000H,0BCH,00000000B+OBC2+003H
;
	BYTE	01AH,10000000B+OPB1+000H,039H,00000000B+OPB1+001H	; 1
	BYTE	058H,00000000B+OPB1+002H,077H,00000000B+OPB1+003H
	BYTE	097H,00000000B+OPB1+003H,0B8H,00000000B+OPB1+002H
	BYTE	0D6H,00000000B+000H+ORBC,0F8H,00000000B+OPB1+002H
;
	BYTE	019H,10000000B+OPB1+001H				; 2
	BYTE	075H,00000000B+OPB0+002H
	BYTE	086H,00000000B+OCO0+000H,087H,00000000B+OPB0+000H
	BYTE	095H,00000000B+OPB0+002H,093H,00000000B+OCO0+003H
	BYTE	0A5H,00000000B+OBK0+001H
	BYTE	0C5H,00000000B+OPB0+002H,0D6H,00000000B+OCO0+000H
	BYTE	0D7H,00000000B+OBK0+000H
	BYTE	0E5H,00000000B+OBBS+000H,0E6H,00000000B+OPB0+001H
;
	BYTE	03EH,10001101B						; 3
;
	BYTE	05EH,00000011B
	BYTE	067H,00000000B+OPB0+002H,077H,00000000B+OPB0+002H
	BYTE	07EH,00000010B
	BYTE	09EH,00000011B
	BYTE	0A6H,00000000B+OCO0+003H,0A7H,00000000B+OBK0+003H
	BYTE	0DEH,00000101B
	BYTE	0FEH,00000010B
;
	BYTE	01EH,10000011B						; 4
	BYTE	033H,00000000B+OPB0+004H,046H,00000000B+OCO0+000H
	BYTE	047H,00000000B+OBK0+001H,056H,00000000B+OBBM+000H
	BYTE	05EH,00000010B
	BYTE	083H,00000000B+OPB0+004H,093H,00000000B+OPB0+002H
	BYTE	096H,00000000B+000H+ORBC,097H,00000000B+OPB0+000H
	BYTE	0BEH,00000011B
	BYTE	0C7H,00000000B+OBK0+003H
	BYTE	0FEH,00000010B
;
	BYTE	00CH,10000000B+OHL0+002H				; 5
	BYTE	043H,00000000B+OCO0+005H,045H,00000000B+OBK0+004H
	BYTE	046H,00000000B+OBK0+004H,090H,00000000B+000H+OBSM
	BYTE	095H,00000000B+OPB0+001H
;
	BYTE	078H,10000000B+OCM0+002H,0D7H,00000000B+OCM2+003H	; 6
;
	BYTE	039H,10000000B+OCM2+001H				; 7
	BYTE	08CH,00000000B+OHL0+001H,0A8H,00000000B+OPB0+002H
	BYTE	0B8H,00000000B+OPB0+002H,0CCH,00000000B+OHL0+001H
;
;;;;;	      BYTE     05FH,10000000B+OST0+003H
	BYTE	05FH,0F0H+003H,10000000B+OST0				; 8
	BYTE	097H,00000000B+OPB1+003H
	BYTE	09EH,00000000B
;
	BYTE	00EH,10000001B						; 9
	BYTE	016H,00000000B+OBK0+004H,066H,00000000B+OBBM+000H
	BYTE	08EH,00000000B
	BYTE	0FEH,00000001B
;
	BYTE	008H,10000000B+OPB0+002H				; A
	BYTE	00EH,00000110B
	BYTE	06FH,0F0H+007H,00000000B+OCM1
;;;;;	      BYTE     06FH,00000000B+OCM1+007H
	BYTE	09EH,00001111B
;
	BYTE	00EH,10000010B
	BYTE	02DH,00000000B+SCOF					; B
	BYTE	028H,00000000B+OCM0+002H,068H,00000000B+OCM0+002H
	BYTE	0A8H,00000000B+OCM0+002H
	BYTE	0AEH,00000001B
	BYTE	0DEH,00001111B
;
	BYTE	06DH,10000000B+000H+SLON				; C
;
	BYTE	0FDH
;
;
FXOD21	EQU	$		; Underground - 1 !
	BYTE	01001000B,00001111B
;
	BYTE	00EH,00000001B						; 0
;
	BYTE	05EH,00000010B
;
	BYTE	0BCH,00000000B+OHL0+001H,0FCH,00000000B+OHL0+001H
;
	BYTE	02CH,10000000B+OHL0+002H,041H,00000000B+OPB0+002H	; 1
	BYTE	04EH,00000100B
	BYTE	067H,00000000B+OBK0+005H,068H,00000000B+OBK0+004H
	BYTE	069H,00000000B+OBK0+004H,0BAH,00000000B+OCO0+002H
	BYTE	0C7H,00000000B+OBBM+000H
;
	BYTE	0DEH,00001011B
;
	BYTE	0B2H,10000000B+ORBC+000H				; 2
	BYTE	0FEH,00000010B
;
	BYTE	02CH,10000000B+OBC1+001H,02CH,00000000B+OBC2+001H	; 3
	BYTE	067H,00000000B+OBCO+000H,077H,00000000B+OBMS+000H
	BYTE	087H,00000000B+OBCO+000H
	BYTE	08EH,00000000B
	BYTE	0EEH,00000001B
	BYTE	0F6H,00000000B+OSCO+000H
;
	BYTE	003H,10000000B+OBBW+000H,005H,00000000B+OSCO+000H	; 4
	BYTE	013H,00000000B+OBK0+001H,016H,00000000B+OSCO+000H
	BYTE	027H,00000000B+OSCO+000H
	BYTE	02EH,00000010B
	BYTE	088H,00000000B+OCM2+002H,0C7H,00000000B+OBK0+000H
	BYTE	0D7H,00000000B+000H+ORBC,0E4H,00000000B+OCM2+006H
;
	BYTE	007H,10000000B+OBK0+000H,017H,00000000B+OBBS+000H	; 5
	BYTE	048H,00000000B+OCM0+002H,076H,00000000B+OBK0+000H
	BYTE	098H,00000000B+OCM2+002H
;
	BYTE	079H,10000000B+OPB1+001H,088H,00000000B+OPB1+002H	; 6
	BYTE	09CH,00000000B+OHL0+001H,0B7H,00000000B+OCM2+003H
	BYTE	0DCH,00000000B+OHL0+001H,0F8H,00000000B+OPB1+002H
	BYTE	0FEH,00000001B
;
	BYTE	008H,10000000B+OPB1+002H				; 7
	BYTE	00EH,00000000B
	BYTE	06EH,00000010B
	BYTE	073H,00000000B+OBK0+000H,077H,00000000B+OBK0+003H
	BYTE	083H,00000000B+OBBM+000H,093H,00000000B+OBK0+000H
	BYTE	0AEH,00000000B
	BYTE	0FEH,00001010B
;
	BYTE	00EH,10000010B						; 8
	BYTE	039H,00000000B+OCM2+001H,0A8H,00000000B+OCM2+002H
	BYTE	0E7H,00000000B+OCM2+003H
;
	BYTE	00CH,10000000B+OHL0+001H				; 9
	BYTE	08FH,0F0H+002H,00000000B+OST0
;;;;;	      BYTE     08FH,00000000B+OST0+002H
	BYTE	0AEH,00000000B
	BYTE	0FEH,00000100B
;
	BYTE	004H,10000000B+OPB0+001H				; A
	BYTE	017H,00000000B+OBBM+000H,026H,00000000B+OCO0+009H
	BYTE	027H,00000000B+OBK0+009H
	BYTE	0DFH,0F0H+003H,00000000B+OST0
;;;;;	      BYTE     0DFH,00000000B+OST0+003H
	BYTE	0FEH,00000010B
;
	BYTE	044H,10000000B+OCM2+006H,07CH,00000000B+OHL0+001H	; B
	BYTE	08EH,00000110B
	BYTE	0BFH,0F0H+007H,00000000B+OCM1
;;;;;	      BYTE     0BFH,00000000B+OCM1+007H
	BYTE	0EEH,00001111B
;
	BYTE	04DH,10000000B+SCOF+000H				; C
;
	BYTE	00EH,10000010B						; D
	BYTE	068H,00000000B+OCM0+002H
	BYTE	0AEH,00000001B
	BYTE	0DEH,00001111B
;
	BYTE	06DH,10000000B+SLON+000H				; E
;
;
	BYTE	0FDH
;
;
;
FXOD22	EQU	$		; Underground - 2 !
	BYTE	01001000B,00000001B
;
; (UNDERGROUND-1)
	BYTE	00EH,00000000B+001H+000H				; 0
	BYTE	000H,00000000B+OPB0+00AH
	BYTE	03EH,00000000B+006H+000H
	BYTE	045H,00000000B+OCO0+006H,047H,00000000B+OCO0+006H
	BYTE	053H,00000000B+OCO0+004H
	BYTE	0AEH,00000000B+001H+000H
;;;;;	      BYTE     0DFH,00000000B+OCM1+00AH
	BYTE	0DFH,0F0H+00AH,00000000B+OCM1
;
	BYTE	04DH,10000000B+SCOF+000H				; 1
;
;-----------------------------------------------------------------------
;
; (UNDERGROUND-2)
	BYTE	00EH,10000000B+001H+000H				; 2
	BYTE	000H,00000000B+OPB0+00AH
	BYTE	02EH,00000000B+004H+000H
	BYTE	037H,00000000B+OBK0+008H,03AH,00000000B+OCO0+008H
	BYTE	046H,00000000B+OCO0+007H,0C7H,00000000B+000H+ORBC
;
	BYTE	0CEH,00000000B+00FH+000H
;
	BYTE	0DFH,0F0H+00AH,00000000B+OCM1
;;;;;	      BYTE     0DFH,00000000B+OCM1+00AH
;
	BYTE	04DH,10000000B+SCOF+000H				; 3
;
;-----------------------------------------------------------------------
;
; (UNDERGROUND-3)
	BYTE	00EH,10000000B+001H+000H				; 4
	BYTE	000H,00000000B+OPB0+00AH,033H,00000000B+OPB0+003H
	BYTE	043H,00000000B+OPB0+001H,046H,00000000B+OCO0+000H
	BYTE	047H,00000000B+OPB0+000H,053H,00000000B+OBBM+000H
	BYTE	055H,00000000B+OCO0+000H,056H,00000000B+OPB0+000H
	BYTE	062H,00000000B+OCO0+003H,064H,00000000B+OCO0+000H
	BYTE	065H,00000000B+OPB0+000H,071H,00000000B+OCO0+001H
	BYTE	073H,00000000B+OPB0+001H,083H,00000000B+OPB0+001H
	BYTE	094H,00000000B+OCO0+000H,095H,00000000B+OPB0+000H
	BYTE	0A3H,00000000B+OPB0+000H,0A5H,00000000B+OCO0+000H
	BYTE	0A6H,00000000B+OPB0+000H,0B3H,00000000B+OPB0+001H
	BYTE	0B6H,00000000B+OCO0+000H,0B7H,00000000B+OPB0+000H
	BYTE	0C3H,00000000B+OPB0+003H
	BYTE	0DFH,0F0H+00AH,00000000B+OCM1
;;;;;	      BYTE     0DFH,00000000B+OCM1+00AH
;
	BYTE	04DH,10000000B+SCOF+000H				; 5
;
;-----------------------------------------------------------------------
;
; (UNDERGROUND-4)
	BYTE	00EH,10000000B+001H+000H				; 6
	BYTE	000H,00000000B+OPB0+00AH
	BYTE	02EH,00000000B+002H+000H
	BYTE	036H,00000000B+OCO0+007H,037H,00000000B+OPB0+002H
	BYTE	03AH,00000000B+OCO0+009H,047H,00000000B+OBK0+005H
	BYTE	0A7H,00000000B+OPB0+002H,0D7H,00000000B+OBBM+000H
	BYTE	0DFH,0F0H+00AH,00000000B+OCM1
;;;;;	      BYTE     0DFH,00000000B+OCM1+00AH
;
	BYTE	04DH,10000000B+SCOF+000H				; 7
;
;-----------------------------------------------------------------------
;
; (UNDERGROUND-5)
	BYTE	00EH,10000000B+001H+000H				; 8
	BYTE	000H,00000000B+OPB0+00AH
	BYTE	03EH,00000000B+002H+000H
	BYTE	044H,00000000B+OPB0+001H,053H,00000000B+OCO0+004H
	BYTE	054H,00000000B+OCO0+004H,055H,00000000B+OBK0+004H
	BYTE	0A1H,00000000B+OPB0+004H
	BYTE	0AEH,00000000B+001H+000H
	BYTE	0B4H,00000000B+OBK0+001H
	BYTE	0DFH,0F0H+00AH,00000000B+OCM1
;;;;;	      BYTE     0DFH,00000000B+OCM1+00AH
	BYTE	0E5H,00000000B+000H+ORBC
;
	BYTE	04DH,10000000B+SCOF+000H				; 9
;
;
	BYTE	0FDH							; END
;
;
;
;#####################################################################
;#	 Fix obstacle out pos data  ( Underwater )		     #
;#####################################################################
;
FXOD30	EQU	$		; Underwater - 0 !
	BYTE	01000001B,00000001B
;
	BYTE	0B4H,00000000B+OBK1+004H,0C8H,00000000B+OPB0+002H	; 0
	BYTE	0F2H,00000000B+OPB0+001H
;
	BYTE	047H,10000000B+OPB0+003H,06CH,00000000B+OHL0+003H	; 1
	BYTE	065H,00000000B+OCO0+009H
;
	BYTE	09EH,00000111B
	BYTE	0AFH,000H+002H,00000000B+ORCK
	BYTE	0AFH,080H+002H,00000000B+ORCK
;
	BYTE	0BEH,00000001B
	BYTE	0BFH,000H+002H,00000000B+ORCK
	BYTE	0BFH,080H+002H,00000000B+ORCK
;
	BYTE	0CCH,00000000B+OHL0+003H
;
	BYTE	0FEH,00000111B
;
	BYTE	00DH,10000000B+000H+WFST				; 2
	BYTE	00FH,000H+002H,00000000B+ORCK
	BYTE	00FH,080H+002H,00000000B+ORCK
;
	BYTE	01EH,00000001B
	BYTE	01FH,000H+002H,00000000B+ORCK
	BYTE	01FH,080H+002H,00000000B+ORCK
;
	BYTE	06CH,00000000B+OHL0+001H,062H,00000000B+OBK1+005H
	BYTE	063H,00000000B+OPB0+003H,08AH,00000000B+OCO0+001H
	BYTE	0ACH,00000000B+OHL0+001H,0B3H,00000000B+OPB0+003H
	BYTE	0E9H,00000000B+OPB0+001H
;
	BYTE	026H,10000000B+OCO0+003H,027H,00000000B+OBK1+003H	; 3
	BYTE	063H,00000000B+OCO0+003H,064H,00000000B+OBK1+003H
	BYTE	0BAH,00000000B+OPB1+000H,0C9H,00000000B+OPB1+001H
;
	BYTE	0CEH,00001011B
;
	BYTE	0DEH,00001111B		;;T;;
	BYTE	0DFH,000H+003H,00000000B+ORCK
	BYTE	0DFH,070H+003H,00000000B+ORCK
	BYTE	0E5H,00000000B+OWC0+000H
	BYTE	0EFH,000H+004H,00000000B+ORCK
	BYTE	0EFH,070H+003H,00000000B+ORCK
	BYTE	0FFH,000H+00AH,00000000B+ORCK
;
	BYTE	00FH,000H+00AH,10000000B+ORCK				; 4
	BYTE	07DH,00000000B+EXOF+000H,07DH,00000000B+SCOF+000H
;
	BYTE	0FDH
;
;
FXOD31	EQU	$		; Underwater - 1 !		  / W 2 - 2 /
	BYTE	01000001B,00000001B				; / W 3 - 2 /
;
	BYTE	0B8H,00000000B+OPB0+002H,0EAH,00000000B+OCO0+001H	; 0
;
	BYTE	027H,10000000B+OBK1+002H,0B3H,00000000B+OCO0+002H	; 1
;
	BYTE	016H,10000000B+OPB0+004H,04AH,00000000B+OCO0+002H	; 2
	BYTE	0A5H,00000000B+OPB0+001H,0A7H,00000000B+OBK1+001H
;
	BYTE	027H,10000000B+OPB0+003H				; 3
;
	BYTE	008H,10000000B+OPB1+002H,016H,00000000B+OPB1+004H	; 4
	BYTE	02CH,00000000B+OHL0+004H,038H,00000000B+OCO0+002H
	BYTE	076H,00000000B+OPB1+004H,088H,00000000B+OPB1+002H
;
	BYTE	0DEH,00000111B
	BYTE	0EFH,000H+002H,00000000B+ORCK
	BYTE	0EFH,080H+002H,00000000B+ORCK
;
	BYTE	0FEH,00000001B
	BYTE	0FFH,000H+002H,00000000B+ORCK
	BYTE	0FFH,080H+002H,00000000B+ORCK
;
	BYTE	00DH,10000000B+000H+WFST				; 5
	BYTE	023H,00000000B+OBK1+002H,031H,00000000B+OPB0+001H
	BYTE	098H,00000000B+OPB0+002H
;
	BYTE	00DH,10000000B+000H+WFST				; 6
	BYTE	059H,00000000B+OCO0+002H,063H,00000000B+OPB0+003H
	BYTE	067H,00000000B+OBK1+001H
;
	BYTE	014H,10000000B+OCO0+002H,036H,00000000B+OBK1+001H	; 7
	BYTE	087H,00000000B+OPB0+003H
;
	BYTE	017H,10000000B+OPB1+003H,029H,00000000B+OPB1+001H	; 8
	BYTE	030H,00000000B+OPB1+002H,03CH,00000000B+OHL0+008H
	BYTE	042H,00000000B+OBK1+007H,059H,00000000B+OCO0+000H
	BYTE	06AH,00000000B+OCO0+002H,099H,00000000B+OCO0+000H
	BYTE	0C9H,00000000B+OPB1+001H
	BYTE	0D7H,00000000B+OPB1+003H
;
	BYTE	039H,10000000B+OPB0+001H,058H,00000000B+OPB0+002H	; 9
	BYTE	0C3H,00000000B+OPB1+007H,0D3H,00000000B+OBK1+001H
	BYTE	0DCH,00000000B+OHL0+006H,0F7H,00000000B+OCO0+002H
	BYTE	0FAH,00000000B+OCO0+002H
;
	BYTE	023H,10000000B+OBK1+001H,043H,00000000B+OPB1+007H	; A
	BYTE	0C3H,00000000B+OBK1+004H,0C7H,00000000B+OBK1+004H
	BYTE	0D1H,00000000B+OPB0+001H
;
	BYTE	043H,10000000B+OBK1+003H,047H,00000000B+OBK1+003H	; B
	BYTE	09AH,00000000B+OBK1+000H,0A9H,00000000B+OPB1+001H
	BYTE	0B8H,00000000B+OPB1+002H
;
	BYTE	0BEH,00001011B
;
	BYTE	0CEH,00001111B		;;T;;
	BYTE	0CFH,000H+003H,00000000B+ORCK
	BYTE	0CFH,070H+003H,00000000B+ORCK
	BYTE	0D5H,00000000B+OWC0+000H	;;T;;
	BYTE	0DFH,000H+004H,00000000B+ORCK
	BYTE	0DFH,070H+003H,00000000B+ORCK
	BYTE	0EFH,000H+00AH,00000000B+ORCK
	BYTE	0FFH,000H+00AH,00000000B+ORCK
;
	BYTE	00FH,000H+00AH,10000000B+ORCK				; C
	BYTE	00DH,00000000B+000H+EXOF,07DH,00000000B+SCOF+000H
;
	BYTE	0FDH
;
;
FXOD32	EQU	$		; Underwater - 2 !		 / W 8 - 4 / (Castle)
	BYTE	01001001B,00001111B
;
	BYTE	01EH,00000001B						; 0
	BYTE	01FH,000H+000H,00000000B+ONBK
;
	BYTE	02FH,0B0H+000H,00000000B+ONBK
	BYTE	02FH,0C0H+000H,00000000B+ONBK
	BYTE	039H,00000000B+OCM2+003H
;
	BYTE	05EH,00000111B
	BYTE	05FH,0A0H+001H,00000000B+OCRC
	BYTE	05FH,0B0H+000H,00000000B+OCTR
	BYTE	06FH,080H+000H,00000000B+OCTR
	BYTE	06FH,000H+000H,00000000B+ONBK
;
	BYTE	0AEH,00001011B
	BYTE	0AFH,070H+001H,00000000B+OCRC
	BYTE	0BFH,030H+000H,00000000B+ONBK
;
	BYTE	01EH,10000010B						; 1
	BYTE	01FH,020H+000H,00000000B+ONBK
	BYTE	01FH,0A0H+001H,00000000B+OCLC
	BYTE	01FH,070H+000H,00000000B+OCTL
;
	BYTE	06EH,10001000B						; 2
	BYTE	06FH,0A0H+001H,00000000B+OCRC
	BYTE	07FH,010H+000H,00000000B+ONBK
	BYTE	07FH,080H+000H,00000000B+OCTR
;
	BYTE	09EH,00000010B
	BYTE	09FH,020H+000H,00000000B+ONBK
	BYTE	09FH,0A0H+001H,00000000B+OCLC
	BYTE	09FH,080H+000H,00000000B+OCTL
;
	BYTE	00DH,004H						; 4
;
	BYTE	02EH,00001011B
	BYTE	02FH,0A0H+001H,00000000B+OCRC
	BYTE	03FH,010H+000H,00000000B+ONBK
	BYTE	03FH,070H+000H,00000000B+OCTR
;
	BYTE	03EH,00001011B
;;;;K;;;;	BYTE	03EH,00001111B
	BYTE	04FH,040H+000H,00000000B+ONBK
	BYTE	045H,00000000B+000H+OWC0	;;T;;
	BYTE	05FH,040H+002H,00000000B+OLBK
	BYTE	05FH,050H+000H,00000000B+ONBK
	BYTE	06FH,040H+002H,00000000B+OLBK
	BYTE	07FH,040H+002H,00000000B+OLBK
;
;
	BYTE	0EDH,00000000B+000H+SCOF
;
	BYTE	0FDH
;
;
;
	END
