;
	include		mn_hp_smram.asm
;
	 ORG	  0EC300H
		EXTEND
		IDX8
		MEM8
;
;
;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
;	 1986. 5.06	    V.1.0  Super Mario 2
;				   File name : SMFRDT
;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
;=========================================================== SMFRDT ==
	 GLB	  RDCD40
;
	 GLB	  FXCD19,FXCD37
	 GLB	  FXOD19,FXOD37
;=========================================================== SMDATA ==
;----------- ENMY DATA -----------------------------------------------
;---------------------------------------------------------------------
;=========================================================== SMMAIN ==
;=========================================================== SMINIT ==
;........................................................... ( Obst set corde )
	 EXT	  OLD0,OHL0,OCM0,OMS0,OCO0,OBK0,OBK1
	 EXT	  OPB0,OPB1,OPB2,OEW0,OEP0,OCS0,OWT0
	 EXT	  OBG0,OBG1,OBG2,OCM2,OBCO,OBC1,OBC2,OST0
	 EXT	  OBBM,OBBW,OBBS,OLW0,OWC0,OSK0,OCH0,OSL0
	 EXT	  OSP0,OWD0,OBOD,FCM1,FCM2
	 EXT	  OCM1,OCM3,OPL0,OGN0,OBMS,BGCH,OSCO,OSMS,OSBM
	 EXT	  SCOF,CSLP,SCON,SLON,ORBC,OBSM,ODMS,ODMT,OSDM
	 EXT	  JFST,WFST,EXOF,KZST,KZOF
	EXT	STTR,STST
	EXT	BRI0,BRI1,BRI2,OLBK
	EXT	OKID,ONBK,OCTL,OCTR,OCLC,OCRC,ORCK
;=========================================================== SMPLAY ==
	 EXT	  GRSTPD
;=========================================================== SMFRDT ==
	GLB	 URAINIT

	 GLB	  RDCRDT,RDCOSS,FRDAST,COURSD,CROSID
	 GLB	  CORS00,CORS01,CORS02,CORS03
	 GLB	  CORS04,CORS05,CORS06,CORS07
	 GLB	  CSFLDT
;=========================================================== SMENMY ==
;........................................................... ( Enemy kind No. )
	 EXT	  SHTR,BKTR,RDTR,TUTR
	 EXT	  FTR0,WTR0,WTR1
	 EXT	  FTR2,FTR6,FTR7,FLWR
	 EXT	  EXT0,EXT1,JFS0,EXFF
	 EXT	  ELP0,TMK0,BKF0
	 EXT	  BRG0,SST0,SST1,SST2,SST3,SST4,ESHP
	 EXT	  LFT0,LFT1,LFT2,LFT3,LFT4,LFT5,ELV0,ELV1
	 EXT	  GSHL,GFLG,BMUS,BWOD,FIEN
	 EXT	  IKTR,NOT1,YPVS,JPTR
	 EXT	  GIAL,LFT6
;
	 EXT	  FRW0,CFLG
;
	 EXT	  FREND,BKM0
	 EXT	  GRP0,GRP1,GRP2,GRP3,GRP4,GRP5,GRP6,GRP7
;
;=====================================================================
;
;
;
;############################################################################################
;#	 Fix chara out position data							    #
;############################################################################################
;
;		 +------+------+------+------+------+-----+
;	 FXCDxx	 I xx	xxxxxx I xxxx | xxxx I x xx xxxxx I
;	     ^^	 +------+------+------+------+------+-----+
;	     ||	    ^	   ^	   ^	  ^    ^  ^   ^
;	     ||	    |	   |	   |	  |    |  |   |
;	     ||	    |	   |	   |	  |    |  |   +----  Enemy No. or Environment No.
;	     ||	    |	   |	   |	  |    |  +--------  00:Sky	     01:Ground
;	     ||	    |	   |	   |	  |    |	     10:Underground  11:Underwater
;	     ||	    |	   |	   |	  |    +-----------  0:Enemy data  1:Environment data
;	     ||	    |	   |	   |	  +-  (y)pos-L
;	     ||	    |	   |	   +--------  (x)pos-L
;	     ||	    |	   +------  (x)pos-H  ( FF : End crode )
;	     ||	    +-------------  00:Out  11:No out
;	     |+---  Kind corde
;	     +----  0:Sky  1:Ground  2:Underground  3:Underwater
;
;#####################################################################
;#	 Fix chara out pos data	 ( Castle )			     #
;#####################################################################
;#####################################################################
;#	 Fix chara out pos data	 ( Ground )			     #
;#####################################################################
FXCD19	 EQU	  $	    ;< Ground - 9 >	 GOTO underground
;
FXCD30	 EQU	  $	    ;< Ground - 20 >		    ;<W1-2>
;
FXCD37	 EQU	  $	    ;< Ground - 27 >	 Return of Ground
;
;						;from underground-0
;						;from underground-3
	 BYTE	  0FFH
;
;
;############################################################################################
;#	 Fix obstacle out position data							    #
;############################################################################################
;
;		 +------+------+  +------+------+
;	 FXODxx	 I x xxx xxxxx I  I  xxx  xxxxx I
;	     ^^	 +------+------+  +------+------+
;	     ||	   ^  ^	   ^	      ^	    ^
;	     ||	   |  |	   |	      |	    |
;	     ||	   |  |	   |	      |	    |
;	     ||	   |  |	   |	      |	    |
;	     ||	   |  |	   |	      |	    +---  Floor display max loop
;	     ||	   |  |	   |	      +--------- Player start position data index
;	     ||	   |  |	   |
;	     ||	   |  |	   +------  Base BG environmen
;	     ||	   |  +-----------  Play farst base time
;	     ||	   +--------------  0:ON Floor	      1:OFF Floor
;	     ||
;	     ||	 +------+------+------+------+-----+-----+
;	     ||	 I x x	xxxxxx I xxxx | xxxx I xxxx|xxxx I
;	     ||	 +------+------+------+------+-----+-----+
;	     ||	   ^ ^	   ^	   ^	  ^	 ^    ^
;	     ||	   | |	   |	   |	  |	 |    |
;	     ||	   | |	   |	   |	  |	 |    +----  Obstacle display count
;	     ||	   | |	   |	   |	  |	 +---------  Obstacle kind No.
;	     ||	   | |	   |	   |	  +-  (y)pos-L	     F:BG environment change mode
;	     ||	   | |	   |	   +--------  (x)pos-L
;	     ||	   | |	   |
;	     ||	   | |	   +------  (x)pos-H  ( FF : End crode )
;	     ||	   | +------------  0:Floot length 1:Fix length
;	     ||	   |
;	     ||	   +--------  00:Out  11:No out
;	     ||
;	     |+---  Kind corde
;	     +----  0:Underwater 1:Ground  2:Underground  3:Castle
;
;#####################################################################
;#	 Fix obstacle out pos data  ( Castle )			     #
;#####################################################################
;#####################################################################
;#	 Fix obstacle out pos data  ( Ground )			     #
;#####################################################################
FXOD37	 EQU	  $	    ;< Ground - 27 >	    ;( Return of Ground )
	 BYTE	  10010000B,00110001B
;
	 BYTE	  039H,10000000B+OCM2+001H,0BFH,0F0H+007H,00000000B+OST0  : 1
;
	 BYTE	  033H,10000000B+OPB1+007H,0A3H,00000000B+OSCO+000H  : 2
	 BYTE	  0A7H,00000000B+OSCO+000H,0CDH,00000000B+000H+OPL0
;
	 BYTE	  00FH,0F0H+006H,10000000B+OCS0				  : 3
	 BYTE	  0EDH,00000000B+SCOF	    ; SCROLL STOP
;
	 BYTE	  0FDH
;
;
FXOD19	 EQU	  $	    ;< Ground - 9 >  ; GOTO UNDER
	 BYTE	  00111000B,00010001B
;
	 BYTE	  00FH,0F0H+006H,00000000B+OCS0				  : 0
	 BYTE	  0ADH,00000000B+OCM3+000H
;
	 BYTE	  03DH,10000000B+SCOF	    ; SCROLL STOP
	 BYTE	  0FDH						     : end
;
;
FXOD30	 EQU	  $	    ;< Ground - 20 >	  ;<W1-2>&;<W5-2>
;						;from underground - 0
;						;from underground - 3
	 BYTE	  00010000B,00000000B
;
	 BYTE	  00BH,00000000B+OLD0+003H			     : 0
	 BYTE	  05BH,00000000B+OLD0+004H,06AH,00000000B+OCO0+002H
	 BYTE	  0C7H,00000000B+OLD0+002H,0C6H,00000000B+OCO0+002H
;
	 BYTE	  01BH,10000000B+OLD0+004H,02AH,00000000B+OCO0+002H  : 1
	 BYTE	  053H,00000000B+OLD0+003H,062H,00000000B+OCO0+001H
	 BYTE	  097H,00000000B+OLD0+007H,0A6H,00000000B+OCO0+005H
;
	 BYTE	  06EH,10000001B				     : 2
	 BYTE	  08FH,0F0H+007H,00000000B+OST0
;
	 BYTE	  002H,10000000B+OPB1+008H			     : 3
	 BYTE	  012H,00000000B+OBK1+00AH
	 BYTE	  068H,00000000B+OCM0+002H
;
	 BYTE	  0E0H,00000000B+OPB1+00AH			     : 3
	 BYTE	  0F0H,00000000B+OPB1+00AH			     : 3
;;;	    BYTE     0DEH,00001111B
;
	 BYTE	  06DH,10000000B+000H+SLON			     : 4
	 BYTE	  000H,00000000B+OPB1+00AH			     : 3
;
	 BYTE	  0FDH
;
;
;
;=====================================================================
;
;
BOGD	 EQU	  01H
BCS1	 EQU	  01H
BCS2	 EQU	  01H
BCS4	 EQU	  01H
;#####################################################################
;#		  CORSNO -- Course No.				     #
;#		  CORSID -- Course index			     #
;#	 JSR	  RDCRDT    [ Read course data ]		     #
;#		  <ENVRFG -- Next environment value		     #
;#		  TRNPT0 --		     frame information data  #			#
;#####################################################################
RDCRDT	 EQU	  $
	PHB
	PHK
	PLB
;
	 JSL	  >RDCOSS		; Read course data
	 STA	  TRNPT0
;
RDCD40	 EQU	  $
	 AND	  #01100000B
	 ASL	  A
	 ROL	  A
	 ROL	  A
	 ROL	  A
	 STA	  <ENVRFG		; <ENVRFG <-- Environment set
	 STA	  <KDVRFG		; <ENVRFG <-- Environment set
;	LDA	CORSNO
;	CMP	#8H
;	BNE	RDCD45
;	LDA	CORSID
;	CMP	#02H
;	BNE	RDCD45
;	LDA	#1
 ;	  STA	   <ENVRFG		 ; <ENVRFG <-- Environment set
 ;	  STA	   <KDVRFG		 ; <ENVRFG <-- Environment set
;RDCD45 EQU	$
	LDA	CORSNO
	CMP	#7
	BNE	RDCD50
	LDA	CORSID
	CMP	#03
	BNE	RDCD50
	LDA	#3
	STA	<KDVRFG
RDCD50	EQU	$
;
	PLB
	 RTL
;
;#####################################################################
;#	 JSR	  RDCOSS    [ Read course data sub ]		     #
;#####################################################################
RDCOSS	 EQU	  $
	PHB
	PHK
	PLB
;
	 LDY	  CORSNO
		CPY	#00DH
		BCC	RDCOSS_10		; course no. reset ?
;						; yes
		STZ	!CORSID
		STZ	!GOALCT
		LDY	#00000000B
		STY	!CORSNO
RDCOSS_10	EQU	$
	 LDA	  CROSID,Y
	 CLC
	 ADC	  CORSID
	 TAY
;
	 LDA	  COURSD,Y
;
	PLB
	 RTL
;
;*********************************************************************
;*		  TRNPT0 --		     frame information data  *			*
;*	 JSR	  FRDAST    [ Frame data address set ]		     *
;*********************************************************************
TRNPCK	EQU	$
	PHA
	LDA	CORSNO
	CMP	#9
	BCC	SUR099
	LDA	TRNPT0
	AND	#01100000B
	CMP	#20H
	BNE	SUR099
	PLA
	CMP	#1FH
	BEQ	SURRT2
	CMP	#1EH
	BEQ	SURRT3
	CLC
	ADC	#1DH
	BRA	SURRET
SUR099	EQU	$
	PLA
SURRET	EQU	$
	RTS
SURRT2	EQU	$
	LDA	#9
	RTS
SURRT3	EQU	$
	LDA	#1BH
	RTS
;
FRDAST	 EQU	  $
	PHB
	PHK
	PLB
;
	 LDA	  TRNPT0
;;;;;	      JSR      RDCD40		    ; <ENVRFG <-- Environment set
	 AND	  #01100000B
	 ASL	  A
	 ROL	  A
	 ROL	  A
	 ROL	  A
	 STA	  <ENVRFG		; <ENVRFG <-- Environment set
	 STA	  <KDVRFG		; <ENVRFG <-- Environment set
	 TAY
;	LDA	CORSNO
;	CMP	#8H
;	BNE	RD0045
;	LDA	CORSID
;	CMP	#02H
;	BNE	RD0045
;	LDA	#1
 ;	  STA	   <ENVRFG		 ; <ENVRFG <-- Environment set
  ;	  STA	   <KDVRFG		 ; <ENVRFG <-- Environment set
;	TAY
;RD0045 EQU	$
	LDA	CORSNO
	CMP	#7
	BNE	RDCD5X
	LDA	CORSID
	CMP	#03
	BNE	RDCD5X
	LDA	#3
	STA	<KDVRFG
RDCD5X	EQU	$
;
	 LDA	  TRNPT0
	 AND	  #00011111B
	JSR	TRNPCK
	 STA	  ENVRID	       ; ENVRID <-- Environment index set
;
	 LDA	  FCAIDD,Y	  ; Fix pos chara data address set !
	 CLC
	 ADC	  ENVRID
;;	ASL	A	;;T
	 TAY
;
	LDA	FCODA0,Y
	STA	<FXCDA0
	LDA	FCODA1,Y
	STA	<FXCDA0+1
	LDA	#BANK FCODA1
	STA	<FXCDA0+2		; FXCDA0 <-- Fix chara data address (L),(H),(B)
;
	LDY	<ENVRFG
	LDA	FOAIDD,Y
	CLC
	ADC	ENVRID
;;	ASL	A	;;T
	TAY
	STA	<BG2COS
;;	CMP	#1CH
;;	BCS	FDAS13
;;	CMP	#19H
;;	BCS	FDAS12
;;	CMP	#03H
;;	BCS	FDAS11
;;	CMP	#02H
;;	BCC	FDAS10
;;FDAS13	EQU	$
;;	INC	<KDVRFG
;;FDAS12	EQU	$
;;	INC	<KDVRFG
;;FDAS11	EQU	$
;;	INC	<KDVRFG
;;FDAS10	EQU	$
;
	LDA	FOODA0,Y
	STA	<FXODA0
	LDA	FOODA1,Y
	STA	<FXODA0+1
	LDA	#BANK FOODA1
	STA	<FXODA0+2		; <FXODA0 <-- Fix obst data address (L),(H),(B)
;
	LDY	#00H			; Read	frame set sub data !
	LDA	[<FXODA0],Y
	PHA
	AND	#00000111B
	CMP	#00000100B
	BCC	FDAS20			; color ?
;					; yes
	STA	NIGTFG			; color flag set
	LDA	#00H
FDAS20	EQU	$
	STA	BBGFG0			; BG. environment flag set
;
	PLA
	PHA
	AND	#00111000B
	LSR	A
	LSR	A
	LSR	A
	STA	PLFPFG			; player start position set
;
	PLA
	AND	 #11000000B
	CLC
	ROL	A
	ROL	A
	ROL	A
	STA	PYGMTM			; time set
;
	INY
	LDA	[<FXODA0],Y
	PHA
	AND	#00001111B
	STA	FLRNO			; floor no. set
;
	PLA
	PHA
	AND	#00110000B
	LSR	A
	LSR	A
	LSR	A
	LSR	A
	STA	BBGFG1			; BG. set
;
	PLA
	AND	#11000000B
	CLC
	ROL	A
	ROL	A
	ROL	A
	CMP	#00000011B
	BNE	FDAS40			; sky ?
;					; yes
	STA	SKYFLG			; sky flag set
	LDA	#00H
FDAS40	EQU	$
	STA	OBSTFG			; chara. change flag set
	JSR	SFGSET
;
	LDA	<FXODA0
	CLC
	ADC	#02H
	STA	<FXODA0
;
	LDA	<FXODA0+1
	ADC	#00H
	STA	<FXODA0+1		; next pointer set
FDAS90	EQU	$
;
	STZ	BSBGMT
	PLB
	RTL
;
SFGSET	EQU	$
	LDA	SKYFLG
	BNE	SFG050
	LDA	<BG2COS
	CMP	#23H
	BEQ	SFG040
	CMP	#22H
	BEQ	SFG050
	BRA	SFG090
SFG040	EQU	$
	LDA	<SCCH1
	BNE	SFG090
SFG050	EQU	$
	LDA	#1
	STA	WDSTFG
SFG090	EQU	$
	RTS
;
;#####################################################################
;#	 Course data						     #
;#####################################################################
;
;		  +------+------+
;	 CORSxx	  I x xx  xxxxx I
;		  +------+------+
;		    ^  ^    ^
;		    |  |    +------  Environment data No. ( 00H - 1FH )
;		       +-----------  00:Underwater  01:Ground  10:Underground  11:Castle
;
CROSID	 EQU	  $	    ;< Course table index >
	 BYTE	  CORS00-COURSD	       : Course-0 : (W-1)
	 BYTE	  CORS01-COURSD	       :       -1 : (W-2)
	 BYTE	  CORS02-COURSD	       :       -2 : (W-3)
	 BYTE	  CORS03-COURSD	       :       -3 : (W-4)
	 BYTE	  CORS04-COURSD	       :       -4 : (W-5)
	 BYTE	  CORS05-COURSD	       :       -5 : (W-6)
	 BYTE	  CORS06-COURSD	       :       -6 : (W-7)
	 BYTE	  CORS07-COURSD	       :       -7 : (W-8)
	 BYTE	  CORS08-COURSD	       :       -8 : (W-9)
	 BYTE	  CORS0A-COURSD	       :       -A : (W-A)
	 BYTE	  CORS0B-COURSD	       :       -B : (W-B)
	 BYTE	  CORS0C-COURSD	       :       -C : (W-C)
	 BYTE	  CORS0D-COURSD	       :       -D : (W-D)
;
COURSD	 EQU	  $	    ;< Course data >
CORS00	 EQU	  $
;1 COUSE		0      v      1	     v	    2	   v	  3
	 BYTE	  00100000B+00H,00100000B+09H,01000000B+00H,00100000B+01H
	 BYTE	  01100000B+00H
;
CORS01	 EQU	  $
;2 COUSE		0      v      1	     v	    2	   v	  3
	 BYTE	  00100000B+02H,00100000B+03H,00100000B+04H,01100000B+01H
;
CORS02	 EQU	  $
;3 COUSE		0      v      1	     v	    2	   v	  3
	 BYTE	  00100000B+05H,00100000B+09H,00000000B+00H,00100000B+06H
	 BYTE	  01100000B+02H
;
CORS03	 EQU	  $
;4 COUSE		0      v      1	     v	    2	   v	  3
	 BYTE	  00100000B+07H,00100000B+08H,00100000B+0AH,01100000B+03H
;
CORS04	 EQU	  $
;5 COUSE		0      v      1	     v	    2	   v	  3
	 BYTE	  00100000B+0BH,00100000B+09H,01000000B+03H,00100000B+0CH
	 BYTE	  01100000B+04H
;
CORS05	 EQU	  $
;6 COUSE		0      v      1	     v	    2	   v	  3
	 BYTE	  00100000B+0DH,00100000B+09H,00000000B+01H,00100000B+0EH
	 BYTE	  01100000B+05H
;
CORS06	 EQU	  $
;7 COUSE		0      v      1	     v	    2	   v	  3
	 BYTE	  00100000B+0FH,00100000B+10H,00100000B+11H,01100000B+06H
;
CORS07	 EQU	  $
;8 COUNSE		0      v      1	     v	    2	   v	  3
	 BYTE	  00100000B+12H,00100000B+15H,00100000B+16H,01100000B+07H
;
CORS08	 EQU	  $
;9 COUNSE		0      v      1	     v	    2	   v	  3
	 BYTE	  00100000B+18H,00000000B+06H,01100000B+08H,00000000B+07H
CORS0A	 EQU	  $
;A COUSE		0      v      1	     v	    2	   v	  3
	 BYTE	  00100000B+00H,00100000B+1FH,01000000B+05H,00100000B+01H
	 BYTE	  01100000B+0AH
;
CORS0B	 EQU	  $
;B COUSE		0      v      1	     v	    2	   v	  3
	 BYTE	  00100000B+02H,00100000B+1FH,00000000B+08H,00100000B+03H
	 BYTE	  01100000B+0BH
;
CORS0C	 EQU	  $
;C COUSE		0      v      1	     v	    2	   v	  3
	 BYTE	  00100000B+04H,00100000B+05H,00100000B+06H,01100000B+0CH
;
CORS0D	 EQU	  $
;D COUSE		0      v      1	     v	    2	   v	  3
	 BYTE	  00100000B+07H,00100000B+08H,00100000B+09H,01100000B+0DH
;
;
;#####################################################################
;#	 Fix chara out position data address			     #
;#####################################################################
CSFLDT	 EQU	  $	      ;Castle frame loop data
	 BYTE	  DA01				   ; 0 dammy (W3-4:1)
	 BYTE	  DA01				   ; 1	     (W3-4:1)
;
	 BYTE	  DA02				   ; 2 dammy (W3-4:2)
	 BYTE	  DA02				   ; 3	     (W3-4:2)
;
	 BYTE	  DA03				   ; 4 dammy (W6-4:1)
	 BYTE	  DA03				   ; 5	     (W6-4:1)
;
	 BYTE	  DA04				   ; 6 dammy (W6-4:2)
	 BYTE	  DA04				   ; 7	     (W6-4:2)
;
	 BYTE	  DA05				   ; 8	     (W7-2:1)
;
	 BYTE	  DA07				   ; 9	     (W8-4:1)
;
	 BYTE	  DA08				   ; A	     (W8-4:2)
;
	 BYTE	  DA10				   ; B	     (W5-3:3)
;
;
;
;
FCAIDD	 EQU	  $		  ;< Fix out chara data address index >
	 BYTE	  UWC0L-FCODA0;)/2	   : Underwater
	 BYTE	  GDC0L-FCODA0;)/2	   : Ground
	 BYTE	  UGC0L-FCODA0;)/2	   : Underground
	 BYTE	  CSC0L-FCODA0;)/2	   : SHIRO
;
;
FCODA0	 EQU	  $
CSC0L	 EQU	  $	    ; Shiro
	 BYTE	  (FXCD00)&0FFH,(FXCD01)&0FFH,(FXCD02)&0FFH,(FXCD03)&0FFH  ;00
	 BYTE	  (FXCD04)&0FFH,(FXCD05)&0FFH,(FXCD06)&0FFH,(FXCD07)&0FFH  ;04
	 BYTE	  (FXCD08)&0FFH,(FXCD09)&0FFH				   ;08
	 BYTE	  (FXED00)&0FFH,(FXED01)&0FFH,(FXED02)&0FFH,(FXED03)&0FFH  ;0A
;
GDC0L	 EQU	  $	    ; Ground	;0E
	 BYTE	  (FXCD10)&0FFH,(FXCD11)&0FFH,(FXCD12)&0FFH,(FXCD13)&0FFH  ;0E
	 BYTE	  (FXCD14)&0FFH,(FXCD15)&0FFH,(FXCD16)&0FFH,(FXCD17)&0FFH  ;12
	 BYTE	  (FXCD18)&0FFH,(FXCD19)&0FFH,(FXCD20)&0FFH,(FXCD21)&0FFH  ;16
	 BYTE	  (FXCD22)&0FFH,(FXCD23)&0FFH,(FXCD24)&0FFH,(FXCD25)&0FFH  ;1A
	 BYTE	  (FXCD26)&0FFH,(FXCD27)&0FFH,(FXCD28)&0FFH,(FXCD29)&0FFH  ;1E
	 BYTE	  (FXCD30)&0FFH,(FXCD31)&0FFH,(FXCD32)&0FFH,(FXCD33)&0FFH  ;22
	 BYTE	  (FXCD34)&0FFH,(FXCD35)&0FFH,(FXCD36)&0FFH,(FXCD37)&0FFH  ;26
	 BYTE	  (FXCD38)&0FFH						   ;2A
	 BYTE	  (FXED10)&0FFH,(FXED11)&0FFH,(FXED12)&0FFH,(FXED13)&0FFH  ;2B
	 BYTE	  (FXED14)&0FFH,(FXED15)&0FFH,(FXED16)&0FFH,(FXED17)&0FFH  ;2F
	 BYTE	  (FXED18)&0FFH,(FXED19)&0FFH,(FXED20)&0FFH,(FXED21)&0FFH  ;33
;
UGC0L	 EQU	  $	    ; Underground
	 BYTE	  (FXCD40)&0FFH,(FXCD41)&0FFH,(FXCD42)&0FFH,(FXCD43)&0FFH  ;37
	 BYTE	  (FXCD44)&0FFH						   ;3B
	 BYTE	  (FXED40)&0FFH,(FXED41)&0FFH				   ;3C
;
UWC0L	 EQU	  $	    ; Underwater;
	 BYTE	  (FXCD50)&0FFH,(FXCD51)&0FFH,(FXCD52)&0FFH,(FXCD53)&0FFH  ;3E
	 BYTE	  (FXCD54)&0FFH,(FXCD55)&0FFH,(FXCD56)&0FFH,(FXCD57)&0FFH  ;42
	 BYTE	  (FXED50)&0FFH						   ;46
;
;
;
;
FCODA1	 EQU	  $
CSC0H	 EQU	  $	    ; Shiro
	 BYTE	  (FXCD00)/100H,(FXCD01)/100H,(FXCD02)/100H,(FXCD03)/100H
	 BYTE	  (FXCD04)/100H,(FXCD05)/100H,(FXCD06)/100H,(FXCD07)/100H
	 BYTE	  (FXCD08)/100H,(FXCD09)/100H
	 BYTE	  (FXED00)/100H,(FXED01)/100H,(FXED02)/100H,(FXED03)/100H
;
GDC0H	 EQU	  $	    ; Ground
	 BYTE	  (FXCD10)/100H,(FXCD11)/100H,(FXCD12)/100H,(FXCD13)/100H
	 BYTE	  (FXCD14)/100H,(FXCD15)/100H,(FXCD16)/100H,(FXCD17)/100H
	 BYTE	  (FXCD18)/100H,(FXCD19)/100H,(FXCD20)/100H,(FXCD21)/100H
	 BYTE	  (FXCD22)/100H,(FXCD23)/100H,(FXCD24)/100H,(FXCD25)/100H
	 BYTE	  (FXCD26)/100H,(FXCD27)/100H,(FXCD28)/100H,(FXCD29)/100H
	 BYTE	  (FXCD30)/100H,(FXCD31)/100H,(FXCD32)/100H,(FXCD33)/100H
	 BYTE	  (FXCD34)/100H,(FXCD35)/100H,(FXCD36)/100H,(FXCD37)/100H
	 BYTE	  (FXCD38)/100H
	 BYTE	  (FXED10)/100H,(FXED11)/100H,(FXED12)/100H,(FXED13)/100H
	 BYTE	  (FXED14)/100H,(FXED15)/100H,(FXED16)/100H,(FXED17)/100H
	 BYTE	  (FXED18)/100H,(FXED19)/100H,(FXED20)/100H,(FXED21)/100H
;
UGC0H	 EQU	  $	    ; Underground
	 BYTE	  (FXCD40)/100H,(FXCD41)/100H,(FXCD42)/100H,(FXCD43)/100H
	 BYTE	  (FXCD44)/100H
	 BYTE	  (FXED40)/100H,(FXED41)/100H
;
UWC0H	 EQU	  $	    ; Underwater
	 BYTE	  (FXCD50)/100H,(FXCD51)/100H,(FXCD52)/100H,(FXCD53)/100H
	 BYTE	  (FXCD54)/100H,(FXCD55)/100H,(FXCD56)/100H,(FXCD57)/100H
	 BYTE	  (FXED50)/100H
;
;
;
;#####################################################################
;#	 Fix out obstacle data address				     #
;#####################################################################
FOAIDD	 EQU	  $		  ;< Fix out obstacle data address index >
	 BYTE	  UWO0L-FOODA0;)/2	   : Underwater
	 BYTE	  GDO0L-FOODA0;)/2	   : Ground
	 BYTE	  UGO0L-FOODA0;)/2	   : Underground
	 BYTE	  CSO0L-FOODA0;)/2	   : SHIRO
;
;
FOODA0	 EQU	  $		  ;< Fix pos obstacle data address-L >
CSO0L	 EQU	  $	    ; Shiro
	 BYTE	  (FXOD00)&0FFH,(FXOD01)&0FFH,(FXOD02)&0FFH,(FXOD03)&0FFH
	 BYTE	  (FXOD04)&0FFH,(FXOD05)&0FFH,(FXOD06)&0FFH,(FXOD07)&0FFH
	 BYTE	  (FXOD08)&0FFH,(FXOD09)&0FFH
	 BYTE	  (FXBD00)&0FFH,(FXBD01)&0FFH,(FXBD02)&0FFH,(FXBD03)&0FFH
;
GDO0L	 EQU	  $	    ; Ground
	 BYTE	  (FXOD10)&0FFH,(FXOD11)&0FFH,(FXOD12)&0FFH,(FXOD13)&0FFH
	 BYTE	  (FXOD14)&0FFH,(FXOD15)&0FFH,(FXOD16)&0FFH,(FXOD17)&0FFH
	 BYTE	  (FXOD18)&0FFH,(FXOD19)&0FFH,(FXOD20)&0FFH,(FXOD21)&0FFH
	 BYTE	  (FXOD22)&0FFH,(FXOD23)&0FFH,(FXOD24)&0FFH,(FXOD25)&0FFH
	 BYTE	  (FXOD26)&0FFH,(FXOD27)&0FFH,(FXOD28)&0FFH,(FXOD29)&0FFH
	 BYTE	  (FXOD30)&0FFH,(FXOD31)&0FFH,(FXOD32)&0FFH,(FXOD33)&0FFH
	 BYTE	  (FXOD34)&0FFH,(FXOD35)&0FFH,(FXOD36)&0FFH,(FXOD37)&0FFH
	 BYTE	  (FXOD38)&0FFH
	 BYTE	  (FXBD10)&0FFH,(FXBD11)&0FFH,(FXBD12)&0FFH,(FXBD13)&0FFH
	 BYTE	  (FXBD14)&0FFH,(FXBD15)&0FFH,(FXBD16)&0FFH,(FXBD17)&0FFH
	 BYTE	  (FXBD18)&0FFH,(FXBD19)&0FFH,(FXBD20)&0FFH,(FXBD21)&0FFH
;
UGO0L	 EQU	  $	    ; Underground
	 BYTE	  (FXOD40)&0FFH,(FXOD41)&0FFH,(FXOD42)&0FFH,(FXOD43)&0FFH
	 BYTE	  (FXOD44)&0FFH
	 BYTE	  (FXBD40)&0FFH,(FXBD41)&0FFH
;
UWO0L	 EQU	  $	    ; Underwater
	 BYTE	  (FXOD50)&0FFH,(FXOD51)&0FFH,(FXOD52)&0FFH,(FXOD53)&0FFH
	 BYTE	  (FXOD54)&0FFH,(FXOD55)&0FFH,(FXOD56)&0FFH,(FXOD57)&0FFH
	 BYTE	  (FXBD50)&0FFH
;
;
;
;
FOODA1	 EQU	  $		  ; Fix pos obstacle data address-L !
CSO0H	 EQU	  $	    ; Shiro
	 BYTE	  (FXOD00)/100H,(FXOD01)/100H,(FXOD02)/100H,(FXOD03)/100H
	 BYTE	  (FXOD04)/100H,(FXOD05)/100H,(FXOD06)/100H,(FXOD07)/100H
	 BYTE	  (FXOD08)/100H,(FXOD09)/100H
	 BYTE	  (FXBD00)/100H,(FXBD01)/100H,(FXBD02)/100H,(FXBD03)/100H
;
GDO0H	 EQU	  $	    ; Ground
	 BYTE	  (FXOD10)/100H,(FXOD11)/100H,(FXOD12)/100H,(FXOD13)/100H
	 BYTE	  (FXOD14)/100H,(FXOD15)/100H,(FXOD16)/100H,(FXOD17)/100H
	 BYTE	  (FXOD18)/100H,(FXOD19)/100H,(FXOD20)/100H,(FXOD21)/100H
	 BYTE	  (FXOD22)/100H,(FXOD23)/100H,(FXOD24)/100H,(FXOD25)/100H
	 BYTE	  (FXOD26)/100H,(FXOD27)/100H,(FXOD28)/100H,(FXOD29)/100H
	 BYTE	  (FXOD30)/100H,(FXOD31)/100H,(FXOD32)/100H,(FXOD33)/100H
	 BYTE	  (FXOD34)/100H,(FXOD35)/100H,(FXOD36)/100H,(FXOD37)/100H
	 BYTE	  (FXOD38)/100H
	 BYTE	  (FXBD10)/100H,(FXBD11)/100H,(FXBD12)/100H,(FXBD13)/100H
	 BYTE	  (FXBD14)/100H,(FXBD15)/100H,(FXBD16)/100H,(FXBD17)/100H
	 BYTE	  (FXBD18)/100H,(FXBD19)/100H,(FXBD20)/100H,(FXBD21)/100H
;
UGO0H	 EQU	  $	    ; Underground
	 BYTE	  (FXOD40)/100H,(FXOD41)/100H,(FXOD42)/100H,(FXOD43)/100H
	 BYTE	  (FXOD44)/100H
	 BYTE	  (FXBD40)/100H,(FXBD41)/100H
;
UWO0H	 EQU	  $	    ; Underwater
	 BYTE	  (FXOD50)/100H,(FXOD51)/100H,(FXOD52)/100H,(FXOD53)/100H
	 BYTE	  (FXOD54)/100H,(FXOD55)/100H,(FXOD56)/100H,(FXOD57)/100H
	 BYTE	  (FXBD50)/100H
;
;
;*********************************************************************
;*	 Ura-world data initial set		   (URAINIT)	     *
;*********************************************************************
URRSTDT	 EQU	  $		  ;ura-world re-start point data
	 HEX	  76,50		  ;W-A
	 HEX	  65,50		  ;W-B
	 HEX	  75,B0		  ;W-C
	 HEX	  00,00		  ;W-D
UREND	 EQU	  $
;
;
URAINIT	 EQU	  $
	 LDY	  #UREND-URRSTDT-1
URAIT40	 EQU	  $
	 LDA	  URRSTDT,Y
	 STA	  !GRSTPD,Y
	 DEY
	 BPL	  URAIT40	  ;set end ?
;				  ;yes
	 RTS
;
;############################################################################################
;#	 Fix chara out position data							    #
;############################################################################################
;
;		 +------+------+------+------+------+-----+
;	 FXCDxx	 I xx	xxxxxx I xxxx | xxxx I x xx xxxxx I
;	     ^^	 +------+------+------+------+------+-----+
;	     ||	    ^	   ^	   ^	  ^    ^  ^   ^
;	     ||	    |	   |	   |	  |    |  |   |
;	     ||	    |	   |	   |	  |    |  |   +----  Enemy No. or Environment No.
;	     ||	    |	   |	   |	  |    |  +--------  00:Sky	     01:Ground
;	     ||	    |	   |	   |	  |    |	     10:Underground  11:Underwater
;	     ||	    |	   |	   |	  |    +-----------  0:Enemy data  1:Environment data
;	     ||	    |	   |	   |	  +-  (y)pos-L
;	     ||	    |	   |	   +--------  (x)pos-L
;	     ||	    |	   +------  (x)pos-H  ( FF : End crode )
;	     ||	    +-------------  00:Out  11:No out
;	     |+---  Kind corde
;	     +----  0:Sky  1:Ground  2:Underground  3:Underwater
;
;#####################################################################
;#	 Fix chara out pos data	 ( Castle )			     #
;#####################################################################
FXCD00	 EQU	  $	    ;< Castle - 00 >		    / W 1 - 4 /
	 BYTE	  035H,10000000B+SST2				     : 1
;
	 BYTE	  055H,10000000B+SST0,0C9H,00000000B+SST0	     : 2
;
	 BYTE	  059H,10000000B+SST2				     : 3
;
	 BYTE	  045H,10000000B+SST0,0C5H,00000000B+SST0	     : 4
;
	 BYTE	  026H,10000000B+SHTR,045H,00000000B+SST0	     : 5
	 BYTE	  0B9H,00000000B+SST2,0F0H,00000000B+BKF0
;
	 BYTE	  059H,10000000B+SST2				     : 6
;
	 BYTE	  00FH,008H					     : 8
	 BYTE	  078H,00000000B+BKM0,096H,00000000B+LFT4
;
	 BYTE	  090H,10000000B+GIAL				     : 9
;
	 BYTE	  0FFH
;
;
FXCD01	 EQU	  $	    ;< Castle - 01 >		    / W 2 - 4 /
	 BYTE	  074H,10000000B+SHTR,0F0H,00000000B+GRP1	     : 1
;
	 BYTE	  0A0H,10000000B+GRP4				     : 2
;
	 BYTE	  040H,10000000B+GRP5,08CH,00000000B+SST2	     : 3
;
	 BYTE	  0C9H,10000000B+SST2				     : 4
;
	 BYTE	  005H,10000000B+SST0,01CH,00000000B+JPTR	     : 5
	 BYTE	  059H,00000000B+SST0,0B5H,00000000B+SST2
;
	 BYTE	  02CH,10000000B+JPTR				     : 6
	 BYTE	  040H,00000000B+BKF0
	 BYTE	  07CH,00000000B+SST0,0DCH,00000000B+SST2
;
	 BYTE	  06CH,10000000B+JPTR,0BCH,00000000B+JPTR	     : 7
;
	 BYTE	  078H,10000000B+BKM0,0A5H,00000000B+LFT4	     : 8
;
	 BYTE	  090H,10000000B+GIAL				     : 9
;
	 BYTE	  0FFH
;
;
FXCD02	 EQU	  $	    ;< Castle - 02 >		    / W 3 - 4 /
	 BYTE	  00FH,004H
	 BYTE	  09CH,00000000B+JPTR				     : 4
;
	 BYTE	  00FH,007H
	 BYTE	  0C5H,00000000B+SST0				     : 7
;
	 BYTE	  065H,10000000B+SST2				     : 8
;
	 BYTE	  049H,10000000B+SST2				     : 9
;
	 BYTE	  05CH,10000000B+JPTR,078H,00000000B+BKM0	     : A
;
	 BYTE	  090H,10000000B+GIAL				     : B
;
	 BYTE	  0FFH
;
;
FXCD03	 EQU	  $	    ;< Castle - 03 >		    / W 4 - 4 /
	 BYTE	  049H,10000000B+SST4,067H,00000000B+TUTR	     : 1
;
	 BYTE	  079H,10000000B+SST2,0A0H,00000000B+GRP3	     : 2
;
	 BYTE	  057H,10000000B+SST4,0BBH,00000000B+SST2	     : 3
	 BYTE	  0D5H,00000000B+LFT1
;
	 BYTE	  00FH,005H
	 BYTE	  018H,00000000B+SST2,074H,00000000B+SHTR	     : 5
	 BYTE	  084H,00000000B+SHTR,094H,00000000B+SHTR
	 BYTE	  0C6H,00000000B+LFT5
;
	 BYTE	  049H,10000000B+SST2,0DBH,00000000B+FIEN	     : 6
;
	 BYTE	  00FH,008H					     : 8
	 BYTE	  005H,10000000B+SST0,009H,00000000B+SST2
	 BYTE	  0B0H,00000000B+GRP1
;
	 BYTE	  080H,10000000B+BKF0,0C0H,00000000B+GRP5	     : 9
;
	 BYTE	  0ECH,10000000B+LFT4				     : A
;
	 BYTE	  0CCH,10000000B+JPTR				     : B
;
	 BYTE	  04AH,10000000B+SST0				     : C
	 BYTE	  078H,00000000B+BKM0
;
	 BYTE	  090H,10000000B+GIAL				     : D
;
	 BYTE	  0FFH
;
;
;#####################################################################
;#	 Fix chara out pos data	 ( Ground )			     #
;#####################################################################
FXCD10	 EQU	  $	    ;< Ground - 0 >		    / W 1 - 1 /
	 BYTE	  007H,10000000B+FTR2,047H,00000000B+TUTR	     : 1
;;;;;	      BYTE     09EH,00110011B,00000000B	 ;NEXT GOTO Ground-19(SKY)
;
	 BYTE	  00FH,003H					     : 3
	 BYTE	  010H,00000000B+GRP1
;
	 BYTE	  01BH,10000000B+SHTR				     : 4
	 BYTE	  053H,00000000B+YPVS,077H,00000000B+FTR2
;
	 BYTE	  083H,10000000B+TUTR,0A0H,00000000B+GRP6	     : 5
	 BYTE	  090H,00000000B+GRP4
;
	 BYTE	  090H,10000000B+GRP0				     : 6
;
	 BYTE	  060H,10000000B+GRP5,0B7H,00000000B+FTR2	     : 7
	 BYTE	  0EEH,01000010B,00000000B   ;NEXT GOTO Underground-2 (Bonus-1)
;
	 BYTE	  0F7H,10000000B+SHTR				     : 8
;
	 BYTE	  06BH,10000000B+TUTR				     : 9
;
	 BYTE	  01BH,10000000B+TUTR,0ABH,00000000B+YPVS	     : A
;
	 BYTE	  0FFH
;
;
FXCD11	 EQU	  $	    ;< Ground - 1 >		    / W 1 - 3 /
	 BYTE	  096H,10000000B+LFT0,0F9H,00000000B+LFT0	     : 1
;
	 BYTE	  0D3H,10000000B+TUTR				     : 2
;
	 BYTE	  03AH,10000000B+TUTR,05AH,00000000B+TUTR	     : 3
	 BYTE	  095H,00000000B+IKTR,0F4H,00000000B+FTR6
;
	 BYTE	  069H,10000000B+LFT4				     : 4
;
	 BYTE	  033H,10000000B+IKTR
	 BYTE	  086H,00000000B+LFT0,0C9H,00000000B+LFT0	     : 5
;
	 BYTE	  04BH,10000000B+TUTR				     : 6
;
	 BYTE	  067H,10000000B+TUTR				     : 7
;
	 BYTE	  017H,10000000B+TUTR,056H,00000000B+LFT4	     : 8
	 BYTE	  095H,00000000B+LFT0
;
	 BYTE	  00AH,10000000B+LFT0				     : 9
;
	 BYTE	  0FFH
;
;
FXCD12	 EQU	  $	    ;< Ground - 2 >		    / W 2 - 1 /
	 BYTE	  00FH,002H
	 BYTE	  047H,00000000B+FTR2,087H,00000000B+FTR2	     : 2
	 BYTE	  0C7H,00000000B+FTR2,0F7H,00000000B+FTR2
;
	 BYTE	  027H,10000000B+FTR2
	 BYTE	  0EEH,01000010B,00100101B  ;NEXT GOTO Underground-2 (Bonus-3) : 3
;
	 BYTE	  00FH,006H					     : 6
	 BYTE	  0ACH,00000000B+LFT4
;
	 BYTE	  08CH,10000000B+LFT4				     : 7
;
	 BYTE	  04EH,10110011B,00100000B  ;NEXT GOTO Ground-19(SKY): 8
;
	 BYTE	  08BH,10000000B+FTR2				     : 9
;
	 BYTE	  0F7H,10000000B+FTR7				     : A
;
	 BYTE	  036H,10000000B+FTR7				     : B
;
	 BYTE	  0E5H,10000000B+FTR2				     : C
;
	 BYTE	  032H,10000000B+FTR2,0C2H,00000000B+YPVS	     : D
	 BYTE	  0D2H,00000000B+YPVS,0E2H,00000000B+YPVS
;
	 BYTE	  0FFH
;
;
;
FXCD13	 EQU	  $	    ;< Ground - 3 >		    / W 2 - 2 /
	 BYTE	  015H,10000000B+FTR2,09BH,00000000B+YPVS	     : 1
	 BYTE	  0E0H,00000000B+GRP0
;
	 BYTE	  080H,10000000B+GRP5				     : 2 *
;
	 BYTE	  00FH,004H
	 BYTE	  02BH,00000000B+GRP4,0ABH,00000000B+FTR2	     : 4
	 BYTE	  0EBH,00000000B+FTR2
;
	 BYTE	  00FH,006H
	 BYTE	  0F0H,00000000B+GRP0				     : 6
;
	 BYTE	  04BH,10000000B+FTR2				     : 7
;
	 BYTE	  06BH,10000000B+SHTR,0BBH,00000000B+GRP5	     : 8
;
	 BYTE	  04BH,10000000B+GRP4				     : 9
	 BYTE	  0EEH,01000010B,00100000B   ;NEXT GOTO Underground-2 (Bonus-1)
;
	 BYTE	  01BH,10000000B+GRP5,0CBH,00000000B+SHTR	     : A
;
	 BYTE	  0ABH,10000000B+TUTR				     : B
;
	 BYTE	  0EBH,10000000B+GRP4				     : C
;
	 BYTE	  00FH,00EH
	 BYTE	  01BH,00000000B+TUTR,09BH,00000000B+GRP0	     : E
	 BYTE	  0D4H,00000000B+FTR2
;
	 BYTE	  0A3H,10000000B+YPVS,0B3H,00000000+YPVS	     : F
	 BYTE	  0C3H,00000000B+YPVS
;
	 BYTE	  0FFH						     : end of data
;
;
FXCD14	 EQU	  $	    ;< Ground - 4 >		    / W 2 - 3 /
	 BYTE	  0C0H,10000000B+GRP7				     : 1
;
	 BYTE	  00FH,003H
	 BYTE	  038H,00000000B+FTR2				     : 3
;
	 BYTE	  015H,10000000B+FTR6				     : 4
;
	 BYTE	  0AAH,10000000B+TUTR,0F8H,00000000B+IKTR	     : 5
;
	 BYTE	  00FH,007H
	 BYTE	  096H,00000000B+FTR7				     : 7
;
	 BYTE	  00FH,009H
	 BYTE	  048H,00000000B+FTR7,0BAH,00000000B+TUTR	     : 9
;
	 BYTE	  0FFH
;
;
FXCD15	 EQU	  $	    ;< Ground - 5 >		    / W 3 - 1 /
	 BYTE	  087H,10000000B+FIEN,0A3H,00000000B+FIEN	     : 1
;
	 BYTE	  0DBH,10000000B+TUTR,0FBH,00000000B+TUTR	     : 2
;
	 BYTE	  093H,10000000B+FTR6				     : 3
	 BYTE	  0BBH,00000000B+TUTR
	 BYTE	  0CEH,01000010B,01000010B  ;NEXT GOTO Underground-2 (Bonus-2)
;
	 BYTE	  09BH,10000000B+TUTR				     : 4
;
	 BYTE	  0AEH,10110011B,01000000B  ;NEXT GOTO Ground-19 ;<SKY> : 5
	 BYTE	  0DBH,00000000B+SHTR,0F4H,00000000B+FTR6
;
	 BYTE	  033H,10000000B+FTR6,074H,00000000B+FTR6	     : 6
;
	 BYTE	  010H,10000000B+GRP5,0F5H,00000000B+FTR6	     : 7
;
	 BYTE	  02EH,11000010B,01000101B  ;NEXT GOTO Underground-2 (Bonus-3)
	 BYTE	  0B7H,00000000B+TUTR				     : 8
	 BYTE	  0F7H,00000000B+TUTR
;
	 BYTE	  0C8H,10000000B+FTR7				     : 9
;
	 BYTE	  0FFH
;
;
FXCD16	 EQU	  $	    ;< Ground - 6 >		    / W 3 - 3 /
	 BYTE	  080H,10000000B+GRP7				     : 1
	 BYTE	  083H,00000000B+TUTR,092H,00000000B+FTR7
;
	 BYTE	  04BH,10000000B+SHTR,0B0H,00000000B+GRP5	     : 2
;
	 BYTE	  007H,10000000B+SHTR,0B7H,00000000B+LFT0	     : 3
;
	 BYTE	  00CH,10000000B+LFT0				     : 4
;
	 BYTE	  096H,10000000B+LFT5				     : 5
;
	 BYTE	  01BH,10000000B+TUTR				     : 6
	 BYTE	  07BH,00000000B+LFT0,0B7H,00000000B+LFT0
;
	 BYTE	  097H,10000000B+TUTR,0E2H,00000000B+FTR6	     : 7
;
	 BYTE	  0A9H,10000000B+LFT5				     : 8
;
	 BYTE	  038H,10000000B+LFT5				     : 9
;
	 BYTE	  00FH,00BH
	 BYTE	  074H,10000000B+FTR6				     : B
;
	 BYTE	  0FFH
;
;
FXCD17	 EQU	  $	    ;< Ground - 7 >		    / W 4 - 1 /
	 BYTE	  0E2H,10000000B+ESHP				     : 1
;
	 BYTE	  00FH,003H
	 BYTE	  042H,00000000B+ESHP				     : 3
;
	 BYTE	  00FH,006H
	 BYTE	  072H,00000000B+ESHP				     : 6
;
	 BYTE	  00FH,008H
	 BYTE	  0EEH,00000010B,01100000B  ;NEXT GOTO Underwater-2  : 8
;
	 BYTE	  002H,10000000B+ESHP				     : 9
;
	 BYTE	  0EEH,10110011B,01100000B  ;NEXT GOTO Ground-19(SKY): A
;
	 BYTE	  0D3H,10000000B+YPVS				     : B
;
	 BYTE	  0FFH
;
;
FXCD18	 EQU	  $	    ;< Ground - 8 >		    / W 4 - 2 /
	 BYTE	  00FH,002H					     : 2
	 BYTE	  09BH,00000000B+BKTR,0ABH,00000000B+BKTR
;
	 BYTE	  00FH,004H
	 BYTE	  013H,00000000B+TUTR				     : 4
	 BYTE	  092H,00000000B+ESHP
;
	 BYTE	  060H,10000000B+GRP0				     : 5
;
	 BYTE	  000H,10000000B+GRP5				     : 6
;
	 BYTE	  000H,10000000B+GRP4				     : 7
;
	 BYTE	  00BH,10000000B+TUTR,0CBH,00000000B+TUTR	     : 8
;
	 BYTE	  07BH,10000000B+FIEN				     : 9
;
	 BYTE	  09EH,11000010B,01100000B  ;NEXT GOTO Underground-2 (Bonus-3)
	 BYTE	  0E6H,00000000B+FIEN				     : A
;
	 BYTE	  00FH,00CH
	 BYTE	  062H,00000000B+FTR7				     : C
;
	 BYTE	  0FFH
;
;
FXCD20	 EQU	  $	    ;< Ground - 10 >		    / W 4 - 3 /
	 BYTE	  0E6H,10000000B+LFT5				     : 1
;
	 BYTE	  057H,10000000B+LFT4,0B5H,00000000B+LFT0	     : 2
;
	 BYTE	  019H,10000000B+LFT0,076H,00000000B+LFT4	     : 3
	 BYTE	  0A2H,00000000B+FTR6
;
	 BYTE	  095H,10000000B+FTR6				     : 4
;
	 BYTE	  09DH,10000000B+LFT4				     : 5
;
	 BYTE	  00FH,007H					     : 7
	 BYTE	  009H,00000000B+LFT5,055H,00000000B+LFT0
	 BYTE	  08BH,00000000B+TMK0,0A9H,00000000B+LFT0
;
	 BYTE	  0DBH,10000000B+TUTR				     : 8 *
;
	 BYTE	  004H,10000000B+LFT5				     : 9
;
	 BYTE	  024H,10000000B+FTR6,065H,00000000B+FTR6	     : A
;
	 BYTE	  0FFH
;
;
FXCD29	 EQU	  $	    ;< Ground - 19 >		    ;<BONUS - SKY>
	 BYTE	  00AH,10000000B+LFT6				     : 1
;;;;;	      BYTE     01EH,00100000B,00000011B	 ;NEXT GOTO BACK Ground-0 (W1-1)
	 BYTE	  01EH,00100010B,00101001B  ;NEXT GOTO BACK Ground-2 (W2-1)
	 BYTE	  01EH,00100101B,01001001B  ;NEXT GOTO BACK Ground-5 (W3-1)
	 BYTE	  02EH,00100111B,01100110B  ;NEXT GOTO BACK Ground-7 (W4-1)
;
	 BYTE	  0FFH
;
;
;#####################################################################
;#	 Fix chara out pos data	 ( Underground )		     #
;#####################################################################
FXCD40	 EQU	  $	    ;< Underground - 0 >	    / W 1 - 2 /
	 BYTE	  00AH,10000000B+FTR2				     : 1
;
	 BYTE	  0DEH,10110100B,00000000B     ;NEXT GOTO Ground-20  : 2
	 BYTE	  0E0H,00000000B+GRP0
;
	 BYTE	  05BH,10000000B+BKTR				     : 3
;
	 BYTE	  02BH,10000000B+LFT5				     : 4
	 BYTE	  0AAH,00000000B+LFT5
;
	 BYTE	  029H,10000000B+LFT5				     : 5
	 BYTE	  0A8H,00000000B+LFT5
;
;
	 BYTE	  00FH,008H					     : 8
	 BYTE	  0F0H,00000000B+GRP5
;
	 BYTE	  079H,10000000B+LFT5,0C5H,00000000B+LFT2	     : 9
	 BYTE	  0CDH,00000000B+LFT2
;
	 BYTE	  0EEH,00111011B,00000001B  ;NEXT GOTO Ground-27(Return of Ground)
;
	 BYTE	  067H,10000000B+NOT1				     : A
;
	 BYTE	  00FH,00CH					     : C
	 BYTE	  02EH,11000001B,00000000B  ;NEXT GOTO Underground-1
;
	 BYTE	  0FFH
;
;
FXCD41	 EQU	  $	    ;< Underground - 1 >       ;<W1-2>
;						 ;from underground - 0
	 BYTE	  009H,10000000B+LFT5				     : 1
;
	 BYTE	  019H,10000000B+LFT5				     : 2
;
	 BYTE	  0DEH,01000010B,00000010B  ;NEXT GOTO Underground-2 (Bonus-2)
;
	 BYTE	  07BH,10000000B+TUTR				     : 3
;
	 BYTE	  0FFH
;
;
FXCD42	 EQU	  $	    ;< Underground - 2 >	    ;<BONUS>
;
; (UNDERGROUND-1) ;0
	 BYTE	  01EH,10100000B,00001010B  ;NEXT GOTO BACK Ground-0 (W1-1)
	 BYTE	  01EH,00100011B,00101011B  ;NEXT GOTO BACK Ground-3 (W2-2)
	 BYTE	  01EH,00101000B,01101011B  ;NEXT GOTO BACK Ground-8 (W4-2)
;
; (UNDERGROUND-2) ;2
	 BYTE	  00FH,003H
	 BYTE	  01EH,01000000B,00001000B  ;NEXT GOTO BACK Underground-0 (W1-2)
	 BYTE	  01EH,00100101B,01001110B  ;NEXT GOTO BACK Ground-5 (W3-1)
;
; (UNDERGROUND-3) ;5
	 BYTE	  00FH,006H
	 BYTE	  01EH,00100010B,00100101B  ;NEXT GOTO BACK Ground-2 (W2-1)
	 BYTE	  01EH,00100101B,01000101B  ;NEXT GOTO BACK Ground-5 (W3-1)
;
	 BYTE	  0FFH
;
;
;#####################################################################
;#	 Fix chara out pos data	 ( Underwater )			     #
;#####################################################################
;
FXCD50	 EQU	  $	    ;< Underwater - 0 >		    / W 3 - 2 /
	 BYTE	  00FH,001H
	 BYTE	  02AH,00000000B+IKTR				     : 1
	 BYTE	  02EH,00111011B,01000001B  ;NEXT GOTO BACK Ground-27(Return of Ground)
	 BYTE	  0E9H,00000000B+IKTR
;
	 BYTE	  00FH,003H
	 BYTE	  06BH,00000000B+IKTR,0F9H,00000000B+IKTR	     : 3
;
	 BYTE	  0B8H,10000000B+SHTR				     : 4
;
	 BYTE	  02AH,10000000B+IKTR				     : 5
;
	 BYTE	  04AH,10000000B+IKTR,0B3H,00000000B+FTR6	     : 6
;
	 BYTE	  084H,10000000B+IKTR				     : 7
;
	 BYTE	  047H,10000000B+TUTR,087H,00000000B+IKTR	     : 8
;
	 BYTE	  00AH,10000000B+IKTR				     : 9
;
	 BYTE	  042H,10000000B+IKTR				     : A
;
	 BYTE	  01BH,10000000B+IKTR,06BH,00000000B+TUTR	     : B
;
	 BYTE	  0FFH
;
;
FXCD52	 EQU	  $	    ;< Underwater - 2 >		    ;<BONUS>
;
	 BYTE	  01EH,10100111B,01101010B  ;NEXT GOTO BACK Ground-7(W4-1):1
;
	 BYTE	  05BH,10000000B+BKTR,074H,00000000B+IKTR	     : 2
	 BYTE	  0D8H,00000000B+IKTR,0E8H,00000000B+BKTR
;
	 BYTE	  00FH,004H
	 BYTE	  026H,00000000B+IKTR				     : 4
;
	 BYTE	  0FFH
;
;
;############################################################################################
;#	 Fix obstacle out position data							    #
;############################################################################################
;
;		 +------+------+  +------+------+
;	 FXODxx	 I x xxx xxxxx I  I  xxx  xxxxx I
;	     ^^	 +------+------+  +------+------+
;	     ||	   ^  ^	   ^	      ^	    ^
;	     ||	   |  |	   |	      |	    |
;	     ||	   |  |	   |	      |	    |
;	     ||	   |  |	   |	      |	    |
;	     ||	   |  |	   |	      |	    +---  Floor display max loop
;	     ||	   |  |	   |	      +--------- Player start position data index
;	     ||	   |  |	   |
;	     ||	   |  |	   +------  Base BG environmen
;	     ||	   |  +-----------  Play farst base time
;	     ||	   +--------------  0:ON Floor	      1:OFF Floor
;	     ||
;	     ||	 +------+------+------+------+-----+-----+
;	     ||	 I x x	xxxxxx I xxxx | xxxx I xxxx|xxxx I
;	     ||	 +------+------+------+------+-----+-----+
;	     ||	   ^ ^	   ^	   ^	  ^	 ^    ^
;	     ||	   | |	   |	   |	  |	 |    |
;	     ||	   | |	   |	   |	  |	 |    +----  Obstacle display count
;	     ||	   | |	   |	   |	  |	 +---------  Obstacle kind No.
;	     ||	   | |	   |	   |	  +-  (y)pos-L	     F:BG environment change mode
;	     ||	   | |	   |	   +--------  (x)pos-L
;	     ||	   | |	   |
;	     ||	   | |	   +------  (x)pos-H  ( FF : End crode )
;	     ||	   | +------------  0:Floot length 1:Fix length
;	     ||	   |
;	     ||	   +--------  00:Out  11:No out
;	     ||
;	     |+---  Kind corde
;	     +----  0:Underwater 1:Ground  2:Underground  3:Castle
;
;#####################################################################
;#	 Fix obstacle out pos data  ( Castle )			     #
;#####################################################################
FXOD00	 EQU	  $	    ;< Castle - 00 >		    / W 1 - 4 /
	 BYTE	  10011011B,00000111B
;
	BYTE	00FH,050H+002H,00000000B+OKID				; 0
	BYTE	00FH,060H+003H,00000000B+OKID
	BYTE	00FH,070H+004H,00000000B+OKID
;
	 BYTE	  033H,10000000B+000H+OSP0			     : 1
	BYTE	04FH,010H+000H,00000000B+ONBK
	BYTE	04FH,080H+000H,00000000B+OCTL
	 BYTE	  04EH,00001010B
	 BYTE	  07EH,00000110B
	BYTE	08FH,080H+000H,00000000B+OCTR
	BYTE	09FH,080H+000H,00000000B+OCTL
	 BYTE	  09EH,00001010B
	 BYTE	  0CEH,00000110B
	BYTE	0DFH,080H+000H,00000000B+OCTR
	 BYTE	  0E3H,00000000B+000H+OBMS
	BYTE	0EFH,080H+000H,00000000B+OCTL
	 BYTE	  0EEH,00001010B
;
	 BYTE	  01EH,10000111B				     : 2
	BYTE	02FH,020H+000H,00000000B+ONBK
	BYTE	02FH,080H+000H,00000000B+OCTR
	 BYTE	  053H,00000000B+000H+OSP0
	BYTE	08FH,010H+000H,00000000B+ONBK
	BYTE	08FH,080H+000H,00000000B+OCTL
	 BYTE	  08EH,00000010B
	 BYTE	  09CH,00000000B+OHL0+000H
	BYTE	0AFH,0B0H+000H,00000000B+OCTR
	 BYTE	  0C7H,00000000B+000H+OSP0
	 BYTE	  0D7H,00000000B+OBK1+007H
;
	 BYTE	  057H,10000000B+000H+OSP0			     ; 3
	BYTE	05FH,0B0H+000H,00000000B+OCTL
	 BYTE	  06CH,00000000B+OHL0+005H
	BYTE	0CFH,0B0H+000H,00000000B+OCTR
	 BYTE	  0DAH,00000000B+OPB1+000H,0E9H,00000000B+OPB1+001H
	BYTE	0FFH,0A0H+001H,00000000B+OCRC
	 BYTE	  0F8H,00000000B+OPB1+002H
	 BYTE	  0FEH,00001011B
;
	BYTE	00FH,020H+000H,10000000B+ONBK
	BYTE	00FH,070H+000H,00000000B+OCTR
	 BYTE	  043H,00000000B+000H+OSP0,0C3H,00000000B+000H+OSP0  : 4
;
	 BYTE	  043H,10000000B+000H+OSP0,0B7H,00000000B+000H+OSP0  : 5
	 BYTE	  0EEH,00001001B
	BYTE	0EFH,010H+000H,00000000B+ONBK
	BYTE	0EFH,030H+000H,00000000B+ONBK
	 BYTE	  0FEH,00001010B
;
	BYTE	00FH,070H+000H,10000000B+OCTL
	 BYTE	  03EH,00000110B				     : 6
	BYTE	04FH,080H+000H,00000000B+OCTR
	 BYTE	  057H,00000000B+000H+OSP0
	 BYTE	  06EH,00001010B
	BYTE	06FH,080H+000H,00000000B+OCTL
	 BYTE	  07EH,00000110B
	BYTE	08FH,080H+000H,00000000B+OCTR
	 BYTE	  0AEH,00001010B
	BYTE	0AFH,080H+000H,00000000B+OCTL
	 BYTE	  0BEH,00000110B
	BYTE	0CFH,080H+000H,00000000B+OCTR
	 BYTE	  0FEH,00000111B
;
	BYTE	00FH,020H+000H,10000000B+ONBK
	 BYTE	  015H,00000000B+OPB1+002H,055H,00000000B+OPB1+002H  : 7
	 BYTE	  095H,00000000B+OPB1+002H
	BYTE	0FFH,020H+000H,00000000B+ONBK
	BYTE	0FFH,080H+000H,00000000B+OCTL
	 BYTE	  0FEH,00001010B
;
	 BYTE	  00DH,10000000B+000H+OSL0,0CDH,00000000B+000H+OCH0  : 8
	 BYTE	  0CEH,00001001B
	BYTE	0DFH,070H+000H,00000000B+OCTR
	 BYTE	  0DEH,00001011B
;
	 BYTE	  0DDH,00000000B+000H+OSK0
;
	BYTE	0EFH,020H+000H,00000000B+ONBK
	BYTE	0FFH,0A0H+001H,00000000B+OCLC
	BYTE	0FFH,020H+000H,00000000B+ONBK
	BYTE	0FFH,070H+000H,00000000B+OCTL
	 BYTE	  0FEH,00000010B
;
	 BYTE	  05DH,10000000B+000H+SCOF			     : 9
;
	 BYTE	  0FDH
;
;
FXOD01	 EQU	  $	    ;< Castle - 01 >		    / W 2 - 4 /
	 BYTE	  10011011B,00000111B
;
	BYTE	00FH,050H+002H,00000000B+OKID				; 0
	BYTE	00FH,060H+003H,00000000B+OKID
	BYTE	00FH,070H+004H,00000000B+OKID
;;	   BYTE	    005H,00000000B+OBK1+002H,006H,00000000B+OBK1+003H  : 0
;;	   BYTE	    007H,00000000B+OBK1+004H
;
	 BYTE	  003H,10000000B+OPB1+002H			     : 1
	BYTE	00FH,010H+000H,00000000B+ONBK
	 BYTE	  00EH,00000110B
	 BYTE	  01EH,00001100B
	BYTE	01FH,070H+001H,00000000B+OCRC
	BYTE	02FH,040H+000H,00000000B+OCTR
	 BYTE	  07EH,00001010B
	BYTE	07FH,040H+000H,00000000B+OCTL
	 BYTE	  08EH,00000101B
	BYTE	09FH,010H+000H,00000000B+ONBK
	BYTE	09FH,030H+000H,00000000B+ONBK
	BYTE	09FH,050H+000H,00000000B+ONBK
	BYTE	09FH,070H+000H,00000000B+ONBK
	BYTE	09FH,0B0H+000H,00000000B+OCTR
;
	 BYTE	  08EH,10000010B				     : 2
	BYTE	08FH,010H+000H,00000000B+ONBK
	BYTE	08FH,030H+000H,00000000B+ONBK
	BYTE	08FH,050H+000H,00000000B+ONBK
	BYTE	08FH,070H+000H,00000000B+ONBK
;
	 BYTE	  08AH,10000000B+OSP0+000H			     : 3
	BYTE	08FH,0B0H+000H,00000000B+OCTL
	 BYTE	  08EH,00001010B
	 BYTE	  0EEH,00000010B
	BYTE	0FFH,0B0H+000H,00000000B+OCTR
;
	 BYTE	  00AH,10000000B+OPB1+000H,019H,00000000B+OPB1+001H  : 4
	BYTE	02FH,0A0H+001H,00000000B+OCRC
	 BYTE	  023H,00000000B+000H+OSBM,028H,00000000B+OPB1+002H
	 BYTE	  02EH,00001011B
	BYTE	03FH,010H+000H,00000000B+ONBK
	BYTE	03FH,030H+000H,00000000B+ONBK
	BYTE	03FH,070H+000H,00000000B+OCTR
	BYTE	07FH,070H+000H,00000000B+OCTL
	 BYTE	  07EH,00001010B
	BYTE	08FH,010H+002H,00000000B+OLBK
	 BYTE	  087H,00000000B+OBK1+000H
	 BYTE	  08EH,00000100B
	BYTE	09FH,0B0H+000H,00000000B+OCTR
	 BYTE	  0A7H,00000000B+OBK1+001H,0C7H,00000000B+OSP0+000H
	 BYTE	  0D7H,00000000B+OBK1+003H
	 BYTE	  0FEH,00000011B
;
	 BYTE	  003H,10000000B+OSP0+000H			     : 5
	BYTE	00FH,0B0H+000H,00000000B+OCTL
	 BYTE	  00EH,00001010B
	BYTE	01FH,010H+002H,00000000B+OLBK
	 BYTE	  01EH,00000100B
	BYTE	02FH,0B0H+000H,00000000B+OCTR
	 BYTE	  027H,00000000B+OBK1+002H
	 BYTE	  04EH,00001010B
	BYTE	04FH,0B0H+000H,00000000B+OCTL
	 BYTE	  057H,00000000B+OSP0+000H
	BYTE	05FH,010H+002H,00000000B+OLBK
	 BYTE	  05EH,00000100B
	BYTE	06FH,0B0H+000H,00000000B+OCTR
	 BYTE	  067H,00000000B+OBK1+004H
	BYTE	09FH,0B0H+000H,00000000B+OCTL
	 BYTE	  09EH,00001010B
	BYTE	0AFH,010H+002H,00000000B+OLBK
	 BYTE	  0AEH,00000011B
	 BYTE	  0B3H,00000000B+OSP0+000H
	BYTE	0BFH,0A0H+001H,00000000B+OCRC
	BYTE	0BFH,0B0H+000H,00000000B+OCTR
	 BYTE	  0BEH,00001011B
	BYTE	0CFH,070H+000H,00000000B+OCTR
	 BYTE	  0EEH,00001001B
	BYTE	0EFH,010H+000H,00000000B+ONBK
	BYTE	0EFH,030H+000H,00000000B+ONBK
	BYTE	0FFH,070H+000H,00000000B+OCTL
	 BYTE	  0FEH,00001010B
;
	 BYTE	  02EH,10000010B				     : 6
	BYTE	03FH,0B0H+000H,00000000B+OCTR
	 BYTE	  07AH,00000000B+OSP0+000H
	BYTE	07FH,0B0H+000H,00000000B+OCTL
	 BYTE	  07EH,00001010B
	 BYTE	  097H,00000000B+OBK1+001H
	 BYTE	  0BEH,00000100B
	BYTE	0CFH,020H+000H,00000000B+ONBK
	BYTE	0CFH,0B0H+000H,00000000B+OCTR
	 BYTE	  0DAH,00000000B+OSP0+000H
	 BYTE	  0EEH,00001010B
	BYTE	0EFH,0B0H+000H,00000000B+OCTL
	BYTE	0FFH,010H+002H,00000000B+OLBK
	BYTE	0FFH,020H+000H,00000000B+ONBK
	 BYTE	  0FEH,00000010B
;
	BYTE	00FH,0B0H+000H,10000000B+OCTR
	BYTE	03FH,0B0H+000H,00000000B+OCTL
	 BYTE	  03EH,00001010B				     : 7
	 BYTE	  07EH,00000110B
	BYTE	08FH,080H+000H,00000000B+OCTR
	BYTE	0AFH,080H+000H,00000000B+OCTL
	 BYTE	  0AEH,00001010B
	 BYTE	  0CEH,00000110B
	BYTE	0DFH,080H+000H,00000000B+OCTR
	BYTE	0FFH,080H+000H,00000000B+OCTL
	 BYTE	  0FEH,00001010B
;
	 BYTE	  00DH,10000000B+000H+OSL0			     : 8
;
	 BYTE	  011H,00000000B+OPB0+003H,021H,00000000B+OPB0+002H
	 BYTE	  024H,00000000B+ORBC+000H
	 BYTE	  051H,00000000B+OPB0+002H,061H,00000000B+OPB0+002H
;
	 BYTE	  0CDH,00000000B+000H+OCH0	     ;<KUSARI>
;
	 BYTE	  0CEH,00001001B
;
	BYTE	0DFH,070H+000H,00000000B+OCTR
	 BYTE	  0DDH,00000000B+000H+OSK0	     ;<KUI>
;
	 BYTE	  0DEH,00001011B
	BYTE	0EFH,020H+000H,00000000B+ONBK
	BYTE	0FFH,020H+000H,00000000B+ONBK
	BYTE	0FFH,0A0H+001H,00000000B+OCLC
	BYTE	0FFH,070H+000H,00000000B+OCTL
	 BYTE	  0FEH,00000010B
;
	 BYTE	  05DH,10000000B+000H+SCOF			     : 9
;
	 BYTE	  0FDH
;
;
FXOD02	 EQU	  $	    ;< Castle - 02 >		    / W 3 - 4 /
	 BYTE	  01011011B,00000110B
;
	BYTE	00FH,050H+004H,00000000B+OKID				; 0
	BYTE	00FH,060H+005H,00000000B+OKID
	BYTE	00FH,070H+006H,00000000B+OKID
;;;	    BYTE     005H,00000000B+OBK1+004H,006H,00000000B+OBK1+005H	: 0
	 BYTE	  07EH,00001010B
	BYTE	07FH,080H+000H,00000000B+OCTL
	 BYTE	  0AEH,00000010B
	BYTE	0BFH,0B0H+000H,00000000B+OCTR
;	    (point)
DA001	 EQU	  $
	 BYTE	  0FEH,00000010B
;
	 BYTE	  00DH,001H					     : 1
;;;	    BYTE     00EH,00001110B
	 BYTE	  014H,00000000B+OPB1+003H
	 BYTE	  024H,00000000B+OPB1+003H
	BYTE	02FH,0B0H+000H,00000000B+OCTL
	 BYTE	  02EH,00001010B
	 BYTE	  06EH,00001001B
	BYTE	07FH,070H+000H,00000000B+OCTR
	BYTE	0BFH,070H+000H,00000000B+OCTL
	 BYTE	  0BEH,00001010B
	 BYTE	  0EDH,00000000B+000H+CSLP,0E4H,00000000B+OBK1+000H
	 BYTE	  0EEH,00000010B
	 BYTE	  0F3H,00000000B+OPB1+004H
	BYTE	0FFH,0B0H+000H,00000000B+OCTR
;
	 BYTE	  003H,10000000B+OPB1+004H
	 BYTE	  013H,00000000B+OPB1+004H
	 BYTE	  023H,00000000B+OPB1+004H
	 BYTE	  033H,00000000B+OPB1+004H
	 BYTE	  043H,00000000B+OPB1+004H
	 BYTE	  053H,00000000B+OPB1+004H
	 BYTE	  05EH,00000010B				     : 2
	 BYTE	  078H,00000000B+OCM2+002H
	 BYTE	  0A4H,00000000B+OBK1+00DH,0A5H,00000000B+OBK1+00EH
	 BYTE	  0A6H,00000000B+OBK1+00FH
;
	 BYTE	  0A3H,10000000B+OBK1+00EH,0A6H,00000000B+OBK1+00EH  : 3
	 BYTE	  0A9H,00000000B+OBK1+002H,0E9H,00000000B+OBK1+00AH
;
	BYTE	08FH,0B0H+000H,10000000B+OCTL
	 BYTE	  08EH,00001010B
;;;	    BYTE     09CH,10000000B+OHL0+000H
	 BYTE	  0AEH,00000010B
	BYTE	0AFH,0B0H+000H,00000000B+OCTR
	 BYTE	  0A3H,00000000B+OBK1+003H  : 4
	 BYTE	  0A6H,00000000B+OBK1+003H,0A9H,00000000B+OBK1+003H
	 BYTE	  0E5H,00000000B+OSBM+000H,0EDH,00000000B+000H+CSLP
	 BYTE	  0F3H,00000000B+OBK1+000H,0F6H,00000000B+OBK1+000H
	 BYTE	  0F9H,00000000B+OBK1+000H
;
;	    (point)
DA002	 EQU	  $
	 BYTE	  0FEH,00000010B
;
	 BYTE	  00DH,005H					     : 5
;
	BYTE	02FH,0B0H+000H,00000000B+OCTL
	 BYTE	  03CH,00000000B+OHL0+001H,057H,00000000B+OCM2+003H
	BYTE	05FH,0B0H+000H,00000000B+OCTR
	BYTE	06FH,0B0H+000H,00000000B+OCTL
	 BYTE	  07CH,00000000B+OHL0+002H,093H,00000000B+OBK1+000H
	 BYTE	  0A7H,00000000B+OCM2+003H
	BYTE	0AFH,0B0H+000H,00000000B+OCTR
	BYTE	0BFH,0B0H+000H,00000000B+OCTL
	 BYTE	  0B3H,00000000B+OBK1+007H
	 BYTE	  0CCH,00000000B+OHL0+001H
	BYTE	0EFH,0B0H+000H,00000000B+OCTR
;
	 BYTE	  007H,10000000B+OSCO+000H,017H,00000000B+OSCO+000H  : 6
	 BYTE	  027H,00000000B+OSCO+000H,037H,00000000B+OSCO+000H
	 BYTE	  064H,00000000B+OBK1+00BH,077H,00000000B+OBK1+00AH
	BYTE	0FFH,0B0H+000H,00000000B+OCTL
;
	 BYTE	  00CH,10000000B+OHL0+000H			     : 7
	BYTE	01FH,0B0H+000H,00000000B+OCTR
;;	   BYTE	    02EH,00001110B
	 BYTE	  034H,00000000B+OBK1+006H
	 BYTE	  035H,00000000B+OBK1+007H
	 BYTE	  036H,00000000B+OBK1+008H
	 BYTE	  037H,00000000B+OBK1+008H
	 BYTE	  09EH,00000010B
	BYTE	0BFH,0B0H+000H,00000000B+OCTL
	 BYTE	  0CCH,00000000B+OHL0+002H,0C3H,00000000B+OBK1+003H
	 BYTE	  0EDH,00000000B+000H+CSLP
	BYTE	0FFH,0B0H+000H,00000000B+OCTR
;
	 BYTE	  003H,10000000B+OBK1+007H,007H,00000000B+OBK1+007H  : 8
	 BYTE	  083H,00000000B+OBK1+007H,087H,00000000B+OBK1+007H
	 BYTE	  0DDH,00000000B+000H+CSLP
;
;	    (point)
	 BYTE	  003H,10000000B+OBK1+005H,007H,00000000B+OBK1+005H  : 9
	BYTE	05FH,0B0H+000H,00000000B+OCTL
	 BYTE	  05EH,00001010B
	 BYTE	  08EH,00000010B
	BYTE	09FH,0B0H+000H,00000000B+OCTR
	BYTE	0AFH,0B0H+000H,00000000B+OCTL
	 BYTE	  0AEH,00001010B
	 BYTE	  0DEH,00000110B
	BYTE	0EFH,080H+000H,00000000B+OCTR
	BYTE	0FFH,080H+000H,00000000B+OCTL
	 BYTE	  0FEH,00001010B
;
	 BYTE	  00DH,10000000B+000H+OSL0			     : A
	 BYTE	  0CDH,00000000B+000H+OCH0
	 BYTE	  0CEH,00001001B
;
	 BYTE	  0DDH,00000000B+000H+OSK0
	 BYTE	  0DEH,00001011B
	BYTE	0DFH,070H+000H,00000000B+OCTR
	BYTE	0EFH,020H+000H,00000000B+ONBK
	BYTE	0FFH,020H+000H,00000000B+ONBK
	BYTE	0FFH,0A0H+001H,00000000B+OCLC
	BYTE	0FFH,070H+000H,00000000B+OCTL
	 BYTE	  0FEH,00000010B
;
	 BYTE	  05DH,10000000B+000H+SCOF			     : B
;
	 BYTE	  0FDH
;
;
FXOD03	 EQU	  $	    ;< Castle - 03 >		    / W 4 - 4 /
	 BYTE	  10011011B,00000111B
;
	BYTE	00FH,050H+002H,00000000B+OKID				; 0
	BYTE	00FH,060H+003H,00000000B+OKID
	BYTE	00FH,070H+004H,00000000B+OKID
;;;	    BYTE     005H,00000000B+OBK1+002H,006H,00000000B+OBK1+003H	: 0
;;;	    BYTE     007H,00000000B+OBK1+004H
	BYTE	04FH,080H+000H,00000000B+OCTL
	 BYTE	  04EH,00000011B
	 BYTE	  05CH,00000000B+OHL0+002H
	BYTE	08FH,0B0H+000H,00000000B+OCTR
;
	 BYTE	  00CH,10000000B+OBC2+001H,027H,00000000B+OBMS+000H  : 1
	 BYTE	  03CH,00000000B+OBC2+004H,047H,00000000B+OSP0+000H
	BYTE	0EFH,0B0H+000H,00000000B+OCTL
	 BYTE	  0FCH,00000000B+OHL0+000H
	 BYTE	  0FEH,00001011B
;
	BYTE	00FH,070H+000H,10000000B+OCTR
	 BYTE	  077H,00000000B+OSP0+000H			     : 2
	 BYTE	  0EEH,00001001B
	BYTE	0EFH,010H+000H,00000000B+ONBK
	BYTE	0EFH,030H+000H,00000000B+ONBK
	BYTE	0FFH,070H+000H,00000000B+OCTL
	 BYTE	  0FEH,00001010B
;
	 BYTE	  045H,10000000B+OBK1+002H,055H,00000000B+OSP0+000H  : 3
	 BYTE	  099H,00000000B+OBK1+002H,0B9H,00000000B+OSP0+000H
	 BYTE	  0FEH,00000010B
;
	 BYTE	  00EH,10000101B				     : 4
	BYTE	00FH,0B0H+000H,00000000B+OCTR
	BYTE	01FH,010H+000H,00000000B+ONBK
	BYTE	01FH,030H+000H,00000000B+ONBK
	BYTE	01FH,050H+000H,00000000B+ONBK
	BYTE	01FH,070H+000H,00000000B+ONBK
	BYTE	0FFH,020H+000H,00000000B+ONBK
	BYTE	0FFH,040H+000H,00000000B+ONBK
	BYTE	0FFH,060H+000H,00000000B+ONBK
	 BYTE	  0FEH,00000010B
;
	 BYTE	  016H,10000000B+OSP0+000H			     : 5
	 BYTE	  02EH,00001100B
	BYTE	02FH,0A0H+001H,00000000B+OCRC
	BYTE	03FH,040H+000H,00000000B+OCTR
	BYTE	0AFH,040H+000H,00000000B+OCTL
	 BYTE	  0AEH,00001010B
	 BYTE	  0EEH,00000101B
	BYTE	0FFH,010H+000H,00000000B+ONBK
	BYTE	0FFH,030H+000H,00000000B+ONBK
	BYTE	0FFH,050H+000H,00000000B+ONBK
	BYTE	0FFH,070H+000H,00000000B+ONBK
	BYTE	0FFH,0B0H+000H,00000000B+OCTR
;
	 BYTE	  01EH,10000010B				     : 6
	BYTE	01FH,020H+000H,00000000B+ONBK
	BYTE	01FH,040H+000H,00000000B+ONBK
	BYTE	01FH,060H+000H,00000000B+ONBK
	 BYTE	  047H,00000000B+OSP0+000H
;
	 BYTE	  007H,10000000B+OBK1+00DH,0C4H,00000000B+OCM2+002H  : 7
	 BYTE	  0DEH,00001010B
	BYTE	0DFH,0B0H+000H,00000000B+OCTL
	 BYTE	  0FEH,00000010B
;
	 BYTE	  003H,10000000B+OSP0+000H,007H,00000000B+OSP0+000H  : 8
	BYTE	00FH,0B0H+000H,00000000B+OCTR
	 BYTE	  013H,00000000B+OBK1+00CH,017H,00000000B+OBK1+00DH
	 BYTE	  0E3H,00000000B+OSCO+000H
	 BYTE	  0EEH,00001010B
	BYTE	0EFH,0B0H+000H,00000000B+OCTL
	 BYTE	  0F3H,00000000B+OSBM+000H,0F7H,00000000B+OSCO+000H
	 BYTE	  0FEH,00000010B
;
	 BYTE	  004H,10000000B+OBK1+00EH			     ; 9
	 BYTE	  005H,00000000B+OBK1+00EH
	 BYTE	  006H,00000000B+OBK1+00EH
	 BYTE	  007H,00000000B+OBK1+00EH
	BYTE	00FH,0B0H+000H,00000000B+OCTR
	 BYTE	  0FEH,00001010B
	 BYTE	  0F4H,00000000B+OPB1+003H
	BYTE	0FFH,0B0H+000H,00000000B+OCTL
;
	 BYTE	  038H,10000000B+OPB1+004H,04AH,00000000B+OCM2+002H  : A
	 BYTE	  068H,00000000B+OPB1+004H
;
	 BYTE	  037H,10000000B+OBK1+000H			     ; B
	BYTE	09FH,080H+000H,00000000B+OCTR
	BYTE	0AFH,080H+000H,00000000B+OCTL
	BYTE	0EFH,080H+000H,00000000B+OCTR
	BYTE	0FFH,080H+000H,00000000B+OCTL
;;	   BYTE	    0A8H,00000000B+OPB1+004H,0E8H,00000000B+OPB1+004H
;;	   BYTE	    0F8H,00000000B+OPB1+004H
;
	 BYTE	  00DH,10000000B+000H+OSL0			     : C
	 BYTE	  071H,00000000B+OPB1+004H
	 BYTE	  0CDH,00000000B+000H+OCH0
	 BYTE	  0CEH,00001001B
;
	 BYTE	  0DDH,00000000B+000H+OSK0
	 BYTE	  0DEH,00001011B
	BYTE	0DFH,070H+000H,00000000B+OCTR
	BYTE	0EFH,020H+000H,00000000B+ONBK
	BYTE	0FFH,020H+000H,00000000B+ONBK
	BYTE	0FFH,0A0H+001H,00000000B+OCLC
	BYTE	0FFH,070H+000H,00000000B+OCTL
	 BYTE	  0FEH,00000010B
;
	 BYTE	  05DH,10000000B+000H+SCOF			     : D
;
	 BYTE	  0FDH
;
;
;#####################################################################
;#	 Fix obstacle out pos data  ( Ground )			     #
;#####################################################################
FXOD10	 EQU	  $	    ;< Ground - 0 >		    / W 1 - 1 /
	 BYTE	  01010000B,00110001B
;
	 BYTE	  00FH,0F0H+006H,00000000B+OCS0				  : 0
;
	 BYTE	  013H,10000000B+OPB1+004H,023H,00000000B+OBK0+004H  : 1
	 BYTE	  027H,00000000B+OBK0+003H,037H,00000000B+OBBM+000H
	 BYTE	  066H,00000000B+OPB1+001H
	 BYTE	  0ACH,00000000B+OBC2+004H,0C7H,00000000B+ODMS+000H
;
	 BYTE	  00BH,10000000B+OCM2+001H,077H,00000000B+OCM2+003H  : 2
	 BYTE	  0B6H,00000000B+OSMS+000H,0DBH,00000000B+OCM2+001H
;
	 BYTE	  05CH,10000000B+OHL0+002H,083H,00000000B+OBK0+00DH  : 3
	 BYTE	  0A2H,00000000B+OCO0+007H,0A7H,00000000B+OBBS+000H
	 BYTE	  0B7H,00000000B+OBK0+009H
;
	 BYTE	  04FH,0F0H+003H,10000000B+OST0
	BYTE	04EH,00000001B,05EH,00110001B,087H,00000000B+000H+ORBC	: 4
	 BYTE	  093H,00000000B+OBK0+003H
	 BYTE	  0CCH,00000000B+OHL0+006H,0E3H,00000000B+OBK0+00CH
;
	 BYTE	  03AH,10000000B+OPB1+000H,07CH,00000000B+OBC2+001H  : 5
	 BYTE	  097H,00000000B+ODMS+000H,0ACH,00000000B+OBC2+003H
	 BYTE	  0E6H,00000000B+OPB1+001H
;
;	    (point)
	 BYTE	  00EH,10110001B				     : 6
;
	 BYTE	  0B7H,10000000B+OCM2+003H,0DCH,00000000B+OHL0+002H  : 7
	 BYTE	  0D3H,00000000B+OBK0+005H
;
	 BYTE	  007H,10000000B+OCM0+003H,02CH,00000000B+OHL0+001H  : 8
	 BYTE	  0E7H,00000000B+OCM2+003H
;
	 BYTE	  02CH,10000000B+OBC2+002H,034H,00000000B+OCM2+002H  : 9
	 BYTE	  057H,00000000B+OBMS+000H,07CH,00000000B+OHL0+002H
;
	 BYTE	  039H,10000000B+OCM2+001H,0BFH,0F0H+007H,00000000B+OST0  : A
;
	 BYTE	  033H,10000000B+OPB1+007H,0CDH,00000000B+000H+OPL0  : B
;
	 BYTE	  00FH,0F0H+006H,10000000B+OCS0				  : C
	 BYTE	  0EDH,00000000B+SCOF	    ; SCROLL STOP
;
	 BYTE	  0FDH
;
;
FXOD11	 EQU	  $	    ;< Ground - 1 >		    / W 1 - 3 /
	 BYTE	  01010000B,00010001B
;
	 BYTE	  00FH,0F0H+006H,00000000B+OCS0				  : 0
	 BYTE	  0FEH,00010000B
;
	 BYTE	  047H,10000000B+OLD0+002H,056H,00000000B+OCO0+000H  : 1
	 BYTE	  0ACH,00000000B+OEP0+006H,0AFH,0F0H+002H,00000000B+OLW0
;
	 BYTE	  00FH,0F0H+005H,10000000B+OLW0,073H,00000000B+OLD0+006H  : 2
	 BYTE	  082H,00000000B+OCO0+004H,0ECH,00000000B+OBG2+008H
;
	 BYTE	  0BCH,10000000B+OBG2+002H			     : 3
;
	 BYTE	  01CH,10000000B+OBG1+001H,0B3H,00000000B+OLD0+006H  : 4
	 BYTE	  0C2H,00000000B+OCO0+004H
;
	 BYTE	  086H,10000000B+OCO0+000H			     : 5
	 BYTE	  09CH,00000000B+OEP0+004H,09FH,0F0H+002H,00000000B+OLW0
	 BYTE	  0A6H,00000000B+OCO0+000H
	 BYTE	  0DFH,0F0H+005H,00000000B+OLW0
;
;	    (point)
	 BYTE	  00BH,10000000B+OLD0+006H,043H,00000000B+OLD0+002H  : 6
	 BYTE	  097H,00000000B+OBK1+001H,0D3H,00000000B+OLD0+002H
;
	 BYTE	  003H,10000000B+OLD0+002H			     : 7
	 BYTE	  027H,00000000B+OLD0+004H,063H,00000000B+OBMS+000H
	 BYTE	  0C7H,00000000B+OLD0+005H,0D6H,00000000B+OCO0+003H
;
	 BYTE	  0ACH,10000000B+OEP0+007H,0AFH,0F0H+001H,00000000B+OLW0  : 8
;
	 BYTE	  01FH,0F0H+006H,10000000B+OLW0,064H,00000000B+OLD0+003H  : 9
	 BYTE	  0E3H,00000000B+OLD0+002H
;
	 BYTE	  02EH,10010001B				     : A
	 BYTE	  09DH,00000000B+000H+OPL0	     ;(Flag)
	 BYTE	  0AEH,01000010B
	 BYTE	  0BFH,0F0H+000H,00000000B+OCS0
;
	 BYTE	  0ADH,10000000B+000H+SCOF			     : B
;
	 BYTE	  0FDH
;
;
FXOD12	 EQU	  $	    ;< Ground - 2 >		    / W 2 - 1 /
	 BYTE	  01010010B,00100001B
;
	 BYTE	  00FH,0F0H+000H,00000000B+OCS0				  : 0
	 BYTE	  06EH,01100100B
;
	 BYTE	  04FH,0F0H+002H,10000000B+OST0,07CH,00000000B+OWT0+00FH  : 1
	 BYTE	  07CH,00000000B+OBG1+00FH
;
	 BYTE	  06FH,0F0H+001H,10000000B+BRI1				; 2
	 BYTE	  07CH,00000000B+OWT0+008H,07CH,00000000B+OBG1+008H
	 BYTE	  083H,00000000B+OBCO+000H,0A3H,00000000B+OBMS+000H
	 BYTE	  0C3H,00000000B+OBCO+000H,0F7H,00000000B+OLD0+006H
;
	 BYTE	  05CH,10000000B+OWT0+006H,0CFH,0F0H+005H,00000000B+OST0  : 3
	 BYTE	  0D3H,00000000B+OBK0+000H,0E3H,00000000B+OBBS+000H
	 BYTE	  0F3H,00000000B+OBK0+000H
;
	 BYTE	  025H,10000000B+OBK1+005H,02CH,00000000B+OWT0+003H  : 4
	 BYTE	  06AH,00000000B+OCM0+002H,08CH,00000000B+OWT0+004H
	 BYTE	  0DAH,00000000B+OCM2+002H,0FCH,00000000B+OWT0+000H
;
	 BYTE	  00CH,10000000B+OWT0+002H,039H,00000000B+OCM2+003H  : 5
	 BYTE	  05CH,00000000B+OWT0+004H,0AAH,00000000B+OCM2+002H
	 BYTE	  0CCH,00000000B+OWT0+003H,0F7H,00000000B+OLD0+006H
;
	 BYTE	  033H,10000000B+000H+OSCO,040H,00000000B+OSBM+000H  : 6
	 BYTE	  05CH,00000000B+OWT0+00BH
;
	 BYTE	  009H,10000000B+OLD0+003H,027H,00000000B+000H+OBOD  : 7
	 BYTE	  03CH,00000000B+OWT0+00CH
;
;	 ( point )
	 BYTE	  00AH,10000000B+OBK1+000H,063H,00000000B+OBK0+007H  : 8
	 BYTE	  078H,00000000B+OCM2+002H,093H,00000000B+000H+OBBW
	 BYTE	  097H,00000000B+000H+OSCO,0A7H,00000000B+000H+OSCO
	 BYTE	  0B7H,00000000B+OBK0+002H
;
	 BYTE	  047H,10000000B+000H+ODMS,05CH,00000000B+OBC2+002H  : 9
;
	 BYTE	  02AH,10000000B+OBK1+000H,028H,00000000B+000H+OBOD  : A
	 BYTE	  03CH,00000000B+OWT0+00FH,058H,00000000B+OBK1+001H
	 BYTE	  0B8H,00000000B+OBK1+001H
;
	 BYTE	  028H,10000000B+OBK1+001H,03CH,00000000B+OWT0+00BH  : B
	 BYTE	  098H,00000000B+OBK1+001H,0FAH,00000000B+OBK1+000H
;
	 BYTE	  003H,10000000B+OBK1+002H,020H,00000000B+OSMS+000H  : C
;
	 BYTE	  07FH,0F0H+007H,10000000B+OST0,0F3H,00000000B+OPB1+007H  : D
;
	 BYTE	  08DH,10000000B+000H+OPL0
	BYTE	08EH,00000001B,0CFH,0F0H+006H,00000000B+OCS0   : E
;
	 BYTE	  0BDH,10000000B+SCOF	    ; SCROLL STOP	     : F
;
	 BYTE	  0FDH
;
;
;
FXOD13	 EQU	  $	    ;< Ground - 3 >		    / W 2 - 2 /
	 BYTE	  01010100B,00010001B
;
	 BYTE	  00FH,0F0H+006H,00000000B+OCS0				  : 0
;
	 BYTE	  038H,10000000B+OCM2+002H			     : 1
	 BYTE	  0ABH,00000000B+OCM2+001H
;
	 BYTE	  00BH,10000000B+OCM2+001H			     : 2
	 BYTE	  096H,00000000B+OCO0+002H
	 BYTE	  0CEH,00010000B
;
	 BYTE	  01EH,10010001B				     : 3
	 BYTE	  029H,00000000B+OPB1+001H,03AH,00000000B+OPB1+000H
	 BYTE	  04EH,00010000B
	 BYTE	  078H,00000000B+OCM2+004H
	 BYTE	  08EH,00010001B
;
	 BYTE	  006H,10000000B+OCO0+003H			     : 4
;
	 BYTE	  01AH,10000000B+OPB1+000H			     : 5
	 BYTE	  01EH,00010000B
	 BYTE	  05EH,00010001B
	 BYTE	  067H,00000000B+OPB1+003H,077H,00000000B+OPB1+003H
	 BYTE	  088H,00000000B+OPB1+002H,099H,00000000B+OPB1+001H
	 BYTE	  0AAH,00000000B+OPB1+000H
	 BYTE	  0BEH,00010000B
;
	 BYTE	  00AH,10000000B+OCM2+002H			     : 6
	 BYTE	  015H,00000000B+OCO0+005H
	 BYTE	  07EH,00010001B
	 BYTE	  07AH,00000000B+OBK1+001H
;
	 BYTE	  09AH,10000000B+OPB1+000H,0ACH,00000000B+OHL0+002H  : 7
	 BYTE	  0D9H,00000000B+OPB1+001H,0D4H,00000000B+000H+OBBS
	 BYTE	  0ECH,00000000B+OHL0+001H
;
;	    (point)
	 BYTE	  0D6H,10000000B+OCO0+002H			     : 8
;
	 BYTE	  084H,10000000B+OCO0+003H			     : 9
;
	 BYTE	  098H,10000000B+OCM0+002H,0D3H,00000000B+000H+OBBM  : A
	 BYTE	  0D7H,00000000B+000H+ORBC,0E9H,00000000B+OPB1+001H
	 BYTE	  0EEH,00010000B
;
	 BYTE	  02EH,10010001B				     : B
	 BYTE	  039H,00000000B+OCM2+001H
	 BYTE	  093H,00000000B+000H+OSCO,0A6H,00000000B+000H+OSCO
	 BYTE	  0BEH,00010000B
	 BYTE	  0E1H,00000000B+OCM2+001H,0E3H,00000000B+OBK1+001H
;
	 BYTE	  05EH,10010001B				     : C
	 BYTE	  069H,00000000B+OPB1+001H,0E6H,00000000B+OCO0+001H
;
	 BYTE	  028H,10000000B+OPB1+002H			     : D
	 BYTE	  099H,00000000B+OCM2+001H
	 BYTE	  0AEH,00010000B
	 BYTE	  0CEH,00010001B
;
	 BYTE	  0BEH,10010000B				     : E
	 BYTE	  0D6H,00000000B+OBK1+002H
;
	 BYTE	  03EH,10010001B				     : F
	 BYTE	  05FH,0F0H+007H,00000000B+OST0,066H,00000000B+OPB1+000H
	 BYTE	  0D3H,00000000B+OPB1+007H
;
	 BYTE	  06DH,10000000B+OPL0+000H,0AFH,0F0H+006H,00000000B+OCS0  :10
;
	 BYTE	  09DH,10000000B+000H+SCOF			     :11
;
	 BYTE	  0FDH						     : end of data
;
;
FXOD14	 EQU	  $	    ;< Ground - 4 >		    / W 2 - 3 /
	 BYTE	  01010100B,00010001B
;
	 BYTE	  00FH,0F0H+006H,00000000B+OCS0				  : 0
	 BYTE	  0AFH,0F0H+002H,00000000B+OST0,0D8H,00000000B+OPB1+002H
	 BYTE	  0E8H,00000000B+OPB1+002H,0F8H,00000000B+OPB1+002H
	 BYTE	  0FEH,00010000B
;
	 BYTE	  00CH,10000000B+OBG1+00EH,0F8H,00000000B+OPB1+004H  : 1
;
	 BYTE	  00DH,10000000B+JFST+000H			     : 2
	 BYTE	  02CH,00000000B+OBG2+003H,098H,00000000B+OPB1+004H
	 BYTE	  0ACH,00000000B+OBG1+009H
;
	 BYTE	  048H,10000000B+OPB1+004H,06AH,00000000B+OPB1+002H  : 3
	 BYTE	  07CH,00000000B+OBG2+007H,0FAH,00000000B+OPB1+002H
;
	 BYTE	  03CH,10000000B+OBG1+007H,0EAH,00000000B+OPB1+002H  : 4
	 BYTE	  0FCH,00000000B+OBG2+00DH,0F6H,00000000B+OBCO+000H
;
	 BYTE	  003H,10000000B+OBMS+000H,006H,00000000B+OBCO+000H  : 5
	 BYTE	  013H,00000000B+OBCO+000H,0DAH,00000000B+OPB1+002H
;
;	    (point)
	 BYTE	  00DH,10000000B+JFST+000H			     : 6
	 BYTE	  00BH,00000000B+OLD0+007H,097H,00000000B+OLD0+006H
;
	 BYTE	  02CH,10000000B+OBG1+001H,033H,00000000B+OCO0+003H  : 7
	 BYTE	  06CH,00000000B+OBG1+001H,0ACH,00000000B+OBG1+001H
;
	 BYTE	  017H,10000000B+OLD0+003H,073H,00000000B+OLD0+002H  : 8
	 BYTE	  0CCH,00000000B+OBG1+001H
;
	 BYTE	  01AH,10000000B+OPB1+002H,02CH,00000000B+OBG2+00BH  : 9
	 BYTE	  067H,00000000B+OCO0+008H,0EAH,00000000B+OPB1+002H
;
	 BYTE	  00DH,10000000B+EXOF+000H			     : A
	 BYTE	  017H,00000000B+OLD0+002H,053H,00000000B+OLD0+002H
	 BYTE	  0BEH,00010001B
;
	 BYTE	  01DH,10000000B+000H+OPL0			     : B
	 BYTE	  03EH,01000010B
	 BYTE	  03FH,0F0H+000H,00000000B+OCS0
;
	 BYTE	  01DH,10000000B+000H+SCOF			     : C
;
	 BYTE	  0FDH
;
;
FXOD15	 EQU	  $	    ;< Ground - 5 >		    / W 3 - 1 /
;
	 BYTE	  01010010B,10110001B
;
	 BYTE	  00FH,0F0H+000H,00000000B+OCS0				  : 0
	 BYTE	  06EH,01110101B
;
	 BYTE	  053H,10000000B+OBK0+00AH,057H,00000000B+OBK0+005H  : 1
	 BYTE	  0B7H,00000000B+OBBS+000H,0C7H,00000000B+OBK0+003H
;
	 BYTE	  00CH,10000000B+OHL0+003H,05CH,00000000B+OBC2+002H  : 2
	 BYTE	  087H,00000000B+ODMS+000H
	 BYTE	  0C3H,00000000B+OBMS+000H,0C7H,00000000B+OBK0+000H
	 BYTE	  0DCH,00000000B+OBC1+005H
;
	 BYTE	  00CH,10000000B+OHL0+007H,0C3H,00000000B+OBK0+002H  : 3
	 BYTE	  0F3H,00000000B+OSCO+000H
;
	 BYTE	  003H,10000000B+OBK0+002H,027H,00000000B+OCM0+003H  : 4
	 BYTE	  033H,00000000B+OSCO+000H
	 BYTE	  043H,00000000B+OBK0+003H
	 BYTE	  052H,00000000B+OCO0+002H
	 BYTE	  09CH,00000000B+OHL0+006H
	 BYTE	  0A7H,00000000B+OBK0+000H,0C3H,00000000B+OBK0+003H
;
	 BYTE	  003H,10000000B+OBK0+002H,00CH,00000000B+OHL0+002H  : 5
	 BYTE	  033H,00000000B+OBBW+000H,039H,00000000B+OCM2+001H
	 BYTE	  043H,00000000B+OBK0+003H,077H,00000000B+OSBM+000H
	 BYTE	  083H,00000000B+OPB1+007H,0A7H,00000000B+OCM2+003H
;
;	    (point)
	 BYTE	  05CH,10000000B+OHL0+002H
	BYTE	0AEH,00000001B,0C9H,00000000B+OGN0+001H	 : 6
	BYTE	0DEH,00110001B
;
	 BYTE	  007H,10000000B+OBMS+000H,01CH,00000000B+OBC2+001H  : 7
	BYTE	07EH,00000001B
	 BYTE	  098H,00000000B+OGN0+001H
	 BYTE	  09AH,00000000B+OGN0+000H
	 BYTE	  0F3H,00000000B+OSMS+000H
;
	 BYTE	  016H,10000000B+OCM2+004H			     : 8
	 BYTE	  03CH,00000000B+OHL0+002H,068H,00000000B+OCM0+002H
	 BYTE	  08CH,00000000B+OHL0+001H,0A7H,00000000B+OCM2+003H
	BYTE	0DEH,00110001B
	 BYTE	  0E7H,00000000B+OCM2+003H
;
	 BYTE	  0ACH,10000000B+OHL0+003H			     : 9
;
	 BYTE	  009H,10000000B+000H+OBOD,01CH,00000000B+OHL0+003H  : A
	 BYTE	  09FH,0F0H+007H,00000000B+OST0
;
	 BYTE	  013H,10000000B+OPB1+007H			     : B
	 BYTE	  07CH,00000000B+OHL0+002H
	 BYTE	  0ADH,00000000B+000H+OPL0
	 BYTE	  0EFH,0F0H+006H,00000000B+OCS0
;
	 BYTE	  00DH,00EH
	 BYTE	  039H,00000000B+OCM2+001H,07FH,0F0H+007H,00000000B+OST0  : E
	 BYTE	  0F2H,00000000B+OPB1+008H
;
	 BYTE	  002H,10000000B+OPB1+008H,012H,00000000B+OBK1+00AH  : F
	 BYTE	  01CH,00000000B+OHL0+000H,068H,00000000B+OCM0+002H
;
	 BYTE	  0E0H,00000000B+OPB1+00AH
	 BYTE	  0F0H,00000000B+OPB1+00AH
;
	 BYTE	  000H,00000000B+OPB1+00AH
	 BYTE	  06DH,10000000B+SLON+000H
;
;;;	    BYTE     0DEH,00111111B
;
;;;	    BYTE     06DH,10000000B+000H+SLON				:10
;
	 BYTE	  0FDH
;
FXOD16	 EQU	  $	    ;< Ground - 6 >		    / W 3 - 3 /
;
	 BYTE	  01010101B,00010000B
;
	 BYTE	  00BH,00000000B+OLD0+00FH,00FH,0F0H+006H,00000000B+OCS0  : 0
	 BYTE	  0D6H,00000000B+OLD0+002H
;
	 BYTE	  007H,10000000B+OLD0+00FH,033H,00000000B+OLD0+00AH  : 1
	 BYTE	  0FBH,00000000B+OLD0+00FH
;
	 BYTE	  0F7H,10000000B+OLD0+004H			     : 2
;
	 BYTE	  053H,10000000B+OLD0+004H,071H,00000000B+OCM2+001H  : 3
	 BYTE	  0CCH,00000000B+OEP0+005H,0CFH,0F0H+003H,00000000B+OLW0
;
	 BYTE	  01FH,0F0H+008H,10000000B+OLW0,063H,00000000B+OLD0+002H  : 4
	 BYTE	  09BH,00000000B+OLD0+003H,0A9H,00000000B+OCM2+001H
	 BYTE	  0FBH,00000000B+OLD0+007H
;
	 BYTE	  009H,10000000B+OCM2+001H,013H,00000000B+OLD0+003H  : 5
	 BYTE	  021H,00000000B+OCO0+002H
	 BYTE	  059H,00000000B+OBOD+000H,0EBH,00000000B+OLD0+003H
;
	 BYTE	  033H,10000000B+OLD0+003H,040H,00000000B+OSBM+000H  : 6
	 BYTE	  08CH,00000000B+OEP0+004H,08FH,0F0H+007H,00000000B+OLW0
	 BYTE	  093H,00000000B+OCO0+000H,0CFH,0F0H+003H,00000000B+OLW0
;
;	    (point)
	 BYTE	  00BH,10000000B+OLD0+004H,057H,00000000B+OLD0+005H  : 7
;
	 BYTE	  007H,10000000B+OLD0+003H			     : 8
;
	 BYTE	  019H,10000000B+OCM2+003H			     : 9
	 BYTE	  0C6H,00000000B+OCO0+003H,0C7H,00000000B+OLD0+003H
	 BYTE	  0D3H,00000000B+OSCO+000H,0E3H,00000000B+OSCO+000H
;
	 BYTE	  033H,10000000B+OBK1+000H,04AH,00000000B+OCM2+002H  : A
	 BYTE	  055H,00000000B+OCO0+006H,073H,00000000B+OBK1+001H
	 BYTE	  0A8H,00000000B+OCM2+004H,0E3H,00000000B+OLD0+002H
;
	 BYTE	  08EH,10010001B				     : B
	 BYTE	  0ADH,00000000B+000H+OPL0
	 BYTE	  0CEH,01000010B
	 BYTE	  0CFH,0F0H+000H,00000000B+OCS0
;
	 BYTE	  0BDH,10000000B+000H+SCOF			     : C
;
	 BYTE	  0FDH
;
;
FXOD17	 EQU	  $	    ;< Ground - 7 >		    / W 4 - 1 /
	 BYTE	  01010010B,00100001B
;
	 BYTE	  00FH,0F0H+000H,00000000B+OCS0				  : 0
	 BYTE	  06EH,01100011B
;
	 BYTE	  0A9H,10000000B+OCM2+001H,0FBH,00000000B+OCM2+001H  : 1
;
	 BYTE	  022H,10000000B+000H+OSCO,037H,00000000B+000H+ORBC  : 2
	 BYTE	  036H,00000000B+OPB0+000H,039H,00000000B+OPB0+001H
	 BYTE	  0B8H,00000000B+OPB1+002H
;
	 BYTE	  057H,10000000B+OCM2+003H,0E8H,00000000B+000H+OBCO  : 3
	 BYTE	  0F8H,00000000B+000H+OBCO
;
	 BYTE	  008H,10000000B+000H+OBCO,018H,00000000B+000H+OBCO  : 4
	 BYTE	  02DH,00000000B+000H+EXOF
	 BYTE	  028H,00000000B+000H+OBCO,038H,00000000B+000H+OBCO
	 BYTE	  048H,00000000B+000H+OBMS
	 BYTE	  0A8H,00000000B+000H+OBOD
	 BYTE	  0AAH,00000000B+OBK1+000H,0BCH,00000000B+OWT0+00AH
;
	 BYTE	  06AH,10000000B+OBK1+000H			     : 5
;
	 BYTE	  04FH,0F0H+006H,10000000B+OST0,0B7H,00000000B+000H+OSMS  : 6
;
;	    (point)
	 BYTE	  09AH,10000000B+OBK1+000H,0ACH,00000000B+OBC2+001H  : 7
	 BYTE	  0C7H,00000000B+ODMS+000H,0E6H,00000000B+OCM2+004H
;
	 BYTE	  00DH,009H
	 BYTE	  046H,00000000B+OBCO+000H,056H,00000000B+OBMS+000H  : 9
	 BYTE	  06CH,00000000B+OHL0+001H,084H,00000000B+OCM0+001H
	 BYTE	  086H,00000000B+OBCO+000H,096H,00000000B+OBCO+000H
	 BYTE	  0A4H,00000000B+OCM2+001H,0A6H,00000000B+OBCO+000H
	 BYTE	  0B6H,00000000B+OBCO+000H,0C4H,00000000B+OCM2+001H
	 BYTE	  0C6H,00000000B+OBCO+000H,0D6H,00000000B+OBCO+000H
;
	 BYTE	  039H,10000000B+OCM2+001H,06CH,00000000B+OHL0+000H  : A
	 BYTE	  077H,00000000B+OBCO+000H
	 BYTE	  0A3H,00000000B+OBBW+000H,0ACH,00000000B+OHL0+000H
	 BYTE	  0B8H,00000000B+OCM2+002H,0DCH,00000000B+OHL0+001H
;
	 BYTE	  007H,10000000B+OCM2+003H,04CH,00000000B+OHL0+000H  : B
	 BYTE	  06FH,0F0H+007H,00000000B+OST0,0E3H,00000000B+OSCO+000H
	 BYTE	  0E6H,00000000B+OSCO+000H
;
	 BYTE	  05DH,10000000B+000H+EXOF			     : C
	 BYTE	  06CH,00000000B+OHL0+000H
	 BYTE	  07DH,00000000B+000H+OPL0
	 BYTE	  0BFH,0F0H+006H,00000000B+OCS0
;
	 BYTE	  08DH,10000000B+000H+SCOF			     : D
;
	 BYTE	  0FDH
;
;
FXOD18	 EQU	  $	    ;< Ground - 8 >		    / W 4 - 2 /
	 BYTE	  01010000B,10100001B
;
	 BYTE	  00FH,0F0H+006H,00000000B+OCS0				  : 0
;
	 BYTE	  017H,10000000B+OGN0+001H,019H,00000000B+OGN0+001H  : 1
	 BYTE	  048H,00000000B+000H+OBMS
	 BYTE	  068H,00000000B+OGN0+001H,06AH,00000000B+OGN0+000H
	 BYTE	  096H,00000000B+OGN0+004H,0D8H,00000000B+000H+OBBS
	 BYTE	  0E8H,00000000B+000H+OBCO,0F8H,00000000B+000H+OBCO
;
	 BYTE	  0DCH,10000000B+OHL0+001H			     : 2
;
	 BYTE	  06CH,10000000B+OHL0+001H,089H,00000000B+000H+OBOD  : 3
	 BYTE	  09CH,00000000B+OHL0+000H,0C3H,00000000B+OBK0+009H
	 BYTE	  0F8H,00000000B+OPB1+002H
;
	 BYTE	  047H,10000000B+OBK0+007H,0C6H,00000000B+OPB1+001H  : 4
;
;	    (point)
	 BYTE	  00DH,007H
	 BYTE	  056H,00000000B+OCM2+004H,0B7H,00000000B+OBMS+000H  : 7
	 BYTE	  0B9H,00000000B+OGN0+001H,0CCH,00000000B+OBC2+006H
	 BYTE	  0EDH,00000000B+000H+EXOF
;
	 BYTE	  01CH,10000000B+OHL0+000H,037H,00000000B+ODMS+000H  : 8
	 BYTE	  03AH,00000000B+OGN0+000H
	 BYTE	  0DEH,00100000B
	 BYTE	  0E9H,00000000B+ORBC+000H
	 BYTE	  0EEH,00100001B
;
	 BYTE	  0C8H,10000000B+OBK1+00CH			     : 9
;
	 BYTE	  09CH,10000000B+OBC2+006H,0BCH,00000000B+OHL0+000H  : A
	 BYTE	  0CBH,00000000B+OCM0+002H,0EBH,00000000B+OCM2+002H
;
	 BYTE	  00CH,10000000B+OHL0+002H
	 BYTE	  039H,00000000B+OCM2+001H,0B7H,00000000B+OPB1+003H  : B
	 BYTE	  0CCH,00000000B+OHL0+003H,0E6H,00000000B+OPB1+000H
;
	 BYTE	  026H,10000000B+OPB1+000H,04AH,00000000B+OBK1+000H  : C
	 BYTE	  053H,00000000B+OBK1+001H,05CH,00000000B+OWT0+008H
	 BYTE	  0EDH,00000000B+000H+OPL0
;
	 BYTE	  02FH,0F0H+006H,10000000B+OCS0				  : D
;
	 BYTE	  01DH,10000000B+000H+SCOF			     : E
;
	 BYTE	  0FDH
;
;
FXOD20	 EQU	  $	    ;< Ground - 10 >		    / W 4 - 3 /
	 BYTE	  01010000B,00010001B
;
	 BYTE	  00FH,0F0H+006H,00000000B+OCS0				  : 0
	 BYTE	  0FEH,00010000B
;
	 BYTE	  08BH,10000000B+OLD0+003H,0A9H,00000000B+OBOD+000H  : 1
;
	 BYTE	  014H,10000000B+OCO0+001H			     : 2
	 BYTE	  0CCH,00000000B+OEP0+006H,0CFH,0F0H+001H,00000000B+OLW0
;
	 BYTE	  02FH,0F0H+005H,10000000B+OLW0,0B7H,00000000B+OLD0+004H  : 3
;
	 BYTE	  0C7H,10000000B+OLD0+006H,0D6H,00000000B+OCO0+004H  : 4
;
	 BYTE	  02BH,10000000B+OLD0+002H,039H,00000000B+OBOD+000H  : 5
	 BYTE	  072H,00000000B+OCO0+001H,0A7H,00000000B+OBMS+000H
;
;	    (point)
	 BYTE	  01BH,10000000B+OLD0+005H,097H,00000000B+OLD0+003H  : 6
;
	 BYTE	  06CH,10000000B+OEP0+005H,06FH,0F0H+001H,00000000B+OLW0  : 7
	 BYTE	  0A2H,00000000B+OCO0+000H,0BFH,0F0H+005H,00000000B+OLW0
	 BYTE	  0C2H,00000000B+OCO0+000H
;
	 BYTE	  00BH,10000000B+OLD0+00FH,053H,00000000B+OLD0+006H  : 8
	 BYTE	  062H,00000000B+OCO0+004H
;
	 BYTE	  072H,10000000B+OCO0+002H,09BH,00000000B+OLD0+00DH  : 9
;
	 BYTE	  0B7H,10000000B+OPB1+000H,0EDH,00000000B+000H+EXOF  : A
;
	 BYTE	  003H,10000000B+OPB1+000H			     : B
	 BYTE	  08EH,00010001B
	 BYTE	  09DH,00000000B+000H+OPL0
	 BYTE	  0BEH,01000010B
	 BYTE	  0BFH,0F0H+000H,00000000B+OCS0
;
	 BYTE	  09DH,10000000B+SCOF+000H			     : C
;
	 BYTE	  0FDH						     : end
;
;
FXOD29	 EQU	  $	    ;< Ground - 19 >	  :BOUNS ;<SKY>
	 BYTE	  00000000B,11000001B
;
	 BYTE	  04CH,00000000B+OHL0+000H			     : 0
;
	 BYTE	  003H,10000000B+OCO0+00FH			     : 1
;
	 BYTE	  000H,10000000B+OPB0+007H			     : 2
	 BYTE	  023H,00000000B+OCO0+00DH
;
	 BYTE	  007H,10000000B+OBK0+00FH,02AH,00000000B+OCO0+00CH  : 3
;
	 BYTE	  003H,10000000B+OCO0+00FH			     : 4
;
	 BYTE	  03EH,10000000B				     : 5
	 BYTE	  0F3H,00000000B+OCO0+00AH
;
	 BYTE	  0BBH,10000000B+OCO0+002H			     : 6
;
	 BYTE	  0BDH,10000000B+000H+SCOF			     : 7
;
	 BYTE	  0FDH
;
;
;#####################################################################
;#	 Fix obstacle out pos data  ( Underground )		     #
;#####################################################################
FXOD40	 EQU	  $	    ;< Underground - 0 >	    / W 1 - 2 /
	 BYTE	  01001000B,00001111B
;
	 BYTE	  00EH,00000001B				     : 0
	 BYTE	  05EH,00000010B
;
	 BYTE	  00AH,10000000B+OBK1+000H,01CH,00000000B+OHL0+004H  : 1
	 BYTE	  06AH,00000000B+OBK1+000H
	 BYTE	  07FH,0F0H+004H,00000000B+OST0
	 BYTE	  0C6H,00000000B+OPB1+004H,0D6H,00000000B+OPB1+004H
	 BYTE	  0E6H,00000000B+OPB1+004H,0F6H,00000000B+OPB1+004H
	 BYTE	  0FEH,00000000B
	 BYTE	  0F0H,00000000B+OBBM+000H
;
	 BYTE	  000H,10000000B+OBK0+001H			     : 2
	 BYTE	  01EH,00000010B
	 BYTE	  047H,00000000B+OCM2+003H
	 BYTE	  07EH,00000100B
	 BYTE	  084H,00000000B+OPB0+002H,094H,00000000B+OPB0+000H
	 BYTE	  095H,00000000B+ORBC+000H,096H,00000000B+OPB0+000H
	 BYTE	  0A4H,00000000B+OPB0+002H
	 BYTE	  0AEH,00000101B
	 BYTE	  0B8H,00000000B+OPB0+001H,0C8H,00000000B+OPB0+001H
	 BYTE	  0CEH,00000001B
;
	 BYTE	  017H,10000000B+OCM2+003H,045H,00000000B+OSCO+000H  : 3
	 BYTE	  052H,00000000B+OBBW+000H
	 BYTE	  062H,00000000B+OBK0+001H,06FH,0F0H+004H,00000000B+OST0
	 BYTE	  081H,00000000B+OBK0+001H
	 BYTE	  09EH,00000010B
	 BYTE	  0B6H,00000000B+OPB1+004H
	 BYTE	  0C6H,00000000B+OPB1+004H
	 BYTE	  0C0H,00000000B+OBSM+000H
	 BYTE	  0D6H,00000000B+OPB1+004H
	 BYTE	  0D0H,00000000B+OBBM+000H
	 BYTE	  0E6H,00000000B+OPB1+004H
	 BYTE	  0E0H,00000000B+OBSM+000H
	 BYTE	  0F0H,00000000B+OBBM+000H
	 BYTE	  0FEH,00001010B
;
;
;	    (point)
;;;;;;;;;;;;;;	  01EH,10000100B				     : 5
;;;;;;;;;;;;;	  02CH,00000000B+OBC2+002H,057H,00000000B+OBMS+000H
;;;;;;;;;;;;;	  06CH,00000000B+OBC2+005H,0C7H,00000000B+ODMS+000H
;;;;;;;;;;;;;	  0DCH,00000000B+OBC2+002H
;;;;;;;;;;;;;;	  0FEH,00000010B
;
	 BYTE	  00DH,006H
	 BYTE	  00EH,00000001B				     : 6
	 BYTE	  04EH,00000100B
	 BYTE	  067H,00000000B+OCM2+003H
	 BYTE	  08EH,00000010B
	 BYTE	  0B7H,00000000B+OBBS+000H,0BCH,00000000B+OHL0+003H
	 BYTE	  0C4H,00000000B+OCM2+002H,0C7H,00000000B+OBK0+002H
;
	 BYTE	  008H,10000000B+OCM2+002H,02CH,00000000B+OHL0+002H  : 7
	 BYTE	  059H,00000000B+OCM2+001H,07CH,00000000B+OHL0+001H
	 BYTE	  096H,00000000B+OCM2+004H,0BCH,00000000B+OHL0+001H
	 BYTE	  0D8H,00000000B+OCM2+002H,0FCH,00000000B+OHL0+001H
;
	 BYTE	  039H,10000000B+OCM2+001H			     : 8
	 BYTE	  04EH,00000001B
	 BYTE	  09EH,00000100B
	 BYTE	  0A7H,00000000B+OPB0+002H,0B7H,00000000B+ORBC+000H
	 BYTE	  0B8H,00000000B+OPB0+001H,0C7H,00000000B+OPB0+001H
	 BYTE	  0D7H,00000000B+OPB0+000H
	 BYTE	  0DEH,00000010B
;
	 BYTE	  03AH,10000000B+OPB1+000H			     : 9
	 BYTE	  03EH,00001010B
	 BYTE	  09EH,00000000B
;
	 BYTE	  008H,10000000B+OPB0+004H,018H,00000000B+OPB0+004H  : A
	 BYTE	  028H,00000000B+OPB0+004H,048H,00000000B+OPB0+004H
	 BYTE	  06EH,00000110B
	 BYTE	  09EH,00000001B
	 BYTE	  0A8H,00000000B+OPB0+002H,0AFH,0F0H+007H,00000000B+OCM1
	 BYTE	  0B8H,00000000B+OPB0+002H,0C8H,00000000B+OPB0+002H
	 BYTE	  0D8H,00000000B+OPB0+002H
	 BYTE	  0DEH,00001111B
;
	 BYTE	  04DH,10000000B+SCOF+000H			     : B
	 BYTE	  0CEH,00000001B
	 BYTE	  0DCH,00000000B+OHL0+001H,0F9H,00000000B+OCM0+001H
;
	 BYTE	  01CH,10000000B+OHL0+002H,048H,00000000B+OCM2+002H  : C
	 BYTE	  07FH,0F0H+007H,00000000B+OST0,0F2H,00000000B+OPB1+008H
;
	 BYTE	  001H,10000000B+OPB1+009H			     : D
	 BYTE	  011H,00000000B+OBK1+00AH
	 BYTE	  068H,00000000B+OCM0+002H
	 BYTE	  0DEH,00001111B
;
	 BYTE	  06DH,10000000B+000H+SLON			     : E
;
	 BYTE	  0FDH
;
;
FXOD41	 EQU	  $	    ;< Underground - 1 >       ;<W1-2>
;
	 BYTE	  00001011B,00001111B
;
	 BYTE	  00EH,00000001B				     : 0
	 BYTE	  09CH,00000000B+OBC2+001H,0B7H,00000000B+OBMS+000H
	 BYTE	  0BEH,00000000B
;
	 BYTE	  03EH,10000001B				     : 1
	 BYTE	  047H,00000000B+OCM2+003H
	 BYTE	  05EH,00000000B
	 BYTE	  063H,00000000B+OCO0+002H
	 BYTE	  08EH,00000001B
	 BYTE	  0A7H,00000000B+OCM2+003H
	 BYTE	  0BEH,00000000B
;
	 BYTE	  07EH,10000001B				     : 2
	 BYTE	  088H,00000000B+OCM2+002H,0F0H,00000000B+OPB0+009H
	 BYTE	  0FEH,00000000B
;
	 BYTE	  000H,10000000B+OPB0+009H			     : 3
	 BYTE	  00EH,00000001B
	 BYTE	  039H,00000000B+OCM0+001H,0A7H,00000000B+OSCO+000H
	 BYTE	  0AEH,00000000B
	 BYTE	  0B4H,00000000B+OSCO+000H
	 BYTE	  0DEH,00001111B
;
	 BYTE	  00DH,005H
	 BYTE	  00EH,00000010B				     : 5
	 BYTE	  068H,00000000B+OCM0+002H
	 BYTE	  0BEH,00000001B
	 BYTE	  0DEH,00001111B
;
	 BYTE	  06DH,10000000B+000H+SLON			     : 6
;
	 BYTE	  0FDH
;
;
;
FXOD42	 EQU	  $	    ;< Underground - 2 >
	 BYTE	  00001000B,10001111B
;
; (UNDERGROUND-1)
	 BYTE	  00EH,00000001B				     : 0
;
	 BYTE	  017H,00000000B+000H+OSDM
;
	 BYTE	  02EH,00000010B
;
	 BYTE	  030H,00000000B+000H+OBBM,037H,00000000B+OSCO+000H
	 BYTE	  03AH,00000000B+OCO0+009H,044H,00000000B+000H+OSCO
	 BYTE	  058H,00000000B+OCO0+007H,0DFH,0F0H+00AH,00000000B+OCM1
;
	 BYTE	  06DH,10000000B+SCOF+000H			     : 1
;
;-----------------------------------------------------------------------
;
; (UNDERGROUND-2)
	 BYTE	  00EH,10000001B				     : 2
	 BYTE	  000H,00000000B+OPB0+00AH
	 BYTE	  02EH,00000010B
	 BYTE	  087H,00000000B+OPB0+002H,097H,00000000B+OBK0+00FH
	 BYTE	  099H,00000000B+OCO0+00FH
;
	 BYTE	  00AH,10000000B+OGN0+000H,093H,00000000B+OPB0+006H  : 3
	 BYTE	  0A3H,00000000B+000H+ORBC,0A7H,00000000B+OPB0+000H
	 BYTE	  0B3H,00000000B+OPB0+005H
;
	 BYTE	  0DFH,0F0H+00AH,00000000B+OCM1
;
	 BYTE	  06DH,10000000B+SCOF+000H			     : 4
;
;-----------------------------------------------------------------------
;
; (UNDERGROUND-3)
	 BYTE	  00EH,10000001B				     : 5
	 BYTE	  000H,00000000B+OPB0+00AH
	 BYTE	  02EH,00000000B
	 BYTE	  03EH,00000010B
	 BYTE	  041H,00000000B+OPB0+006H,057H,00000000B+OBK0+005H
	 BYTE	  056H,00000000B+OCO0+005H
	 BYTE	  068H,00000000B+OPB0+001H,07AH,00000000B+OCO0+003H
	 BYTE	  0B7H,00000000B+000H+ORBC,0B8H,00000000B+OPB0+001H
;
	 BYTE	  0DFH,0F0H+00AH,00000000B+OCM1
;
	 BYTE	  06DH,10000000B+SCOF+000H			     : 6
;
;-----------------------------------------------------------------------
;
	 BYTE	  0FDH		   : END
;
;
;#####################################################################
;#	 Fix obstacle out pos data  ( Underwater )		     #
;#####################################################################
;
FXOD50	 EQU	  $	    ;< Underwater - 0 >		    / W 3 - 2 /
	 BYTE	  01000001B,00000001B
;
	 BYTE	  003H,10000000B+OBK1+004H,004H,00000000B+OBK1+004H  : 1
	 BYTE	  005H,00000000B+OBK1+004H,05CH,00000000B+OHL0+002H
	 BYTE	  083H,00000000B+OBK1+007H,084H,00000000B+OBK1+007H
	 BYTE	  085H,00000000B+OBK1+007H
;
	 BYTE	  009H,10000000B+OCO0+002H,00CH,00000000B+OHL0+002H  : 2
	 BYTE	  01DH,00000000B+000H+WFST,0FAH,00000000B+OPB1+000H
;
	 BYTE	  009H,10000000B+OPB1+001H,018H,00000000B+OPB1+002H  : 3
	 BYTE	  020H,00000000B+OPB1+003H,027H,00000000B+OPB1+003H
	 BYTE	  033H,00000000B+OBK1+007H,037H,00000000B+OPB1+003H
	 BYTE	  047H,00000000B+OPB1+003H,05CH,00000000B+OHL0+005H
	 BYTE	  079H,00000000B+OCO0+003H
;;;;;	      BYTE     0FEH,00000110B
;
	 BYTE	  000H,10000000B+OBK1+00FH,008H,00000000B+OBK1+00FH
	 BYTE	  009H,00000000B+OBK1+00FH,00AH,00000000B+OBK1+00FH
	 BYTE	  035H,00000000B+OPB0+002H,046H,00000000B+OCO0+008H  : 4
	 BYTE	  091H,00000000B+OPB0+003H,0D6H,00000000B+OPB0+001H
	 BYTE	  0FEH,00000001B
;
	 BYTE	  00CH,10000000B+OHL0+003H,06CH,00000000B+OHL0+004H  : 5
	 BYTE	  0B4H,00000000B+OPB1+002H,0C4H,00000000B+OPB1+002H
	 BYTE	  0D4H,00000000B+OPB1+002H,0E4H,00000000B+OPB1+002H
	 BYTE	  0F4H,00000000B+OPB1+002H
;
;	    (point)
	 BYTE	  018H,10000000B+OPB0+002H,079H,00000000B+OPB0+001H  : 6
	 BYTE	  0F4H,00000000B+OPB1+006H
;;;;;	      BYTE     0FEH,00000010B
;
	 BYTE	  000H,10000000B+OBK1+00FH
	 BYTE	  00CH,00000000B+OHL0+00AH			     : 7
	 BYTE	  01DH,00000000B+000H+WFST
	 BYTE	  031H,00000000B+OPB0+005H,056H,00000000B+OCO0+001H
	 BYTE	  077H,00000000B+OCO0+001H,098H,00000000B+OCO0+001H
	 BYTE	  0C5H,00000000B+OPB0+005H
;;;;;	      BYTE     0FEH,00000001B
;
	 BYTE	  007H,10000000B+OPB1+003H,017H,00000000B+OPB1+003H  : 8
	 BYTE	  027H,00000000B+OPB1+003H,037H,00000000B+OPB1+003H
	 BYTE	  047H,00000000B+OPB1+003H,057H,00000000B+OPB1+003H
	 BYTE	  067H,00000000B+OPB1+003H,078H,00000000B+OPB1+002H
	 BYTE	  089H,00000000B+OPB1+001H,09AH,00000000B+OPB1+000H
	 BYTE	  0BCH,00000000B+OHL0+007H,0CAH,00000000B+OCO0+002H
;
	 BYTE	  03AH,10000000B+OBK1+003H			     : 9
	 BYTE	  046H,00000000B+OPB0+003H,063H,00000000B+OBK1+004H
	 BYTE	  066H,00000000B+OCO0+004H,07CH,00000000B+OHL0+001H
	 BYTE	  09AH,00000000B+OBK1+003H,0B7H,00000000B+OPB0+002H
	 BYTE	  0DCH,00000000B+OHL0+001H,0FAH,00000000B+OBK1+002H
;
	 BYTE	  005H,10000000B+OPB0+004H,02CH,00000000B+OHL0+00DH  : A
	 BYTE	  043H,00000000B+OBK1+007H,047H,00000000B+OBK1+005H
	 BYTE	  0B7H,00000000B+OBK1+000H,0C3H,00000000B+OPB1+004H
;
	 BYTE	  023H,10000000B+OPB1+004H,029H,00000000B+OCO0+005H  : B
	 BYTE	  033H,00000000B+OPB1+004H,043H,00000000B+OPB1+004H
	 BYTE	  053H,00000000B+OPB1+004H,063H,00000000B+OPB1+004H
	 BYTE	  073H,00000000B+OPB1+004H,09AH,00000000B+OPB1+000H
	 BYTE	  0A9H,00000000B+OPB1+001H,0B8H,00000000B+OPB1+002H
	 BYTE	  0C0H,00000000B+OPB1+003H,0C7H,00000000B+OPB1+003H
	 BYTE	  0D0H,00000000B+OPB1+004H,0D5H,00000000B+OWC0+000H
	 BYTE	  0D7H,00000000B+OPB1+003H
	 BYTE	  0E0H,00000000B+OPB1+00AH,0F0H,00000000B+OPB1+00AH
;
	 BYTE	  000H,10000000B+OPB1+00AH
	 BYTE	  00DH,00000000B+000H+EXOF,07DH,00000000B+SCOF+000H  : C
;
	 BYTE	  0FDH
;
;
FXOD52	 EQU	  $	    ;< Underwater - 2 >		    ;<BONUS>
	 BYTE	  00000001B,00000001B
;
	 BYTE	  078H,00000000B+OPB0+002H,0B5H,00000000B+OPB0+005H  : 0
	 BYTE	  0DAH,00000000B+OPB1+000H,0E9H,00000000B+OPB1+001H
	 BYTE	  0F8H,00000000B+OPB1+002H
;
	BYTE	000H,10000000B+OPB1+003H,007H,00000000B+OPB1+003H
	BYTE	010H,00000000B+OPB1+003H,017H,00000000B+OPB1+003H
	BYTE	020H,00000000B+OPB1+003H,027H,00000000B+OPB1+003H
	BYTE	030H,00000000B+OPB1+003H,037H,00000000B+OPB1+003H
	BYTE	040H,00000000B+OPB1+003H,047H,00000000B+OPB1+003H
	BYTE	050H,00000000B+OPB1+003H,057H,00000000B+OPB1+003H
	BYTE	060H,00000000B+OPB1+003H,067H,00000000B+OPB1+003H
	BYTE	070H,00000000B+OPB1+003H,077H,00000000B+OPB1+003H
	BYTE	080H,00000000B+OPB1+003H,087H,00000000B+OPB1+003H
	BYTE	090H,00000000B+OPB1+003H,097H,00000000B+OPB1+003H
	BYTE	0A0H,00000000B+OPB1+003H,0A7H,00000000B+OPB1+003H
	BYTE	0B0H,00000000B+OPB1+003H,0B7H,00000000B+OPB1+003H
	BYTE	0C0H,00000000B+OPB1+003H,0C7H,00000000B+OPB1+003H
	BYTE	0D0H,00000000B+OPB1+003H,0D7H,00000000B+OPB1+003H
	BYTE	0E0H,00000000B+OPB1+003H,0E7H,00000000B+OPB1+003H
	BYTE	0F0H,00000000B+OPB1+003H,0F7H,00000000B+OPB1+003H
;
	 BYTE	  00AH,10000000B+OCO0+00FH,036H,00000000B+OCO0+009H  : 2
	 BYTE	  062H,00000000B+OCO0+003H
;
	BYTE	000H,10000000B+OPB1+002H,008H,00000000B+OPB1+002H
	BYTE	010H,00000000B+OPB1+002H,018H,00000000B+OPB1+002H
	BYTE	020H,00000000B+OPB1+002H,028H,00000000B+OPB1+002H
	BYTE	030H,00000000B+OPB1+002H,038H,00000000B+OPB1+002H
	 BYTE	  036H,00000000B+OCO0+009H			     : 3
	BYTE	040H,00000000B+OPB1+002H,048H,00000000B+OPB1+002H
	BYTE	050H,00000000B+OPB1+002H,058H,00000000B+OPB1+002H
	BYTE	060H,00000000B+OPB1+002H,068H,00000000B+OPB1+002H
	BYTE	070H,00000000B+OPB1+002H,078H,00000000B+OPB1+002H
	BYTE	080H,00000000B+OPB1+002H,088H,00000000B+OPB1+002H
	BYTE	090H,00000000B+OPB1+002H,098H,00000000B+OPB1+002H
	BYTE	0A0H,00000000B+OPB1+002H,0A8H,00000000B+OPB1+002H
	BYTE	0B0H,00000000B+OPB1+002H,0B8H,00000000B+OPB1+002H
	BYTE	0C0H,00000000B+OPB1+002H,0C8H,00000000B+OPB1+002H
	BYTE	0D0H,00000000B+OPB1+002H,0D8H,00000000B+OPB1+002H
	BYTE	0E0H,00000000B+OPB1+002H,0E8H,00000000B+OPB1+002H
	BYTE	0F0H,00000000B+OPB1+002H,0F8H,00000000B+OPB1+002H
;
	 BYTE	  00CH,10000000B+OHL0+004H,065H,00000000B+OPB0+005H  : 4
	 BYTE	  097H,00000000B+OPB0+002H,09AH,00000000B+OBK1+002H
	 BYTE	  0A9H,00000000B+OBK1+001H,0B8H,00000000B+OBK1+000H
	 BYTE	  0C7H,00000000B+OPB1+003H
;
	BYTE	0D0H,00000000B+OPB1+00AH
	 BYTE	  0D5H,00000000B+OWC0+000H
	BYTE	0E0H,00000000B+OPB1+00AH
	BYTE	0F0H,00000000B+OPB1+00AH
;
	BYTE	000H,10000000B+OPB1+00AH
	 BYTE	  07DH,00000000B+SCOF+000H			     : 5
;
	 BYTE	  0FDH
;
;*********************************************************************
;*	 Castle loop check data					     *
;*********************************************************************
DA01	 EQU	  DA001-FXOD02
DA02	 EQU	  DA002-FXOD02
;
;#####################################################################
;#	 Fix chara out pos data	 ( Castle )			     #
;#####################################################################
FXCD04	 EQU	  $	    ;< Castle - 04 >		    / W 5 - 4 /
	 BYTE	  02AH,10000000B+LFT5,06BH,00000000B+JPTR	     : 1
	 BYTE	  0CBH,00000000B+JPTR
;
	 BYTE	  015H,10000000B+SST1,089H,00000000B+SST1	     : 2
	 BYTE	  0CCH,00000000B+SST2
;
	 BYTE	  009H,10000000B+SST2,0F5H,00000000B+SST1	     : 3
;
	 BYTE	  06BH,10000000B+LFT5,0ABH,00000000B+JPTR	     : 4
	 BYTE	  0DBH,00000000B+LFT5
;
	 BYTE	  048H,10000000B+SST2,09BH,00000000B+JPTR	     : 5
;
	 BYTE	  05BH,10000000B+JPTR,0A5H,00000000B+SST1	     : 6
;
	 BYTE	  049H,10000000B+SST2,079H,00000000B+SST2	     : 7
;
	 BYTE	  009H,10000000B+SST2,06BH,00000000B+JPTR	     : 8
	 BYTE	  0C9H,00000000B+SST4
;
	 BYTE	  03BH,10000000B+JPTR				     : 9
;
	 BYTE	  088H,10000000B+BKF0,0B9H,00000000B+SST1	     : A
;
	 BYTE	  019H,10000000B+SST2				     : B
;
	 BYTE	  030H,11000000B+JPTR,078H,00000000B+BKM0	     : C
	 BYTE	  0A6H,00000000B+LFT4
;
	 BYTE	  090H,10000000B+GIAL				     : D
;
	 BYTE	  0FFH
;
;
FXCD05	 EQU	  $	    ;< Castle - 05 >		    / W 6 - 4 /
	 BYTE	  00FH,002H					     : 2
	 BYTE	  009H,00000000B+SST4
;
	 BYTE	  08BH,10000000B+FIEN				     : 3
;
	 BYTE	  02BH,10000000B+JPTR,0E9H,00000000B+SST0	     : 4
;
	 BYTE	  025H,10000000B+SST2				     : 5
;
	 BYTE	  00FH,007H
	 BYTE	  009H,00000000B+SST2,06DH,00000000B+LFT4	     : 7
	 BYTE	  099H,00000000B+SST0,0B5H,00000000B+ELV1
;
	 BYTE	  04BH,10000000B+JPTR				     : 8
;
	 BYTE	  009H,10000000B+SST4,0FBH,00000000B+BKF0	     : 9
;
	 BYTE	  09DH,10000000B+LFT4				     : A
;
	 BYTE	  00FH,00CH					     : C
	 BYTE	  02BH,00000000B+JPTR,078H,00000000B+BKM0
;
	 BYTE	  090H,10000000B+GIAL				     : D
;
	 BYTE	  0FFH
;
;
FXCD06	 EQU	  $	    ;< Castle - 06 >		    / W 7 - 4 /
	 BYTE	  005H,10000000B+SST2				     : 1
;;;;;;;;;BYTE	  065H,00000000B+SST2
;
	 BYTE	  00DH,10000000B+LFT4				     : 2
	 BYTE	  0DDH,00000000B+SST2				     : 2
;
	 BYTE	  007H,10000000B+ELV1,054H,00000000B+ELV1
	 BYTE	  0A2H,00000000B+ELV1
	 BYTE	  0F4H,00000000B+ELV1
;
	 BYTE	  042H,10000000B+ELV1				     : 4
;
	 BYTE	  026H,10000000B+SST2				     : 5
	 BYTE	  0D4H,00000000B+TUTR
;
	 BYTE	  024H,10000000B+TUTR				     : 6
	 BYTE	  064H,00000000B+TUTR
;
	 BYTE	  02BH,10000000B+BKTR,04BH,00000000B+BKTR	     : 7
	 BYTE	  07BH,00000000B+BKTR,09BH,00000000B+BKTR
;
	 BYTE	  05BH,10000000B+BKTR,07BH,00000000B+BKTR	     : 8
;
	 BYTE	  00BH,10000000B+BKTR				     : 9
	 BYTE	  02BH,00000000B+BKTR
	 BYTE	  0C6H,00000000B+SST0
;
	 BYTE	  028H,10000000B+BKTR,048H,00000000B+BKTR	     : A
	 BYTE	  0A6H,00000000B+SST0
;
	 BYTE	  07BH,10000000B+BKF0				     : B
	 BYTE	  085H,00000000B+JPTR
;
	 BYTE	  09DH,10000000B+SST0				     : C
;
	 BYTE	  00FH,00EH					     : E
	 BYTE	  078H,00000000B+BKM0
	 BYTE	  07AH,00000000B+SST2
;
	 BYTE	  090H,10000000B+GIAL				     : F
;
	 BYTE	  0FFH
;
;
FXCD07	 EQU	  $	    ;< Castle - 07 >		    / W 8 - 4 /
	 BYTE	  019H,10000000B+SST0,099H,00000000B+SST0	     : 1
;
	 BYTE	  02CH,10000000B+JPTR,059H,00000000B+SST0	     : 2
	 BYTE	  0C5H,00000000B+FTR6
;
	 BYTE	  00EH,10000011B,11100000B  ;NEXT GOTO Underwater-3  : 3
;
	 BYTE	  00FH,006H
	 BYTE	  02EH,01100111B,11100111B  ;NEXT GOTO Castle-7	     : 6
;
	 BYTE	  00FH,008H
	 BYTE	  09BH,00000000B+IKTR				     : 8
;
	 BYTE	  00EH,10000011B,11100000B  ;NEXT GOTO Underwater-3  : 9
	 BYTE	  039H,00000000B+FTR2,087H,00000000B+FTR7
	 BYTE	  0BDH,00000000B+LFT4
;
	 BYTE	  059H,10000000B+SST4				     : A
;
	 BYTE	  00FH,00FH
	 BYTE	  034H,00000000B+FTR6,077H,00000000B+FTR7	     : F
	 BYTE	  09EH,01100111B,11110001B  ;NEXT GOTO Castle-7
;
	 BYTE	  00FH,012H
	 BYTE	  00EH,01100111B,11100011B  ;NEXT GOTO Castle-7	     :12
	 BYTE	  078H,00000000B+BKM0
;
	 BYTE	  00FH,015H					     :15
	 BYTE	  03BH,00000000B+LFT5
;
	 BYTE	  057H,10000000B+BKTR				     :16
;
	 BYTE	  00FH,018H					     :18
	 BYTE	  055H,00000000B+SST2
	 BYTE	  078H,00000000B+BKM0
;
	 BYTE	  0D0H,10000000B+GIAL				     :18
;
	 BYTE	  0FFH
;
;
;#####################################################################
;#	 Fix chara out pos data	 ( Ground )			     #
;#####################################################################
FXCD21	 EQU	  $	    ;< Ground - 11 >		    / W 5 - 1 /
	 BYTE	  01BH,10000000B+BKTR,04BH,00000000B+BKTR	     : 1
	 BYTE	  07BH,00000000B+BKTR,0ABH,00000000B+BKTR
;
	 BYTE	  00FH,003H
	 BYTE	  0F9H,00000000B+FTR2				     : 3
;
	 BYTE	  0D0H,10000000B+GRP7				     : 4
;
	 BYTE	  08EH,11000100B,10000110B  ;NEXT GOTO Underground-4(Bonus-6): 5
	 BYTE	  0F8H,00000000B+FTR2
;
	 BYTE	  0C0H,10000000B+GRP3				     : 6
;
	 BYTE	  00FH,00DH
	 BYTE	  03AH,00000000B+FTR2,0BBH,00000000B+BKTR	     : D
;
	 BYTE	  030H,10000000B+GRP0				     : E
;
	 BYTE	  080H,10000000B+GRP5				     : F
;
	 BYTE	  0C0H,10000000B+GRP5				     :10
;
	 BYTE	  00FH,012H
	 BYTE	  024H,00000000B+FTR6,054H,00000000B+FTR6	     :12
	 BYTE	  0CEH,00111100B,10000000B  ;NEXT GOTO Ground-28(SKY)
	 BYTE	  0D3H,00000000B+FTR6
;
	 BYTE	  0CBH,10000000B+FTR2,0F9H,00000000B+FTR2	     :13
;
	 BYTE	  0FFH
;
;
FXCD22	 EQU	  $	    ;< Ground - 12 >  (ASURETIC)    / W 5 - 3 /
	 BYTE	  00AH,10000000B+LFT6				     : 1
;
	 BYTE	  015H,10000000B+FTR6,044H,00000000B+FTR6	     : 2
	 BYTE	  04EH,01000100B,10000000B  ;NEXT GOTO Underground-4(Bonus-4)
	 BYTE	  0D8H,00000000B+IKTR
;
	 BYTE	  057H,10000000B+FTR7				     : 3
;
	 BYTE	  00FH,006H					     : 6
	 BYTE	  067H,00000000B+LFT0,08BH,00000000B+TMK0
	 BYTE	  0B9H,00000000B+LFT0
;
	 BYTE	  0ABH,10000000B+TMK0				     : 7
;
	 BYTE	  016H,10000000B+IKTR,02AH,00000000B+LFT4	     : 8
	 BYTE	  084H,00000000B+FTR6
;
	 BYTE	  057H,10000000B+LFT5,0A5H,00000000B+LFT5	     : 9
	 BYTE	  0F5H,00000000B+LFT5
;
	 BYTE	  0A7H,10000000B+LFT0				     : A
;
	 BYTE	  00AH,10000000B+LFT0				     : B
;
	 BYTE	  0FFH
;
;
FXCD23	 EQU	  $	    ;< Ground - 13 >		    / W 6 - 1 /
	 BYTE	  007H,10000000B+BKTR,067H,00000000B+FTR2	     : 1
;
	 BYTE	  040H,10000000B+GRP6,0E0H,00000000B+GRP1	     : 2
;
	 BYTE	  0D0H,10000000B+GRP5				     : 3
;
	 BYTE	  06EH,10000100B,10100000B  ;NEXT GOTO Underwater-4 (Bonus)
	 BYTE	  09BH,00000000B+FIEN				     : 4
;
;
	 BYTE	  00FH,006H
	 BYTE	  0BBH,00000000B+FIEN				     : 6
;
	 BYTE	  00FH,008H
	 BYTE	  00BH,00000000B+FTR2,04BH,00000000B+FTR2	     : 8
;
	 BYTE	  00FH,00AH
	 BYTE	  005H,00000000B+LFT5,085H,00000000B+LFT5	     : A
;
	 BYTE	  00FH,00CH					     : C
	 BYTE	  0DDH,00000000B+LFT4
;
	 BYTE	  0FFH
;
;
FXCD24	 EQU	  $	    ;< Ground - 14 >		    / W 6 - 3 /
	 BYTE	  00FH,002H					     : 2
	 BYTE	  028H,00000000B+FTR7,0E6H,00000000+TUTR
;
	 BYTE	  0D8H,10000000B+FTR7				     : 3
;
	 BYTE	  00FH,005H					     : 5
	 BYTE	  085H,00000000B+FTR6
;
	 BYTE	  078H,10000000B+TUTR,0C8H,00000000B+FTR7	     : 6
;
	 BYTE	  018H,10000000B+TUTR				     : 7
;
	 BYTE	  058H,10000000B+TUTR				     : 8
;
	 BYTE	  0F7H,10000000B+FTR7				     : 9
;
	 BYTE	  00FH,00CH
	 BYTE	  043H,00000000B+FTR6				     : C
;
	 BYTE	  073H,10000000B+FTR6				     : D
;
	 BYTE	  0FFH
;
;
FXCD25	 EQU	  $	    ;< Ground - 15 >		    / W 7 - 1 /
	 BYTE	  0A7H,10000000B+TUTR,0D7H,00000000B+TUTR	     : 1
;
	 BYTE	  00FH,003H
	 BYTE	  06BH,00000000B+SHTR				     : 3
;
	 BYTE	  00FH,006H
	 BYTE	  0E3H,00000000B+FTR6				     : 6
;
	 BYTE	  014H,10000000B+FTR6				     : 7
	 BYTE	  03EH,01000100B,11000011B  ;NEXT GOTO Underground-4 (Bonus-5)
;
	 BYTE	  00BH,10000000B+SHTR				     : 8
	 BYTE	  087H,00000000B+FIEN,0ABH,00000000B+FIEN
;
	 BYTE	  0DBH,10000000B+TUTR				     : 9
;
	 BYTE	  00FH,00BH
	 BYTE	  007H,00000000B+FIEN,013H,00000000B+FTR2	     : B
	 BYTE	  02BH,00000000B+BKTR,04BH,00000000B+BKTR
;
	 BYTE	  00FH,010H
	 BYTE	  00BH,00000000B+FTR2,0B0H,00000000B+GRP0	     :10
;
	 BYTE	  090H,10000000B+GRP5				     :11
;
	 BYTE	  080H,10000000B+GRP5				     :12
	 BYTE	  0AEH,01000100B,11000000B  ;NEXT GOTO Underground-4 (Bonus-4)
;
	 BYTE	  0FFH
;
;
FXCD26	 EQU	  $	    ;< Ground - 16 >		    / W 7 - 2 /
	 BYTE	  00AH,10000000B+LFT6				     : 1
;
	 BYTE	  0D5H,10000000B+FTR6				     : 2
;
	 BYTE	  003H,10000000B+FTR6				     : 3
	 BYTE	  03EH,01000100B,11000110B  ;NEXT GOTO Underground-4 (Bonus-6)
;
	 BYTE	  0D8H,10000000B+TUTR				     : 4
;
	 BYTE	  00FH,006H
	 BYTE	  0A6H,00000000B+ESHP,0B9H,00000000B+FTR2	     : 6
;
	 BYTE	  039H,10000000B+SST2,079H,00000000B+SST0	     : 7
	 BYTE	  0A6H,00000000B+ESHP,0E8H,00000000B+TUTR
;
	 BYTE	  087H,10000000B+TUTR				     : 8
;
	 BYTE	  016H,10000000B+FTR7,0A6H,00000000B+ESHP	     : 9
	 BYTE	  0B9H,00000000B+SST2
;
	 BYTE	  005H,10000000B+FTR6,038H,00000000B+LFT5	     : A
	 BYTE	  089H,00000000B+LFT5
;
	 BYTE	  026H,10000000B+FTR6,046H,00000000B+LFT5	     : B
;
	 BYTE	  0FFH
;
;
FXCD27	 EQU	  $	    ;< Ground - 17 >		    / W 7 - 3 /
;
	 BYTE	  00FH,004H
	 BYTE	  0A3H,00000000B+FTR7				     : 4
;
	 BYTE	  00FH,009H
	 BYTE	  0E3H,00000000B+LFT5				     : 9
;
	 BYTE	  00FH,00DH
	 BYTE	  055H,00000000B+LFT0,0A9H,00000000B+LFT0	     : D
;
	 BYTE	  00FH,011H
	 BYTE	  059H,00000000B+SST2,0A9H,00000000B+SST0	     :11
;
	 BYTE	  023H,10000000B+FTR6				     :12
;
	 BYTE	  015H,10000000B+SST0				     :13
;
	 BYTE	  0FFH
;
;
FXCD28	 EQU	  $	    ;< Ground - 18 >		    / W 8 - 1 /
	 BYTE	  00FH,001H
	 BYTE	  0DBH,00000000B+BKTR				     : 1
;
	 BYTE	  030H,10000000B+GRP0,080H,00000000B+GRP4	     : 2
;
	 BYTE	  01BH,10000000B+FTR2,04AH,00000000B+FTR2	     : 3
	 BYTE	  0EBH,00000000B+TUTR
;
	 BYTE	  03BH,10000000B+BKTR,05BH,00000000B+BKTR	     : 4
	 BYTE	  0E5H,00000000B+FTR6
;
	 BYTE	  014H,10000000B+FTR6,044H,00000000B+FTR6	     : 5
;
	 BYTE	  05BH,10000000B+BKTR				     : 6
;
	 BYTE	  00CH,10000000B+FIEN				     : 7
;
	 BYTE	  035H,10000000B+FTR6				     : 8
;
	 BYTE	  006H,10000000B+FIEN,0E3H,00000000B+FIEN	     : 9
;
	 BYTE	  0DBH,10000000B+TUTR				     : A
;
	 BYTE	  03EH,10000100B,11100000B  ;NEXT GOTO Underground-4 (Bonus-4)
;
	 BYTE	  0FFH
;
;
FXCD31	 EQU	  $	    ;< Ground - 21 >		    / W 8 - 2 /
	 BYTE	  00FH,002H
	 BYTE	  00AH,00000000B+LFT5,0F7H,00000000B+BKTR	     : 2
;
	 BYTE	  080H,10000000B+GRP5				     : 3
;
	 BYTE	  06BH,10000000B+BKTR,07BH,00000000B+BKTR	     : 4
	 BYTE	  09BH,00000000B+BKTR,0ABH,00000000B+BKTR
;
	 BYTE	  039H,10000000B+FTR2				     : 5
;
	 BYTE	  00FH,007H
	 BYTE	  0CEH,00110101B,11101100B  ;NEXT GOTO Ground-21     : 7
	 BYTE	  0F5H,00000000B+FTR6
;
	 BYTE	  0FBH,10000000B+FIEN				     : 8
;
	 BYTE	  0FBH,10000000B+FIEN				     : 9
;
	 BYTE	  03EH,11000100B,11100011B  ;NEXT GOTO Underground-4 (Bonus-5) : A
	 BYTE	  0A7H,00000000B+BKTR
;
	 BYTE	  0FFH
;
;
FXCD32	 EQU	  $	    ;< Ground - 22 >		    / W 8 - 3 /
	 BYTE	  009H,10000000B+LFT5,086H,00000000B+ESHP	     : 1
	 BYTE	  0D5H,00000000B+FTR7
;
	 BYTE	  0A3H,10000000B+FTR6,0D5H,00000000B+LFT5	     : 2
;
	 BYTE	  086H,10000000B+ESHP				     : 3
;
	 BYTE	  02BH,10000000B+TUTR,058H,00000000B+TUTR	     : 4
;
	 BYTE	  05BH,10000000B+FIEN,0EBH,00000000B+FIEN	     : 5
;
	 BYTE	  03EH,10111100B,11100000B  ;NEXT GOTO Ground-28(SKY): 6
;
	 BYTE	  00FH,009H
	 BYTE	  043H,00000000B+FTR6,074H,00000000B+FTR6	     : 9
;
	 BYTE	  06BH,10000000B+FIEN,0DBH,00000000B+FIEN	     : A
;
	 BYTE	  0C6H,10000000B+LFT0				     : B
;
	 BYTE	  019H,10000000B+LFT0				     : C
;
	 BYTE	  012H,10000000B+FTR6				     : D
;
FXCD33	 EQU	  $	    ;< Ground - 23 >		    ;<W8-4>
;
	 BYTE	  0FFH
;
;
FXCD38	 EQU	  $	    ;< Ground - 28 >		    ;<BONUS - SKY>
	 BYTE	  00AH,10000000B+LFT6				     : 1
	 BYTE	  02EH,00101011B,10011000B  ;NEXT GOTO BACK Ground-11(W5-1)
	 BYTE	  02EH,00110110B,11100111B  ;NEXT GOTO BACK Ground-22(W8-3)
;
	 BYTE	  0FFH
;
;
;#####################################################################
;#	 Fix chara out pos data	 ( Underground )		     #
;#####################################################################
FXCD43	 EQU	  $	    ;< Underground - 3 >	    / W 5 - 2 /
	 BYTE	  00BH,10000000B+TUTR,0B7H,00000000B+TUTR	     : 1
	 BYTE	  0D7H,00000000B+TUTR
;
	 BYTE	  00FH,005H
	 BYTE	  067H,00000000B+TUTR,07BH,00000000B+BKTR	     : 5
	 BYTE	  09BH,00000000B+BKTR
;
	 BYTE	  080H,10000000B+GRP2				     : 6
;
	 BYTE	  03BH,10000000B+TUTR				     : 7
;
	 BYTE	  04EH,10110100B,10000000B  ;NEXT GOTO Ground-20     : 8
	 BYTE	  086H,00000000B+ELV0,0C9H,00000000B+ELV1
;
	 BYTE	  016H,10000000B+ELV1				     : 9
;
	 BYTE	  067H,10000000B+NOT1				     : A
	 BYTE	  0DEH,00111011B,10000001B  ;NEXT GOTO BACK Ground-27(Return of Ground)
;
	 BYTE	  0FFH
;
;
FXCD44	 EQU	  $	    ;< Underground - 4 >	    ;<BONUS>
;
; (UNDERGROUND-1) ;0
	 BYTE	  01EH,10101111B,11001010B  ;NEXT GOTO BACK Ground-15(W7-1)
	 BYTE	  01EH,00101100B,10000101B  ;NEXT GOTO BACK Ground-12(W5-3)
;
; (UNDERGROUND-2) ;3
	 BYTE	  00FH,004H
	 BYTE	  01EH,00101101B,10100111B  ;NEXT GOTO BACK Ground-13(W6-1)
	 BYTE	  01EH,00101111B,11001110B  ;NEXT GOTO BACK Ground-15(W7-1)
	 BYTE	  01EH,00110101B,11100101B  ;NEXT GOTO BACK Ground-21(W8-2)
;
; (UNDERGROUND-3) ;6
	 BYTE	  00FH,007H
	 BYTE	  01EH,00101011B,10000111B  ;NEXT GOTO BACK Ground-11(W5-1)
	 BYTE	  01EH,00110000B,11000101B  ;NEXT GOTO BACK Ground-16(W7-2)
;
	 BYTE	  0FFH
;
;
;#####################################################################
;#	 Fix chara out pos data	 ( Underwater )			     #
;#####################################################################
FXCD51	 EQU	  $	    ;< Underwater - 1 >		    / W 6 - 2 /
	 BYTE	  00FH,00000000B+001H				     : 1
;
	 BYTE	  02EH,00111011B,10100001B  ;NEXT GOTO BACK Ground-27(Return of Ground)
;
	 BYTE	  05BH,00000000B+IKTR,0ABH,00000000B+IKTR
;
	 BYTE	  069H,10000000B+IKTR,0BAH,00000000B+IKTR	     : 2
;
	 BYTE	  0FBH,10000000B+IKTR				     : 3
;
	 BYTE	  065H,10000000B+LFT3,06AH,00000000B+LFT3	     : 4
;
	 BYTE	  0A6H,10000000B+LFT3,0ACH,00000000B+LFT3	     : 5
;
	 BYTE	  01BH,10000000B+IKTR,088H,00000000B+IKTR	     : 6
;
	 BYTE	  02BH,10000000B+TUTR				     : 7
	 BYTE	  07BH,00000000B+IKTR
;
	 BYTE	  0A7H,10000000B+FTR7				     : 8
;
	 BYTE	  0E5H,10000000B+TUTR				     : 9
;
	 BYTE	  014H,10000000B+LFT3,019H,00000000B+LFT3	     : A
	 BYTE	  077H,00000000B+IKTR,0F8H,00000000B+IKTR
;
	 BYTE	  047H,10000000B+FTR6				     : B
	 BYTE	  0B9H,00000000B+IKTR				     : B
;
	 BYTE	  0FFH
;
;
FXCD53	 EQU	  $	    ;< Underwater - 3 >		    ;<W8-4>
	 BYTE	  007H,10000000B+SST0,00AH,00000000B+IKTR	     : 1
	 BYTE	  0B9H,00000000B+SST0
;
	 BYTE	  066H,10000000B+SST0,078H,00000000B+IKTR	     : 2
	 BYTE	  0AEH,01100111B,11100101B  ;NEXT GOTO Castle-7
;
	 BYTE	  0FFH
;
;
FXCD54	 EQU	  $	    ;< Underwater - 4 >		    ;<BONUS>
;
	 BYTE	  097H,10000000B+IKTR,0CBH,00000000B+SHTR	     : 1
;
	 BYTE	  0EEH,00101011B,11111000B  ;NEXT GOTO BACK Ground-11(W8-1)
	 BYTE	  0FEH,00101101B,10101101B  ;NEXT GOGT BACK Ground-13(W6-1)
;
	 BYTE	  075H,10000000B+IKTR				     : 2
	 BYTE	  0D3H,00000000B+LFT3,0D9H,00000000B+LFT3
;
	 BYTE	  00FH,004H
	 BYTE	  056H,00000000B+FTR6				     : 4
;
	 BYTE	  0FFH
;
;
;############################################################################################
;#	 Fix obstacle out position data							    #
;############################################################################################
;
;		 +------+------+  +------+------+
;	 FXODxx	 I x xxx xxxxx I  I  xxx  xxxxx I
;	     ^^	 +------+------+  +------+------+
;	     ||	   ^  ^	   ^	      ^	    ^
;	     ||	   |  |	   |	      |	    |
;	     ||	   |  |	   |	      |	    |
;	     ||	   |  |	   |	      |	    |
;	     ||	   |  |	   |	      |	    +---  Floor display max loop
;	     ||	   |  |	   |	      +--------- Player start position data index
;	     ||	   |  |	   |
;	     ||	   |  |	   +------  Base BG environmen
;	     ||	   |  +-----------  Play farst base time
;	     ||	   +--------------  0:ON Floor	      1:OFF Floor
;	     ||
;	     ||	 +------+------+------+------+-----+-----+
;	     ||	 I x x	xxxxxx I xxxx | xxxx I xxxx|xxxx I
;	     ||	 +------+------+------+------+-----+-----+
;	     ||	   ^ ^	   ^	   ^	  ^	 ^    ^
;	     ||	   | |	   |	   |	  |	 |    |
;	     ||	   | |	   |	   |	  |	 |    +----  Obstacle display count
;	     ||	   | |	   |	   |	  |	 +---------  Obstacle kind No.
;	     ||	   | |	   |	   |	  +-  (y)pos-L	     F:BG environment change mode
;	     ||	   | |	   |	   +--------  (x)pos-L
;	     ||	   | |	   |
;	     ||	   | |	   +------  (x)pos-H  ( FF : End crode )
;	     ||	   | +------------  0:Floot length 1:Fix length
;	     ||	   |
;	     ||	   +--------  00:Out  11:No out
;	     ||
;	     |+---  Kind corde
;	     +----  0:Underwater 1:Ground  2:Underground  3:Castle
;
;#####################################################################
;#	 Fix obstacle out pos data  ( Castle )			     #
;#####################################################################
FXOD04	 EQU	  $	    ;< Castle - 04 >		    / W 5 - 4 /
	 BYTE	  10011011B,00001001B
;
	BYTE	00FH,050H+002H,00000000B+OKID				; 0
	BYTE	00FH,060H+003H,00000000B+OKID
;;	   BYTE	    005H,00000000B+OBK1+002H,006H,00000000B+OBK1+003H  : 0
;;	   BYTE	    007H,00000000B+OBK1+003H
	BYTE	00FH,010H+001H,00000000B+OLBK
	BYTE	01FH,010H+001H,00000000B+OLBK
	BYTE	02FH,010H+001H,00000000B+OLBK
	BYTE	03FH,010H+001H,00000000B+OLBK
	 BYTE	  03EH,00000011B
	BYTE	03FH,070H+000H,00000000B+OCTL
	 BYTE	  04CH,00000000B+OWT0+000H
	 BYTE	  04EH,00000111B
;;	   BYTE	    057H,00000000B+OBK1+001H
	BYTE	05FH,070H+000H,00000000B+OCTR
	BYTE	06FH,070H+000H,00000000B+OCTL
	 BYTE	  06EH,00000011B
	 BYTE	  07CH,00000000B+OWT0+002H
	 BYTE	  09EH,00000111B
	BYTE	0AFH,080H+000H,00000000B+OCTR
	 BYTE	  0FEH,00001010B
	BYTE	0FFH,020H+000H,00000000B+ONBK
	BYTE	0FFH,080H+000H,00000000B+OCTL
;
	 BYTE	  07EH,10001001B				     : 1
	BYTE	08FH,070H+000H,00000000B+OCTR
	BYTE	09FH,070H+000H,00000000B+OCTL
	 BYTE	  09EH,00001010B
	 BYTE	  0EEH,00001001B
	BYTE	0FFH,070H+000H,00000000B+OCTR
	 BYTE	  0FEH,00001011B
;
	BYTE	00FH,020H+000H,10000000B+ONBK
	BYTE	01FH,020H+000H,00000000B+ONBK
	 BYTE	  013H,00000000B+OSP0+000H			     : 2
	 BYTE	  01EH,00001001B
	BYTE	03FH,070H+000H,00000000B+OCTL
	 BYTE	  03EH,00001010B
	 BYTE	  06EH,00001001B
	BYTE	07FH,070H+000H,00000000B+OCTR
	 BYTE	  087H,00000000B+OSP0+000H
	BYTE	09FH,0A0H+001H,00000000B+OCLC
	BYTE	09FH,070H+000H,00000000B+OCTL
	 BYTE	  09EH,00000010B
	 BYTE	  0C6H,00000000B+OBBM+000H,0CAH,00000000B+OSP0+000H
	 BYTE	  0F7H,00000000B+OPB1+002H
;
	 BYTE	  007H,10000000B+OSP0+000H,008H,00000000B+OPB1+001H  : 3
	BYTE	01FH,0B0H+000H,00000000B+OCTL
	 BYTE	  017H,00000000B+OPB1+002H
	 BYTE	  01EH,00001010B
	 BYTE	  04EH,00000110B
	 BYTE	  05EH,00001010B
	BYTE	058H,00000000B+OPB1+004H
	 BYTE	  07EH,00000110B
	BYTE	088H,00000000B+OPB1+004H
	 BYTE	  08EH,00001010B
	 BYTE	  0AEH,00000110B
	BYTE	0BFH,080H+000H,00000000B+OCTR
	 BYTE	  0BEH,00000111B
	BYTE	0CFH,020H+000H,00000000B+ONBK
	 BYTE	  0F3H,00000000B+OSP0+000H
;
	 BYTE	  01EH,10000110B				     : 4
	BYTE	01FH,020H+000H,00000000B+ONBK
	BYTE	02FH,080H+000H,00000000B+OCTL
	 BYTE	  02EH,00001010B
	 BYTE	  084H,00000000B+OBK1+007H,093H,00000000B+OBK1+006H
	 BYTE	  0A2H,00000000B+OCO0+005H
;
	 BYTE	  01EH,10001001B				     : 5
	BYTE	02FH,070H+000H,00000000B+OCTR
	 BYTE	  046H,00000000B+OSP0+000H
	 BYTE	  06EH,00001010B
	BYTE	06FH,070H+000H,00000000B+OCTL
	 BYTE	  0A7H,00000000B+OBK1+001H,0DBH,00000000B+OPB1+001H
	 BYTE	  0F7H,00000000B+OPB1+000H
;
	 BYTE	  01BH,10000000B+OPB1+001H,037H,00000000B+OBK1+001H  : 6
	 BYTE	  07EH,00001001B
	 BYTE	  08EH,00001011B
	BYTE	08FH,070H+000H,00000000B+OCTR
	BYTE	09FH,010H+000H,00000000B+ONBK
	BYTE	09FH,030H+000H,00000000B+ONBK
	 BYTE	  0A3H,00000000B+OSP0+000H
	BYTE	0FFH,0A0H+001H,00000000B+OCLC
	BYTE	0FFH,070H+000H,00000000B+OCTL
	 BYTE	  0FEH,00000100B
;
	 BYTE	  017H,10000000B+OBK1+00BH,047H,00000000B+OSP0+000H  : 7
	 BYTE	  077H,00000000B+OSP0+000H
	 BYTE	  0BEH,00000010B
	BYTE	0BFH,020H+000H,00000000B+ONBK
	BYTE	0CFH,0B0H+000H,00000000B+OCTL
	 BYTE	  0CEH,00001010B
;
	 BYTE	  007H,10000000B+OSP0+000H,017H,00000000B+OBK1+001H  : 8
	 BYTE	  063H,00000000B+OBK1+001H,0A7H,00000000B+OBK1+004H
	 BYTE	  0C7H,00000000B+OSP0+000H
;
	 BYTE	  013H,10000000B+OBK1+001H			     : 9
	 BYTE	  04EH,00001001B
	BYTE	05FH,070H+000H,00000000B+OCTR
;
	 BYTE	  01EH,10001010B				     : A
	BYTE	01FH,070H+000H,00000000B+OCTL
	 BYTE	  07EH,00000010B
	BYTE	08FH,0B0H+000H,00000000B+OCTR
	 BYTE	  097H,00000000B+OBK1+004H,0B7H,00000000B+OSP0+000H
	BYTE	0CFH,0B0H+000H,00000000B+OCTL
	 BYTE	  0CEH,00001010B
	 BYTE	  0DEH,00000010B
	 BYTE	  0D8H,00000000B+OPB1+001H
	BYTE	0EFH,0B0H+000H,00000000B+OCTR
	BYTE	0F7H,00000000B+OPB1+002H
	 BYTE	  0FEH,00000011B
;
	BYTE	00FH,020H+000H,10000000B+ONBK
	 BYTE	  007H,00000000B+OBK1+004H,017H,00000000B+OSP0+000H  : B
	 BYTE	  047H,00000000B+OPB1+002H
	BYTE	04FH,0B0H+000H,00000000B+OCTL
	 BYTE	  04EH,00001010B
	 BYTE	  05EH,00000011B
	BYTE	05FH,010H+001H,00000000B+OLBK
	 BYTE	  067H,00000000B+OPB1+002H
	BYTE	06FH,0B0H+000H,00000000B+OCTR
	 BYTE	  077H,00000000B+OBK1+004H,0B7H,00000000B+OPB1+002H
	BYTE	0CFH,010H+001H,00000000B+OLBK
	 BYTE	  0DAH,00000000B+OPB1+000H
	 BYTE	  0E9H,00000000B+OPB1+001H,0F8H,00000000B+OPB1+002H
	BYTE	0FFH,0B0H+000H,00000000B+OCTL
	BYTE	0FFH,020H+000H,00000000B+ONBK
	 BYTE	  0FEH,00001010B
;
	 BYTE	  00DH,10000000B+000H+OSL0,001H,00000000B+OPB0+002H  : C
	 BYTE	  011H,00000000B+OPB0+002H,021H,00000000B+OPB0+002H
	 BYTE	  031H,00000000B+OPB0+002H,041H,00000000B+OPB0+002H
	 BYTE	  051H,00000000B+OPB0+002H,061H,00000000B+OPB0+002H
	 BYTE	  0CDH,00000000B+000H+OCH0
;
	 BYTE	  0CEH,00001001B
	 BYTE	  0DEH,00001011B
	 BYTE	  0DDH,00000000B+000H+OSK0
	BYTE	0DFH,070H+000H,00000000B+OCTR
	BYTE	0EFH,020H+000H,00000000B+ONBK
	BYTE	0FFH,020H+000H,00000000B+ONBK
	BYTE	0FFH,0A0H+001H,00000000B+OCLC
	BYTE	0FFH,070H+000H,00000000B+OCTL
	 BYTE	  0FEH,00000010B
;
	 BYTE	  05DH,10000000B+000H+SCOF			     : D
;
	 BYTE	  0FDH
;
;
FXOD05	 EQU	  $	    ;< Castle - 05 >		    / W 6 - 4 /
	 BYTE	  01011011B,00001001B
;
	BYTE	00FH,050H+002H,00000000B+OKID				; 0
	BYTE	00FH,060H+003H,00000000B+OKID
;;;	    BYTE     005H,00000000B+OBK1+002H,006H,00000000B+OBK1+003H	: 0
	BYTE	04FH,070H+000H,00000000B+OCTL
	 BYTE	  04EH,00001010B
	 BYTE	  087H,00000000B+OBK1+001H
	 BYTE	  0FEH,00000010B
;
	BYTE	00FH,0B0H+000H,10000000B+OCTR
	 BYTE	  088H,00000000B+OCM2+002H,0C7H,00000000B+OBK1+003H  : 1
;
DA003	 EQU	  $
	 BYTE	  00DH,002H					     : 2
;
	 BYTE	  007H,00000000B+000H+OSP0,017H,00000000B+OBK1+004H
	 BYTE	  06EH,00001010B
	BYTE	06FH,0B0H+000H,00000000B+OCTL
	 BYTE	  08EH,00000010B
	BYTE	09FH,0B0H+000H,00000000B+OCTR
	 BYTE	  0BFH,0F0H+007H,00000000B+FCM1,0EDH,00000000B+000H+CSLP
;
	 BYTE	  0B7H,10000000B+OBK1+006H,0C3H,00000000B+OBK1+005H  : 3
;
	 BYTE	  01EH,10001010B				     : 4
	BYTE	01FH,0B0H+000H,00000000B+OCTL
	 BYTE	  02EH,00000010B
	BYTE	03FH,0B0H+000H,00000000B+OCTR
	 BYTE	  033H,00000000B+OBK1+00FH,037H,00000000B+OBK1+00FH
;
	 BYTE	  088H,10000000B+OCM2+002H,0C7H,00000000B+OBK1+003H  : 5
	 BYTE	  0EDH,00000000B+000H+CSLP
;
DA004	 EQU	  $
	 BYTE	  00DH,006H					     : 6
;
	 BYTE	  003H,00000000B+OBK1+003H,00FH,0F0H+004H,00000000B+FCM2
	 BYTE	  047H,00000000B+OCM2+003H,067H,00000000B+OCM2+003H
	BYTE	07FH,0B0H+000H,00000000B+OCTL
	 BYTE	  087H,00000000B+OPB1+005H
	 BYTE	  097H,00000000B+OPB1+005H
	 BYTE	  09EH,00001010B
	 BYTE	  0EDH,00000000B+000H+CSLP,0F7H,00000000B+OBK1+002H
;
	 BYTE	  007H,10000000B+000H+OSP0,097H,00000000B+000H+OSP0  : 7
	 BYTE	  0AEH,00000000B
	 BYTE	  0DEH,00000010B
	BYTE	0EFH,000H+000H,00000000B+ONBK
	BYTE	0EFH,0B0H+000H,00000000B+OCTR
	 BYTE	  0E3H,00000000B+OBK1+005H,0E7H,00000000B+OBK1+005H
;
	 BYTE	  03EH,10001010B				     : 8
	BYTE	03FH,0B0H+000H,00000000B+OCTL
	 BYTE	  04EH,00000010B
	BYTE	05FH,0B0H+000H,00000000B+OCTR
	 BYTE	  053H,00000000B+OBK1+00EH,057H,00000000B+OBK1+00EH
;
	 BYTE	  007H,10000000B+OSP0+000H,0A7H,00000000B+OBK1+004H  : 9
	 BYTE	  0BFH,0F0H+003H,00000000B+FCM1,0EDH,00000000B+000H+CSLP
;
	 BYTE	  02EH,10001010B				     : A
	BYTE	02FH,0B0H+000H,00000000B+OCTL
	 BYTE	  0FEH,00000110B
;
	BYTE	00FH,080H+000H,10000000B+OCTR
	 BYTE	  02EH,00001000B				     : B
	BYTE	03FH,040H+001H,00000000B+OLBK
	BYTE	03FH,010H+000H,00000000B+ONBK
	BYTE	03FH,030H+000H,00000000B+ONBK
	BYTE	03FH,050H+000H,00000000B+ONBK
	BYTE	04FH,040H+001H,00000000B+OLBK
	BYTE	05FH,040H+001H,00000000B+OLBK
	BYTE	06FH,040H+001H,00000000B+OLBK
	BYTE	06FH,010H+000H,00000000B+ONBK
	BYTE	06FH,030H+000H,00000000B+ONBK
	BYTE	06FH,050H+000H,00000000B+ONBK
	 BYTE	  06EH,00000110B
	BYTE	08FH,070H+001H,00000000B+OCRC
	 BYTE	  08EH,00001100B
	BYTE	09FH,040H+000H,00000000B+OCTR
	BYTE	0BFH,070H+001H,00000000B+OCLC
	BYTE	0BFH,040H+000H,00000000B+OCTL
	 BYTE	  0BEH,00000110B
	BYTE	0FFH,080H+000H,00000000B+OCTL
	 BYTE	  0FEH,00001010B
;
	 BYTE	  001H,10000000B+OPB0+002H,00DH,00000000B+OSL0+000H  : C
	 BYTE	  011H,00000000B+OPB0+002H,021H,00000000B+OPB0+002H
	 BYTE	  031H,00000000B+OPB0+002H,041H,00000000B+OPB0+002H
	 BYTE	  042H,00000000B+ORBC+000H,051H,00000000B+OPB0+002H
	 BYTE	  061H,00000000B+OPB0+002H,0CDH,00000000B+OCH0+000H
	 BYTE	  0CEH,00001001B
	 BYTE	  0DDH,00000000B+OSK0+000H
	 BYTE	  0DEH,00001011B
	BYTE	0DFH,070H+000H,00000000B+OCTR
	BYTE	0EFH,020H+000H,00000000B+ONBK
	BYTE	0FFH,020H+000H,00000000B+ONBK
	BYTE	0FFH,0A0H+001H,00000000B+OCLC
	BYTE	0FFH,070H+000H,00000000B+OCTL
	 BYTE	  0FEH,00000010B
;
	 BYTE	  05DH,10000000B+000H+SCOF			     : D
;
	 BYTE	  0FDH
;
;
FXOD06	 EQU	  $	    ;< Castle - 06 >		    / W 7 - 4 /
	 BYTE	  01011000B,00001001B
;
	BYTE	00FH,050H+005H,00000000B+OKID
	BYTE	00FH,060H+00DH,00000000B+OKID
;;	   BYTE	    006H,00000000B+OBK1+00DH			       : 0
;;	   BYTE	    007H,00000000B+OBK1+00DH
	BYTE	00FH,010H+001H,00000000B+OLBK
	BYTE	01FH,010H+001H,00000000B+OLBK
	BYTE	02FH,010H+001H,00000000B+OLBK
	BYTE	03FH,010H+001H,00000000B+OLBK
	BYTE	04FH,010H+001H,00000000B+OLBK
	BYTE	05FH,010H+001H,00000000B+OLBK
	BYTE	06FH,010H+001H,00000000B+OLBK
	BYTE	07FH,010H+001H,00000000B+OLBK
	BYTE	08FH,010H+001H,00000000B+OLBK
	BYTE	09FH,010H+001H,00000000B+OLBK
	BYTE	0AFH,010H+001H,00000000B+OLBK
	BYTE	0BFH,010H+001H,00000000B+OLBK
	BYTE	0BFH,020H+000H,00000000B+ONBK
	 BYTE	  0DEH,00001100B
	BYTE	0EFH,060H+000H,00000000B+OCRC
	BYTE	0EFH,040H+000H,00000000B+OCTR
	 BYTE	  0F3H,00000000B+OBK1+00DH
;
	 BYTE	  003H,10000000B+OSP0+000H			     : 1
;;;;;;;;;BYTE;;;;;063H,00000000B+OSP0+000H;;;;;;;;;;;;;;;;
	 BYTE	  06EH,01000011B
	 BYTE	  0CEH,00001010B
	BYTE	0CFH,040H+000H,00000000B+OCTL
	BYTE	0EFH,010H+007H,00000000B+OLBK
	BYTE	0EFH,020H+000H,00000000B+ONBK
	BYTE	0EFH,080H+000H,00000000B+ONBK
	BYTE	0FFH,010H+007H,00000000B+OLBK
;
	BYTE	00FH,010H+007H,10000000B+OLBK			     ; 2
	BYTE	01FH,010H+007H,00000000B+OLBK
	 BYTE	  01EH,00000101B
	BYTE	02FH,080H+000H,00000000B+OLBK
	BYTE	02FH,0B0H+000H,00000000B+OCTR
	BYTE	03FH,080H+000H,00000000B+OLBK
	BYTE	04FH,080H+000H,00000000B+OLBK
	BYTE	05FH,080H+000H,00000000B+OLBK
	BYTE	06FH,080H+000H,00000000B+OLBK
	 BYTE	  06EH,01000000B
	BYTE	07FH,080H+000H,00000000B+OLBK
	BYTE	08FH,080H+000H,00000000B+OLBK
	BYTE	09FH,080H+000H,00000000B+OLBK
	BYTE	0AFH,080H+000H,00000000B+OLBK
	 BYTE	  0BEH,00000001B
	BYTE	0BFH,000H+000H,00000000B+ONBK
	BYTE	0BFH,080H+000H,00000000B+ONBK
;
	 BYTE	  0C7H,00000000B+OSBM+000H
	 BYTE	  0DBH,00000000B+OSP0+000H
	 BYTE	  0DEH,00000000B
;
	 BYTE	  01FH,0F0H+000H,10000000B+OEW0,06FH,0F0H+000H,00000000B+OEW0  : 3
	 BYTE	  0BFH,0F0H+000H,00000000B+OEW0
;
	 BYTE	  00FH,0F0H+000H,10000000B+OEW0,05FH,0F0H+000H,00000000B+OEW0  : 4
	 BYTE	  07EH,00000101B
	BYTE	08FH,000H+000H,00000000B+ONBK
	BYTE	08FH,0B0H+000H,00000000B+OCTR
	 BYTE	  0A8H,00000000B+OBK1+007H
	BYTE	0AFH,080H+000H,00000000B+ONBK
	BYTE	0BFH,080H+000H,00000000B+OLBK
	BYTE	0CFH,080H+000H,00000000B+OLBK
	BYTE	0DFH,080H+000H,00000000B+OLBK
	BYTE	0EFH,080H+000H,00000000B+OLBK
	BYTE	0FFH,020H+000H,00000000B+ONBK
	BYTE	0FFH,080H+000H,00000000B+OLBK
	 BYTE	  0FEH,00000010B
;
	BYTE	00FH,080H+000H,10000000B+OLBK
	BYTE	01FH,080H+000H,00000000B+ONBK
	 BYTE	  024H,00000000B+OSP0+000H,034H,00000000B+OBK1+000H  : 5
	 BYTE	  03EH,00001100B
	BYTE	03FH,0A0H+001H,00000000B+OCRC
	BYTE	04FH,040H+000H,00000000B+OCTR
	 BYTE	  04EH,01000011B
	 BYTE	  0AEH,00001010B
	BYTE	0AFH,040H+000H,00000000B+OCTL
	 BYTE	  0BEH,00001100B
	BYTE	0CFH,040H+000H,00000000B+OCTR
	 BYTE	  0EEH,00001010B
	BYTE	0EFH,040H+000H,00000000B+OCTL
	 BYTE	  0FEH,00001100B
;
	BYTE	00FH,040H+000H,10000000B+OCTR
	 BYTE	  02EH,00001010B				     : 6
	BYTE	02FH,040H+000H,00000000B+OCTL
	 BYTE	  03EH,00001100B
	BYTE	04FH,040H+000H,00000000B+OCTR
	 BYTE	  07EH,00000010B
	BYTE	07FH,0A0H+001H,00000000B+OCLC
	BYTE	07FH,040H+000H,00000000B+OCTL
	 BYTE	  08EH,00001110B
	 BYTE	  094H,00000000B+OPB1+004H
	 BYTE	  0A4H,00000000B+OPB1+004H
	 BYTE	  0B4H,00000000B+OPB1+005H
	 BYTE	  0C4H,00000000B+OPB1+005H
	 BYTE	  0D4H,00000000B+OPB1+005H
	 BYTE	  0E4H,00000000B+OPB1+005H
	 BYTE	  0F4H,00000000B+OPB1+005H
;
	 BYTE	  004H,10000000B+OPB1+005H			     ; 7
	 BYTE	  014H,00000000B+OPB1+005H
	 BYTE	  024H,00000000B+OPB1+005H
	 BYTE	  034H,00000000B+OPB1+005H
	 BYTE	  044H,00000000B+OPB1+005H
	 BYTE	  054H,00000000B+OPB1+005H
	 BYTE	  064H,00000000B+OPB1+005H
	 BYTE	  074H,00000000B+OPB1+005H
	 BYTE	  084H,00000000B+OPB1+005H
	 BYTE	  094H,00000000B+OPB1+005H
	 BYTE	  0A4H,00000000B+OPB1+005H
	 BYTE	  0B4H,00000000B+OPB1+005H
	 BYTE	  0C4H,00000000B+OPB1+005H
	 BYTE	  0D4H,00000000B+OPB1+005H
	 BYTE	  0E4H,00000000B+OPB1+005H
	 BYTE	  0F4H,00000000B+OPB1+005H
;
	 BYTE	  00EH,10000010B				     : 8
	 BYTE	  004H,00000000B+OPB1+003H
;
	 BYTE	  02EH,10000110B				     : 9
	BYTE	02FH,0A0H+001H,00000000B+OCRC
	BYTE	03FH,080H+000H,00000000B+OCTR
	 BYTE	  04EH,00001100B
	BYTE	04FH,070H+001H,00000000B+OCRC
	BYTE	05FH,040H+000H,00000000B+OCTR
	 BYTE	  09EH,00001001B
	BYTE	09FH,060H+001H,00000000B+OCLC
	BYTE	09FH,040H+000H,00000000B+OCTL
	 BYTE	  0C1H,00000000B+OPB1+002H,0C4H,00000000B+OSP0+000H
	 BYTE	  0EEH,00001100B
	BYTE	0EFH,060H+001H,00000000B+OCRC
	BYTE	0FFH,040H+000H,00000000B+OCTR
;
	 BYTE	  00EH,10000110B				     : A
	BYTE	00FH,070H+001H,00000000B+OCLC
	BYTE	00FH,040H+000H,00000000B+OCTL
	 BYTE	  05EH,00001100B
	BYTE	05FH,070H+001H,00000000B+OCRC
	BYTE	06FH,040H+000H,00000000B+OCTR
	 BYTE	  07EH,00001001B
	BYTE	07FH,060H+001H,00000000B+OCLC
	BYTE	07FH,040H+000H,00000000B+OCTL
	 BYTE	  0A1H,00000000B+OPB1+002H,0A4H,00000000B+OSP0+000H
	BYTE	0CFH,060H+001H,00000000B+OCRC
	BYTE	0DFH,040H+000H,00000000B+OCTR
	 BYTE	  0DEH,00001100B
	 BYTE	  0FEH,00001010B
	BYTE	0FFH,040H+000H,00000000B+OCTL
;
	 BYTE	  028H,10000000B+OBK1+004H,0A6H,00000000B+OBK1+001H  : B
	 BYTE	  0E8H,00000000B+OBK1+004H
;
	 BYTE	  08BH,10000000B+OBK1+002H			     : C
	 BYTE	  09BH,00000000B+OSP0+000H
	 BYTE	  0FEH,00000111B
;
;**********
;
	BYTE	00FH,020H+000H,10000000B+ONBK			     ; D
	BYTE	00FH,080H+000H,00000000B+OCTR
	BYTE	0FFH,020H+000H,00000000B+ONBK
	BYTE	0FFH,080H+000H,00000000B+OCTL
	 BYTE	  0FEH,00001010B
;
	 BYTE	  00DH,10000000B+OSL0+000H			     : E
;;;;;;;	 BYTE	  001H,00000000B+OBK0+001H
;;;;;;	 BYTE	  012H,00000000B+OBK0+004H
;;;;;;	 BYTE	  023H,00000000B+OBK0+006H
;;;;;;;	 BYTE	  077H,00000000B+OSP0+000H
	 BYTE	  0CDH,00000000B+OCH0+000H
	 BYTE	  0CEH,00001001B
	 BYTE	  0DDH,00000000B+OSK0+000H
	 BYTE	  0DEH,00001011B
	BYTE	0DFH,070H+000H,00000000B+OCTR
	BYTE	0EFH,020H+000H,00000000B+ONBK
	BYTE	0FFH,020H+000H,00000000B+ONBK
	BYTE	0FFH,0A0H+001H,00000000B+OCLC
	BYTE	0FFH,070H+000H,00000000B+OCTL
	 BYTE	  0FEH,00000010B
;
	 BYTE	  05DH,10000000B+000H+SCOF			     : F
;
	 BYTE	  0FDH
;
;
FXOD07	 EQU	  $	    ;< Castle - 07 >		    / W 8 - 4 /
	 BYTE	  01011011B,00000011B
;
	 BYTE	  005H,00000000B+OBK1+004H,006H,00000000B+OBK1+005H  : 0
	 BYTE	  007H,00000000B+OBK1+006H
	 BYTE	  06EH,00001010B
	BYTE	06FH,010H+000H,00000000B+ONBK
	BYTE	06FH,0B0H+000H,00000000B+OCTL
	 BYTE	  0EEH,00000010B
	BYTE	0FFH,0B0H+000H,00000000B+OCTR
;
	 BYTE	  0FEH,00000101B
	BYTE	00FH,020H+000H,10000000B+ONBK
DA007	 EQU	  $
;;K;;	      BYTE     0FEH,00000101B
	 BYTE	  00EH,00000101B
;
;	    (point)
	 BYTE	  00DH,001H					     : 1
;;K:;	     BYTE    00FH,020H+000H,00000000B+ONBK
	 BYTE	  017H,00000000B+OSP0+000H,097H,00000000B+OSP0+000H
	BYTE	09FH,020H+000H,00000000B+ONBK
	 BYTE	  09EH,00000010B
	 BYTE	  0C6H,00000000B+OSDM+000H,0FAH,00000000B+OBK1+000H
	 BYTE	  0FEH,00001010B
	BYTE	0FFH,0B0H+000H,00000000B+OCTL
;
	 BYTE	  04EH,10000010B				     : 2
	BYTE	05FH,0B0H+000H,00000000B+OCTR
	 BYTE	  057H,00000000B+OSP0+000H,058H,00000000B+OPB1+002H
	 BYTE	  068H,00000000B+OPB1+002H,079H,00000000B+OPB1+001H
	 BYTE	  08AH,00000000B+OPB1+000H
	 BYTE	  08EH,00001010B
	BYTE	08FH,0B0H+000H,00000000B+OCTL
	 BYTE	  0F5H,00000000B+OBK1+001H,0F9H,00000000B+OCM0+003H
;
	 BYTE	  039H,10000000B+OCM2+003H,097H,00000000B+OBK1+003H  : 3
	 BYTE	  0B5H,00000000B+OCM2+001H
;
	 BYTE	  039H,10000000B+OCM2+003H			     : 4
	 BYTE	  04DH,00000000B+JFST+000H
	 BYTE	  09EH,00000010B
	 BYTE	  0AEH,00000101B
	BYTE	0AFH,0B0H+000H,00000000B+OCTR
	BYTE	0BFH,010H+000H,00000000B+ONBK
	 BYTE	  0CDH,00000000B+EXOF+000H
	 BYTE	  0EDH,00000000B+000H+CSLP
	BYTE	0FFH,020H+004H,00000000B+OLBK
;
;	    (point)
	 BYTE	  00EH,10000001B				     : 5
	BYTE	00FH,010H+000H,00000000B+ONBK
	 BYTE	  017H,00000000B+OSBM+000H
	BYTE	02FH,0B0H+000H,00000000B+OCTL
	 BYTE	  039H,00000000B+OCM2+003H,05CH,00000000B+OHL0+002H
	 BYTE	  085H,00000000B+OPB1+005H
	BYTE	08FH,0B0H+000H,00000000B+OCTR
	BYTE	09FH,0B0H+000H,00000000B+OCTL
	 BYTE	  095H,00000000B+OBK1+002H
	 BYTE	  0A9H,00000000B+OCM0+003H,0CCH,00000000B+OHL0+003H
;
	 BYTE	  05EH,10001111B				     : 6
	 BYTE	  06DH,00000000B+000H+SCOF
;
DA008	 EQU	  $
	 BYTE	  0FEH,00000010B
;
;	    (point)
	 BYTE	  00DH,007H					     : 7
;
	BYTE	02FH,0B0H+000H,00000000B+OCTL
	 BYTE	  039H,00000000B+OCM2+003H
	 BYTE	  04EH,00001010B
	 BYTE	  0AEH,00000010B
	BYTE	0BFH,0B0H+000H,00000000B+OCTR
	 BYTE	  0ECH,00000000B+OBC2+001H
;
	 BYTE	  007H,10000000B+ODMS+000H,017H,00000000B+OBCO+000H  : 8
	BYTE	02FH,0B0H+000H,00000000B+OCTL
	 BYTE	  039H,00000000B+OCM2+003H
	BYTE	05FH,0B0H+000H,00000000B+OCTR
	BYTE	0E6H,00000000B+OSDM+000H
;
	BYTE	02FH,0B0H+000H,10000000B+OCTL
	 BYTE	  039H,00000000B+OCM0+003H			     : 9
	 BYTE	  04EH,00001010B
	 BYTE	  0C4H,00000000B+OBK1+001H,0EBH,00000000B+OPB1+001H
	 BYTE	  0FEH,00000010B
;
	 BYTE	  007H,10000000B+OBK1+000H			     : A
	BYTE	00FH,0B0H+000H,00000000B+OCTR
	BYTE	01FH,0B0H+000H,00000000B+OCTL
	 BYTE	  01EH,00001010B
	 BYTE	  04EH,00000110B
	BYTE	05FH,080H+000H,00000000B+OCTR
	 BYTE	  057H,00000000B+OSP0+000H
	 BYTE	  0BEH,00000010B
	BYTE	0BFH,0A0H+001H,00000000B+OCLC
	BYTE	0BFH,080H+000H,00000000B+OCTL
	 BYTE	  0C9H,00000000B+OPB1+001H,0DAH,00000000B+OPB1+000H
	 BYTE	  0EDH,00000000B+000H+CSLP
;
	 BYTE	  00EH,10000101B				     : B
	BYTE	01FH,010H+000H,00000000B+ONBK
;
	 BYTE	  00DH,00EH
	BYTE	0FFH,020H+000H,00000000B+ONBK
	BYTE	0FFH,0B0H+000H,00000000B+OCTL
	 BYTE	  0FEH,00001010B				     : E
;
	 BYTE	  078H,10000000B+OPB1+004H			     : F
	 BYTE	  08EH,00000110B
	BYTE	09FH,080H+000H,00000000B+OCTR
	 BYTE	  0B3H,00000000B+OSBM+000H,0BFH,0F0H+007H,00000000B+OCM1
	 BYTE	  0EEH,00001111B
	BYTE	0EFH,080H+000H,00000000B+OCTL
	BYTE	0FFH,010H+000H,00000000B+ONBK
;
	 BYTE	  06DH,10000000B+000H+SCOF			     :10
;
;	    (point)
	 BYTE	  00EH,10000010B				     :11
	BYTE	00FH,010H+000H,00000000B+ONBK
	BYTE	01FH,0B0H+000H,00000000B+OCTR
	BYTE	02FH,0B0H+000H,00000000B+OCTL
	 BYTE	  039H,00000000B+OCM2+003H
	BYTE	05FH,0B0H+000H,00000000B+OCTR
	BYTE	09AH,00000000B+OPB1+000H
	BYTE	0AFH,0A0H+001H,00000000B+OCRC
	 BYTE	  0A9H,00000000B+OPB1+001H
	 BYTE	  0AEH,00000110B
	BYTE	0BFH,080H+000H,00000000B+OCTR
	BYTE	0DFH,080H+000H,00000000B+OCTL
	 BYTE	  0DEH,00001010B
	 BYTE	  0E7H,00000000B+OSCO+000H,0EBH,00000000B+OCM0+001H
	 BYTE	  0F7H,00000000B+OSCO+000H
	 BYTE	  0FEH,00000110B
;
	BYTE	00FH,080H+000H,10000000B+OCTR
;
	 BYTE	  00DH,014H					     :14
	BYTE	0FFH,080H+000H,00000000B+OCTL
	 BYTE	  0FEH,00001010B
;
	 BYTE	  05EH,10000010B				     :15
	BYTE	06FH,0B0H+000H,00000000B+OCTR
	 BYTE	  07FH,0F0H+006H,00000000B+FCM1
	 BYTE	  09EH,00001010B
	BYTE	09FH,0B0H+000H,00000000B+OCTL
	 BYTE	  0F8H,00000000B+OPB1+004H
	 BYTE	  0FEH,00001011B
;
	BYTE	00FH,020H+000H,10000000B+ONBK
	BYTE	00FH,070H+000H,00000000B+OCTR
	BYTE	09FH,0A0H+001H,00000000B+OCLC
	BYTE	09FH,070H+000H,00000000B+OCTL
	 BYTE	  09EH,00000100B				     :16
	 BYTE	  0BEH,00000101B
	BYTE	0CFH,040H+000H,00000000B+ONBK
;
	 BYTE	  0BEH,10000010B				     :17
	BYTE	0BFH,020H+000H,00000000B+ONBK
	 BYTE	  0DAH,00000000B+OPB1+000H,0E9H,00000000B+OPB1+001H
	 BYTE	  0F8H,00000000B+OPB1+002H
	BYTE	0FFH,0B0H+000H,00000000B+OCTL
	 BYTE	  0FEH,00001010B
;
	 BYTE	  00DH,10000000B+OSL0+000H			     :18
	 BYTE	  011H,00000000B+OPB1+004H,051H,00000000B+OPB1+002H
	 BYTE	  0CDH,00000000B+OCH0+000H
	 BYTE	  0CEH,00001001B
	 BYTE	  0DDH,00000000B+OSK0+000H
	 BYTE	  0DEH,00001011B
	BYTE	0DFH,070H+000H,00000000B+OCTR
	BYTE	0EFH,020H+000H,00000000B+ONBK
	BYTE	0FFH,020H+000H,00000000B+ONBK
;;K;;	     BYTE    0FFH,0A0H+001H,00000000B+OCLC
;;K;;	     BYTE    0FFH,070H+000H,00000000B+OCTL
	 BYTE	  0FEH,00000010B
;
	 BYTE	  05DH,10000000B+000H+SCOF			     :19
;
	 BYTE	  0FDH
;
;
;#####################################################################
;#	 Fix obstacle out pos data  ( Ground )			     #
;#####################################################################
FXOD21	 EQU	  $	    ;< Ground - 11 >		    / W 5 - 1 /
	 BYTE	  01010010B,10110001B
;
	 BYTE	  00FH,0F0H+000H,00000000B+OCS0				  : 0
	 BYTE	  06EH,01110101B
	 BYTE	  0CCH,00000000B+OBC2+003H
;
	 BYTE	  0A3H,10000000B+OBK1+003H,0BFH,0F0H+004H,00000000B+FCM2  : 1
;
	 BYTE	  00CH,10000000B+OHL0+004H,083H,00000000B+OBK1+00FH  : 2
	BYTE	08EH,00000001B
	 BYTE	  09FH,0F0H+004H,00000000B+FCM2
	BYTE	0AEH,00110001B
	BYTE	0EFH,0F0H+001H,00000000B+FCM2
	 BYTE	  0ECH,00000000B+OHL0+001H
;
	 BYTE	  02FH,0F0H+001H,10000000B+FCM2,02CH,00000000B+OHL0+001H  : 3
	 BYTE	  06FH,0F0H+001H,00000000B+FCM2,06CH,00000000B+OHL0+001H
;
	 BYTE	  0A8H,10000000B+OGN0+001H,0AAH,00000000B+OGN0+000H  : 4
;
	 BYTE	  077H,10000000B+OCM0+003H			     : 5
;
	 BYTE	  056H,10000000B+OCM2+004H			     : 6
;
	 BYTE	  039H,10000000B+OCM2+001H,0BFH,0F0H+007H,00000000B+OST0  : 7
;
	 BYTE	  033H,10000000B+OPB1+007H,043H,00000000B+OSMS+000H  : 8
	 BYTE	  047H,00000000B+OSCO+000H,06CH,00000000B+OHL0+005H
	 BYTE	  0C3H,00000000B+OPB1+007H,0D3H,00000000B+OPB1+007H
	 BYTE	  0E3H,00000000B+OPB1+007H,0EDH,00000000B+KZST+000H
	 BYTE	  0FCH,00000000B+OHL0+007H
;
	 BYTE	  073H,10000000B+OPB1+007H,083H,00000000B+OPB1+007H  : 9
	 BYTE	  093H,00000000B+OPB1+007H,0A3H,00000000B+OPB1+007H
	 BYTE	  0BCH,00000000B+OHL0+008H
;
	 BYTE	  043H,10000000B+OPB1+007H,053H,00000000B+OPB1+007H  : A
	 BYTE	  0DCH,00000000B+OHL0+002H
;
;	    (point)
	 BYTE	  059H,10000000B+OGN0+001H,0C3H,00000000B+OBK1+003H  : B
	 BYTE	  0D9H,00000000B+OCM2+001H,0DFH,0F0H+002H,00000000B+FCM2
;
	 BYTE	  02DH,10000000B+000H+KZOF			     : C
	 BYTE	  05BH,00000000B+OCM2+001H,09BH,00000000B+OCM2+001H
;
	 BYTE	  03BH,10000000B+OCM2+001H			     : D
;
	 BYTE	  0A7H,10000000B+OCO0+002H,0DBH,00000000B+OCM2+001H  : E
;
	 BYTE	  00DH,010H
	 BYTE	  09BH,00000000B+OCM2+001H			     :10
;
	 BYTE	  00AH,10000000B+OBK1+000H,01CH,00000000B+OHL0+004H  :11
	 BYTE	  067H,00000000B+OPB1+003H,076H,00000000B+OPB1+004H
	 BYTE	  085H,00000000B+OPB1+005H,094H,00000000B+OPB1+006H
	 BYTE	  0A3H,00000000B+OPB1+007H,0B3H,00000000B+OPB1+007H
	 BYTE	  0CCH,00000000B+OHL0+009H
;
	 BYTE	  073H,10000000B+OBK0+003H,087H,00000000B+OBK0+002H  :12
	 BYTE	  0B3H,00000000B+OBBW+000H
;
	 BYTE	  0D6H,10000000B+OSCO+000H,0E3H,00000000B+OSCO+000H  :13
;
	BYTE	000H,10000000B+OPB1+00AH,010H,00000000B+OPB1+00AH
	BYTE	020H,00000000B+OPB1+00AH,030H,00000000B+OPB1+00AH
	BYTE	040H,00000000B+OPB1+00AH,050H,00000000B+OPB1+00AH
	BYTE	060H,00000000B+OPB1+00AH,070H,00000000B+OPB1+00AH
	BYTE	080H,00000000B+OPB1+00AH,090H,00000000B+OPB1+00AH
	BYTE	0A0H,00000000B+OPB1+00AH,0B0H,00000000B+OPB1+00AH
	BYTE	0C0H,00000000B+OPB1+00AH,0D0H,00000000B+OPB1+00AH
	BYTE	0E0H,00000000B+OPB1+00AH,0F0H,00000000B+OPB1+00AH
;
	BYTE	000H,10000000B+OPB1+00AH,010H,00000000B+OPB1+00AH
	BYTE	020H,00000000B+OPB1+00AH,030H,00000000B+OPB1+00AH
	BYTE	040H,00000000B+OPB1+00AH,050H,00000000B+OPB1+00AH
	BYTE	060H,00000000B+OPB1+00AH,070H,00000000B+OPB1+00AH
	BYTE	080H,00000000B+OPB1+00AH,090H,00000000B+OPB1+00AH
	BYTE	0A0H,00000000B+OPB1+00AH,0B0H,00000000B+OPB1+00AH
	BYTE	0C0H,00000000B+OPB1+00AH,0D0H,00000000B+OPB1+00AH
;
;;;;;	      BYTE     0FEH,00111111B
;
;;;	    BYTE     00DH,015H
;;;	    BYTE     0DEH,00110001B					:15
	 BYTE	  0ECH,00000000B+OHL0+001H
;
	 BYTE	  003H,10000000B+OCM2+007H			     :16
	 BYTE	  09DH,00000000B+000H+OPL0,0DFH,0F0H+006H,00000000B+OCS0
;
	 BYTE	  00DH,018H
	 BYTE	  039H,00000000B+OCM2+001H,07FH,0F0H+007H,00000000B+OST0  :18
	 BYTE	  0F2H,00000000B+OPB1+008H
;
	 BYTE	  001H,10000000B+OPB1+009H			     :19
	 BYTE	  011H,00000000B+OBK1+009H,068H,00000000B+OCM0+002H
;;;	    BYTE     0DEH,00111111B
	BYTE	0E0H,00000000B+OPB1+00AH,0F0H,00000000B+OPB1+00AH
;
	BYTE	000H,10000000B+OPB1+00AH
	 BYTE	  06DH,00000000B+000H+SLON			     ;1A
;
;
	 BYTE	  0FDH
;
;
FXOD22	 EQU	  $	    ;< Ground - 12 >		    / W 5 - 3 /
	 BYTE	  01010000B,00010001B
;
	 BYTE	  00FH,0F0H+006H,00000000B+OCS0				  : 0
	 BYTE	  0DFH,0F0H+002H,00000000B+OST0
DA010	 EQU	  $
	 BYTE	  0FEH,00010000B
;
	 BYTE	  00DH,001H					     : 1
	 BYTE	  098H,00000000B+OCM2+004H,0C8H,00000000B+OLD0+003H
;
	 BYTE	  052H,10000000B+OPB1+001H			     : 2
	 BYTE	  063H,00000000B+OBK1+001H,061H,00000000B+OCM0+001H
	 BYTE	  0C6H,00000000B+OPB1+001H
;
	 BYTE	  006H,10000000B+OPB1+001H,08BH,00000000B+OCM2+001H  : 3
	 BYTE	  0ABH,00000000B+OCM2+001H,0E4H,00000000B+OLD0+009H
	 BYTE	  0EBH,00000000B+OLD0+009H
;
	 BYTE	  060H,10000000B+000H+OSBM,0C8H,00000000B+OLD0+003H  : 4
	 BYTE	  0CDH,00000000B+CSLP+000H
;
	 BYTE	  039H,10000000B+OCM2+003H,098H,00000000B+OLD0+003H  : 5
;
;	    (point)
	 BYTE	  017H,10000000B+OCM2+005H,07CH,00000000B+OEP0+005H  : 6
	 BYTE	  07FH,0F0H+003H,00000000B+OLW0
	 BYTE	  0CFH,0F0H+005H,00000000B+OLW0,0D4H,00000000B+OCO0+000H
;
;	    (re-start)
	 BYTE	  00BH,10000000B+OLD0+00AH,023H,00000000B+OLD0+006H  : 7
	 BYTE	  032H,00000000B+OCO0+004H
;
	 BYTE	  0A3H,10000000B+OLD0+005H,0B2H,00000000B+OCO0+003H  : 8
;
	 BYTE	  00DH,00AH					     : A
	 BYTE	  027H,00000000B+OLD0+004H,03DH,00000000B+000H+EXOF
	 BYTE	  0A4H,00000000B+OCO0+000H
	 BYTE	  0BCH,00000000B+OEP0+006H,0BFH,0F0H+003H,00000000B+OLW0
	 BYTE	  0C4H,00000000B+OCO0+000H
;
	 BYTE	  004H,10000000B+OCO0+000H,01FH,0F0H+006H,00000000B+OLW0  : B
	 BYTE	  024H,00000000B+OCO0+000H,043H,00000000B+OBK1+001H
	 BYTE	  0CEH,00010001B
	 BYTE	  0DDH,00000000B+000H+OPL0
;
;;;	    BYTE     00EH,11010010B					: C
	 BYTE	  0FFH,0F0H+000H,00000000B+OCS0
;
	 BYTE	  0EDH,10000000B+000H+SCOF			     : D
;
	 BYTE	  0FDH
;
;
FXOD23	 EQU	  $	    ;< Ground - 13 >		    / W 6 - 1 /
	 BYTE	  01010010B,10100001B
;
	 BYTE	  00FH,0F0H+000H,00000000B+OCS0				  : 0
	 BYTE	  06EH,01000000B
	 BYTE	  0D6H,00000000B+OPB1+001H,0E7H,00000000B+OBBM+000H
	 BYTE	  0F7H,00000000B+OBK0+001H
;
	 BYTE	  016H,10000000B+OPB1+001H,034H,00000000B+OPB1+003H  : 1
	 BYTE	  047H,00000000B+OBK0+001H,054H,00000000B+OSMS+000H
	 BYTE	  067H,00000000B+OBBS+000H
	 BYTE	  074H,00000000B+OPB1+003H
	 BYTE	  0DCH,00000000B+OHL0+001H
;
	 BYTE	  006H,10000000B+OPB1+001H,017H,00000000B+OBK0+006H  : 2
	 BYTE	  086H,00000000B+OPB1+001H
;
	 BYTE	  066H,10000000B+OCO0+002H			     : 3
;
	 BYTE	  058H,10000000B+OCO0+001H			     : 4
	 BYTE	  0F7H,00000000B+OSCO+000H
;
	 BYTE	  004H,10000000B+OCM2+006H,08AH,00000000B+OGN0+000H  : 5
	 BYTE	  09CH,00000000B+OHL0+004H
	 BYTE	  0E8H,00000000B+OPB1+002H,0F9H,00000000B+OPB1+001H
;
;
	 BYTE	  00AH,10000000B+OPB1+000H,053H,00000000B+OBK1+001H  : 6
	 BYTE	  05FH,0F0H+003H,00000000B+FCM2
	 BYTE	  07BH,00000000B+OCM2+001H,077H,00000000B+OBK0+005H
;
	 BYTE	  0FCH,10000000B+OBC1+002H			     : 7
;
	 BYTE	  017H,10000000B+OBK0+00AH			     : 8
	 BYTE	  023H,00000000B+OBMS+000H,03CH,00000000B+OBC1+007H
	 BYTE	  0B3H,00000000B+ODMS+000H,0CCH,00000000B+OBC1+003H
	 BYTE	  0DBH,00000000B+OCM2+001H,0DFH,0F0H+003H,00000000B+FCM2
	 BYTE	  0FCH,00000000B+OHL0+000H
;
	 BYTE	  04FH,0F0H+007H,10000000B+OST0				  : 9
	 BYTE	  0CAH,00000000B+OCM0+002H
	 BYTE	  0C5H,00000000B+OBK1+001H
	 BYTE	  0ECH,00000000B+OWT0+004H
;
	 BYTE	  03CH,10000000B+OWT0+00CH			     : A
	 BYTE	  05DH,00000000B+KZST+000H
;
	 BYTE	  00FH,0F0H+003H,10000000B+OST0,047H,00000000B+OPB1+003H  : B
;
	 BYTE	  06BH,10000000B+OCM2+001H,08CH,00000000B+OHL0+00AH  : C
;
	 BYTE	  039H,10000000B+OCM2+001H			     : D
	 BYTE	  0ECH,00000000B+OHL0+003H
	 BYTE	  0F0H,00000000B+OBK1+003H
;
	 BYTE	  00FH,0F0H+002H,10000000B+FCM1
	 BYTE	  029H,00000000B+OCM2+003H			     : E
	 BYTE	  049H,00000000B+OPB1+001H,058H,00000000B+OPB1+002H
	 BYTE	  067H,00000000B+OCM2+003H,085H,00000000B+OPB1+005H
	 BYTE	  094H,00000000B+OPB1+006H
	 BYTE	  0A3H,00000000B+OCM2+007H
	 BYTE	  0ADH,00000000B+KZOF+000H
	BYTE	0AEH,00000001B
;
	 BYTE	  04DH,10000000B+000H+OPL0			     : F
	 BYTE	  08FH,0F0H+006H,00000000B+OCS0
;
	 BYTE	  07DH,10000000B+SCOF+000H			     : 10
;
	 BYTE	  0FDH
;
;
FXOD24	 EQU	  $	    ;< Ground - 14 >		    / W 6 - 3 /
	 BYTE	  01010000B,00010001B
;
	 BYTE	  00FH,0F0H+006H,00000000B+OCS0,0AFH,0F0H+002H,00000000B+OST0  : 0
	 BYTE	  0D8H,00000000B+OPB1+002H
;
	 BYTE	  0DEH,00010000B
;
	 BYTE	  008H,10000000B+OPB1+004H,05AH,00000000B+OPB1+002H  : 1
	 BYTE	  06CH,00000000B+OBG2+00CH,086H,00000000B+OCO0+003H
	 BYTE	  0ADH,00000000B+JFST+000H
;
	 BYTE	  03AH,10000000B+OPB1+002H,053H,00000000B+OCO0+002H  : 2
	 BYTE	  088H,00000000B+OPB1+004H,09CH,00000000B+OBG1+006H
;
	 BYTE	  008H,10000000B+OPB1+004H,04AH,00000000B+OPB1+002H  : 3
	 BYTE	  05CH,00000000B+OBG2+00DH
;
	 BYTE	  03AH,10000000B+OPB1+002H,09CH,00000000B+OBG1+002H  : 4
	 BYTE	  0FCH,00000000B+OBG2+001H
;
	 BYTE	  03CH,10000000B+OBG1+001H,083H,00000000B+000H+OBMS  : 5
	 BYTE	  0ACH,00000000B+OBG2+002H
;
	 BYTE	  02AH,10000000B+OPB1+002H,03CH,00000000B+OBG2+006H  : 6
	 BYTE	  0AAH,00000000B+OPB1+002H,0BCH,00000000B+OBG2+00EH
	 BYTE	  0C6H,00000000B+OCO0+003H
;
	 BYTE	  046H,10000000B+OCO0+003H,0AAH,00000000B+OPB1+002H  : 7
	 BYTE	  0BDH,00000000B+JFST+000H
;
;	    (point)
	 BYTE	  00BH,10000000B+OLD0+006H			     : 8
	 BYTE	  047H,00000000B+OBBM+000H
	 BYTE	  0C7H,00000000B+OLD0+002H
;
	 BYTE	  03CH,10000000B+OBG2+002H,09CH,00000000B+OBG2+001H  : 9
	 BYTE	  0CDH,00000000B+JFST+000H
	 BYTE	  0DCH,00000000B+OBG1+002H
;
	 BYTE	  04CH,10000000B+OBG2+002H,0BCH,00000000B+OBG1+002H  : A
;
	 BYTE	  01CH,10000000B+OBG1+001H,05AH,00000000B+OPB1+002H  : B
	 BYTE	  06CH,00000000B+OBG2+004H,076H,00000000B+OCO0+003H
	 BYTE	  0BAH,00000000B+OPB1+002H,0DCH,00000000B+OBG1+002H
;
	 BYTE	  05DH,10000000B+EXOF+000H,073H,00000000B+OLD0+002H  : C
	 BYTE	  0E3H,00000000B+OLD0+002H
;
	 BYTE	  08EH,10010001B				     : D
	 BYTE	  09DH,00000000B+000H+OPL0
	 BYTE	  0BEH,01000010B
	 BYTE	  0BFH,0F0H+000H,00000000B+OCS0
;
	 BYTE	  09DH,10000000B+SCOF+000H			     : E
;
	 BYTE	  0FDH
;
;
FXOD25	 EQU	  $	    ;< Ground - 15 >		    / W 7 - 1 /
	 BYTE	  01010010B,10110001B
;
	 BYTE	  00FH,0F0H+000H,00000000B+OCS0				  : 0
	 BYTE	  06EH,01110110B
;
	 BYTE	  003H,10000000B+OBK1+001H,009H,00000000B+OCM2+001H  : 1
	 BYTE	  00FH,0F0H+001H,00000000B+FCM2,06FH,0F0H+003H,00000000B+OST0
	 BYTE	  0A7H,00000000B+OPB1+003H,0B7H,00000000B+OBK1+004H
	 BYTE	  0BCH,00000000B+OHL0+00EH
;
	 BYTE	  04DH,10000000B+000H+KZST			     : 2
;
	 BYTE	  003H,10000000B+OBK0+006H,008H,00000000B+OCM2+002H  : 3
	 BYTE	  03FH,0F0H+002H,00000000B+FCM2,06DH,00000000B+000H+KZST
	 BYTE	  073H,00000000B+OBBM+000H,077H,00000000B+OCM2+003H
	 BYTE	  083H,00000000B+OBK0+007H
	 BYTE	  0ACH,00000000B+OHL0+000H,0BFH,0F0H+003H,00000000B+FCM2
;
	 BYTE	  03CH,10000000B+OHL0+000H,09AH,00000000B+OBK1+000H  : 4
	 BYTE	  0ACH,00000000B+OWT0+00BH,0C6H,00000000B+OBK1+00CH
;
	 BYTE	  06AH,10000000B+OBK1+000H,075H,00000000B+OGN0+000H  : 5
	 BYTE	  096H,00000000B+OCM2+004H,0B6H,00000000B+OBBS+000H
	 BYTE	  0DAH,00000000B+OBK1+000H,0E3H,00000000B+OBK0+008H
	 BYTE	  0ECH,00000000B+OWT0+00BH
	 BYTE	  0EDH,00000000B+JFST+000H
;
	 BYTE	  0AAH,10000000B+OBK1+000H			     : 6
;
;	    (point)
	 BYTE	  033H,10000000B+OBK1+004H,051H,00000000B+OCM0+001H  : 7
	 BYTE	  0ADH,00000000B+EXOF+000H,0DDH,00000000B+000H+KZOF
	 BYTE	  0E3H,00000000B+OBK0+00CH
;
	 BYTE	  00CH,10000000B+OBC2+00AH,073H,00000000B+000H+OBBM  : 8
	 BYTE	  0B3H,00000000B+OSMS+000H,0CBH,00000000B+OCM2+001H
	 BYTE	  0ECH,00000000B+OHL0+007H
;
	 BYTE	  00DH,00AH
	 BYTE	  039H,00000000B+OCM2+001H			     : A
	 BYTE	  0DFH,0F0H+003H,00000000B+OST0
;
	 BYTE	  0CAH,10000000B+OBK1+000H,0D6H,00000000B+OGN0+000H  : B
	 BYTE	  0D7H,00000000B+OBK1+000H,0DCH,00000000B+OHL0+00CH
;
	 BYTE	  003H,10000000B+OBK1+001H,0ADH,00000000B+OPL0+000H  : C
	 BYTE	  0EFH,0F0H+006H,00000000B+OCS0
;
	 BYTE	  0EDH,10000000B+SCOF+000H			     : D
;
;
	 BYTE	  039H,10000000B+OCM2+001H			     : E
;
	 BYTE	  00DH,010H
	 BYTE	  07DH,00000000B+000H+KZST			     :10
;
	 BYTE	  00DH,013H
	 BYTE	  0A8H,00000000B+OGN0+001H,0AAH,00000000B+OGN0+000H  :13
;
	 BYTE	  01CH,10000000B+OHL0+003H,0D7H,00000000B+OCM0+003H  :14
	 BYTE	  0F3H,00000000B+OPB1+007H
;
	 BYTE	  05DH,10000000B+000H+KZOF			     :15
	 BYTE	  06DH,00000000B+SCOF+000H
;
	 BYTE	  0FDH
;
;
FXOD26	 EQU	  $	    ;< Ground - 16 >		    / W 7 - 2 /
	 BYTE	  01010110B,00010001B
;
	 BYTE	  00FH,0F0H+006H,00000000B+OCS0,0DFH,0F0H+002H,00000000B+OST0  : 0
;
;	    (loop point)
DA005	 EQU	  $
	 BYTE	  0FEH,00010001B
;
	 BYTE	  00DH,001H					     : 1
	 BYTE	  00CH,00000000B+OWT0+00FH
;
	 BYTE	  003H,10000000B+OBMS+000H,00CH,00000000B+OWT0+002H  : 2
	 BYTE	  029H,00000000B+OLD0+005H,07CH,00000000B+OWT0+00BH
;
	 BYTE	  023H,10000000B+OBK1+002H			     : 3
	 BYTE	  029H,00000000B+OLD0+00FH,031H,00000000B+OCM0+001H
;
	 BYTE	  01CH,10000000B+OWT0+00EH,048H,00000000B+OBK1+00BH  : 4
	 BYTE	  0EDH,00000000B+000H+CSLP
;	    (loop point)
;
	 BYTE	  039H,10000000B+OCM2+001H			     : 5
;
;	    (point)
	 BYTE	  0CFH,0F0H+003H,10000000B+OST0				  : 6
	 BYTE	  0FEH,00010000B
;
	 BYTE	  037H,10000000B+OSP0+000H			     : 7
	 BYTE	  077H,00000000B+OSP0+000H
	 BYTE	  09EH,00010001B
	 BYTE	  0A8H,00000000B+OBK1+004H,0A9H,00000000B+OBK1+004H
	 BYTE	  0AAH,00000000B+OBK1+004H,0F8H,00000000B+OPB1+002H
	 BYTE	  0FEH,00010000B
;
	 BYTE	  037H,10000000B+OBK1+006H			     : 8
	 BYTE	  0DEH,00010001B
	 BYTE	  0E7H,00000000B+OPB1+003H,0F8H,00000000B+OPB1+002H
;
	 BYTE	  009H,10000000B+OPB1+001H			     : 9
	 BYTE	  00EH,00010000B
	 BYTE	  047H,00000000B+OBK1+006H,0B7H,00000000B+OSP0+000H
;
	 BYTE	  0BEH,10010001B
	 BYTE	  0CAH,00000000B+OBK1+002H			     : A
	 BYTE	  0EEH,00010000B
;
	 BYTE	  01DH,10000000B+EXOF+000H
	 BYTE	  07EH,00010001B				     : B
	 BYTE	  083H,00000000B+OCM2+007H
	 BYTE	  09EH,00010000B
;
	 BYTE	  01EH,10010001B				     : C
	 BYTE	  02DH,00000000B+OPL0+000H
	 BYTE	  06FH,0F0H+006H,00000000B+OCS0
;
	 BYTE	  06DH,10000000B+SCOF+000H			     : D
;
	 BYTE	  0FDH
;
;
FXOD27	 EQU	  $	    ;< Ground - 17 >		    / W 7 - 3 /
	 BYTE	  01010111B,00010001B
;
	 BYTE	  00FH,0F0H+006H,00000000B+OCS0				  : 0
	 BYTE	  0FEH,00010000B
;
	 BYTE	  04BH,10000000B+OLD0+002H,059H,00000000B+OBOD+000H  : 1
	 BYTE	  0ADH,00000000B+000H+KZST
;
	 BYTE	  0D3H,10000000B+OLD0+003H			     : 2
;
	 BYTE	  00BH,10000000B+OLD0+004H,029H,00000000B+OBOD+000H  : 3
;
	 BYTE	  07BH,10000000B+OLD0+003H,099H,00000000B+OBOD+000H  : 4
;
	 BYTE	  00DH,006H
	 BYTE	  027H,00000000B+OLD0+002H,035H,00000000B+OBOD+000H  : 6
;
	 BYTE	  023H,10000000B+OBK1+001H,057H,00000000B+OCM2+005H  : 7
	 BYTE	  0A3H,00000000B+OBK1+001H,0ABH,00000000B+OCM2+001H
	 BYTE	  0F7H,00000000B+OCM2+005H
;
	 BYTE	  023H,10000000B+OBK1+001H,087H,00000000B+OLD0+003H  : 8
	 BYTE	  095H,00000000B+OBOD+000H
;
	 BYTE	  00DH,00AH
	 BYTE	  023H,00000000B+OBK1+005H,038H,00000000B+OLD0+003H  : A
	 BYTE	  055H,00000000B+OBMS+000H,09BH,00000000B+OLD0+006H
;
;	    (point)
	 BYTE	  00BH,10000000B+OLD0+006H,0C7H,00000000B+OCM2+005H  : B
;;;;;;	       BYTE	0DDH,00000000B+EXOF+000H
;
	 BYTE	  03BH,10000000B+OLD0+002H,049H,00000000B+OBOD+000H  : C
	 BYTE	  0ADH,00000000B+000H+KZST
;
	 BYTE	  029H,10000000B+OLD0+002H
	 BYTE	  052H,00000000B+OCO0+000H,06CH,00000000B+OEP0+005H  : D
	 BYTE	  06FH,0F0H+001H,00000000B+OLW0,072H,00000000B+OCO0+000H
	 BYTE	  0BFH,0F0H+005H,00000000B+OLW0
;
	 BYTE	  003H,10000000B+OLD0+003H,00AH,00000000B+OLD0+003H  : E
	 BYTE	  012H,00000000B+OCO0+001H
	 BYTE	  08BH,00000000B+OLD0+002H,099H,00000000B+OBOD+000H
;
	 BYTE	  00DH,010H
	 BYTE	  047H,00000000B+OLD0+006H,046H,00000000B+OCO0+005H  :10
	 BYTE	  0B3H,00000000B+OBK1+002H
;
	 BYTE	  013H,10000000B+OBK1+001H,057H,00000000B+OSP0+000H  :11
	 BYTE	  0A7H,00000000B+OSP0+000H,0D3H,00000000B+OBK1+001H
;
	 BYTE	  053H,10000000B+OBK1+001H,0A6H,00000000B+OBK1+001H  :12
;
	 BYTE	  003H,10000000B+OBK1+002H,013H,00000000B+OSP0+000H  :13
	 BYTE	  08DH,00000000B+000H+KZOF
	 BYTE	  0AEH,00010001B
	 BYTE	  0BDH,00000000B+000H+OPL0
;;;	    BYTE     0EEH,01010010B
;
	 BYTE	  0DFH,0F0H+000H,00000000B+OCS0				  :14
	 BYTE	  0ADH,10000000B+SCOF+000H
;
	 BYTE	  0FDH
;
;
FXOD28	 EQU	  $	    ;< Ground - 18 >		    / W 8 - 1 /
	 BYTE	  01010010B,10100001B
;
	 BYTE	  00FH,0F0H+000H,00000000B+OCS0				  : 0
	 BYTE	  06EH,01100101B
;
	 BYTE	  057H,10000000B+OCM2+003H,060H,00000000B+OBK0+001H  : 1
	 BYTE	  06FH,0F0H+002H,00000000B+FCM1,0ACH,00000000B+OBC2+005H
;
	 BYTE	  007H,10000000B+OBMS+000H,01CH,00000000B+OBC2+006H  : 2
	 BYTE	  087H,00000000B+ODMS+000H,09CH,00000000B+OBC2+000H
	 BYTE	  0B0H,00000000B+OBK1+003H,0CFH,0F0H+006H,00000000B+FCM1
;
	 BYTE	  057H,10000000B+OPB1+003H,06CH,00000000B+OHL0+004H  : 3
	 BYTE	  0CDH,00000000B+000H+KZST			     : 3
;
	 BYTE	  09AH,10000000B+OBK1+000H,0ACH,00000000B+OHL0+00CH  : 4
;
	 BYTE	  083H,10000000B+OBK1+001H,08FH,0F0H+004H,00000000B+FCM2  : 5
	 BYTE	  0BDH,00000000B+000H+KZOF
	 BYTE	  0F8H,00000000B+OGN0+001H,0FAH,00000000B+OGN0+000H
;
	 BYTE	  083H,10000000B+OBBM+000H			     : 6
	 BYTE	  093H,00000000B+OBK0+002H,09FH,0F0H+004H,00000000B+FCM2
;
	 BYTE	  059H,10000000B+OCM2+001H,089H,00000000B+OPB1+001H  : 7
	 BYTE	  0A9H,00000000B+OPB1+001H,0BCH,00000000B+OHL0+00CH
;
	 BYTE	  067H,10000000B+OBK0+000H,0EBH,00000000B+OCM2+001H  : 8
;
	 BYTE	  077H,10000000B+OBBM+000H,07AH,00000000B+OGN0+000H  : 9
	 BYTE	  086H,00000000B+OPB0+001H,095H,00000000B+OPB0+002H
	 BYTE	  0A4H,00000000B+OPB0+003H,0B6H,00000000B+OSMS+000H
	 BYTE	  0B3H,00000000B+OBK0+004H
;
	 BYTE	  026H,10000000B+OSDM+000H,04AH,00000000B+OGN0+000H  : A
	 BYTE	  053H,00000000B+OBK0+003H,05CH,00000000B+OHL0+000H
	 BYTE	  06FH,0F0H+003H,00000000B+FCM2,093H,00000000B+ODMT+000H
;
	 BYTE	  007H,10000000B+OCM0+003H,02CH,00000000B+OHL0+004H  : B
	 BYTE	  033H,00000000B+OBK1+000H,074H,00000000B+OCM2+006H
	 BYTE	  0EBH,00000000B+OCM2+001H
;
	 BYTE	  057H,10000000B+ORBC+000H,06CH,00000000B+OHL0+002H  : C
	 BYTE	  096H,00000000B+OCM2+004H,0E3H,00000000B+OBK1+000H
;
	 BYTE	  00CH,10000000B+OHL0+006H			     : D
	 BYTE	  07DH,00000000B+OPL0+000H
	 BYTE	  0BFH,0F0H+006H,00000000B+OCS0
;
	 BYTE	  0BDH,10000000B+SCOF+000H			     : E
;
	 BYTE	  0FDH
;
;
FXOD31	 EQU	  $	    ;< Ground - 21 >		    / W 8 - 2 /
	 BYTE	  01010000B,01100001B
;
	 BYTE	  00FH,0F0H+006H,00000000B+OCS0				  : 0
;
	 BYTE	  0BBH,10000000B+OCM2+001H,0DCH,00000000B+OHL0+006H  : 1
;
	 BYTE	  023H,10000000B+OBBM+000H			     : 2
	 BYTE	  0B5H,00000000B+OCM2+001H,0B7H,00000000B+OBK1+001H
	 BYTE	  0D7H,00000000B+OBK0+008H
;
	 BYTE	  006H,10000000B+OCO0+005H,067H,00000000B+ODMT+000H  : 3
;
	 BYTE	  00DH,005H
	 BYTE	  039H,00000000B+OCM2+001H,07CH,00000000B+OHL0+000H  : 5
	 BYTE	  09EH,01100010B
	 BYTE	  0B6H,00000000B+OSCO+000H
;;K;;	      BYTE     0B6H,00000000B+ORBC+000H
	 BYTE	  0E6H,00000000B+OSDM+000H
;;K;;	      BYTE     0E6H,00000000B+ODMT+000H
;
	 BYTE	  04EH,11100000B				     : 6
	 BYTE	  05DH,00000000B+000H+KZST
	 BYTE	  059H,00000000B+OBOD+000H,06CH,00000000B+OHL0+002H
	 BYTE	  093H,00000000B+OPB1+007H,0ACH,00000000B+OWT0+006H
	 BYTE	  0ADH,00000000B+000H+KZST
;
	 BYTE	  01FH,0F0H+001H,10000000B+OST0,03CH,00000000B+OHL0+001H  : 7
	 BYTE	  098H,00000000B+OBBS+000H
	 BYTE	  09EH,00100000B
	 BYTE	  0A8H,00000000B+OBK0+001H,0F3H,00000000B+OBBW+000H
;
	 BYTE	  00EH,10100001B				     : 8
	 BYTE	  027H,00000000B+OBK0+000H
	 BYTE	  03EH,01100010B
	 BYTE	  056H,00000000B+OSDM+000H
;;K;;	      BYTE     056H,00000000B+ODMT+000H
	 BYTE	  07DH,00000000B+000H+KZOF
	 BYTE	  0C6H,00000000B+OSDM+000H
;;K;;	      BYTE     0C6H,00000000B+ODMT+000H
;
	 BYTE	  03EH,11100000B				     : 9
	 BYTE	  09EH,01100010B
	 BYTE	  0B6H,00000000B+OSDM+000H
;;K;;	      BYTE     0B6H,00000000B+ODMT+000H
;
	 BYTE	  01EH,11100000B				     : A
	 BYTE	  04CH,00000000B+OHL0+000H,06CH,00000000B+OHL0+000H
	 BYTE	  0A7H,00000000B+OCM0+003H
;;;	    BYTE     0DEH,00101111B
	BYTE	0E0H,00000000B+OPB1+00AH
	BYTE	0F0H,00000000B+OPB1+00AH
;
	BYTE	000H,10000000B+OPB1+00AH
	 BYTE	  06DH,00000000B+SCOF+000H			     : B
	 BYTE	  0FEH,00010000B
;
	 BYTE	  00BH,10000000B+OMS0+003H,05BH,00000000B+OMS0+005H  : C
	 BYTE	  0B7H,00000000B+OMS0+002H
;
	 BYTE	  003H,10000000B+OMS0+001H,0ABH,00000000B+OMS0+00FH  : D
	 BYTE	  0BDH,00000000B+OPL0+000H
	 BYTE	  0FFH,0F0H+006H,00000000B+OCS0
;
	 BYTE	  0BDH,10000000B+SCOF+000H			     : E
;
	 BYTE	  0FDH
;
;
FXOD32	 EQU	  $	    ;< Ground - 22 >		    / W 8 - 3 /
	 BYTE	  01010000B,01010000B
;
	 BYTE	  00FH,0F0H+006H,00000000B+OCS0				  : 0
	 BYTE	  00BH,00000000B+OMS0+00FH
;
	 BYTE	  057H,10000000B+OMS0+002H			     : 1
	 BYTE	  08BH,00000000B+OMS0+002H,0D2H,00000000B+OMS0+004H
;
	 BYTE	  04BH,10000000B+OMS0+002H,059H,00000000B+OBOD+000H  : 2
;
	 BYTE	  00BH,10000000B+OMS0+005H,0BBH,00000000B+OMS0+00FH  : 3
	 BYTE	  0BEH,01010010B
;
	 BYTE	  058H,10000000B+OPB1+002H			     : 4
	 BYTE	  09EH,01010000B
	 BYTE	  097H,00000000B+OSDM+000H
;;K;;	      BYTE     097H,00000000B+ODMT+000H
	 BYTE	  0BBH,00000000B+OMS0+00FH
;
	 BYTE	  0AEH,11010010B				     : 5
	 BYTE	  0B6H,00000000B+OSDM+000H
;;K;;	      BYTE     0B6H,00000000B+ODMT+000H
	 BYTE	  0BBH,00000000B+OMS0+00FH
	 BYTE	  0DDH,00000000B+EXOF+000H
	 BYTE	  0F6H,00000000B+OSBM+000H
;;K;;	      BYTE     0F6H,00000000B+OBBM+000H
;
	 BYTE	  02FH,060H+000H,10000000B+STTR			     : 6
	 BYTE	  08EH,01010000B
	 BYTE	  098H,00000000B+OPB1+002H,0EBH,00000000B+OMS0+001H
;
	 BYTE	  007H,10000000B+OCM2+003H,00BH,00000000B+OMS0+00DH  : 7
	 BYTE	  02EH,01010010B
	 BYTE	  04FH,070H+000H,00000000B+STST
;;K;;	      BYTE     047H,00000000B+OBBS+000H
	 BYTE	  0CEH,01010000B
	 BYTE	  0EBH,00000000B+OMS0+00FH
	 BYTE	  0EEH,01010010B
;
	 BYTE	  05EH,11010000B				     : 8
	 BYTE	  0D9H,00000000B+OBOD+000H
;
	 BYTE	  0ABH,10000000B+OMS0+00FH			     : 9
	 BYTE	  0BEH,01010010B
;
	 BYTE	  08EH,11010000B				     : A
	 BYTE	  0ABH,00000000B+OMS0+00DH
	 BYTE	  0AEH,01010010B
;
	 BYTE	  036H,10000000B+OSCO+000H,056H,00000000B+OSDM+000   : B
;;K;;	      BYTE     036H,10000000B+ORBC+000H,056H,00000000B+ODMT+000H  : B
	 BYTE	  05EH,01010000B
	 BYTE	  0DCH,00000000B+OEP0+005H,0DFH,0F0H+002H,00000000B+OLW0
;
	 BYTE	  02FH,0F0H+005H,10000000B+OLW0,0C3H,00000000B+OBK1+001H  : C
;
	 BYTE	  05BH,10000000B+OMS0+00FH			     : D
	 BYTE	  06DH,00000000B+OPL0+000H
	 BYTE	  08EH,01010010B
	 BYTE	  08FH,0F0H+000H,00000000B+OCS0
;
	 BYTE	  08DH,10000000B+SCOF+000H			     : E
;
;
FXOD33	 EQU	  $	    ;< Ground - 23 >		    ;<W8-4>
;
	 BYTE	  0FDH
;
;
FXOD38	 EQU	  $	    ;< Ground - 28 >	  :BOUNS ;<SKY>
	 BYTE	  00000000B,11000001B
;
	 BYTE	  04CH,00000000B+OHL0+000H,0F3H,00000000B+OCO0+00FH  : 0
;
	 BYTE	  0FAH,10000000B+OCO0+006H			     : 1
;
	 BYTE	  068H,10000000B+OBK0+000H,069H,00000000B+OBK0+000H  : 2
	 BYTE	  06AH,00000000B+OBK0+000H,07AH,00000000B+OCO0+007H
	 BYTE	  0F8H,00000000B+OBK0+000H,0F9H,00000000B+OBK0+000H
	 BYTE	  0FAH,00000000B+OBK0+000H
;
	 BYTE	  00AH,10000000B+OCO0+00FH,0B4H,00000000B+OCO0+009H  : 3
;
	 BYTE	  055H,10000000B+OBK0+000H,056H,00000000B+OBK0+000H  : 4
	 BYTE	  073H,00000000B+OCO0+007H
	 BYTE	  0F5H,00000000B+OBK0+000H,0F6H,00000000B+OBK0+000H
;
	 BYTE	  022H,10000000B+OBK0+001H,041H,00000000B+OCO0+008H  : 5
	 BYTE	  052H,00000000B+OBK0+000H,072H,00000000B+OBK0+000H
	 BYTE	  092H,00000000B+OBK0+000H,0B2H,00000000B+OBK0+000H
	 BYTE	  0FEH,00000000B
;
	 BYTE	  09BH,10000000B+OCO0+002H			     : 6
;
	 BYTE	  0ADH,10000000B+000H+SCOF			     : 7
;
	 BYTE	  0FDH
;
;
;#####################################################################
;#	 Fix obstacle out pos data  ( Underground )		     #
;#####################################################################
FXOD43	 EQU	  $	    ;< Underground - 3 >	    / W 5 - 2 /
	 BYTE	  01001000B,00001111B
;
	 BYTE	  01EH,00000001B				     : 0
	 BYTE	  027H,00000000B+OSBM+000H
	 BYTE	  05EH,00000010B
	 BYTE	  08FH,0F0H+003H,00000000B+FCM1,08CH,00000000B+OHL0+001H
	 BYTE	  0EFH,0F0H+007H,00000000B+FCM1
;
	 BYTE	  01CH,10000000B+OHL0+001H			     : 1
	 BYTE	  02EH,00001001B
	 BYTE	  03CH,00000000B+OBC1+003H,073H,00000000B+ODMS+000H
	 BYTE	  08CH,00000000B+OBC1+000H
	 BYTE	  0FEH,00000010B
;
	 BYTE	  01EH,10001110B				     : 2
	 BYTE	  03EH,00000010B
	 BYTE	  044H,00000000B+OBBM+000H,045H,00000000B+OPB0+002H
	 BYTE	  04EH,00001110B
	 BYTE	  08EH,00000010B
	 BYTE	  099H,00000000B+OCM2+001H
	 BYTE	  0B5H,00000000B+OBK0+004H
	 BYTE	  0B6H,00000000B+OBK0+004H
	 BYTE	  0B7H,00000000B+OBK0+004H
	 BYTE	  0FEH,00000010B
;
	 BYTE	  007H,10000000B+000H+OBBM,017H,00000000B+OBK0+002H  : 3
	 BYTE	  037H,00000000B+OPB0+002H
	 BYTE	  037H,00000000B+ORBC+000H,047H,00000000B+OPB0+002H
	 BYTE	  04EH,00001010B
	 BYTE	  057H,00000000B+OPB0+002H
	 BYTE	  05EH,00000010B
	 BYTE	  067H,00000000B+OPB0+002H,077H,00000000B+OPB0+002H
	 BYTE	  07EH,00001010B
	 BYTE	  087H,00000000B+OPB0+002H
	 BYTE	  08EH,00000010B
	 BYTE	  096H,00000000B+OCO0+006H,097H,00000000B+OPB0+002H
	 BYTE	  0A7H,00000000B+OPB0+002H,0B7H,00000000B+OPB0+002H
	 BYTE	  0C7H,00000000B+OPB0+002H,0D7H,00000000B+OPB0+002H
	 BYTE	  0E7H,00000000B+OPB0+002H,0F7H,00000000B+OPB0+002H
	 BYTE	  0FEH,00000100B
;
	 BYTE	  007H,10000000B+OBK0+003H,047H,00000000B+ODMT+000H  : 4
	 BYTE	  057H,00000000B+OBK0+006H,0C7H,00000000B+OBBS+000H
	 BYTE	  0E9H,00000000B+OCM2+001H
;
	 BYTE	  017H,10000000B+OBK0+007H,097H,00000000B+ODMT+000H  : 5
	 BYTE	  09EH,00000001B
	 BYTE	  0A0H,00000000B+OBK0+004H
	 BYTE	  0C6H,00000000B+OCM2+004H,0F0H,00000000B+OBSM+000H
	 BYTE	  0FEH,00000100B
;
;	    (point)
	 BYTE	  00CH,10000000B+OHL0+000H,06FH,0F0H+002H,00000000B+OST0  : 6
	 BYTE	  098H,00000000B+OPB1+002H,0A8H,00000000B+OPB1+002H
	 BYTE	  0BCH,00000000B+OHL0+000H,0C7H,00000000B+OCM2+003H
	 BYTE	  0E7H,00000000B+OCM2+003H
	 BYTE	  0FEH,00000010B
;
	 BYTE	  07FH,0F0H+007H,10000000B+FCM1				  : 7
	 BYTE	  08EH,00000001B
	 BYTE	  09EH,00000000B
	 BYTE	  0DEH,00000010B
	 BYTE	  0F7H,00000000B+000H+ORBC
	 BYTE	  0FEH,00001110B
;
	 BYTE	  04EH,10000010B				     : 8
	 BYTE	  054H,00000000B+OPB0+002H,064H,00000000B+OPB0+001H
	 BYTE	  06EH,00000000B
	 BYTE	  074H,00000000B+OBBW+000H,09FH,0F0H+000H,00000000B+OEW0
	 BYTE	  0DFH,0F0H+000H,00000000B+OEW0
;
	 BYTE	  02FH,0F0H+000H,10000000B+OEW0				  : 9
	 BYTE	  04EH,00000010B
	 BYTE	  059H,00000000B+OCO0+007H
	 BYTE	  0CEH,00001010B
;
	 BYTE	  007H,10000000B+OCM2+005H,068H,00000000B+OPB0+004H  : A
	 BYTE	  07FH,0F0H+004H,00000000B+FCM1,088H,00000000B+OPB0+004H
	 BYTE	  0A8H,00000000B+OPB0+004H
	 BYTE	  0AEH,00000001B
	 BYTE	  0B8H,00000000B+OPB0+002H,0BFH,0F0H+007H,00000000B+OCM1
	 BYTE	  0C8H,00000000B+OPB0+002H,0D8H,00000000B+OPB0+002H
	 BYTE	  0E8H,00000000B+OPB0+002H
	 BYTE	  0EEH,00001111B
;
	 BYTE	  04DH,10000000B+SCOF+000H			     : B
;
	 BYTE	  00DH,00DH
	 BYTE	  00EH,00000010B				     : D
	 BYTE	  068H,00000000B+OCM0+002H
	 BYTE	  0BEH,00000001B
	 BYTE	  0EEH,00001111B
;
	 BYTE	  06DH,10000000B+000H+SLON			     : E
;
	 BYTE	  0FDH
;
;
FXOD44	 EQU	  $	    ;< Underground - 4 >    (BONUS)
	 BYTE	  00001000B,00001111B
;
; (UNDERGROUND-1)
	 BYTE	  00EH,00000001B				     : 0
	 BYTE	  02EH,00000101B
	 BYTE	  038H,00000000B+OBK0+00CH,03AH,00000000B+OCO0+00FH
;
	 BYTE	  008H,10000000B+OBK0+00CH,0C7H,00000000B+ORBC+000H  : 1
	 BYTE	  0CEH,00000001B
	 BYTE	  0DFH,0F0H+00AH,00000000B+OCM1
;
	 BYTE	  06DH,10000000B+SCOF+000H			     : 2
;
;-----------------------------------------------------------------------
;
; (UNDERGROUND-2)
	 BYTE	  00EH,10000001B				     : 3
	 BYTE	  000H,00000000B+OPB0+00AH
	 BYTE	  02EH,00000010B
	 BYTE	  0B8H,00000000B+OCO0+00FH,0CFH,0F0H+005H,00000000B+FCM1
;
	 BYTE	  00FH,0F0H+005H,10000000B+FCM1,04FH,0F0H+005H,00000000B+FCM1  : 4
	 BYTE	  08FH,0F0H+005H,00000000B+FCM1,0DFH,0F0H+00AH,00000000B+OCM1
;
	 BYTE	  06DH,10000000B+SCOF+000H			     : 5
;
;-----------------------------------------------------------------------
;
; (UNDERGROUND-3)
	 BYTE	  00EH,10000001B				     : 6
	 BYTE	  000H,00000000B+OPB0+00AH
	 BYTE	  030H,00000000B+000H+OBBM,034H,00000000B+OPB0+002H
	 BYTE	  03EH,00000010B
	 BYTE	  042H,00000000B+OCO0+007H,044H,00000000B+OCO0+007H
	 BYTE	  046H,00000000B+OBK0+007H,0C0H,00000000B+000H+ORBC
	 BYTE	  0C4H,00000000B+OPB0+002H,0DFH,0F0H+00AH,00000000B+OCM1
;
	 BYTE	  06DH,10000000B+SCOF+000H			     : 7
;
;-----------------------------------------------------------------------
;
	 BYTE	  0FDH		   : END
;
;
;#####################################################################
;#	 Fix obstacle out pos data  ( Underwater )		     #
;#####################################################################
FXOD51	 EQU	  $	    ;< Underwater - 1 >		    / W 6 - 2 /
	 BYTE	  01000001B,00000001B
;
	 BYTE	  027H,10000000B+OPB0+003H,079H,00000000B+OPB0+001H  : 1
	 BYTE	  0C4H,00000000B+OPB0+006H
;
	 BYTE	  000H,10000000B+OPB1+002H,003H,00000000B+OPB0+003H  : 2
	 BYTE	  00CH,00000000B+OHL0+00FH
	 BYTE	  012H,00000000B+OBK1+00BH,01AH,00000000B+OCO0+002H
	 BYTE	  043H,00000000B+OPB0+004H,06DH,00000000B+000H+WFST
	 BYTE	  083H,00000000B+OPB0+003H
	 BYTE	  099H,00000000B+OPB0+003H,0C3H,00000000B+OPB0+004H
	 BYTE	  0DAH,00000000B+OPB0+002H
;
	 BYTE	  00CH,10000000B+OHL0+004H			     : 3
	 BYTE	  009H,00000000B+OPB0+003H,053H,00000000B+OPB1+004H
	 BYTE	  063H,00000000B+OBK1+001H,067H,00000000B+OBK1+004H
	 BYTE	  086H,00000000B+OCO0+001H,08CH,00000000B+OHL0+001H
	 BYTE	  0A3H,00000000B+OBK1+000H,0B3H,00000000B+OPB1+004H
	 BYTE	  0CCH,00000000B+OHL0+003H,0D9H,00000000B+OCO0+002H
;
	 BYTE	  05CH,10000000B+OHL0+004H			     : 4
	 BYTE	  0A0H,00000000B+OPB1+002H,0A8H,00000000B+OPB1+002H
	 BYTE	  0B0H,00000000B+OPB1+002H,0B8H,00000000B+OPB1+002H
	 BYTE	  0C0H,00000000B+OPB1+002H,0C8H,00000000B+OPB1+002H
	 BYTE	  0D0H,00000000B+OPB1+002H,0D8H,00000000B+OPB1+002H
	 BYTE	  0E0H,00000000B+OPB1+002H,0E8H,00000000B+OPB1+002H
;
	 BYTE	  016H,10000000B+OCO0+002H,058H,00000000B+OPB0+002H  : 5
	 BYTE	  08CH,00000000B+OHL0+004H,0A7H,00000000B+OPB0+005H
	 BYTE	  0D0H,00000000B+OPB1+003H,0D7H,00000000B+OPB1+003H
	 BYTE	  0E2H,00000000B+OPB1+001H,0E7H,00000000B+OPB1+003H
	 BYTE	  0F2H,00000000B+OPB1+001H,0F7H,00000000B+OPB1+003H
;
	 BYTE	  013H,10000000B+OBK1+008H,017H,00000000B+OBK1+008H  : 6
	 BYTE	  08CH,00000000B+OHL0+003H
;
;	    (point)
	 BYTE	  01DH,10000000B+000H+WFST			     : 7
	 BYTE	  050H,00000000B+OPB1+002H,05CH,00000000B+OHL0+00BH
	 BYTE	  062H,00000000B+OBK1+00EH,063H,00000000B+OPB0+002H
	 BYTE	  08AH,00000000B+OPB0+002H
	 BYTE	  093H,00000000B+OPB0+004H,0AAH,00000000B+OCO0+002H
	 BYTE	  0D3H,00000000B+OPB0+001H,0EAH,00000000B+OCO0+001H
;
	 BYTE	  003H,10000000B+OPB0+003H,01CH,00000000B+OHL0+004H  : 8
	 BYTE	  01AH,00000000B+OPB0+002H
	 BYTE	  033H,00000000B+OPB0+005H,073H,00000000B+OCO0+004H
	 BYTE	  077H,00000000B+OCO0+004H
;
	 BYTE	  016H,10000000B+OPB0+002H,019H,00000000B+OBK1+001H  : 9
	 BYTE	  01AH,00000000B+OBK1+002H,05CH,00000000B+OHL0+00FH
	 BYTE	  09AH,00000000B+OCO0+007H
	 BYTE	  095H,00000000B+OPB1+004H,0A5H,00000000B+OPB1+004H
	 BYTE	  0B5H,00000000B+OPB1+004H,0C5H,00000000B+OPB1+004H
	 BYTE	  0D5H,00000000B+OPB1+004H,0E5H,00000000B+OPB1+004H
	 BYTE	  0F5H,00000000B+OPB1+004H
;
	 BYTE	  005H,10000000B+OPB1+004H			     : A
	 BYTE	  040H,00000000B+OPB1+001H
	 BYTE	  042H,00000000B+OBK1+005H,056H,00000000B+OBK1+004H
	 BYTE	  05CH,00000000B+OHL0+009H,0A2H,00000000B+OPB1+001H
	 BYTE	  0A6H,00000000B+OPB1+001H,0B3H,00000000B+OBK1+004H
	 BYTE	  0B7H,00000000B+OBK1+004H,0FCH,00000000B+OHL0+008H
;
	 BYTE	  00CH,10000000B+OHL0+007H,028H,00000000B+OPB0+004H  : B
	 BYTE	  059H,00000000B+OPB0+003H
;
	 BYTE	  09AH,00000000B+OBK1+000H,0A9H,00000000B+OPB1+001H
	 BYTE	  0B8H,00000000B+OPB1+002H
;
;;;	    BYTE     0BEH,00001011B
;
	 BYTE	  0C0H,00000000B+OPB1+003H,0C7H,00000000B+OPB1+003H
	 BYTE	  0D0H,00000000B+OPB1+004H,0D5H,00000000B+OWC0+000H
	 BYTE	  0D7H,00000000B+OPB1+003H
	 BYTE	  0E0H,00000000B+OPB1+00AH,0F0H,00000000B+OPB1+00AH
;
	 BYTE	  000H,10000000B+OPB1+00AH
	 BYTE	  00DH,00000000B+000H+EXOF,07DH,00000000B+SCOF+000H  : C
;
;;;	    BYTE     0D4H,00000000B+OPB1+000H	     ;****
;;;	    BYTE     0D5H,00000000B+OWC0+000H
;
;;;	    BYTE     0DEH,00001111B
;
;;;	    BYTE     0E0H,00000000B+OPB1+00AH
;;;	    BYTE     0F0H,00000000B+OPB1+00AH
;
;;;	    BYTE     000H,00000000B+OPB1+00AH
;;;	    BYTE     06DH,10000000B+SCOF+000H
;
;
;;;	    BYTE     00DH,10000000B+000H+EXOF,07DH,00000000B+SCOF+000H	: C
;
	 BYTE	  0FDH
;
;
FXOD53	 EQU	  $	    ;< Underwater - 3 >		    ;<W8-4>
	 BYTE	  00000111B,00001111B
;
	BYTE	00FH,010H+000H,00000000B+ONBK
	 BYTE	  00EH,00000010B				     : 0
	BYTE	01FH,0B0H+000H,00000000B+OCTR
	BYTE	02FH,0B0H+000H,00000000B+OCTL
	 BYTE	  039H,00000000B+OCM2+003H
	BYTE	05FH,0B0H+000H,00000000B+OCTR
;
	 BYTE	  005H,10000000B+OSP0+000H			     : 1
	 BYTE	  02EH,00001011B
	BYTE	02FH,0A0H+001H,00000000B+OCRC
	BYTE	03FH,070H+000H,00000000B+OCTR
	BYTE	03FH,010H+000H,00000000B+ONBK
	 BYTE	  0B7H,00000000B+OSP0+000H
;
	 BYTE	  064H,10000000B+OSP0+000H			     : 2
	 BYTE	  06EH,00000010B
	BYTE	06FH,010H+000H,00000000B+ONBK
	BYTE	06FH,0A0H+001H,00000000B+OCLC
	BYTE	06FH,070H+000H,00000000B+OCTL
	BYTE	0CEH,00000110B
	BYTE	0CFH,0A0H+001H,00000000B+OCRC
	BYTE	0DFH,080H+000H,00000000B+OCTR
	BYTE	0DEH,00001000B
	BYTE	0EFH,040H+001H,00000000B+OLBK
	BYTE	0EFH,020H+000H,00000000B+ONBK
	BYTE	0E6H,00000000B+OWC0+000H
	BYTE	0FFH,040H+003H,00000000B+OLBK
	BYTE	0FFH,070H+000H,00000000B+ONBK
;
	BYTE	00FH,040H+003H,10000000B+OLBK				; 3
	BYTE	07DH,00000000B+SCOF+000H
;
	BYTE	0FDH
;
;
FXOD54	 EQU	  $	    ;< Underwater - 4 >		    ;<BONUS>
	 BYTE	  00000001B,00000001B
;
	 BYTE	  077H,00000000B+OBK1+009H,0A3H,00000000B+OCO0+003H  : 0
;
	 BYTE	  000H,10000000B+OBK1+00FH,029H,00000000B+OPB0+001H  : 1
	 BYTE	  039H,00000000B+OCO0+008H
	 BYTE	  061H,00000000B+OPB0+005H
	 BYTE	  0D6H,00000000B+OPB0+004H
	 BYTE	  0D2H,00000000B+OCO0+004H
;
	 BYTE	  00CH,10000000B+OHL0+002H			     : 2
;;;;	     BYTE     02EH,00000010B
	 BYTE	  030H,00000000B+OBK1+009H	;T
	 BYTE	  031H,00000000B+OPB1+006H,044H,00000000B+OCO0+007H
	 BYTE	  047H,00000000B+OBK1+002H,04AH,00000000B+OCO0+007H
	 BYTE	  097H,00000000B+OBK1+002H,0C1H,00000000B+OPB1+006H
	 BYTE	  0CEH,00000001B
	 BYTE	  0DCH,00000000B+OHL0+002H
;;;	    BYTE     0FEH,00001110B
	 BYTE	  000H,10000000B+OBK1+00FH
	 BYTE	  004H,00000000B+OBK1+00FH
	 BYTE	  005H,00000000B+OBK1+00FH
	 BYTE	  006H,00000000B+OBK1+00FH
	 BYTE	  007H,00000000B+OBK1+00FH
;
	 BYTE	  00CH,00000000B+OHL0+00FH,008H,00000000B+OCO0+00FH  : 3
	 BYTE	  0FEH,00000001B
;
	 BYTE	  027H,10000000B+OPB0+003H,05CH,00000000B+OHL0+002H  : 4
	 BYTE	  09AH,00000000B+OPB1+000H,0A9H,00000000B+OPB1+001H
	 BYTE	  0B8H,00000000B+OPB1+002H,0C7H,00000000B+OPB1+003H
;;;	    BYTE     0CEH,00001111B
	 BYTE	  0D0H,00000000B+OPB1+004H
	 BYTE	  0D5H,00000000B+OWC0+000H
	 BYTE	  0D7H,00000000B+OPB1+003H
	 BYTE	  0E0H,00000000B+OPB1+00AH
	 BYTE	  0F0H,00000000B+OPB1+00AH
;
	 BYTE	  000H,10000000B+OPB1+00AH
	 BYTE	  07DH,00000000B+SCOF+000H			     : 5
;
	 BYTE	  0FDH
;
;
;*********************************************************************
;*	 Castle loop check data					     *
;*********************************************************************
DA03	 EQU	  DA003-FXOD05
DA04	 EQU	  DA004-FXOD05
DA05	 EQU	  DA005-FXOD26
DA07	 EQU	  DA007-FXOD07
DA08	 EQU	  DA008-FXOD07
DA10	 EQU	  DA010-FXOD22
;
;#####################################################################
;#	 Fix chara out pos data	 ( Castle )			     #
;#####################################################################
FXCD08	 EQU	  $	    ;< Castle - 08 >		    / W 9 - 3 /
;
	 BYTE	  01FH,001H
	 BYTE	  00EH,01101001B,00000000B
	 BYTE	  01FH,00BH
	 BYTE	  078H,00000000B+BKM0
;
	 BYTE	  0FFH
;
;
;
;#####################################################################
;#	 Fix chara out pos data	 ( Castle )			     #
;#####################################################################
FXCD09	 EQU	  $	    ;< Castle - 09 >		    / W 9 - 3 /
;
	 BYTE	  01FH,001H
	 BYTE	  01EH,01101000B,00000110B
	 BYTE	  0FFH
;
;
;#####################################################################
;#	 Fix chara out pos data	 ( Ground )			     #
;#####################################################################
FXCD34	 EQU	  $	    ;< Ground - 12 >  (ASURETIC)    / W 9 - 1 /
;
	 BYTE	  01EH,000000101B,0000000B
	 BYTE	  0FFH
;
;
;
FXCD35	 EQU	  $	    ;< Ground - 14 >
;
;
FXCD36	 EQU	  $	    ;< Ground - 16 >
;
;#####################################################################
;#	 Fix chara out pos data	 ( Underwater )			     #
;#####################################################################
FXCD55	 EQU	  $	    ;< Ground - 12 >		    / W 9 - 1 /
;
	 BYTE	  026H,10000000B+FTR6	; 1
;
	 BYTE	  005H,10000000B+ELV1	; 2
	 BYTE	  046H,00000000B+FTR6
;
	 BYTE	  01FH,004H		; 4
	 BYTE	  0E8H,00000000B+FTR7
;
	 BYTE	  038H,10000000B+FTR7	; 5
	 BYTE	  066H,00000000B+ESHP
	 BYTE	  0FBH,00000000B+GRP5
;
	 BYTE	  09BH,10000000B+GRP0	; 6
;
	 BYTE	  0CBH,10000000B+FIEN	; 7
;
	 BYTE	  029H,10000000B+IKTR	; 8
	 BYTE	  095H,00000000B+IKTR
	 BYTE	  0EBH,00000000B+BKTR
 ;
	 BYTE	  00BH,10000000B+BKTR	; 9
	 BYTE	  096H,00000000B+FTR2
	 BYTE	  0C3H,00000000B+FTR2
	 BYTE	  0FFH
;
;#####################################################################
;#	 Fix chara out pos data	 ( Underwater )			     #
;#####################################################################
FXCD56	 EQU	  $	    ;< Ground - 12 >		    / W 9 - 2 /
;
	 BYTE	  01FH,001H
	 BYTE	  0E6H,00000000B+ESHP
;
	 BYTE	  0FFH
;
;#####################################################################
;#	 Fix chara out pos data	 ( Underwater )			     #
;#####################################################################
FXCD57	 EQU	  $	    ;< Ground - 12 >		    / W 9 - 4 /
;
	 BYTE	  03BH,10000000B+YPVS
	 BYTE	  07BH,00000000B+SHTR
	 BYTE	  0BBH,00000000B+BKTR
;
	 BYTE	  02BH,10000000B+FTR2
	 BYTE	  07AH,00000000B+FIEN
;
	 BYTE	  057H,10000000B+IKTR
;
	 BYTE	  027H,10000000B+FTR6
	 BYTE	  09AH,00000000B+JPTR
;
	 BYTE	  0FFH
;
;
;############################################################################################
;#	 Fix obstacle out position data							    #
;############################################################################################
;
;		 +------+------+  +------+------+
;	 FXODxx	 I x xxx xxxxx I  I  xxx  xxxxx I
;	     ^^	 +------+------+  +------+------+
;	     ||	   ^  ^	   ^	      ^	    ^
;	     ||	   |  |	   |	      |	    |
;	     ||	   |  |	   |	      |	    |
;	     ||	   |  |	   |	      |	    |
;	     ||	   |  |	   |	      |	    +---  Floor display max loop
;	     ||	   |  |	   |	      +--------- Player start position data index
;	     ||	   |  |	   |
;	     ||	   |  |	   +------  Base BG environmen
;	     ||	   |  +-----------  Play farst base time
;	     ||	   +--------------  0:ON Floor	      1:OFF Floor
;	     ||
;	     ||	 +------+------+------+------+-----+-----+
;	     ||	 I x x	xxxxxx I xxxx | xxxx I xxxx|xxxx I
;	     ||	 +------+------+------+------+-----+-----+
;	     ||	   ^ ^	   ^	   ^	  ^	 ^    ^
;	     ||	   | |	   |	   |	  |	 |    |
;	     ||	   | |	   |	   |	  |	 |    +----  Obstacle display count
;	     ||	   | |	   |	   |	  |	 +---------  Obstacle kind No.
;	     ||	   | |	   |	   |	  +-  (y)pos-L	     F:BG environment change mode
;	     ||	   | |	   |	   +--------  (x)pos-L
;	     ||	   | |	   |
;	     ||	   | |	   +------  (x)pos-H  ( FF : End crode )
;	     ||	   | +------------  0:Floot length 1:Fix length
;	     ||	   |
;	     ||	   +--------  00:Out  11:No out
;	     ||
;	     |+---  Kind corde
;	     +----  0:Underwater 1:Ground  2:Underground  3:Castle
;
;#####################################################################
;#	 Fix obstacle out pos data  ( Castle )			     #
;#####################################################################
FXOD08	 EQU	  $	    ;< Castle - 08 >		    / W 9 - 3 /
;
;						9W - 3	(castle)
	 BYTE	  01010101B,00110001B
;
	 BYTE	  00DH,00000001B				     ; 1
	 BYTE	  0CFH,0F0H+003H,00000000B+OST0
	 BYTE	  0FEH,00111001B
;
	BYTE	00FH,0A0H+000H,10000000B+OCRC
	BYTE	00FH,070H+000H,00000000B+OCTR
	BYTE	00FH,000H+000H,00000000B+ONBK
;
	 BYTE	  0FEH,00110010B				     ; 2
	BYTE	0FFH,0A0H+001H,00000000B+OCLC
	BYTE	0FFH,070H+000H,00000000B+OCTL
;
	 BYTE	  02EH,10000010B				     ; 3
	 BYTE	  034H,00000000B+OBK1+00BH
	 BYTE	  035H,00000000B+OBK1+00BH
	 BYTE	  036H,00000000B+OBK1+00BH
	 BYTE	  037H,00000000B+OBK1+00BH
	 BYTE	  0F4H,00000000B+OPB1+003H
	BYTE	0FFH,000H+000H,00000000B+ONBK
	 BYTE	  0FEH,00110001B
;
	 BYTE	  029H,10000000B+OBOD+000H,09EH,01000011B	     ; 4
	 BYTE	  0FEH,00110000B
	BYTE	0FFH,0B0H+000H,00000000B+OCTL
;
	 BYTE	  016H,10000000B+OBK1+001H,023H,00000000B+OBBW+000H  ; 5
	 BYTE	  04EH,00110001B
	 BYTE	  04EH,01000000B
	BYTE	05FH,0B0H+000H,00000000B+OCTR
;
	 BYTE	  0D7H,10000000B+OPB1+000H			     ; 6
	 BYTE	  0E6H,00000000B+OPB1+001H
	 BYTE	  0FEH,00000010B
	 BYTE	  0F5H,00000000B+OPB1+002H
	 BYTE	  0FAH,00000000B+OPB1+000H
	BYTE	0FFH,0B0H+000H,00000000B+OCTL
;
	 BYTE	  00CH,10000000B+OWT0+00FH			     ; 7
	BYTE	00FH,000H+000H,00000000B+ONBK
	 BYTE	  004H,00000000B+OPB1+003H
	 BYTE	  014H,00000000B+OBK1+00EH
	 BYTE	  015H,00000000B+OBK1+00EH
	 BYTE	  016H,00000000B+OBK1+00EH
	 BYTE	  017H,00000000B+OBK1+00EH
;
	 BYTE	  00CH,10000000B+OWT0+00FH			     ; 8
	 BYTE	  004H,00000000B+OBK1+00FH
	 BYTE	  005H,00000000B+OBK1+00FH
	 BYTE	  006H,00000000B+OBK1+00FH
	 BYTE	  007H,00000000B+OBK1+00FH
;
	 BYTE	  00CH,10000000B+OWT0+001H			    ; 9
	 BYTE	  004H,00000000B+OPB1+003H
	 BYTE	  014H,00000000B+OPB1+003H
	 BYTE	  01EH,00110010B
	BYTE	02FH,0B0H+000H,00000000B+OCTR
	 BYTE	  024H,00000000B+OPB1+004H
	 BYTE	  02DH,00000000B+OCM3+000H
	BYTE	03FH,000H+000H,00000000B+ONBK
	 BYTE	  034H,00000000B+OPB1+004H
	 BYTE	  04EH,00110010B
	 BYTE	  05EH,00110110B
	 BYTE	  05EH,01000010B
	BYTE	06FH,0A0H+000H,00000000B+OCRC
	BYTE	06FH,080H+000H,00000000B+OCTR
	BYTE	06FH,000H+000H,00000000B+ONBK
	 BYTE	  0CEH,00111000B
	BYTE	0DFH,010H+000H,00000000B+ONBK
;
	 BYTE	  00DH,00BH					     ; B
	 BYTE	  08EH,00110110B
	 BYTE	  08EH,01000000B
	BYTE	08FH,010H+000H,00000000B+ONBK
	 BYTE	  087H,00000000B+OBK1+007H,096H,00000000B+OBK1+006H
	 BYTE	  0EEH,00111010B
	BYTE	0EFH,080H+000H,00000000B+OCTL
	 BYTE	  0FCH,00000000B+OWT0+00AH
;
	 BYTE	  006H,10000000B+OBK1+00DH,007H,00000000B+OBK1+00EH  ; C
	 BYTE	  09EH,00000110B
	BYTE	0AFH,080H+000H,00000000B+OCTR
;	  BYTE	   0A8H,00000000B+OPB1+004H
;	  BYTE	   0B8H,00000000B+OPB1+004H
;	  BYTE	   0C8H,00000000B+OPB1+004H
;	  BYTE	   0D8H,00000000B+OPB1+004H
;	  BYTE	   0E8H,00000000B+OPB1+004H
;	  BYTE	   0F8H,00000000B+OPB1+004H
	BYTE	0FFH,0A0H+001H,00000000B+OCLC
	BYTE	0FFH,080H+000H,00000000B+OCTL
	 BYTE	  0FEH,00110001B
	BYTE	0FFH,000H+000H,00000000B+ONBK
;
	 BYTE	  009H,10000000B+OPB1+001H,01AH,00000000B+OPB1+000H  ; D
	 BYTE	  06DH,00000000B+OPL0+000H,0AFH,0F0H+006H,00000000B+OCS0
;
	 BYTE	  08DH,10000000B+SCOF+000H			     ; E
;
	 BYTE	  0FDH
;
;
;#####################################################################
;#	 Fix obstacle out pos data  ( Castle )			     #
;#####################################################################
FXOD09	 EQU	  $	    ;< Castle - 09 >		    / W 9 - 3 /
;
;						 9W - 3 SKY
	 BYTE	  00000000B,11110001B
;
	 BYTE	  0FEH,10110101B				     ; 0
;
	 BYTE	  00DH,00000010B				     ; 2
	 BYTE	  0FEH,00110100B
;
	 BYTE	  007H,10000000B+OCO0+00FH			     ; 3
	 BYTE	  0CEH,00000000B+000H+000H
;
	 BYTE	  00DH,00000101B				     ; 5
	 BYTE	  08DH,00000000B+SCOF+000H			     ;
;
	 BYTE	  0FDH
;
;
;						 9W - 3 SKY
	 BYTE	  00000000B,11000001B
;
	BYTE	03FH,0B0H+000H,00000000B+OCTL
	 BYTE	  04CH,00000000B+OHL0+000H
	BYTE	05FH,0B0H+000H,00000000B+OCTR
;	  BYTE	   0FEH,00000101B				      ; 0
;
	 BYTE	  000H,10000000B+OPB1+007H
	 BYTE	  010H,00000000B+OPB1+007H
	 BYTE	  020H,00000000B+OPB1+007H
	 BYTE	  030H,00000000B+OPB1+007H
	 BYTE	  040H,00000000B+OPB1+007H
	 BYTE	  050H,00000000B+OPB1+007H
	 BYTE	  060H,00000000B+OPB1+007H
	 BYTE	  070H,00000000B+OPB1+007H
	 BYTE	  080H,00000000B+OPB1+007H
	 BYTE	  090H,00000000B+OPB1+007H
	 BYTE	  0A0H,00000000B+OPB1+007H
	 BYTE	  0B0H,00000000B+OPB1+007H
	 BYTE	  0C0H,00000000B+OPB1+007H
	 BYTE	  0D0H,00000000B+OPB1+007H
	 BYTE	  0E0H,00000000B+OPB1+007H
	 BYTE	  0F0H,00000000B+OPB1+007H
;
	 BYTE	  000H,10000000B+OPB1+007H
	 BYTE	  00DH,00000010B				     ; 2
	 BYTE	  010H,00000000B+OPB1+007H
	 BYTE	  020H,00000000B+OPB1+007H
	 BYTE	  030H,00000000B+OPB1+007H
	 BYTE	  040H,00000000B+OPB1+007H
	 BYTE	  050H,00000000B+OPB1+007H
	 BYTE	  060H,00000000B+OPB1+007H
	 BYTE	  070H,00000000B+OPB1+007H
	 BYTE	  080H,00000000B+OPB1+007H
	 BYTE	  090H,00000000B+OPB1+007H
	 BYTE	  0A0H,00000000B+OPB1+007H
	 BYTE	  0B0H,00000000B+OPB1+007H
	 BYTE	  0C0H,00000000B+OPB1+007H
	 BYTE	  0D0H,00000000B+OPB1+007H
	 BYTE	  0E0H,00000000B+OPB1+007H
	 BYTE	  0F0H,00000000B+OPB1+007H
	 BYTE	  0FEH,00000100B
;
	 BYTE	  007H,10000000B+OCO0+00FH			     ; 3
	 BYTE	  000H,00000000B+OPB1+003H
	 BYTE	  010H,00000000B+OPB1+003H
	 BYTE	  020H,00000000B+OPB1+003H
	 BYTE	  030H,00000000B+OPB1+003H
	 BYTE	  040H,00000000B+OPB1+003H
	 BYTE	  050H,00000000B+OPB1+003H
	 BYTE	  060H,00000000B+OPB1+003H
	 BYTE	  070H,00000000B+OPB1+003H
	 BYTE	  080H,00000000B+OPB1+003H
	 BYTE	  090H,00000000B+OPB1+003H
	 BYTE	  0A0H,00000000B+OPB1+003H
	 BYTE	  0B0H,00000000B+OPB1+003H
	 BYTE	  0C0H,00000000B+OPB1+003H
	 BYTE	  0CEH,00000000B+000H+000H
	BYTE	0CFH,0B0H+000H,00000000B+OCTL
;
	 BYTE	  00DH,00000101B				     ; 5
	 BYTE	  08DH,00000000B+SCOF+000H			     ;
;
	 BYTE	  0FDH
;
;
;
;
;#####################################################################
;#	 Fix obstacle out pos data  ( Ground )			     #
;#####################################################################
FXOD34	 EQU	  $	    ;< Ground - 12 >		    / W 9 - 1 /
;
;						   9W - 1
	BYTE	 01010000B,00110001B
	 BYTE	  000H,00000000B+OBK1+009H
;;	   BYTE	    01010000B,00000010B
	 BYTE	  09FH,0F0H+008H,00000000B+OST0,0EEH,00000001B		 ; 0
;
	 BYTE	  012H,10000000B+OBK1+009H,077H,00000000B+OCM0+003H ; 1
;;;	    BYTE     0DEH,00001111B
;
	 BYTE	  0E0H,00000000B+OPB1+00AH
	 BYTE	  0F0H,00000000B+OPB1+00AH
;
	 BYTE	  000H,00000000B+OPB1+00AH
	 BYTE	  06DH,10000000B+SCOF+000H
;
	 BYTE	  0FDH
;
;
;
;
FXOD35	 EQU	  $	    ;< Ground - 14 >		    / W 9 - 2 /
;
	 BYTE	  0FDH
;
FXOD36	 EQU	  $	    ;< Ground - 16 >		    / W 9 - 3 /
;
	 BYTE	  0FDH
;
;
;
;
;#####################################################################
;#	 Fix obstacle out pos data  ( Underwater )		     #
;#####################################################################
FXOD55	 EQU	  $ ;					    / W 9 - 1 /
;
;
	 BYTE	  00000000B,10100001B			    ;9W - 1  no2
;
	 BYTE	  00AH,00000000B+OPB1+000H,019H,00000000B+OPB1+001H  ; 0
	 BYTE	  028H,00000000B+OPB1+002H
	 BYTE	  039H,00000000B+OCM2+001H
	 BYTE	  058H,00000000B+OPB1+002H,069H,00000000B+OPB1+001H
	 BYTE	  07AH,00000000B+OPB1+000H
;
	 BYTE	  07CH,10000000B+OBC2+005H,0A5H,00000000B+OGN0+001H  ; 1
	 BYTE	  0FEH,00100000B
;
	 BYTE	  01FH,0F0H+000H,10000000B+OEW0				  ; 2
	 BYTE	  05EH,00100001B
	 BYTE	  080H,00000000B+OBK1+00FH
	 BYTE	  08FH,0F0H+005H,00000000B+FCM1,0D6H,00000000B+OCM2+004H
;
	 BYTE	  05EH,10100000B
	 BYTE	  06FH,0F0H+006H,00000000B+FCM1				  ; 3
	 BYTE	  09EH,00100001B
	 BYTE	  0C3H,00000000B+OBK1+007H
;
	 BYTE	  047H,10000000B+OCM2+003H			     ; 4
	 BYTE	  09EH,00100000B
	 BYTE	  0FEH,00100001B
;
	 BYTE	  00DH,00000110B				     ; 6
	 BYTE	  057H,00000000B+OBK1+002H,064H,00000000B+OGN0+001H
	 BYTE	  066H,00000000B+OGN0+000H
;
	 BYTE	  083H,10000000B+OBK0+007H,087H,00000000B+OBK0+007H  ; 7
;
	 BYTE	  00DH,00001001B				     ; 9
	 BYTE	  01DH,00000000B+EXOF
	 BYTE	  05FH,0F0H+008H,00000000B+OST0
;
	 BYTE	  06DH,10000000B+OPL0+000H,0AFH,0F0H+006H,00000000B+OCS0  ; A
;
	 BYTE	  06DH,10000000B+SCOF+000H			     ; B
;
	 BYTE	  0FDH
;
;
;#####################################################################
;#	 Fix obstacle out pos data  ( Underwater )		     #
;#####################################################################
FXOD56	 EQU	  $					   ;/ W 9 - 2 /
;
;						 9W - 2
	 BYTE	  01010000B,00010001B
;
	 BYTE	  000H,00000000B+OBK1+00FH
	 BYTE	  0D7H,00000000B+OCM2+003H			     ; 0
	 BYTE	  0FEH,00011010B
;
	 BYTE	  000H,10000000B+OBK1+00FH
	 BYTE	  06FH,0F0H+002H,00000000B+FCM1				  ; 1
;
	 BYTE	  000H,10000000B+OBK1+00FH
	 BYTE	  01FH,0F0H+005H,00000000B+FCM1,0BFH,0F0H+003H,00000000B+FCM1  ; 2
;
	 BYTE	  000H,10000000B+OBK1+00FH
	 BYTE	  0C7H,00000000B+OBK0+008H,0DFH,0F0H+001H,00000000B+FCM1  ; 3
;
	 BYTE	  000H,10000000B+OBK1+00FH
	 BYTE	  015H,00000000B+OCM2+001H,07FH,0F0H+002H,00000000B+FCM1  ; 4
	 BYTE	  09BH,00000000B+OBK0+00FH,0A8H,00000000B+OCM2+002H
	 BYTE	  0FEH,00010000B
;
	 BYTE	  069H,10000000B+OCM2+001H,0B7H,00000000B+OBK0+005H  ; 5
	 BYTE	  0C5H,00000000B+OCM2+001H
;
	 BYTE	  033H,10000000B+OBK0+00CH,05FH,0F0H+001H,00000000B+FCM2  ; 6
	 BYTE	  08DH,00000000B+EXOF+000H
	 BYTE	  0AAH,00000000B+OLD0+004H,0D1H,00000000B+OCM2+001H
;
	 BYTE	  017H,10000000B+OLD0+005H,026H,00000000B+OCO0+002H  ; 7
	 BYTE	  072H,00000000B+OCO0+002H,073H,00000000B+OLD0+002H
	 BYTE	  07AH,00000000B+OLD0+004H,0C6H,00000000B+OLD0+004H
	 BYTE	  0D5H,00000000B+OCO0+002H
	 BYTE	  0FEH,00010001B
;
	 BYTE	  07FH,0F0H+008H,10000000B+OST0				  ; 8
;
	 BYTE	  08DH,10000000B+OPL0+000H,0CFH,0F0H+006H,00000000B+OCS0  ; 9
;
	 BYTE	  06DH,10000000B+SCOF+000H
;
	 BYTE	  0FDH
;
;
;#####################################################################
;#	 Fix obstacle out pos data  ( Underwater )		     #
;#####################################################################
FXOD57	 EQU	  $					   ;/ W 9 - 4 /
;
;						9W - 4	 (WATER)
	 BYTE	  01010111B,00000000B
;
	 BYTE	  00BH,00000000B+OBK1+00FH			     ; 0
;
	 BYTE	  00BH,10000000B+OBK1+00FH			     ; 1
;
	 BYTE	  00BH,10000000B+OBK1+00FH			     ; 2  A
	 BYTE	  073H,00000000B+OBK1+006H,09AH,00000000B+OBK1+000H
	 BYTE	  0A5H,00000000B+OPB1+004H,0B6H,00000000B+OBK1+001H
	 BYTE	  0D4H,00000000B+OPB1+001H
;
	 BYTE	  00BH,10000000B+OBK1+00FH			     ; 3  RI
	 BYTE	  013H,00000000B+OPB1+003H,04AH,00000000B+OPB1+000H
	 BYTE	  053H,00000000B+OPB1+006H
;
	 BYTE	  0A5H,00000000B+OBK1+004H,0B3H,00000000B+OPB1+007H  ;	  GA
	 BYTE	  0E5H,00000000B+OPB1+005H,0F4H,00000000B+OPB1+000H
;
	 BYTE	  00BH,10000000B+OBK1+00FH			     ; 4
	 BYTE	  014H,00000000B+OPB1+000H			     ;
	 BYTE	  053H,00000000B+OPB1+007H,067H,00000000B+OBK1+002H  ;	  TO
;
	 BYTE	  0C4H,00000000B+OPB1+002H,0D4H,00000000B+OBK1+001H  ;	  U
	 BYTE	  0F3H,00000000B+OPB1+001H,0FAH,00000000B+OPB1+000H
;
	 BYTE	  00BH,10000000B+OBK1+00FH			     ; 5
	 BYTE	  004H,00000000B+OBK1+000H,009H,00000000B+OPB1+001H
	 BYTE	  014H,00000000B+OPB1+005H
;
	 BYTE	  063H,00000000B+OPB1+005H,06AH,00000000B+OPB1+000H  ;	   !
;
	 BYTE	  00BH,10000000B+OBK1+00FH
	 BYTE	  00FH,0F0H+008H,00000000B+OST0				  ; 6
;
	 BYTE	  00BH,10000000B+OBK1+00FH
	 BYTE	  01DH,00000000B+OPL0+000H			     ; 7
	 BYTE	  03EH,01000010B
	 BYTE	  03FH,0F0H+000H,00000000B+OCS0
;;K;;	      BYTE     0CEH,01000000B
;
	 BYTE	  00BH,10000000B+OBK1+00FH
	 BYTE	  03DH,00000000B+SCOF+000H			     ; 8
;
	 BYTE	  0FDH
;
;#####################################################################
;#	 Fix chara out pos data	 ( Castle )			     #
;#####################################################################
FXED00	 EQU	  $	    ;< Castle - 00 >		    / W A - 4 /
	 BYTE	  02AH,10000000B+SST3,06BH,00000000B+JPTR	     : 1
	 BYTE	  08DH,00000000B+SST1,0EAH,00000000B+SST4
;
	 BYTE	  01BH,10000000B+JPTR,0E6H,00000000B+SST1	     : 2
;
	 BYTE	  08CH,10000000B+SST1,0BBH,00000000B+JPTR	     : 3
;
	 BYTE	  0F3H,10000000B+TUTR				     : 4
;
	 BYTE	  09BH,10000000B+JPTR,0DBH,00000000B+JPTR	     : 5
;
	 BYTE	  01BH,10000000B+JPTR,06BH,00000000B+JPTR	     : 6
	 BYTE	  0BBH,00000000B+JPTR
;
	 BYTE	  00FH,009H					     : 9
	 BYTE	  040H,00000000B+BKF0
;
	 BYTE	  078H,10000000B+BKM0				     : A
;
	 BYTE	  090H,10000000B+GIAL				     : B
;
	 BYTE	  0FFH
;
;
FXED01	 EQU	  $	    ;< Castle - 01 >		    / W B - 4 /
;
	 BYTE	  00FH,002H
	 BYTE	  038H,00000000B+SST2,0D9H,00000000B+SST0	     : 2
;
	 BYTE	  06EH,11101011B,00100001B  ;NEXT GOTO Castle-01     : 3
;
	 BYTE	  03AH,10000000B+LFT4				     : 4
;
	 BYTE	  018H,10000000B+SST2				     : 5
;
	 BYTE	  00FH,007H
	 BYTE	  018H,00000000B+SST2				     : 7
;
	 BYTE	  00FH,009H
	 BYTE	  018H,00000000B+SST2				     : 9
;
	 BYTE	  00FH,00BH
	 BYTE	  018H,00000000B+SST2				     : B
	 BYTE	  07BH,00000000B+BKF0
	 BYTE	  08EH,00100001B,00101110B  ;NEXT GOTO Ground-01 (Warp-D)
;
	 BYTE	  0B9H,10000000B+SST2				     : C
;
	 BYTE	  00FH,00EH
	 BYTE	  078H,00000000B+BKM0				     : E
;
	 BYTE	  090H,10000000B+GIAL				     : F
;
	 BYTE	  0FFH
;
;
FXED02	 EQU	  $	    ;< Castle - 02 >		    / W C - 4 /
;
	 BYTE	  005H,10000000B+SST2				     : 1
	 BYTE	  065H,00000000B+SST2
;
	 BYTE	  00DH,10000000B+LFT4				     : 2
	 BYTE	  0DDH,00000000B+SST2
;
	 BYTE	  007H,10000000B+ELV1,054H,00000000B+ELV1	     : 3
	 BYTE	  0A2H,00000000B+ELV1
	 BYTE	  0F4H,00000000B+ELV1
;
	 BYTE	  042H,10000000B+ELV1				     : 4
;
	 BYTE	  026H,10000000B+SST2				     : 5
	 BYTE	  0D4H,00000000B+TUTR
;
	 BYTE	  024H,10000000B+TUTR				     : 6
	 BYTE	  064H,00000000B+TUTR
;
	 BYTE	  02BH,10000000B+BKTR,04BH,00000000B+BKTR	     : 7
	 BYTE	  07BH,00000000B+BKTR,09BH,00000000B+BKTR
;
	 BYTE	  05BH,10000000B+BKTR,07BH,00000000B+BKTR	     : 8
;
	 BYTE	  00BH,10000000B+BKTR				     : 9
	 BYTE	  02BH,00000000B+BKTR
	 BYTE	  0C6H,00000000B+SST0
;
	 BYTE	  028H,10000000B+BKTR,048H,00000000B+BKTR	     : A
	 BYTE	  0A6H,00000000B+SST0
;
	 BYTE	  07BH,10000000B+BKF0				     : B
	 BYTE	  085H,00000000B+JPTR
;
	 BYTE	  09DH,10000000B+SST0				     : C
;
	 BYTE	  00FH,00EH					     : E
	 BYTE	  078H,00000000B+BKM0
	 BYTE	  07AH,00000000B+SST2
;
	 BYTE	  090H,10000000B+GIAL				     : F
;
	 BYTE	  0FFH
;
;
FXED03	 EQU	  $	    ;< Castle - 03 >		    / W D - 4 /
	 BYTE	  019H,10000000B+SST4,099H,00000000B+SST0	     : 1
;
	 BYTE	  02CH,10000000B+JPTR,059H,00000000B+SST0	     : 2
	 BYTE	  0C5H,00000000B+FTR6
;
	 BYTE	  00FH,004H
	 BYTE	  009H,00000000B+LFT5,0BDH,00000000B+SST2	     : 4
;
	 BYTE	  00FH,006H
	 BYTE	  06EH,00101010B,01100001B  ;NEXT GOTO Ground-10     : 6
;
	 BYTE	  00FH,009H
	 BYTE	  048H,00000000B+BKM0				     : 9
;
	 BYTE	  046H,10000000B+IKTR,079H,00000000B+IKTR	     : A
	 BYTE	  08EH,01101101B,01100000B  ;NEXT GOTO Castle-3
	 BYTE	  0A5H,00000000B+IKTR
;
	 BYTE	  0B8H,10000000B+FIEN				     : B
;
	 BYTE	  057H,10000000B+LFT1				     : C
;
	 BYTE	  08CH,10000000B+JPTR				     : D
;
	 BYTE	  076H,10000000B+SST2				     : E
	 BYTE	  078H,00000000B+BKM0
;
	 BYTE	  0D0H,10000000B+GIAL				     : F
;
	 BYTE	  0FFH
;
;
;#####################################################################
;#	 Fix chara out pos data	 ( Ground )			     #
;#####################################################################
FXED10	 EQU	  $	    ;< Ground - 00 >	*61.05.26   / W A - 1 /
;
	 BYTE	  007H,10000000B+TUTR,037H,00000000B+TUTR	     : 1
	 BYTE	  06BH,00000000B+FTR2
	 BYTE	  0E0H,00000000B+GRP6
;
	 BYTE	  020H,10000000B+GRP7				     : 2
	 BYTE	  06EH,00101011B,00000000B  ;NEXT GOTO Ground-11 (SKY)
;
	 BYTE	  0A7H,10000000B+FIEN,0D3H,00000000B+FIEN	     : 3
;
	 BYTE	  0E7H,10000000B+TUTR				     : 4
;
	 BYTE	  024H,10000000B+TUTR,027H,00000000B+TUTR	     : 5
	 BYTE	  049H,00000000B+SHTR,059H,00000000B+SHTR
;
	 BYTE	  010H,10000000B+GRP4,0B0H,00000000B+GRP4	     : 6
;
	 BYTE	  06EH,11000110B,00000000B  ;NEXT GOTO Underground-01 (Bonus-1) : 7
;
	 BYTE	  017H,10000000B+FIEN,053H,00000000B+FIEN	     : 8
;
	 BYTE	  036H,10000000B+FTR2,076H,00000000B+FTR2	     : 9
	 BYTE	  0B6H,00000000B+FTR2
;
	 BYTE	  0E7H,10000000B+TUTR				     : A
;
	 BYTE	  063H,10000000B+TUTR,068H,00000000B+TUTR	     : B
;
	 BYTE	  029H,10000000B+TUTR,057H,00000000B+TUTR	     : C
	 BYTE	  085H,00000000B+TUTR
	 BYTE	  0B5H,00000000B+LFT5
;
	 BYTE	  0FFH
;
;
;
FXED11	 EQU	  $	    ;< Ground - 01 >  (ASURETIC)    / W A - 3 /
;							  *61.05.26
	 BYTE	  00FH,004H					 : 4
	 BYTE	  066H,00000000B+IKTR
;
	 BYTE	  00FH,006H					 : 6
	 BYTE	  086H,00000000B+FTR7
;
	 BYTE	  00FH,008H					 : 8
	 BYTE	  055H,00000000B+FTR6
;
	 BYTE	  0E5H,10000000B+FTR6				 : 9
;
	 BYTE	  0FFH
;
;
FXED12	 EQU	  $	    ;< Ground - 02 >		    / W B - 1 /
	 BYTE	  070H,10000000B+GRP0,0CAH,00000000B+SHTR	     : 1
;
	 BYTE	  066H,10000000B+SHTR				     : 2
;
	 BYTE	  00FH,004H
	 BYTE	  079H,00000000B+FTR2,0ABH,00000000B+FTR2	     : 4
;
	 BYTE	  0EEH,00101011B,00100000B  ;NEXT GOTO Ground-11 (SKY)
;
	 BYTE	  0EBH,10000000B+SHTR				     : 5
;
	 BYTE	  040H,10000000B+GRP4,0FBH,00000000B+SHTR	     : 6
;
	 BYTE	  040H,10000000B+GRP0,0CBH,00000000B+FTR2	     : 7
;
	 BYTE	  00FH,009H
	 BYTE	  04BH,00000000B+SHTR,076H,00000000B+SHTR	     : 9
	 BYTE	  0D8H,00000000B+SHTR
;
	 BYTE	  06BH,10000000B+FTR2,073H,00000000B+YPVS	     : A
	 BYTE	  083H,00000000B+YPVS,0C7H,00000000B+FTR2
;
	 BYTE	  036H,10000000B+FTR7,0C5H,00000000B+YPVS	     : B
;
	 BYTE	  0FFH
;
;
FXED13	 EQU	  $	    ;< Ground - 03 >		    / W B - 3 /
;
	 BYTE	  084H,10000000B+FTR6,0A7H,00000000B+LFT0	     : 1
	 BYTE	  0D3H,00000000B+FTR6,0EAH,00000000B+LFT0
;
	 BYTE	  045H,10000000B+LFT5,0D5H,00000000B+LFT4	     : 2
;
	 BYTE	  045H,10000000B+LFT5,084H,00000000B+LFT1	     : 3
;
	 BYTE	  0B4H,10000000B+FTR6				     : 4
;
	 BYTE	  009H,10000000B+FTR7				     : 5
;
	 BYTE	  0B5H,10000000B+LFT4				     : 6
;
	 BYTE	  05BH,10000000B+TMK0				     : 7
	 BYTE	  0CDH,00000000B+LFT4				     : 7
;
	 BYTE	  0B5H,10000000B+LFT0				     : 8
;
	 BYTE	  009H,10000000B+LFT0,065H,00000000B+LFT4	     : 9
;
	 BYTE	  092H,10000000B+FTR7				     : A
;
	 BYTE	  0E3H,10000000B+TUTR				     : B
;
	 BYTE	  0FFH
;
;
FXED14	 EQU	  $	    ;< Ground - 04 >		    / W C - 1 /
;
	 BYTE	  03AH,10000000B+FTR2,05BH,00000000B+FTR2	     : 1
;
	 BYTE	  0C3H,10000000B+FTR2				     : 2
;
	 BYTE	  0CAH,10000000B+FTR2				     : 3
;
	 BYTE	  00BH,10000000B+FTR2,04AH,00000000B+FTR2	     : 4
;
	 BYTE	  0DEH,11000110B,01000100B  ;NEXT GOTO Underground-1 (Bonus-3) : 5
;
	 BYTE	  00FH,008H
	 BYTE	  049H,00000000B+FTR2,0EBH,00000000B+FTR2	     : 8
;
	 BYTE	  08AH,10000000B+FTR7				     : 9
;
	 BYTE	  0ABH,10000000B+FIEN				     : A
;
	 BYTE	  00FH,00CH
	 BYTE	  003H,00000000B+FTR6				     : C
	 BYTE	  02EH,00101011B,01000000B  ;NEXT GOTO Ground-11(SKY)
;
	 BYTE	  067H,10000000B+YPVS				     : D
;
	 BYTE	  0FFH
;
;
FXED15	 EQU	  $	    ;< Ground - 05 >		    / W C - 2 /
;
	 BYTE	  015H,10000000B+FTR6,054H,00000000B+IKTR	     : 1
;
	 BYTE	  0AAH,10000000B+TUTR,0F8H,00000000B+IKTR	     : 2
;
	 BYTE	  00FH,004H
	 BYTE	  014H,00000000B+IKTR,096H,00000000B+FTR7	     : 4
;
	 BYTE	  00FH,007H
	 BYTE	  095H,00000000B+FTR6				     : 7
;
	 BYTE	  09DH,10000000B+LFT4				     : 8
;
	 BYTE	  00BH,10000000B+TMK0				     : 9
;
	 BYTE	  009H,10000000B+LFT5,055H,00000000B+LFT0	     : A
	 BYTE	  0A9H,00000000B+LFT0,0BBH,00000000B+TMK0
;
;	 BYTE	  00FH,007H
;	 BYTE	  06BH,00000000B+TMK0				     : 7
;	 BYTE	  095H,00000000B+FTR6
;
;	 BYTE	  09DH,10000000B+LFT4				     : 8
;
;	 BYTE	  00FH,00AH
;;	 BYTE	  009H,00000000B+LFT5,055H,00000000B+LFT0	     : A
;	 BYTE	  0A9H,00000000B+LFT0
;
	 BYTE	  0FFH
;
;
FXED16	 EQU	  $	    ;< Ground - 06 >		    / W C - 3 /
;
	 BYTE	  00FH,003H
	 BYTE	  0A6H,00000000B+ESHP				     : 3
;
	 BYTE	  0A3H,10000000B+FTR7				     : 4
;
	 BYTE	  0A6H,10000000B+ESHP				     : 5
;
	 BYTE	  00FH,008H
	 BYTE	  0A6H,00000000B+ESHP				     : 8
;
	 BYTE	  0E3H,10000000B+LFT5				     : 9
;
	 BYTE	  00FH,00DH
	 BYTE	  055H,00000000B+LFT0,0A9H,00000000B+LFT0	     : D
;
	 BYTE	  00FH,011H
	 BYTE	  059H,00000000B+SST2,0A9H,00000000B+SST0	     :11
;
	 BYTE	  023H,10000000B+FTR6				     :12
;
	 BYTE	  015H,10000000B+SST0				     :13
;
	 BYTE	  0FFH
;
;
FXED17	 EQU	  $	    ;< Ground - 07 >		    / W D - 1 /
;
	 BYTE	  087H,10000000B+FIEN,09BH,00000000B+FIEN	     : 1
;
	 BYTE	  018H,10000000B+FTR7				     : 2
;
	 BYTE	  0A4H,10000000B+FTR6				     : 3
;
	 BYTE	  06EH,11000110B,01100000B  ;NEXT GOTO Underground-1 (Bonus-1)
	 BYTE	  09BH,00000000B+BKTR,0D0H,00000000B+GRP4	     : 4
;
	 BYTE	  080H,10000000B+GRP1				     : 5
;
	 BYTE	  003H,10000000B+FTR2,01BH,00000000B+BKTR	     : 6
	 BYTE	  03BH,00000000B+BKTR
;
	 BYTE	  00FH,008H
	 BYTE	  003H,00000000B+FTR7,0F7H,00000000B+FIEN	     : 8
;
	 BYTE	  06BH,10000000B+FIEN				     : 9
;
	 BYTE	  0FFH
;
;
FXED18	 EQU	  $	    ;< Ground - 08 >		    / W D - 2 /
;
	 BYTE	  0DBH,10000000B+BKTR,0F3H,00000000B+TUTR	     : 1
;
	 BYTE	  010H,10000000B+GRP0,080H,00000000B+GRP0	     : 2
;
	 BYTE	  01AH,10000000B+FTR2,04BH,00000000B+FTR2	     : 3
	 BYTE	  07AH,00000000B+FTR2,0ABH,00000000B+FTR2
;
	 BYTE	  00FH,005H
	 BYTE	  0F9H,00000000B+FTR2				     : 5
;
	 BYTE	  0D0H,10000000B+GRP7				     : 6
;
	 BYTE	  02EH,11000110B,01100010B  ;NEXT GOTO Underground-1 (Bonus-2) : 7
;
	 BYTE	  0D4H,10000000B+FTR6				     : 8
;
	 BYTE	  064H,10000000B+FTR6				     : 9
	 BYTE	  07EH,00101011B,01100000B  ;NEXT GOTO Ground-11 (SKY)
;
	 BYTE	  0FFH
;
;
FXED19	 EQU	  $	    ;< Ground - 09 >		    / W D - 3 /
;
	 BYTE	  00FH,003H				    : 3
	 BYTE	  0ABH,00000000B+FIEN
;
	 BYTE	  01BH,10000000B+FIEN			    : 4
;
	 BYTE	  0A3H,10000000B+FIEN,0D7H,00000000B+FIEN   : 5
;
	 BYTE	  00FH,008H
	 BYTE	  033H,00000000B+TUTR			    : 8
;
	 BYTE	  00BH,10000000B+FIEN			    : 9
;
	 BYTE	  0FBH,10000000B+FIEN			    : A
;
	 BYTE	  08BH,10000000B+FIEN			    : B
;
	 BYTE	  03AH,10000000B+FTR2			    : C
;
	 BYTE	  0FFH
;
;
FXED20	 EQU	  $	    ;< Ground - 10 >		    / W D - 4 /
	 BYTE	  00FH,002H
	 BYTE	  009H,00000000B+FIEN				     : 2
	 BYTE	  03EH,01000110B,01100100B  ;NEXT GOTO Castle-03
;
	 BYTE	  02BH,10000000B+FTR2,058H,00000000B+FTR2	     : 3
	 BYTE	  0CAH,00000000B+IKTR
;
	 BYTE	  034H,10000000B+IKTR				     : 4
;
	 BYTE	  0FFH
;
;
FXED21	 EQU	  $	    ;< Ground - 11 >		    ;<BONUS - SKY>
	 BYTE	  00AH,10000000B+LFT6				     : 1
	 BYTE	  01EH,00100000B,00000011B  ;NEXT GOTO BACK Ground-00(WA-1)
	 BYTE	  01EH,00100010B,00100111B  ;NEXT GOTO BACK Ground-02(WB-1)
	 BYTE	  02EH,00100100B,01001000B  ;NEXT GOTO BACK Ground-04(WC-1)
	 BYTE	  02EH,00101000B,01100111B  ;NEXT GOTO BACK Ground-08(WD-2)
;
	 BYTE	  0FFH
;
;
;#####################################################################
;#	 Fix chara out pos data	 ( Underground )		     #
;#####################################################################
FXED40	 EQU	  $	    ;< Underground - 0 >	    / W A - 2 /
;						 *61.05.26
	 BYTE	  0BBH,10000000B+LFT5			     : 1
;
	 BYTE	  01BH,10000000B+LFT5,069H,00000000B+LFT5    : 2
	 BYTE	  0B8H,00000000B+LFT5
;
	 BYTE	  059H,10000000B+LFT5			     : 3
;
	 BYTE	  08DH,10000000B+LFT4			     : 4
;
	 BYTE	  00FH,007H				     : 7
	 BYTE	  015H,00000000B+LFT5
;
	 BYTE	  055H,10000000B+ELV1			     : 8
;
	 BYTE	  06BH,10000000B+FIEN			     : 9
;
	 BYTE	  00EH,10111110B,00000001B  ;NEXT GOTO BACK Ground-37(Ret):A
	 BYTE	  067H,00000000B+NOT1
;
	 BYTE	  0FFH
;
;
FXED41	 EQU	  $	    ;< Underground - 1 >	    ;<BONUS>
;
; (UNDERGROUND-1) ;0
	 BYTE	  01EH,10100000B,00001001B  ;NEXT GOTO BACK Ground-00(WA-1)
	 BYTE	  01EH,00100111B,01100111B  ;NEXT GOTO BACK Ground-07(WD-1)
;
; (UNDERGROUND-2) ;2
	 BYTE	  00FH,003H
	 BYTE	  01EH,00101000B,01101000B  ;NEXT GOTO BACK Ground-08(WD-2)
;
; (UNDERGROUND-3) ;4
	 BYTE	  00FH,005H
	 BYTE	  01EH,00100100B,01001000B  ;NEXT GOTO BACK Ground-04(WC-1)
	 BYTE	  01EH,01101101B,01101000B  ;NEXT GOTO BACK Caslte-03(WD-4)
;
	 BYTE	  0FFH
;
;
;#####################################################################
;#	 Fix chara out pos data	 ( Underwater )			     #
;#####################################################################
FXED50	 EQU	  $	    ;< Underwater - 0 >		    / W B - 2 /
;
	 BYTE	  0EEH,10111110B,00100001B  ;NEXT GOTO BACK Ground-37(Ret):1
;
	 BYTE	  026H,10000000B+IKTR,0F3H,00000000B+FTR2	     : 2
;
	 BYTE	  066H,10000000B+IKTR,0CBH,00000000B+SHTR	     : 3
;
	 BYTE	  065H,10000000B+IKTR				     : 4
;
	 BYTE	  00FH,006H
	 BYTE	  006H,00000000B+FTR2				     : 6
	 BYTE	  097H,00000000B+IKTR,0CBH,00000000B+SHTR
;
	 BYTE	  075H,10000000B+IKTR				     : 7
	 BYTE	  0D3H,00000000B+LFT3,0D9H,00000000B+LFT3
;
	 BYTE	  00FH,009H
	 BYTE	  077H,00000000B+SST4				     : 9
;
	 BYTE	  046H,10000000B+IKTR,0B1H,00000000B+FTR6	     : A
;
	 BYTE	  0FFH
;
;
;
;############################################################################################
;#	 Fix obstacle out position data							    #
;############################################################################################
;
;		 +------+------+  +------+------+
;	 FXBDxx	 I x xxx xxxxx I  I  xxx  xxxxx I
;	     ^^	 +------+------+  +------+------+
;	     ||	   ^  ^	   ^	      ^	    ^
;	     ||	   |  |	   |	      |	    |
;	     ||	   |  |	   |	      |	    |
;	     ||	   |  |	   |	      |	    |
;	     ||	   |  |	   |	      |	    +---  Floor display max loop
;	     ||	   |  |	   |	      +--------- Player start position data index
;	     ||	   |  |	   |
;	     ||	   |  |	   +------  Base BG environmen
;	     ||	   |  +-----------  Play farst base time
;	     ||	   +--------------  0:ON Floor	      1:OFF Floor
;	     ||
;	     ||	 +------+------+------+------+-----+-----+
;	     ||	 I x x	xxxxxx I xxxx | xxxx I xxxx|xxxx I
;	     ||	 +------+------+------+------+-----+-----+
;	     ||	   ^ ^	   ^	   ^	  ^	 ^    ^
;	     ||	   | |	   |	   |	  |	 |    |
;	     ||	   | |	   |	   |	  |	 |    +----  Obstacle display count
;	     ||	   | |	   |	   |	  |	 +---------  Obstacle kind No.
;	     ||	   | |	   |	   |	  +-  (y)pos-L	     F:BG environment change mode
;	     ||	   | |	   |	   +--------  (x)pos-L
;	     ||	   | |	   |
;	     ||	   | |	   +------  (x)pos-H  ( FF : End crode )
;	     ||	   | +------------  0:Floot length 1:Fix length
;	     ||	   |
;	     ||	   +--------  00:Out  11:No out
;	     ||
;	     |+---  Kind corde
;	     +----  0:Underwater 1:Ground  2:Underground  3:Castle
;
;#####################################################################
;#	 Fix obstacle out pos data  ( Castle )			     #
;#####################################################################
FXBD00	 EQU	  $	    ;< Castle - 00 >		    / W A - 4 /
	 BYTE	  10011011B,10000111B
;
	BYTE	00FH,050H+002H,00000000B+OKID				; 0
	BYTE	00FH,060H+003H,00000000B+OKID
	BYTE	00FH,070H+004H,00000000B+OKID
	 BYTE	  0EEH,00001010B
	BYTE	0EFH,010H+000H,00000000B+ONBK
	BYTE	0EFH,080H+000H,00000000B+OCTL
;
	 BYTE	  00EH,10000110B				     : 1
	BYTE	01FH,080H+000H,00000000B+OCTR
	 BYTE	  028H,00000000B+OSP0+000H
	BYTE	03FH,080H+000H,00000000B+OCTL
	 BYTE	  03EH,00001010B
	 BYTE	  06EH,00000010B
	BYTE	07FH,0B0H+000H,00000000B+OCTR
	 BYTE	  08BH,00000000B+OSP0+000H,097H,00000000B+OBMS+000H
	BYTE	09FH,0B0H+000H,00000000B+OCTL
	 BYTE	  09EH,00001010B
	 BYTE	  0CEH,00000110B
	BYTE	0DFH,080H+000H,00000000B+OCTR
	 BYTE	  0E8H,00000000B+OSP0+000H
	BYTE	0FFH,080H+000H,00000000B+OCTL
	 BYTE	  0FEH,00001010B
;
	 BYTE	  02EH,10000110B				     : 2
	BYTE	03FH,080H+000H,00000000B+OCTR
	BYTE	06FH,080H+000H,00000000B+OCTL
	 BYTE	  06EH,00001010B
	 BYTE	  08EH,00001000B
	BYTE	09FH,010H+000H,00000000B+ONBK
	BYTE	09FH,080H+000H,00000000B+OCTR
	 BYTE	  0E4H,00000000B+OSP0+000H
;
	 BYTE	  01EH,10000010B				     : 3
	BYTE	01FH,020H+000H,00000000B+ONBK
	BYTE	01FH,0A0H+001H,00000000B+OCLC
	BYTE	01FH,080H+000H,00000000B+OCTL
	 BYTE	  08AH,00000000B+OSP0+000H
	BYTE	08FH,0B0H+000H,00000000B+OCTL
	 BYTE	  08EH,00001010B
	 BYTE	  0FEH,00000010B
;
	BYTE	00FH,0B0H+000H,10000000B+OCTR
	 BYTE	  01AH,00000000B+OPB1+000H
	BYTE	02FH,0A0H+001H,00000000B+OCRC,029H,00000000B+OPB1+001H	: 4
	 BYTE	  02EH,00000110B
	BYTE	03FH,080H+000H,00000000B+OCTR
	 BYTE	  047H,00000000B+OPB1+000H
	 BYTE	  056H,00000000B+OPB1+001H
	BYTE	06FH,070H+001H,00000000B+OCRC
	 BYTE	  065H,00000000B+OPB1+002H
	 BYTE	  06EH,00001100B
	BYTE	07FH,040H+000H,00000000B+OCTR
	 BYTE	  083H,00000000B+OPB1+000H
;
	 BYTE	  07EH,10001010B				     : 5
	BYTE	07FH,040H+000H,00000000B+OCTL
	 BYTE	  0BBH,00000000B+OPB1+001H,0F9H,00000000B+OPB1+003H
;
	 BYTE	  027H,10000000B+OPB1+005H,088H,00000000B+OPB1+004H  : 6
	 BYTE	  0EBH,00000000B+OPB1+001H
	 BYTE	  0FEH,00000101B
;
	BYTE	00FH,020H+000H,10000000B+ONBK
	BYTE	00FH,0B0H+000H,00000000B+OCTR
	 BYTE	  068H,00000000B+OGN0+000H			     : 7
;
	 BYTE	  00AH,10000000B+OGN0+000H			     : 8
	BYTE	0FFH,020H+000H,00000000B+ONBK
	 BYTE	  0FEH,00000010B
;
	 BYTE	  03AH,10000000B+OGN0+000H			     : 9
	BYTE	03FH,0B0H+000H,00000000B+OCTL
	 BYTE	  03EH,00001010B
	 BYTE	  0AEH,00000010B
	BYTE	0BFH,0B0H+000H,00000000B+OCTR
	 BYTE	  0DAH,00000000B+OPB1+000H,0E9H,00000000B+OPB1+001H
	 BYTE	  0F8H,00000000B+OPB1+002H
	BYTE	0FFH,0B0H+000H,00000000B+OCTL
	 BYTE	  0FEH,00001010B
;
	 BYTE	  00DH,10000000B+000H+OSL0,0A1H,00000000B+OPB1+002H  : A
	 BYTE	  0B1H,00000000B+OPB1+002H,0CDH,00000000B+000H+OCH0
	 BYTE	  0CEH,00001001B
	 BYTE	  0DEH,00001011B
	 BYTE	  0DDH,00000000B+000H+OSK0
	BYTE	0DFH,070H+000H,00000000B+OCTR
	BYTE	0EFH,020H+000H,00000000B+ONBK
	BYTE	0FFH,0A0H+001H,00000000B+OCLC
	BYTE	0FFH,020H+000H,00000000B+ONBK
	BYTE	0FFH,070H+000H,00000000B+OCTL
	 BYTE	  0FEH,00000010B
;
	 BYTE	  05DH,10000000B+000H+SCOF			     : B
;
	 BYTE	  0FDH
;
;
FXBD01	 EQU	  $	    ;< Castle - 01 >		    / W B - 4 /
;
	 BYTE	  10011011B,00001001B
;
	BYTE	00FH,050H+002H,00000000B+OKID
	BYTE	00FH,060H+003H,00000000B+OKID
	BYTE	00FH,010H+001H,00000000B+OLBK
	BYTE	01FH,010H+001H,00000000B+OLBK
	BYTE	02FH,010H+001H,00000000B+OLBK
	BYTE	03FH,010H+001H,00000000B+OLBK
	 BYTE	  03EH,00001010B
	BYTE	03FH,070H+000H,00000000B+OCTL
	 BYTE	  041H,00000000B+OBK1+00BH,042H,00000000B+OBK1+00BH
	BYTE	04FH,010H+001H,00000000B+OLBK
	BYTE	05FH,010H+001H,00000000B+OLBK
	 BYTE	  058H,00000000B+OPB1+004H
	BYTE	06FH,010H+001H,00000000B+OLBK
	BYTE	07FH,010H+001H,00000000B+OLBK
	BYTE	07AH,00000000B+OPB1+002H
	BYTE	08FH,010H+001H,00000000B+OLBK
	BYTE	09FH,010H+001H,00000000B+OLBK
	BYTE	0AFH,010H+001H,00000000B+OLBK
	BYTE	0BFH,010H+001H,00000000B+OLBK
	BYTE	0CFH,010H+001H,00000000B+OLBK
	 BYTE	  0C8H,00000000B+OBK1+001H
	BYTE	0DFH,010H+001H,00000000B+OLBK
	BYTE	0EFH,010H+001H,00000000B+OLBK
	BYTE	0FFH,010H+001H,00000000B+OLBK
	BYTE	0FFH,020H+000H,00000000B+ONBK
;
	 BYTE	  018H,10000000B+OPB1+004H,039H,00000000B+OCM2+003H : 1
	 BYTE	  05EH,00001001B
	BYTE	05FH,070H+000H,00000000B+OCTR
	 BYTE	  066H,00000000B+OBK1+00CH
;
	 BYTE	  00EH,10000010B				    : 2
	BYTE	00FH,0A0H+001H,00000000B+OCLC
	BYTE	00FH,070H+000H,00000000B+OCTL
	 BYTE	  028H,00000000B+OBBM+000H,036H,00000000B+OSP0+000H
	BYTE	03FH,0B0H+000H,00000000B+OCTL
	 BYTE	  03EH,00001010B
	 BYTE	  0AEH,00000010B
	BYTE	0AFH,0B0H+000H,00000000B+OCTR
	 BYTE	  0D7H,00000000B+OSP0+000H
	BYTE	0EFH,0A0H+001H,00000000B+OCRC
	BYTE	0FFH,040H+000H,00000000B+OCTR
	 BYTE	  0FEH,00001100B
;
;;;	BYTE	0FFH,0A0H+001H,10000000B+OCLC
	BYTE	0FFH,040H+000H,10000000B+OCTL
	 BYTE	  0FEH,00001010B				    : 3
;
	 BYTE	  011H,10000000B+OPB1+005H,021H,00000000B+OPB1+005H : 4
	 BYTE	  031H,00000000B+OPB1+005H
	 BYTE	  04EH,00001100B
;;;	BYTE	04FH,0A0H+001H,00000000B+OCRC
	BYTE	05FH,040H+000H,00000000B+OCTR
	 BYTE	  0FEH,00000010B
	BYTE	0FFH,0A0H+001H,00000000B+OCLC
	BYTE	0FFH,040H+000H,00000000B+OCTL
;
	 BYTE	  016H,10000000B+OSP0+000H			    : 5
	 BYTE	  02EH,00001110B
	 BYTE	  034H,00000000B+OPB1+003H
	 BYTE	  044H,00000000B+OPB1+003H
	 BYTE	  054H,00000000B+OPB1+003H
	 BYTE	  064H,00000000B+OPB1+003H
	 BYTE	  074H,00000000B+OPB1+003H
	 BYTE	  084H,00000000B+OPB1+003H
	 BYTE	  094H,00000000B+OPB1+003H
	 BYTE	  0A4H,00000000B+OPB1+003H
	 BYTE	  0B4H,00000000B+OPB1+003H
	 BYTE	  0C4H,00000000B+OPB1+003H
	 BYTE	  0D4H,00000000B+OPB1+003H
	 BYTE	  0E4H,00000000B+OPB1+003H
	 BYTE	  0F4H,00000000B+OPB1+003H
	 BYTE	  0FEH,00000010B
;
	 BYTE	  018H,10000000B+OCM0+002H			    : 6
	 BYTE	  03EH,00001110B
	 BYTE	  044H,00000000B+OPB1+003H
	 BYTE	  054H,00000000B+OPB1+003H
	 BYTE	  064H,00000000B+OPB1+003H
	 BYTE	  074H,00000000B+OPB1+003H
	 BYTE	  084H,00000000B+OPB1+003H
	 BYTE	  094H,00000000B+OPB1+003H
	 BYTE	  0A4H,00000000B+OPB1+003H
	 BYTE	  0B4H,00000000B+OPB1+003H
	 BYTE	  0C4H,00000000B+OPB1+003H
	 BYTE	  0D4H,00000000B+OPB1+003H
	 BYTE	  0E4H,00000000B+OPB1+003H
	 BYTE	  0F4H,00000000B+OPB1+003H
	 BYTE	  0FEH,00000010B
;
	 BYTE	  016H,10000000B+OSP0+000H			    : 7
	 BYTE	  02EH,00001110B
	 BYTE	  034H,00000000B+OPB1+003H
	 BYTE	  044H,00000000B+OPB1+003H
	 BYTE	  054H,00000000B+OPB1+003H
	 BYTE	  064H,00000000B+OPB1+003H
	 BYTE	  074H,00000000B+OPB1+003H
	 BYTE	  084H,00000000B+OPB1+003H
	 BYTE	  094H,00000000B+OPB1+003H
	 BYTE	  0A4H,00000000B+OPB1+003H
	 BYTE	  0B4H,00000000B+OPB1+003H
	 BYTE	  0C4H,00000000B+OPB1+003H
	 BYTE	  0D4H,00000000B+OPB1+003H
	 BYTE	  0E4H,00000000B+OPB1+003H
	 BYTE	  0F4H,00000000B+OPB1+003H
	 BYTE	  0FEH,00000010B
;
	 BYTE	  018H,10000000B+OCM0+002H			    : 8
	 BYTE	  03EH,00001110B
	 BYTE	  044H,00000000B+OPB1+003H
	 BYTE	  054H,00000000B+OPB1+003H
	 BYTE	  064H,00000000B+OPB1+003H
	 BYTE	  074H,00000000B+OPB1+003H
	 BYTE	  084H,00000000B+OPB1+003H
	 BYTE	  094H,00000000B+OPB1+003H
	 BYTE	  0A4H,00000000B+OPB1+003H
	 BYTE	  0B4H,00000000B+OPB1+003H
	 BYTE	  0C4H,00000000B+OPB1+003H
	 BYTE	  0D4H,00000000B+OPB1+003H
	 BYTE	  0E4H,00000000B+OPB1+003H
	 BYTE	  0F4H,00000000B+OPB1+003H
	 BYTE	  0FEH,00000010B
;
	 BYTE	  016H,10000000B+OSP0+000H			    : 9
	 BYTE	  02EH,00001110B
	 BYTE	  034H,00000000B+OPB1+003H
	 BYTE	  044H,00000000B+OPB1+003H
	 BYTE	  054H,00000000B+OPB1+003H
	 BYTE	  064H,00000000B+OPB1+003H
	 BYTE	  074H,00000000B+OPB1+003H
	 BYTE	  084H,00000000B+OPB1+003H
	 BYTE	  094H,00000000B+OPB1+003H
	 BYTE	  0A4H,00000000B+OPB1+003H
	 BYTE	  0B4H,00000000B+OPB1+003H
	 BYTE	  0C4H,00000000B+OPB1+003H
	 BYTE	  0D4H,00000000B+OPB1+003H
	 BYTE	  0E4H,00000000B+OPB1+003H
	 BYTE	  0F4H,00000000B+OPB1+003H
	 BYTE	  0FEH,00000010B
;
	 BYTE	  018H,10000000B+OCM0+002H			    : A
	 BYTE	  03EH,00001110B
	 BYTE	  044H,00000000B+OPB1+003H
	 BYTE	  054H,00000000B+OPB1+003H
	 BYTE	  064H,00000000B+OPB1+003H
	 BYTE	  074H,00000000B+OPB1+003H
	 BYTE	  084H,00000000B+OPB1+003H
	 BYTE	  094H,00000000B+OPB1+003H
	 BYTE	  0A4H,00000000B+OPB1+003H
	 BYTE	  0B4H,00000000B+OPB1+003H
	 BYTE	  0C4H,00000000B+OPB1+003H
	 BYTE	  0D4H,00000000B+OPB1+003H
	 BYTE	  0E4H,00000000B+OPB1+003H
	 BYTE	  0F4H,00000000B+OPB1+003H
	 BYTE	  0FEH,00000010B
;
	 BYTE	  016H,10000000B+OSP0+000H			    : B
	 BYTE	  02EH,00001110B
	 BYTE	  034H,00000000B+OPB1+003H
	 BYTE	  044H,00000000B+OPB1+003H
	 BYTE	  054H,00000000B+OPB1+003H
	 BYTE	  064H,00000000B+OPB1+003H
	 BYTE	  074H,00000000B+OPB1+003H
	 BYTE	  084H,00000000B+OPB1+003H
	 BYTE	  094H,00000000B+OPB1+003H
	 BYTE	  0A4H,00000000B+OPB1+003H
	 BYTE	  0B4H,00000000B+OPB1+003H
	 BYTE	  0C4H,00000000B+OPB1+003H
	 BYTE	  0D4H,00000000B+OPB1+003H
	 BYTE	  0E4H,00000000B+OPB1+003H
	 BYTE	  0F4H,00000000B+OPB1+003H
	 BYTE	  0FEH,00000010B
;
	 BYTE	  018H,10000000B+OCM0+002H			    : C
	 BYTE	  05EH,00001010B
	BYTE	05FH,0B0H+000H,00000000B+OCTL
	 BYTE	  06EH,00000010B
	 BYTE	  07BH,00000000B+OPB1+001H
	 BYTE	  07EH,00001010B
	 BYTE	  0B7H,00000000B+OSP0+000H
	 BYTE	  0EEH,00000111B
	BYTE	0FFH,010H+000H,00000000B+ONBK
	BYTE	0FFH,080H+000H,00000000B+OCTR
;
	 BYTE	  0FEH,10001010B				     : D
	BYTE	0FFH,020H+000H,00000000B+ONBK
	BYTE	0FFH,080H+000H,00000000B+OCTL
;
	 BYTE	  00DH,10000000B+OSL0+000H			     : E
	 BYTE	  0CDH,00000000B+OCH0+000H
	 BYTE	  0CEH,00001001B
	 BYTE	  0DDH,00000000B+OSK0+000H
	 BYTE	  0DEH,00001011B
	BYTE	0DFH,070H+000H,00000000B+OCTR
	BYTE	0EFH,020H+000H,00000000B+ONBK
	BYTE	0FFH,0A0H+001H,00000000B+OCLC
	BYTE	0FFH,020H+000H,00000000B+ONBK
	BYTE	0FFH,070H+000H,00000000B+OCTL
	 BYTE	  0FEH,00000010B
;
	 BYTE	  05DH,10000000B+000H+SCOF			     : F
;
	 BYTE	  0FDH
;
;
;
FXBD02	 EQU	  $	    ;< Castle - 02 >		    / W C - 4 /
	 BYTE	  01011000B,00001001B
;
	BYTE	00FH,050H+005H,00000000B+OKID
	BYTE	00FH,060H+00DH,00000000B+OKID
;;	   BYTE	    006H,00000000B+OBK1+00DH			       : 0
;;	   BYTE	    007H,00000000B+OBK1+00DH
	BYTE	00FH,010H+001H,00000000B+OLBK
	BYTE	01FH,010H+001H,00000000B+OLBK
	BYTE	02FH,010H+001H,00000000B+OLBK
	BYTE	03FH,010H+001H,00000000B+OLBK
	BYTE	04FH,010H+001H,00000000B+OLBK
	BYTE	05FH,010H+001H,00000000B+OLBK
	BYTE	06FH,010H+001H,00000000B+OLBK
	BYTE	07FH,010H+001H,00000000B+OLBK
	BYTE	08FH,010H+001H,00000000B+OLBK
	BYTE	09FH,010H+001H,00000000B+OLBK
	BYTE	0AFH,010H+001H,00000000B+OLBK
	BYTE	0BFH,010H+001H,00000000B+OLBK
	BYTE	0BFH,020H+000H,00000000B+ONBK
	 BYTE	  0DEH,00001100B
	BYTE	0EFH,060H+000H,00000000B+OCRC
	BYTE	0EFH,040H+000H,00000000B+OCTR
	 BYTE	  0F3H,00000000B+OBK1+00DH
;
	 BYTE	  003H,10000000B+OSP0+000H			     : 1
;;;;;;;;;BYTE;;;;;063H,00000000B+OSP0+000H;;;;;;;;;;;;;;;;
	 BYTE	  06EH,01000011B
	 BYTE	  0CEH,00001010B
	BYTE	0CFH,040H+000H,00000000B+OCTL
	BYTE	0EFH,010H+007H,00000000B+OLBK
	BYTE	0EFH,020H+000H,00000000B+ONBK
	BYTE	0EFH,080H+000H,00000000B+ONBK
	BYTE	0FFH,010H+007H,00000000B+OLBK
;
	BYTE	00FH,010H+007H,10000000B+OLBK			     ; 2
	BYTE	01FH,010H+007H,00000000B+OLBK
	 BYTE	  01EH,00000101B
	BYTE	02FH,080H+000H,00000000B+OLBK
	BYTE	02FH,0B0H+000H,00000000B+OCTR
	BYTE	03FH,080H+000H,00000000B+OLBK
	BYTE	04FH,080H+000H,00000000B+OLBK
	BYTE	05FH,080H+000H,00000000B+OLBK
	BYTE	06FH,080H+000H,00000000B+OLBK
	 BYTE	  06EH,01000000B
	BYTE	07FH,080H+000H,00000000B+OLBK
	BYTE	08FH,080H+000H,00000000B+OLBK
	BYTE	09FH,080H+000H,00000000B+OLBK
	BYTE	0AFH,080H+000H,00000000B+OLBK
	 BYTE	  0BEH,00000001B
	BYTE	0BFH,000H+000H,00000000B+ONBK
	BYTE	0BFH,080H+000H,00000000B+ONBK
;
	 BYTE	  0C7H,00000000B+OSBM+000H
	 BYTE	  0DBH,00000000B+OSP0+000H
	 BYTE	  0DEH,00000000B
;
	 BYTE	  01FH,0F0H+000H,10000000B+OEW0,06FH,0F0H+000H,00000000B+OEW0  : 3
	 BYTE	  0BFH,0F0H+000H,00000000B+OEW0
;
	 BYTE	  00FH,0F0H+000H,10000000B+OEW0,05FH,0F0H+000H,00000000B+OEW0  : 4
	 BYTE	  07EH,00000101B
	BYTE	08FH,000H+000H,00000000B+ONBK
	BYTE	08FH,0B0H+000H,00000000B+OCTR
	BYTE	0AFH,080H+000H,00000000B+ONBK
	BYTE	0BFH,080H+000H,00000000B+OLBK
	BYTE	0CFH,080H+000H,00000000B+OLBK
	BYTE	0DFH,080H+000H,00000000B+OLBK
	BYTE	0EFH,080H+000H,00000000B+OLBK
	BYTE	0FFH,020H+000H,00000000B+ONBK
	BYTE	0FFH,080H+000H,00000000B+OLBK
	 BYTE	  0FEH,00000010B
;
	BYTE	00FH,080H+000H,10000000B+OLBK
	BYTE	01FH,080H+000H,00000000B+ONBK
	 BYTE	  024H,00000000B+OSP0+000H,034H,00000000B+OBK1+000H  : 5
	 BYTE	  03EH,00001100B
	BYTE	03FH,0A0H+001H,00000000B+OCRC
	BYTE	04FH,040H+000H,00000000B+OCTR
	 BYTE	  04EH,01000011B
	 BYTE	  0AEH,00001010B
	BYTE	0AFH,040H+000H,00000000B+OCTL
	 BYTE	  0BEH,00001100B
	BYTE	0CFH,040H+000H,00000000B+OCTR
	BYTE	0EFH,040H+000H,00000000B+OCTL
	 BYTE	  0EEH,00001010B
	 BYTE	  0FEH,00001100B
;
	BYTE	00FH,040H+000H,10000000B+OCTR
	BYTE	02FH,040H+000H,00000000B+OCTL
	 BYTE	  02EH,00001010B				     : 6
	 BYTE	  03EH,00001100B
	BYTE	04FH,040H+000H,00000000B+OCTR
	BYTE	07FH,0A0H+001H,00000000B+OCLC
	BYTE	07FH,040H+000H,00000000B+OCTL
	 BYTE	  07EH,00000010B
	 BYTE	  08EH,00001110B
;;;	    BYTE     098H,00000000B+OBK1+006H,0B9H,00000000B+OBK1+004H
	BYTE	094H,00000000B+OPB1+004H
	BYTE	0A4H,00000000B+OPB1+004H
	BYTE	0B4H,00000000B+OPB1+005H
	BYTE	0C4H,00000000B+OPB1+005H
	BYTE	0D4H,00000000B+OPB1+005H
	BYTE	0E4H,00000000B+OPB1+005H
	BYTE	0F4H,00000000B+OPB1+005H
;
;;;	    BYTE     008H,10000000B+OBK1+00FH,009H,00000000B+OBK1+00FH	: 7
	BYTE	004H,10000000B+OPB1+005H
	BYTE	014H,00000000B+OPB1+005H
	BYTE	024H,00000000B+OPB1+005H
	BYTE	034H,00000000B+OPB1+005H
	BYTE	044H,00000000B+OPB1+005H
	BYTE	054H,00000000B+OPB1+005H
	BYTE	064H,00000000B+OPB1+005H
	BYTE	074H,00000000B+OPB1+005H
	BYTE	084H,00000000B+OPB1+005H
	BYTE	094H,00000000B+OPB1+005H
	BYTE	0A4H,00000000B+OPB1+005H
	BYTE	0B4H,00000000B+OPB1+005H
	BYTE	0C4H,00000000B+OPB1+005H
	BYTE	0D4H,00000000B+OPB1+005H
	BYTE	0E4H,00000000B+OPB1+005H
	BYTE	0F4H,00000000B+OPB1+005H
;
	 BYTE	  00EH,10000010B				     : 8
	BYTE	004H,00000000B+OPB1+004H
;
	 BYTE	  02EH,10000110B				     : 9
	BYTE	02FH,0A0H+001H,00000000B+OCRC
	BYTE	03FH,080H+000H,00000000B+OCTR
	 BYTE	  04EH,00001100B
	BYTE	04FH,070H+001H,00000000B+OCRC
	BYTE	05FH,040H+000H,00000000B+OCTR
	 BYTE	  09EH,00001001B
	BYTE	09FH,060H+001H,00000000B+OCLC
	BYTE	09FH,040H+000H,00000000B+OCTL
	 BYTE	  0A6H,00000000B+OPB1+000H
	 BYTE	  0C1H,00000000B+OPB1+002H,0C4H,00000000B+OSP0+000H
	 BYTE	  0EEH,00001100B
	BYTE	0EFH,060H+001H,00000000B+OCRC
	BYTE	0FFH,040H+000H,00000000B+OCTR
;
	 BYTE	  00EH,10000110B				     : A
	BYTE	01FH,070H+001H,00000000B+OCLC
	BYTE	01FH,040H+000H,00000000B+OCTL
	 BYTE	  05EH,00001100B
	BYTE	05FH,070H+001H,00000000B+OCRC
	BYTE	06FH,040H+000H,00000000B+OCTR
	 BYTE	  07EH,00001001B
	BYTE	07FH,060H+001H,00000000B+OCLC
	BYTE	07FH,040H+000H,00000000B+OCTL
	 BYTE	  086H,00000000B+OPB1+000H
	 BYTE	  0A1H,00000000B+OPB1+002H,0A4H,00000000B+OSP0+000H
	 BYTE	  0C6H,00000000B+OPB1+000H
	 BYTE	  0CEH,00001100B
	BYTE	0CFH,060H+001H,00000000B+OCRC
	BYTE	0DFH,040H+000H,00000000B+OCTR
	 BYTE	  0FEH,00001010B
	BYTE	0FFH,040H+000H,00000000B+OCTL
;
	 BYTE	  028H,10000000B+OBK1+004H,0A6H,00000000B+OBK1+001H  : B
	 BYTE	  0E8H,00000000B+OBK1+004H
;
	 BYTE	  08BH,10000000B+OBK1+002H			     : C
	 BYTE	  09BH,00000000B+OSP0+000H
	 BYTE	  0FEH,00000111B
;
;**********
;
	BYTE	00FH,020H+000H,10000000B+ONBK
	BYTE	00FH,080H+000H,00000000B+OCTR
	BYTE	0FFH,020H+000H,00000000B+ONBK
	BYTE	0FFH,080H+000H,00000000B+OCTL
	 BYTE	  0FEH,00001010B				     : D
 ;
	 BYTE	  00DH,10000000B+OSL0+000H			     : E
;;;;;;;	 BYTE	  001H,00000000B+OBK0+001H
;;;;;;	 BYTE	  012H,00000000B+OBK0+004H
;;;;;;	 BYTE	  023H,00000000B+OBK0+006H
;;;;;;;	 BYTE	  077H,00000000B+OSP0+000H
	 BYTE	  0CDH,00000000B+OCH0+000H
	 BYTE	  0CEH,00001001B
	 BYTE	  0DDH,00000000B+OSK0+000H
	 BYTE	  0DEH,00001011B
	BYTE	0DFH,070H+000H,00000000B+OCTR
	BYTE	0EFH,020H+000H,00000000B+ONBK
	BYTE	0FFH,0A0H+001H,00000000B+OCLC
	BYTE	0FFH,020H+000H,00000000B+ONBK
	BYTE	0FFH,070H+000H,00000000B+OCTL
	 BYTE	  0FEH,00000010B
;
	 BYTE	  05DH,10000000B+000H+SCOF			     : F
;
	 BYTE	  0FDH
;
;
;
FXBD03	 EQU	  $	    ;< Castle - 03 >		    / W D - 4 /
	 BYTE	  01011011B,00000011B
;
	 BYTE	  005H,00000000B+OBK1+004H,006H,00000000B+OBK1+005H  : 0
	 BYTE	  039H,00000000B+OCM2+001H
	 BYTE	  06EH,00000010B
	BYTE	06FH,010H+000H,00000000B+ONBK
	 BYTE	  0AEH,00001010B
	BYTE	0AFH,0B0H+000H,00000000B+OCTL
	 BYTE	  0FEH,00000101B
;
	BYTE	00FH,0B0H+000H,10000000B+OCTR
	BYTE	00FH,020H+000H,00000000B+ONBK
	 BYTE	  017H,00000000B+OSP0+000H,097H,00000000B+OSP0+000H  : 1
	 BYTE	  09EH,00000010B
	BYTE	09FH,020H+000H,00000000B+ONBK
	 BYTE	  0A6H,00000000B+OSBM+000H,0FAH,00000000B+OBK1+000H
	 BYTE	  0FEH,00001010B
	BYTE	0FFH,0B0H+000H,00000000B+OCTL
;
	 BYTE	  04EH,10000010B				     : 2
	BYTE	05FH,0B0H+000H,00000000B+OCTR
	 BYTE	  057H,00000000B+OSP0+000H,058H,00000000B+OPB1+002H
	 BYTE	  068H,00000000B+OPB1+002H,079H,00000000B+OPB1+001H
	 BYTE	  08AH,00000000B+OPB1+000H
	 BYTE	  08EH,00001010B
	BYTE	08FH,0B0H+000H,00000000B+OCTL
	 BYTE	  0F5H,00000000B+OBK1+001H,0F9H,00000000B+OCM2+003H
;
	 BYTE	  039H,10000000B+OCM2+003H,0B5H,00000000B+OCM2+001H  : 3
	 BYTE	  0B7H,00000000B+OBK1+001H
;
	 BYTE	  04DH,10000000B+JFST+000H,08AH,00000000B+OPB1+002H  : 4
	 BYTE	  09AH,00000000B+OPB1+002H
	 BYTE	  0AEH,00000101B
	 BYTE	  0BBH,00000000B+OSP0+000H
	BYTE	0BFH,010H+000H,00000000B+ONBK
	 BYTE	  0CDH,00000000B+EXOF+000H
;
	 BYTE	  0FEH,10000010B				     : 5
	BYTE	0FFH,000H+000H,00000000B+ONBK
	BYTE	0FEH,001H
;
	 BYTE	  077H,10000000B+OCM0+003H			     : 6
	 BYTE	  0DEH,00001111B
	BYTE	0DFH,0B0H+000H,00000000B+OCTL
	BYTE	0EFH,000H+000H,00000000B+ONBK
;
	 BYTE	  04EH,10000010B				     : 7
	 BYTE	  06DH,00000000B+000H+SCOF
;
	BYTE	02FH,0B0H+000H,10000000B+OCTL
	 BYTE	  039H,00000000B+OCM2+003H			     : 8
	BYTE	05FH,0B0H+000H,00000000B+OCTR
;
	 BYTE	  00CH,10000000B+OBC1+00AH,008H,00000000B+OBK1+00FH  : 9
	 BYTE	  0B3H,00000000B+OBMS+000H,0CCH,00000000B+OBC1+003H
	 BYTE	  0F9H,00000000B+OBK1+000H
;
	 BYTE	  069H,10000000B+OCM0+001H,0EAH,00000000B+OPB1+000H  : A
	 BYTE	  0FEH,00000111B
	BYTE	0FFH,0A0H+001H,00000000B+OCRC
	 BYTE	  0F9H,00000000B+OPB1+001H
;
	BYTE	00FH,080H+000H,10000000B+OCTR
	BYTE	00FH,020H+000H,00000000B+ONBK
	 BYTE	  0DEH,00000100B				     : B
	BYTE	0DFH,0A0H+001H,00000000B+OCLC
	BYTE	0DFH,080H+000H,00000000B+OCTL
	 BYTE	  0E9H,00000000B+OPB1+001H
	BYTE	0EFH,040H+002H,00000000B+OLBK
	BYTE	0EFH,040H+000H,00000000B+ONBK
	 BYTE	  0F4H,00000000B+OPB1+001H
	 BYTE	  0FAH,00000000B+OPB1+000H
	BYTE	0FFH,040H+002H,00000000B+OLBK
;
	BYTE	00FH,040H+002H,10000000B+OLBK
	BYTE	01FH,040H+002H,00000000B+OLBK
	BYTE	02FH,040H+002H,00000000B+OLBK
	BYTE	03FH,040H+002H,00000000B+OLBK
	 BYTE	  03EH,00001010B
	BYTE	03FH,0B0H+000H,00000000B+OCTL
	BYTE	03FH,020H+000H,00000000B+ONBK
	 BYTE	  07EH,00001100B
	BYTE	08FH,040H+000H,00000000B+OCTR
;
	 BYTE	  07EH,10001010B				     : D
	BYTE	07FH,040H+000H,00000000B+OCTL
	 BYTE	  08EH,00001000B
	 BYTE	  094H,00000000B+OBK1+006H
	BYTE	09FH,010H+000H,00000000B+ONBK
	BYTE	09FH,080H+000H,00000000B+OCTR
	BYTE	09FH,040H+000H,00000000B+OLBK
	BYTE	0AFH,040H+000H,00000000B+OLBK
	BYTE	0BFH,040H+000H,00000000B+OLBK
	BYTE	0CFH,040H+000H,00000000B+OLBK
	BYTE	0DFH,040H+000H,00000000B+OLBK
	BYTE	0EFH,040H+000H,00000000B+OLBK
	BYTE	0FFH,040H+000H,00000000B+OLBK
	BYTE	0FFH,080H+000H,00000000B+OCTL
	BYTE	0FFH,020H+000H,00000000B+ONBK
	 BYTE	  0FEH,00001010B
;
	 BYTE	  00DH,10000000B+OSL0+000H			     : E
	 BYTE	  061H,00000000B+OPB1+004H,071H,00000000B+OPB1+004H
	 BYTE	  081H,00000000B+OPB1+004H,0CDH,00000000B+OCH0+000H
	 BYTE	  0CEH,00001001B
	 BYTE	  0DDH,00000000B+OSK0+000H
	 BYTE	  0DEH,00001011B
	BYTE	0DFH,070H+000H,00000000B+OCTR
	BYTE	0EFH,020H+000H,00000000B+ONBK
;;K;;	     BYTE    0FFH,0A0H+001H,00000000B+OCLC
	BYTE	0FFH,020H+000H,00000000B+ONBK
;;K;;	     BYTE    0FFH,070H+000H,00000000B+OCTL
	 BYTE	  0FEH,00000010B
;
	 BYTE	  05DH,10000000B+000H+SCOF			     : F
;
	 BYTE	  0FDH
;
;
;#####################################################################
;#	 Fix obstacle out pos data  ( Ground )			     #
;#####################################################################
FXBD10	 EQU	  $	    ;< Ground - 00 >		    / W A - 1 /
;						  *61.05.26
	 BYTE	  01010010B,01110001B
;
	 BYTE	  00FH,0F0H+000H,00000000B+OCS0
	 BYTE	  06EH,01110000B
	 BYTE	  0E3H,00000000B+OPB1+004H,0FCH,00000000B+OBC1+001H : 0
	 BYTE	  0FCH,00000000B+OBC2+001H
;
	 BYTE	  013H,10000000B+OSBM+000H			    : 1
	 BYTE	  02CH,00000000B+OBC1+001H,02CH,00000000B+OBC2+001H
	 BYTE	  043H,00000000B+OPB1+004H
	 BYTE	  0B2H,00000000B+OBK0+002H,0B5H,00000000B+OPB1+002H
	 BYTE	  0C7H,00000000B+OBK0+008H
;
	 BYTE	  022H,10000000B+OBK0+002H,052H,00000000B+OBBW+000H : 2
	 BYTE	  056H,00000000B+OPB1+001H,06CH,00000000B+OHL0+003H
	 BYTE	  0DBH,00000000B+OCM2+001H,0FCH,00000000B+OHL0+003H
	 BYTE	  0F3H,00000000B+OBK0+000H
;
	 BYTE	  003H,10000000B+OBK0+004H			    : 3
	 BYTE	  00FH,0F0H+001H,00000000B+FCM2,040H,00000000B+OBSM+000H
	 BYTE	  08CH,00000000B+OBC2+004H,09CH,00000000B+OBC1+006H
	 BYTE	  0D7H,00000000B+ODMS+000H,0ECH,00000000B+OBC2+001H
;
	 BYTE	  089H,10000000B+OPB1+001H,0B6H,00000000B+OPB1+001H : 4
	 BYTE	  0B9H,00000000B+OBK0+00AH,0C7H,00000000B+OBK0+006H
	 BYTE	  0F4H,00000000B+OBK0+003H
;
	 BYTE	  067H,10000000B+OPB1+002H			    : 5
;
	 BYTE	  0E8H,10000000B+OCM2+002H			    : 6
;
;	   (point)
	 BYTE	  078H,10000000B+OBCO+000H,088H,00000000B+ODMS+000H : 7
	 BYTE	  098H,00000000B+OBCO+000H,0A8H,00000000B+OBCO+000H
	 BYTE	  0B8H,00000000B+OBCO+000H
;
	 BYTE	  003H,10000000B+OBK0+001H,007H,00000000B+OBK0+006H : 8
	 BYTE	  023H,00000000B+OBK1+001H
	 BYTE	  021H,00000000B+OCM0+001H,04BH,00000000B+OCM2+001H
	 BYTE	  043H,00000000B+OBK0+002H
	 BYTE	  0CFH,0F0H+003H,00000000B+OST0
;
	 BYTE	  006H,10000000B+OPB1+004H
	 BYTE	  016H,00000000B+OBK0+00AH,039H,00000000B+OCM2+001H : 9
	 BYTE	  058H,00000000B+OCO0+005H,05AH,00000000B+OCO0+005H
	 BYTE	  0C6H,00000000B+OBBM+000H,0DCH,00000000B+OHL0+004H
;
	 BYTE	  03FH,0F0H+007H,10000000B+FCM1,03BH,00000000B+OCM2+001H : A
	 BYTE	  030H,00000000B+OBK1+001H
	 BYTE	  08CH,00000000B+OBC2+001H,0ACH,00000000B+OHL0+001H
	 BYTE	  0E7H,00000000B+OPB1+003H
;
	 BYTE	  039H,10000000B+OBOD+000H,063H,00000000B+OBK0+000H : B
	 BYTE	  065H,00000000B+ORBC+000H,068H,00000000B+OPB1+002H
	 BYTE	  08CH,00000000B+OHL0+000H
;
	 BYTE	  00CH,10000000B+OHL0+001H,029H,00000000B+OPB1+003H : C
	 BYTE	  03CH,00000000B+OHL0+001H,057H,00000000B+OPB1+005H
	 BYTE	  06CH,00000000B+OHL0+001H,085H,00000000B+OPB1+007H
	 BYTE	  09CH,00000000B+OHL0+004H
;
	 BYTE	  01DH,10000000B+OPL0+000H			    : D
	 BYTE	  05FH,0F0H+006H,00000000B+OCS0
;
	 BYTE	  03DH,10000000B+000H+SCOF			    : E
;
	 BYTE	  0FDH
;
;
FXBD11	 EQU	  $	    ;< Ground - 11 >		    / W A - 3 /
;					       *61.05.26
	 BYTE	  01010000B,01010000B
;
	 BYTE	  00BH,00000000B+OLD0+00FH,00FH,0F0H+006H,00000000B+OCS0 : 0
;
	 BYTE	  019H,10000000B+OLD0+006H,084H,00000000B+OCO0+003H : 1
	 BYTE	  0B7H,00000000B+OLD0+00FH
;
	 BYTE	  05DH,10000000B+KZST+000H,06DH,00000000B+JFST+000H : 2
	 BYTE	  0E0H,00000000B+OCO0+002H,0E3H,00000000B+OLD0+002H
;
	 BYTE	  039H,10000000B+OLD0+00CH,056H,00000000B+OCO0+003H : 3
;
	 BYTE	  047H,10000000B+OLD0+00BH,0A4H,00000000B+OLD0+002H : 4
	 BYTE	  0C1H,00000000B+OSBM+000H,0EDH,00000000B+KZOF+000H
	 BYTE	  0F4H,00000000B+OCO0+002H
;
;	   (point)
	 BYTE	  01BH,10000000B+OLD0+008H,0B7H,00000000B+OLD0+003H : 5
;
	 BYTE	  002H,10000000B+OCO0+002H,003H,00000000B+OLD0+002H : 6
	 BYTE	  047H,00000000B+OLD0+00FH,0ADH,00000000B+JFST+000H
;
	 BYTE	  063H,10000000B+OLD0+00CH,082H,00000000B+OCO0+008H : 7
;
	 BYTE	  076H,10000000B+OLD0+003H			    : 8
;
	 BYTE	  008H,10000000B+OLD0+004H			    : 9
	 BYTE	  08EH,00010001B
	 BYTE	  0B0H,00000000B+OSCO+000H,0C9H,00000000B+OBOD+000H
;
	 BYTE	  01DH,10000000B+OPL0+000H			    : A
	 BYTE	  02DH,00000000B+EXOF+000H
	 BYTE	  03FH,0F0H+000H,00000000B+OCS0
;
	 BYTE	  00DH,00EH					    : E
	 BYTE	  00EH,01000000B
	 BYTE	  039H,00000000B+OCM2+001H
	 BYTE	  07FH,0F0H+007H,00000000B+OST0,0F2H,00000000B+OPB1+008H
;
	 BYTE	  001H,10000000B+OPB1+009H,011H,00000000B+OBK1+009H : F
	 BYTE	  068H,00000000B+OCM0+002H
;
	 BYTE	  0E0H,00000000B+OPB1+00AH
	 BYTE	  0F0H,00000000B+OPB1+00AH
;
	 BYTE	  000H,00000000B+OPB1+00AH
	 BYTE	  06DH,10000000B+SLON+000H
;;;	    BYTE     0DEH,00011111B
;
;;;	    BYTE     06DH,10000000B+000H+SLON			       : 10
;
;
	 BYTE	  0FDH
;
;
FXBD12	 EQU	  $	    ;< Ground - 02 >		    / W B - 1 /
	 BYTE	  01010010B,00100001B
;
	 BYTE	  00FH,0F0H+000H,00000000B+OCS0				  : 0
	 BYTE	  06EH,01100000B
;
	 BYTE	  06CH,10000000B+OBC2+006H,0CAH,00000000B+OBK1+000H  : 1
	 BYTE	  0DCH,00000000B+OHL0+002H
;
	 BYTE	  008H,10000000B+OCM2+002H,037H,00000000B+OSMS+000H  : 2
	 BYTE	  056H,00000000B+OCM2+004H
	 BYTE	  07CH,00000000B+OHL0+000H,0DCH,00000000B+OHL0+001H
	 BYTE	  0E7H,00000000B+OBK0+005H
;
	 BYTE	  047H,10000000B+ORBC+000H,049H,00000000B+OBK0+000H  : 3
	 BYTE	  06CH,00000000B+OHL0+002H,096H,00000000B+OCM2+004H
;
	 BYTE	  006H,10000000B+OBCO+000H,036H,00000000B+OBCO+000H  : 4
	 BYTE	  066H,00000000B+OBMS+000H,0A7H,00000000B+OBK0+002H
	 BYTE	  0DCH,00000000B+OHL0+002H
;
	 BYTE	  00AH,10000000B+OPB1+000H,063H,00000000B+OBK0+002H  : 5
	 BYTE	  078H,00000000B+OCM2+002H,093H,00000000B+OBBW+000H
	 BYTE	  097H,00000000B+OSCO+000H,0A3H,00000000B+OBK0+005H
	 BYTE	  0A7H,00000000B+OSCO+000H,0B6H,00000000B+OBK0+004H
;
;	   (point)
	 BYTE	  003H,10000000B+OBK0+002H,05CH,00000000B+OBC2+005H  : 6
	 BYTE	  065H,00000000B+OCM2+001H,07CH,00000000B+OHL0+000H
	 BYTE	  09CH,00000000B+OHL0+000H
;
	 BYTE	  063H,10000000B+OBK0+002H,067H,00000000B+OBK0+000H  : 7
	 BYTE	  077H,00000000B+OSCO+000H,087H,00000000B+OBK0+000H
	 BYTE	  093H,00000000B+OBBS+000H,097H,00000000B+OSCO+000H
	 BYTE	  0A3H,00000000B+OBK0+002H,0A7H,00000000B+OBK0+000H
	 BYTE	  0B7H,00000000B+OSCO+000H,0BCH,00000000B+OHL0+000H
	 BYTE	  0C7H,00000000B+OBK0+000H,0DCH,00000000B+OHL0+000H
	 BYTE	  0FCH,00000000B+OHL0+001H
;
	 BYTE	  019H,10000000B+OBOD+000H			     : 8
	 BYTE	  01EH,00100000B
	 BYTE	  046H,00000000B+OBK0+002H,04CH,00000000B+OBC1+001H
	 BYTE	  063H,00000000B+OBMS+000H
	 BYTE	  08EH,00100001B
	 BYTE	  0D7H,00000000B+OCM2+003H
;
	 BYTE	  046H,10000000B+OBK0+006H,04CH,00000000B+OBC1+002H  : 9
	 BYTE	  068H,00000000B+OPB1+002H,073H,00000000B+ODMS+000H
	 BYTE	  08CH,00000000B+OBC1+002H,0D8H,00000000B+OPB1+002H
;
	 BYTE	  043H,10000000B+OBK0+009H,0C7H,00000000B+OCM2+003H  : A
	 BYTE	  0ECH,00000000B+OHL0+006H
;
	 BYTE	  057H,10000000B+OCM2+003H,07CH,00000000B+OHL0+000H  : B
	 BYTE	  0B5H,00000000B+OPB1+005H,0C5H,00000000B+OPB1+005H
	 BYTE	  0DCH,00000000B+OHL0+000H
	 BYTE	  0E3H,00000000B+OPB1+007H
;
	 BYTE	  07DH,10000000B+000H+OPL0	     ;(Flag)	     : C
	 BYTE	  0BFH,0F0H+006H,00000000B+OCS0
;
	 BYTE	  0ADH,10000000B+000H+SCOF			     : D
;
	 BYTE	  0FDH
;
;
FXBD13	 EQU	  $	    ;< Ground - 03 >		    / W B - 3 /
;
	 BYTE	  10010000B,00010000B
;
	 BYTE	  00BH,00000000B+OLD0+00BH			     : 0
	 BYTE	  00FH,0F0H+006H,00000000B+OCS0
;
	 BYTE	  007H,10000000B+OLD0+004H,0BCH,00000000B+OEP0+004H  : 1
	 BYTE	  0BFH,0F0H+003H,00000000B+OLW0,0C7H,00000000B+OCO0+000H
	 BYTE	  0FFH,0F0H+006H,00000000B+OLW0
;
	 BYTE	  0D1H,10000000B+OBMS+000H			     : 2
;
	 BYTE	  0C3H,10000000B+OLD0+004H,0CBH,00000000B+OLD0+007H  : 3
	 BYTE	  0C2H,00000000B+OCO0+004H
;
	 BYTE	  029H,10000000B+OBOD+000H,077H,00000000B+OBK1+001H  : 4
;
;	    (point)
	 BYTE	  00BH,10000000B+OLD0+006H,076H,00000000B+OBK1+002H  : 5
	 BYTE	  0C7H,00000000B+OCM2+005H
;
	 BYTE	  013H,10000000B+OCM2+007H,01BH,00000000B+OPB1+001H  : 6
	 BYTE	  02BH,00000000B+OPB1+001H,04BH,00000000B+OLD0+002H
	 BYTE	  059H,00000000B+OBOD+000H
;
	 BYTE	  03BH,10000000B+OBK1+000H,03AH,00000000B+OCO0+000H  : 7
	 BYTE	  043H,00000000B+OLD0+002H,07AH,00000000B+OCO0+000H
	 BYTE	  07BH,00000000B+OBK1+000H,0B5H,00000000B+OCO0+001H
	 BYTE	  0B6H,00000000B+OBK0+000H,0C6H,00000000B+OBBM+000H
	 BYTE	  0F3H,00000000B+OLD0+003H
;
	 BYTE	  06BH,10000000B+OLD0+002H  : 8
	 BYTE	  079H,00000000B+OBOD+000H,0CCH,00000000B+OEP0+005H
	 BYTE	  0CFH,0F0H+001H,00000000B+OLW0
;
	 BYTE	  01FH,0F0H+005H,10000000B+OLW0,0C3H,00000000B+OLD0+004H  : 9
;
	 BYTE	  0B3H,10000000B+OLD0+005H			     : A
;
	 BYTE	  0A3H,10000000B+OLD0+005H			     : B
;
	 BYTE	  04DH,10000000B+000H+EXOF			     : C
	 BYTE	  06BH,00000000B+OPB1+001H
	 BYTE	  07EH,00010001B
	 BYTE	  08DH,00000000B+000H+OPL0
;	  BYTE	   0BEH,01000010B
	 BYTE	  0AFH,0F0H+000H,00000000B+OCS0
;
	 BYTE	  08DH,10000000B+000H+SCOF			     : D
;
	 BYTE	  0FDH
;
;
FXBD14	 EQU	  $	    ;< Ground - 04 >		    / W C - 1 /
;
	 BYTE	  01010010B,00110001B
;
	 BYTE	  00FH,0F0H+000H,00000000B+OCS0				  : 0
	 BYTE	  06EH,01110100B
;
	 BYTE	  00DH,002H
	 BYTE	  003H,00000000B+OBK1+003H,01FH,0F0H+002H,00000000B+FCM2  : 2
	 BYTE	  039H,00000000B+OCM2+001H,065H,00000000B+OSMS+000H
	 BYTE	  06CH,00000000B+OBC2+000H,077H,00000000B+ODMS+000H
	 BYTE	  084H,00000000B+OCM2+002H,08CH,00000000B+OBC2+002H
	 BYTE	  0B3H,00000000B+OBK1+004H,0ECH,00000000B+OHL0+001H
	 BYTE	  0EFH,0F0H+002H,00000000B+FCM2
;
	 BYTE	  00DH,004H
	 BYTE	  0ACH,00000000B+OBC1+007H,0CCH,00000000B+OHL0+001H  : 4
	 BYTE	  0CFH,0F0H+001H,00000000B+FCM2,0E7H,00000000B+OBK0+002H
;
	 BYTE	  017H,10000000B+ODMT+000H,023H,00000000B+OBMS+000H  : 5
	 BYTE	  027H,00000000B+OBK0+003H,03CH,00000000B+OBC1+002H
	 BYTE	  065H,00000000B+OCM2+001H,067H,00000000B+OBK1+003H
	 BYTE	  08CH,00000000B+OBC1+001H,0DCH,00000000B+OHL0+001H
;
	 BYTE	  008H,10000000B+OCM0+002H,045H,00000000B+OCM2+005H  : 6
	 BYTE	  063H,00000000B+OBBS+000H,073H,00000000B+OBK0+003H
	 BYTE	  07CH,00000000B+OHL0+002H,08FH,0F0H+002H,00000000B+FCM2
;
;	    (point)
	 BYTE	  073H,10000000B+OBK0+009H,09FH,0F0H+004H,00000000B+FCM2  : 7
	 BYTE	  0BFH,0F0H+004H,00000000B+FCM2,0EFH,0F0H+003H,00000000B+FCM2
;
	 BYTE	  039H,10000000B+OCM2+001H,0FCH,00000000B+OHL0+00AH  : 8
;
	 BYTE	  00DH,00BH
	 BYTE	  013H,00000000B+OBK0+005H,04CH,00000000B+OHL0+001H  : B
	 BYTE	  04FH,0F0H+002H,00000000B+FCM2
	 BYTE	  073H,00000000B+ORBC+000H,077H,00000000B+OSCO+000H
	 BYTE	  0DCH,00000000B+OHL0+008H
;
	 BYTE	  023H,10000000B+OBK0+002H,053H,00000000B+OBBW+000H  : C
	 BYTE	  056H,00000000B+OSCO+000H,063H,00000000B+OBK0+004H
	 BYTE	  08CH,00000000B+OHL0+002H
;
	 BYTE	  03FH,0F0H+003H,10000000B+OST0,077H,00000000B+OPB1+003H  : D
	 BYTE	  096H,00000000B+OCM2+004H,0B3H,00000000B+OCM2+007H
;
	 BYTE	  05DH,10000000B+000H+OPL0,09FH,0F0H+006H,00000000B+OCS0  : E
;
	 BYTE	  08DH,10000000B+SCOF+000H			     : F
;
	 BYTE	  0FDH
;
;
FXBD15	 EQU	  $	    ;< Ground - 05 >		    / W C - 2 /
;
	 BYTE	  01010100B,00010001B
;
	 BYTE	  00FH,0F0H+006H,00000000B+OCS0				  : 0
	 BYTE	  0CFH,0F0H+002H,00000000B+OST0,0F8H,00000000B+OPB1+002H
	 BYTE	  0FEH,00010000B
;
	 BYTE	  03CH,10000000B+OBG1+002H,0BDH,00000000B+JFST+000H  : 1
	 BYTE	  0EAH,00000000B+OPB1+002H,0FCH,00000000B+OBG2+00DH
	 BYTE	  0FCH,00000000B+OBG2+00DH
;
	 BYTE	  017H,10000000B+OCO0+009H,0DAH,00000000B+OPB1+002H  : 2
;
	 BYTE	  00BH,10000000B+OLD0+007H,0B7H,00000000B+OLD0+002H  : 3
;
	 BYTE	  02CH,10000000B+OBG1+001H,033H,00000000B+OCO0+003H  : 4
	 BYTE	  06CH,00000000B+OBG1+001H,0ACH,00000000B+OBG2+001H
;
;	   (point)
	 BYTE	  00BH,10000000B+OLD0+008H,0ADH,00000000B+EXOF+000H  : 5
	 BYTE	  0DBH,00000000B+OBK1+000H
;
	 BYTE	  027H,10000000B+OBK1+000H,0B7H,00000000B+OLD0+004H  : 6
	 BYTE	  0C6H,00000000B+OCO0+002H
;
	 BYTE	  0C7H,10000000B+OLD0+006H,0D6H,00000000B+OCO0+004H  : 7
;
	 BYTE	  02BH,10000000B+OLD0+002H,039H,00000000B+OBOD+000H  : 8
	 BYTE	  072H,00000000B+OCO0+001H,0A7H,00000000B+OBMS+000H
;
	 BYTE	  01BH,10000000B+OLD0+005H,097H,00000000B+OLD0+003H  : 9
;
	 BYTE	  06CH,10000000B+OEP0+005H,06FH,0F0H+001H,00000000B+OLW0  : A
	 BYTE	  0A2H,00000000B+OCO0+000H,0BFH,0F0H+005H,00000000B+OLW0
	 BYTE	  0C2H,00000000B+OCO0+000H
;
;;;;;;	 BYTE	  0C7H,10000000B+OLD0+006H,0D6H,00000000B+OCO0+004H  : 7
;
;;;;;;	 BYTE	  02BH,10000000B+OLD0+002H,039H,00000000B+OBOD+000H  : 8
;;;;;	 BYTE	  072H,00000000B+OCO0+001H,0A7H,00000000B+OBMS+000H
;
;;;;;;	 BYTE	  01BH,10000000B+OLD0+005H,097H,00000000B+OLD0+003H  : 9
;
;;;;;;	 BYTE	  06CH,10000000B+OEP0+005H,06FH,0F0H+001H,00000000B+OLW0  : A
;;;;;;;	 BYTE	  0A2H,00000000B+OCO0+000H,0BFH,0F0H+005H,00000000B+OLW0
;;;;;;;; BYTE	  0C2H,00000000B+OCO0+000H
;
	 BYTE	  00BH,10000000B+OLD0+00AH,062H,00000000B+OCO0+002H  : B
	 BYTE	  063H,00000000B+OLD0+002H,0ADH,00000000B+EXOF+000H
;
	 BYTE	  00EH,10010001B				     : C
	 BYTE	  01DH,00000000B+000H+OPL0
	 BYTE	  05FH,0F0H+006H,00000000B+OCS0
;
	 BYTE	  05DH,10000000B+000H+SCOF			     : D
;
	 BYTE	  0FDH
;
;
FXBD16	 EQU	  $	    ;< Ground - 06 >		    / W C - 3 /
	 BYTE	  01010111B,00010001B
;
	 BYTE	  00FH,0F0H+006H,00000000B+OCS0				  : 0
	 BYTE	  0FEH,00010000B
;
	 BYTE	  04BH,10000000B+OLD0+002H,059H,00000000B+OBOD+000H  : 1
	 BYTE	  0ADH,00000000B+000H+KZST
;
	 BYTE	  0D3H,10000000B+OLD0+003H			     : 2
;
	 BYTE	  00BH,10000000B+OLD0+004H,029H,00000000B+OBOD+000H  : 3
;
	 BYTE	  07BH,10000000B+OLD0+003H,099H,00000000B+OBOD+000H  : 4
;
	 BYTE	  00DH,006H
	 BYTE	  027H,00000000B+OLD0+002H,035H,00000000B+OBOD+000H  : 6
;
	 BYTE	  023H,10000000B+OBK1+001H,057H,00000000B+OCM2+005H  : 7
	 BYTE	  0A3H,00000000B+OBK1+001H,0ABH,00000000B+OCM2+001H
	 BYTE	  0F7H,00000000B+OCM2+005H
;
	 BYTE	  023H,10000000B+OBK1+001H,087H,00000000B+OLD0+003H  : 8
	 BYTE	  095H,00000000B+OBOD+000H
;
	 BYTE	  00DH,00AH
	 BYTE	  023H,00000000B+OBK1+005H,038H,00000000B+OLD0+003H  : A
	 BYTE	  055H,00000000B+OBMS+000H,09BH,00000000B+OLD0+006H
;
;	   (point)
	 BYTE	  00BH,10000000B+OLD0+006H,0C7H,00000000B+OCM2+005H  : B
	 BYTE	  0DDH,00000000B+EXOF+000H
;
	 BYTE	  03BH,10000000B+OLD0+002H,049H,00000000B+OBOD+000H  : C
	 BYTE	  0ADH,00000000B+000H+KZST
;
	 BYTE	  029H,10000000B+OLD0+002H
	 BYTE	  052H,00000000B+OCO0+000H,06CH,00000000B+OEP0+005H  : D
	 BYTE	  06FH,0F0H+001H,00000000B+OLW0,072H,00000000B+OCO0+000H
	 BYTE	  0BFH,0F0H+005H,00000000B+OLW0
;
	 BYTE	  003H,10000000B+OLD0+003H,00AH,00000000B+OLD0+003H  : E
	 BYTE	  012H,00000000B+OCO0+001H
	 BYTE	  08BH,00000000B+OLD0+002H,099H,00000000B+OBOD+000H
;
	 BYTE	  00DH,010H
	 BYTE	  047H,00000000B+OLD0+006H,046H,00000000B+OCO0+005H  :10
	 BYTE	  0B3H,00000000B+OBK1+002H
;
	 BYTE	  013H,10000000B+OBK1+001H,057H,00000000B+OSP0+000H  :11
	 BYTE	  0A7H,00000000B+OSP0+000H,0D3H,00000000B+OBK1+001H
;
	 BYTE	  053H,10000000B+OBK1+001H,0A6H,00000000B+OBK1+001H  :12
;
	 BYTE	  003H,10000000B+OBK1+002H,013H,00000000B+OSP0+000H  :13
	 BYTE	  08DH,00000000B+000H+KZOF
	 BYTE	  0AEH,00010001B
	 BYTE	  0BDH,00000000B+000H+OPL0
;
	 BYTE	  0DFH,0F0H+000H,00000000B+OCS0				  :14
	 BYTE	  0ADH,10000000B+SCOF+000H
;
	 BYTE	  0FDH
;
;
FXBD17	 EQU	  $	    ;< Ground - 07 >		    / W D - 1 /
;
	 BYTE	  01010010B,10100001B
;
	 BYTE	  00FH,0F0H+000H,00000000B+OCS0				  : 0
	 BYTE	  06EH,01100101B
;
	 BYTE	  004H,10000000B+OBK0+000H,014H,00000000B+OBBM+000H  : 1
	 BYTE	  024H,00000000B+OBK0+00DH,057H,00000000B+OBK0+005H
	 BYTE	  0BCH,00000000B+OHL0+009H
;
	 BYTE	  04CH,10000000B+OHL0+000H,06FH,0F0H+003H,00000000B+OST0  : 2
	 BYTE	  0A5H,00000000B+OGN0+001H,0A7H,00000000B+OPB1+003H
	 BYTE	  0B7H,00000000B+OPB1+003H,0E7H,00000000B+OBK0+000H
;
	 BYTE	  035H,10000000B+OBK0+000H,059H,00000000B+OGN0+001H  : 3
	 BYTE	  0B4H,00000000B+ODMT+000H,0C0H,00000000B+OSMS+000H
;
	 BYTE	  005H,10000000B+OBCO+000H,015H,00000000B+OBCO+000H  : 4
	 BYTE	  025H,00000000B+OBCO+000H
	 BYTE	  03AH,00000000B+OGN0+000H,04CH,00000000B+OHL0+001H
	 BYTE	  06CH,00000000B+OBC2+009H,095H,00000000B+OCM0+001H
;
	 BYTE	  073H,10000000B+OBK0+007H,08FH,0F0H+004H,00000000B+FCM2  : 5
	 BYTE	  0F3H,00000000B+OBBS+000H
;
	 BYTE	  003H,10000000B+OBK0+000H,093H,00000000B+ODMT+000H  : 6
	 BYTE	  097H,00000000B+OCM2+003H,0E3H,00000000B+OBK0+000H
;
	 BYTE	  039H,10000000B+OCM2+001H			     : 7
	 BYTE	  094H,00000000B+OBBM+000H,0AAH,00000000B+OBK1+000H
	 BYTE	  0BCH,00000000B+OWT0+00CH,0C7H,00000000B+OBK1+000H
;
	 BYTE	  024H,10000000B+OCM2+002H,027H,00000000B+OBK1+001H  : 8
	 BYTE	  08FH,0F0H+003H,00000000B+OST0,0C6H,00000000B+OGN0+000H
	 BYTE	  0C7H,00000000B+OPB1+003H,0D7H,00000000B+OPB1+003H
	 BYTE	  0E7H,00000000B+OPB1+003H,0F7H,00000000B+OPB1+003H
;
	 BYTE	  003H,10000000B+OBK0+005H,007H,00000000B+OBK0+005H  : 9
	 BYTE	  0AAH,00000000B+OGN0+000H
;
	 BYTE	  003H,10000000B+OBK1+00FH,04FH,0F0H+004H,00000000B+FCM2  : A
	 BYTE	  06CH,00000000B+OHL0+000H
	 BYTE	  0DFH,0F0H+004H,00000000B+FCM2,0FCH,00000000B+OHL0+000H
;
	 BYTE	  05CH,10000000B+OHL0+001H,077H,00000000B+OCM2+003H  : B
	 BYTE	  09DH,00000000B+000H+KZST
	 BYTE	  0C5H,00000000B+OBK1+000H,0E3H,00000000B+OBK1+000H
;
	 BYTE	  07DH,10000000B+000H+OPL0			     : C
	 BYTE	  0BDH,00000000B+000H+KZOF
	 BYTE	  0BFH,0F0H+006H,00000000B+OCS0
;
	 BYTE	  0ADH,10000000B+SCOF+000H			     : D
;
	 BYTE	  0FDH
;
;
FXBD18	 EQU	  $	    ;< Ground - 08 >		    / W D - 2 /
	 BYTE	  01010101B,10100001B
;
	 BYTE	  00FH,0F0H+006H,00000000B+OCS0,09CH,00000000B+OHL0+001H  : 0
;
	 BYTE	  04FH,0F0H+006H,10000000B+OST0,0B3H,00000000B+OBK1+004H  : 1
	 BYTE	  0C9H,00000000B+OBK1+00FH
;
	 BYTE	  013H,10000000B+OBK1+00AH			     : 2
;
	 BYTE	  0A3H,10000000B+OBK1+003H,0BFH,0F0H+004H,00000000B+FCM2  : 3
;
	 BYTE	  00CH,10000000B+OHL0+004H,083H,00000000B+OBK1+00FH  : 4
	 BYTE	  09FH,0F0H+004H,00000000B+FCM2,0EFH,0F0H+002H,00000000B+FCM2
	 BYTE	  0ECH,00000000B+OHL0+001H
;
	 BYTE	  02FH,0F0H+002H,10000000B+FCM2,02CH,00000000B+OHL0+001H  : 5
	 BYTE	  06FH,0F0H+002H,00000000B+FCM2,06CH,00000000B+OHL0+001H
;
	 BYTE	  0A8H,10000000B+OGN0+001H,0AAH,00000000B+OGN0+000H  : 6
;
	 BYTE	  003H,10000000B+OBK1+007H,061H,00000000B+OCM0+001H  : 7
	 BYTE	  06FH,0F0H+005H,00000000B+FCM2
;
	 BYTE	  039H,10000000B+OCM2+001H,0DBH,00000000B+OCM2+001H  : 8
;
	 BYTE	  003H,10000000B+OBK0+002H,017H,00000000B+OBK0+002H  : 9
	 BYTE	  033H,00000000B+OBBW+000H,043H,00000000B+OBK0+000H
	 BYTE	  05BH,00000000B+OCM2+001H
;
	 BYTE	  048H,10000000B+OBOD+000H,04AH,00000000B+OBK1+000H  : A
	 BYTE	  05CH,00000000B+OWT0+00CH,0A3H,00000000B+OBK1+000H
;
	 BYTE	  02DH,10000000B+OPL0+000H,06FH,000H+006H,00000000B+OCS0  : B
;
	 BYTE	  04DH,10000000B+SCOF+000H			     : C
;
	 BYTE	  0FDH
;
FXBD19	 EQU	  $	    ;< Ground - 09 >		    / W D - 3 /
;
	 BYTE	  01010101B,10100001B
;
	 BYTE	  00FH,0F0H+006H,00000000B+OCS0				 : 0
;
	 BYTE	  039H,10000000B+OGN0+001H,068H,00000000B+OGN0+002H : 1
	 BYTE	  0A7H,00000000B+OGN0+002H
	 BYTE	  0AAH,00000000B+OGN0+000H
	 BYTE	  0C7H,00000000B+OBBM+000H
	 BYTE	  0E8H,00000000B+OGN0+002H
;
	 BYTE	  019H,10000000B+OGN0+001H,06CH,00000000B+OHL0+000H : 2
	 BYTE	  078H,00000000B+OCM2+004H
;
	 BYTE	  00EH,11000010B				    : 3
;
	 BYTE	  076H,10000000B+OSCO+000H,086H,00000000B+OSCO+000H : 4
	 BYTE	  096H,00000000B+OSCO+000H,0A6H,00000000B+OSCO+000H
	 BYTE	  0B6H,00000000B+OSCO+000H,0C6H,00000000B+OSCO+000H
	 BYTE	  0D6H,00000000B+OSCO+000H,0E6H,00000000B+OSCO+000H
	 BYTE	  0F6H,00000000B+OSCO+000H
;;K;;	      BYTE     076H,10000000B+OBK0+008H				 : 4
	 BYTE	  0FEH,01000000B
;
	 BYTE	  029H,10000000B+OGN0+001H,073H,00000000B+OBK0+009H : 5
	 BYTE	  077H,00000000B+OPB0+003H,08CH,00000000B+OBC2+007H
;
	 BYTE	  059H,10000000B+OGN0+001H			    : 6
	 BYTE	  087H,00000000B+OGN0+003H,0B6H,00000000B+OGN0+004H
	 BYTE	  0BAH,00000000B+OGN0+000H
	 BYTE	  0E8H,00000000B+OGN0+002H
;
	 BYTE	  038H,10000000B+OGN0+002H			    : 7
;
	 BYTE	  019H,10000000B+OBOD+000H,02CH,00000000B+OHL0+000H : 8
	 BYTE	  033H,00000000B+OPB1+007H
	 BYTE	  04EH,01000010B
	 BYTE	  068H,00000000B+OSCO+000H
;;K;;	      BYTE     068H,00000000B+ORBC+000H
;
	 BYTE	  02EH,11000000B				    : 9
	 BYTE	  038H,00000000B+OCM2+002H,0A8H,00000000B+OGN0+001H
	 BYTE	  0AAH,00000000B+OGN0+000H
;
	 BYTE	  049H,10000000B+OGN0+001H			    : A
	 BYTE	  06EH,01000010B
	 BYTE	  0DEH,01000000B
	 BYTE	  0E7H,00000000B+OBK0+002H
;
	 BYTE	  00EH,11000010B				    : B
;
	 BYTE	  04EH,11000000B				    : C
	 BYTE	  06CH,00000000B+OHL0+000H,079H,00000000B+OGN0+001H
	 BYTE	  08CH,00000000B+OHL0+001H,0A7H,00000000B+OGN0+003H
	 BYTE	  0BCH,00000000B+OHL0+001H,0D5H,00000000B+OGN0+005H
	 BYTE	  0ECH,00000000B+OHL0+001H
;
	 BYTE	  003H,10000000B+OGN0+007H			    : D
	 BYTE	  00EH,00000000B
	 BYTE	  06EH,00000001B
	 BYTE	  09DH,00000000B+OPL0+000H
;;K;;	      BYTE     0CEH,01000010B
	 BYTE	  0BFH,0F0H+000H,00000000B+OCS0
;
	 BYTE	  0ADH,10000000B+SCOF+000H			    : E
;
	 BYTE	  0FDH
;
;
FXBD20	 EQU	  $	    ;< Ground - 10 >		    / W D - 4 /
	 BYTE	  00010000B,00100001B
;
	 BYTE	  039H,10000000B+OCM2+001H			     : 1
;
	 BYTE	  009H,10000000B+OCM2+001H			     : 2
	 BYTE	  0ADH,00000000B+000H+KZST
;
	 BYTE	  07CH,10000000B+OHL0+003H			     : 3
	 BYTE	  096H,00000000B+OBK1+000H
;
	 BYTE	  05BH,10000000B+OCM2+001H,0C8H,00000000B+OSDM+000H  : 4
;
	 BYTE	  01FH,0F0H+007H,10000000B+OST0,093H,00000000B+OPB1+007H  : 5
	 BYTE	  0A3H,00000000B+OPB1+007H,0B3H,00000000B+OPB1+007H
	 BYTE	  0BDH,00000000B+KZOF+000H
	 BYTE	  0CCH,00000000B+OHL0+008H
;
	 BYTE	  054H,10000000B+OCM0+006H			     : 6
;
	 BYTE	  070H,00000000B+OPB1+00AH
	 BYTE	  080H,00000000B+OPB1+00AH
	 BYTE	  090H,00000000B+OPB1+00AH
	 BYTE	  0A0H,00000000B+OPB1+00AH
	 BYTE	  0B0H,00000000B+OPB1+00AH
	 BYTE	  0C0H,00000000B+OPB1+00AH
	 BYTE	  0D0H,00000000B+OPB1+00AH
	 BYTE	  0E0H,00000000B+OPB1+00AH
	 BYTE	  0F0H,00000000B+OPB1+00AH
;
	 BYTE	  000H,10000000B+OPB1+00AH
	 BYTE	  06DH,00000000B+SCOF+000H
;;;	    BYTE     06EH,00101111B
;
;;;	    BYTE     06DH,10000000B+SCOF+000H			       : 7
;
	 BYTE	  0FDH
;
;
FXBD21	 EQU	  $	    ;< Ground - 11 >	  :BOUNS ;<SKY>
	 BYTE	  00000000B,11000001B
;
	 BYTE	  04CH,00000000B+OHL0+000H			     : 0
;
	 BYTE	  002H,10000000B+OCO0+009H,0BAH,00000000B+OCO0+009H  : 1
;
	 BYTE	  062H,10000000B+OCO0+009H			     : 2
	 BYTE	  0A4H,00000000B+OBK0+000H,0A5H,00000000B+OBK0+000H
;
	 BYTE	  01AH,10000000B+OCO0+009H,0A3H,00000000B+OBK0+00CH  : 3
	 BYTE	  0B2H,00000000B+OCO0+009H
;
	 BYTE	  056H,10000000B+OCO0+002H			     : 4
	 BYTE	  06EH,00000000B
	 BYTE	  095H,00000000B+OCO0+001H
;
	 BYTE	  0ADH,10000000B+000H+SCOF			     : 7
;
	 BYTE	  0FDH
;
;
;
;#####################################################################
;#	 Fix obstacle out pos data  ( Underground )		     #
;#####################################################################
FXBD40	 EQU	  $	    ;< Underground - 1 >	    / W A - 2 /
;
	 BYTE	  01001000B,10001111B
;
	 BYTE	  01EH,00000001B				    : 0
	 BYTE	  04EH,00000010B
;
	 BYTE	  000H,10000000B+OBSM+000H,009H,00000000B+OBOD+000H : 1
	 BYTE	  06EH,00001010B
;
	 BYTE	  0EEH,10000010B				    : 2
;
	 BYTE	  02EH,10000000B				    : 3
	 BYTE	  030H,00000000B+OBK0+000H
	 BYTE	  07EH,00000001B
	 BYTE	  087H,00000000B+OBK0+007H
;
	 BYTE	  007H,10000000B+OBBM+000H,017H,00000000B+OBK0+003H : 4
	 BYTE	  03EH,00000000B
	 BYTE	  09EH,00000101B
;
	 BYTE	  05BH,10000000B+OCM2+001H,08BH,00000000B+OCM2+001H : 5
	 BYTE	  0BBH,00000000B+OCM2+001H,0EBH,00000000B+OCM2+001H
;
;	    (point)
	 BYTE	  03EH,10000010B				    : 6
	 BYTE	  07FH,0F0H+008H,00000000B+OST0
	 BYTE	  0FEH,00001010B
;
	 BYTE	  03EH,10000100B				    : 7
	 BYTE	  047H,00000000B+OBK0+009H,048H,00000000B+OBK0+00EH
	 BYTE	  0AFH,0F0H+001H,00000000B+FCM2
	 BYTE	  0CBH,00000000B+OCM2+001H
	 BYTE	  0E7H,00000000B+OBBS+000H
	 BYTE	  0F7H,00000000B+OBK0+003H
;
;
	 BYTE	  02BH,10000000B+OCM2+001H			    : 8
	 BYTE	  037H,00000000B+OPB0+001H
	 BYTE	  03EH,00000000B
	 BYTE	  06FH,0F0H+000H,00000000B+OEW0
	 BYTE	  08EH,00000100B
	 BYTE	  0DFH,0F0H+002H,00000000B+OST0
;
	 BYTE	  09CH,10000000B+OHL0+002H,0CAH,00000000B+OGN0+002H : 9
	 BYTE	  0DCH,00000000B+OHL0+000H,0E8H,00000000B+OGN0+004H
	 BYTE	  0FCH,00000000B+OHL0+000H
	 BYTE	  0FEH,00001000B
;
	 BYTE	  04EH,10001010B				    : A
	 BYTE	  088H,00000000B+OCM2+004H
	 BYTE	  09EH,00000001B
	 BYTE	  0A8H,00000000B+OPB0+002H
	 BYTE	  0BFH,0F0H+007H,00000000B+OCM1
	 BYTE	  0B8H,00000000B+OPB0+002H,0C8H,00000000B+OPB0+002H
	 BYTE	  0D8H,00000000B+OPB0+002H,0E8H,00000000B+OPB0+002H
	 BYTE	  0EEH,00001111B
;
	 BYTE	  04DH,10000000B+SCOF+000H			    : B
;
	 BYTE	  00DH,00DH
	 BYTE	  00EH,00000010B				    : D
	 BYTE	  068H,00000000B+OCM0+002H
	 BYTE	  0BEH,00000001B
	 BYTE	  0EEH,00001111B
;
	 BYTE	  06DH,10000000B+SLON+000H			    : E
;
	 BYTE	  0FDH
;
;
FXBD41	 EQU	  $	    ;< Underground - 1 >    (BONUS)
	 BYTE	  00001000B,00001111B
;
; (UNDERGROUND-1)
	 BYTE	  00EH,00000001B				     : 0
	 BYTE	  02EH,00000101B
	 BYTE	  038H,00000000B+OBK0+000H
	 BYTE	  03EH,00000100B
	 BYTE	  048H,00000000B+OBBM+000H,055H,00000000B+OCO0+005H
	 BYTE	  057H,00000000B+OCO0+005H,058H,00000000B+OBK0+005H
	 BYTE	  0B8H,00000000B+ODMT+000H
	 BYTE	  0BEH,00000101B
	 BYTE	  0C8H,00000000B+OBK0+000H
	 BYTE	  0CEH,00000001B
	 BYTE	  0DFH,0F0H+00AH,00000000B+OCM1
;
	 BYTE	  06DH,10000000B+SCOF+000H			     : 1
;
;-----------------------------------------------------------------------
;
; (UNDERGROUND-2)
	 BYTE	  00EH,10000001B				     : 2
	 BYTE	  000H,00000000B+OPB0+00AH
	 BYTE	  02EH,00000010B
	 BYTE	  034H,00000000B+OCO0+002H,036H,00000000B+OCO0+002H
	 BYTE	  037H,00000000B+OBK0+002H,073H,00000000B+OPB0+004H
	 BYTE	  083H,00000000B+000H+ORBC,087H,00000000B+OBK0+000H
	 BYTE	  093H,00000000B+OPB0+004H,090H,00000000B+OBBM+000H
	 BYTE	  0B4H,00000000B+OCO0+001H
	 BYTE	  0B6H,00000000B+OCO0+001H,0B7H,00000000B+OBK0+001H
	 BYTE	  0DFH,0F0H+00AH,00000000B+OCM1
;
	 BYTE	  06DH,10000000B+SCOF+000H			     : 3
;
;-----------------------------------------------------------------------
;
; (UNDERGROUND-3)
	 BYTE	  00EH,10000001B				     : 4
	 BYTE	  000H,00000000B+OPB0+00AH
	 BYTE	  014H,00000000B+OPB0+006H,024H,00000000B+OPB0+006H
	 BYTE	  02EH,00001100B
	 BYTE	  033H,00000000B+OCO0+003H
	 BYTE	  06EH,00001001B
	 BYTE	  08EH,00001011B
	 BYTE	  096H,00000000B+OCO0+008H
;
	 BYTE	  01EH,10000100B				     : 5
	 BYTE	  03EH,00000101B
	 BYTE	  04AH,00000000B+OCO0+008H,047H,00000000B+000H+ORBC
	 BYTE	  0CEH,00000001B
	 BYTE	  0DFH,0F0H+00AH,00000000B+OCM1
;
	 BYTE	  06DH,10000000B+SCOF+000H			     : 6
;
;-----------------------------------------------------------------------
;
	 BYTE	  0FDH		   : END
;
;
;
;#####################################################################
;#	 Fix obstacle out pos data  ( Underwater )		     #
;#####################################################################
FXBD50	 EQU	  $	    ;< Underwater - 0 >		    / W B - 2 /
;
;
	 BYTE	  01000001B,00000001B
;
	 BYTE	  0DAH,00000000B+OPB1+000H,0E9H,00000000B+OPB1+001H  : 0
	 BYTE	  0F8H,00000000B+OPB1+002H
;
	BYTE	000H,10000000B+OPB1+003H,007H,00000000B+OPB1+003H
	BYTE	010H,00000000B+OPB1+003H,017H,00000000B+OPB1+003H
	BYTE	020H,00000000B+OPB1+003H,027H,00000000B+OPB1+003H
	BYTE	030H,00000000B+OPB1+003H,037H,00000000B+OPB1+003H
	BYTE	040H,00000000B+OPB1+003H,047H,00000000B+OPB1+003H
	BYTE	050H,00000000B+OPB1+003H,057H,00000000B+OPB1+003H
	BYTE	060H,00000000B+OPB1+003H,067H,00000000B+OPB1+003H
	BYTE	070H,00000000B+OPB1+003H,077H,00000000B+OPB1+003H
	BYTE	080H,00000000B+OPB1+003H,087H,00000000B+OPB1+003H
	BYTE	090H,00000000B+OPB1+003H,097H,00000000B+OPB1+003H
	BYTE	0A0H,00000000B+OPB1+003H,0A7H,00000000B+OPB1+003H
	BYTE	0B0H,00000000B+OPB1+003H,0B7H,00000000B+OPB1+003H
	BYTE	0C0H,00000000B+OPB1+003H,0C7H,00000000B+OPB1+003H
	BYTE	0D0H,00000000B+OPB1+003H,0D7H,00000000B+OPB1+003H
	BYTE	0E0H,00000000B+OPB1+003H,0E7H,00000000B+OPB1+003H
	BYTE	0F0H,00000000B+OPB1+003H,0F7H,00000000B+OPB1+003H
;
	 BYTE	  047H,10000000B+OPB0+003H,08AH,00000000B+OPB1+000H  : 2
	 BYTE	  099H,00000000B+OPB1+001H,0A8H,00000000B+OPB1+002H
	 BYTE	  0B7H,00000000B+OPB1+003H,0C6H,00000000B+OPB1+004H
	 BYTE	  0D5H,00000000B+OPB1+005H,0E4H,00000000B+OPB1+006H
	 BYTE	  0EDH,00000000B+WFST+000H
	 BYTE	  0F3H,00000000B+OPB1+007H
;
	 BYTE	  01AH,10000000B+OCO0+00BH,0E3H,00000000B+OPB1+007H  : 3
	 BYTE	  0F3H,00000000B+OPB1+007H
;
	 BYTE	  000H,10000000B+OBK1+00FH
	 BYTE	  031H,00000000B+OPB0+006H,03CH,00000000B+OHL0+002H  : 4
	 BYTE	  077H,00000000B+OPB0+003H,0ACH,00000000B+OHL0+002H
	 BYTE	  0B1H,00000000B+OPB0+006H,0E7H,00000000B+OPB0+003H
	 BYTE	  0FEH,00000001B
;
;	    (point)
	 BYTE	  077H,10000000B+OBK1+009H,0A3H,00000000B+OCO0+003H  : 5
;
	 BYTE	  000H,10000000B+OBK1+00FH,029H,00000000B+OPB0+001H  : 6
	 BYTE	  039H,00000000B+OCO0+008H,061H,00000000B+OPB0+005H
	 BYTE	  0D2H,00000000B+OCO0+004H,0D6H,00000000B+OPB0+004H
;
	 BYTE	  00CH,10000000B+OHL0+002H			     : 7
	 BYTE	  030H,00000000B+OBK1+009H
	 BYTE	  031H,00000000B+OPB1+006H,044H,00000000B+OCO0+007H
	 BYTE	  047H,00000000B+OBK1+002H,04AH,00000000B+OCO0+007H
	 BYTE	  097H,00000000B+OBK1+002H,0C1H,00000000B+OPB1+006H
	 BYTE	  0DCH,00000000B+OHL0+002H
;
	 BYTE	  000H,10000000B+OBK1+00FH
	 BYTE	  00CH,00000000B+OHL0+00FH,008H,00000000B+OCO0+00FH  : 8
	 BYTE	  004H,00000000B+OPB1+003H
	 BYTE	  014H,00000000B+OPB1+003H
	 BYTE	  024H,00000000B+OPB1+003H
	 BYTE	  034H,00000000B+OPB1+003H
	 BYTE	  044H,00000000B+OPB1+003H
	 BYTE	  054H,00000000B+OPB1+003H
	 BYTE	  064H,00000000B+OPB1+003H
	 BYTE	  074H,00000000B+OPB1+003H
	 BYTE	  084H,00000000B+OPB1+003H
	 BYTE	  094H,00000000B+OPB1+003H
	 BYTE	  0A4H,00000000B+OPB1+003H
	 BYTE	  0B4H,00000000B+OPB1+003H
	 BYTE	  0C4H,00000000B+OPB1+003H
	 BYTE	  0D4H,00000000B+OPB1+003H
	 BYTE	  0E4H,00000000B+OPB1+003H
	 BYTE	  0F4H,00000000B+OPB1+003H
;
	 BYTE	  000H,10000000B+OBK1+00FH
	 BYTE	  075H,00000000B+OPB1+000H			     : 9
	 BYTE	  0FEH,00000001B
;
	 BYTE	  00CH,10000000B+OHL0+007H,09AH,00000000B+OPB1+000H  : A
	 BYTE	  0A9H,00000000B+OPB1+001H,0B8H,00000000B+OPB1+002H
	 BYTE	  0C7H,00000000B+OPB1+003H
	 BYTE	  0D0H,00000000B+OPB1+00AH
	 BYTE	  0D5H,00000000B+OWC0+000H
	 BYTE	  0E0H,00000000B+OPB1+00AH
	 BYTE	  0F0H,00000000B+OPB1+00AH
;
	 BYTE	  000H,10000000B+OPB1+00AH
	 BYTE	  06DH,00000000B+EXOF+000H			     : B
	 BYTE	  07DH,00000000B+SCOF+000H
;
	 BYTE	  0FDH
;
;
	 END
