;
		INCLUDE mn_mario_ram.asm
;
;------------------------------------------------------------------------
;
;		Mario Zanmai			1992.12.14(MON)
;
;------------------------------------------------------------------------
;
		ORG	0008000H
;
;========================================================================
		GLB	PPURINT,PS_RESET,ZD_RESET,ROM_ERROR
;
		GLB	CGDATA
;
		GLB	CONTROL_C,DMA_M_M,DMA_D_M
;
		GLB	M1SAVE,M2SAVE,MUSAVE,M3SAVE,SVRMCK
;
		GLB	BGM_SNDTR,BGM_SNDTR1,VOICE_SNDTR,M3_SNDTR1,M3_SNDTR2
;
		GLB	CGDATA,WINDAT0,DIVDAT
;
		GLB	MD_demo
;
;======================================================= (init) ========
		EXT	TITLE_INT,SELECT1,SELECT2,SELECT3,GSINIT
		EXT	WINDON,WINDOFF,MRPLIX
;
		EXT	FADEPLAY,SLINIT,GMRMST,M4SVCLR
;========================================================================
		EXT	DR_MARIO
;========================================================= m4main =======
		EXT	M4SVCK
;========================================================================
;========================================================================
MARIO_1_START	EQU	038000H
MARIO_2_START	EQU	0D8000H
MARIO_USA_START EQU	118000H
MARIO_3_START	EQU	208000H
MARIO_4_START	EQU	308000H
;========================================================================
MARIO_1_NMI	EQU	038003H
MARIO_2_NMI	EQU	0D8003H
MARIO_USA_NMI	EQU	118003H
MARIO_3_NMI	EQU	208003H
MARIO_4_NMI	EQU	308003H
;========================================================================
MARIO_1_IRQ	EQU	038006H
MARIO_2_IRQ	EQU	0D8006H
MARIO_USA_IRQ	EQU	118006H
MARIO_3_IRQ	EQU	208006H
MARIO_4_IRQ	EQU	308006H
;========================================================================
;========================================================================
;========================================================================
;
		EXTEND
		MEM8
		IDX8
;
;
;
;************************************************************************
;*		SFX  Game  Start					*
;************************************************************************
;
;
;===============  System initialize  ====================================
;
		EMULATION
;
GSTART		EQU	$
		SEI				; IRQ disable
;
		CLC
;
		NATIVE
;
		XCE				; Set Native mode
;
		STZ	04200H			; NMI	 "
		STZ	0420CH			; HDMA	 "
		STZ	0420BH			; DMA	 "
		STZ	02140H
		STZ	02141H
		STZ	02142H
		STZ	02143H			; sound port clear
;
		MEM8
;
		LDA	#10000000B
		STA	02100H			; branking on!!
;------------------------------------------------------------------------
;
		MEM16
		IDX16
		REP	#00111000B		; memory,index 16bit mode & BCD mode off
;
;
		LDA	#00000H
		TCD				; (D) <-- #00000H
		LDA	#STACK+0FFH
		TCS				; stack pointer init. set
;
;
		MEM8
		IDX8
		SEP	#00110000B		; momory,index 8bit mode
;
		LDA	#000H
		PHA
		PLB				; (DBR) <-- #000H
;
		LDA	0213FH
		BIT	#00010000B
		BEQ	GST000			; NTSC ?
;						; no
		JMP	PPU_ERROR
;
GST_ERROR	EQU	$
		JMP	>ROM_ERROR
;
CHKDT0		EQU	0AAH
CHKDT1		EQU	055H
BRAMAD		EQU	700000H
IMAGAD		EQU	702000H
;
;
GST000		EQU	$
		JSR	PPURGIT			; PPU register init.
		LDA	#000H
		STA	>ZANMAI_DEMO
		STA	>ZANMAI_FLG
;
		MEM16
		REP	#00100000B		; memory 16bit mode
;
		LDA	#08000H
		STA	!ROM_ADDR
		STA	!ROM_BANK		; rom memory check address init
		STZ	!ROM_NMI
;
;
		MEM8
		SEP	#00100000B		; memory 8bit mode
;
		LDA	#10000001B
		STA	04200H			; NMI enable
;
		STA	MARKCT
;
		JSR	SVRMCK			; Save-ram check
;
		BRA	GST040
		LDA	#CHKDT0
		STA	>IMAGAD
		CMP	>BRAMAD
		BNE	GST_ERROR		; check ok ?
;						; yes
		LDA	#CHKDT1
		STA	>IMAGAD
		CMP	>BRAMAD
		BNE	GST_ERROR		; check ok ?
;						; yes
GST040		EQU	$
;************************************************************************
;*		SFX  Game						*
;************************************************************************
GST100		EQU	$
		LDA	!NMIFLG
		BEQ	GST100			; V-blank NMI?
;						; yes
;;;;;;;;;;;;;;;;;;;		   BRA	   R_M_C_ME
;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;************************************************************************
;;;;;;;;;;;;;;;;;;;;*		   ROM memory check					   *
;;;;;;;;;;;;;;;;;;;;************************************************************************
;;;;;;;;;;;;;;;;;;;R_M_C_MS	   EQU	   $
;;;;;;;;;;;;;;;;;;;		   MEM16
;;;;;;;;;;;;;;;;;;;		   IDX16
;;;;;;;;;;;;;;;;;;;		   REP	   #00110000B		   ; memory,index 16bit mode
;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;		   PHB				   ; (DBR) push
;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;		   LDX	   !ROM_ADDR		   ; (X) <-- rom address
;;;;;;;;;;;;;;;;;;;		   LDY	   !ROM_BANK		   ; (Y) <-- rom bank
;;;;;;;;;;;;;;;;;;;R_M_C_000	   EQU	   $
;;;;;;;;;;;;;;;;;;;		   PHY
;;;;;;;;;;;;;;;;;;;		   PLB				   ; 00~3F(DBR) set
;;;;;;;;;;;;;;;;;;;		   LDA	   0,X			   ; 00bank rom-data
;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;		   PLB				   ; 80~BF(DBR) set
;;;;;;;;;;;;;;;;;;;		   CMP	   0,X			   ; 80bank rom-data
;;;;;;;;;;;;;;;;;;;		   BEQ	   R_M_C_100		   ; memory ok ?
;;;;;;;;;;;;;;;;;;;;						   ; no
;;;;;;;;;;;;;;;;;;;		   SEP	   #00110000B		   ; memory,index 8bit mode
;;;;;;;;;;;;;;;;;;;		   JMP	   >ROM_ERROR
;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;R_M_C_100	   EQU	   $
;;;;;;;;;;;;;;;;;;;		   INX
;;;;;;;;;;;;;;;;;;;		   INX
;;;;;;;;;;;;;;;;;;;		   BNE	   R_M_C_200		   ; next ROM_bank ?
;;;;;;;;;;;;;;;;;;;;						   ; yes
;;;;;;;;;;;;;;;;;;;		   LDX	   #08000H
;;;;;;;;;;;;;;;;;;;		   TYA
;;;;;;;;;;;;;;;;;;;		   ADC	   #00100H
;;;;;;;;;;;;;;;;;;;		   AND	   #0BF3FH
;;;;;;;;;;;;;;;;;;;		   TAY
;;;;;;;;;;;;;;;;;;;R_M_C_200	   EQU	   $
;;;;;;;;;;;;;;;;;;;		   LDA	   >NMIFLG
;;;;;;;;;;;;;;;;;;;		   BEQ	   R_M_C_000		   ; V-blank NMI?
;;;;;;;;;;;;;;;;;;;;						   ; yes
;;;;;;;;;;;;;;;;;;;		   PLB				   ; (DBR) pull
;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;		   STX	   !ROM_ADDR
;;;;;;;;;;;;;;;;;;;		   STY	   !ROM_BANK
;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;		   MEM8
;;;;;;;;;;;;;;;;;;;		   IDX8
;;;;;;;;;;;;;;;;;;;		   SEP	   #00110000B		   ; memory,index 16bit mode
;;;;;;;;;;;;;;;;;;;R_M_C_ME	   EQU	   $
;;;;;;;;;;;;;;;;;;;;
;
		JSR	CONT2			; KEY input
;
		CLI				; IRQ "on"
;
		INC	<FCNT			; frame count+1
;
		LDX	<SLMODE
		LDA	OCLCKD,X
		BEQ	GST140			; OAM clear ok ?
;						; yes
		JSR	OAMCLR			; OAM clear
GST140		EQU	$
		JSL	>MAIN_P			; main program
;
		LDX	<SLMODE
		LDA	OCLCKD,X
		BEQ	GST180			; OAM clear ok ?
;						; yes
		JSR	OAMCHG			; OAM sub. set
GST180		EQU	$
		STZ	!NMIFLG			; NMI flag clear!!
		JMP	GST100
;
;
;************************************************************************
;*		Main  Program						*
;************************************************************************
MAINPL		EQU	$
game0		BYTE	LOW TITLE_INT		; 0 : title
		BYTE	LOW GSINIT		; 1 : select-inital
;;;;;;;;		BYTE	LOW SELECT1
		BYTE	LOW SELECT2
		BYTE	LOW WINDON
		BYTE	LOW SELECT3
		BYTE	LOW WINDOFF
		BYTE	LOW FADEPLAY
		BYTE	LOW SNDTRNS
		BYTE	LOW GAME_JUMP
g_demo		BYTE	LOW DM_GM_JUMP
		BYTE	LOW DR_MARIO
;
MAINPH		EQU	$
		BYTE	HIGH TITLE_INT
		BYTE	HIGH GSINIT
;;;;;;;;		BYTE	HIGH SELECT1
		BYTE	HIGH SELECT2
		BYTE	HIGH WINDON
		BYTE	HIGH SELECT3
		BYTE	HIGH WINDOFF
		BYTE	HIGH FADEPLAY
		BYTE	HIGH SNDTRNS
		BYTE	HIGH GAME_JUMP
		BYTE	HIGH DM_GM_JUMP
		BYTE	HIGH DR_MARIO
;
MAINPB		EQU	$
		BYTE	BANK TITLE_INT
		BYTE	BANK GSINIT
;;;;;;;;		BYTE	BANK SELECT1
		BYTE	BANK SELECT2
		BYTE	BANK WINDON
		BYTE	BANK SELECT3
		BYTE	BANK WINDOFF
		BYTE	BANK FADEPLAY
		BYTE	BANK SNDTRNS
		BYTE	BANK GAME_JUMP
		BYTE	BANK DM_GM_JUMP
		BYTE	BANK DR_MARIO
;
MD_game0	EQU	(game0-game0)
;
MD_demo		EQU	(g_demo-game0)
;
;
MAIN_P		EQU	$
		LDX	<SLMODE
		LDA	>MAINPL,X
		STA	<WORK3
		LDA	>MAINPH,X
		STA	<WORK4
		LDA	>MAINPB,X
		STA	<WORK5
		JML	(WORK3)
;
;
;
;
;************************************************************************
;*		Pause Reset				(PS_RESET)	*
;************************************************************************
PS_RESET	EQU	$
		JSL	>BLANKING		; blanking on
;
		STZ	04200H			; NMI disable
;
		LDA	#000H
		PHA
		PLB				; (DBR) <-- #000H
;
		SEI				; IRQ	disable
		STZ	04200H			; NMI	disable
		STZ	0420CH			; H-DMA disable
;
		MEM16
		REP	#00100000B		; memory 16bit mode
;
		LDA	#STACK+0FFH
		TCS				; stack pointer init. set
;
		MEM8
		SEP	#00100000B		; memory 8bit mode
;
		STZ	<SOUND0
		STZ	<SOUND1
		STZ	<SOUND2
		STZ	<SOUND3
		STZ	02140H
		STZ	02141H
		STZ	02142H
		STZ	02143H			; sound port clear
		LDA	#0F0H
		STA	02141H
		JSR	PPURGIT			; PPU register init.
;;;;;;;;		LDA	#1
;;;;;;;;		STA	<SLMODE
;;;;;;;;		LDA	#004H
;;;;;;;;		STA	<GMMODE
;;;;;;;;		LDA	#001H
;;;;;;;;		STA	!IRQSWFG
;;;;;;;;		LDA	#000H
;;;;;;;;		STA	>ZANMAI_FLG		; zanmai demo flag clear
;;;;;;;;		STA	>GAME_NO		; game no. reset
;
		STZ	<SLMODE
		LDA	#003H
		STA	<GMMODE
		LDA	#00000001B
		STA	!WD2100
		LDA	#001H
		STA	!IRQSWFG
		LDA	#000H
		STA	>ZANMAI_FLG		; zanmai demo flag clear
		STA	>GAME_NO		; game no. reset
;
		LDA	#10000001B
		STA	04200H			; NMI enable
		STA	MARKCT
		JMP	GST100
;
;
;
;
;************************************************************************
;*		Zanmai-demo Reset			(ZD_RESET)	*
;************************************************************************
ZD_RESET	EQU	$
		JSL	>BLANKING		; blanking on
;
		STZ	04200H			; NMI disable
;
		LDA	#000H
		PHA
		PLB				; (DBR) <-- #000H
;
		SEI				; IRQ	disable
		STZ	04200H			; NMI	disable
		STZ	0420CH			; H-DMA disable
;
		MEM16
		REP	#00100000B		; memory 16bit mode
;
		LDA	#STACK+0FFH
		TCS				; stack pointer init. set
;
		MEM8
		SEP	#00100000B		; memory 8bit mode
;
		STZ	<SOUND0
		STZ	<SOUND1
		STZ	<SOUND2
		STZ	<SOUND3
		STZ	02140H
		STZ	02141H
		STZ	02142H
		STZ	02143H			; sound port clear
		LDA	#0F0H
		STA	02141H
		JSR	PPURGIT			; PPU register init.
;
		STZ	<SLMODE
		LDA	#003H
		STA	<GMMODE
		LDA	#00000001B
		STA	!WD2100
		LDA	#001H
		STA	!IRQSWFG
		LDA	#000H
		STA	>ZANMAI_FLG		; zanmai demo flag clear
		STA	>GAME_NO		; game no. reset
;
		LDA	#10000001B
		STA	04200H			; NMI enable
		STA	MARKCT
		JMP	GST100
;
;
;
;
;
;************************************************************************
;*		Game jump				(GAME_JUMP)	*
;************************************************************************
GAME_TBLL	EQU	$
		BYTE	LOW MARIO_1_START
		BYTE	LOW MARIO_2_START
		BYTE	LOW MARIO_USA_START
		BYTE	LOW MARIO_3_START
		BYTE	LOW MARIO_4_START
GAME_TBLH	EQU	$
		BYTE	HIGH MARIO_1_START
		BYTE	HIGH MARIO_2_START
		BYTE	HIGH MARIO_USA_START
		BYTE	HIGH MARIO_3_START
		BYTE	HIGH MARIO_4_START
GAME_TBLB	EQU	$
		BYTE	BANK MARIO_1_START
		BYTE	BANK MARIO_2_START
		BYTE	BANK MARIO_USA_START
		BYTE	BANK MARIO_3_START
		BYTE	BANK MARIO_4_START
;
;
GAME_JUMP	EQU	$
		LDX	#0FH
GALOOP		EQU	$
		LDA	<URADAT,X
		STA	>URADAT2,X
		DEX
		BPL	GALOOP
;
		LDA	<PLAYNO
		STA	>PLNOWK
		LDA	<GAMENO
		STA	>GMNOWK
;
		MEM16
		REP	#00100000B		; memory 16bit mode
;
		LDA	#800000H-7F0000H
		STA	<WORK0			; number of byte
		LDA	#00000H
		LDY	#07FH			; to memory address
		JSL	>DMA_D_M0		; ram clear (7F0000H~7FFFFFH)
;
		MEM8
		SEP	#00100000B		; memory 8bit mode
;
		LDA	<GAMENO
		TAX
		INC	A
		ASL	A
		STA	>GAME_NO
		LDA	>GAME_TBLL,X
		STA	<WORK3
		LDA	>GAME_TBLH,X
		STA	<WORK4
		LDA	>GAME_TBLB,X
		STA	<WORK5
;
		MEM16
		REP	#00100000B		; memory 16bit mode
;
		LDA	#000100H-000010H
		STA	<WORK0			; number of byte
		LDA	#00010H
		LDY	#000H			; to memory address
		JSL	>DMA_D_M0		; ram clear (000010H~0000FFH)
;
		LDA	#002000H-000200H
		STA	<WORK0			; number of byte
		LDA	#00200H
		LDY	#000H			; to memory address
		JSL	>DMA_D_M0		; ram clear (000200H~001FFFH)
;
		MEM8
		SEP	#00100000B		; memory 8bit mode
;
		PLB
		PLB
		PLB
;
		JSL	>GMRMST
;
		LDA	#000H
		STA	>NOW_BSLFG
		STA	>NOW_CORSNO
;
;
		IDX16
		MEM16
		REP	#30H
		LDA	>SVINDX
		TAX
		MEM8
		SEP	#20H
		LDA	>MR1PLA,X
		STA	>SVCORS
		IDX8
		SEP	#10H
;
		JML	(WORK3)
;
;
;
;************************************************************************
;*		Demo-Game jump				(DM_GM_JUMP)	*
;************************************************************************
DM_GM_JUMP	EQU	$
		SEI				; IRQ	disable
		STZ	04200H			; NMI	disable
		STZ	0420CH			; H-DMA disable
;
		STZ	<GMMODE
		STZ	<DEMOTIME
		LDA	#10000000B
		STA	02100H
		STA	!WD2100			; blanking on!!
		STZ	!WD420C			; H-DMA disable
;
		LDA	>ZANMAI_DEMO
		PHA				; (A) push
;
		INC	A
;;;;;;;;;;;;;;;;;;		  AND	  #00001111B
;93/07/15;;;;		AND	#00000011B
		CMP	#00000101B
		BCC	D_G_J_020		;
;						;
		LDA	#00000000B
D_G_J_020	EQU	$
		STA	>ZANMAI_DEMO
		STZ	<PLAYNO
		LDA	#001H
		STA	>ZANMAI_FLG
;
		LDX	#0FH
D_G_J_040	EQU	$
		LDA	<URADAT,X
		STA	>URADAT2,X
		DEX
		BPL	D_G_J_040
;
		PLA				; (A) pull
		STA	<WORK0
;;;;;;;;;;;;;;;;;;		  AND	  #00000011B
		TAX
;;;;;;;;;;;;;;;;;;		INC	A
;;;;;;;;;;;;;;;;;;		ASL	A
;;;;;;;;;;;;;;;;;;		STA	>GAME_NO
		PHX				; (X) push
;
		CPX	#004H
		BNE	D_G_J_060		; mario-world ?
;						; yes
		STZ	02140H
		STZ	02142H
		STZ	02143H			; sound port clear
;
		JSR	M4_SNDTR		; sound transfer
D_G_J_060	EQU	$
		PLX				; (X) pull
		LDA	>GAME_TBLL,X
		STA	<WORK3
		LDA	>GAME_TBLH,X
		STA	<WORK4
		LDA	>GAME_TBLB,X
		STA	<WORK5
;
		MEM16
		REP	#00100000B		; memory 16bit mode
;
;;;;;;;;;;;;;;;;;;		  LDA	  <WORK0
;;;;;;;;;;;;;;;;;;		  ASL	  A
;;;;;;;;;;;;;;;;;;		  TAX
;;;;;;;;;;;;;;;;;;		  LDA	  >MRPLIX,X
;;;;;;;;;;;;;;;;;;		  STA	  >SVINDX		  ; save index off
;
		LDA	#000100H-000010H
		STA	<WORK0			; number of byte
		LDA	#00010H
		LDY	#000H			; to memory address
		JSL	>DMA_D_M0		; ram clear (000010H~0000FFH)
;
		LDA	#002000H-000200H
		STA	<WORK0			; number of byte
		LDA	#00200H
		LDY	#000H			; to memory address
		JSL	>DMA_D_M0		; ram clear (000200H~001FFFH)
;
		LDA	#800000H-7F0000H
		STA	<WORK0			; number of byte
		LDA	#00000H
		LDY	#07FH			; to memory address
		JSL	>DMA_D_M0		; ram clear (7F0000H~7FFFFFH)
;
		CPX	#004H
		BNE	D_G_J_070		; mario-world ?
;						; yes
		LDA	#0FFFFH
		STA	>VRAMD2
D_G_J_070	EQU	$
		MEM8
		SEP	#00100000B		; memory 8bit mode
;
		TXA
		INC	A
		ASL	A
		STA	>GAME_NO
;
		PLB
		PLB
		PLB
;
;;;;;;;;;;;;;;;;;;		  JSL	  >GMRMST
		MEM16
		IDX16
		REP	#00110000B		; memory,index 16bit mode
;
		LDA	<WORK0
		AND	#00003H
		ASL	A
		TAX
		LDA	MRZIDX,X
		TAY
		LDX	#00000H
		TXA
;
		MEM8
		SEP	#00100000B		; memory 8bit mode
D_G_J_080	EQU	$
		LDA	MR1DAT,Y
		STA	>SAVEBF,X
		INY
		INX
		CPX	#MR1PLB-MR3PLA
		BNE	D_G_J_080		;
;						;
		LDA	#000H
		STA	>SAVEBF
		STA	>SAVEBF+1
;
		MEM8
		IDX8
		SEP	#00110000B		; memory,index 8bit mode
;
		JML	(WORK3)
;
;
;
;
;
;************************************************************************
;*		NMI  Routine				(INTSUB)	*
;************************************************************************
NMITABLE	EQU	$
		WORD	NMI0000			; 00 : title & select
		WORD	NMI1000			; 02 : mario-1
		WORD	NMI2000			; 04 : mario-2
		WORD	NMI3000			; 06 : mario-USA
		WORD	NMI4000			; 08 : mario-3
		WORD	NMI5000			; 0A : mario-4
;
;
INTSUB		EQU	$
		SEI				; IRQ disable
;
		MEM16
		IDX16
		REP	#00110000B		; memory,index 16bit mode
;
		PHA				; (A) push
		PHX				; (X) push
		PHY				; (Y) push
		PHD				; (D) push
		LDA	#00000H
		TCD				; (D) <-- #00000H
		PHB
		PHK
		PLB				; (DBR) set
		LDA	<WORK0
		PHA				; (work0) push
;
		MEM8
		IDX8
		SEP	#00110000B		; memory,index 8bit mode
;
;
		LDA	>GAME_NO
		TAX
		JSR	(NMITABLE,X)
;
		REP	#00110000B		; memory,index 16bit mode
;
		PLA
		STA	!WORK0			; (work0) pull
		PLB				; (DBR) reset
		PLD				; (D) pull
		PLY				; (Y) pull
		PLX				; (X) pull
		PLA				; (A) pull
RTISUB		EQU	$
		RTI
;
;
;
;===============================================; NMI-00
NMI0000		EQU	$
		LDA	#HIGH WD2100
		XBA
		LDA	#000H
		TCD				; (D) <-- #WD2100&0FF00H
;
		LDA	04210H			; NMI status reset!!
;
		LDA	<WD2100
		STA	02100H			; blanking on
		STZ	0420CH			; H-DMA disable
;
		LDA	<NMIFLG
		BNE	NMI0040			; NMI flag on ?
;						; no
		INC	<NMIFLG			; NMI flag on
;
;---------------  DMA  --------------------------------------------------
		PHD				; (D) push
;
		JSR	DMAVMA			; character DMA & VMA
		SEP	#00110000B		; memory,index 8bit mode
;
		PLD				; (D) pull
NMI0040		EQU	$
		JSR	PPURGST			; PPU register set
;
		JSR	SNDPORT			; sound port set
;
;---------------  Part Scroll  ------------------------------------------
		LDX	#10000001B
		LDA	<IRQSWFG
		BEQ	NMI0080			; IRQ swich on ?
;						; yes
		AND	#11111110B
		STA	<NMIIRQFG
;
		LDA	04211H			; IRQ reset
		LDA	<IRQVCT
		STA	04209H			; V counter-L
		STZ	0420AH			;	    H
		STZ	04207H
		STZ	04208H			; H counter off
;
;;K;;		STZ	<IRQSWFG
		LDX	#10100001B
NMI0080		EQU	$
		STX	04200H			; V-part_scroll on/off
;
		LDA	<WD2100
		STA	02100H			; blanking on
		LDA	<WD420C
		STA	0420CH
		RTS
;
;
;
;===============================================; NMI-00
NMI1000		EQU	$
		JSL	>MARIO_1_NMI
		RTS
;
;===============================================; NMI-00
NMI2000		EQU	$
		JSL	>MARIO_2_NMI
		RTS
;
;===============================================; NMI-00
NMI3000		EQU	$
		JSL	>MARIO_USA_NMI
		RTS
;
;===============================================; NMI-00
NMI4000		EQU	$
		JSL	>MARIO_3_NMI
		RTS
;
;===============================================; NMI-00
NMI5000		EQU	$
		JSL	>MARIO_4_NMI
		RTS
;
;
;
;
;
;
;
;************************************************************************
;*		IRQ  Routine				(IRQSUB)	*
;************************************************************************
IRQTABLE	EQU	$
		WORD	IRQ0000			; 00 : normal
		WORD	IRQ1000			; 02 : mario-1
		WORD	IRQ2000			; 02 : mario-2
		WORD	IRQ3000			; 02 : mario-USA
		WORD	IRQ4000			; 02 : mario-3
		WORD	IRQ5000			; 02 : mario-4
;
;
IRQSUB		EQU	$
		MEM16
		IDX16
		REP	#00110000B		; memory,index 16bit mode
;
		PHA				; (A) push
		PHX				; (X) push
		PHY				; (Y) push
		PHD				; (D) push
		LDA	#00000H
		TCD				; (D) <-- #00000H
		PHB
		PHK
		PLB				; (DBR) set
;
		MEM8
		IDX8
		SEP	#00110000B		; memory,index 8bit mode
;
;;;;;;;;		LDA	04211H
;;;;;;;;		BPL	IRQS80			; part_scroll ?
;;;;;;;;;						; yes
		LDA	>GAME_NO
		TAX
		JSR	(IRQTABLE,X)
IRQS80		EQU	$
		REP	#00110000B		; memory,index 16bit mode
;
		PLB				; (DBR) reset
		PLD				; (D) pull
		PLY				; (Y) pull
		PLX				; (X) pull
		PLA				; (A) pull
		RTI
;
;
;
;===============================================; IRQ-00
IRQ0000		EQU	$
		LDA	4211H
		BPL	IRQ0100
IRQ0050		EQU	$
		BIT	4212H
		BVC	IRQ0050		; H-DMA on ?
;					; yes
;;K;;		LDA	#10000000B
;;K;;		STA	2100H
;
		LDA	!SCHV10
		STA	210DH
		LDA	!SCHV11
		STA	210DH
IRQ0100		EQU	$
		RTS
;
;
;===============================================; IRQ-00
IRQ1000		EQU	$
		JSL	>MARIO_1_IRQ
		RTS
;
;
;===============================================; IRQ-00
IRQ2000		EQU	$
		JSL	>MARIO_2_IRQ
		RTS
;
;
;===============================================; IRQ-00
IRQ3000		EQU	$
		JSL	>MARIO_USA_IRQ
		RTS
;
;
;===============================================; IRQ-00
IRQ4000		EQU	$
		JSL	>MARIO_3_IRQ
		RTS
;
;
;===============================================; IRQ-00
IRQ5000		EQU	$
		JSL	>MARIO_4_IRQ
		RTS
;
;
;
;
;
;
;
;
;
		MEM8
		IDX8
;************************************************************************
;*		PPU register initial			(PPURGIT)	*
;************************************************************************
PPURGIT		EQU	$
		JSR	TITLE_SNDTR		; title sound transfer
PPURGIT_0	EQU	$
		MEM16
		REP	#00100000B		; memory 16bit mode
;
		LDA	#00150H-00000H
		STA	<WORK0			; number of byte
		LDA	#00000H
		TAY				; to memory address
		JSL	>DMA_D_M0		; ram clear (00000H~0014FH)
;
		LDA	#02000H-00200H
		STA	<WORK0			; number of byte
		LDA	#00200H
		TAY				; to memory address
		JSL	>DMA_D_M0		; ram clear (00200H~01FFFH)
;
		LDA	#7F0000H-7E2000H
		STA	<WORK0			; number of byte
		LDA	#02000H
		LDY	#07EH			; to memory address
		JSL	>DMA_D_M0		; ram clear (7E2000H~7EFFFFH)
;
		LDA	#800000H-7F0000H
		STA	<WORK0			; number of byte
		LDA	#00000H
		LDY	#07FH			; to memory address
		JSL	>DMA_D_M0		; ram clear (7F0000H~7FFFFFH)
;
;
		LDA	#00000H
		STA	>VRAMD
		DEC	A
		STA	>VRAMD2			; vram init. off
;
		MEM8
		SEP	#00100000B		; memory 8bit mode
;
		LDX	#00000000B
		JSL	>PPURINT		; PPU register init.
;
		PHD				; (D) push
		LDA	#HIGH WD2100
		XBA
		LDA	#000H
		TCD				; (D) <-- #WD2100
;
		STZ	02133H			; display init. set
;
;;;;;;;;		STZ	<WD211A
;;;;;;;;		STZ	<WD211B
;;;;;;;;		STZ	<WD211B+1
;;;;;;;;		STZ	<WD211C
;;;;;;;;		STZ	<WD211C+1
;;;;;;;;		STZ	<WD211D
;;;;;;;;		STZ	<WD211D+1
;;;;;;;;		STZ	<WD211E
;;;;;;;;		STZ	<WD211E+1
;;;;;;;;		STZ	<WD211F
;;;;;;;;		STZ	<WD211F+1
;;;;;;;;		STZ	<WD2120
;;;;;;;;		STZ	<WD2120+1
;
;;;;;;;;		STZ	<WD420C
;
		JSR	PPURGST			; PPU register set
;
;
		PLD				; (D) pull
;
		LDA	#001H
		STA	>CGDMAF
		RTS
;
;
;
;
;************************************************************************
;*		PPU register set			(PPURGST)	*
;************************************************************************
PPURGST		EQU	$
		IDX16
		REP	#00010000B		; index 16bit mode
;
		LDA	<WD2101
		STA	02101H			; OBJ. size&address
;
		LDX	<WD2107
		STX	02107H			; BG.1 size&address
;;;;;;;;		LDA	<WD2108
;;;;;;;;		STA	02108H			; BG.2
		LDA	<WD2109
		STA	02109H			; BG.3 size&address
;
		LDA	<WD210B
		STA	0210BH			; BG.1 character address
;
		LDA	<SCCH1
		STA	0210DH
		LDA	<SCCH11
		STA	0210DH			; BG.1 H-scroll count
		LDA	<SCCV1
		STA	0210EH
		LDA	<SCCV11
		STA	0210EH			; BG.1 V
;
		LDA	<SCCH2
		STA	0210FH
		LDA	<SCCH21
		STA	0210FH			; BG.2 H-scroll count
		LDA	<SCCV2
		STA	02110H
		LDA	<SCCV21
		STA	02110H			; BG.2 V
;
		LDA	<SCCH3
		STA	02111H
		LDA	<SCCH31
		STA	02111H			; BG.3 H-scroll count
		LDA	<SCCV3
		STA	02112H
		LDA	<SCCV31
		STA	02112H			; BG.3 V
;
;
;;;;;;;;		LDA	<WD2109
;;;;;;;;		STA	02109H			; offset BASE address
;;;;;;;;		LDA	<OFFSCTL
;;;;;;;;		STA	02111H
;;;;;;;;		STZ	02111H
;;;;;;;;		LDA	<OFFSCTH
;;;;;;;;		STA	02112H			; offset address
;;;;;;;;		STZ	02112H
;
		LDA	<WD2132R
		STA	02132H
		LDA	<WD2132G
		STA	02132H
		LDA	<WD2132B
		STA	02132H			; color set
;
		LDX	<DPMAIN
		STX	0212CH			; display select main
;;;;;;;;		LDA	<DPSUB
;;;;;;;;		STA	0212DH			;		 sub
;
		LDX	<WD212E
		STX	0212EH			; window display main
;;;;;;;;		LDA	<WD212F
;;;;;;;;		STA	0212FH			;		 sub
;
		LDX	<WD2123
		STX	02123H
;;;;;;;;		LDA	<WD2124
;;;;;;;;		STA	02124H
		LDA	<WD2125
		STA	02125H			; window on/off set
;
		LDX	<WD2130
		STX	02130H			; color window on/off set
;;;;;;;;		LDA	<WD2131
;;;;;;;;		STA	02131H			; add.&sub. set
;
		LDX	<WD2105
		STX	02105H			; BG. mode& char. size set & mozaiku set
;;;;;;;;		LDA	<WD2106
;;;;;;;;		STA	02106H			; mozaiku set
;
		IDX8
		SEP	#00010000B		; index 8bit mode
		RTS
;
;
;
;
;
;
;
;************************************************************************
;*		PPU register init.			(PPURINT)	*
;*		[in]	(X)  <--   game no.				*
;*					00 : title			*
;*					01 : player-select		*
;*					02 : map			*
;*					03 : field			*
;*					04 : animetion			*
;*					05 :				*
;*					06 :				*
;*					07 :				*
;*					08 :				*
;*					09 :				*
;*					0A :				*
;*					0B :				*
;*					0C :				*
;*					0D :				*
;*					0E :				*
;*					0F :				*
;************************************************************************
PPURINT		EQU	$
		JSL	>BLANKING		; blanking on
;
		PHD				; (D) push
		LDA	#HIGH WD2100
		XBA
		LDA	#000H
		TCD				; (D) <-- #HIGH WD2100
;
		TXA
		BEQ	PAS010
		LDA	#001H
		STA	!IRQSWFG
		LDA	#037H
		STA	!IRQVCT
;
		PHB
		PHX
		MEM16
		IDX16
		REP	#00110000B		; memory , index 16bit mode
		LDA	>GAMENO
		AND	#00007H
		ASL	A
		TAX
		LDA	VUVUNDT,X
		STA	!SCHV10
;
		LDX	#0C000H
		LDY	#SLDTBF
		LDA	#00FFFH
		MVN	#00CH,#BANK SLDTBF
		MEM8
		IDX8
		SEP	#00110000B		; memory , index 8bit mode
		PLX
		PLB
;
PAS010		EQU	$
		LDA	SCVDTL,X
		STA	<SCCV1
		LDA	SCVDTH,X
		STA	<SCCV11
;
		LDA	SD2101,X
		STA	<WD2101			; OBJ. size&address
;
		LDA	SD2105,X
		STA	<WD2105			; BG. mode[1] & char. size set
		STZ	<WD2106			; mozaiku off
;
		LDA	SD2107,X
		STA	<WD2107			; BG.1 size&address
		LDA	SD2108,X
		STA	<WD2108			; BG.2
		LDA	SD2109,X
		STA	<WD2109			; BG.3
;
		LDA	SD210B,X
		STA	<WD210B			; BG.1,2 character address set
		LDA	SD210C,X
		STA	0210CH			; BG.3
;
		LDA	#00100000B
		STA	<WD2132R
		ASL	A
		STA	<WD2132G
		ASL	A
		STA	<WD2132B		; R.G.B. init.
;
		LDA	SD212C,X
		STA	<DPMAIN			; display select main
		LDA	SD212D,X
		STA	<DPSUB			;		 sub
;
		LDA	SD2130,X
		STA	<WD2130			; color window on/off set
		LDA	SD2131,X
		STA	<WD2131			; add.&sub. set
;
		STZ	<WD212E			; window display main
		STZ	<WD212F			;		 sub
;
		STZ	<WD2123
		STZ	<WD2124
		STZ	<WD2125			; window on/off set
;
		MEM16
		REP	#00100000B		; memory 16bit mode
;
;
		LDA	#04300H&0FF00H
		TCD				; (D) <-- #04300H&0FF00H
;
		JSR	CHRIDMA			; character initial DMA
;
		PLD				; (D) pull
;
;
		TXA
		AND	#000FFH
		ASL	A
		TAX
;
		LDA	#000200H
		STA	<WORK0			; number of byte
		LDA	CGDATA,X
		LDY	#03CH
		STA	<WORK2
		STY	<WORK4			; from memory address
		LDA	#CGWORK
		LDY	#BANK CGWORK		; to memory address
		JSL	>DMA_M_M		; CGWORK set
PPURI40		EQU	$
		MEM8
		SEP	#00100000B		; memory 8bit mode
		RTL
;
;
VUVUNDT		EQU	$
		WORD	00000H,00060H,000C0H,001120H,00190H
;
;
		MEM16
;************************************************************************
;*		Character init. DMA			(CHRIDMA)	*
;************************************************************************
CHIDTBL		EQU	$
		WORD	CHDMA000		; 0 : title
		WORD	CHDMA100		; 1 : game select
;
;
;
CHRIDMA		EQU	$
		PHX				; (X) push
;
		LDY	#10000000B
		STY	02115H			; inc mode
		LDA	#01801H
		STA	<04300H			; B-bus addess & control paramater
		LDY	#00000001B
;
		TXA
		ASL	A
		TAX
		JSR	(CHIDTBL,X)
;
		PLX				; (X) pull
		RTS
;
;
;cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
;c		title character DMA			(CHDMA000)	c
;cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
CHDMA000	EQU	$
		LDA	#00000H
		STA	02116H			; Vram address set
		LDA	#018000H
		STA	<04302H			; A-bus address (L,H)
		LDX	#BANK 018000H
		STX	<04304H			;		(B)
		LDA	#08000H
		STA	<04305H			; data count
		STY	0420BH			; BG.1 charactre DMA
;
		LDA	#03DC000H
		STA	<04302H			; A-bus address (L,H)
		LDX	#BANK 03DC000H
		STX	<04304H			;		(B)
		LDA	#02000H
		STA	<04305H			; data count
		STY	0420BH			; BG.1 charactre DMA
;
;
		LDA	#07000H
		STA	02116H
		LDA	#007E800H
		STA	<04302H			; A-bus address (L,H)
		LDX	#BANK 007E800H
		STX	<04304H			;		(B)
		LDA	#00800H
		STA	<04305H			; data count
		STY	0420BH			; BG.2 charactre DMA
;
;
		LDA	#06000H
		STA	02116H
		LDA	#005F000H
		STA	<04302H			; A-bus address (L,H)
		LDX	#BANK 005F000H
		STX	<04304H			;		(B)
		LDA	#01000H
		STA	<04305H			; data count
		STY	0420BH			; OBJ. charactre DMA
;
		LDA	#07800H
		STA	02116H			; Vram address set
		LDA	#07F000H
		STA	<04302H			; A-bus address (L,H)
		LDX	#BANK 07F000H
		STX	<04304H			;		(B)
		LDA	#00800H
		STA	<04305H			; data count
		STY	0420BH			; BG.2 screen DMA
;
		LDA	#07C00H
		STA	02116H			; Vram address set
		LDA	#3C8000H
		STA	<04302H			; A-bus address (L,H)
		LDX	#BANK 3C8000H
		STX	<04304H			;		(B)
		LDA	#00800H
		STA	<04305H			; data count
		STY	0420BH			; BG.1 screen DMA
		RTS
;
;
;cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
;c		select character DMA			(CHDMA100)	c
;cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
CHDMA100	EQU	$
		LDA	#00000H
		STA	02116H			; Vram address set
		LDA	#0488000H
		STA	<04302H			; A-bus address (L,H)
		LDX	#BANK 0488000H
		STX	<04304H			;		(B)
		LDA	#08000H
		STA	<04305H			; data count
		STY	0420BH			; BG.1 charactre DMA
;
		LDA	#0498000H
		STA	<04302H			; A-bus address (L,H)
		LDX	#BANK 0498000H
		STX	<04304H			;		(B)
		LDA	#05800H
		STA	<04305H			; data count
		STY	0420BH			; BG.1 charactre DMA
;
		LDA	#06C00H
		STA	02116H			; Vram address set
		LDA	#07F000H
		STA	<04302H			; A-bus address (L,H)
		LDX	#BANK 07F000H
		STX	<04304H			;		(B)
		LDA	#00800H
		STA	<04305H			; data count
		STY	0420BH			; BG.2 screen(wipe) DMA
;
		LDA	#07000H
		STA	02116H			; Vram address set
		LDA	#03DA800H
		STA	<04302H			; A-bus address (L,H)
		LDX	#BANK 03DA800H
		STX	<04304H			;		(B)
		LDA	#00800H
		STA	<04305H			; data count
		STY	0420BH			; BG.2 charactre DMA
;
		LDA	#07800H
		STA	02116H			; Vram address set
		LDA	#0CC000H
		STA	<04302H			; A-bus address (L,H)
		LDX	#BANK 0CC000H
		STX	<04304H			;		(B)
		LDA	#01000H
		STA	<04305H			; data count
		STY	0420BH			; BG.1 screen(select) DMA
		RTS
;
;
;
;
;
;
;
		MEM16
		IDX8
;************************************************************************
;*		Memory DMA ( block transfer )				*
;*		[in]	(A),(Y)		<-- to memory address		*
;*			(work0,1)	<-- number of byte		*
;*			(work2,3,4)	<-- from memory address		*
;************************************************************************
DMA_M_M		EQU	$
		STA	02181H
		STY	02183H			; to memory address set
;
		LDA	#00000000B+(080H*100H)
		STA	04300H			; DMA parameter & B bus address set
		LDA	<WORK2
		STA	04302H			; A-bus address (L,H)
		LDY	<WORK4
		STY	04304H			;		(B)
		LDA	<WORK0
		STA	04305H			; number of byte set
;
		LDY	#00000001B
		STY	420BH			; DMA "on"
		RTL
;
;
;
;************************************************************************
;*		Memory DMA ( 1 byte data fill )				*
;*		[in]	(A),(Y)		<-- to memory address		*
;*			(work0,1)	<-- number of byte		*
;*			(work2)		<-- fill 1 byte data		*
;************************************************************************
DMA_D_M0	EQU	$
		STZ	<WORK2			; zero clear
DMA_D_M		EQU	$
		STA	04302H			; A-bus address (L,H)
		STY	04304H			;		(B)
		LDA	#10000000B+(034H*100H)
		STA	04300H			; DMA parameter & B bus address set
		LDA	<WORK0
		STA	04305H			; number of byte set
;
		LDY	#001H
		STY	0211BH
		DEY
		STY	0211BH
		LDY	<WORK2
		STY	0211CH			; (work2)*1
;
		LDY	#00000001B
		STY	0420BH			; DMA "on"
		RTL
;
;
;
;
		MEM8
		IDX8
;************************************************************************
;*		Controlor check				(CONTROL_C)	*
;************************************************************************
CONTROL_C	EQU	$
		LDA	04016H
		AND	#00000001B
		EOR	#00000001B
		ASL	A
		STA	>P_KEYMD0		; 1player controlor mode
;
		LDA	04017H
		AND	#00000001B
		ASL	A
		STA	>P_KEYMD1		; 2player controlor mode
		RTL
;
;
;
;
		MEM8
		IDX8
;************************************************************************
;*		Key input				(CONT2)		*
;*									*
;*		[KEYA1] ---> BYssudlr		   <X>			*
;*						<Y>   <A>		*
;*		[KEYA1L] --> AXLR		   <B>			*
;*									*
;************************************************************************
CONT2		EQU	$
		STZ	4016H
;
		LDA	4218H			; 1P contoroler
		STA	<WORK0
		LDA	4219H
		STA	<WORK1
;
		LDA	<WORK0
		STA	<KEYA1L
		TAY
		EOR	<KEYBFL
		AND	<KEYA1L
		STA	<KEYA2L			; [X,Y,L,R] key
		STY	<KEYBFL
;
		LDA	<WORK1
		STA	<KEYA1
		TAY
		EOR	<KEYBF
		AND	<KEYA1
		STA	<KEYA2			; [A,B,sl,st,u,d,l,r] key
		STY	<KEYBF
;
DEBUGMD		NOP ;RTS			; << DEBUG >>
;
		LDA	421AH			; 2P contoroler
		STA	<WORK0
		LDA	421BH
		STA	<WORK1
;
		LDA	<WORK0
		STA	<KEYA1L+1
		TAY
		EOR	<KEYBFL+1
		AND	<KEYA1L+1
		STA	<KEYA2L+1		; [X,Y,L,R] key
		STY	<KEYBFL+1
;
		LDA	<WORK1
		STA	<KEYA1+1
		TAY
		EOR	<KEYBF+1
		AND	<KEYA1+1
		STA	<KEYA2+1		; [A,B,sl,st,u,d,l,r] key
		STY	<KEYBF+1
		RTS
;
;
;
;************************************************************************
;*		OAM clear				(OAMCLR)	*
;************************************************************************
OAMCLR		EQU	$
		PHD				; (D) push
;
		MEM16
		IDX16
		REP	#00110000B		; memory,index 16bit mode
;
		LDA	#OAM&0FF00H
		TCD				; (D) <-- #OAM&0FF00H
;
		LDY	#0F000H
		LDX	#0200H-80H
OCL020		EQU	$
		TYA
		STA	<OAM+000H,X
		STA	<OAM+004H,X
		STA	<OAM+008H,X
		STA	<OAM+00CH,X
		STA	<OAM+010H,X
		STA	<OAM+014H,X
		STA	<OAM+018H,X
		STA	<OAM+01CH,X
		STA	<OAM+020H,X
		STA	<OAM+024H,X
		STA	<OAM+028H,X
		STA	<OAM+02CH,X
		STA	<OAM+030H,X
		STA	<OAM+034H,X
		STA	<OAM+038H,X
		STA	<OAM+03CH,X
		STA	<OAM+040H,X
		STA	<OAM+044H,X
		STA	<OAM+048H,X
		STA	<OAM+04CH,X
		STA	<OAM+050H,X
		STA	<OAM+054H,X
		STA	<OAM+058H,X
		STA	<OAM+05CH,X
		STA	<OAM+060H,X
		STA	<OAM+064H,X
		STA	<OAM+068H,X
		STA	<OAM+06CH,X
		STA	<OAM+070H,X
		STA	<OAM+074H,X
		STA	<OAM+078H,X
		STA	<OAM+07CH,X
		TXA
		SEC
		SBC	#00080H
		TAX
		BPL	OCL020			; oam clear end ?
;						; yes
		MEM8
		IDX8
		SEP	#00110000B		; memory,index 8bit mode
;
		PLD				; (D) pull
;<<<<>>>>		LDA	#0F0H
;<<<<>>>>		STA	<WORK2			; (work2) <-- clear no.
;<<<<>>>>;
;<<<<>>>>		MEM16
;<<<<>>>>		REP	#00100000B		; memory 16bit mode
;<<<<>>>>;
;<<<<>>>>		LDA	#OAMSUB-OAM
;<<<<>>>>		STA	<WORK0			; number of byte
;<<<<>>>>		LDA	#OAM
;<<<<>>>>		LDY	#BANK OAM		; to memory address
;<<<<>>>>		JSL	>DMA_D_M		; OAM clear (#0F0H clear)
;<<<<>>>>;
;<<<<>>>>		MEM8
;<<<<>>>>		SEP	#00100000B		; memory 8bit mode
		RTS
;
;
;
;************************************************************************
;*		OAM change				(OAMCHG)	*
;************************************************************************
OAMCHG		EQU	$
		PHD				; (D) push
		LDA	#HIGH OAMSUB
		XBA
		LDA	#LOW OAMSUB
		TCD				; (D) <-- #OAMSUB
;
		LDY	#01CH
OACG10		EQU	$
		TYA
		ASL	A
		ASL	A
		TAX
;
		LDA	<OAMSB+3,X
		ASL	A
		ASL	A
		ORA	<OAMSB+2,X
		ASL	A
		ASL	A
		ORA	<OAMSB+1,X
		ASL	A
		ASL	A
		ORA	<OAMSB+0,X
		STA	OAMSUB+0,Y
;
		LDA	<OAMSB+7,X
		ASL	A
		ASL	A
		ORA	<OAMSB+6,X
		ASL	A
		ASL	A
		ORA	<OAMSB+5,X
		ASL	A
		ASL	A
		ORA	<OAMSB+4,X
		STA	OAMSUB+1,Y
;
		LDA	<OAMSB+11,X
		ASL	A
		ASL	A
		ORA	<OAMSB+10,X
		ASL	A
		ASL	A
		ORA	<OAMSB+9,X
		ASL	A
		ASL	A
		ORA	<OAMSB+8,X
		STA	OAMSUB+2,Y
;
		LDA	<OAMSB+15,X
		ASL	A
		ASL	A
		ORA	<OAMSB+14,X
		ASL	A
		ASL	A
		ORA	<OAMSB+13,X
		ASL	A
		ASL	A
		ORA	<OAMSB+12,X
		STA	OAMSUB+3,Y
;
		DEY
		DEY
		DEY
		DEY
		BPL	OACG10			; set end ?
;						; yes
		PLD				; (D) pull
		RTS
;
;
;
;************************************************************************
;*		Sound port set				(SNDPORT)	*
;************************************************************************
SNDPORT		EQU	$
;------- sound port set ----------------------------------------------
		LDA	!SOUND2
		BEQ	SPORT200	; sound "on" ?
;					; yes
		STA	02142H
		CMP	#0F0H
		BCS	SPORT100	; B.G.M. set ?
;					; yes
		STA	!SVSND2
SPORT100	EQU	$
		LDA	!SOUND0
		BNE	SPORT110	; sound "on" ?
;					;
		LDY	02140H
		CPY	!SVSND0
		BNE	SPORT120	; transfer ok ?
;					; yes
SPORT110	EQU	$
		STA	02140H
		STA	!SVSND0
SPORT120	EQU	$
		LDA	!SOUND1
		BNE	SPORT130	;
;					;
		LDY	02141H
		CPY	!SVSND1
		BNE	SPORT140	; transfer ok ?
;					; yes
SPORT130	EQU	$
		STA	02141H
		STA	!SVSND1
SPORT140	EQU	$
		LDA	!SOUND3
		BNE	SPORT150	;
;					;
		LDY	02143H
		CPY	!SVSND3
		BNE	SPORT160	; transfer ok ?
;					; yes
SPORT150	EQU	$
		STA	02143H
		STA	!SVSND3
SPORT160	EQU	$
		STZ	!SOUND0
		STZ	!SOUND1
		STZ	!SOUND2
		STZ	!SOUND3
		RTS
;
;
SPORT200	EQU	$
		LDY	02142H
		CPY	!SVSND2
		BNE	SPORT100	; transfer ok ?
;					; yes
		STA	02142H
		BRA	SPORT100
;
;
;
;************************************************************************
;*		Blanking on				(BLANKING)	*
;************************************************************************
BLANKING	EQU	$
		LDA	#10000000B
		STA	2100H
		STA	WD2100			; blanking on
		STZ	420CH
		STZ	WD420C			; H-DMA disable
;
;;;;;;;;		JSR	VRAMCL			; VCL
		RTL
;
;
;
;
;
;
;
;
;
;\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
;\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
;\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
;\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
;\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
;\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
;
;
OCLCKD		EQU	$			; OAM clear check data ( 0:NOT , 1:CLEAR)
;			 0  1  2  3  4	5  6  7	 8  9  A  B  C	D  E  F
		HEX	01,01,01,01,01,01,01,01,01,00,00,01,01,01,01,01
		HEX	01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01
;
;
;#############	VRAM mode set data  #####################################
SD2101		EQU	$
;			   title    select
		BYTE	00000011B,00000000B
SD2105		EQU	$
		BYTE	00000011B,00000011B
SD2107		EQU	$
		BYTE	01111100B,01110011B
;;;;K;;;;		BYTE	01111000B,01110011B
SD2108		EQU	$
		BYTE	01111000B,01101100B
;;;;K;;;;		BYTE	01110010B,01101100B
SD2109		EQU	$
		BYTE	00000000B,00000000B
SD210B		EQU	$
		BYTE	01110000B,01110000B
;;;;K;;;;		BYTE	01010000B,01110000B
SD210C		EQU	$
		BYTE	00000000B,00000101B
SD212C		EQU	$
		BYTE	00010011B,00000010B
SD212D		EQU	$
		BYTE	00000000B,00010001B
SD2130		EQU	$
		BYTE	00000000B,00000010B
SD2131		EQU	$
		BYTE	00100000B,00100000B
SCVDTL		EQU	$
		BYTE	00000000B,00000000B
SCVDTH		EQU	$
		BYTE	00000000B,00000001B
;
;
;
;#############	Character DMA data  #####################################
SD2116BG1	EQU	$			; Vram address
;			 title select
		WORD	00000H,02000H
SD4302BG1	EQU	$			; A-bus address (L,H)
		WORD	00000H,08000H
SD4304BG1	EQU	$			;		(B)
		WORD	00000H,00006H
SD4305BG1	EQU	$			; data count
		WORD	00000H,04000H
;
SD2116BG2	EQU	$
		WORD	00000H,04000H
SD4302BG2	EQU	$
		WORD	00000H,0A000H
SD4304BG2	EQU	$
		WORD	00000H,00007H
SD4305BG2	EQU	$
		WORD	00000H,02000H
;
SD2116BG3	EQU	$
		WORD	00000H,07000H
SD4302BG3	EQU	$
		WORD	00000H,08000H
SD4304BG3	EQU	$
		WORD	00000H,00007H
SD4305BG3	EQU	$
		WORD	00000H,02000H
;
SD2116OBJ	EQU	$
		WORD	00000H,00000H
SD4302OBJ	EQU	$
		WORD	00000H,0C000H
SD4304OBJ	EQU	$
		WORD	00000H,00006H
SD4305OBJ	EQU	$
		WORD	00000H,04000H
;
;
;
;#############	VCL set data  ###########################################
VCLDAT0		EQU	$			; BG.1,2 VCL data
		WORD	0000FH,0006DH
VCLDAT1		EQU	$			; BG.3	 VCL data
		WORD	00124H,00124H
;
;
;
CGDATA		EQU	$			; CG. data address
		WORD	08E00H,0B400H
;
;
;
;------------------------------------------------------------------------
;
;
;========================================================================
;========================================================================
;========================================================================
;========================================================================
;========================================================================
		MEM8
		IDX8
;************************************************************************
;*		Character DMA & VMA			(DMAVMA)	*
;************************************************************************
DMAVMA		EQU	$
		LDA	#043H
		XBA
		LDA	#000H
		TCD				; (D) <-- #4300H
;
		IDX16
		REP	#00010000B		; index 16it mode
;
		LDX	#01801H
		STX	<04300H			; inc. mode & B-bus address set
;
		LDA	#10000000B
		STA	02115H			; Vram address auto inc.
;
;
;************************************************************************
;*		select character DMA					*
;************************************************************************
SLCHST		EQU	$
		LDA	!SLCHFG
		BEQ	WIPE_CDMA
;
		LDX	#06C00H
		STX	02116H
;;;;K;;;;		LDX	#049D800H
		LDX	!SLCHAD
		STX	<04302H
		LDA	#BANK 049D800H
		STA	<04304H
		LDX	#01000H
		STX	<04305H
		LDA	#00000001B
		STA	0420BH
;
		STZ	!SLCHFG
		STZ	!WIPE_ADR
		STZ	!WIPE_ADR+1
		RTS
;
;
;************************************************************************
;*		Wipe character DMA			(WIPE_CDMA)	*
;************************************************************************
WIPE_CDMA	EQU	$
		LDX	WIPE_ADR
		BEQ	SCR_DMA			; wipe charcater DMA ?
;						; yes
		STX	<04302H			; A-bus address (L,H)
		LDA	#BANK 07E800H
		STA	<04304H			; A-bus address (B)
;;;;K;;;;		LDX	#05000H
;;;;K;;;;		LDA	SLMODE
;;;;K;;;;		BEQ	WIPE_CD40		; title ?
;						; yes
		LDX	#07000H
WIPE_CD40	EQU	$
		STX	02116H			; vram address
		LDY	#00020H*40H
		STY	<04305H			; data count
;
		LDA	#00000001B
		STA	0420BH			; DMA ch "on"
;
		STZ	WIPE_ADR
		STZ	WIPE_ADR+1
;
;
;************************************************************************
;*		Select BG.2 display			(SCR_DMA)	*
;************************************************************************
SCR_DMA		EQU	$
		LDA	SCRVFG
		BEQ	CGDMA			; select BG.2 display ?
;						; yes
;;;;K;;;;		LDX	#07800H
		LDX	#07C00H
		STX	02116H			; Vram address set
		LDX	#TITLBF
		STX	<04302H			; A-bus address (L,H)
		LDA	#BANK TITLBF
		STA	<04304H			; A-bus address (B)
		LDY	#00800H
		STY	<04305H			; data count
;
		LDA	#00000001B
		STA	0420BH			; DMA ch "on"
;
		STZ	SCRVFG
;
;************************************************************************
;*		CG. data DMA				(CGDMA)		*
;************************************************************************
CGDMA		EQU	$
		LDA	!CGDMAF
		BEQ	OBJDMA			; CG. VMA ?
;						; yes
		STZ	02121H			; CG. RAM address set
;
		LDY	#02200H
		STY	<04300H			; inc. mode & B-bus address set
		LDY	#CGWORK
		STY	<04302H			; A-bus address (L,H)
		LDA	#BANK CGWORK
		STA	<04304H			; A-bus address (B)
		LDY	#00200H
		STY	<04305H			; data count
;
		LDA	#00000001B
		STA	0420BH			; DMA ch "on"
;
		STZ	!CGDMAF
;
;
;
;************************************************************************
;*		OBJ_DMA					(OBJDMA)	*
;************************************************************************
OBJDMA		EQU	$
		MEM16
		REP	#00100000B		; memory 16bit mode
		IDX8
		SEP	#00010000B		; index 8bit mode
;
		STZ	02102H			; OAM address set
		LDA	#00400H
		STA	<04300H			; B-bus addess & control paramater
		LDA	#OAM
		STA	<04302H			; A-bus address (L,H)
		STZ	<04304H			;		(B)
		LDA	#00220H
		STA	<04305H			; OBJ_DMA paramater set
		LDY	#00000001B
		STY	0420BH			; DMA ch "ON"
;
;
		LDA	#01801H
		STA	<04300H			; B-bus addess & control paramater
;
;
;************************************************************************
;*		VMA					(VMADSP)	*
;************************************************************************
VMADSP		EQU	$
		LDA	#01801H
		STA	<04300H			; B-bus address & inc. mode set
;
		LDA	#00000H
		TCD				; (D) <-- #00000H
;
		LDA	#VRAMD2
		STA	<VWORK0			; BG data address (L,H) set
;
		MEM8
		SEP	#00100000B		; memory 8bit mode
;
		LDA	#BANK VRAMD2
		STA	04304H
		STA	<VWORK2
;
		IDX16
		REP	#00010000B		; index 16bit mode
;
		LDY	#00000H
		JSR	VRAMTRZ
VMD200		EQU	$
		MEM16
		REP	#00100000B		; memory 16bit mode
;
		LDA	#00000H
		STA	>VRAMD
		DEC	A
		STA	>VRAMD2
		RTS
;
;
;
;
;
;
;
		MEM8
;************************************************************************
;*		Vram write				(VRAMTRZ)	*
;*									*
;*							*
;*		  	  						*
;*							*
;*		        					*
;*		      					*
;*		         f[^if[^axsdj *
;*		  						*
;*		     uq`l@igCkj *
;*									*
;************************************************************************
VMRZ200		EQU	$
		STA	02117H
		INY
		LDA	[<VWORK0],Y
		STA	02116H			; Vram address set
		INY
;
		LDA	[<VWORK0],Y
		ASL	A
		LDA	#01000000B
		ROL	A
		STA	02115H			; VRAM address auto inc.
;
		MEM16
		REP	#00100000B		; memory 16bit mode
;
		LDA	[<VWORK0],Y
		XBA
		ASL	A
		LSR	A
		STA	04305H			; data count
		STA	<VWORK4
		INY
		INY
;
		TYA
;;;;;;;;		CLC
		ADC	<VWORK0
		STA	04302H			; data address (L,H) set
;
		TYA
;;;;;;;;		CLC
		ADC	<VWORK4
		TAY
;
		MEM8
		SEP	#00100000B		; memory 8bit mode
;
		LDA	#00000001B
		STA	0420BH			; DMA ch "ON"
VRAMTRZ		EQU	$
		LDA	[<VWORK0],Y
		BPL	VMRZ200			; end ?
;						; yes
		RTS
;
;
;
;
;
;
;
;
;
		MEM8
		IDX8
;************************************************************************
;*		Sound transfer				(SNDTRNS)	*
;************************************************************************
SOUND_TBL	EQU	$
		WORD	M1_SNDTR
		WORD	M2_SNDTR
		WORD	MUSA_SNDTR
		WORD	M3_SNDTR
		WORD	M4_SNDTR
;
;
SNDTRNS		EQU	$
		SEI				; IRQ	disable
		STZ	04200H			; NMI	disable
		STZ	0420CH			; H-DMA disable
;
		STZ	02140H
		STZ	02142H
		STZ	02143H			; sound port clear
		LDA	#0FFH
		STA	02141H
;
		LDA	<GAMENO
		ASL	A
		TAX
		JSR	(SOUND_TBL,X)
;
		MEM16
		REP	#00100000B		; memory 16bit mode
;
		LDX	#00000001B*2
		LDA	#000200H
		STA	<WORK0			; number of byte
		LDA	CGDATA,X
		LDY	#002H
		STA	<WORK2
		STY	<WORK4			; from memory address
		LDA	#CGRAM
		LDY	#BANK CGRAM		; to memory address
		JSL	>DMA_M_M		; CGRAM set
;
		LDA	#CGWORK
		LDY	#BANK CGWORK		; to memory address
		JSL	>DMA_M_M		; CGWORK set
;
		LDA	#00000H
		STA	>VRAMD
		DEC	A
		STA	>VRAMD2			; vram init. off
;
		MEM8
		SEP	#00100000B		; memory 8bit mode
;
		LDA	#10000001B
		STA	04200H			; NMI enable
;
		INC	<SLMODE
		RTL
;
;
;
;***********************************************************
;*	 sound transfer ( main )			   *
;***********************************************************
TITLE_SNDTR	EQU	$
		MEM16
		REP	#00100000B		; memory 16bit mode
;
		LDA	#00400H
		STA	<WORK0
		LDA	#07FC00H
		STA	<WORK2
		LDY	#BANK 07FC00H
		STY	<WORK4
		LDA	#SNDBUFF
		LDY	#BANK SNDBUFF
		JSL	>DMA_M_M
;
		LDA	#08000H
		STA	<WORK0
		LDA	#3B8000H
		STA	<WORK2
		LDY	#BANK 3B8000H
		STY	<WORK4
		LDA	#SNDBUFF+0400H
		LDY	#BANK SNDBUFF+0400H
		JSL	>DMA_M_M
;
		MEM8
		SEP	#00100000B		; memory 8bit mode
;
;;;;;;;;;		 LDA	 #LOW (SNDBUFF)
		STZ	<address
		LDA	#HIGH (SNDBUFF)
		STA	<address+1
		LDA	#BANK (SNDBUFF)
		STA	<address+2	; sound address set
		JMP	Boot_APU	; sound transfer
;
;
;
;***********************************************************
;*	 sound transfer ( main )			   *
;***********************************************************
BGM_SNDTR	EQU	$
		SEI				; IRQ	disable
		STZ	04200H			; NMI	disable
		STZ	0420CH			; H-DMA disable
;
		STZ	02140H
		LDA	#0FFH
		STA	02141H
		STZ	02142H
		STZ	02143H			; sound port clear
;
;;;;;;;;		LDA	#LOW 00B8000H
		STZ	<address
		LDA	#HIGH 00B8000H
		STA	<address+1
		LDA	#BANK 00B8000H
		STA	<address+2		; sound address set
;
		JSR	Boot_APU		; sound transfer
;
		LDA	#10000001B
		STA	04200H			; NMI enable
		INC	<GMMODE
		LDA	#012H
		STA	<SOUND0			; sound
		RTS
;
;
;
;***********************************************************
;*	 sound transfer ( main )			   *
;***********************************************************
BGM_SNDTR1	EQU	$
		SEI				; IRQ	disable
		STZ	04200H			; NMI	disable
		STZ	0420CH			; H-DMA disable
		STZ	0420BH			; DMA	disable
;
		STZ	02140H
		LDA	#0FFH
		STA	02141H
		STZ	02142H
		STZ	02143H			; sound port clear
;
;;;;;;;;		LDA	#LOW 00B8000H
		STZ	<address
		LDA	#HIGH 00B8000H
		STA	<address+1
		LDA	#BANK 00B8000H
		STA	<address+2		; sound address set
;
		JSR	Boot_APU		; sound transfer
;
		LDA	#10000001B
		STA	04200H			; NMI enable
		RTS
;
;
;
;***********************************************************
;*	 sound transfer ( main )			   *
;***********************************************************
VOICE_SNDTR	EQU	$
		SEI				; IRQ	disable
		STZ	04200H			; NMI	disable
		STZ	0420CH			; H-DMA disable
;
		STZ	02140H
		LDA	#0FFH
		STA	02141H
		STZ	02142H
		STZ	02143H			; sound port clear
;
		LDA	#LOW  03B8000H+2651H-400H
		STA	<address
		LDA	#HIGH 03B8000H+2651H-400H
		STA	<address+1
		LDA	#BANK 03B8000H+2651H-400H
		STA	<address+2		; sound address set
;
		JSR	Boot_APU		; sound transfer
;
		LDA	#10000001B
		STA	04200H			; NMI enable
		INC	<GMMODE
		LDA	#03EH
		STA	<SOUND0			; sound
		RTS
;
;
;
;***********************************************************
;*	 sound transfer ( main )			   *
;***********************************************************
M1_SNDTR	EQU	$
M2_SNDTR	EQU	$
;;;;;;;;;;;		   MEM16
;;;;;;;;;;;		   REP	   #00100000B		   ; memory 16bit mode
;;;;;;;;;;;;
;;;;;;;;;;;		   LDA	   #03000H
;;;;;;;;;;;		   STA	   <WORK0
;;;;;;;;;;;		   LDA	   #1F8000H
;;;;;;;;;;;		   STA	   <WORK2
;;;;;;;;;;;		   LDY	   #BANK 1F8000H
;;;;;;;;;;;		   STY	   <WORK4
;;;;;;;;;;;		   LDA	   #SNDBUFF
;;;;;;;;;;;		   LDY	   #BANK SNDBUFF
;;;;;;;;;;;		   JSL	   >DMA_M_M
;;;;;;;;;;;;
;;;;;;;;;;;		   MEM8
;;;;;;;;;;;		   SEP	   #00100000B		   ; memory 8bit mode
;;;;;;;;;;;;
;;;;;;;;;;;		   LDA	   #LOW (SNDBUFF)
;;;;;;;;;;;		   STZ	   <address
;;;;;;;;;;;		   LDA	   #HIGH (SNDBUFF)
;;;;;;;;;;;		   STA	   <address+1
;;;;;;;;;;;		   LDA	   #BANK (SNDBUFF)
;;;;;;;;;;;		   STA	   <address+2	   ; sound address set
		LDA	#LOW  1F8000H
		STA	<address+0
		LDA	#HIGH 1F8000H
		STA	<address+1
		LDA	#BANK 1F8000H
		STA	<address+2		; sound address set
;
		JSR	Boot_APU	; sound transfer
		RTS
;
;
;
;***********************************************************
;*	 sound transfer ( main )			   *
;***********************************************************
MUSA_SNDTR	EQU	$
;;;;;;;;;;;		   MEM16
;;;;;;;;;;;		   REP	   #00100000B		   ; memory 16bit mode
;;;;;;;;;;;;
;;;;;;;;;;;		   LDA	   #03000H
;;;;;;;;;;;		   STA	   <WORK0
;;;;;;;;;;;		   LDA	   #1FB000H
;;;;;;;;;;;		   STA	   <WORK2
;;;;;;;;;;;		   LDY	   #BANK 1FB000H
;;;;;;;;;;;		   STY	   <WORK4
;;;;;;;;;;;		   LDA	   #SNDBUFF
;;;;;;;;;;;		   LDY	   #BANK SNDBUFF
;;;;;;;;;;;		   JSL	   >DMA_M_M
;;;;;;;;;;;;
;;;;;;;;;;;		   MEM8
;;;;;;;;;;;		   SEP	   #00100000B		   ; memory 8bit mode
;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;		   LDA	   #LOW (SNDBUFF)
;;;;;;;;;;;		   STZ	   <address
;;;;;;;;;;;		   LDA	   #HIGH (SNDBUFF)
;;;;;;;;;;;		   STA	   <address+1
;;;;;;;;;;;		   LDA	   #BANK (SNDBUFF)
;;;;;;;;;;;		   STA	   <address+2	   ; sound address set
;
		LDA	#LOW  1FC000H
		STA	<address+0
		LDA	#HIGH 1FC000H
		STA	<address+1
		LDA	#BANK 1FC000H
		STA	<address+2		; sound address set
;
		JSR	Boot_APU	; sound transfer
		RTS
;
;
;
;***********************************************************
;*	 sound transfer ( main )			   *
;***********************************************************
M3_SNDTR	EQU	$
;;;;;;;;;;;		   MEM16
;;;;;;;;;;;		   REP	   #00100000B		   ; memory 16bit mode
;;;;;;;;;;;;
;;;;;;;;;;;		   LDA	   #02800H
;;;;;;;;;;;		   STA	   <WORK0
;;;;;;;;;;;		   LDA	   #07C000H
;;;;;;;;;;;		   STA	   <WORK2
;;;;;;;;;;;		   LDY	   #BANK 07C000H
;;;;;;;;;;;		   STY	   <WORK4
;;;;;;;;;;;		   LDA	   #SNDBUFF
;;;;;;;;;;;		   LDY	   #BANK SNDBUFF
;;;;;;;;;;;		   JSL	   >DMA_M_M
;;;;;;;;;;;;
;;;;;;;;;;;		   MEM8
;;;;;;;;;;;		   SEP	   #00100000B		   ; memory 8bit mode
;;;;;;;;;;;;
;;;;;;;;;;;		   LDA	   #LOW (SNDBUFF)
;;;;;;;;;;;		   STZ	   <address
;;;;;;;;;;;		   LDA	   #HIGH (SNDBUFF)
;;;;;;;;;;;		   STA	   <address+1
;;;;;;;;;;;		   LDA	   #BANK (SNDBUFF)
;;;;;;;;;;;		   STA	   <address+2	   ; sound address set
;
;;;;;;;;;;;;;;;;;;;;;;		      LDA     #LOW  07C000H
;;;;;;;;;;;;;;;;;;;;;;		      STA     <address+0
;;;;;;;;;;;;;;;;;;;;;;		      LDA     #HIGH 07C000H
;;;;;;;;;;;;;;;;;;;;;;		      STA     <address+1
;;;;;;;;;;;;;;;;;;;;;;		      LDA     #BANK 07C000H
;;;;;;;;;;;;;;;;;;;;;;		      STA     <address+2	      ; sound address set
;
		LDA	#LOW  0C8000H
		STA	<address+0
		LDA	#HIGH 0C8000H
		STA	<address+1
		LDA	#BANK 0C8000H
		STA	<address+2		; sound address set
;
		JSR	Boot_APU	; sound transfer
		RTS
;
;
;
;***********************************************************
;*	 sound transfer ( main )			   *
;***********************************************************
M4_SNDTR	EQU	$
		LDA	#0F0H
		STA	02141H			; sound port reset
;
		STZ	<address
		LDA	#HIGH 04E8000H
		STA	<address+1
		LDA	#BANK 04E8000H
		STA	<address+2		; sound address set
;
		JSR	Boot_APU		; sound transfer
;
		RTS
;
;
;
;****************************************************************
;*		M3-game sound transfer ( main )			*
;****************************************************************
M3_SNDTR1	EQU	$
		SEI				; IRQ	disable
		STZ	04200H			; NMI	disable
		STZ	0420CH			; H-DMA disable
;
		LDA	#0FFH
		STA	02141H			; sound port set
;
;;;;;;;;;;;		   MEM16
;;;;;;;;;;;		   REP	   #00100000B		   ; memory 16bit mode
;;;;;;;;;;;;
;;;;;;;;;;;		   LDA	   #02800H
;;;;;;;;;;;		   STA	   <WORK0
;;;;;;;;;;;		   LDA	   #0CA000H
;;;;;;;;;;;		   STA	   <WORK2
;;;;;;;;;;;		   LDY	   #BANK 0CA000H
;;;;;;;;;;;		   STY	   <WORK4
;;;;;;;;;;;		   LDA	   #SNDBUFF
;;;;;;;;;;;		   LDY	   #BANK SNDBUFF
;;;;;;;;;;;		   JSL	   >DMA_M_M
;;;;;;;;;;;;
;;;;;;;;;;;		   MEM8
;;;;;;;;;;;		   SEP	   #00100000B		   ; memory 8bit mode
;;;;;;;;;;;;
;;;;;;;;;;;		   LDA	   #LOW (SNDBUFF)
;;;;;;;;;;;		   STZ	   <address
;;;;;;;;;;;		   LDA	   #HIGH (SNDBUFF)
;;;;;;;;;;;		   STZ	   <address+1
;;;;;;;;;;;		   LDA	   #BANK (SNDBUFF)
;;;;;;;;;;;		   STA	   <address+2	   ; sound address set
;
		LDA	#LOW  0C8000H
		STA	<address+0
		LDA	#HIGH 0C8000H
		STA	<address+1
		LDA	#BANK 0C8000H
		STA	<address+2		; sound address set
;
		JSR	Boot_APU	; sound transfer
;
;;;;;;;;;;;		   MEM16
;;;;;;;;;;;		   REP	   #00100000B		   ; memory 16bit mode
;;;;;;;;;;;;
;;;;;;;;;;;		   LDA	   #7FC000H-7F0000H
;;;;;;;;;;;		   STA	   <WORK0		   ; number of byte
;;;;;;;;;;;		   LDA	   #00000H
;;;;;;;;;;;		   LDY	   #07FH
;;;;;;;;;;;		   JSL	   >DMA_D_M0		   ; ram clear (7F0000H ~ 7FBFFFH)
;;;;;;;;;;;;
;;;;;;;;;;;		   MEM8
;;;;;;;;;;;		   SEP	   #00100000B		   ; memory 8bit mode
		RTL
;
;
;
;****************************************************************
;*		M3-map sound transfer ( main )			*
;****************************************************************
M3_SNDTR2	EQU	$
		SEI				; IRQ	disable
		STZ	04200H			; NMI	disable
		STZ	0420CH			; H-DMA disable
;
		LDA	#0FFH
		STA	02141H			; sound port set
;
		MEM16
		REP	#00100000B		; memory 16bit mode
;
		LDA	#02800H
		STA	<WORK0
		LDA	#07C000H
		STA	<WORK2
		LDY	#BANK 07C000H
		STY	<WORK4
		LDA	#SNDBUFF
		LDY	#BANK SNDBUFF
		JSL	>DMA_M_M
;
		MEM8
		SEP	#00100000B		; memory 8bit mode
;
		LDA	#LOW (SNDBUFF)
		STZ	<address
		LDA	#HIGH (SNDBUFF)
		STA	<address+1
		LDA	#BANK (SNDBUFF)
		STA	<address+2	; sound address set
;
		JSR	Boot_APU	; sound transfer
;
		MEM16
		REP	#00100000B		; memory 16bit mode
;
		LDA	#7FC000H-7F0000H
		STA	<WORK0			; number of byte
		LDA	#00000H
		LDY	#07FH
		JSL	>DMA_D_M0		; ram clear (7F0000H ~ 7FBFFFH)
;
		MEM8
		SEP	#00100000B		; memory 8bit mode
		RTL
;
;
;
;
;
;
;*********************************************************************
;*	 Sound boot loader  V1.1				     *
;*********************************************************************
;
;-------------------------------------------------
APU_port0	EQU	02140H
APU_port1	EQU	02141H
APU_port2	EQU	02142H
APU_port3	EQU	02143H
address		EQU	00000H
;-------------------------------------------------
;
Boot_APU	EQU	$
		PHP				; (P) push
;
		MEM16
		IDX16
		REP	#00110000B		; memory,index 16bit mode
		LDY	#00
		LDA	#0BBAAH
boot_initial	EQU	$
		CMP	!APU_port0		; m16
		BNE	boot_initial		; transfer ok ?
;						; yes
		MEM8
		SEP	#00100000B		; memory 8bit mode
;
		LDA	#0CCH
		BRA	boot_entry1
;
boot_repeat	EQU	$
		LDA	[<address],Y
		INY
		XBA
		LDA	#00
		BRA	boot_entry2
;
boot_loop	EQU	$
		XBA
		LDA	[<address],Y
		INY
		XBA
boot_wait1	EQU	$
		CMP	!APU_port0
		BNE	boot_wait1
		INC	A
boot_entry2	EQU	$
		REP	#00100000B
		STA	!APU_port0		; m16
		SEP	#00100000B
;
		DEX
		BNE	boot_loop
;
boot_wait2	EQU	$
		CMP	!APU_port0
		BNE	boot_wait2
boot_zero	EQU	$
		ADC	#03
		BEQ	boot_zero
boot_entry1	EQU	$
		PHA				; >
		REP	#00100000B
		LDA	[<address],Y		; m16
		INY
		INY
		TAX
		LDA	[<address],Y		; m16
		INY
		INY
		STA	!APU_port2		; m16
		SEP	#00100000B
		CPX	#01
		LDA	#00
		ROL	A
		STA	!APU_port1
		ADC	#07FH
		PLA				; <
		STA	!APU_port0
boot_wait3	EQU	$
		CMP	!APU_port0
		BNE	boot_wait3
		BVS	boot_repeat
;
		STZ	!APU_port0
		STZ	!APU_port1
		STZ	!APU_port2
		STZ	!APU_port3		; port reset !!
;
		PLP				; (P) pull
		RTS
;
;
;
;
;&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
;&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
;&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
;&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
;&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
;************************************************************************
;*		Save-Ram check				(SVRMCK)	*
;************************************************************************
SVRMCK		EQU	$
		MEM8
		SEP	#00100000B		; memory 8bit mode
;;;;;;;;;;;;;;		      IDX16
;;;;;;;;;;;;;;		      REP     #00010000B	      ; index 16bit mode
;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;		      LDX     #00000H
;;;;;;;;;;;;;;		      TXA
;;;;;;;;;;;;;;		      CLC
;;;;;;;;;;;;;;SVRC_000	      EQU     $
;;;;;;;;;;;;;;		      ADC     >SV_CHK_S,X
;;;;;;;;;;;;;;		      INX
;;;;;;;;;;;;;;		      CPX     #SV_CHK_E-SV_CHK_S
;;;;;;;;;;;;;;		      BNE     SVRC_000		      ; total end ?
;;;;;;;;;;;;;;;						      ; yes
;;;;;;;;;;;;;;		      CMP     #037H
;;;;;;;;;;;;;;		      BEQ     SV_CHK_S		      ; check-sum ok ?
;;;;;;;;;;;;;;;						      ; yes
;;;;;;;;;;;;;;		      SEP     #00010000B
;;;;;;;;;;;;;;		      JMP     >ROM_ERROR
;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;SV_CHK_S	      EQU     $
;;;;;;;;;;;;;;		      IDX8
;;;;;;;;;;;;;;		      SEP     #00010000B	      ; index 8bit mode
;;;;;;;;;;;;;;;
		LDA	#000H
		STA	>DEBUG			;debug flag clear
;
		MEM16
		IDX16
		REP	#00110000B		; memory,index 16bit mode
;
		LDA	>RMCHK1
		CMP	#09743H
		BNE	SVRC_100		; back-up ok ?
;						; yes
		LDA	>RMCHK2
		CMP	#05321H
		BEQ	SVRC_500		; back-up ok ?
;						; no
;
SVRC_100	EQU	$
		IDX8
		SEP	#00010000B		; index 8bit mode
;
		LDA	#702000H-700000H
		STA	<WORK0			; number of byte
		LDA	#00000H
		LDY	#070H			; to memory address
		JSL	>DMA_D_M0		; ram clear (700000H~701FFFH)
;
		IDX16
		REP	#00010000B		; index 16bit mode
;
		LDX	#00000H
SVRC_120	EQU	$
		JSR	SVRSUB			; data set
;
		LDA	>SVINDX
		INC	A
		STA	>SVINDX
		CMP	#0010H
		BCC	SVRC_120		; initial data set end ?
;						; yes
		LDA	#09743H
		STA	>RMCHK1
		LDA	#05321H
		STA	>RMCHK2			; file check-code set
;
		JMP	SVRMCK			; re-check
;
;
		MEM16
		IDX16
SVRC_500	EQU	$
		LDA	#00000H
		STA	>SVINDX
		TAX
SVRC_510	EQU	$
		AND	#00003H
		ASL	A
		TAY
		LDA	SVDTSU,Y
		DEC	A
		DEC	A
		TAY				; save data count
;
		STZ	<WORK
		STX	<WORK2
;
		MEM8
		SEP	#00100000B		; memory 8bit mode
SVRC_520	EQU	$
		LDA	>SAVE_RAM,X
		CLC
		ADC	<WORK
		STA	<WORK
		LDA	<WORK1
		ADC	#000H
		STA	<WORK1
		INX
		DEY
		BNE	SVRC_520		; total end ?
;						; yes
		MEM16
		REP	#00100001B		; memory 16bit mode & CLC
;
		LDA	<WORK
		ADC	>SAVE_RAM,X
		BNE	SVRC_540		; save-file check-sum ok ?
;						; yes
		INX
		INX
SVRC_530	EQU	$
		LDA	>SVINDX
		INC	A
		STA	>SVINDX
		CMP	#00010H
		BCS	SVR900			; file check end ?
;						; no
		BRA	SVRC_510
;
SVRC_540	EQU	$
		MEM16
		IDX16
		REP	#00110000B		; memory,index 16bit mode
;
		LDX	<WORK2
;
		JSR	SVRSUB			; data set
;
		STX	<WORK2
;
		BRA	SVRC_530
;
;
SVR900		EQU	$
		MEM8
		IDX8
		SEP	#00110000B		; memory,index 8bit mode
		LDA	<WALDDT+0AH
		PHA
		LDA	<WALDDT+0BH
		PHA
		PHB
		LDA	#030H
		PHA
		PLB
		LDX	#000H
SVR9005		EQU	$
		STX	<WORK0
		PHX
		JSL	>M4SVCK			; mario 4 save ram check
		BEQ	SVR9008
		JSL	>M4SVCLR
SVR9008		EQU	$
		PLX
		INX
		CPX	#003H
		BNE	SVR9005
		PLB
		PLA
		STA	<WALDDT+0BH
		PLA
		STA	<WALDDT+0AH
		JMP	SVR999
;
;;;;K;;;;		LDA	>MR1PLD+19H
;;;;K;;;;		STA	<WORK
;;;;K;;;;		LDA	>MR1PLD
;;;;K;;;;		AND	#00FFH
;;;;K;;;;		CLC
;;;;K;;;;		ADC	<WORK
;;;;K;;;;		SEC
;;;;K;;;;		SBC	#7
;;;;K;;;;		STA	<WORK
;;;;K;;;;		LDA	>MR1PLD+1
;;;;K;;;;		AND	#00FFH
;;;;K;;;;		CLC
;;;;K;;;;		ADC	<WORK
;;;;K;;;;		SEC
;;;;K;;;;		SBC	#3
;;;;K;;;;		STA	>MR1PLD+19H
;;;;K;;;;		LDA	#0307H
;;;;K;;;;		STA	>MR1PLD
;;;;K;;;;;
;;;;K;;;;		LDA	>MR2PLD+11H
;;;;K;;;;		STA	<WORK
;;;;K;;;;		LDA	>MR2PLD
;;;;K;;;;		AND	#00FFH
;;;;K;;;;		CLC
;;;;K;;;;		ADC	<WORK
;;;;K;;;;		SEC
;;;;K;;;;		SBC	#0CH
;;;;K;;;;		STA	<WORK
;;;;K;;;;		LDA	>MR2PLD+1
;;;;K;;;;		AND	#00FFH
;;;;K;;;;		CLC
;;;;K;;;;		ADC	<WORK
;;;;K;;;;		SEC
;;;;K;;;;		SBC	#3
;;;;K;;;;		STA	>MR2PLD+11H
;;;;K;;;;		LDA	#030CH
;;;;K;;;;		STA	>MR2PLD
;;;;K;;;;;
;;;;K;;;;		LDA	>MRUPLD+07H
;;;;K;;;;		STA	<WORK
;;;;K;;;;		LDA	>MRUPLD
;;;;K;;;;		AND	#00FFH
;;;;K;;;;		CLC
;;;;K;;;;		ADC	<WORK
;;;;K;;;;		SEC
;;;;K;;;;		SBC	#6
;;;;K;;;;		STA	<WORK
;;;;K;;;;		LDA	>MRUPLD+1
;;;;K;;;;		AND	#00FFH
;;;;K;;;;		CLC
;;;;K;;;;		ADC	<WORK
;;;;K;;;;		SEC
;;;;K;;;;		SBC	#1
;;;;K;;;;		STA	>MRUPLD+07H
;;;;K;;;;		LDA	#0106H
;;;;K;;;;		STA	>MRUPLD
;;;;K;;;;;
;;;;K;;;;		LDA	>MR3PLD+116H
;;;;K;;;;		STA	<WORK
;;;;K;;;;		LDA	>MR3PLD
;;;;K;;;;		AND	#00FFH
;;;;K;;;;		CLC
;;;;K;;;;		ADC	<WORK
;;;;K;;;;		SEC
;;;;K;;;;		SBC	#6
;;;;K;;;;		STA	<WORK
;;;;K;;;;		LDA	>MR3PLD+1
;;;;K;;;;		AND	#00FFH
;;;;K;;;;		CLC
;;;;K;;;;		ADC	<WORK
;;;;K;;;;		SEC
;;;;K;;;;		SBC	#0
;;;;K;;;;		STA	>MR3PLD+116H
;;;;K;;;;		LDA	#0007H
;;;;K;;;;		STA	>MR3PLD
;
SVR999		EQU	$
		MEM8
		IDX8
		SEP	#30H
		RTS
;
;
;
		MEM16
		IDX16
;ssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssss
;s		Save data init. set			(SVRSUB)	s
;ssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssss
SVRSUB		EQU	$
		LDA	>SVINDX
		AND	#00003H
		ASL	A
		TAY
		LDA	SVDTSU,Y
		DEC	A
		DEC	A
		STA	<WORKE			; save count
		LDA	MRZIDX,Y
		TAY				; (Y) <-- save data start address
;
		STZ	<WORK0
;
		MEM8
		SEP	#00100000B		; memory 8bit mode
SVRS_020	EQU	$
		LDA	MR1DAT,Y
		STA	>SAVE_RAM,X
		CLC
		ADC	<WORK
		STA	<WORK
		LDA	<WORK1
		ADC	#000H
		STA	<WORK1
		LDA	MR1DAT,Y
		INX
		INY
		DEC	<WORKE
		BNE	SVRS_020		; set end ?
;						; yes
		DEC	<WORKF
		BPL	SVRS_020		; set end ?
;						; yes
;
		MEM16
		REP	#00100000B		; memory 16bit mode
;
		LDA	#00000H
		SEC
		SBC	<WORK
		STA	>MR1PLA,X
;
		LDA	<GAMENO
		AND	#00003H
		CMP	#00003H
		BNE	SVRS_080		;
;						;
;;;;;;;;;;;;;;;		       PHX			       ; (X) push
;;;;;;;;;;;;;;;		       LDA     <PLAYNO
;;;;;;;;;;;;;;;		       AND     #00000011B
;;;;;;;;;;;;;;;		       ASL     A
;;;;;;;;;;;;;;;		       TAX
;;;;;;;;;;;;;;;		       LDA     #0000H
;;;;;;;;;;;;;;;		       STA     >BTLPLA,X
;;;;;;;;;;;;;;;		       PLX			       ; (X) pull
SVRS_080	EQU	$
		INX
		INX
		RTS
;
;
MRZIDX		EQU	$
		WORD	MR1DAT-MR1DAT
		WORD	MR2DAT-MR1DAT
		WORD	MRUDAT-MR1DAT
		WORD	MR3DAT-MR1DAT
;
SVDTSU		EQU	$
		WORD	MR2PLA-MR1PLA
		WORD	MRUPLA-MR2PLA
		WORD	MR3PLA-MRUPLA
		WORD	MR1PLB-MR3PLA
;
MR1DAT		EQU	$
		HEX	FF,FF,FF					; WORLD NO
		HEX	04,04						; PLAYER COUNT
;;;;;;;;;;;;;;;;;;		  HEX	  00,00,00,00,00,00				  ; TOP SCORE
		HEX	00						; URA
		HEX	FF						; 2play-mode
		WORD	00000H						; check-sum
;
MR2DAT		EQU	$
		HEX	FF,FF,FF					; WORLD NO
		HEX	04						; PLAYER COUNT
;;;;;;;;;;;;;;;;;;		  HEX	  00,00,00,00,00,00				  ; TOP SCORE
		HEX	00						; WARP COUNT
		HEX	FF						; new-game
		WORD	00000H						; check-sum
;
MRUDAT		EQU	$
		HEX	FF,FF						; WORLD NO
		HEX	05						; PLAYER COUNT
		HEX	00,00,00,00					; PLAYER DOWN COUNT
		WORD	00000H						; check-sum
;
MR3DAT		EQU	$
		HEX	FF,FF						; Warld no
		HEX	04,04						; player count
		HEX	70,80,80,00,00,00,00,00,00,00,00,00,00,00	; enemy map position
		HEX	D0,C0,A0,00,00,00,00,00,00,00,00,00,00,00
		HEX	00,00,00,00,00,00,00,00,00,00,00,00,00,00
		HEX	01,00,03,00,00,00,00,00,00,00,00,00,00,00
		HEX	00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00 ; map bit
		HEX	00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
		HEX	00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
		HEX	00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
		HEX	00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
		HEX	00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
		HEX	00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
		HEX	00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
		HEX	00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00 ; item ram
		HEX	00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
		HEX	00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
		HEX	00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
		HEX	00,00,00,00,00,00
		HEX	00						; takarabune out flag
		HEX	FF						; 2play mode?
		WORD	00000H						; check-sum
;
;
;
		MEM8
		IDX8
;************************************************************************
;*		MARIO-1	 SAVE				(M1SAVE)	*
;************************************************************************
M1SAVE		EQU	$
		PHX				; (X) push
		PHY				; (Y) push
;
		PHB
		PHK
		PLB				; (DBR) set
;
		LDA	>NOW_BSLFG
		BEQ	M1S_000			; *8-4 save ?
;						; no
		JMP	M1SAVE_S
;
;
M1S_000		EQU	$
		MEM16
		IDX16
		REP	#00110000B		; memory,index 16bit mode
;
		STZ	<WORK0
;
		LDA	>SVINDX
		TAX
;
		MEM8
		SEP	#00100000B		; memory 8bit mode
;
		LDA	!PLAYSW_1
		BEQ	M1S_100			; 2-play-game ?
;						; yes
		LDA	!BSLFG_1
		CMP	!WBSLFG_1
		BEQ	M1S_040			; ura-flag = ?
;						; no
		CMP	#001H
		BEQ	M1S_100			; play-data save ?
;						; no
		JMP	M1S_300
;
M1S_040		EQU	$
		LDA	!CORSNO_1
		CMP	!WCRSNO_1
		BCC	M1S_300			; play-data save ?
;						; yes
M1S_100		EQU	$
		LDA	!BSLFG_1
		STA	<WORK2
		CMP	>MR1PLA+(m1_ura-MR1PLA),X
		BEQ	M1S_140			; save data ura ?
;						; yes
		CMP	#001H
		BEQ	M1S_180			; play-data save ?
;						; no
		BRA	M1S_160
;
M1S_140		EQU	$
		LDA	>MR1PLA,X
		BMI	M1S_180			; world save ok ?
;						; no
		CMP	CORSNO_1
		BCC	M1S_180			; world save ok ?
;						; yes
M1S_160		EQU	$
		LDA	>MR1PLA,X		; no cours save
		JSR	MRSVSB
		LDA	>MR1PLA,X
		JSR	MRSVSB
		LDA	>MR1PLA,X
		BRA	M1S_190
;
M1S_180		EQU	$
		LDA	CORSNO_1		; cours save
		JSR	MRSVSB
;;;;;;;;;;;;		    LDA	    GOALCT_1
		LDA	#000H
		JSR	MRSVSB
;;;;;;;;;;;;		    LDA	    CORSID_1
		LDA	#000H
M1S_190		EQU	$
		BRA	M1S_400
;
;
M1S_300		EQU	$
		LDA	!WBSLFG_1
		STA	<WORK2
		CMP	>MR1PLA+(m1_ura-MR1PLA),X
		BEQ	M1S_340			; save data ura ?
;						; yes
		CMP	#001H
		BEQ	M1S_380			; play-data save ?
;						; no
		BRA	M1S_360
;
M1S_340		EQU	$
		LDA	>MR1PLA,X
		BMI	M1S_380			; world save ok ?
;						; no
		CMP	!WCRSNO_1
		BCC	M1S_380			; world save ok ?
;						; yes
M1S_360		EQU	$
		LDA	>MR1PLA,X		; no cours save
		JSR	MRSVSB
		LDA	>MR1PLA,X
		JSR	MRSVSB
		LDA	>MR1PLA,X
		BRA	M1S_400
;
M1S_380		EQU	$
		LDA	!WCRSNO_1		 ; cours save
		JSR	MRSVSB
		LDA	!WGOLCT_1
		JSR	MRSVSB
		LDA	!WCRSID_1
M1S_400		EQU	$
		JSR	MRSVSB			; world,course save
;
		LDA	!PLCNT_1
		STA	<WORK4
		LDA	!WPLCNT_1
		STA	<WORK5
;
		MEM16
		REP	#00100000B		; memory 16bit mode
;
		LDA	!MRLGFG_1
		AND	#000FFH
		TAY
;
		MEM8
		SEP	#00100000B		; memory 8bit mode
;
		LDA	WORK4,Y
		BPL	M1S_410			; player count reset ?
;						; yes
		LDA	#004H
M1S_410		EQU	$
		JSR	MRSVSB			; player count save
;
		TYA
		EOR	#00000001B
		TAY
		LDA	WORK4,Y
		BPL	M1S_420			; player count reset ?
;						; yes
		LDA	#004H
M1S_420		EQU	$
		JSR	MRSVSB			; player count save
M1S_800		EQU	$
;;;;;;;;;;;;;;;;;;		  LDA	  !TOPSCR_1
;;;;;;;;;;;;;;;;;;		  JSR	  MRSVSB
;;;;;;;;;;;;;;;;;;		  LDA	  !TOPSCR_1+1
;;;;;;;;;;;;;;;;;;		  JSR	  MRSVSB
;;;;;;;;;;;;;;;;;;		  LDA	  !TOPSCR_1+2
;;;;;;;;;;;;;;;;;;		  JSR	  MRSVSB
;;;;;;;;;;;;;;;;;;		  LDA	  !TOPSCR_1+3
;;;;;;;;;;;;;;;;;;		  JSR	  MRSVSB
;;;;;;;;;;;;;;;;;;		  LDA	  !TOPSCR_1+4
;;;;;;;;;;;;;;;;;;		  JSR	  MRSVSB
;;;;;;;;;;;;;;;;;;		  LDA	  !TOPSCR_1+5
;;;;;;;;;;;;;;;;;;		  JSR	  MRSVSB		  ; top-score save
		PHX				; (X) push
		JSR	M1_TOP_CHECK		; top-score check
		PLX				; (X) pull
;
		LDA	>MR1PLA,X
		ORA	<WORK2
		JSR	MRSVSB			; ura-flag save
;
		LDA	!PLAYSW_1
		JSR	MRSVSB			; 2play mode save
;
		MEM16
		REP	#00100000B		; memory 16bit mode
;
		LDA	#00000H
		SEC
		SBC	<WORK
		STA	>SAVE_RAM,X		; file check-sum set
;
		MEM8
		IDX8
		SEP	#00110000B		; memory,index 8bit mode
;
		PLB				; (DBR) reset
		PLY				; (Y) pull
		PLX				; (X) pull
		RTL
;
;
;************************************************************************
;*		MARIO-1	 SAVE (SPECIAL)			(M1SAVE_S)	*
;************************************************************************
M1SAVE_S	EQU	$
		MEM16
		IDX16
		REP	#00110000B		; memory,index 16bit mode
;
		STZ	<WORK0
;
		LDA	>SVINDX
		TAX
;
		MEM8
		SEP	#00100000B		; memory 8bit mode
;
		LDA	>NOW_CORSNO		; cours save
		JSR	MRSVSB
;;;;;;;;;;;;		    LDA	    GOALCT_1
		LDA	#000H
		JSR	MRSVSB
;;;;;;;;;;;;		    LDA	    CORSID_1
		LDA	#000H
		JSR	MRSVSB			; world,course save
;
		LDA	!PLCNT_1
		STA	<WORK4
		LDA	!WPLCNT_1
		STA	<WORK5
;
		MEM16
		REP	#00100000B		; memory 16bit mode
;
		LDA	!MRLGFG_1
		AND	#000FFH
		TAY
;
		MEM8
		SEP	#00100000B		; memory 8bit mode
;
		LDA	WORK4,Y
		BPL	M1S_S_10		; player count reset ?
;						; yes
		LDA	#004H
M1S_S_10	EQU	$
		JSR	MRSVSB			; player count save
;
		TYA
		EOR	#00000001B
		TAY
		LDA	WORK4,Y
		BPL	M1S_S_20		; player count reset ?
;						; yes
		LDA	#004H
M1S_S_20	EQU	$
		JSR	MRSVSB			; player count save
;
		PHX				; (X) push
		JSR	M1_TOP_CHECK		; top-score check
		PLX				; (X) pull
;
		LDA	>NOW_BSLFG
		JSR	MRSVSB			; ura-flag save
;
		LDA	!PLAYSW_1
		JSR	MRSVSB			; 2play mode save
;
		MEM16
		REP	#00100000B		; memory 16bit mode
;
		LDA	#00000H
		SEC
		SBC	<WORK
		STA	>SAVE_RAM,X		; file check-sum set
;
		MEM8
		IDX8
		SEP	#00110000B		; memory,index 8bit mode
;
		LDA	#000H
		STA	>NOW_BSLFG
		STA	>NOW_CORSNO		;
;
		PLB				; (DBR) reset
		PLY				; (Y) pull
		PLX				; (X) pull
		RTL
;
;
		IDX16
;tttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttt
;t		Mario-1 top-score check			(M1_TOP_CHECK)	t
;tttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttt
M1_TOP_CHECK	EQU	$
		PHB
		LDA	#BANK MR1_TOP
		PHA
		PLB				; (DBR) set
;
		PHD				; (D) push
		LDA	#HIGH TOPSCR_1
		XBA
		LDA	#000H
		TCD				; (D) <-- HIGH TOPSCR_1
;
		LDX	#00005H
		SEC
M1_TOP_C_20	EQU	$
		LDA	<TOPSCR_1,X
		SBC	MR1_TOP,X
		DEX
		BPL	M1_TOP_C_20		; check end ?
;						; yes
		BCC	M1_TOP_C_80		; top change ?
;						; yes
		INX
M1_TOP_C_40	EQU	$
		LDA	<TOPSCR_1,X
		STA	MR1_TOP,X
		INX
		CPX	#00006H
		BCC	M1_TOP_C_40		; change end ?
;						; yes
M1_TOP_C_80	EQU	$
		PLD				; (D) pull
		PLB				; (DBR) reset
		RTS
;
;
;;;;;;;;;;;;;;;P1SCST	       EQU     $
;;;;;;;;;;;;;;;		       LDA     PLYSC1_1
;;;;;;;;;;;;;;;		       JSR     MRSVSB
;;;;;;;;;;;;;;;		       LDA     PLYSC1_1+1
;;;;;;;;;;;;;;;		       JSR     MRSVSB
;;;;;;;;;;;;;;;		       LDA     PLYSC1_1+2
;;;;;;;;;;;;;;;		       JSR     MRSVSB
;;;;;;;;;;;;;;;		       LDA     PLYSC1_1+3
;;;;;;;;;;;;;;;		       JSR     MRSVSB
;;;;;;;;;;;;;;;		       LDA     PLYSC1_1+4
;;;;;;;;;;;;;;;		       JSR     MRSVSB
;;;;;;;;;;;;;;;		       LDA     PLYSC1_1+5
;;;;;;;;;;;;;;;		       JSR     MRSVSB
;;;;;;;;;;;;;;;		       RTS
;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;P2SCST	       EQU     $
;;;;;;;;;;;;;;;		       LDA     PLYSC2_1
;;;;;;;;;;;;;;;		       JSR     MRSVSB
;;;;;;;;;;;;;;;		       LDA     PLYSC2_1+1
;;;;;;;;;;;;;;;		       JSR     MRSVSB
;;;;;;;;;;;;;;;		       LDA     PLYSC2_1+2
;;;;;;;;;;;;;;;		       JSR     MRSVSB
;;;;;;;;;;;;;;;		       LDA     PLYSC2_1+3
;;;;;;;;;;;;;;;		       JSR     MRSVSB
;;;;;;;;;;;;;;;		       LDA     PLYSC2_1+4
;;;;;;;;;;;;;;;		       JSR     MRSVSB
;;;;;;;;;;;;;;;		       LDA     PLYSC2_1+5
;;;;;;;;;;;;;;;		       JSR     MRSVSB
;;;;;;;;;;;;;;;		       RTS
;
;
;
		MEM8
		IDX8
;************************************************************************
;*		MARIO-2 SAVE				(M2SAVE)	*
;************************************************************************
M2SAVE		EQU	$
		PHX				; (X) push
		PHY				; (Y) push
;
		PHB
		PHK
		PLB				; (DBR) set
;
		MEM16
		IDX16
		REP	#00110000B		; memory,index 16bit mode
;
		STZ	<WORK0
		LDA	>SVINDX
		TAX
;
		MEM8
		SEP	#00100000B		; memory 8bit mode
;
		LDA	>MR1PLA,X
		BMI	M2S110			; world save ok ?
;						; no
		CMP	CORSNO_2
		BCC	M2S110			; world save ok ?
;						; no
		BNE	M2S108			; corse check ?
;						; yes
		LDA	>MR1PLA+(m1_world-MR1PLA)+1,X
		CMP	GOALCT_2
		BCC	M2S110			; save ok ?
;						; no
M2S108		EQU	$
		LDA	>MR1PLA,X
		JSR	MRSVSB
		LDA	>MR1PLA,X
		JSR	MRSVSB
		LDA	>MR1PLA,X
		JSR	MRSVSB			; world,course save
		BRA	M2S111
;
M2S110		EQU	$
		LDA	CORSNO_2
		JSR	MRSVSB
		LDA	GOALCT_2
		JSR	MRSVSB
		LDA	CORSID_2
		JSR	MRSVSB			; world,course save
M2S111		EQU	$
		LDA	PLCNT_2
;;;;;;;;;;;;;;;		       CMP     #4
;;;;;;;;;;;;;;;		       BCS     M2S215
;;;;;;;;;;;;;;;		       LDA     #4
;;;;;;;;;;;;;;;M2S215	       EQU     $
		BPL	M2S215			; player count reset ?
;						; yes
		LDA	#004H
M2S215		EQU	$
		JSR	MRSVSB			; player count save
;;;;;;;;;;;;;;;		       LDA     ENCOCT1_1
;;;;;;;;;;;;;;;		       JSR     MRSVSB
;;;;;;;;;;;;;;;;;;		  LDA	  TOPSCR_2
;;;;;;;;;;;;;;;;;;		  JSR	  MRSVSB
;;;;;;;;;;;;;;;;;;		  LDA	  TOPSCR_2+1
;;;;;;;;;;;;;;;;;;		  JSR	  MRSVSB
;;;;;;;;;;;;;;;;;;		  LDA	  TOPSCR_2+2
;;;;;;;;;;;;;;;;;;		  JSR	  MRSVSB
;;;;;;;;;;;;;;;;;;		  LDA	  TOPSCR_2+3
;;;;;;;;;;;;;;;;;;		  JSR	  MRSVSB
;;;;;;;;;;;;;;;;;;		  LDA	  TOPSCR_2+4
;;;;;;;;;;;;;;;;;;		  JSR	  MRSVSB
;;;;;;;;;;;;;;;;;;		  LDA	  TOPSCR_2+5
;;;;;;;;;;;;;;;;;;		  JSR	  MRSVSB		  ; top-score save
		PHX				; (X) push
		JSR	M2_TOP_CHECK		; top-score check
		PLX				; (X) pull
;
;;;;;;;;;;;;;;;		       JSR     P1SCST
;
		LDA	WARPCT_2
		JSR	MRSVSB			; warp-flag save
;
		LDA	>SAVEBF+(m2_new-MR2PLA)
		JSR	MRSVSB			; new-game
;
		MEM16
		REP	#00100000B		; memory 16bit mode
;
		LDA	#00000H
		SEC
		SBC	<WORK
		STA	>SAVE_RAM,X		; fiel check-sum set
M2S120		EQU	$
		MEM8
		IDX8
		SEP	#00110000B		; memory,index 8bit mode
;
		PLB				; (DBR) reset
		PLY				; (Y) pull
		PLX				; (X) pull
		RTL
;
;
		IDX16
;tttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttt
;t		Mario-2 top-score check			(M2_TOP_CHECK)	t
;tttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttt
M2_TOP_CHECK	EQU	$
		PHB
		LDA	#BANK MR2_TOP
		PHA
		PLB				; (DBR) set
;
		PHD				; (D) push
		LDA	#HIGH TOPSCR_2
		XBA
		LDA	#000H
		TCD				; (D) <-- HIGH TOPSCR_1
;
		LDX	#00005H
		SEC
M2_TOP_C_20	EQU	$
		LDA	<TOPSCR_2,X
		SBC	MR2_TOP,X
		DEX
		BPL	M2_TOP_C_20		; check end ?
;						; yes
		BCC	M2_TOP_C_80		; top change ?
;						; yes
		INX
M2_TOP_C_40	EQU	$
		LDA	<TOPSCR_2,X
		STA	MR2_TOP,X
		INX
		CPX	#00006H
		BCC	M2_TOP_C_40		; change end ?
;						; yes
M2_TOP_C_80	EQU	$
		PLD				; (D) pull
		PLB				; (DBR) reset
		RTS
;
;
;
		MEM8
		IDX8
;************************************************************************
;*		MARIO-USA SAVE				(MUSAVE)	*
;************************************************************************
MUSAVE		EQU	$
		PHX				; (X) push
		PHY				; (Y) push
;
		PHB
		PHK
		PLB				; (DBR) set
;
		STZ	<WORKF
		LDA	STWRDNO_USA
		CMP	#13H
		BNE	MUS005
		DEC	STWRDNO_USA
		INC	<WORKF
MUS005		EQU	$
		STZ	<WORK2
		STZ	<WORK3
		STZ	<WORK
		STZ	<WORK1
		LDA	STWRDNO_USA
;;;;;;		INC	A
MUS010		EQU	$
		CMP	#03H
		BCC	MUS100
		SEC
		SBC	#3
		INC	<WORK2		; WORLD NO
		BRA	MUS010
;
MUS100		EQU	$
		IDX16
		REP	#10H
		STA	<WORK3		; CORS NO
		LDA	>SVINDX+1
		XBA
		LDA	>SVINDX
		TAX
;
		LDA	<WORKF
		BNE	MUS110
;
		LDA	>MR1PLA,X
		BMI	MUS110
		CMP	<WORK2
		BEQ	MUS107
		BCC	MUS110
		JMP	MUS520X
MUS107		EQU	$
		LDA	>MR1PLA+(m1_world-MR1PLA)+1,X
		CMP	<WORK3
		BCC	MUS110
MUS520X		EQU	$
		LDA	>MR1PLA,X
		JSR	MRSVSB
		LDA	>MR1PLA,X
		JSR	MRSVSB
		BRA	MUS520XE
;
MUS110		EQU	$
		LDA	<WORK2
		JSR	MRSVSB
		LDA	<WORK3
		JSR	MRSVSB
MUS520XE	EQU	$
		LDA	PLCNT_USA
;;;;;;;;;;;;;;;		       CMP     #05H
;;;;;;;;;;;;;;;		       BCS     MUS111
;;;;;;;;;;;;;;;		       LDA     #05H
;;;;;;;;;;;;;;;MUS111	       EQU     $
		BNE	MUS111			; player count reset ?
;						; yes
		LDA	#005H
MUS111		EQU	$
		JSR	MRSVSB
		LDA	PLDOWN_USA
		JSR	MRSVSB
		LDA	PLDOWN_USA+1
		JSR	MRSVSB
		LDA	PLDOWN_USA+2
		JSR	MRSVSB
		LDA	PLDOWN_USA+3
		JSR	MRSVSB
;
MUS119		EQU	$
		MEM16
		REP	#20H
		LDA	#0
		SEC
		SBC	<WORK
		STA	>SAVERM,X
;
MUS120		EQU	$
		MEM8
		IDX8
		SEP	#30H
;
		LDA	<WORKF
		BEQ	MUS130
		INC	STWRDNO_USA
MUS130		EQU	$
		PLB				; (DBR) reset
		PLY				; (Y) pull
		PLX				; (X) pull
		RTL
;
MUS520		EQU	$
		STZ	<WORK
		STZ	<WORK1
		LDA	>MR1PLA,X
		JSR	MRSVSB
		LDA	>MR1PLA,X
		JSR	MRSVSB
		LDA	>MR1PLA,X
		JSR	MRSVSB
		LDA	PLDOWN_USA
		JSR	MRSVSB
		LDA	PLDOWN_USA+1
		JSR	MRSVSB
		LDA	PLDOWN_USA+2
		JSR	MRSVSB
		LDA	PLDOWN_USA+3
		JSR	MRSVSB
		JMP	MUS119
;
;
;
;************************************************************************
;*	JSR	M3SAVE		(MARIO-3 SAVE ROUTINE)			*
;************************************************************************
M3SAVE		EQU	$
		PHX				; (X) push
		PHY				; (Y) push
;
		PHB
		PHK
		PLB				; (DBR) set
;
		MEM16
		IDX16
		REP	#00110000B		; memory,index 16bit mode
;
		LDA	<WORK0
		PHA				; (work0) push
		STZ	<WORK0
		LDA	>SVINDX
		TAX
;
		MEM8
		SEP	#00100000B		; memory 8bit mode
;
		LDA	>MR1PLA,X	; mapno initial?
		BPL	M3S090
		INC	A
		STA	>MR1PLA,X	; mapno initial set
		BRA	M3S100
M3S090		EQU	$
		CMP	MAPCOS_3	; save ok?
		BEQ	M3S100		; yes
		BCC	M3S100		; yes
		JMP	M3S101		; no  (M3S101)
;
M3S100		EQU	$
		LDA	MAPCOS_3
		STA	>MR1PLA,X	; mapno save
;
		PHX
		LDY	#0		; bitbuff save
M3S500		EQU	$
		LDA	BITBUFF_3,Y
		STA	>MR1PLA+(m3_map-MR3PLA),X
		INX
		INY
		CPY	#080H
		BCC	M3S500
;
		PLX
		PHX
		LDY	#0
M3S510		EQU	$		; enemy data save
		LDA	MPEYPS_3,Y
		STA	>MR1PLA+(m3_enmy-MR3PLA),X
		INX
		INY
		CPY	#038H
		BCC	M3S510
;
		PLX
;
		LDA	PLINIT_3	; 1play 2play mode save
		STA	>MR1PLA+(m3_2play-MR3PLA),X
;
M3S101		EQU	$
		PHX
		LDY	#0		; item-ram save
M3S101A		EQU	$
		LDA	ITEMRM_3,Y
		STA	>MR1PLA+(m3_item-MR3PLA),X
		INX
		INY
		CPY	#046H
		BCC	M3S101A
;
		PLX
		PHX
		LDA	PLAYCT_3	; player count save routine
;;;;;;;;;;;;;;;		       BMI     M3S102	       ; if playct < 4 then playct = 4
;;;;;;;;;;;;;;;		       CMP     #4
;;;;;;;;;;;;;;;		       BCS     M3S103
;;;;;;;;;;;;;;;M3S102	       EQU     $
;;;;;;;;;;;;;;;		       LDA     #4
		BPL	M3S103			; player count reset ?
;						; yes
		LDA	#004H
M3S103		EQU	$
		STA	>MR1PLA+(m3_playct-MR3PLA),X
		LDA	PLAYCT_3+1
;;;;;;;;;;;;;;;		       BMI     M3S106
;;;;;;;;;;;;;;;		       CMP     #4
;;;;;;;;;;;;;;;		       BCS     M3S107
;;;;;;;;;;;;;;;M3S106	       EQU     $
;;;;;;;;;;;;;;;		       LDA     #4
		BPL	M3S107			; player count reset ?
;						; yes
		LDA	#004H
M3S107		EQU	$
		STA	>MR1PLA+(m3_playct-MR3PLA)+1,X
;
;;;;;;;;;;;;;;;		       LDA     >SPDFLG_3
;;;;;;;;;;;;;;;		       STA     >MR1PLA+116H,X
;;;;;;;;;;;;;;;		       LDA     >SPDFLG_3+1
;;;;;;;;;;;;;;;		       STA     >MR1PLA+117H,X
;;;;;;;;;;;;;;;		       LDA     >SPDFLG_3+2
;;;;;;;;;;;;;;;		       STA     >MR1PLA+118H,X
;
M3S600		EQU	$
		PLX
		PHX
		LDA	>TSHIPF_3
		STA	>MR1PLA+(m3_takara-MR3PLA),X
;;;;;;;;;;;;;;;		       LDA     MNYPOS_3
;;;;;;;;;;;;;;;		       STA     >MR1PLA+004H,X
;;;;;;;;;;;;;;;		       LDA     MNXPSH_3
;;;;;;;;;;;;;;;		       STA     >MR1PLA+006H,X
;;;;;;;;;;;;;;;		       LDA     MNXPSL_3
;;;;;;;;;;;;;;;		       STA     >MR1PLA+008H,X
;;;;;;;;;;;;;;;		       LDA     SCCHDT_3
;;;;;;;;;;;;;;;		       STA     >MR1PLA+108H,X
;;;;;;;;;;;;;;;		       LDA     MSBHDT_3
;;;;;;;;;;;;;;;		       STA     >MR1PLA+10AH,X
;;;;;;;;;;;;;;;		       LDA     >INTYPS_3
;;;;;;;;;;;;;;;		       STA     >MR1PLA+10CH,X
;;;;;;;;;;;;;;;		       LDA     >INTXPH_3
;;;;;;;;;;;;;;;		       STA     >MR1PLA+10EH,X
;;;;;;;;;;;;;;;		       LDA     >INTXPL_3
;;;;;;;;;;;;;;;		       STA     >MR1PLA+110H,X
;;;;;;;;;;;;;;;		       LDA     >INTSCH_3
;;;;;;;;;;;;;;;		       STA     >MR1PLA+112H,X
;;;;;;;;;;;;;;;		       LDA     >INTMSH_3
;;;;;;;;;;;;;;;		       STA     >MR1PLA+114H,X
;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;		       LDA     PLINIT_3
;;;;;;;;;;;;;;;		       CMP     #2	       ; 2play mode?
;;;;;;;;;;;;;;;		       BNE     M3S800	       ; no  (M3S800)
;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;		       LDA     MNYPOS_3+1
;;;;;;;;;;;;;;;		       STA     >MR1PLA+005H,X
;;;;;;;;;;;;;;;		       LDA     MNXPSH_3+1
;;;;;;;;;;;;;;;		       STA     >MR1PLA+007H,X
;;;;;;;;;;;;;;;		       LDA     MNXPSL_3+1
;;;;;;;;;;;;;;;		       STA     >MR1PLA+009H,X
;;;;;;;;;;;;;;;		       LDA     SCCHDT_3+1
;;;;;;;;;;;;;;;		       STA     >MR1PLA+109H,X
;;;;;;;;;;;;;;;		       LDA     MSBHDT_3+1
;;;;;;;;;;;;;;;		       STA     >MR1PLA+10BH,X
;;;;;;;;;;;;;;;		       LDA     >INTYPS_3+1
;;;;;;;;;;;;;;;		       STA     >MR1PLA+10DH,X
;;;;;;;;;;;;;;;		       LDA     >INTXPH_3+1
;;;;;;;;;;;;;;;		       STA     >MR1PLA+10FH,X
;;;;;;;;;;;;;;;		       LDA     >INTXPL_3+1
;;;;;;;;;;;;;;;		       STA     >MR1PLA+111H,X
;;;;;;;;;;;;;;;		       LDA     >INTSCH_3+1
;;;;;;;;;;;;;;;		       STA     >MR1PLA+113H,X
;;;;;;;;;;;;;;;		       LDA     >INTMSH_3+1
;;;;;;;;;;;;;;;		       STA     >MR1PLA+115H,X
;
M3S800		EQU	$
;;;;;;;;;;;;;;;		       LDY     #011BH	       ; check sum set
		LDY	#(m3_sum-MR3PLA)
		PLX
M3S550		EQU	$
		LDA	>MR1PLA,X
		CLC
		ADC	<WORK
		STA	<WORK
		LDA	#0
		ADC	<WORK1
		STA	<WORK1
		INX
		DEY
		BNE	M3S550
;
		MEM16
		REP	#20H
		LDA	#0
		SEC
		SBC	<WORK
		STA	>MR1PLA,X
		MEM8
		SEP	#20H
		LDA	#0
		STA	>NOTSALE
;
M3S900		EQU	$
		MEM8
		IDX8
		SEP	#30H
;
		PLA
		STA	<WORK1
		PLA
		STA	<WORK
;
		PLB				; (DBR) reset
		PLY				; (Y) pull
		PLX				; (X) pull
		RTL
;
;
;
;
MRSVSB		EQU	$
		STA	>SAVERM,X
		INX
		CLC
		ADC	<WORK
		STA	<WORK
		LDA	<WORK1
		ADC	#0
		STA	<WORK1
		RTS
;
;;;;;;;;;;;;;;;BTSAVE	       EQU     $
;;;;;;;;;;;;;;;		       PHX
;;;;;;;;;;;;;;;		       LDA     >PLNOWK
;;;;;;;;;;;;;;;		       AND     #00000011B
;;;;;;;;;;;;;;;		       ASL     A
;;;;;;;;;;;;;;;		       ASL     A
;;;;;;;;;;;;;;;		       TAX
;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;		       LDA     MRIWIN
;;;;;;;;;;;;;;;		       STA     >BTLPLA,X
;;;;;;;;;;;;;;;		       LDA     MRIWIN+1
;;;;;;;;;;;;;;;		       STA     >BTLPLA+1,X
;;;;;;;;;;;;;;;		       LDA     LUIWIN
;;;;;;;;;;;;;;;		       STA     >BTLPLA+2,X
;;;;;;;;;;;;;;;		       LDA     LUIWIN+1
;;;;;;;;;;;;;;;		       STA     >BTLPLA+3,X
;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;		       PLX
;;;;;;;;;;;;;;;		       RTL
;;;;;;;;;;;;;;;;
;
SV_CHK_E	EQU	$
;
;
;
;
;
		MEM8
		IDX8
;************************************************************************
;*		PPU Error display			(PPU_ERROR)	*
;************************************************************************
PPU_ERR_M	EQU	$
P_E_M0		EQU	$
;				   T	  H	 I	S	      G	     A
		WORD	0003BH,0001DH,00011H,00012H,0001CH,0003BH,00010H,0000AH
;			    M	   E		 P	A      K	     I
		WORD	00016H,0000EH,0003BH,00019H,0000AH,00014H,0003BH,00012H
;			    S		  N	 O	T
		WORD	0001CH,0003BH,00017H,00018H,0001DH,0003BH,0003BH,0003BH
;
P_E_M1		EQU	$
;			    D	   E	  S	 I	G      I      N	     E
		WORD	0000DH,0000EH,0001CH,00012H,00010H,00012H,00017H,0000EH
;			    D		  F	 O	R	      Y	     O
		WORD	0000DH,0003BH,0000FH,00018H,0001BH,0003BH,00022H,00018H
;			    U	   R		 S	U      P      E	     R
		WORD	0001EH,0001BH,0003BH,0001CH,0001EH,00019H,0000EH,0001BH
;
P_E_M2		EQU	$
;			    F	   A	   M	  I	 C	O      M
		WORD	0000FH,0000AH,00016H,00012H,0000CH,00018H,00016H,0003BH
;			    O	   R		 S	U      P      R	     R
		WORD	00018H,0001BH,0003BH,0001CH,0001EH,00019H,0000EH,0001BH
;				   N	  E	 S	.
		WORD	0003BH,00017H,0000EH,0001CH,00026H,0003BH,0003BH,0003BH
;
P_E_M3		EQU	$
;						 N	I      N      T	     E
		WORD	0003BH,0003BH,0003BH,00017H,00012H,00017H,0001DH,0000EH
;			    N	   D	  O		C      O      .	     ,
		WORD	00017H,0000DH,00018H,0003BH,0000CH,00018H,00026H,00027H
;			    L	   T	  D	 .
		WORD	00015H,0001DH,0000DH,00026H,0003BH,0003BH,0003BH,0003BH
;
;
;
;
PPU_ERROR	EQU	$
		JSR	PPURGIT_0		;
;
		MEM8
		SEP	#00100000B		; memory 8bit mode
;
		PHD				; (D) push
;
		STZ	02121H			; CG. RAM address set
;
		MEM16
		REP	#00100000B		; memory 16bit mode
;
		LDA	#03B3BH
		STA	<WORK2
		LDA	#01000H-0800H
		STA	<WORK0
		LDY	#000H
		JSL	>DMA_D_M		; ram clear (00800H ~ 00FFFH)
;
		LDA	#04300H&0FF00H
		TCD				; (D) <-- #04300H&0FF00H
;
		LDY	#10000000B
		STY	02115H			; inc mode
;
		LDA	#07FFFH
		STA	0200H+18H
		LDA	#07FF9H
		STA	0200H+1AH
		LDA	#07FD0H
		STA	0200H+1CH
		LDA	#06AE9H
		STA	0200H+1EH
		LDA	#02200H
		STA	<04300H			; inc. mode & B-bus address set
		LDA	#00200H
		STA	<04302H			; A-bus address (L,H)
		LDX	#BANK 00200H
		STX	<04304H			;		(B)
		STA	<04305H			; data count
		LDY	#00000001B
		STY	0420BH			; CG. DMA
;
		LDA	#01801H
		STA	<04300H			; B-bus addess & control paramater
		LDA	#00000H
		STA	02116H			; Vram address set
		LDA	#198000H+0C0H*20H
		STA	<04302H			; A-bus address (L,H)
		LDX	#BANK 198000H+0C0H*20H
		STX	<04304H			;		(B)
		LDA	#00040H*20H
		STA	<04305H			; data count
		STY	0420BH			; BG. character DMA
;
		PHB
		LDX	#BANK PPU_ERR_M
		PHX
		PLB				; (DBR) set
;
		LDX	#000H
PPU_ER040	EQU	$
		LDA	P_E_M0,X
		STA	!09CAH,X
		LDA	P_E_M1,X
		STA	!0A4AH,X
		LDA	P_E_M2,X
		STA	!0ACAH,X
		LDA	P_E_M3,X
		STA	!0C4AH,X
		INX
		INX
		CPX	#P_E_M1-PPU_ERR_M
		BNE	PPU_ER040		; set end ?
;						; yes
ROM_ER_000	EQU	$
		PLB				; (DBR) reset
;
		LDA	#01000H
		STA	02116H
		LDA	#000800H
		STA	<04302H			; A-bus address (L,H)
		LDX	#BANK 00800H
		STX	<04304H			;		(B)
		STA	<04305H			; data count
		STY	0420BH			; BG.1 screen DMA
;
		MEM8
		SEP	#00100000B		; memory 8bit mode
;
		PLD				; (D) pull
;
		LDA	#00010000B
		STA	02107H			; BG.1 screen address & size
		STZ	0210BH			; BG.1 character address
		LDA	#00000001B
		STA	0212CH			; BG.1 only main
		STZ	0212DH
		LDA	#00000001B
		STA	02105H			; mode[1]
		STZ	02130H
		STZ	02131H
;
		STZ	0210DH
		STZ	0210DH
		STZ	0210EH
		STZ	0210EH
		STZ	0210FH
		STZ	0210FH
		STZ	02110H
		STZ	02110H
		STZ	02111H
		STZ	02111H
		STZ	02112H
		STZ	02112H			; BG.1,2,3 scroll count reset
;
		LDA	#00001111B
		STA	02100H
;
ERR_LOOP	EQU	$
		BIT	04212H
		BPL	ERR_LOOP		; V-blank on ?
;						; yes
		INC	<FCNT
		LDA	<FCNT
		CMP	#018H
		BNE	ERR_LOOP1		;
;
		STZ	<FCNT
;						;
		STZ	02121H			; CG. RAM address set
;
		MEM16
		REP	#00100000B		; memory 16bit mode
;
		LDA	#04300H&0FF00H
		TCD				; (D) <-- #04300H&0FF00H
;
		LDY	#10000000B
		STY	02115H			; inc mode
;
		LDA	0200H+1AH
		PHA
		LDA	0200H+1CH
		STA	0200H+1AH
		LDA	0200H+1EH
		STA	0200H+1CH
		PLA
		STA	0200H+1EH
;
		LDA	#02200H
		STA	<04300H			; inc. mode & B-bus address set
		LDA	#00200H
		STA	<04302H			; A-bus address (L,H)
		LDX	#BANK 00200H
		STX	<04304H			;		(B)
		STA	<04305H			; data count
		LDY	#00000001B
		STY	0420BH			; CG. DMA
;
		LDA	#00000H
		TCD				; (D) <-- #00000H
;
		MEM8
		SEP	#00100000B		; memory 8bit mode
;
ERR_LOOP1	EQU	$
		BIT	04212H
		BMI	ERR_LOOP1		; V-blank off ?
;						; yes
		JMP	ERR_LOOP
;
;
;
;
;
;************************************************************************
;*		Rom ERROR				(ROM_ERROR)	*
;************************************************************************
n_0		EQU	00000H
n_1		EQU	00001H
n_2		EQU	00002H
n_3		EQU	00003H
n_4		EQU	00004H
n_5		EQU	00005H
n_6		EQU	00006H
n_7		EQU	00007H
n_8		EQU	00008H
n_9		EQU	00009H
n_A		EQU	0000AH
n_B		EQU	0000BH
n_C		EQU	0000CH
n_D		EQU	0000DH
n_E		EQU	0000EH
n_F		EQU	0000FH
n_G		EQU	00010H
n_H		EQU	00011H
n_I		EQU	00012H
n_J		EQU	00013H
n_K		EQU	00014H
n_L		EQU	00015H
n_M		EQU	00016H
n_N		EQU	00017H
n_O		EQU	00018H
n_P		EQU	00019H
n_Q		EQU	0001AH
n_R		EQU	0001BH
n_S		EQU	0001CH
n_T		EQU	0001DH
n_U		EQU	0001EH
n_V		EQU	0001FH
n_W		EQU	00020H
n_X		EQU	00021H
n_Y		EQU	00022H
n_Z		EQU	00023H
n_p		EQU	00026H
n_t		EQU	0003AH
n_s		EQU	0003BH
;
ROM_ERR_M	EQU	$
R_E_M0		EQU	$
		WORD	n_W,n_A,n_R,n_N,n_I,n_N,n_G,n_t,n_s,n_I,n_T,n_s,n_I,n_S,n_s,n_A
		WORD	n_s,n_S,n_E,n_R,n_I,n_O,n_U,n_S,n_s,n_s
;
R_E_M1		EQU	$
		WORD	n_C,n_R,n_I,n_M,n_E,n_s,n_T,n_O,n_s,n_C,n_O,n_P,n_Y,n_s,n_V,n_I
		WORD	n_D,n_E,n_O,n_s,n_G,n_A,n_M,n_E,n_S,n_p
;
R_E_M2		EQU	$
		WORD	n_1,n_8,n_s,n_U,n_S,n_C,n_s,n_2,n_3,n_1,n_9,n_s,n_P,n_L,n_E,n_A
		WORD	n_S,n_E,n_s,n_R,n_E,n_F,n_E,n_R,n_s,n_s
;
R_E_M3		EQU	$
		WORD	n_T,n_O,n_s,n_Y,n_O,n_U,n_R,n_s,n_N,n_I,n_N,n_T,n_E,n_N,n_D,n_O
		WORD	n_s,n_G,n_A,n_M,n_E,n_s,n_s,n_s,n_s,n_s
;
R_E_M4		EQU	$
		WORD	n_I,n_N,n_S,n_T,n_R,n_U,n_C,n_T,n_I,n_O,n_N,n_s,n_B,n_O,n_O,n_K
		WORD	n_L,n_E,n_T,n_s,n_F,n_O,n_R,n_s,n_s,n_s
;
R_E_M5		EQU	$
		WORD	n_F,n_U,n_R,n_T,n_H,n_E,n_R,n_s,n_I,n_N,n_F,n_O,n_R,n_M,n_A,n_T
		WORD	n_I,n_O,n_N,n_p,n_s,n_s,n_s,n_s,n_s,n_s
;
;
;
ROM_ERROR	EQU	$
		SEI				; IRQ  disable
		STZ	04200H			; NMI
		STZ	0420CH			; HDMA
		STZ	0420BH			; DMA
		LDA	#10000000B
		STA	02100H			; balnking on!!
;
		STZ	02140H
		STZ	02141H
		STZ	02143H
		LDA	#0F0H
		STA	02142H			; BGM. stop
;
		JSR	PPURGIT_0		;
;
		MEM8
		SEP	#00100000B		; memory 8bit mode
;
		PHD				; (D) push
;
		STZ	02121H			; CG. RAM address set
;
		MEM16
		REP	#00100000B		; memory 16bit mode
;
		LDA	#03B3BH
		STA	<WORK2
		LDA	#01000H-0800H
		STA	<WORK0
		LDY	#000H
		JSL	>DMA_D_M		; ram clear (00800H ~ 00FFFH)
;
		LDA	#04300H&0FF00H
		TCD				; (D) <-- #04300H&0FF00H
;
		LDY	#10000000B
		STY	02115H			; inc mode
;
		LDA	#07FFFH
		STA	0200H+18H
		LDA	#07FF9H
		STA	0200H+1AH
		LDA	#07FD0H
		STA	0200H+1CH
		LDA	#06AE9H
		STA	0200H+1EH
		LDA	#02200H
		STA	<04300H			; inc. mode & B-bus address set
		LDA	#00200H
		STA	<04302H			; A-bus address (L,H)
		LDX	#BANK 00200H
		STX	<04304H			;		(B)
		STA	<04305H			; data count
		LDY	#00000001B
		STY	0420BH			; CG. DMA
;
		LDA	#01801H
		STA	<04300H			; B-bus addess & control paramater
		LDA	#00000H
		STA	02116H			; Vram address set
		LDA	#198000H+0C0H*20H
		STA	<04302H			; A-bus address (L,H)
		LDX	#BANK 198000H+0C0H*20H
		STX	<04304H			;		(B)
		LDA	#00040H*20H
		STA	<04305H			; data count
		STY	0420BH			; BG. character DMA
;
		PHB
		LDX	#BANK ROM_ERR_M
		PHX
		PLB				; (DBR) set
;
		LDX	#000H
ROM_ER040	EQU	$
		LDA	R_E_M0,X
		STA	!09C6H,X
		LDA	R_E_M1,X
		STA	!0A46H,X
		LDA	R_E_M2,X
		STA	!0B46H,X
		LDA	R_E_M3,X
		STA	!0BC6H,X
		LDA	R_E_M4,X
		STA	!0C46H,X
		LDA	R_E_M5,X
		STA	!0CC6H,X
		INX
		INX
		CPX	#R_E_M1-ROM_ERR_M
		BNE	ROM_ER040		; set end ?
;						; yes
		JMP	ROM_ER_000
;
;
;
;
;
;
;
;
;
;************************************************************************
;*	en data and warizan data			(DIVDAT)	*
;************************************************************************
WINDAT0		EQU	$			; en data (R 0FFH)
;			  0   1	  2   3	  4   5	  6   7
		HEX	0FF,0FF,0FF,0FF,0FF,0FF,0FF,0FF
		HEX	0FF,0FF,0FF,0FF,0FE,0FE,0FE,0FE
		HEX	0FD,0FD,0FD,0FD,0FC,0FC,0FC,0FB
		HEX	0FB,0FB,0FA,0FA,0F9,0F9,0F8,0F8
		HEX	0F7,0F7,0F6,0F6,0F5,0F5,0F4,0F3
		HEX	0F3,0F2,0F1,0F1,0F0,0EF,0EE,0EE
		HEX	0ED,0EC,0EB,0EA,0E9,0E9,0E8,0E7
		HEX	0E6,0E5,0E4,0E3,0E2,0E1,0DF,0DE
		HEX	0DD,0DC,0DB,0DA,0D8,0D7,0D6,0D5
		HEX	0D3,0D2,0D0,0CF,0CD,0CC,0CA,0C9
		HEX	0C7,0C6,0C4,0C2,0C1,0BF,0BD,0BB
		HEX	0B9,0B7,0B6,0B4,0B1,0AF,0AD,0AB
		HEX	0A9,0A7,0A4,0A2,09F,09D,09A,097
		HEX	095,092,08F,08C,089,086,082,07F
		HEX	07B,078,074,070,06C,067,063,05E
		HEX	059,053,04D,046,03F,037,02D,01F
		HEX	000
;
DIVDAT	EQU	$				; warizan data
	WORD	0FFFFH
	WORD	0FFFFH,08000H,05555H,04000H,03333H,02AAAH,02492H,02000H
	WORD	01C71H,01999H,01745H,01555H,013B1H,01249H,01111H,01000H
	WORD	00F0FH,00E38H,00D79H,00CCCH,00C30H,00BA2H,00B21H,00AAAH
	WORD	00A3DH,009D8H,0097BH,00924H,008D3H,00888H,00842H,00800H
	WORD	007C1H,00787H,00750H,0071CH,006EBH,006BCH,00690H,00666H
	WORD	0063EH,00618H,005F4H,005D1H,005B0H,00590H,00572H,00555H
	WORD	00539H,0051EH,00505H,004ECH,004D4H,004BDH,004A7H,00492H
	WORD	0047DH,00469H,00456H,00444H,00432H,00421H,00410H,00400H
	WORD	003F0H,003E0H,003D2H,003C3H,003B5H,003A8H,0039BH,0038EH
	WORD	00381H,00375H,00369H,0035EH,00353H,00348H,0033DH,00333H
	WORD	00329H,0031FH,00315H,0030CH,00303H,002FAH,002F1H,002E8H
	WORD	002E0H,002D8H,002D0H,002C8H,002C0H,002B9H,002B1H,002AAH
	WORD	002A3H,0029CH,00295H,0028FH,00288H,00282H,0027CH,00276H
	WORD	00270H,0026AH,00264H,0025EH,00259H,00253H,0024EH,00249H
	WORD	00243H,0023EH,00239H,00234H,00230H,0022BH,00226H,00222H
	WORD	0021DH,00219H,00214H,00210H,0020CH,00208H,00204H,00200H
	WORD	001FCH,001F8H,001F4H,001F0H,001ECH,001E9H,001E5H,001E1H
	WORD	001DEH,001DAH,001D7H,001D4H,001D0H,001CDH,001CAH,001C7H
	WORD	001C3H,001C0H,001BDH,001BAH,001B7H,001B4H,001B2H,001AFH
	WORD	001ACH,001A9H,001A6H,001A4H,001A1H,0019EH,0019CH,00199H
	WORD	00197H,00194H,00192H,0018FH,0018DH,0018AH,00188H,00186H
	WORD	00183H,00181H,0017FH,0017DH,0017AH,00178H,00176H,00174H
	WORD	00172H,00170H,0016EH,0016CH,0016AH,00168H,00166H,00164H
	WORD	00162H,00160H,0015EH,0015CH,0015AH,00158H,00157H,00155H
	WORD	00153H,00151H,00150H,0014EH,0014CH,0014AH,00149H,00147H
	WORD	00146H,00144H,00142H,00141H,0013FH,0013EH,0013CH,0013BH
	WORD	00139H,00138H,00136H,00135H,00133H,00132H,00130H,0012FH
	WORD	0012EH,0012CH,0012BH,00129H,00128H,00127H,00125H,00124H
	WORD	00123H,00121H,00120H,0011FH,0011EH,0011CH,0011BH,0011AH
	WORD	00119H,00118H,00116H,00115H,00114H,00113H,00112H,00111H
	WORD	0010FH,0010EH,0010DH,0010CH,0010BH,0010AH,00109H,00108H
	WORD	00107H,00106H,00105H,00104H,00103H,00102H,00101H,00100H
;
;
;
;
;
;
;
;
;
;************************************************************************
;*		VECTOR							*
;************************************************************************
;===============  Native mode vector  ===================================
		ORG	0FFE4H
;
		WORD	RTISUB			;COP
		ORG	0FFE8H
		WORD	RTISUB			;Abort
		WORD	INTSUB			;NMI
		WORD	GSTART			;(???)RESET?
		WORD	IRQSUB			;IRQ
;
;===============  Emulation mode vector	 ================================
		ORG	0FFF4H
;
		WORD	RTISUB			;COP
		WORD	RTISUB			;(???)
		WORD	RTISUB			;About
		WORD	RTISUB			;NMI
		WORD	GSTART			;Reset
		WORD	IRQSUB			;IRQ
;
;
;
		END

;
;
;
;
;
;
;
;
;
;
;
;
;************************************************************************
;*		Cursol window set			(CR_WINDOW)	*
;************************************************************************
X_W_DT		EQU	$
		WORD	06433H,09463H,0C493H,0F0C3H
Y_W_DT		EQU	$
		WORD	00042H*2,0005AH*2,00072H*2,0008AH*2
;
CR_WINDOW_IT	EQU	$
CR_WINDOW	EQU	$
		PHB
		PHK
		PLB				; (DBR) set
;
		MEM16
		IDX16
		REP	#00110000B		; memory,index 16bit mode
;
		LDA	#0FF00H
		LDX	#00000H*2
CR_WW_010	EQU	$
		STA	!BG3SCR,X
		INX
		INX
		CPX	#00020H*2
		BNE	CR_WW_010		; title off end ?
;						; yes
		LDA	<PLAYNO
		AND	#000FFH
		ASL	A
		TAX
		LDA	Y_W_DT,X
		STA	<WORK0
		CLC
		ADC	#0001AH*2
		CMP	#000A4H*2
		BNE	CR_WW_015		; limit over ?
;						; yes
		LDA	#000A0H*2
CR_WW_015	EQU	$
		STA	<WORK2
;
		LDA	<GAMENO
		AND	#000FFH
		ASL	A
		TAX
		LDA	X_W_DT,X
		LDX	#00028H*2
CR_WW_020	EQU	$
		STA	!BG3SCR,X
		INX
		INX
		CPX	<WORK0
		BNE	CR_WW_020		; set end ?
;						; yes
		AND	#0FF00H
		ORA	#00010H
CR_WW_040	EQU	$
		STA	!BG3SCR,X
		INX
		INX
		CPX	<WORK2
		BNE	CR_WW_040		; set end ?
;						; yes
		LDA	#000FFH
CR_WW_060	EQU	$
		STA	!BG3SCR,X
		INX
		INX
		CPX	#000A7H*2
		BNE	CR_WW_060		; buffer init. clear end ?
;						; yes
		XBA
CR_WW_080	EQU	$
		STA	!BG3SCR,X
		INX
		INX
		CPX	#000E0H*2
		BNE	CR_WW_080		; end clear end ?
;						; yes
		MEM8
		IDX8
		SEP	#00110000B		; memory,index 8bit mode
;
		PLB				; (DBR) reset
		RTS
