	NOLIST
;
;************************************************************************
;*                                                                      *
;*      title name      : "tensai BAKABON"                              *
;*      proccess        : ram name	                                *
;*      file name       : m5ram		                                *
;*                                                                      *
;************************************************************************
;
;
;
;
;****************************************************************
;*	0 page ram						*
;****************************************************************
;
;------	work --------------------------------------------		
WORK	EQU	000H	
WORK0	EQU	WORK
WORK1	EQU	WORK0+1
WORK2	EQU	WORK1+1
WORK3	EQU	WORK2+1
WORK4	EQU	WORK3+1
WORK5	EQU	WORK4+1
WORK6	EQU	WORK5+1
WORK7	EQU	WORK6+1
WORK8	EQU	WORK7+1
WORK9	EQU	WORK8+1
WORKA	EQU	WORK9+1
WORKB	EQU	WORKA+1
WORKC	EQU	WORKB+1
WORKD	EQU	WORKC+1
WORKE	EQU	WORKD+1
WORKF	EQU	WORKE+1
;
;------	system flag -------------------------------------
NMIFLG	EQU	WORK+10H	;NMI flag
IRQFLG	EQU	NMIFLG+1	;IRQ  "
VRFLG	EQU	IRQFLG+1	;BG write flag
FRCNT	EQU	VRFLG+1		;frame counter
;
;------ controller flag ---------------------------------
KEYC1L	EQU	FRCNT+1		;move controller(L)
KEYC1	EQU	KEYC1L+1	;       "       (H)
KEYC2L	EQU	KEYC1+1		;       "	(L) [ triger ]
KEYC2	EQU	KEYC2L+1	;       "       (H)  
;
;------ scroll counter ----------------------------------
SCCH1	EQU	KEYC2+1		;BG1_H
SCCV1	EQU	SCCH1+2		;   _V
SCCH2	EQU	SCCV1+2		;BG2_H
SCCV2	EQU	SCCH2+2		;   _V
SCCH3	EQU	SCCV2+2		;BG3_H
SCCV3	EQU	SCCH3+2		;   _V
SCCH4	EQU	SCCV3+2		;BG4_H
SCCV4	EQU	SCCH4+2		;   _V
;
;------ player ram --------------------------------------
PLXPS1	EQU	SCCV4+2		;player X pos(L)
PLXPS0	EQU	PLXPS1+1	;     "      (H)
PLYPS1	EQU	PLXPS0+1	;   "   Y pos(L)
PLYPS0	EQU	PLYPS1+1	;     "      (H)
;
PLDSX1	EQU	PLYPS0+1	;   "   display X pos(L)
PLDSX0	EQU	PLDSX1+1	;         "          (H)
PLDSY1	EQU	PLDSX0+1	;       "       Y pos(L)
PLDSY0	EQU	PLDSY1+1	;         "          (H)
;
PLXSPL	EQU	PLDSY0+1	;   "   X speed(L)
PLXSPD	EQU	PLXSPL+1	;       "      (H)
PLYSPL	EQU	PLXSPD+1	;   "   Y   "  (L)
PLYSPD	EQU	PLYSPL+1	;       "      (H)
;
PLXSDR	EQU	PLYSPD+1	;   "   X speed buffer ---+
PLJUMP	EQU	PLXSDR+1	;   "   jump flag         +-- ( +2 )
PLYSDR	EQU	PLJUMP+1	;   "   Y speed buffer ---+
PLSITD	EQU	PLYSDR+1	;   "   sit  flag
PLCMKI	EQU	PLSITD+1	;   "   chara muki
PLBGCR	EQU	PLCMKI+1	;   "   BG cross flag
;
PWRK00	EQU	PLBGCR+1	;   "   work.0
PWRK01	EQU	PWRK00+1	;     "     .1
PWRK02	EQU	PWRK01+1	;     "     .2
PWRK03	EQU	PWRK02+1	;     "     .3
;
;------ BG ram ------------------------------------------
SCMUKI	EQU	PWRK03+1	; scroll muki flag
;
BGXPS1	EQU	SCMUKI+2	;BG check point X pos(L)
BGXPS0	EQU	BGXPS1+1	;         "	     (H)
BGYPS1	EQU	BGXPS0+1	;       "       Y pos(L)
BGYPS0	EQU	BGYPS1+1	;	  "	     (H)
;
KEYDAT		EQU	BGYPS0+1	;
CHRPIT		EQU	KEYDAT+2
DOTPIT		EQU	CHRPIT+2
VRAMSH		EQU	DOTPIT+2
NOKORI		EQU	VRAMSH+2
RETURN		EQU	NOKORI+2
OAMPIT		EQU	RETURN+2
INSFLG		EQU	OAMPIT+2
XPOSDT		EQU	INSFLG+2
YPOSDT		EQU	XPOSDT+2
DELFLG		EQU	YPOSDT+2
DELPIT		EQU	DELFLG+2
SAVENO		EQU	DELPIT+2
INPTNO		EQU	SAVENO+2
INPTDT		EQU	INPTNO+2
;;;;;;		EQU	INPTDT+4
;
;****************************************************************
;*	!=0 page ram						* 
;****************************************************************
;
;------ mode no. ----------------------------------------
MODENO	EQU	100H		;mode no.
;
;------ stack pointer -----------------------------------
STACK	EQU	MODENO+1	;stack area
;
;------ OAM ram -----------------------------------------
OAM	EQU	200H		;OAM main
OAMSUB	EQU	OAM+200H	; "  sub
OAMSB	EQU	OAMSUB+20H	;   "    work
;
POAM 	EQU	OAM+080H	;player OAM main
POAMSB	EQU	OAMSB+080H	;     "     sub work
;
OAM2	EQU	OAM+100H	;OAM main.2
OAMSB2	EQU	OAMSB+100H	; "  sub .2
;
;------ OAM along ram -----------------------------------
;
;------ H-DMA buffer ------------------------------------
HDMABF	EQU	OAMSB+200H	;H-DMA buffer
;
;------ color buffer ------------------------------------
NUKCOL	EQU	HDMABF+1C0H	;nuki color 
CGFLG	EQU	NUKCOL+2	;color write flag
CRAMD	EQU	CGFLG+1		;     "      buffer
;
;------ BG & OBJ flag -----------------------------------
BGMODE	EQU	CRAMD+080H	;BG mode
OAMROT	EQU	BGMODE+1	;OAM rotation flag
SUBADF	EQU	OAMROT+1	;main & sub add select flag
HD420C	EQU	SUBADF+1	;H-DMA "ON/OFF" flag
;
;------ window flag -------------------------------------
WIND23	EQU	HD420C+1	;window "ON/OFF" flag ( BG1,2 )
WIND24	EQU	WIND23+1 	;          "          ( BG3,4 )
WIND25	EQU	WIND24+1	;          "          ( OBJ,COLOR )
WIND30	EQU	WIND25+1	;color window "ON/OFF" flag
;
;------ controller flag ---------------------------------
KEYA1L	EQU	WIND30+1	;controller_1(L)
KEYA1	EQU	KEYA1L+1	;    "       (H)
KEYA2L	EQU	KEYA1+1 	;    "       (L) [ triger ]
KEYA2	EQU	KEYA2L+1	;    "       (H)
KEYB1L	EQU	KEYA2+1		;    "     _2(L)
KEYB1	EQU	KEYB1L+1	;    "       (H)
KEYB2L	EQU	KEYB1+1		;    "       (L) [ triger ]
KEYB2	EQU	KEYB2L+1	;    "       (H)
KEYABFL	EQU	KEYB2+1		;to triger check work_1(L)
KEYABF	EQU	KEYABFL+1	;          "           (H)
KEYBBFL	EQU	KEYABF+1 	;          "         _2(L)
KEYBBF	EQU	KEYBBFL+1	;          "           (H)
KEYWK1	EQU	KEYBBF+1	;keyborad work
KEYWK2	EQU	KEYWK1+9	;       "
KEYWK3	EQU	KEYWK2+9	;       "
;  
;------ fade flag ---------------------------------------
FADNO	EQU	KEYWK3+9		;fade no.
FADMK	EQU	FADNO+1		;  "  muki
;
;------ scroll move dot ---------------------------------
SC1MVX	EQU	FADMK+1		;BG1_H move dot
SC1MVY	EQU	SC1MVX+2	; " _V    "
SC2MVX	EQU	SC1MVY+2	;BG2_H    "
SC2MVY	EQU	SC2MVX+2	; " _V    "
SC3MVX	EQU	SC2MVY+2	;BG3_H    " 
SC3MVY	EQU	SC3MVX+2	; " _V    "
SC4MVX	EQU	SC3MVY+2	;BG4_H    "
SC4MVY	EQU	SC4MVX+2	; " _V    "
;
;------ BG screen status flag ---------------------------
BG1SCF	EQU	SC4MVY+2	;BG1 screen status
BG2SCF	EQU	BG1SCF+1	;BG2       "
BG3SCF	EQU	BG2SCF+1	;BG3       "
BG4SCF	EQU	BG3SCF+1	;BG4       "
;
;------ player ram --------------------------------------
PLWALK	EQU	BG4SCF+1	;player walk flag
PLSLIP	EQU	PLWALK+1	;   "   slip  "
PLBGNO	EQU	PLSLIP+1	;   "   cross BG no.
PLBPOW	EQU	PLBGNO+1	;   "   [B] power scale
PLMIDL	EQU	PLBPOW+1	;   "   middle flag ( 0:stand 7E:middle ) 
PLFLYF	EQU	PLMIDL+1	;   "   flying flag
PLFLST	EQU	PLFLYF+1	;      "       stop flag
PLANGL1	EQU	PLFLST+1	;      "       angle(l)
PLANGL	EQU	PLANGL1+1	;         "         (H)
PLANSP	EQU	PLANGL+1	;         "          speed
PLANMK	EQU	PLANSP+2	;         "          muki
PLROTF	EQU	PLANMK+1	;         "          rotation flag
PLFSPW	EQU	PLROTF+1	;         "          power counter
PLAMKC	EQU	PLFSPW+1	;         "          muki change flag
PLSTMF	EQU	PLAMKC+1	;         "          stop -> move flag
PLCANG	EQU	PLSTMF+1	;         "          chara angle
PLBREK	EQU	PLCANG+1	;         "          breaking flag
PLSMSP	EQU	PLBREK+1	;         "          stop <-> move spacial flag
PLCLMB	EQU	PLSMSP+1	;         "          climbing flag
PLCLUP	EQU	PLCLMB+1	;             "               up move flag
PLHANG	EQU	PLCLUP+1	;         "          hanging flag
PLCAFL	EQU	PLHANG+1	;         "          enemy catch flying flag
PLFLSW	EQU	PLCAFL+1	;      "       switch
PLPATN	EQU	PLFLSW+1	;   "   pattern no.
;
PWRK10	EQU	PLPATN+2	;   "   work.0
PWRK11	EQU	PWRK10+1	;     "     .1
PWRK12	EQU	PWRK11+1	;     "     .2
PWRK13	EQU	PWRK12+1	;     "     .3
PWRK14	EQU	PWRK13+1	;     "     .4
PWRK15	EQU	PWRK14+1	;     "     .5
PWRK16	EQU	PWRK15+1	;     "     .6
PWRK17	EQU	PWRK16+1	;     "     .6
;
PCHNO0	EQU	PWRK17+1	;   "   chara DMA address(L,H,B,H2)
;
;------ enemy ram ---------------------------------------
CACHFG	EQU	PCHNO0+(4*8)	;enemy catch flag
CACHPT	EQU	CACHFG+1	;     "      muki change flag
CAKYFG	EQU	CACHPT+1	;     "      key check flag
SLOWFG	EQU	CAKYFG+1	;     "      slowing flag
;
;------ timer -------------------------------------------
TMST	EQU	SLOWFG+1
PLWKTM	EQU	TMST		;player walk timer
PLSTTM	EQU	PLWKTM+1	;   "   sit    "
PLJPTM	EQU	PLSTTM+1	;   "   jump   "
PLAMKT	EQU	PLJPTM+1	;   "   flying muki change timer
PLSTMT	EQU	PLAMKT+1	;      "       stop -> move timer
PLCLMT	EQU	PLSTMT+1	;   "   climbing timer
PLCLUT	EQU	PLCLMT+1	;       "        up move timer
PLHNGT	EQU	PLCLUT+1	;   "   hanging timer
PLCAFT	EQU	PLHNGT+1	;   "   enemy catch flying timer
;
CACHTM	EQU	PLCAFT+1	;enemy catch muki change timer
JUSTCT	EQU	CACHTM+1	;     "      just timer
SLOWTM	EQU	JUSTCT+1	;     "      slowing timer
SHOTCT	EQU	SLOWTM+1	;     "      shot just timer
;
ENTIM0	EQU	SHOTCT+1
ENTIM1	EQU	ENTIM0+1
TMEN	EQU	ENTIM0+ENNO*2
TMNO	EQU	TMEN-TMST	
;
SCRLMH	EQU	TMEN
SCRLMV	EQU	SCRLMH+2
SCRLHD	EQU	SCRLMV+2
SCRLVD	EQU	SCRLHD+12
SCCDTH	EQU	SCRLVD+12
SCCDH3	EQU	SCCDTH+4
SCCDH4	EQU	SCCDH3+4
SCCDTV	EQU	SCCDH4+4
SCCDV3	EQU	SCCDTV+4
SCCDV4	EQU	SCCDV3+4
BGHADD	EQU	SCCDV4+4
BGHBUF	EQU	BGHADD+2
BGVADD	EQU	BGHBUF+0100H
BGVBUF	EQU	BGVADD+2
BGHAD3	EQU	BGVBUF+0100H
BGHAD4	EQU	BGHAD3+2
BGVAD3	EQU	BGHAD4+2
BGVAD4	EQU	BGVAD3+2
BGHVFG	EQU	BGVAD4+2
BGHVF3	EQU	BGHVFG+2
BGHVF4	EQU	BGHVF3+2
TIMEFG	EQU	BGHVF4+2
KEYMOD	EQU	TIMEFG+2
;
;------ enemy -------------------------------------------
RANDM0	EQU	KEYMOD+2
ENINDX	EQU	RANDM0+1
ENDTP0	EQU	ENINDX+1
ENDTP1	EQU	ENDTP0+2
OAMIN0	EQU	ENDTP1+2
OAMIN1	EQU	OAMIN0+1
;
EXNO	EQU	08
ENNO	EQU	16+EXNO
ENMODE	EQU	OAMIN1+1	;
ENTYPE	EQU	ENMODE+1
ENXPSL	EQU	ENMODE+ENNO*2	;
ENXPSH	EQU	ENXPSL+1
ENYPSL	EQU	ENXPSL+ENNO*2	;
ENYPSH	EQU	ENYPSL+1
ENXSPD	EQU	ENYPSL+ENNO*2	;
ENXSDR	EQU	ENXSPD+1
ENYSPD	EQU	ENXSPD+ENNO*2	;
ENYSDR	EQU	ENYSPD+1
ENDSXL	EQU	ENYSPD+ENNO*2	;
ENDSXH	EQU	ENDSXL+1
ENDSYL	EQU	ENDSXL+ENNO*2	;
ENDSYH	EQU	ENDSYL+1
ECRXPL	EQU	ENDSYL+ENNO*2	;
ECRXPH	EQU	ECRXPL+1
ECRYPL	EQU	ECRXPL+ENNO*2	;
ECRYPH	EQU	ECRYPL+1
ECRXSZ	EQU	ECRYPL+ENNO*2	;
ECRYSZ	EQU	ECRXSZ+ENNO*2	;
ENWRK0	EQU	ECRYSZ+ENNO*2	;
ENWRK1	EQU	ENWRK0+1
ENWRK2	EQU	ENWRK0+ENNO*2	;
ENWRK3	EQU	ENWRK2+1
ENMUKI	EQU	ENWRK2+ENNO*2	;
ENRETN	EQU	ENMUKI+1
;
EWORK0	EQU	ENMUKI+ENNO*2	;
EWORK1	EQU	EWORK0+1
EWORK2	EQU	EWORK1+1
EWORK3	EQU	EWORK2+1
EWORK4	EQU	EWORK3+1
EWORK5	EQU	EWORK4+1
EWORK6	EQU	EWORK5+1
EWORK7	EQU	EWORK6+1
;
ENDTBF	EQU	EWORK7+1	;
;;;;	EQU	ENDTBF+100H
;
;
MSGFG	EQU	ENDTBF+100H
MSGNO	EQU	MSGFG+1
;
;
KEYPIT	EQU	MSGNO+2
;	
;========================================================
;=	polygon RAM					=
;========================================================
;;;;	EQU	1F00H ~ 1FFFH
;
;****************************************************************
;*      !=0 bank ram                                            *
;****************************************************************
;
MSGBUF		EQU	0700000H
;
FILENO		EQU	0701FFEH
;
;========================================================
;=	polygon RAM					=
;========================================================
;;;;	EQU	7E2000H ~ 7E27FFH
;
;--------------------------------------------------------
;-	OAM clear 					-
;--------------------------------------------------------
OAMCLR	EQU	7E2800H
;
;--------------------------------------------------------
;-	OAM sub change 					-
;--------------------------------------------------------
OAMCHG	EQU	OAMCLR+2+(128*3)+1
;
;------ BG write buffer ---------------------------------
VRAMD	EQU	OAMCHG+20H*21+1
;
;
CHRBUF		EQU	07E8000H
DOTBUF		EQU	07EC000H
MOJBUF		EQU	07EE000H
;---------------------------------------------------------------------
HDMAB0	EQU	7F0002H
HDMAB1	EQU	HDMAB0+8
;
;
;
;
	LIST
;
