;
		INCLUDE	zel_ram.asm
;
;-----------------------------------------------------------------------
;
;		PAL_ZELDA-3 (FRANCE)		1992.05.20(WED)
;
;------------------------------------------------------------------------
;
		ORG	07FA90H
;
;=============================================== (zel_char) =============
		GLB	GCGCHNG,DJNCGDT
;
		GLB	NKCGSET,NKCGST0,NKCGST1,RGBRSET
;=============================================== (zel_char) =============
		EXT	GDCGST,GDCGST1,GDCGST2,KOUKAST,MSCGST1,MSCGST2
;
		EXT	CORGENE,CGLPT3,CGLPT4,CGLPT8,PLAYCG,KENOBJ,TATEOBJ
;========================================================================
;
		EXTEND
		MEM8
		IDX8
;
;
;
;
;************************************************************************
;*		Danjyon change color data				*
;************************************************************************
DJNCGDT		EQU	$		; danjyon basic color data
;			 dj  bo  e1  e2
		BYTE	00*2,00,03H,01H		; 0 : normal shiro
		BYTE	01*2,00,03H,01H		; 1 : shiro chika
		BYTE	02*2,00,0AH,01H		; 2 : normal minka
		BYTE	03*2,00,01H,07H		; 3 : shinden (boss)
		BYTE	05*2,02,02H,07H		; 4 : sabaku-shinden (boss)
		BYTE	02*2,04,03H,0AH		; 5 : kusuri-baba mise
		BYTE	06*2,05,08H,14H		; 6 : yama no tou
		BYTE	07*2,00,03H,0AH		; 7 : doukutsu
		BYTE	01*2,00,0FH,14H		; 8 : hokora (boss)
		BYTE	05*2,02,00H,07H		; 9 : sabaku-shinden
		BYTE	01*2,00,0FH,0CH		; A : ura-hokora-mizu
		BYTE	03*2,00,06H,07H		; B : shinden
		BYTE	00*2,00,0EH,12H		; C : shisai-room
		BYTE	09*2,05,05H,0BH		; D : ura-mori danjyon
		BYTE	09*2,00,02H,0CH		; E :                  (boss)
		BYTE	08*2,05,0AH,07H		; F : ura-shinden
		BYTE	08*2,00,10H,0CH		;10 : ura-shinden(boss)
		BYTE	11*2,07,02H,07H		;11 : ura-numa danjyon
		BYTE	11*2,00,07H,0FH		;12 :                  (boss)
		BYTE	04*2,00,04H,0CH		;13 : ura-ice danjyon
		BYTE	04*2,00,04H,09H		;14 :                 (boss)
		BYTE	02*2,00,03H,01H		;15 : link-house
		BYTE	10*2,00,04H,04H		;16 : ura-machi
		BYTE	10*2,00,14H,0CH		;17 :           (boss)
		BYTE	12*2,05,07H,0BH		;18 : ura-kame-iwa
		BYTE	12*2,06,10H,0CH		;19 :              (boss)
		BYTE	13*2,05,08H,14H		;1A : ura-tower
		BYTE	13*2,02,00H,07H		;1B :           (boss)
		BYTE	03*2,00,03H,0AH		;1C : shinden-yoko ojiji
		BYTE	14*2,00,03H,01H		;1D : chapel
		BYTE	15*2,00,0BH,11H		;1E : ura-minka (kaji-ya)
		BYTE	02*2,00,0BH,11H		;1F : bomb-ya
		BYTE	07*2,00,00H,02H		;20 : devil-room
		BYTE	16*2,08,13H,0DH		;21 : ganon
		BYTE	05*2,00,03H,0AH		;22 : piramido megami
		BYTE	10*2,00,04H,04H		;23 : ura-machi (nezumi)
		BYTE	13*2,02,02H,07H		;24 : ura-yama-tower (4F)
		BYTE	13*2,10,00H,00H		;25 :                (5F)
		BYTE	00*2,00,03H,02H		;26 : shiro(2F)
		BYTE	07*2,00,03H,07H		;27 : mane-mane
		BYTE	13*2,05,05H,0BH		;28 : ura-yama-tower (B1)
;
;
;
;
; 
;************************************************************************
;*		Ground CG. change			(GCGCHNG)	*
;*		[in]	(A)	<-- set pointer				*
;************************************************************************
CGCGDT 		EQU	$
		HEX	000,0FF,007,0FF		; 0
;
		HEX	000,001,007,0FF		; 1
		HEX	000,002,007,0FF		; 2
		HEX	000,003,007,0FF		; 3
		HEX	000,004,007,0FF		; 4
		HEX	000,005,007,0FF		; 5
		HEX	000,006,007,0FF		; 6
		HEX	007,006,005,0FF		; 7
		HEX	000,008,007,0FF		; 8
		HEX	000,009,007,0FF		; 9
		HEX	000,00A,007,0FF		: A
;
		HEX	000,00B,007,0FF		: B
		HEX	000,0FF,007,0FF		: C
		HEX	000,0FF,007,0FF		: D
		HEX	003,004,007,0FF		: E
		HEX	004,004,003,0FF		: F
;
;
		HEX	010,0FF,006,0FF		;10
;
		HEX	010,001,006,0FF		;11
		HEX	010,011,006,0FF		;12
		HEX	010,003,006,0FF		;13
		HEX	010,004,006,0FF		;14
		HEX	010,005,006,0FF		;15
		HEX	010,006,006,0FF		;16
		HEX	012,013,004,0FF		;17
		HEX	012,005,004,0FF		;18
		HEX	010,009,006,0FF		;19
		HEX	010,00B,006,0FF		;1A
		HEX	010,00C,006,0FF		;1B
		HEX	010,00D,006,0FF		;1C
		HEX	010,00E,006,0FF		;1D
		HEX	010,00F,006,0FF		;1E
;
;
CGCGD1 		EQU	$
		HEX	0FF,0FF			; 0
;
		HEX	003,00A			; 1
		HEX	003,006			; 2
		HEX	003,001			; 3
		HEX	000,002			; 4
		HEX	003,00E			; 5
		HEX	003,002			; 6
		HEX	013,001			; 7
		HEX	00B,00C			; 8
		HEX	011,001			; 9
		HEX	007,005			; A
		HEX	011,000			; B
		HEX	009,00B			; C
		HEX	00F,005			; D
		HEX	003,005			; E
		HEX	003,007			; F
		HEX	00F,002			;10
		HEX	00A,002			;11
		HEX	005,001			;12
		HEX	00C,00E			;13
;
;
GCGCHNG		EQU	$
		ASL	A
		ASL	A
		TAX
		STZ	!CGSTPT+1
;
		LDA	>CGCGDT+0,X
		BMI	CGCG10		; set ok ?
;					; yes
		STA	!GNDBGC1
CGCG10		EQU	$
		LDA	>CGCGDT+1,X
		BMI	CGCG20		; set ok ?
;					; yes
		STA	!GNDBGC2
CGCG20		EQU	$
		LDA	>CGCGDT+2,X
		BMI	CGCG30		; set ok ?
;					; yes
		STA	!KOKBGC
CGCG30		EQU	$
		LDA	<WORK0
		ASL	A
		TAX
		LDA	>CGCGD1+0,X
		BMI	CGCG40		; set ok ?
;					; yes
		STA	!EYOJC0
CGCG40		EQU	$
		LDA	>CGCGD1+1,X
		BMI	CGCG50		; set ok ?
;					; yes
		STA	!EYOJC1
CGCG50		EQU	$
		JSL	>GDCGST1
		JSL	>GDCGST2
		JSL	>KOUKAST
;
		JSL	>MSCGST1
		JSL	>MSCGST2
		RTL
;
;
;
;
;
;*********************************************************************
;*	 siro & nuki color set sub				     *
;*	 X -----  0:nuki  1:siro				     *
;*********************************************************************
NKCGSET		EQU	$
		MEM16
	 	REP	#00100000B
;
	 	LDA	#00000H
NKCST40		EQU	$
		STA	>CGWORK+000H
		STA	>CGWORK+040H
NKCST80		EQU	$
		STA	>CGRAM+000H
		STA	>CGRAM+040H
;
		MEM8 
		IDX8 
		SEP	#00110000B
RGBRSET		EQU	$
		LDA	#00100000B
		STA	<WD2132R
		LDA	#01000000B
		STA	<WD2132G
		LDA	#10000000B
		STA	<WD2132B
		RTL
;
;
;
;*********************************************************************
;*	 Ground nuki color set sub				     *
;*	 X -----  0:nuki  1:siro				     *
;*********************************************************************
NKCGST0		EQU	$ 
		JSR	NKCGGT		; nuki color get
		BRA	NKCST40
;
;
; 
;*********************************************************************
;*	 Ground nuki color set sub				     *
;*	 X -----  0:nuki  1:siro				     *
;*********************************************************************
NKCGST1		EQU	  $ 
		JSR	NKCGGT		; nuki color get
		BRA	NKCST80
;
;
;
; 
;************************************************************************
;*	 Nuki color get					(NKCGGT)	*
;************************************************************************
NKCGGT		EQU	$
		MEM16
		IDX16
		REP	#00110000B
;
;;; France 04.05.20 ;		LDX	#02669H
		LDX	#036EDH
		LDA	<MPDTNO
		CMP	#00080H
		BCC	NKCGT20		; spot ?
;					; yes
		LDA	<RMXYCT
		CMP	#00183H
		BEQ	NKCGT10		; taki boss ?
;					; no
		CMP	#00182H
		BEQ	NKCGT10		; taki ?
;					; no
		CMP	#00180H
		BNE	NKCGT40		; mori-spot ?
;					; no
NKCGT10		EQU	$
;;; France 04.05.20 ;		LDX	#019C6H
		LDX	#2A4AH
		BRA	NKCGT40
;
NKCGT20		EQU	$
;;; France 04.05.20 ;		LDX	#02669H
		LDX	#036EDH
		LDA	<MPDTNO
		AND	#00040H
		BEQ	NKCGT40		; omote ?
;					; no
;;; France 04.05.20 ;		LDX	#02A32H
		LDX	#03AB6H
NKCGT40		EQU	$
		TXA
		RTS
;
;
;
; 
; 
;========================================================================
;========================================================================
;========================================================================
;=============================================== (zel_char) =============
		GLB	PWTRCGS0,PWTRCGS1,PLCGCN0,PLCGCN1,PLCGCN2
		GLB	PWTRCGS2,PWTRCGS3,THCGCN0,THCGCN1,THCGCN2
;=============================================== (zel_char) =============
		EXT	GDCGST,GDCGST1,GDCGST2,KOUKAST,MSCGST1,MSCGST2
;
		EXT	CORGENE,CGLPT3,CGLPT4,CGLPT8,PLAYCG,KENOBJ,TATEOBJ
;========================================================================
;========================================================================
;========================================================================
;
		MEM8
		IDX8
;
;
;
;
;
;
;************************************************************************
;*		Player water CG. set			(PWTRCGS0)	*
;************************************************************************
PWTRCGS0	EQU	$
		LDA	#00000001B
		STA	<PLBGCKF	; player BG.1 check
PWTRCGS2	EQU	$
		LDA	#00000001B
		STA	!PCGCKF
PWTRS00		EQU	$
		MEM16
		REP	#00100001B	; memory 16bit mode & CLC
;
		LDX	#000H
PWTRS40		EQU	$
		LDA	>CGRAM+100H,X
		PHA			; (A) push
		LDA	>CGRAM+1E0H,X
		STA	>CGRAM+100H,X
		STA	>CGWORK+100H,X
		PLA			; (A) pull
		STA	>CGRAM+1E0H,X
		STA	>CGWORK+1E0H,X
;
		LDA	>CGRAM+110H,X
		PHA			; (A) push
		LDA	>CGRAM+1F0H,X
		STA	>CGRAM+110H,X
		STA	>CGWORK+110H,X
		PLA			; (A) pull
		STA	>CGRAM+1F0H,X
		STA	>CGWORK+1F0H,X
;
		LDA	>CGRAM+1B0H,X
		PHA			; (A) push
		LDA	>CGRAM+170H,X
		STA	>CGRAM+1B0H,X
		STA	>CGWORK+1B0H,X
		PLA			; (A) pull
		STA	>CGRAM+170H,X
		STA	>CGWORK+170H,X
;
		INX
		INX
		CPX	#010H
		BNE	PWTRS40		; end ?
;					; yes
		MEM8
		SEP	#00100000B	; memory 8bit mode
;
		INC	<CGVMAF		; CG. write
		RTL
;
;
;
;************************************************************************
;*		Player water CG. reset			(PWTRCGS1)	*
;************************************************************************
PWTRCGS1	EQU	$
		STZ	<PLBGCKF	; player BG.2 check
PWTRCGS3	EQU	$
		STZ	!PCGCKF
		BRA	PWTRS00
;
;
;
; 
;************************************************************************
;*		Player CG. change			(PLCGCN0)	*
;************************************************************************
PLCGCN0		EQU	$
		MEM16
		REP	#00100000B	; memory 16bit mode
;
		LDA	>ITMTBL6
		STA	<WORKC
;
		LDA	>ITMTBL8
		AND	#000FFH
		BRA	PLCGC000
; 
;************************************************************************
;*		Player CG. change			(PLCGCN1)	*
;************************************************************************
PLCGCN1		EQU	$
		MEM16
		REP	#00100000B	; memory 16bit mode
;
		LDA	#00202H
		STA	<WORKC
		LDA	#00404H
		BRA	PLCGC000
; 
;************************************************************************
;*		Player CG. change			(PLCGCN1)	*
;************************************************************************
PLCGCN2		EQU	$
		MEM16
		REP	#00100000B	; memory 16bit mode
;
		LDA	>ITMTBL6
		STA	<WORKC
		LDA	#00303H
PLCGC000	EQU	$
		STA	<WORKE
;
		LDA	#BANK CORGENE
		STA	<WORK2
;
		LDX	<WORKC
		LDA	>CGLPT3,X
		AND	#000FFH
		CLC
		ADC	#KENOBJ
		IDX16
		REP	#00010000B	; index 16bit mode
		LDX	#001B2H		; set point
		LDY	#00002H		; yoko kosuu
		JSR	PLCG200		; ken CG. set
;
		IDX8
		SEP	#00010000B	; index 8bit mode
		LDX	<WORKD
		LDA	>CGLPT4,X
		AND	#000FFH
		CLC
		ADC	#TATEOBJ
		IDX16
		REP	#00010000B	; index 16bit mode
		LDX	#001B8H		; set point
		LDY	#00003H		; yoko kosuu
		JSR	PLCG200		; tate CG. set
;
		IDX8
		SEP	#00010000B	; index 8bit mode
		LDX	<WORKE
		LDA	>CGLPT8,X
		AND	#000FFH
		ASL	A
		CLC
		ADC	#PLAYCG
		IDX16
		REP	#00010000B	; index 16bit mode
		LDX	#001E2H		; set point
		LDY	#0000EH		; yoko kosuu
		JSR	PLCG200		; player CG. set - 0
;
		MEM8
		IDX8
		SEP	#00110000B	; memory 16bit mode
;
		INC	<CGVMAF		; CG. change
		RTL
;
;
		MEM16
		IDX16
PLCG200		EQU	$
		STA	<WORK0
PLCG220		EQU	$
		LDA	[<WORK0]
		STA	>CGRAM,X
		STA	>CGWORK,X
		INC	<WORK0
		INC	<WORK0
		INX
		INX
		DEY
		BPL	PLCG220		; set end ?
;					; yes
		RTS
;
; 
;
;
		MEM8
		IDX8
;************************************************************************
;*		Thunder CG. change			(THCGCN0)	*
;************************************************************************
THCGCN0		EQU	$
		MEM16
		REP	#00100000B	; index 16bit mode
;
		LDX	#000H
THCG020		EQU	$
		LDA	>CGRAM+040H,X
		JSR	THCG400
		STA	>CGWORK+040H,X
		LDA	>CGRAM+050H,X
		JSR	THCG400
		STA	>CGWORK+050H,X
		LDA	>CGRAM+060H,X
		JSR	THCG400
		STA	>CGWORK+060H,X
		LDA	>CGRAM+070H,X
		JSR	THCG400
		STA	>CGWORK+070H,X
		LDA	>CGRAM+080H,X
		JSR	THCG400
		STA	>CGWORK+080H,X
		LDA	>CGRAM+090H,X
		JSR	THCG400
		STA	>CGWORK+090H,X
		LDA	>CGRAM+0A0H,X
		JSR	THCG400
		STA	>CGWORK+0A0H,X
		LDA	>CGRAM+0B0H,X
		JSR	THCG400
		STA	>CGWORK+0B0H,X
		LDA	>CGRAM+0C0H,X
		JSR	THCG400
		STA	>CGWORK+0C0H,X
		LDA	>CGRAM+0D0H,X
		JSR	THCG400
		STA	>CGWORK+0D0H,X
		LDA	>CGRAM+0E0H,X
		JSR	THCG400
		STA	>CGWORK+0E0H,X
		LDA	>CGRAM+0F0H,X
		JSR	THCG400
		STA	>CGWORK+0F0H,X
;
		INX
		INX
		CPX	#010H
		BEQ	THCG040		; BG. CG. set end ?
;					; no
		JMP	THCG020
;
THCG040		EQU	$
		IDX16
		REP	#00010000B	; index 16bit mode
;
		LDA	>CGWORK+040H
		TAY
		LDA	>CGRAM+000H
		BNE	THCG050		;
;					;
		TAY
THCG050		EQU	$
		TYA
		STA	>CGWORK+000H
;
		MEM8
		IDX8
		SEP	#00110000B	; memory,index 16bit mode
;
		RTL
;
;
		MEM16
THCG400		EQU	$
		STA	<WORK0
		AND	#0000000000011111B
		CLC
		ADC	#0000000000001110B
		CMP	#0000000000011111B
		BCC	THCG420		;
;					;
		LDA	#0000000000011111B
THCG420		EQU	$
		STA	<WORK2
;
		LDA	<WORK0
		AND	#0000001111100000B
		CLC
		ADC	#0000000111000000B
		CMP	#0000001111100000B
		BCC	THCG440		;
;					;
		LDA	#0000001111100000B
THCG440		EQU	$
		STA	<WORK4
;
		LDA	<WORK0
		AND	#0111110000000000B
		CLC
		ADC	#0011100000000000B
		CMP	#0111110000000000B
		BCC	THCG460		;
;					;
		LDA	#0111110000000000B
THCG460		EQU	$
		ORA	<WORK2
		ORA	<WORK4
		RTS
;
;
;// 03.06.10 //		LDX	#00001H
;// 03.06.10 //		LDY	#00016H
;// 03.06.10 //		BRA	THCG000
;
;
		MEM8
		IDX8
;************************************************************************
;*		Thunder CG. change			(THCGCN1)	*
;************************************************************************
THCGCN1		EQU	$
		MEM16
		REP	#00100000B	; index 16bit mode
;
		LDX	#000H
THCG120		EQU	$
		LDA	>CGRAM+040H,X
		STA	>CGWORK+040H,X
		LDA	>CGRAM+050H,X
		STA	>CGWORK+050H,X
		LDA	>CGRAM+060H,X
		STA	>CGWORK+060H,X
		LDA	>CGRAM+070H,X
		STA	>CGWORK+070H,X
		LDA	>CGRAM+080H,X
		STA	>CGWORK+080H,X
		LDA	>CGRAM+090H,X
		STA	>CGWORK+090H,X
		LDA	>CGRAM+0A0H,X
		STA	>CGWORK+0A0H,X
		LDA	>CGRAM+0B0H,X
		STA	>CGWORK+0B0H,X
		LDA	>CGRAM+0C0H,X
		STA	>CGWORK+0C0H,X
		LDA	>CGRAM+0D0H,X
		STA	>CGWORK+0D0H,X
		LDA	>CGRAM+0E0H,X
		STA	>CGWORK+0E0H,X
		LDA	>CGRAM+0F0H,X
		STA	>CGWORK+0F0H,X
;
		INX
		INX
		CPX	#010H
		BNE	THCG120		; BG. CG. set end ?
;					; yes
		LDA	>CGWORK+040H
		STA	>CGWORK+000H
;
;
		MEM8
		IDX8
		SEP	#00110000B	; memory 16bit mode
THCG160		EQU	$
		LDA	<GMMODE
		BNE	THCG180		; ground ?
;					; yes
		IDX16
		REP	#00010000B	; index 16bit mode
;
		LDX	#04020H
		STX	<WD2132R
		LDX	#08040H
		STX	<WD2132G
;
;;; France 04.05.20 ;		LDX	#04F33H
;;; France 04.05.20 ;		LDY	#0894FH
		LDX	#05337H
		LDY	#08D53H
		LDA	<MPDTNO
		BEQ	THCG180		; mori ?
;					; no
		CMP	#040H
		BEQ	THCG180		; ura-mori ?
;					; no
		CMP	#05BH
		BEQ	THCG170		; piramido ?
;					; no
;;; France 04.05.20 ;		LDX	#04C26H
;;; France 04.05.20 ;		LDY	#08C4CH
		LDX	#0502AH
		LDY	#09050H
		CMP	#003H
		BEQ	THCG170		; yama ?
;					; no
		CMP	#005H
		BEQ	THCG170		; yama ?
;					; no
		CMP	#007H
		BEQ	THCG170		; yama ?
;					; no
;;; France 04.05.20 ;		LDX	#04A26H
;;; France 04.05.20 ;		LDY	#0874AH
		LDX	#04E2AH
		LDY	#08B4EH
		CMP	#043H
		BEQ	THCG170		; yama ?
;					; no
		CMP	#045H
		BEQ	THCG170		; yama ?
;					; no
		CMP	#047H
		BNE	THCG180		; yama ?
;					; no
THCG170		EQU	$
		STX	<WD2132R
		STY	<WD2132G
THCG180		EQU	$
		IDX8
		SEP	#00010000B	; index 16bit mode
		RTL
;
;
; 
;************************************************************************
;*		Thunder CG. change			(THCGCN2)	*
;************************************************************************
THCGCN2		EQU	$
		MEM16
		REP	#00100000B	; index 16bit mode
;
		LDX	#07EH
THCG240		EQU	$
		LDA	>CGRAM+000H,X
		STA	>CGWORK+000H,X
		LDA	>CGRAM+080H,X
		STA	>CGWORK+080H,X
		DEX
		DEX
		BPL	THCG240		; reset end ?
;					; yes
		MEM8
		SEP	#00100000B	; memory 16bit mode
;
		INC	<CGVMAF		; CG. change
		JMP	THCG160
;
;
;
;
;
;
; 
; 
		END
		END
