;%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 
;%                                                          % 
;%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 
GREDST          EQU     $ 
;== Initial Buffer clear =======
                IDX16 
                REP     #00010000B
                LDX     #0900H-1
                LDA     #00H
GED000          EQU     $ 
                STA     >ENDTBF,X 
                DEX 
                BPL     GED000
; 
                LDX     #0900H/8-1
GED008          EQU     $ 
                STA     >ENITSW,X 
                DEX 
                BPL     GED008
                IDX8
                SEP     #00010000B
;===============================
                LDA     GRNDNO
                ASL     A 
                TAY 
                LDA     GREDAD,Y
                STA     <WORK0
                LDA     GREDAD+1,Y
                STA     <WORK1
; 
                LDY     #00H
GED010          EQU     $ 
                LDA     (WORK0),Y 
                CMP     #0FFH 
                BEQ     GED080
; 
                PHA 
                LSR     A 
                LSR     A 
                LSR     A 
                LSR     A               ; Ypos (H)
                STA     <WORK2
                ASL     A 
                CLC 
                ADC     <WORK2
                STA     <WORK2
                INY 
                LDA     (WORK0),Y 
                LSR     A 
                LSR     A 
                LSR     A 
                LSR     A               ; Xpos (H)
                CLC 
                ADC     <WORK2
                STA     <WORK6          ; Buffer (H)
                PLA 
                ASL     A 
                ASL     A 
                ASL     A 
                ASL     A 
                STA     <WORK7
                LDA     (WORK0),Y 
                AND     #0FH
                ORA     <WORK7
                STA     <WORK5          ; Buffer (L)
; 
                INY 
                LDA     (WORK0),Y 
                IDX16 
                REP     #00010000B
                LDX     <WORK5
                STA     >ENDTBF,X 
                IDX8
                SEP     #00010000B
; 
                INY 
                BRA     GED010
; 
GED080          EQU     $ 
                RTS 
;%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 
;%              Scroll enemy mode set !                     % 
;%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 
GECKXD          EQU     $ 
                BYTE   0,3,6
                BYTE   0,3,6
                BYTE   0,3,6
GECKYD          EQU     $ 
                BYTE   0,0,0
                BYTE   3,3,3
                BYTE   6,6,6
; 
GECKYD          EQU     $ 
GRENST          EQU     $ 
                JSR     GEXSET
                JSR     GEYSET
                RTS 
;------------------------------------------------------------ 
;                                                           | 
;------------------------------------------------------------ 
GXSETL          EQU     $ 
                BYTE   0D0H,020H
GXSETH          EQU     $ 
                BYTE   0FFH,001H
; 
GEXSET          EQU     $ 
                LDY     #00H
                LDA     SCRMVX
                BEQ     GX0090
                BPL     GX0010
                INY 
GX0010          EQU     $ 
                LDA     <SCCH2
                CLC 
                ADC     GXSETL,Y
                STA     <WORKE
                LDA     <SCCH2+1
                ADC     GXSETH,Y
                STA     <WORKF
; 
                LDA     <SCCV2
                SEC 
                SBC     #30H
                STA     <WORKC
                LDA     <SCCV2+1
                SBC     #00H
                STA     <WORKD
; 
                LDX     #015H 
GX0020          EQU     $ 
                JSR     GXYSUB
; 
                MEM16 
                REP     #00100000B
                LDA     <WORKC
                CLC 
                ADC     #0010H
                STA     <WORKC
                MEM8
                SEP     #00100000B
; 
                DEX 
                BPL     GX0020
; 
GX0090          EQU     $ 
                RTS 
;------------------------------------------------------------ 
;                                                           | 
;------------------------------------------------------------ 
GYSETL          EQU     $ 
                BYTE   0D0H,020H
GYSETH          EQU     $ 
                BYTE   0FFH,001H
; 
GEYSET          EQU     $ 
                LDY     #00H
                LDA     SCRMVY
                BEQ     GY0090
                BPL     GY0010
                INY 
GY0010          EQU     $ 
                LDA     <SCCV2
                CLC 
                ADC     GYSETL,Y
                STA     <WORKC
                LDA     <SCCV2+1
                ADC     GYSETH,Y
                STA     <WORKD
; 
                LDA     <SCCH2
                SEC 
                SBC     #20H
                STA     <WORKE
                LDA     <SCCH2+1
                SBC     #00H
                STA     <WORKF
; 
                LDX     #015H 
GY0020          EQU     $ 
                JSR     GXYSUB
; 
                MEM16 
                REP     #00100000B
                LDA     <WORKE
                CLC 
                ADC     #0010H
                STA     <WORKE
                MEM8
                SEP     #00100000B
; 
                DEX 
                BPL     GY0020
; 
GY0090          EQU     $ 
                RTS 
;------------------------------------------------------------ 
;                                                           | 
;------------------------------------------------------------ 
GXYSUB          EQU     $ 
                LDY     GRNDNO
                LDA     <WORKF
                SEC 
                SBC     GECKXD,Y
                CMP     #02H
                BCS     GY0090
                STA     <WORK0
; 
                LDA     <WORKD
                SEC 
                SBC     GECKYD,Y
                CMP     #02H
                BCS     GY0090
                STA     <WORK1
; 
                ASL     A 
                ADC     <WORK1
                ADC     <WORK0
                STA     <WORK0
; 
                LDA     <WORKC
                AND     #0F0H 
                STA     <WORK1
                LDA     <WORKE
                LSR     A 
                LSR     A 
                LSR     A 
                LSR     A 
                ORA     <WORK1
                STA     <WORK1
; 
                PHX 
                JSR     GRES00
                PLX 
                RTS 
;------------------------------------------------------------ 
;                                                           | 
;------------------------------------------------------------ 
GONOFB          EQU     $ 
                BYTE   10000000B
                BYTE   01000000B
                BYTE   00100000B
                BYTE   00010000B
                BYTE   00001000B
                BYTE   00000100B
                BYTE   00000010B
                BYTE   00000001B
; 
GRES00          EQU     $ 
                MEM16 
                REP     #00100000B
; 
                LDA     <WORK0          ; Adress L,H
                LSR     A 
                LSR     A 
                LSR     A 
                CLC 
                ADC     #ENITSW 
                STA     <WORK2
                MEM8
                SEP     #00100000B
; 
                LDA     <WORK0
                AND     #07H
                TAY 
                LDA     (WORK2) 
                AND     GONOFB,Y
                BNE     GES090          ; Already set ? 
;                                       ; No. 
                LDA     (WORK2) 
                ORA     GONOFB,Y        ; Set bit on !
                STA     (WORK2) 
; 
                JSR     ENMYST          ; Enemy set ! 
; 
GES090          EQU     $ 
                RTS 
;------------------------------------------------------------ 
;                                                           | 
;------------------------------------------------------------ 
ENXHDT          EQU     $ 
                BYTE   0,1,2,0,1,2,0,1,2
ENYHDT          EQU     $ 
                BYTE   0,0,0,1,1,1,2,2,2
; 
ENMYST          EQU     $ 
                LDX     #ENNO-1 
ENS000          EQU     $ 
                LDA     ENMODE,X
                BEQ     ENS010
                DEX 
                BPL     ENS000
                RTS 
; 
ENS010          EQU     $ 
                PHX 
                TXA 
                ASL     A 
                TAX 
                MEM16 
                REP     #00100000B
                LDA     <WORK2
                STA     ENSWAD,X        ; On off data adress set !
                MEM8
                SEP     #00100000B
                PLX 
; 
                LDA     #EINIT
                STA     ENMODE,X
; 
                MEM16 
                REP     #00100000B
                LDA     <WORK0
                CLC 
                ADC     #ENDTBF 
                STA     <WORK2
                MEM8
                SEP     #00100000B
; 
                LDA     <WORK0
                ASL     A 
                ASL     A 
                ASL     A 
                ASL     A 
                STA     ENXPSL,X
                LDA     <WORK0
                AND     #0F0H 
                STA     ENYPSL,X
                LDY     <WORK0+1
                LDA     ENXHDT,Y
                STA     ENXPSH,X
                LDA     ENYHDT,Y
                STA     ENYPSH,X
; 
                LDY     #02H
                LDA     (WORK2),Y 
                STA     ENMYNO,X
; 
                JSL     >ENMDST 
                RTS
