;************************************************************************
;*									*
;*	title name	: "ZELDA-3 NES messege porgram"			*
;*	proccess	: system main					*
;*	file name	: m5main					*
;*									*
;************************************************************************
;
;
		INCLUDE	ztmacro.asm
		INCLUDE	tl_ram.asm
;
;
;------------------------------------------------------------------------
;-	global symbol							-
;------------------------------------------------------------------------
;-----< tl1_msg0 >-------------------------------------------------------
		GLB	MSGINIT,LOADSUB
;
;------------------------------------------------------------------------
;-	extern symbol							-
;------------------------------------------------------------------------
;-----< tl1_data >-------------------------------------------------------
		EXT	MSGDATA
;
;************************************************************************
;*									*
;*	program start							*
;*									*
;************************************************************************
;
;
		ORG	018000H
;
;
		EXTEND
;
;
		MEM8
		IDX8
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSL	MSGINIT	( messege data init. sub )		x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
MSGINIT		EQU	$
		MI16
;
		LDX	#007FEH
;
MIN050		EQU	$
		LDA	#00000H
		STA	>DOTBUF,X
		STA	>CHRBUF,X
		LDA	#08080H
		STA	>MOJBUF,X
		DEX
		DEX
		BPL	MIN050
;
		MI8
;
		LDA	#168
		STA	<NOKORI
		INC	<VRAMSH
		RTL
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		dot  data						x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
DOTDATA		EQU	$
		HEX	006,006,006,006,006,006,006,006,003,006,006,006,007,006,006,006
		HEX	006,006,006,007,006,007,007,007,007,006,006,006,006,006,006,006
		HEX	006,006,003,005,006,003,007,006,006,006,006,005,006,006,006,007
		HEX	007,007,007,006,006,004,006,006,006,006,006,006,006,006,003,007
		HEX	006,004,004,006,006,006,006,006,006,006,008,008,008,007,007,007
		HEX	007,004,008,008,008,008,008,008,008,004
;
DOTSPAC		EQU	$
		HEX	001,002,003,004,005,006,007,008
;
BITDATA		EQU	$
		BYTE	10000000B,01000000B,00100000B,00010000B
		BYTE	00001000B,00000100B,00000010B,00000001B
;
CHRPDAT		EQU	$
		WORD	00000H,002A0H,00540H
;
DOTPDAT		EQU	$
		WORD	00000H,00040H,00080H
;
ANDDATA		EQU	$
		BYTE	00000000B,10000000B,11000000B,11100000B
		BYTE	11110000B,11111000B,11111100B,11111110B
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	DATADEL	( moji data delete sub )		x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
DATADEL		EQU	$
		LDA	#008H
		STA	<WORK2
;
		MI16
;
		LDA	#08000H
		STA	<WORK0
;
		LDA	<YPOSDT
		ASL	A
		TAY
		LDX	!CHRPDAT,Y
		STX	<DELPIT
		LDY	#002A0H
		LDA	#00000H
;
DAL100		EQU	$
		STA	>CHRBUF,X
		INX
		INX
		DEY
		DEY
		BNE	DAL100
;
		LDA	<YPOSDT
		ASL	A
		TAY
		LDX	!DOTPDAT,Y
		LDA	>DOTBUF+1,X
		BNE	DAL150
;
		BRL	DALEND
;
DAL150		EQU	$
		STX	<WORK6
		LDA	>MOJBUF+1,X
		TAY
		AND	#000F0H
		ASL	A
		STA	<WORK4
		TYA
		AND	#0000FH
		ORA	<WORK4
		ASL	A
		ASL	A
		ASL	A
		ASL	A
		STA	<WORK4
		TAY
;
		LDA	>DOTBUF,X
		AND	#000FFH
		ASL	A
		STA	<WORKE
;
		STZ	<WORK8
;
DAL200		EQU	$
		LDA	[<WORK0],Y
		STA	<WORKC
;
		PHY
;
		LDA	<WORKE
		CLC
		ADC	<DELPIT
		TAY
		AND	#00FF0H
		CLC
		ADC	<WORK8
		TAX
		TYA
		LSR	A
		AND	#00007H
		TAY
		BEQ	DAL400
;
		M8
;
DAL250		EQU	$
		ASL	<WORKC
		BCC	DAL300
;
		LDA	>CHRBUF,X
		ORA	!BITDATA,Y
		STA	>CHRBUF,X
;
DAL300		EQU	$
		ASL	<WORKD
		BCC	DAL350
;
		LDA	>CHRBUF+1,X
		ORA	!BITDATA,Y
		STA	>CHRBUF+1,X
;
DAL350		EQU	$
		INY
		CPY	#00008H
		BNE	DAL250
;
		M16
;
		TXA
		CLC
		ADC	#00010H
		TAX
;
DAL400		EQU	$
		LDA	<WORKC
		BEQ	DAL450
;
		STA	>CHRBUF,X
;
DAL450		EQU	$
		PLY
		INY
		INY
		LDA	<WORK8
		INC	A
		INC	A
		STA	<WORK8
		CMP	#00010H
		BNE	DAL200
;
		LDA	<WORK4
		CLC
		ADC	#00100H
		TAY
;
		STZ	<WORK8
;
DAL500		EQU	$
		LDA	[<WORK0],Y
		STA	<WORKC
;
		PHY
;
		LDA	<WORKE
		CLC
		ADC	<DELPIT
		TAY
		AND	#00FF0H
		CLC
		ADC	<WORK8
		TAX
		TYA
		LSR	A
		AND	#00007H
		TAY
		BEQ	DAL700
;
		M8
;
DAL550		EQU	$
		ASL	<WORKC
		BCC	DAL600
;
		LDA	>CHRBUF+150H,X
		ORA	!BITDATA,Y
		STA	>CHRBUF+150H,X
;
DAL600		EQU	$
		ASL	<WORKD
		BCC	DAL650
;
		LDA	>CHRBUF+151H,X
		ORA	!BITDATA,Y
		STA	>CHRBUF+151H,X
;
DAL650		EQU	$
		INY
		CPY	#00008H
		BNE	DAL550
;
		M16
;
		TXA
		CLC
		ADC	#00010H
		TAX
;
DAL700		EQU	$
		LDA	<WORKC
		BEQ	DAL750
;
		STA	>CHRBUF+150H,X
;
DAL750		EQU	$
		PLY
		INY
		INY
		LDA	<WORK8
		INC	A
		INC	A
		STA	<WORK8
		CMP	#00010H
		BNE	DAL500
;
		INC	<WORK6
		LDX	<WORK6
		LDA	>DOTBUF+1,X
		BEQ	DALEND
;
		BRL	DAL150
;
DALEND		EQU	$
		MI8
;
		INC	<VRAMSH
		RTS
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	LOADSUB	( messege data load sub )		x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
LOADSUB		EQU	$
		PHB
		PHK
		PLB
;
		LDY	#000H
;
LDB050		EQU	$
		LDA	!MSGDATA,Y
		STA	<WORK0
		CMP	#07FH
		BEQ	LDB070
;
		SEC
		SBC	#074H
		CMP	#003H
		BCS	LDB060
;
		ASL	A
		ASL	A
		ASL	A
		ASL	A
		ASL	A
		ASL	A
		TAX
		INY
		BRA	LDB050
;
LDB060		EQU	$
		LDA	<WORK0
		STA	>MOJBUF+1,X
		INY
		INX
		BRA	LDB050
;
LDB070		EQU	$
		LDX	#000H
;
LDB100		EQU	$
		LDA	>MOJBUF,X
		TAY
		CMP	#080H
		BEQ	LDB250
;
;;;;		CMP	#0F8H
;;;;		BCC	LDB150
;;;;;
;;;;		TYA
;;;;		SEC
;;;;		SBC	#0F8H
;;;;		TAY
;;;;		LDA	!DOTSPAC,Y
;;;;		BRA	LDB200
;;;;;
LDB150		EQU	$
		LDA	!DOTDATA,Y
;
LDB200		EQU	$
		CLC
		ADC	>DOTBUF-1,X
		STA	>DOTBUF,X
;
LDB250		EQU	$
		INX
		CPX	#0C0H
		BNE	LDB100
;
		LDY	#000
;
LDB300		EQU	$
		STY	<YPOSDT
		JSR	DATADEL
		LDY	<YPOSDT
		INY
		CPY	#003H
		BNE	LDB300	
;
		LDX	#081H
		LDY	#002H
		LDA	>DOTBUF,X
		BNE	LDB350
;
		DEY
		LDX	#041H
		LDA	>DOTBUF,X
		BNE	LDB350
;
		DEY
		LDX	#001H
;
LDB350		EQU	$
		LDA	>DOTBUF,X
		BEQ	LDB400
;
		INX
		BRA	LDB350
;
LDB400		EQU	$
		STY	<RETURN
		DEX
		STX	<DOTPIT
		TYA
		ASL	A
		TAY
;
		M16
;
		LDA	!CHRPDAT,Y
		STA	<CHRPIT
;
		M8
;
		PLB
		RTL
;
;
;
		END
;
;
;
