;************************************************************************
;*									*
;*	title name	: "ZELDA-3 NES messege porgram"			*
;*	proccess	: system main					*
;*	file name	: m5main					*
;*									*
;************************************************************************
;
;
		INCLUDE	ztmacro.asm
		INCLUDE	tl_ram.asm
;
;
;------------------------------------------------------------------------
;-	global symbol							-
;------------------------------------------------------------------------
;-----< tl_main >--------------------------------------------------------
;
;------------------------------------------------------------------------
;-	extern symbol							-
;------------------------------------------------------------------------
;
;-----< tl_msg0 >--------------------------------------------------------
		GLB	KEYINPT,MSGINIT,NOINPUT,LOADSUB
;
;
;------------------------------------------------------------------------
;-	define symbol							-
;------------------------------------------------------------------------
;		EQU
;
;
;************************************************************************
;*									*
;*	program start							*
;*									*
;************************************************************************
;
;
		ORG	018000H
;
;
		EXTEND
;
;
		MEM8
		IDX8
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSL	MSGINIT	( messege data init. sub )		x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
MSGINIT		EQU	$
		MI16
;
		LDX	#007FEH
;
MIN050		EQU	$
		LDA	#00000H
		STA	>DOTBUF,X
		STA	>CHRBUF,X
		LDA	#08080H
		STA	>MOJBUF,X
		DEX
		DEX
		BPL	MIN050
;
		MI8
;
		LDA	#168
		STA	<NOKORI
		INC	<VRAMSH
		RTL
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	KEYINPT	( key input data cheange sub )		x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
KEYINPT		EQU	$
		LDY	#080H
		STZ	<DELFLG
		LDA	!KEYWK2
		BEQ	KIT040
;
		ASL	A
		BCC	KIT007
;
		LDA	<RETURN
		STA	<YPOSDT
		LDA	<DOTPIT
		STA	<XPOSDT
;
		LDA	<INSFLG
		EOR	#00000001B
		STA	<INSFLG
		BRL	KITEND
;
KIT007		EQU	$
		ASL	A
		BCC	KIT009
;
		LDA	<INSFLG
		BEQ	KIT008
;
		INC	<DELFLG
		BRL	KITEND
;
KIT008		EQU	$
		JSR	BACKSPC
		JSR	NOKOCNT
		LDY	#080H
		BRL	KITEND
;
KIT009		EQU	$
		ASL	A
		BCS	KIT040
;
		ASL	A
		BCC	KIT010
;
		LDY	#04EH
		BRL	KITEND
;
KIT010		EQU	$
		ASL	A
		BCC	KIT020
;
		LDY	#04FH
		BRL	KITEND
;
KIT020		EQU	$
		ASL	A
		BCC	KIT030
;
		LDY	#050H
		BRL	KIT050
;
KIT030		EQU	$
		ASL	A
		BCC	KIT031
;
		LDY	#04DH
		BRL	KIT050
;
KIT031		EQU	$
		STZ	!MODENO
		BRL	KITEND
;
KIT040		EQU	$
		LDA	!KEYWK2+1
		BEQ	KIT080
;
		ASL	A
		BCC	KIT050
;
		LDY	#036H
		BRL	KITEND
;
KIT050		EQU	$
		ASL	A
		BCC	KIT060
;
		LDY	#035H
		LDA	!KEYWK1+1
		AND	#00010000B
		BNE	KIT055
;
		LDA	!KEYWK1+8
		AND	#00100000B
		BEQ	KIT056
;
KIT055		EQU	$
		LDY	#03EH
;
KIT056		EQU	$
		BRL	KITEND
;
KIT060		EQU	$
		ASL	A
		ASL	A
		ASL	A
		ASL	A
		BCC	KIT070
;
		LDY	#010H
		BRL	KITEND
;
KIT070		EQU	$
		ASL	A
		ASL	A
		BCC	KIT080
;
		LDY	#0F8H
		BRL	KITEND
;
KIT080		EQU	$
		LDA	!KEYWK2+2
		BEQ	KIT160
;
		ASL	A
		BCC	KIT090
;
		LDY	#037H
		BRL	KITEND
;
KIT090		EQU	$
		ASL	A
		BCC	KIT100
;
		LDY	#004H
		BRL	KITEND
;
KIT100		EQU	$
		ASL	A
		BCC	KIT110
;
		LDY	#019H
		BRL	KITEND
;
KIT110		EQU	$
		ASL	A
		BCC	KIT120
;
		LDY	#017H
		BRL	KITEND
;
KIT120		EQU	$
		ASL	A
		BCC	KIT130
;
		LDY	#000H
		BRL	KITEND
;
KIT130		EQU	$
		ASL	A
		BCC	KIT140
;
		LDY	#012H
		BRL	KITEND
;
KIT140		EQU	$
		ASL	A
		BCC	KIT150
;
		LDY	#016H
		BRL	KITEND
;
KIT150		EQU	$
		LDY	#0F9H
		BRL	KITEND
;
KIT160		EQU	$
		LDA	!KEYWK2+3
		BEQ	KIT240
;
		ASL	A
		BCC	KIT170
;
		LDY	#038H
		BRL	KITEND
;
KIT170		EQU	$
		ASL	A
		BCC	KIT180
;
		LDY	#039H
		BRL	KITEND
;
KIT180		EQU	$
		ASL	A
		BCC	KIT190
;
		LDY	#002H
		BRL	KITEND
;
KIT190		EQU	$
		ASL	A
		BCC	KIT200
;
		LDY	#005H
		BRL	KITEND
;
KIT200		EQU	$
		ASL	A
		BCC	KIT210
;
		LDY	#0003H
		BRL	KITEND
;
KIT210		EQU	$
		ASL	A
		BCC	KIT220
;
		LDY	#011H
		BRL	KITEND
;
KIT220		EQU	$
		ASL	A
		BCC	KIT230
;
		LDY	#013H
		BRL	KITEND
;
KIT230		EQU	$
		LDY	#0FAH
		BRL	KITEND
;
KIT240		EQU	$
		LDA	!KEYWK2+4
		BEQ	KIT320
;
		ASL	A
		BCC	KIT250
;
		LDY	#03AH
		BRL	KITEND
;
KIT250		EQU	$
		ASL	A
		BCC	KIT260
;
		LDY	#03BH
		BRL	KITEND
;
KIT260		EQU	$
		ASL	A
		BCC	KIT270
;
		LDY	#015H
		BRL	KITEND
;
KIT270		EQU	$
		ASL	A
		BCC	KIT280
;
		LDY	#001H
		BRL	KITEND
;
KIT280		EQU	$
		ASL	A
		BCC	KIT290
;
		LDY	#007H
		BRL	KITEND
;
KIT290		EQU	$
		ASL	A
		BCC	KIT300
;
		LDY	#006H
		BRL	KITEND
;
KIT300		EQU	$
		ASL	A
		BCC	KIT310
;
		LDY	#018H
		BRL	KITEND
;
KIT310		EQU	$
		LDY	#0FBH
		BRL	KITEND
;
KIT320		EQU	$
		LDA	!KEYWK2+5
		BEQ	KIT400
;
		ASL	A
		BCC	KIT330
;
		LDY	#003CH
		BRL	KITEND
;
KIT330		EQU	$
		ASL	A
		BCC	KIT340
;
		LDY	#03DH
		BRL	KITEND
;
KIT340		EQU	$
		ASL	A
		BCC	KIT350
;
		LDY	#00DH
		BRL	KITEND
;
KIT350		EQU	$
		ASL	A
		BCC	KIT360
;
		LDY	#00CH
		BRL	KITEND
;
KIT360		EQU	$
		ASL	A
		BCC	KIT370
;
		LDY	#009H
		BRL	KITEND
;
KIT370		EQU	$
		ASL	A
		BCC	KIT380
;
		LDY	#014H
		BRL	KITEND
;
KIT380		EQU	$
		ASL	A
		BCC	KIT390
;
		LDY	#008H
		BRL	KITEND
;
KIT390		EQU	$
		LDY	#0FCH
		BRL	KITEND
;
KIT400		EQU	$
		LDA	!KEYWK2+6
		BEQ	KIT480
;
		ASL	A
		BCC	KIT410
;
		LDY	#034H
		BRL	KITEND
;
KIT410		EQU	$
		ASL	A
		BCC	KIT420
;
		LDY	#00FH
		BRL	KITEND
;
KIT420		EQU	$
		ASL	A
		BCC	KIT430
;
		LDY	#042H
		BRL	KITEND
;
KIT430		EQU	$
		ASL	A
		BCC	KIT440
;
		LDY	#041H
		BRL	KITEND
;
KIT440		EQU	$
		ASL	A
		BCC	KIT450
;
		LDY	#00AH
		BRL	KITEND
;
KIT450		EQU	$
		ASL	A
		BCC	KIT460
;
		LDY	#00BH
		BRL	KITEND
;
KIT460		EQU	$
		ASL	A
		BCC	KIT470
;
		LDY	#00EH
		BRL	KITEND
;
KIT470		EQU	$
		LDY	#0FDH
		BRL	KITEND
;
KIT480		EQU	$
		LDA	!KEYWK2+7
		BEQ	KIT502
;
		ASL	A
		BCC	KIT490
;
		LDY	#043H
		BRL	KITEND
;
KIT490		EQU	$
		ASL	A
		BCC	KIT500
;
		LDY	#040H
		BRL	KITEND
;
KIT500		EQU	$
		ASL	A
		BCC	KIT501
;
		LDY	#03FH
		BRL	KITEND
;
KIT501		EQU	$
		ASL	A
		ASL	A
		ASL	A
		ASL	A
		ASL	A
		BCC	KIT502
;
		LDY	#0FEH
		BRA	KITEND
;
KIT502		EQU	$
		LDA	!KEYWK2+8
		BEQ	KITEND
;
		ASL	A
		BCC	KIT503
;
		JSR	SAVESUB
		STZ	!MODENO
		BRA	KITEND
;
KIT503		EQU	$
		LSR	A
		LSR	A
		BCC	KIT506
;
		LDY	#0FFH
		BRA	KITEND
;
KIT506		EQU	$
		LSR	A
		BCC	KITEND
;
		LDA	<RETURN
		INC	A
		CMP	#003H
		BEQ	KITEND
;
KIT508		EQU	$
		STA	<RETURN
		ASL	A
		TAX
;
		LDA	#0168
		STA	<NOKORI
		STZ	<OAMPIT
;
		M16
;
		LDA	>CHRPDAT,X
		STA	<CHRPIT
		LDA	>DOTPDAT,X
		STA	<DOTPIT
		JSR	NOKOCNT
;
		M8
;
KITEND		EQU	$
		STY	<KEYDAT
		CPY	#01AH
		BCS	KIT510
;
		LDA	!KEYWK1+1
		AND	#00010000B
		BNE	KIT510
;
		LDA	!KEYWK1+8
		AND	#00100000B
		BNE	KIT510
;
KIT509		EQU	$
		TYA
		CLC
		ADC	#01AH
		STA	<KEYDAT
		TAY
;
KIT510		EQU	$
		CPY	#0F8H
		BCC	KIT530
;
		LDA	!KEYWK1+1
		AND	#00010000B
		BNE	KIT520
;
		LDA	!KEYWK1+8
		AND	#00100000B
		BEQ	KIT530
;
KIT520		EQU	$
		TYA
		AND	#007H
		CLC
		ADC	#045H
		STA	<KEYDAT
		TAY
;
KIT530		EQU	$
		LDA	<INSFLG
		BEQ	KIT540
;
		JMP	SOUNYUU
;
KIT540		EQU	$
		JSR	MOJISET
		JMP	CASLOAM
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		dot  data						x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
DOTDATA		EQU	$
		HEX	006,006,006,006,006,006,006,006,003,006,006,006,007,006,006,006
		HEX	006,006,006,007,006,007,007,007,007,006,006,006,006,006,006,006
		HEX	006,006,003,005,006,003,007,006,006,006,006,005,006,006,006,007
		HEX	007,007,007,006,006,004,006,006,006,006,006,006,006,006,003,007
		HEX	006,004,004,006,006,006,006,006,006,006,008,008,008,007,007,007
		HEX	007,004,008,008,008,008,008,008,008,004
;
DOTSPAC		EQU	$
		HEX	001,002,003,004,005,006,007,008
;
BITDATA		EQU	$
		BYTE	10000000B,01000000B,00100000B,00010000B
		BYTE	00001000B,00000100B,00000010B,00000001B
;
CHRPDAT		EQU	$
		WORD	00000H,002A0H,00540H
;
DOTPDAT		EQU	$
		WORD	00000H,00040H,00080H
;
ANDDATA		EQU	$
		BYTE	00000000B,10000000B,11000000B,11100000B
		BYTE	11110000B,11111000B,11111100B,11111110B
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	MOJISET	( moji dot data buffer set )		x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
MOJISET		EQU	$
		PHB
		PHK
		PLB
;
		STZ	<WORK3
		LDX	<DOTPIT
		LDY	<KEYDAT
		CPY	#080H
		BNE	MIT010
;
MIT000		EQU	$
		BRL	MITEND
;
MIT010		EQU	$
		LDA	<NOKORI
		BEQ	MIT000
;
		CPY	#0F8H
		BCS	MIT050
;
		LDA	!DOTDATA,Y
		BRA	MIT100
;
MIT050		EQU	$
		LDA	!DOTSPAC-0F8H,Y
;
MIT100		EQU	$
		STA	<WORK2
		CLC
		ADC	>DOTBUF,X
		CMP	#0169
		BCS	MIT000
;
		STA	>DOTBUF+1,X
		LDA	#168
		SEC
		SBC	>DOTBUF+1,X
		STA	<NOKORI
		INX
		STX	<DOTPIT
		INC	<OAMPIT
;
		LDA	<KEYDAT
		STA	>MOJBUF,X
		TAY
		AND	#0F0H
		ASL	A
		STA	<WORK0
		TYA
		AND	#00FH
		ORA	<WORK0
		STA	<KEYDAT
;
		M16
;
		LDA	#08000H
		STA	<WORKD
		LDY	#008H
		STY	<WORKF
;
		I16
;
		LDX	<DOTPIT
		LDA	>DOTBUF-1,X
		AND	#000FFH
		ASL	A
		STA	<WORK0
;
		LDX	#00000H
		LDA	<KEYDAT
		ASL	A
		ASL	A
		ASL	A
		ASL	A
		TAY
;
MIT150		EQU	$
		LDA	[<WORKD],Y
		STA	<WORK4
;
		PHY
		STX	<WORK6
;
		LDA	<WORK0
		CLC
		ADC	<CHRPIT
		TAY
		AND	#00FF0H
		CLC
		ADC	<WORK6
		TAX
		TYA
		LSR	A
		AND	#00007H
		TAY
		BEQ	MIT350
;
		M8
;
MIT200		EQU	$
		ASL	<WORK4
		BCC	MIT250
;
		LDA	>CHRBUF,X
		EOR	!BITDATA,Y
		STA	>CHRBUF,X
;
MIT250		EQU	$
		ASL	<WORK5
		BCC	MIT300
;
		LDA	>CHRBUF+1,X
		EOR	!BITDATA,Y
		STA	>CHRBUF+1,X
;
MIT300		EQU	$
		INY
		CPY	#00008H
		BNE	MIT200
;
		M16
;
		TXA
		CLC
		ADC	#00010H
		TAX
;
MIT350		EQU	$
		LDA	<WORK4
		BEQ	MIT360
;
		STA	>CHRBUF,X
;
MIT360		EQU	$
		PLY
		INY
		INY
		LDX	<WORK6
		INX
		INX
		CPX	#00010H
		BNE	MIT150
;
		LDA	<CHRPIT
		CLC
		ADC	#00150H
		STA	<WORK8
;
		LDX	#00000H
		LDA	<KEYDAT
		CLC
		ADC	#00010H
		ASL	A
		ASL	A
		ASL	A
		ASL	A
		TAY
;
MIT400		EQU	$
		LDA	[<WORKD],Y
		STA	<WORK4
;
		PHY
		STX	<WORK6
;
		LDX	<DOTPIT
		LDA	>DOTBUF-1,X
		AND	#000FFH
		ASL	A
		CLC
		ADC	<WORK8
		TAY
		AND	#00FF0H
		CLC
		ADC	<WORK6
		TAX
		TYA
		LSR	A
		AND	#00007H
		TAY
		BEQ	MIT600
;
		M8
;
MIT450		EQU	$
		ASL	<WORK4
		BCC	MIT500
;
		LDA	>CHRBUF,X
		EOR	!BITDATA,Y
		STA	>CHRBUF,X
;
MIT500		EQU	$
		ASL	<WORK5
		BCC	MIT550
;
		LDA	>CHRBUF+1,X
		EOR	!BITDATA,Y
		STA	>CHRBUF+1,X
;
MIT550		EQU	$
		INY
		CPY	#00008H
		BNE	MIT450
;
		M16
;
		TXA
		CLC
		ADC	#00010H
		TAX
;
MIT600		EQU	$
		LDA	<WORK4
		BEQ	MIT610
;
		STA	>CHRBUF,X
;
MIT610		EQU	$
		PLY
		INY
		INY
		LDX	<WORK6
		INX
		INX
		CPX	#00010H
		BNE	MIT400
;
		INC	<VRAMSH
		JSR	NOKOCNT
;
MITEND		EQU	$
		MI8
;
		PLB
		RTS
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	NOKOCNT	(  nokori count disp sub )		x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
NOKOCNT		EQU	$
		MI16
;
		STZ	<WORK0
		STZ	<WORK2
		STZ	<WORK4
;
		LDA	<NOKORI
		CMP	#100
		BMI	NRT050
;
		SEC
		SBC	#100
		INC	<WORK0
;
NRT050		EQU	$
		CMP	#10
		BMI	NRT100
;
		SEC
		SBC	#10
		INC	<WORK2
		BRA	NRT050
;
NRT100		EQU	$
		STA	<WORK4
;
		LDA	#05851H
		STA	>VRAMD+2
		CLC
		ADC	#02000H
		STA	>VRAMD+12
		LDA	#00500H
		STA	>VRAMD+4
		STA	>VRAMD+14
;
		LDA	<WORK0
		CLC
		ADC	#01D64H
		STA	>VRAMD+6
		CLC
		ADC	#00010H
		STA	>VRAMD+16
;
		LDA	<WORK2
		CLC
		ADC	#01D64H
		STA	>VRAMD+8
		CLC
		ADC	#00010H
		STA	>VRAMD+18
;
		LDA	<WORK4
		CLC
		ADC	#01D64H
		STA	>VRAMD+10
		CLC
		ADC	#00010H
		STA	>VRAMD+20
;
		LDA	#000FFH
		STA	>VRAMD+22
;
		MI8
;
		RTS
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	BACKSPC	( back space data set sub )		x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
BACKSPC		EQU	$
		PHB
		PHK
		PLB
;
		LDX	<DOTPIT
		TXA
		AND	#00111111B
		BNE	BKC150
;
		DEX
		DEC	<RETURN
		LDA	<RETURN
		BPL	BKC050
;
		STZ	<RETURN
		BRL	BKCEND
;
BKC050		EQU	$
		LDA	<RETURN
		ASL	A
		TAY
;
		M16
;
		LDA	!CHRPDAT,Y		
		STA	<CHRPIT
;
		M8
;
BKC100		EQU	$
		LDA	>DOTBUF,X
		BNE	BKC150
;
		DEX
		CPX	#001H
		BNE	BKC100
;
BKC150		EQU	$
		DEX
		STX	<DOTPIT
;
		LDA	#000H
		STA	>DOTBUF+1,X
		LDA	#080H
		STA	>MOJBUF+1,X
;
		LDA	#168
		SEC
		SBC	>DOTBUF,X
		STA	<NOKORI
;
		DEC	<OAMPIT
;
		MI16
;
		LDA	>DOTBUF,X
		AND	#000FFH
		TAY
		ASL	A
		AND	#00FF0H
		CLC
		ADC	<CHRPIT
		TAX
		TYA
		AND	#00007H
		TAY
;
		M8
;
BKC200		EQU	$
		LDA	>CHRBUF,X
		AND	!ANDDATA,Y
		STA	>CHRBUF,X
;
		LDA	>CHRBUF+150H,X
		AND	!ANDDATA,Y
		STA	>CHRBUF+150H,X
;
		INX
		TXA
		AND	#00FH
		BNE	BKC200
;
		CPY	#00000H
		BEQ	BKCEND
;
		CPX	#00150H
		BEQ	BKCEND
;
		CPX	#003F0H
		BEQ	BKCEND
;
		CPX	#00690H
		BEQ	BKCEND
;
		LDY	#00000H
;
BKC250		EQU	$
		LDA	>CHRBUF,X
		AND	!ANDDATA,Y
		STA	>CHRBUF,X
;
		LDA	>CHRBUF+150H,X
		AND	!ANDDATA,Y
		STA	>CHRBUF+150H,X
;
		INX
		TXA
		AND	#00FH
		BNE	BKC250
;
BKCEND		EQU	$
		MI8
;
		INC	<VRAMSH
		PLB
		RTS
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	CASLOAM	( corsol OAM data set sub )		x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
OAMYPOS		EQU	$
		HEX	087,097,0A7
;
CASLOAM		EQU	$
		LDX	<RETURN
		LDA	>OAMYPOS,X
		STA	!OAM+1
		CLC
		ADC	#008H
		STA	!OAM+5
;
		LDX	<DOTPIT
		LDA	>DOTBUF,X
		CLC
		ADC	#028H
		STA	!OAM
		STA	!OAM+4
;
		STZ	!OAM+3
		STZ	!OAM+7
;
		LDA	#0FEH
		STA	!OAM+2
		STA	!OAM+6
;
		RTL
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	SOUNYUU	(  moji sounyuu data set sub )		x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
YPOSDAT		EQU	$
		HEX	0FF,001,000,000
;
XPOSDAT		EQU	$
		HEX	000,000,0FF,001
;
YPOSDT1		EQU	$
		HEX	000,002,000,000
;
XPOSDT1		EQU	$
		HEX	000,000,000,002
;
SOUNYUU		EQU	$
		PHB
		PHK
		PLB
;
		LDA	<KEYDAT
		SEC
		SBC	#04DH
		TAY
		CMP	#04H
		BCC	SNU010
;
		BRL	SNU150
;
SNU010		EQU	$
		LDA	<YPOSDT
		CLC
		ADC	!YPOSDAT,Y
		TAX
		CMP	#0FFH
		BNE	SNU020
;
		LDX	#000H
		BRA	SNU050
;
SNU020		EQU	$
		CMP	<RETURN
		BEQ	SNU050
;
		BMI	SNU050
;
		LDX	<RETURN
;
SNU050		EQU	$
		STX	<YPOSDT
		TXA
		ASL	A
		TAX
		LDA	<XPOSDT
		AND	#03FH
		CLC
		ADC	!DOTPDAT,X
		STA	<XPOSDT
		CLC
		ADC	!XPOSDAT,Y
		TAX
		CMP	#0FFH
		BNE	SNU060
;
		LDX	#000H
		BRA	SNU100
;
SNU060		EQU	$
		AND	#00111111B
		CMP	#00111111B
		BNE	SNU070
;
		LDA	<YPOSDT
		BEQ	SNU070
;
		DEC	<YPOSDT
;
SNU070		EQU	$
		LDA	>DOTBUF,X
		BNE	SNU100
;
		TXA
		AND	#00111111B
		BEQ	SNU100
;
		DEX
		BRA	SNU070
;
SNU100		EQU	$
		STX	<XPOSDT
		LDY	<YPOSDT
		LDA	!OAMYPOS,Y
		STA	!OAM+1
		CLC
		ADC	#008H
		STA	!OAM+5
;
		LDA	>DOTBUF,X
		CLC
		ADC	#028H
		STA	!OAM
		STA	!OAM+4
;
		STZ	!OAM+3
		STZ	!OAM+7
;
		LDA	#0FEH
		STA	!OAM+2
		STA	!OAM+6
;
		BRL	SNUEND
;
SNU150		EQU	$
		LDA	<KEYDAT
		CMP	#080H
		BEQ	SNU200
;
		JSR	DATAINS
		BRA	SNUEND
;
SNU200		EQU	$
		LDA	<DELFLG
		BEQ	SNUEND
;
		JSR	DATADEL
;
;
SNUEND		EQU	$
		PLB
		RTL
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	DATADEL	( moji data delete sub )		x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
DATADEL		EQU	$
		LDX	<XPOSDT
		LDA	>MOJBUF+1,X
		TAY
		LDA	!DOTDATA,Y
;;;;		CPY	#0F8H
;;;;		BCC	DAL010
;;;;;
;;;;		LDA	!DOTSPAC-0F8H,Y
;;;;;
;;;;DAL010		EQU	$
		STA	<WORK0
;
DAL050		EQU	$
		LDA	>MOJBUF+2,X
		STA	>MOJBUF+1,X
		LDA	>DOTBUF+2,X
		TAY
		SEC
		SBC	<WORK0
		STA	>DOTBUF+1,X
		INX
		CPY	#000H
		BNE	DAL050
;
		TYA
		STA	>DOTBUF,X
		LDA	#0168
		SEC
		SBC	>DOTBUF-1,X
		STA	<NOKORI
;
		LDA	<YPOSDT
		CMP	<RETURN
		BNE	DAL070
;
		DEC	<DOTPIT
;
DAL070		EQU	$
		LDA	#008H
		STA	<WORK2
;
		MI16
;
		LDA	#08000H
		STA	<WORK0
;
		LDA	<YPOSDT
		ASL	A
		TAY
		LDX	!CHRPDAT,Y
		STX	<DELPIT
		LDY	#002A0H
		LDA	#00000H
;
DAL100		EQU	$
		STA	>CHRBUF,X
		INX
		INX
		DEY
		DEY
		BNE	DAL100
;
		LDA	<YPOSDT
		ASL	A
		TAY
		LDX	!DOTPDAT,Y
		LDA	>DOTBUF+1,X
		BNE	DAL150
;
		BRL	DALEND
;
DAL150		EQU	$
		STX	<WORK6
		LDA	>MOJBUF+1,X
		TAY
		AND	#000F0H
		ASL	A
		STA	<WORK4
		TYA
		AND	#0000FH
		ORA	<WORK4
		ASL	A
		ASL	A
		ASL	A
		ASL	A
		STA	<WORK4
		TAY
;
		LDA	>DOTBUF,X
		AND	#000FFH
		ASL	A
		STA	<WORKE
;
		STZ	<WORK8
;
DAL200		EQU	$
		LDA	[<WORK0],Y
		STA	<WORKC
;
		PHY
;
		LDA	<WORKE
		CLC
		ADC	<DELPIT
		TAY
		AND	#00FF0H
		CLC
		ADC	<WORK8
		TAX
		TYA
		LSR	A
		AND	#00007H
		TAY
		BEQ	DAL400
;
		M8
;
DAL250		EQU	$
		ASL	<WORKC
		BCC	DAL300
;
		LDA	>CHRBUF,X
		ORA	!BITDATA,Y
		STA	>CHRBUF,X
;
DAL300		EQU	$
		ASL	<WORKD
		BCC	DAL350
;
		LDA	>CHRBUF+1,X
		ORA	!BITDATA,Y
		STA	>CHRBUF+1,X
;
DAL350		EQU	$
		INY
		CPY	#00008H
		BNE	DAL250
;
		M16
;
		TXA
		CLC
		ADC	#00010H
		TAX
;
DAL400		EQU	$
		LDA	<WORKC
		BEQ	DAL450
;
		STA	>CHRBUF,X
;
DAL450		EQU	$
		PLY
		INY
		INY
		LDA	<WORK8
		INC	A
		INC	A
		STA	<WORK8
		CMP	#00010H
		BNE	DAL200
;
		LDA	<WORK4
		CLC
		ADC	#00100H
		TAY
;
		STZ	<WORK8
;
DAL500		EQU	$
		LDA	[<WORK0],Y
		STA	<WORKC
;
		PHY
;
		LDA	<WORKE
		CLC
		ADC	<DELPIT
		TAY
		AND	#00FF0H
		CLC
		ADC	<WORK8
		TAX
		TYA
		LSR	A
		AND	#00007H
		TAY
		BEQ	DAL700
;
		M8
;
DAL550		EQU	$
		ASL	<WORKC
		BCC	DAL600
;
		LDA	>CHRBUF+150H,X
		ORA	!BITDATA,Y
		STA	>CHRBUF+150H,X
;
DAL600		EQU	$
		ASL	<WORKD
		BCC	DAL650
;
		LDA	>CHRBUF+151H,X
		ORA	!BITDATA,Y
		STA	>CHRBUF+151H,X
;
DAL650		EQU	$
		INY
		CPY	#00008H
		BNE	DAL550
;
		M16
;
		TXA
		CLC
		ADC	#00010H
		TAX
;
DAL700		EQU	$
		LDA	<WORKC
		BEQ	DAL750
;
		STA	>CHRBUF+150H,X
;
DAL750		EQU	$
		PLY
		INY
		INY
		LDA	<WORK8
		INC	A
		INC	A
		STA	<WORK8
		CMP	#00010H
		BNE	DAL500
;
		INC	<WORK6
		LDX	<WORK6
		LDA	>DOTBUF+1,X
		BEQ	DALEND
;
		BRL	DAL150
;
DALEND		EQU	$
		MI8
;
		INC	<VRAMSH
		JMP	NOKOCNT
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;		JSR	DATAINS	( moji data ins. sub )			x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
DATAINS		EQU	$
		LDX	<KEYDAT
		LDA	!DOTDATA,X
;;;;		CPX	#0F8H
;;;;		BCC	DAS050
;;;;;
;;;;		LDA	!DOTSPAC-0F8H,X
;;;;;
;;;;DAS050		EQU	$
		STA	<WORK0
		LDX	<DOTPIT
		LDA	>DOTBUF,X
		CLC
		ADC	<WORK0
		CMP	#0169
		BCS	DASEND
;
DAS100		EQU	$
		LDA	>MOJBUF,X
		STA	>MOJBUF+1,X
		LDA	>DOTBUF,X
		CLC
		ADC	<WORK0
		STA	>DOTBUF+1,X
		DEX
		CPX	<XPOSDT
		BNE	DAS100
;
		LDA	<KEYDAT
		STA	>MOJBUF+1,X
		LDA	>DOTBUF,X
		CLC
		ADC	<WORK0
		STA	>DOTBUF+1,X
		INC	<XPOSDT
		LDA	<YPOSDT
		CMP	<RETURN
		BNE	DAS150
;
		INC	<DOTPIT
;
DAS150		EQU	$
		LDX	<DOTPIT
		LDA	#168
		SEC
		SBC	>DOTBUF,X
		STA	<NOKORI
;
		LDY	<YPOSDT
		LDA	!OAMYPOS,Y
		STA	!OAM+1
		CLC
		ADC	#008H
		STA	!OAM+5
;
		LDX	<XPOSDT
		LDA	>DOTBUF,X
		CLC
		ADC	#028H
		STA	!OAM
		STA	!OAM+4
;
		STZ	!OAM+3
		STZ	!OAM+7
;
		LDA	#0FEH
		STA	!OAM+2
		STA	!OAM+6
;
		JMP	DAL070
;
DASEND		EQU	$
		RTS
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	SAVESUB	( messege data save sub )		x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
SAVESUB		EQU	$
		PHB
		LDA	#BANK MSGBUF
		PHA
		PLB
;
		MI16
;
		LDA	<SAVENO
		BEQ	SEB010
;
		DEC	A
		BRA	SEB020
;
SEB010		EQU	$
		LDA	!FILENO
;
SEB020		EQU	$
		ASL	A
		ASL	A
		ASL	A
		ASL	A
		ASL	A
		ASL	A
		STA	<WORK0
		ASL	A
		CLC
		ADC	<WORK0
		TAY
;
		LDX	#00000H
;
SEB050		EQU	$
		LDA	>MOJBUF,X
		STA	!MSGBUF,Y
		INY
		INY
		INX
		INX
		CPX	#000C0H
		BNE	SEB050
;
		LDA	<SAVENO
		BNE	SEB100
;
		LDA	>FILENO
		INC	A
		STA	>FILENO
;
SEB100		EQU	$
		MI8
;
		PLB
		RTS
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	LOADSUB	( messege data load sub )		x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
LOADSUB		EQU	$
		PHB
		LDA	#BANK MSGBUF
		PHA
		PLB
;
		MI16
;
		LDA	<SAVENO
		DEC	A
		ASL	A
		ASL	A
		ASL	A
		ASL	A
		ASL	A
		ASL	A
		STA	<WORK0
		ASL	A
		CLC
		ADC	<WORK0
		TAY
		LDX	#00000H
;
LDB050		EQU	$
		LDA	!MSGBUF,Y
		STA	>MOJBUF,X
		INY
		INY
		INX
		INX
		CPX	#000C0H
		BNE	LDB050
;
		MI8
;
		PLB
;
		PHB
		PHK
		PLB
;
		LDX	#000H
;
LDB100		EQU	$
		LDA	>MOJBUF,X
		TAY
		CMP	#080H
		BEQ	LDB250
;
;;;;		CMP	#0F8H
;;;;		BCC	LDB150
;;;;;
;;;;		TYA
;;;;		SEC
;;;;		SBC	#0F8H
;;;;		TAY
;;;;		LDA	!DOTSPAC,Y
;;;;		BRA	LDB200
;;;;;
;;;;LDB150		EQU	$
		LDA	!DOTDATA,Y
;
LDB200		EQU	$
		CLC
		ADC	>DOTBUF-1,X
		STA	>DOTBUF,X
;
LDB250		EQU	$
		INX
		CPX	#0C0H
		BNE	LDB100
;
		LDY	#000
;
LDB300		EQU	$
		STY	<YPOSDT
		JSR	DAL070
		LDY	<YPOSDT
		INY
		CPY	#003H
		BNE	LDB300	
;
		LDX	<WORK6
		LDA	#168
		SEC
		SBC	>DOTBUF,X
		STA	<NOKORI
;
		JSR	NOKOCNT
;
		LDX	#081H
		LDY	#002H
		LDA	>DOTBUF,X
		BNE	LDB350
;
		DEY
		LDX	#041H
		LDA	>DOTBUF,X
		BNE	LDB350
;
		DEY
		LDX	#001H
;
LDB350		EQU	$
		LDA	>DOTBUF,X
		BEQ	LDB400
;
		INX
		BRA	LDB350
;
LDB400		EQU	$
		STY	<RETURN
		DEX
		STX	<DOTPIT
		TYA
		ASL	A
		TAY
;
		M16
;
		LDA	!CHRPDAT,Y
		STA	<CHRPIT
;
		M8
;
		PLB
		RTL
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	NOINPUT	( file no input sub )			x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
NOINPUT		EQU	$
		LDY	#080H
		LDA	!KEYWK2+1
		AND	#11000000B
		BEQ	NNT100
;
		LDY	#001H
		ASL	A
		BCC	NNT050
;
		LDY	#002H
;
NNT050		EQU	$
		BRA	NNTEND
;
NNT100		EQU	$
		LDA	!KEYWK2+2
		ASL	A
		BCC	NNT150
;
		LDY	#003H
		BRA	NNTEND
;
NNT150		EQU	$
		LDA	!KEYWK2+3
		AND	#11000000B
		BEQ	NNT200
;
		LDY	#005H
		ASL	A
		BCC	NNT050
;
		LDY	#004H
		BRA	NNTEND
;
NNT200		EQU	$
		LDA	!KEYWK2+4
		AND	#11000000B
		BEQ	NNT250
;
		LDY	#007H
		ASL	A
		BCC	NNT050
;
		LDY	#006H
		BRA	NNTEND
;
NNT250		EQU	$
		LDA	!KEYWK2+5
		AND	#11000000B
		BEQ	NNT300
;
		LDY	#009H
		ASL	A
		BCC	NNT050
;
		LDY	#008H
		BRA	NNTEND
;
NNT300		EQU	$
		LDA	!KEYWK2+6
		ASL	A
		BCC	NNT350
;
		LDY	#000H
		BRA	NNTEND
;
NNT350		EQU	$
		LDA	!KEYWK2+8
		AND	#00000010
		BEQ	NNTEND
;
		LDA	<INPTDT
		ASL	A
		STA	<WORK0
		ASL	A
		ASL	A
		CLC
		ADC	<WORK0
		CLC
		ADC	<INPTDT+2
		STA	<SAVENO
		BEQ	NNT360
;
		CMP	>FILENO
		BEQ	NNT370
		BMI	NNT370
;
		BRA	NNT400
;
NNT360		EQU	$
		INC	!MODENO
;
NNT370		EQU	$
		INC	!MODENO
;
NNTEND		EQU	$
		LDX	<INPTNO
		CPY	#080H
		BEQ	NNT400
;
		STY	<INPTDT,X
		TXA
		EOR	#00000010B
		STA	<INPTNO
;
NNT400		EQU	$
		JSR	INPUTDT
		RTL
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	INPUTDT	( input data V-ram set sub )		x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
INPUTDT		EQU	$
		M16
;
		LDA	#04D51H
		STA	>VRAMD+2
		CLC
		ADC	#02000H
		STA	>VRAMD+10
;
		LDA	#00300H
		STA	>VRAMD+4
		STA	>VRAMD+12
;
		LDA	<INPTDT
		CLC
		ADC	#03D64H
		STA	>VRAMD+6
		CLC
		ADC	#00010H
		STA	>VRAMD+14
;
		LDA	<INPTDT+2
		CLC
		ADC	#03D64H
		STA	>VRAMD+8
		CLC
		ADC	#00010H
		STA	>VRAMD+16
;
		LDA	#0FFFFH
		STA	>VRAMD+18
;
		M8
;
		LDA	#04EH
		STA	!OAM+1
		CLC
		ADC	#08H
		STA	!OAM+5
;
		LDA	<INPTNO
		ASL	A
		ASL	A
		CLC
		ADC	#068H
		STA	!OAM
		STA	!OAM+4
;
		STZ	!OAM+3
		STZ	!OAM+7
;
		LDA	#0FEH
		STA	!OAM+2
		STA	!OAM+6
;
		RTS
;




















































;
;
		END
