;
		INCLUDE	zel_ram.asm
;
;-----------------------------------------------------------------------
;
;		ZELDA-3			1991.06.05(WED)
;
;------------------------------------------------------------------------
;
		ORG	1EC700H
;
;=============================================== (zel_char) =============
		GLB	CHSCHNG,CHSCHN0,CHRCHNG,CHRCBS0,CHRCBS1,BGCHCNG,OJCHCNG,GCGCHNG
		GLB	CCBFIT,KNCBFST,TTCBFST,WTRCBFST,OPTCBFST,ITMCBFST,ITMCBFST1,SPOJCNG
		GLB	MPICBST,WGBGCNG,M7CHST,MSGVRMS,MSGVRMS1,MPDTBFST,TPLCGST
;
		GLB	PWTRCGS0,PWTRCGS1,PLCGCN0,PLCGCN1,PLCGCN2
		GLB	PWTRCGS2,PWTRCGS3,THCGCN0,THCGCN1,THCGCN2
;
		GLB	NKCGSET,NKCGST0,NKCGST1
;
		GLB	OBJYSET,MSCGST1,MSCGST2,KENST,TATEST
		GLB	CHOBJST,CHITEMST,PLCGSET,CHITEMS1,PGRVCGST
;
		GLB	MAPCGSET,B3CGSET,DANCORST,KOUKAST
		GLB	GDCGST,GDCGST1,GDCGST2,MAPOBSET,DJCGSET
;
		GLB	spoj0,spoj1,spoj2,spoj3,spoj4,spoj5,spoj6,spoj7
;
		GLB	PICCPT,BGCBDT0,DJNCGDT
;
		GLB	C_0A0,C_4C0
		GLB	C_1F0,C_1X0,C_1Y0,C_2R1,C_2U0,C_2W0
;=============================================== (zel_vma) ==============
		EXT	PCHDT0,PCHDT1,PCHDT2
;
		EXT	bgwB,bgwC,bgwD,bgwE,bgwF,bgw10,bgw11,bgw12,bgw13,bgw14
;=============================================== (zel_init) =============
		EXT	KGBG000,KGBG100,KGBG200
;=============================================== (zel_play) =============
		EXT	RABHEN
;========================================================================
;
		EXTEND
;
		MEM8
		IDX8
;
;
;
;=====================================================================
DCP000		EQU	108000H
DCB000		EQU	118000H
DCB001		EQU	118600H
DCB002		EQU	118C00H
DCB003		EQU	119200H
DCB004		EQU	119800H
DCB005		EQU	119E00H
DCB006		EQU	11A400H
DCB007		EQU	11AA00H
DCB008		EQU	11B000H
DCB009		EQU	11B600H
DCB00A		EQU	11BC00H
DCB00B		EQU	11C200H
DCB00C		EQU	11C800H
DCB00D		EQU	11CCDBH
DCB00E		EQU	11D180H
DCB00F		EQU	11D68FH
DCB010		EQU	11DBE6H
DCB011		EQU	11E021H
DCB012		EQU	11E44FH
DCB013		EQU	11E844H
DCB014		EQU	11EBF4H
DCB015		EQU	11EFDAH
DCB016		EQU	11F43AH
DCB017		EQU	11F755H
DCB018		EQU	11FAEBH
DCB019		EQU	11FEF2H
DCB01A		EQU	11FF88H
DCB01B		EQU	128449H
DCB01C		EQU	12867FH
DCB01D		EQU	128B17H
DCB01E		EQU	129091H
DCB01F		EQU	1295B9H
DCB020		EQU	129A51H
DCB021		EQU	129EC5H
DCB022		EQU	12A432H
DCB023		EQU	12A839H
DCB024		EQU	12AC40H
DCB025		EQU	12B047H
DCB026		EQU	12B44EH
DCB027		EQU	12B8E2H
DCB028		EQU	12BC97H
DCB029		EQU	12C09EH
DCB02A		EQU	12C4B3H
DCB02B		EQU	12C99BH
DCB02C		EQU	12CBEEH
DCB02D		EQU	12CFF5H
DCB02E		EQU	12D0F6H
DCB02F		EQU	12D4FDH
DCB030		EQU	12D904H
DCB031		EQU	12DE42H
DCB032		EQU	12DF85H
DCB033		EQU	12E38CH
DCB034		EQU	12E70EH
DCB035		EQU	12EAE5H
DCB036		EQU	12EEECH
DCB037		EQU	12F2F3H
DCB038		EQU	12F3CCH
DCB039		EQU	12F7D3H
DCB03A		EQU	12FBDAH
DCB03B		EQU	12FFE1H
DCB03C		EQU	1383E8H
DCB03D		EQU	138825H
DCB03E		EQU	138C78H
DCB03F		EQU	1391F6H
DCB040		EQU	1396FBH
DCB041		EQU	139C45H
DCB042		EQU	13A16DH
DCB043		EQU	13A698H
DCB044		EQU	13A9D4H
DCB045		EQU	13AEE4H
DCB046		EQU	13B396H
DCB047		EQU	13B859H
DCB048		EQU	13BD49H
DCB049		EQU	13C196H
DCB04A		EQU	13C674H
DCB04B		EQU	13CB52H
DCB04C		EQU	13CF73H
DCB04D		EQU	13D3D9H
DCB04E		EQU	13D87DH
DCB04F		EQU	13DCF4H
DCB050		EQU	13E1AAH
DCB051		EQU	13E696H
DCB052		EQU	13EBFBH
DCB053		EQU	13F002H
DCB054		EQU	13F433H
DCB055		EQU	13F921H
DCB056		EQU	13FE50H
DCB057		EQU	14834BH
DCB058		EQU	1488BCH
DCB059		EQU	148CC3H
DCB05A		EQU	1490E5H
DCB05B		EQU	149599H
DCB05C		EQU	1499B2H
DCB05D		EQU	149F2BH
DCB05E		EQU	14A3CAH
DCB05F		EQU	14A8B9H
DCB060		EQU	14AD9CH
DCB061		EQU	14B27AH
DCB062		EQU	14B73FH
DCB063		EQU	14BC04H
DCB064		EQU	14BF82H
DCB065		EQU	14C440H
DCB066		EQU	14C867H
DCB067		EQU	14CCDEH
DCB068		EQU	14D1C6H
DCB069		EQU	14D6CFH
DCB06A		EQU	14DB20H
DCB06B		EQU	14DFBDH
DCB06C		EQU	14E49DH
DCB06D		EQU	14E8A4H
DCB06E		EQU	14ECABH
DCB06F		EQU	14F115H
DCB070		EQU	14F54DH
DCB071		EQU	14F847H
DCB072		EQU	14FC04H
DCB073		EQU	1580C7H
DCB074		EQU	1585B7H
DCB075		EQU	158A04H
DCB076		EQU	158EE2H
DCB077		EQU	1593A5H
DCB078		EQU	159895H
DCB079		EQU	159AD5H
DCB07A		EQU	159C47H
DCB07B		EQU	15A04EH
DCB07C		EQU	15A455H
DCB07D		EQU	15A45CH
DCB07E		EQU	15A463H
DCB07F		EQU	15A46AH
DCB080		EQU	15A471H
DCB081		EQU	15A478H
DCB082		EQU	15A47FH
DCB083		EQU	15A486H
DCB084		EQU	15A48DH
DCB085		EQU	15A494H
DCB086		EQU	15A49BH
DCB087		EQU	15A4A2H
DCB088		EQU	15A4A9H
DCB089		EQU	15A4B0H
DCB08A		EQU	15A4B7H
DCB08B		EQU	15A4BEH
DCB08C		EQU	15A4C5H
DCB08D		EQU	15AA9DH
DCB08E		EQU	15AF9CH
DCB08F		EQU	15B49AH
DCB090		EQU	15BA03H
DCB091		EQU	15BDE6H
DCB092		EQU	15C2F6H
DCB093		EQU	15C78BH
DCB094		EQU	15CCBEH
DCB095		EQU	15D241H
DCB096		EQU	15D5EAH
DCB097		EQU	15D9F1H
DCB098		EQU	15DDFBH
DCB099		EQU	15E237H
DCB09A		EQU	15E61EH
DCB09B		EQU	15E7B5H
DCB09C		EQU	15EAC4H
DCB09D		EQU	15F01CH
DCB09E		EQU	15F31DH
DCB09F		EQU	15F8A4H
DCB0A0		EQU	15FE23H
DCB0A1		EQU	168391H
DCB0A2		EQU	16881AH
DCB0A3		EQU	168D49H
DCB0A4		EQU	1692B8H
DCB0A5		EQU	1697EDH
DCB0A6		EQU	169D3EH
DCB0A7		EQU	16A11FH
DCB0A8		EQU	16A359H
DCB0A9		EQU	16A76BH
DCB0AA		EQU	16AC6EH
DCB0AB		EQU	16B216H
DCB0AC		EQU	16B6AFH
DCB0AD		EQU	16BC69H
DCB0AE		EQU	16C13CH
DCB0AF		EQU	16C5ECH
DCB0B0		EQU	16CB66H
DCB0B1		EQU	16CF6DH
DCB0B2		EQU	16D4CAH
DCB0B3		EQU	16D9BAH
DCB0B4		EQU	16DD72H
DCB0B5		EQU	16E179H
DCB0B6		EQU	16E580H
DCB0B7		EQU	16EAAEH
DCB0B8		EQU	16EEB5H
DCB0B9		EQU	16EEBCH
DCB0BA		EQU	16EEC3H
DCB0BB		EQU	16EECAH
DCB0BC		EQU	16EED1H
DCB0BD		EQU	16F1FDH
DCB0BE		EQU	16F572H
DCB0BF		EQU	16FA93H
DCB0C0		EQU	16FE9AH
DCB0C1		EQU	178131H
DCB0C2		EQU	1785A5H
DCB0C3		EQU	1789EEH
DCB0C4		EQU	178EB4H
DCB0C5		EQU	1792BBH
DCB0C6		EQU	1796C2H
DCB0C7		EQU	179B97H
DCB0C8		EQU	17A00AH
DCB0C9		EQU	17A558H
DCB0CA		EQU	17A55FH
DCB0CB		EQU	17AABAH
DCB0CC		EQU	17AFE8H
DCB0CD		EQU	17B462H
DCB0CE		EQU	17B979H
DCB0CF		EQU	17BECDH
DCB0D0		EQU	17C2B3H
DCB0D1		EQU	17C7D0H
DCB0D2		EQU	17CD58H
DCB0D3		EQU	17D045H
DCB0D4		EQU	17D5E8H
DCB0D5		EQU	17DB4FH
DCB0D6		EQU	17DF2BH
DCB0D7		EQU	17E3FEH
DCB0D8		EQU	17E6EBH
DCB0D9		EQU	17E9A1H
DCB0DA		EQU	17ECA5H
DCB0DB		EQU	17F0ACH
DCB0DC		EQU	17F4B3H
DCB0DD		EQU	17F8BAH
DCB0DE		EQU	17FD67H
DCB0DF		EQU	188308H
DCB0E0		EQU	188870H
DCB0E1		EQU	188DACH
DCB0E2		EQU	189159H
DCB0E3		EQU	189475H
DCB0E4		EQU	189881H
DCB0E5		EQU	189C6BH
DCB0E6		EQU	18A072H
DCB0E7		EQU	18A353H
DCB0E8		EQU	18A63FH
DCB0E9		EQU	18AAB5H
DCB0EA		EQU	18AABCH
DCB0EB		EQU	18AFB6H
DCB0EC		EQU	18B11EH
DCB0ED		EQU	18B525H
DCB0EE		EQU	18B92CH
DCB0EF		EQU	18BDD9H
DCB0F0		EQU	18C40EH
DCB0F1		EQU	18CA8BH
;
PICCPT          EQU     DCB0EC
;=====================================================================
;
;
;
BCADB		EQU	$
		BYTE	BANK DCB00C,BANK DCB00D,BANK DCB00E,BANK DCB00F
		BYTE	BANK DCB010,BANK DCB011,BANK DCB012,BANK DCB013
		BYTE	BANK DCB014,BANK DCB015,BANK DCB016,BANK DCB017
		BYTE	BANK DCB018,BANK DCB019,BANK DCB01A,BANK DCB01B
		BYTE	BANK DCB01C,BANK DCB01D,BANK DCB01E,BANK DCB01F
		BYTE	BANK DCB020,BANK DCB021,BANK DCB022,BANK DCB023
		BYTE	BANK DCB024,BANK DCB025,BANK DCB026,BANK DCB027
		BYTE	BANK DCB028,BANK DCB029,BANK DCB02A,BANK DCB02B
		BYTE	BANK DCB02C,BANK DCB02D,BANK DCB02E,BANK DCB02F
		BYTE	BANK DCB030,BANK DCB031,BANK DCB032,BANK DCB033
		BYTE	BANK DCB034,BANK DCB035,BANK DCB036,BANK DCB037
		BYTE	BANK DCB038,BANK DCB039,BANK DCB03A,BANK DCB03B
		BYTE	BANK DCB03C,BANK DCB03D,BANK DCB03E,BANK DCB03F
		BYTE	BANK DCB040,BANK DCB041,BANK DCB042,BANK DCB043
		BYTE	BANK DCB044,BANK DCB045,BANK DCB046,BANK DCB047
		BYTE	BANK DCB048,BANK DCB049,BANK DCB04A,BANK DCB04B
		BYTE	BANK DCB04C,BANK DCB04D,BANK DCB04E,BANK DCB04F
		BYTE	BANK DCB050,BANK DCB051,BANK DCB052,BANK DCB053
		BYTE	BANK DCB054,BANK DCB055,BANK DCB056,BANK DCB057
		BYTE	BANK DCB058,BANK DCB059,BANK DCB05A,BANK DCB05B
		BYTE	BANK DCB05C,BANK DCB05D,BANK DCB05E,BANK DCB05F
		BYTE	BANK DCB060,BANK DCB061,BANK DCB062,BANK DCB063
		BYTE	BANK DCB064,BANK DCB065,BANK DCB066,BANK DCB067
		BYTE	BANK DCB068,BANK DCB069,BANK DCB06A,BANK DCB06B
		BYTE	BANK DCB06C,BANK DCB06D,BANK DCB06E,BANK DCB06F
		BYTE	BANK DCB070,BANK DCB071,BANK DCB072,BANK DCB073
		BYTE	BANK DCB074,BANK DCB075,BANK DCB076,BANK DCB077
		BYTE	BANK DCB078,BANK DCB079,BANK DCB07A,BANK DCB07B
		BYTE	BANK DCB07C,BANK DCB07D,BANK DCB07E,BANK DCB07F
		BYTE	BANK DCB080,BANK DCB081,BANK DCB082,BANK DCB083
		BYTE	BANK DCB084,BANK DCB085,BANK DCB086,BANK DCB087
		BYTE	BANK DCB088,BANK DCB089,BANK DCB08A,BANK DCB08B
		BYTE	BANK DCB0E8,BANK DCB0E9
;
OCADB		EQU	$
		BYTE	BANK DCB000,BANK DCB001,BANK DCB002,BANK DCB003
		BYTE	BANK DCB004,BANK DCB005,BANK DCB006,BANK DCB007
		BYTE	BANK DCB008,BANK DCB009,BANK DCB00A,BANK DCB00B
		BYTE	BANK DCB08C,BANK DCB08D,BANK DCB08E,BANK DCB08F
		BYTE	BANK DCB090,BANK DCB091,BANK DCB092,BANK DCB093
		BYTE	BANK DCB094,BANK DCB095,BANK DCB096,BANK DCB097
		BYTE	BANK DCB098,BANK DCB099,BANK DCB09A,BANK DCB09B
		BYTE	BANK DCB09C,BANK DCB09D,BANK DCB09E,BANK DCB09F
		BYTE	BANK DCB0A0,BANK DCB0A1,BANK DCB0A2,BANK DCB0A3
		BYTE	BANK DCB0A4,BANK DCB0A5,BANK DCB0A6,BANK DCB0A7
		BYTE	BANK DCB0A8,BANK DCB0A9,BANK DCB0AA,BANK DCB0AB
		BYTE	BANK DCB0AC,BANK DCB0AD,BANK DCB0AE,BANK DCB0AF
		BYTE	BANK DCB0B0,BANK DCB0B1,BANK DCB0B2,BANK DCB0B3
		BYTE	BANK DCB0B4,BANK DCB0B5,BANK DCB0B6,BANK DCB0B7
		BYTE	BANK DCB0B8,BANK DCB0B9,BANK DCB0BA,BANK DCB0BB
		BYTE	BANK DCB0BC,BANK DCB0BD,BANK DCB0BE,BANK DCB0BF
		BYTE	BANK DCB0C0,BANK DCB0C1,BANK DCB0C2,BANK DCB0C3
		BYTE	BANK DCB0C4,BANK DCB0C5,BANK DCB0C6,BANK DCB0C7
		BYTE	BANK DCB0C8,BANK DCB0C9,BANK DCB0CA,BANK DCB0CB
		BYTE	BANK DCB0CC,BANK DCB0CD,BANK DCB0CE,BANK DCB0CF
		BYTE	BANK DCB0D0,BANK DCB0D1,BANK DCB0D2,BANK DCB0D3
		BYTE	BANK DCB0D4,BANK DCB0D5,BANK DCB0D6,BANK DCB0D7
		BYTE	BANK DCB0D8,BANK DCB0D9,BANK DCB0DA,BANK DCB0DB
		BYTE	BANK DCB0DC,BANK DCB0DD,BANK DCB0DE,BANK DCB0DF
		BYTE	BANK DCB0E0,BANK DCB0E1,BANK DCB0E2,BANK DCB0E3
		BYTE	BANK DCB0E4,BANK DCB0E5,BANK DCB0E6,BANK DCB0E7
		BYTE	BANK DCB0E8,BANK DCB0E9,BANK DCB0EA,BANK DCB0EB
		BYTE	BANK DCB0EC,BANK DCB0ED,BANK DCB0EE,BANK DCB0EF
		BYTE	BANK DCB0F0
;
;
BCADH		EQU	$
		BYTE	HIGH DCB00C,HIGH DCB00D,HIGH DCB00E,HIGH DCB00F
		BYTE	HIGH DCB010,HIGH DCB011,HIGH DCB012,HIGH DCB013
		BYTE	HIGH DCB014,HIGH DCB015,HIGH DCB016,HIGH DCB017
		BYTE	HIGH DCB018,HIGH DCB019,HIGH DCB01A,HIGH DCB01B
		BYTE	HIGH DCB01C,HIGH DCB01D,HIGH DCB01E,HIGH DCB01F
		BYTE	HIGH DCB020,HIGH DCB021,HIGH DCB022,HIGH DCB023
		BYTE	HIGH DCB024,HIGH DCB025,HIGH DCB026,HIGH DCB027
		BYTE	HIGH DCB028,HIGH DCB029,HIGH DCB02A,HIGH DCB02B
		BYTE	HIGH DCB02C,HIGH DCB02D,HIGH DCB02E,HIGH DCB02F
		BYTE	HIGH DCB030,HIGH DCB031,HIGH DCB032,HIGH DCB033
		BYTE	HIGH DCB034,HIGH DCB035,HIGH DCB036,HIGH DCB037
		BYTE	HIGH DCB038,HIGH DCB039,HIGH DCB03A,HIGH DCB03B
		BYTE	HIGH DCB03C,HIGH DCB03D,HIGH DCB03E,HIGH DCB03F
		BYTE	HIGH DCB040,HIGH DCB041,HIGH DCB042,HIGH DCB043
		BYTE	HIGH DCB044,HIGH DCB045,HIGH DCB046,HIGH DCB047
		BYTE	HIGH DCB048,HIGH DCB049,HIGH DCB04A,HIGH DCB04B
		BYTE	HIGH DCB04C,HIGH DCB04D,HIGH DCB04E,HIGH DCB04F
		BYTE	HIGH DCB050,HIGH DCB051,HIGH DCB052,HIGH DCB053
		BYTE	HIGH DCB054,HIGH DCB055,HIGH DCB056,HIGH DCB057
		BYTE	HIGH DCB058,HIGH DCB059,HIGH DCB05A,HIGH DCB05B
		BYTE	HIGH DCB05C,HIGH DCB05D,HIGH DCB05E,HIGH DCB05F
		BYTE	HIGH DCB060,HIGH DCB061,HIGH DCB062,HIGH DCB063
		BYTE	HIGH DCB064,HIGH DCB065,HIGH DCB066,HIGH DCB067
		BYTE	HIGH DCB068,HIGH DCB069,HIGH DCB06A,HIGH DCB06B
		BYTE	HIGH DCB06C,HIGH DCB06D,HIGH DCB06E,HIGH DCB06F
		BYTE	HIGH DCB070,HIGH DCB071,HIGH DCB072,HIGH DCB073
		BYTE	HIGH DCB074,HIGH DCB075,HIGH DCB076,HIGH DCB077
		BYTE	HIGH DCB078,HIGH DCB079,HIGH DCB07A,HIGH DCB07B
		BYTE	HIGH DCB07C,HIGH DCB07D,HIGH DCB07E,HIGH DCB07F
		BYTE	HIGH DCB080,HIGH DCB081,HIGH DCB082,HIGH DCB083
		BYTE	HIGH DCB084,HIGH DCB085,HIGH DCB086,HIGH DCB087
		BYTE	HIGH DCB088,HIGH DCB089,HIGH DCB08A,HIGH DCB08B
		BYTE	HIGH DCB0E8,HIGH DCB0E9
;
OCADH		EQU	$
		BYTE	HIGH DCB000,HIGH DCB001,HIGH DCB002,HIGH DCB003
		BYTE	HIGH DCB004,HIGH DCB005,HIGH DCB006,HIGH DCB007
		BYTE	HIGH DCB008,HIGH DCB009,HIGH DCB00A,HIGH DCB00B
		BYTE	HIGH DCB08C,HIGH DCB08D,HIGH DCB08E,HIGH DCB08F
		BYTE	HIGH DCB090,HIGH DCB091,HIGH DCB092,HIGH DCB093
		BYTE	HIGH DCB094,HIGH DCB095,HIGH DCB096,HIGH DCB097
		BYTE	HIGH DCB098,HIGH DCB099,HIGH DCB09A,HIGH DCB09B
		BYTE	HIGH DCB09C,HIGH DCB09D,HIGH DCB09E,HIGH DCB09F
		BYTE	HIGH DCB0A0,HIGH DCB0A1,HIGH DCB0A2,HIGH DCB0A3
		BYTE	HIGH DCB0A4,HIGH DCB0A5,HIGH DCB0A6,HIGH DCB0A7
		BYTE	HIGH DCB0A8,HIGH DCB0A9,HIGH DCB0AA,HIGH DCB0AB
		BYTE	HIGH DCB0AC,HIGH DCB0AD,HIGH DCB0AE,HIGH DCB0AF
		BYTE	HIGH DCB0B0,HIGH DCB0B1,HIGH DCB0B2,HIGH DCB0B3
		BYTE	HIGH DCB0B4,HIGH DCB0B5,HIGH DCB0B6,HIGH DCB0B7
		BYTE	HIGH DCB0B8,HIGH DCB0B9,HIGH DCB0BA,HIGH DCB0BB
		BYTE	HIGH DCB0BC,HIGH DCB0BD,HIGH DCB0BE,HIGH DCB0BF
		BYTE	HIGH DCB0C0,HIGH DCB0C1,HIGH DCB0C2,HIGH DCB0C3
		BYTE	HIGH DCB0C4,HIGH DCB0C5,HIGH DCB0C6,HIGH DCB0C7
		BYTE	HIGH DCB0C8,HIGH DCB0C9,HIGH DCB0CA,HIGH DCB0CB
		BYTE	HIGH DCB0CC,HIGH DCB0CD,HIGH DCB0CE,HIGH DCB0CF
		BYTE	HIGH DCB0D0,HIGH DCB0D1,HIGH DCB0D2,HIGH DCB0D3
		BYTE	HIGH DCB0D4,HIGH DCB0D5,HIGH DCB0D6,HIGH DCB0D7
		BYTE	HIGH DCB0D8,HIGH DCB0D9,HIGH DCB0DA,HIGH DCB0DB
		BYTE	HIGH DCB0DC,HIGH DCB0DD,HIGH DCB0DE,HIGH DCB0DF
		BYTE	HIGH DCB0E0,HIGH DCB0E1,HIGH DCB0E2,HIGH DCB0E3
		BYTE	HIGH DCB0E4,HIGH DCB0E5,HIGH DCB0E6,HIGH DCB0E7
		BYTE	HIGH DCB0E8,HIGH DCB0E9,HIGH DCB0EA,HIGH DCB0EB
		BYTE	HIGH DCB0EC,HIGH DCB0ED,HIGH DCB0EE,HIGH DCB0EF
		BYTE	HIGH DCB0F0
;
;
BCADL		EQU	$
		BYTE	LOW DCB00C,LOW DCB00D,LOW DCB00E,LOW DCB00F
		BYTE	LOW DCB010,LOW DCB011,LOW DCB012,LOW DCB013
		BYTE	LOW DCB014,LOW DCB015,LOW DCB016,LOW DCB017
		BYTE	LOW DCB018,LOW DCB019,LOW DCB01A,LOW DCB01B
		BYTE	LOW DCB01C,LOW DCB01D,LOW DCB01E,LOW DCB01F
		BYTE	LOW DCB020,LOW DCB021,LOW DCB022,LOW DCB023
		BYTE	LOW DCB024,LOW DCB025,LOW DCB026,LOW DCB027
		BYTE	LOW DCB028,LOW DCB029,LOW DCB02A,LOW DCB02B
		BYTE	LOW DCB02C,LOW DCB02D,LOW DCB02E,LOW DCB02F
		BYTE	LOW DCB030,LOW DCB031,LOW DCB032,LOW DCB033
		BYTE	LOW DCB034,LOW DCB035,LOW DCB036,LOW DCB037
		BYTE	LOW DCB038,LOW DCB039,LOW DCB03A,LOW DCB03B
		BYTE	LOW DCB03C,LOW DCB03D,LOW DCB03E,LOW DCB03F
		BYTE	LOW DCB040,LOW DCB041,LOW DCB042,LOW DCB043
		BYTE	LOW DCB044,LOW DCB045,LOW DCB046,LOW DCB047
		BYTE	LOW DCB048,LOW DCB049,LOW DCB04A,LOW DCB04B
		BYTE	LOW DCB04C,LOW DCB04D,LOW DCB04E,LOW DCB04F
		BYTE	LOW DCB050,LOW DCB051,LOW DCB052,LOW DCB053
		BYTE	LOW DCB054,LOW DCB055,LOW DCB056,LOW DCB057
		BYTE	LOW DCB058,LOW DCB059,LOW DCB05A,LOW DCB05B
		BYTE	LOW DCB05C,LOW DCB05D,LOW DCB05E,LOW DCB05F
		BYTE	LOW DCB060,LOW DCB061,LOW DCB062,LOW DCB063
		BYTE	LOW DCB064,LOW DCB065,LOW DCB066,LOW DCB067
		BYTE	LOW DCB068,LOW DCB069,LOW DCB06A,LOW DCB06B
		BYTE	LOW DCB06C,LOW DCB06D,LOW DCB06E,LOW DCB06F
		BYTE	LOW DCB070,LOW DCB071,LOW DCB072,LOW DCB073
		BYTE	LOW DCB074,LOW DCB075,LOW DCB076,LOW DCB077
		BYTE	LOW DCB078,LOW DCB079,LOW DCB07A,LOW DCB07B
		BYTE	LOW DCB07C,LOW DCB07D,LOW DCB07E,LOW DCB07F
		BYTE	LOW DCB080,LOW DCB081,LOW DCB082,LOW DCB083
		BYTE	LOW DCB084,LOW DCB085,LOW DCB086,LOW DCB087
		BYTE	LOW DCB088,LOW DCB089,LOW DCB08A,LOW DCB08B
		BYTE	LOW DCB0E8,LOW DCB0E9
;
OCADL		EQU	$
		BYTE	LOW DCB000,LOW DCB001,LOW DCB002,LOW DCB003
		BYTE	LOW DCB004,LOW DCB005,LOW DCB006,LOW DCB007
		BYTE	LOW DCB008,LOW DCB009,LOW DCB00A,LOW DCB00B
		BYTE	LOW DCB08C,LOW DCB08D,LOW DCB08E,LOW DCB08F
		BYTE	LOW DCB090,LOW DCB091,LOW DCB092,LOW DCB093
		BYTE	LOW DCB094,LOW DCB095,LOW DCB096,LOW DCB097
		BYTE	LOW DCB098,LOW DCB099,LOW DCB09A,LOW DCB09B
		BYTE	LOW DCB09C,LOW DCB09D,LOW DCB09E,LOW DCB09F
		BYTE	LOW DCB0A0,LOW DCB0A1,LOW DCB0A2,LOW DCB0A3
		BYTE	LOW DCB0A4,LOW DCB0A5,LOW DCB0A6,LOW DCB0A7
		BYTE	LOW DCB0A8,LOW DCB0A9,LOW DCB0AA,LOW DCB0AB
		BYTE	LOW DCB0AC,LOW DCB0AD,LOW DCB0AE,LOW DCB0AF
		BYTE	LOW DCB0B0,LOW DCB0B1,LOW DCB0B2,LOW DCB0B3
		BYTE	LOW DCB0B4,LOW DCB0B5,LOW DCB0B6,LOW DCB0B7
		BYTE	LOW DCB0B8,LOW DCB0B9,LOW DCB0BA,LOW DCB0BB
		BYTE	LOW DCB0BC,LOW DCB0BD,LOW DCB0BE,LOW DCB0BF
		BYTE	LOW DCB0C0,LOW DCB0C1,LOW DCB0C2,LOW DCB0C3
		BYTE	LOW DCB0C4,LOW DCB0C5,LOW DCB0C6,LOW DCB0C7
		BYTE	LOW DCB0C8,LOW DCB0C9,LOW DCB0CA,LOW DCB0CB
		BYTE	LOW DCB0CC,LOW DCB0CD,LOW DCB0CE,LOW DCB0CF
		BYTE	LOW DCB0D0,LOW DCB0D1,LOW DCB0D2,LOW DCB0D3
		BYTE	LOW DCB0D4,LOW DCB0D5,LOW DCB0D6,LOW DCB0D7
		BYTE	LOW DCB0D8,LOW DCB0D9,LOW DCB0DA,LOW DCB0DB
		BYTE	LOW DCB0DC,LOW DCB0DD,LOW DCB0DE,LOW DCB0DF
		BYTE	LOW DCB0E0,LOW DCB0E1,LOW DCB0E2,LOW DCB0E3
		BYTE	LOW DCB0E4,LOW DCB0E5,LOW DCB0E6,LOW DCB0E7
		BYTE	LOW DCB0E8,LOW DCB0E9,LOW DCB0EA,LOW DCB0EB
		BYTE	LOW DCB0EC,LOW DCB0ED,LOW DCB0EE,LOW DCB0EF
		BYTE	LOW DCB0F0
;
;
;
;
;
C_0A0		EQU	000H
C_0A1		EQU	001H
C_0B0		EQU	002H
C_0B1		EQU	003H
C_0C0		EQU	004H
C_0C1		EQU	005H
C_0D0		EQU	006H
C_0D1		EQU	007H
C_0E0		EQU	008H
C_0E1		EQU	009H
C_0F0		EQU	00AH
C_0F1		EQU	00BH
C_0G0		EQU	00CH
C_0G1		EQU	00DH
C_0H0		EQU	00EH
C_0H1		EQU	00FH
C_0I0		EQU	010H
C_0I1		EQU	011H
C_0J0		EQU	012H
C_0J1		EQU	013H
C_0K0		EQU	014H
C_0K1		EQU	015H
C_0L0		EQU	016H
C_0L1		EQU	017H
C_0M0		EQU	018H
C_0M1		EQU	019H
C_0N0		EQU	01AH
C_0N1		EQU	01BH
C_0O0		EQU	01CH
C_0O1		EQU	01DH
C_0P0		EQU	01EH
C_0P1		EQU	01FH
C_0Q0		EQU	020H
C_0Q1		EQU	021H
C_0R0		EQU	022H
C_0R1		EQU	023H
C_0S0		EQU	024H
C_0S1		EQU	025H
C_0T0		EQU	026H
C_0T1		EQU	027H
C_0U0		EQU	028H
C_0U1		EQU	029H
C_0V0		EQU	02AH
C_0V1		EQU	02BH
C_0W0		EQU	02CH
C_0W1		EQU	02DH
C_0X0		EQU	02EH
C_0X1		EQU	02FH
C_0Y0		EQU	030H
C_0Y1		EQU	031H
C_0Z0		EQU	032H
C_0Z1		EQU	033H
C_1A0		EQU	034H
C_1A1		EQU	035H
C_1B0		EQU	036H
C_1B1		EQU	037H
C_1C0		EQU	038H
C_1C1		EQU	039H
C_1D0		EQU	03AH
C_1D1		EQU	03BH
C_1E0		EQU	03CH
C_1E1		EQU	03DH
C_1F0		EQU	03EH
C_1F1		EQU	03FH
C_1G0		EQU	040H
C_1G1		EQU	041H
C_1H0		EQU	042H
C_1H1		EQU	043H
C_1I0		EQU	044H
C_1I1		EQU	045H
C_1J0		EQU	046H
C_1J1		EQU	047H
C_1K0		EQU	048H
C_1K1		EQU	049H
C_1L0		EQU	04AH
C_1L1		EQU	04BH
C_1M0		EQU	04CH
C_1M1		EQU	04DH
C_1N0		EQU	04EH
C_1N1		EQU	04FH
C_1O0		EQU	050H
C_1O1		EQU	051H
C_1P0		EQU	052H
C_1P1		EQU	053H
C_1Q0		EQU	054H
C_1Q1		EQU	055H
C_1R0		EQU	056H
C_1R1		EQU	057H
C_1S0		EQU	058H
C_1S1		EQU	059H
C_1T0		EQU	05AH
C_1T1		EQU	05BH
C_1U0		EQU	05CH
C_1U1		EQU	05DH
C_1V0		EQU	05EH
C_1V1		EQU	05FH
C_1W0		EQU	060H
C_1W1		EQU	061H
C_1X0		EQU	062H
C_1X1		EQU	063H
C_1Y0		EQU	064H
C_1Y1		EQU	065H
C_1Z0		EQU	066H
C_1Z1		EQU	067H
C_2A0		EQU	068H
C_2A1		EQU	069H
C_2B0		EQU	06AH
C_2B1		EQU	06BH
C_2C0		EQU	06CH
C_2C1		EQU	06DH
C_2D0		EQU	06EH
C_2D1		EQU	06FH
C_2E0		EQU	070H
C_2E1		EQU	071H
C_2F0		EQU	072H
C_2F1		EQU	073H
C_2G0		EQU	074H
C_2G1		EQU	075H
C_2H0		EQU	076H
C_2H1		EQU	077H
C_2I0		EQU	078H
C_2I1		EQU	079H
C_2J0		EQU	07AH
C_2J1		EQU	07BH
C_2K0		EQU	07CH
C_2K1		EQU	07DH
C_2L0		EQU	07EH
C_2L1		EQU	07FH		; BG. char.
C_4R0		EQU	080H	;0E8H	; Map BG.
C_4R1		EQU	081H	;0E9H	; Map BG.
;
;;;;C_2M		EQU	000H
;;;;C_2N		EQU	000H
;;;;C_2O		EQU	000H
;;;;C_2P		EQU	000H
;;;;C_2Q		EQU	000H	; Player char. BANK
C_2R0		EQU	000H	;080H
C_2R1		EQU	001H	;081H
C_2S0		EQU	002H	;082H
C_2S1		EQU	003H	;083H
C_2T0		EQU	004H	;084H
C_2T1		EQU	005H	;085H
C_2U0		EQU	006H	;086H
C_2U1		EQU	007H	;087H
C_2V0		EQU	008H	;088H
C_2V1		EQU	009H	;089H
C_2W0		EQU	00AH	;08AH
C_2W1		EQU	00BH	;08BH
C_2X0		EQU	00CH	;08CH
C_2X1		EQU	00DH	;08DH
C_2Y0		EQU	00EH	;08EH
C_2Y1		EQU	00FH	;08FH
C_2Z0		EQU	010H	;090H
C_2Z1		EQU	011H	;091H
C_3A0		EQU	012H	;092H
C_3A1		EQU	013H	;093H
C_3B0		EQU	014H	;094H
C_3B1		EQU	015H	;095H
C_3C0		EQU	016H	;096H
C_3C1		EQU	017H	;097H
C_3D0		EQU	018H	;098H
C_3D1		EQU	019H	;099H
C_3E0		EQU	01AH	;09AH
C_3E1		EQU	01BH	;09BH
C_3F0		EQU	01CH	;09CH
C_3F1		EQU	01DH	;09DH
C_3G0		EQU	01EH	;09EH
C_3G1		EQU	01FH	;09FH
C_3H0		EQU	020H	;0A0H
C_3H1		EQU	021H	;0A1H
C_3I0		EQU	022H	;0A2H
C_3I1		EQU	023H	;0A3H
C_3J0		EQU	024H	;0A4H
C_3J1		EQU	025H	;0A5H
C_3K0		EQU	026H	;0A6H
C_3K1		EQU	027H	;0A7H
C_3L0		EQU	028H	;0A8H
C_3L1		EQU	029H	;0A9H
C_3M0		EQU	02AH	;0AAH
C_3M1		EQU	02BH	;0ABH
C_3N0		EQU	02CH	;0ACH
C_3N1		EQU	02DH	;0ADH
C_3O0		EQU	02EH	;0AEH
C_3O1		EQU	02FH	;0AFH
C_3P0		EQU	030H	;0B0H
C_3P1		EQU	031H	;0B1H
C_3Q0		EQU	032H	;0B2H
C_3Q1		EQU	033H	;0B3H
C_3R0		EQU	034H	;0B4H
C_3R1		EQU	035H	;0B5H
C_3S0		EQU	036H	;0B6H
C_3S1		EQU	037H	;0B7H
C_3T0		EQU	038H	;0B8H
C_3T1		EQU	039H	;0B9H
C_3U0		EQU	03AH	;0BAH
C_3U1		EQU	03BH	;0BBH
C_3V0		EQU	03CH	;0BCH
C_3V1		EQU	03DH	;0BDH
C_3W0		EQU	03EH	;0BEH
C_3W1		EQU	03FH	;0BFH
C_3X0		EQU	040H	;0C0H
C_3X1		EQU	041H	;0C1H
C_3Y0		EQU	042H	;0C2H
C_3Y1		EQU	043H	;0C3H
C_3Z0		EQU	044H	;0C4H
C_3Z1		EQU	045H	;0C5H
C_4A0		EQU	046H	;0C6H
C_4A1		EQU	047H	;0C7H
C_4B0		EQU	048H	;0C8H
C_4B1		EQU	049H	;0C9H
C_4C0		EQU	04AH	;0CAH
C_4C1		EQU	04BH	;0CBH
C_4D0		EQU	04CH	;0CCH
C_4D1		EQU	04DH	;0CDH
C_4E0		EQU	04EH	;0CEH
C_4E1		EQU	04FH	;0CFH
C_4F0		EQU	050H	;0D0H
C_4F1		EQU	051H	;0D1H
C_4G0		EQU	052H	;0D2H
C_4G1		EQU	053H	;0D3H
C_4H0		EQU	054H	;0D4H
C_4H1		EQU	055H	;0D5H
C_4I0		EQU	056H	;0D6H
C_4I1		EQU	057H	;0D7H
C_4J0		EQU	058H	;0D8H
C_4J1		EQU	059H	;0D9H
C_4K0		EQU	05AH	;0DAH
C_4K1		EQU	05BH	;0DBH
C_4L0		EQU	05CH	;0DCH
C_4L1		EQU	05DH	;0DDH
C_4M0		EQU	05EH	;0DEH
C_4M1		EQU	05FH	;0DFH
C_4N0		EQU	060H	;0E0H
C_4N1		EQU	061H	;0E1H
C_4O0		EQU	062H	;0E2H
C_4O1		EQU	063H	;0E3H
C_4P0		EQU	064H	;0E4H
C_4P1		EQU	065H	;0E5H
C_4Q0		EQU	066H	;0E6H
C_4Q1		EQU	067H	;0E7H
;// 02.10.23 //C_4R0		EQU	068H	;0E8H
;// 02.10.23 //C_4R1		EQU	069H	;0E9H
C_4R2		EQU	068H	;0E8H		; Map obj.
C_4R3		EQU	069H	;0E9H		; Map obj.
;
C_4S0		EQU	06AH	;0EAH
C_4S1		EQU	06BH	;0EBH
;
C_4T		EQU	06CH	;0ECH
C_4U		EQU	06DH	;0EDH
C_4V		EQU	06EH	;0EEH
C_4W		EQU	06FH	;0EFH
C_4X		EQU	070H	;0F0H		; BG.3 char.
;
;
;
;
;************************************************************************
;*		Change char. buffer initial set		(CCBFIT)	*
;************************************************************************
BYCDPD		EQU	$		; [B],[Y] char. data pointer
;			     loot     hammer      arrow      skope
		WORD	00018H*00H,00018H*0BH,00018H*08H,00018H*66H
;			 zzz,onpu       kona    bow-gun
		WORD	00018H*6AH,00018H*6DH,00018H*22H
;
;
CCBFIT		EQU	$
;---------------------------------------- sword char.buffer set
		JSL	>KNCBFST	; sword character buffer set
;
;
;---------------------------------------- shild char.buffer set
		JSL	>TTCBFST	; sword character buffer set
;
;
;---------------------------------------- [B],[Y] item char.buffer set
		PHB
		PHK
		PLB			; (DBR) push
;
		MEM16
		REP	#00100000B	; memory 16bit mode
;
		STZ	<WORKA
		STZ	<WORKC
		LDA	#IMCHBF-CNGCHBF
		STA	<WORK6
;
		MEM8
		SEP	#00100000B	; memory 8bit mode
;
		LDA	#007H
		JSR	CCBIS000	; loot char. buffer set
;
		LDA	#007H
		JSR	CCBIS000	; hammer char. buufer set
;
		LDA	#003H
		JSR	CCBIS000	; arrow char. buufer set
;
		LDY	#C_4O0
		LDA	#004H
		JSR	CCBIS100	; skope char. buufer set
;
;// 02.10.23 //		LDY	#C_2S0
;// 02.10.23 //		LDA	#003H
;// 02.10.23 //		JSR	CCBIS040	; zzz,onpu char. buffer set
		LDA	#003H
		JSR	CCBIS140	; zzz,onpu char. buffer set
;
		LDA	#001H
		JSR	CCBIS140	; kona char. buffer set
;
		LDA	#004H
		JSR	CCBIS000	; bow-gun char. buufer set
;
;---------------------------------------- block char. buffer set
		LDY	#C_4J0
		JSR	CADWKST2	; Obj. char. address work set
;
		MEM16
		IDX16
		REP	#00110000B	; memory,index 16bit mode
;
		LDA	<WORK0
		LDX	#BKCHBF-CNGCHBF
		PHA			; (A) push
		LDY	#00008H
		JSR	CCBIS420	; block char. set
;// 02.10.30 //		JSR	CCBIS200	; block char. set
;
		PLA			; (A) pull
		CLC
		ADC	#00180H
		LDY	#00008H
		JSR	CCBIS420	; block char. set
;// 02.10.30 //		JSR	CCBIS200	; block char. set
;
;
;;;;;;;;;---------------------------------------- water char. buffer set
;;;;;;;;		MEM8
;;;;;;;;		IDX8
;;;;;;;;		SEP	#00110000B	; memory,index 8bit mode
;;;;;;;;;
;;;;;;;;		LDY	#C_1F0
;;;;;;;;		JSR	CADWKST0	; Bg.. char. address work set
;;;;;;;;;
;;;;;;;;		MEM16
;;;;;;;;		IDX16
;;;;;;;;		REP	#00110000B	; memory,index 16bit mode
;;;;;;;;;
;;;;;;;;		LDA	<WORK0
;;;;;;;;		LDY	#(16+4)*3
;;;;;;;;		LDX	#WTRCHBF-CNGCHBF
;;;;;;;;		JSR	CCBIS320	; water char. buffer set
;;;;;;;;;
;;;;;;;;		MEM8
;;;;;;;;		IDX8
;;;;;;;;		SEP	#00110000B	; memory,index 8bit mode
;
;
;---------------------------------------- enemy out item char. buffer set
		MEM8
		IDX8
		SEP	#00110000B	; memory,index 8bit mode
;
		LDY	#C_4P0
		JSR	CADWKST2	; Obj. char. address work set
;
		MEM16
		IDX16
		REP	#00110000B	; memory,index 16bit mode
;
		LDA	<WORK0
		LDX	#EICHBF-CNGCHBF
		LDY	#00003H
		PHA			; (A) push
		JSR	CCBIS420	; enemy out item char. buffer set
;
		PLA			; (A) pull
		CLC
		ADC	#00180H
		LDY	#00003H
		JSR	CCBIS420	; enemy out item char. buffer set
;
;
		MEM8
		IDX8
		SEP	#00110000B	; memory,index 8bit mode
;
;// 02.10.23 //		LDY	#C_2T0
;// 02.10.23 //		JSR	CADWKST		; char. address work set
		LDA	#BANK MPCHBF
		STA	<WORK2
		STA	<WORK5
;
		MEM16
		IDX16
		REP	#00110001B	; memory,index 16bit mode & CLC
;
		LDA	#MPCHBF
;// 02.10.23 //		LDA	<WORK0
		ADC	#00018H*3
		LDX	#(EICHBF-CNGCHBF)+20H*6
		LDY	#(2*3)*3
		PHA			; (A) push
		JSR	CCBIS420	; enemy out item char. buffer set
;
		PLA			; (A) pull
		CLC
		ADC	#00180H
		LDY	#(2*3)*3
		JSR	CCBIS420	; enemy out item char. buffer set
;
		MEM8
		IDX8
		SEP	#00110000B	; memory,index 8bit mode
		PLB			; (DBR) pull
		RTL
;
;
;
;
;
;
;************************************************************************
;*		Sword char. buffer initial set		(KNCBFST)	*
;************************************************************************
KNCDPD		EQU	$		; sword char. data pointer
		WORD	00018H*0CH*0,00018H*0CH*0,00018H*0CH*1,00018H*0CH*1,00018H*0CH*1
;
;
KNCBFST		EQU	$
		PHB
		PHK
		PLB			; (DBR) set
;
		LDY	#C_4O1
		JSR	CADWKST3	; Obj. char. address work set
		LDY	#C_4O0
		JSR	CADWKST2	; Obj. char. address work set
;
		MEM16
		REP	#00100001B	; memory 16bit mode & CLC
;
		LDA	>ITMTBL6
		AND	#000FFH
		ASL	A
		TAY
		LDA	<WORK0
		ADC	KNCDPD,Y
;
		IDX16
		REP	#00010000B	; index 16bit mode
;
		LDX	#KNCHBF-CNGCHBF
		LDY	#0000CH
		PHA			; (A) push
		JSR	CCBIS420	; sword char. buffer set
;
		PLA			; (A) pull
		CLC
		ADC	#00180H
		LDY	#0000CH
		JSR	CCBIS420	; sword char. buffer set
;
		MEM8
		IDX8
		SEP	#00110000B	; memory,index 8bit mode
		PLB			; (DBR) reset
		RTL
;
;
;
;************************************************************************
;*		Shild char. buffer initial set		(TTCBFST)	*
;************************************************************************
TTCDPD		EQU	$		; shild char. data pointer
		WORD	00018H*44H,00018H*44H,00018H*4AH,00018H*60H
;
;
TTCBFST		EQU	$
		PHB
		PHK
		PLB			; (DBR) set
;
		LDY	#C_4O1
		JSR	CADWKST3	; Obj. char. address work set
		LDY	#C_4O0
		JSR	CADWKST2	; Obj. char. address work set
;
		MEM16
		REP	#00100001B	; memory 16bit mode & CLC
;
		LDA	>ITMTBL7
		ASL	A
		TAY
		LDA	<WORK0
		ADC	TTCDPD,Y
;
		IDX16
		REP	#00010000B	; index 16bit mode
;
		LDX	#TTCHBF-CNGCHBF
		PHA			; (A) push
		JSR	CCBIS400	; shild char. buffer set
;
		PLA			; (A) pull
		CLC
		ADC	#00180H
		JSR	CCBIS400	; shild char. buffer set
;
		MEM8
		IDX8
		SEP	#00110000B	; memory,index 8bit mode
		PLB			; (DBR) reset
		RTL
;
;
;
;************************************************************************
;*		Water Character buffer set 		(WTRCBFST)	*
;*		[in]	(Y)	<-- chara. pointer			*
;************************************************************************
WTRCBFST	EQU	$
		PHB
		PHK
		PLB			; (DBR) set
;
		PHY			; (Y) push
;
		JSR	CADWKST0	; Bg.. char. address work set
;
		MEM16
		IDX16
		REP	#00110000B	; memory,index 16bit mode
;
		LDA	<WORK0
		LDY	#(10H+10H)*2
		LDX	#WTRCHBF-CNGCHBF
		JSR	CCBIS320	; water char. buffer set
;
		MEM8
		IDX8
		SEP	#00110000B	; memory,index 8bit mode
;
		PLY			; (Y) pull
		INY
		JSR	CADWKST0	; Bg.. char. address work set
;
		MEM16
		IDX16
		REP	#00110000B	; memory,index 16bit mode
;
		LDA	<WORK0
		LDY	#(10H+10H)*1
		LDX	#WTRCHBF-CNGCHBF+((10H+10H)*20H*2)
		JSR	CCBIS320	; water char. buffer set
;
		MEM8
		IDX8
		SEP	#00110000B	; memory,index 8bit mode
;
		PLB			; (DBR) reset
		RTL
;
;
;
;************************************************************************
;*		Option Character buffer set 		(OPTCBFST)	*
;*		[in]	(Y)	<-- chara. pointer			*
;************************************************************************
OPTDPT		EQU	$
;			   not     queen     jiji              tori
		WORD	018H*00H,018H*00H,018H*20H,018H*20H,018H*40H
;
;
OPTCBFST	EQU	$
		PHB
		PHK
		PLB			; (DBR) set
;
		LDY	#C_4S1
		JSR	CADWKST3	; Obj. char. address work set
		LDY	#C_4S0
		JSR	CADWKST2	; OBJ. char. address work set
;
		MEM16
		IDX16
		REP	#00110000B	; memory,index 16bit mode
;
		LDA	>OPMODE
		AND	#000FFH
		ASL	A
		TAX
		LDA	<WORK0
		CLC
		ADC	>OPTDPT,X
		LDY	#(10H+10H)*1
		LDX	#OPTCHBF-CNGCHBF
		JSR	CCBIS320	; water char. buffer set
;
		MEM8
		IDX8
		SEP	#00110000B	; memory,index 8bit mode
;
		PLB			; (DBR) reset
		RTL
;
;
;************************************************************************
;*		Item char. buffer set			(ITMCBFST)	*
;************************************************************************
ITMCPTD		EQU	$
;			   bin       bomb*3     ya*3        life
		WORD	00018H*68H,00018H*02H,00018H*04H,00018H*06H
;			   fuku      yumi        ken       tsue
		WORD	00018H*08H,00018H*20H,00018H*21H,00018H*22H
;			 buw-gun      lot      nummer      kona
		WORD	00018H*23H,00018H*24H,00018H*25H,00018H*26H
;			   fue      tebukuro      hon       key
		WORD	00018H*28H,00018H*2AH,00018H*2CH,00018H*2EH
;			 buumeran     ashi     kagami      bomb
		WORD	00018H*2FH,00018H*40H,00018H*42H,00018H*44H
;			   lamp      kakure    jisyaku     tama
		WORD	00018H*46H,00018H*48H,00018H*4AH,00018H*4CH
;			  sp-ken     skope    sp-thunder  sp-fire
		WORD	00018H*4EH,00018H*4FH,00018H*60H,00018H*62H
;			 sp-jishin  kara-bin    kiniko     kusuri
		WORD	00018H*64H,00018H*66H,00018H*6AH,00018H*00H
;			   tate      letter     sp-key    pendanto
		WORD	00018H*0AH,00018H*6CH,00018H*6EH,00018H*0EH
;			  rupy1      rupy2      rupy3
		WORD	00018H*40H,00018H*41H,00018H*42H,00018H*0EH
;
;
ITMCBFST1	EQU	$
		PHB
		PHK
		PLB			; (DBR) set
;
		PHA			; (A) push
;;;;;;;;		LDA	#LOW MPCHBF
		STZ	<WORK0
		LDA	#HIGH MPCHBF
		STA	<WORK1
		LDA	#BANK MPCHBF
		STA	<WORK2
		STA	<WORK5
;
		BRA	ITMCBS60
;
ITMCBFST	EQU	$
		PHB
		PHK
		PLB			; (DBR) set
;
		PHA			; (A) push
;
		LDY	#C_4M1
		CMP	#024H
		BCC	ITMCBS40	;
;					;
		LDY	#C_4L1
ITMCBS40	EQU	$
		JSR	CADWKST3	; Obj. char. address work set
		LDY	#C_4M0
		JSR	CADWKST2	; Obj. char. address work set
;
ITMCBS60	EQU	$
		PLA			; (A) pull
;
		MEM16
		REP	#00100001B	; memory 16bit mode & CLC
;
		AND	#000FFH
		ASL	A
		TAX
		LDA	<WORK0
		ADC	ITMCPTD,X
;
		IDX16
		REP	#00010000B	; index 16bit mode
;
		LDX	#ITMCHBF-CNGCHBF
		LDY	#00002H
		PHA			; (A) push
		JSR	CCBIS420	; sword char. buffer set
;
		PLA			; (A) pull
		CLC
		ADC	#00180H
		LDY	#00002H
		JSR	CCBIS420	; sword char. buffer set
;
		MEM8
		IDX8
		SEP	#00110000B	; memory,index 8bit mode
		PLB			; (DBR) reset
		RTL
;
;
;
;************************************************************************
;*		Character buffer set sub.		(CCBIS000)	*
;************************************************************************
CCBIS000	EQU	$
		STA	<WORKA
		LDY	#C_2R0
		LDA	OCADB,Y 
		STA	<WORK2
		STA	<WORK5
		LDA	OCADH,Y
		STA	<WORK1
		LDA	OCADL,Y
		STA	<WORK0
		BRA	CCBIS180
;
;
;************************************************************************
;*		Character buffer set sub.		(CCBIS100)	*
;************************************************************************
CCBIS100	EQU	$
		PHA			; (A) push
;
		JSR	CADWKST2	; Obj. char. address work set
;
		PLA			; (A) pull
CCBIS140	EQU	$
		STA	<WORKA
;
;// 03.05.31 //		LDA	#LOW MPCHBF
		STZ	<WORK0
		LDA	#HIGH MPCHBF
		STA	<WORK1
		LDA	#BANK MPCHBF
		STA	<WORK2
		STA	<WORK5
CCBIS180	EQU	$
		MEM16
		IDX16
		REP	#00110001B	; memory,index 16bit mode & CLC
;
		LDY	<WORKC
		LDA	<WORK0
		ADC	BYCDPD,Y
		LDX	<WORK6
		LDY	<WORKA
		PHA			; (A) push
		JSR	CCBIS420	; character buffer set
;
		PLA			; (A) pull
		CLC
		ADC	#00180H
		LDY	<WORKA
		JSR	CCBIS420	; character buffer set
;
		INC	<WORKC
		INC	<WORKC
;
		STX	<WORK6
;
		MEM8
		IDX8
		SEP	#00110000B	; memory,index 8bit mode
		RTS
;
;
		MEM16
		IDX16
;************************************************************************
;*		Character buffer set sub.		(CCBIS200)	*
;************************************************************************
CCBIS200	EQU	$
		LDY	#00008H
CCBIS220	EQU	$
		STY	<WORKE
CCBIS240	EQU	$
		STA	<WORK0
		CLC
		ADC	#00010H
		STA	<WORK3
;
		LDY	#00007H
CCBIS260	EQU	$
		LDA	[<WORK0]
		STA	>CNGCHBF,X
		INC	<WORK0
		INC	<WORK0
		LDA	[<WORK3]
		AND	#000FFH
		STA	>CNGCHBF+010H,X
		INC	<WORK3
		INX
		INX
		DEY
		BPL	CCBIS260	; 1-char. set end ?
;					; yes
		TXA
		CLC
		ADC	#00010H
		TAX
		LDA	<WORK3
		AND	#00078H
		BNE	CCBIS280	; next ?
;					; yes
		LDA	<WORK3
		CLC
		ADC	#00180H
		STA	<WORK3
CCBIS280	EQU	$
		LDA	<WORK3
		DEC	<WORKE
		BNE	CCBIS240	; set end ?
;					; yes
		RTS
;
;
;************************************************************************
;*		Character buffer set sub.		(CCBIS300)	*
;************************************************************************
CCBIS300	EQU	$
		LDY	#00008H
CCBIS320	EQU	$
		STY	<WORKE
CCBIS340	EQU	$
		STA	<WORK0
		CLC
		ADC	#00010H
		STA	<WORK3
;
		LDY	#00007H/2
CCBIS360	EQU	$
		LDA	[<WORK0]
		STA	>CNGCHBF,X
		INC	<WORK0
		INC	<WORK0
		LDA	[<WORK3]
		AND	#000FFH
		STA	>CNGCHBF+010H,X
		INC	<WORK3
		INX
		INX
		LDA	[<WORK0]
		STA	>CNGCHBF,X
		INC	<WORK0
		INC	<WORK0
		LDA	[<WORK3]
		AND	#000FFH
		STA	>CNGCHBF+010H,X
		INC	<WORK3
		INX
		INX
		DEY
		BPL	CCBIS360	; 1-char. set end ?
;					; yes
		TXA
		CLC
		ADC	#00010H
		TAX
		LDA	<WORK3
		DEC	<WORKE
		BNE	CCBIS340	; set end ?
;					; yes
		RTS
;
;
;************************************************************************
;*		Character buffer set sub.		(CCBIS400)	*
;************************************************************************
CCBIS400	EQU	$
		LDY	#00006H
CCBIS420	EQU	$
		STY	<WORKE
CCBIS440	EQU	$
		STA	<WORK0
		CLC
		ADC	#00010H
		STA	<WORK3
;
		LDY	#00007H
CCBIS460	EQU	$
		LDA	[<WORK0]
		STA	>CNGCHBF,X
		XBA
		ORA	[<WORK0]
		AND	#000FFH
		STA	<WORK8
		INC	<WORK0
		INC	<WORK0
;
		LDA	[<WORK3]
		AND	#000FFH
		STA	<WORKZ
		ORA	<WORK8
		XBA
		ORA	<WORKZ
		STA	>CNGCHBF+010H,X
		INC	<WORK3
		INX
		INX
		DEY
		BPL	CCBIS460	; 1-char. set end ?
;					; yes
		TXA
		CLC
		ADC	#00010H
		TAX
		LDA	<WORK3
		AND	#00078H
		BNE	CCBIS480	; next ?
;					; yes
		LDA	<WORK3
		CLC
		ADC	#00180H
		STA	<WORK3
CCBIS480	EQU	$
		LDA	<WORK3
		DEC	<WORKE
		BNE	CCBIS440	; set end ?
;					; yes
		RTS
;
;
;
;
		MEM8
		IDX8
;************************************************************************
;*		Player water CG. set			(PWTRCGS0)	*
;************************************************************************
PWTRCGS0	EQU	$
		LDA	#00000001B
		STA	<PLBGCKF	; player BG.1 check
PWTRCGS2	EQU	$
		LDA	#00000001B
		STA	!PCGCKF
PWTRS00		EQU	$
		MEM16
		REP	#00100001B	; memory 16bit mode & CLC
;
		LDX	#000H
PWTRS40		EQU	$
		LDA	>CGRAM+100H,X
		PHA			; (A) push
		LDA	>CGRAM+1E0H,X
		STA	>CGRAM+100H,X
		STA	>CGWORK+100H,X
		PLA			; (A) pull
		STA	>CGRAM+1E0H,X
		STA	>CGWORK+1E0H,X
;
		LDA	>CGRAM+110H,X
		PHA			; (A) push
		LDA	>CGRAM+1F0H,X
		STA	>CGRAM+110H,X
		STA	>CGWORK+110H,X
		PLA			; (A) pull
		STA	>CGRAM+1F0H,X
		STA	>CGWORK+1F0H,X
;
		LDA	>CGRAM+1B0H,X
		PHA			; (A) push
		LDA	>CGRAM+170H,X
		STA	>CGRAM+1B0H,X
		STA	>CGWORK+1B0H,X
		PLA			; (A) pull
		STA	>CGRAM+170H,X
		STA	>CGWORK+170H,X
;
		INX
		INX
		CPX	#010H
		BNE	PWTRS40		; end ?
;					; yes
;// 02.10.30 //		LDA	#00200H
;// 02.10.30 //		STA	!CGSTPT		; (CGWORK) set
;// 02.10.30 //;
;// 02.10.30 //		LDX	PLYOJC
;// 02.10.30 //		LDA	>CGLPT7,X 
;// 02.10.30 //		AND	#000FFH
;// 02.10.30 //;///////		CLC
;// 02.10.30 //		ADC	#PLAYCG
;// 02.10.30 //		STA	<WORK0 
;// 02.10.30 //;
;// 02.10.30 //		IDX16
;// 02.10.30 //		REP	#00010000B	; index 16bit mode
;// 02.10.30 //;
;// 02.10.30 //		LDA	#00102H		;set point
;// 02.10.30 //		LDX	#00006H		;yoko kosu
;// 02.10.30 //		JSR	CHGSUB2 
;// 02.10.30 //;
;// 02.10.30 //		IDX8 
;// 02.10.30 //		SEP	#00010000B	; index 8bit mode
;// 02.10.30 //;
;// 02.10.30 //		LDX	PLYOJC1
;// 02.10.30 //		LDA	>CGLPT8,X 
;// 02.10.30 //		AND	#000FFH
;// 02.10.30 //		CLC
;// 02.10.30 //		ADC	#PLAYCG1
;// 02.10.30 //		STA	<WORK0 
;// 02.10.30 //;
;// 02.10.30 //		IDX16
;// 02.10.30 //		REP	#00010000B	; index 16bit mode
;// 02.10.30 //;
;// 02.10.30 //		LDA	#00110H		;set point
;// 02.10.30 //		LDX	#00007H		;yoko kosu
;// 02.10.30 //		JSR	CHGSUB2
;// 02.10.30 //;
;// 02.10.30 //		MEM8
;// 02.10.30 //		IDX8
;// 02.10.30 //		SEP	#00110000B	; memory,index 8bit mode
;// 02.10.30 //;
;// 02.10.30 //		LDX	!DJNNO
;// 02.10.30 //		LDA	>DJDTBL,X
;// 02.10.30 //		ORA	#00000001B
;// 02.10.30 //		STA	>DJDTBL,X	;
;
		MEM8
		SEP	#00100000B	; memory 8bit mode
;
		INC	<CGVMAF		; CG. write
		RTL
;
;
;************************************************************************
;*		Player water CG. reset			(PWTRCGS1)	*
;************************************************************************
PWTRCGS1	EQU	$
		STZ	<PLBGCKF	; player BG.2 check
PWTRCGS3	EQU	$
		STZ	!PCGCKF
		BRA	PWTRS00
;
;// 02.10.30 //		MEM16
;// 02.10.30 //		REP	#00100001B	; memory 16bit mode & CLC
;// 02.10.30 //;
;// 02.10.30 //		LDA	#00200H
;// 02.10.30 //		STA	!CGSTPT		; (CGWORK) set
;// 02.10.30 //;
;// 02.10.30 //		LDX	BOBOJC
;// 02.10.30 //		LDA	>CGLPT7,X 
;// 02.10.30 //		AND	#000FFH
;// 02.10.30 //;///////		CLC
;// 02.10.30 //		ADC	#DANJOBG
;// 02.10.30 //		STA	<WORK0 
;// 02.10.30 //;
;// 02.10.30 //		IDX16
;// 02.10.30 //		REP	#00010000B	; index 16bit mode
;// 02.10.30 //;
;// 02.10.30 //		LDA	#00102H
;// 02.10.30 //		LDX	#00006H
;// 02.10.30 //		JSR	CHGSUB2
;// 02.10.30 //;
;// 02.10.30 //		MEM8
;// 02.10.30 //		IDX8
;// 02.10.30 //		SEP	#00110000B	; memory,index 16bit mode
;// 02.10.30 //;
;// 02.10.30 //		STZ	<PLBGCKF	; player BG.2 check
;// 02.10.30 //;
;// 02.10.30 //		INC	<CGVMAF		; CG. write
;// 02.10.30 //		RTL
;
;
;
;************************************************************************
;*		BG. OBJ change character buffer set	(CHRCBS0)	*
;************************************************************************
CHRCBS0		EQU	$
		PHB
		PHK
		PLB			; (DBR) set
;
;// 03.05.31 //		LDA	#LOW CHCHBF
		STZ	<WORK0
		LDA	#HIGH CHCHBF
		STA	<WORK1
		LDA	#BANK CHCHBF
		STA	<WORK2
;
		MEM16
		IDX16
		REP	#00110000B	; memory,index 16bit mode
;
		LDA	!RBGCPT
		AND	#000FFH
		ASL	A
		ASL	A
		STA	<WORKE
;
		MEM8
		SEP	#00100000B	; memory 8bit mode
;
		LDX	<WORKE
		LDA	RBGCHDT+0,X
		BEQ	CHCB010		; character change ?
;					; yes
		STA	>CHCHTB+0
;
		SEP	#00010000B	; index 8bit mode
;
		TAY
		JSR	CADWS100	; char.data buffer set
CHCB010		EQU	$
		SEP	#00010000B	; index 8bit mode
;
		LDA	<WORK1
		CLC
		ADC	#006H
		STA	<WORK1
;
		REP	#00010000B	; index 16bit mode
;
		LDX	<WORKE
		LDA	RBGCHDT+1,X
		BEQ	CHCB020		; character change ?
;					; yes
		STA	>CHCHTB+1
;
		SEP	#00010000B	; index 8bit mode
;
		TAY
		JSR	CADWS100	; char.data buffer set
CHCB020		EQU	$
		SEP	#00010000B	; index 8bit mode
;
		LDA	<WORK1
		CLC
		ADC	#006H
		STA	<WORK1
;
		REP	#00010000B	; index 16bit mode
;
		LDX	<WORKE
		LDA	RBGCHDT+2,X
		BEQ	CHCB030		; character change ?
;					; yes
		STA	>CHCHTB+2
;
		SEP	#00010000B	; index 8bit mode
;
		TAY
		JSR	CADWS100	; char.data buffer set
CHCB030		EQU	$
		SEP	#00010000B	; index 8bit mode
;
		LDA	<WORK1
		CLC
		ADC	#006H
		STA	<WORK1
;
		REP	#00010000B	; index 16bit mode
;
		LDX	<WORKE
		LDA	RBGCHDT+3,X
		BEQ	CHCB040		; character change ?
;					; yes
		STA	>CHCHTB+3
;
		SEP	#00010000B	; index 8bit mode
;
		TAY
		JSR	CADWS100	; char.data buffer set
CHCB040		EQU	$
		SEP	#00010000B	; index 8bit mode
;
		LDA	<WORK1
		CLC
		ADC	#006H
		STA	<WORK1
;
		BRA	CHCB100
;
;
;
;************************************************************************
;*		OBJ change character buffer set		(CHRCBS1)	*
;************************************************************************
CHRCBS1		EQU	$
		PHB
		PHK
		PLB			; (DBR) set
;
;// 03.05.31 //		LDA	#LOW CHCHBF+600H*4
		STZ	<WORK0
		LDA	#HIGH CHCHBF+600H*4
		STA	<WORK1
		LDA	#BANK CHCHBF+600H*4
		STA	<WORK2
CHCB100		EQU	$
		MEM16
		IDX16
		REP	#00110000B	; memory,index 16bit mode
;
		LDA	!ROBJCPT
		AND	#000FFH
		ASL	A
		ASL	A
		STA	<WORKE
;
		MEM8
		SEP	#00100000B	; memory 8bit mode
;
		LDX	<WORKE
		LDA	ROBCHDT+0,X
		BEQ	CHCB110		; character change ?
;					; yes
		STA	>CHCHTB+4+0
CHCB110		EQU	$
		IDX8
		SEP	#00010000B	; index 8bit mode
;
		LDA	>CHCHTB+4+0
		TAY
		JSR	CADWS300	; char.data buffer set
		LDA	<WORK1
		CLC
		ADC	#006H
		STA	<WORK1
;
		IDX16
		REP	#00010000B	; index 16bit mode
;
		LDX	<WORKE
		LDA	ROBCHDT+1,X
		BEQ	CHCB120		; character change ?
;					; yes
		STA	>CHCHTB+4+1
CHCB120		EQU	$
		IDX8
		SEP	#00010000B	; index 8bit mode
;
		LDA	>CHCHTB+4+1
		TAY
		JSR	CADWS300	; char.data buffer set
		LDA	<WORK1
		CLC
		ADC	#006H
		STA	<WORK1
;
		IDX16
		REP	#00010000B	; index 16bit mode
;
		LDX	<WORKE
		LDA	ROBCHDT+2,X
		BEQ	CHCB130		; character change ?
;					; yes
		STA	>CHCHTB+4+2
CHCB130		EQU	$
		IDX8
		SEP	#00010000B	; index 8bit mode
;
		LDA	>CHCHTB+4+2
		TAY
		JSR	CADWS300	; char.data buffer set
		LDA	<WORK1
		CLC
		ADC	#006H
		STA	<WORK1
;
		IDX16
		REP	#00010000B	; index 16bit mode
;
		LDX	<WORKE
		LDA	ROBCHDT+3,X
		BEQ	CHCB140		; character change ?
;					; yes
		STA	>CHCHTB+4+3
CHCB140		EQU	$
		IDX8
		SEP	#00010000B	; index 8bit mode
;
		LDA	>CHCHTB+4+3
		TAY
		JSR	CADWS300	; char.data buffer set
;
		STZ	!CCHGPT
;///////		LDA	#008H
;///////		STA	!CCHGPT
		PLB			; (DBR) reset
		RTL
;
;
;
;************************************************************************
;*		Message picture buffer set		(MPICBST)	*
;************************************************************************
MPICBST		EQU	$
		PHB
		PHK
		PLB			; (DBR) set
;
;// 03.05.31 //		LDA	#LOW MPCHBF
		STZ	<WORK0
		LDA	#HIGH MPCHBF
		STA	<WORK1
		LDA	#BANK MPCHBF
		STA	<WORK2
		STA	<WORK5
;
		LDA	#C_4T
		STA	<WORKE
MPCB140		EQU	$
		LDY	<WORKE
		JSR	CADWS300	; char.data buffer set
MPCB180		EQU	$
		LDA	<WORK1
		CLC
		ADC	#008H
		STA	<WORK1
		INC	<WORKE
		LDA	<WORKE
		CMP	#C_4W
		BNE	MPCB140		; Message picture buffer set end ?
;					; yes
		PLB			; (DBR) reset
		RTL
;
;
;
;************************************************************************
;*		Warp Ground Basic character change	(WGBGCNG)	*
;************************************************************************
WGBGTBLL	EQU	$
		BYTE	LOW  WGBG000	; dammy
		BYTE	LOW  BGCBFS0	; BG. change - 0
		BYTE	LOW  BGCBFS01	;            - 1
		BYTE	LOW  BGCBFS1	;            - 2
		BYTE	LOW  BGCBFS11	;            - 3
		BYTE	LOW  WGBG100	; new BG. write
		BYTE	LOW  WGBG300	; new BG. write
		BYTE	LOW  WGBG150	; new BG. write
		BYTE	LOW  WGBG200	; new BG. write
		BYTE	LOW  WGBG300	; new BG. write
		BYTE	LOW  WGBG400	; change char.
		BYTE	LOW  BGCBFS2	; Obj. change - 0
		BYTE	LOW  BGCBFS21	;             - 1
		BYTE	LOW  BGCBFS22	;             - 2
		BYTE	LOW  WGBGRTS
;
WGBGTBLH	EQU	$
		BYTE	HIGH WGBG000
		BYTE	HIGH BGCBFS0
		BYTE	HIGH BGCBFS01
		BYTE	HIGH BGCBFS1
		BYTE	HIGH BGCBFS11
		BYTE	HIGH WGBG100
		BYTE	HIGH WGBG300
		BYTE	HIGH WGBG150
		BYTE	HIGH WGBG200
		BYTE	HIGH WGBG300
		BYTE	HIGH WGBG400
		BYTE	HIGH BGCBFS2
		BYTE	HIGH BGCBFS21
		BYTE	HIGH BGCBFS22
		BYTE	HIGH WGBGRTS
;
;
BGWTBL		EQU	$
		BYTE	0000,bgwE,bgwF,bgw10,bgw11,0000,0000,0000
		BYTE	0000,0000,0000,bgw12,bgw13,bgw14,0000
;
;
WGBGCNG		EQU	$
;// 03.05.31 //		LDA	#LOW MPCHBF
		STZ	<WORK0
		LDA	#HIGH MPCHBF
		STA	<WORK1
;
		LDX	!ITEMMD
		LDA	>BGWTBL,X
		STA	<BGWTFG
		STA	!GMAPDF
;
		LDA	>WGBGTBLL,X
		STA	<WORKE
		LDA	>WGBGTBLH,X
		STA	<WORKF
;
		LDX	#000H
		LDA	<MPDTNO
		AND	#01000000B
		BEQ	WGBG20		;
;					;
		LDX	#008H
WGBG20		EQU	$
		INC	!ITEMMD
		JMP	(WORKE)
;
;
WGBG000		EQU	$
		INC	!KGCHCT
		LDA	!KGCHCT
		CMP	#01CH+008H
		BEQ	WGBG040		; next go ?
;					; no
		STZ	!ITEMMD
WGBG040		EQU	$
		RTL
;
;
WGBG100		EQU	$
		JSL	>KGBG000
		DEC	<GAMEMD
		LDA	#bgwC
		STA	<BGWTFG
		STA	!GMAPDF
		RTL
;
;
WGBG150		EQU	$
		JSL	>KGBG100
		INC	!GMAPDF
		RTL
;
;
WGBG200		EQU	$
		JSL	>KGBG200	; new BG. set
;
		LDA	#bgwC
		STA	<BGWTFG
		STA	!GMAPDF
		RTL
;
;
WGBG300		EQU	$
		LDA	#bgwD
		STA	<BGWTFG
		STA	!GMAPDF
		RTL
;
;
WGBGRTS		EQU	$
		LDA	#00EH
		STA	!ITEMMD
		RTL
;
;
;
;---------------------	Change char.  -----------------------------------
WGBG400		EQU	$
;// 03.05.21 //		LDA	>BGCBDT0+7,X
;// 03.05.21 //		TAY
		LDY	#C_1Y0
		LDA	<MPDTNO
		AND	#10111111B
		CMP	#003H
		BEQ	WGBG440		; yama ?
;					; no
		CMP	#005H
		BEQ	WGBG440		; yama ?
;					; no
		CMP	#007H
		BEQ	WGBG440		; yama ?
;					; no
;// 03.05.17 //		CMP	#040H
;// 03.05.17 //		BCS	MPI2130		; ura ?
;// 03.05.17 //;					; no
		LDY	#C_1X0
WGBG440		EQU	$
		JSL	>WTRCBFST	; water char. buffer set
		RTL
;
;
;
;---------------------	BG. change - 0  ---------------------------------
BGCBDT0		EQU	$
		BYTE	C_1G0,C_1G1,C_1H0,C_1H1,C_1I0,C_1X1,C_2R1,C_1X0
		BYTE	C_1K0,C_1K1,C_1L0,C_1L1,C_1I1,C_1Y1,C_2W1,C_1X0
;
;
BGCBFS0		EQU	$
		PHB
		PHK
		PLB			; (DBR) set
;
		PHX			; (X) push
;
		MEM16
		IDX16
		REP	#00110000B	; memory,index 16bit mode
;
		LDA	!RBGCPT
		AND	#000FFH
		ASL	A
		ASL	A
		TAY
;
		MEM8
		SEP	#00100000B	; memory 8bit mode
;
BGCF10		EQU	$
		LDA	RBGCHDT+0,Y
		BEQ	BGCF11		; character change ?
;					; yes
		STA	>CHCHTB+0
BGCF11		EQU	$
		LDA	RBGCHDT+1,Y
		BEQ	BGCF12		; character change ?
;					; yes
		STA	>CHCHTB+1
BGCF12		EQU	$
		LDA	RBGCHDT+2,Y
		BEQ	BGCF13		; character change ?
;					; yes
		STA	>CHCHTB+2
BGCF13		EQU	$
		LDA	RBGCHDT+3,Y
		BEQ	BGCF14		; character change ?
;					; yes
		STA	>CHCHTB+3
BGCF14		EQU	$
		MEM16
		REP	#00100000B	; memory 16bit mode
;
		LDA	!ROBJCPT
		AND	#000FFH
		ASL	A
		ASL	A
		TAY
;
		MEM8
		SEP	#00100000B	; memory 8bit mode
BGCF20		EQU	$
		LDA	ROBCHDT+0,Y
		BEQ	BGCF21		; character change ?
;					; yes
		STA	>CHCHTB+4+0
BGCF21		EQU	$
		LDA	ROBCHDT+1,Y
		BEQ	BGCF22		; character change ?
;					; yes
		STA	>CHCHTB+4+1
BGCF22		EQU	$
		LDA	ROBCHDT+2,Y
		BEQ	BGCF23		; character change ?
;					; yes
		STA	>CHCHTB+4+2
BGCF23		EQU	$
		LDA	ROBCHDT+3,Y
		BEQ	BGCF24		; character change ?
;					; yes
		STA	>CHCHTB+4+3
BGCF24		EQU	$
		IDX8
		SEP	#00010000B	; index 8bit mode
;
		PLX			; (X) pull
;
		LDA	>BGCBDT0+1,X
		STA	<WORK8
		LDA	>BGCBDT0+0,X
		TAY
;
		LDA	#BANK MPCHBF
		JSR	CADWS040	; char.data buffer set
		LDA	<WORK1
		CLC
		ADC	#006H
		STA	<WORK1
;
		LDY	<WORK8
		JSR	CADWS100	; char.data buffer set
;
		PLB			; (DBR) reset
;
		LDA	#BANK MPCHBF
		STA	<WORK2
		STA	<WORK5
;
		MEM16
		IDX16
		REP	#00110001B	; memory,index 16bit mode & CLC
;
		LDX	#00000H
		LDY	#00010H*2*2
		LDA	#MPCHBF
		JSR	BCHC000		; character buffer set-0
		LDY	#00010H*2*2
		LDA	<WORK3
		JSR	BCHC100		; character buffer set-1
;
		MEM8
		IDX8
		SEP	#00110000B	; memory,index 8bit mode
		RTL
;
;
;---------------------	BG. change - 1  ---------------------------------
BGCBFS01	EQU	$
		PHB
		PHK
		PLB			; (DBR) set
;
		LDA	>BGCBDT0+3,X
		STA	<WORK8
		LDA	>BGCBDT0+2,X
		TAY
;
		LDA	#BANK MPCHBF
		JSR	CADWS040	; char.data buffer set
		LDA	<WORK1
		CLC
		ADC	#006H
		STA	<WORK1
;
		LDY	<WORK8
		JSR	CADWS100	; char.data buffer set
;
		PLB			; (DBR) reset
;
		LDA	#BANK MPCHBF
		STA	<WORK2
		STA	<WORK5
;
		MEM16
		IDX16
		REP	#00110001B	; memory,index 16bit mode & CLC
;
		LDX	#00000H
		LDY	#00010H*2*2
		LDA	#MPCHBF
		JSR	BCHC100		; character buffer set-1
		LDY	#00010H*2*2
		LDA	<WORK3
		JSR	BCHC000		; character buffer set-0
;
		MEM8
		IDX8
		SEP	#00110000B	; memory,index 8bit mode
		RTL
;
;
;---------------------	BG. change - 2  ---------------------------------
BGCBFS1		EQU	$
		PHB
		PHK
		PLB			; (DBR) set
;
		LDA	>CHCHTB+1
		TAY
		LDA	#BANK MPCHBF
		JSR	CADWS040	; char.data buffer set
		LDA	<WORK1
		CLC
		ADC	#006H
		STA	<WORK1
;
		LDA	>CHCHTB+2
		TAY
		JSR	CADWS100	; char.data buffer set
;
		PLB			; (DBR) reset
;
		LDA	#BANK MPCHBF
		STA	<WORK2
		STA	<WORK5
;
		MEM16
		IDX16
		REP	#00110001B	; memory,index 16bit mode & CLC
;
		LDX	#00000H
		LDY	#00010H*2*4
		LDA	#MPCHBF
		JSR	BCHC000		; character buffer set-1
;
		MEM8
		IDX8
		SEP	#00110000B	; memory,index 8bit mode
		RTL
;
;
;---------------------	BG. change - 3  ---------------------------------
BGCBFS11	EQU	$
		PHB
		PHK
		PLB			; (DBR) set
;
		LDA	>BGCBDT0+5,X
		STA	<WORK8
		LDA	>BGCBDT0+4,X
		TAY
;
		LDA	#BANK MPCHBF
		JSR	CADWS040	; char.data buffer set
		LDA	<WORK1
		CLC
		ADC	#006H
		STA	<WORK1
;
		LDY	<WORK8
		JSR	CADWS100	; char.data buffer set
;
		PLB			; (DBR) reset
;
		LDA	#BANK MPCHBF
		STA	<WORK2
		STA	<WORK5
;
		MEM16
		IDX16
		REP	#00110001B	; memory,index 16bit mode & CLC
;
		LDX	#00000H
		LDY	#00010H*2*4
		LDA	#MPCHBF
		JSR	BCHC100		; character buffer set-1
;
		MEM8
		IDX8
		SEP	#00110000B	; memory,index 8bit mode
		RTL
;
;
;---------------------	OBJ change - 0  ---------------------------------
BGCBFS2		EQU	$
		PHB
		PHK
		PLB			; (DBR0 set
;
		LDA	>BGCBDT0+6,X
		TAY
		LDA	OCADL,Y
		STA	<WORK0
		LDA	OCADH,Y
		STA	<WORK1
		LDA	OCADB,Y
		STA	<WORK2
		STA	<WORK5
;
		PLB			; (DBR) reset
;
		MEM16
		IDX16
		REP	#00110001B	; memory,index 16bit mode & CLC
;
		LDX	#00000H
		LDY	#00010H*2*2
		LDA	<WORK0
		JSR	BCHC000		; character buffer set-0
;
		MEM8
		IDX8
		SEP	#00110000B	; memory,index 8bit mode
		RTL
;
;
;---------------------	OBJ change - 1  ---------------------------------
BGCBFS21	EQU	$
		PHB
		PHK
		PLB			; (DBR) set
;
		LDA	>CHCHTB+4
		TAY
		LDA	#BANK MPCHBF
		STA	<WORK2
		STA	<WORK5
		JSR	CADWS300	; char.data buffer set
		LDA	<WORK1
		CLC
		ADC	#006H
		STA	<WORK1
;
		LDA	>CHCHTB+5
		TAY
		JSR	CADWS300	; char.data buffer set
;
		PLB			; (DBR) reset
;
		LDA	#BANK MPCHBF
		STA	<WORK2
		STA	<WORK5
;
		MEM16
		IDX16
		REP	#00110001B	; memory,index 16bit mode & CLC
;
		LDX	#00000H
		LDY	#00010H*2*2
		LDA	>CHCHTB+4
		CMP	#C_4I0
		BEQ	BGCF2120	; 8~F color ?
;					; no
		CMP	#C_4I1
		BEQ	BGCF2120	; 8~F color ?
;					; no
		CMP	#C_4M0
		BEQ	BGCF2120	; 8~F color ?
;					; no
		CMP	#C_4M1
		BNE	BGCF2140	; 8~F color ?
;					; yes
BGCF2120	EQU	$
		LDA	#MPCHBF
		JSR	BCHC000		; character buffer set-0
		BRA	BGCF2160
;
BGCF2140	EQU	$
		LDA	#MPCHBF
		JSR	BCHC100		; character buffer set-1
BGCF2160	EQU	$
		LDY	#00010H*2*2
		LDA	<WORK3
		JSR	BCHC100		; character buffer set-1
;
		MEM8
		IDX8
		SEP	#00110000B	; memory,index 8bit mode
		RTL
;
;
;---------------------	OBJ change - 2  ---------------------------------
BGCBFS22	EQU	$
		PHB
		PHK
		PLB			; (DBR) set
;
		LDA	>CHCHTB+6
		TAY
		LDA	#BANK MPCHBF
		STA	<WORK2
		STA	<WORK5
		JSR	CADWS300	; char.data buffer set
		LDA	<WORK1
		CLC
		ADC	#006H
		STA	<WORK1
;
		LDA	>CHCHTB+7
		TAY
		JSR	CADWS300	; char.data buffer set
;
		PLB			; (DBR) reset
;
		LDA	#BANK MPCHBF
		STA	<WORK2
		STA	<WORK5
;
		MEM16
		IDX16
		REP	#00110001B	; memory,index 16bit mode & CLC
;
		LDX	#00000H
		LDY	#00010H*2*4
		LDA	#MPCHBF
		JSR	BCHC100		; character buffer set-1
;
		MEM8
		IDX8
		SEP	#00110000B	; memory,index 8bit mode
;
		JSL	>RABHEN		; rabit change check
		RTL
;
;
;
;
;
;************************************************************************
;*		Danjyon change color data				*
;************************************************************************
DJNCGDT		EQU	$		; danjyon basic color data
;			 dj  kk bo  e1  e2
		BYTE	00*2,00,00,03H,01H,00,00,00	; 0 : normal shiro
		BYTE	01*2,00,00,03H,01H,00,00,00	; 1 : shiro chika , normal chapel
		BYTE	02*2,00,00,0AH,01H,00,00,00	; 2 : normal minka
		BYTE	03*2,00,00,06H,01H,00,00,00	; 3 : shinden (boss)
		BYTE	03*2,00,02,02H,07H,00,00,00	; 4 : sabaku-shinden (boss)
		BYTE	05*2,00,00,03H,0AH,00,00,00	; 5 : kusuri-baba mise
		BYTE	06*2,00,00,03H,01H,00,00,00	; 6 : yama no tou
		BYTE	07*2,00,00,03H,0AH,00,00,00	; 7 : doukutsu
		BYTE	08*2,00,00,14H,0EH,00,00,00	; 8 : hokora
		BYTE	05*2,00,02,00H,07H,00,00,00	; 9 : sabaku-shinden
		BYTE	01*2,00,00,0FH,11H,00,00,00	; A : ura-hokora-mizu
		BYTE	03*2,00,00,06H,07H,00,00,00	; B : shinden
		BYTE	00*2,01,00,0EH,01H,00,00,00	; C : shisai-room
		BYTE	09*2,00,00,0EH,0BH,00,00,00	; D : ura-mori danjyon
		BYTE	09*2,00,00,02H,0CH,00,00,00	; E :                  (boss)
		BYTE	08*2,00,00,0AH,05H,00,00,00	; F : ura-shinden
		BYTE	08*2,00,00,02H,07H,00,00,00	;10 : ura-shinden(boss)
		BYTE	11*2,01,00,0EH,01H,00,00,00	;11 : ura-numa danjyon
		BYTE	11*2,01,00,0EH,01H,00,00,00	;12 :                  (boss)
		BYTE	04*2,00,00,04H,14H,00,00,00	;13 : ura-ice danjyon
		BYTE	04*2,00,00,0EH,01H,00,00,00	;14 :                 (boss)
		BYTE	02*2,00,00,03H,01H,00,00,00	;15 : link-house
		BYTE	10*2,00,00,03H,01H,00,00,00	;16 : ura-machi
		BYTE	10*2,00,00,14H,0CH,00,00,00	;17 :           (boss)
		BYTE	12*2,00,00,03H,01H,00,00,00	;18 : ura-kame-iwa
		BYTE	12*2,00,00,03H,01H,00,00,00	;19 :              (boss)
		BYTE	13*2,00,00,03H,01H,00,00,00	;1A : ura-tower
		BYTE	13*2,00,00,03H,01H,00,00,00	;1B :           (boss)
		BYTE	03*2,00,00,03H,0AH,00,00,00	;1B : shinden-yoko ojiji
;
;
;
;************************************************************************
;*		BG. OBJ character change		(CHRCHNG)	*
;************************************************************************
ROBCHDT		EQU	$		; reset OBJ. char. data
		BYTE	00000,C_4D1,00000,00000	; 00 : ground
		BYTE	C_4C0,C_4D1,C_3A1,C_4N1	;  1 
		BYTE	C_4D0,C_4D1,C_3A1,C_4N1	;  2 
		BYTE	C_4C0,C_4D1,C_3A1,C_2Y0	;  3 
		BYTE	C_4D0,C_4D1,C_2X0,C_2Z1	;  4
		BYTE	C_4D0,C_4D1,C_2X0,C_2Z0	;  5
		BYTE	C_4G1,C_4D1,C_4E0,C_4H0	;  6
		BYTE	C_4D0,C_4D1,C_4E0,C_2Z1	;  7
		BYTE	C_4C0,C_4D1,C_3A0,C_2Z1	;  8
		BYTE	00000,C_4D1,00000,C_4F1	;  9
		BYTE	00000,C_4D1,00000,C_2Z1	;  A
		BYTE	C_4D0,C_4D1,C_2X0,00000	;  B
		BYTE	00000,00000,00000,C_3S0	;  C
		BYTE	C_4D0,C_4D1,C_4F0,C_2Z1	;  D
		BYTE	00000,C_3N0,C_2X0,C_4B0	;  E
		BYTE	C_4D0,C_4D1,C_4G0,C_2Z1	;  F
;
		BYTE	00000,00000,00000,00000	; 10 : ground
		BYTE	00000,00000,00000,00000	;  1 
		BYTE	00000,00000,00000,00000	;  2 
		BYTE	00000,00000,00000,00000	;  3 
		BYTE	00000,00000,00000,00000	;  4
		BYTE	00000,00000,00000,00000	;  5
		BYTE	00000,00000,00000,00000	;  6
		BYTE	00000,00000,00000,00000	;  7
		BYTE	00000,00000,00000,00000	;  8
		BYTE	00000,00000,00000,00000	;  9
		BYTE	00000,00000,00000,00000	;  A
		BYTE	00000,00000,00000,00000	;  B
		BYTE	00000,00000,00000,00000	;  C
		BYTE	00000,00000,00000,00000	;  D
		BYTE	00000,00000,00000,00000	;  E
		BYTE	00000,00000,00000,00000	;  F
;
		BYTE	00000,00000,00000,00000	; 20 : ground
		BYTE	00000,00000,00000,00000	;  1 
		BYTE	00000,00000,00000,00000	;  2 
		BYTE	00000,00000,00000,00000	;  3 
		BYTE	00000,00000,00000,00000	;  4
		BYTE	00000,00000,00000,00000	;  5
		BYTE	00000,00000,00000,00000	;  6
		BYTE	00000,00000,00000,00000	;  7
		BYTE	00000,00000,00000,00000	;  8
		BYTE	00000,00000,00000,00000	;  9
		BYTE	00000,00000,00000,00000	;  A
		BYTE	00000,00000,00000,00000	;  B
		BYTE	00000,00000,00000,00000	;  C
		BYTE	00000,00000,00000,00000	;  D
		BYTE	00000,00000,00000,00000	;  E
		BYTE	00000,00000,00000,00000	;  F
;
		BYTE	00000,00000,00000,00000	; 30 : ground
		BYTE	00000,00000,00000,00000	;  1 
		BYTE	00000,00000,00000,00000	;  2 
		BYTE	00000,00000,00000,00000	;  3 
		BYTE	00000,00000,00000,00000	;  4
		BYTE	00000,00000,00000,00000	;  5
		BYTE	00000,00000,00000,00000	;  6
		BYTE	00000,00000,00000,00000	;  7
		BYTE	00000,00000,00000,00000	;  8
		BYTE	00000,00000,00000,00000	;  9
		BYTE	00000,00000,00000,00000	;  A
		BYTE	00000,00000,00000,00000	;  B
		BYTE	00000,00000,00000,00000	;  C
		BYTE	00000,00000,00000,00000	;  D
		BYTE	00000,00000,00000,00000	;  E
		BYTE	00000,00000,00000,00000	;  F
;
		BYTE	C_4C1,C_4D1,C_3M1,C_3N1	; 40 : danjyon
		BYTE	C_4C0,C_4D1,C_3F0,C_4I0	;  1 
		BYTE	00000,C_4D1,C_3F0,C_4I0	;  2 
		BYTE	C_4N1,C_4D1,00000,C_4I0	;  3 
		BYTE	C_4C0,C_4D1,C_3A1,C_4I0	;  4 
		BYTE	C_4E1,C_4D1,C_4E0,C_4M0	;  5
;;		BYTE	C_4C1,C_4D1,C_3V1,C_4I0	;  6  TEST Morita !
		BYTE	C_4C1,C_4D1,C_3M1,C_4I0	;  6
		BYTE	00000,00000,00000,C_3S0	;  7
		BYTE	C_3O0,C_3N0,C_3M0,C_4I0	;  8
		BYTE	C_3O0,C_3N0,C_3M0,C_3F1	;  9
		BYTE	C_3O1,C_3N0,C_3A0,C_2Z1	;  A
		BYTE	C_3O1,C_3N0,C_3A0,C_3P1	;  B
		BYTE	C_3P0,C_3N0,00000,00000	;  C
		BYTE	C_4H1,C_4D1,C_3A1,00000	;  D
		BYTE	C_4G1,C_4D1,C_3A1,C_4H0	;  E
		BYTE	C_4G1,C_4D1,C_4E0,C_4H0	;  F
;
		BYTE	00000,C_4D1,C_4F0,00000	; 50 : danjyon
		BYTE	C_3G1,C_3G0,C_3I0,C_4I1	;  1 
		BYTE	00000,C_4D1,C_4A0,C_4A1	;  2 
		BYTE	C_3G1,C_3G0,C_3I1,C_4I0	;  3 
		BYTE	C_3G1,C_3G0,C_3V1,C_3W0	;  4
		BYTE	C_3G1,C_3G0,C_3W1,C_4I0	;  5
		BYTE	C_3G1,C_3G0,C_3X0,C_3X1	;  6
		BYTE	C_3G1,C_3G0,C_3Y0,C_3Y1	;  7
		BYTE	C_3G1,C_3G0,C_3Z0,C_3Z1	;  8
		BYTE	C_3G1,C_3G0,C_3M0,C_4I0	;  9
		BYTE	C_3G1,C_3H0,C_3V0,C_4I0	;  A
		BYTE	C_3G1,C_3G0,C_3J1,00000	;  B
		BYTE	C_3G1,C_3G0,C_3K0,00000	;  C
		BYTE	C_3G1,C_3G0,C_3K1,00000	;  D
		BYTE	C_3G1,C_3G0,C_3L0,00000	;  E
		BYTE	C_3G1,C_3G0,C_3L1,00000	;  F
;
		BYTE	00000,00000,00000,00000	; 60 : danjyon
		BYTE	00000,00000,00000,00000	;  1 
		BYTE	00000,00000,00000,00000	;  2 
		BYTE	00000,00000,00000,00000	;  3 
		BYTE	00000,00000,00000,00000	;  4
		BYTE	00000,00000,00000,00000	;  5
		BYTE	00000,00000,00000,00000	;  6
		BYTE	00000,00000,00000,00000	;  7
		BYTE	00000,00000,00000,00000	;  8
		BYTE	00000,00000,00000,00000	;  9
		BYTE	00000,00000,00000,00000	;  A
		BYTE	00000,00000,00000,00000	;  B
		BYTE	00000,00000,00000,00000	;  C
		BYTE	00000,00000,00000,00000	;  D
		BYTE	00000,00000,00000,00000	;  E
		BYTE	00000,00000,00000,00000	;  F
;
		BYTE	00000,00000,00000,00000	; 70 : danjyon
		BYTE	00000,00000,00000,00000	;  1 
		BYTE	00000,00000,00000,00000	;  2 
		BYTE	00000,00000,00000,00000	;  3 
		BYTE	00000,00000,00000,00000	;  4
		BYTE	00000,00000,00000,00000	;  5
		BYTE	00000,00000,00000,00000	;  6
		BYTE	00000,00000,00000,00000	;  7
		BYTE	00000,00000,00000,00000	;  8
		BYTE	00000,00000,00000,00000	;  9
		BYTE	00000,00000,00000,00000	;  A
		BYTE	00000,00000,00000,00000	;  B
		BYTE	00000,00000,00000,00000	;  C
		BYTE	00000,00000,00000,00000	;  D
		BYTE	00000,00000,00000,00000	;  E
		BYTE	00000,00000,00000,00000	;  F
;
		BYTE	C_4Q0,C_4Q1,C_4R2,C_4H0	; 80 select map
;
;
RBGCHDT		EQU	$		;       BG.
;						; Danjyon
		BYTE	C_0D0,00000,C_0S0,C_0N0	; 00 shiro
		BYTE	C_0E0,00000,C_0T1,C_0O1	;  1         under
		BYTE	C_0D0,00000,C_0S0,C_0N0	;  2 shisai-room
		BYTE	C_0D1,00000,C_0U0,C_0P0	;  3 minka
		BYTE	C_0D1,00000,C_0U0,C_0P0	;  4 chapel
		BYTE	C_0E1,00000,C_0S1,C_0N1	;  5 shinden , sabaku
		BYTE	C_0F1,00000,C_0T0,C_0O0	;  6 doukutsu
		BYTE	C_0E1,00000,C_0U1,C_0P1	;  7 ura-danjyon (shinden)
		BYTE	C_0E0,00000,C_0T1,C_0O1	;  8 ura-danjyon (mizu hiki)
		BYTE	C_0E1,00000,C_0V0,C_0Q0	;  9 ura-danjyon (mori-shita)
		BYTE	C_0E1,00000,C_0V1,C_0Q1	;  A ura-danjyon (machi-shita)
		BYTE	C_0F0,00000,C_0W0,C_0R0	;  B ura-danjyon (ice tower)
		BYTE	C_0E1,00000,C_0W1,C_0R1	;  C ura-danjyon (numa)
		BYTE	C_0G0,00000,C_0X0,C_0M0	;  D ura-danjyon (kame-iwa)
		BYTE	C_0G1,00000,C_0X1,C_0M1	;  E ura-danjyon (tower)
		BYTE	C_4R1,00000,C_0Y0,C_1Y1	;  F
;
		BYTE	00000,00000,00000,00000	; 10 : ground
		BYTE	00000,C_1V1,C_1Q0,00000	;  1
		BYTE	00000,C_1V0,C_1R1,00000	;  2
		BYTE	00000,C_1T1,C_1Q1,00000	;  3
		BYTE	00000,C_1T0,C_1O1,00000	;  4
		BYTE	00000,C_1U1,C_1P0,00000	;  5
		BYTE	00000,C_1T1,C_1U0,00000	;  6
		BYTE	00000,C_1S1,C_1R0,00000	;  7
		BYTE	00000,00000,C_1O0,00000	;  8
		BYTE	00000,C_1S0,C_1P1,00000	;  9
		BYTE	00000,C_1T1,00000,00000	;  A
		BYTE	00000,00000,00000,00000	;  B
		BYTE	00000,00000,00000,00000	;  C
		BYTE	00000,00000,00000,00000	;  D
		BYTE	00000,00000,00000,00000	;  E
		BYTE	00000,C_1N0,C_1N1,00000	;  F
;
		BYTE	00000,00000,00000,00000	; 20 : ground (URA)
		BYTE	00000,C_1V1,C_1Q0,00000	;  1
		BYTE	00000,C_1V0,C_1R1,00000	;  2
		BYTE	00000,C_1T1,C_1Q1,00000	;  3
		BYTE	00000,C_1T0,C_1O1,00000	;  4
		BYTE	00000,C_1U1,C_1P0,00000	;  5
		BYTE	00000,C_1T1,C_1U0,00000	;  6
		BYTE	00000,C_1S1,C_1R0,00000	;  7
		BYTE	00000,00000,C_1O0,00000	;  8
		BYTE	00000,C_1S0,C_1P1,00000	;  9
		BYTE	00000,C_1T1,00000,00000	;  A
		BYTE	00000,C_1D0,C_1D1,00000	;  B
		BYTE	00000,C_2A0,C_2A1,00000	;  C
		BYTE	00000,C_0Y0,C_0Y1,00000	;  D
		BYTE	00000,C_0Z0,C_0Z1,00000	;  E
		BYTE	00000,C_1A0,C_1A1,00000	;  F
;
		BYTE	00000,C_1E0,C_1E1,00000	; 30 : ground (URA)
		BYTE	00000,C_1C0,C_1C1,00000	;  1
		BYTE	00000,C_1B0,C_1B1,00000	;  2
		BYTE	00000,00000,00000,00000	;  3
		BYTE	00000,00000,00000,00000	;  4
		BYTE	00000,00000,00000,00000	;  5
		BYTE	00000,00000,00000,00000	;  6
		BYTE	00000,00000,00000,00000	;  7
		BYTE	00000,00000,00000,00000	;  8
		BYTE	00000,00000,00000,00000	;  9
		BYTE	00000,00000,00000,00000	;  A
		BYTE	00000,00000,00000,00000	;  B
		BYTE	00000,00000,00000,00000	;  C
		BYTE	00000,00000,00000,00000	;  D
		BYTE	00000,00000,00000,00000	;  E
		BYTE	00000,00000,00000,00000	;  F
;
		BYTE	C_4R1,C_4R0,C_4R1,C_4R0	; 40 MAP
;
;
;
;;;;;;;;CRCHTBLL	EQU	$		; table(L)
;;;;;;;;		BYTE	LOW CHRCHG2	; Bg. - 0 : 0
;;;;;;;;		BYTE	LOW CHRCHG2	;     - 0 : 1
;;;;;;;;		BYTE	LOW CHRCHG3	;     - 1 : 2
;;;;;;;;		BYTE	LOW CHRCHG3	;     - 1 : 3
;;;;;;;;		BYTE	LOW CHRCHG3	;     - 2 : 4
;;;;;;;;		BYTE	LOW CHRCHG3	;     - 2 : 5
;;;;;;;;		BYTE	LOW CHRCHG4	;     - 3 : 6
;;;;;;;;		BYTE	LOW CHRCHG4	;     - 3 : 7
;;;;;;;;		BYTE	LOW CHRCHG0	; Obj - 0 : 8
;;;;;;;;		BYTE	LOW CHRCHG0	;     - 0 : 9
;;;;;;;;		BYTE	LOW CHRCHG1	;     - 1 : A
;;;;;;;;		BYTE	LOW CHRCHG1	;     - 1 : B
;;;;;;;;		BYTE	LOW CHRCHG1	;     - 2 : C
;;;;;;;;		BYTE	LOW CHRCHG1	;     - 2 : D
;;;;;;;;		BYTE	LOW CHRCHG1	;     - 3 : E
;;;;;;;;		BYTE	LOW CHRCHG1	;     - 3 : F
;;;;;;;;		BYTE	LOW CHRCHG9	; Rts     :10
;;;;;;;;;
;;;;;;;;CRCHTBLH	EQU	$		; table(H)
;;;;;;;;		BYTE	HIGH CHRCHG2
;;;;;;;;		BYTE	HIGH CHRCHG2
;;;;;;;;		BYTE	HIGH CHRCHG3
;;;;;;;;		BYTE	HIGH CHRCHG3
;;;;;;;;		BYTE	HIGH CHRCHG3
;;;;;;;;		BYTE	HIGH CHRCHG3
;;;;;;;;		BYTE	HIGH CHRCHG4
;;;;;;;;		BYTE	HIGH CHRCHG4
;;;;;;;;		BYTE	HIGH CHRCHG0
;;;;;;;;		BYTE	HIGH CHRCHG0
;;;;;;;;		BYTE	HIGH CHRCHG1
;;;;;;;;		BYTE	HIGH CHRCHG1
;;;;;;;;		BYTE	HIGH CHRCHG1
;;;;;;;;		BYTE	HIGH CHRCHG1
;;;;;;;;		BYTE	HIGH CHRCHG1
;;;;;;;;		BYTE	HIGH CHRCHG1
;;;;;;;;		BYTE	HIGH CHRCHG9
;;;;;;;;;
;;;;;;;;VMAADRD		EQU	$
;;;;;;;;		BYTE	02CH,02EH,030H,032H
;;;;;;;;		BYTE	034H,036H,038H,03AH
;;;;;;;;		BYTE	050H,052H,054H,056H
;;;;;;;;		BYTE	058H,05AH,05CH,05EH
;;;;;;;;;
;;;;;;;;DTADDDT		EQU	$
;;;;;;;;		BYTE	000H,003H,000H,003H
;;;;;;;;		BYTE	000H,003H,000H,003H
;;;;;;;;		BYTE	000H,003H,000H,003H
;;;;;;;;		BYTE	000H,003H,000H,003H
;;;;;;;;;
;;;;;;;;BFWKDT		EQU	$
;;;;;;;;		BYTE	HIGH CHCHBF+600H*0,HIGH CHCHBF+600H*0,HIGH CHCHBF+600H*1,HIGH CHCHBF+600H*1
;;;;;;;;		BYTE	HIGH CHCHBF+600H*2,HIGH CHCHBF+600H*2,HIGH CHCHBF+600H*3,HIGH CHCHBF+600H*3
;;;;;;;;		BYTE	HIGH CHCHBF+600H*4,HIGH CHCHBF+600H*4,HIGH CHCHBF+600H*5,HIGH CHCHBF+600H*5
;;;;;;;;		BYTE	HIGH CHCHBF+600H*6,HIGH CHCHBF+600H*6,HIGH CHCHBF+600H*7,HIGH CHCHBF+600H*7
;;;;;;;;;
;;;;;;;;;
;
VMAADRD		EQU	$
		BYTE	050H,051H,052H,053H,054H,055H,056H,057H
		BYTE	058H,059H,05AH,05BH,05CH,05DH,05EH,05FH
;
BFWKDT		EQU	$
		BYTE	HIGH RSETCBF+0000H,HIGH RSETCBF+0200H
		BYTE	HIGH RSETCBF+0400H,HIGH RSETCBF+0600H
		BYTE	HIGH RSETCBF+0800H,HIGH RSETCBF+0A00H
		BYTE	HIGH RSETCBF+0C00H,HIGH RSETCBF+0E00H
		BYTE	HIGH RSETCBF+1000H,HIGH RSETCBF+1200H
		BYTE	HIGH RSETCBF+1400H,HIGH RSETCBF+1600H
		BYTE	HIGH RSETCBF+1800H,HIGH RSETCBF+1A00H
		BYTE	HIGH RSETCBF+1C00H,HIGH RSETCBF+1E00H
;
;
CHRCHNG		EQU	$
		LDX	!CCHGPT
		CPX	#010H
		BEQ	CHRCN90		; character write ?
;					; yes
		LDA	>VMAADRD,X
		STA	<OBCCFG
		STZ	!CHADRF
		LDA	>BFWKDT,X
		STA	!CHADRF+1
;
		INC	!CCHGPT
CHRCN90		EQU	$
		RTL
;
;
;;;;;;;;		PHB
;;;;;;;;		PHK
;;;;;;;;		PLB			; (DBR) set
;;;;;;;;;
;;;;;;;;		LDA	!ROBJCPT
;;;;;;;;		ASL	A
;;;;;;;;		ASL	A
;;;;;;;;		STA	<WORKE
;;;;;;;;		LDA	!RBGCPT
;;;;;;;;		ASL	A
;;;;;;;;		ASL	A
;;;;;;;;		STA	<WORKF
;;;;;;;;;
;;;;;;;;		LDX	!CCHGPT
;;;;;;;;		LDA	#LOW CHCHBF
;;;;;;;;		STA	<WORK0
;;;;;;;;		LDA	BFWKDT,X
;;;;;;;;		STA	<WORK1
;;;;;;;;		LDA	#BANK CHCHBF
;;;;;;;;		STA	<WORK2
;;;;;;;;		STA	<WORK5
;;;;;;;;;
;;;;;;;;		LDA	CRCHTBLL,X
;;;;;;;;		STA	<WORK6
;;;;;;;;		LDA	CRCHTBLH,X
;;;;;;;;		STA	<WORK7
;;;;;;;;;
;;;;;;;;		LDA	DTADDDT,X
;;;;;;;;		STA	<WORK9
;;;;;;;;		LDA	DTADDD1,X	
;;;;;;;;		STA	<WORK8		; (work8,9) <-- point add. data
;;;;;;;;;
;;;;;;;;		LDA	VMAADRD,X	; (A) <-- VMA address
;;;;;;;;		JMP	(!WORK6)
;;;;;;;;;
;;;;;;;;;
;;;;;;;;;
;;;;;;;;CHRCHG0		EQU	$
;;;;;;;;		STA	<OBCCFG		; OBJ. BG. character change flag on
;;;;;;;;		INC	!CCHGPT
;;;;;;;;		LDA	>CHCHTB,X
;;;;;;;;		CMP	#C_4I0
;;;;;;;;		BEQ	CRCH010		; 8~F color ?
;;;;;;;;;					; no
;;;;;;;;		CMP	#C_4I1
;;;;;;;;		BEQ	CRCH010		; 8~F color ?
;;;;;;;;;					; no
;;;;;;;;		CMP	#C_4M0
;;;;;;;;		BEQ	CRCH010		; 8~F color ?
;;;;;;;;;					; no
;;;;;;;;		CMP	#C_4M1
;;;;;;;;		BEQ	CRCH010		; 8~F color ?
;;;;;;;;;					; no
;;;;;;;;		BRA	CRCH110
;;;;;;;;;
;;;;;;;;;
;;;;;;;;CHRCHG3		EQU	$
;;;;;;;;		LDY	!RBGCPT
;;;;;;;;		CPY	#010H
;;;;;;;;		BCC	CHRCHG1		; danjyon ?
;;;;;;;;;					; no
;;;;;;;;CHRCHG2		EQU	$		;// 02.11.13 //
;;;;;;;;		INC	!CCHGPT
;;;;;;;;CRCH000		EQU	$
;;;;;;;;		STA	<OBCCFG		; OBJ. BG. character change flag on
;;;;;;;;CRCH010		EQU	$
;;;;;;;;		MEM16
;;;;;;;;		IDX16
;;;;;;;;		REP	#00110001B	; memory,index 16bit mode & CLC
;;;;;;;;;
;;;;;;;;		LDA	<WORK0
;;;;;;;;		ADC	<WORK8
;;;;;;;;		LDY	#00010H*1
;;;;;;;;		STY	<WORKC
;;;;;;;;		LDX	#00000H
;;;;;;;;CRCH020		EQU	$
;;;;;;;;		STA	<WORK0
;;;;;;;;		CLC
;;;;;;;;		ADC	#00010H
;;;;;;;;		STA	<WORK3
;;;;;;;;;
;;;;;;;;		LDY	#00007H
;;;;;;;;CRCH040 	EQU	$
;;;;;;;;		LDA	[<WORK0]
;;;;;;;;		STA	!VRAMD+2,X
;;;;;;;;		XBA
;;;;;;;;		ORA	[<WORK0]
;;;;;;;;		AND	#000FFH
;;;;;;;;		STA	<WORK8
;;;;;;;;		INC	<WORK0
;;;;;;;;		INC	<WORK0
;;;;;;;;;
;;;;;;;;		LDA	[<WORK3]
;;;;;;;;		AND	#000FFH
;;;;;;;;		STA	<WORKA
;;;;;;;;		ORA	<WORK8
;;;;;;;;		XBA
;;;;;;;;		ORA	<WORKA
;;;;;;;;		STA	!VRAMD+2+010H,X
;;;;;;;;		INC	<WORK3
;;;;;;;;		INX
;;;;;;;;		INX
;;;;;;;;		DEY
;;;;;;;;		BPL	CRCH040		; 1char. end ?
;;;;;;;;;					; yes
;;;;;;;;		TXA
;;;;;;;;		CLC
;;;;;;;;		ADC	#00010H
;;;;;;;;		TAX
;;;;;;;;		LDA	<WORK3
;;;;;;;;		DEC	<WORKC
;;;;;;;;		BNE	CRCH020		; end ?
;;;;;;;;;					; yes
;;;;;;;;		MEM8
;;;;;;;;		IDX8
;;;;;;;;		SEP	#00110000B	; memory,index 8bit mode
;;;;;;;;CHRCHG9		EQU	$
;;;;;;;;		PLB			; (DBR) reset
;;;;;;;;		RTL
;;;;;;;;;
;;;;;;;;;
;;;;;;;;;
;;;;;;;;;// 02.11.13 //CHRCHG2		EQU	$
;;;;;;;;;// 02.11.13 //		LDY	!RBGCPT
;;;;;;;;;// 02.11.13 //		CPY	#010H
;;;;;;;;;// 02.11.13 //		BCC	CHRCHG0		; danjyon ?
;;;;;;;;;// 02.11.13 //;					; yes
;;;;;;;;;;;;;;;;CHRCHG4		EQU	$
;;;;;;;;CHRCHG1		EQU	$
;;;;;;;;		INC	!CCHGPT
;;;;;;;;CRCH100		EQU	$
;;;;;;;;		STA	<OBCCFG		; OBJ. BG. character change flag on
;;;;;;;;CRCH110		EQU	$
;;;;;;;;		MEM16
;;;;;;;;		IDX16
;;;;;;;;		REP	#00110001B	; memory,index 16bit mode & CLC
;;;;;;;;;
;;;;;;;;		LDA	<WORK0
;;;;;;;;		ADC	<WORK8
;;;;;;;;		LDY	#00010H*1
;;;;;;;;		STY	<WORKC
;;;;;;;;		LDX	#00000H
;;;;;;;;CRCH120		EQU	$
;;;;;;;;		STA	<WORK0
;;;;;;;;		CLC
;;;;;;;;		ADC	#00010H
;;;;;;;;		STA	<WORK3
;;;;;;;;;
;;;;;;;;		LDY	#00007H
;;;;;;;;CRCH140 	EQU	$
;;;;;;;;		LDA	[<WORK0]
;;;;;;;;		STA	!VRAMD+2,X
;;;;;;;;		INC	<WORK0
;;;;;;;;		INC	<WORK0
;;;;;;;;;
;;;;;;;;		LDA	[<WORK3]
;;;;;;;;		AND	#000FFH
;;;;;;;;		STA	!VRAMD+2+010H,X
;;;;;;;;		INC	<WORK3
;;;;;;;;		INX
;;;;;;;;		INX
;;;;;;;;		DEY
;;;;;;;;		BPL	CRCH140		; 1char. end ?
;;;;;;;;;					; yes
;;;;;;;;		TXA
;;;;;;;;		CLC
;;;;;;;;		ADC	#00010H
;;;;;;;;		TAX
;;;;;;;;		LDA	<WORK3
;;;;;;;;		DEC	<WORKC
;;;;;;;;		BNE	CRCH120		; end ?
;;;;;;;;;					; yes
;;;;;;;;		MEM8
;;;;;;;;		IDX8
;;;;;;;;		SEP	#00110000B	; memory,index 8bit mode
;;;;;;;;		PLB			; (DBR) reset
;;;;;;;;		RTL
;
;
;
;
;************************************************************************
;*		BG. character change			(BGCHCNG)	*
;************************************************************************
BGCHCNG		EQU	$
		LDA	#BANK CHCHBF
		STA	<WORK2
		STA	<WORK5
;
		MEM16
		IDX16
		REP	#00110001B	; memory,index 16bit mode & CLC
;
		LDX	#00000H
		LDY	#00010H*2*2
		LDA	#CHCHBF
		JSR	BCHC000		; character buffer set-0
;
		LDY	#00010H*2*6
		LDA	!RBGCPT
		AND	#000FFH
		CMP	#00010H
		BCC	BCHCH20		; danjyon ?
;					; yes
		LDY	#00010H*2*4
		LDA	<WORK3
		JSR	BCHC000		; character buffer set-1
		LDY	#00010H*2*2
BCHCH20		EQU	$
		LDA	<WORK3
		JSR	BCHC100		; character buffer set-1
;
		SEP	#00110000B	; memory,index 8bit mode
		RTL
;
;
BCHC000		EQU	$
		STY	<WORKC
BCHC020		EQU	$
		STA	<WORK0
		CLC
		ADC	#00010H
		STA	<WORK3
;
		LDY	#00007H/2
BCHC040 	EQU	$
		LDA	[<WORK0]
		STA	>RSETCBF,X
		XBA
		ORA	[<WORK0]
		AND	#000FFH
		STA	<WORK8
		INC	<WORK0
		INC	<WORK0
		LDA	[<WORK3]
		AND	#000FFH
		STA	<WORKA
		ORA	<WORK8
		XBA
		ORA	<WORKA
		STA	>RSETCBF+010H,X
		INC	<WORK3
		INX
		INX
;
		LDA	[<WORK0]
		STA	>RSETCBF,X
		XBA
		ORA	[<WORK0]
		AND	#000FFH
		STA	<WORK8
		INC	<WORK0
		INC	<WORK0
		LDA	[<WORK3]
		AND	#000FFH
		STA	<WORKA
		ORA	<WORK8
		XBA
		ORA	<WORKA
		STA	>RSETCBF+010H,X
		INC	<WORK3
		INX
		INX
		DEY
		BPL	BCHC040		; 1char. end ?
;					; yes
		TXA
		CLC
		ADC	#00010H
		TAX
		LDA	<WORK3
		DEC	<WORKC
		BNE	BCHC020		; end ?
;					; yes
		RTS
;
;
BCHC100		EQU	$
		STY	<WORKC
BCHC120		EQU	$
		STA	<WORK0
		CLC
		ADC	#00010H
		STA	<WORK3
;
		LDY	#00007H/4
BCHC140 	EQU	$
		LDA	[<WORK0]
		STA	>RSETCBF,X
		INC	<WORK0
		INC	<WORK0
		LDA	[<WORK3]
		AND	#000FFH
		STA	>RSETCBF+010H,X
		INC	<WORK3
		INX
		INX
;
		LDA	[<WORK0]
		STA	>RSETCBF,X
		INC	<WORK0
		INC	<WORK0
		LDA	[<WORK3]
		AND	#000FFH
		STA	>RSETCBF+010H,X
		INC	<WORK3
		INX
		INX
;
		LDA	[<WORK0]
		STA	>RSETCBF,X
		INC	<WORK0
		INC	<WORK0
		LDA	[<WORK3]
		AND	#000FFH
		STA	>RSETCBF+010H,X
		INC	<WORK3
		INX
		INX
;
		LDA	[<WORK0]
		STA	>RSETCBF,X
		INC	<WORK0
		INC	<WORK0
		LDA	[<WORK3]
		AND	#000FFH
		STA	>RSETCBF+010H,X
		INC	<WORK3
		INX
		INX
		DEY
		BPL	BCHC140		; 1char. end ?
;					; yes
		TXA
		CLC
		ADC	#00010H
		TAX
		LDA	<WORK3
		DEC	<WORKC
		BNE	BCHC120		; end ?
;					; yes
		RTS
;
;
;
;
		MEM8
		IDX8
;************************************************************************
;*		OBJ. character change			(OJCHCNG)	*
;************************************************************************
OJCHCNG		EQU	$
		LDA	#BANK CHCHBF
		STA	<WORK2
		STA	<WORK5
;
		MEM16
		IDX16
		REP	#00110001B	; memory,index 16bit mode & CLC
;
		LDX	#00000H
		LDA	#CHCHBF+1800H
		LDY	#00010H*2*6
		JSR	BCHC100		; character buffer set-1
;
		LDY	#00010H*2*2
		LDA	>CHCHTB+7
		AND	#000FFH
		CMP	#C_4I0
		BEQ	OCHCH40		; 8~F color ?
;					; no
		CMP	#C_4I1
		BEQ	OCHCH40		; 8~F color ?
;					; no
		CMP	#C_4M0
		BEQ	OCHCH40		; 8~F color ?
;					; no
		CMP	#C_4M1
		BNE	OCHCH60		; 8~F color ?
;					; no
OCHCH40		EQU	$
		LDA	<WORK3
		JSR	BCHC000		; character buffer set-0
;
		SEP	#00110000B	; memory,index 8bit mode
		RTL
;
OCHCH60		EQU	$
		LDA	<WORK3
		JSR	BCHC100		; character buffer set-1
;
		MEM8
		IDX8
		SEP	#00110000B	; memory,index 8bit mode
		RTL
;
;
;
;
;
;************************************************************************
;*		BG. OBJ character change		(CHSCHNG)	*
;************************************************************************
; <<<<<<  BG   >>>>>>>> 
BGCHDAT 	EQU	$ 
		BYTE	C_0A0,C_0A1,C_0I0,C_0D0,C_0H0,C_0S0,C_0N0,C_1F1	; 00 shiro
		BYTE	C_0A0,C_0A1,C_0I0,C_0E0,C_0H0,C_0T1,C_0O1,C_1F1	;  1         under
		BYTE	C_0A0,C_0A1,C_0I0,C_0D0,C_0H0,C_0S0,C_0N0,C_1F1	;  2 shisai-room
		BYTE	C_0A0,C_0A1,C_0K0,C_0D1,C_0H0,C_0U0,C_0P0,C_1F1	;  3 minka
		BYTE	C_0A0,C_0A1,C_0I0,C_0D1,C_0H0,C_0U0,C_0P0,C_1F1	;  4 chapel
		BYTE	C_0A0,C_0A1,C_0I0,C_0E1,C_0H0,C_0S1,C_0N1,C_1F1	;  5 shinden , sabaku
		BYTE	C_0B0,C_0B1,C_0J0,C_0F1,C_0H0,C_0T0,C_0O0,C_1F1	;  6 doukutsu
		BYTE	C_0A0,C_0A1,C_0I1,C_0E1,C_0H0,C_0U1,C_0P1,C_1F1	;  7 ura-danjyon (shinden)
		BYTE	C_0A0,C_0A1,C_0I1,C_0E0,C_0H0,C_0T1,C_0O1,C_1F1	;  8 ura-danjyon (mizu hiki)
		BYTE	C_0A0,C_0A1,C_0I1,C_0E1,C_0H0,C_0V0,C_0Q0,C_1F1	;  9 ura-danjyon (mori-shita)
		BYTE	C_0A0,C_0A1,C_0I1,C_0E1,C_0H0,C_0V1,C_0Q1,C_1F1	;  A ura-danjyon (machi-shita)
		BYTE	C_0A0,C_0A1,C_0K1,C_0F0,C_0H0,C_0W0,C_0R0,C_1F1	;  B ura-danjyon (ice tower)
		BYTE	C_0A0,C_0A1,C_0I1,C_0E1,C_0H0,C_0W1,C_0R1,C_1F1	;  C ura-danjyon (numa)
		BYTE	C_0A0,C_0A0,C_0I1,C_0G0,C_0H0,C_0X0,C_0M0,C_1F1	;  D ura-danjyon (kame-iwa)
		BYTE	C_0A0,C_0A0,C_0I1,C_0G1,C_0H1,C_0X1,C_0M1,C_1F1	;  E ura-danjyon (tower)
		BYTE	C_4R0,C_4R1,C_4R0,C_4R1,C_0S1,C_0Y0,C_1Y1,C_1F1	;  F
;
		BYTE	C_1G0,C_1G1,C_1H0,C_1H1,C_1T1,C_1Q1,C_1I0,C_1X1	; 10 ground
		BYTE	C_1K0,C_1K1,C_1L0,C_1L1,C_0S1,C_0Y0,C_1I1,C_1Y1	;  1        (URA)
		BYTE	C_0A0,C_0E0,C_0I0,C_0N1,C_0S1,C_0Y1,C_2E0,C_1X1	;  2 
		BYTE	C_0A0,C_0E0,C_0M0,C_0Q1,C_0W0,C_1B1,C_1Y1,C_1X1	;  3 
		BYTE	C_0A0,C_0E0,C_0I0,C_0Q1,C_0W0,C_1B1,C_2E1,C_1X1	;  4 
		BYTE	C_0A0,C_0E0,C_0I1,C_0O1,C_0T1,C_0Z1,C_1Y1,C_1X1	;  5 
		BYTE	C_0A0,C_0E0,C_0I0,C_0N0,C_0S1,C_0Y0,C_1Y1,C_1X1	;  6
		BYTE	C_0A0,C_0E0,C_0I0,C_0N0,C_0S1,C_0Y0,C_1Y1,C_1X1	;  7
		BYTE	C_0A0,C_0E0,C_0I0,C_0N0,C_0S1,C_0Y0,C_1Y1,C_1X1	;  8
		BYTE	C_0A0,C_0E0,C_0I0,C_0N0,C_0S1,C_0Y0,C_1Y1,C_1X1	;  9
		BYTE	C_0A0,C_0E0,C_0I0,C_0N0,C_0S1,C_0Y0,C_1Y1,C_1X1	;  A
		BYTE	C_0A0,C_0E0,C_0I0,C_0N0,C_0S1,C_0Y0,C_1Y1,C_1X1	;  B
		BYTE	C_0A0,C_0E0,C_0I0,C_0N0,C_0S1,C_0Y0,C_1Y1,C_1X1	;  C
		BYTE	C_0A0,C_0E0,C_0I0,C_0N0,C_0S1,C_0Y0,C_1Y1,C_1X1	;  D
		BYTE	C_0A0,C_0E0,C_0I0,C_0N0,C_0S1,C_0Y0,C_1Y1,C_1X1	;  E
		BYTE	C_4R0,C_4R1,C_4R0,C_4R1,C_0S1,C_0Y0,C_1Y1,C_1X1	;  F 
;
		BYTE	C_0A0,C_4R1,C_4R0,C_4R1,C_0S1,C_0Y0,C_1Y1,C_1F1	; 20 MAP
		BYTE	C_0A0,C_0H1,C_0H1,C_4R1,C_0S1,C_0Y0,C_1Y1,C_1F1	; 21 TITLE
;
;
;// 02.12.13 //;<<<<<< OBJ >>>>>>> 
;// 02.12.13 //OBCHDAT 	EQU	$ 
;// 02.12.13 //		BYTE	C_4I0,C_2X1,C_2X0,C_3C0	; 00 danjyon
;// 02.12.13 //		BYTE	C_3B0,C_3B1,C_2X0,C_2X1	;  1 
;// 02.12.13 //		BYTE	C_3B0,C_3B1,C_2X0,C_2X1	;  2 
;// 02.12.13 //		BYTE	C_3B0,C_3B1,C_2X0,C_2X1	;  3 
;// 02.12.13 //		BYTE	C_4I0,C_3H1,C_2X0,C_2X1 ;  4
;// 02.12.13 //		BYTE	C_4I0,C_3H0,C_2X0,C_4I1	;  5 
;// 02.12.13 //		BYTE	C_3B0,C_3B1,C_2X0,C_2X1	;  6 
;// 02.12.13 //		BYTE	C_3B0,C_3B1,C_2X0,C_2X1	;  7 
;// 02.12.13 //		BYTE	C_3B0,C_3B1,C_2X0,C_2X1	;  8 
;// 02.12.13 //		BYTE	C_3B0,C_3B1,C_2X0,C_2X1	;  9 
;// 02.12.13 //		BYTE	C_3B0,C_3B1,C_2X0,C_2X1	;  A 
;// 02.12.13 //		BYTE	C_3B0,C_3B1,C_2X0,C_2X1	;  B 
;// 02.12.13 //		BYTE	C_3B0,C_3B1,C_2X0,C_2X1	;  C 
;// 02.12.13 //		BYTE	C_3B0,C_3B1,C_2X0,C_2X1	;  D 
;// 02.12.13 //		BYTE	C_3B0,C_3B1,C_2X0,C_2X1	;  E 
;// 02.12.13 //		BYTE	C_3B0,C_3B1,C_2X0,C_2X1	;  F 
;// 02.12.13 //;
;// 02.12.13 //		BYTE	C_2X0,C_2X1,C_4H0,C_4H1	; 10 ground 
;// 02.12.13 //		BYTE	C_3B0,C_3B1,C_2X0,C_2X1	;  1 
;// 02.12.13 //		BYTE	C_4I0,C_3B0,C_3B1,C_2X0	;  2
;// 02.12.13 //		BYTE	C_4I0,C_3B0,C_3B1,C_2X0	;  3
;// 02.12.13 //		BYTE	C_4I0,C_3B0,C_3B1,C_2X0	;  4
;// 02.12.13 //		BYTE	C_4I0,C_3B0,C_3B1,C_2X0	;  5
;// 02.12.13 //		BYTE	C_4I0,C_3B0,C_3B1,C_2X0	;  6
;// 02.12.13 //		BYTE	C_4I0,C_3B0,C_3B1,C_2X0	;  7
;// 02.12.13 //		BYTE	C_4I0,C_3B0,C_3B1,C_2X0	;  8
;// 02.12.13 //		BYTE	C_4I0,C_3B0,C_3B1,C_2X0	;  9
;// 02.12.13 //		BYTE	C_4I0,C_3B0,C_3B1,C_2X0	;  A
;// 02.12.13 //		BYTE	C_4I0,C_3B0,C_3B1,C_2X0	;  B
;// 02.12.13 //		BYTE	C_4I0,C_3B0,C_3B1,C_2X0	;  C
;// 02.12.13 //		BYTE	C_4I0,C_3B0,C_3B1,C_2X0	;  D
;// 02.12.13 //		BYTE	C_4I0,C_3B0,C_3B1,C_2X0	;  E
;// 02.12.13 //		BYTE	C_4I0,C_3B0,C_3B1,C_2X0	;  F
;// 02.12.13 //; 
;// 02.12.13 //		BYTE	C_4R3,C_4R3,C_2X0,C_4H0	; 20 select map
;// 02.12.13 //;
; 
;
;
CHSCHNG		EQU	$
		PHB
		PHK
		PLB			; (DBR) set
;
		LDA	#10000000B
		STA	2115H		; inc. mode
;
;<<<<<  Basic  obj. 4bit set >>>>>>
		STZ	2116H
		LDA	#044H
		STA	2117H		; Vram address (04400H)
;
		JSR	CHSET1
;
;
;<<<<< Change obj. 3bit set >>>>>>
		MEM16
		IDX16
		REP	#00110000B	; memory,index 16bit mode
;
;// 03.05.10 //		LDY	#00003H
;// 03.05.10 //		LDX	#00000H
;// 03.05.10 //CHCH010		EQU	$
;// 03.05.10 //		LDA	>CHCHTB+4,X
;// 03.05.10 //		STA	WORK+6,Y
;// 03.05.10 //		INX
;// 03.05.10 //		DEY
;// 03.05.10 //		BPL	CHCH010		;
;// 03.05.10 //;					;
;// 03.05.10 //		LDX	#00003H
;// 02.10.03 //		LDA	!CHARBK
		LDA	!ROBJCPT
		AND	#000FFH
		ASL	A
		ASL	A
		TAY
;
		MEM8
		SEP	#00100000B	; memory 8bit mode
;// 03.05.10 //CHCH020	 	EQU	$
;// 03.05.10 //;// 02.10.03 //		LDA	OBCHDAT,Y
;// 03.05.10 //		LDA	ROBCHDT,Y
;// 03.05.10 //		BNE	CHCH030		;
;// 03.05.10 //;					;
;// 03.05.10 //;// 03.03.25 //		MEM16
;// 03.05.10 //;// 03.03.25 //		REP	#00100000B	; memory 16bit mode
;// 03.05.10 //;// 03.03.25 //		PHY			; (Y) push
;// 03.05.10 //;// 03.03.25 //		PHX			; (X) push
;// 03.05.10 //;// 03.03.25 //		TYA
;// 03.05.10 //;// 03.03.25 //		AND	#00003H
;// 03.05.10 //;// 03.03.25 //		TAX
;// 03.05.10 //;// 03.03.25 //		MEM8
;// 03.05.10 //;// 03.03.25 //		SEP	#00100000B	; memory 8bit mode
;// 03.05.10 //;// 03.03.25 //;
;// 03.05.10 //;// 03.03.25 //		LDA	>CHCHTB+4,X
;// 03.05.10 //;// 03.03.25 //		PLX			; (X) pull
;// 03.05.10 //;// 03.03.25 //		PLY			; (Y) pull
;// 03.05.10 //CHCH030		EQU	$
;// 03.05.10 //		STA	<WORK6,X
;// 03.05.10 //		INY
;// 03.05.10 //		DEX
;// 03.05.10 //		BPL	CHCH020
		LDA	ROBCHDT+0,Y
		BEQ	CHCH010		;
;					;
		STA	>CHCHTB+4+0
CHCH010		EQU	$
		LDA	>CHCHTB+4+0
		STA	<WORK6+3
;
		LDA	ROBCHDT+1,Y
		BEQ	CHCH012		;
;					;
		STA	>CHCHTB+4+1
CHCH012		EQU	$
		LDA	>CHCHTB+4+1
		STA	<WORK6+2
;
		LDA	ROBCHDT+2,Y
		BEQ	CHCH014		;
;					;
		STA	>CHCHTB+4+2
CHCH014		EQU	$
		LDA	>CHCHTB+4+2
		STA	<WORK6+1
;
		LDA	ROBCHDT+3,Y
		BEQ	CHCH016		;
;					;
		STA	>CHCHTB+4+3
CHCH016		EQU	$
		LDA	>CHCHTB+4+3
		STA	<WORK6+0
;
		IDX8
		SEP	#00010000B	; index 8bit mode
;
;// 02.10.03 //		LDA	!ROBJCPT
;// 02.10.03 //		ASL	A
;// 02.10.03 //		ASL	A
;// 02.10.03 //		TAX
;// 02.10.03 //		LDA	ROBCHDT,X
;// 02.10.03 //		STA	<WORK7
;// 02.10.03 //		LDA	ROBCHDT+1,X
;// 02.10.03 //		STA	<WORK6
;
;// 03.05.28 //		LDA	#003H
;// 03.05.28 //		STA	<WORKF
		LDY	<WORK6+3
		LDA	#BANK CHCHBF+0600H*4
		STA	<WORK2
;// 03.05.31 //		LDA	#LOW CHCHBF+0600H*4
		LDX	#HIGH CHCHBF+0600H*4
		JSR	CHSET
;// 03.05.28 //		DEC	<WORKF
		LDY	<WORK6+2
;// 03.05.31 //		LDA	#LOW CHCHBF+0600H*5
		LDX	#HIGH CHCHBF+0600H*5
		JSR	CHSET
;// 03.05.28 //		DEC	<WORKF
		LDY	<WORK6+1
;// 03.05.31 //		LDA	#LOW CHCHBF+0600H*6
		LDX	#HIGH CHCHBF+0600H*6
		JSR	CHSET
;// 03.05.28 //		DEC	<WORKF
		LDY	<WORK6+0
;// 03.05.31 //		LDA	#LOW CHCHBF+0600H*7
		LDX	#HIGH CHCHBF+0600H*7
		JSR	CHSET
;
;
;<<<<< BG charcter set >>>>>>
		MEM16
		IDX16
		REP	#00110000B	; memory,index 16bit mode
;
		LDA	#02000H
		STA	2116H		; Vram address (02000H)
;
;// 03.05.16 //		LDX	#00007H
		LDA	!CHIKNO
		AND	#000FFH
		ASL	A
		ASL	A
		ASL	A
		TAY
;
;// 03.05.16 //		MEM8
;// 03.05.16 //		SEP	#00100000B	; memory 8bit mode
;// 03.05.16 //CHCH100 	EQU	$
;// 03.05.16 //		LDA	BGCHDAT,Y
;// 03.05.16 //		STA	<WORK6,X
;// 03.05.16 //		INY
;// 03.05.16 //		DEX
;// 03.05.16 //		BPL	CHCH100
;// 03.05.16 //;
;// 03.05.16 //		MEM16
;// 03.05.16 //		REP	#00100000B	; index 16bit mode
;
		LDA	!RBGCPT
		AND	#000FFH
		ASL	A
		ASL	A
		TAX
;
		MEM8
		SEP	#00100000B	; memory 8bit mode
;
		LDA	BGCHDAT+0,Y
		STA	<WORK6+7
;
		LDA	BGCHDAT+1,Y
		STA	<WORK6+6
;
		LDA	BGCHDAT+2,Y
		STA	<WORK6+5
;
		LDA	RBGCHDT+0,X
		BNE	CHCH110		; set ?
;					; yes
		LDA	BGCHDAT+3,Y
CHCH110		EQU	$
		STA	>CHCHTB+0
		STA	<WORK6+4
;
		LDA	RBGCHDT+1,X
		BNE	CHCH120		; set ?
;					; yes
		LDA	BGCHDAT+4,Y
CHCH120		EQU	$
		STA	>CHCHTB+1
		STA	<WORK6+3
;
		LDA	RBGCHDT+2,X
		BNE	CHCH130		; set ?
;					; yes
		LDA	BGCHDAT+5,Y
CHCH130		EQU	$
		STA	>CHCHTB+2
		STA	<WORK6+2
;
		LDA	RBGCHDT+3,X
		BNE	CHCH140		; set ?
;					; yes
		LDA	BGCHDAT+6,Y
CHCH140		EQU	$
		STA	>CHCHTB+3
		STA	<WORK6+1
;
		LDA	BGCHDAT+7,Y
		STA	<WORK6+0
;
		IDX8
		SEP	#00010000B	; index 8bit mode
;
		LDA	#007H
		STA	<WORKF
		LDY	<WORK6+7
		JSR	CHSET0
;
		DEC	<WORKF
		LDY	<WORK6+6
		JSR	CHSET0
;
		DEC	<WORKF
		LDY	<WORK6+5
		JSR	CHSET0
;
		DEC	<WORKF
		LDY	<WORK6+4
		LDA	#BANK CHCHBF+0600H*0
;// 03.05.31 //		STA	<WORK2
;// 03.05.31 //		LDA	#LOW CHCHBF+0600H*0
		LDX	#HIGH CHCHBF+0600H*0
		JSR	CHS0000
;
		DEC	<WORKF
		LDY	<WORK6+3
		LDA	#BANK CHCHBF+0600H*1
;// 03.05.31 //		STA	<WORK2
;// 03.05.31 //		LDA	#LOW CHCHBF+0600H*1
		LDX	#HIGH CHCHBF+0600H*1
		JSR	CHS0000
;
		DEC	<WORKF
		LDY	<WORK6+2
		LDA	#BANK CHCHBF+0600H*2
;// 03.05.31 //		STA	<WORK2
;// 03.05.31 //		LDA	#LOW CHCHBF+0600H*2
		LDX	#HIGH CHCHBF+0600H*2
		JSR	CHS0000
;
		DEC	<WORKF
		LDY	<WORK6+1
		LDA	#BANK CHCHBF+0600H*3
;// 03.05.31 //		STA	<WORK2
;// 03.05.31 //		LDA	#LOW CHCHBF+0600H*3
		LDX	#HIGH CHCHBF+0600H*3
		JSR	CHS0000
;
		DEC	<WORKF
		LDY	<WORK6+0
		JSR	CHSET0
;
		PLB			; (DBR) reset
		RTL
;
;
;
; 
;************************************************************************
;*		BG.3 character set			(CHSCHN0)	*
;************************************************************************
CHSCHN0		EQU	$
		PHB
		PHK
		PLB			; (DBR) set
;
		LDA	#10000000B
		STA	2115H		; inc. mode
;
;// 03.05.17 //		LDY	#C_2R0
		LDA	OCADB
		STA	<WORK2
		LDA	OCADH
		STA	<WORK1
		LDA	OCADL
		STA	<WORK0
;
		MEM16
		REP	#00100000B	; memory 16bit mode
;
		LDA	#04000H
		STA	2116H		; Vram address (04000H)
;
		LDY	#040H
CHS1100 	EQU	$
		LDX	#00EH
CHS1140 	EQU	$
		LDA	[<WORK0]
		STA	2118H
		XBA
		ORA	[<WORK0]
		AND	#000FFH
		STA	<BFP000,X
		INC	<WORK0
		INC	<WORK0
		DEX
		DEX
		BPL	CHS1140
;
		LDX	#00EH
CHS1180 	EQU	$
		LDA	[<WORK0]
		AND	#000FFH
		STA	<WORKZ
		ORA	<BFP000,X
		XBA
		ORA	<WORKZ
		STA	2118H
		INC	<WORK0
		DEX
		DEX
		BPL	CHS1180
;
		DEY
		BNE	CHS1100		; 0-7 char. ?
;					; yes
;
;<<<<< BG. 2bit set (BG3) >>>>>
		LDA	#07000H
		STA	2116H		; Vram address (07000H)
;
		MEM8
		SEP	#00100000B	; memory 8bit mode
;
		LDY	#C_4W
		JSR	CHCHN200	; character set
;
		LDY	#C_4X
		JSR	CHCHN200	; character set
;
		LDY	#C_4V
		JSR	CHCHN200	; character set
;
		PLB			; (DBR) RESET
		RTL
;
;
CHCHN200	EQU	$
		JSR	CADWKST2	; char. address work set
;
		MEM16
		IDX16
		REP	#00110000B	; memory,index 16bit mode
;
		LDX	#003FEH/4
CHCHN260 	EQU	$
		LDA	[<WORK0]
		STA	2118H
		INC	<WORK0
		INC	<WORK0
		LDA	[<WORK0]
		STA	2118H
		INC	<WORK0
		INC	<WORK0
		LDA	[<WORK0]
		STA	2118H
		INC	<WORK0
		INC	<WORK0
		LDA	[<WORK0]
		STA	2118H
		INC	<WORK0
		INC	<WORK0
		DEX
		BPL	CHCHN260
;
		MEM8
		IDX8
		SEP	#00110000B	; memory,index 8bit mode
		RTS
;
;
; 
;************************************************************************
;*		Ground CG. change			(GCGCHNG)	*
;*		[in]	(A)	<-- set pointer				*
;************************************************************************
CGCGDT 		EQU	$
		HEX	000,0FF,007,0FF		; 0
;
		HEX	000,001,007,0FF		; 1
		HEX	000,002,007,0FF		; 2
		HEX	000,003,007,0FF		; 3
		HEX	000,004,007,0FF		; 4
		HEX	000,005,007,0FF		; 5
		HEX	000,006,007,0FF		; 6
		HEX	007,006,005,0FF		; 7
		HEX	000,008,007,0FF		; 8
		HEX	000,009,007,0FF		; 9
		HEX	000,00A,007,0FF		: A
;
		HEX	000,00B,007,0FF		: B
		HEX	000,0FF,007,0FF		: C
		HEX	000,0FF,007,0FF		: D
		HEX	000,0FF,007,0FF		: E
		HEX	000,0FF,007,0FF		: F
;
;
		HEX	010,0FF,006,0FF		;10
;
		HEX	010,001,006,0FF		;11
		HEX	010,011,006,0FF		;12
		HEX	010,003,006,0FF		;13
		HEX	010,004,006,0FF		;14
		HEX	010,005,006,0FF		;15
		HEX	010,006,006,0FF		;16
		HEX	012,013,004,0FF		;17
		HEX	010,008,006,0FF		;18
		HEX	010,009,006,0FF		;19
		HEX	010,00B,006,0FF		;1A
		HEX	010,00C,006,0FF		;1B
		HEX	010,00D,006,0FF		;1C
		HEX	010,00E,006,0FF		;1D
		HEX	010,00F,006,0FF		;1E
;
;
CGCGD1 		EQU	$
		HEX	0FF,0FF			; 0
;
		HEX	00A,001			; 1
		HEX	003,006			; 2
		HEX	003,001			; 3
		HEX	002,000			; 4
		HEX	003,00A			; 5
		HEX	003,002			; 6
		HEX	006,001			; 7
		HEX	00B,00C			; 8
		HEX	0FF,0FF			; 9
		HEX	0FF,0FF			: A
		HEX	0FF,0FF			: B
		HEX	0FF,0FF			: C
		HEX	0FF,0FF			: D
		HEX	0FF,0FF			: E
		HEX	0FF,0FF			: F
;
;
GCGCHNG		EQU	$
		ASL	A
		ASL	A
		TAX
		STZ	!CGSTPT+1
;
		LDA	>CGCGDT+0,X
		BMI	CGCG10		; set ok ?
;					; yes
		STA	!GNDBGC1
CGCG10		EQU	$
		LDA	>CGCGDT+1,X
		BMI	CGCG20		; set ok ?
;					; yes
		STA	!GNDBGC2
CGCG20		EQU	$
		LDA	>CGCGDT+2,X
		BMI	CGCG30		; set ok ?
;					; yes
		STA	!KOKBGC
CGCG30		EQU	$
		LDA	<WORK0
		ASL	A
		TAX
		LDA	>CGCGD1+0,X
		BMI	CGCG40		; set ok ?
;					; yes
		STA	!EYOJC0
CGCG40		EQU	$
		LDA	>CGCGD1+1,X
		BMI	CGCG50		; set ok ?
;					; yes
		STA	!EYOJC1
CGCG50		EQU	$
		JSL	>GDCGST1
		JSL	>GDCGST2
		JSL	>KOUKAST
;
		JSL	>MSCGST1
		JSL	>MSCGST2
SPOJC90		EQU	$
		RTL
;
;
;
;************************************************************************
;*		Spacial OBJ character change		(SPOJCNG)	*
;************************************************************************
spoj0		EQU	001H		; reset
spoj1		EQU	003H		; fire
spoj2		EQU	005H		; ice
spoj3		EQU	007H		; flower
spoj4		EQU	009H		; thunder
spoj5		EQU	00BH		; bomber
spoj6		EQU	00DH		; jishin
spoj7		EQU	00EH		; "GAME OVER"
;
;
;// 02.10.24 //SPOADT		EQU	$-1
;// 02.10.24 //		BYTE	000H,003H,000H,003H,000H,003H
;
SPOPTD		EQU	$-1
		BYTE	C_2R1,C_2R1,C_2V0,C_2V0
		BYTE	C_2V1,C_2V1,C_2S0,C_2S0
		BYTE	C_2S0,C_2S0,C_2S1,C_2S1
		BYTE	C_2T0,C_2T0,C_2T1,C_2T1
;
SPOCGD		EQU	$-1
;			  reset      fire
		BYTE	00AH,0FFH,003H,0FFH
;			   ice      flower
		BYTE	000H,0FFH,0FFH,0FFH
;			 thunder    bomber
		BYTE	001H,0FFH,002H,0FFH
;			 jishin   "Game over"
		BYTE	000H,0FFH,0FFH,0FFH
;
;// 02.10.24 //SPOADR		EQU	$-1
;// 02.10.24 //		BYTE	044H,046H,044H,046H,044H,046H
;
;
SPOJCNG		EQU	$
		LDX	!SPOJFG
		BEQ	SPOJC90		; spacial OBJ set ?
;					; yes
		PHB
		PHK
		PLB			; (DBR) set
;
		LDA	SPOCGD,X
		BMI	SPOJ20		; CG. set ?
;					; yes
		STA	!CHITEMJC
		CPX	#001H
		BNE	SPOJ10		; reset ?
;					; yes
;// 03.06.04 //		LDA	<GMMODE
;// 03.06.04 //		BNE	SPOJ05		; ground ?
;// 03.06.04 //;					; yes
;// 03.06.04 //		LDA	#006H
;// 03.06.04 //		STA	!CHITEMJC
;// 03.06.04 //		LDA	<MPDTNO
;// 03.06.04 //		AND	#01000000B
;// 03.06.04 //		BEQ	SPOJ10		; ura ?
;// 03.06.04 //;					; yes
;// 03.06.04 //		LDA	#008H
;// 03.06.04 //		STA	!CHITEMJC
		LDA	#00AH
		STA	!CHITEMJC
SPOJ10		EQU	$
		LDA	#002H
		STA	!CGSTPT+1	; (CGWORK) set
		JSL	>CHITEMST	; special CG. set
		INC	<CGVMAF
SPOJ20		EQU	$
		LDX	!SPOJFG
		LDY	#044H
		STZ	<WORK8
		STZ	<WORK9
		INC	!SPOJFG
		LDA	!SPOJFG
		LSR	A
		BCC	SPOJ40		; end ?
;					; yes
		LDA	#003H
		STA	<WORK9
		STZ	!SPOJFG
		LDY	#046H
SPOJ40		EQU	$
		STY	!NXBWFG		; OBJ. BG. character change flag on
		LDA	#bgwB
		STA	<BGWTFG
;
		LDY	SPOPTD,X	; (Y) <-- file pointer
		CPY	#C_2R1
		BNE	SPOJ50		; reset ?
;					; yes
		LDY	!OJBSPT
;// 03.06.04 //		LDA	<MPDTNO
;// 03.06.04 //		AND	#01000000B
;// 03.06.04 //		BEQ	SPOJ50		; ura ?
;// 03.06.04 //;					; yes
;// 03.06.04 //		LDY	#C_2W1
SPOJ50		EQU	$
		LDA	OCADB,Y 
		STA	<WORK2
		STA	<WORK5
		LDA	OCADH,Y
		STA	<WORK1
		LDA	OCADL,Y
		STA	<WORK0
;
;// 03.03.13 //		CPX	#003H
;// 03.03.13 //		BCS	SPOJ200		; 8-F color ?
;// 03.03.13 //;					; no
;// 03.03.13 //		MEM16
;// 03.03.13 //		IDX16
;// 03.03.13 //		REP	#00110001B	; memory,index 16bit mode & CLC
;// 03.03.13 //;
;// 03.03.13 //		LDY	#00010H*2
;// 03.03.13 //		STY	<WORKC
;// 03.03.13 //		LDX	#00000H
;// 03.03.13 //		LDA	<WORK0
;// 03.03.13 //		ADC	<WORK8
;// 03.03.13 //SPOJ100		EQU	$
;// 03.03.13 //		STA	<WORK0
;// 03.03.13 //		CLC
;// 03.03.13 //		ADC	#00010H
;// 03.03.13 //		STA	<WORK3
;// 03.03.13 //;
;// 03.03.13 //		LDY	#00007H
;// 03.03.13 //SPOJ120 	EQU	$
;// 03.03.13 //		LDA	[<WORK0]
;// 03.03.13 //		STA	>RSETCBF+1000H,X
;// 03.03.13 //		INC	<WORK0
;// 03.03.13 //		INC	<WORK0
;// 03.03.13 //		BNE	SPOJ160		; bank change ?
;// 03.03.13 //;					; yes
;// 03.03.13 //		LDA	#08000H
;// 03.03.13 //		STA	<WORK0
;// 03.03.13 //		LDA	#08010H
;// 03.03.13 //		STA	<WORK3
;// 03.03.13 //		INC	<WORK2
;// 03.03.13 //		INC	<WORK5
;// 03.03.13 //SPOJ160		EQU	$
;// 03.03.13 //		LDA	[<WORK3]
;// 03.03.13 //		AND	#000FFH
;// 03.03.13 //		STA	>RSETCBF+1010H,X
;// 03.03.13 //		INC	<WORK3
;// 03.03.13 //		BNE	SPOJ180		; bank change ?
;// 03.03.13 //;					; yes
;// 03.03.13 //		LDA	#08000H
;// 03.03.13 //		STA	<WORK0
;// 03.03.13 //		LDA	#08010H
;// 03.03.13 //		STA	<WORK3
;// 03.03.13 //		INC	<WORK2
;// 03.03.13 //		INC	<WORK5
;// 03.03.13 //SPOJ180		EQU	$
;// 03.03.13 //		INX
;// 03.03.13 //		INX
;// 03.03.13 //		DEY
;// 03.03.13 //		BPL	SPOJ120		; 1char. end ?
;// 03.03.13 //;					; yes
;// 03.03.13 //		TXA
;// 03.03.13 //		CLC
;// 03.03.13 //		ADC	#00010H
;// 03.03.13 //		TAX
;// 03.03.13 //		LDA	<WORK3
;// 03.03.13 //		DEC	<WORKC
;// 03.03.13 //		BNE	SPOJ100		; end ?
;// 03.03.13 //;					; yes
;// 03.03.13 //		MEM8
;// 03.03.13 //		IDX8
;// 03.03.13 //		SEP	#00110000B	; memory,index 8bit mode
;// 03.03.13 //		PLB			; (DBR) reset
;// 03.03.13 //		RTL
;// 03.03.13 //;
;// 03.03.13 //SPOJ200		EQU	$
;
		MEM16
		IDX16
		REP	#00110001B	; memory,index 16bit mode & CLC
;
		LDY	#00010H*2
		STY	<WORKC
		LDX	#00000H
		LDA	<WORK0
		ADC	<WORK8
SPOJ220		EQU	$
		STA	<WORK0
		CLC
		ADC	#00010H
		STA	<WORK3
;
		LDY	#00007H
SPOJ240 	EQU	$
		LDA	[<WORK0]
		STA	>RSETCBF+1000H,X
		XBA
		ORA	[<WORK0]
		AND	#000FFH
		STA	<WORK8
		INC	<WORK0
		INC	<WORK0
		BNE	SPOJ260		; bank change ?
;					; yes
		LDA	#08000H
		STA	<WORK0
		LDA	#08010H
		STA	<WORK3
		INC	<WORK2
		INC	<WORK5
SPOJ260		EQU	$
		LDA	[<WORK3]
		AND	#000FFH
		STA	<WORKA
		ORA	<WORK8
		XBA
		ORA	<WORKA
		STA	>RSETCBF+1010H,X
		INC	<WORK3
		BNE	SPOJ280		; bank change ?
;					; yes
		LDA	#08000H
		STA	<WORK0
		LDA	#08010H
		STA	<WORK3
		INC	<WORK2
		INC	<WORK5
SPOJ280		EQU	$
		INX
		INX
		DEY
		BPL	SPOJ240		; 1char. end ?
;					; yes
		TXA
		CLC
		ADC	#00010H
		TAX
		LDA	<WORK3
		DEC	<WORKC
		BNE	SPOJ220		; end ?
;					; yes
		MEM8
		IDX8
		SEP	#00110000B	; memory,index 8bit mode
		PLB			; (DBR) reset
		RTL
;
;
;
; 
;************************************************************************
;*		Player CG. change			(PLCGCN0)	*
;************************************************************************
PLCGCN0		EQU	$
		MEM16
		REP	#00100000B	; memory 16bit mode
;
;;;;;;;;		LDA	!KENOJC
		LDA	>ITMTBL6
		STA	<WORKC
;;;;;;;;;;;;;;;;		LDA	!TATOJC
;;;;;;;;		LDA	>ITMTBL7
;;;;;;;;		STA	<WORKD
;;;;;;;;		LDA	!PLYOJC
		LDA	>ITMTBL8
		AND	#000FFH
;;;;;;;;		STA	<WORKE
;;;;;;;;		LDA	!PLYOJC1
;;;;;;;;		STA	<WORKF
		BRA	PLCGC000
; 
;************************************************************************
;*		Player CG. change			(PLCGCN1)	*
;************************************************************************
PLCGCN1		EQU	$
		MEM16
		REP	#00100000B	; memory 16bit mode
;
		LDA	#00202H
		STA	<WORKC
		LDA	#00404H
		BRA	PLCGC000
; 
;************************************************************************
;*		Player CG. change			(PLCGCN1)	*
;************************************************************************
PLCGCN2		EQU	$
		MEM16
		REP	#00100000B	; memory 16bit mode
;
;;;;;;;;		LDA	!KENOJC
		LDA	>ITMTBL6
		STA	<WORKC
		LDA	#00303H
PLCGC000	EQU	$
		STA	<WORKE
;
		LDA	#BANK CORGENE
		STA	<WORK2
;
		LDX	<WORKC
		LDA	>CGLPT3,X
		AND	#000FFH
		CLC
		ADC	#KENOBJ
		IDX16
		REP	#00010000B	; index 16bit mode
		LDX	#001B2H		; set point
		LDY	#00002H		; yoko kosuu
		JSR	PLCG200		; ken CG. set
;
		IDX8
		SEP	#00010000B	; index 8bit mode
		LDX	<WORKD
		LDA	>CGLPT4,X
		AND	#000FFH
		CLC
		ADC	#TATEOBJ
		IDX16
		REP	#00010000B	; index 16bit mode
		LDX	#001B8H		; set point
		LDY	#00003H		; yoko kosuu
		JSR	PLCG200		; tate CG. set
;
		IDX8
		SEP	#00010000B	; index 8bit mode
		LDX	<WORKE
		LDA	>CGLPT8,X
		AND	#000FFH
		ASL	A
		CLC
		ADC	#PLAYCG
		IDX16
		REP	#00010000B	; index 16bit mode
		LDX	#001E2H		; set point
		LDY	#0000EH		; yoko kosuu
		JSR	PLCG200		; player CG. set - 0
;
		MEM8
		IDX8
		SEP	#00110000B	; memory 16bit mode
;
		INC	<CGVMAF		; CG. change
		RTL
;
;
		MEM16
		IDX16
PLCG200		EQU	$
		STA	<WORK0
PLCG220		EQU	$
		LDA	[<WORK0]
		STA	>CGRAM,X
		STA	>CGWORK,X
		INC	<WORK0
		INC	<WORK0
		INX
		INX
		DEY
		BPL	PLCG220		; set end ?
;					; yes
		RTS
;
; 
;
; 
;************************************************************************
;*		Thunder CG. change			(THCGCN0)	*
;************************************************************************
THCGCN0		EQU	$
		MEM16
		IDX16
		REP	#00110000B	; memory,index 16bit mode
;
		LDX	#00000H
THCG020		EQU	$
		LDA	#07FFFH
		STA	>CGWORK+040H,X
		STA	>CGWORK+050H,X
		STA	>CGWORK+060H,X
		STA	>CGWORK+070H,X
		STA	>CGWORK+080H,X
		STA	>CGWORK+090H,X
		STA	>CGWORK+0A0H,X
		STA	>CGWORK+0B0H,X
		STA	>CGWORK+0C0H,X
		STA	>CGWORK+0D0H,X
		STA	>CGWORK+0E0H,X
		STA	>CGWORK+0F0H,X
;
		LDA	>CGRAM+160H,X
		STA	>CGWORK+160H,X
		LDA	>CGRAM+180H,X
		STA	>CGWORK+180H,X
		LDA	>CGRAM+1A0H,X
		STA	>CGWORK+1A0H,X
		LDA	>CGRAM+1F0H,X
		STA	>CGWORK+1F0H,X
		INX
		INX
		CPX	#00010H
		BNE	THCG020		; BG. CG. set end ?
;					; yes
		MEM8
		IDX8
		SEP	#00110000B	; memory 16bit mode
		RTL
;
;// 03.06.05 //		LDX	#00001H
;// 03.06.05 //		LDY	#00016H
;// 03.06.05 //		BRA	THCG000
;
;
;************************************************************************
;*		Thunder CG. change			(THCGCN1)	*
;************************************************************************
THCGCN1		EQU	$
		MEM16
		IDX16
		REP	#00110000B	; memory,index 16bit mode
;
		LDX	#00000H
THCG120		EQU	$
		LDA	>CGRAM+040H,X
		STA	>CGWORK+040H,X
		LDA	>CGRAM+050H,X
		STA	>CGWORK+050H,X
		LDA	>CGRAM+060H,X
		STA	>CGWORK+060H,X
		LDA	>CGRAM+070H,X
		STA	>CGWORK+070H,X
		LDA	>CGRAM+080H,X
		STA	>CGWORK+080H,X
		LDA	>CGRAM+090H,X
		STA	>CGWORK+090H,X
		LDA	>CGRAM+0A0H,X
		STA	>CGWORK+0A0H,X
		LDA	>CGRAM+0B0H,X
		STA	>CGWORK+0B0H,X
		LDA	>CGRAM+0C0H,X
		STA	>CGWORK+0C0H,X
		LDA	>CGRAM+0D0H,X
		STA	>CGWORK+0D0H,X
		LDA	>CGRAM+0E0H,X
		STA	>CGWORK+0E0H,X
		LDA	>CGRAM+0F0H,X
		STA	>CGWORK+0F0H,X
;
		LDA	#07FFFH
		STA	>CGWORK+160H,X
		STA	>CGWORK+180H,X
		STA	>CGWORK+1A0H,X
		STA	>CGWORK+1F0H,X
		INX
		INX
		CPX	#00010H
		BNE	THCG120		; BG. CG. set end ?
;					; yes
;// 03.06.05 //		LDX	#00002H
;// 03.06.05 //		LDY	#00017H
;// 03.06.05 //THCG000		EQU	$
;// 03.06.05 //		PHY			; (Y) push
;// 03.06.05 //;
;// 03.06.05 //		LDA	>CGLPT3,X
;// 03.06.05 //		AND	#000FFH
;// 03.06.05 //		CLC
;// 03.06.05 //		ADC	#TOKUSYU
;// 03.06.05 //		STA	<WORK0
;// 03.06.05 //		PHA			; (A) push
;// 03.06.05 //;
;// 03.06.05 //		LDX	#00200H
;// 03.06.05 //		LDY	#00007H
;// 03.06.05 //THCG060		EQU	$
;// 03.06.05 //		LDA	[<WORK0]
;// 03.06.05 //		STA	>CHGRAM+040H,X
;// 03.06.05 //		STA	>CHGRAM+050H,X
;// 03.06.05 //		STA	>CHGRAM+060H,X
;// 03.06.05 //		STA	>CHGRAM+070H,X
;// 03.06.05 //		STA	>CHGRAM+080H,X
;// 03.06.05 //		STA	>CHGRAM+090H,X
;// 03.06.05 //		STA	>CHGRAM+0A0H,X
;// 03.06.05 //		STA	>CHGRAM+0B0H,X
;// 03.06.05 //		STA	>CHGRAM+0C0H,X
;// 03.06.05 //		STA	>CHGRAM+0D0H,X
;// 03.06.05 //		STA	>CHGRAM+0E0H,X
;// 03.06.05 //		STA	>CHGRAM+0F0H,X
;// 03.06.05 //		INC	<WORK0
;// 03.06.05 //		INC	<WORK0
;// 03.06.05 //		INX
;// 03.06.05 //		INX
;// 03.06.05 //		DEY
;// 03.06.05 //		BPL	THCG060		; BG. CG. set end ?
;// 03.06.05 //;					; yes
;// 03.06.05 //		PLA			; (A) pull
;// 03.06.05 //		CLC
;// 03.06.05 //		ADC	#00006H
;// 03.06.05 //		STA	<WORK0
;// 03.06.05 //		LDA	[<WORK0]
;// 03.06.05 //		STA	>CGWORK+000H
;// 03.06.05 //;
;// 03.06.05 //		PLY			; (Y) pull
;// 03.06.05 //		TYX			; (X) <-- (Y)
;// 03.06.05 //		LDA	>CGLPT71,X
;// 03.06.05 //		CLC
;// 03.06.05 //		ADC	#ENMYOBJ
;// 03.06.05 //		STA	<WORK0
;// 03.06.05 //;
;// 03.06.05 //		LDX	#00300H
;// 03.06.05 //		LDY	#00007H
;// 03.06.05 //THCG080		EQU	$
;// 03.06.05 //		LDA	[<WORK0]
;// 03.06.05 //		STA	>CHGRAM+060H,X
;// 03.06.05 //		STA	>CHGRAM+080H,X
;// 03.06.05 //		STA	>CHGRAM+0A0H,X
;// 03.06.05 //		STA	>CHGRAM+0F0H,X
;// 03.06.05 //		INC	<WORK0
;// 03.06.05 //		INC	<WORK0
;// 03.06.05 //		INX
;// 03.06.05 //		INX
;// 03.06.05 //		DEY
;// 03.06.05 //		BPL	THCG080		; BG. CG. set end ?
;// 03.06.05 //;					; yes
		MEM8
		IDX8
		SEP	#00110000B	; memory 16bit mode
		RTL
;
;
; 
;************************************************************************
;*		Thunder CG. change			(THCGCN2)	*
;************************************************************************
THCGCN2		EQU	$
		MEM16
		IDX16
		REP	#00110000B	; memory,index 16bit mode
;
		LDX	#0007EH
THCG240		EQU	$
		LDA	>CGRAM+000H,X
		STA	>CGWORK+000H,X
		LDA	>CGRAM+080H,X
		STA	>CGWORK+080H,X
		LDA	>CGRAM+100H,X
		STA	>CGWORK+100H,X
		LDA	>CGRAM+180H,X
		STA	>CGWORK+180H,X
		DEX
		DEX
		BPL	THCG240		; reset end ?
;					; yes
		MEM8
		IDX8
		SEP	#00110000B	; memory 16bit mode
;
		INC	<CGVMAF		; CG. change
		RTL
;
;
;
;************************************************************************
;*		Mode<7> character set			(M7CHST)	*
;************************************************************************
M7CHST		EQU	$
		LDA	#01BH
		STA	<WORK2		; mode<7> char B address
;
		LDA	#10000000B
		STA	2115H
		STZ	2116H
		STZ	2117H		; Vram address
;
		IDX16
		REP	#00010000B	; index 16bit mode
;
		LDY	#08000H
		STY	<WORK0		; mode<7> char L,H address
;
		LDY	#000000H
M7CH400		EQU	$
		LDA	[<WORK0],Y
		STA	2119H		; Vram charcter set
		INY
		LDA	[<WORK0],Y
		STA	2119H		; Vram charcter set
		INY
		LDA	[<WORK0],Y
		STA	2119H		; Vram charcter set
		INY
		LDA	[<WORK0],Y
		STA	2119H		; Vram charcter set
		INY
		CPY	#04000H
		BNE	M7CH400		; set end ?
;					; yes
		IDX8
		SEP	#00010000B	; index 8bit mode
		RTL
;
;
;
;
;
;
;
; 
		MEM8
		IDX8
;************************************************************************
;*		Message char. Vramd set			(MSGVRMS)	*
;************************************************************************
MSGVRMS		EQU	$
		LDA	#00000010B
		STA	2101H		; obj size,address set
		LDA	#10000000B
		STA	2115H		; inc. mode
;
;
;<<<<< OBJ. 3bit set  >>>>>
		STZ	2116H
		LDA	#050H
		STA	2117H		; Vram address (05000H)
;
		PHB
		PHK
		PLB			; (DBR) set
;
		LDY	#C_4O0
		JSR	CADWKST2	; char. address work set
		REP	#00100000B	; memory 16bit mode
		LDY	#03FH
		JSR	CHST800		; ken,tate set
;
		LDY	#C_4O1
		JSR	CADWKST2	; char. address work set
		REP	#00100000B	; memory 16bit mode
		LDY	#03FH
		JSR	CHST800		; ken,tate set
;
		PLB			; (DBR) reset
;
;
;<<<<< BG. 2bit set (BG3) >>>>>
		LDA	#BANK GDBUF0
		STA	<WORK2
;
		MEM16
		IDX16
		REP	#00110000B	; memory,index 16bit mode
;
		LDA	#07000H
		STA	2116H		; Vram address (07000H)
;
		LDA	#GDBUF0
		STA	<WORK0
;
		LDX	#(0100H+00A0H)*10H/2-1
MVMS40	 	EQU	$
		LDA	[<WORK0]
		STA	2118H
		INC	<WORK0
		INC	<WORK0
		DEX
		BPL	MVMS40
;
		MEM8
		IDX8
		SEP	#00110000B	; memory,index 8bit mode
;
		PHB
		PHK
		PLB			; (DBR) set
;
		LDY	#C_4X
		JSR	CADWKST2	; char. address work set
;
		MEM16
		IDX16
		REP	#00110000B	; memory,index 16bit mode
;
		LDX	#(0100H-00A0H)*10H/2-1
MVMS80		EQU	$
		LDA	[<WORK0]
		STA	2118H
		INC	<WORK0
		INC	<WORK0
		DEX
		BPL	MVMS80		; set end ?
;					; yes
		MEM8
		IDX8
		SEP	#00110000B	; memory,index 8bit mode
;
		PLB			; (DBR) reset
		RTL
;
;
;************************************************************************
;*		Message char. Vramd set			(MSGVRMS1)	*
;************************************************************************
MSGVRMS1	EQU	$
		LDA	#00000010B
		STA	2101H		; obj size,address set
		LDA	#10000000B
		STA	2115H		; inc. mode
;
;<<<<< BG. 2bit set (BG3) >>>>>
		LDA	#BANK GDBUF0
		STA	<WORK2
;
		MEM16
		REP	#00100000B	; memory 16bit mode
;
		LDA	#07000H
		STA	2116H		; Vram address (07000H)
;
		LDA	#GDBUF0
		STA	<WORK0
;
		LDA	[<WORK0]
		STA	2118H
;
		MEM8
		SEP	#00100000B	; memory 8bit mode
		RTL
;
;
;
;=========================================================================
;=========================================================================
;=========================================================================
;
		MEM8
		IDX8
;*************************************************************************
;*	 Y ----- flg  0~						 *
;*************************************************************************
CHSET		EQU	$
		STZ	<WORK0
		STX	<WORK1
;
		PHY			; (Y) push
;// 03.05.29 //		JSR	CADWKST2	; char. address work set
		JSR	CADWS300	; char. address work set
;
		MEM16
		REP	#00100000B	; memory 16bit mode
;
		LDY	#03FH
		PLX			; (X) <-- (Y) pull
;// 03.05.28 //CHST000 	EQU	$
;// 03.05.28 //		LDX	<WORKF
;// 03.05.28 //;// 03.03.19 //		LDA	>CHCHTB+4,X
;// 03.05.28 //;// 03.03.19 //		AND	#000FFH
;// 03.05.28 //		LDA	<WORK6,X
;// 03.05.28 //		AND	#000FFH
;// 03.05.28 //		CMP	#C_4I0
		CPX	#C_4I0
		BEQ	CHST800		; 8~F color ?
;					; no
;// 03.05.28 //		CMP	#C_4I1
		CPX	#C_4I1
		BEQ	CHST800		; 8~F color ?
;					; no
;// 03.05.28 //		CMP	#C_4M0
		CPX	#C_4M0
		BEQ	CHST800		; 8~F color ?
;					; no
;// 03.05.28 //		CMP	#C_4M1
		CPX	#C_4M1
		BEQ	CHST800		; 8~F color ?
;					; no
;// 03.05.28 //		CMP	#C_4O0
		CPX	#C_4O0
		BEQ	CHST800		; 8~F color ?
;					; no
;// 03.05.28 //		CMP	#C_4O1
		CPX	#C_4O1
		BEQ	CHST800		; 8~F color ?
;					; no
;// 03.05.31 //CHST050		EQU	$
		JMP	CHS0100
;// 03.05.17 //		LDX	#000H
;// 03.05.17 //CHST100 	EQU	$
;// 03.05.17 //		LDA	[<WORK0]
;// 03.05.17 //		STA	2118H
;// 03.05.17 //		INC	<WORK0
;// 03.05.17 //		INC	<WORK0
;// 03.05.17 //		LDA	[<WORK0]
;// 03.05.17 //		STA	2118H
;// 03.05.17 //		INC	<WORK0
;// 03.05.17 //		INC	<WORK0
;// 03.05.17 //		LDA	[<WORK0]
;// 03.05.17 //		STA	2118H
;// 03.05.17 //		INC	<WORK0
;// 03.05.17 //		INC	<WORK0
;// 03.05.17 //		LDA	[<WORK0]
;// 03.05.17 //		STA	2118H
;// 03.05.17 //		INC	<WORK0
;// 03.05.17 //		INC	<WORK0
;// 03.05.17 //		DEX
;// 03.05.17 //		BPL	CHST100
;// 03.05.17 //;
;// 03.05.17 //		LDX	#000H
;// 03.05.17 //CHST500 	EQU	$
;// 03.05.17 //		LDA	[<WORK0]
;// 03.05.17 //		AND	#00FFH
;// 03.05.17 //		STA	2118H
;// 03.05.17 //		INC	<WORK0
;// 03.05.17 //		LDA	[<WORK0]
;// 03.05.17 //		AND	#00FFH
;// 03.05.17 //		STA	2118H
;// 03.05.17 //		INC	<WORK0
;// 03.05.17 //		LDA	[<WORK0]
;// 03.05.17 //		AND	#00FFH
;// 03.05.17 //		STA	2118H
;// 03.05.17 //		INC	<WORK0
;// 03.05.17 //		LDA	[<WORK0]
;// 03.05.17 //		AND	#00FFH
;// 03.05.17 //		STA	2118H
;// 03.05.17 //		INC	<WORK0
;// 03.05.17 //		DEX
;// 03.05.17 //		BPL	CHST500
;// 03.05.17 //;
;// 03.05.17 //		DEY
;// 03.05.17 //		BPL	CHST050		; end ?
;// 03.05.17 //;					; yes
;// 03.05.17 //		MEM8
;// 03.05.17 //		SEP	#00100000B	; memory 8bit mode
;// 03.05.17 //		RTS
;
		MEM16
CHS0300 	EQU	$
CHST800 	EQU	$
		LDX	#00EH
CHST820 	EQU	$
		LDA	[<WORK0]
		STA	2118H
		XBA
		ORA	[<WORK0]
		AND	#000FFH
		STA	<BFP000,X
		INC	<WORK0
		INC	<WORK0
		DEX
		DEX
		LDA	[<WORK0]
		STA	2118H
		XBA
		ORA	[<WORK0]
		AND	#000FFH
		STA	<BFP000,X
		INC	<WORK0
		INC	<WORK0
		DEX
		DEX
		BPL	CHST820
;
		LDX	#00EH
CHST860 	EQU	$
		LDA	[<WORK0]
		AND	#000FFH
		STA	<WORKZ
		ORA	<BFP000,X
		XBA
		ORA	<WORKZ
		STA	2118H
		INC	<WORK0
		DEX
		DEX
		LDA	[<WORK0]
		AND	#000FFH
		STA	<WORKZ
		ORA	<BFP000,X
		XBA
		ORA	<WORKZ
		STA	2118H
		INC	<WORK0
		DEX
		DEX
		BPL	CHST860
;
		DEY
		BPL	CHST800		; end ?
;					; yes
		MEM8
		SEP	#00100000B	; memory 8bit mode
		RTS
;
;
;*************************************************************************
;*	 Y ----- flg  0~						 *
;*************************************************************************
CHSET0		EQU	$
		LDA	#BANK MPCHBF
		LDX	#HIGH MPCHBF
;// 03.05.31 //		LDA	#LOW MPCHBF
CHS0000		EQU	$
		STZ	<WORK0		; LOW
		STX	<WORK1		; HIGH
		STA	<WORK2		; BANK
;
		JSR	CADWS100	; char. address work set
CHS0010		EQU	$
		MEM16
		REP	#00100000B	; memory 16bit mode
;
		LDY	#03FH 
		LDX	!CHIKNO
;// 03.05.31 //		CPX	#020H
;// 03.05.31 //		BNE	CHS0020		; select-map ?
;// 03.05.31 //;					; yes
;// 03.05.31 //		LDX	<WORKF
;// 03.05.31 //		CPX	#004H
;// 03.05.31 //		BEQ	CHS0030		; 8-F character ?
;// 03.05.31 //;					; no
;// 03.05.31 //		CPX	#003H
;// 03.05.31 //		BEQ	CHS0030		; 8-F character ?
;// 03.05.31 //;					; no
;// 03.05.31 //		BRA	CHS0100
;// 03.05.31 //;
;// 03.05.31 //CHS0020		EQU	$
		CPX	#010H
		BCC	CHS0040		; ground ?
;					; yes
		LDX	<WORKF
		CPX	#007H
		BEQ	CHS0300		; 8-F character ?
;					; no
		CPX	#002H
		BEQ	CHS0300		; 8-F character ?
;					; no
		CPX	#004H
		BEQ	CHS0300		; 8-F character ?
;					; no
		CPX	#003H
		BNE	CHS0100		; 8-F character ?
;					; yes
CHS0030		EQU	$
		JMP	CHS0300
;
CHS0040		EQU	$
		LDX	<WORKF
		CPX	#006H
		BEQ	CHS0030		; 8-F character ?
;					; no
		CPX	#005H
		BEQ	CHS0030		; 8-F character ?
;					; no
		CPX	#004H
		BEQ	CHS0030		; 8-F character ?
;					; no
CHS0100 	EQU	$
;// 03.05.17 //		LDX	#000H
;// 03.05.17 //CHS0120 	EQU	$
		LDA	[<WORK0]
		STA	2118H
		INC	<WORK0
		INC	<WORK0
		LDA	[<WORK0]
		STA	2118H
		INC	<WORK0
		INC	<WORK0
		LDA	[<WORK0]
		STA	2118H
		INC	<WORK0
		INC	<WORK0
		LDA	[<WORK0]
		STA	2118H
		INC	<WORK0
		INC	<WORK0
		LDA	[<WORK0]
		STA	2118H
		INC	<WORK0
		INC	<WORK0
		LDA	[<WORK0]
		STA	2118H
		INC	<WORK0
		INC	<WORK0
		LDA	[<WORK0]
		STA	2118H
		INC	<WORK0
		INC	<WORK0
		LDA	[<WORK0]
		STA	2118H
		INC	<WORK0
		INC	<WORK0
;// 03.05.17 //		DEX
;// 03.05.17 //		BPL	CHS0120
;
		LDX	#001H
CHS0160 	EQU	$
		LDA	[<WORK0]
		AND	#000FFH
		STA	2118H
		INC	<WORK0
		LDA	[<WORK0]
		AND	#000FFH
		STA	2118H
		INC	<WORK0
		LDA	[<WORK0]
		AND	#000FFH
		STA	2118H
		INC	<WORK0
		LDA	[<WORK0]
		AND	#000FFH
		STA	2118H
		INC	<WORK0
		DEX
		BPL	CHS0160
;
		DEY
		BPL	CHS0100
;
		MEM8
		SEP	#00100000B	; memory 8bit mode
		RTS
;
;
;// 03.05.17 //		MEM16
;// 03.05.17 //CHS0300 	EQU	$
;// 03.05.17 //		LDX	#00EH
;// 03.05.17 //CHS0320 	EQU	$
;// 03.05.17 //		LDA	[<WORK0]
;// 03.05.17 //		STA	2118H
;// 03.05.17 //		XBA
;// 03.05.17 //		ORA	[<WORK0]
;// 03.05.17 //		AND	#000FFH
;// 03.05.17 //		STA	<BFP000,X
;// 03.05.17 //		INC	<WORK0
;// 03.05.17 //		INC	<WORK0
;// 03.05.17 //		DEX
;// 03.05.17 //		DEX
;// 03.05.17 //		LDA	[<WORK0]
;// 03.05.17 //		STA	2118H
;// 03.05.17 //		XBA
;// 03.05.17 //		ORA	[<WORK0]
;// 03.05.17 //		AND	#000FFH
;// 03.05.17 //		STA	<BFP000,X
;// 03.05.17 //		INC	<WORK0
;// 03.05.17 //		INC	<WORK0
;// 03.05.17 //		DEX
;// 03.05.17 //		DEX
;// 03.05.17 //		BPL	CHS0320
;// 03.05.17 //;
;// 03.05.17 //		LDX	#0EH
;// 03.05.17 //CHS0360 	EQU	$
;// 03.05.17 //		LDA	[<WORK0]
;// 03.05.17 //		AND	#000FFH
;// 03.05.17 //		STA	<WORKZ
;// 03.05.17 //		ORA	<BFP000,X
;// 03.05.17 //		XBA
;// 03.05.17 //		ORA	<WORKZ
;// 03.05.17 //		STA	2118H
;// 03.05.17 //		INC	<WORK0
;// 03.05.17 //		DEX
;// 03.05.17 //		DEX
;// 03.05.17 //		LDA	[<WORK0]
;// 03.05.17 //		AND	#000FFH
;// 03.05.17 //		STA	<WORKZ
;// 03.05.17 //		ORA	<BFP000,X
;// 03.05.17 //		XBA
;// 03.05.17 //		ORA	<WORKZ
;// 03.05.17 //		STA	2118H
;// 03.05.17 //		INC	<WORK0
;// 03.05.17 //		DEX
;// 03.05.17 //		DEX
;// 03.05.17 //		BPL	CHS0360
;// 03.05.17 //;
;// 03.05.17 //		DEY
;// 03.05.17 //		BPL	CHS0300		; end ?
;// 03.05.17 //;					; yes
;// 03.05.17 //		MEM8
;// 03.05.17 //		SEP	#00100000B	; memory 8bit mode
;// 03.05.17 //		RTS
;// 03.05.17 //;
;
;
;
;*************************************************************************
;*    obj 2bit CH set							*
;*************************************************************************
CHSET1		EQU	$
		LDY	!OJBSPT
		LDA	OCADB,Y 
		STA	<WORK2
		LDA	OCADH,Y
		STA	<WORK1
		LDA	OCADL,Y
		STA	<WORK0
;
		MEM16
		REP	#00100000B	; memory 16bit mode
;
		LDY	#040H
CHS1200 	EQU	$
		LDX	#00EH
CHS1240 	EQU	$
		LDA	[<WORK0]
		STA	2118H
		XBA
		ORA	[<WORK0]
		AND	#000FFH
		STA	<BFP000,X
		INC	<WORK0
		INC	<WORK0
		DEX
		DEX
		LDA	[<WORK0]
		STA	2118H
		XBA
		ORA	[<WORK0]
		AND	#000FFH
		STA	<BFP000,X
		INC	<WORK0
		INC	<WORK0
		DEX
		DEX
		BPL	CHS1240
;
		LDX	#00EH
CHS1280 	EQU	$
		LDA	[<WORK0]
		AND	#000FFH
		STA	<WORKZ
		ORA	<BFP000,X
		XBA
		ORA	<WORKZ
		STA	2118H
		INC	<WORK0
		DEX
		DEX
		LDA	[<WORK0]
		AND	#000FFH
		STA	<WORKZ
		ORA	<BFP000,X
		XBA
		ORA	<WORKZ
		STA	2118H
		INC	<WORK0
		DEX
		DEX
		BPL	CHS1280
;
		DEY
		BNE	CHS1200		; 0-7 char. ?
;					; yes
;
		MEM8
		SEP	#00100000B	; memory 8bit mode
;
		LDA	<SLMODE
		BEQ	TCHSET1
;
		LDY	#C_2U0
		LDA	OCADB,Y 
		STA	<WORK2
		LDA	OCADH,Y
		STA	<WORK1
		LDA	OCADL,Y
		STA	<WORK0
;
		MEM16
		REP	#00100000B	; memory 16bit mode
;
;// 03.05.20 //		LDY	#080H
		LDY	#07FH
		JMP	CHS0100
;// 03.05.20 //CHS1300 	EQU	$
;// 03.05.20 //		LDX	#007H
;// 03.05.20 //CHS1340 	EQU	$ 
;// 03.05.20 //		LDA	[<WORK0]
;// 03.05.20 //		STA	2118H
;// 03.05.20 //		INC	<WORK0
;// 03.05.20 //		INC	<WORK0
;// 03.05.20 //;// 03.02.28 //		BNE	CHS1360		; bank change ?
;// 03.05.20 //;// 03.02.28 //;					; yes
;// 03.05.20 //;// 03.02.28 //		LDA	#08000H
;// 03.05.20 //;// 03.02.28 //		STA	<WORK0
;// 03.05.20 //;// 03.02.28 //		INC	<WORK2
;// 03.05.20 //;// 03.02.28 //CHS1360		EQU	$
;// 03.05.20 //;// 03.02.28 //		DEX
;// 03.05.20 //		DEX
;// 03.05.20 //		BPL	CHS1340
;// 03.05.20 //;
;// 03.05.20 //		LDX	#007H
;// 03.05.20 //CHS1380 	EQU	$
;// 03.05.20 //		LDA	[<WORK0]
;// 03.05.20 //		AND	#000FFH
;// 03.05.20 //		STA	2118H
;// 03.05.20 //		INC	<WORK0
;// 03.05.20 //;// 03.02.28 //		BNE	CHS1390		; bank change ?
;// 03.05.20 //;// 03.02.28 //;					; yes
;// 03.05.20 //;// 03.02.28 //		LDA	#08000H
;// 03.05.20 //;// 03.02.28 //		STA	<WORK0
;// 03.05.20 //;// 03.02.28 //		INC	<WORK2
;// 03.05.20 //;// 03.02.28 //CHS1390		EQU	$
;// 03.05.20 //;// 03.02.28 //		DEX
;// 03.05.20 //		DEX
;// 03.05.20 //		BPL	CHS1380
;// 03.05.20 //;
;// 03.05.20 //		DEY
;// 03.05.20 //		BNE	CHS1300 	; end ?
;// 03.05.20 //;					; yes
;// 03.05.20 //		MEM8
;// 03.05.20 //		SEP	#00100000B	; memory 8bit mode
;// 03.05.20 //		RTS
;
;
;
		MEM8
TCHSET1		EQU	$
		STZ	<WORKF
		LDY	#C_4O0
		STY	<WORK6
		LDA	#BANK MPCHBF
		STA	<WORK2
;// 03.05.31 //		LDA	#LOW MPCHBF
		LDX	#HIGH MPCHBF
		JSR	CHSET
;
		LDY	#C_4O1
		STY	<WORK6
;// 03.05.31 //		LDA	#LOW MPCHBF
		LDX	#HIGH MPCHBF
		JMP	CHSET
;
;
;
;************************************************************************
;*		Map data buffer set			(MPDTBFST)	*
;************************************************************************
MPDTBFST	EQU	$
		JSR	CHREAD
		RTL
;
;
;
;************************************************************************
;*		OBJ. Character data address work set	(CADWKST3)	*
;************************************************************************
CADWKST3	EQU	$
;// 03.05.31 //		LDA	#LOW MPCHBF+600H
		STZ	<WORK0
		LDA	#HIGH MPCHBF+600H
		STA	<WORK1
		LDA	#BANK MPCHBF+600H
		BRA	CADWS40
;
;
;************************************************************************
;*		OBJ. Character data address work set	(CADWKST2)	*
;************************************************************************
CADWKST2	EQU	$
;// 03.05.31 //		LDA	#LOW MPCHBF
		STZ	<WORK0
		LDA	#HIGH MPCHBF
		STA	<WORK1
		LDA	#BANK MPCHBF
CADWS40		EQU	$
		STA	<WORK2
		STA	<WORK5
CADWS300	EQU	$
		LDA	OCADB,Y 
		STA	<CWORK2
		LDA	OCADH,Y
		STA	<CWORK1
		LDA	OCADL,Y
		STA	<CWORK0
		BRA	CHREAD
;
;
;************************************************************************
;*		BG. Character data address work set	(CADWKST0)	*
;************************************************************************
CADWKST0	EQU	$
;// 03.05.31 //		LDA	#LOW MPCHBF
		STZ	<WORK0
		LDA	#HIGH MPCHBF
		STA	<WORK1
		LDA	#BANK MPCHBF
CADWS040	EQU	$
		STA	<WORK2
		STA	<WORK5
CADWS100	EQU	$
		LDA	BCADB,Y 
		STA	<CWORK2
		LDA	BCADH,Y
		STA	<CWORK1
		LDA	BCADL,Y
		STA	<CWORK0
;
;************************************************************************
;*		Character buffer set			(CHRREAD)	*
;*		[in]	(cwork0,1,2)	<-- char. bit    address	*
;*			(work0,1,2)	<-- char. data   address	*
;************************************************************************
CHREAD		EQU	$
		IDX16
		REP	#00010000B	; index 16 bit mode
;
		LDY	#00000H		; (Y) <-- chara data buffer index
GTCODE		EQU	$
		JSR	GET1DT		; 1 data read
		CMP	#0FFH
		BNE	GTCOD1		; end ?
;					; yes
		SEP	#00010000B	; index 8 bit mode 
		RTS
;
GTCOD1		EQU	$
		STA	<CWORK5
		AND	#0E0H
		CMP	#0E0H
		BEQ	GT2COD		; 2 byte code ?
;					; no
		PHA			; (A) push : data type save
		LDA	<CWORK5
;
		MEM16
		REP	#00100000B	; memory 16 bit mode
;
		AND	#0001FH
		BRA	GT2CD2
;
		MEM8
GT2COD		EQU	$
		LDA	<CWORK5
		ASL	A
		ASL	A
		ASL	A
		AND	#0E0H
		PHA			; (A) push : data type save
		LDA	<CWORK5
		AND	#003H
		XBA
		JSR	GET1DT		; 1 data read
;
		MEM16
		REP	#00100000B	; memory 16 bit mode
GT2CD2		EQU	$
		INC	A
		STA	<CWORK3
;
		MEM8
		SEP	#00100000B	; memory 8 bit mode
GTCDEN		EQU	$
		PLA			; (A) pull : data type load
		BEQ	NORM		; [ CMP #000H ] = ?
;					; no
		BMI	REF		; [ CMP #1xxH ] > ?
;					; no
		ASL	A
		BPL	REN1		; [ CMP #020H ] > ?
;					; no
		ASL	A
		BPL	REN2		; [ CMP #040H ] > ?
;					; no
REN12		EQU	$
		JSR	GET1DT		; 1 data read
		LDX	<CWORK3
REN121		EQU	$
		STA	[<WORK],Y
		INC	A
		INY
		DEX
		BNE	REN121		; end ?
;					; yes
		BRA	GTCODE
;
NORM		EQU	$
		JSR	GET1DT		; 1 data read
		STA	[<WORK],Y
		INY
		LDX	<CWORK3
		DEX
		STX	<CWORK3
		BNE	NORM		; end ?
;					; yes
		BRA	GTCODE
;
REN1		EQU	$
		JSR	GET1DT		; 1 data read
		LDX	<CWORK3
REN11		EQU	$
		STA	[<WORK],Y
		INY
		DEX
		BNE	REN11		; end ?
;					; yes
		BRA	GTCODE
;
REN2		EQU	$
		JSR	GET1DT		; 1 data read
		XBA
		JSR	GET1DT		; 1 data read
		LDX	<CWORK3
REN21		EQU	$
		XBA
		STA	[<WORK],Y
		INY
		DEX
		BEQ	REN22		; end ?
;					; no
		XBA
		STA	[<WORK],Y
		INY
		DEX
		BNE	REN21 
REN22		EQU	$
		JMP	GTCODE
;
REF		EQU	$
		JSR	GET1DT		; 1 data read
		XBA
		JSR	GET1DT		; 1 data read
;// 02.12.21 //		XBA
		TAX
REF1		EQU	$
		PHY
		TXY
		LDA	[<WORK],Y
		TYX
		PLY
		STA	[<WORK],Y
		INY
		INX
;
		MEM16
		REP	#00100000B	; memory 16 bit mode 
;
		DEC	<CWORK3
;
		MEM8
		SEP	#00100000B	; memory 8 bit mode
;
		BNE	REF1		; end ?
;					; yes
		JMP	GTCODE
;
GET1DT		EQU	$
		LDA	[<CWORK0]
		LDX	<CWORK0
		INX
		BNE	GT1DT1		; (c) on ?
;					; yes
		LDX	#08000H
		INC	<CWORK2
GT1DT1		EQU	$
		STX	<CWORK0
		RTS
;
;
;
;
;
;
;
;\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
; 
; 
; 
;CGDATA 
; 
;cgdata.asm  (H3.06.05 14:28)
CORGENE		EQU	$
                BYTE    0FFH,07FH,0D9H,008H,007H,01EH,0CAH,04AH,0A5H,014H,03FH,013H,0DFH,019H,000H,000H
                BYTE    0FFH,07FH,079H,019H,0B6H,014H,0DCH,039H,0A5H,014H,0F7H,066H,0EFH,045H,0FFH,07FH
                BYTE    049H,069H,0ECH,062H,0F4H,06FH,0A5H,014H,051H,07FH,04FH,07EH,000H,000H,0FFH,07FH
                BYTE    01FH,05AH,089H,051H,0D3H,076H,0A5H,014H,0DFH,02AH,097H,015H,0FFH,07FH,0F6H,01AH
                BYTE    075H,011H,09EH,036H,0A5H,014H,0FEH,059H,017H,03DH,000H,000H,0A5H,014H,0A5H,014H
                BYTE    0A5H,014H,0A5H,014H,0A5H,014H,0A5H,014H,0A5H,014H,0FFH,07FH,07BH,018H,075H,011H
                BYTE    09EH,036H,0A5H,014H,056H,07EH,0CAH,065H,000H,000H,0FFH,07FH,05CH,029H,049H,01AH
                BYTE    074H,03FH,0A5H,014H,05FH,01FH,037H,012H,0FFH,07FH,0D9H,008H,090H,01DH,036H,02EH
                BYTE    0A5H,014H,03FH,013H,0DFH,019H,000H,000H,0FFH,07FH,079H,019H,0B6H,014H,0DCH,039H
                BYTE    0A5H,014H,0F7H,066H,0EFH,045H,0FFH,07FH,0A8H,059H,0EEH,056H,0B3H,06BH,0A5H,014H
                BYTE    035H,07FH,02EH,062H,000H,000H,0FFH,07FH,01FH,05AH,089H,051H,0D3H,076H,0A5H,014H
                BYTE    0DFH,02AH,097H,015H,0FFH,07FH,0FBH,00EH,075H,011H,09EH,036H,0A5H,014H,02CH,04FH
                BYTE    066H,036H,000H,000H,0A5H,014H,0A5H,014H,0A5H,014H,0A5H,014H,0A5H,014H,0A5H,014H
                BYTE    0A5H,014H,0FFH,07FH,07BH,018H,075H,011H,09EH,036H,0A5H,014H,056H,07EH,0CAH,065H
                BYTE    000H,000H,0FFH,07FH,05CH,029H,049H,01AH,074H,03FH,0A5H,014H,05FH,01FH,037H,012H
                BYTE    0FFH,07FH,07AH,02BH,0B7H,011H,09EH,036H,0A5H,014H,04DH,04FH,046H,046H,0FFH,001H
                BYTE    046H,026H,089H,03FH,078H,010H,09DH,059H,05CH,02AH,071H,015H,000H,000H,0FFH,07FH
                BYTE    07AH,02BH,0B7H,011H,09EH,036H,0A5H,014H,04DH,04FH,046H,046H,0FFH,001H,028H,061H
                BYTE    0B2H,07AH,078H,010H,09DH,059H,05CH,02AH,0B6H,011H,000H,000H,0FFH,07FH,07AH,02BH
                BYTE    0B7H,011H,09EH,036H,0A5H,014H,04DH,04FH,046H,046H,0FFH,001H,057H,010H,07EH,03DH
                BYTE    078H,010H,09DH,059H,05CH,02AH,0C9H,019H,000H,000H,0FFH,07FH,07AH,02BH,0DAH,011H
                BYTE    09EH,036H,0A5H,014H,04DH,04FH,046H,046H,0FFH,001H,046H,026H,089H,03FH,078H,010H
                BYTE    097H,03DH,07EH,056H,0B2H,020H,000H,000H,000H,000H,0FAH,00EH,0D1H,07DH,000H,000H
                BYTE    01AH,07FH,000H,000H,01AH,07FH,01AH,07FH,0D1H,07DH,0A7H,040H,0D1H,07DH,0A7H,040H
                BYTE    0D1H,07DH,0CFH,050H,0FFH,07FH,0C6H,010H,014H,012H,03DH,03BH,0DEH,066H,019H,052H
                BYTE    0EDH,042H,029H,026H,037H,047H,047H,015H,058H,02DH,03DH,046H,0A5H,014H,070H,02EH
                BYTE    0AAH,021H,0F1H,025H,009H,00DH,02AH,051H,051H,072H,0A5H,014H,0CFH,021H,04BH,019H
                BYTE    04AH,029H,0ADH,04DH,073H,072H,07BH,07FH,008H,025H,03FH,037H,0DFH,019H,0FFH,07FH
                BYTE    000H,000H,0D0H,02DH,0F9H,052H,0ADH,04DH,0ADH,04DH,0ADH,04DH,079H,04FH,078H,02DH
                BYTE    0BFH,07DH,0BFH,07DH,0A5H,014H,091H,032H,0CBH,021H,0ADH,04DH,0ADH,04DH,0ADH,04DH
                BYTE    0ADH,04DH,0ADH,04DH,0ADH,04DH,0ADH,04DH,0ADH,04DH,0ADH,04DH,0ADH,04DH,0ADH,04DH
                BYTE    0ADH,04DH,0ADH,04DH,0ADH,04DH,0ADH,04DH,0ADH,04DH,0ADH,04DH,0ADH,04DH,0ADH,04DH
                BYTE    0ADH,04DH,0ADH,04DH,0ADH,04DH,0ADH,04DH,0ADH,04DH,0ADH,04DH,0ADH,04DH,0ADH,04DH
                BYTE    0ADH,04DH,0ADH,04DH,0ADH,04DH,0ADH,04DH,0ADH,04DH,0ADH,04DH,0ADH,04DH,0ADH,04DH
                BYTE    0ADH,04DH,0ADH,04DH,0ADH,04DH,0ADH,04DH,0ADH,04DH,0ADH,04DH,0ADH,04DH,0FFH,07FH
                BYTE    000H,000H,000H,000H,01FH,07EH,0B0H,061H,0D9H,07AH,0F4H,05DH,0FFH,07FH,000H,000H
                BYTE    000H,000H,000H,000H,0E0H,01EH,0FEH,003H,0E0H,03FH,0FFH,07FH,000H,000H,000H,000H
                BYTE    000H,000H,01FH,001H,0DFH,003H,0FFH,001H,0FFH,07FH,000H,000H,000H,000H,000H,000H
                BYTE    010H,078H,07FH,07FH,017H,07CH,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H
                BYTE    000H,000H,000H,000H,0A5H,014H,089H,060H,030H,075H,031H,072H,039H,07FH,049H,065H
                BYTE    007H,065H,0A5H,014H,012H,05BH,0D8H,073H,005H,016H,0C6H,01AH,049H,042H,037H,02EH
                BYTE    0A5H,014H,00AH,03AH,0EFH,04AH,0AFH,019H,073H,022H,0E6H,014H,037H,02EH,048H,008H
                BYTE    097H,026H,07FH,047H,0DAH,031H,09FH,04AH,08FH,005H,032H,027H,048H,008H,08FH,005H
                BYTE    097H,026H,0F7H,019H,0BBH,032H,048H,008H,05CH,04FH,0A5H,014H,04AH,029H,073H,04EH
                BYTE    09CH,073H,00CH,03EH,03FH,017H,0DAH,025H,0FFH,07FH,014H,07BH,075H,034H,07CH,055H
                BYTE    0A5H,014H,0BFH,002H,05DH,011H,0FFH,07FH,0DBH,032H,0B6H,000H,03EH,026H,0A5H,014H
                BYTE    094H,056H,0ADH,039H,0FFH,07FH,030H,005H,02AH,051H,051H,072H,0A5H,014H,01FH,013H
                BYTE    0F6H,00DH,0FFH,07FH,0FFH,00EH,075H,011H,09EH,036H,0A5H,014H,071H,01BH,060H,01EH
                BYTE    0FFH,07FH,0FBH,010H,0B4H,00DH,0FBH,02AH,0A5H,014H,04EH,003H,04AH,002H,0FFH,07FH
                BYTE    0F0H,071H,00AH,026H,0F3H,046H,0A5H,014H,0DEH,041H,078H,008H,0FFH,07FH,0FCH,008H
                BYTE    0D4H,009H,0DCH,012H,0A5H,014H,0D8H,04EH,0D1H,029H,0FFH,07FH,066H,019H,076H,00CH
                BYTE    0BBH,002H,0A5H,014H,00AH,04BH,028H,02EH,059H,07BH,0AEH,07FH,083H,05AH,02AH,06FH
                BYTE    040H,031H,09BH,07FH,059H,07BH,060H,02DH,0E2H,03DH,066H,04EH,0EAH,05EH,071H,06FH
                BYTE    0F6H,07FH,064H,03DH,0FFH,07FH,018H,000H,075H,011H,09EH,036H,0A5H,014H,01CH,023H
                BYTE    036H,016H,0FFH,07FH,0D1H,004H,007H,046H,00EH,06BH,0A5H,014H,03EH,01EH,077H,011H
                BYTE    0FFH,07FH,029H,049H,07BH,011H,0BFH,022H,0A5H,014H,073H,076H,0ADH,059H,0FFH,07FH
                BYTE    049H,02FH,0B4H,00DH,0FBH,02AH,0A5H,014H,09EH,051H,0B7H,034H,0FFH,07FH,0FBH,010H
                BYTE    036H,016H,01DH,03BH,0A5H,014H,0AFH,05EH,0C8H,041H,0FFH,07FH,09BH,036H,08BH,022H
                BYTE    072H,03FH,0A5H,014H,0BCH,035H,015H,021H,0FFH,07FH,014H,014H,0FAH,014H,03DH,012H
                BYTE    000H,000H,07FH,037H,0DFH,01EH,0FFH,07FH,05FH,05EH,072H,009H,038H,026H,0A5H,014H
                BYTE    036H,076H,02FH,051H,0FFH,07FH,063H,00DH,02BH,022H,03DH,04BH,000H,000H,073H,043H
                BYTE    08CH,026H,0FFH,07FH,090H,070H,0D5H,028H,0BEH,041H,000H,000H,099H,013H,056H,016H
                BYTE    0FFH,07FH,0D0H,008H,07BH,001H,0BFH,016H,0A5H,014H,03DH,03AH,036H,021H,0FFH,07FH
                BYTE    0D9H,008H,04AH,029H,031H,046H,0A5H,014H,05AH,06BH,073H,04EH,084H,010H,084H,010H
                BYTE    084H,010H,084H,010H,084H,010H,084H,010H,084H,010H,04AH,029H,0BDH,077H,018H,063H
                BYTE    031H,046H,0BDH,077H,031H,046H,018H,063H,0FFH,07FH,0FFH,027H,02DH,05EH,03FH,013H
                BYTE    0F4H,06FH,0D8H,024H,0F1H,07FH,0FFH,027H,09FH,01AH,03FH,003H,008H,021H,0D7H,001H
                BYTE    0C5H,019H,07FH,047H,008H,021H,036H,016H,016H,014H,01FH,073H,008H,021H,0BCH,045H
                BYTE    047H,077H,000H,000H,018H,000H,0DDH,03AH,000H,000H,000H,000H,018H,000H,0FFH,07FH
                BYTE    000H,000H,000H,000H,0BCH,002H,0FFH,07FH,000H,000H,000H,000H,0C5H,071H,0FFH,07FH
                BYTE    000H,000H,000H,000H,0C6H,018H,0FFH,07FH,000H,000H,000H,000H,0C5H,071H,01FH,037H
                BYTE    000H,000H,000H,000H,096H,00DH,03DH,043H,000H,000H,000H,000H,004H,017H,0FFH,07FH
                BYTE    000H,000H,000H,000H,046H,000H,04EH,015H,014H,02EH,000H,000H,018H,000H,0FFH,07FH
                BYTE    000H,000H,000H,000H,018H,000H,0E0H,01EH,000H,000H,000H,000H,018H,000H,07FH,01FH
                BYTE    000H,000H,000H,000H,03DH,052H,03DH,052H,03DH,052H,000H,000H,03DH,052H,03DH,052H
                BYTE    03DH,052H,000H,000H,03DH,052H,03DH,052H,03DH,052H,000H,000H,03DH,052H,03DH,052H
                BYTE    03DH,052H,09FH,06AH,0FFH,027H,094H,061H,099H,075H,099H,075H,099H,075H,099H,075H
                BYTE    000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H
                BYTE    000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,098H,04DH,07FH,06AH
                BYTE    000H,000H,0F3H,038H,05EH,062H,0FFH,076H,0BBH,056H,0F2H,023H,0E6H,043H,007H,001H
                BYTE    088H,01AH,0E8H,01BH,0FFH,07FH,0D3H,039H,0D3H,07DH,0F1H,07FH,020H,029H,086H,052H
                BYTE    090H,03FH,0F7H,05FH,0ECH,01CH,0C6H,00CH,02BH,015H,0D0H,019H,075H,036H,03BH,04FH
                BYTE    0EEH,01CH,089H,010H,0FFH,07FH,0C6H,00CH,02BH,015H,0D0H,019H,075H,036H,05DH,053H
                BYTE    0EEH,01CH,089H,010H,0A5H,014H,04AH,029H,073H,04EH,09CH,073H,087H,035H,03FH,017H
                BYTE    0DAH,025H,0FFH,07FH,0A5H,00CH,068H,031H,0CBH,03DH,00DH,046H,0CDH,018H,0D0H,019H
                BYTE    0EEH,01CH,0C6H,00CH,02BH,015H,033H,01AH,019H,03BH,0CDH,018H,0C7H,04DH,046H,045H
                BYTE    0FFH,07FH,0A5H,00CH,004H,025H,066H,031H,0A8H,039H,01FH,07CH,02BH,015H,089H,010H
                BYTE    0C6H,010H,06EH,021H,0F3H,021H,0DCH,03AH,0CDH,018H,0DEH,066H,0D9H,059H,0FFH,07FH
                BYTE    0A5H,00CH,01FH,07CH,0F5H,049H,078H,05AH,084H,034H,0D0H,019H,0EEH,01CH,0A7H,014H
                BYTE    0B5H,012H,029H,049H,09CH,073H,087H,035H,0FFH,03DH,0BCH,014H,0FFH,07FH,0A5H,00CH
                BYTE    01FH,07CH,092H,039H,015H,046H,01FH,07CH,02BH,015H,089H,010H,0C6H,00CH,02BH,015H
                BYTE    083H,030H,046H,045H,05DH,053H,004H,025H,0C7H,04DH,0FFH,07FH,0A5H,00CH,00AH,015H
                BYTE    084H,020H,01FH,07CH,01FH,07CH,01FH,07CH,0A5H,07CH,063H,014H,0C7H,02CH,009H,039H
                BYTE    0AEH,049H,074H,062H,0ECH,01CH,089H,010H,000H,000H,063H,014H,0C7H,02CH,009H,039H
                BYTE    0AEH,049H,074H,062H,0ECH,01CH,089H,010H,0A5H,014H,04AH,029H,073H,04EH,09CH,073H
                BYTE    047H,031H,03FH,017H,0DAH,025H,000H,000H,063H,014H,026H,02DH,089H,039H,0CBH,03DH
                BYTE    08BH,020H,009H,039H,0ECH,01CH,063H,014H,0C6H,02CH,029H,039H,0CEH,049H,07BH,023H
                BYTE    073H,07DH,05CH,035H,0FFH,07FH,063H,014H,0E4H,024H,026H,02DH,089H,039H,01FH,07CH
                BYTE    0C7H,02CH,089H,010H,063H,014H,00BH,01DH,090H,025H,0F4H,021H,0FEH,032H,0EFH,058H
                BYTE    0C6H,02CH,0FFH,07FH,063H,014H,0EAH,020H,02DH,029H,070H,031H,01FH,07CH,009H,039H
                BYTE    0ECH,01CH,0A7H,014H,0B5H,012H,029H,049H,09CH,073H,047H,031H,0FFH,03DH,0BCH,014H
                BYTE    0FFH,07FH,063H,014H,0A8H,020H,0CAH,020H,00BH,029H,01FH,07CH,0C7H,02CH,089H,010H
                BYTE    0FFH,07FH,0FFH,07FH,0FFH,07FH,0FFH,07FH,0FFH,07FH,0FFH,07FH,0FFH,07FH,0FFH,07FH
                BYTE    063H,010H,0C7H,028H,084H,020H,01FH,07CH,01FH,07CH,01FH,07CH,0E7H,044H,0A7H,014H
                BYTE    04FH,021H,0B3H,021H,015H,032H,0BAH,03EH,0F8H,056H,00FH,025H,0FFH,07FH,0A7H,014H
                BYTE    04FH,021H,0B3H,021H,015H,032H,0BAH,03EH,0F8H,056H,00FH,025H,0A5H,014H,04AH,029H
                BYTE    073H,04EH,09CH,073H,052H,029H,03FH,017H,0FAH,025H,0FFH,07FH,0A7H,014H,0FFH,07FH
                BYTE    0FFH,07FH,0FFH,07FH,084H,029H,093H,021H,0ECH,01CH,0A7H,014H,04FH,021H,0B3H,021H
                BYTE    058H,032H,08CH,010H,084H,02EH,083H,01DH,0FFH,07FH,0A7H,014H,0FFH,07FH,0FFH,07FH
                BYTE    0FFH,07FH,049H,019H,02EH,025H,0CAH,018H,0E9H,014H,0B1H,021H,057H,036H,09AH,03AH
                BYTE    0FFH,03BH,0D9H,056H,077H,04AH,0FFH,07FH,0A7H,014H,02DH,019H,06FH,021H,0B1H,029H
                BYTE    084H,029H,093H,021H,0ECH,01CH,0C4H,014H,075H,012H,029H,049H,09CH,073H,01FH,07CH
                BYTE    0FFH,03DH,0BCH,014H,000H,000H,0A7H,014H,048H,029H,08AH,031H,0ECH,039H,048H,029H
                BYTE    02EH,025H,0CAH,018H,0FFH,07FH,0FFH,07FH,0FFH,07FH,0FFH,07FH,0FFH,07FH,0FFH,07FH
                BYTE    0FFH,07FH,000H,000H,0A7H,014H,004H,02DH,045H,035H,01FH,07CH,0E9H,01CH,04FH,021H
                BYTE    08CH,05DH,0C4H,014H,046H,01DH,0C8H,029H,0B0H,03AH,059H,053H,007H,039H,0C6H,024H
                BYTE    000H,000H,0C4H,014H,024H,01DH,0C8H,029H,0B0H,03AH,059H,053H,007H,039H,0C6H,024H
                BYTE    0C4H,014H,06DH,02DH,094H,052H,09CH,073H,026H,031H,03FH,017H,0FAH,025H,000H,000H
                BYTE    084H,010H,005H,02DH,048H,035H,08CH,031H,01FH,07CH,0C8H,029H,007H,039H,0C4H,014H
                BYTE    046H,01DH,0C8H,029H,01FH,07CH,01FH,07CH,01FH,07CH,01FH,07CH,000H,000H,084H,010H
                BYTE    0C4H,028H,005H,02DH,029H,025H,01FH,07CH,024H,01DH,0C6H,024H,0C4H,014H,01FH,07CH
                BYTE    01FH,07CH,01FH,07CH,01FH,07CH,01FH,07CH,01FH,07CH,000H,000H,084H,010H,01FH,07CH
                BYTE    01FH,07CH,01FH,07CH,01FH,07CH,01FH,07CH,01FH,07CH,0C4H,014H,075H,012H,029H,049H
                BYTE    09CH,073H,026H,031H,0FFH,03DH,0BCH,014H,000H,000H,084H,010H,01FH,07CH,01FH,07CH
                BYTE    01FH,07CH,01FH,07CH,01FH,07CH,01FH,07CH,0C6H,024H,007H,045H,06AH,05DH,02FH,07EH
                BYTE    071H,07FH,084H,07CH,000H,070H,000H,000H,0A3H,010H,003H,019H,084H,01CH,01FH,07CH
                BYTE    01FH,07CH,01FH,07CH,007H,045H,0A5H,024H,00CH,041H,0B0H,051H,075H,066H,07DH,07BH
                BYTE    0EEH,052H,024H,03EH,0FFH,07FH,0A5H,024H,00CH,041H,0B0H,051H,075H,066H,07DH,07BH
                BYTE    0EEH,052H,024H,03EH,0A5H,014H,04AH,029H,073H,04EH,09CH,073H,00CH,03EH,0ECH,07FH
                BYTE    0E5H,05EH,0FFH,07FH,0A5H,01CH,08CH,045H,0EFH,051H,073H,05EH,0D4H,06BH,072H,063H
                BYTE    092H,06AH,00BH,02CH,013H,050H,01AH,068H,0FFH,07CH,0BFH,07DH,07FH,07EH,0FFH,07FH
                BYTE    0FFH,07FH,0A5H,01CH,00AH,041H,06CH,049H,0EFH,055H,02FH,05FH,0CCH,052H,0EFH,055H
                BYTE    00BH,02CH,013H,050H,01AH,068H,0FFH,07CH,0BFH,07DH,07FH,07EH,0FFH,07FH,0FFH,07FH
                BYTE    0A5H,01CH,08CH,045H,0EFH,051H,073H,05EH,03CH,07FH,097H,072H,0F3H,05DH,0C4H,014H
                BYTE    0B5H,012H,029H,049H,09CH,073H,01FH,07CH,0FFH,03DH,0BCH,014H,0FFH,07FH,0A5H,01CH
                BYTE    00AH,041H,06CH,049H,0EFH,055H,0B7H,073H,0D0H,05AH,00DH,04EH,0FFH,07FH,0FFH,07FH
                BYTE    0FFH,07FH,0FFH,07FH,0FFH,07FH,0FFH,07FH,0FFH,07FH,0FFH,07FH,084H,020H,0EBH,03CH
                BYTE    0A5H,048H,01FH,07CH,01FH,07CH,01FH,07CH,01FH,07CH,0A5H,00CH,0EAH,010H,04DH,019H
                BYTE    0F3H,029H,096H,03EH,047H,01DH,0C5H,014H,000H,000H,0A5H,00CH,00BH,011H,06EH,01DH
                BYTE    014H,02EH,0D8H,046H,047H,01DH,0C5H,014H,0C4H,014H,06DH,02DH,094H,052H,09CH,073H
                BYTE    0AEH,015H,03FH,017H,0FAH,025H,000H,000H,084H,010H,068H,021H,0AAH,029H,090H,021H
                BYTE    01FH,07CH,06EH,01DH,047H,01DH,0A5H,00CH,0EAH,010H,04DH,019H,0F3H,029H,01FH,07CH
                BYTE    01FH,07CH,01FH,07CH,000H,000H,084H,010H,005H,019H,067H,021H,04DH,019H,01FH,07CH
                BYTE    00BH,011H,0C5H,014H,0C4H,014H,01FH,07CH,01FH,07CH,01FH,07CH,01FH,07CH,01FH,07CH
                BYTE    01FH,07CH,000H,000H,084H,010H,0AEH,015H,0F0H,01DH,0AEH,015H,01FH,07CH,06EH,01DH
                BYTE    06AH,01DH,0C4H,014H,075H,012H,029H,049H,09CH,073H,0AEH,015H,0FFH,03DH,0BCH,014H
                BYTE    000H,000H,01FH,07CH,01FH,07CH,01FH,07CH,01FH,07CH,01FH,07CH,00BH,011H,0E7H,01CH
                BYTE    0C6H,024H,007H,045H,06AH,05DH,02FH,07EH,071H,07FH,084H,07CH,000H,070H,000H,000H
                BYTE    0A3H,010H,003H,019H,084H,020H,01FH,07CH,01FH,07CH,01FH,07CH,0A5H,07CH,01FH,07CH
                BYTE    01FH,07CH,01FH,07CH,01FH,07CH,01FH,07CH,01FH,07CH,01FH,07CH,000H,000H,01FH,07CH
                BYTE    01FH,07CH,01FH,07CH,01FH,07CH,01FH,07CH,01FH,07CH,01FH,07CH,01FH,07CH,01FH,07CH
                BYTE    01FH,07CH,01FH,07CH,01FH,07CH,01FH,07CH,01FH,07CH,000H,000H,01FH,07CH,01FH,07CH
                BYTE    01FH,07CH,01FH,07CH,01FH,07CH,01FH,07CH,01FH,07CH,01FH,07CH,01FH,07CH,01FH,07CH
                BYTE    01FH,07CH,01FH,07CH,01FH,07CH,01FH,07CH,000H,000H,01FH,07CH,01FH,07CH,01FH,07CH
                BYTE    01FH,07CH,01FH,07CH,01FH,07CH,01FH,07CH,01FH,07CH,01FH,07CH,01FH,07CH,01FH,07CH
                BYTE    01FH,07CH,01FH,07CH,01FH,07CH,000H,000H,01FH,07CH,01FH,07CH,01FH,07CH,01FH,07CH
                BYTE    01FH,07CH,01FH,07CH,01FH,07CH,01FH,07CH,01FH,07CH,01FH,07CH,01FH,07CH,01FH,07CH
                BYTE    01FH,07CH,01FH,07CH,000H,000H,01FH,07CH,01FH,07CH,01FH,07CH,01FH,07CH,01FH,07CH
                BYTE    01FH,07CH,01FH,07CH,01FH,07CH,01FH,07CH,01FH,07CH,01FH,07CH,01FH,07CH,01FH,07CH
                BYTE    01FH,07CH,000H,000H,01FH,07CH,01FH,07CH,01FH,07CH,01FH,07CH,01FH,07CH,01FH,07CH
                BYTE    01FH,07CH,085H,010H,0C8H,010H,00CH,011H,091H,01DH,0F4H,029H,00BH,015H,090H,021H
                BYTE    0FFH,07FH,085H,010H,0C8H,010H,00DH,011H,091H,01DH,035H,02EH,00BH,015H,090H,021H
                BYTE    0A5H,014H,04AH,029H,073H,04EH,09CH,073H,01FH,07CH,03FH,017H,0DAH,025H,0FFH,07FH
                BYTE    085H,010H,0CAH,014H,0EBH,018H,00DH,01DH,0EBH,018H,0C8H,010H,00BH,019H,0C6H,010H
                BYTE    06CH,011H,074H,01AH,019H,03BH,0CDH,018H,0EFH,07DH,008H,05DH,0FFH,07FH,085H,010H
                BYTE    087H,010H,0A8H,014H,0C9H,018H,0A8H,014H,063H,00CH,0C8H,010H,0C6H,010H,06EH,021H
                BYTE    0F3H,021H,0DCH,03AH,01FH,07CH,0DEH,066H,0D9H,059H,0FFH,07FH,086H,010H,0CAH,014H
                BYTE    0EBH,018H,00DH,01DH,0EBH,018H,0C8H,010H,00BH,019H,0A7H,014H,0B5H,012H,029H,049H
                BYTE    09CH,073H,01FH,07CH,0FFH,03DH,0BCH,014H,0FFH,07FH,086H,010H,087H,010H,0A8H,014H
                BYTE    0C9H,018H,0A8H,014H,063H,00CH,0C8H,010H,0C6H,024H,007H,045H,06AH,05DH,0E7H,07CH
                BYTE    071H,07FH,0A0H,07CH,000H,058H,0FFH,07FH,000H,000H,000H,000H,000H,000H,000H,000H
                BYTE    000H,000H,000H,000H,000H,000H,085H,010H,0E8H,014H,04CH,025H,0F0H,031H,0B6H,03AH
                BYTE    0C6H,028H,007H,039H,000H,000H,085H,010H,0E8H,014H,04CH,025H,0F0H,031H,0B6H,03AH
                BYTE    0C6H,028H,007H,039H,0C4H,014H,06DH,02DH,094H,052H,0FFH,07FH,00CH,03EH,03FH,017H
                BYTE    0FAH,025H,000H,000H,084H,010H,0A5H,020H,0AEH,029H,0F0H,029H,01FH,07CH,06DH,029H
                BYTE    067H,01DH,0C4H,014H,0F0H,019H,0F9H,032H,09FH,063H,0EEH,01CH,04BH,06AH,008H,049H
                BYTE    000H,000H,084H,010H,0C6H,010H,008H,019H,06BH,021H,01FH,07CH,0E8H,014H,004H,015H
                BYTE    0C4H,014H,0F3H,021H,0DCH,03AH,0DEH,066H,05BH,05AH,00EH,047H,068H,032H,000H,000H
                BYTE    084H,010H,0C5H,028H,006H,02DH,029H,035H,01FH,07CH,06DH,029H,067H,01DH,0C4H,014H
                BYTE    075H,012H,029H,049H,09CH,073H,0AEH,015H,0FFH,03DH,0BCH,014H,000H,000H,084H,010H
                BYTE    083H,020H,0C4H,024H,0E7H,02CH,01FH,07CH,0E8H,014H,004H,015H,0C6H,024H,007H,045H
                BYTE    06AH,05DH,02FH,07EH,071H,07FH,084H,07CH,000H,070H,000H,000H,063H,014H,004H,02DH
                BYTE    045H,035H,01FH,07CH,027H,029H,0A8H,02DH,08CH,05DH,0A5H,00CH,0EAH,010H,04DH,019H
                BYTE    0F3H,029H,096H,03EH,06AH,01DH,0E7H,01CH,000H,000H,0A5H,00CH,00BH,011H,06EH,01DH
                BYTE    014H,02EH,0D8H,046H,06AH,01DH,0E7H,01CH,0C4H,014H,06DH,02DH,094H,052H,09CH,073H
                BYTE    0AEH,015H,03FH,017H,0FAH,025H,000H,000H,084H,010H,068H,021H,0AAH,029H,090H,021H
                BYTE    01FH,07CH,06AH,01DH,007H,01DH,0A5H,00CH,0EAH,010H,04DH,019H,0F3H,029H,01FH,07CH
                BYTE    01FH,07CH,01FH,07CH,000H,000H,084H,010H,005H,019H,067H,021H,04DH,019H,01FH,07CH
                BYTE    028H,015H,0C5H,014H,0C4H,014H,01FH,07CH,01FH,07CH,01FH,07CH,01FH,07CH,01FH,07CH
                BYTE    01FH,07CH,000H,000H,084H,010H,0AEH,015H,0F0H,01DH,0AEH,015H,01FH,07CH,06AH,01DH
                BYTE    0E7H,01CH,0C4H,014H,075H,012H,029H,049H,09CH,073H,0AEH,015H,0FFH,03DH,0BCH,014H
                BYTE    000H,000H,084H,010H,01FH,07CH,01FH,07CH,01FH,07CH,01FH,07CH,01FH,07CH,01FH,07CH
                BYTE    0C6H,024H,007H,045H,06AH,05DH,02FH,07EH,071H,07FH,084H,07CH,000H,070H,000H,000H
                BYTE    0A3H,010H,003H,019H,084H,020H,01FH,07CH,01FH,07CH,01FH,07CH,0A5H,07CH,063H,014H
                BYTE    0C7H,02CH,009H,039H,0AEH,049H,074H,062H,0ECH,01CH,089H,010H,000H,000H,063H,014H
                BYTE    0C7H,02CH,009H,039H,0AEH,049H,074H,062H,0ECH,01CH,089H,010H,0A5H,014H,04AH,029H
                BYTE    073H,04EH,09CH,073H,047H,031H,03FH,017H,0DAH,025H,000H,000H,063H,014H,026H,02DH
                BYTE    089H,039H,0CBH,03DH,08BH,020H,009H,039H,0ECH,01CH,063H,014H,0C6H,02CH,029H,039H
                BYTE    0CEH,049H,01FH,07CH,01FH,07CH,01FH,07CH,000H,000H,063H,014H,0E4H,024H,026H,02DH
                BYTE    089H,039H,01FH,07CH,0C7H,02CH,089H,010H,063H,014H,00DH,015H,0B4H,021H,03FH,033H
                BYTE    01FH,07CH,01FH,07CH,01FH,07CH,000H,000H,063H,014H,0EAH,020H,02DH,029H,070H,031H
                BYTE    01FH,07CH,009H,039H,0ECH,01CH,0A7H,014H,0B5H,012H,029H,049H,09CH,073H,026H,02DH
                BYTE    0FFH,03DH,0BCH,014H,000H,000H,063H,014H,0A8H,020H,0CAH,020H,00BH,029H,0FFH,07FH
                BYTE    0ECH,028H,087H,01CH,063H,014H,0E7H,044H,069H,05DH,04FH,07EH,051H,07FH,049H,069H
                BYTE    007H,065H,000H,000H,063H,014H,0C7H,02CH,009H,039H,04AH,039H,0A5H,01CH,0E7H,030H
                BYTE    0E7H,044H,063H,014H,0C7H,02CH,009H,039H,0AEH,049H,074H,062H,0ECH,01CH,089H,010H
                BYTE    000H,000H,063H,014H,0C7H,02CH,009H,039H,0AEH,049H,074H,062H,0ECH,01CH,089H,010H
                BYTE    0A5H,014H,04AH,029H,073H,04EH,09CH,073H,047H,031H,03FH,017H,0DAH,025H,000H,000H
                BYTE    063H,014H,026H,02DH,089H,039H,0CBH,03DH,08BH,020H,009H,039H,0ECH,01CH,063H,014H
                BYTE    0C6H,02CH,029H,039H,0CEH,049H,01FH,07CH,01FH,07CH,01FH,07CH,000H,000H,063H,014H
                BYTE    0E4H,024H,026H,02DH,089H,039H,01FH,07CH,0C7H,02CH,089H,010H,063H,014H,00DH,015H
                BYTE    0B4H,021H,03FH,033H,01FH,07CH,01FH,07CH,01FH,07CH,000H,000H,063H,014H,0EAH,020H
                BYTE    02DH,029H,070H,031H,01FH,07CH,009H,039H,0ECH,01CH,0A7H,014H,0B5H,012H,029H,049H
                BYTE    09CH,073H,026H,02DH,0FFH,03DH,0BCH,014H,000H,000H,063H,014H,0A8H,020H,0CAH,020H
                BYTE    00BH,029H,0FFH,07FH,0ECH,028H,087H,01CH,063H,014H,0E7H,044H,069H,05DH,04FH,07EH
                BYTE    051H,07FH,049H,069H,007H,065H,000H,000H,063H,014H,0C7H,02CH,009H,039H,04AH,039H
                BYTE    0A5H,01CH,0E7H,030H,0E7H,044H,063H,014H,0C7H,02CH,009H,039H,0AEH,049H,074H,062H
                BYTE    0ECH,01CH,089H,010H,000H,000H,063H,014H,0C7H,02CH,009H,039H,0AEH,049H,074H,062H
                BYTE    0ECH,01CH,089H,010H,0A5H,014H,04AH,029H,073H,04EH,09CH,073H,047H,031H,03FH,017H
                BYTE    0DAH,025H,000H,000H,063H,014H,026H,02DH,089H,039H,0CBH,03DH,08BH,020H,009H,039H
                BYTE    0ECH,01CH,063H,014H,0C6H,02CH,029H,039H,0CEH,049H,01FH,07CH,01FH,07CH,01FH,07CH
                BYTE    000H,000H,063H,014H,0E4H,024H,026H,02DH,089H,039H,01FH,07CH,0C7H,02CH,089H,010H
                BYTE    063H,014H,00DH,015H,0B4H,021H,03FH,033H,01FH,07CH,01FH,07CH,01FH,07CH,000H,000H
                BYTE    063H,014H,0EAH,020H,02DH,029H,070H,031H,01FH,07CH,009H,039H,0ECH,01CH,0A7H,014H
                BYTE    0B5H,012H,029H,049H,09CH,073H,026H,02DH,0FFH,03DH,0BCH,014H,000H,000H,063H,014H
                BYTE    0A8H,020H,0CAH,020H,00BH,029H,0FFH,07FH,0ECH,028H,087H,01CH,0FFH,07FH,0FFH,07FH
                BYTE    0FFH,07FH,0FFH,07FH,0FFH,07FH,0FFH,07FH,0FFH,07FH,000H,000H,063H,014H,0C7H,02CH
                BYTE    009H,039H,04AH,039H,0A5H,01CH,0E7H,030H,0E7H,044H,063H,014H,0C7H,02CH,009H,039H
                BYTE    0AEH,049H,074H,062H,0ECH,01CH,089H,010H,000H,000H,063H,014H,0C7H,02CH,009H,039H
                BYTE    0AEH,049H,074H,062H,0ECH,01CH,089H,010H,0A5H,014H,04AH,029H,073H,04EH,09CH,073H
                BYTE    047H,031H,03FH,017H,0DAH,025H,000H,000H,063H,014H,026H,02DH,089H,039H,0CBH,03DH
                BYTE    08BH,020H,009H,039H,0ECH,01CH,0C6H,024H,007H,045H,06AH,05DH,02FH,07EH,071H,07FH
                BYTE    084H,07CH,000H,070H,000H,000H,04AH,029H,0F0H,01CH,008H,062H,0CAH,046H,06AH,053H
                BYTE    097H,046H,01FH,07CH,0C6H,024H,0E7H,044H,069H,05DH,04FH,07EH,051H,07FH,084H,07CH
                BYTE    000H,070H,000H,000H,0A5H,024H,0E7H,038H,04AH,03DH,0CEH,049H,07BH,023H,073H,07DH
                BYTE    05CH,035H,01FH,07CH,01FH,07CH,01FH,07CH,01FH,07CH,01FH,07CH,01FH,07CH,01FH,07CH
                BYTE    000H,000H,04AH,029H,0F0H,01CH,01FH,07CH,01FH,07CH,01FH,07CH,01FH,07CH,01FH,07CH
                BYTE    01FH,07CH,01FH,07CH,01FH,07CH,01FH,07CH,01FH,07CH,01FH,07CH,01FH,07CH,000H,000H
                BYTE    04AH,029H,0F0H,01CH,01FH,07CH,01FH,07CH,01FH,07CH,01FH,07CH,01FH,07CH,01FH,07CH
                BYTE    01FH,07CH,01FH,07CH,01FH,07CH,01FH,07CH,01FH,07CH,01FH,07CH,000H,000H,01FH,07CH
                BYTE    01FH,07CH,01FH,07CH,01FH,07CH,01FH,07CH,01FH,07CH,01FH,07CH,01FH,07CH,01FH,07CH
                BYTE    01FH,07CH,01FH,07CH,01FH,07CH,01FH,07CH,01FH,07CH,000H,000H,01FH,07CH,01FH,07CH
                BYTE    01FH,07CH,01FH,07CH,01FH,07CH,01FH,07CH,01FH,07CH,01FH,07CH,01FH,07CH,01FH,07CH
                BYTE    01FH,07CH,01FH,07CH,01FH,07CH,01FH,07CH,000H,000H,01FH,07CH,01FH,07CH,01FH,07CH
                BYTE    01FH,07CH,01FH,07CH,01FH,07CH,01FH,07CH,0A5H,014H,0E5H,044H,067H,05DH,06CH,07EH
                BYTE    00EH,021H,0D5H,039H,018H,042H,000H,000H,01FH,07CH,01FH,07CH,01FH,07CH,01FH,07CH
                BYTE    01FH,07CH,01FH,07CH,01FH,07CH,01FH,07CH,01FH,07CH,01FH,07CH,01FH,07CH,01FH,07CH
                BYTE    01FH,07CH,01FH,07CH,000H,000H,01FH,07CH,01FH,07CH,01FH,07CH,01FH,07CH,01FH,07CH
                BYTE    01FH,07CH,01FH,07CH,01FH,07CH,01FH,07CH,01FH,07CH,01FH,07CH,01FH,07CH,01FH,07CH
                BYTE    01FH,07CH,000H,000H,01FH,07CH,01FH,07CH,01FH,07CH,01FH,07CH,01FH,07CH,01FH,07CH
                BYTE    01FH,07CH,01FH,07CH,01FH,07CH,01FH,07CH,01FH,07CH,01FH,07CH,01FH,07CH,01FH,07CH
                BYTE    000H,000H,0FFH,07FH,0F7H,07EH,094H,072H,0EFH,065H,0FFH,07FH,0F7H,07EH,094H,072H
                BYTE    01FH,07CH,01FH,07CH,01FH,07CH,01FH,07CH,01FH,07CH,01FH,07CH,01FH,07CH,000H,000H
                BYTE    000H,000H,084H,01CH,0E7H,034H,029H,045H,084H,01CH,0E7H,034H,029H,045H,01FH,07CH
                BYTE    01FH,07CH,01FH,07CH,01FH,07CH,01FH,07CH,01FH,07CH,01FH,07CH,000H,000H,01FH,07CH
                BYTE    01FH,07CH,01FH,07CH,01FH,07CH,01FH,07CH,01FH,07CH,01FH,07CH,01FH,07CH,01FH,07CH
                BYTE    01FH,07CH,01FH,07CH,01FH,07CH,01FH,07CH,01FH,07CH,000H,000H,01FH,07CH,01FH,07CH
                BYTE    01FH,07CH,01FH,07CH,01FH,07CH,01FH,07CH,01FH,07CH,01FH,07CH,01FH,07CH,01FH,07CH
                BYTE    01FH,07CH,01FH,07CH,01FH,07CH,01FH,07CH,000H,000H,01FH,07CH,01FH,07CH,01FH,07CH
                BYTE    01FH,07CH,01FH,07CH,01FH,07CH,01FH,07CH,01FH,07CH,01FH,07CH,01FH,07CH,01FH,07CH
                BYTE    01FH,07CH,01FH,07CH,01FH,07CH,000H,000H,01FH,07CH,01FH,07CH,01FH,07CH,01FH,07CH
                BYTE    01FH,07CH,01FH,07CH,01FH,07CH,0A5H,014H,00EH,021H,073H,02DH,0F6H,03DH,005H,016H
                BYTE    0C6H,01AH,059H,04AH,000H,000H,009H,01DH,0B2H,021H,035H,02AH,0FBH,042H,011H,021H
                BYTE    076H,02DH,03AH,046H,0A5H,014H,01FH,07CH,0F8H,032H,0B7H,02AH,005H,016H,0C6H,01AH
                BYTE    006H,01BH,000H,000H,027H,021H,00AH,03AH,0EFH,04AH,097H,05FH,0FFH,07FH,01FH,07CH
                BYTE    0C6H,01AH,0A5H,014H,02DH,015H,0B2H,021H,037H,02EH,083H,015H,005H,016H,0C6H,01AH
                BYTE    000H,000H,0C6H,018H,00AH,019H,04EH,019H,0B2H,021H,037H,02EH,083H,015H,0C6H,01AH
                BYTE    0A5H,014H,049H,042H,012H,05BH,0D8H,073H,0F6H,03DH,01FH,07CH,0C6H,01AH,000H,000H
                BYTE    0A8H,020H,050H,03DH,019H,05AH,01EH,06FH,008H,039H,08BH,059H,052H,06AH,0A5H,014H
                BYTE    067H,05DH,0EBH,06DH,06CH,076H,01FH,07CH,005H,016H,0C6H,01AH,000H,000H,0C6H,018H
                BYTE    02DH,019H,0B2H,021H,015H,02AH,098H,036H,067H,05DH,01FH,07CH,0A5H,014H,0E5H,044H
                BYTE    067H,05DH,06CH,07EH,00EH,021H,0D5H,039H,018H,042H,000H,000H,027H,021H,00AH,03AH
                BYTE    0EFH,04AH,097H,05FH,0FFH,07FH,01FH,07CH,0C6H,01AH,008H,00DH,033H,01AH,0D8H,02AH
                BYTE    07DH,04FH,0B4H,031H,05AH,042H,0FDH,05EH,000H,000H,008H,020H,00DH,034H,012H,048H
                BYTE    018H,064H,01FH,07CH,07FH,07EH,0FFH,07FH,027H,021H,00AH,03AH,0EFH,04AH,097H,05FH
                BYTE    0FFH,07FH,0DFH,07DH,0C6H,01AH,000H,000H,008H,00DH,033H,01AH,0D8H,02AH,07DH,04FH
                BYTE    0B4H,031H,05AH,042H,0FDH,05EH,07FH,07EH,07FH,07EH,07FH,07EH,07FH,07EH,07FH,07EH
                BYTE    07FH,07EH,07FH,07EH,000H,000H,008H,020H,00DH,034H,012H,048H,018H,064H,01FH,07CH
                BYTE    07FH,07EH,0FFH,07FH,07FH,07EH,07FH,07EH,07FH,07EH,07FH,07EH,07FH,07EH,07FH,07EH
                BYTE    07FH,07EH,000H,000H,0A5H,014H,050H,052H,038H,06BH,0BDH,073H,0A5H,014H,00EH,021H
                BYTE    0F6H,03DH,07FH,07EH,07FH,07EH,07FH,07EH,07FH,07EH,07FH,07EH,07FH,07EH,07FH,07EH
                BYTE    000H,000H,008H,020H,00DH,034H,012H,048H,018H,064H,01FH,07CH,07FH,07EH,0FFH,07FH
                BYTE    07FH,07EH,07FH,07EH,07FH,07EH,07FH,07EH,07FH,07EH,07FH,07EH,07FH,07EH,000H,000H
                BYTE    008H,020H,00DH,034H,012H,048H,018H,064H,01FH,07CH,07FH,07EH,0FFH,07FH,07FH,07EH
                BYTE    07FH,07EH,07FH,07EH,07FH,07EH,07FH,07EH,07FH,07EH,07FH,07EH,000H,000H,008H,020H
                BYTE    00DH,034H,012H,048H,018H,064H,01FH,07CH,07FH,07EH,0FFH,07FH,07FH,07EH,07FH,07EH
                BYTE    07FH,07EH,07FH,07EH,07FH,07EH,07FH,07EH,07FH,07EH,000H,000H,0C6H,018H,02DH,019H
                BYTE    0B2H,021H,015H,02AH,098H,036H,067H,05DH,01FH,07CH,07FH,07EH,07FH,07EH,07FH,07EH
                BYTE    07FH,07EH,07FH,07EH,07FH,07EH,07FH,07EH,000H,000H,027H,021H,00AH,03AH,0EFH,04AH
                BYTE    097H,05FH,0FFH,07FH,01FH,07CH,0C6H,01AH,000H,000H,000H,000H,000H,000H,000H,000H
                BYTE    000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H
                BYTE    000H,000H,000H,000H,000H,000H,0A5H,014H,00EH,038H,018H,060H,01FH,07CH,0BFH,07DH
                BYTE    07FH,07EH,03FH,07FH,000H,000H,0A5H,014H,00EH,038H,018H,060H,01FH,07CH,0BFH,07DH
                BYTE    07FH,07EH,03FH,07FH,000H,000H,00EH,038H,018H,060H,01FH,07CH,0BFH,07DH,07FH,07EH
                BYTE    03FH,07FH,000H,000H,000H,000H,00EH,038H,018H,060H,01FH,07CH,0BFH,07DH,07FH,07EH
                BYTE    03FH,07FH,000H,000H,00EH,038H,018H,060H,01FH,07CH,0BFH,07DH,07FH,07EH,03FH,07FH
                BYTE    000H,000H,0A5H,014H,00EH,038H,018H,060H,01FH,07CH,0BFH,07DH,07FH,07EH,03FH,07FH
                BYTE    0A5H,014H,00EH,038H,018H,060H,01FH,07CH,0BFH,07DH,07FH,07EH,03FH,07FH,000H,000H
                BYTE    000H,000H,00EH,038H,018H,060H,01FH,07CH,0BFH,07DH,07FH,07EH,03FH,07FH,000H,000H
                BYTE    00EH,038H,018H,060H,01FH,07CH,0BFH,07DH,07FH,07EH,03FH,07FH,000H,000H,0A5H,014H
                BYTE    00EH,038H,018H,060H,01FH,07CH,0BFH,07DH,07FH,07EH,03FH,07FH,000H,000H,00EH,038H
                BYTE    018H,060H,01FH,07CH,0BFH,07DH,07FH,07EH,03FH,07FH,000H,000H,000H,000H,00EH,038H
                BYTE    018H,060H,01FH,07CH,0BFH,07DH,07FH,07EH,03FH,07FH,000H,000H,00EH,038H,018H,060H
                BYTE    01FH,07CH,0BFH,07DH,07FH,07EH,03FH,07FH,000H,000H,000H,000H,00EH,038H,018H,060H
                BYTE    01FH,07CH,0BFH,07DH,07FH,07EH,03FH,07FH,000H,000H,00EH,038H,018H,060H,01FH,07CH
                BYTE    0BFH,07DH,07FH,07EH,03FH,07FH,000H,000H,000H,000H,00EH,038H,018H,060H,01FH,07CH
                BYTE    0BFH,07DH,07FH,07EH,03FH,07FH,000H,000H,0E6H,043H,086H,009H,060H,015H,000H,000H
                BYTE    000H,000H,000H,000H,008H,025H,000H,000H,0FFH,07FH,0BDH,002H,02DH,04EH,0F3H,066H
                BYTE    099H,07FH,02DH,04EH,099H,07FH,000H,000H,0F0H,07FH,047H,04DH,000H,031H,000H,000H
                BYTE    000H,000H,000H,000H,008H,025H,000H,000H,0FFH,07FH,067H,04DH,0FEH,001H,0BDH,002H
                BYTE    07EH,03FH,0F3H,066H,099H,07FH,000H,000H,0E6H,005H,0A5H,000H,0A5H,000H,000H,000H
                BYTE    000H,000H,000H,000H,008H,025H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H
                BYTE    000H,000H,000H,000H,000H,000H,000H,000H,04AH,04DH,0A5H,000H,0A5H,000H,000H,000H
                BYTE    000H,000H,000H,000H,008H,025H,000H,000H,0FFH,07FH,067H,04DH,02DH,04EH,0F3H,066H
                BYTE    099H,07FH,0BDH,002H,07EH,03FH,000H,000H,069H,000H,0ABH,004H,00EH,00DH,052H,015H
                BYTE    0B4H,01DH,014H,026H,055H,02AH,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H
                BYTE    000H,000H,000H,000H,000H,000H,000H,000H,0C0H,038H,002H,041H,044H,049H,086H,051H
                BYTE    0C8H,059H,00AH,062H,04CH,06AH,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H
                BYTE    000H,000H,000H,000H,000H,000H,0C6H,024H,007H,045H,06AH,05DH,02FH,07EH,071H,07FH
                BYTE    084H,07CH,000H,070H,0C6H,00CH,02BH,015H,083H,030H,046H,045H,05DH,053H,004H,025H
                BYTE    0C7H,04DH,0A5H,014H,00EH,038H,018H,060H,01FH,07CH,0BFH,07DH,07FH,07EH,03FH,07FH
                BYTE    000H,000H,00EH,038H,018H,060H,01FH,07CH,0BFH,07DH,07FH,07EH,03FH,07FH,000H,000H
                BYTE    00EH,000H,059H,010H,01FH,029H,004H,00CH,021H,000H,005H,010H,063H,00CH,0A5H,040H
                BYTE    067H,05DH,0AEH,07EH,018H,07FH,0BFH,07DH,09DH,07FH,048H,008H,003H,030H,008H,044H
                BYTE    012H,069H,0AEH,010H,06DH,058H,0F7H,019H,0A5H,014H,0A5H,040H,067H,05DH,0AEH,07EH
                BYTE    0CBH,010H,00CH,06AH,071H,015H,0FFH,07FH,0F7H,07EH,094H,072H,0EFH,065H,0FFH,07FH
                BYTE    0F7H,07EH,094H,072H,000H,000H,084H,01CH,0E7H,034H,029H,045H,084H,01CH,0E7H,034H
                BYTE    029H,045H,0A5H,014H,00EH,038H,018H,060H,01FH,07CH,0BFH,07DH,07FH,07EH,03FH,07FH
                BYTE    000H,000H,00EH,038H,018H,060H,01FH,07CH,0BFH,07DH,07FH,07EH,03FH,07FH,000H,000H
                BYTE    00EH,038H,018H,060H,01FH,07CH,0BFH,07DH,07FH,07EH,03FH,07FH,000H,000H,00EH,038H
                BYTE    018H,060H,01FH,07CH,0BFH,07DH,07FH,07EH,03FH,07FH,0A5H,014H,0CAH,014H,00DH,015H
                BYTE    071H,019H,0C5H,015H,087H,01EH,014H,01EH,0A5H,014H,0CAH,014H,00DH,015H,071H,019H
                BYTE    08DH,015H,011H,01AH,014H,01EH,0A5H,014H,0CAH,014H,00DH,015H,071H,019H,00DH,015H
                BYTE    014H,01EH,014H,01EH,0E6H,014H,00AH,03AH,0EFH,04AH,0D6H,05FH,061H,019H,087H,01EH
                BYTE    046H,01BH,0A5H,014H,04CH,011H,0D1H,01DH,035H,02EH,0E5H,015H,087H,01EH,046H,02AH
                BYTE    048H,008H,0AEH,010H,051H,021H,0F7H,019H,090H,01DH,0F3H,025H,0BBH,032H,048H,008H
                BYTE    0AEH,010H,051H,021H,0F7H,019H,0DAH,042H,05CH,04FH,0BBH,032H,048H,008H,0AEH,010H
                BYTE    051H,021H,0F7H,019H,051H,021H,0F7H,019H,0BBH,032H,048H,008H,08FH,005H,097H,026H
                BYTE    07FH,047H,0B0H,01DH,0F3H,025H,0B6H,02EH,048H,008H,0DAH,031H,09FH,04AH,032H,027H
                BYTE    06CH,005H,0F3H,025H,0EFH,015H,063H,00CH,087H,00CH,0CAH,010H,02DH,011H,08DH,015H
                BYTE    0CFH,019H,090H,01DH,063H,00CH,087H,00CH,0CAH,010H,02DH,011H,0B6H,06FH,0BFH,07DH
                BYTE    0FFH,07FH,063H,00CH,087H,00CH,0CAH,010H,02DH,011H,02DH,011H,090H,01DH,090H,01DH
                BYTE    0E6H,014H,00AH,03AH,0EFH,04AH,0D6H,05FH,08DH,015H,0CFH,019H,0BFH,07DH,0A5H,014H
                BYTE    04CH,011H,0D1H,01DH,035H,02EH,08DH,015H,0CFH,019H,090H,01DH,000H,000H,006H,018H
                BYTE    04BH,024H,0F0H,024H,0E8H,00CH,04AH,01DH,095H,029H,000H,000H,006H,018H,04BH,024H
                BYTE    0F0H,024H,0A8H,014H,021H,000H,0C9H,018H,000H,000H,006H,018H,04BH,024H,0F0H,024H
                BYTE    04BH,024H,0F0H,024H,095H,029H,000H,000H,08FH,005H,097H,026H,07FH,047H,0E8H,00CH
                BYTE    04AH,01DH,06BH,021H,000H,000H,0DAH,031H,09FH,04AH,032H,027H,0E8H,010H,04AH,01DH
                BYTE    009H,015H,000H,000H,00EH,038H,018H,060H,01FH,07CH,0BFH,07DH,07FH,07EH,03FH,07FH
                BYTE    000H,000H,00EH,038H,018H,060H,01FH,07CH,0BFH,07DH,07FH,07EH,03FH,07FH,000H,000H
                BYTE    00EH,038H,018H,060H,01FH,07CH,0BFH,07DH,07FH,07EH,03FH,07FH,000H,000H,00EH,038H
                BYTE    018H,060H,01FH,07CH,0BFH,07DH,07FH,07EH,03FH,07FH,00EH,038H,018H,060H,01FH,07CH
                BYTE    0BFH,07DH,07FH,07EH,03FH,07FH,0FFH,07FH,00EH,038H,018H,060H,01FH,07CH,0BFH,07DH
                BYTE    07FH,07EH,03FH,07FH,0FFH,07FH,00EH,038H,018H,060H,01FH,07CH,0BFH,07DH,07FH,07EH
                BYTE    03FH,07FH,0FFH,07FH,0E5H,014H,00EH,02AH,0B3H,036H,09AH,057H,0FFH,073H,0E5H,015H
                BYTE    0C6H,01AH,00EH,038H,018H,060H,01FH,07CH,0BFH,07DH,07FH,07EH,03FH,07FH,0FFH,07FH
                BYTE    00EH,038H,018H,060H,01FH,07CH,0BFH,07DH,07FH,07EH,03FH,07FH,0FFH,07FH,0C6H,018H
                BYTE    091H,01DH,014H,026H,099H,032H,0CDH,018H,033H,025H,019H,043H,0E6H,014H,009H,03AH
                BYTE    0CFH,04AH,076H,05FH,0BBH,06FH,0E5H,015H,087H,01EH,0A5H,014H,04CH,011H,0D1H,01DH
                BYTE    035H,02EH,0A3H,01DH,0E4H,019H,043H,019H,0E6H,014H,050H,03DH,019H,05AH,01EH,06FH
                BYTE    073H,022H,08BH,059H,052H,06AH,0E6H,014H,04CH,011H,0D1H,01DH,061H,019H,074H,02DH
                BYTE    0E4H,019H,0EFH,01CH,0A5H,014H,0D1H,029H,0D8H,04EH,0FFH,07FH,047H,019H,00DH,032H
                BYTE    0C6H,01AH,0C6H,00CH,091H,01DH,0F9H,011H,0FFH,012H,0FFH,07FH,08FH,020H,0F3H,02CH
                BYTE    084H,010H,07FH,07EH,044H,031H,031H,046H,0F1H,01CH,07FH,07EH,07FH,07EH,0C6H,018H
                BYTE    0CBH,03DH,04FH,04EH,058H,06BH,061H,019H,0C6H,01AH,0FFH,07FH,0A5H,014H,050H,052H
                BYTE    038H,06BH,0BDH,073H,0A5H,014H,00EH,021H,0F6H,03DH,00EH,038H,018H,060H,01FH,07CH
                BYTE    0BFH,07DH,07FH,07EH,03FH,07FH,0FFH,07FH,00EH,038H,018H,060H,01FH,07CH,0BFH,07DH
                BYTE    07FH,07EH,03FH,07FH,0FFH,07FH,0A5H,014H,06FH,021H,00CH,06AH,098H,06BH,0C5H,015H
                BYTE    087H,01EH,014H,01EH,0A5H,014H,008H,055H,018H,060H,01FH,07CH,0C5H,015H,087H,01EH
                BYTE    00CH,06AH,00EH,038H,018H,060H,01FH,07CH,0BFH,07DH,07FH,07EH,03FH,07FH,0FFH,07FH
                BYTE    0C6H,018H,0ABH,025H,071H,032H,058H,04BH,026H,019H,00DH,015H,014H,01EH,0E5H,014H
                BYTE    04CH,011H,0D1H,01DH,011H,01AH,0D6H,01AH,052H,01EH,0D0H,00DH,0C6H,018H,0ABH,025H
                BYTE    071H,032H,058H,04BH,07BH,063H,08DH,015H,011H,01AH,0C0H,03CH,023H,065H,0A7H,07DH
                BYTE    0A9H,07EH,04FH,07FH,0CFH,019H,000H,000H,063H,00CH,02BH,015H,012H,02AH,0D8H,03AH
                BYTE    06AH,014H,090H,01DH,0E9H,014H,063H,00CH,02CH,01DH,050H,021H,076H,026H,0B6H,06FH
                BYTE    0CFH,019H,0FFH,07FH,0C6H,018H,091H,01DH,014H,026H,099H,032H,0CDH,018H,033H,025H
                BYTE    019H,043H,063H,00CH,087H,00CH,0CAH,010H,02DH,011H,0B6H,06FH,0FFH,07FH,090H,01DH
                BYTE    0A5H,014H,089H,046H,0AAH,04AH,053H,03EH,018H,07FH,00DH,04FH,09DH,07FH,0C6H,018H
                BYTE    091H,01DH,014H,026H,099H,032H,005H,035H,088H,049H,019H,043H,0E6H,014H,0B0H,015H
                BYTE    0F7H,02AH,09CH,03FH,018H,060H,018H,060H,018H,060H,0C6H,018H,018H,060H,01FH,07CH
                BYTE    0BFH,07DH,07FH,07EH,03FH,07FH,0FFH,07FH,0C6H,018H,0ABH,025H,071H,032H,058H,04BH
                BYTE    026H,019H,00DH,015H,014H,01EH,0E5H,014H,04CH,011H,0D1H,01DH,011H,01AH,0D6H,01AH
                BYTE    052H,01EH,0D0H,00DH,0C6H,018H,0ABH,025H,071H,032H,058H,04BH,07BH,063H,08DH,015H
                BYTE    011H,01AH,000H,028H,040H,038H,0A1H,044H,004H,051H,08CH,065H,00CH,06AH,087H,01EH
                BYTE    0E6H,014H,00BH,032H,0F3H,046H,099H,053H,0FEH,06BH,0A8H,041H,087H,01EH,005H,015H
                BYTE    04CH,011H,087H,01EH,0A4H,019H,005H,026H,065H,032H,0C8H,036H,048H,008H,02DH,001H
                BYTE    0F3H,015H,05CH,04FH,028H,001H,0CCH,009H,050H,01AH,048H,008H,08DH,01DH,073H,03AH
                BYTE    07BH,043H,0FFH,05BH,0F7H,046H,0BAH,03EH,048H,008H,04BH,015H,011H,016H,01BH,037H
                BYTE    07EH,04BH,0AEH,01DH,060H,003H,000H,000H,021H,008H,063H,010H,0A5H,018H,0E7H,02CH
                BYTE    029H,035H,06BH,049H,048H,008H,02DH,025H,014H,046H,0FAH,05EH,0FFH,07FH,090H,01DH
                BYTE    0F5H,03AH,048H,008H,06EH,021H,052H,02EH,0F5H,03AH,0BEH,053H,090H,01DH,03AH,043H
                BYTE    000H,030H,08CH,050H,011H,061H,038H,07EH,0BFH,038H,06DH,058H,0FFH,07FH,048H,008H
                BYTE    06DH,058H,08AH,005H,04EH,022H,056H,037H,0DBH,001H,01FH,01FH,048H,008H,008H,044H
                BYTE    005H,038H,0F0H,01DH,0DAH,042H,05CH,04FH,06DH,058H,048H,008H,051H,021H,06DH,058H
                BYTE    096H,079H,090H,01DH,0F3H,025H,0F7H,019H,048H,008H,008H,044H,0FFH,07FH,0FFH,07FH
                BYTE    090H,01DH,0F3H,025H,06DH,058H,00EH,038H,018H,060H,01FH,07CH,0BFH,07DH,07FH,07EH
                BYTE    03FH,07FH,0FFH,07FH,048H,008H,051H,001H,019H,012H,0DFH,02AH,068H,019H,0ECH,029H
                BYTE    070H,042H,048H,008H,0CFH,021H,093H,02EH,076H,03FH,090H,01DH,095H,03BH,0BAH,043H
                BYTE    0E6H,014H,0EBH,004H,02EH,011H,071H,019H,019H,012H,03FH,02BH,019H,043H,048H,008H
                BYTE    090H,005H,098H,026H,05DH,03BH,0EDH,034H,033H,051H,0F8H,06DH,048H,008H,0EEH,01CH
                BYTE    0B5H,031H,0DBH,04EH,0FFH,05BH,090H,01DH,0F3H,025H,048H,008H,04EH,021H,012H,02EH
                BYTE    0D6H,03EH,090H,01DH,090H,01DH,01AH,043H,048H,008H,04EH,005H,092H,009H,078H,026H
                BYTE    015H,01AH,0ECH,000H,009H,000H,007H,000H,039H,00DH,05CH,026H,03FH,03BH,080H,000H
                BYTE    00AH,000H,011H,000H,0FFH,07FH,0FFH,07FH,0FFH,07FH,0FFH,07FH,0FFH,07FH,0FFH,07FH
                BYTE    0FFH,07FH,000H,000H,0ACH,030H,0F0H,024H,074H,035H,0FFH,07FH,04AH,01DH,0FFH,07FH
                BYTE    000H,000H,003H,00CH,008H,018H,0F0H,024H,0FFH,05BH,0C9H,018H,095H,029H,000H,000H
                BYTE    000H,000H,000H,000H,000H,000H,004H,00CH,000H,000H,005H,010H,000H,000H,004H,000H
                BYTE    00DH,000H,015H,000H,01FH,001H,04AH,01DH,0E8H,00CH,000H,000H,030H,01DH,092H,039H
                BYTE    0B8H,05AH,03FH,06BH,04AH,01DH,0ACH,00CH,000H,000H,00CH,019H,094H,03DH,07BH,056H
                BYTE    0A8H,014H,04AH,01DH,0C9H,018H
;END
;
;a
; 
OBJJYO	 EQU	  CORGENE	  ;obj jyouchyu 
PLAYCG   EQU	  OBJJYO+15*8*2   ;player cg1
;;;;PLAYCG1  EQU	  PLAYCG+7*5*2	  ;player cg2 
;
;b
;
DANJOBG  EQU	  PLAYCG+15*5*2	  ;danjyo bg kankei obj 
CHOBJ    EQU	  DANJOBG+7*12*2	  ;chengi obj
;
;c
;
ENMYOBJ	 EQU	  CHOBJ+7*11*2	  ;ENMY OBJ
;
;d
;
KENOBJ  EQU	  ENMYOBJ+7*24*2  ;DANJYOU BASE BG
TATEOBJ EQU	  KENOBJ+3*3*2	  ; 
BG32BIT EQU       TATEOBJ+4*3*2   ;
MAP2BIT EQU       BG32BIT+4*8*2   ;
CHITEM  EQU       MAP2BIT+4*8*2   ;
MAPOBJ	EQU	  CHITEM+7*3*2	
;
;e,f,g,h,i,j,k,l
;
DANCOR	 EQU	  MAPOBJ+7*3*2	  ;KABE BG
;;;;;MAPCOR   EQU      DANCOR+15*72*2  ; MAP COLOR
;MAPCOR   EQU      DANCOR+15*120*2  ; MAP COLOR
MAPCOR   EQU      DANCOR+15*(6*20)*2  ; MAP COLOR
;
;m
KOUKABG  EQU      MAPCOR+16*6*2  ;
TOKUSYU  EQU      KOUKABG+7*8*2   ;
;
;n,o,p
;
CIJOBG	 EQU	  TOKUSYU+7*6*2  ;CIJO BG 
CIJOBG1	 EQU	  CIJOBG+7*30*2	  ;CIJO SOUSYOKU BG
;	 EQU	  CIJOBG1+7*60*2  ;
;
CGLPT3	 EQU	  $
		BYTE	000H
		BYTE	000H,006H,00CH,012H,018H,01EH,024H,02AH,030H,036H,03CH,042H
CGLPT4	 EQU	  $
		BYTE	000H
		BYTE	000H,008H,010H,018H
CGLPT7	 EQU	  $
		BYTE	000H,00EH,01CH,02AH,038H,046H,054H,062H
		BYTE	070H,07EH,08CH,09AH,0A8H,0B6H,0C4H,0D2H
CGLPT71	 EQU	  $
		WORD	00000H,0000EH,0001CH,0002AH,00038H,00046H,00054H,00062H
		WORD	00070H,0007EH,0008CH,0009AH,000A8H,000B6H,000C4H,000D2H
		WORD	000E0H,000EEH,000FCH,0010AH,00118H,00126H,00134H,00142H
CGLPT8	 EQU	  $
		BYTE	000H,00FH,01EH,02DH,03CH
;;;;;;;;;;;;;		 BYTE	  000H,018H,030H,048H
CGLPT72  EQU	  $ 
	 	BYTE	000H,01CH,038H,054H,070H,08CH,0A8H,0C4H
CGLPT73  EQU	  $
		WORD	00000H,0002AH,00054H,0007EH,000A8H,000D2H,000FCH,00126H
		WORD	00150H,0017AH,001A4H,001CEH,001F8H,00222H,0024CH,00276H
		WORD	002A0H,002CAH,002F4H,0031EH
CGLPT75  EQU	  $
		WORD	(07H*05H*2)*0,(07H*05H*2)*1,(07H*05H*2)*2
		WORD	(07H*05H*2)*3,(07H*05H*2)*4,(07H*05H*2)*5
;;;;;;;;		BYTE	000H,046H,08CH,0D2H
CGLPT16	 EQU	  $
		BYTE	000H,040H
CGLPT24	 EQU	  $
		BYTE	000H,030H
CGLPT162 EQU	  $
		WORD	00000H,000B4H,00168H,0021CH,002D0H,00384H,00438H,004ECH
		WORD	005A0H,00654H,00708H,007BCH,00870H,00924H,009D8H,00A8CH
		WORD	00B40H,00BF4H,00CA8H,00D5CH
CGLPTF4	 EQU	  $
		WORD	00000H,00078H
;
; 
;/*----------------------------------------------------------------------*/
;/*		dajyou bgkouka obj cg set				*/
;/*----------------------------------------------------------------------*/
DJCGSET	 EQU	  $ 
	 MEM16
	 REP	  #00100001B		; memory 16bit mode & CLC
;
	 LDX	  BOBOJC
	 LDA	  >CGLPT7,X 
	 AND	  #00FFH
;///////	 CLC
	 ADC	  #DANJOBG
	 STA	  <WORK0 
; 
	 IDX16
	 REP	  #00010000B
;
	 LDA	  #00102H
	 LDX	  #06H
	 JSR	  CHGSUB2 
;
;// 02.11.28 //		LDX	!DANJC
;// 02.11.28 //		LDA	>CGLPT162,X
;// 02.11.28 //		ADC	#DANCOR
;// 02.11.28 //		STA	<WORK0
;// 02.11.28 //;
;// 02.11.28 //		IDX16
;// 02.11.28 //		REP	#00010000B	; index 16bit mode
;// 02.11.28 //;
;// 02.11.28 //		LDA	#00112H
;// 02.11.28 //		LDX	#00006H
;// 02.11.28 //		JSR	CHGSUB2
	 MEM8 
	 IDX8 
	 SEP	  #00110000B
	 RTL
; 
; 
;/*----------------------------------------------------------------------*/
;/*		dajyou bgkouka obj cg set				*/
;/*----------------------------------------------------------------------*/
OBJYSET	 EQU	  $ 
	 MEM16
	 REP	  #00100001B		; memory 16bit mode & CLC
	
	 LDX	  #00H
	 LDA	  <MPDTNO
	 AND	  #040H
	 BEQ	  OBJY010
	 INX
	 INX
OBJY010	EQU	$

	 LDA	  >CGLPTF4,X 
;///////	 CLC
	 ADC	  #OBJJYO
	 STA	  <WORK0 

; 
	 IDX16
	 REP	  #00010000B
;

	 LDA	  #00122H
	 LDX	  #0EH
	 LDY      #03H
	 JSR	  CHGSUB3
;
	 MEM8 
	 IDX8 
	 SEP	  #00110000B
	 RTL

;/*----------------------------------------------------------------------*/
;/*	  enmy cg set							 */
;/*----------------------------------------------------------------------*/
MSCGST1	 EQU	  $ 
	 MEM16
	 IDX16
	 REP	  #00110001B		; memory,index 16bit mode & CLC
;
	 LDA	  EYOJC0
	 AND      #000FFH
	 ASL	  A
	 TAX
	 LDA	  >CGLPT71,X 
;///////	 CLC
	 ADC	  #ENMYOBJ
	 STA	  <WORK0 
; 
	 LDA	  #001A2H				;set point 
	 LDX	  #00006H				;yoko kosu
	 JSR	  CHGSUB2 
;
	 MEM8 
	 IDX8 
	 SEP	  #00110000B
	 RTL
; 
;
;
;/*----------------------------------------------------------------------*/
;/*	  enmy cg set 2							 */
;/*----------------------------------------------------------------------*/
MSCGST2	 EQU	  $ 
	 MEM16
	 IDX16
	 REP	  #00110001B		; memory,index 16bit mode & CLC
;
	 LDA	  EYOJC1
	 AND      #000FFH
	 ASL	  A
	 TAX
	 LDA	  >CGLPT71,X 
;///////	 CLC
	 ADC	  #ENMYOBJ
	 STA	  <WORK0 
; 
	 LDA	  #001C2H				;set point 
	 LDX	  #00006H				;yoko kosu
	 JSR	  CHGSUB2 
;
	 MEM8 
	 IDX8 
	 SEP	  #00110000B
	 RTL
; 

;/*----------------------------------------------------------------------*/
;/*		ken obj set				 */
;/*----------------------------------------------------------------------*/
KENST	 EQU	  $ 
	 MEM16
	 REP	  #00100001B		; memory 16bit mode & CLC
;
;;;;;;;;	 LDX	  KENOJC
		LDA	>ITMTBL6
		AND	#000FFH
		TAX
	 LDA	  >CGLPT3,X 
	 AND	  #00FFH
;///////	 CLC
	 ADC	  #KENOBJ
	 STA	  <WORK0 
; 
	 IDX16
	 REP	  #00010000B
;
	 LDA	  #001B2H				;set point 
	 LDX	  #00002H				;yoko kosu
	 JSR	  CHGSUB2 
;
	 MEM8 
	 IDX8 
	 SEP	  #00110000B
	 RTL
; 
;/*----------------------------------------------------------------------*/
;/*		tate obj set				 */
;/*----------------------------------------------------------------------*/
TATEST	 EQU	  $ 
	 MEM16
	 REP	  #00100001B		; memory 16bit mode & CLC
;
;;;;;;;;	 LDX	  TATOJC
		LDA	>ITMTBL7
		AND	#000FFH
		TAX
	 LDA	  >CGLPT4,X 
	 AND	  #00FFH
;///////	 CLC
	 ADC	  #TATEOBJ
	 STA	  <WORK0 
; 
	 IDX16
	 REP	  #00010000B
;
	 LDA	  #001B8H				;set point 
	 LDX	  #00003H				;yoko kosu
	 JSR	  CHGSUB2 
;
	 MEM8 
	 IDX8 
	 SEP	  #00110000B
	 RTL
; 
;
;
;/*----------------------------------------------------------------------*/
;/*	  chengi kouka obj cg set 							 */
;/*----------------------------------------------------------------------*/
CHOBJST	 EQU	  $ 
	 MEM16
	 REP	  #00100001B		; memory 16bit mode & CLC
;
	 LDX	  CHOBJJC
	 LDA	  >CGLPT7,X 
	 AND	  #00FFH
;///////	 CLC
	 ADC	  #CHOBJ
	 STA	  <WORK0 
; 
	 IDX16
	 REP	  #00010000B
;
	 LDA	  #001C2H				;set point 
	 LDX	  #00006H				;yoko kosu
	 JSR	  CHGSUB2 
;
	 MEM8 
	 IDX8 
	 SEP	  #00110000B
	 RTL
;

;
;/*----------------------------------------------------------------------*/
;/*	  enmy cg set 2							 */
;/*----------------------------------------------------------------------*/
CHITEMST EQU	  $ 
	 MEM16
	 REP	  #00100001B		; memory 16bit mode & CLC
;
	 LDX	  CHITEMJC
	 LDA	  >CGLPT7,X 
	 AND	  #00FFH
;///////	 CLC
;// 02.10.30 //	 ADC	  #CHITEM
		ADC	#CHOBJ
	 STA	  <WORK0 
; 
	 IDX16
	 REP	  #00010000B
;
	 LDA	  #001D2H				;set point 
	 LDX	  #00006H				;yoko kosu
	 JSR	  CHGSUB2 
;
	 MEM8 
	 IDX8 
	 SEP	  #00110000B
	 RTL
;
;/*----------------------------------------------------------------------*/
;/*	  enmy cg set 2							 */
;/*----------------------------------------------------------------------*/
CHITEMS1 EQU	  $ 
	 MEM16
	 REP	  #00100001B		; memory 16bit mode & CLC
;
	 LDX	  #007H
	 LDA	  <MPDTNO
	 AND	  #00040H
	 BEQ	  CHITM140		; ura ?
;					; yes
	 INX
	 INX
CHITM140 EQU	  $
	 PHX				; (X) push
	 LDA	  >CGLPT7,X 
	 AND	  #00FFH
;///////	 CLC
;// 02.10.30 //	 ADC	  #CHITEM
		ADC	#CHOBJ
	 STA	  <WORK0 
; 
	 IDX16
	 REP	  #00010000B
;
	 LDA	  #00112H				;set point 
	 LDX	  #00006H				;yoko kosu
	 JSR	  CHGSUB2 
;
	 IDX8
	 SEP	  #00010000B
;
	 PLX				; (X) pull
	 DEX
;
	 LDA	  >CGLPT7,X 
	 AND	  #000FFH
	 CLC
         ADC      #CHOBJ
	 STA	  <WORK0 
; 
	 IDX16
	 REP	  #00010000B
;
	 LDA	  #001D2H				;set point 
	 LDX	  #00006H				;yoko kosu
	 JSR	  CHGSUB2 
;
	 MEM8 
	 IDX8 
	 SEP	  #00110000B
	 RTL
; 
;/*----------------------------------------------------------------------*/
;/*	  map obj cg set 						 */
;/*----------------------------------------------------------------------*/
MAPOBSET EQU	  $ 
	 MEM16
	 REP	  #00100001B		; memory 16bit mode & CLC
;
	 LDA	  #MAPOBJ
	 STA	  <WORK0 
; 
	 IDX16
	 REP	  #00010000B
;
	 LDA	  #00182H				;set point 
	 LDX	  #00006H				;yoko kosu
	 LDY	  #00002H				;tate kosu
	 JSR	  CHGSUB3 
;
	 MEM8 
	 IDX8 
	 SEP	  #00110000B
	 RTL
; 
;/*----------------------------------------------------------------------*/
;/*		player cg set						*/
;/*----------------------------------------------------------------------*/
PGCGDT		EQU	$
		WORD	027FFH,048E0H
;
PLCGSET	 EQU	  $ 
	 MEM16
	 REP	  #00100001B		; memory 16bit mode & CLC
;
;;;;;;;;	 LDX	  PLYOJC
		LDA	>ITMTBL8
		AND	#000FFH
		TAX
	 LDA	  >CGLPT8,X 
	 AND	  #00FFH
	 ASL      A
;///////	 CLC
	 ADC	  #PLAYCG
	 STA	  <WORK0 
; 
	 IDX16
	 REP	  #00010000B
;
	 LDA	  #001E2H				;set point 
	 LDX	  #0000EH				;yoko kosu 0->
	 JSR	  CHGSUB2 
PGRVCGST	EQU	$
		MEM16
		IDX16
		REP	#00110000B	; memory,index 16bit mode
;
		LDA	>ITEMR21
		AND	#000FFH
		BEQ	PLCGS80		; power grove on ?
;					; yes
		DEC	A
		ASL	A
		TAX
		LDA	>PGCGDT,X
		STA	>CGRAM+100H+(07DH*2)
		STA	>CGWORK+100H+(07DH*2)
PLCGS80		EQU	$
	 MEM8 
	 IDX8 
	 SEP	  #00110000B
;
		INC	<CGVMAF
	 RTL
; 
; 
;************************************************************************
;*		Title player CG. set			(TPLCGST)	*
;************************************************************************
TPLCGST		EQU	$
		PHB
		LDA	#BANK CORGENE
		PHA
		PLB			; (DBR) set
;
		MEM16
		IDX16
		REP	#00110000B	; memory,index 16bit mode
;
		LDY	#PLAYCG-CORGENE
		LDX	#00000H
TPCGS20		EQU	$
		LDA	CORGENE+01EH*0,Y
		STA	>CGRAM+102H,X
		STA	>CGWORK+102H,X
		LDA	CORGENE+01EH*1,Y
		STA	>CGRAM+142H,X
		STA	>CGWORK+142H,X
		LDA	CORGENE+01EH*2,Y
		STA	>CGRAM+182H,X
		STA	>CGWORK+182H,X
		INY
		INY
		INX
		INX
		CPX	#00020H
		BNE	TPCGS20		; player CG. set end ?
;					; yes
;
		LDY	#KENOBJ-CORGENE
		LDX	#00000H
TPCGS40		EQU	$
		LDA	CORGENE+006H*0,Y
		STA	>CGRAM+132H,X
		STA	>CGWORK+132H,X
		LDA	CORGENE+006H*1,Y
		STA	>CGRAM+172H,X
		STA	>CGWORK+172H,X
		LDA	CORGENE+006H*2,Y
		STA	>CGRAM+1B2H,X
		STA	>CGWORK+1B2H,X
		INY
		INY
		INX
		INX
		CPX	#00006H
		BNE	TPCGS40		; ken CG set end ?
;					; yes
;
		LDY	#TATEOBJ-CORGENE
TPCGS60		EQU	$
		LDA	CORGENE+008H*0,Y
		STA	>CGRAM+132H,X
		STA	>CGWORK+132H,X
		LDA	CORGENE+008H*1,Y
		STA	>CGRAM+172H,X
		STA	>CGWORK+172H,X
		LDA	CORGENE+008H*2,Y
		STA	>CGRAM+1B2H,X
		STA	>CGWORK+1B2H,X
		INY
		INY
		INX
		INX
		CPX	#0000EH
		BNE	TPCGS60		; tate CG. set end ?
;					; yes
;
		LDY	#OBJJYO-CORGENE
		LDX	#00000H
TPCGS80		EQU	$
		LDA	CORGENE+7*2,Y
		STA	>CGRAM+1D0H,X
		STA	>CGWORK+1D0H,X
		LDA	CORGENE+(7+8+7)*2,Y
		STA	>CGRAM+1F0H,X
		STA	>CGWORK+1F0H,X
		INY
		INY
		INX
		INX
		CPX	#0000EH
		BNE	TPCGS80		;
;					;
;
		MEM8
		IDX8
		SEP	#00110000B	; memory,index 8bit mode
;
		PLB			; (DBR) reset
		RTL
;
;
;/*----------------------------------------------------------------------*/
;/*		player cg set						*/
;/*----------------------------------------------------------------------*/
;PLCGSET1 EQU	  $ 
;	 MEM16
;	 REP	  #00100001B		; memory 16bit mode & CLC
;;
;	 LDX	  PLYOJC1
;	 LDA	  >CGLPT8,X 
;	 AND	  #00FFH
;;///////	 CLC
;	 ADC	  #PLAYCG1
;	 STA	  <WORK0 
;; 
;	 IDX16
;	 REP	  #00010000B
;;
;	 LDA	  #001F0H				;set point 
;	 LDX	  #00007H				;yoko kosu
;	 JSR	  CHGSUB2 
;;
;	 MEM8 
;	 IDX8 
;	 SEP	  #00110000B
;	 RTL
;
;
;
;***************************
;****** BG CG DATA SET *****
;***************************
;/*----------------------------------------------------------------------*/
;/*		MAP COLOR cg set						*/
;/*----------------------------------------------------------------------*/
MAPCGSET EQU	  $ 
	 MEM16
	 REP	  #00100001B		; memory 16bit mode & CLC
;
	 LDA	  #MAPCOR 
	 STA	  <WORK0 
; 
	 IDX16
	 REP	  #00010000B
;
	 LDA	  #00040H				;set point 
	 LDX	  #0000FH				;yoko kosu
	 LDY	  #00005H				;tate kosu
	 JSR	  CHGSUB3
;
	 MEM8 
	 IDX8 
	 SEP	  #00110000B
	 RTL

;/*----------------------------------------------------------------------*/
;/*		BG3 2BIT cg set						*/
;/*----------------------------------------------------------------------*/
B3CGSET	 EQU	  $ 
	 MEM16
	 REP	  #00100001B		; memory 16bit mode & CLC
;
	 LDX	  BG3BGC
	 LDA	  >CGLPT16,X 
	 AND	  #00FFH
;///////	 CLC
	 ADC	  #BG32BIT 
	 STA	  <WORK0 
; 
	 IDX16
	 REP	  #00010000B
;
	 LDA	  #00000H				;set point 
	 LDX	  #0000FH				;yoko kosu
	 LDY	  #00001H				;tate kosu
	 JSR	  CHGSUB3
;
	 MEM8 
	 IDX8 
	 SEP	  #00110000B
	 RTL
; 
;/*----------------------------------------------------------------------*/
;/*		danjyou cg set						*/
;/*----------------------------------------------------------------------*/
DANCORST EQU	  $ 
	 MEM16
	 REP	  #00100001B		; memory 16bit mode & CLC
;
	 LDX	  DANJC
	 LDA	  >CGLPT162,X 
;///////	 CLC
	 ADC	  #DANCOR
	 STA	  <WORK0 
; 
	 IDX16
	 REP	  #00010000B
;
	 LDA	  #00042H				;set point 
	 LDX	  #0000EH				;yoko kosu
	 LDY	  #00005H				;tate kosu
	 JSR	  CHGSUB3
;
;/**** obj color set *****/
	 IDX8 
	 SEP	  #00010000B
;
	 LDX	  DANJC
	 LDA	  >CGLPT162,X 
	 CLC
	 ADC	  #DANCOR
	 STA	  <WORK0 
; 
	 IDX16
	 REP	  #00010000B
;
	 LDA	  #00112H				;set point 
	 LDX	  #00006H				;yoko kosu
	 JSR	  CHGSUB2
;
	 MEM8 
	 IDX8 
	 SEP	  #00110000B
	 RTL
; 
;// 03.02.20 //;
;// 03.02.20 //;/*----------------------------------------------------------------------*/
;// 03.02.20 //;/*		tokusyu cg set						*/
;// 03.02.20 //;/*----------------------------------------------------------------------*/
;// 03.02.20 //SPCGSET	 EQU	  $ 
;// 03.02.20 //	 MEM16
;// 03.02.20 //	 REP	  #00100001B		; memory 16bit mode & CLC
;// 03.02.20 //;
;// 03.02.20 //	 LDX	  SPGC
;// 03.02.20 //	 LDA	  >CGLPT7,X 
;// 03.02.20 //	 AND	  #00FFH
;// 03.02.20 //;///////	 CLC
;// 03.02.20 //	 ADC	  #TOKUSYU 
;// 03.02.20 //	 STA	  <WORK0 
;// 03.02.20 //; 
;// 03.02.20 //	 IDX16
;// 03.02.20 //	 REP	  #00010000B
;// 03.02.20 //;
;// 03.02.20 //	 LDA	  #000C2H				;set point 
;// 03.02.20 //	 LDX	  #00006H				;yoko kosu
;// 03.02.20 //	 JSR	  CHGSUB2
;// 03.02.20 //;
;// 03.02.20 //	 MEM8 
;// 03.02.20 //	 IDX8 
;// 03.02.20 //	 SEP	  #00110000B
;// 03.02.20 //	 RTL
; 
;/*----------------------------------------------------------------------*/
;/*		KOUKA BG cg set						*/
;/*----------------------------------------------------------------------*/
KOUKAST	 EQU	  $ 
	 MEM16
	 REP	  #00100001B		; memory 16bit mode & CLC
;
	 LDX	  KOKBGC
	 LDA	  >CGLPT7,X 
	 AND	  #00FFH
;///////	 CLC
	 ADC	  #KOUKABG 
	 STA	  <WORK0 
; 
	 IDX16
	 REP	  #00010000B
;
	 LDA	  #000E2H				;set point 
	 LDX	  #00006H				;yoko kosu
	 JSR	  CHGSUB2
;
	 MEM8 
	 IDX8 
	 SEP	  #00110000B
	 RTL
; 
;/*----------------------------------------------------------------------*/
;/*		cijo bg cg set						*/
;/*----------------------------------------------------------------------*/
GDCGST	 EQU	  $ 
	 MEM16
	 REP	  #00100001B		; memory 16bit mode & CLC
;
;// 03.01.29 //	 LDX	  GNDBGC
;// 03.01.29 //	 LDA	  >CGLPT75,X 
;// 03.01.29 //	 AND	  #00FFH
		LDA	!GNDBGC
		ASL	A
		TAX
		LDA	>CGLPT75,X
;///////	 CLC
	 ADC	  #CIJOBG
	 STA	  <WORK0 
; 
	 IDX16
	 REP	  #00010000B
;
	 LDA	  #00042H				;set point 
	 LDX	  #00006H				;yoko kosu
	 LDY      #00004H				;tate kosu
	 JSR	  CHGSUB3 
;
;// 03.04.15 //;/**** obj color set ******/
;// 03.04.15 //;// 03.01.29 //	 LDX	  GNDBGC
;// 03.04.15 //;// 03.01.29 //	 LDA	  >CGLPT75,X 
;// 03.04.15 //;// 03.01.29 //	 AND	  #00FFH
;// 03.04.15 //		LDA	!GNDBGC
;// 03.04.15 //		ASL	A
;// 03.04.15 //		TAX
;// 03.04.15 //		LDA	>CGLPT75,X
;// 03.04.15 //;///////	 CLC
;// 03.04.15 //	 ADC	  #CIJOBG
;// 03.04.15 //	 STA	  <WORK0 
;// 03.04.15 //; 
;// 03.04.15 //	 IDX16
;// 03.04.15 //	 REP	  #00010000B
;// 03.04.15 //;
;// 03.04.15 //	 LDA	  #00102H				;set point 
;// 03.04.15 //	 LDX	  #00006H				;yoko kosu
;// 03.04.15 //	 JSR	  CHGSUB2 
;
	 MEM8 
	 IDX8 
	 SEP	  #00110000B
	 RTL
; 
;
;
;/*----------------------------------------------------------------------*/
;/*		cijo bg cg set						*/
;/*----------------------------------------------------------------------*/
GDCGST1	 EQU	  $ 
	 MEM16
	 REP	  #00100001B		; memory 16bit mode & CLC
;
	 LDA	  GNDBGC1
	 AND	  #000FFH
	 ASL	  A
	 TAX
	 LDA	  >CGLPT73,X 
;// 02,12,17 //	 AND	  #00FFH
;///////	 CLC
	 ADC	  #CIJOBG1
	 STA	  <WORK0 
; 
	 IDX16
	 REP	  #00010000B
;
	 LDA	  #00052H				;set point 
	 LDX	  #00006H				;yoko kosu
	 LDY      #00002H				;tate kosu
	 JSR	  CHGSUB3
;
	 MEM8 
	 IDX8 
	 SEP	  #00110000B
	 RTL
; 
;
;
;/*----------------------------------------------------------------------*/
;/*		cijo bg cg set						*/
;/*----------------------------------------------------------------------*/
GDCGST2	 EQU	  $ 
	 MEM16
	 REP	  #00100001B		; memory 16bit mode & CLC
;
	 LDA	  GNDBGC2
	 AND	  #000FFH
	 ASL	  A
	 TAX
	 LDA	  >CGLPT73,X 
;// 02,12,17 //	 AND	  #00FFH
;///////	 CLC
	 ADC	  #CIJOBG1
	 STA	  <WORK0 
; 
	 IDX16
	 REP	  #00010000B
;
	 LDA	  #000B2H				;set point 
	 LDX	  #00006H				;yoko kosu
	 LDY      #00002H				;tate kosu
	 JSR	  CHGSUB3 
;
	 MEM8 
	 IDX8 
	 SEP	  #00110000B
	 RTL
;
;
;
;
;
;*********************************************************************
;*	 siro & nuki color set sub				     *
;*	 X -----  0:nuki  1:siro				     *
;*********************************************************************
NKCGSET		EQU	$
		MEM16
	 	REP	#00100000B
;
	 	LDA	#00000H
NKCST40		EQU	$
		STA	>CGWORK+000H
;// 03.06.05 //		STA	>CGWORK+020H
		STA	>CGWORK+040H
;// 03.06.05 //		STA	>CGWORK+060H
;// 03.06.05 //		STA	>CGWORK+080H
;// 03.06.05 //		STA	>CGWORK+0A0H
;// 03.06.05 //		STA	>CGWORK+0C0H
;// 03.06.05 //		STA	>CGWORK+0E0H
;// 03.06.05 //		STA	>CGWORK+100H
;// 03.06.05 //		STA	>CGWORK+120H
;// 03.06.05 //		STA	>CGWORK+140H
;// 03.06.05 //		STA	>CGWORK+160H
;// 03.06.05 //		STA	>CGWORK+180H
;// 03.06.05 //		STA	>CGWORK+1A0H
;// 03.06.05 //		STA	>CGWORK+1C0H
;// 03.06.05 //		STA	>CGWORK+1E0H
NKCST80		EQU	$
		STA	>CGRAM+000H
;// 03.06.05 //		STA	>CGRAM+020H
		STA	>CGRAM+040H
;// 03.06.05 //		STA	>CGRAM+060H
;// 03.06.05 //		STA	>CGRAM+080H
;// 03.06.05 //		STA	>CGRAM+0A0H
;// 03.06.05 //		STA	>CGRAM+0C0H
;// 03.06.05 //		STA	>CGRAM+0E0H
;// 03.06.05 //		STA	>CGRAM+100H
;// 03.06.05 //		STA	>CGRAM+120H
;// 03.06.05 //		STA	>CGRAM+140H
;// 03.06.05 //		STA	>CGRAM+160H
;// 03.06.05 //		STA	>CGRAM+180H
;// 03.06.05 //		STA	>CGRAM+1A0H
;// 03.06.05 //		STA	>CGRAM+1C0H
;// 03.06.05 //		STA	>CGRAM+1E0H
;
		MEM8 
		IDX8 
		SEP	#00110000B
;
		LDA	#00100000B
		STA	<WD2132R
		LDA	#01000000B
		STA	<WD2132G
		LDA	#10000000B
		STA	<WD2132B
		RTL
;
;
; 
;*********************************************************************
;*	 Ground nuki color set sub				     *
;*	 X -----  0:nuki  1:siro				     *
;*********************************************************************
NKCGDTR		EQU	$
		BYTE	005H+020H,007H+020H,013H+020H
NKCGDTG		EQU	$
		BYTE	00FH+040H,014H+040H,00FH+040H
NKCGDTB		EQU	$
		BYTE	005H+080H,007H+080H,009H+080H
;
;
NKCGST0		EQU	$ 
		MEM16
		IDX16
		REP	#00110000B
;
		LDX	#01E87H
		LDA	<MPDTNO
		CMP	#00080H
		BCC	NKCS020		; spot ?
;					; yes
		LDA	<RMXYCT
		CMP	#00183H
		BEQ	NKCS010		; taki boss ?
;					; no
		CMP	#00182H
		BEQ	NKCS010		; taki ?
;					; no
		CMP	#00180H
		BNE	NKCS040		; mori-spot ?
;					; no
NKCS010		EQU	$
		LDX	#015E5H
		BRA	NKCS040
;
NKCS020		EQU	$
		LDX	#01E87H
		LDA	<MPDTNO
		AND	#00040H
		BEQ	NKCS040		; omote ?
;					; no
		LDX	#025F3H
NKCS040		EQU	$
		TXA
		BRA	NKCST40
;
;// 03.05.16 //		STX	<WORK0
;// 03.05.16 //	 LDY	  #0000FH
;// 03.05.16 //	 LDX	  #00000H
;// 03.05.16 //NKCS080  EQU	  $ 
;// 03.05.16 //		LDA	<WORK0
;// 03.05.16 //;// 03.04.17 //		LDA	#00000H
;// 03.05.16 //	 STA	  >CGRAM+000H,X
;// 03.05.16 //	 STA	  >CGWORK+000H,X
;// 03.05.16 //	 TXA
;// 03.05.16 //	 CLC
;// 03.05.16 //	 ADC	  #020H 
;// 03.05.16 //	 TAX
;// 03.05.16 //	 DEY
;// 03.05.16 //	 BPL	  NKCS080 
;// 03.05.16 //; 
;// 03.05.16 //	 MEM8 
;// 03.05.16 //	 IDX8 
;// 03.05.16 //	 SEP	  #00110000B
;// 03.05.16 //;
;// 03.05.16 //		LDA	#00100000B
;// 03.05.16 //;// 03.04.17 //		LDX	<WORK0
;// 03.05.16 //;// 03.04.17 //		LDA	>NKCGDTR,X
;// 03.05.16 //		STA	<WD2132R
;// 03.05.16 //		LDA	#01000000B
;// 03.05.16 //;// 03.04.17 //		LDA	>NKCGDTG,X
;// 03.05.16 //		STA	<WD2132G
;// 03.05.16 //		LDA	#10000000B
;// 03.05.16 //;// 03.04.17 //		LDA	>NKCGDTB,X
;// 03.05.16 //		STA	<WD2132B
;// 03.05.16 //	 RTL
; 
;
;
; 
;*********************************************************************
;*	 Ground nuki color set sub				     *
;*	 X -----  0:nuki  1:siro				     *
;*********************************************************************
NKCGST1		EQU	  $ 
		MEM16
		IDX16
		REP	  #00110000B
;
		LDX	#01E87H
		LDA	<MPDTNO
		CMP	#00080H
		BCC	NKCS120		; spot ?
;					; yes
		LDA	<RMXYCT
		CMP	#00183H
		BEQ	NKCS110		; taki boss ?
;					; no
		CMP	#00182H
		BEQ	NKCS110		; taki ?
;					; no
		CMP	#00180H
		BNE	NKCS140		; mori-spot ?
;					; no
NKCS110		EQU	$
		LDX	#015E5H
		BRA	NKCS140
;
NKCS120		EQU	$
		LDX	#01E87H
		LDA	<MPDTNO
		AND	#00040H
		BEQ	NKCS140		; omote ?
;					; no
		LDX	#025F3H
NKCS140		EQU	$
		TXA
		JMP	NKCST80
;// 03.05.30 //		STA	>CGRAM+000H
;// 03.05.30 //		STA	>CGRAM+020H
;// 03.05.30 //		STA	>CGRAM+040H
;// 03.05.30 //		STA	>CGRAM+060H
;// 03.05.30 //		STA	>CGRAM+080H
;// 03.05.30 //		STA	>CGRAM+0A0H
;// 03.05.30 //		STA	>CGRAM+0C0H
;// 03.05.30 //		STA	>CGRAM+0E0H
;// 03.05.30 //		STA	>CGRAM+100H
;// 03.05.30 //		STA	>CGRAM+120H
;// 03.05.30 //		STA	>CGRAM+140H
;// 03.05.30 //		STA	>CGRAM+160H
;// 03.05.30 //		STA	>CGRAM+180H
;// 03.05.30 //		STA	>CGRAM+1A0H
;// 03.05.30 //		STA	>CGRAM+1C0H
;// 03.05.30 //		STA	>CGRAM+1E0H
;// 03.05.30 //; 
;// 03.05.30 //		MEM8
;// 03.05.30 //		IDX8
;// 03.05.30 //		SEP	#00110000B
;// 03.05.30 //;
;// 03.05.30 //		LDA	#00100000B
;// 03.05.30 //		STA	<WD2132R
;// 03.05.30 //		LDA	#01000000B
;// 03.05.30 //		STA	<WD2132G
;// 03.05.30 //		LDA	#10000000B
;// 03.05.30 //		STA	<WD2132B
;// 03.05.30 //		RTL
;
;
;// 03.05.16 //		STX	<WORK0
;// 03.05.16 //	 LDY	  #0000FH
;// 03.05.16 //	 LDX	  #00000H
;// 03.05.16 //NKCS180  EQU	  $ 
;// 03.05.16 //		LDA	<WORK0
;// 03.05.16 //;// 03.04.17 //		LDA	#00000H
;// 03.05.16 //	 STA	  >CGRAM+000H,X
;// 03.05.16 //	 TXA
;// 03.05.16 //	 CLC
;// 03.05.16 //	 ADC	  #020H 
;// 03.05.16 //	 TAX
;// 03.05.16 //	 DEY
;// 03.05.16 //	 BPL	  NKCS180 
;// 03.05.16 //; 
;// 03.05.16 //	 MEM8 
;// 03.05.16 //	 IDX8 
;// 03.05.16 //	 SEP	  #00110000B
;// 03.05.16 //;
;// 03.05.16 //		LDA	#00100000B
;// 03.05.16 //;// 03.04.17 //		LDX	<WORK0
;// 03.05.16 //;// 03.04.17 //		LDA	>NKCGDTR,X
;// 03.05.16 //		STA	<WD2132R
;// 03.05.16 //		LDA	#01000000B
;// 03.05.16 //;// 03.04.17 //		LDA	>NKCGDTG,X
;// 03.05.16 //		STA	<WD2132G
;// 03.05.16 //		LDA	#10000000B
;// 03.05.16 //;// 03.04.17 //		LDA	>NKCGDTB,X
;// 03.05.16 //		STA	<WD2132B
;// 03.05.16 //	 RTL
; 
;
; 

	 MEM16
	 IDX16
; 
;*********************************************************************
;*	 CHGSUB2						     *
;*	 CHGSUB3						     *
;*								     *
;*	 WORK0,1  <---- ch data addres				     *
;*	 WORK4,5  <---- set ram pointer 			     *
;*	 WORK6,7  <---- yoko set kosu				     *
;*	 WORK8,9  <---- tate set kosu				     *
;*								     *
;*********************************************************************
CHGSUB2  EQU	  $ 
;// 03.05.16 //	 STA	  <WORK4	; set point
;// 03.05.16 //	 STX	  <WORK6	; yoko count
		 TXY		; (Y) <-- (X) : yoko count
;
;// 03.05.16 //		 LDA	  CGSTPT
;// 03.05.16 //		 CLC
;// 03.05.16 //		 ADC	  <WORK4
;// 03.05.16 //		 TAX
		CLC
		ADC	CGSTPT
		TAX
	 LDA	  #BANK CORGENE
	 STA	  <WORK2
;// 03.05.16 //	 LDY	  <WORK6
CS20100  EQU	  $ 
	 LDA	  [<WORK]
	 STA	  >CHGRAM,X				;CGRAM
	 INC	  <WORK0 
	 INC	  <WORK0 
	 INX
	 INX
	 DEY
	 BPL	  CS20100 
; 
	 RTS
; 
; 
; 
CHGSUB3  EQU	  $
	 STA	  <WORK4	; set point
	 STX	  <WORK6	; yoko count
	 STY	  <WORK8	; tate count
;
	 LDA	  #BANK CORGENE
	 STA	  <WORK2
CS30000  EQU	  $ 
		 LDA	  CGSTPT
		 CLC
		 ADC	  <WORK4
		 TAX
	 LDY	  <WORK6
CS30100  EQU	  $ 
	 LDA	  [<WORK]
	 STA	  >CHGRAM,X				;CGRAM
	 INC	  <WORK0 
	 INC	  <WORK0 
	 INX
	 INX
	 DEY
	 BPL	  CS30100 
; 
	 LDA	  <WORK4 
	 CLC
	 ADC	  #00020H 
	 STA	  <WORK4 
; 
	 DEC	  <WORK8 
	 BPL	  CS30000 
; 
	 RTS
; 
; 
; 
; 
; 
		END
