;
		INCLUDE	zel_ram.asm
;
;--------------------------------------------------------------------
;
;		ZELDA-3			1991.06.05(WED)
;
;--------------------------------------------------------------------
;
		ORG	1D8000H
;
;=============================================== (zel_bg3) ===========
		GLB	MTRDSP,SLITEM,MAPDSP,KAIHUKU,KAIMP,BITMCKL
;
		GLB	MTRON2,MTRSUB,ITEMSET,LMPCHCK,ITEM0ST,FLNODSP
;
		GLB	STGITRM
;
		GLB	BOMBER,BUMERN,YUMIYA,HANMER
		GLB	ROD001,ROD002,HUEEEE,SCOPUU
		GLB	LAMPUU,KONAAA,BIN001,BIN002
		GLB	BIN003,HUKUUU,SBOMBE,STHAND
		GLB	SGISIN,SOROMN,KAKURE,TRAIFS
;=============================================== (zel_main) ==========
		EXT	VRAMCL,VRAMCL1,JSRSUB
;
		EXT	MD_title,MD_djint,MD_djply,MD_gdint,MD_gdply
		EXT	MD_evint,MD_evply
		EXT	MD_fdout,MD_fdin,MD_etcpl
		EXT	MD_wpout,MD_wpin,MD_ghldn,MD_gover
;=============================================== (zel_vma) ===========
		EXT	DJBGWT,VDTWT,WBUFS0,WBUFS1
;
		EXT	VT01
;
		EXT	bgw1,bgw8
;=============================================== (zel_data0) =========
		EXT	BITCD0
;=============================================== (zel_char) ==========
		EXT	CHSCHNG
		EXT	B3CGSET,MAPCGSET,MAPOBSET
		EXT	PWTRCGS0
;=============================================== (zel_init) ==========
		EXT	DARKDT
;
		EXT	p1_move,p1_scl0,p1_scl1,p1_bchg,p1_dopn,p1_sdop
		EXT	p1_stpc,p1_hldn,p1_mcng,p1_opyk,p1_bmbd,p1_ltwp
;=============================================== (zel_comn) ==========
		EXT	LGTWPMV
;=============================================== (zel_bgwt) ==========
		EXT	CGEDP0,CGEDPT
;=============================================== (zel_play) ==========
		EXT	SWMD
;=============================================== (zel_rmdt) ==========
		EXT	DJNDT
;=====================================================================
;
		EXTEND
;
		MEM8
		IDX8
;
;
;
;************************************************************************
;*		item NO.						*
;************************************************************************
BOMBER		EQU	001
BUMERN		EQU	002
YUMIYA		EQU	003
HANMER		EQU	004
ROD001		EQU	005
ROD002		EQU	006
HUEEEE		EQU	007
SCOPUU		EQU	008
LAMPUU		EQU	009
KONAAA		EQU	010
BIN001		EQU	011
BIN002		EQU	012
BIN003		EQU	013
HUKUUU		EQU	014
SBOMBE		EQU	015
STHAND		EQU	016
SGISIN		EQU	017
SOROMN		EQU	018
KAKURE		EQU	019
TRAIFS		EQU	020
;************************************************************************
;*		Mater display				(MTRDSP)	*
;************************************************************************
MTRDSP		EQU	$
		PHB
		PHK
		PLB			; (DBR) set
;
		LDA	!ITEMMD
		BEQ	MTRDSPGO	;
;					;
		PLB
		RTL
;
ITEM0ST		EQU	$		;ITEM 0 ni natta toki ni yobu
		PHB
		PHK
		PLB			; (DBR) set
;
		JSR	BITMCK
		JSR	DATTEN
		JSR	MTRON0
		SEP	#00110000B
		STZ	ITEMMD
;					;
		PLB
		RTL
;
MTRDSPGO	EQU	$
;
MTRDSP0		EQU	$
		LDA	>UPMPCT		;MP
		BEQ	MTRDSP2
;
		LDA	>MPNWCT
		CMP	#080H		;? max
		BCC	MTRDSP1
		LDA	#080H		;y
		STA	>MPNWCT
		LDA	#000H
		STA	>UPMPCT
		BRA	MTRDSP2
MTRDSP1		EQU	$
		LDA	>UPMPCT		;MP UP!
		DEC	A
		STA	>UPMPCT
		LDA	>MPNWCT
		INC	A
		STA	>MPNWCT
;
MTRDSP2		EQU	$
		LDA	DWCNCT		; down COIN
		BEQ	MTRDSP3
;
		DEC	DWCNCT
		MEM16
		IDX16
		REP	#00110000B
		LDA	>CONCNT
		BEQ	MTR023
		DEC	A
		STA	>CONCNT
MTR023		EQU	$
		MEM8
		IDX8
		SEP	#00110000B
;
MTRDSP3		EQU	$		
		LDA	>UPCNCT		; up COIN
		BEQ	MTRDSP4
		LDA	>UPCNCT
		DEC	A
		STA	>UPCNCT
		MEM16
		IDX16
		REP	#00110000B
		LDA	>CONCNT
		CMP	#999
		BEQ	MTR035
		INC	A
		STA	>CONCNT
MTR035		EQU	$
		MEM8
		IDX8
		SEP	#00110000B
;
MTRDSP4		EQU	$		;BOMB
		LDA	>UPBMCT
		BEQ	MTRDSP5
		LDA	>UPBMCT
		DEC	A
		STA	>UPBMCT
		LDA	>BMBCNT
		CMP	#99
		BEQ	MTR045
		INC	A
		STA	>BMBCNT
MTR045		EQU	$
;
MTRDSP5		EQU	$		;YA
		LDA	>UPAWCT
		BEQ	MTRDSP6
		LDA	>UPAWCT
		DEC	A
		STA	>UPAWCT
		LDA	>ARWCNT
		CMP	#255
		BEQ	MTR055
		INC	A
		STA	>ARWCNT
;
MTR055		EQU	$
		LDA	>ITEMR01
		BEQ	MTRDSP6		;? YUMI NASHI
;					;N
		CMP	#001H		;? YA NASHI
		BNE	MTRDSP6
;					;Y
		LDA	#002H
		STA	>ITEMR01	;YA ON
;
		JSL	>ITEM0ST
;
MTRDSP6		EQU	$
;
		LDA	KAIFLG
		BNE	MTRDSP8
		LDA	>UPLFCT
		BEQ	MTRDSP9
		LDA	>LFNWCT
		CMP	>LFITCT
		BCC	MTRDSP7
		LDA	>LFITCT
		STA	>LFNWCT
		LDA	#000H
		STA	>UPLFCT
		BRA	MTRDSP9
MTRDSP7		EQU	$
		LDA	>UPLFCT
		SEC
		SBC	#008H
		STA	>UPLFCT
		INC	KAIFLG
		LDA	#007H
		STA	KAICNT
MTRDSP8		EQU	$
;
		MEM16
		IDX16
		REP	#00110000B
;
		LDA	#0FFFFH
		STA	<WORK+0EH
		JSR	MPWT		;MP COIN BOMB YA WRITE
		JSR	KAIHUKU1
;
		MEM8
		IDX8
		SEP	#00110000B
;
		INC	<B3CHFG		; mater write flag on
;
		PLB			; (DBR) reset
		RTL
;
MTRDSP9		EQU	$
;
		MEM16
		IDX16
		REP	#00110000B
;
		LDA	#0FFFFH
		STA	<WORK+0EH
		JSR	LIFEWT		;LIFE MP COIN BOMB YA WRITE
;
		MEM8
		IDX8
		SEP	#00110000B
;
		INC	<B3CHFG		; mater write flag on
;
		PLB			; (DBR) reset
		RTL
;
;
;
;************************************************************************
;*		Select ITEM	main			(SLITEM)	*
;************************************************************************
SLITEM		EQU	$
		PHB
		PHK
		PLB			; (DBR) set
;
		JSR	SLITMSB2
;
		PLB			; (DBR) reset
		RTL
;
;
ITEMSET		EQU	$
		JSR	ITEMS00
		RTL
;
;
;
SLITMSB2	EQU	$
		INC	IFRCNT0		; item frcnt 0
;
		LDA	!ITEMMD
		JSL	>JSRSUB
		WORD	SLITM100	;0  : init - 0
		WORD	SLITM300	;1  :      - 1
		WORD	SLITM700	;2  : scroll
		WORD	WAITMV		;3  : wait
		WORD	BMOVE		;4  : B move
		WORD	DATTEN		;5  : exit
		WORD	SLITM900	;6  : scroll
;					;   : bin select
		WORD	BINSCT10	;7  : init
		WORD	BINSCT20	;8  : kuro nuri
		WORD	BINSCT30	;9  : waku write
		WORD	BINSCT40	;A  : select
		WORD	BINSCT50	;B  : nuki nuri
		WORD	BINSCT60	;B  : moto ni modosu
;
SLITM100	EQU	$
		MEM16
		REP	#00100000B	; memory 16bit mode
;
		LDX	#000H
		LDA	#0207FH
SLITM120	EQU	$
		STA	!WBGBUF+000H,X
		STA	!WBGBUF+080H,X
		STA	!WBGBUF+100H,X
		STA	!WBGBUF+180H,X
		STA	!WBGBUF+200H,X
		STA	!WBGBUF+280H,X
		STA	!WBGBUF+300H,X
		STA	!WBGBUF+380H,X
		STA	!WBGBUF+400H,X
		STA	!WBGBUF+480H,X
		STA	!WBGBUF+500H,X
		STA	!WBGBUF+580H,X
		STA	!WBGBUF+600H,X
		STA	!WBGBUF+680H,X
		STA	!WBGBUF+700H,X
		STA	!WBGBUF+780H,X
		INX
		INX
		CPX	#080H
		BNE	SLITM120	; clear end ?
;					; yes
		MEM8
		SEP	#00100000B	; memory 8bit mode
;
		LDA	#bgw1
		STA	<BGWTFG
		LDA	#022H
		STA	!NXBWFG
		INC	!ITEMMD
		RTS
;
;
SLITM300	EQU	$
		JSR	BITMCK		;ITEM CHK
;
		LDA	#01
		JSR	WAKUTEN		;tenmetu color
		JSR	WTWAKU1
		LDA	#01
		JSR	WAKUTEN		;tenmetu color
		JSR	WTWAKU2
		LDA	#01
		JSR	WAKUTEN		;tenmetu color
		JSR	WTWAKU3
;		LDA	#01
;		JSR	WAKUTEN		;tenmetu color
		JSR	WTWAKU4I
;		LDA	#01
;		JSR	WAKUTEN		;tenmetu color
		JSR	WTWAKU5
		LDA	#01
		JSR	WAKUTEN		;tenmetu color
		JSR	WTWAKU6
;		LDA	#01
;		JSR	WAKUTEN		;tenmetu color
		JSR	WTWAKU7I
;		LDA	#01
;		JSR	WAKUTEN		;tenmetu color
		JSR	WTWAKU8I
		LDA	#01
		JSR	WAKUTEN		;tenmetu color
		JSR	WTWAKU9
;		LDA	#01
;		JSR	WAKUTEN		;tenmetu color
		JSR	WTWAKUAI
;		LDA	#01
;		JSR	WAKUTEN		;tenmetu color
		JSR	WTWAKUBI
;		LDA	#01
;		JSR	WAKUTEN		;tenmetu color
		JSR	WTWAKUCI
;		LDA	#01
;		JSR	WAKUTEN		;tenmetu color
		JSR	WTWAKUDI
;
		LDX	#018
		LDA	>ITEMR01
SLITM330	EQU	$
		ORA	>ITEMR02,X
		DEX
		BPL	SLITM330
		CMP	#000H
		BEQ	SLITM320	;? NO ITEM
;					;N
		LDA	>BINCT0
		ORA	>BINCT1
		ORA	>BINCT2
		ORA	>BINCT3
		BNE	SLITM350
		BRA	SLITM360	;CLS
SLITM350	EQU	$
		LDA	>ITEMR16
		BNE	SLITM340	;? HAGIMETE
		TAY			;Y
		INY	
		LDA	>BINCT0
		BNE	SLITM370
		INY	
		LDA	>BINCT1
		BNE	SLITM370
		INY	
		LDA	>BINCT2
		BNE	SLITM370
		INY
SLITM370	EQU	$
		TYA
SLITM360	EQU	$
		STA	>ITEMR16
SLITM340	EQU	$
		JSR	BMVSP1
		BCS	SLITM310
		JSR	BMVSP3RT
SLITM310	EQU	$
;		LDA	#01
;		JSR	WAKUTEN		;tenmetu color
;		JSR	WTWAKU1
		JSR	WTWAKU12I
		LDA	GETITM0		;? ITEM BIN SELECT
		CMP	#016
		BNE	SLITM320
		LDA	#01
		JSR	WAKUTEN		;tenmetu color
		JSR	WTBINST		; BIN SELECT
;
SLITM320	EQU	$
		LDA	#010H
		STA	IFRCNT1
		LDA	#bgw1
		STA	<BGWTFG
		LDA	#022H
		STA	!NXBWFG
		INC	!ITEMMD
		RTS
;
;
;// 03.02.14 //SLITM500	EQU	$
;// 03.02.14 //;// 03.02.08 //		JSR	MTROFF		; mater off
;// 03.02.14 //;
;// 03.02.14 //		INC	!ITEMMD
;// 03.02.14 //		RTS
;
;
SLITM700	EQU	$
		MEM16
		REP	#00100000B	; memory 16bit mode
;
		LDA	<SCCV3
		SEC
		SBC	#00008H
		STA	<SCCV3
		CMP	#0FF20H
;
		MEM8
		SEP	#00100000B	; memory 8bit mode
;
		BNE	SLITM720	; 1st. scroll end ?
;					; yes
		INC	!ITEMMD
SLITM720	EQU	$
		RTS
;
;
WAITMV		EQU	$
		LDX	#018
		LDA	>ITEMR01
WAITMV40	EQU	$
		ORA	>ITEMR02,X
		DEX
		BPL	WAITMV40
		CMP	#000H
		BEQ	WAITMV20
		LDA	#bgw1		;consol write
		STA	<BGWTFG
		LDA	#022H
		STA	!NXBWFG
		JSR	BMVSP1
		BCS	WAITMV30
		JSR	BMVSP3RT
WAITMV30	EQU	$
		JSR	WTWAKU12I
		LDA	#004H
		STA	!ITEMMD
;
		LDA	GETITM0		;?ITEM BIN SELECT
		CMP	#016
		BNE	WAITMV50
		LDA	#00AH
		STA	ITEMMD
		
WAITMV50	EQU	$
		RTS
WAITMV20	EQU	$
		LDA	<KEYA2
		BEQ	WAITMV10
		LDA	#005H
		STA	!ITEMMD
WAITMV10	EQU	$
		RTS
;
;
BMVSP1		EQU	$		;MOTTE IRU ITEM GA ARUKA ?
		LDX	GETITM0
		LDA	>ITEMR01-1,X
		BNE	BMVSP110
		CLC			;N
		RTS
BMVSP110	EQU	$		;Y
		SEC
		RTS
;
;
BMVSP2LT	EQU	$		; <<
		LDA	GETITM0
		DEC	A
		CMP	#001H
		BCS	BMVSP2L1
		LDA	#020
BMVSP2L1	EQU	$
		STA	GETITM0
		RTS
;
;
BMVSP2RT	EQU	$		; >>
		LDA	GETITM0
		INC	A
		CMP	#021
		BCC	BMVSP2R1
		LDA	#001H
BMVSP2R1	EQU	$
		STA	GETITM0
		RTS
;
;
BMVSP3LT	EQU	$		; << (WHILE)
		JSR	BMVSP2LT
		JSR	BMVSP1
		BCC	BMVSP3LT
		RTS
;
;
BMVSP3RT	EQU	$		; >> (WHILE)
		JSR	BMVSP2RT
		JSR	BMVSP1
		BCC	BMVSP3RT
		RTS
;
;
BMVSP3UP	EQU	$		; << (WHILE)
		JSR	BMVSP2LT
		JSR	BMVSP2LT
		JSR	BMVSP2LT
		JSR	BMVSP2LT
		JSR	BMVSP2LT
		JSR	BMVSP1
		BCC	BMVSP3UP
		RTS
;
;
BMVSP3DN	EQU	$		; >> (WHILE)
		JSR	BMVSP2RT
		JSR	BMVSP2RT
		JSR	BMVSP2RT
		JSR	BMVSP2RT
		JSR	BMVSP2RT
		JSR	BMVSP1
		BCC	BMVSP3DN
		RTS
;
;
BMOVE		EQU	$
		INC	IFRCNT1		; item frcnt 1
;
		LDA	<KEYA2
		AND	#11010000B
		BEQ	BMOVE20
;// 03.02.14 //		LDA	#06H
		LDA	#005H
		STA	!ITEMMD
		RTS
;
BMOVE20		EQU	$
		LDA	<KEYA1
		AND	#00100000B
		BEQ	BMOVE0		; selelct on ?
;					; yes
		LDA	<KEYA1L
		AND	#00010000B
		BEQ	BMOVE0		; pause reset ?
;					; yes
		MEM16
		REP	#00100000B	; memory 16bit mode
;
		LDA	#00000H
		STA	>CGWORK+000H
		LDA	>CGRAM+040H
		STA	>CGWORK+040H
;
		MEM8
		SEP	#00100000B	; memory 8bit mode
;
		STZ	!FLNODFG
		JSL	>FLNODSP	; floor no. off
		INC	<B3CHFG
;
		LDA	#MD_gover
		STA	<SLMODE
		LDA	#002H
		STA	<GAMEMD
		STZ	<SCCV3
		STZ	<SCCV31
		STZ	!BMMODE
		LDA	#040H
		STA	!KGCHPT
		RTS
;
;
BMOVE0		EQU	$
		LDA	<KEYA2		;UP ?
		AND	#008H
		BEQ	BMOVE1
		JSR	BMVSP3UP
		BRA	BMOVEEX
BMOVE1		EQU	$
		LDA	<KEYA2
		AND	#004H
		BEQ	BMOVE2
		JSR	BMVSP3DN
		BRA	BMOVEEX
BMOVE2		EQU	$
		LDA	<KEYA2
		AND	#002H
		BEQ	BMOVE3
		JSR	BMVSP3LT
		BRA	BMOVEEX
BMOVE3		EQU	$
		LDA	<KEYA2
		AND	#001H
		BEQ	BMOVE4
		JSR	BMVSP3RT
BMOVEEX		EQU	$
		LDA	#010H		;consol on
		STA	IFRCNT1
BMOVE4		EQU	$
		LDA	#01		; waku 1 to B item o on
		JSR	WAKUTEN
		JSR	WTWAKU1
		JSR	WTWAKU12I
;
		LDA	GETITM0		;?ITEM BIN01
		CMP	#016
		BNE	BMOVE5
		LDA	#007H		;BIN SELECT
		STA	ITEMMD
;
BMOVE5		EQU	$
;
		LDA	#bgw1
		STA	<BGWTFG
		LDA	#022H		;BG ni kaku
		STA	!NXBWFG
		RTS
;
;
DATTEN		EQU	$		; exit
		INC	!ITEMMD
;
		JSR	MTRON1		; mater in write
;
ITEMS00		EQU	$
                LDX     GETITM0		;B item data tfr
		LDA	>BTFRDAT,X
		STA	BPSHMD
;
;		LDA	>YTFRDAT,X
;               STA     YPSHMD
		RTS
;
;
SLITM900	EQU	$
		MEM16
		REP	#00100000B	; memory 16bit mode
;
		LDA	<SCCV3
		CLC
		ADC	#00008H
		STA	<SCCV3
;
		MEM8
		SEP	#00100000B	; memory 8bit mode
;
		BNE	SLITM980	; end ?
;					; yes
		JSR	MTRON0		; mater on
;
		STZ	!ITEMMD		; item select off
		STZ	<GAMEMD		; select item end
		LDA	!NXSLMD
		STA	<SLMODE
;
		JSL	>LMPCHCK	; lamp on/off check
;
		LDA	!BPSHMD
;// 02.10.22 //		CMP	#002H
		CMP	#ROD001
		BEQ	SLITM940	; lot select ?
;					; no
		CMP	#ROD002
		BEQ	SLITM940	; lot select ?
;					; no
;		CMP	#ROD003
;		BEQ	SLITM940	; lot select ?
;					; no
		LDA	#002H	
		STA	!TMDTFG
		STZ	!TMBMCT
		BRA	SLITM980
SLITM940	EQU	$
		LDA	TMBMCT
		BNE	SLITM900
		
		STZ	!TMDTFG
SLITM980	EQU	$
		RTS
;
;
;************************************************************************
;*		YAMAMOTO SUB P.						*
;************************************************************************
BINSCT10	EQU	$
		STZ	IWORK0		;INIT CNT
;
		INC	ITEMMD
		RTS
;----------------------------------------
BINSCT20	EQU	$
		MEM16
		IDX16
		REP	#00110000B
;
		LDA	IWORK0
		AND	#000FFH
		ASL	A
		ASL	A
		ASL	A
		ASL	A
		ASL	A
		ASL	A
		TAX
		LDA	#NUKIDT
		STA	IWAKU5+000H,X
		STA	IWAKU5+002H,X
		STA	IWAKU5+004H,X
		STA	IWAKU5+006H,X
		STA	IWAKU5+008H,X
		STA	IWAKU5+00AH,X
		STA	IWAKU5+00CH,X
		STA	IWAKU5+00EH,X
		STA	IWAKU5+010H,X
		STA	IWAKU5+012H,X
;
		MEM8
		IDX8
		SEP	#00110000B
;
		INC	IWORK0
		LDA	IWORK0
		CMP	#013H
		BNE	BINSCT25
		INC	ITEMMD
		LDA	#011H		;CLS CNT
		STA	IWORK0
BINSCT25	EQU	$
		LDA	#bgw1
		STA	<BGWTFG
		LDA	#022H
		STA	!NXBWFG
		RTS
;----------------------------------------
BINSCT3D	EQU	$
		WORD	028FBH,028F9H,028F9H,028F9H
		WORD	028F9H,028F9H,028F9H,028F9H
		WORD	028F9H,068FBH
;
		WORD	028FCH,KURODT,KURODT,KURODT
		WORD	KURODT,KURODT,KURODT,KURODT
		WORD	KURODT,068FCH
;
		WORD	0A8FBH,0A8F9H,0A8F9H,0A8F9H
		WORD	0A8F9H,0A8F9H,0A8F9H,0A8F9H
		WORD	0A8F9H,0E8FBH
BINSCT30	EQU	$
		MEM16
		IDX16
		REP	#00110000B
;
		LDA	IWORK0
		AND	#000FFH
		ASL	A
		ASL	A
		ASL	A
		ASL	A
		ASL	A
		ASL	A
		TAX
		PHX
;
		LDY	#00012H
BINSCT37	EQU	$
		LDA	BINSCT3D,Y
		STA	IWAKU5+012H,X
		DEX
		DEX
		DEY
		DEY
		BPL	BINSCT37
;
		PLX
		LDY	#00012H
BINSCT35	EQU	$
		LDA	BINSCT3D+014H,Y
		STA	IWAKU5+040H+012H,X
		DEX
		DEX
		DEY
		DEY
		BPL	BINSCT35
;
		LDX	#00012H
BINSCT39	EQU	$
		LDA	BINSCT3D+028H,X
		STA	IWAKU5+480H,X
		DEX
		DEX
		BPL	BINSCT39
;
		MEM8
		IDX8
		SEP	#00110000B
;
		DEC	IWORK0
		LDA	IWORK0
		BPL	BINSCT33
		INC	ITEMMD
BINSCT33	EQU	$
		LDA	#bgw1
		STA	<BGWTFG
		LDA	#022H
		STA	!NXBWFG
		RTS
;----------------------------------------
BINSCT40	EQU	$
		INC	IFRCNT1		;FRCNT
;
		LDA	<KEYA2
		AND	#11010000B
		BEQ	BINSCT48
		LDA	#005H		;EXIT
		STA	!ITEMMD
		BRA	BINSCT49
;
BINSCT48	EQU	$
		LDA	<KEYA2
		AND	#003H
		BEQ	BINSCT49
;
		LDA	<KEYA2
		AND	#002H
		BEQ	BINSCT43
		JSR	BMVSP3LT
		BRA	BINSCT45
BINSCT43	EQU	$
		JSR	BMVSP3RT
BINSCT45	EQU	$
		LDA	#010H		;consol on
		STA	IFRCNT1
		LDA	#01		; waku 1 to B item o on
		JSR	WAKUTEN
		JSR	WTWAKU1
		JSR	WTWAKU12I
;
		INC	ITEMMD
		STZ	IWORK0		;CLS CNT
		RTS
BINSCT49	EQU	$
		JSR	BINSTS40	;WRITE BG
		LDA	<KEYA2
		AND	#00CH
		BNE	BINSCT47
		RTS
;
BINSCT47	EQU	$
		LDA	#010H		;CONSOL ON
		STA	IFRCNT1
;
		LDA	>ITEMR16
		DEC	A
		STA	<WORK0
		LDA	<KEYA2
		AND	#008H
		BEQ	BINSCT44	;? UP
BINSCT4A	EQU	$
		LDA	<WORK0		;Y
		DEC	A
		AND	#003H
		STA	<WORK0
		TAX
		LDA	>BINCT0,X
		BEQ	BINSCT4A
		BRA	BINSCT46
BINSCT44	EQU	$
		LDA	<WORK0		;DOWN
		INC	A
		AND	#003H
		STA	<WORK0
		TAX
		LDA	>BINCT0,X
		BEQ	BINSCT44
BINSCT46	EQU	$
		LDA	<WORK0
		INC	A
		STA	>ITEMR16
;
BINSCT42	EQU	$
		RTS
;----------------------------------------;CONSOL WRITE
BNS40CNS	EQU	$
		WORD	00088H,00188H,00288H,00388H
BINSTS40	EQU	$
		MEM16
		IDX16
		REP	#00110000B
;
		LDX	#00000H		;---	KURO
		LDY	#00007H		;
		LDA	#KURODT
BINSTS41	EQU	$
		STA	IWAKU5+042H,X
		STA	IWAKU5+082H,X
		STA	IWAKU5+0C2H,X
		STA	IWAKU5+102H,X
		STA	IWAKU5+142H,X
		STA	IWAKU5+182H,X
		STA	IWAKU5+1C2H,X
		STA	IWAKU5+202H,X
		STA	IWAKU5+242H,X
		STA	IWAKU5+282H,X
		STA	IWAKU5+2C2H,X
		STA	IWAKU5+302H,X
		STA	IWAKU5+342H,X
		STA	IWAKU5+382H,X
		STA	IWAKU5+3C2H,X
		STA	IWAKU5+402H,X
		STA	IWAKU5+442H,X
		INX
		INX
		DEY
		BPL	BINSTS41
;
		LDA	#IWAKU5+088H	;TFR SAKI
		STA	<WORK0
		LDA	>BINCT0		;NO. SET
		AND	#000FFH
		STA	<WORK2
		LDA	#RITEM29	;TFR MOTO 
		STA	<WORK4
		JSR	SETITEM		;SET ITEM
;
;					;BIN2 SET
		LDA	#IWAKU5+188H	;TFR SAKI
		STA	<WORK0
		LDA	>BINCT1		;NO. SET
		AND	#000FFH
		STA	<WORK2
		LDA	#RITEM30	;TFR MOTO 
		STA	<WORK4
		JSR	SETITEM		;SET ITEM
;
;					;BIN3 SET
		LDA	#IWAKU5+288H	;TFR SAKI
		STA	<WORK0
		LDA	>BINCT2		;NO. SET
		AND	#000FFH
		STA	<WORK2
		LDA	#RITEM31	;TFR MOTO 
		STA	<WORK4
		JSR	SETITEM		;SET ITEM
;
;
		LDA	#IWAKU5+388H	;TFR SAKI
		STA	<WORK0
		LDA	>BINCT3		;NO. SET
		AND	#000FFH
		STA	<WORK2
		LDA	#RITEM32	;TFR MOTO 
		STA	<WORK4
		JSR	SETITEM		;SET ITEM
;
;
		LDA	#WITEM16	;TFR SAKI
		STA	<WORK0
		LDA	>ITEMR16	;NO. SET
		AND	#000FFH
		TAX
		LDA	>BINCT0-1,X
		AND	#000FFH
		STA	<WORK2
		LDA	#RITEM16	;TFR MOTO 
		STA	<WORK4
		JSR	SETITEM		;SET ITEM
;
;
		LDA	GETITM0		;WAKU2 WRITE
		AND	#000FFH
		DEC	A
		ASL	A
		TAX
		LDY	STGITWM,X
		LDA	WBGBUF-WBGBUF,Y
		STA	IWAKU2+48H
		LDA	WBGBUF-WBGBUF+002H,Y
		STA	IWAKU2+4AH
		LDA	WBGBUF-WBGBUF+040H,Y
		STA	IWAKU2+88H
		LDA	WBGBUF-WBGBUF+042H,Y
		STA	IWAKU2+8AH
;
;
		LDA	>ITEMR16
		DEC	A
		AND	#000FFH
		ASL	A
		TAY
		LDA	BNS40CNS,Y
		TAY
;
		LDA	IFRCNT1
		AND	#010H
		BEQ	BINSTS49
		LDA	#03C61H		;consol set
		STA	IWAKU5-40H,Y
		ORA	#04000H
		STA	IWAKU5-3EH,Y
		LDA	#03C70H
		STA	IWAKU5-02H,Y
		ORA	#04000H
		STA	IWAKU5+04H,Y
		LDA	#0BC70H
		STA	IWAKU5+3EH,Y
		ORA	#04000H
		STA	IWAKU5+44H,Y
		LDA	#0BC61H
		STA	IWAKU5+80H,Y
		ORA	#04000H
		STA	IWAKU5+82H,Y
		LDA	#03C60H
		STA	IWAKU5-42H,Y
		ORA	#04000H
		STA	IWAKU5-3CH,Y
		ORA	#08000H
		STA	IWAKU5+84H,Y
		EOR	#04000H
		STA	IWAKU5+7EH,Y
;
;
		LDA	>ITEMR16
		AND	#000FFH
		BEQ	BINSTS43
		TAX
		LDA	>BINCT0-1,X
		AND	#000FFH
		DEC	A
;		BEQ	BINSTS43
;		DEC	A		;pri. ok
		ASL	A
		ASL	A
		ASL	A
		ASL	A
		ASL	A
		TAX
		LDY	#00000H
BINSTS42	EQU	$
		LDA	BINMOJI,X
		STA	!IWAKU2+0C2H,Y
		LDA	BINMOJI+10H,X
		STA	!IWAKU2+102H,Y
		INX
		INX
		INY
		INY
		CPY	#00010H
		BCC	BINSTS42
BINSTS43	EQU	$
;
;
BINSTS49	EQU	$
		MEM8
		IDX8
		SEP	#00110000B
;
		LDA	#bgw1
		STA	<BGWTFG
		LDA	#022H
		STA	!NXBWFG
		RTS
;----------------------------------------
BINSCT50	EQU	$
		MEM16
		IDX16
		REP	#00110000B
;
		LDA	IWORK0
		AND	#000FFH
		ASL	A
		ASL	A
		ASL	A
		ASL	A
		ASL	A
		ASL	A
		TAX
		LDA	#NUKIDT
		STA	IWAKU5+000H,X
		STA	IWAKU5+002H,X
		STA	IWAKU5+004H,X
		STA	IWAKU5+006H,X
		STA	IWAKU5+008H,X
		STA	IWAKU5+00AH,X
		STA	IWAKU5+00CH,X
		STA	IWAKU5+00EH,X
		STA	IWAKU5+010H,X
		STA	IWAKU5+012H,X
;
		MEM8
		IDX8
		SEP	#00110000B
;
		INC	IWORK0
		LDA	IWORK0
		CMP	#013H
		BNE	BINSCT55
		INC	ITEMMD
BINSCT55	EQU	$
		LDA	#bgw1
		STA	<BGWTFG
		LDA	#022H
		STA	!NXBWFG
		RTS
;----------------------------------------
BINSCT60	EQU	$
		JSR	WTWAKU5
		LDA	#01
		JSR	WAKUTEN		;tenmetu color
		JSR	WTWAKU6
;		LDA	#01
;		JSR	WAKUTEN		;tenmetu color
		JSR	WTWAKU7I
;		LDA	#01
;		JSR	WAKUTEN		;tenmetu color
		JSR	WTWAKU8I
		LDA	#01
		JSR	WAKUTEN		;tenmetu color
		JSR	WTWAKU9
;		LDA	#01
;		JSR	WAKUTEN		;tenmetu color
		JSR	WTWAKUAI
;		LDA	#01
;		JSR	WAKUTEN		;tenmetu color
		JSR	WTWAKUBI
;		LDA	#01
;		JSR	WAKUTEN		;tenmetu color
		JSR	WTWAKUCI
;		LDA	#01
;		JSR	WAKUTEN		;tenmetu color
		JSR	WTWAKUDI
;
		LDA	#004H		;B ITEM SELECT
		STA	ITEMMD
		LDA	#bgw1
		STA	<BGWTFG
		LDA	#022H
		STA	!NXBWFG
		RTS
;----------------------------------------
SETITEM		EQU	$
;
;		<WORK0,1 : TFR SAKI SET
;
;		<WORK2,3 : NO. SET(NANBANME)
;
;		<WORK4,5 : TFR MOTO
;
;
		MEM16
		IDX16
;
		LDA	<WORK2		;TFR MOTO GET
		ASL	A
		ASL	A
		ASL	A
		TAY
;
		LDX	<WORK0		;TFR SAKI SET
;
		LDA	(<WORK4),Y
		STA	WBGBUF-WBGBUF+000H,X
		INY
		INY
		LDA	(<WORK4),Y
		STA	WBGBUF-WBGBUF+002H,X
		INY
		INY
		LDA	(<WORK4),Y
		STA	WBGBUF-WBGBUF+040H,X
		INY
		INY
		LDA	(<WORK4),Y
		STA	WBGBUF-WBGBUF+042H,X
;
		RTS
;
		MEM8
		IDX8
;
;
;----------------------------------------
;
;
;
BITMCKL		EQU	$		;JSL BITMCK
		JSR	BITMCK
		RTL
;---
BITMCK		EQU	$		;item ga nakanatta yooon
		MEM8
		IDX8
		SEP	#00110000B
;
		LDX	#018
		LDA	>ITEMR01
BITMCK4		EQU	$
		ORA	>ITEMR02,X
		DEX
		BPL	BITMCK4
		CMP	#000H
		BNE	BITMCK1
		STZ	GETITM0
		STZ	GETITM0+1
		STZ	GETITM0+2
BITMCK3		EQU	$
		RTS
BITMCK1		EQU	$
		LDA	GETITM0
		BNE	BITMCK2
		LDA	#001H
		STA	GETITM0
BITMCK2		EQU	$
		JSR	BMVSP1
		BCS	BITMCK3
		JMP	BMVSP3RT
;
;
WAKUTEN		EQU	$
		MEM8
		IDX8
		SEP	#00110000B
;
		LDX	#0E3H		;A<>0 -- WORK+1=8
		CMP	#000		;
		BEQ	WAKUTEN2	;waku no tenmetu
		LDX	#0FFH		;
WAKUTEN2	EQU	$
		STX	<WORK+1
		LDA	#0FFH
		STA	<WORK
		RTS
;
;
WTWAKU1		EQU	$		;waku 1 o kaku
		MEM16
		IDX16
		REP	#00110000B
;
		LDA	#03CFBH		;KADO
		AND	<WORK		; iro
		STA	!IWAKU1		;[
		ORA	#08000H
		STA	!IWAKU1+380H	;[
		ORA	#04000H
		STA	!IWAKU1+3A4H	;]
		EOR	#08000H
		STA	!IWAKU1+024H	;]
;
		LDX	#00000H		;|	TATE
		LDY	#0000CH		;|
WTWK110		EQU	$
		LDA	#03CFCH
		AND	<WORK		; iro
		STA	!IWAKU1+040H,X
		ORA	#04000H
		STA	!IWAKU1+064H,X
		TXA
		CLC
		ADC	#00040H
		TAX
		DEY
		BPL	WTWK110
;
		LDX	#00000H		;---	YOKO
		LDY	#00010H		;
WTWK120		EQU	$
		LDA	#03CF9H
		AND	<WORK		; iro
		STA	!IWAKU1+002H,X
		ORA	#08000H
		STA	!IWAKU1+382H,X
		INX
		INX
		DEY
		BPL	WTWK120
;
		LDX	#00000H		;---	KURO
		LDY	#00010H		;
		LDA	#KURODT
WTWK130		EQU	$
		STA	!IWAKU1+042H,X
		STA	!IWAKU1+082H,X
		STA	!IWAKU1+0C2H,X
		STA	!IWAKU1+102H,X
		STA	!IWAKU1+142H,X
		STA	!IWAKU1+182H,X
		STA	!IWAKU1+1C2H,X
		STA	!IWAKU1+202H,X
		STA	!IWAKU1+242H,X
		STA	!IWAKU1+282H,X
		STA	!IWAKU1+2C2H,X
		STA	!IWAKU1+302H,X
		STA	!IWAKU1+342H,X
		INX
		INX
		DEY
		BPL	WTWK130
;
		LDA	#03CF0H		;Y write
		STA	!IWAKU1+042H
		LDA	#03CF1H
		STA	!IWAKU1+082H
;
		LDA	#0246EH		;ITEM write
		STA	!IWAKU1+004H
		LDA	#0246FH
		STA	!IWAKU1+006H
;
;					;YUMI SET
		LDA	#WITEM01	;TFR SAKI
		STA	<WORK0
		LDA	>ITEMR01	;NO. SET
		AND	#000FFH
		STA	<WORK2
		LDA	#RITEM01	;TFR MOTO 
		STA	<WORK4
		JSR	SETITEM		;SET ITEM
;
;					;BUMERN SET
		LDA	#WITEM02	;TFR SAKI
		STA	<WORK0
		LDA	>ITEMR02	;NO. SET
		AND	#000FFH
		STA	<WORK2
		LDA	#RITEM02	;TFR MOTO 
		STA	<WORK4
		JSR	SETITEM		;SET ITEM
;
;					;HUKKU SET
		LDA	#WITEM03	;TFR SAKI
		STA	<WORK0
		LDA	>ITEMR03	;NO. SET
		AND	#000FFH
		STA	<WORK2
		LDA	#RITEM03	;TFR MOTO 
		STA	<WORK4
		JSR	SETITEM		;SET ITEM
;
;					;BOMB SET
		LDA	#WITEM04	;TFR SAKI
		STA	<WORK0
		LDA	>ITEMR04	;NO. SET
		AND	#000FFH
		BEQ	WTWK140
		LDA	#00001H
WTWK140		EQU	$
		STA	<WORK2
		LDA	#RITEM04	;TFR MOTO 
		STA	<WORK4
		JSR	SETITEM		;SET ITEM
;
;					;KONA &KINOKO SET
		LDA	#WITEM05	;TFR SAKI
		STA	<WORK0
		LDA	>ITEMR05	;NO. SET
		AND	#000FFH
		STA	<WORK2
		LDA	#RITEM05	;TFR MOTO 
		STA	<WORK4
		JSR	SETITEM		;SET ITEM
;
;					;FIRE ROT SET
		LDA	#WITEM06	;TFR SAKI
		STA	<WORK0
		LDA	>ITEMR06	;NO. SET
		AND	#000FFH
		STA	<WORK2
		LDA	#RITEM06	;TFR MOTO 
		STA	<WORK4
		JSR	SETITEM		;SET ITEM
;
;					;ICE ROT SET
		LDA	#WITEM07	;TFR SAKI
		STA	<WORK0
		LDA	>ITEMR07	;NO. SET
		AND	#000FFH
		STA	<WORK2
		LDA	#RITEM07	;TFR MOTO 
		STA	<WORK4
		JSR	SETITEM		;SET ITEM
;
;					;S. BOMB SET
		LDA	#WITEM08	;TFR SAKI
		STA	<WORK0
		LDA	>ITEMR08	;NO. SET
		AND	#000FFH
		STA	<WORK2
		LDA	#RITEM08	;TFR MOTO 
		STA	<WORK4
		JSR	SETITEM		;SET ITEM
;
;					;S. THNDER SET
		LDA	#WITEM09	;TFR SAKI
		STA	<WORK0
		LDA	>ITEMR09	;NO. SET
		AND	#000FFH
		STA	<WORK2
		LDA	#RITEM09	;TFR MOTO 
		STA	<WORK4
		JSR	SETITEM		;SET ITEM
;
;					;S. GISIN SET
		LDA	#WITEM10	;TFR SAKI
		STA	<WORK0
		LDA	>ITEMR10	;NO. SET
		AND	#000FFH
		STA	<WORK2
		LDA	#RITEM10	;TFR MOTO 
		STA	<WORK4
		JSR	SETITEM		;SET ITEM
;
;					;KANTERA SET
		LDA	#WITEM11	;TFR SAKI
		STA	<WORK0
		LDA	>ITEMR11	;NO. SET
		AND	#000FFH
		STA	<WORK2
		LDA	#RITEM11	;TFR MOTO 
		STA	<WORK4
		JSR	SETITEM		;SET ITEM
;
;					;HANMER SET
		LDA	#WITEM12	;TFR SAKI
		STA	<WORK0
		LDA	>ITEMR12	;NO. SET
		AND	#000FFH
		STA	<WORK2
		LDA	#RITEM12	;TFR MOTO 
		STA	<WORK4
		JSR	SETITEM		;SET ITEM
;
;					;SKOPU SET
		LDA	#WITEM13	;TFR SAKI
		STA	<WORK0
		LDA	>ITEMR13	;NO. SET
		AND	#000FFH
		STA	<WORK2
		LDA	#RITEM13	;TFR MOTO 
		STA	<WORK4
		JSR	SETITEM		;SET ITEM
;
;					;OKARINA SET
		LDA	#WITEM14	;TFR SAKI
		STA	<WORK0
		LDA	>ITEMR14	;NO. SET
		AND	#000FFH
		STA	<WORK2
		LDA	#RITEM14	;TFR MOTO 
		STA	<WORK4
		JSR	SETITEM		;SET ITEM
;
;					;SOROMON SET
		LDA	#WITEM15	;TFR SAKI
		STA	<WORK0
		LDA	>ITEMR15	;NO. SET
		AND	#000FFH
		STA	<WORK2
		LDA	#RITEM15	;TFR MOTO 
		STA	<WORK4
		JSR	SETITEM		;SET ITEM
;
;					;BIN select SET
		LDA	#WITEM16	;TFR SAKI
		STA	<WORK0
		LDA	>ITEMR16	;NO. SET
		AND	#000FFH
		TAX
		LDA	>BINCT0-1,X
		AND	#000FFH
		STA	<WORK2
		LDA	#RITEM16	;TFR MOTO 
		STA	<WORK4
		JSR	SETITEM		;SET ITEM
;
;					; SET
		LDA	#WITEM17	;TFR SAKI
		STA	<WORK0
		LDA	>ITEMR17	;NO. SET
		AND	#000FFH
		STA	<WORK2
		LDA	#RITEM17	;TFR MOTO 
		STA	<WORK4
		JSR	SETITEM		;SET ITEM
;
;					; SET
		LDA	#WITEM18	;TFR SAKI
		STA	<WORK0
		LDA	>ITEMR18	;NO. SET
		AND	#000FFH
		STA	<WORK2
		LDA	#RITEM18	;TFR MOTO 
		STA	<WORK4
		JSR	SETITEM		;SET ITEM
;
;					;KAKURE MINO SET
		LDA	#WITEM19	;TFR SAKI
		STA	<WORK0
		LDA	>ITEMR19	;NO. SET
		AND	#000FFH
		STA	<WORK2
		LDA	#RITEM19	;TFR MOTO 
		STA	<WORK4
		JSR	SETITEM		;SET ITEM
;
;					;W--P SET
		LDA	#WITEM20	;TFR SAKI
		STA	<WORK0
		LDA	>ITEMR20	;NO. SET
		AND	#000FFH
		STA	<WORK2
		LDA	#RITEM20	;TFR MOTO 
		STA	<WORK4
		JSR	SETITEM		;SET ITEM
;
		MEM8
		IDX8
		SEP	#00110000B
		RTS
;----------------------------------------
WTWAKU2		EQU	$		;waku 2 o kaku
		MEM16
		IDX16
		REP	#00110000B
;
		LDA	#03CFBH		;KADO
		AND	<WORK		; iro
		STA	!IWAKU2		;[
		ORA	#08000H
		STA	!IWAKU2+140H	;[
		ORA	#04000H
		STA	!IWAKU2+152H	;]
		EOR	#08000H
		STA	!IWAKU2+012H	;]
;
		LDX	#00000H		;|	TATE
		LDY	#00003H		;|
WTWK210		EQU	$
		LDA	#03CFCH
		AND	<WORK		; iro
		STA	!IWAKU2+040H,X
		ORA	#04000H
		STA	!IWAKU2+052H,X
		TXA
		CLC
		ADC	#00040H
		TAX
		DEY
		BPL	WTWK210
;
		LDX	#00000H		;---	YOKO
		LDY	#00007H		;
WTWK220		EQU	$
		LDA	#03CF9H
		AND	<WORK		; iro
		STA	!IWAKU2+002H,X
		ORA	#08000H
		STA	!IWAKU2+142H,X
		INX
		INX
		DEY
		BPL	WTWK220
;
		LDX	#00000H		;---	KURO
		LDY	#00007H		;
		LDA	#KURODT
WTWK230		EQU	$
		STA	!IWAKU2+042H,X
		STA	!IWAKU2+082H,X
		STA	!IWAKU2+0C2H,X
		STA	!IWAKU2+102H,X
		INX
		INX
		DEY
		BPL	WTWK230
;
		MEM8
		IDX8
		SEP	#00110000B
		RTS
;
;
WTWAKU3		EQU	$		;waku 3 o kaku
		MEM16
		IDX16
		REP	#00110000B
;
		LDX	#00000H		;---	KURO
		LDY	#00011H		;
		LDA	#KURODT
WTWK330		EQU	$
		STA	!IWAKU3+042H,X
		STA	!IWAKU3+082H,X
		STA	!IWAKU3+0C2H,X
		STA	!IWAKU3+102H,X
		STA	!IWAKU3+142H,X
		STA	!IWAKU3+182H,X
		STA	!IWAKU3+1C2H,X
		INX
		INX
		DEY
		BPL	WTWK330
;
		LDA	>ITMTBL1			;MOJI WRITE
		AND	#0FF00H
		STA	<WORK+2
		LDA	#0003
		STA	<WORK+4
		LDY	#0000
		TYX
WTWK350		EQU	$
		LDA	#0004
		STA	<WORK+6
WTWK360		EQU	$
		ASL	<WORK+2
		BCC	WTWK370
		LDA	YDATA,X
;		AND	#0E3FFH
		STA	!IWAKU3+132-40H,Y
		LDA	YDATA+2,X
;		AND	#0E3FFH
		STA	!IWAKU3+134-40H,Y
		LDA	YDATA+4,X
;		AND	#0E3FFH
		STA	!IWAKU3+136-40H,Y
		LDA	YDATA+6,X
;		AND	#0E3FFH
		STA	!IWAKU3+138-40H,Y
		LDA	YDATA+8,X
;		AND	#0E3FFH
		STA	!IWAKU3+140-40H,Y
		LDA	YDATA+10,X
;		AND	#0E3FFH
		STA	!IWAKU3+132,Y
		LDA	YDATA+12,X
;		AND	#0E3FFH
		STA	!IWAKU3+134,Y
		LDA	YDATA+14,X
;		AND	#0E3FFH
		STA	!IWAKU3+136,Y
		LDA	YDATA+16,X
;		AND	#0E3FFH
		STA	!IWAKU3+138,Y
		LDA	YDATA+18,X
;		AND	#0E3FFH
		STA	!IWAKU3+140,Y
WTWK370		EQU	$
		TXA
		CLC
		ADC	#0014H
		TAX
		TYA
		CLC
		ADC	#00010
		TAY
		DEC	<WORK+6
		BNE	WTWK360
		TYA
		CLC
		ADC	#0005AH
		TAY
		DEC	<WORK+4
		BNE	WTWK350		;end?
;					;y
		LDA	#024FBH		;KADO
		AND	<WORK		; iro
		STA	!IWAKU3		;[
		ORA	#08000H
		STA	!IWAKU3+200H	;[
		ORA	#04000H
		STA	!IWAKU3+226H	;]
		EOR	#08000H
		STA	!IWAKU3+026H	;]
;
		LDX	#00000H		;|	TATE
		LDY	#00006H		;|
WTWK310		EQU	$
		LDA	#024FCH
		AND	<WORK		; iro
		STA	!IWAKU3+040H,X
		ORA	#04000H
		STA	!IWAKU3+066H,X
		TXA
		CLC
		ADC	#00040H
		TAX
		DEY
		BPL	WTWK310
;
		LDX	#00000H		;---	YOKO
		LDY	#00011H		;
WTWK320		EQU	$
		LDA	#024F9H
		AND	<WORK		; iro
		STA	!IWAKU3+002H,X
		ORA	#08000H
		STA	!IWAKU3+202H,X
		INX
		INX
		DEY
		BPL	WTWK320
;
		LDA	#0A4F0H		;A write
		STA	!IWAKU3+042H
		LDA	#024F2H
		STA	!IWAKU3+082H
;
		LDA	#02482H		;DO write
		STA	!IWAKU3+004H
		LDA	#02483H
		STA	!IWAKU3+006H
;
		MEM8
		IDX8
		SEP	#00110000B
		RTS
;
;
WTWAKU4I	EQU	$		; waku 4 o kaku
		MEM16
		IDX16
		REP	#00110000B
;
;					;GROBU SET
		LDA	#WITEM21	;TFR SAKI
		STA	<WORK0
		LDA	>ITEMR21	;NO. SET
		AND	#000FFH
		STA	<WORK2
		LDA	#RITEM21	;TFR MOTO 
		STA	<WORK4
		JSR	SETITEM		;SET ITEM
;
;					;GISYO SET
		LDA	#WITEM22	;TFR SAKI
		STA	<WORK0
		LDA	>ITEMR22	;NO. SET
		AND	#000FFH
		STA	<WORK2
		LDA	#RITEM22	;TFR MOTO 
		STA	<WORK4
		JSR	SETITEM		;SET ITEM
;
;					;HIRE SET
		LDA	#WITEM23	;TFR SAKI
		STA	<WORK0
		LDA	>ITEMR23	;NO. SET
		AND	#000FFH
		STA	<WORK2
		LDA	#RITEM23	;TFR MOTO 
		STA	<WORK4
		JSR	SETITEM		;SET ITEM
;
		LDA	>ITEMR21		;GROBE CHK.
		AND	#000FFH
		BEQ	WTWK4I50
		CMP	#00001H
		BNE	WTWK4I55
		LDA	#00000H
		JSR	WTWK4IMPRI
		BRA	WTWK4I50
WTWK4I55	EQU	$
		LDA	#00001H
		JSR	WTWK4IMPRI
WTWK4I50	EQU	$
;		LDA	>ITEMR22		;HIRE CHK.
;		AND	#000FFH
;		BEQ	WTWK4I60
;		LDA	#00002H
;		JSR	WTWK4IMPRI
WTWK4I60	EQU	$
;		LDA	>ITEMR23		;GISYO CHK.
;		BEQ	WTWK4I70
;		LDA	#00003H
;		JSR	WTWK4IMPRI
;		LDA	#00006H
;		JSR	WTWK4IMPRI
;WTWK4I70	EQU	$
;
		MEM8
		IDX8
		SEP	#00110000B
		RTS
;
WTWK4IMPRI	EQU	$
		MEM16
		IDX16
		STA	<WORK0		;PARA. SAVE
		ASL	A
		ASL	A
		ADC	<WORK0
		ASL	A
		ASL	A
		TAX
;
		LDA	YGROB,X
;		AND	#0E3FFH
;		ORA	#00800H
		STA	!IWAKU3+142-40H
		LDA	YGROB+2,X
;		AND	#0E3FFH
;		ORA	#00800H
		STA	!IWAKU3+144-40H
		LDA	YGROB+4,X
;		AND	#0E3FFH
;		ORA	#00800H
		STA	!IWAKU3+146-40H
		LDA	YGROB+6,X
;		AND	#0E3FFH
;		ORA	#00800H
		STA	!IWAKU3+148-40H
		LDA	YGROB+8,X
;		AND	#0E3FFH
;		ORA	#00800H
		STA	!IWAKU3+150-40H
		LDA	YGROB+10,X
;		AND	#0E3FFH
;		ORA	#00800H
		STA	!IWAKU3+142
		LDA	YGROB+12,X
;		AND	#0E3FFH
;		ORA	#00800H
		STA	!IWAKU3+144
		LDA	YGROB+14,X
;		AND	#0E3FFH
;		ORA	#00800H
		STA	!IWAKU3+146
		LDA	YGROB+16,X
;		AND	#0E3FFH
;		ORA	#00800H
		STA	!IWAKU3+148
		LDA	YGROB+18,X
;		AND	#0E3FFH
;		ORA	#00800H
		STA	!IWAKU3+150
;
		RTS
;
;
WTWK5DT		EQU	$
		WORD	028FBH,028F9H,028F9H,028F9H
		WORD	028F9H,028F9H,028F9H,028F9H
		WORD	028F9H,068FBH
		WORD	028FCH,KURODT,KURODT,02444H
		WORD	02445H,02C46H,02C47H,024ADH
		WORD	024AEH,068FCH
		WORD	028FCH,0246EH,0246FH,03C48H
		WORD	02449H,0244AH,0244BH,KURODT
		WORD	KURODT,068FCH
		WORD	028FCH,KURODT,KURODT,02521H
		WORD	02522H,02523H,02524H,02482H
		WORD	02483H,068FCH
		WORD	028FCH,02484H,02485H,02453H
		WORD	02925H,02526H,0E444H,KURODT
		WORD	KURODT,068FCH
		WORD	0A8FBH,0A8F9H,0A8F9H,0A8F9H
		WORD	0A8F9H,0A8F9H,0A8F9H,0A8F9H
		WORD	0A8F9H,0E8FBH
WTWAKU5		EQU	$		; waku 5 o kaku
		MEM16
		IDX16
		REP	#00110000B
;
		LDX	#00000H
WTWK510		EQU	$
		LDA	WTWK5DT,X
		STA	!IWAKU5,X
		LDA	WTWK5DT+014H,X
		STA	!IWAKU5+040H,X
		LDA	WTWK5DT+028H,X
		STA	!IWAKU5+080H,X
		LDA	WTWK5DT+03CH,X
		STA	!IWAKU5+0C0H,X
		LDA	WTWK5DT+050H,X
		STA	!IWAKU5+100H,X
		LDA	WTWK5DT+064H,X
		STA	!IWAKU5+140H,X
		INX
		INX
		CPX	#00014H
		BCC	WTWK510
		MEM8
		IDX8
		SEP	#00110000B
		RTS
;
;
WAKU6DT		EQU	$
		WORD	0288AH		;COIN NO E

WTWAKU6		EQU	$		; waku 4 o kaku
		MEM16
		IDX16
		REP	#00110000B
;
		LDA	#028FBH		;KADO
		AND	<WORK		; iro
		STA	!IWAKU6		;[
		ORA	#08000H
		STA	!IWAKU6+080H	;[
		ORA	#04000H
		STA	!IWAKU6+092H	;]
		EOR	#08000H
		STA	!IWAKU6+012H	;]
;
		LDX	#00000H		;|	TATE
		LDY	#00000H		;|
WTWK610		EQU	$
		LDA	#028FCH
		AND	<WORK		; iro
		STA	!IWAKU6+040H,X
		ORA	#04000H
		STA	!IWAKU6+052H,X
		TXA
		CLC
		ADC	#00040H
		TAX
		DEY
		BPL	WTWK610
;
		LDX	#00000H		;---	YOKO
		LDY	#00007H		;
WTWK620		EQU	$
		LDA	#028F9H
		AND	<WORK		; iro
		STA	!IWAKU6+002H,X
		ORA	#08000H
		STA	!IWAKU6+082H,X
		INX
		INX
		DEY
		BPL	WTWK620
;
		LDX	#00000H		;---	KURO
		LDY	#00007H		;
		LDA	#KURODT
WTWK630		EQU	$
		STA	!IWAKU6+042H,X
		INX
		INX
		DEY
		BPL	WTWK630
;
;		MEM16
;		IDX16
;		REP	#00110000B
;
		LDA	>ITMTBL3		;waku 4 (item) write
		XBA
		STA	<WORK+2
		LDY	#0000
WTWK6I10	EQU	$
		LDA	#0008
		STA	<WORK+8
WTWK6I20	EQU	$
		ASL	<WORK+2
		BCC	WTWK6I30
		LDA	WAKU6DT
;		AND	#0E3FFH
		STA	!IWAKU6+042H,Y
;
WTWK6I30	EQU	$
		INY
		INY
		DEC	<WORK+8
		BNE	WTWK6I20	;
;
		MEM8
		IDX8
		SEP	#00110000B
		RTS
;
;
WTWAKU12I	EQU	$		;waku 1 2 no naka o erabu
		MEM16
		IDX16
		REP	#00110000B
;
		LDA	GETITM0
		AND	#000FFH
		DEC	A
		ASL	A
		TAX
		LDY	STGITWM,X
WTWAKU12I6	EQU	$
		LDA	WBGBUF-WBGBUF,Y
		STA	IWAKU2+48H
		LDA	WBGBUF-WBGBUF+002H,Y
		STA	IWAKU2+4AH
		LDA	WBGBUF-WBGBUF+040H,Y
		STA	IWAKU2+88H
		LDA	WBGBUF-WBGBUF+042H,Y
		STA	IWAKU2+8AH
;
		LDA	IFRCNT1
		AND	#010H
		BEQ	WTWAKU12I8
		LDA	#03C61H		;consol set
		STA	WBGBUF-WBGBUF-40H,Y
		ORA	#04000H
		STA	WBGBUF-WBGBUF-3EH,Y
		LDA	#03C70H
		STA	WBGBUF-WBGBUF-02H,Y
		ORA	#04000H
		STA	WBGBUF-WBGBUF+04H,Y
		LDA	#0BC70H
		STA	WBGBUF-WBGBUF+3EH,Y
		ORA	#04000H
		STA	WBGBUF-WBGBUF+44H,Y
		LDA	#0BC61H
		STA	WBGBUF-WBGBUF+80H,Y
		ORA	#04000H
		STA	WBGBUF-WBGBUF+82H,Y
		LDA	#03C60H
		STA	WBGBUF-WBGBUF-42H,Y
		ORA	#04000H
		STA	WBGBUF-WBGBUF-3CH,Y
		ORA	#08000H
		STA	WBGBUF-WBGBUF+84H,Y
		EOR	#04000H
		STA	WBGBUF-WBGBUF+7EH,Y
;
WTWAKU12I8	EQU	$
		LDA	GETITM0		;bin 1   moji
		AND	#000FFH
		CMP	#00016
		BNE	WTWAKU12I9
		LDA	>ITEMR16
		AND	#000FFH
		BEQ	WTWAKU12I9
		TAX
		LDA	>BINCT0-1,X
		AND	#000FFH
		DEC	A
;		BEQ	WTWAKU12I9
;		DEC	A		;pri. ok
		ASL	A
		ASL	A
		ASL	A
		ASL	A
		ASL	A
		TAX
		LDY	#00000H
WTWAKU12IA	EQU	$
		LDA	BINMOJI,X
		STA	!IWAKU2+0C2H,Y
		LDA	BINMOJI+10H,X
		STA	!IWAKU2+102H,Y
		INX
		INX
		INY
		INY
		CPY	#00010H
		BCC	WTWAKU12IA
		JMP	WTWAKU12IF
WTWAKU12I9	EQU	$
;;;;;;;;		LDA	GETITM0		;bin 2   moji
;;;;;;;;		AND	#000FFH
;;;;;;;;		CMP	#00017
;;;;;;;;		BNE	WTWAKU12IB
;;;;;;;;		LDA	>BINCT1
;;;;;;;;		AND	#000FFH
;;;;;;;;		DEC	A
;;;;;;;;		BEQ	WTWAKU12IB
;;;;;;;;		DEC	A		;pri. ok
;;;;;;;;		ASL	A
;;;;;;;;		ASL	A
;;;;;;;;		ASL	A
;;;;;;;;		ASL	A
;;;;;;;;		ASL	A
;;;;;;;;		TAX
;;;;;;;;		LDY	#00000H
;;;;;;;;WTWAKU12IC	EQU	$
;;;;;;;;		LDA	BINMOJI,X
;;;;;;;;		STA	!IWAKU2+0C2H,Y
;;;;;;;;		LDA	BINMOJI+10H,X
;;;;;;;;		STA	!IWAKU2+102H,Y
;;;;;;;;		INX
;;;;;;;;		INX
;;;;;;;;		INY
;;;;;;;;		INY
;;;;;;;;		CPY	#00010H
;;;;;;;;		BCC	WTWAKU12IC
;;;;;;;;		JMP	WTWAKU12IF
;;;;;;;;WTWAKU12IB	EQU	$
;;;;;;;;		LDA	GETITM0		;bin 3   moji
;;;;;;;;		AND	#000FFH
;;;;;;;;		CMP	#00018
;;;;;;;;		BNE	WTWAKU12I10
;;;;;;;;		LDA	>BINCT2
;;;;;;;;		AND	#000FFH
;;;;;;;;		DEC	A
;;;;;;;;		BEQ	WTWAKU12I10
;;;;;;;;		DEC	A		;pri. ok
;;;;;;;;		ASL	A
;;;;;;;;		ASL	A
;;;;;;;;		ASL	A
;;;;;;;;		ASL	A
;;;;;;;;		ASL	A
;;;;;;;;		TAX
;;;;;;;;		LDY	#00000H
;;;;;;;;WTWAKU12IE	EQU	$
;;;;;;;;		LDA	BINMOJI,X
;;;;;;;;		STA	!IWAKU2+0C2H,Y
;;;;;;;;		LDA	BINMOJI+10H,X
;;;;;;;;		STA	!IWAKU2+102H,Y
;;;;;;;;		INX
;;;;;;;;		INX
;;;;;;;;		INY
;;;;;;;;		INY
;;;;;;;;		CPY	#00010H
;;;;;;;;		BCC	WTWAKU12IE
;;;;;;;;		JMP	WTWAKU12IF
WTWAKU12I10	EQU	$
		LDA	GETITM0		;KONA   moji
		AND	#000FFH
		CMP	#00005
		BNE	WTWAKU12I12
		LDA	>ITEMR05
		AND	#000FFH
		DEC	A
		BEQ	WTWAKU12I12
		DEC	A		;pri. ok
		ASL	A
		ASL	A
		ASL	A
		ASL	A
		ASL	A
		TAX
		LDY	#00000H
WTWAKU12I11	EQU	$
		LDA	KONAMJI,X
		STA	!IWAKU2+0C2H,Y
		LDA	KONAMJI+10H,X
		STA	!IWAKU2+102H,Y
		INX
		INX
		INY
		INY
		CPY	#00010H
		BCC	WTWAKU12I11
		BRA	WTWAKU12IF
WTWAKU12I12	EQU	$
		LDA	GETITM0		;TEGAMI   moji
		AND	#000FFH
		CMP	#00020
		BNE	WTWAKU12ID
		LDA	>ITEMR20
		AND	#000FFH
		DEC	A
		BEQ	WTWAKU12ID
		DEC	A		;pri. ok
		ASL	A
		ASL	A
		ASL	A
		ASL	A
		ASL	A
		TAX
		LDY	#00000H
WTWAKU12I13	EQU	$
		LDA	TGMIMJI,X
		STA	!IWAKU2+0C2H,Y
		LDA	TGMIMJI+10H,X
		STA	!IWAKU2+102H,Y
		INX
		INX
		INY
		INY
		CPY	#00010H
		BCC	WTWAKU12I13
		BRA	WTWAKU12IF
WTWAKU12ID	EQU	$
		TXA
		ASL	A
		ASL	A
		ASL	A
		ASL	A
		TAX
		LDY	#00000H
WTWAKU12I5	EQU	$
		LDA	BDATAM,X
		STA	!IWAKU2+0C2H,Y
		LDA	BDATAM+10H,X
		STA	!IWAKU2+102H,Y
		INX
		INX
		INY
		INY
		CPY	#00010H
		BCC	WTWAKU12I5
WTWAKU12IF	EQU	$
;
WTWAKU12I3	EQU	$
		MEM8
		IDX8
		SEP	#00110000B
		RTS
;
;
;
WTWAKU7I	EQU	$
		MEM16
		IDX16
		REP	#00110000B
;
;					;TAMA SET
		LDA	#WITEM24	;TFR SAKI
		STA	<WORK0
		LDA	>ITMTBL4	;NO. SET
		AND	#000FFH
		STA	<WORK2
		LDA	#RITEM24	;TFR MOTO 
		STA	<WORK4
		JSR	SETITEM		;SET ITEM
;
		MEM8
		IDX8
		SEP	#00110000B
;
		RTS
;
;
WTWAKU8I	EQU	$
		MEM16
		IDX16
		REP	#00110000B
;
;					;KAGAMI SET
		LDA	#WITEM25	;TFR SAKI
		STA	<WORK0
		LDA	>ITMTBL5	;NO. SET
		AND	#000FFH
		STA	<WORK2
		LDA	#RITEM25	;TFR MOTO 
		STA	<WORK4
		JSR	SETITEM		;SET ITEM
;
		MEM8
		IDX8
		SEP	#00110000B
;
		RTS
;
;
WAKU9MDT0	EQU	$
		WORD	02479H,0247AH,0247BH,0247CH
		WORD	0248CH,KURODT,KURODT,KURODT
WAKU9MDT1	EQU	$
		WORD	02469H,0246AH,0246BH,0246CH
		WORD	0246DH,0246EH,0246FH,KURODT
WTWAKU9		EQU	$		; waku 4 o kaku
		MEM16
		IDX16
		REP	#00110000B
;
		LDA	#028FBH		;KADO
		AND	<WORK		; iro
		STA	!IWAKU9		;[
		ORA	#08000H
		STA	!IWAKU9+200H	;[
		ORA	#04000H
		STA	!IWAKU9+212H	;]
		EOR	#08000H
		STA	!IWAKU9+012H	;]
;
		LDX	#00000H		;|	TATE
		LDY	#00006H		;|
WTWK910		EQU	$
		LDA	#028FCH
		AND	<WORK		; iro
		STA	!IWAKU9+040H,X
		ORA	#04000H
		STA	!IWAKU9+052H,X
		TXA
		CLC
		ADC	#00040H
		TAX
		DEY
		BPL	WTWK910
;
		LDX	#00000H		;---	YOKO
		LDY	#00007H		;
WTWK920		EQU	$
		LDA	#028F9H
		AND	<WORK		; iro
		STA	!IWAKU9+002H,X
		ORA	#08000H
		STA	!IWAKU9+202H,X
		INX
		INX
		DEY
		BPL	WTWK920
;
		LDX	#00000H		;---	KURO
		LDY	#00007H		;
		LDA	#KURODT
WTWK930		EQU	$
		STA	!IWAKU9+042H,X
		STA	!IWAKU9+082H,X
		STA	!IWAKU9+0C2H,X
		STA	!IWAKU9+102H,X
		STA	!IWAKU9+142H,X
		STA	!IWAKU9+182H,X
		STA	!IWAKU9+1C2H,X
		INX
		INX
		DEY
		BPL	WTWK930
;
		LDX	#00000H		;---	YOKO(- - -)
		LDY	#00007H		;
		LDA	#028D7H
		AND	<WORK		; iro
WTWK940		EQU	$
		STA	!IWAKU9+102H,X
		INX
		INX
		DEY
		BPL	WTWK940
;
		LDX	#00000H		;---	YOKO( MOJI )
		LDY	#00007H		;
WTWK950		EQU	$
		LDA	WAKU9MDT0,X
		AND	<WORK		; iro
		STA	!IWAKU9+042H,X
		LDA	WAKU9MDT1,X
		AND	<WORK		; iro
		STA	!IWAKU9+142H,X
		INX
		INX
		DEY
		BPL	WTWK950
;
		LDA	<GMMODE
		AND	#000FFH
		BNE	WTWAKU9I
;
		LDX	#00000H		;---	KURO
		LDY	#00009H		;
		LDA	#0207FH
WTWK960		EQU	$
		STA	!IWAKU9+100H,X
		STA	!IWAKU9+140H,X
		STA	!IWAKU9+180H,X
		STA	!IWAKU9+1C0H,X
		STA	!IWAKU9+200H,X
		INX
		INX
		DEY
		BPL	WTWK960
;
		LDA	#028FBH		;KADO
		AND	<WORK		; iro
		ORA	#08000H
		STA	!IWAKU9+100H	;[
		ORA	#04000H
		STA	!IWAKU9+112H	;]
;
		LDX	#00000H		;---	YOKO
		LDY	#00007H		;
WTWK970		EQU	$
		LDA	#028F9H
		AND	<WORK		; iro
		STA	!IWAKU9+002H,X
		ORA	#08000H
		STA	!IWAKU9+102H,X
		INX
		INX
		DEY
		BPL	WTWK970
;
;
WTWAKU9I	EQU	$
		MEM16
		IDX16
		REP	#00110000B
;
;					;KEN SET
		LDA	#WITEM26	;TFR SAKI
		STA	<WORK0
		LDA	>ITMTBL6	;NO. SET
		AND	#000FFH
		STA	<WORK2
		LDA	#RITEM26	;TFR MOTO 
		STA	<WORK4
		JSR	SETITEM		;SET ITEM
;
		MEM8
		IDX8
		SEP	#00110000B
;
		RTS
;
;
WTWAKUAI	EQU	$
		MEM16
		IDX16
		REP	#00110000B
;
;					;TATE SET
		LDA	#WITEM27	;TFR SAKI
		STA	<WORK0
		LDA	>ITMTBL7	;NO. SET
		AND	#000FFH
		STA	<WORK2
		LDA	#RITEM27	;TFR MOTO 
		STA	<WORK4
		JSR	SETITEM		;SET ITEM
;
		MEM8
		IDX8
		SEP	#00110000B
;
		RTS
;
;
WTWAKUBI	EQU	$
		MEM16
		IDX16
		REP	#00110000B
;
;					;HUKU SET
		LDA	#WITEM28	;TFR SAKI
		STA	<WORK0
		LDA	>ITMTBL8	;NO. SET
		AND	#000FFH
		STA	<WORK2
		LDA	#RITEM28	;TFR MOTO 
		STA	<WORK4
		JSR	SETITEM		;SET ITEM
;
		MEM8
		IDX8
		SEP	#00110000B
;
		RTS
;
;
WTWAKUCI	EQU	$		; waku 4 o kaku
		MEM16
		IDX16
		REP	#00110000B
;
;					;KEY SET
		LDA	DJNNO
		CMP	#0FFH
		BEQ	WTWKCI30
		LSR	A
		TAX
		LDA	>KEYCNT
WTWKCI20	EQU	$
		ASL	A
		DEX
		BPL	WTWKCI20
;
		BCC	WTWKCI30	;? DANJON KEY GET
;					;Y
		LDA	#WITEM29+0CH	;TFR SAKI
		STA	<WORK0
		LDA	#00001H		;NO. SET
		STA	<WORK2
		LDA	#RITEM39	;TFR MOTO 
		STA	<WORK4
		JSR	SETITEM		;SET ITEM
;
WTWKCI30	EQU	$
		LDA	DJNNO
		CMP	#0FFH
		BEQ	WTWKCI50
		LSR	A
		TAX
		LDA	>MAPCNT
WTWKCI40	EQU	$
		ASL	A
		DEX
		BPL	WTWKCI40
;
		BCC	WTWKCI50	;? MAP GET
;					;Y
		LDA	#WITEM29	;TFR SAKI
		STA	<WORK0
		LDA	#00001H		;NO. SET
		STA	<WORK2
		LDA	#RITEM41	;TFR MOTO 
		STA	<WORK4
		JSR	SETITEM		;SET ITEM
;
WTWKCI50	EQU	$
WTWKCI10	EQU	$
		MEM8
		IDX8
		SEP	#00110000B
;
		RTS
;
;
WTWAKUDI	EQU	$
		MEM16
		IDX16
		REP	#00110000B
;
;					;GISYAKU SET
;
		LDA	DJNNO
		CMP	#0FFH
		BEQ	WTWAKUDI20
		LSR	A
		TAX
		LDA	>ITMTBLA
WTWAKUDI10	EQU	$
		ASL	A
		DEX
		BPL	WTWAKUDI10
;
		BCC	WTWAKUDI20	;? GISYAKU GET
;					;Y
		LDA	#WITEM37	;TFR SAKI
		STA	<WORK0
		LDA	#00001H		;NO. SET
		STA	<WORK2
		LDA	#RITEM37	;TFR MOTO 
		STA	<WORK4
		JSR	SETITEM		;SET ITEM
;
WTWAKUDI20	EQU	$
		MEM8
		IDX8
		SEP	#00110000B
;
		RTS
;
;
WTBINST		EQU	$		; bin select o kaku
		MEM16
		IDX16
		REP	#00110000B
;
		LDA	#028FBH		;KADO
		AND	<WORK		; iro
		STA	!IWAKU5		;[
		ORA	#08000H
		STA	!IWAKU5+480H	;[
		ORA	#04000H
		STA	!IWAKU5+492H	;]
		EOR	#08000H
		STA	!IWAKU5+012H	;]
;
		LDX	#00000H		;|	TATE
		LDY	#00010H		;|
WTBIN10		EQU	$
		LDA	#028FCH
		AND	<WORK		; iro
		STA	!IWAKU5+040H,X
		ORA	#04000H
		STA	!IWAKU5+052H,X
		TXA
		CLC
		ADC	#00040H
		TAX
		DEY
		BPL	WTBIN10
;
		LDX	#00000H		;---	YOKO
		LDY	#00007H		;
WTBIN20		EQU	$
		LDA	#028F9H
		AND	<WORK		; iro
		STA	!IWAKU5+002H,X
		ORA	#08000H
		STA	!IWAKU5+482H,X
		INX
		INX
		DEY
		BPL	WTBIN20
;
		LDX	#00000H		;---	KURO
		LDY	#00007H		;
		LDA	#KURODT
WTBIN30		EQU	$
		STA	IWAKU5+042H,X
		STA	IWAKU5+082H,X
		STA	IWAKU5+0C2H,X
		STA	IWAKU5+102H,X
		STA	IWAKU5+142H,X
		STA	IWAKU5+182H,X
		STA	IWAKU5+1C2H,X
		STA	IWAKU5+202H,X
		STA	IWAKU5+242H,X
		STA	IWAKU5+282H,X
		STA	IWAKU5+2C2H,X
		STA	IWAKU5+302H,X
		STA	IWAKU5+342H,X
		STA	IWAKU5+382H,X
		STA	IWAKU5+3C2H,X
		STA	IWAKU5+402H,X
		STA	IWAKU5+442H,X
 		INX
		INX
		DEY
		BPL	WTBIN30
;
;
WTBINSTI	EQU	$
		MEM16
		IDX16
		REP	#00110000B
;
                LDA     #IWAKU5+088H    ;TFR SAKI
                STA     <WORK0
                LDA     >BINCT0         ;NO. SET
                AND     #000FFH
                STA     <WORK2
                LDA     #RITEM29        ;TFR MOTO 
                STA     <WORK4
                JSR     SETITEM         ;SET ITEM
;
;                                       ;BIN2 SET
                LDA     #IWAKU5+188H    ;TFR SAKI
                STA     <WORK0
                LDA     >BINCT1         ;NO. SET
                AND     #000FFH
                STA     <WORK2
                LDA     #RITEM30        ;TFR MOTO 
                STA     <WORK4
                JSR     SETITEM         ;SET ITEM
;
;                                       ;BIN3 SET
                LDA     #IWAKU5+288H    ;TFR SAKI
                STA     <WORK0
                LDA     >BINCT2         ;NO. SET
                AND     #000FFH
                STA     <WORK2
                LDA     #RITEM31        ;TFR MOTO 
                STA     <WORK4
                JSR     SETITEM         ;SET ITEM
;
;
                LDA     #IWAKU5+388H    ;TFR SAKI
                STA     <WORK0
                LDA     >BINCT3         ;NO. SET
                AND     #000FFH
                STA     <WORK2
                LDA     #RITEM32        ;TFR MOTO 
                STA     <WORK4
                JSR     SETITEM         ;SET ITEM
;
;
                LDA     #WITEM16        ;TFR SAKI
                STA     <WORK0
                LDA     >ITEMR16        ;NO. SET
                AND     #000FFH
                TAX
                LDA     >BINCT0-1,X
                AND     #000FFH
                STA     <WORK2
                LDA     #RITEM16        ;TFR MOTO 
                STA     <WORK4
                JSR     SETITEM         ;SET ITEM
;
;
                LDA     GETITM0         ;WAKU2 WRITE
                AND     #000FFH
                DEC     A
                ASL     A
                TAX
                LDY     STGITWM,X
                LDA     WBGBUF-WBGBUF,Y
                STA     IWAKU2+48H
                LDA     WBGBUF-WBGBUF+002H,Y
                STA     IWAKU2+4AH
                LDA     WBGBUF-WBGBUF+040H,Y
                STA     IWAKU2+88H
                LDA     WBGBUF-WBGBUF+042H,Y
                STA     IWAKU2+8AH
;
;
		LDA	>ITEMR16
		DEC	A
		AND	#000FFH
		ASL	A
		TAY
		LDA	BNS40CNS,Y
		TAY
;
		LDA	IFRCNT1
		LDA	#03C61H		;consol set
		STA	IWAKU5-40H,Y
		ORA	#04000H
		STA	IWAKU5-3EH,Y
		LDA	#03C70H
		STA	IWAKU5-02H,Y
		ORA	#04000H
		STA	IWAKU5+04H,Y
		LDA	#0BC70H
		STA	IWAKU5+3EH,Y
		ORA	#04000H
		STA	IWAKU5+44H,Y
		LDA	#0BC61H
		STA	IWAKU5+80H,Y
		ORA	#04000H
		STA	IWAKU5+82H,Y
		LDA	#03C60H
		STA	IWAKU5-42H,Y
		ORA	#04000H
		STA	IWAKU5-3CH,Y
		ORA	#08000H
		STA	IWAKU5+84H,Y
		EOR	#04000H
		STA	IWAKU5+7EH,Y
;
		MEM8
		IDX8
		SEP	#00110000B
;
		LDA	#010H
		STA	IFRCNT1
;
		RTS
;
;
;
;
;
;
;
;
;
;
HENKAN		EQU	$		;16 sin o 10 sin ni suru
		MEM16			;A ni 16 sin o ireru
		IDX16			;3 keta you
		REP	#00110000B	;work+3,4,5 ni 100,10,1 no keta ga hairu
;
		STZ	WORK+3
;
		LDX	#0000
		LDY	#0002		;3 keta 
;
HENKAN1		EQU	$
		CMP	TBL16_10,Y
		BCC	HENKAN2
		SEC
		SBC	TBL16_10,Y
		INC	<WORK+3,X
		BRA	HENKAN1
;
HENKAN2		EQU	$
		INX
		DEY
		DEY
		BPL	HENKAN1
;
		STA	<WORK+5
;
		MEM8
		IDX8
		SEP	#00110000B
;
		LDY	#02		;dekita data no 0 o tumeru
HENKAN3		EQU	$
		LDA	<WORK+3
		BNE	HENKAN4
		LDA	<WORK+4
		STA	<WORK+3
		LDA	<WORK+5
		STA	<WORK+4
		LDA	#07FH
		STA	<WORK+5
HENKAN4		EQU	$
		DEY
		BNE	HENKAN3
		LDX	#02		;bg no data ni naosu
HENKAN5		EQU	$
		LDA	<WORK+3,X
		CMP	#07FH
		BEQ	HENKAN6
		ORA	#090H
HENKAN6		EQU	$
		STA	<WORK+3,X
		DEX
		BPL	HENKAN5
		RTS
;
;
KAIHUKU		EQU	$
		LDA	#001H
		STA	KAIFLG
		JSR	KAIHUKU0
		RTL
;
KAIHUKU0	EQU	$
		MEM8
		IDX8
		SEP	#00110000B
;
		LDA	>LFNWCT		;life no now >= max
		CMP	>LFITCT
		BCC	KAIHUKU1	;n
;					;y
		LDA	>LFITCT		;life o max ni suru( max < now no toki)
		STA	>LFNWCT
;
		STZ	KAIFLG
;
		SEC			;OK ---> SEC
		RTS
;
KAIHUKU1	EQU	$
		MEM8
		IDX8
		SEP	#00110000B
;
		LDA	#LOW  ILIFE	;doko ni kakuka o work+0,1,2 ni set
		STA	<WORK+0
		LDA	#HIGH ILIFE
		STA	<WORK+1
		LDA	#BANK ILIFE
		STA	<WORK+2
;
		DEC	KAICNT
		BNE	KAIHUKU3	;kaicnt = 0
		MEM16			;y (kakikae)
		IDX16
		REP	#00110000B
;
		LDA	>LFNWCT		;doko ni kakuka o X ni set
		AND	#000FFH
		LSR	A
		LSR	A
		LSR	A
		ASL	A
		TAY
		CMP	#0016
		BCC	KAIHUKU2
		AND	#000FH
		TAY
		LDA	<WORK
		CLC
		ADC	#0064
		STA	<WORK
;
KAIHUKU2	EQU	$
		MEM8
		IDX8
		SEP	#00110000B
;
		LDX	KAIIDX		;tugi no frem o set
		LDA	>KAIFRM,X
		STA	KAICNT
		TXA			;BG no data o set
		ASL	A
		TAX
		LDA	>KAIDAT,X
		STA	[<WORK],Y
		INY
		LDA	>KAIDAT+1,X
		STA	[<WORK],Y
		LDA	KAIIDX
		INC	A
		AND	#03H
		STA	KAIIDX
		BNE	KAIHUKU3
;
		LDA	>LFNWCT		;LIFE kaihuku
		CLC
		ADC	#0008
		STA	>LFNWCT
;
		LDA	>LFNWCT
		CMP	>LFITCT
		BCC	KAIHUKU4
		LDA	>LFITCT
		STA	>LFNWCT
;
KAIHUKU4	EQU	$
		MEM8
		IDX8
		SEP	#00110000B
;
		JSR	MTRON0
;
		STZ	KAIFLG
;
KAIHUKU3	EQU	$
		CLC			;NO --> CLC
		RTS
;
KAIMP		EQU	$
		MEM8
		IDX8
		SEP	#00110000B
;
		LDA	>MPNWCT		;MP no now >= max
		CMP	#080H
		BCS	KAIMP1		;n
;
		LDA	#080H
		STA	>UPMPCT
;
		MEM8
		IDX8
		SEP	#00110000B
;					NO ---> CLC
		RTL
;
KAIMP1		EQU	$
		MEM8
		IDX8
		SEP	#00110001B	;OK --> SEC
;
		RTL
;
;
;
;************************************************************************
;*		YAMAMOTO DATA.						*
;************************************************************************
BDATAM		EQU	$			;BITEM NAME
		WORD	KURODT,KURODT,KURODT,KURODT,KURODT,KURODT,KURODT,KURODT
		WORD	02424H,KURODT,0241FH,KURODT,KURODT,KURODT,KURODT,KURODT
;										
		WORD	0242FH,KURODT,KURODT,KURODT,KURODT,KURODT,KURODT,KURODT
		WORD	0256BH,0243FH,02571H,02576H,0257CH,KURODT,KURODT,KURODT
;										
		WORD	0256BH,0257EH,02557H,KURODT,KURODT,KURODT,KURODT,KURODT
		WORD	KURODT,0255BH,0257DH,0257EH,02563H,KURODT,KURODT,KURODT
;										
		WORD	0242FH,KURODT,0242FH,KURODT,KURODT,KURODT,KURODT,KURODT
		WORD	02419H,02407H,0240FH,0242DH,KURODT,KURODT,KURODT,KURODT
;										
		WORD	KURODT,KURODT,KURODT,KURODT,KURODT,KURODT,KURODT,KURODT
		WORD	02406H,02418H,02409H,KURODT,KURODT,KURODT,KURODT,KURODT
;										
		WORD	0256BH,024AAH,02551H,02573H,0243FH,KURODT,KURODT,KURODT
		WORD	KURODT,0257AH,0257EH,02563H,KURODT,KURODT,KURODT,KURODT
;										
		WORD	02550H,02551H,0255CH,KURODT,KURODT,KURODT,KURODT,KURODT
		WORD	KURODT,0257AH,0257EH,02563H,KURODT,KURODT,KURODT,KURODT
;										
		WORD	0242FH,KURODT,0242FH,KURODT,KURODT,KURODT,KURODT,KURODT
		WORD	0256DH,0257CH,02569H,0243FH,KURODT,KURODT,KURODT,KURODT
;										
		WORD	KURODT,KURODT,0242FH,KURODT,KURODT,KURODT,KURODT,KURODT
		WORD	0255AH,0257CH,0255FH,0243FH,KURODT,KURODT,KURODT,KURODT
;										
		WORD	0242FH,KURODT,KURODT,KURODT,KURODT,KURODT,KURODT,KURODT
		WORD	0240BH,0240BH,0242DH,KURODT,KURODT,KURODT,KURODT,KURODT
;										
		WORD	KURODT,KURODT,KURODT,KURODT,KURODT,KURODT,KURODT,KURODT
		WORD	02405H,0242DH,02412H,02426H,KURODT,KURODT,KURODT,KURODT
;										
		WORD	KURODT,KURODT,KURODT,KURODT,KURODT,KURODT,KURODT,KURODT
		WORD	02569H,0257CH,0256EH,0243FH,KURODT,KURODT,KURODT,KURODT
;										
		WORD	KURODT,KURODT,KURODT,0242EH,KURODT,KURODT,KURODT,KURODT
		WORD	0255CH,02559H,0257EH,0256BH,KURODT,KURODT,KURODT,KURODT
;										
		WORD	KURODT,KURODT,KURODT,KURODT,KURODT,KURODT,KURODT,KURODT
		WORD	02554H,02555H,02577H,02564H,KURODT,KURODT,KURODT,KURODT
;										
		WORD	0255EH,0257AH,02572H,0257CH,02418H,KURODT,KURODT,KURODT
		WORD	KURODT,02411H,02403H,KURODT,KURODT,KURODT,KURODT,KURODT
;										
		WORD	KURODT,KURODT,KURODT,KURODT,KURODT,KURODT,KURODT,KURODT
		WORD	02406H,02418H,02409H,KURODT,KURODT,KURODT,KURODT,KURODT
;										
		WORD	0255EH,0257AH,02572H,0255EH,02418H,KURODT,KURODT,KURODT
		WORD	KURODT,02411H,02403H,KURODT,KURODT,KURODT,KURODT,KURODT
;										
		WORD	0257CH,0257AH,02572H,0255EH,02418H,KURODT,KURODT,KURODT
		WORD	KURODT,02411H,02403H,KURODT,KURODT,KURODT,KURODT,KURODT
;										
		WORD	KURODT,KURODT,KURODT,KURODT,KURODT,KURODT,KURODT,KURODT
		WORD	02405H,02407H,02429H,0241FH,02418H,KURODT,KURODT,KURODT
;										
		WORD	KURODT,0242FH,KURODT,KURODT,KURODT,KURODT,KURODT,KURODT
		WORD	02412H,02405H,0241FH,KURODT,KURODT,KURODT,KURODT,KURODT
;										
BINMOJI		EQU	$
		WORD	KURODT,KURODT,KURODT,KURODT,KURODT,KURODT,KURODT,KURODT
		WORD	02406H,02418H,02409H,KURODT,KURODT,KURODT,KURODT,KURODT
;										
		WORD	0242FH,KURODT,KURODT,KURODT,KURODT,KURODT,KURODT,KURODT
		WORD	0241AH,0242DH,KURODT,KURODT,KURODT,KURODT,KURODT,KURODT
;										
		WORD	02401H,02418H,02410H,02418H,0242FH,KURODT,KURODT,KURODT
		WORD	KURODT,KURODT,KURODT,0241FH,0240CH,KURODT,KURODT,KURODT
;										
		WORD	02410H,02405H,02426H,02418H,0242FH,KURODT,KURODT,KURODT
		WORD	KURODT,KURODT,KURODT,0241FH,0240CH,KURODT,KURODT,KURODT
;
KONAMJI		EQU	$										
		WORD	KURODT,KURODT,KURODT,KURODT,KURODT,KURODT,KURODT,KURODT
		WORD	0241EH,0241DH,02402H,02418H,02409H,02414H,KURODT,KURODT
;										
TGMIMJI		EQU	$
		WORD	KURODT,0242FH,KURODT,KURODT,KURODT,KURODT,KURODT,KURODT
		WORD	02405H,02405H,0241FH,KURODT,KURODT,KURODT,KURODT,KURODT
;
		WORD	02563H,02576H,02551H,KURODT,KURODT,KURODT,KURODT,KURODT
		WORD	KURODT,0256BH,024AFH,0243FH,0255CH,KURODT,KURODT,KURODT
;
;
;
;
RITEM01		EQU	$
		WORD	020F5H,020F5H,020F5H,020F5H
		WORD	038BAH,038E9H,038E8H,038CBH	;yumi
		WORD	038BAH,038BBH,038CAH,038CBH	;yimi & ya
;
RITEM02		EQU	$
		WORD	020F5H,020F5H,020F5H,020F5H
		WORD	02CB8H,02CB9H,02CF5H,02CC9H
;
RITEM03		EQU	$
		WORD	020F5H,020F5H,020F5H,020F5H
		WORD	03CF5H,03CF6H,03CC0H,03CF5H
;
RITEM04		EQU	$
		WORD	020F5H,020F5H,020F5H,020F5H
		WORD	02CB2H,02CB3H,02CC2H,06CC2H
;
RITEM05		EQU	$
		WORD	020F5H,020F5H,020F5H,020F5H
		WORD	03440H,03441H,03442H,03443H	;kinoko
		WORD	0383BH,0383CH,0383DH,0383EH	;kona
;
RITEM06		EQU	$
		WORD	020F5H,020F5H,020F5H,020F5H
		WORD	024B0H,024B1H,024C0H,024C1H
;
RITEM07		EQU	$
		WORD	020F5H,020F5H,020F5H,020F5H
		WORD	02CB0H,02CB1H,02CC0H,02CC1H
;
RITEM08		EQU	$
		WORD	020F5H,020F5H,020F5H,020F5H
		WORD	0287DH,0287EH,0E87EH,0E87DH
;
RITEM09		EQU	$
		WORD	020F5H,020F5H,020F5H,020F5H
		WORD	02876H,02877H,0E877H,0E876H
;
RITEM10		EQU	$
		WORD	020F5H,020F5H,020F5H,020F5H
		WORD	02866H,02867H,0E867H,0E866H
;
RITEM11		EQU	$
		WORD	020F5H,020F5H,020F5H,020F5H
		WORD	024BCH,024BDH,024CCH,024CDH
;
RITEM12		EQU	$
		WORD	020F5H,020F5H,020F5H,020F5H
		WORD	038B6H,038B7H,038C6H,038C7H
;
RITEM13		EQU	$
		WORD	020F5H,020F5H,020F5H,020F5H
		WORD	038D0H,038D1H,038E0H,038E1H
;
RITEM14		EQU	$
		WORD	020F5H,020F5H,020F5H,020F5H
		WORD	02CD4H,02CD5H,02CE4H,02CE5H
;
RITEM15		EQU	$
		WORD	020F5H,020F5H,020F5H,020F5H
		WORD	028DCH,028DDH,028ECH,028EDH
;
RITEM16		EQU	$
RITEM29		EQU	$
RITEM30		EQU	$
RITEM31		EQU	$
RITEM32		EQU	$
		WORD	020F5H,020F5H,020F5H,020F5H
		WORD	02440H,02441H,02442H,02443H	;kinoko
		WORD	02CD2H,06CD2H,02CC3H,02CD3H	;kara
		WORD	024D2H,064D2H,024E2H,024E3H	;red
		WORD	03CD2H,07CD2H,03CE2H,03CE3H	;green
		WORD	02CD2H,06CD2H,02CE2H,02CE3H	;blue
;
RITEM17		EQU	$
		WORD	020F5H,020F5H,020F5H,020F5H
		WORD	024DCH,024DDH,024ECH,024EDH
;
RITEM18		EQU	$
		WORD	020F5H,020F5H,020F5H,020F5H
		WORD	02CDCH,02CDDH,02CECH,02CEDH
;
RITEM19		EQU	$
		WORD	020F5H,020F5H,020F5H,020F5H
		WORD	024B4H,024B5H,024C4H,024C5H
;
RITEM20		EQU	$
		WORD	020F5H,020F5H,020F5H,020F5H
		WORD	028DEH,028DFH,028EEH,028EFH	;TEGAMI
		WORD	02C62H,02C63H,02C72H,02C73H	;miror
		WORD	02886H,02887H,02888H,02889H	; T FORS
;
RITEM21		EQU	$
		WORD	020F5H,020F5H,020F5H,020F5H
		WORD	020DAH,020DBH,020EAH,020EBH
		WORD	034DAH,034DBH,034EAH,034EBH
;
RITEM22		EQU	$
		WORD	020F5H,020F5H,020F5H,020F5H
		WORD	03CA5H,03CA6H,03CD8H,03CD9H
;
RITEM23		EQU	$
		WORD	020F5H,020F5H,020F5H,020F5H
		WORD	02C9AH,02C9BH,02C9DH,02C9EH
;
RITEM24		EQU	$
		WORD	020F5H,020F5H,020F5H,020F5H
		WORD	02D2BH,02D2CH,02D2DH,02D2EH
;
RITEM25		EQU	$
		WORD	020F5H,020F5H,020F5H,020F5H
		WORD	02433H,02434H,02435H,02436H	;tama
		WORD	02C33H,02C34H,02C35H,02C36H
		WORD	03033H,03034H,03035H,03036H
		WORD	03433H,03434H,03435H,03436H
;
RITEM26		EQU	$
		WORD	020F5H,020F5H,020F5H,020F5H
		WORD	02C64H,02CCEH,02C75H,0EC64H	;KEN 1
		WORD	02464H,024CEH,02475H,0E464H     ;KEN 2
		WORD	03064H,030CEH,03075H,0F064H     ;KEN 3
		WORD	03464H,034CEH,03475H,0F464H     ;KEN 4
;
RITEM27		EQU	$
		WORD	020F5H,020F5H,020F5H,020F5H
		WORD	020FDH,060FDH,020FEH,060FEH	;TATE 1
		WORD	024FDH,064FDH,024FEH,064FEH	;TATE 2
		WORD	02CFDH,06CFDH,02CFEH,06CFEH	;TATE 3
;
RITEM28		EQU	$
		WORD	020F5H,020F5H,020F5H,020F5H
		WORD	03C68H,07C68H,03C78H,07C78H	;HUKU 1
		WORD	02068H,06068H,02078H,06078H	;HUKI2
;
RITEM37		EQU	$
		WORD	020F5H,020F5H,020F5H,020F5H
		WORD	024BFH,064BFH,02CCFH,06CCFH
;
RITEM39		EQU	$
		WORD	020F5H,020F5H,020F5H,020F5H
		WORD	028D6H,068D6H,028E6H,028E7H
;
RITEM41		EQU	$
		WORD	020F5H,020F5H,020F5H,020F5H
		WORD	030DEH,030DFH,030EEH,030EFH
;
;
;
;
;
YGROB		EQU	$
		WORD	02CF5H,02CF5H,02CF5H,02C2FH,02CF5H
		WORD	02CF5H,02C05H,02C11H,02C07H,02D28H
;
		WORD	02CF5H,02CF5H,02CF5H,02C2FH,02CF5H
		WORD	02CF5H,02C05H,02C11H,02C07H,02D29H
;
YDATA		EQU	$
		WORD	02CF5H,02CF5H,02CF5H,02CF5H,02CF5H
		WORD	02CF5H,02CF5H,02C19H,02C0BH,02C28H
;
		WORD	02CF5H,02CF5H,02CF5H,02C2FH,02CF5H
		WORD	02CF5H,02C05H,02C11H,02C07H,02D27H
;
		WORD	02CF5H,02CF5H,02CF5H,02CF5H,02CF5H
		WORD	02CF5H,02C19H,02C14H,02C0CH,02CF5H
;
		WORD	02CF5H,02CF5H,02CF5H,02CF5H,02CF5H
		WORD	02CF5H,02CF5H,02CF5H,02CF5H,02CF5H
;
		WORD	02CF5H,02CF5H,02CF5H,02C2FH,02CF5H
		WORD	02CF5H,02C04H,02C25H,02C07H,02CF5H
;
		WORD	02CF5H,02CF5H,02CF5H,02CF5H,02CF5H
		WORD	02C25H,02C20H,02CF5H,02CF5H,02CF5H
;
		WORD	02CF5H,02CF5H,02CF5H,02CF5H,02CF5H
		WORD	02C01H,02C18H,02C28H,02CF5H,02CF5H
;
		WORD	02CF5H,02CF5H,02CF5H,02CF5H,02CF5H
		WORD	02D2AH,02CF5H,02CF5H,02CF5H,02CF5H
;
TBL16_10	EQU	$
		WORD	00010,00100
;
LFDAT0		EQU	$		;life meter no max write (siro waku)(gusuu)
		WORD	024A2H
		WORD	024A2H
		WORD	024A2H
;
LFDAT1		EQU	$		;life meter no now write (gusuu)
		WORD	024A2H
		WORD	024A1H
		WORD	024A0H
;
KAIDAT		EQU	$		;kaihuku no data
		WORD	024A3H
		WORD	024A4H
		WORD	024A3H
		WORD	024A0H
;
KAIFRM		EQU	$		;kaihuku no frem su
		BYTE	07		;2
		BYTE	07		;3
		BYTE	07		;4
		BYTE	07		;1(2 kaime ikou)
;
;
BTFRDAT		EQU	$		;B item no data(TFR)
		BYTE	000H		;NOT ITEM
		BYTE	YUMIYA
		BYTE	BUMERN
		BYTE	HUKUUU
		BYTE	BOMBER
		BYTE	KONAAA
		BYTE	ROD001
		BYTE	ROD002
		BYTE	SBOMBE
		BYTE	STHAND
		BYTE	SGISIN
		BYTE	LAMPUU
		BYTE	HANMER
		BYTE	SCOPUU
		BYTE	HUEEEE
		BYTE	SOROMN
		BYTE	BIN001
		BYTE	BIN002
		BYTE	BIN003
		BYTE	KAKURE
		BYTE	TRAIFS
;
YTFRDAT		EQU	$		;Y item no data(TFR)
		BYTE	000H		;a  i  sa tu
		BYTE	001H		;i  no ru
		BYTE	006H		;ta be ru
		BYTE	002H		;ne ru
		BYTE	007H		;ka tu gu
		BYTE	003H		;ho ru
		BYTE	005H		;o  do ru
		BYTE	004H		;u  ta u
		BYTE	008H		;o  yo gu
;
ETFRDAT		EQU	$-1		;E item no data(TFR)
		BYTE	000
		BYTE	000
		BYTE	000
		BYTE	000
		BYTE	000
		BYTE	001
		BYTE	002
		BYTE	003
		BYTE	000
		BYTE	000
		BYTE	000
		BYTE	000
		BYTE	000
		BYTE	000
		BYTE	000
		BYTE	000
;
NUKIDT		EQU	0207FH		;KURO NUKI DATA
KURODT		EQU	024F5H		;KURO NUKI DATA
;
;
;
;************************************************************************
;*		Lamp on/off check			(LMPCHCK)	*
;************************************************************************
LMPCHCK		EQU	$
;// 03.04.18 //		LDA	!BPSHMD
;// 03.04.18 //;// 02.10.22 //		CMP	#004H
;// 03.04.18 //		CMP	#LAMPUU
;// 03.04.18 //		BNE	LMPCK480	; lamp on ?
;// 03.04.18 //;					; yes
		LDA	>ITEMR11
		BEQ	LMPCK180	; kantera on ?
;					; yes
		LDA	>DARKFG
		BEQ	LMPCK180	; now-dark ?
;					; yes
		LDA	!LGTWFG
		BNE	LMPCK180	; light-wipe on ?
;					; no
;// 03.04.01 //		LDA	!LGTWST
;// 03.04.01 //		CMP	#003H
;// 03.05.10 //		LDX	!LGTWST
;// 03.05.10 //		CPX	#003H
;// 03.05.10 //		BCS	LMPCK180	; light-wipe on ?
;// 03.05.10 //;					; yes
		LDA	!LGTWST
		BNE	LMPCK180	; light-wipe on ?
;					; yes
		INC	!LGTWFG
;
		LDA	#00000001B
		STA	<DPSUB
;// 03.04.01 //		INC	A
;// 03.04.01 //		TAX
;// 03.04.01 //		LDA	>DARKDT,X
;// 03.04.01 //		STA	>DKRMCG
;// 03.04.01 //		LDA	#p1_ltwp
;// 03.04.01 //		STA	<GAMEMD
;// 03.04.01 //		STZ	<JRSBPT
;// 03.04.01 //		INC	!LGTWFG		; light-wipe on
;// 03.04.01 //		JSL	>LGTWPIT	; light-wipe set
;// 03.04.01 //		LDA	#00010010B
;// 03.04.01 //		STA	<WD2130
LMPCK180	EQU	$
		RTL
;
;// 03.04.18 //LMPCK480	EQU	$
;// 03.04.18 //		LDA	!LGTWFG
;// 03.04.18 //		BEQ	LMPCK180	; light-wipe on ?
;// 03.04.18 //;					; yes
;// 03.04.18 //		STZ	!LGTWFG
;// 03.04.18 //		STZ	<DPSUB
;// 03.04.18 //;// 03.04.01 //		DEC	!LGTWST
;// 03.04.18 //;// 03.04.01 //		LDX	!LGTWST
;// 03.04.18 //;// 03.04.01 //		LDA	>DARKDT,X
;// 03.04.18 //;// 03.04.01 //		STA	>DKRMCG
;// 03.04.18 //;// 03.04.01 //		LDA	#p1_ltwp
;// 03.04.18 //;// 03.04.01 //		STA	<GAMEMD
;// 03.04.18 //;// 03.04.01 //		STZ	<JRSBPT
;// 03.04.18 //;// 03.04.01 //		STZ	!LGTWFG		; light-wipe off
;// 03.04.18 //;// 03.04.01 //		LDA	#00000010B
;// 03.04.18 //;// 03.04.01 //		STA	<WD2130
;// 03.04.18 //		RTL
;
;
;
;// 03.03.05 //;
;// 03.03.05 //;************************************************************************
;// 03.03.05 //;*		Lamp on/off check			(LMPCHCK)	*
;// 03.03.05 //;************************************************************************
;// 03.03.05 //LMPCHCK		EQU	$
;// 03.03.05 //		LDA	!BPSHMD
;// 03.03.05 //;// 02.10.22 //		CMP	#004H
;// 03.03.05 //		CMP	#LAMPUU
;// 03.03.05 //		BNE	LMPCK480	; lamp on ?
;// 03.03.05 //;					; yes
;// 03.03.05 //		LDA	>DARKFG
;// 03.03.05 //		BEQ	LMPCK180	; now-dark ?
;// 03.03.05 //;					; yes
;// 03.03.05 //		LDA	!LGTWFG
;// 03.03.05 //		BNE	LMPCK180	; light-wipe on ?
;// 03.03.05 //;					; no
;// 03.03.05 //		LDA	!LGTWST
;// 03.03.05 //		CMP	#003H
;// 03.03.05 //		BCS	LMPCK180	; light-wipe on ?
;// 03.03.05 //;					; yes
;// 03.03.05 //		TAX
;// 03.03.05 //		LDA	>CCNGED
;// 03.03.05 //		DEC	A
;// 03.03.05 //		STA	>CCNGCT
;// 03.03.05 //		LDA	>CGEDPT,X
;// 03.03.05 //		STA	>CCNGED
;// 03.03.05 //		LDA	#p1_ltwp
;// 03.03.05 //		STA	<GAMEMD
;// 03.03.05 //		STZ	<JRSBPT
;// 03.03.05 //		LDA	#002H
;// 03.03.05 //		STA	>CCNGFG		; fade-in set
;// 03.03.05 //		INC	!LGTWFG		; light-wipe on
;// 03.03.05 //		JSL	>LGTWPIT	; light-wipe set
;// 03.03.05 //		LDA	#00010000B
;// 03.03.05 //		STA	<WD2130
;// 03.03.05 //		LDA	#01110010B
;// 03.03.05 //		STA	<WD2131		; color-add. mode set
;// 03.03.05 //LMPCK180	EQU	$
;// 03.03.05 //		RTL
;// 03.03.05 //;
;// 03.03.05 //LMPCK480	EQU	$
;// 03.03.05 //		LDA	!LGTWFG
;// 03.03.05 //		BEQ	LMPCK180	; light-wipe on ?
;// 03.03.05 //;					; yes
;// 03.03.05 //		LDA	>CCNGED
;// 03.03.05 //		STA	>CCNGCT
;// 03.03.05 //		DEC	!LGTWST
;// 03.03.05 //		LDX	!LGTWST
;// 03.03.05 //		LDA	>CGEDPT-1,X
;// 03.03.05 //		STA	>CCNGED
;// 03.03.05 //		LDA	#p1_ltwp
;// 03.03.05 //		STA	<GAMEMD
;// 03.03.05 //		STZ	<JRSBPT
;// 03.03.05 //		LDA	#000H
;// 03.03.05 //		STA	>CCNGFG		; fade-out set
;// 03.03.05 //		STZ	!LGTWFG		; light-wipe off
;// 03.03.05 //		LDA	#00000010B
;// 03.03.05 //		STA	<WD2130
;// 03.03.05 //		LDA	#00100000B
;// 03.03.05 //		STA	<WD2131		; sub-add. mode set
;// 03.03.05 //		RTL
;// 03.03.05 //;
;
;
;
;
;************************************************************************
;*		Map display				(MAPDSP)	*
;************************************************************************
MAPDSP		EQU	$
		LDA	!MAPDMD
		JSL	>JSRSUB
		WORD	MPDP000		; 0 : fade out
		WORD	MPDP200		; 1 : init. display
		WORD	MPDP400		; 2 : fade in
		WORD	MPDP600		; 3 : play
		WORD	MPDP700		; 4 : scroll
		WORD	MPDP900		; 5 : fade out
		WORD	MPDP800		; 6 : game BG. display
		WORD	MPDPC00		; 7 : fade in
;
;
;
;---------------------------------------; fade out
MPDP080		EQU	$
		RTL
;
;
MPDP000		EQU	$
		DEC	<BLKFLG
		BNE	MPDP080		; fade out ?
;					; yes
		LDA	#10000000B
		STA	<BLKFLG		; blanking on
		INC	!MAPDMD
		STA	!GMAPDF
;
		STZ	!MAPCFG
		LDA	#00100000B
		STA	<WD2132R
		LDA	#01000000B
		STA	<WD2132G
		LDA	#10000000B
		STA	<WD2132B	; R.G.B. color set
;
		MEM16
		REP	#00100000B	; memory 16bit mode
;
;// 03.06.05 //		LDX	#03EH
;// 03.06.05 //		LDA	#0FF00H
;// 03.06.05 //MPDP020		EQU	$
;// 03.06.05 //;// 03.05.29 //		STA	!HDMABF+000H,X
;// 03.06.05 //;// 03.05.29 //		STA	!HDMABF+040H,X
;// 03.06.05 //;// 03.05.29 //		STA	!HDMABF+080H,X
;// 03.06.05 //;// 03.05.29 //		STA	!HDMABF+0C0H,X
;// 03.06.05 //;// 03.05.29 //		STA	!HDMABF+100H,X
;// 03.06.05 //;// 03.05.29 //		STA	!HDMABF+140H,X
;// 03.06.05 //;// 03.05.29 //		STA	!HDMABF+180H,X
;// 03.06.05 //;
;// 03.06.05 //		LDA	>CGWORK+000H,X
;// 03.06.05 //		STA	>CGRAM+000H,X
;// 03.06.05 //		LDA	>CGWORK+040H,X
;// 03.06.05 //		STA	>CGRAM+040H,X
;// 03.06.05 //		LDA	>CGWORK+080H,X
;// 03.06.05 //		STA	>CGRAM+080H,X
;// 03.06.05 //		LDA	>CGWORK+0C0H,X
;// 03.06.05 //		STA	>CGRAM+0C0H,X
;// 03.06.05 //		LDA	>CGWORK+100H,X
;// 03.06.05 //		STA	>CGRAM+100H,X
;// 03.06.05 //		LDA	>CGWORK+140H,X
;// 03.06.05 //		STA	>CGRAM+140H,X
;// 03.06.05 //		LDA	>CGWORK+180H,X
;// 03.06.05 //		STA	>CGRAM+180H,X
;// 03.06.05 //		LDA	>CGWORK+1C0H,X
;// 03.06.05 //		STA	>CGRAM+1C0H,X
;// 03.06.05 //		DEX
;// 03.06.05 //		DEX
;// 03.06.05 //		BPL	MPDP020		; wipe clear end ?
;// 03.06.05 //;					; yes
		LDA	!YUREXD
		STA	>BKYRXD
		LDA	!YUREYD
		STA	>BKYRYD
		STZ	!YUREXD
		STZ	!YUREYD
;
		LDA	<SCCH1
		STA	>BKSCH1
		LDA	<SCCH2
		STA	>BKSCH2
		LDA	<SCCV1
		STA	>BKSCV1
		LDA	<SCCV2
		STA	>BKSCV2		; SCCH,V push
		STZ	<SCCH1
		STZ	<SCCH2
		STZ	<SCCH3
		STZ	<SCCV1
		STZ	<SCCV2
		STZ	<SCCV3		; SCCH,V clear
;
		LDA	<WD2130
		STA	>BKWD2130
		LDA	#02002H
		STA	<WD2130
;
;
		LDX	#000H
		LDA	#01C7EH
MPDP040		EQU	$
		STA	>MAPBUF+000H,X
		STA	>MAPBUF+100H,X
		STA	>MAPBUF+200H,X
		STA	>MAPBUF+300H,X
		STA	>MAPBUF+400H,X
		STA	>MAPBUF+500H,X
		STA	>MAPBUF+600H,X
		STA	>MAPBUF+700H,X
;
		STA	>MAPBUF+0800H,X
		STA	>MAPBUF+0900H,X
		STA	>MAPBUF+0A00H,X
		STA	>MAPBUF+0B00H,X
		STA	>MAPBUF+0C00H,X
		STA	>MAPBUF+0D00H,X
		STA	>MAPBUF+0E00H,X
		STA	>MAPBUF+0F00H,X
;
		DEX
		DEX
		BNE	MPDP040		; map-buffer clear end ?
;					; yes
		MEM8
		SEP	#00100000B	; memory 8bit mode
		RTL
;
;
;---------------------------------------; init. display
;
;
MPDPTBL		EQU	$
		WORD	DMAPWT000		; 0 : char irekae
		WORD	DMAPWT100		; 1 : map waku write
		WORD	DMAPWT200		; 2 : danmenzu write
		WORD	DMAPWT300		; 3 : meiro write
		WORD	DMAPWT400		; 4 : obj initial set
;
MPDP200		EQU	$
;;;		JSL	>VRAMCL1	; VCL
;
;;;		PHB
;;;		PHK
;;;		PLB			; (DBR) set
;
;;;		MEM16
;;;		IDX16
;;;		REP	#00110000B	; memory,index 16bit mode
;
;;;		LDX	#0007EH		;OAMSB cls
MPINIT0		EQU	$
;;;		STZ	OAMSB,X
;;;		DEX
;;;		DEX
;;;		BPL	MPINIT0
;;;;
;;;		LDA	#00F9EH		;MAP NEXT BG POINT SET
;;;		STA	MAPBGP
;;;;
;;;		MEM8
;;;		IDX8
;;;		SEP	#00110000B	; memory,index 8bit mode
;;;;
;;;		STZ	MAPCFG		;2 OR 3 MAP KAZU CLS(3 KO)
;;;;
;;;		MEM8			;INITIAL TOP
;;;		IDX16
;;;		REP	#00010000B
;;;		LDA	!FLORNO
;;;;		LSR	A
;;;		INC	A
;;;;		STA	MAPLEV
;;;;		LDA	!FLORNO
;;;;		AND	#10000000B
;;;;		EOR	MAPLEV
;;;		STA	MAPLEV
;;;		MEM16
;;;		IDX16
;;;		REP	#00110000B
;;;		LDA	!DJNNO
;;;		AND	#000FFH
;;;;		ASL	A
;;;		TAX
;;;		MEM8
;;;		SEP	#00100000B
;;;;;;		LDA	TOWERD0,X
;;;		DEC	A
;;;		CMP	MAPLEV
;;;		BMI	MPINIT11
;;;		MEM16
;;;		IDX16
;;;		REP	#00110000B
;;;		LDA	#00F9EH
;;;		STA	MAPWTA
;;;		MEM8
;;;		IDX8
;;;		SEP	#00110000B
;;;		JSR	MAPWKST1
;;;		JSR	MAPWKST2
;;;;
MPINIT11	EQU	$
;;;		MEM8			;INITIAL MIDEL
;;;		IDX16
;;;		REP	#00010000B
;;;		LDA	!FLORNO
;;;;		LSR	A
;;;;		STA	MAPLEV
;;;;		LDA	!FLORNO
;;;;		AND	#10000000B
;;;;		EOR	MAPLEV
;;;		STA	MAPNOW		;MIDEL POINT SET
;;;		STA	MAPLEV
;;;		MEM16
;;;		IDX16
;;;		REP	#00110000B
;;;		LDA	#0025EH
;;;		STA	MAPWTA
;;;		MEM8
;;;		IDX8
;;;		SEP	#00110000B
;;;;;;		JSR	MAPWKST1
;;;;;;		JSR	MAPWKST2
;;;;
;;;		MEM8			;INITIAL BOTOM
;;;		IDX16
;;;		REP	#00010000B
;;;		LDA	!FLORNO
;;;;		LSR	A
;;;		DEC	A
;;;;		STA	MAPLEV
;;;;		LDA	!FLORNO
;;;;		AND	#10000000B
;;;;;;;		EOR	MAPLEV
;;;		STA	MAPLEV
;;;		MEM16
;;;		IDX16
;;;		REP	#00110000B
;;;		LDA	!DJNNO
;;;		AND	#000FFH
;;;;		ASL	A
;;;		TAX
;;;		MEM8
;;;		SEP	#00100000B
;;;;;;		LDA	TOWERD0+1,X
;;;		CLC
;;;		ADC	MAPLEV
;;;		BMI	MPINIT12
;;;		MEM16
;;;		IDX16
;;;		REP	#00110000B
;;;		LDA	#0051EH
;;;		STA	MAPWTA
;;;		MEM8
;;;		IDX8
;;;;;;		SEP	#00110000B
;;;		JSR	MAPWKST1
;;;		JSR	MAPWKST2
MPINIT12	EQU	$
;
;;;		MEM8
;;;		IDX8
;;;		SEP	#00110000B
;;;;
;;;		PLB			; (DBR) reset
;;;;
;// 03.01.31 //		LDA	!CHARBK
;// 03.01.31 //		STA	>BKCHBK
;;;		LDA	!CHIKNO
;;;		STA	>BKCHNO
;;;		LDA	!ROBJCPT
;;;		STA	>BKROJC
;;;		LDA	!RBGCPT
;;;		STA	>BKRBGC
;;;		LDA	<DPMAIN
;;;		STA	>BKDPMN
;;;		LDA	<DPSUB
;;;		STA	>BKDPSB		; BG. chara,DPMAIN,DPSUB push
;;;;
;;;		LDA	#020H
;// 03.01.31 //		STA	!CHARBK
;;;		STA	!CHIKNO
;;;		LDA	#030H
;;;		STA	!ROBJCPT
;;;		STA	!RBGCPT
;;;		LDA	#00010111B
;;;		STA	<DPMAIN
;;;		STZ	<DPSUB		; map char. flag set
;;;;
;;;		LDA	#00000010B
;;;		STA	2101H
;;;		JSL	>CHSCHNG	; MAP character set
;;;;
;;;		LDA	#002H
;;;		STA	!CGSTPT+1	; (CGWORK) set
;;;		JSL	>MAPCGSET	; MAP CG. BG. set
;;;;;;		JSL	>MAPOBSET	;         OBJ set
;;;		LDA	#001H
;;;		STA	!BG3BGC
;;;		JSL	>B3CGSET	;         BG.3 set
;;;		INC	<CGVMAF
;;;;
;;;;;;		JSR	MPB3ST		; map BG.3 set
;;;;
;;;;;;		JSR	MPB1ST		; map BG.1 set
;;;;
;;;;;;		JSR	TOWERST		; tower set
;;;;
;
;
;
		LDA	!MAPCFG
		ASL	A
		TAX
		JMP	(MPDPTBL,X)
;
;
DMAPWT000	EQU	$
		LDA	!CHIKNO
		STA	>BKCHNO
		LDA	!ROBJCPT
		STA	>BKROJC
		LDA	!RBGCPT
		STA	>BKRBGC
		LDA	<DPMAIN
		STA	>BKDPMN
		LDA	<DPSUB
		STA	>BKDPSB		; BG. chara,DPMAIN,DPSUB push
;
		LDA	#020H
;// 03.01.31 //		STA	!CHARBK
		STA	!CHIKNO
		LDA	#080H
		STA	!ROBJCPT
		LDA	#040H
		STA	!RBGCPT
		LDA	#00010110B
		STA	<DPMAIN
		LDA	#00000001B
		STA	<DPSUB		; map char. flag set
;
		LDA	#00000010B
		STA	2101H
		JSL	>CHSCHNG	; MAP character set
;
		LDA	#002H
		STA	!CGSTPT+1	; (CGWORK) set
		JSL	>MAPCGSET	; MAP CG. BG. set
		JSL	>MAPOBSET	;         OBJ set
		LDA	#001H
		STA	!BG3BGC
		JSL	>B3CGSET	;         BG.3 set
		INC	<CGVMAF
		INC	!MAPCFG
;
		RTL
;
;
DMAPWT100	EQU	$
;
		JSL	>VRAMCL1	; VCL
;
;
;;;3.3.5.TUE:			JSR	MAPW000		; MAP waku write !!
;;;3.3.5.TUE:MAPW000		EQU	$
;
		IDX16
		REP	#00010000B		; index 16bit mode
;
		LDX	#DMAP000-MAPWAKU-1
		STX	!VRAMD
MAPWT000	EQU	$
		LDA	>MAPWAKU,X
		STA	!VRAMD2,X
		DEX
		BPL	MAPWT000
;
		IDX8
		SEP	#00010000B		; index 8bit mode
;
		INC	!MAPCFG
;
		LDA	#VT01
		STA	<VRFLG
;
		RTL
;
;
;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;		haikei	set !!
;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
MPGRADD		EQU	$
		WORD	01223H
		WORD	01223H+040H,01223H+080H,01223H+0C0H,01223H+0100H
		WORD	01223H-040H,01223H-080H,01223H-0C0H,01223H-0100H
;
;
DMAPWT200	EQU	$
;
		PHB
		PHK
		PLB		; PBR => DBR
;
		MEM16
		IDX16
		REP	#00110000B		; memory,index 16bit mode
;
		STZ	!VRAMD
		LDX	!DJNNO
		PHX
		LDA	>TOWERDT,X
		AND	#00300H
		BEQ	MPDP220			; normal ?
;						; no
		AND	#00100H
		BEQ	MPDP220			; mountain ?
;						; yes
		MEM8
		SEP	#00100000B		; memory 8bit mode
;
		LDX	#DMAPMIZU-DMAPYAMA
		STX	!VRAMD
MPDP210		EQU	$
		LDA	DMAPYAMA-1,X
		STA	!VRAMD2-1,X
		DEX
		BNE	MPDP210
;
		MEM16
		REP	#00100000B		; memory 16bit mode
;
MPDP220		EQU	$
		STZ	<WORK0
		STZ	<WORK2
		LDX	!DJNNO
		LDA	>TOWERDT,X
		AND	#000FFH
		CMP	#00050H
		BCC	MPDP230
;
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		SEC
		SBC	#00004H
		ASL	A
		STA	<WORK0
		BRA	MPDP240
;
MPDP230		EQU	$
		AND	#0000FH
		CMP	#00005H
		BCC	MPDP240
;
		ASL	A
		STA	<WORK0
MPDP240		EQU	$
		LDX	<WORK0
		LDY	!VRAMD
		LDA	MPGRADD,X
		STA	<WORK0
		STA	<WORKE
MPDP243		EQU	$
		LDA	<WORK0
		XBA
		STA	!VRAMD2,Y
		INY
		INY
		LDA	#00E40H
		STA	!VRAMD2,Y
		INY
		INY
		LDX	<WORK2
		LDA	MPGRDT,X
		STA	<WORK4
		LDX	!DJNNO
		LDA	TOWERDT,X
		AND	#00200H
		BEQ	MPDP244
;
		LDA	<WORK4
		CLC
		ADC	#00400H
		STA	<WORK4
MPDP244		EQU	$
		LDA	<WORK4
		STA	!VRAMD2,Y
		INY
		INY
		LDA	<WORK2
		CMP	#0000CH
		BEQ	MPDP245
;
		INC	<WORK2
		INC	<WORK2
MPDP245		EQU	$
		LDA	<WORK0
		CLC
		ADC	#00020H
		STA	<WORK0
		CMP	#01360H
		BCC	MPDP243
		STY	!VRAMD
MPDP250		EQU	$
;
		MEM8
		SEP	#00100000B		; memory 8bit mode
;
		PLX
;
		JSR	BLWRITE
;
		IDX16
		REP	#00010000B		; index 16bit mode
;
		LDY	!VRAMD
		LDA	#0FFH
		STA	!VRAMD2,Y
;
		IDX8
		SEP	#00010000B		; index 8bit mode
;
		INC	!MAPCFG
;
		LDA	#VT01
		STA	<VRFLG
;
		PLB		; DBR reset !!
;
		RTL
;
;
;
;===============< tategiri map block >=======================
;
MAPBLDT		EQU	$
		WORD	     00F26H,00F27H,04F27H,04F26H
		WORD	     08F26H,08F27H,0CF27H,0CF26H
;
;
;============================================================
;
BLCODT		EQU	$
		WORD	00000H,00400H
;
;============================================================
;
		IDX16
;
BLWRITE		EQU	$
;
		MEM16
		REP	#00100000B		; memory 16bit mode
;
		LDA	TOWERDT,X
		AND	#000FFH
		STA	<WORK2
		AND	#0000FH
		STA	<WORK0			; chikakaisuu => WORK0
		LDA	<WORK2
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		CLC
		ADC	<WORK0
		STA	<WORK2			; soukaisuu => WORK2
;
		LDA	<FLORNO
		CLC
		ADC	<WORK0
		AND	#00FFH
		STA	<WORKC			; playerkaisuu => WORKC
;
		STZ	<WORKA			; initial set
		LDA	<WORKE
		SEC
		SBC	#00040H
		CLC
		ADC	#00002H
		STA	<WORKE
;
		LDX	<WORK0
		BEQ	BLKWT010
;
		LDA	<WORKE
BLKWT000	EQU	$
		CLC
		ADC	#00040H
		DEX
		BNE	BLKWT000
;
		STA	<WORKE
BLKWT010	EQU	$
;
		IDX16
		REP	#00010000B		; index 16bit mode
;
		LDY	!VRAMD
BLKWT015	EQU	$
		LDX	#00000H
		LDA	<WORKE
BLKWT020	EQU	$
		XBA
		STA	!VRAMD2,Y
		INY
		INY
		LDA	#00700H
		STA	!VRAMD2,Y
		INY
		INY
BLKWT030	EQU	$
		LDA	MAPBLDT,X
		PHX
		PHA
;
		LDX	#00000H
		LDA	<WORKA
; '91/ 4/ 2 ::		CMP	<WORKC
; '91/ 4/ 2 ::		BCC	BLKWT035
; '91/ 4/ 2 ::;
		CMP	<WORK0
		BMI	BLKWT035
;
; '91/ 4/ 5 ::		INX
; '91/ 4/ 5 ::		INX
; '91/ 4/ 2 ::		CMP	<WORKC
; '91/ 4/ 2 ::		BEQ	BLKWT035
; '91/ 4/ 2 ::;
		INX
		INX
BLKWT035	EQU	$
		PLA
;
		SEC
		SBC	BLCODT,X
		STA	!VRAMD2,Y
		PLX
;
		INY
		INY
		INX
		INX
		CPX	#00008H
		BCC	BLKWT030
;
		BEQ	BLKWT038
;
		CPX	#00010H
		BNE	BLKWT030
;
		BRA	BLKWT040
;
BLKWT038	EQU	$
		LDA	<WORKE
		CLC
		ADC	#00020H
		BRA	BLKWT020
;
BLKWT040	EQU	$
		LDA	<WORKE
		SEC
		SBC	#00040H
		STA	<WORKE
		INC	<WORKA
		LDA	<WORKA
		CMP	<WORK2
		BMI	BLKWT015
;
		STY	!VRAMD
;
		MEM8
		IDX8
		SEP	#00110000B		; memory,index 8bit mode
;
		RTS
;
;
;
;
DMAPWT300	EQU	$
;
;;;3.3.5.TUE:;
;;;3.3.5.TUE:		IDX16
;;;3.3.5.TUE:		REP	#00010000B		; index 16bit mode
;;;3.3.5.TUE:;
;;;3.3.5.TUE:		LDX	#TOWERDT-DMAPMAIZ-1
;;;3.3.5.TUE:		STX	!VRAMD
;;;3.3.5.TUE:DMAPWT110	EQU	$
;;;3.3.5.TUE:		LDA	>DMAPMAIZ,X
;;;3.3.5.TUE:		STA	!VRAMD2,X
;;;3.3.5.TUE:		DEX
;;;3.3.5.TUE:		BPL	DMAPWT110
;;;3.3.5.TUE:;
;;;3.3.5.TUE:		LDX	!DJNNO
;;;3.3.5.TUE:		LDA	<FLORNO
;;;3.3.5.TUE:		BMI	DMAPWT120		; chika ni iruka ?
;;;;3.3.5.TUE:						; no
;;;3.3.5.TUE:		LDA	>TOWERDT,X
;;;3.3.5.TUE:		AND	#00FH
;;;3.3.5.TUE:		BNE	DMAPWT150		; chika wa aru ?
;;;3.3.5.TUE:;						; no
;;;3.3.5.TUE:		BRA	DMAPWT130
;;;3.3.5.TUE:;
;;;3.3.5.TUE:DMAPWT120	EQU	$
;;;3.3.5.TUE:		LDA	>TOWERDT,X
;;;3.3.5.TUE:		AND	#00FH
;;;3.3.5.TUE:		STA	<WORK0
;;;3.3.5.TUE:		LDA	<FLORNO
;;;3.3.5.TUE:		EOR	#0FFH
;;;3.3.5.TUE:		CLC
;;;3.3.5.TUE:		ADC	#001H
;;;3.3.5.TUE:		CMP	<WORK0
;;;3.3.5.TUE:		BMI	DMAPWT150
;;;3.3.5.TUE:;
;;;3.3.5.TUE:DMAPWT130	EQU	$
;;;3.3.5.TUE:;
;;;3.3.5.TUE:		MEM16
;;;3.3.5.TUE:		REP	#00100000B		; memory 16bit mode
;;;3.3.5.TUE:;
;;;3.3.5.TUE:		LDX	#00004H
;;;3.3.5.TUE:DMAPWT140	EQU	$
;;;3.3.5.TUE:		LDA	!VRAMD2,X
;;;3.3.5.TUE:		SEC
;;;3.3.5.TUE:		SBC	#00400H
;;;3.3.5.TUE:		STA	!VRAMD2,X
;;;3.3.5.TUE:		INX
;;;3.3.5.TUE:		INX
;;;3.3.5.TUE:		INX
;;;3.3.5.TUE:		INX
;;;3.3.5.TUE:		INX
;;;3.3.5.TUE:		INX
;;;3.3.5.TUE:		CPX	#TOWERDT-DMAPMAIZ-1
;;;3.3.5.TUE:		BCC	DMAPWT140
;;;3.3.5.TUE:;
;;;3.3.5.TUE:		MEM8
;;;3.3.5.TUE:		SEP	#00100000B		; memory 8bit mode
;;;3.3.5.TUE:;
;;;3.3.5.TUE:DMAPWT150	EQU	$
;;;3.3.5.TUE:;
;;;3.3.5.TUE:		IDX8
;;;3.3.5.TUE:		SEP	#00010000B		; index 8bit mode
;;;;
;;;		LDA	#VT01
;;;		STA	<VRFLG
;
;
;
;
; -- [ FLOOR WRITE MAIN ] -------------------------------------------
;
;
		PHB
		PHK
		PLB			; PBR=>DBR
;
; === < initial > ============================
;
		STZ	!MAPLEV		; Now scroll flag
;
		MEM16 
		IDX16
		REP	#00110000B	; Memory,index 16bit mode
;
		STZ	<WORK0
		STZ	<WORK2
		STZ	<WORK4
;
		STZ	<WORK6		; MAPBUF add data
		STZ	<WORK8		; Floor color and data
		STZ	<WORKA		; Scroll up,down data
		STZ	<WORKC
;
		STZ	!MAPWTA		; obj address index initial set
;
;
		LDX	!DJNNO
		LDA	TOWERDT,X
		AND	#0000FH
		EOR	#000FFH
		INC	A
		CMP	<FLORNO
		BEQ	FLMAIN010	; Bottom step ?
;					: No
;
		LDA	<FLORNO
		AND	#000FFH
		STA	!MAPBGP		; Map set floor position
;;;		LDA	#0EFFFH
;;;		STA	<WORK8		; Floor color set (yellow)
;
		BRA	FLMAIN020
;
FLMAIN010	EQU	$
		LDA	<FLORNO
		INC	A
		STA	!MAPBGP		; Map set floor position
;;;		LDA	#0EBFFH
;;;		STA	<WORK8		; Floor color set (red)
;
		INC	!MAPWTA
		INC	!MAPWTA		; obj address index set
;
FLMAIN020	EQU	$
		LDA	!MAPBGP
		AND	#00080
		BNE	FLMAIN021	; Chijyo ?
;					: Yes	
		LDA	#0EBFFH
		STA	<WORK8		; Floor color set (new yellow)
		BRA	FLMAIN022
;
FLMAIN021	EQU	$
		LDA	#0EFFFH
		STA	<WORK8		; Floor color set (new blue)
;
FLMAIN022	EQU	$
		JSR	MOJISET		; 1F(high) Moji write
		JSR	WAKUSET		; 1F(high) waku write
		JSR	MAPUNST		; 1F(high) map write
;
  		DEC	!MAPBGP		; Map set floor position
;
		MEM16
        	IDX16
		REP	#00110000B	; Memory,index 16bit mode
;
  		LDA	#00300H
		STA	<WORK6
;
		LDA	!MAPWTA
		BNE	FLMAIN030	; Bottom step ?
;					: No
;
;;;		LDA	#0F3FFH
;;;		STA	<WORK8		; Floor color set (blue)
		BRA	FLMAIN040
;
FLMAIN030	EQU	$
;;;		LDA	#0EFFFH
;;;		STA	<WORK8		; Floor color set (yellow)
;
FLMAIN040	EQU	$
		LDA	!MAPBGP
		AND	#00080
		BNE	FLMAIN041	; Chijyo ?
;					: Yes	
		LDA	#0EBFFH
		STA	<WORK8		; Floor color set (new yellow)
		BRA	FLMAIN042
;
FLMAIN041	EQU	$
		LDA	#0EFFFH
		STA	<WORK8		; Floor color set (new blue)
;
FLMAIN042	EQU	$
		JSR	MOJISET		; B1(low) Moji write
		JSR	WAKUSET		; B1(low) waku write
		JSR	MAPUNST		; B1(high) map write
;
		MEM16
        	IDX16
		REP	#00110000B	; Memory,index 16bit mode
;
		INC	!MAPBGP		; Map set floor position reset
		STZ	<WORK6		; MAPBUF add data reset
;
;
		MEM8 
		IDX8
		SEP	#00110000B	; Memory,index 8bit mode
;
;
; ============================================
;
		LDA     #bgw8		; BG write set
		STA     <BGWTFG
		LDA	#022H
		STA     !NXBWFG
		INC	!MAPCFG
;
		PLB			; DBR reset
;
		RTL
;
; -------------------------------------------------------------------
;
;
;************************************************************************
;*		WAKU WRITE						*
;************************************************************************
WKADODT		EQU	$
		WORD	01F19H,05F19H,09F19H,0DF19H
;			HL     HR     LF     LR
;
WKADOPS		EQU	$
		WORD	000E2H,000F8H,003A2H,003B8H
;
WYOKODT		EQU	$
		WORD	01F1AH,09F1AH
;			HIGH   LOW
;
WYOKOPS		EQU	$
		WORD	000E4H,003A4H
;
WTATEDT		EQU	$
		WORD	01F1BH,05F1BH
;			LEFT   RIGHT
;
WTATEPS		EQU	$
		WORD	00122H,00138H
;
;
WAKUSET		EQU	$
		MEM16 
		IDX16
		REP	#00110000B	; Memory,index 16bit mode
;
;
; ---- [ Kado set ] -------------
;
		STZ	<WORK2		; Kado count clear
;
WAKU020		EQU	$
		LDY	<WORK2
		LDA	WKADOPS,Y
		CLC
		ADC	<WORK6
		AND	#00FFFH
		TAX
;
		LDA	#00F00H		; Write area clear
		STA	>MAPBUF,X
;
		LDA	WKADODT,Y	; Kado write
		AND	<WORK8
		STA	>MAPBUF,X
;
		INC	<WORK2
		INC	<WORK2
		LDA	<WORK2
		CMP	#00008H
		BNE	WAKU020		; 4 kado write ?
;					: Yes
;
; ---- [ Yoko set ] -------------
;
		LDY	#00000H
;
WAKU030		EQU	$
		STZ	<WORK2		; Yoko count clear
		LDA	WYOKOPS,Y
		CLC
		ADC	<WORK6
		STA	<WORK4		; Left point set
;
WAKU040		EQU	$
		LDA	<WORK4
		CLC
		ADC	<WORK2
		AND	#00FFFH
		TAX
;
		LDA	#00F00H		; Write area clear
		STA	>MAPBUF,X
;
		LDA	WYOKODT,Y	; Yoko line write
		AND	<WORK8
		STA	>MAPBUF,X
;
		INC	<WORK2
		INC	<WORK2
		LDA	<WORK2
		CMP	#00014H
		BNE	WAKU040		; 10 line write ?
;					: Yes
		INY
		INY
		CPY	#00004H
		BNE	WAKU030		; High, low write ?
;					: Yes
;
; ---- [ Tate set ] -------------
;
		LDY	#00000H
;
WAKU050		EQU	$
		STZ	<WORK2		; Tate count clear
		LDA	WTATEPS,Y
		CLC
		ADC	<WORK6
		STA	<WORK4		; High point set
;
WAKU060		EQU	$
		LDA	<WORK4
		CLC
		ADC	<WORK2
		AND	#00FFFH
		TAX
;
		LDA	#00F00H		; Write area clear
		STA	>MAPBUF,X
;
		LDA	WTATEDT,Y	; Tate line write
		AND	<WORK8
		STA	>MAPBUF,X
;
		LDA	<WORK2
		CLC
		ADC	#00040H
		STA	<WORK2
		CMP	#00280H
		BNE	WAKU060		; 10 line write ?
;					: Yes
		INY
		INY
		CPY	#00004H
		BNE	WAKU050		; Left, right write ?
;					: Yes
;
		MEM8 
		IDX8
		SEP	#00110000B	; Memory,index 8bit mode
;
		RTS
;
;************************************************************************
;*		MOJI WRITE						*
;************************************************************************
WMJSUDT         EQU     $
                WORD    01F1EH,01F1FH,01F20H,01F21H
		WORD	01F22H,01F23H,01F24H,01F25H
;
MOJISET		EQU	$
		MEM16
		IDX16
		REP	#00110000B	; Memory,index 16bit mode
;
;
		LDA	#000DEH		; Moji clear count set
		STA	<WORK0
;
MOJI005		EQU	$
		LDA	<WORK0
		CLC
		ADC	<WORK6
		AND	#00FFFH
		TAX
;
		LDA	#00F00H		; Write area clear
		STA	>MAPBUF,X
		STA	>MAPBUF+002H,X
;
		LDA	<WORK0
		CLC
		ADC	#00040H
		STA	<WORK0
		CMP	#0039EH
		BNE	MOJI005		; Moji write area clear end ?
;					: Yes
;
; --------------------------------------------------------------
		LDA	!MAPBGP		; Now kaisu
		AND	#00080H
		BEQ	MOJI010		; Chijyo ?
;					: No
;
		LDA	#01F1CH		; "B" data get
		BRA	MOJI020
;
MOJI010		EQU	$
		LDA	!MAPBGP		; Now kaisu
		AND	#0000FH
		ASL	A
		TAY
		LDA	WMJSUDT,Y	; Kaisu no. get
;
MOJI020		EQU	$
		PHA		
;
		LDA	#0035EH		; Moji set position
		CLC
		ADC	<WORK6
		AND	#00FFFH
		TAX
;
		PLA
		AND	<WORK8
		STA	>MAPBUF,X	; Left moji write
;
		LDA	!MAPBGP		; Now kaisu
		AND	#00080H
		BEQ	MOJI030		; Chijyo ?
;					: No
;
		LDA	!MAPBGP		; Now kaisu
		AND	#000FFH
		EOR	#000FFH
		ASL	A
		TAY
		LDA	WMJSUDT,Y	; Kaisu no. get
		BRA	MOJI040
;
MOJI030		EQU	$
		LDA	#01F1DH		; "F" data get
;
MOJI040		EQU	$
		AND	<WORK8
		STA	>MAPBUF+002H,X	; Right moji write
;
		MEM8 
		IDX8
		SEP	#00110000B	; Memory,index 8bit mode
;
		RTS
;
;
;************************************************************************
;*		MAP UNIT SET						*
;************************************************************************
XUNPODT		EQU	$
		WORD	00124H,001A4H,00224H,002A4H,00324H
;
MAPUNST		EQU	$
		MEM16
		IDX16
		REP	#00110000B	; Memory,index 16bit mode
;
		STZ	<WORK0		; Line count clear
;
MAPST010	EQU	$
		LDA	<WORK0
		ASL	A
		TAX
		LDA	XUNPODT,X	; Line position get
		CLC
		ADC	<WORK6
		AND	#00FFFH
		TAX
;
		JSR	MAPUNWR		; Map unit write
;
		INC	<WORK0		; Line count inc
		LDA	<WORK0
		CMP	#00005H
		BNE	MAPST010	; 5 line write ?
;					: Yes
;
		MEM8 
		IDX8
		SEP	#00110000B	; Memory,index 8bit mode
;
		RTS
;
;
;************************************************************************
;*		MAP UNIT WRITE						*
;************************************************************************
UNGETDT		EQU	$
		WORD	00000H,0000AH,00014H,0001EH,00028H
;
STEPADT		EQU	$
		WORD	00000H,00032H,00064H,00096H,000C8H
		WORD	000FAH,0012CH,0015EH,00190H
;
CLCMPDT		EQU	$
		WORD	00300H,00B00H,00F00H
;
;
MAPUNWR		EQU	$
		MEM16
		IDX16
		REP	#00110000B	; Memory,index 16bit mode
;
		STZ	<WORK2		; Unit count clear
;
MAPWR010	EQU	$
		STZ	<WORKE		; Go add data clear
		PHX			; X index push
;
		LDA	<WORK0
		ASL	A
		TAX
;
		LDA	<WORK2		; Yoko unit count
		ASL	A
		ADC	UNGETDT,X	; Unit line
		STA	<WORK4
;
		MEM8
		SEP	#00100000B	; Memory 8bit mode
;
		LDX	!DJNNO
		LDA	TOWERDT,X
		AND	#00FH
		CLC
		ADC	!MAPBGP
		ASL	A
;
		STA	<WORKE		; New 1990/05/22
;
		TAY
;
		MEM16
		REP	#00100000B	; Memory 16bit mode
;
;;		LDA	TWDTADD2,X
		LDA	TOWERADD,X	; Tower data no. label get
		STA	<WORKC
		LDA	TWDTADD1,Y	; Step no. get
		CLC
		ADC	<WORK4
		TAY
;
		LDA	(<WORKC),Y	; Index data get
		CMP	#0FFFFH
		BNE	MAPWR020	; Space area ?
;					: Yes
;
		LDA	LASTUNO		; Last unit no. set
;;		ASL	A
;;		ASL	A
		BRA	MAPWR030
;
;
MAPWR020	EQU	$
;
; --- [ Old version ] ---------------------
;;
;
;		STA	<WORK4		; TWDTADD * 3 --> X index
;;
		ASL	A
		PHA
;
		LDA	TWDTADD2,X
		STA	<WORKC
;
		LDA	<WORKE
		AND	#000FFH
		TAY
;
		LDA	TWDTADD1,Y	; Step no. get
		CLC
		ADC	<WORK4
		TAY
		LDA	(<WORKC),Y	; Index data get
		ASL	A
;
		TAX
		LDA	>DJNTBL,X
		AND	#0000FH
;;;;
;;;		BNE	MAPWR025	; Go to room ?
;;;;					: No
;;;;
;;;		LDA	#0000CH		; Go add data set
;
		STA	<WORKE		; Go data store
;
;
;MAPWR025	EQU	$
		PLA
		BRA	MAPWR0301
;
;		ADC	<WORK4
;		TAX
;;
;		LDA	>DJNDT,X	; Adress data ==> <WORKB,C,D
;		STA	<WORKB
;		LDA	>DJNDT+1,X
;		STA	<WORKC
;		LDY	#00001H
;		LDA	[<WORKB],Y	; Unit no. get
;		AND	#000FFH
;
;
; ----------------------------------------------------
;;;
;;;
;;		PHX
;;;
;;		LDA	<WORK0
;;		ASL	A
;;		TAX
;;;
;;		LDA	<WORK2		; Yoko unit count
;;		ASL	A
;;		CLC
;;		ADC	UNGETDT,X	; Unit line
;;		STA	<WORK4
;;;
;;		LDX	!DJNNO
;;		LDA	FLDTADD,X
;;		CLC
;;		ADC	<WORK4
;;		STA	<WORK4
;;;
;;		LDA	TOWERDT,X
;;		AND	#000F0H		; High step get
;;		LSR	A
;;		LSR	A
;;		LSR	A
;;		LSR	A
;;		DEC	A
;;		SEC
;;		SBC	!MAPBGP		; Now kaisu
;;		AND	#000FFH
;;		ASL	A
;;		TAX
;;;
;;		LDA	STEPADT,X	; Step count add
;;		CLC
;;		ADC	<WORK4
;;		TAY
;;		PLX
;;;
;;		LDA	#00F00H		; Write area clear
;;		STA	>MAPBUF,X
;;		STA	>MAPBUF+02H,X
;;		STA	>MAPBUF+040H,X
;;		STA	>MAPBUF+042H,X
;;;
;;		LDA	FLDATA000,Y	; Unit No. get
;;		CMP	#0FFFFH
;;		BNE	MAPWR020	; Space area ?
;;;					; Yes
;;;
;;		LDA	#00035H		; Last unit no. set
;;;
; ----------------------------------------------------
;
MAPWR030	EQU	$
		ASL	A		; Unit data 
;
MAPWR0301	EQU	$
		ASL	A 
		ASL	A 
		TAY
;
;
;;;		LDA	<WORK8
;;;		ROL	A
;;;		ROL	A
;;;		ROL	A
;;;		ROL	A
;;;		ROL	A
;;;		ROL	A
;;;		ROL	A
;;;		AND	#00003H
;;;		CMP	#00003H
;;;		BNE	MAPWR031	; Color yellow ?
;;;;					: Yes
;;;;		INC	A
;;;;
MAPWR031	EQU	$
;;;		TAX
;;;		LDA	CLCMPDT,X
;;;		STA	<WORKC
;
		PLX
		STZ	<WORKC
		LDA	MAPUNIT,Y	; Map unit write ( High left )
		AND	<WORK8
;;;		CMP	<WORKC
;;;		BEQ	MAPWR035
;;;		CLC
;;;		ADC	<WORKE
;
		PHA
		CMP	#00F00H
		BEQ	MAPWR035	; Space area (blue)?
;					: No
		CMP	#00B00H
		BEQ	MAPWR035	; Space area (yellow)?
;					: No
		LDA	<WORKE
		AND	#00008H
		BNE	MAPWR035	; Go to room ?
;					: No
		LDA	#00800H
		STA	<WORKC		
;
MAPWR035	EQU	$
		PLA
		CLC
		ADC	<WORKC
;
		PHX
		STA	<WORKC		; Unit data store
		LDX	!DJNNO
		LDA	>MAPCNT
		AND	>BITCD0,X
		BNE	MAPWR0355	; Do you have a map ?
;					: No
;
		LDA	<WORKE
		AND	#00008H
		BNE	MAPWR0355	; Go to room ?
;					: No
;
		LDA	#00F00H		; Space area (yellow) set
		BRA	MAPWR0357
;
MAPWR0355	EQU	$
		LDA	<WORKC
MAPWR0357	EQU	$
		PLX
		STA	>MAPBUF,X
; ---------
		STZ	<WORKC
		LDA	MAPUNIT+02H,Y	; ( High right )
		AND	<WORK8
;;;		CMP	<WORKC
;;;		BEQ	MAPWR036
;;;		CLC
;;;		ADC	<WORKE
;
		PHA
		CMP	#00F00H
		BEQ	MAPWR036	; Space area (blue)?
;					: No
		CMP	#00B00H
		BEQ	MAPWR036	; Space area (yellow)?
;					: No
		LDA	<WORKE
		AND	#00004H
		BNE	MAPWR036	; Go to room ?
;					: No
		LDA	#00800H
		STA	<WORKC		
;
MAPWR036	EQU	$
		PLA
		CLC
		ADC	<WORKC
;
		PHX
		STA	<WORKC		; Unit data store
		LDX	!DJNNO
		LDA	>MAPCNT
		AND	>BITCD0,X
		BNE	MAPWR0365	; Do you have a map ?
;					: No
;
		LDA	<WORKE
		AND	#00004H
		BNE	MAPWR0365	; Go to room ?
;					: No
;
		LDA	#00F00H		; Space area (yellow) set
		BRA	MAPWR0367
;
MAPWR0365	EQU	$
		LDA	<WORKC
MAPWR0367	EQU	$
		PLX
		STA	>MAPBUF+02H,X
; ---------
		STZ	<WORKC
		LDA	MAPUNIT+04H,Y	; ( Low left )
		AND	<WORK8
;;;		CMP	<WORKC
;;;		BEQ	MAPWR037
;;;		CLC
;;;		ADC	<WORKE
;
		PHA
		CMP	#00F00H
		BEQ	MAPWR037	; Space area (blue)?
;					: No
		CMP	#00B00H
		BEQ	MAPWR037	; Space area (yellow)?
;					: No
		LDA	<WORKE
		AND	#00002H
		BNE	MAPWR037	; Go to room ?
;					: No
		LDA	#00800H
		STA	<WORKC		
;
MAPWR037	EQU	$
		PLA
		CLC
		ADC	<WORKC
;
		PHX
		STA	<WORKC		; Unit data store
		LDX	!DJNNO
		LDA	>MAPCNT
		AND	>BITCD0,X
		BNE	MAPWR0375	; Do you have a map ?
;					: No
;
		LDA	<WORKE
		AND	#00002H
		BNE	MAPWR0375	; Go to room ?
;					: No
;
		LDA	#00F00H		; Space area (yellow) set
		BRA	MAPWR0377
;
MAPWR0375	EQU	$
		LDA	<WORKC
MAPWR0377	EQU	$
		PLX
		STA	>MAPBUF+040H,X
;
; ---------
		STZ	<WORKC
		LDA	MAPUNIT+06H,Y	; ( Low right )
		AND	<WORK8
;;;		CMP	<WORKC
;;;		BEQ	MAPWR038
;;;		CLC
;;;		ADC	<WORKE
;
		PHA
		CMP	#00F00H
		BEQ	MAPWR038	; Space area (blue)?
;					: No
		CMP	#00B00H
		BEQ	MAPWR038	; Space area (yellow)?
;					: No
		LDA	<WORKE
		AND	#00001H
		BNE	MAPWR038	; Go to room ?
;					: No
		LDA	#00800H
		STA	<WORKC		
;
MAPWR038	EQU	$
		PLA
		CLC
		ADC	<WORKC
;
		PHX
		STA	<WORKC		; Unit data store
		LDX	!DJNNO
		LDA	>MAPCNT
		AND	>BITCD0,X
		BNE	MAPWR0385	; Do you have a map ?
;					: No
;
		LDA	<WORKE
		AND	#00001H
		BNE	MAPWR0385	; Go to room ?
;					: No
;
		LDA	#00F00H		; Space area (yellow) set
		BRA	MAPWR0387
;
MAPWR0385	EQU	$
		LDA	<WORKC
MAPWR0387	EQU	$
		PLX
		STA	>MAPBUF+042H,X
;
; ---------
;
		INX
		INX
		INX
		INX
		INC	<WORK2		; Unit count inc
		LDA	<WORK2
		CMP	#00005H
		BEQ	MAPWR040	; 5 unit set ?
;					: No
		JMP	MAPWR010
;
MAPWR040	EQU	$
;
		RTS
;
		MEM8
		IDX8
;
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+		player position initial				    +
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
YADDDT		EQU	$
		WORD	0001FH,0007FH
;
XADDDT		EQU	$
		WORD	00090H
;
VLOOMNO0	EQU	$
		WORD	00001H,00002H,0005AH
;
VLOOMNO1	EQU	$
		WORD	00000H,00051H,0003AH
;
VLMIDX		EQU	$
		WORD	00004H
;
;
DMAPWT400	EQU	$
;
		PHB
		PHK
		PLB		; PBR => DBR
;
		IDX16
		REP	#00010000B		; index 16bit mode
;
		LDA	#000H
		XBA
		LDX	!DJNNO
		LDA	TOWERDT,X
		AND	#00FH
		CLC
		ADC	<FLORNO
		ASL	A
		TAY
;
		MEM16
		REP	#00100000B		; memory 16bit mode
;
		STZ	<WORK0
		STZ	<WORK2
;
;========= Loom nomber set !
;
		PHY
		LDY	VLMIDX
		LDA	<RMXYCT
DMPP000		EQU	$
		CMP	VLOOMNO0,Y
		BEQ	DMPP100		
;
		DEY
		DEY
		BPL	DMPP000
;
		BRA	DMPP900
;
DMPP100		EQU	$
		LDA	VLOOMNO1,Y
DMPP900		EQU	$
		STA	<WORKE
		PLY
;
		LDA	TWDTADD2,X
		STA	<WORK4
		LDA	TWDTADD1,Y
		TAY
;
DMPXY000	EQU	$
		LDA	(<WORK4),Y
		INY
		INY
		CMP	<WORKE
		BEQ	DMPXY100
;
		LDA	<WORK0
		CMP	#00040H
		BCC	DMPXY010
;
		STZ	<WORK0
		LDA	<WORK2
		CLC
		ADC	#00010H
		STA	<WORK2
		BRA	DMPXY000
;
DMPXY010	EQU	$
		CLC
		ADC	#00010H
		STA	<WORK0
		BRA	DMPXY000
;
DMPXY100	EQU	$
;
		LDA	<WORK0
		CLC
		ADC	XADDDT
		STA	!MPLKPX
;
; '91/ 4/10::		LDA	<PLXPS1
; '91/ 4/10::		AND	#00100H
; '91/ 4/10::		BEQ	DMPXY150		; W room ?
; '91/ 4/10::;						; no
; '91/ 4/10::		LDA	!MPLKPX			; E room !!!
; '91/ 4/10::		CLC
; '91/ 4/10::		ADC	#00008H
; '91/ 4/10::		STA	!MPLKPX
		LDA	<PLXPS1
		AND	#001E0H
		ASL	A
		ASL	A
		ASL	A
		XBA
		CMP	#00005H
		BMI	DMPXY150
;
		CMP	#0000CH
		BMI	DMPXY120
;
		LDA	#0000CH
DMPXY120	EQU	$
		CLC
		ADC	!MPLKPX
		SEC
		SBC	#00004H
		STA	!MPLKPX
DMPXY150	EQU	$
		LDY	!MAPWTA
;
		LDA	<WORK2
		STA	!TLRAM2
		CLC
		ADC	YADDDT,Y		; map up,down set !!!
		STA	!MPLKPY
;
; '91/ 4/10::		LDA	<PLYPS1
; '91/ 4/10::		AND	#00100H
; '91/ 4/10::		BEQ	DMPXY200		; N room ?
; '91/ 4/10::;						; no
; '91/ 4/10::		LDA	!MPLKPY			; S room !!!
; '91/ 4/10::		CLC
; '91/ 4/10::		ADC	#00008H
; '91/ 4/10::		STA	!MPLKPY
		LDA	<PLYPS1
		AND	#001E0H
		ASL	A
		ASL	A
		ASL	A
		XBA
		CMP	#00005H
		BMI	DMPXY200
;
		CMP	#0000CH
		BMI	DMPXY170
;
		LDA	#0000CH
DMPXY170	EQU	$
		CLC
		ADC	!MPLKPY
		SEC
		SBC	#00004H
		STA	!MPLKPY
DMPXY200	EQU	$
;
		MEM8
		IDX8
		SEP	#00110000B		; memory,index 8bit mode
;
		INC	!MAPDMD
		STZ	<BLKFLG		; blanking off
		STZ	!MAPCFG
;
		PLB		; DBR reset !!
;
		RTL
;
;
;
;
;
; ------------------------------------------------------------------
;
;
;---------------------------------------; fade in
MPDP400		EQU	$
		INC	<BLKFLG
		LDA	<BLKFLG
		CMP	#00FH
		BNE	MPDP440		; fade in end ?
;					; yes
		INC	!MAPDMD
MPDP440		EQU	$
		RTL
;
;
; ------------------------------------------------------------------
;
;
;---------------------------------------; play
;
MPDP600		EQU	$
;;;		JSR	TOWERST		; tower set
;
; '91/ 4/ 2 ::		LDA	!MAPCFG
; '91/ 4/ 2 ::		ASL	A
; '91/ 4/ 2 ::		TAX
; '91/ 4/ 2 ::		JMP	(MPPLTBL,X)
; '91/ 4/ 2 ::;
; '91/ 4/ 2 ::;
; '91/ 4/ 2 ::MPPLTBL		EQU	$
; '91/ 4/ 2 ::		WORD	DMAPPL000
; '91/ 4/ 2 ::		WORD	DMAPPL100
; '91/ 4/ 2 ::;
; '91/ 4/ 2 ::;
; '91/ 4/ 2 ::DMAPPL000	EQU	$
; '91/ 4/ 2 ::		INC	!MAPCFG
; '91/ 4/ 2 ::;
; '91/ 4/ 2 ::		RTL
		JSL	>DMAPPL100
;
		JMP	DMAPPL200
;
;
DMAPPL100	EQU	$
;
		PHB
		PHK
		PLB			; PBR=>DBR
;
		LDA	<KEYA1L
		AND	#01000000B
;;		BEQ	MPDP620		; [X] key on ?
		BNE	NOTO
;
		JSL	>MPDP620		; [X] key on ?

;;		LDA	!MAPLEV
;;		BNE	NLL		; move end ?
;;;					; yes ! bext key check & move !
;;		JSL	>MPDP620	; 1	
;;		JSL	>MPDP620 	; 2		
NLL		EQU	$
		PLB
		RTL
;
NOTO		EQU	$
		INC	!MAPDMD
		INC	!MAPDMD
		STZ	!MAPCFG
;
		PLB			; DBR reset
;
		RTL
;
;
;************************************************************************
;*		MAP SCROLL						*
;************************************************************************
MAPOSDT		EQU	$
		WORD	00060H,0FFA0H
;
;
MPDP620		EQU	$
		JSL	>MPDP623
;
		LDA	!MAPLEV
		BEQ	MPDP621		; Now scroll ?
;;		BEQ	MPDP623		; Now scroll ?
;					: Yes
		JMP	SCRCTAD
;
MPDP621		EQU	$
		RTL
;==== Key check ===
MPDP623		EQU	$
;
; ----- < NEW > ----------------------------------------------------
;
		MEM16
		IDX16
		REP	#00110000B	; Memory,index 16bit mode
;
		LDX	!DJNNO
		LDA	TOWERDT,X
		AND	#000F0H
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		STA	<WORK0		; High step set
;
		LDA	TOWERDT,X
		AND	#0000FH
		CLC
		ADC	<WORK0		; High + Low step
		CMP	#00003H
		BMI	MPDP624		; All step < 3 ?
;					: No
		MEM8
		IDX8
		SEP	#00110000B	; Memory,index 8bit mode
;
;
; ------------------------------------------------------------------
;
		LDA	MAPLEV
		BNE	MPDP624
;
		LDA	<KEYA1
		AND	#00001100B
		BNE	MPDP625		; Up, down key on ?
;					: No
MPDP624		EQU	$
		JMP	MPDP699
;
MPDP625		EQU	$
		STA	<WORKA		; Key data store
;
		STZ	!MAPBGP+001H	; Map point set (high clear)
;
		AND	#00001000B
		BEQ	MPDP630		; Up key (scroll down) ?
;					: Yes
		MEM16
		IDX16
		REP	#00110000B	; Memory,index 16bit mode
;
 		LDX	!DJNNO
		LDA	TOWERDT,X
		AND	#000F0H
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		DEC	A
		CMP	!MAPBGP
		BNE	MPDP628		; Top step ?
;					: Yes
		JMP	MPDP699
;
MPDP628		EQU	$
		INC	!MAPBGP		; Map point inc
;
		LDA	<WORK6
		SEC
		SBC	#00300H
		AND	#00FFFH
		STA	<WORK6		; MAPBUF add data set
;
		BRA	MPDP635
;
;
MPDP630		EQU	$		; Down key (scroll up)
		MEM16
		IDX16
		REP	#00110000B	; Memory,index 16bit mode
;
		LDX	!DJNNO
		LDA	TOWERDT,X
		AND	#0000FH
		EOR	#000FFH
		INC	A
		INC	A
		AND	#000FFH
		CMP	!MAPBGP
		BEQ	MPDP699		; Bottom step ?
;					: No
;
		DEC	!MAPBGP		; Map point dec
		DEC	!MAPBGP
;
		LDA	<WORK6
		CLC
		ADC	#00600H
		AND	#00FFFH
		STA	<WORK6		; MAPBUF add data set
;
;
; ----- < COLOR DATA SET > -----------------------------------------
;
MPDP635		EQU	$
		MEM8
		SEP	#00100000B	; Memory 8bit mode
;
		LDA	!MAPBGP
		CMP	<FLORNO
		BNE	MPDP638		; Link in floor ?
;					: Yes
;
		MEM16
		REP	#00100000B	; Memory 16bit mode
;
;;;		LDA	#0EFFFH		; Floor color set (yellow)
;;;		STA	<WORK8
;
;;;		MEM8
;;;		SEP	#00100000B	; Memory 8bit mode
		BRA	MPDP640
;
MPDP638		EQU	$
		BMI	MPDP639		; Higher ?
;					: Yes
;
		MEM16
		REP	#00100000B	; Memory 16bit mode
;
;;;		LDA	#0EBFFH		; Floor color set (red)
;;;		STA	<WORK8
;
;;;		MEM8
;;;		SEP	#00100000B	; Memory 8bit mode
		BRA	MPDP640
;
MPDP639		EQU	$		; Lower
		MEM16
		REP	#00100000B	; Memory 16bit mode
;
;;;		LDA	#0F3FFH		; Floor color set (blue)
;;;		STA	<WORK8
;
;;;		MEM8
;;;		SEP	#00100000B	; Memory 8bit mode
;
MPDP640		EQU	$
		LDA	!MAPBGP
		AND	#00080H
		BNE	COLOBLUE	; Chijyo ?
;					: Yes	
		LDA	#0EBFFH
		STA	<WORK8		; Floor color set (new yellow)
		BRA	COLORED
;
COLOBLUE	EQU	$
		LDA	#0EFFFH
		STA	<WORK8		; Floor color set (new blue)
;
COLORED		EQU	$
		MEM8
		SEP	#00100000B	; Memory 8bit mode
;
		JSR	MOJISET		; Moji write
		JSR	WAKUSET		; Waku write	 
		JSR	MAPUNST		; Map write
;
		MEM8
		SEP	#00100000B	; Memory 8bit mode
;
		INC	!MAPLEV		; Now scroll flag inc
;
;
; ----- < SCROLL COUNT SET > ---------------------------------------
;
		LDA	<WORKA
		AND	#008H
		LSR	A
		LSR	A
		TAX
;
		MEM16
		IDX16
		REP	#00110000B	; Memory,index 16bit mode
;
		LDA	<SCCV2
		CLC
		ADC	MAPOSDT,X
		STA	!MAPSMK		; Scroll count set !!
;
;
; ----- < DATA RESET AREA > ----------------------------------------
;
		LDA	<WORKA
		AND	#00008H
		BNE	MPDP650		; Up key on ?
;					: No
		LDA	<WORK6
		SEC
		SBC	#00300H
		AND	#00FFFH
		STA	<WORK6		; MAPBUF add data reset
;
		INC	!MAPBGP		; Map point reset
;
; ------------------------------------------------------------------
;
MPDP650		EQU	$
		MEM8
		SEP	#00100000B	; Memory,index 8bit mode
;
		LDA     #bgw8		; BG write set
		STA     <BGWTFG
;;		LDA	#022H
;;		STA     !NXBWFG
;
MPDP699		EQU	$
		BRA	SCRC020
;
;
;************************************************************************
;*		SCROLL COUNT ADD					*
;************************************************************************
MAPSCDT		EQU	$
		WORD	00004H,0FFFCH
OBJSCDT		EQU	$
		WORD	0FFFCH,00004H
;
;
SCRCTAD		EQU	$
		MEM16
		IDX16
		REP	#00110000B	; Memory,index 16bit mode
;
		LDA	<WORKA
		AND	#00008H
		LSR	A
		LSR	A
		TAX
;
		LDA	!MPLKPY
		CLC
		ADC	OBJSCDT,X
		STA	!MPLKPY		; OBJ y pos add !!
;
		LDA	<SCCV2
;;		CMP	!MAPSMK
;;		BEQ	SCRC010		; Scroll count ok ?
;					; No
		CLC
		ADC	MAPSCDT,X
		STA	<SCCV2		; Scroll count set !!
;
		CMP	!MAPSMK
		BNE	SCRC020
;;		BEQ	SCRC010		; Scroll count ok ?
;;		BRA	SCRC020
;
SCRC010		EQU	$
		MEM8
		SEP	#00100000B	; Memory 8bit mode
		STZ	!MAPLEV		; Now scroll flag clear
;
;;                JSL	>MPDP620		EQU	$
;;		JMP	SCRCTAD
;;		BRA	SCRC100
;
SCRC020		EQU	$
;
		MEM8
		IDX8
		SEP	#00110000B	; Memory,Index 8bit mode
;
		RTL
;
;
;====== Player position =======
;
DMAPPL200	EQU	$
;
		PHB
		PHK
		PLB			; PBR=>DBR
;
		IDX16
		REP	#00010000B	; index 16bit mode
;
		LDX	!DJNNO
		LDA	TOWERDT,X
		AND	#00FH
		STA	<WORK2
		CLC
		ADC	<FLORNO
		STA	<WORK1
		STA	<WORK3
;
		IDX8
		SEP	#00010000B	; index 8bit mode
;
		STZ	<WORK0
		STZ	<WORKE
		JSR	PLFLDP
;
		INC	<WORK0
SCRC100		EQU	$
		JSR	DMPWAKUST
;
		INC	<WORKE
		LDA	<WORK0
		CMP	#002H*12+1
		BNE	SCRC100
;
		JSR	DMPOAMSET
;
		INC	<WORK0
		JSR	FLNOOMST
;
		PLB			; DBR reset
;
		RTL
;
;
; ------------------------------------------------------------------
;
;
;************************************************************************
;*		OAM SET ( player floor position )			*
;************************************************************************
;
FLDPX		EQU	$
		BYTE	01CH
;
PLFLDP		EQU	$
;
		IDX16
		REP	#00010000B	; index 16bit mode
;
		LDA	#004H
		SEC
		SBC	<WORK2
		BMI	FLDP100
;
		CLC
		ADC	<WORK3
		STA	<WORK3
		LDA	<WORK2
		BNE	FLDP100
;
		LDA	TOWERDT,X
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		SEC
		SBC	#004H
		BMI	FLDP100
;
		SEC
		SBC	<WORK3
		EOR	#0FFH
		INC	A
		STA	<WORK3
FLDP100		EQU	$
;
		IDX8
		SEP	#00010000B	; index 8bit mode
;
		LDX	<WORK0
;
		LDA	#00000000B
		STA	!OAMSB,X		; oamsub set
;
		TXA
		ASL	A
		ASL	A
		TAX
;
		LDA	FLDPX
		STA	!OAM+000H,X		; X position set
;
		LDY	<WORK3
		LDA	FLNOYADD,Y
		STA	!OAM+001H,X		; Y position set
;
		LDA	<FCNT
		AND	#00001100B
		LSR	A
		LSR	A
		CLC
		ADC	#004H
		TAY
		LDA	DMAPCHNO,Y
		STA	!OAM+002H,X		; char No. set
;
		LDA	DMOMATOR,Y
		STA	!OAM+003H,X		; atoribuut set
;
		RTS
;
;
;************************************************************************
;*		OAM SET ( player position )				*
;************************************************************************
;
DMAPCHNO	EQU	$
		BYTE	034H,035H,036H,034H
		BYTE	031H,032H,033H,032H
;
DMOMATOR	EQU	$
		BYTE	00111011B,00111001B,00111101B,00111001B
		BYTE	00111011B,00111011B,00111011B,00111011B
;
DMPOAMSET	EQU	$
		LDX	<WORK0
;
		LDA	#00000000B
		STA	!OAMSB,X		; oamsub set
;
		TXA
		ASL	A
		ASL	A
		TAX
;
		LDA	!MPLKPX
		STA	!OAM+000H,X		; X position set
;
; '91/ 4/ 2 ::		STZ	<WORKF
; '91/ 4/ 2 ::		LDA	!MPLKPY
; '91/ 4/ 2 ::		STA	<WORKC
; '91/ 4/ 2 ::		LDA	!MPLKPY+1
; '91/ 4/ 2 ::		STA	<WORKD
; '91/ 4/ 2 ::;
; '91/ 4/ 2 ::		LDA	<WORK1
; '91/ 4/ 2 ::		CMP	<WORK0
; '91/ 4/ 2 ::		BEQ	DMPOMST100		; floor No = ?
; '91/ 4/ 2 ::;						; no !
; '91/ 4/ 2 ::		BPL	DMPOMST000		; floor No < ?
; '91/ 4/ 2 ::;						; no !
; '91/ 4/ 2 ::;						; floor No > !!!
; '91/ 4/ 2 ::		LDA	<WORK0
; '91/ 4/ 2 ::		SEC
; '91/ 4/ 2 ::		SBC	<WORK1
; '91/ 4/ 2 ::		STA	<WORK2
; '91/ 4/ 2 ::		LDA	#0A0H
; '91/ 4/ 2 ::		STA	<WORK4
; '91/ 4/ 2 ::		LDA	#0FFH
; '91/ 4/ 2 ::		STA	<WORK5
; '91/ 4/ 2 ::		BRA	DMPOMST050
; '91/ 4/ 2 ::;
; '91/ 4/ 2 ::DMPOMST000	EQU	$
; '91/ 4/ 2 ::		SEC
; '91/ 4/ 2 ::		SBC	<WORK0
; '91/ 4/ 2 ::		STA	<WORK2
; '91/ 4/ 2 ::		LDA	#060H
; '91/ 4/ 2 ::		STA	<WORK4
; '91/ 4/ 2 ::		STZ	<WORK5
; '91/ 4/ 2 ::DMPOMST050	EQU	$
; '91/ 4/ 2 ::		STZ	<WORK3
; '91/ 4/ 2 ::		JSR	DMPLYPOS
; '91/ 4/ 2 ::		INC	<WORKF
; '91/ 4/ 2 ::		INC	<WORKF
; '91/ 4/ 2 ::		INC	<WORKF
; '91/ 4/ 2 ::		INC	<WORKF
;
DMPOMST100	EQU	$
; '91/ 4/ 2 ::		LDA	<WORKD
		LDA	!MPLKPY+1
		BEQ	DMOMST000
;
		LDA	#0F0H
		BRA	DMOMST010
;
DMOMST000	EQU	$
; '91/ 4/ 2 ::		LDA	<WORKC
		LDA	!MPLKPY
DMOMST010	EQU	$
		STA	!OAM+001H,X		; Y position set
;
		LDA	<FCNT
		AND	#00001100B
		LSR	A
		LSR	A
; '91/ 4/ 2 ::		CLC
; '91/ 4/ 2 ::		ADC	<WORKF
		TAY
DMOMST020	EQU	$
		LDA	DMAPCHNO,Y
		STA	!OAM+002H,X		; char No. set
		LDA	DMOMATOR,Y
		STA	!OAM+003H,X		; atoribuut set
;
		RTS
;
;
; '91/ 4/ 2 ::DMPLYPOS	EQU	$
; '91/ 4/ 2 ::;
; '91/ 4/ 2 ::		MEM16
; '91/ 4/ 2 ::		REP	#00100000B		; memory 16bit mode
; '91/ 4/ 2 ::;
; '91/ 4/ 2 ::DMPLY000	EQU	$
; '91/ 4/ 2 ::		LDA	<WORKC
; '91/ 4/ 2 ::		CLC
; '91/ 4/ 2 ::		ADC	<WORK4
; '91/ 4/ 2 ::		STA	<WORKC
; '91/ 4/ 2 ::;
; '91/ 4/ 2 ::		DEC	<WORK2
; '91/ 4/ 2 ::		BNE	DMPLY000
; '91/ 4/ 2 ::;
; '91/ 4/ 2 ::		MEM8
; '91/ 4/ 2 ::		SEP	#00100000B		; memory 8bit mode
; '91/ 4/ 2 ::;
; '91/ 4/ 2 ::		RTS
;
;
;************************************************************************
;*		OAM SET ( waku )					*
;************************************************************************
;
WAKUADDX	EQU	$
		BYTE	0F8H,000H,008H,010H,0F8H,010H,0F8H,010H
		BYTE	0F8H,000H,008H,010H
;
WAKUADDY	EQU	$
		BYTE	0F8H,0F8H,0F8H,0F8H,000H,000H,008H,008H
		BYTE	010H,010H,010H,010H
;
WCHNO		EQU	$
; '91/ 6/ 5 :: WED:		BYTE	012H,006H,030H,012H,012H,006H,006H
		BYTE	087H,006H,006H,088H,08AH,012H,08AH,012H
		BYTE	08BH,08CH,08CH,089H
;
WATORI		EQU	$
		BYTE	00110001B,10110001B,10110001B,00110001B
		BYTE	00110001B,01110001B,00110001B,01110001B
		BYTE	00110001B,00110001B,00110001B,00110001B
;
WCOL		EQU	$
		BYTE	00000100B,00000110B,00001000B,00000110B
;
DMPWADD		EQU	$
		WORD	00000H,00060H,000C0H,00120H
		WORD	00180H,001E0H,00240H
;
DMPWAKUST	EQU	$
; '91/ 6/ 5 ::WED:::		IDX16
; '91/ 6/ 5 ::WED:::		REP	#00010000B		; index 16bit mode !!
; '91/ 6/ 5 ::WED:::;
; '91/ 6/ 5 ::WED:::		LDA	#000H
; '91/ 6/ 5 ::WED:::		XBA
; '91/ 6/ 5 ::WED:::		LDY	#0000BH
		LDY	#00BH
DMPW000		EQU	$
		LDA	<WORK0
		TAX
		LDA	#00000000B
		STA	!OAMSB,X		; oamsub set !!
;
		TXA
		ASL	A
		ASL	A
		TAX
;
		LDA	!MPLKPX
		AND	#0F0H
		CLC
		ADC	WAKUADDX,Y
		STA	!OAM+000H,X		; x position set !!
;
; '91/ 5/ 8:WED:::		LDA	#0F0H
; '91/ 5/ 8:WED:::		STA	<WORKF
; '91/ 5/ 8:WED:::		PHY
; '91/ 5/ 8:WED:::		LDA	<WORKE
; '91/ 5/ 8:WED:::		SEC
; '91/ 5/ 8:WED:::		SBC	<WORK1
; '91/ 5/ 8:WED:::		BPL	DMPW005
; '91/ 5/ 8:WED:::;
; '91/ 5/ 8:WED:::		EOR	#0FFH
; '91/ 5/ 8:WED:::		INC	A
; '91/ 5/ 8:WED:::		ASL	A
; '91/ 5/ 8:WED:::		TAY
; '91/ 5/ 8:WED:::;
; '91/ 5/ 8:WED:::		MEM16
; '91/ 5/ 8:WED:::		REP	#00100000B		; memory 16bit mode
; '91/ 5/ 8:WED:::;
; '91/ 5/ 8:WED:::		LDA	!MPLKPY
; '91/ 5/ 8:WED:::		CLC
; '91/ 5/ 8:WED:::		ADC	DMPWADD,Y
; '91/ 5/ 8:WED:::		BRA	DMPW008
; '91/ 5/ 8:WED:::;
; '91/ 5/ 8:WED:::DMPW005		EQU	$
; '91/ 5/ 8:WED:::		ASL	A
; '91/ 5/ 8:WED:::		TAY
; '91/ 5/ 8:WED:::;
; '91/ 5/ 8:WED:::		MEM16
; '91/ 5/ 8:WED:::		REP	#00100000B		; memory 16bit mode
; '91/ 5/ 8:WED:::;
; '91/ 5/ 8:WED:::		LDA	!MPLKPY
; '91/ 5/ 8:WED:::		SEC
; '91/ 5/ 8:WED:::		SBC	DMPWADD,Y
; '91/ 5/ 8:WED:::DMPW008		EQU	$
; '91/ 5/ 8:WED:::;
; '91/ 5/ 8:WED:::		MEM8
; '91/ 5/ 8:WED:::		SEP	#00100000B		; memory 8bit mode
; '91/ 5/ 8:WED:::;
; '91/ 5/ 8:WED:::		PLY
; '91/ 5/ 8:WED:::		XBA
; '91/ 5/ 8:WED:::		CMP	#000H
; '91/ 5/ 8:WED:::		BNE	DMPW010
; '91/ 5/ 8:WED:::;
; '91/ 5/ 8:WED:::		XBA
; '91/ 5/ 8:WED:::		INC	A
; '91/ 5/ 8:WED:::		AND	#0F0H
; '91/ 5/ 8:WED:::		CLC
; '91/ 5/ 8:WED:::		ADC	WAKUADDY,Y
; '91/ 5/ 8:WED:::		STA	<WORKF
; '91/ 5/ 8:WED:::DMPW010		EQU	$
; '91/ 5/ 8:WED:::		LDA	<WORKF
		PHY
		LDA	<WORKE
		ASL	A
		TAY
		LDA	!TLRAM2
		CLC
		ADC	YADDDT,Y
		PLY
		CLC
		ADC	WAKUADDY,Y
;
; '91/ 5/ 8:WED:::		DEC	A
		STA	!OAM+001H,X		; y position set !!
;
		LDA	WCHNO,Y
		STA	!OAM+002H,X		; char No. set !!
;
		LDA	WATORI,Y
		STA	<WORKC
;
		PHY
;;		LDY	#000H
		LDA	<FCNT
		LSR	A
		AND	#00000011B
		TAY
;;		BCS	DMPW020
;;;
;;		INY
;;		LDA	<FCNT
;;		AND	#00001000B
;;		BCC	DMPW020
;;;
;;		INY
;;DMPW020		EQU	$
		LDA	<WORKC
		ORA	WCOL,Y
		STA	!OAM+003H,X		; atoribuut set !!
		PLY
;
		INC	<WORK0
		DEY
		BPL	DMPW000
;
; '91/ 6/ 5 ::WED:::		IDX8
; '91/ 6/ 5 ::WED:::		SEP	#00010000B		; index 8bit mode !!
; '91/ 6/ 5 ::WED:::;
		RTS
;
;
;************************************************************************
;*		OAM SET ( floor no )					*
;************************************************************************
;
FLNOYADD	EQU	$
		BYTE	0BBH,0ABH,09BH,08BH,07BH,06BH,05BH,04BH
;
FLNCHNO		EQU	$
		BYTE	01EH,01FH,020H,021H,022H,023H,024H,025H
;
FNATORI		EQU	$
		BYTE	00111101B,00111011B,00111001B
;
FLNOOMST	EQU	$
		LDA	<WORK0
		INC	A
		INC	A
		STA	<WORK5
		LDA	!MAPBGP
		DEC	A
		STA	<WORK3
		LDA	#001H
		STA	<WORK2
FNOM000		EQU	$
		LDX	<WORK5
		LDA	#00000000B
		STA	!OAMSB+000H,X
		STA	!OAMSB+001H,X
;
		TXA
		ASL	A
		ASL	A
		TAX
;
		LDA	#01CH
		STA	!OAM+002H,X		; char No. initial set !
		LDA	#01DH
		STA	!OAM+006H,X		; char No. initial set !
;
		LDA	#030H
		STA	!OAM+000H,X		; xpos set !!!
		CLC
		ADC	#008H
		STA	!OAM+004H,X		; xpos set !!!
;
		LDA	<WORK3
; '91/ 4/ 2 ::		PHA
		BPL	FNOM100			; chijyou ?
;						; no !
		EOR	#0FFH
		TAY
		LDA	FLNCHNO,Y
		STA	!OAM+006H,X		; chra No. set !!!
		LDY	#000H
		BRA	FNOM200
;
FNOM100		EQU	$
		TAY
		LDA	FLNCHNO,Y
		STA	!OAM+002H,X		; chra No. set !!!
		LDY	#001H
FNOM200		EQU	$
; '91/ 4/ 2 ::		LDY	#000H
; '91/ 4/ 2 ::		PLA
; '91/ 4/ 2 ::		CMP	<FLORNO
; '91/ 4/ 2 ::		BEQ	FNOM250
; '91/ 4/ 2 ::;
; '91/ 4/ 2 ::		BMI	FNOM280
; '91/ 4/ 2 ::;
; '91/ 4/ 2 ::		INY
; '91/ 4/ 2 ::FNOM250		EQU	$
; '91/ 4/ 2 ::		INY
; '91/ 4/ 2 ::FNOM280		EQU	$
		LDA	FNATORI,Y
		STA	!OAM+003H,X		; atoribuut set !!!
		STA	!OAM+007H,X		; atoribuut set !!!
		PHX
		LDX	<WORK2
		STA	<WORKE,X
		PLX
;
		PHX
;
		IDX16
		REP	#00010000B	; index 16bit mode
;
		LDX	!DJNNO
		LDA	TOWERDT,X
		AND	#00FH
		STA	<WORK1
		CLC
		ADC	<WORK3
		STA	<WORK0
;
		LDA	#004H
		SEC
		SBC	<WORK1
		BMI	FNOM500
;
		CLC
		ADC	<WORK0
		STA	<WORK0
		LDA	<WORK1
		BNE	FNOM500
;
		LDA	TOWERDT,X
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		SEC
		SBC	#004H
		BMI	FNOM500
;
		SEC
		SBC	<WORK0
		EOR	#0FFH
		INC	A
		STA	<WORK0
FNOM500		EQU	$
;
		IDX8
		SEP	#00010000B	; index 8bit mode
;
		PLX
;
		LDY	<WORK0
		LDA	FLNOYADD,Y
		STA	!OAM+001H,X             ; ypos set !!!
		STA	!OAM+005H,X             ; ypos set !!!
;
		DEC	<WORK5
		DEC	<WORK5
		INC	<WORK3
		DEC	<WORK2
		BMI	FNOM300
;
		BRL	FNOM000
;
FNOM300		EQU	$
		LDA	<FCNT
		AND	#004H
		BNE	BLOBJST
;
		RTS
;
;
BLOMADD		EQU	$
;;		BYTE	00CH,014H
		HEX	00,08
;
BLCHNO		EQU	$
		BYTE	037H,038H,038H,037H
;
BLOBJST		EQU	$
		LDY	<WORK0
		LDA	FLNOYADD,Y
		SEC
		SBC	#004H
		STA	<WORK2
		CLC
		ADC	#010H
		STA	<WORK3
;
		LDA	#001H
		STA	<WORKD
BLOMST000	EQU	$
		LDA	#028H
		STA	<WORK1
		LDA	#003H
		STA	<WORKC
		LDX	<WORKD
		LDA	BLOMADD,X
		TAY
BLOMST050	EQU	$
		LDA	#000H
		STA	!OAMSB+040H,Y
		STA	!OAMSB+044H,Y
		PHY
		TYA
		ASL	A
		ASL	A
		TAY
		LDA	<WORK1
		STA	!OAM+100H,Y		; xpos set !
		STA	!OAM+110H,Y		; xpos set !
;
		LDA	<WORK2,X
		STA	!OAM+101H,Y		; ypos set !
		CLC
		ADC	#008H
		STA	!OAM+111H,Y		; ypos set !
;
		PHX
		LDX	<WORKC
		LDA	BLCHNO,X
		STA	!OAM+102H,Y		; char No. set !
		STA	!OAM+112H,Y		; char No. set !
		PLX
;
		PHY
		LDA	<WORKE,X
		LDY	<WORKC
		BNE	BLOMST080
;
		ORA	#01000000B
BLOMST080	EQU	$
		PLY	
		STA	!OAM+103H,Y		; atoribuut set !
		ORA	#10000000B
		STA	!OAM+113H,Y		; atoribuut set !
;
		PLY
		INY
		LDA	<WORK1
		CLC
		ADC	#008H
		STA	<WORK1
		DEC	<WORKC
		BPL	BLOMST050
;
		DEC	<WORKD
		BPL	BLOMST000
;
		RTS
;
;
;*************	OAM SET END ************
;
;
;---------------------------------------; scroll
MPDP700		EQU	$
		MEM16
		IDX16
		REP	#00110000B
;
		LDA	MAPSMK
		CLC
		ADC     <SCCV2
		STA     <SCCV2		; scroll move
;
		LDA	MAPSMK		; OBJ Y SET( LINK POSITION )
		EOR	#0FFFFH
		INC	A
		CLC
		ADC	MPLKPY
		STA	MPLKPY
;
		MEM8
		IDX8
		SEP	#00110000B
;
;;;		JSR	MAPLKP		;OBJ SET
;
		DEC	MAPSCT
		BNE	MPDP710		;scroll end?
;					;y
		DEC	!MAPDMD		;jsrsub -1
;
MPDP710		EQU	$
		RTL
;
;
;
;---------------------------------------; fade out
MPDP900		EQU	$
		DEC	<BLKFLG
		BNE	MPDP980		; fade out ?
;					; yes
		LDA	#10000000B
		STA	2100H
		STA	<BLKFLG		; blanking on
		INC	!MAPDMD
;
		MEM16
		IDX16
		REP	#00110000B	; memory,index 16bit mode
;
		LDA	>BKWD2130
		STA	<WD2130
;
		LDA	>BKSCH1
		STA	<SCCH1
		LDA	>BKSCH2
		STA	<SCCH2
		LDA	>BKSCV1
		STA	<SCCV1
		LDA	>BKSCV2
		STA	<SCCV2		; SCCH,V pull
		STZ	<SCCH3
		STZ	<SCCV3
;
		LDA	>BKYRXD
		STA	!YUREXD
		LDA	>BKYRYD
		STA	!YUREYD
;
		MEM8
		IDX8
		SEP	#00110000B	; memory,index 8bit mode
;
		INC	<CGVMAF
MPDP980		EQU	$
		RTL
;
;
;
;---------------------------------------; game BG. display
MPDP800		EQU	$
		LDA	<WD420C
		PHA			; (A) push
		STZ	420CH
		STZ	<WD420C
;
		JSL	>VRAMCL		; VCL
;
		LDA	>BKDPMN
		STA	<DPMAIN
		LDA	>BKDPSB
		STA	>DPSUB		; DPMAIN,DPSUB pull
;
;// 03.01.31 //		LDA	>BKCHBK
;// 03.01.31 //		STA	!CHARBK
		LDA	>BKCHNO
		STA	!CHIKNO
		LDA	>BKROJC
		STA	!ROBJCPT
		LDA	>BKRBGC
		STA	!RBGCPT
		JSL	>CHSCHNG	; BG. character reset
		STZ	!CGSTPT+1	; (CGRAM) set
		STZ	!BG3BGC
;
;// 03.05.20 //		LDA	<LNMODE
;// 03.05.20 //		CMP	#SWMD
;// 03.05.20 //		BNE	MPDP820		; player swiming ?
;// 03.05.20 //;					; yes
;// 03.05.20 //		JSL	>PWTRCGS0
;// 03.05.20 //MPDP820		EQU	$
		JSR	MTRON0		; mater BG3. write
;// 03.06.05 //		JSR	ITEMS00		; item set
;
		STZ	!SCRLFG
		STZ	!WBFPNT
MPDP840		EQU	$
		JSL	>WBUFS1
		JSL	>DJBGWT		; init. BG.1 write
;
		JSL	>WBUFS0
		JSL	>DJBGWT		; init. BG.2 write
;
		LDA	!WBFPNT
		CMP	#010H
		BNE	MPDP840		; end ?
;					; yes
		STZ	<BGWTFG
		STZ	<JRSBPT
;
		PLA			; (A) pull
		STA	<WD420C
;
;// 03.03.15 //		JSL	>MTRDSP		; mater display
;// 03.03.15 //;
;// 03.03.15 //		LDX	#003H
;// 03.03.15 //		LDA	>DARKFG
;// 03.03.15 //		BEQ	MPDP860		; now dark ?
;// 03.03.15 //;					; yes
;// 03.03.15 //		LDA	!LGTWST
;// 03.03.15 //		CMP	#003H
;// 03.03.15 //		BCS	MPDP860		; light-wipe on ?
;// 03.03.15 //;					; yes
;// 03.03.15 //		TAX
;// 03.03.15 //MPDP860		EQU	$
;// 03.03.15 //		LDA	>CGEDP0,X
;// 03.03.15 //		STA	>CCNGED
;// 03.03.15 //		LDA	#01EH
;// 03.03.15 //		STA	>CCNGCT
;// 03.03.15 //		LDA	#002H
;// 03.03.15 //		STA	>CCNGFG
;
		MEM16
		REP	#00100000B	; memory 16bit mode
;
		LDX	#000H
MPDP870		EQU	$
		LDA	>CGRAM+000H,X
		STA	>CGWORK+000H,X
		LDA	>CGRAM+040H,X
		STA	>CGWORK+040H,X
		LDA	>CGRAM+080H,X
		STA	>CGWORK+080H,X
		LDA	>CGRAM+0C0H,X
		STA	>CGWORK+0C0H,X
		LDA	>CGRAM+100H,X
		STA	>CGWORK+100H,X
		LDA	>CGRAM+140H,X
		STA	>CGWORK+140H,X
		LDA	>CGRAM+180H,X
		STA	>CGWORK+180H,X
		LDA	>CGRAM+1C0H,X
		STA	>CGWORK+1C0H,X
		INX
		INX
		CPX	#040H
		BNE	MPDP870		;
;					;
		MEM8
		SEP	#00100000B	; memory 8bit mode
;
		LDA	>DKRMCG
		TSB	<WD2132R
		TSB	<WD2132G
		TSB	<WD2132B	; R.G.B. color set
;
;
		INC	<CGVMAF
		INC	!MAPDMD
		STZ	<BLKFLG
		STZ	!GMAPDF
		RTL
;
;
;---------------------------------------; fade in
MPDPC00		EQU	$
		JSL	>LGTWPMV	; light wipe
;
		INC	<BLKFLG
		LDA	<BLKFLG
		CMP	#00FH
		BNE	MPDPC40		; fade in end ?
;					; yes
		LDA	!NXSLMD
		STA	<SLMODE
		STZ	<GAMEMD
		STZ	!MAPDMD
		STZ	<JRSBPT
		LDA	#00FH
		STA	<BLKFLG		; blanking off
MPDPC40		EQU	$
		RTL
;
;
;
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;	map data
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;
MAPWAKU		EQU	$
		BYTE	060H,042H,000H,001H
		WORD	     02100H
		BYTE	060H,043H,040H,00EH
		WORD	     02101H
		BYTE	060H,04BH,000H,001H
		WORD	     06100H
		BYTE	060H,062H,0C0H,02EH
		WORD	     02110H
		BYTE	060H,06BH,0C0H,02EH
		WORD	     06110H
		BYTE	063H,062H,000H,001H
		WORD	     0A100H
		BYTE	063H,063H,040H,00EH
		WORD	     0A101H
		BYTE	063H,06BH,000H,001H
		WORD	     0E100H
;
		BYTE	060H,084H,000H,00BH
		WORD	     02102H,02103H,02104H,02105H,02106H
		WORD	     02107H
		BYTE	060H,0A4H,000H,00BH
		WORD	     02112H,02113H,02114H,02115H,02116H
		WORD	     02117H
;
		BYTE	060H,04EH,000H,001H
		WORD	     02100H
		BYTE	060H,04FH,040H,01AH
		WORD	     02101H
		BYTE	060H,05DH,000H,001H
		WORD	     06100H
		BYTE	060H,06EH,0C0H,02EH
		WORD	     02110H
		BYTE	060H,07DH,0C0H,02EH
		WORD	     06110H
		BYTE	063H,06EH,000H,001H
		WORD	     0A100H
		BYTE	063H,06FH,040H,01AH
		WORD	     0A101H
		BYTE	063H,07DH,000H,001H
		WORD	     0E100H
;
		BYTE	060H,000H,040H,07EH
		WORD	     02111H
		BYTE	063H,080H,041H,03EH
		WORD	     02111H
		BYTE	060H,000H,0C0H,03EH
		WORD	     02111H
		BYTE	060H,001H,0C0H,03EH
		WORD	     02111H
		BYTE	060H,00CH,0C0H,03EH
		WORD	     02111H
		BYTE	060H,00DH,0C0H,03EH
		WORD	     02111H
		BYTE	060H,01EH,0C0H,03EH
		WORD	     02111H
		BYTE	060H,01FH,0C0H,03EH
		WORD	     02111H
;
;------------ waku tensen --------------------
;
		BYTE	010H,091H,0C0H,012H
		WORD	     00B12H
		BYTE	010H,092H,000H,013H
		WORD	     00B06H,00B30H,00B06H,00B30H,00B06H,00B30H
		WORD	     00B06H,00B30H,00B06H,00B30H
		BYTE	010H,0B3H,000H,011H
		WORD	     00B12H,00B00H,00B12H,00B00H,00B12H,00B00H
		WORD	     00B12H,00B00H,00B12H
		BYTE	010H,0D2H,000H,013H
		WORD	     00B06H,00B30H,00B06H,00B30H,00B06H,00B30H
		WORD	     00B06H,00B30H,00B06H,00B30H
		BYTE	010H,0F3H,000H,011H
		WORD	     00B12H,00B00H,00B12H,00B00H,00B12H,00B00H
		WORD	     00B12H,00B00H,00B12H
		BYTE	011H,012H,000H,013H
		WORD	     00B06H,00B30H,00B06H,00B30H,00B06H,00B30H
		WORD	     00B06H,00B30H,00B06H,00B30H
		BYTE	011H,033H,000H,011H
		WORD	     00B12H,00B00H,00B12H,00B00H,00B12H,00B00H
		WORD	     00B12H,00B00H,00B12H
		BYTE	011H,052H,000H,013H
		WORD	     00B06H,00B30H,00B06H,00B30H,00B06H,00B30H
		WORD	     00B06H,00B30H,00B06H,00B30H
		BYTE	011H,073H,000H,011H
		WORD	     00B12H,00B00H,00B12H,00B00H,00B12H,00B00H
		WORD	     00B12H,00B00H,00B12H
		BYTE	011H,092H,000H,013H
		WORD	     00B06H,00B30H,00B06H,00B30H,00B06H,00B30H
		WORD	     00B06H,00B30H,00B06H,00B30H
		BYTE	011H,0B3H,000H,011H
		WORD	     00B12H,00B00H,00B12H,00B00H,00B12H,00B00H
		WORD	     00B12H,00B00H,00B12H
		BYTE	011H,0D2H,040H,012H
		WORD	     00B06H
;
		BYTE	012H,011H,0C0H,012H
		WORD	     00B12H
		BYTE	012H,012H,000H,013H
		WORD	     00B06H,00B30H,00B06H,00B30H,00B06H,00B30H
		WORD	     00B06H,00B30H,00B06H,00B30H
		BYTE	012H,033H,000H,011H
		WORD	     00B12H,00B00H,00B12H,00B00H,00B12H,00B00H
		WORD	     00B12H,00B00H,00B12H
		BYTE	012H,052H,000H,013H
		WORD	     00B06H,00B30H,00B06H,00B30H,00B06H,00B30H
		WORD	     00B06H,00B30H,00B06H,00B30H
		BYTE	012H,073H,000H,011H
		WORD	     00B12H,00B00H,00B12H,00B00H,00B12H,00B00H
		WORD	     00B12H,00B00H,00B12H
		BYTE	012H,092H,000H,013H
		WORD	     00B06H,00B30H,00B06H,00B30H,00B06H,00B30H
		WORD	     00B06H,00B30H,00B06H,00B30H
		BYTE	012H,0B3H,000H,011H
		WORD	     00B12H,00B00H,00B12H,00B00H,00B12H,00B00H
		WORD	     00B12H,00B00H,00B12H
		BYTE	012H,0D2H,000H,013H
		WORD	     00B06H,00B30H,00B06H,00B30H,00B06H,00B30H
		WORD	     00B06H,00B30H,00B06H,00B30H
		BYTE	012H,0F3H,000H,011H
		WORD	     00B12H,00B00H,00B12H,00B00H,00B12H,00B00H
		WORD	     00F12H,00F00H,00F12H
		BYTE	013H,012H,000H,013H
		WORD	     00B06H,00B30H,00B06H,00B30H,00B06H,00B30H
		WORD	     00B06H,00B30H,00B06H,00B30H
		BYTE	013H,033H,000H,011H
		WORD	     00B12H,00B00H,00B12H,00B00H,00B12H,00B00H
		WORD	     00B12H,00B00H,00B12H
		BYTE	013H,052H,040H,012H
		WORD	     00B06H
;
		BYTE	0FFH
;
DMAP000		EQU	$		; tategiri map
;
; '91.3.6 wed:		BYTE	012H,023H,040H,00EH
; '91.3.6 wed:		WORD	     01728H
; '91.3.6 wed:		BYTE	012H,043H,040H,00EH
; '91.3.6 wed:		WORD	     01729H
; '91.3.6 wed:		BYTE	012H,063H,040H,00EH
; '91.3.6 wed:		WORD	     0172AH
; '91.3.6 wed:		BYTE	012H,083H,040H,00EH
; '91.3.6 wed:		WORD	     0172BH
; '91.3.6 wed:		BYTE	012H,0A3H,040H,00EH
; '91.3.6 wed:		WORD	     0172CH
; '91.3.6 wed:		BYTE	012H,0C3H,040H,00EH
; '91.3.6 wed:		WORD	     0172DH
; '91.3.6 wed:		BYTE	012H,0E3H,040H,00EH
; '91.3.6 wed:		WORD	     0172EH
; '91.3.6 wed:		BYTE	013H,003H,040H,00EH
; '91.3.6 wed:		WORD	     0172EH
; '91.3.6 wed:		BYTE	013H,023H,040H,00EH
; '91.3.6 wed:		WORD	     0172EH
; '91.3.6 wed:		BYTE	013H,043H,040H,00EH
; '91.3.6 wed:		WORD	     0172EH
;
;;;		BYTE	0FFH
;
MPGRDT		EQU	$
		WORD	01B28H,01B29H,01B2AH,01B2BH
		WORD	01B2CH,01B2DH,01B2EH
;
DMAPYAMA	EQU	$		; tategiri map yama
		BYTE	010H,0AAH,000H,001H
		WORD	     01B2FH
		BYTE	010H,0C9H,000H,003H
		WORD	     01B2FH,01B2EH
		BYTE	010H,0E5H,000H,00BH
		WORD	     01B2FH,01B2EH,05B2FH,01B2FH
		WORD	     01B2EH,01B2EH
		BYTE	011H,003H,000H,001H
		WORD	     01B2FH
		BYTE	011H,004H,040H,00CH
		WORD	     01B2EH
;
		BYTE	011H,023H,040H,00EH
		WORD	     01B2EH
		BYTE	011H,043H,040H,00EH
		WORD	     01B2EH
		BYTE	011H,063H,040H,00EH
		WORD	     01B2EH
		BYTE	011H,083H,040H,00EH
		WORD	     01B2EH
		BYTE	011H,0A3H,040H,00EH
		WORD	     01B2EH
		BYTE	011H,0C3H,040H,00EH
		WORD	     01B2EH
		BYTE	011H,0E3H,040H,00EH
		WORD	     01B2EH
		BYTE	012H,003H,040H,00EH
		WORD	     01B2EH
		BYTE	012H,023H,040H,00EH
		WORD	     01B2EH
		BYTE	012H,043H,040H,00EH
		WORD	     01B2EH
		BYTE	012H,063H,040H,00EH
		WORD	     01B2EH
		BYTE	012H,083H,040H,00EH
		WORD	     01B2EH
		BYTE	012H,0A3H,040H,00EH
		WORD	     01B2EH
		BYTE	012H,0C3H,040H,00EH
		WORD	     01B2EH
		BYTE	012H,0E3H,040H,00EH
		WORD	     01B2EH
		BYTE	013H,003H,040H,00EH
		WORD	     01B2EH
;
;;;		BYTE	0FFH
;
DMAPMIZU	EQU	$
;
; '91.3.6 wed:		BYTE	012H,023H,040H,00EH
; '91.3.6 wed:		WORD	     01B28H
; '91.3.6 wed:		BYTE	012H,043H,040H,00EH
; '91.3.6 wed:		WORD	     01B29H
; '91.3.6 wed:		BYTE	012H,063H,040H,00EH
; '91.3.6 wed:		WORD	     01B2AH
; '91.3.6 wed:		BYTE	012H,083H,040H,00EH
; '91.3.6 wed:		WORD	     01B2BH
; '91.3.6 wed:		BYTE	012H,0A3H,040H,00EH
; '91.3.6 wed:		WORD	     01B2CH
; '91.3.6 wed:		BYTE	012H,0C3H,040H,00EH
; '91.3.6 wed:		WORD	     01B2DH
; '91.3.6 wed:		BYTE	012H,0E3H,040H,00EH
; '91.3.6 wed:		WORD	     01B2EH
; '91.3.6 wed:		BYTE	013H,003H,040H,00EH
; '91.3.6 wed:		WORD	     01B2EH
; '91.3.6 wed:		BYTE	013H,023H,040H,00EH
; '91.3.6 wed:		WORD	     01B2EH
; '91.3.6 wed:		BYTE	013H,043H,040H,00EH
; '91.3.6 wed:		WORD	     01B2EH
;
;;;		BYTE	0FFH
;
DMAP100		EQU	$ 
;
;
;************************************************************************
;*	MAP UNIT DATA	( NEW )						*
;************************************************************************
MAPUNIT		EQU	$
;
; == [ KYOKAI CHIKADOU ] =================================
;
		WORD    01F6CH,01F6DH,09F6CH,09F6DH ; B1
		WORD    01F6EH,01F6FH,00F00H,01F70H
		WORD    00F00H,00F00H,01F71H,05F71H
		WORD    00F00H,00F00H,01F71H,01F72H
		WORD    01F73H,05F73H,09F73H,0DF73H
		WORD    01F7CH,01F7DH,00F00H,00F00H
		WORD    01F74H,05F74H,01F75H,05F75H ; 1F
		WORD    00F00H,01F7CH,00F00H,00F00H
		WORD    01F7DH,00F00H,00F00H,00F00H
		WORD    01F78H,01F79H,01F7AH,01F7BH ; 2F
;
; == [ SHIRO NAIBU . ROU ENO CHIKADOU ] ==================
;
		WORD    00F00H,00F00H,01F4EH,01F4FH ; B4
		WORD    00F00H,00F00H,01F53H,00F00H ; B3
		WORD    00F00H,00F00H,01F40H,00F00H ; B2,B1
		WORD    00F00H,00F00H,01F43H,05F43H
		WORD    01F41H,01F42H,01F46H,01F47H
		WORD    01F44H,01F45H,01F4AH,01F4BH
		WORD    01F48H,01F49H,01F4CH,01F4DH
		WORD    00F00H,01F86H,00F00H,01F87H ; 1F
		WORD    01F88H,05F88H,01F90H,05F90H
		WORD    01F86H,00F00H,01F87H,00F00H
		WORD    01F89H,01F8AH,01F8BH,01F8CH
		WORD    01F8DH,05F8DH,01F8EH,05F8EH
		WORD    01F91H,01F92H,01F93H,01F94H
		WORD    01F8FH,05F8FH,01F90H,05F90H ; 2F

; == [ SHINDEN ( OMOTE ) ] ===============================
;
		WORD    01F61H,01F62H,09F61H,01F63H ; B1
		WORD    01F5BH,05F5BH,01F60H,05F60H
		WORD    01F64H,01F65H,01F66H,01F67H
		WORD    01F68H,01F69H,01F6AH,05F6AH
		WORD    00F00H,00F00H,01F57H,01F58H ; 1F
		WORD    01F59H,01F5AH,01F5EH,01F5FH
		WORD    01F5CH,01F5DH,09F5CH,01F6BH
		WORD    01F68H,01F69H,01F6AH,05F6AH
		WORD    00F00H,00F00H,01F51H,00F00H ; 2F
		WORD    01F52H,00F00H,01F53H,00F00H
		WORD    01F54H,01F55H,01F56H,05F56H
;
;------------------------------------------------------------
;
; ( DJNNO = 06 )
;
; == [ SABAKU SHINDEN ] ==================================
;
		WORD    01F9EH,01F9FH,01FA3H,05FA3H ; B1
		WORD    01FA0H,01FA0H,01F95H,00F00H
		WORD    01FA1H,01FA2H,00F00H,00F00H
		WORD    01FA6H,01FA7H,01FAAH,01FABH
		WORD    01FA8H,05FA8H,01FACH,05FACH
		WORD    01FA9H,00F00H,01FADH,00F00H
		WORD    00F00H,00F00H,00F00H,01F95H ; 1F,2F
		WORD    01F96H,01F97H,01F98H,00F00H
		WORD    00F00H,01FA4H,00F00H,01FA5H
;
;------------------------------------------------------------
;
; ( DJNNO = 08 )
;
; == [ SHISAI NO TOU ] ===================================
;
		WORD    00F00H,01F7EH,00F00H,01F80H ; 2F
		WORD    01F7FH,00F00H,01F81H,00F00H 
		WORD    00F00H,01F82H,00F00H,09F82H ; 3F,4F
		WORD    00F00H,01F83H,00F00H,09F83H ; 5F
		WORD    00F00H,01F84H,00F00H,09F82H ; 6F,7F
		WORD    00F00H,01F85H,00F00H,01F85H ; 8F
;
;
;************************************************************************
;*	MAP UNIT DATA	( OLD VERSION )					*
;************************************************************************
;		WORD    01F01H,01F01H,01F01H,01F01H ; 0
;		WORD    01F03H,01F03H,09F03H,09F03H ; 1
;		WORD    01F01H,01F03H,01F01H,09F03H ; 2
;		WORD    01F03H,01F01H,09F03H,01F01H ; 3
;		WORD    0DF05H,09F05H,0DF05H,09F05H ; 4
;		WORD    01F01H,01F01H,0DF05H,09F05H ; 5
;		WORD    0DF05H,09F05H,01F01H,01F01H ; 6
;		WORD    01F02H,05F02H,09F02H,0DF02H ; 7
;;
;		WORD    0DF05H,0DF04H,01F01H,0DF03H ; 8
;		WORD    09F04H,09F05H,09F03H,01F01H ; 9
;		WORD    01F01H,05F03H,05F05H,05F04H ; A
;		WORD    01F03H,01F01H,01F04H,01F05H ; B
;		WORD    05F08H,05F07H,0DF08H,0DF07H ; C
;		WORD    01F07H,05F07H,05F0AH,01F0AH ; D
;		WORD    01F07H,01F08H,09F07H,09F08H ; E
;		WORD    0DF0AH,09F0AH,09F07H,0DF07H ; F
;;
;		WORD    01F0BH,01F0BH,09F0BH,09F0BH ; 10
;		WORD    01F0CH,05F0CH,01F0CH,05F0CH ; 11
;		WORD    01F07H,05F07H,09F07H,0DF07H ; 12 
;		WORD    05F08H,05F07H,01F09H,01F0AH ; 13 
;		WORD    01F07H,01F08H,05F0AH,05F09H ; 14
;		WORD    09F09H,09F0AH,0DF08H,0DF07H ; 15
;		WORD    0DF0AH,0DF09H,09F07H,09F08H ; 16
;		WORD    00F00H,01F0BH,00F00H,09F0BH ; 17
;;
;		WORD    01F0BH,00F00H,09F0BH,00F00H ; 18
;		WORD    00F00H,00F00H,01F0CH,05F0CH ; 19
;		WORD    01F0CH,05F0CH,00F00H,00F00H ; 1A
;		WORD    0DF0AH,09F0AH,05F0AH,01F0AH ; 1B
;		WORD    05F08H,01F08H,0DF08H,09F08H ; 1C
;		WORD    01F03H,00F00H,09F03H,00F00H ; 1D
;		WORD    00F00H,01F03H,00F00H,09F03H ; 1E
;		WORD    0DF05H,09F05H,00F00H,00F00H ; 1F
;;
;		WORD    00F00H,00F00H,0DF05H,09F05H ; 20
;		WORD    01F01H,00F00H,01F01H,00F00H ; 21
;		WORD    00F00H,01F01H,00F00H,01F01H ; 22
;		WORD    01F01H,01F01H,00F00H,00F00H ; 23
;		WORD    00F00H,00F00H,01F01H,01F01H ; 24
;		WORD    01F01H,01F03H,00F00H,09F03H ; 25
;		WORD    00F00H,01F03H,01F01H,09F03H ; 26
;		WORD    01F03H,01F01H,09F03H,00F00H ; 27
;;
;		WORD    01F03H,00F00H,09F03H,01F01H ; 28
;		WORD    01F01H,00F00H,0DF05H,09F05H ; 29
;		WORD    00F00H,01F01H,0DF05H,09F05H ; 2A
;		WORD    0DF05H,09F05H,01F01H,00F00H ; 2B
;		WORD    0DF05H,09F05H,00F00H,01F01H ; 2C
;		WORD    00F00H,01F01H,01F01H,01F01H ; 2D
;		WORD    01F01H,00F00H,01F01H,01F01H ; 2E
;		WORD    01F01H,01F01H,00F00H,01F01H ; 2F
;;
;		WORD    01F01H,01F01H,01F01H,00F00H ; 30
;		WORD    01F01H,00F00H,00F00H,00F00H ; 31
;		WORD    00F00H,01F01H,00F00H,00F00H ; 32
;		WORD    00F00H,00F00H,01F01H,00F00H ; 33
;		WORD    00F00H,00F00H,00F00H,01F01H ; 34
;		WORD    05F08H,01F08H,0DF08H,0DF49H ; 35
;		WORD    00F00H,01F4CH,00F00H,09F4CH ; 36
;		WORD    0DF0AH,05F49H,05F0AH,0DF4AH ; 37
;;
;		WORD    00F00H,00F00H,05F60H,01F60H ; 38
;		WORD    00F00H,00F00H,0DF61H,09F63H ; 39
;		WORD    05F15H,05F41H,00F00H,00F00H ; 3A
;		WORD    01F0EH,05F0EH,09F07H,0DF07H ; 3B
;		WORD    0DF63H,09F63H,05F63H,01F63H ; 3C
;		WORD    05F51H,01F55H,0DF51H,09F55H ; 3D
;		WORD    0DF15H,09F15H,0DF68H,01F63H ; 3E
;		WORD    05F49H,00F00H,01F0AH,00F00H ; 3F
;;
;		WORD    09F3AH,00F00H,01F3AH,00F00H ; 40
;		WORD    00F00H,00F00H,0DF11H,01F83H ; 41
;		WORD    00F00H,00F00H,0DF63H,09F63H ; 42
;		WORD    01F41H,05F41H,09F4AH,0DF02H ; 43
;		WORD    09F3AH,00F00H,05F3FH,01F39H ; 44
;		WORD    01F49H,05F02H,09F02H,0DF4AH ; 45
;		WORD    09F0AH,00F00H,0DF02H,00F00H ; 46
;		WORD    00F00H,0DF0AH,00F00H,09F02H ; 47
;;
;		WORD    00F00H,05F51H,00F00H,09F4CH ; 48
;		WORD    05F60H,01F60H,0DF63H,09F63H ; 49
;		WORD    01F51H,00F00H,09F4CH,00F00H ; 4A
;		WORD    09F11H,01F4EH,0DF45H,05F11H ; 4B
;		WORD    01F80H,05F80H,09F45H,0DF45H ; 4C
;		WORD    01F4EH,0DF11H,01F11H,09F45H ; 4D
;		WORD    00F00H,00F00H,09F3AH,00F00H ; 4E
;		WORD    01F4CH,00F00H,09F03H,00F00H ; 4F
;;
;		WORD    0DF67H,09F67H,05F66H,01F66H ; 50
;		WORD    00F00H,00F00H,01F02H,01F08H ; 51
;		WORD    05F08H,05F0FH,01F01H,01F11H ; 52
;		WORD    01F02H,05F0FH,01F01H,01F11H ; 53
;		WORD    0DF11H,09F11H,09F80H,0DF80H ; 54
;		WORD    05F54H,01F3BH,09F4FH,01F3AH ; 55
;		WORD    05F0AH,01F0AH,0DF0AH,09F0AH ; 56
;		WORD    05F51H,01F3DH,0DF51H,01F39H ; 57
;;
;		WORD    01F4AH,05F4AH,05F0AH,01F0AH ; 58
;		WORD    01F4AH,05F02H,09F02H,0DF02H ; 59
;		WORD    0DF68H,09F68H,05F68H,01F68H ; 5A
;		WORD    00F00H,00F00H,05F68H,01F08H ; 5B
;		WORD    01F45H,05F45H,09F10H,0DF10H ; 5C
;		WORD    01F4FH,00F00H,09F4FH,00F00H ; 5D
;		WORD    01F41H,05F41H,09F41H,0DF41H ; 5E
;		WORD    01F49H,05F0FH,01F3AH,01F11H ; 5F
;;
;		WORD    01F43H,05F43H,09F07H,0DF07H ; 60
;		WORD    05F55H,01F3DH,0DF51H,01F39H ; 61
;		WORD    01F5AH,01F39H,09F02H,01F05H ; 62
;		WORD    00F00H,00F00H,00F00H,09F3AH ; 63
;		WORD    05F3BH,09F3BH,01F3CH,00F00H ; 64
;		WORD    05F51H,01F14H,09F4CH,00F00H ; 65
;		WORD    01F51H,00F00H,09F03H,00F00H ; 66
;		WORD    05F60H,01F65H,00F00H,00F00H ; 67
;;
;		WORD    01F3DH,01F3DH,09F3AH,00F00H ; 68
;		WORD    01F02H,05F4AH,09F41H,0DF41H ; 69
;		WORD    01F43H,05F43H,0DF15H,09F15H ; 6A
;		WORD    01F55H,00F00H,09F03H,00F00H ; 6B
;		WORD    00F00H,05F51H,05F65H,0DF02H ; 6C
;		WORD    01F3AH,00F00H,05F3BH,01F39H ; 6D
;		WORD    01F02H,01F08H,09F49H,09F08H ; 6E
;		WORD    01F3CH,00F00H,09F3BH,00F00H ; 6F
;;
;		WORD    01F49H,00F00H,09F02H,01F60H ; 70
;		WORD    01F3CH,01F08H,05F6EH,09F08H ; 71
;		WORD    09F3AH,00F00H,01F3AH,01F01H ; 72
;		WORD    09F3BH,00F00H,00F00H,00F00H ; 73
;		WORD    01F02H,01F14H,09F02H,0DF02H ; 74
;		WORD    05F65H,01F65H,00F00H,00F00H ; 75
;		WORD    05F65H,01F05H,00F00H,00F00H ; 76
;		WORD    01F03H,01F4CH,09F03H,09F4CH ; 77
;;
;		WORD    09F0AH,01F4CH,01F0AH,0DF55H ; 78
;		WORD    00F00H,00F00H,05F60H,09F65H ; 79
;		WORD    01F0EH,05F0EH,09F0EH,0DF0EH ; 7A
;		WORD    05F15H,05F42H,00F00H,00F00H ; 7B
;		WORD    0DF63H,01F68H,05F64H,01F64H ; 7C
;		WORD    01F03H,01F4CH,09F41H,0DF0EH ; 7D
;		WORD    00F00H,00F00H,00F00H,00F00H ; 7E
;		WORD    00F00H,00F00H,00F00H,00F00H ; 7F
;;
;		WORD    00F00H,00F00H,0DF65H,01F60H ; 80
;		WORD    05F3FH,01F3DH,01F3FH,05F3BH ; 81
;		WORD    01F51H,01F4CH,09F5DH,09F55H ; 82
;		WORD    05F65H,01F05H,01F14H,01F14H ; 83
;		WORD    01F03H,00F00H,09F51H,00F00H ; 84
;		WORD    05F4FH,01F4FH,0DF4DH,0DF54H ; 85
;		WORD    01F01H,01F03H,01F3EH,09F55H ; 86
;		WORD    01F03H,00F00H,01F13H,00F00H ; 87
;;
;		WORD    0DF0AH,01F4FH,05F0AH,0DF54H ; 88
;;
;;
;		WORD    00F00H,00F00H,00F00H,00F00H ; FFFF (89)
;
LASTUNO		EQU	$
		WORD	00089H			    ; Last unit No.
;
;
;****************************************************************
;*	tower data						*
;****************************************************************
TOWERDT		EQU	$
;
;
;
;			; 00 0 0 0 H
;			;    - - -
;			;    | | |_ chika kaisuu
;			;    | |
;			;    | |_ chijyou kaisuu
;			;    |
;			;    |_ danjyon no syurui
;			;		( 0.normal 1.mountain 2.water )
; 
; 
; 
		WORD	00021H		; DJNNO =  00 (kyokai chika)
		WORD	00024H		; DJNNO =  02 (shiro,rou)
		WORD	00021H		; DJNNO =  04 (shinden)
		WORD	00021H		; DJNNO =  06 (sabaku shinden)
		WORD	00080H		; DJNNO =  08 (shisai no tou)
		WORD	00013H		; DJNNO =  0A (ura hokora)
		WORD	00011H		; DJNNO =  0C (ura shinden)
		WORD	00013H		; DJNNO =  0E (ura numa)
		WORD	00002H		; DJNNO =  10 (ura mori)
		WORD	00017H		; DJNNO =  12 (ura mizuumi)
;
;++++++++++++++< TOWERDT end >++++++++++++
;
TWDTADD1        EQU     $
                WORD    TWDT0000-TWDT0000		; 1
                WORD    TWDT0001-TWDT0000		; 2
                WORD    TWDT0002-TWDT0000		; 3
                WORD    TWDT0003-TWDT0000		; 4
                WORD    TWDT0004-TWDT0000		; 5
                WORD    TWDT0005-TWDT0000		; 6
                WORD    TWDT0006-TWDT0000		; 7
                WORD    TWDT0007-TWDT0000		; 8
;
;------------------------------------------------------
;
TWDTADD2        EQU     $
                WORD    TWDT0000	; DJNNO =  00
		WORD	TWDT0010	; DJNNO =  02
		WORD	TWDT0020	; DJNNO =  04
		WORD	TWDT0030	; DJNNO =  06
                WORD    TWDT0040	; DJNNO =  08
		WORD	TWDT0050	; DJNNO =  0A
		WORD	TWDT0060	; DJNNO =  0C
		WORD	TWDT0070	; DJNNO =  0E
		WORD	TWDT0080	; DJNNO =  10
		WORD	TWDT0090	; DJNNO =  12
;
;
;************************************************************************
;*	FLOOR DATA 1							*
;************************************************************************
;
; ( DJNNO = 00 )
;
; == [ Kyokai --> Gyokuza no ura ] =========================
;
TWDT0000        EQU     $					; B1
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,00010H,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,00020H,00021H,00022H,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,00032H,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,00042H,0FFFFH
;
TWDT0001        EQU     $					; 1F
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,00001H,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,00030H,0FFFFH
;
TWDT0002        EQU     $					; 2F
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,00031H,0FFFFH
;
TWDT0003        EQU     $
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
;
TWDT0004        EQU     $
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
;
TWDT0005        EQU     $
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
;
TWDT0006        EQU     $
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
;
TWDT0007        EQU     $
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
;
;------------------------------------------------------------
;
; ( DJNNO = 02 )
;
; == [ Jyochyu . chika-rou eno chikadou ] ====================
;
TWDT0010        EQU     $					; B4
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,00080H,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
;
TWDT0011        EQU     $					; B3
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,00070H,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
;
TWDT0012        EQU     $					: B2
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,00071H,00072H,0FFFFH,0FFFFH
		WORD	0FFFFH,00081H,00082H,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
;
TWDT0013        EQU     $					; B1
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,00071H,00072H,0FFFFH,0FFFFH
		WORD	0FFFFH,00081H,00082H,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
;
TWDT0014        EQU     $					; 1F
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,00050H,00051H,00052H,0FFFFH
		WORD	0FFFFH,00060H,00061H,00062H,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
;
TWDT0015        EQU     $					; 2F
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,00041H,0FFFFH,0FFFFH
		WORD	0FFFFH,00060H,00061H,00062H,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
;
;------------------------------------------------------------
;
; ( DJNNO = 04 )
;
; == [ Shinden ] ============================================
;
TWDT0020        EQU     $					; B1
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,00043H,00034H,00045H,0FFFFH
		WORD	0FFFFH,0FFFFH,0FF44H,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
;
TWDT0021        EQU     $					; 1F
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,00024H,0FFFFH,0FFFFH
		WORD	0FFFFH,00033H,00034H,00035H,0FFFFH
		WORD	0FFFFH,0FFFFH,00044H,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
;
TWDT0022        EQU     $					; 2F
		WORD	0FFFFH,0FFFFH,00004H,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,00014H,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,00054H,0FFFFH,0FFFFH
;
;------------------------------------------------------------
;
; ( DJNNO = 06 )
;
; == [ Sabaku no Shinden  ] =================================
;
TWDT0030        EQU     $					; B1
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,00064H,00065H,00066H
		WORD	0FFFFH,00073H,00074H,00075H,0FFFFH
;
TWDT0031        EQU     $					; 1F
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,00084H,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,00076H
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
;
TWDT0032        EQU     $					; 2F
		WORD	00053H,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	00063H,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	00083H,00084H,0FFFFH,0FFFFH,0FFFFH
;
;------------------------------------------------------------
;
; ( DJNNO = 08 )
;
; == [ Shisai's tower ] =====================================
;
TWDT0040        EQU     $					; DUMMY 1F
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
;
TWDT0041        EQU     $					; 2F
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,000E0H,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
;
TWDT0042        EQU     $					; 3F
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,000D0H,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
;
TWDT0043        EQU     $					; 4F
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,000C0H,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
;
TWDT0044	EQU     $					; 5F
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,000B0H,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
;
TWDT0045        EQU     $					; 6F
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,000A0H,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
;
TWDT0046        EQU     $					; 7F
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,000A0H,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
;
TWDT0047        EQU     $					; 8F
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,00090H,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
;
;------------------------------------------------------------
;
; ( DJNNO = 0A )
;
; == [ Ura hokora danjyon ] =================================
;
TWDT0050        EQU     $					; B3
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,00027H,0FFFFH,0FFFFH,0FFFFH
;
TWDT0051        EQU     $					; B2
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	00005H,0FFFFH,00007H,00008H,0FFFFH
		WORD	00015H,00016H,00017H,0FFFFH,0FFFFH
		WORD	00025H,00026H,0FFFFH,0FFFFH,0FFFFH
;
TWDT0052        EQU     $					; B1
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	00005H,00006H,00007H,00008H,0FFFFH
		WORD	00015H,00016H,00017H,00028H,0FFFFH
		WORD	00025H,00026H,0FFFFH,0FFFFH,0FFFFH
;
TWDT0053        EQU     $					; 1F
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,00027H,00028H,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,00038H,0FFFFH
;
;
;------------------------------------------------------------
;
; ( DJNNO = 0C )
;
; == [ Ura shinden ] ========================================
;
TWDT0060        EQU     $					; B1
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0001AH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0002AH,0003BH,0002CH
		WORD	0FFFFH,0FFFFH,0005AH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0006AH,0FFFFH,0FFFFH
;
TWDT0061        EQU     $					; 1F
		WORD	0FFFFH,0FFFFH,0000AH,0FFFFH,0FFFFH
		WORD	00018H,00019H,0001AH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0002AH,0002BH,0002CH
		WORD	0FFFFH,0FFFFH,0003AH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0004AH,0FFFFH,0FFFFH
;
;
;------------------------------------------------------------
;
; ( DJNNO = 0E )
;
; == [ Ura numa no shinden ] ================================
;
TWDT0070        EQU     $					; B3
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,000B2H,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,000C2H,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
;
TWDT0071        EQU     $					; B2
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,000B2H,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,000C2H,000C3H,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,000D3H,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
;
TWDT0072        EQU     $					; B1
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	00091H,00092H,00093H,00094H,00095H
		WORD	0FFFFH,000A2H,000A3H,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
;
TWDT0073        EQU     $					; 1F
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,000D2H,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
;
;
;------------------------------------------------------------
;
; ( DJNNO = 10 )
;
; == [ Ura no mori ] ========================================
;
TWDT0080        EQU     $					; B2
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,00047H,00048H,00049H
		WORD	0FFFFH,0FFFFH,00057H,00058H,0FFFFH
		WORD	0FFFFH,0FFFFH,00067H,00068H,0FFFFH
;
TWDT0081        EQU     $					; B1
		WORD	00029H,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	00039H,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,00047H,00048H,00049H
		WORD	0FFFFH,00056H,00057H,00058H,0FFFFH
		WORD	0FFFFH,0FFFFH,00067H,00068H,00069H
;
;
;------------------------------------------------------------
;
; ( DJNNO = 12 )
;
; == [ Ura mizuumi no chikatou ] ============================
;
TWDT0090        EQU     $					; B7
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,000DEH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
;
TWDT0091        EQU     $					; B6
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,000BEH,000BFH,0FFFFH
		WORD	0FFFFH,0FFFFH,000CEH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
;
TWDT0092        EQU     $					; B5
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0009EH,0009FH,0FFFFH
		WORD	0FFFFH,0FFFFH,000AEH,000AFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
;
TWDT0093        EQU     $					; B4
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0007EH,0007FH,0FFFFH
		WORD	0FFFFH,0FFFFH,0008EH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
;
TWDT0094        EQU     $					; B3
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0005EH,0005FH,0FFFFH
		WORD	0FFFFH,0FFFFH,0006EH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
;
TWDT0095        EQU     $					; B2
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0003EH,0003FH,0FFFFH
		WORD	0FFFFH,0FFFFH,0004EH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
;
TWDT0096        EQU     $					; B1
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0001EH,0001FH,0FFFFH
		WORD	0FFFFH,0FFFFH,0002EH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
;
TWDT0097        EQU     $					; 1F
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0000EH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
;
;
;
;************************************************************************
;*	FLOOR  DATA  LABEL  ( noto use )				*
;************************************************************************
TOWERADD	EQU     $
		WORD    TOWER000	; DJNNO =  00
		WORD	TOWER010	; DJNNO =  02
		WORD	TOWER020	; DJNNO =  04
		WORD	TOWER030	; DJNNO =  06
                WORD    TOWER040	; DJNNO =  08
		WORD	TOWER050	; DJNNO =  0A
		WORD	TOWER060	; DJNNO =  0C
		WORD	TOWER070	; DJNNO =  0E
		WORD	TOWER080	; DJNNO =  10
		WORD	TOWER090	; DJNNO =  12
;
;
;************************************************************************
;*	FLOOR  DATA							*
;************************************************************************
;
; ( DJNNO = 00 )
;
; == [ KYOKAI CHIKADOU ] =================================
;
TOWER000        EQU     $					; B1
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,00077H,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,00078H,00038H,00039H,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0007AH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,00075H,0FFFFH
;
TOWER001        EQU     $					; 1F
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0007CH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0007BH,0FFFFH
;
TOWER002        EQU     $					; 2F
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,00070H,0FFFFH
;
TOWER003        EQU     $
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
;
TOWER004        EQU     $
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
;
TOWER005        EQU     $
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
;
TOWER006        EQU     $
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
;
TOWER007        EQU     $
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
;
;------------------------------------------------------------
;
; ( DJNNO = 02 )
;
; == [ SHIRO NAIBU . ROU ENO CHIKADOU ] ==================
;
TOWER010        EQU     $					; B4
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,00076H,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
;
TOWER011        EQU     $					; B3
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,00075H,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
;
TOWER012        EQU     $					: B2
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0006DH,0006EH,0FFFFH,0FFFFH
		WORD	0FFFFH,00070H,0006FH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
;
TOWER013        EQU     $					; B1
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,00072H,00071H,0FFFFH,0FFFFH
		WORD	0FFFFH,00074H,00073H,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
;
TOWER014        EQU     $					; 1F
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,00048H,00049H,0004AH,0FFFFH
		WORD	0FFFFH,0004BH,0004CH,0004DH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
;
TOWER015        EQU     $					; 2F
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0001FH,0FFFFH,0FFFFH
		WORD	0FFFFH,00046H,0FFFFH,00047H,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
;
;------------------------------------------------------------
;
; ( DJNNO = 04 )
;
; == [ SHINDEN ( OMOTE ) ] ===============================
;
TOWER020        EQU     $					; B1
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,00060H,00062H,0FFFFH
		WORD	00061H,0FFFFH,00007H,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
;
TOWER021        EQU     $					; 1F
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0005BH,0FFFFH,0FFFFH
		WORD	0FFFFH,0005FH,0005CH,00055H,0FFFFH
		WORD	0FFFFH,0FFFFH,0005EH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
;
TOWER022        EQU     $					; 2F
		WORD	0FFFFH,0FFFFH,0004EH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0004FH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0005AH,0FFFFH,0FFFFH
;
;------------------------------------------------------------
;
; ( DJNNO = 06 )
;
; == [ SABAKU SHINDEN ] ==================================
;
TOWER030        EQU     $					; B1
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,00069H,00068H,00067H
		WORD	0FFFFH,0006CH,0006AH,0006BH,0FFFFH
;
TOWER031        EQU     $					; 1F
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0001DH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,00036H
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
;
TOWER032        EQU     $					; 2F
		WORD	00063H,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	00064H,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	00065H,00066H,0FFFFH,0FFFFH,0FFFFH
;
;------------------------------------------------------------
;
; ( DJNNO = 08 )
;
; == [ SHISAI NO TOU ] ===================================
;
TOWER040        EQU     $					; DUMMY 1F
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
;
TOWER041        EQU     $					; 2F
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
;
TOWER042        EQU     $					; 3F
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
;
TOWER043        EQU     $					; 4F
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
;
TOWER044	EQU     $					; 5F
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
;
TOWER045        EQU     $					; 6F
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
;
TOWER046	EQU     $					; 7F
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
;
TOWER047        EQU     $					; 8F
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
;
;------------------------------------------------------------
;
; ( DJNNO = 0A )
;
; == [ URA HOKORA ] ======================================
;
TOWER050        EQU     $					; B3
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,00027H,0FFFFH,0FFFFH,0FFFFH
;
TOWER051        EQU     $					; B2
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	00005H,0FFFFH,00007H,00008H,0FFFFH
		WORD	00015H,00016H,00017H,0FFFFH,0FFFFH
		WORD	00025H,00026H,0FFFFH,0FFFFH,0FFFFH
;
TOWER052        EQU     $					; B1
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	00005H,00006H,00007H,00008H,0FFFFH
		WORD	00015H,00016H,00017H,00028H,0FFFFH
		WORD	00025H,00026H,0FFFFH,0FFFFH,0FFFFH
;
TOWER053        EQU     $					; 1F
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,00027H,00028H,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,00038H,0FFFFH
;
;------------------------------------------------------------
;
; ( DJNNO = 0C )
;
; == [ SHINDEN ( URA ) ] =================================
;
TOWER060        EQU     $					; B1
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0001AH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0002AH,0003BH,0002CH
		WORD	0FFFFH,0FFFFH,0005AH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0006AH,0FFFFH,0FFFFH
;
TOWER061        EQU     $					; 1F
		WORD	0FFFFH,0FFFFH,0000AH,0FFFFH,0FFFFH
		WORD	00018H,00019H,0001AH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0002AH,0002BH,0002CH
		WORD	0FFFFH,0FFFFH,0003AH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0004AH,0FFFFH,0FFFFH
;
;------------------------------------------------------------
;
; ( DJNNO = 0E )
;
; == [ URANUMA NO SHINDEN ] ==============================
;
TOWER070        EQU     $					; B3
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,000B2H,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,000C2H,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
;
TOWER071        EQU     $					; B2
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,000B2H,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,000C2H,000C3H,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,000D3H,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
;
TOWER072        EQU     $					; B1
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	00091H,00092H,00093H,00094H,00095H
		WORD	0FFFFH,000A2H,000A3H,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
;
TOWER073        EQU     $					; 1F
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,000D2H,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
;
;------------------------------------------------------------
;
; ( DJNNO = 10 )
;
; == [ URANUMA NO MORI ] =================================
;
TOWER080	EQU     $					; B2
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,00088H,00084H
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
;
TOWER081	EQU     $					; B1
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	00063H,0FFFFH,00085H,00086H,00087H
		WORD	0FFFFH,00080H,00081H,00082H,0FFFFH
		WORD	0FFFFH,0FFFFH,00045H,00083H,00084H
;
;------------------------------------------------------------
;
; ( DJNNO = 12 )
;
; == [ URAMIZUUMI NO CHIKAROU ] ==========================
;
TOWER090	EQU	$					; B7
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,000DEH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
;
TOWER091	EQU	$					; B6
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,000BEH,000BFH,0FFFFH
		WORD	0FFFFH,0FFFFH,000CEH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
;
TOWER092	EQU	$					; B5
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0009EH,0009FH,0FFFFH
		WORD	0FFFFH,0FFFFH,000AEH,000AFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
;
TOWER093	EQU	$					; B4
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0007EH,0007FH,0FFFFH
		WORD	0FFFFH,0FFFFH,0008EH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
;
TOWER094	EQU	$					; B3
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0005EH,0005FH,0FFFFH
		WORD	0FFFFH,0FFFFH,0006EH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
;
TOWER95		EQU	$					; B2
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0003EH,0003FH,0FFFFH
		WORD	0FFFFH,0FFFFH,0004EH,0FFFFH,0FFFFH
;
TOWER096	EQU	$					; B1
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0001EH,0001FH,0FFFFH
		WORD	0FFFFH,0FFFFH,0002EH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
;
TOWER097	EQU	$					; 1F
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0000EH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
		WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
;
;------------------------------------------------------------
;
;
;// 03.02.08 //;************************************************************************
;// 03.02.08 //;*		Mater off				(MTROFF)	*
;// 03.02.08 //;************************************************************************
;// 03.02.08 //MTROFF		EQU	$
;// 03.02.08 //		MEM16
;// 03.02.08 //		IDX16
;// 03.02.08 //		REP	#00110000B	; memory,index 16bit mode
;// 03.02.08 //;
;// 03.02.08 //		LDX	#00000H
;// 03.02.08 //MTR040		EQU	$
;// 03.02.08 //		LDA	>MTRBUF+000H,X
;// 03.02.08 //		AND	#1110001111111111B
;// 03.02.08 //		STA	>MTRBUF+000H,X
;// 03.02.08 //;
;// 03.02.08 //		LDA	>MTRBUF+040H,X
;// 03.02.08 //		AND	#1110001111111111B
;// 03.02.08 //		STA	>MTRBUF+040H,X
;// 03.02.08 //;
;// 03.02.08 //		LDA	>MTRBUF+080H,X
;// 03.02.08 //		AND	#1110001111111111B
;// 03.02.08 //		STA	>MTRBUF+080H,X
;// 03.02.08 //;
;// 03.02.08 //		LDA	>MTRBUF+0C0H,X
;// 03.02.08 //		AND	#1110001111111111B
;// 03.02.08 //		STA	>MTRBUF+0C0H,X
;// 03.02.08 //;
;// 03.02.08 //		LDA	>MTRBUF+100H,X
;// 03.02.08 //		AND	#1110001111111111B
;// 03.02.08 //		STA	>MTRBUF+100H,X
;// 03.02.08 //		INX
;// 03.02.08 //		INX
;// 03.02.08 //		CPX	#00040H
;// 03.02.08 //		BNE	MTR040		; end ?
;// 03.02.08 //;					; yes
;// 03.02.08 //MTR080		EQU	$
;// 03.02.08 //		LDA	>MTRBUF+100H,X
;// 03.02.08 //		AND	#1110001111111111B
;// 03.02.08 //		STA	>MTRBUF+100H,X
;// 03.02.08 //		INX
;// 03.02.08 //		INX
;// 03.02.08 //		CPX	#0004AH
;// 03.02.08 //		BNE	MTR080		; end ?
;// 03.02.08 //;					; yes
;// 03.02.08 //		BRA	MTR200
;// 03.02.08 //;
;
;************************************************************************
;*		soto BANK mater on  			(MTRSUB)	*
;************************************************************************
MTRSUB		EQU	$
		PHB
		PHK
		PLB
		JSR	MTRON0
		PLB
		RTL
;
;************************************************************************
;*		Mater on				(MTRON0)	*
;************************************************************************
MTRON2		EQU	$
		JSR	MTRON0
		RTL
;
MTRON0		EQU	$
		MEM16
		IDX16
		REP	#00110000B	; memory,index 16bit mode
;
		PHB			; (DBR) push
		LDA	#MTRDTEN-MTRDATA-1
		LDX	#MTRDATA
		LDY	#MTRBUF
		MVN	#BANK MTRDATA,#BANK MTRBUF
;;		MVN	#002H,#07EH
		PLB			; (DBR) pull
;
		PHB
		PHK
		PLB			; (DBR) set
;
;// 03.02.08 //		LDA	#0FFFFH
		BRA	MTR100
;
;
;************************************************************************
;*		Mater off				(MTRON1)	*
;************************************************************************
MTRON1		EQU	$
		MEM16
		IDX16
		REP	#00110000B	; memory,index 16bit mode
;
		PHB
		PHK
		PLB			; (DBR) set
;
;// 03.02.08 //		LDA	#1110001111111111B
MTR100		EQU	$
		JSR	MTRINWT		; mater in write
;
		PLB			; (DBR) reset
MTR200		EQU	$
		MEM8
		IDX8
		SEP	#00110000B	; (DBR) pull
;
		INC	<B3CHFG		; mater write flag on
		RTS
;
;
;
;
;-----------------------------------------------------------------------
STGITRM		EQU	$
		WORD	RITEM01,RITEM02,RITEM03,RITEM04,RITEM05
		WORD	RITEM06,RITEM07,RITEM08,RITEM09,RITEM10
		WORD	RITEM11,RITEM12,RITEM13,RITEM14,RITEM15
		WORD	RITEM16,RITEM17,RITEM18,RITEM19,RITEM20
		WORD	RITEM21,RITEM22,RITEM23,RITEM24,RITEM25
		WORD	RITEM26,RITEM27,RITEM28,RITEM29,RITEM30
		WORD	RITEM31,RITEM32
;		WORD	RITEM37,RITEM39,RITEM41
;
STGITWM		EQU	$
		WORD	WITEM01,WITEM02,WITEM03,WITEM04,WITEM05
		WORD	WITEM06,WITEM07,WITEM08,WITEM09,WITEM10
;
		WORD	WITEM11,WITEM12,WITEM13,WITEM14,WITEM15
		WORD	WITEM16,WITEM17,WITEM18,WITEM19,WITEM20
;
;		WORD	WITEM21,WITEM22,WITEM23,WITEM24,WITEM25
;		WORD	WITEM26,WITEM27,WITEM28,WITEM29,WITEM30
;
SETGITM		EQU	$
;
;		<WORK0,1 : TFR SAKI SET
;
;		<WORK2,3 : NO. SET(NANBANME)
;
;		<WORK4,5 : TFR MOTO
;
;		GETITM0,+1  : ITEM NO.
;
		MEM8
		IDX8
		SEP	#00110000B
;
		LDA	>ITEMR01
		BEQ	STGIM25
		LDX	#002H
		LDA	>ARWCNT
		BNE	STGIM20
		LDX	#001H
STGIM20		EQU	$
		TXA
		STA	>ITEMR01	;ya init set
;
STGIM25		EQU	$
		MEM16
		IDX16
		REP	#00110000B
;
		LDX	GETITM0
		BEQ	STGIM10
		LDA	>ITEMR01-1,X
		AND	#000FFH
		CPX	#00004		;? BOMB 
		BNE	STGIM30		;
		LDA	#00001H		;Y
STGIM30		EQU	$
		CPX	#00016		;? BIN SELECT
		BNE	STGIM40
		TXY
		TAX			;Y
		LDA	>BINCT0-1,X
		AND	#000FFH
		TYX
STGIM40		EQU	$
		STA	<WORK2
		TXA
		DEC	A
		ASL	A
		TAX
		LDA	STGITRM,X
		STA	<WORK4
;
		LDA	<WORK2		;TFR MOTO GET
		ASL	A
		ASL	A
		ASL	A
		TAY
;
		LDA	(<WORK4),Y
		STA	>MWAKU7+044H+000H
		INY
		INY
		LDA	(<WORK4),Y
		STA	>MWAKU7+044H+002H
		INY
		INY
		LDA	(<WORK4),Y
		STA	>MWAKU7+044H+040H
		INY
		INY
		LDA	(<WORK4),Y
		STA	>MWAKU7+044H+042H
;
STGIM10		EQU	$
		RTS
;----------------------------------------
		MEM16
		IDX16
;
MTRINWT		EQU	$		; mater in write
BITMWT		EQU	$
;
		JSR	SETGITM		;SET ITEM B
;
LIFEWT		EQU	$
		MEM8
		IDX8
		SEP	#00110000B
;					;life no max
		LDA	#LOW  LFDAT0	;dono data o kakuka o work+10,11,12 ni set
		STA	<WORK+10
		LDA	#HIGH LFDAT0
		STA	<WORK+11
		LDA	#BANK LFDAT0
		STA	<WORK+12
;
		LDA	#LOW  ILIFE	;doko ni kakuka o work+7,8,9 ni set
		STA	<WORK+7
		LDA	#HIGH ILIFE
		STA	<WORK+8
		LDA	#BANK ILIFE
		STA	<WORK+9
;
		MEM16
		IDX16
		REP	#00110000B	; memory,index 16bit mode
;
		LDA	>LFITCT		;nani o kakuka o set(doredake kakuka)
		AND	#000FFH
		STA	<WORK		;henkan suru atai
		STA	<WORK+2		;henkan suru mono no max
		STA	<WORK+4		;henkan suru mono no now
;
		JSR	WRITEMT
;					;life no nokori
		MEM8
		IDX8
		SEP	#00110000B	; memory,index 8bit mode
;
		LDA	#LOW  LFDAT1	;dono data o kakuka o work+10,11,12 ni set
		STA	<WORK+10
		LDA	#HIGH LFDAT1
		STA	<WORK+11
		LDA	#BANK LFDAT1
		STA	<WORK+12
;
		LDA	#LOW  ILIFE	;doko ni kakuka o work+7,8,9 ni set
		STA	<WORK+7
		LDA	#HIGH ILIFE
		STA	<WORK+8
		LDA	#BANK ILIFE
		STA	<WORK+9
;
		LDA	>LFITCT
		CMP	>LFNWCT
		BEQ	LFWT10
		SEC
		SBC	#004H
		CMP	>LFNWCT
		BCS	LFWT10
		LDA	>LFNWCT
		BRA	LFWT20
;
LFWT10		EQU	$
		LDA	>LFNWCT		;nani o kakuka o set(doredake kakuka)
		CLC
		ADC	#003H
LFWT20		EQU	$
		MEM16
		IDX16
		REP	#00110000B	; memory,index 16bit mode
;
		AND	#000FCH
		STA	<WORK		;henkan suru atai
		STA	<WORK+4		;henkan suru mono no now
;
		LDA	>LFITCT		;life no max o set
		AND	#000FFH
		STA	<WORK+2		;henkan suru mono no max
;
		JSR	WRITEMT
;					;life no nokori
;		MEM8
;		IDX8
;		SEP	#00110000B	; memory,index 8bit mode
;
;
MPWT		EQU	$
;
		MEM16
		IDX16
		REP	#00110000B
;
		LDA	>MPNWCT
		AND	#000FFH
		CLC
		ADC	#00007H
		AND	#0FFF8H
		TAX
		LDA	MPMTRDT+00H,X	;METER 1
		STA	>IMP+000H
		LDA	MPMTRDT+02H,X	;METER 2
		STA	>IMP+040H
		LDA	MPMTRDT+04H,X	;METER 3
		STA	>IMP+080H
		LDA	MPMTRDT+06H,X	;METER 4
		STA	>IMP+0C0H
;
;		MEM8
;		IDX8
;		SEP	#00110000B
;
;
COINWT		EQU	$
;		MEM16
;		IDX16
;		REP	#00110000B
;
		LDA	>CONCNT		;COIN no kazu o 10 sin ni suru
		JSR	HENKAN		;16 --> 10
;
		MEM16
		IDX16
		REP	#00110000B
;
		LDA	<WORK+3
		AND	#00FFH
		ORA	#2400H
;// 03.02.08 //		AND	<WORKE
		STA	>ICOIN
		LDA	<WORK+4
		AND	#00FFH
		ORA	#2400H
;// 03.02.08 //		AND	<WORKE
		STA	>ICOIN+2
		LDA	<WORK+5
		AND	#00FFH
		ORA	#2400H
;// 03.02.08 //		AND	<WORKE
		STA	>ICOIN+4
;
;
BOMBWT		EQU	$
;                MEM16
;                IDX16
;                REP     #00110000B
;
                LDA     >BMBCNT          ;BOMB no kazu o 10 sin ni suru
		AND	#000FFH
                JSR     HENKAN          ;16 --> 10
;
                MEM16
                IDX16
                REP     #00110000B
;
		LDA	<WORK+3
		AND	#00FFH
		ORA	#2400H
;// 03.02.08 //		AND	<WORKE
		STA	>IBOMB
                LDA     <WORK+4
                AND     #00FFH
                ORA     #2400H
;// 03.02.08 //		AND	<WORKE
		STA	>IBOMB+2
;
;
WTYA		EQU	$
;                MEM16
;                IDX16
;                REP     #00110000B
;
                LDA     >ARWCNT          ;YA no kazu o 10 sin ni suru
                AND     #00FFH
                JSR     HENKAN          ;16 --> 10
;
                MEM16
                IDX16
                REP     #00110000B
;
                LDA     <WORK+3
                AND     #00FFH
                ORA     #2400H
;// 03.02.08 //		AND	<WORKE
		STA	>IYA
                LDA     <WORK+4
                AND     #00FFH
                ORA     #2400H
;// 03.02.08 //		AND	<WORKE
		STA	>IYA+2
                LDA     <WORK+5
                AND     #00FFH
                ORA     #2400H
;// 03.02.08 //		AND	<WORKE
		STA	>IYA+4
;
;		MEM8
;		IDX8
;		SEP	#00110000B
;
WTKEY		EQU	$
;                MEM16
;                IDX16
;                REP     #00110000B
;
                LDA     >ITMTBL9        ;KEY no kazu o 10 sin ni suru
                AND     #00FFH
                JSR     HENKAN          ;16 --> 10
;
                MEM16
                IDX16
                REP     #00110000B
;
                LDA     <WORK+3
                AND     #00FFH
                ORA     #2400H
;// 03.02.08 //		AND	<WORKE
		STA	>IKEY
                LDA     <WORK+4
                AND     #00FFH
                ORA     #2400H
;// 03.02.08 //		AND	<WORKE
		STA	>IKEY+2
;
		MEM8
		IDX8
		SEP	#00110000B
;
		RTS			;NOT TAME BEEM
;----------------------------------------
WTTMBM		EQU	$
		MEM16
		IDX16
		REP	#00110000B
;
		LDA	>MPNWCT
		AND	#00020H
		BNE	WTTMBM2
		BRL	WTTMBMEX1
;
WTTMBM2		EQU	$
		LDA	#00C00H
		STA	<WORKE
		LDA	TMBMCT
		CMP	#00020H
		BCC	WTTMBM21
		LDA	SLMODE
		AND	#000FFH
		CMP	#MD_etcpl
		BEQ	WTTMBM21
		LDA	FRCNT
		AND	#00004H
		BNE	WTTMBM6
WTTMBM21	EQU	$
		LDA	TMBMCT
		BEQ	WTTMBMEX1		;MP = 0?
		LDX	#00000H
		LDA	TMBMCT
		LSR	A
		LSR	A
		BEQ	WTTMBMEX1
		TAY			;n
		LDA	#02082H
		ORA	<WORKE
WTTMBM5		EQU	$		;MP 1 masu 
		STA	>IMP-4,X
		INX
		INX
		DEY
		BNE	WTTMBM5
;
WTTMBMEX	EQU	$
		LDA	TMBMCT
		CMP	#00020H
;		BCC	WTTMBMEX2
		BRA	WTTMBMEX2
		LDA	#020A5H
		ORA     <WORKE
		STA	>IMP-4,X
		LDA	#020A6H
		ORA     <WORKE
		STA	>IMP-2,X
		BRA	WTTMBMEX1
WTTMBMEX2       EQU     $
		LDA	TMBMCT
		LSR	A
		LSR	A
		BCS	WTTMBMEX3
		LDA	#02080H
		ORA     <WORKE
		STA	>IMP-4,X
		LDA	#02081H
		ORA     <WORKE
		STA	>IMP-2,X
		BRA	WTTMBMEX1
WTTMBMEX3	EQU	$
		LDA	#02083H
		ORA     <WORKE
		STA	>IMP-4,X
		LDA	#02084H
		ORA     <WORKE
		STA	>IMP-2,X
		LDA	#02085H
		ORA     <WORKE
		STA	>IMP-0,X
;
WTTMBMEX1	EQU	$
		MEM8
		IDX8
		SEP	#00110000B	; memory,index 8bit mode
;
		RTS
;
WTTMBM6		EQU	$
		MEM16
		IDX16
;
		LDX	#00012H
		LDA	#207FH
WTTMBM7		EQU	$
		STA	>IMP-4,X
		DEX
		DEX
		BPL	WTTMBM7
		BRA	WTTMBMEX1
;
;
WRITEMT		EQU	$		;meta o kaku
		MEM16
		IDX16
;
		LDX	#0000
WTMT1		EQU	$
		LDA	<WORK
		CMP	#0008		;max?
		BCC	WTMT2
		SBC	#0008
		STA	<WORK
		LDY	#0004
		JSR	WTMTSB
		INX
		INX
		BRA	WTMT1
WTMT2		EQU	$
		CMP	#0005		;max-1?
		BCC	WTMT3
		LDY	#0004
		BRA	WTMTSB
WTMT3		EQU	$
		CMP	#0001		;max-2?
		BCC	WTMT4
		LDY	#0002
		BRA	WTMTSB
WTMT4		EQU	$
		RTS
;
;
WTMTSB		EQU	$
		CPX	#0016
		BCC	WTMTSB1
		LDX	#0000
		LDA	<WORK+7
		CLC
		ADC	#0064
		STA	<WORK+7
WTMTSB1		EQU	$
		LDA	[<WORK+10],Y
		TXY
;// 03.02.08 //		AND	<WORKE
		STA	[<WORK+7],Y
		RTS
;
;---
MPMTRDT		EQU	$
		WORD	03CF5H,03CF5H,03CF5H,03CF5H	; 0
		WORD	03CF5H,03CF5H,03CF5H,03C5FH	; 1
		WORD	03CF5H,03CF5H,03CF5H,03C4CH	; 2
		WORD	03CF5H,03CF5H,03CF5H,03C4DH	; 3
		WORD	03CF5H,03CF5H,03CF5H,03C4EH	; 4
		WORD	03CF5H,03CF5H,03C5FH,03C5EH	; 5
		WORD	03CF5H,03CF5H,03C4CH,03C5EH	; 6
		WORD	03CF5H,03CF5H,03C4DH,03C5EH	; 7
		WORD	03CF5H,03CF5H,03C4EH,03C5EH	; 8
		WORD	03CF5H,03C5FH,03C5EH,03C5EH	; 9
		WORD	03CF5H,03C4CH,03C5EH,03C5EH	; A
		WORD	03CF5H,03C4DH,03C5EH,03C5EH	; B
		WORD	03CF5H,03C4EH,03C5EH,03C5EH	; C
		WORD	03C5FH,03C5EH,03C5EH,03C5EH	; D
		WORD	03C4CH,03C5EH,03C5EH,03C5EH	; E
		WORD	03C4DH,03C5EH,03C5EH,03C5EH	; F
		WORD	03C4EH,03C5EH,03C5EH,03C5EH	;10
;
;------------------------------------------------------------------------
MTRDATA		EQU	$
		WORD	0207FH,0207FH,02850H,02851H,02852H,0285BH,0285BH,0285CH
		WORD	0207FH,0207FH,0207FH,0207FH,0207FH,0207FH,0207FH,0207FH
		WORD	0207FH,0207FH,0207FH,0207FH,0207FH,0207FH,0207FH,0207FH
		WORD	0249CH,024ABH,024ACH,0649CH,0207FH,0207FH,0207FH,0207FH
;
		WORD	0207FH,0207FH,02854H,02871H,02858H,0207FH,0207FH,0285DH
		WORD	024A8H,0207FH,0207FH,0207FH,02CA9H,0207FH,0207FH,038A7H
		WORD	0207FH,0207FH,0207FH,02871H,0207FH,0207FH,0207FH,0207FH
		WORD	0207FH,0207FH,0207FH,0207FH,0207FH,0207FH,0207FH,0207FH
;
		WORD	0207FH,0207FH,02854H,0304EH,02858H,0207FH,0207FH,0285DH
		WORD	0207FH,0207FH,0207FH,0207FH,0207FH,0207FH,0207FH,0207FH
		WORD	0207FH,0207FH,0207FH,0207FH,0207FH,0207FH,0207FH,0207FH
		WORD	0207FH,0207FH,0207FH,0207FH,0207FH,0207FH,0207FH,0207FH
;
		WORD	0207FH,0207FH,02854H,0305EH,02859H,0A85BH,0A85BH,0A85CH
		WORD	0207FH,0207FH,0207FH,0207FH,0207FH,0207FH,0207FH,0207FH
		WORD	0207FH,0207FH,0207FH,0207FH,0207FH,0207FH,0207FH,0207FH
		WORD	0207FH,0207FH,0207FH,0207FH,0207FH,0207FH,0207FH,0207FH
;
		WORD	0207FH,0207FH,02854H,0305EH,06854H,0207FH,0207FH,0207FH
		WORD	0207FH,0207FH,0207FH,0207FH,0207FH,0207FH,0207FH,0207FH
		WORD	0207FH,0207FH,0207FH,0207FH,0207FH,0207FH,0207FH,0207FH
		WORD	0207FH,0207FH,0207FH,0207FH,0207FH,0207FH,0207FH,0207FH
;
		WORD	0207FH,0207FH,0A850H,02856H,0E850H
MTRDTEN		EQU	$
;
;// 03.01.10 //		WORD	0207FH,0207FH,0207FH,0207FH,024ABH,024ACH,0207FH,0207FH
;// 03.01.10 //		WORD	0207FH,0207FH,0207FH,0207FH,0207FH,0207FH,0207FH,0207FH
;// 03.01.10 //		WORD	0207FH,0207FH,0207FH,0207FH,0207FH,028FAH,028F9H,028F9H
;// 03.01.10 //		WORD	028F9H,028F9H,028F9H,028F9H,028F9H,028F9H,068FAH,0207FH
;// 03.01.10 //;
;// 03.01.10 //		WORD	0207FH,0209DH,0209EH,0207FH,0207FH,0207FH,0207FH,0207FH
;// 03.01.10 //		WORD	0207FH,0207FH,0207FH,0207FH,0207FH,0207FH,0207FH,0207FH
;// 03.01.10 //		WORD	0207FH,0207FH,0207FH,0207FH,0207FH,028FCH,0249BH,020F5H
;// 03.01.10 //		WORD	020F5H,0249CH,020F5H,020F5H,020F5H,020F5H,068FCH,0207FH
;// 03.01.10 //;
;// 03.01.10 //		WORD	0207FH,0209FH,0209FH,0207FH,02CADH,02CAEH,06C57H,02C56H
;// 03.01.10 //		WORD	02C56H,02C56H,02C56H,02C56H,02C56H,02C57H,0207FH,0207FH
;// 03.01.10 //		WORD	0207FH,0207FH,0207FH,0207FH,0207FH,028FCH,020F5H,020F5H
;// 03.01.10 //		WORD	020F5H,020F5H,020F5H,020F5H,020F5H,020F5H,068FCH,0207FH
;// 03.01.10 //;
;// 03.01.10 //		WORD	0207FH,024FDH,024FEH,0207FH,028A8H,0207FH,0207FH,0207FH
;// 03.01.10 //		WORD	0207FH,02CA9H,0207FH,0207FH,0207FH,038A7H,0207FH,0207FH
;// 03.01.10 //		WORD	0207FH,0207FH,0207FH,0207FH,0207FH,0A8FAH,0A8F9H,0A8F9H
;// 03.01.10 //		WORD	0A8F9H,0A8F9H,0A8F9H,0A8F9H,0A8F9H,0A8F9H,0E8FAH,0207FH
;
;
;
;
		MEM8
		IDX8
;************************************************************************
;	FLOOR NOMBER DSP						*	
;************************************************************************	
;
FLNODTH		EQU	$
;			;   1:     2:     3:     4:     5:     6:     7:     8:     9:     0:
		WORD	02508H,02509H,02509H,0250AH,0250BH,0250CH,0250DH,0251DH,0E51CH,0250EH
FLNODTL		EQU	$
		WORD	02518H,02519H,0A509H,0251AH,0251BH,0251CH,02518H,0A51DH,0E50CH,0A50EH
;
;
FLNODSP		EQU	$
		MEM16
		IDX16
		REP	#00110000B		; memory,index 16bit mode
;
		LDA	!FLNODFG
		AND	#000FFH
		BEQ	FLNOCLS			; display ?
;						; yes
		INC	A
		CMP	#000C0H
		BNE	FNDSP020		; end ?
;						; yes
		LDA	#00000H
FNDSP020	EQU	$
		STA	!FLNODFG
;
		PHB
		PHK
		PLB		; PBR => DBR
;
;// 03.03.19 //;*******************	IFLNO initial start	*********************
;// 03.03.19 //;
;// 03.03.19 //		LDA	#025H			; atoribuut set !
;// 03.03.19 //		STA	>IFLNO+001H
;// 03.03.19 //		STA	>IFLNO+041H
;// 03.03.19 //		STA	>IFLNO+003H
;// 03.03.19 //		STA	>IFLNO+043H
;// 03.03.19 //;
;// 03.03.19 //		LDA	#00FH			; char No set (F) !
;// 03.03.19 //		STA	>IFLNO+002H
;// 03.03.19 //		LDA	#01FH			;
;// 03.03.19 //		STA	>IFLNO+042H
;// 03.03.19 //		LDA	#01EH			;
;// 03.03.19 //		STA	>IFLNO+000H
;// 03.03.19 //		LDA	#020H			; char No set (B) !
;// 03.03.19 //		STA	>IFLNO+040H
;// 03.03.19 //;
;// 03.03.19 //;*******************	IFLNO initial end	*********************
;
;*******************	IFLNO initial start	*********************
		LDA	#0251EH
		STA	>IFLNO+000H
		LDA	#02520H
		STA	>IFLNO+040H
		LDA	#0250FH
		STA	>IFLNO+002H
		LDA	#0251FH
		STA	>IFLNO+042H
;
		LDX	#00000H
		LDA	<FLORNO-1
		BMI	FNDP000			; chika ?
;						; no
		LDA	<FLORNO
		AND	#000FFH
;// 03.03.19 //		ASL	A
;// 03.03.19 //		TAY
;// 03.03.19 //		LDA	FLNODTH,Y
;// 03.03.19 //		STA	>IFLNO,X
;// 03.03.19 //		LDA	FLNODTL,Y
;// 03.03.19 //		STA	>IFLNO+040H,X
;// 03.03.19 //		BRA	FNDP100
		BRA	FNDP050
;
FNDP000		EQU	$			; chika !!!
		INX
		INX
		LDA	<FLORNO
		ORA	#0FF00H
		EOR	#0FFFFH
FNDP050		EQU	$
		ASL	A
		TAY
		LDA	FLNODTH,Y
		STA	>IFLNO,X
		LDA	FLNODTL,Y
		STA	>IFLNO+040H,X
;// 03.03.19 //FNDP100		EQU	$
;
		SEP	#00110000B		; memory,index 8bit mode
;
		PLB		; DBR reset !!
;
		INC	<B3CHFG		; mater display
		RTL
;
;
;************************************************************************
;	FLOOR NOMBER CLEAR						*	
;************************************************************************	
;
FLNOCLS		EQU	$
		LDA	#0007FH
		STA	>IFLNO+000H		
		STA	>IFLNO+040H		
		STA	>IFLNO+002H		
		STA	>IFLNO+042H		
;// 03.03.19 //		LDA	#000H
;// 03.03.19 //		STA	>IFLNO+001H		
;// 03.03.19 //		STA	>IFLNO+041H		
;// 03.03.19 //		STA	>IFLNO+003H		
;// 03.03.19 //		STA	>IFLNO+043H		
;
		MEM8
		IDX8
		SEP	#00110000B		; memory,index 8bit mode
;
		RTL
;
;
;
;
;
		END
