;
		INCLUDE	zel_ram.asm
;
;--------------------------------------------------------------------
;
;		ZELDA-3			1991.10.10(THU)
;
;--------------------------------------------------------------------
;
		ORG	0DDB40H
;
;=============================================== (zel_bg3) ===========
		GLB	MTRDSP,SLITEM,KAIHUKU,KAIMP,BITMCKL
;
		GLB	MTRON2,MTRON3,MTRON4,MTRSUB,ITEMSET,LMPCHCK,ITEM0ST
;
		GLB	STGITRM
;
		GLB	BOMBER,BUMERN,YUMIYA,HANMER
		GLB	ROD001,ROD002,HUEEEE,SCOPUU
		GLB	LAMPUU,KONAAA,BIN001,BIN002
		GLB	BIN003,HUKUUU,SBOMBE,STHAND
		GLB	SGISIN,SOROMN,KAKURE,TRAIFS
;
		GLB	BOMBMAP,BOMBMAX,YAAAMAP,YAAAMAX
;=============================================== (zel_main) ==========
		EXT	VRAMCL,VRAMCL1,JSRSUB
;
		EXT	MD_title,MD_djint,MD_djply,MD_gdint,MD_gdply
		EXT	MD_evint,MD_evply
		EXT	MD_fdout,MD_fdin,MD_etcpl
		EXT	MD_wpout,MD_wpin,MD_ghldn,MD_gover,MD_psrst
;=============================================== (zel_vma) ===========
		EXT	DJBGWT,VDTWT,WBUFS0,WBUFS1
;
		EXT	VT01
;
		EXT	bgw1,bgw8
;=============================================== (zel_data0) =========
		EXT	BITCD0
;=============================================== (zel_char) ==========
		EXT	CHSCHNG
		EXT	B3CGSET,MAPCGSET,MAPOBSET
		EXT	PWTRCGS0
;=============================================== (zel_init) ==========
		EXT	DARKDT
;
		EXT	p1_move,p1_scl0,p1_scl1,p1_bchg,p1_dopn,p1_sdop
		EXT	p1_stpc,p1_hldn,p1_mcng,p1_opyk,p1_bmbd,p1_ltwp
;=============================================== (zel_comn) ==========
		EXT	LGTWPMV
;=============================================== (zel_bgwt) ==========
		EXT	CGEDP0,CGEDPT
;=============================================== (zel_play) ==========
		EXT	SWMD
;=============================================== (zel_rmdt) ==========
		EXT	DJNDT
;=====================================================================
;
		EXTEND
;
		MEM8
		IDX8
;
;
;
;************************************************************************
;*		item NO.						*
;************************************************************************
BOMBER		EQU	001
BUMERN		EQU	002
YUMIYA		EQU	003
HANMER		EQU	004
ROD001		EQU	005
ROD002		EQU	006
HUEEEE		EQU	007
SCOPUU		EQU	008
LAMPUU		EQU	009
KONAAA		EQU	010
BIN001		EQU	011
BIN002		EQU	012
BIN003		EQU	013
HUKUUU		EQU	014
SBOMBE		EQU	015
STHAND		EQU	016
SGISIN		EQU	017
SOROMN		EQU	018
KAKURE		EQU	019
TRAIFS		EQU	020
;
HARTMAX		EQU	020
;************************************************************************
;*		Mater display				(MTRDSP)	*
;************************************************************************
BOMBMAP		EQU	$
		BYTE	010H,015H,020H,025H,030H,035H,040H,050H
BOMBMAX		EQU	$
		BYTE	0010,0015,0020,0025,0030,0035,0040,0050
;
YAAAMAP		EQU	$
		BYTE	030H,035H,040H,045H,050H,055H,060H,070H
YAAAMAX		EQU	$
		BYTE	0030,0035,0040,0045,0050,0055,0060,0070
;
HARTARM		EQU	$
;			0    1    2    3    4    5    6    7    8
		BYTE	009H,009H,009H,009H,009H,009H,009H,009H,011H
;			9    10   11   12   13   14   15   16   17
		BYTE	011H,011H,011H,011H,011H,011H,019H,019H,019H
;			18   19   20
		BYTE	019H,019H,019H
;
MTRDSP		EQU	$
		PHB
		PHK
		PLB			; (DBR) set
;
		LDA	!ITEMMD
		BEQ	MTRDSPGO	;
;					;
		PLB
		RTL
;
ITEM0ST		EQU	$		;ITEM 0 ni natta toki ni yobu
		PHB
		PHK
		PLB			; (DBR) set
;
		JSR	BITMCK
		JSR	DATTEN
		JSR	MTRON0
		SEP	#00110000B
		STZ	ITEMMD
;					;
		PLB
		RTL
;
MTRDSPGO	EQU	$
;
MTRDSP0		EQU	$
		LDA	>UPMPCT		;MP
		BEQ	MTRDSP2
;
		LDA	>MPNWCT
		CMP	#080H		;? max
		BCC	MTRDSP1
		LDA	#080H		;y
		STA	>MPNWCT
		LDA	#000H
		STA	>UPMPCT
		BRA	MTRDSP2
MTRDSP1		EQU	$
		LDA	>UPMPCT		;MP UP!
		DEC	A
		STA	>UPMPCT
		LDA	>MPNWCT
		INC	A
		STA	>MPNWCT
;
		LDA	<FRCNT
		AND	#003H
		BNE	MTRDSP2
;
		LDA	SOUND2
		BNE	MTRDSP2
		LDA	#02DH
		STA	SOUND2
;
MTRDSP2		EQU	$
		MEM16			;COIN
		IDX16
		REP	#00110000B
;
		LDA	>CONPRT
		CMP	>CONCNT
		BEQ	MTRDSP3
;
		BMI	MTR022
		DEC	A
		BPL	MTR024		;- CHK
		LDA	#00000
		STA	>CONCNT
		BRA	MTR024
MTR022		EQU	$
		INC	A
		CMP	#1000		;MAX CHK
		BCC	MTR024
		LDA	#0999
		STA	>CONCNT
MTR024		EQU	$
		STA	>CONPRT
;
		MEM8
		IDX8
		SEP	#00110000B
;
		LDA	SOUND2
		BNE	MTRDSP3
;
;;		LDA	<FRCNT
		LDA	COSDCT
		INC	COSDCT
		AND	#007H
		BNE	MTRDSP4
;
		LDA	#029H		;OTO
		STA	SOUND2			; <sound3>
;
		BRA	MTRDSP4
MTRDSP3		EQU	$
		MEM8
		IDX8
		SEP	#00110000B
;
		STZ	COSDCT
MTRDSP4		EQU	$		;BOMB
		LDA	>UPBMCT
		BEQ	MTRDSP5
		LDA	>UPBMCT
		DEC	A
		STA	>UPBMCT
		LDA	>ITEMR49
		TAY
		LDA	>BMBCNT
		CMP	BOMBMAX,Y
		BEQ	MTR045
		INC	A
		STA	>BMBCNT
MTR045		EQU	$
;
MTRDSP5		EQU	$		;YA
		LDA	>UPAWCT
		BEQ	MTRDSP6
		LDA	>UPAWCT
		DEC	A
		STA	>UPAWCT
		LDA	>ITEMR50
		TAY
		LDA	>ARWCNT
		CMP	YAAAMAX,Y
		BEQ	MTR055
		INC	A
		STA	>ARWCNT
;
MTR055		EQU	$
		LDA	>ITEMR01
		BEQ	MTRDSP6		;? YUMI NASHI
;					;N
		AND	#001H
		CMP	#001H		;? YA NASHI
		BNE	MTRDSP6
;					;Y
		LDA	>ITEMR01
		INC	A
		STA	>ITEMR01	;YA ON
;
		JSL	>ITEM0ST
;
MTRDSP6		EQU	$
		LDA	PYALSP
		BNE	MTR065
		LDA	>UPLFCT
		BNE	MTR065
		LDA	>LFITCT
		LSR	A
		LSR	A
		LSR	A
		TAX
		LDA	>LFNWCT
		CMP	HARTARM,X
		BCS	MTR065
;
		LDA	HRTSCT
		BNE	MTR068
;
		LDA	SOUND2
		BNE	MTR065
		LDA	#020H
		STA	HRTSCT
		LDA	#02BH		;OTO
		STA	SOUND2			; <sound2>
MTR068		EQU	$
		DEC	HRTSCT
;
MTR065		EQU	$
		LDA	KAIFLG
		BNE	MTRDSP8
		LDA	>UPLFCT
		BEQ	MTRDSP9
		LDA	>LFNWCT
		CMP	>LFITCT
		BCC	MTRDSP7
		LDA	>LFITCT
		STA	>LFNWCT
		LDA	#000H
		STA	>UPLFCT
		BRA	MTRDSP9
MTRDSP7		EQU	$
		LDA	>LFNWCT		;LIFE kaihuku
		CLC
		ADC	#0008
		STA	>LFNWCT
;
		LDA	SOUND3
		BNE	MTRDSP72
		LDA	#00DH		;OTO
		STA	SOUND3			; <sound3>
MTRDSP72	EQU	$
;
		LDA	>LFNWCT
		CMP	>LFITCT
		BCC	MTRDSP70
		LDA	>LFITCT
		STA	>LFNWCT
MTRDSP70	EQU	$
;
		LDA	>UPLFCT
		SEC
		SBC	#008H
		STA	>UPLFCT
		INC	KAIFLG
		LDA	#007H
		STA	KAICNT
;
MTRDSP8		EQU	$
;
		MEM16
		IDX16
		REP	#00110000B
;
		LDA	#0FFFFH
		STA	<WORK+0EH
		JSR	MPWT		;MP COIN BOMB YA WRITE
		JSR	KAIHUKU1
;
		MEM8
		IDX8
		SEP	#00110000B
;
		INC	<B3CHFG		; mater write flag on
;
		PLB			; (DBR) reset
		RTL
;
MTRDSP9		EQU	$
;
		MEM16
		IDX16
		REP	#00110000B
;
		LDA	#0FFFFH
		STA	<WORK+0EH
		JSR	LIFEWT		;LIFE MP COIN BOMB YA WRITE
;
		MEM8
		IDX8
		SEP	#00110000B
;
		INC	<B3CHFG		; mater write flag on
;
		PLB			; (DBR) reset
		RTL
;
;
;
;************************************************************************
;*		Select ITEM	main			(SLITEM)	*
;************************************************************************
SLITEM		EQU	$
		PHB
		PHK
		PLB			; (DBR) set
;
		JSR	SLITMSB2
;
		PLB			; (DBR) reset
		RTL
;
;
ITEMSET		EQU	$
		JSR	ITEMS00
		RTL
;
;
;
SLITMSB2	EQU	$
		INC	IFRCNT0		; item frcnt 0
;
		LDA	!ITEMMD
		JSL	>JSRSUB
		WORD	SLITM100	;0  : init - 0
		WORD	SLITM300	;1  :      - 1
		WORD	SLITM700	;2  : scroll
		WORD	WAITMV		;3  : wait
		WORD	BMOVE		;4  : B move
		WORD	DATTEN		;5  : exit
		WORD	SLITM900	;6  : scroll
;					;   : bin select
		WORD	BINSCT10	;7  : init
		WORD	BINSCT20	;8  : kuro nuri
		WORD	BINSCT30	;9  : waku write
		WORD	BINSCT40	;A  : select
		WORD	BINSCT50	;B  : nuki nuri
		WORD	BINSCT60	;B  : moto ni modosu
;
SLITM100	EQU	$
		MEM16
		REP	#00100000B	; memory 16bit mode
;
		LDX	#000H
		LDA	#0207FH
SLITM120	EQU	$
		STA	!WBGBUF+000H,X
		STA	!WBGBUF+080H,X
		STA	!WBGBUF+100H,X
		STA	!WBGBUF+180H,X
		STA	!WBGBUF+200H,X
		STA	!WBGBUF+280H,X
		STA	!WBGBUF+300H,X
		STA	!WBGBUF+380H,X
		STA	!WBGBUF+400H,X
		STA	!WBGBUF+480H,X
		STA	!WBGBUF+500H,X
		STA	!WBGBUF+580H,X
		STA	!WBGBUF+600H,X
		STA	!WBGBUF+680H,X
		STA	!WBGBUF+700H,X
		STA	!WBGBUF+780H,X
		INX
		INX
		CPX	#080H
		BNE	SLITM120	; clear end ?
;					; yes
		MEM8
		SEP	#00100000B	; memory 8bit mode
;
		LDA	#011H
		STA	!SOUND3		; <sound3>
;
		LDA	#bgw1
		STA	<BGWTFG
		LDA	#022H
		STA	!NXBWFG
		INC	!ITEMMD
		RTS
;
;
SLITM300	EQU	$
		JSR	BITMCK		;ITEM CHK
;
		LDA	#01
		JSR	WAKUTEN		;tenmetu color
		JSR	WTWAKU1
		LDA	#01
		JSR	WAKUTEN		;tenmetu color
		JSR	WTWAKU2
		LDA	#01
		JSR	WAKUTEN		;tenmetu color
		JSR	WTWAKU3
;		LDA	#01
;		JSR	WAKUTEN		;tenmetu color
		JSR	WTWAKU4I
;		LDA	#01
;		JSR	WAKUTEN		;tenmetu color
		JSR	WTWAKU5
;		LDA	#01
;		JSR	WAKUTEN		;tenmetu color
;		JSR	WTWAKU6
;		LDA	#01
;		JSR	WAKUTEN		;tenmetu color
		JSR	WTWAKU7I
;		LDA	#01
;		JSR	WAKUTEN		;tenmetu color
		JSR	WTWAKU8I
		LDA	#01
		JSR	WAKUTEN		;tenmetu color
		JSR	WTWAKU9
;		LDA	#01
;		JSR	WAKUTEN		;tenmetu color
		JSR	WTWAKUAI
;		LDA	#01
;		JSR	WAKUTEN		;tenmetu color
		JSR	WTWAKUBI
;		LDA	#01
;		JSR	WAKUTEN		;tenmetu color
		JSR	WTWAKUCI
;		LDA	#01
;		JSR	WAKUTEN		;tenmetu color
		JSR	WTWAKUDI
;
		LDX	#018
		LDA	>ITEMR01
SLITM330	EQU	$
		ORA	>ITEMR02,X
		DEX
		BPL	SLITM330
		CMP	#000H
		BEQ	SLITM320	;? NO ITEM
;					;N
		LDA	>BINCT0
		ORA	>BINCT1
		ORA	>BINCT2
		ORA	>BINCT3
		BNE	SLITM350
		BRA	SLITM360	;CLS
SLITM350	EQU	$
		LDA	>ITEMR16
		BNE	SLITM340	;? HAGIMETE
		TAY			;Y
		INY	
		LDA	>BINCT0
		BNE	SLITM370
		INY	
		LDA	>BINCT1
		BNE	SLITM370
		INY	
		LDA	>BINCT2
		BNE	SLITM370
		INY
SLITM370	EQU	$
		TYA
SLITM360	EQU	$
		STA	>ITEMR16
SLITM340	EQU	$
		JSR	BMVSP1
		BCS	SLITM310
		JSR	BMVSP3RT
SLITM310	EQU	$
;		LDA	#01
;		JSR	WAKUTEN		;tenmetu color
;		JSR	WTWAKU1
		JSR	WTWAKU12I
		LDA	GETITM0		;? ITEM BIN SELECT
		CMP	#016
		BNE	SLITM320
		LDA	#01
		JSR	WAKUTEN		;tenmetu color
		JSR	WTBINST		; BIN SELECT
;
SLITM320	EQU	$
		LDA	#010H
		STA	IFRCNT1
		LDA	#bgw1
		STA	<BGWTFG
		LDA	#022H
		STA	!NXBWFG
		INC	!ITEMMD
		RTS
;
;
;// 03.02.14 //SLITM500	EQU	$
;// 03.02.14 //;// 03.02.08 //		JSR	MTROFF		; mater off
;// 03.02.14 //;
;// 03.02.14 //		INC	!ITEMMD
;// 03.02.14 //		RTS
;
;
SLITM700	EQU	$
		MEM16
		REP	#00100000B	; memory 16bit mode
;
		LDA	<SCCV3
		SEC
		SBC	#00008H
		STA	<SCCV3
;// 03.10.10 //		CMP	#0FF20H
		CMP	#0FF18H
;
		MEM8
		SEP	#00100000B	; memory 8bit mode
;
		BNE	SLITM720	; 1st. scroll end ?
;					; yes
		INC	!ITEMMD
SLITM720	EQU	$
		RTS
;
;
WAITMV		EQU	$
		LDX	#018
		LDA	>ITEMR01
WAITMV40	EQU	$
		ORA	>ITEMR02,X
		DEX
		BPL	WAITMV40
		CMP	#000H
		BEQ	WAITMV20
		LDA	#bgw1		;consol write
		STA	<BGWTFG
		LDA	#022H
		STA	!NXBWFG
		JSR	BMVSP1
		BCS	WAITMV30
		JSR	BMVSP3RT
WAITMV30	EQU	$
		JSR	WTWAKU12I
		LDA	#004H
		STA	!ITEMMD
;
		LDA	GETITM0		;?ITEM BIN SELECT
		CMP	#016
		BNE	WAITMV50
		LDA	#00AH
		STA	ITEMMD
		
WAITMV50	EQU	$
		RTS
WAITMV20	EQU	$
		LDA	<KEYA2
		BEQ	WAITMV10
		LDA	#005H
		STA	!ITEMMD
		RTS
;
WAITMV10	EQU	$
;// 03.09.10 //		JMP	PSRSCK		; pause-reset check
		RTS
;
;
BMVSP1		EQU	$		;MOTTE IRU ITEM GA ARUKA ?
		LDX	GETITM0
		LDA	>ITEMR01-1,X
		BNE	BMVSP110
		CLC			;N
		RTS
BMVSP110	EQU	$		;Y
		SEC
		RTS
;
;
BMVSP2LT	EQU	$		; <<
		LDA	GETITM0
		DEC	A
		CMP	#001H
		BCS	BMVSP2L1
		LDA	#020
BMVSP2L1	EQU	$
		STA	GETITM0
		RTS
;
;
BMVSP2RT	EQU	$		; >>
		LDA	GETITM0
		INC	A
		CMP	#021
		BCC	BMVSP2R1
		LDA	#001H
BMVSP2R1	EQU	$
		STA	GETITM0
		RTS
;
;
BMVSP3LT	EQU	$		; << (WHILE)
		JSR	BMVSP2LT
		JSR	BMVSP1
		BCC	BMVSP3LT
		RTS
;
;
BMVSP3RT	EQU	$		; >> (WHILE)
		JSR	BMVSP2RT
		JSR	BMVSP1
		BCC	BMVSP3RT
		RTS
;
;
BMVSP3UP	EQU	$		; << (WHILE)
		JSR	BMVSP2LT
		JSR	BMVSP2LT
		JSR	BMVSP2LT
		JSR	BMVSP2LT
		JSR	BMVSP2LT
		JSR	BMVSP1
		BCC	BMVSP3UP
		RTS
;
;
BMVSP3DN	EQU	$		; >> (WHILE)
		JSR	BMVSP2RT
		JSR	BMVSP2RT
		JSR	BMVSP2RT
		JSR	BMVSP2RT
		JSR	BMVSP2RT
		JSR	BMVSP1
		BCC	BMVSP3DN
		RTS
;
;
BMOVE		EQU	$
		INC	IFRCNT1		; item frcnt 1
;
		LDA	<KEYA1		;TEST
		BNE	BMOVE30
		STZ	<WORKZ
BMOVE30		EQU	$
;
		LDA	<KEYA2
		AND	#00010000B
		BEQ	BMOVE20
;// 03.02.14 //		LDA	#06H
		LDA	#005H
		STA	!ITEMMD
		LDA	#012H
		STA	!SOUND3		; <sound3>
		RTS
;
BMOVE20		EQU	$
BMOVE0		EQU	$
		LDA	<WORKZ		;TEST
		BNE	BMOVE4
;
		LDA	GETITM0
		STA	<WORK0
;
		LDA	<KEYB2L		;UP ?
		AND	#010H
		BEQ	BMOVE6		;test BMOVE1
		LDX	GETITM0
		LDA	#000H
		STA	>ITEMR01-1,X
		BRA	BMOVEEX
BMOVE6		EQU	$
		LDA	<KEYA2		;UP ?
		AND	#008H
		BEQ	BMOVE1
		JSR	BMVSP3UP
		BRA	BMOVEEX
BMOVE1		EQU	$
		LDA	<KEYA2
		AND	#004H
		BEQ	BMOVE2
		JSR	BMVSP3DN
		BRA	BMOVEEX
BMOVE2		EQU	$
		LDA	<KEYA2
		AND	#002H
		BEQ	BMOVE3
		JSR	BMVSP3LT
		BRA	BMOVEEX
BMOVE3		EQU	$
		LDA	<KEYA2
		AND	#001H
		BEQ	BMOVE4
		JSR	BMVSP3RT
BMOVEEX		EQU	$
		LDA	<KEYA2
		STA	<WORKZ		;TEST
;
		LDA	GETITM0
		CMP	<WORK0
		BEQ	BMOVE4
;
		LDA	#010H		;consol on
		STA	IFRCNT1
		LDA	#020H		;OTO
		STA	SOUND3
BMOVE4		EQU	$
		LDA	#01		; waku 1 to B item o on
		JSR	WAKUTEN
		JSR	WTWAKU1
		JSR	WTWAKU12I
;
		LDA	GETITM0		;?ITEM BIN01
		CMP	#016
		BNE	BMOVE5
		LDA	#007H		;BIN SELECT
		STA	ITEMMD
;
BMOVE5		EQU	$
;
		LDA	#bgw1
		STA	<BGWTFG
		LDA	#022H		;BG ni kaku
		STA	!NXBWFG
;// 03.09.10 //PSRSCK		EQU	$
;// 03.09.10 //		LDA	<KEYA1+1
;// 03.09.10 //		AND	#00110000B
;// 03.09.10 //		CMP	#00110000B
;// 03.09.10 //		BNE	PSRSC80		; selelct,start on ?
;// 03.09.10 //;					; yes
;// 03.09.10 //		LDA	<KEYA1L+1
;// 03.09.10 //		AND	#00110000B
;// 03.09.10 //		CMP	#00110000B
;// 03.09.10 //		BNE	PSRSC80		; pause reset ?
;// 03.09.10 //;					; yes
;// 03.09.10 //		MEM16
;// 03.09.10 //		REP	#00100000B	; memory 16bit mode
;// 03.09.10 //;
;// 03.09.10 //		LDA	#00000H
;// 03.09.10 //		STA	>CGWORK+000H
;// 03.09.10 //		LDA	>CGRAM+040H
;// 03.09.10 //		STA	>CGWORK+040H
;// 03.09.10 //;
;// 03.09.10 //		STZ	!ITEMMD
;// 03.09.10 //;
;// 03.09.10 //		MEM8
;// 03.09.10 //		SEP	#00100000B	; memory 8bit mode
;// 03.09.10 //;
;// 03.09.10 //		LDA	#000H
;// 03.09.10 //		STA	>LFNWCT		; heart off
;// 03.09.10 //		JSL	>MTRDSP
;// 03.09.10 //;
;// 03.09.10 //		STZ	!FLNODFG
;// 03.09.10 //		JSL	>FLNODSP	; floor no. off
;// 03.09.10 //		INC	<B3CHFG
;// 03.09.10 //;
;// 03.09.10 //		LDA	#MD_psrst
;// 03.09.10 //		STA	<SLMODE
;// 03.09.10 //		STZ	<GAMEMD
;// 03.09.10 //		STZ	<SCCV3
;// 03.09.10 //		STZ	<SCCV31
;// 03.09.10 //		STZ	!BMMODE
;// 03.09.10 //PSRSC80		EQU	$
		RTS
;
;
;
;
DATTEN		EQU	$		; exit
		INC	!ITEMMD
;
		JSR	MTRON1		; mater in write
;
ITEMS00		EQU	$
                LDX     GETITM0		;B item data tfr
		LDA	>BTFRDAT,X
		STA	BPSHMD
;
;		LDA	>YTFRDAT,X
;               STA     YPSHMD
		RTS
;
;
SLITM900	EQU	$
		MEM16
		REP	#00100000B	; memory 16bit mode
;
		LDA	<SCCV3
		CLC
		ADC	#00008H
		STA	<SCCV3
;
		MEM8
		SEP	#00100000B	; memory 8bit mode
;
		BNE	SLITM980	; end ?
;					; yes
		JSR	MTRON0		; mater on
;
		STZ	!ITEMMD		; item select off
		STZ	<GAMEMD		; select item end
		LDA	!NXSLMD
		STA	<SLMODE
;
		LDA	<GAMEMD
		BEQ	SLITM920	; danjyon ?
;					; yes
		JSL	>LMPCHCK	; lamp on/off check
SLITM920	EQU	$
		LDA	!BPSHMD
;// 02.10.22 //		CMP	#002H
		CMP	#ROD001
		BEQ	SLITM940	; lot select ?
;					; no
		CMP	#ROD002
		BEQ	SLITM940	; lot select ?
;					; no
;		CMP	#ROD003
;		BEQ	SLITM940	; lot select ?
;					; no
		LDA	#002H	
		STA	!TMDTFG
		STZ	!TMBMCT
		BRA	SLITM980
SLITM940	EQU	$
		LDA	TMBMCT
		BNE	SLITM900
		
		STZ	!TMDTFG
SLITM980	EQU	$
		RTS
;
;
;************************************************************************
;*		YAMAMOTO SUB P.						*
;************************************************************************
BINSCT10	EQU	$
		STZ	IWORK0		;INIT CNT
;
		INC	ITEMMD
		RTS
;----------------------------------------
BINSCT20	EQU	$
		MEM16
		IDX16
		REP	#00110000B
;
		LDA	IWORK0
		AND	#000FFH
		ASL	A
		ASL	A
		ASL	A
		ASL	A
		ASL	A
		ASL	A
		TAX
		LDA	#NUKIDT
		STA	IWAKU5+000H,X
		STA	IWAKU5+002H,X
		STA	IWAKU5+004H,X
		STA	IWAKU5+006H,X
		STA	IWAKU5+008H,X
		STA	IWAKU5+00AH,X
		STA	IWAKU5+00CH,X
		STA	IWAKU5+00EH,X
		STA	IWAKU5+010H,X
		STA	IWAKU5+012H,X
;
		MEM8
		IDX8
		SEP	#00110000B
;
		INC	IWORK0
		LDA	IWORK0
		CMP	#013H
		BNE	BINSCT25
		INC	ITEMMD
		LDA	#011H		;CLS CNT
		STA	IWORK0
BINSCT25	EQU	$
		LDA	#bgw1
		STA	<BGWTFG
		LDA	#022H
		STA	!NXBWFG
		RTS
;----------------------------------------
BINSCT3D	EQU	$
		WORD	028FBH,028F9H,028F9H,028F9H
		WORD	028F9H,028F9H,028F9H,028F9H
		WORD	028F9H,068FBH
;
		WORD	028FCH,KURODT,KURODT,KURODT
		WORD	KURODT,KURODT,KURODT,KURODT
		WORD	KURODT,068FCH
;
		WORD	0A8FBH,0A8F9H,0A8F9H,0A8F9H
		WORD	0A8F9H,0A8F9H,0A8F9H,0A8F9H
		WORD	0A8F9H,0E8FBH
BINSCT30	EQU	$
		MEM16
		IDX16
		REP	#00110000B
;
		LDA	IWORK0
		AND	#000FFH
		ASL	A
		ASL	A
		ASL	A
		ASL	A
		ASL	A
		ASL	A
		TAX
		PHX
;
		LDY	#00012H
BINSCT37	EQU	$
		LDA	BINSCT3D,Y
		STA	IWAKU5+012H,X
		DEX
		DEX
		DEY
		DEY
		BPL	BINSCT37
;
		PLX
		LDY	#00012H
BINSCT35	EQU	$
		LDA	BINSCT3D+014H,Y
		STA	IWAKU5+040H+012H,X
		DEX
		DEX
		DEY
		DEY
		BPL	BINSCT35
;
		LDX	#00012H
BINSCT39	EQU	$
		LDA	BINSCT3D+028H,X
		STA	IWAKU5+480H,X
		DEX
		DEX
		BPL	BINSCT39
;
		MEM8
		IDX8
		SEP	#00110000B
;
		DEC	IWORK0
		LDA	IWORK0
		BPL	BINSCT33
		INC	ITEMMD
BINSCT33	EQU	$
		LDA	#bgw1
		STA	<BGWTFG
		LDA	#022H
		STA	!NXBWFG
		RTS
;----------------------------------------
BINSCT40	EQU	$
		INC	IFRCNT1		;FRCNT
;
		LDA	<KEYA2
		AND	#00010000B
		BEQ	BINSCT48
		LDA	#012H
		STA	!SOUND3		; <sound3>
		LDA	#005H		;EXIT
		STA	!ITEMMD
		BRA	BINSCT49
;
BINSCT48	EQU	$
		LDA	<KEYA2
		AND	#003H
		BEQ	BINSCT49
;
		LDA	<KEYA2
		AND	#002H
		BEQ	BINSCT43
		JSR	BMVSP3LT
		BRA	BINSCT45
BINSCT43	EQU	$
		LDA	<KEYA2
		AND	#001H
		BEQ	BINSCT4D
		JSR	BMVSP3RT
;		BRA	BINSCT45
BINSCT4D	EQU	$
;		LDA	<KEYA2
;		AND	#008H
;		BEQ	BINSCT4B
;		JSR	BMVSP3UP
;		BRA	BINSCT45
;BINSCT4B	EQU	$
;;		LDA	<KEYA2
;;		AND	#004H
;;		BEQ	BINSCT4C
;		JSR	BMVSP3DN
;;		BRA	BINSCT45
;BINSCT4C	EQU	$
BINSCT45	EQU	$
		LDA	#010H		;consol on
		STA	IFRCNT1
		LDA	#020H		;OTO
		STA	SOUND3
		LDA	#01		; waku 1 to B item o on
		JSR	WAKUTEN
		JSR	WTWAKU1
		JSR	WTWAKU12I
;
		INC	ITEMMD
		STZ	IWORK0		;CLS CNT
		RTS
BINSCT49	EQU	$
		JSR	BINSTS40	;WRITE BG
		LDA	<KEYA2
;		ORA	<KEYA2L
		AND	#00CH
		BNE	BINSCT47
;					;
		RTS
;// 03.09.10 //		JMP	PSRSCK		; pause-reset check
;
BINSCT47	EQU	$
		LDA	>ITEMR16
		DEC	A
		STA	<WORK0
		STA	<WORK2
		LDA	<KEYA2
		AND	#008H
		BEQ	BINSCT44	;? UP
BINSCT4A	EQU	$
		LDA	<WORK0		;Y
		DEC	A
		AND	#003H
		STA	<WORK0
		TAX
		LDA	>BINCT0,X
		BEQ	BINSCT4A
		BRA	BINSCT46
BINSCT44	EQU	$
		LDA	<WORK0		;DOWN
		INC	A
		AND	#003H
		STA	<WORK0
		TAX
		LDA	>BINCT0,X
		BEQ	BINSCT44
BINSCT46	EQU	$
		LDA	<WORK0
		CMP	<WORK2
		BEQ	BINSCT42
		INC	A
		STA	>ITEMR16
;
		LDA	#010H		;CONSOL ON
		STA	IFRCNT1
		LDA	#020H		;OTO
		STA	SOUND3
;
BINSCT42	EQU	$
		RTS
;----------------------------------------;CONSOL WRITE
BNS40CNS	EQU	$
		WORD	00088H,00188H,00288H,00388H
BINSTS40	EQU	$
		MEM16
		IDX16
		REP	#00110000B
;
		LDX	#00000H		;---	KURO
		LDY	#00007H		;
		LDA	#KURODT
BINSTS41	EQU	$
		STA	IWAKU5+042H,X
		STA	IWAKU5+082H,X
		STA	IWAKU5+0C2H,X
		STA	IWAKU5+102H,X
		STA	IWAKU5+142H,X
		STA	IWAKU5+182H,X
		STA	IWAKU5+1C2H,X
		STA	IWAKU5+202H,X
		STA	IWAKU5+242H,X
		STA	IWAKU5+282H,X
		STA	IWAKU5+2C2H,X
		STA	IWAKU5+302H,X
		STA	IWAKU5+342H,X
		STA	IWAKU5+382H,X
		STA	IWAKU5+3C2H,X
		STA	IWAKU5+402H,X
		STA	IWAKU5+442H,X
		INX
		INX
		DEY
		BPL	BINSTS41
;
		LDA	#IWAKU5+088H	;TFR SAKI
		STA	<WORK0
		LDA	>BINCT0		;NO. SET
		AND	#000FFH
		STA	<WORK2
		LDA	#RITEM29	;TFR MOTO 
		STA	<WORK4
		JSR	SETITEM		;SET ITEM
;
;					;BIN2 SET
		LDA	#IWAKU5+188H	;TFR SAKI
		STA	<WORK0
		LDA	>BINCT1		;NO. SET
		AND	#000FFH
		STA	<WORK2
		LDA	#RITEM30	;TFR MOTO 
		STA	<WORK4
		JSR	SETITEM		;SET ITEM
;
;					;BIN3 SET
		LDA	#IWAKU5+288H	;TFR SAKI
		STA	<WORK0
		LDA	>BINCT2		;NO. SET
		AND	#000FFH
		STA	<WORK2
		LDA	#RITEM31	;TFR MOTO 
		STA	<WORK4
		JSR	SETITEM		;SET ITEM
;
;
		LDA	#IWAKU5+388H	;TFR SAKI
		STA	<WORK0
		LDA	>BINCT3		;NO. SET
		AND	#000FFH
		STA	<WORK2
		LDA	#RITEM32	;TFR MOTO 
		STA	<WORK4
		JSR	SETITEM		;SET ITEM
;
;
		LDA	#WITEM16	;TFR SAKI
		STA	<WORK0
		LDA	>ITEMR16	;NO. SET
		AND	#000FFH
		TAX
		BNE	BINSTS44
		LDA	#00000H
		BRA	BINSTS45
BINSTS44	EQU	$
		LDA	>BINCT0-1,X
		AND	#000FFH
BINSTS45	EQU	$
		STA	<WORK2
		LDA	#RITEM16	;TFR MOTO 
		STA	<WORK4
		JSR	SETITEM		;SET ITEM
;
;
		LDA	GETITM0		;WAKU2 WRITE
		AND	#000FFH
		DEC	A
		ASL	A
		TAX
		LDY	STGITWM,X
		LDA	WBGBUF-WBGBUF,Y
		STA	IWAKU2+48H
		LDA	WBGBUF-WBGBUF+002H,Y
		STA	IWAKU2+4AH
		LDA	WBGBUF-WBGBUF+040H,Y
		STA	IWAKU2+88H
		LDA	WBGBUF-WBGBUF+042H,Y
		STA	IWAKU2+8AH
;
;
		LDA	>ITEMR16
		DEC	A
		AND	#000FFH
		ASL	A
		TAY
		LDA	BNS40CNS,Y
		TAY
;
		LDA	IFRCNT1
		AND	#010H
		BEQ	BINSTS49
		LDA	#03C61H		;consol set
		STA	IWAKU5-40H,Y
		ORA	#04000H
		STA	IWAKU5-3EH,Y
		LDA	#03C70H
		STA	IWAKU5-02H,Y
		ORA	#04000H
		STA	IWAKU5+04H,Y
		LDA	#0BC70H
		STA	IWAKU5+3EH,Y
		ORA	#04000H
		STA	IWAKU5+44H,Y
		LDA	#0BC61H
		STA	IWAKU5+80H,Y
		ORA	#04000H
		STA	IWAKU5+82H,Y
		LDA	#03C60H
		STA	IWAKU5-42H,Y
		ORA	#04000H
		STA	IWAKU5-3CH,Y
		ORA	#08000H
		STA	IWAKU5+84H,Y
		EOR	#04000H
		STA	IWAKU5+7EH,Y
;
;
		LDA	>ITEMR16
		AND	#000FFH
		BEQ	BINSTS43
		TAX
		LDA	>BINCT0-1,X
		AND	#000FFH
		DEC	A
;		BEQ	BINSTS43
;		DEC	A		;pri. ok
		ASL	A
		ASL	A
		ASL	A
		ASL	A
		ASL	A
		TAX
		LDY	#00000H
BINSTS42	EQU	$
		LDA	BINMOJI,X
		STA	!IWAKU2+0C2H,Y
		LDA	BINMOJI+10H,X
		STA	!IWAKU2+102H,Y
		INX
		INX
		INY
		INY
		CPY	#00010H
		BCC	BINSTS42
BINSTS43	EQU	$
;
;
BINSTS49	EQU	$
		MEM8
		IDX8
		SEP	#00110000B
;
		LDA	#bgw1
		STA	<BGWTFG
		LDA	#022H
		STA	!NXBWFG
		RTS
;----------------------------------------
BINSCT50	EQU	$
		MEM16
		IDX16
		REP	#00110000B
;
		LDA	IWORK0
		AND	#000FFH
		ASL	A
		ASL	A
		ASL	A
		ASL	A
		ASL	A
		ASL	A
		TAX
		LDA	#NUKIDT
		STA	IWAKU5+000H,X
		STA	IWAKU5+002H,X
		STA	IWAKU5+004H,X
		STA	IWAKU5+006H,X
		STA	IWAKU5+008H,X
		STA	IWAKU5+00AH,X
		STA	IWAKU5+00CH,X
		STA	IWAKU5+00EH,X
		STA	IWAKU5+010H,X
		STA	IWAKU5+012H,X
;
		MEM8
		IDX8
		SEP	#00110000B
;
		INC	IWORK0
		LDA	IWORK0
		CMP	#013H
		BNE	BINSCT55
		INC	ITEMMD
BINSCT55	EQU	$
		LDA	#bgw1
		STA	<BGWTFG
		LDA	#022H
		STA	!NXBWFG
		RTS
;----------------------------------------
BINSCT60	EQU	$
		JSR	WTWAKU5
;		LDA	#01
;		JSR	WAKUTEN		;tenmetu color
;		JSR	WTWAKU6
;		LDA	#01
;		JSR	WAKUTEN		;tenmetu color
		JSR	WTWAKU7I
;		LDA	#01
;		JSR	WAKUTEN		;tenmetu color
		JSR	WTWAKU8I
		LDA	#01
		JSR	WAKUTEN		;tenmetu color
		JSR	WTWAKU9
;		LDA	#01
;		JSR	WAKUTEN		;tenmetu color
		JSR	WTWAKUAI
;		LDA	#01
;		JSR	WAKUTEN		;tenmetu color
		JSR	WTWAKUBI
;		LDA	#01
;		JSR	WAKUTEN		;tenmetu color
		JSR	WTWAKUCI
;		LDA	#01
;		JSR	WAKUTEN		;tenmetu color
		JSR	WTWAKUDI
;
		LDA	#004H		;B ITEM SELECT
		STA	ITEMMD
		LDA	#bgw1
		STA	<BGWTFG
		LDA	#022H
		STA	!NXBWFG
		RTS
;----------------------------------------
SETITEM		EQU	$
;
;		<WORK0,1 : TFR SAKI SET
;
;		<WORK2,3 : NO. SET(NANBANME)
;
;		<WORK4,5 : TFR MOTO
;
;
		MEM16
		IDX16
;
		LDA	<WORK2		;TFR MOTO GET
		ASL	A
		ASL	A
		ASL	A
		TAY
;
		LDX	<WORK0		;TFR SAKI SET
;
		LDA	(<WORK4),Y
		STA	WBGBUF-WBGBUF+000H,X
		INY
		INY
		LDA	(<WORK4),Y
		STA	WBGBUF-WBGBUF+002H,X
		INY
		INY
		LDA	(<WORK4),Y
		STA	WBGBUF-WBGBUF+040H,X
		INY
		INY
		LDA	(<WORK4),Y
		STA	WBGBUF-WBGBUF+042H,X
;
		RTS
;
		MEM8
		IDX8
;
;
;----------------------------------------
;
;
;
BITMCKL		EQU	$		;JSL BITMCK
		JSR	BITMCK
		RTL
;---
BITMCK		EQU	$		;item ga nakanatta yooon
		MEM8
		IDX8
		SEP	#00110000B
;
		LDX	#018
		LDA	>ITEMR01
BITMCK4		EQU	$
		ORA	>ITEMR02,X
		DEX
		BPL	BITMCK4
		CMP	#000H
		BNE	BITMCK1
		STZ	GETITM0
		STZ	GETITM0+1
		STZ	GETITM0+2
BITMCK3		EQU	$
		RTS
BITMCK1		EQU	$
		LDA	GETITM0
		BNE	BITMCK2
		LDA	#001H
		STA	GETITM0
BITMCK2		EQU	$
		JSR	BMVSP1
		BCS	BITMCK3
		JMP	BMVSP3RT
;
;
WAKUTEN		EQU	$
		MEM8
		IDX8
		SEP	#00110000B
;
		LDX	#0E3H		;A<>0 -- WORK+1=8
		CMP	#000		;
		BEQ	WAKUTEN2	;waku no tenmetu
		LDX	#0FFH		;
WAKUTEN2	EQU	$
		STX	<WORK+1
		LDA	#0FFH
		STA	<WORK
		RTS
;
;
WTWAKU1		EQU	$		;waku 1 o kaku
		MEM16
		IDX16
		REP	#00110000B
;
		LDA	#03CFBH		;KADO
		AND	<WORK		; iro
		STA	!IWAKU1		;[
		ORA	#08000H
		STA	!IWAKU1+380H	;[
		ORA	#04000H
		STA	!IWAKU1+3A4H	;]
		EOR	#08000H
		STA	!IWAKU1+024H	;]
;
		LDX	#00000H		;|	TATE
		LDY	#0000CH		;|
WTWK110		EQU	$
		LDA	#03CFCH
		AND	<WORK		; iro
		STA	!IWAKU1+040H,X
		ORA	#04000H
		STA	!IWAKU1+064H,X
		TXA
		CLC
		ADC	#00040H
		TAX
		DEY
		BPL	WTWK110
;
		LDX	#00000H		;---	YOKO
		LDY	#00010H		;
WTWK120		EQU	$
		LDA	#03CF9H
		AND	<WORK		; iro
		STA	!IWAKU1+002H,X
		ORA	#08000H
		STA	!IWAKU1+382H,X
		INX
		INX
		DEY
		BPL	WTWK120
;
		LDX	#00000H		;---	KURO
		LDY	#00010H		;
		LDA	#KURODT
WTWK130		EQU	$
		STA	!IWAKU1+042H,X
		STA	!IWAKU1+082H,X
		STA	!IWAKU1+0C2H,X
		STA	!IWAKU1+102H,X
		STA	!IWAKU1+142H,X
		STA	!IWAKU1+182H,X
		STA	!IWAKU1+1C2H,X
		STA	!IWAKU1+202H,X
		STA	!IWAKU1+242H,X
		STA	!IWAKU1+282H,X
		STA	!IWAKU1+2C2H,X
		STA	!IWAKU1+302H,X
		STA	!IWAKU1+342H,X
		INX
		INX
		DEY
		BPL	WTWK130
;
		LDA	#03CF0H		;Y write
		STA	!IWAKU1+042H
		LDA	#03CF1H
		STA	!IWAKU1+082H
;
		LDA	#0246EH		;ITEM write
		STA	!IWAKU1+004H
		LDA	#0246FH
		STA	!IWAKU1+006H
;
;					;YUMI SET
		LDA	#WITEM01	;TFR SAKI
		STA	<WORK0
		LDA	>ITEMR01	;NO. SET
		AND	#000FFH
		STA	<WORK2
		LDA	#RITEM01	;TFR MOTO 
		STA	<WORK4
		JSR	SETITEM		;SET ITEM
;
;					;BUMERN SET
		LDA	#WITEM02	;TFR SAKI
		STA	<WORK0
		LDA	>ITEMR02	;NO. SET
		AND	#000FFH
		STA	<WORK2
		LDA	#RITEM02	;TFR MOTO 
		STA	<WORK4
		JSR	SETITEM		;SET ITEM
;
;					;HUKKU SET
		LDA	#WITEM03	;TFR SAKI
		STA	<WORK0
		LDA	>ITEMR03	;NO. SET
		AND	#000FFH
		STA	<WORK2
		LDA	#RITEM03	;TFR MOTO 
		STA	<WORK4
		JSR	SETITEM		;SET ITEM
;
;					;BOMB SET
		LDA	#WITEM04	;TFR SAKI
		STA	<WORK0
		LDA	>ITEMR04	;NO. SET
		AND	#000FFH
		BEQ	WTWK140
		LDA	#00001H
WTWK140		EQU	$
		STA	<WORK2
		LDA	#RITEM04	;TFR MOTO 
		STA	<WORK4
		JSR	SETITEM		;SET ITEM
;
;					;KONA &KINOKO SET
		LDA	#WITEM05	;TFR SAKI
		STA	<WORK0
		LDA	>ITEMR05	;NO. SET
		AND	#000FFH
		STA	<WORK2
		LDA	#RITEM05	;TFR MOTO 
		STA	<WORK4
		JSR	SETITEM		;SET ITEM
;
;					;FIRE ROT SET
		LDA	#WITEM06	;TFR SAKI
		STA	<WORK0
		LDA	>ITEMR06	;NO. SET
		AND	#000FFH
		STA	<WORK2
		LDA	#RITEM06	;TFR MOTO 
		STA	<WORK4
		JSR	SETITEM		;SET ITEM
;
;					;ICE ROT SET
		LDA	#WITEM07	;TFR SAKI
		STA	<WORK0
		LDA	>ITEMR07	;NO. SET
		AND	#000FFH
		STA	<WORK2
		LDA	#RITEM07	;TFR MOTO 
		STA	<WORK4
		JSR	SETITEM		;SET ITEM
;
;					;S. BOMB SET
		LDA	#WITEM08	;TFR SAKI
		STA	<WORK0
		LDA	>ITEMR08	;NO. SET
		AND	#000FFH
		STA	<WORK2
		LDA	#RITEM08	;TFR MOTO 
		STA	<WORK4
		JSR	SETITEM		;SET ITEM
;
;					;S. THNDER SET
		LDA	#WITEM09	;TFR SAKI
		STA	<WORK0
		LDA	>ITEMR09	;NO. SET
		AND	#000FFH
		STA	<WORK2
		LDA	#RITEM09	;TFR MOTO 
		STA	<WORK4
		JSR	SETITEM		;SET ITEM
;
;					;S. GISIN SET
		LDA	#WITEM10	;TFR SAKI
		STA	<WORK0
		LDA	>ITEMR10	;NO. SET
		AND	#000FFH
		STA	<WORK2
		LDA	#RITEM10	;TFR MOTO 
		STA	<WORK4
		JSR	SETITEM		;SET ITEM
;
;					;KANTERA SET
		LDA	#WITEM11	;TFR SAKI
		STA	<WORK0
		LDA	>ITEMR11	;NO. SET
		AND	#000FFH
		STA	<WORK2
		LDA	#RITEM11	;TFR MOTO 
		STA	<WORK4
		JSR	SETITEM		;SET ITEM
;
;					;HANMER SET
		LDA	#WITEM12	;TFR SAKI
		STA	<WORK0
		LDA	>ITEMR12	;NO. SET
		AND	#000FFH
		STA	<WORK2
		LDA	#RITEM12	;TFR MOTO 
		STA	<WORK4
		JSR	SETITEM		;SET ITEM
;
;					;SKOPU SET
		LDA	#WITEM13	;TFR SAKI
		STA	<WORK0
		LDA	>ITEMR13	;NO. SET
		AND	#000FFH
		STA	<WORK2
		LDA	#RITEM13	;TFR MOTO 
		STA	<WORK4
		JSR	SETITEM		;SET ITEM
;
;					;OKARINA SET
		LDA	#WITEM14	;TFR SAKI
		STA	<WORK0
		LDA	>ITEMR14	;NO. SET
		AND	#000FFH
		STA	<WORK2
		LDA	#RITEM14	;TFR MOTO 
		STA	<WORK4
		JSR	SETITEM		;SET ITEM
;
;					;SOROMON SET
		LDA	#WITEM15	;TFR SAKI
		STA	<WORK0
		LDA	>ITEMR15	;NO. SET
		AND	#000FFH
		STA	<WORK2
		LDA	#RITEM15	;TFR MOTO 
		STA	<WORK4
		JSR	SETITEM		;SET ITEM
;
;					;BIN select SET
		LDA	#WITEM16	;TFR SAKI
		STA	<WORK0
		LDA	>ITEMR16	;NO. SET
		AND	#000FFH
		TAX
		BNE	WTWK150
		LDA	#00000H
		BRA	WTWK160
WTWK150		EQU	$
		LDA	>BINCT0-1,X
		AND	#000FFH
WTWK160		EQU	$
		STA	<WORK2
		LDA	#RITEM16	;TFR MOTO 
		STA	<WORK4
		JSR	SETITEM		;SET ITEM
;
;					; SET
		LDA	#WITEM17	;TFR SAKI
		STA	<WORK0
		LDA	>ITEMR17	;NO. SET
		AND	#000FFH
		STA	<WORK2
		LDA	#RITEM17	;TFR MOTO 
		STA	<WORK4
		JSR	SETITEM		;SET ITEM
;
;					; SET
		LDA	#WITEM18	;TFR SAKI
		STA	<WORK0
		LDA	>ITEMR18	;NO. SET
		AND	#000FFH
		STA	<WORK2
		LDA	#RITEM18	;TFR MOTO 
		STA	<WORK4
		JSR	SETITEM		;SET ITEM
;
;					;KAKURE MINO SET
		LDA	#WITEM19	;TFR SAKI
		STA	<WORK0
		LDA	>ITEMR19	;NO. SET
		AND	#000FFH
		STA	<WORK2
		LDA	#RITEM19	;TFR MOTO 
		STA	<WORK4
		JSR	SETITEM		;SET ITEM
;
;					;W--P SET
		LDA	#WITEM20	;TFR SAKI
		STA	<WORK0
		LDA	>ITEMR20	;NO. SET
		AND	#000FFH
		STA	<WORK2
		LDA	#RITEM20	;TFR MOTO 
		STA	<WORK4
		JSR	SETITEM		;SET ITEM
;
		MEM8
		IDX8
		SEP	#00110000B
		RTS
;----------------------------------------
WTWAKU2		EQU	$		;waku 2 o kaku
		MEM16
		IDX16
		REP	#00110000B
;
		LDA	#03CFBH		;KADO
		AND	<WORK		; iro
		STA	!IWAKU2		;[
		ORA	#08000H
		STA	!IWAKU2+140H	;[
		ORA	#04000H
		STA	!IWAKU2+152H	;]
		EOR	#08000H
		STA	!IWAKU2+012H	;]
;
		LDX	#00000H		;|	TATE
		LDY	#00003H		;|
WTWK210		EQU	$
		LDA	#03CFCH
		AND	<WORK		; iro
		STA	!IWAKU2+040H,X
		ORA	#04000H
		STA	!IWAKU2+052H,X
		TXA
		CLC
		ADC	#00040H
		TAX
		DEY
		BPL	WTWK210
;
		LDX	#00000H		;---	YOKO
		LDY	#00007H		;
WTWK220		EQU	$
		LDA	#03CF9H
		AND	<WORK		; iro
		STA	!IWAKU2+002H,X
		ORA	#08000H
		STA	!IWAKU2+142H,X
		INX
		INX
		DEY
		BPL	WTWK220
;
		LDX	#00000H		;---	KURO
		LDY	#00007H		;
		LDA	#KURODT
WTWK230		EQU	$
		STA	!IWAKU2+042H,X
		STA	!IWAKU2+082H,X
		STA	!IWAKU2+0C2H,X
		STA	!IWAKU2+102H,X
		INX
		INX
		DEY
		BPL	WTWK230
;
		MEM8
		IDX8
		SEP	#00110000B
		RTS
;
;
WTWAKU3		EQU	$		;waku 3 o kaku
		MEM16
		IDX16
		REP	#00110000B
;
		LDX	#00000H		;---	KURO
		LDY	#00010H		;
		LDA	#KURODT
WTWK330		EQU	$
		STA	!IWAKU3+042H,X
		STA	!IWAKU3+082H,X
		STA	!IWAKU3+0C2H,X
		STA	!IWAKU3+102H,X
		STA	!IWAKU3+142H,X
		STA	!IWAKU3+182H,X
		STA	!IWAKU3+1C2H,X
		INX
		INX
		DEY
		BPL	WTWK330
;
		LDA	>ITMTBL1			;MOJI WRITE
		AND	#0FF00H
		STA	<WORK+2
		LDA	#0003
		STA	<WORK+4
		LDY	#0000
		TYX
WTWK350		EQU	$
		LDA	#0004
		STA	<WORK+6
WTWK360		EQU	$
		ASL	<WORK+2
		BCC	WTWK370
		LDA	YDATA,X
;		AND	#0E3FFH
		STA	!IWAKU3+132-40H,Y
		LDA	YDATA+2,X
;		AND	#0E3FFH
		STA	!IWAKU3+134-40H,Y
		LDA	YDATA+4,X
;		AND	#0E3FFH
		STA	!IWAKU3+136-40H,Y
		LDA	YDATA+6,X
;		AND	#0E3FFH
		STA	!IWAKU3+138-40H,Y
		LDA	YDATA+8,X
;		AND	#0E3FFH
		STA	!IWAKU3+140-40H,Y
		LDA	YDATA+10,X
;		AND	#0E3FFH
		STA	!IWAKU3+132,Y
		LDA	YDATA+12,X
;		AND	#0E3FFH
		STA	!IWAKU3+134,Y
		LDA	YDATA+14,X
;		AND	#0E3FFH
		STA	!IWAKU3+136,Y
		LDA	YDATA+16,X
;		AND	#0E3FFH
		STA	!IWAKU3+138,Y
		LDA	YDATA+18,X
;		AND	#0E3FFH
		STA	!IWAKU3+140,Y
WTWK370		EQU	$
		TXA
		CLC
		ADC	#0014H
		TAX
		TYA
		CLC
		ADC	#00010
		TAY
		DEC	<WORK+6
		BNE	WTWK360
		TYA
		CLC
		ADC	#0005AH
		TAY
		DEC	<WORK+4
		BNE	WTWK350		;end?
;					;y
		LDA	#024FBH		;KADO
		AND	<WORK		; iro
		STA	!IWAKU3		;[
		ORA	#08000H
		STA	!IWAKU3+200H	;[
		ORA	#04000H
		STA	!IWAKU3+224H	;]
		EOR	#08000H
		STA	!IWAKU3+024H	;]
;
		LDX	#00000H		;|	TATE
		LDY	#00006H		;|
WTWK310		EQU	$
		LDA	#024FCH
		AND	<WORK		; iro
		STA	!IWAKU3+040H,X
		ORA	#04000H
		STA	!IWAKU3+064H,X
		TXA
		CLC
		ADC	#00040H
		TAX
		DEY
		BPL	WTWK310
;
		LDX	#00000H		;---	YOKO
		LDY	#00010H		;
WTWK320		EQU	$
		LDA	#024F9H
		AND	<WORK		; iro
		STA	!IWAKU3+002H,X
		ORA	#08000H
		STA	!IWAKU3+202H,X
		INX
		INX
		DEY
		BPL	WTWK320
;
		LDA	#0A4F0H		;A write
		STA	!IWAKU3+042H
		LDA	#024F2H
		STA	!IWAKU3+082H
;
		LDA	#02482H		;DO write
		STA	!IWAKU3+004H
		LDA	#02483H
		STA	!IWAKU3+006H
;
		MEM8
		IDX8
		SEP	#00110000B
		RTS
;
;
WTWAKU4I	EQU	$		; waku 4 o kaku
		MEM16
		IDX16
		REP	#00110000B
;
;					;GROBU SET
		LDA	#WITEM21+8	;TFR SAKI
		STA	<WORK0
		LDA	>ITEMR21	;NO. SET
		AND	#000FFH
		STA	<WORK2
		LDA	#RITEM21	;TFR MOTO 
		STA	<WORK4
		JSR	SETITEM		;SET ITEM
;
;					;KUTU SET
		LDA	#WITEM21	;TFR SAKI
		STA	<WORK0
		LDA	>ITEMR22	;NO. SET
		AND	#000FFH
		STA	<WORK2
		LDA	#RITEM22	;TFR MOTO 
		STA	<WORK4
		JSR	SETITEM		;SET ITEM
;
;					;HIRE SET
		LDA	#WITEM23+4	;TFR SAKI
		STA	<WORK0
		LDA	>ITEMR23	;NO. SET
		AND	#000FFH
		STA	<WORK2
		LDA	#RITEM23	;TFR MOTO 
		STA	<WORK4
		JSR	SETITEM		;SET ITEM
;
		LDA	>ITEMR21		;GROBE CHK.
		AND	#000FFH
		BEQ	WTWK4I50
		CMP	#00001H
		BNE	WTWK4I55
		LDA	#00000H
		JSR	WTWK4IMPRI
		BRA	WTWK4I50
WTWK4I55	EQU	$
		LDA	#00001H
		JSR	WTWK4IMPRI
WTWK4I50	EQU	$
;		LDA	>ITEMR22		;HIRE CHK.
;		AND	#000FFH
;		BEQ	WTWK4I60
;		LDA	#00002H
;		JSR	WTWK4IMPRI
WTWK4I60	EQU	$
;		LDA	>ITEMR23		;GISYO CHK.
;		BEQ	WTWK4I70
;		LDA	#00003H
;		JSR	WTWK4IMPRI
;		LDA	#00006H
;		JSR	WTWK4IMPRI
;WTWK4I70	EQU	$
;
		MEM8
		IDX8
		SEP	#00110000B
		RTS
;
WTWK4IMPRI	EQU	$
		MEM16
		IDX16
		STA	<WORK0		;PARA. SAVE
		ASL	A
		ASL	A
		ADC	<WORK0
		ASL	A
		ASL	A
		TAX
;
		LDA	YGROB,X
;		AND	#0E3FFH
;		ORA	#00800H
		STA	!IWAKU3+132-40H
		LDA	YGROB+2,X
;		AND	#0E3FFH
;		ORA	#00800H
		STA	!IWAKU3+134-40H
		LDA	YGROB+4,X
;		AND	#0E3FFH
;		ORA	#00800H
		STA	!IWAKU3+136-40H
		LDA	YGROB+6,X
;		AND	#0E3FFH
;		ORA	#00800H
		STA	!IWAKU3+138-40H
		LDA	YGROB+8,X
;		AND	#0E3FFH
;		ORA	#00800H
		STA	!IWAKU3+140-40H
		LDA	YGROB+10,X
;		AND	#0E3FFH
;		ORA	#00800H
		STA	!IWAKU3+132
		LDA	YGROB+12,X
;		AND	#0E3FFH
;		ORA	#00800H
		STA	!IWAKU3+134
		LDA	YGROB+14,X
;		AND	#0E3FFH
;		ORA	#00800H
		STA	!IWAKU3+136
		LDA	YGROB+16,X
;		AND	#0E3FFH
;		ORA	#00800H
		STA	!IWAKU3+138
		LDA	YGROB+18,X
;		AND	#0E3FFH
;		ORA	#00800H
		STA	!IWAKU3+140
;
		RTS
;
		MEM8
		IDX8
;
WTWK5DT		EQU	$
		WORD	028FBH,028F9H,028F9H,028F9H
		WORD	028F9H,028F9H,028F9H,028F9H
		WORD	028F9H,068FBH
		WORD	028FCH,02521H,02522H,02523H
		WORD	02524H,0253FH,KURODT,KURODT
		WORD	KURODT,068FCH
		WORD	028FCH,KURODT,KURODT,KURODT
		WORD	KURODT,KURODT,KURODT,KURODT
		WORD	KURODT,068FCH
		WORD	028FCH,KURODT,KURODT,KURODT
		WORD	0213BH,0213CH,KURODT,KURODT
		WORD	KURODT,068FCH
		WORD	028FCH,KURODT,KURODT,KURODT
		WORD	0213DH,0213EH,KURODT,KURODT
		WORD	KURODT,068FCH
		WORD	028FCH,KURODT,KURODT,KURODT
		WORD	KURODT,KURODT,KURODT,KURODT
		WORD	KURODT,068FCH
		WORD	028FCH,KURODT,0213BH,0213CH
		WORD	KURODT,KURODT,0213BH,0213CH
		WORD	KURODT,068FCH
		WORD	028FCH,KURODT,0213DH,0213EH
		WORD	KURODT,KURODT,0213DH,0213EH
		WORD	KURODT,068FCH
		WORD	0A8FBH,0A8F9H,0A8F9H,0A8F9H
		WORD	0A8F9H,0A8F9H,0A8F9H,0A8F9H
		WORD	0A8F9H,0E8FBH
;
WTWK6DT		EQU	$
		WORD	028FBH,028F9H,028F9H,028F9H
		WORD	028F9H,028F9H,028F9H,028F9H
		WORD	028F9H,068FBH
		WORD	028FCH,0252FH,02534H,02535H
		WORD	02536H,02537H,KURODT,KURODT
		WORD	KURODT,068FCH
		WORD	028FCH,KURODT,KURODT,KURODT
		WORD	KURODT,KURODT,KURODT,KURODT
		WORD	KURODT,068FCH
		WORD	028FCH,KURODT,KURODT,03146H
		WORD	03147H,03146H,03147H,KURODT
		WORD	KURODT,068FCH
		WORD	028FCH,KURODT,KURODT,KURODT
		WORD	KURODT,KURODT,KURODT,KURODT
		WORD	KURODT,068FCH
		WORD	028FCH,KURODT,03146H,03147H
		WORD	03146H,03147H,03146H,03147H
		WORD	KURODT,068FCH
		WORD	028FCH,KURODT,KURODT,KURODT
		WORD	KURODT,KURODT,KURODT,KURODT
		WORD	KURODT,068FCH
		WORD	028FCH,KURODT,KURODT,03146H
		WORD	03147H,03146H,03147H,KURODT
		WORD	KURODT,068FCH
		WORD	0A8FBH,0A8F9H,0A8F9H,0A8F9H
		WORD	0A8F9H,0A8F9H,0A8F9H,0A8F9H
		WORD	0A8F9H,0E8FBH
;
WTWAKU5		EQU	$		; waku 5 o kaku
		LDA	>MODTBL0
		CMP	#003H
		BCC	WTWK500
		JMP	WTWAKU6

WTWK500		EQU	$
;
		MEM16
		IDX16
		REP	#00110000B
;
		LDX	#00000H
WTWK510		EQU	$
		LDA	WTWK5DT,X
		STA	!IWAKU5,X
		LDA	WTWK5DT+014H,X
		STA	!IWAKU5+040H,X
		LDA	WTWK5DT+028H,X
		STA	!IWAKU5+080H,X
		LDA	WTWK5DT+03CH,X
		STA	!IWAKU5+0C0H,X
		LDA	WTWK5DT+050H,X
		STA	!IWAKU5+100H,X
		LDA	WTWK5DT+064H,X
		STA	!IWAKU5+140H,X
		LDA	WTWK5DT+078H,X
		STA	!IWAKU5+180H,X
		LDA	WTWK5DT+08CH,X
		STA	!IWAKU5+1C0H,X
		LDA	WTWK5DT+0A0H,X
		STA	!IWAKU5+200H,X
		INX
		INX
		CPX	#00014H
		BCC	WTWK510
;
		LDA	#IWAKU5+0C8H	;TFR SAKI
		STA	<WORK0
		LDA	>ITEMR53	;NO. SET
		AND	#00001H
		STA	<WORK2
		LDA	#RITM530	;TFR MOTO 
		STA	<WORK4
		JSR	SETITEM		;SET ITEM
;
		LDA	#IWAKU5+184H	;TFR SAKI
		STA	<WORK0
		STZ	<WORK2
		LDA	>ITEMR53	;NO. SET
		AND	#00002H
		BEQ	WTWK520
		INC	<WORK2
WTWK520		EQU	$
		LDA	#RITM531	;TFR MOTO 
		STA	<WORK4
		JSR	SETITEM		;SET ITEM
;
		LDA	#IWAKU5+18CH	;TFR SAKI
		STA	<WORK0
		STZ	<WORK2
		LDA	>ITEMR53	;NO. SET
		AND	#00004H
		BEQ	WTWK530
		INC	<WORK2
WTWK530		EQU	$
		LDA	#RITM532	;TFR MOTO 
		STA	<WORK4
		JSR	SETITEM		;SET ITEM
;
;
		MEM8
		IDX8
		SEP	#00110000B
		RTS
;
;
WAKU6C0		EQU	02D44H
WAKU6C1		EQU	02D45H
;
WTWAKU6		EQU	$		; waku 4 o kaku
		MEM16
		IDX16
		REP	#00110000B
;
		LDX	#00000H
WTWK610		EQU	$
		LDA	WTWK6DT,X
		STA	!IWAKU5,X
		LDA	WTWK6DT+014H,X
		STA	!IWAKU5+040H,X
		LDA	WTWK6DT+028H,X
		STA	!IWAKU5+080H,X
		LDA	WTWK6DT+03CH,X
		STA	!IWAKU5+0C0H,X
		LDA	WTWK6DT+050H,X
		STA	!IWAKU5+100H,X
		LDA	WTWK6DT+064H,X
		STA	!IWAKU5+140H,X
		LDA	WTWK6DT+078H,X
		STA	!IWAKU5+180H,X
		LDA	WTWK6DT+08CH,X
		STA	!IWAKU5+1C0H,X
		LDA	WTWK6DT+0A0H,X
		STA	!IWAKU5+200H,X
		INX
		INX
		CPX	#00014H
		BCC	WTWK610
;		MEM16
;		IDX16
;		REP	#00110000B
;
		LDA	>ITMTBL3		;waku 6 (item) write
		AND	#00001H
		BEQ	WTWK620
		LDA	#WAKU6C0		;1
		STA	!IWAKU5+0C0H+00H+06H
		LDA	#WAKU6C1
		STA	!IWAKU5+0C0H+02H+06H
WTWK620		EQU	$
;
		LDA	>ITMTBL3
		AND	#00002H
		BEQ	WTWK630
		LDA	#WAKU6C0		;2
		STA	!IWAKU5+0C0H+00H+0AH
		LDA	#WAKU6C1
		STA	!IWAKU5+0C0H+02H+0AH
WTWK630		EQU	$
;
		LDA	>ITMTBL3
		AND	#00004H
		BEQ	WTWK640
		LDA	#WAKU6C0		;3
		STA	!IWAKU5+140H+00H+04H
		LDA	#WAKU6C1
		STA	!IWAKU5+140H+02H+04H
WTWK640		EQU	$
;
		LDA	>ITMTBL3
		AND	#00008H
		BEQ	WTWK650
		LDA	#WAKU6C0		;4
		STA	!IWAKU5+140H+00H+08H
		LDA	#WAKU6C1
		STA	!IWAKU5+140H+02H+08H
WTWK650		EQU	$
;
		LDA	>ITMTBL3
		AND	#00010H
		BEQ	WTWK660
		LDA	#WAKU6C0		;5
		STA	!IWAKU5+140H+00H+0CH
		LDA	#WAKU6C1
		STA	!IWAKU5+140H+02H+0CH
WTWK660		EQU	$
;
		LDA	>ITMTBL3
		AND	#00020H
		BEQ	WTWK670
		LDA	#WAKU6C0		;6
		STA	!IWAKU5+1C0H+00H+06H
		LDA	#WAKU6C1
		STA	!IWAKU5+1C0H+02H+06H
WTWK670		EQU	$
;
		LDA	>ITMTBL3
		AND	#00040H
		BEQ	WTWK680
		LDA	#WAKU6C0		;7
		STA	!IWAKU5+1C0H+00H+0AH
		LDA	#WAKU6C1
		STA	!IWAKU5+1C0H+02H+0AH
WTWK680		EQU	$
;
		MEM8
		IDX8
		SEP	#00110000B
		RTS
;
;
WTWAKU12I	EQU	$		;waku 1 2 no naka o erabu
		MEM16
		IDX16
		REP	#00110000B
;
		LDA	GETITM0
		AND	#000FFH
		DEC	A
		ASL	A
		TAX
		LDY	STGITWM,X
WTWAKU12I6	EQU	$
		LDA	WBGBUF-WBGBUF,Y
		STA	IWAKU2+48H
		LDA	WBGBUF-WBGBUF+002H,Y
		STA	IWAKU2+4AH
		LDA	WBGBUF-WBGBUF+040H,Y
		STA	IWAKU2+88H
		LDA	WBGBUF-WBGBUF+042H,Y
		STA	IWAKU2+8AH
;
		LDA	IFRCNT1
		AND	#010H
		BEQ	WTWAKU12I8
		LDA	#03C61H		;consol set
		STA	WBGBUF-WBGBUF-40H,Y
		ORA	#04000H
		STA	WBGBUF-WBGBUF-3EH,Y
		LDA	#03C70H
		STA	WBGBUF-WBGBUF-02H,Y
		ORA	#04000H
		STA	WBGBUF-WBGBUF+04H,Y
		LDA	#0BC70H
		STA	WBGBUF-WBGBUF+3EH,Y
		ORA	#04000H
		STA	WBGBUF-WBGBUF+44H,Y
		LDA	#0BC61H
		STA	WBGBUF-WBGBUF+80H,Y
		ORA	#04000H
		STA	WBGBUF-WBGBUF+82H,Y
		LDA	#03C60H
		STA	WBGBUF-WBGBUF-42H,Y
		ORA	#04000H
		STA	WBGBUF-WBGBUF-3CH,Y
		ORA	#08000H
		STA	WBGBUF-WBGBUF+84H,Y
		EOR	#04000H
		STA	WBGBUF-WBGBUF+7EH,Y
;
WTWAKU12I8	EQU	$
		LDA	GETITM0		;bin 1   moji
		AND	#000FFH
		CMP	#00016
		BNE	WTWAKU12I9
		LDA	>ITEMR16
		AND	#000FFH
		BEQ	WTWAKU12I9
		TAX
		LDA	>BINCT0-1,X
		AND	#000FFH
		DEC	A
;		BEQ	WTWAKU12I9
;		DEC	A		;pri. ok
		ASL	A
		ASL	A
		ASL	A
		ASL	A
		ASL	A
		TAX
		LDY	#00000H
WTWAKU12IA	EQU	$
		LDA	BINMOJI,X
		STA	!IWAKU2+0C2H,Y
		LDA	BINMOJI+10H,X
		STA	!IWAKU2+102H,Y
		INX
		INX
		INY
		INY
		CPY	#00010H
		BCC	WTWAKU12IA
		JMP	WTWAKU12IF
WTWAKU12I9	EQU	$
;;;;;;;;		LDA	GETITM0		;bin 2   moji
;;;;;;;;		AND	#000FFH
;;;;;;;;		CMP	#00017
;;;;;;;;		BNE	WTWAKU12IB
;;;;;;;;		LDA	>BINCT1
;;;;;;;;		AND	#000FFH
;;;;;;;;		DEC	A
;;;;;;;;		BEQ	WTWAKU12IB
;;;;;;;;		DEC	A		;pri. ok
;;;;;;;;		ASL	A
;;;;;;;;		ASL	A
;;;;;;;;		ASL	A
;;;;;;;;		ASL	A
;;;;;;;;		ASL	A
;;;;;;;;		TAX
;;;;;;;;		LDY	#00000H
;;;;;;;;WTWAKU12IC	EQU	$
;;;;;;;;		LDA	BINMOJI,X
;;;;;;;;		STA	!IWAKU2+0C2H,Y
;;;;;;;;		LDA	BINMOJI+10H,X
;;;;;;;;		STA	!IWAKU2+102H,Y
;;;;;;;;		INX
;;;;;;;;		INX
;;;;;;;;		INY
;;;;;;;;		INY
;;;;;;;;		CPY	#00010H
;;;;;;;;		BCC	WTWAKU12IC
;;;;;;;;		JMP	WTWAKU12IF
;;;;;;;;WTWAKU12IB	EQU	$
;;;;;;;;		LDA	GETITM0		;bin 3   moji
;;;;;;;;		AND	#000FFH
;;;;;;;;		CMP	#00018
;;;;;;;;		BNE	WTWAKU12I10
;;;;;;;;		LDA	>BINCT2
;;;;;;;;		AND	#000FFH
;;;;;;;;		DEC	A
;;;;;;;;		BEQ	WTWAKU12I10
;;;;;;;;		DEC	A		;pri. ok
;;;;;;;;		ASL	A
;;;;;;;;		ASL	A
;;;;;;;;		ASL	A
;;;;;;;;		ASL	A
;;;;;;;;		ASL	A
;;;;;;;;		TAX
;;;;;;;;		LDY	#00000H
;;;;;;;;WTWAKU12IE	EQU	$
;;;;;;;;		LDA	BINMOJI,X
;;;;;;;;		STA	!IWAKU2+0C2H,Y
;;;;;;;;		LDA	BINMOJI+10H,X
;;;;;;;;		STA	!IWAKU2+102H,Y
;;;;;;;;		INX
;;;;;;;;		INX
;;;;;;;;		INY
;;;;;;;;		INY
;;;;;;;;		CPY	#00010H
;;;;;;;;		BCC	WTWAKU12IE
;;;;;;;;		JMP	WTWAKU12IF
WTWAKU12I10	EQU	$
		LDA	GETITM0		;KONA   moji
		AND	#000FFH
		CMP	#00005
		BNE	WTWAKU12I12
		LDA	>ITEMR05
		AND	#000FFH
		DEC	A
		BEQ	WTWAKU12I12
		DEC	A		;pri. ok
		ASL	A
		ASL	A
		ASL	A
		ASL	A
		ASL	A
		TAX
		LDY	#00000H
WTWAKU12I11	EQU	$
		LDA	KONAMJI,X
		STA	!IWAKU2+0C2H,Y
		LDA	KONAMJI+10H,X
		STA	!IWAKU2+102H,Y
		INX
		INX
		INY
		INY
		CPY	#00010H
		BCC	WTWAKU12I11
		JMP	WTWAKU12IF
WTWAKU12I12	EQU	$
		LDA	GETITM0		;TEGAMI   moji
		AND	#000FFH
		CMP	#00020
		BNE	WTWAKU12I14
		LDA	>ITEMR20
		AND	#000FFH
		DEC	A
		BEQ	WTWAKU12I14
		DEC	A		;pri. ok
		ASL	A
		ASL	A
		ASL	A
		ASL	A
		ASL	A
		TAX
		LDY	#00000H
WTWAKU12I13	EQU	$
		LDA	TGMIMJI,X
		STA	!IWAKU2+0C2H,Y
		LDA	TGMIMJI+10H,X
		STA	!IWAKU2+102H,Y
		INX
		INX
		INY
		INY
		CPY	#00010H
		BCC	WTWAKU12I13
		JMP	WTWAKU12IF
WTWAKU12I14	EQU	$
		LDA	GETITM0		;OKARINA   moji
		AND	#000FFH
		CMP	#00013
		BNE	WTWAKU12I16
		LDA	>ITEMR13
		AND	#000FFH
		DEC	A
		BEQ	WTWAKU12I16
		DEC	A		;pri. ok
		ASL	A
		ASL	A
		ASL	A
		ASL	A
		ASL	A
		TAX
		LDY	#00000H
WTWAKU12I15	EQU	$
		LDA	OKARMJI,X
		STA	!IWAKU2+0C2H,Y
		LDA	OKARMJI+10H,X
		STA	!IWAKU2+102H,Y
		INX
		INX
		INY
		INY
		CPY	#00010H
		BCC	WTWAKU12I15
		BRA	WTWAKU12IF
WTWAKU12I16	EQU	$
		LDA	GETITM0		;YAAA   moji
		AND	#000FFH
		CMP	#00001
		BNE	WTWAKU12ID
		LDA	>ITEMR01
		AND	#000FFH
		DEC	A
		BEQ	WTWAKU12ID
		DEC	A		;pri. ok
		ASL	A
		ASL	A
		ASL	A
		ASL	A
		ASL	A
		TAX
		LDY	#00000H
WTWAKU12I17	EQU	$
		LDA	YAAAMJI,X
		STA	!IWAKU2+0C2H,Y
		LDA	YAAAMJI+10H,X
		STA	!IWAKU2+102H,Y
		INX
		INX
		INY
		INY
		CPY	#00010H
		BCC	WTWAKU12I17
		BRA	WTWAKU12IF
WTWAKU12ID	EQU	$
		TXA
		ASL	A
		ASL	A
		ASL	A
		ASL	A
		TAX
		LDY	#00000H
WTWAKU12I5	EQU	$
		LDA	BDATAM,X
		STA	!IWAKU2+0C2H,Y
		LDA	BDATAM+10H,X
		STA	!IWAKU2+102H,Y
		INX
		INX
		INY
		INY
		CPY	#00010H
		BCC	WTWAKU12I5
WTWAKU12IF	EQU	$
;
WTWAKU12I3	EQU	$
		MEM8
		IDX8
		SEP	#00110000B
		RTS
;
;
;
WTWAKU7I	EQU	$
		MEM16
		IDX16
		REP	#00110000B
;
;					;TAMA SET
		LDA	#WITEM24+6	;TFR SAKI
		STA	<WORK0
		LDA	>ITMTBL4	;NO. SET
		AND	#000FFH
		STA	<WORK2
		LDA	#RITEM24	;TFR MOTO 
		STA	<WORK4
		JSR	SETITEM		;SET ITEM
;
		MEM8
		IDX8
		SEP	#00110000B
;
		RTS
;
;
WTWAKU8I	EQU	$
		MEM16
		IDX16
		REP	#00110000B
;
;					;KAGAMI SET
;		LDA	#WITEM25	;TFR SAKI
;		STA	<WORK0
;		LDA	>ITMTBL5	;NO. SET
;		AND	#000FFH
;		STA	<WORK2
;		LDA	#RITEM25	;TFR MOTO 
;		STA	<WORK4
;		JSR	SETITEM		;SET ITEM
;
		MEM8
		IDX8
		SEP	#00110000B
;
		RTS
;
;
WAKU9MDT0	EQU	$
		WORD	02479H,0247AH,0247BH,0247CH
		WORD	0248CH,KURODT,KURODT,KURODT
WAKU9MDT1	EQU	$
		WORD	02469H,0246AH,0246BH,0246CH
		WORD	0246DH,0246EH,0246FH,KURODT
WTWAKU9		EQU	$		; waku 4 o kaku
		MEM16
		IDX16
		REP	#00110000B
;
		LDA	#028FBH		;KADO
		AND	<WORK		; iro
		STA	!IWAKU9		;[
		ORA	#08000H
		STA	!IWAKU9+200H	;[
		ORA	#04000H
		STA	!IWAKU9+212H	;]
		EOR	#08000H
		STA	!IWAKU9+012H	;]
;
		LDX	#00000H		;|	TATE
		LDY	#00006H		;|
WTWK910		EQU	$
		LDA	#028FCH
		AND	<WORK		; iro
		STA	!IWAKU9+040H,X
		ORA	#04000H
		STA	!IWAKU9+052H,X
		TXA
		CLC
		ADC	#00040H
		TAX
		DEY
		BPL	WTWK910
;
		LDX	#00000H		;---	YOKO
		LDY	#00007H		;
WTWK920		EQU	$
		LDA	#028F9H
		AND	<WORK		; iro
		STA	!IWAKU9+002H,X
		ORA	#08000H
		STA	!IWAKU9+202H,X
		INX
		INX
		DEY
		BPL	WTWK920
;
		LDX	#00000H		;---	KURO
		LDY	#00007H		;
		LDA	#KURODT
WTWK930		EQU	$
		STA	!IWAKU9+042H,X
		STA	!IWAKU9+082H,X
		STA	!IWAKU9+0C2H,X
		STA	!IWAKU9+102H,X
		STA	!IWAKU9+142H,X
		STA	!IWAKU9+182H,X
		STA	!IWAKU9+1C2H,X
		INX
		INX
		DEY
		BPL	WTWK930
;
		LDX	#00000H		;---	YOKO(- - -)
		LDY	#00007H		;
		LDA	#028D7H
		AND	<WORK		; iro
WTWK940		EQU	$
		STA	!IWAKU9+102H,X
		INX
		INX
		DEY
		BPL	WTWK940
;
		LDX	#00000H		;---	YOKO( MOJI )
		LDY	#00007H		;
WTWK950		EQU	$
		LDA	WAKU9MDT0,X
		AND	<WORK		; iro
		STA	!IWAKU9+042H,X
		LDA	WAKU9MDT1,X
		AND	<WORK		; iro
		STA	!IWAKU9+142H,X
		INX
		INX
		DEY
		BPL	WTWK950
;
;		LDA	<GMMODE
;		AND	#000FFH
;		BNE	WTWAKU9I
		LDA	DJNNO
		AND	#000FFH
		CMP	#000FFH
		BNE	WTWAKU9I
		LDX	#00000H		;---	KURO
		LDY	#00007H		;
		LDA	#KURODT
WTWK960		EQU	$
		STA	!IWAKU9+142H,X
		INX
		INX
		DEY
		BPL	WTWK960
;
;					;HART SET
		LDA	#WITEM37	;TFR SAKI
		STA	<WORK0
		LDA	>ITEMR44	;NO. SET
		AND	#000FFH
		STA	<WORK2
		LDA	#HARTBK		;TFR MOTO 
		STA	<WORK4
		JSR	SETITEM		;SET ITEM
;
;
;
WTWAKU9I	EQU	$
		MEM16
		IDX16
		REP	#00110000B
;
;					;KEN SET
		LDA	#WITEM26	;TFR SAKI
		STA	<WORK0
		LDA	>ITMTBL6	;NO. SET
		AND	#000FFH
		CMP	#000FFH
		BNE	WTWAKU9I10
		LDA	#000H
WTWAKU9I10	EQU	$
		STA	<WORK2
		LDA	#RITEM26	;TFR MOTO 
		STA	<WORK4
		JSR	SETITEM		;SET ITEM
;
		MEM8
		IDX8
		SEP	#00110000B
;
		RTS
;
;
WTWAKUAI	EQU	$
		MEM16
		IDX16
		REP	#00110000B
;
;					;TATE SET
		LDA	#WITEM27	;TFR SAKI
		STA	<WORK0
		LDA	>ITMTBL7	;NO. SET
		AND	#000FFH
		STA	<WORK2
		LDA	#RITEM27	;TFR MOTO 
		STA	<WORK4
		JSR	SETITEM		;SET ITEM
;
		MEM8
		IDX8
		SEP	#00110000B
;
		RTS
;
;
WTWAKUBI	EQU	$
		MEM16
		IDX16
		REP	#00110000B
;
;					;HUKU SET
		LDA	#WITEM28	;TFR SAKI
		STA	<WORK0
		LDA	>ITMTBL8	;NO. SET
		AND	#000FFH
		STA	<WORK2
		LDA	#RITEM28	;TFR MOTO 
		STA	<WORK4
		JSR	SETITEM		;SET ITEM
;
		MEM8
		IDX8
		SEP	#00110000B
;
		RTS
;
;
WTWAKUCI	EQU	$		; waku 4 o kaku
		MEM16
		IDX16
		REP	#00110000B
;
;					;KEY SET
;		LDA	<GMMODE
;		AND	#000FFH
;		BEQ	WTWKCI10
		LDA	DJNNO
		AND	#000FFH
		CMP	#000FFH
		BEQ	WTWKCI30
		LSR	A
		TAX
		LDA	>KEYCNT
WTWKCI20	EQU	$
		ASL	A
		DEX
		BPL	WTWKCI20
;
		BCC	WTWKCI30	;? DANJON KEY GET
;					;Y
		JSR	TAKBOCK		;TAKARA BOX CHK
		REP	#00110000B
;
		LDA	#WITEM29+0CH	;TFR SAKI
		STA	<WORK0
		LDA	#00001H		;NO. SET
		CLC
		ADC	<WORK2
		STA	<WORK2
		LDA	#RITEM39	;TFR MOTO 
		STA	<WORK4
		JSR	SETITEM		;SET ITEM
;
WTWKCI30	EQU	$
		LDA	DJNNO
		AND	#000FFH
		CMP	#000FFH
		BEQ	WTWKCI50
		LSR	A
		TAX
		LDA	>MAPCNT
WTWKCI40	EQU	$
		ASL	A
		DEX
		BPL	WTWKCI40
;
		BCC	WTWKCI50	;? MAP GET
;					;Y
		LDA	#WITEM29	;TFR SAKI
		STA	<WORK0
		LDA	#00001H		;NO. SET
		STA	<WORK2
		LDA	#RITEM41	;TFR MOTO 
		STA	<WORK4
		JSR	SETITEM		;SET ITEM
;
WTWKCI50	EQU	$
WTWKCI10	EQU	$
		MEM8
		IDX8
		SEP	#00110000B
;
		RTS
;
TAKBOCK		EQU	$
		MEM8
		IDX8
		SEP	#00110000B
;
		LDA	DJNNO
		LSR	A
		JSL	>JSRSUB
		WORD	TAKBOC0
		WORD	TAKBOC1
		WORD	TAKBOC2
		WORD	TAKBOC3
		WORD	TAKBOC4
		WORD	TAKBOC5
		WORD	TAKBOC6
		WORD	TAKBOC7
		WORD	TAKBOC8
		WORD	TAKBOC9
		WORD	TAKBOCA
		WORD	TAKBOCB
		WORD	TAKBOCC
		WORD	TAKBOCD
;--
TAKBOC0		EQU	$	;NASI
TAKBOC1		EQU	$
TAKBOC4		EQU	$
TAKBONT		EQU	$
		STZ	<WORK2
		STZ	<WORK3
		RTS
TAKBOC2		EQU	$
		LDA	>ITEMR01
TAKBOTS		EQU	$
		BEQ	TAKBONT
TAKBOIC		EQU	$
		LDA	#001H
		STA	<WORK2
		STZ	<WORK3
		RTS
TAKBOC3		EQU	$
		LDA	>ITEMR21
		BRA	TAKBOTS
TAKBOC5		EQU	$
		LDA	>ITEMR03
		BRA	TAKBOTS
TAKBOC6		EQU	$
		LDA	>ITEMR12
		BRA	TAKBOTS
TAKBOC7		EQU	$
		LDA	>ITEMR17
		BRA	TAKBOTS
TAKBOC8		EQU	$
		LDA	>ITEMR06
		BRA	TAKBOTS
TAKBOC9		EQU	$
		LDA	>ITMTBL8
		BRA	TAKBOTS
TAKBOCA		EQU	$
		LDA	>ITMTBL4
		BRA	TAKBOTS
TAKBOCB		EQU	$
		LDA	>ITEMR21
		DEC	A
		BRA	TAKBOTS
TAKBOCC		EQU	$
		LDA	>ITMTBL7
		CMP	#003
		BEQ	TAKBOIC
		STZ	<WORK2
		STZ	<WORK3
		RTS
TAKBOCD		EQU	$
		LDA	>ITMTBL8
		CMP	#002
		BEQ	TAKBOIC
		STZ	<WORK2
		STZ	<WORK3
		RTS
;----------------------------------------
WTWAKUDI	EQU	$
		MEM16
		IDX16
		REP	#00110000B
;
;					;GISYAKU SET
;
;		LDA	<GMMODE
;		AND	#000FFH
;		BEQ	WTWAKUDI20
		LDA	DJNNO
		AND	#000FFH
		CMP	#000FFH
		BEQ	WTWAKUDI20
		LSR	A
		TAX
		LDA	>ITMTBLA
WTWAKUDI10	EQU	$
		ASL	A
		DEX
		BPL	WTWAKUDI10
;
		BCC	WTWAKUDI20	;? GISYAKU GET
;					;Y
		LDA	#WITEM37	;TFR SAKI
		STA	<WORK0
		LDA	#00001H		;NO. SET
		STA	<WORK2
		LDA	#RITEM37	;TFR MOTO 
		STA	<WORK4
		JSR	SETITEM		;SET ITEM
;
WTWAKUDI20	EQU	$
		MEM8
		IDX8
		SEP	#00110000B
;
		RTS
;
;
WTBINST		EQU	$		; bin select o kaku
		MEM16
		IDX16
		REP	#00110000B
;
		LDA	#028FBH		;KADO
		AND	<WORK		; iro
		STA	!IWAKU5		;[
		ORA	#08000H
		STA	!IWAKU5+480H	;[
		ORA	#04000H
		STA	!IWAKU5+492H	;]
		EOR	#08000H
		STA	!IWAKU5+012H	;]
;
		LDX	#00000H		;|	TATE
		LDY	#00010H		;|
WTBIN10		EQU	$
		LDA	#028FCH
		AND	<WORK		; iro
		STA	!IWAKU5+040H,X
		ORA	#04000H
		STA	!IWAKU5+052H,X
		TXA
		CLC
		ADC	#00040H
		TAX
		DEY
		BPL	WTBIN10
;
		LDX	#00000H		;---	YOKO
		LDY	#00007H		;
WTBIN20		EQU	$
		LDA	#028F9H
		AND	<WORK		; iro
		STA	!IWAKU5+002H,X
		ORA	#08000H
		STA	!IWAKU5+482H,X
		INX
		INX
		DEY
		BPL	WTBIN20
;
		LDX	#00000H		;---	KURO
		LDY	#00007H		;
		LDA	#KURODT
WTBIN30		EQU	$
		STA	IWAKU5+042H,X
		STA	IWAKU5+082H,X
		STA	IWAKU5+0C2H,X
		STA	IWAKU5+102H,X
		STA	IWAKU5+142H,X
		STA	IWAKU5+182H,X
		STA	IWAKU5+1C2H,X
		STA	IWAKU5+202H,X
		STA	IWAKU5+242H,X
		STA	IWAKU5+282H,X
		STA	IWAKU5+2C2H,X
		STA	IWAKU5+302H,X
		STA	IWAKU5+342H,X
		STA	IWAKU5+382H,X
		STA	IWAKU5+3C2H,X
		STA	IWAKU5+402H,X
		STA	IWAKU5+442H,X
 		INX
		INX
		DEY
		BPL	WTBIN30
;
;
WTBINSTI	EQU	$
		MEM16
		IDX16
		REP	#00110000B
;
                LDA     #IWAKU5+088H    ;TFR SAKI
                STA     <WORK0
                LDA     >BINCT0         ;NO. SET
                AND     #000FFH
                STA     <WORK2
                LDA     #RITEM29        ;TFR MOTO 
                STA     <WORK4
                JSR     SETITEM         ;SET ITEM
;
;                                       ;BIN2 SET
                LDA     #IWAKU5+188H    ;TFR SAKI
                STA     <WORK0
                LDA     >BINCT1         ;NO. SET
                AND     #000FFH
                STA     <WORK2
                LDA     #RITEM30        ;TFR MOTO 
                STA     <WORK4
                JSR     SETITEM         ;SET ITEM
;
;                                       ;BIN3 SET
                LDA     #IWAKU5+288H    ;TFR SAKI
                STA     <WORK0
                LDA     >BINCT2         ;NO. SET
                AND     #000FFH
                STA     <WORK2
                LDA     #RITEM31        ;TFR MOTO 
                STA     <WORK4
                JSR     SETITEM         ;SET ITEM
;
;
                LDA     #IWAKU5+388H    ;TFR SAKI
                STA     <WORK0
                LDA     >BINCT3         ;NO. SET
                AND     #000FFH
                STA     <WORK2
                LDA     #RITEM32        ;TFR MOTO 
                STA     <WORK4
                JSR     SETITEM         ;SET ITEM
;
;
                LDA     #WITEM16        ;TFR SAKI
                STA     <WORK0
                LDA     >ITEMR16        ;NO. SET
                AND     #000FFH
                TAX
                LDA     >BINCT0-1,X
                AND     #000FFH
                STA     <WORK2
                LDA     #RITEM16        ;TFR MOTO 
                STA     <WORK4
                JSR     SETITEM         ;SET ITEM
;
;
                LDA     GETITM0         ;WAKU2 WRITE
                AND     #000FFH
                DEC     A
                ASL     A
                TAX
                LDY     STGITWM,X
                LDA     WBGBUF-WBGBUF,Y
                STA     IWAKU2+48H
                LDA     WBGBUF-WBGBUF+002H,Y
                STA     IWAKU2+4AH
                LDA     WBGBUF-WBGBUF+040H,Y
                STA     IWAKU2+88H
                LDA     WBGBUF-WBGBUF+042H,Y
                STA     IWAKU2+8AH
;
;
		LDA	>ITEMR16
		DEC	A
		AND	#000FFH
		ASL	A
		TAY
		LDA	BNS40CNS,Y
		TAY
;
		LDA	IFRCNT1
		LDA	#03C61H		;consol set
		STA	IWAKU5-40H,Y
		ORA	#04000H
		STA	IWAKU5-3EH,Y
		LDA	#03C70H
		STA	IWAKU5-02H,Y
		ORA	#04000H
		STA	IWAKU5+04H,Y
		LDA	#0BC70H
		STA	IWAKU5+3EH,Y
		ORA	#04000H
		STA	IWAKU5+44H,Y
		LDA	#0BC61H
		STA	IWAKU5+80H,Y
		ORA	#04000H
		STA	IWAKU5+82H,Y
		LDA	#03C60H
		STA	IWAKU5-42H,Y
		ORA	#04000H
		STA	IWAKU5-3CH,Y
		ORA	#08000H
		STA	IWAKU5+84H,Y
		EOR	#04000H
		STA	IWAKU5+7EH,Y
;
		MEM8
		IDX8
		SEP	#00110000B
;
		LDA	#010H
		STA	IFRCNT1
;
		RTS
;
;
;
;
;
;
;
;
;
;
HENKAN		EQU	$		;16 sin o 10 sin ni suru
		MEM16			;A ni 16 sin o ireru
		IDX16			;3 keta you
		REP	#00110000B	;work+3,4,5 ni 100,10,1 no keta ga hairu
;
		STZ	WORK+3
;
		LDX	#0000
		LDY	#0002		;3 keta 
;
HENKAN1		EQU	$
		CMP	TBL16_10,Y
		BCC	HENKAN2
		SEC
		SBC	TBL16_10,Y
		INC	<WORK+3,X
		BRA	HENKAN1
;
HENKAN2		EQU	$
		INX
		DEY
		DEY
		BPL	HENKAN1
;
		STA	<WORK+5
;
		MEM8
		IDX8
		SEP	#00110000B
;
;;;		LDY	#02		;dekita data no 0 o tumeru
;;;HENKAN3		EQU	$
;;;		LDA	<WORK+3
;;;		BNE	HENKAN4
;;;		LDA	<WORK+4
;;;		STA	<WORK+3
;;;		LDA	<WORK+5
;;;		STA	<WORK+4
;;;		LDA	#07FH
;;;		STA	<WORK+5
;;;HENKAN4		EQU	$
;;;		DEY
;;;		BNE	HENKAN3
		LDX	#02		;bg no data ni naosu
HENKAN5		EQU	$
		LDA	<WORK+3,X
		CMP	#07FH
		BEQ	HENKAN6
		ORA	#090H
HENKAN6		EQU	$
		STA	<WORK+3,X
		DEX
		BPL	HENKAN5
		RTS
;
;
KAIHUKU		EQU	$
		LDA	>LFNWCT		;life no now >= max
		CMP	>LFITCT
		BCC	KAIHUKU0	;n
;					;y
		LDA	>LFITCT		;life o max ni suru( max < now no toki)
		STA	>LFNWCT
		LDA	#000H
		STA	>UPLFCT
;
		LDA	KAIFLG
		BNE	KAIHUKU5
		SEC			;OK ---> SEC
		RTL
KAIHUKU0	EQU	$
		LDA	#0A0H
		STA	>UPLFCT
KAIHUKU5	EQU	$
		CLC
		RTL
;
KAIHUKU1	EQU	$
		MEM8
		IDX8
		SEP	#00110000B
;
		LDA	#LOW  ILIFE	;doko ni kakuka o work+0,1,2 ni set
		STA	<WORK+0
		LDA	#HIGH ILIFE
		STA	<WORK+1
		LDA	#BANK ILIFE
		STA	<WORK+2
;
		DEC	KAICNT
		BNE	KAIHUKU3	;kaicnt = 0
		MEM16			;y (kakikae)
		IDX16
		REP	#00110000B
;
		LDA	>LFNWCT		;doko ni kakuka o X ni set
		AND	#000F8H
		DEC	A
		LSR	A
		LSR	A
		LSR	A
		ASL	A
		TAY
		CMP	#HARTMAX
		BCC	KAIHUKU2
		SBC	#HARTMAX
		TAY
		LDA	<WORK
		CLC
		ADC	#0064
		STA	<WORK
;
KAIHUKU2	EQU	$
		MEM8
		IDX8
		SEP	#00110000B
;
		LDX	KAIIDX		;tugi no frem o set
		LDA	>KAIFRM,X
		STA	KAICNT
		TXA			;BG no data o set
		ASL	A
		TAX
		LDA	>KAIDAT,X
		STA	[<WORK],Y
		INY
		LDA	>KAIDAT+1,X
		STA	[<WORK],Y
		LDA	KAIIDX
		INC	A
		AND	#03H
		STA	KAIIDX
		BNE	KAIHUKU3
;
;		LDA	>LFNWCT		;LIFE kaihuku
;		CLC
;		ADC	#0008
;		STA	>LFNWCT
;
;		LDA	#00DH		;OTO
;		STA	SOUND3			; <sound3>
;
;		LDA	>LFNWCT
;		CMP	>LFITCT
;		BCC	KAIHUKU4
;		LDA	>LFITCT
;		STA	>LFNWCT
;
KAIHUKU4	EQU	$
		MEM8
		IDX8
		SEP	#00110000B
;
		JSR	MTRON0
;
		STZ	KAIFLG
;
KAIHUKU3	EQU	$
		CLC			;NO --> CLC
		RTS
;
KAIMP		EQU	$
		MEM8
		IDX8
		SEP	#00110000B
;
		LDA	>MPNWCT		;MP no now >= max
		CMP	#080H
		BCS	KAIMP1		;n
;
		LDA	#080H
		STA	>UPMPCT
;
		MEM8
		IDX8
		SEP	#00110000B
;					NO ---> CLC
		RTL
;
KAIMP1		EQU	$
		MEM8
		IDX8
		SEP	#00110001B	;OK --> SEC
;
		RTL
;
;
;
;************************************************************************
;*		YAMAMOTO DATA.						*
;************************************************************************
BDATAM		EQU	$			;BITEM NAME
		WORD	KURODT,KURODT,KURODT,KURODT,KURODT,KURODT,KURODT,KURODT
		WORD	KURODT,KURODT,02574H,KURODT,KURODT,0256FH,KURODT,KURODT
;										
		WORD	KURODT,0242FH,KURODT,KURODT,KURODT,KURODT,KURODT,KURODT
		WORD	KURODT,0256BH,0243FH,02571H,02576H,0257CH,KURODT,KURODT
;										
		WORD	KURODT,KURODT,KURODT,KURODT,KURODT,KURODT,KURODT,KURODT
		WORD	0256BH,0257EH,02557H,0255BH,0257DH,0257EH,02563H,KURODT
;										
		WORD	KURODT,KURODT,0242FH,KURODT,0242FH,KURODT,KURODT,KURODT
		WORD	KURODT,KURODT,02419H,02407H,0240FH,0242DH,KURODT,KURODT
;										
		WORD	KURODT,KURODT,KURODT,KURODT,KURODT,KURODT,KURODT,KURODT
		WORD	KURODT,KURODT,02406H,02418H,02409H,KURODT,KURODT,KURODT
;										
		WORD	KURODT,KURODT,KURODT,KURODT,KURODT,KURODT,0242FH,KURODT
		WORD	0256BH,024AAH,02551H,02550H,0257AH,0257EH,02563H,KURODT
;										
		WORD	KURODT,KURODT,KURODT,KURODT,KURODT,KURODT,0242FH,KURODT
		WORD	KURODT,02550H,02551H,0255CH,0257AH,0257EH,02563H,KURODT
;										
		WORD	KURODT,KURODT,0242FH,KURODT,0242FH,KURODT,KURODT,KURODT
		WORD	KURODT,KURODT,0256DH,0257CH,02569H,0243FH,KURODT,KURODT
;										
		WORD	KURODT,KURODT,KURODT,KURODT,KURODT,KURODT,KURODT,KURODT
		WORD	KURODT,KURODT,02553H,0243FH,02562H,02578H,KURODT,KURODT
;										
		WORD	KURODT,KURODT,KURODT,KURODT,KURODT,KURODT,KURODT,KURODT
		WORD	KURODT,KURODT,0255BH,0244BH,02551H,02557H,KURODT,KURODT
;										
		WORD	KURODT,KURODT,KURODT,KURODT,KURODT,KURODT,KURODT,KURODT
		WORD	KURODT,KURODT,02555H,0257CH,02562H,02576H,KURODT,KURODT
;										
		WORD	KURODT,0242FH,KURODT,KURODT,KURODT,KURODT,KURODT,KURODT
		WORD	0256EH,0255BH,0257EH,02557H,02569H,0257CH,0256EH,0243FH
;										
		WORD	KURODT,KURODT,KURODT,KURODT,0242FH,KURODT,KURODT,KURODT
		WORD	KURODT,KURODT,0255BH,0244FH,0256CH,02578H,KURODT,KURODT
;										
		WORD	KURODT,KURODT,KURODT,KURODT,KURODT,KURODT,KURODT,KURODT
		WORD	KURODT,02420H,0240BH,02413H,02427H,02550H,0256FH,KURODT
;										
		WORD	KURODT,KURODT,0242FH,KURODT,KURODT,KURODT,KURODT,KURODT
		WORD	KURODT,02570H,02563H,02576H,02418H,0240BH,02430H,KURODT
;										
		WORD	KURODT,KURODT,KURODT,KURODT,KURODT,KURODT,KURODT,KURODT
		WORD	KURODT,KURODT,02406H,02418H,02409H,KURODT,KURODT,KURODT
;										
		WORD	KURODT,KURODT,KURODT,KURODT,KURODT,KURODT,KURODT,KURODT
		WORD	0255EH,0256EH,02577H,02550H,02418H,02561H,02553H,KURODT
;										
		WORD	KURODT,0242FH,KURODT,KURODT,KURODT,KURODT,KURODT,KURODT
		WORD	KURODT,02569H,02551H,02576H,02418H,02561H,02553H,KURODT
;										
		WORD	KURODT,0242FH,KURODT,KURODT,KURODT,KURODT,KURODT,KURODT
		WORD	0256EH,0255BH,0257EH,02557H,0256EH,0257CH,02563H,KURODT
;										
		WORD	KURODT,KURODT,KURODT,0242FH,KURODT,KURODT,KURODT,KURODT
		WORD	KURODT,KURODT,02412H,02405H,0241FH,KURODT,KURODT,KURODT
;										
BINMOJI		EQU	$
		WORD	KURODT,KURODT,KURODT,KURODT,KURODT,KURODT,KURODT,KURODT
		WORD	KURODT,KURODT,02406H,02418H,02409H,KURODT,KURODT,KURODT
;										
		WORD	KURODT,KURODT,0242FH,KURODT,KURODT,KURODT,KURODT,KURODT
		WORD	KURODT,KURODT,0241AH,KURODT,KURODT,0242DH,KURODT,KURODT
;										
		WORD	KURODT,KURODT,KURODT,KURODT,KURODT,KURODT,KURODT,KURODT
		WORD	02401H,02418H,02410H,02418H,KURODT,02557H,0255CH,02577H
;										
		WORD	KURODT,KURODT,KURODT,KURODT,KURODT,KURODT,KURODT,KURODT
		WORD	0241EH,0241DH,02402H,02418H,KURODT,02557H,0255CH,02577H
;
		WORD	KURODT,KURODT,KURODT,KURODT,KURODT,KURODT,KURODT,KURODT
		WORD	02401H,02418H,02410H,02413H,0241EH,0241DH,02402H,KURODT
;
		WORD	KURODT,KURODT,KURODT,KURODT,KURODT,KURODT,KURODT,KURODT
		WORD	KURODT,KURODT,02425H,02402H,0240DH,02401H,KURODT,KURODT
;
		WORD	KURODT,KURODT,KURODT,KURODT,KURODT,KURODT,KURODT,KURODT
		WORD	KURODT,KURODT,02569H,KURODT,KURODT,02560H,KURODT,KURODT
;
		WORD	KURODT,KURODT,0242FH,KURODT,KURODT,KURODT,KURODT,KURODT
		WORD	02404H,02402H,02409H,0242DH,02418H,02569H,02560H,KURODT
;
KONAMJI		EQU	$										
		WORD	KURODT,KURODT,KURODT,KURODT,KURODT,KURODT,KURODT,KURODT
		WORD	KURODT,0241EH,0241DH,02402H,02418H,02409H,02414H,KURODT
;										
OKARMJI		EQU	$										
		WORD	KURODT,KURODT,KURODT,KURODT,KURODT,KURODT,KURODT,KURODT
		WORD	KURODT,KURODT,02554H,02555H,02577H,02564H,KURODT,KURODT
;										
		WORD	KURODT,KURODT,KURODT,KURODT,KURODT,KURODT,KURODT,KURODT
		WORD	KURODT,KURODT,02554H,02555H,02577H,02564H,KURODT,KURODT
;										
TGMIMJI		EQU	$
		WORD	KURODT,0242FH,KURODT,KURODT,KURODT,KURODT,KURODT,KURODT
		WORD	0256EH,0255BH,02555H,02578H,0256FH,02576H,0243FH,KURODT
;
		WORD	02563H,02576H,02551H,KURODT,KURODT,KURODT,KURODT,KURODT
		WORD	KURODT,0256BH,024AFH,0243FH,0255CH,KURODT,KURODT,KURODT
;
YAAAMJI		EQU	$
		WORD	KURODT,KURODT,KURODT,KURODT,KURODT,KURODT,KURODT,KURODT
		WORD	KURODT,02573H,KURODT,02413H,KURODT,02574H,0256FH,KURODT
;										
		WORD	KURODT,KURODT,KURODT,KURODT,KURODT,KURODT,KURODT,KURODT
		WORD	KURODT,KURODT,02574H,KURODT,KURODT,0256FH,KURODT,KURODT
;										
		WORD	0242FH,KURODT,KURODT,KURODT,KURODT,KURODT,KURODT,KURODT
		WORD	02406H,0242DH,02418H,02573H,02413H,02574H,0256FH,KURODT
;										
;										
;
;
;
;
RITEM01		EQU	$
		WORD	020F5H,020F5H,020F5H,020F5H
		WORD	028BAH,028E9H,028E8H,028CBH	;yumi
		WORD	028BAH,0284AH,02849H,028CBH	;yimi & ya
		WORD	028BAH,028E9H,028E8H,028CBH	;yumi
		WORD	028BAH,028BBH,024CAH,028CBH	;yimi & ya
;
RITEM02		EQU	$
		WORD	020F5H,020F5H,020F5H,020F5H
		WORD	02CB8H,02CB9H,02CF5H,02CC9H
		WORD	024B8H,024B9H,024F5H,024C9H
;
RITEM03		EQU	$
		WORD	020F5H,020F5H,020F5H,020F5H
		WORD	024F5H,024F6H,024C0H,024F5H
;
RITEM04		EQU	$
		WORD	020F5H,020F5H,020F5H,020F5H
		WORD	02CB2H,02CB3H,02CC2H,06CC2H
;
RITEM05		EQU	$
		WORD	020F5H,020F5H,020F5H,020F5H
		WORD	02444H,02445H,02446H,02447H	;kinoko
		WORD	0203BH,0203CH,0203DH,0203EH	;kona
;
RITEM06		EQU	$
		WORD	020F5H,020F5H,020F5H,020F5H
		WORD	024B0H,024B1H,024C0H,024C1H
;
RITEM07		EQU	$
		WORD	020F5H,020F5H,020F5H,020F5H
		WORD	02CB0H,02CBEH,02CC0H,02CC1H
;
RITEM08		EQU	$
		WORD	020F5H,020F5H,020F5H,020F5H
		WORD	0287DH,0287EH,0E87EH,0E87DH
;
RITEM09		EQU	$
		WORD	020F5H,020F5H,020F5H,020F5H
		WORD	02876H,02877H,0E877H,0E876H
;
RITEM10		EQU	$
		WORD	020F5H,020F5H,020F5H,020F5H
		WORD	02866H,02867H,0E867H,0E866H
;
RITEM11		EQU	$
		WORD	020F5H,020F5H,020F5H,020F5H
		WORD	024BCH,024BDH,024CCH,024CDH
;
RITEM12		EQU	$
		WORD	020F5H,020F5H,020F5H,020F5H
		WORD	020B6H,020B7H,020C6H,020C7H
;
RITEM13		EQU	$
		WORD	020F5H,020F5H,020F5H,020F5H
		WORD	020D0H,020D1H,020E0H,020E1H
		WORD	02CD4H,02CD5H,02CE4H,02CE5H
		WORD	02CD4H,02CD5H,02CE4H,02CE5H
;
RITEM14		EQU	$
		WORD	020F5H,020F5H,020F5H,020F5H
		WORD	03C40H,03C41H,02842H,03C43H	;ami
;
RITEM15		EQU	$
		WORD	020F5H,020F5H,020F5H,020F5H
		WORD	03CA5H,03CA6H,03CD8H,03CD9H
;
RITEM16		EQU	$
RITEM29		EQU	$
RITEM30		EQU	$
RITEM31		EQU	$
RITEM32		EQU	$
		WORD	020F5H,020F5H,020F5H,020F5H
		WORD	02044H,02045H,02046H,02047H	;kinoko
		WORD	02837H,02838H,02CC3H,02CD3H	;kara
		WORD	024D2H,064D2H,024E2H,024E3H	;red
		WORD	03CD2H,07CD2H,03CE2H,03CE3H	;green
		WORD	02CD2H,06CD2H,02CE2H,02CE3H	;blue
		WORD	02855H,06855H,02C57H,02C5AH	;yosei
		WORD	02837H,02838H,02839H,0283AH	;hachi
		WORD	02837H,02838H,02839H,0283AH	;KIN hachi
;
RITEM17		EQU	$
		WORD	020F5H,020F5H,020F5H,020F5H
		WORD	024DCH,024DDH,024ECH,024EDH
;
RITEM18		EQU	$
		WORD	020F5H,020F5H,020F5H,020F5H
		WORD	02CDCH,02CDDH,02CECH,02CEDH
;
RITEM19		EQU	$
		WORD	020F5H,020F5H,020F5H,020F5H
		WORD	024B4H,024B5H,024C4H,024C5H
;
RITEM20		EQU	$
		WORD	020F5H,020F5H,020F5H,020F5H
		WORD	028DEH,028DFH,028EEH,028EFH	;TEGAMI
		WORD	02C62H,02C63H,02C72H,02C73H	;miror
		WORD	02886H,02887H,02888H,02889H	; T FORS
;
RITEM21		EQU	$
		WORD	020F5H,020F5H,020F5H,020F5H
		WORD	02130H,02131H,02140H,02141H
		WORD	028DAH,028DBH,028EAH,028EBH
;
RITEM22		EQU	$
		WORD	020F5H,020F5H,020F5H,020F5H
		WORD	03429H,0342AH,0342BH,0342CH
;
RITEM23		EQU	$
		WORD	020F5H,020F5H,020F5H,020F5H
		WORD	02C9AH,02C9BH,02C9DH,02C9EH
;
RITEM24		EQU	$
		WORD	020F5H,020F5H,020F5H,020F5H
		WORD	02433H,02434H,02435H,02436H	;tama
;
RITEM25		EQU	$
		WORD	020F5H,020F5H,020F5H,020F5H
;
RITEM26		EQU	$
		WORD	020F5H,020F5H,020F5H,020F5H
		WORD	02C64H,02CCEH,02C75H,03D25H	;KEN 1
		WORD	02C8AH,02C65H,02474H,03D26H     ;KEN 2
		WORD	0248AH,02465H,03C74H,02D48H     ;KEN 3
		WORD	0288AH,02865H,02C74H,02D39H     ;KEN 4
;
RITEM27		EQU	$
		WORD	024F5H,024F5H,024F5H,024F5H
		WORD	02CFDH,06CFDH,02CFEH,06CFEH	;TATE 1
		WORD	034FFH,074FFH,0349FH,0749FH	;TATE 2
		WORD	02880H,02881H,0288DH,0288EH	;TATE 3
;
RITEM28		EQU	$
		WORD	03C68H,07C68H,03C78H,07C78H	;HUKU 0
		WORD	02C68H,06C68H,02C78H,06C78H	;HUKU 1
		WORD	02468H,06468H,02478H,06478H	;HUKI 2
;
RITEM37		EQU	$
		WORD	020F5H,020F5H,020F5H,020F5H
		WORD	024BFH,064BFH,02CCFH,06CCFH
;
RITEM39		EQU	$
		WORD	020F5H,020F5H,020F5H,020F5H
		WORD	028D6H,068D6H,028E6H,028E7H
		WORD	0354BH,0354CH,0354DH,0354EH
;
RITEM41		EQU	$
		WORD	020F5H,020F5H,020F5H,020F5H
		WORD	028DEH,028DFH,028EEH,028EFH
;
RITM530		EQU	$				;PENDANT
		WORD	0313BH,0313CH,0313DH,0313EH
		WORD	0252BH,0252CH,0252DH,0252EH
;
RITM531		EQU	$
		WORD	0313BH,0313CH,0313DH,0313EH
		WORD	02D2BH,02D2CH,02D2DH,02D2EH
;
RITM532		EQU	$
		WORD	0313BH,0313CH,0313DH,0313EH
		WORD	03D2BH,03D2CH,03D2DH,03D2EH
;
RUPY000		EQU	$
		WORD	020F5H,020F5H,020F5H,020F5H
		WORD	03D30H,03D31H,03D40H,03D41H
;
HARTBK		EQU	$
		WORD	02484H,06484H,02485H,06485H
		WORD	024ADH,06484H,02485H,06485H
		WORD	024ADH,06484H,024AEH,06485H
		WORD	024ADH,064ADH,024AEH,06485H
;
;
;
;
YGROB		EQU	$
		WORD	02CF5H,02CF5H,02CF5H,02C2FH,02CF5H
		WORD	02CF5H,02C05H,02C11H,02C07H,02D28H
;
		WORD	02CF5H,02CF5H,02CF5H,02C2FH,02CF5H
		WORD	02CF5H,02C05H,02C11H,02C07H,02D29H
;
YDATA		EQU	$
		WORD	02CF5H,02CF5H,02CF5H,02C2FH,02CF5H	;KATUGU
		WORD	02CF5H,02C05H,02C11H,02C07H,02D27H
;
		WORD	02CF5H,02CF5H,02CF5H,02CF5H,02CF5H	;YOMU
		WORD	02CF5H,02CF5H,02C25H,02C20H,02CF5H
;
		WORD	02CF5H,02CF5H,02CF5H,02CF5H,02CF5H	;HANASU
		WORD	02CF5H,02CF5H,02C19H,02C14H,02C0CH
;
		WORD	02CF5H,02CF5H,0207FH,0207FH,0207FH	;DAMI
		WORD	02CF5H,02CF5H,0207FH,0207FH,0207FH
;
;
		WORD	02CF5H,02CF5H,02C2EH,02CF5H,02CF5H	HIKU
		WORD	02C1AH,02C31H,02C19H,02C28H,02CF5H
;
		WORD	02CF5H,02CF5H,02CF5H,02CF5H,02CF5H	;HASIRU
		WORD	02CF5H,02C19H,02C0BH,02C28H,02CF5H
;
		WORD	02CF5H,02CF5H,02CF5H,02C2FH,02CF5H	;OYOGU
		WORD	02CF5H,02C04H,02C25H,02C07H,02CF5H
;
		WORD	02CF5H,02CF5H,02CF5H,0207FH,0207FH	;DAMI
		WORD	02C01H,02C18H,02C28H,0207FH,0207FH
;
TBL16_10	EQU	$
		WORD	00010,00100
;
LFDAT0		EQU	$		;life meter no max write (siro waku)(gusuu)
		WORD	024A2H
		WORD	024A2H
		WORD	024A2H
;
LFDAT1		EQU	$		;life meter no now write (gusuu)
		WORD	024A2H
		WORD	024A1H
		WORD	024A0H
;
KAIDAT		EQU	$		;kaihuku no data
		WORD	024A3H
		WORD	024A4H
		WORD	024A3H
		WORD	024A0H
;
KAIFRM		EQU	$		;kaihuku no frem su
		BYTE	01		;2
		BYTE	01		;3
		BYTE	01		;4
		BYTE	01		;1(2 kaime ikou)
;
;
BTFRDAT		EQU	$		;B item no data(TFR)
		BYTE	000H		;NOT ITEM
		BYTE	YUMIYA
		BYTE	BUMERN
		BYTE	HUKUUU
		BYTE	BOMBER
		BYTE	KONAAA
		BYTE	ROD001
		BYTE	ROD002
		BYTE	SBOMBE
		BYTE	STHAND
		BYTE	SGISIN
		BYTE	LAMPUU
		BYTE	HANMER
		BYTE	SCOPUU
		BYTE	HUEEEE
		BYTE	BIN002
		BYTE	BIN001
		BYTE	SOROMN
		BYTE	BIN003
		BYTE	KAKURE
		BYTE	TRAIFS
;
YTFRDAT		EQU	$		;Y item no data(TFR)
		BYTE	000H		;a  i  sa tu
		BYTE	001H		;i  no ru
		BYTE	006H		;ta be ru
		BYTE	002H		;ne ru
		BYTE	007H		;ka tu gu
		BYTE	003H		;ho ru
		BYTE	005H		;o  do ru
		BYTE	004H		;u  ta u
		BYTE	008H		;o  yo gu
;
;ETFRDAT		EQU	$-1		;E item no data(TFR)
;		BYTE	000
;		BYTE	000
;		BYTE	000
;		BYTE	000
;		BYTE	000
;		BYTE	001
;		BYTE	002
;		BYTE	003
;		BYTE	000
;		BYTE	000
;		BYTE	000
;		BYTE	000
;		BYTE	000
;		BYTE	000
;		BYTE	000
;		BYTE	000
;
NUKIDT		EQU	0207FH		;KURO NUKI DATA
KURODT		EQU	024F5H		;KURO NUKI DATA
;
;
;
;************************************************************************
;*		Lamp on/off check			(LMPCHCK)	*
;************************************************************************
LMPCHCK		EQU	$
;// 03.04.18 //		LDA	!BPSHMD
;// 03.04.18 //;// 02.10.22 //		CMP	#004H
;// 03.04.18 //		CMP	#LAMPUU
;// 03.04.18 //		BNE	LMPCK480	; lamp on ?
;// 03.04.18 //;					; yes
		LDA	>ITEMR11
		BEQ	LMPCK180	; kantera on ?
;					; yes
		LDA	>DARKFG
		BEQ	LMPCK180	; now-dark ?
;					; yes
		LDA	!LGTWFG
		BNE	LMPCK180	; light-wipe on ?
;					; no
;// 03.04.01 //		LDA	!LGTWST
;// 03.04.01 //		CMP	#003H
;// 03.05.10 //		LDX	!LGTWST
;// 03.05.10 //		CPX	#003H
;// 03.05.10 //		BCS	LMPCK180	; light-wipe on ?
;// 03.05.10 //;					; yes
		LDA	!LGTWST
		BNE	LMPCK180	; light-wipe on ?
;					; yes
		INC	!LGTWFG
;
		LDA	!GSUBFG
		CMP	#002H
		BEQ	LMPCK180	;
;					;
		LDA	#00000001B
		STA	<DPSUB
;// 03.04.01 //		INC	A
;// 03.04.01 //		TAX
;// 03.04.01 //		LDA	>DARKDT,X
;// 03.04.01 //		STA	>DKRMCG
;// 03.04.01 //		LDA	#p1_ltwp
;// 03.04.01 //		STA	<GAMEMD
;// 03.04.01 //		STZ	<JRSBPT
;// 03.04.01 //		INC	!LGTWFG		; light-wipe on
;// 03.04.01 //		JSL	>LGTWPIT	; light-wipe set
;// 03.04.01 //		LDA	#00010010B
;// 03.04.01 //		STA	<WD2130
LMPCK180	EQU	$
		RTL
;
;// 03.04.18 //LMPCK480	EQU	$
;// 03.04.18 //		LDA	!LGTWFG
;// 03.04.18 //		BEQ	LMPCK180	; light-wipe on ?
;// 03.04.18 //;					; yes
;// 03.04.18 //		STZ	!LGTWFG
;// 03.04.18 //		STZ	<DPSUB
;// 03.04.18 //;// 03.04.01 //		DEC	!LGTWST
;// 03.04.18 //;// 03.04.01 //		LDX	!LGTWST
;// 03.04.18 //;// 03.04.01 //		LDA	>DARKDT,X
;// 03.04.18 //;// 03.04.01 //		STA	>DKRMCG
;// 03.04.18 //;// 03.04.01 //		LDA	#p1_ltwp
;// 03.04.18 //;// 03.04.01 //		STA	<GAMEMD
;// 03.04.18 //;// 03.04.01 //		STZ	<JRSBPT
;// 03.04.18 //;// 03.04.01 //		STZ	!LGTWFG		; light-wipe off
;// 03.04.18 //;// 03.04.01 //		LDA	#00000010B
;// 03.04.18 //;// 03.04.01 //		STA	<WD2130
;// 03.04.18 //		RTL
;
;
;
;// 03.03.05 //;
;// 03.03.05 //;************************************************************************
;// 03.03.05 //;*		Lamp on/off check			(LMPCHCK)	*
;// 03.03.05 //;************************************************************************
;// 03.03.05 //LMPCHCK		EQU	$
;// 03.03.05 //		LDA	!BPSHMD
;// 03.03.05 //;// 02.10.22 //		CMP	#004H
;// 03.03.05 //		CMP	#LAMPUU
;// 03.03.05 //		BNE	LMPCK480	; lamp on ?
;// 03.03.05 //;					; yes
;// 03.03.05 //		LDA	>DARKFG
;// 03.03.05 //		BEQ	LMPCK180	; now-dark ?
;// 03.03.05 //;					; yes
;// 03.03.05 //		LDA	!LGTWFG
;// 03.03.05 //		BNE	LMPCK180	; light-wipe on ?
;// 03.03.05 //;					; no
;// 03.03.05 //		LDA	!LGTWST
;// 03.03.05 //		CMP	#003H
;// 03.03.05 //		BCS	LMPCK180	; light-wipe on ?
;// 03.03.05 //;					; yes
;// 03.03.05 //		TAX
;// 03.03.05 //		LDA	>CCNGED
;// 03.03.05 //		DEC	A
;// 03.03.05 //		STA	>CCNGCT
;// 03.03.05 //		LDA	>CGEDPT,X
;// 03.03.05 //		STA	>CCNGED
;// 03.03.05 //		LDA	#p1_ltwp
;// 03.03.05 //		STA	<GAMEMD
;// 03.03.05 //		STZ	<JRSBPT
;// 03.03.05 //		LDA	#002H
;// 03.03.05 //		STA	>CCNGFG		; fade-in set
;// 03.03.05 //		INC	!LGTWFG		; light-wipe on
;// 03.03.05 //		JSL	>LGTWPIT	; light-wipe set
;// 03.03.05 //		LDA	#00010000B
;// 03.03.05 //		STA	<WD2130
;// 03.03.05 //		LDA	#01110010B
;// 03.03.05 //		STA	<WD2131		; color-add. mode set
;// 03.03.05 //LMPCK180	EQU	$
;// 03.03.05 //		RTL
;// 03.03.05 //;
;// 03.03.05 //LMPCK480	EQU	$
;// 03.03.05 //		LDA	!LGTWFG
;// 03.03.05 //		BEQ	LMPCK180	; light-wipe on ?
;// 03.03.05 //;					; yes
;// 03.03.05 //		LDA	>CCNGED
;// 03.03.05 //		STA	>CCNGCT
;// 03.03.05 //		DEC	!LGTWST
;// 03.03.05 //		LDX	!LGTWST
;// 03.03.05 //		LDA	>CGEDPT-1,X
;// 03.03.05 //		STA	>CCNGED
;// 03.03.05 //		LDA	#p1_ltwp
;// 03.03.05 //		STA	<GAMEMD
;// 03.03.05 //		STZ	<JRSBPT
;// 03.03.05 //		LDA	#000H
;// 03.03.05 //		STA	>CCNGFG		; fade-out set
;// 03.03.05 //		STZ	!LGTWFG		; light-wipe off
;// 03.03.05 //		LDA	#00000010B
;// 03.03.05 //		STA	<WD2130
;// 03.03.05 //		LDA	#00100000B
;// 03.03.05 //		STA	<WD2131		; sub-add. mode set
;// 03.03.05 //		RTL
;// 03.03.05 //;
;
;
;// 03.02.08 //;************************************************************************
;// 03.02.08 //;*		Mater off				(MTROFF)	*
;// 03.02.08 //;************************************************************************
;// 03.02.08 //MTROFF		EQU	$
;// 03.02.08 //		MEM16
;// 03.02.08 //		IDX16
;// 03.02.08 //		REP	#00110000B	; memory,index 16bit mode
;// 03.02.08 //;
;// 03.02.08 //		LDX	#00000H
;// 03.02.08 //MTR040		EQU	$
;// 03.02.08 //		LDA	>MTRBUF+000H,X
;// 03.02.08 //		AND	#1110001111111111B
;// 03.02.08 //		STA	>MTRBUF+000H,X
;// 03.02.08 //;
;// 03.02.08 //		LDA	>MTRBUF+040H,X
;// 03.02.08 //		AND	#1110001111111111B
;// 03.02.08 //		STA	>MTRBUF+040H,X
;// 03.02.08 //;
;// 03.02.08 //		LDA	>MTRBUF+080H,X
;// 03.02.08 //		AND	#1110001111111111B
;// 03.02.08 //		STA	>MTRBUF+080H,X
;// 03.02.08 //;
;// 03.02.08 //		LDA	>MTRBUF+0C0H,X
;// 03.02.08 //		AND	#1110001111111111B
;// 03.02.08 //		STA	>MTRBUF+0C0H,X
;// 03.02.08 //;
;// 03.02.08 //		LDA	>MTRBUF+100H,X
;// 03.02.08 //		AND	#1110001111111111B
;// 03.02.08 //		STA	>MTRBUF+100H,X
;// 03.02.08 //		INX
;// 03.02.08 //		INX
;// 03.02.08 //		CPX	#00040H
;// 03.02.08 //		BNE	MTR040		; end ?
;// 03.02.08 //;					; yes
;// 03.02.08 //MTR080		EQU	$
;// 03.02.08 //		LDA	>MTRBUF+100H,X
;// 03.02.08 //		AND	#1110001111111111B
;// 03.02.08 //		STA	>MTRBUF+100H,X
;// 03.02.08 //		INX
;// 03.02.08 //		INX
;// 03.02.08 //		CPX	#0004AH
;// 03.02.08 //		BNE	MTR080		; end ?
;// 03.02.08 //;					; yes
;// 03.02.08 //		BRA	MTR200
;// 03.02.08 //;
;
;************************************************************************
;*		soto BANK mater on  			(MTRSUB)	*
;************************************************************************
MTRSUB		EQU	$
		PHB
		PHK
		PLB
		JSR	MTRON0
		PLB
		RTL
;
;
;
		MEM8
		IDX8
;************************************************************************
;*		Mater on				(MTRON0)	*
;************************************************************************
MTRON3		EQU	$
		LDA	#000H
		STA	>DKRMCG		; R.G.B. off
;
		LDA	#0FFH
MTRON4		EQU	$
		STA	>ITMTBL9	; key count set
MTRON2		EQU	$
		JSR	MTRON0
		RTL
;
MTRON0		EQU	$
		MEM16
		IDX16
		REP	#00110000B	; memory,index 16bit mode
;
		PHB			; (DBR) push
		LDA	#MTRDTEN-MTRDATA-1
		LDX	#MTRDATA
		LDY	#MTRBUF
		MVN	#BANK MTRDATA,#BANK MTRBUF
;;		MVN	#002H,#07EH
		PLB			; (DBR) pull
;
		PHB
		PHK
		PLB			; (DBR) set
;
;// 03.02.08 //		LDA	#0FFFFH
		BRA	MTR100
;
;
;************************************************************************
;*		Mater off				(MTRON1)	*
;************************************************************************
MTRON1		EQU	$
		MEM16
		IDX16
		REP	#00110000B	; memory,index 16bit mode
;
		PHB
		PHK
		PLB			; (DBR) set
;
;// 03.02.08 //		LDA	#1110001111111111B
MTR100		EQU	$
		JSR	MTRINWT		; mater in write
;
		PLB			; (DBR) reset
MTR200		EQU	$
		MEM8
		IDX8
		SEP	#00110000B	; (DBR) pull
;
		INC	<B3CHFG		; mater write flag on
		RTS
;
;
;
;
;-----------------------------------------------------------------------
STGITRM		EQU	$
		WORD	RITEM01,RITEM02,RITEM03,RITEM04,RITEM05
		WORD	RITEM06,RITEM07,RITEM08,RITEM09,RITEM10
		WORD	RITEM11,RITEM12,RITEM13,RITEM14,RITEM15
		WORD	RITEM16,RITEM17,RITEM18,RITEM19,RITEM20
		WORD	RITEM21,RITEM22,RITEM23,RITEM24,RITEM25
		WORD	RITEM26,RITEM27,RITEM28,RITEM29,RITEM30
		WORD	RITEM31,RITEM32,RUPY000
;		WORD	RITEM37,RITEM39,RITEM41
;
STGITWM		EQU	$
		WORD	WITEM01,WITEM02,WITEM03,WITEM04,WITEM05
		WORD	WITEM06,WITEM07,WITEM08,WITEM09,WITEM10
;
		WORD	WITEM11,WITEM12,WITEM13,WITEM14,WITEM15
		WORD	WITEM16,WITEM17,WITEM18,WITEM19,WITEM20
;
;		WORD	WITEM21,WITEM22,WITEM23,WITEM24,WITEM25
;		WORD	WITEM26,WITEM27,WITEM28,WITEM29,WITEM30
;
YAAAUCD		EQU	02486H
YAAADCD		EQU	02487H
SETGITM		EQU	$
;
;		<WORK0,1 : TFR SAKI SET
;
;		<WORK2,3 : NO. SET(NANBANME)
;
;		<WORK4,5 : TFR MOTO
;
;		GETITM0,+1  : ITEM NO.
;
		MEM8
		IDX8
		SEP	#00110000B
;
		LDA	>ITEMR01
		BEQ	STGIM25
		CMP	#003
		BCC	STGIM23
		LDA	#LOW  YAAAUCD
		STA	>IYA-040H
		LDA	#HIGH YAAAUCD
		STA	>IYA-03FH
		LDA	#LOW  YAAADCD
		STA	>IYA-03EH
		LDA	#HIGH YAAADCD
		STA	>IYA-03DH
		LDX	#004H
		LDA	>ARWCNT
		BNE	STGIM20
		LDX	#003H
		BRA	STGIM20
;
STGIM23		EQU	$
		LDX	#002H
		LDA	>ARWCNT
		BNE	STGIM20
		LDX	#001H
STGIM20		EQU	$
		TXA
		STA	>ITEMR01	;ya init set
;
STGIM25		EQU	$
		MEM16
		IDX16
		REP	#00110000B
;
		LDX	GETITM0
		BEQ	STGIM10
		LDA	>ITEMR01-1,X
		AND	#000FFH
		CPX	#00004		;? BOMB 
		BNE	STGIM30		;
		LDA	#00001H		;Y
STGIM30		EQU	$
		CPX	#00016		;? BIN SELECT
		BNE	STGIM40
		TXY
		TAX			;Y
		LDA	>BINCT0-1,X
		AND	#000FFH
		TYX
STGIM40		EQU	$
		STA	<WORK2
		TXA
		DEC	A
		ASL	A
		TAX
		LDA	STGITRM,X
		STA	<WORK4
;
		LDA	<WORK2		;TFR MOTO GET
		ASL	A
		ASL	A
		ASL	A
		TAY
;
		LDA	(<WORK4),Y
		STA	>MWAKU7+044H+000H
		INY
		INY
		LDA	(<WORK4),Y
		STA	>MWAKU7+044H+002H
		INY
		INY
		LDA	(<WORK4),Y
		STA	>MWAKU7+044H+040H
		INY
		INY
		LDA	(<WORK4),Y
		STA	>MWAKU7+044H+042H
;
STGIM10		EQU	$
		RTS
;----------------------------------------
		MEM16
		IDX16
;
MTRINWT		EQU	$		; mater in write
BITMWT		EQU	$
;
		JSR	SETGITM		;SET ITEM B
;
LIFEWT		EQU	$
		MEM8
		IDX8
		SEP	#00110000B
;					;life no max
		LDA	#LOW  LFDAT0	;dono data o kakuka o work+10,11,12 ni set
		STA	<WORK+10
		LDA	#HIGH LFDAT0
		STA	<WORK+11
		LDA	#BANK LFDAT0
		STA	<WORK+12
;
		LDA	#LOW  ILIFE	;doko ni kakuka o work+7,8,9 ni set
		STA	<WORK+7
		LDA	#HIGH ILIFE
		STA	<WORK+8
		LDA	#BANK ILIFE
		STA	<WORK+9
;
		MEM16
		IDX16
		REP	#00110000B	; memory,index 16bit mode
;
		LDA	>LFITCT		;nani o kakuka o set(doredake kakuka)
		AND	#000FFH
		STA	<WORK		;henkan suru atai
		STA	<WORK+2		;henkan suru mono no max
		STA	<WORK+4		;henkan suru mono no now
;
		JSR	WRITEMT
;					;life no nokori
		MEM8
		IDX8
		SEP	#00110000B	; memory,index 8bit mode
;
		LDA	#LOW  LFDAT1	;dono data o kakuka o work+10,11,12 ni set
		STA	<WORK+10
		LDA	#HIGH LFDAT1
		STA	<WORK+11
		LDA	#BANK LFDAT1
		STA	<WORK+12
;
		LDA	#LOW  ILIFE	;doko ni kakuka o work+7,8,9 ni set
		STA	<WORK+7
		LDA	#HIGH ILIFE
		STA	<WORK+8
		LDA	#BANK ILIFE
		STA	<WORK+9
;
		LDA	>LFITCT
		CMP	>LFNWCT
		BEQ	LFWT10
		SEC
		SBC	#004H
		CMP	>LFNWCT
		BCS	LFWT10
;		LDA	>LFNWCT
;		BRA	LFWT20
;
LFWT10		EQU	$
		LDA	>LFNWCT		;nani o kakuka o set(doredake kakuka)
		CLC
		ADC	#003H
LFWT20		EQU	$
		MEM16
		IDX16
		REP	#00110000B	; memory,index 16bit mode
;
		AND	#000FCH
		STA	<WORK		;henkan suru atai
		STA	<WORK+4		;henkan suru mono no now
;
		LDA	>LFITCT		;life no max o set
		AND	#000FFH
		STA	<WORK+2		;henkan suru mono no max
;
		JSR	WRITEMT
;					;life no nokori
;		MEM8
;		IDX8
;		SEP	#00110000B	; memory,index 8bit mode
;
;
MPWT		EQU	$
;
		MEM16
		IDX16
		REP	#00110000B
;
		LDA	>MPLVFG
		AND	#000FFH
		CMP	#001H
		BCC	MPWT10
		LDA	#MPMTMD0
		STA	>IMP-042H	;M WRITE
		LDA	#MPMTMD1
		STA	>IMP-040H	;M WRITE
		LDA	#MPMTMD2
		STA	>IMP-03EH	;M WRITE
MPWT10		EQU	$
		LDA	>MPNWCT
		AND	#000FFH
		CLC
		ADC	#00007H
		AND	#0FFF8H
		TAX
		LDA	MPMTRDT+00H,X	;METER 1
		STA	>IMP+000H
		LDA	MPMTRDT+02H,X	;METER 2
		STA	>IMP+040H
		LDA	MPMTRDT+04H,X	;METER 3
		STA	>IMP+080H
		LDA	MPMTRDT+06H,X	;METER 4
		STA	>IMP+0C0H
;
;		MEM8
;		IDX8
;		SEP	#00110000B
;
;
COINWT		EQU	$
;		MEM16
;		IDX16
;		REP	#00110000B
;
		LDA	>CONPRT		;COIN no kazu o 10 sin ni suru
		JSR	HENKAN		;16 --> 10
;
		MEM16
		IDX16
		REP	#00110000B
;
		LDA	<WORK+3
		AND	#00FFH
		ORA	#2400H
;// 03.02.08 //		AND	<WORKE
		STA	>ICOIN
		LDA	<WORK+4
		AND	#00FFH
		ORA	#2400H
;// 03.02.08 //		AND	<WORKE
		STA	>ICOIN+2
		LDA	<WORK+5
		AND	#00FFH
		ORA	#2400H
;// 03.02.08 //		AND	<WORKE
		STA	>ICOIN+4
;
;
BOMBWT		EQU	$
;                MEM16
;                IDX16
;                REP     #00110000B
;
                LDA     >BMBCNT          ;BOMB no kazu o 10 sin ni suru
		AND	#000FFH
                JSR     HENKAN          ;16 --> 10
;
                MEM16
                IDX16
                REP     #00110000B
;
		LDA	<WORK+4
		AND	#00FFH
		ORA	#2400H
;// 03.02.08 //		AND	<WORKE
		STA	>IBOMB
                LDA     <WORK+5
                AND     #00FFH
                ORA     #2400H
;// 03.02.08 //		AND	<WORKE
		STA	>IBOMB+2
;
;
WTYA		EQU	$
;                MEM16
;                IDX16
;                REP     #00110000B
;
                LDA     >ARWCNT          ;YA no kazu o 10 sin ni suru
                AND     #00FFH
                JSR     HENKAN          ;16 --> 10
;
                MEM16
                IDX16
                REP     #00110000B
;
                LDA     <WORK+4
                AND     #00FFH
                ORA     #2400H
;// 03.02.08 //		AND	<WORKE
		STA	>IYA
                LDA     <WORK+5
                AND     #00FFH
                ORA     #2400H
;// 03.02.08 //		AND	<WORKE
		STA	>IYA+2
;                LDA     <WORK+5
;                AND     #00FFH
;                ORA     #2400H
;;// 03.02.08 //		AND	<WORKE
;		STA	>IYA+4
;
;		MEM8
;		IDX8
;		SEP	#00110000B
;
WTKEY		EQU	$
;                MEM16
;                IDX16
;                REP     #00110000B
;
		LDA	#0007FH		;NUKI
		STA	<WORK+5
                LDA     >ITMTBL9        ;KEY no kazu o 10 sin ni suru
                AND     #00FFH
		CMP	#00FFH
		BEQ	WTKEY20
                JSR     HENKAN          ;16 --> 10
;
WTKEY20		EQU	$
                MEM16
                IDX16
                REP     #00110000B
;
                LDA     <WORK+5
                AND     #00FFH
                ORA     #2400H
		STA	>IKEY+2
		CMP	#0247FH
		BNE	WTKEY10
		STA	>IKEY+2-40H
;
WTKEY10		EQU	$
		MEM8
		IDX8
		SEP	#00110000B
;
		RTS			;NOT TAME BEEM
;----------------------------------------
WTTMBM		EQU	$
		MEM16
		IDX16
		REP	#00110000B
;
		LDA	>MPNWCT
		AND	#00020H
		BNE	WTTMBM2
		BRL	WTTMBMEX1
;
WTTMBM2		EQU	$
		LDA	#00C00H
		STA	<WORKE
		LDA	TMBMCT
		CMP	#00020H
		BCC	WTTMBM21
		LDA	SLMODE
		AND	#000FFH
		CMP	#MD_etcpl
		BEQ	WTTMBM21
		LDA	FRCNT
		AND	#00004H
		BNE	WTTMBM6
WTTMBM21	EQU	$
		LDA	TMBMCT
		BEQ	WTTMBMEX1		;MP = 0?
		LDX	#00000H
		LDA	TMBMCT
		LSR	A
		LSR	A
		BEQ	WTTMBMEX1
		TAY			;n
		LDA	#02082H
		ORA	<WORKE
WTTMBM5		EQU	$		;MP 1 masu 
		STA	>IMP-4,X
		INX
		INX
		DEY
		BNE	WTTMBM5
;
WTTMBMEX	EQU	$
		LDA	TMBMCT
		CMP	#00020H
;		BCC	WTTMBMEX2
		BRA	WTTMBMEX2
		LDA	#020A5H
		ORA     <WORKE
		STA	>IMP-4,X
		LDA	#020A6H
		ORA     <WORKE
		STA	>IMP-2,X
		BRA	WTTMBMEX1
WTTMBMEX2       EQU     $
		LDA	TMBMCT
		LSR	A
		LSR	A
		BCS	WTTMBMEX3
		LDA	#02080H
		ORA     <WORKE
		STA	>IMP-4,X
		LDA	#02081H
		ORA     <WORKE
		STA	>IMP-2,X
		BRA	WTTMBMEX1
WTTMBMEX3	EQU	$
		LDA	#02083H
		ORA     <WORKE
		STA	>IMP-4,X
		LDA	#02084H
		ORA     <WORKE
		STA	>IMP-2,X
		LDA	#02085H
		ORA     <WORKE
		STA	>IMP-0,X
;
WTTMBMEX1	EQU	$
		MEM8
		IDX8
		SEP	#00110000B	; memory,index 8bit mode
;
		RTS
;
WTTMBM6		EQU	$
		MEM16
		IDX16
;
		LDX	#00012H
		LDA	#207FH
WTTMBM7		EQU	$
		STA	>IMP-4,X
		DEX
		DEX
		BPL	WTTMBM7
		BRA	WTTMBMEX1
;
;
WRITEMT		EQU	$		;meta o kaku
		MEM16
		IDX16
;
		LDX	#0000
WTMT1		EQU	$
		LDA	<WORK
		CMP	#0008		;max?
		BCC	WTMT2
		SBC	#0008
		STA	<WORK
		LDY	#0004
		JSR	WTMTSB
		INX
		INX
		BRA	WTMT1
WTMT2		EQU	$
		CMP	#0005		;max-1?
		BCC	WTMT3
		LDY	#0004
		BRA	WTMTSB
WTMT3		EQU	$
		CMP	#0001		;max-2?
		BCC	WTMT4
		LDY	#0002
		BRA	WTMTSB
WTMT4		EQU	$
		RTS
;
;
WTMTSB		EQU	$
		CPX	#HARTMAX
		BCC	WTMTSB1
		LDX	#0000
		LDA	<WORK+7
		CLC
		ADC	#0064
		STA	<WORK+7
WTMTSB1		EQU	$
		LDA	[<WORK+10],Y
		TXY
;// 03.02.08 //		AND	<WORKE
		STA	[<WORK+7],Y
		RTS
;
;---
MPMTMD0		EQU	028F7H
MPMTMD1		EQU	02851H
MPMTMD2		EQU	028FAH
;
MPMTRDT		EQU	$
		WORD	03CF5H,03CF5H,03CF5H,03CF5H	; 0
		WORD	03CF5H,03CF5H,03CF5H,03C5FH	; 1
		WORD	03CF5H,03CF5H,03CF5H,03C4CH	; 2
		WORD	03CF5H,03CF5H,03CF5H,03C4DH	; 3
		WORD	03CF5H,03CF5H,03CF5H,03C4EH	; 4
		WORD	03CF5H,03CF5H,03C5FH,03C5EH	; 5
		WORD	03CF5H,03CF5H,03C4CH,03C5EH	; 6
		WORD	03CF5H,03CF5H,03C4DH,03C5EH	; 7
		WORD	03CF5H,03CF5H,03C4EH,03C5EH	; 8
		WORD	03CF5H,03C5FH,03C5EH,03C5EH	; 9
		WORD	03CF5H,03C4CH,03C5EH,03C5EH	; A
		WORD	03CF5H,03C4DH,03C5EH,03C5EH	; B
		WORD	03CF5H,03C4EH,03C5EH,03C5EH	; C
		WORD	03C5FH,03C5EH,03C5EH,03C5EH	; D
		WORD	03C4CH,03C5EH,03C5EH,03C5EH	; E
		WORD	03C4DH,03C5EH,03C5EH,03C5EH	; F
		WORD	03C4EH,03C5EH,03C5EH,03C5EH	;10
;
;------------------------------------------------------------------------
MTRDATA		EQU	$
		WORD	0207FH,0207FH,02850H,0A856H,02852H,0285BH,0285BH,0285CH
		WORD	0207FH,03CA8H,0207FH,0207FH,02C88H,02C89H,0207FH,020A7H
		WORD	020A9H,0207FH,02871H,0207FH,0207FH,0207FH,0288BH,0288FH
		WORD	024ABH,024ACH,0688FH,0688BH,0207FH,0207FH,0207FH,0207FH
;
		WORD	0207FH,0207FH,02854H,02871H,02858H,0207FH,0207FH,0285DH
		WORD	0207FH,0207FH,0207FH,0207FH,0207FH,0207FH,0207FH,0207FH
		WORD	0207FH,0207FH,0207FH,0207FH,0207FH,0207FH,0207FH,0207FH
		WORD	0207FH,0207FH,0207FH,0207FH,0207FH,0207FH,0207FH,0207FH
;
		WORD	0207FH,0207FH,02854H,0304EH,02858H,0207FH,0207FH,0285DH
		WORD	0207FH,0207FH,0207FH,0207FH,0207FH,0207FH,0207FH,0207FH
		WORD	0207FH,0207FH,0207FH,0207FH,0207FH,0207FH,0207FH,0207FH
		WORD	0207FH,0207FH,0207FH,0207FH,0207FH,0207FH,0207FH,0207FH
;
		WORD	0207FH,0207FH,02854H,0305EH,02859H,0A85BH,0A85BH,0A85CH
		WORD	0207FH,0207FH,0207FH,0207FH,0207FH,0207FH,0207FH,0207FH
		WORD	0207FH,0207FH,0207FH,0207FH,0207FH,0207FH,0207FH,0207FH
		WORD	0207FH,0207FH,0207FH,0207FH,0207FH,0207FH,0207FH,0207FH
;
		WORD	0207FH,0207FH,02854H,0305EH,06854H,0207FH,0207FH,0207FH
		WORD	0207FH,0207FH,0207FH,0207FH,0207FH,0207FH,0207FH,0207FH
		WORD	0207FH,0207FH,0207FH,0207FH,0207FH,0207FH,0207FH,0207FH
		WORD	0207FH,0207FH,0207FH,0207FH,0207FH,0207FH,0207FH,0207FH
;
		WORD	0207FH,0207FH,0A850H,02856H,0E850H
MTRDTEN		EQU	$
;
;// 03.01.10 //		WORD	0207FH,0207FH,0207FH,0207FH,024ABH,024ACH,0207FH,0207FH
;// 03.01.10 //		WORD	0207FH,0207FH,0207FH,0207FH,0207FH,0207FH,0207FH,0207FH
;// 03.01.10 //		WORD	0207FH,0207FH,0207FH,0207FH,0207FH,028FAH,028F9H,028F9H
;// 03.01.10 //		WORD	028F9H,028F9H,028F9H,028F9H,028F9H,028F9H,068FAH,0207FH
;// 03.01.10 //;
;// 03.01.10 //		WORD	0207FH,0209DH,0209EH,0207FH,0207FH,0207FH,0207FH,0207FH
;// 03.01.10 //		WORD	0207FH,0207FH,0207FH,0207FH,0207FH,0207FH,0207FH,0207FH
;// 03.01.10 //		WORD	0207FH,0207FH,0207FH,0207FH,0207FH,028FCH,0249BH,020F5H
;// 03.01.10 //		WORD	020F5H,0249CH,020F5H,020F5H,020F5H,020F5H,068FCH,0207FH
;// 03.01.10 //;
;// 03.01.10 //		WORD	0207FH,0209FH,0209FH,0207FH,02CADH,02CAEH,06C57H,02C56H
;// 03.01.10 //		WORD	02C56H,02C56H,02C56H,02C56H,02C56H,02C57H,0207FH,0207FH
;// 03.01.10 //		WORD	0207FH,0207FH,0207FH,0207FH,0207FH,028FCH,020F5H,020F5H
;// 03.01.10 //		WORD	020F5H,020F5H,020F5H,020F5H,020F5H,020F5H,068FCH,0207FH
;// 03.01.10 //;
;// 03.01.10 //		WORD	0207FH,024FDH,024FEH,0207FH,028A8H,0207FH,0207FH,0207FH
;// 03.01.10 //		WORD	0207FH,02CA9H,0207FH,0207FH,0207FH,038A7H,0207FH,0207FH
;// 03.01.10 //		WORD	0207FH,0207FH,0207FH,0207FH,0207FH,0A8FAH,0A8F9H,0A8F9H
;// 03.01.10 //		WORD	0A8F9H,0A8F9H,0A8F9H,0A8F9H,0A8F9H,0A8F9H,0E8FAH,0207FH
;
;
;
;
;
;
		END
