;
		INCLUDE	zel_ram.asm
;
;--------------------------------------------------------------------
;
;		ZELDA-3			1991.06.24(MON)
;
;--------------------------------------------------------------------
;
		ORG	02B800H
;
;=============================================== (zel_isub) =========
		GLB	BGMDST,INBGWT1,WD2132IT
		GLB	TINCLST,INCLST0,INCLST1,INCLST11,CGWKST,CGWKST1,CGWKST2
		GLB	INHDMA2
;
		GLB	IIT1000,IIT2000,IIT3000,IIT4000,IIT5000
;
		GLB	MPTOGD,MPINT0,MPALST,GDMMRST
;;;;;;;;		GLB	GDRIT0,GDRIT1
		GLB	MPMAIN,GNXBGWT,WTVRAM,GSLBGWT
		GLB	MP1TOGD
;=============================================== (zel_main) =========
		EXT	MD_title,MD_djint,MD_djply,MD_gdint,MD_gdply
		EXT	MD_evint,MD_evply
		EXT	MD_fdout,MD_fdin,MD_etcpl
		EXT	MD_wpout,MD_wpin
;=============================================== (zel_play) ========
		EXT	SWSPCL1
;=============================================== (zel_init) ========
		EXT	GDMCK800,GSLC400,CGPTDT,PFLGCL
;
		EXT	p2_fin1
;=============================================== (zel_vma) =========
		EXT	DJBGWT,WBUFS0,WBUFS1
;
		EXT	VT01,VT02
;
		EXT	bgw3,bgw4
;=============================================== (zel_make) =========
		EXT	MKROOM
;=============================================== (zel_data0) ========
		EXT	BITCD0
;=============================================== (zel_enmy) =========
		EXT	GREDS2,ALCLER
;=============================================== (zel_sunt) =========
		EXT	SCUNIT0,SCUNIT1,SCUNIT2,SCUNIT3
;=============================================== (zel_munt) =========
		EXT	MPUNIT,betaut
;
		EXT	drut0,drut1
		EXT	drutA,drutB,drutC,drutD
		EXT	drutE,drutF
;
		EXT	hakut0,hakut1,hakut6,hakut7,hakut8,hakut9
		EXT	sgtu05,sgtu06,sgtu07,sgtu08,sgtu09,sgtu0A
;
		EXT	mizu00,mizu01,mizu02,mizu03,mizu04,mizu05,mizu06
		EXT	mizu07,mizu08,mizu09,mizu0A,mizu0B,mizu0C,mizu0D
		EXT	mizu0E,mizu0F,mizu10,mizu11,mizu12,mizu13,mizu14
		EXT	mizu15,mizu16,mizu17,mizu18,mizu19,mizu1A,mizu1B
		EXT	mizu1C,mizu1D,mizu1E,mizu1F,mizu20,mizu21,mizu22
		EXT	mizu23,mizu24,mizu25,mizu26
;
		EXT	umgtu0,umgtu1,umgtu2,umgtu3,umgtu4
		EXT	umgtu5,umgtu6,umgtu7,umgtu8,umgtu9
		EXT	umgt10,umgt11
;
		EXT	taki00,taki01,taki02,taki03,taki04,taki05,taki06
		EXT	taki07,taki08,taki09,taki0A,taki0B,taki0C,taki0D
		EXT	taki0E,taki0F,taki10,taki11,taki12
;
		EXT	torid0,torid1,torid2,torid3,torid4
		EXT	torid5,torid6,torid7,torid8,torid9
;=============================================== (zel_mpdt) =========
		EXT	MAPDTH00,MAPDTH01,MAPDTH02,MAPDTH03,MAPDTH04,MAPDTH05,MAPDTH06,MAPDTH07
		EXT	MAPDTH08,MAPDTH09,MAPDTH0A,MAPDTH0B,MAPDTH0C,MAPDTH0D,MAPDTH0E,MAPDTH0F
;
		EXT	MAPDTH10,MAPDTH11,MAPDTH12,MAPDTH13,MAPDTH14,MAPDTH15,MAPDTH16,MAPDTH17
		EXT	MAPDTH18,MAPDTH19,MAPDTH1A,MAPDTH1B,MAPDTH1C,MAPDTH1D,MAPDTH1E,MAPDTH1F
;
		EXT	MAPDTH20,MAPDTH21,MAPDTH22,MAPDTH23,MAPDTH24,MAPDTH25,MAPDTH26,MAPDTH27
		EXT	MAPDTH28,MAPDTH29,MAPDTH2A,MAPDTH2B,MAPDTH2C,MAPDTH2D,MAPDTH2E,MAPDTH2F
;
		EXT	MAPDTH30,MAPDTH31,MAPDTH32,MAPDTH33,MAPDTH34,MAPDTH35,MAPDTH36,MAPDTH37
		EXT	MAPDTH38,MAPDTH39,MAPDTH3A,MAPDTH3B,MAPDTH3C,MAPDTH3D,MAPDTH3E,MAPDTH3F
;
		EXT	MAPDTH40,MAPDTH41,MAPDTH42,MAPDTH43,MAPDTH44,MAPDTH45,MAPDTH46,MAPDTH47
		EXT	MAPDTH48,MAPDTH49,MAPDTH4A,MAPDTH4B,MAPDTH4C,MAPDTH4D,MAPDTH4E,MAPDTH4F
;
		EXT	MAPDTH50,MAPDTH51,MAPDTH52,MAPDTH53,MAPDTH54,MAPDTH55,MAPDTH56,MAPDTH57
		EXT	MAPDTH58,MAPDTH59,MAPDTH5A,MAPDTH5B,MAPDTH5C,MAPDTH5D,MAPDTH5E,MAPDTH5F
;
		EXT	MAPDTH60,MAPDTH61,MAPDTH62,MAPDTH63,MAPDTH64,MAPDTH65,MAPDTH66,MAPDTH67
		EXT	MAPDTH68,MAPDTH69,MAPDTH6A,MAPDTH6B,MAPDTH6C,MAPDTH6D,MAPDTH6E,MAPDTH6F
;
		EXT	MAPDTH70,MAPDTH71,MAPDTH72,MAPDTH73,MAPDTH74,MAPDTH75,MAPDTH76,MAPDTH77
		EXT	MAPDTH78,MAPDTH79,MAPDTH7A,MAPDTH7B,MAPDTH7C,MAPDTH7D,MAPDTH7E,MAPDTH7F
;
		EXT	MAPDTH80,MAPDTH81,MAPDTH82,MAPDTH83,MAPDTH84,MAPDTH85,MAPDTH86,MAPDTH87
		EXT	MAPDTH88,MAPDTH89,MAPDTH8A,MAPDTH8B,MAPDTH8C,MAPDTH8D,MAPDTH8E,MAPDTH8F
;
		EXT	MAPDTH90,MAPDTH91,MAPDTH92,MAPDTH93,MAPDTH94,MAPDTH95,MAPDTH96,MAPDTH97
;
;
;=============================================== (zel_char) =========
		EXT	NKCGSET,NKCGST0,NKCGST1,GCGCHNG,MPDTBFST
;
		EXT	OBJYSET,MSCGST1,MSCGST2,KENST,TATEST
		EXT	CHOBJST,CHITEMST,PLCGSET
		EXT	B3CGSET,DANCORST,KOUKAST
		EXT	GDCGST,GDCGST1,GDCGST2,DJCGSET,TPLCGST
;
		EXT	BGCBDT0
;=============================================== (zel_djdt) =========
		EXT	DJNBDT,DJNLDT
;====================================================================
;
		EXTEND
;
		MEM8
		IDX8
;
;
;
;************************************************************************
;*		BG mode set				(BGMDST)	*
;************************************************************************
BGMDST		EQU	$
;---------------  BG mode initial set  ----------------------------------
;;;;;;;;		LDA	#00000100B
		STZ	2133H		; BG. initial (Vsize = 244)
		LDA	#00001001B
		STA	<MD2105		; BG mode<1> set
		STZ	<MD2106		; mozaiku reset!!
;
;// 02.09.21 //		LDA	#00000011B
		LDA	#00010011B
		STA	2107H		; BG1 screen data set
;// 02.09.21 //		LDA	#00010011B
		LDA	#00000011B
		STA	2108H		; BG2
		LDA	#01100011B
		STA	2109H		; BG3
;
		LDA	#00100010B
		STA	210BH		; BG1,2 character address set
		LDA	#00000111B
		STA	210CH		; BG3 character address set
;
;---------------  Window parameter set  ---------------------------------
;// 02.07.24 //		STZ	212EH		; window select  (main)
;// 02.07.24 //		STZ	212FH		;        "       (sub)
;// 02.07.24 //;
;// 02.07.24 //		STZ	2123H		; window (BG2:off , BG1:off)
;// 02.07.24 //		STZ	2124H		;        (BG4:off , BG3:off)
;// 02.07.24 //		STZ	2125H		;        (CL:off  , OBJ:off)
;// 02.07.24 //;
;// 02.07.24 //		STZ	212AH		; window masuku set (OR mode)
;// 02.07.24 //		STZ	212BH
;
;// 02.11.20 //		LDA	#00000010B	; color mode set
;// 02.11.20 //		STA	<WD2130
		LDA	#00100000B	; color add. select (back)
		STA	<WD2131
WD2132IT	EQU	$
		LDA	#00100000B
		STA	<WD2132R
		LDA	#01000000B
		STA	<WD2132G
		LDA	#10000000B
		STA	<WD2132B
		RTS
;
;			
;
;************************************************************************
;*		Initial BG. write			(INBGWT1)	*
;************************************************************************
INBGWT1		EQU	$
		LDA	<WD420C
		PHA			; (A) push
		STZ	420CH
		STZ	<WD420C
;
		JSL	>MKROOM		; init. making room
		STZ	!SCRLFG
		STZ	!WBFPNT
		STZ	!ITEMMD
IBW140		EQU	$
		JSL	>WBUFS1
		JSL	>DJBGWT		; init. BG.1 write
;// 03.05.28 //		JSL	>RCHRCK		; reset character check
;
		JSL	>WBUFS0
		JSL	>DJBGWT		; init. BG.2 write
;// 03.05.28 //		JSL	>RCHRCK		; reset character check
;
		LDA	!WBFPNT
		CMP	#010H
		BNE	IBW140		; end ?
;					; yes
IBW160		EQU	$
		PLA			; (A) pull
		STA	<WD420C
		STZ	<BGWTFG
		STZ	!ITEMMD
		STZ	<JRSBPT
		RTS
;
;
;
;************************************************************************
;*		Initial Color set			(TINCLST)	*
;************************************************************************
TINCLST		EQU	$
		LDA	#002H
		STA	!CGSTPT+1
;
		JSL	>NKCGSET	; nuki
;
		JSL	>B3CGSET
		JSL	>DANCORST
		JSL	>KOUKAST	; BG. CG. set
;
		JSL	>TPLCGST	; obj. CG set
;
		INC	<CGVMAF
;
		RTS
;
;
;
;
;************************************************************************
;*		Initial Color set			(INCLST0)	*
;*			[Danjyon]					*
;************************************************************************
INCLST0		EQU	$
		STZ	!CGSTPT+1
;
		JSL	>NKCGSET	; nuki
;
		JSL	>DJCGSET
		JSL	>OBJYSET
		JSL	>MSCGST1
		JSL	>MSCGST2
		JSL	>KENST
		JSL	>TATEST
;// 03.02.26 //		JSL	>CHOBJST
		JSL	>CHITEMST
		JSL	>PLCGSET	; OBJ. CG. set
;
		JSL	>B3CGSET
		JSL	>DANCORST
;// 02.12.26 //		JSL	>SPCGSET
		JSL	>KOUKAST	; BG. CG. set
;// 03.05.30 //		RTS
;
;************************************************************************
;*		Color work set				(CGWKST)	*
;************************************************************************
CGWKST		EQU	$
		LDA	!DANJC
		STA	>BKDANC
		LDA	!KOKBGC
		STA	>BKKOKC
		LDA	!SPGC
		STA	>BKSPCC		; now BG. CG. point push
;
		MEM16
		REP	#00100000B	; memory 16bit mode
;
		LDA	#00002H
		STA	>CCNGFG
		LDA	#00000H
		STA	>CCNGCT
		LDA	#00000H
		STA	>CCNGED
;
		JMP	CGWKST2
;
;// 03.05.10 //		LDX	#000H
;// 03.05.10 //CGWS40		EQU	$
;// 03.05.10 //		LDA	>CGRAM+000H,X
;// 03.05.10 //		STA	>CGWORK+000H,X
;// 03.05.10 //		LDA	>CGRAM+040H,X
;// 03.05.10 //		STA	>CGWORK+040H,X
;// 03.05.10 //		LDA	>CGRAM+080H,X
;// 03.05.10 //		STA	>CGWORK+080H,X
;// 03.05.10 //		LDA	>CGRAM+0C0H,X
;// 03.05.10 //		STA	>CGWORK+0C0H,X
;// 03.05.10 //		LDA	>CGRAM+100H,X
;// 03.05.10 //		STA	>CGWORK+100H,X
;// 03.05.10 //		LDA	>CGRAM+140H,X
;// 03.05.10 //		STA	>CGWORK+140H,X
;// 03.05.10 //		LDA	>CGRAM+180H,X
;// 03.05.10 //		STA	>CGWORK+180H,X
;// 03.05.10 //		LDA	>CGRAM+1C0H,X
;// 03.05.10 //		STA	>CGWORK+1C0H,X
;// 03.05.10 //		INX
;// 03.05.10 //		INX
;// 03.05.10 //		CPX	#040H
;// 03.05.10 //		BNE	CGWS40		; end ?
;// 03.05.10 //;					; yes
;// 03.05.10 //;
;// 03.05.10 //;// 02.07.24 //		LDX	#00000H
;// 03.05.10 //;// 02.07.24 //CGWS40		EQU	$
;// 03.05.10 //;// 02.07.24 //		STA	>CGWORK+000H,X
;// 03.05.10 //;// 02.07.24 //		STA	>CGWORK+080H,X
;// 03.05.10 //;// 02.07.24 //		STA	>CGWORK+100H,X
;// 03.05.10 //;// 02.07.24 //		STA	>CGWORK+180H,X
;// 03.05.10 //;// 02.07.24 //		INX
;// 03.05.10 //;// 02.07.24 //		INX
;// 03.05.10 //;// 02.07.24 //		CPX	#00080H
;// 03.05.10 //;// 02.07.24 //		BNE	CGWS40		;
;// 03.05.10 //;// 02.07.24 //;					;
;// 03.05.10 //;// 02.07.24 //		LDX	#00000H
;// 03.05.10 //;// 02.07.24 //CGWS80		EQU	$
;// 03.05.10 //;// 02.07.24 //		LDA	>CGRAM+000H,X
;// 03.05.10 //;// 02.07.24 //		STA	>CGWORK+000H,X
;// 03.05.10 //;// 02.07.24 //		LDA	>CGRAM+010H,X
;// 03.05.10 //;// 02.07.24 //		STA	>CGWORK+010H,X
;// 03.05.10 //;// 02.07.24 //		LDA	>CGRAM+020H,X
;// 03.05.10 //;// 02.07.24 //		STA	>CGWORK+020H,X
;// 03.05.10 //;// 02.07.24 //		LDA	>CGRAM+030H,X
;// 03.05.10 //;// 02.07.24 //		STA	>CGWORK+030H,X
;// 03.05.10 //;// 02.07.24 //;
;// 03.05.10 //;// 02.07.24 //		LDA	>CGRAM+1B0H,X
;// 03.05.10 //;// 02.07.24 //		STA	>CGWORK+1B0H,X
;// 03.05.10 //;// 02.07.24 //		LDA	>CGRAM+1D0H,X
;// 03.05.10 //;// 02.07.24 //		STA	>CGWORK+1D0H,X
;// 03.05.10 //;// 02.07.24 //		LDA	>CGRAM+1E0H,X
;// 03.05.10 //;// 02.07.24 //		STA	>CGWORK+1E0H,X
;// 03.05.10 //;// 02.07.24 //		LDA	>CGRAM+1F0H,X
;// 03.05.10 //;// 02.07.24 //		STA	>CGWORK+1F0H,X
;// 03.05.10 //;// 02.07.24 //		INX
;// 03.05.10 //;// 02.07.24 //		INX
;// 03.05.10 //;// 02.07.24 //		CPX	#00010H
;// 03.05.10 //;// 02.07.24 //		BNE	CGWS80		;
;// 03.05.10 //;// 02.07.24 //;					;
;// 03.05.10 //;
;// 03.05.10 //		MEM8
;// 03.05.10 //		SEP	#00100000B	; memory 8bit mode
;// 03.05.10 //;
;// 03.05.10 //;// 02.07.25 //		JSL	>CCBFIT		; change char. buffer init. set
;// 03.05.10 //;
;// 03.05.10 //		INC	<CGVMAF		; CG. write
;// 03.05.10 //		RTS
;
;
;
		MEM8
		IDX8
;************************************************************************
;*		Initial Color set			(INCLST1)	*
;*			[Ground]					*
;************************************************************************
INCLST11	EQU	$
		JSR	INCLST1
		RTL
;
;
INCLST1		EQU	$
		LDX	#002H
		LDA	<MPDTNO
		AND	#03FH
		CMP	#003H
		BEQ	INCLS120	;
;					;
		CMP	#005H
		BEQ	INCLS120	;
;					;
		CMP	#007H
		BEQ	INCLS120	;
;					;
		LDX	#000H
INCLS120	EQU	$
		LDA	<MPDTNO
		AND	#01000000B
		BEQ	INCLS140	;
					;
		INX
INCLS140	EQU	$
		STX	!GNDBGC
		STZ	!CGSTPT+1
;
		JSL	>OBJYSET
		JSL	>CHITEMST
		JSL	>MSCGST1
		JSL	>MSCGST2
		JSL	>KENST
		JSL	>TATEST
		JSL	>PLCGSET	; OBJ. CG. set
;
;// 03.01.29 //		LDA	#000H
;// 03.01.29 //		STA	!GNDBGC
;// 03.01.29 //		STA	!GNDBGC1
;// 03.01.29 //		INC	A
;// 03.01.29 //		STA	!GNDBGC2
;
		LDA	#001H
		STA	!BOBOJC
		JSL	>DJCGSET
		JSL	>B3CGSET
		JSL	>GDCGST
;// 02.12.18 //		JSL	>GDCGST1
;// 02.12.18 //		JSL	>GDCGST2
;// 02.12.18 //		JSL	>KOUKAST	; BG. CG. set
;// 02.12.18 //		JSL	>NKCGST0	; nuki
		RTS
;
;
;
;
;
;
;************************************************************************
;*		Color work set				(CGWKST1)	*
;************************************************************************
CGWKST1		EQU	$
		MEM16
		REP	#00100000B	; memory 16bit mode
;
		LDX	#000H
		LDA	#00000H
CGWS140		EQU	$
;// 03.06.05 //		STA	>CGWORK+000H,X
		STA	>CGWORK+040H,X
		STA	>CGWORK+080H,X
		STA	>CGWORK+0C0H,X
		STA	>CGWORK+100H,X
		STA	>CGWORK+140H,X
		STA	>CGWORK+180H,X
		STA	>CGWORK+1C0H,X
		INX
		INX
		CPX	#040H
		BNE	CGWS140		;
;					;
		LDX	#000H
CGWS180		EQU	$
		LDA	>CGRAM+000H,X
		STA	>CGWORK+000H,X
		LDA	>CGRAM+010H,X
		STA	>CGWORK+010H,X
		LDA	>CGRAM+020H,X
		STA	>CGWORK+020H,X
		LDA	>CGRAM+030H,X
		STA	>CGWORK+030H,X
;
		LDA	>CGRAM+1B0H,X
		STA	>CGWORK+1B0H,X
		LDA	>CGRAM+1D0H,X
		STA	>CGWORK+1D0H,X
		LDA	>CGRAM+1E0H,X
		STA	>CGWORK+1E0H,X
		LDA	>CGRAM+1F0H,X
		STA	>CGWORK+1F0H,X
		INX
		INX
		CPX	#010H
		BNE	CGWS180		;
;					;
		MEM8
		SEP	#00100000B	; memory 8bit mode
;
		LDA	#11110111B
		STA	<MD2106
		STA	>MZKCNT
;
		INC	<CGVMAF		; CG. write
		RTS
;
;
;
;************************************************************************
;*		Color work set				(CGWKST2)	*
;************************************************************************
CGWKST2		EQU	$
		MEM16
		REP	#00100000B	; memory 16bit mode
;
		LDX	#00000H
CGWS240		EQU	$
		LDA	>CGRAM+000H,X
		STA	>CGWORK+000H,X
		LDA	>CGRAM+040H,X
		STA	>CGWORK+040H,X
		LDA	>CGRAM+080H,X
		STA	>CGWORK+080H,X
		LDA	>CGRAM+0C0H,X
		STA	>CGWORK+0C0H,X
		LDA	>CGRAM+100H,X
		STA	>CGWORK+100H,X
		LDA	>CGRAM+140H,X
		STA	>CGWORK+140H,X
		LDA	>CGRAM+180H,X
		STA	>CGWORK+180H,X
		LDA	>CGRAM+1C0H,X
		STA	>CGWORK+1C0H,X
		INX
		INX
		CPX	#040H
		BNE	CGWS240		; end ?
;					; yes
		MEM8
		IDX8
		SEP	#00100000B	; memory 8bit mode
;
		INC	<CGVMAF		; CG. write
		RTS
;
;
;
;
;
;************************************************************************
;*		Initial H-DMA 1				(INHDMA1)	*
;************************************************************************
;;;;INHDMA1		EQU	$
;;;;		PHB
;;;;		PHK
;;;;		PLB			; (DBR) set
;;;;;
;;;;		LDX	#0FH
;;;;IHD010		EQU	$
;;;;		LDA	WINDDT,X
;;;;		STA	!WINDOW,X
;;;;		DEX
;;;;		BPL	IHD010		;
;;;;;					;
;;;;		LDX	#04H
;;;;IHD020		EQU	$
;;;;		LDA	HDMAP1,X
;;;;		STA	4370H,X
;;;;		DEX
;;;;		BPL	IHD020
;;;;;
;;;;		LDA	#10000000B	; H-DMA ch "ON"!!
;;;;		STA	420CH
;;;;;
;;;;		PLB			; (DBR) reset
;;;;		RTL
;
;************************************************************************
;*		Initial H-DMA 2				(INHDMA2)	*
;************************************************************************
INHDMA2		EQU	$
;============== H-DMA parameter set ====================================
		PHB
		PHK
		PLB
;
		LDX	#04H
INH010		EQU	$
		LDA	HDMAP2,X
		STA	4370H,X
		DEX
		BPL	INH010
		LDA	#BANK HDMABF		; data bank set
		STA	4377H
;
		LDA	#00110011B
		STA	<WD2123			; window mask (BG2:on  , BG1:on  )
		LDA	#00000011B
		STA	<WD2124			;             (BG4:off , BG3:on  )
		LDA	#00110011B
		STA	<WD2125			;             (COL:on  , OBJ:on  )
;
		LDA	<DPMAIN
		STA	<WDMAIN
		LDA	<DPSUB
		STA	<WDSUB			; main,sub window set
;
		LDA	#10000000B
		STA	<WD420C			; H-DMA ch "ON" !!
;
		IDX16
		REP	#00010000B		; index 16 bit mode set
;
		LDX	#01DFH			; H-DMA buffer clear
INH020		EQU	$
		STZ	HDMABF,X
		DEX
		BPL	INH020
;
		IDX8				; index 8 bit mode set
		SEP	#00010000B
		PLB
		RTL
;
;===============  H-DMA window data  ====================================
WINDDT		EQU	$
		BYTE	001H
		BYTE	000H,0FFH
		BYTE	001H
		BYTE	000H,0FFH
		BYTE	001H
		BYTE	000H,0FFH
		BYTE	001H
		BYTE	000H,0FFH
		BYTE	081H
		BYTE	000H,000H
		BYTE	000H
;
;===============  H-DMA parameter  ======================================
HDMAP1		EQU	$
		BYTE	00000001B	; DMA control parameter
		BYTE	026H		;     B bus address
		WORD	WINDOW		;     A      "      (L),(H)
		BYTE	00H		;                   (B)
;
;===============  H-DMA parameter  ======================================
HDMAP2		EQU	$
		BYTE	01000001B	; DMA control parameter
		BYTE	026H		;     B bus address
		BYTE	LOW HDMADR	;     A      "      (L)
		BYTE	HIGH HDMADR	;                   (H)
		BYTE	BANK HDMADR	;                   (B)
;
HDMADR		EQU	$
		BYTE	0F8H
		WORD	HDMABF
		BYTE	0F8H
		WORD	HDMABF+78H*2
		BYTE	00
;
;
;
;
;
;************************************************************************
;*		Initial RAM  set  [Danjyon]		(IIT1000)	*
;************************************************************************
STRMDT		EQU	$		; start room no.     <RMXYCT>
		WORD	00104H
;			  4LR
		WORD	00104H
		WORD	00011H,00060H,00061H,00062H
;
		WORD	000F0H,000F1H,000D9H,00074H,00076H,00083H,00063H,000F2H
		WORD	000F3H,000F4H,000F5H,000F6H,000F7H,000F8H,000E8H,000E9H
		WORD	000FBH,000EBH,000FCH,000ECH,000FDH,000EDH,000FEH,000EEH
		WORD	000FFH,000EFH,000DFH,000F9H,000FAH,000EAH,000E0H,00028H
		WORD	0004AH,000D2H,00048H,00057H,00058H,00056H,00039H,0000EH
		WORD	000E6H,000E7H,000E4H,000E5H,00055H,0013DH,0013EH,00000H
;
;			   0L     0R     1L     1R     2L     2R    3Ld
		WORD	00100H,00100H,00101H,00101H,00102H,00102H,00103H
STRMD0		EQU	$
;			  3Lu     3R
		WORD	00103H,00103H
;			   5L     5R     6L     6R     7L     7R      8      9 
		WORD	00105H,00105H,00106H,00106H,00107H,00107H,00108H,00109H
;			    A      B     CL     CR    1BL    1BR    1CL    1CR     
		WORD	0010AH,0010BH,0010CH,0010CH,0011BH,0011BH,0011CH,0011CH		
;                        20L    20R     10L    10R     11     12    13L    14L
		WORD	00120H,0020FH,00110H,00110H,00111H,00112H,00113H,00114H
;                        15L    test   test   test   test    1AL    14R
		WORD	00115H,00116H,00117H,00118H,00119H,0011AH,00114H,00000H
;
		WORD	00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H
		WORD	00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H
		WORD	00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H
		WORD	00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H
		WORD	00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H
;
;			  H1     H2     H3     H4     H5     H6     H7     H8
		WORD	00067H,00068H,00069H,00049H,00057H,00058H,00047H,00055H
;
;
ISCTDT		EQU	$		; scroll limit data  <SCVU>
		WORD	02100H,02000H,02110H,02110H,00900H,00900H,00900H,00A00H
		WORD	02100H,02000H,02110H,02110H,00900H,00900H,00900H,00A00H
;
		WORD	00300H,00200H,00310H,00310H,00200H,00200H,00200H,00300H	; chapel
		WORD	00D00H,00C00H,00D10H,00D10H,00000H,00000H,00000H,00100H	; shiro-0
		WORD	00D00H,00C00H,00D10H,00D10H,00200H,00200H,00200H,00300H	;      -1
		WORD	00D00H,00C00H,00D10H,00D10H,00400H,00400H,00400H,00500H	;      -2
;
		WORD	01F00H,01E00H,01F10H,01F10H,00000H,00000H,00000H,00100H ; doukutu -L
		WORD	01F00H,01E00H,01F10H,01F10H,00300H,00200H,00300H,00300H ; doukutu -R
		WORD	01B00H,01A00H,01B10H,01B10H,01200H,01200H,01200H,01300H ; shinden
		WORD	00F00H,00E00H,00F10H,00F10H,00800H,00800H,00800H,00900H ; desert sindn-0
		WORD	00F00H,00E00H,00F10H,00F10H,00D00H,00C00H,00D00H,00D00H ;             -1
		WORD	01100H,01000H,01110H,01110H,00600H,00600H,00600H,00700H ;	      -2
		WORD	00D00H,00C00H,00D10H,00D10H,00600H,00600H,00600H,00700H ;	      -3
		WORD	01F00H,01E00H,01F10H,01F10H,00500H,00500H,00500H,00600H ; sontyo-L
		WORD	01F00H,01E00H,01F10H,01F10H,00600H,00600H,00600H,00700H ; sontyo-R
		WORD	01F00H,01E00H,01F10H,01F10H,00900H,00900H,00900H,00A00H ; futago-L
		WORD	01F00H,01E00H,01F10H,01F10H,00A00H,00A00H,00A00H,00B00H ; futago-R
		WORD	01F00H,01E00H,01F10H,01F10H,00D00H,00D00H,00D00H,00E00H ; tunagi doukutu -L
		WORD	01F00H,01E00H,01F10H,01F10H,00E00H,00E00H,00E00H,00F00H ; tunagi doukutu -R
		WORD	01F00H,01E00H,01F10H,01F10H,01000H,01000H,01000H,01100H ; 3 tunagi doukutu -D
		WORD	01D00H,01C00H,01D10H,01D10H,01000H,01000H,01000H,01100H ; 3 tunagi doukutu -UL
		WORD	01D00H,01C00H,01D10H,01D10H,01200H,01200H,01200H,01300H ; 3 tunagi doukutu -UR
		WORD	01F00H,01E00H,01F10H,01F10H,01600H,01600H,01600H,01700H ; tunawatari -D
		WORD	01D00H,01C00H,01D10H,01D10H,01600H,01600H,01600H,01700H ; tunawatari -U
		WORD	01F00H,01E00H,01F10H,01F10H,01800H,01800H,01800H,01900H ; jyogetunagi -D 
		WORD	01D00H,01C00H,01D10H,01D10H,01800H,01800H,01800H,01900H ; jyogetunagi -U
		WORD	01F00H,01E00H,01F10H,01F10H,01A00H,01A00H,01A00H,01B00H ; otoshianatunagi -D 
		WORD	01D00H,01C00H,01D10H,01D10H,01A00H,01A00H,01A00H,01B00H ; otoshianatunagi -U
		WORD	01F00H,01E00H,01F10H,01F10H,01D00H,01D00H,01D00H,01E00H ; uzumaki-D 
		WORD	01D00H,01C00H,01D10H,01D10H,01C00H,01C00H,01D00H,01E00H ; uzumaki-U
		WORD	01F00H,01E00H,01F10H,01F10H,01A00H,01A00H,01A00H,01B00H ; migisita-iriguti
		WORD	01D00H,01C00H,01D10H,01D10H,01B00H,01B00H,01B00H,01C00H ; migisita_start
		WORD	01B00H,01A00H,01B10H,01B10H,01E00H,01E00H,01E00H,01F00H ; migisita atatri
		WORD	01F00H,01E00H,01F10H,01F10H,01200H,01200H,01200H,01300H ; meganeiwa -LD
		WORD	01F00H,01E00H,01F10H,01F10H,01400H,01400H,01400H,01500H ; meganeiwa -RD
		WORD	01D00H,01C00H,01D10H,01D10H,01400H,01400H,01400H,01500H ; meganeiwa -U
		WORD	01D00H,01C00H,01D10H,01D10H,00000H,00000H,00000H,00100H ; tower of shisai
		WORD	00500H,00400H,00510H,00510H,01000H,01000H,01000H,01100H ; ura hokora danjon 
		WORD	00900H,00800H,00910H,00910H,01400H,01400H,01400H,01500H ; ura shinden 
		WORD	01B00H,01A00H,01B10H,01B10H,00500H,00400H,00500H,00500H ; ura numa danjon
		WORD	00900H,00800H,00910H,00910H,01000H,01000H,01000H,01100H ; ura mori in-1
		WORD	00B00H,00A00H,00B10H,00B10H,00F00H,00E00H,00F00H,00F00H ;            -2
		WORD	00B00H,00A00H,00B10H,00B10H,01100H,01000H,01100H,01100H ;            -3 
		WORD	00B00H,00A00H,00B10H,00B10H,00C00H,00C00H,00C00H,00D00H ;            -4
		WORD	00700H,00600H,00710H,00710H,01300H,01300H,01300H,01400H ;            -5
		WORD	00100H,00000H,00110H,00110H,01D00H,01C00H,01D00H,01D00H ; ura mizuumi
		WORD	01D00H,01C00H,01D10H,01D10H,00C00H,00C00H,00C00H,00D00H ; doukutu2-L
		WORD	01D00H,01C00H,01D10H,01D10H,00F00H,00E00H,00F00H,00F00H ; doukutu2-R
		WORD	01D00H,01C00H,01D10H,01D10H,00800H,00800H,00800H,00900H ; Mt.jji house-L
		WORD	01D00H,01C00H,01D10H,01D10H,00A00H,00A00H,00A00H,00B00H ; Mt.jji house-R
		WORD	00B00H,00A00H,00B10H,00B10H,00A00H,00A00H,00A00H,00B00H ; castle reverse
		WORD	02700H,02600H,02710H,02710H,01A00H,01A00H,01A00H,01B00H ; Mt.tower
		WORD	02700H,02600H,02710H,02710H,01C00H,01C00H,01C00H,01D00H ; machi danjon
		WORD	02100H,02000H,02110H,02110H,00900H,00900H,00900H,00A00H
;
		WORD	02100H,02000H,02110H,02110H,00000H,00000H,00000H,00100H	;  0L
		WORD	02100H,02000H,02110H,02110H,00100H,00100H,00100H,00200H	;  0R
		WORD	02100H,02000H,02110H,02110H,00200H,00200H,00200H,00300H	;  1L
		WORD	02100H,02000H,02110H,02110H,00300H,00300H,00300H,00400H	;  1R
		WORD	02100H,02000H,02110H,02110H,00400H,00400H,00400H,00500H	;  2L
		WORD	02100H,02000H,02110H,02110H,00500H,00500H,00500H,00600H	;  2R
		WORD	02100H,02000H,02110H,02110H,00600H,00600H,00600H,00700H	;  3Ld
		WORD	02100H,02000H,02110H,02110H,00600H,00600H,00600H,00700H	;  3Lu
		WORD	02100H,02000H,02110H,02110H,00700H,00700H,00700H,00800H	;  3R
		WORD	02100H,02000H,02110H,02110H,00A00H,00A00H,00A00H,00B00H	;  5L
		WORD	02100H,02000H,02110H,02110H,00B00H,00B00H,00B00H,00C00H	;  5R
		WORD	02100H,02000H,02110H,02110H,00C00H,00C00H,00C00H,00D00H	;  6L
		WORD	02100H,02000H,02110H,02110H,00D00H,00D00H,00D00H,00E00H	;  6R
		WORD	02100H,02000H,02110H,02110H,00E00H,00E00H,00E00H,00F00H	;  7L
		WORD	02100H,02000H,02110H,02110H,00F00H,00F00H,00F00H,01000H	;  7R
		WORD	02100H,02000H,02110H,02110H,01000H,01000H,01000H,01100H	;  8
		WORD	02100H,02000H,02110H,02110H,01200H,01200H,01200H,01300H	;  9
		WORD	02100H,02000H,02110H,02110H,01400H,01400H,01400H,01500H	;  A
		WORD	02100H,02000H,02110H,02110H,01600H,01600H,01600H,01700H	;  B
		WORD	02100H,02000H,02110H,02110H,01800H,01800H,01800H,01900H	;  CL
		WORD	02100H,02000H,02110H,02110H,01900H,01900H,01900H,01A00H	;  CR
		WORD	02300H,02200H,02310H,02310H,01600H,01600H,01600H,01700H	;  1BL
   		WORD	02300H,02200H,02310H,02310H,01700H,01700H,01700H,01800H	;  1BR
   		WORD	02300H,02200H,02310H,02310H,01800H,01800H,01800H,01900H	;  1CL
   		WORD	02300H,02200H,02310H,02310H,01900H,01900H,01900H,01900H ;  1CR
   		WORD	02500H,02400H,02510H,02510H,00000H,00000H,00000H,00100H	;  20L
   		WORD	02500H,02400H,02510H,02510H,00100H,00100H,00100H,00200H	;  20R
   		WORD	02300H,02200H,02310H,02310H,00000H,00000H,00100H,00100H	;  10L
   		WORD	02300H,02200H,02310H,02310H,00100H,00100H,00100H,00200H	;  10R
   		WORD	02300H,02200H,02310H,02310H,00200H,00200H,00200H,00300H	;  11
   		WORD	02300H,02200H,02310H,02310H,00400H,00400H,00400H,00500H	;  12
   		WORD	02300H,02200H,02310H,02310H,00600H,00600H,00600H,00700H	;  13L
   		WORD	02300H,02200H,02310H,02310H,00800H,00800H,00800H,00900H	;  14L
   		WORD	02300H,02200H,02310H,02310H,00A00H,00A00H,00A00H,00B00H	;  15L
;
		WORD	02300H,02200H,02310H,02310H,00C00H,00C00H,00C00H,00D00H ;  test
		WORD	02300H,02200H,02310H,02310H,00E00H,00E00H,00E00H,00F00H ;  test
		WORD	02300H,02200H,02310H,02310H,01000H,01000H,01000H,01100H ;  test
		WORD	02300H,02200H,02310H,02310H,01200H,01200H,01200H,01300H ;  test
;
		WORD	02300H,02200H,02310H,02310H,01400H,01400H,01400H,01500H ;  1AL
		WORD	02300H,02200H,02310H,02310H,00900H,00900H,00900H,00A00H ;  14R
		WORD	02100H,02000H,02110H,02110H,00900H,00900H,00900H,00A00H
		WORD	02100H,02000H,02110H,02110H,00900H,00900H,00900H,00A00H
		WORD	02100H,02000H,02110H,02110H,00900H,00900H,00900H,00A00H
		WORD	02100H,02000H,02110H,02110H,00900H,00900H,00900H,00A00H
		WORD	02100H,02000H,02110H,02110H,00900H,00900H,00900H,00A00H
		WORD	02100H,02000H,02110H,02110H,00900H,00900H,00900H,00A00H
		WORD	02100H,02000H,02110H,02110H,00900H,00900H,00900H,00A00H
		WORD	02100H,02000H,02110H,02110H,00900H,00900H,00900H,00A00H
		WORD	02100H,02000H,02110H,02110H,00900H,00900H,00900H,00A00H
		WORD	02100H,02000H,02110H,02110H,00900H,00900H,00900H,00A00H
		WORD	02100H,02000H,02110H,02110H,00900H,00900H,00900H,00A00H
		WORD	02100H,02000H,02110H,02110H,00900H,00900H,00900H,00A00H
		WORD	02100H,02000H,02110H,02110H,00900H,00900H,00900H,00A00H
		WORD	02100H,02000H,02110H,02110H,00900H,00900H,00900H,00A00H
		WORD	02100H,02000H,02110H,02110H,00900H,00900H,00900H,00A00H
		WORD	02100H,02000H,02110H,02110H,00900H,00900H,00900H,00A00H
		WORD	02100H,02000H,02110H,02110H,00900H,00900H,00900H,00A00H
		WORD	02100H,02000H,02110H,02110H,00900H,00900H,00900H,00A00H
		WORD	02100H,02000H,02110H,02110H,00900H,00900H,00900H,00A00H
		WORD	02100H,02000H,02110H,02110H,00900H,00900H,00900H,00A00H
		WORD	02100H,02000H,02110H,02110H,00900H,00900H,00900H,00A00H
		WORD	02100H,02000H,02110H,02110H,00900H,00900H,00900H,00A00H
		WORD	02100H,02000H,02110H,02110H,00900H,00900H,00900H,00A00H
		WORD	02100H,02000H,02110H,02110H,00900H,00900H,00900H,00A00H
		WORD	02100H,02000H,02110H,02110H,00900H,00900H,00900H,00A00H
		WORD	02100H,02000H,02110H,02110H,00900H,00900H,00900H,00A00H
		WORD	02100H,02000H,02110H,02110H,00900H,00900H,00900H,00A00H
		WORD	02100H,02000H,02110H,02110H,00900H,00900H,00900H,00A00H
		WORD	02100H,02000H,02110H,02110H,00900H,00900H,00900H,00A00H
		WORD	02100H,02000H,02110H,02110H,00900H,00900H,00900H,00A00H
		WORD	02100H,02000H,02110H,02110H,00900H,00900H,00900H,00A00H
		WORD	02100H,02000H,02110H,02110H,00900H,00900H,00900H,00A00H
		WORD	02100H,02000H,02110H,02110H,00900H,00900H,00900H,00A00H
		WORD	02100H,02000H,02110H,02110H,00900H,00900H,00900H,00A00H
		WORD	02100H,02000H,02110H,02110H,00900H,00900H,00900H,00A00H
		WORD	02100H,02000H,02110H,02110H,00900H,00900H,00900H,00A00H
		WORD	02100H,02000H,02110H,02110H,00900H,00900H,00900H,00A00H
		WORD	02100H,02000H,02110H,02110H,00900H,00900H,00900H,00A00H
		WORD	02100H,02000H,02110H,02110H,00900H,00900H,00900H,00A00H
		WORD	02100H,02000H,02110H,02110H,00900H,00900H,00900H,00A00H
		WORD	02100H,02000H,02110H,02110H,00900H,00900H,00900H,00A00H
;
		WORD	00C00H,00C00H,00C10H,00D10H,00E00H,00E00H,00E00H,00F00H ; ura mori hole-1 
		WORD	00C00H,00C00H,00C10H,00D10H,01000H,01000H,01000H,01100H ;              -2 
		WORD	00C00H,00C00H,00C10H,00D10H,01200H,01200H,01200H,01300H ;              -3 
		WORD	00800H,00800H,00810H,00910H,01200H,01200H,01200H,01300H ;              -4 
		WORD	00A00H,00A00H,00A10H,00B10H,00F00H,00E00H,00F00H,00F00H ;              -5 
		WORD	00A00H,00A00H,00A10H,00B10H,01100H,01000H,01100H,01100H ;              -6 
		WORD	00800H,00800H,00810H,00910H,00E00H,00E00H,00E00H,00F00H ;              -7 
		WORD	00A00H,00A00H,00A10H,00B10H,00B00H,00A00H,00B00H,00B00H ; castle reverse hole 
;
;
;
ISCHDT		EQU	$		; sccH               <SCCH>
		WORD	00900H
		WORD	00900H
		WORD	00280H,00000H,00280H,00480H
;
		WORD	00000H,00300H,01280H,00880H,00D00H,00600H,00600H,00500H
		WORD	00600H,00900H,00A00H,00D00H,00E80H,01000H,01000H,01280H
		WORD	01680H,01600H,01800H,01880H,01A80H,01B00H,01D00H,01D00H
		WORD	01E00H,01F00H,01E80H,01200H,01400H,01400H,00080H,01080H
		WORD	01480H,00500H,01000H,00F00H,01100H,00C00H,01300H,01D00H
		WORD	00C00H,00F00H,00800H,00A80H,00A00H,01A80H,01C80H,00000H
;
;			   0L     0R     1L     1R     2L     2R    3Ld    3Lu     3R
		WORD	00000H,00100H,00200H,00300H,00400H,00500H,00600H,00600H,00700H
;			   5L     5R     6L     6R     7L     7R      8     9
		WORD	00A00H,00B00H,00C00H,00D00H,00E00H,00F00H,01000H,01280H
;			    A      B     CL     CR    1BL    1BR    1CL    1CR
		WORD	01400H,01680H,01800H,01900H,01600H,01700H,01800H,01900H
;			  20L    20R    10L   10R     11     12     13L    14L
  		WORD	00000H,00100H,00000H,00100H,00200H,00480H,00600H,00800H
;			  15L   test   test   test   test   1AL     14R
 		WORD	00A00H,00C00H,00E80H,01080H,01280H,01400H,00900H,00000H
;
		WORD	00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H
		WORD	00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H
		WORD	00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H
		WORD	00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H
		WORD	00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H
;
;			  H1     H2     H3     H4     H5     H6     H7     H8
		WORD	00E76H,01008H,01200H,01200H,00F00H,01100H,00E00H,00B00H
;
;// 03.04.02 //;
;// 03.04.02 //;
;// 03.04.02 //ISCVDT		EQU	$		; sccV               <SCCV>
;// 03.04.02 //		WORD	02118H
;// 03.04.02 //		WORD	02118H
;// 03.04.02 //		WORD	00918H,00D18H,00D18H,00D18H
;// 03.04.02 //;
;// 03.04.02 //		WORD	01F18H,01F18H,00B18H,00F18H,00F18H,01118H,00D18H,00000H
;// 03.04.02 //		WORD	00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H
;// 03.04.02 //		WORD	00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H
;// 03.04.02 //		WORD	00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H
;// 03.04.02 //;
;// 03.04.02 //;
;// 03.04.02 //		WORD	02118H,02118H,02118H,02118H,02118H,02118H,02118H,01FFCH,02118H
;// 03.04.02 //		WORD	02118H,02118H,02118H,02118H,02118H,02118H,02118H,02118H,02118H
;// 03.04.02 //		WORD	02118H,02118H,02118H,02118H,02118H
;// 03.04.02 //;
ISCVDT		EQU	$		; sccV               <SCCV>
		WORD	02110H
		WORD	02110H
		WORD	00310H,00D10H,00D10H,00D10H
;
		WORD	01F10H,01F10H,01B10H,00F10H,00F10H,01110H,00D10H,01F10H
		WORD	01F10H,01F10H,01F10H,01F10H,01F10H,01F10H,01D10H,01D10H
		WORD	01F10H,01D10H,01F10H,01D10H,01F10H,01D10H,01F10H,01D10H
		WORD	01F10H,01D10H,01B10H,01F10H,01F10H,01D10H,01D10H,00510H
		WORD	00910H,01B10H,00910H,00B10H,00B10H,00B10H,00710H,00110H
		WORD	01D10H,01D10H,01D10H,01D10H,00B10H,02710H,02710H,00000H
;
;
		WORD	02110H,02110H,02110H,02110H,02110H,02110H,02110H,02000H,02110H
		WORD	02110H,02110H,02110H,02110H,02110H,02110H,02110H,02110H
		WORD	02110H,02110H,02110H,02110H,02310H,02310H,02310H,02310H
		WORD	02510H,02510H,02310H,02310H,02310H,02310H,02310H,02310H
		WORD	02310H,02310H,02310H,02310H,02310H,02310H,02310H,00000H
		WORD	00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H
		WORD	00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H
		WORD	00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H
		WORD	00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H
		WORD	00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H
;
;			  H1     H2     H3     H4     H5     H6     H7     H8
		WORD	00C2CH,00C10H,00C00H,00800H,00A10H,00A6DH,00887H,00A10H
;
;
IYPSDT		EQU	$		; player Y-pos.      <PLYPS1>
		WORD	02178H
		WORD	021D8H
		WORD	003C0H,00DD8H,00DC0H,00DD8H
;
		WORD	01FD8H,01FC0H,01BD8H,00FD8H,00FD8H,011D8H,00DD8H,01FD8H
		WORD	01FD8H,01FD8H,01FD8H,01FC0H,01FD8H,01FD8H,01DD8H,01DD8H
		WORD	01FD8H,01DD8H,01FC0H,01DD8H,01FC0H,01DD8H,01FC0H,01DD8H
		WORD	01FC0H,01DD8H,01BD8H,01FD8H,01FC0H,01DD8H,01DD8H,005D8H
		WORD	009D8H,01BD8H,009D8H,00BD8H,00BD8H,00BD8H,007D8H,001D8H
		WORD	01DC0H,01DC0H,01DC0H,01DD8H,00BD8H,027D8H,027D8H,00000H
;
;
		WORD	021D8H,021D8H,021D8H,021D8H,021D8H,021D8H,021D8H,02020H,021D8H
		WORD	021D8H,021D8H,021D8H,021D8H,021D8H,021D8H,021D8H,021D8H
		WORD	021C0H,021D8H,021D8H,021C0H,023C0H,023D8H,023D8H,023D8H
		WORD	025D8H,025D8H,023D8H,023C0H,023D8H,023D8H,023D8H,023D8H
		WORD	023D8H,023D8H,023D8H,023D8H,023D8H,023D8H,023D8H,00000H
		WORD	00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H
		WORD	00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H
		WORD	00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H
		WORD	00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H
		WORD	00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H
;
;			  H1     H2     H3     H4     H5     H6     H7     H8 
		WORD	00C99H,00C89H,00C4AH,00846H,00A89H,00AD9H,008F3H,00A96H
;
;
IXPSDT		EQU	$		;        X-pos.      <PLXPS1>
		WORD	00978H
		WORD	00978H
		WORD	002F8H,00078H,002F8H,004F8H
;
		WORD	00078H,00378H,012F8H,008F8H,00D78H,00678H,00678H,00578H
		WORD	00678H,00978H,00A78H,00D78H,00EF8H,01078H,01078H,012F8H
		WORD	016F8H,01678H,01878H,018F8H,01AF8H,01B78H,01D78H,01D78H
		WORD	01E78H,01F78H,01EF8H,01278H,01478H,01478H,000F8H,010F8H
		WORD	014F8H,00578H,01078H,00F78H,01178H,00C78H,01378H,01D78H
		WORD	00C78H,00F78H,00878H,00AF8H,00A78H,01AF8H,01CF8H,00000H
;
;
		WORD	00078H,00178H,00278H,00378H,00478H,00578H,00678H,00678H,00778H
		WORD	00A78H,00B78H,00C78H,00D78H,00E78H,00F78H,01078H,012F8H
		WORD	01478H,016F8H,01878H,01978H,01678H,01778H,01878H,01978H
		WORD	00078H,00178H,00078H,00178H,00278H,004F8H,00678H,00878H
		WORD	00A78H,00C78H,00EF8H,010F8H,012F8H,01478H,00978H,00000H
		WORD	00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H
		WORD	00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H
		WORD	00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H
		WORD	00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H
		WORD	00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H
;
;			  H1     H2     H3     H4     H5     H6     H7     H8
		WORD	00EEEH,01080H,0126FH,0126FH,00F70H,01170H,00E78H,00B9FH
;
IUPCDT		EQU	$		; up   check data    <PYUPCT>
		WORD	00187H
		WORD	00187H
		WORD	00187H,00187H,00187H,00187H
;
		WORD	00187H,00187H,00187H,00187H,00187H,00187H,00187H,00187H
		WORD	00187H,00187H,00187H,00187H,00187H,00187H,00187H,00187H
		WORD	00187H,00187H,00187H,00187H,00187H,00187H,00187H,00187H
		WORD	00187H,00187H,00187H,00187H,00187H,00187H,00187H,00187H
		WORD	00187H,00187H,00187H,00187H,00187H,00187H,00187H,00187H
		WORD	00187H,00187H,00187H,00187H,00187H,00187H,00187H,00187H
;
;
		WORD	00187H,00187H,00187H,00187H,00187H,00187H,00187H,00074H,00187H
		WORD	00187H,00187H,00187H,00187H,00187H,00187H,00187H,00187H
		WORD	00187H,00187H,00187H,00187H,00187H,00187H,00187H,00187H
		WORD	00187H,00187H,00187H,00187H,00187H,00187H,00187H,00187H
		WORD	00187H,00187H,00187H,00187H,00187H,00187H,00187H,00187H
		WORD	00187H,00187H,00187H,00187H,00187H,00187H,00187H,00187H
		WORD	00187H,00187H,00187H,00187H,00187H,00187H,00187H,00187H
		WORD	00187H,00187H,00187H,00187H,00187H,00187H,00187H,00187H
		WORD	00187H,00187H,00187H,00187H,00187H,00187H,00187H,00187H
		WORD	00187H,00187H,00187H,00187H,00187H,00187H,00187H,00187H
;
;			  H1     H2     H3     H4     H5     H6     H7     H8
;// 03.05.09 //		WORD	00084H,00076H,00068H,00070H,00080H,00078H,00183H,00000H
		WORD	000A4H,00088H,00070H,00078H,00088H,000E4H,000FEH,00088H
;
;
ILFCDT		EQU	$		; left               <PXLFCT>
		WORD	0017FH
		WORD	0017FH
		WORD	000FFH,0007FH,000FFH,000FFH
;
		WORD	0007FH,0017FH,000FFH,000FFH,0017FH,0007FH,0007FH,0017FH
		WORD	0007FH,0017FH,0007FH,0017FH,000FFH,0007FH,0007FH,000FFH
		WORD	000FFH,0007FH,0007FH,000FFH,000FFH,0017FH,0017FH,0017FH
		WORD	0007FH,0017FH,000FFH,0007FH,0007FH,0007FH,000FFH,000FFH
		WORD	000FFH,0017FH,0007FH,0017FH,0017FH,0007FH,0017FH,0017FH
		WORD	0007FH,0017FH,0007FH,000FFH,0007FH,000FFH,000FFH,00000H
;
;
		WORD	0007FH,0017FH,0007FH,0017FH,0007FH,0017FH,0007FH,0007FH,0017FH
		WORD	0007FH,0017FH,0007FH,0017FH,0007FH,0017FH,0007FH,000FFH
		WORD	0007FH,000FFH,0007FH,0017FH,0007FH,0017FH,0007FH,0017FH
		WORD	0007FH,0017FH,0007FH,0017FH,0007FH,000FFH,0007FH,0007FH
		WORD	0007FH,0007FH,000FFH,000FFH,000FFH,0007FH,00000H,00000H
		WORD	00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H
		WORD	00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H
		WORD	00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H
		WORD	00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H
		WORD	00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H
;
;			  H1     H2     H3     H4     H5     H6     H7     H8
		WORD	000F5H,00087H,0007CH,0007CH,0017FH,0017FH,0007FH,0017FH
;
;
BGCHPT		EQU	$		; BG. character pointer  <CHIKNO>
		BYTE	003H
		BYTE	003H
		BYTE	004H,004H,004H,004H
;
		BYTE	006H,006H,005H,005H,005H,005H,005H,003H
		BYTE	003H,003H,003H,006H,006H,006H,006H,006H
		BYTE	006H,006H,006H,006H,006H,006H,006H,006H
		BYTE	006H,006H,006H,006H,006H,006H,004H,008H
		BYTE	007H,00CH,009H,009H,009H,009H,009H,00BH
		BYTE	006H,006H,006H,006H,001H,005H,00AH,000H
;
;			 0L   0R   1L   1R   2L   2R  3Ld  3Lu   3R
		BYTE	003H,003H,003H,003H,003H,003H,003H,003H,003H
;			 5L   5R   6L   6R   7L   7R    8    9
		BYTE	003H,003H,003H,003H,003H,003H,003H,003H
;			  A    B   CL   CR   1BL  1BR  1CL  1CR
		BYTE	006H,008H,006H,006H,006H,006H,006H,006H
;			 20L  20R  10L  10R   11   12  13L  14L
		BYTE	006H,006H,006H,006H,003H,003H,001H,006H
;			 15L test test test test  1AL  14R
 		BYTE	006H,00DH,001H,001H,00AH,005H,006H,000H
		BYTE	000H,000H,000H,000H,000H,000H,000H,000H
		BYTE	000H,000H,000H,000H,000H,000H,000H,000H
		BYTE	000H,000H,000H,000H,000H,000H,000H,000H
		BYTE	000H,000H,000H,000H,000H,000H,000H,000H
		BYTE	000H,000H,000H,000H,000H,000H,000H,000H
;
;			 H1   H2   H3   H4   H5   H6   H7   H8  
		BYTE	009H,009H,009H,009H,009H,009H,009H,001H
;
;
FLNODT		EQU	$		; floor no. data         <FLORNO>
		BYTE	000H
		BYTE	000H
		BYTE	000H,001H,000H,001H
;
		BYTE	000H,0FFH,001H,0FFH,000H,001H,001H,000H
		BYTE	000H,000H,000H,000H,001H,000H,001H,001H
		BYTE	000H,001H,000H,002H,000H,002H,000H,002H
		BYTE	0FEH,000H,001H,001H,000H,002H,001H,000H
		BYTE	000H,000H,0FFH,0FFH,0FFH,0FFH,0FFH,000H
		BYTE	000H,000H,000H,000H,0FFH,000H,000H,000H
;
		BYTE	000H,000H,000H,000H,000H,000H,000H,000H,000H
		BYTE	000H,000H,000H,000H,000H,000H,000H,000H
		BYTE	000H,000H,000H,000H,000H,000H,000H,000H
		BYTE	000H,000H,000H,000H,000H,000H,000H,000H
		BYTE	000H,000H,000H,000H,000H,000H,000H,000H
		BYTE	000H,000H,000H,000H,000H,000H,000H,000H
		BYTE	000H,000H,000H,000H,000H,000H,000H,000H
		BYTE	000H,000H,000H,000H,000H,000H,000H,000H
		BYTE	000H,000H,000H,000H,000H,000H,000H,000H
		BYTE	000H,000H,000H,000H,000H,000H,000H,000H
;
		BYTE	0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FEH
;
;
DJNPTD		EQU	$		; danjyon map pointer    <DJNNO>
		BYTE	0FFH
		BYTE	0FFH
		BYTE	000H,002H,002H,002H
;
		BYTE	000H,000H,004H,006H,006H,006H,006H,0FFH
		BYTE	0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH
		BYTE	0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH
		BYTE	0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,008H,00AH
		BYTE	00CH,00EH,010H,010H,010H,010H,010H,012H
		BYTE	0FFH,0FFH,0FFH,0FFH,0FFH,014H,016H,000H
;
;			 0L   0R   1L   1R   2L   2R  3Ld  3Lu   3R  
		BYTE	0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH
;			 5L   5R   6L   6R   7L   7R    8    9
		BYTE	0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH
;			  A    B   CL   CR   1BL  1BR  1CL  1CR
		BYTE	0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH
;			 20L  20R  10L  10R   11   12  13L  14L
		BYTE	0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH
;			 15L test test test test  1AL  14R
  		BYTE	0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH
;
		BYTE	0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH
		BYTE	0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH
		BYTE	0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH
		BYTE	0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH
		BYTE	0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH
;
;			 H1   H2   H3   H4   H5   H6   H7   H8  
		BYTE	010H,010H,010H,010H,010H,010H,010H,0FFH
;
;
;
INDRDT		EQU	$		; player in-door data    <PWORK6>
		BYTE	000H
		BYTE	001H
		BYTE	001H,001H,001H,001H
;
		BYTE	001H,001H,001H,001H,001H,001H,001H,001H
		BYTE	001H,001H,001H,001H,001H,001H,001H,001H
		BYTE	001H,001H,001H,001H,001H,001H,001H,001H
		BYTE	001H,001H,001H,001H,001H,001H,001H,001H
		BYTE	001H,001H,001H,001H,001H,001H,001H,001H
		BYTE	001H,001H,001H,001H,001H,001H,001H,001H
;
;			 0L   0R   1L   1R   2L   2R  3Ld  3Lu   3R 
		BYTE	001H,001H,001H,001H,001H,001H,001H,001H,001H
;			 5L   5R   6L   6R   7L   7R    8    9
		BYTE	001H,001H,001H,001H,001H,001H,001H,001H
;			  A    B   CL   CR   1BL  1BR  1CL  1CR
		BYTE	001H,001H,001H,001H,001H,001H,001H,001H
;			 20L  20R  10L  10R   11   12  13L  14L
		BYTE	001H,001H,001H,001H,001H,001H,001H,001H
;			 15L test test test test  1AL  14R
		BYTE	001H,001H,001H,001H,001H,001H,001H,001H
		BYTE	001H,001H,001H,001H,001H,001H,001H,001H
		BYTE	001H,001H,001H,001H,001H,001H,001H,001H
		BYTE	001H,001H,001H,001H,001H,001H,001H,001H
		BYTE	001H,001H,001H,001H,001H,001H,001H,001H
		BYTE	001H,001H,001H,001H,001H,001H,001H,001H
;
		BYTE	000H,000H,000H,000H,000H,000H,000H,000H
;
;
PBGMDT		EQU	$		; player BG. check mode data  <PLBGCKF>
		BYTE	000H
		BYTE	000H
		BYTE	001H,000H,000H,000H
;
		BYTE	000H,000H,000H,000H,000H,000H,000H,000H
		BYTE	000H,000H,000H,000H,000H,000H,000H,000H
		BYTE	000H,000H,000H,000H,000H,000H,000H,000H
		BYTE	001H,000H,000H,000H,001H,000H,000H,000H
		BYTE	000H,000H,000H,000H,000H,000H,000H,000H
		BYTE	000H,000H,000H,000H,000H,000H,000H,000H
;
;
		BYTE	000H,000H,000H,000H,000H,000H,000H,000H,000H
		BYTE	000H,000H,000H,000H,000H,000H,000H,000H
		BYTE	000H,000H,000H,001H,001H,000H,000H,000H
		BYTE	000H,000H,000H,000H,000H,000H,000H,000H
		BYTE	000H,000H,000H,000H,000H,000H,000H,000H
		BYTE	000H,000H,000H,000H,000H,000H,000H,000H
		BYTE	000H,000H,000H,000H,000H,000H,000H,000H
		BYTE	000H,000H,000H,000H,000H,000H,000H,000H
		BYTE	000H,000H,000H,000H,000H,000H,000H,000H
		BYTE	000H,000H,000H,000H,000H,000H,000H,000H
;
		BYTE	000H,000H,000H,000H,000H,000H,000H,000H
;
;
CBGMDT		EQU	$		; char. BG. check mode data   <CDBGCKF>
		BYTE	000H
		BYTE	000H
		BYTE	001H,000H,000H,000H
;
		BYTE	000H,001H,000H,000H,000H,000H,000H,000H
		BYTE	000H,000H,000H,001H,000H,000H,000H,000H
		BYTE	000H,000H,001H,000H,001H,000H,001H,000H
		BYTE	001H,000H,000H,000H,001H,000H,000H,000H
		BYTE	000H,000H,000H,000H,000H,000H,000H,000H
		BYTE	001H,001H,001H,000H,000H,000H,000H,000H
;
;
		BYTE	000H,000H,000H,000H,000H,000H,000H,000H,000H
		BYTE	000H,000H,000H,000H,000H,000H,000H,000H
		BYTE	001H,000H,000H,001H,001H,000H,000H,000H
		BYTE	000H,000H,000H,000H,000H,000H,000H,000H
		BYTE	000H,000H,000H,000H,000H,000H,000H,000H
		BYTE	000H,000H,000H,000H,000H,000H,000H,000H
		BYTE	000H,000H,000H,000H,000H,000H,000H,000H
		BYTE	000H,000H,000H,000H,000H,000H,000H,000H
		BYTE	000H,000H,000H,000H,000H,000H,000H,000H
		BYTE	000H,000H,000H,000H,000H,000H,000H,000H
;
		BYTE	000H,000H,000H,000H,000H,000H,000H,001H
;
;
RCKXD0		EQU	$               ; room size              <RMCKXF>
		BYTE	000H
		BYTE	000H
		BYTE	002H,000H,002H,002H
;
		BYTE	002H,002H,002H,002H,000H,002H,000H,000H
		BYTE	000H,000H,000H,000H,002H,002H,000H,002H
		BYTE	002H,002H,002H,000H,002H,002H,000H,002H
		BYTE	000H,000H,000H,002H,000H,002H,002H,002H
		BYTE	002H,000H,000H,000H,000H,002H,000H,000H
		BYTE	002H,002H,000H,002H,002H,002H,002H,000H
;
;
		BYTE	000H,000H,000H,000H,000H,000H,000H,000H,000H
		BYTE	000H,000H,000H,000H,000H,000H,000H,002H
		BYTE	000H,002H,000H,000H,000H,000H,002H,002H
		BYTE	000H,000H,002H,002H,000H,002H,000H,000H
		BYTE	000H,002H,002H,002H,002H,000H,000H,000H
		BYTE	000H,000H,000H,000H,000H,000H,000H,000H
		BYTE	000H,000H,000H,000H,000H,000H,000H,000H
		BYTE	000H,000H,000H,000H,000H,000H,000H,000H
		BYTE	000H,000H,000H,000H,000H,000H,000H,000H
		BYTE	000H,000H,000H,000H,000H,000H,000H,000H
;
		BYTE	002H,002H,000H,000H,000H,000H,000H,002H
;
;
RCKXD1		EQU	$               ;                        <RMXCPT>
		BYTE	000H
		BYTE	000H
		BYTE	000H,000H,000H,000H
;
		BYTE	000H,001H,000H,000H,001H,000H,000H,001H
		BYTE	000H,001H,000H,001H,000H,000H,000H,000H
		BYTE	000H,000H,000H,000H,000H,001H,000H,001H
		BYTE	000H,001H,000H,000H,000H,000H,000H,000H
		BYTE	000H,001H,000H,001H,001H,000H,001H,001H
		BYTE	000H,001H,000H,000H,000H,000H,000H,000H
;
;
		BYTE	000H,000H,000H,000H,000H,000H,000H,000H,000H
		BYTE	000H,000H,000H,000H,000H,000H,000H,000H
		BYTE	000H,000H,000H,000H,000H,000H,000H,001H
		BYTE	000H,000H,000H,001H,000H,000H,000H,000H
		BYTE	000H,000H,000H,000H,000H,000H,001H,000H
		BYTE	000H,000H,000H,000H,000H,000H,000H,000H
		BYTE	000H,000H,000H,000H,000H,000H,000H,000H
		BYTE	000H,000H,000H,000H,000H,000H,000H,000H
		BYTE	000H,000H,000H,000H,000H,000H,000H,000H
		BYTE	000H,000H,000H,000H,000H,000H,000H,000H
;
		BYTE	000H,000H,000H,000H,001H,001H,000H,001H
;
;
RCKYD0		EQU	$               ;                        <RMCKYF>
		BYTE	000H
		BYTE	000H
		BYTE	002H,002H,002H,002H
;
		BYTE	002H,002H,000H,002H,002H,002H,000H,002H
		BYTE	002H,000H,000H,002H,002H,000H,002H,002H
		BYTE	002H,002H,002H,002H,002H,002H,002H,002H
		BYTE	002H,002H,002H,002H,002H,002H,000H,002H
		BYTE	000H,002H,002H,000H,002H,000H,000H,000H
		BYTE	002H,002H,002H,002H,000H,002H,002H,000H
;
;
		BYTE	000H,000H,000H,000H,000H,000H,002H,002H,000H
		BYTE	000H,000H,000H,000H,000H,000H,000H,002H
		BYTE	002H,000H,000H,002H,000H,000H,000H,000H
		BYTE	000H,000H,000H,000H,000H,002H,002H,000H
		BYTE	002H,002H,002H,002H,000H,000H,000H,000H
		BYTE	000H,000H,000H,000H,000H,000H,000H,000H
		BYTE	000H,000H,000H,000H,000H,000H,000H,000H
		BYTE	000H,000H,000H,000H,000H,000H,000H,000H
		BYTE	000H,000H,000H,000H,000H,000H,000H,000H
		BYTE	000H,000H,000H,000H,000H,000H,000H,000H
;
		BYTE	002H,000H,002H,002H,000H,002H,002H,000H
;
;
RCKYD1		EQU	$               ;                        <RMYCPT>
		BYTE	002H
		BYTE	002H
		BYTE	002H,002H,002H,002H
;
		BYTE	002H,002H,002H,002H,002H,002H,002H,002H
		BYTE	002H,002H,002H,002H,002H,002H,002H,002H
		BYTE	002H,002H,002H,002H,002H,002H,002H,002H
		BYTE	002H,002H,002H,002H,002H,002H,002H,002H
		BYTE	002H,002H,002H,002H,002H,002H,002H,002H
		BYTE	002H,002H,002H,002H,002H,002H,002H,000H
;
;
		BYTE	002H,002H,002H,002H,002H,002H,002H,000H,002H
		BYTE	002H,002H,002H,002H,002H,002H,002H,002H
		BYTE	002H,002H,002H,002H,002H,002H,002H,002H
		BYTE	002H,002H,002H,002H,002H,002H,002H,002H
		BYTE	002H,002H,002H,002H,002H,002H,002H,000H
		BYTE	000H,000H,000H,000H,000H,000H,000H,000H
		BYTE	000H,000H,000H,000H,000H,000H,000H,000H
		BYTE	000H,000H,000H,000H,000H,000H,000H,000H
		BYTE	000H,000H,000H,000H,000H,000H,000H,000H
		BYTE	000H,000H,000H,000H,000H,000H,000H,000H
;
		BYTE	000H,000H,000H,000H,000H,000H,000H,000H
;
;
DDOPPDT		EQU	$		; (GDRBF0)
		WORD	00816H
		WORD	00816H
;// 03.05.24 //		WORD	00AA8H
;// 03.05.24 //		WORD	00AA8H
		WORD	00000H,00000H,00000H,00000H
;
		WORD	00000H,00000H,00000H,00000H,00000H,00000H,00000H,005CAH
		WORD	005D6H,00BB6H,00B86H,00000H,00000H,00000H,00000H,00000H
		WORD	00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H
		WORD	00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H
		WORD	00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H
		WORD	00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H
;
;			   0L     0R     1L     1R     2L     2R    3Ld    3Lu   3R 
		WORD	007AAH,0041AH,005B4H,00B18H,00D68H,014CAH,01CD0H,0FFFFH,01A64H
;			   5L     5R     6L     6R     7L     7R      8      9 
		WORD	01466H,0091EH,00AA8H,0040EH,009ACH,09C0CH,0142CH,00A98H
;// 03.05.24 //		WORD	01466H,0091EH,00816H,0069EH,00A1AH,09C0CH,0142CH,00A98H
;			    A      B     CL     CR    1BL    1BR    1CL    1CR
		WORD	00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H
;			  20L    20R    10L    10R     11     12    13L    14L
		WORD	00000H,00000H,00000H,00000H,00AA8H,008A0H,00000H,00000H
;                         15L   test   test   test   test    1AL   14R
		WORD	00000H,00000H,00816H,00000H,00000H,00000H,00000H,00000H
		WORD	00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H
		WORD	00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H
		WORD	00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H
		WORD	00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H
		WORD	00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H
;
;			  H1     H2     H3     H4     H5     H6     H7     H8 
		WORD	00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H
;
;
GWPCKD		EQU	$		; ground warp check room
		WORD	000F9H,00182H,000F3H,00040H,00054H,00074H,0010AH,0010BH
;
;
;
IIT1000		EQU	$
          	PHB
		PHK
		PLB			; (DBR) set
;
		LDA	#001H
		STA	<GMMODE		; game-mode (DANJYON) set
;
		LDA	!GOVRCFG
		BEQ	IIT1001		; gaove-over continue ?
;					; yes
		JMP	IIT1002
;
IIT1001		EQU	$
		MEM16
		REP	#00100000B	; memory 16bit mode
;
		LDA	!GRNDNO
		STA	>GRNOBK		; ground no. push
;
		LDA	<DPMAIN
		STA	>DPMSBK		; DPMAIN & DPSUB push
;
		LDA	<SCCV2
		STA	>SCV2BK
		LDA	<SCCH2
		STA	>SCH2BK		; SCCH,V push
;
		LDA	<PLYPS1
		STA	>PLYPBK
		LDA	<PLXPS1
		STA	>PLXPBK		; Ground position push
;
		LDA	!PYUPCT
		STA	>UPCTBK
		LDA	!PXLFCT
		STA	>LFCTBK		; up,left check counter push
;
		LDA	<MPDTNO
		STA	>MPDNBK
		LDA	<SCRPNT
		STA	>SRPTBK		; Ground information push
		STZ	<MPDTNO
		STZ	<MPDTN1
;
		LDA	!SCVU+0
		STA	>SCVUBK+0
		LDA	!SCVU+2
		STA	>SCVUBK+2
		LDA	!SCVU+4
		STA	>SCVUBK+4
		LDA	!SCVU+6
		STA	>SCVUBK+6
;
		LDA	!SCKY00
		STA	>SCKYBK+0
		LDA	!SCKY10
		STA	>SCKYBK+2
		LDA	!SCKX00
		STA	>SCKXBK+0
		LDA	!SCKX10
		STA	>SCKXBK+2
;
		LDA	!UPSLCT
		STA	>USCTBK
		LDA	!DWSLCT
		STA	>DSCTBK
		LDA	!LFSLCT
		STA	>LSCTBK
		LDA	!RTSLCT
		STA	>RSCTBK
;
		MEM8
		SEP	#00100000B	; memory 8bit mode
;
		LDA	!CHARBK
		STA	>CHBKBK
		LDA	!CHIKNO
		STA	>CHNOBK
		LDA	!RBGCPT
		STA	>RBGPBK
		LDA	!ROBJCPT
		STA	>ROJPBK
IIT1002		EQU	$
		MEM16
		IDX16
		REP	#00110000B	; memory,index 16bit mode
;
;// 02.08.16 //		LDA	!GRNDNO
;// 02.08.16 //		STA	>GRNORM		; ground no. push
;// 02.08.16 //;
;// 02.08.16 //		LDA	<DPMAIN
;// 02.08.16 //		STA	>DPMSRM		; DPMAIN & DPSUB push
;// 02.08.16 //;
;// 02.08.16 //		LDA	<SCCV1
;// 02.08.16 //		STA	>SCV1RM
;// 02.08.16 //		LDA	<SCCH1
;// 02.08.16 //		STA	>SCH1RM
;// 02.08.16 //		LDA	<SCCV2
;// 02.08.16 //		STA	>SCV2RM
;// 02.08.16 //		LDA	<SCCH2
;// 02.08.16 //		STA	>SCH2RM		; SCCH,V push
;// 02.08.16 //;
;// 02.08.16 //		LDA	<PLYPS1
;// 02.08.16 //		STA	>PLYPRM
;// 02.08.16 //		LDA	<PLXPS1
;// 02.08.16 //		STA	>PLXPRM		; Ground position push
;// 02.08.16 //;
;// 02.08.16 //		LDA	!PYUPCT
;// 02.08.16 //		STA	>UPCTRM
;// 02.08.16 //		LDA	!PYDWCT
;// 02.08.16 //		STA	>DWCTRM
;// 02.08.16 //		LDA	!PXLFCT
;// 02.08.16 //		STA	>LFCTRM
;// 02.08.16 //		LDA	!PXRTCT
;// 02.08.16 //		STA	>RTCTRM		; up,dwon,left,right check counter push
;// 02.08.16 //;
;// 02.08.16 //		LDA	<MPDTNO
;// 02.08.16 //		STA	>MPDNRM
;// 02.08.16 //		LDA	<YWRITE
;// 02.08.16 //		STA	>YWTERM
;// 02.08.16 //		LDA	<XWRITE
;// 02.08.16 //		STA	>XWTERM
;// 02.08.16 //		LDA	<SCRPNT
;// 02.08.16 //		STA	>SRPTRM		; Ground information push
;// 02.08.16 //;
;// 02.08.16 //		LDA	!SCVU+0
;// 02.08.16 //		STA	>SCVURM+0
;// 02.08.16 //		LDA	!SCVU+2
;// 02.08.16 //		STA	>SCVURM+2
;// 02.08.16 //		LDA	!SCVU+4
;// 02.08.16 //		STA	>SCVURM+4
;// 02.08.16 //		LDA	!SCVU+6
;// 02.08.16 //		STA	>SCVURM+6
;// 02.08.16 //;
;// 02.08.16 //		LDA	!SCKY00
;// 02.08.16 //		STA	>SCKYRM+0
;// 02.08.16 //		LDA	!SCKY10
;// 02.08.16 //		STA	>SCKYRM+2
;// 02.08.16 //		LDA	!SCKX00
;// 02.08.16 //		STA	>SCKXRM+0
;// 02.08.16 //		LDA	!SCKX10
;// 02.08.16 //		STA	>SCKXRM+2
;
		STZ	!GOVRCFG	; game-over check flag off!!
		LDA	!RESTSFG
		BEQ	IIT1005		; restart ?
;					; yes
		JMP	IIT0000
;
IIT1005		EQU	$
		LDA	!GOPOSF
		AND	#000FFH
		ASL	A
		TAX
		ASL	A
		ASL	A
		ASL	A
		TAY
;
		LDA	STRMDT,X
		STA	<RMXYCT		; init. room no.
		STA	!ERXYCT
;;;;;;;;		STA	<NXRMCT
;
		LDA	ISCVDT,X
		STA	<SCCV2
		STA	<SCCV1
		STA	!SSCCV2
		STA	!SSCCV1
		LDA	ISCHDT,X
		STA	<SCCH2
		STA	<SCCH1		; scroll count set
		STA	!SSCCH2
		STA	!SSCCH1
;
		LDA	>MODTBL0
		BEQ	IIT1010		; start demo ?
;					; no
		LDA	IYPSDT,X
		STA	<PLYPS1
		LDA	IXPSDT,X
		STA	<PLXPS1		; player position set
IIT1010		EQU	$
		LDA	IUPCDT,X
		STA	!PYUPCT
;// 03.01.30 //		LDA	IDNCDT,X
		INC	A
		INC	A
		STA	!PYDWCT
		LDA	ILFCDT,X
		STA	!PXLFCT
;// 03.01.30 //		LDA	IRTCDT,X
		INC	A
		INC	A
		STA	!PXRTCT		; up,dwon,left,right check counter set
;
		LDA	#001F8H
		STA	<PSCKRM		; Danjyon pos. check ram set
;
		LDA	DDOPPDT,X
		STA	!GDRBF0
		STZ	!GDRBF1
;
;
		LDA	ISCTDT+0,Y
		STA	!SCVU
		LDA	ISCTDT+2,Y
		STA	!SCVU1
		LDA	ISCTDT+4,Y
		STA	!SCVD
		LDA	ISCTDT+6,Y
		STA	!SCVD1
		LDA	ISCTDT+8,Y
		STA	!SCHL
		LDA	ISCTDT+10,Y
		STA	!SCHL1
		LDA	ISCTDT+12,Y
		STA	!SCHR
		LDA	ISCTDT+14,Y
		STA	!SCHR1
;
;
		LDA	#00000H
		STA	!SCKY00
		LDA	#00110H
		STA	!SCKY10
		LDA	#00000H
		STA	!SCKX00
		LDA	#00100H
		STA	!SCKX10		; scroll end check data init. set
;
;
		LDA	!GOPOSF
		AND	#000FFH
		TAX
;
		MEM8
		SEP	#00100000B	; memory 16bit mode
;
		LDA	#002H
		CPX	#000H
		BEQ	IIT1040		; start ?
;					; no
		CPX	#(STRMD0-STRMDT)/2
		BEQ	IIT1040		;
;					;
		LDA	#000H
IIT1040		EQU	$
		STA	<PLMKCH		; init. player muki set
;
;// 02.12.07 //		LDA	OJCHPT,X
;// 02.12.07 //		STA	!CHARBK
;// 02.12.07 //		STA	!ROBJCPT
		LDA	BGCHPT,X
		STA	!CHIKNO
;// 02.12.07 //		STA	!RBGCPT
;
		LDA	FLNODT,X
		STA	<FLORNO		; init. floor no.
		LDA	DJNPTD,X
		STA	!DJNNO		; danjyon map pointer
		LDA	INDRDT,X
		STA	<PWORK6		; init player in-door data set
		LDA	PBGMDT,X
		STA	<PLBGCKF	; init player BG. check mode set
		LDA	CBGMDT,X
		STA	!CDBGCKF
		LDA	RCKXD0,X
		STA	<RMCKXF
		LDA	RCKYD0,X
		STA	<RMCKYF
		LDA	RCKXD1,X
		STA	<RMXCPT
		LDA	RCKYD1,X
		STA	<RMYCPT
;
		LDX	<RMXYCT
		CPX	#00100H
		BCC	IIT1070		; minka ?
;					; yes
		STZ	<FLORNO
IIT1070		EQU	$
		LDA	#080H
		STA	<KNCRXP
		STA	<KNCRYP
		LDA	#00FH
		STA	<PLMVKY		; Y player move key flag
		STA	<PLMVKY1	; X
		LDA	#0FFH
		STA	<PLZPS1
		STA	<PLZSPD
;
		MEM8
		IDX8
		SEP	#00110000B	; memory,index 8bit mode
;
		PLB			; (DBR) reset
;
		MEM16
		REP	#00100000B	; memory 16bit mode
;
		LDX	#000H
IIT1080		EQU	$
		LDA	>DJNBDT+000H,X
		STA	>BLKTBUF+000H,X
		LDA	>DJNBDT+080H,X
		STA	>BLKTBUF+080H,X
		LDA	>DJNBDT+100H,X
		STA	>BLKTBUF+100H,X	; block data table set
;
		LDA	>DJNLDT+000H,X
		STA	>LMPTBUF+000H,X
		LDA	>DJNLDT+080H,X
		STA	>LMPTBUF+080H,X
		LDA	>DJNLDT+100H,X
		STA	>LMPTBUF+100H,X	; lamp data table set
		INX
		INX
		CPX	#(3*080H)/3
		BNE	IIT1080		; set end ?
;					; yes
		LDX	#(16*16)/4-2
		LDA	#00000H
IIT1090		EQU	$
		STA	>DJINFTBL+000H,X
		STA	>DJINFTBL+040H,X
		STA	>DJINFTBL+080H,X
		STA	>DJINFTBL+0C0H,X
;
		STA	!DJBITRM+000H,X
		STA	!DJBITRM+040H,X
		STA	!DJBITRM+080H,X
		STA	!DJBITRM+0C0H,X
		STA	!DJBITRM+100H,X
		DEX
		DEX
		BPL	IIT1090		; danjyon information clear end ?
;					; yes
IIT1100		EQU	$
		MEM16
		REP	#00100000B	; memory 16bit mode
;
		LDX	#004H
		LDA	<RMXYCT
		CMP	#000F2H
		BEQ	IIT1160		;
;					;
		LDX	#010H
IIT1120		EQU	$
		DEX
		DEX
		BMI	IIT1180		; check end ?
;					; yes
		CMP	>GWPCKD,X
		BNE	IIT1120		; check room ?
;					; yes
IIT1160		EQU	$
		LDA	>MAPPPS1
		ORA	>BITCD0+10H,X
		STA	>MAPPPS1
IIT1180		EQU	$
		MEM8
		IDX8
		SEP	#00110000B	; memory,index 8bit mode
		RTS
;
;
;
;
		MEM16
		IDX16
;************************************************************************
;*		Restart Initial RAM  set  [Danjyon]	(IIT0000)	*
;************************************************************************
RESTRMDT	EQU	$		; start room no.     <RMXYCT>
		WORD	00104H,00011H,00080H,00055H,00041H
;
REISCTDT	EQU	$		; scroll limit data  <SCVU>
		WORD	02100H,02000H,02110H,02110H,00900H,00900H,00900H,00A00H
		WORD	00200H,00200H,00210H,00310H,00200H,00200H,00200H,00300H
		WORD	01000H,01000H,01010H,01110H,00100H,00000H,00100H,00100H
		WORD	00A00H,00A00H,00A10H,00B10H,00B00H,00A00H,00B00H,00B00H
		WORD	00800H,00800H,00810H,00910H,00200H,00200H,00200H,00300H
;
REISCHDT	EQU	$		; sccH               <SCCH>
		WORD	00900H,00280H,00DBH,00A8EH,00280H
;
REISCVDT	EQU	$		; sccV               <SCCV>
		WORD	02110H,00231H,01000H,00A03H,00822H
;
REIYPSDT	EQU	$		; player Y-pos.      <PLYPS1>
		WORD	02178H,0029CH,01041H,00A70H,0088FH
;
REIXPSDT	EQU	$		;        X-pos.      <PLXPS1>
		WORD	00978H,002F8H,00160H,00B06H,002F8H
;
REIUPCDT	EQU	$		; up   check data    <PYUPCT>
		WORD	0017FH,000A7H,00083H,0007BH,0009AH
;
REILFCDT	EQU	$		; left               <PXLFCT>
		WORD	0017FH,000FFH,00167H,0010DH,000FFH
;
REBGCHPT	EQU	$		; BG. character pointer  <CHIKNO>
		BYTE	003H,004H,004H,001H,004H
;
REFLNODT	EQU	$		; floor no. data         <FLORNO>
		BYTE	000H,000H,0FCH,0FFH,001H
;
REDJNPTD	EQU	$		; danjyon map pointer    <DJNNO>
		BYTE	0FFH,000H,002H,0FFH,002H
;
REPBGMDT	EQU	$		; player BG. check mode data  <PLBGCKF>
		BYTE	000H,001H,000H,000H,000H
;
RECBGMDT	EQU	$		; char. BG. check mode data   <CDBGCKF>
		BYTE	000H,001H,000H,001H,000H
;
RERCKXD0	EQU	$               ; room size              <RMCKXF>
		BYTE	000H,002H,002H,002H,002H
;
RERCKXD1	EQU	$               ;                        <RMXCPT>
		BYTE	000H,000H,001H,001H,000H
;
RERCKYD0	EQU	$               ;                        <RMCKYF>
		BYTE	000H,002H,000H,000H,002H
;
RERCKYD1	EQU	$               ;                        <RMYCPT>
		BYTE	002H,000H,000H,000H,000H
;
REDDOPPD	EQU	$		; (GDRBF0)
		WORD	00816H,00000H,00000H,00000H,00000H
;
GOPOSFRM	EQU	$		;                        <GOPOSF>
		WORD	00000H,00002H,00002H,00032H,00004H
;
;
IIT0000		EQU	$
		LDA	>MODTBL3
		AND	#000FFH
		ASL	A
		TAX
		ASL	A
		ASL	A
		ASL	A
		TAY
;
		LDA	GOPOSFRM,X
		STA	!GOPOSF
;
		LDA	RESTRMDT,X
		STA	<RMXYCT		; init. room no.
		STA	!ERXYCT
;
		LDA	REISCVDT,X
		STA	<SCCV2
		STA	<SCCV1
		STA	!SSCCV2
		STA	!SSCCV1
		LDA	REISCHDT,X
		STA	<SCCH2
		STA	<SCCH1		; scroll count set
		STA	!SSCCH2
		STA	!SSCCH1
;
		LDA	>MODTBL0
		BEQ	IIT0010		; start demo ?
;					; no
		LDA	REIYPSDT,X
		STA	<PLYPS1
		LDA	REIXPSDT,X
		STA	<PLXPS1		; player position set
IIT0010		EQU	$
		LDA	REIUPCDT,X
		STA	!PYUPCT
		INC	A
		INC	A
		STA	!PYDWCT
		LDA	REILFCDT,X
		STA	!PXLFCT
		INC	A
		INC	A
		STA	!PXRTCT		; up,dwon,left,right check counter set
;
		LDA	#001F8H
		STA	<PSCKRM		; Danjyon pos. check ram set
		LDA	REDDOPPD,X
		STA	!GDRBF0
;
;
		LDX	#00000H
IIT0020		EQU	$
		LDA	REISCTDT,Y
		STA	!SCVU,X
		INY
		INY
		INX
		INX
		CPX	#00010H
		BNE	IIT0020		;
;					;
;
		LDA	#00000H
		STA	!SCKY00
		LDA	#00110H
		STA	!SCKY10
		LDA	#00000H
		STA	!SCKX00
		LDA	#00100H
		STA	!SCKX10		; scroll end check data init. set
;
;
		LDA	>MODTBL3
		AND	#000FFH
		TAX
;
		MEM8
		SEP	#00100000B	; memory 16bit mode
;
		LDA	#002H
		STA	<PLMKCH		; init. player muki set
;
;// 02.12.07 //		LDA	OJCHPT,X
;// 02.12.07 //		STA	!CHARBK
;// 02.12.07 //		STA	!ROBJCPT
		LDA	REBGCHPT,X
		STA	!CHIKNO
;// 02.12.07 //		STA	!RBGCPT
;
		LDA	REFLNODT,X
		STA	<FLORNO		; init. floor no.
		LDA	REDJNPTD,X
		STA	!DJNNO		; danjyon map pointer
		STZ	<PWORK6		; init player in-door data set
		LDA	REPBGMDT,X
		STA	<PLBGCKF	; init player BG. check mode set
		LDA	RECBGMDT,X
		STA	!CDBGCKF
		LDA	RERCKXD0,X
		STA	<RMCKXF
		LDA	RERCKYD0,X
		STA	<RMCKYF
		LDA	RERCKXD1,X
		STA	<RMXCPT
		LDA	RERCKYD1,X
		STA	<RMYCPT
;
		STZ	!RESTSFG
		JMP	IIT1070
;
;
;
;
		MEM8
		IDX8
;************************************************************************
;*		Initial RAM  set  [Ground]		(IIT2000)	*
;************************************************************************
DROOMDT		EQU	$		; (RMXYCT) check
		WORD	00104H
		WORD	00011H,00060H,00061H,00062H,0FFFFH,00090H
;
		WORD	000F0H,000F1H,000D9H,00074H,00076H,00083H,00063H,000F2H
		WORD	000F3H,000F4H,000F5H,000F6H,000F7H,000F8H,000E8H,000E9H
		WORD	000FBH,000EBH,000FCH,000ECH,000FDH,000EDH,000FEH,000EEH
		WORD	000FFH,000EFH,000DFH,000F9H,000FAH,000EAH,000E0H,00028H
		WORD	0004AH,000D2H,00048H,00057H,00058H,00056H,00039H,0000EH
		WORD	000E6H,000E7H,000E4H,000E5H,00055H,00000H,00000H,00000H
;
		WORD	00180H,00181H,00182H,00183H,00880H,00881H
DRMDTE		EQU	$
;
;// 03.05.10 //DDPMSRM		EQU	$		; (DPMAIN,DPSUB)
;// 03.05.10 //;			  104
;// 03.05.10 //		WORD	00016H
;// 03.05.10 //;			   40     60     61    62
;// 03.05.10 //		WORD	00016H,00016H,00016H,00016H,00016H,00016H
;// 03.05.10 //;
;// 03.05.10 //;			   F0     F1     54    74      76     83     63     F2
;// 03.05.10 //		WORD	00016H,00016H,00016H,00016H,00016H,00016H,00016H,00016H
;// 03.05.10 //;			   F3     F4     F5    F6      F7     F8     E8     E9
;// 03.05.10 //		WORD	00016H,00016H,00016H,00016H,00016H,00016H,00016H,00016H
;// 03.05.10 //;			   FB     EB     FC    EC      FD     ED     FE     EE
;// 03.05.10 //		WORD	00016H,00016H,00016H,00016H,00016H,00016H,00016H,00016H
;// 03.05.10 //;			   FF     EF     DF    F9      FA     EA     C0     38
;// 03.05.10 //		WORD	00016H,00016H,00016H,00016H,00016H,00016H,00016H,00016H
;// 03.05.10 //;                          4A     D2     48    57      58     56     39     0E 
;// 03.05.10 // 		WORD	00016H,00016H,00016H,00016H,00016H,00016H,00016H,00016H
;// 03.05.10 //;
;// 03.05.10 //		WORD	00016H,00016H,00016H,00016H,00016H,00016H,00016H,00016H
;// 03.05.10 //;
;// 03.05.10 //		WORD	00016H,00016H,00016H,00016H,00016H,00016H
DSCCVRM		EQU	$		; (SCCV2,SCCV1)
;			  104
		WORD	00A96H
;// 03.05.23 //		WORD	006E6H
;			   11     60     61    62
		WORD	00400H,00600H,00692H,00600H,00200H,00600H
;			   F0     F1     D9    74      76     83     63     F2
		WORD	0025AH,00293H,00600H,00C6EH,00C46H,00C66H,00C00H,00646H
;			   F3     F4     F5    F6      F7     F8     E8     E9
		WORD	0064BH,00B06H,00B06H,00000H,00000H,00145H,000A6H,00086H
;			   FB     EB     FC    EC      FD     ED     FE     EE
		WORD	00267H,001A9H,00245H,00146H,001CAH,00145H,001A5H,00145H
;			   FF     EF     DF    F9      FA     EA     E0     38
		WORD	001E9H,00305H,00099H,001C9H,001E6H,00135H,00600H,00E8AH
;                          4A     D2     48    57      58     56     39     0E 
		WORD	00600H,00C66H,00066H,001E6H,001F6H,001A6H,00076H,00D66H
;			   E6     E7     E4    E5      55
		WORD	00205H,001C9H,00320H,00226H,0067AH,00000H,00000H,00000H
;
		WORD	00320H,00000H,00320H,00020H,00320H,00080H
DSCCHRM		EQU	$		; (SCCH2,SCCH1)
;			  104
		WORD	0084EH
;// 03.05.23 //		WORD	004C2H
;			   11     60     61    62
		WORD	006E6H,006B6H,00786H,00856H,00EE2H,0076AH
;			   F0     F1     D9    74      76     83     63     F2
		WORD	00500H,0060EH,00EE2H,000A2H,00132H,00000H,00000H,001EEH
;			   F3     F4     F5    F6      F7     F8     E8     E9
		WORD    00230H,00100H,00200H,00B4EH,00C6EH,00C0EH,00C1EH,00D00H
;			   FB     EB     FC    EC      FD     ED     FE     EE
		WORD    00C5EH,00BCEH,00C0AH,00C3EH,00CAEH,00CAAH,00C5AH,00C3EH
;			   FF     EF     DF    F9      FA     EA     E0     38
		WORD    00D00H,00D00H,00D00H,006DEH,00752H,00752H,0078EH,006F2H
;                          4A     D2     48    57      58     56     39     0E 
		WORD	00EE2H,000A2H,00242H,001C2H,00262H,00066H,00022H,00C4EH
;                          E6     E7     E4    E5      55
		WORD	00500H,00600H,006BEH,0081EH,0085EH,00000H,00000H,00000H
;
		WORD	00000H,00100H,0021EH,00600H,00C00H,00078H
DPLYPRM		EQU	$		; (PLYPS1)
;			  104
		WORD	00AF8H-10H
;// 03.05.23 //		WORD	00748H-10H
;			   11         60         61         62
		WORD	00438H-24H,00620H-24H,006F0H-24H,00620H-24H,00213H-10H,00658H-00H
;			   F0         F1         D9         74         76         83         63         F2
		WORD	002C8H-10H,002F0H-10H,00628H-10H,00CD0H-10H,00CA8H-10H,00CC8H-10H,00C50H-10H,006A8H-10H
;			   F3         F4         F5         F6         F7         F8         E8         E9
		WORD    006A8H-10H,00B68H-10H,00B68H-10H,00018H-10H,00027H-10H,001A7H-10H,00108H-10H,000E8H-10H
;			   FB         EB         FC         EC         FD         ED         FE         EE
		WORD    00287H-10H,00207H-10H,002A7H-10H,001A8H-10H,00228H-10H,001A7H-10H,00207H-10H,001A7H-10H
;			   FF         EF         DF         F9         FA         EA         E0         38
		WORD    00247H-10H,00367H-10H,000F7H-10H,00227H-10H,00248H-10H,00197H-10H,00657H-24H,00EE8H-10H
;                          4A         D2         48         57         58         56         39         0E
		WORD	00648H-10H,00CC8H-10H,000C8H-10H,00248H-10H,00258H-10H,00208H-10H,000D8H-10H,00DC8H-10H
;                          E6         E7         E4         E5         55
		WORD	00267H-10H,00227H-10H,003B8H-10H,00288H-10H,006D8H-10H,00000H-10H,00000H,00000H
;
		WORD	003E8H,00080H,003E8H,000E8H,003E8H,000E8H
DPLXPRM		EQU	$		; (PLXPS1)
;			  104
		WORD	008B8H
;// 03.05.23 //		WORD	00548H
;			   11     60     61    62
		WORD	00758H,00728H,007F8H,008C8H,00F50H,007F0H
;			   F0     F1     D9    74      76     83     63     F2
		WORD	00588H,00678H,00F50H,00128H,001B8H,00058H,00078H,00258H
;			   F3     F4     F5    F6      F7     F8     E8     E9
		WORD	002B8H,001B8H,00238H,00BB8H,00CD8H,00C78H,00C88H,00D98H
;			   FB     EB     FC    EC      FD     ED     FE     EE
		WORD	00CC8H,00C38H,00C78H,00CA8H,00D18H,00D18H,00CC8H,00CA8H
;			   FF     EF     DF    F9      FA     EA     E0     38
		WORD	00DA8H,00DC8H,00DB8H,00748H,007C8H,007C8H,007F8H,00778H
;                          4A     D2     48    57      58     56     39     0E 
		WORD	00F50H,00128H,002C8H,00248H,002E8H,000E8H,000A8H,00CB8H
;                          E6     E7     E4    E5      55
		WORD	005B8H,00648H,00728H,00888H,008C8H,00000H,00000H,00000H
;
		WORD	00080H,001F0H,0029EH,006A8H,00C70H,000F0H
DUPCTRM		EQU	$		; (PYUPCT)
;			  104
		WORD	00B03H
;// 03.05.23 //		WORD	00753H
;			   11     60     61    62
		WORD	0046DH,0066DH,006FFH,0066DH,0026DH,0066DH
;			   F0     F1     D9    74      76     83     63     F2
		WORD	002D7H,00300H,0066DH,00CDBH,00CB3H,00CD3H,00C6DH,006B3H
;			   F3     F4     F5    F6      F7     F8     E8     E9
		WORD	006B8H,00B73H,00B73H,0006DH,0006DH,001B2H,00113H,000F3H
;			   FB     EB     FC    EC      FD     ED     FE     EE
		WORD	00293H,00216H,002B2H,001B3H,00237H,001B2H,00212H,001B2H
;			   FF     EF     DF    F9      FA     EA     E0     38
		WORD	00256H,00372H,00106H,00236H,00253H,001A2H,0066DH,00EF7H
;                          4A     D2     48    57      58     56     39     0E 
		WORD	0066DH,00CD3H,000D3H,00253H,00263H,00213H,000E3H,00DD3H
;			   E6     E7     E4    E5      55
		WORD	00272H,00236H,0038DH,00293H,006E7H,00000H,00000H,00000H
;
		WORD	0039DH,0008FH,0039DH,0009DH,0039DH,000F5H
DLFCTRM		EQU	$		; (PXLFCT)
;			  104
		WORD	008C3H
;// 03.05.23 //		WORD	0054FH
;			   11     60     61    62
		WORD	00763H,00733H,00803H,008D3H,00F57H,007F7H
;			   F0     F1     D9    74      76     83     63     F2
		WORD	0058DH,00683H,00F57H,0012FH,001BFH,0008DH,0008DH,00263H
;			   F3     F4     F5    F6      F7     F8     E8     E9
		WORD	002BDH,0018DH,00275H,00BC3H,00CE3H,00C83H,00C93H,00D75H
;			   FB     EB     FC    EC      FD     ED     FE     EE
		WORD	00CD3H,00C43H,00C7FH,00CB3H,00D23H,00D1FH,00CCFH,00CB3H
;			   FF     EF     DF    F9      FA     EA     E0     38
		WORD	00D75H,00D75H,00D8DH,00753H,007CFH,007CFH,00803H,0077FH
;                          4A     D2     48    57      58     56     39     0E 
		WORD	00F57H,0012FH,002CFH,0024FH,002EFH,000F3H,000AFH,00CC3H
;			   E6     E7     E4    E5      55
		WORD	0058DH,00675H,00733H,00893H,008D3H,00000H,00000H,00000H
;
		WORD	00083H,0018DH,002A1H,00683H,00C7DH,000FBH
DMPDNRM		EQU	$		; (MPDTNO)
;			  104
		WORD	0002CH
;// 03.05.23 //		WORD	0001AH
;			   11     60     61    62
		WORD	00013H,0001BH,0001BH,0001BH,0000FH,0005BH
;			   F0     F1     D9    74      76     83     63     F2
		WORD	0000AH,00003H,0001EH,00030H,00030H,00030H,00030H,00018H
;			   F3     F4     F5    F6      F7     F8     E8     E9
		WORD	00018H,00028H,00029H,00005H,00005H,00005H,00005H,00005H
;			   FB     EB     FC    EC      FD     ED     FE     EE
		WORD	00005H,00005H,00005H,00005H,00005H,00005H,00005H,00005H
;			   FF     EF     DF    F9      FA     EA     E0     38
		WORD	00005H,00005H,00005H,00003H,00003H,00003H,0001BH,0007BH
;                          4A     D2     48    57      58     56     39     0E 
		WORD	0005EH,00070H,00040H,00040H,00040H,00040H,00040H,00075H
;			   E6	  E7     E4    E5      55
		WORD	0000AH,00003H,00003H,00003H,0001BH,00000H,00000H,00000H
;
		WORD	00080H,00080H,00081H,00083H,00086H,0001EH
DSRPTRM		EQU	$		; (SCRPNT)
;			  104
		WORD	00408H
;// 03.05.23 //		WORD	0079AH
;			   11     60     61    62
		WORD	0001CH,00018H,00530H,0004AH,0001CH,0002EH
;			   F0     F1     D9    74      76     83     63     F2
		WORD	00320H,01500H,0005CH,00296H,001A8H,00280H,00000H,001BEH
;			   F3     F4     F5    F6      F7     F8     E8     E9
		WORD	002C6H,008A0H,00780H,00028H,0004EH,009C2H,004C4H,003E0H
;			   FB     EB     FC    EC      FD     ED     FE     EE
		WORD	010CCH,00CBAH,011C0H,009C6H,00ED4H,009D6H,00CCAH,009C8H
;			   FF     EF     DF    F9      FA     EA     E0     38
		WORD	00FE0H,017E0H,00560H,00E9AH,00EAAH,0092AH,00032H,0049EH
;                          4A     D2     48    57      58     56     39     0E 
		WORD	0005CH,00296H,002C8H,00EBAH,00F4CH,00C8EH,00306H,00BCAH
;			   E6	  E7     E4    E5      55
		WORD	00020H,00E80H,01818H,010C4H,0044CH,00000H,00000H,00000H
;
		WORD	01800H,00020H,01782H,00000H,01800H,00410H
;
DGDRSP0		EQU	$		; (GDRBF0)
;			  104
		WORD	00816H
;// 03.05.23 //		WORD	00AA8H
;			   11     60     61    62
		WORD	00000H,00000H,00000H,00000H,00000H,00000H
;			   F0     F1     D9    74      76     83     63     F2
		WORD	00000H,00000H,00000H,00000H,00000H,00000H,00000H,005CAH
;			   F3     F4     F5    F6      F7     F8     E8     E9
		WORD	005D6H,00BB6H,00B86H,00000H,00000H,00000H,00000H,00000H
;			   FB     EB     FC    EC      FD     ED     FE     EE
		WORD	00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H
;			   FF     EF     DF    F9      FA     EA     E0     38
		WORD	00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H
;                          4A     D2     48    57      58     56     39     0E 
		WORD	00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H
;			   E6	  E7     E4    E5      55
		WORD	00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H
;
		WORD	00000H,00000H,00000H,00000H,00000H,00000H
;
DGDRSP1		EQU	$		; (GDRBF1)
;			  104
		WORD	00000H
;			   11     60     61    62
		WORD	001AAH,08124H,087BEH,08158H,00000H,00000H
;			   F0     F1     D9    74      76     83     63     F2
		WORD	00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H
;			   F3     F4     F5    F6      F7     F8     E8     E9
		WORD	00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H
;			   FB     EB     FC    EC      FD     ED     FE     EE
		WORD	00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H
;			   FF     EF     DF    F9      FA     EA     E0     38
		WORD	00000H,00000H,00000H,00000H,00000H,00000H,082BEH,00000H
;                          4A     D2     48    57      58     56     39     0E 
		WORD	00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H
;			   E6	  E7     E4    E5      55
		WORD	00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H
;
		WORD	00000H,00000H,00000H,00000H,00000H,00000H
;
DUPSCRM		EQU	$		; (UPSLCT)
;			  104
		WORD	0000AH
;// 03.05.23 //		WORD	0000AH
;			   11     60     61    62
		WORD	00000H,00000H,0000EH,00000H,00000H,00000H
;			   F0     F1     D9    74      76     83     63     F2
		WORD	00006H,0000DH,00000H,00002H,0000AH,0000AH,00000H,0000AH
;			   F3     F4     F5    F6      F7     F8     E8     E9
		WORD	00005H,0000AH,0000AH,00000H,00000H,0000BH,0000AH,0000AH
;			   FB     EB     FC    EC      FD     ED     FE     EE
		WORD	0000AH,00007H,0000BH,0000AH,00006H,0000BH,0000BH,0000BH
;			   FF     EF     DF    F9      FA     EA     E0     38
		WORD	00007H,0000BH,00007H,00007H,0000AH,0000BH,00000H,00006H
;                          4A     D2     48    57      58     56     39     0E 
		WORD	00000H,0000AH,0000AH,0000AH,0000AH,0000AH,0000AH,0000AH
;			   E6	  E7     E4    E5      55
		WORD	0000BH,00007H,00000H,0000AH,00006H,00000H,00000H,00000H
;
		WORD	00000H,00000H,00000H,00000H,00000H,00000H
;
DLFSCRM		EQU	$		; (LFSLCT)
;			  104
		WORD	0FFF2H
;// 03.05.23 //		WORD	0000EH
;			   11     60     61    62
		WORD	0FFFAH,0000AH,0FFFAH,0FFFAH,0FFFEH,00006H
;			   F0     F1     D9    74      76     83     63     F2
		WORD	00000H,0FFF2H,0FFFEH,0000EH,0000EH,00000H,00000H,0FFF6H
;			   F3     F4     F5    F6      F7     F8     E8     E9
		WORD	0FFFBH,00000H,0FFF6H,0FFF2H,00002H,00002H,00002H,00000H
;			   FB     EB     FC    EC      FD     ED     FE     EE
		WORD	00002H,00002H,0FFF6H,0FFF2H,0FFF2H,00006H,0FFF6H,00002H
;			   FF     EF     DF    F9      FA     EA     E0     38
		WORD	00000H,00000H,00000H,0FFF2H,0FFF6H,0FFF5H,00002H,0FFFEH
;                          4A     D2     48    57      58     56     39     0E 
		WORD	0FFFEH,0000EH,0FFFEH,0000EH,0FFFEH,0000AH,0000EH,00002H
;			   E6	  E7     E4    E5      55
		WORD	00000H,00000H,00002H,00002H,00002H,00000H,00000H,00000H
;
		WORD	00000H,00000H,0FFF2H,00000H,00000H,00000H
;
;
;
IIT2000		EQU	$
		PHB
		PHK
		PLB			; (DBR) set
;
		STZ	<GMMODE		; game-mode (GROUND) set
;
		MEM16
		REP	#00100000B	; memory 16bit mode
;
		LDA	#000FFH
		STA	!DJNNO
		STZ	!GDMMPT		; ground memory buffer pointer clear
;
		LDA	<RMXYCT
		CMP	#00104H
		BEQ	IIT205		; link-house ?
;					; no
		CMP	#00180H
		BCS	IIT205		; minka ?
;					; yes
		CMP	#00100H
		BCC	IIT205		; minka ?
;					; yes
		JSR	IIT2100
		JMP	IIT240
;
IIT205		EQU	$
		LDX	#DRMDTE-DROOMDT
IIT210		EQU	$
		DEX
		DEX
		CMP	DROOMDT,X
		BNE	IIT210		;
;					;
;// 03.05.10 //		LDA	DDPMSRM,X
;// 03.05.10 //		STA	<DPMAIN		; DPMAIN,DPSUB pull
;
		LDA	DSCCVRM,X
		STA	<SCCV1
		STA	<SCCV2
		STA	!SSCCV2
		STA	!SSCCV1
		LDA	DSCCHRM,X
		STA	<SCCH1
		STA	<SCCH2		; SCCH,V pull
		STA	!SSCCH2
		STA	!SSCCH1
;
		LDA	DPLYPRM,X
		STA	<PLYPS1
		LDA	DPLXPRM,X
		STA	<PLXPS1		; Ground position pull
;
		LDA	DUPSCRM,X
		STA	!UPSLCT
		LDA	#00000H
		SEC
		SBC	!UPSLCT
		STA	!DWSLCT
		LDA	DLFSCRM,X
		STA	!LFSLCT
		LDA	#00000H
		SEC
		SBC	!LFSLCT
		STA	!RTSLCT
;
		LDA	DMPDNRM,X
		STA	<MPDTNO
		STA	!GRNDNO
		LDA	DSRPTRM,X
		STA	<SCRPNT		; Ground information pull
		SEC
		SBC	#00400H
		AND	#00F80H
		ASL	A
		XBA
		STA	<YWRITE
		LDA	<SCRPNT
		SEC
		SBC	#00010H
		AND	#0003EH
		LSR	A
		STA	<XWRITE
;
		LDA	DUPCTRM,X
		STA	!PYUPCT
;// 03.02.01 //		LDA	DDWCTRM,X
		DEC	A
		DEC	A
		STA	!PYDWCT
		LDA	DLFCTRM,X
		STA	!PXLFCT
;// 03.02.01 //		LDA	DRTCTRM,X
		DEC	A
		DEC	A
		STA	!PXRTCT		; up,dwon,left,right check counter pull
		LDA	#00002H
		STA	<PLMKCH
;
		LDA	DGDRSP0,X
		STA	!GDRBF0
		LDA	DGDRSP1,X
		STA	!GDRBF1
IIT240		EQU	$
		PLB			; (DBR) reset
IIT250		EQU	$
		LDA	#0FFF8H
		STA	<PSCKRM		; Ground pos. check ram set
;
		MEM8
		IDX8
		SEP	#00110000B	; memory,index 8bit mode
;
		PHB
		PHK
		PLB			; (DBR) set
;
		JSR	GDMCK800	; information ram set
		LDA	#0E4H
		STA	!GRMSZ1
		STZ	!GRMSZ0+1
;
		LDA	<MPDTNO
		AND	#00111111B
		ASL	A
		TAY
;
		MEM16
		REP	#00100000B	; memory 16bit mode
;
		LDX	#000H
		LDA	!GRMSZ0
		BEQ	IIT260		; 4x4 room ?
;					; yes
		INX
		INX
IIT260		EQU	$
		JSR	GSLC400		; scroll check RAM set
;
		MEM8
		SEP	#00100000B	; memory 8bit mode
;
		PLB			; (DBR) reset
;
		STZ	<RMXCPT
		LDA	#002H
		STA	<RMYCPT
		STA	<RMCKXF
		STA	<RMCKYF
;
		LDA	#080H
		STA	<KNCRXP
		STA	<KNCRYP
		LDA	#00FH
		STA	<PLMVKY		; Y player move key flag
		STA	<PLMVKY1	; X
		LDA	#0FFH
		STA	<PLZPS1
		STA	<PLZSPD
		RTS
;
;
IIT2100		EQU	$
		MEM16
		REP	#00100000B	; memory 16bit mode
;
		LDA	>GRNOBK
		STA	!GRNDNO		; grond no. pull
;
		LDA	>DPMSBK
		STA	<DPMAIN		; DPMAIN,DPSUB pull
;
		LDA	>SCV2BK
		STA	<SCCV1
		STA	<SCCV2
		STA	!SSCCV2
		STA	!SSCCV1
		LDA	>SCH2BK
		STA	<SCCH1
		STA	<SCCH2		; SCCH,V pull
		STA	!SSCCH2
		STA	!SSCCH1
;
		LDA	>PLYPBK
		STA	<PLYPS1
;// 03.04.02 //		AND	#0000FH
;// 03.04.02 //		STA	!DWSLCT
;// 03.04.02 //		ORA	#0FFF0H
;// 03.04.02 //		STA	!UPSLCT
		LDA	>PLXPBK
		STA	<PLXPS1		; Ground position pull
;// 03.04.02 //		AND	#0000FH
;// 03.04.02 //		STA	!RTSLCT
;// 03.04.02 //		ORA	#0FFF0H
;// 03.04.02 //		STA	!LFSLCT
		LDA	<PLYPS1
		SEC
		SBC	#00010H
		STA	<PLYPS1
		LDA	#00002H
		STA	<PLMKCH
		LDA	!GDRBF0
		CMP	#0FFFFH
		BNE	IIT2140		;
;					;
		LDA	<PLYPS1
		CLC
		ADC	#00020H
		STA	<PLYPS1
		STZ	<PLMKCH
IIT2140		EQU	$
		LDA	>MPDNBK
		STA	<MPDTNO
		LDA	>SRPTBK
		STA	<SCRPNT		; Ground information pull
		SEC
		SBC	#00400H
		AND	#00F80H
		ASL	A
		XBA
		STA	<YWRITE
		LDA	<SCRPNT
		SEC
		SBC	#00010H
		AND	#0003EH
		LSR	A
		STA	<XWRITE
;
;
		LDA	>UPCTBK
		STA	!PYUPCT
		DEC	A
		DEC	A
		STA	!PYDWCT
		LDA	>LFCTBK
		STA	!PXLFCT
		DEC	A
		DEC	A
		STA	!PXRTCT		; up,dwon,left,right check counter pull
;
		LDA	>SCVUBK+0
		STA	!SCVU+0
		LDA	>SCVUBK+2
		STA	!SCVU+2
		LDA	>SCVUBK+4
		STA	!SCVU+4
		LDA	>SCVUBK+6
		STA	!SCVU+6
;
		LDA	>SCKYBK+0
		STA	!SCKY00
		LDA	>SCKYBK+2
		STA	!SCKY10
		LDA	>SCKXBK+0
		STA	!SCKX00
		LDA	>SCKXBK+2
		STA	!SCKX10		; scroll end check data init. set
;
		LDA	>USCTBK
		STA	!UPSLCT
		LDA	>DSCTBK
		STA	!DWSLCT
		LDA	>LSCTBK
		STA	!LFSLCT
		LDA	>RSCTBK
		STA	!RTSLCT
;
		MEM8
		SEP	#00100000B	; memory 8bit mode
;
		LDA	>CHBKBK
		STA	!CHARBK
		LDA	>CHNOBK
		STA	!CHIKNO
		LDA	>RBGPBK
		STA	!RBGCPT
		LDA	>ROJPBK
		STA	!ROBJCPT
;
		MEM16
		REP	#00100000B	; memory 16bit mode
		RTS
;
;
;
		MEM8
;************************************************************************
;*		Initial RAM  set  [Ground --> Event]	(IIT3000)	*
;************************************************************************
GCCKYD		EQU	$		; ground charcater y-pos. check data
SCVU0DT		EQU	$
		WORD	00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H
		WORD	00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H
		WORD	00400H,00400H,00400H,00400H,00400H,00400H,00400H,00400H
		WORD	00600H,00600H,00600H,00600H,00600H,00600H,00600H,00600H
		WORD	00600H,00600H,00800H,00600H,00600H,00800H,00600H,00600H
		WORD	00A00H,00A00H,00A00H,00A00H,00A00H,00A00H,00A00H,00A00H
		WORD	00C00H,00C00H,00C00H,00C00H,00C00H,00C00H,00C00H,00C00H
		WORD	00C00H,00C00H,00E00H,00E00H,00E00H,00C00H,00C00H,00E00H
;
SCVU1DT		EQU	$
		WORD	00320H,00020H,00320H,00020H,00000H,00000H,00320H,00320H
		WORD	00320H,00020H,00000H,00000H,00000H,00000H,00320H,00320H
		WORD	00400H,00400H,00400H,00400H,00400H,00400H,00400H,00400H
		WORD	00600H,00600H,00600H,00600H,00600H,00600H,00600H,00600H
		WORD	00600H,00600H,00800H,00600H,00600H,00800H,00600H,00600H
		WORD	00A00H,00A00H,00A00H,00A00H,00A00H,00A00H,00A00H,00A00H
		WORD	00C00H,00C00H,00C00H,00C00H,00C00H,00C00H,00C00H,00C00H
		WORD	00C00H,00C00H,00E00H,00E00H,00E00H,00C00H,00C00H,00E00H
;
SCHU0DT		EQU	$
		WORD	00000H,00100H,00200H,00600H,00600H,00A00H,00C00H,00C00H
		WORD	00000H,00000H,00200H,00600H,00600H,00A00H,00C00H,00C00H
		WORD	00000H,00200H,00400H,00600H,00800H,00A00H,00C00H,00E00H
		WORD	00000H,00000H,00400H,00600H,00600H,00A00H,00C00H,00C00H
		WORD	00000H,00000H,00400H,00600H,00600H,00A00H,00C00H,00C00H
		WORD	00000H,00200H,00400H,00600H,00800H,00A00H,00C00H,00E00H
		WORD	00000H,00000H,00400H,00600H,00800H,00A00H,00A00H,00E00H
		WORD	00000H,00000H,00400H,00600H,00800H,00A00H,00A00H,00E00H
;
SCHU1DT		EQU	$
		WORD	00000H,00100H,00500H,00600H,00600H,00A00H,00C00H,00C00H
		WORD	00000H,00200H,00400H,00600H,00600H,00A00H,00C00H,00C00H
		WORD	00000H,00200H,00400H,00600H,00800H,00A00H,00C00H,00E00H
		WORD	00000H,00000H,00400H,00600H,00600H,00A00H,00C00H,00C00H
		WORD	00000H,00000H,00400H,00600H,00600H,00A00H,00C00H,00C00H
		WORD	00000H,00200H,00400H,00600H,00800H,00A00H,00C00H,00E00H
		WORD	00000H,00000H,00400H,00600H,00800H,00A00H,00A00H,00E00H
		WORD	00000H,00000H,00400H,00600H,00800H,00A00H,00A00H,00E00H
;
;
SCKY0DT		EQU	$
		WORD	0FF20H,0FF20H,0FF20H,0FF20H,0FF20H,0FF20H,0FF20H,0FF20H
		WORD	0FF20H,0FF20H,00120H,0FF20H,0FF20H,0FF20H,0FF20H,00120H
		WORD	00320H,00320H,00320H,00320H,00320H,00320H,00320H,00320H
		WORD	00520H,00520H,00520H,00520H,00520H,00520H,00520H,00520H
		WORD	00520H,00520H,00720H,00520H,00520H,00720H,00520H,00520H
		WORD	00920H,00920H,00920H,00920H,00920H,00920H,00920H,00920H
		WORD	00B20H,00B20H,00B20H,00B20H,00B20H,00B20H,00B20H,00B20H
		WORD	00B20H,00B20H,00D20H,00D20H,00D20H,00B20H,00B20H,00D20H
;
SCKX0DT		EQU	$
		WORD	0FFFCH,00100H,00300H,00100H,00500H,00900H,00B00H,00B00H
		WORD	0FFFCH,00200H,00300H,00500H,00500H,00900H,00B00H,00B00H
		WORD	0FF00H,00100H,00300H,00500H,00700H,00900H,00B00H,00D00H
		WORD	0FF00H,0FF00H,00300H,00500H,00500H,00900H,00B00H,00B00H
		WORD	0FF00H,0FF00H,00300H,00500H,00500H,00900H,00B00H,00B00H
		WORD	0FF00H,00100H,00300H,00500H,00700H,00900H,00B00H,00D00H
		WORD	0FF00H,0FF00H,00300H,00500H,00700H,00900H,00900H,00D00H
		WORD	0FF00H,0FF00H,00300H,00500H,00700H,00900H,00900H,00D00H
;
SCKY1DT		EQU	$
		WORD	0FF20H,0FF20H,0FF20H,0FF20H,0FF20H,0FF20H,00400H,00400H
		WORD	0FF20H,0FF20H,00120H,0FF20H,0FF20H,0FF20H,00400H,00400H
		WORD	00320H,00320H,00320H,00320H,00320H,00320H,00320H,00320H
		WORD	00520H,00520H,00520H,00520H,00520H,00520H,00520H,00520H
		WORD	00520H,00520H,00720H,00520H,00520H,00720H,00520H,00520H
		WORD	00920H,00920H,00920H,00920H,00920H,00920H,00920H,00920H
		WORD	00B20H,00B20H,00B20H,00B20H,00B20H,00B20H,00B20H,00B20H
		WORD	00B20H,00B20H,00D20H,00D20H,00D20H,00B20H,00B20H,00D20H
;
SCKX1DT		EQU	$
		WORD	00004H,00104H,00300H,00100H,00500H,00900H,00B00H,00B00H
		WORD	00004H,00104H,00300H,00100H,00500H,00900H,00B00H,00B00H
		WORD	0FF00H,00100H,00300H,00500H,00700H,00900H,00B00H,00D00H
		WORD	0FF00H,0FF00H,00300H,00500H,00500H,00900H,00B00H,00B00H
		WORD	0FF00H,0FF00H,00300H,00500H,00500H,00900H,00B00H,00B00H
		WORD	0FF00H,00100H,00300H,00500H,00700H,00900H,00B00H,00D00H
		WORD	0FF00H,0FF00H,00300H,00500H,00700H,00900H,00900H,00D00H
		WORD	0FF00H,0FF00H,00300H,00500H,00700H,00900H,00900H,00D00H
;
;
GCCKXD		EQU	$		;                  x-pos. check data
		WORD	00000H,00000H,00200H,00600H,00600H,00A00H,00C00H,00C00H
		WORD	00000H,00000H,00200H,00600H,00600H,00A00H,00C00H,00C00H
		WORD	00000H,00200H,00400H,00600H,00800H,00A00H,00C00H,00E00H
		WORD	00000H,00000H,00400H,00600H,00600H,00A00H,00C00H,00C00H
		WORD	00000H,00000H,00400H,00600H,00600H,00A00H,00C00H,00C00H
		WORD	00000H,00200H,00400H,00600H,00800H,00A00H,00C00H,00E00H
		WORD	00000H,00000H,00400H,00600H,00800H,00A00H,00A00H,00E00H
		WORD	00000H,00000H,00400H,00600H,00800H,00A00H,00A00H,00E00H
;
;
EPMKDT		EQU	$		; event player muki data
		HEX	00,04,00,00,00,00,00,00
		HEX	00,00,00,00,00,00,00,00
		HEX	00,00,00,00,00,00,00,00
		HEX	00,00,00,00,00,00,00,00
		HEX	00,00,00,00,00,00,00,00
		HEX	00,00,00,00,00,00,00,00
		HEX	00,00,00,00,00,00,00,00
		HEX	00,00,00,00,00,00,00,00
;
;
ROBJCDT		EQU	$
		HEX	0C,0C,0E,0E,0E,10,10,10
		HEX	0C,0C,0E,0E,10,10,10,10
		HEX	10,12,10,13,13,10,12,12
		HEX	10,10,12,11,11,12,10,10
		HEX	10,10,10,11,11,10,10,10
		HEX	10,10,10,10,10,12,10,10
		HEX	10,10,12,12,12,12,10,10
		HEX	10,10,10,10,10,10,10,10
;
RBGCDT		EQU	$
		HEX	2F,2F,2F,2F,2F,2F,2F,2F
		HEX	2F,2F,2F,2F,2F,2F,2F,2F
		HEX	2F,2F,2F,2F,2F,2F,2F,2F
		HEX	2F,2F,2F,2F,2F,2F,2F,2F
		HEX	2F,2F,2F,2F,2F,2F,2F,2F
		HEX	2F,2F,2F,2F,2F,2F,2F,2F
		HEX	2F,2F,2F,2F,2F,2F,2F,2F
		HEX	2F,2F,2F,2F,2F,2F,2F,2F
;
ECGPTDT		EQU	$
		HEX	0A,0A,0A,0A,02,02,02,0A
		HEX	0A,0A,0A,02,02,02,02,0A
		HEX	0A,0A,0A,09,09,0A,0A,0A
		HEX	03,03,0A,04,04,07,05,05
		HEX	03,03,0A,04,04,07,05,05
		HEX	0A,0A,0A,0A,0A,0A,0A,0A
		HEX	06,06,0A,0A,0A,07,07,0A
		HEX	06,06,0A,0A,0A,07,07,0A
;
EOJCTBL		EQU	$
		HEX	08,08,08,08,00,00,00,00
		HEX	08,08,08,00,00,00,00,02
		HEX	04,04,00,00,00,00,02,02
		HEX	04,04,00,01,01,02,00,00
		HEX	04,04,04,01,01,02,00,00
		HEX	04,00,00,00,00,02,00,00
		HEX	03,03,00,02,02,02,02,02
		HEX	03,03,00,02,02,02,02,02
;
;
;
;
IIT3000		EQU	$
		MEM16
		REP	#00100000B	; memory 16bit mode
;
		STZ	!GDMMPT		; ground memory buffer pointer clear
;
		LDA	!GRNDNO
		CMP	#00081H
		BNE	IIT3005		;
;					;
		JMP	IIT3010
;
IIT3005		EQU	$
		STA	>GRNORM		; ground no. push
;
		LDA	<DPMAIN
		STA	>DPMSRM		; DPMAIN & DPSUB push
;
		LDA	<SCCV2
		STA	>SCV2RM
		LDA	<SCCH2
		STA	>SCH2RM		; SCCH,V push
;
		LDA	<PLYPS1
		STA	>PLYPRM
		LDA	<PLXPS1
		STA	>PLXPRM		; Ground position push
;
		LDA	!PYUPCT
		STA	>UPCTRM
		LDA	!PXLFCT
		STA	>LFCTRM		; up,left check counter push
;
		LDA	<MPDTNO
		STA	>MPDNRM
		LDA	<SCRPNT
		STA	>SRPTRM		; Ground information push
;
		LDA	!SCVU+0
		STA	>SCVURM+0
		LDA	!SCVU+2
		STA	>SCVURM+2
		LDA	!SCVU+4
		STA	>SCVURM+4
		LDA	!SCVU+6
		STA	>SCVURM+6
;
		LDA	!SCKY00
		STA	>SCKYRM+0
		LDA	!SCKY10
		STA	>SCKYRM+2
		LDA	!SCKX00
		STA	>SCKXRM+0
		LDA	!SCKX10
		STA	>SCKXRM+2
;
		LDA	!UPSLCT
		STA	>USCTRM
		LDA	!DWSLCT
		STA	>DSCTRM
		LDA	!LFSLCT
		STA	>LSCTRM
		LDA	!RTSLCT
		STA	>RSCTRM
;
		MEM8
		SEP	#00100000B	; memory 8bit mode
;
;// 03.03.27 //		LDA	!GDWTFG
;// 03.03.27 //		STA	>SLFGRM
;
		LDA	!CHARBK
		STA	>CHBKRM
		LDA	!CHIKNO
		STA	>CHNORM
		LDA	!RBGCPT
		STA	>RBGPRM
		LDA	!ROBJCPT
		STA	>ROJPRM
IIT3010		EQU	$
		MEM8
		SEP	#00100000B	; memory 8bit mode
;
		JSR	IIT2000		; initial RAM set
;
;
		PHB
		PHK
		PLB			; (DBR) set
;
		LDA	<RMXYCT
		PHA			; (A) push
		SEC
		SBC	#080H
		STA	<RMXYCT
		TAX
		LDA	>EPMKDT,X
		STA	<PLMKCH		; player muki set
		STZ	!CCHGPT
		LDA	>ROBJCDT,X
		STA	!ROBJCPT
		LDA	>RBGCDT,X
		STA	!RBGCPT		; reset OBJ,BG. character point set
		PHX			; (X) push
		LDA	>EOJCTBL,X
		STA	<WORK0		; (work0) <-- Obj. CG. pointer
		LDA	>ECGPTDT,X
		JSL	>GCGCHNG	; CG. reset
		PLX			; (X) pull
;
		MEM16
		IDX16
		REP	#00110000B	; memory,index 16bit mode
;
;// 03.03.25 //		TXA
;// 03.03.25 //		AND	#0003FH
;// 03.03.25 //		TAX
;// 03.03.25 //		LDA	>RMSZD0,X
;// 03.03.25 //		AND	#000FFH
;// 03.03.25 //		ASL	A
;// 03.03.25 //		TAX
;// 03.03.25 //		LDA	>RMYRPD,X
;// 03.03.25 //		STA	<WORK0
;// 03.03.25 //		LDA	>RMXRPD,X
;// 03.03.25 //		STA	<WORK2
		LDA	#003F0H
		STA	<WORK0
;
;
		LDA	<RMXYCT
		AND	#0003FH
		ASL	A
		TAX
		LDA	>GCCKYD,X
		STA	!GCCKY0
		LDA	>GCCKXD,X
		LSR	A
		LSR	A
		LSR	A
		STA	!GCCKX0
;
		LDA	<WORK0
		STA	!GCCKY1
;// 03.03.25 //		LDA	<WORK2
		LDA	<WORK0
		LSR	A
		LSR	A
		LSR	A
		STA	!GCCKX1
;
;
		LDA	<RMXYCT
		ASL	A
		TAY
;
		IDX8
		SEP	#00010000B	; index 8bit mode
;
		LDA	SCVU0DT,Y
		STA	!SCVU+0
		LDA	SCVU1DT,Y
		STA	!SCVU+2
		LDA	SCHU0DT,Y
		STA	!SCVU+4
		LDA	SCHU1DT,Y
		STA	!SCVU+6
;
		LDA	SCKY0DT,Y
		STA	!SCKY00
		LDA	SCKY1DT,Y
		STA	!SCKY10
		LDA	SCKX0DT,Y
		STA	!SCKX00
		LDA	SCKX1DT,Y
		STA	!SCKX10
;
		MEM8
		SEP	#00100000B	; memory 8bit mode
;
		PLA			; (A) pull
		STA	<RMXYCT
;
		PLB			; (DBR) reset
;
		JSL	>NKCGST1	; nuki CG. set
;
		JSR	IIT1100		; map point check
		RTS
;
;
;
;
;************************************************************************
;*		Initial RAM  set  [Event --> Ground]	(IIT4000)	*
;************************************************************************
IIT4000		EQU	$
		MEM16
		REP	#00100000B	; memory 16bit mode
;
		STZ	!GDMMPT		; ground memory buffer pointer clear
;
		LDA	>GRNORM
		STA	!GRNDNO		; grond no. pull
;
		LDA	>DPMSRM
		STA	<DPMAIN		; DPMAIN,DPSUB pull
;
		LDA	>SCV2RM
		STA	<SCCV1
		STA	<SCCV2
		STA	!SSCCV2
		STA	!SSCCV1
		LDA	>SCH2RM
		STA	<SCCH1
		STA	<SCCH2		; SCCH,V pull
		STA	!SSCCH2
		STA	!SSCCH1
;
		LDA	>PLYPRM
		STA	<PLYPS1
;// 03.04.02 //		AND	#0000FH
;// 03.04.02 //		STA	!DWSLCT
;// 03.04.02 //		ORA	#0FFF0H
;// 03.04.02 //		STA	!UPSLCT
		LDA	>PLXPRM
		STA	<PLXPS1		; Ground position pull
;// 03.04.02 //		AND	#0000FH
;// 03.04.02 //		STA	!RTSLCT
;// 03.04.02 //		ORA	#0FFF0H
;// 03.04.02 //		STA	!LFSLCT
;
		LDA	>MPDNRM
		STA	<MPDTNO
		LDA	>SRPTRM
		STA	<SCRPNT		; Ground information pull
		SEC
		SBC	#00400H
		AND	#00F80H
		ASL	A
		XBA
		STA	<YWRITE
		LDA	<SCRPNT
		SEC
		SBC	#00010H
		AND	#0003EH
		LSR	A
		STA	<XWRITE
;
		LDA	>UPCTRM
		STA	!PYUPCT
		DEC	A
		DEC	A
		STA	!PYDWCT
		LDA	>LFCTRM
		STA	!PXLFCT
		DEC	A
		DEC	A
		STA	!PXRTCT		; up,dwon,left,right check counter pull
;
;
		LDA	>SCVURM+0
		STA	!SCVU+0
		LDA	>SCVURM+2
		STA	!SCVU+2
		LDA	>SCVURM+4
		STA	!SCVU+4
		LDA	>SCVURM+6
		STA	!SCVU+6
;
		LDA	>SCKYRM+0
		STA	!SCKY00
		LDA	>SCKYRM+2
		STA	!SCKY10
		LDA	>SCKXRM+0
		STA	!SCKX00
		LDA	>SCKXRM+2
		STA	!SCKX10		; scroll end check data init. set
;
		LDA	>USCTRM
		STA	!UPSLCT
		LDA	>DSCTRM
		STA	!DWSLCT
		LDA	>LSCTRM
		STA	!LFSLCT
		LDA	>RSCTRM
		STA	!RTSLCT
;
		MEM8
		SEP	#00100000B	; memory 8bit mode
;
;// 03.03.27 //		LDA	>SLFGRM
;// 03.03.27 //		STA	!GDWTFG
;// 03.03.27 //		STZ	!GDWTFG
;// 03.03.27 //		LDX	#004H
;// 03.03.27 //IIT4040		EQU	$
;// 03.03.27 //		DEX
;// 03.03.27 //		LSR	A
;// 03.03.27 //		BCC	IIT4040		;
;// 03.03.27 //;					;
;// 03.03.27 //		STX	!SCRLFG
;// 03.03.27 //		STX	!GATMFG
;
		LDA	>CHBKRM
		STA	!CHARBK
		LDA	>CHNORM
		STA	!CHIKNO
		LDA	>RBGPRM
		STA	!RBGCPT
		LDA	>ROJPRM
		STA	!ROBJCPT
		LDX	<MPDTNO
		LDA	>ROJCTBL,X
		STA	<WORK0		; (work0) <-- Obj. CG. pointer
		LDA	>CGPTDT,X
		JSL	>GCGCHNG	; CG. reset
		JSL	>NKCGST1	; nuki CG. set
;
		STZ	<RMXCPT
		LDA	#002H
		STA	<RMYCPT
		STA	<RMCKXF
		STA	<RMCKYF
;
		LDA	#080H
		STA	<KNCRXP
		STA	<KNCRYP
		LDA	#00FH
		STA	<PLMVKY		; Y player move key flag
		STA	<PLMVKY1	; X
		LDA	#0FFH
		STA	<PLZPS1
		STA	<PLZSPD
;
		MEM8
		IDX8
		SEP	#00110000B	; memory,index 8bit mode
;
		JSL	>SWSPCL1	; swimming flag clear
;
		JSR	GDMCK800	; information ram set
		LDA	#0E4H
		STA	!GRMSZ1
		STZ	!GRMSZ0+1
		RTS
;
;
;
;
;************************************************************************
;*		Initial RAM  set  [Warp]		(IIT5000)	*
;************************************************************************
;// 03.05.10 //WDPMSRM		EQU	$		; (DPMAIN,DPSUB)
;// 03.05.10 //		WORD	00016H,00016H,00016H,00016H,00016H,00016H,00016H,00016H
WSCCVRM		EQU	$		; (SCCV2,SCCV1)
		WORD	002CAH,0025BH,00669H,0086BH,00920H,00F20H,00C17H,00EDFH
WSCCHRM		EQU	$		; (SCCH2,SCCH1)
		WORD    0060EH,00EBAH,00230H,0078EH,00C16H,00000H,00E2AH,006F2H
WPLYPRM		EQU	$		; (PLYPS1)
		WORD	00328H,002BDH,006C7H,008C9H,009B6H,00FACH,00C75H,00F3DH
WPLXPRM		EQU	$		; (PLXPS1)
		WORD	00678H,00F28H,002B8H,007F8H,00C80H,00076H,00E98H,00778H
WUPCTRM		EQU	$		; (PYUPCT)
		WORD	00337H,002C8H,006D6H,008D8H,0098DH,00F8DH,00C84H,00F4CH
WLFCTRM		EQU	$		; (PXLFCT)
		WORD	00683H,00F2FH,002BDH,00803H,00C8BH,0008DH,00E9FH,0077FH
WMPDNRM		EQU	$		; (MPDTNO)
		WORD	00003H,0000FH,00018H,0001BH,0001EH,00030H,00037H,0003BH
WSRPTRM		EQU	$		; (SCRPNT)
		WORD	01600H,00216H,00346H,01332H,01802H,01800H,00084H,0069EH
WUPSCRM		EQU	$		; (UPSLCT)
		WORD	0FFF6H,00005H,0FFF7H,0FFF5H,00000H,00000H,0FFF9H,0FFF1H
WLFSCRM		EQU	$		; (LFSLCT)
		WORD	0FFF2H,0FFF6H,0FFFBH,00002H,0FFFAH,00000H,0FFF6H,0FFFEH
;
;
IIT5000		EQU	$
		PHB
		PHK
		PLB			; (DBR) set
;
		MEM16
		REP	#00100000B	; memory 16bit mode
;
		STZ	!GDMMPT		; ground memory buffer pointer clear
;
		ASL	!MEMSTT
		LDX	!MEMSTT
;// 03.05.10 //		LDA	WDPMSRM,X
;// 03.05.10 //		STA	<DPMAIN		; DPMAIN,DPSUB pull
;
		LDA	WSCCVRM,X
		STA	<SCCV1
		STA	<SCCV2
		STA	!SSCCV2
		STA	!SSCCV1
		LDA	WSCCHRM,X
		STA	<SCCH1
		STA	<SCCH2		; SCCH,V pull
		STA	!SSCCH2
		STA	!SSCCH1
;
		LDA	WPLYPRM,X
		STA	<PLYPS1
		LDA	WPLXPRM,X
		STA	<PLXPS1		; Ground position pull
;
		LDA	WUPSCRM,X
		STA	!UPSLCT
		LDA	#00000H
		SEC
		SBC	!UPSLCT
		STA	!DWSLCT
		LDA	WLFSCRM,X
		STA	!LFSLCT
		LDA	#00000H
		SEC
		SBC	!LFSLCT
		STA	!RTSLCT
;
		LDA	WMPDNRM,X
		STA	<MPDTNO
		STA	!GRNDNO
		LDA	WSRPTRM,X
		STA	<SCRPNT		; Ground information pull
		SEC
		SBC	#00400H
		AND	#00F80H
		ASL	A
		XBA
		STA	<YWRITE
		LDA	<SCRPNT
		SEC
		SBC	#00010H
		AND	#0003EH
		LSR	A
		STA	<XWRITE
;
		LDA	WUPCTRM,X
		STA	!PYUPCT
;// 03.02.01 //		LDA	DDWCTRM,X
		DEC	A
		DEC	A
		STA	!PYDWCT
		LDA	WLFCTRM,X
		STA	!PXLFCT
;// 03.02.01 //		LDA	DRTCTRM,X
		DEC	A
		DEC	A
		STA	!PXRTCT		; up,dwon,left,right check counter pull
;
		STZ	!GDRBF0
		STZ	!GDRBF1
;
		PLB			; (DBR) reset
		JSR	IIT250		;
;
		JSR	INCLST1
		LDX	<MPDTNO
		LDA	>ROJCTBL,X
		STA	<WORK0
		LDA	>CGPTDT,X
		JSL	>GCGCHNG	; ground cg. set
		JSL	>NKCGST0	; nuki
;
		JSR	CGWKST		; (CGWORK) set
;
		JSL	>ALCLER		; enemy clear
		JSL	>GREDS2		; ground enemy set
;
		STZ	<PWORK6
		JSR	PFLGCL		; player flag clear
		RTL
;
;
;
;
;
;***************************** GROUND ***********************************
;************************************************************************
;*		data o >GDBUF0 & >GDBUF1 ni okuru			*
;************************************************************************
MPTOGD		EQU	$
		MEM16
		IDX16
		REP	#00110000B
;
		JSR	MPCNG
;
		LDX	#0001EH
		LDA	#betaut
MPG40		EQU	$
		STA	>GDBUF2+000H,X
		STA	>GDBUF2+020H,X
		STA	>GDBUF2+020H,X
		STA	>GDBUF2+040H,X
		STA	>GDBUF2+060H,X
		DEX
		DEX
		BPL	MPG40		;
;					;
		LDX	!GDRBF0
		BEQ	MPG200		; door open ?
;					; yes
		CPX	#0FFFFH
		BEQ	MPG200		;
;					;
		CPX	#08000H
		BCS	MPG80		;
;					;
		LDA	#drut0
		STA	>GDBUF0,X
		LDA	#drut1
		BRA	MPG100
;
MPG80		EQU	$
		TXA
		AND	#01FFFH
		TAX
		LDA	#drutE
		STA	>GDBUF0,X
		LDA	#drutF
MPG100		EQU	$
		STA	>GDBUF0+2,X
		STZ	!GDRBF0
MPG200		EQU	$
		MEM8
		IDX8
		SEP	#00110000B
;
		LDX	<MPDTNO
		LDA	>GNDTBL,X
		AND	#00100000B
		BEQ	MPG400		; shikake on ?
;					; yes
		MEM16
		IDX16
		REP	#00110000B	; memory,index 16bit mode
;
		LDA	<MPDTNO
		ASL	A
		TAX
		JSR	(GOPTNDT,X)
;
		MEM8
		IDX8
		SEP	#00110000B
MPG400		EQU	$
		RTS
;
;
;
MPINT0		EQU	$
		JSR	MPTOGD
;
;// 03.05.23 //		MEM16
;// 03.05.23 //		REP	#00100000B	; memory 16bit mode
;// 03.05.23 //;
;// 03.05.23 //		LDA	#0FFFFH
;// 03.05.23 //		STA	<CWORK0
;// 03.05.23 //		STZ	<CWORK2
;// 03.05.23 //		STZ	<CWORK4
;// 03.05.23 //;
;// 03.05.23 //		MEM8
;// 03.05.23 //		SEP	#00100000B	; memory 8bit mode
;
		STZ	<CWORK4
		STZ	<CWORK4+1
		JSR	MPALST		; ground all write
;
		LDA	#bgw4
		STA	<BGWTFG
		STA	!GMAPDF
;
                LDA     #MD_wpin
                STA     <SLMODE
                STZ     <JRSBPT
		STZ	<GAMEMD
		RTS
;
;
;
;
;
;
;
MPBGUP		EQU	$		;matomete ? retu kaku
                MEM8
                IDX8
                SEP     #00110000B
;
                LDA     #08H
                STA     !GDWTFG
;
		LDA	#bgw3
		STA	<BGWTFG
;
                MEM16
                IDX16
                REP     #00110000B
;
		LDY	<WORK+14
		LDA	#0007FH		;]VRAMD+4 ni kosuu(007F) o set
;// 02.12.25 //		STA	VRAMD+2,Y	;]
;// 03.02.06 //		STA	!RWBUFF,Y	;]
		STA	!BGCWBF,Y
		INY
		INY
		STY	<WORK+14
MPBGUP1         EQU     $
		JSR	MPUDLN		;ue(sita) no BG o kaku
;
		LDA	<SCRPNT		;]
		SEC			; ]SCRPNT=SCRPNT-64
		SBC	#0128		; ]gamen no kihonten
		STA	<SCRPNT		;]
;
		LDA	<YWRITE		;]
		DEC	A		; ]unit tani no tate no iti
		AND	#001FH		; ]
		STA	<YWRITE		;]
;
		DEC	<WORK+8
		BNE	MPBGUP1
;
		LDA	#0FFFFH
		LDX	<WORK+14
;// 02.12.25 //		STA	VRAMD+2,X
;// 03.02.06 //		STA	!RWBUFF,X
		STA	!BGCWBF,X
		RTS
;
;
MPBGLF		EQU	$		;matomete ? retu kaku
		MEM8
		IDX8
		SEP	#00110000B
;
                LDA     #02H
                STA     !GDWTFG
;
		LDA	#bgw3
		STA	<BGWTFG
;
		MEM16
		IDX16
		REP	#00110000B
;
		LDY	<WORK+14
		LDA	#0803FH		;]BG no kosu set 803F
;// 02.12.25 //		STA	VRAMD+2,Y	;]		 tate kosuu
;// 03.02.06 //		STA	!RWBUFF,Y	;]		 tate kosuu
		STA	!BGCWBF,Y
		INY
		INY
		STY	<WORK+14
MPBGLF1		EQU	$
		JSR	MPRLLN		;yoko no BG o kaku
;
		DEC	<SCRPNT		; ]SCRPNT=SCRPNT-2
		DEC	<SCRPNT		; ]gamen no kihonten
;
		LDA	<XWRITE		;]
		DEC	A		; ]unit tani no yoko no iti
		AND	#001FH		; ]
		STA	<XWRITE		;]
;
		DEC	<WORK+8
		BNE	MPBGLF1
;
		LDA	#0FFFFH
		LDX	<WORK+14
;// 02.12.25 //		STA	VRAMD+2,X
;// 03.02.06 //		STA	!RWBUFF,X
		STA	!BGCWBF,X
		RTS
;
;
;
;************************************************************************
;*              map o kaeru			                        *
;************************************************************************
GNXBGWT		EQU	$
                MEM16
                IDX16
                REP     #00110000B
;
                JSR     MPCNG           ;data no tensou
;
		LDX	#0001EH
		LDA	#betaut
GNXBW20		EQU	$
		STA	>GDBUF2+000H,X
		STA	>GDBUF2+020H,X
		STA	>GDBUF2+040H,X
		STA	>GDBUF2+060H,X
		DEX
		DEX
		BPL	GNXBW20		;
;					;
                MEM8
                IDX8
                SEP     #00110000B
;
		LDX	<MPDTNO
		LDA	>GNDTBL,X
		AND	#00100000B
		BEQ	GNXBW40		; shikake on ?
;					; yes
		MEM16
		IDX16
		REP	#00110000B	; memory,index 16bit mode
;
		LDA	<MPDTNO
		ASL	A
		TAX
		JSR	(GOPTNDT,X)
;
		MEM8
		IDX8
		SEP	#00110000B
GNXBW40		EQU	$
		INC	<GAMEMD		;MPSUBx1CALL ni iku
                RTS

;
;
;
;************************************************************************
;*		map o kaetatoki ni saisyo ni kaku			*
;************************************************************************
WTVRTBL		EQU	$
                WORD    MPTFG0		;0
                WORD    WTVRAM4		;1 (R)
                WORD    WTVRAM3		;2 (L)
                WORD    MPTFG0		;3
                WORD    WTVRAM2		;4 (D)
                WORD    MPTFG0		;5
                WORD    MPTFG0		;6
                WORD    MPTFG0		;7
                WORD    WTVRAM1		;8 (U)
;
;
WTVRAM		EQU	$
		MEM8
		IDX8
		SEP	#00110000B
;
                LDA     !GDWTFG
		ASL	A
		TAX
		JMP	(WTVRTBL,X)
;
;
;
;
WTVRAM1         EQU     $		;ue
                MEM16
                IDX16
                REP     #00110000B
;
                LDA     <SCRPNT         ;SCRPNT + 2380H
                CLC
                ADC     #0380H
                STA     <SCRPNT
;
                LDA     <YWRITE         ;Y no BG o kaku ichi
                CLC
                ADC     #0007H
                AND     #001FH
                STA     <YWRITE
;
                STZ     <WORK+14        ;VRAMD+2,? ? o cls
;
                LDA     #0007H          ;nanretu BG o kakuka
                STA     <WORK+8
;
                JSR     MPBGUP          ;BG o ue ni kaku
;
                MEM8
                IDX8
                SEP     #00110000B
                RTS

;
;
;
;
WTVRAM2         EQU     $		;sita
                MEM16
                IDX16
                REP     #00110000B
;
		LDA	<SCRPNT		
WTVRAM21	EQU	$
		CMP	#0080H
		BCC	WTVRAM22
		SBC	#0080H
		BRA	WTVRAM21
WTVRAM22	EQU	$
                CLC
                ADC     #0780H
                STA     <SCRPNT
;
                STZ     <WORK+14        ;VRAMD+2,? ? o cls
		LDA	#007H
                STA     <YWRITE
;
                LDA     #0008H          ;nanretu BG o kakuka
                STA     <WORK+8
;
                JSR     MPBGUP          ;BG o ue ni kaku
;
                LDA     <YWRITE         ;Y no BG o kaku ichi
                CLC
                ADC     #0009H
                AND     #001FH
                STA     <YWRITE
;
                LDA     <SCRPNT         ;SCRPNT += B80H
                SEC
                SBC     #0B80H
                STA     <SCRPNT
;
                MEM8
                IDX8
                SEP     #00110000B
;
                RTS
;
;
;
;
WTVRAM3         EQU     $		;hidari
                MEM16
                IDX16
                REP     #00110000B
;
                LDA     <SCRPNT         ;SCRPNT + 8EH
                CLC
                ADC     #000EH
                STA     <SCRPNT
;
                LDA     <XWRITE         ;Y no BG o kaku ichi
                CLC
                ADC     #0007H
                AND     #001FH
                STA     <XWRITE
;
                STZ     <WORK+14        ;VRAMD+2,? ? o cls
;
                LDA     #0007H          ;nanretu BG o kakuka
                STA     <WORK+8
;
                JSR     MPBGLF          ;BG o ue ni kaku
;
                MEM8
                IDX8
                SEP     #00110000B
;
                RTS
;
;
;
;
WTVRAM4         EQU     $		;migi
                MEM16
                IDX16
                REP     #00110000B
;
                LDA     <SCRPNT         ;SCRPNT - 40H + 1EH
                SEC
                SBC     #0060H
                CLC
                ADC     #001EH
                STA     <SCRPNT
;
                STZ     <WORK+14        ;VRAMD+2,? ? o cls
;
                LDA     <XWRITE         ;Y no BG o kaku ichi
                DEC     A
                AND     #001FH
                STA     <XWRITE
;
                LDA     #0008H          ;nanretu BG o kakuka
                STA     <WORK+8
;
                JSR     MPBGLF          ;BG o ue ni kaku
;
                LDA     <XWRITE         ;Y no BG o kaku ichi
                CLC
                ADC     #0009H
                AND     #001FH
                STA     <XWRITE
;
                LDA     <SCRPNT         ;SCRPNT -= 2EH
                SEC
                SBC     #002EH
                STA     <SCRPNT
;
                MEM8
                IDX8
                SEP     #00110000B
;
                RTS
;
;
;
;
;************************************************************************
;*              sukuroru                                                 *
;************************************************************************
GSLBTBL		EQU	$
                WORD    MPTFG0          ;0
                WORD    MPSUB42         ;1 (R)
                WORD    MPSUB32         ;2 (L)
                WORD    MPTFG0          ;3
                WORD    MPSUB22         ;4 (D)
                WORD    MPTFG0          ;5
                WORD    MPTFG0          ;6
                WORD    MPTFG0          ;7
                WORD    MPSUB12         ;8 (U)
;
;
GSLBGWT		EQU	$
                MEM8
                IDX8
                SEP     #00110000B
;
                LDA     !GDWTFG
		ASL	A
		TAX
		JMP	(GSLBTBL,X)
;
;
;
;
MPSUB12         EQU     $
                MEM16
                IDX16
                REP     #00110000B
;
                STZ     <WORK+14
;
;// 03.02.04 //		LDY	<WORK+14
;// 03.02.04 //		LDA	#0007FH		;]VRAMD+4 ni kosuu(007F) o set
;// 03.02.04 //		STA	!WBGBUF,Y
;// 03.02.04 //		INY
;// 03.02.04 //		INY
;// 03.02.04 //		STY	<WORK+14
;// 03.02.04 //;
;// 03.02.04 //                JSR     MPUDLN          ;ue(sita) no BG o kaku
;// 03.02.04 //;
;// 03.02.04 //                LDA     <SCRPNT         ;]
;// 03.02.04 //                SEC                     ; ]SCRPNT=SCRPNT-64(unit)
;// 03.02.04 //                SBC     #0128           ; ]gamen no kihonten
;// 03.02.04 //                STA     <SCRPNT         ;]
;// 03.02.04 //;
;// 03.02.04 //                LDA     <YWRITE         ;]
;// 03.02.04 //                DEC     A               ; ]unit tani no tate no iti
;// 03.02.04 //                AND     #001FH          ; ]
;// 03.02.04 //                STA     <YWRITE         ;]
		JSR	MPUP0
MPSUBEXT	EQU	$
                LDY     <WORK+14        ;VRAMD+2,Y ni #0FFFFH(END) o kaku
                LDA     #0FFFFH         ;
;// 02.12.25 //                STA     VRAMD+2,Y       ;
;// 03.02.06 //                STA     !RWBUFF,Y       ;
		STA	!BGCWBF,Y
;// 02.12.25 //                STA     VRAMD+4,Y       ;
;// 03.02.06 //                STA     !RWBUFF+2,Y       ;
		STA	!BGCWBF+2,Y
		CPY	#00000H
		BEQ	MPSUBEXT2
;
                MEM8
                IDX8
                SEP     #00110000B
;
		LDA	#bgw3
		STA	<BGWTFG
MPSUBEXT2	EQU	$
		SEP	#00110000B
                RTS
;
;
;
;
MPSUB22         EQU     $
                MEM16
                IDX16
                REP     #00110000B
;
                STZ     <WORK+14
;
;// 03.02.04 //		LDY	<WORK+14
;// 03.02.04 //		LDA	#0007FH		;]VRAMD+4 ni kosuu(007F) o set
;// 03.02.04 //		STA	!WBGBUF,Y
;// 03.02.04 //		INY
;// 03.02.04 //		INY
;// 03.02.04 //		STY	<WORK+14
;// 03.02.04 //;
;// 03.02.04 //                JSR     MPUDLN          ;ue(sita) no BG o kaku
;// 03.02.04 //;
;// 03.02.04 //                LDA     <SCRPNT         ;]
;// 03.02.04 //                CLC                     ; ]SCRPNT=SCRPNT+64(unit)
;// 03.02.04 //                ADC     #0128           ; ]
;// 03.02.04 //                STA     <SCRPNT         ;]
;// 03.02.04 //;
;// 03.02.04 //                LDA     <YWRITE         ;]
;// 03.02.04 //                INC     A               ; ]unit tani no tate no iti
;// 03.02.04 //                AND     #001FH          ; ]
;// 03.02.04 //                STA     <YWRITE         ;]
;
		JSR	MPDOWN0
;
		BRA	MPSUBEXT
;
;
;
;
MPSUB32         EQU     $
                MEM16
                IDX16
                REP     #00110000B
;
                STZ     <WORK+14
;
;// 03.02.04 //		LDY	<WORK+14
;// 03.02.04 //		LDA	#0803FH		;]BG no kosu set 803F
;// 03.02.04 //		STA	!WBGBUF,Y
;// 03.02.04 //		INY
;// 03.02.04 //		INY
;// 03.02.04 //		STY	<WORK+14
;// 03.02.04 //;
;// 03.02.04 //                JSR     MPRLLN          ;hidari(migi) no BG o kaku
;// 03.02.04 //;
;// 03.02.04 //                DEC     <SCRPNT         ;]SCRPNT=SCRPNT-1(unit)
;// 03.02.04 //                DEC     <SCRPNT         ;]
;// 03.02.04 //;
;// 03.02.04 //                LDA     <XWRITE         ;]
;// 03.02.04 //                DEC     A               ; ]unit tani no yoko no iti
;// 03.02.04 //                AND     #001FH          ; ]
;// 03.02.04 //                STA     <XWRITE         ;]
;
		JSR	MPLEFT0
;
		BRA	MPSUBEXT
;
;
;
;
MPSUB42         EQU     $
                MEM16
                IDX16
                REP     #00110000B
;
                STZ     <WORK+14
;
;// 03.02.04 //		LDY	<WORK+14
;// 03.02.04 //		LDA	#0803FH		;]BG no kosu set 803F
;// 03.02.04 //		STA	!WBGBUF,Y
;// 03.02.04 //		INY
;// 03.02.04 //		INY
;// 03.02.04 //		STY	<WORK+14
;// 03.02.04 //;
;// 03.02.04 //                JSR     MPRLLN          ;hidari(migi) no BG o kaku
;// 03.02.04 //;
;// 03.02.04 //                INC     <SCRPNT         ;]SCRPNT=SCRPNT+1(unit)
;// 03.02.04 //                INC     <SCRPNT         ;]
;// 03.02.04 //;
;// 03.02.04 //                LDA     <XWRITE         ;]
;// 03.02.04 //                INC     A               ; ]unit tani no yoko no iti
;// 03.02.04 //                AND     #001FH          ; ]
;// 03.02.04 //                STA     <XWRITE         ;]
;
		JSR	MPRIGHT0
;
		BRA	MPSUBEXT
;
;
;
;
;************************************************************************
;*              hutuu ni BG o kaku                                      *
;************************************************************************
MPBWTBL		EQU	$
		WORD	MPTFG0
		WORD	MPTFG1
		WORD	MPTFG2
		WORD	MPTFG0
		WORD	MPTFG4
		WORD	MPTFG5
		WORD	MPTFG6
		WORD	MPTFG0
		WORD	MPTFG8
		WORD	MPTFG9
		WORD	MPTFGA
		WORD	MPTFG0
		WORD	MPTFG0
		WORD	MPTFG0
		WORD	MPTFG0
		WORD	MPTFG0
;
;
MPMAIN		EQU	$
MPBGWT		EQU	$
		MEM16
		IDX16
		REP	#00110000B
;
		STZ	<WORK+14
;
		MEM8
		IDX8
		SEP	#00110000B
;
		LDA	!GDWTFG
		ASL	A
		TAX
		JSR	(MPBWTBL,X)
;
		MEM16
		IDX16
		REP	#00110000B
;
		LDY	<WORK+14	;VRAMD+2,Y ni #0FFFFH(END) o kaku
		LDA	#0FFFFH		;
		STA	!BGCWBF,Y
		STA	!BGCWBF+2,Y
		CPY	#00000H
		BEQ	MPBGWT0		; write ?
;					; yes
		MEM8
		IDX8
		SEP	#00110000B
;
		LDA	#bgw3
		STA	<BGWTFG
MPBGWT0		EQU	$
		SEP	#00110000B	; memory,index 8bit mode
;
		LDA	!GDWTFG		;]GEWTFG o yokeru(test)
		STA	!SCRLFG		;]
		RTS
;
;
;
MPTFG0		EQU	$
		STZ	<GAMEMD
		RTS
;
MPTFG1		EQU	$
		JSR	MPRIGHT
		STZ	!GDWTFG		;doko ni kakuka no flg o cls
		RTS
;
MPTFG2		EQU	$
		JSR	MPLEFT
		STZ	!GDWTFG		;doko ni kakuka no flg o cls
		RTS
;
MPTFG4		EQU	$
		JSR	MPDOWN
		STZ	!GDWTFG		;doko ni kakuka no flg o cls
		RTS
;
MPTFG5		EQU	$
MPTFG6		EQU	$
;;;;;;;;		JSR	MPRIGHT
		JSR	MPDOWN
		SEP	#00110000B
		LDA	!GDWTFG
		AND	#003H
		STA	!GDWTFG		;doko ni kakuka no flg o cls
		RTS
;
;// 03.05.28 //MPTFG6		EQU	$
;// 03.05.28 //;;;;;;;;		JSR	MPLEFT
;// 03.05.28 //		JSR	MPDOWN
;// 03.05.28 //		SEP	#00110000B
;// 03.05.28 //		LDA	!GDWTFG
;// 03.05.28 //		AND	#003H
;// 03.05.28 //		STA	!GDWTFG		;doko ni kakuka no flg o cls
;// 03.05.28 //		RTS
;
MPTFG8		EQU	$
		JSR	MPUP
		STZ	!GDWTFG		;doko ni kakuka no flg o cls
		RTS
;
MPTFG9		EQU	$
MPTFGA		EQU	$
;;;;;;;;		JSR	MPRIGHT
		JSR	MPUP
		SEP	#00110000B
		LDA	!GDWTFG
		AND	#003H
		STA	!GDWTFG		;doko ni kakuka no flg o cls
		RTS
;
;// 03.05.28 //MPTFGA		EQU	$
;// 03.05.28 //;;;;;;;;		JSR	MPLEFT
;// 03.05.28 //		JSR	MPUP
;// 03.05.28 //		SEP	#00110000B
;// 03.05.28 //		LDA	!GDWTFG
;// 03.05.28 //		AND	#003H
;// 03.05.28 //		STA	!GDWTFG		;doko ni kakuka no flg o cls
;// 03.05.28 //		RTS
;
;
MPUP		EQU	$
		MEM16
		IDX16
		REP	#00110000B
;
		LDA	<SCRPNT		;]
		CMP	#0128		; ]
		BMI	MPUP1		;]gamen no ue o koeta ka?
;					;n
MPUP0		EQU	$
		LDY	<WORK+14
		LDA	#0007FH		;]VRAMD+4 ni kosuu(007F) o set
		STA	!BGCWBF,Y
		INY
		INY
		STY	<WORK+14
;
		JSR	MPUDLN		;ue(sita) no BG o kaku
;
		LDA	<SCRPNT		;]
		SEC			; ]SCRPNT=SCRPNT-64
		SBC	#0128		; ]gamen no kihonten
		STA	<SCRPNT		;]
;
		LDA	<YWRITE		;]
		DEC	A		; ]unit tani no tate no iti
		AND	#001FH		; ]
		STA	<YWRITE		;]
MPUP1		EQU	$
		RTS
;
;
MPSTPD		EQU	$
		WORD	01800H,01000H,00800H,00000H
MPDOWN		EQU	$
		MEM16
		IDX16
		REP	#00110000B
;
		LDX	<MPDTNO
		LDA	>MPSIZE,X
		AND	#000FFH
		ASL	A
		TAX
;
		LDA	<SCRPNT		;]
;		CMP	#0C00H		;		CMP	#1800H		; ]gamen no sita o koeta ka?
		CMP	>MPSTPD,X
		BCS	MPDOWN1		;]
;					;n
MPDOWN0		EQU	$
		LDY	<WORK+14
		LDA	#0007FH		;]VRAMD+4 ni kosuu(007F) o set
		STA	!BGCWBF,Y
		INY
		INY
		STY	<WORK+14
;
		JSR	MPUDLN		;ue(sita) no BG o kaku
;
		LDA	<SCRPNT		;]
		CLC			; ]SCRPNT=SCRPNT+64
		ADC	#0128		; ]
		STA	<SCRPNT		;]
;
		LDA	<YWRITE		;]
		INC	A		; ]unit tani no tate no iti
		AND	#001FH		; ]
		STA	<YWRITE		;]
MPDOWN1		EQU	$
		RTS
;
;
MPLEFT		EQU	$
		MEM16
		IDX16
		REP	#00110000B
;
		LDA	<SCRPNT		;]
MPLEFT1		EQU	$
		CMP	#0080H
		BCC	MPLEFT2
		SBC	#0080H
		BRA	MPLEFT1
MPLEFT2		EQU	$
		CMP	#00000H
		BEQ	MPLEFT3		; ]hidari hasi ka?
;					;n
MPLEFT0		EQU	$
		LDY	<WORK+14
		LDA	#0803FH		;]BG no kosu set 803F
		STA	!BGCWBF,Y
		INY
		INY
		STY	<WORK+14
;
		JSR	MPRLLN		;hidari(migi) no BG o kaku
;
		DEC	<SCRPNT		;]SCRPNT=SCRPNT-2
		DEC	<SCRPNT		;]
;
		LDA	<XWRITE		;]
		DEC	A		; ]unit tani no yoko no iti
		AND	#001FH		; ]
		STA	<XWRITE		;]
MPLEFT3		EQU	$
		RTS
;
;
MPSTPR		EQU	$
		WORD	00080H,00060H,00040H,00020H,00000H
MPRIGHT		EQU	$
		MEM16
		IDX16
		REP	#00110000B
;
		LDX	<MPDTNO
		LDA	>MPSIZE,X
		AND	#000FFH
		ASL	A
		TAX
;
		LDA	<SCRPNT		;]
MPRIGHT1	EQU	$
		CMP	>MPSTPR,X
		BCC	MPRIGHT2
		SBC	>MPSTPR,X
		BRA	MPRIGHT1
MPRIGHT2	EQU	$
;		CMP	#0040H		; ]migi hasi ka?
		CMP	>MPSTPR+2,X
		BCS	MPRIGHT3	;]
;					;n
MPRIGHT0	EQU	$
		LDY	<WORK+14
		LDA	#0803FH		;]BG no kosu set 803F
		STA	!BGCWBF,Y
		INY
		INY
		STY	<WORK+14
;
		JSR	MPRLLN		;hidari(migi) no BG o kaku
;
		INC	<SCRPNT		;]SCRPNT=SCRPNT+2
		INC	<SCRPNT		;]
;
		LDA	<XWRITE		;]
		INC	A		; ]unit tani no yoko no iti
		AND	#001FH		; ]
		STA	<XWRITE		;]
MPRIGHT3	EQU	$
		RTS
;
;
;************************************************************************
;*									*
;*		MAIN no SUB PROGRAM					*
;*					ALL 16 bit MODE			*
;************************************************************************
		MEM16
		IDX16
;
;************************************************************************
;*		left & right (#) ni BG o hiku	sub program		*
;******************************+*****************************************
MPRLLN		EQU	$
		LDA	!GDWTFG		;]]]
		AND	#0002H		;   ]key ga hidari ka migika o mite
		TAX			;   ]hidari SCRPNT-1040=Y
		LDA	<SCRPNT		;   ]migi   SCRPNT-976=Y
		SEC			;   ]
		SBC	>RLDATA,X	;   ] RLDATA 976,1040
		TAY
;
		LDA	<YWRITE		;]
		ASL	A		; ]X=YWRITE*2
		TAX			;]
;
		LDA	#GDBUF0
		STA	<WORK0
		LDA	#BANK GDBUF0	;// 02.12.10 //
		STA	<WORK2		;// 02.12.10 //
		LDA	#0032/2		;MPRLL1 o kurikaesu kaisu(1 retu no kazu)
		STA	<WORK+3
MPRLL1		EQU	$
		LDA	[<WORK],Y	;MPDATA --> map data
		STA	DATBUF,X	;DATBUF --> data o ireru toko
		INX
		INX
		TXA			;]
		AND	#003FH		; ]X>1F --> X=0 (0<=X<=1F)
		TAX			;]
		TYA
		CLC			; ]Y=Y+128
		ADC	#0128		; ]tate ni data o totekuru
		TAY
;
		LDA	[<WORK],Y	;MPDATA --> map data
		STA	DATBUF,X	;DATBUF --> data o ireru toko
		INX
		INX
		TXA			;]
		AND	#003FH		; ]X>1F --> X=0 (0<=X<=1F)
		TAX			;]
		TYA
		CLC			; ]Y=Y+128
		ADC	#0128		; ]tate ni data o totekuru
		TAY
		DEC	<WORK+3
		BNE	MPRLL1		;1 retu bun no data o DATBUF ni okutaka
;
		STZ	<WORK		;			]]]]]]   ________
		LDA	<XWRITE		;			      ]  |       |  
		STA	<WORK+2		;			      ]  +-------+
		CMP	#00016		;			      ]  ----+----
		BCC	MPRLL2		;tonari no gamen ka?	      ]  |   |   |
;					;y			      ]  +-------+
		AND	#000FH		;			      ]
		STA	<WORK+2		;			      ]
		LDA	#0400H		;			      ]
		STA	<WORK		;			]]]]]]
MPRLL2		EQU	$
		LDA	<WORK+2		;]]
		ASL	A		;  ]<WORK=<WORK+(<WORK+2)*4
		CLC			;  ]VRAM no adress keisan
		ADC	<WORK		;  ]
		STA	<WORK		;]]
		CLC			;]
		ADC	#0800H		; ]tonari no gamen no adress keisan
		STA	<WORK+12	;]
;
		LDA	>MPDBUF+0	;    ]
		JSR	SMPLINE
;
		LDA	<WORK+12	;]
		STA	<WORK		; ]yokete oita 2 gamen me no adress o work ni okuru
		LDA	>MPDBUF+2	;    ]
;
;************************************************************************
;*		32 no BG o kaku				sub program	*
;************************************************************************
SMPLINE		EQU	$
		STA	<WORK+2
;
		LDY	<WORK+14	;VRAMD+2,Y no Y
		LDA	<WORK		;](VRAMD+2,Y)=<WORK+(<WORK+4)
		STA	!BGCWBF,Y
		INC	A
		STA	!BGCWBF+042H,Y
		INY
		INY
;
		LDA	#00032/2
		STA	<WORK6
SMPLIN1		EQU	$
		LDX	<WORK+2		;    ]
		LDA	DATBUF,X	;    ]
		INX			;DATBUF,Y no Y o tugini susumeru
		INX			;(tigi no unit)
		STX	<WORK+2
		ASL	A		;    ]
		ASL	A		;    ]
		ASL	A		;    ]X=(DATBUF,Y)*4+(<WORK+4)
		TAX			;]]]]
;
		LDA	>MPUNIT+0,X	;
		STA	!BGCWBF+00H,Y
		LDA	>MPUNIT+2,X	;
		STA	!BGCWBF+42H,Y
		INY			;VRAMD+6,Y no Y o tugini suru
		INY			;
		LDA	>MPUNIT+4,X		;
		STA	!BGCWBF+00H,Y
		LDA	>MPUNIT+6,X		;
		STA	!BGCWBF+42H,Y
		INY			;VRAMD+6,Y no Y o tugini suru
		INY			;
;
		DEC	<WORK+6
		BNE	SMPLIN1		; 1retu end ?
;					; y
		TYA
		CLC
		ADC	#00042H
		STA	<WORK+14
		RTS
;
;
;
;************************************************************************
;*		up & down (######ni BG o hiku	sub program	*
;************************************************************************
MPUDLN		EQU	$
		LDA	!GDWTFG		;]]]
		AND	#0004H		;   ]
		LSR	A		;   ]
		TAX			;   ] key no ue ka sitaka o mite
		LDA	<SCRPNT		;   ] ue   nara SCRPNT-1040=Y
		SEC			;   ] sita nara SCRPNT+3056=Y
		SBC	>UDDATA,X	;   ] UDDATA 1040,3056(F410)
		TAY
;
		LDA	<XWRITE		;]
		ASL	A		; ]X=XWRITE*2
		TAX			;]
;
		LDA	#GDBUF0
		STA	<WORK0
		LDA	#BANK GDBUF0	;// 02.12.10 //
		STA	<WORK2		;// 02.12.10 //
		LDA	#0032/2		;MPUDL1 o kurikaesu kaisu(1 retu no kazu)
		STA	<WORK+3
MPUDL1		EQU	$
		LDA	[<WORK],Y	;<WORK L,H,B --> map data
		STA	DATBUF,X	;DATBUF --> data o ireru toko
		INX
		INX
		TXA			;]
		AND	#003FH	 	; ]X>1F -->X=0 (0<=X<=1F)
		TAX			;]
		INY
		INY
;
		LDA	[<WORK],Y	;<WORK L,H,B --> map data
		STA	DATBUF,X	;DATBUF --> data o ireru toko
		INX
		INX
		TXA			;]
		AND	#003FH	 	; ]X>1F -->X=0 (0<=X<=1F)
		TAX			;]
		INY
		INY
		DEC	<WORK+3
		BNE	MPUDL1		;1 retu bun no data o DATBUF ni iretaka?
;					;y
		STZ	<WORK0		;// 02.12.10 //
		LDA	<YWRITE		;			    ] |-----------
		STA	<WORK+2		;			    ] |          |
		CMP	#00016		;			    ] +-----+    |
		BCC	MPUDL2		;tonarino gamenka?	    ] |  |  |    |--dotiraka no adress o moto meru
;					;y
		AND	#000FH		;			    ] |~~|~~|    |
		STA	<WORK+2		;			    ] +-----+    |
		LDA	#0800H		;			    ] |          |
		STA	<WORK		;			]]]]  -----------|
MPUDL2		EQU	$		;]]]
		LDA	<WORK+2		;   ]
		ASL	A		;   ]<WORK=<WORK+(work+2)*64
		ASL	A		;   ]
		ASL	A		;   ]
		ASL	A		;   ]
		ASL	A		;   ]
		ASL	A		;   ]
		CLC			;   ]
		ADC	<WORK		;   ]
		STA	<WORK		;]]]
;
		CLC			;]
		ADC	#0400H		; ]<WORK=<WORK+0400H
		STA	<WORK+12	;]
;
		LDY	<WORK+14	;VRAMD+2,Y no Y
		LDA	<WORK		;]
		STA	!BGCWBF,Y
		INY
		INY
		LDA	>MPDBUF+0	;    ]
		JSR	LMPLINE
;
		LDY	<WORK+14	;VRAMD+2,Y no Y
		LDA	<WORK+12	;]
		STA	!BGCWBF,Y
		INY
		INY
		LDA	>MPDBUF+2	;    ]
;
;************************************************************************
;*		32 no BG o kaku				sub program	*
;************************************************************************
LMPLINE		EQU	$
		STA	<WORK+2
;
		LDA	#0032/2
		STA	<WORK6
LMPLIN1		EQU	$
		LDX	<WORK+2		;    ]
		LDA	DATBUF,X	;    ]
		INX			;DATBUF,Y no Y o tugini susumeru
		INX			;(tigi no unit)
		STX	<WORK+2
		ASL	A		;    ]
		ASL	A		;    ]
		ASL	A		;    ]X=(DATBUF,Y)*4+(<WORK+4)
		TAX			;]]]]
;
		LDA	>MPUNIT,X	;
		STA	!BGCWBF+00H,Y
		LDA	>MPUNIT+4,X	;
		STA	!BGCWBF+40H,Y
		INY			;VRAMD+6,Y no Y o tugini suru
		INY			;
		LDA	>MPUNIT+2,X		;
		STA	!BGCWBF+00H,Y
		LDA	>MPUNIT+6,X		;
		STA	!BGCWBF+40H,Y
		INY			;VRAMD+6,Y no Y o tugini suru
		INY			;
;
		DEC	<WORK+6
		BNE	LMPLIN1		; 1retu end ?
;					; y
		TYA
		CLC
		ADC	#00040H
		STA	<WORK+14	;VRAMD+2,Y no Y
		RTS
;
;
;
;
;
;************************************************************************
;*		GDBUF0 to GDBUF1 no data o kaeru			*
;************************************************************************
MPCNG		EQU	$
		LDA	<MPDTNO		;]
		ASL	A		; ]X=MPDTNO*3
		ADC	<MPDTNO		; ]
		TAX			;]
		LDA	#BANK GDBUF0	; ]
		STA	<WORK+2		; ]WORK   +1 +2 ni GDBUF0 no L H B 
                STA     <WORK+5		; ]WORK+3 +4 +5 ni GDBUF0+128 no L H B
		LDA	#GDBUF0		;]
;// 03.02.04 //		STA	<WORK		; ]
;// 03.02.04 //		CLC			; ]           o set
;// 03.02.04 //		ADC	#0080H		; ]
;// 03.02.04 //		STA	<WORK+3		;]
;// 03.02.04 //                LDA     >MPTBLDT,X      ;]
;// 03.02.04 //		STA	<WORK+8		; ]WORK+8 +9 +10 ni MPDAT L H B o set
;// 03.02.04 //		LDA	>MPTBLDT+1,X	; ]
;// 03.02.04 //		STA	<WORK+9		;]
;// 03.02.04 //		JSR	MPCNG1		;data no tenkai
		JSR	MPCNG0		;data no tenkai
;
;
                LDA     <MPDTNO         ;]
		INC	A
		STA	<WORK
                ASL     A               ; ]X=MPDTNO*3
                ADC     <WORK	         ; ]
                TAX                     ;]
                LDA     #GDBUF0         ;]
		CLC
		ADC	#0040H
;// 03.02.04 //                STA     <WORK           ; ]
;// 03.02.04 //                CLC                     ; ]           o set
;// 03.02.04 //                ADC     #0080H          ; ]
;// 03.02.04 //                STA     <WORK+3         ;]
;// 03.02.04 //                LDA     >MPTBLDT,X      ;]
;// 03.02.04 //                STA     <WORK+8         ; ]WORK+8 +9 +10 ni MPDAT L H B o set
;// 03.02.04 //                LDA     >MPTBLDT+1,X    ; ]
;// 03.02.04 //                STA     <WORK+9         ;]
;// 03.02.04 //                JSR     MPCNG1		;data no tenkai
                JSR     MPCNG0		;data no tenkai
;
;
;
		LDA	<MPDTNO		;]
		CLC
		ADC	#008
		STA	<WORK
		ASL	A		; ]X=MPDTNO*3
		ADC	<WORK		; ]
		TAX			;]
		LDA	#GDBUF1		;]
;// 03.02.04 //		STA	<WORK		; ]
;// 03.02.04 //                CLC                     ; ]           o set
;// 03.02.04 //                ADC     #0080H          ; ]
;// 03.02.04 //                STA     <WORK+3         ;]
;// 03.02.04 //                LDA     >MPTBLDT,X      ;]
;// 03.02.04 //		STA	<WORK+8		; ]WORK+8 +9 +10 ni MPDAT L H B o set
;// 03.02.04 //		LDA	>MPTBLDT+1,X	; ]
;// 03.02.04 //		STA	<WORK+9		;]
;// 03.02.04 //		JSR	MPCNG1		;data no tenkai
		JSR	MPCNG0		;data no tenkai
;
                LDA     <MPDTNO         ;]
		CLC
		ADC	#009
		STA	<WORK
                ASL     A               ; ]X=MPDTNO*3
                ADC     <WORK         ; ]
                TAX                     ;]
                LDA     #GDBUF1         ;]
		CLC
		ADC	#00040H
MPCNG0		EQU	$
                STA     <WORK           ; ]
                CLC                     ; ]           o set
                ADC     #0080H          ; ]
                STA     <WORK+3         ;]
;
                LDA     >MPTBLDT,X      ;]
                STA     <CWORK0         ; ]WORK+8 +9 +10 ni MPDAT L H B o set
                LDA     >MPTBLDT+1,X    ; ]
                STA     <CWORK1         ;]
;
;
		LDA	<WORK0
		PHA
		LDA	<WORK2
		PHA
		LDA	<WORK4
		PHA
;
		LDA	#GDBUF5
		STA	<WORK0
		LDA	#BANK GDBUF5
		STA	<WORK2
;
		PHX
		SEP	#00110000B
		JSL	>MPDTBFST
		REP	#00110000B
		JSR	MPCNG4
		PLX
;
		PLA
		STA	<WORK4
		PLA
		STA	<WORK2
		PLA
		STA	<WORK0
;
		LDA	#GDBUF4
		STA	<WORK+8
		LDA	#BANK GDBUF4
		STA	<WORKA
;************************************************************************
MPCNG1		EQU	$
		MEM8
		IDX16
		SEP	#00100000B
;
		PHB
		LDA	#BANK GDBUF5
		PHA
		PLB
;
		MEM16
		IDX16
		REP	#00110000B
;
		LDA	#0FFFFH		;INDEX INIT. (MPCNG8)
		STA	GDBUF5+40H	;INDEX SAVE
		STZ	<WORK+6		;GDBUF no syusyoku
		STZ	<WORK+11	;MPDAT no syusyoku
MPCNG2		EQU	$
		LDA	#0010H		;yoko no UNIT su /2
		STA	<WORK+13
MPCNG3		EQU	$
		LDY	<WORK+11
		LDA	[<WORK+8],Y
		ASL	A
		LDY	<WORK+6
;
		JSR	MPCNG8		;UNIT SET
;
;
;;		LDA	>SCUNIT0,X
;;		STA	[<WORK],Y
;;		LDA	>SCUNIT2,X
;;		STA	[<WORK+3],Y
;;		INY
;;		INY
;;		LDA	>SCUNIT1,X
;;		STA	[<WORK],Y
;;		LDA	>SCUNIT3,X
;;		STA	[<WORK+3],Y
;;		INY
;;		INY
;
;
		STY	<WORK+6
		INC	<WORK+11
		INC	<WORK+11
		DEC	<WORK+13
		BNE	MPCNG3		;yoko 1 retu end?
;					;y
		LDA	<WORK+6
		CLC
		ADC	#00C0H
		STA	<WORK+6
		CMP	#01000H
		BCC	MPCNG2		;end?
;					;y
		PLB
		RTS
;
;
;
MPCNG4		EQU	$
		MEM8
		IDX16
		SEP	#00100000B
;
		PHB
		LDA	#BANK GDBUF5
		PHA
		PLB
		STA	<WORK2
;
		MEM16
		IDX16
		REP	#00110000B
;
		LDX	#00000H
		TXY
		LDA	#GDBUF4
		STA	<WORK0
MPCNG5		EQU	$
		LDA	GDBUF5,X
		XBA
		STA	[<WORK],Y
		INY
		INY
		INX
		INX
		LDA	GDBUF5,X
		XBA
		STA	[<WORK],Y
		INY
		INY
		INX
		INX
		LDA	GDBUF5,X
		XBA
		STA	[<WORK],Y
		INY
		INY
		INX
		INX
		LDA	GDBUF5,X
		XBA
		STA	[<WORK],Y
		INY
		INY
		INX
		INX
		CPX	#00200H
		BCC	MPCNG5
;
		PLB
		RTS
;
;
;
		MEM16
MPCNG8		EQU	$
		PHA
		AND	#0FFF8H
		CMP	GDBUF5+40H
		BNE	MPCNG9			;? MAE TO ONAGI
		JMP	MPCNGA			;Y
MPCNG9		EQU	$			;N
		STA	GDBUF5+40H		;INDEX SAVE
;
		LSR	A			;X*(3/4)
		STA	GDBUF5+42H
		LSR	A
		ADC	GDBUF5+42H
;
		TAX
;
		MEM8				;TENKAI
		IDX16
		SEP	#00100000B
;
		LDA	>SCUNIT0+0,X
		STA	GDBUF5+00H
;
		LDA	>SCUNIT0+1,X
		STA	GDBUF5+02H
;
		LDA	>SCUNIT0+2,X
		STA	GDBUF5+04H
;
		LDA	>SCUNIT0+3,X
		STA	GDBUF5+06H
;
		LDA	>SCUNIT0+4,X
		PHA
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		STA	GDBUF5+01H
;
		PLA
		AND	#00FH
		STA	GDBUF5+03H
;
		LDA	>SCUNIT0+5,X
		PHA
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		STA	GDBUF5+05H
;
		PLA
		AND	#00FH
		STA	GDBUF5+07H
;
;
		LDA	>SCUNIT1+0,X
		STA	GDBUF5+10H
;
		LDA	>SCUNIT1+1,X
		STA	GDBUF5+12H
;
		LDA	>SCUNIT1+2,X
		STA	GDBUF5+14H
;
		LDA	>SCUNIT1+3,X
		STA	GDBUF5+16H
;
		LDA	>SCUNIT1+4,X
		PHA
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		STA	GDBUF5+11H
;
		PLA
		AND	#00FH
		STA	GDBUF5+13H
;
		LDA	>SCUNIT1+5,X
		PHA
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		STA	GDBUF5+15H
;
		PLA
		AND	#00FH
		STA	GDBUF5+17H
;
;
		LDA	>SCUNIT2+0,X
		STA	GDBUF5+20H
;
		LDA	>SCUNIT2+1,X
		STA	GDBUF5+22H
;
		LDA	>SCUNIT2+2,X
		STA	GDBUF5+24H
;
		LDA	>SCUNIT2+3,X
		STA	GDBUF5+26H
;
		LDA	>SCUNIT2+4,X
		PHA
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		STA	GDBUF5+21H
;
		PLA
		AND	#00FH
		STA	GDBUF5+23H
;
		LDA	>SCUNIT2+5,X
		PHA
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		STA	GDBUF5+25H
;
		PLA
		AND	#00FH
		STA	GDBUF5+27H
;
;
		LDA	>SCUNIT3+0,X
		STA	GDBUF5+30H
;
		LDA	>SCUNIT3+1,X
		STA	GDBUF5+32H
;
		LDA	>SCUNIT3+2,X
		STA	GDBUF5+34H
;
		LDA	>SCUNIT3+3,X
		STA	GDBUF5+36H
;
		LDA	>SCUNIT3+4,X
		PHA
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		STA	GDBUF5+31H
;
		PLA
		AND	#00FH
		STA	GDBUF5+33H
;
		LDA	>SCUNIT3+5,X
		PHA
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		STA	GDBUF5+35H
;
		PLA
		AND	#00FH
		STA	GDBUF5+37H
;
;
		MEM16
		IDX16
		REP	#00110000B
;
MPCNGA		EQU	$
		PLA
		AND	#00007H
		TAX
		LDA	GDBUF5+00H,X		;UNIT SET
		STA	[<WORK],Y
		LDA	GDBUF5+20H,X
		STA	[<WORK+3],Y
		INY
		INY
		LDA	GDBUF5+10H,X
		STA	[<WORK],Y
		LDA	GDBUF5+30H,X
		STA	[<WORK+3],Y
		INY
		INY
;
		RTS
;
;
;
;
		MEM16
		IDX16
;************************************************************************
;*		GDBUF2 to GDBUF3 no data o kaeru			*
;************************************************************************
MP2CNG		EQU	$
		LDA	<MPDTNO		;]
		ASL	A		; ]X=MPDTNO*3
		ADC	<MPDTNO		; ]
		TAX			;]
		LDA	#BANK GDBUF2	; ]
		STA	<WORK+2		; ]WORK   +1 +2 ni GDBUF2 no L H B 
                STA     <WORK+5		; ]WORK+3 +4 +5 ni GDBUF2+128 no L H B
		LDA	#GDBUF2		;]
;<< 03.04.17 >>;// 03.02.04 //		STA	<WORK		; ]
;<< 03.04.17 >>;// 03.02.04 //		CLC			; ]           o set
;<< 03.04.17 >>;// 03.02.04 //		ADC	#0080H		; ]
;<< 03.04.17 >>;// 03.02.04 //		STA	<WORK+3		;]
;<< 03.04.17 >>;// 03.02.04 //                LDA     >MPTBLDT,X      ;]
;<< 03.04.17 >>;// 03.02.04 //		STA	<WORK+8		; ]WORK+8 +9 +10 ni MPDAT L H B o set
;<< 03.04.17 >>;// 03.02.04 //		LDA	>MPTBLDT+1,X	; ]
;<< 03.04.17 >>;// 03.02.04 //		STA	<WORK+9		;]
;<< 03.04.17 >>;// 03.02.04 //		JSR	MP2CNG1		;data no tenkai
;<< 03.04.17 >>		JSR	MP2CNG0		;data no tenkai
;<< 03.04.17 >>;
;<< 03.04.17 >>;
;<< 03.04.17 >>                LDA     <MPDTNO         ;]
;<< 03.04.17 >>		INC	A
;<< 03.04.17 >>		STA	<WORK
;<< 03.04.17 >>                ASL     A               ; ]X=MPDTNO*3
;<< 03.04.17 >>                ADC     <WORK	         ; ]
;<< 03.04.17 >>                TAX                     ;]
;<< 03.04.17 >>                LDA     #GDBUF2         ;]
;<< 03.04.17 >>		CLC
;<< 03.04.17 >>		ADC	#0040H
;<< 03.04.17 >>;// 03.02.04 //                STA     <WORK           ; ]
;<< 03.04.17 >>;// 03.02.04 //                CLC                     ; ]           o set
;<< 03.04.17 >>;// 03.02.04 //                ADC     #0080H          ; ]
;<< 03.04.17 >>;// 03.02.04 //                STA     <WORK+3         ;]
;<< 03.04.17 >>;// 03.02.04 //                LDA     >MPTBLDT,X      ;]
;<< 03.04.17 >>;// 03.02.04 //                STA     <WORK+8         ; ]WORK+8 +9 +10 ni MPDAT L H B o set
;<< 03.04.17 >>;// 03.02.04 //                LDA     >MPTBLDT+1,X    ; ]
;<< 03.04.17 >>;// 03.02.04 //                STA     <WORK+9         ;]
;<< 03.04.17 >>;// 03.02.04 //                JSR     MP2CNG1		;data no tenkai
;<< 03.04.17 >>                JSR     MP2CNG0		;data no tenkai
;<< 03.04.17 >>;
;<< 03.04.17 >>;
;<< 03.04.17 >>;
;<< 03.04.17 >>		LDA	<MPDTNO		;]
;<< 03.04.17 >>		CLC
;<< 03.04.17 >>		ADC	#008
;<< 03.04.17 >>		STA	<WORK
;<< 03.04.17 >>		ASL	A		; ]X=MPDTNO*3
;<< 03.04.17 >>		ADC	<WORK		; ]
;<< 03.04.17 >>		TAX			;]
;<< 03.04.17 >>		LDA	#GDBUF3		;]
;<< 03.04.17 >>;// 03.02.04 //		STA	<WORK		; ]
;<< 03.04.17 >>;// 03.02.04 //                CLC                     ; ]           o set
;<< 03.04.17 >>;// 03.02.04 //                ADC     #0080H          ; ]
;<< 03.04.17 >>;// 03.02.04 //                STA     <WORK+3         ;]
;<< 03.04.17 >>;// 03.02.04 //                LDA     >MPTBLDT,X      ;]
;<< 03.04.17 >>;// 03.02.04 //		STA	<WORK+8		; ]WORK+8 +9 +10 ni MPDAT L H B o set
;<< 03.04.17 >>;// 03.02.04 //		LDA	>MPTBLDT+1,X	; ]
;<< 03.04.17 >>;// 03.02.04 //		STA	<WORK+9		;]
;<< 03.04.17 >>;// 03.02.04 //		JSR	MP2CNG1		;data no tenkai
;<< 03.04.17 >>		JSR	MP2CNG0		;data no tenkai
;<< 03.04.17 >>;
;<< 03.04.17 >>                LDA     <MPDTNO         ;]
;<< 03.04.17 >>		CLC
;<< 03.04.17 >>		ADC	#009
;<< 03.04.17 >>		STA	<WORK
;<< 03.04.17 >>                ASL     A               ; ]X=MPDTNO*3
;<< 03.04.17 >>                ADC     <WORK         ; ]
;<< 03.04.17 >>                TAX                     ;]
;<< 03.04.17 >>                LDA     #GDBUF3         ;]
;<< 03.04.17 >>		CLC
;<< 03.04.17 >>		ADC	#00040H
MP2CNG0		EQU	$
		STA     <WORK           ; ]
                CLC                     ; ]           o set
                ADC     #0080H          ; ]
                STA     <WORK+3         ;]
;
                LDA     >MPTBLDT,X      ;]
                STA     <CWORK0         ; ]WORK+8 +9 +10 ni MPDAT L H B o set
                LDA     >MPTBLDT+1,X    ; ]
                STA     <CWORK1         ;]
;
;
		LDA	<WORK0
		PHA
		LDA	<WORK2
		PHA
		LDA	<WORK4
		PHA
;
		LDA	#GDBUF5
		STA	<WORK0
		LDA	#BANK GDBUF5
		STA	<WORK2
;
		PHX
		SEP	#00110000B
		JSL	>MPDTBFST
		REP	#00110000B
		JSR	MPCNG4
		PLX
;
		PLA
		STA	<WORK4
		PLA
		STA	<WORK2
		PLA
		STA	<WORK0
;
		LDA	#GDBUF4
		STA	<WORK+8
		LDA	#BANK GDBUF4
		STA	<WORKA
;************************************************************************
MP2CNG1		EQU	$
		MEM8
		IDX16
		SEP	#00100000B
;
		PHB
		LDA	#BANK GDBUF5
		PHA
		PLB
;
		MEM16
		IDX16
		REP	#00110000B
;
		LDA	#0FFFFH		;INDEX INIT. (MPCNG8)
		STA	GDBUF5+40H	;INDEX SAVE
		STZ	<WORK+6		;GDBUF no syusyoku
		STZ	<WORK+11	;MPDAT no syusyoku
MP2CNG2		EQU	$
		LDA	#0010H		;yoko no UNIT su /2
		STA	<WORK+13
MP2CNG3		EQU	$
		LDY	<WORK+11
		LDA	[<WORK+8],Y
		ASL	A
		TAX
		LDY	<WORK+6
		JSR	MPCNG8		;UNIT SET
;
;
;;		LDA	>SCUNIT0,X
;;		STA	[<WORK],Y
;;		LDA	>SCUNIT2,X
;;		STA	[<WORK+3],Y
;;		INY
;;		INY
;;		LDA	>SCUNIT1,X
;;		STA	[<WORK],Y
;;		LDA	>SCUNIT3,X
;;		STA	[<WORK+3],Y
;;		INY
;;		INY
;
;
		STY	<WORK+6
		INC	<WORK+11
		INC	<WORK+11
		DEC	<WORK+13
		BNE	MP2CNG3		;yoko 1 retu end?
;					;y
		LDA	<WORK+6
		CLC
		ADC	#00C0H
		STA	<WORK+6
		CMP	#01000H
		BCC	MP2CNG2		;end?
;					;y
		PLB
		RTS
;
;
		MEM8
		IDX8
;
;************************************************************************
;*		DATA							*
;************************************************************************
TATYDT		EQU	$		;BG o yoko ni hikuka tate ni hikuka 
		WORD	00002,00004	;
;
RLDATA		EQU	$		;RLDATA  720,        784
		WORD	00976		;        migi ue     hidari ue
UDDATA		EQU	$		;UDDATA  784,       !(2288)+1
		WORD	01040,0F410H	;        hidari ue   hidari sita
;
MPDBUF		EQU	$
		WORD	00000,00032
;
MPSIZE		EQU	$
;				0--> 4*4
;				1--> 3*3
;				2--> 2*2
;				3--> 1*1
;
;// 02.11.15 //		BYTE	0,0,2,0,0,0,0,2
;// 02.11.15 //		BYTE	0,0,2,0,0,0,0,2
;// 02.11.15 //		BYTE	2,2,2,2,2,2,2,2
;// 02.11.15 //		BYTE	0,0,2,0,0,2,0,0
;// 02.11.15 //		BYTE	0,0,2,0,0,2,0,0
;// 02.11.15 //		BYTE	2,2,2,2,2,0,0,2
;// 02.11.15 //		BYTE	0,0,2,2,2,0,0,2
;// 02.11.15 //		BYTE	0,0,2,2,2,2,2,2
;
		BYTE	0,0,0,0,0,0,0,0
		BYTE	0,0,0,0,0,0,0,0
		BYTE	0,0,0,0,0,0,0,0
		BYTE	0,0,0,0,0,0,0,0
		BYTE	0,0,0,0,0,0,0,0
		BYTE	0,0,0,0,0,0,0,0
		BYTE	0,0,0,0,0,0,0,0
		BYTE	0,0,0,0,0,0,0,0
;
		BYTE	0,0,2,0,0,0,0,2
		BYTE	0,0,2,0,0,0,0,2
		BYTE	2,2,2,2,2,2,2,2
		BYTE	0,0,2,0,0,2,0,0
		BYTE	0,0,2,0,0,2,0,0
		BYTE	2,2,2,2,2,2,2,2
		BYTE	0,0,2,2,2,0,0,2
		BYTE	0,0,2,2,2,0,0,2
;
		BYTE	0,0,0,0,0,0,0,0
		BYTE	0,0,0,0,0,0,0,0
		BYTE	0,0,0,0,0,0,0,0
		BYTE	0,0,0,0,0,0,0,0
		BYTE	0,0,0,0,0,0,0,0
		BYTE	0,0,0,0,0,0,0,0
		BYTE	0,0,0,0,0,0,0,0
		BYTE	0,0,0,0,0,0,0,0
;
MPTBLDT		EQU	$
		LWORD	MAPDTH00,MAPDTH01,MAPDTH02,MAPDTH03,MAPDTH04,MAPDTH05,MAPDTH06,MAPDTH07
		LWORD	MAPDTH08,MAPDTH09,MAPDTH0A,MAPDTH0B,MAPDTH0C,MAPDTH0D,MAPDTH0E,MAPDTH0F
;
		LWORD	MAPDTH10,MAPDTH11,MAPDTH12,MAPDTH13,MAPDTH14,MAPDTH15,MAPDTH16,MAPDTH17
		LWORD	MAPDTH18,MAPDTH19,MAPDTH1A,MAPDTH1B,MAPDTH1C,MAPDTH1D,MAPDTH1E,MAPDTH1F
;
		LWORD	MAPDTH20,MAPDTH21,MAPDTH22,MAPDTH23,MAPDTH24,MAPDTH25,MAPDTH26,MAPDTH27
		LWORD	MAPDTH28,MAPDTH29,MAPDTH2A,MAPDTH2B,MAPDTH2C,MAPDTH2D,MAPDTH2E,MAPDTH2F
;
		LWORD	MAPDTH30,MAPDTH31,MAPDTH32,MAPDTH33,MAPDTH34,MAPDTH35,MAPDTH36,MAPDTH37
		LWORD	MAPDTH38,MAPDTH39,MAPDTH3A,MAPDTH3B,MAPDTH3C,MAPDTH3D,MAPDTH3E,MAPDTH3F
;
		LWORD	MAPDTH40,MAPDTH41,MAPDTH42,MAPDTH43,MAPDTH44,MAPDTH45,MAPDTH46,MAPDTH47
		LWORD	MAPDTH48,MAPDTH49,MAPDTH4A,MAPDTH4B,MAPDTH4C,MAPDTH4D,MAPDTH4E,MAPDTH4F
;
		LWORD	MAPDTH50,MAPDTH51,MAPDTH52,MAPDTH53,MAPDTH54,MAPDTH55,MAPDTH56,MAPDTH57
		LWORD	MAPDTH58,MAPDTH59,MAPDTH5A,MAPDTH5B,MAPDTH5C,MAPDTH5D,MAPDTH5E,MAPDTH5F
;
		LWORD	MAPDTH60,MAPDTH61,MAPDTH62,MAPDTH63,MAPDTH64,MAPDTH65,MAPDTH66,MAPDTH67
		LWORD	MAPDTH68,MAPDTH69,MAPDTH6A,MAPDTH6B,MAPDTH6C,MAPDTH6D,MAPDTH6E,MAPDTH6F
;
		LWORD	MAPDTH70,MAPDTH71,MAPDTH72,MAPDTH73,MAPDTH74,MAPDTH75,MAPDTH76,MAPDTH77
		LWORD	MAPDTH78,MAPDTH79,MAPDTH7A,MAPDTH7B,MAPDTH7C,MAPDTH7D,MAPDTH7E,MAPDTH7F
;
;
		LWORD	MAPDTH83,MAPDTH8A,MAPDTH8B,MAPDTH8E,MAPDTH8F,MAPDTH8F,MAPDTH83,MAPDTH83
		LWORD	MAPDTH84,MAPDTH8C,MAPDTH8D,MAPDTH8C,MAPDTH8F,MAPDTH8F,MAPDTH84,MAPDTH84
;
		LWORD	MAPDTH83,MAPDTH80,MAPDTH81,MAPDTH81,MAPDTH82,MAPDTH82,MAPDTH83,MAPDTH83
		LWORD	MAPDTH84,MAPDTH80,MAPDTH81,MAPDTH81,MAPDTH82,MAPDTH82,MAPDTH84,MAPDTH84
;
		LWORD	MAPDTH83,MAPDTH80,MAPDTH81,MAPDTH81,MAPDTH82,MAPDTH82,MAPDTH83,MAPDTH83
		LWORD	MAPDTH84,MAPDTH80,MAPDTH81,MAPDTH81,MAPDTH82,MAPDTH82,MAPDTH84,MAPDTH84
;
		LWORD	MAPDTH8F,MAPDTH8F,MAPDTH80,MAPDTH80,MAPDTH81,MAPDTH90,MAPDTH8F,MAPDTH81
		LWORD	MAPDTH8F,MAPDTH8F,MAPDTH80,MAPDTH80,MAPDTH91,MAPDTH81,MAPDTH80,MAPDTH82
;
;
;
;
;
;
;************************************************************************
;*		DATA							*
;************************************************************************
MP1TOGD		EQU	$
		MEM16
		IDX16
		REP	#00110000B
;
		JSR	MP2CNG
;
;// 03.05.23 //		LDA	#0FFFFH
;// 03.05.23 //		STA	<CWORK0
;// 03.05.23 //		STZ	<CWORK2
		LDA	#01000H
		STA	<CWORK4
;
		MEM8
		IDX8
		SEP	#00110000B
;
		JSR	MP2ALST
;
		LDA	#bgw4
		STA	<BGWTFG
		STA	!GMAPDF
;
		INC	<GAMEMD
		RTS
;
;
;
;
;
;
;----------------------------------------
MP2ALST		EQU	$
		PHB
		LDA	#BANK MPUNIT
		PHA
		PLB
;
		MEM16
		IDX16
		REP	#00110000B
;
;// 03.05.28 //		LDA	<SCRPNT
;// 03.05.28 //		CLC
;// 03.05.28 //		ADC	#01000H
;// 03.05.28 //		STA	<SCRPNT
;// 03.05.28 //;
;// 03.05.28 //		STZ	<WORK+10
;// 03.05.28 //		STZ	<WORK+14	;VRAMD+2,Y no Y no toko o cls
;// 03.05.28 //;
		LDA	#GDBUF2
		STA	<WORK4
		LDA	#BANK GDBUF2
		BRA	MP3ALST
;// 03.05.28 //		STA	<WORK6
;// 03.05.28 //;
;// 03.05.28 //		LDA	#0020H/2	;MPINT1 o kuri kaesu kaisu
;// 03.05.28 //		STA	<WORK+8		;tate no unit su
;// 03.05.28 //MP2ALS2		EQU     $
;// 03.05.28 //		JSR	MPALLN		;ue(sita) no BG o kaku
;// 03.05.28 //		LDA	<SCRPNT		;]
;// 03.05.28 //		SEC			; ]SCRPNT=SCRPNT-64
;// 03.05.28 //		SBC	#0128		; ]gamen no kihonten
;// 03.05.28 //		STA	<SCRPNT		;]
;// 03.05.28 //		LDA	<YWRITE		;]
;// 03.05.28 //		DEC	A		; ]unit tani no tate no iti
;// 03.05.28 //		AND	#001FH		; ]
;// 03.05.28 //		STA	<YWRITE		;]
;// 03.05.28 //;
;// 03.05.28 //		JSR	MPALLN		;ue(sita) no BG o kaku
;// 03.05.28 //		LDA	<SCRPNT		;]
;// 03.05.28 //		SEC			; ]SCRPNT=SCRPNT-64
;// 03.05.28 //		SBC	#0128		; ]gamen no kihonten
;// 03.05.28 //		STA	<SCRPNT		;]
;// 03.05.28 //		LDA	<YWRITE		;]
;// 03.05.28 //		DEC	A		; ]unit tani no tate no iti
;// 03.05.28 //		AND	#001FH		; ]
;// 03.05.28 //		STA	<YWRITE		;]
;// 03.05.28 //;
;// 03.05.28 //		DEC	<WORK+8
;// 03.05.28 //		BNE	MPALS2
;// 03.05.28 //;
;// 03.05.28 //		MEM8
;// 03.05.28 //		IDX8
;// 03.05.28 //		SEP	#00110000B
;// 03.05.28 //;
;// 03.05.28 //		PLB
;// 03.05.28 //		RTS
;
;
		MEM8
		IDX8
;----------------------------------------
MPALST		EQU	$
		PHB
		LDA	#BANK MPUNIT
		PHA
		PLB
;
		MEM16
		IDX16
		REP	#00110000B
;
		LDA	#GDBUF0
		STA	<WORK4
		LDA	#BANK GDBUF0
MP3ALST		EQU	$
		STA	<WORK6
;
		LDA	<SCRPNT
		CLC
		ADC	#01000H
		STA	<SCRPNT
;
		STZ	<WORK+10
		STZ	<WORK+14	;VRAMD+2,Y no Y no toko o cls
;
		LDA	#0020H/2	;MPINT1 o kuri kaesu kaisu
		STA	<WORK+8		;tate no unit su
MPALS2		EQU     $
		JSR	MPALLN		;ue(sita) no BG o kaku
		LDA	<SCRPNT		;]
		SEC			; ]SCRPNT=SCRPNT-64
		SBC	#0128		; ]gamen no kihonten
		STA	<SCRPNT		;]
		LDA	<YWRITE		;]
		DEC	A		; ]unit tani no tate no iti
		AND	#001FH		; ]
		STA	<YWRITE		;]
;
		JSR	MPALLN		;ue(sita) no BG o kaku
		LDA	<SCRPNT		;]
		SEC			; ]SCRPNT=SCRPNT-64
		SBC	#0128		; ]gamen no kihonten
		STA	<SCRPNT		;]
		LDA	<YWRITE		;]
		DEC	A		; ]unit tani no tate no iti
		AND	#001FH		; ]
		STA	<YWRITE		;]
;
		DEC	<WORK+8
		BNE	MPALS2
;
		MEM8
		IDX8
		SEP	#00110000B
;
		PLB
		RTS
;
;
MPALLN		EQU	$
		MEM16
		IDX16
;
		LDA	<SCRPNT		;   ] ue   nara SCRPNT-1040=Y
		SEC			;   ] sita nara SCRPNT+3056=Y
		SBC	#01040
		AND	#01FFFH
		TAY
;
		LDA	<XWRITE		;]
		ASL	A		; ]X=XWRITE*2
		TAX			;]
;
		LDA	#0032/2		;MPALL1 o kurikaesu kaisu(1 retu no kazu)
		STA	<WORK
MPALL1		EQU	$
		LDA	[<WORK4],Y	;<WORK L,H,B --> map data
		STA	!DATBUF,X	;DATBUF --> data o ireru toko
		INX
		INX
		TXA			;]
		AND	#003FH	 	; ]X>1F -->X=0 (0<=X<=1F)
		TAX			;]
		INY
		INY
		TYA
		AND	#01FFFH
		TAY
;
		LDA	[<WORK4],Y	;<WORK L,H,B --> map data
		STA	!DATBUF,X	;DATBUF --> data o ireru toko
		INX
		INX
		TXA			;]
		AND	#003FH	 	; ]X>1F -->X=0 (0<=X<=1F)
		TAX			;]
		INY
		INY
		TYA
		AND	#01FFFH
		TAY
		DEC	<WORK
		BNE	MPALL1		;1 retu bun no data o DATBUF ni iretaka?
;					;y
		LDA	<YWRITE		;			    ] |-----------
		STA	<WORK+2		;			    ] |          |
		CMP	#00016		;			    ] +-----+    |
		BCC	MPALL2		;tonarino gamenka?	    ] |  |  |    |--dotiraka no adress o moto meru
;					;y
		AND	#000FH		;			    ] |~~|~~|    |
		STA	<WORK+2		;			    ] +-----+    |
		LDA	#0800H		;			    ] |          |
		STA	<WORK		;			]]]]  -----------|
MPALL2		EQU	$		;]]]
		LDA	<WORK+2		;   ]
		ASL	A		;   ]<WORK=<WORK+(work+2)*64
		ASL	A		;   ]
		ASL	A		;   ]
		ASL	A		;   ]
		ASL	A		;   ]
		ASL	A		;   ]
		CLC			;   ]
		ADC	<WORK		;   ]
		STA	<WORK		;]]]
;
		LDA	>MPDBUF+0	;    ]
		JSR	MPALNE
;
		LDA	<WORK
		CLC
		ADC	#00400H
		STA	<WORK
		LDA	>MPDBUF+2	;    ]
;
;************************************************************************
;*		32 no BG o kaku				sub program	*
;************************************************************************
MPALNE		EQU	$
		STA	<WORK+2
;
		LDX	<WORK+10
		LDA	<WORK
		ORA	<CWORK4
		STA	>GRWRBF+2000H,X
		INX
		INX
		STX	<WORK+10
;
		LDX	<WORK+14
		LDA	#0032/2
		STA	<WORK+12
MPALN1		EQU	$
		LDY	<WORK2		;    ]
		LDA	!DATBUF,Y	;    ]
		INY			;DATBUF,Y no Y o tugini susumeru
		INY			;(tigi no unit)
		STY	<WORK2
		ASL	A		;    ]
		ASL	A		;    ]
		ASL	A		;    ]X=(DATBUF,Y)*4+(<WORK+4)
		TAY			;]]]]
;
		LDA	MPUNIT+0,Y	;
;// 03.02.20 //		AND	<CWORK0
;// 03.02.20 //		ORA	<CWORK2
		STA	>GRWRBF+00H,X	;
		LDA	MPUNIT+4,Y	;
;// 03.02.20 //		AND	<CWORK0
;// 03.02.20 //		ORA	<CWORK2
		STA	>GRWRBF+40H,X	;
		INX			;VRAMD+6,Y no Y o tugini suru
		INX			;
;
		LDA	MPUNIT+2,Y	;
;// 03.02.20 //		AND	<CWORK0
;// 03.02.20 //		ORA	<CWORK2
		STA	>GRWRBF+00H,X	;
		LDA	MPUNIT+6,Y	;
;// 03.02.20 //		AND	<CWORK0
;// 03.02.20 //		ORA	<CWORK2
		STA	>GRWRBF+40H,X	;
		INX			;VRAMD+6,Y no Y o tugini suru
		INX			;
		DEC	<WORK+12
		BNE	MPALN1		;1 retu end?
;					;y
		TXA
		CLC
		ADC	#00040H
		STA	<WORK+14	;VRAMD+6,Y no Y o hozon
		RTS
;
;
;
;
;
;************************************************************************
;*		Ground memory buffer reset		(GDMMRST)	*
;************************************************************************
GDMMRST		EQU	$
		MEM16
		IDX16
		REP	#00110000B	; memory,index 16bit mode
;
		LDA	!GDMMPT
		BEQ	GMMRS80		;
;					;
		LDX	#00000H
		STX	<WORK0
GMMRS40		EQU	$
		LDX	<WORK0
		LDA	>GDMMBF+000H,X
		TAY
		LDA	>GDMMBF+200H,X
		TYX			; (X) <-- (Y)
		STA	>GDBUF0,X
		INC	<WORK0
		INC	<WORK0
		LDA	<WORK0
		CMP	!GDMMPT
		BNE	GMMRS40		; reset end ?
;					; yes
GMMRS80		EQU	$
		MEM8
		IDX8
		SEP	#00110000B	; memory,index 16bit mode
		RTS
;
;
;
;
		MEM16
		IDX16
;************************************************************************
;*		Ground shikake check			(GSKKCK)	*
;************************************************************************
GOPTNDT		EQU	$
		WORD	GOPTN00,GOPTN01,GOPTN02,GOPTN03,GOPTN04,GOPTN05,GOPTN06,GOPTN07
		WORD	GOPTN08,GOPTN09,GOPTN0A,GOPTN0B,GOPTN0C,GOPTN0D,GOPTN0E,GOPTN0F
;
		WORD	GOPTN10,GOPTN11,GOPTN12,GOPTN13,GOPTN14,GOPTN15,GOPTN16,GOPTN17
		WORD	GOPTN18,GOPTN19,GOPTN1A,GOPTN1B,GOPTN1C,GOPTN1D,GOPTN1E,GOPTN1F
;
		WORD	GOPTN20,GOPTN21,GOPTN22,GOPTN23,GOPTN24,GOPTN25,GOPTN26,GOPTN27
		WORD	GOPTN28,GOPTN29,GOPTN2A,GOPTN2B,GOPTN2C,GOPTN2D,GOPTN2E,GOPTN2F
;
		WORD	GOPTN30,GOPTN31,GOPTN32,GOPTN33,GOPTN34,GOPTN35,GOPTN36,GOPTN37
		WORD	GOPTN38,GOPTN39,GOPTN3A,GOPTN3B,GOPTN3C,GOPTN3D,GOPTN3E,GOPTN3F
;
		WORD	GOPTN40,GOPTN41,GOPTN42,GOPTN43,GOPTN44,GOPTN45,GOPTN46,GOPTN47
		WORD	GOPTN48,GOPTN49,GOPTN4A,GOPTN4B,GOPTN4C,GOPTN4D,GOPTN4E,GOPTN4F
;
		WORD	GOPTN50,GOPTN51,GOPTN52,GOPTN53,GOPTN54,GOPTN55,GOPTN56,GOPTN57
		WORD	GOPTN58,GOPTN59,GOPTN5A,GOPTN5B,GOPTN5C,GOPTN5D,GOPTN5E,GOPTN5F
;
		WORD	GOPTN60,GOPTN61,GOPTN62,GOPTN63,GOPTN64,GOPTN65,GOPTN66,GOPTN67
		WORD	GOPTN68,GOPTN69,GOPTN6A,GOPTN6B,GOPTN6C,GOPTN6D,GOPTN6E,GOPTN6F
;
		WORD	GOPTN70,GOPTN71,GOPTN72,GOPTN73,GOPTN74,GOPTN75,GOPTN76,GOPTN77
		WORD	GOPTN78,GOPTN79,GOPTN7A,GOPTN7B,GOPTN7C,GOPTN7D,GOPTN7E,GOPTN7F
;
		WORD	GOPTN80,GOPTN81,GOPTN82,GOPTN83,GOPTN84,GOPTN85,GOPTN86,GOPTN87
		WORD	GOPTN88,GOPTN89,GOPTN8A,GOPTN8B,GOPTN8C,GOPTN8D,GOPTN8E,GOPTN8F
;
		WORD	GOPTN90,GOPTN91,GOPTN92,GOPTN93,GOPTN94,GOPTN95,GOPTN96,GOPTN97
		WORD	GOPTN98,GOPTN99,GOPTN9A,GOPTN9B,GOPTN9C,GOPTN9D,GOPTN9E,GOPTN9F
;
		WORD	GOPTNA0,GOPTNA1,GOPTNA2,GOPTNA3,GOPTNA4,GOPTNA5,GOPTNA6,GOPTNA7
		WORD	GOPTNA8,GOPTNA9,GOPTNAA,GOPTNAB,GOPTNAC,GOPTNAD,GOPTNAE,GOPTNAF
;
		WORD	GOPTNB0,GOPTNB1,GOPTNB2,GOPTNB3,GOPTNB4,GOPTNB5,GOPTNB6,GOPTNB7
		WORD	GOPTNB8,GOPTNB9,GOPTNBA,GOPTNBB,GOPTNBC,GOPTNBD,GOPTNBE,GOPTNBF
;
;
GOPTN00		EQU	$
GOPTN01		EQU	$
GOPTN02		EQU	$
GOPTN03		EQU	$
GOPTN04		EQU	$
GOPTN05		EQU	$
GOPTN06		EQU	$
GOPTN07		EQU	$
GOPTN08		EQU	$
GOPTN09		EQU	$
GOPTN0A		EQU	$
GOPTN0B		EQU	$
GOPTN0C		EQU	$
GOPTN0D		EQU	$
GOPTN0E		EQU	$
GOPTN0F		EQU	$
GOPTN10		EQU	$
GOPTN11		EQU	$
GOPTN12		EQU	$
GOPTN13		EQU	$
		RTS
GOPTN14		EQU	$
;// 03.06.03 //		LDX	#00532H
		LDA	#hakut0
		STA	>GDBUF0+00532H
;// 03.06.03 //		LDA	#hakut1
		INC	A
		STA	>GDBUF0+00534H
		LDA	#hakut6
		STA	>GDBUF0+005B2H
;// 03.06.03 //		LDA	#hakut7
		INC	A
		STA	>GDBUF0+005B4H
;// 03.06.03 //		LDA	#hakut8
		INC	A
		STA	>GDBUF0+00632H
;// 03.06.03 //		LDA	#hakut9
		INC	A
		STA	>GDBUF0+00634H
		RTS
;
GOPTN15		EQU	$
GOPTN16		EQU	$
GOPTN17		EQU	$
GOPTN18		EQU	$
GOPTN19		EQU	$
GOPTN1A		EQU	$
		RTS
GOPTN1B		EQU	$
;// 03.06.03 //		LDX	#013BCH
		LDA	#sgtu08
		STA	>GDBUF0+013BCH
;// 03.06.03 //		LDA	#sgtu09
		INC	A
		STA	>GDBUF0+013BEH
;// 03.06.03 //		LDA	#sgtu05
		INC	A
		STA	>GDBUF0+0143CH
;// 03.06.03 //		LDA	#sgtu06
		INC	A
		STA	>GDBUF0+0143EH
;
;// 03.06.03 //		LDX	#013C0H
		LDA	#sgtu09
		STA	>GDBUF0+013C0H
;// 03.06.03 //		LDA	#sgtu0A
		INC	A
		STA	>GDBUF0+013C2H
		LDA	#sgtu06
		STA	>GDBUF0+01440H
;// 03.06.03 //		LDA	#sgtu07
		INC	A
		STA	>GDBUF0+01442H
		RTS
;
GOPTN1C		EQU	$
GOPTN1D		EQU	$
GOPTN1E		EQU	$
GOPTN1F		EQU	$
GOPTN20		EQU	$
GOPTN21		EQU	$
GOPTN22		EQU	$
GOPTN23		EQU	$
GOPTN24		EQU	$
GOPTN25		EQU	$
GOPTN26		EQU	$
GOPTN27		EQU	$
GOPTN28		EQU	$
GOPTN29		EQU	$
GOPTN2A		EQU	$
GOPTN2B		EQU	$
GOPTN2C		EQU	$
GOPTN2D		EQU	$
GOPTN2E		EQU	$
GOPTN2F		EQU	$
GOPTN30		EQU	$
GOPTN31		EQU	$
GOPTN32		EQU	$
GOPTN33		EQU	$
GOPTN34		EQU	$
GOPTN35		EQU	$
GOPTN36		EQU	$
GOPTN37		EQU	$
GOPTN38		EQU	$
GOPTN39		EQU	$
GOPTN3A		EQU	$
		RTS
GOPTN3B		EQU	$
GOPTN7B		EQU	$
		LDA	#mizu00
		STA	>GDBUF0+3ACH
		STA	>GDBUF0+424H
		STA	>GDBUF0+4A0H
		STA	>GDBUF0+51EH
		STA	>GDBUF0+61CH
		STA	>GDBUF0+734H
;
;// 03.06.03 //		LDA	#mizu01
		INC	A
		STA	>GDBUF0+3AEH
		STA	>GDBUF0+4A2H
;
;// 03.06.03 //		LDA	#mizu02
		INC	A
		STA	>GDBUF0+3B0H
		STA	>GDBUF0+438H
		STA	>GDBUF0+4BAH
		STA	>GDBUF0+5AAH
		STA	>GDBUF0+73AH
;
;// 03.06.03 //		LDA	#mizu03
		INC	A
		STA	>GDBUF0+426H
		STA	>GDBUF0+428H
		STA	>GDBUF0+42AH
		STA	>GDBUF0+432H
		STA	>GDBUF0+434H
		STA	>GDBUF0+436H
;
;// 03.06.03 //		LDA	#mizu04
		INC	A
		STA	>GDBUF0+42CH
		STA	>GDBUF0+4A4H
		STA	>GDBUF0+520H
		STA	>GDBUF0+61EH
;
;// 03.06.03 //		LDA	#mizu05
		INC	A
		STA	>GDBUF0+42EH
		STA	>GDBUF0+4A6H
		STA	>GDBUF0+4A8H
		STA	>GDBUF0+4B0H
		STA	>GDBUF0+4B6H
		STA	>GDBUF0+522H
		STA	>GDBUF0+524H
		STA	>GDBUF0+526H
		STA	>GDBUF0+538H
		STA	>GDBUF0+5A0H
		STA	>GDBUF0+5A2H
		STA	>GDBUF0+5A4H
		STA	>GDBUF0+5A6H
		STA	>GDBUF0+620H
		STA	>GDBUF0+622H
		STA	>GDBUF0+69EH
		STA	>GDBUF0+6A0H
		STA	>GDBUF0+71EH
		STA	>GDBUF0+720H
		STA	>GDBUF0+826H
		STA	>GDBUF0+8A6H
		STA	>GDBUF0+8A8H
		STA	>GDBUF0+926H
;
;// 03.06.03 //		LDA	#mizu06
		INC	A
		STA	>GDBUF0+430H
		STA	>GDBUF0+4B8H
		STA	>GDBUF0+5A8H
		STA	>GDBUF0+62AH
;
;// 03.06.03 //		LDA	#mizu07
		INC	A
		STA	>GDBUF0+4AAH
		STA	>GDBUF0+4B2H
		STA	>GDBUF0+528H
		STA	>GDBUF0+5B8H
		STA	>GDBUF0+8AAH
		STA	>GDBUF0+928H
;
;// 03.06.03 //		LDA	#mizu08
		INC	A
		STA	>GDBUF0+4ACH
		STA	>GDBUF0+530H
		STA	>GDBUF0+79EH
		STA	>GDBUF0+7A0H
		STA	>GDBUF0+9A6H
		STA	>GDBUF0+9B8H
;
;// 03.06.03 //		LDA	#mizu09
		INC	A
		STA	>GDBUF0+4AEH
		STA	>GDBUF0+4B4H
		STA	>GDBUF0+536H
		STA	>GDBUF0+7A2H
		STA	>GDBUF0+824H
;
;// 03.06.03 //		LDA	#mizu0A
		INC	A
		STA	>GDBUF0+52EH
		STA	>GDBUF0+534H
		STA	>GDBUF0+79CH
		STA	>GDBUF0+822H
		STA	>GDBUF0+934H
		STA	>GDBUF0+9B6H
;
;// 03.06.03 //		LDA	#mizu0B
		INC	A
		STA	>GDBUF0+53AH
		STA	>GDBUF0+638H
		STA	>GDBUF0+6B8H
		STA	>GDBUF0+93AH
;
;// 03.06.03 //		LDA	#mizu0C
		INC	A
		STA	>GDBUF0+59EH
		STA	>GDBUF0+5B6H
		STA	>GDBUF0+636H
		STA	>GDBUF0+69CH
		STA	>GDBUF0+6B6H
		STA	>GDBUF0+71CH
		STA	>GDBUF0+8A4H
		STA	>GDBUF0+924H
;
;// 03.06.03 //		LDA	#mizu0D
		INC	A
		STA	>GDBUF0+624H
		STA	>GDBUF0+6A2H
;
;// 03.06.03 //		LDA	#mizu0E
		INC	A
		STA	>GDBUF0+626H
;
;// 03.06.03 //		LDA	#mizu0F
		INC	A
		STA	>GDBUF0+628H
;
;// 03.06.03 //		LDA	#mizu10
		INC	A
		STA	>GDBUF0+6A4H
		STA	>GDBUF0+7B6H
;
;// 03.06.03 //		LDA	#mizu11
		INC	A
		STA	>GDBUF0+6A6H
		STA	>GDBUF0+726H
		STA	>GDBUF0+728H
		STA	>GDBUF0+72AH
		STA	>GDBUF0+7AAH
		STA	>GDBUF0+836H
		STA	>GDBUF0+838H
;
;// 03.06.03 //		LDA	#mizu12
		INC	A
		STA	>GDBUF0+6A8H
		STA	>GDBUF0+7B8H
;
;// 03.06.03 //		LDA	#mizu13
		INC	A
		STA	>GDBUF0+6AAH
;
;// 03.06.03 //		LDA	#mizu14
		INC	A
		STA	>GDBUF0+722H
		STA	>GDBUF0+7A4H
		STA	>GDBUF0+828H
;
;// 03.06.03 //		LDA	#mizu15
		INC	A
		STA	>GDBUF0+724H
;
;// 03.06.03 //		LDA	#mizu16
		INC	A
		STA	>GDBUF0+7A6H
;
;// 03.06.03 //		LDA	#mizu17
		INC	A
		STA	>GDBUF0+7A8H
		STA	>GDBUF0+8B6H
;
;// 03.06.03 //		LDA	#mizu18
		INC	A
		STA	>GDBUF0+7B4H
;
;// 03.06.03 //		LDA	#mizu19
		INC	A
		STA	>GDBUF0+7BAH
;
;// 03.06.03 //		LDA	#mizu1A
		INC	A
		STA	>GDBUF0+82AH
;
;// 03.06.03 //		LDA	#mizu1B
		INC	A
		STA	>GDBUF0+834H
;
;// 03.06.03 //		LDA	#mizu1C
		INC	A
		STA	>GDBUF0+83AH
;
;// 03.06.03 //		LDA	#mizu1D
		INC	A
		STA	>GDBUF0+8B4H
;
;// 03.06.03 //		LDA	#mizu1E
		INC	A
		STA	>GDBUF0+8B8H
;
;// 03.06.03 //		LDA	#mizu1F
		INC	A
		STA	>GDBUF0+8BAH
;
;// 03.06.03 //		LDA	#mizu20
		INC	A
		STA	>GDBUF0+936H
;
;// 03.06.03 //		LDA	#mizu21
		INC	A
		STA	>GDBUF0+938H
;
;// 03.06.03 //		LDA	#mizu22
		INC	A
		STA	>GDBUF0+52AH
		STA	>GDBUF0+532H
		STA	>GDBUF0+92AH
;
;// 03.06.03 //		LDA	#mizu23
		INC	A
		STA	>GDBUF0+5BAH
		STA	>GDBUF0+9A8H
		STA	>GDBUF0+9BAH
;
;// 03.06.03 //		LDA	#mizu24
		INC	A
		STA	>GDBUF0+9A4H
;
;// 03.06.03 //		LDA	#mizu25
		INC	A
		STA	>GDBUF0+736H
;
;// 03.06.03 //		LDA	#mizu26
		INC	A
		STA	>GDBUF0+738H
		RTS
;
;
GOPTN3C		EQU	$
GOPTN3D		EQU	$
GOPTN3E		EQU	$
GOPTN3F		EQU	$
		RTS
GOPTN40		EQU	$
GOPTN41		EQU	$
GOPTN48		EQU	$
GOPTN49		EQU	$
		LDA	#umgt10
		STA	>GDBUF0+0494H
		STA	>GDBUF0+0514H
		STA	>GDBUF0+0594H
;// 03.06.03 //		LDA	#umgt11
		INC	A
		STA	>GDBUF0+0496H
		STA	>GDBUF0+0516H
		STA	>GDBUF0+0596H
;// 03.06.03 //		LDA	#umgtu0
		INC	A
		STA	>GDBUF0+0614H
;// 03.06.03 //		LDA	#umgtu1
		INC	A
		STA	>GDBUF0+0616H
;// 03.06.03 //		LDA	#umgtu2
		INC	A
		STA	>GDBUF0+0692H
;// 03.06.03 //		LDA	#umgtu3
		INC	A
		STA	>GDBUF0+0694H
;// 03.06.03 //		LDA	#umgtu4
		INC	A
		STA	>GDBUF0+0696H
;// 03.06.03 //		LDA	#umgtu5
		INC	A
		STA	>GDBUF0+0698H
;// 03.06.03 //		LDA	#umgtu6
		INC	A
		STA	>GDBUF0+0712H
;// 03.06.03 //		LDA	#umgtu7
		INC	A
		STA	>GDBUF0+0714H
;// 03.06.03 //		LDA	#umgtu8
		INC	A
		STA	>GDBUF0+0716H
;// 03.06.03 //		LDA	#umgtu9
		INC	A
		STA	>GDBUF0+0718H
		RTS
;
GOPTN42		EQU	$
GOPTN43		EQU	$
GOPTN44		EQU	$
GOPTN45		EQU	$
GOPTN46		EQU	$
GOPTN47		EQU	$
GOPTN4A		EQU	$
GOPTN4B		EQU	$
GOPTN4C		EQU	$
GOPTN4D		EQU	$
GOPTN4E		EQU	$
GOPTN4F		EQU	$
GOPTN50		EQU	$
GOPTN51		EQU	$
GOPTN52		EQU	$
GOPTN53		EQU	$
GOPTN54		EQU	$
GOPTN55		EQU	$
GOPTN56		EQU	$
GOPTN57		EQU	$
		RTS
GOPTN58		EQU	$
GOPTN59		EQU	$
GOPTN60		EQU	$
GOPTN61		EQU	$
		LDA	#torid0
		STA	>GDBUF0+0BBCH
		STA	>GDBUF0+0BBEH
		STA	>GDBUF0+0BC0H
;// 03.06.18 //		LDA	#torid1
		INC	A
		STA	>GDBUF0+0C3CH
;// 03.06.18 //		LDA	#torid2
		INC	A
		STA	>GDBUF0+0C3EH
;// 03.06.18 //		LDA	#torid3
		INC	A
		STA	>GDBUF0+0C40H
;// 03.06.18 //		LDA	#torid4
		INC	A
		STA	>GDBUF0+0CBCH
;// 03.06.18 //		LDA	#torid5
		INC	A
		STA	>GDBUF0+0CBEH
;// 03.06.18 //		LDA	#torid6
		INC	A
		STA	>GDBUF0+0CC0H
;// 03.06.18 //		LDA	#torid7
		INC	A
		STA	>GDBUF0+0DC3CH
;// 03.06.18 //		LDA	#torid8
		INC	A
		STA	>GDBUF0+0DC3EH
;// 03.06.18 //		LDA	#torid9
		INC	A
		STA	>GDBUF0+0DC40H
		RTS
;
GOPTN5A		EQU	$
GOPTN5B		EQU	$
GOPTN5C		EQU	$
GOPTN5D		EQU	$
GOPTN5E		EQU	$
GOPTN5F		EQU	$
GOPTN62		EQU	$
GOPTN63		EQU	$
GOPTN64		EQU	$
GOPTN65		EQU	$
GOPTN66		EQU	$
GOPTN67		EQU	$
GOPTN68		EQU	$
GOPTN69		EQU	$
GOPTN6A		EQU	$
GOPTN6B		EQU	$
GOPTN6C		EQU	$
GOPTN6D		EQU	$
GOPTN6E		EQU	$
GOPTN6F		EQU	$
GOPTN70		EQU	$
GOPTN71		EQU	$
GOPTN72		EQU	$
GOPTN73		EQU	$
GOPTN74		EQU	$
GOPTN75		EQU	$
GOPTN76		EQU	$
GOPTN77		EQU	$
GOPTN78		EQU	$
GOPTN79		EQU	$
GOPTN7A		EQU	$
;;;;;;;GOPTN7B		EQU	$
GOPTN7C		EQU	$
GOPTN7D		EQU	$
GOPTN7E		EQU	$
GOPTN7F		EQU	$
GOPTN80		EQU	$
		RTS
GOPTN81		EQU	$
		LDA	#taki00
		STA	>GDBUF0+06CH
;// 03.06.03 //		LDA	#taki01
		INC	A
		STA	>GDBUF0+06EH
;// 03.06.03 //		LDA	#taki02
		INC	A
		STA	>GDBUF0+070H
;// 03.06.03 //		LDA	#taki03
		INC	A
		STA	>GDBUF0+072H
		STA	>GDBUF0+074H
		STA	>GDBUF0+076H
		STA	>GDBUF0+078H
;// 03.06.03 //		LDA	#taki04
		INC	A
		STA	>GDBUF0+07AH
;// 03.06.03 //		LDA	#taki05
		INC	A
		STA	>GDBUF0+07CH
;// 03.06.03 //		LDA	#taki06
		INC	A
		STA	>GDBUF0+07EH
;
;// 03.06.03 //		LDA	#taki07
		INC	A
		STA	>GDBUF0+0EEH
;// 03.06.03 //		LDA	#taki08
		INC	A
		STA	>GDBUF0+0F0H
;// 03.06.03 //		LDA	#taki09
		INC	A
		STA	>GDBUF0+0F2H
		STA	>GDBUF0+0F6H
;// 03.06.03 //		LDA	#taki0A
		INC	A
		STA	>GDBUF0+0F4H
		STA	>GDBUF0+0F8H
;// 03.06.03 //		LDA	#taki0B
		INC	A
		STA	>GDBUF0+0FAH
;// 03.06.03 //		LDA	#taki0C
		INC	A
		STA	>GDBUF0+0FCH
;
;// 03.06.03 //		LDA	#taki0D
		INC	A
		STA	>GDBUF0+170H
;// 03.06.03 //		LDA	#taki0E
		INC	A
		STA	>GDBUF0+172H
;// 03.06.03 //		LDA	#taki0F
		INC	A
		STA	>GDBUF0+174H
;// 03.06.03 //		LDA	#taki10
		INC	A
		STA	>GDBUF0+176H
;// 03.06.03 //		LDA	#taki11
		INC	A
		STA	>GDBUF0+178H
;// 03.06.03 //		LDA	#taki12
		INC	A
		STA	>GDBUF0+17AH
		RTS
;
GOPTN82		EQU	$
GOPTN83		EQU	$
GOPTN84		EQU	$
GOPTN85		EQU	$
GOPTN86		EQU	$
GOPTN87		EQU	$
GOPTN88		EQU	$
GOPTN89		EQU	$
GOPTN8A		EQU	$
GOPTN8B		EQU	$
GOPTN8C		EQU	$
GOPTN8D		EQU	$
GOPTN8E		EQU	$
GOPTN8F		EQU	$
GOPTN90		EQU	$
GOPTN91		EQU	$
GOPTN92		EQU	$
GOPTN93		EQU	$
GOPTN94		EQU	$
GOPTN95		EQU	$
GOPTN96		EQU	$
GOPTN97		EQU	$
GOPTN98		EQU	$
GOPTN99		EQU	$
GOPTN9A		EQU	$
GOPTN9B		EQU	$
GOPTN9C		EQU	$
GOPTN9D		EQU	$
GOPTN9E		EQU	$
GOPTN9F		EQU	$
GOPTNA0		EQU	$
GOPTNA1		EQU	$
GOPTNA2		EQU	$
GOPTNA3		EQU	$
GOPTNA4		EQU	$
GOPTNA5		EQU	$
GOPTNA6		EQU	$
GOPTNA7		EQU	$
GOPTNA8		EQU	$
GOPTNA9		EQU	$
GOPTNAA		EQU	$
GOPTNAB		EQU	$
GOPTNAC		EQU	$
GOPTNAD		EQU	$
GOPTNAE		EQU	$
GOPTNAF		EQU	$
GOPTNB0		EQU	$
GOPTNB1		EQU	$
GOPTNB2		EQU	$
GOPTNB3		EQU	$
GOPTNB4		EQU	$
GOPTNB5		EQU	$
GOPTNB6		EQU	$
GOPTNB7		EQU	$
GOPTNB8		EQU	$
GOPTNB9		EQU	$
GOPTNBA		EQU	$
GOPTNBB		EQU	$
GOPTNBC		EQU	$
GOPTNBD		EQU	$
GOPTNBE		EQU	$
GOPTNBF		EQU	$
		RTS
;
;
;
;
;
;
		END
