;************************************************************************
;*	    Super Famicom Polygon Shape Data for ZELDA			*
;*						[ Mar.04, 1991 ]	*
;************************************************************************

		extend

;;;;Object_Shape	sect		rel
;;;;PACKAGE		group		Object_Shape

;===============  Cross Definition  =====================================

		global		_SHAPES

;************************************************************************
;*	_SHAPES : Shape structure					*
;*									*
;*		byte		number  of points , number  of faces	*
;*		word		pointer of points , pointer of faces 	*
;************************************************************************
;
;
		ORG		1EF795H
;
;
_SHAPES		equ		$
;------------------------------------------------------------------------
cube		byte		8,6
		word		cube_points,cube_faces
triangle	byte		6,5
		word		triangle_points,triangle_faces
tetrahedron	byte		4,4
		word		tetra_points,tetra_faces
pyramid		byte		5,5
		word		pyramid_points,pyramid_faces
octahedron	byte		6,8
		word		octa_points,octa_faces
sixteen		byte		10,16
		word		sixteen_points,sixteen_faces
pentagon	byte		10,7
		word		penta_points,penta_faces
fourteen	byte		12,14
		word		fourteen_points,fourteen_faces
SFX_character	byte		36,11
		word		SFX_points,SFX_faces
triforce	byte		6,3
		word		triforce_points,triforce_faces
test		byte		12,12
		word		test_points,test_faces
star_5		byte		10,3
		word		star_5_points,star_5_faces

;************************************************************************
;*		cube datas						*
;************************************************************************

cube_points	byte		-30,-30,-30
		byte		-30, 30,-30
		byte		 30, 30,-30
		byte		 30,-30,-30
		byte		-30,-30, 30
		byte		-30, 30, 30
		byte		 30, 30, 30
		byte		 30,-30, 30

cube_faces	byte		4,0,1,2,3,3
		byte		4,1,5,6,2,2
		byte		4,5,4,7,6,3
		byte		4,4,0,3,7,5
		byte		4,4,5,1,0,1
		byte		4,3,2,6,7,4

;************************************************************************
;*		triangle datas						*
;************************************************************************

triangle_points	byte		-35,-25,-20
		byte		-35, 25,-20
		byte		 35, 25,-20
		byte		 35,-25,-20
		byte		  0, 25, 40
		byte		  0,-25, 40

triangle_faces	byte		4,0,1,2,3,12
		byte		4,5,4,1,0,14
		byte		4,3,2,4,5,13
		byte		3,1,4,2,11
		byte		3,0,3,5,15

;************************************************************************
;*		tetrahedron datas					*
;************************************************************************

tetra_points	byte		  0,-20, 40
		byte		-35,-20,-20
		byte		 35,-20,-20
		byte		  0, 40,  0

tetra_faces	byte		3,0,1,2,6
		byte		3,0,3,1,8
		byte		3,0,2,3,7
		byte		3,1,3,2,9

;************************************************************************
;*		pyramid datas						*
;************************************************************************

pyramid_points	byte		  0, 40,  0
		byte		-35,-20,-35
		byte		-35,-20, 35
		byte		 35,-20, 35
		byte		 35,-20,-35

pyramid_faces	byte		3,0,1,2,3
		byte		3,0,2,3,4
		byte		3,0,3,4,2
		byte		3,0,4,1,1
		byte		4,4,3,2,1,5

;************************************************************************
;*		octahedron datas					*
;************************************************************************

octa_points	byte		  0, 50,  0
		byte		-35,  0,-35
		byte		-35,  0, 35
		byte		 35,  0, 35
		byte		 35,  0,-35
		byte		  0,-50,  0

octa_faces	byte		3,0,1,2,3
		byte		3,0,2,3,4
		byte		3,0,3,4,2
		byte		3,0,4,1,1
		byte		3,5,2,1,8
		byte		3,5,3,2,9
		byte		3,5,4,3,7
		byte		3,5,1,4,6

;************************************************************************
;*		sixteen datas						*
;************************************************************************

sixteen_points	byte		  0, 50,  0
		byte		  0,-50,  0
		byte		  0,  0, 50
		byte		 35,  0, 35
		byte		 50,  0,  0
		byte		 35,  0,-35
		byte		  0,  0,-50
		byte		-35,  0,-35
		byte		-50,  0,  0
		byte		-35,  0, 35

sixteen_faces	byte		3,3,0,2,1
		byte		3,4,0,3,2
		byte		3,5,0,4,3
		byte		3,6,0,5,4
		byte		3,7,0,6,5
		byte		3,8,0,7,4
		byte		3,9,0,8,3
		byte		3,2,0,9,2
		byte		3,2,1,3,6
		byte		3,3,1,4,7
		byte		3,4,1,5,8
		byte		3,5,1,6,9
		byte		3,6,1,7,10
		byte		3,7,1,8,9
		byte		3,8,1,9,8
		byte		3,9,1,2,7

;************************************************************************
;*		twelve datas						*
;************************************************************************

penta_points	byte		  0, 30, 45
		byte		 43, 30, 13
		byte		 27, 30,-36
		byte		-27, 30,-36
		byte		-43, 30, 13
		byte		  0,-30, 45
		byte		 43,-30, 13
		byte		 27,-30,-36
		byte		-27,-30,-36
		byte		-43,-30, 13

penta_faces	byte		5,0,1,2,3,4,7
		byte		5,5,9,8,7,6,7
		byte		4,0,5,6,1,11
		byte		4,1,6,7,2,12
		byte		4,2,7,8,3,13
		byte		4,3,8,9,4,12
		byte		4,4,9,5,0,13

;************************************************************************
;*		fourteen datas						*
;************************************************************************

fourteen_points	byte		  0, 42,-42
		byte		 42,  0,-42
		byte		  0,-42,-42
		byte		-42,  0,-42
		byte		  0, 42, 42
		byte		 42,  0, 42
		byte		  0,-42, 42
		byte		-42,  0, 42
		byte		 42, 42,  0
		byte		 42,-42,  0
		byte		-42, 42,  0
		byte		-42,-42,  0

fourteen_faces	byte		4,0,1,2,3,6
		byte		4,7,6,5,4,7
		byte		4,8,5,9,1,8
		byte		4,10,3,11,7,9
		byte		4,4,8,0,10,8
		byte		4,6,11,2,9,7

		byte		3,0,8,1,1
		byte		3,8,4,5,2
		byte		3,4,10,7,3
		byte		3,10,0,3,4

		byte		3,3,2,11,11
		byte		3,1,9,2,12
		byte		3,5,6,9,13
		byte		3,7,11,6,14

;****************************************************************
;*		SFX character datas				*	
;****************************************************************

SFX_points	byte		-56, 32,0
		byte		-60, 24,0
		byte		-60,  0,0
		byte		-56, -8,0
		byte		-40, -8,0
		byte		-40,-16,0
		byte		-60,-16,0
		byte		-60,-32,0
		byte		-28,-32,0
		byte		-24,-24,0
		byte		-24,  0,0
		byte		-28,  8,0
		byte		-44,  8,0
		byte		-44, 16,0
		byte		-24, 16,0
		byte		-24, 32,0
		byte		 16, 32,0
		byte		-20, 32,0
		byte		-20,-32,0
		byte		 -4,-32,0
		byte		 -4, -8,0
		byte		  8, -8,0
		byte		  8,  8,0
		byte		 -4,  8,0
		byte		 -4, 16,0
		byte		 16, 16,0
		byte		 20, 32,0
		byte		 40, 32,0
		byte		 28,  0,0
		byte		 52,  0,0
		byte		 60,-32,0
		byte		 40,-32,0
		byte		 44, 32,0
		byte		 60, 32,0
		byte		 36,-32,0
		byte		 20,-32,0

SFX_faces	byte		128+4,0,15,14,13,1+5*16
		byte		128+6,0,13,12,3,2,1,1+5*16
		byte		128+4,12,11,4,3,1+5*16
		byte		128+6,8,5,4,11,10,9,1+5*16
		byte		128+4,8,7,6,5,1+5*16
		byte		128+4,19,18,17,24,6+10*16
		byte		128+4,23,22,21,20,6+10*16
		byte		128+4,17,16,25,24,6+10*16
		byte		128+3,26,27,28,11+15*16
		byte		128+3,29,30,31,11+15*16
		byte		128+4,32,33,34,35,11+15*16

;************************************************************************
;*		Triforce datas						*
;************************************************************************

triforce_points	byte		  0, 60, 0
		byte		 26, 15, 0
		byte		 52,-30, 0
		byte		  0,-30, 0
		byte		-52,-30, 0
		byte		-26, 15, 0

triforce_faces	byte		128+3,0,1,5,11+14*16
		byte		128+3,1,2,3,11+14*16
		byte		128+3,5,3,4,11+14*16

;************************************************************************
;*		test datas						*
;************************************************************************

test_points	byte		-030,0030,-010
		byte		-010,0030,-010
		byte		-010,-010,-010
		byte		-030,-030,-010
		byte		-030,0030,0010
		byte		-010,0030,0010
		byte		-010,-010,0010
		byte		-030,-030,0010
		byte		0030,-010,-010
		byte		0030,-010,0010
		byte		0030,-030,0010
		byte		0030,-030,-010

test_faces	byte		004h,000h,001h,002h,003h,001h
		byte		004h,005h,004h,007h,006h,002h
		byte		004h,001h,005h,006h,002h,003h
		byte		004h,004h,000h,003h,007h,004h
		byte		004h,004h,005h,001h,000h,005h
		byte		004h,002h,008h,00bh,003h,003h
		byte		004h,009h,006h,007h,00ah,004h
		byte		004h,006h,009h,008h,002h,005h
		byte		004h,003h,00bh,00ah,007h,006h
		byte		004h,008h,009h,00ah,00bh,006h
		byte		004h,003h,002h,006h,007h,006h
		byte		004h,003h,002h,006h,007h,006h

;************************************************************************
;*		star 5 datas						*
;************************************************************************

star_5_points	EQU	$
		BYTE		0000,0060,0000			;0
		BYTE		0020,0020,0000			;1
		BYTE		0060,0020,0000			;2
		BYTE		0025,0000,0000			;3
		BYTE		0040,-040,0000			;4
		BYTE		0000,-020,0000			;5
		BYTE		-040,-040,0000			;6
		BYTE		-025,0000,0000			;7
		BYTE		-060,0020,0000			;8
		BYTE		-020,0020,0000			;9

star_5_faces	EQU	$
		BYTE		083H,009H,002H,006H,021H
		BYTE		083H,001H,004H,008H,021H
		BYTE		083H,003H,006H,000H,021H

		end
