;************************************************************************
;*									*
;*	title name	: "tensai BAKABON"				*
;*	proccess	: system main					*
;*	file name	: m5main					*
;*									*
;************************************************************************
;
;
	include		ztmacro.asm
	include		ztram.asm
;
;
;------------------------------------------------------------------------
;-	global symbol							-
;------------------------------------------------------------------------
;
;------------------------------------------------------------------------
;-	extern symbol							-
;------------------------------------------------------------------------
;
;
;------------------------------------------------------------------------
;-	define symbol							-
;------------------------------------------------------------------------
;	EQU
;
;
;************************************************************************
;*									*
;*	program start							*
;*									*
;************************************************************************
;
;
	ORG	008000H
;
;
	EXTEND
;
;
;****************************************************************
;*	reset routine						*
;****************************************************************
;
	EMULATION
;
GSTART	EQU	$
	SEI			;IRQ   disable
	STZ	4200H		;NMI      "
	STZ	420BH		;DMA      "
	STZ	420CH		;H-DMA    "
	STZ	2140H		;sound port reset
	STZ	2141H		;       "
	STZ	2142H		;       "
	STZ	2143H		;       "
	LDA	#10000000B	;branking "ON"
	STA	2100H
;
	NATIVE
;
	CLC			;set native mode
	XCE			;
;
	MI16
;
	LDA	#0000H		;direct register set( 000~0ff )
	TCD
	LDA	#01FFH		;stack pointer set
	TCS
;
;----------------------------------------------------------------
;-      reset start intial set	                                -
;----------------------------------------------------------------
	LDA	#00000011B	;OBJ intial set
	STA	2101H
;;;;	LDA	#01		;[ !=0 ]
	STA	<NMIFLG
	STZ	!MODENO		;move no. set( intial )
;
;
;****************************************************************
;*	Main routine						*
;****************************************************************
;
GST100	EQU	$
	LDA	<NMIFLG
	BEQ	GST100		;NMI end ? ( no:GST100 )
;
	CLI			;IRQ "ON" !!
	INC	<FRCNT		;frame counter set
	JSR	MOVE		;[ move ]
;
	STZ	<NMIFLG		;NMI flag clear 
	BRA	GST100
;
;****************************************************************
;*      NMI routine	                                        *
;****************************************************************
;
INTSUB	EQU	$
;
	MEM16
	IDX16
	REP	#00111000B		;[hex] <-- [dec]
;
	PHA
	PHX
	PHY
	PHD
	PHB
;
	LDA	#0000H		;(D) set
	TCD
	PHK			;(DBR) set
	PLB
;
	MI8
;
	LDA	4210H		;NMI status reset
;
;------ NMI intial --------------------------------------
	LDA	#10000000B	;branking "ON" 
	STA	2100H
	STZ	420CH		;H-DMA disable
;
	LDA	!BG1SCF		;BG1 screen status flag set
	STA	2107H
	LDA	!BG2SCF		;BG2          "
	STA	2108H
	LDA	!BG3SCF		;BG3          "
	STA	2109H
	LDA	!BG4SCF		;BG4          "
	STA	210AH
;
	LDA	!WIND23		;window "ON/OFF" set
	STA	2123H	
	LDA	!WIND24		
	STA	2124H
	LDA	!WIND25	
	STA	2125H
	LDA	!WIND30		;color window "ON/OFF" set
	STA	2130H
;
	LDA	!SUBADF		;main & sub add set
	STA	2131H
	LDA	!BGMODE		;BG mode set
	STA	2105H
;
	LDA	<NMIFLG	
	BNE	INT010		;time over ? ( yes:INT010 )
;
;------ NMI move ----------------------------------------
	INC	<NMIFLG		;NMI flag "ON"
;
;------ DMA set -----------------------------------------
	JSR	COLDMA		;color DMA set
	JSR	VMADSP		;BG write
	JSR	OBJDMA		;OBJ DMA set
;
;------ controller input --------------------------------
	JSR	CONT2		;controller read
;
	LDA	#10000001B	;NMI enable
	STA	4200H
INT010	EQU	$
;------ scroll counter set ------------------------------
	LDA	<SCCH1		;BG1_H
	STA	210DH
	LDA	<SCCH1+1
	STA	210DH
	LDA	<SCCV1		; " _V
	STA	210EH
	LDA	<SCCV1+1
	STA	210EH
	LDA	<SCCH2		;BG2_H
	STA	210FH
	LDA	<SCCH2+1	
	STA	210FH
	LDA	<SCCV2		; " _V
	STA	2110H
	LDA	<SCCV2+1
	STA	2110H
	LDA	<SCCH3		;BG3_H
	STA	2111H
	LDA	<SCCH3+1
	STA	2111H
	LDA	<SCCV3		; " _V
	STA	2112H
	LDA	<SCCV3+1
	STA	2112H
	LDA	<SCCH4		;BG4_H
	STA	2113H
	LDA	<SCCH4+1
	STA	2113H
	LDA	<SCCV4		; " _V
	STA	2114H
	LDA	<SCCV4+1
	STA	2114H
;
;------ NMI end set -------------------------------------
	LDA	!FADNO		;fade set
	STA	2100H
	LDA	!HD420C		;H-DMA flag set
	STA	420CH
;
;------ polygon task change -----------------------------
INT020	EQU	$
;
	MI16
;
	PLB
	PLD
	PLY
	PLX
	PLA
;
RTISUB	EQU	$
	RTI
;
	MEM8
	IDX8
;
;****************************************************************
;*      IRQ routine	                                        *
;****************************************************************
;
IRQSUB	EQU	$
	RTI
;
;
;****************************************************************
;*	BG write 						*
;****************************************************************
VTABLE	EQU	$
VTB00	LWORD	VRAMD+2
VTB01	LWORD	VRCLDT
VTB02	LWORD	MMJIWT
;
VTCL	EQU	VTB01-VTABLE
bgw2	EQU	VTB01-VTABLE
;
;----------------------------------------------------------------
;-	VRAM clear  						-
;----------------------------------------------------------------
VRCLDT	EQU	$
	WORD	3000H,47FFH
	WORD	20FFH
	WORD	2000H,47FFH
	WORD	01BCH
	WORD	0FFFFH
;
VRAMCL	EQU	$
	JSR	BLNKON		;branking "ON"
;
;------ OAM intial ----------------------------------------------
	STZ	OAMROT		;OAM priority rotation set ( 000H~ )
	LDA	#VTCL
	STA	<VRFLG
;	
;----------------------------------------------------------------
;-	BG write  						-
;----------------------------------------------------------------
VMADSP	EQU	$
;
	I16
;
	LDY	<VRFLG
	LDX	!VTABLE,Y	;BG data address(L) set
	LDA	!VTABLE+2,Y	;       "       (B) set
	JSR	VRAMTR		;VRAM write
;
	IDX8
;
	LDA	<VRFLG
	BNE	VMD010		;VRAMD write ? ( no:VMD010 )
;
	STA	!VRAMD
	STA	!VRAMD+1
	DEC	A		;[ LDA	#0FFFFH ]
	STA	!VRAMD+3
VMD010	EQU	$
	STZ	<VRFLG
	RTS
;
;************************************************************************
;*		Message Moji character write		(MMJIWT)	*
;************************************************************************
MMJIWT		EQU	$
		IDX16
		REP	#00010000B	; index 16bit mode
;
		LDA	#10000000B
		STA	2115H		; Vram address auto inc.
		LDX	#01801H
		STX	4300H		; inc. mode & B-bus address set
;
		LDY	#07C00H
		STY	2116H		; Vram address set
;
		LDY	#MOJIBUF
		STY	4302H		; A-bus address (L,H)
		LDA	#BANK MOJIBUF
		STA	4304H		; A-bus address (B)
		LDX	#00010H*120
		STX	4305H		; data count
		LDA	#00000001B
		STA	420BH		; HEAD DMA on!!
;
		IDX8
		SEP	#00010000B	; index 8bit mode
;
		STZ	!GMAPDF
		RTS
;
;****************************************************************
;*	color DMA  						*
;****************************************************************
CTABLE	EQU	$
CTB00	LWORD	CRAMD+1		;[0]
CTB01	LWORD	WKCGRM		;[1] BG2 & BG3 C.G fade
;
CT01	EQU	CTB01-CTABLE
;
COLDMA	EQU	$
	LDY	!CGFLG
	LDA	!CTABLE+2,Y	;data address(B) set
	STA	4320H+4
	STA	<WORK+2		;work address(B)
	STZ	<WORK+1		;      "     (H)
	STZ	<WORK		;      "     (L)
	STZ	<WORK+4		;[ to 16 bit mode ]
	LDA	!CTABLE+1,Y	;data address(L,H)
	XBA
	LDA	!CTABLE,Y
;
	I16
;
	TAY
	LDX	#00000000B+(22H*100H)	;inc mode & B bus address
	STX	4320H
CLDM10	EQU	$
	LDA	[<WORK],Y
	BEQ	CLDM20	;end ? ( yes:CLDM20 )
;
	STA	4320H+5		;number of byte
	STA	<WORK+3		;(WK3) <-- "
	STZ	4320H+6
	INY
	LDA	[<WORK],Y	;C.G ram address set
	STA	2121H
;
	M16
;
	INY
	TYA			;data address(L,H) set
	STA	4320H+2
	CLC
	ADC	<WORK+3
	TAY
;
	M8
;
	LDA	#00000100B	;DMA "ON"
	STA	420BH
	BRA	CLDM10
;
CLDM20	EQU	$
;
	I8
;
	LDA	!CGFLG
	BNE	CLDM30
;
	STZ	!CRAMD	;pointer reset 
	STZ	!CRAMD	;end code set
CLDM30	EQU	$
	STZ	!CGFLG
;
;----------------------------------------------------------------
;-	constant color set					-
;----------------------------------------------------------------
	LDA	!NUKCOL		;[ red ]
	AND	#00011111B
	ORA	#00100000B
	STA	2132H
;
	M16
;
	LDA	!NUKCOL		;[ green ]
	LSR	A
	LSR	A
;
	M8
;
	LSR	A
	LSR	A
	LSR	A
	AND	#00011111B
	ORA	#01000000B
	STA	2132H
;
	LDA	!NUKCOL+1	;[ blue ]
	LSR	A
	LSR	A
	ORA	#10000000B
	STA	2132H
	RTS
;
;****************************************************************
;*	OBJ DMA		                                        *
;****************************************************************
;
OBJDMA	EQU	$
	STZ	4300H	;DMA control parameter
;
	M16
;
	STZ	2102H	;OAM address set ( 00~ )
;
	LDA	#04+((OAM&0000FFH)*100H)			;DMA B bus address & A bus address(L)
	STA	4301H
	LDA	#((OAM&00FF00H)/100H)+((OAM&0FF0000H)/100H) 	;DMA A bus address(H,B)
	STA	4303H
	LDA	#0220H		;DMA number of byte
	STA	4305H
	LDY	#00000001B	;DMA ch "ON"
	STY	420BH
;
	M8
;
	LDA	#10000000B	;OAM rotation set
	STA	2103H
	LDA	!OAMROT
	STA	2102H
	RTS
;
;****************************************************************
;*      controller read                                         *
;****************************************************************
;
CONT2	EQU	$
	LDA	4212H
	LSR	A
	BCS	CONT2		;read ok ? ( no:CONT2 )
;
	MI16
;
	LDA	4218H		;1p controller
	AND	#1111111111110000B
	STA	!KEYA1L
	TAY
	EOR	!KEYABFL
	AND	!KEYA1L
	STA	!KEYA2L
	STY	!KEYABFL
;
	LDA	421AH		;2p controller
	AND	#1111111111110000B
	STA	!KEYB1L
	TAY
	EOR	!KEYBBFL
	AND	!KEYB1L
	STA	!KEYB2L
	STY	!KEYBBFL
;
	LDA	!KEYA1L		;move controller set
	STA	<KEYC1L
	LDA	!KEYA2L
	STA	<KEYC2L
;
	MI8
;
	RTS
;
;****************************************************************
;*	vram transfer sub					*
;*		in  : (X) <-- data address(L,H)			*
;*		      (A) <--       "     (B)			*
;****************************************************************
;
	IDX16
;
VRAMTR	EQU	$
	PHB			;(DBR) save
	PHA			;(DBR) <-- data bank
	PLB
	STA	<WORK		;(WK0) <-- data address(B)
;
	M16
;
VTR010	EQU	$
	LDY	!0000,X
	BPL	VTR020		;end ? ( no:VTR020 )
;
;------ end return ------------------------------
	SEP	#00110000B	;memory,index 8 bit mode set
	PLB
	RTS
;
VTR020	EQU	$
	LDA	!0002,X		;number 0f byte set
	AND	#01FFFH
	INC	A
	STA	<WORK+1		;(WK1,2) <-- number of byte
	STA	<WORK+3		;(WK3,4) <-- data index up add data
;
	LDA	#10000000B	
	BIT	!0002,X
	BPL	VTR030		;tate ? ( no:VTR030 )
;------ tate write set --------------------------
	LDA	#10000001B
VTR030	EQU	$
	STA	>2115H		;inc mode set
	STA	<WORK+5		;(WK5,6) <-- inc mode
	TYA
	STA	>2116H		;VRAM address set
;
	LDA	!0002,X
	AND	#0010000000000000B
	BEQ	VTR040		;VRAM read ? ( no:VTR040 )
;------ VRAM read -------------------------------
	LDA	#0003H		;(WK3,4) <-- data index up add data
	STA	<WORK+3
	LDA	!0004,X		;A bus address(L,H) set
	STA	>4302H
	LDA	!0005,X		;      "      (B) set
	STA	>4303H
	LDA	>2139H		;read intial
	LDA	#10000001B+(39H*100H)
	BRA	VTR060	
;
VTR040	EQU	$
	LDA	<WORK		;A bus address(B) set
	STA	>4304H
	LDY	#00000001B+(18H*100H)
	BVC	VTR050		;= data set ? ( no:VTR050 )
;------ = data set ------------------------------
	LSR	<WORK+1		;(number of byte)/2
	LDA	#0002H		;(WK3,4) <-- data index up add data
	STA	<WORK+3
	LDA	#00001000B+(19H*100H)	;control parameter & B bus address set
	STA	>4300H
	TXA			;A bus address(L,H) set
	CLC
	ADC	#0005H
	STA	>4302H
	LDA	<WORK+1		;number of byte set
	STA	>4305H
	LDA	#00000001B*100H	;DMA start
	STA	>420AH		;[ 420AH dummy ]
	LDA	<WORK+5
	AND	#01111111B
	STA	>2115H		;inc mode set
	LDA	!0000,X
	STA	>2116H		;VRAM address set
	LDY	#00001000B+(18H*100H)
VTR050	EQU	$
	TXA			;A bus address(L,H) set
	CLC
	ADC	#0004H
	STA	>4302H
	TYA
VTR060	EQU	$
	STA	>4300H		;control parameter & B bus address set
	LDA	<WORK+1		;number of byte set
	STA	>4305H
	LDA	#00000001B*100H	;DMA start
	STA	>420AH		;[ 420AH dummy ]
	TXA
	CLC
	ADC	#0004H		;[ not (C)=1 !! if (C)=1 then error data !! ]
	ADC	<WORK+3
	TAX
	JMP	VTR010	
;
	MEM8
	IDX8
;	
;****************************************************************
;*      ram clear	                                        *
;****************************************************************
;
RAMCLR	EQU	$
;
	MI16
;
	LDX	#01EFEH
RMC010	EQU	$
	STZ	<WORK,X
	DEX
	DEX
	BMI	RMC020
	CPX	#01FEH
	BNE	RMC010		;stack area ? ( no:RMC010 )
	LDX	#00FEH
	BRA	RMC010
;
RMC020	EQU	$
	LDA	#0000H
	STA	!VRAMD
	STZ	!CRAMD
	DEC	A		;[ LDA	#0FFFFH ]
	STA	!VRAMD+2
;
	MI8
;
	RTS
;
;****************************************************************
;*      BG mode set	                                        *
;****************************************************************
;
BGMDST	EQU	$
	STZ	2133H		;display intial set
	STZ	2106H		;mozaiku reset
;
	LDA	#00000000B
	STA	!BGMODE		;BG mode set( mode 0 )
;
	LDA	#01000011B
	STA	2107H		;BG1 screen address set
	STA	!BG1SCF
	LDA	#01010011B
	STA	2108H		;BG2        "
	STA	!BG2SCF
	LDA	#01000000B
	STA	2109H		;BG3        "
	STA	!BG3SCF
;;;;	LDA	#01000010B
	STA	210AH		;BG4        "
	STA	!BG4SCF
;
	LDA	#00100000B	
	STA	210BH		;BG1,2 chara address set
	LDA	#00000000B
	STA	210CH		;BG3,4      "
;
	LDA	#00000100B	
	STA	212CH		;main display select set
	LDA	#00000000B
	STA	212DH		;sub         "
	STZ	212EH
	LDA	#00000000B
	STA	212FH
;
;;;;	LDA	#11110000B
;;;;	STA	!WIND23		;BG1,2 window disable
;;;;	LDA	#10101111B
;;;;	STA	!WIND24		;BG3,4        "
;;;;	LDA	#11111111B	
;;;;	STA	!WIND25		;OBJ,color    "   
;;;;	LDA	#00100010B
	STZ	!WIND30		;color window "ON/OFF" set
;;;;	LDA	#00011110B
;;;;	STA	!SUBADF		;add & sub flag set
;;;;;
;;;;	STZ	212AH		;window logic
;;;;	LDA	#00000100B
;;;;	STA	212BH
;;;;;
	LDA	#10000000B	;mode 7 over flow set
	STA	211AH
	RTS
;
;****************************************************************
;*	H-DMA intial						*
;****************************************************************
;
INHDMA	EQU	$
	RTS
;	
;====== H-DMA parameter data ===================================
HDMAP0	EQU	$
;;;;	BYTE	01000010B	;DMA control parameter
	BYTE	01000000B	;DMA control parameter
;;;;	BYTE	10H		;    B bus address
	BYTE	2CH		;    B bus address
	BYTE	LOW  HDMADR0	;    A     "      (L)
	BYTE	HIGH HDMADR0	;          "      (H)
	BYTE	BANK HDMADR0	;          "      (B)
;
;;;;HDMADR0	EQU	$
	BYTE	80H+70H
	WORD	HDMABF
	BYTE	80H+70H
	WORD	HDMABF+(70H*2)
	BYTE	00H
;
HDMADR0	EQU	$
	BYTE	80H+08H		;line no.1 [ 00~07 ]
	WORD	HDMABF
	BYTE	80H+08H		;line no.2 [ 08~0F ]
	WORD	HDMABF
	BYTE	80H+08H		;line no.3 [ 10~17 ]
	WORD	HDMABF
	BYTE	80H+08H		;line no.4 [ 18~1F ]
	WORD	HDMABF
	BYTE	80H+08H		;line no.5 [ 20~27 ]
	WORD	HDMABF
	BYTE	80H+08H		;line no.6 [ 28~2F ]
	WORD	HDMABF
	BYTE	80H+08H		;line no.7 [ 30~37 ]
	WORD	HDMABF
	BYTE	80H+08H		;line no.8 [ 38~3F ]
	WORD	HDMABF
	BYTE	80H+08H		;line no.9 [ 40~47 ]
	WORD	HDMABF
	BYTE	80H+08H		;line no.A [ 48~4F ]
	WORD	HDMABF
	BYTE	80H+08H		;line no.B [ 50~57 ]
	WORD	HDMABF
	BYTE	80H+08H		;line no.C [ 58~5F ]
	WORD	HDMABF
	BYTE	80H+08H		;line no.D [ 60~67 ]
	WORD	HDMABF
	BYTE	80H+08H		;line no.E [ 48~4F ]
	WORD	HDMABF
	BYTE	80H+08H		;line no.F [ 50~57 ]
	WORD	HDMABF
	BYTE	80H+08H		;line no.G [ 58~5F ]
	WORD	HDMABF
	BYTE	80H+08H		;line no.H [ 60~67 ]
	WORD	HDMABF
	BYTE	80H+08H		;line no.I [ 68~6F ]
	WORD	HDMABF
	BYTE	80H+08H		;line no.J [ 70~77 ]
	WORD	HDMABF
	BYTE	80H+08H		;line no.K [ 70~7F ]
	WORD	HDMABF
	BYTE	80H+08H		;line no.L [ 80~87 ]
	WORD	HDMABF
	BYTE	80H+08H		;line no.M [ 88~8F ]
	WORD	HDMABF
	BYTE	80H+08H		;line no.N [ 90~97 ]
	WORD	HDMABF
	BYTE	80H+08H		;line no.O [ 98~9F ]
	WORD	HDMABF
	BYTE	80H+08H		;line no.P [ A0~A7 ]
	WORD	HDMABF
	BYTE	80H+08H		;line no.Q [ A8~AF ]
	WORD	HDMABF
	BYTE	80H+08H		;line no.R [ B0~B7 ]
	WORD	HDMABF
	BYTE	80H+08H		;line no.S [ B8~BF ]
	WORD	HDMABF
	BYTE	80H+08H		;line no.T [ C0~C7 ]
	WORD	HDMABF
	BYTE	80H+08H		;line no.U [ C8~CF ]
	WORD	HDMABF
	BYTE	80H+08H		;line no.V [ D0~D7 ]
	WORD	HDMABF
	BYTE	80H+08H		;line no.W [ D8~DF ]
	WORD	HDMABF
	BYTE	00H
;
;****************************************************************
;*      move play	                                        *
;****************************************************************
;
MOVE	EQU	$
	LDA	!MODENO
	ASL	A
	TAX
	JMP	(!MOVADR,X)
;
MOVADR	EQU	$
	WORD	RESTIN		;reset start intial
GMINT	WORD	FADEIN		;fade in & out
	WORD	GMINIT		;game intial
	WORD	FADEIN		;fade in & out
	WORD	GMPLAY		;  "  play
	WORD	GMPLAY1
;
GMIN	EQU	(GMINT-MOVADR)/2
;
;****************************************************************
;*      blanking "ON" 		                                *
;****************************************************************
;
BLNKON	EQU	$
	STZ	4200H		;NMI disable
	STZ	420CH		;H-DMA  "
	LDA	#10000000B	;blanking "ON"
	STA	2100H
	RTS
;
;****************************************************************
;*      reset start intial	                                *
;****************************************************************
;
RESTIN	EQU	$
	JSR	RAMCLR		;ram clear
	INC	!MODENO		;go to play !!
	INC	!MODENO		;     "
;
;****************************************************************
;*      game intial 		                                *
;****************************************************************
GMINIT	EQU	$
	JSR	VRAMCL		;VRAM clear
	JSR	BGMDST		;BG mode set
;
;
MODINC	EQU	$
	INC	!MODENO		;go to next mode 
;
;****************************************************************
;*      blanking "OFF" 		                                *
;****************************************************************
;
BLNKOF	EQU	$
	LDA	#10000001B	;NMI enable
	STA	4200H
	RTS
;
;****************************************************************
;*      game play		                                *
;****************************************************************
;
GMPLAY	EQU	$
	RTS
;
;****************************************************************
;*      game play		                                *
;****************************************************************
;
GMPLAY1	EQU	$
	RTS
;
;****************************************************************
;*	fade in & out						*
;****************************************************************
FADAD	EQU	$
	BYTE	001H,0FFH
FADCP	EQU	$
	BYTE	00FH,000H
;
FADEIN	EQU	$
	LDY	!FADMK
	LDA	!FADNO
	CLC
	ADC	!FADAD,Y
	STA	!FADNO
	CMP	!FADCP,Y
	BNE	FADI10		;fade in & out end ? ( no:FADI10 )
;
	TYA			;      "       change !!
	EOR	#01H
	STA	!FADMK
MDINC2	EQU	$
	INC	!MODENO
;
FADI10	EQU	$
	RTS
;
;****************************************************************
;*       game name                                              *
;****************************************************************
; 
	ORG	0FFC0H

	EXTEND
;
	IDX8
	MEM8
; 
	BYTE	053H,055H,050H,045H,052H,020H			   ;"SUPER "
	BYTE	04DH,041H,052H,049H,04FH,057H,04FH,052H,04CH,044H  ;"MARIOWORLD"
	BYTE	020H,020H,020H,020H,020H,020H			   ;"      "
	BYTE	002H,009H,001H,000H,001H,000H			   ;type data 
	BYTE	0FFH,0FFH,000H,000H				   ;check sum 
;
;****************************************************************
;*       Interrupt Vector                                       *
;****************************************************************
;
;======= native mode vector =====================================
;
	ORG	0FFE4H
;
	EXTEND
;
	MEM8
	IDX8
;
	WORD	RTISUB		;COP
;;;;	WORD	RTISUB		;BRK 
;
	ORG	0FFE8H
	EXTEND
	IDX8
	MEM8
	WORD	RTISUB		;Abort
	WORD	INTSUB		;NMI
	WORD	GSTART		;( ??? ) reset ?
	WORD	IRQSUB		;IRQ
; 
;======= emulation mode vector ===================================
; 
	ORG	0FFF4H
;
	EXTEND
;
	MEM8
	IDX8
; 
	WORD	RTISUB		;COP
	WORD	RTISUB		;( ??? )
	WORD	RTISUB		;Abort
	WORD	RTISUB		;NMI
	WORD	GSTART		;Reset
	WORD	RTISUB		;IRQ
;
	END
