;	NOLIST
;
;************************************************************************
;*                                                                      *
;*      title name      : "tensai BAKABON"                              *
;*      proccess        : ram name	                                *
;*      file name       : m5ram		                                *
;*                                                                      *
;************************************************************************
;
;
;
;
;****************************************************************
;*	0 page ram						*
;****************************************************************
;
;------	work --------------------------------------------		
WORK	EQU	000H	
WORK0	EQU	WORK
WORK1	EQU	WORK0+1
WORK2	EQU	WORK1+1
WORK3	EQU	WORK2+1
WORK4	EQU	WORK3+1
WORK5	EQU	WORK4+1
WORK6	EQU	WORK5+1
WORK7	EQU	WORK6+1
WORK8	EQU	WORK7+1
WORK9	EQU	WORK8+1
WORKA	EQU	WORK9+1
WORKB	EQU	WORKA+1
WORKC	EQU	WORKB+1
WORKD	EQU	WORKC+1
WORKE	EQU	WORKD+1
WORKF	EQU	WORKE+1
;
;------	system flag -------------------------------------
NMIFLG	EQU	WORK+10H	;NMI flag
IRQFLG	EQU	NMIFLG+1	;IRQ  "
VRFLG	EQU	IRQFLG+1	;BG write flag
FRCNT	EQU	VRFLG+2		;frame counter
;
;------ controller flag ---------------------------------
KEYC1L	EQU	FRCNT+1		;move controller(L)
KEYC1	EQU	KEYC1L+1	;       "       (H)
KEYC2L	EQU	KEYC1+1		;       "	(L) [ triger ]
KEYC2	EQU	KEYC2L+1	;       "       (H)  
;
;------ scroll counter ----------------------------------
SCCH1	EQU	KEYC2+1		;BG1_H
SCCV1	EQU	SCCH1+2		;   _V
SCCH2	EQU	SCCV1+2		;BG2_H
SCCV2	EQU	SCCH2+2		;   _V
SCCH3	EQU	SCCV2+2		;BG3_H
SCCV3	EQU	SCCH3+2		;   _V
SCCH4	EQU	SCCV3+2		;BG4_H
SCCV4	EQU	SCCH4+2		;   _V
;
;------ player ram --------------------------------------
PLXPS1	EQU	SCCV4+2		;player X pos(L)
PLXPS0	EQU	PLXPS1+1	;     "      (H)
PLYPS1	EQU	PLXPS0+1	;   "   Y pos(L)
PLYPS0	EQU	PLYPS1+1	;     "      (H)
;
PLDSX1	EQU	PLYPS0+1	;   "   display X pos(L)
PLDSX0	EQU	PLDSX1+1	;         "          (H)
PLDSY1	EQU	PLDSX0+1	;       "       Y pos(L)
PLDSY0	EQU	PLDSY1+1	;         "          (H)
;
PLXSPL	EQU	PLDSY0+1	;   "   X speed(L)
PLXSPD	EQU	PLXSPL+1	;       "      (H)
PLYSPL	EQU	PLXSPD+1	;   "   Y   "  (L)
PLYSPD	EQU	PLYSPL+1	;       "      (H)
;
PLXSDR	EQU	PLYSPD+1	;   "   X speed buffer ---+
PLJUMP	EQU	PLXSDR+1	;   "   jump flag         +-- ( +2 )
PLYSDR	EQU	PLJUMP+1	;   "   Y speed buffer ---+
PLSITD	EQU	PLYSDR+1	;   "   sit  flag
PLCMKI	EQU	PLSITD+1	;   "   chara muki
PLBGCR	EQU	PLCMKI+1	;   "   BG cross flag
;
PWRK00	EQU	PLBGCR+1	;   "   work.0
PWRK01	EQU	PWRK00+1	;     "     .1
PWRK02	EQU	PWRK01+1	;     "     .2
PWRK03	EQU	PWRK02+1	;     "     .3
;
;------ BG ram ------------------------------------------
SCMUKI	EQU	PWRK03+1	; scroll muki flag
;
;****************************************************************
;*	!=0 page ram						* 
;****************************************************************
;
;------ mode no. ----------------------------------------
MODENO	EQU	100H		;mode no.
;
;------ stack pointer -----------------------------------
STACK	EQU	MODENO+1	;stack area
;
;------ OAM ram -----------------------------------------
OAM	EQU	200H		;OAM main
OAMSUB	EQU	OAM+200H	; "  sub
OAMSB	EQU	OAMSUB+20H	;   "    work
;
POAM 	EQU	OAM+080H	;player OAM main
POAMSB	EQU	OAMSB+080H	;     "     sub work
;
OAM1	EQU	OAM+4		;OAM main.1
OAMSB1	EQU	OAMSB+4		; "  sub .1
OAM2	EQU	OAM+100H	;OAM main.2
OAMSB2	EQU	OAMSB+100H	; "  sub .2
;
;------ OAM along ram -----------------------------------
;
;------ H-DMA buffer ------------------------------------
HDMABF	EQU	OAMSB+200H	;H-DMA buffer
;
;------ color buffer ------------------------------------
NUKCOL	EQU	HDMABF+1C0H	;nuki color 
CGFLG	EQU	NUKCOL+2	;color write flag
CRAMD	EQU	CGFLG+1		;     "      buffer
;
;------ BG & OBJ flag -----------------------------------
BGMODE	EQU	CRAMD+080H	;BG mode
OAMROT	EQU	BGMODE+1	;OAM rotation flag
SUBADF	EQU	OAMROT+1	;main & sub add select flag
HD420C	EQU	SUBADF+1	;H-DMA "ON/OFF" flag
;
;------ window flag -------------------------------------
WIND23	EQU	HD420C+1	;window "ON/OFF" flag ( BG1,2 )
WIND24	EQU	WIND23+1 	;          "          ( BG3,4 )
WIND25	EQU	WIND24+1	;          "          ( OBJ,COLOR )
WIND30	EQU	WIND25+1	;color window "ON/OFF" flag
;
;------ controller flag ---------------------------------
KEYA1L	EQU	WIND30+1	;controller_1(L)
KEYA1	EQU	KEYA1L+1	;    "       (H)
KEYA2L	EQU	KEYA1+1 	;    "       (L) [ triger ]
KEYA2	EQU	KEYA2L+1	;    "       (H)
KEYB1L	EQU	KEYA2+1		;    "     _2(L)
KEYB1	EQU	KEYB1L+1	;    "       (H)
KEYB2L	EQU	KEYB1+1		;    "       (L) [ triger ]
KEYB2	EQU	KEYB2L+1	;    "       (H)
KEYABFL	EQU	KEYB2+1		;to triger check work_1(L)
KEYABF	EQU	KEYABFL+1	;          "           (H)
KEYBBFL	EQU	KEYABF+1 	;          "         _2(L)
KEYBBF	EQU	KEYBBFL+1	;          "           (H)
;
;------ fade flag ---------------------------------------
FADNO	EQU	KEYBBF+1	;fade no.
FADMK	EQU	FADNO+1		;  "  muki
;
;------ scroll move dot ---------------------------------
SC1MVX	EQU	FADMK+1		;BG1_H move dot
SC1MVY	EQU	SC1MVX+2	; " _V    "
SC2MVX	EQU	SC1MVY+2	;BG2_H    "
SC2MVY	EQU	SC2MVX+2	; " _V    "
SC3MVX	EQU	SC2MVY+2	;BG3_H    " 
SC3MVY	EQU	SC3MVX+2	; " _V    "
SC4MVX	EQU	SC3MVY+2	;BG4_H    "
SC4MVY	EQU	SC4MVX+2	; " _V    "
;
;------ BG screen status flag ---------------------------
BG1SCF	EQU	SC4MVY+2	;BG1 screen status
BG2SCF	EQU	BG1SCF+1	;BG2       "
BG3SCF	EQU	BG2SCF+1	;BG3       "
BG4SCF	EQU	BG3SCF+1	;BG4       "
;
;------ player ram --------------------------------------
PLWALK	EQU	BG4SCF+1	;player walk flag
PLSLIP	EQU	PLWALK+1	;   "   slip  "
PLBGNO	EQU	PLSLIP+1	;   "   cross BG no.
PLBPOW	EQU	PLBGNO+1	;   "   [B] power scale
PLMIDL	EQU	PLBPOW+1	;   "   middle flag ( 0:stand 7E:middle ) 
PLFLYF	EQU	PLMIDL+1	;   "   flying flag
PLFLST	EQU	PLFLYF+1	;      "       stop flag
PLANGL1	EQU	PLFLST+1	;      "       angle(l)
PLANGL	EQU	PLANGL1+1	;         "         (H)
PLANSP	EQU	PLANGL+1	;         "          speed
PLANMK	EQU	PLANSP+2	;         "          muki
PLROTF	EQU	PLANMK+1	;         "          rotation flag
PLFSPW	EQU	PLROTF+1	;         "          power counter
PLAMKC	EQU	PLFSPW+1	;         "          muki change flag
PLSTMF	EQU	PLAMKC+1	;         "          stop -> move flag
PLCANG	EQU	PLSTMF+1	;         "          chara angle
PLBREK	EQU	PLCANG+1	;         "          breaking flag
PLSMSP	EQU	PLBREK+1	;         "          stop <-> move spacial flag
PLCLMB	EQU	PLSMSP+1	;         "          climbing flag
PLCLUP	EQU	PLCLMB+1	;             "               up move flag
PLHANG	EQU	PLCLUP+1	;         "          hanging flag
PLHGCT	EQU	PLHANG+1	;         "          hanging flag
PLCAFL	EQU	PLHGCT+1	;         "          enemy catch flying flag
PLFLSW	EQU	PLCAFL+1	;      "       switch
PLDOOR	EQU	PLFLSW+1	;   "   door demo flag
PLDRMK	EQU	PLDOOR+1	;     "      muki
PLCOLR	EQU	PLDRMK+1	;   "   color no.
PLPATN	EQU	PLCOLR+1	;   "   pattern no.
;
PWRK10	EQU	PLPATN+2	;   "   work.10
PWRK11	EQU	PWRK10+1	;     "     .11
PWRK12	EQU	PWRK11+1	;     "     .12
PWRK13	EQU	PWRK12+1	;     "     .13
PWRK14	EQU	PWRK13+1	;     "     .14
PWRK15	EQU	PWRK14+1	;     "     .15
PWRK16	EQU	PWRK15+1	;     "     .16
PWRK17	EQU	PWRK16+1	;     "     .17
;
PWRK20	EQU	PWRK17+1	;   "   work.20
PWRK21	EQU	PWRK20+1	;     "     .21
PWRK22	EQU	PWRK21+1	;     "     .22
PWRK23	EQU	PWRK22+1	;     "     .23
PWRK24	EQU	PWRK23+1	;     "     .24
PWRK25	EQU	PWRK24+1	;     "     .25
PWRK26	EQU	PWRK25+1	;     "     .26
PWRK27	EQU	PWRK26+1	;     "     .27
;
PWRK30	EQU	PWRK27+1	;   "   work.20
PWRK31	EQU	PWRK30+1	;     "     .21
PWRK32	EQU	PWRK31+1	;     "     .22
PWRK33	EQU	PWRK32+1	;     "     .23
PWRK34	EQU	PWRK33+1	;     "     .24
PWRK35	EQU	PWRK34+1	;     "     .25
PWRK36	EQU	PWRK35+1	;     "     .26
PWRK37	EQU	PWRK36+1	;     "     .27
;
PWBX00	EQU	PWRK37+1	;   "   BG X pos(H).00
PWBX01	EQU	PWBX00+1	;         "        .01
PWBX02	EQU	PWBX01+1	;         "        .02
PWBX03	EQU	PWBX02+1	;         "        .03
PWBX04	EQU	PWBX03+1	;         "        .04
PWBX05	EQU	PWBX04+1	;         "        .05
PWBX06	EQU	PWBX05+1	;         "        .06
PWBX07	EQU	PWBX06+1	;         "        .07
;
PWBY00	EQU	PWBX07+1	;   "   BG Y pos(H).00
PWBY01	EQU	PWBY00+1	;         "        .01
PWBY02	EQU	PWBY01+1	;         "        .02
PWBY03	EQU	PWBY02+1	;         "        .03
PWBY04	EQU	PWBY03+1	;         "        .04
PWBY05	EQU	PWBY04+1	;         "        .05
PWBY06	EQU	PWBY05+1	;         "        .06
PWBY07	EQU	PWBY06+1	;         "        .07
;
PWBX10	EQU	PWBY07+1	;   "   BG X pos(L).00
PWBX11	EQU	PWBX10+1	;         "        .01
PWBX12	EQU	PWBX11+1	;         "        .02
PWBX13	EQU	PWBX12+1	;         "        .03
PWBX14	EQU	PWBX13+1	;         "        .04
PWBX15	EQU	PWBX14+1	;         "        .05
PWBX16	EQU	PWBX15+1	;         "        .06
PWBX17	EQU	PWBX16+1	;         "        .07
;
PWBY10	EQU	PWBX17+1	;   "   BG Y pos(L).00
PWBY11	EQU	PWBY10+1	;         "        .01
PWBY12	EQU	PWBY11+1	;         "        .02
PWBY13	EQU	PWBY12+1	;         "        .03
PWBY14	EQU	PWBY13+1	;         "        .04
PWBY15	EQU	PWBY14+1	;         "        .05
PWBY16	EQU	PWBY15+1	;         "        .06
PWBY17	EQU	PWBY16+1	;         "        .07
;
PCHNO0	EQU	PWBY17+1	;   "   chara DMA address(L,H,B,H2)
;
;------ enemy ram ---------------------------------------
CACHFG	EQU	PCHNO0+(4*8)	;enemy catch flag
CACHPT	EQU	CACHFG+1	;     "      muki change flag
CAKYFG	EQU	CACHPT+1	;     "      key check flag
SLOWFG	EQU	CAKYFG+1	;     "      slowing flag
;
;
;------ C.G buffer --------------------------------------
CGRAM	EQU	SLOWFG+1
;;;;	EQU	CGRAM+200H
;
;
;------ TEST --------------
CHRDFG	EQU	CGRAM+200H
CHANDF	EQU	CHRDFG+2
;;;;	EQU	CHANDF+2
CHARAM	EQU	CHANDF+2
;;;;;;	EQU	CHARAM+200H
GMAPDF	EQU	CHARAM+200H
;
;	
VRAMD	EQU	1000H
VRAMD1	EQU	1001H
VRAMD2	EQU	1002H
;
MESBUF	EQU	1300H
;
WNKEIS		EQU	1600H		; vram no adress low (keisan)
WNKEISH		EQU	1601H		;
WNADRS		EQU	1602H		; vram no adrwss low (moto)
WNADRSH		EQU	1603H		;
WIND_SYS	EQU	1604H		; jsrsub (0)w1 (1)w2 (2)s (3)c
MJISPD		EQU	1605H		; jsrsub moji speed syori
MJISPDBK	EQU	1606H		; mjispd BAK
WNWORK		EQU	1607H		; jsrsub slow window
INITAL		EQU	1608H		; jsrsub (0)inital (1)program
MOJIX		EQU	1609H		; moji data o totekuru tokoro l
MOJIXH		EQU	160AH		;
MJIDAT		EQU	160BH		; moji data o vramd you ni kaeu
MJIATR		EQU	160CH		; moji atori bute no hairu toko
MESBUFX		EQU	160DH		; mesbuf,x no x no hairutoko l
MESBUFH		EQU	160EH		; 
SCRLIN		EQU	160FH		; scrool line kazu
MSGWAIT		EQU	1610H		; jsrsub time wait L
MSGWAITH	EQU	1611H		;		   H
MSGCHCT		EQU	1612H		; messeg init char no count L
MSGCHCTH	EQU	1613H		;		   	    H
MSGCNT		EQU	1614H		; messeg hanyou cnt l
MSGCNTH		EQU	1615H		; messeg hanyou cnt h
ZURCNT		EQU	1616H		; messeg zure cnt
ZURCNTH		EQU	1617H		; messeg zure cnt
MSG_RTS		EQU	1618H
;					; 1619H -- 161FH msge yobi(zel_msge.asm in cls)
MSGENOL		EQU	1620H		; messeg NO. L.
MSGENOH		EQU	1621H		; messeg NO. H.
MSG_SU0		EQU	1622H		; messeg SUUGI 0,1
MSG_SU1		EQU	1623H		; messeg SUUGI 2,3
;
;========================================================
;=	polygon RAM					=
;========================================================
;;;;	EQU	1F00H ~ 1FFFH
;
;****************************************************************
;*      !=0 bank ram                                            *
;****************************************************************
;
;========================================================
;=	polygon RAM					=
;========================================================
;;;;	EQU	7E2000H ~ 7E27FFH
;
;--------------------------------------------------------
;-	OAM clear 					-
;--------------------------------------------------------
OAMCLR	EQU	7E2800H
;
;--------------------------------------------------------
;-	OAM sub change 					-
;--------------------------------------------------------
OAMCHG	EQU	OAMCLR+2+(128*3)+1
;
;------ BG write buffer ---------------------------------
;
;;;;;
;;;;;------ TEST buffer -------------------------------------
;;;;CHRDBF	EQU	VRAMD+200H
;;;;;
;
;---------------------------------------------------------------------
HDMAB0	EQU	7E0002H
HDMAB1	EQU	HDMAB0+8
;
;
MOJIBUF		EQU	7F0000H		; BG.3 message moji buffer
;
MJIBUF		EQU	MOJIBUF+120H*10H ; tenkai go no mesege 
;
MJPCBF		EQU	7F1F80H		; moji picture buffer
;
	LIST
;
