/************************************************************************
*									*
*	afRϐgf[^쐬						*
*									*
************************************************************************/

#include <math.h>
#include <stdio.h>
#include <ctype.h>

#define	unchar	unsigned char 
#define	unshort	unsigned short

#define	ON	1
#define	OFF	0

void cgx_read( char *s1,unchar *s2 );
void kage_cnv( unchar *s1 );
int kage_sub( unchar *s1,unchar (*s2)[2] );

void main( int argc,char **argv )
{

	/****** ram set ******/
	FILE	*fpw0;

	char	cgx_name[30];
	unchar	cgx_data[0x4000];

	/******	input data check *****/
	if( argc != 2 ){
		printf( "Usage: bg3shadow (CGX file)\n" );
		exit(1);
	}

	/****** CGX file read ******/
	strcpy( cgx_name,argv[1] );
	strcat( cgx_name,".CGX" );	
	cgx_read( cgx_name,cgx_data );

	/******	BG3 change data convert ******/
	kage_cnv( cgx_data );

}

/****************************************************************
*	bfwt@Cǂݍ					*
****************************************************************/

void cgx_read( char *s1,unchar *s2 )
{

	/****** ram set ******/
	FILE	*fp;

	int	i;

	/****** CGX file open ******/
	if( !(fp = fopen( s1,"r" )) ){
		printf( "can't open (%s) !!\n",s1 );
		exit(1);
	}

	/******	CGX data raed ******/
	for( i=0;i<0x4000;i++ ){
		if( feof( fp ) ){
			printf( "CGX file error !!\n" );
			exit(1);
		}
		*s2++ = fgetc( fp );
	}

	/****** CGX file close ******/
	fclose( fp );

}

/****************************************************************
*	afRϐgf[^ϊ					*
****************************************************************/

void kage_cnv( unchar *s1 )
{
	/******	ram set ******/
	FILE	*fp;

	int	high;
	unchar	kage_data[0x80][2];

	int	i,j,k;

	/****** BG3 change data file open ******/
	if( !(fp = fopen( "bg3shadow.dat","w" )) ){
		printf( "can't open (bg3shadow.dat) !!\n" );
		exit(1);
	}

	/******	BG3 change data make ******/
	for( i=0;i<0x4000;i+=0x1000 ){
		if( high = kage_sub( (s1+i+0xf0e),kage_data ) ){
			fprintf( fp,"\t\tHEX\t%02X\n",high );
			for( k=0;k<high;k++ ){
				fprintf( fp,"\t\tHEX\t%02X",(unchar)(kage_data[k][0] - 0x20));
				fprintf( fp,",%02X\n",kage_data[k][1] );
			}
			fprintf( fp,";\n" );
		}
	}

	/****** BG3 change data file close ******/
	fclose( fp );

}

/********************************************************
*	P̃f[^쐬				*
********************************************************/

int kage_sub( unchar *s1,unchar (*s2)[2] )
{
	/******	ram set ******/
	int	st,en,high;

	int	i,j,k,l;
	int	f;
	unchar	a;

	/******	data make ******/
        high = 0;
	for( i=0;i<16;i++ ){
		for( j=0;j<8;j++ ){
			st=0x40;
			en=0x40;
			for( f=0,k=0;k<0x80;k+=8 ){
				a = *s1;
				for( l=0;l<8;l++ ){
					switch( f ){
						case 0:
							if( a & 0x80 ){
								st   = k + l;
								en   = 0x80;
								high = (i*8)+j+1;
								f++;
							}
							break;

						case 1:
							if( !(a & 0x80) ){
								en = k + l;
								f++;
							}

						defualt :
							break;

					}
					a<<=1;
				}
				s1 += 0x10;
			}
			(*s2)[1] = en - st;				
			(*s2)[0] = ( ( 0x80 - (*s2)[1] ) / 2 ) - st + 0x20;				
			s2++;

			s1 -= (0x10*16)+2;
		}
		s1 -= 0x100-0x10;
	}

	return( high );

}
