/****************************************************************
*	chip OBJ rotation chara convert				*
****************************************************************/
#include <stdio.h>

#define unchar	unsigned char
#define unshort unsigned short

#define CHRMAX	256*256
#define CPCMAX	256*128

/****** main ram define ******/
unchar	fname0[20],fname1[20];
unchar	ch7buf[CHRMAX],cpcbuf[CPCMAX];

main( argc,argv )
int	argc;
char	**argv;
{
	/****** program start ******/
	if(argc != 2){
		printf("parameter error !!\n");
		exit(1);
	}
	strcpy(fname0,*(++argv));
	strcpy(fname1,fname0);
	strcat(fname0,".CH7");
	strcat(fname1,".CPC");

	dtread();
	dtconv();

}

/********************************************************
*	mode 7 chara read				*
********************************************************/
dtread()
{
	/****** ram define ******/
	FILE	*fpr;

	/******* file open ******/
	if((fpr=fopen(fname0,"r")) == 0){
		printf("can't open %s !!\n",fname0);
		exit(1);
	}

	if((fread( ch7buf,sizeof(unchar),CHRMAX,fpr)) == NULL ){
		printf("mode 7 chara read error !!\n");
	}

	fclose(fpr);

}

/********************************************************
*	chip OBJ rotation chara convert			*
********************************************************/
dtconv()
{
	/****** ram define ******/
	FILE	*fpw;
	int	wcnt;
	long	 i,j,k,l,m,n;

	/****** program start ******/
	if((fpw=fopen(fname1,"w")) == 0){
		printf("can't open %s !!\n",fname1);
		exit(1);
	}
	wcnt=0;
	for(n=0;n<(64*16*32);n+=(64*16*16)){
		for(i=n;i<(n+64*16*8);i+=(64*16)){
			for(j=i;j<(i+64);j+=8){
				for(k=j;k<(j+64*16*8*2);k+=(64*16*8)){
					for(l=k;l<(k+64*16);l+=64){
						for(m=l;m<(l+8);m++){
							cpcbuf[wcnt++] = ch7buf[m]&0x0f;
						}
					}
				}
			}
		}
	}

	wcnt=0;
	for(n=0;n<(64*16*32);n+=(64*16*16))
		for(i=n;i<(n+64*16*8);i+=(64*16))
			for(j=i;j<(i+64);j+=8)
				for(k=j;k<(j+64*16*8*2);k+=(64*16*8))
					for(l=k;l<(k+64*16);l+=64)
						for(m=l;m<(l+8);m++,wcnt++)
							cpcbuf[wcnt] = cpcbuf[wcnt] | ((ch7buf[m+0x8000]&0x0f)*0x10);

	if((fwrite( cpcbuf,sizeof(unchar),CPCMAX,fpw)) == NULL ){
		printf("chip OBJ rotation chara write error !!\n");
	}

	fclose(fpw);

	if((fpw=fopen("iwa.lis","w")) == 0){
		printf("can't open %s !!\n",fname1);
		exit(1);
	}
	fprintf(fpw,"\n");
	for(n=0;n<(256*128);n+=256*64){
		for(i=n;i<(n+64*4);i+=64){
			for(j=i;j<(i+(256*64));j+=256){
				for(k=j;k<(j+64);k++){
					fprintf(fpw,"%1X",cpcbuf[k]);
				}
				fprintf(fpw,"\n");
			}
		}
	}
	fclose(fpw);

}
