#include	<stdio.h>
#include	<memory.h>
#include	<strings.h>
#include	<math.h>

FILE	*fpw,*fpw2;

#define		R 0x20
#define		R2 (int)(0x20/3.141592654+0.5)
#define		V 1

unsigned char	xx[0x40];
unsigned char	xx2[0x40];
unsigned char	yy[0x40];
unsigned char	yy2[0x40];
unsigned char	c[0x40][0x40];

main()
{
	static char	filename[] = {"cir-X.DAT"};
	static char	filename2[] = {"cir-X.TXT"};
	static char	cpcom1[] = {"cp "};
	static char	cpcom2[] = {" ../asm/"};
	char	c[125];

	printf("\n\n\n<<<<< CIRCLE X DATA START !! >>>>>\t\n\n\n");

	if(( fpw = fopen(filename2,"w")) == NULL){
		printf("Write file2 open error !!\n");
		exit(1);
	}
	if(( fpw2 = fopen(filename,"wb")) == NULL){
		printf("Write file open error !!\n");
		exit(1);
	}

	circle_X();
	printf("\n");
	cir_full();
	cir_data_save();

	fclose(fpw);
	fclose(fpw2);

	printf("\n\n<<<<< CIRCLE X DATA END !! >>>>>\n\n\n");
/**************************/
	strcpy(c,cpcom1);
	strcat(c,filename);
	strcat(c, cpcom2);
	strcat(c,filename);
	printf("\n%s\n",c);
	system(c);
	strcpy(c,cpcom1);
	strcat(c,filename2);
	strcat(c, cpcom2);
	strcat(c,filename2);
	printf("\n%s\n",c);
	system(c);
/**************************/
}

circle_X()
{
	double	a, b, x, y;
	int	i;

	i = 0;
	y = R;

	while( y > 0 ){
		x = sqrt(( R * R ) - ( y * y ));
		a = x;
		xx[i] = -(unsigned char)a + R;
		printf("%03XH",xx[i]);
		y--;
		i++;
		if( ( b = y - (((int)y/8)*8)) == 0 ){
			printf("\n");
		}
		else{
			printf(",");
		}
	}

	while( y < R ){
		x = sqrt(( R * R ) - ( y * y ));
		a = x;
		xx[i] = -(unsigned char)a + R;
		printf("%03XH",xx[i]);
		y++;
		i++;
		if( ( b = y - (((int)y/8)*8)) == 0 ){
			printf("\n");
		}
		else{
			printf(",");
		}
	}

	printf("\n");

	i = 0;
	while(i<R*2){
		xx2[i] = ( R * 2 ) - xx[i];
		printf("%03XH",xx2[i]);
		i++;
		if( ( b = i - (i/8)*8) == 0 ){
			printf("\n");
		}
		else{
			printf(",");
		}
	}
}

cir_full()
{
	double	x,y,v;
	int	i,j;
	unsigned char	cc;

	for(i=0;i<R*2;i++){
		j=0;
		for(x=(R);x>(-R);x--){
/****
			y = sqrt(( R * R ) - ( x * x ));
****/
			y = sqrt(( (xx2[i] - R*V ) * (xx2[i] - R*V )) - ( x * x ));
			v = atan2(y,x);
			cc = R * v;
			if(j < xx[i] || j > xx2[i]){
				c[i][j] = 0xff;
			}
			else{
				c[i][j] = cc;
			}
			j++;
		}
	}
}

cir_data_save()
{
	int	b,i,j;

	fprintf(fpw,"CRDATA\tEQU\t$\n");
	for(i=0;i<R*2;i++){
		fprintf(fpw,";------- %02X : %02X\n", xx2[i],xx[i]);
		j = 0;
		while(j<R*2){
			if( ( b = j - (j/16)*16) == 0 ){
				fprintf(fpw,"\tHEX\t");
			}
			fprintf(fpw,"%02X",c[i][j]);
			putc(c[i][j],fpw2);
			j++;
			if( ( b = j - (j/16)*16) == 0 ){
				fprintf(fpw,"\n");
			}
			else{
				fprintf(fpw,",");
			}
		}
	}
	fprintf(fpw,";\n;\n;\n;\n");
}
