#include <math.h>
#include <stdio.h>

#define	PI	3.1415927

FILE *fpw0;

main()
{
	/****** ram set ******/
	double i,b;
	unsigned short a,j=0;

	/****** write file open ******/
	if((fpw0=fopen("angl.dat","w")) == 0){
		printf("can't open !!\n");
		exit(1);
	}

	/****** cos data label set ******/
	fprintf(fpw0,";************************************************************************\n");
	fprintf(fpw0,";*	cos data							*\n");	
	fprintf(fpw0,";************************************************************************\n");

	/****** cos data make ******/
	fprintf(fpw0,"XCOS\t\tEQU\t$");	
	for(i=0.0;i<90.0;i+=(360.0/2048.0)){
		b = cos(i*(PI/180.0)) * (double)0x100;
		if( b >= 0 ){
			b += 0.5;
		}
		else{
			b -= 0.5;
		}
		a = (unsigned short)b;
		if(j--==0){
			j=7;
			fprintf(fpw0,"\n\t\tWORD\t%05XH",a);
		}
		else{
			fprintf(fpw0,",%05XH",a);
		}	
	}
	fprintf(fpw0,"\n;\n");

	fprintf(fpw0,"XSIN\t\tEQU\t$");	
	for(i=0.0;i<360.0;i+=(360.0/2048.0)){
		b = 0.0 - sin(i*(PI/180.0)) * (double)0x100;
		if( b >= 0 ){
			b += 0.5;
		}
		else{
			b -= 0.5;
		}
		a = (unsigned short)b;
		if(j--==0){
			j=7;
			fprintf(fpw0,"\n\t\tWORD\t%05XH",a);
		}
		else{
			fprintf(fpw0,",%05XH",a);
		}	
	}
	fprintf(fpw0,"\n;\n");

	/****** write file close ******/
	fclose(fpw0);

}

