/*******************************************************************************/
/*			    Tiny Text Editor				       */
/*									       */
/*	   for	German and French  version				       */
/*									       */
/*	   Programmed by Y.Nishida   [ Nov.15, 1991 ]  version 1.00	       */
/*	   Programmed by N.Okajima   [ Jan.17, 1992 ]  version 1.50	       */
/*******************************************************************************/

#include    <stdio.h>
#include    <strings.h>
#include    <ctype.h>
#include    <signal.h>
#include    "console.h"
#include    "editor.h"
#include    "function.h"

#define	    CTRL  (0x100-'@')		/*  0xc0 */

static	int   length ;
static	int   width ;
static	int   posx ;
static	int   home ;
static	int   colum ;
static	int   toppos ;
static	char  cursor_home[7] = { '\033','[','1',';','0','1','H' } ;
static	int   pointbuf[MAXCOLUM] ;

static	short KeyMacroBuffer[1024] ;
static	int   KeyMacroLength = 0 ;
static	int   KeyMacroCount  = 0 ;
static	int   KeyMacroFlag   = 0 ;

static	void  CursorRight() ;
static	void  BackSpace() ;
static	void  CursorLeft() ;
static	void  DeleteChar() ;
static	void  StoreChar() ;
static	void  DisplayAllScreen2();
static int StoreCh();

/************************************************************************/
/*  Input one character							*/
/************************************************************************/

extern int InputChar()
{
	register int  cc ;

	sigsetmask( SignalMask ) ;
	if ( KeyMacroFlag == 2 ) {
		cc = KeyMacroBuffer[KeyMacroCount++] ;
		if ( KeyMacroCount == KeyMacroLength ) KeyMacroFlag = 0 ;
		return ( cc ) ;
	}
	cc = GetChr() ;

	if ( cc == '\033' ) {
		if ( (cc = GetChr()) == '[' ) {
			switch ( cc = GetChr()) {
				case 'A': cc = CTRL+'E' ; break ;
				case 'B': cc = CTRL+'X' ; break ;
				case 'C': cc = CTRL+'D' ; break ;
				case 'D': cc = CTRL+'S' ; break ;
				default : if ( isdigit( cc )) cc = FunctionKey( cc-'0' ) ;
					  if ( cc != 0x135 ) LatinFlag = 0 ;
					  break ;
			}
		}

/******************************************************************
		else if ( '@'<=cc && cc<='Y' ) {
			cc = CTRL+'Z' + cc - 'A' + 2 ;
			LatinFlag = 0 ;
		}
		else if ( 'a'<=cc && cc<='y' ) {
			cc = CTRL+'Z' + cc - 'a' + 2 ;
			LatinFlag = 0 ;
		}
		else if ( cc == 'Z' || cc == 'z') {
			cc = 0x135 ;
		}
		else if ( cc == ' ' ) {
			cc = CTRL+'Z' + 1 ;
			LatinFlag = 0 ;
		}
		else if ( isdigit(cc)) {
			cc += 0x300 ;
			LatinFlag = 0 ;
		}
******************************************************************/
	}
	else if ( cc < 0x1c ) {
		cc += 0x100 ;
	}
	else if ( cc == 0x7f ) {
		cc = 0x136 ;
	}
	else if ( (cc > 0x20 && cc < 0x7f) && LatinFlag==1 ) {
		if ( cc == 0x2d )  cc = 0xff ;
		else		   cc += 0x80 ;
	}
	/* 킪܂܂ȃtXl̂߂ɁEEE */
	else if( cc==0x5e ) {
		cc = GetChr();
		switch( cc ) {
			case 'a':
				cc=0xe2;
				break;
			case 'A':
				cc=0xc2;
				break;
			case 'o':
				cc=0xf4;
				break;
			case 'O':
				cc=0xd4;
				break;
			case 'i':
				cc=0xee;
				break;
			case 'I':
				cc=0xce;
				break;
			case 'u':
				cc=0xfb;
				break;
			case 'U':
				cc=0xdb;
				break;
			case 'e':
				cc=0xea;
				break;
			case 'E':
				cc=0xca;
				break;
			default:
				break;
		}
	}
	else if( cc==0xa8 ) {
		cc = GetChr();
		switch( cc ) {
			case 'a':
				cc=0xe4;
				break;
			case 'A':
				cc=0xc4;
				break;
			case 'o':
				cc=0xf6;
				break;
			case 'O':
				cc=0xd6;
				break;
			case 'i':
				cc=0xef;
				break;
			case 'I':
				cc=0xcf;
				break;
			case 'u':
				cc=0xfc;
				break;
			case 'U':
				cc=0xdc;
				break;
			case 'e':
				cc=0xeb;
				break;
			case 'E':
				cc=0xcb;
				break;
			default:
				break;
		}
	}
/**************************************/

	if ( KeyMacroFlag == 1 && KeyMacroLength < 1024 ) {
		KeyMacroBuffer[KeyMacroLength++] = (short)cc ;
	}
	SignalMask = sigblock( sigmask( SIGWINCH )) ;
	return ( cc ) ;
}

/************************************************************************/
/*  Check Function Key							*/
/************************************************************************/

static int FunctionKey( num )
int  num ;
{
	int  cc ;

	cc = GetChr() ;
	if ( isdigit( cc )) {
		num = num * 10 + cc - '0' ;
		if (( cc = GetChr()) == '~' ) {
			switch( num ) {
				case 11:
				case 12:
				case 13:
				case 14:
				case 16:
				case 17:
				case 18:
				case 19:
				case 20:
				case 21:
					cc = FunctionCode[num-11] ;
					break;
				case 15:
					cc=0x60;   /** ` **/
					break;
			}

			/** if ( 11 <= num && num <= 21 ) cc = FunctionCode[num-11] ; **/
		}
	}
	else if ( cc == '~' ) {
		switch ( num ) {
			case 4: cc = 0x111 ; break ;
			case 8: cc = 0x106 ; break ;
			case 9:
				cc = GetChr() ;
				switch( cc ) {
					case 0xe9:
						cc=0x7e;
						break;
					case 0x22:
						cc=0x23;
						break;
					case 0x27:
						cc=0x7b;
						break;
					case 0x28:
						cc=0x5b;
						break;
					case 0x2d:
						cc=0x7c;
						break;
					case 0xe8:
						cc=0x60;
						break;
					case 0x5f:
						cc=0x5c;
						break;
					case 0xe7:
						cc=0x5e;
						break;
					case 0xe0:
						cc=0x40;
						break;

					case 0x29:
						cc=0x5d;
						break;
					case 0x3d:
						cc=0x7d;
						break;
					default:
						break;
				}
				break;
		}
	}
	return ( cc ) ;
}

/************************************************************************/
/*  Input string							*/
/************************************************************************/

extern int InputString( home_pos,init_pos )
int  home_pos,init_pos ;
{
	int  cnt,flg = 1 ;

	cursor_home[4] = '0' + (home_pos+1) / 10 ;
	cursor_home[5] = '0' + (home_pos+1) % 10 ;

	home   = 0 ;
	posx   = home_pos + init_pos ;
	colum  = init_pos ;
	length = init_pos ;
	width  = ScreenWidth - home_pos - 1 ;
	toppos = home_pos ;

	/****** string buffer clear ******/
	StringBuffer[init_pos] = '|' ;
	for ( cnt=init_pos+1 ; cnt<MAXCOLUM ; cnt++ ) {
		StringBuffer[cnt] = ' ' ;
	}
	write( 1,cursor_home,7 ) ;
	write( 1,StringBuffer,width ) ;
	Locate( posx,0 ) ;

	while ( flg ) {
		int  cc ;
		switch ( cc = InputChar()) {
			case 0x104: CursorRight() ; break ;
			case 0x108: BackSpace() ;   break ;
			case 0x113: CursorLeft() ;  break ;
			case 0x136: DeleteChar() ;  break ;
			case 0x10d: flg = 0 ;	    break ;
			default	  : StoreChar ( cc ) ; break ;
		}
	}
	StringBuffer[length] = '\0' ;
	return ( length ) ;
}

/************************************************************************/
/*  Store character							*/
/************************************************************************/

static void StoreChar( cc )
int  cc ;
{
	if ( (isprint( cc ) || ( cc>0xa0 && cc<=0xff))	&& length < MAXCOLUM-1 ) {
		InsertMemory( &StringBuffer[colum],MAXCOLUM-colum,1 ) ;
		StringBuffer[colum] = cc ;
		write( 1,&StringBuffer[colum],ScreenWidth-posx-1 ) ;
		length++ ;
		CursorRight() ;
	}
}

/************************************************************************/
/*  Back space								*/
/************************************************************************/

static void BackSpace()
{
	if ( colum > 0 ) {
		CursorLeft() ;
		length-- ;
		DeleteMemory( &StringBuffer[colum],MAXCOLUM-colum,1 ) ;
		write( 1,&StringBuffer[colum],ScreenWidth-posx-1 ) ;
		Locate( posx,0 ) ;
	}
}

/************************************************************************/
/*  Delete character							*/
/************************************************************************/

static void DeleteChar()
{
	if ( length > 0 ) {
		length-- ;
		DeleteMemory( &StringBuffer[colum],MAXCOLUM-colum,1 ) ;
		write( 1,&StringBuffer[colum],ScreenWidth-posx-1 ) ;
		Locate( posx,0 ) ;
	}
}

/************************************************************************/
/*  Move cursor right							*/
/************************************************************************/

static void CursorRight()
{
	unchar	*cc ;

	cc = &StringBuffer[colum] ;

	if ( colum < length ) {
		colum++ ;
		if ( posx == ScreenWidth - 1 ) {
			home++ ;
			write( 1,cursor_home,7 ) ;
			write( 1,StringBuffer[home],width ) ;
			Locate( posx,0 ) ;
		}
		else {
			posx++ ;
			Locate( posx,0 ) ;
		}
	}
}

/************************************************************************/
/*  Move cursor left							*/
/************************************************************************/

static void CursorLeft()
{
	int    pnt ;

	if ( colum > 0 ) {
		colum-- ;
		if ( posx == toppos ) {
			home-- ;
			write( 1,StringBuffer[home],width ) ;
			write( 1,cursor_home,7 ) ;
		}
		else {
			posx-- ;
			Locate( posx,0 ) ;
		}

	}
}
/************************************************************************/
/*  Start Key Macro definition						*/
/************************************************************************/

extern int DefineKeyMacro()
{
	if ( KeyMacroFlag == 0 ) {
		KeyMacroFlag   = 1 ;
		KeyMacroLength = 0 ;

		strcpy( Information+27,"MACRO" ) ;
		Information[32] = ' ' ;
		Locate( 0,0 ) ;
		PrintMessage( Information ) ;
		Locate( CursorPosX,CursorPosY ) ;
	}
	else if ( KeyMacroFlag == 1 ) {
		KeyMacroLength-- ;
		KeyMacroFlag = 0 ;

		strcpy( Information+27,"     " ) ;
		Information[32] = ' ' ;
		Locate( 0,0 ) ;
		PrintMessage( Information ) ;
		Locate( CursorPosX,CursorPosY ) ;
	}
	return ( InputChar()) ;
}

/************************************************************************/
/*  Execute Key Macro							*/
/************************************************************************/

extern int ExecuteKeyMacro()
{
	if ( KeyMacroFlag == 0 && KeyMacroLength > 0 ) {
		KeyMacroFlag  = 2 ;
		KeyMacroCount = 0 ;
	}
	return ( InputChar()) ;
}

/************************************************************************/
/*  Window Menu 1							*/
/************************************************************************/

extern int  WinMenu1()
{
	int  cc,yp,flag;

	Locate( 0,1 );
	PutStr( "\033[K+---------------------------------------+" ) ;
	Locate( 0,2 );
	PutStr( "\033[K|               MENU 1                  |" ) ;
	Locate( 0,3 );
	PutStr( "\033[K+---------------------------------------+" ) ;
	Locate( 0,4 );
	PutStr( "\033[K| 1. Save & End                         |" ) ;
	Locate( 0,5 );
	PutStr( "\033[K| 2. Quit                               |" ) ;
	Locate( 0,6 );
	PutStr( "\033[K| 3. Save                               |" ) ;
	Locate( 0,7 );
	PutStr( "\033[K| 4. Rename                             |" ) ;
	Locate( 0,8 );
	PutStr( "\033[K| 5. MargeFile                          |" ) ;
	Locate( 0,9 );
	PutStr( "\033[K+---------------------------------------+" ) ;

	yp=4;
	Locate( 2,yp );

	flag=1;
	while( flag ) {
		cc=InputChar();
		switch( cc ) {
			case '1'   : cc=0x120;	flag=0; break;
			case '2'   : cc=0x12c;	flag=0; break;
			case '3'   : cc=0x12e;	flag=0; break;
			case '4'   : cc=0x129;	flag=0; break;
			case '5'   : cc=0x134;	flag=0; break;
			case 0x113 :	    /* cursor left  */
			case 0x104 :	    /* cursor right */
			case 0x122 :
			case 0x123 :
			case 0x125 :
			case 0x126 : flag=0; break;
			case 0x105 : if( yp>4 )	      yp--;
				     else if( yp==4 ) yp=8;
				     Locate( 2,yp );
				     break;
			case 0x118 : if( yp<8 )	      yp++;
				     else if( yp==8 ) yp=4;
				     Locate( 2,yp );
				     break;
			case 0x10D : switch( yp ) {
					case 4 : cc=0x120; break;
					case 5 : cc=0x12c; break;
					case 6 : cc=0x12e; break;
					case 7 : cc=0x129; break;
					case 8 : cc=0x134; break;
					default: break;
				     }
				     flag=0; break;
			default	   : cc=0x127;	flag=0; break;
		}
	}

	DisplayAllScreen2( 10 ) ;
	Locate( CursorPosX,CursorPosY );

	return( cc ) ;
}

/************************************************************************/
/*  Window Menu 2							*/
/************************************************************************/

extern int  WinMenu2()
{
	int  cc,yp,flag;

	Locate( 0,1 );
	PutStr( "\033[K+---------------------------------------+" ) ;
	Locate( 0,2 );
	PutStr( "\033[K|               MENU 2                  |" ) ;
	Locate( 0,3 );
	PutStr( "\033[K+---------------------------------------+" ) ;
	Locate( 0,4 );
	PutStr( "\033[K| 1. Search                             |" ) ;
	Locate( 0,5 );
	PutStr( "\033[K| 2. Replase                            |" ) ;
	Locate( 0,6 );
	PutStr( "\033[K| 3. Range                              |" ) ;
	Locate( 0,7 );
	PutStr( "\033[K| 4. Block Save                         |" ) ;
	Locate( 0,8 );
	PutStr( "\033[K| 5. Define Key Macro                   |" ) ;
	Locate( 0,9 );
	PutStr( "\033[K+---------------------------------------+" ) ;

	yp=4;
	Locate( 2,yp );

	flag=1;
	while( flag ) {
		cc=InputChar();
		switch( cc ) {
			case '1'   : cc=0x121;	flag=0; break;
			case '2'   : cc=0x133;	flag=0; break;
			case '3'   : cc=0x12D;	flag=0; break;
			case '4'   : cc=0x132;	flag=0; break;
			case '5'   : cc=0x128;	flag=0; break;
			case 0x113 :	    /* cursor left  */
			case 0x104 :	    /* cursor right */
			case 0x122 :
			case 0x123 :
			case 0x125 :
			case 0x126 : flag=0; break;
			case 0x105 : if( yp>4 )	      yp--;
				     else if( yp==4 ) yp=8;
				     Locate( 2,yp );
				     break;
			case 0x118 : if( yp<8 )	      yp++;
				     else if( yp==8 ) yp=4;
				     Locate( 2,yp );
				     break;
			case 0x10D : switch( yp ) {
					case 4 : cc=0x121; break;
					case 5 : cc=0x133; break;
					case 6 : cc=0x12D; break;
					case 7 : cc=0x132; break;
					case 8 : cc=0x128; break;
					default: break;
				     }
				     flag=0; break;
			default	   : cc=0x127;	flag=0; break;
		}
	}

	DisplayAllScreen2( 10 ) ;
	Locate( CursorPosX,CursorPosY );

	return( cc ) ;
}

/************************************************************************/
/*  Window Menu 3							*/
/************************************************************************/

extern int  WinMenu3()
{
	int  cc,yp,flag;

	Locate( 0,1 );
	PutStr( "\033[K+---------------------------------------+" ) ;
	Locate( 0,2 );
	PutStr( "\033[K|               MENU 3                  |" ) ;
	Locate( 0,3 );
	PutStr( "\033[K+---------------------------------------+" ) ;
	Locate( 0,4 );
	PutStr( "\033[K| 1. Move bottom of text                |" ) ;
	Locate( 0,5 );
	PutStr( "\033[K| 2. Move top of text                   |" ) ;
	Locate( 0,6 );
	PutStr( "\033[K| 3. Go to Line                         |" ) ;
	Locate( 0,7 );
	PutStr( "\033[K+---------------------------------------+" ) ;

	yp=4;
	Locate( 2,yp );

	flag=1;
	while( flag ) {
		cc=InputChar();
		switch( cc ) {
			case '1'   : cc=0x102;	flag=0; break;
			case '2'   : cc=0x10A;	flag=0; break;
			case '3'   : cc=0x200;	flag=0; break;
			case 0x113 :	    /* cursor left  */
			case 0x104 :	    /* cursor right */
			case 0x122 :
			case 0x123 :
			case 0x125 :
			case 0x126 : flag=0; break;
			case 0x105 : if( yp>4 )	      yp--;
				     else if( yp==4 ) yp=6;
				     Locate( 2,yp );
				     break;
			case 0x118 : if( yp<6 ) yp++;
				     else if( yp==6 ) yp=4;
				     Locate( 2,yp );
				     break;
			case 0x10D : switch( yp ) {
					case 4 : cc=0x102; break;
					case 5 : cc=0x10A; break;
					case 6 : cc=0x200; break;
					default: break;
				     }
				     flag=0; break;
			default	   : cc=0x127;	flag=0; break;
		}
	}

	DisplayAllScreen2( 10 ) ;
	Locate( CursorPosX,CursorPosY );

	return( cc ) ;
}

/************************************************************************/
/*  Window Menu 4							*/
/************************************************************************/

extern int  WinMenu4()
{
	int  cc,xp,yp,flag;

	Locate( 0,1 );
	PutStr( "\033[K+---------------------------------------------------------+" ) ;
	Locate( 0,2 );
	PutStr( "\033[K|                        MENU 4                           |" ) ;
	Locate( 0,3 );
	PutStr( "\033[K+---------------------------------------------------------+" ) ;
	Locate( 0,4 );
	PutStr( "\033[K| 0. (...)                    C. (Pease of Heart 4)       |" ) ;
	Locate( 0,5 );
	PutStr( "\033[K| 1. (LINK fase)              D. (Pease of Heart 5)       |" ) ;
	Locate( 0,6 );
	PutStr( "\033[K| 2. (Old a letter 1)         E. (Pease of Heart 6)       |" ) ;
	Locate( 0,7 );
	PutStr( "\033[K| 3. (Old a lettet 2)         F. (Pease of Heart 7)       |" ) ;
	Locate( 0,8 );
	PutStr( "\033[K| 4. (Old a lettet 3)         G. (A Botton)               |" ) ;
	Locate( 0,9 );
	PutStr( "\033[K| 5. (Up arrow)               H. (B Botton)               |" ) ;
	Locate( 0,10 );
	PutStr( "\033[K| 6. (Down arrow)             I. (X Botton)               |" ) ;
	Locate( 0,11 );
	PutStr( "\033[K| 7. (Right arrow)            J. (Y Botton)               |" ) ;
	Locate( 0,12 );
	PutStr( "\033[K| 8. (Left arrow)             K. ()                      |" ) ;
	Locate( 0,13 );
	PutStr( "\033[K| 9. (Pease of Heart 1)       L. ()                      |" ) ;
	Locate( 0,14 );
	PutStr( "\033[K| A. (Pease of Heart 2)       M. ()                      |" ) ;
	Locate( 0,15 );
	PutStr( "\033[K| B. (Pease of Heart 3)       N. ()                      |" ) ;
	Locate( 0,16 );
	PutStr( "\033[K+---------------------------------------------------------+" ) ;

	yp=4;
	xp=2;
	Locate( xp,yp );

	flag=1;
	while( flag ) {
		cc=InputChar();
		switch( cc ) {
			case '0'   : cc=0x5F;  flag=0; break;
			case '1'   : StoreCh( 0x26 );
				     cc=0x2A;  flag=0; break;
			case '2'   : cc=0x23;  flag=0; break;
			case '3'   : cc=0x24;  flag=0; break;
			case '4'   : cc=0x25;  flag=0; break;
			case '5'   : cc=0x2B;  flag=0; break;
			case '6'   : cc=0xB2;  flag=0; break;
			case '7'   : cc=0xB3;  flag=0; break;
			case '8'   : cc=0x2F;  flag=0; break;
			case '9'   : cc=0x3D;  flag=0; break;
			case 'a'   :
			case 'A'   : cc=0x5E;  flag=0; break;
			case 'b'   :
			case 'B'   : cc=0x7E;  flag=0; break;
			case 'c'   :
			case 'C'   : cc=0xA7;  flag=0; break;
			case 'd'   :
			case 'D'   : cc=0xA2;  flag=0; break;
			case 'e'   :
			case 'E'   : cc=0xA3;  flag=0; break;
			case 'F'   :
			case 'f'   : cc=0xA5;  flag=0; break;
			case 'g'   :
			case 'G'   : cc=0xF8;  flag=0; break;
			case 'h'   :
			case 'H'   : cc=0xE3;  flag=0; break;
			case 'i'   :
			case 'I'   : cc=0xD7;  flag=0; break;
			case 'j'   :
			case 'J'   : cc=0xB1;  flag=0; break;
			case 'k'   :
			case 'K'   : cc=0xE2;  flag=0; break;
			case 'l'   :
			case 'L'   : cc=0xFB;  flag=0; break;
			case 'm'   :
			case 'M'   : cc=0xEE;  flag=0; break;
			case 'n'   :
			case 'N'   : cc=0xF4;  flag=0; break;
			case 0x122 :
			case 0x123 :
			case 0x125 :
			case 0x126 : flag=0; break;
			case 0x105 : if( yp>4 )	      yp--;
				     else if( yp==4 ) yp=15;
				     Locate( xp,yp );
				     break;
			case 0x118 : if( yp<15 )       yp++;
				     else if( yp==15 ) yp=4;
				     Locate( xp,yp );
				     break;
			case 0x113 : if( xp!=2 )      xp=2;
				     else if( xp==2 ) xp=30;
				     Locate( xp,yp );
				     break;
			case 0x104 : if( xp!=30 )	xp=30;
				     else if ( xp==30 ) xp=2;
				     Locate( xp,yp );
				     break;
			case 0x10D : switch( yp ) {
					case 4 : if( xp==2 ) cc=0x5F;
						 else	     cc=0xA7; break;
					case 5 : if( xp==2 ) {
							StoreCh( 0x26 );
							cc=0x2A;
						 }
						 else	     cc=0xA2; break;
					case 6 : if( xp==2 ) cc=0x23;
						 else	     cc=0xA3; break;
					case 7 : if( xp==2 ) cc=0x24;
						 else	     cc=0xA5; break;
					case 8 : if( xp==2 ) cc=0x25;
						 else	     cc=0xF8; break;
					case 9 : if( xp==2 ) cc=0x2B;
						 else	     cc=0xE3; break;
					case 10: if( xp==2 ) cc=0xB2;
						 else	     cc=0xD7; break;
					case 11: if( xp==2 ) cc=0xB3;
						 else	     cc=0xB1; break;
					case 12: if( xp==2 ) cc=0x2F;
						 else	     cc=0xE2; break;
					case 13: if( xp==2 ) cc=0x3D;
						 else	     cc=0xFB; break;
					case 14: if( xp==2 ) cc=0x5E;
						 else	     cc=0xEE; break;
					case 15: if( xp==2 ) cc=0x7E;
						 else	     cc=0xF4; break;
					default: break;
				     }
				     flag=0; break;
			default	   : cc=0x127;	flag=0; break;
		}
	}

	DisplayAllScreen2( 20 ) ;
	Locate( CursorPosX,CursorPosY );

	return( cc ) ;
}


/************************************************************************/
/*  Display all screen							*/
/************************************************************************/

static void DisplayAllScreen2( line )
int line;
{
	char *display_point ;
	int  count,display_line,pnt ;
	char cc=' ' ;

	display_line = CurrentHomeY ;

	for ( count=1 ; count<line ; count++ ) {
		display_point = (char *)&TextBuffer[display_line][CurrentHomeX] ;
		if ( display_line++ > MaximumLine ) {
			write( 1,"\033[J",3 ) ;
			break ;
		}
		Locate( 0,count ) ;
		write( 1,display_point,ScreenWidth-1 ) ;
	}
}

/************************************************************************/
/*  Store character into the Text buffer				*/
/************************************************************************/

static int StoreCh( code )
int  code ;
{
	unchar *txtptr ;

	txtptr = &TextBuffer[CurrentLine][CurrentColum] ;

	if ( InsertFlag ) {
		if ( CurrentColum < MAXCOLUM-1 ) {
			InsertMemory( txtptr,MAXCOLUM-CurrentColum,1 ) ;
			*txtptr = code ;
			write( 1,txtptr++,ScreenWidth-CursorPosX-1 ) ;
			CursorForward() ;
		}
	}
	else {
		if ( CurrentColum < MAXCOLUM-1 ) {
			*txtptr = code ;
			write( 1,txtptr++,1 ) ;
			CursorForward() ;
		}
	}
}
