/*******************************************************************************/
/*			      Tiny Text Editor				       */
/*									       */
/*	   for	German and French  version				       */
/*									       */
/*	   Programmed by Y.Nishida   [ Nov.15, 1991 ]  version 1.00	       */
/*	   Programmed by N.Okajima   [ Jan.17, 1992 ]  version 1.50	       */
/*******************************************************************************/

#include    <stdio.h>
#include    <strings.h>
#include    <ctype.h>
#include    "console.h"
#include    "editor.h"

static int  sw = 0 ;

static void DisplayLineNumber() ;
static void DisplayColumNumber() ;
extern void DisplayAllScreen() ;
extern void CursorForward() ;
extern void CursorBackward() ;
extern void MoveCursorLine() ;

/************************************************************************/
/*  Move Cursor any line						*/
/************************************************************************/

extern int GotoLine()
{
	int  line ;

	PutStr( "\033[7m" ) ;
	PutStr( "\033[1;1H\033[KLine:" ) ;

	InputString( 5,0 ) ;
	PutStr( "\033[27m" ) ;
	if (( line = atoi( StringBuffer )) > 0 ) {
		if ( --line > MaximumLine ) line = MaximumLine ;
		MoveCursorLine( line,(ScreenHeight-1 )/2 ) ;
	}
	PutStr( "\033[1;1H\033[K" ) ;
	PrintMessage( Information ) ;
	Locate( CursorPosX,CursorPosY ) ;
	return ( InputChar()) ;
}

/************************************************************************/
/*  Move cursor line							*/
/************************************************************************/

extern void MoveCursorLine( line,posy )
int  line,posy ;
{
	int  bottom ;

	CurrentHomeX = 0 ;
	CurrentHomeY = line - posy ;
	CurrentLine  = line ;
	CurrentColum = 0 ;
	CursorPosX   = 0 ;
	CursorPosY   = posy + 1 ;
	bottom	     = MaximumLine - ( ScreenHeight - 2 ) ;

	if ( CurrentHomeY < 0 || bottom < 0 ) {
		CurrentHomeY = 0 ;
		CursorPosY   = CurrentLine - CurrentHomeY + 1 ;
	}
	else if ( CurrentHomeY >= bottom ) {
		CurrentHomeY = bottom ;
		CursorPosY   = CurrentLine - CurrentHomeY + 1 ;
	}
	DisplayAllScreen() ;
	sprintf( Information+6,"%05d  COL:%03d",CurrentLine+1,CurrentColum+1 ) ;
	Information[20] = ' ' ;
}

/************************************************************************/
/*  Move cursor one line up						*/
/************************************************************************/

extern int MoveCursorUp()
{
	int  pnt ;
	char cc=' ' ;

	if ( CursorPosY > 1 ) {
		CursorPosY-- ;
		CurrentLine-- ;
		DisplayLineNumber() ;
	}
	else {
		if ( CurrentHomeY > 0 ) {
			CurrentHomeY-- ;
			CurrentLine-- ;
			write( 1,"\033[2;1H\033[1L",10 ) ;

			write( 1,(char *)&TextBuffer[CurrentHomeY][CurrentHomeX],ScreenWidth-1 ) ;
			DisplayLineNumber() ;
		}
	}
	return ( InputChar() ) ;
}

/************************************************************************/
/*  Move cursor one line down						*/
/************************************************************************/

extern int MoveCursorDown()
{
	int   pnt ;
	char  cc=' ' ;

	if ( CurrentLine == MaximumLine )  return ( InputChar()) ;

	if ( CursorPosY < ScreenHeight-1 ) {
		if ( CurrentLine < MaximumLine ) {
			CursorPosY++ ;
			CurrentLine++ ;
			DisplayLineNumber() ;
		}
	}
	else {
		if ( CurrentLine < MaximumLine ) {
			CurrentHomeY++ ;
			CurrentLine++ ;
			write( 1,"\033[2;1H\033[1M",10 ) ;
			Locate( 0,ScreenHeight-1 ) ;
			write( 1,(char *)&TextBuffer[CurrentLine][CurrentHomeX],ScreenWidth-1 ) ;
			DisplayLineNumber() ;
		}
	}
	return ( InputChar()) ;
}

/************************************************************************/
/*  Move cursor right ( Cursor forward )				*/
/************************************************************************/

extern int MoveCursorRight()
{
	if ( CurrentColum < MAXCOLUM-1 ) {
		CursorForward() ;
	}
	return ( InputChar()) ;
}

extern void CursorForward()
{
	unchar *txtptr ;

	txtptr = &TextBuffer[CurrentLine][CurrentColum] ;

	CurrentColum++ ;
	CursorPosX++ ;
	if ( CursorPosX == ScreenWidth-2 && issjis1(TextBuffer[CurrentLine][CurrentColum])
		 && CurrentColum != MAXCOLUM-1 ) {
		if ( (CurrentColum+8)>MAXCOLUM-1 ) {
			CurrentHomeX += 1 ;
			CursorPosX   -= 1 ;
		}
		else {
			CurrentHomeX += 8 ;
			CursorPosX   -= 8 ;
		}
		DisplayAllScreen() ;
	}
	else if ( CursorPosX == ScreenWidth-1 && CurrentColum != MAXCOLUM-1 ) {
		if ( (CurrentColum+8)>MAXCOLUM-1 ) {
			CurrentHomeX += 1 ;
			CursorPosX   -= 1 ;
		}
		else {
			CurrentHomeX += 8 ;
			CursorPosX   -= 8 ;
		}
		DisplayAllScreen() ;
	}
	DisplayColumNumber() ;
}

/************************************************************************/
/*  Move cursor left ( Cursor backward )				*/
/************************************************************************/

extern int MoveCursorLeft()
{
	if ( CurrentColum > 0 ) {
		CursorBackward() ;
	}
	return ( InputChar() ) ;
}

extern void CursorBackward()
{
	CurrentColum-- ;
	CursorPosX-- ;
	if ( CursorPosX < 0 ) {
		CurrentHomeX -= 8 ;
		CursorPosX   += 8 ;
		DisplayAllScreen() ;
	}
	DisplayColumNumber() ;
}

/************************************************************************/
/*  Scroll down								*/
/************************************************************************/

extern int ScrollDown()
{
	int  pnt ;
	char cc=' ' ;

	if ( CurrentHomeY > 0 ) {
		CurrentHomeY-- ;
		CurrentLine-- ;
		write( 1,"\033[2;1H\033[1L",10 ) ;
		write( 1,(char *)&TextBuffer[CurrentHomeY][CurrentHomeX],ScreenWidth-1 ) ;
		DisplayLineNumber() ;
	}
	return ( InputChar()) ;
}

/************************************************************************/
/*  Scroll up								*/
/************************************************************************/

extern int ScrollUp()
{
	int  bottom,pnt ;
	char cc=' ' ;

	bottom = MaximumLine - ( ScreenHeight - 2 ) ;
	if ( CurrentHomeY < bottom ) {
		CurrentHomeY++ ;
		CurrentLine++ ;
		write( 1,"\033[2;1H\033[1M",10 ) ;
		Locate( 0,ScreenHeight-1 ) ;
		write( 1,(char *)&TextBuffer[CurrentHomeY+ScreenHeight-2][CurrentHomeX],ScreenWidth-1 ) ;
		DisplayLineNumber() ;
	}
	return ( InputChar()) ;
}

/************************************************************************/
/*  Move cursor one page up						*/
/************************************************************************/

extern int PageUp()
{
	if ( CurrentHomeY != 0 ) {
		if (( CurrentHomeY -= ScreenHeight - 1 ) < 0 ) {
			CurrentHomeY = 0 ;
		}
		CurrentLine = CurrentHomeY + CursorPosY - 1 ;
		DisplayAllScreen() ;
		DisplayLineNumber() ;
	}
	return ( InputChar()) ;
}

/************************************************************************/
/*  Move cursor one page down						*/
/************************************************************************/

extern int PageDown()
{
	int  bottom,next_home ;

	bottom = MaximumLine - ( ScreenHeight - 2 ) ;
	if (( next_home = CurrentHomeY + ScreenHeight - 1 ) > bottom ) {
		next_home = bottom ;
	}
	if ( CurrentHomeY < next_home ) {
		CurrentHomeY = next_home ;
		CurrentLine  = CurrentHomeY + CursorPosY - 1 ;
		DisplayAllScreen() ;
		DisplayLineNumber() ;
	}
	return ( InputChar()) ;
}

/************************************************************************/
/*  Move cursor top of line						*/
/************************************************************************/

extern int MoveTopLine()
{
	if ( CurrentColum > 0 ) {
		CurrentColum = 0 ;
		CursorPosX   = 0 ;
		if ( CurrentHomeX > 0 ) {
			CurrentHomeX = 0 ;
			DisplayAllScreen() ;
		}
		DisplayColumNumber() ;
	}
	return ( InputChar()) ;
}

/************************************************************************/
/*  Move cursor bottom of line						*/
/************************************************************************/

extern int MoveBottomLine()
{
	register unchar *txtptr ;
	register int	colum,home ;

	txtptr = &TextBuffer[CurrentLine][MAXCOLUM-2] ;
	for ( colum=MAXCOLUM-2 ; colum>=0 ; txtptr--,colum-- ) {
		if ( *txtptr != ' ' )  break ;
	}
	if ( ++colum != CurrentColum ) {
		CurrentColum = colum ;
		home	     = 0 ;
		while ( colum > ScreenWidth-1 ) {
			colum -= 8 ;
			home  += 8 ;
		}
		if ( home != CurrentHomeX ) {
			CurrentHomeX = home ;
			DisplayAllScreen() ;
		}
		CurrentHomeX = home ;
		CursorPosX   = colum ;
		DisplayColumNumber() ;
	}
	return ( InputChar()) ;
}

/************************************************************************/
/*  Horizontal Tabulation						*/
/************************************************************************/

extern int Tabulation()
{
	int  count,old_home,pnt ;

	for ( count=0 ; count<TabCount ; count++ ) {
		if ( CurrentColum < (int)TabPoint[count] ) {
			CurrentColum = (int)TabPoint[count] ;
			break ;
		}
	}
	CursorPosX = CurrentColum - CurrentHomeX ;
	old_home   = CurrentHomeX ;

	while ( CursorPosX > ScreenWidth-1 ) {
		CursorPosX   -= 8 ;
		CurrentHomeX += 8 ;
	}
	if ( CurrentHomeX != old_home )	 DisplayAllScreen() ;
	DisplayColumNumber() ;
	return ( InputChar()) ;
}

/************************************************************************/
/*  Horizontal Back Tabulation						*/
/************************************************************************/

extern int BackTab()
{
	int  count,old_home,pnt ;

	for ( count=TabCount-1 ; count>=0 ; count-- ) {
		if ( CurrentColum > (int)TabPoint[count] ) {
			CurrentColum = (int)TabPoint[count] ;
			break ;
		}
	}
	CursorPosX = CurrentColum - CurrentHomeX ;
	old_home   = CurrentHomeX ;

	while ( CursorPosX < 0 ) {
		CursorPosX   += 8 ;
		CurrentHomeX -= 8 ;
	}
	if ( CurrentHomeX != old_home )	 DisplayAllScreen() ;
	DisplayColumNumber() ;
	return ( InputChar()) ;
}

/************************************************************************/
/*  Move cursor top of insert line					*/
/************************************************************************/

extern int MoveTopInsLine()
{
	if ( CurrentColum > 0 ) {
		CurrentColum = 0 ;
		CursorPosX   = 0 ;
		if ( CurrentHomeX > 0 ) {
			CurrentHomeX = 0 ;
			DisplayAllScreen() ;
		}
	}
	if ( AutoIndentFlag ) AutoIndent( CurrentLine-1 ) ;
	DisplayColumNumber() ;
	return ( InputChar()) ;
}

/************************************************************************/
/*  Carriage return							*/
/************************************************************************/

extern int ReturnCursor()
{
	int  res ;

	if ( CurrentColum > 0 ) {
		CurrentColum = 0 ;
		CursorPosX   = 0 ;
		if ( CurrentHomeX > 0 ) {
			CurrentHomeX = 0 ;
			DisplayAllScreen() ;
		}
	}
	if ( AutoIndentFlag )  AutoIndent( CurrentLine ) ;
	DisplayColumNumber() ;

	if ( CurrentLine < MaximumLine ) res = MoveCursorDown() ;
	else				 res = InputChar() ;
	return ( res ) ;
}

/************************************************************************/
/*  Move cursor top of text						*/
/************************************************************************/

extern int MoveTextTop()
{
	if ( CurrentHomeY != 0 ) {
		CurrentHomeX = 0 ;
		CurrentHomeY = 0 ;
		DisplayAllScreen() ;
	}
	else if ( CurrentHomeX > 0 ) {
		CurrentHomeX = 0 ;
		DisplayAllScreen() ;
	}
	CurrentLine  = 0 ;
	CurrentColum = 0 ;
	CursorPosX   = 0 ;
	CursorPosY   = 1 ;

	strcpy( Information+6,"00001  COL:001" ) ;
	Information[20] = ' ' ;
	Locate( 0,0 ) ;
	PrintMessage( Information ) ;
	Locate( CursorPosX,CursorPosY ) ;
	return ( InputChar()) ;
}

/************************************************************************/
/*  Move cursor bottom of text						*/
/************************************************************************/

extern int MoveTextBottom()
{
	int  bottom ;

	bottom = MaximumLine - ( ScreenHeight - 2 ) ;
	if ( CurrentHomeY < bottom ) {
		CurrentHomeX = 0 ;
		CurrentHomeY = bottom ;
		DisplayAllScreen() ;
	}
	else if ( CurrentHomeX > 0 ) {
		CurrentHomeX = 0 ;
		DisplayAllScreen() ;
	}
	CurrentLine  = MaximumLine ;
	CurrentColum = 0 ;
	CursorPosX   = 0 ;
	CursorPosY   = MaximumLine - CurrentHomeY + 1 ;

	sprintf( Information+6,"%05d  COL:001",CurrentLine+1 ) ;
	Information[20] = ' ' ;
	Locate( 0,0 ) ;
	PrintMessage( Information ) ;
	Locate( CursorPosX,CursorPosY ) ;
	return ( InputChar()) ;
}

/************************************************************************/
/*  Display cursor line number						*/
/************************************************************************/

static void DisplayLineNumber()
{
	static char prtbuf[11] = { '\033','[','1',';','7','H','0','0','0','0','0' } ;

	register int  num ;

	num = CurrentLine + 1 ;

	prtbuf[6] = '0' + num / 10000 ;
	Information[6] = prtbuf[6] ;

	num %= 10000 ;
	prtbuf[7] = '0' + num / 1000 ;
	Information[7] = prtbuf[7] ;

	num %= 1000 ;
	prtbuf[8] = '0' + num / 100 ;
	Information[8] = prtbuf[8] ;

	num %= 100 ;
	prtbuf[9] = '0' + num / 10 ;
	Information[9] = prtbuf[9] ;

	prtbuf[10] = '0' + num % 10 ;
	Information[10] = prtbuf[10] ;

	PutStr( "\033[7m" ) ;
	write( 1,prtbuf,11 ) ;
	PutStr( "\033[27m" ) ;
	Locate( CursorPosX,CursorPosY ) ;
}

/************************************************************************/
/*  Display cursor colum number						*/
/************************************************************************/

static void DisplayColumNumber()
{
	static char prtbuf[10] = { '\033','[','1',';','1','8','H','0','0','0' } ;

	register int  num ;

	num = CurrentColum + 1 ;

	prtbuf[7] = '0' + num /	 100 ;
	Information[17] = prtbuf[7] ;

	num %= 100 ;
	prtbuf[8] = '0' + num / 10 ;
	Information[18] = prtbuf[8] ;

	prtbuf[9] = '0' + num % 10 ;
	Information[19] = prtbuf[9] ;

	PutStr( "\033[7m" ) ;
	write( 1,prtbuf,10 ) ;
	PutStr( "\033[27m" ) ;
	Locate( CursorPosX,CursorPosY ) ;
}

/************************************************************************/
/*  Initialize editor process						*/
/************************************************************************/

extern void SetupEditor()
{
	sprintf( Information," LINE:00001  COL:001  INS         FILE:%s", FileName ) ;
	PutStr( "\033[2J\033[01;01H" ) ;
	PrintMessage( Information ) ;
}

/************************************************************************/
/*  Display all screen							*/
/************************************************************************/

extern void DisplayAllScreen()
{
	char *display_point ;
	int  count,display_line,pnt ;
	char cc=' ' ;

	display_line = CurrentHomeY ;

	for ( count=1 ; count<ScreenHeight ; count++ ) {
		display_point = (char *)&TextBuffer[display_line][CurrentHomeX] ;
		if ( display_line++ > MaximumLine ) {
			write( 1,"\033[J",3 ) ;
			break ;
		}
		Locate( 0,count ) ;
		write( 1,display_point,ScreenWidth-1 ) ;
	}
}

/************************************************************************/
/*  Display after cursor						*/
/************************************************************************/

extern void DisplayAfter()
{
	char *display_point ;
	int  count,display_line,pnt ;
	char cc=' ' ;

	display_line = CurrentLine ;

	for ( count=CursorPosY ; count<ScreenHeight ; count++ ) {
		display_point = (char *)&TextBuffer[display_line][CurrentHomeX] ;
		if ( display_line++ > MaximumLine ) {
			write( 1,"\033[J",3 ) ;
			break ;
		}
		Locate( 0,count ) ;
		write( 1,display_point,ScreenWidth-1 ) ;
	}
}
