/****************************************************************
*	xwd file convert					*		
****************************************************************/		
#include <stdio.h>

#define	unchar	unsigned char	
#define	unshort	unsigned short
#define	ROT3	6.3496042	/* SQR3( 256 ) */
#define	STP3	ROT3/32.0	/* (SQR3( 256 ))/32 */

/****** main ram define ******/
char		fname0[20],fname1[20];
unsigned char	xwdbuf[0x20000];
unsigned char	chrbuf[0x2d00];

main( argc,argv )
int	argc;
char	**argv;
{
	/****** program start ******/
	if(argc != 2){
		printf("parameter error !!\n");
		exit(1);
	}
	strcpy(fname0,*(++argv));
	strcpy(fname1,fname0);
	strcat(fname0,".xwd");		
	strcat(fname1,".chr");		

	dtread();
	dtconv();
	dtsave();

}

/********************************************************
*	xwd file read					*		
********************************************************/		
dtread()
{
	/****** ram define ******/
	FILE	*fp;
	int	*hno,*xsz,*ysz,i;

	/****** program start ******/
	if((fp=fopen(fname0,"r")) == 0){
		printf("can't open %s !!\n",fname0);
		exit(1);
	}

	if((fread( xwdbuf,sizeof(unchar),0x20000,fp)) == NULL){
		printf("xwd file read error !!\n");
		exit(1);
	}

	hno = (int*)&xwdbuf[0x00];
	xsz = (int*)&xwdbuf[0x10];
	ysz = (int*)&xwdbuf[0x14];
	if(*hno != 0x6d || *xsz != 240 || *ysz != 180){
		printf("xwd file size error !!\n");
		exit(1);
	}

	for(i=0x1ed+(240*2*180);i<0x20000;i++){
		xwdbuf[i] = 0x00;
	}
		
	fclose(fp);

}

/********************************************************
*	xwd data convert				*		
********************************************************/		
dtconv()
{
	/****** ram define ******/
	unshort	*pix[4];
	unchar	col,orb,anb,red,green,blue;
	int	x,y,xb,yb,sp,i;
	unchar	zb;
	int	xw0,xw1,xw2;
	int	cw0,cw1,cw2;
	
	/****** program start ******/
	for(i=0;i<0x2d00;i++){
		chrbuf[i] = 0x00;
	}
	for(y=0;y<12;y++){				/* y loop */
		xw0 = 0x1ed+(y*(240*2)*(8*2));
		cw0 = y*(15*64);
		for(x=0;x<15;x++){			/* x loop */
			xw1 = xw0+(x*(8*2*2));
			cw1 = cw0+(x*64);
			for(yb=0;yb<8;yb++){		/* dot loop */
				xw2 = xw1+(yb*(240*2*2));
				cw2 = cw1+(yb*2);
				for(xb=0,orb=0x80;xb<8*2*2;xb+=4,orb>>=1){
					pix[0] = (unshort*)&xwdbuf[xw2+xb];
					pix[1] = (unshort*)&xwdbuf[xw2+xb+2];
					pix[2] = (unshort*)&xwdbuf[xw2+xb+(240*2)];
					pix[3] = (unshort*)&xwdbuf[xw2+xb+(240*2)+2];
					red   = 0x00;
					green = 0x00;
					blue  = 0x00;
					for(i=0;i<4;i++){
						red   += (unchar)(*pix[i] & 0x1f);
						green += (unchar)((*pix[i]>>5) & 0x1f);
						blue  += (unchar)((*pix[i]>>10) & 0x1f);
					}
					red   = (unchar)(((double)(red)/4.0+0.5)*STP3);
					green = (unchar)(((double)(green)/4.0+0.5)*STP3);
					blue  = (unchar)(((double)(blue)/4.0+0.5)*STP3);
					col = (unchar)((double)blue*ROT3*ROT3+0.5)+(unchar)((double)green*ROT3+0.5)+(unchar)((double)red+0.5);
					for(sp=0,anb=0x01;sp<64;sp+=16,anb<<=2){
						if((col & anb)!=0x00){
							chrbuf[cw2+sp] |= orb;
						}
						if((col & (anb<<1))!=0x00){
							chrbuf[cw2+sp+1] |= orb;
						}
					}
				}
			}
		}
	}

}

/********************************************************
*	chr file save					*		
********************************************************/		
dtsave()
{
	/****** ram define ******/
	FILE	*fp;

	/****** program start ******/
	if((fp=fopen(fname1,"w")) == 0){
		printf("can't open %s !!\n",fname1);
		exit(1);
	}

	if((fwrite( chrbuf,sizeof(unchar),0x2d00,fp)) == NULL){
		printf("chr file save error !!\n");
		exit(1);
	}

	fclose(fp);

}

