/************************************************************************
*		aff[^Ro[g					*
************************************************************************/

#include <stdio.h>
#include <sys/time.h>

#define unchar	unsigned char
#define unshort unsigned short

#define ON	1
#define OFF	0

FILE *fpr,*fpw;

void bgdtcnv( char * );

void main( int argc,char **argv )
{

	/****** ϐ錾 ******/
	char file_name[256];

	/****** `FbN ******/
	if( argc != 2 ){
		printf( "Usage: ys_bgdtcnv24 (bgdt_file)\n" );
		exit(1);
	}

	/****** aff[^t@Cnodm ******/
	strcpy(file_name, argv[1]);
	strcat(file_name, ".dat");
	if( !( fpr = fopen( file_name,"r" ) ) ){
		printf( "can't open (%s) !!\n",file_name );
		exit(1);
	}

	/****** Ro[gf[^o̓t@Cnodm ******/
	if( !( fpw = fopen( "bgdt24.lis","w" ) ) ){
		printf( "can't open (bgdt24.lis) !!\n" );
		exit(1);
	}

	/****** aff[^ϊ ******/
	bgdtcnv( file_name );

	/****** t@Cbknrd ******/
	fclose( fpr );
	fclose( fpw );

}

/****************************************************************
*	aff[^ϊ						*
****************************************************************/
void bgdtcnv( char *file_name )
{

	/****** ϐ錾 ******/
	int	c;
	int	i;
	struct tm *time;
	struct timeval tp;
	struct timezone tzp;

	gettimeofday(&tp, &tzp);
	time=localtime( &tp );

	fprintf(fpw, ";------------------------------------------------------------------------\n");
	fprintf(fpw, ";-\t\t\"%s\" (%04d/%02d/%02d %02d:%02d:%02d)\t\t\t\t\t\t-\n", file_name,
			time->tm_year+1900,time->tm_mon+1,time->tm_mday,time->tm_hour,time->tm_min,time->tm_sec);
	fprintf(fpw, ";------------------------------------------------------------------------\n");
	fprintf(fpw, "\t\tGLB\tBGDT_00_00\n");
	fprintf(fpw, "BGDT_00_00\tEQU\t$");

	i = 0;
	while((c = fgetc(fpr)) != EOF){
		if(!(i & 0x0f)){
			fprintf(fpw, "\n\t\tHEX\t%02X", (unchar)c);
		}
		else{
			fprintf(fpw, ",%02X", (unchar)c);
		}
		i++;
	}
	fprintf(fpw, "\n");
	fprintf(fpw, ";-------------- next go to data -----------------------------------------\n");
	fprintf(fpw, "\t\tHEX\tFF\n");
	fprintf(fpw, ";\n");

}
