/****************************************************************
*		l`o|Cgf[^ Ro[g			*
*			( gcc ys_mpdtcnv1.c -o ys_mpdtcnv1)	*
*						by K.Koda	*
****************************************************************/

#include <stdio.h>
#include <sys/time.h>

#define unchar	unsigned char
#define unshort unsigned short

#define ON	1
#define OFF	0

FILE	       *fpr, *fpw;

void
mpptcnv(char *);

void
main(int argc, char **argv)
{
	/****** ϐ錾 ******/

	char		ptdt_file[100];

	/****** `FbN ******/
	if (argc != 2) {
		printf("Usage: ys_obtpcnv (ptdt_file)\n");
		exit(1);
	}
	/****** l`o|Cgf[^ t@Cnodm ******/
	strcpy(ptdt_file, argv[1]);
	strcat(ptdt_file, ".pdt");
	if (!(fpr = fopen(ptdt_file, "r"))) {
		printf("can't open (%s) !!\n", ptdt_file);
		exit(1);
	}

	/****** Ro[gf[^o̓t@Cnodm ******/
	if (!(fpw = fopen("mpptdt.lis", "w"))) {
		printf("can't open (mpptdt.lis) !!\n");
		exit(1);
	}
	/****** l`o|Cgf[^ ϊ ******/
	mpptcnv(ptdt_file);

	/****** t@Cbknrd ******/
	fclose(fpr);
	fclose(fpw);
}

/****************************************************************
*		l`o|Cgf[^ ϊ			*
****************************************************************/
void
mpptcnv(char *ptdt_file)
{
	/****** ϐ錾 ******/
	int		i,j,k;

	struct	tm *time;
	struct	timeval tp;
	struct	timezone tzp;

	gettimeofday(&tp, &tzp);
	time=localtime( &tp );

	/****** x Zbg ******/
	fprintf(fpw, ";****************************************************************\n");
	fprintf(fpw, ";*\t\tmap point status data (%04d/%02d/%02d %02d:%02d:%02d)\t*\n",
			time->tm_year+1900,time->tm_mon+1,time->tm_mday,time->tm_hour,time->tm_min,time->tm_sec);
	fprintf(fpw, ";****************************************************************\n");
	fprintf(fpw, ";\n");

	/*** Ro[g!! ***/
	fgetc(fpr);
	fgetc(fpr);

	for (i = 0; i < 10; i++){
	    fprintf(fpw, ";--------------- DATA No.%02D ---------------\n", i);
	    fprintf(fpw, "\t\tHEX\t%02X,%02X,%02X,%02X\n", fgetc(fpr),fgetc(fpr),fgetc(fpr),fgetc(fpr) );
	    fprintf(fpw, "\t\tHEX\t%02X,%02X,%02X,%02X\n", fgetc(fpr),fgetc(fpr),fgetc(fpr),fgetc(fpr) );
	    fprintf(fpw, "\t\tHEX\t%02X,%02X\n",fgetc(fpr),fgetc(fpr) );

	    for (j = 0; j < 4; j++){
		fprintf ( fpw, ";------------------------------- move data%1X\n", j);
		fprintf ( fpw, "\t\tHEX\t%02X\t\t; NEXT GOTO\n", fgetc(fpr) );

		for (k = 0; k < 16; k++){
			fprintf ( fpw, "\t\tHEX\t%02X\n", fgetc(fpr) );
			fprintf ( fpw, "\t\tHEX\t%02X\n", fgetc(fpr) );
			fprintf ( fpw, "\t\tHEX\t%02X\n", fgetc(fpr) );
			fprintf ( fpw, "\t\tHEX\t%02X\n", fgetc(fpr) );
			fprintf ( fpw, ";\n" );
		}

	    }

	    fprintf(fpw, ";\n");
	}
}
