/************************************************************************/
/*		yoshi bZ[Wf[^ ҏW program			*/
/*									*/
/*		  Ver 0.1  Programmed by N.Okajima   [Jul,20,1995]	*/
/*									*/
/*		   (gcc -O ys_msgchk.c -o ys_msgchk)			*/
/************************************************************************/
#include "ys_msgchk.h"
#include <stdio.h>


static int dot_count();


/************************************************************************/
/*  Main								*/
/************************************************************************/
main( argc,argv )
int argc;
char **argv;
{
	FILE *rfp,*wfp;
	unchar read_buf[256];
	unchar write_buf[128][256];
	unchar work_buf[256];
	char r_fname[256];
	char w_fname[256];
	unchar *p;
	register int  i;
	int  line_cnt;
	int  dot_cnt,work;

	if( argc!=2 ) {
		puts( "Usage ys_msgchk inputfile" );
		exit( 1 );
	}

	strcpy( r_fname,argv[1] );
	strcat( r_fname,".dat" );
	strcpy( w_fname,"ch_" );
	strcat( w_fname,argv[1] );
	strcat( w_fname,".dat" );

	for( i=0; i<128; i++ ) write_buf[i][0]='\0';
	work_buf[0]='\0';

	if( (rfp=fopen(r_fname,"r"))==NULL ) {
		printf( "open error !! %s\n",r_fname );
		exit( 1 );
	}


	if( (wfp=fopen(w_fname,"w"))==NULL ) {
		printf( "open error !! %s\n",w_fname );
		exit( 1 );
	}

	line_cnt=0;
	dot_cnt=0;
	while( fgets( read_buf,256,rfp ) != NULL ) {
		read_buf[strlen(read_buf)-1]='\0';
		p=(unchar *)strtok( read_buf," " );

		if( p == NULL ) {	/* 1 Word  Only */
			work = dot_count( read_buf );
			dot_cnt += work;
			if( dot_cnt+4 > DOT_MAX ) {
				strcpy( write_buf[line_cnt],work_buf );
				strcat( write_buf[line_cnt],"\n" );
				line_cnt++;
				strcpy( work_buf,read_buf );
				strcat( work_buf," " );
				dot_cnt=work;
				dot_cnt+=4;
				continue;
			} else {
				strcat( work_buf,read_buf );
				strcat( work_buf," " );
				dot_cnt+=4;
			}
		} else {
			work = dot_count( p );
			dot_cnt += work;
			if( dot_cnt+4 > DOT_MAX ) {
				strcpy( write_buf[line_cnt],work_buf );
				strcat( write_buf[line_cnt],"\n" );
				line_cnt++;
				strcpy( work_buf,p );
				strcat( work_buf," " );
				dot_cnt=work;
				dot_cnt+=4;
			} else {
				strcat( work_buf,p );
				strcat( work_buf," " );
				dot_cnt+=4;
			}
		}

		while( (p=(unchar *)strtok( NULL," " )) != NULL ) {
			work = dot_count( p );
			dot_cnt += work;
			if( dot_cnt+4 > DOT_MAX ) {
				strcpy( write_buf[line_cnt],work_buf );
				strcat( write_buf[line_cnt],"\n" );
				line_cnt++;
				dot_cnt=work;
				strcpy( work_buf,p );
				strcat( work_buf," " );
				dot_cnt+=4;
			} else {
				strcat( work_buf,p );
				strcat( work_buf," " );
				dot_cnt+=4;
			}
		}
	}

	if( strlen(work_buf) != 0 ) {
		strcpy( write_buf[line_cnt],work_buf );
		strcat( write_buf[line_cnt],"\n" );
		line_cnt++;
	}

	fprintf( wfp,"@05\n" );
	for( i=0; i<line_cnt; i++ ) {
		fprintf( wfp,"%s",write_buf[i] );

		if( i == line_cnt-1 ) {
			if( line_cnt < 5 ) {
				fprintf( wfp,"@0F\n@FF\n" );
			} else {
				fprintf( wfp,"@12@12@12@12\n@12@12@12@12\n@0F\n@FF\n" );
			}

			continue;
		}

		switch( i ) {
			case 0:
				fprintf( wfp,"@06\n" );
				break;
			case 1:
				fprintf( wfp,"@07\n" );
				break;
			case 2:
				fprintf( wfp,"@08\n" );
				break;
			case 3:
				fprintf( wfp,"@0E\n" );
				break;
			default:
				if( i != 0 && (i%4) == 0 ) {
					fprintf( wfp,"@0A\n@12@12@12@12\n@12@12@12@12\n@0E\n" );
				} else {
					fprintf( wfp,"@12@12@12@12\n@12@12@12@12\n@0E\n" );
				}
				break;
		}

	}

	fclose( wfp );
	fclose( rfp );
}

/************************************************************************/
/*  Dot Count															*/
/************************************************************************/
static int dot_count( wd )
unchar *wd;
{
	register int i,j;
	int len,dcnt;

	len=strlen( wd );

	dcnt=0;
	for( i=0; i<len; i++ ) {
		for( j=0; j<MOJI_CNT; j++ ) {
			if ( (unchar)(wd[i])==moji_tbl[j] ) break ;
		}
		if( j<MOJI_CNT ) {
			dcnt+=dot_tbl[j] ;
		}
	}

	return( dcnt );
}
