/************************************************************************/
/*			yoshi åǡ ɥåȥȥå program		*/
/*																		*/
/*			Ver 0.1  Programmed by N.Okajima   [Jul,20,1995]			*/
/*																		*/
/*				(gcc -O ys_msgcntchk.c -o ys_msgcntchk)					*/
/************************************************************************/
#include "ys_msgchk.h"
#include <stdio.h>

#define OPENING_MAX		190
#define MSSAGE_MAX		126
#define ENDING_MAX		192
#define COURCE_MAX		124

static int dot_count( char *wd );

/************************************************************************/
/*  Main																*/
/************************************************************************/
main( int argc,char **argv )
{
	FILE *rfp;
	char read_buf[256];
	char r_fname[256];
	int  opt;
	int  line_cnt;
	int  dot_cnt;
	int  dot_max;
	int  over_flag;

	if( argc!=3 ) {
		printf( "Usage : ys_msgcntchk -[O,M,E,C] inputfile\n" );
		printf( "        -O : Opening       Dot Check\n" );
		printf( "        -M : Message Block Dot Check\n" );
		printf( "        -E : Ending        Dot Check\n" );
		printf( "        -C : Cource In     Dot Check\n" );
		exit( 1 );
	}

	opt=argv[1][1];
	switch( opt ) {
		case 'O':
		case 'o':
			dot_max=OPENING_MAX;
			break;
		case 'M':
		case 'm':
			dot_max=MSSAGE_MAX;
			break;
		case 'E':
		case 'e':
			dot_max=ENDING_MAX;
			break;
		case 'C':
		case 'c':
			dot_max=COURCE_MAX;
			break;
		default:
			printf( "Usage : ys_msgcntchk -[O,M,E,C] inputfile\n" );
			printf( "        -O : Opening       Dot Check\n" );
			printf( "        -M : Message Block Dot Check\n" );
			printf( "        -E : Ending        Dot Check\n" );
			printf( "        -C : Cource In     Dot Check\n" );
			exit( 1 );
	}

	strcpy( r_fname,argv[2] );
	strcat( r_fname,".dat" );

	if( (rfp=fopen(r_fname,"r"))==NULL ) {
		printf( "open error !! %s\n",r_fname );
		exit( 1 );
	}

	printf( "==== File : %s ====\n",r_fname );

	over_flag=0;
	line_cnt=0;
	while( fgets( read_buf,256,rfp ) != NULL ) {
		line_cnt++;
		read_buf[strlen(read_buf)-1]='\0';
		dot_cnt = dot_count( read_buf );
		if( dot_cnt > dot_max ) {
			printf( "LINE:%d %dDots (%dDots Over !!)\n",line_cnt,dot_cnt,dot_cnt-dot_max );
			over_flag=1;
		}
	}

	if( !over_flag ) printf( "***** No Error. *****\n\n" );
	
	fclose( rfp );
}

/************************************************************************/
/*  Dot Count															*/
/************************************************************************/
static int dot_count( char *wd )
{
	register int i,j;
	int len,dcnt;

	len=strlen( wd );

	dcnt=0;
	for( i=0; i<len; i++ ) {
		for( j=0; j<MOJI_CNT; j++ ) {
			if ( wd[i]==moji_tbl[j] ) break ;
		}
		if( j<MOJI_CNT ) {
			dcnt+=dot_tbl[j] ;
		}
	}

	return( dcnt );
}
