/************************************************************************
 *									*
 *	bV[ bZ[W sN`[ f[^쐬			*
 *					Programmed by  Y. Yamamoto.	*
 *						Sep. 12(Mon), JST 1994	*
 *								Ver 1.00*
 ************************************************************************/

#include	<stdio.h>

#define		ON		1
#define		OFF		0
#define		TRUE		1
#define		FALSE		0
#define		unint		unsigned int
#define		unshort		unsigned short
#define		unchar		unsigned char
#define		min(x, y)	((x) < (y) ? (x) : (y))
#define		max(x, y)	((x) < (y) ? (y) : (x))

#define		R_FILE_SIZE	0x400

/************************************************************************
 *									*
 *	ϐ								*
 *									*
 ************************************************************************/
int		Argc;
char		**Argv, **Args;

/************************************************************************
 *									*
 *	main								*
 *									*
 ************************************************************************/
void main(int argc, char **argv, char **args)
{
	FILE	*rfp, *wfp;
	unshort	r_data[R_FILE_SIZE][8];
	int	i, j, k;
	
	Argc = argc;
	Argv = argv;
	Args = args;

	if(Argc != 3) {
		printf("%s readfile.CGX writefile\n", Argv[0]);
		exit(1);
	}

	if((rfp = fopen(Argv[1], "r")) == NULL) {
		perror(Argv[1]);
		exit(1);
	}
	if((fread(r_data, sizeof(unshort),
		  R_FILE_SIZE * 8, rfp)) != R_FILE_SIZE * 8) {
		perror(Argv[1]);
		exit(1);
	}
	fclose(rfp);
	
	if((wfp = fopen(Argv[2], "w")) == NULL) {
		perror(Argv[2]);
		exit(1);
	}
	for(i = 0; i < R_FILE_SIZE; i += 0x10) {
		for(j = 0; j < 0x8; j += 0x1) {
			fprintf(wfp, "\tBYTE ");
			for(k = 0; k < 0x10; k += 0x1) {
				fprintf(wfp, "%03d",
					((r_data[i + k][j] >> 8) & 0xff));
				if(k == 0xf) {
					fprintf(wfp, "\n");
				} else {
					fprintf(wfp, ",");
				}
			}
		}
	}
	fclose(wfp);
}



