/********************************************************************************/
/*										*/
/*	Yohi xxxx.OBZ file --> asm source file convet program Ver 0.002		*/
/*										*/
/*		     Programed By N.Okajima [1994.06.13]			*/
/*										*/
/********************************************************************************/
#include <math.h>
#include <stdio.h>

#define unchar	unsigned char
#define unshort unsigned short

#define ON	1
#define OFF	0

FILE *fpr0,*fpr1,*fpw0;

/********************************************************************************/
/* Main										*/
/********************************************************************************/
main()
{
	/****** ram set ******/
	char	obj_name[100][20];
	int	obj_no[100][64];
	unchar	obj_data[100][64][6][4],read_buf[0x180];
	unchar	baby_data[100][64][3];
	unchar	egg_data[100][64][3];

	int	f_max;
	int	i,j,k,l,p;
	int	f;

	unshort char_no;
	unchar	yusen;

	/****** sprite file name table file open ******/
	if( (fpr0=fopen("ysobj.TBL","r")) == 0 ){
		printf("can't open (ysobj.TBL) !!\n");
		exit(1);
	}

	/****** obz file convert ******/
	f_max = 0;
	while( fgets(obj_name[f_max],20,fpr0) != NULL ){

		/****** sprite file open ******/
		obj_name[f_max][strlen(obj_name[f_max])-1]='\0';
		strcat( obj_name[f_max],".OBZ" );

		if( !(fpr1=fopen(obj_name[f_max],"r")) ){
			printf( "can't open (%s) !!\n",obj_name[f_max] );
			exit(1);
		}

		/****** sprite file convert ******/
		for( i=0;i<64;i++ ) {
			obj_no[f_max][i] = 0;

			baby_data[f_max][i][0] = 0;	/* Ԃ񑊑΂wʒuZbgiftHgj */
			baby_data[f_max][i][1] = 0;	/*	 h    x	   h		  */
			baby_data[f_max][i][2] = 6;	/*     h  vC[Ƃ̗D揇ʃ`FbNf[^ */
			egg_data[f_max][i][0]  = 0;	/* ^}S΂wʒuZbgiftHgj */
			egg_data[f_max][i][1]  = 0;	/*	h   x		 h		*/
			egg_data[f_max][i][2]  = 6;	/*     h  vC[Ƃ̗D揇ʃ`FbNf[^ */

			fread( read_buf,sizeof(unchar),0x180,fpr1 );
			for( f=0,p=0,j=0,k=0; j<64; j++,p+=6 ) {
				if( read_buf[p]&0x80 ) {

					char_no = (short)(read_buf[p+0]&0x0f)*0x100+(short)(read_buf[p+1]);

					if (char_no == 0x22e) {
						baby_data[f_max][i][0] = read_buf[p+2];	    /* Ԃ񑊑΂wʒuZbg */
						baby_data[f_max][i][1] = read_buf[p+3] - 2; /*	     h	   x	 h	*/
						baby_data[f_max][i][2] = k;		    /*	   h  vC[Ƃ̗D揇ʃ`FbNf[^ */
					}
					else if (char_no == 0x24e) {
						egg_data[f_max][i][0]  = read_buf[p+2]; /* ^}S΂wʒuZbg */
						egg_data[f_max][i][1]  = read_buf[p+3]; /*	h   x	  h	  */
						egg_data[f_max][i][2]  = k;		/*   h	 vC[Ƃ̗D揇ʃ`FbNf[^ */
					}
					else if (char_no != 0x24a) {

						obj_no[f_max][i]++;

						obj_data[f_max][i][k][0]=read_buf[p+0]&0x0f;	/* chara no.(H) */
						obj_data[f_max][i][k][0]|=(read_buf[p+0]&0x40)>>1;
						obj_data[f_max][i][k][0]|=read_buf[p+4]&0xc0;
						obj_data[f_max][i][k][3]=read_buf[p+1];		/* chara no.(L) */
						obj_data[f_max][i][k][1]=read_buf[p+2];		/* X pos */
						obj_data[f_max][i][k][2]=read_buf[p+3];		/* Y pos */
						k++;
					}
					else {
						obj_no[f_max][i] = 0;
						j = 64;
					}
				}
			}

			if( obj_no[f_max][i] > 6 ) {
				printf( "OBJ data 6 over !! (%s no.=%02X)\n", obj_name[f_max],i );
				exit(1);
			}

		}
		f_max++;

		/****** sprite file close ******/
		fclose( fpr1 );
	}

	/****** sprite file name table file close ******/
	fclose( fpr0 );

	/****** ys_pld.h make ******/
	if( !(fpw0=fopen("../sfc/ys_pld.h","w")) ){
		printf("can't open (../sfc/ys_pld.h) !!\n");
		exit(1);
	}

	fprintf( fpw0,"\t\tNOLIST\n" );
	fprintf( fpw0,";\n" );
	fprintf( fpw0,";************************************************************************\n" );
	fprintf( fpw0,";*\t\t\t\t\t\t\t\t\t*\n" );
	fprintf( fpw0,";*\ttitle name\t: \"yossy\"\t\t\t\t\t*\n" );
	fprintf( fpw0,";*\tproccess\t: player pattern name\t\t\t\t*\n" );
	fprintf( fpw0,";*\tfile name\t: ys_pld.h\t\t\t\t\t*\n" );
	fprintf( fpw0,";*\t\t\t\t\t\t\t\t\t*\n" );
	fprintf( fpw0,";************************************************************************\n" );
	fprintf( fpw0,";\n" );
	fprintf( fpw0,";\n" );

	for( i=0,k=0;i<f_max;i++ ){
		obj_name[i][2] = '\0';
		for( j=0;j<32;j++ ){
			if( obj_no[i][j] ){
				fprintf( fpw0,"%s%02X\t\tEQU\t%03XH\n",obj_name[i],j,k++ );
			}
		}
		fprintf( fpw0,";\n" );
	}

	fprintf( fpw0,";\n" );
	fprintf( fpw0,";\n" );
	fprintf( fpw0,";\n" );
	fprintf( fpw0,";\n" );
	fprintf( fpw0,";\n" );
	fprintf( fpw0,"\t\tLIST\n" );

	fclose( fpw0 );

	/****** ys_pldt.asm make ******/
	if( !(fpw0=fopen("../sfc/ys_pldt.asm","w")) ){
		printf("can't open (../sfc/ys_pldt.asm) !!\n");
		exit(1);
	}

	fprintf( fpw0,";************************************************************************\n" );
	fprintf( fpw0,";*\t\t\t\t\t\t\t\t\t*\n" );
	fprintf( fpw0,";*\ttitle name\t: \"yossy\"\t\t\t\t\t*\n" );
	fprintf( fpw0,";*\tproccess\t: player pattern data\t\t\t\t*\n" );
	fprintf( fpw0,";*\tfile name\t: ys_pldt\t\t\t\t\t*\n" );
	fprintf( fpw0,";*\t\t\t\t\t\t\t\t\t*\n" );
	fprintf( fpw0,";************************************************************************\n" );
	fprintf( fpw0,";\n" );
	fprintf( fpw0,";\n" );
	fprintf( fpw0,";\n" );
	fprintf( fpw0,";\n" );
	fprintf( fpw0,";------------------------------------------------------------------------\n" );
	fprintf( fpw0,";-\t\tglobal symbol\t\t\t\t\t\t-\n" );
	fprintf( fpw0,";------------------------------------------------------------------------\n" );
	fprintf( fpw0,"\t\tGLB\tCHDTNO,CHDTIN,CHYPAD\n" );
	fprintf( fpw0,";\n" );
	fprintf( fpw0,";\n" );
	fprintf( fpw0,";************************************************************************\n" );
	fprintf( fpw0,";*\t\t\t\t\t\t\t\t\t*\n" );
	fprintf( fpw0,";*\t\tdata start\t\t\t\t\t\t*\n" );
	fprintf( fpw0,";*\t\t\t\t\t\t\t\t\t*\n" );
	fprintf( fpw0,";************************************************************************\n" );
	fprintf( fpw0,";\n" );
	fprintf( fpw0,";\n" );
	fprintf( fpw0,"\t\tEXTEND\n" );
	fprintf( fpw0,";\n" );
	fprintf( fpw0,";\n" );
	fprintf( fpw0,"Group_4C\tGROUP\tPlay_data\n" );
	fprintf( fpw0,"Play_data\tSECT\tREL\n" );
	fprintf( fpw0,";\n" );

	fprintf( fpw0,";************************************************************************\n" );
	fprintf( fpw0,";*\t\tnumber of OBJ data\t\t\t\t\t*\n" );
	fprintf( fpw0,";************************************************************************\n" );
	fprintf( fpw0,"CHDTNO\t\tEQU\t$\n" );
	for( i=0,k=0;i<f_max;i++ ){
		for( j=0;j<64;j++ ){
			if( obj_no[i][j] ){
				fprintf( fpw0,"\t\tBYTE\t%03XH\t;[%03X] \t<%s%02X>\n",obj_no[i][j],k++,obj_name[i],j );
			}
		}
		fprintf( fpw0,";\n" );
	}

	fprintf( fpw0,";************************************************************************\n" );
	fprintf( fpw0,";*\t\tOBJ data pointer data\t\t\t\t\t*\n" );
	fprintf( fpw0,";************************************************************************\n" );
	fprintf( fpw0,"CHDTIN\t\tEQU\t$\n" );
	for( i=0,k=0,l=0;i<f_max;i++ ){
		for( j=0;j<64;j++ ){
			if( obj_no[i][j] ){
				fprintf( fpw0,"\t\tWORD\t%05XH\t;[%03X] \t<%s%02X>\n",l,k++,obj_name[i],j );
				l += obj_no[i][j] * 4;
			}
		}
		fprintf( fpw0,";\n" );
	}

	fprintf( fpw0,";************************************************************************\n" );
	fprintf( fpw0,";*\t\tOBJ data\t\t\t\t\t\t*\n" );
	fprintf( fpw0,";************************************************************************\n" );
	fprintf( fpw0,"CHYPAD\t\tEQU\t$\n" );
	for( i=0,k=0;i<f_max;i++ ){
		for( j=0;j<64;j++ ){
			if( obj_no[i][j] ){
				for( l=0;l<obj_no[i][j];l++ ){
					fprintf( fpw0,"\t\tBYTE\t" );
					fprintf( fpw0, "%03XH",obj_data[i][j][l][0] );
					fprintf( fpw0,",%03XH",obj_data[i][j][l][1] );
					fprintf( fpw0,",%03XH",obj_data[i][j][l][2] );
					fprintf( fpw0,",%03XH",obj_data[i][j][l][3] );
					if( !l ) fprintf( fpw0,"\t;[%03X] \t<%s%02X>",k++,obj_name[i],j );
					fprintf( fpw0,"\n" );
				}
				fprintf( fpw0,";\n" );
			}
		}
		fprintf( fpw0,";\n" );
	}

	fprintf( fpw0,";\n" );
	fprintf( fpw0,";\n" );
	fprintf( fpw0,";\n" );
	fprintf( fpw0,";\n" );
	fprintf( fpw0,";\n" );
	fprintf( fpw0,"\t\tEND\n" );

	fclose( fpw0 );

	/****** ys_pldt_e.asm make ******/
	if( !(fpw0=fopen("../sfc/ys_pldt_e.asm","w")) ){
		printf("can't open (../sfc/ys_pldt_e.asm) !!\n");
		exit(1);
	}

	fprintf( fpw0,";************************************************************************\n" );
	fprintf( fpw0,";*\t\t\t\t\t\t\t\t\t*\n" );
	fprintf( fpw0,";*\ttitle name\t: \"yossy\"\t\t\t\t\t*\n" );
	fprintf( fpw0,";*\tproccess\t: player pattern enemy data\t\t\t*\n" );
	fprintf( fpw0,";*\tfile name\t: ys_pldt_e\t\t\t\t\t*\n" );
	fprintf( fpw0,";*\t\t\t\t\t\t\t\t\t*\n" );
	fprintf( fpw0,";************************************************************************\n" );
	fprintf( fpw0,";\n" );
	fprintf( fpw0,";\n" );
	fprintf( fpw0,";\n" );
	fprintf( fpw0,";\n" );
	fprintf( fpw0,";------------------------------------------------------------------------\n" );
	fprintf( fpw0,";-\t\tglobal symbol\t\t\t\t\t\t-\n" );
	fprintf( fpw0,";------------------------------------------------------------------------\n" );
	fprintf( fpw0,"\t\tGLB\tBABY_AD_X,BABY_AD_Y\n" );
	fprintf( fpw0,"\t\tGLB\tEGG_AD_X,EGG_AD_Y\n" );
	fprintf( fpw0,";\n" );
	fprintf( fpw0,";\n" );
	fprintf( fpw0,";************************************************************************\n" );
	fprintf( fpw0,";*\t\t\t\t\t\t\t\t\t*\n" );
	fprintf( fpw0,";*\t\tdata start\t\t\t\t\t\t*\n" );
	fprintf( fpw0,";*\t\t\t\t\t\t\t\t\t*\n" );
	fprintf( fpw0,";************************************************************************\n" );
	fprintf( fpw0,";\n" );
	fprintf( fpw0,";\n" );
	fprintf( fpw0,"Group_3\t\tGROUP\tPlayer_e_data\n" );
	fprintf( fpw0,"Player_e_data\tSECT\tREL\n" );
	fprintf( fpw0,";\n" );
	fprintf( fpw0,";\n" );
	fprintf( fpw0,"\t\tEXTEND\n" );
	fprintf( fpw0,";\n" );
	fprintf( fpw0,";\n" );

	fprintf( fpw0,";************************************************************************\n" );
	fprintf( fpw0,";*\t\tԂ̃vC[Ƃ̑Έʒuf[^\t\t\t*\n" );
	fprintf( fpw0,";************************************************************************\n" );
	fprintf( fpw0,"BABY_AD_X\tEQU\t$\n" );
	for( i=0,k=0;i<f_max;i++ ){
		for( j=0;j<64;j++ ){
			if( obj_no[i][j] ){
				if (baby_data[i][j][2] != 0) yusen = 0x00; else yusen = 0x40;
				fprintf( fpw0,"\t\tBYTE\t(%03XH&0BFH)+%02XH\t;[%03X] \t<%s%02X>\n",baby_data[i][j][0],yusen,k++,obj_name[i],j );
			}
		}
		fprintf( fpw0,";\n" );
	}

	fprintf( fpw0,"BABY_AD_Y\tEQU\t$\n" );
	for( i=0,k=0;i<f_max;i++ ){
		for( j=0;j<64;j++ ){
			if( obj_no[i][j] ){
				fprintf( fpw0,"\t\tBYTE\t%03XH\t\t;[%03X] \t<%s%02X>\n",baby_data[i][j][1],k++,obj_name[i],j );
			}
		}
		fprintf( fpw0,";\n" );
	}

	fprintf( fpw0,";\n" );


	fprintf( fpw0,";************************************************************************\n" );
	fprintf( fpw0,";*\t\t^}S̃vC[Ƃ̑Έʒuf[^\t\t\t\t*\n" );
	fprintf( fpw0,";************************************************************************\n" );
	fprintf( fpw0,"EGG_AD_X\t\tEQU\t$\n" );
	for( i=0,k=0;i<f_max;i++ ){
		for( j=0;j<64;j++ ){
			if( obj_no[i][j] ){
				if (baby_data[i][j][2] != 0 ) yusen = 0x00; else yusen = 0x40;
				fprintf( fpw0,"\t\tBYTE\t(%03XH&0BFH)+%02XH\t;[%03X] \t<%s%02X>\n",egg_data[i][j][0],yusen,k++,obj_name[i],j );
			}
		}
		fprintf( fpw0,";\n" );
	}

	fprintf( fpw0,"EGG_AD_Y\t\tEQU\t$\n" );
	for( i=0,k=0;i<f_max;i++ ){
		for( j=0;j<64;j++ ){
			if( obj_no[i][j] ){
				fprintf( fpw0,"\t\tBYTE\t%03XH\t\t;[%03X] \t<%s%02X>\n",egg_data[i][j][1],k++,obj_name[i],j );
			}
		}
		fprintf( fpw0,";\n" );
	}


	fprintf( fpw0,";\n" );
	fprintf( fpw0,";\n" );
	fprintf( fpw0,";\n" );
	fprintf( fpw0,";\n" );
	fprintf( fpw0,";\n" );
	fprintf( fpw0,"\t\tEND\n" );

	fclose( fpw0 );

}



/********************************************************************************/
/*										*/
/********************************************************************************/
#ifdef OLD_VERSION /***********************************************************************************/
	/****** obj file convert ******/
	f_max = 0;
	while( fgets(obj_name[f_max],20,fpr0) != NULL ){

		/****** sprite file open ******/
		i=0; while( obj_name[f_max][i] != '\n' && obj_name[f_max][i] != '\0'  ) i++;
		obj_name[f_max][i] = '\0';
		strcat( obj_name[f_max],".SPR" );
		if( !(fpr1=fopen(obj_name[f_max],"r")) ){
			printf( "can't open (%s) !!\n",obj_name[f_max] );
			exit(1);
		}

		/****** sprite file convert ******/
		for( i=0;i<32;i++ ){
			if( obj_no[f_max][i] = (int)fgetc( fpr1 ) ){
				if( obj_no[f_max][i] > 6 ){
					printf( "OBJ data 6 over !! (%s no.=%02X)\n", obj_name[f_max],i );
					exit(1);
				}
				for( j=0;j<obj_no[f_max][i];j++ ){
					fgetc( fpr1 );							/* X pos(H)	*/
					obj_data[f_max][i][j][1] =  fgetc( fpr1 );			/* X  " (L)     */
					fgetc( fpr1 );							/* Y pos(H)	*/
					obj_data[f_max][i][j][2] =  fgetc( fpr1 );			/* Y  " (L)     */
					obj_data[f_max][i][j][0] =  fgetc( fpr1 );			/* chara no.(H) */
					obj_data[f_max][i][j][3] =  fgetc( fpr1 );			/*     "    (L) */
					obj_data[f_max][i][j][0] |= fgetc( fpr1 ) & 0xc0;		/* atr data	*/
					obj_data[f_max][i][j][0] |= ( fgetc( fpr1 ) & 0x02 ) << 4;	/* size		*/
				}
			}
		}
		f_max++;

		/****** sprite file close ******/
		fclose( fpr1 );

	}

	/****** sprite file name table file close ******/
	fclose( fpr0 );
#endif /***********************************************************************************/
