;************************************************************************
;*									*
;*	title name	: "yossy tool"					*
;*	proccess	: edit process					*
;*	file name	: yst_edit					*
;*									*
;************************************************************************
;
;
		SALL
;
		include		yst_header.inc
;
		XALL
;
;
;------------------------------------------------------------------------
;
;		Super_Y edit-tool		1992.03.05(THU)
;
;------------------------------------------------------------------------
;
;
;=============================================== (syt_edit) =============
		GLB	PLAY,MODESL,ERROR,INPTDT,WNDWST
		GLB	PSCTDT1,UNITST0
		GLB	MSSCRMD,PLPSST
		GLB	PLY510,STRTBFST,ALLMOVE,DSPCOPYMD
		GLB	EN_SDPTCAL,UNDR_ITCOL,UNDR_COL
		GLB	STUNT0_SB_ST,UNDO_GO
;
;=============================================== (sytz_main) ==============
		EXT	VRAMCL,OAMCLR2,JSRSUB,DTBFCLR,DTBFCLR1
;
;=============================================== (syt_init) ==============
		EXT	BGWRITE,BGSET,UNITST
		EXT	MDSL,CGST,BGWR,PLMD,ERR0,DTSV,DTLD,DTDS,BGDS
		EXT	UPSL,DWSL,LFSL,RISL,STIN,MFRM,DTDL,GAME
		EXT	MSSC,PSST,ALMV,DSPCP,ITSB
		EXT	BGDISP
;
;=============================================== (syt_bgsc0) =============
		EXT	KOTESB,KAHNSB
;
;=============================================== (syt_data) ==============
		EXT	COSEDAT
;
;=============================================== yst_en_edit =============
		GLB	ENBGMV
;
;=============================================== yst_en_file =============
		EXT	UN_ENAME_SET
;=========================================================================
BS_LMT		EQU	00FH
;=========================================================================
;
;
;=============== _~[ ==================================================
		GLB	M_HEIIN,M_ATKIN,M_HEIMV,M_ATKMV,M_HAZIN
		GLB	M_HAZMV,M_LIFIN,M_LIFMV,M_ETRIN,M_TH1IN
		GLB	M_ETRMV,M_FUSIN,M_TH1MV,M_FUSMV,M_MISIN
		GLB	M_MISMV,M_TAMIN,M_HZKMV,M_TAMMV
		GLB	M_THOIN,M_THOMV,M_PTRIN,M_PTRMV,M_SUIIN
		GLB	M_SUIMV,M_BAKIN,M_BAKMV,M_DR0IN,M_DR1IN
		GLB	M_BBYIN,M_DR2IN,M_DR3IN,M_DR4IN,M_DR0MV
		GLB	M_DR5IN,M_DR1MV,M_BBYMV,M_EGGIN,M_DR2MV
		GLB	M_DR3MV,M_DR4MV,M_ATAIN,M_DR5MV,M_EGGMV
		GLB	M_ATAMV,STT_PL_GO,HMPIN,STT_PL_STP
		GLB	BGM_SET,BS_SCRE,TMUP,D_00,BOSSQ_MD7_SET
		GLB	INT_STAT,EGG_SAVE,EGG_LOAD,MHDPLY_JSL
		GLB	M_ITMIN,M_ITMMV
;
;
;************************************************************************
;*									*
;*		program start						*
;*									*
;************************************************************************
;
;
		EXTEND
;
;
		MEM8
		IDX8
;
Group_17	GROUP	Edit_pro
Edit_pro	SECT	REL
;
;
;************************************************************************
;*		Play main				(PLAY)		*
;************************************************************************
PLAY		EQU	$
		LDA	#002
		STA	!ENBGFLG
;
		LDA	INKEY
		CMP	#L_U		; inkey [U] ON ?
		BNE	PASS00_000	;	NO -> PASS00_000
		LDA	#ITSB		; Gc[ցEEE
		STA	!MODENO		;
		STZ	!ENBGFLG	;
		JSL	>UN_ENAME_SET
		RTL
;
PASS00_000	EQU	$
		CMP	#L_Z		; inkey [Z] ON ?
		BNE	PASS00		;	NO -> PASS00
;
		JSR	MSSCINT
;
PASS00		EQU	$
		CMP	#RIS
		BNE	PASS02		; [F_9] --- (player pos set) ?
;
		LDA	#PSST
		STA	MODENO
		STZ	!TIMSTFG
		RTL
;
PASS02		EQU	$
		LDA	!MOUSEBT	; hmotsjbgio[
		AND	#11000000B	;	J[\ʒuNA ?
		BEQ	PASS02_10	;	NO -> PASS02_10
		STZ	!INDTPT
;
PASS02_10	EQU	$
		LDA	DTMODE	       ; ka-he-n mode ?
		BEQ	PASS20		;	NO -> PASS20
;
		LDA	INKEY
		CMP	#L_X		; "X" ON ?
		BNE	PASS10		;	NO -> PASS10
		LDA	CRSSMMD
		CMP	#002H		; Y lock mode ?
		BEQ	PASS30		;	YES -> PASS30
		EOR	#001H		; X lock
		AND	#001H		;	ON or OFF set
		BRA	PASS15
PASS10		EQU	$
		CMP	#L_Y		; "Y" ON ?
		BNE	PASS30		;	NO -> PASS30
		LDA	CRSSMMD
		CMP	#001H		; X lock mode ?
		BEQ	PASS30		;	YES -> PASS30
		EOR	#002H		; Y lock
		AND	#002H		;	ON or OFF set
PASS15		EQU	$
		STA	CRSSMMD
		BRA	PASS30
;
PASS20		EQU	$
		STZ	CRSSMMD
;
PASS30		EQU	$
		LDA	MOUSEBT
		AND	#01000000B
		BEQ	PLY0FF		; mouse [L] key --- (data set) ?
		JMP	PLY100		;yes
;					; no
PLY0FF		EQU	$
		LDX	#00		;(X) <-- edit mode select no.
		LDA	INKEY
		CMP	#L_Q
		BEQ	PLY0FF2		;"NORMAL" ? ( yes:PLY0FF2 )
;
		INX
		CMP	#L_W
		BEQ	PLY0FF2		;"INSERT" ? ( yes:PLY0FF2 )
;
		INX
		CMP	#L_R
		BEQ	PLY0FF2		;"S-DEL" ? ( yes:PLY0FF2 )
;
		INX
		CMP	#L_T
		BEQ	PLY0FF2		;"DELETE" ? ( yes:PLY0FF2 )
;
		INX
		CMP	#L_S
		BEQ	PLY0FF2		;"SERACH" ? ( yes:PLY0FF2 )
;
		INX
		CMP	#L_G		; "1 unit move" ?
		BEQ	PLY0FF2		;	YES -> PLY0FF2
;
		INX
		CMP	#L_I		; all move ?
		BNE	PLY0FFE		;	NO -> PLY0FFE
;
		LDY	#0FFH
		STY	SRCHPT
		STY	SRCHPT+1
		STZ	!UNTMVMD
;
PLY0FF2		EQU	$
		STX	EDMODE
		JMP	PLY040
;
PLY0FFE		EQU	$
		LDX	#MDSL
		CMP	#MOD
		BNE	PLY000		; [F_1] --- (mode select) ?
;
		LDA	EDMODE
		ASL	A
		INC	A		;[ +08H ]
		ASL	A
		ASL	A
		ASL	A
		STA	MOUSWK0
		JMP	PLY200
;
PLY000		EQU	$		; no
		CMP	#RTN
		BNE	PLY020		;undo ? ( no:PLY020 )
;
;-------------- to undo data back_up !! -----------------
;
		I16
;
		LDX	UNDONO
		BNE	PLY010		;undo data nothing ? ( no:PLY010 )
;
		SEP	#00010000B	;index 8 bit mode set
		JMP	PLY040
;
PLY010		EQU	$
		LDA	>UNDOBUF-1,X
		STA	>DTBUFF-1,X
		DEX
		BNE	PLY010
;;;;		LDX	#00
		STX	UNDONO	       ;undo buffer cancel !!
;
		LDX	UNDOXP1	       ;cursol pos load
		STX	CRXPSL1
		LDX	UNDOYP1
		STX	CRYPSL1
		LDX	UNDOXP2
		STX	CRXPSL2
		LDX	UNDOYP2
		STX	CRYPSL2
;
		M16
		I8
;
		LDX	UNDOSFT	       ;move cousol index load
		STX	SIFTFG
;
		JSR	CSRDSCK
		BCC	PLY014		;Y display ? ( yes:PLY014 )
;
		JSR	CNTSCST
;
PLY014		EQU	$
;
		M8
;
		JMP	>UNITST0	; unit buffer set
;
;--------------------------------------------------------
;
PLY020		EQU	$
		CMP	#SPS
		BNE	PLY028		;return last input data pos ? ( no:PLY028 )
;
;-------------- return last input data pos --------------
		LDA	LASTFG
		BNE	PLY022		;last input data nothing ? ( no:PLY022 )
		JMP	PLY040
;
PLY022		EQU	$
;
		M16
;
		LDA	LASTXP
		STA	CRXPSL1
		STA	CRXPSL2
		LDA	LASTYP
		STA	CRYPSL1
		STA	CRYPSL2
;
		JSR	CNTSCST
;
		JMP	>REDISP
;
;----------------------------------------------------------------
;-		cursol display check				-
;----------------------------------------------------------------
CSRDSCK		EQU	$
		LDX	SIFTFG
		LDA	CRXPSL1,X
		SEC
		SBC	<SCCH1
		SEC
		SBC	#08H
		CMP	#0F8H-08H
		BCS	CSRDC10		;X display ? ( no:CSRDC10 )
;
		LDA	CRYPSL1,X
		SEC
		SBC	<SCCV1
		SEC
		SBC	#08H
		CMP	#0A8H-08H
CSRDC10		EQU	$
		RTS
;
;----------------------------------------------------------------
;-		cursol center scroll counter set		-
;----------------------------------------------------------------
CNTSCST		EQU	$
		LDX	SIFTFG
		LDA	CRXPSL1,X
		SEC
		SBC	#070H
		CMP	#0FFF8H
		BPL	PLY024
		LDA	#0FFF8H
PLY024		EQU	$
		STA	<SCCH1
		STA	<SCCH2
		STA	<SCCH3
		LDA	CRYPSL1,X
		SEC
		SBC	#050H
		CMP	#0FFF8H
		BPL	PLY026
		LDA	#0FFF8H
PLY026		EQU	$
		STA	<SCCV1
		STA	<SCCV2
		STA	<SCCV3
;
		M8
;
		RTS
;
;--------------------------------------------------------
;
PLY028		EQU	$
		CMP	#F_8		; [F_8] ON ?
		BNE	PLY029		;	NO -> PLY029
		LDA	!BG3CLSFG
		EOR	#004H
		AND	#004H
		STA	!BG3CLSFG	; ܂ڂ
		RTL
;
PLY029		EQU	$
		CMP	#F_0
		BNE	PLY030		; [F_10] -- (character change) ?
;
;-------------- game mode -----------------------
		LDA	#GAME
		STA	MODENO
		STZ	ENDTPT
		STZ	ENDTPT+1
		LDA	#01H
		STA	FADMK
		RTL
;
PLY030		EQU	$
		CMP	#CHC
		BNE	PLY031		; [F_7] --- (character change) ?
;
;-------------- go to BG course status data input -------
		LDX	#STIN
		STX	MODENO
		STZ	STINFG
		RTL
;
PLY031		EQU	$
;;;;		CMP	#SPS
;;;;		BEQ	PLY180		; [space] --- (cursol1 = cursol2) ?
;					; no
		LDX	#MFRM
		CMP	#FRM
		BEQ	PLY450		; [F_2] --- (media format) ?
;
		LDX	#DTSV
		CMP	#SAV
		BEQ	PLY300		; [F_3] --- (data save) ?
;					; no
		LDX	#DTLD
		CMP	#LOD
		BEQ	PLY400		; [F_4] --- (data load) ?
;					; no
		LDX	#DTDL
		CMP	#DEL
		BEQ	PLY480		; [F_5] --- (data delete) ?
;					; no
		LDX	#DTDS
		CMP	#UNT
		BEQ	PLY500		; [F_6] --- (unit display) ?
;					; no
		LDA	INKEY3
		LDX	#LFSL
;;;;		    CMP	    #LFS
;;;;		    BEQ	    PLY800	    ; [F_8] --- (left scroll) ?
		CMP	#L_K
		BNE	PLY032		; [K] ----- (left scroll) ?
;					; yes
PLY800		EQU	$
		JMP	PLY820
;
PLY032		EQU	$
		LDX	#RISL
;;;;		    CMP	    #RIS
;;;;		    BEQ	    PLY900	    ; [F_9] --- (right scroll) ?
		CMP	#L_L
		BNE	PLY034		; [L] ----- (right scroll) ?
;					; yes
PLY900		EQU	$
		JMP	PLY920
;
PLY034		EQU	$
		CMP	#UPS		; [UPS] ON ?
		BNE	PLY034_00	;	NO -> PLY034_00
		LDA	#DSPCP
		STA	!MODENO
		RTL
;
PLY034_00	EQU	$
		LDX	#UPSL
		CMP	#L_O
		BEQ	PLY600		; [O] ----- (up scroll) ?
;					; no
		LDX	#DWSL
		CMP	#DWS
		BEQ	PLY700		; [DWS] --- (down scroll) ?
		CMP	#L_c
		BEQ	PLY700		; [,] ----- (down scroll) ?
;
PLY040		EQU	$
		JSR	MSNDTST		; select no display
;
		JSR	BGMOVE		; BG. move
		JSR	CRMV		; key read and cursol mov; BG. set
		JSL	>BGSET
;
		JSR	DTIMAIN		; data input
;
;-------------	input data set key on  -------------
PLY100		EQU	$
		PHB			;(DBR) save
		PHK			;(DBR) <-- (PBR)
		PLB
;
		LDX	#000
		LDA	!MUSEBUF
		BEQ	PLY100_10
		INX
		INX
PLY100_10	EQU	$
		JSR	(MUSDBL_ADR,X)
;
		JSR	DPDISP		; dtpt & buffer data display
		JSR	MODEPL
;
		PLB
		RTL
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+	}EX _uNbN `FbN			+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
MUSDBL_ADR	EQU	$
		WORD	MUSDBLINT,MUSDBL
;
;
;;;;;------------- coursol equrl key on -------------
;;;;PLY180		EQU	$
;;;;		LDA	CRYPSL1
;;;;		STA	CRYPSL2
;;;;		LDA	CRXPSL1
;;;;		STA	CRXPSL2
;;;;		LDA	#0FFH
;;;;		STA	INKEY
;;;;		BRA	PLY040
;
;-------------	delete mode -------------
PLY480		EQU	$
		STZ	DELFLG
		BRA	PLY410
;
;-------------	media format -------------
PLY450		EQU	$
		STZ	FRMFLG
		BRA	PLY200
;
;-------------	load mode -------------
PLY400		EQU	$
		STZ	LDFLG
PLY410		EQU	$
		BRA	PLY200
;
;-------------	save mode -------------
PLY300		EQU	$
		STZ	SVFLG
;
		PHX			;(X) save
		JSL	>PLY510
		PLX			;(X) load
;
;------------- mode select display key on -------------
PLY200		EQU	$
		STX	MODENO
		RTL
;
;-------------	unit display mode -------------
PLY500		EQU	$
		STX	MODENO
		STZ	MPDSFG
;
PLY510		EQU	$
		PHB			;(DBR) save
		PHK			;(DBR) <-- (PBR)
		PLB
		JSR	SDPTCAL		;[STDTPT] set
		PLB
		RTL
;
;-------------	up scroll -------------
PLY600		EQU	$
		MEM16
		REP	#00100000B	; memory 16bit mode
;
		LDA	<SCCV1
		CMP	#0FFF8H
		BEQ	PLY680		; scroll ok ?
;					; yes
		SEC
		SBC	#00100H
		CMP	#0FFF8H
		BPL	PLY640		; limit over ?
;					; yes
		LDA	#0FFF8H
PLY640		EQU	$
		STA	MVSCV1
;
		MEM8
		SEP	#00100000B	; memory 8bit mode
;
		STX	MODENO
PLY680		EQU	$
		SEP	#00100000B	; memory 8bit mode
		RTL
;
;
;-------------	down scroll -------------
PLY700		EQU	$
		MEM16
		REP	#00100000B	; memory 16bit mode
;
		LDA	<SCCV1
		CMP	#0758H
		BEQ	PLY680		; scroll ok ?
;					; yes
		CLC
		ADC	#00100H
		CMP	#0758H+1
		BCC	PLY640		; limit over ?
;					; yes
		LDA	#0758H
		BRA	PLY640
;
;
;-------------	left scroll -------------
PLY820		EQU	$
		MEM16
		REP	#00100000B	; memory 16bit mode
;
		LDA	<SCCH1
		CMP	#0FFF8H
		BEQ	PLY680		; scroll ok ?
;					; yes
		SEC
		SBC	#00100H
		CMP	#0FFF8H
		BPL	PLY840		; limit over ?
;					; yes
		LDA	#0FFF8H
PLY840		EQU	$
		STA	MVSCH1
;
		MEM8
		SEP	#00100000B	; memory 8bit mode
;
		STX	MODENO
		RTL
;
;
;-------------	right scroll -------------
PLY920		EQU	$
		MEM16
		REP	#00100000B	; memory 16bit mode
;
		LDA	<SCCH1
		CMP	#0F08H
		BEQ	PLY680		; scroll ok ?
;					; yes
		CLC
		ADC	#00100H
		CMP	#0F08H+1
		BCC	PLY840		; limit over ?
;					; yes
		LDA	#0F08H
		BRA	PLY840
;
;
;
;
;
;
;
		MEM8
		IDX8
;************************************************************************
;*		data input type select			(DTIMAIN)	*
;************************************************************************
INPDADD		EQU	$
		HEX	FF,01
;
;-------------------------------------- data input
DSPDT		EQU	$
		BYTE	040H,0C2H,000H,032H
		BYTE	048H,0C2H,000H,032H
DSPDTE		EQU	$
;
DTIMAIN		EQU	$
		LDA	INKEY
		CMP	#NUL
		BEQ	DTIPT20		; key in ?
;					; yes
		CMP	#RTN
		BNE	DTIPT00		; [return] ?
;					; yes
		STZ	INDTPT	       ; data set point clear
		BRA	DTIPT20
;
DTIPT00		EQU	$
		CMP	#SU0
		BCC	PPAASS
		CMP	#L_G
		BCC	DTIPT10		; input key (0 ~ F) ?
;					; no
PPAASS		EQU	$
		LDA	INKEY3
		LDX	#00
		LDY	#00
		CMP	#L_H
		BEQ	DTIPT02
		INY
		CMP	#L_N
		BEQ	DTIPT02
;
		INX
		DEY
		CMP	#L_J
		BEQ	DTIPT02
		INY
		CMP	#L_M
		BNE	DTIPT20
DTIPT02		EQU	$
		LDA	INPBUF,X
		PHX
		TAX
		LDA	>INPTDT,X
		CLC
		TYX
		ADC	>INPDADD,X
		AND	#0FH
		ORA	#SU0
		CMP	#SU9+1
		BCC	DTIPT04
;
;;;;		CLC
		ADC	#L_A-SU9-1-1
DTIPT04		EQU	$
		PLX
		STA	INPBUF,X
		BRA	DTIPT20
;
DTIPT10		EQU	$
		LDX	INDTPT
		LDA	INKEY
		STA	INPBUF,X       ; input data set
;
		TXA
		EOR	#00000001B
		STA	INDTPT
;
;-------------- BG data type no. OAM set ----------------
DTIPT20		EQU	$
		LDX	#DSPDTE-DSPDT-1
DTIPT40		EQU	$
		LDA	>DSPDT,X
		STA	>UTNOAM,X
		DEX
		BPL	DTIPT40		;
;					;
		LDA	INPBUF
		STA	>UTNOAM+4*0+2
		LDA	INPBUF+1
		STA	>UTNOAM+4*1+2
;
		LDA	<FRCNT
		AND	#00001000B
		BEQ	DTIPT80		; flashing ?
;					; yes
		LDA	INDTPT
		ASL	A
		ASL	A
		TAX
		LDA	#030H
		STA	>UTNOAM+4*0+3,X
DTIPT80		EQU	$
		LDX	INPBUF+0
		LDA	>INPTDT,X
		ASL	A
		ASL	A
		ASL	A
		ASL	A
		STA	<WORK0
		LDX	INPBUF+1
		LDA	>INPTDT,X
		ORA	<WORK0
		RTS
;
;
;
;
;************************************************************************
;*		Mode no. display			(BSNDTST)	*
;************************************************************************
MSNDT		EQU	$
		BYTE	0C8H,010H,000H,038H
		BYTE	0D0H,010H,000H,038H
		BYTE	0D8H,010H,000H,038H
		BYTE	0E0H,010H,000H,038H
		BYTE	0E8H,010H,000H,038H
		BYTE	0F0H,010H,000H,038H
;
		BYTE	0C8H,020H,0E0H,038H	;
		BYTE	0D8H,020H,0E2H,038H	;  [course name]
		BYTE	0E8H,020H,0E4H,038H	;
MSNDTE		EQU	$
;
MSNDTCT		EQU	MSNDTE-MSNDT-1
;
;
MSDATA		EQU	$
		BYTE	080H,081H,082H,083H,084H,085H	;00 : NORMAL
		BYTE	090H,091H,092H,093H,094H,095H	;01 : S-DEL
		BYTE	0A0H,0A1H,0A2H,0A3H,0A4H,0A5H	;02 : INSEART
		BYTE	0B0H,0B1H,0B2H,0B3H,0B4H,0B5H	;03 : DELETE
		BYTE	0C0H,0C1H,0C2H,0C3H,0C4H,0C5H	;04 : SEARCH
		BYTE	055H,04EH,049H,054H,04DH,056H	;05 : UNITMV
;;;;K;;;;		BYTE	0D0H,0D1H,0D2H,0D3H,0D4H,0D5H	;05 : B-CHNG
;
;
MSNDTST		EQU	$
		PHB
		PHK
		PLB			; (DBR) set
;
		LDX	#MSNDTCT
MSN0100		EQU	$
		LDA	MSNDT,X
		STA	>MODOAM,X
		DEX
		BPL	MSN0100		;
;					;
		LDY	EDMODE	       ; (Y) <-- mode no.
		CPY	#006H
		BCS	MSN0900
		LDX	MDDTPT,Y
		LDA	MSDATA+0,X
		STA	>MODOAM+4*0+2
		LDA	MSDATA+1,X
		STA	>MODOAM+4*1+2
		LDA	MSDATA+2,X
		STA	>MODOAM+4*2+2
		LDA	MSDATA+3,X
		STA	>MODOAM+4*3+2
		LDA	MSDATA+4,X
		STA	>MODOAM+4*4+2
		LDA	MSDATA+5,X
		STA	>MODOAM+4*5+2
;
		LDA	#00101010B
		STA	>OAMSUB+((CHCOAM-OAM)>>4)
;
		LDA	DISPMDDT,Y
		EOR	!BG3CLSFG
		STA	!MANSEL
;
MSN0900		EQU	$
		PLB			; (DBR) reset
		RTS
;
;
DISPMDDT	EQU	$
		BYTE	016H,016H,017H,017H,017H,017H
;
;
;
;************************************************************************
;*		Mode play				(MODEPL)	*
;************************************************************************
INPTDT		EQU	$
;				ASC --> HEX
;			 0  1  2  3  4	5  6  7	 8  9  A  B  C	D  E  F
		HEX	FF,FF,FF,FF,FF,FF,FF,FF,FF,FF,FF,FF,FF,FF,FF,FF ; 0
		HEX	FF,FF,FF,FF,FF,FF,FF,FF,FF,FF,FF,FF,FF,FF,FF,00 ; 1
		HEX	7F,FF,FF,FF,FF,FF,FF,FF,FF,FF,FF,FF,FF,25,26,27 ; 2
		HEX	00,01,02,03,04,05,06,07,08,09,FF,FF,FF,28,FF,FF ; 3
		HEX	FF,0A,0B,0C,0D,0E,0F,10,11,12,13,14,15,16,17,18 ; 4
		HEX	19,1A,1B,1C,1D,1E,1F,20,21,22,23,FF,FF,FF,FF,29 ; 5
		HEX	FF,FF,FF,FF,FF,FF,FF,FF,FF,FF,FF,FF,FF,FF,FF,FF ; 6
		HEX	FF,FF,FF,FF,FF,FF,FF,FF,FF,FF,FF,FF,FF,FF,FF,FF ; 7
;
;
MODEPL		EQU	$
		LDA	EDMODE
		JSL	>JSRSUB
Normal		WORD	DATSL		;00   NORMAL
Insert		WORD	INSERT		;01   INSERT
S_del		WORD	SRCDEL		;02   S-DEL
Delete		WORD	DELET		;03   DELET
Search		WORD	SEARCH		;04   SERCH
		WORD	ONEMOVE		;05   P jbg ړ [h
		WORD	ALLMVINT	;06
		WORD	ALLMVEND	;08
;;;;B_chng		WORD	BSCHNG		;05   B_CHNG
;
normal		EQU	(Normal-Normal)/2
insert		EQU	(Insert-Normal)/2
s_del		EQU	(S_del-Normal)/2
delete		EQU	(Delete-Normal)/2
search		EQU	(Search-Normal)/2
;;;;b_chng		EQU	(B_chng-Normal)/2
;
;
;
;
;----------------------------------------------------------------
;-		to undo data back_up !!				-
;----------------------------------------------------------------
UNDOBFST	EQU	$
;
		I16
;
		LDX	STDTPT
		INX
		STX	UNDONO
UNDBS010	EQU	$
		LDA	>DTBUFF-1,X
		STA	>UNDOBUF-1,X
		DEX
		BNE	UNDBS010
;
		LDX	CRXPSL1	       ;cursol pos save
		STX	UNDOXP1
		LDX	CRYPSL1
		STX	UNDOYP1
		LDX	CRXPSL2
		STX	UNDOXP2
		LDX	CRYPSL2
		STX	UNDOYP2
		LDA	SIFTFG
		STA	UNDOSFT	       ;move cousol index save
;
		I8
;
		RTS
;
;
;------------------------------------------------------------------------
;-		Data select & buffer set [NORMAL]	(DATSL)		-
;------------------------------------------------------------------------
DATSL		EQU	$
		LDA	MOUSEBT
		AND	#01000000B
		BEQ	DATEND		; mouse [L] key --- (data set) ?
;					; no
		JSR	UNDOBFST
;
DATSL1		EQU	$
		LDX	INPBUF+0
		LDA	>INPTDT,X
		ASL	A
		ASL	A
		ASL	A
		ASL	A
		STA	<WORK+2
		LDX	INPBUF+1
		LDA	>INPTDT,X
		TSB	<WORK+2		;(WK2) <-- type no.
;
		LDA	DTMODE
		BEQ	DTSL010		; kotei ?
		JMP	BGUTS200
;					; yes
;-------------- kotei data set --------------------------
DTSL010		EQU	$
		LDX	<WORK+2
		LDA	>KOTESB,X
		BPL	DTSL020		;type no. error ? ( no:DTSL020 )
		JMP	ERRST0
;
DTSL020		EQU	$
;
		I16
;
		LDX	STDTPT	       ; (X) <-- set data pointer
		LDA	#00
		STA	>DTBUFF,X	;kotei flag set
		JSR	CPSCAL
		STA	>DTBUFF+1,X	; X,Y(H) set
		LDA	<WORK+1
		STA	>DTBUFF+2,X	; X,Y(L) set
		LDA	<WORK+2
		STA	>DTBUFF+3,X	; kotei data type no. set
		LDA	#0FFH
		STA	>DTBUFF+4,X	; end code
;
		I8
;
		STZ	SIFTFG
;
DTSL030		EQU	$
;
;-------------- last input data pos set -------------------------
;
		M16
;
		LDA	CRXPSL1
		AND	#0FF0H
		STA	LASTXP
		LDA	CRYPSL1
		AND	#07F0H
		STA	LASTYP
;
		M8
;
		LDA	#01H
		STA	LASTFG
;
		JSL	>UNITST0		; unit buffer set
;
DATEND		EQU	$
		RTS
;
;-------------- kahen data set --------------------------
KAHNNO		EQU	$	;number of data byte
		HEX	4	;[00]
		HEX	4	;[01]
		HEX	5	;[02]
;
BGUTS200	EQU	$
		LDX	<WORK+2
		LDA	>KAHNSB,X
		CMP	#0FFH
		BNE	BGUTS202	; type no. error ? ( no:BGUTS202 )
		JMP	ERRST0
;
BGUTS202	EQU	$
		TXA
;
		I16
;
		LDX	STDTPT	       ; (X) <-- set data pointer
		STA	>DTBUFF,X	; kahen type no. set
		TAY			;(Y) <-- kahen type no.
		JSR	CPSCAL
		STA	>DTBUFF+1,X	; X,Y(H) set
		LDA	<WORK+1
		STA	>DTBUFF+2,X	; X,Y(L) set
;
		I8
;
		TYX
		LDA	>KAHNSB,X
		STA	<WORK+6		;(WK6) <-- kahen data status data
;
		M16
;
		LDA	CRXPSL1
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		STA	<WORK+3
		LDA	CRSSMMD	       ; end cursol semi auto flag
		AND	#00001H
		BEQ	TAIHI00
		LDA	XTAIHI
		BRA	TAIHI05
TAIHI00		EQU	$
		LDA	CRXPSL2
TAIHI05		EQU	$
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		SEC
		SBC	<WORK+3
		BPL	BGUTS210	;- X wide ? ( no:BGUTS210 )
		LDY	<WORK+6
		BMI	BGUTS210	;X wide + only ? ( no:BGUTS210 )
;
		EOR	#00FFH
		INC	A
BGUTS210	EQU	$
		STA	<WORK+3		;(WK3) <-- X wide
;
		LDA	CRYPSL1
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		STA	<WORK+4
		LDA	CRSSMMD	       ; end cursol semi auto flag
		AND	#00002H
		BEQ	TAIHI10
		LDA	YTAIHI
		BRA	TAIHI15
TAIHI10		EQU	$
		LDA	CRYPSL2
TAIHI15		EQU	$
		LSR	A
		LSR	A
		LSR	A
		LSR	A
;
		M8
;
		SEC
		SBC	<WORK+4
		BPL	BGUTS220	;- Y wide ? ( no:BGUTS220 )
		BIT	<WORK+6
		BVS	BGUTS220	;Y wide + only ? ( no:BGUTS220 )
;
		EOR	#0FFH
		INC	A
BGUTS220	EQU	$
		STA	<WORK+4		;(WK4) <-- Y wide
;
		LDA	<WORK+6
		AND	#3FH
		ASL	A
		TAX
		JSR	(!KAHNSEL,X)	;kahen sub select
;
		JSR	DTSL030
;
;-------------- cursol reset ------------------------------------
		LDX	SIFTFG	       ;main cursol set !!
		TXA
		EOR	#02H
		TAY
;
		M16
;
		LDA	CRXPSL1,X      ;main cursol <-- sub cursol !!
		STA	CRXPSL1,Y
		LDA	CRYPSL1,X
		STA	CRYPSL1,Y
;
		M8
;
		STZ	SIFTFG	       ;main cursol set !!
		RTS
;
;--------------------------------------------------------
;-		error set !!				-
;--------------------------------------------------------
ERRST0		EQU	$
;
		MI8
;
		LDA	#03FH
		STA	ERRFLG
		LDA	#ERR0
		STA	MODENO
		RTS
;
;--------------------------------------------------------
;-		kahen sub select			-
;--------------------------------------------------------
KAHNSEL		EQU	$
		WORD	KAHNSB0
		WORD	KAHNSB1
		WORD	KAHNSB2
;
;-------------- kahen sub.1 ---------------------
KAHNSB0		EQU	$
		I16			; index 16bit mode
;
		LDX	STDTPT	       ; (X) <-- set data pointer
		LDA	<WORK+3
		STA	>DTBUFF+3,X	; data number set
		LDA	#0FFH
		STA	>DTBUFF+4,X	; end code set
;
		I8			; index 8bit mode
		RTS
;
;-------------- kahen sub.2 ---------------------
KAHNSB1		EQU	$
		I16			; index 16bit mode
;
		LDX	STDTPT	       ; (X) <-- set data pointer
		LDA	<WORK+4
		STA	>DTBUFF+3,X	; data number set
		LDA	#0FFH
		STA	>DTBUFF+4,X	; end code set
;
		LDA	<WORK4		; xW ~bg `FbN !!
		BPL	KAHNSB15	;
		LDA	<WORK6
		AND	#040H
		BNE	KAHNSB15
		LDA	#034H		;
		STA	!ERRFLG		;
		LDA	#ERR0		;
		STA	!MODENO		;
		LDA	#0FFH
		STA	>DTBUFF,X	; end code set
		I8			; index 8bit mode
		PLA
		PLA
		RTS
;
KAHNSB15	EQU	$
		I8			; index 8bit mode
		RTS
;
;-------------- kahen sub.3 ---------------------
KAHNSB2		EQU	$
		I16			; index 16bit mode
;
		LDX	STDTPT	       ; (X) <-- set data pointer
		LDA	<WORK+3
		STA	>DTBUFF+3,X	; data number set
		LDA	<WORK+4
		STA	>DTBUFF+4,X	; data number set
		LDA	#0FFH
		STA	>DTBUFF+5,X	; end code set
;
		LDA	>DTBUFF,X
		CMP	#021H
		BCC	KAHNSB23
		CMP	#035H
		BCC	KAHNSB25
;
KAHNSB23	EQU	$
		LDA	<WORK6
		AND	#040H
		BNE	KAHNSB25
		LDA	<WORK4		; xW ~bg `FbN !!
		BPL	KAHNSB25	;
		LDA	#034H		;
		STA	!ERRFLG		;
		LDA	#ERR0		;
		STA	!MODENO		;
		LDA	#0FFH
		STA	>DTBUFF,X	; end code set
		I8			; index 8bit mode
		PLA
		PLA
		RTS
;
KAHNSB25	EQU	$
		I8			; index 8bit mode
		RTS
;
;-------------- kahen sub.4 ---------------------
KAHNSB3		EQU	$
		I16			; index 16bit mode
;
		LDX	STDTPT	       ; (X) <-- set data pointer
		LDA	CRXPSH2
		AND	#0FH
		STA	<WORK+5
		LDA	CRYPSH2
		AND	#07H
		ASL	A
		ASL	A
		ASL	A
		ASL	A
		ORA	<WORK+5
		STA	>DTBUFF+3,X	; data number set
		LDA	#0FFH
		STA	>DTBUFF+4,X	; end code set
;
		I8			; index 8bit mode
		RTS
;
;
;
;------------------------------------------------------------------------
;-		Inseart [INSERT]			(INSERT)	-
;------------------------------------------------------------------------
INSERT		EQU	$
		LDA	MOUSEBT
		AND	#01000000B
		BNE	INS0010		; mouse [L] key --- (data set) ?
;					; no
		REP	#00100000B	;memory 16 bit mode
;
		LDA	SRCHNO
		JMP	DPD0300		; point display
;
INS0010		EQU	$
		JSR	INSPL
		LDA	ERRFLG
		BNE	INSEND		;error ? ( yes:INSEND )
;
		JSL	>UNITST0		; unit buffer set
;
		STZ	EDMODE		       ;nomal mode return
INSEND		EQU	$
		RTS
;
INSPL		EQU	$
		JSR	UNDOBFST
;
		MI16
;
		LDX	INSTPT
		BPL	INP0000		;serach pointer nothing ? ( no:INP0000 )
		JMP	ERRST0
;
;-------------- now data save -------------------
INP0000		EQU	$
		LDA	STDTPT
		SEC
		SBC	INSTPT
		PHA			;number of copy data byte save
		TAY
		STX	STDTPT
;
		M8
;
INP0010		EQU	$
		LDA	>DTBUFF,X
		STA	>DTBUFF2,X
		INX
		DEY
		BPL	INP0010
;
		I8
;
;-------------- data set ------------------------
		JSR	DATSL1
;
		MI16
;
		PLA
;
		LDY	ERRFLG
		BNE	INP0070		;error return ? ( yes:INP0070 )
;
		STA	<WORK1E		;(WK1E,1F) <-- number of copy data byte save
;
;-------------- data change ---------------------
		LDY	#04		;(Y) <-- number of kotei data byte
		LDX	INSTPT
		LDA	>DTBUFF,X
		AND	#00FFH
		BEQ	INP0040		;kotei ? ( yes:INP0040 )
;
		PHX			;(X) save
		TAX
		LDA	>KAHNSB,X
		PLX			;(X) load
		AND	#003FH
		TAY
		LDA	!KAHNNO,Y
		AND	#00FFH
		TAY			;(Y) <-- number of kahen data byte
INP0040		EQU	$
		TYA
		CLC
		ADC	INSTPT
		STA	INSTPT
		STA	SRCHPT
		INC	SRCHNO
		TAY
		CLC
		ADC	<WORK1E
		STA	<WORK1E
;
		LDA	#DTBUFF
		STA	<WORK
;
		M8
;
		LDA	#BANK DTBUFF
		STA	<WORK+2
INP0050		EQU	$
		CPY	<WORK1E
		BCS	INP0060
		LDA	>DTBUFF2,X
		STA	[<WORK],Y
		INX
		INY
		BRA	INP0050
;
INP0060		EQU	$
		LDA	#0FFH		;end code set
		STA	[<WORK],Y
;
INP0070		EQU	$
;
		MI8
;
		RTS
;
;
;
;
;------------------------------------------------------------------------
;-		Search- delete [S_DEL]			(SRCDEL)	-
;------------------------------------------------------------------------
SRCDEL		EQU	$
		LDA	MOUSEBT
		AND	#01000000B
		BEQ	SDLEND		; mouse [L] key --- (data set) ?
;					; no
		JSR	CPSCAL		; (WK0,1) <-- check x,y-pos.
;
		M16
;
		LDA	#0FFFFH
		STA	SRCHPT
SRD0000		EQU	$
		PHA
;
		M8
;
		JSR	SRCHSB		;data search
;
		M16
;
		PLA
		BCC	SRD0002		;search ok ? ( no:SRD0002 )
		LDA	SRCHPT
		BRA	SRD0000
;
SRD0002		EQU	$
		BPL	SRD0010		;error ? ( yes:SRD0010 )
		JMP	SAPERR
;
SRD0010		EQU	$
;
		M8
;
		JSR	DELPL
		LDA	ERRFLG
		BNE	SDLEND		;error ? ( yes:SDLEND )
;
		JSL	>UNITST0			; unit buffer set
;
		STZ	EDMODE		       ;nomal mode return
SDLEND		EQU	$
		RTS
;
;
;
;
;------------------------------------------------------------------------
;-		Delete [DELETE]				(DELET)		-
;------------------------------------------------------------------------
DELET		EQU	$
		LDA	MOUSEBT
		AND	#01000000B
		BEQ	DELEND		; mouse [L] key --- (data set) ?
;					; no
		JSR	DELPL
		LDA	ERRFLG
		BNE	DELEND		;error ? ( yes:DELEND )
;
		JSL	>UNITST0			; unit buffer set
;
		STZ	EDMODE		       ;nomal mode return
DELEND		EQU	$
		RTS
;
;
DELPL		EQU	$
		JSR	UNDOBFST
;
		I16
;
		LDY	SRCHPT
		BMI	DLPER10
;
		PHB			;(DBR) save
		LDA	#BANK DTBUFF
		PHA
		PLB
DLP0010		EQU	$
;
		M16
;
		LDX	#04H		;(X) <-- number of kotei data byte
		LDA	DTBUFF,Y
		AND	#00FFH
		BEQ	DLP0020		;kotei ? ( yes:DLP0020 )
;
		CMP	#0FFH
		BEQ	DLPERR		;data end ? ( yes:DLPERR )
;
		TAX
		LDA	>KAHNSB,X
		AND	#003FH
		TAX
		LDA	>KAHNNO,X
		AND	#00FFH
		TAX			;(X) <-- number of kahen data byte
DLP0020		EQU	$
		STX	<WORK		;(WK0,1) <-- number of data byte
		TYA
		CLC
		ADC	<WORK
		TAX
;
		LDA	>STDTPT
		SEC
		SBC	<WORK
		STA	<WORK
DLP0030		EQU	$
		LDA	DTBUFF,X
		STA	DTBUFF,Y
		INX
		INY
		DEC	<WORK
		BPL	DLP0030
;
		MI8
;
		PLB
		RTS
;
;-------------- delete error set ----------------
DLPERR		EQU	$
		PLB

DLPER10		EQU	$
;
		MI8
;
		LDA	#03FH
		STA	ERRFLG
		LDA	#ERR0
		STA	MODENO
		RTS
;
;
;
;
;------------------------------------------------------------------------
;-		Search [SEARCH]				(SEARCH)	-
;------------------------------------------------------------------------
SEARCH		EQU	$
		LDA	MOUSEBT
		AND	#01000000B
		BEQ	SRCH200		; mouse [L] key --- (data set) ?
;					; no
		JSR	CPSCAL		; (WK0,1) <-- check x,y-pos.
		STZ	<WORKF
SRCH100		EQU	$
		JSR	SRCHSB
		BCS	SRCH200
		LDA	<WORKF
		BNE	SAPERR		; not search ? ( yes:SAPERR )
		INC	<WORKF
		LDA	#0FFH
		STA	!SRCHPT
		STA	!SRCHPT+1
		BRA	SRCH100
;;;;K;;;;		BCC	SAPERR		; not search ? ( yes:SAPERR )
;
SRCH200		EQU	$
		MI16			; memory , index 16bit mode
;
		LDX	SRCHPT
		BMI	SRCH500		; search display ok ?
;					; yes
		LDY	#04		;(Y) <-- number of kotei data byte
		LDA	>DTBUFF,X
		AND	#00FFH		;[ (B)=0 ]
		BEQ	SRCH210		; kahen data ?
;					; yes
		PHX			;(X) save
		TAX
		LDA	>KAHNSB,X
		PLX			;(X) load
		AND	#003FH
		TAY
		LDA	!KAHNNO,Y
		AND	#00FFH		;[ (B)=0 ]
		TAY			;(Y) <-- number of kahen data byte
;
SRCH210		EQU	$
		STY	<WORK		;(WK0) <-- number of data byte
;
		M8
;
		PHB			;(DBR) save
		LDA	#BANK OAM	;(DBR) <-- OAM(B)
		PHA
		PLB
;
		LDY	#00		;(Y) <-- OAM index
SRCH220		EQU	$
		LDA	#C_HI
		STA	!PTDOAM+(DPTDT0-DPTDT+2)+4*4,Y
		PHX
		LDA	>DTBUFF,X
		PHA
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		TAX
		LDA	>PSCTDT1,X
		STA	!PTDOAM+(DPTDT0-DPTDT+2)+4*5,Y
		PLA
		AND	#00001111B
		TAX
		LDA	>PSCTDT1,X
		STA	!PTDOAM+(DPTDT0-DPTDT+2)+4*6,Y
		PLX
		INX
		TYA			;[ (Y) < FF !! then (B)=0 ]
		CLC
		ADC	#4*3
		TAY
		DEC	<WORK
		BNE	SRCH220
;
		PLB
;
		M16
		I8
;
		LDA	SRCHNO
		JSR	DPD0300		; point display
;
SRCH500		EQU	$
;
		MI8
;
		RTS
;
;
;
;-------------- search error set ----------------
SAPERR		EQU	$
;
		MI8
;
		LDA	#0FFH
		STA	SRCHPT	       ; search point clear
		STA	SRCHPT+1
		STA	INSTPT	       ; insert	     "
		STA	INSTPT+1
;
		LDA	#03FH
		STA	ERRFLG
		LDA	#ERR0
		STA	MODENO
		RTS
;
;
;
;--------------------------------------------------------
;-		data search				-
;--------------------------------------------------------
SRCHSB		EQU	$
;
		MI16
;
		LDX	SRCHPT
		BPL	SRCH010		; initial ?
;					; yes
		INX			;[ LDX #00 ]
		STZ	SRCHNO
		BRA	SRCH020
;
;-------------- pointer up !! -------------------
SRCH000		EQU	$
;
		M16
;
SRCH010		EQU	$
		LDY	#04		;(Y) <-- number of kotei data byte
		LDA	>DTBUFF,X
		AND	#00FFH
		BEQ	SRCH012		;kotei ? ( yes:SRCH012 )
;
		CMP	#00FFH
		BEQ	SRCH050		;end code ? ( yes:SRCH050 )
;
		PHX			;(X) save
		TAX
		LDA	>KAHNSB,X
		PLX			;(X) load
		AND	#003FH
		TAY
		LDA	!KAHNNO,Y
		AND	#00FFH
		TAY
SRCH012		EQU	$
		STY	<WORK+2
		TXA
		CLC
		ADC	<WORK+2
		TAX
		INC	SRCHNO	       ; search data no. up !!
;
;-------------- X,Y pos search ------------------
SRCH020		EQU	$
;
		M8
;
		LDA	>DTBUFF,X
		CMP	#0FFH
		BEQ	SRCH050		;end code ? ( yes:SRCH050 )
;
		LDA	>DTBUFF+1,X
		CMP	<WORK
		BNE	SRCH000		;= pos ? ( no:SRCH000 )
		LDA	>DTBUFF+2,X
		CMP	<WORK+1
		BNE	SRCH000		;	    "
;
		STX	SRCHPT	       ; search pointer up !!
		STX	INSTPT	       ; insert	     "
;
		IDX8
		SEP	#00010001B	;(C)<-1
		RTS
;
;-------------- not search return set !! --------
SRCH050		EQU	$
;
		MI8
;
		CLC
		RTS
;
;----------------------------------------------------------------
;		1,2,3,4		X --> WORK2   Y --> WORK4	-
;----------------------------------------------------------------
CPSCAL		EQU	$
		LDA	CRXPSL1
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		STA	<WORK+1
		LDA	CRYPSL1
		AND	#11110000B
		TSB	<WORK+1		;(WK1) <-- X,Y(L)
		LDA	CRYPSH1
		ASL	A
		ASL	A
		ASL	A
		ASL	A
		ORA	CRXPSH1
		STA	<WORK		;(WK0) <-- X,Y(H)
		RTS
;
;
;
;****************************************************************
;*								*
;*		ʃRs[ [h				*
;*								*
;****************************************************************
DSPCOPYMD	EQU	$
		PHB
		PHK
		PLB
		LDX	#000H
		LDA	!UNTMVMD
		CMP	#006H
		BEQ	DSPCOPYMD_000
		JSR	MSCSRMV		; mouse coursol move
		JSL	>BGSET
;
DSPCOPYMD_000	EQU	$
		MI16			; memory , index 16bit mode
		LDX	#00000H
DSPCOPYMD_010	EQU	$
		LDA	DSPCOPYMD_DAT,X
		STA	>OAM+100H,X
		INX
		INX
		CPX	#DSPCOPYMD_DATA-DSPCOPYMD_DAT
		BCC	DSPCOPYMD_010
		MI8			; memory , index 8bit mode
;
		LDA	!DSPCPFM	; eqnl mnDZbg
		PHA
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		STA	<WORK0
		LDA	>OAM+100H+(DSPCOPYMD_FRM-DSPCOPYMD_DAT)+2
		CLC
		ADC	<WORK0
		STA	>OAM+100H+(DSPCOPYMD_FRM-DSPCOPYMD_DAT)+2
		PLA
		AND	#00FH
		STA	<WORK0
		LDA	>OAM+100H+(DSPCOPYMD_FRM-DSPCOPYMD_DAT)+6
		CLC
		ADC	<WORK0
		STA	>OAM+100H+(DSPCOPYMD_FRM-DSPCOPYMD_DAT)+6
;
		LDA	!DSPCPTO
		PHA
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		STA	<WORK0
		LDA	>OAM+100H+(DSPCOPYMD_TO-DSPCOPYMD_DAT)+2
		CLC
		ADC	<WORK0
		STA	>OAM+100H+(DSPCOPYMD_TO-DSPCOPYMD_DAT)+2
		PLA
		AND	#00FH
		STA	<WORK0
		LDA	>OAM+100H+(DSPCOPYMD_TO-DSPCOPYMD_DAT)+6
		CLC
		ADC	<WORK0
		STA	>OAM+100H+(DSPCOPYMD_TO-DSPCOPYMD_DAT)+6
;
		LDX	!UNTMVMD
		JSR	(DSPCOPYMD_ADR,X)
;
		PLB
		RTL
;
DSPCOPYMD_ADR	EQU	$
		WORD	DSPCOPYMD_100,DSPCOPYMD_200
		WORD	DSPCOPYMD_300,DSPCOPYMD_400
;
DSPCOPYMD_DAT	EQU	$
		BYTE	039H,0AAH,044H,032H	; c
		BYTE	041H,0AAH,049H,032H	; h
		BYTE	048H,0AAH,053H,032H	; r
		BYTE	050H,0AAH,050H,032H	; o
		BYTE	058H,0AAH,04CH,032H	; k
		BYTE	060H,0AAH,041H,032H	; `
		BYTE	068H,0AAH,059H,032H	; x
;
		BYTE	078H,0AAH,043H,032H	; b
		BYTE	080H,0AAH,04FH,032H	; n
		BYTE	088H,0AAH,050H,032H	; o
		BYTE	090H,0AAH,059H,032H	; x
;
		BYTE	0A0H,0AAH,04DH,032H	; l
		BYTE	0A8H,0AAH,04FH,032H	; n
		BYTE	0B0H,0AAH,044H,032H	; c
		BYTE	0B8H,0AAH,045H,032H	; d
;
		BYTE	046H,0B9H,046H,032H	; e
		BYTE	04EH,0B9H,052H,032H	; q
		BYTE	056H,0B9H,04FH,032H	; n
		BYTE	05EH,0B9H,04DH,032H	; l
		BYTE	068H,0B9H,05FH,032H	; \
DSPCOPYMD_FRM	EQU	$
		BYTE	070H,0B9H,070H,032H	; O
		BYTE	078H,0B9H,070H,032H	; O
;
		BYTE	08EH,0B9H,054H,032H	; s
		BYTE	096H,0B9H,04FH,032H	; n
		BYTE	0A0H,0B9H,05FH,032H	; \
DSPCOPYMD_TO	EQU	$
		BYTE	0A8H,0B9H,070H,032H	; O
		BYTE	0B0H,0B9H,070H,032H	; O
;
DSPCOPYMD_DATA	EQU	$
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+	ʃRs[ [h	]Zbg		+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
DSPCOPYMD_100	EQU	$
		JSR	DSPCOPYMD_SUB	; L[`FbN
		LDA	<FRCNT
		AND	#010H
		BNE	DSPCOPYMD_110
		LDA	>OAM+100H+(DSPCOPYMD_FRM-DSPCOPYMD_DAT)+3
		EOR	#002H
		STA	>OAM+100H+(DSPCOPYMD_FRM-DSPCOPYMD_DAT)+3
		STA	>OAM+100H+(DSPCOPYMD_FRM-DSPCOPYMD_DAT)+7
DSPCOPYMD_110	EQU	$
		LDA	!MOUSEBT
		AND	#11000000B	; mouse key ON ?
		BEQ	DSPCOPYMD_190	;	NO -> DSPCOPYMD_190
		AND	#01000000B	; mouse [L] key ON ?
		BEQ	DSPCOPYMD_150	;	NO -> DSPCOPYMD_150
		JSR	CPSCAL
		STA	!DSPCPFM
DSPCOPYMD_150	EQU	$
		INC	!UNTMVMD
		INC	!UNTMVMD
DSPCOPYMD_190	EQU	$
		RTS
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+	ʃRs[ [h	]Zbg		+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
DSPCOPYMD_200	EQU	$
		JSR	DSPCOPYMD_SUB	; L[`FbN
		LDA	<FRCNT
		AND	#010H
		BNE	DSPCOPYMD_210
		LDA	>OAM+100H+(DSPCOPYMD_TO-DSPCOPYMD_DAT)+3
		EOR	#002H
		STA	>OAM+100H+(DSPCOPYMD_TO-DSPCOPYMD_DAT)+3
		STA	>OAM+100H+(DSPCOPYMD_TO-DSPCOPYMD_DAT)+7
DSPCOPYMD_210	EQU	$
		LDA	!MOUSEBT
		AND	#11000000B	; mouse key ON ?
		BEQ	DSPCOPYMD_290	;	NO -> DSPCOPYMD_290
		AND	#01000000B	; mouse [L] key ON ?
		BNE	DSPCOPYMD_250	;	YES -> DSPCOPYMD_250
		DEC	!UNTMVMD
		DEC	!UNTMVMD
		BRA	DSPCOPYMD_290
DSPCOPYMD_250	EQU	$
		JSR	CPSCAL
		STA	!DSPCPTO
		INC	!UNTMVMD
		INC	!UNTMVMD
DSPCOPYMD_290	EQU	$
		RTS
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	ʃRs[ [h	L[`FbN	+
;++++++++++++++++++++++++++++++++++++++++++++++++
DSPCOPYMD_SUB	EQU	$
		LDA	!INKEY
		CMP	#UPS
		BNE	DSPCOPYMD_SUBPS
		LDA	#PLMD
		STA	!MODENO
		STZ	!UNTMVMD
DSPCOPYMD_SUBPS EQU	$
		RTS
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+	ʃRs[ [h	f[^Zbg		+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
DSPCOPYMD_300	EQU	$
		LDY	!DSPCPFM
		LDA	!UNBUFAD,Y
		BMI	DSPCOPYMD_390
		LDX	!DSPCPTO
		CMP	!UNBUFAD,X
		BEQ	DSPCOPYMD_450
;
		JSR	UNDOBFST	; data back_up !!
;
		I16			; index 16bit mode
		LDX	!STDTPT
		LDA	#000
		STA	>DTBUFF,X
		LDA	!DSPCPFM	; ]f[^Zbg
		STA	>DTBUFF+1,X
		LDA	!DSPCPTO	; ]f[^Zbg
		STA	>DTBUFF+2,X
		LDA	#0FBH
		STA	>DTBUFF+3,X	; jbgmn. Zbg
		LDA	#0FFH
		STA	>DTBUFF+4,X
		M16			; memory 16bit mode
		LDA	!STDTPT
		CLC
		ADC	#00004H
		STA	!STDTPT
		MI8			; memory , index 8bit mode
;
		JSR	DTSL030
;
		INC	!UNTMVMD
		INC	!UNTMVMD
		BRA	DSPCOPYMD_490
;
DSPCOPYMD_390	EQU	$
		STZ	!UNTMVMD
		RTS
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+	ʃRs[ [h	ʕ\		+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
DSPCOPYMD_400	EQU	$
		JSL	>BGDISP
		LDA	!MODENO
		CMP	#PLMD
		BNE	DSPCOPYMD_490
DSPCOPYMD_450	EQU	$
		LDA	#002
		STA	!UNTMVMD
DSPCOPYMD_490	EQU	$
		LDA	#DSPCP
		STA	!MODENO
		RTS
;
;
;
;
;
;************************************************************************
;*		BG. move				(BGMOVE)	*
;************************************************************************
BGMOVE		EQU	$
;
		I16
;
		LDX	#00000H
		LDY	#00008H
		LDA	INKEY2
		CMP	#RIT
		BEQ	BGM040		; --> key ?
;					; yes
		CMP	#LEF
		BNE	BGM100		; <-- key ?
;					; yes
		LDY	#0FFF8H
		INX
		INX
BGM040		EQU	$
;
		M16
;
		TYA
		CLC
		ADC	<SCCH1
		CMP	#0FFF8H
		BPL	BGM050		; move ok ?
;
		LDA	#0FFF8H
BGM050		EQU	$
		CMP	#0F08H+1
		BMI	BGM052		; move ok ?
;
		LDA	#0F08H
BGM052		EQU	$
		STA	<SCCH1
		STA	<SCCH2
		STA	<SCCH3
		STX	!SCHMK1
;
		LDA	SIFTFG
		AND	#00FFH
		TAX
		LDA	CRXPSL1,X
		SEC
		SBC	<SCCH1
		TAY
		SEC
		SBC	#008H
		BMI	BGM060		; arrow x-pos. reset ?
;					; no
		TYA
		SEC
		SBC	#00F8H
		BMI	BGM080		; arrow x-pos. reset ?
;					; yes
BGM060		EQU	$
		EOR	#0FFFFH
		SEC			;[ INC A ]
		ADC	CRXPSL1,X
		STA	CRXPSL1,X
BGM080		EQU	$
		BRA	BGM180
;
;
		MEM8
;
BGM100		EQU	$
		LDX	#00000H
		LDY	#00008H
		CMP	#DWN
		BEQ	BGM140		; down key ?
;					; yes
		CMP	#UPP
		BNE	BGM200		; up key ?
;					; yes
		LDY	#0FFF8H
		INX
		INX
BGM140		EQU	$
;
		M16
;
		TYA
		CLC
		ADC	<SCCV1
		CMP	#0FFF8H
		BPL	BGM150		; move ok ?
;
		LDA	#0FFF8H
BGM150		EQU	$
		CMP	#0758H+1
		BMI	BGM152		; move ok ?
;
		LDA	#0758H
BGM152		EQU	$
		STA	<SCCV1
		STA	<SCCV2
		STA	<SCCV3
		STX	!SCVMK1
;
		LDA	SIFTFG
		AND	#00FFH
		TAX
		LDA	CRYPSL1,X
		SEC
		SBC	<SCCV1
		TAY
		SEC
		SBC	#008H
		BMI	BGM160		; arrow x-pos. reset ?
;					; no
		TYA
		SEC
		SBC	#000A8H
		BMI	BGM180		; arrow x-pos. reset ?
;					; yes
BGM160		EQU	$
		EOR	#0FFFFH
		SEC			;[ INC A ]
		ADC	CRYPSL1,X
		STA	CRYPSL1,X
BGM180		EQU	$
;
BGM200		EQU	$
;
		MI8
;
		RTS
;
;------------------------------------------ en_edit
ENBGMV		EQU	$
		JSR	BGMOVE
		RTL
;
;
;
;
;************************************************************************
;*		Arrow cursol move			(CRMV)		*
;************************************************************************
DISPDT		EQU	$
		BYTE	018H,0AAH,C_X, 032H	;"X-XX"
		BYTE	020H,0AAH,C_HI,032H
		BYTE	028H,0AAH,000H,032H
		BYTE	030H,0AAH,000H,032H
;
		BYTE	018H,0B2H,C_Y, 032H	;"Y-XX"
		BYTE	020H,0B2H,C_HI,032H
		BYTE	028H,0B2H,000H,032H
		BYTE	030H,0B2H,000H,032H
;
		BYTE	018H,0BCH,086H,038H	;"kotei" or "kahen"
		BYTE	028H,0BCH,088H,038H
;
		BYTE	040H,0BAH,C_N,032H	;"NO"
		BYTE	048H,0BAH,C_O,032H
		BYTE	038H,0C2H,C_HI,032H	;"-XX-XX"
;
		BYTE	058H,0BAH,000H,032H	;"XW"
		BYTE	060H,0BAH,000H,032H
		BYTE	070H,0BAH,000H,032H	;"YW"
		BYTE	078H,0BAH,000H,032H
		BYTE	050H,0C2H,000H,032H
		BYTE	058H,0C2H,000H,032H
		BYTE	060H,0C2H,000H,032H
		BYTE	068H,0C2H,000H,032H
		BYTE	070H,0C2H,000H,032H
		BYTE	078H,0C2H,000H,032H
;
LOCKDT		EQU	$
		BYTE	088H,0B2H,000H,032H	; X , Y
		BYTE	090H,0B2H,000H,032H	;  LOCK ON
		BYTE	098H,0B2H,000H,032H	;	DISP SET
		BYTE	0A0H,0B2H,000H,032H	;
;
DISPDTE		EQU	$
;
;
PSCTDT0		EQU	$
		HEX	30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30
PSCTDT1		EQU	$
;			 0  1  2  3  4	5  6  7	 8  9  a  b  c	d  e  f
		HEX	30,31,32,33,34,35,36,37,38,39,41,42,43,44,45,46
;
CRATBD0		EQU	$
		HEX	088,000,086
CRATBD1		EQU	$
		HEX	08C,000,08A
;
STMDATB		EQU	$
		HEX	038,03A
;
DTMDCH0		EQU	$		;"kotei" or "kahen" chara no. data
		HEX	0A6,0AA
DTMDCH1		EQU	$
		HEX	0A8,0AC
;
;
CRMV		EQU	$
		PHB			;(DBR) save
		PHK			;(DBR) <-- (PBR)
		PLB
;
		LDX	SIFTFG
;
;-------------- kotei or kahen change -------------------
CRM0000		EQU	$
		LDA	INKEY
		CMP	#ESC
		BNE	CRM0040		; 'ESC' key ?
;					; yes
		LDA	DTMODE
		EOR	#01H
		STA	DTMODE
		STZ	SIFTFG
;
;-------------- cursol select ---------------------------
CRM0040		EQU	$
		LDA	DTMODE
		BEQ	CRM0100		; kahen ?
;					; yes
		LDA	MOUSEBT
		AND	#10000000B
		BEQ	CRM0100		; mouse [R] key ?
;					; yes
		TXY			;(Y) <-- old cursol index save
		TXA
		EOR	#00000010B
		STA	SIFTFG
		TAX
;
		M16
;
		LDA	CRXPSL1,X
		SEC
		SBC	<SCCH1
		SEC
		SBC	#08H
		CMP	#0F8H-08H
		BCS	CRM050		;cursol pos reset ? ( yes:CRM050 )
		LDA	CRYPSL1,X
		SEC
		SBC	<SCCV1
		SEC
		SBC	#08H
		CMP	#0D8H-08H
		BCC	CRM060		;cursol pos reset ? ( no:CRM060 )
;
CRM050		EQU	$
		LDA	CRXPSL1,Y	;new cursol pos reset !!
		STA	CRXPSL1,X
		LDA	CRYPSL1,Y
		STA	CRYPSL1,X
CRM060		EQU	$
;
		M8
;
;-------------- mouse pos check -------------------------
CRM0100		EQU	$
		JSR	MSCSRMV
;
		LDX	#DISPDTE-DISPDT-1
CRD0100		EQU	$
		LDA	DISPDT,X
		STA	>XYPOAM,X
		DEX
		BPL	CRD0100
;
		LDA	DTMODE
		BEQ	CRD0150
		LDA	CRSSMMD
		BEQ	CRD0150
		LDX	#LOCKDT-DISPDT
		CLC
		ADC	#L_W
		STA	>XYPOAM+2,X
		LDA	#L_S
		STA	>XYPOAM+2+4,X
		LDA	#L_E
		STA	>XYPOAM+2+8,X
		LDA	#L_T
		STA	>XYPOAM+2+12,X
;
CRD0150		EQU	$
		LDX	SIFTFG
		LDA	CRXPSL1,X
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		TAY
		LDA	PSCTDT1,Y
		STA	>XYPOAM+4*3+2	; x-pos. count set
;
		LDA	CRYPSL1,X
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		AND	#00001111B
		TAY
		LDA	PSCTDT1,Y
		STA	>XYPOAM+4*7+2	; y-pos. count set
;
		LDA	CRXPSH1,X
		AND	#00001111B
		TAY
		LDA	PSCTDT1,Y
		STA	>XYPOAM+4*2+2	; hi-x-pos. count set
;
		LDA	CRYPSH1,X
		AND	#00001111B
		TAY
		LDA	PSCTDT1,Y
		STA	>XYPOAM+4*6+2	; hi-x-pos. count set
;
		LDX	DTMODE
		BEQ	CRD0122		;kotei ? ( yes:CRD0122 )
;
;-------------- pos wide set ----------------------------
		LDA	#C_X
		STA	>SMDOAM+4*5+2
		LDA	#C_W
		STA	>SMDOAM+4*6+2
		LDA	#C_Y
		STA	>SMDOAM+4*7+2
		LDA	#C_W
		STA	>SMDOAM+4*8+2
		LDA	#C_HI
		STA	>SMDOAM+4*9+2
		STA	>SMDOAM+4*12+2
;
		M16
;
		LDA	CRXPSL1	       ; x-pos wide set
		AND	#0FFF0H
		STA	<WORK
		LDA	CRXPSL2
		AND	#0FFF0H
		SEC
		SBC	<WORK
;
		M8
;
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		AND	#00001111B
		TAY
		LDA	PSCTDT1,Y
		STA	>SMDOAM+4*11+2
		XBA
		AND	#00001111B
		TAY
		LDA	PSCTDT1,Y
		STA	>SMDOAM+4*10+2
;
		M16
;
		LDA	CRYPSL1
		AND	#0FFF0H
		STA	<WORK
		LDA	CRYPSL2
		AND	#0FFF0H
		SEC
		SBC	<WORK
;
		M8
;
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		AND	#00001111B
		TAY
		LDA	PSCTDT1,Y
		STA	>SMDOAM+4*14+2
		XBA
		AND	#00001111B
		TAY
		LDA	PSCTDT1,Y
		STA	>SMDOAM+4*13+2
;
CRD0122		EQU	$
		LDA	STMDATB,X
		STA	>XYPOAM+4*0+3
		STA	>XYPOAM+4*1+3
		STA	>XYPOAM+4*2+3
		STA	>XYPOAM+4*3+3
		STA	>XYPOAM+4*4+3
		STA	>XYPOAM+4*5+3
		STA	>XYPOAM+4*6+3
		STA	>XYPOAM+4*7+3
		STA	>SMDOAM+4*0+3
		STA	>SMDOAM+4*1+3	; set mode attribute set
		STA	>SMDOAM+4*2+3
		STA	>SMDOAM+4*3+3
		STA	>SMDOAM+4*4+3
		STA	>SMDOAM+4*5+3
		STA	>SMDOAM+4*6+3
		STA	>SMDOAM+4*7+3
		STA	>SMDOAM+4*8+3
		STA	>SMDOAM+4*9+3
		STA	>SMDOAM+4*10+3
		STA	>SMDOAM+4*11+3
		STA	>SMDOAM+4*12+3
		STA	>SMDOAM+4*13+3
		STA	>SMDOAM+4*14+3
;
		LDA	!DTMDCH0,X	; "kote" or "kahen" chara no. set
		STA	>SMDOAM+4*0+2
		LDA	!DTMDCH1,X
		STA	>SMDOAM+4*1+2
;
		LDA	#00001010B
		STA	>OAMSUB+((SMDOAM-OAM)>>4)
;
		PLB			; (DBR) reset
		RTS
;
;----------------------------------------------------------------
;-		mouse cursol move				-
;----------------------------------------------------------------
;
		MEM8
		IDX8
;
MSCSRMV		EQU	$
		LDA	MOUSEBX
		BEQ	CRM0200		; x-move ?
;					; yes
		BMI	CRM0140		; --> key ?
;					; yes
;-------------- mouse right move ----------------
;
		M16
;
		AND	#0007FH
		STA	<WORK0
;
		CLC
		ADC	CRXPSL1,X
		CMP	#1000H
		BCC	CRM0110
		LDA	#0FFFH
CRM0110		EQU	$
		STA	CRXPSL1,X
		SEC
		SBC	<SCCH1
		SEC
		SBC	#000F8H-1
		BMI	CRM0180		; cursol limit scroll ?
;					; yes
;;;;		CMP	#08H+1
		CMP	#10H+1
		BCC	CRM0112		;8 dot scroll over ? ( no:CRM0112 )
;
		LDA	<SCCH1
		CLC
;;;;		ADC	#00F8H+08H
		ADC	#00F8H+10H
		STA	CRXPSL1,X
;;;;		LDA	#08H
		LDA	#10H
CRM0112		EQU	$
		CLC
		ADC	<SCCH1
		LDY	#00H
		BRA	CRM0160
;
;-------------- mouse left move -----------------
CRM0140		EQU	$
;
		M16
;
		ORA	#0FF00H
		STA	<WORK0
;
		CLC
		ADC	CRXPSL1,X
		BPL	CRM0150
		LDA	#00
CRM0150		EQU	$
		STA	CRXPSL1,X
		SEC
		SBC	<SCCH1
		SEC
		SBC	#00008H
		BPL	CRM0180		; cursol limit scroll ?
;					; yes
;;;;		CMP	#0FFF8H
		CMP	#0FFF0H
		BCS	CRM0151		;8 dot scroll over ? ( no:CRM0151 )
;
		LDA	<SCCH1
		CLC
;;;;		ADC	#00008H-08H
		ADC	#00008H-10H
		STA	CRXPSL1,X
;;;;		LDA	#0FFF8H
		LDA	#0FFF0H
CRM0151		EQU	$
		CLC
		ADC	<SCCH1
		LDY	#02H
;
CRM0160		EQU	$
		STA	<SCCH1
		STA	<SCCH2
		STA	<SCCH3
		STY	SCHMK1
;
CRM0180		EQU	$
;
		M8
;
CRM0200		EQU	$
		LDA	MOUSEBY
		BEQ	CRM0400		; y-move ?
;					; yes
		BMI	CRM0240		; down key ?
;
;-------------- mouse down move -----------------
;					; yes
		M16
;
		AND	#0007FH
		CLC
		ADC	CRYPSL1,X
		CMP	#0800H
		BCC	CRM0210
		LDA	#07FFH
CRM0210		EQU	$
		STA	CRYPSL1,X
		SEC
		SBC	<SCCV1
		SEC
		SBC	#000A8H-1
		BMI	CRM0260		; cursol limit scroll ?
;					; yes
;;;;		CMP	#08H+1
		CMP	#10H+1
		BCC	CRM0212		;8 dot scroll over ? ( no:CRM0212 )
;
		LDA	<SCCV1
		CLC
;;;;		ADC	#000A8H+08H
		ADC	#000A8H+10H
		STA	CRYPSL1,X
;;;;		LDA	#08H
		LDA	#10H
CRM0212		EQU	$
		CLC
		ADC	<SCCV1
		LDY	#00H
		BRA	CRM0252
;
;-------------- mouse up move -------------------
CRM0240		EQU	$
;
		M16
;
		ORA	#0FF00H
		CLC
		ADC	CRYPSL1,X
		BPL	CRM0250
		LDA	#00
CRM0250		EQU	$
		STA	CRYPSL1,X
		SEC
		SBC	<SCCV1
		SEC
		SBC	#00008H
		BPL	CRM0260		; cursol limit scroll ?
;					; yes
;;;;		CMP	#0FFF8H
		CMP	#0FFF0H
		BCS	CRM02502	;8 dot scroll over ? ( no:CRM02502 )
;
		LDA	<SCCV1
		CLC
;;;;		ADC	#00008H-08H
		ADC	#00008H-10H
		STA	CRYPSL1,X
;;;;		LDA	#0FFF8H
		LDA	#0FFF0H
CRM02502	EQU	$
		CLC
		ADC	<SCCV1
		LDY	#02H
;
CRM0252		EQU	$
		STA	<SCCV1
		STA	<SCCV2
		STA	<SCCV3
		STY	SCVMK1
;
CRM0260		EQU	$
;
		M8
;
CRM0400		EQU	$		; arrow OAM set
;
		M16
;
		LDX	SIFTFG
		LDA	CRXPSL1,X
		SEC
		SBC	<SCCH1
		STA	<WORK0
		LDA	CRYPSL1,X
		SEC
		SBC	<SCCV1
		STA	<WORK2
;
		TXA
		EOR	#00000010B
		TAX
		LDA	CRXPSL1,X
		SEC
		SBC	<SCCH1
		STA	<WORK4
		CLC
		ADC	#010H
		CMP	#0110H
		BCC	CRM0410
		LDA	#0180H
		STA	<WORK4
CRM0410		EQU	$
		LDA	CRYPSL1,X
		SEC
		SBC	<SCCV1
		STA	<WORK6
		CLC
		ADC	#010H
		CMP	#0100H
		BCC	CRM0420
		LDA	#0180H
		STA	<WORK4
CRM0420		EQU	$
		LDA	CRSSMMD
		AND	#000FFH
		BNE	CRM0425
		LDA	CRXPSL2
		STA	XTAIHI
		LDA	CRYPSL2
		STA	YTAIHI
CRM0425		EQU	$
;
		M8
;
		LDX	SIFTFG
		LDA	<WORK0
		STA	>ARROAM		; x-pos. set
		LDA	<WORK2
		STA	>ARROAM+1	; y-pos. set
		LDA	CRATBD0,X
		STA	>ARROAM+2	; char. no. set
		LDA	#034H
		STA	>ARROAM+3	; attribute set
		STA	>AR1OAM+3	; attribute set
;
		LDA	#00101010B	; ( + last input data cursol )
		STA	>OAMSUB
;
		LDA	DTMODE
		BEQ	CRM0440		; kotei ?
;					; no
		TXA
		EOR	#02H
		TAX
		LDA	CRATBD1,X
		STA	>AR1OAM+2	; char. no. set
		LDA	<WORK4
		STA	>AR1OAM		; x-pos. set
		LDA	<WORK6
		STA	>AR1OAM+1	; y-pos. set
		LDA	<WORK5
		AND	#01H
		ASL	A
		ASL	A
		ORA	>OAMSUB
		STA	>OAMSUB		; display "ON/OFF" set
CRM0440		EQU	$
		RTS
;
;
;
;
;************************************************************************
;*		Set DATA pointer & unit no.		(DPDISP)	*
;************************************************************************
DPTDT		EQU	$
		BYTE	048H,0A8H,C_P, 032H	;"PT-"
		BYTE	050H,0A8H,C_T, 032H
		BYTE	058H,0A8H,C_HI,032H
DPTDT0		EQU	$
		BYTE	060H,0A8H,000H,032H	;PT-"XXXX"
		BYTE	068H,0A8H,000H,032H
		BYTE	070H,0A8H,000H,032H
		BYTE	078H,0A8H,000H,032H
;
		BYTE	058H,0B0H,000H,032H	;PT-XXXX
		BYTE	060H,0B0H,000H,032H	;  "XX-XX-XX-XX-XX-XX"
		BYTE	068H,0B0H,000H,032H
		BYTE	070H,0B0H,000H,032H
		BYTE	078H,0B0H,000H,032H
		BYTE	080H,0B0H,000H,032H
		BYTE	088H,0B0H,000H,032H
		BYTE	090H,0B0H,000H,032H
		BYTE	098H,0B0H,000H,032H
		BYTE	0A0H,0B0H,000H,032H
		BYTE	0A8H,0B0H,000H,032H
		BYTE	0B0H,0B0H,000H,032H
		BYTE	0B8H,0B0H,000H,032H
		BYTE	0C0H,0B0H,000H,032H
		BYTE	0C8H,0B0H,000H,032H
		BYTE	0D0H,0B0H,000H,032H
		BYTE	0D8H,0B0H,000H,032H
		BYTE	0E0H,0B0H,000H,032H
DPTDTE		EQU	$
;
DPDSCNT		EQU	DPTDTE-DPTDT-1
;
FLMDAT		EQU	$			;t@C
		BYTE	088H,0C0H,L_h ,032H	; -
		BYTE	090H,0C0H,L_h ,032H	; -
		BYTE	098H,0C0H,L_h ,032H	; -
		BYTE	0A0H,0C0H,L_h ,032H	; -
		BYTE	0A8H,0C0H,L_h ,032H	; -
		BYTE	0B0H,0C0H,L_h ,032H	; -
		BYTE	0B8H,0C0H,L_h ,032H	; -
		BYTE	0C0H,0C0H,L_h ,032H	; -
		BYTE	0C8H,0C0H,L_p ,032H	; .
		BYTE	0D0H,0C0H,L_D ,032H	; D
		BYTE	0D8H,0C0H,L_A ,032H	; A
		BYTE	0E0H,0C0H,L_T ,032H	; T
;
;
DPDISP		EQU	$
;
;-------------- last input data display check -------------------
		LDA	LASTFG
		BEQ	DPD0020		;last input data nothing ? ( yes:DPD0020 )
;
		LDA	!BG3CLSFG
		BNE	DPD0020
;
		LDA	<FRCNT
		AND	#018H
		BEQ	DPD0020		;display timming ? ( no:DPD0020 )
;
		M16			; memory 16bit mode
;
		LDA	LASTXP
		SEC
		SBC	<SCCH1
		PHA
		CLC
		ADC	#010H
		CMP	#0110H
		PLA
		BCS	DPD0010		;X pos display ? ( no:DPD0010 )
;
		STA	<WORK0		;(WK0,1) <-- display X pos
		LDA	LASTYP
		CLC
		SBC	<SCCV1
		PHA
		CLC
		ADC	#010H
		CMP	#0100H
		PLA
;
		M8			; memory 8bit mode
;
		BCS	DPD0020		;Y pos display ? ( no:DPD0020 )
;
		STA	>LASOAM+1	 ;OAM Y pos set
		LDA	<WORK0
		STA	>LASOAM		 ; "  X    "
		LDA	#0AEH
		STA	>LASOAM+2	 ; "  chara no. set
		LDA	#030H
		STA	>LASOAM+3	 ; "  att set
		LDA	<WORK1
		AND	#01H
		ASL	A
		ASL	A
		ASL	A
		ASL	A
		ORA	>OAMSUB
		STA	>OAMSUB		 ;OAM sub set
		BRA	DPD0020
;
;----------------------------------------------------------------
;
DPD0010		EQU	$
		M8			; memory 8bit mode
;
DPD0020		EQU	$
		LDX	#DPTDTE-DPTDT-1
DPD0100		EQU	$
		LDA	>DPTDT,X
		STA	>PTDOAM,X
		DEX
		BPL	DPD0100
;
		LDX	#DPDISP-FLMDAT-1
DPD0150		EQU	$		; t@C
		LDA	>FLMDAT,X	;	n`lCjVZbg
		STA	>FLOAM,X
		DEX
		BPL	DPD0150
;
		LDA	!NMDTBF0
		BEQ	DPD0200
		LDA	#007H
		TAY
		ASL	A
		ASL	A
		TAX
DPD0160		EQU	$		; t@C Zbg
		LDA	!NMDTBF0,Y
		CMP	#SPS
		BEQ	DPD0165
		CMP	#08EH
		BEQ	DPD0165
		STA	>FLOAM+2,X
		DEX
		DEX
		DEX
		DEX
		BMI	DPD0200
DPD0165		EQU	$
		DEY
		BPL	DPD0160
;
		LDA	#SPS
DPD0180		EQU	$		; t@C kLZbg
		STA	>FLOAM+2,X
		DEX
		DEX
		DEX
		DEX
		BPL	DPD0180
;
DPD0200		EQU	$
		JSR	SDPTCAL		; set data pointer calc
;
		M16
;
		LDA	DTPT
DPD0300		EQU	$
;
		M8
;
		PHA			; (A) push
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		TAX
		LDA	>PSCTDT1,X
		STA	>PTDOAM+(DPTDT0-DPTDT+2)+4*2
		PLA			; (A) pull
		AND	#00001111B
		TAX
		LDA	>PSCTDT1,X
		STA	>PTDOAM+(DPTDT0-DPTDT+2)+4*3 ; point no. set
;
		XBA
		PHA			; (A) push
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		TAX
		LDA	>PSCTDT1,X
		STA	>PTDOAM+(DPTDT0-DPTDT+2)
		PLA			; (A) pull
		AND	#00001111B
		TAX
		LDA	>PSCTDT1,X
		STA	>PTDOAM+(DPTDT0-DPTDT+2)+4 ; point no. set
		RTS
;
;
;
;
;------------------------------------------------------------------------
;-		set data pointer calc			(SDPTCAL)	-
;-		[out]	(X)	--->	set pointer			-
;------------------------------------------------------------------------
SDPTCAL		EQU	$
;
		MI16
;
		STZ	DTPT
		LDX	#00000H
SDPTC20		EQU	$
		LDY	#04		;(Y) <-- number of data byte ( kotei )
		LDA	>DTBUFF,X
		AND	#00FFH
		BEQ	SDPTC30		;kotei data ? ( yes:SDPTC30 )
;
		CMP	#00FFH
		BEQ	SDPTC40		;end code ? ( yes:SDPTC40 )
;
		PHX			;(X) save
		TAX
		LDA	>KAHNSB,X
		PLX			;(X) load
		AND	#003FH
		TAY
		LDA	!KAHNNO,Y
		AND	#00FFH
		TAY
SDPTC30		EQU	$
		STY	<WORK
		TXA
		CLC
		ADC	<WORK
		TAX
		INC	DTPT
		BRA	SDPTC20
;
SDPTC40		EQU	$
		STX	STDTPT	       ; (STDTPT) <-- next set pointer
		MI8			; memory , index 8bit mode
		RTS
;
;
;
;----------------------------------------------------------------
;-		en_file ̃R[p				-
;----------------------------------------------------------------
EN_SDPTCAL	EQU	$
		JSR	SDPTCAL
		RTL
;
;
;
;
;
;
;
;************************************************************************
;*		Mode Select				(MODESL)	*
;************************************************************************
MDNDT		EQU	$
		BYTE	0C8H,010H,080H,038H	; NORMAL
		BYTE	0D0H,010H,081H,038H
		BYTE	0D8H,010H,082H,038H
		BYTE	0E0H,010H,083H,038H
		BYTE	0E8H,010H,084H,038H
		BYTE	0F0H,010H,085H,038H
;
		BYTE	0C8H,018H,090H,038H	; INSERT
		BYTE	0D0H,018H,091H,038H
		BYTE	0D8H,018H,092H,038H
		BYTE	0E0H,018H,093H,038H
		BYTE	0E8H,018H,094H,038H
		BYTE	0F0H,018H,095H,038H
;
		BYTE	0C8H,020H,0A0H,038H	; S-DEL
		BYTE	0D0H,020H,0A1H,038H
		BYTE	0D8H,020H,0A2H,038H
		BYTE	0E0H,020H,0A3H,038H
		BYTE	0E8H,020H,0A4H,038H
		BYTE	0F0H,020H,0A5H,038H
;
		BYTE	0C8H,028H,0B0H,038H	; DELETE
		BYTE	0D0H,028H,0B1H,038H
		BYTE	0D8H,028H,0B2H,038H
		BYTE	0E0H,028H,0B3H,038H
		BYTE	0E8H,028H,0B4H,038H
		BYTE	0F0H,028H,0B5H,038H
;
		BYTE	0C8H,030H,0C0H,038H	; SEARCH
		BYTE	0D0H,030H,0C1H,038H
		BYTE	0D8H,030H,0C2H,038H
		BYTE	0E0H,030H,0C3H,038H
		BYTE	0E8H,030H,0C4H,038H
		BYTE	0F0H,030H,0C5H,038H
;
		BYTE	0C8H,038H,0A5H,038H	; B-CHNG
		BYTE	0D0H,038H,0A5H,038H
		BYTE	0D8H,038H,0A5H,038H
		BYTE	0E0H,038H,0A5H,038H
		BYTE	0E8H,038H,0A5H,038H
		BYTE	0F0H,038H,0A5H,038H
;
;;;;		BYTE	0C8H,038H,0D0H,038H	; B-CHNG
;;;;		BYTE	0D0H,038H,0D1H,038H
;;;;		BYTE	0D8H,038H,0D2H,038H
;;;;		BYTE	0E0H,038H,0D3H,038H
;;;;		BYTE	0E8H,038H,0D4H,038H
;;;;		BYTE	0F0H,038H,0D5H,038H
MDNDTE		EQU	$
;
MDNDTCT		EQU	MDNDTE-MDNDT-2
;
MDDTPT		EQU	$
		BYTE	006H*0,006H*1,006H*2,006H*3,006H*4,006H*5
;
MDATPT		EQU	$
		BYTE	(004H*6)*0+3
		BYTE	(004H*6)*1+3
		BYTE	(004H*6)*2+3
		BYTE	(004H*6)*3+3
		BYTE	(004H*6)*4+3
		BYTE	(004H*6)*5+3
;
;
;
MODESL		EQU	$
;
		MI16
;
		LDA	#00
		STA	>OAMSUB
		STA	>OAMSUB+((CHCOAM-OAM)>>4)
		STA	>OAMSUB+((SMDOAM-OAM)>>4)
;
		LDX	#MDNDTE-MDNDT-2
MDN0100		EQU	$
		LDA	>MDNDT,X
		STA	>OAM,X
		DEX
		DEX
		BPL	MDN0100		; set end ?
;					; yes
		MI8
;
		LDA	INKEY
		CMP	#MOD
		BEQ	MDN0110		;return ? ( yes:MDN0110 )
		CMP	#RTN
		BEQ	MDN0110		;	    "
		LDA	MOUSEBT
		AND	#11000000B
		BEQ	MDN0400		;    "    ( no:MDN0400 )
;
MDN0110		EQU	$
		LDA	EDMODE
		CMP	#search
		BNE	MDN0140		; SEARCH ?
;					; yes
		LDA	#0FFH
		STA	SRCHPT
		STA	SRCHPT+1
MDN0140		EQU	$
		LDA	#PLMD
		STA	MODENO
		JSL	>OAMCLR2
		RTL
;
MDN0400		EQU	$
		LDA	INKEY2
		CMP	#DWN
		BNE	MDS0600		; down key ?
;					; yes
		LDA	EDMODE
		INC	A
;;;;		CMP	#006H
		CMP	#005H
		BNE	MDS0640		; limit ?
;					; yes
		LDA	#000H
		BRA	MDS0640
;
MDS0600		EQU	$
		LDA	INKEY2
		CMP	#UPP
		BNE	MDS0800		; up key ?
;					; yes
		LDA	EDMODE
		DEC	A
		BPL	MDS0640		; limit ?
;					; yes
;;;;		LDA	#005H
		LDA	#004H
MDS0640		EQU	$
		STA	EDMODE
;
		ASL	A
		INC	A		;[ +08H ]
		ASL	A
		ASL	A
		ASL	A
		STA	MOUSWK0	       ;mouse menu pos set
;
MDS0800		EQU	$
		LDA	MOUSEBY
		BEQ	MDS0830		;mouse move ? ( no:MDS0830 )
;
		CLC
		ADC	MOUSWK0
		BPL	MDS0810
		LDA	#00
MDS0810		EQU	$
		CMP	#05H*10H
		BCC	MDS0820
		LDA	#05H*10H-1
MDS0820		EQU	$
		STA	MOUSWK0
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		STA	EDMODE
;
MDS0830		EQU	$
		LDX	EDMODE
		LDA	>MDATPT,X
		TAX
		LDY	#05H
		LDA	#034H
MDS0900		EQU	$
		STA	>OAM,X
		INX
		INX
		INX
		INX
		DEY
		BPL	MDS0900
;
		RTL
;
;
;
;
;
;************************************************************************
;*		Error display				(ERROR)		*
;************************************************************************
ERDSDT		EQU	$
		BYTE	0CCH,040H,C_E,030H
		BYTE	0D4H,040H,C_R,030H
		BYTE	0DCH,040H,C_R,030H
		BYTE	0E4H,040H,C_O,030H
		BYTE	0ECH,040H,C_R,030H
ERDSDTE		EQU	$
;
ESCNT		EQU	ERDSDTE-ERDSDT-1
EROMPOS		EQU	0B0H
;
;
ERROR		EQU	$
		PHB			;(DBR) save
		LDA	#BANK OAM	;(DBR) <-- OAM(B)
		PHA
		PLB
;
		LDY	#EROMPOS+ESCNT
		LDX	#ESCNT
ERD0100		EQU	$
		LDA	>ERDSDT,X
		STA	OAM,Y
		DEY
		DEX
		BPL	ERD0100
;
		LDA	<FRCNT
		AND	#08H
		BNE	ERD0300
;
		LDY	#EROMPOS+003H
		LDX	#04H
		LDA	#039H
ERD0200		EQU	$
		STA	OAM,Y
		INY
		INY
		INY
		INY
		DEX
		BPL	ERD0200
;
ERD0300		EQU	$
		PLB
;
		DEC	ERRFLG
		BPL	ERD0500
;
		LDA	#PLMD
		STA	MODENO
		STZ	ERRFLG
ERD0500		EQU	$
		RTL
;
;
;
;
;************************************************************************
;*		Window set				(WNDWST)	*
;************************************************************************
TLW1DT		EQU	$
		BYTE	00H+00CH
		BYTE	0FFH,000H
		BYTE	00H+038H
		BYTE	0C4H,0FBH
		BYTE	00H+062H
		BYTE	0FFH,000H
		BYTE	00H+028H
		BYTE	017H,0E9H
		BYTE	00H+01H
		BYTE	0FFH,000H
		BYTE	00H
;
TLHDPR		EQU	$
		BYTE	00000001B
		BYTE	26H
		LWORD	TLW1DT
;
ENWINDW_DT	EQU	$
		BYTE	000H+00EH
		BYTE	0FFH,000H
		BYTE	000H+070H
		BYTE	018H,0E0H
		BYTE	000H+051H
		BYTE	018H,0E0H
		BYTE	000H+001H
		BYTE	0FFH,000H
		BYTE	000H
;
ENTLHDPR	EQU	$
		BYTE	00000001B
		BYTE	26H
		LWORD	ENWINDW_DT
;
;
WNDWST		EQU	$
		LDX	#004H
WDWST020	EQU	$
		LDA	>TLHDPR,X
		STA	4370H,X
		LDA	>ENTLHDPR,X
		STA	4360H,X
		DEX
		BPL	WDWST020
;
		LDA	#00000000B
		STA	WIND23	       ; window mask BG1.BG2 set
		LDA	#00000010B
		STA	WIND24	       ;	     BG4.Bg3
		LDA	#00100000B
		STA	WIND25	       ;	     COL,OBJ
		LDA	#00000100B
		STA	WMANSL
		LDA	#00000000B
		STA	WSUBSL
		LDA	#00010000B
		STA	WIND30
		LDA	#01100011B
		STA	SUBADF
		STZ	212AH
		STZ	212BH
;
		LDA	!ENBGFLG
		LSR	A
		EOR	#00000001B
		AND	#00000001B
		ORA	#00010110B
		STA	MANSEL
		LDA	#00000000B
		STA	SUBSEL	       ; gamen disp. swich set
;
		LDA	#10000000B
		STA	HD420C	       ; H-DMA ch"ON"
		RTL
;
;
;********************************************************
;*		unit buffer set initial set		*
;********************************************************
UNITST0		EQU	$
		JSL	>UNITST		; unit buffer set
;
REDISP		EQU	$
;
		M16
;
		LDA	<SCCH1		;start scrool counter set
		SEC
		SBC	#0010H+0110H+0010H
		STA	WRSCH1
		LDA	<SCCV1
		STA	WRSCV1
;
		M8
;
		LDA	#16+4		;loop counter set
		STA	BGDPFG
		LDA	#BGDS		;BG display mode set
		STA	MODENO
		RTL
;
;
;********************************************************
;*							*
;*	mouse auto scroll initial set			*
;*							*
;********************************************************
MSSCINT		EQU	$
		LDA	#MSSC
		STA	MODENO
		STZ	!WIDEX
		STZ	!WIDEY
		LDX	SIFTFG
		LDA	#080H
		STA	CRXPSL1,X
		LDA	#060H
		STA	CRYPSL1,X
		M16			; memory 16bit mode
		LDA	CRXPSL1,X
		STA	MSSCRX
		LDA	CRYPSL1,X
		STA	MSSCRY
		M8			; memory 8bit mode
;
		PLA
		PLA
		RTL
;
;
;********************************************************
;*							*
;*	mouse auto scroll mode				*
;*							*
;********************************************************
MSSCRMD		EQU	$
		LDX	SIFTFG
		LDA	MOUSEBT
		AND	#10000000B	; mouse right ON ?
		BEQ	MSSCR00
		STZ	!MUSEBUF
		LDA	#PLMD
		STA	MODENO
		M16			; memory 16bit mode
		LDA	<SCCH1
		CLC
		ADC	#00088H
		STA	CRXPSL1,X
		STA	MSSCRX
		LDA	<SCCV1
		CLC
		ADC	#00068H
		STA	CRYPSL1,X
		STA	MSSCRY
		M8			; memory 8bit mode
		JMP	MSSCR99
;
MSSCR00		EQU	$
		LDA	CRXPSL1,X
		CLC
		ADC	MOUSEBX
		CMP	#040H		; X limit check
		BCC	MSSCR05
		CMP	#0C0H
		BCC	MSSCR10
		LDA	#0C0H
		BRA	MSSCR10
MSSCR05		EQU	$
		LDA	#040H
MSSCR10		EQU	$
		STA	CRXPSL1,X
		STA	>OAM
		LDA	MSSCRX
		STA	>OAM+4
;
		LDA	CRYPSL1,X
		CLC
		ADC	MOUSEBY
		CMP	#020H		; Y limit check
		BCC	MSSCR15
		CMP	#0A0H
		BCC	MSSCR20
		LDA	#0A0H
		BRA	MSSCR20
MSSCR15		EQU	$
		LDA	#020H
MSSCR20		EQU	$
		STA	CRYPSL1,X
		STA	>OAM+1
		LDA	MSSCRY
		STA	>OAM+5
		LDA	#034H
		STA	>OAM+3
		STA	>OAM+7
		LDA	>CSLDAT,X
		STA	>OAM+2		; move cursol char. set
		LDA	#08CH
		STA	>OAM+6		; senter cursol char. set
;
		LDA	#02AH
		STA	>OAMSUB
;
		LDA	CRXPSL1,X      ; X wide
		CMP	#078H		;     scroll stop limit check
		BCC	MSSCR29
		CMP	#088H
		BCS	MSSCR29
		JMP	MSSCR50
;
MSSCR29		EQU	$
		STZ	<WORK2
		STZ	<WORK3
		STZ	<WORK4
		STZ	<SCHMK1
		LDA	CRXPSL1,X      ; X point
		SEC
		SBC	MSSCRX
		BPL	MSSCR30
		EOR	#0FFH
		INC	A
		INC	<WORK3
		LDY	#002H
		STY	<SCHMK1
MSSCR30		EQU	$
		JSR	MSSCRSP		; mouse scroll speed
		CLC
		ADC	WIDEX
		STA	WIDEX
		BCC	MSSCR33
		INC	<WORK1
MSSCR33		EQU	$
		M16			; memory 16bit mode
		LDA	<WORK3
		BEQ	MSSCR35
		LDA	<WORK0
		EOR	#0FFFFH
		INC	A
		STA	<WORK0
		LDA	#0FFFFH
		STA	<WORK2
MSSCR35		EQU	$
		LDA	<SCCH1		; H scroll point set
		CLC
		ADC	<WORK1
		STA	<SCCH1
		STA	<SCCH2
		STA	<SCCH3
		LDA	<WORK1
		BEQ	MSSCR39
		LDA	<SCCH1
		CLC
		ADC	#00008H
		BPL	MSSCR38
		LDA	#0FFF8H
		BRA	MSSCR385
MSSCR38		EQU	$
		CMP	#00F11H
		BCC	MSSCR39
		LDA	#00F08H
MSSCR385	EQU	$
		STA	<SCCH1
		STA	<SCCH2
		STA	<SCCH3
MSSCR39		EQU	$
		M8			; memory 8bit mode
;
MSSCR50		EQU	$		; Y wide
		LDA	CRYPSL1,X      ;     scroll stop limit check
		CMP	#058H
		BCC	MSSCR59
		CMP	#068H
		BCS	MSSCR59
		JMP	MSSCR90
;
MSSCR59		EQU	$
		STZ	<WORK2
		STZ	<WORK3
		STZ	<WORK4
		STZ	<SCVMK1
		LDA	CRYPSL1,X      ; Y point
		SEC
		SBC	MSSCRY
		BPL	MSSCR40
		EOR	#0FFH
		INC	A
		INC	<WORK3
		LDY	#002H
		STY	<SCVMK1
MSSCR40		EQU	$
		JSR	MSSCRSP		; mouse scroll speed
		CLC
		ADC	WIDEY
		STA	WIDEY
		BCC	MSSCR43
		INC	<WORK1
MSSCR43		EQU	$
		M16			; memory 16bit mode
		LDA	<WORK3
		BEQ	MSSCR45
		LDA	<WORK0
		EOR	#0FFFFH
		INC	A
		STA	<WORK0
		LDA	#0FFFFH
		STA	<WORK2
MSSCR45		EQU	$
		LDA	<SCCV1		; V scroll point set
		CLC
		ADC	<WORK1
		STA	<SCCV1
		STA	<SCCV2
		STA	<SCCV3
		LDA	<WORK1
		BEQ	MSSCR49
		LDA	<SCCV1
		CLC
		ADC	#00008H
		BPL	MSSCR48
		LDA	#0FFF8H
		BRA	MSSCR485
MSSCR48		EQU	$
		CMP	#00761H
		BCC	MSSCR49
		LDA	#00758H
MSSCR485	EQU	$
		STA	<SCCV1
		STA	<SCCV2
		STA	<SCCV3
MSSCR49		EQU	$
		M8			; memory 8bit mode
;
MSSCR90		EQU	$
		JSL	>BGSET
;
MSSCR99		EQU	$
		RTL
;
;
;-------------------------------------- mouse scroll speed
MSSCRSP		EQU	$
		M16			; memory 16bit mode
		AND	#000FFH
		ASL	A
		ASL	A
		ASL	A
		ASL	A
		STA	<WORK0
		M8			; memory 8bit mode
		LDA	<WORK0
		RTS
;
;
CSLDAT		EQU	$
		BYTE	088H,000H,086H
;
;********************************************************
;*							*
;*		player pos set move			*
;*							*
;********************************************************
PLPSST		EQU	$
		PHB			;(DBR) save
		PHK			;(DBR) <-- (PBR)
		PLB
;
		LDX	SIFTFG
		JSR	MSCSRMV		;mouse coursol move
;
		JSR	TIMCNTST	; ^C}[JEg Zbg
;
		PLB
;
		LDA	MOUSEBT
		AND	#10000000B
		BEQ	PPST010		;return to normal ? ( no:PPST010 )
;
;-------------- return to normal mode !! ----------------
		LDA	#PLMD
		STA	MODENO
		BRA	PPST020
;
;-------------- player pos set cursol move --------------
PPST010		EQU	$
		LDA	MOUSEBT
		AND	#01000000B
		BEQ	PPST020		;player pos set ? ( no:PPST020 )
;
		M16
;
		LDX	SIFTFG
		LDA	CRXPSL1,X
		AND	#0FFF0H
		STA	T_PLXPSL
		LDA	CRYPSL1,X
		AND	#0FFF0H
		STA	T_PLYPSL
;
		M8
;
;-------------- player pos OAM set ----------------------
PPST020		EQU	$
		LDA	<FRCNT
		AND	#018H
		BEQ	PPST030		;OAM set timming ? ( no:PPST030 )
;
		M16
;
		LDA	T_PLXPSL
		SEC
		SBC	<SCCH1
		STA	<WORK		;(WK0,1) <-- display X pos
		CLC
		ADC	#010H
		CMP	#0100H+010H
		BCS	PPST030		;X pos display ? ( no:PPST030 )
;
		LDA	T_PLYPSL
		SEC
		SBC	<SCCV1
		PHA			;(A) save
		CLC
		ADC	#010H
		CMP	#0F0H+010H
		PLA			;(A) load
		BCS	PPST030		;Y pos display ? ( no:PPST030 )
;
		M8
;
		STA	>LASOAM+1	;OAM Y pos set
		LDA	#0AEH
		STA	>LASOAM+2	; "  chara no. set
		LDA	#030H
		STA	>LASOAM+3	; "  att set
		LDA	<WORK
		STA	>LASOAM		; "  X pos set
		LDA	<WORK+1
		AND	#01H
		ASL	A
		ASL	A
		ASL	A
		ASL	A
		ORA	>OAMSUB
		STA	>OAMSUB		 ;OAM sub set
;
;-------------- BG screen scroll write ------------------
PPST030		EQU	$
;
		M8
;
PPST040		EQU	$
		JMP	>BGSET
;
;	TIMSTFG
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+		^C}[JEg Zbg		+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
TIMCNTST_OBJDT	EQU	$
		BYTE	050H,0B4H,C_T,03CH	; T
		BYTE	058H,0B4H,C_I,03CH	; I
		BYTE	060H,0B4H,C_M,03CH	; M
		BYTE	068H,0B4H,C_E,03CH	; E
		BYTE	070H,0B4H,C_R,03CH	; R
;
		BYTE	080H,0B4H,L_e,03CH	; =
;
TIMCNTST_KAZU	EQU	$
		BYTE	090H,0B4H,SU0,03CH	; 0
		BYTE	098H,0B4H,SU0,03CH	; 0
		BYTE	0A0H,0B4H,SU0,03CH	; 0
TIMCNTST_OBJ	EQU	$
;
TIMCNTST_DATA	EQU	$
		BYTE	003H,007H,00BH
;
TIMCNTST_DAT	EQU	$
		WORD	00100,00010,00001
;
;
TIMCNTST	EQU	$
		MI16			; memory , index 16bit mode
		LDX	#00000H
TIMCNTST_100	EQU	$
		LDA	TIMCNTST_OBJDT,X
		STA	>OAM+10H,X
		INX
		INX
		CPX	#TIMCNTST_OBJ-TIMCNTST_OBJDT
		BCC	TIMCNTST_100
;
		LDX	#00000H
		TXY
		LDA	!TIMER
TIMCNTST_130	EQU	$		; S̈
		CMP	#00100
		BCC	TIMCNTST_150
		SBC	#00100
		INX
		BRA	TIMCNTST_130
;
TIMCNTST_150	EQU	$		; \̈
		CMP	#00010
		BCC	TIMCNTST_200
		SBC	#00010
		INY
		BRA	TIMCNTST_150
;
TIMCNTST_200	EQU	$
		STX	<WORK10		; S
		STY	<WORK12		; \
		STA	<WORK14		; 
		MI8			; memory , index 8bit mode
		ORA	#030H
		STA	>OAM+10H+(TIMCNTST_KAZU-TIMCNTST_OBJDT)+10
		TYA
		ORA	#030H
		STA	>OAM+10H+(TIMCNTST_KAZU-TIMCNTST_OBJDT)+6
		TXA
		ORA	#030H
		STA	>OAM+10H+(TIMCNTST_KAZU-TIMCNTST_OBJDT)+2
;
		LDA	<FRCNT
		AND	#010H
		BEQ	TIMCNTST_300
		LDY	!TIMSTFG
		LDX	TIMCNTST_DATA,Y
		LDA	#030H
		STA	>OAM+10H+(TIMCNTST_KAZU-TIMCNTST_OBJDT),X
;
TIMCNTST_300	EQU	$
		LDA	!INKEY
		CMP	#SU0
		BCC	TIMCNTST_900
		CMP	#SU9+1
		BCS	TIMCNTST_900
		SEC
		SBC	#030H
		STA	<WORK0
		STZ	<WORK1
;
		M16			; memory 16bit mode
		LDA	#00000
TIMCNTST_305	EQU	$
		DEC	<WORK10
		BMI	TIMCNTST_310
		CLC
		ADC	#00100
		BRA	TIMCNTST_305
;
TIMCNTST_310	EQU	$
		STA	<WORK10		; S
		LDA	#00000
TIMCNTST_315	EQU	$
		DEC	<WORK12
		BMI	TIMCNTST_320
		CLC
		ADC	#00010
		BRA	TIMCNTST_315
;
TIMCNTST_320	EQU	$
		STA	<WORK12		; \
;
		LDA	!TIMSTFG
		AND	#000FFH
		ASL	A
		TAX
		LDA	#00000H
TIMCNTST_330	EQU	$
		DEC	<WORK0
		BMI	TIMCNTST_350
		CLC
		ADC	TIMCNTST_DAT,X
		BRA	TIMCNTST_330
TIMCNTST_350	EQU	$
		STA	<WORK10,X
		LDA	<WORK10		; ^C}[ Zbg !!
		CLC
		ADC	<WORK12
		CLC
		ADC	<WORK14
		STA	!TIMER
		STA	!T_TIMER
		M8			; memory 8bit mode
;
		LDA	!TIMSTFG
		INC	A
		CMP	#003H
		BCC	TIMCNTST_380
		LDA	#000H
TIMCNTST_380	EQU	$
		STA	!TIMSTFG
;
TIMCNTST_900	EQU	$
		RTS
;
;
;****************************************************************
;*								*
;*	P jbg ړ [h					*
;*								*
;****************************************************************
ONEMOVE		EQU	$
		LDA	!UNTMVMD
		BNE	ONEMOVE_100
		LDA	!MOUSEBT
		AND	#01000000B	; mouse [L] key ON ?
		BEQ	ONEMOVE_999	;	NO -> ONEMOVE_999
		INC	!UNTMVMD
		JSR	SEARCH		; search
		LDA	SRCHPT
		BMI	ONEMOVE_999
;
ONEMOVE_100	EQU	$
		JSR	CPSCAL		; J[\ |Cg Zbg !!
		LDA	!MOUSEBS
		AND	#01000000B	; mouse [L] key ON ?
		BEQ	ONEMOVE_800	;	NO -> ONEMOVE_800
		LDA	!CRXPSL1
		AND	#0F0H
		SEC
		SBC	<SCCH1
		STA	>OAM+4
		LDA	!CRYPSL1
		AND	#0F0H
		SEC
		SBC	<SCCV1
		STA	>OAM+5
		LDA	#000H
		STA	>OAM+6
		LDA	#033H
		STA	>OAM+7
		JSR	SRCH200		; T[` f[^ ʕ\ !!
		BRA	ONEMOVE_999
;
ONEMOVE_800	EQU	$
		MI16			; memory , index 16bit mode
		JSR	XYSTART		; X,Y start point set
		LDX	!SRCHPT
		BMI	ONEMOVE_890
		LDA	<WORK0
		CMP	>DTBUFF+1,X
		BEQ	ONEMOVE_890
		JSR	LIMTCHK		; ʊO `FbN & Zbg
		MI8			; memory , index 8bit mode
		STZ	!UNTMVMD
		STZ	!EDMODE		       ;nomal mode return
		BRA	ONEMOVE_999
ONEMOVE_890	EQU	$
		MI8			; memory , index 8bit mode
		STZ	!UNTMVMD
;
ONEMOVE_999	EQU	$
		RTS
;
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+							+
;+	ʊO `FbN & Zbg			+
;+			in				+
;+			X <- data set index		+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
		MEM16
		IDX16
LIMTCHK		EQU	$
		LDA	>DTBUFF,X
		AND	#000FFH
		BNE	LIMTCHK_200
		JSR	LIMTCHK_KOTEI	; Œ f[^ `FbN
		BRA	LIMTCHK_700
;
LIMTCHK_200	EQU	$
		PHX
		JSR	LIMTCHK_KAHEN	;  f[^ `FbN
		PLX
;
LIMTCHK_700	EQU	$
		LDA	<WORKE
		BNE	LIMTCHK_900
		PHX
		MI8			; memory , index 8bit mode
		JSR	UNDOBFST	; undo buffer set
		MI16			; memory , index 16bit mode
		PLX
		LDA	<WORK0
		STA	>DTBUFF+1,X
		MI8			; memory , index 8bit mode
		JSL	>UNITST0	; unit buffer set
		STZ	EDMODE		; nomal mode return
		MI16			; memory , index 16bit mode
LIMTCHK_900	EQU	$
		RTS
		MEM8
		IDX8
;
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+						+
;+	Œ f[^ `FbN			+
;+			in			+
;+			workA,B <- X start point+
;+			workC,D <- Y start point+
;+			X <--- data read index	+
;+			out			+
;+			OK : 0000 -> work E,F	+
;+			OUT: ffff -> work E,F	+
;++++++++++++++++++++++++++++++++++++++++++++++++
		MEM16
		IDX16
LIMTCHK_KOTEI	EQU	$
		JSR	KOTEI_SB	; Œ f[^ count set
		JSR	KOTEI_KAHEN	; Œ  ~bg `FbN
		RTS
;
;
;++++++++++++++++++++++++++++++++++++++++
;+	Œ f[^ count set		+
;++++++++++++++++++++++++++++++++++++++++
KOTEI_SB	EQU	$
		LDA	>DTBUFF+3,X
		AND	#000FFH
		ASL	A
		TAY
		LDA	KOTEI_DT,Y
		PHA
		AND	#000FFH
		STA	<WORK2		; X check data
		PLA
		XBA
		AND	#000FFH
		STA	<WORK4		; Y check data
		RTS
		MEM8
		IDX8
;
KOTEI_DT	EQU	$
		WORD	00101H,00101H,00101H,00101H	; 00-03
		WORD	00101H,00101H,00101H,00101H	; 04-07
		WORD	00000H,00000H,00000H,00000H	; 08-0B
		WORD	00000H,00000H,00000H,00000H	; 0C-0F
;
		WORD	00000H,00000H,00000H,00000H	; 10-13
		WORD	00000H,00000H,00000H,00000H	; 14-17
		WORD	00000H,00000H,00000H,00000H	; 18-1B
		WORD	00000H,00000H,00000H,00000H	; 1C-1F
;
		WORD	00000H,00000H,00000H,00000H	; 20-23
		WORD	00000H,00000H,00000H,00000H	; 24-27
		WORD	00000H,00000H,00000H,00000H	; 28-2B
		WORD	00000H,00000H,00000H,00000H	; 2C-2F
;
		WORD	00101H,00606H,00000H,00000H	; 30-33
		WORD	00000H,00000H,00000H,00000H	; 34-37
		WORD	00000H,00000H,00000H,00000H	; 38-3B
		WORD	00000H,00000H,00000H,00000H	; 3C-3F
;
		WORD	00000H,00000H,00000H,00000H	; 40-43
		WORD	00000H,00000H,00000H,00200H	; 44-47
		WORD	00300H,00000H,00000H,00000H	; 48-4B
		WORD	00000H,00000H,00000H,00000H	; 4C-4F
;
		WORD	00101H,00000H,00102H,00000H	; 50-53
		WORD	00000H,00000H,00000H,00000H	; 54-57
		WORD	00000H,00000H,00000H,00000H	; 58-5B
		WORD	00000H,00000H,00000H,00000H	; 5C-5F
;
		WORD	00000H,00000H,00000H,00000H	; 60-63
		WORD	00000H,00000H,00000H,00000H	; 64-67
		WORD	00000H,00000H,00000H,00000H	; 68-6B
		WORD	00000H,00000H,00000H,00000H	; 6C-6F
;
		WORD	00000H,00000H,00000H,00000H	; 70-73
		WORD	00000H,00000H,00000H,00000H	; 74-77
		WORD	00000H,00000H,00000H,00000H	; 78-7B
		WORD	00000H,00000H,00000H,00000H	; 7C-7F
;
		WORD	00000H,00000H,00000H,00000H	; 80-83
		WORD	00000H,00000H,00000H,00000H	; 84-87
		WORD	00000H,00000H,00000H,00000H	; 88-8B
		WORD	00000H,00000H,00000H,00000H	; 8C-8F
;
		WORD	00000H,00000H,00000H,00000H	; 90-93
		WORD	00000H,00000H,00000H,00000H	; 94-97
		WORD	00000H,00000H,00000H,00000H	; 98-9B
		WORD	00000H,00000H,00000H,00000H	; 9C-9F
;
		WORD	00000H,00000H,00000H,00000H	; A0-A3
		WORD	00000H,00000H,00000H,00000H	; A4-A7
		WORD	00000H,00000H,00000H,00000H	; A8-AB
		WORD	00000H,00000H,00000H,00000H	; AC-AF
;
		WORD	00000H,00000H,00000H,00000H	; B0-B3
		WORD	00000H,00000H,00000H,00000H	; B4-B7
		WORD	00000H,00000H,00000H,00000H	; B8-BB
		WORD	00000H,00000H,00000H,00000H	; BC-BF
;
		WORD	00000H,00000H,00000H,00000H	; C0-C3
		WORD	00000H,00000H,00000H,00000H	; C4-C7
		WORD	00000H,00000H,00000H,00000H	; C8-CB
		WORD	00000H,00000H,00000H,00000H	; CC-CF
;
		WORD	00000H,00000H,00000H,00000H	; D0-D3
		WORD	00000H,00000H,00000H,00000H	; D4-D7
		WORD	00000H,00000H,00000H,00000H	; D8-DB
		WORD	00000H,00000H,00000H,00000H	; DC-DF
;
		WORD	00000H,00000H,00000H,00000H	; E0-E3
		WORD	00000H,00000H,00000H,00000H	; E4-E7
		WORD	00000H,00000H,00000H,00000H	; E8-EB
		WORD	00000H,00000H,00000H,00000H	; EC-EF
;
		WORD	00000H,00000H,00000H,00000H	; F0-F3
		WORD	00000H,00000H,00000H,00000H	; F4-F7
		WORD	00000H,00000H,00000H,00000H	; F8-FB
		WORD	00000H,00000H,00000H,00000H	; FC-FF
;
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+						+
;+	 f[^ `FbN			+
;+			in			+
;+			workA,B <- X start point+
;+			workC,D <- Y start point+
;+			X <--- data read index	+
;+			out			+
;+			OK : 0000 -> work E,F	+
;+			OUT: ffff -> work E,F	+
;++++++++++++++++++++++++++++++++++++++++++++++++
		MEM16
		IDX16
LIMTCHK_KAHEN	EQU	$
		JSR	KAHEN_SB0	;  X^[gf[^ count set
		JSR	KOTEI_KAHEN	; Œ  ~bg `FbN
		LDA	<WORKE
		BEQ	KAHEN_200
		JMP	KAHEN_900
;
KAHEN_200	EQU	$		; end point check
		JSR	KAHEN_SB1	;  Ghf[^ count set
		JSR	KOTEI_KAHEN	; Œ  ~bg `FbN
		LDA	<WORKE
		BNE	KAHEN_900
;
KAHEN_300	EQU	$		; Eオ ~bg `FbN
		LDY	#00000H
		LDA	>DTBUFF,X
		AND	#000FFH
		INY
		CMP	#00005H
		BEQ	KAHEN_310
		INY
		CMP	#00007H
		BEQ	KAHEN_310
		INY
		CMP	#00009H
		BEQ	KAHEN_310
		INY
		CMP	#00046H
		BEQ	KAHEN_310
		INY
		CMP	#0005CH
		BEQ	KAHEN_310
		INY
		CMP	#0005DH
		BEQ	KAHEN_310
		INY
		CMP	#0005EH
		BNE	KAHEN_900
KAHEN_310	EQU	$
		LDA	<WORK2
		STA	<WORK4
		LDA	KAHEN_DT2,Y
		BEQ	KAHEN_350
		BMI	KAHEN_320
		ASL	<WORK4
		BRA	KAHEN_350
KAHEN_320	EQU	$
		LSR	<WORK4
KAHEN_350	EQU	$
		JSR	KOTEI_KAHEN	; Œ  ~bg `FbN
;
KAHEN_900	EQU	$
		RTS
;
;
;++++++++++++++++++++++++++++++++++++++++
;+	 X^[gf[^ count set	+
;++++++++++++++++++++++++++++++++++++++++
KAHEN_SB0	EQU	$
		LDA	>DTBUFF,X
		AND	#000FFH
		ASL	A
		TAY
KAHEN_100	EQU	$		; start point check
		LDA	KAHEN_DT0,Y
		PHA
		AND	#000FFH
		BEQ	KAHEN_110
		ORA	#0FF00H
KAHEN_110	EQU	$
		STA	<WORK2
		PLA
		XBA
		AND	#000FFH
		BEQ	KAHEN_120
		ORA	#0FF00H
KAHEN_120	EQU	$
		STA	<WORK4
		RTS
;
;
;++++++++++++++++++++++++++++++++++++++++
;+	 Ghf[^ count set	+
;+		in			+
;+		X <- read data index	+
;++++++++++++++++++++++++++++++++++++++++
KAHEN_SB1	EQU	$
		PHX
		LDA	>DTBUFF+3,X	; X or Y size
		PHA
		AND	#000FFH
		STA	<WORK6
		AND	#00080H
		BEQ	KAHEN_210
		LDA	<WORK6
		ORA	#0FF00H
		STA	<WORK6
KAHEN_210	EQU	$
		PLA
		XBA
		AND	#000FFH
		STA	<WORK8
		AND	#00080H
		BEQ	KAHEN_220
		LDA	<WORK8
		ORA	#0FF00H
		STA	<WORK8
KAHEN_220	EQU	$
		LDA	KAHEN_DT1,Y
		PHA
		AND	#000FFH
		STA	<WORK2
		PLA
		XBA
		AND	#000FFH
		STA	<WORK4
		TYA
		LSR	A
		TAX
		LDA	>KAHNSB,X
		AND	#00003H
		STA	<WORKE
		AND	#00001H
		ASL	A
		TAX
		LDA	<WORK6		; X or Y size
		CLC
		ADC	<WORKA,X
		STA	<WORKA,X
		LDA	<WORKE
		AND	#00002H		; size data 1 set ?
		BEQ	KAHEN_250	;	YES -> KAHEN_250
		LDA	<WORK8		; Y size
		CLC
		ADC	<WORKC
		STA	<WORKC
KAHEN_250	EQU	$
		PLX
		RTS
		MEM8
		IDX8
;
KAHEN_DT0	EQU	$-2		; start point check data
		WORD	       0FF00H,0FFFFH,0FF00H	; 00-03
		WORD	0FF00H,0FF00H,0FF00H,0FE00H	; 04-07
		WORD	0FF00H,0FE00H,00000H,00000H	; 08-0B
		WORD	00000H,00000H,00000H,00000H	; 0C-0F
;
		WORD	00000H,00000H,00000H,00000H	; 10-13
		WORD	00000H,00000H,00000H,0FFFFH	; 14-17
		WORD	00000H,00000H,00000H,00000H	; 18-1B
		WORD	00000H,00000H,00000H,00000H	; 1C-1F
;
		WORD	00000H,00000H,00000H,00000H	; 20-03
		WORD	00000H,00000H,00000H,00000H	; 24-27
		WORD	00000H,00000H,00000H,00000H	; 28-2B
		WORD	00000H,00000H,00000H,00000H	; 2C-2F
;
		WORD	00000H,00000H,00000H,00000H	; 30-33
		WORD	00000H,00000H,00000H,00000H	; 34-37
		WORD	00000H,00000H,00000H,00000H	; 38-3B
		WORD	00000H,00000H,00000H,00000H	; 3C-3F
;
		WORD	00000H,00000H,00000H,00000H	; 40-43
		WORD	00000H,0FF00H,0FF00H,00000H	; 44-47
		WORD	00000H,00000H,00000H,00000H	; 48-4B
		WORD	00000H,00000H,00000H,00000H	; 4C-4F
;
		WORD	00000H,00000H,00000H,00000H	; 50-53
		WORD	00000H,00000H,00000H,00000H	; 54-57
		WORD	00000H,0FF00H,0FF00H,0FF00H	; 58-5B
		WORD	0FF00H,0FF00H,0FE00H,00000H	; 5C-5F
;
		WORD	00000H,00000H,00000H,00000H	; 60-63
		WORD	00000H,00000H,00000H,00000H	; 64-67
		WORD	00000H,00000H,00000H,00000H	; 68-6B
		WORD	00000H,00000H,00000H,00000H	; 6C-6F
;
		WORD	00000H,00000H,00000H,00000H	; 70-73
		WORD	00000H,00000H,00000H,00000H	; 74-77
		WORD	00000H,00000H,00000H,00000H	; 78-7B
		WORD	00000H,00000H,00000H,00000H	; 7C-7F
;
		WORD	00000H,00000H,00000H,00000H	; 80-83
		WORD	00000H,00000H,00000H,00000H	; 84-87
		WORD	00000H,00000H,00000H,00000H	; 88-8B
		WORD	00000H,00000H,00000H,00000H	; 8C-8F
;
		WORD	00000H,00000H,00000H,00000H	; 90-93
		WORD	00000H,00000H,00000H,00000H	; 94-97
		WORD	00000H,00000H,00000H,00000H	; 98-9B
		WORD	00000H,00000H,00000H,00000H	; 9C-9F
;
		WORD	00000H,00000H,00000H,00000H	; A0-A3
		WORD	00000H,00000H,00000H,00000H	; A4-A7
		WORD	00000H,00000H,00000H,00000H	; A8-AB
		WORD	00000H,00000H,00000H,00000H	; AC-AF
;
		WORD	00000H,00000H,00000H,00000H	; B0-B3
		WORD	00000H,00000H,00000H,00000H	; B4-B7
		WORD	00000H,00000H,00000H,00000H	; B8-BB
		WORD	00000H,00000H,00000H,00000H	; BC-BF
;
		WORD	00000H,00000H,00000H,00000H	; C0-C3
		WORD	00000H,00000H,00000H,00000H	; C4-C7
		WORD	00000H,00000H,00000H,00000H	; C8-CB
		WORD	00000H,00000H,00000H,00000H	; CC-CF
;
		WORD	00000H,00000H,00000H,00000H	; D0-D3
		WORD	00000H,00000H,00000H,00000H	; D4-D7
		WORD	00000H,00000H,00000H,00000H	; D8-DB
		WORD	00000H,00000H,00000H,00000H	; DC-DF
;
		WORD	00000H,00000H,00000H,00000H	; E0-E3
		WORD	00000H,00000H,00000H,00000H	; E4-E7
		WORD	00000H,00000H,00000H,00000H	; E8-EB
		WORD	00000H,00000H,00000H,00000H	; EC-EF
;
		WORD	00000H,00000H,00000H,00000H	; F0-F3
		WORD	00000H,00000H,00000H,00000H	; F4-F7
		WORD	00000H,00000H,00000H,00000H	; F8-FB
		WORD	00000H,00000H,00000H,00000H	; FC-FF
;
KAHEN_DT1	EQU	$-2		; end point check data
		WORD	       00000H,00000H,00000H	; 00-03
		WORD	00000H,00000H,00000H,00000H	; 04-07
		WORD	00000H,00000H,00000H,00000H	; 08-0B
		WORD	00000H,00000H,00000H,00000H	; 0C-0F
;
		WORD	00000H,00000H,00000H,00000H	; 10-13
		WORD	00000H,00000H,00000H,00000H	; 14-17
		WORD	00000H,00000H,00000H,00000H	; 18-1B
		WORD	00000H,00000H,00000H,00000H	; 1C-1F
;
		WORD	00000H,00000H,00000H,00000H	; 20-03
		WORD	00000H,00000H,00000H,00000H	; 24-27
		WORD	00000H,00000H,00000H,00000H	; 28-2B
		WORD	00000H,00000H,00000H,00000H	; 2C-2F
;
		WORD	00000H,00000H,00000H,00000H	; 30-33
		WORD	00000H,00000H,00000H,00000H	; 34-37
		WORD	00000H,00000H,00000H,00000H	; 38-3B
		WORD	00000H,00000H,00000H,00000H	; 3C-3F
;
		WORD	00000H,00000H,00000H,00000H	; 40-43
		WORD	00000H,00000H,00000H,00000H	; 44-47
		WORD	00000H,00000H,00000H,00000H	; 48-4B
		WORD	00000H,00000H,00000H,00000H	; 4C-4F
;
		WORD	00000H,00000H,00000H,00000H	; 50-53
		WORD	00000H,00000H,00000H,00000H	; 54-57
		WORD	00000H,00000H,00000H,00000H	; 58-5B
		WORD	00000H,00000H,00000H,00000H	; 5C-5F
;
		WORD	00000H,00000H,00000H,00000H	; 60-63
		WORD	00000H,00000H,00000H,00000H	; 64-67
		WORD	00000H,00000H,00000H,00000H	; 68-6B
		WORD	00000H,00000H,00000H,00000H	; 6C-6F
;
		WORD	00000H,00000H,00000H,00000H	; 70-73
		WORD	00000H,00000H,00000H,00000H	; 74-77
		WORD	00000H,00000H,00000H,00000H	; 78-7B
		WORD	00000H,00000H,00000H,00000H	; 7C-7F
;
		WORD	00000H,00000H,00000H,00000H	; 80-83
		WORD	00000H,00000H,00000H,00000H	; 84-87
		WORD	00000H,00000H,00000H,00000H	; 88-8B
		WORD	00000H,00000H,00000H,00000H	; 8C-8F
;
		WORD	00000H,00000H,00000H,00000H	; 90-93
		WORD	00000H,00000H,00000H,00000H	; 94-97
		WORD	00000H,00000H,00000H,00000H	; 98-9B
		WORD	00000H,00000H,00000H,00000H	; 9C-9F
;
		WORD	00000H,00000H,00000H,00000H	; A0-A3
		WORD	00000H,00000H,00000H,00000H	; A4-A7
		WORD	00000H,00000H,00000H,00000H	; A8-AB
		WORD	00000H,00000H,00000H,00000H	; AC-AF
;
		WORD	00000H,00000H,00000H,00000H	; B0-B3
		WORD	00000H,00000H,00000H,00000H	; B4-B7
		WORD	00000H,00000H,00000H,00000H	; B8-BB
		WORD	00000H,00000H,00000H,00000H	; BC-BF
;
		WORD	00000H,00000H,00000H,00000H	; C0-C3
		WORD	00000H,00000H,00000H,00000H	; C4-C7
		WORD	00000H,00000H,00000H,00000H	; C8-CB
		WORD	00000H,00000H,00000H,00000H	; CC-CF
;
		WORD	00000H,00000H,00000H,00000H	; D0-D3
		WORD	00000H,00000H,00000H,00000H	; D4-D7
		WORD	00000H,00000H,00000H,00000H	; D8-DB
		WORD	00000H,00000H,00000H,00000H	; DC-DF
;
		WORD	00000H,00000H,00000H,00000H	; E0-E3
		WORD	00000H,00000H,00000H,00000H	; E4-E7
		WORD	00000H,00000H,00000H,00000H	; E8-EB
		WORD	00000H,00000H,00000H,00000H	; EC-EF
;
		WORD	00000H,00000H,00000H,00000H	; F0-F3
		WORD	00000H,00000H,00000H,00000H	; F4-F7
		WORD	00000H,00000H,00000H,00000H	; F8-FB
		WORD	00000H,00000H,00000H,00000H	; FC-FF
;
KAHEN_DT2	EQU	$-1
		BYTE	080H,000H,001H,000H,080H,000H,001H
;
;
;++++++++++++++++++++++++++++++++++++++++
;+					+
;+	Œ  ~bg `FbN	+
;+		in			+
;+		work2,3 <- X count	+
;+		    4,5 <- Y count	+
;+		    A,B <- X start point+
;+		    C,D <- Y start point+
;+		    X <- data read index+
;+		out			+
;+		OK : 0000 -> work E,F	+
;+		OUT: ffff -> work E,F	+
;++++++++++++++++++++++++++++++++++++++++
		MEM16
		IDX16
KOTEI_KAHEN	EQU	$
		STZ	<WORKE
		LDA	<WORKA		; X check
		CLC
		ADC	<WORK2
		STA	<WORK6
		AND	#0FF00H		; X ~bg OK ?
		BNE	KOTEI_KAHEN10	;	NO -> KOTEI_KAHEN10
		LDA	<WORKC		; Y check
		CLC
		ADC	<WORK4
		STA	<WORK8
		AND	#0FF80H		; Y ~bg OK ?
		BNE	KOTEI_KAHEN10	;	NO -> KOTEI_KAHEN10
		LDA	<BGBFPT
		AND	#000FFH
		CMP	#00063		; XN[ ʂς ?
		BCC	KOTEI_KAHEN90	;	YES -> KOTEI_KAHEN90
		LSR	<WORK6
		LSR	<WORK6
		LSR	<WORK6
		LSR	<WORK6
		LDA	<WORK8
		AND	#00070H
		ORA	<WORK6
		STA	<WORK6
		LDA	>DTBUFF+1,X
		AND	#000FFH
		CMP	<WORK6		; XN[ ʓ ?
		BEQ	KOTEI_KAHEN90	;	YES -> KOTEI_KAHEN90
KOTEI_KAHEN10	EQU	$
		DEC	<WORKE		; error !!
KOTEI_KAHEN90	EQU	$
		RTS
		MEM8
		IDX8
;
;
;****************************************************************
;*								*
;*	x̃jbg܂Ƃ߂ĈړCjV[h	*
;*								*
;****************************************************************
ALLMVINT	EQU	$
		STZ	!KHNKTIMD
		STZ	!UNTMVMD
		LDA	#ALMV
		STA	!MODENO
		INC	!EDMODE		; nomal mode return
		RTS
;
;
;****************************************************************
;*								*
;*	x̃jbg܂Ƃ߂ĈړGh[h	*
;*								*
;****************************************************************
ALLMVEND	EQU	$
		STZ	!EDMODE		; nomal mode return
		LDA	!ERRFLG
		BEQ	ALLMVEND_900
		LDA	#ERR0
		STA	!MODENO
		LDA	#search
		STA	!EDMODE
ALLMVEND_900	EQU	$
		RTS
;
;
;****************************************************************
;*								*
;*	x̃jbg܂Ƃ߂Ĉړ郂[h		*
;*								*
;****************************************************************
ALLMOVE		EQU	$
		PHB
		PHK
		PLB
		LDX	SIFTFG
		JSR	MSCSRMV		;mouse coursol move
		JSL	>BGSET
;
		MI16			; memory , index 16bit mode
		LDX	#00000H
ALLMOVE_LOP	EQU	$
		LDA	ALLMOVE_DAT,X
		STA	>OAM+100H,X
		INX
		INX
		CPX	#ALLMOVE_DATA-ALLMOVE_DAT
		BCC	ALLMOVE_LOP
		MI8			; memory , index 8bit mode
;
		LDA	!KHNKTIMD
		ASL	A
		ASL	A
		ASL	A
		TAY
		LDA	KHNKTIDT+0,Y
		STA	>OAM+100H+(ALLMOVE_KK-ALLMOVE_DAT)+02H
		LDA	KHNKTIDT+1,Y
		STA	>OAM+100H+(ALLMOVE_KK-ALLMOVE_DAT)+06H
		LDA	KHNKTIDT+2,Y
		STA	>OAM+100H+(ALLMOVE_KK-ALLMOVE_DAT)+0AH
		LDA	KHNKTIDT+3,Y
		STA	>OAM+100H+(ALLMOVE_KK-ALLMOVE_DAT)+0EH
		LDA	KHNKTIDT+4,Y
		STA	>OAM+100H+(ALLMOVE_KK-ALLMOVE_DAT)+12H
		LDA	KHNKTIDT+5,Y
		STA	>OAM+100H+(ALLMOVE_KK-ALLMOVE_DAT)+16H
		LDA	KHNKTIDT+6,Y
		STA	>OAM+100H+(ALLMOVE_KK-ALLMOVE_DAT)+1AH
		LDA	KHNKTIDT+7,Y
		STA	>OAM+100H+(ALLMOVE_KK-ALLMOVE_DAT)+1EH
;
		LDA	!UNTPTNSL	; "jbg"
		ASL	A		;    &
		ASL	A		; "p^["
		TAY			;	OBJ
		LDA	UNTPTNDT+00H,Y	;	 set
		STA	>OAM+100H+(ALLMOVE_UP-ALLMOVE_DAT)+002H
		LDA	UNTPTNDT+01H,Y
		STA	>OAM+100H+(ALLMOVE_UP-ALLMOVE_DAT)+006H
		LDA	UNTPTNDT+02H,Y
		STA	>OAM+100H+(ALLMOVE_UP-ALLMOVE_DAT)+00AH
		LDA	UNTPTNDT+03H,Y
		STA	>OAM+100H+(ALLMOVE_UP-ALLMOVE_DAT)+00EH
;
		LDA	!STUNTNO0	; unit NO. set 0
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		ORA	#070H
		STA	>OAM+100H+(ALLMOVE_NO0-ALLMOVE_DAT)+0AH
		LDA	!STUNTNO0
		AND	#00FH
		ORA	#070H
		STA	>OAM+100H+(ALLMOVE_NO0-ALLMOVE_DAT)+0EH
;
		LDY	!UTPNMODE	; mode set
		LDA	UTPNMODEDT,Y
		STA	>OAM+100H+(ALLMOVE_MD-ALLMOVE_DAT)+02H
		LDA	UTPNMODEDT+4,Y
		STA	>OAM+100H+(ALLMOVE_MD-ALLMOVE_DAT)+06H
;
		CPY	#003H
		BNE	ALLMOVE_100
		MI16			; memory , index 16bit mode
ALLMOVE_LOP2	EQU	$
		LDA	ALLMOVE_DAT,X
		STA	>OAM+100H,X
		INX
		INX
		CPX	#UNTPTNDT-ALLMOVE_DAT
		BCC	ALLMOVE_LOP2
		MI8			; memory , index 8bit mode
;
		LDA	!STUNTNO1	; unit NO. set 1
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		ORA	#070H
		STA	>OAM+100H+(ALLMOVE_NO1-ALLMOVE_DAT)+0AH
		LDA	!STUNTNO1
		AND	#00FH
		ORA	#070H
		STA	>OAM+100H+(ALLMOVE_NO1-ALLMOVE_DAT)+0EH
;
ALLMOVE_100	EQU	$
		LDA	!SIFTX+1
		BPL	ALLMOVE_110
		LDA	#02DH
		BRA	ALLMOVE_120
ALLMOVE_110	EQU	$
		LDA	#02BH
ALLMOVE_120	EQU	$
		STA	>OAM+100H+(ALLMOVE_X-ALLMOVE_DAT)+0AH
		LDA	!SIFTX		; "wQOO"
		LSR	A		;	set
		LSR	A
		LSR	A
		LSR	A
		ORA	#070H
		STA	>OAM+100H+(ALLMOVE_X-ALLMOVE_DAT)+0EH
		LDA	!SIFTX
		AND	#00FH
		ORA	#070H
		STA	>OAM+100H+(ALLMOVE_X-ALLMOVE_DAT)+12H
;
		LDA	!SIFTY+1
		BPL	ALLMOVE_160
		LDA	#02DH
		BRA	ALLMOVE_170
ALLMOVE_160	EQU	$
		LDA	#02BH
ALLMOVE_170	EQU	$
		STA	>OAM+100H+(ALLMOVE_Y-ALLMOVE_DAT)+0AH
		LDA	!SIFTY		; "xQOO"
		LSR	A		;	set
		LSR	A
		LSR	A
		LSR	A
		ORA	#070H
		STA	>OAM+100H+(ALLMOVE_Y-ALLMOVE_DAT)+0EH
		LDA	!SIFTY
		AND	#00FH
		ORA	#070H
		STA	>OAM+100H+(ALLMOVE_Y-ALLMOVE_DAT)+12H
;
		LDA	!UNTMVMD
		AND	#07FH
		TAX
		JSR	(ALLMOVE_SEL,X)
;
		LDA	!UNTMVMD
		AND	#080H
		STA	<WORK0
		LDA	!UNTMVMD
		AND	#07FH
		STA	!UNTMVMD
		LDA	!INKEY2
		CMP	#LEF
		BEQ	ALLMOVE_250
		CMP	#RIT
		BNE	ALLMOVE_300
		INC	!UNTMVMD
		INC	!UNTMVMD
		LDA	!UNTMVMD
		CMP	#006H
		BNE	ALLMOVE_240
		LDA	!UTPNMODE
		CMP	#003H
		BEQ	ALLMOVE_240
		INC	!UNTMVMD
		INC	!UNTMVMD
ALLMOVE_240	EQU	$
		LDA	!UNTMVMD
		CMP	#00EH
		BCC	ALLMOVE_270
		LDA	#00CH
		STA	!UNTMVMD
		BRA	ALLMOVE_270
ALLMOVE_250	EQU	$
		DEC	!UNTMVMD
		DEC	!UNTMVMD
		LDA	!UNTMVMD
		CMP	#006H
		BNE	ALLMOVE_260
		LDA	!UTPNMODE
		CMP	#003H
		BEQ	ALLMOVE_260
		DEC	!UNTMVMD
		DEC	!UNTMVMD
ALLMOVE_260	EQU	$
		LDA	!UNTMVMD
		BPL	ALLMOVE_270
		STZ	!UNTMVMD
ALLMOVE_270	EQU	$
		STZ	<WORK0
;
ALLMOVE_300	EQU	$
		LDA	!INKEY
		CMP	#ESC
		BNE	ALLMOVE_400
		LDA	!KHNKTIMD
		EOR	#001H
		STA	!KHNKTIMD
;
ALLMOVE_400	EQU	$
		LDA	!INKEY
		CMP	#L_I		;[I] key ON ?
		BEQ	ALLMOVE_450	;	YES -> ALLMOVE_450
		LDA	!UNTMVMD
		ORA	<WORK0
		STA	!UNTMVMD
		LDA	!MOUSEBT
		AND	#01000000B	; mouse [L] key ON ?
		BEQ	ALLMOVE_900	;	NO -> ALLMOVE_900
ALLMOVE_450	EQU	$
		LDA	#PLMD
		STA	!MODENO
ALLMOVE_900	EQU	$
		PLB
		RTL
;
ALLMOVE_DAT	EQU	$
ALLMOVE_KK	EQU	$
		BYTE	018H,0A8H,0A6H,038H	; ""
		BYTE	020H,0A8H,0A7H,038H	;   &
		BYTE	028H,0A8H,0A8H,038H	; "Œ"
		BYTE	030H,0A8H,0A9H,038H
		BYTE	018H,0B0H,0B6H,038H
		BYTE	020H,0B0H,0B7H,038H
		BYTE	028H,0B0H,0B8H,038H
		BYTE	030H,0B0H,0B9H,038H
;
ALLMOVE_UP	EQU	$
		BYTE	038H,0B9H,055H,032H	; "jbg"
		BYTE	040H,0B9H,04EH,032H	;     &
		BYTE	048H,0B9H,049H,032H	; "p^["
		BYTE	050H,0B9H,054H,032H
;
ALLMOVE_NO0	EQU	$
		BYTE	060H,0B9H,04EH,032H	; "mnDOO"
		BYTE	068H,0B9H,04FH,032H
		BYTE	060H,0C2H,070H,032H
		BYTE	068H,0C2H,070H,032H
;
ALLMOVE_MD	EQU	$
		BYTE	074H,0BCH,020H,033H	; "!!","<-|","|->","~"
		BYTE	07CH,0BCH,021H,033H
;
ALLMOVE_X	EQU	$
		BYTE	09DH,0B9H,058H,032H	; "wQ{OO"
		BYTE	0A6H,0B9H,05FH,032H
		BYTE	0AFH,0B9H,02BH,032H
		BYTE	0B6H,0B9H,070H,032H
		BYTE	0BEH,0B9H,070H,032H
;
ALLMOVE_Y	EQU	$
		BYTE	09DH,0C2H,059H,032H	; "xQ{OO"
		BYTE	0A6H,0C2H,05FH,032H
		BYTE	0AFH,0C2H,02BH,032H
		BYTE	0B6H,0C2H,070H,032H
		BYTE	0BEH,0C2H,070H,032H
;
ALLMOVE_RAN	EQU	$
		BYTE	0D0H,0C2H,052H,032H	; "RAN"
		BYTE	0D8H,0C2H,055H,032H
		BYTE	0E0H,0C2H,04EH,032H
ALLMOVE_DATA	EQU	$
;
ALLMOVE_NO1	EQU	$
		BYTE	085H,0B9H,04EH,032H	; "mnDOO"
		BYTE	08DH,0B9H,04FH,032H
		BYTE	085H,0C2H,070H,032H
		BYTE	08DH,0C2H,070H,032H
;
KHNKTIDT	EQU	$
		BYTE	0A6H,0A7H,0A8H,0A9H	; "Œ"
		BYTE	0B6H,0B7H,0B8H,0B9H
		BYTE	0AAH,0ABH,0ACH,0ADH	; ""
		BYTE	0BAH,0BBH,0BCH,0BDH
;
UNTPTNDT	EQU	$
		BYTE	055H,04EH,049H,054H	; "jbg"
		BYTE	050H,054H,052H,04EH	; "p^["
;
UTPNMODEDT	EQU	$
		BYTE	020H,022H,024H,026H	; "!!","<-|","|->","~"
		BYTE	021H,023H,025H,027H
;
ALLMOVE_SEL	EQU	$
		WORD	UNTPTN,STUNT0,PTNMD
		WORD	STUNT1,SIFT_X,SIFT_Y
		WORD	PSHRAN,YESNOOK
;
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+	jbg & p^[ set				+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
UNTPTN		EQU	$
		LDA	<FRCNT
		AND	#010H
		BNE	UNTPTN_000
		LDA	>OAM+100H+(ALLMOVE_UP-ALLMOVE_DAT)+03H
		EOR	#002H
		STA	>OAM+100H+(ALLMOVE_UP-ALLMOVE_DAT)+03H
		STA	>OAM+100H+(ALLMOVE_UP-ALLMOVE_DAT)+07H
		STA	>OAM+100H+(ALLMOVE_UP-ALLMOVE_DAT)+0BH
		STA	>OAM+100H+(ALLMOVE_UP-ALLMOVE_DAT)+0FH
UNTPTN_000	EQU	$
		LDA	!INKEY2
		CMP	#UPP
		BEQ	UNTPTN_100
		CMP	#DWN
		BNE	UNTPTN_300
UNTPTN_100	EQU	$
		LDA	!UNTPTNSL
		EOR	#001H
		AND	#001H
		STA	!UNTPTNSL
UNTPTN_300	EQU	$
		RTS
;
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+	jbg mnD set0				+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
STUNT0		EQU	$
		LDA	>OAM+100H+(ALLMOVE_NO0-ALLMOVE_DAT)+03H
		EOR	#002H
		STA	>OAM+100H+(ALLMOVE_NO0-ALLMOVE_DAT)+03H
		STA	>OAM+100H+(ALLMOVE_NO0-ALLMOVE_DAT)+07H
		STA	>OAM+100H+(ALLMOVE_NO0-ALLMOVE_DAT)+0BH
		STA	>OAM+100H+(ALLMOVE_NO0-ALLMOVE_DAT)+0FH
		LDA	<FRCNT
		AND	#010H
		BNE	STUNT0_000
		LDA	!UNTMVMD
		ROL	A
		ROL	A
		ROL	A
		ROL	A
		AND	#004H
		TAX
		LDA	>OAM+100H+(ALLMOVE_NO0-ALLMOVE_DAT)+0BH,X
		EOR	#002H
		STA	>OAM+100H+(ALLMOVE_NO0-ALLMOVE_DAT)+0BH,X
STUNT0_000	EQU	$
		LDA	!STUNTNO0
		STA	<WORK0
		JSR	STUNT0_SB	; unit NO. or sift count set
		LDA	<WORK0
		STA	!STUNTNO0
		RTS
;
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+	[h Zbg					+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
PTNMD		EQU	$
		LDA	<FRCNT
		AND	#010H
		BNE	PTNMD_000
		LDA	>OAM+100H+(ALLMOVE_MD-ALLMOVE_DAT)+03H
		EOR	#002H
		STA	>OAM+100H+(ALLMOVE_MD-ALLMOVE_DAT)+03H
		STA	>OAM+100H+(ALLMOVE_MD-ALLMOVE_DAT)+07H
PTNMD_000	EQU	$
		LDA	!INKEY2
		CMP	#UPP
		BNE	PTNMD_100
		LDA	!UTPNMODE
		DEC	A
		BRA	PTNMD_150
;
PTNMD_100	EQU	$
		CMP	#DWN
		BNE	PTNMD_300
		LDA	!UTPNMODE
		INC	A
PTNMD_150	EQU	$
		AND	#003H
		STA	!UTPNMODE
PTNMD_300	EQU	$
		RTS
;
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+	jbg mnD set1				+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
STUNT1		EQU	$
		LDA	>OAM+100H+(ALLMOVE_NO1-ALLMOVE_DAT)+03H
		EOR	#002H
		STA	>OAM+100H+(ALLMOVE_NO1-ALLMOVE_DAT)+03H
		STA	>OAM+100H+(ALLMOVE_NO1-ALLMOVE_DAT)+07H
		STA	>OAM+100H+(ALLMOVE_NO1-ALLMOVE_DAT)+0BH
		STA	>OAM+100H+(ALLMOVE_NO1-ALLMOVE_DAT)+0FH
		LDA	<FRCNT
		AND	#010H
		BNE	STUNT1_000
		LDA	!UNTMVMD
		ROL	A
		ROL	A
		ROL	A
		ROL	A
		AND	#004H
		TAX
		LDA	>OAM+100H+(ALLMOVE_NO1-ALLMOVE_DAT)+0BH,X
		EOR	#002H
		STA	>OAM+100H+(ALLMOVE_NO1-ALLMOVE_DAT)+0BH,X
STUNT1_000	EQU	$
		LDA	!STUNTNO1
		STA	<WORK0
		JSR	STUNT0_SB	; unit NO. or sift count set
		LDA	<WORK0
		STA	!STUNTNO1
		RTS
;
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+	w Vtg Zbg				+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
SIFT_X		EQU	$
		LDA	>OAM+100H+(ALLMOVE_X-ALLMOVE_DAT)+03H
		EOR	#002H
		STA	>OAM+100H+(ALLMOVE_X-ALLMOVE_DAT)+03H
		STA	>OAM+100H+(ALLMOVE_X-ALLMOVE_DAT)+07H
		STA	>OAM+100H+(ALLMOVE_X-ALLMOVE_DAT)+0BH
		STA	>OAM+100H+(ALLMOVE_X-ALLMOVE_DAT)+0FH
		STA	>OAM+100H+(ALLMOVE_X-ALLMOVE_DAT)+13H
		LDA	<FRCNT
		AND	#010H
		BNE	SIFT_X_000
		LDA	!UNTMVMD
		ROL	A
		ROL	A
		ROL	A
		ROL	A
		AND	#004H
		TAX
		LDA	>OAM+100H+(ALLMOVE_X-ALLMOVE_DAT)+0FH,X
		EOR	#002H
		STA	>OAM+100H+(ALLMOVE_X-ALLMOVE_DAT)+0FH,X
SIFT_X_000	EQU	$
		LDA	!INKEY2
		CMP	#UPP
		BEQ	SIFT_X_010
		CMP	#DWN
		BNE	SIFT_X_020
SIFT_X_010	EQU	$
		LDA	!SIFTX+1
		EOR	#0FFH
		STA	!SIFTX+1
SIFT_X_020	EQU	$
		LDA	!SIFTX
		STA	<WORK0
		JSR	STUNT0_SB	; unit NO. or sift count set
		LDA	<WORK0
		STA	!SIFTX
;
SIFT_X_900	EQU	$
		RTS
;
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+	x Vtg Zbg				+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
SIFT_Y		EQU	$
		LDA	>OAM+100H+(ALLMOVE_Y-ALLMOVE_DAT)+03H
		EOR	#002H
		STA	>OAM+100H+(ALLMOVE_Y-ALLMOVE_DAT)+03H
		STA	>OAM+100H+(ALLMOVE_Y-ALLMOVE_DAT)+07H
		STA	>OAM+100H+(ALLMOVE_Y-ALLMOVE_DAT)+0BH
		STA	>OAM+100H+(ALLMOVE_Y-ALLMOVE_DAT)+0FH
		STA	>OAM+100H+(ALLMOVE_Y-ALLMOVE_DAT)+13H
		LDA	<FRCNT
		AND	#010H
		BNE	SIFT_Y_000
		LDA	!UNTMVMD
		ROL	A
		ROL	A
		ROL	A
		ROL	A
		AND	#004H
		TAX
		LDA	>OAM+100H+(ALLMOVE_Y-ALLMOVE_DAT)+0FH,X
		EOR	#002H
		STA	>OAM+100H+(ALLMOVE_Y-ALLMOVE_DAT)+0FH,X
SIFT_Y_000	EQU	$
		LDA	!INKEY2
		CMP	#UPP
		BEQ	SIFT_Y_010
		CMP	#DWN
		BNE	SIFT_Y_020
SIFT_Y_010	EQU	$
		LDA	!SIFTY+1
		EOR	#0FFH
		STA	!SIFTY+1
SIFT_Y_020	EQU	$
		LDA	!SIFTY
		STA	<WORK0
		JSR	STUNT0_SB	; unit NO. or sift count set
		LDA	<WORK0
		STA	!SIFTY
;
SIFT_Y_900	EQU	$
		RTS
;
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+	f[^ Zbg X^[g				+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
PSHRAN		EQU	$
		LDA	<FRCNT
		AND	#010H
		BNE	PSHRAN_000
		LDA	>OAM+100H+(ALLMOVE_RAN-ALLMOVE_DAT)+03H
		EOR	#002H
		STA	>OAM+100H+(ALLMOVE_RAN-ALLMOVE_DAT)+03H
		STA	>OAM+100H+(ALLMOVE_RAN-ALLMOVE_DAT)+07H
		STA	>OAM+100H+(ALLMOVE_RAN-ALLMOVE_DAT)+0BH
PSHRAN_000	EQU	$
		LDA	!INKEY2
		CMP	#RTN
		BNE	PSHRAN_900
		LDA	UNTPTNSL	; unit move ?
		BNE	PSHRAN_100	;	NO -> PSHRAN_100
		LDA	!KHNKTIMD	; Œ [h ?
		BEQ	PSHRAN_100	;	YES -> PSHRAN_100
		LDA	!STUNTNO0
		BNE	PSHRAN_100
		LDA	#PLMD
		STA	!MODENO
		LDA	#040H
		STA	!ERRFLG
		BRA	PSHRAN_900
;
PSHRAN_100	EQU	$
		INC	!UNTMVMD
		INC	!UNTMVMD
PSHRAN_900	EQU	$
		RTS
;
SETGODT		EQU	$
		WORD	UNTSETGO0,PTNSETGO0
		WORD	UNTSETGO1,PTNSETGO1
		WORD	UNTSETGO2,PTNSETGO2
		WORD	UNTSETGO3,PTNSETGO3
;
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+	YES , NO L[				+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
YESNOOK		EQU	$
		MI16			; memory , index 16bit mode
		LDX	#00000H
YESNOOK_100	EQU	$
		LDA	YESNOOK_DAT,X
		STA	>OAM+010H,X
		INX
		INX
		CPX	#YESNOOK_DATA-YESNOOK_DAT
		BCC	YESNOOK_100
		MI8			; memory , index 8bit mode
;
		LDA	<FRCNT
		AND	#010H
		BEQ	YESNOOK_200
		LDA	#03CH
		STA	>OAM+010H+003H
		STA	>OAM+010H+007H
		STA	>OAM+010H+00BH
		STA	>OAM+010H+00FH
		STA	>OAM+010H+013H
		STA	>OAM+010H+017H
		STA	>OAM+010H+01BH
		STA	>OAM+010H+01FH
		STA	>OAM+010H+023H
		STA	>OAM+010H+027H
		STA	>OAM+010H+02BH
;
YESNOOK_200	EQU	$
		LDA	!INKEY
		CMP	#L_Y
		BEQ	YESNOOK_300
		CMP	#L_N
		BEQ	YESNOOK_400
		BRA	YESNOOK_900
;
YESNOOK_300	EQU	$
		JSR	UNDOBFST	; undo buffer set
		LDA	!SIFTX
		STA	<WORK12
		STZ	<WORK13
		LDA	!SIFTX+1
		BPL	YESNOOK_310
		STA	<WORK13
		LDA	<WORK12
		EOR	#0FFH
		INC	A
		STA	<WORK12
YESNOOK_310	EQU	$
		LDA	!SIFTY
		STA	<WORK14
		STZ	<WORK15
		LDA	!SIFTY+1
		BPL	YESNOOK_360
		STA	<WORK15
		LDA	<WORK14
		EOR	#0FFH
		INC	A
		STA	<WORK14
YESNOOK_360	EQU	$
		MI16			; memory , index 16bit mode
		STZ	<WORKE
		LDA	!STUNTNO0
		AND	#000FFH
		STA	<WORK10
		LDA	!UNTPTNSL
		AND	#000FFH
		ASL	A
		STA	<WORK0
		LDA	!UTPNMODE
		AND	#000FFH
		ASL	A
		ASL	A
		ORA	<WORK0
		TAX
		JSR	(SETGODT,X)	; data set go !!
		MI8			; memory , index 8bit mode
		BRA	YESNOOK_900
;
YESNOOK_400	EQU	$
		LDA	#PLMD
		STA	!MODENO
;
YESNOOK_900	EQU	$
		RTS
;
YESNOOK_DAT	EQU	$
		BYTE	050H,0ACH,053H,032H
		BYTE	058H,0ACH,045H,032H
		BYTE	060H,0ACH,054H,032H
		BYTE	068H,0ACH,020H,032H
		BYTE	070H,0ACH,04FH,032H
		BYTE	078H,0ACH,04BH,032H
		BYTE	080H,0ACH,03FH,032H
		BYTE	088H,0ACH,020H,032H
		BYTE	090H,0ACH,059H,032H
		BYTE	098H,0ACH,02FH,032H
		BYTE	0A0H,0ACH,04EH,032H
YESNOOK_DATA	EQU	$
;
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	unit NO. or sift count set		+
;++++++++++++++++++++++++++++++++++++++++++++++++
STUNT0_SB	EQU	$
		LDA	!INKEY3
		CMP	#SU0
		BCC	STUNT0_SB_990
		CMP	#SU9+1
		BCC	STUNT0_SB_210
		CMP	#L_A
		BCC	STUNT0_SB_990
		CMP	#L_G
		BCS	STUNT0_SB_990
		SEC
		SBC	#007H
STUNT0_SB_210	EQU	$
		SEC
		SBC	#030H
		STA	<WORK2
		LDA	!UNTMVMD
		BMI	STUNT0_SB_220
		ASL	<WORK2
		ASL	<WORK2
		ASL	<WORK2
		ASL	<WORK2
STUNT0_SB_220	EQU	$
		LDA	!UNTMVMD
		BPL	STUNT0_SB_230
		LDA	<WORK0
		AND	#0F0H
		STA	<WORK0
		BRA	STUNT0_SB_240
STUNT0_SB_230	EQU	$
		LDA	<WORK0
		AND	#00FH
		STA	<WORK0
STUNT0_SB_240	EQU	$
		LDA	<WORK0
		ORA	<WORK2
		STA	<WORK0
		LDA	!UNTMVMD
		EOR	#080H
		STA	!UNTMVMD
STUNT0_SB_990	EQU	$
		RTS
;
STUNT0_SB_ST	EQU	$
		PHB
		LDA	#BANK STUNT0_SB
		PHA
		PLB
		JSR	STUNT0_SB
		PLB
		RTL
;
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	jbg Zbg GO !!			+
;+				(ꂾ)	+
;++++++++++++++++++++++++++++++++++++++++++++++++
		MEM16
		IDX16
UNTSETGO0	EQU	$
		LDA	<WORK10
		STA	<WORK1A
		STZ	<WORK1C
		STZ	<WORK1E
		JSR	UNTCHKST	; `FbN & f[^ Zbg
		LDA	<WORKE
		PHA
		LDA	<WORK1E
		PHA
		MI8			; memory , index 8bit mode
		JSL	>UNITST0	; unit buffer set
		MI16			; memory , index 16bit mode
		PLA
		STA	<WORK1E
		PLA
		BPL	UNTSETGO0_900
		JSR	SETGO_ERR	; G[ Zbg!!
UNTSETGO0_900	EQU	$
		RTS
;
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	jbg Zbg GO !!			+
;+				(ȑO)		+
;++++++++++++++++++++++++++++++++++++++++++++++++
UNTSETGO1	EQU	$
		LDA	<WORK10
		STA	<WORK1A
		STZ	<WORK1C
		STZ	<WORK1E
UNTSETGO1_100	EQU	$
		JSR	UNTCHKST	; `FbN & f[^ Zbg
		LDA	<WORKE
		BMI	UNTSETGO1_200
UNTSETGO1_150	EQU	$
		STZ	<WORKE
		STZ	<WORK1C
		STZ	<WORK1E
		LDA	!KHNKTIMD	; Œ f[^ ?
		BEQ	UNTSETGO1_180	;	YES -> UNTSETGO1_180
		DEC	<WORK1A		;  jbg NO. Gh ?
		BEQ	UNTSETGO1_200	;	YES -> UNTSETGO1_200
		BRA	UNTSETGO1_190
UNTSETGO1_180	EQU	$
		DEC	<WORK1A		; Œ jbg NO. Gh ?
		BMI	UNTSETGO1_200	;	YES -> UNTSETGO1_200
UNTSETGO1_190	EQU	$
		JSR	UNTPOSCHK	; jbg NO. |Cg `FbN
		LDA	<WORKE
		BNE	UNTSETGO1_150
		BRA	UNTSETGO1_100
;
		LDA	<WORK1A
		BEQ	UNTSETGO1_200
		DEC	<WORK1A
		BRA	UNTSETGO1_100
;
UNTSETGO1_200	EQU	$
		LDA	<WORKE
		PHA
		LDA	<WORK1E
		PHA
		MI8			; memory , index 8bit mode
		JSL	>UNITST0	; unit buffer set
		MI16			; memory , index 16bit mode
		PLA
		STA	<WORK1E
		PLA
		BPL	UNTSETGO1_900
		JSR	SETGO_ERR	; G[ Zbg!!
UNTSETGO1_900	EQU	$
		RTS
;
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	jbg Zbg GO !!			+
;+				(ȍ~)		+
;++++++++++++++++++++++++++++++++++++++++++++++++
UNTSETGO2	EQU	$
		LDA	<WORK10
		STA	<WORK1A
		STZ	<WORK1C
		STZ	<WORK1E
UNTSETGO2_100	EQU	$
		JSR	UNTCHKST	; `FbN & f[^ Zbg
		LDA	<WORKE
		BMI	UNTSETGO2_200
UNTSETGO2_150	EQU	$
		STZ	<WORKE
		STZ	<WORK1C
		STZ	<WORK1E
		INC	<WORK1A
		JSR	UNTPOSCHK	; jbg NO. |Cg `FbN
		LDA	<WORKE
		BEQ	UNTSETGO2_100
		LDX	<WORK1A
		LDA	!KHNKTIMD
		AND	#0000FH
		BNE	UNTSETGO2_180
		LDA	>KOTESB,X
		AND	#000FFH
		CMP	#000FFH
		BNE	UNTSETGO2_150
		BRA	UNTSETGO2_200
UNTSETGO2_180	EQU	$
		LDA	>KAHNSB,X
		AND	#000FFH
		CMP	#000FFH
		BNE	UNTSETGO2_150
;
UNTSETGO2_200	EQU	$
		LDA	<WORKE
		PHA
		LDA	<WORK1E
		PHA
		MI8			; memory , index 8bit mode
		JSL	>UNITST0	; unit buffer set
		MI16			; memory , index 16bit mode
		PLA
		STA	<WORK1E
		PLA
		BPL	UNTSETGO2_900
		JSR	SETGO_ERR	; G[ Zbg!!
UNTSETGO2_900	EQU	$
		RTS
;
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	jbg Zbg GO !!			+
;+				(``܂)	+
;++++++++++++++++++++++++++++++++++++++++++++++++
UNTSETGO3	EQU	$
		LDA	<WORK10
		STA	<WORK1A
		STZ	<WORK1C
		STZ	<WORK1E
UNTSETGO3_100	EQU	$
		JSR	UNTCHKST	; `FbN & f[^ Zbg
		LDA	<WORKE
		BMI	UNTSETGO3_200
UNTSETGO3_150	EQU	$
		STZ	<WORKE
		STZ	<WORK1C
		STZ	<WORK1E
		LDA	!STUNTNO1
		AND	#000FFH
		CMP	<WORK1A
		BCS	UNTSETGO3_200
		INC	<WORK1A
		JSR	UNTPOSCHK	; jbg NO. |Cg `FbN
		LDA	<WORKE
		BNE	UNTSETGO3_150
		BRA	UNTSETGO3_100
;
UNTSETGO3_200	EQU	$
		LDA	<WORKE
		PHA
		LDA	<WORK1E
		PHA
		MI8			; memory , index 8bit mode
		JSL	>UNITST0	; unit buffer set
		MI16			; memory , index 16bit mode
		PLA
		STA	<WORK1E
		PLA
		BPL	UNTSETGO3_900
		JSR	SETGO_ERR	; G[ Zbg!!
UNTSETGO3_900	EQU	$
		RTS
;
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	p^[ Zbg GO !!			+
;+				(ꂾ)	+
;++++++++++++++++++++++++++++++++++++++++++++++++
PTNSETGO0	EQU	$
		LDA	<WORK10
		STA	<WORK1A
		JSR	PTNPOSCHK	; p^[ |Cg `FbN
		JSR	PTNSETGO_SB	; p^[ f[^ Zbg
		LDA	<WORKE
		PHA
		LDA	<WORK1E
		PHA
		MI8			; memory , index 8bit mode
		JSL	>UNITST0	; unit buffer set
		MI16			; memory , index 16bit mode
		PLA
		STA	<WORK1E
		PLA
		BEQ	PTNSETGO0_100
		JSR	SETGO_ERR	; G[ Zbg!!
PTNSETGO0_100	EQU	$
		RTS
;
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	p^[ Zbg GO !!			+
;+				(ȑO)		+
;++++++++++++++++++++++++++++++++++++++++++++++++
PTNSETGO1	EQU	$
		LDA	<WORK10
		STA	<WORK1A
PTNSETGO1_100	EQU	$
		JSR	PTNPOSCHK	; p^[ |Cg `FbN
		JSR	PTNSETGO_SB	; p^[ f[^ Zbg
		LDA	<WORKE
		BNE	PTNSETGO1_200
		LDA	<WORK1A
		BEQ	PTNSETGO1_200
		DEC	<WORK1A
		BRA	PTNSETGO1_100
;
PTNSETGO1_200	EQU	$
		LDA	<WORKE
		PHA
		LDA	<WORK1E
		PHA
		MI8			; memory , index 8bit mode
		JSL	>UNITST0	; unit buffer set
		MI16			; memory , index 16bit mode
		PLA
		STA	<WORK1E
		PLA
		BEQ	PTNSETGO1_900
		JSR	SETGO_ERR	; G[ Zbg!!
PTNSETGO1_900	EQU	$
		RTS
;
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	p^[ Zbg GO !!			+
;+				(ȍ~)		+
;++++++++++++++++++++++++++++++++++++++++++++++++
PTNSETGO2	EQU	$
		LDA	<WORK10
		STA	<WORK1A
		JSR	PTNPOSCHK	; p^[ |Cg `FbN
PTNSETGO2_100	EQU	$
		JSR	PTNSETGO_SB	; p^[ f[^ Zbg
		INC	<WORK1A
		JSR	PTNPOSCHK	; p^[ |Cg `FbN
		LDX	<WORK1E
		LDA	>DTBUFF,X
		AND	#000FFH
		CMP	#000FFH
		BEQ	PTNSETGO2_200
		LDA	<WORKE
		BEQ	PTNSETGO2_100
PTNSETGO2_200	EQU	$
		LDA	<WORKE
		PHA
		LDA	<WORK1E
		PHA
		MI8			; memory , index 8bit mode
		JSL	>UNITST0	; unit buffer set
		MI16			; memory , index 16bit mode
		PLA
		STA	<WORK1E
		PLA
		BEQ	PTNSETGO2_900
		JSR	SETGO_ERR	; G[ Zbg!!
PTNSETGO2_900	EQU	$
		RTS
;
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	p^[ Zbg GO !!			+
;+				(``܂)	+
;++++++++++++++++++++++++++++++++++++++++++++++++
PTNSETGO3	EQU	$
		LDA	<WORK10
		STA	<WORK1A
		JSR	PTNPOSCHK	; p^[ |Cg `FbN
PTNSETGO3_100	EQU	$
		JSR	PTNSETGO_SB	; p^[ f[^ Zbg
		INC	<WORK1A
		JSR	PTNPOSCHK	; p^[ |Cg `FbN
		LDA	<WORKE
		BNE	PTNSETGO3_200
		LDA	!STUNTNO1
		AND	#000FFH
		CMP	<WORK1A
		BCS	PTNSETGO3_100
PTNSETGO3_200	EQU	$
		LDA	<WORKE
		PHA
		LDA	<WORK1E
		PHA
		MI8			; memory , index 8bit mode
		JSL	>UNITST0	; unit buffer set
		MI16			; memory , index 16bit mode
		PLA
		STA	<WORK1E
		PLA
		BEQ	PTNSETGO3_900
		JSR	SETGO_ERR	; G[ Zbg!!
PTNSETGO3_900	EQU	$
		RTS
;
;
;++++++++++++++++++++++++++++++++++++++++
;+	jbg NO.			+
;+		|Cg `FbN	+
;+			&		+
;+		f[^ Zbg		+
;++++++++++++++++++++++++++++++++++++++++
UNTCHKST	EQU	$
		JSR	UNTPOSCHK	; jbg NO. |Cg `FbN
		LDA	<WORKE
		BNE	UNTCHKST_900
		JSR	UNTSETGO_SB	; jbg NO. f[^ Zbg
		LDA	<WORKE
		BNE	UNTCHKST_900
		LDY	#00004H
		LDX	<WORK1E
		LDA	>DTBUFF,X
		AND	#000FFH		; Œ f[^ ?
		BEQ	UNTCHKST_300	;	YES -> UNTCHKST_300
		CMP	#000FFH		; f[^ Gh ?
		BEQ	UNTCHKST_900	;	YES -> UNTCHKST_900
		TAX
		LDA	>KAHNSB,X
		AND	#0003FH
		TAX
		LDA	KAHNNO,X
		AND	#000FFH
		TAY
UNTCHKST_300	EQU	$
		TYA
		CLC
		ADC	<WORK1E
		STA	<WORK1E
		INC	<WORK1C
		BRA	UNTCHKST
UNTCHKST_900	EQU	$
		RTS
;
;
;++++++++++++++++++++++++++++++++++++++++
;+	jbg NO. |Cg `FbN	+
;+		in			+
;+		work1A,1B <- comper data+
;+		out			+
;+		work1E,1F <- point NO.	+
;++++++++++++++++++++++++++++++++++++++++
UNTPOSCHK	EQU	$
		LDY	#00004H
		LDX	<WORK1E
		LDA	>DTBUFF,X
		AND	#000FFH		; Œ f[^ ?
		BEQ	UNTCHK_200	;	YES -> UNTCHK_200
		CMP	#000FFH		; f[^ Gh ?
		BEQ	UNTCHK_300	;	YES -> UNTCHK_300
		LDA	!KHNKTIMD
		AND	#00001H		; Œ f[^ ړ [h ?
		BEQ	UNTCHK_150	;	YES -> UNTCHK_150
		LDA	>DTBUFF,X
		AND	#000FFH
		CMP	<WORK1A
		BEQ	UNTCHK_900
UNTCHK_150	EQU	$
		PHX
		LDA	>DTBUFF,X
		AND	#000FFH
		TAX
		LDA	>KAHNSB,X
		PLX
		AND	#0003FH
		TAY
		LDA	KAHNNO,Y
		AND	#000FFH
		TAY
UNTCHK_200	EQU	$
		LDA	!KHNKTIMD
		AND	#00001H		;  f[^ ړ [h ?
		BNE	UNTCHK_250	;	YES -> UNTCHK_250
		LDA	>DTBUFF+3,X
		AND	#000FFH
		CMP	<WORK1A
		BEQ	UNTCHK_900
UNTCHK_250	EQU	$
		TYA
		CLC
		ADC	<WORK1E
		STA	<WORK1E
		INC	<WORK1C
		BRA	UNTPOSCHK
UNTCHK_300	EQU	$
		LDA	#00001H
		STA	<WORKE
UNTCHK_900	EQU	$
		RTS
;
;
;++++++++++++++++++++++++++++++++++++++++
;+	X,Y start point set		+
;+		in			+
;+		work0,1 <- start point	+
;+		out			+
;+		workA,B <- X start point+
;+		    C,D <- Y start point+
;++++++++++++++++++++++++++++++++++++++++
XYSTART		EQU	$
		LDA	<WORK0
		XBA
		AND	#00F0FH
		STA	<WORKA
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		ORA	<WORKA
		AND	#000FFH
		STA	<WORKA		; X start point
;
		LDA	<WORK0
		XBA
		AND	#0F0F0H
		STA	<WORKC
		ASL	A
		ASL	A
		ASL	A
		ASL	A
		ORA	<WORKC
		XBA
		AND	#000FFH
		STA	<WORKC		; Y start point
		RTS
;
;
;++++++++++++++++++++++++++++++++++++++++
;+	G[ Zbg			+
;++++++++++++++++++++++++++++++++++++++++
SETGO_ERR	EQU	$
		M8			; memory 8bit mode
		LDA	#040H
		STA	!ERRFLG
		LDA	#001H
		STA	!LASTFG
		LDX	<WORK1E
		LDA	>DTBUFF+1,X
		PHA
		AND	#00FH
		STA	!LASTXP+1
		STA	!CRXPSL1+1
		STA	!CRXPSL2+1
		PLA
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		STA	!LASTYP+1
		STA	!CRYPSL1+1
		STA	!CRYPSL2+1
		LDA	>DTBUFF+2,X
		PHA
		ASL	A
		ASL	A
		ASL	A
		ASL	A
		STA	!LASTXP
		STA	!CRXPSL1
		STA	!CRXPSL2
		PLA
		AND	#0F0H
		STA	!LASTYP
		STA	!CRYPSL1
		STA	!CRYPSL2
		M16			; memory 16bit mode
		LDA	<WORK1E
		STA	!SRCHPT
		JSR	CNTSCST		; cursol center scroll counter set
		JSL	>REDISP
		RTS
;
;
;++++++++++++++++++++++++++++++++++++++++
;+	p^[ |Cg `FbN	+
;+		in			+
;+		work1A,1B <- comper data+
;+		out			+
;+		work1E,1F <- point NO.	+
;++++++++++++++++++++++++++++++++++++++++
PTNPOSCHK	EQU	$
		STZ	<WORK1C
		STZ	<WORK1E
POSCHK_100	EQU	$
		LDA	<WORK1C
		CMP	<WORK1A
		BCS	POSCHK_300
		LDY	#00004H
		LDX	<WORK1E
		LDA	>DTBUFF,X
		AND	#000FFH		; Œ f[^ ?
		BEQ	POSCHK_200	;	YES -> POSCHK_200
		PHX
		TAX
		LDA	>KAHNSB,X
		PLX
		AND	#0003FH
		TAY
		LDA	KAHNNO,Y
		AND	#000FFH
		TAY
POSCHK_200	EQU	$
		TYA
		CLC
		ADC	<WORK1E
		STA	<WORK1E
		INC	<WORK1C
		BRA	POSCHK_100
POSCHK_300	EQU	$
		RTS
;
;
;++++++++++++++++++++++++++++++++++++++++
;+	jbg mn. f[^ Zbg	+
;+	p^[ f[^ Zbg		+
;++++++++++++++++++++++++++++++++++++++++
UNTSETGO_SB	EQU	$
PTNSETGO_SB	EQU	$
		LDX	<WORK1E
		LDA	>DTBUFF+1,X
		STA	<WORK0
		JSR	XYSTART		; X,Y start point set
		LDX	<WORK1E
		LDA	>DTBUFF,X
		AND	#000FFH
		BNE	PTNSETGO_200
		LDA	>DTBUFF+3,X
		AND	#000FFH
		CMP	#000FBH
		BNE	PTNSETGO_050
		JSR	DSP_CP_MV
		JMP	PTNSETGO_900
PTNSETGO_050	EQU	$
		JSR	KOTEI_SB	; Œ f[^ count set
		LDA	<WORKA
		CLC
		ADC	<WORK12
		STA	<WORKA
		LDA	<WORKC
		CLC
		ADC	<WORK14
		STA	<WORKC
		JSR	KOTEI_KAHEN	; Œ  ~bg `FbN
		LDA	<WORKE
		BEQ	PTNSETGO_300
		JMP	PTNSETGO_900
;
;
PTNSETGO_200	EQU	$
		JSR	KAHEN_SB0	;  X^[gf[^ count set
		LDA	<WORKA
		CLC
		ADC	<WORK12
		STA	<WORKA
		LDA	<WORKC
		CLC
		ADC	<WORK14
		STA	<WORKC
		JSR	KOTEI_KAHEN	; Œ  ~bg `FbN
		LDA	<WORKE
		BNE	PTNSETGO_900
;
		JSR	KAHEN_SB1	;  Ghf[^ count set
		JSR	KOTEI_KAHEN	; Œ  ~bg `FbN
		LDA	<WORKE
		BNE	PTNSETGO_900
;
PTNSETGO_300	EQU	$		; Vtg JEg !!
		LDX	<WORK1E
		LDA	!SIFTX
		STA	<WORK0
		BPL	PTNSETGO_310
		EOR	#000FFH
		INC	A
		STA	<WORK0
PTNSETGO_310	EQU	$
		LDA	>DTBUFF+1,X	; X point set
		XBA
		AND	#00F0FH
		STA	<WORK2
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		ORA	<WORK2
		AND	#000FFH
		CLC
		ADC	<WORK0
		AND	#000FFH
		STA	<WORK2
		ASL	A
		ASL	A
		ASL	A
		ASL	A
		ORA	<WORK2
		AND	#00F0FH
		XBA
		STA	<WORK2
;
		LDA	!SIFTY
		STA	<WORK0
		BPL	PTNSETGO_360
		EOR	#000FFH
		INC	A
		STA	<WORK0
PTNSETGO_360	EQU	$
		LDA	>DTBUFF+1,X	; Y point set
		XBA
		AND	#0F0F0H
		STA	<WORK4
		ASL	A
		ASL	A
		ASL	A
		ASL	A
		ORA	<WORK4
		AND	#0FF00H
		XBA
		CLC
		ADC	<WORK0
		XBA
		AND	#0FF00H
		STA	<WORK4
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		ORA	<WORK4
		AND	#0F0F0H
		XBA
		ORA	<WORK2
		STA	>DTBUFF+1,X
;
PTNSETGO_900	EQU	$
		RTS
;
;
;++++++++++++++++++++++++++++++++++++++++
;+	ʃRs[			+
;+		jbgm. ړ	+
;++++++++++++++++++++++++++++++++++++++++
DSP_CP_MV	EQU	$
		LDA	!SIFTX
		BPL	DSP_CP_MV_010
		EOR	#000FFH
		INC	A
DSP_CP_MV_010	EQU	$
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		STA	<WORK0
		LDA	!SIFTX
		AND	#0FF00H
		ORA	<WORK0
		STA	<WORK0
		M8			; memory 8bit mode
		LDA	>DTBUFF+1,X
		CLC
		ADC	<WORK0
		STA	>DTBUFF+1,X
		LDA	>DTBUFF+2,X
		CLC
		ADC	<WORK0
		STA	>DTBUFF+2,X
;
		M16			; memory 16bit mode
		LDA	!SIFTY
		BPL	DSP_CP_MV_110
		EOR	#000FFH
		INC	A
DSP_CP_MV_110	EQU	$
		AND	#0FFF0H
		STA	<WORK0
		M8			; memory 8bit mode
		LDA	>DTBUFF+1,X
		CLC
		ADC	<WORK0
		STA	>DTBUFF+1,X
		LDA	>DTBUFF+2,X
		CLC
		ADC	<WORK0
		STA	>DTBUFF+2,X
		M16			; memory 16bit mode
;
DSP_CP_MV_900	EQU	$
		STZ	<WORKE
		RTS
		MEM8
		IDX8
;
;
;****************************************************************
;*								*
;*	N_ |Cg ʕ\p obt@ Zbg [`	*
;*								*
;****************************************************************
		MEM8
		IDX8
STRTBFST	EQU	$
		PHA
		PHB
		LDA	#BANK ENBGDTBF
		PHA
		PLB
		M16			; memory 16bit mode
;
		LDA	(<XYPOINT)
		INC	A
		STA	(<XYPOINT)
;;;;K;;;;		LDA	(<WORK2)
;;;;K;;;;		INC	A
;;;;K;;;;		STA	(<WORK2)
;
		M8			; memory 8bit mode
		PLB
		PLA
		RTL
;
;
;****************************************************************
;*								*
;*	}EX _uNbN CjV `FbN		*
;*								*
;****************************************************************
MUSDBLINT	EQU	$
		STZ	!MUSEBUF
		LDA	!MOUSEBT
		AND	#10000000B	;}EX E nm ?
		BEQ	MUSDBLINT_900	;	NO -> MUSDBLINT_900
		LDA	#010H
		STA	!MUSEBUF
;
MUSDBLINT_900	EQU	$
		RTS
;
UNDR_ITCOL	EQU	$
		LDA	!MUSEBUF
		BNE	UNDR_ITCOL_PAS
		JSR	MUSDBLINT
UNDR_ITCOL_PAS	EQU	$
		RTL
;
;
;****************************************************************
;*								*
;*		}EX _uNbN `FbN			*
;*								*
;****************************************************************
MUSDBL		EQU	$
		DEC	!MUSEBUF
		BEQ	MUSDBL_900
		LDA	!MOUSEBT
		AND	#10000000B	;}EX E nm ?
		BEQ	MUSDBL_900	;	NO -> MUSDBL_900
		LDA	#MSSC
		STA	!MODENO
		STZ	!WIDEX
		STZ	!WIDEY
		LDX	!SIFTFG
		LDA	#080H
		STA	!CRXPSL1,X
		LDA	#060H
		STA	!CRYPSL1,X
		M16			; memory 16bit mode
		LDA	!CRXPSL1,X
		STA	!MSSCRX
		LDA	!CRYPSL1,X
		STA	!MSSCRY
		M8			; memory 8bit mode
MUSDBL_900	EQU	$
		RTS
;
UNDR_COL	EQU	$
		LDA	!MUSEBUF
		BEQ	UNDR_COL_PAS
		JSR	MUSDBL
UNDR_COL_PAS	EQU	$
		RTL
;
;
;********************************************************
;*		tmcn				*
;********************************************************
UNDO_GO		EQU	$
		PHP
		PHB
		PHK
		PLB
		M8			; memory 8bit mode
		I16			; index 16bit mode
;
		LDX	!UNDONO		; undo OK ?
		BEQ	UNDO_GO_990	;	NO -> UNDO_GO_990
;
UNDO_GO_LOOP	EQU	$
		LDA	>UNDOBUF-1,X
		STA	>DTBUFF-1,X
		DEX
		BNE	UNDO_GO_LOOP
;
UNDO_GO_990	EQU	$
		LDX	#00000
		STX	!UNDONO
		PLB
		PLP
		RTL
;
		MEM8
		IDX8
;
;
;****************************************************************
;*		_~[ !!					*
;****************************************************************
BS_SCRE EQU	00000H
TMUP	EQU	00000H
D_00	EQU	00000H
INT_STAT	EQU	00000H
STT_PL_GO	EQU	00000H
HMPIN	EQU	00000H
STT_PL_STP	EQU	00000H
;
M_HEIIN EQU	$
M_ATKIN EQU	$
M_HEIMV EQU	$
M_ATKMV EQU	$
M_HAZIN EQU	$
M_HAZMV EQU	$
M_LIFIN EQU	$
M_LIFMV EQU	$
M_ETRIN EQU	$
M_TH1IN EQU	$
M_ETRMV EQU	$
M_FUSIN EQU	$
M_TH1MV EQU	$
M_FUSMV EQU	$
M_MISIN EQU	$
M_MISMV EQU	$
M_TAMIN EQU	$
M_HZKMV EQU	$
M_TAMMV EQU	$
M_THOIN EQU	$
M_THOMV EQU	$
M_PTRIN EQU	$
M_PTRMV EQU	$
M_SUIIN EQU	$
M_SUIMV EQU	$
M_BAKIN EQU	$
M_BAKMV EQU	$
M_DR0IN EQU	$
M_DR1IN EQU	$
M_BBYIN EQU	$
M_DR2IN EQU	$
M_DR3IN EQU	$
M_DR4IN EQU	$
M_DR0MV EQU	$
M_DR5IN EQU	$
M_DR1MV EQU	$
M_BBYMV EQU	$
M_EGGIN EQU	$
M_DR2MV EQU	$
M_DR3MV EQU	$
M_DR4MV EQU	$
M_ATAIN EQU	$
M_DR5MV EQU	$
M_EGGMV EQU	$
M_ATAMV EQU	$
BGM_SET EQU	$
BOSSQ_MD7_SET	EQU	$
EGG_SAVE	EQU	$
EGG_LOAD	EQU	$
MHDPLY_JSL	EQU	$
M_ITMIN		EQU	$
M_ITMMV		EQU	$
		RTL
;
		MEM8
		IDX8
;
;
;
;
		END
