;************************************************************************
;*									*
;*	title name	: "yossy tool"					*
;*	proccess	: initial process				*
;*	file name	: yst_init					*
;*									*
;************************************************************************
;
;
		SALL
;
		include		yst_header.inc
;
		XALL
;
;
;------------------------------------------------------------------------
;
;		Super_Y edit-tool		1992.03.05(THU)
;
;------------------------------------------------------------------------
;
;
;=============================================== (syt_init) =============
		GLB	BGWTPL,BGWRITE,BGSET,UNITST,BGINT
		GLB	ENWTPL,ENBGSLC
		GLB	ITMD,PLMD,MDSL,BGWR,ERR0,DTSV,DTLD,DTDS,UPSL,DWSL
		GLB	LFSL,RISL,BGDS,STIN,MFRM,DTDL,GAME
		GLB	MSSC,ITSB,PSST,ALMV,DSPCP
		GLB	ENPLMD,ENMDSL,ENFILE
		GLB	FPSV,FPLD,FPDL,ENFILE,ENFMD,FLNM,FPFT,MSTST,ENITSB
		GLB	BGDISP,BGMV
;
		GLB	GMIN,MPIN
;
;=============================================== (syt_main) =============
		EXT	JSRSUB,JSLSUB,JSRSUBL,OAMCLR2,BLNKOF2,KYREAD
		EXT	FADEST,DMA_M_M
;=============================================== (yst_rpro) =============
		EXT	VRAMCL,BGSCWTL,NEWVMADL,VMADSPL
;=============================================== (syt_edit) =============
		EXT	PLAY,MODESL,ERROR,WNDWST
		EXT	MSSCRMD,PLPSST
		EXT	PLY510
		EXT	STRTBFST,ALLMOVE,DSPCOPYMD,BGDTMOVE
;=============================================== (syt_dmap) =============
		EXT	DTDISP
;=============================================== (syt_stat) =============
		EXT	STATIN
;=============================================== (syt_svld) =============
		EXT	FORMAT,DTSAVE,DTLOAD,DTDEL
;=============================================== (yst_bgsc0) ============
		EXT	KOTEISB,KAHENSB
		EXT	KAHNSB
;=============================================== (ys_unit) ==============
		EXT	UNDTADD,UNDATA
;=============================================== (ys_init) =============
		EXT	GMCHRST,GMCOLST,RUTSET
;=============================================== (yst_game) ============
		EXT	GMINIT,GMPLAY,GMFADE,GMGOAL
;=============================================== (yst_en_edit) =========
		EXT	ENPLAY,PLDWNMN
		EXT	MSTEST
		EXT	ENALLCLS
;=============================================== (yst_en_file) =========
		EXT	ENFLINT,ENFLMD
		EXT	FLPYSV,FLPYLD,FLPYDL,FLNMDSP
		EXT	FLPYFT
		EXT	BGENINT,BGENSL,BGENFD
		EXT	ENBFST
		EXT	ENBFCLS
;=============================================== (yst_bgsc) =============
		EXT	BG3SCK
;========================================================================
;
;
;
;************************************************************************
;*									*
;*		program start						*
;*									*
;************************************************************************
;
;
		EXTEND
;
;
		MEM8
		IDX8
;
Group_17	GROUP	Init_pro
Init_pro	SECT	REL
;
;
;************************************************************************
;*		Initial - 1				(INIT1)		*
;************************************************************************
BGWTPL		EQU	$
		LDA	MODENO
		CMP	#GMIN
		BCS	BGWP010
;
		JSL	>KYREAD		; key-board read
;
		JSL	>OAMCLR2
		LDA	MODENO
BGWP010		EQU	$
		JSL	>JSRSUBL
		LWORD	INIT		;00
		LWORD	PLAY		;01
		LWORD	MODESL		;02
		LWORD	BGWRITE		;03
		LWORD	ERROR		;04
		LWORD	DTSAVE		;05
		LWORD	DTLOAD		;06
		LWORD	DTDISP		;07
		LWORD	UPSCRL		;08
		LWORD	DWSCRL		;09
		LWORD	LFSCRL		;0A
		LWORD	RISCRL		;0B
		LWORD	BGDISP		;0C
		LWORD	STATIN		;0D
		LWORD	FORMAT		;0E
		LWORD	DTDEL		;0F
;
		LWORD	MSSCRMD		;10
		LWORD	ALLMOVE		;11
		LWORD	DSPCOPYMD	;12
		LWORD	RTLSUB		;13
		LWORD	RTLSUB		;14
;
		LWORD	RTLSUB		;15
;
		LWORD	INIT		;16
		LWORD	PLPSST		;17 player pos set
GMINT		LWORD	FADEST		;18
		LWORD	GMINIT		;19
		LWORD	GMFADE		;1A
		LWORD	GMPLAY		;1B
		LWORD	GMGOAL		;1C S[
;
;
ITMD		EQU	000H
PLMD		EQU	ITMD+1	;001H
MDSL		EQU	PLMD+1	;002H
BGWR		EQU	MDSL+1	;003H
ERR0		EQU	BGWR+1	;004H
DTSV		EQU	ERR0+1	;005H
DTLD		EQU	DTSV+1	;006H
DTDS		EQU	DTLD+1	;007H
UPSL		EQU	DTDS+1	;008H
DWSL		EQU	UPSL+1	;009H
LFSL		EQU	DWSL+1	;00AH
RISL		EQU	LFSL+1	;00BH
BGDS		EQU	RISL+1	;00CH
STIN		EQU	BGDS+1	;00DH
MFRM		EQU	STIN+1	;00EH
DTDL		EQU	MFRM+1	;00FH
;
MSSC		EQU	DTDL+1	;010H
ALMV		EQU	MSSC+1	;011H
DSPCP		EQU	ALMV+1	;012H
;
ITSB		EQU	016H
PSST		EQU	017H
GAME		EQU	018H
GMIN		EQU	GAME
MPIN		EQU	ITMD
;
;
;------------------------------------------------------------------------
;-		dummy							-
;------------------------------------------------------------------------
RTLSUB		EQU	$
		RTL
;
;
;-------------- chikei name character address ---------------------------
CHIKCHR		EQU	$		;[BG1TYP]
		WORD	15C000H		;[0]
		WORD	15C000H+0200H	;[1]
		WORD	15C000H+0400H	;[2]
		WORD	15C000H+0600H	;[3]
		WORD	15C000H+0800H	;[4]
		WORD	15C000H+0A00H	;[5]
		WORD	15C000H+0C00H	;[6]
		WORD	15C000H+0E00H	;[7]
		WORD	15C000H		;[8]
		WORD	15C000H+0200H	;[9]
		WORD	15C000H+0400H	;[A]
		WORD	15C000H+0600H	;[B]
		WORD	15C000H+0800H	;[C]
		WORD	15C000H+0A00H	;[D]
		WORD	15C000H+0C00H	;[E]
		WORD	15C000H+0E00H	;[F]
;
;
ENWTPL		EQU	$
		LDA	MODENO
		CMP	#GMIN
		BCS	ENWP010
;
		JSL	>KYREAD		; key-board read
;
		JSL	>OAMCLR2
		LDA	MODENO
ENWP010		EQU	$
		JSL	>JSRSUBL
		LWORD	ENINIT		;00
		LWORD	ENPLAY		;01 enmy data set
		LWORD	PLDWNMN		;02
		LWORD	BGWRITE		;03
		LWORD	ERROR		;04
		LWORD	FLPYSV		;05
		LWORD	FLPYLD		;06
		LWORD	DTDISP		;07
		LWORD	UPSCRL		;08
		LWORD	DWSCRL		;09
		LWORD	LFSCRL		;0A
		LWORD	RISCRL		;0B
		LWORD	BGDISP		;0C
		LWORD	STATIN		;0D
		LWORD	FLNMDSP		;0E
		LWORD	FLPYDL		;0F
;
		LWORD	MSSCRMD		;10
		LWORD	ENFLINT		;11 enmy file mode initial
		LWORD	ENFLMD		;12 enmy file mode
		LWORD	FLPYFT		;13
		LWORD	ENALLCLS	;14
		LWORD	BGDTMOVE	;15
		LWORD	ENINITSB	;16
		LWORD	PLPSST		;17 player pos set
		LWORD	FADEST		;18
		LWORD	GMINIT		;19
		LWORD	GMFADE		;1A
		LWORD	GMPLAY		;1B
		LWORD	GMGOAL		;1C S[
;
;
ENPLMD		EQU	001H
ENMDSL		EQU	ENPLMD+1	;002H
FPSV		EQU	005H
FPLD		EQU	FPSV+1		;006H
FLNM		EQU	00EH
FPDL		EQU	FLNM+1		;00FH
;
ENFILE		EQU	011H
ENFMD		EQU	ENFILE+1	;012H
FPFT		EQU	ENFMD+1		;013H
MSTST		EQU	FPFT+1		;014H
BGMV		EQU	MSTST+1		;015H
ENITSB		EQU	BGMV+1		;016H
;
;
ENBGSLC		EQU	$
		JSL	>KYREAD		; key-board read
;
		LDA	MODENO
		JSL	>JSRSUBL
		LWORD	BGENINT		; BG or enmy data set tool select initial
		LWORD	BGENSL		; select
		LWORD	BGENFD
;
;
ENINIT		EQU	$
		LDA	#00000H
		STA	!ALL_UDFG
		STA	>ENMYDTBF
		STA	!ENDTPT
		DEC	A
		STA	>ENDTBF
ENINITSB	EQU	$
		JSL	>INIT
		JSL	>ENBFST
		RTL
;
;
;
;
INIT		EQU	$
		JSL	>VRAMCL		; VRAM clear!!
;
		LDA	#PLMD
		STA	!MODENO
;;;;K;;;;		INC	MODENO	       ;go to next mode !!
;
;-------------- NMI,IRQ type no. set ------------------------------------
		STZ	NMITYP
		STZ	IRQTYP
;
;-------------- SFX-DOS start -------------------------------------------
		DOS	_DOSRST
;
;-------------- BG unit set --------------------------------------------
		JSL	>PLY510
		JSL	>UNITST
;
;-------------- course BG initial set -----------------------------------
INIT1000	EQU	$
;;;;K;;;;;
;;;;K;;;;;-------------- RC̕\`FbNp --------------------------------
;;;;K;;;;		LDX	#(SV_COIN_BF1-SV_COIN_BF0)/2-2
;;;;K;;;;INIT1005	EQU	$
;;;;K;;;;		STZ	!SV_COIN_BF0+000H,X
;;;;K;;;;		STZ	!SV_COIN_BF0+040H,X
;;;;K;;;;		STZ	!SV_COIN_BF1+000H,X
;;;;K;;;;		STZ	!SV_COIN_BF1+040H,X
;;;;K;;;;		STZ	!SV_COIN_BF2+000H,X
;;;;K;;;;		STZ	!SV_COIN_BF2+040H,X
;;;;K;;;;		STZ	!SV_COIN_BF3+000H,X
;;;;K;;;;		STZ	!SV_COIN_BF3+040H,X
;;;;K;;;;		DEX
;;;;K;;;;		DEX
;;;;K;;;;		BPL	INIT1005
;
;---------------  OBJ mode initial set	---------------------------------
		LDA	#00000010B
		STA	2101H
;
;---------------  BG. mode initial set	---------------------------------
		STZ	2133H		; BG. initial (Vsize = 244)
		LDA	#00011001B
		STA	2105H		; BG mode<1> set
		STZ	2106H		; mozaiku reset!!
;
		LDA	#038H
		STA	2107H		; BG1 screen data set
		LDA	#069H
		STA	2108H		; BG2
		LDA	#034H
		STA	2109H		; BG3
		LDA	#038H
		STA	210AH		; BG4
;
		LDA	#01110001B
		STA	210BH		; BG.1,2 character address set
		LDA	#00100010B
		STA	210CH		; BG.3,4 character address set
;
;---------------  Window parameter set	---------------------------------
		STZ	212EH		; window select	 (main)
		STZ	212FH		;	 "       (sub)
;
		STZ	2123H		; window (BG2:off , BG1:off)
		STZ	2124H		;	 (BG4:off , BG3:off)
		STZ	2125H		;	 (CL:off  , OBJ:off)
;
		STZ	212AH		; window masuku set (OR mode)
		STZ	212BH
;
;-------------- game color set ------------------------------------------
;
INIT_450	EQU	$
		JSL	>GMCOLST	;game color set
;
INIT_460	EQU	$
		STZ	2121H		;CGRAM address set
;
		M16
		LDA	#07FFFH
		STA	>DATACOL+2
;
		LDA	#00000000B+(22H*100H)	;DMA parameter & B bus address
		STA	4300H
		LDA	#DATACOL		;A bus address(L,H)
		STA	4302H
		LDY	#BANK DATACOL		;	"     (B)
		STY	4304H
		LDA	#0100H			;number of byte
		STA	4305H
		LDX	#00000001B
		STX	420BH			;DMA "ON"
;
		M8
;
		LDA	!ENBGFLG
		BNE	INIT_500
		JSL	>ENBFST
;
;-------------- BG curse data initial write -----------------------------
INIT_500	EQU	$
		JSL	>BGINT
;
		M16
;
		LDA	!T_TIMER
		STA	!TIMER
		LDA	#00009
		STA	!TIMER_HI
		STA	!TIMER_MID
		STA	!TIMER_LOW
;
		LDA	<SCCH1
		STA	<SCCH3
		STA	<SCCH2
;
		LDA	<SCCV1
		STA	<SCCV3
		STA	<SCCV2
;
		M8
;
;-------------- game character set --------------------------------------
INIT_520	EQU	$
		JSL	>GMCHRST	;game character set
;
;------------------------------------------------------------------------
;-		tool initial set					-
;------------------------------------------------------------------------
;
;-------------- OBJ color set -----------------------------------
INIT_540	EQU	$
		LDA	#080H			;CGRAM address set
		STA	2121H
;
		M16
;
		LDA	#00000000B+(22H*100H)	;DMA parameter & B bus address
		STA	4300H
		LDA	#14C000H		;A bus address(L,H)
		STA	4302H
		LDY	#BANK 14C000H		;	"     (B)
		STY	4304H
		LDA	#0100H			;number of byte
		STA	4305H
		LDX	#00000001B
		STX	420BH			;DMA "ON"
;
;-------------- BG2 character set -------------------------------
		LDA	#10000000B	;inc mode
		STA	2115H
;
		M16			; memory 16bit mode
;
		LDA	#1800H
		STA	2116H		; VRAM address set
		LDA	#00000001B+(18H*100H)
		STA	4300H		; parameter & B bus address
		LDA	#169000H
		STA	4302H		; A bus address (L,H)
		LDY	#BANK 169000H
		STY	4304H		;		(B)
		LDA	#00800H
		STA	4305H		; number of byte
		STX	420BH
;
		M8			; memory 8bit mode
;
;-------------- BG3 character set -------------------------------
		LDA	#10000000B	;inc mode
		STA	2115H
;
		M16
;
		LDA	#2000H
		STA	2116H		; VRAM address set
		LDA	#00000001B+(18H*100H)
		STA	4300H		; parameter & B bus address
		LDA	#148000H
		STA	4302H		; A bus address (L,H)
		LDY	#BANK 148000H
		STY	4304H		;		(B)
		LDA	#2000H
		STA	4305H		; number of byte
		STX	420BH		; DMA "on"
;
		STZ	NUKCOL		;constant color set
;
;-------------- BG3 screen set ----------------------------------
		LDA	#3400H
		STA	2116H		; VRAM address set
		LDA	#14A000H
		STA	4302H		; A bus address (L,H)
		LDY	#BANK 14A000H
		STY	4304H		;		(B)
		LDA	#0800H
		STA	4305H		; number of byte
		STX	420BH		; DMA "on"
;
;-------------- OBJ character set -------------------------------
		LDA	#4000H		;VRAM address set
		STA	2116H
		LDA	#158000H	;A bus address(L,H)
		STA	4302H
		LDY	#BANK 158000H	;	"     (B)
		STY	4304H
		LDA	#4000H		;number of byte
		STA	4305H
		STX	420BH		;DMA "ON"
;
;-------------- chikei name character set -----------------------
		LDA	BG1TYP
		ASL	A
		TAX
		LDA	#4E00H		;VRAM address set
		STA	2116H
		LDA	>CHIKCHR,X	;A bus address(L,H) set
		STA	4302H
		LDY	#BANK 15C000H	;	"     (B) set
		STY	4304H
		LDA	#00C0H		;number of byte set
		TAY
		STA	4305H
		LDX	#00000001B
		STX	420BH
;
		LDA	#4F00H		;VRAM address set
		STA	2116H
		STY	4305H		;number of byte
		STX	420BH
;
		M8
;
;-------------- window set --------------------------------------
		JSL	>WNDWST		; window set
;
		JMP	>BLNKOF2
;
;************************************************************************
;*		 BG. write				(INBGWT1)	*
;************************************************************************
BGWRITE		EQU	$
		JSL	>VRAMCL		; VRAM clear!!
;
		JSL	>INIT1000	;course BG initial set
;
		LDA	#PLMD
		STA	MODENO
;
		JMP	>BLNKOF2
;
;
;
;
;************************************************************************
;*		UP scroll BG. write			(UPSCRL)	*
;************************************************************************
UPSCRL		EQU	$
		MEM16
		REP	#00100000B	; memory 16bit mode
;
		LDA	#00002H
		STA	!SCVMK1
		LDA	#0FFF8H
		BRA	VSCROLL
;
;
;************************************************************************
;*		DOWN scroll BG. write			(DWSCRL)	*
;************************************************************************
DWSCRL		EQU	$
		MEM16
		REP	#00100000B	; memory 16bit mode
;
		STZ	!SCVMK1
		LDA	#00008H
VSCROLL		EQU	$
		STA	<WORK0
		LDX	SIFTFG
		CLC
		ADC	CRYPSL1,X
		STA	CRYPSL1,X
;
		LDA	<SCCV1
		CLC
		ADC	<WORK0
		PHA
		SEC
		SBC	MVSCV1
		STA	<WORK2
		EOR	<WORK0
		ASL	A
		PLA
		BCS	VSCL40		; end ?
;					; yes
		LDA	CRYPSL1,X
		SEC
		SBC	<WORK2
		STA	CRYPSL1,X
		LDA	MVSCV1
		STZ	MVSCV1
		LDX	#PLMD
		STX	MODENO
VSCL40		EQU	$
		STA	<SCCV1
		STA	<SCCV2
		STA	<SCCV3		; scroll count move
;
		MEM8
		SEP	#00100000B	; memory 8bit mode
;
		JMP	>BGSET
;
;
;
;
;************************************************************************
;*		LEFT scroll BG. write			(LFSCRL)	*
;************************************************************************
LFSCRL		EQU	$
		MEM16
		REP	#00100000B	; memory 16bit mode
;
		LDA	#00002H
		STA	!SCHMK1
		LDA	#0FFF8H
		BRA	HSCROLL
;
;
;************************************************************************
;*		RIGHT scroll BG. write			(RISCRL)	*
;************************************************************************
RISCRL		EQU	$
		MEM16
		REP	#00100000B	; memory 16bit mode
;
		STZ	!SCHMK1
		LDA	#00008H
HSCROLL		EQU	$
		STA	<WORK0
		LDX	SIFTFG
		CLC
		ADC	CRXPSL1,X
		STA	CRXPSL1,X
;
		LDA	<SCCH1
		CLC
		ADC	<WORK0
		PHA
		SEC
		SBC	MVSCH1
		STA	<WORK2
		EOR	<WORK0
		ASL	A
		PLA
		BCS	HSCL40		; end ?
;					; yes
		LDA	CRXPSL1,X
		SEC
		SBC	<WORK2
		STA	CRXPSL1,X
		LDA	MVSCH1
		STZ	MVSCH1
		LDX	#PLMD
		STX	MODENO
HSCL40		EQU	$
		STA	<SCCH1
		STA	<SCCH2
		STA	<SCCH3		; scroll count move
;
		MEM8
		SEP	#00100000B	; memory 8bit mode
;
		JMP	>BGSET
;
;
;
;
;************************************************************************
;*		BG intial write						*
;************************************************************************
BGINT		EQU	$
		PHB			;(DBR) save
		PHK			;(DBR) <-- (PBR)
		PLB
;
		STZ	<BGWHF1		;BG write flag reset !!
		STZ	<BGWVF1
		STZ	<SCHMK1		;scroll muki reset !!
;
		MI16
;
;-------------- intial BG write ---------------------------------
		LDA	#16+1		;loop no.
		STA	<BGW_WORK
;
		LDA	<SCCV1
		STA	WRSCV1
		LDA	<SCCH1
		SEC
		SBC	#0100H
		STA	WRSCH1
;
BGIN20		EQU	$
;;;;		    JSR	    BGINT_SUB
		LDX	#00
		STX	<WORK10
		LDA	WRSCH1
		JSR	HWADST
;
;-------------- enemy data BG write set -------------------------
		LDA	MODENO
		CMP	#GAME
		BCS	BGIN22		;game mode ? ( yes:BGIN22 )
;;;;K;;;;		LDA	!ENBGFLG
;;;;K;;;;		AND	#0000FH
;;;;K;;;;		CMP	#00002H
;;;;K;;;;		BEQ	BGIN32
;
		JSR	ENB2HST		; enmy data BG set
		BRA	BGIN24
;
BGIN22		EQU	$
;
		MI8
;
		JSL	>BG3SCK
		JSL	>NEWVMADL
;
BGIN24		EQU	$
;
		MI8

		JSL	>BGSCWTL	;BG screen write
;
		MI16
;
		LDA	WRSCH1
		CLC
		ADC	#0010H
		STA	WRSCH1
		DEC	<BGW_WORK
		BNE	BGIN20
;
;-------------- afQwiXN[Zbg ------------------
		LDA	MODENO
		CMP	#GAME
		BCS	BGIN40		;game mode ? ( yes:BGIN40 )
		JMP	BGIN50
;
;-------------- OafRCgݒ ----------------------
BGIN40		EQU	$
		LDA	BG3TYP
		CMP	#0AH
		BNE	BGIN50		;"mogura course ? ( no:BGIN50 )
;
		PHB			;(DBR) save
		PEA	VRAMD/100H
		PLB
		PLB
;
		LDY	VRAMD
		LDA	#2800H
		STA	VRAMD+2,Y		;VRAM address set
		LDA	#0010000000000000B+(800H-1)
		STA	VRAMD+4,Y		;number of byte & VRAM raed flag set
		LDA	#CHRSVBF
		STA	VRAMD+6,Y		;A bus address(L,H) set
		LDA	#BANK CHRSVBF
		STA	VRAMD+8,Y		;A bus address(B) set
		LDA	#0FFFFH
		STA	VRAMD+9,Y		;end code set
		TYA
		CLC
		ADC	#7
		STA	VRAMD			;next index set
;
		PLB
;
		MI8
;
		JSL	>VMADSPL		;VRAM read !!
;
BGIN50		EQU	$
;
		MI8
;
		PLB
		RTL
;
;************************************************************************
;*		BG screen scroll write set				*
;************************************************************************
;
BGSET		EQU	$
		PHB			;(DBR) save
		PHK			;(DBR) <-- (PBR)
		PLB
;
		MI16
;
;-------------- BG write timming check --------------------------
;
;-------------- H scroll BG write -----------------------
		LDA	<SCCH1
		AND	#0FFF0H
		CMP	WRSCH1
		BEQ	BGST020		;BG change ? ( no:BGST020 )
;
		JSR	HWADST		;H scroll screen data set
;
;-------------- enemy data BG write set c[p -------------------------
		LDA	MODENO
		CMP	#GAME
		BCS	BGST012		;game mode ? ( yes:BGST012 )
		JSR	ENB2HST		; enmy data BG set
;
BGST012		EQU	$
		LDX	<WORK10		;(X) <-- BG type
;
;-------------- V scroll BG write -----------------------
BGST020		EQU	$
		LDA	<SCCV1
		AND	#0FFF0H
		CMP	WRSCV1
		BEQ	BGST030		;BG change ? ( no:BGST030 )
;
		JSR	VWADST		;V scroll screen data set
;
;-------------- enemy data BG write set c[p -------------------------
		LDA	MODENO
		CMP	#GAME
		BCS	BGST030		;game mode ? ( yes:BGST030 )
		JSR	ENB2VST		; enmy data BG set
;
BGST030		EQU	$
;
		MI8
;
		PLB
		RTL
;
;****************************************************************
;*		H scroll BG screen write set			*
;*			in  : (X) <-- BG type [ 0:BG1 4:BG2 ]	*
;*			      (A) <-- H scroll counter		*
;****************************************************************
;
		MEM16
		IDX16
;
BGWPNTH		EQU	$
		WORD	00100H,00000H
;
HWADST		EQU	$
		INC	<BGWHF1		;BG write flag "ON"
;
		STA	WRSCH1
		LDY	<SCHMK1
		CLC
		ADC	!BGWPNTH,Y
		TAY
		AND	#01F0H
		TAX			;(A) save
;
		LSR	A
		LSR	A
		LSR	A
		STA	<WORKA		;(WKA,B) <-- af`FbNpobt@|C^[wʒu
;
		TXA			;(A) load
		BIT	#0100H
		BEQ	HWAS010
;
		EOR	#(0400H<<3)|0100H
HWAS010		EQU	$
		LSR	A
		LSR	A
		LSR	A
		TAX			;(A) save
;;;;		CLC
		ADC	#6800H		;screen base address add
		STA	<BGWAH1_0
		INC	A
		STA	<BGWAH1_1
		TYA
		AND	#0F00H
		XBA
		STA	<WORK
		TXA			;(A) load
		AND	#000FH<<1
		STA	<WORK2
;
		LDA	<SCCV1
		AND	#00F0H
		TAY
;
		ASL	A
		ASL	A		;(A) <-- af`FbNpobt@|C^[xʒu
		TSB	<WORKA		;(WKA,B) <-- af`FbNpobt@|C^[ʒu
;
		TYA
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		PHA			;low set loop no save
		EOR	#000FH
		INC	A
		STA	<WORK6		;(WK6,7) <-- up set loop no.
		TYA
		ASL	A
		STA	<WORKE
		LDA	<SCCV1
		LSR	A
		LSR	A
		TAY
		LSR	A
		LSR	A
		AND	#0700H>>4
		ORA	<WORK
		STA	<WORK4
		TAX
		LDA	UNBUFAD-1,X
		AND	#3F00H
		ASL	A
		ORA	<WORKE
		ORA	<WORK2
		TAX			;(X) <-- unit buffer pointer
;
		TYA
		AND	#00F0H>>2
		TAY			;(Y) <-- chara no. set buffer address
;
		JSR	HWAS20
;
		PLA
		BEQ	HWAS30		;low set ? ( no:HWAS30 )
;
;-------------- hi -> low set -----------------------------------
		STA	<WORK6		;(WK6,7) <-- loop no.
;
		TYA
		AND	#01FH*2
		TAY
;
		LDA	#0FC00H
		TRB	<WORKA
;
		LDA	<WORK4
		CLC
		ADC	#0010H
		AND	#07F0H>>4
		TAX
		LDA	UNBUFAD-1,X
		AND	#3F00H
		ASL	A
		ORA	<WORK2
		TAX
;
;-------------- write buffer set --------------------------------
HWAS20		EQU	$
		PHX			;(X) save
		LDA	>BGUNIT,X
		STA	<WORK0		;jbgm. Z[u
;
		LDX	<WORKA
		STA	>BGCHECK_BUF,X
		TXA
		CLC
		ADC	#(010H*2)*2
		STA	<WORKA
;
		LDA	<WORK1
		AND	#000FFH
		ASL	A
		TAX
		LDA	<WORK0
		AND	#000FFH
		ASL	A
		ASL	A
		ASL	A
;;;;		CLC
		ADC	>UNDTADD,X
		TAX
		LDA	>UNDATA,X
		STA	BGHSCRBF,Y
		LDA	>UNDATA+2,X
		STA	BGHSCRBF+20H*2,Y
		LDA	>UNDATA+4,X
		STA	BGHSCRBF+2,Y
		LDA	>UNDATA+6,X
		STA	BGHSCRBF+20H*2+2,Y
		INY
		INY
		INY
		INY
		PLA			;(X) load
		CLC
		ADC	#0020H
		TAX
		DEC	<WORK6
		BNE	HWAS20
;
HWAS30		EQU	$
		RTS
;
;****************************************************************
;*		V scroll BG screen write set			*
;*			in  : (X) <-- BG type [ 0:BG1 4:BG2 ]	*
;*			      (A) <-- V scroll counter		*
;****************************************************************
BGWPNTV		EQU	$
		WORD	000E0H,00000H
;
VWADST		EQU	$
		INC	<BGWVF1		;BG write flag "ON"
;
		STA	WRSCV1
		LDY	<SCVMK1
		CLC
		ADC	!BGWPNTV,Y
		STA	<BG3WSCV	;BG3 screen write scroll counter_V set
		TAY
		ASL	A
		AND	#00F0H<<1
		STA	<WORK2
		ASL	A
;
		STA	<WORKA		;(WKA,B) <-- af`FbNpobt@|C^[xʒu
;
		STA	<WORK
		TYA
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		AND	#0700H>>4
		STA	<WORK4
;
		LDA	<SCCH1
		LSR	A
		LSR	A
		TAX
		AND	#00F0H>>2
		TAY
		LSR	A
		LSR	A
		STA	<WORK8		;(WK8,9) <-- low set loop no. -1
		EOR	#0FH
		INC	A
		STA	<WORK6		;(WK6,7) <-- hi set loop no.
;
		TYA
		CLC
		ADC	#04H
		STA	<BGWNO1_1	;number of byte 2 set
		TYA
		LSR	A
		STA	<WORKE
		TXA			;(A) load
		LSR	A
		AND	#01F0H>>3
		TAY
;
		TSB	<WORKA		;(WKA,B) <-- af`FbNpobt@|C^[ʒu
;
		TYA
		BIT	#0100H>>3
		BEQ	VWAS10
;
		EOR	#0400H|(0100H>>3)
VWAS10		EQU	$
		ORA	<WORK
		TAX
		CLC
		ADC	#6800H		;screen base address add
		STA	<BGWAV1_00
		CLC
		ADC	#020H
		STA	<BGWAV1_01
		TXA
		EOR	#0400H
		AND	#0FFE0H
		CLC
		ADC	#6800H		;screen base address add
		STA	<BGWAV1_10
		CLC
		ADC	#020H
		STA	<BGWAV1_11
		LDA	#22H*2
		SEC
		SBC	<BGWNO1_1
		STA	<BGWNO1_0	;number of byte 1 set
		LDY	#BGVSCRBF	;(Y) <-- chara no. set buffer address
		LDA	<SCCH1+1
		AND	#000FH
		PHA			;(A) save
		ORA	<WORK4
		TAX
		LDA	UNBUFAD-1,X
		AND	#3F00H
		ASL	A
		ORA	<WORKE
		ORA	<WORK2
		TAX
;
		JSR	VWAS20
;
;-------------- hi -> low set -----------------------------------
		LDX	<WORK8
		INX
		STX	<WORK6		;(WK6,7) <-- loop no.
;
		LDA	<WORKA
		BIT	#01FH<<1
		BNE	VWAS12
		SEC
		SBC	#020H<<1
		STA	<WORKA
VWAS12		EQU	$
;
		PLA			;(A) load
		INC	A
		AND	#000FH
		ORA	<WORK4
		TAX
		LDA	UNBUFAD-1,X
		AND	#3F00H
		ASL	A
		ORA	<WORK2
		TAX
;
;-------------- write buffer set --------------------------------
VWAS20		EQU	$
		PHX			;(X) save
		LDA	>BGUNIT,X
;
		LDX	<WORKA
		STA	>BGCHECK_BUF,X
		INX
		INX
		STX	<WORKA
;
		TAX
		AND	#0FF00H
		XBA
		ASL	A
		PHA			;(A) save
		TXA
		AND	#00FFH
		ASL	A
		ASL	A
		ASL	A
		PLX			;(A) load
;;;;		CLC
		ADC	>UNDTADD,X
		TAX
		LDA	>UNDATA,X
		STA	0,Y
		LDA	>UNDATA+2,X
		STA	2,Y
		LDA	>UNDATA+4,X
		STA	22H*2,Y
		LDA	>UNDATA+6,X
		STA	22H*2+2,Y
		INY
		INY
		INY
		INY
		PLX
		INX
		INX
		DEC	<WORK6
		BNE	VWAS20
		RTS
;
		MEM8
		IDX8
;
;
;
;********************************************************
;*	enmy data BG set				*
;*	H scroll BG screen write VRAM address set	*
;********************************************************
;
		MEM16
		IDX16
;
ENB2HST		EQU	$
		PHB
		PHK
		PLB
;
		LDA	<SCHMK1
		AND	#00002H
		TAX
		LDA	WRSCH1
		CLC
		ADC	>BGWPNTH,X
		TAX
		AND	#001F0H
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		ORA	#03800H		; BG2 screen address [ 3800H- ]
		STA	!B2WTADH
;
		LDA	<SCCV1
		SEC
		SBC	#00020H
		AND	#0FFF0H
		TAY
		JSR	B2ENBFAD	; enmy data buffer address set
		LDA	<WORK0
		LSR	A
		LSR	A
		LSR	A
		AND	#0001EH
		STA	<WORK4
		LDA	<WORK0
		XBA
		AND	#00010H
		ASL	A
		EOR	<WORK4
		TAY			; buffer index set
;
		LDA	#020H		;(WK6,7) <-- loop no.
		STA	<WORK+6
;
ENB2H00		EQU	$
		LDX	#00482H
		M8			; memory 8bit mode
		LDA	[<WORK0]
;;;;K;;;;		AND	#000FFH
		BEQ	ENB2H10
		LDX	#02480H
ENB2H10		EQU	$
		M16			; memory 16bit mode
		TXA
		STA	!B2ENWTH,Y
		DEC	<WORK+6
		BEQ	ENB2H30		;end ? ( yes:ENB2H30 )
;
		INY
		INY
		TYA
		AND	#0003EH
		TAY
		LDA	<WORK0
		CLC
		ADC	#00010H
		AND	#07FFFH
		STA	<WORK0
		AND	#000F0H		; high inc ?
		BNE	ENB2H00		;	NO -> ENB2H00
		LDA	<WORK0		; next page
		SEC			;  enmy data buffer address set
		SBC	#00100H
		CLC
		ADC	#01000H
		AND	#07FFFH
		STA	<WORK0
		BRA	ENB2H00
;
ENB2H30		EQU	$
		INC	B2WTHF	       ;BG2 write flag "ON"
		PLB
		RTS
;
;
;********************************************************
;*	enmy data BG set				*
;*	V scroll BG screen write VRAM address set	*
;********************************************************
ENB2VST		EQU	$
		PHB
		PHK
		PLB
;
		LDA	<SCVMK1
		AND	#00002H
		TAX
		LDA	WRSCV1
		CLC
		ADC	>BGWPNTV,X
		TAY
		ASL	A
		AND	#003E0H
		ORA	#03800H		; BG2 screen address [ 7C00H- ]
		STA	!B2WTADV
;
		LDA	<SCCH1
		SEC
		SBC	#00020H
		AND	#0FFF0H
		TAX
		JSR	B2ENBFAD	; enmy data buffer address set
		LDA	<WORK0
		ASL	A
		AND	#0001EH
		STA	<WORK4
		LDA	<WORK0
		AND	#00100H
		LSR	A
		LSR	A
		LSR	A
		EOR	<WORK4
		TAY			; buffer index set
;
		LDA	#020H		;(WK6,7) <-- loop no.
		STA	<WORK+6
;
ENB2V00		EQU	$
		LDX	#00482H
		M8			; memory 8bit mode
		LDA	[<WORK0]
;;;;K;;;;		AND	#000FFH
		BEQ	ENB2V10
		LDX	#02480H
ENB2V10		EQU	$
		M16			; memory 16bit mode
		TXA
		STA	!B2ENWTV,Y
		DEC	<WORK+6
		BEQ	ENB2V30		;end ? ( yes:ENB2V30 )
;
		INY
		INY
		TYA
		AND	#0003EH
		TAY
		LDA	<WORK0
		AND	#0F000H
		STA	<WORK4
		INC	<WORK0
		LDA	<WORK0		; high inc ?
		AND	#0000FH		;	NO -> ENB2V00
		BNE	ENB2V00
		LDA	<WORK0		; next page
		SEC			;  enmy data buffer address set
		SBC	#00010H
		CLC
		ADC	#00100H
		AND	#00FFFH
		ORA	<WORK4
		STA	<WORK0
		BRA	ENB2V00
;
ENB2V30		EQU	$
		INC	B2WTVF	       ;BG2 write flag "ON"
		PLB
		RTS
;
;
;********************************************************
;*	enmy data buffer address set			*
;*			      in			*
;*				scch -> X		*
;*				sccv -> Y		*
;*			      out			*
;*				work2 <- bank		*
;*				work1 <- high		*
;*				work0 <- low		*
;********************************************************
B2ENBFAD	EQU	$
		STZ	<WORK0
		TYA
		AND	#00700H
		ASL	A
		ASL	A
		ASL	A
		ASL	A
		XBA
		ORA	#ENBGDTBF/100H
		STA	<WORK1
		TXA
		AND	#00F00H
		XBA
		ORA	<WORK1
		STA	<WORK1		; bank & high address set
;
		TYA
		AND	#000F0H
		ORA	<WORK0
		STA	<WORK0
		TXA
		AND	#000F0H
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		ORA	<WORK0
		STA	<WORK0		; high & low address set
		RTS
;
		MEM8
		IDX8
;
;
;
;****************************************************************
;*		unit buffer display				*
;****************************************************************
BGDISP		EQU	$
		STZ	<SCHMK1		;scroll muki reset !!
;
		MI16
;
		PHB			;(DBR) save
		PHK			;(DBR) <-- (PBR)
		PLB
;
		LDA	WRSCH1
		CLC
		ADC	#010H
		LDX	#00
		STX	<WORK10		;(WK10) <-- BG type
		JSR	HWADST		;H scroll BG screen write VRAM address set
;
		LDA	!MODENO
		CMP	#GAME
		BCS	BGDS005
		JSR	ENB2HST
;
BGDS005		EQU	$
		PLB			;(DBR) load
;
		MI8
;
		DEC	BGDPFG
		BNE	BGDS010		;return ? ( no:BGDS010 )
;
;-------------- return set ------------------------------
		LDA	#PLMD		;normal mode set
		STA	MODENO
BGDS010		EQU	$
		RTL
;
;****************************************************************
;*		unit buffer set main				*
;****************************************************************
;
		MEM8
		IDX8
;
UNITST		EQU	$
		PHB			;(DBR) save
;
;-------------- base unit set ---------------------------
		JSL	>RUTSET		;ram unit set
;
;-------------- BG unit buffer clear --------------------
;
		M16			; memory 16bit mode
		PHB
		LDX	#BANK BG2FKN_CP
		PHX
		PLB
;
		LDX	#000H
UNST000_000	EQU	$
		STZ	!BG2FKN_CP,X
		INX
		INX
		CPX	#006H*20
		BCC	UNST000_000
;
		LDX	#BANK BGUNIT
		PHX
		PLB
		I16			; index 16bit mode
		LDX	#(200H*64)
UNST000		EQU	$
		STZ	!BGUNIT-2,X
		DEX
		DEX
		BNE	UNST000
;
		PLB
;
		LDX	#0000EH
UNST001		EQU	$
		STZ	!UNBFSB+000H,X
		STZ	!UNBFSB+010H,X
		STZ	!UNBFSB+020H,X
		STZ	!UNBFSB+030H,X
		DEX
		DEX
		BPL	UNST001
;
		MI8			; memory , index 8bit mode
;
		STZ	!UBFSBCNT
;
		JSL	>ENBFCLS	; strat point buffer clear
;
UNST0015	EQU	$
;;;;K;;;;		LDA	#00
		LDA	#080H
		LDX	#16*8-1
UNST002		EQU	$
		STA	!UNBUFAD,X
		DEX
		BPL	UNST002
		STZ	BGBFPT	       ;buffer pointer clear !!
;
;-------------- BG unit buffer set ----------------------
;
		M16			; memory 16bit mode
;
		LDA	#COURSEDT	;BG course data address set
		STA	<BGDTADR
		LDA	#COURSEDT/100H
		STA	<BGDTADR+1
		LDA	#10		;[+10]
		STA	<BGDTPT		;BG course data pointer set
;
UNTS010		EQU	$
		MI16			; memory , index 16bit mode
		LDA	#00001H
		STA	<XSIZECP
		STA	<YSIZECP
;
		LDY	<BGDTPT
		LDA	[<BGDTADR],Y
		AND	#000FFH
		STA	<STUNTNO
		INY
		LDA	[<BGDTADR],Y
		XBA
		STA	<XYPOINT	; X,Y (L,H) point
		INY
;
		M8			; memory 8bit mode
;
		LDA	<STUNTNO	; Œ or  ?
		BEQ	KOTEISL		;	Œ -> goto KOTEISL
		CMP	#0FFH		;
		BNE	KAHENSL		;	 -> goto KAHENSL
;
		I8			; index 8bit mode
		PLB
		RTL
;
		MEM8
		IDX16
;
;-------------- kotei data -------------------------------
KOTEISL		EQU	$
		LDA	!ENBGFLG
		BEQ	KOTEISL_00
		JSL	>STRTBFST	; N_ |Cg ʕ\p obt@ Zbg [`
KOTEISL_00	EQU	$
		PHK
		PEA	UNTS010-1
;
		LDA	#BANK KOTEISB
		PHA
		PHA
		PLB
;
		INY
		LDA	[<BGDTADR],Y	; unit NO.
		STA	<STUNTNO
		INY
		STY	<BGDTPT
;
		M16			; memory 16bit mode
		AND	#000FFH
		ASL	A
		TAX
;
		LDA	>KOTEISB,X
		PHA
		MI8			; memory , index 8bit mode
		RTL
;
		MEM8
		IDX16
;
;-------------- kahen data -------------------------------
KAHENSL		EQU	$
		LDA	!ENBGFLG
		BEQ	KAHENSL_00
		JSL	>STRTBFST	; N_ |Cg ʕ\p obt@ Zbg [`
KAHENSL_00	EQU	$
		PHK
		PEA	UNTS010-1
;
		M16			; memory 16bit mode
		LDX	<STUNTNO
		LDA	>KAHNSB,X
		AND	#00003H
		CMP	#00001H
		BEQ	KAHEN10
		TAX
;
		INY
		LDA	[<BGDTADR],Y
		STA	<WORKA
		BIT	#00080H
		BEQ	KAHEN05
		LDA	!BG1TYP
		CMP	#00002H		;  ?
		BEQ	KAHEN05		;	YES -> KAHEN05
		LDA	<WORKA
		ORA	#0FF00H
		DEC	A
		BRA	KAHEN08
KAHEN05		EQU	$
		LDA	<WORKA
		AND	#000FFH
		INC	A
KAHEN08		EQU	$
		STA	<XSIZECP	; X size set
		TXA
		BEQ	KAHEN15
;
KAHEN10		EQU	$
		INY
		LDA	[<BGDTADR],Y
		BIT	#00080H
		BEQ	KAHEN13
		ORA	#0FF00H
		DEC	A
		BRA	KAHEN18
KAHEN13		EQU	$
		AND	#000FFH
		INC	A
KAHEN18		EQU	$
		STA	<YSIZECP	; Y size set
KAHEN15		EQU	$
		INY
		STY	<BGDTPT
;
KAHEN20		EQU	$
		LDA	<STUNTNO
		ASL	A
		TAX
		M8			; memory 8bit mode
;
		LDA	#BANK KAHENSB
		PHA
		PHA
		PLB
		LDA	KAHENSB+1,X
		PHA
		LDA	KAHENSB,X
		PHA
		I8			; index 8bit mode
		RTL
;
;
;
		MEM8
		IDX8
;
;
;
;
;
		END
