;************************************************************************
;*									*
;*	title name	: "yossy tool"					*
;*	proccess	: ram name					*
;*	file name	: yst_ram					*
;*									*
;************************************************************************
;
;
		SALL
;
		include		../../../JPN/union/ys_ram.asm
		include		../../../JPN/union/ys_mram.asm
;
		XALL
;
;
;========================================================================
;=		!=0 page RAM						=
;========================================================================
;
;--------------------------------------------------------------------
;		save RAM area					    -
;--------------------------------------------------------------------
SAVECK0		EQU	NMICONT+2	;save RAM check data.1 [35]
;
SAVERM		EQU	SAVECK0+1
;;;;K;;;;;
;;;;K;;;;;-------------- file name buffer --------------------------------
;;;;K;;;;FLNMWK		EQU	TIMERNO+2	; FILE NAME WORK
;;;;K;;;;NMPTWK		EQU	FLNMWK+8	; FILE NAME POINTER WORK
;
;
ENBGFLG		EQU	TIMERNO+2
;
;
;-------------- vC[oʒu ------------------------------
;;;;K;;;;T_PLXPSL	EQU	NMPTWK+2
T_PLXPSL	EQU	ENBGFLG+2
T_PLYPSL	EQU	T_PLXPSL+2
;
;-------------- ZbgafP^Cv --------------------------
T_BG1TYP	EQU	T_PLYPSL+2
T_BG1COL	EQU	T_BG1TYP+2
;
T_TIMER		EQU	T_BG1COL+2
;
SAVERME		EQU	T_TIMER+2
SAVERMN		EQU	SAVERME-SAVERM
;
SAVECK1		EQU	SAVERME		;save RAM check data.2 [53]
;
;
;--------------------------------------------------------------------
;		use OAM name set				    -
;--------------------------------------------------------------------
ARROAM		EQU	OAM		; arrow OAM-0
AR1OAM		EQU	OAM+4*1		;	   -1
LASOAM		EQU	OAM+4*2		; last input data pos
XYPOAM		EQU	OAM+4*16	; x,y-position OAM
SMDOAM		EQU	XYPOAM+4*8	; set mode OAM
UTNOAM		EQU	SMDOAM+4*19	; unit no. OAM
;;;;K;;;;UTNOAM		EQU	SMDOAM+4*15	; unit no. OAM
PTDOAM		EQU	UTNOAM+4*2	; PT & unit no. OAM
MODOAM		EQU	PTDOAM+4*25	; mode OAM
CHCOAM		EQU	MODOAM+4*6
;
DWOAM		EQU	OAM+100H	; window OAM
;
FLOAM		EQU	OAM+140H	; t@C
;
;
;;;;;;;;;; Save,Load mode
CUROAM		EQU	OAM+100H	; cursol OAM
NAMOAM		EQU	OAM+104H	; name OAM
;
;
;--------------------------------------------------------------------
;		tool RAM area					    -
;--------------------------------------------------------------------
TOOL_RAM_START	EQU	STATIC1
;
;-------------- mouse data ------------------------------------------
MOUSEAS		EQU	STATIC1		;MOUSE A KEY
MOUSEAX		EQU	MOUSEAS+1	;MOUSE A X
MOUSEAY		EQU	MOUSEAX+1	;MOUSE A Y
MOUSEBS		EQU	MOUSEAY+1	;MOUSE B KEY
MOUSEBX		EQU	MOUSEBS+1	;MOUSE B X
MOUSEBY		EQU	MOUSEBX+1	;MOUSE B Y
MOUSESPA	EQU	MOUSEBY+1	;MOUSE A SPEED
MOUSESPB	EQU	MOUSESPA+1	;MOUSE A SPEED
MOUSEAT		EQU	MOUSESPB+1	;MOUSE A KEY(TRIGER)
MOUSEAB		EQU	MOUSEAT+1	;MOUSE A KEY(TRIGER WORK)
MOUSEBT		EQU	MOUSEAB+1	;MOUSE B KEY(TRIGER)
MOUSEBB		EQU	MOUSEBT+1	;MOUSE B KEY(TRIGER WORK)
MUSECTX		EQU	MOUSEBB+1	; mouse move check count
MUSECTY		EQU	MUSECTX+1	; mouse move check count
;
MOUSWK0		EQU	MUSECTY		;mouse work RAM
;
MUSEBUF		EQU	MOUSWK0+2	;}EX obt@
;
;-------------- editer ram ------------------------------------------
EDMODE		EQU	MUSEBUF+1	; edit mode flg
DTMODE		EQU	EDMODE+1	; data mode ( 0:kotei !=0:kahen )
;
CRXPSL1		EQU	DTMODE+1	;	hi-y-pos
CRXPSH1		EQU	CRXPSL1+1	; arrow low-x-pos (Base)
CRXPSL2		EQU	CRXPSH1+1	;	hi-y-pos
CRXPSH2		EQU	CRXPSL2+1	;		  (counter)
CRYPSL1		EQU	CRXPSH2+1	; arrow hi-x-pos
CRYPSH1		EQU	CRYPSL1+1	;	low-y-pos (Base)
CRYPSL2		EQU	CRYPSH1+1	; arrow hi-x-pos
CRYPSH2		EQU	CRYPSL2+1	;		  (counter)
;
INKEY		EQU	CRYPSH2+1	; key data
INKEY2		EQU	INKEY+1		;
INKEY3		EQU	INKEY2+1	;
;
MVSCH1		EQU	INKEY3+1	; move SCCH1 counter
MVSCV1		EQU	MVSCH1+2	; move SCCV1 counter
;
BGDPFG		EQU	MVSCV1+2	; BG data display flag
SIFTFG		EQU	BGDPFG+1	; shift mode flag
LDFLG		EQU	SIFTFG+1	; load flag
SVFLG		EQU	LDFLG+1		; save	"
DELFLG		EQU	SVFLG+1		; delete "
MPDSFG		EQU	DELFLG+1	; map display flag
STINFG		EQU	MPDSFG+1
;
ERRFLG		EQU	STINFG+1	; error flag
INDTPT		EQU	ERRFLG+2	; BG data type no. cursol pos
INPBUF		EQU	INDTPT+1	;	"          set buffer
;
STDTPT		EQU	INPBUF+2	; course data pointer
INSTPT		EQU	STDTPT+2	; insert pointer
SRCHPT		EQU	INSTPT+2	; search pointer
SRCHNO		EQU	SRCHPT+2	;    "   data pos
;
DTPT		EQU	SRCHNO+2	; now data pos
;
MODESV		EQU	DTPT+2
;
;-------------- file save & load RAM --------------------------------
NAMEPT		EQU	MODESV+2	; file name buffer pointer
;
FKOSUU		EQU	NAMEPT+1	; FILE kosuu
HNUMCT		EQU	FKOSUU+1	; HI NUMBER COUNTER
LNUMCT		EQU	HNUMCT+2	; LOW NUMBER COUNTER
VHLTP		EQU	LNUMCT+2	; VRAMD HI LOW TOP
VHLLT		EQU	VHLTP+2		; VRAMD HI LOW LAST
NMBBUF		EQU	VHLLT+2		; LOAD NUMBER BUFFER
;;;;K;;;;;
;;;;K;;;;;-------------- file save & load RAM --------------------------------
;;;;K;;;;NAMEPT		EQU	MODESV+2	; file name buffer pointer
;;;;K;;;;NMDTBF0		EQU	NAMEPT+1	;	  "
;;;;K;;;;NMDTBF1		EQU	NMDTBF0+1	;	  "
;;;;K;;;;NMDTBF2		EQU	NMDTBF1+1	;	  "
;;;;K;;;;NMDTBF3		EQU	NMDTBF2+1	;	  "
;;;;K;;;;NMDTBF4		EQU	NMDTBF3+1	;	  "
;;;;K;;;;NMDTBF5		EQU	NMDTBF4+1	;	  "
;;;;K;;;;NMDTBF6		EQU	NMDTBF5+1	;	  "
;;;;K;;;;NMDTBF7		EQU	NMDTBF6+1	;	  "
;;;;K;;;;;
;;;;K;;;;FKOSUU		EQU	NMDTBF7+1	; FILE kosuu
;;;;K;;;;HNUMCT		EQU	FKOSUU+1	; HI NUMBER COUNTER
;;;;K;;;;LNUMCT		EQU	HNUMCT+2	; LOW NUMBER COUNTER
;;;;K;;;;VHLTP		EQU	LNUMCT+2	; VRAMD HI LOW TOP
;;;;K;;;;VHLLT		EQU	VHLTP+2		; VRAMD HI LOW LAST
;;;;K;;;;NMBBUF		EQU	VHLLT+2		; LOAD NUMBER BUFFER
;
;--------------------------------------------------------------------
STATX		EQU	NMBBUF+2	; cursole xpos
STATY		EQU	STATX+2		; cursole ypos
STATCMP		EQU	STATY+2
FRMFLG		EQU	STATCMP+1
DYNFLG		EQU	FRMFLG+1
ERCODE		EQU	DYNFLG+1
;
;--------------------------------------------------------------------
UNDONO		EQU	ERCODE+1	;undo buffer size
UNDOXP1		EQU	UNDONO+2	;  "  save cursol X pos.1
UNDOYP1		EQU	UNDOXP1+2	;	  "       Y   "
UNDOXP2		EQU	UNDOYP1+2	;	  "       X  " .2
UNDOYP2		EQU	UNDOXP2+2	;	  "       Y   "
UNDOSFT		EQU	UNDOYP2+2
;
LASTFG		EQU	UNDOSFT+1	;last input flag
LASTXP		EQU	LASTFG+1	;     "     data start X pos
LASTYP		EQU	LASTXP+2	;	    "          Y  "
;
;-------------- AADA used ram ---------------------------------------
WIDEX		EQU	LASTYP+2	; scroll move X wide
WIDEY		EQU	WIDEX+1		; scroll move Y wide
CRSSMMD		EQU	WIDEY+1		; mouse cursol semi auto mode
;					;	0 -> off
;					;	>0 -> X pos
;					;	<0 -> Y pos
UNTPTNSL	EQU	CRSSMMD+1
STUNTNO0	EQU	UNTPTNSL+1
UTPNMODE	EQU	STUNTNO0+1
STUNTNO1	EQU	UTPNMODE+1
SIFTX		EQU	STUNTNO1+1
SIFTY		EQU	SIFTX+2
KHNKTIMD	EQU	SIFTY+2
;
BAKOKRM		EQU	KHNKTIMD+1
;
XTAIHI		EQU	BAKOKRM+1	; X point ta-i-hi
YTAIHI		EQU	XTAIHI+2
MSSCRX		EQU	YTAIHI+2
MSSCRY		EQU	MSSCRX+2
UNTMVMD		EQU	MSSCRY+2	; jbg ړ [h NO. (p)
BG3CLSFG	EQU	UNTMVMD+1
DSPCPFM		EQU	BG3CLSFG+1
DSPCPTO		EQU	DSPCPFM+1
;
;-------------- AADA used ram (enmy edit tool used ram) -------------
PLDWMNFG	EQU	DSPCPTO+1	; pull down menuw flag
B2WTHF		EQU	PLDWMNFG+1	; BG2 H write flag
B2WTVF		EQU	B2WTHF+2	; BG2 V write flag
ENDELFG		EQU	B2WTVF+2	; delete mode use flag
ENDSPFG		EQU	ENDELFG+1	; search data disp set flag
ENMDOBJ		EQU	ENDSPFG+1	; enmy edit mode obj ON flag
;
TIMSTFG		EQU	ENMDOBJ+1
;;;;K;;;;ENBGFLG		EQU	ENMDOBJ+1	; enmy , BG edit mode flag
;;;;K;;;;TIMSTFG		EQU	ENBGFLG+1
;
;--------------------------------------------------------------------
FLDBUF		EQU	TIMSTFG+1
;;;;		EQU	FLDBUF+0800H
;
;--------------------------------------------------------------------
;
;------------ AADA used ram (enmy edit mode use) --------------------
FLNMBF		EQU	FLDBUF		; file name buffer
;						500Hgp
OBJTPBF		EQU	FLDBUF		; IuWF^Cv f[^ \p obt@
OBJTPBF0	EQU	OBJTPBF+00CH
OBJTPBF1	EQU	OBJTPBF0+008
OBJTPBF2	EQU	OBJTPBF1+008
OBJTPBF3	EQU	OBJTPBF2+008
OBJTPBF4	EQU	OBJTPBF3+008
OBJTPBF5	EQU	OBJTPBF4+008
;
B2ENWTH		EQU	FLDBUF		; BG2 H-write data
B2ENWTV		EQU	B2ENWTH+040H	; BG2 V-write data
;
;
ENNAMCT		EQU	FLDBUF+0800H	; enmy name buffer count
;
B2WTADH		EQU	ENNAMCT+2	; BG2 write address (H scroll)
B2WTADV		EQU	B2WTADH+2	; BG2 write address (V scroll)
ENINKYBF	EQU	B2WTADV+2	; inkey buffer
ENUNDBF		EQU	ENINKYBF+1	; enmy data undo buffer
;
FNBIDX		EQU	ENUNDBF+0AH	; file name buffer index
MJIDX0		EQU	FNBIDX+1	; mo-ji buffer index 0
MJIDX1		EQU	MJIDX0+1	;	"       "    1
MJIDX2		EQU	MJIDX1+1	;	"       "    2
MJIDX3		EQU	MJIDX2+1	;	"       "    3
MOJBF0		EQU	MJIDX3+1	; mo-ji disp buffer 0
MOJBF1		EQU	MOJBF0+8	;	"       "   1
;
NMDTBF0		EQU	MOJBF1		; afR[Xf[^
NMDTBF1		EQU	NMDTBF0+1	;	t@C
NMDTBF2		EQU	NMDTBF1+1	;
NMDTBF3		EQU	NMDTBF2+1	;
NMDTBF4		EQU	NMDTBF3+1	;
NMDTBF5		EQU	NMDTBF4+1	;
NMDTBF6		EQU	NMDTBF5+1	;
NMDTBF7		EQU	NMDTBF6+1	;
;
FLNMWK		EQU	MOJBF1		; FILE NAME WORK
NMPTWK		EQU	MJIDX1		; FILE NAME POINTER WORK
;
MOJBF2		EQU	MOJBF1+8	;	"       "   2
MOJBF3		EQU	MOJBF2+8	;	"       "   3
SCRLBF		EQU	MOJBF3+8	; file name scroll buffer
ENEMYNO		EQU	SCRLBF+2	; enmy NO.
ENNOFLS		EQU	ENEMYNO+2	; enmy NO. flash counter
ENDTPT		EQU	ENNOFLS+1	; enmy data buffer index
SRCPOS		EQU	ENDTPT+2	; enmy data buffer point (search)
ENNAM0		EQU	SRCPOS+2	; enmy name buffer 0
ENNAM1		EQU	ENNAM0+1	;	"       "  1
ENNAM2		EQU	ENNAM1+1	;	"       "  2
ENNAM3		EQU	ENNAM2+1	;	"       "  3
ENNAM4		EQU	ENNAM3+1	;	"       "  4
ENMDFG0		EQU	ENNAM4+1	; file mode flag
ENMDFG1		EQU	ENMDFG0+1	; ma-e-no file mode flag
RDFLDT		EQU	ENMDFG1+1	; read file data flag
GMMDBF		EQU	RDFLDT+1	; game mode ta-i-hi buffer
NTBKCNT		EQU	GMMDBF+1	; mdws  a`bj XN[ JE^[
CSLWKIDX	EQU	NTBKCNT+1	; J[\ N CfbNX
CHRSCRCT	EQU	CSLWKIDX+2	; ^Cv f[^ XN[ JE^[
SCRBAR		EQU	CHRSCRCT+1	; ^Cv f[^ XN[ o[ JE^[
ALL_UDFG	EQU	SCRBAR+1	; ܂Ƃ߂ē̂tmcntO
ENMSLMD		EQU	ALL_UDFG+2
EN_SCH3		EQU	ENMSLMD+2
EN_SCV3		EQU	EN_SCH3+2
EN_DP_XCT	EQU	EN_SCV3+2
EN_DP_YCT	EQU	EN_DP_XCT+2
ENDSP_PG	EQU	EN_DP_YCT+2
;
;
TOOL_RAM_END	EQU	ENDSP_PG+2
;
TOOL_RAM_SIZE	EQU	TOOL_RAM_END-TOOL_RAM_START
;;;;K;;;;;--------------------------------------------------------------------
;;;;K;;;;;
;;;;K;;;;;------------ AADA used ram (enmy edit mode use) --------------------
;;;;K;;;;ENNAMCT		EQU	FLDBUF+1	; enmy name buffer count
;;;;K;;;;;
;;;;K;;;;B2WTADH		EQU	ENNAMCT+2	; BG2 write address (H scroll)
;;;;K;;;;B2ENWTH		EQU	B2WTADH+2	; BG2 write data
;;;;K;;;;B2WTADV		EQU	B2ENWTH+040H	; BG2 write address (V scroll)
;;;;K;;;;B2ENWTV		EQU	B2WTADV+2	; BG2 write data
;;;;K;;;;ENINKYBF	EQU	B2ENWTV+040H	; inkey buffer
;;;;K;;;;ENUNDBF		EQU	ENINKYBF+1	; enmy data undo buffer
;;;;K;;;;FLNMBF		EQU	ENUNDBF+0AH	; file name buffer
;;;;K;;;;;
;;;;K;;;;OBJTPBF		EQU	FLNMBF		; IuWF^Cv f[^ \p obt@
;;;;K;;;;OBJTPBF0	EQU	OBJTPBF+00CH
;;;;K;;;;OBJTPBF1	EQU	OBJTPBF0+008
;;;;K;;;;OBJTPBF2	EQU	OBJTPBF1+008
;;;;K;;;;OBJTPBF3	EQU	OBJTPBF2+008
;;;;K;;;;OBJTPBF4	EQU	OBJTPBF3+008
;;;;K;;;;OBJTPBF5	EQU	OBJTPBF4+008
;;;;K;;;;;
;;;;K;;;;FNBIDX		EQU	FLNMBF+0500H	; file name buffer index
;;;;K;;;;MJIDX0		EQU	FNBIDX+1	; mo-ji buffer index 0
;;;;K;;;;MJIDX1		EQU	MJIDX0+1	;	"       "    1
;;;;K;;;;MJIDX2		EQU	MJIDX1+1	;	"       "    2
;;;;K;;;;MJIDX3		EQU	MJIDX2+1	;	"       "    3
;;;;K;;;;MOJBF0		EQU	MJIDX3+1	; mo-ji disp buffer 0
;;;;K;;;;MOJBF1		EQU	MOJBF0+8	;	"       "   1
;;;;K;;;;MOJBF2		EQU	MOJBF1+8	;	"       "   2
;;;;K;;;;MOJBF3		EQU	MOJBF2+8	;	"       "   3
;;;;K;;;;SCRLBF		EQU	MOJBF3+8	; file name scroll buffer
;;;;K;;;;ENEMYNO		EQU	SCRLBF+2	; enmy NO.
;;;;K;;;;ENNOFLS		EQU	ENEMYNO+2	; enmy NO. flash counter
;;;;K;;;;ENDTPT		EQU	ENNOFLS+1	; enmy data buffer index
;;;;K;;;;SRCPOS		EQU	ENDTPT+2	; enmy data buffer point (search)
;;;;K;;;;ENNAM0		EQU	SRCPOS+2	; enmy name buffer 0
;;;;K;;;;ENNAM1		EQU	ENNAM0+1	;	"       "  1
;;;;K;;;;ENNAM2		EQU	ENNAM1+1	;	"       "  2
;;;;K;;;;ENNAM3		EQU	ENNAM2+1	;	"       "  3
;;;;K;;;;ENNAM4		EQU	ENNAM3+1	;	"       "  4
;;;;K;;;;ENMDFG0		EQU	ENNAM4+1	; file mode flag
;;;;K;;;;ENMDFG1		EQU	ENMDFG0+1	; ma-e-no file mode flag
;;;;K;;;;RDFLDT		EQU	ENMDFG1+1	; read file data flag
;;;;K;;;;GMMDBF		EQU	RDFLDT+1	; game mode ta-i-hi buffer
;;;;K;;;;NTBKCNT		EQU	GMMDBF+1	; mdws  a`bj XN[ JE^[
;;;;K;;;;CSLWKIDX	EQU	NTBKCNT+1	; J[\ N CfbNX
;;;;K;;;;CHRSCRCT	EQU	CSLWKIDX+2	; ^Cv f[^ XN[ JE^[
;;;;K;;;;SCRBAR		EQU	CHRSCRCT+1	; ^Cv f[^ XN[ o[ JE^[
;;;;K;;;;ALL_UDFG	EQU	SCRBAR+1	; ܂Ƃ߂ē̂tmcntO
;;;;K;;;;ENMSLMD		EQU	ALL_UDFG+2
;;;;K;;;;EN_SCH3		EQU	ENMSLMD+2
;;;;K;;;;EN_SCV3		EQU	EN_SCH3+2
;;;;K;;;;EN_DP_XCT	EQU	EN_SCV3+2
;;;;K;;;;EN_DP_YCT	EQU	EN_DP_XCT+2
;;;;K;;;;ENDSP_PG	EQU	EN_DP_YCT+2
;;;;K;;;;;
;;;;K;;;;;
;;;;K;;;;TOOL_RAM_END	EQU	ENDSP_PG+2
;;;;K;;;;;
;;;;K;;;;TOOL_RAM_SIZE	EQU	TOOL_RAM_END-TOOL_RAM_START
;
;====================================================================
;;SFX-DOS	EQU	1E00H		; ~ 1FFFH
;====================================================================
;
;
;====================================================================
;=		!=0 bank RAM					    =
;====================================================================
;
;-------------- nai^Cv f[^ obt@ ----------------------
CHRDTBF		EQU	707C00H
;			   |
;			000300H
;
;-------------- snnkpq`l̑ޔꏊ --------------------------
TOOL_BUF	EQU	708000H
;			   |
;			708000H+TOOL_RAM_SIZE
;
;-------------- Gf[^ obt@ -----------------------------------
ENMYDTBF	EQU	70E000H		; enmy data index (L)
ENDTBF		EQU	ENMYDTBF+2	;		  (H)
;
ENNAMCT_SB	EQU	70EFFEH
;					; enmy data
ENNAMBF		EQU	70F000H		; enmy name buffer
;
;-------------- Gf[^ obt@ tmcnGA (܂Ƃ߂ĈړƂgp)
UNDO_ENDATA	EQU	71C000H
;
;--------------- G̖O̕\p obt@ ----------------------
ENMDSPBUF	EQU	71D000H
;
;-------------- course data buffer ----------------------------------
;;;;K;;;;COURSEDT	EQU	RPRO_RAM-(2+(7*100)+(800H*3))
COURSEDT	EQU	710000H
DTBUFF		EQU	COURSEDT+10
DTBUFF2		EQU	COURSEDT+1000H
;
UNDOBUF		EQU	DTBUFF2+1000H   ;to undo data back_up RAM
;
;-------------- R[Xf[^ a`bj to ---------------------
DTBUFF_BAK	EQU	71A000H
ENMYDTBF_BAK	EQU	DTBUFF_BAK+1000H
;;;;;;		EQU	ENMYDTBF_BAK+1000H
;
;.............. enemy data buffer ...................................
ENBGDTBF	EQU	7F0000H		; enmy set BG data buffer
;;;;;		EQU	ENBGDTBF+8000H
;
;
;====================================================================
;=		M-chip RAM					    =
;====================================================================
;
M_ENDTBF	EQU	WOB7CHR+(66H*20H) ;normal enemy data set area
;;;;		EQU	M_ENDTBF+(3*106)
;
;
;
;
;
