;************************************************************************
;*									*
;*	title name	: "yossy tool"					*
;*	proccess	: status data set				*
;*	file name	: yst_stat					*
;*									*
;************************************************************************
;
;
		SALL
;
		include		yst_header.inc
		include		../../../JPN/sfc/ys_presno.h
;
		XALL
;
;
;------------------------------------------------------------------------
;
;		Super_Y edit-tool		1992.03.05(THU)
;
;------------------------------------------------------------------------
;
;
;=============================================== (ys_init) ==============
		EXT	ITSB
		EXT	VRAMDX_ST
;
;=============================================== (syt_dmap) =============
		GLB	STATIN
		GLB	OBJTP,EALMV
;=============================================== (syt_main) =============
		EXT	BLNKON
		EXT	JSRSUB,BLNKOF2,VRAMCL
;=============================================== (yst_rpro) =============
		EXT	NEWVMADL
;=============================================== (syt_init) =============
		EXT	GMMDST
		EXT	BGWR,GM00
;=============================================== (yst_edit) =============
		EXT	PSCTDT1
		EXT	STUNT0_SB_ST
;=========================================================================
;
;
;
;************************************************************************
;*									*
;*		program start						*
;*									*
;************************************************************************
;
;
		EXTEND
;
;
		MEM8
		IDX8
;
Group_17	GROUP	Stat_pro
Stat_pro	SECT	REL
;
;
;************************************************************************
;*		Data display mode			(DTDISP)	*
;************************************************************************
;
;
STATIN		EQU	$
		PHB
		PHK
		PLB
;;;;K;;;;		JSR	STATIN1
		LDA	!STINFG
		ASL	A
		TAX
		JSR	(STATIN1,X)
		PLB
		RTL
;
;
STATIN1		EQU	$
;;;;K;;;;		LDA	STINFG
;;;;K;;;;		JSL	>JSRSUB
		WORD	STATIN000		;00
		WORD	STATIN200		;01
		WORD	CHRSTINT		;02
		WORD	CHRST			;03
		WORD	EN_ALL_MOVE		;04
		WORD	ENMY_SIFT		;05
;
OBJTP	EQU	002H
EALMV	EQU	004H
;
;
;
;========================================================================
;=		Init. display				(DTDP000)	=
;========================================================================
		MEM8
		IDX8
STATIN000	EQU	$
		JSL	>VRAMCL
;
;-------------- BG color set ----------------------------
		STZ	2121H			;CGRAM address set
;
		M16
;
		LDA	#00000000B+(22H*100H)	;DMA parameter & B bus address
		STA	4300H
		LDA	#14C000H		;A bus address(L,H)
		STA	4302H
		LDY	#BANK 14C000H		;	"     (B)
		STY	4304H
		LDA	#0100H			;number of byte
		STA	4305H
		LDX	#00000001B
		STX	420BH			;DMA "ON"
;
;-------------- BG3 screen set --------------------------
		LDY	#10000000B	;inc mode
		STY	2115H
		LDA	#3400H
		STA	2116H		; VRAM address set
		LDA	#00000001B+(18H*100H)
		STA	4300H		; parameter & B bus address
		LDA	#14B000H
		STA	4302H		; A bus address (L,H)
		LDY	#BANK 14B000H
		STY	4304H		;		(B)
		LDA	#1000H
		STA	4305H		; number of byte
		STX	420BH		; DMA "on"
;
;-------------- next initial --------------------------
		LDA	#0001CH
		STA	STATX
		STZ	STATY

LOOP0		EQU	$

		JSR	ZERODISP

		LDA	STATY
		CLC
		ADC	#00002H
		STA	STATY
		CMP	#16*2
		BNE	LOOP0
;
		LDA	#0001CH
		STA	STATX
		STZ	STATY

		MI8
		LDA	#012H
		STA	STATCMP
;
;-------------- map mode initial flag set ---------------
		LDA	#00010100B	;main select ( BG3,OBJ )
		STA	MANSEL	       ; 212CH
		STZ	WMANSL	       ;window "OFF"
		STZ	WIND23
		STZ	WIND24
		STZ	WIND25
;
		STZ	<SCCH3		;BG3 scroll counter set
		STZ	<SCCH3+1
		STZ	<SCCV3
		STZ	<SCCV3+1
		LDA	#00001111B
		STA	FADNO		; 2100H
		LDA	#036H
		STA	2109H
		INC	STINFG
;
		JSL	>BLNKOF2
		RTS
;
;----------------------------------------------------------
;
;========================================================================
;=		Move					(STATIN200)	=
;========================================================================
		MEM8
		IDX8
STATIN200	EQU	$
;
;
;
;
;-------------- cursol move -----------------------------
		LDA	<FRCNT
		AND	#010H
		BEQ	STATIN010

		LDA	STATX
		AND	#001H
		PHA
		ASL	A
		ASL	A
		ASL	A
		CLC
		ADC	#0E0H
		STA	>OAM		; x-pos. set
;
		LDA	STATY
		TAX
		CMP	#008H
		BCC	STATIN203
		CMP	STATCMP
		BCS	STATIN202

		LDA	#008H
		BRA	STATIN203
STATIN202	EQU	$
		SEC
		SBC	#00EH
STATIN203	EQU	$
		ASL	A
		ASL	A
		STA	<WORK0
		ASL	A
		CLC
		ADC	#017H
		CLC
		ADC	<WORK0
		STA	>OAM+1		; y-pos. set
;
		PLA
		BNE	STATIN205

		LDA	GMSTATUS,X
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		CMP	#00AH
		BCC	STATIN208
		BRA	STATIN007
STATIN205	EQU	$
		LDA	GMSTATUS,X
		AND	#00FH
		CMP	#009H
		BCC	STATIN208
STATIN007	EQU	$
		CLC
		ADC	#007H
STATIN208	EQU	$
		CLC
		ADC	#030H
		STA	>OAM+2		; char. no. set
		LDA	#032H
		STA	>OAM+3		; attribute set
;
		LDA	#00000000B	;OAM sub set
		STA	>OAMSUB

;
;-------------- input check -----------------------------
STATIN010	EQU	$

		LDA	INKEY
		CMP	#CHC
		BNE	STATIN210		;return ? ( no:DTDP210 )
;
;-------------- return set ----------------------
;
;
		LDA	#BGWR
		STA	MODENO
		LDA	#074H
		STA	2109H
		RTS
;
;
;
;
;
		MEM8
		IDX8
STATIN210	EQU	$
		LDA	INKEY
		CMP	#NUL
		BEQ	STATIN240
		CMP	#L_G
		BCS	STATIN240

STATIN220	EQU	$
		CMP	#SU0		; l ?
		BCS	KEYDISP		;	YES -> KEYDISP

STATIN240	EQU	$
		LDA	INKEY2
		CMP	#UPP
		BEQ	CURMOV_U
		CMP	#DWN
		BEQ	CURMOV_D

		MI8
		RTS
;
		MEM8
		IDX8
CURMOV_D	EQU	$
		M16
		LDA	STATY
		CMP	#0001EH
		BCS	CURMOV_UD200
		CMP	#00008H
		BCC	CURMOV_D100
		CMP	#00016H
		BCS	CURMOV_D100

		LDA	<SCCV3
		CLC
		ADC	#00018H
		STA	<SCCV3

CURMOV_D100	EQU	$
		LDA	STATY
		CLC
		ADC	#00002H
		STA	STATY

		M8
		LDA	#018H
		STA	STATCMP
		M16
		BRA	CURMOV_UD000
;
		MEM8
		IDX8
CURMOV_U	EQU	$
		M16
		LDA	STATY
		BEQ	CURMOV_UD200
		CMP	#0000AH
		BCC	CURMOV_U100
		CMP	#00018H
		BCS	CURMOV_U100

		LDA	<SCCV3
		SEC
		SBC	#00018H
		STA	<SCCV3

CURMOV_U100	EQU	$
		LDA	STATY
		SEC
		SBC	#00002H
		STA	STATY

		M8
		LDA	#018H
		STA	STATCMP
		M16

CURMOV_UD000	EQU	$
		LDA	#0001CH
		STA	STATX

		LDX	STATY
		LDA	GMSTATUS,X
		BNE	CURMOV_UD200

		JSR	ZERODISP
CURMOV_UD200	EQU	$

		MI8
		RTS
;
		MEM8
		IDX8
KEYDISP		EQU	$
		STA	<WORK2

		LDA	STATX
		PHA

		JSR	CHECK_DATA
		MEM8
;		IDX8

		PLA
		CMP	STATX
		BEQ	KEYDISP100
		STA	<WORKA
		STZ	<WORKB

		LDA	#004H
		STA	<WORK3
		MI16
;
		LDA	>VRAMD
		TAX
		LDA	STATY
		TAY
		ASL	A
		ASL	A
		ASL	A
		ASL	A
		STA	<WORK4
		ASL	A
		STA	<WORK6

		LDA	#3400H+060H	;(WK0,1) <-- start VRAM address set
		CLC
		ADC	<WORKA
		CLC
		ADC	<WORK4
		CLC
		ADC	<WORK6
		STA	>VRAMD+2,X	 ;VRAM address set

		LDA	#001H
		STA	>VRAMD+4,X	 ;number of byte set

		LDA	<WORK2
		STA	>VRAMD+6,X	 ;chara no. set
;
		LDA	#0FFFFH
		STA	>VRAMD+8,X	 ;end code set

		TXA
		CLC
		ADC	#00006H
		STA	>VRAMD

		MI8
KEYDISP100	EQU	$
		RTS
;
		MEM8
		IDX8
ZERODISP	EQU	$
		MI16
		LDA	>VRAMD
		TAX
		LDA	STATY
		TAY
		ASL	A
		ASL	A
		ASL	A
		ASL	A
		STA	<WORK4
		ASL	A
		STA	<WORK6

		LDA	#3400H+060H	;(WK0,1) <-- start VRAM address set
		CLC
		ADC	STATX
		CLC
		ADC	<WORK4
		CLC
		ADC	<WORK6
		STA	>VRAMD+2,X	 ;VRAM address set

		LDA	#00003H
		STA	>VRAMD+4,X	 ;number of byte set

		LDA	GMSTATUS,Y
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		CMP	#0000AH
		BCC	ZERODISP208
		CLC
		ADC	#00007H
ZERODISP208	EQU	$
		CLC
		ADC	#00430H
		STA	>VRAMD+6,X	 ;chara no. set

		LDA	GMSTATUS,Y
		AND	#0000FH
		CMP	#0000AH
		BCC	ZERODISP209
		CLC
		ADC	#00007H
ZERODISP209	EQU	$
		CLC
		ADC	#00430H
		STA	>VRAMD+8,X	 ;chara no. set
;
		LDA	#0FFFFH
		STA	>VRAMD+10,X	 ;end code set

		TXA
		CLC
		ADC	#0008H
		STA	>VRAMD

		RTS
;
		MEM8
		IDX8
CHECK_DATA	EQU	$
		LDA	STATY
		TAX
		LSR	A
		TAY

		LDA	STATX
		AND	#001H
		BEQ	CHECK_DT000

		LDA	INKEY
		CMP	#040H
		BCS	CHECK_DT50
		AND	#00FH
		BRA	CHECK_DT80
CHECK_DT50	EQU	$
		SEC
		SBC	#037H
CHECK_DT80	EQU	$

		CMP	CHKDT_L,Y
		BCS	CHECK_DT400

		STA	<WORK0
		STZ	<WORK1

		M16
		LDA	GMSTATUS,X
		AND	#000F0H
		ORA	<WORK0
		STA	GMSTATUS,X

		LDA	#0001CH
		BRA	CHECK_DT200

		MEM8
CHECK_DT000	EQU	$
		LDA	INKEY
		CMP	#040H
		BCS	CHECK_DT150
		AND	#00FH
		BRA	CHECK_DT180
CHECK_DT150	EQU	$
		SEC
		SBC	#037H
CHECK_DT180	EQU	$

		CMP	CHKDT_H,Y
		BCS	CHECK_DT400

		ASL	A
		ASL	A
		ASL	A
		ASL	A
		STA	<WORK0
		STZ	<WORK1

		M16
		LDA	GMSTATUS,X
		AND	#0000FH
		ORA	<WORK0
		STA	GMSTATUS,X

		LDA	#0001DH
CHECK_DT200	EQU	$
		STA	STATX

		M8
CHECK_DT400	EQU	$
		RTS
;
CHKDT_L		EQU	$
		BYTE	010H	;kLJ[(0-1F)
		BYTE	010H	;afP^Cv(0-F)
		BYTE	010H	;  h  J[(0-F)
		BYTE	010H	;afQXN[(0-1F)
		BYTE	010H	;  h  J[(0-1F)
		BYTE	010H	;afR^Cv(0-3F)
		BYTE	010H	;  h  J[(0-1F)
		BYTE	010H	;nai^Cv(0-F)
		BYTE	010H	;  "   J[(0-F)
		BYTE	010H	;ʃ[h(0-1F)
		BYTE	010H	;L]p^[(0-1F)
		BYTE	010H	;J[]p^[(0-F)
		BYTE	010H	;XN[^Cv(0-F)
		BYTE	010H	;afl mD(0-F)
		BYTE	004H	;R[X mD(0-3)
		BYTE	008H	;XRA^Cv (0-7)
;
CHKDT_H		EQU	$
		BYTE	002H	;kLJ[(0-1F)
		BYTE	001H	;afP^Cv(0-F)
		BYTE	002H	;  h  J[(0-1F)
		BYTE	002H	;afQXN[(0-1F)
		BYTE	004H	;  h  J[(0-3F)
		BYTE	004H	;afR^Cv(0-3F)
		BYTE	004H	;  h  J[(0-3F)
		BYTE	008H	;nai^Cv(0-F)
		BYTE	001H	;  "   J[(0-F)
		BYTE	002H	;ʃ[h(0-1F)
		BYTE	004H	;L]p^[(0-3F)
		BYTE	002H	;J[]p^[(0-1F)
		BYTE	002H	;XN[^Cv(0-1F)
		BYTE	001H	;afl mD(0-F)
		BYTE	001H	;R[X mD(0-3)
		BYTE	001H	;XRA^Cv (0-7)
;
;;;;K;;;;;
;;;;K;;;;CHKDT_L		EQU	$
;;;;K;;;;		BYTE	010H	;kLJ[(0-1F)
;;;;K;;;;		BYTE	010H	;afP^Cv(0-F)
;;;;K;;;;		BYTE	010H	;  h  J[(0-F)
;;;;K;;;;		BYTE	010H	;afQXN[(0-1F)
;;;;K;;;;		BYTE	010H	;  h  J[(0-1F)
;;;;K;;;;		BYTE	010H	;afR^Cv(0-3F)
;;;;K;;;;		BYTE	010H	;  h  J[(0-1F)
;;;;K;;;;		BYTE	010H	;nai^Cv(0-F)
;;;;K;;;;		BYTE	010H	;  "   J[(0-F)
;;;;K;;;;		BYTE	010H	;ʃ[h(0-1F)
;;;;K;;;;		BYTE	010H	;L]p^[(0-1F)
;;;;K;;;;		BYTE	010H	;J[]p^[(0-F)
;;;;K;;;;		BYTE	010H	;XN[^Cv(0-F)
;;;;K;;;;		BYTE	010H	;afl mD(0-F)
;;;;K;;;;		BYTE	004H	;R[X mD(0-3)
;;;;K;;;;		BYTE	008H	;XRA^Cv (0-7)
;;;;K;;;;;
;;;;K;;;;CHKDT_H		EQU	$
;;;;K;;;;		BYTE	002H	;kLJ[(0-1F)
;;;;K;;;;		BYTE	001H	;afP^Cv(0-F)
;;;;K;;;;		BYTE	001H	;  h  J[(0-F)
;;;;K;;;;		BYTE	002H	;afQXN[(0-1F)
;;;;K;;;;		BYTE	002H	;  h  J[(0-1F)
;;;;K;;;;		BYTE	004H	;afR^Cv(0-3F)
;;;;K;;;;		BYTE	002H	;  h  J[(0-1F)
;;;;K;;;;		BYTE	008H	;nai^Cv(0-F)
;;;;K;;;;		BYTE	001H	;  "   J[(0-F)
;;;;K;;;;		BYTE	002H	;ʃ[h(0-1F)
;;;;K;;;;		BYTE	002H	;L]p^[(0-1F)
;;;;K;;;;		BYTE	002H	;J[]p^[(0-F)
;;;;K;;;;		BYTE	001H	;XN[^Cv(0-F)
;;;;K;;;;		BYTE	001H	;afl mD(0-F)
;;;;K;;;;		BYTE	001H	;R[X mD(0-3)
;;;;K;;;;		BYTE	001H	;XRA^Cv (0-7)
;
;RTN		EQU	00DH		; [return]
;TAB		EQU	08BH		; [TAB]
;ESC		EQU	08CH		; [ESC]
;UPP		EQU	01CH		; [up	 key]
;DWN		EQU	01DH		; [down	 key]
;LEF		EQU	01EH		; [left	 key]
;RIT		EQU	01FH		; [right key]
;
;
;****************************************************************
;*								*
;****************************************************************
CHRDATA		EQU	$
		WORD	00034H,00030H,00041H	;SO`
		WORD	00034H,00030H,00042H	;SOa
		WORD	00034H,00030H,00043H	;SOb
		WORD	00034H,00030H,00044H	;SOc
;
		WORD	00034H,00031H,00041H	;SP`
		WORD	00034H,00031H,00042H	;SPa
		WORD	00034H,00031H,00043H	;SPb
		WORD	00034H,00031H,00044H	;SPc
;
		WORD	00034H,00032H,00041H	;SQ`
		WORD	00034H,00032H,00042H	;SQa
		WORD	00034H,00032H,00043H	;SQb
		WORD	00034H,00032H,00044H	;SQc
;
		WORD	00034H,00033H,00041H	;SR`
		WORD	00034H,00033H,00042H	;SRa
		WORD	00034H,00033H,00043H	;SRb
		WORD	00034H,00033H,00044H	;SRc
;
		WORD	00034H,00034H,00041H	;SS`
		WORD	00034H,00034H,00042H	;SSa
		WORD	00034H,00034H,00043H	;SSb
		WORD	00034H,00034H,00044H	;SSc
;
		WORD	00034H,00035H,00041H	;ST`
		WORD	00034H,00035H,00042H	;STa
		WORD	00034H,00035H,00043H	;STb
		WORD	00034H,00035H,00044H	;STc
;
		WORD	00034H,00036H,00041H	;SU`
		WORD	00034H,00036H,00042H	;SUa
		WORD	00034H,00036H,00043H	;SUb
		WORD	00034H,00036H,00044H	;SUc
;
		WORD	00034H,00037H,00041H	;SV`
		WORD	00034H,00037H,00042H	;SVa
		WORD	00034H,00037H,00043H	;SVb
		WORD	00034H,00037H,00044H	;SVc
;
		WORD	00034H,00038H,00041H	;SW`
		WORD	00034H,00038H,00042H	;SWa
		WORD	00034H,00038H,00043H	;SWb
		WORD	00034H,00038H,00044H	;SWc
;
		WORD	00034H,00039H,00041H	;SX`
		WORD	00034H,00039H,00042H	;SXa
		WORD	00034H,00039H,00043H	;SXb
		WORD	00034H,00039H,00044H	;SXc
;
		WORD	00034H,00041H,00041H	;S``
		WORD	00034H,00041H,00042H	;S`a
		WORD	00034H,00041H,00043H	;S`b
		WORD	00034H,00041H,00044H	;S`c
;
		WORD	00034H,00042H,00041H	;Sa`
		WORD	00034H,00042H,00042H	;Saa
		WORD	00034H,00042H,00043H	;Sab
		WORD	00034H,00042H,00044H	;Sac
;
		WORD	00034H,00043H,00041H	;Sb`
		WORD	00034H,00043H,00042H	;Sba
		WORD	00034H,00043H,00043H	;Sbb
		WORD	00034H,00043H,00044H	;Sbc
;
		WORD	00034H,00044H,00041H	;Sc`
		WORD	00034H,00044H,00042H	;Sca
		WORD	00034H,00044H,00043H	;Scb
		WORD	00034H,00044H,00044H	;Scc
;
		WORD	00034H,00045H,00041H	;Sd`
		WORD	00034H,00045H,00042H	;Sda
		WORD	00034H,00045H,00043H	;Sdb
		WORD	00034H,00045H,00044H	;Sdc
;
		WORD	00034H,00046H,00041H	;Se`
		WORD	00034H,00046H,00042H	;Sea
		WORD	00034H,00046H,00043H	;Seb
		WORD	00034H,00046H,00044H	;Sec
;
		WORD	00045H,00034H,00041H	;dS`
		WORD	00045H,00034H,00042H	;dSa
		WORD	00045H,00034H,00043H	;dSb
		WORD	00045H,00034H,00044H	;dSc
;
		WORD	00045H,00035H,00041H	;dT`
		WORD	00045H,00035H,00042H	;dTa
		WORD	00045H,00035H,00043H	;dTb
		WORD	00045H,00035H,00044H	;dTc
;
		WORD	00045H,00036H,00041H	;dU`
		WORD	00045H,00036H,00042H	;dUa
		WORD	00045H,00036H,00043H	;dUb
		WORD	00045H,00036H,00044H	;dUc
;
		WORD	00045H,00037H,00041H	;dV`
		WORD	00045H,00037H,00042H	;dVa
		WORD	00045H,00037H,00043H	;dVb
		WORD	00045H,00037H,00044H	;dVc
;
		WORD	00038H,00045H,00041H	;Wd`
		WORD	00038H,00045H,00042H	;Wda
		WORD	00038H,00045H,00043H	;Wdb
		WORD	00038H,00045H,00044H	;Wdc
;
		WORD	00038H,00046H,00041H	;We`
		WORD	00038H,00046H,00042H	;Wea
		WORD	00038H,00046H,00043H	;Web
		WORD	00038H,00046H,00044H	;Wec
;
		WORD	00031H,00030H,00041H	;PPO`
		WORD	00031H,00030H,00042H	;PPOa
		WORD	00031H,00030H,00043H	;PPOb
		WORD	00031H,00030H,00044H	;PPOc
;
		WORD	00031H,00031H,00041H	;PPP`
		WORD	00031H,00031H,00042H	;PPPa
		WORD	00031H,00031H,00043H	;PPPb
		WORD	00031H,00031H,00044H	;PPPc
;
;
;****************************************************************
;*								*
;*		kf[^m. CjVZbg		*
;*								*
;****************************************************************
CHRSTINT_RAM	EQU	$
		WORD	OBJTPBF0,OBJTPBF1,OBJTPBF2
		WORD	OBJTPBF3,OBJTPBF4,OBJTPBF5
;
		WORD	OBJTPBF0+080H,OBJTPBF1+080H,OBJTPBF2+080H
		WORD	OBJTPBF3+080H,OBJTPBF4+080H,OBJTPBF5+080H
;
		WORD	OBJTPBF0+100H,OBJTPBF1+100H,OBJTPBF2+100H
		WORD	OBJTPBF3+100H,OBJTPBF4+100H,OBJTPBF5+100H
;
		WORD	OBJTPBF0+180H,OBJTPBF1+180H,OBJTPBF2+180H
		WORD	OBJTPBF3+180H,OBJTPBF4+180H,OBJTPBF5+180H
;
		WORD	OBJTPBF0+200H,OBJTPBF1+200H,OBJTPBF2+200H
		WORD	OBJTPBF3+200H,OBJTPBF4+200H,OBJTPBF5+200H
;
		WORD	OBJTPBF0+280H,OBJTPBF1+280H,OBJTPBF2+280H
		WORD	OBJTPBF3+280H,OBJTPBF4+280H,OBJTPBF5+280H
;
;
CHRSTINT	EQU	$
		DEC	!FADNO
		BMI	CHRSTINT_000
		JMP	CHRSTINT_990	; goto RTS
;
CHRSTINT_000	EQU	$
		JSL	>BLNKON
		JSL	>VRAMCL
;
;-------------- PPU Reg. initial set ----------------------------
		LDX	#GM00
		JSL	>GMMDST
		STZ	2105H
		LDA	#011H
		STA	!MANSEL
		STA	212CH
		LDA	#074H
		STA	!BG1SCF
		STA	2107H
;
;-------------- mode 0 character set ----------------------------
		M16			; memory 16bit mode
		LDY	#10000000B
		STY	2115H		; inc mode set
		LDA	#00000H
		STA	2116H		; VRAM address set
		LDA	#00000001B+(18H*100H)
		STA	4300H		; DMA parameter & B bus address
		LDA	#169800H
		STA	4302H		; A bus address(L,H) set
		LDY	#BANK 169800H
		STY	4304H		;	"	(B) set
		LDA	#01000H
		STA	4305H		; number of byte set
		LDX	#00000001B
		STX	420BH		; DMA "ON"
;
;-------------- mode 0 screen write -----------------------------
		LDA	#07400H
		STA	2116H		; VRAM address set
		LDA	#00000001B+(18H*100H)
		STA	4300H		; DMA parameter & B bus address
		LDA	#168800H
		STA	4302H		; A bus address(L,H) set
		LDY	#BANK 168800H
		STY	4304H		;	"	(B) set
		LDA	#00800H
		STA	4305H		; number of byte set
		STX	420BH		; DMA "ON"
;
;-------------- OBJ character set -------------------------------
		LDA	#04000H
		STA	2116H		; VRAM address set
		LDA	#00000001B+(18H*100H)
		STA	4300H		; DMA parameter & B bus address
		LDA	#168000H
		STA	4302H		; A bus address(L,H)
		LDY	#BANK 168000H
		STY	4304H		;	"	(B)
		LDA	#00400H
		STA	4305H		; number of byte set
		STX	420BH		; DMA "ON"
;
		M8			; memory 8bit mode
;
;-------------- color set ---------------------------------------
		STZ	2121H		; CGRAM address set
		M16			; memory 16bit mode
		LDA	#00000000B+(22H*100H)
		STA	4300H		; DMA parameter & B bus address
		LDA	#16B000H
		STA	4302H		; A bus address(L,H) set
		LDY	#BANK 16B000H
		STY	4304H		;	"	(B) set
		LDA	#00200H
		STA	4305H		; number of byte set
		STX	420BH		; DMA "ON"
;
;-------------- obt@̏ݒ --------------------------------
		PHB
		I16			; index 16bit mode
		LDX	#1688C0H
		LDY	#OBJTPBF
		LDA	#002C0H
		MVN	#BANK 168800H,#BANK OBJTPBF
		PLB
;
		LDX	#00000H
CHRSTINT_700	EQU	$
		TXA
		ASL	A
		TAY
		LDA	CHRSTINT_RAM,Y
		STA	<WORK0
		INC	A
		INC	A
		STA	<WORK2
		INC	A
		INC	A
		STA	<WORK4
;
		LDA	>CHRDTBF,X
		AND	#000FFH
		ASL	A
		STA	<WORKE
		ASL	A
;;;;K;;;;		CLC
		ADC	<WORKE
		TAY
		LDA	CHRDATA,Y
		STA	(<WORK0)
		LDA	CHRDATA+2,Y
		STA	(<WORK2)
		LDA	CHRDATA+4,Y
		STA	(<WORK4)
		INX
		CPX	#036
		BCC	CHRSTINT_700
;
		I8			; index 8bit mode
;
;-------------- obt@ XN[  --------------------
		LDA	#07460H
		STA	2116H		; VRAM address set
		LDA	#00000001B+(18H*100H)
		STA	4300H		; DMA parameter & B bus address
		LDA	#OBJTPBF
		STA	4302H		; A bus address(L,H) set
		LDY	#BANK OBJTPBF
		STY	4304H		;	"	(B) set
		LDA	#002C0H
		STA	4305H		; number of byte set
		LDX	#00000001B
		STX	420BH		; DMA "ON"
;
;-------------- q`l̏ݒ --------------------------------
		LDA	<SCCH1
		STA	!XTAIHI
		LDA	<SCCV1
		STA	!YTAIHI
		STZ	<SCCH1
		STZ	<SCCV1
		STZ	!CSLWKIDX
;
		M8			; memory 8bit mode
;
		STZ	!NTBKCNT
;;;;K;;;;		STZ	!CHRSCRCT
;;;;K;;;;		STZ	!SCRBAR
;
		LDA	!OBJTYP
		CMP	#07AH+1
		BCC	CHRSTINT_890
		SEC
		SBC	#07AH
		ASL	A
		ASL	A
		ASL	A
		TAX
		LDA	CSLWAKU_DAT,X
		STA	!CSLWKIDX
		LDA	#07AH
CHRSTINT_890	EQU	$
		STA	!CHRSCRCT
		LSR	A
		LSR	A
		STA	!SCRBAR
		JSR	CHRSCR_NO
		JSL	>NEWVMADL
;
CHRSTINT_900	EQU	$
		JSL	>BLNKOF2
		INC	!STINFG
;
CHRSTINT_990	EQU	$
		RTS
;
;
;----------------------------------------------------------------
;-		}EX NbN f[^				-
;----------------------------------------------------------------
MUSKLK	EQU	$
	BYTE	080H,080H,080H,000H,000H,000H,080H,004H	;"A"line
	BYTE	004H,004H,080H,008H,008H,008H,080H,00CH
	BYTE	00CH,00CH,080H,010H,010H,010H,080H,014H
	BYTE	014H,014H,080H,018H,018H,018H,080H,080H
;
	BYTE	080H,080H,080H,001H,001H,001H,080H,005H	;"B"line
	BYTE	005H,005H,080H,009H,009H,009H,080H,00DH
	BYTE	00DH,00DH,080H,011H,011H,011H,080H,015H
	BYTE	015H,015H,080H,019H,019H,019H,080H,080H
;
	BYTE	080H,080H,080H,002H,002H,002H,080H,006H	;"C"line
	BYTE	006H,006H,080H,00AH,00AH,00AH,080H,00EH
	BYTE	00EH,00EH,080H,012H,012H,012H,080H,016H
	BYTE	016H,016H,080H,01AH,01AH,01AH,080H,080H
;
	BYTE	080H,080H,080H,003H,003H,003H,080H,007H	;"D"line
	BYTE	007H,007H,080H,00BH,00BH,00BH,080H,00FH
	BYTE	00FH,00FH,080H,013H,013H,013H,080H,017H
	BYTE	017H,017H,080H,01BH,01BH,01BH,080H,080H
;
	BYTE	080H,080H,080H,080H,080H,080H,080H,080H	;
	BYTE	080H,080H,080H,080H,080H,080H,080H,080H
	BYTE	080H,080H,080H,080H,080H,081H,081H,081H
	BYTE	081H,080H,082H,082H,082H,082H,080H,080H
;
;
;****************************************************************
;*								*
;*		kf[^m. Zbg				*
;*								*
;****************************************************************
CHRST_DAT	EQU	$
		BYTE	01CH*0,01CH*1,01CH*2,01CH*3
;
;
CHRST		EQU	$
		JSR	MUSMOVE		; }EXړ
;
		LDA	!MOUSEBT
		AND	#10000000B
		BNE	CHRST_050
		LDA	!INKEY
		CMP	#F_3		;[F3] ON ?
		BNE	CHRST_100	;	NO -> CHRST_100
CHRST_050	EQU	$
		LDA	#ITSB
		STA	!MODENO
		STZ	!STINFG
		M16			; memory 16bit mode
		LDA	!XTAIHI
		STA	<SCCH1
		LDA	!YTAIHI
		STA	<SCCV1
		M8			; memory 8bit mode
		JMP	CHRST_900
;
CHRST_100	EQU	$
		LDA	!CRYPSL2
		BMI	CHRST_500
		LDA	!CRXPSL2
		CMP	#030H
		BCC	CHRST_200
		JSR	CSLWAKU		; g ړ
		JMP	CHRST_900
;
CHRST_200	EQU	$		; XN[ o[ ړ
		JSR	CHRSCR
		JSR	SCRBARST
		JMP	CHRST_900
;
CHRST_500	EQU	$
		LDA	!MOUSEBT
		AND	#01000000B
		BEQ	CHRST_600
		LDA	!CRYPSL2
		AND	#008H
		BEQ	CHRST_600
		LDA	!CRYPSL2
		AND	#070H
		ASL	A
		STA	<WORK0
		LDA	!CRXPSL2
		AND	#0F8H
		LSR	A
		LSR	A
		LSR	A
		ORA	<WORK0
		TAY
		LDA	MUSKLK,Y	; data read
		STA	<WORK0
		BPL	CHRST_550
		JSR	NXTBCK
		BRA	CHRST_900
CHRST_550	EQU	$
		LDY	!NTBKCNT
		CLC
		ADC	CHRST_DAT,Y
		STA	<WORK0
		JSR	CHRDT_SET
;
CHRST_600	EQU	$
;
CHRST_900	EQU	$
		JSR	CSLWKOBJ
		JSR	SCRBAROBJST
		RTS
;
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+		}EXړ				+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
MUSMOVE		EQU	$
		PHB			;(DBR) save
		LDA	#BANK OAM	;(DBR) <-- OAM(B)
		PHA
		PLB
;
		M16			; memory 16bit mode
		LDA	>CRXPSL2
		CLC
		ADC	>MOUSEBX
		AND	#000FFH
		STA	>CRXPSL2
		SEC
		SBC	#00007H
		AND	#000FFH
		TAX
		STX	!OAM		;wZbg
;
		LDA	>CRYPSL2
		CLC
		ADC	>MOUSEBY
		AND	#000FFH
		STA	>CRYPSL2
		TAX
		STX	!OAM+1		;xZbg
;
		LDA	>MOUSEBB
		AND	#11000000B
		BEQ	MUSMOVE_PAS
		LDA	#00002H
MUSMOVE_PAS	EQU	$
		ORA	#03000H
		STA	!OAM+2		;LN^[ Zbg
;
		M8			; memory 8bit mode
		LDA	#002H
		STA	!OAMSUB
		PLB
		RTS
;
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+		J[\ N Zbg			+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
CSLWAKU_DAT	EQU	$
		BYTE	000H,001H,002H,003H,004H,005H,0FFH,0FFH
		BYTE	006H,007H,008H,009H,00AH,00BH,0FFH,0FFH
		BYTE	00CH,00DH,00EH,00FH,010H,011H,0FFH,0FFH
		BYTE	012H,013H,014H,015H,016H,017H,0FFH,0FFH
		BYTE	018H,019H,01AH,01BH,01CH,01DH,0FFH,0FFH
		BYTE	01EH,01FH,020H,021H,022H,023H,0FFH,0FFH
;
;
CSLWAKU		EQU	$
		LDA	!MOUSEBT
		AND	#01000000B	; }EXNbN ?
		BEQ	CSLWAKU_900	;	NO -> CSLWAKU_900
		LDA	!CRXPSL2
		CMP	#030H
		BCC	CSLWAKU_900
		CMP	#0F0H
		BCS	CSLWAKU_900
		SEC
		SBC	#030H
		AND	#0F0H
		M16			; memory 16bit mode
		ASL	A
		ASL	A
		ASL	A
		XBA
		M8			; memory 8bit mode
		AND	#007H
		STA	<WORK0
		LDA	!CRYPSL2
		CMP	#014H
		BCC	CSLWAKU_900
		CMP	#074H
		BCS	CSLWAKU_900
		SEC
		SBC	#014H
		AND	#0F0H
		LSR	A
		ORA	<WORK0
		TAY
		LDA	CSLWAKU_DAT,Y	;J[\ N CfbNX
		M16			; mmeory 16bit mode
		AND	#0003FH
		STA	!CSLWKIDX
		M8			; mmeory 8bit mode
CSLWAKU_900	EQU	$
		RTS
;
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+		^Cv f[^ XN[		+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
CHRSCR_DT0	EQU	$
		BYTE	0FFH,001H
;
CHRSCR_DT1	EQU	$
		BYTE	006H,0FAH
;
;
CHRSCR		EQU	$
		LDA	!MOUSEBT
		AND	#01000000B	; }EXNbN ?
		BEQ	CHRSCR_900	;	NO -> CHRSCR_900
		LDA	!CRXPSL2
		CMP	#008H
		BCC	CHRSCR_900
		CMP	#018H
		BCS	CHRSCR_900
;
		LDA	!CRYPSL2
		CMP	#020H
		BCC	CHRSCR_900
		CMP	#030H
		BCS	CHRSCR_050
		LDY	#000H
		BRA	CHRSCR_080
CHRSCR_050	EQU	$
		CMP	#058H
		BCC	CHRSCR_900
		CMP	#068H
		BCS	CHRSCR_900
		LDY	#001H
;
CHRSCR_080	EQU	$
		LDA	!CHRSCRCT
		CLC
		ADC	CHRSCR_DT0,Y
		BMI	CHRSCR_900
		CMP	#07BH
		BCS	CHRSCR_900
		STA	!CHRSCRCT
		CMP	#079H
		BCS	CHRSCR_100
		LSR	A
		LSR	A
		STA	!SCRBAR
;
CHRSCR_100	EQU	$
		LDA	!CSLWKIDX
		CLC
		ADC	CHRSCR_DT1,Y
		BMI	CHRSCR_200
		CMP	#024H
		BCS	CHRSCR_200
		STA	!CSLWKIDX
;
CHRSCR_200	EQU	$
		JSR	CHRSCR_NO
;
CHRSCR_900	EQU	$
		RTS
;
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+		XN[ o[ ړ			+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
SCRBARST	EQU	$
		LDA	!CRXPSL2	;
		CMP	#00AH		; XN[ o[
		BCC	SCRBARST_900	;	͈͓ ?
		CMP	#015H		;	NO -> SCRBARST_900
		BCS	SCRBARST_900	;
		LDA	!CRYPSL2	;
		CMP	#030H		;
		BCC	SCRBARST_900	;
		CMP	#058H		;
		BCS	SCRBARST_900	;
		LDA	!MOUSEBB
		AND	#01000000B	; }EXNbN ?
		BEQ	SCRBARST_900	;	NO -> SCRBARST_900
;
		LDA	!CRYPSL2
		CMP	#04EH
		BCC	SCRBARST_200
		LDA	#04EH
SCRBARST_200	EQU	$
		SEC
		SBC	#030H
		BMI	SCRBARST_900
		CMP	#01FH
		BCS	SCRBARST_900
		STA	!SCRBAR
		ASL	A
		ASL	A
		STA	!CHRSCRCT
;
		JSR	CHRSCR_NO
;
SCRBARST_900	EQU	$
		RTS
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	^Cv f[^ obt@		+
;+		^Cv mn. Zbg		+
;++++++++++++++++++++++++++++++++++++++++++++++++
CHRSCR_NO	EQU	$
		LDA	!CHRSCRCT
		STA	<WORK0
		I16			; index 16bit mode
		LDX	#0000H
CHRSCR_NO_100	EQU	$
		LDA	<WORK0
		AND	#00FH
		ORA	#0F0H
		STA	!OBJTPBF+008H,X
		LDA	<WORK0
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		BNE	CHRSCR_NO_150
		LDA	#0A6H
		BRA	CHRSCR_NO_155
CHRSCR_NO_150	EQU	$
		ORA	#0F0H
CHRSCR_NO_155	EQU	$
		STA	!OBJTPBF+006H,X
		INC	<WORK0
		M16			; memory 16bit mode
		TXA
		CLC
		ADC	#00080H
		TAX
		M8			; memory 8bit mode
		CPX	#00300H
		BCC	CHRSCR_NO_100
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	^Cv f[^ obt@ Zbg		+
;++++++++++++++++++++++++++++++++++++++++++++++++
CHRSCR_BF_SET	EQU	$
		MI16			; memory , index 16bit mode
		LDA	!CHRSCRCT
		AND	#000FFH
		ASL	A
		STA	<WORK0
		ASL	A
		CLC
		ADC	<WORK0
		TAX
		M8			; memory 8bit mode
		LDY	#00000H
;
CHRSCR_BF_LOP	EQU	$
		M16			; memory 16bit mode
		LDA	CHRSTINT_RAM,Y
		STA	<WORK0
		INC	A
		INC	A
		STA	<WORK2
		INC	A
		INC	A
		STA	<WORK4
		PHY
		LDA	>CHRDTBF,X
		AND	#000FFH
		ASL	A
		STA	<WORKE
		ASL	A
;;;;K;;;;		CLC
		ADC	<WORKE
		TAY
		M8			; memory 8bit mode
		LDA	CHRDATA,Y
		STA	(<WORK0)
		LDA	CHRDATA+2,Y
		STA	(<WORK2)
		LDA	CHRDATA+4,Y
		STA	(<WORK4)
		PLY
		INX
		INY
		INY
		CPY	#CHRSTINT-CHRSTINT_RAM
		BCC	CHRSCR_BF_LOP
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	^Cv f[^ obt@ cl`]	+
;++++++++++++++++++++++++++++++++++++++++++++++++
		M16			; memory 16bit mode
		PHB			;(DBR) save
		PEA	VRAMD/100H	;(DBR) <-- VRAMDX(B)
		PLB
		PLB
;
		LDY	!VRAMDX		;(X) <-- VRAMDX set pointer
		LDA	#07460H
		STA	0,Y		;VRAM address set
		LDA	#10000000B+(00000001B*100H)
		STA	2,Y		;VRAM address inc mode & DMA parameter
		LDA	#018H
		STA	4,Y		;B bus address set
		LDA	#OBJTPBF
		STA	5,Y		;A bus address(L,H) set
		LDA	#BANK OBJTPBF
		STA	7,Y		;	:	(B) set
		LDA	#002C0H
		STA	8,Y
		TYA
		CLC
		ADC	#12
		STA	10,Y		;next data address set
		STA	!VRAMDX		;end address set
;
		PLB
		MI8			; memory , index 8bit mode
		RTS
;
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+		J[\ N IuWF Zbg		+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
CSLWKOBJ_ADR	EQU	$
		WORD	0142CH,0144CH,0146CH,0148CH,014ACH,014CCH
		WORD	0242CH,0244CH,0246CH,0248CH,024ACH,024CCH
		WORD	0342CH,0344CH,0346CH,0348CH,034ACH,034CCH
		WORD	0442CH,0444CH,0446CH,0448CH,044ACH,044CCH
		WORD	0542CH,0544CH,0546CH,0548CH,054ACH,054CCH
		WORD	0642CH,0644CH,0646CH,0648CH,064ACH,064CCH
;
;
CSLWKOBJ	EQU	$
		MI16			; memory , index 16bit mode
		LDA	!CSLWKIDX
		ASL	A
		TAY
		LDA	CSLWKOBJ_ADR,Y
		STA	>OAM+10H
		CLC
		ADC	#00010H
		STA	>OAM+14H
		LDA	#03004H
		STA	>OAM+12H
		LDA	#03006H
		STA	>OAM+16H
		MI8			; memory , index 8bit mode
		LDA	#02AH
		STA	!OAMSUB+1
		RTS
;
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+		mdws  a`bj			+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
NXTBCK_DAT	EQU	$-1
		BYTE	001H,0FFH
;
NXTBCK_ADR	EQU	$
		WORD	168C00H,16B200H,16B400H,16B600H
;
NXTBCK_ADR_END	EQU	$
;
;
NXTBCK		EQU	$
		LDA	<WORK0
		AND	#00FH
		TAY
		LDA	!NTBKCNT
		CLC
		ADC	NXTBCK_DAT,Y
		BMI	NXTBCK_000
		CMP	#(NXTBCK_ADR_END-NXTBCK_ADR)/2
		BCS	NXTBCK_000
		STA	!NTBKCNT
NXTBCK_000	EQU	$
		LDA	!NTBKCNT
		ASL	A
		MI16			; memory , index 16bit mode
		AND	#000FFH
		TAX
;
		PHB			;(DBR) save
		PEA	VRAMD/100H	;(DBR) <-- VRAMDX(B)
		PLB
		PLB
;
		LDY	!VRAMDX		;(X) <-- VRAMDX set pointer
		LDA	#07400H+0200H
		STA	0,Y		;VRAM address set
		LDA	#10000000B+(00000001B*100H)
		STA	2,Y		;VRAM address inc mode & DMA parameter
		LDA	#018H
		STA	4,Y		;B bus address set
		LDA	>NXTBCK_ADR,X
		STA	5,Y		;A bus address(L,H) set
		LDA	#BANK 168C00H
		STA	7,Y		;	:	(B) set
		LDA	#00200H
		STA	8,Y
		TYA
		CLC
		ADC	#12
		STA	10,Y		;next data address set
		STA	!VRAMDX		;end address set
;
		PLB
		MI8			; memory , index 8bit mode
		RTS
;
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+	LN^[ oN mn. Zbg		+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
CHRDT_SET	EQU	$
		MI16			; memory , index 16bit mode
		LDA	!CHRSCRCT
		AND	#000FFH
		ASL	A
		STA	<WORK2
		ASL	A
		CLC
		ADC	<WORK2
		CLC
		ADC	!CSLWKIDX
		TAX
		M8			; memory 8bit mode
		LDA	<WORK0
		STA	>CHRDTBF,X
		I8			; index 8bit mode
;
		JSR	CHRSCR_BF_SET
;
		RTS
;
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+	XN[ o[ naiZbg			+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
SCRBAROBJST	EQU	$
		LDA	#008H
		STA	>OAM+18H
		LDA	!SCRBAR
		CLC
		ADC	#030H
		STA	>OAM+19H
		LDA	#008H
		STA	>OAM+1AH	; LN^[mn.
		LDA	#030H
		STA	>OAM+1BH	; Agr[g
		RTS
;
;
;****************************************************************
;*								*
;*		Gf[^ ړ[h				*
;*								*
;****************************************************************
EN_ALL_ADD	EQU	$
		BYTE	0FFH,001H
;
EN_ALL_ADR	EQU	$
		WORD	STATNOSET	; X^[gjbgm.
		WORD	ENDNOSET	; Ghjbgm.
		WORD	X_SIFTST	; w Vtg
		WORD	Y_SIFTST	; x Vtg
		WORD	SIFT_RAN	; Vtg X^[g!!
;
;
EN_ALL_MOVE	EQU	$
		LDA	!MOUSEBT
		AND	#10000000B	; }EXENbN ?
		BNE	EN_MOVE_000	;	YES -> EN_MOVE_000
		LDA	!INKEY
		CMP	#L_I		;[I] ON ?
		BNE	EN_MOVE_100	;	NO -> EN_MOVE_100
EN_MOVE_000	EQU	$
		LDA	#ITSB
		STA	!MODENO
		STZ	!STINFG
		JMP	EN_MOVE_900
;
EN_MOVE_100	EQU	$
		LDA	!INKEY2
		CMP	#LEF
		BEQ	EN_MOVE_110
		CMP	#RIT
		BNE	EN_MOVE_200
EN_MOVE_110	EQU	$
		AND	#001
		TAX
		LDA	!UNTMVMD
		AND	#07FH
		CLC
		ADC	EN_ALL_ADD,X
		CMP	#005
		BCS	EN_MOVE_200
		STA	!UNTMVMD
;
EN_MOVE_200	EQU	$
		JSR	EN_MV_OBJ
;
		LDA	!UNTMVMD
		AND	#07FH
		ASL	A
		TAX
		JSR	(EN_ALL_ADR,X)
;
EN_MOVE_900	EQU	$
		RTS
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+		X^[gjbgm.			+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
STATNOSET	EQU	$
		LDA	!OAM+100H+(EN_MV_OBJ_DT0-EN_MV_OBJ_DT)+03H
		EOR	#002H
		STA	!OAM+100H+(EN_MV_OBJ_DT0-EN_MV_OBJ_DT)+03H
		STA	!OAM+100H+(EN_MV_OBJ_DT0-EN_MV_OBJ_DT)+07H
		STA	!OAM+100H+(EN_MV_OBJ_DT0-EN_MV_OBJ_DT)+0BH
		STA	!OAM+100H+(EN_MV_OBJ_DT0-EN_MV_OBJ_DT)+0FH
		LDA	<FRCNT
		AND	#010H
		BNE	STATNOSET_000
		LDA	!UNTMVMD
		CLC
		AND	#080H
		ROL	A
		ROL	A
		ROL	A
		ROL	A
		TAX
		LDA	!OAM+100H+(EN_MV_OBJ_DT0-EN_MV_OBJ_DT)+0BH,X
		EOR	#002H
		STA	!OAM+100H+(EN_MV_OBJ_DT0-EN_MV_OBJ_DT)+0BH,X
STATNOSET_000	EQU	$
		LDA	!STUNTNO0
		STA	<WORK0
		JSL	>STUNT0_SB_ST
		LDA	<WORK0
		STA	!STUNTNO0
		RTS
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+		Ghjbgm.			+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
ENDNOSET	EQU	$
		LDA	!OAM+100H+(EN_MV_OBJ_DT2-EN_MV_OBJ_DT)+03H
		EOR	#002H
		STA	!OAM+100H+(EN_MV_OBJ_DT2-EN_MV_OBJ_DT)+03H
		STA	!OAM+100H+(EN_MV_OBJ_DT2-EN_MV_OBJ_DT)+07H
		STA	!OAM+100H+(EN_MV_OBJ_DT2-EN_MV_OBJ_DT)+0BH
		STA	!OAM+100H+(EN_MV_OBJ_DT2-EN_MV_OBJ_DT)+0FH
		LDA	<FRCNT
		AND	#010H
		BNE	ENDNOSET_000
		LDA	!UNTMVMD
		CLC
		AND	#080H
		ROL	A
		ROL	A
		ROL	A
		ROL	A
		TAX
		LDA	!OAM+100H+(EN_MV_OBJ_DT2-EN_MV_OBJ_DT)+0BH,X
		EOR	#002
		STA	!OAM+100H+(EN_MV_OBJ_DT2-EN_MV_OBJ_DT)+0BH,X
ENDNOSET_000	EQU	$
		LDA	!STUNTNO1
		STA	<WORK0
		JSL	>STUNT0_SB_ST
		LDA	<WORK0
		STA	!STUNTNO1
		RTS
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+		w Vtg				+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
X_SIFTST	EQU	$
		LDA	!OAM+100H+(EN_MV_OBJ_DT3-EN_MV_OBJ_DT)+03H
		EOR	#002H
		STA	!OAM+100H+(EN_MV_OBJ_DT3-EN_MV_OBJ_DT)+03H
		STA	!OAM+100H+(EN_MV_OBJ_DT3-EN_MV_OBJ_DT)+07H
		STA	!OAM+100H+(EN_MV_OBJ_DT3-EN_MV_OBJ_DT)+0BH
		STA	!OAM+100H+(EN_MV_OBJ_DT3-EN_MV_OBJ_DT)+0FH
		STA	!OAM+100H+(EN_MV_OBJ_DT3-EN_MV_OBJ_DT)+13H
		LDA	<FRCNT
		AND	#010H
		BNE	X_SIFTST_000
		LDA	!UNTMVMD
		CLC
		AND	#080H
		ROL	A
		ROL	A
		ROL	A
		ROL	A
		TAX
		LDA	!OAM+100H+(EN_MV_OBJ_DT3-EN_MV_OBJ_DT)+0FH,X
		EOR	#002
		STA	!OAM+100H+(EN_MV_OBJ_DT3-EN_MV_OBJ_DT)+0FH,X
X_SIFTST_000	EQU	$
		LDA	!INKEY2
		CMP	#UPP
		BEQ	X_SIFTST_010
		CMP	#DWN
		BNE	X_SIFTST_020
X_SIFTST_010	EQU	$
		LDA	!SIFTX+1
		EOR	#0FFH
		STA	!SIFTX+1
X_SIFTST_020	EQU	$
		LDA	!SIFTX
		STA	<WORK0
		JSL	>STUNT0_SB_ST
		LDA	<WORK0
		STA	!SIFTX
		RTS
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+		x Vtg				+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
Y_SIFTST	EQU	$
		LDA	!OAM+100H+(EN_MV_OBJ_DT4-EN_MV_OBJ_DT)+03H
		EOR	#002H
		STA	!OAM+100H+(EN_MV_OBJ_DT4-EN_MV_OBJ_DT)+03H
		STA	!OAM+100H+(EN_MV_OBJ_DT4-EN_MV_OBJ_DT)+07H
		STA	!OAM+100H+(EN_MV_OBJ_DT4-EN_MV_OBJ_DT)+0BH
		STA	!OAM+100H+(EN_MV_OBJ_DT4-EN_MV_OBJ_DT)+0FH
		STA	!OAM+100H+(EN_MV_OBJ_DT4-EN_MV_OBJ_DT)+13H
		LDA	<FRCNT
		AND	#010H
		BNE	Y_SIFTST_000
		LDA	!UNTMVMD
		CLC
		AND	#080H
		ROL	A
		ROL	A
		ROL	A
		ROL	A
		TAX
		LDA	!OAM+100H+(EN_MV_OBJ_DT4-EN_MV_OBJ_DT)+0FH,X
		EOR	#002
		STA	!OAM+100H+(EN_MV_OBJ_DT4-EN_MV_OBJ_DT)+0FH,X
Y_SIFTST_000	EQU	$
		LDA	!INKEY2
		CMP	#UPP
		BEQ	Y_SIFTST_010
		CMP	#DWN
		BNE	Y_SIFTST_020
Y_SIFTST_010	EQU	$
		LDA	!SIFTY+1
		EOR	#0FFH
		STA	!SIFTY+1
Y_SIFTST_020	EQU	$
		LDA	!SIFTY
		STA	<WORK0
		JSL	>STUNT0_SB_ST
		LDA	<WORK0
		STA	!SIFTY
		RTS
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+		Vtg X^[g!!			+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
SIFT_RAN	EQU	$
		LDA	<FRCNT
		AND	#010H
		BNE	SIFT_RAN_000
		LDA	!OAM+100H+(EN_MV_OBJ_DT5-EN_MV_OBJ_DT)+03H
		EOR	#002
		STA	!OAM+100H+(EN_MV_OBJ_DT5-EN_MV_OBJ_DT)+03H
		STA	!OAM+100H+(EN_MV_OBJ_DT5-EN_MV_OBJ_DT)+07H
		STA	!OAM+100H+(EN_MV_OBJ_DT5-EN_MV_OBJ_DT)+0BH
SIFT_RAN_000	EQU	$
		LDA	!INKEY2
		CMP	#RTN
		BNE	SIFT_RAN_900
		INC	!STINFG
SIFT_RAN_900	EQU	$
		RTS
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+	Gf[^ ړ[h IuWF Zbg		+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
EN_MV_OBJ_DT	EQU	$
		BYTE	028H,0B0H,050H,032H	;
		BYTE	030H,0B0H,054H,032H	; "p^["
		BYTE	038H,0B0H,052H,032H	;
		BYTE	040H,0B0H,04EH,032H	;
;
EN_MV_OBJ_DT0	EQU	$
		BYTE	050H,0B0H,04EH,032H	;
		BYTE	058H,0B0H,04FH,032H	; "mDOO"
		BYTE	050H,0B9H,070H,032H	;
		BYTE	058H,0B9H,070H,032H	;
;
EN_MV_OBJ_DT1	EQU	$
		BYTE	064H,0B3H,026H,033H	; "`"
		BYTE	06CH,0B3H,027H,033H	;
;
EN_MV_OBJ_DT2	EQU	$
		BYTE	075H,0B0H,04EH,032H	;
		BYTE	07DH,0B0H,04FH,032H	; "mDOO"
		BYTE	075H,0B9H,070H,032H	;
		BYTE	07DH,0B9H,070H,032H	;
;
EN_MV_OBJ_DT3	EQU	$
		BYTE	08DH,0B0H,058H,032H	;
		BYTE	096H,0B0H,05FH,032H	; "wQ{OO"
		BYTE	09FH,0B0H,02BH,032H	;
		BYTE	0A6H,0B0H,070H,032H	;
		BYTE	0AEH,0B0H,070H,032H	;
;
EN_MV_OBJ_DT4	EQU	$
		BYTE	08DH,0B9H,059H,032H	;
		BYTE	096H,0B9H,05FH,032H	; "xQ{OO"
		BYTE	09FH,0B9H,02BH,032H	;
		BYTE	0A6H,0B9H,070H,032H	;
		BYTE	0AEH,0B9H,070H,032H	;
;
EN_MV_OBJ_DT5	EQU	$
		BYTE	0C0H,0B9H,052H,032H	;
		BYTE	0C8H,0B9H,055H,032H	; "q`m"
		BYTE	0D0H,0B9H,04EH,032H	;
EN_MV_OBJ_DT_ED	EQU	$
;
;
EN_MV_OBJ	EQU	$
		MI16			; memory , index 16bit mode
		LDX	#0000H
EN_MV_OBJ_OAM	EQU	$
		LDA	EN_MV_OBJ_DT,X
		STA	!OAM+100H,X
		INX
		INX
		CPX	#EN_MV_OBJ_DT_ED-EN_MV_OBJ_DT
		BCC	EN_MV_OBJ_OAM
		MI8			; memory , index 8bit mode
;
		LDA	!STUNTNO0	;X^[gm.
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		ORA	#070H
		STA	!OAM+100H+(EN_MV_OBJ_DT0-EN_MV_OBJ_DT)+0AH
		LDA	!STUNTNO0
		AND	#00FH
		ORA	#070H
		STA	!OAM+100H+(EN_MV_OBJ_DT0-EN_MV_OBJ_DT)+0EH
;
		LDA	!STUNTNO1	;Ghm.
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		ORA	#070H
		STA	!OAM+100H+(EN_MV_OBJ_DT2-EN_MV_OBJ_DT)+0AH
		LDA	!STUNTNO1
		AND	#00FH
		ORA	#070H
		STA	!OAM+100H+(EN_MV_OBJ_DT2-EN_MV_OBJ_DT)+0EH
;
		LDA	!SIFTX+1	;wtO
		BPL	EN_MV_OBJ_310
		LDA	#02DH
		STA	!OAM+100H+(EN_MV_OBJ_DT3-EN_MV_OBJ_DT)+0AH
EN_MV_OBJ_310	EQU	$
		LDA	!SIFTX		;wړ
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		ORA	#070H
		STA	!OAM+100H+(EN_MV_OBJ_DT3-EN_MV_OBJ_DT)+0EH
		LDA	!SIFTX
		AND	#00FH
		ORA	#070H
		STA	!OAM+100H+(EN_MV_OBJ_DT3-EN_MV_OBJ_DT)+12H
;
		LDA	!SIFTY+1	;xtO
		BPL	EN_MV_OBJ_320
		LDA	#02DH
		STA	!OAM+100H+(EN_MV_OBJ_DT4-EN_MV_OBJ_DT)+0AH
EN_MV_OBJ_320	EQU	$
		LDA	!SIFTY		;xړ
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		ORA	#070H
		STA	!OAM+100H+(EN_MV_OBJ_DT4-EN_MV_OBJ_DT)+0EH
		LDA	!SIFTY
		AND	#00FH
		ORA	#070H
		STA	!OAM+100H+(EN_MV_OBJ_DT4-EN_MV_OBJ_DT)+12H
;
		RTS
;
;
;****************************************************************
;*								*
;*		Gf[^ Vtg X^[g !!			*
;*								*
;****************************************************************
ENMY_SIFT	EQU	$
		INC	!ALL_UDFG
		PHB
		MI16			; memory , index 16bit mode
		LDA	>ENMYDTBF
		INC	A
		STA	<WORK0
		ASL	A
		ASL	A
		ASL	A
		CLC
		SBC	<WORK0
		LDX	#ENMYDTBF
		LDY	#UNDO_ENDATA
		MVN	#BANK ENMYDTBF,#BANK UNDO_ENDATA
		MI8			; memory , index 8bit mode
		PLB
;
		STZ	<WORKB
		LDA	!SIFTX
		STA	<WORKA
		LDA	!SIFTX+1
		BPL	ENMY_SIFT_020
		LDA	!SIFTX
		EOR	#0FFH
		INC	A
		STA	<WORKA
		LDA	#0FFH
		STA	<WORKB
ENMY_SIFT_020	EQU	$
		STZ	<WORKD
		LDA	!SIFTY
		STA	<WORKC
		LDA	!SIFTY+1
		BPL	ENMY_SIFT_100
		LDA	!SIFTY
		EOR	#0FFH
		INC	A
		STA	<WORKC
		LDA	#0FFH
		STA	<WORKD
;
ENMY_SIFT_100	EQU	$
		MI16			; memory , index 16bit mode
		LDA	!STUNTNO0
		AND	#000FFH
		STA	<WORK10
		ASL	A
		ASL	A
		ASL	A
		SEC
		SBC	<WORK10
		TAX
		M8			; memory 8bit mode
ENMY_SIFT_200	EQU	$
		LDA	<WORK10
		CMP	!STUNTNO1
		BCS	ENMY_SIFT_900
		LDA	>ENMYDTBF
		BCS	ENMY_SIFT_900
;
		M16			; memory 16bit mode
		LDA	>ENDTBF+6,X	; wW Vtg
		AND	#000FFH
		CLC
		ADC	<WORKA
		AND	#000FFH
		STA	<WORK12
		LDA	>ENDTBF+6,X
		AND	#0FF00H
		ORA	<WORK12
		STA	>ENDTBF+6,X
;
ENMY_SIFT_240	EQU	$
		LDA	>ENDTBF+5,X	; xW Vtg
		AND	#000FFH
		LSR	A
		CLC
		ADC	<WORKC
		BMI	ENMY_SIFT_280
		CMP	#00080H
		BCS	ENMY_SIFT_280
		ASL	A
		AND	#000FFH
		STA	<WORK12
		LDA	>ENDTBF+5,X
		AND	#0FF00H
		ORA	<WORK12
		STA	>ENDTBF+5,X
;
ENMY_SIFT_280	EQU	$
		M8			; memory 8bit mode
		INX
		INX
		INX
		INX
		INX
		INX
		INX
		INC	<WORK10
		BRA	ENMY_SIFT_200
;
ENMY_SIFT_900	EQU	$
		I8			; index 8bit mode
		LDA	#ITSB
		STA	!MODENO
		STZ	!STINFG
		RTS
;
;
;
;
;
;
		END
;
