;************************************************************************
;*									*
;*	title name	: "yossy map tool"				*
;*	proccess	: map data edit file mode			*
;*	file name	: ysm_file					*
;*									*
;************************************************************************
;
;
		SALL
;
		include		ysm_header.inc
;
		XALL
;
;
;------------------------------------------------------------------------
;-		global symbol						-
;------------------------------------------------------------------------
		GLB	FILEIN,FILEMV,UNMPBF
		GLB	MDBAD
;
;------------------------------------------------------------------------
;-		extern symbol						-
;------------------------------------------------------------------------
;
;-------------<	ysm_main >-----------------------------------------------
		EXT	VRAMCL,OAMCLR,BLNKOFF,URAMCLR
		EXT	EDT0
;
;-------------<	ysm_rpro >-----------------------------------------------
		EXT	NEWVMADL,CHIPON,BLNKON
		EXT	KYREAD
;
;-------------<	ysm_init >-----------------------------------------------
		EXT	GMMDST
		EXT	ED00,FL00
;
;-------------<	ysm_title >----------------------------------------------
		EXT	MODINC,MODINC2
;
;------------------------------------------------------------------------
;-		define symbol						-
;------------------------------------------------------------------------
;
;
;
;************************************************************************
;*									*
;*		program start						*
;*									*
;************************************************************************
;
;
;
		EXTEND
;
;
		MEM8
		IDX8
;
Group_1		GROUP	File_pro
File_pro	SECT	REL
;
;
;************************************************************************
;*		map data edit file mode initial				*
;************************************************************************
;
FILEIN		EQU	$
		JSL	>VRAMCL		;VRAM clear
		JSL	>URAMCLR	;use RAM clear
;
;--------------	PPU Reg. initial set ----------------------------
		LDX	#FL00		;(X) <-- map mode type no.
		JSL	>GMMDST		;game mode set
;
;--------------	mode 0 character set ----------------------------
;
		M16			; memory 16bit mode
;
		LDY	#10000000B
		STY	2115H		;inc mode set
		LDA	#6000H
		STA	2116H		;VRAM address set
		LDA	#00000001B+(18H*100H)
		STA	4300H		;DMA parameter & B bus address set
		LDA	#099800H
		STA	4302H		;A bus address(L,H) set
		LDY	#BANK 099800H
		STY	4304H		;	"     (B) set
		LDA	#01000H
		STA	4305H		;number of byte set
		LDX	#00000001B
		STX	420BH		;DMA "ON"
;
;--------------	mode 0 screen write -----------------------------
		LDA	#7C00H
		STA	2116H		;VRAM address set
		LDA	#00000001B+(18H*100H)
		STA	4300H		;DMA parameter & B bus address set
		LDA	#09B800H
		STA	4302H		;A bus address(L,H) set
;;;;		LDY	#BANK 09B800H
;;;;		STY	4304H		;	"     (B) set
		LDA	#0800H
		STA	4305H		;number of byte set
		STX	420BH		;DMA "ON"
;
;--------------	OBJ character set -------------------------------
		LDA	#4000H
		STA	2116H		;VRAM address set
		LDA	#00000001B+(18H*100H)
		STA	4300H		;DMA parameter & B bus address set
		LDA	#098000H
		STA	4302H		;A bus address(L,H) set
;;;;		LDY	#BANK 098000H
;;;;		STY	4304H		;	"     (B) set
		LDA	#0400H
		STA	4305H		;number of byte set
		STX	420BH		;DMA "ON"
;
;-------------- mo-ji set 0 -------------------------------------
		PHB
		PHK
		PLB
;
		LDA	#07C41H
		STA	2116H		; VRAM address set
		LDA	#MJDAT0
		STA	<WORK0
		JSR	MJSET0		; mo-ji set
;
		LDA	#07C61H
		STA	2116H		; VRAM address set
		LDA	#MJDAT1
		STA	<WORK0
		JSR	MJSET0		; mo-ji set
;
		LDA	#07C81H
		STA	2116H		; VRAM address set
		LDA	#MJDAT2
		STA	<WORK0
		JSR	MJSET0		; mo-ji set
;
		LDA	#07CA1H
		STA	2116H		; VRAM address set
		LDA	#MJDAT3
		STA	<WORK0
		JSR	MJSET0		; mo-ji set
;
		LDA	#07CC1H
		STA	2116H		; VRAM address set
		LDA	#MJDAT4
		STA	<WORK0
		JSR	MJSET0		; mo-ji set
;
		LDA	#07CE1H
		STA	2116H		; VRAM address set
		LDA	#MJDAT5
		STA	<WORK0
		JSR	MJSET0		; mo-ji set
;
		LDA	#07D01H
		STA	2116H		; VRAM address set
		LDA	#MJDAT6
		STA	<WORK0
		JSR	MJSET0		; mo-ji set
;
		LDA	#07D21H
		STA	2116H		; VRAM address set
		LDA	#MJDAT7
		STA	<WORK0
		JSR	MJSET0		; mo-ji set
;
		LDA	#07D41H
		STA	2116H		; VRAM address set
		LDA	#MJDAT8
		STA	<WORK0
		JSR	MJSET0		; mo-ji set
;
;-------------- mo-ji set 1 -------------------------------------
		LDA	#00000000B
		STA	2115H		; inc mode set
		LDA	#07C4BH
		STA	<WORK0
		LDA	#MOJBFA
		STA	<WORK2
		JSR	MJSET1		; mo-ji set
;
		LDA	#07C6BH
		STA	<WORK0
		LDA	#MOJBFB
		STA	<WORK2
		JSR	MJSET1		; mo-ji set
;
		LDA	#07C8BH
		STA	<WORK0
		LDA	#MOJBFC
		STA	<WORK2
		JSR	MJSET1		; mo-ji set
;
		LDA	#07CABH
		STA	<WORK0
		LDA	#MOJBFD
		STA	<WORK2
		JSR	MJSET1		; mo-ji set
;
		LDA	#07CCBH
		STA	<WORK0
		LDA	#MOJBFE
		STA	<WORK2
		JSR	MJSET1		; mo-ji set
;
		LDA	#07CEBH
		STA	<WORK0
		LDA	#MOJBFF
		STA	<WORK2
		JSR	MJSET1		; mo-ji set
;
		LDA	#07D0BH
		STA	<WORK0
		LDA	#MOJBFG
		STA	<WORK2
		JSR	MJSET1		; mo-ji set
;
		LDA	#07D2BH
		STA	<WORK0
		LDA	#MOJBFH
		STA	<WORK2
		JSR	MJSET1		; mo-ji set
;
		LDA	#07D4BH
		STA	<WORK0
		LDA	#MOJBFP
		STA	<WORK2
		JSR	MJSET1		; mo-ji set
;
		PLB
;
;--------------	color set ---------------------------------------
;
		M8
		I16
;
		LDX	#200H-1
FLIN010		EQU	$
		LDA	>09D200H,X
		STA	>DATACOL,X
		DEX
		BPL	FLIN010
;
		I8
;
;
		STZ	!FILFGS
		STZ	!MDSTFG
		STZ	!FLBFIDX
		STZ	!SCRLBF
		STZ	!SCRLBF+1
		LDA	#080H
		STA	!FILFLG
		STA	!SRCFLG
;
;--------------	sfx-dos start -----------------------------------
		DOS	_DOSRST
;
;--------------	go to next mode !! ------------------------------
		JMP	>MODINC2	;go to next mode !!
;
;
;++++++++++++++++++++++++++++++++++++++++
;+					+
;+	mo-ji set			+
;+					+
;++++++++++++++++++++++++++++++++++++++++
		MEM16
MJSET0		EQU	$
		LDY	#000H
MJSTLP		EQU	$
		LDA	(<WORK0),Y
		STA	2118H
		INY
		INY
		CPY	#02EH
		BNE	MJSTLP
		RTS
;
MJSET1		EQU	$
		LDA	<WORK0
		STA	2116H		; VRAM address set
		LDA	#00000000B+(18H*100H)
		STA	4300H		; DMA parameter & B bus address set
		LDA	<WORK2
		STA	4302H		; A bus address(L,H) set
		LDY	#BANK MOJBFA
		STY	4304H		;        "     (B) set
		LDA	#00008H
		STA	4305H		; number of byte set
		STX	420BH		; DMA "ON"
		RTS
		MEM8
;
;
MJDAT0		EQU	$
		WORD	0004DH,00041H,00050H,000C3H,000DEH,0002DH
		WORD	000C0H,00041H,00020H,0005BH,00020H,00020H
		WORD	00020H,00020H,00020H,00020H,00020H,00020H
		WORD	0002EH,0004DH,00050H,00044H,0005DH
;
MJDAT1		EQU	$
		WORD	0004DH,00041H,00050H,000C3H,000DEH,0002DH
		WORD	000C0H,00042H,00020H,0005BH,00020H,00020H
		WORD	00020H,00020H,00020H,00020H,00020H,00020H
		WORD	0002EH,0004DH,00050H,00044H,0005DH
;
MJDAT2		EQU	$
		WORD	0004DH,00041H,00050H,000C3H,000DEH,0002DH
		WORD	000C0H,00043H,00020H,0005BH,00020H,00020H
		WORD	00020H,00020H,00020H,00020H,00020H,00020H
		WORD	0002EH,0004DH,00050H,00044H,0005DH
;
MJDAT3		EQU	$
		WORD	0004DH,00041H,00050H,000C3H,000DEH,0002DH
		WORD	000C0H,00044H,00020H,0005BH,00020H,00020H
		WORD	00020H,00020H,00020H,00020H,00020H,00020H
		WORD	0002EH,0004DH,00050H,00044H,0005DH
;
MJDAT4		EQU	$
		WORD	0004DH,00041H,00050H,000C3H,000DEH,0002DH
		WORD	000C0H,00045H,00020H,0005BH,00020H,00020H
		WORD	00020H,00020H,00020H,00020H,00020H,00020H
		WORD	0002EH,0004DH,00050H,00044H,0005DH
;
MJDAT5		EQU	$
		WORD	0004DH,00041H,00050H,000C3H,000DEH,0002DH
		WORD	000C0H,00046H,00020H,0005BH,00020H,00020H
		WORD	00020H,00020H,00020H,00020H,00020H,00020H
		WORD	0002EH,0004DH,00050H,00044H,0005DH
;
MJDAT6		EQU	$
		WORD	0004DH,00041H,00050H,000C3H,000DEH,0002DH
		WORD	000C0H,00047H,00020H,0005BH,00020H,00020H
		WORD	00020H,00020H,00020H,00020H,00020H,00020H
		WORD	0002EH,0004DH,00050H,00044H,0005DH
;
MJDAT7		EQU	$
		WORD	0004DH,00041H,00050H,000C3H,000DEH,0002DH
		WORD	000C0H,00048H,00020H,0005BH,00020H,00020H
		WORD	00020H,00020H,00020H,00020H,00020H,00020H
		WORD	0002EH,0004DH,00050H,00044H,0005DH
;
MJDAT8		EQU	$
		WORD	000CEH,000DFH,000B2H,000DDH,000C4H,000C3H
		WORD	000DEH,0002DH,000C0H,0005BH,00020H,00020H
		WORD	00020H,00020H,00020H,00020H,00020H,00020H
		WORD	0002EH,00050H,00044H,00054H,0005DH
;
;
;************************************************************************
;*		map data edit file mode move				*
;************************************************************************
;
FILEMV		EQU	$
;
;--------------	key input ---------------------------------------
		JSL	>KYREAD
;
;--------------	mouse cursol set --------------------------------
		LDA	CSRXPS
		CLC
		ADC	MOUSEBX
		STA	CSRXPS
		SEC
		SBC	#07H
		STA	>OAM
		STA	>OAM+4
		LDA	CSRYPS
		CLC
		ADC	MOUSEBY
		STA	CSRYPS
		STA	>OAM+1
		STA	>OAM+4+1
;;;;K;;;;		LDA	#00H
;;;;K;;;;		STA	>OAM+2
;;;;K;;;;		STA	>OAM+4+2
		LDA	#30H
		STA	>OAM+3
		STA	>OAM+4+3
		LDA	#00001110B
		STA	>OAMSUB
;
		LDA	<MOUSEBS
		AND	#11000000B	; mouse key ON ?
		BEQ	MUSOFF		;	NO -> MUSOFF
		LDA	#002H
MUSOFF		EQU	$
		STA	>OAM+2
		STA	>OAM+4+2
;
		LDA	MOUSEBT
		AND	#01000000B	; mouse left ON ?
		BEQ	PASS00		;	NO -> PASS00
		LDA	!CSRXPS		; loda
		CMP	#0CEH		;  save
		BCC	PASS00		;   del
		CMP	#0F3H		;    format
		BCS	PASS00		;     exit
		LDA	!CSRYPS		;
		CMP	#00BH		;
		BCC	PASS00		;
		CMP	#05CH		;
		BCS	PASS00		;
		CLC			;
		ADC	#004H		;
		AND	#0F0H		;
		LSR	A		;
		LSR	A		;
		LSR	A		;
		STA	<WORK0		;
		CMP	#008H		; mode FORMAT ?
		BEQ	PASS003		;	YES -> PASS003
		CMP	#00AH		; mode EXIT ?
		BEQ	PASS003		;	YES -> PASS003
		LDA	!FILFLG
		BMI	PASS00
		TAX
		LDA	!MJIDXA,X	; mo-ji buffer = 0 ?
		BNE	PASS003		;	YES -> PASS00
		JMP	PASS00		;
PASS003		EQU	$
		LDA	<WORK0
		PHA			;
		CMP	!MDSTFG		;
		BEQ	PASS005		;
		STZ	<WORK2		; mo-do-su
		STZ	<WORK3		;
		JSR	MDHNTN		; bit ha-n-te-n sub
PASS005		EQU	$
		PLA
		STA	!MDSTFG
;;K;;		CMP	#004H
;;K;;		BNE	PASS008
;;K;;		LDA	!FILFGS
;;K;;		BNE	PASS00
PASS008		EQU	$
		LDA	#004H
		STA	<WORK2		; ha-n-te-n
		STA	<WORK3		;
		JSR	MDHNTN		; bit ha-n-te-n sub
		LDX	!MDSTFG
		BEQ	PASS00
		JSR	FLBFCLR		; file name buffer initial set
		LDX	!MDSTFG
		JSR	(MDSET,X)	; mode sub
		JMP	FLMV010
;
PASS00		EQU	$
		LDA	!MDSTFG
		BEQ	PASS10
		LDA	<MOUSEBT
		AND	#11000000B	; mouse swich ON ?
		BEQ	PASS10		;	NO -> PASS10
		AND	#10000000B	; mouse right ON ?
		BNE	PASS05		;	YES -> PASS05
		JSR	MDSTSB
		LDA	<WORK0
		CMP	#0FCH		; input "NO" ?
		BEQ	PASS05		;	NO -> PASS05
		CMP	#0FEH
		BEQ	PASS03
		JMP	FLMV010
PASS03		EQU	$
		LDX	!MDSTFG
		JSR	(SETDOS,X)
		STZ	!MDSTFG
		JMP	FLMV010
;
PASS05		EQU	$
		STZ	<WORK2		; mo-do-su
		STZ	<WORK3		;
		JSR	MDHNTN		; bit ha-n-te-n sub
		STZ	!MDSTFG
		JSR	FLBFCLR		; file name buffer initial set
		JSR	FLNMDSP
		JMP	FLMV010
;
PASS10		EQU	$
		LDA	!SRCFLG
		BMI	PASS20
		ASL	A
		TAX
		CMP	#010H
		BEQ	PASS15
		STA	!MPCHGFG
		STA	!MPTYPE		; map type set
PASS15		EQU	$
		STZ	!SCRLBF
		JSR	(FILSET,X)	; file surch & name disp set
		LDA	#080H
		STA	!SRCFLG
		JMP	FLMV010
;
PASS20		EQU	$
		LDA	<MOUSEBT
		AND	#01000000B	; mouse left ON ?
		BEQ	PASS30		;	NO -> PASS30
		LDA	!CSRXPS
		CMP	#00AH
		BCC	PASS30
		CMP	#0BEH
		BCS	PASS30
		LDA	!CSRYPS
		CMP	#010H
		BCC	PASS30
		CMP	#058H
		BCS	PASS30
		SEC
		SBC	#010H
		AND	#078H
		LSR	A
		LSR	A
		LSR	A
		STA	!FILFLG
		STA	!SRCFLG
		JSR	HNTNST		; ha-n-te-n
		JMP	FLMV010
;
PASS30		EQU	$
		LDA	!FILFLG
		BMI	PASS40
		LDA	<MOUSEBT
		AND	#01000000B	; mouse left ON ?
		BEQ	PASS40		;	NO -> PASS40
		LDA	!CSRYPS
		CMP	#09CH
		BCC	PASS40
		CMP	#0DCH
		BCS	PASS40
		JSR	MJBFST		; mo-ji buffer set
		JMP	FLMV010
;
PASS40		EQU	$
		LDA	!FLBFIDX
		CMP	#007H
		BCC	PASS50
		LDA	<MOUSEBT
		AND	#01000000B	; mouse left ON ?
		BEQ	PASS50		;	NO -> PASS50
		LDA	!CSRYPS
		CMP	#066H
		BCC	PASS50
		CMP	#08FH
		BCS	PASS50
		LDA	!CSRXPS
		CMP	#009H
		BCC	PASS50
		CMP	#017H
		BCS	PASS50
		JSR	FLSCRL		; file name scroll
		JMP	FLMV010
;
PASS50		EQU	$
		LDA	!FILFLG
		BMI	PASS60
		LDA	<MOUSEBT
		AND	#01000000B	; mouse left ON ?
		BEQ	PASS60		;	NO -> PASS60
		LDA	!CSRYPS
		CMP	#068H
		BCC	PASS60
		CMP	#090H
		BCS	PASS60
		AND	#008H
		BEQ	PASS60
		LDA	!CSRXPS
		CMP	#020H
		BCC	PASS60
		CMP	#0F0H
		BCS	PASS60
		JSR	FLNMST		; file name set
;
PASS60		EQU	$
;
FLMV010		EQU	$
		PLB
		RTL
;
;
MDSET		EQU	$-2
		WORD	LOADST	; 1
		WORD	SAVEST	; 2
		WORD	DELSET	; 3
		WORD	FRMTST	; 4
		WORD	EXITST	; 5
;
FILSET		EQU	$
		WORD	MPDTSTA	; A
		WORD	MPDTSTB	; B
		WORD	MPDTSTC	; C
		WORD	MPDTSTD	; D
		WORD	MPDTSTE	; E
		WORD	MPDTSTF	; F
		WORD	MPDTSTG	; G
		WORD	MPDTSTH	; H
		WORD	POINSET	; P
;
;;;;K;;;;		WORD	MPDTST	; 0
;;;;K;;;;		WORD	CHRAST	; 1
;;;;K;;;;		WORD	COLRST	; 2
;;;;K;;;;		WORD	SCRNST	; 3
;
;
SETDOS		EQU	$-2
		WORD	LOADDS
		WORD	SAVEDS
		WORD	DELDS
		WORD	FRMTDS
;
;
;********************************************************
;*							*
;*	load dos set					*
;*							*
;********************************************************
LOADDS		EQU	$
		DOS	_LOAD
		TAX
		BNE	DSSTOK
		LDA	!FILFGS
		CMP	#008H
		BCC	LDDS00
		LDA	>MPPTCNT
		STA	!PTLMTCT
		JSR	QSTCTST		; quest count set
LDDS00		EQU	$
		JSR	MPBFST		; map data buffer set
		BRA	FRDS50
;
;
;********************************************************
;*							*
;*	save dos set					*
;*							*
;********************************************************
SAVEDS		EQU	$
		DOS	_SAVE
		BRA	DSSTOK
;
;
;********************************************************
;*							*
;*	delete dos set					*
;*							*
;********************************************************
DELDS		EQU	$
		DOS	_PURGE
		BRA	FRDS50		; goto "OK" set
;
;
;********************************************************
;*							*
;*	format dos set					*
;*							*
;********************************************************
FRMTDS		EQU	$
		DOS	_FORMAT
DSSTOK		EQU	$
		TAX
		BEQ	FRDS50
		STA	<WORKE
		JSR	FLBFCLR		; file name buffer initial set
		JSR	ERNMST		; error name set
		BRA	FRDS90
;
FRDS50		EQU	$
		LDA	#04FH		; "OK" set
		STA	!FILBF3
		LDA	#04BH
		STA	!FILBF3+1
;
		JSR	FLNMDSP
;
FRDS90		EQU	$
		STZ	<WORK2		; mo-do-su
		STZ	<WORK3		;
		JSR	MDHNTN		; bit ha-n-te-n sub
		RTS
;
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+						+
;+	map data buffer set			+
;+						+
;++++++++++++++++++++++++++++++++++++++++++++++++
MPBFST		EQU	$
		LDA	#BANK MPDTBFA
		STA	<WORK2
		M16			; memory 16bit mode
		LDX	!MPCHGFG
		LDA	MDBAD,X
		STA	<WORK0
;
		LDA	[<WORK0]
		STA	!MPOBJSTN
		ASL	A
		ASL	A
		STA	<WORK4
		INC	<WORK0
		INC	<WORK0
;
		I16			; index 16bit mode
		LDY	#00000H
EXIT20		EQU	$
		LDA	[<WORK0],Y
		STA	!MPOBJTYP,Y
		INY
		INY
		CPY	<WORK4
		BNE	EXIT20
		CPY	#00258H
		BCS	EXIT38
;;;;K;;;;		BCS	EXIT90
;
		LDA	#00000H
EXIT30		EQU	$
		STA	!MPOBJTYP,Y
		INY
		INY
		CPY	#00258H
		BNE	EXIT30
;
EXIT38		EQU	$
		STZ	!MPTCNT0
		STZ	!MPTCNT1
		LDX	#00000H
		TXY
EXIT40		EQU	$
		LDA	!MPOBJTYP,Y
		AND	#000FFH
		CMP	#007AH		; point set data ?
		BCC	EXIT45		;	NO -> EXIT45
		LDA	!MPOBJTYP,Y
		STA	>MPTDAT,X
		LDA	!MPOBJTYP+2,Y
		STA	>MPTDAT+2,X
		INC	!MPTCNT1
		INX
		INX
		INX
		INX
EXIT45		EQU	$
		INY
		INY
		INY
		INY
		CPY	<WORK4
		BCC	EXIT40
;
		LDA	!MPOBJSTN
		SEC
		SBC	!MPTCNT1
		STA	!MPTCNT0
;
EXIT90		EQU	$
		MI8			; memory , index 8bit mode
;
EXIT99		EQU	$
		RTS
;
;
;++++++++++++++++++++++++++++++++++++++++
;+					+
;+	edit file coll			+
;+					+
;++++++++++++++++++++++++++++++++++++++++
UNMPBF		EQU	$
		PHB
		PHK
		PLB
		JSR	MPBFST
		PLB
		RTL
;
;
MDBAD		EQU	$
		WORD	MPDTBFA,MPDTBFB,MPDTBFC,MPDTBFD
		WORD	MPDTBFE,MPDTBFF,MPDTBFG,MPDTBFH
		WORD	MPPTCNT
;
;
;********************************************************
;*							*
;*	file name set					*
;*							*
;********************************************************
FLNMST		EQU	$
		LDX	#000H
		LDA	!CSRXPS
		CMP	#080H
		BCC	FLST20
		LDX	#00CH
		CMP	#090H
		BCS	FLST20
		BRA	FLST90
;
FLST20		EQU	$		; file name buffer
		LDA	!CSRYPS		;	ram address set
		SEC
		SBC	#068H
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		TAY
		TXA
		CLC
		ADC	FLSTDT,Y
		CLC
		ADC	!SCRLBF
		TAX
;
		LDA	!FILBF0,X
		CMP	#020H
		BEQ	FLST90
		LDA	#008H
		STA	<WORK0
		STA	<WORK1
		LDA	!FILFGS
		ASL	A
		ASL	A
		ASL	A
		TAY
		PHY
FLST40		EQU	$		; file buffer ->
		LDA	!FILBF0,X	;	mo-ji buffer set
		STA	!MOJBFA,Y
		INX
		INY
		DEC	<WORK0
		BNE	FLST40
		PLY
		LDA	!FILFGS
		TAX
FLST45		EQU	$
		LDA	!MOJBFA,Y
		CMP	#020H
		BEQ	FLST50
		INY
		INC	!MJIDXA,X
		DEC	<WORK1
		BNE	FLST45
;
FLST50		EQU	$
		JSR	FLNMDMA		; 1 file name DMA set
;
FLST90		EQU	$
		RTS
;
;
FLSTDT		EQU	$
		HEX	000H,018H,030H
;
;
;********************************************************
;*							*
;*	file name scroll				*
;*							*
;********************************************************
FLSCRL		EQU	$
		LDX	#000H
		LDA	!CSRYPS		; scroll
		CMP	#077H		;	(up) 000h -> X
		BCC	FLSL00		;     (down) 002h -> X
		CMP	#07EH
		BCC	FLSL90
		LDX	#002H
;
FLSL00		EQU	$
		M16			; memory 16bit mode
		TXY
		BNE	FLSL03
		LDA	!FLBFIDX
		DEC	A
		AND	#000FEH
		LSR	A
		TAY
		LDA	UPSCRLM,Y
		AND	#000F8H
		CMP	!SCRLBF		; up scroll limt ?
		BEQ	FLSL05		;	YES -> FLSL05
FLSL03		EQU	$
		LDA	!SCRLBF
		CLC
		ADC	FLSLCT,X
		STA	!SCRLBF		; down scroll limt ?
		BPL	FLSL05		;	NO -> FLSL05
		STZ	!SCRLBF
FLSL05		EQU	$
		M8			; memory 8bit mode
;
		JSR	FLNMDSP		; file name disp set
;
FLSL90		EQU	$
		RTS
;
FLSLCT		EQU	$
		WORD	00018H,0FFE8H
;
UPSCRLM		EQU	$-3
		HEX	018H,030H,048H,060H,078H,090H
;
;
;********************************************************
;*							*
;*	load set					*
;*							*
;********************************************************
LOADST		EQU	$
		JSR	YESNOOK
;
		LDA	!FILFGS
		CMP	#008H
		BCC	LDST00
		LDA	!PTLMTCT
		STA	!MPPTCNT
LDST00		EQU	$
;
		LDA	#04CH		; "LOAD" set
		STA	!FILBF2+04H
		LDA	#04FH
		STA	!FILBF2+05H
		LDA	#041H
		STA	!FILBF2+06H
		LDA	#044H
		STA	!FILBF2+07H
;
		LDA	#04FH		; "OK" set
		STA	!FILBF2+09H
		LDA	#04BH
		STA	!FILBF2+0AH
;
		JSR	FLNMDSP
;
		RTS
;
;
;********************************************************
;*							*
;*	save set					*
;*							*
;********************************************************
SAVEST		EQU	$
		JSR	YESNOOK
;
		LDA	#053H		; "SAVE" set
		STA	!FILBF2+04H
		LDA	#041H
		STA	!FILBF2+05H
		LDA	#056H
		STA	!FILBF2+06H
		LDA	#045H
		STA	!FILBF2+07H
;
		LDA	#04FH		; "OK" set
		STA	!FILBF2+09H
		LDA	#04BH
		STA	!FILBF2+0AH
;
		JSR	FLNMDSP
;
		RTS
;
;
;********************************************************
;*							*
;*	del set						*
;*							*
;********************************************************
DELSET		EQU	$
		JSR	YESNOOK
;
		LDA	#044H		; "DELETE" set
		STA	!FILBF2+03H
		LDA	#045H
		STA	!FILBF2+04H
		LDA	#04CH
		STA	!FILBF2+05H
		LDA	#045H
		STA	!FILBF2+06H
		LDA	#054H
		STA	!FILBF2+07H
		LDA	#0045H
		STA	!FILBF2+08H
;
		LDA	#04FH		; "OK" set
		STA	!FILBF2+0AH
		LDA	#04BH
		STA	!FILBF2+0BH
;
		JSR	FLNMDSP
;
		RTS
;
;
;********************************************************
;*							*
;*	format set					*
;*							*
;********************************************************
FRMTST		EQU	$
		LDA	#046H		; "FORMAT" set
		STA	!FILBF0+1
		LDA	#04FH
		STA	!FILBF0+2
		LDA	#052H
		STA	!FILBF0+3
		LDA	#04DH
		STA	!FILBF0+4
		LDA	#041H
		STA	!FILBF0+5
		LDA	#054H
		STA	!FILBF0+6
;
		LDA	#04FH		; "OK" set
		STA	!FILBF0+8
		LDA	#04BH
		STA	!FILBF0+9
;
		JSR	FLNMDSP
;
		RTS
;
;
;********************************************************
;*							*
;*	exit set					*
;*							*
;********************************************************
EXITST		EQU	$
		DOS	_DOSSTP		; sfx-dos stop !!
		LDA	#EDT0
		STA	!MODENO		; return to edit mode !!
		RTS
;
;
;++++++++++++++++++++++++++++++++++++++++
;+					+
;+	"LOAD","SAVE","DEL" OK sub	+
;+					+
;++++++++++++++++++++++++++++++++++++++++
YESNOOK		EQU	$
		LDA	!FILFGS
		ASL	A
		ASL	A
		ASL	A
		TAY
		LDX	#000H
OK000		EQU	$		; mo-ji buffer ->
		LDA	!MOJBFA,Y	;	file buffer set
		STA	!FILBF0,X
		INY
		INX
		CPX	#008H
		BNE	OK000
;
		LDY	#000H
		LDA	!FILFGS
		CMP	#008H
		BNE	OK010
		LDY	#004H
OK010		EQU	$
		LDA	OKDATA,Y
		STA	!FILBF0,X
		INX
		INY
		TYA
		AND	#003H
		BNE	OK010
;
		LDA	#0
		DOS	_SELDSK		; disk drive set
		LDA	#2
		DOS	_DSKRST		; disk mode set
;
		LDX	#000H
OK020		EQU	$
		LDA	!FILBF0,X
		STA	1EE0H,X
		INX
		CPX	#008H
		BNE	OK020
;
		LDA	!FILBF0+1,X
		STA	1EE0H,X
		LDA	!FILBF0+2,X
		STA	1EE0H+1,X
		LDA	!FILBF0+3,X
		STA	1EE0H+2,X
;
;;;;K;;;;		LDA	!FILFGS
;;;;K;;;;		CMP	#008H		; point data file ?
;;;;K;;;;		BEQ	OK030		;	YES -> OK030
;;;;K;;;;		LDA	!MDSTFG
;;;;K;;;;		CMP	#002H		; file load ?
;;;;K;;;;		BNE	OK040		;	NO -> OK040
OK030		EQU	$
		LDA	!FILFGS
		ASL	A
		TAX
		M16			; memory 16bit mode
		LDA	MDBAD,X
		STA	1EF0H
		LDA	#00258H+2
		CPX	#010H
		BNE	OK035
		LDA	#06978H+2
OK035		EQU	$
		STA	1EF4H
		STZ	1EF6H
		M8			; memory 8bit mode
		LDA	#BANK MPDTBFA
		LDX	!FILFGS
		CPX	#008H
		BNE	OK038
		LDA	#BANK MAPPTBF
OK038		EQU	$
		STA	1EF2H
;;;;K;;;;		BRA	OK999
;;;;K;;;;OK040		EQU	$
;;;;K;;;;		M16			; memory 16bit mode
;;;;K;;;;		LDA	#MPOBJTYP-2
;;;;K;;;;		STA	1EF0H
;;;;K;;;;		LDA	#00258H+2
;;;;K;;;;		STA	1EF4H
;;;;K;;;;		STZ	1EF6H
;;;;K;;;;		M8			; memory 8bit mode
;;;;K;;;;		LDA	#BANK MPOBJTYP
;;;;K;;;;		STA	1EF2H
;
OK999		EQU	$
		RTS
;
;
OKDATA		EQU	$
		HEX	02EH,04DH,050H,044H	; .MPD
		HEX	02EH,050H,044H,054H	; .PDT
;
;
;++++++++++++++++++++++++++++++++++++++++
;+					+
;+	mode set "YES","NO"		+
;+					+
;++++++++++++++++++++++++++++++++++++++++
MDSTSB		EQU	$
		LDA	<MOUSEBT
		AND	#01000000B	; mouse left ON ?
		BEQ	MDSTPS		;	NO -> MDSTPS
		LDA	!CSRYPS
		CMP	#09CH
		BCC	MDSTPS
		CMP	#0DCH
		BCS	MDSTPS
		LDA	!CSRXPS
		CMP	#0D6H
		BCC	MDSTPS
		CMP	#0F4H
		BCS	MDSTPS
		JSR	MJBFST
MDSTPS		EQU	$
		RTS
;
;
;********************************************************
;*							*
;*	map data file					*
;*							*
;********************************************************
MPDTSTA		EQU	$
MPDTSTB		EQU	$
MPDTSTC		EQU	$
MPDTSTD		EQU	$
MPDTSTE		EQU	$
MPDTSTF		EQU	$
MPDTSTG		EQU	$
MPDTSTH		EQU	$
		LDA	!SRCFLG
		ASL	A
		STA	!MPCHGFG
		STA	!MPTYPE		; map type set
		LDA	#02EH
		STA	<WORK0
		LDA	#04DH
		STA	<WORK1
		LDA	#050H
		STA	<WORK2
		LDA	#044H
		STA	<WORK3
		JSR	FLBFCLR		; file name buffer initial set
		JSR	FLNMSB
		LDA	<WORKE
		BEQ	MPDT50
		JSR	ERNMST		; error name set
		BRA	MPDT90
;
MPDT50		EQU	$
		JSR	FLNMDSP		; file name disp set
;
MPDT90
		RTS
;
;
;********************************************************
;*							*
;*	point data file					*
;*							*
;********************************************************
POINSET		EQU	$
		LDA	#02EH
		STA	<WORK0
		LDA	#050H
		STA	<WORK1
		LDA	#044H
		STA	<WORK2
		LDA	#054H
		STA	<WORK3
		JSR	FLBFCLR		; file name buffer initial set
		JSR	FLNMSB
		LDA	<WORKE
		BEQ	POIN50
		JSR	ERNMST		; error name set
		BRA	POIN90
;
POIN50		EQU	$
		JSR	FLNMDSP		; file name disp set
;
POIN90		EQU	$
		RTS
;;;;K;;;;;
;;;;K;;;;;
;;;;K;;;;;********************************************************
;;;;K;;;;;*							*
;;;;K;;;;;*	character data file				*
;;;;K;;;;;*							*
;;;;K;;;;;********************************************************
;;;;K;;;;CHRAST		EQU	$
;;;;K;;;;		LDA	#02EH
;;;;K;;;;		STA	<WORK0
;;;;K;;;;		LDA	#043H
;;;;K;;;;		STA	<WORK1
;;;;K;;;;		LDA	#047H
;;;;K;;;;		STA	<WORK2
;;;;K;;;;		LDA	#058H
;;;;K;;;;		STA	<WORK3
;;;;K;;;;		JSR	FLBFCLR		; file name buffer initial set
;;;;K;;;;		JSR	FLNMSB
;;;;K;;;;		LDA	<WORKE
;;;;K;;;;		BEQ	CHRA50
;;;;K;;;;		JSR	ERNMST		; error name set
;;;;K;;;;		BRA	CHRA90
;;;;K;;;;;
;;;;K;;;;CHRA50		EQU	$
;;;;K;;;;		JSR	FLNMDSP		; file name disp set
;;;;K;;;;;
;;;;K;;;;CHRA90		EQU	$
;;;;K;;;;		RTS
;;;;K;;;;;
;;;;K;;;;;
;;;;K;;;;;********************************************************
;;;;K;;;;;*							*
;;;;K;;;;;*	color data file					*
;;;;K;;;;;*							*
;;;;K;;;;;********************************************************
;;;;K;;;;COLRST		EQU	$
;;;;K;;;;		LDA	#02EH
;;;;K;;;;		STA	<WORK0
;;;;K;;;;		LDA	#043H
;;;;K;;;;		STA	<WORK1
;;;;K;;;;		LDA	#04FH
;;;;K;;;;		STA	<WORK2
;;;;K;;;;		LDA	#04CH
;;;;K;;;;		STA	<WORK3
;;;;K;;;;		JSR	FLBFCLR		; file name buffer initial set
;;;;K;;;;		JSR	FLNMSB
;;;;K;;;;		LDA	<WORKE
;;;;K;;;;		BEQ	COLR50
;;;;K;;;;		JSR	ERNMST		; error name set
;;;;K;;;;		BRA	COLR90
;;;;K;;;;;
;;;;K;;;;COLR50		EQU	$
;;;;K;;;;		JSR	FLNMDSP		; file name disp set
;;;;K;;;;;
;;;;K;;;;COLR90		EQU	$
;;;;K;;;;		RTS
;;;;K;;;;;
;;;;K;;;;;
;;;;K;;;;;********************************************************
;;;;K;;;;;*							*
;;;;K;;;;;*	screen data file				*
;;;;K;;;;;*							*
;;;;K;;;;;********************************************************
;;;;K;;;;SCRNST		EQU	$
;;;;K;;;;		LDA	#02EH
;;;;K;;;;		STA	<WORK0
;;;;K;;;;		LDA	#053H
;;;;K;;;;		STA	<WORK1
;;;;K;;;;		LDA	#043H
;;;;K;;;;		STA	<WORK2
;;;;K;;;;		LDA	#052H
;;;;K;;;;		STA	<WORK3
;;;;K;;;;		JSR	FLBFCLR		; file name buffer initial set
;;;;K;;;;		JSR	FLNMSB
;;;;K;;;;		LDA	<WORKE
;;;;K;;;;		BEQ	SCRN50
;;;;K;;;;		JSR	ERNMST		; error name set
;;;;K;;;;		BRA	SCRN90
;;;;K;;;;;
;;;;K;;;;SCRN50		EQU	$
;;;;K;;;;		JSR	FLNMDSP		; file name disp set
;;;;K;;;;;
;;;;K;;;;SCRN90		EQU	$
;;;;K;;;;		RTS
;
;
;++++++++++++++++++++++++++++++++++++++++
;+					+
;+	error name set			+
;+					+
;++++++++++++++++++++++++++++++++++++++++
ERNMST		EQU	$
;
		JSR	FLNMDSP
;
		I16			; index 16bit mode
		PHB
		LDA	#BANK VRAMDX
		PHA
		PLB
		LDY	!VRAMDX
		M16			; memory 16bit mode
		LDA	#00000H
		STA	!VRAMD
		DEC	A
		STA	!VRAMD+2
		LDA	<WORKE
		AND	#0000FH
		ASL	A
		TAX
		LDA	#07DA4H		; vram address
		STA	0,Y		;	2116H , 2117H set
		LDA	#00000H
		STA	2,Y		; 2115H , 4300H set
		LDA	>ERNMDT,X
		STA	5,Y		; 4302H , 4303H set
		LDA	>ERNMCT,X
		STA	8,Y		; 4305H , 4306H set
		TYA
		CLC
		ADC	#0000CH
		STA	10,Y		; next address set
		STA	!VRAMDX		; end address set
		M8			; memory 8bit mode
		LDA	#00018H
		STA	4,Y		; 4301H set
		LDA	#BANK ERNMDT
		STA	7,Y		; 4304H set
;
		PLB
		I8			; index 8bit mode
		RTS
;
;
ERNMDT		EQU	$-2
		WORD	ERDT01,ERDT02,ERDT03,ERDT04
		WORD	ERDT05,ERDT06,ERDT07,ERDT08
		WORD	ERDT09
;
ERNMCT		EQU	$-2
		WORD	ERDT02-ERDT01,ERDT03-ERDT02
		WORD	ERDT04-ERDT03,ERDT05-ERDT04
		WORD	ERDT06-ERDT05,ERDT07-ERDT06
		WORD	ERDT08-ERDT07,ERDT09-ERDT08
		WORD	ERDT0A-ERDT09
;
ERDT01	EQU	$
	HEX	044H,049H,053H,04BH,020H		; disk
	HEX	053H,045H,054H,020H			; set
	HEX	045H,052H,052H,04FH,052H		; error
;
ERDT02	EQU	$
	HEX	044H,049H,053H,04BH,020H		; disk
	HEX	049H,02FH,04FH,020H			; I/O
	HEX	045H,052H,052H,04FH,052H		; error
;
ERDT03	EQU	$
	HEX	044H,049H,053H,04BH,020H		; disk
	HEX	053H,059H,053H,054H,045H,04DH,020H	; system
	HEX	045H,052H,052H,04FH,052H		; error
;
ERDT04	EQU	$
	HEX	046H,049H,04CH,045H,020H		; file
	HEX	04EH,04FH,054H,020H			; not
	HEX	046H,04FH,055H,04EH,044H		; found
;
ERDT05	EQU	$
	HEX	046H,049H,04CH,045H,020H		; file
	HEX	04FH,050H,045H,04EH,020H		; open
	HEX	045H,052H,052H,04FH,052H		; error
;
ERDT06	EQU	$
	HEX	044H,049H,052H,045H			; dire
	HEX	043H,054H,04FH,052H,059H		; ctory
	HEX	020H,046H,055H,04CH,04CH		; full
;
ERDT07	EQU	$
	HEX	046H,049H,04CH,045H,020H		; file
	HEX	052H,045H,041H,044H,020H		; read
	HEX	04FH,04EH,04CH,059H			; only
;
ERDT08	EQU	$
	HEX	044H,049H,053H,04BH,020H		; disk
	HEX	046H,055H,04CH,04CH			; full
	HEX	020H,020H,020H,020H,020H
;
ERDT09	EQU	$
	HEX	046H,049H,04CH,045H,020H		; file
	HEX	041H,04CH,052H,045H,041H,044H,059H,020H	; already
	HEX	045H,058H,049H,053H,054H		; exist
;
ERDT0A	EQU	$
;
;
;++++++++++++++++++++++++++++++++++++++++
;+					+
;+	file name disp set		+
;+					+
;++++++++++++++++++++++++++++++++++++++++
FLNMDSP		EQU	$
		I16			; index 16bit mode
		PHB
		LDA	#BANK VRAMDX
		PHA
		PLB
;
		STZ	<WORK0
		STZ	<WORK1
		STZ	<WORK2
		STZ	<WORK3
FLDSP00		EQU	$
		LDX	<WORK0
		LDY	!VRAMDX
		M16			; memory 16bit mode
		LDA	>FLNMAD,X	; vram address
		STA	0,Y		;	2116H , 2117H set
		LDA	#00000H
		STA	2,Y		; 2115H , 4300H set
		LDA	#FILBF0
		CLC
		ADC	<WORK2
		CLC
		ADC	>SCRLBF
		STA	5,Y		; 4302H , 4303H set
		LDA	#0000CH
		STA	8,Y		; 4305H , 4306H set
		TYA
		CLC
		ADC	#0000CH
		STA	10,Y		; next address set
		STA	!VRAMDX		; end address set
		M8			; memory 8bit mode
		LDA	#00018H
		STA	4,Y		; 4301H set
		LDA	#BANK FILBF0
		STA	7,Y		; 4304H set
;
		INC	<WORK0
		INC	<WORK0
		LDA	<WORK2
		CLC
		ADC	#00CH
		STA	<WORK2
		CMP	#048H
		BNE	FLDSP00
;
		M16			; memory 16bit mode
		LDX	!VRAMD
		LDA	#07DB0H
		STA	!VRAMD+02,X
		LDA	#04003H
		STA	!VRAMD+04,X
		LDA	#00020H
		STA	!VRAMD+06,X
		LDA	#0FFFFH
		STA	!VRAMD+08,X
		LDA	!VRAMD
		CLC
		ADC	#00006H
		STA	!VRAMD
		M8			; memory 8bit mode
;
		PLB
		I8			; index 8bit mode
		RTS
;
;
FLNMAD		EQU	$
		WORD	07DA4H
		WORD	07DB2H
		WORD	07DE4H
		WORD	07DF2H
		WORD	07E24H
		WORD	07E32H
;
;
;++++++++++++++++++++++++++++++++++++++++
;+					+
;+	file name buffer initial sub	+
;+					+
;++++++++++++++++++++++++++++++++++++++++
FLBFCLR		EQU	$
		STZ	!FLBFIDX
		M16			; memory 16bti mode
		LDX	#00AH
		LDA	#02020H
FLCLR		EQU	$
		STA	!FILBF0,X
		STA	!FILBF1,X
		STA	!FILBF2,X
		STA	!FILBF3,X
		STA	!FILBF4,X
		STA	!FILBF5,X
		STA	!FILBF6,X
		STA	!FILBF7,X
		STA	!FILBF8,X
		STA	!FILBF9,X
		STA	!FILBFA,X
		STA	!FILBFB,X
		STA	!FILBFC,X
		STA	!FILBFD,X
		STA	!FILBFE,X
		STA	!FILBFF,X
		DEX
		DEX
		BPL	FLCLR
;
		M8			; memory 8bti mode
		RTS
;
;
;++++++++++++++++++++++++++++++++++++++++
;+					+
;+	file name srch sub		+
;+					+
;++++++++++++++++++++++++++++++++++++++++
FLNMSB		EQU	$
		STZ	<WORKE
		LDA	#0
		DOS	_SELDSK		; disk drive set
		LDA	#2
		DOS	_DSKRST		; disk mode set
;
		LDX	#000H
		LDA	#03FH
FLNM00		EQU	$		; wild name "?" set
		STA	1EE0H,X
		INX
		CPX	#008H
		BNE	FLNM00
;
		LDA	<WORK1		; ka-ku-chi-yo-u-si set
		STA	1EE8H		;
		LDA	<WORK2		;
		STA	1EE9H		;
		LDA	<WORK3		;
		STA	1EEAH		;
		DOS	_DIRFST
		TAX
		BNE	FLNM80
;
		LDX	#000H
FLNM10		EQU	$
		LDA	1EC0H,X
		STA	!FILBF0,X
		INX
		CPX	#008H
		BNE	FLNM10
		M16			; memory 16bit mode
		LDA	<WORK0
		STA	!FILBF0+08
		LDA	<WORK2
		STA	!FILBF0+10
		M8			; memory 8bit mode
		INC	!FLBFIDX
		LDA	#00CH
		STA	<WORKA
;
FLNM20		EQU	$
		DOS	_DIRNXT
		TAX
		BNE	FLNM90
		LDX	#000H
		LDY	<WORKA
FLNM25		EQU	$
		LDA	1EC0H,X
		STA	!FILBF0,Y
		INY
		INX
		CPX	#008H
		BNE	FLNM25
		M16			; memory 16bit mode
		LDA	<WORK0
		STA	!FILBF0,Y
		LDA	<WORK2
		STA	!FILBF0+2,Y
		M8			; memory 8bit mode
		INC	!FLBFIDX
		LDA	<WORKA
		CLC
		ADC	#00CH
		STA	<WORKA
		BRA	FLNM20
;
FLNM80		EQU	$
		STX	<WORKE
FLNM90		EQU	$
		RTS
;
;
;++++++++++++++++++++++++++++++++++++++++
;+					+
;+	mo-ji disp & buffer set		+
;+					+
;++++++++++++++++++++++++++++++++++++++++
MJBFST		EQU	$
		LDA	!CSRYPS
		CLC
		ADC	#004H
		SEC
		SBC	#0A0H
		AND	#0F0H
		STA	<WORK0
;
		LDA	!CSRXPS
		CLC
		ADC	#004H
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		ORA	<WORK0
		TAX
;
		LDA	#004H
		STA	<WORK1
		LDA	MOJDAT,X	; mo-ji data read
		STA	<WORK0
		STA	<WORKE
		CMP	#0FCH		; no ?
		BEQ	MJBF90		;	YES -> MJBF90
		CMP	#0FEH		; yes ?
		BEQ	MJBF90		;	YES -> MJBF90
		CMP	#0FFH		; line clear ?
		BEQ	MJBF50		;	YES -> MJBF50
		CMP	#0FDH		; back specs ?
		BNE	MJBF00		;	NO -> MJBF00
		LDA	#020H
		STA	<WORK0
		LDX	!FILFGS
		LDA	!MJIDXA,X
		BEQ	MJBF90
		DEC	!MJIDXA,X
;
MJBF00		EQU	$
		LDX	!FILFGS		; address
		LDA	!MJIDXA,X
		CMP	#008H
		BCS	MJBF10
;
		LDA	!FILFGS		; buffer set
		TAY
		ASL	A
		ASL	A
		ASL	A
		CLC
		ADC	!MJIDXA,Y
		TAY
		LDA	<WORK0
		STA	!MOJBFA,Y
;
		JSR	FLNMDMA		; 1 file name DMA set
;
MJBF10		EQU	$
		LDA	<WORKE		; mo-ji data read
		CMP	#0FDH
		BEQ	MJBF90
		INC	!MJIDXA,X
		LDA	!MJIDXA,X
		CMP	#008H
		BCC	MJBF90
		LDA	#008H
		STA	!MJIDXA,X
		BRA	MJBF90
;
MJBF50		EQU	$
		JSR	LINCLR		; line clear
;
MJBF90		EQU	$
		RTS
;
MJADRS		EQU	$
		WORD	07C4BH
		WORD	07C6BH
		WORD	07C8BH
		WORD	07CABH
		WORD	07CCBH
		WORD	07CEBH
		WORD	07D0BH
		WORD	07D2BH
		WORD	07D4BH
;
MJBFADL		EQU	$
		BYTE	LOW MOJBFA,LOW MOJBFB,LOW MOJBFC,LOW MOJBFD
		BYTE	LOW MOJBFE,LOW MOJBFF,LOW MOJBFG,LOW MOJBFH
		BYTE	LOW MOJBFP
;
MJBFADH		EQU	$
		BYTE	HIGH MOJBFA,HIGH MOJBFB,HIGH MOJBFC,HIGH MOJBFD
		BYTE	HIGH MOJBFE,HIGH MOJBFF,HIGH MOJBFG,HIGH MOJBFH
		BYTE	HIGH MOJBFP
;
;
;++++++++++++++++++++++++++++++++++++++++
;+					+
;+	line clear			+
;+					+
;++++++++++++++++++++++++++++++++++++++++
LINCLR		EQU	$
		LDX	!FILFGS		; index clear
		LDA	!MJIDXA,X
		BEQ	LIN90
		STZ	!MJIDXA,X
;
		LDA	!FILFGS
		ASL	A
		ASL	A
		ASL	A
		TAY
		LDX	#008H
		LDA	#020H
LIN00		EQU	$		; buffer clear
		STA	!MOJBFA,Y
		INY
		DEX
		BNE	LIN00
;
		JSR	FLNMDMA		; 1 file name DMA set
;
LIN90		EQU	$
		RTS
;
;
;########################################################
;#							#
;#	ha-n-te-n , mo-do-su				#
;#		( file name )				#
;########################################################
HNTNST		EQU	$
		I16			; index 16bit mode
		LDA	#000H
		XBA
		LDA	!FILFGS
		ASL	A
		TAY
		LDX	HNDAT,Y
		STX	<WORK0
		LDX	#00000H
		STX	<WORK2
		JSR	HNTNSUB		; ha-n-te-n set
;
		LDA	#000H
		XBA
		LDA	!FILFLG
		ASL	A
		TAY
		LDX	HNDAT,Y
		STX	<WORK0
		LDX	#00404H
		STX	<WORK2
		JSR	HNTNSUB		; ha-n-te-n set
HNTN10		EQU	$
		LDA	!FILFLG
		STA	!FILFGS
		I8			; index 8bit mode
		RTS
;
;
HNDAT		EQU	$
		WORD	07C40H
		WORD	07C60H
		WORD	07C80H
		WORD	07CA0H
		WORD	07CC0H
		WORD	07CE0H
		WORD	07D00H
		WORD	07D20H
		WORD	07D40H
;
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+						+
;+	bit ha-n-te-n VRAMDX set sub		+
;+		( file name )			+
;+			  WORK0,1 <- address	+
;+			  WORK2,3 <- atori	+
;++++++++++++++++++++++++++++++++++++++++++++++++
		IDX16
HNTNSUB		EQU	$
		PHB
		LDA	#BANK VRAMDX
		PHA
		PLB
		M16			; memory 16bit mode
		LDX	!VRAMDX
		LDA	<WORK0
		STA	0,X		; 2116H , 2117H set
		LDA	#00980H
		STA	2,X		; 2115H , 4300H set
		LDA	#00019H
		STA	4,X		; 4301H set
		TXA
		CLC
		ADC	#0000CH
		STA	5,X		; 4302H , 4303H set
		LDA	#0007EH
		STA	7,X		; 4304H set
		LDA	#00030H
		STA	8,X		; 4305H , 4306H set
		TXA
		CLC
		ADC	#0000EH
		STA	10,X		; next address set
		STA	!VRAMDX		; end address set
		LDA	<WORK2
		STA	12,X		; data set
		M8			; memory 8bit mode
		PLB
		RTS
		IDX8
;
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+						+
;+	bit ha-n-te-n VRAMDX set sub		+
;+		( mode )			+
;+			  WORK0,1 <- address	+
;+			  WORK2,3 <- atori	+
;++++++++++++++++++++++++++++++++++++++++++++++++
MDHNTN		EQU	$
		M16			; memory 16bit mode
		LDX	!MDSTFG
		BEQ	MDHT99
		LDA	MDHNAD,X
		STA	<WORK0
		PHB
		LDX	#BANK VRAMDX
		PHX
		PLB
		I16			; index 16bit mode
		LDX	!VRAMDX
		LDA	<WORK0
		STA	0,X		; 2116H , 2117H set
		LDA	#00980H
		STA	2,X		; 2115H , 4300H set
		LDA	#00019H
		STA	4,X		; 4301H set
		TXA
		CLC
		ADC	#0000CH
		STA	5,X		; 4302H , 4303H set
		LDA	#0007EH
		STA	7,X		; 4304H set
		LDA	#00008H
		STA	8,X		; 4305H , 4306H set
		TXA
		CLC
		ADC	#0000EH
		STA	10,X		; next address set
		STA	!VRAMDX		; end address set
		LDA	<WORK2
		STA	12,X		; data set
		PLB
MDHT99		EQU	$
		MI8			; memory , index 8bit mode
		RTS
;
;
MDHNAD		EQU	$-2
		WORD	07C5AH
		WORD	07C9AH
		WORD	07CDAH
		WORD	07D1AH
;
;
;************************************************
;*						*
;*	1 file name DMA set			*
;*		work 0,1 <- vram address	*
;*		     2,3 <- buffer address	*
;*						*
;************************************************
FLNMDMA		EQU	$
		PHX
		PHY
		LDA	!FILFGS
		ASL	A
		TAY
		LDA	MJADRS,Y
		STA	<WORK0
		LDA	MJADRS+1,Y
		STA	<WORK1
		LDY	!FILFGS
		LDA	MJBFADL,Y
		STA	<WORK2
		LDA	MJBFADH,Y
		STA	<WORK3
;
		PHB
		LDA	#BANK VRAMDX
		PHA
		PLB
;
		MI16			; memory , index 16bit mode
		LDX	!VRAMDX
		LDA	<WORK0
		STA	0,X		; 2116H , 2117H set
		LDA	#00000H
		STA	2,X		; 2115H , 4300H set
		LDA	<WORK2
		STA	5,X		; 4302H , 4303H set
		LDA	#00008H
		STA	8,X		; 4305H , 4306H set
		M16			; memory 16bit mode
		TXA
		CLC
		ADC	#0000CH
		STA	10,X
		STA	!VRAMDX
		M8			; memory 8bit mode
		LDA	#018H
		STA	4,X		; 4301H set
		LDA	#BANK MOJBFA
		STA	7,X		; 4304H set
		I8			; index 8bit mode
;
		PLB
		PLY
		PLX
		RTS
;
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+						+
;+	quest count set				+
;+						+
;++++++++++++++++++++++++++++++++++++++++++++++++
QSTCTST		EQU	$
		I16			; index 16bit mode
		LDX	#00013H
		LDA	!PTLMTCT
		STA	<WORK0
		DEC	A
		TAY
		STZ	<WORK2
;
QST010		EQU	$
		LDA	>MAPPTBF+1,X
		BEQ	QST015
		INC	<WORK2
		LDA	>MAPPTBF+2,X
		BEQ	QST015
		INC	<WORK2
		LDA	>MAPPTBF+3,X
		BEQ	QST015
		INC	<WORK2
QST015		EQU	$
		LDA	<WORK2
		STA	!QSTCNT,Y
		DEC	<WORK0
		BEQ	QST020
		DEY
		M16			; memory 16bit mode
		TXA
		CLC
		ADC	#0011AH
		TAX
		M8			; memory 8bit mode
		STZ	<WORK2
		BRA	QST010
;
QST020		EQU	$
		I8			; index 8bit mode
		RTS
;
;
MOJDAT		EQU	$
;			0    1	  2    3    4	 5    6	   7   
		HEX	000H,041H,042H,043H,044H,045H,046H,047H
;			8    9	  A    B    C	 D    E	   F
		HEX	048H,049H,04AH,0FFH,0FFH,0FEH,0FEH,0FEH
;
;			0    1	  2    3    4	 5    6	   7   
		HEX	000H,04BH,04CH,04DH,04EH,04FH,050H,051H
;			8    9	  A    B    C	 D    E	   F
		HEX	052H,053H,054H,0FDH,0FDH,0FEH,0FEH,0FEH
;
;			0    1	  2    3    4	 5    6	   7   
		HEX	000H,055H,056H,057H,058H,059H,05AH,020H
;			8    9	  A    B    C	 D    E	   F
		HEX	020H,02DH,05FH,020H,020H,020H,0FCH,0FCH
;
;			0    1	  2    3    4	 5    6	   7   
		HEX	000H,030H,031H,032H,033H,034H,035H,036H
;			8    9	  A    B    C	 D    E	   F
		HEX	037H,038H,039H,020H,020H,020H,0FCH,0FCH
;
;
;
;
;
;
;
		END
