;************************************************************************
;*									*
;*	title name	: "yossy map tool"				*
;*	proccess	: initial					*
;*	file name	: ysm_init					*
;*									*
;************************************************************************
;
;
		SALL
;
		include		ysm_header.inc
		include		../../../JPN/sfc/ys_color.h
		include		../../../JPN/sfc/ys_presno.h
;
		XALL
;
;
;------------------------------------------------------------------------
;-		global symbol						-
;------------------------------------------------------------------------
		GLB	MPCHRST,CHRSET,GMMDST
		GLB	MPCOLST
		GLB	DIVDTST
		GLB	MP00,GM00,ED00,FL00
;
;------------------------------------------------------------------------
;-		extern symbol						-
;------------------------------------------------------------------------
;
;-------------< ys_main >------------------------------------------------
;
;-------------< ys_rpro >------------------------------------------------
		EXT	CHIPON
;
;-------------< ys_data >------------------------------------------------
		EXT	DIVDAT
;
;-------------< ys_chr >-------------------------------------------------
		EXT	ADDSTART
;
;------------------------------------------------------------------------
;-		define symbol						-
;------------------------------------------------------------------------
;;;;		EQU
;
;
;
;************************************************************************
;*									*
;*		program start						*
;*									*
;************************************************************************
;
;
		EXTEND
;
;
		MEM8
		IDX8
;
Group_1		GROUP	Init_pro
Init_pro	SECT	REL
;
;
;************************************************************************
;*		LN^[Zbgf[^				*
;************************************************************************
;
		MEM8
		IDX8
;
;------------------------------------------------------------------------
;-		LN^[ uq`l zuf[^			-
;------------------------------------------------------------------------
CHRTBL		EQU	$
;
;-------------- }bv --------------------------------------------------
MPCHAR		EQU	$
		BYTE	CHR27B			;[ afRwiLN^[ ]
		WORD	3C00H+8000H,0800H
;
		BYTE	CHR78			;[ [hVLN^[ ( 0000-1FFF ) ]
		WORD	0000H
;
		HEX	FF	;end code
;
;
MPCHR		EQU	MPCHAR-CHRTBL
;
;------------------------------------------------------------------------
;-		}bvLN^[Zbg				-
;------------------------------------------------------------------------
;
;----------------------------------------------------------------
;-		}bvLN^[oNf[^			-
;----------------------------------------------------------------
MPCHRST		EQU	$
		PHB			;(DBR) save
		PHK			;(DBR) <-- (PBR)
		PLB
;
;-------------- [hVLN^[Zbg ------------------------------
		I16
;
		LDY	#MPCHR		;(Y) <-- character index
;
;-------------- LN^[Zbg --------------------------------------
GMCS030		EQU	$
		LDA	#MPBITMAP/400H
		STA	CIPSCB		;bitmap screen address set
;
GMCS032		EQU	$
		LDA	!CHRTBL,Y	;(A) <-- chara bank
		CMP	#0F0H
		BCC	GMCS040		;direct set ? ( yes:GMCS040 )
;
		CMP	#0FFH
		BEQ	GMCS050		;end ? ( yes:GMCS050 )
;
		SEC
		SBC	#0F0H
;
		M16
;
		AND	#00FFH
		TAX
;
		M8
;
		LDA	<WORK10,X	;(A) <-- chara bank
GMCS040		EQU	$
		LDX	!CHRTBL+1,Y	;(X) <-- VRAM address
		JSR	CHRSUB
		INY
		INY
		INY
		BRA	GMCS032
;
GMCS050		EQU	$
;
		I8
;
		PLB
		RTL
;
;------------------------------------------------------------------------
;-		LN^[Zbg					-
;-			(Y) <-- LN^[zuf[^|C^[	-
;------------------------------------------------------------------------
;
		MEM8
		IDX16
;
CHRSET		EQU	$
		PHB			;(DBR) save
		PHK			;(DBR) <-- (PBR)
		PLB
;
		JMP	GMCS030
;
;****************************************************************
;*		character buffer set & DMA			*
;*			in  : (A) <-- chara bank		*
;*			      (X) <-- VRAM address		*
;*			[ from memory-8,index-16 bit mode !! ]	*
;****************************************************************
;
		MEM8
		IDX16
;
CHRSUB		EQU	$
		STX	<WORKE		;(WKE,F) <-- VRAM address set
;
		M16
;
		AND	#00FFH		;x3
		STA	<WORKC		;(WKC,D) <-- chara bank
		ASL	A
;;;;		CLC
		ADC	<WORKC
		TAX
;
;-------------- press data convert ----------------------
		LDA	<WORKE
		BPL	CHRSB000	;摜kH ( yes:CHRSB000 )
;
;-------------- 摜kf[^ ----------------------
		LDA	!CHRTBL+3,Y
		STA	<WORKA		;(WKA,B) <-- number of byte
		INY
		INY
		PHY			;(Y) save
;
		ASL	A		;x4
		ASL	A		;
		XBA
		AND	#00FFH
		STA	R3		;(R3) <-- pless data line
;
		LDA	>ADDSTART+((NO_PRES+CHR10)*3),X
		STA	R1		;(R1)  <-- pless data address(L,H)
		LDA	>ADDSTART+((NO_PRES+CHR10)*3)+2,X
		AND	#00FFH
		STA	R0		;(R0)  <--	    "        (B)
;
		I8
;
		M_CHIP	DEF_CHR
;
		I16
;
		LDY	<WORKA		;(Y) <-- number of byte
;
		M8
;
		BRA	CHRSB002
;
		MEM16
;
;-------------- ǂڂkf[^ ------------------
CHRSB000	EQU	$
		PHY			;(Y) save
;
		LDA	>ADDSTART+(NO_PRES*3),X
		STA	R9		;(R9)  <-- pless data address(L,H)
		LDA	>ADDSTART+(NO_PRES*3)+2,X
		AND	#00FFH
		STA	R4		;(R4)  <--	    "        (B)
		LDA	#MPBITMAP
		STA	R10		;(R10) <-- data store address
;
		I8
;
		M_CHIP	DT_UNCOMPRESS
;
		I16
;
		LDA	R10
		SEC
		SBC	#MPBITMAP
		TAY			;(Y) <-- number of byte
;
		M8
;
		LDA	<WORKC
		CMP	#CHR78
		BCS	CHRSB010	;mode 7 chara ? ( yes:CHRSB010 )
;
;-------------- character DMA set -----------------------
CHRSB002	EQU	$
		LDA	#10000000B	;inc mode set
		STA	2115H
		LDX	<WORKE		;VRAM address set
		STX	2116H
;
		LDX	#00000001B+(18H*100H)	;DMA paramer & B bus address set
		STX	4300H
		LDX	#MPBITMAP		;A bus address(L,H) set
		STX	4302H
		LDA	#BANK MPBITMAP		;	"     (B) set
		STA	4304H
		STY	4305H			;number of byte set
		LDA	#00000001B
		STA	420BH			;DMA "ON" !!
;
		PLY			;(X) load
		RTS
;
;-------------- mode 7 character DMA set ----------------
CHRSB010	EQU	$
		PHB			;(DBR) save
		LDA	#BANK WORKBF
		PHA
		PLB
;
		M16
;
		TYA
		STA	<WORK		;loop no
		ASL	A
		PHA			;number of byte save
;
		LDX	#00		;(X) <-- from data pointer
		LDY	#00		;(Y) <-- to	    "
CHRSB020	EQU	$
		LDA	>MPBITMAP,X
		PHA
		AND	#0FH
		STA	WORKBF,Y
		INY
		PLA
		AND	#0F0H
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		STA	WORKBF,Y
		INX
		INY
		DEC	<WORK
		BNE	CHRSB020
;
		M8
;
		PLY
		PLB
;
		LDA	#10000000B	;inc mode set
		STA	2115H
		LDX	<WORKE		;VRAM address set
		STX	2116H
;
		LDX	#00000000B+(19H*100H)	;DMA paramer & B bus address set
		STX	4300H
		LDX	#WORKBF			;A bus address(L,H) set
		STX	4302H
		LDA	#BANK WORKBF		;	"     (B) set
		STA	4304H
		STY	4305H			;number of byte set
		LDA	#00000001B
		STA	420BH			;DMA "ON" !!
;
		PLY			;(X) load
		RTS
;
;****************************************************************
;*								*
;*		kf[^					*
;*			́F					*
;*				(A) <-- f[^mD		*
;*				(X) <-- 𓀐AhX		*
;*								*
;*			óF					*
;*				(A) <-- 𓀃f[^oCg	*
;*								*
;*			gpq`lFibbvnqjOj		*
;*								*
;****************************************************************
;
		MEM16
		IDX16
;
UNCOMPRES_X	EQU	$
		LDX	#MPBITMAP+1000H ;(X) <-- 𓀐AhX
;
UNCOMPRES	EQU	$
		STA	CCWORK0
		ASL	A
;;;;		CLC
		ADC	CCWORK0
;
		STX	CCWORK0		;(CWK0) <-- 𓀐AhX
		STX	R10		;(R10)	<--	  h
;
		TAX
;
;-------------- press data convert ----------------------
		LDA	>ADDSTART+(NO_PRES*3),X
		STA	R9		;(R9)  <-- pless data address(L,H)
		LDA	>ADDSTART+(NO_PRES*3)+2,X
		AND	#00FFH
		STA	R4		;(R4)  <--	    "        (B)
;
		I8
;
		M_CHIP	DT_UNCOMPRESS
;
		I16
;
		LDA	R10
		SEC
		SBC	CCWORK0		;(A) <-- number of byte
		RTL
;
;************************************************************************
;*		}bvJ[Zbg					*
;************************************************************************
;
		MEM8
		IDX8
;
;------------------------------------------------------------------------
;-		J[zu f[^					-
;------------------------------------------------------------------------
COLTBL		EQU	$
;		WORD	(color data pointer)
;		BYTE	(start pos),(X wide)+(Y wide*10H)
;
;-------------- }bv --------------------------------------------------
MPCOLR		EQU	$
		WORD	MAP_AICON_COL		;afACRJ[
		BYTE	031H,0FH+(04H*10H)
		WORD	TITLE_COL		;^CgJ[
		BYTE	021H,0FH+(01H*10H)
		WORD	MAP_AICON_COL		;naiACRJ[
		BYTE	0B1H,0FH+(04H*10H)
;
		WORD	(WORK10-WORK10)+8000H	;ʂJ[
		BYTE	000H,01H+(01H*10H)
		WORD	(WORK12-WORK10)+8000H	;[hVpn`J[
		BYTE	001H,0FH+(02H*10H)
		WORD	(WORK14-WORK10)+8000H	;rbg}bvnaiJ[
		BYTE	0F1H,0FH+(01H*10H)
;
		WORD	0FFFFH	;end code
;
;
MPCOL		EQU	MPCOLR-COLTBL
;
;----------------------------------------------------------------
;-		}bvJ[oNf[^			-
;----------------------------------------------------------------
MP_M7B3_COLBK	EQU	$
		WORD	MAP_M7B3_COL_0	;[0:n]
		WORD	MAP_M7B3_COL_0	;[1:]
		WORD	MAP_M7B3_COL_0	;[2:]
		WORD	MAP_M7B3_COL_1	;[3:n]
;;;;K;;;;		WORD	MAP_M7B3_COL_3	;[3:]
		WORD	MAP_M7B3_COL_4	;[4:]
		WORD	MAP_M7B3_COL_5	;[5:]
		WORD	MAP_M7B3_COL_6	;[6:]
		WORD	MAP_M7B3_COL_7	;[7:]
;
MP_BTMP_COLBK	EQU	$
		WORD	MAP_BTMP_COL_0	;[0:n]
		WORD	MAP_BTMP_COL_0	;[1:n]
		WORD	MAP_BTMP_COL_0	;[2:]
		WORD	MAP_BTMP_COL_1	;[3:n]
;;;;K;;;;		WORD	MAP_BTMP_COL_3	;[3:]
		WORD	MAP_BTMP_COL_4	;[4:]
		WORD	MAP_BTMP_COL_5	;[5:]
		WORD	MAP_BTMP_COL_6	;[6:]
		WORD	MAP_BTMP_COL_7	;[7:]
;
MPCOLST		EQU	$
		PHB			;(DBR) save
		PHK			;(DBR) <-- (PBR)
		PLB
;
		MI16
;
		LDX	MPTYPE
;
;-------------- kLJ[Zbg ----------------------------------------
		LDA	!MP_M7B3_COLBK,X
		STA	<WORK10
;
;-------------- [hVAafRpJ[Zbg --------------------------
		INC	A		;+2
		INC	A		;
		STA	<WORK12
;
;-------------- rbg}bvJ[Zbg --------------------------------
		LDA	!MP_BTMP_COLBK,X
		STA	<WORK14
;
		LDX	#MPCOL		;(X) <-- color index
;
;-------------- J[Zbg --------------------------------------------
GMCOL020	EQU	$
		LDA	#COL_ADDRESS
		STA	<WORK0
		LDA	#COL_ADDRESS/100H
		STA	<WORK1		;(WK0,1,3) <-- color data address
;
GMCOL030	EQU	$
		LDA	!COLTBL,X
		BPL	GMCOL040	;direct set ? ( yes:GMCS040 )
;
		CMP	#0FFFFH
		BEQ	GMCOL070	;end ? ( yes:GMCOL070 )
;
		AND	#7FFFH
		TAY
		LDA	WORK10,Y
GMCOL040	EQU	$
		TAY			;(Y) <-- color data pointer
		LDA	!COLTBL+3,X
		AND	#0FH
		STA	<WORK3		;(WK3,4) <-- X wide
		LDA	!COLTBL+3,X
		AND	#0F0H
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		STA	<WORK5		;(WK5,6) <-- Y wide
		LDA	!COLTBL+2,X
		AND	#00FFH
		ASL	A
		STA	<WORK7		;(WK7,8) <-- color buffer start pos
;
		PHX			;(X) save
;
GMCOL050	EQU	$
		TAX			;(X) <-- color buffer start pos
		LDA	<WORK3
		STA	<WORK9		;(WK9,A) <-- X wide
GMCOL060	EQU	$
		LDA	[<WORK0],Y
		STA	>DATACOL,X
		INY
		INY
		INX
		INX
		DEC	<WORK9
		BNE	GMCOL060
;
		LDA	<WORK7
		CLC
		ADC	#020H
		STA	<WORK7
		DEC	<WORK5
		BNE	GMCOL050
;
		PLX			;(X) load
;
		INX
		INX
		INX
		INX
		BRA	GMCOL030
;
GMCOL070	EQU	$
;
		MI8
;
		PLB
		RTL
;
;
;------------------------------------------------------------------------
;-		J[Zbg						-
;-			in  : (X) <-- J[zuf[^|C^[	-
;------------------------------------------------------------------------
;
		MEM16
		IDX16
;
COLSET		EQU	$
		PHB			;(DBR) save
		PHK			;(DBR) <-- (PBR)
		PLB
;
		JMP	GMCOL020
;
;************************************************************************
;*		game mode set						*
;*			in  : (X) <-- game mode type no.		*
;************************************************************************
GMMDIN		EQU	$
MPD00		WORD	MPMD00-GMMDDT	;[map]
EDD00		WORD	EDMD00-GMMDDT	;[edit]
FLD00		WORD	FLMD00-GMMDDT	;[file]
GMD00		WORD	GMMD00-GMMDDT	;[00]
;
MP00		EQU	MPD00-GMMDIN
ED00		EQU	EDD00-GMMDIN
FL00		EQU	FLD00-GMMDIN
GM00		EQU	GMD00-GMMDIN
;
PPUREG		EQU	$	;[21??H]
;			[BGMODE]  [BG1SCF]  [BG2SCF]  [BG3SCF]	[BG12CH]  [BG34CH]  [WIND23]  [WIND24]
;			[WIND25]  [MANSEL]  [SUBSEL]  [WMANSL]	[WSUBSL]  [WIND30]  [SUBADF]
		BYTE	05H,	  07H,	    08H,      09H,	0BH,	  0CH,	    23H,      24H
		BYTE	25H,	  2CH,	    2DH,      2EH,	2FH,	  30H,	    31H
;
GMMDDT		EQU	$
;			[NMITYP]  [IRQTYP]  [CIPSCB]  [CIPSCR]	[nuki change]
;			[BGMODE]  [BG1SCF]  [BG2SCF]  [BG3SCF]	[BG12CH]  [BG34CH]  [WIND23]  [WIND24]
;			[WIND25]  [MANSEL]  [SUBSEL]  [WMANSL]	[WSUBSL]  [WIND30]  [SUBADF]
;-------------- map mode ----------------------------------------
MPMD00		BYTE	002H,	  000H,	    00BH,     00011101B,0
		BYTE	00000000B,07CH,	    07CH,     07CH,	00110000B,01000100B,00000000B,00000000B
		BYTE	00000000B,00000000B,00000000B,00000000B,00000000B,00000000B,00111111B
;
;-------------- map data edit mode ------------------------------
EDMD00		BYTE	004H,	  000H,	    00BH,     00011101B,0
		BYTE	00000000B,000H,	    07CH,     000H,	01010000B,00000000B,00000011B,00000000B
		BYTE	00000000B,00000000B,00000000B,00000001B,00000000B,00000000B,00000000B
;
;-------------- map data edit file mode -------------------------
FLMD00		BYTE	000H,	  000H,	    018H,     00111101B,0
		BYTE	00000000B,07CH,	    000H,     000H,	00000110B,00000110B,00000000B,00000000B
		BYTE	00000000B,00010001B,00000000B,00000000B,00000000B,00000000B,00000000B
;
;-------------- normal mode -------------------------------------
GMMD00		BYTE	000H,	  000H,	    018H,     00111101B,0
		BYTE	00000001B,070H,	    074H,     078H,	00000000B,00000110B,00000000B,00000000B
		BYTE	00000000B,00010011B,00000000B,00000000B,00000000B,00000000B,00000000B
;
;
		MEM8
		IDX8
;
GMMDST		EQU	$
		PHB			;(DBR) save
		PHK			;(DBR) <-- (PBR)
		PLB
;
		I16
;
		LDY	!GMMDIN,X	:(Y) <-- game mode data pointer
;
;-------------- game mode RAM set -------------------------------
		LDA	!GMMDDT,Y	;NMI type no. set
		STA	NMITYP
		LDA	!GMMDDT+1,Y	;IRQ type no. set
		STA	IRQTYP
		LDA	!GMMDDT+2,Y	;chip screen base set
		STA	CIPSCB
		LDA	!GMMDDT+3,Y	;     "      size mode set
		STA	CIPSCR
		LDA	!GMMDDT+4,Y
		BEQ	GMDS000		;nuki color change ? ( no:GMDS000 )
;
;-------------- nuki color change -----------------------
;
		M16
;
		LDA	>DATACOL
		STA	NUKCOL
		LDA	#00
		STA	>DATACOL
;
		M8
;
GMDS000		EQU	$
		LDX	#00
GMDS010		EQU	$
		LDA	!GMMDDT+5,Y
		STA	GMMDRM,X
		INY
		INX
		CPX	#GMMDNO
		BCC	GMDS010
;
		STZ	HD420C		;H-DMA "OFF"
;
;-------------- PPU Reg. set ------------------------------------
		LDY	#2100H		;(WK0,1) <-- PPU Reg. address
		STY	<WORK
;
		I8
;
		LDX	#GMMDNO-1
GMDS020		EQU	$
		LDY	!PPUREG,X
		LDA	GMMDRM,X
		STA	(<WORK),Y
		DEX
		BPL	GMDS020
;
		LDA	#00000010B	;OBJ intial set
		STA	2101H
		STZ	2133H		;display intial set
		LDA	#10000000B	;mode 7 over flow set
		STA	211AH
		STZ	212AH		;window logic
		STZ	212BH		;     "
;
		PLB
		RTL
;
;************************************************************************
;*		warizan data set					*
;************************************************************************
DIVDTST		EQU	$
;
		MI16			; memory 16bit mode !!
;
		PHB
		LDY	#DIVBUF
		LDX	#DIVDAT
		LDA	#256*2*4+2-1
		MVN	#BANK DIVDAT,#BANK DIVBUF
		PLB
;
		MI8			; memory 8bit mode !!
;
		RTL
;
;
;
;
;
;
;
;
;
		END
