;************************************************************************
;*									*
;*	title name	: "yossy map tool"				*
;*	proccess	: map						*
;*	file name	: ysm_map					*
;*									*
;************************************************************************
;
;
		SALL
;
		include		ysm_header.inc
;
		XALL
;
;
;------------------------------------------------------------------------
;-		global symbol						-
;------------------------------------------------------------------------
		GLB	MPTSIN,MPTEST,MPTSIN2
		GLB	M_KUMO,M_SMOK,M_KAMO,M_PLAY
		GLB	PFGON
;
;------------------------------------------------------------------------
;-		extern symbol						-
;------------------------------------------------------------------------
;
;-------------< ysm_main >-----------------------------------------------
		EXT	VRAMCL,OAMCLR,BLNKOFF,URAMCLR,DMA_M_M
		EXT	MPTS,MPT2,EDT0,MNU0
;
;-------------< ysm_rpro >-----------------------------------------------
		EXT	NEWVMADL,CHIPON,BLNKON
		EXT	MPCHRST,CSNMITL
;
;-------------< ysm_init >-----------------------------------------------
		EXT	GMMDST,CHRSET,DIVDTST
		EXT	MPCOLST
		EXT	MP00,GM00
;
;-------------< ysm_title >----------------------------------------------
		EXT	MODINC,MODINC2
;
;-------------< ysm_data >-----------------------------------------------
		EXT	COS,SIN
;
;------------------------------------------------------------------------
;-		define symbol						-
;------------------------------------------------------------------------
;
;
;
;************************************************************************
;*									*
;*		program start						*
;*									*
;************************************************************************
;
;
;
		EXTEND
;
;
		MEM8
		IDX8
;
Group_1		GROUP	Map_pro
Map_pro		SECT	REL
;
;
;************************************************************************
;*		map test 1st initial					*
;************************************************************************
;
;-------------- map OBJ name --------------------------------------------
YAMA_H		EQU	01H
YAMA_M		EQU	02H
YAMA_L		EQU	03H
TOWER_T		EQU	04H
TOWER_G		EQU	05H
KAZAN		EQU	06H
SML_YAMA	EQU	07H
DAI		EQU	08H
SML_TOWER	EQU	09H
WID_TOWER	EQU	0AH
MIN_YAMA	EQU	0BH
SAKU		EQU	0CH
YANE		EQU	0DH
HOLL		EQU	0EH
TREE_1		EQU	0FH
TREE_2		EQU	10H
TREE_3		EQU	11H
TREE_4		EQU	12H
TREE_5		EQU	13H
IWA		EQU	14H
KUMO		EQU	15H
LAPUTA		EQU	16H
KEBLE		EQU	17H
KUSA		EQU	18H
FLOWER		EQU	19H
ISHI		EQU	1AH
LOPE		EQU	1BH
SMOKE_1		EQU	1CH
SMOKE_2		EQU	1DH
SMOKE_3		EQU	1EH
SMOKE_4		EQU	1FH
SMOKE_5		EQU	20H
SMOKE_6		EQU	21H
SMOKE_7		EQU	22H
KAMO_1		EQU	23H
KAMO_2		EQU	24H
KAMO_3		EQU	25H
KAMO_4		EQU	26H
KAMO_5		EQU	27H
KAMO_6		EQU	28H
KAMO_7		EQU	29H
KAMO_8		EQU	2AH
PLAYER_01	EQU	2BH
PLAYER_02	EQU	2CH
PLAYER_03	EQU	2DH
PLAYER_04	EQU	2EH
PLAYER_05	EQU	2FH
PLAYER_06	EQU	30H
PLAYER_07	EQU	31H
PLAYER_08	EQU	32H
PLAYER_09	EQU	33H
PLAYER_10	EQU	34H
PLAYER_11	EQU	35H
PLAYER_12	EQU	36H
PLAYER_13	EQU	37H
PLAYER_14	EQU	38H
PLAYER_15	EQU	39H
PLAYER_16	EQU	3AH
PLAYER_17	EQU	3BH
PLAYER_18	EQU	3CH
PLAYER_19	EQU	3DH
PLAYER_20	EQU	3EH
PLAYER_21	EQU	3FH
PLAYER_22	EQU	40H
PLAYER_23	EQU	41H
PLAYER_24	EQU	42H
PLAYER_25	EQU	43H
PLAYER_26	EQU	44H
PLAYER_27	EQU	45H
PLAYER_28	EQU	46H
PLAYER_29	EQU	47H
PLAYER_30	EQU	48H
PLAYER_31	EQU	49H
PLAYER_32	EQU	4AH
PLAYER_33	EQU	4BH
PLAYER_34	EQU	4CH
PLAYER_35	EQU	4DH
PLAYER_36	EQU	4EH
PLAYER_37	EQU	4FH
PLAYER_38	EQU	50H
PLAYER_39	EQU	51H
PLAYER_40	EQU	52H
PLAYER_41	EQU	53H
PLAYER_42	EQU	54H
PLAYER_43	EQU	55H
PLAYER_44	EQU	56H
PLAYER_45	EQU	57H
PLAYER_46	EQU	58H
PLAYER_47	EQU	59H
PLAYER_48	EQU	5AH
AYASHI_H	EQU	5BH
AYASHI_L	EQU	5CH
AYASHI_2	EQU	5DH
BIG_KINOKO	EQU	5EH
SML_KINOKO	EQU	5FH
ZENMAI		EQU	60H
BIG_CRYSTL	EQU	61H
SML_CRYSTL	EQU	62H
ISHI_T_1	EQU	63H
ISHI_T_2	EQU	64H
MIN_TOWER	EQU	65H
KINOKO_2	EQU	66H
KINOKO_3	EQU	67H
KINOKO_4	EQU	68H
KINOKO_6	EQU	69H
KINOKO_7	EQU	6AH
HOLL_MASK	EQU	6BH
AYA_WOD_L	EQU	6CH
AYA_WOD_S	EQU	6DH
IWA_L		EQU	6EH
IWA_S		EQU	6FH
J_TOWR_L	EQU	70H
J_TOWR_S	EQU	71H
GY_TOWR		EQU	72H
KUPA_TOWR	EQU	73H
BOOM_1		EQU	74H
BOOM_2		EQU	75H
BOOM_3		EQU	76H
BOOM_4		EQU	77H
BOOM_5		EQU	78H
BOOM_6		EQU	79H
BOOM_7		EQU	7AH
BOOM_8		EQU	7BH
BOOM_9		EQU	7CH
BOOM_A		EQU	7DH
HATA_01		EQU	7EH
HATA_02		EQU	7FH
HATA_03		EQU	80H
HATA_04		EQU	81H
HATA_05		EQU	82H
HATA_06		EQU	83H
HATA_07		EQU	84H
HATA_08		EQU	85H
HATA_09		EQU	86H
HATA_0A		EQU	87H
HATA_0B		EQU	88H
HATA_0C		EQU	89H
BRK_LPUT	EQU	8AH
YS_FRSH0	EQU	8BH
YS_FRSH1	EQU	8CH
YS_FRSH2	EQU	8DH
YS_FRSH3	EQU	8EH
YS_FRSH4	EQU	8FH
;
;;;;K;;;;;
;;;;K;;;;;-------------- map color data address table ----------------------------
;;;;K;;;;MPCOLTBL	EQU	$
;;;;K;;;;		WORD	17D000H+(200H-1)	;[chijyo]
;;;;K;;;;		WORD	17D200H+(200H-1)	;[chika]
;
;-------------- map mode 7 screen data address table --------------------
MPSCRTBL	EQU	$
		WORD	1AD800H			;[chijyo]
		WORD	1ADC00H			;[chika]
;
;
;-------------- H-DMA set data ------------------------------------------
;
;-------------- H-DMA parameter data ( matrix A,B ) -------------
MPHDMAP0	EQU	$
		BYTE	01000011B	;DMA control parameter
		BYTE	1BH		;    B bus address
		BYTE	LOW  HDMAPR0	;    A	    "     (L)
		BYTE	HIGH HDMAPR0	;	    "     (H)
		BYTE	BANK HDMAPR0	;	    "     (B)
;
HDMAPD0		EQU	$
		BYTE	70H+80H		;line no.
		WORD	MPHDMABF0
		BYTE	70H+80H		;line no.
		WORD	MPHDMABF0
		HEX	00		;end code
;
;-------------- H-DMA parameter data ( matrix C,D ) -------------
MPHDMAP1	EQU	$
		BYTE	01000011B	;DMA control parameter
		BYTE	1DH		;    B bus address
		BYTE	LOW  HDMAPR1	;    A	    "     (L)
		BYTE	HIGH HDMAPR1	;	    "     (H)
		BYTE	BANK HDMAPR1	;	    "     (B)
;
HDMAPD1		EQU	$
		BYTE	70H+80H		;line no.
		WORD	MPHDMABF2
		BYTE	70H+80H		;line no.
		WORD	MPHDMABF2
		HEX	00		;end code
;
;-------------- H-DMA parameter data ( BG mode ) ----------------
MPHDMAP4	EQU	$
		BYTE	00000000B	;DMA control parameter
		BYTE	05H		;    B bus address
		BYTE	LOW  HDMADB0	;    A	    "     (L)
		BYTE	HIGH HDMADB0	;	    "     (H)
		BYTE	BANK HDMADB0	;	    "     (B)
;
HDMAPD4		EQU	$
		BYTE	70H+00H		;line no.
		BYTE	11000000B	;	( BG mode 0 )
		BYTE	70H+00H		;line no.
		BYTE	00000111B	;	( BG mode 7 )
		HEX	00		;end code
;
;-------------- H-DMA parameter data ( main select ) ------------
MPHDMAP5	EQU	$
		BYTE	00000000B	;DMA control parameter
		BYTE	2CH		;    B bus address
		BYTE	LOW  HDMADB1	;    A	    "     (L)
		BYTE	HIGH HDMADB1	;	    "     (H)
		BYTE	BANK HDMADB1	;	    "     (B)
;
HDMAPD5		EQU	$
		BYTE	70H+00H		;line no.
		BYTE	00011110B	;	( BG mode 0 )
		BYTE	70H+00H		;line no.
		BYTE	00010001B	;	( BG mode 7 )
		HEX	00		;end code
;
;-------------- H-DMA parameter data ( BG4 scroll counter_H ) ---
MPHDMAP6	EQU	$
		BYTE	01000010B	;DMA control parameter
		BYTE	13H		;    B bus address
		BYTE	LOW  HDMAPR4	;    A	    "     (L)
		BYTE	HIGH HDMAPR4	;	    "     (H)
		BYTE	BANK HDMAPR4	;	    "     (B)
;
HDMAPD6		EQU	$
		BYTE	5FH+00H		;line no.
		WORD	SCCH4		;
		BYTE	01H+00H		;line no.
		WORD	MPSCH40		;
		BYTE	01H+00H		;line no.
		WORD	MPSCH41		;
		BYTE	01H+00H		;line no.
		WORD	MPSCH42		;
		BYTE	02H+00H		;line no.
		WORD	MPSCH43		;
		BYTE	03H+00H		;line no.
		WORD	MPSCH44		;
		BYTE	04H+00H		;line no.
		WORD	MPSCH45		;
		BYTE	05H+00H		;line no.
		WORD	MPSCH46		;
		BYTE	06H+00H		;line no.
		WORD	MPSCH47		;
		HEX	00		;end code
HDMAPD6E	EQU	$
;
;
MPTSIN		EQU	$
		JSL	>VRAMCL		;VRAM clear
		JSL	>URAMCLR	;use RAM clear
;
;-------------- PPU Reg. initial set ----------------------------
		LDX	#MP00		;(X) <-- map mode type no.
		JSL	>GMMDST		;game mode set
		LDA	#7CH
		STA	210AH		;BG4 screen base set
;
;-------------- mode 0 character set ----------------------------
;
		JSL	>MPCHRST	; }bvLN^[ Zbg
;
;-------------- mode 0 screen write -----------------------------
;
		M16			; memory 16bit mode
;
		LDY	#10000000B
		STY	2115H		;inc mode set
		LDA	#7C00H
		STA	2116H		;VRAM address set
		LDA	#00000001B+(18H*100H)
		STA	4300H		;DMA parameter & B bus address set
		LDA	#08F800H
		STA	4302H		;A bus address(L,H) set
		LDY	#BANK 08F800H
		STY	4304H		;	"     (B) set
		LDA	#0800H
		STA	4305H		;number of byte set
		LDX	#00000001B
		STX	420BH		;DMA "ON"
;;;;K;;;;;
;;;;K;;;;;-------------- mode 0 character set ----------------------------
;;;;K;;;;;
;;;;K;;;;		LDA	#5C00H
;;;;K;;;;		STA	2116H		;VRAM address set
;;;;K;;;;		LDA	#00000001B+(18H*100H)
;;;;K;;;;		STA	4300H		;DMA parameter & B bus address set
;;;;K;;;;		LDA	#08F000H
;;;;K;;;;		STA	4302H		;A bus address(L,H) set
;;;;K;;;;		LDY	#BANK 08F000H
;;;;K;;;;		STY	4304H		;	"     (B) set
;;;;K;;;;		LDA	#0800H
;;;;K;;;;		STA	4305H		;number of byte set
;;;;K;;;;;;;;		LDX	#00000001B
;;;;K;;;;		STX	420BH		;DMA "ON"
;;;;K;;;;;
;;;;K;;;;		LDA	#3C00H
;;;;K;;;;		STA	2116H		;VRAM address set
;;;;K;;;;		LDA	#00000001B+(18H*100H)
;;;;K;;;;		STA	4300H		;DMA parameter & B bus address set
;;;;K;;;;		LDA	#08E800H
;;;;K;;;;		STA	4302H		;A bus address(L,H) set
;;;;K;;;;		LDY	#BANK 08E800H
;;;;K;;;;		STY	4304H		;	"     (B) set
;;;;K;;;;		LDA	#0800H
;;;;K;;;;		STA	4305H		;number of byte set
;;;;K;;;;;;;;		LDX	#00000001B
;;;;K;;;;		STX	420BH		;DMA "ON"
;
;-------------- map initial RAM set -----------------------------
		JSL	>DIVDTST	;div data set
;
		M16
;
		STZ	<SCCH1		;scroll counter set
		LDA	#0E0H
		STA	<SCCV1
		STZ	<SCCH2
		LDA	#08FH
		STA	<SCCV2
		STZ	<SCCH3
		LDA	#09FH
		STA	<SCCV3
		STZ	<SCCH4
		STZ	<SCCV4
;
		LDA	#0080H		;center X pos set
		STA	CENTX
		LDA	#0180H		;center Y pos set
		STA	CENTY
;
		M8
;
;-------------- map mode 7 matrix H-DMA initial set -------------
		LDX	#04
MPTI070		EQU	$
		LDA	!MPHDMAP0,X
		STA	4370H,X
		LDA	!MPHDMAP1,X
		STA	4360H,X
;;;;		LDA	!MPHDMAP2,X
;;;;		STA	4350H,X
;;;;		LDA	!MPHDMAP3,X
;;;;		STA	4340H,X
		LDA	!MPHDMAP4,X
		STA	4330H,X
		LDA	!MPHDMAP5,X
		STA	4320H,X
		LDA	!MPHDMAP6,X
		STA	4310H,X
		DEX
		BPL	MPTI070
		LDA	#BANK MPHDMABF0
		STA	4377H
		STA	4367H
;;;;		STA	4357H
;;;;		STA	4347H
		STA	4337H
		STA	4327H
		STZ	4317H
;
		LDX	#HDMAPD6E-HDMAPD6-1
MPTI080		EQU	$
		LDA	!HDMAPD0,X
		STA	>HDMAPR0,X
		LDA	!HDMAPD1,X
		STA	>HDMAPR1,X
;;;;		LDA	!HDMAPD2,X
;;;;		STA	>HDMAPR2,X
;;;;		LDA	!HDMAPD3,X
;;;;		STA	>HDMAPR3,X
		LDA	!HDMAPD4,X
		STA	>HDMADB0,X
		LDA	!HDMAPD5,X
		STA	>HDMADB1,X
		LDA	!HDMAPD6,X
		STA	>HDMAPR4,X
		DEX
		BPL	MPTI080
;
		LDA	#11001110B
		STA	HD420C		;H-DMA "ON" !!
;
		INC	MODENO		;go to map test play !!
;
		LDA	#0A2H
		STA	!MPPLXPS
		LDA	#000H
		STA	!MPPLZPS
		STA	!MPPLYPS
;
;
;************************************************************************
;*		map test initial ( no blanking )			*
;************************************************************************
;
MPTSIN2		EQU	$
;
;
;-------------- color set ---------------------------------------
;
		JSL	>MPCOLST	; }bvJ[ Zbg
;
;;;;K;;;;;
;;;;K;;;;		I16
;;;;K;;;;;
;;;;K;;;;		LDY	MPTYPE
;;;;K;;;;		LDX	!MPCOLTBL,Y	;(X) <-- color data pointer
;;;;K;;;;;
;;;;K;;;;		PHB			;(DBR) save
;;;;K;;;;		LDA	#BANK DATACOL
;;;;K;;;;		PHA
;;;;K;;;;		PLB
;;;;K;;;;;
;;;;K;;;;		LDY	#0200H-1
;;;;K;;;;MPTI2010	EQU	$
;;;;K;;;;		LDA	>80000H,X
;;;;K;;;;		STA	DATACOL,Y
;;;;K;;;;		DEX
;;;;K;;;;		DEY
;;;;K;;;;		BPL	MPTI2010
;;;;K;;;;;
;;;;K;;;;		PLB
;
;-------------- map player initial set ------------------
;;;;		LDA	MPPLXPS-1	;map player pos initial set
;;;;		AND	#0FF00H
;;;;		STA	MPPLXPOS
;;;;		LDA	MPPLZPS-1
;;;;		AND	#0FF00H
;;;;		STA	MPPLZPOS
;
		M8
;
		LDA	MPLMODE
		CMP	#PGAT
		BNE	MPTI2062
;
		STZ	MPLMODE
;;;;		LDA	MPTYPE
;;;;		CMP	#CHIJO
;;;;		BEQ	MPTI2062
;;;;;
;;;;		LDA	#PHOL
;;;;		STA	MPLMODE
;;;;		LDA	#04H
;;;;		STA	MPPLGPW
MPTI2062	EQU	$
;
;------------------ f[^ [h CfbNX ------------------
		CMP	#PFGON
		BCC	MPTI2065
		JSR	MPCLRPT_SB
;
MPTI2065	EQU	$
		LDA	#05EH		;map player R size initial set
		STA	MPPLRSZ
		LDA	MPANGLE
		STA	MPPLANG
;
		I8
;
;-------------- 1st map set -------------------------------------
		JSL	>BLNKOFF	;NMI enable
;
		LDA	MPFADFG
		BNE	MPTI2092	;1st fade in/out ? ( no:MPTI2092 )
;
		M16
;
		LDA	#7FFFH
		STA	NUKCOL		;1st constant color set
;
		M8
;
		LDA	#1FH
		STA	MPFADR
		STA	MPFADG
		STA	MPFADB
;
MPTI2092	EQU	$
		STZ	MPFADFG		;fade in/out cancel !!
		JSL	>MPTEST0	;1st map set
;
		INC	MPFADFG
		JSR	MPFADIN		;fade initial set
;
		LDA	MPWDMAFG
		STA	MPDMAFG		;bitmap chara DMA "ON" !!
;
MPTI2100	EQU	$
		LDA	MPDMAFG
		BNE	MPTI2100	;bitmap chara DMA end ? ( no:MPTI2100 )
;
		LDA	MPBANK		;OBJ chara bank change
		EOR	#01H
		STA	MPBANK
;
		LDA	#0FH
		STA	FADNO
;
;-------------- go to next mode !! ------------------------------
		JMP	>MODINC		;go to next mode !!
;
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	f[^ [h CfbNX		+
;++++++++++++++++++++++++++++++++++++++++++++++++
MPCLRPT_SB	EQU	$
		MI16			; memory , index 16bit mode
		LDA	#00000H
		LDX	!MENUNO
		BEQ	MPCLRPT_SB_END
;
MPCLRPT_SB_LOP	EQU	$
		CLC
		ADC	#0010EH
		DEX
		BNE	MPCLRPT_SB_LOP
MPCLRPT_SB_END	EQU	$
		STA	!MPCLRPT
		TAX
		LDA	>MPTPOS,X
		ASL	A
		ASL	A
		TAX
;
		M8			; memory 8bit mode
;
		LDA	!MPOBJTYP+1,X	;w
		STA	!MPPLXPS
		STA	!MPPLXPOS+1
		STA	<WORK0
		LDA	!MPOBJTYP+2,X	;y
		STA	!MPPLZPS
		STA	!MPPLZPOS+1
		STA	<WORK1
		LDA	!MPOBJTYP+3,X	;x
		STA	!MPPLYPS
		STA	!MPPLYPOS+1
;
		STZ	!MPMVOBWK0
		STZ	!MPPLWLK
;
		I8			; index 8bit mode
;
		JSR	ANGLCALC	;angle calculate
		LDA	#0C0H
		SEC
		SBC	<WORK2
		STA	!MPANGLE
;
		M16			; memory 16bit mode
		LDA	!MPCLRPT
		LDX	!QSTCNT
		BEQ	MPCLRPT_SB_600
MPCLRPT_SB_550	EQU	$
		CLC
		ADC	#00041H
		DEX
		BNE	MPCLRPT_SB_550
;
MPCLRPT_SB_600	EQU	$
		I16			; index 16bit mode
		TAX
		LDA	>MPTQNT,X
		AND	#000FFH
		TAX
		LDA	#00000H
MPCLRPT_SB_650	EQU	$
		CLC
		ADC	#0010EH
		DEX
		BNE	MPCLRPT_SB_650
		TAX
		LDA	>MPTPOS,X
		ASL	A
		ASL	A
		STA	!MPFGONPT	; next goto point buffer set
		MI8			; memory , index 8bit mode
;
		RTS
;
;;;;K;;;;		LDA	>MPTQNT,X
;;;;K;;;;		AND	#000FFH
;;;;K;;;;		ASL	A
;;;;K;;;;		ASL	A
;;;;K;;;;		TAX
;;;;K;;;;		LDA	>MPTDAT+1,X
;;;;K;;;;		LDY	#00000H
;;;;K;;;;MPCLRPT_SB_650	EQU	$
;;;;K;;;;		CMP	!MPOBJTYP+1,Y
;;;;K;;;;		BEQ	MPCLRPT_SB_700
;;;;K;;;;		INY
;;;;K;;;;		INY
;;;;K;;;;		INY
;;;;K;;;;		INY
;;;;K;;;;		BRA	MPCLRPT_SB_650
;;;;K;;;;;
;;;;K;;;;MPCLRPT_SB_700	EQU	$
;;;;K;;;;		STY	!MPFGONPT	; next goto point buffer set
;;;;K;;;;		MI8			; memory , index 8bit mode
;;;;K;;;;;
;;;;K;;;;		RTS
;
;************************************************************************
;*		map test initial					*
;************************************************************************
;
;-------------- map test OAM data -------------------------------
MPOBX		EQU	10H
MPOBY		EQU	28H
;
MPTSOAM		EQU	$
		BYTE	040H+MPOBX,000H+MPOBY,000H,3EH	;[01]
		BYTE	060H+MPOBX,000H+MPOBY,004H,3EH	;[02]
		BYTE	080H+MPOBX,000H+MPOBY,008H,3EH	;[03]
;
		BYTE	020H+MPOBX,020H+MPOBY,040H,3EH	;[04]
		BYTE	040H+MPOBX,020H+MPOBY,044H,3EH	;[05]
		BYTE	060H+MPOBX,020H+MPOBY,048H,3EH	;[06]
		BYTE	080H+MPOBX,020H+MPOBY,04CH,3EH	;[07]
		BYTE	0A0H+MPOBX,020H+MPOBY,00CH,3EH	;[08]
;
		BYTE	010H+MPOBX,040H+MPOBY,080H,3EH	;[09]
		BYTE	030H+MPOBX,040H+MPOBY,084H,3EH	;[10]
		BYTE	050H+MPOBX,040H+MPOBY,088H,3EH	;[11]
		BYTE	070H+MPOBX,040H+MPOBY,08CH,3EH	;[12]
		BYTE	090H+MPOBX,040H+MPOBY,040H,3FH	;[13]
		BYTE	0B0H+MPOBX,040H+MPOBY,044H,3FH	;[14]
;
		BYTE	010H+MPOBX,060H+MPOBY,0C0H,3EH	;[15]
		BYTE	030H+MPOBX,060H+MPOBY,0C4H,3EH	;[16]
		BYTE	050H+MPOBX,060H+MPOBY,0C8H,3EH	;[17]
		BYTE	070H+MPOBX,060H+MPOBY,0CCH,3EH	;[18]
;
		BYTE	010H+MPOBX,080H+MPOBY,000H,3FH	;[19]
		BYTE	030H+MPOBX,080H+MPOBY,004H,3FH	;[20]
		BYTE	050H+MPOBX,080H+MPOBY,008H,3FH	;[21]
		BYTE	070H+MPOBX,080H+MPOBY,00CH,3FH	;[22]
		BYTE	090H+MPOBX,070H+MPOBY,048H,3FH	;[23]
		BYTE	0B0H+MPOBX,070H+MPOBY,04CH,3FH	;[24]
;
		BYTE	090H+MPOBX,060H+MPOBY,080H,3FH	;[25]
		BYTE	0A0H+MPOBX,060H+MPOBY,082H,3FH	;[26]
		BYTE	0B0H+MPOBX,060H+MPOBY,084H,3FH	;[27]
		BYTE	0C0H+MPOBX,060H+MPOBY,086H,3FH	;[28]
;
		BYTE	090H+MPOBX,090H+MPOBY,088H,3FH	;[29]
		BYTE	0A0H+MPOBX,090H+MPOBY,08AH,3FH	;[30]
		BYTE	0B0H+MPOBX,090H+MPOBY,08CH,3FH	;[31]
		BYTE	0C0H+MPOBX,090H+MPOBY,08EH,3FH	;[32]
;
		BYTE	000H+MPOBX,050H+MPOBY,0A0H,3FH	;[33]
		BYTE	000H+MPOBX,060H+MPOBY,0A2H,3FH	;[34]
		BYTE	000H+MPOBX,070H+MPOBY,0A4H,3FH	;[35]
		BYTE	000H+MPOBX,080H+MPOBY,0A6H,3FH	;[36]
		BYTE	0D0H+MPOBX,050H+MPOBY,0A8H,3FH	;[37]
		BYTE	0D0H+MPOBX,060H+MPOBY,0AAH,3FH	;[38]
		BYTE	0D0H+MPOBX,070H+MPOBY,0ACH,3FH	;[39]
		BYTE	0D0H+MPOBX,080H+MPOBY,0AEH,3FH	;[40]
MPTSOAME	EQU	$
;
MPTSOAMSB	EQU	$
		WORD	1010101010101010B		;[01-08]
		WORD	1010101010101010B		;[09-16]
		WORD	1010101010101010B		;[17-24]
		WORD	0000000000000000B		;[25-32]
		WORD	0000000000000000B		;[33-40]
MPTSOAMSBE	EQU	$
;
;-------------- map test bitmap data convert status data --------
MPCNVST		EQU	$
		WORD	MPCNVST0
		WORD	MPCNVST1
		WORD	MPCNVST2
		WORD	MPCNVST3
MPCNVBP		EQU	$
		WORD	MPDMABF
		WORD	MPDMABF+0E00H
		WORD	MPDMABF+0E00H*2
		WORD	MPDMABF+0E00H*3
;
;				  X	Y	number of chara
MPCNVST0	WORD	MPBITMAP+(08*20+00)*20H
		BYTE	06*2				;(1)
		WORD	MPBITMAP+(20*20+04)*20H
		BYTE	02*2				;(11)
		WORD	MPBITMAP+(08*20+01)*20H
		BYTE	06*2				;(1)
		WORD	MPBITMAP+(20*20+05)*20H
		BYTE	02*2				;(11)
		WORD	MPBITMAP+(08*20+02)*20H
		BYTE	06*2				;(2)
		WORD	MPBITMAP+(20*20+06)*20H
		BYTE	02*2				;(11)
		WORD	MPBITMAP+(08*20+03)*20H
		BYTE	06*2				;(2)
		WORD	MPBITMAP+(20*20+07)*20H
		BYTE	02*2				;(11)
		WORD	MPBITMAP+(04*20+04)*20H
		BYTE	08*2				;(3)
		WORD	MPBITMAP+(04*20+05)*20H
		BYTE	08*2				;(3)
		WORD	MPBITMAP+(04*20+06)*20H
		BYTE	08*2				;(4)
		HEX	FF
;
MPCNVST1	WORD	MPBITMAP+(04*20+07)*20H
		BYTE	08*2				;(4)
		WORD	MPBITMAP+(02*20+08)*20H
		BYTE	08*2				;(5)
		WORD	MPBITMAP+(02*20+09)*20H
		BYTE	08*2				;(5)
		WORD	MPBITMAP+(02*20+10)*20H
		BYTE	08*2				;(6)
		WORD	MPBITMAP+(02*20+11)*20H
		BYTE	08*2				;(6)
		WORD	MPBITMAP+(02*20+12)*20H
		BYTE	08*2				;(7)
		WORD	MPBITMAP+(02*20+13)*20H
		BYTE	08*2				;(7)
		HEX	FF
;
MPCNVST2	WORD	MPBITMAP+(02*20+14)*20H
		BYTE	08*2				;(8)
		WORD	MPBITMAP+(02*20+15)*20H
		BYTE	08*2				;(8)
		WORD	MPBITMAP+(02*20+16)*20H
		BYTE	08*2				;(9)
		WORD	MPBITMAP+(02*20+17)*20H
		BYTE	08*2				;(9)
		WORD	MPBITMAP+(02*20+18)*20H
		BYTE	08*2				;(10)
		WORD	MPBITMAP+(02*20+19)*20H
		BYTE	08*2				;(10)
		WORD	MPBITMAP+(18*20+08)*20H
		BYTE	04*2				;(12)
		WORD	MPBITMAP+(18*20+14)*20H
		BYTE	04*2				;(15)
		HEX	FF
;
MPCNVST3	WORD	MPBITMAP+(18*20+09)*20H
		BYTE	04*2				;(12)
		WORD	MPBITMAP+(18*20+15)*20H
		BYTE	04*2				;(15)
		WORD	MPBITMAP+(18*20+10)*20H
		BYTE	04*2				;(13)
		WORD	MPBITMAP+(18*20+16)*20H
		BYTE	04*2				;(16)
		WORD	MPBITMAP+(18*20+11)*20H
		BYTE	04*2				;(13)
		WORD	MPBITMAP+(18*20+17)*20H
		BYTE	04*2				;(16)
		WORD	MPBITMAP+(18*20+12)*20H
		BYTE	04*2				;(14)
		WORD	MPBITMAP+(18*20+18)*20H
		BYTE	04*2				;(17)
		WORD	MPBITMAP+(18*20+13)*20H
		BYTE	04*2				;(14)
		WORD	MPBITMAP+(18*20+19)*20H
		BYTE	04*2				;(17)
		WORD	MPBITMAP+(00*20+10)*20H
		BYTE	01*2				;(18)
		WORD	MPBITMAP+(00*20+12)*20H
		BYTE	01*2				;(19)
		WORD	MPBITMAP+(00*20+14)*20H
		BYTE	01*2				;(20)
		WORD	MPBITMAP+(00*20+16)*20H
		BYTE	01*2				;(21)
		WORD	MPBITMAP+(26*20+10)*20H
		BYTE	01*2				;(22)
		WORD	MPBITMAP+(26*20+12)*20H
		BYTE	01*2				;(23)
		WORD	MPBITMAP+(26*20+14)*20H
		BYTE	01*2				;(24)
		WORD	MPBITMAP+(26*20+16)*20H
		BYTE	01*2				;(25)
		WORD	MPBITMAP+(00*20+11)*20H
		BYTE	01*2				;(18)
		WORD	MPBITMAP+(00*20+13)*20H
		BYTE	01*2				;(19)
		WORD	MPBITMAP+(00*20+15)*20H
		BYTE	01*2				;(20)
		WORD	MPBITMAP+(00*20+17)*20H
		BYTE	01*2				;(21)
		WORD	MPBITMAP+(26*20+11)*20H
		BYTE	01*2				;(22)
		WORD	MPBITMAP+(26*20+13)*20H
		BYTE	01*2				;(23)
		WORD	MPBITMAP+(26*20+15)*20H
		BYTE	01*2				;(24)
		WORD	MPBITMAP+(26*20+17)*20H
		BYTE	01*2				;(25)
		HEX	FF
;
;
;-------------- angle add data ----------------------------------
ANGLADD		EQU	$
		WORD	00000H,00002H,0FFFEH,00002H
;
;-------------- BG3,4 scroll speed data -------------------------
MPBG3SCA	EQU	$
		WORD	00000H,0FFF9H,00007H,00007H
MPBG3SPD	EQU	$
		WORD	00000H,0FFFFH,00001H,00001H
MPBG4SCA	EQU	$
		WORD	00000H,0FFFEH,0000EH,0000EH
MPBG4SPD	EQU	$
		WORD	00000H,0FFFEH,00002H,00002H
;
;-------------- map fade in/out data ------------------------------------
FADECINC	EQU	$		;[FADMK]
		BYTE	00111111B	;[0]	[chijyo]
		BYTE	10111111B	;[1]
		BYTE	10111111B	;[0]	[chika]
		BYTE	00111111B	;[1]
FADINTM		EQU	$
;			B  G  R
		HEX	00,14,0A,0	;[0]	[chijyo]
		HEX	00,00,00,0	;[1]
		HEX	00,00,00,0	;[0]	[chika]
		HEX	00,00,20,0	;[1]
FADTD		EQU	$
		HEX	00,00,00,0	;[0]	[chijyo]
		HEX	00,00,00,0	;[1]
		HEX	00,00,00,0	;[0]	[chika]
		HEX	00,00,00,0	;[1]
FADAD		EQU	$
		HEX	FE,FC,FE,0	;[0]	[chijyo]
		HEX	01,02,02,0	;[1]
		HEX	FE,FF,FF,0	;[0]	[chika]
		HEX	01,01,02,0	;[1]
FADCP		EQU	$
		WORD	00000H		;[0]	[chijyo]
		WORD	07FFFH		;[1]
		WORD	00000H		;[0]	[chika]
		WORD	07FFFH		;[1]
;
MPTEST0		EQU	$
		PHB			;(DBR) save
		PHK			;(DBR) <-- (PBR)
		PLB
;
MPTEST		EQU	$
;
;-------------- OAM set -----------------------------------------
		JSL	>OAMCLR		;OAM clear !!
;
		MI16
;
		LDX	#MPTSOAME-MPTSOAM-2
MPTS010		EQU	$
		LDA	!MPTSOAM,X
		STA	>OAM,X
		DEX
		DEX
		BPL	MPTS010
;
		MI8
;
		LDX	#MPTSOAMSBE-MPTSOAMSB-1
MPTS020		EQU	$
		LDA	!MPTSOAMSB,X
		STA	>OAMSUB,X
		DEX
		BPL	MPTS020
;
;-------------- map pars data set -------------------------------
;
		M16
;
		LDX	#BANK MPPARSST
		LDA	#MPPARSST
		JSL	>CHIPON
;
;-------------- map bitmap OBJ move -----------------------------
;
		M8
;
		JSR	MPMVOBJ
;
		M16
;
;-------------- map bitmap buffer clear -------------------------
		LDX	#BANK MPBFCLR
		LDA	#MPBFCLR
		JSL	>CHIPON
;
;-------------- map bitmap buffer set ---------------------------
		LDX	#BANK MPWRITE
		LDA	#MPWRITE
		JSL	>CHIPON
;
		M8
;
;-------------- bitmap buffer trasfer ---------------------------
MPTS030		EQU	$
		LDA	MPDMAFG
		BNE	MPTS030		;bitmap chara DMA end ? ( no:MPTS030 )
;
;-------------- bitmap data convert -----------------------------
;
;-------------- memory DMA timming check ----------------
MPTS032		EQU	$
		LDA	4212H
		BPL	MPTS032
MPTS034		EQU	$
		LDA	4212H
		BMI	MPTS034
;
;-------------- memory DMA start ------------------------
;
		M16
;
		LDA	#MPCNVBF	;(WK23,24,25) <-- from address
		STA	<WORK23
		LDA	#BANK MPCNVBF
		STA	<WORK25
;
		LDX	#(4-1)*2
MPTS040		EQU	$
		STX	<WORK		;(WK0,1) <-- loop no
;
		LDA	>MPCNVST,X
		STA	>R14		;convert status data address(L,H)
		LDA	#BANK MPCNVST0
		STA	>R0		;		"           (B)
		LDX	#BANK MPBFCNV
		LDA	#MPBFCNV
		JSL	>CHIPON
;
		LDX	<WORK
		LDA	#MPDMABF/100H	;(WK20,21,22) <-- to address
		STA	<WORK21
		LDA	!MPCNVBP,X
		STA	<WORK20
;
		M8
;
;-------------- memory DMA timming check ----------------
MPTS042		EQU	$
		BIT	4212H
		BVC	MPTS042
MPTS044		EQU	$
		BIT	4212H
		BVS	MPTS044
		LDY	#04H
MPTS046		EQU	$
		DEY
		BNE	MPTS046
;
		M16
;
		LDA	#0E00H		;(A) <-- number of byte
		JSL	>DMA_M_M
;
		DEX
		DEX
		BPL	MPTS040
;
		LDA	MPBANK		;chara bank change
		EOR	#01H
		STA	MPBANK
		LDA	#03H		;DMA start "ON" !!
		STA	MPWDMAFG
;
		M8
;
;-------------- fade in/out check -------------------------------
		LDA	MPFADFG
		BEQ	MPTS200		;fade ? ( no:MPTS200 )
;
;;;KK;;;		LDA	MPTYPE
;;;KK;;;		ORA	FADMK
;;;KK;;;		TAY
		LDA	#000H		
		ORA	FADMK
		TAY
;
		LDX	!FADECINC,Y
		STX	SUBADF		;constant color sub & add set
;
		ASL	A
		PHA			;fade type save
		ASL	A
		TAY			;(X) <-- color add data start pointer
;
		LDX	#(3-1)*2
MPTS050		EQU	$
		DEC	MPFADRTM,X
		BPL	MPTS080		;color change timming ? ( no:MPTS080 )
;
		LDA	!FADTD,Y
		STA	MPFADRTM,X	;timer set
		LDA	MPFADR,X
		CLC
		ADC	!FADAD,Y
		BPL	MPTS060
		LDA	#00
MPTS060		EQU	$
		CMP	#01FH
		BCC	MPTS070
		LDA	#1FH
MPTS070		EQU	$
		STA	MPFADR,X
MPTS080		EQU	$
		INY
		DEX
		DEX
		BPL	MPTS050
;
		M16
;
		LDA	MPFADB
		ASL	A
		ASL	A
		ASL	A
		ASL	A
		ASL	A
		ORA	MPFADG
		ASL	A
		ASL	A
		ASL	A
		ASL	A
		ASL	A
		ORA	MPFADR
		STA	NUKCOL
;
		PLX			;fade type load
		CMP	!FADCP,X
;
		M8
;
		BNE	MPTS100		;fade end ? ( no:MPTS100 )
;
;-------------- fade end check --------------------------
		LDA	FADMK
		EOR	#01H
		STA	FADMK
		BEQ	MPTS090		;fade in end ? ( no:MPTS090 )
;
		STZ	MPFADFG		;map fade in/out flag "OFF" !!
		PLB
		RTL
;
;-------------- go to next set !! ---------------
MPTS090		EQU	$
		LDA	#MPT2
		STA	MODENO		;go to next map !!
		LDA	MPGOTYPE
		STA	MPTYPE		;go to map type set
;
MPTS100		EQU	$
		PLB
		RTL
;
MPTS200		EQU	$
		LDA	<MOUSEBB
		AND	#10000000B
		BEQ	MPTS210
		LDA	<MOUSEBT
		AND	#01000000B
		BEQ	MPTS210		;return to edit mode ? ( no:MPTS210 )
;
		LDA	#EDT0
		STA	!MODENO
		STZ	!MPMVOBWK0
		STZ	!MPMVOBWK0+1
		LDA	!POINTFG
		BEQ	MPTS210
		LDA	#MNU0
		STA	!MODENO
		LDX	!MPFGONPT
		LDA	!MPFGONTY	; jbgmn. ǂ
		STA	!MPOBJTYP,X
MPTS210		EQU	$
		PLB
		RTL
;
;****************************************************************
;		map bitmap OBJ move				*
;****************************************************************
MPMVOBSB	EQU	$-2
MV_KUMO		WORD	KUMOMOV		;kumo
MV_SMOK		WORD	SMOKMOV		;kazan smoke
MV_KAMO		WORD	KAMOMOV		;kamome
MV_PLAY		WORD	PLAYMOV		;player
MV_GATE		WORD	GATEMOV		;gate
;
M_KUMO		EQU	MV_KUMO-MPMVOBSB
M_SMOK		EQU	MV_SMOK-MPMVOBSB
M_KAMO		EQU	MV_KAMO-MPMVOBSB
M_PLAY		EQU	MV_PLAY-MPMVOBSB
M_GATE		EQU	MV_GATE-MPMVOBSB
;
;
MPMVOBJ		EQU	$
		LDY	#(MPMVOBN-1)*4
MPMO010		EQU	$
		LDX	MPMVOBJNO,Y
		BEQ	MPMO030		;move ? ( no:MPMO030 )
;
		LDA	MPMVOBTM0,Y	;timer set
		BEQ	MPMO020
		DEC	A
		STA	MPMVOBTM0,Y
MPMO020		EQU	$
		JSR	(!MPMVOBSB,X)	;type select
;
MPMO030		EQU	$
		DEY
		DEY
		DEY
		DEY
		BPL	MPMO010
		RTS
;
;----------------------------------------------------------------
;		gate move					-
;----------------------------------------------------------------
GATEPTN		EQU	$
;		BYTE	GATE_0,GATE_D,GATE_C,GATE_B,GATE_A,GATE_9,GATE_8,GATE_7
;		BYTE	GATE_7,GATE_6,GATE_5,GATE_4,GATE_3,GATE_2,GATE_1,GATE_0
;
GATEMOV		EQU	$
		LDA	MPMVOBWK0,Y
		SEC
		SBC	MPANGLE
		SEC
		SBC	#08H/2
		AND	#0FH*8
		LSR	A
		LSR	A
		LSR	A
		TAX
		LDA	!GATEPTN,X
		STA	MPPLTYP,Y
		RTS
;
;----------------------------------------------------------------
;		kumo move					-
;----------------------------------------------------------------
KUMOMOV		EQU	$
		STZ	<WORK		;(WK0) <-- center X pos
		STZ	<WORK+1		;(WK1) <--    "   Y  "
		LDA	MPMVOBWK0,Y	;(A) <-- angle
		INC	A
		STA	MPMVOBWK0,Y
		LDX	#40H		;(X) <-- R
		JMP	ROTCALC		;rotation caluclate
;
;----------------------------------------------------------------
;		kazan smoke move				-
;----------------------------------------------------------------
MPSMKXP		EQU	$
		HEX	30,30,30,2F,2F,30
		HEX	31,31,30,2F,2F,30
		HEX	31
MPSMKPT		EQU	$
		BYTE	SMOKE_1,SMOKE_2,SMOKE_3,SMOKE_3,SMOKE_3,SMOKE_3
		BYTE	SMOKE_3,SMOKE_3,SMOKE_3,SMOKE_4,SMOKE_5,SMOKE_6
		BYTE	SMOKE_7
SMKMX		EQU	MPSMKPT-MPSMKXP
;
SMOKMOV		EQU	$
		LDA	MPPLYPS,Y	;smoke Y pos set
		INC	A
		INC	A
		STA	MPPLYPS,Y
		LDX	MPMVOBWK0,Y
		INX
		CPX	#SMKMX
		BCC	SMKM010
		LDX	#00
		LDA	#1AH
		STA	MPPLYPS,Y	;smoke Y pos reset
SMKM010		EQU	$
		TXA
		STA	MPMVOBWK0,Y
		LDA	!MPSMKXP,X
		STA	MPPLXPS,Y	;smoke X pos set
		STA	MPPLZPS,Y	;  "   Z    "
		LDA	!MPSMKPT,X
		STA	MPPLTYP,Y	;pattern no. set
		RTS
;
;----------------------------------------------------------------
;		kamome move					-
;----------------------------------------------------------------
KAMOPT		EQU	$
		BYTE	KAMO_1,KAMO_2,KAMO_3,KAMO_4,KAMO_5,KAMO_6,KAMO_7,KAMO_8
KAMOPTE		EQU	$
KAMMX		EQU	KAMOPTE-KAMOPT
;
KAMOMOV		EQU	$
		LDX	MPMVOBWK1,Y
		INX
		CPX	#KAMMX
		BCC	KAMM010
		LDX	#00
KAMM010		EQU	$
		TXA
		STA	MPMVOBWK1,Y
		LDA	!KAMOPT,X
		STA	MPPLTYP,Y
		LDA	#28H
		STA	<WORK		;(WK0) <-- center X pos
		LDA	#08H
		STA	<WORK+1		;(WK1) <--    "   Y  "
		LDA	MPMVOBWK0,Y	;(A) <-- angle
		CLC
		ADC	#4
		STA	MPMVOBWK0,Y
		LDX	#18H		;(X) <-- R
		JMP	ROTCALC		;rotation caluclate
;
;--------------------------------------------------------
;-		rotation caluclate			-
;-			in  : (WK0) <-- center X pos	-
;-			      (WK1) <--	   "   Z  "	-
;-			      (A)   <-- angle		-
;-			      (X)   <-- R		-
;--------------------------------------------------------
ROTCALC		EQU	$
		STX	<WORK+2
;
		MI16
;
		AND	#00FFH
		ASL	A
		TAX
		LDA	>COS,X
		STA	<WORK+3
		BPL	ROTCL010
		EOR	#0FFFFH
		INC	A
ROTCL010	EQU	$
		CMP	#0100H
;
		M8
;
		BCS	ROTCL020	;1.0 ? ( yes:ROTCL020 )
;
		STA	4202H
		LDA	<WORK+2
		STA	4203H
		NOP
		NOP
		NOP
		NOP
		LDA	4216H
		ASL	A		;(C) <-- 0.5
		LDA	4217H
		ADC	#0
		BRA	ROTCL030
;
ROTCL020	EQU	$
		LDA	<WORK+2
ROTCL030	EQU	$
		BIT	<WORK+4
		BPL	ROTCL040
		EOR	#0FFH
		INC	A
ROTCL040	EQU	$
		CLC
		ADC	<WORK
		STA	MPPLXPS,Y
;
		M16
;
		LDA	>SIN,X
		STA	<WORK+3
		BPL	ROTCL050
		EOR	#0FFFFH
		INC	A
ROTCL050	EQU	$
		CMP	#0100H
;
		M8
;
		BCS	ROTCL060	;1.0 ? ( yes:ROTC060 )
;
		STA	4202H
		LDA	<WORK+2
		STA	4203H
		NOP
		NOP
		NOP
		NOP
		LDA	4216H
		ASL	A		;(C) <-- 0.5
		LDA	4217H
		ADC	#0
		BRA	ROTCL070
;
ROTCL060	EQU	$
		LDA	<WORK+2
ROTCL070	EQU	$
		BIT	<WORK+4
		BPL	ROTCL080
		EOR	#0FFH
		INC	A
ROTCL080	EQU	$
		CLC
		ADC	<WORK+1
		STA	MPPLZPS,Y
;
		I8
;
		RTS
;
;----------------------------------------------------------------
;		player move					-
;----------------------------------------------------------------
MPPLANAD	EQU	$
		HEX	00,FF,01,01
MPPLRAD		EQU	$
		HEX	00,02,FE,FE
MPPLRCP		EQU	$
		HEX	00,6A,54,54
;
MPLMVANG	EQU	$-1
; KEYC1 & 00001111B -->	 1  2  3  4  5	6  7  8	 9  A  B  C  D	E  F
		HEX	00,80,00,C0,20,60,20,40,E0,A0,E0,C0,E0,A0,E0
MPLCHPT		EQU	$
		BYTE	PLAYER_01,PLAYER_06,PLAYER_11,PLAYER_16,PLAYER_21,PLAYER_26,PLAYER_31,PLAYER_36  ;[ stop ]
		BYTE	PLAYER_02,PLAYER_07,PLAYER_12,PLAYER_17,PLAYER_22,PLAYER_27,PLAYER_32,PLAYER_37  ;[walk.1]
		BYTE	PLAYER_03,PLAYER_08,PLAYER_13,PLAYER_18,PLAYER_23,PLAYER_28,PLAYER_33,PLAYER_38  ;[  " .2]
		BYTE	PLAYER_04,PLAYER_09,PLAYER_14,PLAYER_19,PLAYER_24,PLAYER_29,PLAYER_34,PLAYER_39  ;[  " .3]
		BYTE	PLAYER_05,PLAYER_10,PLAYER_15,PLAYER_20,PLAYER_25,PLAYER_30,PLAYER_35,PLAYER_40  ;[  " .4]
		BYTE	PLAYER_02,PLAYER_07,PLAYER_41,PLAYER_17,PLAYER_22,PLAYER_27,PLAYER_45,PLAYER_37  ;[  " .5]
		BYTE	PLAYER_03,PLAYER_08,PLAYER_42,PLAYER_18,PLAYER_23,PLAYER_28,PLAYER_46,PLAYER_38  ;[  " .6]
		BYTE	PLAYER_04,PLAYER_09,PLAYER_43,PLAYER_19,PLAYER_24,PLAYER_29,PLAYER_47,PLAYER_39  ;[  " .7]
		BYTE	PLAYER_05,PLAYER_10,PLAYER_44,PLAYER_20,PLAYER_25,PLAYER_30,PLAYER_48,PLAYER_40  ;[  " .8]
;
PLAYMOV		EQU	$
;
		M16
;
		STZ	MPWBG3AD
		STZ	MPWBG4AD
		STZ	MPBG3SP
		STZ	MPBG4SP
;
		M8
;
		LDX	MPLMODE
		JSR	(!PLMVSB,X)
		RTS
;
PLMVSB		EQU	$
		WORD	PLWLK0		;key walk
PHOLE		WORD	PLHOLE		;holl in
PGATE		WORD	PLGATE		;go to gate
;
PFLGON		WORD	PLFLGON0	;go to next point Flag "ON" ( initial )
		WORD	PLFLGON1	;	     "              ( point hand zoom up )
		WORD	PLFLGON2	;	     "              (      "	 move )
		WORD	PLFLGON1	;	     "              (      "	 zoom down & point zoom up )
PWALK0		WORD	MPMODINC	;	 "        walk ( initial )
		WORD	PLWALK0		;	   "           ( walk )
PWALK1		WORD	PLWALK1		;EFCg
;
;
PHOL		EQU	PHOLE-PLMVSB
PGAT		EQU	PGATE-PLMVSB
;
PFGON		EQU	PFLGON-PLMVSB
PWLK0		EQU	PWALK0-PLMVSB
PWLK1		EQU	PWALK1-PLMVSB
;
;
;----------------------------------------------------------------
;-		key walk					-
;----------------------------------------------------------------
PLWLK0		EQU	$
		LDA	MPFADFG
		BEQ	PWK010		;now fade in/out ? ( no:PLYM010 )
		RTS
;
PWK010		EQU	$
;;;;		LDA	MPTYPE
;;;;		CMP	#CHIKA
;;;;		BNE	PWK020		;chika ? ( no:PWK020 )
;;;;		LDA	KEYB2
;;;;		AND	#00100000B
;;;;		BEQ	PWK020		;go to chijyo ? ( no:PWK020 )
;;;;
;;;;;--------------	go to chijyo initial set --------
;;;;		LDA	#CHIJO		;(A) <-- map type
;;;;		JMP	MPCHANG
;;;;;
;-------------- player move -------------------------------------
PWK020		EQU	$
;
;-------------- player pos move -------------------------
		LDA	KEYA1
		AND	#00001111B
		BNE	PWK022		;move key in ? ( yes:PWK022 )
		JMP	PWK070
;
;-------------- player muki set -----------------
PWK022		EQU	$
		TAX
		LDA	!MPLMVANG,X
		STA	MPMVOBWK0,Y	;move angle set
;
;-------------- player walk mode select ---------
;
;
;
;-------------- player pos rotation -------------
		TXA
		AND	#00000011B
		BEQ	PWK040		;side move ? ( no:PWK040 )
;
		TAX
		LDA	MPPLANG
		CLC
		ADC	!MPPLANAD,X
		STA	MPPLANG
		SEC
		SBC	MPANGLE
		CLC
		ADC	#08H
		CMP	#08H*2+1
		BCC	PWK040		;map scroll ? ( no:PWK040 )
;
		BMI	PWK030
;;;;		SEC
		SBC	#08H*2
PWK030		EQU	$
		CLC
		ADC	MPANGLE
		STA	MPANGLE
;
		M16
;
		PHY
;
		LDA	KEYA2
		AND	#00000011B
		ASL	A
		TAY
		LDA	!MPBG3SCA,Y
		STA	MPWBG3AD
		LDA	!MPBG4SCA,Y
		STA	MPWBG4AD
		BEQ	PWK032		;1st rotation ? ( no:PWK032 )
;
		LDX	#00
		BRA	PWK034
;
PWK032		EQU	$
		STZ	MPBG3AD
		STZ	MPBG4AD
PWK034		EQU	$
		TXA
		ASL	A
		TAX
		LDA	!MPBG3SPD,X
		STA	MPBG3SP
		LDA	!MPBG4SPD,X
		STA	MPBG4SP
;
		PLY
;
		M8
;
;-------------- player pos up & down move -------
PWK040		EQU	$
		LDA	KEYA1
		AND	#00001100B
		LSR	A
		LSR	A
		TAX
		LDA	MPPLRSZ
		CMP	!MPPLRCP,X
		BEQ	PWK050		;up & down max ? ( yes:PWK050 )
;
		CLC
		ADC	!MPPLRAD,X
		STA	MPPLRSZ
		BRA	PWKSUB
;
;-------------- gate in check -----------
PWK050		EQU	$
		CPX	#00001000B>>2
		BNE	PWKSUB		;up ? ( no:PWKSUB )
;
		LDA	MPPLANG
		CLC
		ADC	#01H
		AND	#1FH
		CMP	#01H*2+1
		BCS	PWKSUB		;gate area ? ( no:PWKSUB )
;
		LDA	#PGAT
		STA	MPLMODE		;go to gate in !!
;
;-------------- walk pattern set ----------------
PWKSUB		EQU	$
		LDA	MPMVOBWK1,Y
		INC	A
		AND	#07H
		STA	MPMVOBWK1,Y	;walk pattern pointer set
		INC	A		;[ 1- <-- 0- ]
;
PWK070		EQU	$
		ASL	A
		ASL	A
		ASL	A
		STA	<WORK
		LDA	MPMVOBWK0,Y
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		ORA	<WORK
		TAX
		LDA	!MPLCHPT,X
		STA	MPPLTYP,Y	;pattern no. set
;
		STZ	MPPLGPW		;G power clear !!
		JMP	MPPLCAL		;player pos calculate
;
;----------------------------------------------------------------
;-		holl in						-
;----------------------------------------------------------------
PLHOLE		EQU	$
		JSR	MPPLCAL		;player pos calculate
;
		LDA	MPFADFG
		BEQ	PHL000		;now fade in/out ? ( no:PHL000 )
;
		LDA	MPPLYPS,Y
		BMI	PHL040		;jump down ? ( no:PHL040 )
;
PHL000		EQU	$
		LDA	MPPLGPW
		CMP	#04H
		BCS	PHL010		;G power max ? ( no:PHL010 )
		INC	MPPLGPW
PHL010		EQU	$
		LDA	MPPLYPS,Y
		SEC
		SBC	MPPLGPW
		STA	MPPLYPS,Y
		BNE	PHL020		;holl in move end ? ( no:PHL020 )
;
;-------------- holl in move end !! -------------
		STZ	MPLMODE		;go to key walk !!
		RTS
;
PHL020		EQU	$
		CMP	#0E7H
		BNE	PHL040		;go to chika ? ( no:PHL040 )
;
;-------------- go to chika initial set ---------
;;;;		LDA	#CHIKA		;(A) <-- map type
;;;;		LDA	#CHIJO		;(A) <-- map type
		LDA	#00
MPCHANG		EQU	$
		STA	MPGOTYPE	;map go to type set
		INC	MPFADFG		;fade flag "ON" !!
;
;-------------- fade initial set --------------------------------
MPFADIN		EQU	$
		PHY
;
		LDA	MPTYPE
		ORA	FADMK
		ASL	A
		ASL	A
		TAX
		LDY	#(3-1)*2
PHL030		EQU	$
		LDA	!FADINTM,X
		STA	MPFADRTM,Y	;constant color add fade initial wait timer set ( red )
		INX
		DEY
		DEY
		BPL	PHL030
;
		PLY
;
PHL040		EQU	$
		RTS
;
;----------------------------------------------------------------
;-		go to gate					-
;----------------------------------------------------------------
PLGATE		EQU	$
		LDA	MPPLRSZ
		SEC
		SBC	#02H
		STA	MPPLRSZ
		CMP	#04CH
		BNE	PGT020		;fade start ? ( no:PGT020 )
;
;-------------- go to next map initial set ------
;;;;		LDA	#CHIKA
;;;;		LDX	MPTYPE
;;;;		CPX	#CHIJO
;;;;		BEQ	PGT010
;;;;		LDA	#CHIJO		;(A) <-- map type
		LDA	#00
PGT010		EQU	$
		JSR	MPCHANG
;
PGT020		EQU	$
		JMP	PWKSUB
;
;
;--------------------------------------------------------
;-		map player pos calculate		-
;--------------------------------------------------------
MPPLCAL		EQU	$
;
		MI16
;
		LDA	MPPLANG
		AND	#00FFH
		ASL	A
		TAX
		LDA	>SIN,X
		PHP
		BPL	MPCL010
		EOR	#0FFFFH
MPCL010		EQU	$
		CMP	#0100H
		XBA
;
		M8
;
		LDA	MPPLRSZ		;(A) <-- R
		BCS	MPCL020
;
		STA	4202H
		XBA
		STA	4203H
		NOP
		NOP
		NOP
		NOP
		LDA	4216H
		ASL	A
		LDA	4217H
		ADC	#0
MPCL020		EQU	$
		PLP
;
		MEM16
;
		BPL	MPCL030
		EOR	#0FFFFH
		INC	A
MPCL030		EQU	$
		STA	MPPLXPS,Y
;
		LDA	>COS,X
		PHP
		BPL	MPCL040
		EOR	#0FFFFH
MPCL040		EQU	$
		CMP	#0100H
		XBA
;
		M8
;
		LDA	MPPLRSZ		;(A) <-- R
		BCS	MPCL050
;
		STA	4202H
		XBA
		STA	4203H
		NOP
		NOP
		NOP
		NOP
		LDA	4216H
		ASL	A
		LDA	4217H
		ADC	#0
MPCL050		EQU	$
		PLP
;
		MI8
;
		BMI	MPCL060
		EOR	#0FFH
		INC	A
MPCL060		EQU	$
		STA	MPPLZPS,Y
		RTS
;
;
;
;;;;		CLC
;;;;		ADC	MPANGLE
;;;;;
;;;;		MI16
;;;;;
;;;;		AND	#00FFH
;;;;		ASL	A
;;;;		TAX
;;;;		LDA	>COS,X
;;;;		ASL	A		;2 dot move
;;;;		CLC
;;;;		ADC	MPPLXPOS
;;;;		STA	MPPLXPOS
;;;;		LDA	>SIN,X
;;;;		ASL	A		;2 dot move
;;;;		CLC
;;;;		ADC	MPPLZPOS
;;;;		STA	MPPLZPOS
;;;;;
;;;;		MI8
;;;;;
;;;;		XBA
;;;;		STA	MPPLZPS,Y
;;;;		LDA	MPPLXPOS+1
;;;;		STA	MPPLXPS,Y
;
;----------------------------------------------------------------
;-		go to next point Flag "ON"( initial )		-
;----------------------------------------------------------------
PLFLGON0	EQU	$
		LDA	!FADNO
		BMI	PLFLGON0_PAS
		BEQ	PLFLGON0_PAS
		LDA	!MPFADFG
		BEQ	PLFLGON0_SET
PLFLGON0_PAS	EQU	$
		RTS
;
PLFLGON0_SET	EQU	$
		I16
;
		LDX	!MPFGONPT	;(X) <-- parts pointer
		LDA	!MPOBJTYP,X	;point parts type no. set
		STA	!MPFGONTY
;;;		LDA	#POINT_HAND	;hand point parts type no. set
		STA	!MPOBJTYP,X
;
		I8			; index 8bit mode
		JMP	MPMODINC	;go to next mode !!
;
;----------------------------------------------------------------
;-		go to next point Flag "ON"( point hand zoom up )-
;----------------------------------------------------------------
FGONZOMAD	EQU	$
		WORD	00040H,0FFE0H
;
FGONPOSAD	BYTE	004H,0FCH,004H,0FCH,004H,0FCH,000H,000H,000H,000H
;
FGONZOMAD2	WORD	0FFC0H
FGONZOMAD3	WORD	00020H,0FFF0H,00040H,0FFE0H
FGONZOMCP	EQU	$
		WORD	00180H,00100H
;
FGONPOSCP	BYTE	000H,000H,000H,000H,000H,000H,000H,000H,000H,000H
;
		WORD	00000H
		WORD	00100H,000E0H,00180H,00100H
;
PLFLGON1	EQU	$
		LDA	MPFADFG
		BNE	PFG020		;now fade in/out ? ( yes:PFG020 )
;
		PHY			;(Y) save
;
		MI16
;
		LDX	MPFGONPT	;(X) <-- parts pointer
		LDY	MPFGONCT	;(Y) <-- zoom control counter
		LDA	MPWOBJSIZ,X
		CLC
		ADC	!FGONZOMAD,Y
		PHA
		SEC
		SBC	!FGONZOMCP,Y
		EOR	!FGONZOMAD,Y
		ASL	A		;(C) <-- (N)
		PLA
		BCS	PFG010		;zoom ok ? ( no:PFG010 )
;
		INY
		INY
		STY	MPFGONCT
		CPY	#FGONPOSAD-FGONZOMAD
		BEQ	PFG000		;zoom end ? ( yes:PFG000 )
		CPY	#FGONZOMAD3-FGONZOMAD
		BNE	PFG0FF		;zoom end ? ( no:PFG0FF )
;
;-------------- point <-- hand parts change ---------------------
;
		M8
;
		LDA	MPFGONTY
		STA	MPOBJTYP,X
;
		M16
;
		BRA	PFG002
;
PFG0FF		EQU	$
		CPY	#FGONZOMCP-FGONZOMAD
		BNE	PFG010		;zoom end ? ( no:PFG010 )
;
;-------------- go to next mode ---------------------------------
PFG000		EQU	$
		JSR	MPMODINC	;go to next mode !! [ (Y) not break !! ]
PFG002		EQU	$
		LDA	!FGONZOMCP-2,Y
PFG010		EQU	$
		STA	MPWOBJSIZ,X	;size reset
;
		MI8
;
		PLY			;(Y) load
;
PFG020		EQU	$
		RTS
;
;----------------------------------------------------------------
;-		go to next point Flag "ON"( point hand move )	-
;----------------------------------------------------------------
PLFLGON2	EQU	$
		PHY			;(Y) save
;
		MI16
;
		LDA	MPANGLE
		ASL	A
		TAX
		LDA	>COS,X
		STA	<WORK		;(WK0,1) <-- cos data sigh save
		BPL	PFG210
		EOR	#0FFFFH
		INC	A
PFG210		EQU	$
		PHA			;ABS(cos) data save
;
		LDA	>SIN,X
		STA	<WORK2		;(WK2,3) <-- sin data sigh save
		BPL	PFG220
		EOR	#0FFFFH
		INC	A
PFG220		EQU	$
;
;-------------- Z pos move --------------------------------------
		CMP	#0100H		;(C) <-- [ >100H ]
;
		M8
;
		XBA
		LDX	MPFGONCT	;(X) <-- zoom control counter
		LDA	!FGONZOMAD,X
		STA	<WORK4		;(WK4) <-- add data sigh save
		BPL	PFG222
		EOR	#0FFH
		INC	A
PFG222		EQU	$
		STA	<WORK5		;(WK5) <-- ABS(add data)
		BCS	PFG230
;
		STA	4202H
		XBA
		STA	4203H
		NOP
		NOP
		NOP
		NOP
		LDA	4217H
PFG230		EQU	$
		PHA
		LDA	<WORK3
		EOR	<WORK4
		ASL	A		;(C) <-- (NN)
		PLA
		BCC	PFG240
		EOR	#0FFH
		INC	A
PFG240		EQU	$
		LDY	MPFGONPT	;(Y) <-- parts pointer
		CLC
		ADC	MPOBJZPS,Y
		STA	MPOBJZPS,Y
;
;-------------- X pos move --------------------------------------
		PLA
		XBA
		PLA
		LSR	A		;(C) <-- [ >100H ]
		LDA	<WORK5
		BCS	PFG250
;
		STA	4202H
		XBA
		STA	4203H
		NOP
		NOP
		NOP
		NOP
		LDA	4217H
PFG250		EQU	$
		PHA
		LDA	<WORK1
		EOR	<WORK4
		ASL	A		;(C) <-- (NN)
		PLA
		BCC	PFG260
		EOR	#0FFH
		INC	A
PFG260		EQU	$
		CLC
		ADC	MPOBJXPS,Y
		STA	MPOBJXPS,Y
;
;-------------- Y pos move --------------------------------------
		LDA	MPOBJYPS,Y
		CLC
		ADC	!FGONZOMAD,X
		STA	MPOBJYPS,Y
;
		I8
;
		PLY			;(Y) load
;
		INX
		STX	MPFGONCT
		CPX	#FGONZOMAD2-FGONZOMAD
		BNE	PFG270		;pos move end ? ( no:PFG270 )
;
;;;;K;;;;		LDA	#15H		;[]
;;;;K;;;;		STA	SOUND3
;
MPMODINC	EQU	$
		INC	MPLMODE
		INC	MPLMODE
PFG270		EQU	$
		RTS
;
;----------------------------------------------------------------
;-		go to next point walk				-
;----------------------------------------------------------------
PLWALK0		EQU	$
		LDA	MPFADFG
		BNE	PWK0070		;now fade in/out ? ( yes:PLYM0070 )
;
		LDA	MPMVOBWK0,Y
		BNE	PWK0050		;next walk point check ? ( no:PWK0050 )
;
;-------------- next walk set -----------------------------------
;
		I16
;
		LDX	!MPCLRPT
		LDA	>MAPPTBF+11,X
		BPL	PWK0020		;0 walk point end ? ( no:PWK0020 )
;
;-------------- 0 walk point set ----------------
		LDX	MPFGONPT
		LDA	MPPLXPS,X
		STA	MPGOTOXP	;go to next point X pos set
		LDA	MPPLZPS,X
		STA	MPGOTOZP	;go to next point Z pos set
		LDA	MPPLYPS,X
		BRA	PWK0030
;
;-------------- walk point read -----------------
PWK0020		EQU	$
		LDA	>MAPPTBF+12,X
		STA	MPGOTOXP	;go to next point X pos set
		LDA	>MAPPTBF+13,X
		STA	MPGOTOZP	;	"         Z    "
		LDA	>MAPPTBF+14,X
;
;-------------- next walk speed calculate ---------------
PWK0030		EQU	$
		STA	MPGOTOYP	;go to next point Y pos set
;
		I8
;
		JSR	PWKCAL		;player walk speed calculate
;
;-------------- player pos move ---------------------------------
PWK0050		EQU	$
		JSR	PSCALC		;player pos calculate
;
;-------------- player walk pattern no. set ---------------------
		LDA	MPPLWLK
		INC	A
		CMP	#08H+1
		BCC	PWK0060
		LDA	#01H
PWK0060		EQU	$
		STA	MPPLWLK
;
PWK0070		EQU	$
		RTS
;
;----------------------------------------------------------------
;-		player walk speed calculate			-
;-			in  : (MPGOTOXP) <-- go to X pos	-
;-			      (MPGOTOZP) <--   "   Z  "		-
;-			      (MPGOTOYP) <--   "   Y  "		-
;----------------------------------------------------------------
;
		MEM8
		IDX8
;
PWKCAL		EQU	$
		PHY			;(Y) save
;
;-------------- player walk speed set -------------------
		LDA	MPGOTOXP
		SEC
		SBC	MPPLXPS,Y
		STA	<WORK3		;(WK3) <-- X move muki
		ABS8
		STA	<WORK4		;(WK4) <-- ABS( X move size )
		LDA	MPGOTOZP
		SEC
		SBC	MPPLZPS,Y
		STA	<WORK5		;(WK5) <-- Z move muki
		ABS8
		STA	<WORK6		;(WK6) <-- ABS( Z move size )
		LDA	MPGOTOYP
		SEC
		SBC	MPPLYPS,Y
		STA	<WORK7		;(WK7) <-- Z move muki
		ABS8
		STA	<WORK8		;(WK8) <-- ABS( Y move size )
;
		LDY	#04		;(Y) <-- big size index
		CMP	<WORK6
		BCS	PWCL010
		LDY	#02
		LDA	<WORK6
PWCL010		EQU	$
		CMP	<WORK4
		BCS	PWCL020
		LDY	#00
		LDA	<WORK4
PWCL020		EQU	$
		STA	MPGOTOCT	;walk counter set
		STY	<WORK9		;(WK9) <-- big size index
;
		LDX	#04
PWCL030		EQU	$
		CPX	<WORK9
		BNE	PWCL040		;big size index ? ( no:PWCL040 )
;
		M16
;
		LDA	#0200H
		BRA	PWCL050
;
		MEM8
;
PWCL040		EQU	$
		STZ	4204H		;div calculate
		LDA	<WORK4,X
		STA	4205H
		LDA	WORK4,Y
		STA	4206H
		NOP
		NOP
		NOP
		NOP
		NOP
		NOP
		NOP
;
		M16
;
		LDA	4214H
		ASL	A		;[ 2dot/f ]
PWCL050		EQU	$
		BIT	<WORK3-1,X	;(N) set
		ABS16
		STA	MPPLXSPD,X	;speed set
;
		M8
;
		DEX
		DEX
		BPL	PWCL030
;
		STZ	!MPPLXPS	;speed(L) reset
		STZ	!MPPLZPS
		STZ	!MPPLYPS
;
;-------------- map rotation angle set ------------------
		LDA	<WORK3
		STA	<WORK0		;(WK0) <-- X size
		LDA	<WORK5
		STA	<WORK1		;(WK1) <-- Z size
		JSR	ANGLCALC
;
		PLY			;(Y) load
;
		STA	MPPLANG		;map player move angle set
;
		TYX
		INC	MPMVOBWK0,X	;walk flag "ON"
		RTS
;
;----------------------------------------------------------------
;		player pos calculate				-
;----------------------------------------------------------------
;
		MEM8
		IDX8
;
PSCALC		EQU	$
;
		M16
;
		LDX	#04
PSCL010		EQU	$
		LDA	MPPLXPOS,X	;X pos
		CLC
		ADC	MPPLXSPD,X
		STA	MPPLXPOS,X
		DEX
		DEX
		BPL	PSCL010
;
		M8
;
;-------------- player pos convert set --------------------------
		LDA	!MPPLXPOS+1
		STA	!MPPLXPS	;map X pos set
		STA	<WORK0
		LDA	!MPPLZPOS+1
		STA	!MPPLZPS	; "  Z    "
		STA	<WORK1
		LDA	!MPPLYPOS+1
		STA	!MPPLYPS	; "  Y    "
;
		JSR	ANGLCALC	;angle calculate
		LDA	#0C0H
		SEC
		SBC	<WORK2
		LDX	#002H
		CMP	!MPANGLE
		BEQ	PSCL010_90
		BPL	PSCL010_20
		DEX
PSCL010_20	EQU	$
		LDA	MPPLANAD,X
		CLC
		ADC	!MPANGLE
		STA	!MPANGLE
;
		LDA	!MPPLWLK
		ASL	A
		ASL	A
		ASL	A
		STA	<WORK0
		LDA	!MPPLANG
		CLC
		ADC	!MPANGLE
		CLC
		ADC	#020H/2
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		ORA	<WORK0
		TAX
		LDA	MPLCHPT,X
		STA	!MPPLTYP	; pattern NO. set
;
PSCL010_90	EQU	$
		DEC	MPGOTOCT
		DEC	MPGOTOCT
		BMI	PSCL020		;walk end ? ( yes:PSCL020 )
		BNE	PSCL040		;    "    ? ( no:PSCL040 )
;
;-------------- walk end check --------------------------
PSCL020		EQU	$
;
		I16
;
		LDX	!MPCLRPT
;;;;K;;;;		LDA	>MAPPTBF+7,X
		LDA	>MAPPTBF+11,X
		BPL	PSCL030		;go to course in [start] wait ? ( no:PSCL030 )
;
;-------------- go to course in [start] wait ----
		LDA	#PWLK1
		STA	MPLMODE
;;;;K;;;;		STZ	MPLMODE
;;;;K;;;;;
;;;;K;;;;;-------------- course select BG display set ----
;;;;K;;;;		JSR	CORSELON
;
;-------------- walk end player map pos reset ---
PSCL030		EQU	$
		INX
		INX
		INX
		INX
		STX	MPCLRPT		;next point index set
;
		I8
;
;;;;K;;;;		TYX
;;;;K;;;;		STZ	MPMVOBWK0,X	;walk flag "OFF"
		STZ	!MPMVOBWK0	;walk flag "OFF"
;
		LDA	!MPGOTOXP
		STA	!MPPLXPS	;map X pos set
		LDA	!MPGOTOZP
		STA	!MPPLZPS	; "  Z    "
		LDA	!MPGOTOYP
		STA	!MPPLYPS	;map Y pos set
PSCL040		EQU	$
		RTS
;
;
;****************************************************************
;*		EFCg					*
;****************************************************************
PLWALK1		EQU	$
		RTS
;
;************************************************************************
;*		atan data						*
;************************************************************************
ATAN		EQU	$
		WORD	00000H,00000H,00000H,00000H,00000H,00002H,00002H,00002H
		WORD	00002H,00002H,00002H,00002H,00004H,00004H,00004H,00004H
		WORD	00004H,00004H,00006H,00006H,00006H,00006H,00006H,00006H
		WORD	00008H,00008H,00008H,00008H,00008H,00008H,0000AH,0000AH
		WORD	0000AH,0000AH,0000AH,0000AH,0000AH,0000CH,0000CH,0000CH
		WORD	0000CH,0000CH,0000CH,0000EH,0000EH,0000EH,0000EH,0000EH
		WORD	0000EH,0000EH,00010H,00010H,00010H,00010H,00010H,00010H
		WORD	00012H,00012H,00012H,00012H,00012H,00012H,00012H,00014H
		WORD	00014H,00014H,00014H,00014H,00014H,00014H,00016H,00016H
		WORD	00016H,00016H,00016H,00016H,00018H,00018H,00018H,00018H
		WORD	00018H,00018H,00018H,0001AH,0001AH,0001AH,0001AH,0001AH
		WORD	0001AH,0001AH,0001CH,0001CH,0001CH,0001CH,0001CH,0001CH
		WORD	0001CH,0001EH,0001EH,0001EH,0001EH,0001EH,0001EH,0001EH
		WORD	0001EH,00020H,00020H,00020H,00020H,00020H,00020H,00020H
		WORD	00022H,00022H,00022H,00022H,00022H,00022H,00022H,00022H
		WORD	00024H,00024H,00024H,00024H,00024H,00024H,00024H,00026H
		WORD	00026H,00026H,00026H,00026H,00026H,00026H,00026H,00028H
		WORD	00028H,00028H,00028H,00028H,00028H,00028H,00028H,0002AH
		WORD	0002AH,0002AH,0002AH,0002AH,0002AH,0002AH,0002AH,0002AH
		WORD	0002CH,0002CH,0002CH,0002CH,0002CH,0002CH,0002CH,0002CH
		WORD	0002EH,0002EH,0002EH,0002EH,0002EH,0002EH,0002EH,0002EH
		WORD	0002EH,00030H,00030H,00030H,00030H,00030H,00030H,00030H
		WORD	00030H,00030H,00032H,00032H,00032H,00032H,00032H,00032H
		WORD	00032H,00032H,00032H,00032H,00034H,00034H,00034H,00034H
		WORD	00034H,00034H,00034H,00034H,00034H,00034H,00036H,00036H
		WORD	00036H,00036H,00036H,00036H,00036H,00036H,00036H,00036H
		WORD	00038H,00038H,00038H,00038H,00038H,00038H,00038H,00038H
		WORD	00038H,00038H,00038H,0003AH,0003AH,0003AH,0003AH,0003AH
		WORD	0003AH,0003AH,0003AH,0003AH,0003AH,0003AH,0003CH,0003CH
		WORD	0003CH,0003CH,0003CH,0003CH,0003CH,0003CH,0003CH,0003CH
		WORD	0003CH,0003EH,0003EH,0003EH,0003EH,0003EH,0003EH,0003EH
		WORD	0003EH,0003EH,0003EH,0003EH,0003EH,00040H,00040H,00040H
;
;----------------------------------------------------------------
;-		angle calculate					-
;-			in  : (WK0)	<-- X size		-
;-			      (WK1)	<-- Y size		-
;-			out : (A),(WK2) <-- angle		-
;----------------------------------------------------------------
ANGCKD		EQU	$	;[ ???H/2+[XXH] : XXH = NEG flag ]
		WORD	000H/2+0000H,080H/2+8000H,000H/2+8000H,180H/2+0000H
		WORD	100H/2+8000H,080H/2+0000H,100H/2+0000H,180H/2+8000H
;
		MEM8
		IDX8
;
ANGLCALC	EQU	$
		LDX	#00H		;(X) <-- angle pos check data
		LDA	<WORK0
		BPL	ANCL010		;right ? ( yes:ANCL010 )
		LDX	#04H
		NEG8
ANCL010		EQU	$
		STA	<WORK2
		LDA	<WORK1
		BPL	ANCL020		;under ? ( yes:ANCL020 )
		INX
		INX
		NEG8
ANCL020		EQU	$
		LDY	<WORK2
		CMP	<WORK2
		BEQ	ANCL030		;Y =< X ? ( yes:ANCL030 )
		BCC	ANCL030		;	    "
		INX
		TAY
		LDA	<WORK2
ANCL030		EQU	$
		STZ	4204H		;div calculate
		STA	4205H
		STY	4206H
		STY	<WORK2		;(WK2,3) <-- div data
		STZ	<WORK3
;
		TXA
		ASL	A
		TAX
		NOP
		NOP
		NOP
		NOP
;
		MI16
;
		LDA	4216H
		ASL	A
		SEC
		SBC	<WORK2		;(C) <-- 0.5
		LDA	4214H		;(X) <-- div ans
		ADC	#0
		ASL	A
		TAY
		CPY	#(0100H+1)*2
		BCC	ANCL040
		LDY	#(0100H*2)
ANCL040		EQU	$
		LDA	>ANGCKD,X
		ASL	A		;(C) <-- NEG flag
		STA	<WORK2
		TYX
		LDA	>ATAN,X
		BCC	ANCL050
		NEG16
ANCL050		EQU	$
		CLC
		ADC	<WORK2
		LSR	A
;
		MI8
;
		STA	<WORK2
		RTS
;
;
;
;
;
;
;
		END
