;************************************************************************
;*									*
;*	title name	: "yossy map tool"				*
;*	proccess	: title						*
;*	file name	: ysm_title					*
;*									*
;************************************************************************
;
;
		SALL
;
		include		ysm_header.inc
;
		XALL
;
;
;------------------------------------------------------------------------
;-		global symbol						-
;------------------------------------------------------------------------
		GLB	MODINC,MODINC2
		GLB	TLINIT,TLPLAY
;
;------------------------------------------------------------------------
;-		extern symbol						-
;------------------------------------------------------------------------
;
;-------------< ys_main >------------------------------------------------
		EXT	RAMCLR,VRAMCL,BLNKOFF
;
;-------------< ys_rpro >------------------------------------------------
		EXT	CHIPON
;
;-------------< ys_init >------------------------------------------------
		EXT	GMMDST,MPCHRST
		EXT	GM00
;
;-------------< ys_title >-----------------------------------------------
		EXT	M_KUMO,M_SMOK,M_KAMO,M_PLAY,M_DORO
;
;------------------------------------------------------------------------
;-		define symbol						-
;------------------------------------------------------------------------
;;;;		EQU
;
;
;************************************************************************
;*									*
;*		program start						*
;*									*
;************************************************************************
;
;
		EXTEND
;
;
		MEM8
		IDX8
;
Group_1		GROUP	Title_pro
Title_pro	SECT	REL
;
;************************************************************************
;*		title initial						*
;************************************************************************
TLOBJD		EQU	$
		HEX	70,60,00,00
		HEX	80,60,02,00
		HEX	70,70,20,00
		HEX	80,70,22,00
TLOBJDE		EQU	$
;
TLINIT		EQU	$
		JSL	>RAMCLR		;all RAM clear
;
		JSL	>VRAMCL		;VRAM clear
;
;-------------- map data edit initial set -------------------------------
		JSR	MPDTINIT
;
;-------------- title initial set ---------------------------------------
		LDX	#GM00		;(X) <-- game mode type no.
		JSL	>GMMDST		;game mode set
		LDA	#00010000B
		STA	212CH		;OBJ only display
;
;-------------- character set -----------------------------------
;
		M16
;
		LDA	#CIPCHD+0060H+1
		STA	>OCHRADR	;chara data address set
		LDA	#(CIPCHD+0060H)/100H
		STA	>OCHRADR+1
		LDA	#0100H
		STA	>OMATA
		STA	>OMATD
		LDA	#0000H
		STA	>OMATB
		STA	>OMATC
		STA	>OBUFXPS	;data set buffer X pointer
		STA	>OBUFYPS	;	"        Y    "
		LDA	#010H
		STA	>OCENTX		;center X pos
		STA	>OCENTY		;   "   Y  "
;
		LDX	#BANK OBJMD73
		LDA	#OBJMD73
		JSL	>CHIPON		;mode 7 OBJ chara set
;
		LDA	#4000H
		STA	<WORK		;(WK0,1) <-- VRAM address
		LDA	#WOB7CHR
		STA	<WORK2		;(WK2,3) <-- chara data address
		LDY	#10000000B	;inc mode set
		STY	2115H
		LDA	#00000001B+(18H*100H)	;DMA parameter & B bus address set
		STA	4300H
		LDY	#BANK WOB7CHR		;A bus address(B) set
		STY	4304H
		LDY	#04		;(Y) <-- loop no
		LDX	#00000001B	;(X) <-- DMA "ON"
TLIN000		EQU	$
		LDA	<WORK
		STA	2116H		;VRAM address set
		CLC
		ADC	#0100H
		STA	<WORK
		LDA	<WORK2
		STA	4302H		;A bus address(L,H) set
		CLC
		ADC	#0200H
		STA	<WORK2
		LDA	#0080H
		STA	4305H		;number of byte set
		STX	420BH		;DMA "ON"
		DEY
		BNE	TLIN000
;
		M8
;
		LDX	#TLOBJDE-TLOBJD-1	;OAM set
TLIN002		EQU	$
		LDA	!TLOBJD,X
		STA	>OAM,X
		DEX
		BPL	TLIN002
		LDA	#10101010B
		STA	>OAMSUB
;
;-------------- color set ---------------------------------------
;
		I16
;
		LDX	#0200H-1-2	;color set
TLIN010		EQU	$
		LDA	>9D000H+2,X
		STA	>DATACOL+2,X
		DEX
		BPL	TLIN010
;
		I8
;
		LDA	#020H		;fade wait timer set
		STA	FADTM
;
;---------------- AADA used ram initial set ---------------------
		LDX	#007H
		LDA	#020H
AADAINT		EQU	$
		STA	!MOJBFA,X
		STA	!MOJBFB,X
		STA	!MOJBFC,X
		STA	!MOJBFD,X
		STA	!MOJBFE,X
		STA	!MOJBFF,X
		STA	!MOJBFG,X
		STA	!MOJBFH,X
		STA	!MOJBFP,X
		DEX
		BPL	AADAINT
;
		LDA	#001H
		STA	!UNITNO		; unit NO. initial set
		M16			; memory 16bit mode
		LDA	#00100H
		STA	!EDZOOM
		STZ	!EDCENTX	; map display center pos set
		STZ	!EDCENTY
		M8			; memory 8bit mode
;
;-------------- blanking "ON" & go to next mode -----------------
MODINC2		EQU	$
		JSL	>BLNKOFF	;blanking "OFF"
;
MODINC		EQU	$
		INC	MODENO
		PLB
		RTL
;
;************************************************************************
;*		title play						*
;************************************************************************
;
TLPLAY		EQU	$
;
;-------------- Mr.dorobo display wait --------------------------
;
		I16
;
		LDY	#00000H
		LDX	#0AH
TLPL010		EQU	$
		DEY
		BNE	TLPL010
		DEX
		BNE	TLPL010
;
		I8
;
;-------------- go to next mode !! ------------------------------
		JMP	>MODINC
;
;
;
;************************************************************************
;*		map data edit initial set				*
;************************************************************************
;
;-------------- map OBJ name --------------------------------------------
YAMA_H		EQU	01H
YAMA_M		EQU	02H
YAMA_L		EQU	03H
TOWER_T		EQU	04H
TOWER_G		EQU	05H
KAZAN		EQU	06H
SML_YAMA	EQU	07H
DAI		EQU	08H
SML_TOWER	EQU	09H
WID_TOWER	EQU	0AH
MIN_YAMA	EQU	0BH
SAKU		EQU	0CH
YANE		EQU	0DH
HOLL		EQU	0EH
TREE_1		EQU	0FH
TREE_2		EQU	10H
TREE_3		EQU	11H
TREE_4		EQU	12H
TREE_5		EQU	13H
IWA		EQU	14H
KUMO		EQU	15H
LAPUTA		EQU	16H
KEBLE		EQU	17H
KUSA		EQU	18H
FLOWER		EQU	19H
ISHI		EQU	1AH
LOPE		EQU	1BH
SMOKE_1		EQU	1CH
SMOKE_2		EQU	1DH
SMOKE_3		EQU	1EH
SMOKE_4		EQU	1FH
SMOKE_5		EQU	20H
SMOKE_6		EQU	21H
SMOKE_7		EQU	22H
KAMO_1		EQU	23H
KAMO_2		EQU	24H
KAMO_3		EQU	25H
KAMO_4		EQU	26H
KAMO_5		EQU	27H
KAMO_6		EQU	28H
KAMO_7		EQU	29H
KAMO_8		EQU	2AH
PLAYER_01	EQU	2BH
PLAYER_02	EQU	2CH
PLAYER_03	EQU	2DH
PLAYER_04	EQU	2EH
PLAYER_05	EQU	2FH
PLAYER_06	EQU	30H
PLAYER_07	EQU	31H
PLAYER_08	EQU	32H
PLAYER_09	EQU	33H
PLAYER_10	EQU	34H
PLAYER_11	EQU	35H
PLAYER_12	EQU	36H
PLAYER_13	EQU	37H
PLAYER_14	EQU	38H
PLAYER_15	EQU	39H
PLAYER_16	EQU	3AH
PLAYER_17	EQU	3BH
PLAYER_18	EQU	3CH
PLAYER_19	EQU	3DH
PLAYER_20	EQU	3EH
PLAYER_21	EQU	3FH
PLAYER_22	EQU	40H
PLAYER_23	EQU	41H
PLAYER_24	EQU	42H
PLAYER_25	EQU	43H
PLAYER_26	EQU	44H
PLAYER_27	EQU	45H
PLAYER_28	EQU	46H
PLAYER_29	EQU	47H
PLAYER_30	EQU	48H
PLAYER_31	EQU	49H
PLAYER_32	EQU	4AH
PLAYER_33	EQU	4BH
PLAYER_34	EQU	4CH
PLAYER_35	EQU	4DH
PLAYER_36	EQU	4EH
PLAYER_37	EQU	4FH
PLAYER_38	EQU	50H
PLAYER_39	EQU	51H
PLAYER_40	EQU	52H
PLAYER_41	EQU	53H
PLAYER_42	EQU	54H
PLAYER_43	EQU	55H
PLAYER_44	EQU	56H
PLAYER_45	EQU	57H
PLAYER_46	EQU	58H
PLAYER_47	EQU	59H
PLAYER_48	EQU	5AH
AYASHI_H	EQU	5BH
AYASHI_L	EQU	5CH
AYASHI_2	EQU	5DH
BIG_KINOKO	EQU	5EH
SML_KINOKO	EQU	5FH
ZENMAI		EQU	60H
BIG_CRYSTL	EQU	61H
SML_CRYSTL	EQU	62H
ISHI_T_1	EQU	63H
ISHI_T_2	EQU	64H
MIN_TOWER	EQU	65H
KINOKO_2	EQU	66H
KINOKO_3	EQU	67H
KINOKO_4	EQU	68H
KINOKO_6	EQU	69H
KINOKO_7	EQU	6AH
HOLL_MASK	EQU	6BH
GATE_0		EQU	6CH
GATE_1		EQU	6DH
GATE_2		EQU	6EH
GATE_3		EQU	6FH
GATE_4		EQU	70H
GATE_5		EQU	71H
GATE_6		EQU	72H
GATE_7		EQU	73H
GATE_8		EQU	74H
GATE_9		EQU	75H
GATE_A		EQU	76H
GATE_B		EQU	77H
GATE_C		EQU	78H
GATE_D		EQU	79H
;
;
;-------------- map OBJ data address table ------------------------------
MPOBJTBL	EQU	$
CHIJODT		WORD	MPOBJDT0	;[0] chijyo
;
;-------------- map move OBJ data address table -------------------------
MPMVOBJTBL	EQU	$
		WORD	MPMVOBJDT0	;[0] chijyo
;
;-------------- map OBJ data neme ---------------------------------------
CHIJO		EQU	CHIJODT-MPOBJTBL
;
;
;-------------< chijyo data >--------------------------------------------
;
;-------------- move OBJ initial data ---------------------------
MPMVOBJDT0	EQU	$
;			OBJNO  WK0  WK1	 TM0
		BYTE	M_PLAY,000H,000H,000H	;[0] player
		BYTE	0FFH	;end code
;;;;		BYTE	M_GATE,000H,000H,000H	;[1] gate.1
;;;;		BYTE	M_GATE,0E0H,000H,000H	;[2]   " .2
;;;;		BYTE	M_GATE,0C0H,000H,000H	;[3]   " .3
;;;;		BYTE	M_GATE,0A0H,000H,000H	;[4]   " .4
;;;;		BYTE	M_GATE,080H,000H,000H	;[5]   " .5
;;;;		BYTE	M_GATE,060H,000H,000H	;[6]   " .6
;;;;		BYTE	M_GATE,040H,000H,000H	;[7]   " .7
;;;;		BYTE	M_GATE,020H,000H,000H	;[8]   " .8
;;;;		BYTE	M_KUMO,000H,000H,000H	;[9] kumo.1
;;;;		BYTE	M_KUMO,055H,000H,000H	;[A]   " .2
;;;;		BYTE	M_KUMO,0AAH,000H,000H	;[B]   " .3
;;;;		BYTE	M_SMOK,000H,000H,000H	;[C] kazan smoke.1
;;;;		BYTE	M_SMOK,004H,000H,000H	;[D]	  "     .2
;;;;		BYTE	M_SMOK,008H,000H,000H	;[E]	  "     .3
;;;;		BYTE	M_KAMO,000H,000H,000H	;[F] kamome
;
;-------------- map OBJ set data --------------------------------
MPOBJDT0	EQU	$
;			[type no.] [X]	[Z]  [Y]
;-------------- move OBJ area -----------------------------------
		BYTE	PLAYER_01, 040H,0F0H,000H	;[0]  player
		BYTE	000,	   000H,0B0H,000H	;[1]  gate.1
		BYTE	000,	   039H,0C7H,000H	;[2]	" .2
		BYTE	000,	   050H,000H,000H	;[3]	" .3
		BYTE	000,	   039H,039H,000H	;[4]	" .4
		BYTE	000,	   000H,050H,000H	;[5]	" .5
		BYTE	000,	   0C7H,039H,000H	;[6]	" .6
		BYTE	000,	   0B0H,000H,000H	;[7]	" .7
		BYTE	000,	   0C7H,0C7H,000H	;[8]	" .8
		BYTE	000,	   030H,030H,042H	;[9]  kumo.1
		BYTE	000,	   030H,030H,040H	;[A]   " .2
		BYTE	000,	   030H,030H,044H	;[B]   " .3
		BYTE	000,	   030H,030H,01AH	;[C] kazan smoke.1
		BYTE	000,	   030H,030H,01AH	;[D]	    "     .2
		BYTE	000,	   030H,030H,01AH	;[E]	    "     .3
		BYTE	000,	   030H,030H,030H	;[F] kamome
;
;;;;		BYTE	GATE_0,	   000H,0B0H,000H	;[1]  gate.1
;;;;		BYTE	GATE_4,	   039H,0C7H,000H	;[2]	" .2
;;;;		BYTE	GATE_7,	   050H,000H,000H	;[3]	" .3
;;;;		BYTE	GATE_A,	   039H,039H,000H	;[4]	" .4
;;;;		BYTE	GATE_0,	   000H,050H,000H	;[5]	" .5
;;;;		BYTE	GATE_4,	   0C7H,039H,000H	;[6]	" .6
;;;;		BYTE	GATE_7,	   0B0H,000H,000H	;[7]	" .7
;;;;		BYTE	GATE_A,	   0C7H,0C7H,000H	;[8]	" .8
;;;;		BYTE	KUMO,	   030H,030H,042H	;[9]  kumo.1
;;;;		BYTE	KUMO,	   030H,030H,040H	;[A]   " .2
;;;;		BYTE	KUMO,	   030H,030H,044H	;[B]   " .3
;;;;		BYTE	000,	   030H,030H,01AH	;[C] kazan smoke.1
;;;;		BYTE	000,	   030H,030H,01AH	;[D]	    "     .2
;;;;		BYTE	000,	   030H,030H,01AH	;[E]	    "     .3
;;;;		BYTE	000,	   030H,030H,030H	;[F] kamome
;;;;;
;;;;		BYTE	YAMA_H,	   0F8H,018H,000H
;;;;		BYTE	YAMA_M,	   028H,008H,000H
;;;;		BYTE	YAMA_L,	   0D8H,0F8H,000H
;;;;		BYTE	TOWER_T,   018H,0E0H,000H
;;;;		BYTE	TOWER_G,   0F8H,038H,000H
;;;;		BYTE	SML_TOWER, 0ECH,040H,000H
;;;;		BYTE	SML_TOWER, 0ECH,030H,000H
;;;;		BYTE	SML_TOWER, 004H,040H,000H
;;;;		BYTE	SML_TOWER, 004H,030H,000H
;;;;		BYTE	SML_TOWER, 0CAH,0D2H,000H
;;;;		BYTE	KAZAN,	   030H,030H,000H
;;;;		BYTE	SML_YAMA,  0F0H,0B0H,000H
;;;;		BYTE	DAI,	   0E8H,0D8H,000H
;;;;		BYTE	DAI,	   000H,0F0H,000H
;;;;		BYTE	WID_TOWER, 050H,0DEH,000H
;;;;		BYTE	MIN_YAMA,  008H,0A8H,000H
;;;;		BYTE	MIN_YAMA,  018H,0B8H,000H
;;;;		BYTE	MIN_YAMA,  028H,0C0H,000H
;;;;		BYTE	SAKU,	   038H,0E6H,000H
;;;;		BYTE	SAKU,	   032H,0E0H,000H
;;;;		BYTE	SAKU,	   03EH,0E0H,000H
;;;;		BYTE	SAKU,	   038H,0DAH,000H
;;;;		BYTE	YANE,	   0A0H,0FCH,000H
;;;;		BYTE	HOLL,	   048H,000H,0FFH
;;;;		BYTE	IWA,	   0C8H,030H,000H
;;;;		BYTE	IWA,	   0C8H,020H,000H
;;;;		BYTE	IWA,	   0D8H,038H,000H
;;;;		BYTE	IWA,	   0D8H,020H,000H
;;;;		BYTE	IWA,	   0E0H,050H,000H
;;;;		BYTE	IWA,	   010H,038H,000H
;;;;		BYTE	IWA,	   018H,020H,000H
;;;;		BYTE	IWA,	   020H,048H,000H
;;;;		BYTE	IWA,	   030H,050H,000H
;;;;		BYTE	IWA,	   038H,040H,000H
;;;;		BYTE	TREE_1,	   0B0H,0C0H,000H
;;;;		BYTE	TREE_1,	   0B8H,0CCH,000H
;;;;		BYTE	TREE_1,	   0B0H,0D0H,000H
;;;;		BYTE	TREE_1,	   0D8H,0C0H,000H
;;;;		BYTE	TREE_1,	   0F8H,0C0H,000H
;;;;		BYTE	TREE_1,	   028H,0A0H,000H
;;;;		BYTE	TREE_1,	   060H,008H,000H
;;;;		BYTE	TREE_1,	   064H,0F0H,000H
;;;;		BYTE	TREE_2,	   0A8H,030H,000H
;;;;		BYTE	TREE_2,	   0B0H,038H,000H
;;;;		BYTE	TREE_2,	   0B8H,040H,000H
;;;;		BYTE	TREE_3,	   09CH,008H,000H
;;;;		BYTE	TREE_3,	   09CH,0F0H,000H
;;;;		BYTE	TREE_3,	   0ACH,030H,000H
;;;;		BYTE	TREE_3,	   0B4H,038H,000H
;;;;		BYTE	TREE_3,	   0BCH,0D0H,000H
;;;;		BYTE	TREE_3,	   0C4H,0C8H,000H
;;;;		BYTE	TREE_3,	   0CCH,0C8H,000H
;;;;		BYTE	TREE_3,	   0CCH,0C0H,000H
;;;;		BYTE	TREE_3,	   00CH,058H,000H
;;;;		BYTE	TREE_3,	   014H,050H,000H
;;;;		BYTE	TREE_3,	   01CH,040H,000H
;;;;		BYTE	TREE_3,	   01CH,030H,000H
;;;;		BYTE	TREE_3,	   02CH,048H,000H
;;;;		BYTE	TREE_3,	   02CH,040H,000H
;;;;		BYTE	TREE_3,	   034H,0C8H,000H
;;;;		BYTE	TREE_3,	   034H,0C0H,000H
;;;;		BYTE	TREE_3,	   03CH,0C8H,000H
;;;;		BYTE	TREE_3,	   03CH,0C0H,000H
;;;;		BYTE	TREE_3,	   044H,028H,000H
;;;;		BYTE	TREE_3,	   044H,020H,000H
;;;;		BYTE	TREE_3,	   044H,0C8H,000H
;;;;		BYTE	TREE_3,	   044H,0C0H,000H
;;;;		BYTE	TREE_3,	   04CH,028H,000H
;;;;		BYTE	TREE_3,	   054H,0E8H,000H
;;;;		BYTE	TREE_3,	   05CH,0E8H,000H
;;;;		BYTE	TREE_4,	   0ACH,0C8H,000H
;;;;		BYTE	TREE_4,	   0B4H,0C0H,000H
;;;;		BYTE	TREE_4,	   0B4H,0B8H,000H
;;;;		BYTE	TREE_4,	   0BCH,0C0H,000H
;;;;		BYTE	TREE_4,	   0DCH,0B8H,000H
;;;;		BYTE	TREE_4,	   0E4H,0C0H,000H
;;;;		BYTE	TREE_4,	   004H,0C0H,000H
;;;;		BYTE	TREE_4,	   0FCH,098H,000H
;;;;		BYTE	TREE_4,	   004H,0D0H,000H
;;;;		BYTE	TREE_4,	   004H,0B8H,000H
;;;;		BYTE	TREE_4,	   004H,0A0H,000H
;;;;		BYTE	TREE_4,	   00CH,0D8H,000H
;;;;		BYTE	TREE_4,	   00CH,0C8H,000H
;;;;		BYTE	TREE_4,	   00CH,0B8H,000H
;;;;		BYTE	TREE_4,	   014H,0D8H,000H
;;;;		BYTE	TREE_4,	   014H,0D0H,000H
;;;;		BYTE	TREE_4,	   024H,0B8H,000H
;;;;		BYTE	TREE_4,	   02CH,0B0H,000H
;;;;		BYTE	TREE_4,	   04CH,020H,000H
;;;;		BYTE	TREE_4,	   054H,010H,000H
;;;;		BYTE	TREE_5,	   0A8H,018H,000H
;;;;		BYTE	TREE_5,	   0A8H,008H,000H
;;;;		BYTE	TREE_5,	   0B0H,0F0H,000H
;;;;		BYTE	TREE_5,	   0B8H,0E0H,000H
;;;;		BYTE	TREE_5,	   0C0H,048H,000H
;;;;		BYTE	TREE_5,	   0C8H,010H,000H
;;;;		BYTE	TREE_5,	   0D8H,010H,000H
;;;;		BYTE	TREE_5,	   030H,05AH,000H
;;;;		BYTE	TREE_5,	   048H,038H,000H
;;;;		BYTE	TREE_5,	   048H,010H,000H
;;;;		BYTE	LAPUTA,	   010H,0E8H,064H
;;;;		BYTE	FLOWER,	   0F8H,060H,000H
;;;;		BYTE	KUSA,	   000H,064H,000H
;;;;		BYTE	KUSA,	   000H,05CH,000H
;;;;		BYTE	KUSA,	   008H,068H,000H
;;;;		BYTE	KUSA,	   008H,060H,000H
;;;;		BYTE	FLOWER,	   010H,064H,000H
;;;;		BYTE	KUSA,	   018H,068H,000H
;;;;		BYTE	KUSA,	   018H,060H,000H
;;;;		BYTE	KUSA,	   020H,05CH,000H
;;;;		BYTE	ISHI,	   0C8H,044H,000H
;;;;		BYTE	ISHI,	   0CCH,050H,000H
;;;;		BYTE	ISHI,	   0D0H,048H,000H
;;;;		BYTE	ISHI,	   0D4H,050H,000H
;;;;		BYTE	LOPE,	   0D8H,0F8H,036H
;;;;		BYTE	LOPE,	   0DAH,0FAH,038H
;;;;		BYTE	LOPE,	   0DCH,0FCH,03AH
;;;;		BYTE	LOPE,	   0DEH,0FEH,03CH
;;;;		BYTE	LOPE,	   0E0H,000H,03EH
;;;;		BYTE	LOPE,	   0E2H,002H,040H
;;;;		BYTE	LOPE,	   0E4H,004H,042H
;;;;		BYTE	LOPE,	   0E6H,006H,044H
;;;;		BYTE	LOPE,	   0E8H,008H,046H
;;;;		BYTE	LOPE,	   0EAH,00AH,048H
;;;;		BYTE	LOPE,	   0ECH,00CH,04AH
;;;;		BYTE	LOPE,	   0EEH,00EH,04CH
;;;;		BYTE	LOPE,	   0F0H,010H,04EH
;;;;		BYTE	LOPE,	   0F2H,012H,050H
;;;;		BYTE	LOPE,	   0F4H,014H,052H
;;;;		BYTE	LOPE,	   0F6H,016H,054H
;;;;		BYTE	KEBLE,	   0E8H,008H,046H
;;;;		BYTE	HOLL_MASK, 048H,000H,0E6H
		HEX	FF	;end code
;
MPDTINIT	EQU	$
;
;-------------- mode 7 character set ----------------------------
		JSL	>MPCHRST	;character set
;
		IDX8
;
;-------------- mode 7 screen clear -----------------------------
		LDA	#7FH		;(WK0) <-- clear chara no.
		STA	<WORK
;
		STZ	2115H		;inc mode set
;
		M16
;
		STZ	2116H		;VRAM address set
		LDA	#00001000B+(18H*100H)
		STA	4300H		;DMA parameter & B bus address set
		LDA	#WORK
		STA	4302H		;A bus address(L,H) set
;;;;		LDY	#BANK WORK
		STZ	4304H		;	"     (B) set
		LDA	#400H*4*4
		STA	4305H		;number of byte set
		LDX	#00000001B
		STX	420BH		;DMA "ON"
;
;-------------- mode 7 screen set -------------------------------
		LDA	#08D800H	;[chijyo] screen data
		STA	<WORK+4
;
		LDA	#00000000B+(18H*100H)
		STA	4300H		;DMA parameter & B bus address set
		LDY	#BANK 80000H
		STY	4304H		;A bus address(B) set
		LDA	#(100H/8)*(20H*4)
		STA	<WORK		;(WK0,1) <-- start VRAM address
;;;;		LDX	#00000001B	;(X) <-- DMA "ON" data
		LDA	#32
		TAY			;(Y) <-- number of byte
		STA	<WORK+2		;(WK2,3) <-- V loop no
MPDI000		EQU	$
		LDA	<WORK
		STA	2116H		;VRAM address set
		CLC
		ADC	#20H*4
		STA	<WORK
		LDA	<WORK+4
		STA	4302H		;A bus address(L,H) set
		CLC
		ADC	#32
		STA	<WORK+4
		STY	4305H		;number of byte set
		STX	420BH
		DEC	<WORK+2
		BNE	MPDI000
;
		M8
;
;-------------- map OBJ data RAM set --------------------
;
		I16
		PHB
		LDA	#BANK MPDTBFA
		PHA
		PLB
		M16			; memory 16bit mode
		LDX	#0025AH
MPDI015		EQU	$
		STZ	!MPDTBFA,X
		STZ	!MPDTBFB,X
		STZ	!MPDTBFC,X
		STZ	!MPDTBFD,X
		STZ	!MPDTBFE,X
		STZ	!MPDTBFF,X
		STZ	!MPDTBFG,X
		STZ	!MPDTBFH,X
		STZ	!MPTDAT,X
		DEX
		DEX
		BPL	MPDI015
		M8			; memory 8bit mode
		PLB
;
		LDX	#00		;(Y)	 <-- map OBJ RAM pointer
MPDI010		EQU	$
		LDA	!MPOBJDT0,X
		BMI	MPDI030		;end ? ( yes:MPDI030 )
;
		INC	MPOBJSTN	;map OBJ set no count up !!
;
		LDY	#4
MPDI020		EQU	$
		LDA	!MPOBJDT0,X
		STA	MPOBJTYP,X
		STA	>MPDTBFA+2,X
		STA	>MPDTBFB+2,X
		STA	>MPDTBFC+2,X
		STA	>MPDTBFD+2,X
		STA	>MPDTBFE+2,X
		STA	>MPDTBFF+2,X
		STA	>MPDTBFG+2,X
		STA	>MPDTBFH+2,X
		INX
		DEY
		BNE	MPDI020
		BRA	MPDI010
;
;-------------- map OBJ zoom size initial set -----------
MPDI030		EQU	$
		LDA	!MPOBJSTN
		STA	>MPDTBFA
		STA	>MPDTBFB
		STA	>MPDTBFC
		STA	>MPDTBFD
		STA	>MPDTBFE
		STA	>MPDTBFF
		STA	>MPDTBFG
		STA	>MPDTBFH
		STA	!MPTCNT0
		STZ	!MPTCNT1
;
		M16
;
		LDX	#000H
MPDI045		EQU	$
		STZ	!QSTCNT,X
		INY
		INY
		CPY	#0100
		BCC	MPDI045
;
		LDX	#(MPOBJN-1)*4
		LDA	#0100H		;(A) <-- 1.0
MPDI040		EQU	$
		STA	MPWOBJSIZ,X
		DEX
		DEX
		DEX
		DEX
		BPL	MPDI040
;
		LDA	MPPLXPS-1	;map player pos initial set
		AND	#0FF00H
		STA	MPPLXPOS
		LDA	MPPLZPS-1
		AND	#0FF00H
		STA	MPPLZPOS
;
		M8
;
;-------------- map move OBJ data RAM set ---------------
		LDY	#00		;(Y)	 <-- map move OBJ RAM pointer
MPTI2070	EQU	$
		LDA	!MPMVOBJDT0,Y
		BMI	MPTI2090	;end ? ( yes:MPTI2090 )
;
		LDX	#4
MPTI2080	EQU	$
		LDA	!MPMVOBJDT0,Y
		STA	MPMVOBJNO,Y
		INY
		DEX
		BNE	MPTI2080
		BRA	MPTI2070
;
MPTI2090	EQU	$
;
		I8
;
		RTS
;
;
;
;
;
		END
