;************************************************************************
;*									*
;*	title name	: "yossy"					*
;*	proccess	: initial					*
;*	file name	: ys_init					*
;*									*
;************************************************************************
;
;
		include		../../../JPN/sfc/sfx_macro.h
		include		../../../JPN/sfc/ys_unit.h
		include		../../../JPN/sfc/ys_color.h
		include		yst_ram.asm
;
;
;------------------------------------------------------------------------
;-		global symbol						-
;------------------------------------------------------------------------
		GLB	GMCHRST,GMCOLST,GMMDST,RUTSET
		GLB	GM00,GM01,GM02,GM03,GM04,GM05,GM06
;
;------------------------------------------------------------------------
;-		extern symbol						-
;------------------------------------------------------------------------
;
;-------------< ys_main >------------------------------------------------
;
;-------------< ys_rpro >------------------------------------------------
		EXT	CHIPON
;
;-------------< ys_unit >------------------------------------------------
		EXT	UNDTADD,UNDATA,RUTDATA
;
;-------------< ys_chr >-------------------------------------------------
		EXT	ADDSTART
;
;
;------------------------------------------------------------------------
;-		define symbol						-
;------------------------------------------------------------------------
;;;;		EQU
;
;
;************************************************************************
;*									*
;*		program start						*
;*									*
;************************************************************************
;
;
		ORG	068000H
;
;
		EXTEND
;
;
		MEM8
		IDX8
;
;************************************************************************
;*		character name set					*
;************************************************************************
CHR00		EQU	6
CHR01		EQU	CHR00+1
CHR02		EQU	CHR01+1
CHR03		EQU	CHR02+1
CHR04		EQU	CHR03+1
CHR05		EQU	CHR04+1
CHR06		EQU	CHR05+1
CHR07		EQU	CHR06+1
CHR08		EQU	CHR07+1
CHR09		EQU	CHR08+1
CHR0A		EQU	CHR09+1
CHR0B		EQU	CHR0A+1
CHR0C		EQU	CHR0B+1
CHR0D		EQU	CHR0C+1
CHR0E		EQU	CHR0D+1
CHR0F		EQU	CHR0E+1
CHR10		EQU	CHR0F+1
CHR11		EQU	CHR10+1
CHR12		EQU	CHR11+1
CHR13		EQU	CHR12+1
CHR14		EQU	CHR13+1
CHR15		EQU	CHR14+1
CHR16		EQU	CHR15+1
CHR17		EQU	CHR16+1
CHR18		EQU	CHR17+1
CHR19		EQU	CHR18+1
CHR1A		EQU	CHR19+1
CHR1B		EQU	CHR1A+1
CHR1C		EQU	CHR1B+1
CHR1D		EQU	CHR1C+1
CHR1E		EQU	CHR1D+1
CHR1F		EQU	CHR1E+1
CHR20A		EQU	CHR1F+1
CHR20B		EQU	CHR20A+1
CHR21A		EQU	CHR20B+1
CHR21B		EQU	CHR21A+1
CHR22A		EQU	CHR21B+1
CHR22B		EQU	CHR22A+1
CHR23A		EQU	CHR22B+1
CHR23B		EQU	CHR23A+1
CHR24A		EQU	CHR23B+1
CHR24B		EQU	CHR24A+1
CHR25A		EQU	CHR24B+1
CHR25B		EQU	CHR25A+1
CHR26A		EQU	CHR25B+1
CHR26B		EQU	CHR26A+1
CHR27A		EQU	CHR26B+1
CHR27B		EQU	CHR27A+1
CHR30		EQU	CHR27B+1
CHR31		EQU	CHR30+1
CHR32		EQU	CHR31+1
CHR33		EQU	CHR32+1
CHR38		EQU	CHR33+1
CHR39		EQU	CHR38+1
CHR3A		EQU	CHR39+1
CHR3B		EQU	CHR3A+1
CHR3C		EQU	CHR3B+1
CHR3D		EQU	CHR3C+1
CHR3E		EQU	CHR3D+1
CHR40		EQU	CHR3E+1
CHR41		EQU	CHR40+1
CHR42		EQU	CHR41+1
CHR43		EQU	CHR42+1
CHR44		EQU	CHR43+1
CHR45		EQU	CHR44+1
CHR46		EQU	CHR45+1
CHR47		EQU	CHR46+1
CHR48		EQU	CHR47+1
CHR49		EQU	CHR48+1
CHR4A		EQU	CHR49+1
CHR4B		EQU	CHR4A+1
CHR4C		EQU	CHR4B+1
CHR4D		EQU	CHR4C+1
CHR4E		EQU	CHR4D+1
CHR4F		EQU	CHR4E+1
CHR58		EQU	CHR4F+1
CHR59		EQU	CHR58+1
CHR5A		EQU	CHR59+1
;
;************************************************************************
;*		game play character set					*
;************************************************************************
;
		MEM8
		IDX8
;
;----------------------------------------------------------------
;-		change character bank data			-
;----------------------------------------------------------------
BG1CHRBK	EQU	$
;			 [0]   [1]   [2]
		BYTE	CHR00,CHR01,CHR30  ;[0:n]
		BYTE	CHR02,CHR03,CHR31  ;[1:]
		BYTE	CHR08,CHR09,CHR09  ;[2:]
		BYTE	CHR0A,CHR0B,CHR0B  ;[3:n]
		BYTE	CHR04,CHR05,CHR32  ;[4:]
		BYTE	CHR06,CHR07,CHR07  ;[5:ou]
		BYTE	CHR0C,CHR0D,CHR31  ;[6:Jx]
BG2CHRBK	EQU	$
;			 [0]   [1]
		BYTE	CHR1E,CHR1F	   ;[0:n]
		BYTE	CHR18,CHR19	   ;[1:]
		BYTE	CHR12,CHR13	   ;[2:]
		BYTE	CHR10,CHR11	   ;[3:n]
		BYTE	CHR10,CHR11	   ;[4:]
		BYTE	CHR14,CHR15	   ;[5:ou]
		BYTE	CHR1C,CHR1D	   ;[6:Jx]
		BYTE	CHR1A,CHR1B	   ;[7:pXeQ]
BG3CHRBK	EQU	$
;			 [0]	[1]
		BYTE	CHR20A,CHR20B	   ;[0:R]
		BYTE	CHR22A,CHR21A	   ;[1:iXN[j]
		BYTE	CHR22A,CHR22B	   ;[2:afRGiJxAIoPj]
		BYTE	CHR23A,CHR22B	   ;[3:pXe]
		BYTE	CHR23A,CHR22B	   ;[4:	  h   Q]
		BYTE	CHR24A,CHR24A	   ;[5:afRGi]|Sj]
		BYTE	CHR22A,CHR22B	   ;[6:	  h   i{gj]
		BYTE	CHR22A,CHR22B	   ;[7:]
		BYTE	CHR22A,CHR22B	   ;[8:]
OBJCHRBK	EQU	$
;			 [0]   [1]
		BYTE	CHR42,CHR43	   ;[0:n]
		BYTE	CHR40,CHR4B	   ;[1:]
		BYTE	CHR40,CHR49	   ;[2:]
		BYTE	CHR4A,CHR4B	   ;[3:n]
		BYTE	CHR40,CHR45	   ;[4:]
		BYTE	CHR46,CHR47	   ;[5:ou]
		BYTE	CHR4A,CHR4B	   ;[6:Jx]
		BYTE	CHR40,CHR4B	   ;[7:pXeQ]
;
;----------------------------------------------------------------
;-		character set status table data			-
;----------------------------------------------------------------
CHRTBL		EQU	$
;
;-------------- game play character ---------------------
GMCHAR		EQU	$
		BYTE	CHR3D		     ;[ BG1,2 main character	( 1C00-1FFF ) ]
		WORD	1C00H
		BYTE	CHR3E		     ;[		    "           ( 3800-3FFF ) ]
		WORD	3800H
		BYTE	CHR58		     ;[ OBJ main character	( 4000-47FF ) ]
		WORD	4000H
		BYTE	CHR59		     ;[		    "           ( 4800-4FFF ) ]
		WORD	4800H
		BYTE	CHR3C		     ;[ meter character set	( 6000-67FF ) ]
		WORD	6000H
;
		BYTE	(WORK13-WORK10)+80H  ;[ BG2 change chacter set	( 0800-0FFF ) ]
		WORD	0800H
		BYTE	(WORK14-WORK10)+80H  ;[		    "           ( 1000-17FF ) ]
		WORD	1000H
;
		BYTE	(WORK10-WORK10)+80H  ;[ BG1 change chacter set	( 2000-27FF ) ]
		WORD	2000H
		BYTE	(WORK11-WORK10)+80H  ;[		    "           ( 2800-2FFF ) ]
		WORD	2800H
		BYTE	(WORK12-WORK10)+80H  ;[		    "           ( 3000-37FF ) ]
		WORD	3000H
;
		BYTE	(WORK17-WORK10)+80H  ;[ OBJ change chacter set	( 5000-57FF ) ]
		WORD	5000H
		BYTE	(WORK18-WORK10)+80H  ;[		    "           ( 5800-5FFF ) ]
		WORD	5800H
;
		BYTE	(WORK15-WORK10)+80H  ;[ BG3 change chacter set	( 6800-6BFF ) ]
		WORD	6800H
		BYTE	(WORK16-WORK10)+80H  ;[		    "           ( 6C00-6FFF ) ]
		WORD	6C00H
;
		HEX	FF	;end code
;
;-------------- map title character ---------------------
MTCHAR		EQU	$
		BYTE	CHR5A		     ;[ mode 7 character set	( 0000-3FFF ) ]
		WORD	0000H
		BYTE	CHR27B		     ;[ mode 0 BG character set ( 5C00-5FFF ) ]
		WORD	5C00H
		BYTE	CHR26B		     ;[ title BG character set	( 3C00-3FFF ) ]
		WORD	3C00H
		BYTE	CHR27A		     ;[ moji BG character set	( 4000-43FF ) ]
		WORD	4000H
		HEX	FF	;end code
;
;-------------- map character ---------------------------
MPCHAR		EQU	$
		BYTE	CHR5A		     ;[ mode 7 character set	( 0000-3FFF ) ]
		WORD	0000H
		BYTE	CHR27B		     ;[ mode 0 BG character set ( 5C00-5FFF ) ]
		WORD	5C00H
		BYTE	CHR27A		     ;[ moji BG character set	( 3C00-3FFF ) ]
		WORD	3C00H
		HEX	FF	;end code
;
GMCHR		EQU	GMCHAR-CHRTBL
MTCHR		EQU	MTCHAR-CHRTBL
MPCHR		EQU	MPCHAR-CHRTBL
;
;----------------------------------------------------------------
;-		character set					-
;----------------------------------------------------------------
GMCHRST		EQU	$
		PHB			;(DBR) save
		PHK			;(DBR) <-- (PBR)
		PLB
;
		MI16
;
;-------------- afPLN^[Zbg ------------------------
		LDA	BG1TYP		;x3
		ASL	A
;;;;		CLC
		ADC	BG1TYP
		TAY
		LDA	!BG1CHRBK,Y
		STA	<WORK10
		LDA	!BG1CHRBK+1,Y
		STA	<WORK11
;
;-------------- afQLN^[Zbg ------------------------
		LDA	BG2TYP		;x2
		ASL	A
		TAY
		LDA	!BG2CHRBK,Y
		STA	<WORK13
;
;-------------- afRLN^[Zbg ------------------------
		LDA	BG3TYP		;x2
		ASL	A
		TAY
		LDA	!BG3CHRBK,Y
		STA	<WORK15
;
;-------------- naiLN^[Zbg ------------------------
		LDA	OBJTYP		;x2
		ASL	A
		TAY
		LDA	!OBJCHRBK,Y
		STA	<WORK17
;
		M8
;
		LDY	#GMCHR		;(Y) <-- character index
;
;-------------- LN^[Zbg ------------------------------
GMCS050		EQU	$
		LDA	!CHRTBL,Y	;(A) <-- chara bank
		BPL	GMCS060		;direct set ? ( yes:GMCS060 )
;
		CMP	#0FFH
		BEQ	GMCS070		;end ? ( yes:GMCS070 )
;
		M16
;
		AND	#007FH
		TAX
;
		M8
;
		LDA	<WORK10,X	;(A) <-- chara bank
GMCS060		EQU	$
		LDX	!CHRTBL+1,Y	;(X) <-- VRAM address
		JSR	CHRSUB
		INY
		INY
		INY
		BRA	GMCS050
;
GMCS070		EQU	$
;
		I8
;
		PLB
		RTL
;
;--------------------------------------------------------
;-		character set				-
;-			in  : (Y) <-- character index	-
;--------------------------------------------------------
CHRSET		EQU	$
		PHB			;(DBR) save
		PHK			;(DBR) <-- (PBR)
		PLB
		BRA	GMCS050
;
;****************************************************************
;*		character buffer set & DMA			*
;*			in  : (A) <-- chara bank		*
;*			      (X) <-- VRAM address		*
;*			[ from memory-8,index-16 bit mode !! ]	*
;****************************************************************
;
		MEM8
		IDX16
;
CHRSUB		EQU	$
		PHY			;(Y) save
;
		STX	<WORKE		;(WKE,F) <-- VRAM address set
;
		M16
;
		AND	#00FFH		;x3
		STA	<WORKC		;(WKC,D) <-- chara bank
		ASL	A
;;;;		CLC
		ADC	<WORKC
		TAX
;
		M8
;
;-------------- press data convert ----------------------
		LDA	>ADDSTART,X	;(WK8,9,A) <-- pless data address
		STA	<WORK8
		LDA	>ADDSTART+1,X
		STA	<WORK9
		LDA	>ADDSTART+2,X
		STA	<WORKA
		LDY	#WORKBF		;(WK0,1,2) <-- data store address
		STY	<WORK0
		LDA	#BANK WORKBF
		STA	<WORK2
		JSR	CHREAD		;Character buffer set
;
;-------------- character DMA set -----------------------
		LDA	<WORKC
		CMP	#CHR5A
		BEQ	CHRSB010	;mode 7 chara ? ( yes:CHRSB010 )
;
		LDA	#10000000B	;inc mode set
		STA	2115H
		LDX	<WORKE		;VRAM address set
		STX	2116H
;
		LDX	#00000001B+(18H*100H)	;DMA paramer & B bus address set
		STX	4300H
		LDX	#WORKBF			;A bus address(L,H) set
		STX	4302H
		LDA	#BANK WORKBF		;	"     (B) set
		STA	4304H
		STY	4305H			;number of byte set
		LDA	#00000001B
		STA	420BH			;DMA "ON" !!
;
		PLY			;(X) load
		RTS
;
;-------------- mode 7 character DMA set ----------------
CHRSB010	EQU	$
		PHB			;(DBR) save
		LDA	#BANK WORKBF
		PHA
		PLB
;
		M16
;
		TYA
		STA	<WORK		;loop no
		ASL	A
		PHA			;number of byte save
;
		LDX	#00		;(X) <-- from data pointer
		LDY	#00		;(Y) <-- to	    "
CHRSB020	EQU	$
		LDA	WORKBF,X
		PHA
		AND	#0FH
		STA	WORKBF+1800H,Y
		INY
		PLA
		AND	#0F0H
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		STA	WORKBF+1800H,Y
		INX
		INY
		DEC	<WORK
		BNE	CHRSB020
;
		M8
;
		PLY
		PLB
;
		LDA	#10000000B	;inc mode set
		STA	2115H
		LDX	<WORKE		;VRAM address set
		STX	2116H
;
		LDX	#00000000B+(19H*100H)	;DMA paramer & B bus address set
		STX	4300H
		LDX	#WORKBF+1800H		;A bus address(L,H) set
		STX	4302H
		LDA	#BANK WORKBF+1800H	;	"     (B) set
		STA	4304H
		STY	4305H			;number of byte set
		LDA	#00000001B
		STA	420BH			;DMA "ON" !!
;
		PLY			;(X) load
		RTS
;

;
;************************************************************************
;*		game play color set					*
;************************************************************************
;
		MEM8
		IDX8
;
;----------------------------------------------------------------
;-		change color bank data				-
;----------------------------------------------------------------
BG1COLBK	EQU	$
		WORD	BG1_SUB_7_COL	;[0:n]
		WORD	BG1_SUB_1_COL	;[1:]
		WORD	BG1_SUB_2_COL	;[2:]
		WORD	BG1_SUB_3_COL	;[3:n]
		WORD	BG1_SUB_6_COL	;[4:]
		WORD	BG1_SUB_5_COL	;[5:ou]
		WORD	BG1_SUB_0_COL	;[6:Jx]
BG2COLBK	EQU	$
		WORD	BG2_SUB_7_COL	;[0:n]
		WORD	BG2_SUB_4_COL	;[1:]
		WORD	BG2_SUB_1_COL	;[2:]
		WORD	BG2_SUB_0_COL	;[3:n]
		WORD	BG2_SUB_3_COL	;[4:]
		WORD	BG2_SUB_3_COL	;[5:ou]
		WORD	BG2_SUB_6_COL	;[6:Jx]
		WORD	BG2_SUB_5_COL	;[7:pXeQ]
BG3COLBK	EQU	$
		WORD	BG3_SUB_0_COL	;[0:R]
		WORD	BG3_SUB_1_COL	;[1:gl}XN]
		WORD	BG3_SUB_2_COL	;[2:]
		WORD	BG3_SUB_3_COL	;[3:XC]
		WORD	BG3_SUB_4_COL	;[4:Jx]
		WORD	BG3_SUB_5_COL	;[5:ouA]
		WORD	BG3_SUB_6_COL	;[6]
		WORD	BG3_SUB_7_COL	;[7]
		WORD	BG3_SUB_8_COL	;[8]
		WORD	BG3_SUB_9_COL	;[9]
		WORD	BG3_SUB_A_COL	;[A]
		WORD	BG3_SUB_B_COL	;[B]
		WORD	BG3_SUB_C_COL	;[C]
		WORD	BG3_SUB_D_COL	;[D]
		WORD	BG3_SUB_E_COL	;[E]
		WORD	BG3_SUB_F_COL	;[F]
OBJCOLBK	EQU	$
		WORD	OBJ_SUB_1_COL  ;[0:n]
		WORD	OBJ_SUB_1_COL  ;[1:]
		WORD	OBJ_SUB_2_COL  ;[2:]
		WORD	OBJ_SUB_3_COL  ;[3:n]
		WORD	OBJ_SUB_6_COL  ;[4:]
		WORD	OBJ_SUB_6_COL  ;[5:ou]
		WORD	OBJ_SUB_0_COL  ;[6:Jx]
		WORD	OBJ_SUB_1_COL  ;[7:pXeQ]
;
;----------------------------------------------------------------
;-		color set status table data			-
;----------------------------------------------------------------
COLTBL		EQU	$
;		WORD	(color data pointer)
;		BYTE	(start pos),(X wide)+(Y wide*10H)
;
;-------------- game play color -------------------------
GMCOLR		EQU	$
		WORD	METER_COL		;meter color
		BYTE	011H,0FH+(01H*10H)
		WORD	BG1_MAIN_COL		;BG1 main color
		BYTE	021H,07H+(04H*10H)
		WORD	OBJ_MAIN_COL		;OBJ main color
		BYTE	081H,0FH+(06H*10H)
;
		WORD	(WORK10-WORK10)+8000H	;nuki color
		BYTE	000H,01H+(02H*10H)
		WORD	(WORK16-WORK10)+8000H	;BG3 sub color
		BYTE	001H,0FH+(01H*10H)
		WORD	(WORK12-WORK10)+8000H	;BG1 sub color
		BYTE	028H,08H+(04H*10H)
		WORD	(WORK14-WORK10)+8000H	;BG2 sub color
		BYTE	061H,0FH+(02H*10H)
		WORD	(WORK18-WORK10)+8000H	;OBJ sub color
		BYTE	0E1H,0FH+(02H*10H)
;
		WORD	0FFFFH	;end code
;
;-------------- map color -------------------------------
MPCOLR		EQU	$
		WORD	0FFFFH	;end code
;
GMCOL		EQU	GMCOLR-COLTBL
MPCOL		EQU	MPCOLR-COLTBL
;
;----------------------------------------------------------------
;-		color set					-
;----------------------------------------------------------------
GMCOLST		EQU	$
		PHB			;(DBR) save
		PHK			;(DBR) <-- (PBR)
		PLB
;
		MI16
;
;-------------- kLJ[Zbg --------------------------------
		LDA	NUKINO		;nuki color x2
		ASL	A
;;;;		CLC
		ADC	#NUKI_COL
		STA	<WORK10
;
;-------------- afPJ[Zbg ------------------------------
		LDA	BG1COL		;x2
		ASL	A
		TAY
		LDA	!BG1COLBK,Y
		STA	<WORK12
;
;-------------- afQJ[Zbg ------------------------------
		LDA	BG2COL		;x2
		ASL	A
		TAY
		LDA	!BG2COLBK,Y
		STA	<WORK14
;
;-------------- afRJ[Zbg ------------------------------
		LDA	BG3COL		;x2
		ASL	A
		TAY
		LDA	!BG3COLBK,Y
		STA	<WORK16
;
;-------------- naiJ[Zbg ------------------------------
		LDA	OBJTYP		;x2
		ASL	A
		TAY
		LDA	!OBJCOLBK,Y
		STA	<WORK18
;
		LDX	#GMCOL		;(X) <-- color index
;
;-------------- J[Zbg ------------------------------------
GMCOL020	EQU	$
		LDA	#COL_ADDRESS
		STA	<WORK0
		LDA	#COL_ADDRESS/100H
		STA	<WORK1		;(WK0,1,3) <-- color data address
;
GMCOL030	EQU	$
		LDA	!COLTBL,X
		BPL	GMCOL040	;direct set ? ( yes:GMCS040 )
;
		CMP	#0FFFFH
		BEQ	GMCOL070	;end ? ( yes:GMCOL070 )
;
		AND	#7FFFH
		TAY
		LDA	WORK10,Y
GMCOL040	EQU	$
		TAY			;(Y) <-- color data pointer
		LDA	!COLTBL+3,X
		AND	#0FH
		STA	<WORK3		;(WK3,4) <-- X wide
		LDA	!COLTBL+3,X
		AND	#0F0H
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		STA	<WORK5		;(WK5,6) <-- Y wide
		LDA	!COLTBL+2,X
		AND	#00FFH
		ASL	A
		STA	<WORK7		;(WK7,8) <-- color buffer start pos
;
		PHX			;(X) save
;
GMCOL050	EQU	$
		TAX			;(X) <-- color buffer start pos
		LDA	<WORK3
		STA	<WORK9		;(WK9,A) <-- X wide
GMCOL060	EQU	$
		LDA	[<WORK0],Y
		STA	>DATACOL,X
;;;;		STA	>MOTOCOL,X
;;;;		STA	>WORKCOL,X
;;;;		STA	>BASECOL,X
		INY
		INY
		INX
		INX
		DEC	<WORK9
		BNE	GMCOL060
;
		LDA	<WORK7
		CLC
		ADC	#020H
		STA	<WORK7
		DEC	<WORK5
		BNE	GMCOL050
;
		PLX			;(X) load
;
		INX
		INX
		INX
		INX
		BRA	GMCOL030
;
GMCOL070	EQU	$
;
		MI8
;
		PLB
		RTL
;
;************************************************************************
;*		game mode set						*
;*			in  : (X) <-- game mode type no.		*
;************************************************************************
GMMDIN		EQU	$
MPD00		WORD	MPMD00-GMMDDT	;[map]
GMD00		WORD	GMMD00-GMMDDT	;[00]
GMD01		WORD	GMMD01-GMMDDT	;[01]
GMD02		WORD	GMMD02-GMMDDT	;[02]
GMD03		WORD	GMMD03-GMMDDT	;[03]
GMD04		WORD	GMMD04-GMMDDT	;[04]
GMD05		WORD	GMMD05-GMMDDT	;[05]
GMD06		WORD	GMMD06-GMMDDT	;[06]
;
BTMPM		WORD	BTMPMD-GMMDDT	;[bitmap( 256 color )]
;
MP00		EQU	MPD00-GMMDIN
GM00		EQU	GMD00-GMMDIN
GM01		EQU	GMD01-GMMDIN
GM02		EQU	GMD02-GMMDIN
GM03		EQU	GMD03-GMMDIN
GM04		EQU	GMD04-GMMDIN
GM05		EQU	GMD05-GMMDIN
GM06		EQU	GMD06-GMMDIN
;
BTMP		EQU	BTMPM-GMMDIN
;
PPUREG		EQU	$	;[21??H]
;			[BGMODE]  [BG1SCF]  [BG2SCF]  [BG3SCF]	[BG12CH]  [BG34CH]  [WIND23]  [WIND24]
;			[WIND25]  [MANSEL]  [SUBSEL]  [WMANSL]	[WSUBSL]  [WIND30]  [SUBADF]
		BYTE	05H,	  07H,	    08H,      09H,	0BH,	  0CH,	    23H,      24H
		BYTE	25H,	  2CH,	    2DH,      2EH,	2FH,	  30H,	    31H
;
GMMDDT		EQU	$
;			[NMITYP]  [IRQTYP]  [CIPSCB]  [CIPSCR]	[nuki change]
;			[BGMODE]  [BG1SCF]  [BG2SCF]  [BG3SCF]	[BG12CH]  [BG34CH]  [WIND23]  [WIND24]
;			[WIND25]  [MANSEL]  [SUBSEL]  [WMANSL]	[WSUBSL]  [WIND30]  [SUBADF]
;-------------- map mode ----------------------------------------
MPMD00		BYTE	006H,	  000H,	    00BH,     00011101B,0
		BYTE	00000000B,07CH,	    07CH,     07CH,	00110000B,01000100B,00000000B,00000000B
		BYTE	00000000B,00000000B,00000000B,00000000B,00000000B,00000000B,00111111B
;
;-------------- normal mode -------------------------------------
GMMD00		BYTE	000H,	  000H,	    018H,     00111101B,0
		BYTE	00000001B,001H,	    074H,     078H,	00000000B,00000110B,00000000B,00000000B
		BYTE	00000000B,00010011B,00000000B,00000000B,00000000B,00000000B,00000000B
;
;-------------- game mode ( room ) ------------------------------
GMMD01		BYTE	002H,	  000H,	    018H,     00111101B,0
		BYTE	01101001B,001H,	    07AH,     074H,	00000000B,00000110B,00000000B,00000000B
		BYTE	00000000B,00010001B,00000110B,00000000B,00000000B,00000010B,00100000B
;
;-------------- game mode ( glass ) -----------------------------
GMMD02		BYTE	002H,	  000H,	    018H,     00111101B,0
		BYTE	01101001B,001H,	    07AH,     074H,	00000000B,00000110B,00000000B,00000000B
		BYTE	00000000B,00010111B,00000100B,00000000B,00000000B,00000010B,00000000B
;
;-------------- game mode ( water ) -----------------------------
GMMD03		BYTE	002H,	  000H,	    018H,     00111101B,1
		BYTE	01101001B,001H,	    07AH,     074H,	00000000B,00000110B,00000000B,00000000B
		BYTE	00000000B,00010011B,00000100B,00000000B,00000000B,00000010B,11010000B
;
;-------------- game mode ( yogan ) -----------------------------
GMMD04		BYTE	004H,	  000H,	    018H,     00111101B,1
		BYTE	00100010B,001H,	    078H,     074H,	00000000B,00000110B,00000000B,00000000B
		BYTE	00000000B,00010011B,00010000B,00000000B,00000000B,00000010B,00100000B
;
;-------------- game mode ( soap ) ------------------------------
GMMD05		BYTE	002H,	  000H,	    018H,     00111101B,0
		BYTE	01101001B,001H,	    078H,     074H,	00000000B,00000110B,00000000B,00000000B
		BYTE	00000000B,00010011B,00010100B,00000000B,00000000B,00000010B,01110010B
;
;-------------- game mode ( kabe ) ------------------------------
GMMD06		BYTE	002H,	  000H,	    018H,     00111101B,0
		BYTE	01101001B,001H,	    07AH,     074H,	00000000B,00000110B,00000000B,00000000B
		BYTE	00000000B,00010011B,00000000B,00000000B,00000000B,00000010B,00100000B
;
;
;
;
;-------------- bitmap( 256 color ) -----------------------------
BTMPMD		BYTE	008H,	  002H,	    002H,     00011111B,0
		BYTE	00000011B,03CH,	    000H,     000H,	00000000B,00000000B,00000000B,00000000B
		BYTE	00000000B,00000001B,00000000B,00000000B,00000000B,00000000B,00000000B
;
;
		MEM8
		IDX8
;
GMMDST		EQU	$
		PHB			;(DBR) save
		PHK			;(DBR) <-- (PBR)
		PLB
;
		I16
;
		LDY	!GMMDIN,X	:(Y) <-- game mode data pointer
;
;-------------- game mode RAM set -------------------------------
		LDA	!GMMDDT,Y	;NMI type no. set
		STA	NMITYP
		LDA	!GMMDDT+1,Y	;IRQ type no. set
		STA	IRQTYP
;;;;		LDA	!GMMDDT+2,Y	;chip screen base set
;;;;		STA	CIPSCB
;;;;		LDA	!GMMDDT+3,Y	;     "      size mode set
;;;;		STA	CIPSCR
		LDA	!GMMDDT+4,Y
		BEQ	GMDS000		;nuki color change ? ( no:GMDS000 )
;
;-------------- nuki color change -----------------------
;
		M16
;
		LDA	>DATACOL
		STA	NUKCOL
		LDA	#00
		STA	>DATACOL
;;;;		STA	>MOTOCOL
;;;;		STA	>WORKCOL
;;;;		STA	>BASECOL
;
		M8
;
GMDS000		EQU	$
		LDX	#00
GMDS010		EQU	$
		LDA	!GMMDDT+5,Y
		STA	GMMDRM,X
		INY
		INX
		CPX	#GMMDNO
		BCC	GMDS010
;
		STZ	HD420C		;H-DMA "OFF"
;
;-------------- PPU Reg. set ------------------------------------
		LDY	#2100H		;(WK0,1) <-- PPU Reg. address
		STY	<WORK
;
		I8
;
		LDX	#GMMDNO-1
GMDS020		EQU	$
		LDY	!PPUREG,X
		LDA	GMMDRM,X
		STA	(<WORK),Y
		DEX
		BPL	GMDS020
;
		LDA	#00000010B	;OBJ intial set
		STA	2101H
		STZ	2133H		;display intial set
		LDA	#10000000B	;mode 7 over flow set
		STA	211AH
		STZ	212AH		;window logic
		STZ	212BH		;     "
;
		PLB
		RTL
;
;************************************************************************
;*		base unit data set					*
;************************************************************************
;
		MEM8
		IDX8
;
RUTSET		EQU	$
		LDA	#BANK RUT0200	;(WK2) <-- ram unit address(B)
		STA	<WORK2
;
		MI16
;
		LDX	#0		;(X) <-- base unit data set data pointer
RUTS010		EQU	$
		STX	<WORK3		;(WK3,4) <-- base unit data set data pointer
;
		LDA	>RUTDATA,X
		AND	#00FFH
		BEQ	RUTS050		;end ? ( yes:RUTS050 )
;
		TAY
		LDA	>RUTDATA+1,X
		STA	<WORK0		;(WK0,1,2) <-- ram unit address(L,H)
;
		LDA	BG1TYP
		ASL	A
;;;;		CLC
		ADC	<WORK3
		TAX
		LDA	>RUTDATA+3,X	;(A) <-- base unit course data
		TYX			;(X) <-- number of data byte
		LDY	#00		;(Y) <-- ram unit pointer
RUTS020		EQU	$
		STA	[<WORK0],Y
		INC	A
		INY
		INY
		DEX
		BNE	RUTS020
;
		LDA	<WORK3
		CLC
		ADC	#1+2+(2*8)	;[ 1:number of unit 2:ram unit address (2*8):unit data address ]
		TAX
		BRA	RUTS010
;
RUTS050		EQU	$
;
		MI8
;
		RTL
;
;************************************************************************
;*		Character buffer set			(CHRREAD)	*
;*		[in]	(work8,9,A)	<-- pless data address		*
;*			(work0,1,2)	<-- data store address		*
;************************************************************************
;
		MEM8
		IDX16
;
CHREAD		EQU	$
		LDY	#00000H		; (Y) <-- chara data buffer index
GTCODE		EQU	$
		JSR	GET1DT		; 1 data read
		CMP	#0FFH
		BNE	GTCOD1		; end ?
		RTS
;
GTCOD1		EQU	$
		STA	<WORK5
		AND	#0E0H
		CMP	#0E0H
		BEQ	GT2COD		; 2 byte code ?
;					; no
		PHA			; (A) push : data type save
		LDA	<WORK5
;
		M16
;
		AND	#0001FH
		BRA	GT2CD2
;
		MEM8
GT2COD		EQU	$
		LDA	<WORK5
		ASL	A
		ASL	A
		ASL	A
		AND	#0E0H
		PHA			; (A) push : data type save
		LDA	<WORK5
		AND	#003H
		XBA
		JSR	GET1DT		; 1 data read
;
		M16
;
GT2CD2		EQU	$
		INC	A
		STA	<WORK3
;
		M8
;
GTCDEN		EQU	$
		PLA			; (A) pull : data type load
		BEQ	NORM		; [ CMP #000H ] = ?
;					; no
		BMI	REF		; [ CMP #1xxH ] > ?
;					; no
		ASL	A
		BPL	REN1		; [ CMP #020H ] > ?
;					; no
		ASL	A
		BPL	REN2		; [ CMP #040H ] > ?
;					; no
REN12		EQU	$
		JSR	GET1DT		; 1 data read
		LDX	<WORK3
REN121		EQU	$
		STA	[<WORK],Y
		INC	A
		INY
		DEX
		BNE	REN121		; end ?
;					; yes
		BRA	GTCODE
;
NORM		EQU	$
		JSR	GET1DT		; 1 data read
		STA	[<WORK],Y
		INY
		LDX	<WORK3
		DEX
		STX	<WORK3
		BNE	NORM		; end ?
;					; yes
		BRA	GTCODE
;
REN1		EQU	$
		JSR	GET1DT		; 1 data read
		LDX	<WORK3
REN11		EQU	$
		STA	[<WORK],Y
		INY
		DEX
		BNE	REN11		; end ?
;					; yes
		BRA	GTCODE
;
REN2		EQU	$
;;;;;;;;		JSR	GET1DT		; 1 data read
;;;;;;;;		XBA
;;;;;;;;		JSR	GET1DT		; 1 data read
		JSR	GET2DT		; 1 data read (x2)
		LDX	<WORK3
REN21		EQU	$
		XBA
		STA	[<WORK],Y
		INY
		DEX
		BEQ	REN22		; end ?
;					; no
		XBA
		STA	[<WORK],Y
		INY
		DEX
		BNE	REN21
REN22		EQU	$
		JMP	GTCODE
;
REF		EQU	$
;;;;;;;;		JSR	GET1DT		; 1 data read
;;;;;;;;		XBA
;;;;;;;;		JSR	GET1DT		; 1 data read
		JSR	GET2DT		; 1 data read (x2)
		TAX
REF1		EQU	$
		PHY
		TXY
		LDA	[<WORK],Y
		PLY
		STA	[<WORK],Y
		INY
		INX
;
		M16
;
		DEC	<WORK3
;
		M8
;
		BNE	REF1		; end ?
;					; yes
		JMP	GTCODE
;
;
;------------------------------------------------
GET1DT		EQU	$
		LDA	[<WORK8]
		LDX	<WORK8
		INX
		BNE	GT1DT1		; (c) on ?
;					; yes
		LDX	#08000H
		INC	<WORKA
GT1DT1		EQU	$
		STX	<WORK8
		RTS
;
;
;------------------------------------------------
GET2DT		EQU	$
		LDA	[<WORK8]
		LDX	<WORK8
		INX
		BNE	GT2DT1		; (c) on ?
;					; yes
		LDX	#08000H
		INC	<WORKA
GT2DT1		EQU	$
		STX	<WORK8
;
		XBA
;
		LDA	[<WORK8]
		INX
		BNE	GT2DT2		; (c) on ?
;					; yes
		LDX	#08000H
		INC	<WORKA
GT2DT2		EQU	$
		STX	<WORK8
		RTS
;
;
;
;
;
		END
