;************************************************************************
;*									*
;*	title name	: "yossy tool"					*
;*	proccess	: edit process					*
;*	file name	: yst_edit					*
;*									*
;************************************************************************
;
;
		SALL
;
		include		yst_header.inc
;
		XALL
;		
;		
;------------------------------------------------------------------------
;
;		Super_Y edit-tool		1992.03.05(THU)
;
;------------------------------------------------------------------------
;
		ORG	02A000H
;
;=============================================== (syt_edit) =============
		GLB	PLAY,MODESL,ERROR,INPTDT,WNDWST
		GLB	PSCTDT1,UNITST0
		GLB	MSSCRMD
		GLB	PLY510
;=============================================== (sytz_main) ==============
		EXT	JSRSUB,JSRSUBL,VRAMCL,OAMCLR,DTBFCLR,DTBFCLR1
;=============================================== (syt_init) ==============
		EXT	BGWRITE,BGSET,UNITST
		EXT	MDSL,CGST,BGWR,PLMD,ERR0,DTSV,DTLD,DTDS,BGDS
		EXT	UPSL,DWSL,LFSL,RISL,STIN,MFRM,DTDL,GAME
		EXT	MSSC
;=============================================== (syt_bgsc0) =============
		EXT	KOTESB,KAHNSB
;=============================================== (syt_data) ==============
		EXT	COSEDAT
;=============================================== yst_en_edit =============
		GLB	ENBGMV
;=========================================================================
BS_LMT		EQU	00FH
;=========================================================================
;
		EXTEND
		MEM8
		IDX8
;
;
;
;************************************************************************
;*		Play main				(PLAY)		*
;************************************************************************
PLAY		EQU	$
		LDA	<INKEY
		CMP	#L_Z		; inkey [Z] ON ?
		BNE	PASS00		;	NO -> PASS00
		JSR	MSSCINT
PASS00		EQU	$
		LDA	<DTMODE		; ka-he-n mode ?
		BEQ	PASS20		;	NO -> PASS20
;
		LDA	<INKEY
		CMP	#L_U		; "U" ON ?
		BNE	PASS10		;	NO -> PASS10
		LDA	<CRSSMMD
		CMP	#002H		; Y lock mode ?
		BEQ	PASS30		;	YES -> PASS30
		EOR	#001H		; X lock
		AND	#001H		;	ON or OFF set
		BRA	PASS15
PASS10		EQU	$
		CMP	#L_Y		; "Y" ON ?
		BNE	PASS30		;	NO -> PASS30
		LDA	<CRSSMMD
		CMP	#001H		; X lock mode ?
		BEQ	PASS30		;	YES -> PASS30
		EOR	#002H		; Y lock
		AND	#002H		;	ON or OFF set
PASS15		EQU	$
		STA	<CRSSMMD
		BRA	PASS30
;
PASS20		EQU	$
		STZ	<CRSSMMD
;
PASS30		EQU	$
		LDA	<MOUSEBT
		AND	#01000000B
		BEQ	PLY0FF		; mouse [L] key --- (data set) ?
		JMP	PLY100		;yes
;					; no
PLY0FF		EQU	$
		LDX	#00		;(X) <-- edit mode select no. 
		LDA	<INKEY
		CMP	#L_Q
		BEQ	PLY0FF2		;"NORMAL" ? ( yes:PLY0FF2 )
;
		INX
		CMP	#L_W
		BEQ	PLY0FF2		;"INSERT" ? ( yes:PLY0FF2 )
;
		INX
		CMP	#L_R
		BEQ	PLY0FF2		;"S-DEL" ? ( yes:PLY0FF2 )
;
		INX
		CMP	#L_T
		BEQ	PLY0FF2		;"DELETE" ? ( yes:PLY0FF2 )
;
		INX
		CMP	#L_S
		BNE	PLY0FFE		;"SERACH" ? ( no:PLY0FFE )
;
		LDY	#0FFH
		STY	<SRCHPT
		STY	<SRCHPT+1
;
PLY0FF2		EQU	$
		STX	<EDMODE
		JMP	PLY040
;
PLY0FFE		EQU	$
		LDX	#MDSL
		CMP	#MOD
		BNE	PLY000		; [F_1] --- (mode select) ?
;
		LDA	<EDMODE
		ASL	A
		INC	A		;[ +08H ]
		ASL	A
		ASL	A
		ASL	A
		STA	<MOUSWK0
		JMP	PLY200
;
PLY000		EQU	$		; no
		CMP	#RTN
		BNE	PLY020		;undo ? ( no:PLY020 )
;
;--------------	to undo data back_up !! -----------------
;
		I16
;
		LDX	<UNDONO
		BNE	PLY010		;undo data nothing ? ( no:PLY010 )
;
		SEP	#00010000B	;index 8 bit mode set
		JMP	PLY040
;
PLY010		EQU	$
		LDA	>UNDOBUF-1,X
		STA	>DTBUFF-1,X
		DEX
		BNE	PLY010		
;;;;		LDX	#00
		STX	<UNDONO		;undo buffer cancel !!
;
		LDX	<UNDOXP1	;cursol pos load
		STX	<CRXPSL1
		LDX	<UNDOYP1
		STX	<CRYPSL1
		LDX	<UNDOXP2
		STX	<CRXPSL2
		LDX	<UNDOYP2
		STX	<CRYPSL2
;
		M16
		I8
;
		LDX	<UNDOSFT	;move cousol index load
		STX	<SIFTFG
;
		JSR	CSRDSCK
		BCC	PLY014		;Y display ? ( yes:PLY014 )
;
		JSR	CNTSCST
;
PLY014		EQU	$	
;
		M8
;
		JMP	>UNITST0	; unit buffer set
;
;--------------------------------------------------------
;
PLY020		EQU	$
		CMP	#SPS
		BNE	PLY028		;return last input data pos ? ( no:PLY028 )
;
;--------------	return last input data pos --------------
		LDA	LASTFG
		BNE	PLY022		;last input data nothing ? ( no:PLY022 )
		JMP	PLY040	
;
PLY022		EQU	$
;
		M16
;
		LDA	LASTXP
		STA	<CRXPSL1
		STA	<CRXPSL2
		LDA	LASTYP
		STA	<CRYPSL1
		STA	<CRYPSL2
;
		JSR	CNTSCST
;
		JMP	>REDISP
;
;----------------------------------------------------------------
;-		cursol display check				-
;----------------------------------------------------------------
CSRDSCK		EQU	$
		LDX	<SIFTFG
		LDA	<CRXPSL1,X
		SEC
		SBC	<SCCH1
		SEC
		SBC	#08H
		CMP	#0F8H-08H
		BCS	CSRDC10		;X display ? ( no:CSRDC10 )
;
		LDA	<CRYPSL1,X
		SEC
		SBC	<SCCV1
		SEC
		SBC	#08H
		CMP	#0A8H-08H
CSRDC10		EQU	$
		RTS
;
;----------------------------------------------------------------
;-		cursol center scroll counter set		-
;----------------------------------------------------------------
CNTSCST		EQU	$
		LDX	<SIFTFG
		LDA	<CRXPSL1,X
		SEC
		SBC	#070H
		CMP	#0FFF8H
		BPL	PLY024
		LDA	#0FFF8H
PLY024		EQU	$
		STA	<SCCH1
		STA	<SCCH3
		LDA	<CRYPSL1,X
		SEC
		SBC	#050H
		CMP	#0FFF8H
		BPL	PLY026
		LDA	#0FFF8H
PLY026		EQU	$
		STA	<SCCV1
		STA	<SCCV3
;
		M8
;
		RTS
;
;--------------------------------------------------------
;
PLY028		EQU	$
		CMP	#F_0
		BNE	PLY030		; [F_10] -- (character change) ?
;
;--------------	game mode -----------------------
		LDA	#GAME
		STA	<GMMODE
		RTL
;
PLY030		EQU	$
		CMP	#CHC
		BNE	PLY031		; [F_7] --- (character change) ?
;
;--------------	go to BG course status data input -------		
		LDA	#080H
		STA	<BLKFLG
		STZ	<HD420C
		LDX	#STIN
		STX	<GMMODE
		STZ	<STINFG
		RTL
;
PLY031		EQU	$
;;;;		CMP	#SPS
;;;;		BEQ	PLY180		; [space] --- (cursol1 = cursol2) ?
;					; no
		LDX	#MFRM
		CMP	#FRM
		BEQ	PLY450		; [F_2] --- (media format) ?
;
		LDX	#DTSV
		CMP	#SAV
		BEQ	PLY300		; [F_3] --- (data save) ?
;					; no
		LDX	#DTLD
		CMP	#LOD
		BEQ	PLY400		; [F_4] --- (data load) ?
;					; no
		LDX	#DTDL
		CMP	#DEL
		BEQ	PLY480		; [F_5] --- (data delete) ?
;					; no
		LDX	#DTDS
		CMP	#UNT
		BEQ	PLY500		; [F_6] --- (unit display) ?
;					; no
		LDA	<INKEY3
		LDX	#LFSL
		CMP	#LFS
		BEQ	PLY800		; [F_8] --- (left scroll) ?
		CMP	#L_K
		BNE	PLY032		; [K] ----- (left scroll) ?
;					; yes
PLY800		EQU	$
		JMP	PLY820
;
PLY032		EQU	$
		LDX	#RISL
		CMP	#RIS
		BEQ	PLY900		; [F_9] --- (right scroll) ?
		CMP	#L_L
		BNE	PLY034		; [L] ----- (right scroll) ?
;					; yes
PLY900		EQU	$
		JMP	PLY920
;
PLY034		EQU	$
		LDX	#UPSL
		CMP	#UPS
		BEQ	PLY600		; [UPS] --- (up scroll) ?
		CMP	#L_O
		BEQ	PLY600		; [O] ----- (up scroll) ?
;					; no
		LDX	#DWSL
		CMP	#DWS
		BEQ	PLY700		; [DWS] --- (down scroll) ?
		CMP	#L_c
		BEQ	PLY700		; [,] ----- (down scroll) ?
;
PLY040		EQU	$
		JSR	MSNDTST		; select no display
;
		JSR	BGMOVE		; BG. move
		JSR	CRMV		; key read and cursol move
		JSL	>BGSET		; BG. set
;
		JSR	DTIMAIN		; data input
;
;-------------  input data set key on  -------------
PLY100		EQU	$
		PHB			;(DBR) save
		PHK			;(DBR) <-- (PBR)
		PLB
;
		JSR	DPDISP		; dtpt & buffer data display
		JSR	MODEPL
;
		PLB
		RTL
;
;
;;;;;------------- coursol equrl key on -------------
;;;;PLY180		EQU	$
;;;;		LDA	<CRYPSL1
;;;;		STA	<CRYPSL2
;;;;		LDA	<CRXPSL1
;;;;		STA	<CRXPSL2
;;;;		LDA	#0FFH
;;;;		STA	<INKEY
;;;;		BRA	PLY040
;
;-------------  delete mode -------------
PLY480		EQU	$
		STZ	<DELFLG
		BRA	PLY410
;
;-------------  media format -------------
PLY450		EQU	$
		STZ	<FRMFLG
		BRA	PLY200
;
;-------------  load mode -------------
PLY400		EQU	$
		STZ	<LDFLG
PLY410		EQU	$
		LDA	#080H
		STA	<BLKFLG
		BRA	PLY200
;
;-------------  save mode -------------
PLY300		EQU	$
		STZ	<SVFLG
;
		PHX			;(X) save
		JSL	>PLY510
		PLX			;(X) load
;
;------------- mode select display key on -------------
PLY200		EQU	$
		STX	<GMMODE
		RTL
;
;-------------  unit display mode -------------
PLY500		EQU	$
		LDA	#080H
		STA	<BLKFLG
		STZ	<HD420C
		STX	<GMMODE
		STZ	<MPDSFG
;
PLY510		EQU	$
		PHB			;(DBR) save
		PHK			;(DBR) <-- (PBR)
		PLB
		JSR	SDPTCAL		;[STDTPT] set
		PLB
		RTL
;
;-------------  up scroll -------------
PLY600		EQU	$
		MEM16
		REP	#00100000B	; memory 16bit mode
;
		LDA	<SCCV1
		CMP	#0FFF8H
		BEQ	PLY680		; scroll ok ?
;					; yes
		SEC
		SBC	#00100H
		CMP	#0FFF8H
		BPL	PLY640		; limit over ?
;					; yes
		LDA	#0FFF8H
PLY640		EQU	$
		STA	<MVSCV1
;
		MEM8
		SEP	#00100000B	; memory 8bit mode
;
		STX	<GMMODE
PLY680		EQU	$
		SEP	#00100000B	; memory 8bit mode
		RTL
;
;
;-------------  down scroll -------------
PLY700		EQU	$
		MEM16
		REP	#00100000B	; memory 16bit mode
;
		LDA	<SCCV1
		CMP	#0758H
		BEQ	PLY680		; scroll ok ?
;					; yes
		CLC
		ADC	#00100H
		CMP	#0758H+1
		BCC	PLY640		; limit over ?
;					; yes
		LDA	#0758H
		BRA	PLY640
;
;
;-------------  left scroll -------------
PLY820		EQU	$
		MEM16
		REP	#00100000B	; memory 16bit mode
;
		LDA	<SCCH1
		CMP	#0FFF8H
		BEQ	PLY680		; scroll ok ?
;					; yes
		SEC
		SBC	#00100H
		CMP	#0FFF8H
		BPL	PLY840		; limit over ?
;					; yes
		LDA	#0FFF8H
PLY840		EQU	$
		STA	<MVSCH1
;
		MEM8
		SEP	#00100000B	; memory 8bit mode
;
		STX	<GMMODE
		RTL
;
;
;-------------  right scroll -------------
PLY920		EQU	$
		MEM16
		REP	#00100000B	; memory 16bit mode
;
		LDA	<SCCH1
		CMP	#0F08H
		BEQ	PLY680		; scroll ok ?
;					; yes
		CLC
		ADC	#00100H
		CMP	#0F08H+1
		BCC	PLY840		; limit over ?
;					; yes
		LDA	#0F08H
		BRA	PLY840
;
;
;
;
;
;
;
		MEM8  
		IDX8
;************************************************************************
;*		data input type select			(DTIMAIN)	*
;************************************************************************
INPDADD		EQU	$
		HEX	FF,01
;
;--------------------------------------	data input
DSPDT		EQU	$
		BYTE	040H,0C2H,000H,032H
		BYTE	048H,0C2H,000H,032H
DSPDTE		EQU	$
;
DTIMAIN		EQU	$
		LDA	<INKEY
		CMP	#NUL
		BEQ	DTIPT20		; key in ?
;					; yes
		CMP	#RTN
		BNE	DTIPT00		; [return] ?
;					; yes
		STZ	<INDTPT		; data set point clear
		BRA	DTIPT20
;
DTIPT00		EQU	$
		CMP	#SU0
		BCC	PPAASS
		CMP	#L_G
		BCC	DTIPT10		; input key (0 ~ F) ?
;					; no
PPAASS		EQU	$
		LDA	<INKEY3
		LDX	#00
		LDY	#00
		CMP	#L_H
		BEQ	DTIPT02
		INY
		CMP	#L_N
		BEQ	DTIPT02
;
		INX
		DEY
		CMP	#L_J
		BEQ	DTIPT02
		INY
		CMP	#L_M
		BNE	DTIPT20
DTIPT02		EQU	$
		LDA	<INPBUF,X
		PHX
		TAX
		LDA	>INPTDT,X
		CLC
		TYX
		ADC	>INPDADD,X
		AND	#0FH
		ORA	#SU0
		CMP	#SU9+1
		BCC	DTIPT04
;
;;;;		CLC
		ADC	#L_A-SU9-1-1
DTIPT04		EQU	$
		PLX
		STA	<INPBUF,X
		BRA	DTIPT20
;
DTIPT10		EQU	$
		LDX	<INDTPT
		LDA	<INKEY
		STA	<INPBUF,X	; input data set
;
		TXA
		EOR	#00000001B
		STA	<INDTPT
;
;-------------- BG data type no. OAM set ----------------
DTIPT20		EQU	$
		LDX	#DSPDTE-DSPDT-1
DTIPT40		EQU	$
		LDA	>DSPDT,X
		STA	!UTNOAM,X
		DEX
		BPL	DTIPT40		;
;					;
		LDA	<INPBUF
		STA	!UTNOAM+4*0+2
		LDA	<INPBUF+1
		STA	!UTNOAM+4*1+2
;
		LDA	<FRCNT
		AND	#00001000B
		BEQ	DTIPT80		; flashing ?
;					; yes
		LDA	<INDTPT
		ASL	A
		ASL	A
		TAY
		LDA	#030H
		STA	!UTNOAM+4*0+3,Y
DTIPT80		EQU	$
		LDX	<INPBUF+0
		LDA	>INPTDT,X
		ASL	A
		ASL	A
		ASL	A
		ASL	A
		STA	<WORK0
		LDX	<INPBUF+1
		LDA	>INPTDT,X
		ORA	<WORK0
		RTS
;
;
;
;
;************************************************************************
;*		Mode no. display			(BSNDTST)	*
;************************************************************************
MSNDT		EQU	$
		BYTE	0C8H,010H,000H,038H
		BYTE	0D0H,010H,000H,038H
		BYTE	0D8H,010H,000H,038H
		BYTE	0E0H,010H,000H,038H
		BYTE	0E8H,010H,000H,038H
		BYTE	0F0H,010H,000H,038H
;
		BYTE	0C8H,020H,0E0H,038H	;
		BYTE	0D8H,020H,0E2H,038H	;  [course name]
		BYTE	0E8H,020H,0E4H,038H	;
MSNDTE		EQU	$
;
MSNDTCT		EQU	MSNDTE-MSNDT-1
;
;
MSDATA		EQU	$
		BYTE	080H,081H,082H,083H,084H,085H	;00 : NORMAL
		BYTE	090H,091H,092H,093H,094H,095H	;01 : S-DEL
		BYTE	0A0H,0A1H,0A2H,0A3H,0A4H,0A5H	;02 : INSEART
		BYTE	0B0H,0B1H,0B2H,0B3H,0B4H,0B5H	;03 : DELETE
		BYTE	0C0H,0C1H,0C2H,0C3H,0C4H,0C5H	;04 : SEARCH
		BYTE	0D0H,0D1H,0D2H,0D3H,0D4H,0D5H	;05 : B-CHNG
;
;
MSNDTST		EQU	$
		PHB
		PHK
		PLB			; (DBR) set
;
		LDX	#MSNDTCT
MSN0100		EQU	$
		LDA	MSNDT,X
		STA	!MODOAM,X
		DEX
		BPL	MSN0100		;
;					;
		LDY	<EDMODE		; (Y) <-- mode no.
		LDX	MDDTPT,Y
		LDA	MSDATA+0,X
		STA	!MODOAM+4*0+2
		LDA	MSDATA+1,X
		STA	!MODOAM+4*1+2
		LDA	MSDATA+2,X
		STA	!MODOAM+4*2+2
		LDA	MSDATA+3,X
		STA	!MODOAM+4*3+2
		LDA	MSDATA+4,X
		STA	!MODOAM+4*4+2
		LDA	MSDATA+5,X
		STA	!MODOAM+4*5+2
;
		LDA	#00101010B
		STA	!OAMSUB+((CHCOAM-OAM)>>4)
;
		PLB			; (DBR) reset
		RTS
;
;
;
;
;
;************************************************************************
;*		Mode play				(MODEPL)	*
;************************************************************************
INPTDT		EQU	$
;				ASC --> HEX
;			 0  1  2  3  4  5  6  7  8  9  A  B  C  D  E  F
		HEX	FF,FF,FF,FF,FF,FF,FF,FF,FF,FF,FF,FF,FF,FF,FF,FF	; 0
		HEX	FF,FF,FF,FF,FF,FF,FF,FF,FF,FF,FF,FF,FF,FF,FF,00 ; 1
		HEX	7F,FF,FF,FF,FF,FF,FF,FF,FF,FF,FF,FF,FF,25,26,27 ; 2
		HEX	00,01,02,03,04,05,06,07,08,09,FF,FF,FF,28,FF,FF ; 3
		HEX	FF,0A,0B,0C,0D,0E,0F,10,11,12,13,14,15,16,17,18 ; 4
		HEX	19,1A,1B,1C,1D,1E,1F,20,21,22,23,FF,FF,FF,FF,29 ; 5
		HEX	FF,FF,FF,FF,FF,FF,FF,FF,FF,FF,FF,FF,FF,FF,FF,FF ; 6
		HEX	FF,FF,FF,FF,FF,FF,FF,FF,FF,FF,FF,FF,FF,FF,FF,FF ; 7
;
;
MODEPL		EQU	$
		LDA	<EDMODE
		JSL	>JSRSUB
Normal		WORD	DATSL		;00   NORMAL
Insert		WORD	INSERT		;01   INSERT
S_del		WORD	SRCDEL		;02   S-DEL
Delete		WORD	DELET		;03   DELET
Search		WORD	SEARCH		;04   SERCH
;;;;B_chng		WORD	BSCHNG		;05   B_CHNG
;
normal		EQU	(Normal-Normal)/2
insert		EQU	(Insert-Normal)/2
s_del		EQU	(S_del-Normal)/2
delete		EQU	(Delete-Normal)/2
search		EQU	(Search-Normal)/2
;;;;b_chng		EQU	(B_chng-Normal)/2
;
;
;
;
;----------------------------------------------------------------
;-		to undo data back_up !!				-
;----------------------------------------------------------------
UNDOBFST	EQU	$
;
		I16
;
		LDX	<STDTPT
		INX
		STX	<UNDONO
UNDBS010	EQU	$
		LDA	>DTBUFF-1,X
		STA	>UNDOBUF-1,X
		DEX
		BNE	UNDBS010
;
		LDX	<CRXPSL1	;cursol pos save
		STX	<UNDOXP1
		LDX	<CRYPSL1
		STX	<UNDOYP1
		LDX	<CRXPSL2
		STX	<UNDOXP2
		LDX	<CRYPSL2
		STX	<UNDOYP2
		LDA	<SIFTFG
		STA	<UNDOSFT	;move cousol index save
;
		I8
;
		RTS
;
;
;------------------------------------------------------------------------
;-		Data select & buffer set [NORMAL]	(DATSL)		-
;------------------------------------------------------------------------
DATSL		EQU	$
		LDA	<MOUSEBT
		AND	#01000000B
		BEQ	DATEND		; mouse [L] key --- (data set) ?
;					; no
		JSR	UNDOBFST
;
DATSL1		EQU	$
		LDX	<INPBUF+0
		LDA	>INPTDT,X
		ASL	A
		ASL	A
		ASL	A
		ASL	A
		STA	<WORK+2
		LDX	<INPBUF+1
		LDA	>INPTDT,X
		TSB	<WORK+2		;(WK2) <-- type no.
;
		LDA	<DTMODE
		BEQ	DTSL010		; kotei ?
		JMP	BGUTS200
;					; yes
;--------------	kotei data set --------------------------
DTSL010		EQU	$
		LDX	<WORK+2
		LDA	>KOTESB,X
		BPL	DTSL020		;type no. error ? ( no:DTSL020 )
		JMP	ERRST0
;
DTSL020		EQU	$
;
		I16
;
		LDX	<STDTPT		; (X) <-- set data pointer
		LDA	#00
		STA	>DTBUFF,X	;kotei flag set
		JSR	CPSCAL
		STA	>DTBUFF+1,X	; X,Y(H) set
		LDA	<WORK+1
		STA	>DTBUFF+2,X	; X,Y(L) set
		LDA	<WORK+2
		STA	>DTBUFF+3,X	; kotei data type no. set
		LDA	#0FFH
		STA	>DTBUFF+4,X	; end code
;
		I8
;
		STZ	<SIFTFG
;
DTSL030		EQU	$
;
;--------------	last input data pos set -------------------------
;
		M16
;
		LDA	CRXPSL1
		AND	#0FF0H
		STA	LASTXP
		LDA	CRYPSL1
		AND	#07F0H
		STA	LASTYP
;
		M8
;
		LDA	#01H
		STA	LASTFG
;
		JSL	>UNITST0		; unit buffer set
;
DATEND		EQU	$
		RTS
;
;--------------	kahen data set --------------------------
KAHNNO		EQU	$	;number of data byte
		HEX	4	;[00]
		HEX	4	;[01]
		HEX	5	;[02]
;
BGUTS200	EQU	$
		LDX	<WORK+2
		LDA	>KAHNSB,X
		CMP	#0FFH
		BNE	BGUTS202	; type no. error ? ( no:BGUTS202 )
		JMP	ERRST0
;
BGUTS202	EQU	$
		TXA
;
		I16
;
		LDX	<STDTPT		; (X) <-- set data pointer
		STA	>DTBUFF,X	; kahen type no. set
		TAY			;(Y) <-- kahen type no.
		JSR	CPSCAL
		STA	>DTBUFF+1,X	; X,Y(H) set
		LDA	<WORK+1
		STA	>DTBUFF+2,X	; X,Y(L) set
;
		I8
;
		TYX
		LDA	>KAHNSB,X
		STA	<WORK+6		;(WK6) <-- kahen data status data
;
		M16
;		
		LDA	<CRXPSL1
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		STA	<WORK+3
		LDA	<CRSSMMD	; end cursol semi auto flag
		AND	#00001H
		BEQ	TAIHI00
		LDA	<XTAIHI
		BRA	TAIHI05
TAIHI00		EQU	$
		LDA	<CRXPSL2
TAIHI05		EQU	$
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		SEC
		SBC	<WORK+3
		BPL	BGUTS210	;- X wide ? ( no:BGUTS210 )
		LDY	<WORK+6
		BMI	BGUTS210	;X wide + only ? ( no:BGUTS210 )
;
		EOR	#00FFH
		INC	A
BGUTS210	EQU	$
		STA	<WORK+3		;(WK3) <-- X wide
;
		LDA	<CRYPSL1
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		STA	<WORK+4
		LDA	<CRSSMMD	; end cursol semi auto flag
		AND	#00002H
		BEQ	TAIHI10
		LDA	<YTAIHI
		BRA	TAIHI15
TAIHI10		EQU	$
		LDA	<CRYPSL2
TAIHI15		EQU	$
		LSR	A
		LSR	A
		LSR	A
		LSR	A
;
		M8
;
		SEC
		SBC	<WORK+4
		BPL	BGUTS220	;- Y wide ? ( no:BGUTS220 )
		BIT	<WORK+6
		BVS	BGUTS220	;Y wide + only ? ( no:BGUTS220 )
;
		EOR	#0FFH
		INC	A
BGUTS220	EQU	$
		STA	<WORK+4		;(WK4) <-- Y wide
;
		LDA	<WORK+6
		AND	#3FH
		ASL	A
		TAX
		JSR	(!KAHNSEL,X)	;kahen sub select
;
		JSR	DTSL030
;
;--------------	cursol reset ------------------------------------
		LDX	<SIFTFG		;main cursol set !!
		TXA
		EOR	#02H
		TAY
;
		M16
;
		LDA	<CRXPSL1,X	;main cursol <-- sub cursol !!
		STA	CRXPSL1,Y
		LDA	<CRYPSL1,X
		STA	CRYPSL1,Y
;
		M8
;
		STZ	<SIFTFG		;main cursol set !!
		RTS
;
;--------------------------------------------------------
;-		error set !!				-
;--------------------------------------------------------
ERRST0		EQU	$
;
		MI8
;
		LDA	#03FH
		STA	<ERRFLG
		LDA	#ERR0
		STA	<GMMODE
		RTS
;
;--------------------------------------------------------
;-		kahen sub select			-
;--------------------------------------------------------
KAHNSEL		EQU	$
		WORD	KAHNSB0	
		WORD	KAHNSB1	
		WORD	KAHNSB2	
;
;--------------	kahen sub.1 ---------------------
KAHNSB0		EQU	$
;
		I16
;
		LDX	<STDTPT		; (X) <-- set data pointer
		LDA	<WORK+3
		STA	>DTBUFF+3,X	; data number set
		LDA	#0FFH
		STA	>DTBUFF+4,X	; end code set
;
		I8
;
		RTS
;
;--------------	kahen sub.2 ---------------------
KAHNSB1		EQU	$
;
		I16
;
		LDX	<STDTPT		; (X) <-- set data pointer
		LDA	<WORK+4
		STA	>DTBUFF+3,X	; data number set
		LDA	#0FFH
		STA	>DTBUFF+4,X	; end code set
;
		I8
;
		RTS
;
;--------------	kahen sub.3 ---------------------
KAHNSB2		EQU	$
;
		I16
;
		LDX	<STDTPT		; (X) <-- set data pointer
		LDA	<WORK+3
		STA	>DTBUFF+3,X	; data number set
		LDA	<WORK+4
		STA	>DTBUFF+4,X	; data number set
		LDA	#0FFH
		STA	>DTBUFF+5,X	; end code set
;
		I8
;
		RTS
;
;--------------	kahen sub.4 ---------------------
KAHNSB3		EQU	$
;
		I16
;
		LDX	<STDTPT		; (X) <-- set data pointer
		LDA	<CRXPSH2
		AND	#0FH
		STA	<WORK+5
		LDA	<CRYPSH2
		AND	#07H
		ASL	A	
		ASL	A	
		ASL	A	
		ASL	A	
		ORA	<WORK+5
		STA	>DTBUFF+3,X	; data number set
		LDA	#0FFH
		STA	>DTBUFF+4,X	; end code set
;
		I8
;
		RTS
;
;
;
;------------------------------------------------------------------------
;-		Inseart [INSERT]			(INSERT)	-
;------------------------------------------------------------------------
INSERT		EQU	$
		LDA	<MOUSEBT
		AND	#01000000B
		BNE	INS0010		; mouse [L] key --- (data set) ?
;					; no
		REP	#00100000B	;memory 16 bit mode
;
		LDA	<SRCHNO
		JMP	DPD0300		; point display
;
INS0010		EQU	$
		JSR	INSPL
		LDA	<ERRFLG
		BNE	INSEND		;error ? ( yes:INSEND )
;
		JSL	>UNITST0		; unit buffer set
;
		STZ	<EDMODE			;nomal mode return
INSEND		EQU	$
		RTS
;
INSPL		EQU	$
		JSR	UNDOBFST
;
		MI16
;
		LDX	<INSTPT
		BPL	INP0000		;serach pointer nothing ? ( no:INP0000 )
		JMP	ERRST0
;
;-------------- now data save -------------------
INP0000		EQU	$
		LDA	<STDTPT
		SEC
		SBC	<INSTPT
		PHA			;number of copy data byte save
		TAY
		STX	<STDTPT
;
		M8
;
INP0010		EQU	$
		LDA	>DTBUFF,X
		STA	>DTBUFF2,X
		INX
		DEY
		BPL	INP0010
;
		I8
;
;-------------- data set ------------------------
		JSR	DATSL1
;
		MI16
;
		PLA
;
		LDY	<ERRFLG
		BNE	INSEND		;error return ? ( yes:INSEND )
;
		STA	<WORK1E		;(WK1E,1F) <-- number of copy data byte save
;
;--------------	data change ---------------------		
		LDY	#04		;(Y) <-- number of kotei data byte
		LDX	<INSTPT
		LDA	>DTBUFF,X
		AND	#00FFH
		BEQ	INP0040		;kotei ? ( yes:INP0040 )
;
		PHX			;(X) save
		TAX
		LDA	>KAHNSB,X
		PLX			;(X) load
		AND	#003FH
		TAY
		LDA	!KAHNNO,Y
		AND	#00FFH
		TAY			;(Y) <-- number of kahen data byte
INP0040		EQU	$
		TYA
		CLC
		ADC	<INSTPT
		STA	<INSTPT
		STA	<SRCHPT
		INC	<SRCHNO
		TAY
		CLC
		ADC	<WORK1E
		STA	<WORK1E
;
		LDA	#DTBUFF
		STA	<WORK
;
		M8
;
		LDA	#BANK DTBUFF
		STA	<WORK+2
INP0050		EQU	$
		CPY	<WORK1E
		BCS	INP0060
		LDA	>DTBUFF2,X
		STA	[<WORK],Y
		INX
		INY
		BRA	INP0050
;
INP0060		EQU	$
		LDA	#0FFH		;end code set
		STA	[<WORK],Y
;
		I8
;
		RTS
;
;
;
;
;------------------------------------------------------------------------
;-		Search- delete [S_DEL]			(SRCDEL)	-
;------------------------------------------------------------------------
SRCDEL		EQU	$
		LDA	<MOUSEBT
		AND	#01000000B
		BEQ	SDLEND		; mouse [L] key --- (data set) ?
;					; no
		JSR	CPSCAL		; (WK0,1) <-- check x,y-pos.
;
		M16
;
		LDA	#0FFFFH
		STA	<SRCHPT
SRD0000		EQU	$
		PHA
;
		M8
;
		JSR	SRCHSB		;data search
;
		M16
;
		PLA
		BCC	SRD0002		;search ok ? ( no:SRD0002 )
		LDA	<SRCHPT
		BRA	SRD0000
;
SRD0002		EQU	$
		BPL	SRD0010		;error ? ( yes:SRD0010 )
		JMP	SAPERR
;
SRD0010		EQU	$
;
		M8
;
		JSR	DELPL
		LDA	ERRFLG
		BNE	SDLEND		;error ? ( yes:SDLEND )
;
		JSL	>UNITST0			; unit buffer set
;
		STZ	<EDMODE			;nomal mode return
SDLEND		EQU	$
		RTS
;
;
;
;
;------------------------------------------------------------------------
;-		Delete [DELETE]				(DELET)		-
;------------------------------------------------------------------------
DELET		EQU	$
		LDA	<MOUSEBT
		AND	#01000000B
		BEQ	DELEND		; mouse [L] key --- (data set) ?
;					; no
		JSR	DELPL
		LDA	ERRFLG
		BNE	DELEND		;error ? ( yes:DELEND )
;
		JSL	>UNITST0			; unit buffer set
;
		STZ	<EDMODE			;nomal mode return
DELEND		EQU	$
		RTS
;
;
DELPL		EQU	$
		JSR	UNDOBFST
;
		I16
;
		LDY	<SRCHPT	
		BMI	DLPER10
;
		PHB			;(DBR) save
		LDA	#BANK DTBUFF
		PHA
		PLB
DLP0010		EQU	$
;
		M16
;
		LDX	#04H		;(X) <-- number of kotei data byte
		LDA	DTBUFF,Y
		AND	#00FFH
		BEQ	DLP0020		;kotei ? ( yes:DLP0020 )
;
		CMP	#0FFH
		BEQ	DLPERR		;data end ? ( yes:DLPERR )
;
		TAX
		LDA	>KAHNSB,X
		AND	#003FH
		TAX
		LDA	>KAHNNO,X
		AND	#00FFH
		TAX			;(X) <-- number of kahen data byte
DLP0020		EQU	$
		STX	<WORK		;(WK0,1) <-- number of data byte
		TYA
		CLC
		ADC	<WORK
		TAX
;
		M8
;
DLP0030		EQU	$
		LDA	DTBUFF,X
		STA	DTBUFF,Y
		INX
		INY
		DEC	<WORK
		BNE	DLP0030
;
		M16
;
		LDA	#04H		;(WK0,1) <-- number of kotei data byte
		STA	<WORK
		LDA	DTBUFF,X
		AND	#00FFH
		BEQ	DLP0030		;kotei ? ( yes:DLP0030 )
;
		CMP	#0FFH
		BEQ	DLP0040		;data end ? ( yes:DLP0040 )
;
		PHX			;(X) save
		TAX
		LDA	>KAHNSB,X
		AND	#003FH
		TAX
		LDA	>KAHNNO,X
		AND	#00FFH
		STA	<WORK		;(WK0,1) <-- number of kahen data byte
		PLX			;(X) load
		BRA	DLP0030
;
DLP0040		EQU	$		
;
		MI8
;
		PLB
		RTS
;
;-------------- delete error set ----------------
DLPERR		EQU	$
		PLB
		
DLPER10		EQU	$
;
		MI8
;
		LDA	#03FH
		STA	<ERRFLG
		LDA	#ERR0
		STA	<GMMODE
		RTS
;
;
;
;
;------------------------------------------------------------------------
;-		Search [SEARCH]				(SEARCH)	-
;------------------------------------------------------------------------
SEARCH		EQU	$
		LDA	<MOUSEBT
		AND	#01000000B
		BEQ	SRCH200		; mouse [L] key --- (data set) ?
;					; no
		JSR	CPSCAL		; (WK0,1) <-- check x,y-pos.
		JSR	SRCHSB
		BCC	SAPERR		; not search ? ( yes:SAPERR )
;
SRCH200		EQU	$
;
		MI16
;
		LDX	<SRCHPT
		BMI	SRCH500		; search display ok ?
;					; yes
		LDY	#04		;(Y) <-- number of kotei data byte
		LDA	>DTBUFF,X
		AND	#00FFH		;[ (B)=0 ]
		BEQ	SRCH210		; kahen data ?
;					; yes
		PHX			;(X) save
		TAX
		LDA	>KAHNSB,X
		PLX			;(X) load
		AND	#003FH
		TAY
		LDA	!KAHNNO,Y
		AND	#00FFH		;[ (B)=0 ]
		TAY			;(Y) <-- number of kahen data byte
;
SRCH210		EQU	$
		STY	<WORK		;(WK0) <-- number of data byte
;
		M8
;
		LDY	#00		;(Y) <-- OAM index
SRCH220		EQU	$
		LDA	#C_HI
		STA	!PTDOAM+(DPTDT0-DPTDT+2)+4*4,Y
		PHX
		LDA	>DTBUFF,X
		PHA
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		TAX
		LDA	>PSCTDT1,X
		STA	!PTDOAM+(DPTDT0-DPTDT+2)+4*5,Y
		PLA
		AND	#00001111B
		TAX
		LDA	>PSCTDT1,X
		STA	!PTDOAM+(DPTDT0-DPTDT+2)+4*6,Y
		PLX
		INX
		TYA			;[ (Y) < FF !! then (B)=0 ]
		CLC
		ADC	#4*3
		TAY
		DEC	<WORK
		BNE	SRCH220
;
		M16
		I8
;
		LDA	<SRCHNO
		JSR	DPD0300		; point display
;
SRCH500		EQU	$
;
		MI8
;
		RTS
;
;
;
;--------------	search error set ----------------
SAPERR		EQU	$
;
		MI8
;
		LDA	#0FFH
		STA	<SRCHPT		; search point clear
		STA	<SRCHPT+1
		STA	<INSTPT		; insert      "
		STA	<INSTPT+1
;
		LDA	#03FH
		STA	<ERRFLG
		LDA	#ERR0
		STA	<GMMODE
		RTS
;
;
;
;--------------------------------------------------------
;-		data search 				-
;--------------------------------------------------------
SRCHSB		EQU	$
;
		MI16
;
		LDX	<SRCHPT
		BPL	SRCH010		; initial ?
;					; yes
		INX			;[ LDX #00 ]
		STZ	<SRCHNO
		BRA	SRCH020
;
;--------------	pointer up !! -------------------
SRCH000		EQU	$
;
		M16
;
SRCH010		EQU	$
		LDY	#04		;(Y) <-- number of kotei data byte
		LDA	>DTBUFF,X
		AND	#00FFH
		BEQ	SRCH012		;kotei ? ( yes:SRCH012 )
;
		CMP	#00FFH
		BEQ	SRCH050		;end code ? ( yes:SRCH050 )
;
		PHX			;(X) save
		TAX
		LDA	>KAHNSB,X
		PLX			;(X) load
		AND	#003FH
		TAY
		LDA	!KAHNNO,Y
		AND	#00FFH
		TAY
SRCH012		EQU	$
		STY	<WORK+2
		TXA
		CLC
		ADC	<WORK+2
		TAX
		INC	<SRCHNO		; search data no. up !!
;
;--------------	X,Y pos search ------------------
SRCH020		EQU	$
;
		M8
;
		LDA	>DTBUFF,X
		CMP	#0FFH
		BEQ	SRCH050		;end code ? ( yes:SRCH050 )
;
		LDA	>DTBUFF+1,X
		CMP	<WORK
		BNE	SRCH000		;= pos ? ( no:SRCH000 )
		LDA	>DTBUFF+2,X
		CMP	<WORK+1
		BNE	SRCH000		;	    "
;
		STX	<SRCHPT		; search pointer up !!
		STX	<INSTPT		; insert      "
;
		IDX8
		SEP	#00010001B	;(C)<-1
		RTS
;
;--------------	not search return set !! --------
SRCH050		EQU	$
;
		MI8
;
		CLC
		RTS
;
;----------------------------------------------------------------------------------------
;		1,2,3,4			X	-----> WORK2   Y ------> WORK4
;----------------------------------------------------------------------------------------
CPSCAL		EQU	$
		LDA	<CRXPSL1
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		STA	<WORK+1
		LDA	<CRYPSL1
		AND	#11110000B
		TSB	<WORK+1		;(WK1) <-- X,Y(L)
		LDA	<CRYPSH1
		ASL	A
		ASL	A
		ASL	A
		ASL	A
		ORA	<CRXPSH1
		STA	<WORK		;(WK0) <-- X,Y(H)
		RTS
;
;
;
;
;
;
;************************************************************************
;*		BG. move				(BGMOVE)	*
;************************************************************************
BGMOVE		EQU	$
;
		I16
;
		LDX	#00000H
		LDY	#00008H
		LDA	<INKEY2
		CMP	#RIT
		BEQ	BGM040		; --> key ?
;					; yes
		CMP	#LEF
		BNE 	BGM100		; <-- key ?
;					; yes
		LDY	#0FFF8H
		INX
		INX
BGM040		EQU	$
;
		M16
;
		TYA
		CLC
		ADC	<SCCH1
		CMP	#0FFF8H
		BPL	BGM050		; move ok ?
;
		LDA	#0FFF8H
BGM050		EQU	$
		CMP	#0F08H+1
		BMI	BGM052		; move ok ?
;
		LDA	#0F08H
BGM052		EQU	$
		STA	<SCCH1
		STA	<SCCH3
		STX	!SCHMUK
;
		LDA	<SIFTFG
		AND	#00FFH
		TAX
		LDA	<CRXPSL1,X
		SEC
		SBC	<SCCH1
		TAY
		SEC
		SBC	#008H
		BMI	BGM060		; arrow x-pos. reset ?
;					; no
		TYA
		SEC
		SBC	#00F8H
		BMI	BGM080		; arrow x-pos. reset ?
;					; yes
BGM060		EQU	$
		EOR	#0FFFFH
		SEC			;[ INC A ]
		ADC	<CRXPSL1,X
		STA	<CRXPSL1,X
BGM080		EQU	$
		BRA	BGM180
;
;
		MEM8
;
BGM100		EQU	$
		LDX	#00000H
		LDY	#00008H
		CMP	#DWN
		BEQ	BGM140		; down key ?
;					; yes
		CMP	#UPP
		BNE	BGM200		; up key ?
;					; yes
		LDY	#0FFF8H
		INX
		INX
BGM140		EQU	$
;
		M16
;
		TYA
		CLC
		ADC	<SCCV1
		CMP	#0FFF8H
		BPL	BGM150		; move ok ?
;
		LDA	#0FFF8H
BGM150		EQU	$
		CMP	#0758H+1
		BMI	BGM152		; move ok ?
;
		LDA	#0758H
BGM152		EQU	$
		STA	<SCCV1
		STA	<SCCV3
		STX	!SCVMUK
;
		LDA	<SIFTFG
		AND	#00FFH
		TAX
		LDA	<CRYPSL1,X
		SEC
		SBC	<SCCV1
		TAY
		SEC
		SBC	#008H
		BMI	BGM160		; arrow x-pos. reset ?
;					; no
		TYA
		SEC
		SBC	#000A8H
		BMI	BGM180		; arrow x-pos. reset ?
;					; yes
BGM160		EQU	$
		EOR	#0FFFFH
		SEC			;[ INC A ]
		ADC	<CRYPSL1,X
		STA	<CRYPSL1,X
BGM180		EQU	$
;
BGM200		EQU	$
;
		MI8
;
		RTS
;
;------------------------------------------ en_edit
ENBGMV		EQU	$
		JSR	BGMOVE
		RTL
;
;
;
;
;************************************************************************
;*		Arrow cursol move			(CRMV)		*
;************************************************************************
DISPDT		EQU	$
		BYTE	018H,0AAH,C_X, 032H	;"X-XX"
		BYTE	020H,0AAH,C_HI,032H
		BYTE	028H,0AAH,000H,032H
		BYTE	030H,0AAH,000H,032H
;
		BYTE	018H,0B2H,C_Y, 032H	;"Y-XX"
		BYTE	020H,0B2H,C_HI,032H
		BYTE	028H,0B2H,000H,032H
		BYTE	030H,0B2H,000H,032H
;
		BYTE	018H,0BCH,086H,038H	;"kotei" or "kahen"
		BYTE	028H,0BCH,088H,038H
;
		BYTE	040H,0BAH,C_N,032H	;"NO"
		BYTE	048H,0BAH,C_O,032H
		BYTE	038H,0C2H,C_HI,032H	;"-XX-XX"
;
		BYTE	058H,0BAH,000H,032H	;"XW"
		BYTE	060H,0BAH,000H,032H
		BYTE	070H,0BAH,000H,032H	;"YW"
		BYTE	078H,0BAH,000H,032H
		BYTE	050H,0C2H,000H,032H
		BYTE	058H,0C2H,000H,032H
		BYTE	060H,0C2H,000H,032H
		BYTE	068H,0C2H,000H,032H
		BYTE	070H,0C2H,000H,032H
		BYTE	078H,0C2H,000H,032H
;
LOCKDT		EQU	$
		BYTE	088H,0B2H,000H,032H	; X , Y
		BYTE	090H,0B2H,000H,032H	;  LOCK ON
		BYTE	098H,0B2H,000H,032H	;	DISP SET
		BYTE	0A0H,0B2H,000H,032H	;
;
DISPDTE		EQU	$
;
;
PSCTDT0		EQU	$
		HEX	30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30
PSCTDT1		EQU	$
;			 0  1  2  3  4  5  6  7  8  9  a  b  c  d  e  f
		HEX	30,31,32,33,34,35,36,37,38,39,41,42,43,44,45,46
;
CRATBD0		EQU	$
		HEX	088,000,086
CRATBD1		EQU	$
		HEX	08C,000,08A
;
STMDATB		EQU	$
		HEX	038,03A
;
DTMDCH0		EQU	$		;"kotei" or "kahen" chara no. data
		HEX	0A6,0AA
DTMDCH1		EQU	$
		HEX	0A8,0AC
;
;
CRMV		EQU	$
		LDX	<SIFTFG
;;K;;		LDA	<EDMODE
;;K;;		CMP	#delete
;;K;;		BNE	CRM0000		; delete ?
;;K;;;					; yes
;;K;;		JMP	CRM0400
;
;--------------	kotei or kahen change -------------------
CRM0000		EQU	$
		LDA	<INKEY
		CMP	#ESC
		BNE	CRM0040		; 'ESC' key ?
;					; yes
		LDA	<DTMODE
		EOR	#01H
		STA	<DTMODE
		STZ	<SIFTFG
;
;--------------	cursol select ---------------------------
CRM0040		EQU	$
		LDA	<DTMODE
		BEQ	CRM0100		; kahen ?
;					; yes
		LDA	<MOUSEBT
		AND	#10000000B
		BEQ	CRM0100		; mouse [R] key ?
;					; yes
		TXY			;(Y) <-- old cursol index save
		TXA
		EOR	#00000010B
		STA	<SIFTFG
		TAX
;
		M16
;
		LDA	<CRXPSL1,X
		SEC
		SBC	<SCCH1
		SEC
		SBC	#08H
		CMP	#0F8H-08H
		BCS	CRM050		;cursol pos reset ? ( yes:CRM050 )
		LDA	<CRYPSL1,X
		SEC
		SBC	<SCCV1
		SEC
		SBC	#08H
		CMP	#0D8H-08H
		BCC	CRM0100		;cursol pos reset ? ( no:CRM0100 )
;
CRM050		EQU	$
		LDA	CRXPSL1,Y	;new cursol pos reset !!
		STA	<CRXPSL1,X
		LDA	CRYPSL1,Y
		STA	<CRYPSL1,X
;
;-------------- mouse pos check -------------------------
CRM0100		EQU	$
		LDA	<MOUSEBX
		BEQ	CRM0200		; x-move ?
;					; yes
		BMI	CRM0140		; --> key ?
;					; yes
;--------------	mouse right move ----------------
;
		M16
;
		AND	#0007FH
		STA	<WORK0
;
		CLC
		ADC	<CRXPSL1,X
		CMP	#1000H
		BCC	CRM0110
		LDA	#0FFFH
CRM0110		EQU	$
		STA 	<CRXPSL1,X
		SEC
		SBC	<SCCH1
		SEC
		SBC	#000F8H-1
		BMI	CRM0180		; cursol limit scroll ?
;					; yes
;;;;		CMP	#08H+1
		CMP	#10H+1
		BCC	CRM0112		;8 dot scroll over ? ( no:CRM0112 )
;
		LDA	<SCCH1
		CLC
;;;;		ADC	#00F8H+08H
		ADC	#00F8H+10H
		STA	<CRXPSL1,X
;;;;		LDA	#08H
		LDA	#10H
CRM0112		EQU	$
		CLC
		ADC	<SCCH1
		LDY	#00H
		BRA	CRM0160
;
;--------------	mouse left move -----------------
CRM0140		EQU	$
;
		M16
;
		ORA	#0FF00H
		STA	<WORK0
;
		CLC
		ADC 	<CRXPSL1,X
		BPL	CRM0150
		LDA	#00
CRM0150		EQU	$
		STA 	<CRXPSL1,X
		SEC
		SBC	<SCCH1
		SEC
		SBC	#00008H
		BPL	CRM0180		; cursol limit scroll ?
;					; yes
;;;;		CMP	#0FFF8H
		CMP	#0FFF0H
		BCS	CRM0151		;8 dot scroll over ? ( no:CRM0151 )
;
		LDA	<SCCH1
		CLC
;;;;		ADC	#00008H-08H
		ADC	#00008H-10H
		STA 	<CRXPSL1,X
;;;;		LDA	#0FFF8H
		LDA	#0FFF0H
CRM0151		EQU	$
		CLC
		ADC	<SCCH1
		LDY	#02H
;
CRM0160		EQU	$
		STA	<SCCH1
		STA	<SCCH3
		STY	SCHMUK
;
CRM0180		EQU	$
;
		M8
;
CRM0200		EQU	$
		LDA	<MOUSEBY
		BEQ	CRM0400		; y-move ?
;					; yes
		BMI	CRM0240		; down key ?
;
;--------------	mouse down move -----------------
;					; yes
		M16
;
		AND	#0007FH
		CLC
		ADC	<CRYPSL1,X
		CMP	#0800H
		BCC	CRM0210
		LDA	#07FFH
CRM0210		EQU	$
		STA 	<CRYPSL1,X
		SEC
		SBC	<SCCV1
		SEC
		SBC	#000A8H-1
		BMI	CRM0260		; cursol limit scroll ?
;					; yes
;;;;		CMP	#08H+1
		CMP	#10H+1
		BCC	CRM0212		;8 dot scroll over ? ( no:CRM0212 )
;
		LDA	<SCCV1
		CLC
;;;;		ADC	#000A8H+08H
		ADC	#000A8H+10H
		STA 	<CRYPSL1,X
;;;;		LDA	#08H
		LDA	#10H
CRM0212		EQU	$
		CLC
		ADC	<SCCV1
		LDY	#00H
		BRA	CRM0252
;
;--------------	mouse up move -------------------
CRM0240		EQU	$
;
		M16
;
		ORA	#0FF00H
		CLC
		ADC	<CRYPSL1,X
		BPL	CRM0250
		LDA	#00
CRM0250		EQU	$
		STA 	<CRYPSL1,X
		SEC
		SBC	<SCCV1
		SEC
		SBC	#00008H
		BPL	CRM0260		; cursol limit scroll ?
;					; yes
;;;;		CMP	#0FFF8H
		CMP	#0FFF0H
		BCS	CRM02502	;8 dot scroll over ? ( no:CRM02502 )
;
		LDA	<SCCV1
		CLC
;;;;		ADC	#00008H-08H
		ADC	#00008H-10H
		STA 	<CRYPSL1,X
;;;;		LDA	#0FFF8H
		LDA	#0FFF0H
CRM02502	EQU	$
		CLC
		ADC	<SCCV1
		LDY	#02H
;
CRM0252		EQU	$
		STA	<SCCV1
		STA	<SCCV3
		STY	SCVMUK
;
CRM0260		EQU	$
;
		M8
;
CRM0280		EQU	$
CRM0400		EQU	$		; arrow OAM set
		PHB
		PHK
		PLB			; (DBR) set
;
		M16
;
		LDX	<SIFTFG
		LDA	<CRXPSL1,X
		SEC
		SBC	<SCCH1
		STA	<WORK0
		LDA	<CRYPSL1,X
		SEC
		SBC	<SCCV1
		STA	<WORK2
;
		TXA
		EOR	#00000010B
		TAX
		LDA	<CRXPSL1,X
		SEC
		SBC	<SCCH1
		STA	<WORK4
		CLC
		ADC	#010H
		CMP	#0110H
		BCC	CRM0410
		LDA	#0180H
		STA	<WORK4
CRM0410		EQU	$
		LDA	<CRYPSL1,X
		SEC
		SBC	<SCCV1
		STA	<WORK6
		CLC
		ADC	#010H
		CMP	#0100H
		BCC	CRM0420
		LDA	#0180H
		STA	<WORK4
CRM0420		EQU	$
		LDA	<CRSSMMD
		AND	#000FFH
		BNE	CRM0425
		LDA	<CRXPSL2
		STA	<XTAIHI
		LDA	<CRYPSL2
		STA	<YTAIHI
CRM0425		EQU	$
;
		M8
;
		LDX	<SIFTFG
		LDA	<WORK0
		STA 	!ARROAM		; x-pos. set
		LDA	<WORK2
		STA	!ARROAM+1	; y-pos. set
		LDA	CRATBD0,X
		STA	!ARROAM+2	; char. no. set
		LDA	#034H
		STA	!ARROAM+3	; attribute set
;
		STA	!AR1OAM+3	; attribute set
;
		LDA	#00101010B	; ( + last input data cursol ) 
		STA	!OAMSUB
;
		LDA	<DTMODE
		BEQ	CRM0440		; kotei ?
;					; no
		TXA
		EOR	#02H
		TAX
		LDA	CRATBD1,X
		STA	!AR1OAM+2	; char. no. set
		LDA	<WORK4
		STA 	!AR1OAM		; x-pos. set
		LDA	<WORK6
		STA	!AR1OAM+1	; y-pos. set
		LDA	<WORK5
		AND	#01H
		ASL	A
		ASL	A
		ORA	!OAMSUB 
		STA	!OAMSUB		; display "ON/OFF" set 
CRM0440		EQU	$
;
;
		LDX	#DISPDTE-DISPDT-1
CRD0100		EQU	$
		LDA	DISPDT,X
		STA	!XYPOAM,X
		DEX
		BPL	CRD0100
;
		LDA	<DTMODE
		BEQ	CRD0150
		LDA	<CRSSMMD
		BEQ	CRD0150
		LDX	#LOCKDT-DISPDT
		CLC
		ADC	#L_W
		STA	!XYPOAM+2,X
		LDA	#L_S
		STA	!XYPOAM+2+4,X
		LDA	#L_E
		STA	!XYPOAM+2+8,X
		LDA	#L_T
		STA	!XYPOAM+2+12,X
;
CRD0150		EQU	$
		LDX	<SIFTFG
		LDA	CRXPSL1,X
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		TAY
		LDA	PSCTDT1,Y
		STA	!XYPOAM+4*3+2	; x-pos. count set
;
		LDA	<CRYPSL1,X
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		AND	#00001111B
		TAY
		LDA	PSCTDT1,Y
		STA	!XYPOAM+4*7+2	; y-pos. count set
;
		LDA	<CRXPSH1,X
		AND	#00001111B
		TAY
		LDA	PSCTDT1,Y
		STA	!XYPOAM+4*2+2	; hi-x-pos. count set
;
		LDA	<CRYPSH1,X
		AND	#00001111B
		TAY
		LDA	PSCTDT1,Y
		STA	!XYPOAM+4*6+2	; hi-x-pos. count set
;
		LDX	<DTMODE
		BEQ	CRD0122		;kotei ? ( yes:CRD0122 )	
;
;--------------	pos wide set ----------------------------
		LDA	#C_X
		STA	SMDOAM+4*5+2
		LDA	#C_W
		STA	SMDOAM+4*6+2
		LDA	#C_Y
		STA	SMDOAM+4*7+2
		LDA	#C_W
		STA	SMDOAM+4*8+2
		LDA	#C_HI
		STA	SMDOAM+4*9+2
		STA	SMDOAM+4*12+2
;
		M16
;
		LDA	<CRXPSL1	; x-pos wide set
		AND	#0FFF0H
		STA	<WORK
		LDA	<CRXPSL2
		AND	#0FFF0H
		SEC
		SBC	<WORK
;
		M8
;
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		AND	#00001111B
		TAY
		LDA	PSCTDT1,Y
		STA	!SMDOAM+4*11+2
		XBA
		AND	#00001111B
		TAY
		LDA	PSCTDT1,Y
		STA	!SMDOAM+4*10+2
;
		M16
;
		LDA	<CRYPSL1
		AND	#0FFF0H
		STA	<WORK
		LDA	<CRYPSL2
		AND	#0FFF0H
		SEC
		SBC	<WORK
;
		M8
;
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		AND	#00001111B
		TAY
		LDA	PSCTDT1,Y
		STA	!SMDOAM+4*14+2
		XBA
		AND	#00001111B
		TAY
		LDA	PSCTDT1,Y
		STA	!SMDOAM+4*13+2
;
CRD0122		EQU	$
		LDA	STMDATB,X
		STA	!XYPOAM+4*0+3
		STA	!XYPOAM+4*1+3
		STA	!XYPOAM+4*2+3
		STA	!XYPOAM+4*3+3
		STA	!XYPOAM+4*4+3
		STA	!XYPOAM+4*5+3
		STA	!XYPOAM+4*6+3
		STA	!XYPOAM+4*7+3
		STA	!SMDOAM+4*0+3
		STA	!SMDOAM+4*1+3	; set mode attribute set
		STA	!SMDOAM+4*2+3
		STA	!SMDOAM+4*3+3
		STA	!SMDOAM+4*4+3
		STA	!SMDOAM+4*5+3
		STA	!SMDOAM+4*6+3
		STA	!SMDOAM+4*7+3
		STA	!SMDOAM+4*8+3
		STA	!SMDOAM+4*9+3
		STA	!SMDOAM+4*10+3
		STA	!SMDOAM+4*11+3
		STA	!SMDOAM+4*12+3
		STA	!SMDOAM+4*13+3
		STA	!SMDOAM+4*14+3
;
		LDA	!DTMDCH0,X	; "kote" or "kahen" chara no. set
		STA	SMDOAM+4*0+2
		LDA	!DTMDCH1,X
		STA	SMDOAM+4*1+2
;
		LDA	#00001010B
		STA	!OAMSUB+((SMDOAM-OAM)>>4)
;
		PLB			; (DBR) reset
		RTS
;
;
;
;
;
;************************************************************************
;*		Set DATA pointer & unit no. 		(DPDISP)	*
;************************************************************************
DPTDT		EQU	$
		BYTE	048H,0A8H,C_P, 032H	;"PT-"
		BYTE	050H,0A8H,C_T, 032H
		BYTE	058H,0A8H,C_HI,032H
DPTDT0		EQU	$
		BYTE	060H,0A8H,000H,032H	;PT-"XXXX"
		BYTE	068H,0A8H,000H,032H
		BYTE	070H,0A8H,000H,032H
		BYTE	078H,0A8H,000H,032H
;
		BYTE	058H,0B0H,000H,032H	;PT-XXXX
		BYTE	060H,0B0H,000H,032H	;  "XX-XX-XX-XX-XX-XX"
		BYTE	068H,0B0H,000H,032H
		BYTE	070H,0B0H,000H,032H
		BYTE	078H,0B0H,000H,032H
		BYTE	080H,0B0H,000H,032H
		BYTE	088H,0B0H,000H,032H
		BYTE	090H,0B0H,000H,032H
		BYTE	098H,0B0H,000H,032H
		BYTE	0A0H,0B0H,000H,032H
		BYTE	0A8H,0B0H,000H,032H
		BYTE	0B0H,0B0H,000H,032H
		BYTE	0B8H,0B0H,000H,032H
		BYTE	0C0H,0B0H,000H,032H
		BYTE	0C8H,0B0H,000H,032H
		BYTE	0D0H,0B0H,000H,032H
		BYTE	0D8H,0B0H,000H,032H
		BYTE	0E0H,0B0H,000H,032H
DPTDTE		EQU	$
;
DPDSCNT		EQU	DPTDTE-DPTDT-1
;
;
DPDISP		EQU	$
;
;--------------	last input data display check -------------------
		LDA	LASTFG
		BEQ	DPD0020		;last input data nothing ? ( yes:DPD0020 )
;
		LDA	<FRCNT
		AND	#018H
		BEQ	DPD0020		;display timming ? ( no:DPD0020 )
;
		M16
;
		LDA	LASTXP
		SEC
		SBC	<SCCH1
		PHA
		CLC
		ADC	#010H
		CMP	#0110H
		PLA
		BCS	DPD0010		;X pos display ? ( no:DPD0010 )
;
		STA	<WORK0		;(WK0,1) <-- display X pos
		LDA	LASTYP
		CLC
		SBC	<SCCV1
		PHA
		CLC
		ADC	#010H
		CMP	#0100H
		PLA
;
		M8
;
		BCS	DPD0020		;Y pos display ? ( no:DPD0020 )
;
		STA	LASOAM+1	;OAM Y pos set
		LDA	<WORK0
		STA	LASOAM		; "  X    "
		LDA	#0AEH
		STA	LASOAM+2	; "  chara no. set
		LDA	#030H
		STA	LASOAM+3	; "  att set
		LDA	<WORK1
		AND	#01H
		ASL	A
		ASL	A
		ASL	A
		ASL	A
		ORA	OAMSUB
		STA	OAMSUB		;OAM sub set
		BRA	DPD0020
;
;----------------------------------------------------------------
;
DPD0010		EQU	$
;
		M8
;
DPD0020		EQU	$
		LDX	#DPTDTE-DPTDT-1
DPD0100		EQU	$
		LDA	>DPTDT,X
		STA	!PTDOAM,X
		DEX
		BPL	DPD0100		;
;					;
		JSR	SDPTCAL		; set data pointer calc
;
		M16
;
		LDA	<DTPT
DPD0300		EQU	$
;
		M8
;
		PHA			; (A) push
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		TAX
		LDA	>PSCTDT1,X
		STA	!PTDOAM+(DPTDT0-DPTDT+2)+4*2
		PLA			; (A) pull
		AND	#00001111B
		TAX
		LDA	>PSCTDT1,X
		STA	!PTDOAM+(DPTDT0-DPTDT+2)+4*3 ; point no. set
;
		XBA
		PHA			; (A) push
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		TAX
		LDA	>PSCTDT1,X
		STA	!PTDOAM+(DPTDT0-DPTDT+2)
		PLA			; (A) pull
		AND	#00001111B
		TAX
		LDA	>PSCTDT1,X
		STA	!PTDOAM+(DPTDT0-DPTDT+2)+4 ; point no. set
		RTS
;
;
;
;
;------------------------------------------------------------------------
;-		set data pointer calc			(SDPTCAL)	-
;-		[out]	(X)	--->	set pointer			-
;------------------------------------------------------------------------
SDPTCAL		EQU	$
;
		MI16
;
		STZ	<DTPT
		LDX	#00000H
SDPTC20		EQU	$
		LDY	#04		;(Y) <-- number of data byte ( kotei )
		LDA	>DTBUFF,X
		AND	#00FFH
		BEQ	SDPTC30		;kotei data ? ( yes:SDPTC30 )
;
		CMP	#00FFH
		BEQ	SDPTC40		;end code ? ( yes:SDPTC40 )
;
		PHX			;(X) save
		TAX
		LDA	>KAHNSB,X
		PLX			;(X) load
		AND	#003FH
		TAY
		LDA	!KAHNNO,Y
		AND	#00FFH
		TAY
SDPTC30		EQU	$
		STY	<WORK
		TXA
		CLC
		ADC	<WORK
		TAX
		INC	<DTPT
		BRA	SDPTC20
;
SDPTC40		EQU	$
		STX	<STDTPT		; (STDTPT) <-- next set pointer
;
		MI8
;
		RTS
;
;
;
;
;
;
;
;
;
;
;************************************************************************
;*		Mode Select				(MODESL)	*
;************************************************************************
MDNDT		EQU	$
		BYTE	0C8H,010H,080H,038H	; NORMAL
		BYTE	0D0H,010H,081H,038H
		BYTE	0D8H,010H,082H,038H
		BYTE	0E0H,010H,083H,038H
		BYTE	0E8H,010H,084H,038H
		BYTE	0F0H,010H,085H,038H
;
		BYTE	0C8H,018H,090H,038H	; INSERT
		BYTE	0D0H,018H,091H,038H
		BYTE	0D8H,018H,092H,038H
		BYTE	0E0H,018H,093H,038H
		BYTE	0E8H,018H,094H,038H
		BYTE	0F0H,018H,095H,038H
;
		BYTE	0C8H,020H,0A0H,038H	; S-DEL
		BYTE	0D0H,020H,0A1H,038H
		BYTE	0D8H,020H,0A2H,038H
		BYTE	0E0H,020H,0A3H,038H
		BYTE	0E8H,020H,0A4H,038H
		BYTE	0F0H,020H,0A5H,038H
;
		BYTE	0C8H,028H,0B0H,038H	; DELETE
		BYTE	0D0H,028H,0B1H,038H
		BYTE	0D8H,028H,0B2H,038H
		BYTE	0E0H,028H,0B3H,038H
		BYTE	0E8H,028H,0B4H,038H
		BYTE	0F0H,028H,0B5H,038H
;
		BYTE	0C8H,030H,0C0H,038H	; SEARCH
		BYTE	0D0H,030H,0C1H,038H
		BYTE	0D8H,030H,0C2H,038H
		BYTE	0E0H,030H,0C3H,038H
		BYTE	0E8H,030H,0C4H,038H
		BYTE	0F0H,030H,0C5H,038H
;
		BYTE	0C8H,038H,0A5H,038H	; B-CHNG
		BYTE	0D0H,038H,0A5H,038H
		BYTE	0D8H,038H,0A5H,038H
		BYTE	0E0H,038H,0A5H,038H
		BYTE	0E8H,038H,0A5H,038H
		BYTE	0F0H,038H,0A5H,038H
;
;;;;		BYTE	0C8H,038H,0D0H,038H	; B-CHNG
;;;;		BYTE	0D0H,038H,0D1H,038H
;;;;		BYTE	0D8H,038H,0D2H,038H
;;;;		BYTE	0E0H,038H,0D3H,038H
;;;;		BYTE	0E8H,038H,0D4H,038H
;;;;		BYTE	0F0H,038H,0D5H,038H
MDNDTE		EQU	$
;
MDNDTCT		EQU	MDNDTE-MDNDT-2
;
MDDTPT		EQU	$
		BYTE	006H*0,006H*1,006H*2,006H*3,006H*4,006H*5
;
MDATPT		EQU	$
		BYTE	(004H*6)*0+3
		BYTE	(004H*6)*1+3
		BYTE	(004H*6)*2+3
		BYTE	(004H*6)*3+3
		BYTE	(004H*6)*4+3
		BYTE	(004H*6)*5+3
;
;
;
MODESL		EQU	$
;
		MI16
;
		STZ	!OAMSUB
		STZ	!OAMSUB+((CHCOAM-OAM)>>4)
		STZ	!OAMSUB+((SMDOAM-OAM)>>4)
;
		LDX	#MDNDTE-MDNDT-2
MDN0100		EQU	$
		LDA	>MDNDT,X
		STA	!OAM,X
		DEX
		DEX
		BPL	MDN0100		; set end ?
;					; yes
		MI8
;
		LDA	<INKEY
		CMP	#MOD
		BEQ	MDN0110		;return ? ( yes:MDN0110 )
		CMP	#RTN
		BEQ	MDN0110		;    	    "
		LDA	<MOUSEBT
		AND	#11000000B
		BEQ	MDN0400		;    "    ( no:MDN0400 )
;
MDN0110		EQU	$
		LDA	<EDMODE
		CMP	#search
		BNE	MDN0140		; SEARCH ?
;					; yes
		LDA	#0FFH
		STA	<SRCHPT
		STA	<SRCHPT+1
MDN0140		EQU	$
		LDA	#PLMD
		STA	<GMMODE
		JSL 	>OAMCLR
		RTL
;
MDN0400		EQU	$
		LDA	<INKEY2
		CMP	#DWN
		BNE	MDS0600		; down key ?
;					; yes
		LDA	<EDMODE
		INC	A
;;;;		CMP	#006H
		CMP	#005H
		BNE	MDS0640		; limit ?
;					; yes
		LDA	#000H
		BRA	MDS0640
;
MDS0600		EQU	$
		LDA	<INKEY2
		CMP	#UPP
		BNE	MDS0800		; up key ?
;					; yes
		LDA	<EDMODE
		DEC	A
		BPL	MDS0640		; limit ?
;					; yes
;;;;		LDA	#005H
		LDA	#004H
MDS0640		EQU	$
		STA	<EDMODE
;
		ASL	A
		INC	A		;[ +08H ]
		ASL	A
		ASL	A
		ASL	A
		STA	<MOUSWK0	;mouse menu pos set
;
MDS0800		EQU	$
		LDA	<MOUSEBY
		BEQ	MDS0830		;mouse move ? ( no:MDS0830 )
;
		CLC
		ADC	<MOUSWK0
		BPL	MDS0810
		LDA	#00
MDS0810		EQU	$
		CMP	#05H*10H
		BCC	MDS0820
		LDA	#05H*10H-1
MDS0820		EQU	$
		STA	<MOUSWK0
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		STA	<EDMODE
;
MDS0830		EQU	$
		LDX	<EDMODE
		LDA	>MDATPT,X
		TAX
		LDY	#05H
		LDA	#034H
MDS0900		EQU	$
		STA	OAM,X
		INX
		INX
		INX
		INX
		DEY
		BPL	MDS0900
;
		RTL
;
;
;
;
;
;************************************************************************
;*		Error display				(ERROR)		*
;************************************************************************
ERDSDT		EQU	$
		BYTE	0CCH,040H,C_E,030H
		BYTE	0D4H,040H,C_R,030H
		BYTE	0DCH,040H,C_R,030H
		BYTE	0E4H,040H,C_O,030H
		BYTE	0ECH,040H,C_R,030H
ERDSDTE		EQU	$
;
ESCNT		EQU	ERDSDTE-ERDSDT-1
EROMPOS		EQU	0B0H		
;
;
ERROR		EQU	$
		LDY	#EROMPOS+ESCNT
		LDX	#ESCNT
ERD0100		EQU	$
		LDA	>ERDSDT,X
		STA	OAM,Y
		DEY
		DEX
		BPL	ERD0100
;	
		LDA	<FRCNT
		AND	#08H
		BNE	ERD0300
;
		LDY	#EROMPOS+003H
		LDX	#04H
		LDA	#039H
ERD0200		EQU	$
		STA	OAM,Y
		INY
		INY
		INY
		INY
		DEX
		BPL	ERD0200
;
ERD0300		EQU	$
		DEC	ERRFLG
		BPL	ERD0500
;
		LDA	#PLMD
		STA	<GMMODE
		STZ	<ERRFLG
ERD0500		EQU	$
		RTL
;
;
;
;
;************************************************************************
;*		Window set				(WNDWST)	*
;************************************************************************
TLW1DT		EQU	$
		BYTE	00H+00CH
		BYTE	0FFH,000H
		BYTE	00H+038H
		BYTE	0C4H,0FBH
		BYTE	00H+062H
		BYTE	0FFH,000H
		BYTE	00H+028H
		BYTE	017H,0E9H
		BYTE	00H+01H
		BYTE	0FFH,000H
		BYTE	00H
;
TLHDPR		EQU	$
		BYTE	00000001B
		BYTE	26H
		LWORD	TLW1DT
;
;
WNDWST		EQU	$
		LDX	#004H
WDWST020	EQU	$
		LDA	>TLHDPR,X
		STA	4370H,X
		DEX
		BPL	WDWST020
;
		LDA	#00000000B
		STA	<WIND23		; window mask BG1.BG2 set
		LDA	#00000010B
		STA	<WIND24		;             BG4.Bg3
		LDA	#00100000B
		STA	<WIND25		;             COL,OBJ
		LDA	#00000100B
		STA	<WMANSL
		LDA	#00000000B
		STA	<WSUBSL
		LDA	#00010000B
		STA	<WIND30
		LDA	#01100011B
		STA	<SUBADF
		STZ	212AH
		STZ	212BH
;
		LDA	#00010101B
		STA	<MANSEL
		LDA	#00000000B
		STA	<SUBSEL		; gamen disp. swich set
;
		LDA	#10000000B
		STA	<HD420C		; H-DMA ch"ON"
		RTL
;
;********************************************************
;*		unit buffer set initial set		*
;********************************************************
UNITST0		EQU	$
		JSL	>UNITST		; unit buffer set
;
REDISP		EQU	$
;
		M16
;
		LDA	<SCCH1		;start scrool counter set 
		SEC
		SBC	#0010H+0110H+0010H
		STA	<WRSCH1
		LDA	<SCCV1
		STA	<WRSCV1
;
		M8
;
		LDA	#16+4		;loop counter set
		STA	<BGDPFG
		LDA	#BGDS		;BG display mode set	
		STA	<GMMODE
		RTL
;
;
;********************************************************
;*							*
;*	mouse auto scroll initial set			*
;*							*
;********************************************************
MSSCINT		EQU	$
		LDA	#MSSC
		STA	<GMMODE
		STZ	!WIDEX
		STZ	!WIDEY
		LDX	<SIFTFG
		LDA	#080H
		STA	<CRXPSL1,X
		LDA	#060H
		STA	<CRYPSL1,X
		M16			; memory 16bit mode
		LDA	<CRXPSL1,X
		STA	<MSSCRX
		LDA	<CRYPSL1,X
		STA	<MSSCRY
		M8			; memory 8bit mode
;
		PLA
		PLA
		RTL
;
;
;********************************************************
;*							*
;*	mouse auto scroll mode				*
;*							*
;********************************************************
MSSCRMD		EQU	$
		LDX	<SIFTFG
		LDA	<MOUSEBT
		AND	#10000000B	; mouse right ON ?
		BEQ	MSSCR00
		LDA	#PLMD
		STA	<GMMODE
		M16			; memory 16bit mode
		LDA	<SCCH1
		CLC
		ADC	#00088H
		STA	<CRXPSL1,X
		STA	<MSSCRX
		LDA	<SCCV1
		CLC
		ADC	#00068H
		STA	<CRYPSL1,X
		STA	<MSSCRY
		M8			; memory 8bit mode
		JMP	MSSCR99
;
MSSCR00		EQU	$
		LDA	<CRXPSL1,X
		CLC
		ADC	<MOUSEBX
		CMP	#040H		; X limit check
		BCC	MSSCR05
		CMP	#0C0H
		BCC	MSSCR10
		LDA	#0C0H
		BRA	MSSCR10
MSSCR05		EQU	$
		LDA	#040H
MSSCR10		EQU	$
		STA	<CRXPSL1,X
		STA	!OAM
		LDA	<MSSCRX
		STA	!OAM+4
;
		LDA	<CRYPSL1,X
		CLC
		ADC	<MOUSEBY
		CMP	#020H		; Y limit check
		BCC	MSSCR15
		CMP	#0A0H
		BCC	MSSCR20
		LDA	#0A0H
		BRA	MSSCR20
MSSCR15		EQU	$
		LDA	#020H
MSSCR20		EQU	$
		STA	<CRYPSL1,X
		STA	!OAM+1
		LDA	<MSSCRY
		STA	!OAM+5
		LDA	#034H
		STA	!OAM+3
		STA	!OAM+7
		LDA	>CSLDAT,X
		STA	!OAM+2		; move cursol char. set
		LDA	#08CH
		STA	!OAM+6		; senter cursol char. set
;
		LDA	#02AH
		STA	!OAMSUB
;
		LDA	<CRXPSL1,X	; X wide
		CMP	#078H		;     scroll stop limit check
		BCC	MSSCR29
		CMP	#088H
		BCS	MSSCR29
		JMP	MSSCR50
;
MSSCR29		EQU	$
		STZ	<WORK2
		STZ	<WORK3
		STZ	<WORK4
		STZ	<SCHMUK
		LDA	<CRXPSL1,X	; X point
		SEC
		SBC	<MSSCRX
		BPL	MSSCR30
		EOR	#0FFH
		INC	A
		INC	<WORK3
		LDY	#002H
		STY	<SCHMUK
MSSCR30		EQU	$
		JSR	MSSCRSP		; mouse scroll speed
		CLC
		ADC	<WIDEX
		STA	<WIDEX
		BCC	MSSCR33
		INC	<WORK1
MSSCR33		EQU	$
		M16			; memory 16bit mode
		LDA	<WORK3
		BEQ	MSSCR35
		LDA	<WORK0
		EOR	#0FFFFH
		INC	A
		STA	<WORK0
		LDA	#0FFFFH
		STA	<WORK2
MSSCR35		EQU	$
		LDA	<SCCH1		; H scroll point set
		CLC
		ADC	<WORK1
		STA	<SCCH1
		STA	<SCCH2
		STA	<SCCH3
		LDA	<WORK1
		BEQ	MSSCR39
		LDA	<SCCH1
		CLC
		ADC	#00008H
		BPL	MSSCR38
		LDA	#0FFF8H
		BRA	MSSCR385
MSSCR38		EQU	$
		CMP	#00F11H
		BCC	MSSCR39
		LDA	#00F08H
MSSCR385	EQU	$
		STA	<SCCH1
		STA	<SCCH2
		STA	<SCCH3
MSSCR39		EQU	$
		M8			; memory 8bit mode
;
MSSCR50		EQU	$		; Y wide
		LDA	<CRYPSL1,X	;     scroll stop limit check
		CMP	#058H
		BCC	MSSCR59
		CMP	#068H
		BCS	MSSCR59
		JMP	MSSCR90
;
MSSCR59		EQU	$
		STZ	<WORK2
		STZ	<WORK3
		STZ	<WORK4
		STZ	<SCVMUK
		LDA	<CRYPSL1,X	; Y point
		SEC
		SBC	<MSSCRY
		BPL	MSSCR40
		EOR	#0FFH
		INC	A
		INC	<WORK3
		LDY	#002H
		STY	<SCVMUK
MSSCR40		EQU	$
		JSR	MSSCRSP		; mouse scroll speed
		CLC
		ADC	<WIDEY
		STA	<WIDEY
		BCC	MSSCR43
		INC	<WORK1
MSSCR43		EQU	$
		M16			; memory 16bit mode
		LDA	<WORK3
		BEQ	MSSCR45
		LDA	<WORK0
		EOR	#0FFFFH
		INC	A
		STA	<WORK0
		LDA	#0FFFFH
		STA	<WORK2
MSSCR45		EQU	$
		LDA	<SCCV1		; V scroll point set
		CLC
		ADC	<WORK1
		STA	<SCCV1
		STA	<SCCV2
		STA	<SCCV3
		LDA	<WORK1
		BEQ	MSSCR49
		LDA	<SCCV1
		CLC
		ADC	#00008H
		BPL	MSSCR48
		LDA	#0FFF8H
		BRA	MSSCR485
MSSCR48		EQU	$
		CMP	#00761H
		BCC	MSSCR49
		LDA	#00758H
MSSCR485	EQU	$
		STA	<SCCV1
		STA	<SCCV2
		STA	<SCCV3
MSSCR49		EQU	$
		M8			; memory 8bit mode
;
MSSCR90		EQU	$
		JSL	>BGSET
;
MSSCR99		EQU	$
		RTL
;
;
;-------------------------------------- mouse scroll speed
MSSCRSP		EQU	$
		M16			; memory 16bit mode
		AND	#000FFH
		ASL	A
		ASL	A
		ASL	A
		ASL	A
		STA	<WORK0
		M8			; memory 8bit mode
		LDA	<WORK0
		RTS
;
;
CSLDAT		EQU	$
		BYTE	088H,000H,086H
;
;
;
;
;
;
;
		END
