;
;
;****************************************************************
;*								*
;*	title name  ; yossy enmy data set			*
;*	proccess    ; enmy edit proccess			*
;*	file name   ; yst_en_edit				*
;*								*
;****************************************************************
;
;
		SALL
;
		include	yst_header.inc
;
		XALL
;
;
;---------------------------------------------------------------
;
;		Supar_Y enmy-edit-tool
;
;---------------------------------------------------------------
;
		ORG	058000H
;
;=============================================== yst_en_edit ===
		GLB	ENPLAY,PLDWNMN
		GLB	MSTEST
;
;=============================================== yst_init ======
		EXT	BGSET,ERR0,GAME
		EXT	ENPLMD,ENMDSL,ENFILE
		EXT	MSTST
;
;=============================================== yst_edit ======
		EXT	MSSC,UPSL,DWSL,LFSL,RISL
		EXT	PSCTDT1
		EXT	ENBGMV
		EXT	MSSCRMD
;
;===============================================================
;
		EXTEND
		MEM8
		IDX8
;
;
;****************************************************************
;*								*
;*	enmy data set editer					*
;*								*
;****************************************************************
ENPLAY		EQU	$
		STZ	<ENMDOBJ
		LDA	<MOUSEBT
		AND	#10000000B	; mouse right ON ?
		BEQ	ENPL000		;	NO -> ENPL000
		STZ	<PLDWFG
		STZ	<MOUSWK0
		STZ	<ENDELFG
		STZ	<ENDSPFG
		M16			; memory 16bit mode
		STZ	!SRCPOS
		LDA	#00000H
		STA	>ENMYDTBF
		M8			; memory 8bit mode
		LDA	#ENMDSL
		STA	<GMMODE
		JMP	ENPL999		; goto RTL
ENPL000		EQU	$
		LDA	<INKEY
		CMP	#L_Z		; inkey [Z] ON ?
		BNE	ENPL00		;	NO -> ENPL00
		JSR	ENSCINT		; mouse auto scroll initial set
		JMP	ENPL999
;
ENPL00		EQU	$
		LDA	<INKEY3
		CMP	#UPS		; up scroll ?
		BEQ	ENPL005		;	YES -> ENPL005
		CMP	#L_O		;	NO  -> ENPL10
		BNE	ENPL10
ENPL005		EQU	$
		LDX	#UPSL
		JSR	UPSCRCK		; up scroll check
		JMP	ENPL999		; goto RTL
;
ENPL10		EQU	$
		CMP	#DWS		; down scroll ?
		BEQ	ENPL105		;	YES -> ENPL105
		CMP	#L_c		;	NO  -> ENPL20
		BNE	ENPL20
ENPL105		EQU	$
		LDX	#DWSL
		JSR	DWNSCRCK	; down scroll check
		JMP	ENPL999		; goto RTL
;
ENPL20		EQU	$
		CMP	#LFS		; left scroll ?
		BEQ	ENPL205		;	YES -> ENPL205
		CMP	#L_K		;	NO  -> ENPL30
		BNE	ENPL30
ENPL205		EQU	$
		LDX	#LFSL
		JSR	LFSCRCK		; left scroll check
		JMP	ENPL999		; goto RTL
;
ENPL30		EQU	$
		CMP	#RIS		; right scroll ?
		BEQ	ENPL305		;	YES -> ENPL305
		CMP	#L_L		;	NO  -> ENPL40
		BNE	ENPL40
ENPL305		EQU	$
		LDX	#RISL
		JSR	RTSCRCK		; right scroll check
		JMP	ENPL999
;
ENPL40		EQU	$
		LDA	<INKEY
		CMP	#F_2		; [F2] ON ?
		BNE	ENPL50		;	NO -> ENPL50
		LDA	#ENFILE
		STA	<GMMODE
		JMP	ENPL999
;
ENPL50		EQU	$
		CMP	#RTN		; push return key ?
		BNE	ENPL60		;	NO -> ENPL60
		CMP	!ENINKYBF
		BEQ	ENPL60
		STA	!ENINKYBF
		JSR	ENUND		; undo mode (push return key)
		JMP	ENPL999
;
ENPL60		EQU	$
		CMP	#F_0		; [F10] ON ?
		BNE	ENPL70		;	NO -> ENPL70
		LDA	#GAME
		STA	<GMMODE
		JMP	ENPL999
;
ENPL70		EQU	$
		CMP	#L_P		; [P] ON ?
		BNE	ENPL80		;	NO -> ENPL80
		JSR	ENSCINT		; mouse auto scroll initial set
		LDA	#MSTST
		STA	<GMMODE
		JMP	ENPL999
;
ENPL80		EQU	$
		PHB
		PHK
		PLB
		LDA	<PLDWFG
		ASL	A
		TAX
		JSR	(MDJSRSB,X)
		PLB
;
		LDA	<INKEY
		STA	!ENINKYBF
		JSL	>ENBGMV		; BG. move
		JSR	MSMVST		; mouse cursol move
		JSR	ENDTSCR		; enmy edit data screen set
		JSL	>BGSET		; BG. set
;
ENPL999		EQU	$
		RTL
;
;
MDJSRSB		EQU	$
		WORD	ENEDT		; edit
		WORD	ENUND		; undo
		WORD	ENMOV		; move
		WORD	ENDEL		; delete
		WORD	ENREN		; rename
		WORD	ENSRC		; search
;
;
;****************************************************************
;*								*
;*	right scroll check					*
;*								*
;****************************************************************
RTSCRCK		EQU	$
		STZ	!SCHMUK
		M16			; memory 16bit mode
		LDA	<SCCH1
		CMP	#00F08H		; scroll OK ?
		BEQ	LFCK009		;	NO -> LFCK009
		CLC
		ADC	#00100H
		CMP	#00F08H+1	; limit over ?
		BCC	LFCK005		;	NO -> LFCK005
		LDA	#00F08H
		BRA	LFCK005
		M8			; memory 8bit mode
		RTS
;
;
;****************************************************************
;*								*
;*	left scroll check					*
;*								*
;****************************************************************
LFSCRCK		EQU	$
		LDA	#002H
		STA	!SCHMUK
		M16			; memory 16bit mode
		LDA	<SCCH1
		CMP	#0FFF8H		; scroll OK ?
		BEQ	LFCK009		;	NO -> LFCK009
		SEC
		SBC	#00100H
		CMP	#0FFF8H		; limit over ?
		BPL	LFCK005		;	NO -> LFCK005
		LDA	#0FFF8H
LFCK005		EQU	$
		STA	<MVSCH1
		STX	<GMMODE
LFCK009		EQU	$
		M8			; memory 8bit mode
		RTS
;
;
;****************************************************************
;*								*
;*	down scroll check					*
;*								*
;****************************************************************
DWNSCRCK	EQU	$
		STZ	!SCVMUK
		M16			; memory 16bit mode
		LDA	<SCCV1
		CMP	#00758H		; scroll OK ?
		BEQ	UPCK009		;	NO -> UPCK009
		CLC
		ADC	#00100H
		CMP	#00758H+1	; limit over ?
		BCC	UPCK005		;	NO -> UPCK005
		LDA	#00758H
		BRA	UPCK005
		M8			; memory 8bit mode
;
;
;****************************************************************
;*								*
;*	up scroll check						*
;*								*
;****************************************************************
UPSCRCK		EQU	$
		LDA	#002H
		STA	!SCVMUK
		M16			; memory 16bit mode
		LDA	<SCCV1
		CMP	#0FFF8H		; scroll OK ?
		BEQ	UPCK009		;	NO -> UPCK009
		SEC
		SBC	#00100H
		CMP	#0FFF8H		; limit over ?
		BPL	UPCK005		;	NO -> UPCK005
		LDA	#0FFF8H
UPCK005		EQU	$
		STA	<MVSCV1
		STX	<GMMODE
UPCK009		EQU	$
		M8			; memory 8bit mode
		RTS
;
;
;****************************************************************
;*								*
;*	mouse auto scroll initial set				*
;*								*
;****************************************************************
ENSCINT		EQU	$
		LDA	#MSSC
		STA	<GMMODE
		STZ	!WIDEX
		STZ	!WIDEY
		LDX	<SIFTFG
		LDA	#080H
		STA	<CRXPSL1,X
		LDA	#060H
		STA	<CRYPSL1,X
		M16			; memory 16bit mode
		LDA	<CRXPSL1,X
		STA	<MSSCRX
		LDA	<CRYPSL1,X
		STA	<MSSCRY
		M8			; memory 8bit mode
;
		RTS
;
;;K;;		PLA
;;K;;		PLA
;;K;;		RTL
;
;
;****************************************************************
;*								*
;*	enmy edit mouse move set				*
;*								*
;****************************************************************
MSMVST		EQU	$
;-------------- mouse pos check --------------
		LDA	<MOUSEBX	; mouse X move ?
		BEQ	MSMV100		;	NO -> MSMV100
		BMI	MSMV050		; X<0 move ?
;					; 	YES -> MSMV050
;-------------- mouse right move --------------
		M16			; memory 16bit mode
		AND	#0007FH
		STA	<WORK0
;
		CLC
		ADC	<CRXPSL1
		CMP	#01000H		;  right scroll limit ?
		BCC	MSMV010		;	NO -> MSMV010
		LDA	#00FFFH
MSMV010		EQU	$
		STA	<CRXPSL1
		SEC
		SBC	<SCCH1
		SEC
		SBC	#000F8H-1	; 1 disp limit ?
		BMI	MSMV080		;	NO -> MSMV080
;
		CMP	#010H+1		; 8 dot over ?
		BCC	MSMV012		;	NO -> CRM0112
;
		LDA	<SCCH1
		CLC
		ADC	#000F8H+10H
		STA	<CRXPSL1
		LDA	#10H
MSMV012		EQU	$
		CLC
		ADC	<SCCH1
		LDY	#000H
		BRA	MSMV070
;
;-------------- mouse left move -----------------
MSMV050		EQU	$
		M16			; memory 16bit mode
		ORA	#0FF00H
		STA	<WORK0
;
		CLC
		ADC	<CRXPSL1	; left scroll limit ?
		BPL	MSMV060		;	NO -> MSMV060
		LDA	#00000H
MSMV060		EQU	$
		STA	<CRXPSL1
		SEC
		SBC	<SCCH1
		SEC
		SBC	#00008H		; 1 disp limit ?
		BPL	MSMV080		;	NO -> MSMV080
;
		CMP	#0FFF0H		; 8 dot over ?
		BCS	MSMV065		;	NO -> MSMV065
;
		LDA	<SCCH1
		CLC
		ADC	#00008H-10H
		STA	<CRXPSL1
		LDA	#0FFF0H
MSMV065		EQU	$
		CLC
		ADC	<SCCH1
		LDY	#002H
;
MSMV070		EQU	$
		STA	<SCCH1
		STA	<SCCH2
		STA	<SCCH3
		STY	<SCHMUK
;
MSMV080		EQU	$
		M8			; memory 8bit mode
;
MSMV100		EQU	$
		LDA	<MOUSEBY	; mouse Y move ?
		BEQ	MSMV200		;	NO -> MSMV200
		BMI	MSMV150		; down move ?
;					;	NO -> MSMV150
;-------------- mouse down move -----------------
		M16			; memory 16bit mode
		AND	#0007FH
;
		CLC
		ADC	<CRYPSL1
		CMP	#00800H		; down scroll limit ?
		BCC	MSMV110		;	NO -> MSMV110
		LDA	#007FFH
MSMV110		EQU	$
		STA	<CRYPSL1
		SEC
		SBC	<SCCV1
		SEC
		SBC	#000A8H-1	; 1 disp limit ?
		BMI	MSMV180		;	NO -> MSMV180
;
		CMP	#10H+1		; 8 dot over ?
		BCC	MSMV115		;	NO -> MSMV115
;
		LDA	<SCCV1
		CLC
		ADC	#000A8H+10H
		STA	<CRYPSL1
		LDA	#010H
MSMV115		EQU	$
		CLC
		ADC	<SCCV1
		LDY	#000H
		BRA	MSMV170
;
;-------------- mouse up move -------------------
MSMV150		EQU	$
		M16			; memory 16bit mode
		ORA	#0FF00H
		CLC
		ADC	<CRYPSL1	; up scroll limit ?
		BPL	MSMV155		;	NO -> MSMV155
		LDA	#00000H
MSMV155		EQU	$
		STA	<CRYPSL1
		SEC
		SBC	<SCCV1
		SEC
		SBC	#00008H		; 1 disp limit ?
		BPL	MSMV180		;	NO -> MSMV180
;
		CMP	#0FFF0H		; 8 dot over ?
		BCS	MSMV1555	;	NO -> MSMV1555
;
		LDA	<SCCV1
		CLC
		ADC	#00008H-10H
		STA	<CRYPSL1
		LDA	#0FFF0H
MSMV1555	EQU	$
		CLC
		ADC	<SCCV1
		LDY	#002H
;
MSMV170		EQU	$
		STA	<SCCV1
		STA	<SCCV2
		STA	<SCCV3
		STY	<SCVMUK
;
MSMV180		EQU	$
		M8			; memory 8bit mode
;
MSMV200		EQU	$
		M16
;
		LDA	<CRXPSL1
		SEC
		SBC	<SCCH1
		STA	<WORK0
		LDA	<CRYPSL1
		SEC
		SBC	<SCCV1
		STA	<WORK2
;
		M8
;
		LDA	<WORK0
		STA 	!ARROAM		; x-pos. set
		LDA	<WORK2
		STA	!ARROAM+1	; y-pos. set
		LDA	#088H
		STA	!ARROAM+2	; char. no. set
		LDA	#034H
		STA	!ARROAM+3	; attribute set
;
		LDA	#00001010B	; ( + last input data cursol ) 
		STA	!OAMSUB
;
;------------- mode obj set  --------------------
		LDA	<ENMDOBJ
		BEQ	MSMV250
;
		DEC	A
		DEC	A
		STA	!OAM+6
		LDA	#033H
		STA	!OAM+7
		LDA	<XTAIHI
		SEC
		SBC	<SCCH1
		STA	!OAM+4
		LDA	<YTAIHI
		SEC
		SBC	<SCCV1
		STA	!OAM+5
;
MSMV250		EQU	$
;
;------------- keyboard input -------------------
		LDA	<INKEY
		CMP	#030H
		BCC	MSMV320
		CMP	#03AH
		BCC	MSMV300
		CMP	#041H
		BCC	MSMV320
		CMP	#047H
		BCS	MSMV320
;
MSMV300		EQU	$		; enmy NO. ram set
		SEC
		SBC	#030H
		TAX
		JSR	ENNOWKST	; enmy NO. work set
;
		LDA	!ENNOFLS
		LSR	A
		LSR	A
		TAY
		LDA	>ENNODT,X
;;K;;		TYX
;;K;;		BNE	MSMV310
;;K;;		CMP	#002H
;;K;;		BCS	MSMV390
MSMV310		EQU	$
		STA	!WORK0,Y
		LDA	!ENNOFLS
		CLC
		ADC	#004H
		AND	#00FH
		STA	!ENNOFLS
		CMP	#009H
		BCC	MSMV390
		STZ	!ENNOFLS
		JMP	MSMV390
;
MSMV320		EQU	$
		CMP	#L_H		; 10 point dec.
		BEQ	MSMV330		;	YES -> MSMV330
		CMP	#L_J		; 1 point dec.
		BEQ	MSMV340		;	YES -> MSMV340
		CMP	#L_M		; 1 point inc.
		BEQ	MSMV350		;	YES -> MSMV350
		CMP	#L_N		; 10 point inc.
		BNE	MSMV400		;	NO  -> MSMV400
;
		JSR	ENNOWKST	; enmy NO. work set
		LDA	<WORK1
		INC	A
		AND	#00FH
		STA	<WORK1
		BNE	MSMV325
		INC	<WORK0
;;K;;		LDA	<WORK0
;;K;;		EOR	#001H
;;K;;		STA	<WORK0
MSMV325		EQU	$
		BRA	MSMV390
;
MSMV330		EQU	$		; 10 point dec.
		JSR	ENNOWKST	; enmy NO. work set
		LDA	<WORK1
		DEC	A
		AND	#00FH
		STA	<WORK1
		CMP	#00FH
		BNE	MSMV335
		DEC	<WORK0
;;K;;		LDA	<WORK0
;;K;;		EOR	#001H
;;K;;		STA	<WORK0
MSMV335		EQU	$
		BRA	MSMV390
;
MSMV340		EQU	$		; 1 point dec.
		JSR	ENNOWKST	; enmy NO. work set
		LDA	<WORK2
		DEC	A
		AND	#00FH
		STA	<WORK2
		BRA	MSMV390
;
MSMV350		EQU	$		; 1 point inc.
		JSR	ENNOWKST	; enmy NO. work set
		LDA	<WORK2
		INC	A
		AND	#00FH
		STA	<WORK2
;
MSMV390		EQU	$
		LDA	<WORK1
		ASL	A
		ASL	A
		ASL	A
		ASL	A
		ORA	<WORK2
		STA	!ENMYNO
		LDA	<WORK0
;;K;;		AND	#00FH
		STA	!ENMYNO+1
;
		M16			; memory 16bit mode
		LDA	!ENMYNO
		BMI	MSMV393
		CMP	!ENNAMCT
		BCC	MSMV398
		STZ	!ENMYNO
		BRA	MSMV398
MSMV393		EQU	$
		LDA	!ENNAMCT
		DEC	A
		STA	!ENMYNO
MSMV398		EQU	$
		M8			; memory 8bit mode
;
MSMV400		EQU	$
		RTS
;
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+						+
;+	enmy NO. work set			+
;+				work0 <- high	+
;+				    1 <- mid	+
;+				    2 <- low	+
;++++++++++++++++++++++++++++++++++++++++++++++++
ENNOWKST	EQU	$
		LDA	!ENMYNO		; enmy NO. low set
		AND	#00FH
		STA	<WORK2
		LDA	!ENMYNO		; enmy NO. mid set
		AND	#0F0H
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		STA	<WORK1
		LDA	!ENMYNO+1	; enmy NO. high set
		AND	#00FH
		STA	<WORK0
		RTS
;
;
ENNODT		EQU	$
		BYTE	000H,001H,002H,003H,004H,005H,006H,007H
		BYTE	008H,009H,000H,000H,000H,000H,000H,000H
		BYTE	000H,00AH,00BH,00CH,00DH,00EH,00FH
;
ENOBJ		EQU	$
		BYTE	000H,002H,004H
;
;
;****************************************************************
;*								*
;*	enmy edit data screen set				*
;*								*
;****************************************************************
ENDTSCR		EQU	$
		PHB
		PHK
		PLB
		MI16			; memory , index 16bit mode
		LDX	#00000H
ENDTLOP		EQU	$		; disp set
		LDA	ENSCRD0,X
		STA	!OAM+100H,X
		INX
		INX
		CPX	#ENSCRD5-ENSCRD0
		BNE	ENDTLOP
		STX	<WORK0
		MI8			; memory , index 8bit mode
;
;--------------------------------------- put count set
		M16			; memory 16bit mode
		LDA	!ENDTPT
		BEQ	ENDT200
		M8			; memory 8bit mode
		AND	#00FH
		TAX
		LDA	<ENDSPFG
		BEQ	ENDT110
		M16			; memory 16bit mode
		LDA	>ENMYDTBF
		STA	<WORKA
		M8			; memory 8bit mode
		AND	#00FH
		TAX
ENDT110		EQU	$
		LDA	>PSCTDT1,X
		STA	!OAM+100H+012H
		LDA	!ENDTPT
		AND	#0F0H
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		TAX
		LDA	<ENDSPFG
		BEQ	ENDT120
		LDA	<WORKA
		AND	#0F0H
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		TAX
ENDT120		EQU	$
		LDA	>PSCTDT1,X
		STA	!OAM+100H+00EH
		LDA	!ENDTPT+1
		AND	#00FH
		TAX
		LDA	<ENDSPFG
		BEQ	ENDT130
		LDA	<WORKB
		AND	#00FH
		TAX
ENDT130		EQU	$
		LDA	>PSCTDT1,X
		STA	!OAM+100H+00AH
;
;--------------------------------------- enmy NO. set
ENDT200		EQU	$
		M16			; memory 16bit mode
		LDA	!ENMYNO
		AND	#00FFFH
		BEQ	ENDT290
		STA	<WORKA
		M8			; memory 8bit mode
		AND	#00FH
		TAX
		LDA	>PSCTDT1,X
		STA	!OAM+100H+(ENSCRD1-ENSCRD0)+026H	; low
		LDA	<WORKA
		AND	#0F0H
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		TAX
		LDA	>PSCTDT1,X
		STA	!OAM+100H+(ENSCRD1-ENSCRD0)+022H	; mid
		LDX	<WORKB
		LDA	>PSCTDT1,X
		STA	!OAM+100H+(ENSCRD1-ENSCRD0)+01EH	; high
;
ENDT290		EQU	$
		M8			; memory 8bit mode
		LDA	<FRCNT
		AND	#010H
		BEQ	ENDT300
		LDX	!ENNOFLS
		LDA	!OAM+100H+(ENSCRD1-ENSCRD0)+01FH,X
		AND	#0F0H
		STA	!OAM+100H+(ENSCRD1-ENSCRD0)+01FH,X
;
;--------------------------------------- enmy name
ENDT300		EQU	$
		MI16			; memory , index 16bit mode
		LDA	!ENMYNO
		ASL	A
		ASL	A
		CLC
		ADC	!ENMYNO
		TAX
		M8			; memory 8bit mode
		LDA	!ENNAMBF+0,X
		STA	!OAM+100H+(ENSCRD2-ENSCRD0)+002H
		STA	!ENNAM0
		LDA	!ENNAMBF+1,X
		STA	!OAM+100H+(ENSCRD2-ENSCRD0)+006H
		STA	!ENNAM1
		LDA	!ENNAMBF+2,X
		STA	!OAM+100H+(ENSCRD2-ENSCRD0)+00AH
		STA	!ENNAM2
		LDA	!ENNAMBF+3,X
		STA	!OAM+100H+(ENSCRD2-ENSCRD0)+00EH
		STA	!ENNAM3
		LDA	!ENNAMBF+4,X
		STA	!OAM+100H+(ENSCRD2-ENSCRD0)+012H
		STA	!ENNAM4
		I8			; index 8bit mode
;
;--------------------------------------- X point set
ENDT400		EQU	$
		LDA	<CRXPSL1
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		TAX
		LDA	>PSCTDT1,X
		STA	!OAM+100H+(ENSCRD3-ENSCRD0)+0EH
		LDX	<CRXPSH1
		LDA	>PSCTDT1,X
		STA	!OAM+100H+(ENSCRD3-ENSCRD0)+0AH
;
;--------------------------------------- Y point set
		LDA	<CRYPSL1
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		TAX
		LDA	>PSCTDT1,X
		STA	!OAM+100H+(ENSCRD3-ENSCRD0)+1EH
		LDX	<CRYPSH1
		LDA	>PSCTDT1,X
		STA	!OAM+100H+(ENSCRD3-ENSCRD0)+1AH
;
;--------------------------------------- file name set
		LDA	!MJIDX0
		BEQ	ENDT500
		LDX	#000H
		TXY
ENDT505		EQU	$
		LDA	!MOJBF0,X
		STA	!OAM+100H+(ENSCRD4-ENSCRD0)+2,Y
		INY
		INY
		INY
		INY
		INX
		CPX	#008H
		BNE	ENDT505
ENDT500		EQU	$
		LDA	!MJIDX1
		BEQ	ENDT600
		LDX	#000H
		TXY
ENDT515		EQU	$
		LDA	!MOJBF1,X
		STA	!OAM+100H+(ENSCRD45-ENSCRD0)+2,Y
		INY
		INY
		INY
		INY
		INX
		CPX	#008H
		BNE	ENDT515
;
;--------------------------------------- edit mode set
ENDT600		EQU	$
		LDX	<WORK0
		M16			; memory 16bit mode
		LDA	<PLDWFG
		AND	#000FFH
		ASL	A
		TAY
		LDA	ENSCRD5,Y
		STA	<WORK2
		LDY	#000H
ENDT610		EQU	$
		LDA	(<WORK2),Y
		STA	!OAM+100H,X
		INX
		INX
		INY
		INY
		CPY	#(PLDWDT1-PLDWDT0)
		BNE	ENDT610
		M8			; memory 8bit mode
		PHX
		LDX	<WORK0
		LDA	#010H
		STA	!OAM+100H+01H,X
		STA	!OAM+100H+05H,X
		STA	!OAM+100H+09H,X
		STA	!OAM+100H+0DH,X
		STA	!OAM+100H+11H,X
		STA	!OAM+100H+15H,X
		PLX
;
ENDT99		EQU	$
		PLB
		RTS
;
;
ENSCRD0		EQU	$
		BYTE	020H,0BAH,C_P,032H	; P
		BYTE	028H,0BAH,C_T,032H	; T
		BYTE	028H,0C2H,C_0,032H	; 0
		BYTE	030H,0C2H,C_0,032H	; 0
		BYTE	038H,0C2H,C_0,032H	; 0
;
ENSCRD1		EQU	$
		BYTE	048H,0BAH,C_E,03AH	; E
		BYTE	050H,0BAH,C_N,03AH	; N
		BYTE	058H,0BAH,C_M,03AH	; M
		BYTE	060H,0BAH,C_Y,03AH	; Y
;
		BYTE	050H,0C2H,C_N,03AH	; N
		BYTE	058H,0C2H,C_O,03AH	; O
		BYTE	060H,0C2H,L_p,03AH	; .
		BYTE	068H,0C2H,C_0,03AH	; 0
		BYTE	070H,0C2H,C_0,03AH	; 0
		BYTE	078H,0C2H,C_0,03AH	; 0
;
ENSCRD2		EQU	$			; enmy name
		BYTE	088H,0BAH,C_HI,032H	; -
		BYTE	090H,0BAH,C_HI,032H	; -
		BYTE	098H,0BAH,C_HI,032H	; -
		BYTE	0A0H,0BAH,C_HI,032H	; -
		BYTE	0A8H,0BAH,C_HI,032H	; -
;
ENSCRD3		EQU	$			; X,Y point
		BYTE	0B8H,0BAH,C_X,032H	; X
		BYTE	0C0H,0BAH,C_HI,032H	; -
		BYTE	0C8H,0BAH,C_0,032H	; 0
		BYTE	0D0H,0BAH,C_0,032H	; 0
;
		BYTE	0B8H,0C2H,C_Y,032H	; Y
		BYTE	0C0H,0C2H,C_HI,032H	; -
		BYTE	0C8H,0C2H,C_0,032H	; 0
		BYTE	0D0H,0C2H,C_0,032H	; 0
;
ENSCRD4		EQU	$
		BYTE	020H,0AAH,02DH,032H	; enmy file name set
		BYTE	028H,0AAH,02DH,032H
		BYTE	030H,0AAH,02DH,032H
		BYTE	038H,0AAH,02DH,032H
		BYTE	040H,0AAH,02DH,032H
		BYTE	048H,0AAH,02DH,032H
		BYTE	050H,0AAH,02DH,032H
		BYTE	058H,0AAH,02DH,032H
		BYTE	060H,0AAH,02EH,032H
		BYTE	068H,0AAH,045H,032H
		BYTE	070H,0AAH,04EH,032H
		BYTE	078H,0AAH,044H,032H
ENSCRD45	EQU	$
		BYTE	088H,0AAH,02DH,032H	; corse data name set
		BYTE	090H,0AAH,02DH,032H
		BYTE	098H,0AAH,02DH,032H
		BYTE	0A0H,0AAH,02DH,032H
		BYTE	0A8H,0AAH,02DH,032H
		BYTE	0B0H,0AAH,02DH,032H
		BYTE	0B8H,0AAH,02DH,032H
		BYTE	0C0H,0AAH,02DH,032H
		BYTE	0C8H,0AAH,02EH,032H
		BYTE	0D0H,0AAH,044H,032H
		BYTE	0D8H,0AAH,041H,032H
		BYTE	0E0H,0AAH,054H,032H
;
ENSCRD5		EQU	$
		WORD	PLDWDT0,PLDWDT1,PLDWDT2
		WORD	PLDWDT3,PLDWDT4,PLDWDT5
;
ENSCRD6		EQU	$
;
;
;****************************************************************
;*								*
;*	pull down menuw						*
;*								*
;****************************************************************
PLDWNMN		EQU	$
		LDA	<MOUSEBB
		AND	#10000000B	; mouse right ON ?
		BNE	PLDWN00		;	YES -> PLDWN00
		LDA	#ENPLMD
		STA	<GMMODE
		JMP	PLDWN99
PLDWN00		EQU	$
		PHB
		PHK
		PLB
		MI16			; memory , index 16bit mode
		LDX	#00000H
PLDWN05		EQU	$
		LDA	PLDWDT0,X
		STA	!OAM+100H,X
		INX
		INX
		CPX	#(PLDWDTE-PLDWDT0)
		BNE	PLDWN05
;
		M8			; memory 8bit mode
		LDA	<MOUSEBY	; mouse move ?
		BEQ	PLDWN20		;	NO -> PLDWN20
		BMI	PLDWN10
		INC	<MOUSWK0
		BRA	PLDWN105
PLDWN10		EQU	$
		DEC	<MOUSWK0
;
PLDWN105	EQU	$
		LDA	<MOUSWK0	; mouse up move ?
		BMI	PLDWN15		;	YES -> PLDWN15
		CMP	#004H
		BCC	PLDWN20
		STZ	<MOUSWK0
		INC	<PLDWFG
		LDA	<PLDWFG
		CMP	#006H
		BCC	PLDWN20
		STZ	<PLDWFG
		BRA	PLDWN20
PLDWN15		EQU	$
		CMP	#0FCH
		BCS	PLDWN20
		STZ	<MOUSWK0
		DEC	<PLDWFG
		BPL	PLDWN20
		LDA	#005H
		STA	<PLDWFG
;
PLDWN20		EQU	$
		LDA	#000H
		XBA
		LDA	<PLDWFG
		TAX
		LDA	PLDWDT,X
		TAX
		LDA	#03AH
		STA	!OAM+100H+03H,X
		STA	!OAM+100H+07H,X
		STA	!OAM+100H+0BH,X
		STA	!OAM+100H+0FH,X
		STA	!OAM+100H+13H,X
		STA	!OAM+100H+17H,X
;
		I8			; index 8bit mode
		PLB
PLDWN99		EQU	$
		RTL
;
;
PLDWDT		EQU	$
		BYTE	PLDWDT0-PLDWDT0	; 0
		BYTE	PLDWDT1-PLDWDT0	; 1
		BYTE	PLDWDT2-PLDWDT0	; 2
		BYTE	PLDWDT3-PLDWDT0	; 3
		BYTE	PLDWDT4-PLDWDT0	; 4
		BYTE	PLDWDT5-PLDWDT0	; 5
;
PLDWDT0		EQU	$
		BYTE	0C8H,010H,C_E,032H	; E
		BYTE	0D0H,010H,C_D,032H	; D
		BYTE	0D8H,010H,C_I,032H	; I
		BYTE	0E0H,010H,C_T,032H	; T
		BYTE	0D8H,010H,C_I,032H	;
		BYTE	0E0H,010H,C_T,032H	;
;
PLDWDT1		EQU	$
		BYTE	0C8H,018H,C_U,032H	; U
		BYTE	0D0H,018H,C_N,032H	; N
		BYTE	0D8H,018H,C_D,032H	; D
		BYTE	0E0H,018H,C_O,032H	; O
		BYTE	0D8H,018H,C_D,032H	;
		BYTE	0E0H,018H,C_O,032H	;
;
PLDWDT2		EQU	$
		BYTE	0C8H,020H,C_M,032H	; M
		BYTE	0D0H,020H,C_O,032H	; O
		BYTE	0D8H,020H,C_V,032H	; V
		BYTE	0E0H,020H,C_E,032H	; E
		BYTE	0D8H,020H,C_V,032H	;
		BYTE	0E0H,020H,C_E,032H	;
;
PLDWDT3		EQU	$
		BYTE	0C8H,028H,C_D,032H	; D
		BYTE	0D0H,028H,C_E,032H	; E
		BYTE	0D8H,028H,C_L,032H	; L
		BYTE	0E0H,028H,C_E,032H	; E
		BYTE	0E8H,028H,C_T,032H	; T
		BYTE	0F0H,028H,C_E,032H	; E
;
PLDWDT4		EQU	$
		BYTE	0C8H,030H,C_R,032H	; R
		BYTE	0D0H,030H,C_E,032H	; E
		BYTE	0D8H,030H,C_N,032H	; N
		BYTE	0E0H,030H,C_A,032H	; A
		BYTE	0E8H,030H,C_M,032H	; M
		BYTE	0F0H,030H,C_E,032H	; E
;
PLDWDT5		EQU	$
		BYTE	0C8H,038H,C_S,032H	; S
		BYTE	0D0H,038H,C_E,032H	; E
		BYTE	0D8H,038H,C_A,032H	; A
		BYTE	0E0H,038H,C_R,032H	; R
		BYTE	0E8H,038H,C_C,032H	; C
		BYTE	0F0H,038H,C_H,032H	; H
;
PLDWDTE		EQU	$
;
;
;****************************************************************
;*								*
;*	edit mode						*
;*								*
;****************************************************************
ENEDT		EQU	$
		LDA	<MOUSEBT
		AND	#01000000B	; mouse left ON ?
		BNE	ENEDT00		;	YES -> ENEDT00
		JMP	ENEDT99		;	NO  -> ENEDT99
ENEDT00		EQU	$
		LDA	!ENDTPT
		CMP	#0FFH
		BEQ	ENEDT99
;
		JSR	ENBFAD		; enmy buffer address set
;
		LDA	[<WORK0]	; buffer inc.
		INC	A		;
		STA	[<WORK0]	;
;
		MI16			; memory , index 16bit mode
		JSR	ENNOIDX		; enmy NO. set index
		LDA	!ENMYNO		;
		AND	#001FFH		; ENMYNO * 5 --> X
		STA	<WORK0		;
		ASL	A		;
		ASL	A		;
		ADC	<WORK0		;
		TAY			;
;
		LDA	!ENNAMBF,Y	; enmy name set
		STA	>ENDTBF,X	;
		LDA	!ENNAMBF+2,Y	;
		STA	>ENDTBF+2,X	;
		LDA	!ENNAMBF+3,Y	;
		STA	>ENDTBF+3,X	;
;
		LDA	<CRYPSL1	; address set
		AND	#007F0H		;
		LSR	A		;
		LSR	A		;
		LSR	A		;
		STA	<WORK0		;
		LDA	<CRXPSL1	;
		AND	#00FF0H		;
		ASL	A		;
		ASL	A		;
		ASL	A		;
		ASL	A		;
		ORA	<WORK0		;
		STA	>ENDTBF+5,X	;
		MI8			; memory , index 8bit mode
;
		M16			; memory 16bit mode
		LDA	#02400H
		STA	<WORK0
		JSR	ENVMST
		M8			; memory 8bit mode
;
		STZ	<VRFLG
;
		INC	!ENDTPT
;
		MI16			; memory , index 16bit mode
		JSR	ENNOIDX		; enmy NO. set index
		LDA	#0FFFFH
		STA	>ENDTBF,X
		MI8			; memory , index 16bit mode
;
ENEDT99		EQU	$
		RTS
;
;;;;K;;;;;
;;;;K;;;;		MI16			; memory , index 16bit mode
;;;;K;;;;		JSR	ENNOIDX		; enmy NO. set index
;;;;K;;;;		LDA	<CRYPSL1	;
;;;;K;;;;		AND	#007F0H		; 00000000 00000000 00000000 B
;;;;K;;;;		LSR	A		; |------| |-----||--------|
;;;;K;;;;		LSR	A		;    |	      |	  enmy unit NO
;;;;K;;;;		LSR	A		;    |	    Y point
;;;;K;;;;		XBA			;  X point
;;;;K;;;;		ORA	!ENMYNO		;
;;;;K;;;;		STA	>ENDTBF,X	;
;;;;K;;;;		LDA	<CRXPSL1	;
;;;;K;;;;		LSR	A		;
;;;;K;;;;		LSR	A		;
;;;;K;;;;		LSR	A		;
;;;;K;;;;		LSR	A		;
;;;;K;;;;		M8			; memory 8bit mode
;;;;K;;;;		STA	>ENDTBF+2,X	;
;;;;K;;;;		I8			; index 8bit mode
;;;;K;;;;;
;
;****************************************************************
;*								*
;*	undo mode						*
;*								*
;****************************************************************
ENUND		EQU	$
		LDA	!ENUNDBF
		ASL	A
		TAX
		JSR	(RTNDAT,X)
		RTS
;
RTNDAT		EQU	$
		WORD	UNDERR	; 0
		WORD	UNDERR	; 1
		WORD	UNDMOV	; 2
		WORD	UNDDEL	; 3
		WORD	UNDREN	; 4
;
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+							+
;+	undo move					+
;+							+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
UNDMOV		EQU	$
		MI16			; memory , index 16bit mode
		LDX	!ENUNDBF+1
		LDA	>ENDTBF+5,X
		STA	<WORKA
		JSR	UNDBFAD		; enmy buffer data address
		M8			; memory 8bit mode
		LDA	[<WORK0]
		DEC	A
		STA	[<WORK0]
;
UNDMV00		EQU	$
		M16			; memory 16bit mode
		LDA	!ENUNDBF+8
		STA	<WORKA
		JSR	UNDBFAD		; enmy buffer data address
		MI8			; memory , index 8bit mode
		LDA	[<WORK0]
		INC	A
		STA	[<WORK0]
;
		M16			; memory 16bit mode
		LDA	!ENUNDBF+8
		AND	#000FEH
		ASL	A
		ASL	A
		ASL	A
		STA	<CRYPSL1
		SEC
		SBC	#00040H
		BMI	UNDPOS0
		CMP	#00758H
		BCC	UNDPOS1
		LDA	#00760H
		BRA	UNDPOS1
UNDPOS0		EQU	$
		LDA	#00000H
UNDPOS1		EQU	$
		AND	#007F0H
		SEC
		SBC	#00008H
		STA	<SCCV1
		STA	<SCCV2
		STA	<SCCV3
;
		LDA	!ENUNDBF+8
		AND	#0FF00H
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		STA	<CRXPSL1
		SEC
		SBC	#00080H
		BMI	UNDPOS2
		CMP	#00F01H
		BCC	UNDPOS3
		LDA	#00F00H
		BRA	UNDPOS3
UNDPOS2		EQU	$
		LDA	#00000H
UNDPOS3		EQU	$
		AND	#00FF0H
		SEC
		SBC	#00008H
		STA	<SCCH1
		STA	<SCCH2
		STA	<SCCH3
		M8			; memory 8bit mode
;
		JSR	UNDREN
		LDA	#080H
		STA	<BLKFLG
		STZ	<GMMODE
		STZ	<PLDWFG
		RTS
;
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+							+
;+	undo delete					+
;+							+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
UNDDEL		EQU	$
		STZ	!ENUNDBF
		PHB
		MI16			; memory , index 16bit mode
		LDA	!ENDTPT
		AND	#000FFH
		STA	<WORK4
		ASL	A
		ASL	A
		ASL	A
		SEC
		SBC	<WORK4
		PHA
		SEC
		SBC	!ENUNDBF+1
		STA	<WORK4
		PLA
		CLC
		ADC	#ENDTBF
		STA	<WORK0
		CLC
		ADC	#00007H
		STA	<WORK2
;
		LDX	<WORK0
		LDY	<WORK2
		LDA	<WORK4
		MVP	#BANK ENDTBF,#BANK ENDTBF
		MI8			; memory , index 8bit mode
		PLB
;
		JMP	UNDMV00
;
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+							+
;+	undo rename					+
;+							+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
UNDREN		EQU	$
		MI16			; memory , index 16bit mode
		LDX	!ENUNDBF+1
;
		LDA	>ENDTBF,X
		PHA
		LDA	!ENUNDBF+3
		STA	>ENDTBF,X
		PLA
		STA	!ENUNDBF+3
;
		LDA	>ENDTBF+2,X
		PHA
		LDA	!ENUNDBF+5
		STA	>ENDTBF+2,X
		PLA
		STA	!ENUNDBF+5
;
		LDA	>ENDTBF+4,X
		PHA
		LDA	!ENUNDBF+7
		STA	>ENDTBF+4,X
		PLA
		STA	!ENUNDBF+7
;
		M8			; memory 8bit mode
		LDA	>ENDTBF+6,X
		PHA
		LDA	!ENUNDBF+9
		STA	>ENDTBF+6,X
		PLA
		STA	!ENUNDBF+9
		I8			; index 8bit mode
		RTS
;
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+							+
;+	undo error					+
;+							+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
UNDERR		EQU	$
		LDA	#03FH
		STA	<ERRFLG
		LDA	#ERR0
		STA	<GMMODE
		STZ	<PLDWFG
		RTS
;
		RTS
;
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+						+
;+	enmy buffer data address		+
;+						+
;++++++++++++++++++++++++++++++++++++++++++++++++
		MEM16
		IDX16
;
UNDBFAD		EQU	$
		STZ	<WORK1
		LDA	<WORKA
		XBA
		LSR	A
		AND	#07000H
		STA	<WORK0
		LDA	<WORKA
		AND	#0F000H
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		ORA	<WORK0
		STA	<WORK0		; high set
		LDA	<WORKA
		AND	#0001EH
		ASL	A
		ASL	A
		ASL	A
		ORA	<WORK0
		STA	<WORK0
		LDA	<WORKA
		AND	#00F00H
		XBA
		ORA	<WORK0
		STA	<WORK0		; low set
		LDA	<WORK1
		ORA	#07F80H
		STA	<WORK1
		RTS
;
		MEM8
		IDX8
;
;
;****************************************************************
;*								*
;*	move mode						*
;*								*
;****************************************************************
ENMOV		EQU	$
		LDA	<MOUSEBB
		AND	#01000000B	; mouse left ON ?
		BEQ	ENMOVPS		;	NO -> ENMOVPS
		LDX	#002H
		JSR	MDOBJAD		;  mode obj cursol set
ENMOVPS		EQU	$
		LDA	<ENDELFG
		ASL	A
		TAX
		JSR	(ENMOVMD,X)
		RTS
;
ENMOVMD		EQU	$
		WORD	MOV000,MOV100
;
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+	move mode  (search)				+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
MOV000		EQU	$
		JSR	REN000
		LDA	<ENDELFG
		BEQ	MOV090
;
		JSR	ENBFAD		; enmy buffer address set
		M16			; memory 16bit mode
		LDA	[<WORK0]	; buffer dec.
		DEC	A
		STA	[<WORK0]
		BNE	MOV030
;
		LDA	#00402H
		STA	<WORK0
		JSR	ENVMST		; enmy sinbol disp set
MOV030		EQU	$
		M8			; memory 8bit mode
;
MOV090		EQU	$
		RTS
;
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+	move mode  (move)				+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
MOV100		EQU	$
		LDA	<MOUSEBB
		AND	#01000000B	; mouse left ON ?
		BNE	MOV190		;	YES -> MOV190
		MI16			; memory , index 16bit mode
		JSR	ENDTBFAD	; enmy data buffer address set
;
		JSR	UNDBFST		; undo buffer data set
;
		LDX	!SRCPOS
		LDA	>ENDTBF+5,X
		AND	#001H
		ORA	<WORK0
		STA	>ENDTBF+5,X
		MI8			; memory , index 8bit mode
;
		JSR	ENBFAD		; enmy buffer address set
		M16			; memory 16bit mode
		LDA	[<WORK0]	; buffer dec.
		INC	A
		STA	[<WORK0]
;
		LDA	#02400H
		STA	<WORK0
		JSR	ENVMST		; enmy sinbol disp set
		M8			; memory 8bit mode
;
		STZ	<ENDELFG
MOV190		EQU	$
		RTS
;
;
;****************************************************************
;*								*
;*	delete mode						*
;*								*
;****************************************************************
ENDEL		EQU	$
		LDA	<MOUSEBB
		AND	#01000000B	; mouse left ON ?
		BEQ	ENDELPS		;	NO -> ENDELPS
		LDX	#004H
		JSR	MDOBJAD		;  mode obj cursol set
ENDELPS		EQU	$
		LDA	<ENDELFG
		ASL	A
		TAX
		JSR	(ENDELMD,X)
		RTS
;
ENDELMD		EQU	$
		WORD	DEL000,DEL100
;
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+	delete mode  (delete)				+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
DEL100		EQU	$
		LDA	<MOUSEBB
		AND	#01000000B	; mouse left ON ?
		BEQ	DEL110		;	YES -> DEL110
		JMP	ENDEL99		;	NO  -> ENDEL99
DEL110		EQU	$
		MI16			; memory , index 16bit mode
		JSR	ENDTBFAD	; enmy data buffer address set
		LDX	!SRCPOS
		LDA	>ENDTBF+5,X
		AND	#0FFFEH
		CMP	<WORK0
		BEQ	ENDEL90
;
		JSR	KAERU		; mouse cursol move ram change
		PHP
		JSR	ENBFAD		; enmy buffer address set
		PLP
		LDA	[<WORK0]	; buffer dec.
		DEC	A		;
		STA	[<WORK0]	;
		AND	#000FFH
		BNE	ENDEL70
;
		I8			; index 8bit mode
		LDA	#00402H
		STA	<WORK0
		JSR	ENVMST		; enmy sinbol disp set
		I16			; index 16bit mode
;
ENDEL70		EQU	$
		PHB
		MI16			; memory ,index 16bit mode
;
		JSR	UNDBFST		; undo buffer data set
;
		LDA	!SRCPOS		; enmy data ma-e tu-me-ru
		CLC
		ADC	#ENDTBF
		STA	<WORKA
		CLC
		ADC	#00007H
		STA	<WORKC
		LDA	!ENDTPT
		ASL	A
		ASL	A
		ASL	A
		SEC
		SBC	!ENDTPT
		SEC
		SBC	!SRCPOS
		DEC	A
		STA	<WORKE
		I16			; index 16bit mode
		LDX	<WORKC
		LDY	<WORKA
		LDA	<WORKE
		MVN	#BANK ENDTBF,#BANK ENDTBF
		PLB
;
		JSR	KAERU		; mouse cursol move ram change
		STZ	!SRCPOS
		LDA	#00000H
		STA	>ENMYDTBF
		MI8			; memory , index 8bit mode
		STZ	<VRFLG
		DEC	!ENDTPT
;
ENDEL90		EQU	$
		MI8			; memory , index 8bit mode
		STZ	<ENDELFG
;
ENDEL99		EQU	$
		RTS
;
;
;****************************************************************
;*								*
;*	rename mode						*
;*								*
;****************************************************************
ENREN		EQU	$
		LDA	<ENDELFG
		ASL	A
		TAX
		JSR	(ENRENMD,X)
		RTS
;
ENRENMD		EQU	$
		WORD	REN000,REN100,REN200
;
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+	rename mode  (search)				+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
REN000		EQU	$
DEL000		EQU	$
		LDA	<MOUSEBT
		AND	#01000000B	; mouse left ON ?
		BEQ	REN090		;	NO -> REN090
		LDA	#001H
		STA	<ENDELFG
		JSR	ENSRC		; enmy data buffer search
REN090		EQU	$
		RTS
;
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+	rename mode  (move)				+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
REN100		EQU	$
		LDX	#006H
		JSR	MDOBJAD		;  mode obj cursol set
		LDA	<MOUSEBB
		AND	#01000000B	; mouse left ON ?
		BNE	REN190		;	YES -> REN190
		MI16			; memory , index 16bit mode
		JSR	ENDTBFAD	; enmy data buffer address set
		LDX	!SRCPOS
		LDA	>ENDTBF+5,X
		AND	#0FFFEH
		CMP	<WORK0
		BNE	REN180
		MI8			; memory , index 8bit mode
		STZ	<ENDELFG
		BRA	REN190
;
REN180		EQU	$
		MI8			; memory , index 8bit mode
		LDA	#002H
		STA	<ENDELFG
;
REN190		EQU	$
		RTS
;
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+	rename mode  (enmy NO. change)			+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
REN200		EQU	$
		LDA	#006H
		STA	<ENMDOBJ
		LDA	<MOUSEBT
		AND	#01000000B	; mouse left ON ?
		BEQ	REN290		;	NO -> REN290
		MI16			; memory , index 16bit mode
		JSR	ENDTBFAD	; enmy data buffer address set
		MI8			; memory , index 8bit mode
		LDA	<CRXPSL1
		AND	#0F0H
		CMP	<XTAIHI
		BNE	REN250
		LDA	<CRYPSL1
		AND	#0F0H
		CMP	<YTAIHI
		BNE	REN250
;
		MI16			; memory , index 16bit mode
		JSR	UNDBFST		; undo buffer data set
;
		LDX	!SRCPOS
		LDA	!ENNAM0		; enmy name change
		STA	>ENDTBF,X	;
		LDA	!ENNAM2		;
		STA	>ENDTBF+2,X	;
		LDA	!ENNAM3		;
		STA	>ENDTBF+3,X	;
		MI8			; memory , index 8bit mode
REN250		EQU	$
		STZ	<ENDELFG
;
REN290		EQU	$
		RTS
;
;
;****************************************************************
;*								*
;*	search mode						*
;*								*
;****************************************************************
ENSRC		EQU	$
		LDA	#001H
		STA	<ENDSPFG
		LDA	<MOUSEBT
		AND	#01000000B	; mouse left ON ?
		BNE	ENSRC00		;	YES -> ENSRC00
		JMP	ENSRC99		;	NO  -> ENSRC99
ENSRC00		EQU	$
		M16			; memory 16bit mode
		LDA	<CRXPSL1
		AND	#00FF0H
		CMP	<CRXPSL2
		BNE	ENSRC20
		LDA	<CRYPSL1
		AND	#00FF0H
		CMP	<CRYPSL2
		BEQ	ENSRC25
ENSRC20		EQU	$
		LDA	#08000H
		STA	!SRCPOS
		LDA	#00000H
		STA	>ENMYDTBF
ENSRC25		EQU	$
		M8			; memory 8bit mode
		JSR	ENDTSRC		; enmy data buffer search
;
		M16			; memory 16bit mode
		LDA	<CRXPSL1
		AND	#00FF0H
		STA	<CRXPSL2
		LDA	<CRYPSL1
		AND	#00FF0H
		STA	<CRYPSL2
		M8			; memory 8bit mode
;
ENSRC99		EQU	$
		RTS
;
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+							+
;+	undo buffer data set				+
;+							+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
		MEM16
		IDX16
;
UNDBFST		EQU	$
		LDX	!SRCPOS
		LDA	<PLDWFG		; mode set
		AND	#000FFH		;
		STA	!ENUNDBF	;
;
		LDA	!SRCPOS		; count set
		STA	!ENUNDBF+1	;
;
		LDA	>ENDTBF,X	; data set
		STA	!ENUNDBF+3	; data set
		LDA	>ENDTBF+2,X	;
		STA	!ENUNDBF+5	;
		LDA	>ENDTBF+4,X	;
		STA	!ENUNDBF+7	;
		LDA	>ENDTBF+5,X	;
		STA	!ENUNDBF+8	;
		RTS
;
		MEM8
		IDX8
;
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+							+
;+	enmy data buffer address set			+
;+							+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
		MEM16
		IDX16
ENDTBFAD	EQU	$
		LDA	<CRXPSL1
		AND	#00FF0H
		ASL	A
		ASL	A
		ASL	A
		ASL	A
		STA	<WORK0
		LDA	<CRYPSL1
		AND	#007F0H
		LSR	A
		LSR	A
		LSR	A
		ORA	<WORK0
		STA	<WORK0
		RTS
;
		MEM8
		IDX8
;
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+							+
;+	mouse cursol move ram change			+
;+							+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
		MEM16
		IDX16
KAERU		EQU	$
		LDA	<CRXPSL1
		PHA
		LDA	<CRXPSL2
		STA	<CRXPSL1
		PLA
		STA	<CRXPSL2
		LDA	<CRYPSL1
		PHA
		LDA	<CRYPSL2
		STA	<CRYPSL1
		PLA
		STA	<CRYPSL2
		RTS
		MEM8
		IDX8
;
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+							+
;+	enmy sinbol disp set				+
;+				in			+
;+				  work 0,1 <- unit NO.	+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
		MEM16
ENVMST		EQU	$
		LDX	!VRAMD
		LDA	<CRXPSL1
		AND	#001F0H
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		STA	<WORKA
		LDA	<CRYPSL1
		AND	#001F0H
		ASL	A
		ORA	#07C00H
		ORA	<WORKA
;
		STA	!VRAMD+2,X
		LDA	#00001H
		STA	!VRAMD+4,X
		LDA	<WORK0
		STA	!VRAMD+6,X
		LDA	#0FFFFH
		STA	!VRAMD+8,X
		LDA	!VRAMD
		CLC
		ADC	#00006H
		STA	!VRAMD
		RTS
		MEM8
;
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+							+
;+	enmy data buffer search				+
;+		     work 0,1 <- enmy data buffer point	+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
ENDTSRC		EQU	$
		MI16			; memory , index 16bit mode
;
		LDA	>ENMYDTBF
		STA	<WORK6
		LDA	!SRCPOS
		BMI	SRC005
		INC	<WORK6
		CLC
		ADC	#00007H
SRC005		EQU	$
		AND	#07FFFH
		TAX
		JSR	ENDTBFAD	; enmy data buffer address set
;
SRC000		EQU	$
		LDA	>ENDTBF,X
		CMP	#0FFFFH
		BEQ	SRC995
		LDA	>ENDTBF+5,X
		AND	#0FFFEH
		CMP	<WORK0
		BEQ	SRC990
		INC	<WORK6
		TXA
		CLC
		ADC	#00007H
		TAX
		BRA	SRC000
;
SRC990		EQU	$
		LDA	<WORK6
		STA	>ENMYDTBF
		LDA	>ENDTBF,X
		STA	!ENNAM0
		LDA	>ENDTBF+2,X
		STA	!ENNAM2
		LDA	>ENDTBF+3,X
		STA	!ENNAM3
		STX	!SRCPOS
		JSR	ENMNO		; enmy name -> enmy NO.
		MI8			; memory , index 8bit mode
		BRA	SRC999
;
		MEM16
		IDX16
SRC995		EQU	$
		LDA	#00000H
		STA	>ENMYDTBF
		LDA	#08000H
		STA	!SRCPOS
		MI8			; memory , index 8bit mode
		STZ	<ENDELFG
		STZ	<ENDSPFG
		LDA	#03FH
		STA	<ERRFLG
		LDA	#ERR0
		STA	<GMMODE
SRC999		EQU	$
		RTS
;
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+							+
;+	enmy name -> enmy NO.				+
;+							+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
		IDX16
ENMNO		EQU	$
		LDA	!ENNAMCT
		STA	<WORK0
		ASL	A
		ASL	A
		CLC
		ADC	<WORK0
		STA	<WORK0
		STZ	<WORK4
		M8			; memory 8bit mode
		LDY	#00000H
ENMNO00		EQU	$
		LDA	>ENDTBF,X
		CMP	!ENNAMBF,Y
		BNE	ENMNO50
		LDA	>ENDTBF+1,X
		CMP	!ENNAMBF+1,Y
		BNE	ENMNO50
		LDA	>ENDTBF+2,X
		CMP	!ENNAMBF+2,Y
		BNE	ENMNO50
		LDA	>ENDTBF+3,X
		CMP	!ENNAMBF+3,Y
		BNE	ENMNO50
		LDA	>ENDTBF+4,X
		CMP	!ENNAMBF+4,Y
		BEQ	ENMNO60
ENMNO50		EQU	$
		M16			; memory 16bit mode
		INC	<WORK4
		M8			; memory 8bit mode
		INY
		INY
		INY
		INY
		INY
		CPY	<WORK0
		BCC	ENMNO00
;
ENMNO60		EQU	$
		M16			; memory 16bit mode
		LDA	<WORK4
		STA	!ENMYNO
		RTS
		MEM8
		IDX8
;
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+							+
;+	enmy NO. set index				+
;+				!ENDTPT*7 -> X		+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
		MEM16
		IDX16
;
ENNOIDX		EQU	$
		LDA	!ENDTPT
		ASL	A
		ASL	A
		ASL	A
		SEC
		SBC	!ENDTPT
		TAX
		RTS
;
		MEM8
		IDX8
;
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+							+
;+	enmy buffer address set				+
;+							+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
ENBFAD		EQU	$
		M16			; memory 16bit mode
		STZ	<WORK0
		LDA	<CRXPSL1
		AND	#00F00H
		XBA
		ORA	#07F80H
		STA	<WORK1
		LDA	<CRYPSL1
		AND	#00700H
		ASL	A
		ASL	A
		ASL	A
		ASL	A
		XBA
		ORA	<WORK1
		STA	<WORK1		; bank & high address set
		M8			; memory 8bit mode
;
		LDA	<CRXPSL1
		AND	#0F0H
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		STA	<WORK0
		LDA	<CRYPSL1
		AND	#0F0H
		ORA	<WORK0
		STA	<WORK0		; low address set
		RTS
;
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+							+
;+	mode obj cursol set				+
;+				X <- obj index		+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
MDOBJAD		EQU	$
		STX	<ENMDOBJ
		LDA	<CRXPSL1
		AND	#0F0H
		STA	<XTAIHI
		LDA	<CRYPSL1
		AND	#0F0H
		STA	<YTAIHI
		RTS
;
;
;****************************************************************
;*								*
;*	mouse auto scroll mode (test)				*
;*								*
;****************************************************************
MSTEST		EQU	$
		JSL	>MSSCRMD
;
		LDA	!OAM+4		; X pos
		PHA
		SEC
		SBC	!OAM
		CLC
		ADC	!OAM+4
		STA	!OAM+4
		PLA
		STA	!OAM
;
		LDA	!OAM+5		; Y pos
		PHA
		SEC
		SBC	!OAM+1
		CLC
		ADC	!OAM+5
		STA	!OAM+5
		PLA
		STA	!OAM+1
;
		RTL
;
;
;SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS
;S								S
;S	7byte data -> 3byte data ϊ				S
;S								S
;SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS
HNKNST		EQU	$
		MI16			; memory , index 16bit mode
		LDX	#00000H
		STZ	<WORKA
		LDA	>ENMYDTBF
		STA	<WORKC
HNKN00		EQU	$
		JSR	ENMNO		; enmy name -> enmy NO.
		LDY	<WORKA
		LDA	>ENDTBF+5,X
;;;K;;;		STA	<WORK0+1,Y
		LDA	>ENDTBF+4,X
		AND	#0FE00H
		ORA	!ENMYNO
;;;K;;;		STA	<WORK0,Y
		INC	<WORKA
		INC	<WORKA
		INC	<WORKA
		INX
		INX
		INX
		INX
		INX
		INX
		INX
		DEC	<WORKC
		BNE	HNKN00
		MI8			; memory , index 8bit mode
		RTS
;
;
;
;
;
;
		END
