;************************************************************************
;*									*
;*	title name	: "yossy tool"					*
;*	proccess	: game play main				*
;*	file name	: yst_game					*
;*									*
;************************************************************************
;
;
		SALL
;
		include		yst_header.inc
;
		XALL
;
;
;------------------------------------------------------------------------
;-		global symbol						-
;------------------------------------------------------------------------
		GLB	GMINIT,GMPLAY
;
;------------------------------------------------------------------------
;-		extern symbol						-
;------------------------------------------------------------------------
;
;-------------< yst_main >-----------------------------------------------
		EXT	OAMCLR,OAMCHG
;
;-------------< yst_vma >------------------------------------------------
		EXT	VRAMCL
;
;-------------< ys_init >------------------------------------------------
		EXT	GMCHRST,GMCOLST,GMMDST,UNITST,BGINT
		EXT	GM01,GM02,GM03,GM04,GM05,GM06
;
;-------------< yst_init >-----------------------------------------------
		EXT	BGSET
;
;-------------< yst_play >-----------------------------------------------
		EXT	PLINIT,PLAYER,PLCSET,PLSCRL
;
;
;------------------------------------------------------------------------
;-		define symbol						-
;------------------------------------------------------------------------
;;;;		EQU
;
;
;
;************************************************************************
;*									*
;*		program start						*
;*									*
;************************************************************************
;
;
		EXTEND
;
;
		MEM8
		IDX8
;
;
		ORG	78000H
;
;
;************************************************************************
;*		game initial						*
;************************************************************************
GMMDNOD		EQU	$
		BYTE	GM01	 ;[0]
		BYTE	GM02	 ;[1]
		BYTE	GM03	 ;[2]
		BYTE	GM04	 ;[3]
		BYTE	GM01	 ;[4]
		BYTE	GM05	 ;[5]
		BYTE	GM06	 ;[6]
;
GMINIT		EQU	$
		PHB			;(DBR) save
		PHK			;(DBR) <-- (PBR)
		PLB
;
		JSL	>VRAMCL		;VRAM clear
		STZ	4200H		;NMI disable
		STZ	1E00H
;
		JSL	>UNITST		;unit no. buffer set
;
;-------------- character set -----------------------------------
		JSL	>GMCHRST	;character set
;
;-------------- color set ---------------------------------------
		JSL	>GMCOLST	;color set
;
		STZ	2121H		;CGRAM address set
;
		M16
;
		LDA	#00000000B+(22H*100H)	;DMA parameter & B bus address
		STA	4300H
		LDA	#DATACOL		;A bus address(L,H)
		STA	4302H
		LDY	#BANK DATACOL		;	"     (B)
		STY	4304H
		LDA	#0100H			;number of byte
		STA	4305H
		LDX	#00000001B
		STX	420BH			;DMA "ON"
;
		M8
;
;-------------- game mode set -----------------------------------
		LDY	BG1TYP
		LDX	!GMMDNOD,Y	;(X) <-- game mode type no.
		JSL	>GMMDST		;game mode set
;
;-------------- BG screen set -----------------------------------
		JSR	GMSCRST		;BG2 screen set ( test )
		JSR	BG3SCIN		;BG3 spacial screen set
;
;-------------- player initial set ------------------------------
		JSL	>PLINIT		;player initial
;
;-------------- etc initial set ---------------------------------
		JSL	>BGINT		;BG initial write
;
;-------------- SFX-DOS disable ---------------------------------
		DOS	_DOSSTP
;
;-------------- go to next move !! ------------------------------
		INC	<GMMODE
		LDA	#0FH
		STA	<BLKFLG
;
		LDA	#10000001B
		STA	4200H
		STA	1E00H
;
		PLB
		RTL
;
;************************************************************************
;*		game play						*
;************************************************************************
;
GMPLAY		EQU	$
		JSL	>OAMCLR		;OAM clear
;
		JSL	>PLSCRL		;scroll set
		JSL	>PLCSET		;player OAM set
		JSL	>PLAYER		;player move
;
		JSL	>OAMCHG		;OAM sub change
;
		JSL	>BGSET		;BG write
;
		LDA	<KEYA2
		AND	#00010000B
		BEQ	GMPL010		;return to edit ? ( no:GMPL010 )
;
;-------------- SFX-DOS enable ----------------------------------
		STZ	<GMMODE
;
GMPL010		EQU	$
		RTL
;
;************************************************************************
;*		game play screen set					*
;************************************************************************
SC2ADRS		EQU	$	 ;[BG2TYP]
		LWORD	09A000H	 ;[0:Jx]
		LWORD	09A800H	 ;[1:]
		LWORD	099000H	 ;[2:]
		LWORD	09A000H	 ;[3:n]
		LWORD	09A000H	 ;[4:]
		LWORD	09A800H	 ;[5:]
		LWORD	09E800H	 ;[6:ou]
		LWORD	09A800H	 ;[7:n]
;
GMSCRST		EQU	$
;
		M16
;
;-------------- BG1 meter screen set ----------------------------
		LDY	#10000000B	;inc mode set
		STY	2115H
		LDA	#00000001B+(18H*100H)	;parameter & A bus address set
		STA	4300H
		LDA	#7800H		;VRAM address set
		STA	2116H
		LDA	#09E000H	;(B) bus address(L,H)
		STA	4302H
		LDY	#BANK 09E000H	;	"       (B)
		STY	4304H
		LDA	#0800H		;number of byte
		STA	4305H
		LDX	#00000001B	;DMA "ON"
		STX	420BH
;
;-------------- BG2 screen set ----------------------------------
		LDA	BG2TYP
		ASL	A
;;;;		CLC
		ADC	BG2TYP
		TAY			;(Y) <-- chikei no.
;
		LDA	#7C00H		;VRAM address set
		STA	2116H
		LDA	!SC2ADRS,Y	;(B) bus address(L,H)
		STA	4302H
		LDX	!SC2ADRS+2,Y	;	"       (B)
		STX	4304H
		LDA	#0800H*2	;number of byte
		STA	4305H
		LDX	#00000001B
		STX	420BH		;DMA "ON"
;
		M8
;
		RTS
;
;************************************************************************
;*		BG3 spacial screen data set				*
;************************************************************************
;
;-------------- BG3 screen pattern data ---------------------------------
BG3SCAD		EQU	$		;[BG3TYP]
		LWORD	09C000H		;[0] yuki yama
		LWORD	09B800H		;[1] mizu
		LWORD	09F000H		;[2] H-DMA test
;
		MEM8
		IDX8
;
BG3SCIN		EQU	$
;
;-------------- BG3 screen set ----------------------------------
		LDA	BG3TYP		;x3
		ASL	A
;;;;		CLC
		ADC	BG3TYP
		TAX
;
		LDA	#10000000B	;inc mode set
		STA	2115H
;
		M16
;
		LDA	#7400H			;VRAM address set
		STA	2116H
;
		LDA	#00000001B+(18H*100H)	;DMA parameter & B bus address set
		STA	4300H
		LDA	>BG3SCAD,X		;A bus address set
		STA	4302H
		LDA	>BG3SCAD+1,X
		STA	4303H
		LDA	#0800H			;number of byte set
		STA	4305H
		LDY	#00000001B
		STY	420BH			;DMA "ON" !!
;
		M8
;
		RTS
;
;
;
;
;
		END
