;************************************************************************
;*									*
;*	title name	: "yossy tool"					*
;*	proccess	: initial process				*
;*	file name	: yst_init					*
;*									*
;************************************************************************
;
;
		SALL
;
		include		yst_header.inc
;
		XALL
;
;
;------------------------------------------------------------------------
;
;		Super_Y edit-tool		1992.03.05(THU)
;
;------------------------------------------------------------------------
;
		ORG	028000H
;
;=============================================== (syt_init) =============
		GLB	BGWTPL,BGWRITE,BGSET,UNITST,BGINT
		GLB	ENWTPL,ENBGSLC
		GLB	ITMD,PLMD,MDSL,BGWR,ERR0,DTSV,DTLD,DTDS,UPSL,DWSL
		GLB	LFSL,RISL,BGDS,STIN,MFRM,DTDL,GAME
		GLB	MSSC
		GLB	ENPLMD,ENMDSL,ENFILE
		GLB	FPSV,FPLD,FPDL,ENFILE,ENFMD,FLNM
		GLB	FPFT
		GLB	MSTST
;=============================================== (syt_main) =============
		EXT	JSRSUB,JSRSUBL,KYREAD
;=============================================== (syt_vma) ==============
		EXT	VRAMCL,BGSCWTL
;=============================================== (syt_edit) =============
		EXT	PLAY,MODESL,ERROR,WNDWST
		EXT	MSSCRMD
		EXT	PLY510
;=============================================== (syt_dmap) =============
		EXT	DTDISP
;=============================================== (syt_stat) =============
		EXT	STATIN
;=============================================== (syt_svld) =============
		EXT	FORMAT,DTSAVE,DTLOAD,DTDEL
;=============================================== (yst_bgsc0) ============
		EXT	KOTEISB,KAHENSB
;=============================================== (ys_unit) ==============
		EXT	UNDTADD,UNDATA
;=============================================== (ys_init) =============
		EXT	GMCHRST,GMCOLST,RUTSET
;=============================================== (yst_game) ============
		EXT	GMINIT,GMPLAY
;=============================================== (yst_en_edit) =========
		EXT	ENPLAY,PLDWNMN
		EXT	MSTEST
;=============================================== (yst_en_file) =========
		EXT	ENFLINT,ENFLMD
		EXT	FLPYSV,FLPYLD,FLPYDL,FLNMDSP
		EXT	FLPYFT
		EXT	BGENINT,BGENSL,BGENFD
;========================================================================
;
		EXTEND
		MEM8
		IDX8
;
;
;
;
;************************************************************************
;*		Initial - 1				(INIT1)		*
;************************************************************************
BGWTPL		EQU	$
		JSL	>KYREAD		; key-board read
;
		LDA	<GMMODE
		JSL	>JSRSUBL
		LWORD	INIT		;00
		LWORD	PLAY		;01
		LWORD	MODESL		;02
		LWORD	BGWRITE		;03
		LWORD	ERROR		;04
		LWORD	DTSAVE		;05
		LWORD	DTLOAD		;06
		LWORD	DTDISP		;07
		LWORD	UPSCRL		;08
		LWORD	DWSCRL		;09
		LWORD	LFSCRL		;0A
		LWORD	RISCRL		;0B
		LWORD	BGDISP		;0C
		LWORD	STATIN		;0D
		LWORD	FORMAT		;0E
		LWORD	DTDEL		;0F
;
		LWORD	GMINIT		;10
		LWORD	GMPLAY		;11
		LWORD	MSSCRMD		;12
;;
;
ITMD		EQU	000H
PLMD		EQU	001H
MDSL		EQU	002H
BGWR		EQU	003H
ERR0		EQU	004H
DTSV		EQU	005H
DTLD		EQU	006H
DTDS		EQU	007H
UPSL		EQU	008H
DWSL		EQU	009H
LFSL		EQU	00AH
RISL		EQU	00BH
BGDS		EQU	00CH
STIN		EQU	00DH
MFRM		EQU	00EH
DTDL		EQU	00FH
;
GAME		EQU	010H
MSSC		EQU	012H
;
;
;
;
;
;-------------- chikei name character address ---------------------------
CHIKCHR		EQU	$		;[BG1TYP]
		WORD	1DC000H		;[0]
		WORD	1DC000H+0200H	;[1]
		WORD	1DC000H+0400H	;[2]
		WORD	1DC000H+0600H	;[3]
		WORD	1DC000H+0800H	;[4]
		WORD	1DC000H+0A00H	;[5]
		WORD	1DC000H+0C00H	;[6]
;
;
ENWTPL		EQU	$
		JSL	>KYREAD		; key-board read
;
		LDA	<GMMODE
		JSL	>JSRSUBL
		LWORD	ENINIT		;00
		LWORD	ENPLAY		;01 enmy data set
		LWORD	PLDWNMN		;02
		LWORD	BGWRITE		;03
		LWORD	ERROR		;04
		LWORD	FLPYSV		;05
		LWORD	FLPYLD		;06
		LWORD	DTDISP		;07
		LWORD	UPSCRL		;08
		LWORD	DWSCRL		;09
		LWORD	LFSCRL		;0A
		LWORD	RISCRL		;0B
		LWORD	BGDISP		;0C
		LWORD	STATIN		;0D
		LWORD	FLNMDSP		;0E
		LWORD	FLPYDL		;0F
;
		LWORD	GMINIT		;10
		LWORD	GMPLAY		;11
		LWORD	MSSCRMD		;12
		LWORD	ENFLINT		;13 enmy file mode initial
		LWORD	ENFLMD		;14 enmy file mode
		LWORD	FLPYFT		;15
		LWORD	MSTEST		;16 mouse auto scroll mode (test)
;
;
ENPLMD		EQU	001H
ENMDSL		EQU	002H
FPSV		EQU	005H
FPLD		EQU	006H
FLNM		EQU	00EH
FPDL		EQU	00FH
ENFILE		EQU	013H
ENFMD		EQU	014H
FPFT		EQU	015H
MSTST		EQU	016H
;
;
ENBGSLC		EQU	$
		JSL	>KYREAD		; key-board read
;
		LDA	<GMMODE
		JSL	>JSRSUBL
		LWORD	BGENINT		; BG or enmy data set tool select initial
		LWORD	BGENSL		; select
		LWORD	BGENFD
;
;
ENINIT		EQU	$
		JSL	>PLY510
		JSL	>UNITST
		JSL	>INIT
		LDA	#19H
		STA	BGMODE
		STA	2105H
		LDA	#00010111B
		STA	<MANSEL
		LDA	#07CH
		STA	2107H
		LDA	#001H
		STA	2108H
		LDA	#07H
		STA	210BH
		RTL
;
;
;
;
INIT		EQU	$
		JSL	>VRAMCL		; VRAM clear!!
;
		INC	<GMMODE		;go to next mode !!
;
;-------------- course BG initial set ---------------------------
INIT1000	EQU	$
;
;---------------  OBJ mode initial set	---------------------------------
		LDA	#00000010B
		STA	2101H
;
;---------------  BG. mode initial set	---------------------------------
		STZ	2133H		; BG. initial (Vsize = 244)
		LDA	#00101001B
		STA	2105H		; BG mode<1> set
		STZ	2106H		; mozaiku reset!!
;
		LDA	#00000001B
		STA	2107H		; BG1 screen data set
;;;;K;;;;		LDA	#01111110B
		LDA	#01111100B
		STA	2108H		; BG2
		LDA	#01110100B
		STA	2109H		; BG3
		LDA	#01111000B
		STA	210AH		; BG4
;
		LDA	#01110000B
		STA	210BH		; BG.1,2 character address set
		LDA	#01100110B
		STA	210CH		; BG.3	 character address set
;
;---------------  Window parameter set	---------------------------------
		STZ	212EH		; window select	 (main)
		STZ	212FH		;	 "       (sub)
;
		STZ	2123H		; window (BG2:off , BG1:off)
		STZ	2124H		;	 (BG4:off , BG3:off)
		STZ	2125H		;	 (CL:off  , OBJ:off)
;
		STZ	212AH		; window masuku set (OR mode)
		STZ	212BH
;
;-------------- BG curse data initial write -----------------------------
		JSL	>BGINT
;
		M16
;
		LDA	<SCCH1
		STA	<SCCH3
		STA	<SCCH2
;
		LDA	<SCCV1
		STA	<SCCV3
		STA	<SCCV2
;
		M8
;
;-------------- game character set --------------------------------------
		JSL	>GMCHRST	;game character set
;
;-------------- game color set ------------------------------------------
		JSL	>GMCOLST	;game color set
;
		STZ	2121H		;CGRAM address set
;
		M16
;
		LDA	#00000000B+(22H*100H)	;DMA parameter & B bus address
		STA	4300H
		LDA	#DATACOL		;A bus address(L,H)
		STA	4302H
		LDY	#BANK DATACOL		;	"     (B)
		STY	4304H
		LDA	#0100H			;number of byte
		STA	4305H
		LDX	#00000001B
		STX	420BH			;DMA "ON"
;
		M8
;
;------------------------------------------------------------------------
;-		tool initial set					-
;------------------------------------------------------------------------
;
;-------------- OBJ color set -----------------------------------
		LDA	#080H			;CGRAM address set
		STA	2121H
;
		M16
;
		LDA	#00000000B+(22H*100H)	;DMA parameter & B bus address
		STA	4300H
		LDA	#1CC000H		;A bus address(L,H)
		STA	4302H
		LDY	#BANK 1CC000H		;	"     (B)
		STY	4304H
		LDA	#0100H			;number of byte
		STA	4305H
		LDX	#00000001B
		STX	420BH			;DMA "ON"
;
;-------------- BG2 character set -------------------------------
		LDA	#10000000B	;inc mode
		STA	2115H
;
		M16			; memory 16bit mode
;
		LDA	#7000H
		STA	2116H		; VRAM address set
		LDA	#00000001B+(18H*100H)
		STA	4300H		; parameter & B bus address
		LDA	#089000H
		STA	4302H		; A bus address (L,H)
		LDY	#BANK 089000H
		STY	4304H		;		(B)
		LDA	#00800H
		STA	4305H		; number of byte
		STX	420BH
;
		M8			; memory 8bit mode
;
;-------------- BG3 character set -------------------------------
		LDA	#10000000B	;inc mode
		STA	2115H
;
		M16
;
		LDA	#6000H
		STA	2116H		; VRAM address set
		LDA	#00000001B+(18H*100H)
		STA	4300H		; parameter & B bus address
		LDA	#1C8000H
		STA	4302H		; A bus address (L,H)
		LDY	#BANK 1C8000H
		STY	4304H		;		(B)
		LDA	#2000H
		STA	4305H		; number of byte
		STX	420BH		; DMA "on"
;
;-------------- BG3 screen set ----------------------------------
		LDA	#7400H
		STA	2116H		; VRAM address set
		LDA	#1CA000H
		STA	4302H		; A bus address (L,H)
		LDY	#BANK 1CA000H
		STY	4304H		;		(B)
		LDA	#0800H
		STA	4305H		; number of byte
		STX	420BH		; DMA "on"
;
;-------------- OBJ character set -------------------------------
		LDA	#4000H		;VRAM address set
		STA	2116H
		LDA	#1D8000H	;A bus address(L,H)
		STA	4302H
		LDY	#BANK 1D8000H	;	"     (B)
		STY	4304H
		LDA	#4000H		;number of byte
		STA	4305H
		STX	420BH		;DMA "ON"
;
;-------------- chikei name character set -----------------------
		LDA	BG1TYP
		ASL	A
		TAX
		LDA	#4E00H		;VRAM address set
		STA	2116H
		LDA	>CHIKCHR,X	;A bus address(L,H) set
		STA	4302H
		LDY	#BANK 1DC000H	;	"     (B) set
		STY	4304H
		LDA	#00C0H		;number of byte set
		TAY
		STA	4305H
		LDX	#00000001B
		STX	420BH
;
		LDA	#4F00H		;VRAM address set
		STA	2116H
		STY	4305H		;number of byte
		STX	420BH
;
		M8
;
;-------------- window set --------------------------------------
		JSL	>WNDWST		; window set
;
		LDA	#00001111B
		STA	<BLKFLG		; blanking off
		RTL
;
;************************************************************************
;*		 BG. write				(INBGWT1)	*
;************************************************************************
BGWRITE		EQU	$
		JSL	>VRAMCL		; VRAM clear!!
;
		JSL	>INIT1000	;course BG initial set
;
		LDA	#PLMD
		STA	<GMMODE
		RTL
;
;
;
;
;************************************************************************
;*		UP scroll BG. write			(UPSCRL)	*
;************************************************************************
UPSCRL		EQU	$
		MEM16
		REP	#00100000B	; memory 16bit mode
;
		LDA	#00002H
		STA	!SCVMUK
		LDA	#0FFF8H
		BRA	VSCROLL
;
;
;************************************************************************
;*		DOWN scroll BG. write			(DWSCRL)	*
;************************************************************************
DWSCRL		EQU	$
		MEM16
		REP	#00100000B	; memory 16bit mode
;
		STZ	!SCVMUK
		LDA	#00008H
VSCROLL		EQU	$
		STA	<WORK0
		LDX	<SIFTFG
		CLC
		ADC	<CRYPSL1,X
		STA	<CRYPSL1,X
;
		LDA	<SCCV1
		CLC
		ADC	<WORK0
		PHA
		SEC
		SBC	<MVSCV1
		STA	<WORK2
		EOR	<WORK0
		ASL	A
		PLA
		BCS	VSCL40		; end ?
;					; yes
		LDA	<CRYPSL1,X
		SEC
		SBC	<WORK2
		STA	<CRYPSL1,X
		LDA	<MVSCV1
		STZ	<MVSCV1
		LDX	#PLMD
		STX	<GMMODE
VSCL40		EQU	$
		STA	<SCCV1
		STA	<SCCV2
		STA	<SCCV3		; scroll count move
;
		MEM8
		SEP	#00100000B	; memory 8bit mode
;
		JMP	>BGSET
;
;
;
;
;************************************************************************
;*		LEFT scroll BG. write			(LFSCRL)	*
;************************************************************************
LFSCRL		EQU	$
		MEM16
		REP	#00100000B	; memory 16bit mode
;
		LDA	#00002H
		STA	!SCHMUK
		LDA	#0FFF8H
		BRA	HSCROLL
;
;
;************************************************************************
;*		RIGHT scroll BG. write			(RISCRL)	*
;************************************************************************
RISCRL		EQU	$
		MEM16
		REP	#00100000B	; memory 16bit mode
;
		STZ	!SCHMUK
		LDA	#00008H
HSCROLL		EQU	$
		STA	<WORK0
		LDX	<SIFTFG
		CLC
		ADC	<CRXPSL1,X
		STA	<CRXPSL1,X
;
		LDA	<SCCH1
		CLC
		ADC	<WORK0
		PHA
		SEC
		SBC	<MVSCH1
		STA	<WORK2
		EOR	<WORK0
		ASL	A
		PLA
		BCS	HSCL40		; end ?
;					; yes
		LDA	<CRXPSL1,X
		SEC
		SBC	<WORK2
		STA	<CRXPSL1,X
		LDA	<MVSCH1
		STZ	<MVSCH1
		LDX	#PLMD
		STX	<GMMODE
HSCL40		EQU	$
		STA	<SCCH1
		STA	<SCCH2
		STA	<SCCH3		; scroll count move
;
		MEM8
		SEP	#00100000B	; memory 8bit mode
;
		JMP	>BGSET
;
;
;
;
;************************************************************************
;*		BG intial write						*
;************************************************************************
BGINT		EQU	$
		PHB			;(DBR) save
		PHK			;(DBR) <-- (PBR)
		PLB
;
		STZ	BGWHF1		;BG write flag reset !!
		STZ	BGWVF1
		STZ	SCHMK1		;scroll muki reset !!
;
;-------------- intial scroll counter set -----------------------
;
		MI16
;
		LDA	<SCCV1
		STA	WRSCV1
;
;-------------- intial BG write ---------------------------------
		LDA	#16+1		;loop no.
		STA	<WORK12
		LDA	<SCCH1
		SEC
		SBC	#0100H
		STA	<WORK14
;
BGIN20		EQU	$
		LDX	#00
		STX	<WORK10		;(WK10) <-- BG type
		JSR	HWADST		;H scroll BG screen write VRAM address set
;
;-------------- enemy data BG write set -------------------------
		LDA	!ENBGFLG
		AND	#0000FH
		CMP	#00002H
		BEQ	BGIN30
;
		JSR	ENB2HST		; enmy data BG set
;
BGIN30		EQU	$
;
		MI8
;
;;;;		JSR	BG3SCK		;"mogura" course BG3 screen set check
;;;;		JSL	>NEWVMADL	;BG3 screen write
		JSL	>BGSCWTL	;BG screen write
;
		MI16
;
		LDA	<WORK14
		CLC
		ADC	#0010H
		STA	<WORK14
;
		DEC	<WORK12
		BNE	BGIN20
;
;
;;;;;--------------	"mogura" course BG3 glass character save --------
;;;;		LDA	CHIKNO
;;;;		CMP	#01H
;;;;		BNE	BGIN050		;"mogura course ? ( no:BGIN050 )
;;;;;
;;;;		PHB			;(DBR) save
;;;;		PEA	VRAMD/100H
;;;;		PLB
;;;;		PLB
;;;;;
;;;;		LDY	VRAMD
;;;;		LDA	#6C00H
;;;;		STA	VRAMD+2,Y		;VRAM address set
;;;;		LDA	#0010000000000000B+(800H-1)
;;;;		STA	VRAMD+4,Y		;number of byte & VRAM raed flag set
;;;;		LDA	#CHRSVBF
;;;;		STA	VRAMD+6,Y		;A bus address(L,H) set
;;;;		LDA	#BANK CHRSVBF
;;;;		STA	VRAMD+8,Y		;A bus address(B) set
;;;;		LDA	#0FFFFH
;;;;		STA	VRAMD+9,Y		;end code set
;;;;		TYA
;;;;		CLC
;;;;		ADC	#7
;;;;		STA	VRAMD			;next index set
;;;;;
;;;;		PLB
;;;;;
;;;;		MI8
;;;;;
;;;;		JSL	>VMADSPL		;VRAM read !!
;;;;;
;;;;BGIN050		EQU	$
;
		MI8
;
		PLB
		RTL
;
;************************************************************************
;*		BG screen scroll write set				*
;************************************************************************
;
BGSET		EQU	$
		PHB			;(DBR) save
		PHK			;(DBR) <-- (PBR)
		PLB
;
		MI16
;
		LDX	#00		;(X) <-- BG type [ 0:BG1 4:BG2 ]
BGST010		EQU	$
		STX	<WORK10		;(WK10,11) <-- BG type
;
;-------------- BG write timming check --------------------------
;
;-------------- H scroll BG write -----------------------
		LDA	<SCCH1,X
		AND	#0FFF0H
		CMP	WRSCH1,X
		BEQ	BGST020		;BG change ? ( no:BGST020 )
;
		JSR	HWADST		;H scroll screen data set
;
;-------------- enemy data BG write set -------------------------
		LDA	!ENBGFLG
		AND	#0000FH
		CMP	#00002H
		BEQ	BGST012
;
		JSR	ENB2HST		; enmy data BG set
;
BGST012		EQU	$
		LDX	<WORK10		;(X) <-- BG type
;
;-------------- V scroll BG write -----------------------
BGST020		EQU	$
		LDA	<SCCV1,X
		AND	#0FFF0H
		CMP	WRSCV1,X
		BEQ	BGST030		;BG change ? ( no:BGST030 )
;
		JSR	VWADST		;V scroll screen data set
;-------------- enemy data BG write set -------------------------
		LDA	!ENBGFLG
		AND	#0000FH
		CMP	#00002H
		BEQ	BGST022
;
		JSR	ENB2VST		; enmy data BG set
BGST022		EQU	$
		LDX	<WORK10		;(X) <-- BG type
;
BGST030		EQU	$
		DEX
		BPL	BGST010
;
		MI8
;
		PLB
		RTL
;
;****************************************************************
;*		H scroll BG screen write set			*
;*			in  : (X) <-- BG type [ 0:BG1 4:BG2 ]	*
;*			      (A) <-- H scroll counter		*
;****************************************************************
BGWPNTH		EQU	$
		WORD	00100H,00000H
BGSCRADR	EQU	$		;BG screen VRAM address data
		WORD	0000H		;[BG1]
UNBFPINT	WORD	0000H>>4
		WORD	0000H		;[BG2]
		WORD	0800H>>4
BGBUFADR	EQU	$
		WORD	BGHSCRBF	;[BG1]
BGBUFAMX	WORD	BGHSCRBF+(020H*2)
		WORD	BGHSCRBF	;[BG2]
		WORD	BGHSCRBF+(020H*2)
;
		MEM16
		IDX16
;
HWADST		EQU	$
		INC	BGWHF1,X	;BG write flag "ON"
;
		STA	WRSCH1,X
		LDY	SCHMK1,X
		CLC
		ADC	!BGWPNTH,Y
		TAY
		STA	<WORK		;(WK0,1) <-- write H counter
		AND	#01F0H
		BIT	#0100H
		BEQ	HWAS010
;
		EOR	#(0400H<<3)|0100H
HWAS010		EQU	$
		LSR	A
		LSR	A
		LSR	A
		PHA			;(A) save
;;;;		CLC
		ADC	!BGSCRADR,X	;screen base address add
		STA	BGWAH1_0,X
		INC	A
		STA	BGWAH1_1,X
		TYA
		AND	#0F00H
		XBA
		STA	<WORK
		PLA			;(A) load
		AND	#000FH*2
		STA	<WORK2
;
		LDA	<SCCV1,X
		AND	#00F0H
		TAY
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		PHA			;low set loop no save
		EOR	#000FH
		INC	A
		STA	<WORK6		;(WK6,7) <-- up set loop no.
		TYA
		ASL	A
		STA	<WORKE
		LDA	<SCCV1,X
		LSR	A
		LSR	A
		TAY
		LSR	A
		LSR	A
		AND	#0700H>>4
		ORA	!UNBFPINT,X
		ORA	<WORK
		STA	<WORK4
		TAX
		LDA	>UNBUFAD-1,X
		AND	#3F00H
		ASL	A
		ORA	<WORKE
		ORA	<WORK2
		PHA			;(A) save
;
		TYA
		AND	#00F0H>>2
		LDX	<WORK10		;(X) <-- BG type
;;;;		CLC
		ADC	!BGBUFADR,X
		TAY			;(Y) <-- chara no. set buffer address
;
		PLX			;(A) load
		JSR	HWAS20
;
		LDX	<WORK10		;(X) <-- BG type
		PLA
		BEQ	HWAS30		;low set ? ( no:HWAS30 )
;
;-------------- hi -> low set -----------------------------------
		STA	<WORK6		;(WK6,7) <-- loop no.
;
		TYA
		CMP	!BGBUFAMX,X
		BCC	HWAS14
		LDY	!BGBUFADR,X
HWAS14		EQU	$
		LDA	<WORK4
		CLC
		ADC	#0010H
		AND	#07F0H>>4
		ORA	!UNBFPINT,X
		TAX
		LDA	>UNBUFAD-1,X
		AND	#3F00H
		ASL	A
		ORA	<WORK2
		TAX
;
;-------------- write buffer set --------------------------------
HWAS20		EQU	$
		PHX			;(X) save
		LDA	>BGUNIT,X
		PHA
		XBA
		AND	#00FFH
		ASL	A
		TAX
		PLA
		AND	#00FFH
		ASL	A
		ASL	A
		ASL	A
;;;;		CLC
		ADC	>UNDTADD,X
		TAX
		LDA	>UNDATA,X
		STA	0,Y
		LDA	>UNDATA+2,X
		STA	20H*2,Y
		LDA	>UNDATA+4,X
		STA	2,Y
		LDA	>UNDATA+6,X
		STA	20H*2+2,Y
		INY
		INY
		INY
		INY
		PLA			;(X) load
		CLC
		ADC	#0020H
		TAX
		DEC	<WORK6
		BNE	HWAS20
;
HWAS30		EQU	$
		RTS
;
;****************************************************************
;*		V scroll BG screen write set			*
;*			in  : (X) <-- BG type [ 0:BG1 4:BG2 ]	*
;*			      (A) <-- V scroll counter		*
;****************************************************************
BGWPNTV		EQU	$
		WORD	000F0H,00000H
BGBUFADV	EQU	$
		WORD	BGVSCRBF,0	;[BG1]
		WORD	BGVSCRBF	;[BG2]
;
VWADST		EQU	$
		INC	BGWVF1,X		;BG write flag "ON"
;
		STA	WRSCV1,X
		LDY	SCVMK1,X
		CLC
		ADC	!BGWPNTV,Y
		STA	BG3WSCV		;BG3 screen write scroll counter_V set
		TAY
		ASL	A
		AND	#00F0H*2
		STA	<WORK2
		ASL	A
		STA	<WORK
		TYA
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		AND	#0700H>>4
		STA	<WORK4
;
		LDA	<SCCH1,X
		LSR	A
		LSR	A
		PHA
		AND	#00F0H>>2
		TAY
		LSR	A
		LSR	A
		STA	<WORK8		;(WK8,9) <-- low set loop no. -1
		EOR	#0FH
		INC	A
		STA	<WORK6		;(WK6,7) <-- hi set loop no.
;
		TYA
		CLC
		ADC	#04H
		STA	BGWNO1_1,X	;number of byte 2 set
		TYA
		LSR	A
		STA	<WORKE
		PLA			;(A) load
		LSR	A
		AND	#01F0H>>3
		BIT	#0100H>>3
		BEQ	VWAS10
;
		EOR	#0400H|(0100H>>3)
VWAS10		EQU	$
		ORA	<WORK
		PHA
		CLC
		ADC	!BGSCRADR,X	;screen base address add
		STA	BGWAV1_00,X
		CLC
		ADC	#020H
		STA	BGWAV1_01,X
		PLA
		EOR	#0400H
		AND	#0FFE0H
		CLC
		ADC	!BGSCRADR,X	;screen base address add
		STA	BGWAV1_10,X
		CLC
		ADC	#020H
		STA	BGWAV1_11,X
		LDA	#22H*2
		SEC
		SBC	BGWNO1_1,X
		STA	BGWNO1_0,X	;number of byte 1 set
		LDY	!BGBUFADV,X	;(Y) <-- chara no. set buffer address
		LDA	<SCCH1+1
		AND	#000FH
		PHA			;(A) save
		ORA	<WORK4
		TAX
		LDA	>UNBUFAD-1,X
		AND	#3F00H
		ASL	A
		ORA	<WORKE
		ORA	<WORK2
		TAX
;
		JSR	VWAS20
;
;-------------- hi -> low set -----------------------------------
		LDX	<WORK8
		INX
		STX	<WORK6		;(WK6,7) <-- loop no.
;
		PLA			;(A) load
		INC	A
		AND	#000FH
		ORA	<WORK4
		TAX
		LDA	>UNBUFAD-1,X
		AND	#3F00H
		ASL	A
		ORA	<WORK2
		TAX
;
;-------------- write buffer set --------------------------------
VWAS20		EQU	$
		PHX			;(X) save
		LDA	>BGUNIT+1,X
		AND	#00FFH
		ASL	A
		PHA			;(A) save
		LDA	>BGUNIT,X
		AND	#00FFH
		ASL	A
		ASL	A
		ASL	A
		PLX			;(A) load
;;;;		CLC
		ADC	>UNDTADD,X
		TAX
		LDA	>UNDATA,X
		STA	0,Y
		LDA	>UNDATA+2,X
		STA	2,Y
		LDA	>UNDATA+4,X
		STA	22H*2,Y
		LDA	>UNDATA+6,X
		STA	22H*2+2,Y
		INY
		INY
		INY
		INY
		PLX
		INX
		INX
		DEC	<WORK6
		BNE	VWAS20
		RTS
;
		MEM8
		IDX8
;
;
;
;********************************************************
;*	enmy data BG set				*
;*	H scroll BG screen write VRAM address set	*
;********************************************************
;
		MEM16
		IDX16
;
ENB2HST		EQU	$
		PHB
		PHK
		PLB
;
		LDA	<SCHMUK
		AND	#00002H
		TAX
		LDA	<WRSCH1
		CLC
		ADC	>BGWPNTH,X
		TAX
		AND	#001F0H
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		ORA	#07C00H		; BG2 screen address [ 7C00H- ]
		STA	!B2WTADH
;
		LDA	<SCCV2
		SEC
		SBC	#00020H
		AND	#0FFF0H
		TAY
		JSR	B2ENBFAD	; enmy data buffer address set
		LDA	<WORK0
		LSR	A
		LSR	A
		LSR	A
		AND	#0001EH
		STA	<WORK4
		LDA	<WORK0
		XBA
		AND	#00010H
		ASL	A
		EOR	<WORK4
		TAY			; buffer index set
;
		LDA	#020H		;(WK6,7) <-- loop no.
		STA	<WORK+6
;
ENB2H00		EQU	$
		LDX	#00402H
		M8			; memory 8bit mode
		LDA	[<WORK0]
;;;;K;;;;		AND	#000FFH
		BEQ	ENB2H10
		LDX	#02400H
ENB2H10		EQU	$
		M16			; memory 16bit mode
		TXA
		STA	!B2ENWTH,Y
		DEC	<WORK+6
		BEQ	ENB2H30		;end ? ( yes:ENB2H30 )
;
		INY
		INY
		TYA
		AND	#0003EH
		TAY
		LDA	<WORK0
		CLC
		ADC	#00010H
		STA	<WORK0
		AND	#000F0H		; high inc ?
		BNE	ENB2H00		;	NO -> ENB2H00
		LDA	<WORK0		; next page
		SEC			;  enmy data buffer address set
		SBC	#00100H
		CLC
		ADC	#01000H
		ORA	#08000H
		STA	<WORK0
		BRA	ENB2H00
;
ENB2H30		EQU	$
		INC	<B2WTHF		;BG2 write flag "ON"
		PLB
		RTS
;
;
;********************************************************
;*	enmy data BG set				*
;*	V scroll BG screen write VRAM address set	*
;********************************************************
ENB2VST		EQU	$
		PHB
		PHK
		PLB
;
		LDA	<SCVMUK
		AND	#00002H
		TAX
		LDA	<WRSCV1
		CLC
		ADC	>BGWPNTV,X
		TAY
		ASL	A
		AND	#003E0H
		ORA	#07C00H		; BG2 screen address [ 7C00H- ]
		STA	!B2WTADV
;
		LDA	<SCCH2
		SEC
		SBC	#00020H
		AND	#0FFF0H
		TAX
		JSR	B2ENBFAD	; enmy data buffer address set
		LDA	<WORK0
		ASL	A
		AND	#0001EH
		STA	<WORK4
		LDA	<WORK0
		AND	#00100H
		LSR	A
		LSR	A
		LSR	A
		EOR	<WORK4
		TAY			; buffer index set
;
		LDA	#020H		;(WK6,7) <-- loop no.
		STA	<WORK+6
;
ENB2V00		EQU	$
		LDX	#00402H
		M8			; memory 8bit mode
		LDA	[<WORK0]
;;;;K;;;;		AND	#000FFH
		BEQ	ENB2V10
		LDX	#02400H
ENB2V10		EQU	$
		M16			; memory 16bit mode
		TXA
		STA	!B2ENWTV,Y
		DEC	<WORK+6
		BEQ	ENB2V30		;end ? ( yes:ENB2V30 )
;
		INY
		INY
		TYA
		AND	#0003EH
		TAY
		LDA	<WORK0
		AND	#0F000H
		STA	<WORK4
		INC	<WORK0
		LDA	<WORK0		; high inc ?
		AND	#0000FH		;	NO -> ENB2V00
		BNE	ENB2V00
		LDA	<WORK0		; next page
		SEC			;  enmy data buffer address set
		SBC	#00010H
		CLC
		ADC	#00100H
		AND	#00FFFH
		ORA	<WORK4
		STA	<WORK0
		BRA	ENB2V00
;
ENB2V30		EQU	$
		INC	<B2WTVF		;BG2 write flag "ON"
		PLB
		RTS
;
;
;********************************************************
;*	enmy data buffer address set			*
;*			      in			*
;*				scch -> X		*
;*				sccv -> Y		*
;*			      out			*
;*				work2 <- bank		*
;*				work1 <- high		*
;*				work0 <- low		*
;********************************************************
B2ENBFAD	EQU	$
		STZ	<WORK0
		TYA
		AND	#00700H
		ASL	A
		ASL	A
		ASL	A
		ASL	A
		XBA
		ORA	#07F80H
		STA	<WORK1
		TXA
		AND	#00F00H
		XBA
		ORA	<WORK1
		STA	<WORK1		; bank & high address set
;
		TYA
		AND	#000F0H
		ORA	<WORK0
		STA	<WORK0
		TXA
		AND	#000F0H
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		ORA	<WORK0
		STA	<WORK0		; high & low address set
		RTS
;
		MEM8
		IDX8
;
;
;
;****************************************************************
;*		unit buffer display				*
;****************************************************************
BGDISP		EQU	$
		STZ	<SCHMUK		;scroll muki reset !!
;
		MI16
;
		PHB			;(DBR) save
		PHK			;(DBR) <-- (PBR)
		PLB
;
		LDA	<WRSCH1
		CLC
		ADC	#010H
		LDX	#00
		STX	<WORK10		;(WK10) <-- BG type
		JSR	HWADST		;H scroll BG screen write VRAM address set
;
		PLB			;(DBR) load
;
		MI8
;
		DEC	<BGDPFG
		BNE	BGDS010		;return ? ( no:BGDS010 )
;
;-------------- return set ------------------------------
		LDA	#PLMD		;normal mode set
		STA	<GMMODE
BGDS010		EQU	$
		RTL
;
;****************************************************************
;*		unit buffer set main				*
;****************************************************************
;
		MEM8
		IDX8
;
UNITST		EQU	$
		PHB			;(DBR) save
;
;-------------- base unit set ---------------------------
		JSL	>RUTSET		;ram unit set
;
;-------------- BG unit buffer clear --------------------
;
		MI16
;
		LDA	#0000
		LDX	#(200H*64)-2
UNST000		EQU	$
		STA	>NXGOTOBF,X
		DEX
		DEX
		BPL	UNST000
;
		MI8
;
		LDA	#00
		LDX	#16*8-1
UNST002		EQU	$
		STA	>UNBUFAD,X
		DEX
		BPL	UNST002
		STZ	<BGBFPT		;buffer pointer clear !!
;
;-------------- BG unit buffer set ----------------------
;
		M16
;
		LDA	#COURSEDT	;BG course data address set
		STA	<BGDTADR
		LDA	#COURSEDT/100H
		STA	<BGDTADR+1
		LDA	#7		;[+7]
		STA	<BGDTPT		;BG course data pointer set
;
		M8
;
UNTS010		EQU	$
;
		I16
;
		LDY	<BGDTPT
		LDA	[<BGDTADR],Y
		STA	<WORK1C		;(WK1C) <-- "kotei" & "kahen" flag
		INY			;[+1]
		LDA	[<BGDTADR],Y	;(WK1D) <-- X,Y pos(H)
		STA	<WORK1D
		INY			;[+2]
		LDA	[<BGDTADR],Y	;(WK1E) <--    "   (L)
		STA	<WORK1E
		INY			;[+3]
		LDA	[<BGDTADR],Y	;(WK1F) <-- status data
		STA	<WORK1F
		INY			;[+4]
		STY	<BGDTPT
		LDA	<WORK1C
		BEQ	KOTEISL		;kotei data ? ( yes:KOTEISL )
;
		CMP	#0FFH
		BNE	KAHENSL		;data end ? ( yes:KAHENSL )
;
		SEP	#00010000B	;index 8 bit mode
;
		PLB
		RTL
;
;-------------- kotei data -------------------------------
KOTEISL		EQU	$
		PHK			;return address set
		PEA	UNTS010-1
;
		M16
;
		LDA	<WORK1F
		AND	#00FFH
		STA	<WORK
		ASL	A		;[ (C)=0 ]
		ADC	<WORK
		TAX
;
		M8
;
		LDA	>KOTEISB+2,X
		PHA
		PHA			;(DBR) set
		PLB
		LDA	>KOTEISB+1,X
		PHA
		LDA	>KOTEISB,X
;
		I8
;
		PHA
		RTL
;
;-------------- kahen data -------------------------------
KAHENSL		EQU	$
		PHK			;return address set
		PEA	UNTS010-1
;
		M16
;
		AND	#00FFH
		STA	<WORK
		ASL	A		;[ (C)=0 ]
		ADC	<WORK
		TAX
;
		M8
;
		LDA	>KAHENSB+2,X
		PHA
		PHA			;(DBR) set
		PLB
		LDA	>KAHENSB+1,X
		PHA
		LDA	>KAHENSB,X
		PHA
;
		I8
;
		RTL
;
;
;
;
;
		END
