;************************************************************************
;*									*
;*	title name	: "yossy tool"					*
;*	proccess	: ram name					*
;*	file name	: yst_ram					*
;*									*
;************************************************************************
;
;
;
;--------------------------------------------------------------------
;
;-------------- color address define --------------------------------
COL_ADDRESS	EQU	0B8000H
;
;
;--------------------------------------------------------------------
WORK		EQU	000H		; work area
WORK0		EQU	000H
WORK1		EQU	001H
WORK2		EQU	002H
WORK3		EQU	003H
WORK4		EQU	004H
WORK5		EQU	005H
WORK6		EQU	006H
WORK7		EQU	007H
WORK8		EQU	008H
WORK9		EQU	009H
WORKA		EQU	00AH
WORKB		EQU	00BH
WORKC		EQU	00CH
WORKD		EQU	00DH
WORKE		EQU	00EH
WORKF		EQU	00FH
WORK10		EQU	010H
WORK11		EQU	011H
WORK12		EQU	012H
WORK13		EQU	013H
WORK14		EQU	014H
WORK15		EQU	015H
WORK16		EQU	016H
WORK17		EQU	017H
WORK18		EQU	018H
WORK19		EQU	019H
WORK1A		EQU	01AH
WORK1B		EQU	01BH
WORK1C		EQU	01CH
WORK1D		EQU	01DH
WORK1E		EQU	01EH
WORK1F		EQU	01FH
;
;--------------------------------------------------------------------
NMIFLG		EQU	WORK1F+1	; NMI flag
IRQFLG		EQU	NMIFLG+1	; IRQ flag
BLKFLG		EQU	IRQFLG+1	; Blanking check flag
VRFLG		EQU	BLKFLG+1	; VMA pointer flag
VRFLG2		EQU	VRFLG+2		; VMA pointer flag
FCNT		EQU	VRFLG2+2	; frame counter
FRCNT		EQU	FCNT		; ''
;
;-------------- game mode no. ---------------------------------------
GMMODE		EQU	FRCNT+2		; Game Mode select no.
;
;-------------- PPU reg ---------------------------------------------
HD420C		EQU	GMMODE+1	; 420CH
;
NUKCOL		EQU	HD420C+1	; nuki color
;
;-------------- scroll counter --------------------------------------
SCCH1		EQU	NUKCOL+2	; BG-1. H-scroll counter
SCCV1		EQU	SCCH1+2		; BG-1. V-	"
;
SCCH2		EQU	SCCV1+2		; BG-2. H-	"
SCCV2		EQU	SCCH2+2		; BG-2. V-	"
;
SCCH3		EQU	SCCV2+2		; BG-3. H-	"
SCCV3		EQU	SCCH3+2		; BG-3. V-	"
;
SCCH4		EQU	SCCV3+2		; BG-4. H-	"
SCCV4		EQU	SCCH4+2		; BG-4. V-	"
;
;-------------- controller data -------------------------------------
KEYA1L		EQU	SCCV4+2		;	     (X,Y,L,R	       )
KEYA1		EQU	KEYA1L+1	; key repeat (A,B,sl,st,u,d,l,r)
KEYA2L		EQU	KEYA1+1		;
KEYA2		EQU	KEYA2L+1	;     triga
KEYB1L		EQU	KEYA2+1		;
KEYB1		EQU	KEYB1L+1	;
KEYB2L		EQU	KEYB1+1		;
KEYB2		EQU	KEYB2L+1	;
KEYABFL		EQU	KEYB2+1		;     back_up
KEYABF		EQU	KEYABFL+1	;     back_up
KEYBBFL		EQU	KEYABF+1	;
KEYBBF		EQU	KEYBBFL+1	;
;
;-------------- mouse data ------------------------------------------
MOUSEAS		EQU	KEYBBF+1	;MOUSE A KEY
MOUSEAX		EQU	MOUSEAS+1	;MOUSE A X
MOUSEAY		EQU	MOUSEAX+1	;MOUSE A Y
MOUSEBS		EQU	MOUSEAY+1	;MOUSE B KEY
MOUSEBX		EQU	MOUSEBS+1	;MOUSE B X
MOUSEBY		EQU	MOUSEBX+1	;MOUSE B Y
MOUSESPA	EQU	MOUSEBY+1	;MOUSE A SPEED
MOUSESPB	EQU	MOUSESPA+1	;MOUSE A SPEED
MOUSEAT		EQU	MOUSESPB+1	;MOUSE A KEY(TRIGER)
MOUSEAB		EQU	MOUSEAT+1	;MOUSE A KEY(TRIGER WORK)
MOUSEBT		EQU	MOUSEAB+1	;MOUSE B KEY(TRIGER)
MOUSEBB		EQU	MOUSEBT+1	;MOUSE B KEY(TRIGER WORK)
MUSECTX		EQU	MOUSEBB+1	; mouse move check count
MUSECTY		EQU	MUSECTX+1	; mouse move check count
;
;-------------- BG write ram ----------------------------------------
WRSCH1		EQU	MUSECTY+1	;
WRSCV1		EQU	WRSCH1+2	;
SCHMUK		EQU	WRSCV1+2	;
SCHMK1		EQU	SCHMUK		;
SCVMUK		EQU	SCHMUK+2	;
SCVMK1		EQU	SCVMUK		;
;
;-------------- editer ram ------------------------------------------
EDMODE		EQU	SCVMUK+2	; edit mode flg
DTMODE		EQU	EDMODE+1	; data mode ( 0:kotei !=0:kahen )
;
CRXPSL1		EQU	DTMODE+1	;	hi-y-pos
CRXPSH1		EQU	CRXPSL1+1	; arrow low-x-pos (Base)
CRXPSL2		EQU	CRXPSH1+1	;	hi-y-pos
CRXPSH2		EQU	CRXPSL2+1	;		  (counter)
CRYPSL1		EQU	CRXPSH2+1	; arrow hi-x-pos
CRYPSH1		EQU	CRYPSL1+1	;	low-y-pos (Base)
CRYPSL2		EQU	CRYPSH1+1	; arrow hi-x-pos
CRYPSH2		EQU	CRYPSL2+1	;		  (counter)
;
INKEY		EQU	CRYPSH2+1	; key data
INKEY2		EQU	INKEY+1		;
INKEY3		EQU	INKEY2+1	;
;
MVSCH1		EQU	INKEY3+1	; move SCCH1 counter
MVSCV1		EQU	MVSCH1+2	; move SCCV1 counter
;
BGDPFG		EQU	MVSCV1+2	; BG data display flag
SIFTFG		EQU	BGDPFG+1	; shift mode flag
LDFLG		EQU	SIFTFG+1	; load flag
SVFLG		EQU	LDFLG+1		; save	"
DELFLG		EQU	SVFLG+1		; delete "
MPDSFG		EQU	DELFLG+1	; map display flag
STINFG		EQU	MPDSFG+1
;
ERRFLG		EQU	STINFG+1	; error flag
INDTPT		EQU	ERRFLG+2	; BG data type no. cursol pos
INPBUF		EQU	INDTPT+1	;	"          set buffer
;
STDTPT		EQU	INPBUF+2	; course data pointer
INSTPT		EQU	STDTPT+2	; insert pointer
SRCHPT		EQU	INSTPT+2	; search pointer
SRCHNO		EQU	SRCHPT+2	;    "   data pos
;
DTPT		EQU	SRCHNO+2	; now data pos
;
BGDTADR		EQU	DTPT+2		; BG course data address buffer
BGBFPT		EQU	BGDTADR+3	; BG unit buffer pointer
BGDTPT		EQU	BGBFPT+2	; course data convert pointer
;
LKFLG		EQU	BGDTPT+2	; unit set lock flag
;
BGUNDT0		EQU	LKFLG+2		; bg unit no.
BGUNDT1		EQU	BGUNDT0+2	; bg unit no. and #0ff00h
;
;-------------- AADA USED RAM --------------
XYCPBF		EQU	BGUNDT1+2	; X , Y point compear buffer
;
;-------------- file save & load RAM --------------------------------
;;;;K;;;;NAMEPT		EQU	BGUNDT1+2	; file name buffer pointer
NAMEPT		EQU	XYCPBF+2	; file name buffer pointer
NMDTBF0		EQU	NAMEPT+1	;	  "
NMDTBF1		EQU	NMDTBF0+1	;	  "
NMDTBF2		EQU	NMDTBF1+1	;	  "
NMDTBF3		EQU	NMDTBF2+1	;	  "
NMDTBF4		EQU	NMDTBF3+1	;	  "
NMDTBF5		EQU	NMDTBF4+1	;	  "
NMDTBF6		EQU	NMDTBF5+1	;	  "
NMDTBF7		EQU	NMDTBF6+1	;	  "
;
FKOSUU		EQU	NMDTBF7+1	; FILE kosuu
HNUMCT		EQU	FKOSUU+1	; HI NUMBER COUNTER
LNUMCT		EQU	HNUMCT+2	; LOW NUMBER COUNTER
VHLTP		EQU	LNUMCT+2	; VRAMD HI LOW TOP
VHLLT		EQU	VHLTP+2		; VRAMD HI LOW LAST
NMBBUF		EQU	VHLLT+2		; LOAD NUMBER BUFFER
;
;--------------------------------------------------------------------
STATX		EQU	NMBBUF+2	; cursole xpos
STATY		EQU	STATX+2		; cursole ypos
STATCMP		EQU	STATY+2
FRMFLG		EQU	STATCMP+1
DYNFLG		EQU	FRMFLG+1
ERCODE		EQU	DYNFLG+1
;
;--------------------------------------------------------------------
UNDONO		EQU	ERCODE+1	;undo buffer size
UNDOXP1		EQU	UNDONO+2	;  "  save cursol X pos.1
UNDOYP1		EQU	UNDOXP1+2	;	  "       Y   "
UNDOXP2		EQU	UNDOYP1+2	;	  "       X  " .2
UNDOYP2		EQU	UNDOXP2+2	;	  "       Y   "
UNDOSFT		EQU	UNDOYP2+2
;
LASTFG		EQU	UNDOSFT+1	;last input flag
LASTXP		EQU	LASTFG+1	;     "     data start X pos
LASTYP		EQU	LASTXP+2	;	    "          Y  "
;
;-------------- AADA used ram ---------------------------------------
WIDEX		EQU	LASTYP+2	; scroll move X wide
WIDEY		EQU	WIDEX+1		; scroll move Y wide
CRSSMMD		EQU	WIDEY+1		; mouse cursol semi auto mode
;					;	0 -> off
;					;	>0 -> X pos
;					;	<0 -> Y pos
XTAIHI		EQU	CRSSMMD+1	; X point ta-i-hi
YTAIHI		EQU	XTAIHI+2
MSSCRX		EQU	YTAIHI+2
MSSCRY		EQU	MSSCRX+2
;
;-------------- AADA used ram (enmy edit tool used ram) -------------
PLDWFG		EQU	MSSCRY+2	; pull down menuw flag
B2WTHF		EQU	PLDWFG+1	; BG2 H write flag
B2WTVF		EQU	B2WTHF+2	; BG2 V write flag
ENDELFG		EQU	B2WTVF+2	; delete mode use flag
ENDSPFG		EQU	ENDELFG+1	; search data disp set flag
ENMDOBJ		EQU	ENDSPFG+1	; enmy edit mode obj ON flag
ENBGFLG		EQU	ENMDOBJ		; enmy , BG edit mode flag
;;;;;		EQU	ENMDOBJ+1
;
;
;
;-------------- player RAM ------------------------------------------
;;;;K;;;;PLXPSL		EQU	LASTYP+2	;player X pos
PLXPSL		EQU	ENMDOBJ+1	;player X pos
PLYPSL		EQU	PLXPSL+2	;   "   Y  "
;
;
;.............< game mode RAM >..........................................
GMMDRM		EQU	PLYPSL+2
;
BGMODE		EQU	GMMDRM		;[2105] BG mode
BG1SCF		EQU	BGMODE+1	;[2107] BG1 screen status
BG2SCF		EQU	BG1SCF+1	;[2108] BG2	   "
BG3SCF		EQU	BG2SCF+1	;[2109] BG3	   "
BG12CH		EQU	BG3SCF+1	;[210B] BG1,2 chara address
BG34CH		EQU	BG12CH+1	;[210C] BG3,4	   "
WIND23		EQU	BG34CH+1	;[2123] window "ON/OFF" flag ( BG1,2 )
WIND24		EQU	WIND23+1	;[2124]		   "         ( BG3,4 )
WIND25		EQU	WIND24+1	;[2125]		   "         ( OBJ,COLOR )
MANSEL		EQU	WIND25+1	;[212C] main select flag
SUBSEL		EQU	MANSEL+1	;[212D] sub	   "
WMANSL		EQU	SUBSEL+1	;[212E] window main select flag
WSUBSL		EQU	WMANSL+1	;[212F]	   "   sub       "
WIND30		EQU	WSUBSL+1	;[2130] color window "ON/OFF" flag
SUBADF		EQU	WIND30+1	;[2131] main & sub add select flag
;
GMMDRME		EQU	SUBADF+1
GMMDNO		EQU	GMMDRME-GMMDRM
;
;--------------------------------------------------------------------
MOUSWK0		EQU	GMMDRME		;mouse work RAM
;
;--------------------------------------------------------------------
;--------------------------------------------------------------------
;--------------------------------------------------------------------
;--------------------------------------------------------------------
NMITYP		EQU	100H		;NMI type no.
IRQTYP		EQU	NMITYP+2	;IRQ	"
;
SAVECK0		EQU	IRQTYP+2	;file name check data.1 [35]
;
;-------------- save RAM --------------------------------------------
SAVERM		EQU	SAVECK0+1
;
;-------------- file name buffer --------------------------------
FLNMWK		EQU	SAVERM	; FILE NAME WORK
NMPTWK		EQU	FLNMWK+8	; FILE NAME POINTER WORK
;
;-------------- game character bank no. flag --------------------
GMSTATUS	EQU	NMPTWK+2
;
NUKINO		EQU	GMSTATUS	;kLJ[(0-F)
BG1TYP		EQU	NUKINO+2	;afP^Cv(0-F)
BG1COL		EQU	BG1TYP+2	;  h  J[(0-F)
BG2TYP		EQU	BG1COL+2	;afQ^Cv(0-F)
BG2COL		EQU	BG2TYP+2	;  h  J[(0-F)
BG3TYP		EQU	BG2COL+2	;afR^Cv(0-3F)
BG3COL		EQU	BG3TYP+2	;  h  J[(0-F)
OBJTYP		EQU	BG3COL+2	;nai^Cv(0-F)
CHRTRP		EQU	OBJTYP+2	;L]p^[(0-1F)
COLTRP		EQU	CHRTRP+2	;J[]p^[(0-1F)
SCRLNO		EQU	COLTRP+2	;XN[^Cv(0-F)
BGM_NO		EQU	SCRLNO+2	;afl mD(0-F)
CORSNO		EQU	BGM_NO+2	;R[X mD(0-3)
;
PLAYXP		EQU	CORSNO+2	;player start X pos
PLAYYP		EQU	PLAYXP+2	;      "      Y  "
TIMERNO		EQU	PLAYYP+2	;timer
;
SAVERME		EQU	TIMERNO+2
SAVERMN		EQU	SAVERME-SAVERM
;
SAVECK1		EQU	SAVERME		;file name check data.1 [35]
;
;
STACK		EQU	SAVECK1+1	; Stack area
;
;
;-------------- OAM buffer ------------------------------------------
OAM		EQU	0200H		; OAM main
OAM2		EQU	0300H		;	   + 100H
OAMSUB		EQU	OAM+200H	;     sub
OAMSB		EQU	OAMSUB+20H	;     work sub
OAMSB2		EQU	OAMSB+040H	;	       + 40H
;
;-------------- use OAM pos -----------------------------------------
ARROAM		EQU	OAM		; arrow OAM-0
AR1OAM		EQU	OAM+4*1		;	   -1
LASOAM		EQU	OAM+4*2		; last input data pos
XYPOAM		EQU	OAM+4*16	; x,y-position OAM
SMDOAM		EQU	XYPOAM+4*8	; set mode OAM
UTNOAM		EQU	SMDOAM+4*19	; unit no. OAM
;;;;K;;;;UTNOAM		EQU	SMDOAM+4*15	; unit no. OAM
PTDOAM		EQU	UTNOAM+4*2	; PT & unit no. OAM
MODOAM		EQU	PTDOAM+4*25	; mode OAM
CHCOAM		EQU	MODOAM+4*6
;
DWOAM		EQU	OAM2		; window OAM
;
;
;;;;;;;;;; Save,Load mode
CUROAM		EQU	300H		; cursol OAM
NAMOAM		EQU	304H		; name OAM
;
;
;-------------- game play RAM -------------------------------------------
PLXP21		EQU	OAMSB+80H	;old player X pos
PLYP21		EQU	PLXP21+2	;     "     Y  "
PSCENT		EQU	PLYP21+2	;player scroll center pos
MXSCCV1		EQU	PSCENT+2	;max scroll counter_V
;
;-------------< couse BG data write RAM >--------------------------------
WSCCH1		EQU	MXSCCV1+2
WSCCV1		EQU	WSCCH1+2
;
WRSCH2		EQU	WSCCV1+2	;	    "           BG2_H        "
WRSCV2		EQU	WRSCH2+2	;	     "             _V        "
SCHMK2		EQU	WRSCV2+2	;	     "          BG1_H scroll muki
SCVMK2		EQU	SCHMK2+2	;	     "             _V      "
BGWHF1		EQU	SCVMK2+2	;BG1_H screen write "ON/OFF" flag
BGWVF1		EQU	BGWHF1+2	; " _V            "
BGWHF2		EQU	BGWVF1+2	;BG2_H		  "
BGWVF2		EQU	BGWHF2+2	; " _V            "
BGWAH1_0	EQU	BGWVF2+2	;BG1 screen write VRAM address( H_scroll ).1
BGWAV1_00	EQU	BGWAH1_0+2	;	       "              ( V   "	 )
BGWAH2_0	EQU	BGWAV1_00+2	;BG2	       "              ( H   "	 )
BGWAV2_00	EQU	BGWAH2_0+2	;	       "              ( V   "	 )
BGWAH1_1	EQU	BGWAV2_00+2	;BG1	       "              ( H_scroll ).2
BGWAV1_10	EQU	BGWAH1_1+2	;	       "              ( V   "	 )
BGWAH2_1	EQU	BGWAV1_10+2	;BG2	       "              ( H   "	 )
BGWAV2_10	EQU	BGWAH2_1+2	;	       "              ( V   "	 )
BGWNO1_0	EQU	BGWAV2_10+2	;BG1	       "              ( H_scroll ).3
BGWAV1_01	EQU	BGWNO1_0+2	;	       "              ( V   "	 )
BGWNO2_0	EQU	BGWAV1_01+2	;BG2	       "              ( H   "	 )
BGWAV2_01	EQU	BGWNO2_0+2	;	       "              ( V   "	 )
BGWNO1_1	EQU	BGWAV2_01+2	;BG1	       "              ( H_scroll ).4
BGWAV1_11	EQU	BGWNO1_1+2	;	       "              ( V   "	 )
BGWNO2_1	EQU	BGWAV1_11+2	;BG2	       "              ( H   "	 )
BGWAV2_11	EQU	BGWNO2_1+2	;	       "              ( V   "	 )
;
BG3WSCV		EQU	BGWAV2_11+2	;BG3 screen write scroll counter_V
;
BGHSCRBF	EQU	BG3WSCV+2		;H_scroll write buffer
BGVSCRBF	EQU	BGHSCRBF+20H*2*2	;V	    "
;;;;		EQU	BGVSCRBF+22H*2*2
;
;
;--------------------------------------------------------------------
FLDBUF		EQU	0800H
fldbuf		EQU	FLDBUF+0800H
;
;--------------------------------------------------------------------
;
;------------ AADA used ram (enmy edit mode use) --------------------
ENNAMCT		EQU	000800H		; enmy name buffer count
ENNAMBF		EQU	000802H		; enmy name buffer
;			  |
;			0009FFH
;
B2WTADH		EQU	000B00H		; BG2 write address (H scroll)
B2ENWTH		EQU	B2WTADH+2	; BG2 write data
B2WTADV		EQU	B2ENWTH+040H	; BG2 write address (V scroll)
B2ENWTV		EQU	B2WTADV+2	; BG2 write data
ENINKYBF	EQU	B2ENWTV+040H	; inkey buffer
ENUNDBF		EQU	ENINKYBF+1	; enmy data undo buffer
FLNMBF		EQU	ENUNDBF+0AH	; file name buffer
;
;;;;K;;;;FLNMBF		EQU	00E00H		; file name buffer
FNBIDX		EQU	FLNMBF+0340H	; file name buffer index
MJIDX0		EQU	FNBIDX+1	; mo-ji buffer index 0
MJIDX1		EQU	MJIDX0+1	;	"       "    1
MJIDX2		EQU	MJIDX1+1	;	"       "    2
MOJBF0		EQU	MJIDX2+1	; mo-ji disp buffer 0
MOJBF1		EQU	MOJBF0+8	;	"       "   1
MOJBF2		EQU	MOJBF1+8	;	"       "   2
SCRLBF		EQU	MOJBF2+8	; file name scroll buffer
ENMYNO		EQU	SCRLBF+2	; enmy NO.
ENNOFLS		EQU	ENMYNO+2	; enmy NO. flash counter
ENDTPT		EQU	ENNOFLS+1	; enmy data buffer index
SRCPOS		EQU	ENDTPT+2	; enmy data buffer point (search)
ENNAM0		EQU	SRCPOS+2	; enmy name buffer 0
ENNAM1		EQU	ENNAM0+1	;	"       "  1
ENNAM2		EQU	ENNAM1+1	;	"       "  2
ENNAM3		EQU	ENNAM2+1	;	"       "  3
ENNAM4		EQU	ENNAM3+1	;	"       "  4
ENMDFG0		EQU	ENNAM4+1	; file mode flag
;;;;K;;;;ENMDFG0		EQU	00F00H		; file mode flag
ENMDFG1		EQU	ENMDFG0+1	; ma-e-no file mode flag
RDFLDT		EQU	ENMDFG1+1	; read file data flag
GMMDBF		EQU	RDFLDT+1	; game mode ta-i-hi buffer
;;;;;		EQU	GMMDBF+1
;
;--------------------------------------------------------------------
;
;--------------------------------------------------------------------
VRAMD		EQU	1000H		; VRAM_area
VRAMD2		EQU	VRAMD+2
VRAMDX		EQU	VRAMD+0C00H
;
;--------------------------------------------------------------------
RUT0000		EQU	1800H
;
;--------------------------------------------------------------------
;
;--------------------------------------------------------------------
;
;
;====================================================================
;;SFX-DOS	EQU	1E00H		; ~ 1FFFH
;====================================================================
;
;
;====================================================================
;====================================================================
CHARSUU		EQU	040H
UNITSUU		EQU	16+4
;
;-------------- AADA USED RAM -----------------------------------
ENMYDTBF	EQU	07F2000H	; enmy data index (L) 07F2000H
ENDTBF		EQU	07F2002H	;		  (H) 07F2001H
;					; enmy data 07F2002H
;					;		|
;					;	    07F26FFH
;
;
UNBUFAD		EQU	07F4000H
;
;
;-------------- unit buffer -----------------------------------------
NXGOTOBF	EQU	7E7E00H
BGUNIT		EQU	NXGOTOBF+(16*8*4)
;
;-------------- course data buffer ----------------------------------
COURSEDT	EQU	7F0000H
DTBUFF		EQU	COURSEDT+7
DTBUFF2		EQU	7F4000H
;
UNDOBUF		EQU	7F8000H		;to undo data back_up RAM
;
;.............. enemy data buffer ...................................
ENBGDTBF	EQU	7F8000H		; enmy set BG data buffer
;;;;;		EQU	7FFFFFH
;
;--------------------------------------------------------------------
;
;
;-------------- pless data convert buffer ---------------------------
WORKBF		EQU	7E7000H
DATACOL		EQU	WORKBF
;
;
;%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
;--------------------------------------------------------------------
;
;
