;************************************************************************
;*									*
;*	title name	: "yossy tool"					*
;*	proccess	: status data set				*
;*	file name	: yst_stat					*
;*									*
;************************************************************************
;
;
		SALL
;
		include		yst_header.inc
;
		XALL
;
;
;------------------------------------------------------------------------
;
;		Super_Y edit-tool		1992.03.05(THU)
;
;------------------------------------------------------------------------
;
		ORG	02D000H
;
;=============================================== (syt_dmap) =============
		GLB	STATIN
;=============================================== (syt_main) =============
		EXT	JSRSUB
;=============================================== (syt_init) =============
		EXT	BGWR
;=============================================== (syt_edit) =============
		EXT	PSCTDT1
;=========================================================================
;
		EXTEND
		MEM8
		IDX8
;
;
;
;
;
;
;************************************************************************
;*		Data display mode			(DTDISP)	*
;************************************************************************
;
;
STATIN		EQU	$
		PHB
		PHK
		PLB
		JSR	STATIN1
		PLB
		RTL
;
;
STATIN1		EQU	$
		LDA	<STINFG
		JSL	>JSRSUB
		WORD	STATIN000		;00
		WORD	STATIN200		;01
;
;
;
;========================================================================
;=		Init. display				(DTDP000)	=
;========================================================================
		MEM8
		IDX8
STATIN000	EQU	$
;
;-------------- BG color set ----------------------------
		STZ	2121H			;CGRAM address set
;
		M16
;
		LDA	#00000000B+(22H*100H)	;DMA parameter & B bus address
		STA	4300H
		LDA	#1CC000H		;A bus address(L,H)
		STA	4302H
		LDY	#BANK 1CC000H		;	"     (B)
		STY	4304H
		LDA	#0100H			;number of byte
		STA	4305H
		LDX	#00000001B
		STX	420BH			;DMA "ON"
;
;-------------- BG3 screen set --------------------------
		LDY	#10000000B	;inc mode
		STY	2115H
		LDA	#7400H
		STA	2116H		; VRAM address set
		LDA	#00000001B+(18H*100H)
		STA	4300H		; parameter & B bus address
		LDA	#1CB000H
		STA	4302H		; A bus address (L,H)
		LDY	#BANK 1CB000H
		STY	4304H		;		(B)
		LDA	#1000H
		STA	4305H		; number of byte
		STX	420BH		; DMA "on"
;
;-------------- next initial --------------------------
		LDA	#0001CH
		STA	<STATX
		STZ	<STATY

LOOP0		EQU	$

		JSR	ZERODISP

		LDA	<STATY
		CLC
		ADC	#00002H
		STA	<STATY
		CMP	#13*2
		BNE	LOOP0
;
		LDA	#0001CH
		STA	<STATX
		STZ	<STATY

		MI8
		LDA	#012H
		STA	<STATCMP
;
;-------------- map mode initial flag set ---------------
		LDA	#00010100B	;main select ( BG3,OBJ )
		STA	<MANSEL		; 212CH
		STZ	<WMANSL		;window "OFF"
		STZ	WIND23
		STZ	WIND24
		STZ	WIND25
;
		STZ	<SCCH3		;BG3 scroll counter set
		STZ	<SCCH3+1
		STZ	<SCCV3
		STZ	<SCCV3+1
		LDA	#00001111B
		STA	<BLKFLG		; 2100H
		LDA	#076H
		STA	2109H
		INC	<STINFG
		RTS
;----------------------------------------------------------
;
;========================================================================
;=		Move					(STATIN200)	=
;========================================================================
		MEM8
		IDX8
STATIN200	EQU	$
;
;
;
;
;-------------- cursol move -----------------------------
		LDA	<FRCNT
		AND	#010H
		BEQ	STATIN010

		LDA	<STATX
		AND	#001H
		PHA
		ASL	A
		ASL	A
		ASL	A
		CLC
		ADC	#0E0H
		STA	!OAM		; x-pos. set
;
		LDA	<STATY
		TAX
		CMP	#008H
		BCC	STATIN203
		CMP	<STATCMP
		BCS	STATIN202

		LDA	#008H
		BRA	STATIN203
STATIN202	EQU	$
		SEC
		SBC	#0AH
STATIN203	EQU	$
		ASL	A
		ASL	A
		STA	<WORK0
		ASL	A
		CLC
		ADC	#017H
		CLC
		ADC	<WORK0
		STA	!OAM+1		; y-pos. set
;
		PLA
		BNE	STATIN205

		LDA	GMSTATUS,X
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		CMP	#00AH
		BCC	STATIN208
		BRA	STATIN007
STATIN205	EQU	$
		LDA	GMSTATUS,X
		AND	#00FH
		CMP	#009H
		BCC	STATIN208
STATIN007	EQU	$
		CLC
		ADC	#007H
STATIN208	EQU	$
		CLC
		ADC	#030H
		STA	!OAM+2		; char. no. set
		LDA	#032H
		STA	!OAM+3		; attribute set
;
		LDA	#00000000B	;OAM sub set
		STA	OAMSUB

;
;-------------- input check -----------------------------
STATIN010	EQU	$

		LDA	<INKEY
		CMP	#CHC
		BNE	STATIN210		;return ? ( no:DTDP210 )
;
;-------------- return set ----------------------
;
;
		LDA	#BGWR
		STA	<GMMODE
		LDA	#074H
		STA	2109H
		RTS
;
;
;
;
;
		MEM8
		IDX8
STATIN210	EQU	$
		LDA	<INKEY
		CMP	#NUL
		BEQ	STATIN240
		CMP	#L_G
		BCS	STATIN240

STATIN220	EQU	$
		CMP	#SU0
		BCS	KEYDISP

STATIN240	EQU	$
		LDA	<INKEY2
		CMP	#UPP
		BEQ	CURMOV_U
		CMP	#DWN
		BEQ	CURMOV_D

		MI8
		RTS
;
		MEM8
		IDX8
CURMOV_D	EQU	$
		M16
		LDA	<STATY
		CMP	#00018H
		BCS	CURMOV_UD200
		CMP	#00008H
		BCC	CURMOV_D100
		CMP	#00012H
		BCS	CURMOV_D100

		LDA	<SCCV3
		CLC
		ADC	#00018H
		STA	<SCCV3

CURMOV_D100	EQU	$
		LDA	<STATY
		CLC
		ADC	#00002H
		STA	<STATY

		M8
		LDA	#012H
		STA	<STATCMP
		M16
		BRA	CURMOV_UD000
;
		MEM8
		IDX8
CURMOV_U	EQU	$
		M16
		LDA	<STATY
		BEQ	CURMOV_UD200
		CMP	#0000AH
		BCC	CURMOV_U100
		CMP	#00014H
		BCS	CURMOV_U100

		LDA	<SCCV3
		SEC
		SBC	#00018H
		STA	<SCCV3

CURMOV_U100	EQU	$
		LDA	<STATY
		SEC
		SBC	#00002H
		STA	<STATY

		M8
		LDA	#012H
		STA	<STATCMP
		M16

CURMOV_UD000	EQU	$
		LDA	#0001CH
		STA	<STATX

		LDX	<STATY
		LDA	GMSTATUS,X
		BNE	CURMOV_UD200

		JSR	ZERODISP
CURMOV_UD200	EQU	$

		MI8
		RTS
;
		MEM8
		IDX8
KEYDISP		EQU	$
		STA	<WORK2

		LDA	<STATX
		PHA

		JSR	CHECK_DATA
		MEM8
;		IDX8

		PLA
		CMP	<STATX
		BEQ	KEYDISP100
		STA	<WORKA
		STZ	<WORKB

		LDA	#004H
		STA	<WORK3
		MI16
;
		LDY	VRAMD
		LDA	<STATY
		TAX
		ASL	A
		ASL	A
		ASL	A
		ASL	A
		STA	<WORK4
		ASL	A
		STA	<WORK6

		LDA	#7400H+060H		;(WK0,1) <-- start VRAM address set
		CLC
		ADC	<WORKA
		CLC
		ADC	<WORK4
		CLC
		ADC	<WORK6
		STA	VRAMD+2,Y	;VRAM address set

		LDA	#001H
		STA	VRAMD+4,Y	;number of byte set

		LDA	<WORK2
		STA	VRAMD+6,Y	;chara no. set
;
		LDA	#0FFFFH
		STA	VRAMD+8,Y	;end code set

		LDA	VRAMD
		CLC
		ADC	#00006H
		STA	VRAMD

		MI8
KEYDISP100	EQU	$
		RTS
;
		MEM8
		IDX8
ZERODISP	EQU	$
		MI16
		LDY	VRAMD
		LDA	<STATY
		TAX
		ASL	A
		ASL	A
		ASL	A
		ASL	A
		STA	<WORK4
		ASL	A
		STA	<WORK6

		LDA	#7400H+060H		;(WK0,1) <-- start VRAM address set
		CLC
		ADC	<STATX
		CLC
		ADC	<WORK4
		CLC
		ADC	<WORK6
		STA	VRAMD+2,Y	;VRAM address set

		LDA	#00003H
		STA	VRAMD+4,Y	;number of byte set

		LDA	GMSTATUS,X
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		CMP	#0000AH
		BCC	ZERODISP208
		CLC
		ADC	#00007H
ZERODISP208	EQU	$
		CLC
		ADC	#00430H
		STA	VRAMD+6,Y	;chara no. set

		LDA	GMSTATUS,X
		AND	#0000FH
		CMP	#0000AH
		BCC	ZERODISP209
		CLC
		ADC	#00007H
ZERODISP209	EQU	$
		CLC
		ADC	#00430H
		STA	VRAMD+8,Y	;chara no. set
;
		LDA	#0FFFFH
		STA	VRAMD+10,Y	;end code set

		LDA	VRAMD
		CLC
		ADC	#0008H
		STA	VRAMD

		RTS
;
		MEM8
		IDX8
CHECK_DATA	EQU	$
		LDA	<STATY
		TAX
		LSR	A
		TAY

		LDA	<STATX
		AND	#001H
		BEQ	CHECK_DT000

		LDA	<INKEY
		CMP	#040H
		BCS	CHECK_DT50
		AND	#00FH
		BRA	CHECK_DT80
CHECK_DT50	EQU	$
		SEC
		SBC	#037H
CHECK_DT80	EQU	$

		CMP	CHKDT_L,Y
		BCS	CHECK_DT400

		STA	<WORK0
		STZ	<WORK1

		M16
		LDA	GMSTATUS,X
		AND	#000F0H
		ORA	<WORK0
		STA	GMSTATUS,X

		LDA	#0001CH
		BRA	CHECK_DT200

		MEM8
CHECK_DT000	EQU	$
		LDA	<INKEY
		CMP	#040H
		BCS	CHECK_DT150
		AND	#00FH
		BRA	CHECK_DT180
CHECK_DT150	EQU	$
		SEC
		SBC	#037H
CHECK_DT180	EQU	$

		CMP	CHKDT_H,Y
		BCS	CHECK_DT400

		ASL	A
		ASL	A
		ASL	A
		ASL	A
		STA	<WORK0
		STZ	<WORK1

		M16
		LDA	GMSTATUS,X
		AND	#0000FH
		ORA	<WORK0
		STA	GMSTATUS,X

		LDA	#0001DH
CHECK_DT200	EQU	$
		STA	<STATX

		M8
CHECK_DT400	EQU	$
		RTS
;
CHKDT_L		EQU	$
		BYTE	010H	;kLJ[(0-F)
		BYTE	010H	;afP^Cv(0-F)
		BYTE	010H	;  h  J[(0-F)
		BYTE	010H	;afQ^Cv(0-F)
		BYTE	010H	;  h  J[(0-F)
		BYTE	010H	;afR^Cv(0-3F)
		BYTE	010H	;  h  J[(0-F)
		BYTE	010H	;nai^Cv(0-F)
		BYTE	010H	;L]p^[(0-1F)
		BYTE	010H	;J[]p^[(0-1F)
		BYTE	010H	;XN[^Cv(0-F)
		BYTE	010H	;afl mD(0-F)
		BYTE	004H	;R[X mD(0-3)
;
CHKDT_H		EQU	$
		BYTE	001H	;kLJ[(0-F)
		BYTE	001H	;afP^Cv(0-F)
		BYTE	001H	;  h  J[(0-F)
		BYTE	001H	;afQ^Cv(0-F)
		BYTE	001H	;  h  J[(0-F)
		BYTE	004H	;afR^Cv(0-3F)
		BYTE	001H	;  h  J[(0-F)
		BYTE	001H	;nai^Cv(0-F)
		BYTE	002H	;L]p^[(0-1F)
		BYTE	002H	;J[]p^[(0-1F)
		BYTE	001H	;XN[^Cv(0-F)
		BYTE	001H	;afl mD(0-F)
		BYTE	001H	;R[X mD(0-3)
;
;RTN		EQU	00DH		; [return]
;TAB		EQU	08BH		; [TAB]
;ESC		EQU	08CH		; [ESC]
;UPP		EQU	01CH		; [up	 key]
;DWN		EQU	01DH		; [down	 key]
;LEF		EQU	01EH		; [left	 key]
;RIT		EQU	01FH		; [right key]
;
		END

