;************************************************************************
;*									*
;*	title name	: "yossy tool"					*
;*	proccess	: course data file access process		*
;*	file name	: yst_svld					*
;*									*
;************************************************************************
;
;
		SALL
;
		include		yst_header.inc
;
		XALL
;
;
;------------------------------------------------------------------------
;
;		Super_Y edit-tool		1992.03.05(THU)
;
;------------------------------------------------------------------------
;
		ORG	02E000H
;
;=============================================== (yst_svld) =============
		GLB	FORMAT,DTSAVE,DTLOAD,DTDEL
		GLB	DTSHARE
;=============================================== (yst_main) ==============
		EXT	JSRSUB,JSRSUBL,OAMCLR,DTBFCLR,DTBFCLR1
;=============================================== (yst_init) ==============
		EXT	PLMD,BGWR
;=============================================== (yst_edit) ==============
		EXT	INPTDT,UNITST
;=============================================== (yst_vma) ==============
		EXT	VRAMCL
;=========================================================================
;
		EXTEND
		MEM8
		IDX8
;
;
;
;************************************************************************
;*		Media Format				(FORMAT)	*
;************************************************************************
FORMAT		EQU	$
		PHB
		PHK
		PLB
		JSR	FORMAT1
		PLB
		RTL
;
;--------- FORMAT1 ----------
FORMAT1		EQU	$
		LDA	<FRMFLG
		JSL	>JSRSUB
		WORD	FORMPL		;00 format mode
		WORD	FORM		;01 formating
;
FORMDT		EQU	$
		BYTE	040H,0B8H,046H,03CH	;F
		BYTE	048H,0B8H,04FH,03CH	;O
		BYTE	050H,0B8H,052H,03CH	;R
		BYTE	058H,0B8H,04DH,03CH	;M
		BYTE	060H,0B8H,041H,03CH	;A
		BYTE	068H,0B8H,054H,03CH	;T
;
		BYTE	078H,0B8H,04FH,03CH	;O
		BYTE	080H,0B8H,04BH,03CH	;K
		BYTE	088H,0B8H,03FH,03CH	;?
;
		BYTE	098H,0B8H,059H,03CH	;Y
		BYTE	0A0H,0B8H,02FH,03CH	;/
		BYTE	0A8H,0B8H,04EH,03CH	;N
FORMDTE		EQU	$
;
FORMDT2		EQU	$
		BYTE	040H,0C0H,04EH,03CH	;N
		BYTE	048H,0C0H,04FH,03CH	;O
		BYTE	050H,0C0H,057H,03CH	;W
;
		BYTE	060H,0C0H,046H,03CH	;F
		BYTE	068H,0C0H,04FH,03CH	;O
		BYTE	070H,0C0H,052H,03CH	;R
		BYTE	078H,0C0H,04DH,03CH	;M
		BYTE	080H,0C0H,041H,03CH	;A
		BYTE	088H,0C0H,054H,03CH	;T
		BYTE	090H,0C0H,049H,03CH	;I
		BYTE	098H,0C0H,04EH,03CH	;N
		BYTE	0A0H,0C0H,047H,03CH	;G
		BYTE	0A8H,0C0H,02EH,03CH	;.
		BYTE	0B0H,0C0H,02EH,03CH	;.
FORMDTE2	EQU	$

;
;
;-------------	Save media format -------------
		MEM8
		IDX8
FORMPL		EQU	$
		MEM16
		REP	#00100000B	; memory 16bit mode
;
		LDX	#FORMDTE-FORMDT-2
FRMDSP000	EQU	$
		LDA	>FORMDT,X
		STA	!OAM,X
		DEX
		DEX
		BPL	FRMDSP000
;
		STZ	!OAMSUB+0
		STZ	!OAMSUB+2
		STZ	!OAMSUB+4
;
;
		MEM8
		SEP	#00100000B	; memory 8bit mode
;
		LDA	<INKEY
		CMP	#FRM		; [F2]
		BEQ	FORM010		; yes... return
		CMP	#L_N		; [N]
		BNE	FORM000		; no...	 FORM000
FORM010		EQU	$		; yes... return
		STZ	<FRMFLG

		LDA	#PLMD
		STA	<GMMODE
		RTS
;
FORM000		EQU	$
		CMP	#L_Y		; [Y]
		BNE	FORM200		; no...	 FORM200
;
		MEM16
		REP	#00100000B	; memory 16bit mode
;
		LDX	#FORMDTE2-FORMDT2-2
FRMDSP100	EQU	$
		LDA	>FORMDT2,X
		STA	!OAM,X
		DEX
		DEX
		BPL	FRMDSP100
;
		STZ	!OAMSUB+0
		STZ	!OAMSUB+2
		STZ	!OAMSUB+4
;
		MEM8
		SEP	#00100000B	; memory 8bit mode

		INC	<FRMFLG
FORM200		EQU	$
		RTS


FORM		EQU	$
		LDA	<ERCODE
		BNE	FRM0010		;error code in key on wait?
;					;    (YES goto SV0010)
		LDA	#002H
		DOS	_DSKRST		;disk reset
;
		DOS	_FORMAT		;format
;
		CMP	#000H
		BEQ	FORM010		;error?
;					;    (NO goto FRM0020)
		STA	<ERCODE		;error code set
FRM0010		EQU	$
		JSR	MSVERR		;error messege oam set sub go!!
		LDA	INKEY3
		CMP	#NUL
		BEQ	FRM0020		;any key input?
;					;    (NO goto FRM0020)
		STZ	<ERCODE		;error code clear
FRM0020		EQU	$
		LDA	<ERCODE
		BEQ	FORM010		;error code set?

		RTS

;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;************************************************************************
;*		Data save				(DTSAVE)	*
;************************************************************************
DTSAVE		EQU	$
		PHB
		PHK
		PLB
		JSR	DTSAVE1
		PLB
		RTL
;
;--------- DTSAVE1 ----------
DTSAVE1		EQU	$
		LDA	<SVFLG
		JSL	>JSRSUB
		WORD	DTSVINT		;00
		WORD	DTSVPL		;01   data save set
		WORD	DTSVCHK		;02   save check
		WORD	MSGWR		;03   message write
		WORD	DTSV		;04   now saving
		WORD	DTSVCL		;05   save disply clear
		WORD	OLDFILE_DEL	;06   old file delete
;
;
;
;-------------	Data save init. -------------
		MEM8
		IDX8
DTSVINT		EQU	$
		LDX	#007H
		LDA	#020H
DTSVI020	EQU	$
		STA	<NMDTBF0,X
		DEX
		BPL	DTSVI020
;
		STZ	<NAMEPT		;file name counter clear

;		LDA	FNAME0		;system not load or save
;		CMP	#035H		;
;		BNE	DTSVI040	;
;					;
;		LDA	FNAME1		;
;		CMP	#053H		;
;		BNE	DTSVI040	;

		LDX	NMPTWK		;trans. old file name to new file name
		BEQ	DTSVI040
DTSVI030	EQU	$		;
		LDA	FLNMWK,X	;
		STA	<NMDTBF0,X	;
		DEX			;
		BPL	DTSVI030	;
					;
		LDA	NMPTWK		;
		STA	<NAMEPT		;

DTSVI040	EQU	$
		STZ	<ERCODE		;err code clear
		STZ	<DYNFLG		;over write flag clear
		INC	<SVFLG

		RTS
;
;
;
;
;
;-------------	data save play -------------
SAVDSDT		EQU	$
		BYTE	028H,0ACH,0C6H,03CH
		BYTE	038H,0ACH,0C8H,03CH
		BYTE	048H,0ACH,0CAH,03CH
;
;
		BYTE	070H,0ACH,007H,03CH
		BYTE	080H,0ACH,009H,03CH
		BYTE	090H,0ACH,009H,03CH
		BYTE	0A0H,0ACH,009H,03CH
		BYTE	0B0H,0ACH,00AH,03CH
;
		BYTE	070H,0BCH,002H,03CH
		BYTE	080H,0BCH,004H,03CH
		BYTE	090H,0BCH,004H,03CH
		BYTE	0A0H,0BCH,004H,03CH
		BYTE	0B0H,0BCH,005H,03CH
SAVDTE		EQU	$
;
;
;
;--------- DTSVPL ----------
DTSVPL		EQU	$
		MEM16
		REP	#00100000B	; memory 16bit mode
;
		LDX	#SAVDTE-SAVDSDT-2
DSP0000		EQU	$
		LDA	>SAVDSDT,X
		STA	!OAM,X
		DEX
		DEX
		BPL	DSP0000
;
		LDA	#1010101010101010B
		STA	!OAMSUB
		LDA	#0000001010101010B
		STA	!OAMSUB+2
		STZ	!OAMSUB+18
;
		MEM8
		SEP	#00100000B	; memory 8bit mode
;
		LDA	<DYNFLG
		BEQ	DSP0050		;over write flag on?
;					;    (NO goto DSP0050)
		JMP	OVWSET		;over write yes,no sub go!!
DSP0050		EQU	$
		LDA	<INKEY
		CMP	#SAV
		BNE	DSP0100		; [F_3] key ?
;					; yes
		JMP	DTSVEND
;
DSP0100		EQU	$
		CMP	#STT
		BEQ	DSP0400		; [F_10] key ?
;					; no
;
		LDA	<INKEY2
		CMP	#RIT
		BNE	DSP0140		; right key ?
;					; yes
		LDA	<NAMEPT
		INC	A
		AND	#00000111B
		STA	<NAMEPT
		BRA	DSP0300
DSP0140		EQU	$
		CMP	#LEF
		BNE	DSP0200		; left key ?
;					; yes
		LDA	<NAMEPT
		BNE	DSP0141

		TAX
		LDA	#020H
		STA	<NMDTBF0,X
		BRA	DSP0300

DSP0141		EQU	$
		DEC	A
		STA	<NAMEPT
		TAX

		LDA	#020H
		STA	<NMDTBF0+1,X

		BRA	DSP0300
;
DSP0200		EQU	$
		CMP	#RTN
		BNE	DSP0300		; [RETURN] key ?
;					; yes
		STZ	<NAMEPT

		LDX	#007H
		LDA	#020H
DSP0250		EQU	$
		STA	<NMDTBF0,X
		DEX
		BPL	DSP0250

		LDA	#NUL
		STA	<INKEY3
DSP0300		EQU	$
		JSR	NAMEST
		RTS
;
;
;******** DSP0400 ********
DSP0400		EQU	$		;*** file already exist check ***
		LDX	#007H

DSP0401		EQU	$
		LDA	<NMDTBF0,X
		CMP	#08EH
		BNE	DSP0402

		LDA	#020H
		STA	<NMDTBF0,X

DSP0402		EQU	$
		DEX
		BPL	DSP0401

		JSR	NMNTSB		;file name = all space ?
		LDA	<ERCODE		;
		BEQ	DSP0405		;  no: DSP0405
;
		RTS
DSP0405		EQU	$
		JSR	DIRSUB1		;FLBUF <- file directory set sub go!!
;
		MEM16
		IDX16
		REP	#00110000B	; memory,index 16bit mode
;
		LDX	#0000H
		TXY			;index clear
		STX	<WORK0		;next data index ram clear
DSP0410		EQU	$
		LDA	FLDBUF,X
		CMP	NMDTBF0,Y
		BNE	DSP0420		;file name = input name (moji equll)?
;					;    (NO goto DSP0420)
		INX
		INX
		INY
		INY
		CPY	#0008H
		BEQ	DSP0600		;all moji equal?
;					;    (YES goto DSP0600)
		BRA	DSP0410		;next moji check
;
DSP0420		EQU	$
		LDA	<WORK0		;file index load
		CLC
		ADC	#0008H		;next moji index comp
		CMP	#0800H
		BEQ	DSP0430		;file name buffer end?
;					;    (YES goto DTS0430)
		STA	<WORK0
		TAX			;next file index set
		LDY	#0000H		;index claer
		BRA	DSP0410		;next file check
;
DSP0430		EQU	$
		MEM8
		IDX8
		SEP	#00110000B	; memory,index 8bit mode
;
		JMP	DTS0800		;save sub go!!
;
;
;
;******** DSP0600 ********
DSP0600		EQU	$		;*** over write check 0 ***
		MEM8
		IDX8
		SEP	#00110000B	; memory,index 8bit mode
;
		LDA	#001H
		STA	<DYNFLG		;over write flag on
		RTS
;
;******** OVWSET ********
OVWSET		EQU	$		;*** over write check 1 ***
		MEM16
		REP	#00100000B	; memory 16bit mode
;
		LDX	#SOWSDTE-SOWSDT-2
OVW0610		EQU	$
		LDA	>SOWSDT,X
		STA	!OAM+4*13,X	;"over write ok (y/n)?" messege set
		DEX
		DEX
		BPL	OVW0610		;oam set end?
;					;    (NO goto OVW0610)
		LDA	#0000001010101010B
		STA	!OAMSUB+2
		LDA	#0000000000000000B
		STA	!OAMSUB+4
;
		MEM8
		SEP	#00100000B	; memory 8bit mode
;
		LDA	<FRCNT		;get data tenmetu
		AND	#00001000B
		BEQ	OVW0630		;tenmetu flame?
;					;    (NO goto OVW0630)
		LDX	#SOWSDTE-SOWSDT-2
		LDA	#0F0H
OVW0620		EQU	$
		STA	!OAM+4*13+1,X	;ypos clear set
		DEX
		DEX
		BPL	OVW0620		;oam set end?
		STZ	!OAMSUB+4
		STZ	!OAMSUB+5
		STZ	!OAMSUB+6
		STZ	!OAMSUB+7
;					;    (NO goto OVW0620)
OVW0630		EQU	$
		LDX	<INKEY3
		CPX	#L_Y
		BEQ	DTS0810		;Y key on?
;					;    (YES goto DTS0810)
		CPX	#NUL
		BNE	OVW0640		;any key push?
;					;    (YES goto OVW0640)
		JMP	NAMEST
OVW0640		EQU	$
		STZ	<DYNFLG		;over write flag clear
		RTS
;
;
;******** DTS0800 ********
DTS0810		EQU	$
		INC	<SVFLG
DTS0800		EQU	$		;*** save sub ***
		JSR	BUFFSET

		STZ	NMPTWK		;name pointer work clear
		LDX	#007H
DTS0820		EQU	$
		LDA	<NMDTBF0,X
		CMP	#08EH		;moji = blink space ?
		BNE	DTS0821		;  no: DTS0821

		LDA	#020H		;moji <- space
		STA	<NMDTBF0,X	;

DTS0821		EQU	$
		STA	1EE0H,X
		STA	FLNMWK,X	;file name work set
		CMP	#020H		;moji = space ?
		BEQ	DTS0825		; yes: DTS0825

		INC	NMPTWK		;name pointer work inc.

DTS0825		EQU	$
		DEX
		BPL	DTS0820

;		LDA	#035H		;old file name used flag set
;		STA	FNAME0		;
;		LDA	#053H		;
;		STA	FNAME1		;
;
		LDA	#044H		;D
		STA	1EE0H+8
		LDA	#041H		;A
		STA	1EE0H+9
		LDA	#054H		;T
		STA	1EE0H+10
		LDA	#LOW  COURSEDT	;LOW
		STA	1EE0H+16
		LDA	#HIGH COURSEDT	;HI
		STA	1EE0H+17
		LDA	#BANK COURSEDT	;BANK
		STA	1EE0H+18
;
		MEM16
		REP	#00100000B
;		LDA	#0400H
		LDA	<STDTPT
		CLC
		ADC	#007H+1
		STA	1EE0H+20	;SIZE
;
;
		MEM8
		SEP	#00100000B
;
		STZ	<FRCNT		;next flame frassing clear
		LDA	#NUL
		STA	INKEY3		;Y key code clear
		JSR	NAMEST

		LDA	<DYNFLG		;over write ?
		BEQ	DTS0828		;  no: DTS0828

		LDA	#005H		;save mode adjustment
		STA	<SVFLG		;

DTS0828		EQU	$
		STZ	<DYNFLG		;over write flag clear

		INC	<SVFLG		;save mode set
		RTS
;
;--------  DTSVCHK ------------
DTSVCHK		EQU	$
;
		MEM16
		REP	#00100000B	; memory 16bit mode
;
		LDX	#CHKMSGE-CHKMSG-2
CHK000		EQU	$
		LDA	>CHKMSG,X
		STA	!OAM,X
		DEX
		DEX
		BPL	CHK000
;
		STZ	!OAMSUB+0
		STZ	!OAMSUB+2
		STZ	!OAMSUB+4
;
		MEM8
		SEP	#00100000B	; memory 8bit mode

		LDA	<INKEY
		CMP	#L_N		; [N]
		BNE	CHK200		; no...	 CHK200

		DEC	<SVFLG
		DEC	<SVFLG
		RTS
;
CHK200		EQU	$
		CMP	#L_Y		; [Y]
		BNE	CHK300		; no...	 CHK300

		INC	<SVFLG
CHK300		EQU	$
		RTS
;

;
;--------  MSGWR ------------
;
MSGWR		EQU	$
		MEM16
		REP	#00100000B	; memory 16bit mode
;
		LDX	#NWSVDTE-NWSVDT-2
DTS0830		EQU	$
		LDA	>NWSVDT,X
		STA	!OAM+4*13,X	;"now saving!!" messege set
		DEX
		DEX
		BPL	DTS0830		;oam set end?
;					;    (NO goto DTS0830)
		STZ	!OAMSUB+0
		STZ	!OAMSUB+2
		STZ	!OAMSUB+4
		STZ	!OAMSUB+6
;
		MEM8
		SEP	#00100000B

		INC	<SVFLG
		RTS
;
;--------  DTSV ------------
DTSV		EQU	$
		LDA	<ERCODE
		BNE	SV0010		;error code in key on wait?
;					;    (YES goto SV0010)
		LDA	#002H
		DOS	_DSKRST		;disk reset
;
		DOS	_SAVE		;save
;
		CMP	#000H
		BEQ	SV0020		;error?
;					;    (NO goto SV0020)
		STA	<ERCODE		;error code set
SV0010		EQU	$
		JSR	MSVERR		;error messege oam set sub go!!
		LDA	INKEY3
		CMP	#NUL
		BEQ	SV0020		;any key input?
;					;    (NO goto SV0020)
		STZ	<ERCODE		;error code clear
SV0020		EQU	$
		LDA	<ERCODE
		BNE	SV0030		;error code set?
;					;    (YES goto SV0030)
		INC	<SVFLG		;data save clear mode set
SV0030		EQU	$
		RTS
;
;--------  DTSVCL ------------
DTSVCL		EQU	$
;--------  DTSVEND ------------
DTSVEND		EQU	$
		STZ	<SVFLG
		STZ	!OAMSUB+0
		STZ	!OAMSUB+1
		STZ	!OAMSUB+2
		STZ	!OAMSUB+3
		STZ	!OAMSUB+4
		STZ	!OAMSUB+5
		STZ	!OAMSUB+6
;
		LDA	#PLMD
		STA	<GMMODE
		RTS
;
;******** MSVERR ********
MSVERR		EQU	$		;*** error messege set sub ***
;
		MEM16
		REP	#00100000B	; memory 16bit mode
;
		LDX	#MSERDTE-MSERDT-2
MSE0100		EQU	$
		LDA	>MSERDT,X
		STA	!OAM+4*13,X	;"error code No." messege set
		DEX
		DEX
		BPL	MSE0100		;oam set end?
;					;    (NO goto MSE0100)
		LDX	#MSERDTE-MSERDT-2
		LDA	<ERCODE
		AND	#00FFH
		CLC
		ADC	#0030H		;ascii code comp (err code 1-9)
		ORA	#03C00H		;atribute plus
		STA	!OAM+4*13,X	;last oam char No. & atribute set
;
		LDA	#0000001010101010B
		STA	!OAMSUB+2
		LDA	#0000000000000000B
		STA	!OAMSUB+4
		LDA	#0000000000000000B
		STA	!OAMSUB+6
;
		MEM8
		SEP	#00100000B	; memory 8bit mode
		RTS
;
;******** NMNTSB ********
NMNTSB		EQU	$		;*** name not check sub ***
		LDX	#000H
NMN0100		EQU	$
		LDA	<NMDTBF0,X
		CMP	#020H
		BNE	NMN0200		;name data space?
;					;    (NO goto NMN0200)
		INX			;next moji check
		CPX	#008H
		BNE	NMN0100		;8 moji all space code?
;					;    (NO goto NMN0100)
		LDA	#004H		;error "file not found" set
		STA	<ERCODE
		INC	<SVFLG		;save mode set
NMN0200		EQU	$
		RTS
;
;
OLDFILE_DEL	EQU	$

;		LDA	#002H
;		DOS	_DSKRST		;disk zokusei set
;
;		DOS	_PURGE		;delete GO!!

		LDA	#003H		;save mode set
		STA	<SVFLG		;

		RTS
;
		MEM8
		IDX8
;
;		0page ----> hoka
;
;
STAT_CNVDT	EQU	$
;			[number of bit]
		BYTE	4		;[NUKINO] kLJ[(0-F)
		BYTE	4		;[BG1TYP] afP^Cv(0-F)
		BYTE	4		;[BG1COL]   h	J[(0-F)
		BYTE	4		;[BG2TYP] afQ^Cv(0-F)
		BYTE	4		;[BG2COL]   h	J[(0-F)
		BYTE	6		;[BG3TYP] afR^Cv(0-3F)
		BYTE	4		;[BG3COL]   h	J[(0-F)
		BYTE	4		;[OBJTYP] nai^Cv(0-F)
		BYTE	5		;[CHRTRP] L]p^[(0-1F)
		BYTE	5		;[COLTRP] J[]p^[(0-1F)
		BYTE	4		;[SCRLNO] XN[^Cv(0-F)
		BYTE	4		;[BGM_NO] afl mD(0-F)
		BYTE	2		;[CORSNO] R[X mD(0-3)
		HEX	00	;end code
;
BUFFSET		EQU	$
		PHB			;(DBR) save
		PHK			;(DBR) <-- (PBR)
		PLB
;
		MI16
;
		LDA	#COURSEDT
		STA	<BGDTADR
		LDA	#COURSEDT/100H
		STA	<BGDTADR+1
;
		STZ	<WORK		;(WK0,1) <-- BG course data pointer
;
		M8
;
		LDA	#8
		STA	<WORK2		;(WK2) <-- number of bit initial set
		LDY	#00		;(Y) <-- status data set RAM pointer
		LDX	#00		;(X) <-- status data convert data pointer
		LDA	!STAT_CNVDT,X
STATSV_010	EQU	$
		STA	<WORK4		;(WK4) <-- set number of bit
		LDA	#8
		SEC
		SBC	<WORK4
		STA	<WORK8
		LDA	GMSTATUS,Y	;(A)   <-- status data set RAM
STATSV_012	EQU	$
		ASL	A
		DEC	<WORK8
		BNE	STATSV_012
;
STATSV_020	EQU	$
		DEC	<WORK2
		BPL	STATSV_030	;BG course data read ? ( no:STATSV_030 )
;
		PHA			;(A) save
		PHY			;(Y) save
		LDY	<WORK
		LDA	<WORK6
		STA	[<BGDTADR],Y	;BG course data set
		INY
		STY	<WORK
		LDA	#8-1
		STA	<WORK2		;(WK2) <-- number of bit
		PLY			;(Y) load
		PLA
STATSV_030	EQU	$
		ASL	A
		ROL	<WORK6		;(WK6) <-- BG course data
		DEC	<WORK4
		BNE	STATSV_020
;
		INY
		INY
		INX
		LDA	!STAT_CNVDT,X
		BNE	STATSV_010	;end ? ( no:STATSV_010 )
;
STATSV_040	EQU	$
		DEC	<WORK2
		BNE	STATSV_050
		ASL	<WORK6
		BRA	STATSV_040
;
STATSV_050	EQU	$
		LDY	<WORK
		LDA	<WORK6
		STA	[<BGDTADR],Y	;BG course data set
;
		I8
;
		PLB
		RTS
;
;
;
;******** OAM DATA ********
SOWSDT		EQU	$			;over write message data
		BYTE	038H,0C6H,04FH,03CH	;O
		BYTE	040H,0C6H,056H,03CH	;V
		BYTE	048H,0C6H,045H,03CH	;E
		BYTE	050H,0C6H,052H,03CH	;R
;
		BYTE	060H,0C6H,057H,03CH	;W
		BYTE	068H,0C6H,052H,03CH	;R
		BYTE	070H,0C6H,049H,03CH	;I
		BYTE	078H,0C6H,054H,03CH	;T
		BYTE	080H,0C6H,045H,03CH	;E
;
;
		BYTE	098H,0C6H,04FH,03CH	;O
		BYTE	0A0H,0C6H,04BH,03CH	;K
		BYTE	0A8H,0C6H,03FH,03CH	;?
;
		BYTE	0B8H,0C6H,059H,03CH	;Y
		BYTE	0C0H,0C6H,02FH,03CH	;/
		BYTE	0C8H,0C6H,04EH,03CH	;N
SOWSDTE		EQU	$
;
;
;******** OAM DATA ********
CHKMSG		EQU	$			;over write message data
		BYTE	038H,0C6H,053H,03CH	;S
		BYTE	040H,0C6H,041H,03CH	;A
		BYTE	048H,0C6H,056H,03CH	;V
		BYTE	050H,0C6H,045H,03CH	;E
;
		BYTE	060H,0C6H,04EH,03CH	;N
		BYTE	068H,0C6H,041H,03CH	;A
		BYTE	070H,0C6H,04DH,03CH	;M
		BYTE	078H,0C6H,045H,03CH	;E
;
;
		BYTE	088H,0C6H,04FH,03CH	;O
		BYTE	090H,0C6H,04BH,03CH	;K
		BYTE	098H,0C6H,03FH,03CH	;?
;
		BYTE	0A8H,0C6H,059H,03CH	;Y
		BYTE	0B0H,0C6H,02FH,03CH	;/
		BYTE	0B8H,0C6H,04EH,03CH	;N
CHKMSGE		EQU	$
;
;
;******** OAM DATA ********
NWSVDT		EQU	$			;now saving message data
		BYTE	040H,0C6H,04EH,03CH	;N
		BYTE	048H,0C6H,04FH,03CH	;O
		BYTE	050H,0C6H,057H,03CH	;W
;
		BYTE	060H,0C6H,053H,03CH	;S
		BYTE	068H,0C6H,041H,03CH	;A
		BYTE	070H,0C6H,056H,03CH	;V
		BYTE	078H,0C6H,049H,03CH	;I
		BYTE	080H,0C6H,04EH,03CH	;N
		BYTE	088H,0C6H,047H,03CH	;G
		BYTE	090H,0C6H,02EH,03CH	;.
		BYTE	098H,0C6H,02EH,03CH	;.
		BYTE	0A0H,0C6H,02EH,03CH	;.
		BYTE	0A8H,0C6H,02EH,03CH	;.
		BYTE	0B0H,0C6H,02EH,03CH	;.
		BYTE	0B8H,0C6H,02EH,03CH	;.
NWSVDTE		EQU	$
;
;
;******** OAM DATA ********
MSERDT		EQU	$			;error message data
		BYTE	050H,0A8H,045H,03CH	;E
		BYTE	058H,0A8H,052H,03CH	;R
		BYTE	060H,0A8H,052H,03CH	;R
		BYTE	068H,0A8H,04FH,03CH	;O
		BYTE	070H,0A8H,052H,03CH	;R
		BYTE	078H,0A8H,02EH,03CH	;.
		BYTE	080H,0A8H,02EH,03CH	;.
;
		BYTE	040H,0B8H,045H,03CH	;E
		BYTE	048H,0B8H,052H,03CH	;R
		BYTE	050H,0B8H,052H,03CH	;R
		BYTE	058H,0B8H,04FH,03CH	;O
		BYTE	060H,0B8H,052H,03CH	;R
;
		BYTE	070H,0B8H,043H,03CH	;C
		BYTE	078H,0B8H,04FH,03CH	;O
		BYTE	080H,0B8H,044H,03CH	;D
		BYTE	088H,0B8H,045H,03CH	;E
;
		BYTE	098H,0B8H,030H,03CH	;No.
MSERDTE		EQU	$
;
;
;
NAMEDT		EQU	$
		HEX	078H,0B4H,000H,030H
		HEX	080H,0B4H,000H,030H
		HEX	088H,0B4H,000H,030H
		HEX	090H,0B4H,000H,030H
		HEX	098H,0B4H,000H,030H
		HEX	0A0H,0B4H,000H,030H
		HEX	0A8H,0B4H,000H,030H
		HEX	0B0H,0B4H,000H,030H
NAMEDTE		EQU	$
;
NMCNT		EQU	NAMEDTE-NAMEDT-1
;
;
;
;******** NAMEST ********
NAMEST		EQU	$		;*** file name set sub ***
		LDX	#NMCNT
NMS0020		EQU	$
		LDA	>NAMEDT,X
		STA	!NAMOAM,X
		DEX
		BPL	NMS0020
;
		LDX	<NAMEPT
		LDA	<INKEY3
		CMP	#NUL
		BEQ	NMS0100
;
		CMP	#01FH		;space yori mae ascii code
		BCC	NMS0100
;
		CMP	#07BH		;z yori ushiro ascii code
		BCS	NMS0100		;data set ok?
;					; yes
		STA	<NMDTBF0,X
;
		INC	<NAMEPT
		LDA	<NAMEPT
		AND	#00000111B
		STA	<NAMEPT

NMS0100		EQU	$		;data oam set
		LDA	<NMDTBF0
		STA	!NAMOAM+4*0+2
		LDA	<NMDTBF1
		STA	!NAMOAM+4*1+2
		LDA	<NMDTBF2
		STA	!NAMOAM+4*2+2
		LDA	<NMDTBF3
		STA	!NAMOAM+4*3+2
		LDA	<NMDTBF4
		STA	!NAMOAM+4*4+2
		LDA	<NMDTBF5
		STA	!NAMOAM+4*5+2
		LDA	<NMDTBF6
		STA	!NAMOAM+4*6+2
		LDA	<NMDTBF7
		STA	!NAMOAM+4*7+2
;
		STZ	!OAMSUB+18
;
		LDA	<FRCNT		;get data tenmetu
		AND	#00001000B
		BEQ	NMS0800

		LDA	<NMDTBF0,X	;char. = space ?
		CMP	#020H		;
		BNE	NMS0200		;  no: NMS0200

		LDA	#08EH		;blink char. set
		STA	<NMDTBF0,X	;

		BRA	NMS0800

NMS0200		EQU	$
		LDA	<NAMEPT
		ASL	A
		ASL	A
		TAX
		LDA	#0F0H
		STA	!NAMOAM+4*0+1,X

NMS0800		EQU	$
		RTS
;
;
;************************************************************************
;*		Directory BG set			(DIRSUB)	*
;************************************************************************
DIRSUB		EQU	$
		JSR	DIRSUB1
		MEM8
		IDX8
		SEP	#00110000B	; memory,index 8bit mode

		JSR	INTWAK

		RTS
;
DIRSUB1		EQU	$
;
		MEM16
		IDX16
		REP	#00110000B	; memory,index 16bit mode
;
		LDX	#07FEH		;RAM CLEAR kosuu SET
		LDY	#0000H
		LDA	#2020H		;ASCII SPACE CODE SET
DIR005		EQU	$
		STA	FLDBUF,X
		DEX
		DEX
		BPL	DIR005		;RAM CLEAR END?
;					;    (NO goto DIR005)
		MEM8
		IDX8
		SEP	#00110000B	; memory,index 8bit mode
;
		LDA	#002H
		DOS	_DSKRST		;FILE zokusei SET
;
		MEM16
		REP	#00100000B	; memory,index 16bit mode
;
		LDX	#000H
		LDA	#03F3FH		;ASCII ?? CODE SET
DIR010		EQU	$
		STA	01EE0H,X	;DIRECTORY CHECK CODE SET
		INX
		INX
		CPX	#008H
		BNE	DIR010		;CODE SET END?
;					;   (NO goto DIR010)
		MEM8
		SEP	#00100000B	; memory 8bit mode
;
		LDA	#044H		;ASCII CODE D SET
		STA	1EE0H+8
		LDA	#041H		;ASCII CODE A SET
		STA	1EE0H+9
		LDA	#054H		;ASCII CODE T SET
		STA	1EE0H+10	;zokusei SET
;
		DOS	_DIRFST
		CMP	#000H
		BNE	DIR060		;FILE LOAD ERROR?
;					;    (YES goto DIR060)
		IDX16
		REP	#00010000B	; index 16bit mode
;
		LDX	#0000H
DIR020		EQU	$
		LDA	01EC0H,X
		STA	FLDBUF,X	;FILE NAME DATA BUFFER SET
		INX
		CPX	#0008H
		BNE	DIR020		;FIRST NAME DATA SET END?
;					;    (NO goto DIR020)
DIR030		EQU	$
		LDA	#008H
		STA	<WORK0		;NAME COUNTER SET
		DOS	_DIRNXT
		CMP	#000H
		BNE	DIR050		;FILE LOAD END?
;					;    (YES goto DIR050)
		LDY	#0000H
DIR040		EQU	$
		LDA	01EC0H,Y
		STA	FLDBUF,X	;FILE NAME DATA BUFFER CONTINUE
		INX
		INY
		DEC	<WORK0
		BNE	DIR040		;FILE NAME 8 moji SET END?
;					;    (NO goto DIR040)
		CPX	#07FEH
		BCC	DIR030		;MAX FILE DATA?
;					;    (NO goto DIR030)
DIR050		EQU	$
		TXA
		LSR	A
		LSR	A
		LSR	A		;FILE suu = FILE NAME BUFFER INDEX / 008H
		STA	FKOSUU		;FILE suu SET
DIR060		EQU	$
;
		RTS
;
;
;
;
;
;
;************************************************************************
;*		Data load				(DTLOAD)	*
;************************************************************************
DTLOAD		EQU	$
		PHB			;PROGRAM BANK NOT= DATA BANK
		PHK
		PLB			;PROGRAM BANK = DATA BANK CHANGE
;
		JSR	DTLOAD1
;
		PLB			;BANK RECOVER
		RTL
;
;
;--------- DTLOAD1 ----------
DTLOAD1		EQU	$
		LDA	<LDFLG
		JSL	>JSRSUB
		WORD	DTLDINT		;00   data load initial
		WORD	DTLDPL		;01   data load play
;
;
;--------  DTLDINT ------------
DTLDINT		EQU	$
		JSL	>VRAMCL		; VCL
;
		STZ	2121H		;CGRAM address set

		I16			; index 16bit mode
;
		LDX	#00000000B+(22H*100H)	;DMA parameter & B bus address
		STX	4300H
		LDX	#1CC000H		;A bus address(L,H)
		STX	4302H
		LDA	#BANK 1CC000H		;	"     (B)
		STA	4304H
		LDX	#0100H			;number of byte
		STX	4305H
		LDA	#00000001B
		STA	420BH			;DMA "ON"
;
;-------------- BG3,4 screen set --------------------------
		LDA	#10000000B	;inc mode
		STA	2115H
		LDX	#7400H
		STX	2116H		; VRAM address set
		LDX	#00000001B+(18H*100H)
		STX	4300H		; parameter & B bus address
		LDX	#1CE000H
		STX	4302H		; A bus address (L,H)
		LDA	#BANK 1CE000H
		STA	4304H		;		(B)
		LDX	#0800H
		STX	4305H		; number of byte
		LDA	#00000001B
		STA	420BH		; DMA "on"
;
;
		I8			; index 8bit mode
;
		JSR	DIRSUB
;
		LDX	#001H
		LDA	#030H
DTLDI020	EQU	$
		STA	<NMBBUF,X	; name buffe ascii data (0) clearr
		DEX
		BPL	DTLDI020
;
		STZ	<NAMEPT		;input No. data pointer clear
;
;
		MEM16
		REP	#00100000B	; memory 16bit mode
;
		STZ	<SCCH3		;BG3,4 scroll counter set
		STZ	<SCCH4
;
		STZ	<SCCV3
		LDA	#0FFC3H
		STA	<SCCV4
;
;
		MEM8
		SEP	#00100000B	; memory 8bit mode
;
		STZ	!OAMSUB+0
		STZ	!OAMSUB+1
		STZ	!OAMSUB+2
		STZ	!OAMSUB+3
		STZ	!OAMSUB+4
		STZ	!OAMSUB+5
		STZ	!OAMSUB+6
;
		STZ	WIND23
		STZ	WIND24
		STZ	WIND25

		LDA	#00011100B	;main select ( BG3,BG4,OBJ )
		STA	<MANSEL		; 212CH
		STZ	<WMANSL		;window "OFF"

		STZ	2105H		; 2105H

		LDA	#00001111B
		STA	<BLKFLG
		STZ	<ERCODE

		INC	<LDFLG
		RTS
;
;
;
;
;
;
;
;
;
;-------- DTLDPL -------------
LODDSDT		EQU	$
		BYTE	098H,020H,030H,03CH
		BYTE	0A0H,020H,030H,03CH
LODDTE		EQU	$
;
;
;
DTLDPL		EQU	$
		MEM16
		REP	#00100000B	; memory 16bit mode
;
		LDX	#LODDTE-LODDSDT-2
DLP0000		EQU	$
		LDA	>LODDSDT,X
		STA	!OAM,X
		DEX
		DEX
		BPL	DLP0000
;
;
		MEM8
		SEP	#00100000B	; memory 8bit mode
;
;
;------- load key on ? -------
LDSP0050	EQU	$
		LDA	<INKEY
		CMP	#LOD
		BEQ	DTLDEND		; [F_4] key ?
;					; yes
;
;--------- set key on ? ------
		CMP	#STT
		BEQ	DTL0500		; [F_10] key ?
;					; no
;
;------- LOAD PLAY  ----
		MEM16
		REP	#00100000B	; memory 16bit mode
;
		LDA	#00010H
		LDX	<INKEY2
		CPX	#DWN
		BEQ	DLP0200		; down key ?
;					; no
		LDA	#0FFF0H
		CPX	#UPP
		BNE	DLP0300		; up key ?
;					; yes
DLP0200		EQU	$
		JSR	WKSET1
		CLC
		ADC	<SCCV4
		STA	<SCCV4		;tate scroll move
;
DLP0300		EQU	$
		M8			; memory 8bit mode
		JSR	NUMBST
		RTS
;
;
DTLDEND		EQU	$
;		JSL	>DTSHARE

		MI8
		JSL	>UNITST

		LDA	#BGWR
		STA	<GMMODE
;
		STZ	<LDFLG
		STZ	!OAMSUB+0
		STZ	!OAMSUB+1
		STZ	!OAMSUB+2
		STZ	!OAMSUB+3
		STZ	!OAMSUB+4
		STZ	!OAMSUB+5
		STZ	!OAMSUB+6
;
		LDA	#029H
		STA	2105H
		RTS
;
;
;
;
;
;
DTL0500		EQU	$
		MEM8
		SEP	#00100000B	; memory 8bit mode
;
		LDA	NMBBUF		;load No. HI load
		SEC
		SBC	#030H		;HEX <- ascii change
		CMP	#011H
		BCC	DTL0510		;data HI 0AH ijo?
;					;    (NO goto DTL0510)
		SEC
		SBC	#007H		;0A <-> 0F data change
DTL0510		EQU	$
		ASL	A
		ASL	A
		ASL	A
		ASL	A		;data HI move
		STA	<WORK2		;data HI set
;
		LDA	NMBBUF+1	;load No. LOW load
		SEC
		SBC	#030H		;HEX <- ascii change
		CMP	#011H
		BCC	DTL0520		;data LOW 0AH ijo?
;					;    (NO goto DTL0520)
		SEC
		SBC	#007H		;0A <-> 0F data change
DTL0520		EQU	$
		ORA	<WORK2		;data HI LOW plus
		STA	<WORK2
		STZ	<WORK3		;HI ram clear
;
		MEM16
		IDX16
		REP	#00110000B	; memory index 16bit mode
;
		LDA	<WORK2
		ASL	A
		ASL	A
		ASL	A		;NAME BUFFER index = No. * 08H
		TAX
;
;
;
		LDA	#04144H		;D and A ascii code set
		STA	1EE0H+8
		LDA	#COURSEDT
		STA	1EE0H+16	;LOW and HI address set
;		LDA	#0400H
		LDA	#1000H
		STA	1EE0H+20	;SIZE set
;
;
		MEM8
		SEP	#00100000B	; memory 8bit mode
;
		STZ	NMPTWK		;name pointer work clear

		LDA	#008H
		STA	<WORK0		;name counter set
		LDY	#0000H
DTL0600		EQU	$
		LDA	FLDBUF,X
		STA	1EE0H,Y
		STA	FLNMWK,Y	;file name work set
		CMP	#020H		;moji = space ?
		BEQ	DTL0660		; yes: DTL0660

		INC	NMPTWK		;name pointer work (long counter) inc.

DTL0660		EQU	$
		INX
		INY
		DEC	<WORK0
		BNE	DTL0600		;8 moji set?
;					;    (NO goto DTL0600)
;
;		LDA	#035H		;old file name used flag set
;		STA	FNAME0		;
;		LDA	#053H		;
;		STA	FNAME1		;
;
		LDA	#054H		;T ascii code set
		STA	1EE0H+10
		LDA	#BANK COURSEDT	;BANK
		STA	1EE0H+18	;BANK set
;
		IDX8
		SEP	#00010000B	; index 8bit mode
;
		LDA	#002H
		DOS	_DSKRST		;disk zokusei set
;
		DOS	_LOAD		;load GO!!
;
		LDX	#007H
DTL0800		EQU	$
		LDA	1EE0H,X
		STA	<NMDTBF0,X
		DEX
		BPL	DTL0800
;
		JSL	>DTSHARE
;
		STZ	<LASTFG		;last input data flag "OFF" !!
		RTS
;
;
;
NUMBST		EQU	$
;
		LDX	#LODDTE-LODDSDT-2
NUM010		EQU	$
		LDA	>LODDSDT,X
		STA	!OAM,X
		DEX
		BPL	NUM010		;initial oam set end?
;					;    (NO goto NUM010)
		LDX	<NAMEPT
		LDA	<INKEY
		CMP	#NUL
		BEQ	NUM020		; data set ok ?
;					; yes
		CMP	#SU0
		BCC	NUM020		;data 0 ijo ?
;					;    (NO goto NUM020)
		CMP	#L_G
		BCS	NUM020		;data F ika ?
;					;    (NO goto NUM020)
		STA	<NMBBUF,X
;
		LDA	<NAMEPT
		EOR	#00000001B
		STA	<NAMEPT		;pointer set

		BRA	NUM028

NUM020		EQU	$
		CMP	#L_K
		BEQ	NUM022
		CMP	#L_J
		BEQ	NUM023
		CMP	#L_N
		BEQ	NUM021
		CMP	#L_H
		BNE	NUM02F

		INC	<NMBBUF+1
		BRA	NUM024

NUM021		EQU	$
		DEC	<NMBBUF+1
		BRA	NUM024

NUM022		EQU	$
		INC	<NMBBUF
		BRA	NUM024

NUM023		EQU	$
		DEC	<NMBBUF

NUM024		EQU	$
		LDX	#001H

NUM025		EQU	$
		LDA	<NMBBUF,X
		CMP	#SU0
		BCS	NUM026

		LDA	#SU0
		STA	<NMBBUF,X
		BRA	NUM029

NUM026		EQU	$
		CMP	#SU9+1
		BNE	NUM027

		LDA	#L_A
		STA	<NMBBUF,X
		BRA	NUM029

NUM027		EQU	$
		CMP	#L_A-1
		BNE	NUM028

		LDA	#SU9
		STA	<NMBBUF,X
		BRA	NUM029

NUM028		EQU	$
		CMP	#L_G
		BNE	NUM029

		LDA	#L_F
		STA	<NMBBUF,X

NUM029		EQU	$
		DEX
		BPL	NUM025


NUM02F		EQU	$
		LDA	<NMBBUF		;data oam set
		STA	!OAM+4*0+2
		LDA	<NMBBUF+1
		STA	!OAM+4*1+2
;
		LDA	<FRCNT		;get data tenmetu
		AND	#00001000B
		BEQ	NUM030
;
		LDA	<NAMEPT
		ASL	A
		ASL	A
		TAX
		LDA	#0F0H
		STA	!OAM+4*0+1,X
NUM030		EQU	$
		RTS
;
;
;
;
;
;
;************************************************************************
;*		WAKU SET 1 LINE				(WKSET1)	*
;************************************************************************
ADDDT1		WORD	00040H,0FFC0H	;vramd hi low add data
ADDDT2		WORD	00002H,0FFFEH	;No. add data
;
WKSET1		EQU	$
		MEM16
		IDX16
		REP	#00010000B	; index 16bit mode
;
		PHA
;
		LDX	#0000H		;top or last index clear
		CMP	#0000H
		PHP
		BMI	WKS010		;plus ?(scroll down)
;					;    (YES goto WKS010)
		INX
		INX
WKS010		EQU	$
		LDA	<VHLTP,X
		STA	<WORK2		;vramd top or last data set
		LDA	<HNUMCT,X
		STA	<WORK4		;number top or last data set
;
		JSR	IVMSTSB
;
		LDX	#0000H		;add data index set
		TXY
		PLP
		BPL	WKS020		;mimus ?(scroll up)
;					    (YES WKS020)
		INX
		INX
WKS020		EQU	$
		LDA	VHLTP,Y
		CLC
		ADC	ADDDT1,X
		STA	VHLTP,Y		;NEXT LINE DATA SET
		CPX	#0002H
		BEQ	WKS030		;up ?
;					;    (YES goto WKS030)
		AND	#0400H
		BEQ	WKS040		;7C02H <- 7802H	 CHANGE?
;					;    (NO goto WKS030)
		LDA	VHLTP,Y
		EOR	#0400H
		STA	VHLTP,Y		;CHANGE DATA SET
		BRA	WKS040
WKS030		EQU	$
;		AND	#0F00H
;		CMP	#0700H
;		BNE	WKS040

		AND	#0400H
		BEQ	WKS040		;7BC2H -> 77C2H	 CHANGE
;
		LDA	VHLTP,Y
		EOR	#00C00H
;		LDA	#07BC2H
		STA	VHLTP,Y		;CHANGE DATA SET
WKS040		EQU	$
		LDA	HNUMCT,Y
		CLC
		ADC	ADDDT2,X
		AND	#00FFH
		STA	HNUMCT,Y	;NUMBER PLUS or MINUS
		INY
		INY
		CPY	#0004H
		BNE	WKS020		;TOP or LAST SET END?
;					;    (NO goto WKS020)
		PLA
;
		IDX8
		SEP	#00010000B	; index 8bit mode
;
		RTS
;
;
;
;
;
;
;--------  DTSHARE ------------
;
;		0page ----> hoka
;
;
DTSHARE		EQU	$
		PHB			;(DBR) save
		PHK			;(DBR) <-- (PBR)
		PLB
;
		MI16
;
		LDA	#COURSEDT
		STA	<BGDTADR
		LDA	#COURSEDT/100H
		STA	<BGDTADR+1
;
		STZ	<WORK		;(WK0,1) <-- BG course data pointer
;
		M8
;
		STZ	<WORK2		;(WK2) <-- number of bit initial set
		LDY	#00		;(Y) <-- status data set RAM pointer
		LDX	#00		;(X) <-- status data convert data pointer
		LDA	!STAT_CNVDT,X
STATLD_010	EQU	$
		STA	<WORK4		;(WK4) <-- set number of bit
		LDA	#00		;(A) <-- status data set RAM
STATLD_020	EQU	$
		DEC	<WORK2
		BPL	STATLD_030	;BG course data read ? ( no:STATLD_030 )
;
		PHA			;(A) save
		LDA	#8-1
		STA	<WORK2		;(WK2) <-- number of bit
		PHY			;(Y) save
		LDY	<WORK
		LDA	[<BGDTADR],Y	;(A) <-- raed BG course data
		STA	<WORK6
		INY
		STY	<WORK
		PLY			;(Y) load
		PLA			;(A) load
STATLD_030	EQU	$
		ASL	<WORK6
		ROL	A		;(A) <-- status data
		DEC	WORK4
		BNE	STATLD_020
;
		STA	GMSTATUS,Y	;status data RAM set
		INY
		INY
		INX
		LDA	!STAT_CNVDT,X
		BNE	STATLD_010	;end ? ( no:STATLD_010 )
;
		I8
;
		PLB
		RTL
;
;
;
;
;******** OAM DATA ********
CHKMSG2		EQU	$			;load name check message data
		BYTE	038H,0C6H,04CH,03CH	;L
		BYTE	040H,0C6H,04FH,03CH	;O
		BYTE	048H,0C6H,041H,03CH	;A
		BYTE	050H,0C6H,044H,03CH	;D
;
		BYTE	060H,0C6H,04EH,03CH	;N
		BYTE	068H,0C6H,041H,03CH	;A
		BYTE	070H,0C6H,04DH,03CH	;M
		BYTE	078H,0C6H,045H,03CH	;E
;
;
		BYTE	088H,0C6H,04FH,03CH	;O
		BYTE	090H,0C6H,04BH,03CH	;K
		BYTE	098H,0C6H,03FH,03CH	;?
;
		BYTE	0A8H,0C6H,059H,03CH	;Y
		BYTE	0B0H,0C6H,02FH,03CH	;/
		BYTE	0B8H,0C6H,04EH,03CH	;N
CHKMSGE2	EQU	$
;
;
;******** OAM DATA ********
NWLDDT		EQU	$			;now saving message data
		BYTE	040H,0C6H,04EH,03CH	;N
		BYTE	048H,0C6H,04FH,03CH	;O
		BYTE	050H,0C6H,057H,03CH	;W
;
		BYTE	060H,0C6H,04CH,03CH	;L
		BYTE	068H,0C6H,04FH,03CH	;O
		BYTE	070H,0C6H,041H,03CH	;A
		BYTE	078H,0C6H,044H,03CH	;D
		BYTE	080H,0C6H,049H,03CH	;I
		BYTE	088H,0C6H,04EH,03CH	;N
		BYTE	090H,0C6H,047H,03CH	;G
		BYTE	098H,0C6H,02EH,03CH	;.
		BYTE	0A0H,0C6H,02EH,03CH	;.
		BYTE	0A8H,0C6H,02EH,03CH	;.
		BYTE	0B0H,0C6H,02EH,03CH	;.
		BYTE	0B8H,0C6H,02EH,03CH	;.
NWLDDTE		EQU	$
;
;************************************************************************
;*		Directory BG set			(INTWAK)	*
;************************************************************************
;
WAKDAT		EQU	$
		WORD	7802H,0037H					;waku HI BG DATA
		WORD	01C8BH,01C8CH,01C8CH,01C8DH,01C8CH,01C8CH,01C8CH,01C8CH
		WORD	01C8CH,01C8CH,01C8CH,01C8CH,01C8EH,01020H,01020H,01C8BH
		WORD	01C8CH,01C8CH,01C8DH,01C8CH,01C8CH,01C8CH,01C8CH,01C8CH
		WORD	01C8CH,01C8CH,01C8CH,01C8EH
;
WAKDT0		EQU	$
		WORD	7822H,0037H					;waku LOW BG DATA
		WORD	00C9BH
WAKDT1		EQU	$
		WORD	       00C9CH,00C9CH,00C9DH
WAKDT2		EQU	$
		WORD				    00C9CH,00C9CH,00C9CH,00C9CH
		WORD	00C9CH,00C9CH,00C9CH,00C9CH,00C9EH,00020H,00020H,00C9BH
WAKDT3		EQU	$
		WORD	00C9CH,00C9CH,00C9DH
WAKDT4		EQU	$
		WORD			     00C9CH,00C9CH,00C9CH,00C9CH,00C9CH
		WORD	00C9CH,00C9CH,00C9CH,00C9EH
		WORD	0FFFFH
WAKDT5		EQU	$
;
;
NMBDCT		EQU	$
		WORD	00C30H,00C31H,00C32H,00C33H,00C34H,00C35H,00C36H,00C37H ;NUMBER DATA
		WORD	00C38H,00C39H,00C41H,00C42H,00C43H,00C44H,00C45H,00C46H
;
WAKPT0		EQU	WAKDT1-WAKDAT
WAKPT1		EQU	WAKDT3-WAKDT1
WAKPT2		EQU	(WAKDT5-WAKDT3)+WAKPT0-2
;
WAKPT3		EQU	WAKDT2-WAKDAT
WAKPT4		EQU	WAKDT4-WAKDT2
WAKPT5		EQU	(WAKDT5-WAKDT4)+WAKPT3-2
;
;
INTWAK		EQU	$
		MEM16
		IDX16
		REP	#00110000B	; memory,index 16bit mode
;
		LDA	#00F6H
		STA	<HNUMCT		;HI NUMBER COUNTER SET
		LDA	#00F8H
		STA	<LNUMCT		;LOW NUMBER COUNTER SET
		STA	<WORK4
;
		LDA	#07AC2H
		STA	<VHLTP		;VRAMD HI LOW TOP SET
		STA	<VHLLT		;VRAMD HI LOW LAST SET
		LDX	#00000H
		LDA	#07B02H
		STA	<WORK2		;TOP HIL LOW SET
INT010		EQU	$
;
		JSR	IVMSTSB
;
		LDA	<WORK2
		CLC
		ADC	#0040H
		STA	<WORK2		;NEXT LINE DATA SET
		AND	#0400H
		BEQ	INT020		;7C02H <- 7802H	 CHANGE?
;					;    (NO goto INT020)
		LDA	<WORK2
		EOR	#0400H
		STA	<WORK2		;CHANGE DATA SET
INT020		EQU	$
		LDA	<WORK2
		CMP	<VHLLT
		BNE	INT010		;LAST LINE DATA SET?
;					;    (NO goto INT010)
		LDA	<WORK4
		STA	<LNUMCT		;last number set
;
;
INT090		EQU	$
;
		MEM8
		IDX8
		SEP	#00110000B	; memory,index	8bit mode
;
		RTS
;
;
;
;************************************************************************
;*		INITIAL VRAMD SET SUB			(IVMSTSB)	*
;************************************************************************
IVMSTSB		EQU	$
		MEM16
		IDX16
;
		LDY	!VRAMD				;index set
		LDX	#00000H				;register clear
IVM010		EQU	$
		LDA	WAKDAT,X
		STA	!VRAMD+2,Y
		INY
		INY
		INX
		INX
		CPX	#WAKDT5-WAKDAT
		BNE	IVM010				;waku right and left set?
;							;      (NO goto IVM010)
		PHY					; (Y) push ***A***
;
		LDY	!VRAMD
		LDA	<WORK2
		STA	!VRAMD+2+(WAKDAT-WAKDAT),Y	;vramd HI LOW SET (left)
		CLC
		ADC	#00020H
		STA	!VRAMD+2+(WAKDT0-WAKDAT),Y	;vramd HI LOW SET (right)
;
		LDA	<WORK4				;number data load
		PHA					; (A) push ***B***
		AND	#00F0H				;number HI only
		LSR	A
		LSR	A
		LSR	A				;No. / 10H *02H
		TAX
		LDA	NMBDCT,X
		STA	!VRAMD+2+(WAKDT1-WAKDAT),Y	;No. charcter HI set
		PLA					; (A) pull ***B***
		AND	#000FH				;number LOW only
		ASL	A				;No. * 02H
		TAX
		LDA	NMBDCT,X
		STA	!VRAMD+4+(WAKDT1-WAKDAT),Y	;No. charcter LOW set
;
		PHY					; (Y) push ***C***
;
		LDA	#0008H
		STA	<WORK0				;moji counter set
		LDA	<WORK4
		ASL	A
		ASL	A
		ASL	A				;name buffer index = number * 08H
		TAX
IVM020		EQU	$
		LDA	FLDBUF,X
		AND	#00FFH				;name data load
		STA	!VRAMD+2+(WAKDT2-WAKDAT),Y	;moji set
		INX
		INY
		INY
		DEC	<WORK0
		BNE	IVM020				;8 moji set end?
;							;      (NO goto IVM020)
		PLY					; (Y) pull ***C***
;
		LDA	<WORK4
		INC	A
		AND	#00FFH
		STA	<WORK4				;next number set

		PHA					; (A) push ***E***
		AND	#00F0H				;number HI only
		LSR	A
		LSR	A
		LSR	A				;No. / 10H *02H
		TAX
		LDA	NMBDCT,X
		STA	!VRAMD+2+(WAKDT3-WAKDAT),Y	;No. charcter HI set
		PLA					;(A) pull ***E***
		AND	#000FH				;number LOW only
		ASL	A				;No. * 02H
		TAX
		LDA	NMBDCT,X
		STA	!VRAMD+4+(WAKDT3-WAKDAT),Y	;No. charcter LOW set
;
;
		LDA	#0008H
		STA	<WORK0				;moji counter set
		LDA	<WORK4
		ASL	A
		ASL	A
		ASL	A				;name buffer index = number * 08H
		TAX
IVM030		EQU	$
		LDA	FLDBUF,X			;name data load
		AND	#00FFH
		STA	!VRAMD+2+(WAKDT4-WAKDAT),Y	;moji set
		INX
		INY
		INY
		DEC	<WORK0				;8 moji set end?
		BNE	IVM030				;      (NO goto IVM030)
;
;
;
		LDA	<WORK4
		INC	A
		AND	#00FFH
		STA	<WORK4				;next number set
;
		PLY					; (Y) pull ***A***
		DEY
		DEY					;0FFFFH (end code)data index minus
		STY	!VRAMD
		RTS

;
;
;
;
;
;
;
;
;
;************************************************************************
;*		Data Delete				(DTDEL)		*
;************************************************************************
DTDEL		EQU	$
		MEM8
		IDX8
;		SEP	#00110000B  ; memory,index 8bit mode
;
		PHB			;PROGRAM BANK NOT= DATA BANK
		PHK
		PLB			;PROGRAM BANK = DATA BANK CHANGE
;
		JSR	DTDEL1
;
		PLB			;BANK RECOVER
		RTL
;
;
;--------- DTDEL1 ----------
DTDEL1		EQU	$
		LDA	<DELFLG
		JSL	>JSRSUB
		WORD	DTDLINT		;00   data delete initial
		WORD	DTDLINT2	;01   data delete initial
		WORD	DTDLPL		;02   data delete play
;
;
;--------  DTDLINT ------------
;
DELMES		EQU	$
		WORD	7466H,0011H
		WORD	000D0H,000D1H,000D2H,000D3H,000D4H,000D5H,000D6H,000D7H,000D8H
		WORD	7486H,0011H
		WORD	000E0H,000E1H,000E2H,000E3H,000E4H,000E5H,000E6H,000E7H,000E8H
		WORD	74A6H,0011H
		WORD	000F0H,000F1H,000F2H,000F3H,000F4H,000F5H,000F6H,000F7H,000F8H
		WORD	0FFFFH
DELMESEND	EQU	$
;
;
DTDLINT		EQU	$
		JSL	>VRAMCL		; VCL
;
		STZ	2121H		;CGRAM address set

		I16			; index 16bit mode
;
		LDX	#00000000B+(22H*100H)	;DMA parameter & B bus address
		STX	4300H
		LDX	#1CC000H		;A bus address(L,H)
		STX	4302H
		LDA	#BANK 1CC000H		;	"     (B)
		STA	4304H
		LDX	#0100H			;number of byte
		STX	4305H
		LDA	#00000001B
		STA	420BH			;DMA "ON"
;
;-------------- BG3,4 screen set --------------------------
		LDA	#10000000B	;inc mode
		STA	2115H
		LDX	#7400H
		STX	2116H		; VRAM address set
		LDX	#00000001B+(18H*100H)
		STX	4300H		; parameter & B bus address
		LDX	#1CE000H
		STX	4302H		; A bus address (L,H)
		LDA	#BANK 1CE000H
		STA	4304H		;		(B)
		LDX	#0800H
		STX	4305H		; number of byte
		LDA	#00000001B
		STA	420BH		; DMA "on"
;
;

		I8			; index 8bit mode
;
		JSR	DIRSUB
;
		LDX	#001H
		LDA	#030H
DTDLI010	EQU	$
		STA	<NMBBUF,X	; name buffe ascii data (0) clearr
		DEX
		BPL	DTDLI010
;
		STZ	<NAMEPT		;input No. data pointer clear
;
;
		MEM16
		REP	#00100000B	; memory 16bit mode
;
		STZ	<SCCH3		;BG3,4 scroll counter set
		STZ	<SCCH4
;
		STZ	<SCCV3
		LDA	#0FFC3H
		STA	<SCCV4
;
		MEM8
		SEP	#00100000B	; memory 8bit mode
;
		STZ	!OAMSUB+0
		STZ	!OAMSUB+1
		STZ	!OAMSUB+2
		STZ	!OAMSUB+3
		STZ	!OAMSUB+4
		STZ	!OAMSUB+5
		STZ	!OAMSUB+6
;
		STZ	WIND23
		STZ	WIND24
		STZ	WIND25
;
		STZ	<DYNFLG
;
		LDA	#00011100B	;main select ( BG3,BG4,OBJ )
		STA	<MANSEL		; 212CH
		STZ	<WMANSL		;window "OFF"

		STZ	2105H		; 2105H


		INC	<DELFLG
		RTS
;
;
;
DTDLINT2	EQU	$
		M16
		LDY	!VRAMD				;index set
		LDX	#00000H				;register clear
DLI010		EQU	$
		LDA	DELMES,X
		STA	!VRAMD+2,Y
		INY
		INY
		INX
		INX
		CPX	#DELMESEND-DELMES
		BNE	DLI010				;waku right and left set?
;							;      (NO goto IVM010)
		STX	!VRAMD
;
		M8
		LDA	#00001111B
		STA	<BLKFLG
		STZ	<ERCODE

		INC	<DELFLG
		RTS
;
;
;
DTDLPL		EQU	$
		MEM16
		REP	#00100000B	; memory 16bit mode
;
		LDX	#LODDTE-LODDSDT-2
DDP0000		EQU	$
		LDA	>LODDSDT,X
		STA	!OAM,X
		DEX
		DEX
		BPL	DDP0000
;
		MEM8
		SEP	#00100000B	; memory 8bit mode
;
;
		LDA	<DYNFLG
		BNE	DDP0401
;
;------- delete key on ? -------
		LDA	<INKEY		;F_5 key in ( delete mode on or off key )
		CMP	#DEL
		BEQ	DTDLEND
;
;--------- set key on ? ------
		LDA	<INKEY
		CMP	#STT		;F_10 key in ( data set key )
		BEQ	DDP0400
;
;------- DELETE PLAY  ----
DDP0100		EQU	$
		MEM16
		REP	#00100000B	; memory 16bit mode
;
		LDA	#00010H
		LDX	<INKEY2
		CPX	#DWN
		BEQ	DDP0200		; down key ?
;					; no
		LDA	#0FFF0H
		CPX	#UPP
		BNE	DDP0300		; up key ?
;					; yes
DDP0200		EQU	$
		JSR	WKSET1
		CLC
		ADC	<SCCV4
		STA	<SCCV4		;tate scroll move
		MEM8
		SEP	#00100000B	; memory 8bit mode
DDP0300		EQU	$
		MEM8
		SEP	#00100000B	; memory 8bit mode
		JSR	NUMBST
		RTS
;
;
;
		MEM8
		IDX8
DTDLEND		EQU	$
		LDA	#10000000B
		STA	<BLKFLG
;
		JSL	>UNITST
;
		LDA	#BGWR
		STA	<GMMODE
;
		STZ	<DELFLG
;		LDA	#00000001B
;		STA	<DATFLG		; mode unit set
;
		LDA	#029H
		STA	2105H
		RTS
;
;
DOKSDT		EQU	$
		BYTE	068H,030H,04FH,03CH	;OK Y/N?
		BYTE	070H,030H,04BH,03CH
		BYTE	080H,030H,059H,03CH
		BYTE	088H,030H,02FH,03CH
		BYTE	090H,030H,04EH,03CH
		BYTE	098H,030H,03FH,03CH
DOKDTE		EQU	$
;
;
;
DDP0400		EQU	$
		LDA	#001H
		STA	<DYNFLG
		RTS
;
DDP0401		EQU	$
		MEM16
		REP	#00100000B	; memory 16bit mode
;
		LDX	#DOKDTE-DOKSDT-2
DDP0410		EQU	$
		LDA	>DOKSDT,X
		STA	!OAM+8,X
		DEX
		DEX
		BPL	DDP0410
;
		MEM8
		SEP	#00100000B	; memory 8bit mode
;
		LDA	<FRCNT		;get data tenmetu
		AND	#00001000B
		BEQ	DDP0430
;
		LDX	#DOKDTE-DOKSDT-2
		LDA	#0F0H
DDP0420		EQU	$
		STA	!OAM+8+1,X
		DEX
		DEX
		BPL	DDP0420
;
DDP0430		EQU	$
		LDX	<INKEY
		CPX	#L_Y
		BEQ	DDP0500
;
		CPX	#NUL
		BNE	DDP0440
;
		JMP	NUM020
DDP0440		EQU	$
		STZ	<DYNFLG
		RTS
;
;
;
;
;
DDP0500		EQU	$
		MEM8
		SEP	#00100000B	; memory 8bit mode
;
		LDA	NMBBUF		;load No. HI load
		SEC
		SBC	#030H		;HEX <- ascii change
		CMP	#011H
		BCC	DDP0510		;data HI 0AH ijo?
;					;    (NO goto DDP0510)
		SEC
		SBC	#007H		;0A <-> 0F data change
DDP0510		EQU	$
		ASL	A
		ASL	A
		ASL	A
		ASL	A		;data HI move
		STA	<WORK2		;data HI set
;
		LDA	NMBBUF+1	;load No. LOW load
		SEC
		SBC	#030H		;HEX <- ascii change
		CMP	#011H
		BCC	DDP0520		;data LOW 0AH ijo?
;					;    (NO goto DDP0520)
		SEC
		SBC	#007H		;0A <-> 0F data change
DDP0520		EQU	$
		ORA	<WORK2		;data HI LOW plus
		STA	<WORK2
		STZ	<WORK3		;HI ram clear
;
		MEM16
		IDX16
		REP	#00110000B	; memory index 16bit mode
;
		LDA	<WORK2
		ASL	A
		ASL	A
		ASL	A		;NAME BUFFER index = No. * 08H
		TAX
;
;
;
		LDA	#04144H		;D and A ascii code set
		STA	1EE0H+8
;
		MEM8
		SEP	#00100000B	; memory 8bit mode
;
		LDA	#008H
		STA	<WORK0		;name counter set
		LDY	#0000H
DDP0600		EQU	$
		LDA	FLDBUF,X
		STA	1EE0H,Y
		INX
		INY
		DEC	<WORK0
		BNE	DDP0600		;8 moji set?
;					;    (NO goto DDP0600)
;
		LDA	#054H		;T ascii code set
		STA	1EE0H+10
;
		IDX8
		SEP	#00010000B	; index 8bit mode
;
		LDA	#002H
		DOS	_DSKRST		;disk zokusei set
;
		DOS	_PURGE		;delete GO!!
;
		MEM8
		IDX8
		SEP	#00110000B	; memory,index 8bit mode
;
		JMP	DTDLEND
;
;
;
;
;
;
;
;
		END
