;************************************************************************
;*	Super Famicom Disk Operation System include file.		*
;*						[ Aug.26, 1991 ]	*
;************************************************************************

DOS_variable	equ		001E00H

;=============== System works ===========================================

NMI_switch	equ		DOS_variable+000H	;     1 byte	: NMI switch
DOS_switch	equ		DOS_variable+001H	;     1 byte	: Driver active switch
IRQ_status	equ		DOS_variable+002H	;     1 byte	: IRQ status
IRQ_address	equ		DOS_variable+004H	;     2 bytes	: IRQ routine address
NMI_address	equ		DOS_variable+006H	;     2 bytes	: NMI routine address
keyboard_type	equ		DOS_variable+008H	;     1 byte

;=============== Temporary works ========================================

work0		equ		DOS_variable+010H	;     2 bytes	: Temporary work 0
work1		equ		DOS_variable+012H	;     2 bytes	: Temporary work 1
work2		equ		DOS_variable+014H	;     2 bytes	: Temporary work 2
work3		equ		DOS_variable+016H	;     2 bytes	: Temporary work 3

;=============== File I/O work ==========================================

current_drive	equ		DOS_variable+030H	;     1 byte	: Current directory
current_cluster	equ		DOS_variable+031H	;     2 bytes	: Current cruster number
void_cluster	equ		DOS_variable+033H	;     2 bytes	: Void culuster number
file_open_mode	equ		DOS_variable+035H	;     1 byte	:
secbuf_count	equ		DOS_variable+036H	;     2 bytes	:
logical_head	equ		DOS_variable+038H	;     4 bytes	:
;------------------------------------------------------------------------
current_dir_sec	equ		DOS_variable+040H	;     1 byte	: Search directory current sector
current_dir_idx	equ		DOS_variable+041H	;     2 bytes	: Search directory current index
notused_dir_sec	equ		DOS_variable+043H	;     1 byte	: Not used directory sector
notused_dir_idx	equ		DOS_variable+044H	;     2 bytes	: Not used directory index

;=============== Disk information works =================================

FloppyDisk_Info	equ		DOS_variable+050H
sectors_cruster	equ		DOS_variable+050H	;     1 byte	: sectors / cruster
sectors_track	equ		DOS_variable+051H	;     1 byte	: sectors / track
dir_top_sector	equ		DOS_variable+052H	;     1 byte	: top sector of Directory
dir_nsectors	equ		DOS_variable+053H	;     1 byte	: number of Directory sectors
FAT_nsectors	equ		DOS_variable+054H	;     1 byte	: number of FAT sectors
cls_top_sector	equ		DOS_variable+055H	;     2 byte	: top sector of Cruster
nclusters	equ		DOS_variable+057H	;     2 bytes	: number of Crusters
sector_length	equ		DOS_variable+059H	;     2 bytes	: size of Sector ( byte )
directory_size	equ		DOS_variable+05BH	;     2 byte	: size of Directory ( byte )
FAT_code	equ		DOS_variable+05DH	;     1 byte	: FAT ID code
;reserved	equ		DOS_variable+05EH	;     2 bytes	: Reserved

;=============== FDC driver's works =====================================

Disk_control	equ		DOS_variable+060H	;     8 bytes	: Disk control parameter buffer
FDC_result	equ		DOS_variable+068H	;     7 bytes	: FDC result buffer
FDC_device_mode	equ		DOS_variable+06FH	;     1 byte	: FDC device mode
FDC_command	equ		DOS_variable+070H	;     9 bytes	: FDC command buffer
FDC_parameter	equ		DOS_variable+076H	;    10 bytes	: FDC parameter buffer
FDC_EOT		equ		DOS_variable+076H	;     1 byte	: FDC Last sector number
FDC_GSL		equ		DOS_variable+077H	;     1	byte	: FDC Gap skip length
FDC_DTL		equ		DOS_variable+078H	;     1 byte	: FDC Data length
FDC_TRK		equ		DOS_variable+079H	;     1 byte	: FDC Number of tracks
FDC_LEN		equ		DOS_variable+07AH	;     1 byte	: FDC Record length ( *256 bytes )
FDC_SC		equ		DOS_variable+07BH	;     1 byte	: FDC Number of Sectors on 1 track
FDC_N		equ		DOS_variable+07CH	;     1 byte	: FDC Record length ( code  )
FDC_GPL		equ		DOS_variable+07DH	;     1 byte	: FDC Gap length
FDC_SRT_HUT	equ		DOS_variable+07EH	;     1 byte	: FDC SRT & HUT
FDC_HLT_ND	equ		DOS_variable+07FH	;     1 byte	: FDC HLT & Non-DMA

;=============== Define SCC driver's works ==============================

RS232C_baurate	equ		DOS_variable+080H	;     1 byte	: RS232C baurate
RS232C_status	equ		DOS_variable+081H	;     1 byte	: RS232C status
;------------------------------------------------------------------------
serial_errsta	equ		DOS_variable+082H	;     1 byte	: RS232C receive error status
serial_datcnt	equ		DOS_variable+083H	;     1 byte	: RS232C buffer Data counter
serial_putptr	equ		DOS_variable+084H	;     1 byte	: RS232C buffer Data put pointer
serial_getptr	equ		DOS_variable+085H	;     1 byte	: RS232C buffer Data get pointer
;------------------------------------------------------------------------
keybuf_datcnt	equ		DOS_variable+086H	;     1 byte	: Keyboard buffer Data counter 
keybuf_putptr	equ		DOS_variable+087H	;     1 byte	: Keyboard buffer Data put pointer
keybuf_getptr	equ		DOS_variable+088H	;     1 byte	: Keyboard buffer Data get pointer
;------------------------------------------------------------------------
capital_lock	equ		DOS_variable+089H	;     1 byte	: Keyboard capital lock flag
shift_flags	equ		DOS_variable+08AH	;     1 byte	: Keyboard shift flags

;=============== Define CON driver's works ==============================

cursor_posx	equ		DOS_variable+090H	;     1 byte	: Cursor position x
cursor_posy	equ		DOS_variable+091H	;     1 byte	: Cursor position y
cursor_addr	equ		DOS_variable+092H	;     2 bytes	: Cursor address
cursor_point	equ		DOS_variable+094H	;     2 bytes	: Cursor display address
cursor_flags	equ		DOS_variable+096H	;     1 byte	: Cursor display flags
space_character	equ		DOS_variable+097H	;     1 byte	: Space character
character_color	equ		DOS_variable+098H	;     1 byte	: Character color
escape_command	equ		DOS_variable+099H	;     1 byte	: Escape sequence status
escape_counter	equ		DOS_variable+09AH	;     1 byte	: Escape sequence counter
escape_buffer	equ		DOS_variable+09BH	;     3 bytes

;=============== System buffers =========================================

directory_entry	equ		DOS_variable+0C0H	;   32 bytes	: Directory entry
search_filename	equ		DOS_variable+0E0H	;   32 bytes	: Search file name
access_filename	equ		DOS_variable+0E0H	;   16 bytes	: Access file name
rename_filename	equ		DOS_variable+0F0H	;   16 bytes	: Rename file name
data_address	equ		DOS_variable+0F0H	;    4 bytes	:
data_length	equ		DOS_variable+0F4H	;    4 bytes	:
access_size	equ		DOS_variable+0F8H	;    4 bytes	:
;------------------------------------------------------------------------
Keyboard_buffer	equ		DOS_variable+0A0H	;   32 bytes	: Keyboard receive buffer
Line_buffer	equ		DOS_variable+0C0H	;   64 bytes	: Line buffer ( temporary buffer )
RS232C_buffer	equ		DOS_variable+100H	;  256 bytes	: RS232C receive buffer
;------------------------------------------------------------------------
Disk_FAT	equ		7E2000H			; 2048 bytes	: Floppy disk File Allocation Table
Disk_Directory	equ		7E2800H			; 1024 bytes	: Floppy disk Directory buffer
Disk_Sector	equ		7E2C00H			; 1024 bytes	: Floppy disk Sector read/write buffer
Text_VRAM	equ		7E3000H			; 2048 bytes	: Text Video RAM emulation buffer

;===============  Define Device control I/O ports  ======================

SCC_chanB_ctrl	equ		005F00H			; SCC channel B control port
SCC_chanB_data	equ		005F01H			; SCC channel B data port
SCC_chanA_ctrl	equ		005F02H			; SCC channel A control port
SCC_chanA_data	equ		005F03H			; SCC channel A data port
;------------------------------------------------------------------------
PPI_port_A	equ		005F10H			; PPI parallel port A
PPI_port_B	equ		005F11H			; PPI parallel port B
PPI_port_C	equ		005F12H			; PPI parallel port C
PPI_comm_reg	equ		005F13H			; PPI command register
;------------------------------------------------------------------------
FDC_Stat_reg	equ		005F20H			; FDC Status register
FDC_Data_reg	equ		005F21H			; FDC Data register
FDC_term_cnt	equ		005F30H			; FDC TC ( Terminal Count )

;_______________  end of include file  __________________________________
