;************************************************************************
;*									*
;*	title name	: "yossy"					*
;*	proccess	: mario chip program.4				*
;*	file name	: ys_chip4					*
;*									*
;************************************************************************
;
;
		SALL
;
		include		ys_chip.inc
;
		XALL
;
;
;------------------------------------------------------------------------
;-		global symbol						-
;------------------------------------------------------------------------
;
;------------------------------------------------------------------------
;-		extern symbol						-
;------------------------------------------------------------------------
;
;-------------< ys_chip0 >-----------------------------------------------
		EXT	COS,SIN,LCOS,LSIN
;
;-------------< ys_chip2 >-----------------------------------------------
		EXT	C_32_ROTZOM
;
;************************************************************************
;*									*
;*		program start						*
;*									*
;************************************************************************
;
;
Group_8		GROUP	S_chip_4
S_chip_4	SECT	REL
;
;****************************************************************
;*								*
;*		[hVp[^vZ[`			*
;*								*
;*	[In]							*
;*		R1	]p					*
;*		R6	w{*2				*
;*		R2	x{*2				*
;*								*
;*	[Out]							*
;*		R3	}gNXa				*
;*		R5	    h	  `				*
;*		R7	    h	  b				*
;*		R8	    h	  c				*
;*								*
;****************************************************************
M_BOSS0_MODE7	EQU	$
		IBT	R0,#BANK SIN
		ROMB

		IWT	R5,#DIVBUF
		FROM	R6
		ADD	R5
		TO	R6
		LDW	(R0)
		SMS	R6,REG0

		FROM	R2
		ADD	R5
		TO	R2
		LDW	(R0)
		SMS	R2,REG1

		IWT	R0,#SIN
		TO	R14
		ADD	R1

		IWT	R0,#COS
		TO	R10
		ADD	R1

		GETB
		INC	R14
		GETBH
		MOVE	R7,R0
		SMS	R7,REG2

		MOVE	R14,R10
		GETB
		INC	R14
		GETBH
		MOVE	R8,R0
		SMS	R8,REG3

		FROM	R7
		LMULT
		WITH	R4
		HIB
		LOB
		SWAP
		TO	R3		;R3 <- SIN X (B)
		OR	R4

		FROM	R8
		LMULT
		WITH	R4
		HIB
		LOB
		SWAP
		TO	R5		;R5 <- COS X (A)
		OR	R4

		MOVE	R6,R2

		FROM	R7
		LMULT
		WITH	R4
		HIB
		LOB
		SWAP
		OR	R4
		TO	R7		;R7 <- -SIN Y (C)
		NOT
		INC	R7

		FROM	R8
		LMULT
		WITH	R4
		HIB
		LOB
		SWAP
		TO	R8		;R8 <- COS Y (D)
		OR	R4

		STOP
		NOP
;
;********************************************************************************
;*		܂[ςʂn`lZbg					*
;*										*
;*	[In]									*
;*		(R1)  <-- ENDSXL						*
;*		(R2)  <-- ENDSYL						*
;*		(R5)  <-- ENWRK4*2 (ENCHPT)					*
;*		(R8)  <-- ENMUKI						*
;*		(R10) <-- G̃CfbNX					*
;*		(R0)  <-- n`lZbgf[^oN				*
;*		(R14) <-- n`lZbgf[^AhX				*
;*		WRK0	̕t瓪̒S܂ł̋			*
;*		WRK1	]p							*
;*		WRK2	̕t̂w@onrD				*
;*		WRK3	̕t̂x@onrD				*
;*		WRK4	̈ʒuvZp]p␳l				*
;*		WRK5	c{							*
;*		WRK6	{							*
;*		WRKF	n`lZbgȂ					*
;*										*
;********************************************************************************
MPACK_OAML
		BYTE	02*8,03*8,00*8,01*8,04*8
;
M_MPACK_OAMSET	EQU	$
		ROMB
;
		IWT	R0,#CENOAML
		ADD	R10
		LDW	(R0)
		SMS	R0,CWORK8
		MOVES	R0,R0
		BPL	MPACK_OAMSET_000 ;n`lmہH ( yes:MPACK_OAMSET_000 )
		NOP
;
		STOP
		NOP
;
MPACK_OAMSET_000
		IWT	R3,#8*4*4		;rn`lQcw̃ZbgCfbNXvZ
		TO	R4			;
		ADD	R3			;
;
		WITH	R14
		ADD	R5
;
		GETBL
		INC	R14
		TO	R14			;(R14) <-- Zbgp^[n`lZbgf[^AhX
		GETBH
;
		IBT	R12,#005		;n`lZbg
;
		mJSR	OAMSET_SB
;
		LMS	R0,CWORKF		;̂n`lZbg ?
		SUB	#0			;
		BEQ	MPACK_OAMSET_100	; yes: MPACK_OAMSET_100
		NOP

		LMS	R4,CWORK8
		IWT	R11,#08000H
		IBT	R12,#04*4
		CACHE
		MOVE	R13,R15

		FROM	R11
		STW	(R4)
		WITH	R4
		ADD	#008

		LOOP
		NOP

		LMS	R12,CWORKF
		IWT	R0,#004*4
		WITH	R12
		SUB	R0
		BEQ	MPACK_OAMSET_080
		NOP

		IBT	R0,#BANK MPACK_OAML
		ROMB

		IWT	R14,#MPACK_OAML

		CACHE
		MOVE	R13,R15

		GETB
		ADD	R4
		FROM	R11
		STW	(R0)

		LOOP
		INC	R14

MPACK_OAMSET_080
		STOP
		NOP

MPACK_OAMSET_100
		IBT	R0,#BANK SIN
		ROMB

		LMS	R4,CWORK4		;(R4) <- ̈ʒuvZp]p␳l
		LMS	R1,CWORK1		;(R1) <- ]p
		IWT	R5,#001FEH		;
		WITH	R4
		AND	R5

		IWT	R0,#SIN
		TO	R14
		ADD	R4
		TO	R3
		ADD	R1

		IWT	R0,#COS
		TO	R7
		ADD	R4
		TO	R9
		ADD	R1

		LMS	R6,CWORK0	;Y
		GETB
		INC	R14
		GETBH
		LMULT
		WITH	R4
		HIB
		LOB
		SWAP
		TO	R6
		OR	R4
		LMS	R0,CWORK5
		LMULT
		WITH	R4
		HIB
		LOB
		SWAP
		TO	R12
		OR	R4

		LMS	R6,CWORK0
		MOVE	R14,R7		;X
		GETB
		INC	R14
		GETBH
		LMULT
		WITH	R4
		HIB
		LOB
		SWAP
		TO	R6
		OR	R4
		LMS	R0,CWORK6
		LMULT
		WITH	R4
		HIB
		LOB
		SWAP
		TO	R13
		OR	R4

		MOVE	R14,R3
		GETB
		INC	R14
		TO	R6		;R3 <- SIN
		GETBH

		FROM	R12
		LMULT
		WITH	R4
		HIB
		LOB
		SWAP
		TO	R3		;R3 <- Y SIN
		OR	R4

		FROM	R13
		LMULT
		WITH	R4
		HIB
		LOB
		SWAP
		TO	R5		;R5 <- X SIN
		OR	R4
;
		MOVE	R14,R9
		GETB
		INC	R14
		TO	R6
		GETBH

		LMS	R7,CWORK3
		FROM	R12
		LMULT
		WITH	R4
		HIB
		LOB
		SWAP
		OR	R4
		ADD	R5		;R0 <- Y COS + X SIN
		NOT
		INC	R0
		TO	R2
		ADD	R7

		LMS	R7,CWORK2
		FROM	R13
		LMULT
		WITH	R4
		HIB
		LOB
		SWAP
		OR	R4
		SUB	R3		;R0 <- X COS - Y SIN
		MOVES	R8,R8
		BNE	MPACK_OAMSET_150
		TO	R1

		NOT
		INC	R1
		WITH	R1

MPACK_OAMSET_150
		ADD	R7

		LMS	R4,CWORK8
		IBT	R12,#4*4
		CACHE
		MOVE	R13,R15

		LDW	(R4)
		ADD	R1
		SBK
		INC	R4
		INC	R4
		LDW	(R4)
		ADD	R2

		WITH	R4
		ADD	#006

		LOOP
		SBK

		STOP
		NOP
;
;********************************************************************************
;*										*
;*										*
;*		(R1) <--  ENDSXL						*
;*		(R2) <--  ENDSYL						*
;*		(R3) <--  ENCHPT						*
;*		(R8) <--  ENMUKI						*
;*		(R10) <-- G̃CfbNX					*
;*		(R12) <-- LN^[f[^					*
;*		(R14) <-- n`lZbgf[^AhX				*
;*										*
;********************************************************************************
M_OAMSET_SB	EQU	$
		ROMB
		MOVE	R11,R4
		FROM	R12
		UMULT	 R3
		IBT	R6,#005
		LMULT
		FROM	R4
		TO	R14
		ADD	R14
		MOVE	R4,R11

		mJSR	OAMSET_SB
		STOP
		NOP
;
;********************************************************************************
;*										*
;*	[In]									*
;*		(R1) <--  ENDSXL						*
;*		(R2) <--  ENDSYL						*
;*		(R8) <--  ENMUKI						*
;*		(R10) <-- G̃CfbNX					*
;*		(R12) <-- LN^[f[^					*
;*		(R14) <-- n`lZbgf[^AhX				*
;*										*
;*	[Brk]									*
;*		R10,R12,R14							*
;*										*
;********************************************************************************
OAMSET_SB
		IWT	R0,#CENCLOR		;ATR SET
		ADD	R10
		TO	R3
		LDB	(R0)
		FROM	R8			;ENMUKI
		ADD	R8
		ADD	R0
		MULT	#008H
		XOR	R3
		TO	R3
		SWAP
;
		IWT	R0,#CENCHRB
		ADD	R10
		LDB	(R0)
		MULT	#8
		SMS	R0,CWORK10		;LN^[oN
;
		IWT	R0,#CENEMU0		;DATA SET
		ADD	R10
		LDB	(R0)
		TO	R10
		SWAP
;
		CACHE
;
OAMSET_SB2
		SMS	R11,RTS0

		MOVE	R13,R15			; loop address set

		GETBS
		IWT	R9,#4000H		;H flip check data
		WITH	R9
		AND	R3
		BEQ	OAMSET_SB120		;H frip ? [ no:OAMSET_SB120 ]
		INC	R14			;[ * (Z)=1: IBT R9,#0 ]
;
		NOT
		INC	R0
		IBT	R9,#008H

OAMSET_SB120
		TO	R5
		ADD	R1			; r5 <- x position
;
		GETBS
		IBT	R11,#00H		;V flip check data
		MOVES	R3,R3
		BPL	OAMSET_SB130		;V frip ? [ no:OAMSET_130 ]
		INC	R14
;
		NOT
		INC	R0
		IBT	R11,#008H

OAMSET_SB130
		TO	R6
		ADD	R2		; r6 <- y position
;
		GETB
		INC	R14
		GETBH
		INC	R14
;
		TO	R7
		XOR	R3		; R7 <- atoribute & chara No.
;
		GETB			; oamsb
		AND	#02H
		BNE	OAMSET_SB140
		NOP
;
		WITH	R5
		ADD	R9
		WITH	R6
		ADD	R11

OAMSET_SB140
		GETBH			;(R0) <-- sub,data
		INC	R14
;
		FROM	R5
		STW	(R4)		; x position
		INC	R4
		INC	R4
;
		TO	R5		; r5 <- sub,data
		XOR	R10
;
		FROM	R6
		STW	(R4)		; y position
		INC	R4
		INC	R4
		LMS	R0,CWORK10	;(R0) <-- LN^[oN
		ADD	R7
		STW	(R4)		; chara No., atoribute
		INC	R4
		INC	R4
		FROM	R5
		STW	(R4)		; oamsb,data
		INC	R4
;
		LOOP
		INC	R4

		LMS	R11,RTS0

		mRTS
;
;
;********************************************************************************
;*		܂[ςisjʂn`lZbg				*
;*										*
;*	[In]									*
;*		(R1)  <-- ENDSXL						*
;*		(R2)  <-- ENDSYL						*
;*		(R8)  <-- ENMUKI						*
;*		(R10) <-- G̃CfbNX					*
;*		(R0)  <-- n`lZbgf[^oN				*
;*		(R14) <-- n`lZbgf[^AhX				*
;*		WRKF  <-- n`lZbgȂ					*
;*										*
;********************************************************************************
MPACH_OAML
		BYTE	04*8,00*8,03*8,02*8,01*8
;
M_MPACH_OAMSET	EQU	$
		ROMB
;
		IWT	R0,#CENOAML
		ADD	R10
		TO	R4
		LDW	(R0)
		MOVES	R4,R4
		BPL	MPACH_OAMSET_000 ;n`lmہH ( yes:MPACH_OAMSET_000 )
		NOP
;
		STOP
		NOP
;
MPACH_OAMSET_000
		SMS	R4,REG4
		mLDB0	CENCHPT,R10
		ADD	R0
		WITH	R14
		ADD	R0
		GETBL
		INC	R14
		TO	R14			;(R14) <-- Zbgp^[n`lZbgf[^AhX
		GETBH
;
		mJSR	OAMSET_SB
;
		LMS	R0,CWORKF
		TO	R12
		SUB	#0
		BEQ	MPACH_OAMSET_080
		NOP

		IBT	R0,#BANK MPACH_OAML
		ROMB

		IWT	R14,#MPACH_OAML
		IWT	R11,#08000H
		LMS	R4,REG4

		CACHE
		MOVE	R13,R15

		GETB
		ADD	R4
		FROM	R11
		STW	(R0)

		LOOP
		INC	R14

MPACH_OAMSET_080
		STOP
		NOP
;
;********************************************************************************
;*		_Ci~bNeTn`lZbg					*
;*										*
;*	[In]									*
;*		(R1)  <-- ENDSXL						*
;*		(R2)  <-- ENDSYL						*
;*		(R3)  <-- tFCXItZbgw@onrD			*
;*		(R5)  <--	 h	 @ x@onrD			*
;*		(R6)  <-- {							*
;*		(R8)  <-- ENMUKI						*
;*		(R10) <-- G̃CfbNX					*
;*										*
;********************************************************************************
M_DTELE_OAMSET	EQU	$
		FROM	R3			;R1 <- Zbgw@onrD
		LMULT				;
		WITH	R4			;
		HIB				;
		LOB				;
		SWAP				;
		OR	R4			;
		MOVES	R8,R8			;
		BEQ	DTELE_OAMSET_010	;
		NOP				;
						;
		NOT				;
		INC	R0			;
						;
DTELE_OAMSET_010				;
		ADD	R1			;
		TO	R1			;
		SUB	#08			;8-10H

		FROM	R5			;R2 <- Zbgx@onrD
		LMULT				;
		WITH	R4			;
		HIB				;
		LOB				;
		SWAP				;
		OR	R4			;
		ADD	R2			;
		TO	R2			;
		ADD	#08			;

		mLDW	R4,CENOAML,R10
		IBT	R12,#002		;R12 <- c[v񐔃Zbg
		IBT	R3,#010H		;
		mLDB0	CENCHPT,R10		;ȂȂ ?
		SUB	#1			;
		BEQ	DTELE_OAMSET_100	; yes: DTELE_OAMSET_100
		WITH	R2

		SUB	R3
		IBT	R12,#004		;R12 <- c[v񐔃Zbg
		WITH	R2

DTELE_OAMSET_100
		SUB	R3

		MOVES	R8,R8			; ?
		BEQ	DTELE_OAMSET_110	; yes: DTELE_OAMSET_110
		NOP

		WITH	R1
		ADD	R3
		IBT	R3,#0F0H

DTELE_OAMSET_110
		IBT	R5,#02
		IWT	R11,#0FF01H

		IWT	R0,#CENCLOR		;ATR SET
		ADD	R10
		TO	R7
		LDB	(R0)
		FROM	R8			;ENMUKI
		ADD	R8
		ADD	R0
		MULT	#008H
		TO	R7
		XOR	R7
;
		CACHE
		MOVE	R13,R15

		MOVE	R9,R1
		FROM	R9

DTELE_OAMSET_130
		STW	(R4)
		INC	R4
		INC	R4
		FROM	R2
		STW	(R4)
		INC	R4
		INC	R4
		INC	R4
		LDW	(R4)
		AND	R11
		OR	R7
		SBK
		INC	R4
		FROM	R5
		STW	(R4)
		INC	R4
		INC	R4

		FROM	R9
		CMP	R1
		BNE	DTELE_OAMSET_200
		WITH	R2

		WITH	R9
		ADD	R3
		BRA	DTELE_OAMSET_130
		FROM	R9

DTELE_OAMSET_200
		ADD	#0FH

		LOOP
		INC	R2

		STOP
		NOP
;
;********************************************************************************
;*		낼[ʂn`lZbg					*
;*										*
;*	[In]									*
;*		(R0)  <-- n`lZbgf[^oN				*
;*		(R1)  <-- ENDSXL						*
;*		(R2)  <-- ENDSYL						*
;*		(R8)  <-- ENMUKI						*
;*		(R10) <-- G̃CfbNX					*
;*		(R12) <-- {̂̃LN^[f[^				*
;*		(R14) <-- {̂n`lZbgf[^AhX			*
;*		WRK12  <-- ̃LN^[f[^				*
;*		WRK13  <-- n`lZbgf[^AhX				*
;*		WRK14  <-- 둫n`lZbgf[^AhX			*
;*		WRK15  <-- ̒w						*
;*		WRK16  <-- ̒x						*
;*		WRK1C  <-- ZbgX^[gw					*
;*		WRK1D  <-- ZbgX^[gx					*
;*										*
;*	[Out]									*
;*		WRK1E  <-- ̐[ItZbgw					*
;*		WRK1F  <-- ̐[ItZbgx					*
;*										*
;********************************************************************************
M_GEROZ_OAMSET	EQU	$
		ROMB
;
		LMS	R0,CWORK1C
		SEX
		SBK
		LMS	R0,CWORK1D
		SEX
		SBK
;
		WITH	R14			;(R14) <-- Zbgp^[n`lf[^AhX
		ADD	#0			;

		SMS	R10,REG10
		mJSR	OAMSET_SB
		LMS	R10,REG10
;
		LMS	R0,CWORK13		;(R14) <-- Zbgp^[n`lf[^AhX
		MOVES	R14,R0			;LтĂ ?
		BEQ	GEROZ_OAMSET_100+1	;  no: GEROZ_OAMSET_100+1
		LMS	R0,CWORK1C		;CWRK1E <- ZbgX^[gw
		LMS	R7,CWORK15		;
		WITH	R7			;
		DIV2				;
		SUB	R7			;
		SMS	R0,CWORK1E		;
		LMS	R7,CWORK16		;CWRK1F <- ZbgX^[gx
		WITH	R7			;
		DIV2				;
		LMS	R0,CWORK1D		;
		SUB	R7			;
		SMS	R0,CWORK1F		;

		LMS	R12,CWORK12		;(R12) <-- ZbgLN^[f[^
		SMS	R10,REG10
		mJSR	OAMSET_SB
		LMS	R10,REG10

GEROZ_OAMSET_100
		LMS	R0,CWORK14		;(R14) <-- Zbgp^[n`lf[^AhX
		MOVES	R14,R0			;둫Ȃ ?
		BEQ	GEROZ_OAMSET_800	; yes: GEROZ_OAMSET_800
		NOP

		IBT	R12,#002		;(R12) <-- ZbgLN^[f[^
		mJSR	OAMSET_SB

GEROZ_OAMSET_800

		STOP
		NOP
;
;****************************************************************
;*								*
;*		l̕ω[`iP_j			*
;*								*
;*	[In]							*
;*		R1	ω錳̐@̂P		*
;*		R2	@@@@@h@@@@@Q		*
;*		R3	@@@@@h@@@@@R		*
;*		R6	ωʁiPOOPOOgj		*
;*		R7	ω̐@̂P		*
;*		R8	@@@@@h@@@@@Q		*
;*		R9	@@@@@h@@@@@R		*
;*								*
;*	[Out]							*
;*		R1	ω̐@̂P			*
;*		R2	@@@@h@@@Q			*
;*		R3	@@@@h@@@R			*
;*								*
;****************************************************************
M_B_1P_MORPH	EQU	$
		IWT	R10,#00100H
		IWT	R11,#00200H
		IWT	R12,#001FEH

		FROM	R1
		TO	R4
		SUB	R7
		FROM	R4
		ADD	R10
		CMP	R11
		BCC	M_B_1P_MORPH0600
		NOP

		BMI	M_B_1P_MORPH0400
		WITH	R4

		BRA	M_B_1P_MORPH0600
		SUB	R11

M_B_1P_MORPH0400
		ADD	R11

M_B_1P_MORPH0600
		FROM	R4
		LMULT
		WITH	R4
		HIB
		LOB
		SWAP
		OR	R4
		FROM	R1
		SUB	R0
		TO	R1
		AND	R12

		FROM	R2
		SUB	R8
		LMULT
		WITH	R4
		HIB
		LOB
		SWAP
		OR	R4
		WITH	R2
		SUB	R0

		FROM	R3
		TO	R4
		SUB	R9
		FROM	R4
		ADD	R10
		CMP	R11
		BCC	M_B_1P_MORPH0900
		NOP

		BMI	M_B_1P_MORPH0700
		WITH	R4

		BRA	M_B_1P_MORPH0900
		SUB	R11

M_B_1P_MORPH0700
		ADD	R11

M_B_1P_MORPH0900
		FROM	R4
		LMULT
		WITH	R4
		HIB
		LOB
		SWAP
		OR	R4
		FROM	R3
		SUB	R0
		TO	R3
		AND	R12

		STOP
		NOP
;
;****************************************************************
;*		enemy 1 point rotation				*
;****************************************************************
;[IN]		R1	px	i@őPed@j
;		R5	w@onrD
;		R6	x@onrD
;
;[OUT]		R0	w@onrD
;		R1	x@onrD
;
M_ENMY_1P_ROT2	EQU	$
		mJSR	M_ENMY_1P_ROT2_S

		STOP
		NOP
;
M_ENMY_1P_ROT2_S
		IBT	R0,#BANK SIN
		ROMB

		IWT	R0,#SIN
		TO	R14
		ADD	R1

		IWT	R0,#COS
		TO	R9
		ADD	R1

		GETB
		INC	R14
		GETBH
		MOVE	R7,R0

		LMULT			;R2 <- Y SIN
		WITH	R4		;
		HIB			;
		LOB			;
		SWAP			;
		TO	R2		;
		OR	R4		;

		MOVE	R14,R9
		GETB
		INC	R14
		GETBH
		MOVE	R8,R0

		LMULT			;R3 <- Y COS
		WITH	R4		;
		HIB			;
		LOB			;
		SWAP			;
		TO	R3		;
		OR	R4		;

		MOVE	R6,R5
		FROM	R7		;R1 <- X SIN + Y COS
		LMULT			;
		WITH	R4		;
		HIB			;
		LOB			;
		SWAP			;
		OR	R4		;
		TO	R1		;
		ADD	R3		;

		FROM	R8		;R0 <- X COS - Y SIN
		LMULT			;
		WITH	R4		;
		HIB			;
		LOB			;
		SWAP			;
		OR	R4		;
		ADD	R2		;

		mRTS
;;
;;********************************************************************************
;;*		߃{Xn`lZbg						*
;;*										*
;;*	[In]									*
;;*		(R10) <-- G̃CfbNX					*
;;*		WRK0  <-- f[^oN						*
;;*		WRK9  <-- ItZbgʒuf[^AhX				*
;;*		WRK11  <-- Zbgw@onrD					*
;;*		WRK12  <-- Zbgx@onrD					*
;;*		REG4  <-- n`lZbgAhX					*
;;*										*
;;********************************************************************************
;M_BOSS0_OAMSET2 EQU	$
;		LMS	R0,CWORK0
;		ROMB
;;
;		LMS	R0,CWORK10		;R14 <-- n`lZbgf[^AhX
;		MULT	R12			;
;		MULT	#05			;
;		LMS	R1,CWORK9		;
;		TO	R14			;
;		ADD	R1			;
;		mJSR	BOSS0_OAMSET_SB
;
;		STOP
;		NOP
;
;********************************************************************************
;*		߃{Xn`lZbg						*
;*										*
;*	[In]									*
;*		(R10) <-- G̃CfbNX					*
;*		WRK0  <-- eqnlf[^oN					*
;*		WRK1  <-- eqnlf[^bgos				*
;*		WRK2  <-- snf[^bgos					*
;*		WRK3  <-- [tBOiO`POOgj			*
;*		WRK4  <-- [tBOtO				*
;*		WRK5  <-- [tBOtO					*
;*		WRK7  <-- ENDSXL+8						*
;*		WRK8  <-- ENDSYL+8						*
;*		WRK9  <-- OItZbgʒuf[^AhX			*
;*		WRKA  <-- OItZbgʒuf[^AhX			*
;*		WRKB  <-- ItZbgʒuf[^AhX			*
;*		WRKC  <-- ItZbgʒuf[^AhX			*
;*		WRKD  <-- ItZbgʒuf[^AhX			*
;*		WRKE  <-- 㑫ItZbgʒuf[^AhX			*
;*		WRKF  <-- n`lf[^x[XAhX				*
;*		WRK13 <-- ÕItZbgw@onrD				*
;*		WRK14 <-- 㑫̃ItZbgw@onrD				*
;*		WRK15 <-- G̉]peqnlf[^CfbNX			*
;*		WRK16 <-- G̉]psnf[^CfbNX			*
;*		WRK17 <-- G̉]pf[^AhX				*
;*		WRK18 <-- G̉]pf[^[tBOtO		*
;*		WRK19 <-- ړtO					*
;*		REG3  <-- _[WJE^[					*
;*		REG8  <-- BBODYXZM						*
;*		REG9  <-- BBODYYZM						*
;*										*
;*	[Out]									*
;*		WRK10 <-- ZbgmnD						*
;*		WRK11 <-- b̃ZbgSw@onrD				*
;*		WRK12 <-- b̃ZbgSx@onrD				*
;*		WRK13 <-- ÕItZbgw@onrD				*
;*		WRK14 <-- 㑫̃ItZbgw@onrD				*
;*		WRK1A <-- ̉]p						*
;*		WRK1B <-- ̉]p						*
;*		WRK1C <-- ̉]p						*
;*		WRK1D <-- ̉]p						*
;*		WRK1E <-- b̉]p						*
;*		WRK1F <-- ɂȂ鑫̃Z^[x@onrD			*
;*		REG0  <-- ̃ItZbgw@onrD				*
;*		REG10 <-- ̃ItZbgx@onrD				*
;*		REG11 <-- `FbNEWIDEY					*
;*		REG12 <-- `FbNEPWIDY					*
;*		REG13 <-- vC[NX`FbŇ			*
;*		REG15 <-- `FbNWf[^AhX				*
;*										*
;*	[Break]									*
;*		WRK10,WRK11,WRK12,WRK1E,WRK1F,REG1,REG2,REG4,REG5,REG6,REG7	*
;*		REG14								*
;*										*
;********************************************************************************
M_BOSS0_OAMSET	EQU	$
		mLDW0	CENOAML,R10
		MOVES	R4,R0
		BPL	BOSS0_OAMSET_000	;n`lmہH ( yes:BOSS0_OAMSET_000 )
		NOP
;
		STOP
		NOP
;
BOSS0_OAMSET_000
		SMS	R4,REG4
;
		LMS	R0,CWORK4		;WRK1E <- [tBOtO
		SMS	R0,CWORK1E
;
		LMS	R7,CWORKF
		IBT	R6,#05*7
		LMS	R0,CWORK1		;WRK1 <- eqnlf[^AhX
		MULT	R6
		ADD	R7
		SBK
		SMS	R0,REG1
		LMS	R0,CWORK2		;WRK2 <- snf[^AhX
		MULT	R6
		ADD	R7
		SBK
		SMS	R0,REG2
		LMS	R0,CWORK5
		SMS	R0,REG5
;
		mJSR	BOSS0_MOVE
;
		LMS	R0,CWORK4		;WRK1E <- [tBOtO
		SMS	R0,CWORK1E
;
		LMS	R0,REG1
		SMS	R0,CWORK1
		LMS	R0,REG2
		SMS	R0,CWORK2
		LMS	R0,REG5
		SMS	R0,CWORK5
;
		IWT	R0,#BOSS0_RANGE		;`FbNWf[^AhX
		SMS	R0,REG15		;
		IBT	R0,#01			;vC[NX`FbŇʂNA
		SMS	R0,REG13		;
;
;O
		mJSR	BOSS0_MORPH
		mJSR	BOSS0_PLCHK
		LMS	R0,CWORK12
		SMS	R0,CWORK1F
		IBT	R12,#04
		LMS	R0,CWORK10		;R14 <-- n`lZbgf[^AhX
		MULT	R12			;
		MULT	#05			;
		LMS	R1,CWORK9		;
		TO	R14			;
		ADD	R1			;
		mJSR	BOSS0_OAMSET_SB
;O
		mJSR	BOSS0_MORPH
		mJSR	BOSS0_PLCHK
		IBT	R12,#04
		LMS	R0,CWORK10		;R14 <-- n`lZbgf[^AhX
		MULT	R12			;
		MULT	#05			;
		LMS	R1,CWORKA		;
		TO	R14			;
		ADD	R1			;
		mJSR	BOSS0_OAMSET_SB
;
		mJSR	BOSS0_MORPH
;;;;;;;;		mJSR	BOSS0_PLCHK
		LMS	R0,REG15		;̃`FbNWf[^AhXvZ
		INC	R0			;
		INC	R0			;
		SBK				;
		LMS	R0,REG13		;vC[NX`FbŇINC.
		INC	R0			;
		INC	R0			;
		SBK				;
;
		IBT	R12,#01
		LMS	R0,CWORK10		;R14 <-- n`lZbgf[^AhX
		MULT	R12			;
		MULT	#05			;
		LMS	R1,CWORKB		;
		TO	R14			;
		ADD	R1			;
		mJSR	BOSS0_OAMSET_SB
;
		mJSR	BOSS0_MORPH
		LMS	R0,REG6
		SMS	R0,REG0
		LMS	R0,REG7
		SMS	R0,REG10
		mJSR	BOSS0_PLCHK
		IBT	R12,#04
		LMS	R0,CWORK10		;R14 <-- n`lZbgf[^AhX
		MULT	R12			;
		MULT	#05			;
		LMS	R1,CWORKC		;
		TO	R14			;
		ADD	R1			;
		mJSR	BOSS0_OAMSET_SB
;
		mJSR	BOSS0_MORPH
		IBT	R12,#04
		LMS	R0,CWORK10		;R14 <-- n`lZbgf[^AhX
		MULT	R12			;
		MULT	#05			;
		LMS	R1,CWORKD		;
		TO	R14			;
		ADD	R1			;
		mJSR	BOSS0_OAMSET_SB
;㑫
		mJSR	BOSS0_MORPH
		LMS	R1,CWORK12		;OnʂɒĂ ?
		LMS	R0,CWORK1F		;
		SUB	R1			;
		BPL	BOSS0_OAMSET_700	; yes: BOSS0_OAMSET_700
		FROM	R1

		SBK

BOSS0_OAMSET_700
		IBT	R12,#04
		LMS	R0,CWORK10		;R14 <-- n`lZbgf[^AhX
		MULT	R12			;
		MULT	#05			;
		LMS	R1,CWORKE		;
		TO	R14			;
		ADD	R1			;
		mJSR	BOSS0_OAMSET_SB
;b
		mJSR	BOSS0_MORPH
;
		LMS	R0,CWORK18		;WRK1E <- G̉]pf[^[tBOtO
		SMS	R0,CWORK1E
;
		LMS	R7,CWORK17
		IBT	R6,#05
		LMS	R0,CWORK15		;WRK1 <- eqnlf[^AhX
		MULT	R6
		ADD	R7
		SBK
		LMS	R0,CWORK16		;WRK2 <- snf[^AhX
		MULT	R6
		ADD	R7
		SBK
;
		LMS	R0,CWORK0
		ROMB
;
		mJSR_X	BOSS0_A_M_SB
		CACHE
		SMS	R1,CWORK1A
		mJSR	BOSS0_A_M_SB
		SMS	R1,CWORK1B
		mJSR	BOSS0_A_M_SB
		SMS	R1,CWORK1C
		mJSR	BOSS0_A_M_SB
		SMS	R1,CWORK1D
		mJSR	BOSS0_A_M_SB
		SMS	R1,CWORK1E

		mJSR	BOSS0_PLCHK_K

		STOP
		NOP
;
;********************************************************************************
;*		߃{XvC[`FbN[`				*
;*										*
;*	[In]									*
;*		(R10) <-- G̃CfbNX					*
;*		REG3  <-- _[WJE^[					*
;*		REG6  <-- ItZbgw@onrD				*
;*		REG7  <-- ItZbgx@onrD				*
;*		REG8  <-- BBODYXZM						*
;*		REG9  <-- BBODYYZM						*
;*		REG13 <-- vC[NX`FbŇ			*
;*		REG15 <-- `FbNWf[^AhX				*
;*										*
;*	[Break]									*
;*		R4,R6,R7,R8,REG14						*
;*										*
;*	[Out]									*
;*		REG11 <-- `FbNEWIDEY					*
;*		REG12 <-- `FbNEPWIDY					*
;*		REG13 <-- vC[NX`FbŇ			*
;*		REG15 <-- `FbNWf[^AhX				*
;*										*
;********************************************************************************
BOSS0_RANGE
		HEX	008,008		;mn
		HEX	006,006		;mn
		HEX	003,003		;mn
		HEX	008,008		;mn
;
BOSS0_PLCHK
		SMS	R14,REG14

		LMS	R0,REG3			;_[W󂯂Ă ?
		SUB	#0			;
		BNE	BOSS0_PLCHK0300		; yes: BOSS0_PLCHK0300
		NOP

		IWT	R0,#BANK BOSS0_RANGE
		ROMB

		mLDW	R7,CEPWIDX,R10		;w`FbN͈͓ ?
		LMS	R0,REG6			;
		TO	R8			;
		ADD	R7			;
						;
		LMS	R7,CPWIDEX		;
		LMS	R14,REG15		;
		LMS	R6,REG8			;
		GETB				;
		LMULT				;
		WITH	R4			;
		HIB				;
		LOB				;
		SWAP				;
		OR	R4			;
		ADD	R7			;
		TO	R4			;
		ADD	R0			;
		ADD	R8			;
		CMP	R4			;
		BCS	BOSS0_PLCHK0300		;  no: BOSS0_PLCHK0300
		NOP

		INC	R14			;x`FbN͈͓ ?
		mLDW	R7,CEPWIDY,R10		;
		LMS	R0,REG7			;
		TO	R8			;
		ADD	R7			;
		SMS	R8,REG12		;
						;
		LMS	R7,CPWIDEY		;
		LMS	R6,REG9			;
		GETB				;
		LMULT				;
		WITH	R4			;
		HIB				;
		LOB				;
		SWAP				;
		OR	R4			;
		SMS	R0,REG11		;
		ADD	R7			;
		TO	R4			;
		ADD	R0			;
		ADD	R8			;
		CMP	R4			;
		BCS	BOSS0_PLCHK0300		;  no: BOSS0_PLCHK0300
		NOP

		LMS	R0,REG13		;vC[NX`FbŇʃZbg
		DEC	R0			;
		BRA	BOSS0_PLCHK0500		;
		SBK				;

BOSS0_PLCHK0300
		LMS	R0,REG15		;̃`FbNWf[^AhXvZ
		INC	R0			;
		INC	R0			;
		SBK				;
		LMS	R0,REG13		;vC[NX`FbŇINC.
		INC	R0			;
		INC	R0			;
		SBK				;

BOSS0_PLCHK0500
		LMS	R0,CWORK0
		ROMB

		LMS	R14,REG14

BOSS0_PLCHK0800
BOSS0_P_K0000

		mRTS
;
;********************************************************************************
;*		߃{XvC[`FbN[`				*
;*										*
;*	[In]									*
;*		(R10) <-- G̃CfbNX					*
;*		WRK1E <-- b̉]p						*
;*		REG6  <-- b̃ItZbgw@onrD				*
;*		REG7  <-- b̃ItZbgx@onrD				*
;*		REG8  <-- BBODYXZM						*
;*		REG9  <-- BBODYYZM						*
;*		REG13 <-- vC[NX`FbŇ			*
;*										*
;*	[Break]									*
;*		R4,R6,R7,R8,REG14						*
;*										*
;*	[Out]									*
;*		REG11 <-- `FbNEWIDEY					*
;*		REG12 <-- `FbNEPWIDY					*
;*		REG13 <-- vC[NX`FbŇ			*
;*										*
;********************************************************************************
BOSS0_PLCHK_K
		LMS	R0,REG13		;łɂǂɂĂ ?
		LSR				;
		BCC	BOSS0_P_K0000		; yes: BOSS0_P_K0000
		NOP

		SMS	R14,REG14
		SMS	R11,RTS0

		LMS	R6,REG8			;R0 <- w@onrD
		IBT	R0,#016H		;
		LMULT				;
		WITH	R4			;
		HIB				;
		LOB				;
		SWAP				;
		OR	R4			;
		SMS	R0,CWORK2
		LMS	R1,CWORK1E
		mJSR_X	M_1P_ROT
		WITH	R0
		SUB	#0
		BPL	BOSS0_P_K0100
		NOP

		NOT
		INC	R0

BOSS0_P_K0100
		SMS	R0,CWORK0

		FROM	R1
		SUB	#0
		BPL	BOSS0_P_K0110
		WITH	R1

		NOT
		INC	R1

BOSS0_P_K0110
		SMS	R1,CWORK1

		LMS	R6,REG9			;R0 <- x@onrD
		IBT	R0,#014H		;
		LMULT				;
		WITH	R4			;
		HIB				;
		LOB				;
		SWAP				;
		OR	R4			;
		SMS	R0,CWORK3
		LMS	R1,CWORK1E
		mJSR_X	M_1P_ROT
		WITH	R0
		SUB	#0
		BPL	BOSS0_P_K0120
		NOP

		NOT
		INC	R0

BOSS0_P_K0120
		LMS	R5,CWORK1
		CMP	R5
		BMI	BOSS0_P_K0121
		NOP

		SBK

BOSS0_P_K0121
		MOVES	R0,R1
		BPL	BOSS0_P_K0130
		FROM	R1

		NOT
		INC	R0

BOSS0_P_K0130
		LMS	R5,CWORK0
		CMP	R5
		BMI	BOSS0_P_K0131
		NOP

		SBK

BOSS0_P_K0131
		LMS	R11,RTS0

		mLDW	R7,CEPWIDX,R10		;w`FbN͈͓ ?
		LMS	R0,REG6			;
		TO	R8			;
		ADD	R7			;
						;
		LMS	R7,CPWIDEX		;
		LMS	R0,CWORK0		;
		ADD	R7			;
		TO	R4			;
		ADD	R0			;
		ADD	R8			;
		CMP	R4			;
		BCS	BOSS0_P_K0300		;  no: BOSS0_P_K0300
		NOP

		mLDW	R7,CEPWIDY,R10		;x`FbN͈͓ ?
		LMS	R0,REG7			;
		TO	R8			;
		ADD	R7			;
		SMS	R8,REG12		;
						;
		LMS	R7,CPWIDEY		;
		LMS	R0,CWORK1		;
		SMS	R0,REG11		;
		ADD	R7			;
		TO	R4			;
		ADD	R0			;
		ADD	R8			;
		CMP	R4			;
		BCS	BOSS0_P_K0300		;  no: BOSS0_P_K0300
		NOP

		LMS	R0,REG13		;vC[NX`FbŇʃZbg
		DEC	R0			;
		SBK				;

BOSS0_P_K0300
		LMS	R14,REG14

		mRTS
;
;********************************************************************************
;*		߃{Xړ[`						*
;*										*
;*	[In]									*
;*		(R10) <-- G̃CfbNX					*
;*		WRK0  <-- eqnlf[^oN					*
;*		WRK1  <-- eqnlf[^AhX				*
;*		WRK2  <-- snf[^AhX					*
;*		WRK3  <-- [tBOiO`POOgj			*
;*		WRK1E <-- [tBOtO				*
;*		WRK5  <-- [tBOtO					*
;*		WRK7  <-- ENDSXL+8						*
;*		WRK8  <-- ENDSYL+8						*
;*		WRKF  <-- n`lf[^x[XAhX				*
;*		WRK13 <-- ÕItZbgw@onrD				*
;*		WRK14 <-- 㑫̃ItZbgw@onrD				*
;*		WRK19 <-- ړtO					*
;*		REG8  <-- BBODYXZM						*
;*		REG9  <-- BBODYYZM						*
;*										*
;*	[Out]									*
;*		WRK13 <-- ÕItZbgw@onrD				*
;*		WRK14 <-- 㑫̃ItZbgw@onrD				*
;*										*
;********************************************************************************
BOSS0_MOVE
		SMS	R11,RTS0
;
		mJSR	BOSS0_MV_SB
		SMS	R7,CWORK1A
		SMS	R8,CWORK1B
		IBT	R7,#05*5
		LMS	R0,CWORK1		;eqnlf[^AhX
		ADD	R7
		SBK
		LMS	R0,CWORK2		;snf[^AhX
		ADD	R7
		SBK
		IBT	R6,#020H
		LMS	R0,CWORK5		;[tBOtO
		LMULT
		FROM	R4
		SBK
		IWT	R6,#00400H
		LMS	R0,CWORK1E		;[tBOtO
		LMULT
		FROM	R4
		SBK
		mJSR	BOSS0_MV_SB

		LMS	R0,CWORK19		;ړ ?
		SUB	#0			;
		BEQ	BOSS0_MOVE0100+1	; yes: BOSS0_MOVE0100+1
		LMS	R0,CWORK1A

		SMS	R0,CWORK13
		SMS	R7,CWORK14
;
		LMS	R11,RTS0
;
		mRTS
;
BOSS0_MOVE0100
		LMS	R0,CWORK1B		;O̕nʂɒĂ ?
		SUB	R8			;
		BPL	BOSS0_MOVE0500		; yes: BOSS0_MOVE0500
		NOP

		LMS	R0,CWORK1A
		SMS	R0,CWORK13
		LMS	R1,CWORK14
		FROM	R7
		SBK
		WITH	R7
		SUB	R1
		BRA	BOSS0_MOVE0600
		NOP

BOSS0_MOVE0500
		SMS	R7,CWORK14
		LMS	R0,CWORK1A
		LMS	R1,CWORK13
		SBK
		TO	R7
		SUB	R1

BOSS0_MOVE0600
		mLDW0	CENXPSL,R10
		SUB	R7
		SBK
;
		LMS	R0,CWORK7
		SUB	R7
		SBK
;
		LMS	R11,RTS0
;
		mRTS
;
BOSS0_MV_SB
		SMS	R11,RTS1
;
		LMS	R0,CWORK0
		ROMB
;
		LMS	R14,CWORK2		;snf[^ǂ
		INC	R14			;
						;
		TO	R1			;
		GETB				;
		INC	R14			;
		TO	R2			;
		GETB				;
		INC	R14			;
		TO	R3			;
		GETB				;
		INC	R14			;
		TO	R5			;
		GETB				;

		LMS	R6,CWORK3		;[tBOPOO ?
		FROM	R6			;
		HIB				;
		BNE	BOSS0_MV_SB1000		; yes: BOSS0_MV_SB1000
		NOP

		LMS	R0,CWORK5		;[tBO ?
		ADD	R0			;
		BCC	BOSS0_MV_SB1000		;  no: BOSS0_MV_SB1000
		NOP

		LMS	R14,CWORK1		;WRK14 <- eqnlf[^AhX
		INC	R14			;

		mJSR_X	BOSS0_MORPH_SBA
		WITH	R1
		TO	R1		;[ MOVE R1,R0 ]

		mJSR_X	BOSS0_MORPH_SBR
		WITH	R2
		TO	R2		;[ MOVE R2,R0 ]

		mJSR_X	BOSS0_MORPH_SBA
		WITH	R3
		TO	R3		;[ MOVE R3,R0 ]

		mJSR_X	BOSS0_MORPH_SBR
		WITH	R5
		TO	R5		;[ MOVE R5,R0 ]

		LMS	R0,CWORK1E
		LSR
		LSR
		SBK
;
BOSS0_MV_SB1000
		mJSR_X	M_1P_ROT
		WITH	R2
		MOVE	R7,R0
		MOVE	R8,R1

		MOVE	R1,R3
		MOVE	R6,R5
		mJSR	M_1P_ROT_S
		TO	R7
		ADD	R7
		mLDB0	CENMUKI,R10		; ?
		SUB	#0			;
		BEQ	BOSS0_MV_SB1500		; yes: BOSS0_MV_SB1500
		WITH	R7

		NOT
		INC	R7

BOSS0_MV_SB1500
		LMS	R6,REG8
		FROM	R7
		LMULT
		WITH	R4
		HIB
		LOB
		SWAP
		TO	R7
		OR	R4

		FROM	R8
		ADD	R1
		LMS	R6,REG9
		LMULT
		WITH	R4
		HIB
		LOB
		SWAP
		TO	R8
		OR	R4
;
		LMS	R11,RTS1
;
		mRTS
;
;********************************************************************************
;*		߃{Xn`lp[tBOf[^vZ				*
;*										*
;*	[In]									*
;*		(R10) <-- G̃CfbNX					*
;*		WRK0  <-- eqnlf[^oN					*
;*		WRK1  <-- eqnlf[^AhX				*
;*		WRK2  <-- snf[^AhX					*
;*		WRK3  <-- [tBOiO`POOgj			*
;*		WRK1E <-- [tBOtO				*
;*		WRK7  <-- ENDSXL+8						*
;*		WRK8  <-- ENDSYL+8						*
;*		REG8  <-- BBODYXZM						*
;*		REG9  <-- BBODYYZM						*
;*										*
;*	[Out]									*
;*		WRK10 <-- ZbgmnD						*
;*		WRK11 <-- ZbgSw@onrD				*
;*		WRK12 <-- ZbgSx@onrD				*
;*										*
;********************************************************************************
BOSS0_MORPH
		SMS	R11,RTS0
;
		LMS	R0,CWORK0
		ROMB
;
		LMS	R14,CWORK2		;snf[^ǂ
						;
		GETB				;
		INC	R14			;
		SMS	R0,CWORK10		;
						;
		TO	R1			;
		GETB				;
		INC	R14			;
		TO	R2			;
		GETB				;
		INC	R14			;
		TO	R3			;
		GETB				;
		INC	R14			;
		TO	R5			;
		GETB				;
		INC	R14			;
						;
		SMS	R14,CWORK2		;WRK2 <- ̂snf[^AhX

		LMS	R6,CWORK3		;[tBOPOO ?
		FROM	R6			;
		HIB				;
		BNE	BOSS0_M1000		; yes: BOSS0_M1000
		NOP

		LMS	R14,CWORK1		;WRK14 <- eqnlf[^AhX

		LMS	R0,CWORK5		;[tBO ?
		ADD	R0			;
		BCS	BOSS0_M0400		;  yes: BOSS0_M0400
		SBK

		WITH	R14
		ADD	#05

		LMS	R0,CWORK1E
		ADD	R0
		ADD	R0
		BRA	BOSS0_M0700
		SBK

BOSS0_M0400
		TO	R4			;WRK10 <- LZbgmnD
		GETB				;
		INC	R14			;
						;
		FROM	R6			;	;[tBOTOȏ ?
		SEX				;	;
		BMI	BOSS0_M0500		;	; yes: BOSS0_M0500
		NOP				;
						;
		SMS	R4,CWORK10		;

BOSS0_M0500
		mJSR_X	BOSS0_MORPH_SBA
		WITH	R1
		TO	R1		;[ MOVE R1,R0 ]

		mJSR_X	BOSS0_MORPH_SBR
		WITH	R2
		TO	R2		;[ MOVE R2,R0 ]

		mJSR_X	BOSS0_MORPH_SBA
		WITH	R3
		TO	R3		;[ MOVE R3,R0 ]

		mJSR_X	BOSS0_MORPH_SBR
		WITH	R5
		TO	R5		;[ MOVE R5,R0 ]
;
BOSS0_M0700
		SMS	R14,CWORK1		;WRK1 <- ̂eqnlf[^AhX

BOSS0_M1000
		LMS	R12,CWORK7
		LMS	R13,CWORK8

		mJSR_X	M_1P_ROT
		WITH	R2
		MOVE	R7,R0
		MOVE	R8,R1

		MOVE	R1,R3
		MOVE	R6,R5
		mJSR	M_1P_ROT_S
		TO	R7
		ADD	R7
		mLDB0	CENMUKI,R10		; ?
		SUB	#0			;
		BEQ	BOSS0_M1100		; yes: BOSS0_M1100
		WITH	R7

		NOT
		INC	R7

BOSS0_M1100
		LMS	R6,REG8
		FROM	R7
		LMULT
		WITH	R4
		HIB
		LOB
		SWAP
		TO	R7
		OR	R4
		SMS	R7,REG6
		FROM	R7
		ADD	R12			;+ENDSXL+8
		SMS	R0,CWORK11
		FROM	R1
		ADD	R8
		LMS	R6,REG9
		LMULT
		WITH	R4
		HIB
		LOB
		SWAP
		OR	R4
		SMS	R0,REG7
		ADD	R13			;+ENDSYL+8
		SMS	R0,CWORK12

		LMS	R0,CWORK0
		ROMB
;
		LMS	R11,RTS0

		mRTS
;
;****************************************************************
;*		enemy 1 point rotation				*
;****************************************************************
;[IN]		R1	px	i@őee@j
;		R6	aAXJ[ʁAD
;
;[OUT]		R0	w
;		R1	x
;
M_1P_ROT
		TO	R6		;[ MOVE R6,R2 ]

		IBT	R0,#BANK LSIN
		ROMB

M_1P_ROT_S
		IWT	R0,#LSIN
		TO	R14
		ADD	R1

		IWT	R0,#LCOS
		TO	R2
		ADD	R1

		GETBS
		MULT	R6
		ADD	R0
		ADD	R0
		HIB
		TO	R1
		SEX

		MOVE	R14,R2
		GETBS
		MULT	R6
		ADD	R0
		ADD	R0
		HIB

		mRTS_X
		SEX
;
;********************************************************************************
;*		߃{Xn`lp[tBOf[^vZipxpTuj		*
;*										*
;*	[In]									*
;*		R*    <-- [tBOsnf[^				*
;*		R6    <-- [tBOiO`POOgj			*
;*		R14   <-- eqnlf[^AhX				*
;*		WRK1E  <-- [tBOtO				*
;*										*
;*	[Out]									*
;*		R0    <-- [tBǑ					*
;*		R14   <-- ̂eqnlf[^AhX				*
;*		WRK1E <-- ̃[tBOtO				*
;*										*
;*	[Break]									*
;*		R0,R4,R7,R8,R9,R12						*
;*										*
;********************************************************************************
BOSS0_MORPH_SBA
		TO	R7		;[ MOVE R7,R* ]

		TO	R8			;R8 <- eqnlf[^
		GETB				;
		INC	R14			;

		WITH	R7			;R7 <- f[^
		SUB	R8			;
		MOVE	R12,R7			;
						;
		IWT	R9,#00080H		;
		FROM	R7			;
		ADD	R9			;
		BNE	BOSS0_M_SBA0080		;
		WITH	R9			;
						;
		DEC	R0			;
		WITH	R9		;[ IWT	R9,#00100H ]
						;
BOSS0_M_SBA0080					;
		ADD	R9			;
		CMP	R9			;
		BCC	BOSS0_M_SBA0300		;
		FROM	R7			;
						;
		SUB	#0			;
		BPL	BOSS0_M_SBA0100		;
		WITH	R7			;
						;
		ADD	R9			;
		BRA	BOSS0_M_SBA0300		;
		NOP				;
						;
BOSS0_M_SBA0100					;
		SUB	R9			;
						;
BOSS0_M_SBA0300					;
		LMS	R0,CWORK1E		;肷 ?
		ADD	R0			;
		BCC	BOSS0_M_SBA0500		;  no: BOSS0_M_SBA0500
		SBK				;̃[tBOtOZbg

		MOVE	R7,R12

BOSS0_M_SBA0500
		FROM	R7			;R7 <- [tBO̊px
		LMULT				;
		WITH	R4
		HIB
		LOB
		SWAP
		OR	R4
		ADD	R8			;
		LOB				;

		mRTS_X
		WITH	R0
;
;********************************************************************************
;*		߃{Xn`lp[tBOf[^vZiapTuj		*
;*										*
;*	[In]									*
;*		R*    <-- [tBOsnf[^				*
;*		R6    <-- [tBOiO`POOgj			*
;*		R14   <-- eqnlf[^AhX				*
;*										*
;*	[Out]									*
;*		R0    <-- [tBǑ					*
;*		R14   <-- ̂eqnlf[^AhX				*
;*										*
;*	[Break]									*
;*		R0,R4,R8							*
;*										*
;********************************************************************************
BOSS0_MORPH_SBR
		TO	R0		;[ MOVE R0,R* ]

		TO	R8			;R8 <- eqnlf[^
		GETB				;
		INC	R14			;

		SUB	R8			;R0 <- [tBO̔a
		LMULT				;
		WITH	R4
		HIB
		LOB
		SWAP
		OR	R4
		ADD	R8			;

		mRTS_X
		WITH	R0
;
;********************************************************************************
;*										*
;*		(R10) <-- G̃CfbNX					*
;*		(R12) <-- LN^[f[^					*
;*		(R14) <-- n`lZbgf[^AhX				*
;*		WRK0  <-- n`lZbgf[^oN				*
;*		WRK11 <-- ZbgENDSXL						*
;*		WRK12 <-- ZbgENDSYL						*
;*		REG4  <-- n`lZbgAhX					*
;*										*
;********************************************************************************
;
BOSS0_OAMSET_SB
		LMS	R0,CWORK11
		TO	R1
		SUB	#008
		LMS	R0,CWORK12
		TO	R2
		SUB	#008
		LMS	R4,REG4
;
		mLDB	R3,CENCLOR,R10		;ATR SET
		mLDB0	CENMUKI,R10		;ENMUKI
		ADD	R0
		ADD	R0
		MULT	#008H
		XOR	R3
		TO	R3
		SWAP
;
		mLDB0	CENEMU0,R10		;DATA SET
		TO	R8
		SWAP
;
		SMS	R11,RTS0
		CACHE
		MOVE	R13,R15			; loop address set
;
		GETBS
		IWT	R9,#4000H		;H flip check data
		WITH	R9
		AND	R3
		BEQ	B0_OAMSET_SB120		;H frip ? [ no:B0_OAMSET_SB120 ]
		INC	R14			;[ * (Z)=1: IBT R9,#0 ]
;
		NOT
		INC	R0
		IBT	R9,#008H

B0_OAMSET_SB120
		TO	R5
		ADD	R1			; r5 <- x position
;
		GETBS
		IBT	R11,#00H		;V flip check data
		MOVES	R3,R3
		BPL	B0_OAMSET_SB130		;V frip ? [ no:B0_OAMSET_130 ]
		INC	R14
;
		NOT
		INC	R0
		IBT	R11,#008H

B0_OAMSET_SB130
		TO	R6
		ADD	R2		; r6 <- y position
;
		GETB
		INC	R14
		GETBH
		INC	R14
;
		TO	R7
		XOR	R3		; R7 <- atoribute & chara No.
;
		GETB			; oamsb
		AND	#02H
		BNE	B0_OAMSET_SB140
		NOP
;
		WITH	R5
		ADD	R9
		WITH	R6
		ADD	R11

B0_OAMSET_SB140
		GETBH			;(R0) <-- sub,data
		INC	R14
;
		FROM	R5
		STW	(R4)		; x position
		INC	R4
		INC	R4
;
		TO	R5		; r5 <- sub,data
		XOR	R8
;
		FROM	R6
		STW	(R4)		; y position
		INC	R4
		INC	R4
		FROM	R7
		STW	(R4)		; chara No., atoribute
		INC	R4
		INC	R4
		FROM	R5
		STW	(R4)		; oamsb,data
		INC	R4
;
		LOOP
		INC	R4

		LMS	R11,RTS0
		SMS	R4,REG4

		mRTS
;
;********************************************************************************
;*		߃{X]pp[tBOf[^vZ				*
;*										*
;*	[In]									*
;*		(R10) <-- G̃CfbNX					*
;*		WRK0  <-- eqnlf[^oN					*
;*		WRK15 <-- eqnlf[^AhX				*
;*		WRK16 <-- snf[^AhX					*
;*		WRK3  <-- [tBOiO`POOgj			*
;*		WRK1E <-- [tBOtO				*
;*										*
;********************************************************************************
BOSS0_A_M_SB
		SMS	R11,RTS0
;
		LMS	R14,CWORK16		;snf[^ǂ
		TO	R1			;
		GETB				;
		INC	R14			;
		FROM	R14			;
		SBK				;WRK16 <- ̂snf[^AhX

		LMS	R6,CWORK3		;[tBOPOO ?
		FROM	R6			;
		HIB				;
		BNE	BOSS0_A_M_SB1000	; yes: BOSS0_A_M_SB1000
		NOP

		LMS	R14,CWORK15		;R14 <- eqnlf[^AhX

		mJSR_X	BOSS0_MORPH_SBA
		WITH	R1
		TO	R1		;[ MOVE R1,R0 ]

		SMS	R14,CWORK15		;WRK15 <- ̂eqnlf[^AhX

BOSS0_A_M_SB1000
		LMS	R11,RTS0

		mRTS
;
;********************************************************************************
;*		߃{Xw@onrD␳					*
;*										*
;*	[In]									*
;*		(R1)  <-- BBODYANG						*
;*		(R2)  <-- BBODYACP						*
;*		(R3)  <-- S]p						*
;*		(R6)  <-- b̔a						*
;*		(R10) <-- G̃CfbNX					*
;*										*
;********************************************************************************
M_BOSS0_XPS_REV EQU	$
		mLDW	R4,CENMUKI,R10

		WITH	R1
		SUB	R3
		MOVES	R4,R4
		BNE	BOSS0_X_R0100
		NOP

		WITH	R1
		NOT
		INC	R1

BOSS0_X_R0100
		FROM	R1
		SUB	R2
		ADD	R0
		TO	R3
		LMULT

		mLDB	R5,CENXPSL+1,R10
		mLDB0	CENXPSL-1,R10
		mLDBn	R2,CENXPSL,R10
		WITH	R2
		SWAP
		TO	R2
		OR	R2
		FROM	R3
		SUB	#00
		BMI	BOSS0_X_R0300
		WITH	R2

		ADD	R4
		FROM	R5
		ADC	#00
		BRA	BOSS0_X_R0500
		NOP

BOSS0_X_R0300
		ADD	R4
		BCS	BOSS0_X_R0500
		FROM	R5

		SUB	#01

BOSS0_X_R0500
		LOB
		TO	R6
		SWAP
		FROM	R2
		HIB
		OR	R6
		SBK

		mSTB	R2,CENXPSL-1,R10

		STOP
		NOP
;
;
;
;
;
		END
