;************************************************************************
;*									*
;*	title name	: "yossy"					*
;*	proccess	: mario chip program.7				*
;*	file name	: ys_chip7					*
;*									*
;************************************************************************
;
;
		SALL
;
		include		ys_chip.inc
		include		ys_chip2.inc
;
		XALL
;
;
;------------------------------------------------------------------------
;-		global symbol						-
;------------------------------------------------------------------------
;
;------------------------------------------------------------------------
;-		extern symbol						-
;------------------------------------------------------------------------
;
;-------------< ys_chip0 >-----------------------------------------------
		EXT	COS,SIN,LCOS,LSIN
;
;-------------< ys_msub0 >-----------------------------------------------
;
;-------------< GmD >---------------------------------------
		EXT	FKPBM,KPBOM
;
;-------------< ys_msge0 >-----------------------------------------------
		EXT	MSG_FONT
;
;------------------------------------------------------------------------
;-		define symbol						-
;------------------------------------------------------------------------
UNDTADD		EQU	4c32a4H
UNDATA		EQU	4c33f2H
;
;
;
;
;************************************************************************
;*									*
;*		program start						*
;*									*
;************************************************************************
;
;
Group_9		GROUP	S_chip_7
S_chip_7	SECT	REL
;
;
;************************************************************************
;*		GfBOrbg}bvp				*
;*		Rc\C					*
;*			 F (R1)   <-- XN[ʂyW		*
;*				(R2)   <--	h     xW		*
;*				(R3)   <--	h     wW		*
;*				(R5)   <-- obt@ AhX		*
;*				(CWK0) <-- f[^			*
;************************************************************************
;
E_BITMAP	EQU	$
		SUB	R0		;vbg[hZbg
		CMODE
;
		SMS	R1,CWORK1	;(CWK1) <-- XN[ʂyW
		SMS	R2,CWORK2	;(CWK2) <--	 h	xW
		SMS	R3,CWORK3	;(CWK3) <--	 h	wW
;
		CACHE
;
E_BITMAP_0050
		LDW	(R5)		;(R0) <-- naiyW
		INC	R0
		BNE	E_BITMAP_0060	;f[^dmcH ( no:E_BITMAP_0060 )
		DEC	R0
;
		RPIX
;
		STOP
		NOP
;
E_BITMAP_0060
		SUB	R1
		BMI	E_BITMAP_0110	;XN[ʂOH ( yes:E_BITMAP_0110 )
		INC	R5
;
E_BITMAP_0100
		IWT	R6,#01C0H
		SUB	R6
		BCC	E_BITMAP_0150	;XN[ʂ牓H ( no:E_BITMAP_0150 )
		ADD	R6
;
E_BITMAP_0110
		WITH	R5
		ADD	#6-1
		BRA	E_BITMAP_0050+1
		LDW	(R5)
;
E_BITMAP_0150
		MOVE	R7,R0		;(R7) <-- XN[ʂ̂y
		IWT	R6,#040H	;XN[ʂyW␳l
		ADD	R6
		ADD	R0
		IWT	R6,#BITMAP_DIV
		ADD	R6
		TO	R6		;(R6) <-- XN[ʂł̔{
		LDW	(R0)
;
		INC	R5
		LDB	(R5)		;(R0) <-- naiwW
		SEX
		SUB	R3
		LMULT
		WITH	R4
		HIB
		LOB
		SWAP
		OR	R4
		IBT	R4,#(24*8)/2
		TO	R3		;(R3) <-- XN[ʕ\wW
		ADD	R4
;
		INC	R5
		LDB	(R5)		;(R0) <-- naixW
		SEX
		SUB	R2
		LMULT
		WITH	R4
		HIB
		LOB
		SWAP
		OR	R4
		IBT	R4,#32
		TO	R2		;(R2) <-- XN[ʕ\xW
		ADD	R4
;
		INC	R5
		LDB	(R5)		;(R0) <-- LN^[{{
		ADD	R0		;~SiPOOgOSOgj
		ADD	R0		;
		LMULT
		WITH	R4
		HIB
		LOB
		SWAP
		TO	R6		;(R6) <-- XN[ʂł̃LN^[{
		OR	R4
;
		IBT	R0,#BANK BITMAP_OBJ_TBL ;nai^Cvf[^AhXiajZbg
		ROMB
;
		INC	R5
		LDB	(R5)		;(R0) <-- nai^CvmDpbgmD
		SMS	R5,REG5		;(R5) save
;
		IWT	R4,#11000000B
		TO	R5		;(R5) <-- pbgmD~SOg
		AND	R4
		BIC	R4
		MULT	#7		;~V
		IWT	R14,#BITMAP_OBJ_TBL
		TO	R14		;(R14) <-- nai^Cvf[^AhXikCgj
		ADD	R14
;
		FROM	R7
		LSR
		LSR
		LSR
		IBT	R4,#030H
		AND	R4
		TO	R5		;(R5) <-- VF[fBO
		OR	R5
;
		GETB			;(R0) <-- LN^[Sw
		INC	R14
		SWAP			;~POOg
		FMULT
		ADC	R3
		MOVE	R3,R0		;(R3) <-- XN[ʕ\wW
		IWT	R1,#24*8	;(R1) <-- rbg}bvőwW
		SUB	R1
		BPL	E_BITMAP_0152	;\njH ( no:E_BITMAP_0152 )
		GETB			;(R0) <-- LN^[Sx
;
		INC	R14
		SWAP
		FMULT
		ADC	R2
		MOVE	R2,R0		;(R2) <-- XN[ʕ\xW
		IWT	R8,#16*8	;(R8) <-- rbg}bvőxW
		SUB	R8
		BPL	E_BITMAP_0152	;\njH ( no:E_BITMAP_0152 )
		GETB			;(R0) <-- LN^[w
;
		INC	R14
		SWAP
		FMULT
		TO	R9		;(R9) <-- XN[ʕ\EwW
		ADD	R3
		BMI	E_BITMAP_0152	;\njH ( no:E_BITMAP_0152 )
		GETB			;(R0) <-- LN^[x
;
		INC	R14
		SWAP
		FMULT
		TO	R10		;(R10) <-- XN[ʕ\ExW
		ADD	R2
		BPL	E_BITMAP_0154	;\njH ( yes:E_BITMAP_0154 )
		GETB
;
E_BITMAP_0152
		mDJMP_X E_BITMAP_0600+1
		LMS	R1,CWORK1	;(R1) <-- XN[ʂyW
;
E_BITMAP_0154
		INC	R14
		TO	R11		;(R11) <-- LN^[AhXikCgj
		GETBH
		INC	R14
;
;------------------------------------------------------------------------
;-		LN^[ZbgiP^{jvZ			-
;-		Z							-
;-			in :						-
;-				(R7) <-- 폜				-
;-				(R6) <-- 				-
;-			out :						-
;-				(R4) <-- 				-
;-				(R0) <-- ]				-
;------------------------------------------------------------------------
		IBT	R7,#01H		;(R7) <-- PDO
;
		SUB	R0		;(R0) <-- AL[^NA
		MOVE	R4,R0		;(R4) <-- NA
;
		IBT	R12,#32
		IWT	R13,#E_BITMAP_0160+1
E_BITMAP_0160
		WITH	R4		;փVtg
		ADD	R4
		WITH	R7		;폜փVtg
		ADD	R7
		ROL			;폜AL[^ɃVtg
		SUB	R6		;AL[^Ər
		BCC	E_BITMAP_0170	;AL[^ł΁AZȗ
		ADD	R6
;
		SUB	R6		;AL[^珜
		INC	R4		;ɂP
E_BITMAP_0170
		LOOP
		WITH	R4
;
		MOVE	R6,R4		;(R6) <-- XN[ʂł̃LN^[{
;
		GETB
		IBT	R4,#7FH
		AND	R4
		ROMB			;LN^[AhXiajZbg
;
		GETBS
		IWT	R4,#8000H
		AND	R4
		TO	R5		;(R5) <-- ʂʂSrbg[h
		OR	R5
;
;------------------------------------------------------------------------
;-		LN^[gAk					-
;-			 F (R1)  <-- rbg}bvőwW	-
;-				(R8)  <-- rbg}bvőxW	-
;-				(R2)  <-- rbg}bvWQx	-
;-				(R3)  <--	   h	      Qw	-
;-				(R5)  <-- pbgmD		-
;-				(R6)  <-- {iPOOgPDOj	-
;-				(R9)  <-- Erbg}bvWQw	-
;-				(R10) <--	    h	      Qx	-
;-				(R11) <-- LN^[AhXikCgj-
;------------------------------------------------------------------------
;
;-------------- LN^[X^[g|C^[vZ ----------------------
		IBT	R7,#0		;(R7) <-- LN^[X^[g|C^[x
		MOVES	R0,R2
		BPL	E_BITMAP_0200	;rbg}bvGA[I[o[H ( no:E_BITMAP_0200 )
		NOT
;
		INC	R0
		LMULT
		MOVE	R7,R4		;(R7) <-- LN^[X^[g|C^[x
		IBT	R2,#0
E_BITMAP_0200
		IBT	R4,#0		;(R4) <-- LN^[X^[g|C^[w
		MOVES	R0,R3
		BPL	E_BITMAP_0250	;rbg}bvGA[I[o[H ( no:E_BITMAP_0250 )
		NOT
;
		INC	R0
		LMULT			;(R4) <-- LN^[X^[g|C^[w
		IBT	R3,#0
E_BITMAP_0250
;
;-------------- LN^[ ------------------------------------
		DEC	R1		;[ IBT R1,#24*8-1 ]
		FROM	R1
		SUB	R9
		BCC	E_BITMAP_0300
		ADD	R9
;
		FROM	R9
E_BITMAP_0300
		TO	R9		;(R9) <-- X loop no.
		SUB	R3
		INC	R9
;
		DEC	R8		;[ IBT R8,#16*8-1 ]
		FROM	R8
		SUB	R10
		BCC	E_BITMAP_0350
		ADD	R10
;
		FROM	R10
E_BITMAP_0350
		TO	R10
		SUB	R2
		INC	R10
;
		IWT	R13,#E_BITMAP_0450 ;(R13) <-- loop address
E_BITMAP_0400
		MOVE	R1,R3		;(R1) <-- plot start X pos set
		MOVE	R8,R4		;(R8) <-- PX
;
		MOVE	R12,R9		;(R12) <-- X loop no.
E_BITMAP_0450
		MERGE
		TO	R14
		ADD	R11
;
		WITH	R8
		ADD	R6
;
		MOVES	R5,R5
		BPL	E_BITMAP_0500	;high color ? ( no:E_BITMAP_0500 )
		GETB			;color read
;
		LSR
		LSR
		LSR
		LSR
E_BITMAP_0500
		AND	#0FH
		BEQ	E_BITMAP_0550	;kLH ( yes:E_BITMAP_0550 )
		ADD	R5
;
		COLOUR
		LOOP
		PLOT			;pset
;
		WITH	R7
		ADD	R6
;
		DEC	R10
		BNE	E_BITMAP_0400
		INC	R2		;Y pos +1
;
		BRA	E_BITMAP_0600+1
		LMS	R1,CWORK1	;(R1) <-- XN[ʂyW
;
E_BITMAP_0550
		LOOP
		INC	R1
;
		WITH	R7
		ADD	R6
;
		DEC	R10
		BNE	E_BITMAP_0400
		INC	R2		;Y pos +1
;
E_BITMAP_0600
		LMS	R1,CWORK1	;(R1) <-- XN[ʂyW
		LMS	R2,CWORK2	;(R2) <--      h     xW
		LMS	R3,CWORK3	;(R3) <--      h     wW
;
		LMS	R5,REG5		;(R5) load
		mDJMP_X E_BITMAP_0050
		INC	R5
;
;
;
		mEND_NOP
;
;
;
;------------------------------------------------------------------------
;-		nai^Cvf[^					-
;------------------------------------------------------------------------
BITMAP_OBJ_TBL	EQU	$
;			  +---------------- LN^[Sw
;			  |    +--------------- LN^[Sx
;			  |    |    +-------------- LN^[w
;			  |    |    |	 +------------- LN^[x
;			  |    |    |	 |     +----------- LN^[AhX
;			  |    |    |	 |     |	 ioNWOgȏ͏ʂSrbgj
;			  |    |    |	 |     |
;			  |    |    |	 |     |
;			  |    |    |	 |     |
;
;-------------- |P --------------------------------------------------
BMP_OBJ_TORI00	EQU	$
		BYTE	0F4H,0F0H,018H,028H
		LWORD			804000H+CIPCHD5+0000H*8
;
;-------------- |Q --------------------------------------------------
BMP_OBJ_TORI01	EQU	$
		BYTE	0E8H,0F3H,02FH,028H
		LWORD			804000H+CIPCHD5+0003H*8
;
;-------------- |R --------------------------------------------------
BMP_OBJ_TORI02	EQU	$
		BYTE	0E4H,0FAH,037H,01FH
		LWORD			800000H+CIPCHD5+0010H*8
;
;-------------- |S --------------------------------------------------
BMP_OBJ_TORI03	EQU	$
		BYTE	0E0H,005H,03FH,00FH
		LWORD			800000H+CIPCHD5+0008H*8
;
;-------------- |T --------------------------------------------------
BMP_OBJ_TORI04	EQU	$
		BYTE	0E4H,004H,037H,017H
		LWORD			804000H+CIPCHD5+0506H*8
;
;-------------- |U --------------------------------------------------
BMP_OBJ_TORI05	EQU	$
		BYTE	0F0H,004H,01FH,01FH
		LWORD			800000H+CIPCHD5+040CH*8
;
;-------------- |V --------------------------------------------------
BMP_OBJ_TORI06	EQU	$
		BYTE	0F0H,004H,020H,01FH
		LWORD			800000H+CIPCHD5+0004H*8
;
;-------------- |W --------------------------------------------------
BMP_OBJ_TORI07	EQU	$
		BYTE	0F0H,001H,020H,01FH
		LWORD			800000H+CIPCHD5+0000H*8
;
;-------------- |X --------------------------------------------------
BMP_OBJ_TORI08	EQU	$
		BYTE	0E8H,005H,02FH,010H
		LWORD			800000H+CIPCHD5+0208H*8
;
;-------------- |PO ------------------------------------------------
BMP_OBJ_TORI09	EQU	$
		BYTE	0E8H,002H,02FH,017H
		LWORD			804000H+CIPCHD5+0500H*8
;
;-------------- |PP ------------------------------------------------
BMP_OBJ_TORI10	EQU	$
		BYTE	0E8H,0FFH,030H,017H
		LWORD			800000H+CIPCHD5+0406H*8
;
;-------------- |PQ ------------------------------------------------
BMP_OBJ_TORI11	EQU	$
		BYTE	0E8H,0F9H,02FH,01FH
		LWORD			800000H+CIPCHD5+0400H*8
;
;-------------- |PR ------------------------------------------------
BMP_OBJ_TORI12	EQU	$
		BYTE	0F4H,0F0H,017H,028H
		LWORD			804000H+CIPCHD5+0009H*8
;
;-------------- R|P --------------------------------------------------
BMP_OBJ_YAMA0	EQU	$
		BYTE	0E8H,0C0H,02FH,03FH
		LWORD			000000H+CIPCHD5+0000H*8
;
;-------------- R|Q --------------------------------------------------
BMP_OBJ_YAMA1	EQU	$
		BYTE	0F8H,0E8H,00FH,017H
		LWORD			000000H+CIPCHD5+0506H*8
;
;-------------- R|R , R|S -----------------------------------------
BMP_OBJ_YAMA2	EQU	$
BMP_OBJ_YAMA3	EQU	$
		BYTE	0E8H,0C0H,02FH,03FH
		LWORD			000000H+CIPCHD5+0010H*8
;
;-------------- _|P --------------------------------------------------
BMP_OBJ_KUMO0	EQU	$
		BYTE	0E8H,0E8H,02FH,027H
		LWORD			000000H+CIPCHD5+0006H*8
;
;-------------- _|Q --------------------------------------------------
BMP_OBJ_KUMO1	EQU	$
		BYTE	0F0H,0D0H,01FH,02FH
		LWORD			000000H+CIPCHD5+000CH*8
;
;-------------- _|R --------------------------------------------------
BMP_OBJ_KUMO2	EQU	$
		BYTE	0F0H,0F4H,01FH,017H
		LWORD			000000H+CIPCHD5+0508H*8
;
;-------------- _|S --------------------------------------------------
BMP_OBJ_KUMO3	EQU	$
		BYTE	0F0H,0F8H,01FH,00FH
		LWORD			000000H+CIPCHD5+060CH*8
;
;-------------- _ --------------------------------------------------
BMP_OBJ_BIGKUM	EQU	$
		BYTE	0C0H,0C8H,07FH,037H
		LWORD			804000H+CIPCHD5+0110H*8
;
;--------------  ------------------------------------------------------
BMP_OBJ_HOME	EQU	$
		BYTE	0D8H,0C0H,04FH,047H
		LWORD			000000H+CIPCHD5+0016H*8
;
;-------------- u ------------------------------------------------------
BMP_OBJ_OKA	EQU	$
		BYTE	0C0H,0F8H,07FH,017H
		LWORD			004000H+CIPCHD5+0510H*8
;
;-------------- 㑐 ----------------------------------------------------
BMP_OBJ_UKS	EQU	$
		BYTE	0D8H,0E0H,050H,040H
		LWORD			004000H+CIPCHD5+0006H*8
;
;--------------  P -------------------------------------------------
BMP_OBJ_DKS0	EQU	$
		BYTE	0E8H,0E0H,02FH,03FH
		LWORD			004000H+CIPCHD5+0000H*8
;
;--------------  Q -------------------------------------------------
BMP_OBJ_DKS1	EQU	$
		BYTE	0DCH,0DCH,047H,047H
		LWORD			800000H+CIPCHD5+0017H*8
;
;-------------- ї P -------------------------------------------
BMP_OBJ_STORI0	EQU	$
		BYTE	0F8H,0F4H,010H,018H
		LWORD			804000H+CIPCHD5+000CH*8
;
;-------------- ї Q -------------------------------------------
BMP_OBJ_STORI1	EQU	$
		BYTE	0F8H,0F4H,010H,018H
		LWORD			804000H+CIPCHD5+000EH*8
;
;-------------- ї R -------------------------------------------
BMP_OBJ_STORI2	EQU	$
		BYTE	0F8H,0F4H,010H,018H
		LWORD			000000H+CIPCHD5+0506H*8
;
;-------------- ї S -------------------------------------------
BMP_OBJ_STORI3	EQU	$
		BYTE	0F4H,0F4H,018H,018H
		LWORD			004000H+CIPCHD5+0210H*8
;
;-------------- ї T -------------------------------------------
BMP_OBJ_STORI4	EQU	$
		BYTE	0F4H,0F4H,018H,018H
		LWORD			004000H+CIPCHD5+0213H*8
;
;-------------- ї U -------------------------------------------
BMP_OBJ_STORI5	EQU	$
		BYTE	0F4H,0F4H,018H,018H
		LWORD			804000H+CIPCHD5+030DH*8
;
;-------------- ї V -------------------------------------------
BMP_OBJ_STORI6	EQU	$
		BYTE	0F4H,0F4H,018H,018H
		LWORD			800000H+CIPCHD5+0410H*8
;
;-------------- Ԓ P -----------------------------------------------
BMP_OBJ_FTORI0	EQU	$
		BYTE	0F8H,0F8H,010H,010H
		LWORD			004000H+CIPCHD5+0010H*8
;
;-------------- Ԓ Q -----------------------------------------------
BMP_OBJ_FTORI1	EQU	$
		BYTE	0F8H,0F8H,010H,010H
		LWORD			004000H+CIPCHD5+0012H*8
;
;-------------- Ԓ R -----------------------------------------------
BMP_OBJ_FTORI2	EQU	$
		BYTE	0F8H,0F8H,010H,010H
		LWORD			004000H+CIPCHD5+0014H*8
;
;-------------- Ԓ S -----------------------------------------------
BMP_OBJ_FTORI3	EQU	$
		BYTE	0F8H,0F8H,010H,010H
		LWORD			004000H+CIPCHD5+0116H*8
;
;-------------- Ԓ T -----------------------------------------------
BMP_OBJ_FTORI4	EQU	$
		BYTE	0F8H,0F8H,010H,010H
		LWORD			004000H+CIPCHD5+0118H*8
;
;-------------- Ԓ U -----------------------------------------------
BMP_OBJ_FTORI5	EQU	$
		BYTE	0F8H,0F8H,010H,010H
		LWORD			004000H+CIPCHD5+011AH*8
;
;-------------- Ԓ V -----------------------------------------------
BMP_OBJ_FTORI6	EQU	$
		BYTE	0F8H,0F8H,010H,010H
		LWORD			004000H+CIPCHD5+011CH*8
;
;-------------- Ԓ W -----------------------------------------------
BMP_OBJ_FTORI7	EQU	$
		BYTE	0F8H,0F8H,010H,010H
		LWORD			004000H+CIPCHD5+011EH*8
;
;-------------- Ԓ X -----------------------------------------------
BMP_OBJ_FTORI8	EQU	$
		BYTE	0F8H,0F8H,010H,010H
		LWORD			004000H+CIPCHD5+0316H*8
;
;-------------- Ԓ PO ---------------------------------------------
BMP_OBJ_FTORI9	EQU	$
		BYTE	0F8H,0F8H,010H,010H
		LWORD			004000H+CIPCHD5+0318H*8
;
;-------------- Ԓ PP ---------------------------------------------
BMP_OBJ_FTORIA	EQU	$
		BYTE	0F8H,0F8H,010H,010H
		LWORD			004000H+CIPCHD5+031AH*8
;
;
;
;
;
;************************************************************************
;*		NbpOf[Vobt@Zbg			*
;*			in :						*
;*				(R0)  <-- Of[VJ[AhX	*
;*				(R14) <--	      h		*
;************************************************************************
;
KOOPA_GRADATION EQU	$
		ROMB
		MOVE	R14,R14
;
		mJSR	COL_R_G_B_ST
;
		IWT	R8,#HDMABF0		  ;(R8)	 <-- kLJ[obt@|C^[
		IWT	R9,#WOB7CHR		  ;(R9)	 <-- qobt@|C^[
		IWT	R10,#WOB7CHR+0D2H	  ;(R10) <-- fEaobt@|C^[
;
		CACHE
;
		IBT	R12,#04FH
		MOVE	R13,R15
KOOPA_GRAD_0050
		FROM	R1
		STW	(R8)
		INC	R8
		INC	R8
		FROM	R2
		STB	(R9)
		INC	R9
		FROM	R3
		STW	(R10)
		INC	R10
		LOOP
		INC	R10
;
		IBT	R7,#14
KOOPA_GRAD_0100
		mJSR	COL_R_G_B_ST
;
		IBT	R12,#004H
		MOVE	R13,R15
KOOPA_GRAD_0150
		FROM	R1
		STW	(R8)
		INC	R8
		INC	R8
		FROM	R2
		STB	(R9)
		INC	R9
		FROM	R3
		STW	(R10)
		INC	R10
		LOOP
		INC	R10
;
		DEC	R7
		BNE	KOOPA_GRAD_0100
		NOP
;
		mJSR	COL_R_G_B_ST
;
		IBT	R12,#0D2H-(050H+(14*004H))
		MOVE	R13,R15
KOOPA_GRAD_0200
		FROM	R1
		STW	(R8)
		INC	R8
		INC	R8
		FROM	R2
		STB	(R9)
		INC	R9
		FROM	R3
		STW	(R10)
		INC	R10
		LOOP
		INC	R10
;
		STOP
		NOP
;
;------------------------------------------------------------------------
;-		J[qEfEa					-
;-			out :						-
;-				(R1) <-- J[f[^			-
;-				(R2) <-- q				-
;-				(R3) <-- fEa				-
;------------------------------------------------------------------------
COL_R_G_B_ST
		GETB
		INC	R14
		GETBH
		INC	R14
		MOVE	R1,R0		;(R1) <-- ZbgJ[
;
		IBT	R5,#1FH		;(R5) <-- qEfEa`mcf[^
		AND	R5
		IBT	R6,#00100000B	;(R6) <-- ŒJ[qEfEaIf[^
		TO	R2		;(R2) <-- q
		OR	R6
;
		FROM	R1
		LSR
		LSR
		LSR
		LSR
		LSR
		MOVE	R4,R0
		AND	R5
		WITH	R6		;[ IBT R6,#01000000B ]
		ADD	R6		;
		TO	R3		;(R3) <-- f
		OR	R6
;
		FROM	R4
		LSR
		LSR
		LSR
		LSR
		LSR
		AND	R5
		WITH	R6		;[ IWT R6,#10000000B ]
		ADD	R6		;
		OR	R6
		SWAP
		TO	R3		;(R3) <-- fEa
		OR	R3
;
		mRTS
;
;************************************************************************
;*		Nbpn`lRcϊ					*
;*			in :						*
;*				(R1) <-- wW				*
;*				(R2) <-- xW				*
;*				(R3) <-- wW			*
;*				(R5) <-- n`lCfbNX		*
;*				(R7) <-- n`l			*
;*			out :						*
;*				(R1) <-- n`lWw␳l		*
;*				(R2) <-- n`lWx␳l		*
;*				(R6) <-- Rcϊ{			*
;*				(R9) <-- yW				*
;************************************************************************
;
KOOPA_3D_OAM	EQU	$
		FROM	R1
		SUB	R3
		IWT	R9,#0100H
		TO	R9		;(R9) <-- yW
		ADD	R9
;
;------------------------------------------------------------------------
;-		iP^{jvZ					-
;-		Z							-
;-			in :						-
;-				(R9) <-- 				-
;-			out :						-
;-				(R6) <-- 				-
;-				(R0) <-- ]				-
;------------------------------------------------------------------------
		IBT	R10,#01H	;(R10) <-- PDO
;
		SUB	R0		;(R0) <-- AL[^NA
		MOVE	R6,R0		;(R6) <-- NA
;
		CACHE
;
		IBT	R12,#32
		IWT	R13,#KOOPA_3D_OAM_20+1
KOOPA_3D_OAM_20
		WITH	R6		;փVtg
		ADD	R6
		WITH	R10		;폜փVtg
		ADD	R10
		ROL			;폜AL[^ɃVtg
		SUB	R9		;AL[^Ər
		BCC	KOOPA_3D_OAM_30 ;AL[^ł΁AZȗ
		ADD	R9
;
		SUB	R9		;AL[^珜
		INC	R6		;ɂP
KOOPA_3D_OAM_30
		LOOP
		WITH	R6		;(R6) <-- XN[ʂł̔{
;
;------------------------------------------------------------------------
;-		Rcϊ						-
;------------------------------------------------------------------------
		LMS	R8,CESCCH1	;(R8)  <-- XN[JE^[g
		IWT	R10,#080H-8	;(R10) <-- ʒSwW
;
		FROM	R3
		SUB	R8
		SUB	R10
		LMULT
		WITH	R4
		HIB
		LOB
		SWAP
		OR	R4
		ADD	R10
		ADD	R8
		TO	R1		;(R1) <-- n`lWw␳l
		SUB	R1
;
		LMS	R8,CESCCV1	;(R8)  <-- XN[JE^[u
		IWT	R10,#090H-8	;(R10) <-- ʒSxW
;
		FROM	R2
		SUB	R8
		SUB	R10
		LMULT
		WITH	R4
		HIB
		LOB
		SWAP
		OR	R4
		ADD	R10
		ADD	R8
		TO	R2		;(R2) <-- n`lWw␳l
		SUB	R2
;
;------------------------------------------------------------------------
;-		n`l␳						-
;------------------------------------------------------------------------
		IBT	R4,#8-2		;n`lCfbNXZl
;
		MOVE	R12,R7		;(R12) <-- n`l
		MOVE	R13,R15
KOOPA_3D_OAM_40
		LDW	(R5)
		ADD	R1
		SBK			;[ STW (R5) ]
		INC	R5
		INC	R5
		LDW	(R5)
		ADD	R2
;
		WITH	R5
		ADD	R4
		LOOP
		SBK			;[ STW (R5) ]
;
		STOP
		NOP
;
;
;****************************************************************
;*								*
;*		GfBOp J[tF[h			*
;*				in				*
;*				R1 : J[f[^		*
;*				R2 : `FW J[f[^	*
;*				R3 : J[f[^ obt@	*
;****************************************************************
END_COL_FADE	EQU	$
		CACHE			; LbV X^[g !!
;
		IBT	R10,#01FH
		LM	R0,CBTMP_COL_CNT
		INC	R0
		SBK
		MOVE	R6,R0
		IWT	R12,#00200H/2
		MOVE	R13,R15
;
		LDW	(R1)		; qJ[̕ϊ
		TO	R8
		AND	R10
		LDW	(R2)
		TO	R9
		AND	R10
		LINK	#004
		IWT	R15,#END_COL_SUB
		NOP
		MOVE	R5,R0
;
		LDW	(R1)		; fJ[̕ϊ
		ADD	R0
		ADD	R0
		ADD	R0
		SWAP
		TO	R8
		AND	R10
		LDW	(R2)
		ADD	R0
		ADD	R0
		ADD	R0
		SWAP
		TO	R9
		AND	R10
		LINK	#004
		IWT	R15,#END_COL_SUB
		NOP
		SWAP
		LSR
		LSR
		LSR
		TO	R5
		OR	R5
;
		LDW	(R1)		; aJ[̕ϊ
		SWAP
		LSR
		LSR
		TO	R8
		AND	R10
		LDW	(R2)
		SWAP
		LSR
		LSR
		TO	R9
		AND	R10
		LINK	#004
		IWT	R15,#END_COL_SUB
		NOP
		SWAP
		ADD	R0
		ADD	R0
;
		OR	R5
		STW	(R3)
		INC	R1
		INC	R1
		INC	R2
		INC	R2
		INC	R3
		LOOP
		INC	R3
;
END_COL_990
		STOP
		NOP
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+	GfBOp J[tF[h Tu[`	+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
END_COL_SUB
		FROM	R9
		SUB	R8
		MULT	R6
		ASR
		ASR
		ASR
		ASR
		ASR
		ADD	R8
		AND	R10
		MOVE	R15,R11
		NOP
;
;************************************************************************
;*		Nbp[hVXN[Rcϊ			*
;*			in :						*
;*				(R1) <-- yW				*
;*				(R2) <-- xW				*
;*				(R3) <-- wW				*
;*				(R5) <-- 				*
;*			out :						*
;*				(R6) <-- Rcϊ{			*
;*				(R9) <-- [hV{			*
;************************************************************************
;
KOOPA_3D_SET	EQU	$
		IWT	R6,#040H
		FROM	R1
		LMULT
		WITH	R4
		HIB
		LOB
		SWAP
		TO	R9		;(R9) <-- [hV{
		OR	R4
;
;------------------------------------------------------------------------
;-		iP^{jvZ					-
;-		Z							-
;-			in :						-
;-				(R1) <-- 				-
;-			out :						-
;-				(R6) <-- 				-
;-				(R0) <-- ]				-
;------------------------------------------------------------------------
		IBT	R10,#01H	;(R10) <-- PDO
;
		SUB	R0		;(R0) <-- AL[^NA
		MOVE	R6,R0		;(R6) <-- NA
;
		CACHE
;
		IBT	R12,#32
		IWT	R13,#KOOPA_3D_SET_20+1
KOOPA_3D_SET_20
		WITH	R6		;փVtg
		ADD	R6
		WITH	R10		;폜փVtg
		ADD	R10
		ROL			;폜AL[^ɃVtg
		SUB	R1		;AL[^Ər
		BCC	KOOPA_3D_SET_30 ;AL[^ł΁AZȗ
		ADD	R1
;
		SUB	R1		;AL[^珜
		INC	R6		;ɂP
KOOPA_3D_SET_30
		LOOP
		WITH	R6		;(R6) <-- XN[ʂł̔{
;
;------------------------------------------------------------------------
;-		Rcϊ						-
;------------------------------------------------------------------------
		LMS	R8,CESCCH1	;(R8)  <-- XN[JE^[g
		IWT	R10,#080H	;(R10) <-- ʒSwW
;
		FROM	R3
		SUB	R8
		SUB	R10
		LMULT
		WITH	R4
		HIB
		LOB
		SWAP
		OR	R4
		DEC	R5
		BPL	KOOPA_3D_SET_40 ;]H ( yes:KOOPA_3D_SET_40 )
		INC	R5
;
		NOT
		INC	R0
KOOPA_3D_SET_40
		IWT	R5,#0180H
		ADD	R5
		SMS	R0,CESCCH3	;NbpwWZbg
;
		LMS	R8,CESCCV1	;(R8)  <-- XN[JE^[u
		IWT	R10,#090H	;(R10) <-- ʒSxW
;
		FROM	R2
		SUB	R8
		SUB	R10
		LMULT
		WITH	R4
		HIB
		LOB
		SWAP
		TO	R5
		OR	R4
		IWT	R0,#0180H
		SUB	R5
		SMS	R0,CESCCV3	;NbpxWZbg
;
		STOP
		NOP
;
;************************************************************************
;*		Nbpt@C[vC[Փ˃`FbN		*
;*			in :						*
;*				(R1) <-- t@C[CfbNX		*
;*			out :						*
;*				(R0) <-- Փ˃tOi 0:Փ )		*
;************************************************************************
;
KPFIR_CROSS	EQU	$
		mLDW0	CEPWIDX,R1
		DEC	R0
		BPL	KPFIR_CROSS_010
		INC	R0
;
		NOT
		INC	R0
KPFIR_CROSS_010
		IBT	R4,#040H
		SUB	R4
		BCS	KPFIR_CROSS_050 ;wnjH ( no:KPFIR_CROSS_050 )
		ADD	R4
;
		TO	R2		;(R2) <-- w~w
		UMULT	R0
;
		mLDW0	CEPWIDY,R1
		DEC	R0
		BPL	KPFIR_CROSS_020
		INC	R0
;
		NOT
		INC	R0
KPFIR_CROSS_020
		SUB	R4
		BCS	KPFIR_CROSS_050 ;xnjH ( no:KPFIR_CROSS_050 )
		ADD	R4
;
		UMULT	R0		;(R0) <-- x~x
		TO	R2		;(R2) <-- w~w{x~x
		ADD	R2
;
		LMS	R0,CPWIDEY
		UMULT	R0		;(R0) <-- vC[TCY~vC[TCY
		IWT	R3,#02CH*02CH
		ADD	R3
		SUB	R2
		BCS	KPFIR_CROSS_100 ;ՓˁH ( yes:KPFIR_CROSS_100 )
		SUB	R0		;[ IBT R0,#0 ] 
;
KPFIR_CROSS_050
		IBT	R0,#1		;Ė
KPFIR_CROSS_100
		STOP
		NOP
;
;************************************************************************
;*		NbpoN_Zbg`FbN				*
;*			out :						*
;*				(R1) <-- oN_			*
;************************************************************************
KPBOM_CHECK	EQU	$
		IBT	R1,#0		;(R1) <-- oN_
;
		IWT	R2,#CENMODE
		IWT	R3,#CENMYNO
		IWT	R4,#CENSHOT
		IWT	R5,#FKPBM
		IWT	R6,#KPBOM
		IWT	R7,#4
;
		CACHE
;
		IBT	R12,#CENNO
		MOVE	R13,R15
KPBOM_CHECK_050
		LDW	(R2)
		LOB
		BEQ	KPBOM_CHECK_150 ;G݁H ( no:KPBOM_CHECK_150 )
		NOP
;
		LDW	(R3)
		SUB	R5
		BEQ	KPBOM_CHECK_100 ;DoN_H ( yes:KPBOM_CHECK_100 )
		ADD	R5
;
		SUB	R6
		BNE	KPBOM_CHECK_150 ;oN_H ( no:KPBOM_CHECK_150 )
		NOP
;
		LDW	(R4)
		SUB	#0
		BNE	KPBOM_CHECK_150 ;VbgH ( yes:KPBOM_CHECK_150 )
		NOP
;
KPBOM_CHECK_100
		INC	R1		;oN_
;
KPBOM_CHECK_150
		WITH	R2
		ADD	R7
		WITH	R3
		ADD	R7
		WITH	R4
		ADD	R7
;
		LOOP
		NOP
;
		STOP
		NOP
;
;************************************************************************
;*		GfBObZ[WafRXN[Zbg		*
;************************************************************************
ENDMSG_SCRST	EQU	$
		CACHE
;
		IWT	R3,#WOB7CHR+1000H ;(R3) <-- XN[Zbgobt@|C^[
		IWT	R0,#3CEH	;(R3) <-- kLLmD
		IWT	R12,#800H/2
		MOVE	R13,R15
ENDMSG_SCRST_10
		STW	(R3)
		INC	R3
		LOOP
		INC	R3
;
		IWT	R1,#2000H			      ;(R1) <-- XN[X^[gLmD
		IWT	R2,#WOB7CHR+1000H+(32*2*(16+1))+(2*2) ;(R2) <-- XN[X^[g|C^[
;
		IBT	R4,#20H-10H	;[ IBT R4,#10H ]
		IBT	R5,#0FH
		IBT	R7,#(32*2)-((24/2)*2)
		IBT	R8,#038H
		IBT	R10,#11		;(R10) <-- s
		IBT	R11,#24/2	;(R11) <-- 
ENDMSG_SCRST_20
		MOVE	R0,R1
		MOVE	R12,R11
		MOVE	R13,R15
ENDMSG_SCRST_30
		STW	(R2)
		INC	R0
		INC	R0
		TO	R14		;[ * not break (R0) ]
		AND	R5
		BNE	ENDMSG_SCRST_40
		INC	R2
;
		ADD	R4
ENDMSG_SCRST_40
		LOOP
		INC	R2
;
		WITH	R2
		ADD	R7
		FROM	R1
		ADD	R8
		TO	R1
		BIC	R4	;[  ]
;
		DEC	R10
		BNE	ENDMSG_SCRST_20+1
		MOVE	R0,R1
;
		STOP
		NOP
;
;************************************************************************
;*		GfBObZ[WafRrbg}bvZbg		*
;*			in :						*
;*				(R3) <-- bZ[WAhXiaj	*
;*				(R4) <--	 h	   ikCgj	*
;************************************************************************
ENDMSG_CHRST	EQU	$
		CACHE
;
		IWT	R5,#WOB7CHR+1000H
		SUB	R0		;[ IBT R0,#0 ]
		IWT	R12,#600H/2
		MOVE	R13,R15
ENDMSG_CHRST_00
		STW	(R5)
		INC	R5
		LOOP
		INC	R5
;
		IBT	R5,#0		;(R5) <-- rbg}bvwW
		IBT	R6,#0		;(R6) <-- rbg}bvxW
;
		IBT	R7,#1		;(R7)  <-- J[`mcf[^
		IWT	R9,#128		;(R9)  <-- rbg}bvwW␳l
		IBT	R10,#16		;(R10) <-- rbg}bvxW␳l
ENDMSG_CHRST_10
		FROM	R3
		ROMB
		MOVE	R14,R4		;(R14) <-- bZ[Wf[^|C^[
		GETB
		INC	R14
;
		IWT	R11,#0FFH	;(R11) <-- R[h
		SUB	R11
		BNE	ENDMSG_CHRST_50 ;R[hH ( no:ENDMSG_CHRST_50 )
		ADD	R11
;
;-------------- R[h ----------------------------------------------
		GETB			;(R0)  <-- R[he
		INC	R14		;(R14) <-- ̃bZ[WAhX
;
		TO	R11		;[ * not break (R0) ]
		SUB	#0AH
		BEQ	ENDMSG_CHRST_20 ;QsڂցH ( yes:ENDMSG_CHRST_20 )
		NOP
;
		STOP
		NOP
;
ENDMSG_CHRST_20
		GETB
		INC	R14
;
		IBT	R5,#040H	;(R5) <-- rbg}bvwW
		IBT	R6,#010H	;(R6) <-- rbg}bvxW
;
;-------------- bZ[Wvbg --------------------------------------
ENDMSG_CHRST_50
		MOVE	R4,R14		;(R4) <-- ̃bZ[Wf[^|C^[
;
		IBT	R14,#BANK MSG_FONT
		FROM	R14
		ROMB
;
		UMULT	#12
		IWT	R14,#MSG_FONT
		TO	R14		;(R14) <-- tHgf[^AhX
		ADD	R14
;
		IBT	R8,#12
ENDMSG_CHRST_60
		TO	R11		;(R11) <-- tHgf[^
		GETBH
		INC	R14
;
		MOVE	R1,R5		;(R1) <-- vbgwW
		MOVE	R2,R6		;(R2) <-- vbgxW
;
		IBT	R12,#8
		MOVE	R13,R15
ENDMSG_CHRST_70
		WITH	R11
		ADD	R11
		ROL
		AND	R7
		COLOUR
;
		FROM	R1
		SUB	R9
		BCC	ENDMSG_CHRST_80
		WITH	R2
;
		ADD	R10
		MOVE	R1,R0
ENDMSG_CHRST_80
		LOOP
		PLOT
;
		DEC	R8
		BNE	ENDMSG_CHRST_60
		INC	R6
;
		WITH	R6
		SUB	#12
		WITH	R5
		ADD	#10
;
		RPIX
;
		FROM	R5
		SUB	R9
		BCC	ENDMSG_CHRST_10+1
		FROM	R3
;
		MOVE	R5,R0
		WITH	R6		;(R6) <-- srbg}bvxW
		BRA	ENDMSG_CHRST_10
		ADD	R10
;
;************************************************************************
;*		\jbN}IՓ˃TCYZbg				*
;*			in :						*
;*				(R1) <-- ]px			*
;*				(R4) <-- S܂ł̂x{P		*
;************************************************************************
MARIO_SIZEST	EQU	$
		IBT	R0,#BANK LCOS
		ROMB
		IWT	R0,#LCOS
		TO	R14
		ADD	R1
		GETBS
		MOVE	R1,R0		;(R1) <-- f[^
;
		LMS	R3,CPWIDEY	;(R3) <-- xTCY
		MULT	R3
		ADD	R0
		ADD	R0
		HIB
		SEX
		NOT
		ADD	R4
		LMS	R4,CPLYPSL
		ADD	R4
		SMS	R0,CPCENTY	;SxW
;
		IBT	R0,#040H	;[ IWT R14,#LSIN ]
		TO	R14
		ADD	R14
		GETBS
		MOVE	R2,R0		;(R2) <-- f[^
;
		MULT	R3
		ADD	R0
		ADD	R0
		HIB
		SEX
		ADD	#8
		LMS	R4,CPLXPSL
		ADD	R4
		SMS	R0,CPCENTX	;SwW
;
		DEC	R1
		BPL	MARIO_SIZEST_10
		INC	R1
;
		WITH	R1
		NOT
		INC	R1
MARIO_SIZEST_10
		DEC	R2
		BPL	MARIO_SIZEST_20
		INC	R2
;
		WITH	R2
		NOT
		INC	R2
MARIO_SIZEST_20
		LMS	R0,CPWIDEX	;(R0) <-- wTCY
		TO	R5		;(R5) <-- wTCY~
		MULT	R1
		TO	R6		;(R6) <-- wTCY~
		MULT	R2
;
		FROM	R3
		MULT	R2
		ADD	R5
		ADD	R0
		ADD	R0
		HIB
		SMS	R0,CPWIDEX	;wTCYZbg
;
		FROM	R3
		MULT	R1
		ADD	R6
		ADD	R0
		ADD	R0
		HIB
		SMS	R0,CPWIDEY	;xTCYZbg
;
		STOP
		NOP
;
;;;;;************************************************************************
;;;;;*		    yǃR[X̉Zbg`FbN			    *
;;;;;*			    out :					    *
;;;;;*				    (R0) <-- 0:TEhZbg		    *
;;;;;************************************************************************
;;;;DOKAN_SND_CK    EQU	    $
;;;;		    IWT	    R1,#UT77CF			      ;(R1) <-- hJjbg
;;;;		    IWT	    R2,#UT77D6-UT77CF		      ;(R2) <-- hJjbg
;;;;		    IWT	    R3,#UT8554-UT77CF-(UT77D6-UT77CF) ;(R3) <-- hJjbg
;;;;		    IWT	    R4,#BGCHECK_BUF		      ;(R4) <-- afjbgobt@|C^[
;;;;;
;;;;		    CACHE
;;;;;
;;;;		    IWT	    R12,#16*2*16
;;;;		    MOVE    R13,R15
;;;;DOKAN_SND_CK_10
;;;;		    LDW	    (R4)
;;;;		    SUB	    R1
;;;;		    BEQ	    DOKAN_SND_CK_50 ;hJjbgH ( yes:DOKAN_SND_CK_50 )
;;;;		    NOP
;;;;;
;;;;		    SUB	    R2
;;;;		    BEQ	    DOKAN_SND_CK_50 ;hJjbgH ( yes:DOKAN_SND_CK_50 )
;;;;		    NOP
;;;;;
;;;;		    SUB	    R3
;;;;		    BEQ	    DOKAN_SND_CK_50 ;hJjbgH ( yes:DOKAN_SND_CK_50 )
;;;;		    INC	    R4
;;;;;
;;;;		    LOOP
;;;;		    INC	    R4
;;;;;
;;;;DOKAN_SND_CK_50
;;;;		    STOP
;;;;		    NOP
;
;************************************************************************
;*									*
;*	xnrgh cnnq lnud * Q				*
;*					Programmed by  Y. Yamamoto.	*
;*				1995N 619(j) 140620b JST *
;*								Ver 0.00*
;************************************************************************
DOR2_SIZE		EQU		020h
DOR2_A0			EQU		DOR2_SIZE * 000h + DOR2_SIZE - 1
DOR2_A1			EQU		DOR2_SIZE * 001h + DOR2_SIZE - 1
DOR2_A2			EQU		DOR2_SIZE * 010h + DOR2_SIZE - 1
DOR2_A3			EQU		DOR2_SIZE * 011h + DOR2_SIZE - 1
DOR2_A4			EQU		DOR2_SIZE * 020h + DOR2_SIZE - 1
DOR2_A5			EQU		DOR2_SIZE * 021h + DOR2_SIZE - 1
DOR2_A6			EQU		DOR2_SIZE * 030h + DOR2_SIZE - 1
DOR2_A7			EQU		DOR2_SIZE * 031h + DOR2_SIZE - 1
;
DOR2_B0			EQU		DOR2_SIZE * 011h + DOR2_SIZE - 1
DOR2_B1			EQU		DOR2_SIZE * 013h + DOR2_SIZE - 1
DOR2_B2			EQU		DOR2_SIZE * 031h + DOR2_SIZE - 1
DOR2_B3			EQU		DOR2_SIZE * 033h + DOR2_SIZE - 1
DOR2_B4			EQU		DOR2_SIZE * 015h + DOR2_SIZE - 1
DOR2_B5			EQU		DOR2_SIZE * 017h + DOR2_SIZE - 1
DOR2_B6			EQU		DOR2_SIZE * 035h + DOR2_SIZE - 1
DOR2_B7			EQU		DOR2_SIZE * 037h + DOR2_SIZE - 1
;
DOOR2_MV	EQU		$
		LM		R0, CWORK1	;R1 = Y * 40H + X * 10H
		ADD		R0
		MULT		#8
		LM		R1, CWORK0
		ADD		R1
		MULT		#4
		IWT		R1, #WOB7CHR
		TO		R14
		ADD		R1
;
		CACHE
;
		IWT		 R1, #DOR2_A7
		IWT		 R3, #DOR2_B7
		LINK		 #4
		IWT		 R15, #DO2S_M00
		NOP
		IWT		 R1, #DOR2_A6
		IWT		 R3, #DOR2_B6
		LINK		 #4
		IWT		 R15, #DO2S_M00
		NOP
		IWT		 R1, #DOR2_A5
		IWT		 R3, #DOR2_B5
		LINK		 #4
		IWT		 R15, #DO2S_M00
		NOP
		IWT		 R1, #DOR2_A4
		IWT		 R3, #DOR2_B4
		LINK		 #4
		IWT		 R15, #DO2S_M00
		NOP
		IWT		 R1, #DOR2_A3
		IWT		 R3, #DOR2_B3
		LINK		 #4
		IWT		 R15, #DO2S_M00
		NOP
		IWT		 R1, #DOR2_A2
		IWT		 R3, #DOR2_B2
		LINK		 #4
		IWT		 R15, #DO2S_M00
		NOP
		IWT		 R1, #DOR2_A1
		IWT		 R3, #DOR2_B1
		LINK		 #4
		IWT		 R15, #DO2S_M00
		NOP
		IWT		R1, #DOR2_A0
		IWT		R3, #DOR2_B0
		LINK		#4
		IWT		R15, #DO2S_M00
		NOP
;
		STOP
		NOP
;
;
;
DO2S_M00
		WITH		R1
		ADD		R14
		WITH		R3
		ADD		R14
;
		IBT		R2, #010H
		FROM		R1
		TO		R2
		SUB		R2
;
		IBT		R4, #DOR2_SIZE
		FROM		R3
		TO		R4
		SUB		R4
		FROM		R3
		TO		R5
		SUB		#2
		FROM		R4
		TO		R6
		SUB		#2
;
		IBT		R10, #2
DO2S_M50
		IBT		R12, #4
DO2S_M20
		IBT		R13, #2
DO2S_M10
		TO		R7
		LDB		(R1)
		MOVE		R8, R7
;
		WITH		R7
		LSR
		ROR
		WITH		R8
		LSR
		ROR
		WITH		R7
		LSR
		ROR
		WITH		R8
		LSR
		ROR
		WITH		R7
		LSR
		ROR
		WITH		R8
		LSR
		ROR
		WITH		R7
		LSR
		ROR
		WITH		R8
		LSR
		ROR
;
		SWAP
		STB		(R3)
		DEC		R3
		STB		(R5)
		DEC		R5
;
		WITH		R7
		LSR
		ROR
		WITH		R8
		LSR
		ROR
		WITH		R7
		LSR
		ROR
		WITH		R8
		LSR
		ROR
		WITH		R7
		LSR
		ROR
		WITH		R8
		LSR
		ROR
		WITH		R7
		LSR
		ROR
		WITH		R8
		LSR
		ROR
;
		SWAP
		STB		(R4)
		DEC		R4
		STB		(R6)
		DEC		R6
;
		DEC		R13
		BNE		DO2S_M10
		DEC		R1
;
		WITH		R3
		SUB		#2
		WITH		R4
		SUB		#2
		WITH		R5
		SUB		#2
		WITH		R6
		SUB		#2
;
		DEC		R12
		BNE		DO2S_M20
		NOP
;
		IBT		R12, #4
DO2S_M40
		IBT		R13, #2
DO2S_M30
		TO		R7
		LDB		(R2)
		MOVE		R8, R7
;
		WITH		R7
		LSR
		ROR
		WITH		R8
		LSR
		ROR
		WITH		R7
		LSR
		ROR
		WITH		R8
		LSR
		ROR
		WITH		R7
		LSR
		ROR
		WITH		R8
		LSR
		ROR
		WITH		R7
		LSR
		ROR
		WITH		R8
		LSR
		ROR
;
		SWAP
		STB		(R3)
		DEC		R3
		STB		(R5)
		DEC		R5
;
		WITH		R7
		LSR
		ROR
		WITH		R8
		LSR
		ROR
		WITH		R7
		LSR
		ROR
		WITH		R8
		LSR
		ROR
		WITH		R7
		LSR
		ROR
		WITH		R8
		LSR
		ROR
		WITH		R7
		LSR
		ROR
		WITH		R8
		LSR
		ROR
;
		SWAP
		STB		(R4)
		DEC		R4
		STB		(R6)
		DEC		R6
;
		DEC		R13
		BNE		DO2S_M30
		DEC		R2
;
		WITH		R3
		SUB		#2
		WITH		R4
		SUB		#2
		WITH		R5
		SUB		#2
		WITH		R6
		SUB		#2
;
		DEC		R12
		BNE		DO2S_M40
		NOP
;
		IWT		R12, #DOR2_SIZE * 0FH
		WITH		R3
		SUB		R12
		WITH		R4
		SUB		R12
		WITH		R5
		SUB		R12
		WITH		R6
		SUB		R12
;
		DEC		R10
		BEQ		DO2S_M60
		NOP
;
		mDJMP		DO2S_M50
;
DO2S_M60
		JMP		R11
		NOP
;
;
;
;
;
;************************************************************************
;*		afgXN[obt@Zbg			*
;*			in :						*
;*				(R1)  <-- jbgobt@|C^[DP*
;*				(R12) <-- jbgDP		*
;*				(R2)  <-- jbgobt@|C^[DQ*
;*				(R3)  <-- jbgDQ		*
;*				(R10) <-- obt@|C^[	*
;************************************************************************
BGWRITE_H	EQU	$
		IWT	R0,#BGCHECK_BUF
		TO	R1		;(R1) <-- jbgobt@|C^[DP
		ADD	R1
		TO	R2		;(R2) <-- jbgobt@|C^[DQ
		ADD	R2
;
		IWT	R0,#CBGHSCRBF
		TO	R4		;(R4) <-- obt@|C^[()
		ADD	R10
		IBT	R0,#20H*2
		TO	R5		;(R5) <-- obt@|C^[(E)
		ADD	R4
		FROM	R12
		ADD	R12
		ADD	R0
		ADD	R10
		IBT	R10,#1FH*2
		TO	R10
		AND	R10
;
		IBT	R0,#BANK UNDTADD
		ROMB
		IWT	R6,#UNDTADD	;(R6) <-- jbgLmDf[^e[uAhX
		IWT	R7,#UNDATA	;(R7) <-- jbgLmDf[^AhX
		IBT	R8,#8		;(R8) <-- ~Wf[^
;
		mJSR_X	BGWRITE_H_SUB
		CACHE
;
		MOVE	R1,R2
		MOVES	R12,R3
		BEQ	BGWRITE_H_0010	;jbgDQOH ( yes:BGWRITE_H_0010 )
		NOP
;
		IWT	R0,#CBGHSCRBF
		TO	R4		;(R4) <-- obt@|C^[()
		ADD	R10
		IBT	R0,#20H*2
		TO	R5		;(R5) <-- obt@|C^[(E)
		ADD	R4
;
		mJSR	BGWRITE_H_SUB
BGWRITE_H_0010
		STOP
		NOP
;
BGWRITE_H_SUB
		MOVE	R13,R15
BGWRITE_H_0050
		LDW	(R1)
		TO	R9
		UMULT	R8
		HIB
		ADD	R0
		TO	R14
		ADD	R6
;
		GETB
		INC	R14
		GETBH
		ADD	R9
		TO	R14
		ADD	R7
;
		IBT	R9,#(010H*2)*2
		WITH	R1
		ADD	R9
;
		GETB
		INC	R14
		STB	(R4)
		INC	R4
		GETB
		INC	R14
		STB	(R4)
		INC	R4
;
		GETB
		INC	R14
		STB	(R5)
		INC	R5
		GETB
		INC	R14
		STB	(R5)
		INC	R5
;
		GETB
		INC	R14
		STB	(R4)
		INC	R4
		GETB
		INC	R14
		STB	(R4)
		INC	R4
;
		GETB
		INC	R14
		STB	(R5)
		INC	R5
		GETB
		INC	R14
		STB	(R5)
;
		LOOP
		INC	R5
;
		mRTS
;
;************************************************************************
;*		afuXN[obt@Zbg			*
;*			in :						*
;*				(R1)  <-- jbgobt@|C^[DP*
;*				(R12) <-- jbgDP		*
;*				(R2)  <-- jbgobt@|C^[DQ*
;*				(R3)  <-- jbgDQ		*
;************************************************************************
BGWRITE_V	EQU	$
		IWT	R0,#BGCHECK_BUF
		TO	R1		;(R1) <-- jbgobt@|C^[DP
		ADD	R1
		TO	R2		;(R2) <-- jbgobt@|C^[DQ
		ADD	R2
;
		IWT	R4,#CBGVSCRBF	    ;(R4) <-- obt@|C^[ij
		IWT	R5,#CBGVSCRBF+22H*2 ;(R5) <-- obt@|C^[ij
;
		IBT	R0,#BANK UNDTADD
		ROMB
		IWT	R6,#UNDTADD	;(R6) <-- jbgLmDf[^e[uAhX
		IWT	R7,#UNDATA	;(R7) <-- jbgLmDf[^AhX
		IBT	R8,#8		;(R8) <-- ~Wf[^
;
		mJSR_X	BGWRITE_V_SUB
		CACHE
;
		MOVE	R1,R2
		MOVE	R12,R3
		mJSR	BGWRITE_V_SUB
;
		STOP
		NOP
;
BGWRITE_V_SUB
		MOVE	R13,R15
BGWRITE_V_0050
		LDW	(R1)
		TO	R9
		UMULT	R8
		HIB
		ADD	R0
		TO	R14
		ADD	R6
;
		GETB
		INC	R14
		INC	R1
		INC	R1
		GETBH
		ADD	R9
		TO	R14
		ADD	R7
;
		GETB
		INC	R14
		STB	(R4)
		INC	R4
		GETB
		INC	R14
		STB	(R4)
		INC	R4
;
		GETB
		INC	R14
		STB	(R4)
		INC	R4
		GETB
		INC	R14
		STB	(R4)
		INC	R4
;
		GETB
		INC	R14
		STB	(R5)
		INC	R5
		GETB
		INC	R14
		STB	(R5)
		INC	R5
;
		GETB
		INC	R14
		STB	(R5)
		INC	R5
		GETB
		INC	R14
		STB	(R5)
;
		LOOP
		INC	R5
;
		mRTS
;
;
;
;
;
		END
