;************************************************************************
;*									*
;*	title name	: "yossy"					*
;*	proccess	: enemy sub.1					*
;*	file name	: ys_boss1					*
;*									*
;************************************************************************
;
;
		SALL
;
		include		ys_header.inc
		include		ys_unit.h
		include		ys_pld.h
		include		ys_color.h
		include		../union/ys_bgcheck.h
		include		ys_ename.h
		include		ys_presno.h
;
		XALL
;
;
;------------------------------------------------------------------------
;-		global symbol						-
;------------------------------------------------------------------------
		GLB	SLIMEIN,BSLM4IN,BSLM6IN,BSLM8IN,SLEYEIN,SSLIMIN
;
		GLB	SLIMEMV,BSLM4MV,BSLM6MV,BSLM8MV,SLEYEMV,SSLIMMV
;
		GLB	BGDATA_MAKE
;
;------------------------------------------------------------------------
;-		extern symbol						-
;------------------------------------------------------------------------
;
;-------------< sy_main >------------------------------------------------
		EXT	SOUND_3_ON
;
;-------------< sy_rpro >------------------------------------------------
		EXT	CHIPON,CHIPON_RAM_READ
		EXT	B3CL
;
;-------------< sy_play >------------------------------------------------
		EXT	PLCOLTR
		EXT	EBSTAT
		EXT	PFAL,PSTP,PMOV
		EXT	PFLP,PDEM
;
;-------------< sy_bgsc >------------------------------------------------
		EXT	UNITCHG
;
;-------------< sy_enmy >------------------------------------------------
		EXT	ENEMY,ENINSB
		EXT	ENCLEAR,ENCLEAR_NORETN,DISPCK0,DISPCK1,DISPCK2
		EXT	ENINSR,ENINSR2,EEXCHK,EEYCHK,EEXYCK,ESTATST
		EXT	ENINSR_I,ENINSR2_I
		EXT	SCOREST,COLD_KIRA_ST,SHOT_EN_KILL
		EXT	ENMDCK,XSDOWN,EPCRCK,MUKEOR,XSPEOR,MKEOR2,PLFLST
		EXT	PLFLST_2
		EXT	COLBL_SET4,FSMK0_SET4,FSMK0_SET2
;
		EXT	EINIT,EFAIL,EMOVE,EEATM,ENOSE,EBABL,ERINT,EFALL
		EXT	EFIRE
;
		EXT	EATMXS,NOSWT
;
		EXT	ENFAIL0,EGGKILL_ALL,ENDEATH_SET
		EXT	SHOT_EN_KILL_S,SHOT_EN_KILL_2
;
		EXT	COLBL_SET2
;
		EXT	TROBJ_CANCEL
		EXT	TROBJ_SR_2x2,TROBJ_SR_4x4,TROBJ_SR_8x8
		EXT	TROBJ_SR_2x2_CL,TROBJ_SR_4x4_CL,TROBJ_SR_8x8_CL
		EXT	TROBJ_OAM_2x2,TROBJ_OAM_4x4,TROBJ_OAM_8x8
		EXT	TROBJ_OAM_2x2_I,TROBJ_OAM_4x4_I,TROBJ_OAM_8x8_I
		EXT	TROBJ_CLEAR
		EXT	TROBJ_PLOT_X,TROBJ_PLOT_Y
;
;-------------< sy_enmy3 >------------------------------------------------
		EXT	IWATSIN,BG3POLYST0,BG3POLYST
		EXT	ICE_IN_CK
		EXT	BSCLW_SET_B,BSCLW_SET_M
		EXT	BOSS_CLEAR
;
;-------------< sy_enmy5 >------------------------------------------------
		EXT	SLIME_START_ST,SLIME_START_ED
;
;-------------< sy_enmy6 >------------------------------------------------
		EXT	DOROB_RMODE0
		EXT	DOROB_RMODE1
		EXT	DOROB_RMODE2
		EXT	DOROB_RMODE3
		EXT	DOROB_RMODE5
		EXT	DOROB_RMODE6
		EXT	DOROB_RMODE7
		EXT	DOROB_RMODE8
		EXT	DOROB_RMODE9
;
		EXT	DOROB_R5_CHCT
;
		EXT	DOROB_R5_CHPT
;
;-------------< sy_exst >------------------------------------------------
		EXT	EXINSR
		EXT	SKSNOW
;
;-------------< sy_unit >------------------------------------------------
		EXT	UNCOMPRES,VRAMDX_ST
		EXT	UNDTADD,UNDATA,RUTDATA
;
		EXT	M_DMA_BFST
;
;-------------< ys_data >------------------------------------------------
		EXT	SIN,COS
;
;------------------------------------------------------------------------
;-		define symbol						-
;------------------------------------------------------------------------
;
BABY_INDEX	EQU	00H
;
;
;************************************************************************
;*									*
;*		program start						*
;*									*
;************************************************************************
;
		EXTEND
;
		MEM16
		IDX8
;
		DPAGE	EN0RAM
;
Group_1		GROUP	Boss1_pro
Boss1_pro	SECT	REL
;
;************************************************************************
;*		initial ( block slime )					*
;************************************************************************
;			 [4]	[6]    [8]
BSLM_XSRH	EQU	$
		WORD	00020H,00030H,00040H
BSLM_XSRH2	EQU	$
		WORD	00040H,00060H,00080H
BSLM_YSRH	EQU	$
		WORD	00050H,00060H,00080H
BSLM_DTADR	EQU	$
		WORD	BG3KAG0F,BG3KAG10,BG3KAG11
BSLM_VSUM	EQU	$
		WORD	00003H,00004H,00006H
BSLM_HSUM	EQU	$
		WORD	00004H,00006H,00008H
BSLM_VADX	EQU	$
		WORD	0FFE8H,0FFD8H,0FFC8H
BSLM_VADY	EQU	$
		WORD	0FFD0H,0FFC0H,0FFA0H
;
;USED WORK
;		EWORK0		*
;		EWORK2		*
;		EWORK4
;		EWORK6
;		EWORK8
;		EWORKA
;		EWORKC
;		EWORKE		*
;
BSLM8IN		EQU	$			;-- bslm8in --
BSLM6IN		EQU	$			;-- bslm6in --
BSLM4IN		EQU	$			;-- bslm4in --
		LDA	ENMYNO,X
		SEC
		SBC	#BSLM4
		ASL	A
		TAY

		LDA	<ENWRK0,X		;afubN݂̑`FbN ?
		BNE	BKSLMIN0090		;  no: BKSLMIN0090

		LDA	!BSLM_VADY,Y
		CLC
		ADC	ECENTY,X
		STA	R0
		LDA	!BSLM_VADX,Y
		CLC
		ADC	ECENTX,X
		STA	R8
		M_CHIPR M_BGUNIT_READ
		LDX	<ENINDX
		LDA	R6
		CMP	#UT0181			;afubN݂ ?
		BEQ	BKSLMIN0080		; yes: BKSLMIN0080

BKSLMIN0040	EQU	$
		JSL	>ENCLEAR

		RTL

BKSLMIN0080	EQU	$
		LDA	<EWORK0		;slime BG data buffer index <work> set
		STA	<ENWRK0,X	;

BKSLMIN0090	EQU	$
		LDA	BG3USEFG		;obN ?
		BNE	BKSLMIN0040		; yes: BKSLMIN0040

		LDA	ENXPSL,X		;vC[߂ɂ ?
		CLC				;
		ADC	#00008H			;
		SEC				;
		SBC	PCENTX			;
		CLC				;
		ADC	!BSLM_XSRH,Y		;
		CMP	!BSLM_XSRH2,Y		;
		BCS	BKSLMIN0100		;
						;
		LDA	PLYPSL			;
		SEC				;
		SBC	ENYPSL,X		;
		CLC				;
		ADC	!BSLM_YSRH,Y		;
		CMP	!BSLM_YSRH,Y		;
		BCC	BKSLMIN0200		; yes: BKSLMIN0200

BKSLMIN0100	EQU	$
		LDA	#EINIT
		STA	ENMODE,X

		RTL

BKSLMIN0200	EQU	$
		INC	BG3USEFG		;obNtOZbg

		LDA	#UT0181			;trans. data set ( change color attr. )
		JSL	>BGDATA_MAKE		;
						;
		LDA	<EWORK4			;
		XBA				;
		AND	#000E3H			;
		ORA	#00014H			;
;		LDA	#00016H			;trans. data set ( change color attr. )
		STA	SLMZMAX			;

		LDA	<ENWRK0,X		;slime BG data buffer index set
		STA	BLKBGID			;

		LDA	ENXPSL,X		;x pos. revise
		CLC				;
		ADC	#00008H			;
		STA	ENXPSL,X		;

		STZ	SLMCOLX			;blosk slime col. data index clear

		LDA	!BSLM_VSUM,Y		;v_line loop counter set
		STA	BLKVSUM			;
		ASL	A			;
		STA	<EWORK2			;

		LDA	ENXPSL,X		;Vram addr. calc.
		CLC				;
		ADC	!BSLM_VADX,Y		;
;;		AND	#001F0H			;
		PHA				;
		AND	#000F0H			;
		LSR	A			;
		LSR	A			;
		LSR	A			;
		STA	<EWORK0			;
						;
		PLA				;
		AND	#00100H			;
		BEQ	BKSLMIN0280		;
						;
		LDA	<EWORK0			;
		CLC				;
		ADC	#00400H			;
		STA	<EWORK0			;
						;
BKSLMIN0280	EQU	$			;
		LDA	ENYPSL,X		;
		CLC				;
		ADC	!BSLM_VADY,Y		;
;		AND	#001F0H			;
		AND	#000F0H			;
		ASL	A			;
		ASL	A			;
		ORA	<EWORK0			;
		STA	<EWORK0			;
		STA	BLKADDR			;

		LDA	!BSLM_HSUM,Y		;
		STA	<EWORKE			;
		STA	BLKHSUM			;h_line sum.set

		PHX

		PHB
		M8
		LDA	#BANK VRAMDX
		PHA
		PLB

		MI16
		LDX	#VRAMDX
		INX
		INX

BKSLMIN0300	EQU	$
		LDA	<EWORK0			;Vram addr. set
		STA	00H,X			;

		LDA	#00880H			;inc. mode & DMA para. set
		STA	02H,X			; 2115h & 4300h

		LDA	#00019H			;DMA B_bus addr. set
		STA	04H,X			;

		LDA	#SLMZMAX		;DMA A_bus addr. set
		STA	05H,X			;

		LDA	#BANK SLMZMAX		;DMA A_bus bank set
		STA	07H,X			;

		LDA	<EWORKE			;DMA trans. data sum. set
		ASL	A			;
		STA	08H,X			;

		TXA				;next data addr. calc.
		CLC				;
		ADC	#0000CH			;
		STA	0AH,X			;next data addr. set
		TAX

		DEC	<EWORK2			;trans. loop end ?
		BEQ	BKSLMIN0400		; yes: BKSLMIN0400

		LDA	<EWORK0			;next Vram addr. calc.
		CLC				;
		ADC	#00020H			;
		STA	<EWORK0			;

		BRA	BKSLMIN0300

BKSLMIN0400	EQU	$
		TXA				;last data addr. set
		STA	VRAMDX			;

		JSR	BLKSLM_COLCHG		;block slime col. init.

		PLB

		I8
		PLX

;--------------< colour data change >--------------
		LDA	#00008H			;colour change timer set
		STA	ENTIM0,X		;
		LSR	A
;		LDA	#00004H			;colour change counter set
		STA	SLMZMIN			;

;--------------<
		LDA	#0FFFFH
		STA	SLMSIZE			;slime size counter clear
		STZ	SLMHDFG				;tONA

		LDA	!BSLM_DTADR,Y		;bg3 data addr. set
		STA	BLKSIZE			;

		LDY	#008H			;routine mode index set
		STY	<ENWRK2,X		;

		LDA	#00000H			;ړ[Zbg
		STA	SLMLLMT
		LDA	#07FFFH			;ړE[Zbg
		STA	SLMRLMT

		RTL
;
BGDATA_MAKE	EQU	$			;BGUNIT data ( UT**** ) --> BG data
		PHY
		I16

		TAY
		AND	#0FF00H
		XBA
		ASL	A
		TAX
		LDA	>UNDTADD,X
		STA	<EWORK0
		TYA
		AND	#000FFH
		ASL	A
		ASL	A
		ASL	A
		CLC
		ADC	<EWORK0
		TAX
		LDA	>UNDATA,X
		STA	<EWORK4		;EWORK4 <-- chara no.1
		LDA	>UNDATA+2,X
		STA	<EWORK6		;EWORK6 <-- chara no.2
		LDA	>UNDATA+4,X
		STA	<EWORK8		;EWORK8 <-- chara no.3
		LDA	>UNDATA+6,X
		STA	<EWORKA		;EWORKA <-- chara no.4

		I8
		PLY

		LDX	<ENINDX

		RTL
;
;************************************************************************
;*		initial ( rbOՂ )					*
;************************************************************************
SLIME_I_SUB	EQU	$
		WORD	SLIME_I_SUB00		;afRLN^[]ibZ[Wpj
		WORD	SLIME_I_SUB01		;afRLN^[]ibZ[Wpj
		WORD	SLIME_I_SUB02		;afRXN[]ibZ[Wpj
		WORD	SLIME_I_SUB10		;f
		WORD	SLIME_I_SUB11		;fdmc`FbN
		WORD	SLIME_I_SUB12		;тՂfdmc`FbN
		WORD	SLIME_I_SUB20		;afRLN^[]iXCpj
		WORD	SLIME_I_SUB21		;afRLN^[]iXCpj
		WORD	SLIME_I_SUB22		;afRXN[]iXCpj
		WORD	SLIME_I_SUB30		;ՂiAjɂ
		WORD	SLIME_I_SUB40		;afQݒ
;
SLIMEIN		EQU	$			;-- slimein --
		TXY
		LDA	<ENWRK2,X
		ASL	A
		TAX
		JSR	(SLIME_I_SUB,X)

		LDA	#EINIT		;enemy mode keep init.
		STA	ENMODE,X	;

		RTL
;
SLIME_I_SUB10	EQU	$
		TYX
;
		LDA	#00000100B	;afR\hnmh
		TSB	MANSEL		;[ & SUBSEL ]
;
		LDA	PLXPSL			;vC[AĂ ?
		CMP	#001E0H			;
		BMI	SLIME_I_S100800		;  no: SLIME_I_S100800

		STZ	PLXSPD
		STZ	PLMVSP
		STZ	PLCMKI
;
;-------------- JbNZbg ----------------------------
		LDA	#KAMC2
		JSL	>ENINSR_I
		LDA	#00010H
		STA	ENXPSL,Y
;
;-------------- fZbg ----------------------------
		LDA	#DMPLC
		JSL	>ENINSR
		LDA	#SLIME_START_ST
		STA	ENWRK0,Y
		LDA	#SLIME_START_ED
		STA	ENWRKC,Y
		STZ	BOSS0FLG

		INC	<ENWRK2,X

SLIME_I_S100800 EQU	$

		RTS
;
SLIME_I_SUB11	EQU	$
		TYX
;
		LDY	BOSS0FLG		;Ղf ?
		BEQ	SLIME_I_S110800		; yes: SLIME_I_S110800
;		LDA	PLMODE			;Ղf ?
;		CMP	#PDEM			;
;		BEQ	SLIME_I_S110800		; yes: SLIME_I_S110800

		LDA	#SSLIM
		JSL	>ENINSR
		LDA	#00240H
		STA	ENXPSL,Y
		LDA	#00730H
		STA	ENYPSL,Y
		LDA	#00006
		STA	ENWRK2,Y
		M8
		STA	ENYUSN,Y
		LDA	#02EH
		STA	ENCLOR,Y
		M16

		LDX	#(10H*1)*2		;6 <- 1
SLIME_I_S110500 EQU	$
		LDA	>MOTOCOL+09H*10H*2-2,X
		STA	>DATACOL+0EH*10H*2-2,X
		DEX
		DEX
		BNE	SLIME_I_S110500

		LDX	<ENINDX
		STZ	BOSS0FLG
		INC	<ENWRK2,X

SLIME_I_S110800 EQU	$

		RTS
;
SLIME_I_SUB12	EQU	$
		TYX

		LDY	BOSS0FLG		;тՂ ?
		BEQ	SLIME_I_S120800		;  no: SLIME_I_S120800

		STZ	SLMSTGF
		LDY	BG2TYP			;PUFo[W ?
		CPY	#016H			;
		BNE	SLIME_I_S120500		;  no: SLIME_I_S120500

		INC	SLMSTGF
		LDY	#00AH
		STY	<ENWRK2,X
		RTS

SLIME_I_S120500 EQU	$
		INC	<ENWRK2,X

SLIME_I_S120800 EQU	$

		RTS
;
SLIME_I_SUB30	EQU	$
		TYX
;
		STZ	TROBJ_ARIA		;
;
		LDA	SCCH1			;CjVw@onrDZbg
		CLC				;
		ADC	#000A8H			;
		STA	ENXPSL,X		;
		LDA	#00728H			;CjVx@onrDZbg
		STA	ENYPSL,X		;
		STA	SLSTCPY			;
		LDA	#007B0H			;`FbNx@onrDZbg
		STA	SLMYLOW			;

		INC	BG3USEFG		;obNtOZbg

		LDY	#SLIME_RMODE3		;routine mode index set
		STY	<ENWRK2,X		;
;
		LDA	#SLMAP		;(A) <-- exstra no.
		JSL	>EXINSR

		LDA	#0FFFFH		;timer set
		STA	EXTIM0,Y	;
		LDA	ENXPSL,X	;x_pos set
		STA	EXXPSL,Y	;

		LDA	ENYPSL,X	;y_pos set
		CLC
		ADC	#00006H
		STA	ENYPSL,X
		STA	EXYPSL,Y	;

		LDA	ENYPSL,X		;Z^[onrDZbg
		SEC
		SBC	ESCCV1
		CLC
		ADC	#0000EH+8
		STA	SLMKIRE

		TYA			;appear data index save
		STA	ENWRK8,X	;

		TXA			;slime data index save
		STA	EXWRK0,Y	;

;--------------< other work set >----------------
		STZ	SLMZMAX			;^e{Xs[hl`wNA
		STZ	SLMZMIN			;^e{Xs[hlhmNA
		STZ	SLMFTFG			;ntONA
		STZ	SLMSPOI			;rhmf[^|C^[NA
		STZ	SLMSXZM			;rhmf[^Aw@Y[NA
		LDA	#00100H			;rhmf[^Ax@XebvZbg
		STA	SLMSYST			;
		STZ	SLMYURE			;Ղh񐔃NA
		STZ	SLMDMGF			;_[WtONA
		STZ	SLMNIGE			;т̂tONA
		LDA	#0FFFFH
		STA	SLMSIZE			;ՂTCYNA
		STZ	SLMDMGT			;Ղ_[W^C}[Zbg

		LDA	#000E0H			;{lZbg
		STA	<ENWRK0,X		;

		STZ	ENWRKA,X		;␳bNtONA
		STZ	SLMHDFG			;tONA

		DEC	ENTIM3,X		;X^[gXgbv^C}[Zbg
		LDA	#00001			;X^[gXgbvtOZbg
		STA	SLMSTART		;
		STZ	SLMDEMO			;ՂtONA
;;;;;;;;		LDA	#00016H			;mrn
;;;;;;;;		STA	SOUND2

		PLA			;ڂqsk
		RTL
;
;------------------------------------------------------------------------
;-		afRLN^[]					-
;------------------------------------------------------------------------
SLIME_I_SUB00	EQU	$
		LDA	#CHRE8A		;(A) <-- LN^[oNibZ[Wj
		BRA	SLIME_I_SUB2010
SLIME_I_SUB01	EQU	$
		LDA	#CHRE8B		;(A) <-- LN^[oNibZ[Wj
		BRA	SLIME_I_SUB2110
;
SLIME_I_SUB20	EQU	$
		LDA	#CHR23A		;(A) <-- LN^[oNiXCj
SLIME_I_SUB2010 EQU	$
;
		I16
;
		LDY	#2800H		;(Y) <-- uq`lAhX
		BRA	SLIME_I_SUB2020
SLIME_I_SUB21	EQU	$
		LDA	#CHR22B		;(A) <-- LN^[oNiXCj
SLIME_I_SUB2110 EQU	$
;
		I16
;
		LDY	#2C00H		;(Y) <-- uq`lAhX
;
SLIME_I_SUB2020 EQU	$
		PHA			;(A) save
		PHY			;(Y) save
;
		I8
;
		LDA	#00000100B+(00000100B*100H) ;afR\hneeh
		TRB	MANSEL		;[ & SUBSEL ]
;
		JSL	>TROBJ_CANCEL	;]GAJ
;
		I16
;
		PLY			;(Y) <-- uq`lAhX
		PLA			;(A) <-- LN^[oN
		JSR	UNCOM_VRAMTR
;
		IDX8
;
		BRA	SLIMEIN_MODINC
;
;------------------------------------------------------------------------
;-		afRXCXN[]				-
;------------------------------------------------------------------------
SLIME_I_SUB02	EQU	$
		LDA	#B3CL		;afRXN[NA[
		STA	VRFLG
;
		I16
;
		LDX	#BG3_SUB_A_COL+((0FH-1)*2) ;(X) <-- J[|C^[ibZ[Wj
;-------------- J[Zbg --------------------------------------------
SLIME_I_SUB2210 EQU	$
		PHB			;(DBR) save
		PEA	DATACOL/100H	;(DBR) <-- DATACOL(B)
		PLB
		PLB
;
		LDY	#(0FH-1)*2
SLIME_I_SUB2220 EQU	$
		LDA	>COL_ADDRESS,X	;afJ[Zbg
		STA	MOTOCOL+01H*2,Y
		STA	DATACOL+01H*2,Y
		DEX
		DEX
		DEY
		DEY
		BPL	SLIME_I_SUB2220
;
		PLB
;
		I8
;
		BRA	SLIMEIN_MODINC
;
SLIME_I_SUB22	EQU	$
;
		I16
;
		LDA	#B3TEKI0	;(A) <-- LN^[oN
		LDY	#3400H		;(Y) <-- uq`lAhX
		JSR	UNCOM_VRAMTR
		IDX8
;
;-------------- J[Zbg --------------------------------------------
		LDX	#006

SLIME_I_SUB2240 EQU	$
		LDA	>COL_ADDRESS+BG3_TEKI_1+0*2,X
		STA	>MOTOCOL+4*2,X
		STA	>DATACOL+4*2,X
		DEX
		DEX
		BPL	SLIME_I_SUB2240
;
SLIMEIN_MODINC	EQU	$
		LDX	<ENINDX
		INC	<ENWRK2,X
		RTS
;
SLIME_I_SUB40	EQU	$
;
;-------------- J[Zbg --------------------------------------------
		LDX	#0EH*2
SLIME_I_S400100 EQU	$
		LDA	>COL_ADDRESS+SLIMEBOSS_COL-2,X
		STA	>MOTOCOL+(06H*10H+01H)*2-2,X
		STA	>DATACOL+(06H*10H+01H)*2-2,X
		LDA	>COL_ADDRESS+SLIMEBOSS_COL+0EH*2-2,X
		STA	>MOTOCOL+(07H*10H+01H)*2-2,X
		STA	>DATACOL+(07H*10H+01H)*2-2,X
		DEX
		DEX
		BNE	SLIME_I_S400100

;afQG֕ύX
		LDY	#0FH			;g|cl`p[^ύX
		STY	4331H
		INY		;[ LDY	#10H ]
		STY	4341H

		LDX	<ENINDX
		DEC	<ENWRK2,X

		RTS
;
;------------------------------------------------------------------------
;-		kf[^̉𓀁Auq`lւ̓]			-
;-			in :						-
;-				(A) <-- LN^[oN		-
;-				(Y) <-- uq`lAhX		-
;------------------------------------------------------------------------
;
		MEM16
		IDX16
;
UNCOM_VRAMTR	EQU	$
		PHY			;(Y) save
;
;-------------- kf[^̉ ----------------------------------------
		LDX	#WOB7CHR+1000H	;(X) <-- kf[^i[AhXZbg
		JSL	>UNCOMPRES	;[ (A) <-- WJf[^oCg ]
;
;-------------- WJf[^] ------------------------------------------
		PLY			;(Y) <-- uq`lAhX
		LDX	#BANK WOB7CHR
		STX	WORK1		;(WK1,2) <-- ]AhXiaj
		LDX	#WOB7CHR+1000H	;(X)	 <-- ]AhXikCgj
		JSL	>VRAMDX_ST
;
		I8
;
		RTS
;
;************************************************************************
;*		move	( rbOՂ )					*
;************************************************************************
;		ENWRK0	{
;		ENWRK2	ROUTINE MODE INDEX
;		ENWRK4	{Xs[h~bg
;		ENWRK6	{Xs[h
;		ENWRK8	APPEAR DATA INDEX SAVE / SLIME_EYE ROUTINE INDEX ( ENEMY INDEX )
;		ENWRKA	USE
;		ENWRKC	ntO	0...FOOT 2...HEAD
;
;		ENCONT	{JE^[
;
;		SLMIDX0 GCfbNX
;		SLMZMAX ^e{l`wD
;		SLMZMIN ^e{lhmD
;		SLMFTFG ntO (0BIT)
;		SLMKIRE Z^[onrD
;		SLMSPOI SIN f[^|C^[
;		SLMSXZM SIN f[^|C^[w@ynnl@ek`f
;		SLMSYST SIN f[^|C^[x@rsdo
;		SLMDMGT Ղ_[W^C}[
;		SLMYURE rbOՂh
;		SLMDMGF Ղ_[WtO
;		SLMNIGE Ղ撵т̂tO
;		SLMTRZM rbOՂό`{
;
;		SLMYLOW ̂x@onrD
;
;		SLMLLMT ړ[Z[u
;		SLMRLMT ړE[Z[u
;
;		SLMSTART X^[gbNtO
;		SLMDEMO ՂftO
;		SLMSTGF Xe[WtO	0...afR 1...afQ
;
;		SLMHDFG Ղ擪tO
;		SLMHDYP Ղ擪̂x@onrD
;
;		SLMSIZE TCY
;		SLMSIZE2 TCY2
;
;		ENTIM0	Xgbv^C}[
;		ENTIM1	_[W`FbNbN^C}[
;		ENTIM2
;		ENTIM3	X^[gbN^C}[
;
SLIME_SUB	EQU	$
SLIME_0		EQU	$
		WORD	SLIME_SUB0	;		Ղ *
SLIME_1		EQU	$
		WORD	SLIME_SUB1	;[			Ղ *
SLIME_2		EQU	$
		WORD	SLIME_SUB2	;		Ղ *
SLIME_3		EQU	$
		WORD	SLIME_SUB3	;ł͂		Ղ
SLIME_4		EQU	$
		WORD	SLIME_SUB4	;		Ղ *
SLIME_5		EQU	$
		WORD	SLIME_SUB0	;		Ղ *
SLIME_6		EQU	$
		WORD	SLIME_SUB6	;ႭȂ		Ղ *
SLIME_7		EQU	$
		WORD	SLIME_SUB7	;܂		Ղ *
;
SLIME_8		EQU	$
		WORD	SLIME_SUB8	;J[`FW@ԂՂ
SLIME_9		EQU	$
		WORD	SLIME_SUB9	;ւ񂯂@@@@ԂՂ
;
;		*...KYO-TSU-
;
SLIME_RMODE0	EQU	(SLIME_0-SLIME_SUB)/2
SLIME_RMODE1	EQU	(SLIME_1-SLIME_SUB)/2
SLIME_RMODE2	EQU	(SLIME_2-SLIME_SUB)/2
SLIME_RMODE3	EQU	(SLIME_3-SLIME_SUB)/2
SLIME_RMODE4	EQU	(SLIME_4-SLIME_SUB)/2
SLIME_RMODE5	EQU	(SLIME_5-SLIME_SUB)/2
SLIME_RMODE6	EQU	(SLIME_6-SLIME_SUB)/2
SLIME_RMODE7	EQU	(SLIME_7-SLIME_SUB)/2
SLIME_RMODE8	EQU	(SLIME_8-SLIME_SUB)/2
SLIME_RMODE9	EQU	(SLIME_9-SLIME_SUB)/2
;
BSLM4MV		EQU	$			;-- bslm4mv --
BSLM6MV		EQU	$			;-- bslm6mv --
BSLM8MV		EQU	$			;-- bslm8mv --
SLIMEMV		EQU	$			;-- slimemv --
;		ldy	#004
;		sty	2100h
;
		LDA	<ENWRK0,X
		STA	R0
		LDY	SLMSIZE+1
		TYA
		STA	R6
		M_CHIP	MULTIPLY
		LDX	<ENINDX
		LDA	R0
		STA	SLMSIZE2

		JSR	SLIME_OAM_SET

		JSL	>ENMDCK			;mode check

		LDY	<ENWRK2,X		;J[ςĂ ?
		CPY	#SLIME_RMODE8		;
		BEQ	SLIMEMV0400		; yes: SLIMEMV0400
		CPY	#SLIME_RMODE9		;ubNm[}ɂȂĂr ?
		BEQ	SLIMEMV0300		; yes: SLIMEMV0300

;		PHY

		JSR	SLIME_BGDTMK		;BG check
;
		JSR	SLIME_OBJCK		;vs enemy check

SLIMEMV0300	EQU	$
		JSR	SLIME_PLCHK		;vs player check

SLIMEMV0400	EQU	$
		JSR	SLIME_BGCHK

SLIMEMV0500	EQU	$
		TXY
		LDA	<ENWRK2,X
		ASL	A
		TAX
		JSR	(SLIME_SUB,X)

		LDA	ENTIM3,X		;X^[gbN ?
		BNE	SLIMEMV0600		; yes: SLIMEMV0600

		STZ	SLMSTART		;X^[gbNtONA
		STZ	PLMODE

SLIMEMV0600	EQU	$
		LDA	SLMDMGT
		BEQ	SLIMEMV0700

		DEC	SLMDMGT

SLIMEMV0700	EQU	$
;		ldy	#00fh
;		sty	2100h

		RTL
;
SLIME_OAM_SET	EQU	$
		LDY	<ENWRK2,X		;J[ςĂ ?
		CPY	#SLIME_RMODE8		;
		BEQ	SLIME_O_SET0800		; yes: SLIME_O_SET0800
		CPY	#SLIME_RMODE9		;ubNm[}ɂȂĂr ?
		BEQ	SLIME_O_SET0800		; yes: SLIME_O_SET0800
		CPY	#SLIME_RMODE7		;Ghf ?
		BNE	SLIME_O_SET0500		;  no: SLIME_O_SET0500

		LDY	SLMDEMO			;afR ?
		CPY	#002			;
		BPL	SLIME_O_SET0800		; yes: SLIME_O_SET0800

SLIME_O_SET0500	EQU	$
		JSR	SLIME_CHIP		;slime data set

SLIME_O_SET0800 EQU	$

		RTS
;
SLIME_BGCHK	EQU	$
		LDY	<ENWRK2,X
		CPY	#SLIME_RMODE5		;Wv ?
		BEQ	SLIME_BGCHK0100		; yes: SLIME_BGCHK0100
		CPY	#SLIME_RMODE4
		BPL	SLIME_BGCHK0800

SLIME_BGCHK0100 EQU	$
		LDA	ENCBFG,X		;ǂɂ ?
		AND	#0000CH			;
		BEQ	SLIME_BGCHK0800		;  no: SLIME_BGCHK0800

		AND	#00008H
		LSR	A
		LSR	A
		DEC	A
		CLC
		ADC	ENXPSL,X
		SEC
		SBC	ENMOVX,X
		STA	ENXPSL,X

		LDA	ENXSPD,X
		EOR	#0FFFFH
		INC	A
		STA	ENXSPD,X
		LDA	ENXMAX,X
		EOR	#0FFFFH
		INC	A
		STA	ENXMAX,X

SLIME_BGCHK0800 EQU	$

		RTS
;
SLIME_SUB0	EQU	$
		TYX

		JSR	SLIME_MOV

		LDA	SLMSXZM
		BEQ	SLIME_SUB0300
		BMI	SLIME_SUB0200

		DEC	SLMSXZM

		BRA	SLIME_SUB0300

SLIME_SUB0200	EQU	$
		INC	SLMSXZM

SLIME_SUB0300	EQU	$

		RTS
;
PUYO_YURE_XSPD	EQU	$
		WORD	00100H,0FF00H
;
SLIME_SUB1	EQU	$
		TYX

		LDY	SLMSTART		;X^[gbN ?
		BNE	SLIME_SUB1008		; yes: SLIME_SUB1008

		LDA	SLMNIGE			;ʏ ?
		BEQ	SLIME_SUB1050		;  no: SLIME_SUB1050

		LDY	SLMSIZE+1		;ՂAȂĂ ?
		CPY	#04BH			;
		BCC	SLIME_SUB1050		; yes: SLIME_SUB1050

		BIT	#00001H			;Ղ_[W󂯂 ?
		BNE	SLIME_SUB1010		;  no: SLIME_SUB1010

		STZ	ENXSPD,X		;w@roddcNA
		STZ	ENXPOW,X		;w@onvdqNA

		LDA	#00002H			;Ղh񐔃Zbg
		STA	SLMYURE			;

		LDY	#SLIME_RMODE4		;routine mode index set
		STY	<ENWRK2,X		;

SLIME_SUB1008	EQU	$

		RTS

SLIME_SUB1010	EQU	$
		LDA	#00400H			;{Xs[h̏ƃ~bgZbg
		STA	SLMZMAX			;
		STA	<ENWRK4,X		;

		LDA	#0FCE0H			;{Xs[h̉Zbg
		STA	SLMZMIN			;

		LDA	SLMNIGE			;ՂEɐiƂĂ ?
		AND	#00002H			;   0... yes 2...no
		TAY				;iт̂Xs[hZbgj
		LDA	!PUYO_YURE_XSPD,Y
		STA	ENXMAX,X

		STZ	SLMNIGE			;tobinoki flag clear

		LDY	#SLIME_RMODE5
		STY	<ENWRK2,X		;routine mode index set

		RTS

SLIME_SUB1050	EQU	$
		LDA	EPWIDX,X		;vC[߂ɂ ?
		CLC				;
		ADC	#00080H			;
		CMP	#00100H			;
		BCS	SLIME_SUB1100		;  no: SLIME_SUB1100

		LDA	<RANDM0			;Wv ?
		BIT	#00003H			;
		BEQ	SLIME_SUB1100		; yes: SLIME_SUB1100

		STZ	SLMYURE			;Ղh񐔃NA

		STZ	SLMSXZM			;sin data x zoom clear

		LDA	#00010H			;w@onvdqZbg
		STA	ENXPOW,X		;

		LDA	#00100H			;{Xs[h̏ƃ~bgZbg
		STA	SLMZMAX			;
		STA	<ENWRK4,X		;

		LDY	#SLIME_RMODE2		;routine mode index set
		STY	<ENWRK2,X		;
		BRA	SLIME_SUB1200		;  no: SLIME_SUB1200

SLIME_SUB1100	EQU	$
		LDA	#00400H			;{Xs[h̏ƃ~bgZbg
		STA	SLMZMAX			;
		STA	<ENWRK4,X		;

		LDA	#0FCE0H			;{Xs[h̉Zbg
		STA	SLMZMIN			;

		STZ	<ENWRK2,X		;routine mode index set

SLIME_SUB1200	EQU	$
		LDA	#000C0H
		LDY	EPXMUK,X
		BNE	SLIME_SUB1300

		EOR	#0FFFFH
		INC	A

SLIME_SUB1300	EQU	$
		STA	<EWORK0

		LDA	EPWIDX,X
		STA	<EWORK2

		LDA	ENCBFG,X		;isɕ ?
		AND	#0000CH			;
		BEQ	SLIME_SUB1400		;
		SEC				;
		SBC	#00006H			;
		EOR	<EWORK2			;
		BMI	SLIME_SUB1400		;  no: SLIME_SUB1400

		LDA	<EWORK0
		EOR	#0FFFFH
		INC	A
		STA	<EWORK0

SLIME_SUB1400	EQU	$
		LDA	<EWORK0
		LDY	SLMDMGF			;_[W󂯂 ?
		BEQ	SLIME_SUB1800		;  no: SLIME_SUB1800

		STZ	SLMDMGF			;Ղ_[WtONA
		EOR	#0FFFFH
		INC	A

SLIME_SUB1800	EQU	$
		STA	R0
		LDY	SLMSIZE+1
		TYA
		STA	<EWORK0
		LDA	#00200H
		SEC
		SBC	<EWORK0
		STA	R6
		M_CHIP	MULTIPLY
		LDX	<ENINDX
		LDA	R0
		STA	ENXMAX,X

		RTS
;
SLIME_SUB2	EQU	$
		TYX

		LDA	<ENWRK4,X	;nobiteru ?
		CMP	SLMZMAX		;
		BNE	SLIME_SUB2200	;  no: SLIME_SUB2200

		LDA	ENXMAX,X
		BMI	SLIME_SUB2300

SLIME_SUB2100	EQU	$
		INC	SLMSXZM

		BRA	SLIME_SUB2400

SLIME_SUB2200	EQU	$
		LDA	ENXMAX,X
		BMI	SLIME_SUB2100

SLIME_SUB2300	EQU	$
		DEC	SLMSXZM

SLIME_SUB2400	EQU	$
		JSR	SLIME_MOV200

		LDY	SLMSIZE+1		;ՂAȂĂ ?
		CPY	#04BH			;
		BCC	SLIME_SUB2800		; yes: SLIME_SUB2800

		TXA
		STA	R1

		M_CHIP	SHOTENSR

		LDX	<ENINDX

		LDA	R1		;shot enemy nothing ?
		BMI	SLIME_SUB2800	; yes: SLIME_SUB2800

		TAY
		LDA	ENXPSL,Y		;range check
		SEC				;
		SBC	ENXPSL,X		;
		STA	<EWORK0			;
		CLC				;
		ADC	#00080H			;
		CMP	#00100H			;
		BCS	SLIME_SUB2700		; range over: SLIME_SUB2700

		LDA	<EWORK0			;ĂĂ ?
		EOR	ENXSPD,Y		;
		BPL	SLIME_SUB2800		;  no: SLIME_SUB2800

		LDA	#SLIME_RMODE1		;routine mode index set
		STA	<ENWRK2,X		;
		STA	SLMNIGE			;tobinoki flag set

		LDA	<EWORK0
		BMI	SLIME_SUB2800

;		LDA	SLMNIGE
;		ORA	#00002H
		LDA	#00003H
		STA	SLMNIGE

		BRA	SLIME_SUB2800

SLIME_SUB2700	EQU	$
;;;;;;;;		PLP

SLIME_SUB2800	EQU	$
		LDA	ENCBFG,X		;͕ ?
		BIT	#0000CH			;
		BEQ	SLIME_SUB2900		;  no: SLIME_SUB2900

		LDA	#00003H			;Ղh񐔃Zbg
		STA	SLMYURE			;

SLIME_SUB2900	EQU	$

		RTS
;
SLIME_SUB3	EQU	$
		TYX

		LDY	ENWRK8,X
		LDA	ENYPSL,X
		SEC
		SBC	EXYPSL,Y
		CMP	#00050H
		BMI	SLIME_SUB3200
		CMP	#00068H
		BPL	SLIME_SUB3100

		LDA	#00300H
		STA	ENGMAX,X
		BRA	SLIME_SUB3200

SLIME_SUB3100	EQU	$
		STZ	SLSTCPY		;( bg3 < bg1 ) ==> ( bg3 > bg1 )

		LDA	#00010H		;new GPOW set
		STA	ENGPOW,X	;

		LDA	#00400H		;new GMAX set
		STA	ENGMAX,X	;

		LDA	#00080H			;X^[gXgbv^C}[Zbg
		STA	ENTIM3,X		;

		STZ	<ENWRK2,X	;routine mode index set

		JSR	SLMEYE_SET

SLIME_SUB3200	EQU	$
		JSR	SLIME_MOV	;

		RTS
;
;		SLMSPOI SIN DATA POINTER
;		SLMSXZM SIN DATA X ZOOM FLAG
;		SLMSYST SIN DATA Y STEP
;
SLIME_SUB4	EQU	$
		TYX

		LDA	SLMYURE			;ՂhI ?
		BNE	SLIME_SUB4050		;  no: SLIME_SUB4050

		LDA	SLMSXZM		;sin data x zoom hosei end ?
		BMI	SLIME_SUB4030	; yes: SLIME_SUB4030

		DEC	SLMSXZM		;sin data x zoom hosei

		RTS

SLIME_SUB4030	EQU	$
		LDY	#SLIME_RMODE1		;routine mode index set
		STY	<ENWRK2,X		;

		STZ	SLMSXZM			;sin data x zoom clear
		STZ	SLMNIGE			;puyo damage flag clear

		RTS

SLIME_SUB4050	EQU	$
		LDA	SLMYURE
		BIT	#00001H
		BNE	SLIME_SUB4100

		LDA	SLMSYST
		CLC
		ADC	#00040H
		STA	SLMSYST
		CMP	#00800H
		BNE	SLIME_SUB4300
		BRA	SLIME_SUB4200

SLIME_SUB4100	EQU	$
		LDA	SLMSYST
		SEC
		SBC	#00040H
		STA	SLMSYST
		CMP	#00100H
		BNE	SLIME_SUB4300

SLIME_SUB4200	EQU	$
		DEC	SLMYURE

SLIME_SUB4300	EQU	$
		LDA	SLMSXZM		;sin data x zoom flag cul. & set
		CMP	#00008H		;
		BCS	SLIME_SUB4900

		INC	SLMSXZM

SLIME_SUB4900	EQU	$

		RTS
;
SLIME_S6_XSPD	EQU	$
		WORD	00080H,00100H,00200H,00400H
SLIME_S6_YSPD	EQU	$
		WORD	0FF80H,0FF00H,0FE00H,0FC00H
;
SLIME_SUB6	EQU	$
		TYX

		LDA	ENTIM0,X		;Xgbv ?
		BNE	SLIME_SUB6300		; yes: SLIME_SUB6300

		LDA	#00002
		STA	ENTIM0,X

		LDA	<RANDM0
		AND	#0000EH
		TAY
		LDA	!SLIME_S6_XSPD,Y
		STA	<EWORK0
		LDA	<RANDM0+1
		AND	#00006H
		TAY
		LDA	!SLIME_S6_YSPD,Y
		STA	<EWORK2
		LDA	<RANDM0
		AND	#0000FH
		SEC
		SBC	#00008
		STA	<EWORK4

		LDA	#0003BH			;mrn
		JSL	>SOUND_3_ON

		LDA	#SLMSB		;(A) <-- enemy no.
		JSL	>EXINSR

		LDA	ENXPSL,X
		CLC
		ADC	<EWORK4
		STA	EXXPSL,Y	;X pos set
		LDA	ENYPSL,X
		SEC
		SBC	#00004
		STA	EXYPSL,Y	;Y pos set
		LDA	#0FFFFH
		STA	EXTIM0,Y
		LDA	<EWORK0
		STA	EXXSPD,Y
		LDA	<EWORK2
		STA	EXYSPD,Y
		M8
		LDA	#0FFH
		STA	EXWTSP,Y
		M16

SLIME_SUB6300	EQU	$
		LDA	SLMSIZE			;ŃTCYɂȂ ?
		SEC				;
		SBC	#00020H			;
		STA	SLMSIZE			;
		CMP	#02000H			;
		BCS	SLIME_SUB6800		;  no: SLIME_SUB6800

		LDA	#00040H
		STA	ENTIM0,X
		INC	<ENWRK2,X

SLIME_SUB6800	EQU	$

		RTS
;
SLIME_SUB7	EQU	$
		TYX

		LDA	ENTIM0,X		;Xgbv ?
		BNE	SLIME_SUB7800		; yes: SLIME_SUB7800

		INC	SLMDEMO
		LDY	SLMDEMO
		CPY	#001
		BEQ	SLIME_SUB7500
		CPY	#002
		BEQ	SLIME_SUB7300

		STZ	TROBJ_ARIA
		JSL	>BOSS_CLEAR
		PLA
		RTL

SLIME_SUB7300	EQU	$
		LDA	ENXPSL,X
		STA	<EWORK0
		LDA	ENYPSL,X
		STA	<EWORK2
		JSL	>BSCLW_SET_B
		LDA	#000C0H			;Xgbv^C}[Zbg
		STA	ENTIM0,X		;

		RTS

SLIME_SUB7500	EQU	$
		LDA	ENWRK8,X
		TAX
		LDA	#SMOK0		;(A) <-- exstra no.
		JSL	>EXINSR
		LDA	ENXPSL,X	;X pos set
		STA	EXXPSL,Y
		LDA	ENYPSL,X	;Y pos set
		STA	EXYPSL,Y
		LDA	#00		;X speed set
		STA	EXXSPD,Y
		LDA	EXMOD2,Y
		AND	#0FFFCH
		STA	EXMOD2,Y
		LDA	#0FFC0H		;Y speed set
		STA	EXYSPD,Y
		LDA	#02		;counter set
		STA	EXWRK0,Y
		LDA	#06		;timer set
		STA	EXTIM0,Y

		JSL	>ENCLEAR		;Ղ̖ڂNA

		LDA	#0001CH		;mrn
		JSL	>SOUND_3_ON

		LDA	#00002H
		STA	ENTIM0,X

SLIME_SUB7800	EQU	$

		RTS
;
SLIME_SUB8	EQU	$
		TYX
;
		LDA	ENTIM0,X	;Xgbv ?
		BNE	SLIME_SUB8200	;  no: SLIME_SUB8200

		DEC	SLMZMIN		;colour change counter dec.
		BEQ	SLIME_SUB8100	;colour change end ?
					; yes: SLIME_SUB8100

		LDA	#00008H		;colour change timer set
		STA	ENTIM0,X	;

		JSR	BLKSLM_COLCHG	;

		RTS

SLIME_SUB8100	EQU	$
		STZ	SLMTRZM		;counter ( bairitu ) clear

		INC	<ENWRK2,X	;routine mode index inc.

SLIME_SUB8200	EQU	$

		RTS
;
SLIME_SUB9	EQU	$
		TYX

		LDA	SLMTRZM		;first change ?
;		BNE	SLIME_SUB9100	;  no: SLIME_SUB9100
		BEQ	SLIME_SUB9010
		JMP	SLIME_SUB9100

SLIME_SUB9010	EQU	$
		PHA

;		clear ??
;
;		LDA	#01220H			;trans. data set
;		LDA	#013EEH			;trans. data set
;		STA	BLKVRDT
;
		LDA	#UT0000		;trans. data set
		JSL	>BGDATA_MAKE

		LDA	<EWORK4

		PHX			;trans. data set ( BG space data )
		LDX	#000H
SLIME_SUB9030	EQU	$
		STA	BLKVRDT,X
		INX
		INX
		CPX	#020H
		BNE	SLIME_SUB9030

		PLX
		LDA	BLKADDR		;vram addr. set
		STA	<EWORK0		;

		LDA	BLKVSUM		;V_line sum.set
		ASL	A
		STA	<EWORK2		;

		PHX

		PHB
		M8
		LDA	#BANK VRAMDX
		PHA
		PLB

		MI16
		LDX	#VRAMDX
		INX
		INX

SLIME_SUB9050	EQU	$
		LDA	<EWORK0		;Vram addr. set
		STA	00H,X		;

		LDA	#00180H		;inc. mode & DMA para. set
		STA	02H,X		; 2115h & 43*0h

		LDA	#00018H		;DMA B_bus addr. set ( 0021**H )
		STA	04H,X		;

		LDA	#BLKVRDT	;DMA A_bus addr. set
		STA	05H,X		;

		LDA	#BANK BLKVRDT	;DMA A_bus bank set
		STA	07H,X		;

		LDA	BLKHSUM		;DMA trans. data sum. set
		ASL	A
		ASL	A
		STA	08H,X		;

		TXA			;next data addr. calc.
		CLC			;
		ADC	#0000CH		;
		STA	0AH,X		;next data addr. set
		TAX

		DEC	<EWORK2		;trans. data end ?
		BEQ	SLIME_SUB9080	; yes: SLIME_SUB9080

		LDA	<EWORK0		;next Vram addr. calc.
		CLC			;
		ADC	#00020H		;
		STA	<EWORK0		;

		BRA	SLIME_SUB9050

SLIME_SUB9080	EQU	$
		TXA			;last data addr. set
		STA	VRAMDX		;

		I8

		PLB
		PLX

		PHX
		I16

		LDA	BLKVSUM		;tate loop counter set
		STA	<EWORK0		;

		LDX	BLKBGID

SLIME_SUB9081	EQU	$
		PHX

		LDY	BLKHSUM		;yoko loop counter set

SLIME_SUB9088	EQU	$
;		LDA	#UT00D5		;normal kabe set
		LDA	#UT0000		;nuki set
		STA	>BGUNIT,X	;

		INX			;data set index inc.
		INX			;data set index inc.

		DEY			;yoko loop end ?
		BNE	SLIME_SUB9088	;  no: SLIME_SUB9088

		PLA			;next v_line addr. calc.
		CLC			;
		ADC	#00020H		;
		TAX			;

		DEC	<EWORK0		;tate loop end ?
		BNE	SLIME_SUB9081	;  no: SLIME_SUB9081

		I8
		PLX

		PLA

SLIME_SUB9100	EQU	$
		CMP	#00102H		;henkei end?
		BNE	SLIME_SUB9200	;  no: SLIME_SUB9200

;--------------< normal routine data set >-------------
		LDA	#00010H		;G pow set
		STA	ENGPOW,X	;

		LDA	#00400H		;G max set
		STA	ENGMAX,X	;

		LDA	#000E0H			;bairitu set
		STA	<ENWRK0,X		;
		STZ	ENWRK6,X		;bairitu speed clear
		STZ	ENWRK4,X		;bairitu max clear
		LDY	#SLIME_RMODE1		;routine mode index set
		STY	<ENWRK2,X		;

		STZ	SLMZMAX			;^e{Xs[hZbg
		STZ	SLMFTFG			;ntONA

		LDA	ENDSYL,X		;Z^[onrDZbg
		CLC
		ADC	#00016H
		STA	SLMKIRE

		STZ	SLMSPOI		;,,,,,,
		STZ	SLMSXZM		;sin data x zoom flag clear
		LDA	#00100H		;sin data y step set
		STA	SLMSYST		;
		STZ	SLMYURE			;Ղh񐔃NA
		STZ	SLMNIGE		;т̂tONA
		STZ	SLMTRZM		;puyo henkei bairitu clear

		STZ	SLSTCPY		;( slime start y pos. for compare ) clear

		STZ	ENWRKC,X		;ntONA

		JMP	SLMEYE_SET	;puyo eye set

SLIME_SUB9200	EQU	$
		LDA	BLKSIZE
		STA	R1		;(R1) <-- from data address
		LDA	#BG3KAG0E
		STA	R2		;(R2) <-- to data address
		LDA	SLMTRZM
		STA	R3		;(R3) <-- counter ( bairitu )
;
		LDA	#BANK BG3KAG00
		STA	R0		;(R0) <-- data bank

		LDA	ENDSYL,X
		STA	R4		;(R4) <-- base Y pos

		LDA	#00078H
		SEC
		SBC	ENDSXL,X
		STA	R5		;(R5) <-- base X pos

		LDA	PLDSXL
		STA	CCWORKA		;(CWKA) <-- player display X pos
		LDA	PLDSYL
		STA	CCWORKB		;(CWKB) <--	   "       Y  "
		LDA	PLSITD
		STA	CCWORKC		;(CWKC) <--    "   sit down flag

		M_CHIP	BG3CHNG
;
		I16
;
;--------------< data trans. >-----------------
		JSL	>M_DMA_BFST
		LWORD	HDMABUF		;to address set
		LWORD	HDMABF		;from address set
		WORD	0D2H*2*2	;number of byte set

;--------------< config. set >-------------------
		MI8

;		LDA	#079H		;
;		STA	BGMODE		;
;
;		LDA	#015H
;		STA	MANSEL
;
;;		LDA	#000H
;		STZ	SUBSEL
;
;		LDA	#002H
;		STA	WIND30
;
;		LDA	#020H
;		STA	SUBADF
;
;		LDA	#002H		;
;		STA	NMITYP		;
;		STZ	IRQTYP		;
;
		LDA	#010H
		STA	MANSEL
		LDA	#007H
		STA	SUBSEL
		LDA	#002H
		STA	WIND30
		LDA	#020H
		STA	SUBADF

		LDA	#00011000B
		TSB	HD420C
		M16

		LDX	<ENINDX
;--------------< colour set >-----------------
;		LDA	#07FFFH
		LDA	#0637DH			;gJ[
		STA	>DATACOL+(05H*2)	;
		STA	>MOTOCOL+(05H*2)	;
;		LDA	#07FF6H			;
		LDA	#04A75H			;eJ[
		STA	>DATACOL+(06H*2)	;
		STA	>MOTOCOL+(06H*2)	;
		LDA	#0000H			;֊sJ[
		STA	>DATACOL+(07H*2)	;
		STA	>MOTOCOL+(07H*2)	;

		LDA	SLMTRZM
		INC	A
		INC	A
		STA	SLMTRZM

		RTS
;
SLMEYE_SET	EQU	$
		LDA	#SLEYE		;(A) <-- enemy no.
		JSL	>ENINSR
		BCC	SLMEYE_SET0100	;fail: SLMEYE_SET0100

		TXA
		PHX
		TYX
		STA	<ENWRK0,X	;slime (main) routine index set
		STZ	<ENWRK4,X	;slime eyes relative pos. clear
		PLX

		TYA			;slime_eye routine index save
		STA	ENWRK8,X	;

		LDA	#00002H
		STA	ENCHPT,Y	;char. pat. no set

		LDA	ENXPSL,X
		STA	ENXPSL,Y	;X pos set

		LDA	ENYPSL,X
		SEC
		SBC	#00038H
		STA	ENYPSL,Y	;Y pos set

SLMEYE_SET0100	EQU	$

		RTS
;
BLKSLM_COLCHG	EQU	$
		I16
		LDX	SLMCOLX

		LDA	>COL_ADDRESS+SLIM_BLK_COL+0,X
		STA	>DATACOL+(05CH*2)
		LDA	>COL_ADDRESS+SLIM_BLK_COL+2,X
		STA	>DATACOL+(05DH*2)
		LDA	>COL_ADDRESS+SLIM_BLK_COL+4,X
		STA	>DATACOL+(05EH*2)
		LDA	>COL_ADDRESS+SLIM_BLK_COL+6,X
		STA	>DATACOL+(05FH*2)

		TXA			;next colour index calc.
		CLC			;
		ADC	#00008H		;
		STA	SLMCOLX		;
		I8

		RTS
;
SLIME_CHIP	EQU	$
		I16
		LDY	<ENWRK2,X		;ł͂ ?
		CPY	#SLIME_RMODE3		;
		BNE	SLIME_CHIP0100		;  no: SLIME_CHIP0100

		STZ	CCWORK7
		STZ	CCWORK8

		LDY	ENWRK8,X
		LDA	EXYPSL,Y	;KIRE Y_POS
		SEC
		SBC	SCCV1
		BRA	SLIME_CHIP0200

SLIME_CHIP0100	EQU	$
		PHX
		LDA	ENWRK8,X
		TAX

		LDA	<ENWRK4,X
		PHA
		AND	#000FFH
		CMP	#00080H
		BCC	SLIME_CHIP0150

		ORA	#0FF00H

SLIME_CHIP0150	EQU	$
		STA	CCWORK7

		PLA
		XBA
		AND	#000FFH
		CMP	#00080H
		BCC	SLIME_CHIP0180

		ORA	#0FF00H

SLIME_CHIP0180	EQU	$
		SEC
		SBC	#00038H
		STA	CCWORK8
		PLX

		LDA	#00000H		;KIRE Y_POS

SLIME_CHIP0200	EQU	$
		STA	R2		;KIRE Y_POS

		LDA	SLMKIRE			;(R3) <- Z^[onrD
		STA	R3

		LDA	ENDSXL,X	;foot x_pos
		CLC
		ADC	#00008H
		STA	CCWORK0

		LDA	ENDSYL,X	;foot y_pos
		STA	CCWORK1

		LDA	SLMSIZE2		;c{vZ
		STA	CCWORK3			;TATE BAIRITU

		STX	CCWORK9

		LDA	#00300H
		SEC
		SBC	<ENWRK0,X
;		LDA	<ENWRK0,X		;{vZ
;		ASL	A
;		TAX
;		LDA	>DIVBUF,X
		STA	R0
		I8
		LDY	SLMSIZE+1
		TYA
		STA	R6
		M_CHIP	MULTIPLY
		I16
		LDA	R0
		STA	CCWORK2

		LDA	SLMSPOI		;sin data pointer
		STA	CCWORK4

		LDA	SLMSXZM		;sin data x zoom
		STA	CCWORK5

		LDA	SLMSYST		;sin data y step
		STA	CCWORK6

		LDA	PLDSXL		;player display x_pos. set
		STA	CCWORKA

		LDA	PLDSYL		;player display y_pos. set
		STA	CCWORKB

		LDA	PLSITD		;player sit down flag set
		STA	CCWORKC

		I8
		M_CHIPR SLIMEST

SLIME_CHIP0280	EQU	$
		I16
		JSL	>M_DMA_BFST
		LWORD	HDMABUF		;to address set
		LWORD	HDMABF		;from address set
		WORD	0D2H*2*2	;umber of byte set
		MI8

		LDA	SLSTCPY		;̐؂[͎cĂ ?
		ORA	SLSTCPY+1	;
		BEQ	SLIME_CHIP0300	;  no: SLIME_CHIP0300

		LDA	#015H
		STA	MANSEL
		LDA	#002H
		STA	SUBSEL
		LDA	BGMODE
		AND	#0F7H
		BRA	SLIME_CHIP0400

SLIME_CHIP0300	EQU	$
		LDA	#016H
		STA	MANSEL
		LDA	#001H
		STA	SUBSEL
		LDA	BGMODE
		ORA	#008H

SLIME_CHIP0400	EQU	$
		STA	BGMODE

		LDA	#002H
		STA	WIND30
		LDA	#020H
		STA	SUBADF

;		LDA	#079H		;nR[Xp
;		STA	BGMODE		;
;
;		LDA	#010H
;;		LDA	#014H
;		STA	MANSEL
;
;		LDA	#005H
;;		LDA	#003H
;		STA	SUBSEL
;
;		LDA	#002H
;		STA	WIND30
;
;		LDA	#020H
;		STA	SUBADF

;		LDA	#071H		;ZՂp
;		STA	BGMODE		;
;
;		LDA	#013H
;		STA	MANSEL
;
;		LDA	#004H
;		STA	SUBSEL
;
;		LDA	#022H
;		STA	WIND30
;
;		LDA	#073H
;		STA	SUBADF

;;;;;		LDA	#002H		;kabe course deha iranai !!!
;;;;;		STA	NMITYP		;
;;;;;		STZ	IRQTYP		;

		LDA	#00011000B
		TSB	HD420C
		M16

		LDX	<ENINDX		;ENEMY INDEX FUKKATU
;-------------- color set -----------------------
		LDY	SLMDMGT			;_[W ?
		BEQ	SLIME_CHIP0480		;  no: SLIME_CHIP0480

		LDA	ENTIM2,X
		BNE	SLIME_CHIP04A0

		LDA	#00004H
		STA	ENTIM2,X

		LDA	>DATACOL+(05H*2)
		EOR	#0FFFFH
		STA	>DATACOL+(05H*2)
		STA	>MOTOCOL+(05H*2)

		LDA	>DATACOL+(06H*2)
		EOR	#0FFFFH

		BRA	SLIME_CHIP0490

SLIME_CHIP0480	EQU	$
;		LDA	#07FFFH
		LDA	#0637DH
		STA	>DATACOL+(05H*2)
		STA	>MOTOCOL+(05H*2)
;		LDA	#07FF6H
		LDA	#04A75H

SLIME_CHIP0490	EQU	$
		STA	>DATACOL+(06H*2)
		STA	>MOTOCOL+(06H*2)
		LDA	#0000H
		STA	>DATACOL+(07H*2)
		STA	>MOTOCOL+(07H*2)

SLIME_CHIP04A0	EQU	$
		LDA	CCWORK10		;̂x@onrD
		STA	ENWRKA,X		;

		LDY	<ENWRK2,X
		CPY	#SLIME_RMODE3
		BEQ	SLIME_CHIP0500

		LDA	ENWRK8,X
		TAY

		LDA	CCWORK7
		CLC
		ADC	ENXPSL,X
		STA	ENXPSL,Y

		LDA	CCWORK8
		CLC
		ADC	ENYPSL,X
		STA	ENYPSL,Y

SLIME_CHIP0500	EQU	$

		RTS
;
SLM_BGDTMK_DT1	EQU	$
		WORD	0FFFDH,0FFFEH
;
SLIME_BGDTMK	EQU	$
		LDY	<ENWRK2,X		;on ?
		CPY	#SLIME_RMODE3		;
		BNE	SLIME_BGDTMK0100	;  no: SLIME_BGDTMK0100

		STZ	ENCBFG,X		;af`FbNLZ

		RTS

SLIME_BGDTMK0100 EQU	$
		LDA	ENYSPD,X		;㏸Ă ?
		BMI	SLIME_BGDTMK0180	; yes: SLIME_BGDTMK0180

		LDA	SLMYLOW			;nʂɒ ?
		CMP	ENYPSL,X		;
		BPL	SLIME_BGDTMK0180	;  no: SLIME_BGDTMK0180

		STA	ENYPSL,X
		LDA	ENCBFG,X
		ORA	#00001
		STA	ENCBFG,X

SLIME_BGDTMK0180 EQU	$
		LDY	SLMHDFG			;Ă ?
		BNE	SLIME_BGDTMK0280	; yes: SLIME_BGDTMK0280

		LDY	#000
		LDA	ENYSPD,X
		BPL	SLIME_BGDTMK0200

		INY
		INY

SLIME_BGDTMK0200 EQU	$
		LDA	!SLM_BGDTMK_DT1,Y
		AND	ENCBFG,X
		STA	ENCBFG,X
		AND	#00003			; ?
		BEQ	SLIME_BGDTMK0400	;  no: SLIME_BGDTMK0400
		AND	#00002			; ?
		BEQ	SLIME_BGDTMK0300	;  no: SLIME_BGDTMK0300
;
		STZ	ENGPOW,X		;f@onvdqNA
		STZ	ENYSPD,X

		STZ	<ENWRK2,X

		LDA	ENWRKA,X		;̂x@onrDZ[u
		SEC
		SBC	#00004H
		STA	SLMHDYP			;

		INC	SLMHDFG			;Ղ擪tOZbg

SLIME_BGDTMK0280 EQU	$
		LDA	SLMHDYP
		CLC
		ADC	ENYPSL,X
		SEC
		SBC	ENWRKA,X
		BRA	SLIME_BGDTMK0380

SLIME_BGDTMK0300 EQU	$
		LDA	ENYPSL,X		;x@onrD␳
		AND	#0FFF0H			;
		ORA	#00001			;
						;
SLIME_BGDTMK0380 EQU	$			;
		STA	ENYPSL,X		;

SLIME_BGDTMK0400 EQU	$
		LDA	ENCBFG,X
		AND	#00030H
		LSR	A
		LSR	A
		ORA	ENCBFG,X
		STA	ENCBFG,X

SLIME_BGDTMK0800 EQU	$

		RTS
;
SLIME_OBJCK	EQU	$
		LDY	ECRSFG,X		;GƂ ?
		DEY				;
		BMI	SLIME_OBJCK0300		;  no: SLIME_OBJCK0300

		LDA	ENMODE,Y		;Ă ?
		CMP	#EMOVE			;
		BNE	SLIME_OBJCK0300		;  no: SLIME_OBJCK0300
		LDA	ENSHOT,Y		;VbgĂ ?
		BEQ	SLIME_OBJCK0300		;  no: SLIME_OBJCK0300
		LDA	ENWRK0,Y		;oEh ?
		CMP	#00002			;
		BPL	SLIME_OBJCK0300		; yes: SLIME_OBJCK0300

		LDA	SLMSIZE			;ԂႭȂ ?
		CMP	#04C00H			;
		BCC	SLIME_OBJCK0100		; yes: SLIME_OBJCK0100

		LDA	<ENWRK2,X		;XEBO ?
		CMP	#SLIME_RMODE4		;
		BEQ	SLIME_OBJCK0100		; yes: SLIME_OBJCK0100
		CMP	#SLIME_RMODE6
		BEQ	SLIME_OBJCK0100		; yes: SLIME_OBJCK0100
		CMP	#SLIME_RMODE7
		BNE	SLIME_OBJCK0200		; yes: SLIME_OBJCK0200

SLIME_OBJCK0100	EQU	$
		TYX
		JSL	>SHOT_EN_KILL
		RTS

SLIME_OBJCK0200	EQU	$
		STZ	ENXSPD,X
		STZ	ENXPOW,X
		LDA	#00040H
		STA	ENTIM0,X

		LDA	#PDEM
		STA	PLMODE
		LDA	#SLIME_RMODE6
		STA	<ENWRK2,X
		LDA	#0FFFFH
		STA	ENTIM3,X

SLIME_OBJCK0300 EQU	$

		RTS

SLIME_OBJCK0400 EQU	$
		LDA	#00020H			;_[W^C}[Zbg
		STA	SLMDMGT			;

		LDA	ENTIM1,X		;`FbNbN ?
		BNE	SLIME_OBJCK0300		; yes: SLIME_OBJCK0300

		LDA	ENXPSL,Y		;Ă̂w@onrDZ[u
		STA	<EWORK0			;
		LDA	ENYPSL,Y		;	h	@ x@onrDZ[u
		STA	<EWORK2			;
		LDA	ENGPOW,Y
		STA	<EWORK4

		LDA	#0003BH			;mrn
		JSL	>SOUND_3_ON

		LDA	#SLMSB		;(A) <-- enemy no.
		JSL	>EXINSR

		LDA	<EWORK0
		STA	EXXPSL,Y	;X pos set
		LDA	<EWORK2
		STA	EXYPSL,Y	;Y pos set
		LDA	#0FFFFH
		STA	EXTIM0,Y
		M8
		LDA	#0FFH
		STA	EXWTSP,Y
		M16

		LDA	<RANDM0
		PHA
		AND	#001FFH
		SEC
		SBC	#00100H
		STA	EXXSPD,Y	;X speed set
		BMI	SLIME_OBJCK0500

		LDA	#00002
		STA	EXMUKI,Y

SLIME_OBJCK0500 EQU	$
		PLA
		XBA
		AND	#003FFH
		EOR	#0FFFFH
		INC	A
		STA	EXYSPD,Y	;Y speed set

		LDA	#00014H			;mrn
		JSL	>SOUND_3_ON
;;;;;;;;		LDA	#00020H			;mrn
;;;;;;;;		STA	SOUND0

		LDY	SLMDMGF
		BNE	SLIME_OBJCK0700

		INC	SLMDMGF			;Ղ_[WtOZbg
		LDY	#002			;hhtOZbg
		STY	SLMNIGE			;

		LDY	<ENWRK2,X		;Ղ@ړ ?
		CPY	#SLIME_RMODE2		;
		BNE	SLIME_OBJCK0600		;  no: SLIME_OBJCK0600

		LDA	#00003H			;Ղh񐔃Zbg
		STA	SLMYURE			;
		STZ	ENXSPD,X		;x idou stop
		STZ	ENXPOW,X		;

SLIME_OBJCK0600 EQU	$
		LDA	ENXSPD,X
		EOR	#0FFFFH
		INC	A
		STA	ENXSPD,X
		LDA	ENXMAX,X
		EOR	#0FFFFH
		INC	A
		STA	ENXMAX,X

SLIME_OBJCK0700 EQU	$
		LDA	SLMSIZE
		SEC
		SBC	#00100H
		CMP	#04C00H
		BCS	SLIME_OBJCK0800

		LDA	#04BFFH

SLIME_OBJCK0800 EQU	$
		STA	SLMSIZE
		LDY	#002H
		LDA	<EWORK4			;l`wȂ ?
		CMP	#00040H			;
		BPL	SLIME_OBJCK0900		;  no: SLIME_OBJCK0900

		LDY	#001

SLIME_OBJCK0900 EQU	$
		TYA				;`FbNbN^C}[Zbg
		STA	ENTIM1,X		;

SLIME_PLCHK0001 EQU	$

		RTS
;
SLIME_PLCHK_DT	EQU	$
		WORD	00080H,0FF80H
;
SLIME_PLCHK	EQU	$
		LDA	CCWORKD			;vC[̋߂ɂ ?
		BEQ	SLIME_PLCHK0001		;  no: SLIME_PLCHK0001

		BIT	#00001H			;vC[ɓ܂Ă ?
		BEQ	SLIME_PLCHK0050		;  no: SLIME_PLCHK0050

		BIT	#0000EH			;vC[̑`FbNꂽ ?
		BEQ	SLIME_PLCHK0280		; yes: SLIME_PLCHK0280

SLIME_PLCHK0050 EQU	$
		LDY	EPXMUK,X
		LDA	!SLIME_PLCHK_DT,Y
		SEC
		SBC	EPWIDX,X
		CMP	#08000H
		ROR	A
		STA	<EWORK0

		LDY	<ENWRK2,X
		CPY	#SLIME_RMODE6
		BEQ	SLIME_PLCHK0280
		CPY	#SLIME_RMODE7
		BEQ	SLIME_PLCHK0280

		LDA	PLXSPD			;vC[̂wXs[ho߂Ă ?
		PHA				;
		CLC				;
		ADC	#00400H			;
		CMP	#00800H			;
		BCS	SLIME_PLCHK0250		; yes: SLIME_PLCHK0250

		PLA				;vC[̂wXs[h␳
		SEC				;
		SBC	<EWORK0			;
		STA	PLXSPD			;
		STA	PLMVSP			;
		BRA	SLIME_PLCHK0280

SLIME_PLCHK0250 EQU	$
		PLA

SLIME_PLCHK0280 EQU	$
		LDA	CCWORKD			;vC[ɓ܂Ă ?
		BIT	#00001H			;
		BEQ	SLIME_PLCHK0400		;  no: SLIME_PLCHK0400

		LDA	PLYSPD			;vC[㏸ ?
		BMI	SLIME_PLCHK0400		; yes: SLIME_PLCHK0400

SLIME_PLCHK0290 EQU	$
		LSR	A			;vC[̂xXs[h␳
		STA	PLYSPD

SLIME_PLCHK0400 EQU	$
		LDY	EPYMUK,X
		LDA	!SLIME_PLCHK_DT,Y
		SEC
		SBC	EPWIDY,X
		STA	<EWORK0

		LDA	PLYSPD
		PHA
		CLC
		ADC	#00200H
		CMP	#00400H
		BCS	SLIME_PLCHK0500

		PLA				;㏸n߂ ?
		SEC				;
		SBC	<EWORK0			;
		SEC				;
		SBC	#00080H			;
		STA	PLYSPD			;
		BPL	SLIME_PLCHK0900		;  no: SLIME_PLCHK0900

		LDA	#P006
		STA	PLJUMP

		RTS

SLIME_PLCHK0500 EQU	$
		PLA

SLIME_PLCHK0900 EQU	$

		RTS
;
;
SLIME_MOV	EQU	$
		LDY	SLMHDFG			;VɂĂ ?
		BEQ	SLIME_MOV100		;  no: SLIME_MOV100

		LDA	#00002
		BRA	SLIME_MOV130

SLIME_MOV100	EQU	$
		LDA	ENCBFG,X		;nʁ@@VɂĂ ?
		AND	#00003H			;
		BEQ	SLIME_MOV500		;  no: SLIME_MOV500

		AND	#00002H			;ڒntOZbg

SLIME_MOV130	EQU	$
		STA	ENWRKC,X		;

		LDY	SLMFTFG			;O璅nĂ ?
		BNE	SLIME_MOV200		; yes: SLIME_MOV200

		INC	SLMFTFG			;ntOZbg

		STZ	ENXSPD,X		;w@roddcNA
		STZ	ENXPOW,X		;w@onvdqNA

		LDA	ENWRK6,X		;SHITA KARA ?
		BPL	SLIME_MOV150		;  no: SLIME_MOV150

		EOR	#0FFFFH			;{Xs[h]
		INC	A			;

SLIME_MOV150	EQU	$
		PHA
		EOR	#0FFFFH
		INC	A
		STA	ENWRK6,X

		PLA
		PHA
		LSR	A
		LSR	A
		STA	<EWORKE
		PLA
		SEC
		SBC	<EWORKE
		STA	SLMZMAX			;{Xs[h̏Zbg
		STA	<ENWRK4,X		;{Xs[h~bgZbg
		EOR	#0FFFFH			;{Xs[h̉Zbg
		INC	A			;
		STA	SLMZMIN			;

SLIME_MOV200	EQU	$
		JSR	SLMSPD_CHG

		LDA	ENWRK6,X
		BPL	SLIME_MOV550

		EOR	#0FFFFH
		INC	A

		BRA	SLIME_MOV550

SLIME_MOV500	EQU	$
		STZ	ENWRKC,X		;ڒntONA

		STZ	SLMFTFG			;ntONA

		LDA	ENYSPD,X		;{Xs[hZbg
		STA	ENWRK6,X		;
		BPL	SLIME_MOV550

		EOR	#0FFFFH
		INC	A

SLIME_MOV550	EQU	$
		LSR	A			;{vZ
		LSR	A			;
		LSR	A			;
		CLC				;
		ADC	#000E0H			;
						;
SLIME_MOV530	EQU	$			;
		STA	<ENWRK0,X		;

		RTS
;
;SLM_YSPD_CMP	EQU	$
;		WORD	00140H,00120H,000A0H
SLIME_ST_XMAX	EQU	$
		WORD	000C0H,0FF40H
;
SLMSPD_CHG	EQU	$
		LDY	<ENWRK2,X		;Ղ ?
		CPY	#SLIME_RMODE2		;
		BEQ	SLMSPD_CHG0002		; yes: SLMSPD_CHG0002
		CPY	#SLIME_RMODE5		;Wv ?
		BNE	SLMSPD_CHG0005		;  no: SLMSPD_CHG0005

		LDA	#04000H
		BRA	SLMSPD_CHG0008

SLMSPD_CHG0002	EQU	$
		LDA	#00A00H
		BRA	SLMSPD_CHG0008

SLMSPD_CHG0005	EQU	$
		LDY	SLMSIZE+1
		TYA
		CLC				;
		ADC	#02000H			;

SLMSPD_CHG0008	EQU	$
		STA	<EWORK0

		LDA	ENWRK6,X		;Ղ{vZ
		BPL	SLMSPD_CHG0010		;
						;
		EOR	#0FFFFH			;
		INC	A			;
						;
SLMSPD_CHG0010	EQU	$			;
		CLC				;
		ADC	<EWORK0			;
		ASL	A			;
		AND	#0FF00H			;
		XBA				;
						;
SLMSPD_CHG0015	EQU	$			;
		STA	<EWORKE			;

		LDA	<ENWRK4,X		;{Xs[hE菬 ?
		CMP	ENWRK6,X		;
		BMI	SLMSPD_CHG0100		;  no: SLMSPD_CHG0100

		CMP	SLMZMAX			;{Xs[h͏z ?
		BEQ	SLMSPD_CHG0050		; yes: SLMSPD_CHG0050

		LDY	<ENWRK2,X		;Ղ ?
		CPY	#SLIME_RMODE2		;
		BEQ	SLMSPD_CHG0040		; yes: SLMSPD_CHG0040

		LDA	SLMZMIN			;̔{Xs[h̉vZ
		BEQ	SLMSPD_CHG0030		;
						;
		SEC				;
		ROR	A			;
		CMP	#0FFE0H			;
		BCC	SLMSPD_CHG0030		;
						;
SLMSPD_CHG0020	EQU	$			;
		LDA	#00000H			;
						;
SLMSPD_CHG0030	EQU	$			;
		STA	SLMZMIN			;

		BRA	SLMSPD_CHG0048

SLMSPD_CHG0040	EQU	$
		INC	SLMYURE
		LDA	SLMYURE
		CMP	#00004H
		BNE	SLMSPD_CHG0048

		DEC	<ENWRK2,X		;routine mode index dec.

		RTS

SLMSPD_CHG0048	EQU	$
		LDA	SLMZMAX			;{Xs[h~bgɕύX
		STA	<ENWRK4,X		;

SLMSPD_CHG0050	EQU	$
		LDA	ENWRK6,X		;{Xs[hvZ
		CLC				;
		ADC	<EWORKE			;

		JMP	SLMSPD_CHG0200

SLMSPD_CHG0100	EQU	$
		CMP	SLMZMAX			;{Xs[h~bg͏ ?
		BEQ	SLMSPD_CHG0110
		JMP	SLMSPD_CHG0150		;  no: SLMSPD_CHG0150

SLMSPD_CHG0110	EQU	$
		LDY	<ENWRK2,X		;Ղ ?
		CPY	#SLIME_RMODE2		;
		BEQ	SLMSPD_CHG0135		; yes: SLMSPD_CHG0135

		LDA	SLMZMAX			;̔{Xs[h̏vZ
		BEQ	SLMSPD_CHG0135		;
						;
		LSR	A			;
		CMP	#00020H			;
		BCS	SLMSPD_CHG0130		;
						;
SLMSPD_CHG0120	EQU	$			;
		LDA	#00000H			;
						;
SLMSPD_CHG0130	EQU	$			;
		STA	SLMZMAX			;

SLMSPD_CHG0138	EQU	$			;
;		LDA	#00200H			;
		LDA	#001D0H			;
		BRA	SLMSPD_CHG013A		;
						;
SLMSPD_CHG0135	EQU	$
		LDA	#00600H			;
						;
SLMSPD_CHG013A	EQU	$			;
		STA	<EWORK0			;

		LDA	ENWRK6,X		;Ղ悽ĂɐLтĂ ?
		BMI	SLMSPD_CHG0140		;  no: SLMSPD_CHG0140

		LDY	ENWRKC,X		;Ă ?
		BNE	SLMSPD_CHG013B		; yes: SLMSPD_CHG013B

		CMP	<EWORK0			;
		BCC	SLMSPD_CHG0140		;  no: SLMSPD_CHG0140

		EOR	#0FFFFH			;x@roddcZbg
		INC	A			;

SLMSPD_CHG013B	EQU	$
		STA	R0
		LDA	#00100H
		STA	R6
		M_CHIP	MULTIPLY
		LDX	<ENINDX
		LDA	R0
		STA	ENYSPD,X		;

		STZ	SLMHDFG			;tONA

		LDA	#00010H			;f@onvdqZbg
		STA	ENGPOW,X		;

		LDY	SLMSTART		;on ?
		BNE	SLMSPD_CHG013C		; yes: SLMSPD_CHG013C

		LDA	#00010H			;w@onvdqZbg
		STA	ENXPOW,X		;

		RTS

SLMSPD_CHG013C	EQU	$
		LDA	#00010H
		STA	ENXPOW,X

		LDY	EPXMUK,X
		LDA	!SLIME_ST_XMAX,Y
		STA	ENXMAX,X

SLMSPD_CHG0140	EQU	$
		LDA	SLMZMIN			;{Xs[h~bgɕύX
		STA	<ENWRK4,X		;

SLMSPD_CHG0150	EQU	$
		LDA	ENWRK6,X		;{Xs[hvZ
		SEC				;
		SBC	<EWORKE			;
						;
SLMSPD_CHG0200	EQU	$			;
		STA	ENWRK6,X		;

		LDA	SLMZMAX			;ՂWvI ?
		ORA	SLMZMIN			;
		BNE	SLMSPD_CHG0300		; no:  SLMSPD_CHG0300

		LDY	#SLIME_RMODE1
		STY	<ENWRK2,X		;routine mode index set

SLMSPD_CHG0300	EQU	$

		RTS
;
;************************************************************************
;*		initial ( Ղ̖ڂ )				*
;************************************************************************
SLEYEIN		EQU	$			;-- sleyein --
		RTL
;
;************************************************************************
;*		move	( Ղ̖ڂ )				*
;************************************************************************
;		ENWRK0	SLIME ROUTINE INDEX ( ENEMY INDEX )
;		ENWRK2	MABATAKI KAISUU
;		ENWRK4	EYES POS.
;		ENWRK6
;		ENWRK8
;
SLEYEMV		EQU	$			;-- sleyemv --
		JSL	>ENMDCK		;mode check

		JSR	EYE_SEARCH

		LDA	ENTIM0,X	;char. pat change ?
		BNE	SLEYEMV0900	;  no; SLEYEMV0800

		LDA	<ENWRK2,X	;mabataki nashi ?
		BEQ	SLEYEMV0800	; yes: SLEYEMV0800

		BIT	#00001H
		BNE	SLEYEMV0100

		DEC	ENCHPT,X	;char. pat. no. dec.
		LDA	ENCHPT,X	;
		BNE	SLEYEMV0700	;
		BRA	SLEYEMV0200	;

SLEYEMV0100	EQU	$
		INC	ENCHPT,X	;char. pat. no. inc.
		LDA	ENCHPT,X	;
		CMP	#00002H		;
		BNE	SLEYEMV0700	;

SLEYEMV0200	EQU	$
		DEC	<ENWRK2,X	;mabataki counter dec.

SLEYEMV0700	EQU	$
		LDA	#00004H		;mabataki char. pat. cahnge timer set
		STA	ENTIM0,X	;
		BRA	SLEYEMV0900

SLEYEMV0800	EQU	$
		LDA	<RANDM0		;mabataki suru ?
		BIT	#0001FH		;
		BNE	SLEYEMV0900	;  no: SLEYEMV0900

		LDA	#00004H		;mabataki counter set
		STA	<ENWRK2,X	;

SLEYEMV0900	EQU	$

		INC	<ENCONT,X

		RTL
;
;		EWORK0	ANGLE
;		EWORK2	X POS
;		EWORK4	Y POS
;		EWORK6	EPWIDX
;		EWORK8	EPWIDY
;		EWORKA
;		EWORKC
;		EWORKE	EYES POS.
;
EYE_SEARCH	EQU	$
		LDX	<ENINDX

		LDA	<ENWRK4,X	;eyes pos. set
		STA	<EWORKE		;

		LDA	EPWIDX,X		;]pvZ
		STA	R1			;
		LDA	EPWIDY,X		;
		STA	R2			;
						;
		M_CHIP	M_RAD_GET		;
						;
		I16
		LDA	R1
		JSR	SEYE_POS

		M8

		LDA	<EWORKE		;X HOSEI PLAS ?
		CMP	<EWORK2		;X HOSEI : X MOKUHYOU ?
		BEQ	SLIME_EYE0700	; yes: SLIME_EYE0700

		LDA	<EWORKE		;X HOSEI PLAS ?
		BMI	SLIME_EYE0650	; no:  SLIME_EYE0650

		LDA	<EWORK2		;X MOKUHYOU PLAS
		BMI	SLIME_EYE0680	; no:  SLIME_EYE0680
		CMP	<EWORKE
		BCC	SLIME_EYE0680

SLIME_EYE0600	EQU	$
		INC	<EWORKE		;x_pos inc.
		BRA	SLIME_EYE0700

SLIME_EYE0650	EQU	$
		LDA	<EWORK2
		BPL	SLIME_EYE0600
		CMP	<EWORKE
		BCS	SLIME_EYE0600

SLIME_EYE0680	EQU	$
		DEC	<EWORKE		;x_pos dec.

SLIME_EYE0700	EQU	$
		LDA	<EWORKF		;Y HOSEI PLAS ?
		CMP	<EWORK4		;Y HOSEI : Y MOKUHYOU ?
		BEQ	SLIME_EYE0800	; yes: SLIME_EYE0800

		LDA	<EWORKF		;Y HOSEI PLAS ?
		BMI	SLIME_EYE0750	; no:  SLIME_EYE0750

		LDA	<EWORK4		;Y MOKUHYOU PLAS
		BMI	SLIME_EYE0780	; no:  SLIME_EYE0780
		CMP	<EWORKF
		BCC	SLIME_EYE0780

SLIME_EYE0710	EQU	$
		INC	<EWORKF		;y_pos inc.
		BRA	SLIME_EYE0800

SLIME_EYE0750	EQU	$
		LDA	<EWORK4
		BEQ	SLIME_EYE0800	; yes: SLIME_EYE0800
		BPL	SLIME_EYE0710
		CMP	<EWORKF
		BCS	SLIME_EYE0710

SLIME_EYE0780	EQU	$
		DEC	<EWORKF		;y_pos dec.

SLIME_EYE0800	EQU	$
		M16
		LDA	<EWORKE		;eyes pos. set
		STA	<ENWRK4,X	;

		RTS
;
SEYE_POS	EQU	$
		I16
		ASL	A
		TAX
		PHX

		LDA	>COS,X
		M8			;SET_DATA GET & SET
		STA	211BH		;
		XBA			;
		STA	211BH		;
		LDA	#010H		; hankei
		STA	211CH		;

		LDA	2135H
		STA	<EWORK2
		BPL	SEYE_POS0050

		LDA	#0FFH
		BRA	SEYE_POS0080

SEYE_POS0050	EQU	$
		LDA	#000H

SEYE_POS0080	EQU	$
		STA	<EWORK3		;x pos. set

		M16

		PLX
		LDA	>SIN,X
		M8			;SET_DATA GET & SET
		STA	211BH		;
		XBA			;
		STA	211BH		;
		LDA	#010H		; hankei
		STA	211CH		;

		LDA	2135H
		STA	<EWORK4
		BPL	SEYE_POS0200

		LDA	#0FFH
		BRA	SEYE_POS0300

SEYE_POS0200	EQU	$
		LDA	#000H

SEYE_POS0300	EQU	$
		STA	<EWORK5		;y pos. set

		M16

		I8
		LDX	<ENINDX

		RTS
;
;************************************************************************
;*		initial ( тՂ )					*
;************************************************************************
SSLIMIN		EQU	$		;-- sslimin --
		LDY	#SSLIM_RMODE5
		STY	<ENWRK2,X

		RTL
;
;************************************************************************
;*		move	( тՂ )					*
;************************************************************************
;		ENWRK0	DvC[`FbNbNtO
;		ENWRK2	ROUTINE MODE INDEX
;		ENWRK4
;		ENWRK6
;		ENWRK8
;		ENWRKA	ăZbg`FbN
;		ENWRKC	ăZbg`FbN
;
;		ENTIM0	Xgbv^C}[
;		ENTIM1	Lp^[`FW^C}[
;
SSLIM_SUB	EQU	$
SSLIM_0		EQU	$
		WORD	SSLIM_SUB0		;ׂ炾炟`
SSLIM_1		EQU	$
		WORD	SSLIM_SUB1		;nPODOO
SSLIM_2		EQU	$
		WORD	SSLIM_SUB2		;EH[N
SSLIM_3		EQU	$
		WORD	SSLIM_SUB3		;Ԃ
SSLIM_4		EQU	$
		WORD	SSLIM_SUB4		;e
SSLIM_5		EQU	$
		WORD	SSLIM_SUB5		;CjV
SSLIM_60	EQU	$
		WORD	SSLIM_SUB60		;тՂ̃CjVfiׂ炾炟`j
SSLIM_61	EQU	$
		WORD	SSLIM_SUB61		;тՂ̃CjVfinPODOOj
SSLIM_62	EQU	$
		WORD	SSLIM_SUB62		;тՂ̃CjVfiJbN҂Wvj
SSLIM_63	EQU	$
		WORD	SSLIM_SUB63		;тՂ̃CjVfiV`FbNnj
SSLIM_64	EQU	$
		WORD	SSLIM_SUB64		;тՂ̃CjVfi҂j
;
;ys_chip3  PONTA_BOMB ɒӁII
;
SSLIM_RMODE0	EQU	(SSLIM_0-SSLIM_0)/2
SSLIM_RMODE1	EQU	(SSLIM_1-SSLIM_0)/2
SSLIM_RMODE2	EQU	(SSLIM_2-SSLIM_0)/2
SSLIM_RMODE3	EQU	(SSLIM_3-SSLIM_0)/2
SSLIM_RMODE4	EQU	(SSLIM_4-SSLIM_0)/2
SSLIM_RMODE5	EQU	(SSLIM_5-SSLIM_0)/2
SSLIM_RMODE60	EQU	(SSLIM_60-SSLIM_0)/2
SSLIM_RMODE61	EQU	(SSLIM_61-SSLIM_0)/2
SSLIM_RMODE62	EQU	(SSLIM_62-SSLIM_0)/2
SSLIM_RMODE63	EQU	(SSLIM_63-SSLIM_0)/2
SSLIM_RMODE64	EQU	(SSLIM_64-SSLIM_0)/2
;
SSLIMMV		EQU	$			;-- sslimmv --
		LDA	ENMODE,X
		CMP	#EMOVE
		BNE	SSLIMMV0100
		LDY	ENSHOT,X
		BEQ	SSLIMMV0100

		LDA	#00002
		STA	ENYUSN,X
		STZ	ENCHPT,X
		LDA	#0FFFFH
		STA	ENWRKA,X
		STA	ENWRKC,X

SSLIMMV0100	EQU	$
		JSL	>ENMDCK			;mode check

		TXY
		LDA	<ENWRK2,X
		ASL	A
		TAX
		JSR	(SSLIM_SUB,X)

		JSR	SSLIM_PLCHK

		RTL
;
SSLIM_PLCHK	EQU	$
		LDA	<ENWRK0,X		;IuWF`FbNbN ?
		BNE	SSLIM_PLCHK0500		; yes: SSLIM_PLCHK0500

		LDY	ECRSFG,X		;vC[ɂ ?
		BPL	SSLIM_PLCHK0300		;  no: SSLIM_PLCHK0300

		LDY	<ENWRK2,X		;ׂĂ ?
		CPY	#SSLIM_RMODE3		;
		BEQ	SSLIM_PLCHK0500		; yes: SSLIM_PLCHK0500
		CPY	#SSLIM_RMODE4		;
		BEQ	SSLIM_PLCHK0500		;

		LDA	EPWIDY,X		;vC[炠 ?
		SEC				;
		SBC	PWIDEY			;
		SEC				;
		SBC	EWIDEY,X		;
		CMP	#0FFF8H			;
		BCS	SSLIM_PLCHK0100		;  no: SSLIM_PLCHK0100

SSLIM_PLCHK0080	EQU	$
		JSL	>PLFLST

		RTS

SSLIM_PLCHK0100 EQU	$
		LDY	PLJUMP			;vC[Wv ?
		BEQ	SSLIM_PLCHK0080		;  no: SSLIM_PLCHK0080

		LDA	ENCBFG,X		;nʂɒĂ ?
		AND	#00001			;
		BEQ	SSLIM_PLCHK0500		;  no: SSLIM_PLCHK0500

		LDA	#00020H
		STA	PLFLSH

		LDA	P_KEY_NAGE
		ORA	P_KEY_MNAG
		STA	<EWORK0
		AND	KEYC1L
		STA	P_KEYC1L
		LDA	KEYC2L
		AND	<EWORK0
		STA	P_KEYC2L

		STZ	PLDOSN
		LDA	#PDEM
		STA	PLMODE

		LDA	#0111110001100000B	;HȂAGȂ
		STA	ENMOD0,X		;

		STZ	<ENCONT,X
		STZ	ENXSPD,X
		LDA	#00004
		STA	ENTIM1,X
		STA	ENCHPT,X

		LDY	#SSLIM_RMODE3
		STY	<ENWRK2,X

		RTS

SSLIM_PLCHK0300 EQU	$
		JSL	>EPCRCK

SSLIM_PLCHK0500 EQU	$

		RTS
;
SSLIM_S0_CHPT	EQU	$-1
		HEX	08,09,00,01
SSLIM_S0_TIM1	EQU	$-1
		HEX	10,06,05,04
;
SSLIM_SUB0	EQU	$
SSLIM_SUB60	EQU	$
		TYX

		LDA	ENTIM1,X
		BNE	SSLIM_SUB0800

		INC	<ENCONT,X
		LDY	<ENCONT,X
		CPY	#005
		BNE	SSLIM_SUB0500

		LDA	#00040H
		STA	ENGPOW,X
		STZ	<ENCONT,X
		STZ	ENCHPT,X
		INC	<ENWRK2,X

		RTS

SSLIM_SUB0500	EQU	$
		LDA	!SSLIM_S0_CHPT,Y
		AND	#000FFH
		STA	ENCHPT,X
		LDA	!SSLIM_S0_TIM1,Y
		AND	#000FFH
		STA	ENTIM1,X

SSLIM_SUB0800	EQU	$

		RTS
;
SSLIM_S1_CHPT	EQU	$-1
		HEX	01,04,05,06,01,00,02,00,01
SSLIM_S1_TIM1	EQU	$-1
		HEX	02,02,02,02,02,02,04,02,30
;
SSLIM_SUB1	EQU	$
SSLIM_SUB61	EQU	$
		TYX

		LDA	ENCBFG,X		;nʂɒ ?
		AND	#00001			;
		BEQ	SSLIM_SUB1800		;  no: SSLIM_SUB1800

		LDA	ENTIM1,X		;Lp^[`FW ?
		BNE	SSLIM_SUB1800		;  no: SSLIM_SUB1800

		INC	<ENCONT,X
		LDY	<ENCONT,X
		LDA	!SSLIM_S1_CHPT,Y
		AND	#000FFH
		STA	ENCHPT,X
		LDA	!SSLIM_S1_TIM1,Y
		AND	#000FFH
		STA	ENTIM1,X
		CPY	#009			;np^[I ?
		BMI	SSLIM_SUB1800		;  no: SSLIM_SUB1800

		LDA	ENTIM1,X
		STA	ENTIM0,X
		LDY	EPXMUK,X
		TYA
		STA	ENMUKI,X

		INC	<ENWRK2,X

		LDY	<ENWRK2,X		;тՂ̃f ?
		CPY	#SSLIM_RMODE61+1	;
		BNE	SSLIM_SUB1800		;  no: SSLIM_SUB1800

		LDA	#00007H
		STA	<ENCONT,X
		INC	BOSS_START

SSLIM_SUB1800	EQU	$

		RTS
;
SSLIM_XSPD	EQU	$
		WORD	0FFC0H,00040H
;
SSLIM_SUB2	EQU	$
		TYX

		LDA	ENTIM0,X		;Xgbv ?
		BNE	SSLIM_SUB2800		; yes: SSLIM_SUB2800

		STZ	<ENWRK0,X		;DvC[`FbNbNtONA

		LDY	ENMUKI,X
		LDA	!SSLIM_XSPD,Y
		STA	ENXSPD,X

		LDA	ENTIM1,X
		BNE	SSLIM_SUB2800

		LDA	#00004H
		STA	ENTIM1,X

		LDA	ENCHPT,X
		INC	A
		AND	#00003
		STA	ENCHPT,X

SSLIM_SUB2800	EQU	$

		RTS
;
SSLIM_PLYREV	EQU	$
;ENCHPT =		 [4]	[5]    [6]
		WORD	0001AH,00018H,00014H
;
SSLIM_SUB3	EQU	$
		TYX

		LDA	ENTIM1,X		;Lp^[`FW ?
		BNE	SSLIM_SUB3800		;  no: SSLIM_SUB3800

		INC	<ENCONT,X
		INC	<ENCONT,X
		LDY	<ENCONT,X		;ԂI ?
		CPY	#006			;
		BMI	SSLIM_SUB3500		;  no: SSLIM_SUB3500

		LDA	#00003
		STA	ENTIM0,X

		LDA	#SSLMB
		JSL	>EXINSR
		LDA	ECENTX,X
		STA	EXXPSL,Y
		LDA	ECENTY,X
		STA	EXYPSL,Y
		LDA	#00005
		STA	EXCHPT,Y
		LDA	#00002
		STA	EXTIM0,Y
		M8
		LDA	#0FFH
		STA	EXWTSP,Y
		M16
		INC	<ENWRK2,X

		RTS

SSLIM_SUB3500	EQU	$
		LDA	#00004
		STA	ENTIM1,X
		INC	ENCHPT,X

SSLIM_SUB3800	EQU	$
		LDA	PLBGCR
		AND	#0000000000000111B
		BNE	SSLIM_SUB3900

		LDY	<ENCONT,X
		LDA	ENYPSL,X
		SEC
		SBC	!SSLIM_PLYREV,Y
		SEC
		SBC	PLFTLN
		STA	PLYPSL
		STZ	PLYSPD
		INC	ONLFFG

SSLIM_SUB3900	EQU	$

		RTS
;
SSLIM_SUB4	EQU	$
		TYX

		LDA	ENTIM0,X
		BNE	SSLIM_SUB4100

		LDA	#0003BH			;mrn
		JSL	>SOUND_3_ON

		LDA	#PMOV
		STA	PLMODE
		STZ	P_KEYC1L
		STZ	P_KEYC2L

		JSL	>ENCLEAR_NORETN

		PLA
		RTL

SSLIM_SUB4100	EQU	$
		LDA	ECENTX,X
		STA	R1
		LDA	ECENTY,X
		STA	R2
		LDA	#00040H			;a
		STA	R10			;
		LDA	#00200H			;XSPD
		STA	CCWORK0
		LDA	#0FE00H			;YSPD
		STA	CCWORK1

		M_CHIP	PONTA_BOMB

		LDX	<ENINDX

		RTS
;
SSLIM_SUB5	EQU	$
		TYX

		LDA	ENWRKA,X
		CMP	ENWRKC,X
		BNE	SSLIM_SUB5100

		INC	A
		BNE	SSLIM_SUB5100

		INC	A		;[ LDA	#00001 ]
		STA	ENCHPT,X
		INC	A		;[ LDA	#00002 ]
		STA	ENYUSN,X
		STA	<ENWRK2,X
		LDA	#00030H
		STA	ENTIM0,X
		LDY	EPXMUK,X
		TYA
		STA	ENMUKI,X
		RTS

SSLIM_SUB5100	EQU	$
		LDA	EPWIDX,X
		CLC
		ADC	#00030H
		CMP	#00060H
		BCS	SSLIM_SUB5800

;		LDA	ENYPSL,X		;oJnʒu
;		CLC				;
;		ADC	#00010H			;
;		STA	ENYPSL,X		;

		LDA	#0FFFFH
		STA	ENWRKA,X
		STA	ENWRKC,X

		LDA	#00007
		STA	ENCHPT,X
		INC	A		[ LDA	#00008 ]
		STA	ENTIM1,X

		LDA	#00002
		STA	ENYUSN,X

		STZ	<ENWRK2,X

SSLIM_SUB5800	EQU	$

		RTS
;
SSLIM_S62_CHPT	EQU	$
		HEX	04,05,06,05,04,00,02
;
SSLIM_SUB62	EQU	$
		TYX

		LDA	BOSS_START		;JbNޏꂵ ?
		BPL	SSLIM_SUB62800		;  no: SSLIM_SUB62800

		LDA	ENTIM1,X
		BNE	SSLIM_SUB62800

		DEC	<ENCONT,X		;Wv ?
		BPL	SSLIM_SUB62300		;  no: SSLIM_SUB62300

		LDA	#00002
		STA	ENCHPT,X
		STA	<ENCONT,X
		LDA	#0FC00H
		STA	ENYSPD,X
		STZ	ENGPOW,X
		STZ	ENCBFG,X
		INC	<ENWRK2,X
		RTS

SSLIM_SUB62300	EQU	$
		LDY	<ENCONT,X
		LDA	!SSLIM_S62_CHPT,Y
		AND	#000FFH
		STA	ENCHPT,X
		LDA	#00002H
		STA	ENTIM1,X

SSLIM_SUB62800	EQU	$

		RTS
;
SSLIM_S63_CHPT	EQU	$
		HEX	07,08
SSLIM_S63_TIM1	EQU	$
		HEX	08,10
;
SSLIM_SUB63	EQU	$
		TYX

		LDA	ENYSPD,X
		BEQ	SSLIM_SUB63300

		LDA	ENCBFG,X		; ?
		AND	#00002			;
		BEQ	SSLIM_SUB63800		;  no: SSLIM_SUB63800

		LDA	ENYPSL,X
		CLC
		ADC	#00008H
		AND	#0FFF0H
		STA	ENYPSL,X
		STZ	ENYSPD,X
		RTS

SSLIM_SUB63300	EQU	$
		LDA	ENTIM1,X
		BNE	SSLIM_SUB63800

		DEC	<ENCONT,X
		BPL	SSLIM_SUB63500

		STZ	BOSS_START
		LDA	#00040H
		STA	ENTIM0,X
		LDA	#000FFH
		STA	ENYUSN,X
		INC	<ENWRK2,X
		RTS

SSLIM_SUB63500	EQU	$
		LDY	<ENCONT,X
		LDA	!SSLIM_S63_CHPT,Y
		AND	#000FFH
		STA	ENCHPT,X
		LDA	!SSLIM_S63_TIM1,Y
		AND	#000FFH
		STA	ENTIM1,X

SSLIM_SUB63800	EQU	$

		RTS
;
SSLIM_SUB64	EQU	$
		TYX

		LDA	ENTIM0,X		;Xgbv ?
		BNE	SSLIM_SUB64800		; yes: SSLIM_SUB64800

		INC	BOSS0FLG
		JSL	>ENCLEAR

SSLIM_SUB64800	EQU	$

		RTS
;
;
;
;
;
;
