;************************************************************************
;*									*
;*	title name	: "yossy"					*
;*	proccess	: ending					*
;*	file name	: ys_ending					*
;*									*
;************************************************************************
;
;
		SALL
;
		include		ys_header.inc
		include		ys_unit.h
		include		ys_color.h
		include		ys_presno.h
;
		XALL
;
;
;------------------------------------------------------------------------
;-		global symbol						-
;------------------------------------------------------------------------
		GLB	GAME_OVER_INT,GAME_OVER
		GLB	ENDING_MAP_IN
		GLB	ENDING1_IN,ENDING1_PL,ENDING_START
		GLB	END_BITMAP_CLR
;
;------------------------------------------------------------------------
;-		extern symbol						-
;------------------------------------------------------------------------
;
;-------------< ys_main >------------------------------------------------
		EXT	RAMCLR,VRAMCL,VRAMCL2,BLNKOFF,URAMCLR,OAMDXCLR
		EXT	DMA_D_M,DMA_M_M
		EXT	SOUND_TR_2
;
		EXT	GM01
		EXT	MPIN,HMPIN
		EXT	TITLE_SOUND,END_SOUND
;
;-------------< ys_enmy >------------------------------------------------
		EXT	ENRAMCLR
;
;-------------< ys_rpro >------------------------------------------------
		EXT	CHIPON
;
		EXT	ENCL
;
;-------------< ys_init >------------------------------------------------
		EXT	GMMDST,CHRSET,COLSET,VRAMDX_ST
		EXT	UNCOMPRES
;
		EXT	BTMP
		EXT	END_CHR
;
;-------------< ys_title >-----------------------------------------------
		EXT	MODINC,MODINC2
;
;-------------< ys_data >------------------------------------------------
		EXT	DIVDAT
;
;-------------< ys_msgdt >-----------------------------------------------
		EXT	GMOV_MSG
;
;-------------< ys_chr >-------------------------------------------------
		EXT	ADDSTART
;
;
;------------------------------------------------------------------------
;-		define symbol						-
;------------------------------------------------------------------------
;;;;		EQU
;
;
;************************************************************************
;*									*
;*		program start						*
;*									*
;************************************************************************
;
;
		EXTEND
;
;
		MEM8
		IDX8
;
Group_10	GROUP	Ending_pro
Ending_pro	SECT	REL
;
;
;****************************************************************
;*								*
;*		f`ld@nudq CjVZbg		*
;*								*
;****************************************************************
GAME_OVER_INT	EQU	$
		JSL	>VRAMCL		;VRAM clear
		JSL	>URAMCLR	;use RAM clear
		JSL	>ENRAMCLR	;Gq`lNA
;
		JSL	>OAMDXCLR	;OAM clear
;
		LDX	#GM01
		JSL	>GMMDST
		LDA	#010H
		STA	!MANSEL
		STZ	!SUBSEL
		LDA	#022H
		STA	!OBJSEL
		STA	2101H
		STZ	!HD420C
;
;----------------------------------------------- LN^[
		M16			; memory 16bit mode
		LDA	#GMOV_MSG
		STA	>MSG_ADR
		LDA	#BANK GMOV_MSG
		STA	>MSG_BNK
;
		M_CHIP	MSG_CORE
;
		LDA	#04000H
		STA	2116H		; VRAM address set
		LDA	#00000001B+(18H*100H)
		STA	4300H		; DMA parameter & B bus address
		LDA	#WOB7CHR
		STA	4302H		; A bus address(L,H) set
		LDY	#BANK WOB7CHR
		STY	4304H		;	"       (B) set
		LDA	#02000H
		STA	4305H		; number of byte set
		LDX	#00000001B
		STX	420BH		; DMA "ON" !!
;
		LDA	#00000
		STA	!NUKCOL
		STA	>DATACOL
		TAX
GM_OV_IT_020	EQU	$
		STA	>DATACOL+(010H*2)*9,X
		INX
		INX
		CPX	#010H*2
		BCC	GM_OV_IT_020
;
		LDA	#000
		STA	>CLFDCNT
;
		LDX	#000H
GM_OV_IT_050	EQU	$		; Xe[^X p[^ NA
		STZ	!GMSTATUS,X
		INX
		INX
		CPX	#CORSNO-NUKINO
		BCC	GM_OV_IT_050
;
		LDX	#000H
GM_OV_IT_060	EQU	$
		STZ	!OAMSUB+000H,X
		STZ	!OAMSUB+100H,X
		STZ	!OAMSUB+120H,X
		DEX
		DEX
		BNE	GM_OV_IT_060
;
		LDA	#00018H		; IuWF\p wW
		STA	<GMOV_OBJ_X
		LDA	#00060H		; IuWF\p xW
		STA	<GMOV_OBJ_Y
		LDX	#000H
GM_OV_IT_070	EQU	$
		LDA	<GMOV_OBJ_Y,X
		STA	<GMOV_OBJ_Y+2,X
		LDA	<GMOV_OBJ_X,X
		CLC
		ADC	#00018H
		STA	<GMOV_OBJ_X+2,X
		INX
		INX
		CPX	#00002*4
		BCC	GM_OV_IT_070
;
		CLC
		ADC	#00010H
		STA	<GMOV_OBJ_X,X
GM_OV_IT_075	EQU	$
		LDA	<GMOV_OBJ_Y,X
		STA	<GMOV_OBJ_Y+2,X
		LDA	<GMOV_OBJ_X,X
		CLC
		ADC	#00018H
		STA	<GMOV_OBJ_X+2,X
		INX
		INX
		CPX	#00002*7
		BCC	GM_OV_IT_075
;
		STZ	<GMOV_SLT
		LDA	#00800H
		STA	<GMOV_CNT
		LDA	#00100H
		STA	<GMOV_WAIT
;
		LDX	#007H
WANA_WANA_WANA	EQU	$
		LDA	#0FFFFH
WANA_WANA	EQU	$
		DEC	A
		BNE	WANA_WANA
		DEX
		BNE	WANA_WANA_WANA
;
		M8			; memory 8bit mode
;
;----------------------------------------------- NMI-IRQ set
		LDA	#002H		;IRQ counter set
		STA	!IRQFLG
		STZ	!HD420C		;NMIIRQ H-DMA flag set
;;;;		    LDA	    #070H	    ;H counter set
		LDA	#050H		;H counter set
		STA	4207H
		LDA	#0D8H		;V counter set
		STA	4209H
		LDA	#10110001B	;timer IRQ "ON"
		STA	4200H
;
		LDA	#004
		STA	SOUND_0
;
		INC	!MODENO
		BRA	GAME_OVER_990
;
;
;****************************************************************
;*								*
;*		f`ld@nudq				*
;*								*
;****************************************************************
GAME_OVER_ADR	EQU	$
		WORD	GAME_OVR_000,GAME_OVR_100
		WORD	GAME_OVR_700,GAME_OVR_800
		WORD	GAME_OVR_900
;
;
GAME_OVER	EQU	$
		JSL	>OAMDXCLR	;OAM clear
;
		LDX	<GMOVMOD
		JSR	(GAME_OVER_ADR,X)
;
GAME_OVER_990	EQU	$
		M16			; memory 16bit mode
		M_CHIP	DX_OAM		; OAM convert
		M8			; memory 8bit mode
;
		PLB
		RTL
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+		v`hs ^C}[			+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
GAME_OVR_000	EQU	$
		M16			; memory 16bit mode
		INC	!GMOV_TIM
		LDA	!GMOV_TIM
		CMP	#00200H
		BCC	GAME_OVR_050
		INC	<GMOVMOD
		INC	<GMOVMOD
GAME_OVR_050	EQU	$
		M8			; memory 8bit mode
		JSR	GAME_OVR_SET
		RTS
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+		tF[h				+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
GAME_OVR_100	EQU	$
		M16			; memory 16bit mode
		LDA	>DATACOL+020H*9+002H*3
		CLC
		ADC	#00421H*2
		BPL	GAME_OVR_150
		INC	<GMOVMOD
		INC	<GMOVMOD
		LDA	#07FFFH
GAME_OVR_150	EQU	$
		STA	>DATACOL+020H*9+002H*3
		M8			; memory 8bit mode
		JSR	GAME_OVR_SET
		RTS
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+		"f`ld@nudq"			+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
GAME_OVR_NO	EQU	$
		HEX	015H	;f
		HEX	001H	;`
		HEX	016H	;l
		HEX	004H	;d
		HEX	017H	;n
		HEX	018H	;u
		HEX	004H	;d
		HEX	019H	;q
;
GAME_OVR_NO_END EQU	$
;
GAME_OVR_X	EQU	$
		HEX	10,30,50,70,10,30,50,70
;
GAME_OVR_Y	EQU	$
		HEX	50,50,50,50,70,70,70,70
;
GM_OV_NO	EQU	GAME_OVR_NO_END-GAME_OVR_NO
;
GM_OV_SND	EQU	$
		WORD	00043H,0002EH
;
;
GAME_OVR_700	EQU	$
		LDA	<KEYC2L		; L[͑҂
		AND	#0C0H		;
		ORA	<KEYC2		;
		AND	#0D0H		;
		BEQ	GAME_OVR_710	;
		INC	<GMOVMOD	;
		INC	<GMOVMOD	;
		LDA	#05CH
		LDX	!GMOV_SLT
		LDA	GM_OV_SND,X
		STA	<SOUND_3	; sound set !!
		BRA	GAME_OVR_730
;
GAME_OVR_710	EQU	$
		LDA	<KEYC2
		AND	#003
		BEQ	GAME_OVR_730
		LDA	<GMOV_SLT
		EOR	#002
		AND	#002
		STA	<GMOV_SLT
		LDA	#05CH
		STA	<SOUND_3	; sound set !!
;
GAME_OVR_730	EQU	$
GAME_OVR_SET	EQU	$
		M16			; memory 16bit mode
;
		LDA	#WOB7CHR+(80H*20H)
		STA	R1		;(R1) <-- M-chip clear RAM start address
		LDA	#(80H*20H)/2
		STA	R12
		M_CHIP	MRAM_CLR
;
		LDX	#000H
		LDY	#GM_OV_NO-1
GAME_OVR_750	EQU	$
		LDA	GAME_OVR_NO,Y
		AND	#000FFH
		STA	R1		;(R1) <-- moji no.
		LDA	<GMOV_ANGL_X,X
		AND	#000FFH
		STA	R2		;(R2) <-- X angle
		LDA	<GMOV_ANGL_Y,X
		AND	#000FFH
		STA	R3		;(R3) <-- Y   "
		LDA	GAME_OVR_X,Y
		AND	#000FFH
		STA	R4		;(R4) <-- center X pos
		LDA	GAME_OVR_Y,Y
		AND	#000FFH
		STA	R5		;(R5) <--    "   Y  "
		LDA	<GMOV_ZOM
		STA	R6		;(R6) <-- zoom flag
;
		PHY
		PHX			;(X) save
		M_CHIP	MOJIPOLY2
		PLX			;(X) load
		PLY
;
		INX
		DEY
		BPL	GAME_OVR_750
;
		I16			; indxex 16bit mode
		LDY	#05000H			; uq`lAhX
		LDA	#BANK WOB7CHR
		STA	<WORK1
		LDA	#01000H			; ]oCg
		LDX	#WOB7CHR+(80H*20H)	; ]AhX
		JSL	>VRAMDX_ST
;
		LDA	#03100H
		STA	<WORK4		; LN^[m.
;
		LDX	#00000H
		LDY	!OAMIDX
GAME_OVR_770	EQU	$
		LDA	<GMOV_OBJ_X,X
		STA	!SOAM_DX+000,Y	; wW
		LDA	<GMOV_OBJ_Y,X
		STA	!SOAM_DX+002,Y	; xW
		LDA	<WORK4
		STA	!SOAM_DX+004,Y
		LDA	#04002H
		STA	!SOAM_DX+006,Y
		LDA	<WORK4
		INC	A
		INC	A
		INC	A
		INC	A
		BIT	#0000FH
		BNE	GAME_OVR_775
		LDA	#03140H
GAME_OVR_775	EQU	$
		STA	<WORK4
		INX
		INX
		TYA
		CLC
		ADC	#00008
		TAY
		CPY	#GM_OV_NO*8+200H
		BCC	GAME_OVR_770
;
		JSR	AGAIN_OBJ_SET
;
		STY	!OAMIDX
;
		I8			; index 8bit mode
		LDA	<GMOV_ZOM
		CMP	#00030H
		BCS	GAME_OVR_780
		INC	A
		STA	<GMOV_ZOM
		BRA	GAME_OVR_790
;
;
GAME_OVR_780	EQU	$
		M8			; memory 8bit mode
		LDX	#000
		STZ	<WORK0
GM_OV_780_000	EQU	$
		LDA	<GMOV_CNT+1
		BNE	GM_OV_780_100
		LDA	<GMOV_ANGL_X,X
		BEQ	GM_OV_780_200
		LDA	#001
GM_OV_780_100	EQU	$
		CLC
		ADC	<GMOV_ANGL_X,X
		STA	<GMOV_ANGL_X,X
		ORA	<WORK0
		STA	<WORK0
;
GM_OV_780_200	EQU	$
		LDA	<GMOV_CNT+1
		BNE	GM_OV_780_300
		LDA	<GMOV_ANGL_Y,X
		BEQ	GM_OV_780_400
		LDA	#001
GM_OV_780_300	EQU	$
		CLC
		ADC	<GMOV_ANGL_Y,X
		STA	<GMOV_ANGL_Y,X
GM_OV_780_400	EQU	$
		INX
		CPX	#008
		BCC	GM_OV_780_000
;
		M16			; memory 16bit mode
		LDA	<GMOV_CNT
		SEC
		SBC	#00010H
		BPL	GAME_OVR_785
		LDA	#00000
		LDX	<WORK0
		BNE	GAME_OVR_790
		DEC	<GMOV_WAIT
		BNE	GAME_OVR_785
		LDA	#00100H
		STA	<GMOV_WAIT
		LDA	#00800H
GAME_OVR_785	EQU	$
		STA	<GMOV_CNT
;
GAME_OVR_790	EQU	$
		M8			; memory 8bit mode
		RTS
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	ăX^[g nai Zbg		+
;++++++++++++++++++++++++++++++++++++++++++++++++
AGN_OBJ_DAT	EQU	$
		WORD	00050H,00082H
;
;
		MEM16
		IDX16
AGAIN_OBJ_SET	EQU	$
		LDX	<GMOV_SLT
		LDA	AGN_OBJ_DAT,X	; wW
		STA	!SOAM_DX+000,Y	;
		STA	!SOAM_DX+008,Y	;
		LDA	#000B0H		; xW
		STA	!SOAM_DX+002,Y	;
		CLC			;
		ADC	#00008H		;
		STA	!SOAM_DX+010,Y	;
		LDA	#03280H
		STA	!SOAM_DX+004,Y
		ORA	#00010H
		STA	!SOAM_DX+012,Y
		LDA	#04000H
		STA	!SOAM_DX+006,Y
		STA	!SOAM_DX+014,Y
		TYA
		CLC
		ADC	#00016
		TAY
;
		LDA	#00048H
		STA	<WORK0
		LDA	#03220H
		STA	<WORK2
		LDX	#00006
AGN_OBJ_050	EQU	$
		LDA	<WORK0		; wW
		STA	!SOAM_DX+000,Y	;
		STA	!SOAM_DX+008,Y	;
		CLC
		ADC	#00010H
		STA	<WORK0
		LDA	#00090H		; xW
		STA	!SOAM_DX+002,Y	;
		CLC			;
		ADC	#00010H		;
		STA	!SOAM_DX+010,Y	;
		LDA	<WORK2
		STA	!SOAM_DX+004,Y
		CLC
		ADC	#00020H
		STA	!SOAM_DX+012,Y
		LDA	#04002H
		STA	!SOAM_DX+006,Y
		STA	!SOAM_DX+014,Y
		INC	<WORK2
		INC	<WORK2
		TYA
		CLC
		ADC	#00016
		TAY
		DEX
		BNE	AGN_OBJ_050
;
		RTS
		MEM8
		IDX8
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+	ZNg X^[g CjV Zbg		+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
GAME_OVR_800	EQU	$
		JSR	GAME_OVR_730
		LDA	<GMOV_SLT
		BNE	GAME_OVR_850
;
		LDA	#HMPIN
		STA	!MODENO
		LDA	#003
		STA	!PLCONT
		BRA	GAME_OVR_890
;
GAME_OVR_850	EQU	$
		DEC	!FADNO
		BNE	GAME_OVR_890
		INC	<GMOVMOD
		INC	<GMOVMOD
GAME_OVR_890	EQU	$
		RTS
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+		^Cg }bv ցEEE		+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
GAME_OVR_900	EQU	$
		STZ	4200H
		LDX	#TITLE_SOUND	;(X) <-- TEhvO]e[umD
		JSL	>SOUND_TR_2
		STZ	!TITLEFG
		LDA	#080H
		STA	!TITL_SND
		STZ	!WLD6_FLG
		STZ	!WLD6_FLG+1
		STZ	!FADNO
		STZ	!FADMK
		LDA	#MPIN+1
		STA	!MODENO
		LDA	#10110001B	;timer IRQ "ON"
		STA	4200H
		RTS
;
;************************************************************************
;*		GfBO]}bvf CjVZbg		*
;************************************************************************
ENDING_MAP_IN	EQU	$
		LDA	#0FFH
		STA	!TITLEFG
		LDA	#006*2
		STA	!MPTYPE
		INC	!WLD6_FLG
		JMP	>MODINC
;
;************************************************************************
;*		GfBOrbg}bvZbg			*
;************************************************************************
END_BITMAP_CLR	EQU	$
		WORD	5000H,4000H+(0800H-1)
		WORD	0000H
;
		WORD	0FFFFH
;
ENDING1_IN	EQU	$
		LDA	#ENCL
		JSL	>VRAMCL2	;VRAM clear
		JSL	>URAMCLR	;use RAM clear
;
;------------------------------------------------------------------------
;-		LN^[Zbg					-
;------------------------------------------------------------------------
;
		I16
;
		LDY	#END_CHR	;(Y) <-- LN^[zuf[^|C^[
		JSL	>CHRSET
;
		M8			; memory 8bit mode
;
;------------------------------------------------------------------------
;-		rbg}bvXN[Zbg				-
;------------------------------------------------------------------------
		LDA	#10000001B
		STA	2115H		;inc mode set
;
		MI16
;
		LDA	#5084H
		STA	<WORK		;(WK0,1) <-- VRAM address
		LDX	#0000H		;(X)	 <-- set screen data
;
		LDA	#24		;(WK2,3) <-- H loop no
		STA	<WORK+2
ENDING1_IN_0050 EQU	$
		LDA	<WORK
		STA	2116H		;VRAM address set
;
		LDY	#16		;(Y) <-- V loop no
ENDING1_IN_0100 EQU	$
		STX	2118H
		INX
		DEY
		BNE	ENDING1_IN_0100
;
		INC	<WORK
;
		DEC	<WORK+2
		BNE	ENDING1_IN_0050
;
;------------------------------------------------------------------------
;-		J[Zbg						-
;------------------------------------------------------------------------
		LDX	#0200H-2
ENDING1_IN_0150 EQU	$
		LDA	>COL_ADDRESS+ENDING_BMP_COL,X
		STA	>BITMAP_COL,X
		STA	>BTMP_MOTO_COL,X
		DEX
		DEX
		BPL	ENDING1_IN_0150
;
		LDX	#004H*2-2
ENDING1_IN_0160 EQU	$
		LDA	>BITMAP_COL+(010H*2)*00EH+001H*2,X
		STA	!END_MJ_COL_BF+000H*2,X
		LDA	>BITMAP_COL+(010H*2)*00FH+001H*2,X
		STA	!END_MJ_COL_BF+004H*2,X
		DEX
		DEX
		BPL	ENDING1_IN_0160
;
;------------------------------------------------------------------------
;-		P^f[^q`lZbg				-
;------------------------------------------------------------------------
		PHB
		LDY	#BITMAP_DIV
		LDX	#DIVDAT
		LDA	#0200H*2-1
		MVN	#BANK DIVDAT,#BANK BITMAP_DIV
		PLB
;
		MI8
;
;------------------------------------------------------------------------
;-		PPU Reg. set						-
;------------------------------------------------------------------------
		LDX	#BTMP		;(X) <-- game mode type no.
		JSL	>GMMDST		;game mode set
		STZ	210DH		;BG1 scroll counter set
		STZ	210DH
		STZ	210EH
		STZ	210EH
		STZ	210FH		;BG2 scroll counter set
		STZ	210FH
		STZ	2110H
		STZ	2110H
;
		LDA	#003
		STA	!OBJSEL
		STA	2101H
;
;------------------------------------------------------------------------
;-		naif[^obt@Zbg				-
;------------------------------------------------------------------------
;
		MI16			; memory , index 16bit mode
;
		LDX	#ENDING_OBJ_DT2-ENDING_OBJ_DT-2
ENDING1_IN_0200 EQU	$		; ꖋrbg}bvf[^
		LDA	ENDING_OBJ_DT,X
		STA	!BITMAP_OBJDT,X
		DEX
		DEX
		BPL	ENDING1_IN_0200
;
		LDA	#3*40H
		STA	<TORI_ATR
;
		LDA	#CBITMAP_OBJDT
		STA	<BTMP_ADR
;
;------------------------------------------------------------------------
;-		q`lNA[					-
;------------------------------------------------------------------------
		I8			; index 8bit mode
;
		LDA	#0FFB0H		; J xWZbg
		STA	<BITMAP_Y	;	 yW
		STZ	<BITMAP_X	;
		LDA	#00030H		; X^bt[JEg
		STA	!END_CNT	;	lZbg
		LDA	#00008H
		STA	<BTMP_Z_CT	; ސ Zbg
		LDA	#EDG_TORI0
		STA	<TORI_POS	; f[^ |WV AhX
		LDA	#00009H
		STA	<END_OAM_XCT	;IuWF wJEgZbg
;
;------------------------------------------------------------------------
;-		rbg}bvf[^]					-
;------------------------------------------------------------------------
		JSR	BIT_MAP_CLS
;
		LDA	#00000H
		STA	R1		;(R1)	<-- XN[ʂyW
		LDA	<BITMAP_Y
		STA	R2		;(R2)	<-- XN[ʂxW
		LDA	<BITMAP_X
		STA	R3		;(R3)	<-- XN[ʂwW
		LDA	<BTMP_ADR
		STA	R5
		M_CHIP	E_BITMAP
;
		LDX	#10000000B
		STX	2115H		; inc mode set
		LDA	#00000H
		STA	2116H		; VRAM address
		LDA	#00000001B+(18H*100H)
		STA	4300H		; DMA paramer & B bus address
		LDA	#BITMAP_BF
		STA	4302H		; A bus address(L,H) set
		LDX	#BANK BITMAP_BF
		STX	4304H		;	"       (B) set
		LDA	#06000H
		STA	4305H		; number of byte set
		LDX	#00000001B
		STX	420BH		; DMA ON!!
;
;------------------------------------------------------------------------
;-		dmchmfLN^[ 쐬			-
;------------------------------------------------------------------------
		JSR	BIT_MAP_CLS
;
		LDX	!CIPSCR
		PHX
		LDX	#00111101B
		STX	!CIPSCR
		M_CHIP	ENDING_MOJI
		PLX
		STX	!CIPSCR
;
		LDA	#07000H
		STA	2116H		; VRAM address
		LDA	#00000001B+(18H*100H)
		STA	4300H		; DMA paramer & B bus address
		LDA	#BITMAP_BF
		STA	4302H		; A bus address(L,H) set
		LDX	#BANK BITMAP_BF
		STX	4304H		;	"       (B) set
		LDA	#02000H
		STA	4305H		; number of byte set
		LDX	#00000001B
		STX	420BH		; DMA ON!!
;
		M8			; memory 8bit mode
;
;------------------------------------------------------------------------
;-		TEhvO]					-
;------------------------------------------------------------------------
		LDX	#END_SOUND
		JSL	>SOUND_TR_2
;
		LDA	#001
		STA	<SOUND_0	; sound set !!
;
;------------------------------------------------------------------------
;-		NMI-IRQ set						-
;------------------------------------------------------------------------
;;;;		    LDA	    #018H	    ;H counter set
		LDA	#050H		;H counter set
		STA	4207H
		LDA	#001
		STA	4208H
		LDA	#0D8H		;V counter set
		STA	4209H
		LDA	#10110001B	;timer IRQ "ON" [ NMI disable ]
		STA	4200H
;
		STZ	!FADNO
;
		JMP	>MODINC
;
;************************************************************************
;*		GfBO tF[h X^[g				*
;************************************************************************
ENDING_START	EQU	$
		LDA	<END_FRCNT
		AND	#003
		BNE	EDG_STT_100
;
		INC	!FADNO
;
EDG_STT_100	EQU	$
		M16			; memory 16bit mode
		INC	<END_FRCNT
;
		LDA	!FADNO
		AND	#000FFH
		CMP	#0000FH
		BCC	EDG1_PL_100
		STZ	!BTMP_COL_CNT
		INC	!MODENO
		LDA	!FADMK
		EOR	#001
		AND	#001
		STA	!FADMK
		STZ	<END_FRCNT
;
		BRA	EDG1_PL_100
		MEM8
;
;************************************************************************
;*		GfBOrbg}bv				*
;************************************************************************
END_ADR_DT	EQU	$
		WORD	END_NO1_CNT,END_NO1_MSG ;P
		WORD	END_NO1_PL,END_FADE
;
		WORD	END_CHR_1,END_CHR_2	;Q
		WORD	END_NO2_IN
END_NO2_NEXT	EQU	$
		WORD	END_NO2_PL_KM,END_NO2_PL_TR
		WORD	END_FADE_NO2
;
END_ADR_TORI	EQU	$
		WORD	END_CHR_1,END_CHR_2	;R
		WORD	END_NO3_IN
END_NO3_NEXT	EQU	$
		WORD	END_NO3_FADE
		WORD	END_NO3_HM,END_NO3_TR
		WORD	END_NO3_WAIT,END_NO3_FLY
		WORD	END_NO3_WAIT,END_NO3_HOME
		WORD	END_NO3_WAIT
		WORD	END_FADE2
;
		WORD	END_NO4_IN,END_CHR_1	;S
		WORD	END_CHR_2,END_FADE2
BIT_MAP_OFF	EQU	$
		WORD	END_NO4_WAIT,END_FADE2
;
		WORD	END_NO5_IN,END_CHR_1	;T
		WORD	END_CHR_2,END_FADE3
		WORD	NO5_WAIT_1,NO5_WAIT_2
		WORD	NO5_WAIT_3
END_ADR_DT_END	EQU	$
;
;
ENDING1_PL	EQU	$
		M16			; memory 16bit mode
		INC	<END_FRCNT
;
		LDA	!END_NXT
		BNE	EDG1_PL_990
		LDX	<END_MOD
		CPX	#END_ADR_DT_END-END_ADR_DT
		BCS	EDG1_PL_100
		JSR	(END_ADR_DT,X)
;
EDG1_PL_100	EQU	$
		LDA	<END_MOD
		CMP	#BIT_MAP_OFF-END_ADR_DT
		BCS	EDG1_PL_990
		LDA	!END_NXT
		BNE	EDG1_PL_990
		JSR	BIT_MAP_CLS
;
;-------------- rbg}bvobt@Zbg ------------------------------
		LDA	<BITMAP_Z
		CLC
		ADC	<BTMP_Z_CT
		AND	#003FFH
		STA	<BITMAP_Z
;
		LDA	<END_MOD
		CMP	#END_ADR_TORI-END_ADR_DT	; ł邩 ?
		BCS	EDG1_PL_200			;	NO -> EDG1_PL_200
		JSR	TORI_RAM_ST
;
EDG1_PL_200	EQU	$
		LDA	<EDG_SCRL
		BEQ	EDG1_PL_240
		CLC
		ADC	#00300H
EDG1_PL_240	EQU	$
		CLC
		ADC	<BITMAP_Z
		STA	R1		;(R1)	<-- XN[ʂyW
		LDA	<BITMAP_Y
		STA	R2		;(R2)	<-- XN[ʂxW
		LDA	<BITMAP_X
		STA	R3		;(R3)	<-- XN[ʂwW
		LDA	<BTMP_ADR
		STA	R5
		M_CHIP	E_BITMAP
;
;-------------- rbg}bvoN؂ւ ------------------------------
;
		M8			;  memory 8bit mode
;
		LDA	#03H		;rbg}bvLN^[]Jn
		STA	<BITMAP_WTRF
;
EDG1_PL_990	EQU	$
		M8			;  memory 8bit mode
		PLB
		RTL
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+		rbg}bvobt@NA		+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
		MEM16
BIT_MAP_CLS	EQU	$
		LDA	#BITMAP_BF
		STA	R0		;(R0)  <-- ]AhX
		LDA	#2
		STA	R1		;(R1)  <-- ]AhXZf[^
		STZ	R2		;(R2)  <-- ]f[^
		LDA	#6000H/2
		STA	R12		;(R12) <-- ][h
		M_CHIP	MRAM_FILL
		RTS
;
;****************************************************************
;*		P bZ[W (JEg_E)		*
;****************************************************************
END_NO1_CNT	EQU	$
		DEC	!END_CNT
		BNE	NO1_CNT_990
		INC	<END_MOD
		INC	<END_MOD
NO1_CNT_990	EQU	$
		RTS
;
;****************************************************************
;*		P bZ[W\				*
;****************************************************************
NO1_MSG_DAT	EQU	$
		HEX	020H,040H,040H,020H,040H,040H,040H,040H
		HEX	040H,020H,040H,040H,020H,040H,020H,040H
		HEX	040H,020H,040H,020H,040H,040H,040H,040H
		HEX	040H,040H,020H,040H,020H,040H
NO1_MSG_DAT_E	EQU	$
;
STAFF_CMP	EQU	NO1_MSG_DAT_E-NO1_MSG_DAT
;
;
END_NO1_MSG	EQU	$
		LDA	!END_MK
		BEQ	NO1_MSG_500
		LDA	#00CH
		BRA	NO1_MSG_550
;
NO1_MSG_500	EQU	$
		LDA	!END_OBJ_CT
		CMP	#STAFF_CMP
		BCS	NO1_MSG_900
		TAX
		INC	!END_OBJ_CT
		LDA	NO1_MSG_DAT,X
		AND	#000FFH
NO1_MSG_550	EQU	$
		STA	!END_CNT
		DEC	<END_MOD
		DEC	<END_MOD
		BRA	NO1_MSG_990
;
NO1_MSG_900	EQU	$
		INC	<END_MOD
		INC	<END_MOD
		BRA	NO1_MSG_999
;
NO1_MSG_990	EQU	$
		LDA	!END_MK
		EOR	#00002H
		AND	#00002H
		STA	!END_MK
NO1_MSG_999	EQU	$
		RTS
;
;****************************************************************
;*		P ҂					*
;****************************************************************
END_NO1_PL	EQU	$
		LDA	!END_OBJ_CT
		CMP	#STAFF_CMP
		BCC	END_SUB090
		LDA	<BITMAP_Z
		BNE	END_SUB090
		INC	<END_MOD
		INC	<END_MOD
		INC	<EDG_SCRL+1
		JSR	BLACK_INT
		JSR	END_WAKU_SET
		STZ	!BTMP_COL_CNT
END_SUB090	EQU	$
		RTS
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	tF[hAEg CjVZbg		+
;++++++++++++++++++++++++++++++++++++++++++++++++
BLACK_INT	EQU	$
		I16			;index 16bit mode
		LDA	#00000H
		TAX
END_SUB050	EQU	$
		STA	>BTMP_CHG_COL,X
		INX
		INX
		CPX	#010H*2*010H
		BNE	END_SUB050
		LDX	#00006H
END_SUB060	EQU	$
		LDA	>BTMP_MOTO_COL+(010H*2*0EH)+2,X
		STA	>BTMP_CHG_COL+(010H*2*0EH)+2,X
		LDA	>BTMP_MOTO_COL+(010H*2*0FH)+2,X
		STA	>BTMP_CHG_COL+(010H*2*0FH)+2,X
		DEX
		DEX
		BPL	END_SUB060
		I8			; index 8bit mode
		RTS
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+		NJ[Zbg		+
;++++++++++++++++++++++++++++++++++++++++++++++++
END_WAKU_DAT0	EQU	$
		WORD	00000H,0569CH,028F1H,00006H,05B9FH,02DF6H,0004DH,06FDFH
END_WAKU_DAT1	EQU	$
		WORD	00000H,0679FH,01D51H,06FD9H,02144H
END_WAKU_DAT2	EQU	$
;
;
END_WAKU_SET	EQU	$
		LDX	#000
END_WAKU_050	EQU	$
		LDA	END_WAKU_DAT0,X
		STA	>BTMP_CHG_COL+020H*5+2,X
		INX
		INX
		CPX	#END_WAKU_DAT1-END_WAKU_DAT0
		BCC	END_WAKU_050
;
		LDX	#000
END_WAKU_100	EQU	$
		LDA	END_WAKU_DAT1,X
		STA	>BTMP_CHG_COL+020H*6+2,X
		INX
		INX
		CPX	#END_WAKU_DAT2-END_WAKU_DAT1
		BCC	END_WAKU_100
		RTS
;
;****************************************************************
;*		J[ tF[hAEg				*
;****************************************************************
END_FADE	EQU	$
		LDA	!BTMP_COL_CNT
		CMP	#00020H
		BCS	ED_FAD_150
		LDA	#BTMP_MOTO_COL
		STA	R1
		LDA	#BTMP_CHG_COL
		STA	R2
		LDA	#BITMAP_COL
		STA	R3
		M_CHIP	END_COL_FADE
		BRA	ED_FAD_190
;
ED_FAD_150	EQU	$
		INC	<END_MOD
		INC	<END_MOD
		STZ	!BTMP_COL_CNT
		PHB
		LDX	#BANK BITMAP_COL
		PHX
		PLB
		LDX	#000
ED_FAD_160	EQU	$
		LDA	!BITMAP_COL+000H,X
		STA	!BTMP_MOTO_COL+000H,X
		LDA	!BITMAP_COL+100H,X
		STA	!BTMP_MOTO_COL+100H,X
		INX
		INX
		BNE	ED_FAD_160
		PLB
;
ED_FAD_190	EQU	$
		RTS
;
;****************************************************************
;*		J[ tF[h ̂Q				*
;****************************************************************
END_FADE2	EQU	$
		JSR	END_FADE
		LDA	<END_FRCNT
		AND	#00001
		BNE	END_FADE2_050
		LDA	!BTMP_COL_CNT
		BEQ	END_FADE2_050
		DEC	!BTMP_COL_CNT
END_FADE2_050	EQU	$
		RTS
;
;****************************************************************
;*		LN^[ZbĝP			*
;****************************************************************
END_CHR_1_ADR	EQU	$
		WORD	(CHRF1-CHR10)*3		; 2
		WORD	(CHRF1-CHR10)*3		; 3
		WORD	(CHR118-CHR10)*3	; _~[
		WORD	(CHR118-CHR10)*3	; 4
		WORD	(CHR118-CHR10)*3	; 5
;
;
END_CHR_1	EQU	$
		I16			; index 16bit mode
		LDY	<END_NO
		LDX	END_CHR_1_ADR,Y
		LDA	#06000H
		BRA	END_CHR_SET
;
;****************************************************************
;*		LN^[ZbĝQ			*
;****************************************************************
END_CHR_2_ADR	EQU	$
		WORD	(CHRF1-CHR10)*3 ; 2
		WORD	(CHRF2-CHR10)*3 ; 3
		WORD	(CHRF2-CHR10)*3 ; _~[
		WORD	(CHRF2-CHR10)*3 ; 4
		WORD	(CHR33-CHR10)*3 ; 5
;
;
END_CHR_2	EQU	$
		I16			; index 16bit mode
		LDY	<END_NO
		LDX	END_CHR_2_ADR,Y
		LDA	#06800H
END_CHR_SET	EQU	$
		STA	!END_ADR
		LDA	>ADDSTART+((NO_PRES+CHR10)*3),X
		STA	R1
		LDA	>ADDSTART+((NO_PRES+CHR10)*3)+2,X
		AND	#000FFH
		STA	R0
		LDA	#00040H
		STA	R3
		I8			; index 8bit mode
		LDX	!CIPSCR
		PHX
		LDX	#00111101B
		STX	!CIPSCR
		M_CHIP	DEF_CHR
		PLX
		STX	!CIPSCR
;
		LDA	#01000H
		STA	!END_KAZU
		INC	!END_NXT	; XN[`FW !!
		INC	<END_MOD
		INC	<END_MOD
		STZ	<BITMAP_TRF
		STZ	<BITMAP_WTRF
		RTS
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+		XN[Zbg		+
;++++++++++++++++++++++++++++++++++++++++++++++++
END_SCR_NO	EQU	$
		WORD	No_2,No_3,No_4,No_5
;
;
		IDX16
END_SCR		EQU	$
		LDX	<END_NO
		LDA	END_SCR_NO,X
		LDX	#BITMAP_BF
		JSL	>UNCOMPRES
		I8			; index 8bit mode
		LDA	#05CA0H
		STA	!END_ADR
		LDA	#00300H
		STA	!END_KAZU
		INC	!END_NXT	; XN[`FW !!
		INC	<END_NO
		INC	<END_NO
		STZ	<BITMAP_TRF
		STZ	<BITMAP_WTRF
		RTS
		IDX8
;
;****************************************************************
;*		Q CjVZbg				*
;****************************************************************
END_NO2_IN	EQU	$
		I16			; index 16bit mode
		LDX	#00000H
END_NO2_IN_150	EQU	$
		LDA	>COL_ADDRESS+ENDING_BMP_COL2,X
		STA	>BTMP_CHG_COL,X
		INX
		INX
		CPX	#020H*0CH
		BCC	END_NO2_IN_150
;
		LDX	#ENDING_OBJ_DT3-ENDING_OBJ_DT2-2
END_NO2_IN_180	EQU	$
		LDA	ENDING_OBJ_DT2,X
		STA	!BITMAP_OBJDT,X
		DEX
		DEX
		BPL	END_NO2_IN_180
;
		JSR	END_SCR
		I8			; index 8bit mode
;
		LDA	#0*40H
		STA	<TORI_ATR
		LDA	#EDG_TORI1
		STA	<TORI_POS	; f[^ |WV AhX
		STZ	<BITMAP_Z
		STZ	<BITMAP_Y
		STZ	<EDG_SCRL
		STZ	<BTMP_Z_CT	; ސ Zbg
		LDA	#00060H
		STA	<END_ANM_CNT
		INC	<END_MOD
		INC	<END_MOD
		LDA	#0FE30H
		STA	<END_NO2_Z
;
		RTS
;
;****************************************************************
;*		Q (Ă)				*
;****************************************************************
END_NO2_PL_KM	EQU	$
		JSR	END_FADE2
		LDA	!BTMP_COL_CNT
		CMP	#00018H
		BCC	END_NO2_PL_TR
		LDA	!END_OBJ_CT
		CMP	#STAFF_CMP+1
		BEQ	END_NO2_PL_TR
		LDA	!END_MK
		EOR	#002H
		AND	#002H
		STA	!END_MK
		INC	!END_OBJ_CT
		LDA	#00AH
		STA	<END_OAM_XCT
;
;****************************************************************
;*		Q (ł)				*
;****************************************************************
END_NO2_PL_TR	EQU	$
		M8				; memory 8bit mode
		LDA	!BITMAP_OBJDT+EDG_TORI1+3
		INC	A
		STA	!BITMAP_OBJDT+EDG_TORI1+3
		M16				; memory 16it mode
		LDA	<END_NO2_Z
		BMI	ED_NO2_PL_TR_90
		CMP	#001B0H
		BCC	ED_NO2_PL_TR_90
;
		JSR	BLACK_INT
		JSR	END_WAKU_SET
		INC	<END_MOD
		INC	<END_MOD
		LDA	!END_MK
		EOR	#00002H
		AND	#00002H
		STA	!END_MK
ED_NO2_PL_TR_90 EQU	$
		LDY	<TORI_POS
		LDA	<END_NO2_Z
		CLC
		ADC	#00008H
		STA	<END_NO2_Z
		RTS
;
;****************************************************************
;*		Q J[ tF[hAEg			*
;****************************************************************
END_FADE_NO2	EQU	$
		M8				; memory 8bit mode
		LDA	!BITMAP_OBJDT+EDG_TORI1+3
		INC	A
		STA	!BITMAP_OBJDT+EDG_TORI1+3
		LDA	!BITMAP_OBJDT+EDG_TORI1+4
		BEQ	ED_FAD_NO2_030
		DEC	A
		STA	!BITMAP_OBJDT+EDG_TORI1+4
ED_FAD_NO2_030	EQU	$
		M16				; memory 16bit mode
		AND	#000FFH
		CMP	#00010H
		BCS	ED_FAD_NO2_090
		JSR	END_FADE2
ED_FAD_NO2_090	EQU	$
		RTS
;
;****************************************************************
;*		R CjVZbg				*
;****************************************************************
END_NO3_IN	EQU	$
		I16			; index 16bit mode
		LDX	#00000H
END_NO3_IN_150	EQU	$
		LDA	>COL_ADDRESS+ENDING_BMP_COL3,X
		STA	>BTMP_CHG_COL,X
		INX
		INX
		CPX	#020H*10H
		BCC	END_NO3_IN_150
;
		LDX	#ENDING_OBJ_DT_E-ENDING_OBJ_DT3-2
END_NO3_IN_180	EQU	$
		LDA	ENDING_OBJ_DT3,X
		STA	!BITMAP_OBJDT,X
		DEX
		DEX
		BPL	END_NO3_IN_180
;
		JSR	END_SCR
		I8			; index 8bit mode
;
		STZ	<BITMAP_Z
		STZ	<EDG_SCRL
		STZ	<BTMP_Z_CT	; ސ Zbg
		INC	<END_MOD
		INC	<END_MOD
		LDA	#EDG_TORI2
		STA	<TORI_POS
		STZ	<END_ANM_CNT
		LDA	#002
		STA	<SOUND_0	; sound set !!
		RTS
;
;****************************************************************
;*		R		J[ tF[h			*
;****************************************************************
END_NO3_FADE	EQU	$
		JSR	END_FADE2
		LDA	!BTMP_COL_CNT
		CMP	#00008H
		BCS	END_NO3_HM_SB
		RTS
;
;****************************************************************
;*		R		ƃY[			*
;****************************************************************
END_NO3_HM_SB	EQU	$
		LDA	#00002
		STA	<BTMP_Z_CT
END_NO3_HM	EQU	$
		M8				; memory 8bit mode
		LDA	<BITMAP_Z
		AND	#002
		BNE	ED_NO3_HM_050
		LDA	!BITMAP_OBJDT+EDG3_KM0+2
		CLC
		ADC	#001
		STA	!BITMAP_OBJDT+EDG3_KM0+2
;
		LDA	!BITMAP_OBJDT+EDG3_KM2+2
		SEC
		SBC	#001
		STA	!BITMAP_OBJDT+EDG3_KM2+2
;
		LDA	!BITMAP_OBJDT+EDG3_KM4+2
		CLC
		ADC	#001
		STA	!BITMAP_OBJDT+EDG3_KM4+2
;
		LDA	!BITMAP_OBJDT+EDG3_KM6+2
		SEC
		SBC	#001
		STA	!BITMAP_OBJDT+EDG3_KM6+2
;
ED_NO3_HM_050	EQU	$
		LDA	!BITMAP_OBJDT+EDG3_KM5+2
		CLC
		ADC	#001
		STA	!BITMAP_OBJDT+EDG3_KM5+2
;
		LDA	!BITMAP_OBJDT+EDG3_KM7+2
		SEC
		SBC	#001
		STA	!BITMAP_OBJDT+EDG3_KM7+2
;
		LDA	!BITMAP_OBJDT+EDG3_KM1+2
		CLC
		ADC	#001
		STA	!BITMAP_OBJDT+EDG3_KM1+2
;
		LDA	!BITMAP_OBJDT+EDG3_KM3+2
		SEC
		SBC	#001
		STA	!BITMAP_OBJDT+EDG3_KM3+2
;
		LDA	!BITMAP_OBJDT+EDG3_KM1+3
		SEC
		SBC	#001
		STA	!BITMAP_OBJDT+EDG3_KM1+3
		STA	!BITMAP_OBJDT+EDG3_KM3+3
		STA	!BITMAP_OBJDT+EDG3_KM5+3
		STA	!BITMAP_OBJDT+EDG3_KM7+3
		M16				; memory 16bit mode
		LDA	<BITMAP_Z
		CMP	#000A0H
		BCC	ED_NO3_HM_090
		INC	<END_MOD
		INC	<END_MOD
		STZ	<BTMP_Z_CT
ED_NO3_HM_090	EQU	$
		RTS
;
;****************************************************************
;*		R ()					*
;****************************************************************
NO3_TR_DAT	EQU	$
		BYTE	BMP_STORI0+(0*40H),BMP_STORI1+(0*40H)
		BYTE	BMP_STORI2+(0*40H),BMP_STORI3+(0*40H)
NO3_TR_BTBT	EQU	$
		BYTE	BMP_STORI4+(0*40H),BMP_STORI5+(0*40H)
		BYTE	BMP_STORI6+(0*40H),BMP_STORI5+(0*40H)
NO3_TR_DAT_END	EQU	$
;
;
END_NO3_TR	EQU	$
		INC	<END_ANM_CNT
		LDA	<END_ANM_CNT
		CMP	#(NO3_TR_DAT_END-NO3_TR_DAT)*2
		BCC	NO3_TR_100
		LDA	#(NO3_TR_BTBT-NO3_TR_DAT)*2
		STA	<END_ANM_CNT
NO3_TR_100	EQU	$
		LSR	A
		TAY
		LDX	<TORI_POS
		M8				; memory 8bit mode
		LDA	NO3_TR_DAT,Y
		STA	!BITMAP_OBJDT+5,X
		CPY	#NO3_TR_BTBT-NO3_TR_DAT
		BCC	NO3_TR_200
		LDA	!BITMAP_OBJDT+3,X
		SEC
		SBC	#003
		STA	!BITMAP_OBJDT+3,X
		LDA	!BITMAP_OBJDT+2,X
		CLC
		ADC	#003
		STA	!BITMAP_OBJDT+2,X
		CMP	#048H
		BCC	NO3_TR_200
		M16				; memory 16bit mode
		LDA	#00040H
		STA	<END_ANM_CNT
		INC	<END_MOD
		INC	<END_MOD
NO3_TR_200	EQU	$
		M16				; memory 16bit mode
;
		RTS
;
;****************************************************************
;*		R (҂)					*
;****************************************************************
END_NO3_WAIT	EQU	$
		DEC	<END_ANM_CNT
		BNE	NO3_WAIT_100
		INC	<END_MOD
		INC	<END_MOD
		STZ	<END_ANM_CNT
NO3_WAIT_100	EQU	$
		RTS
;
;****************************************************************
;*		R (ł)				*
;****************************************************************
NO3_FLY_DAT	EQU	$
		BYTE	BMP_FTORI0+(0*40H),BMP_FTORI1+(0*40H)
		BYTE	BMP_FTORI2+(0*40H),BMP_FTORI3+(0*40H)
		BYTE	BMP_FTORI4+(0*40H),BMP_FTORI5+(0*40H)
		BYTE	BMP_FTORI6+(0*40H),BMP_FTORI7+(0*40H)
		BYTE	BMP_FTORI8+(0*40H),BMP_FTORI9+(0*40H)
		BYTE	BMP_FTORIA+(0*40H)
NO3_FLY_DAT_END EQU	$
;
;
END_NO3_FLY	EQU	$
		M8				; memory 8bit mode
		INC	<END_ANM_CNT
		LDA	<END_ANM_CNT
		CMP	#NO3_FLY_DAT_END-NO3_FLY_DAT
		BCC	NO3_FLY_100
		LDA	#000
NO3_FLY_100	EQU	$
		STA	<END_ANM_CNT
		TAX
		LDA	NO3_FLY_DAT,X
		STA	!BITMAP_OBJDT+EDG_FLY+5
;
		LDA	!BITMAP_OBJDT+EDG_FLY+2
		DEC	A
		DEC	A
		STA	!BITMAP_OBJDT+EDG_FLY+2
		AND	#002
		BNE	NO3_FLY_200
		LDA	!BITMAP_OBJDT+EDG_FLY+3
		DEC	A
		STA	!BITMAP_OBJDT+EDG_FLY+3
		CMP	#0C0H
		BNE	NO3_FLY_200
		INC	<END_MOD
		INC	<END_MOD
		LDA	#008H
		STA	<END_ANM_CNT
NO3_FLY_200	EQU	$
		M16				; memory 16bit mode
		LDA	#00100H
		CLC
		ADC	<BITMAP_Z
		STA	!BITMAP_OBJDT+EDG_FLY
;
		RTS
;
;****************************************************************
;*		R (Ƃ̖)			*
;****************************************************************
NO3_HOME_ADR	EQU	$
		WORD	NO3_HOME_ON,NO3_HOME_OFF
		WORD	NO3_HOME_ON,NO3_HOME_OFF
		WORD	NO3_HOME_OFF,NO3_HOME_OFF
		WORD	NO3_HOME_ON
NO3_HOME_ADR_E	EQU	$
;
;
END_NO3_HOME	EQU	$
		LDA	<END_ANM_CNT
		AND	#0FFFEH
		TAX
		JSR	(NO3_HOME_ADR,X)
		INC	<END_ANM_CNT
		LDA	<END_ANM_CNT
		CMP	#NO3_HOME_ADR_E-NO3_HOME_ADR
		BCC	NO3_HOME_990
		JSR	BLACK_INT
		JSR	END_WAKU_SET
		INC	<END_MOD
		INC	<END_MOD
		LDA	#010H
		STA	<END_ANM_CNT
NO3_HOME_990	EQU	$
		RTS
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+		Ƃ̖ nm !!			+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
NO3_HOME_ON	EQU	$
		LDA	#003FFH
		STA	>BITMAP_COL+010H*2*0+008H*2
		STA	>BITMAP_COL+010H*2*1+008H*2
		STA	>BITMAP_COL+010H*2*2+008H*2
		STA	>BITMAP_COL+010H*2*3+008H*2
		STA	>BTMP_MOTO_COL+010H*2*0+008H*2
		STA	>BTMP_MOTO_COL+010H*2*1+008H*2
		STA	>BTMP_MOTO_COL+010H*2*2+008H*2
		STA	>BTMP_MOTO_COL+010H*2*3+008H*2
		RTS
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+		Ƃ̖ nee !!			+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
NO3_HOME_OFF	EQU	$
		LDA	#01041H
		STA	>BITMAP_COL+010H*2*0+008H*2
		LDA	#01400H
		STA	>BITMAP_COL+010H*2*1+008H*2
		LDA	#01800H
		STA	>BITMAP_COL+010H*2*2+008H*2
		LDA	#01C00H
		STA	>BITMAP_COL+010H*2*3+008H*2
		RTS
;
;****************************************************************
;*		S CjVZbg				*
;****************************************************************
END_NO4_IN	EQU	$
		I16			; index 16bit mode
		LDX	#00000H
END_NO4_IN_150	EQU	$
		LDA	>COL_ADDRESS+ENDING_BMP_COL3,X
		STA	>BTMP_CHG_COL,X
		INX
		INX
		CPX	#020H*10H
		BCC	END_NO4_IN_150
;
		LDX	#00000H
END_NO4_IN_170	EQU	$
		LDA	>COL_ADDRESS+ENDING_BMP_COL4,X
		STA	>BTMP_CHG_COL+010H*2*4,X
		INX
		INX
		CPX	#010H*2
		BCC	END_NO4_IN_170
;
		LDA	>COL_ADDRESS+ENDING_BMP_COL4
		STA	>BTMP_CHG_COL
;
		JSR	END_SCR
		I8			; index 8bit mode
;
		LDA	#00080H
		STA	<END_ANM_CNT
		LDA	#0FFFFH
		STA	!BITMAP_OBJDT
		INC	<END_MOD
		INC	<END_MOD
		RTS
;
;****************************************************************
;*		S (҂)					*
;****************************************************************
END_NO4_WAIT	EQU	$
		DEC	<END_ANM_CNT
		BNE	NO4_WAIT_100
		JSR	BLACK_INT
		JSR	END_WAKU_SET
		INC	<END_MOD
		INC	<END_MOD
		STZ	<END_ANM_CNT
NO4_WAIT_100	EQU	$
		RTS
;
;****************************************************************
;*		J[ tF[h ̂R				*
;****************************************************************
END_FADE3	EQU	$
		JSR	END_FADE
		LDA	!BTMP_COL_CNT
		BEQ	END_FADE3_050
		DEC	!BTMP_COL_CNT
		LDA	<END_FRCNT
		AND	#00002
		BNE	END_FADE3_050
		INC	!BTMP_COL_CNT
END_FADE3_050	EQU	$
		RTS
;
;****************************************************************
;*		T CjVZbg				*
;****************************************************************
END_NO5_IN	EQU	$
		I16			; index 16bit mode
		LDX	#00000H
END_NO5_IN_050	EQU	$
		LDA	>COL_ADDRESS+ENDING_BMP_COL3,X
		STA	>BTMP_CHG_COL,X
		INX
		INX
		CPX	#020H*10H
		BCC	END_NO5_IN_050
;
		JSR	END_SCR
		LDA	#00340H
		STA	!END_KAZU
		I8			; index 8bit mode
;
		LDX	#000H
END_NO5_IN_070	EQU	$
		LDA	>COL_ADDRESS+ENDING_BMP_COL5,X
		STA	>BTMP_CHG_COL,X
		INX
		INX
		CPX	#010H*2*4
		BCC	END_NO5_IN_070
;
		LDA	#0337FH
		STA	>BTMP_CHG_COL+010H*2*5+009H*2
		STA	>BTMP_CHG_COL+010H*2*5+00AH*2
;
		LDA	#00009
		STA	<END_OAM_XCT
		LDA	#00030H
		STA	<END_ANM_CNT
		INC	<END_MOD
		INC	<END_MOD
		RTS
;
;****************************************************************
;*		T (bZ[W\҂)			*
;****************************************************************
NO5_WAIT_3	EQU	$
		LDA	<END_ANM_CNT
		DEC	A
		BNE	NO5_WAIT_1
		LDA	#0000AH
		STA	<END_OAM_XCT
NO5_WAIT_1	EQU	$
		DEC	<END_ANM_CNT
		BNE	NO5_WAIT_100
		LDA	!END_MK
		EOR	#002H
		AND	#002H
		STA	!END_MK
		INC	!END_OBJ_CT
		INC	<END_MOD
		INC	<END_MOD
		LDA	#00170H
		STA	<END_ANM_CNT
NO5_WAIT_100	EQU	$
		RTS
;
;****************************************************************
;*		T (҂)					*
;****************************************************************
NO5_WAIT_2	EQU	$
		DEC	<END_ANM_CNT
		BNE	NO5_WAIT_200
		LDA	!END_MK
		EOR	#002H
		AND	#002H
		STA	!END_MK
		INC	<END_MOD
		INC	<END_MOD
		LDA	#00030H
		STA	<END_ANM_CNT
NO5_WAIT_200	EQU	$
		RTS
;
;
;****************************************************************
;*								*
;*		̉H΂Aj[V			*
;*					(V[P`Q)		*
;****************************************************************
TORI_RAM_DATA	EQU	$
		BYTE	BMP_TORI00,BMP_TORI01,BMP_TORI02,BMP_TORI03
		BYTE	BMP_TORI04,BMP_TORI05,BMP_TORI06,BMP_TORI07
		BYTE	BMP_TORI08,BMP_TORI09,BMP_TORI10,BMP_TORI11
		BYTE	BMP_TORI12
TORI_RAM_DT_END EQU	$
;
YAMA0_DATA	EQU	$
		BYTE	BMP_YAMA0+(0*40H),BMP_YAMA2+(2*40H)
		BYTE	BMP_KUMO2+(0*40H),BMP_KUMO0+(0*40H)
;
YAMA1_DATA	EQU	$
		BYTE	BMP_YAMA1+(0*40H),BMP_YAMA0+(0*40H)
		BYTE	BMP_YAMA1+(0*40H),BMP_KUMO0+(0*40H)
;
YAMA2_DATA	EQU	$
		BYTE	BMP_YAMA2+(2*40H),BMP_KUMO2+(0*40H)
		BYTE	BMP_KUMO0+(0*40H),BMP_KUMO0+(0*40H)
;
YAMA3_DATA	EQU	$
		BYTE	BMP_YAMA3+(2*40H),BMP_KUMO0+(0*40H)
		BYTE	BMP_KUMO0+(0*40H),BMP_YAMA3+(2*40H)
;
TORI_RAM_CMP	EQU	TORI_RAM_DT_END-TORI_RAM_DATA
;
;
TORI_RAM_ST	EQU	$
		I16				; index 16bit mode
		LDY	<TORI_POS
		LDA	<END_NO2_Z
		BNE	TR_RM_ST_0180
		LDA	<EDG_SCRL
		BEQ	TR_RM_ST_0150
		CLC
		ADC	#00300H
TR_RM_ST_0150	EQU	$
		CLC
		ADC	<BITMAP_Z
TR_RM_ST_0180	EQU	$
		STA	!BITMAP_OBJDT,Y
;
		LDA	<EDG_SCRL		; X^bt[I ?
		BEQ	TR_RM_ST_0500		;	NO -> TR_RM_ST_0500
		LDA	<BITMAP_Y
		BEQ	TR_RM_ST_0500
		CLC
		ADC	#00002
		STA	<BITMAP_Y
;
TR_RM_ST_NO2	EQU	$
TR_RM_ST_0500	EQU	$
		INC	<END_ANM_CNT
		LDA	<END_ANM_CNT
		CMP	#TORI_RAM_CMP
		BCC	TR_RM_ST_0550
		LDA	#00000H
TR_RM_ST_0550	EQU	$
		STA	<END_ANM_CNT
		TAX
;
		M8				; memory 8bit mode
		LDA	<BITMAP_X
		STA	!BITMAP_OBJDT+2,Y
		LDA	<BITMAP_Y
		BEQ	TR_RM_ST_0700
		STA	!BITMAP_OBJDT+3,Y
;
TR_RM_ST_0700	EQU	$
		LDA	TORI_RAM_DATA,X		;  Aj[V
		CLC				;
		ADC	<TORI_ATR		;
		STA	!BITMAP_OBJDT+5,Y	;
;
		MI8				; memory , index 8bit mode
;
		LDA	<END_NO			; P
		BNE	TR_RM_ST_0990		;	NO -> TR_RM_ST_0990
;
;;;;K;;;;		LDA	<EDG_SCRL+1
;;;;K;;;;		BNE	TR_RM_ST_0900
;;;;K;;;;		JSR	TORI_CONTROL
;
TR_RM_ST_0900	EQU	$
		LDA	<BITMAP_Z+1		;
		BNE	TR_RM_ST_0990		; P ?
		LDA	<BITMAP_Z		;	NO -> TR_RM_ST_0990
		BNE	TR_RM_ST_0990		;
		LDA	<END_YM_FG
		INC	A
		AND	#003
		STA	<END_YM_FG
		TAX
		LDA	YAMA0_DATA,X
		STA	!BITMAP_OBJDT+EDG1_YM0+5
		LDA	YAMA1_DATA,X
		STA	!BITMAP_OBJDT+EDG1_YM1+5
		LDA	YAMA2_DATA,X
		STA	!BITMAP_OBJDT+EDG1_YM2+5
		LDA	YAMA3_DATA,X
		STA	!BITMAP_OBJDT+EDG1_YM3+5
TR_RM_ST_0990	EQU	$
		M16				; memory 16bit mode
		RTS
;
;;;;K;;;;;
;;;;K;;;;;********************************************************
;;;;K;;;;;*		Rg[				*
;;;;K;;;;;********************************************************
;;;;K;;;;H_MV_DAT	EQU	$
;;;;K;;;;		WORD	00002H,0FFFEH
;;;;K;;;;;
;;;;K;;;;V_MV_DAT	EQU	$-2
;;;;K;;;;		WORD	0FFFEH,00002H
;;;;K;;;;;
;;;;K;;;;H_MV_CMP	EQU	$
;;;;K;;;;		WORD	00030H,0FFD0H
;;;;K;;;;;
;;;;K;;;;V_MV_CMP	EQU	$-2
;;;;K;;;;		WORD	0FF90H,0FFC8H
;;;;K;;;;;
;;;;K;;;;		MEM8
;;;;K;;;;		IDX8
;;;;K;;;;;
;;;;K;;;;TORI_CONTROL	EQU	$
;;;;K;;;;		M16				; memory 16bit mode
;;;;K;;;;		LDA	!END_OBJ_CT
;;;;K;;;;		CMP	#STAFF_CMP-1		;  S␳X^[g ?
;;;;K;;;;		BCC	TR_CNL_100		;	NO -> TR_CNL_100
;;;;K;;;;		LDX	#000
;;;;K;;;;		LDA	<BITMAP_X
;;;;K;;;;		BMI	TR_CNL_030
;;;;K;;;;		BEQ	TR_CNL_050
;;;;K;;;;		INX
;;;;K;;;;		INX
;;;;K;;;;TR_CNL_030	EQU	$
;;;;K;;;;		CLC
;;;;K;;;;		ADC	H_MV_DAT,X
;;;;K;;;;		STA	<BITMAP_X
;;;;K;;;;TR_CNL_050	EQU	$
;;;;K;;;;		LDX	#002
;;;;K;;;;		LDA	<BITMAP_Y
;;;;K;;;;		CMP	#0FFB0H
;;;;K;;;;		BEQ	TR_CNL_090
;;;;K;;;;		BCS	TR_CNL_080
;;;;K;;;;		INX
;;;;K;;;;		INX
;;;;K;;;;TR_CNL_080	EQU	$
;;;;K;;;;		CLC
;;;;K;;;;		ADC	V_MV_DAT,X
;;;;K;;;;		STA	<BITMAP_Y
;;;;K;;;;TR_CNL_090	EQU	$
;;;;K;;;;		BRA	TR_CNL_200
;;;;K;;;;;
;;;;K;;;;TR_CNL_100	EQU	$
;;;;K;;;;		LDA	<KEYC1
;;;;K;;;;		AND	#003H			; EL[nm ?
;;;;K;;;;		BEQ	TR_CNL_140		;	NO -> TR_CNL_140
;;;;K;;;;		AND	#002
;;;;K;;;;		TAX
;;;;K;;;;		LDA	H_MV_DAT,X
;;;;K;;;;		CLC
;;;;K;;;;		ADC	<BITMAP_X
;;;;K;;;;		CMP	H_MV_CMP,X
;;;;K;;;;		BEQ	TR_CNL_140
;;;;K;;;;		STA	<BITMAP_X
;;;;K;;;;TR_CNL_140	EQU	$
;;;;K;;;;		LDA	<KEYC1
;;;;K;;;;		AND	#00CH			; ㉺ L[nm ?
;;;;K;;;;		BEQ	TR_CNL_200		;	NO -> TR_CNL_200
;;;;K;;;;		LSR	A
;;;;K;;;;		TAX
;;;;K;;;;		LDA	V_MV_DAT,X
;;;;K;;;;		CLC
;;;;K;;;;		ADC	<BITMAP_Y
;;;;K;;;;		CMP	V_MV_CMP,X
;;;;K;;;;		BEQ	TR_CNL_200
;;;;K;;;;		STA	<BITMAP_Y
;;;;K;;;;;
;;;;K;;;;TR_CNL_200	EQU	$
;;;;K;;;;		M8				; memory 8bit mode
;;;;K;;;;		I16				; index 16bit mode
;;;;K;;;;		LDY	<TORI_POS
;;;;K;;;;		LDA	<BITMAP_X
;;;;K;;;;		STA	!BITMAP_OBJDT+2,Y
;;;;K;;;;		LDA	<BITMAP_Y
;;;;K;;;;		STA	!BITMAP_OBJDT+3,Y
;;;;K;;;;		I8				; index 8bit mode
;;;;K;;;;TR_CNL_900	EQU	$
;;;;K;;;;		RTS
;
		MEM8
		IDX8
;
;------------------------------------------------------------------------
;-		naif[^						-
;------------------------------------------------------------------------
ENDING_OBJ_DT	EQU	$
;			  +------------------ naiyW
;			  |    +----------------- naiwW
;			  |    |    +---------------- naixW
;			  |    |    |	  +-------------- LN^[{{
;			  |    |    |	  |	  +---------- nai^CvpbgmD
;			  |    |    |	  |	  |
;			  |    |    |	  |	  |
;			  |    |    |	  |	  |
		WORD	05C0H
		BYTE	      072H,0E8H,100H/4,BMP_KUMO0+(0*40H)
		WORD	05C0H
		BYTE	      044H,0E0H,100H/4,BMP_KUMO0+(0*40H)
		WORD	05C0H
		BYTE	      016H,0E2H,100H/4,BMP_KUMO0+(0*40H)
		WORD	05C0H
		BYTE	      0E8H,0D8H,100H/4,BMP_KUMO0+(0*40H)
		WORD	05C0H
		BYTE	      0BAH,0E8H,100H/4,BMP_KUMO0+(0*40H)
		WORD	05C0H
		BYTE	      08CH,0E0H,100H/4,BMP_KUMO0+(0*40H)
;
		WORD	05A0H
		BYTE	      000H,026H,100H/4,BMP_BIGKM+(2*40H)
;
		WORD	0580H
		BYTE	      062H,0E0H,100H/4,BMP_KUMO0+(0*40H)
		WORD	0580H
		BYTE	      034H,0D8H,100H/4,BMP_KUMO0+(0*40H)
		WORD	0580H
		BYTE	      006H,0E8H,100H/4,BMP_KUMO0+(0*40H)
		WORD	0580H
		BYTE	      0D8H,0D8H,100H/4,BMP_KUMO0+(0*40H)
		WORD	0580H
		BYTE	      0AAH,0E0H,100H/4,BMP_KUMO0+(0*40H)
;
		WORD	057CH
		BYTE	      010H,002H,100H/4,BMP_KUMO0+(0*40H)
		WORD	057CH
		BYTE	      0ECH,006H,100H/4,BMP_KUMO0+(0*40H)
		WORD	0578H
		BYTE	      026H,00AH,100H/4,BMP_KUMO0+(0*40H)
		WORD	0578H
		BYTE	      0D7H,00DH,100H/4,BMP_KUMO0+(0*40H)
		WORD	0570H
		BYTE	      0B9H,024H,100H/4,BMP_KUMO0+(0*40H)
		WORD	0570H
		BYTE	      052H,024H,100H/4,BMP_KUMO0+(0*40H)
		WORD	0568H
		BYTE	      016H,014H,100H/4,BMP_KUMO0+(0*40H)
		WORD	0568H
		BYTE	      0E8H,01CH,100H/4,BMP_KUMO0+(0*40H)
		WORD	0568H
		BYTE	      0C0H,00CH,100H/4,BMP_KUMO2+(0*40H)
		WORD	0560H
		BYTE	      044H,01EH,100H/4,BMP_KUMO0+(0*40H)
		WORD	0560H
		BYTE	      0BAH,024H,100H/4,BMP_KUMO0+(0*40H)
		WORD	055CH
		BYTE	      000H,01AH,100H/4,BMP_KUMO2+(0*40H)
		WORD	0558H
		BYTE	      05FH,01AH,100H/4,BMP_KUMO0+(0*40H)
		WORD	0558H
		BYTE	      0ACH,01AH,100H/4,BMP_KUMO0+(0*40H)
;
		WORD	0540H
		BYTE	      07FH,0E2H,100H/4,BMP_KUMO0+(0*40H)
		WORD	0540H
		BYTE	      051H,0D8H,100H/4,BMP_KUMO0+(0*40H)
		WORD	0540H
		BYTE	      023H,0E0H,100H/4,BMP_KUMO0+(0*40H)
		WORD	0540H
		BYTE	      0F5H,0E8H,100H/4,BMP_KUMO0+(0*40H)
		WORD	0540H
		BYTE	      0C7H,0E0H,100H/4,BMP_KUMO0+(0*40H)
		WORD	0540H
		BYTE	      099H,0D8H,100H/4,BMP_KUMO0+(0*40H)
;
		WORD	0500H
		BYTE	      072H,0D8H,100H/4,BMP_KUMO0+(0*40H)
		WORD	0500H
		BYTE	      044H,0DEH,100H/4,BMP_KUMO0+(0*40H)
		WORD	0500H
		BYTE	      016H,0E8H,100H/4,BMP_KUMO0+(0*40H)
		WORD	0500H
		BYTE	      0E8H,0E0H,100H/4,BMP_KUMO0+(0*40H)
		WORD	0500H
		BYTE	      0BAH,0D8H,100H/4,BMP_KUMO0+(0*40H)
		WORD	0500H
		BYTE	      08CH,0E2H,100H/4,BMP_KUMO0+(0*40H)
;
		WORD	04C0H
		BYTE	      072H,0E8H,100H/4,BMP_KUMO0+(0*40H)
		WORD	04C0H
		BYTE	      044H,0E0H,100H/4,BMP_KUMO0+(0*40H)
		WORD	04C0H
		BYTE	      016H,0E2H,100H/4,BMP_KUMO0+(0*40H)
		WORD	04C0H
		BYTE	      0E8H,0D8H,100H/4,BMP_KUMO0+(0*40H)
		WORD	04C0H
		BYTE	      0BAH,0E8H,100H/4,BMP_KUMO0+(0*40H)
		WORD	04C0H
		BYTE	      08CH,0E0H,100H/4,BMP_KUMO0+(0*40H)
;
		WORD	0480H
		BYTE	      062H,0E0H,100H/4,BMP_KUMO0+(0*40H)
		WORD	0480H
		BYTE	      034H,0D8H,100H/4,BMP_KUMO0+(0*40H)
		WORD	0480H
		BYTE	      006H,0F0H,100H/4,BMP_KUMO0+(0*40H)
		WORD	0480H
		BYTE	      0D8H,0D8H,100H/4,BMP_KUMO0+(0*40H)
		WORD	0480H
		BYTE	      0AAH,0E0H,100H/4,BMP_KUMO0+(0*40H)
;
		WORD	0470H
		BYTE	      0F8H,0D8H,100H/4,BMP_KUMO2+(0*40H)
;
		WORD	0440H
		BYTE	      07FH,0E2H,100H/4,BMP_KUMO0+(0*40H)
		WORD	0440H
		BYTE	      051H,0D8H,100H/4,BMP_KUMO0+(0*40H)
		WORD	0440H
		BYTE	      023H,0E0H,100H/4,BMP_KUMO0+(0*40H)
		WORD	0440H
		BYTE	      0F5H,0E8H,100H/4,BMP_KUMO0+(0*40H)
		WORD	0440H
		BYTE	      0C7H,0E0H,100H/4,BMP_KUMO0+(0*40H)
		WORD	0440H
		BYTE	      099H,0D8H,100H/4,BMP_KUMO0+(0*40H)
;
		WORD	0400H
		BYTE	      072H,0D8H,100H/4,BMP_KUMO0+(0*40H)
		WORD	0400H
		BYTE	      044H,0DEH,100H/4,BMP_KUMO0+(0*40H)
		WORD	0400H
		BYTE	      016H,0E8H,100H/4,BMP_KUMO0+(0*40H)
		WORD	0400H
		BYTE	      0E8H,0E0H,100H/4,BMP_KUMO0+(0*40H)
		WORD	0400H
		BYTE	      0BAH,0D8H,100H/4,BMP_KUMO0+(0*40H)
		WORD	0400H
		BYTE	      08CH,0E2H,100H/4,BMP_KUMO0+(0*40H)
;
		WORD	03E0H
		BYTE	      060H,0A0H,100H/4,BMP_KUMO2+(0*40H)
		WORD	03E0H
		BYTE	      0A0H,0B0H,100H/4,BMP_KUMO2+(0*40H)
ENDING1_YM3	EQU	$
		WORD	03E0H
		BYTE	      020H,0E0H,0C0H/4,BMP_YAMA3+(2*40H)
;
		WORD	03C0H
		BYTE	      07FH,0D8H,100H/4,BMP_KUMO0+(0*40H)
		WORD	03C0H
		BYTE	      051H,0E0H,100H/4,BMP_KUMO0+(0*40H)
		WORD	03C0H
		BYTE	      023H,0E8H,100H/4,BMP_KUMO0+(0*40H)
		WORD	03C0H
		BYTE	      0F5H,0D8H,100H/4,BMP_KUMO0+(0*40H)
		WORD	03C0H
		BYTE	      0C7H,0D2H,100H/4,BMP_KUMO0+(0*40H)
		WORD	03C0H
		BYTE	      099H,0E8H,100H/4,BMP_KUMO0+(0*40H)
;
		WORD	03A0H
		BYTE	      090H,090H,100H/4,BMP_KUMO3+(0*40H)
		WORD	03A0H
		BYTE	      070H,0B0H,100H/4,BMP_KUMO2+(0*40H)
ENDING1_YM1	EQU	$
		WORD	03A0H
		BYTE	      010H,0E0H,100H/4,BMP_YAMA1+(0*40H)
;
		WORD	0380H
		BYTE	      062H,0F0H,100H/4,BMP_KUMO0+(0*40H)
		WORD	0380H
		BYTE	      034H,0E0H,100H/4,BMP_KUMO0+(0*40H)
		WORD	0380H
		BYTE	      006H,0D8H,100H/4,BMP_KUMO0+(0*40H)
		WORD	0380H
		BYTE	      0D8H,0DEH,100H/4,BMP_KUMO0+(0*40H)
		WORD	0380H
		BYTE	      0AAH,0E8H,100H/4,BMP_KUMO0+(0*40H)
		WORD	0380H
		BYTE	      070H,0E6H,100H/4,BMP_KUMO1+(0*40H)
;
ENDING1_YM2	EQU	$
		WORD	0360H
		BYTE	      0E0H,0F0H,100H/4,BMP_YAMA2+(2*40H)
;
		WORD	0340H
		BYTE	      072H,0E8H,100H/4,BMP_KUMO0+(0*40H)
		WORD	0340H
		BYTE	      044H,0E0H,100H/4,BMP_KUMO0+(0*40H)
		WORD	0340H
		BYTE	      016H,0E2H,100H/4,BMP_KUMO0+(0*40H)
		WORD	0340H
		BYTE	      0E8H,0D8H,100H/4,BMP_KUMO0+(0*40H)
		WORD	0340H
		BYTE	      0BAH,0E8H,100H/4,BMP_KUMO0+(0*40H)
		WORD	0340H
		BYTE	      08CH,0E0H,100H/4,BMP_KUMO0+(0*40H)
;
		WORD	0320H
		BYTE	      000H,090H,100H/4,BMP_KUMO3+(0*40H)
;
		WORD	0300H
		BYTE	      062H,0E0H,100H/4,BMP_KUMO0+(0*40H)
		WORD	0300H
		BYTE	      034H,0D8H,100H/4,BMP_KUMO0+(0*40H)
		WORD	0300H
		BYTE	      006H,0F0H,100H/4,BMP_KUMO0+(0*40H)
		WORD	0300H
		BYTE	      0D8H,0D8H,100H/4,BMP_KUMO0+(0*40H)
		WORD	0300H
		BYTE	      0AAH,0E0H,100H/4,BMP_KUMO0+(0*40H)
;
		WORD	02E0H
		BYTE	      060H,0A0H,100H/4,BMP_KUMO2+(0*40H)
		WORD	02E0H
		BYTE	      0E0H,0B0H,100H/4,BMP_KUMO2+(0*40H)
ENDING1_YM0	EQU	$
		WORD	02E0H
		BYTE	      0C0H,000H,100H/4,BMP_YAMA0+(0*40H)
;
		WORD	02C0H
		BYTE	      07FH,0E2H,100H/4,BMP_KUMO0+(0*40H)
		WORD	02C0H
		BYTE	      051H,0D8H,100H/4,BMP_KUMO0+(0*40H)
		WORD	02C0H
		BYTE	      023H,0E0H,100H/4,BMP_KUMO0+(0*40H)
		WORD	02C0H
		BYTE	      0F5H,0E8H,100H/4,BMP_KUMO0+(0*40H)
		WORD	02C0H
		BYTE	      0C7H,0E0H,100H/4,BMP_KUMO0+(0*40H)
		WORD	02C0H
		BYTE	      099H,0D8H,100H/4,BMP_KUMO0+(0*40H)
		WORD	02C0H
		BYTE	      07FH,0D6H,100H/4,BMP_KUMO1+(0*40H)
;
		WORD	02A0H
		BYTE	      030H,0B0H,100H/4,BMP_KUMO2+(0*40H)
;
		WORD	0280H
		BYTE	      072H,0D8H,100H/4,BMP_KUMO0+(0*40H)
		WORD	0280H
		BYTE	      044H,0DEH,100H/4,BMP_KUMO0+(0*40H)
		WORD	0280H
		BYTE	      016H,0E8H,100H/4,BMP_KUMO0+(0*40H)
		WORD	0280H
		BYTE	      0E8H,0E0H,100H/4,BMP_KUMO0+(0*40H)
		WORD	0280H
		BYTE	      0BAH,0D8H,100H/4,BMP_KUMO0+(0*40H)
		WORD	0280H
		BYTE	      08CH,0E2H,100H/4,BMP_KUMO0+(0*40H)
		WORD	0280H
		BYTE	      08CH,0D6H,100H/4,BMP_KUMO1+(0*40H)
;
		WORD	0260H
		BYTE	      050H,090H,100H/4,BMP_KUMO3+(0*40H)
;
		WORD	0240H
		BYTE	      07FH,0D8H,100H/4,BMP_KUMO0+(0*40H)
		WORD	0240H
		BYTE	      051H,0E0H,100H/4,BMP_KUMO0+(0*40H)
		WORD	0240H
		BYTE	      023H,0E8H,100H/4,BMP_KUMO0+(0*40H)
		WORD	0240H
		BYTE	      0F5H,0D8H,100H/4,BMP_KUMO0+(0*40H)
		WORD	0240H
		BYTE	      0C7H,0D2H,100H/4,BMP_KUMO0+(0*40H)
		WORD	0240H
		BYTE	      099H,0E8H,100H/4,BMP_KUMO0+(0*40H)
;
		WORD	0200H
		BYTE	      062H,0F0H,100H/4,BMP_KUMO0+(0*40H)
		WORD	0200H
		BYTE	      034H,0E0H,100H/4,BMP_KUMO0+(0*40H)
		WORD	0200H
		BYTE	      006H,0D8H,100H/4,BMP_KUMO0+(0*40H)
		WORD	0200H
		BYTE	      0D8H,0DEH,100H/4,BMP_KUMO0+(0*40H)
		WORD	0200H
		BYTE	      0AAH,0E8H,100H/4,BMP_KUMO0+(0*40H)
;
		WORD	01C0H
		BYTE	      072H,0E8H,100H/4,BMP_KUMO0+(0*40H)
		WORD	01C0H
		BYTE	      044H,0E0H,100H/4,BMP_KUMO0+(0*40H)
		WORD	01C0H
		BYTE	      016H,0E2H,100H/4,BMP_KUMO0+(0*40H)
		WORD	01C0H
		BYTE	      0E8H,0D8H,100H/4,BMP_KUMO0+(0*40H)
		WORD	01C0H
		BYTE	      0BAH,0E8H,100H/4,BMP_KUMO0+(0*40H)
		WORD	01C0H
		BYTE	      08CH,0E0H,100H/4,BMP_KUMO0+(0*40H)
;
		WORD	0180H
		BYTE	      062H,0E0H,100H/4,BMP_KUMO0+(0*40H)
		WORD	0180H
		BYTE	      034H,0D8H,100H/4,BMP_KUMO0+(0*40H)
		WORD	0180H
		BYTE	      006H,0E8H,100H/4,BMP_KUMO0+(0*40H)
		WORD	0180H
		BYTE	      0D8H,0D8H,100H/4,BMP_KUMO0+(0*40H)
		WORD	0180H
		BYTE	      0AAH,0E0H,100H/4,BMP_KUMO0+(0*40H)
;
		WORD	0140H
		BYTE	      07FH,0E2H,100H/4,BMP_KUMO0+(0*40H)
		WORD	0140H
		BYTE	      051H,0D8H,100H/4,BMP_KUMO0+(0*40H)
		WORD	0140H
		BYTE	      023H,0E0H,100H/4,BMP_KUMO0+(0*40H)
		WORD	0140H
		BYTE	      0F5H,0E8H,100H/4,BMP_KUMO0+(0*40H)
		WORD	0140H
		BYTE	      0C7H,0E0H,100H/4,BMP_KUMO0+(0*40H)
		WORD	0140H
		BYTE	      099H,0D8H,100H/4,BMP_KUMO0+(0*40H)
;
		WORD	0100H
		BYTE	      072H,0D8H,100H/4,BMP_KUMO0+(0*40H)
		WORD	0100H
		BYTE	      044H,0DEH,100H/4,BMP_KUMO0+(0*40H)
		WORD	0100H
		BYTE	      016H,0E8H,100H/4,BMP_KUMO0+(0*40H)
		WORD	0100H
		BYTE	      0E8H,0E0H,100H/4,BMP_KUMO0+(0*40H)
		WORD	0100H
		BYTE	      0BAH,0D8H,100H/4,BMP_KUMO0+(0*40H)
		WORD	0100H
		BYTE	      08CH,0E2H,100H/4,BMP_KUMO0+(0*40H)
;
		WORD	00C0H
		BYTE	      072H,0E8H,100H/4,BMP_KUMO0+(0*40H)
		WORD	00C0H
		BYTE	      044H,0E0H,100H/4,BMP_KUMO0+(0*40H)
		WORD	00C0H
		BYTE	      016H,0E2H,100H/4,BMP_KUMO0+(0*40H)
		WORD	00C0H
		BYTE	      0E8H,0D8H,100H/4,BMP_KUMO0+(0*40H)
		WORD	00C0H
		BYTE	      0BAH,0E8H,100H/4,BMP_KUMO0+(0*40H)
		WORD	00C0H
		BYTE	      08CH,0E0H,100H/4,BMP_KUMO0+(0*40H)
;
		WORD	0080H
		BYTE	      062H,0E0H,100H/4,BMP_KUMO0+(0*40H)
		WORD	0080H
		BYTE	      034H,0D8H,100H/4,BMP_KUMO0+(0*40H)
		WORD	0080H
		BYTE	      006H,0F0H,100H/4,BMP_KUMO0+(0*40H)
		WORD	0080H
		BYTE	      0D8H,0D8H,100H/4,BMP_KUMO0+(0*40H)
		WORD	0080H
		BYTE	      0AAH,0E0H,100H/4,BMP_KUMO0+(0*40H)
;
		WORD	0070H
		BYTE	      0F8H,0D8H,100H/4,BMP_KUMO2+(0*40H)
;
		WORD	0040H
		BYTE	      07FH,0E2H,100H/4,BMP_KUMO0+(0*40H)
		WORD	0040H
		BYTE	      051H,0D8H,100H/4,BMP_KUMO0+(0*40H)
		WORD	0040H
		BYTE	      023H,0E0H,100H/4,BMP_KUMO0+(0*40H)
		WORD	0040H
		BYTE	      0F5H,0E8H,100H/4,BMP_KUMO0+(0*40H)
		WORD	0040H
		BYTE	      0C7H,0E0H,100H/4,BMP_KUMO0+(0*40H)
		WORD	0040H
		BYTE	      099H,0D8H,100H/4,BMP_KUMO0+(0*40H)
;
		WORD	0000H
		BYTE	      072H,0D8H,100H/4,BMP_KUMO0+(0*40H)
		WORD	0000H
		BYTE	      044H,0DEH,100H/4,BMP_KUMO0+(0*40H)
		WORD	0000H
		BYTE	      016H,0E8H,100H/4,BMP_KUMO0+(0*40H)
		WORD	0000H
		BYTE	      0E8H,0E0H,100H/4,BMP_KUMO0+(0*40H)
		WORD	0000H
		BYTE	      0BAH,0D8H,100H/4,BMP_KUMO0+(0*40H)
		WORD	0000H
		BYTE	      08CH,0E2H,100H/4,BMP_KUMO0+(0*40H)
;
EDG_OBJ_TORI0	EQU	$
		WORD	0000H
		BYTE	      000H,0B0H,040H/4,BMP_TORI00+(3*40H)
;
		WORD	0FFFFH		; GhR[h
;
;
ENDING_OBJ_DT2	EQU	$
;;;;K;;;;ENDING2__KUMO0 EQU	$
;;;;K;;;;		WORD	01C2H
;;;;K;;;;		BYTE	      088H,020H,100H/4,BMP_BIGKM0+(2*40H)
;;;;K;;;;ENDING2__KUMO2 EQU	$
;;;;K;;;;		WORD	01C0H
;;;;K;;;;		BYTE	      078H,020H,100H/4,BMP_BIGKM2+(2*40H)
;;;;K;;;;;
;;;;K;;;;ENDING2__KUMO1 EQU	$
;;;;K;;;;		WORD	0179H
;;;;K;;;;		BYTE	      088H,07FH,1C0H/4,BMP_BIGKM1+(2*40H)
;;;;K;;;;ENDING2__KUMO3 EQU	$
;;;;K;;;;		WORD	0178H
;;;;K;;;;		BYTE	      078H,07FH,1C0H/4,BMP_BIGKM3+(2*40H)
;;;;K;;;;;
;;;;K;;;;EDG_OBJ_TORI1	EQU	$
;;;;K;;;;		WORD	0000H
;;;;K;;;;		BYTE	      000H,000H,040H/4,BMP_TORI00+(3*40H)
EDG_OBJ_TORI1	EQU	$
		WORD	0000H
		BYTE	      000H,0B4H,080H/4,BMP_TORI00+(3*40H)
;
		WORD	0FFFFH		; GhR[h
;
;
ENDING_OBJ_DT3	EQU	$
		WORD	0130H
		BYTE		000H,040H,2C0H/4,BMP_OKA+(2*40H)
EDG_OBJ_FLY	EQU	$
		WORD	0300H
		BYTE		070H,010H,100H/4,BMP_FTORI0+(0*40H)
		WORD	0110H
		BYTE		000H,028H,100H/4,BMP_HOME+(0*40H)
EDG_OBJ_TORI2	EQU	$
		WORD	0100H
		BYTE		018H,020H,100H/4,BMP_STORI0+(0*40H)
;
ENDING3_KM0	EQU	$
		WORD	00E0H
		BYTE		00CH,030H,100H/4,BMP_DKS0+(3*40H)
ENDING3_KM1	EQU	$
		WORD	00D0H
		BYTE		018H,0F8H,100H/4,BMP_UKS+(3*40H)
ENDING3_KM2	EQU	$
		WORD	00E0H
		BYTE		0F4H,030H,100H/4,BMP_DKS1+(3*40H)
ENDING3_KM3	EQU	$
		WORD	00D0H
		BYTE		0D8H,0F8H,100H/4,BMP_UKS+(3*40H)
;
ENDING3_KM4	EQU	$
		WORD	00D0H
		BYTE		030H,030H,150H/4,BMP_DKS0+(3*40H)
ENDING3_KM5	EQU	$
		WORD	00A0H
		BYTE		028H,0F8H,140H/4,BMP_UKS+(3*40H)
ENDING3_KM6	EQU	$
		WORD	00D0H
		BYTE		0C8H,030H,150H/4,BMP_DKS1+(3*40H)
ENDING3_KM7	EQU	$
		WORD	00A0H
		BYTE		0C8H,0F8H,140H/4,BMP_UKS+(3*40H)
;
		WORD	0FFFFH		; GhR[h
ENDING_OBJ_DT_E EQU	$
;
;
EDG_TORI0	EQU	EDG_OBJ_TORI0-ENDING_OBJ_DT
EDG1_YM0	EQU	ENDING1_YM0-ENDING_OBJ_DT
EDG1_YM1	EQU	ENDING1_YM1-ENDING_OBJ_DT
EDG1_YM2	EQU	ENDING1_YM2-ENDING_OBJ_DT
EDG1_YM3	EQU	ENDING1_YM3-ENDING_OBJ_DT
;
;;;;K;;;;EDG_KM0		EQU	ENDING2__KUMO0-ENDING_OBJ_DT2
;;;;K;;;;EDG_KM1		EQU	ENDING2__KUMO1-ENDING_OBJ_DT2
;;;;K;;;;EDG_KM2		EQU	ENDING2__KUMO2-ENDING_OBJ_DT2
;;;;K;;;;EDG_KM3		EQU	ENDING2__KUMO3-ENDING_OBJ_DT2
EDG_TORI1	EQU	EDG_OBJ_TORI1-ENDING_OBJ_DT2
;
EDG_FLY		EQU	EDG_OBJ_FLY-ENDING_OBJ_DT3
EDG_TORI2	EQU	EDG_OBJ_TORI2-ENDING_OBJ_DT3
EDG3_KM0	EQU	ENDING3_KM0-ENDING_OBJ_DT3
EDG3_KM1	EQU	ENDING3_KM1-ENDING_OBJ_DT3
EDG3_KM2	EQU	ENDING3_KM2-ENDING_OBJ_DT3
EDG3_KM3	EQU	ENDING3_KM3-ENDING_OBJ_DT3
EDG3_KM4	EQU	ENDING3_KM4-ENDING_OBJ_DT3
EDG3_KM5	EQU	ENDING3_KM5-ENDING_OBJ_DT3
EDG3_KM6	EQU	ENDING3_KM6-ENDING_OBJ_DT3
EDG3_KM7	EQU	ENDING3_KM7-ENDING_OBJ_DT3
;
;
;------------------------------------------------------------------------
;-		nai^Cvx					-
;------------------------------------------------------------------------
BMP_TORI00	EQU	(BMP_OBJ_TORI00-BITMAP_OBJ_TBL)/7
BMP_TORI01	EQU	(BMP_OBJ_TORI01-BITMAP_OBJ_TBL)/7
BMP_TORI02	EQU	(BMP_OBJ_TORI02-BITMAP_OBJ_TBL)/7
BMP_TORI03	EQU	(BMP_OBJ_TORI03-BITMAP_OBJ_TBL)/7
BMP_TORI04	EQU	(BMP_OBJ_TORI04-BITMAP_OBJ_TBL)/7
BMP_TORI05	EQU	(BMP_OBJ_TORI05-BITMAP_OBJ_TBL)/7
BMP_TORI06	EQU	(BMP_OBJ_TORI06-BITMAP_OBJ_TBL)/7
BMP_TORI07	EQU	(BMP_OBJ_TORI07-BITMAP_OBJ_TBL)/7
BMP_TORI08	EQU	(BMP_OBJ_TORI08-BITMAP_OBJ_TBL)/7
BMP_TORI09	EQU	(BMP_OBJ_TORI09-BITMAP_OBJ_TBL)/7
BMP_TORI10	EQU	(BMP_OBJ_TORI10-BITMAP_OBJ_TBL)/7
BMP_TORI11	EQU	(BMP_OBJ_TORI11-BITMAP_OBJ_TBL)/7
BMP_TORI12	EQU	(BMP_OBJ_TORI12-BITMAP_OBJ_TBL)/7
BMP_YAMA0	EQU	(BMP_OBJ_YAMA0-BITMAP_OBJ_TBL)/7
BMP_YAMA1	EQU	(BMP_OBJ_YAMA1-BITMAP_OBJ_TBL)/7
BMP_YAMA2	EQU	(BMP_OBJ_YAMA2-BITMAP_OBJ_TBL)/7
BMP_YAMA3	EQU	(BMP_OBJ_YAMA3-BITMAP_OBJ_TBL)/7
BMP_KUMO0	EQU	(BMP_OBJ_KUMO0-BITMAP_OBJ_TBL)/7
BMP_KUMO1	EQU	(BMP_OBJ_KUMO1-BITMAP_OBJ_TBL)/7
BMP_KUMO2	EQU	(BMP_OBJ_KUMO2-BITMAP_OBJ_TBL)/7
BMP_KUMO3	EQU	(BMP_OBJ_KUMO3-BITMAP_OBJ_TBL)/7
BMP_BIGKM	EQU	(BMP_OBJ_BIGKUM-BITMAP_OBJ_TBL)/7
BMP_BIGKM0	EQU	BMP_BIGKM
BMP_BIGKM1	EQU	BMP_BIGKM
BMP_BIGKM2	EQU	BMP_BIGKM
BMP_BIGKM3	EQU	BMP_BIGKM
BMP_HOME	EQU	(BMP_OBJ_HOME-BITMAP_OBJ_TBL)/7
BMP_OKA		EQU	(BMP_OBJ_OKA-BITMAP_OBJ_TBL)/7
BMP_UKS		EQU	(BMP_OBJ_UKS-BITMAP_OBJ_TBL)/7
BMP_DKS0	EQU	(BMP_OBJ_DKS0-BITMAP_OBJ_TBL)/7
BMP_DKS1	EQU	(BMP_OBJ_DKS1-BITMAP_OBJ_TBL)/7
BMP_STORI0	EQU	(BMP_OBJ_STORI0-BITMAP_OBJ_TBL)/7
BMP_STORI1	EQU	(BMP_OBJ_STORI1-BITMAP_OBJ_TBL)/7
BMP_STORI2	EQU	(BMP_OBJ_STORI2-BITMAP_OBJ_TBL)/7
BMP_STORI3	EQU	(BMP_OBJ_STORI3-BITMAP_OBJ_TBL)/7
BMP_STORI4	EQU	(BMP_OBJ_STORI4-BITMAP_OBJ_TBL)/7
BMP_STORI5	EQU	(BMP_OBJ_STORI5-BITMAP_OBJ_TBL)/7
BMP_STORI6	EQU	(BMP_OBJ_STORI6-BITMAP_OBJ_TBL)/7
BMP_FTORI0	EQU	(BMP_OBJ_FTORI0-BITMAP_OBJ_TBL)/7
BMP_FTORI1	EQU	(BMP_OBJ_FTORI1-BITMAP_OBJ_TBL)/7
BMP_FTORI2	EQU	(BMP_OBJ_FTORI2-BITMAP_OBJ_TBL)/7
BMP_FTORI3	EQU	(BMP_OBJ_FTORI3-BITMAP_OBJ_TBL)/7
BMP_FTORI4	EQU	(BMP_OBJ_FTORI4-BITMAP_OBJ_TBL)/7
BMP_FTORI5	EQU	(BMP_OBJ_FTORI5-BITMAP_OBJ_TBL)/7
BMP_FTORI6	EQU	(BMP_OBJ_FTORI6-BITMAP_OBJ_TBL)/7
BMP_FTORI7	EQU	(BMP_OBJ_FTORI7-BITMAP_OBJ_TBL)/7
BMP_FTORI8	EQU	(BMP_OBJ_FTORI8-BITMAP_OBJ_TBL)/7
BMP_FTORI9	EQU	(BMP_OBJ_FTORI9-BITMAP_OBJ_TBL)/7
BMP_FTORIA	EQU	(BMP_OBJ_FTORIA-BITMAP_OBJ_TBL)/7
;
;
;
;
;
		END
