;************************************************************************
;*									*
;*	title name	: "yossy"					*
;*	proccess	: game play main				*
;*	file name	: ys_game					*
;*									*
;************************************************************************
;
;
		SALL
;
		include		ys_header.inc
		include		ys_unit.h
		include		ys_color.h
		include		ys_msg.h
		include		ys_presno.h
		include		ys_pld.h
		include		ys_ename.h
;
		XALL
;
;
;------------------------------------------------------------------------
;-		global symbol						-
;------------------------------------------------------------------------
		GLB	GMINIT,GMPLAY,GMPLAY2,GMFADE,GMGOAL
		GLB	INHDMA,BGM_SET
		GLB	MSG_BTMP_CLR,MSGDSP,MSGDSP_X
		GLB	BG3SCRCLR,BG3WANCLR,BG3WTRCLR
		GLB	GLBG1SCRCLR,GOAL_B1SCRDAT
		GLB	DWNMOJI_DAT,GLBG3SCRCLR
		GLB	BOSCLR_SCORE
		GLB	BGCOIN_SETCHK,HALF_INIT,HALF_SLCT
		GLB	MD7_MATRIX_SET,BOSSQ_MD7_SET
		GLB	EGG_SAVE,EGG_LOAD
		GLB	COS_AGAIN_INT,CORS_AGAIN
		GLB	GMURAMCLR
;
		GLB	BGCIN_STCHK_ADR,BGCIN_STCHK_DAT
		GLB	HALF_MSG_DAT,Pause_move,AGAIN_WAIT_SET
;
		GLB	HDMAP5,HDMAPD5,HDMAP6,HDMAPD6
		GLB	HDMAPD5_NO
;
		GLB	sagi1
;
;------------------------------------------------------------------------
;-		extern symbol						-
;------------------------------------------------------------------------
;
;-------------< ys_main >------------------------------------------------
		EXT	OAMDXCLR,VRAMCL,URAMCLR,OAMCLR,VMADSPL,DMA_M_M
		EXT	DMA_D_M,BLNKOFF
		EXT	SOUND_TR,SOUND_3_ON,RANDAM
;
		EXT	GMIN,GMPL,HMPIN,BNSGM,BNSMV,B3CL,WNCL,B3WRCL
		EXT	INT_GM,HMPFAD,GM_CTN
		EXT	W1_0_SOUND
;
;-------------< ys_rpro >------------------------------------------------
		EXT	CHIPON,CHIPON1,CHIPON_RAM_READ
		EXT	NEWVMADL,BGCDMA_L
		EXT	GLB1CL,BG1DT,GLB3CL,HF_DT,VMADSPL
;
;-------------< ys_mini >------------------------------------------------
		EXT	MINIINIT
;
;-------------< ys_init >------------------------------------------------
		EXT	GMCHRST,GMCOLST,GMMDST,VRAMDX_ST
		EXT	DBLTELESA,DBLCOLST
		EXT	DIVDTST,M_DMA_BFST,M_DMA_BFST_N,UNCOMPRES
		EXT	OBJCHRBK,CHRSET,UNCOMPRES_X
		EXT	GM01,GM02,GM03,GM04,GM05,GM06,GM07
		EXT	GM08,GM09,GM0A,GM0B,GM0C,GMMD7,GM0D,GM0E,GM0F,GM10
;
;-------------< ys_title >-----------------------------------------------
		EXT	MODINC,MODINC2
;
;-------------< ys_play >------------------------------------------------
		EXT	PLINIT,PLINIT_2,PLSCRL_INIT,PLAYER,PLCSET,PLSCRL
		EXT	SCRL_CXY_SET
		EXT	TIMEUP_SET,BERO_CANCEL
		EXT	PTTL,PRET,PSTP,PCLR,PBQ7,PDKN
		EXT	PFLP
;
;-------------< ys_enmy >------------------------------------------------
		EXT	ENEMY,ENINSB,ENCSET,ENRAMCLR,ENINSR,EGGSET,ENINSR2
		EXT	ENINSR_I
		EXT	QKM_COIN_XSP
		EXT	BABYM,EGG00,EGG09,MSTAR,BOSSQ,YSEGG
		EXT	EFAIL,ECHNG
;
;-------------< ys_enmy3 >-----------------------------------------------
		EXT	MARIO_CHANGE
		EXT	KUMOB_SET,ITEGG_INIT,TO_COIN_CHANGE
;
;-------------< ys_exst >------------------------------------------------
		EXT	EXINSR
;
;-------------< ys_data >------------------------------------------------
		EXT	DIVDAT,SIN,COS
;
;-------------< ys_msgdt >-----------------------------------------------
		EXT	MSG_DOCA
;
		EXT	MIS_MSG,HF_MSG,AGN_MSG
;
;-------------< ys_bgsc >------------------------------------------------
		EXT	BGINT,BGSET,BG3SCK,UNITST,BGSTATST,UNITST_SUB
		EXT	CORSIN_WIND_ST
;
;-------------< ys_bgsc0 >-----------------------------------------------
		EXT	RND_RND
;
;-------------< ys_mapdt >-----------------------------------------------
		EXT	MPSTATBL,MPSTATUS,INT_STAT
		EXT	HFSTTUS,HFSTATBL
		EXT	COURSTBL
		EXT	CORS_MIN0
;
;------------------------------------------------------------------------
;-		define symbol						-
;------------------------------------------------------------------------
;;;;		EQU
;
;
;
;************************************************************************
;*									*
;*		program start						*
;*									*
;************************************************************************
;
;
		EXTEND
;
;
		MEM8
		IDX8
;
Group_1		GROUP	Game_pro
Game_pro	SECT	REL
;
;************************************************************************
;*		game use ram clear					*
;************************************************************************
GMURAMCLR	EQU	$
		JSL	>URAMCLR
;
		M16
;
;-------------- afRʈʒuZbg ------------------------------------
		LDA	#04000H		;(A) <-- afRʈʒuij
		STA	WATER_Y
;
;-------------- }IG^C}[NA[ ------------------------------
		STZ	SUPER_FLAG
;
		M8
;
		RTL
;
;************************************************************************
;*		game initial						*
;************************************************************************
;
;------------------------------------------------------------------------
;-		ʃ[h^Cvf[^					-
;------------------------------------------------------------------------
GMMDNOD		EQU	$	;[DSPMOD]
		BYTE	GM01	;[00:nAR[XȂǁi{^Cvj]
		BYTE	GM02	;[01:OafR}XN]
		BYTE	GM03	;[02:]
		BYTE	GM04	;[03:n⃂[hQ]
		BYTE	GM05	;[04:ouafR}XN]
		BYTE	GM06	;[05:Jx]
		BYTE	GM07	;[06:X̂]
		BYTE	GM08	;[07:WQAAz[afRR[X]
		BYTE	GM09	;[08:~R[X]
		BYTE	GM0A	;[09:{X@[hVp]
		BYTE	GM0B	;[0A:[hO  _u eTp]
		BYTE	GM0C	;[0B:hJ]
		BYTE	GM0D	;[0C:afQG]
		BYTE	GM0E	;[0D:afQGQQ[̈ݑ]
		BYTE	GM0F	;[0E:afR}XN]
		BYTE	GM10	;[0F:Ⴞ񂾂ރR[X]
;
GMINIT		EQU	$
		JSL	>VRAMCL		;VRAM clear
		JSL	>GMURAMCLR	;use RAM clear
;
;-------------- Gq`lNA[ ----------------------------------------
		JSL	>ENRAMCLR
;
;------------------------------------------------------------------------
;-		course data initial set					-
;------------------------------------------------------------------------
		LDA	NEXTGOTO	; next go to ?
		BEQ	GMINIT_000	;	YES -> GMINIT_000
		JMP	GMIN010
;
;----------------------------------------------------------------
;-		1st course data set				-
;----------------------------------------------------------------
;
;-------------- Q[vCq`lNA[ ------------------
;
GMINIT_000	EQU	$
		M16
;
		LDY	#00		;(Y) <-- 0 clear
		STZ	<WORK21		;(WK20,21,22) <-- to memory address
		LDA	#GM_INIT_RAM_S
		STA	<WORK20
		LDA	#GM_INIT_RAM_SE ;(A) <-- number of byte
		JSL	>DMA_D_M
;
		M8
;
		MI16
;
;-------------- ዾtONA[ ----------------------------
		STZ	GRASS_ON
;
;-------------- RC̕\`FbNp ------------------------
		LDX	#(SV_COIN_BF1-SV_COIN_BF0)/2-2
GMINIT_005	EQU	$
		STZ	!SV_COIN_BF0+000H,X
		STZ	!SV_COIN_BF0+040H,X
		STZ	!SV_COIN_BF1+000H,X
		STZ	!SV_COIN_BF1+040H,X
		STZ	!SV_COIN_BF2+000H,X
		STZ	!SV_COIN_BF2+040H,X
		STZ	!SV_COIN_BF3+000H,X
		STZ	!SV_COIN_BF3+040H,X
		DEX
		DEX
		BPL	GMINIT_005
;
;-------------- R[Xf[^AhXZbg ----------------------
		LDA	#100		;initial timer set
		STA	!TIMER
		STZ	!TIMER_LOW
		STZ	!TIMER_MID
		LDA	#00001
		STA	!TIMER_HI
;;;;K;;;;		LDA	#300		;initial timer set
;;;;K;;;;		STA	!TIMER
;;;;K;;;;		STZ	!TIMER_LOW
;;;;K;;;;		STZ	!TIMER_MID
;;;;K;;;;		LDA	#00003
;;;;K;;;;		STA	!TIMER_HI
;
		LDA	MAPOINT
		ASL	A
		TAX
		LDA	>MPSTATBL,X
		TAX
;
		LDA	>MPSTATUS+1,X	;player start X pos set
		AND	#00FFH
		ASL	A
		ASL	A
		ASL	A
		ASL	A
		STA	PLXPSL
		LDA	>MPSTATUS+2,X	;      "      Y    "
		AND	#00FFH
		ASL	A
		ASL	A
		ASL	A
		ASL	A
		STA	PLYPSL
		LDA	>MPSTATUS,X	;course data pointer set
		JMP	GMIN020
;
;----------------------------------------------------------------
;-		next go to course data set			-
;----------------------------------------------------------------
GMIN010		EQU	$
;
		MI16
;
		STZ	!TIMCNT_UP
;
;-------------- mdws  fnsn  R[Xf[^Zbg ----------
		LDA	NEXTGOTO
		DEC	A		;ϐgł̂mdws fnsnH
		BEQ	MINIGAME_CHK	;	NO -> MINIGAME_CHK
		JMP	GMIN030
;
MINIGAME_CHK	EQU	$
		LDX	NEXTGOTO_POS
;
;-------------- fnsn ~jQ[ `FbN --------------------
		LDA	>NXGOTOBF+0,X
		AND	#000FFH
		CMP	#CORS_MIN0	; next goto mini game ?
		BCC	MINIGAME_PAS	;	NO -> MINIGAME_PAS
;;;;K;;;;		SEC
		SBC	#CORS_MIN0
		ASL	A
		STA	!MINIMD		;~j Q[ [hm. Zbg
		LDA	>NXGOTOBF+3,X
		AND	#000FFH
		STA	!MINI_SVBUF+0	; ߂ꏊ̃e[uf[^
		LDA	>NXGOTOBF+1,X
		STA	!MINI_SVBUF+1	; v[[̖߂ꏊ
		LDA	!TIMER
		STA	!MINI_SVBUF+3	; ^C}[
;;;;		    JSL	    >EGG_SAVE	    ; ^}S Z[u ǁ` !!
		JMP	>MINIINIT	; ~j Q[ X^[g !!
;
MINIGAME_PAS	EQU	$
		LDA	>NXGOTOBF+1,X	;player start X pos set
		AND	#00FFH
		ASL	A
		ASL	A
		ASL	A
		ASL	A
		STA	PLXPSL
		LDA	>NXGOTOBF+2,X	;      "      Y    "
		AND	#00FFH
		ASL	A
		ASL	A
		ASL	A
		ASL	A
		STA	PLYPSL
		LDA	>NXGOTOBF+3,X
		AND	#00FFH
		STA	!PLMODE
		LDA	>NXGOTOBF+0,X	;course data pointer set
;
;----------------------------------------------------------------
;-		course data set					-
;----------------------------------------------------------------
GMIN020		EQU	$
		AND	#00FFH
		ASL	A		;
		STA	<WORK		;
		ASL	A		; x6
;;;;		CLC			;
		ADC	<WORK		;
		TAX
;
;-------------- BG course data set ------------------------------
		LDA	>COURSTBL,X	;BG course data address set
		STA	<BGDTADR
		LDA	>COURSTBL+1,X
		STA	<BGDTADR+1
;
;-------------- enemy data address set --------------------------
		LDA	>COURSTBL+3,X	;enemy data address set
		STA	>EDTADR
		LDA	>COURSTBL+5,X
		AND	#00FFH
		STA	>EDTADR+2
;
GMIN030		EQU	$
		STZ	!BNS_GO_FG	;{[iX Q[ tO NA
;
		MI8
;
		JSL	>BGSTATST	;R[Xf[^ Xe[^Xf[^Zbg
;
;------------------------------------------------------------------------
;-		afRʈʒuZbg					-
;------------------------------------------------------------------------
;
		M16
;
		LDA	#07B0H		;(A) <-- afRʈʒuij
		LDX	BG3TYP
		CPX	#13H
		BEQ	GMIN030_050
		CPX	#1DH
		BNE	GMIN030_100
		LDA	#0700H		;(A) <-- afRʈʒuij
GMIN030_050	EQU	$
		STA	WATER_Y
GMIN030_100	EQU	$
;
		M8
;
;------------------------------------------------------------------------
;-		TEhvO]iQ[vCj			-
;------------------------------------------------------------------------
		LDA	!MAPOINT
		CMP	#INT_STAT
		BNE	GMIN030_150	;Pv|OH ( no:GMIN030_150 )
;
		LDA	#W1_0_SOUND	;(X) <-- TEhvO]e[umD
		STA	BGM_NO
GMIN030_150	EQU	$
		JSL	>SOUND_TR
GMIN030_180	EQU	$
;
;-----------------------------------------------------------------------
;-	[hVp̃LN^[ƃJ[Zbg				-
;-----------------------------------------------------------------------
		LDA	!DSPMOD
		CMP	#009
		BNE	GMIN030_200
		JSR	MD7CHRCOL
		BRA	GMIN030_250
;
;------------------------------------------------------------------------
;-	_ueTp LN^[ƃJ[Zbg			-
;------------------------------------------------------------------------
GMIN030_200	EQU	$
		CMP	#00AH
		BNE	GMIN030_210
		JSL	>DBLTELESA
		JSL	>DBLCOLST
		BRA	GMIN030_250
;
;------------------------------------------------------------------------
;-		character set						-
;------------------------------------------------------------------------
GMIN030_210	EQU	$
		JSL	>GMCHRST	;R[XLN^[Zbg
		JSL	>BGCDMA_L	;]LN^[Zbg
;
;------------------------------------------------------------------------
;-	tJR[Xp tgubN LN^[ `FbNZbg	-
;------------------------------------------------------------------------
		LDA	!BG1TYP
		CMP	#003
		BNE	GMIN030_220
		JSR	FUKAN_LIFT
;
;------------------------------------------------------------------------
;-		color set						-
;------------------------------------------------------------------------
GMIN030_220	EQU	$
		JSL	>GMCOLST	;color set
;
;------------------------------------------------------------------------
;-		PPU Reg. set						-
;------------------------------------------------------------------------
GMIN030_230	EQU	$
		LDY	DSPMOD
		LDX	!GMMDNOD,Y	;(X) <-- game mode type no.
		JSL	>GMMDST		;game mode set
;;;;K;;;;;
;;;;K;;;;;------------------------------------------------------------------------
;;;;K;;;;;-		mater initial set					-
;;;;K;;;;;------------------------------------------------------------------------
;;;;K;;;;		JSR	METERIT		;meter initial
;
;------------------------------------------------------------------------
;-		H-DMA initial set					-
;------------------------------------------------------------------------
GMIN030_250	EQU	$
		JSL	>INHDMA		;H-DMA initial set
;
;------------------------------------------------------------------------
;-		BG screen set						-
;------------------------------------------------------------------------
		LDA	!DSPMOD
		CMP	#009
		BEQ	GMIN030_260
		CMP	#00AH
		BEQ	GMIN030_260
		JSR	BG2_SCR_INIT	;afQXN[Zbg
		JSR	BG3_SCR_INIT	;afR	       h
;
;------------------------------------------------------------------------
;-		Etc initial set						-
;------------------------------------------------------------------------
GMIN030_260	EQU	$
		JSL	>DIVDTST	;div data set
;
;------------------------------------------------------------------------
;-		1st game play initial set				-
;------------------------------------------------------------------------
		LDA	NEXTGOTO
		BEQ	GMIN032		;next go to ? ( no:GMIN032 )
		JMP	GMIN100
;
;-------------- CjVX^[g --------------------------------------
GMIN032		EQU	$
		LDA	#0FH
		STA	FADNO		;fade no set
		LDA	#01H
		STA	FADMK		;fade muki
;
;-------------- R[Xf[^afZbg ----------------------
		JSL	>BGINT		;BG initial write
;
;-------------- R[XC^CgfvC[Zbg ------
		LDX	#16*8-1		;XN[Zbg
GMIN034		EQU	$
		STZ	UNBUFAD,X
		DEX
		BPL	GMIN034
;
		M16
;
		LDA	PLXPSL	       ;vC[oʒuZbg
		SEC
		SBC	#18H+78H
		STA	PLXPSL
		CLC
		ADC	#018H
		STA	ESCCH1
		LDA	PLYPSL
		SEC
;;;;		    SBC	    #084H
		SBC	#084H+10H
		STA	ESCCV1
		INC	PLJUMP		;WvtOhnmhiXN[rsnoj
;
;-------------- vC[Zbg ----------------------------
		JSL	>PLINIT_2	;player initial
;
		M16
;
		LDA	#P006		;vC[ԃZbg
		STA	PLJUMP
		LDA	#0280H
		STA	PLMVSP
		LDA	#0FC00H
		STA	PLYSPD
		LDA	#PTTL
		STA	PLMODE
;
		M8
;
;-------------- R[XC^Cgfrbg}bvNA[ --
		JSL	>MSG_BTMP_CLR
;
;-------------- R[XC^CgEBhEZbg ----------
		LDA	#001H		;hoJ{hEBhEZbg
		STA	GMFADE_FLG0
;
		M16
;
		LDA	#02H		;荞݃vOmDZbg
		STA	NMI_PROG_NO
		LDA	#0120H		;EBhEZbg
		STA	GMFADE_CT
		JSL	>CORSIN_WIND_ST
;
		MEM8
;
		LDA	#03H		;[]
		STA	<SOUND_0
;
;-------------- NMI-IRQ "ON" ------------------------------------
		LDA	#02H		;IRQ counter set
		STA	IRQFLG
;;;;		    LDA	    #070H	    ;H counter set
		LDA	#050H		;H counter set
		STA	4207H
		LDA	#0D8H		;V counter set
		STA	4209H
		LDA	#10110001B	;timer IRQ "ON"
		STA	4200H
;
;-------------- R[Xf[^WJ --------------------------------
		JSL	>UNITST_SUB
;
		M16
;
GMIN040		EQU	$
		LDA	INCSTIM
		CMP	#0C0H
		BCC	GMIN040		;\IH ( no:GMIN040 )
;
		LDA	#07FFFH
		STA	>DATACOL+008*020H+4
		M8
;
		STZ	NMI_PROG_NO
;
;-------------- R[Xf[^afZbgZbg ------------
;
		M16
;
		LDA	<SCCV1
		STA	WRSCV1
		LDA	<SCCH1
		SEC
		SBC	#0100H
		STA	WRSCH1
;
		M8
;
		INC	MODENO		;[ +2 ]
		BRA	GMIN150
;
;-------------- mdws  fnsn  X^[g ----------------------------
GMIN100		EQU	$
		DEC	A		;[ CMP #01H ]
		BNE	GMIN110		;ϐgł̂mdws  fnsnH ( yes:GMIN110 )
;
;-------------- R[Xf[^WJ --------------------------------
		JSL	>UNITST_SUB
;
GMIN110		EQU	$
;
;-------------- vC[Zbg ----------------------------
		JSL	>PLINIT		;player initial
;
;-------------- GZbg ------------------------------------
		JSL	>ENINSB		;enemy initial set
;
;-------------- XN[JE^[Zbg ------------------
		LDA	PLSCRL_MAXX
		CMP	#0FH
		BEQ	GMIN120		;l`wXN[lύXH ( no:GMIN120 )
;
;-------------- XN[JE^[ďZbg ----------------
		JSL	>PLSCRL_INIT	;player scroll initial

;-------------- GďZbg ----------------------------------
		JSL	>ENINSB		;enemy initial set
;
;-------------- R[Xf[^afZbg ----------------------
GMIN120		EQU	$
		JSL	>BGINT		;BG initial write
		STZ	NEXTGOTO	;next go to flag reset
;
;-------------- NMI-IRQ "ON" ------------------------------------
		STZ	NMI_PROG_NO	;荞݃vOmD
;
		LDA	#02H		;IRQ counter set
		STA	IRQFLG
;;;;		    LDA	    #070H	    ;H counter set
		LDA	#050H		;H counter set
		STA	4207H
		LDA	#0D8H		;V counter set
		STA	4209H
		LDA	#10110001B	;timer IRQ "ON"
		STA	4200H
;
GMIN150		EQU	$
;
;-------------- XN[Zbg ----------------------------
;
		MI16			; mempry , index 16bit mode
;
		JSL	>SCRL_CXY_SET	;XN[Zbg
;
		MI8			; mempry , index 8bit mode
;
;-------------- ItZbg[htOZbg --------------------
		LDA	BGMODE
		AND	#07H
		CMP	#02H
		BNE	GMIN160		;ItZbg[hH ( no:GMIN160 )
;
		INC	BG2OF_FG	;n̔g
GMIN160		EQU	$
;
;-------------- aflZbg ------------------------------------
		JSL	>BGM_SET	;[]
;
;
;
;
;
		M16
;
		lda	MANSEL
		sta	<0f9h
		lda	WMANSL
		sta	<0fbh
;
		M8
;
;
;
;
;
		JMP	>MODINC
;
;------------------------------------------------------------------------
;-		aflZbg						-
;------------------------------------------------------------------------
BGM_INIT_FLAG	EQU	$-1
		HEX	01	;[0] Ԕ
		HEX	01	;[1] n
		HEX	01	;[2] 
		HEX	01	;[3] {X
		HEX	01	;[4] n
		HEX	09	;[5] {XiȂ{Xaflj
		HEX	01	;[6] {[iXQ[
		HEX	01	;[7] {X
		HEX	09	;[8] {XiȂ{Xaflj
		HEX	0C	;[9] {XiJ`J`pȂ{Xaflj
		HEX	01	;[A] AX`bN
		HEX	02	;[B] G}I
		HEX	0	;[C] Nbp
		HEX	01	;[D] XyVS
		HEX	0	;[E]
		HEX	0	;[F]
;
		HEX	0	;[10] ^Cg
		HEX	02	;[11] Pv|Of
		HEX	01	;[12] }bv
;
BGM_SET		EQU	$
		PHP			;(P) save
;
		MI8
;
		LDA	GM_SOUND_0
		BNE	BGM_SET_010	;aflύXH ( no:BGM_SET_010 )
;
		LDX	GM_BGM_NO
		LDA	>BGM_INIT_FLAG,X
		STA	SOUND_0		;[]
		STA	GM_SOUND_0
BGM_SET_010	EQU	$
		STZ	SOUND_3
		STZ	SOUND_3_P
;
		PLP
		RTL
;
;------------------------------------------------------------------------
;-		R[XC^Cgfrbg}bvNA[		-
;------------------------------------------------------------------------
;
		MEM8
		IDX8
;
MSG_BTMP_CLR	EQU	$
		LDA	#BANK WOB7CHR	;(WK20,21,22) <-- ]AhX
		STA	<WORK22
;
		M16
;
		LDA	#WOB7CHR
		STA	<WORK20
		LDA	#0800H		;(A) <-- NA[oCg
		LDY	#00		;(Y) <--     h	 f[^
		JSL	>DMA_D_M
;
		M8
;
		RTL
;
;------------------------------------------------------------------------
;-		ԃ|Cgʉߎ̃f[^A				-
;------------------------------------------------------------------------
MID_POINT_LD	EQU	$
;
		MI16
;
		LDX	#MID_POINT_E-MID_POINT_S-2
MID_POINT_LD_10 EQU	$
		LDA	>MID_POINT_SV_S,X
		STA	!MID_POINT_S,X
		DEX
		DEX
		BPL	MID_POINT_LD_10
;
		STZ	EGGPNT
		LDX	#2+(6*2)-2
MID_POINT_LD_20 EQU	$
		LDA	>MID_EGGPNT,X
		STA	>SV_EGGPNT,X
		DEX
		DEX
		BPL	MID_POINT_LD_20
;
MID_POINT_LD_50 EQU	$
;
		MI8
;
		RTS
;
;************************************************************************
;*		IvVۑ					*
;************************************************************************
EGG_SAVE	EQU	$
		PHP			;(P) save
;
		M16
		I8
;
		LDA	EGGPNT
		STA	>SV_EGGPNT
		BEQ	EGG_SAVE_020	;vC[IvVAĂH ( no:EGG_SAVE_020 )
;
		TAX
EGG_SAVE_010	EQU	$
		LDY	EGGLNK-2,X	;IvVGmDۑ
		LDA	ENMYNO,Y
		STA	>SV_OPENNO-2,X
		DEX
		DEX
		BNE	EGG_SAVE_010
;
EGG_SAVE_020	EQU	$
		PLP			;(P) load
		RTL
;
;************************************************************************
;*		IvV񕜋A					*
;************************************************************************
EGG_LOAD	EQU	$
		PHP			;(P) save
;
		M16
		I8
;
		STZ	EGGPNT
		LDA	>SV_EGGPNT
		BEQ	EGG_LOAD_030	;vC[IvVZbgH ( no:EGG_LOAD_030 )
;
		STA	<WORK		;(WK0) <-- IvV
;
		PHD			;(D) save
		LDA	#EN0RAM		;(D) <-- enemy 0 page
		TCD
;
		DPAGE	EN0RAM
;
		LDX	#00
EGG_LOAD_010	EQU	$
		PHX			;(X) save
;
		LDA	>SV_OPENNO,X	;(A) <-- GmD
		CMP	#YSEGG
		BEQ	EGG_LOAD_020	;bV[^}SH ( yes:EGG_LOAD_020 )
		JSL	>ENINSR		;GGAm
		BCC	EGG_LOAD_020	;      h    H ( no:EGG_LOAD_020 )
;
		TYX
		LDA	PLXPSL		;vC[IvVwWZbg
		STA	ENXPSL,X
		LDA	PLYPSL		;vC[IvVxWZbg
		CLC
		ADC	#010H
		STA	ENYPSL,X
		LDA	ENCLOR,X	;afD揇ʃZbg
		AND	#11001111B
		ORA	PLPRIO
		STA	ENCLOR,X
		STX	<ENINDX
		JSL	>EGGSET		;vC[IvVNZbg
		STZ	SOUND_3_P	;[ TEhLZ ]
;
EGG_LOAD_020	EQU	$
		PLX			;(X) load
;
		INX
		INX
		CPX	WORK
		BCC	EGG_LOAD_010
;
		PLD			;(D) load
;
		DPAGE	WORK
;
		LDA	#00
		STA	>SV_EGGPNT
;
EGG_LOAD_030	EQU	$
		PLP
		RTL
;
		MEM8
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+	[hVp̃LN^[ƃJ[Zbg			+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
MD7CHRCOL	EQU	$
		JSL	>GMCOLST
;
		LDA	#CHRCEA
		STA	<WORK10
		LDA	#CHRCEB
		STA	<WORK11
		LDA	#CHRCFA
		STA	<WORK12
		LDA	#CHRCFB
		STA	<WORK13
		LDA	#M7TORIBOSS
		STA	<WORK14
		MI16			; memory , index 16bit mode
		LDX	#00000H
MD7CHRCOL_LOP	EQU	$
		LDA	>COL_ADDRESS+MODE7COL0+00*020H,X
		STA	>DATACOL+00*020H,X
		STA	>MOTOCOL+00*020H,X
		LDA	>COL_ADDRESS+MODE7COL0+01*020H,X
		STA	>DATACOL+01*020H,X
		STA	>MOTOCOL+01*020H,X
		LDA	>COL_ADDRESS+MODE7COL0+02*020H,X
		STA	>DATACOL+02*020H,X
		STA	>MOTOCOL+02*020H,X
		LDA	>COL_ADDRESS+MODE7COL0+03*020H,X
		STA	>DATACOL+03*020H,X
		STA	>MOTOCOL+03*020H,X
		LDA	>COL_ADDRESS+MODE7COL0+04*020H,X
		STA	>DATACOL+04*020H,X
		STA	>MOTOCOL+04*020H,X
		INX
		INX
		CPX	#00020H
		BCC	MD7CHRCOL_LOP
;
		M8			; memory 8bit mode
;
		LDA	#CHR44D-CHR10
		STA	!OBJCHR_BNK	;GLN^[oNPZbg
		STA	<WORK15
;
		LDA	#CHR40B-CHR10
		STA	!OBJCHR_BNK+1	;GLN^[oNQZbg
		STA	<WORK16
;
		LDA	#CHR40C-CHR10
		STA	!OBJCHR_BNK+2	;GLN^[oNRZbg
		STA	<WORK17
;
		LDA	#CHR46C-CHR10
		STA	!OBJCHR_BNK+3	;GLN^[oNSZbg
		STA	<WORK18
;
		STA	<WORK19
		STA	<WORK1A
		LDA	#0FFH
		STA	!OBJCHR_BNK+4	;GLN^[oNTZbg
		STA	!OBJCHR_BNK+5	;GLN^[oNUZbg
;
		LDY	#GMMD7
		JSL	>CHRSET
		I8			; index 8bit mode
;
		LDY	!DSPMOD
		LDX	GMMDNOD,Y	;(X) <-- game mode type no.
		JSL	>GMMDST		;game mode set
;
		M16
;
		LDA	#0080H		;XN[JE^[Zbg
		STA	SCCH3
		STA	ESCCH3
;;;;		    LDA	    #0040H
;;;;		    LDA	    #0080H
		STA	SCCV3
		STA	ESCCV3
		LDA	#0100H		;[hVSWZbg
		STA	M7X
		LDA	#00F8H
		STA	M7Y
		INC	ATSCRL_H	;XN[rsnoII
		INC	ATSCRL_V	;	  h
		JSL	>BOSSQ_MD7_SET	;[hVp[^Zbg
;
;-------------- {XpZbg ------------------------------
		LDA	#BOSSQ		;(A) <-- GmD
		JSL	>ENINSR_I	;GGAm
;
		M8
;
;;;;K;;;;		JSR	METERIT		;meter initial
		RTS
;
;------------------------------------------------------------------------
;-		[hVp[^Zbg				-
;------------------------------------------------------------------------
;
		MEM16
;
BOSSQ_MD7_SET	EQU	$
		JSL	>MD7_MATRIX_SET ;[hV}gbNXZbg
;
		LDA	PLMODE
		CMP	#PBQ7
		BEQ	BOSSQ_M7_ST_050 ;ofH ( yes:BOSSQ_M7_ST_050 )
;
		LDA	PLXPSL		;vC[wW␳
		CMP	#0140H-020H
		BPL	BOSSQ_M7_ST_010
		CLC
		ADC	#0140H
BOSSQ_M7_ST_010 EQU	$
		CMP	#(0140H-020H)+0140H
		BMI	BOSSQ_M7_ST_020
		SEC
		SBC	#0140H
BOSSQ_M7_ST_020 EQU	$
		STA	PLXPSL
;
		SEC			;[hV]pxZbg
		SBC	#0140H-020H
;
		M8
;
		STA	4202H
		LDY	#0CDH		;[ 100H : 140H ]
		STY	4203H
		NOP
		NOP
		LDA	#LOW (020H*0CDH)
		CLC
		ADC	4216H
		LDA	4217H
		ADC	#0
		PHA			;(A) save
		XBA
		STA	4202H
		STY	4203H
		NOP
		NOP
		PLA			;(A) load
		CLC
		ADC	4216H
		SEC
		SBC	#HIGH ((020H*0CDH)+0080H)
		AND	#00FFH
		STA	MD7_ANGL
;
		M16
;
		LDA	PLXPSL		;n`lZbgpXN[JE^[Zbg
		SEC
		SBC	#078H
		STA	ATSCRL_SCCH1
		STA	SCCH1
		STA	ESCCH1
		LDA	ESCCV3
		CLC
		ADC	#026H
		STA	ATSCRL_SCCV1
		STA	SCCV1
		STA	ESCCV1
;
BOSSQ_M7_ST_050 EQU	$
		RTL
;
;------------------------------------------------------------------------
;-		[hV}gbNXZbg				-
;------------------------------------------------------------------------
;
		MEM16
;
MD7_MATRIX_SET	EQU	$
		PHX			;(X) save
;
		LDA	MD7_ANGL
		AND	#00FFH
		ASL	A
;
		I16
;
		TAX
		LDA	>COS,X
		STA	M7A
		STA	M7D
		LDA	>SIN,X
		STA	M7B
		EOR	#0FFFFH
		INC	A
		STA	M7C
;
		I8
;
		PLX			;(X) Load
		RTL
;
		MEM8
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+	tJR[Xp tgubN LN^[Zbg	+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
FUKAN_LIFT	EQU	$
		M16			; memory 16bit mode
;
		LDX	#10000000B
		STX	2115H		; inc mode set
		LDA	#00000001B+(18H*100H)
		STA	4300H		; DMA paramer & B bus address set
		LDX	#BANK CHR50
		STX	4304H		; A bus address(B) set
		LDY	#00000001B
;
		LDA	#04000H+0100H*2+00010H*8
		STA	2116H		; VRAM address set
		LDA	#CHR50+(020H*236)
		STA	4302H		; A bus address(L,H) set
		LDA	#00020H*4
		STA	4305H		; number of byte set
		STY	420BH		; DMA "ON" !!
;
		STA	4305H		; number of byte set
		LDA	#04000H+0100H*3+00010H*8
		STA	2116H		; VRAM address set
		LDA	#CHR50+(020H*252)
		STA	4302H		; A bus address(L,H) set
		STY	420BH		; DMA "ON" !!
;
		M8			; memory 8bit mode
		RTS
;
;************************************************************************
;*		game play fade "in/out"					*
;************************************************************************
;
GMFADE		EQU	$
;
;-------------- Q[ʃZbg ----------------------------------------
		LDA	#01H
		STA	PLSTFG		;player stop !!
		STA	ENSTFG		;enemy	  "
		JSL	>GMPLAY2	;game play ( display only )
;
;-------------- EBhEZbg ----------------------------------------
;
		M16
;
		LDA	GMFADE_NO
		STA	R1		;(R1) <-- ό`f[^mD
		INC	A
		STA	R2		;(R2) <--  h       h
		LDA	GMFADE_CT
		STA	R6		;(R6) <--  h 
		M_CHIP	WIND_CHANGE
;
;-------------- EBhEp[^Zbg ------------------------------
		LDA	GMFADE_CT
		CLC
		ADC	#08H
		STA	GMFADE_CT
		CMP	#0100H+1
		BCC	GMFADE_010	;ό`f[^؂ւH ( no:GMFADE_010 )
;
		STZ	GMFADE_CT
;
		INC	GMFADE_NO
		LDA	GMFADE_NO
		CMP	#02H
		BCC	GMFADE_010	;end ? ( no:GMFADE_010 )
;
;-------------- go to game play !! ------------------------------
;
		M8
;
		STZ	WMANSL		;window disable
		STZ	WSUBSL
		STZ	WIND23
		STZ	WIND24
		STZ	WIND25
		LDA	#00100000B	;H-DMA "OFF"
		TRB	HD420C
		STZ	PLSTFG		;player move !!
		STZ	ENSTFG		;enemy	  "
		INC	MODENO		;[ +2 ]
		JMP	>MODINC
;
		MEM16
;
GMFADE_010	EQU	$
;
;-------------- EBhEobt@]Zbg ----------------------------
		JSL	>M_DMA_BFST
		LWORD	WINDBUF		;]AhX
		LWORD	WINDBF		;]AhX
		WORD	(0D2H*4)	;]oCg
;
		M8
;
;-------------- window PPU set ----------------------------------
		LDA	#00011111B
		STA	WMANSL
		STA	WSUBSL
		LDA	#00110011B
		STA	WIND23
		STA	WIND24
		STA	WIND25
		STZ	WLOGIC		;window logic set
		STZ	212BH		;
		LDA	#00100000B
		TSB	HD420C		;H-DMA "ON" !!
		LDA	#0FH
		STA	FADNO		;fade no set
		LDA	#01H
		STA	FADMK		;fade muki
;
		PLB
		RTL
;
;************************************************************************
;*		game goal in						*
;************************************************************************
;
GMGOAL		EQU	$
		LDX	GOAL_IN
		CPX	#GOAL_CL
		BCS	GMGOAL_010	;Q[ʃZbgH ( no:GMGOAL_010 )
;
;-------------- Q[ʃZbg ----------------------------------------
		JSL	>GMPLAY2	;game play ( display )
;
		LDX	GOAL_IN
GMGOAL_010	EQU	$
		JSR	(!GMGOAL_SUB,X)
;
		PLB
		RTL
;
;------------------------------------------------------------------------
;-		S[[`e[uf[^			-
;------------------------------------------------------------------------
GMGOAL_SUB	EQU	$-1
		WORD	GMGOAL_000	;Zbg
		WORD	GMGOAL_WAIT	;f҂ifn`kLN^[pj
		WORD	GMGOAL_WAIT	;f҂
		WORD	GMGOAL_100	;EBhDZbg
		WORD	BSCR_SCRE_200	;EBhDX^[g!!
		WORD	BSCR_SCRE_300	;EBhD bkntrd
GOAL_CALC	WORD	GMGOAL_B1CLS	;ʃNA[ BG1
		WORD	GMGOAL_B3CLS	;ʃNA[ BG3
		WORD	GMGOAL_CLI0	;ZʏZbg|P
		WORD	GMGOAL_CLI1	;	h	   |Q
		WORD	GMGOAL_CLI2	;	h	   |R
		WORD	BSCR_SCRE_400	;EBhDX^[g!!
SCRE_START	WORD	GMGOAL_WAIT_TM	;EFCg
		WORD	GMGOAL_SCR_TIME ;^C|Cg
		WORD	GMGOAL_WAIT_TM	;EFCg
		WORD	GMGOAL_SCR_CON	;RC |Cg
		WORD	GMGOAL_WAIT_TM	;EFCg
		WORD	GMGOAL_SCR_SPL	;XyV |Cg
		WORD	GMGOAL_WAIT_TM	;EFCg
		WORD	GMGOAL_HICHK	;nCXRA `FbN
GOAL_500	WORD	GMGOAL_WAIT_TM	;EFCg
		WORD	GMGOAL_2LINE	;QC
GOAL_600	WORD	GMGOAL_WAIT_TM	;EFCg
		WORD	GMGOAL_MARU	;܂鏑
GOAL_700	WORD	GMGOAL_WAIT_TM	;EFCg
		WORD	GMGOAL_HANA_IN
		WORD	GMGOAL_HANA	;Ԃ܂鏑
GOAL_800	WORD	GMGOAL_WAIT_TM	;EFCg
		WORD	GMGOAL_HSCST	;nCXRAʕ\
		WORD	GMGOAL_FLSH	;  "       "	   (}[N_)
GOAL_900	WORD	GMGOAL_CALC	;hm jdx v`hs
;
GOAL_CL		EQU	GOAL_CALC-GMGOAL_SUB
SCRE_STT	EQU	SCRE_START-GMGOAL_SUB
;
GMGOAL_2LN	EQU	GOAL_500-GMGOAL_SUB
GMGOAL_MR	EQU	GOAL_600-GMGOAL_SUB
GMGOAL_HN	EQU	GOAL_700-GMGOAL_SUB
GMGOAL_HI	EQU	GOAL_800-GMGOAL_SUB
GMGOAL_CC	EQU	GOAL_900-GMGOAL_SUB
;
;----------------------------------------------------------------
;-		[hhmb.					-
;----------------------------------------------------------------
GOALMD_INC	EQU	$
		INC	GOAL_IN
		INC	GOAL_IN
;;;;K;;;;		RTS
;
;----------------------------------------------------------------
;-		f҂					-
;----------------------------------------------------------------
GMGOAL_WAIT	EQU	$
		RTS
;
;----------------------------------------------------------------
;-		EBhDZbg				-
;----------------------------------------------------------------
GMGOAL_100	EQU	$
		LDA	!HD420C
		PHA
		JSR	BSCR_SCRE_100
		PLA
		TSB	!HD420C
		RTS
;
;----------------------------------------------------------------
;-		afP ʃNA[				-
;----------------------------------------------------------------
GMGOAL_B1CLS	EQU	$
		M16			; memory 16bit mode
		PHB			; obt@ NA[
		LDX	#BANK GALSCRBF
		PHX
		PLB
		LDX	#000H
		LDA	#0017FH
GMGOAL_CLS_LOP	EQU	$
		STA	!GALSCRBF+000H,X
		STA	!GALSCRBF+100H,X
		STA	!GALSCRBF+200H,X
		STA	!GALSCRBF+300H,X
		STA	!GALSCRBF+380H,X
		DEX
		DEX
		BNE	GMGOAL_CLS_LOP
		PLB
;
		LDX	#000H
GMGOAL_LIN_LOP	EQU	$
		LDA	BG3LINEDAT0,X
		STA	>GALSCRBF+088H,X
		LDA	BG3LINEDAT1,X
		STA	>GALSCRBF+348H,X
		INX
		INX
		CPX	#BG3LINEDAT1-BG3LINEDAT0
		BCC	GMGOAL_LIN_LOP
;
		LDA	#004
		STA	!CHRTRP
		STZ	!COLTRP
;
		M8			; memory 8bit mode
		LDA	#GLB1CL
		STA	!VRFLG
		JMP	GOALMD_INC
;
;
GLBG1SCRCLR	EQU	$
		WORD	06800H,040BFH,018EEH	; BG1 clear data (up)
		WORD	068A0H,0447FH,01A11H	; BG1 gleen data
		WORD	06860H,0C029H,018EEH	; BG1 clear data (lf0)
		WORD	06861H,0C029H,018EEH	; BG1 clear data (lf1)
		WORD	0687EH,0C029H,018EEH	; BG1 clear data (rt0)
		WORD	0687FH,0C029H,018EEH	; BG1 clear data (rt1)
		WORD	06B00H,0413FH,018EEH	; BG1 clear data (down)
		WORD	0FFFFH
;
BG3LINEDAT0	EQU	$
		WORD	00145H,00146H,08145H,0C146H,04145H,04146H
		WORD	00145H,00146H,08145H,08146H,04145H,00146H
		WORD	00145H,08146H,00145H,00146H,00145H,00146H
		WORD	08145H,0C146H,00145H,00146H,08145H,00146H
;
BG3LINEDAT1	EQU	$
		WORD	00145H,00146H,08145H,08146H,00145H,00146H
		WORD	00145H,00146H,08145H,08146H,00145H,08146H
		WORD	00145H,08146H,08145H,00146H,04145H,00146H
		WORD	08145H,00146H,00145H,08146H,00145H,00146H
;
;----------------------------------------------------------------
;-		afR ʃNA[				-
;----------------------------------------------------------------
GMGOAL_B3CLS	EQU	$
		LDA	#GLB3CL
		STA	!VRFLG
		JMP	GOALMD_INC
;
GLBG3SCRCLR	EQU	$
		WORD	03400H,047FFH,0117FH	; BG3 clear data
		WORD	0FFFFH
;
;----------------------------------------------------------------
;-		ZʏZbg|PiLN^[Zbgj	-
;----------------------------------------------------------------
GMGOAL_CLI0	EQU	$
;
		MI16			; memory , index 16bit mode
;
;-------------- obt@ Zbg ---------------------------------
;
		LDX	#(00000H*40H)+(00005H*2)
		LDY	#00000H
		STZ	<WORK0
B3BFST_LP_000	EQU	$
		LDA	GMGOAL_SCR0,Y
		JSR	B3BFSTSB
		CPY	#GMGOAL_SCR1-GMGOAL_SCR0
		BCC	B3BFST_LP_000
;
		JSR	B3BFST_LP_100
;
		JSR	B3BFST_LP_200
;
		JSR	B3BFST_LP_300
;
		LDX	#(0000FH*40H)+(00007H*2)
		LDY	#00000H
		STZ	<WORK0
B3BFST_LP_400	EQU	$
		LDA	GMGOAL_SCR4,Y
		JSR	B3BFSTSB
		CPY	#GMGOAL_SCR5-GMGOAL_SCR4
		BCC	B3BFST_LP_400
;
		MI8			; memory , index 8bit mode
		LDX	!MAPOINT
		LDA	!HISCEBF,X
		MI16			; memory , index 16bit mode
;
		AND	#000FFH
		STA	!HISCORE
		STZ	<WORK0
		LDA	!HISCORE	; nCXRA_\
		CMP	#00100
		BCC	B3BFST_100
		LDA	#00011
		STA	<WORK0
		DEC	A
		BRA	B3BFST_200
B3BFST_100	EQU	$
		CMP	#00010
		BCC	B3BFST_200
		INC	<WORK0
		SBC	#00010
		BRA	B3BFST_100
B3BFST_200	EQU	$
		ASL	A
		TAY
		LDA	GMGOAL_KAZ_DT0,Y
		STA	>GALSCR_HISCR0+2
		LDA	GMGOAL_KAZ_DT1,Y
		STA	>GALSCR_HISCR1+2
		LDA	<WORK0
		ASL	A
		TAY
		LDA	GMGOAL_KAZ_DT0,Y
		STA	>GALSCR_HISCR0
		LDA	GMGOAL_KAZ_DT1,Y
		STA	>GALSCR_HISCR1
;
;-------------- afR LN^[Zbg -----------------------
;
		LDA	#BANK CHR74
		STA	<WORK1		; bank NO. set
		LDY	#02800H		;(Y) <-- VRAM address
		LDX	#CHR74		;(X) <-- A bus address
		LDA	#0800H		;(A) <-- number byte
		JSL	>VRAMDX_ST
;
;-------------- afP LN^[Zbg P --------------------
;
		LDA	#BANK CHR50
		STA	<WORK1		; bank NO. set
		LDY	#01000H		;(Y) <-- VRAM address
		LDX	#CHR50+(0F0H*20H)	;(X) <-- A bus address
		LDA	#0100H		;(A) <-- number byte
		JSL	>VRAMDX_ST
;
;-------------- afP LN^[Zbg Q --------------------
;
		LDA	#BANK CHR50
		STA	<WORK1		; bank NO. set
		LDY	#01100H		;(Y) <-- VRAM address
		LDX	#CHR50+(0F6H*20H)	;(X) <-- A bus address
		LDA	#0100H		;(A) <-- number byte
		JSL	>VRAMDX_ST
;
		MI8			; memory , index 8bit mode
;
		JMP	GOALMD_INC
;
;------------------------------------------------
;-		obt@ Zbg Tu[`	-
;-			in			-
;-			A <- data read index	-
;-			X <- buffer index	-
;-			out			-
;-			X <- next buffer index	-
;-			Y <- next data index	-
;------------------------------------------------
		MEM16
		IDX16
B3BFSTSB	EQU	$
		PHY
		AND	#000FFH
		TAY
		LDA	GMGOAL_MJ_DAT0,Y
		ORA	<WORK0
		STA	>GALSCRBF+000H,X
		LDA	GMGOAL_MJ_DAT1,Y
		ORA	<WORK0
		STA	>GALSCRBF+040H,X
		INX
		INX
		PLY
		INY
		RTS
;
;++++++++++++++++++++++++++++++++++++++++
;+		" bnhm "		+
;++++++++++++++++++++++++++++++++++++++++
B3BFST_LP_100	EQU	$
		LDX	#(00004H*40H)+(00004H*2)
		LDY	#00000H
B3BFST_LP_150	EQU	$
		LDA	GMGOAL_SCR1,Y
		JSR	B3BFSTSB
		CPY	#GMGOAL_SCR2-GMGOAL_SCR1
		BCC	B3BFST_LP_150
		RTS
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+		" eknvdq "		+
;++++++++++++++++++++++++++++++++++++++++++++++++
B3BFST_LP_200	EQU	$
		LDX	#(00007H*40H)+(00004H*2)
		LDY	#00000H
B3BFST_LP_250	EQU	$
		LDA	GMGOAL_SCR2,Y
		JSR	B3BFSTSB
		CPY	#GMGOAL_SCR3-GMGOAL_SCR2
		BCC	B3BFST_LP_250
		RTS
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	" sns`k@onhms "		+
;++++++++++++++++++++++++++++++++++++++++++++++++
B3BFST_LP_300	EQU	$
		LDX	#(0000AH*40H)+(00004*2)
		LDY	#00000H
B3BFST_LP_350	EQU	$
		LDA	GMGOAL_SCR3,Y
		JSR	B3BFSTSB
		CPY	#GMGOAL_SCR4-GMGOAL_SCR3
		BCC	B3BFST_LP_350
		RTS
;
		MEM8
		IDX8
;
;
GMGOAL_SCR0	EQU	$
		BYTE	MAL,MAL+2,NUK,HHH,III,GGG,HHH,NUK,SSS,CCC,OOO
		BYTE	RRR,EEE,UPP,UPP,UPP,UPP,S22,S66,NUK,MAL,MAL+2
;
GMGOAL_SCR1	EQU	$
		BYTE	STR,STR+2,NUK,SSS,TTT,AAA,RRR,NUK,UPP,UPP,UPP,UPP
		BYTE	UPP,NUK,S00,NNM,S33,S00,ARW,ARW+2,NUK,S00,TEN,TEN+2
;
GMGOAL_SCR2	EQU	$
		BYTE	CIN,CIN+2,NUK,CCC,OOO,III,NNN,NUK,UPP,UPP,UPP,UPP
		BYTE	UPP,NUK,S00,NNM,S22,S00,ARW,ARW+2,NUK,S00,TEN,TEN+2
;
GMGOAL_SCR3	EQU	$
		BYTE	FWR,FWR+2,NUK,FFF,LLL,OOO,WWW,EEE,RRR,NUK,UPP,UPP
		BYTE	UPP,UPP,UPP,S00,NNM,S55,ARW,ARW+2,NUK,S00,TEN,TEN+2
;
GMGOAL_SCR4	EQU	$
		BYTE	TTT,OOO,TTT,AAA,LLL,NUK,PPP,OOO,III,NNN,TTT,UPP
		BYTE	UPP,UPP,UPP,UPP,UPP,NUK,S00,TEN,TEN+2
;
GMGOAL_SCR5	EQU	$		; **|[Yp**
		BYTE	NUK,HHH,III,GGG,HHH,NUK,SSS,CCC,OOO,RRR,EEE
		BYTE	UPP,UPP,UPP,UPP,UPP,UPP,NUK,S00,TEN,TEN+2
;
GMGOAL_SCR6	EQU	$
;
GMGOAL_MJ_DAT0	EQU	$
		WORD	0010AH,0010BH,0010CH,0010DH,0010EH,04106H,00120H,00121H
		WORD	00122H,00123H,00124H,0C116H,00126H,00127H,00109H,00128H
		WORD	00129H,00128H,04102H,0012CH,0012DH,0012EH,08136H,00101H
		WORD	00101H,00142H,00144H,00143H,0017FH,0012AH,0012BH,00548H
		WORD	00549H,0054AH,0054BH,0054CH,0054DH,0054EH,0054FH,0017FH
GMGOAL_KAZ_DT0	EQU	$
		WORD	00109H,00100H,00102H,00102H,00103H
		WORD	00104H,00105H,00106H,00107H,0C115H
		WORD	00168H,00167H,00175H,00176H
		WORD	0017FH,0017FH
;
GMGOAL_MJ_DAT1	EQU	$
		WORD	0011AH,0011BH,0011CH,0011DH,0011EH,0011FH,00130H,00131H
		WORD	00132H,00133H,00134H,0C106H,00136H,00137H,00119H,00138H
		WORD	00139H,00140H,00112H,0013CH,0013DH,0013EH,08126H,00111H
		WORD	0013CH,0C142H,0C144H,0017FH,00141H,0013AH,0013BH,00508H
		WORD	00518H,00525H,00535H,0052FH,0053FH,0050FH,00547H,0017FH
GMGOAL_KAZ_DT1	EQU	$
		WORD	00119H,00110H,0C142H,00112H,00113H
		WORD	00114H,00115H,00116H,00117H,0C105H
		WORD	00178H,00177H,00179H,0017AH
		WORD	0015FH,0016FH
;
AAA	EQU	0
BBB	EQU	AAA+2
CCC	EQU	BBB+2
DDD	EQU	CCC+2
EEE	EQU	DDD+2
FFF	EQU	EEE+2
GGG	EQU	FFF+2
HHH	EQU	GGG+2
III	EQU	HHH+2
JJJ	EQU	III+2
KKK	EQU	JJJ+2
LLL	EQU	KKK+2
MMM	EQU	LLL+2
NNN	EQU	MMM+2
OOO	EQU	NNN+2
PPP	EQU	OOO+2
QQQ	EQU	PPP+2
RRR	EQU	QQQ+2
SSS	EQU	RRR+2
TTT	EQU	SSS+2
UUU	EQU	TTT+2
VVV	EQU	UUU+2
WWW	EQU	VVV+2
XXX	EQU	WWW+2
YYY	EQU	XXX+2
ZZZ	EQU	YYY+2
NNM	EQU	ZZZ+2
UPP	EQU	NNM+2
DWP	EQU	UPP+2
MAL	EQU	DWP+2
STR	EQU	MAL+2+2
FWR	EQU	STR+2+2
CIN	EQU	FWR+2+2
MIS	EQU	CIN+2+2
NUK	EQU	MIS+2+2
S00	EQU	NUK+2
S11	EQU	S00+2
S22	EQU	S11+2
S33	EQU	S22+2
S44	EQU	S33+2
S55	EQU	S44+2
S66	EQU	S55+2
S77	EQU	S66+2
S88	EQU	S77+2
S99	EQU	S88+2
S100	EQU	S99+2
ARW	EQU	S100+2+2
TEN	EQU	ARW+2+2
;
;----------------------------------------------------------------
;-		ZʏZbg|QiafPXN[Zbgj-
;----------------------------------------------------------------
GMGOAL_CLI1	EQU	$
		M16			; memory 16bit mode
		STZ	!TIMCNT
		STZ	!GOAL_TIM_PT
		STZ	!GOAL_CON_PT
		STZ	!GOAL_SPL_PT
		STZ	!GOAL_TTL_PT
		M8			; memory 8bit mode
;
		LDA	#BG1DT
		STA	!VRFLG
		JMP	GOALMD_INC
;
GOAL_B1SCRDAT	EQU	$
		WORD	06862H,00001H,01A02H
		WORD	06863H,04033H,01A03H
		WORD	0687DH,00001H,01A04H
		WORD	06882H,0C025H,01A05H
		WORD	06883H,00001H,01A00H
		WORD	06884H,04031H,01A01H
		WORD	0689DH,0C025H,01A15H
		WORD	068A3H,0C023H,01A10H
		WORD	06AE2H,00001H,01A12H
		WORD	06AE3H,04033H,01A13H
		WORD	06AFDH,00001H,01A14H
		WORD	0FFFFH
;
;----------------------------------------------------------------
;-		ZʏZbg|RiXN[Zbgj	-
;----------------------------------------------------------------
GMGOAL_CLI2	EQU	$
;
;-------------- afR XN[Zbg -------------------------
;
		MI16			; memory , index 16bit mode
;
		LDA	#BANK GALSCRBF
		STA	<WORK1
		LDY	#034A0H		;(Y) <-- VRAM address
		LDX	#GALSCRBF	;(X) <-- A bus address
		LDA	#00018*00040H	;(A) <-- number byte
		JSL	>VRAMDX_ST
;
;-------------- J[Zbg ------------------------------------
		LDX	#(00FH-1)*2
GMGOAL_CLI2_010 EQU	$
		LDA	>COL_ADDRESS+BG3_SUB_5_COL,X
		STA	>DATACOL+2,X
		LDA	>COL_ADDRESS+BG2_SUB_9_COL,X
		STA	>DATACOL+(20H*6)+2,X
		LDA	>COL_ADDRESS+BG2_SUB_9_COL+20H,X
		STA	>DATACOL+(20H*6)+20H+2,X
		DEX
		DEX
		BPL	GMGOAL_CLI2_010
;
;-------------- ʐݒ -----------------------------------------
		STZ	<SCCH1		;BG1 scroll counter set
		STZ	<SCCV1
		STZ	<SCCH3
		STZ	<SCCV3
;
		STZ	NUKCOL		;nuki color set
		LDA	#00
		STA	>DATACOL
;
		STZ	!GOAL_CHR_CHNG
		STZ	!GOAL_CHR_CNT
		MI8			; memory , index 8bit mode
;
		LDA	!BGMODE
		AND	#00FH
		STA	!BGMODE
		LDA	#00000100B	;BG3 display set
		STA	MANSEL
		LDA	#00000001B	;BG1 display set
		STA	SUBSEL
;
		JMP	GOALMD_INC
;
;----------------------------------------------------------------
;-		EFCg					-
;----------------------------------------------------------------
GMGOAL_WAIT_TM	EQU	$
		JSR	GOAL_MJ_CHNG	; S[
		DEC	!GLWAITTIM
		BNE	GMGOAL_WAIT_TIM
		JSR	GOALMD_INC
		LDA	!GOAL_IN
		CMP	#GMGOAL_2LN
		BCS	GMGOAL_WAIT_TIM
;;;;		    LDA	    #011H
;;;;		    STA	    !SOUND3
GMGOAL_WAIT_TIM EQU	$
		RTS
;
;----------------------------------------------------------------
;-		^C |Cg					-
;----------------------------------------------------------------
TIMER_DEC	EQU	00010
;
TIMER_MAX	EQU	00030
;
;
GMGOAL_SCR_TIME EQU	$
		JSR	GOAL_MJ_CHNG	; S[
;
		MI16			; memory , index 16bit mode
		LDA	!TIMER
		SEC
		SBC	#TIMER_DEC
		STA	!TIMER
		BPL	SCR_TIME_05
		STZ	!TIMER
		MI8			; memory , index 16bit mode
;;;;		    LDA	    #012H
;;;;		    STA	    !SOUND3
		LDA	#020H
		STA	!GLWAITTIM
		LDA	!CORS_COIN
		ORA	!CORS_COIN+1
		BNE	SCR_TIME_03
		JSR	GOALMD_INC
		JSR	GOALMD_INC
		LDA	!FRWR_P
		ORA	!FRWR_P+1
		BNE	SCR_TIME_03
		JSR	GOALMD_INC
		JSR	GOALMD_INC
SCR_TIME_03	EQU	$
		JMP	GOALMD_INC
;
		MEM16
		IDX16
SCR_TIME_05	EQU	$
		STZ	<WORK2
		INC	!TIMCNT
		STZ	!TIMCNT
;
		LDA	!GOAL_TIM_PT	; ^C |CgvZ
		INC	A
		CMP	#TIMER_MAX	; l`w `FbN !!
		BCC	SCR_TIME_10
		LDA	#00400H
		STA	<WORK0
		STA	<WORK2
		JSR	B3BFST_LP_100
		LDA	#TIMER_MAX
		BRA	SCR_TIME_13
SCR_TIME_10	EQU	$
		PHA
		MI8			; memory , index 8bit mode
		LDA	#05AH
		JSL	>SOUND_3_ON	;[]
		MI16			; memory , index 16bit mode
		PLA
SCR_TIME_13	EQU	$
		STA	!GOAL_TIM_PT
		LDX	#00000H
SCR_TIME_15	EQU	$
		CMP	#00010
		BCC	SCR_TIME_50
		INX
		SBC	#00010
		BRA	SCR_TIME_15
;
SCR_TIME_50	EQU	$
		STA	<WORK0
		LDA	#BANK GALSCR_TIM0
		STA	<WORK6
		STA	<WORK9
		STA	<WORK12
		STA	<WORK15
		LDA	#GALSCR_TIM0
		STA	<WORK4
		CLC
		ADC	#00007*2
		STA	WORK10
		LDA	#GALSCR_TIM1
		STA	<WORK7
		CLC
		ADC	#00007*2
		STA	<WORK13
		JSR	SCR_BUFST	; obt@Zbg
;
		MI8			; memory , index 8bit mode
;
SCR_TIME_90	EQU	$
		RTS
;
;----------------------------------------------------------------
;-		RC |Cg					-
;----------------------------------------------------------------
COIN_MAX	EQU	00020
;
;
GMGOAL_SCR_CON	EQU	$
		JSR	GOAL_MJ_CHNG	; S[
;
		MI16			; memory , index 16bit mode
		LDA	!GOAL_CON_PT
		CMP	#COIN_MAX	; l`w ?
		BCS	SCR_CON_000	;	YES -> SCR_CON_000
		DEC	!CORS_COIN
		LDA	!CORS_COIN
		BPL	SCR_CON_005
SCR_CON_000	EQU	$
;
		MI8			; memory , index 8bit mode
;;;;		    LDA	    #012H
;;;;		    STA	    !SOUND3
		LDA	#020H
		STA	!GLWAITTIM
		LDA	!FRWR_P
		ORA	!FRWR_P+1
		BNE	SCR_CON_03
		JSR	GOALMD_INC
		JSR	GOALMD_INC
SCR_CON_03	EQU	$
		JMP	GOALMD_INC
;
		MEM16
		IDX16
SCR_CON_005	EQU	$
		STZ	<WORK2
		LDA	!GOAL_CON_PT	; RC |CgvZ
		INC	A
		CMP	#COIN_MAX	; l`w `FbN !!
		BCC	SCR_CON_20
		LDA	#00400H
		STA	<WORK0
		STA	<WORK2
		JSR	B3BFST_LP_200
		LDA	#COIN_MAX
		BRA	SCR_CON_23
SCR_CON_20	EQU	$
		PHA
		MI8			; memory , index 8bit mode
		LDA	#05AH
		JSL	>SOUND_3_ON	;[]
		MI16			; memory , index 16bit mode
		PLA
SCR_CON_23	EQU	$
		STA	!GOAL_CON_PT
		LDX	#00000H
SCR_CON_25	EQU	$
		CMP	#00010
		BCC	SCR_CON_30
		INX
		SBC	#00010
		BRA	SCR_CON_25
;
SCR_CON_30	EQU	$
		STA	<WORK0
		LDA	#BANK GALSCR_CIN0
		STA	<WORK6
		STA	<WORK9
		STA	<WORK12
		STA	<WORK15
		LDA	#GALSCR_CIN0
		STA	<WORK4
		CLC
		ADC	#00007*2
		STA	<WORK10
		LDA	#GALSCR_CIN1
		STA	<WORK7
		CLC
		ADC	#00007*2
		STA	<WORK13
		JSR	SCR_BUFST	; obt@Zbg
;
		MI8			; memory , index 8bit mode
;
SCR_CON_90	EQU	$
		RTS
;
;----------------------------------------------------------------
;-		XyV(t[) |Cg			-
;----------------------------------------------------------------
GMGOAL_SCR_SPL	EQU	$
		JSR	GOAL_MJ_CHNG	; S[
		MI16			; memory , index 16bit mode
		DEC	!FRWR_P
		LDA	!FRWR_P
		BPL	SCR_SPL_005
		STZ	!FRWR_P
;
		MI8			; memory , index 8bit mode
;;;;		    LDA	    #012H
;;;;		    STA	    !SOUND3
		LDA	#020H
		STA	!GLWAITTIM
		JMP	GOALMD_INC
;
		MEM16
		IDX16
SCR_SPL_005	EQU	$
		STZ	<WORK2
		LDA	!GOAL_SPL_PT
		CLC
		ADC	#00010
		STA	!GOAL_SPL_PT
		LDX	#00000H		; XyV |CgvZ
SCR_SPL_020	EQU	$
		CMP	#00010
		BCC	SCR_SPL_030
		INX
		SBC	#00010
		BRA	SCR_SPL_020
;
SCR_SPL_030	EQU	$
		CPX	#000005
		BCC	SCR_SPL_040
		PHX
		LDA	#00400H
		STA	<WORK0
		STA	<WORK2
		JSR	B3BFST_LP_300
		PLX
SCR_SPL_040	EQU	$
		LDA	#0FFFFH
		STA	<WORK0
		LDA	#BANK GALSCR_SPL0
		STA	<WORK6
		STA	<WORK9
		STA	<WORK12
		STA	<WORK15
		LDA	#GALSCR_SPL0
		STA	<WORK4
		CLC
		ADC	#00005*2
		STA	<WORK10
		LDA	#GALSCR_SPL1
		STA	<WORK7
		CLC
		ADC	#00005*2
		STA	<WORK13
		JSR	SCR_BUFST	; obt@Zbg
;
		MI8			; memory , index 8bit mode
;
		LDA	#05AH
		JSL	>SOUND_3_ON	;[]
		RTS
;
;--------------------------------------------------------
;-	obt@Zbg					-
;-		in					-
;-		X <--------- \̈ʂ̐			-
;-		work0,1 <--- ̈ʂ̐			-
;-		    2,3 <--- Agr[g		-
;-		    4,5,6 <- obt@ AhX(up)	-
;-		    7,8,9 <- obt@ AhX(down)	-
;-		 10,11,12 <- obt@ AhX(up)	-
;-		 13,14,15 <- obt@ AhX(down)	-
;--------------------------------------------------------
		MEM16
		IDX16
SCR_BUFST	EQU	$
		TXA			; \̈
		BEQ	SCR_BUFST_20
		ASL	A
		TAX
		LDA	GMGOAL_KAZ_DT0,X
		ORA	<WORK2
		STA	[<WORK4]
		STA	[<WORK10]
		LDA	GMGOAL_KAZ_DT1,X
		ORA	<WORK2
		STA	[<WORK7]
		STA	[<WORK13]
;
SCR_BUFST_20	EQU	$
		LDY	#00002
		LDA	<WORK0		; ̈
		BMI	SCR_BUFST_30
		ASL	A
		TAX
		LDA	GMGOAL_KAZ_DT0,X
		ORA	<WORK2
		STA	[<WORK4],Y
		STA	[<WORK10],Y
		LDA	GMGOAL_KAZ_DT1,X
		ORA	<WORK2
		STA	[<WORK7],Y
		STA	[<WORK13],Y
;
SCR_BUFST_30	EQU	$
		STZ	<WORK0		; |Cg v
		STZ	<WORK2
		LDX	#00004H
		LDA	!GOAL_TIM_PT
		CLC
		ADC	!GOAL_CON_PT
		CLC
		ADC	!GOAL_SPL_PT
		CMP	#00100		; POO_ ?
		BCC	SCR_BUFST_35	;	NO -> SCR_BUFST_35
		LDA	#00100
SCR_BUFST_35	EQU	$
		STA	!GOAL_TTL_PT
		CMP	#00100
		BCC	SCR_BUFST_45
		LDA	#00011
		STA	<WORK0
		DEC	A
		BRA	SCR_BUFST_50
SCR_BUFST_45	EQU	$
		CMP	#00010
		BCC	SCR_BUFST_50
		INC	<WORK0
		SBC	#00010
		BRA	SCR_BUFST_45
;
SCR_BUFST_50	EQU	$		; ̈
		ASL	A
		TAY
		LDA	GMGOAL_KAZ_DT0,Y
		STA	>GALSCR_TOL0+4
		LDA	GMGOAL_KAZ_DT1,Y
		STA	>GALSCR_TOL1+4
;
		LDA	<WORK0		; \̈
		BEQ	SCR_BUFST_55
		ASL	A
		TAY
		LDA	GMGOAL_KAZ_DT0,Y
		STA	>GALSCR_TOL0+2
		LDA	GMGOAL_KAZ_DT1,Y
		STA	>GALSCR_TOL1+2
;
SCR_BUFST_55	EQU	$
		LDA	<WORK2		; S̈
		ASL	A
		TAY
		BEQ	SCR_BUFST_VRM
		LDA	GMGOAL_KAZ_DT0,Y
		STA	>GALSCR_TOL0
		LDA	GMGOAL_KAZ_DT1,Y
		STA	>GALSCR_TOL1
;
SCR_BUFST_VRM	EQU	$
		LDA	#BANK GALSCRBF
		STA	<WORK1
		LDY	#034A0H		;(Y) <-- VRAM address
		LDX	#GALSCRBF	;(X) <-- A bus address
		LDA	#00018*00040H	;(A) <-- number byte
		JSL	>VRAMDX_ST
;
		RTS
		MEM8
		IDX8
;
;----------------------------------------------------------------
;-		nCXRA `FbN				-
;----------------------------------------------------------------
GMGOAL_HICHK	EQU	$
		JSR	GOAL_MJ_CHNG
		LDA	#030H
		STA	!GLWAITTIM
		MI16			; memory , index 16bit mode
		STZ	!SPECIAL_P
		LDX	#GMGOAL_2LN
		LDA	!GOAL_TTL_PT
		BMI	GMGOAL_HICHK_80
		CMP	!HISCORE	; nCXRA ?
		BCC	GMGOAL_HICHK_80 ;	NO -> GMGOAL_HICHK_80
		LDX	#GMGOAL_MR
GMGOAL_HICHK_80 EQU	$
		STX	!GOAL_IN
		MI8			; memory , index 8bit mode
		RTS
;
;----------------------------------------------------------------
;-		QC				-
;----------------------------------------------------------------
GMGOAL_2LINE_DT EQU	$
		WORD	GALSCR_LIN0,GALSCR_LIN1,GALSCR_LIN2,GALSCR_LIN3
		WORD	GALSCR_LIN1,GALSCR_LIN2
;
GMGOAL_2LINE_CH EQU	$
		WORD	00555H,00556H,00557H,0015FH
		WORD	00565H,00566H
;
;
GMGOAL_2LINE	EQU	$
		JSR	GOAL_MJ_CHNG
		LDA	#BANK GALSCR_LIN0
		STA	<WORK2
		MI16			; memory , index 16bit mode
		LDA	!SPECIAL_P
		AND	#000FEH
		TAX
		CPX	#GMGOAL_2LINE_CH-GMGOAL_2LINE_DT
		BCC	GMGOAL_2LINE_10
		LDA	#GMGOAL_CC
		STA	!GOAL_IN
		BRA	GMGOAL_2LINE_90
GMGOAL_2LINE_10 EQU	$
		LDA	GMGOAL_2LINE_DT,X
		STA	<WORK0
		LDA	GMGOAL_2LINE_CH,X
		STA	[<WORK0]
		INC	!SPECIAL_P
		JSR	SCR_BUFST_VRM
GMGOAL_2LINE_90 EQU	$
		MI8			; memory , index 8bit mode
		RTS
;
;----------------------------------------------------------------
;-		܂鏑					-
;----------------------------------------------------------------
GMGOAL_MARU_DT	EQU	$
		WORD	GALSCR_EN0,GALSCR_EN1,GALSCR_EN2,GALSCR_EN3
		WORD	GALSCR_EN4,GALSCR_EN5,GALSCR_EN6,GALSCR_EN7
		WORD	GALSCR_EN8,GALSCR_EN9
;
GMGOAL_MARU_CH	EQU	$
		WORD	00562H,00561H,00560H,00563H
		WORD	00553H,00550H,00551H,00552H
		WORD	00554H,0015FH
;
;
GMGOAL_MARU	EQU	$
		JSR	GOAL_MJ_CHNG
		LDA	#BANK GALSCR_EN0
		STA	<WORK2
		LDA	#030H
		STA	!GLWAITTIM
		MI16			; memory , index 16bit mode
		LDA	!SPECIAL_P
		AND	#000FEH
		TAX
		CPX	#GMGOAL_MARU_CH-GMGOAL_MARU_DT
		BCC	GMGOAL_MARU_10
		LDX	#GMGOAL_HI
		LDA	!GOAL_TTL_PT
		CMP	#00100		; vPOO_ ?
		BNE	GMGOAL_MARU_05	;	NO -> GMGOAL_MARU_05
		STZ	!SPECIAL_P
		LDX	#GMGOAL_HN
GMGOAL_MARU_05	EQU	$
		STX	!GOAL_IN
		BRA	GMGOAL_MARU_90
GMGOAL_MARU_10	EQU	$
		LDA	GMGOAL_MARU_DT,X
		STA	<WORK0
		LDA	GMGOAL_MARU_CH,X
		STA	[<WORK0]
		INC	!SPECIAL_P
		JSR	SCR_BUFST_VRM
GMGOAL_MARU_90	EQU	$
		MI8			; memory , index 8bit mode
		RTS
;
;----------------------------------------------------------------
;-		Ԃ܂鏑					-
;----------------------------------------------------------------
GMGOAL_HANA_DT	EQU	$
		WORD	GALSCR_HEN0,GALSCR_HEN1,GALSCR_HEN2,GALSCR_HEN3
		WORD	GALSCR_HEN4,GALSCR_HEN5,GALSCR_HEN6,GALSCR_HEN7
		WORD	GALSCR_HEN8,GALSCR_HEN9,GALSCR_HENA,GALSCR_HENB
;
GMGOAL_HANA_CH	EQU	$
		WORD	0056BH,0056AH,00569H,0056DH
		WORD	0055DH,00559H,0055AH,0055BH
		WORD	0055CH,0055EH,0015FH,0056CH
;
;
GMGOAL_HANA_IN	EQU	$
		LDA	#095H
		STA	<SOUND_3	; sound set!!
		JSR	GOALMD_INC
;
GMGOAL_HANA	EQU	$
		JSR	GOAL_MJ_CHNG
		LDA	#BANK GALSCR_HEN0
		STA	<WORK2
		MI16			; memory , index 16bit mode
		LDA	!SPECIAL_P
		AND	#000FEH
		TAX
		CPX	#GMGOAL_HANA_CH-GMGOAL_HANA_DT
		BCC	GMGOAL_HANA_10
		LDA	#GMGOAL_HI
		STA	!GOAL_IN
		LDA	#00030H
		STA	!GLWAITTIM
		BRA	GMGOAL_HANA_90
GMGOAL_HANA_10	EQU	$
		LDA	GMGOAL_HANA_DT,X
		STA	<WORK0
		LDA	GMGOAL_HANA_CH,X
		STA	[<WORK0]
		INC	!SPECIAL_P
		JSR	SCR_BUFST_VRM
GMGOAL_HANA_90	EQU	$
		MI8			; memory , index 8bit mode
		RTS
;
;----------------------------------------------------------------
;-		nCXRA ʕ\				-
;----------------------------------------------------------------
GMGOAL_HSCST	EQU	$
		JSR	GOAL_MJ_CHNG
		MI16			; memory , index 16bit mode
		LDA	!GOAL_TTL_PT
		CMP	!HISCORE	; nCXRA ?
		BCS	GMGOAL_HSCST_10 ;	YES -> GMGOAL_HSCST_10
		LDA	#GMGOAL_CC
		STA	!GOAL_IN
		BRA	GMGOAL_HSCST_90
;
GMGOAL_HSCST_10 EQU	$
		STA	!HISCORE
		STZ	<WORK0
		CMP	#00100
		BCC	GMGOAL_HSCST_15
		LDA	#00011
		STA	<WORK0
		DEC	A
		BRA	GMGOAL_HSCST_20
GMGOAL_HSCST_15 EQU	$
		CMP	#00010
		BCC	GMGOAL_HSCST_20
		INC	<WORK0
		SBC	#00010
		BRA	GMGOAL_HSCST_15
;
GMGOAL_HSCST_20 EQU	$		; ̈
		ASL	A
		TAY
		LDA	GMGOAL_KAZ_DT0,Y
		STA	>GALSCR_HISCR0+2
		LDA	GMGOAL_KAZ_DT1,Y
		STA	>GALSCR_HISCR1+2
;
		LDA	<WORK0		; \̈
		ASL	A
		TAY
		BEQ	GMGOAL_HSCST_80
		LDA	GMGOAL_KAZ_DT0,Y
		STA	>GALSCR_HISCR0
		LDA	GMGOAL_KAZ_DT1,Y
		STA	>GALSCR_HISCR1
		JSR	SCR_BUFST_VRM
;
GMGOAL_HSCST_80 EQU	$
		INC	!GOAL_IN
		INC	!GOAL_IN
GMGOAL_HSCST_90 EQU	$
		MI8			; memory , index 8bit mode
		RTS
;
;----------------------------------------------------------------
;-		nCXRA ʕ\	(}[N_)		-
;----------------------------------------------------------------
GMGOAL_FLSH	EQU	$
		MI16			; memory , index 16bit mode
		LDA	#00570H
		STA	>GALSCR_LFLSH0
		STA	>GALSCR_RFLSH0
		LDA	#00572H
		STA	>GALSCR_LFLSH1
		STA	>GALSCR_RFLSH1
		LDA	#00571H
		STA	>GALSCR_LFLSH0+2
		STA	>GALSCR_RFLSH0+2
		LDA	#00573H
		STA	>GALSCR_LFLSH1+2
		STA	>GALSCR_RFLSH1+2
		JSR	SCR_BUFST_VRM
;
		INC	!GOAL_IN
		INC	!GOAL_IN
		MI8			; memory , index 8bit mode
		RTS
;
;
;----------------------------------------------------------------
;-		Z						-
;-			hm jdx v`hs			-
;----------------------------------------------------------------
GMGOAL_CALC	EQU	$
		JSR	GOAL_MJ_CHNG
;
		LDA	<KEYC1
		ORA	<KEYC1L
		AND	#11110000B	; return to map ?
		BEQ	GMGOAL_CALC_900 ;	NO -> GMGOAL_CALC_900
;
;-------------- return to map !! --------------------------------
		JSL	>EGG_SAVE
;
		LDX	#HMPIN
		LDA	!BNS_GO_FG
		BPL	GMGOAL_CALC_003
		JSR	BONUS_NO_SET
		LDX	#BNSGM
GMGOAL_CALC_003 EQU	$
		STX	!MODENO
		LDA	#0F1H
		STA	<SOUND_0
		INC	!CORSCLR	;R[XNA[tOhnmh!!
		LDX	!MAPOINT
		LDA	!HISCORE
		CMP	!HISCEBF,X
		BEQ	GMGOAL_CALC_008
		BCC	GMGOAL_CALC_008
		PHA
		LDA	!MPCLRTBL,X
		AND	#07FH		; R[XNA Ă ?
		BEQ	GMGOAL_CALC_005 ;	NO -> GMGOAL_CALC_005
		LDA	!HISCEBF,X
		ORA	#080H
		STA	!CORSCLR
GMGOAL_CALC_005 EQU	$
		PLA
GMGOAL_CALC_008 EQU	$
		STA	!HISCEBF,X
;
GMGOAL_CALC_900 EQU	$
		RTS
;
;----------------------------------------------------------------
;-		S[				-
;----------------------------------------------------------------
GOAL_MJ_CHNG	EQU	$
		LDA	!GOAL_IN
		CMP	#GMGOAL_CC
		BCC	GOAL_MJ_900
		DEC	!GOAL_CHR_CNT
		BPL	GOAL_MJ_900
		LDA	#005H
		STA	!GOAL_CHR_CNT
		MI16			; memory , index 16bit mode
		LDA	!GOAL_CHR_CHNG
		TAX
		LDA	GOAL_MJ_DAT+2,X
		AND	#000FFH
		STA	<WORK1		; bank NO. set
		LDY	#02800H		;(Y) <-- VRAM address
		LDA	GOAL_MJ_DAT,X
		TAX			;(X) <-- A bus address
		LDA	#0800H		;(A) <-- number byte
		JSL	>VRAMDX_ST
		MI8			; memory , index 8bit mode
;
		LDA	!GOAL_CHR_CHNG
		INC	A
		INC	A
		INC	A
		CMP	#GOAL_MJ_DAT_E-GOAL_MJ_DAT
		BCC	GOAL_MJ_500
		LDA	#000H
GOAL_MJ_500	EQU	$
		STA	!GOAL_CHR_CHNG
;
GOAL_MJ_900	EQU	$
		RTS
;
GOAL_MJ_DAT	EQU	$
		LWORD	CHR74
		LWORD	CHR74+0800H
		LWORD	CHR74+1000H
GOAL_MJ_DAT_E	EQU	$
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+		{[iX Q[ m. Zbg		+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
CADE	EQU	000	; J[h߂
SKCH	EQU	CADE+2	; XNb`
KUJI	EQU	SKCH+2	; т
CINM	EQU	KUJI+2	; J[h킹
RULT	EQU	CINM+2	; [bg
SROT	EQU	RULT+2	; Xbg
;
;
BNS_NO_TBL	EQU	$
		BYTE	CADE,SKCH
		BYTE	KUJI,SROT
		BYTE	CINM,RULT
		BYTE	KUJI,SKCH
		BYTE	CADE,RULT
		BYTE	CINM,SROT
;
;
BONUS_NO_SET	EQU	$
		JSL	>RANDAM
		AND	#001H
		STA	<WORK0
		LDA	!MPTYPE
		CLC
		ADC	<WORK0
		TAX
		LDA	BNS_NO_TBL,X
		STA	!BONUSNO
		CMP	#RULT		; [bg ?
		BNE	BONUS_NO_900	;	NO -> BONUS_NO_900
		LDA	!PLCONT
		DEC	A		; vC[̎clQlȏォ ?
		BNE	BONUS_NO_900	;	YES -> BONUS_NO_900
		LDA	BNS_NO_TBL-1,X
		STA	!BONUSNO
BONUS_NO_900	EQU	$
		RTS
;
;************************************************************************
;*		game play						*
;************************************************************************
;
;-------------- JEg_EpLN^[AhXf[^ ----------
;
;-------------- O`X܂ --------------------------------------
CNTDOWN_CHR	EQU	$
		WORD	CHR50+(200H*20H)  ;[0]
		WORD	CHR50+(202H*20H)  ;[1]
		WORD	CHR50+(204H*20H)  ;[2]
		WORD	CHR50+(206H*20H)  ;[3]
		WORD	CHR50+(208H*20H)  ;[4]
		WORD	CHR50+(20AH*20H)  ;[5]
		WORD	CHR50+(20CH*20H)  ;[6]
		WORD	CHR50+(20EH*20H)  ;[7]
		WORD	CHR50+(220H*20H)  ;[8]
		WORD	CHR50+(222H*20H)  ;[9]
;
;-------------- POȏ ----------------------------------------
CNTDOWN_CHR_10	EQU	$
		WORD	CHR50+(0B0H*20H)  ;[0]
		WORD	CHR50+(0B1H*20H)  ;[1]
		WORD	CHR50+(0B2H*20H)  ;[2]
		WORD	CHR50+(0B3H*20H)  ;[3]
		WORD	CHR50+(0D0H*20H)  ;[4]
		WORD	CHR50+(0D1H*20H)  ;[5]
		WORD	CHR50+(0D2H*20H)  ;[6]
		WORD	CHR50+(0D3H*20H)  ;[7]
		WORD	CHR50+(0D4H*20H)  ;[8]
		WORD	CHR50+(0D5H*20H)  ;[9]
;
;-------------- JEg_Epn`lZbgf[^ ------------------
CTDWX_U_L	EQU	020H
CTDWY_U_L	EQU	020H
CTDWX_U_R	EQU	0C0H
CTDWY_U_R	EQU	020H
;
CNTDOWN_OAM_IN	EQU	$
		BYTE	CNTDOWN_OAM_U_L-CNTDOWN_OAM+(5*4)-2 ;[0]
		BYTE	CNTDOWN_OAM_U_R-CNTDOWN_OAM+(5*4)-2 ;[1]
;
CNTDOWN_OAM	EQU	$
;			      X		     Y	       CH   AT
CNTDOWN_OAM_U_L EQU	$
		BYTE	008H+CTDWX_U_L,008H+CTDWY_U_L,00CH,032H ;[0]
		BYTE	000H+CTDWX_U_L,000H+CTDWY_U_L,0C8H,032H ;[1]
		BYTE	010H+CTDWX_U_L,000H+CTDWY_U_L,0C8H,072H ;[2]
		BYTE	000H+CTDWX_U_L,010H+CTDWY_U_L,0C8H,0B2H ;[3]
		BYTE	010H+CTDWX_U_L,010H+CTDWY_U_L,0C8H,0F2H ;[4]
CNTDOWN_OAM_U_R EQU	$
		BYTE	008H+CTDWX_U_R,008H+CTDWY_U_R,00CH,032H ;[0]
		BYTE	000H+CTDWX_U_R,000H+CTDWY_U_R,0C8H,032H ;[1]
		BYTE	010H+CTDWX_U_R,000H+CTDWY_U_R,0C8H,072H ;[2]
		BYTE	000H+CTDWX_U_R,010H+CTDWY_U_R,0C8H,0B2H ;[3]
		BYTE	010H+CTDWX_U_R,010H+CTDWY_U_R,0C8H,0F2H ;[4]
;
;-------------- Ԃ񃌁[_[n`lZbgf[^ ----------------------
BABY_MK_XAD	EQU	$
		WORD	0FFF0H,00010H  ;,00000H,00000H
BABY_MK_YAD	EQU	$
		WORD	00000H,00000H,0FFEAH,00010H
BABY_MK_OAMDT	EQU	$
;			X  Y  CH AT
		HEX	00,03,C4,30	;[E]
		HEX	08,00,D5,30
		HEX	00,05,C4,B0
		HEX	08,08,D5,B0
		HEX	00,00,D5,70	;[]
		HEX	08,03,C4,70
		HEX	00,08,D5,F0
		HEX	08,05,C4,F0
		HEX	03,00,C4,30	;[]
		HEX	05,00,C4,70
		HEX	00,08,C5,F0
		HEX	08,08,C5,B0
		HEX	00,00,C5,70	;[]
		HEX	08,00,C5,30
		HEX	03,08,C4,B0
		HEX	05,08,C4,F0
;
;-------------- [^[J[Aj[Vf[^ ----------------------
METCOLD		EQU	$
		WORD	003FFH,0023FH,0001FH,04010H,07C00H,07E00H,047E0H,003F4H
		WORD	003FFH,0023FH,0001FH
;
BACKCLD		EQU	$
		WORD	07D93H,07FFFH,07FFFH,07FFFH,07DF5H,07FF7H,07FF9H,07DF5H
		WORD	07FF9H,07FFFH,00000H,00000H,00000H,00000H,00000H,00000H
;
		WORD	07D93H,07FFFH,07FFFH,07EBAH,07E17H,07FF7H,07F18H,07E76H
		WORD	07FFBH,07FFDH,00000H,00000H,00000H,00000H,00000H,00000H
;
		WORD	07D93H,07FFFH,07FFFH,07E17H,07EBAH,07FF7H,07E76H,07F18H
		WORD	07FFDH,07FFBH,00000H,00000H,00000H,00000H,00000H,00000H
;
		WORD	07D93H,07FFFH,07FFFH,07DF5H,07FFFH,07FF7H,07DF5H,07FF9H
		WORD	07FFFH,07FF9H,00000H,00000H,00000H,00000H,00000H,00000H
;
COLDTAR		EQU	$
		BYTE	0FH*2*1-1,0FH*2*2-1,0FH*2*3-1,0FH*2*4-1,0FH*2*3-1,0FH*2*2-1
;
;-------------- tilt data -----------------------------------------------
TILTAD		EQU	$
		WORD	00001H,00000H,0FFFFH,00000H,0FFFEH,00000H,0FFFFH,00000H
TILTAD2		EQU	$
		WORD	0FFFEH,00000H,00002H,00000H,0FFFEH,00000H,0FFFCH,00000H
;
;-------------- hrrhUCNZbgf[^ ------------------------
BIRIBIRI_MOZDT	EQU	$
		BYTE	0111B+(00H<<4),0111B+(00H<<4),0111B+(01H<<4),0111B+(01H<<4)
		BYTE	0111B+(02H<<4),0111B+(02H<<4),0111B+(03H<<4),0111B+(03H<<4)
		BYTE	0111B+(04H<<4),0111B+(04H<<4),0111B+(05H<<4),0111B+(05H<<4)
		BYTE	0111B+(06H<<4),0111B+(06H<<4),0111B+(07H<<4),0111B+(07H<<4)
;
;-------------- pause check data ----------------------------------------
GMPASAD		EQU	$
		HEX	FF,01
;
;-------------- item select check data ----------------------------------
ITMSL_INIT	EQU	$
;;;;		    HEX	    FF,02
ITMSLAD		EQU	$
		HEX	FE,02
ITMSLCP		EQU	$
		HEX	00,28
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		initial game play					x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
GMPLAY2		EQU	$
		PHB			;(DBR) save
		PHK
		PLB
;
;------------------------------------------------------------------------
;-		key cancel !!						-
;------------------------------------------------------------------------
		STZ	<KEYC1
		STZ	<KEYC1L
		STZ	<KEYC2
		STZ	<KEYC2L
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		game play						x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
GMPLAY		EQU	$
;
;
;
;
;
		M16
;
		lda	<0f9h
		sta	MANSEL
		lda	<0fbh
		sta	WMANSL
;
		M8
;
;
;
;
;
;------------------------------------------------------------------------
;-		[hVnaiNA[					-
;------------------------------------------------------------------------
		LDA	#00010000B
		STA	OBJ_BG_FG
		STZ	OBJ_BG_FG+1
;
;------------------------------------------------------------------------
;-		massage display check					-
;------------------------------------------------------------------------
		LDA	MSGMOD		; bZ[W\ ?
		BEQ	GM_PAUSE_CHK	;	NO -> GM_PAUSE_CHK
;
		JSL	>MSGDSP
		JMP	GMPL010
;
;------------------------------------------------------------------------
;-		pause check						-
;------------------------------------------------------------------------
INTPRMT_ADR	EQU	$-2
		WORD	TIME10_PRMT	; 1 ^C}[ PO
		WORD	TIME20_PRMT	; 2 ^C}[ QO
		WORD	POW_PRMT	; 3 ǂłonv
		WORD	EGG_PRMT	; 4 ł^}S
		WORD	GARASU_PRMT	; 5 ߂
		WORD	ALLHTN_PRMT	; 6 G݂ȃnei_
		WORD	SUIKA_PRMT	; 7 XCJ̎ACe
		WORD	COLD0_PRMT	; 8 XACe
		WORD	FIRE0_PRMT	; 9 ΃ACe
;
;
GM_PAUSE_CHK	EQU	$
		LDA	!GMPAUSE	; |[Y ?
		BNE	GM_PS_CHK_020	;	YES -> GM_PS_CHK_020
;
		LDA	<KEYC2
		AND	#00010000B	; X^[g L[ nm ?
		BEQ	GM_PS_CHK_FFF	;	NO -> GM_PS_CHK_FFF
		LDA	CCHGTN		; glH
		ORA	GATE_IN		; ԃ|Cgʉ߁H
		ORA	GOAL_BOSS_CLEAR ; {XNA[H
		ORA	ITEMNO		; ACegpH
		ORA	PLSTFG		; vC[rsnoH
		ORA	!ENSTFG		; GrsnoH
		BNE	GM_PS_CHK_FFF	;	YES -> GM_PS_CHK_FFF
		LDA	PLMODE
		CMP	#PDKN
		BCC	GM_PS_CHK_000	;vC[f[hH ( no:GM_PS_CHK_000 )
GM_PS_CHK_FFF	EQU	$
		JMP	GMPL010
;
GM_PS_CHK_000	EQU	$
		LDA	!GMPASMK
		EOR	#001
		AND	#001
		STA	!GMPASMK
		LDA	#001
		STA	!GMPAUSE
;
GM_PS_CHK_020	EQU	$
;;;;K;;;;		JSL	>OAMCLR		;OAM clear
;
;----------------------------------------------------------------
;-		pause move					-
;----------------------------------------------------------------
		LDA	<KEYC2
		AND	#00100000B	; R[X NA ?
		BEQ	GMPL004		;	NO -> GMPL004
;
;---------------------------------------------- test TEST
sagi1		equ	$
		bra	test_pas_050
		lda	!SVFILEIDX
		cmp	#001*2
		bne	test_pas_050
		inc	!CORSCLR
		bra	test_pas_100
test_pas_050	equ	$
;---------------------------------------------- test TEST
;
		LDX	!MAPOINT
		LDA	!MPCLRTBL,X
		AND	#07FH
		BEQ	GMPL004
;
;-------------- course clear !! ---------------------------------
test_pas_100	equ	$
		LDA	#0F0H
		STA	<SOUND_0
		LDA	#01H		;[]
		STA	<SOUND_3
;
		CPX	#INT_STAT	; KR[X ?
		BNE	GMPL002		;	NO -> GMPL002
		STZ	!MAPOINT
GMPL002		EQU	$
;;;;K;;;;		LDA	#HMPIN
		LDA	#HMPFAD
		STA	MODENO
;
		PLB
		RTL
;
;
;
GMPL004		EQU	$
		JMP	GMPASUB
;
;------------------------------------------------------------------------
;-		game move						-
;------------------------------------------------------------------------
GMPL010		EQU	$
		LDA	!ITEMNO		; ACegp ?
		BEQ	GMPL010_PASS	;	NO -> GMPL010_PASS
;
		LDX	ITEM_TM
		BEQ	GMPL0100	;EFCgH ( no:GMPL0100 )
		DEC	ITEM_TM
		BRA	GMPL010_PASS
;
GMPL0100	EQU	$
		ASL	A
		TAX			; gpACe
;
		M16
;
		JSR	(INTPRMT_ADR,X) ;	ep[^ Zbg
;
		M8
		BRA	GMPL010_PASS
;
PAUSE_SUB	EQU	$		;|[YɂIuWFZbgp
		PHB			;
		PHK			;
		PLB			;
;
GMPL010_PASS	EQU	$
		JSL	>OAMDXCLR	;OAM clear
;
;------------------------------------------------------------------------
;-		scroll counter set					-
;------------------------------------------------------------------------
		JSL	>PLSCRL		;scroll set
;
;------------------------------------------------------------------------
;-		BG write						-
;------------------------------------------------------------------------
		JSL	>BGSET		;BG write
		JSL	>BG3SCK		;"mogura" course BG3 screen set check
;
;------------------------------------------------------------------------
;-		to "Tilt" scroll counter save				-
;------------------------------------------------------------------------
;
		M16
;
		LDA	<SCCV1
		PHA			;BG1 scroll counter_V save
;
;------------------------------------------------------------------------
;-		"Tilt" set						-
;------------------------------------------------------------------------
		LDA	ENSTFG
		ORA	BIRIBIRI
		ORA	ITEMNO
		BNE	GMPL020		;rsnoH ( yes:GMPL020 )
;
		LDA	TILTCT2
		BEQ	GMPL012		;tilt ? ( no:GMPL012 )
;
		PHA
		LDA	TILTCT
		BEQ	GMPL011

		DEC	TILTCT

GMPL011		EQU	$
		PLA
		DEC	TILTCT2
		AND	#07H
		ASL	A
		TAY
		LDA	!TILTAD2,Y
		BRA	GMPL0120
;
GMPL012		EQU	$
		LDA	TILTCT
		BEQ	GMPL013		;tilt ? ( no:GMPL013 )
;
		DEC	TILTCT
		AND	#07H
		ASL	A
		TAY
		LDA	!TILTAD,Y

GMPL0120	EQU	$
		STA	TILTAL		;"Tilt" counter set
		CLC
		ADC	<SCCV1
		STA	<SCCV1
		STA	ESCCV1
;
		LDY	BG3TYP
		CPY	#09H
		BEQ	GMPL0128
		CPY	#0AH
		BNE	GMPL013
GMPL0128	EQU	$
		LDA	TILTAL
		CLC
		ADC	<SCCV3
		STA	<SCCV3
		STA	ESCCV3
;
GMPL013		EQU	$
;
;------------------------------------------------------------------------
;-		offset data set						-
;------------------------------------------------------------------------
GMPL020		EQU	$
;
		M8
;
		LDX	BG2OF_FG	;(X) <-- ItZbg[h^Cv
		BEQ	GMPL030		;ItZbg[hH ( no:GMPL030 )
;
		JSR	(!BG2OFST_TBL,X)
;
;------------------------------------------------------------------------
;-		OAM set							-
;------------------------------------------------------------------------
GMPL030		EQU	$
		JSL	>ENCSET		;enemy	OAM set
		JSL	>PLCSET		;player	   "
;
;------------------------------------------------------------------------
;-		player move						-
;------------------------------------------------------------------------
		JSL	>PLAYER		;player move
;
;------------------------------------------------------------------------
;-		enemy move						-
;------------------------------------------------------------------------
		JSL	>ENEMY		;enemy move
;
;------------------------------------------------------------------------
;-		H-DMA data set						-
;------------------------------------------------------------------------
		JSR	SPACIAL
;
;------------------------------------------------------------------------
;		J[]						-
;------------------------------------------------------------------------
		LDA	!DSPMOD
		CMP	#009
		BEQ	LIF150_PASS
;
		LDA	COLTRP
		ASL	A
		TAX
		JSR	(!COLTR_SEL,X)
;
;------------------------------------------------------------------------
;-		hrrhZbg					-
;------------------------------------------------------------------------
LIF150_PASS	EQU	$
		LDA	BIRIBIRI
		BEQ	MET150		;hrrhH ( no:MET150 )
;
		DEC	BIRIBIRI
		AND	#0FH
		TAX
		LDA	!BIRIBIRI_MOZDT,X
;
MET150		EQU	$
		STA	MOZNO
;
;------------------------------------------------------------------------
;-		to "Tilt" scroll counter load				-
;------------------------------------------------------------------------
;
		M16			; memory 16bit mode
;
		PLA			;BG1 scroll counter_V load
		STA	<SCCV1
		STA	ESCCV1
;
;------------------------------------------------------------------------
;-		ԂJEg_E`FbN				-
;------------------------------------------------------------------------
		LDA	BABYNO		;ԂJEg_EtOZbg
		AND	#1010000000000000B
		STA	BABYDWN
		LDA	CCHGMK
		ORA	CCHGFG
		ORA	GMFADE_CT
		ORA	ENSTFG
		ORA	GOAL_IN
		ORA	GOAL_BOSS_CLEAR
		ORA	ITEMNO
		BEQ	GMPL032		;ԂJEg_EnjH ( yes:GMPL032 )
		LDA	#01H
GMPL032		EQU	$
		ORA	BABYDWN
		STA	BABYDWN
		BNE	GMPL040		;ԂJEg_EH ( no:GMPL040 )
;
;-------------- ^CNZbg`FbN ----------------------------------
		LDA	TIMCHG
		BEQ	GMPL040		;^CNZbgH ( no:GMPL040 )
;
		LDA	TIMER
		CMP	#110		;(C) set
		LDA	#057H		;[]
		BCS	GMPL034
;;;;		    BCS	    GMPL040
		LDA	#058H		;[]
GMPL034		EQU	$
		JSL	>SOUND_3_ON
;
;-------------- ߂ēGɓbZ[W\`FbN ----------------
		LDY	SV_STATUS
		BMI	GMPL036		;߂ēGɓbZ[W\njH ( no:GMPL036 )
;
		LDY	MAPOINT
		BEQ	GMPL035		;Pv|PH ( yes:GMPL035 )
		CPY	#INT_STAT
		BNE	GMPL036		;Pv|OH ( no:GMPL036 )
GMPL035		EQU	$
		LDA	#080H		;bZ[W\σZbg
		TSB	SV_STATUS
		INC	MSGMOD		;bZ[W\hnmh
		LDA	#MIS_MSG
		STA	>MSG_NO
;
GMPL036		EQU	$
;
;------------------------------------------------------------------------
;-		OAM data convert					-
;------------------------------------------------------------------------
GMPL040		EQU	$
		LDX	#BANK DX_OAM
		LDA	#DX_OAM
		JSL	>CHIPON1	;[ "TASK !!" mater set ]
;
;------------------------------------------------------------------------
;-		ԂUJEg`FbN				-
;------------------------------------------------------------------------
COUNT_DOWN	EQU	$
		LDA	OBJ_TIMER_DISP
		BEQ	COUNT_DOWN_0050
		DEC	OBJ_TIMER_DISP
;
COUNT_DOWN_0050 EQU	$
		LDA	GMFADE_CT
		ORA	GOAL_IN
		ORA	GOAL_BOSS_CLEAR
		BNE	COUNT_DOWN_011	;J[eEBhEH ( yes:COUNT_DOWN_011 )
;
		LDA	TIMER
		CMP	#109
		BCC	COUNT_DOWN_018	;naiJE^[\H ( yes:COUNT_DOWN_018 )
;
		LDA	BABYDWN
		BEQ	COUNT_DOWN_020	;Ԃ񃌁[_[ZbgH ( yes:COUNT_DOWN_020 )
;
		LDA	OBJ_TIMER_DISP
		BNE	COUNT_DOWN_0102 ;nai^C}[\H ( yes:COUNT_DOWN_0102 )
;
		LDA	<KEYC1L
		ORA	PLMODE
		ORA	MSGMOD
		BNE	COUNT_DOWN_011	;L[͖vC[fH ( no:COUNT_DOWN_011 )
;
		LDA	OBJ_TIMER_WAIT
		CMP	#60H
		BCS	COUNT_DOWN_0102 ;nai^C}[\H ( yes:COUNT_DOWN_0102 )
		INC	OBJ_TIMER_WAIT
		BRA	COUNT_DOWN_0100
;
COUNT_DOWN_011	EQU	$
		STZ	OBJ_TIMER_WAIT
COUNT_DOWN_0100 EQU	$
		LDY	DSPMOD
		CPY	#0DH
		BEQ	COUNT_DOWN_0102 ;QQ`̈ݑ܁H ( yes:COUNT_DOWN_0102 )
		JMP	LIF150
;
;-------------- ԃQ[gʉ߃^C}[toII ------------------
COUNT_DOWN_0102 EQU	$
		JMP	COUNT_DOWN_100
;
;-------------- Ԃ񃌁[_[n`lZbg ----------------------------
COUNT_DOWN_018	EQU	$
		STZ	OBJ_TIMER_WAIT
;
		LDA	BABYDWN
		BNE	COUNT_DOWN_0102 ;Ԃ񃌁[_[ZbgH ( no:COUNT_DOWN_0102 )
;
COUNT_DOWN_020	EQU	$
		LDX	#04		;(X) <-- ixj
		LDA	ENDSXL
		SEC
		SBC	#08H
		CMP	#(0100H-018H)-08H
		BCS	COUNT_DOWN_030	;wWI[o[H ( yes:COUNT_DOWN_030 )
		LDA	ENDSYL
		SEC
		SBC	#010H
		CMP	#(0D9H-08H)-010H
		BCC	COUNT_DOWN_090	;xWI[o[H ( no:COUNT_DOWN_090 )
;
COUNT_DOWN_030	EQU	$
		LDA	ENDSYL
		SEC
		SBC	#(0D9H/2)-08H	;[ 0B9H:V size ]
		STA	<WORK4		;(WK4,5) <-- Ŝx
		ABS16
		STA	<WORK6		;(WK6,7) <-- `ariŜxj
		LDA	ENDSXL
		SEC
		SBC	#(100H/2)-08H
		STA	<WORK0		;(WK0,1) <-- Ŝw
		ABS16
		STA	<WORK2		;(WK2,3) <-- `ariŜwj
;
		CMP	<WORK6
		BCC	COUNT_DOWN_080	;wɃ[_[\H ( yes:COUNT_DOWN_080 )
		LDX	#00		;(X) <-- w
COUNT_DOWN_080	EQU	$
		LDA	<WORK0,X
		BPL	COUNT_DOWN_090	;̉EẢH
		INX
		INX
COUNT_DOWN_090	EQU	$
		LDA	ENDSXL
		CLC
		ADC	!BABY_MK_XAD,X
		CMP	#02H
		BPL	COUNT_DOWN_092
		LDA	#02H
COUNT_DOWN_092	EQU	$
		CMP	#0100H-12H+1
		BMI	COUNT_DOWN_094
		LDA	#0100H-12H
COUNT_DOWN_094	EQU	$
		STA	<WORK2
		LDA	ENDSYL
		CLC
		ADC	!BABY_MK_YAD,X
		CMP	#0AH
		BPL	COUNT_DOWN_096
		LDA	#0AH
COUNT_DOWN_096	EQU	$
		CMP	#0D9H-012H+1
		BMI	COUNT_DOWN_098
		LDA	#0D9H-012H
COUNT_DOWN_098	EQU	$
		STA	<WORK3
		TXA
		ASL	A
		ASL	A
		ASL	A
		TAX
		LDA	FRCNT2
		AND	#04H
		LSR	A
;;;;		    CLC
		ADC	#02H
		XBA
		STA	<WORK		;(WK0,1) <-- J[
		CLC			;[ * (C) <- 0 ]
		LDA	<WORK2
		ADC	!BABY_MK_OAMDT,X
		STA	OAM+(5*4)	;n`l	 wCxWZbg
		LDA	!BABY_MK_OAMDT+2,X
		ORA	<WORK
		STA	OAM+(5*4)+2	;n`l	 LmDC`ssZbg
		LDA	<WORK2
		ADC	!BABY_MK_OAMDT+4,X
		STA	OAM+(5*4)+4	;n`l	 wCxWZbg
		LDA	!BABY_MK_OAMDT+6,X
		ORA	<WORK
		STA	OAM+(5*4)+6	;n`l	 LmDC`ssZbg
		LDA	<WORK2
		ADC	!BABY_MK_OAMDT+8,X
		STA	OAM+(5*4)+8	;n`l	 wCxWZbg
		LDA	!BABY_MK_OAMDT+10,X
		ORA	<WORK
		STA	OAM+(5*4)+10	;n`l	 LmDC`ssZbg
		LDA	<WORK2
		ADC	!BABY_MK_OAMDT+12,X
		STA	OAM+(5*4)+12	;n`l	 wCxWZbg
		LDA	!BABY_MK_OAMDT+14,X
		ORA	<WORK
		STA	OAM+(5*4)+14	;n`l	 LmDC`ssZbg
;
;-------------- naiJE^[\ ------------------------------------
COUNT_DOWN_100	EQU	$
;
;-------------- JEgLN^[]Zbg ------------------
		LDA	TIMER_HI
		BEQ	COUNT_DOWN_130	;PǑ͂OH ( yes:COUNT_DOWN_130 )
;
		ASL	A
		TAX
		LDA	!CNTDOWN_CHR_10,X
		STA	PCHNO0+24
		XBA
		TAX
		INX
		INX
		STX	PCHNO0+27
		LDA	TIMER_MID
		ASL	A
		TAX
		LDA	!CNTDOWN_CHR_10,X
		STA	PCHNO0+28
		XBA
		TAX
		INX
		INX
		BRA	COUNT_DOWN_132
;
COUNT_DOWN_130	EQU	$
		LDA	TIMER_MID
		ASL	A
		TAX
		LDA	!CNTDOWN_CHR,X
		STA	PCHNO0+24
		CLC
		ADC	#020H
		STA	PCHNO0+28
		XBA
		TAX
		INX
		INX
		STX	PCHNO0+27
COUNT_DOWN_132	EQU	$
		STX	PCHNO0+31
		LDX	#BANK CHR50
		STX	PCHNO0+26
		STX	PCHNO0+30
;
		LDA	#0000001010101010B
		STA	OAMSUB		;OAM sub set
		STZ	OAMSUB+2	;    "
;
;-------------- JEgn`lZbg ----------------------------
		LDY	DSPMOD
		CPY	#0DH
		BEQ	COUNT_DOWN_133	;QQ`̈ݑ܁H ( yes:COUNT_DOWN_133 )
;
		LDA	PLDSXL
		SEC
		SBC	#((100H-010H)/2)-020H
		CMP	#020H*2
		BCC	COUNT_DOWN_136	;nai^C}[\ʒuύXH ( no:COUNT_DOWN_136 )
;
		LDX	#0
		LDA	PLDSXL
		SEC
		SBC	#(100H-010H)/2
		BPL	COUNT_DOWN_134
COUNT_DOWN_133	EQU	$
		LDX	#1
COUNT_DOWN_134	EQU	$
		STX	OBJ_TIMER_DSPS
;
COUNT_DOWN_136	EQU	$
		LDX	OBJ_TIMER_DSPS
		LDY	!CNTDOWN_OAM_IN,X
		LDX	#(5*4)-2
COUNT_DOWN_140	EQU	$
		LDA	!CNTDOWN_OAM,Y
		STA	OAM,X
		DEY
		DEY
		DEX
		DEX
		BPL	COUNT_DOWN_140
;
LIF150		EQU	$
;
		M8
;
;
;
;
;
		M16
;
		lda	KEYB2L
		and	#0100000000000000B
		beq	test_0010
		lda	<0feh
		eor	#00000001B+(00000001B*100H)
		sta	<0feh
test_0010	EQU	$
		lda	KEYB2L
		and	#0000000001000000B
		beq	test_0020
		lda	<0feh
		eor	#00000010B+(00000010B*100H)
		sta	<0feh
test_0020	EQU	$
		lda	KEYB2L
		and	#0000000010000000B
		beq	test_0030
		lda	<0feh
		eor	#00000100B+(00000100B*100H)
		sta	<0feh
test_0030	EQU	$
		lda	KEYB2L
		and	#1000000000000000B
		beq	test_0040
		lda	<0feh
		eor	#00010000B+(00010000B*100H)
		sta	<0feh
test_0040	EQU	$
		lda	KEYB2L
		and	#0010000000000000B
		beq	test_0050
		lda	<0feh
		eor	#00001000B+(00001000B*100H)
		sta	<0feh
test_0050	EQU	$
		lda	KEYB2L
		and	#0001000000000000B
		beq	test_0060
		lda	#1111111111111111B
		sta	<0feh
test_0060	EQU	$
		lda	KEYB2L
		and	#0000000000100000B
		beq	test_0080
		lda	HD420C
		eor	#00000110B
		sta	HD420C
test_0080	EQU	$
		lda	KEYB2L
		and	#0000000000010000B
		beq	test_0090
		lda	<0fdh
		inc	a
		and	#03h
		tax
		stx	<0fdh
		asl	a
		tax
		lda	!test_col,x
		sta	NUKCOL
test_0090	EQU	$
		lda	<0f9h
		and	<0feh
		sta	MANSEL
		lda	<0fbh
		and	<0feh
		sta	WMANSL
;
		M8
;
;
;
;
;
		PLB
		RTL
;
test_col	equ	$
		WORD	0000h
		WORD	7fffh
		WORD	5a75h
		WORD	03e0h
;
;
;
;
;;;;		    LDX	    #04
;;;;test_010	    EQU	    $
;;;;		    LDA	    !TEST_HDMAP0,X
;;;;		    STA	    4330H,X
;;;;		    LDA	    !TEST_HDMAP1,X
;;;;		    STA	    4340H,X
;;;;		    DEX
;;;;		    BPL	    test_010
;;;;		    LDA	    #BANK HDMABUF
;;;;		    STA	    4337H
;;;;		    STA	    4347H
;;;;;
;;;;		    LDX	    #TEST_HDMAPD1-TEST_HDMAPD0-1
;;;;test_020	    EQU	    $
;;;;		    LDA	    !TEST_HDMAPD0,X
;;;;		    STA	    >HDMAPR1,X
;;;;		    LDA	    !TEST_HDMAPD1,X
;;;;		    STA	    >HDMAPR2,X
;;;;		    DEX
;;;;		    BPL	    test_020
;;;;;
;;;;		    M16
;;;;;
;;;;;-------------- afPXN[JE^[Zbg ------------------------
;;;;		    LDA	    #HDMABF0
;;;;		    STA	    R0		    ;(R0) <-- ]AhX
;;;;		    LDA	    #4
;;;;		    STA	    R1		    ;(R1) <-- ]AhXZf[^
;;;;		    LDA	    <SCCH1
;;;;		    STA	    R2		    ;(R2) <-- ]f[^
;;;;		    LDA	    #080H
;;;;		    STA	    R12
;;;;		    M_CHIP  MRAM_FILL
;;;;		    LDA	    #HDMABF0+2
;;;;		    STA	    R0		    ;(R0) <-- ]AhX
;;;;;;;;		LDA	#4
;;;;;;;;		STA	R1		;(R1) <-- ]AhXZf[^
;;;;		    LDA	    <SCCV1
;;;;		    STA	    R2		    ;(R2) <-- ]f[^
;;;;		    LDA	    #080H
;;;;		    STA	    R12
;;;;		    M_CHIP  MRAM_FILL
;;;;;
;;;;;-------------- afQXN[JE^[Zbg ------------------------
;;;;		    LDA	    #HDMABF1
;;;;		    STA	    R0		    ;(R0) <-- ]AhX
;;;;;;;;		LDA	#4
;;;;;;;;		STA	R1		;(R1) <-- ]AhXZf[^
;;;;		    LDA	    <SCCH2
;;;;		    STA	    R2		    ;(R2) <-- ]f[^
;;;;		    LDA	    #060H
;;;;		    STA	    R12
;;;;		    M_CHIP  MRAM_FILL
;;;;		    LDA	    #HDMABF1+2
;;;;		    STA	    R0		    ;(R0) <-- ]AhX
;;;;;;;;		LDA	#4
;;;;;;;;		STA	R1		;(R1) <-- ]AhXZf[^
;;;;		    LDA	    <SCCV2
;;;;		    STA	    R2		    ;(R2) <-- ]f[^
;;;;		    LDA	    #060H
;;;;		    STA	    R12
;;;;		    M_CHIP  MRAM_FILL
;;;;;
;;;;;-------------- afPX^[XN[JE^[Zbg ----------------
;;;;		    LDA	    <SCCH1
;;;;		    STA	    R1		    ;(R1) <-- afPXN[JE^[g
;;;;		    LDA	    FRCNT2
;;;;		    STA	    R2		    ;(R2) <-- X^[f[^|C^[
;;;;		    LDA	    #010H
;;;;		    STA	    R3		    ;(R3) <-- gX^[
;;;;		    LDA	    #02H
;;;;		    STA	    R4		    ;(R4) <-- gX^[U
;;;;		    LDA	    #00H
;;;;		    STA	    R5		    ;(R5) <-- gX^[XΗ
;;;;		    LDA	    #HDMABF0+(80H*4)
;;;;		    STA	    R6		    ;(R6) <-- g|cl`obt@|C^[
;;;;		    LDA	    #4
;;;;		    STA	    R7		    ;(R7) <--	      h	Zf[^
;;;;		    LDA	    #0D2H-080H
;;;;		    STA	    R12		    ;(R12) <-- obt@ZbgC
;;;;		    M_CHIP  RASTER_SET_2
;;;;		    LDA	    <SCCV1
;;;;		    STA	    R1		    ;(R1) <-- afPXN[JE^[u
;;;;		    LDA	    FRCNT2
;;;;		    STA	    R2		    ;(R2) <-- X^[f[^|C^[
;;;;		    LDA	    #02H
;;;;		    STA	    R3		    ;(R3) <-- uX^[
;;;;		    LDA	    #04H
;;;;		    STA	    R4		    ;(R4) <-- uX^[U
;;;;		    LDA	    #0FFE0H
;;;;		    STA	    R5		    ;(R5) <-- uX^[XΗ
;;;;		    LDA	    #HDMABF0+(80H*4)+2
;;;;		    STA	    R6		    ;(R6) <-- g|cl`obt@|C^[
;;;;;;;;		LDA	#4
;;;;;;;;		STA	R7		;(R7) <--	  h	    Zf[^
;;;;		    LDA	    #0D2H-080H
;;;;		    STA	    R12		    ;(R12) <-- obt@ZbgC
;;;;		    M_CHIP  RASTER_SET_2
;;;;;
;;;;;-------------- afQX^[XN[JE^[Zbg ----------------
;;;;		    LDA	    <SCCH2
;;;;		    STA	    R1		    ;(R1) <-- afQXN[JE^[g
;;;;		    LDA	    FRCNT2
;;;;		    STA	    R2		    ;(R2) <-- X^[f[^|C^[
;;;;		    LDA	    #010H
;;;;		    STA	    R3		    ;(R3) <-- gX^[
;;;;		    LDA	    #02H
;;;;		    STA	    R4		    ;(R4) <-- gX^[U
;;;;		    LDA	    #00H
;;;;		    STA	    R5		    ;(R5) <-- gX^[XΗ
;;;;		    LDA	    #HDMABF1+(60H*4)
;;;;		    STA	    R6		    ;(R6) <-- g|cl`obt@|C^[
;;;;		    LDA	    #4
;;;;		    STA	    R7		    ;(R7) <--	      h	Zf[^
;;;;		    LDA	    #0D2H-060H
;;;;		    STA	    R12		    ;(R12) <-- obt@ZbgC
;;;;		    M_CHIP  RASTER_SET_2
;;;;		    LDA	    <SCCV2
;;;;		    STA	    R1		    ;(R1) <-- afQXN[JE^[u
;;;;		    LDA	    FRCNT2
;;;;		    LSR	    A
;;;;		    STA	    R2		    ;(R2) <-- X^[f[^|C^[
;;;;		    LDA	    #02H
;;;;		    STA	    R3		    ;(R3) <-- uX^[
;;;;		    LDA	    #04H
;;;;		    STA	    R4		    ;(R4) <-- uX^[U
;;;;		    LDA	    #0FFE0H
;;;;		    STA	    R5		    ;(R5) <-- uX^[XΗ
;;;;		    LDA	    #HDMABF1+(60H*4)+2
;;;;		    STA	    R6		    ;(R6) <-- g|cl`obt@|C^[
;;;;;;;;		LDA	#4
;;;;;;;;		STA	R7		;(R7) <--	  h	    Zf[^
;;;;		    LDA	    #0D2H-060H
;;;;		    STA	    R12		    ;(R12) <-- obt@ZbgC
;;;;		    M_CHIP  RASTER_SET_2
;;;;;
;;;;;-------------- g|cl`obt@]Zbg ----------------------------
;;;;		    JSL	    >M_DMA_BFST
;;;;		    LWORD   HDMABUF0	    ;]AhX
;;;;		    LWORD   HDMABF0	    ;]AhX
;;;;		    WORD    (0D2H*4)*2	    ;]oCg
;;;;;
;;;;		    M8
;;;;;
;;;;		    LDA	    #00011000B	    ;X^[g|cl`hnmh
;;;;		    TSB	    HD420C
;;;;		    PLB
;;;;		    RTL
;;;;;
;;;;;
;;;;;
;;;;TEST_HDMAP0	    EQU	    $
;;;;		    BYTE    01000011B	    ;DMA control parameter
;;;;		    BYTE    0DH		    ;	 B bus address
;;;;		    BYTE    LOW	 HDMAPR1    ;	 A	"     (L)
;;;;		    BYTE    HIGH HDMAPR1    ;		"     (H)
;;;;		    BYTE    BANK HDMAPR1    ;		"     (B)
;;;;TEST_HDMAP1	    EQU	    $
;;;;		    BYTE    01000011B	    ;DMA control parameter
;;;;		    BYTE    0FH		    ;	 B bus address
;;;;		    BYTE    LOW	 HDMAPR2    ;	 A	"     (L)
;;;;		    BYTE    HIGH HDMAPR2    ;		"     (H)
;;;;		    BYTE    BANK HDMAPR2    ;		"     (B)
;;;;;
;;;;TEST_HDMAPD0    EQU	    $
;;;;		    BYTE    59H+80H	    ;line no.
;;;;		    WORD    HDMABUF0
;;;;		    BYTE    59H+80H	    ;line no.
;;;;		    WORD    HDMABUF0+(59H*4)
;;;;		    HEX	    00		    ;end code
;;;;TEST_HDMAPD1    EQU	    $
;;;;		    BYTE    59H+80H	    ;line no.
;;;;		    WORD    HDMABUF2
;;;;		    BYTE    59H+80H	    ;line no.
;;;;		    WORD    HDMABUF2+(59H*4)
;;;;		    HEX	    00		    ;end code
;;;;;
;
;
;
		lda	#4
		sta	2100h
;
		PLB
		RTL
;
;
;
;
;
		M16
;
		M_CHIP	TEST_01
;
		M8
;
		lda	#0fh
		sta	2100h
;
		PLB
		RTL
;
;************************************************************************
;*									*
;*		J[]						*
;*									*
;************************************************************************
;
		MEM8
		IDX8
;
COLTR_SEL	EQU	$
		WORD	COLTR_00	;[00] J[]
		WORD	COLTR_01	;[01] X̏
		WORD	COLTR_02	;[02] X̂
		WORD	COLTR_03	;[03] Jxwi
		WORD	COLTR_04	;[04] n`wi
		WORD	COLTR_05	;[05] n
		WORD	COLTR_06	;[06] nR[XafP̑
		WORD	COLTR_07	;[07] n  nR[XafP̑
		WORD	COLTR_08	;[08] hJR[XafP̑
		WORD	COLTR_09	;[09] n`
		WORD	COLTR_0A	;[0A] nQ n
		WORD	COLTR_0B	;[0B]  (񂾂~Ă)
		WORD	COLTR_0C	;[0C]  (񂾂)
		WORD	COLTR_0D	;[0D] afR n`[
		WORD	COLTR_0E	;[0E] n (   n )
		WORD	COLTR_0F	;[0F] afR{X
		WORD	COLTR_10	;[10] X̒n (afP)
		WORD	COLTR_11	;[11] afR
		WORD	COLTR_12	;[12] ]^Cv T,`,PO,PP ̑g
		WORD	COLTR_13	;[13] nWJ[ n X̂
		WORD	COLTR_13	;[14] afR
;
;------------------------------------------------------------------------
;-		J[]						-
;------------------------------------------------------------------------
COLTR_00	EQU	$
		RTS
;
;------------------------------------------------------------------------
;-		X̏							-
;------------------------------------------------------------------------
COLTR_01_DAT	EQU	$
		WORD	COL_ADDRESS+ICE_SIRO_COL0
		WORD	COL_ADDRESS+ICE_SIRO_COL1
		WORD	COL_ADDRESS+ICE_SIRO_COL2
		WORD	COL_ADDRESS+ICE_SIRO_COL3
		WORD	COL_ADDRESS+ICE_SIRO_COL4
		WORD	COL_ADDRESS+ICE_SIRO_COL5
		WORD	COL_ADDRESS+ICE_SIRO_COL6
		WORD	COL_ADDRESS+ICE_SIRO_COL7
;
COLTR_01_CNT	EQU	$
		BYTE	030H,010H,050H,010H
;
;
COLTR_01	EQU	$
		M16			; memory 16bit mode
		DEC	!COL_ANIME_TM
		LDA	!COL_ANIME_TM
		BPL	COLTR_01_200
		LDA	!COL_ANIME_CT
		INC	A
		INC	A
		AND	#00007*2
		STA	!COL_ANIME_CT
		BNE	COLTR_01_100
		JSL	>RND_RND
		AND	#00003
		TAX
		LDA	COLTR_01_CNT,X
		AND	#000FFH
		BRA	COLTR_01_150
COLTR_01_100	EQU	$
		LDA	#00004
COLTR_01_150	EQU	$
		STA	!COL_ANIME_TM
;
COLTR_01_200	EQU	$
		LDX	!COL_ANIME_CT
		LDA	COLTR_01_DAT,X
		STA	<WORK0
		LDA	#00013*2
		STA	<WORKE
		LDX	#00004*20H+003H*2
		JSR	BG1_ANIME_SET
		M8			; memory 8bit mode
		RTS
;
;------------------------------------------------------------------------
;-		X̂уJ[Aj[V			-
;------------------------------------------------------------------------
;
;-------------- X̂уJ[Aj[V^C}[f[^ ----------
MORI_COL_ANIME	EQU	$
		HEX	00,40,40,40
;
COLTR_02	EQU	$
;
		I16
;
		LDA	PLXPSL		;ij
		SEC			;
		SBC	PLXPSL_OLD	;
		BMI	COLTR_02_022
		BNE	COLTR_02_020
		LDY	PLXSPD
		BNE	COLTR_02_010
		LDX	COL_ANIME_CT
		CPX	#01H
		BEQ	COLTR_02_030
		STZ	COL_ANIME_TM
COLTR_02_010	EQU	$
		LDA	#01H
COLTR_02_020	EQU	$
		EOR	#0FFFFH
		INC	A
COLTR_02_022	EQU	$
		SEC
		SBC	#06H
COLTR_02_030	EQU	$
;
		I8
;
		CLC
		ADC	COL_ANIME_TM
		STA	COL_ANIME_TM
		BPL	COLTR_02_070	;J[؂ւH ( no:COLTR_02_070 )
		LDX	COL_ANIME_CT
		INX
		CPX	#04H
		BCC	COLTR_02_040
		LDX	#00H
COLTR_02_040	EQU	$
		STX	COL_ANIME_CT
		LDA	>MORI_COL_ANIME,X
		BNE	COLTR_02_050	;_^C}[ZbgH ( no:COLTR_02_050 )
;
		LDA	RANDM0
		AND	#0E0H
		CLC			;[ 10H-2FH ]
		ADC	#020H
COLTR_02_050	EQU	$
		STA	COL_ANIME_TM
		TXA
		ASL	A		;x6
;;;;		    CLC			;
		ADC	COL_ANIME_CT	;
		ASL	A
		TAX
;
		PHB			;(DBR) save
		LDA	#BANK DATACOL	;(DBR) <-- DATACOL(B)
		PHA
		PLB
;
		M16
;
		LDY	#0
COLTR_02_060	EQU	$
		LDA	>COL_ADDRESS+MORI_ANIM_COL,X
		STA	MOTOCOL+(05H*2),Y
		STA	DATACOL+(05H*2),Y
		INX
		INX
		INY
		INY
		CPY	#(3*2)
		BCC	COLTR_02_060
;
		M8
;
		PLB
;
COLTR_02_070	EQU	$
		RTS
;
;------------------------------------------------------------------------
;-		JxwiJ[Aj[V				-
;------------------------------------------------------------------------
COLTR_03	EQU	$
		LDA	FRCNT2
		AND	#03H*8
		ASL	A
		ASL	A
;;;;		    CLC
		ADC	#(16-1)*2
		TAX
;
		PHB			;(DBR) save
		LDA	#BANK DATACOL	;(DBR) <-- DATACOL(B)
		PHA
		PLB
;
		M16
;
		LDY	#(16-1)*2
COLTR_03_010	EQU	$
		LDA	>COL_ADDRESS+KABE_ANIM_COL,X
		STA	MOTOCOL+(70H*2),Y
		STA	DATACOL+(70H*2),Y
		DEX
		DEX
		DEY
		DEY
		BPL	COLTR_03_010
;
		M8
;
		PLB
		RTS
;
;------------------------------------------------------------------------
;-		n`wiJ[Aj[V				-
;------------------------------------------------------------------------
COLTR_04_DAT	EQU	$
		WORD	COL_ADDRESS+B3TAKI_COL_0
		WORD	COL_ADDRESS+B3TAKI_COL_1
		WORD	COL_ADDRESS+B3TAKI_COL_2
		WORD	COL_ADDRESS+B3TAKI_COL_3
		WORD	COL_ADDRESS+B3TAKI_COL_4
		WORD	COL_ADDRESS+B3TAKI_COL_5
		WORD	COL_ADDRESS+B3TAKI_COL_6
		WORD	COL_ADDRESS+B3TAKI_COL_7
;
;
COLTR_04	EQU	$
		LDA	FRCNT2
		AND	#01CH
		LSR	A
		TAX
		LDA	#BANK COL_ADDRESS
		STA	<WORK2
;
		M16			; memory 16bit mode
		LDA	!BG2SCR_CNT
		CLC
		ADC	#00000H
		STA	!BG2SCR_CNT
;
;
		LDA	COLTR_04_DAT,X
		STA	<WORK0
		PHB
		LDY	#BANK DATACOL
		PHY
		PLB
;
		LDY	#000H
COLTR_04_030	EQU	$
		LDA	[<WORK0],Y
		STA	!MOTOCOL+(7*16+01)*2,Y
		STA	!DATACOL+(7*16+01)*2,Y
		INY
		INY
		CPY	#(15*2)
		BCC	COLTR_04_030
;
		M8			; memory 8bit mode
		PLB
;
		LDA	#010H
		STA	!BG3SPH_CT
;
		RTS
;
;-----------------------------------------------------------------------
;-		nJ[Aj[V				-
;-----------------------------------------------------------------------
COLTR_05	EQU	$
		JSR	BG1CHIKA_COL
COLTR_05_SB	EQU	$
;;;;K;;;;		LDX	!COL_ANIME_CT
;;;;K;;;;		LDA	!FRCNT2
;;;;K;;;;		AND	#007H		; J[؂ւH
;;;;K;;;;		BNE	COLTR_05_40	;	NO -> COLTR_05_40
;;;;K;;;;;
;;;;K;;;;		TXA
;;;;K;;;;		CLC
;;;;K;;;;		ADC	#(8*2)
;;;;K;;;;		AND	#070H
;;;;K;;;;		STA	!COL_ANIME_CT
;;;;K;;;;		TAX
;;;;K;;;;;
;;;;K;;;;;
;;;;K;;;;;
;;;;K;;;;;
;
		INC	!COL_ANIME_CT
		LDA	!COL_ANIME_CT
		AND	#038H
		ASL	A
		TAX
;
COLTR_05_40	EQU	$
		PHB			;(DBR) save
		LDA	#BANK DATACOL	;(DBR) <-- DATACOL(B)
		PHA
		PLB
		M16			; memory 16bit mode
;
		LDY	#000
COLTR_05_50	EQU	$
		LDA	>COL_ADDRESS+CHIKA_IWA_COL,X
		STA	!MOTOCOL+(71H*2),Y
		STA	!DATACOL+(71H*2),Y
		INX
		INX
		INY
		INY
		CPY	#(8*2)
		BCC	COLTR_05_50
;
		M8			; memory 8bit mode
		PLB
		RTS
;
;------------------------------------------------------------------------
;-		nR[XafP̑					-
;------------------------------------------------------------------------
COLTR_06_DAT	EQU	$
		WORD	COL_ADDRESS+B1TAKI_COL0
		WORD	COL_ADDRESS+B1TAKI_COL1
		WORD	COL_ADDRESS+B1TAKI_COL2
		WORD	COL_ADDRESS+B1TAKI_COL3
;
;
COLTR_06	EQU	$
		JSR	COLTR_05_SB
COLTR_06_SB	EQU	$
		M16			; memory 16bit mode
		LDA	!FRCNT2		; nWJ[
		AND	#00038H
		LSR	A
		LSR	A
		TAX
		LDA	B1CK_COL_ADR,X
		STA	<WORK0
;
		LDX	#010H*2*4+003H*2
		LDA	#0000DH*2
		STA	<WORKE
		JSR	BG1_ANIME_SET
		M8			; memory 8bit mode
;
COLTR_06_SB_SB	EQU	$
		LDA	!FRCNT2
		AND	#018H
		LSR	A
		LSR	A
		TAX
;
		M16			; memory 16bit mode
		LDA	COLTR_06_DAT,X
		STA	<WORK0
;
		LDX	#053H*2
		LDA	#00004H*2
		STA	<WORKE
		JSR	BG1_ANIME_SET
		M8			; memory 8bit mode
		RTS
;
;------------------------------------------------------------------------
;-		n  nR[XafP̑			-
;------------------------------------------------------------------------
COLTR_07	EQU	$
		JSR	COLTR_05_SB
		JSR	COLTR_06
		RTS
;
;------------------------------------------------------------------------
;-		afPnJ[]					-
;------------------------------------------------------------------------
B1CK_COL_ADR	EQU	$
		WORD	COL_ADDRESS+B1CHIKA_COL0
		WORD	COL_ADDRESS+B1CHIKA_COL1
		WORD	COL_ADDRESS+B1CHIKA_COL2
		WORD	COL_ADDRESS+B1CHIKA_COL3
		WORD	COL_ADDRESS+B1CHIKA_COL4
		WORD	COL_ADDRESS+B1CHIKA_COL5
		WORD	COL_ADDRESS+B1CHIKA_COL6
		WORD	COL_ADDRESS+B1CHIKA_COL7
;
;
BG1CHIKA_COL	EQU	$
		LDA	!BG1TYP
		AND	#007
		BNE	B1CK_COL_PASS
		M16			; memory 16bit mode
		LDA	!FRCNT2
		AND	#00038H
		LSR	A
		LSR	A
		TAX
		LDA	B1CK_COL_ADR,X
		STA	<WORK0
;
		LDX	#010H*2*4+003H*2
		LDA	#0000DH*2
		STA	<WORKE
		JSR	BG1_ANIME_SET
;
		LDA	<WORK0
		CLC
		ADC	#0000DH*2
		STA	<WORK0
;
		LDX	#010H*2*0+002H*2
		LDA	#00006H*2
		STA	<WORKE
		JSR	BG1_ANIME_SET
		M8			; memory 8bit mode
B1CK_COL_PASS	EQU	$
		RTS
;
;------------------------------------------------------------------------
;-		hJR[XafP̑					-
;------------------------------------------------------------------------
COLTR_08_DAT	EQU	$
		WORD	COL_ADDRESS+B1DKAN_COL0
		WORD	COL_ADDRESS+B1DKAN_COL1
		WORD	COL_ADDRESS+B1DKAN_COL2
		WORD	COL_ADDRESS+B1DKAN_COL3
;
COLTR_08	EQU	$
		LDA	!FRCNT2
		AND	#00CH
		LSR	A
		TAX
;
		M16			; memory 16bit mode
		LDA	COLTR_08_DAT,X
		STA	<WORK0
;
COLTR_08_SET	EQU	$
		LDX	#053H*2
		LDA	#00004H*2
		STA	<WORKE
		JSR	BG1_ANIME_SET
;
		LDA	BG1TYP
		CMP	#0BH
		BNE	COLTR_08_SET_10
;
;-------------- yǂ̐TEhZbg`FbN --------------------------
		LDA	#00100100B	;[]
		STA	SOUND_1
;
COLTR_08_SET_10 EQU	$
;
		M8			; memory 8bit mode
;
		RTS
;
;------------------------------------------------------------------------
;-		n`							-
;------------------------------------------------------------------------
COLTR_09_DAT	EQU	$
		WORD	COL_ADDRESS+BG3SHIRO+0*2
		WORD	COL_ADDRESS+BG3SHIRO+1*2
		WORD	COL_ADDRESS+BG3SHIRO+2*2
		WORD	COL_ADDRESS+BG3SHIRO+3*2
		WORD	COL_ADDRESS+BG3SHIRO+4*2
		WORD	COL_ADDRESS+BG3SHIRO+3*2
		WORD	COL_ADDRESS+BG3SHIRO+2*2
		WORD	COL_ADDRESS+BG3SHIRO+1*2
;
;
COLTR_09	EQU	$
		LDA	#BANK COL_ADDRESS
		STA	<WORK2
		LDA	!COL_ANIME_TM
		INC	A
		STA	!COL_ANIME_TM
		CMP	#006
		BCC	COLTR_09_10
		STZ	!COL_ANIME_TM
		LDA	!COL_ANIME_CT
		INC	A
		INC	A
		AND	#007H*2
		STA	!COL_ANIME_CT
COLTR_09_10	EQU	$
		LDX	!COL_ANIME_CT
		LDA	#BANK COL_ADDRESS
		STA	<WORK2
		M16			; memory 16bit mode
		LDA	COLTR_09_DAT,X
		STA	<WORK0
		LDA	[<WORK0]
		STA	>MOTOCOL+001H*2
		STA	>DATACOL+001H*2
		STA	>MOTOCOL+009H*2
		STA	>DATACOL+009H*2
		M8			; memory 8bit mode
		RTS
;
;------------------------------------------------------------------------
;-		nQ n						-
;------------------------------------------------------------------------
COLTR_0A_DAT	EQU	$
		WORD	COL_ADDRESS+CHIKA2_COL0
		WORD	COL_ADDRESS+CHIKA2_COL1
		WORD	COL_ADDRESS+CHIKA2_COL2
		WORD	COL_ADDRESS+CHIKA2_COL3
;
;
COLTR_0A	EQU	$
		LDA	!FRCNT2
		AND	#018H
		LSR	A
		LSR	A
		TAX
		LDA	#BANK COL_ADDRESS
		STA	<WORK2
;
		M16			; memory 16bit mode
		LDA	COLTR_0A_DAT,X
		STA	<WORK0
;
		JMP	COLTR_08_SET
		MEM8
;
;------------------------------------------------------------------------
;-		 (񂾂~Ă)					-
;------------------------------------------------------------------------
COLTR_0B_DAT	EQU	$
		WORD	COL_ADDRESS+SNOW_COL7
		WORD	COL_ADDRESS+SNOW_COL6
		WORD	COL_ADDRESS+SNOW_COL5
		WORD	COL_ADDRESS+SNOW_COL4
		WORD	COL_ADDRESS+SNOW_COL3
		WORD	COL_ADDRESS+SNOW_COL2
		WORD	COL_ADDRESS+SNOW_COL1
		WORD	COL_ADDRESS+SNOW_COL0
;
;
COLTR_0B	EQU	$
		M16			; memory 16bit mode
		LDA	!COL_ANIME_TM
		INC	A
		CMP	#00070H
		BCS	COLTR_0B_000
		STA	!COL_ANIME_TM
		BRA	COLTR_0B_900
;
COLTR_0B_000	EQU	$
		LDA	!FRCNT2
		AND	#0007FH
		BNE	COLTR_0B_900
;
		M8			; memory 8bit mode
		LDA	#004
		STA	!MANSEL
		LDA	#013H
		STA	!SUBSEL
		LDA	#024H
		STA	!SUBADF
		M16			; memory 16bit mode
		LDA	!COL_ANIME_CT
		INC	A
		CMP	#00008
		BCS	COLTR_0B_900
		STA	!COL_ANIME_CT
		ASL	A
		TAY
		LDA	COLTR_0B_DAT,Y
		STA	<WORK0
		LDX	#00001H*2
		LDA	#00003H*2
		STA	<WORKE
		JSR	BG1_ANIME_SET
;
COLTR_0B_900	EQU	$
		M8			; memory 8bit mode
		RTS
;
;------------------------------------------------------------------------
;-		 (񂾂)					-
;------------------------------------------------------------------------
COLTR_0C_DAT	EQU	$
		WORD	COL_ADDRESS+SNOW_COL0
		WORD	COL_ADDRESS+SNOW_COL1
		WORD	COL_ADDRESS+SNOW_COL2
		WORD	COL_ADDRESS+SNOW_COL3
		WORD	COL_ADDRESS+SNOW_COL4
		WORD	COL_ADDRESS+SNOW_COL5
		WORD	COL_ADDRESS+SNOW_COL6
		WORD	COL_ADDRESS+SNOW_COL7
;
;
COLTR_0C	EQU	$
		M16			; memory 16bit mode
		LDA	!COL_ANIME_TM
		INC	A
		CMP	#001A0H
		BCS	COLTR_0C_000
		STA	!COL_ANIME_TM
		BRA	COLTR_0C_900
;
COLTR_0C_000	EQU	$
		LDA	!FRCNT2
		AND	#0003FH
		BNE	COLTR_0B_900
;
		LDA	!COL_ANIME_CT
		INC	A
		CMP	#00008
		BCS	COLTR_0C_800
		STA	!COL_ANIME_CT
		ASL	A
		TAY
		LDA	COLTR_0C_DAT,Y
		STA	<WORK0
		LDX	#00001H*2
		LDA	#00003H*2
		STA	<WORKE
		JSR	BG1_ANIME_SET
		BRA	COLTR_0C_900
;
COLTR_0C_800	EQU	$
		LDA	!MANSEL
		EOR	#004
		STA	!MANSEL
		LDA	!SUBADF
		EOR	#004
		STA	!SUBADF
		STZ	!COLTRP
;
COLTR_0C_900	EQU	$
		M8			; memory 8bit mode
		RTS
;
;------------------------------------------------------------------------
;-		afR n`[						-
;------------------------------------------------------------------------
COLTR_0D_DAT0	EQU	$
		WORD	COL_ADDRESS+B3YUHI_COL_0
		WORD	COL_ADDRESS+B3YUHI_COL_1
		WORD	COL_ADDRESS+B3YUHI_COL_2
		WORD	COL_ADDRESS+B3YUHI_COL_3
		WORD	COL_ADDRESS+B3YUHI_COL_3
		WORD	COL_ADDRESS+B3YUHI_COL_2
		WORD	COL_ADDRESS+B3YUHI_COL_1
		WORD	COL_ADDRESS+B3YUHI_COL_0
;
COLTR_0D_DAT1	EQU	$
		WORD	COL_ADDRESS+B3ASAHI_COL_0
		WORD	COL_ADDRESS+B3ASAHI_COL_1
		WORD	COL_ADDRESS+B3ASAHI_COL_2
		WORD	COL_ADDRESS+B3ASAHI_COL_3
		WORD	COL_ADDRESS+B3ASAHI_COL_3
		WORD	COL_ADDRESS+B3ASAHI_COL_2
		WORD	COL_ADDRESS+B3ASAHI_COL_1
		WORD	COL_ADDRESS+B3ASAHI_COL_0
;
;
COLTR_0D	EQU	$
		LDA	!COL_ANIME_TM
		INC	A
		CMP	#012
		BCC	COLTR_0D_100
		INC	!COL_ANIME_CT
		LDA	#000
COLTR_0D_100	EQU	$
		STA	!COL_ANIME_TM
;
		LDA	!COL_ANIME_CT
		AND	#007
		ASL	A
		TAY
		M16			; memory 16bit mode
		LDA	!BG3COL
		AND	#00001
		BNE	COLTR_0D_120
		LDA	COLTR_0D_DAT0,Y
		BRA	COLTR_0D_140
COLTR_0D_120	EQU	$
		LDA	COLTR_0D_DAT1,Y
COLTR_0D_140	EQU	$
		STA	<WORK0
		LDX	#00001H*2
		LDA	#00003H*2
		STA	<WORKE
		JSR	BG1_ANIME_SET
;
		LDA	#00002
		STA	!BG3SPH_CT
		LDA	#00002
		STA	!BG3SPV_CT
		M8			; memory 8bit mode
;
		RTS
;
;------------------------------------------------------------------------
;-		n (   n )					-
;------------------------------------------------------------------------
COLTR_0E_DAT	EQU	$
		WORD	COL_ADDRESS+B2CK_TK_COL0
		WORD	COL_ADDRESS+B2CK_TK_COL1
		WORD	COL_ADDRESS+B2CK_TK_COL2
		WORD	COL_ADDRESS+B2CK_TK_COL3
		WORD	COL_ADDRESS+B2CK_TK_COL4
		WORD	COL_ADDRESS+B2CK_TK_COL5
		WORD	COL_ADDRESS+B2CK_TK_COL6
		WORD	COL_ADDRESS+B2CK_TK_COL7
;
COLTR_0E_ADR	EQU	$
		WORD	00006H*20H+00008H*2
		WORD	00006H*20H+00004H*2
;
COLTR_0E_AND	EQU	$
		WORD	0001CH,00038H
;
;
COLTR_0E	EQU	$
		LDA	!BG1TYP
		CMP	#008		; nQR[X̗n ?
		BNE	COLTR_0E_020	;	NO -> COLTR_0E_020
		JSR	COLTR_0A
		BRA	COLTR_0E_SB
COLTR_0E_020	EQU	$
		JSR	COLTR_06_SB_SB
COLTR_0E_SB	EQU	$
		M16			; memory 16bit mode
		LDA	!BG2COL
		AND	#00001
		ASL	A
		TAY
		ASL	A
		ASL	A
		ASL	A
		STA	<WORK0
		LDA	COLTR_0E_ADR,Y
		TAX
		LDA	COLTR_0E_AND,Y
		AND	!FRCNT2
		DEY
		BMI	COLTR_0E_500
		LSR	A
COLTR_0E_500	EQU	$
		LSR	A
		TAY
		LDA	COLTR_0E_DAT,Y
		CLC
		ADC	<WORK0
		STA	<WORK0
		LDA	#00008*2
		STA	<WORKE
		JSR	BG1_ANIME_SET
		M8			; memory 8bit mode
		RTS
;
;------------------------------------------------------------------------
;-		afR{X						-
;------------------------------------------------------------------------
COLTR_0F_DAT	EQU	$
		WORD	COL_ADDRESS+B3BSRM_COL0
		WORD	COL_ADDRESS+B3BSRM_COL1
		WORD	COL_ADDRESS+B3BSRM_COL2
		WORD	COL_ADDRESS+B3BSRM_COL3
;
;
COLTR_0F	EQU	$
		M16			; memory 16bit mode
		LDA	!FRCNT2
		AND	#0000CH
		LSR	A
		TAX
		LDA	COLTR_0F_DAT,X
		STA	<WORK0
		LDA	#00003H*2
		STA	<WORKE
		LDX	#00000H*20H+00005H*2
		JSR	BG1_ANIME_SET
		M8			; memory 8bit mode
		RTS
;
;------------------------------------------------------------------------
;-		X̒n (afP)					-
;------------------------------------------------------------------------
COLTR_10_DAT	EQU	$
		WORD	COL_ADDRESS+B1ICECK_COL7
		WORD	COL_ADDRESS+B1ICECK_COL6
		WORD	COL_ADDRESS+B1ICECK_COL5
		WORD	COL_ADDRESS+B1ICECK_COL4
		WORD	COL_ADDRESS+B1ICECK_COL3
		WORD	COL_ADDRESS+B1ICECK_COL2
		WORD	COL_ADDRESS+B1ICECK_COL1
		WORD	COL_ADDRESS+B1ICECK_COL0
;
COLTR_10_CNT	EQU	$
		WORD	00040H+00008H*8*2
		WORD	00020H+00008H*8*2
		WORD	00060H+00008H*8*2
		WORD	00020H+00008H*8*2
;
;
COLTR_10	EQU	$
		M16			; memory 16bit mode
		LDA	!COL_ANIME_PM
		CMP	#00008H*8*2
		BCS	COLTR_10_400
		LSR	A
		LSR	A
		AND	#00007*2
		TAX
		LDA	COLTR_10_DAT,X
		STA	<WORK0
		LDA	#00007H*2
		STA	<WORKE
		LDX	#00004*20H+009H*2
		JSR	BG1_ANIME_SET
;
COLTR_10_400	EQU	$
		DEC	!COL_ANIME_PM
		BPL	COLTR_10_900
		JSL	>RND_RND
		ADC	<FRCNT
		AND	#00003
		ASL	A
		TAX
		LDA	COLTR_10_CNT,X
		STA	!COL_ANIME_PM
;
COLTR_10_900	EQU	$
		M8			; memory 8bit mode
		JSR	COLTR_05_SB
		RTS
;
;------------------------------------------------------------------------
;-		afR						-
;------------------------------------------------------------------------
COLTR_11	EQU	$
		JSR	COLTR_0E
		M16				; memory 16bit mode
		LDA	#COL_ADDRESS+B3KIRI_COL
		STA	<WORK0
		M8				; memory 8bit mode
COLTR_11_SB	EQU	$
		M16			; memory 16bit mode
		LDA	!COL_ANM_TM00
		CMP	#00320H
		BCC	COLTR_11_800
		CMP	#00320H+200H
		BCS	COLTR_11_900
;
		SBC	#00320H-1
		AND	#0FFE0H
		LSR	A
		LSR	A
		ADC	<WORK0
		STA	<WORK0
		LDA	#00004H*2
		STA	<WORKE
		LDX	#00000H*20H+00000H*2
		JSR	BG1_ANIME_SET
		LDA	#01304H
		STA	!MANSEL
		LDA	!SUBADF
		ORA	#00004
		STA	!SUBADF
;
COLTR_11_800	EQU	$
		CLC
		SED
		LDA	!COL_ANM_TM00
		ADC	#00001
		STA	!COL_ANM_TM00
		CLD
COLTR_11_900	EQU	$
		M8			; memory 8bit mode
		RTS
;
;------------------------------------------------------------------------
;-		]^Cv T,`,PO,PP ̑g			-
;------------------------------------------------------------------------
COLTR_12	EQU	$
		JSR	COLTR_0A
		JSR	COLTR_10
		M16				; memory 16bit mode
		LDA	#COL_ADDRESS+B3KR_SR_COL
		STA	<WORK0
		M8				; memory 8bit mode
		JSR	COLTR_11_SB
		RTS
;
;------------------------------------------------------------------------
;-		nWJ[ n X̂			-
;------------------------------------------------------------------------
COLTR_13	EQU	$
		JSR	COLTR_02	; X̂
		JSR	COLTR_0E_SB	; n
		M16			; memory 16bit mode
		LDA	!FRCNT2		; nWJ[
		AND	#00038H
		LSR	A
		LSR	A
		TAX
		LDA	B1CK_COL_ADR,X
		STA	<WORK0
;
		LDX	#010H*2*4+003H*2
		LDA	#0000DH*2
		STA	<WORKE
		JSR	BG1_ANIME_SET
		M8			; meory 8bit mode
		RTS
;
;------------------------------------------------------------------------
;-		afR						-
;------------------------------------------------------------------------
COLTR_14	EQU	$
		M16				; memory 16bit mode
		LDA	!COL_ANM_TM00
		CMP	#00320H
		BCC	COLTR_14_800
		CMP	#00320H+200H
		BCS	COLTR_14_900
;
		SBC	#00320H-1
		AND	#0FFE0H
		LSR	A
		LSR	A
		ADC	#COL_ADDRESS+B3KR_SR_COL
		STA	<WORK0
		LDA	#00004H*2
		STA	<WORKE
		LDX	#00000H*20H+00000H*2
		JSR	BG1_ANIME_SET
		LDA	#01304H
		STA	!MANSEL
		LDA	!SUBADF
		ORA	#00004
		STA	!SUBADF
;
COLTR_14_800	EQU	$
		CLC
		SED
		LDA	!COL_ANM_TM00
		ADC	#00001
		STA	!COL_ANM_TM00
		CLD
COLTR_14_900	EQU	$
		M8			; memory 8bit mode
		RTS
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+						+
;+	afPAj[VJ[ Zbg	+
;+			in			+
;+			  X : data set index	+
;+			wk0 : f[^AhX	+
;+			wkE : [v ~bg	+
;++++++++++++++++++++++++++++++++++++++++++++++++
		MEM16
BG1_ANIME_SET	EQU	$
		LDA	#BANK COL_ADDRESS
		STA	<WORK2
		PHB			;(DBR) save
		LDY	#BANK DATACOL	;(DBR) <-- DATACOL(B)
		PHY
		PLB
;
		LDY	#000H
BG1_ANIME_LOP	EQU	$
		LDA	[<WORK0],Y
		STA	!MOTOCOL,X
		STA	!DATACOL,X
		INX
		INX
		INY
		INY
		CPY	<WORKE
		BCC	BG1_ANIME_LOP
;
		PLB
		RTS
		MEM8
;
;
;
;
;------------------------------------------------------------------------
;-		pause move						-
;-			in  : (Y) <-- pause flag			-
;------------------------------------------------------------------------
;
;-------------- moji OAM data -------------------------------------------
GMPASOAM	EQU	$
;			X   Y	CH  AT
		HEX	02A,014,0E0,030 ;[00] "P"
		HEX	03A,014,0E2,030 ;[01]
		HEX	02A,024,000,031 ;[02]
		HEX	03A,024,002,031 ;[03]
;
		HEX	046,014,0E4,030 ;[04] "A"
		HEX	056,014,0E6,030 ;[05]
		HEX	046,024,004,031 ;[06]
		HEX	056,024,006,031 ;[07]
;
		HEX	062,014,0E8,030 ;[08] "U"
		HEX	072,014,0EA,030 ;[09]
		HEX	062,024,008,031 ;[0A]
		HEX	072,024,00A,031 ;[0B]
;
		HEX	07E,014,0EC,030 ;[0C] "S"
		HEX	08E,014,0EE,030 ;[0D]
		HEX	07E,024,00C,031 ;[0E]
		HEX	08E,024,00E,031 ;[0F]
;
		HEX	09A,014,020,031 ;[10] "E"
		HEX	0AA,014,022,031 ;[11]
		HEX	09A,024,028,031 ;[12]
		HEX	0AA,024,02A,031 ;[13]
GMPASOAME	EQU	$
;
;-------------- moji move data ------------------------------------------
GMPASINTM	EQU	$
;			P  A  U	 S  E
		HEX	00,04,08,0C,10
;
GMPASZMAD	EQU	$
; GMPASZMK -->
		HEX	FC,04,FC,04,FC,04,FC,04,FC,04,FC
ZOMMAX		HEX	01,00
GMPASZMCP	EQU	$
		HEX	20,34,20,34,20,34,20,34,20,34,20
		HEX	34,00
ZOMMX		EQU	ZOMMAX-GMPASZMAD
;
GMPASASAD	EQU	$
;			ZOMMX ->
		HEX	04,FF
GMPASASMX	EQU	$
		HEX	40,10
;
GMPASMJNO	EQU	$
;			 P  A  U  S  E
		HEX	00,01,02,03,04
;
GMPASCNTX	EQU	$
		HEX	10,30,50,70,10
GMPASCNTY	EQU	$
		HEX	50,50,50,50,70
;
GMPASIN_SNDNO	EQU	$
		WORD	01H,	   02H
;
GMPASUB_ADR	EQU	$-2
		WORD	GMPASUB_000,GMPASUB_0000
		WORD	GMPASUB_100
		WORD	GMPASUB_200,GMPASUB_300
		WORD	GMPASUB_400,GMPASUB_500
		WORD	GMPASUB_600,GMPASUB_700
		WORD	GMPASUB_800
ITEM_OBJ	EQU	$
		WORD	GMPASUB_900
GMPASUB_MOVE	EQU	$
		WORD	GMPASUB_A00,GMPASUB_A00
		WORD	GMPASUB_A00,GMPASUB_A00
		WORD	GMPASUB_A00,GMPASUB_A00
		WORD	GMPASUB_A00,GMPASUB_B00
		WORD	GMPASUB_C00
OBJ_SAVE	EQU	$
;
Vram_save	EQU	(OBJ_SAVE-GMPASUB_ADR)/2
Item_obj	EQU	(ITEM_OBJ-GMPASUB_ADR)/2
Pause_move	EQU	(GMPASUB_MOVE-GMPASUB_ADR)/2
;
;
GMPASUB		EQU	$
		MI16			; memory , index 16bit mode
		LDA	!GMPAUSE
		AND	#000FFH
		ASL	A
		TAX
		LDA	!GMPASMK
		AND	#00FFH
		ASL	A
		TAY
		JSR	(GMPASUB_ADR,X)
		MI8			; memory , index 8bit mode
;
;------------------------------- ACe IuWF Zbg
		LDA	!GMPAUSE
		CMP	#Item_obj
		BCC	GMPASUB_PASS
		LDA	!ITEMDSP	; ACeĂ邩 ?
		BEQ	GMPASUB_PASS	;	NO -> GMPASUB_PASS
		JSR	ITEMOBJST
;
		JSR	MTR_COL_CHG
;
GMPASUB_PASS	EQU	$
		PLB
		RTL
;
		MEM16
		IDX16
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+	J[\g J[Aj[V		+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
MTR_COL_DAT	EQU	$
		WORD	07C00H,07C1FH,0001FH,003FFH
		WORD	003E0H,003FFH,0001FH,07C1FH
;
;
MTR_COL_CHG	EQU	$
		M16			; memory 16bit mode
		LDA	<FRCNT
		AND	#00111000B
		LSR	A
		LSR	A
		TAX
		LDA	MTR_COL_DAT,X
		STA	>DATACOL+(01*20H)+(0EH*2)
		M8			; memory 8bit mode
		RTS
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+		J[ tF[h C , AEg		+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
GM_PS_ADR	EQU	$
		WORD	GM_PS_OUT,GM_PS_IN
;
;
GMPASUB_900	EQU	$
		MI8			; memory , index 8bit mode
		LDA	!GMPASMK
		EOR	#001
		BRA	GMPASUB_050
;
GMPASUB_000	EQU	$
		MI8			; memory , index 8bit mode
		LDA	!GMPASMK
GMPASUB_050	EQU	$
		PHA			;(A) save
;
		ASL	A
		TAX
		LDA	!FADNO
		JSR	(GM_PS_ADR,X)
;
		PLA			;(A) load
		EOR	GMPASMK
		BEQ	GMPASUB_060	;ԂJEg\H ( yes:GMPASUB_060 )
		RTS
;
;-------------- ԂJEg\ --------------------
GMPASUB_060	EQU	$
;
		M16			; memory 16bit mode
;
		PLA			;[ pull pull return !! ]
		JMP	>COUNT_DOWN_011 ;ԂJEg\
;
		MEM8
		IDX8
;
;------------------------------- J[ tF[h C
GM_PS_IN	EQU	$
		DEC	A
		DEC	A
		BPL	GM_PS_IN_OUT
		JSR	GMPASUB_MODE
		LDA	#080H
		BRA	GM_PS_IN_OUT
;
;------------------------------- J[ tF[h AEg
GM_PS_OUT	EQU	$
		AND	#00FH
		INC	A
		INC	A
		CMP	#00FH
		BCC	GM_PS_IN_OUT
		JSR	GMPASUB_MODE
		LDA	#00FH
GM_PS_IN_OUT	EQU	$
		STA	!FADNO
		RTS
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+	|[ỸtF[hł̃IuWFZbg		+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
GMPASUB_0000	EQU	$
		MI8			; memory , index 8bit mode
		JSL	>OAMCLR		; OAM clear
		MI16			; memory , index 16bit mode
		LDA	!GMPASMK
		BNE	GMPASUB_0050
		STZ	!KEYA1L
		STZ	!KEYA2L
		STZ	!KEYB1L
		STZ	!KEYB2L
		STZ	<KEYC1L
		STZ	<KEYC2L
		MI8			; memory , index 8bit mode
		JSL	>PAUSE_SUB
		MI16			; memory , index 16bit mode
GMPASUB_0050	EQU	$
		JSR	GMPASUB_MODE
		RTS
;
		MEM16
		IDX16
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+		nai f[^ Z[u  [h		+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
GMPASUB_1_AD	EQU	$
		WORD	05400H,05400H+8000H
GMPASUB_1_BT	EQU	$
		WORD	(16*8)*20H,(16*8)*20H+2
;
;
GMPASUB_100	EQU	$
		TYX
		LDA	!GMPASIN_SNDNO,X ;[]
		STA	<SOUND_3
;
		LDA	#OBJ_BUF
		STA	<WORK0
		LDY	GMPASUB_1_BT,X	;(Y) <-- number of byte
		LDA	GMPASUB_1_AD,X	;(A) <-- VRAM address
		JMP	VRMSAVE
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+		nai f[^ Z[u  [h		+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
GMPASUB_2_AD	EQU	$
		WORD	04E00H,04E00H+8000H
GMPASUB_2_BT	EQU	$
		WORD	(16*6)*20H,(16*6)*20H+2
;
;
GMPASUB_200	EQU	$
;
;-------------- pause moji RAM clear --------------------
		MI8			; memory , index 8bit mode
		LDX	#GMPASCLRSE-1
GMPASUB_220	EQU	$
		STZ	!GMPASCLR_S,X
		DEX
		BPL	GMPASUB_220
;
		LDX	#PASMOJ-2
GMPASUB_230	EQU	$
		LDA	GMPASINTM,X
		STA	!GMPASTIM,X
		DEX
		BPL	GMPASUB_230
;
		MI16			; memory , index 16bit mode
		TYX
		LDA	#OBJ_BUF
		CLC
		ADC	GMPASUB_1_BT+2
		STA	<WORK0
		LDY	GMPASUB_2_BT,X	;(Y) <-- number of byte
		LDA	GMPASUB_2_AD,X	;(A) <-- VRAM address
		BRA	VRMSAVE
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+	afRLN^[ f[^ Z[u  [h	+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
GMPASUB_3_AD	EQU	$
		WORD	02800H,02800H+8000H
;
;
GMPASUB_300	EQU	$
		TYX
		LDA	#B3CHR_BUF
		STA	<WORK0
		LDY	GMPASUB_1_BT,X	;(Y) <-- number of byte
		LDA	GMPASUB_3_AD,X	;(A) <-- VRAM address
		BRA	VRMSAVE
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+	afRXN[ f[^ Z[u  [h	+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
GMPASUB_4_AD	EQU	$
		WORD	03400H,03400H+8000H
;
GMPASUB_4_BT	EQU	$
		WORD	(16*4)*20H,(16*4)*20H+2
;
;
GMPASUB_400	EQU	$
		TYX
		LDA	#B3SCR_BUF
		STA	<WORK0
		LDY	GMPASUB_4_BT,X	;(Y) <-- number of byte
		LDA	GMPASUB_4_AD,X	;(A) <-- VRAM address
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+		uq`lGA Z[u			+
;+				in			+
;+				Y <- number of byte	+
;+				A <- VRAM address	+
;+				wrk0,1 <- ]AhX+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
VRMSAVE		EQU	$
		PHB			;(DBR) save
		PEA	VRAMDX/100H
		PLB
		PLB			;(DBR) <-- VRAMDX(B)
;
		LDX	VRAMDX
		STA	0,X		;VRAM address set
		ASL	A		;(C) <-- VRAM read ?
		LDA	#10000000B
		STA	2,X		;inc mode set
		LDA	#BANK OBJ_BUF
		STA	7,X		;A bus address(H,B) set
		TYA
		STA	8,X		;number of byte set
		LDA	#10000001B+(39H*100H)
		LDY	<WORK0		; VRAM read ?
		BCS	VRSV010		;	YES -> VRSV010
;
		LDA	#00000001B+(18H*100H)
		INY
		INY
VRSV010		EQU	$
		STA	3,X		;inc mode & DMA parameter set
		TYA
		STA	5,X		;B bus address & A bus addres(L) set
;
		TXA
		CLC
		ADC	#12
		STA	10,X		;next data address set
		STA	VRAMDX		;end address set
;
		PLB		;(DBR) load
		JSR	GMPASUB_MODE
		RTS
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+		_\pLN^[ Zbg		+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
GMPASUB_500	EQU	$
		TYA			; Zbg nj ?
		BEQ	GMPASUB_590	;	NO -> GMPASUB_590
		LDX	#CHR32
		LDA	#BANK CHR32
		LDY	ITEM_STOP
		BEQ	GMPASUB_510	;ACegp֎~H ( no:GMPASUB_510 )
;
		LDX	#CHR64P
		LDA	#BANK CHR64P
GMPASUB_510	EQU	$
		STA	<WORK1
		LDY	#05400H
		LDA	#00400H
		JSL	>VRAMDX_ST
GMPASUB_590	EQU	$
		JSR	GMPASUB_MODE
		RTS
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+		[^[ LN^[Zbg		+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
GMPASUB_600	EQU	$
		TYA			; Zbg nj ?
		BEQ	GMPASUB_690	;	NO -> GMPASUB_690
		LDA	#CHRE9A
		JSL	>UNCOMPRES_X
;
		LDX	#BANK WOB7CHR
		STX	<WORK1
		LDX	#WOB7CHR+1000H
		LDY	#02C00H
		JSL	>VRAMDX_ST
GMPASUB_690	EQU	$
		JSR	GMPASUB_MODE
		RTS
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+	ep[^ f[^ Z[u  [h		+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
GMPASUB_7_BNK	EQU	$
		WORD	BANK PRMTR_BUF,BANK GMMDRM,BANK PRMTR_BUF
;
GMPASUB_7_ADR	EQU	$
		WORD	PRMTR_BUF,GMMDRM,PRMTR_BUF
;
GMPASUB_7_SUB	EQU	$
		WORD	GMPASUB_710,GMPASUB_720
;
;
GMPASUB_700	EQU	$
		JSR	GMPASUB_MODE
		TYX
		JSR	(GMPASUB_7_SUB,X)
;
		LDA	GMPASUB_7_BNK,Y
		STA	<WORK2
		LDA	GMPASUB_7_ADR,Y
		STA	<WORK0
		INY
		INY
		LDA	GMPASUB_7_BNK,Y
		STA	<WORK5
		LDA	GMPASUB_7_ADR,Y
		STA	<WORK3
;
		LDY	#00000H
		TYX
		M8			; memory 8bit mode
GMPASUB_750	EQU	$
		LDA	[<WORK0],Y
		STA	[<WORK3],Y
		INY
		CPY	#GMMDNO-1
		BCC	GMPASUB_750
;
		RTS
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+		J[ Zbg				+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
GMPS_COL_ADR	EQU	$
		WORD	GMPS_COL_OUT,GMPS_COL_IN
;
GMPASUB_800	EQU	$
		JSR	GMPASUB_MODE
		PHB
		I8			; index 8bit mode
		TYX
		JMP	(GMPS_COL_ADR,X)
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+		|[Y [h CjV Zbg		+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
GMPASUB_A00	EQU	$
		JSR	GMPASUB_MODE
		MI8			; memory , index 8bit mode
		LDA	!GMPAUSE
		SEC
		SBC	#Pause_move
		ASL	A
		ASL	A
		ASL	A
		LDX	#PASMOJ-2
GMPASUB_A40	EQU	$
		STA	GMPASZOM,X
		DEX
		BPL	GMPASUB_A40
;
GMPASUB_A90	EQU	$
		JMP	GMPASUB_B70
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+		|[Y vC				+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
GMPASUB_B00	EQU	$
		MI8			; memory , index 8bit mode
		LDA	!ITEMBUF	; ACeĂ邩 ?
		BEQ	GMPASUB_B00_00	;	NO -> GMPASUB_B00_00
		JSR	ITMSEL		; ACe ZNg
;
GMPASUB_B00_00	EQU	$
		LDA	!ITEMNO
		BEQ	GMPASUB_B03
		LDA	<KEYC2L
		AND	#10000000B	; "`" L[ nm ?
		BNE	GMPASUB_B05	;	YES -> GMPASUB_B05
GMPASUB_B03	EQU	$
		ORA	<KEYC2
		AND	#10010000B	; "a" or X^[g L[ nm ?
		BEQ	GMPASUB_B20	;	NO -> GMPASUB_B20
GMPASUB_B05	EQU	$
;;;;K;;;;		LDA	!GMPASMK
;;;;K;;;;		EOR	#001
;;;;K;;;;		AND	#001
;;;;K;;;;		STA	!GMPASMK
		JSR	GMPASUB_MODE
;
GMPASUB_B20	EQU	$
		LDX	#PASMOJ-2
GMPASUB_B25	EQU	$
		LDA	GMPASTIM,X	; wait ?
		BEQ	GMPASUB_B30	;	NO -> GMPASUB_B30
;
		LDA	<FRCNT
		AND	#03H
		BNE	GMPASUB_B60
		DEC	GMPASTIM,X	;timer dec
		BRA	GMPASUB_B60
;
;-------------- moji zoom -----------------------
GMPASUB_B30	EQU	$
		LDY	GMPASZMK,X
		LDA	<FRCNT
		AND	#03H
		BNE	GMPASUB_B35
		LDA	GMPASZOM,X
		CLC
		ADC	!GMPASZMAD,Y
		STA	GMPASZOM,X
		CMP	!GMPASZMCP,Y	; zoom muki change ?
		BNE	GMPASUB_B35	;	NO -> GMPASUB_B35
;
		INC	GMPASZMK,X
GMPASUB_B35	EQU	$
		CPY	#ZOMMX		; moji rotation ?
		BCC	GMPASUB_B60	;	NO -> GMPASUB_B60
;
;-------------- moji rotation -------------------
		LDA	GMPASXAS,X
		CMP	!GMPASASMX-ZOMMX,Y	; max rotation speed ?
		BNE	GMPASUB_B40		;	NO -> GMPASUB_B40
;
		CPY	#ZOMMX		; rotation end check ?
		BEQ	GMPASUB_B50	;	NO -> GMPASUB_B50
		LDA	GMPASXAN,X
		BNE	GMPASUB_B50	;	NO -> GMPASUB_B50
;
;-------------- go to wait set ------------------
		STZ	GMPASZMK,X	;zoom muki reset
		STZ	GMPASXAS,X	;rotation speed reset
		STZ	GMPASXAC,X	;	"       calc reset
		LDA	#020H
		STA	GMPASTIM,X	;wait timer set
		BRA	GMPASUB_B70
;
GMPASUB_B40	EQU	$
		LDA	<FRCNT
		LSR	A
		BCS	GMPASUB_B50
		LDA	GMPASXAS,X
		CLC
		ADC	!GMPASASAD-ZOMMX,Y
		STA	GMPASXAS,X
GMPASUB_B50	EQU	$
		LDA	GMPASXAS,X
		TAY
		ASL	A
		ASL	A
		ASL	A
		ASL	A
		CLC
		ADC	GMPASXAC,X
		STA	GMPASXAC,X
		TYA
		PHP			;(C),(N) save
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		PLP
		BPL	GMPASUB_B55
		ORA	#0F0H
GMPASUB_B55	EQU	$
		ADC	GMPASXAN,X
		STA	GMPASXAN,X
;
GMPASUB_B60	EQU	$
		DEX
		BMI	GMPASUB_B70
		JMP	GMPASUB_B25
;
;-------------- moji polygon set ------------------------
GMPASUB_B70	EQU	$
;
		M16			; memory 16bit mode
;
		LDA	#WOB7CHR+(80H*20H)
		STA	R1		;(R1) <-- M-chip clear RAM start address
		LDA	#(80H*20H)/2
		STA	R12
		M_CHIP	MRAM_CLR
;
		LDX	#PASMOJ-2
GMPASUB_B80	EQU	$
		LDA	!GMPASMJNO,X
		AND	#00FFH
		STA	R1		;(R1) <-- moji no.
		LDA	GMPASXAN,X
		AND	#00FFH
		STA	R2		;(R2) <-- X angle
		STA	R3		;(R3) <-- Y   "
		LDA	!GMPASCNTX,X
		AND	#00FFH
		STA	R4		;(R4) <-- center X pos
		LDA	!GMPASCNTY,X
		AND	#00FFH
		STA	R5		;(R5) <--    "   Y  "
		LDA	GMPASZOM,X
		AND	#00FFH
		STA	R6		;(R6) <-- zoom flag
;
		PHX			;(X) save
;
		M_CHIP	MOJIPOLY2
;
		PLX			;(X) load
;
		DEX
		BPL	GMPASUB_B80
;
		LDA	#WOB7CHR+(80H*20H)+(60H*20H)
		STA	R1		;(R1) <-- convert RAM from start address
		LDA	#WOB7CHR+(80H*20H)+(48H*20H)
		STA	R2		;(R2) <-- convert RAM to start address
		LDA	#(8*20H)/2
		STA	R3		;(R3) <-- 1 block number of word
		LDA	#01H
		STA	R4		;(R4) <-- number of block
		M_CHIP	MJRAMCNV	;moji polygon RAM convert
;
		LDA	#WOB7CHR+(80H*20H)+(70H*20H)
		STA	R1		;(R1) <-- convert RAM from start address
		LDA	#WOB7CHR+(80H*20H)+(58H*20H)
		STA	R2		;(R2) <-- convert RAM to start address
		LDA	#(8*20H)/2
		STA	R3		;(R3) <-- 1 block number of word
		LDA	#01H
		STA	R4		;(R4) <-- number of block
		M_CHIP	MJRAMCNV	;moji polygon RAM convert
;
;-------------- pause moji OAM set ------------------------------
		LDA	#1010101010101010B	;big size set
		STA	>OAMSUB
		STA	>OAMSUB+2
		STA	>OAMSUB+4
		STA	>OAMSUB+6
;
		M8			; memory 8bit mode
;
		STZ	<WORK0
		LDA	#010H
		STA	<WORK0
		LDX	#000H
GMPASUB_B90	EQU	$
		LDA	!GMPASOAM+0,X
		CLC
		ADC	<WORK0
		STA	>OAM+0,X
		LDA	!GMPASOAM+1,X
		STA	>OAM+1,X
		LDA	!GMPASOAM+2,X
		STA	>OAM+2,X
		LDA	!GMPASOAM+3,X
		STA	>OAM+3,X
		INX
		INX
		INX
		INX
		CPX	#GMPASOAME-GMPASOAM
		BCC	GMPASUB_B90
;
		RTS
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+		gpACe_			+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
GMPASUB_C00	EQU	$
		MI8			; memory , index 8bit mode
		LDA	!ITEMNO
		BEQ	GMPASUB_C50
		INC	!GMPASTM
		LDA	!GMPASTM
		CMP	#020H
		BCC	GMPASUB_C90
		STZ	!GMPASTM
GMPASUB_C50	EQU	$
		LDA	!GMPASMK
		EOR	#001
		AND	#001
		STA	!GMPASMK
		JSR	GMPASUB_MODE
		JSR	GMPASUB_MODE
GMPASUB_C90	EQU	$
		JMP	GMPASUB_B70
;
		MEM8
		IDX8
;
;++++++++++++++++++++++++++++++++++++++++
;+	|[X[hmnDhmb	+
;++++++++++++++++++++++++++++++++++++++++
GMPASUB_MD_DT	EQU	$
		BYTE	0FFH,001H
;
;
GMPASUB_MODE	EQU	$
		PHY
		PHP
		M8		; memory 8bit mode
		LDY	!GMPASMK
		LDA	!GMPAUSE
		CLC
		ADC	GMPASUB_MD_DT,Y
		STA	!GMPAUSE
		BNE	GMPASUB_MD_90	;|[YH ( no:GMPASUB_MD_90 )
;
;-------------- ACeEFCg^C}[Zbg`FbN ----------
		LDA	ITEMNO
		BEQ	GMPASUB_MD_90	;ACegpH ( no:GMPASUB_MD_90 )
;
		LDA	#027H		;[]
		JSL	>SOUND_3_ON
		LDA	#040H
		STA	ITEM_TM
;
GMPASUB_MD_90	EQU	$
		PLP
		PLY
		RTS
;
		MEM16
		IDX16
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	̑ f[^ A			+
;++++++++++++++++++++++++++++++++++++++++++++++++
GMPASUB_710	EQU	$
		LDA	>SCH_BUF
		STA	<SCCH3
		LDA	>SCV_BUF
		STA	<SCCV3
		LDA	>HD42C_BUF
		STA	!HD420C
		LDA	>NUK_BUF
		STA	!NUKCOL
;
		M8			; memory 8bit mode
		LDA	>NMITYP_BUF
		STA	!NMITYP
		LDA	>MOZNO_BUF
		STA	!MOZNO
		LDA	>SUBADF_BUF
		STA	!SUBADF
		M16			; memory 16bit mode
		RTS
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	̑ f[^ ޔ			+
;++++++++++++++++++++++++++++++++++++++++++++++++
GMPASUB_720	EQU	$
		LDA	<SCCH3
		STA	>SCH_BUF
		LDA	<SCCV3
		STA	>SCV_BUF
		LDA	!HD420C
		STA	>HD42C_BUF
		LDA	!NUKCOL
		STA	>NUK_BUF
;
		M8			; memory 8bit mode
		LDA	!NMITYP
		STA	>NMITYP_BUF
		LDA	!MOZNO
		STA	>MOZNO_BUF
		STZ	!MOZNO
		LDA	!SUBADF
		STA	>SUBADF_BUF
		LDA	#020H
		STA	!SUBADF
		M16			; memory 16bit mode
;
		PHY
		LDA	#BANK CHR74	;XRA LN^[Zbg
		STA	<WORK1		;bank NO. set
		LDY	#02800H		;(Y) <-- VRAM address
		LDX	#CHR74		;(X) <-- A bus address
		LDA	#0800H		;(A) <-- number byte
		JSL	>VRAMDX_ST
		PLY
		RTS
;
		IDX8
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+		tF[h AEg			+
;++++++++++++++++++++++++++++++++++++++++++++++++
GMPS_COL_OUT	EQU	$
		LDX	#000
GMPS_COL_OUT_LP EQU	$
		LDA	>COL_BUF+000H,X
		STA	>DATACOL+000H,X
		LDA	>COL_BUF+100H,X
		STA	>DATACOL+100H,X
		INX
		INX
		BNE	GMPS_COL_OUT_LP
;
		PLB
		RTS
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+		tF[h C			+
;++++++++++++++++++++++++++++++++++++++++++++++++
GMPS_COL_IN	EQU	$
		LDA	#00000H
		STA	<SCCH3
		STA	<SCCV3
		STA	!NUKCOL
		TAX
		STX	!HD420C
		LDY	#BANK DATACOL
		PHY
		PLB
;
GMPS_COL_IN_00	EQU	$		; J[f[^̑ޔ
		LDA	!DATACOL+000H,X
		STA	>COL_BUF+000H,X
		LDA	!DATACOL+100H,X
		STA	>COL_BUF+100H,X
		INX
		INX
		BNE	GMPS_COL_IN_00
;
		LDA	#00000H
		TAX
		TXY
GMPS_COL_IN_10	EQU	$		; J[f[^̃[NA
		STA	!DATACOL+000H,X
		STA	!DATACOL+100H,X
		INX
		INX
		BNE	GMPS_COL_IN_10
;
		TYX
GMPS_COL_IN_20	EQU	$		;|SƃXRÃJ[Zbg
		LDA	>COL_ADDRESS+METER_COL+2,X
		STA	!DATACOL+((16*2)*0)+2,X
		LDA	>COL_ADDRESS+METER_COL+(16*2)+2,X
		STA	!DATACOL+((16*2)*1)+2,X
		LDA	>COL_ADDRESS+OBJ_MAIN_COL+(15*2*0),X
		STA	!DATACOL+((16*2)*8)+2,X
		LDA	>COL_ADDRESS+OBJ_MAIN_COL+(15*2*1),X
		STA	!DATACOL+((16*2)*9)+2,X
		LDA	>COL_ADDRESS+OBJ_MAIN_COL+(15*2*2),X
		STA	!DATACOL+((16*2)*10)+2,X
		INX
		INX
		CPX	#015*2
		BCC	GMPS_COL_IN_20
;
		LDX	#BANK PAUSE_SCR
		PHX
		PLB
		LDX	#000
		LDA	#0217FH
GMPS_COL_IN_30	EQU	$		; XN[ obt@ NA
		STA	!PAUSE_SCR+000H,X
		STA	!PAUSE_SCR+100H,X
		STA	!PAUSE_SCR+200H,X
		STA	!PAUSE_SCR+300H,X
		STA	!PAUSE_SCR+400H,X
		STA	!PAUSE_SCR+500H,X
		STA	!PAUSE_SCR+600H,X
		INX
		INX
		BNE	GMPS_COL_IN_30
;
		LDX	#000
		STX	<WORK0
		TXY
GMPS_COL_IN_40	EQU	$		; {LN^[ Zbg
		LDA	<WORK0		; _
		ASL	A
		TAX
		LDA	>BG3LINEDAT1,X
		STA	!PAUSE_SCR+(20H*10H+04H)*2,Y
;
		LDX	<WORK0
		CPX	#GMGOAL_SCR5-GMGOAL_SCR4
		BCS	GMPS_COL_IN_46
		LDA	>GMGOAL_SCR4,X	; "sns`k onhms"
		AND	#000FFH
		TAX
		LDA	>GMGOAL_MJ_DAT0,X
		STA	!PAUSE_SCR+(20H*11H+07H)*2,Y
		LDA	>GMGOAL_MJ_DAT1,X
		STA	!PAUSE_SCR+(20H*12H+07H)*2,Y
;
GMPS_COL_IN_46	EQU	$
		LDX	<WORK0
		CPX	#GMGOAL_SCR6-GMGOAL_SCR5
		BCS	GMPS_COL_IN_48
		LDA	>GMGOAL_SCR5,X	; "ghfg rbnqd"
		AND	#000FFH
		TAX
		LDA	>GMGOAL_MJ_DAT0,X
		STA	!PAUSE_SCR+(20H*14H+07H)*2,Y
		LDA	>GMGOAL_MJ_DAT1,X
		STA	!PAUSE_SCR+(20H*15H+07H)*2,Y
;
GMPS_COL_IN_48	EQU	$
		INY
		INY
		INC	<WORK0
		LDX	<WORK0
		CPX	#GMGOAL_SCR2-GMGOAL_SCR1
		BCC	GMPS_COL_IN_40
;
GMPS_COL_IN_49	EQU	$
;
		JSR	GMPS_TIMER
;
		JSR	GMPS_COIN
;
		JSR	GMPS_FLOWER
;
		JSR	GMPS_TOTAL
;
		JSR	GMPS_HI_SCORE
;
		JSR	GMPS_MATER
;
		JSR	ITEM_INIT
;
		I16			; index 16bit mode
		LDY	#BANK PAUSE_SCR
		STY	<WORK1		;(WK1) <- ]oN
		LDY	#03400H		; Y <---- uq`lAhX
		LDX	#PAUSE_SCR	; X <---- ]AhX
		LDA	#(00020H*1CH)*2 ; A <---- ]oCg
		JSL	>VRAMDX_ST
		I8			; index 8bit mode
;
		PLB
;
		LDX	#009H
		STX	!BGMODE
		LDX	#034H
		STX	!BG3SCF
		LDX	#002H
		STX	!BG34CH
		STX	!NMITYP
		LDA	#00014H
		STA	!MANSEL
		RTS
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+		^C}[_\		+
;++++++++++++++++++++++++++++++++++++++++++++++++
GMPS_TIMER	EQU	$
		STZ	<WORK18
		LDY	#000
		STZ	<WORK0
		LDA	>TIMER
		BEQ	GMPS_TIMER_060
GMPS_TIMER_020	EQU	$
		CMP	#TIMER_DEC
		BCC	GMPS_TIMER_040
		SEC
		SBC	#TIMER_DEC
		INC	<WORK0
		BRA	GMPS_TIMER_020
;
GMPS_TIMER_040	EQU	$
		LDA	<WORK0
		CMP	#TIMER_MAX	; l`wȏ゠邩 ?
		BCC	GMPS_TIMER_060	;	NO -> GMPS_TIMER_060
		LDA	#00400H
		STA	<WORK18
		LDA	#TIMER_MAX
GMPS_TIMER_060	EQU	$
		STA	<WORK0
GMPS_TIMER_070	EQU	$
		CMP	#00010
		BCC	GMPS_TIMER_080
		SBC	#00010
		INY
		BRA	GMPS_TIMER_070
;
GMPS_TIMER_080	EQU	$
		ASL	A
		TAX
		PHX
		PHY
;
		LDX	#000
		TXY
GMPS_TIMER_085	EQU	$		; {LN^[
		PHX
		LDA	>GMGOAL_SCR1,X
		AND	#000FFH
		TAX
		LDA	>GMGOAL_MJ_DAT0,X
		ORA	<WORK18
		STA	!PAUSE_SCR+(20H*07H+04H)*2,Y
		LDA	>GMGOAL_MJ_DAT1,X
		ORA	<WORK18
		STA	!PAUSE_SCR+(20H*08H+04H)*2,Y
		PLX
		INY
		INY
		INX
		CPX	#GMGOAL_SCR2-GMGOAL_SCR1
		BCC	GMPS_TIMER_085
;
		PLY
		PLX
		LDA	#PAUSE_SCR+(20H*07H+11H)*2
		STA	<WORK10
		LDA	#PAUSE_SCR+(20H*07H+18H)*2
		STA	<WORK12
		LDA	#PAUSE_SCR+(20H*08H+11H)*2
		STA	<WORK14
		LDA	#PAUSE_SCR+(20H*08H+18H)*2
		STA	<WORK16
		JSR	GMPS_COL_IN_SB
		RTS
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+		RC_\			+
;++++++++++++++++++++++++++++++++++++++++++++++++
GMPS_COIN	EQU	$
		STZ	<WORK18
		LDY	#000
		LDA	>CORS_COIN
		CMP	#COIN_MAX	; l`wȏ゠邩 ?
		BCC	GMPS_CIN_020	;	NO -> GMPS_CIN_020
		LDA	#00400H
		STA	<WORK18
		LDA	#COIN_MAX
GMPS_CIN_020	EQU	$
		STA	<WORK2
GMPS_CIN_040	EQU	$
		CMP	#00010
		BCC	GMPS_CIN_060
		SBC	#00010
		INY
		BRA	GMPS_CIN_040
;
GMPS_CIN_060	EQU	$
		ASL	A
		TAX
		PHX
		PHY
;
		LDX	#000
		TXY
GMPS_CIN_085	EQU	$		; {LN^[
		PHX
		LDA	>GMGOAL_SCR2,X
		AND	#000FFH
		TAX
		LDA	>GMGOAL_MJ_DAT0,X
		ORA	<WORK18
		STA	!PAUSE_SCR+(20H*0AH+04H)*2,Y
		LDA	>GMGOAL_MJ_DAT1,X
		ORA	<WORK18
		STA	!PAUSE_SCR+(20H*0BH+04H)*2,Y
		PLX
		INY
		INY
		INX
		CPX	#GMGOAL_SCR3-GMGOAL_SCR2
		BCC	GMPS_CIN_085
;
		PLY
		PLX
		LDA	#PAUSE_SCR+(20H*0AH+11H)*2
		STA	<WORK10
		LDA	#PAUSE_SCR+(20H*0AH+18H)*2
		STA	<WORK12
		LDA	#PAUSE_SCR+(20H*0BH+11H)*2
		STA	<WORK14
		LDA	#PAUSE_SCR+(20H*0BH+18H)*2
		STA	<WORK16
		JSR	GMPS_COL_IN_SB
		RTS
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+		t[_\		+
;++++++++++++++++++++++++++++++++++++++++++++++++
GMPS_FLOWER	EQU	$
		STZ	<WORK18
		LDA	>FRWR_P
		ASL	A
		TAX
		CPX	#005*2
		BCC	GMPS_FLWR_050
		LDA	#00400H
		STA	<WORK18
GMPS_FLWR_050	EQU	$
		PHX
;
		LDX	#000
		TXY
GMPS_FLWR_085	EQU	$		; {LN^[
		PHX
		LDA	>GMGOAL_SCR3,X
		AND	#000FFH
		TAX
		LDA	>GMGOAL_MJ_DAT0,X
		ORA	<WORK18
		STA	!PAUSE_SCR+(20H*0DH+04H)*2,Y
		LDA	>GMGOAL_MJ_DAT1,X
		ORA	<WORK18
		STA	!PAUSE_SCR+(20H*0EH+04H)*2,Y
		PLX
		INY
		INY
		INX
		CPX	#GMGOAL_SCR4-GMGOAL_SCR3
		BCC	GMPS_FLWR_085
;
		PLX
		LDA	>GMGOAL_KAZ_DT0,X
		ORA	<WORK18
		STA	!PAUSE_SCR+(20H*0DH+13H)*2
		TXY
		BEQ	GMPS_FLWR_095
		STA	!PAUSE_SCR+(20H*0DH+18H)*2
GMPS_FLWR_095	EQU	$
		LDA	>GMGOAL_KAZ_DT1,X
		ORA	<WORK18
		STA	!PAUSE_SCR+(20H*0EH+13H)*2
		TXY
		BEQ	GMPS_FLWR_099
		STA	!PAUSE_SCR+(20H*0EH+18H)*2
GMPS_FLWR_099	EQU	$
		RTS
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+		v_\			+
;++++++++++++++++++++++++++++++++++++++++++++++++
GMPS_TOTAL	EQU	$
		STZ	<WORK18
		LDY	#000
		LDA	>FRWR_P
		ASL	A
		STA	<WORKE
		ASL	A
		ASL	A
		ADC	<WORKE
		CLC
		ADC	<WORK0
		CLC
		ADC	<WORK2
		STA	<WORK0
		CMP	#00100		; POO_ ?
		BCC	GMPS_TTL_040	;	NO -> GMPS_TTL_040
;;;;K;;;;		LDA	#00400H
;;;;K;;;;		STA	<WORK18
		LDA	#(S100-S00)/2
		TAY
		INY
		BRA	GMPS_TTL_060
;
GMPS_TTL_040	EQU	$
		CMP	#00010
		BCC	GMPS_TTL_060
		SBC	#00010
		INY
		BRA	GMPS_TTL_040
;
GMPS_TTL_060	EQU	$
		ASL	A
		TAX
		LDA	#PAUSE_SCR+(20H*11H+18H)*2
		STA	<WORK10
		STA	<WORK12
		LDA	#PAUSE_SCR+(20H*12H+18H)*2
		STA	<WORK14
		STA	<WORK16
		JSR	GMPS_COL_IN_SB
		RTS
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+		nCXRA_\		+
;++++++++++++++++++++++++++++++++++++++++++++++++
GMPS_HI_SCORE	EQU	$
		LDY	#000
		LDA	>MAPOINT
		TAX
		LDA	>HISCEBF,X
		AND	#000FFH
		CMP	<WORK0
		BCS	GMPS_HI_020
		LDA	<WORK0
GMPS_HI_020	EQU	$
		CMP	#00100		; POO_ ?
		BCC	GMPS_HI_040	;	NO -> GMPS_HI_040
		LDA	#(S100-S00)/2
		TAY
		INY
		BRA	GMPS_HI_060
GMPS_HI_040	EQU	$
		CMP	#00010
		BCC	GMPS_HI_060
		SBC	#00010
		INY
		BRA	GMPS_HI_040
;
GMPS_HI_060	EQU	$
		ASL	A
		TAX
		LDA	#PAUSE_SCR+(20H*14H+18H)*2
		STA	<WORK10
		STA	<WORK12
		LDA	#PAUSE_SCR+(20H*15H+18H)*2
		STA	<WORK14
		STA	<WORK16
		STZ	<WORK18
		JSR	GMPS_COL_IN_SB
		RTS
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	ACe ZNg CjVZbg	+
;++++++++++++++++++++++++++++++++++++++++++++++++
ITEM_INIT	EQU	$
		PHB
		PHK
		PLB
		STZ	!ITEMDSP+0
		STZ	!ITEMDSP+1
		M8			; memory 8bit mode
		LDX	#000
		TXY
ITMINT_040	EQU	$
		LDA	!ITEMBUF,X
		AND	#00FH
		BEQ	ITMINT_060
		STA	!ITEMBUF,Y
		INY
ITMINT_060	EQU	$
		INX
		CPX	#027
		BCC	ITMINT_040
;
		TYX
ITMINT_080	EQU	$
		CPX	#027
		BCS	ITMINT_100
		STZ	!ITEMBUF,X
		INX
		BRA	ITMINT_080
;
ITMINT_100	EQU	$
		LDA	!ITEMBUF	; ACe Ă邩 ?
		BEQ	ITMINT_120	;	NO -> ITMINT_120
;
		LDY	#000H
		LDA	!ITEMPNT
		BNE	ITMINT_110
		STZ	!ITMBFPOS
		INC	!ITEMPNT
ITMINT_110	EQU	$		; ACemn. Zbg
		LDX	!ITMBFPOS
;
ITMINT_115	EQU	$
		LDA	!ITEMBUF,X	; \pobt@ Zbg
		STA	!ITEMDSP,Y
		INX
		INY
		CPY	#003
		BCC	ITMINT_115
;
		M16			; memory 16bit mode
		JSR	ITEM_CORSL_SUB
;
ITMINT_120	EQU	$
		M16			; memory 16bit mode
		PLB
		RTS
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+		[^[			+
;++++++++++++++++++++++++++++++++++++++++++++++++
GMPS_TIM_DT_UP	EQU	$
		WORD	01DA8H,01D80H,01D82H,01D84H,01D86H
		WORD	01D88H,01DA0H,01DA2H,01DA4H,01DA6H
;
GMPS_TIM_DT_DWN EQU	$
		WORD	01DB8H,01D90H,01D92H,01D94H,01D96H
		WORD	01D98H,01DB0H,01DB2H,01DB4H,01DB6H
;
;
GMPS_MATER	EQU	$
		LDX	#000
GMPS_MTR_020	EQU	$
		LDA	#09D8BH
		STA	!PAUSE_SCR+(20H*17H+00H)*2,X
		LDA	#01D8BH
		STA	!PAUSE_SCR+(20H*1AH+00H)*2,X
		LDA	#009AFH
		STA	!PAUSE_SCR+(20H*18H+00H)*2,X
		STA	!PAUSE_SCR+(20H*19H+00H)*2,X
		INX
		INX
		CPX	#020H*2
		BCC	GMPS_MTR_020
;
		LDA	#0098CH			; " bV[ "
		STA	!PAUSE_SCR+(20H*18H+01H)*2
		INC	A
		STA	!PAUSE_SCR+(20H*18H+02H)*2
		INC	A
		STA	!PAUSE_SCR+(20H*19H+01H)*2
		INC	A
		STA	!PAUSE_SCR+(20H*19H+02H)*2
;
		LDX	#000
		TXY
		LDA	>PLCONT			; cl
GMPS_MTR_040	EQU	$
		CMP	#00100		;POOȏ ?
		BCC	GMPS_MTR_043	;	NO -> GMPS_MTR_043
		SBC	#00100
		INY
		BRA	GMPS_MTR_040
GMPS_MTR_043	EQU	$
		CMP	#00010		;POȏ ?
		BCC	GMPS_MTR_045	;	NO -> GMPS_MTR_045
		SBC	#00010
		INX
		BRA	GMPS_MTR_043
GMPS_MTR_045	EQU	$
		CPY	#000
		BNE	GMPS_MTR_049
		TXY
		TAX
		LDA	#010
		CPY	#000
		BNE	GMPS_MTR_049
		TXY
		TAX
		LDA	#010
GMPS_MTR_049	EQU	$
		ORA	#00DC0H
		STA	!PAUSE_SCR+(20H*19H+05H)*2
		TXA
		ORA	#00DC0H
		STA	!PAUSE_SCR+(20H*19H+04H)*2
		TYA
		ORA	#00DC0H
		STA	!PAUSE_SCR+(20H*19H+03H)*2
;
		LDA	#00DD2H			; " RC "
		STA	!PAUSE_SCR+(20H*18H+06H)*2
		INC	A
		STA	!PAUSE_SCR+(20H*18H+07H)*2
		INC	A
		STA	!PAUSE_SCR+(20H*19H+06H)*2
		INC	A
		STA	!PAUSE_SCR+(20H*19H+07H)*2
;
		LDX	#000
		LDA	>COIN_CNT		; RC
GMPS_MTR_060	EQU	$
		CMP	#00010
		BCC	GMPS_MTR_065
		SBC	#00010
		INX
		BRA	GMPS_MTR_060
GMPS_MTR_065	EQU	$
		CPX	#000
		BNE	GMPS_MTR_069
		TAX
		LDA	#010
GMPS_MTR_069	EQU	$
		ORA	#00DC0H
		STA	!PAUSE_SCR+(20H*19H+09H)*2
		TXA
		ORA	#00DC0H
		STA	!PAUSE_SCR+(20H*19H+08H)*2
;
		LDA	#00DCBH			; " X^[ "
		STA	!PAUSE_SCR+(20H*18H+0BH)*2
		INC	A
		STA	!PAUSE_SCR+(20H*18H+0CH)*2
		INC	A
		STA	!PAUSE_SCR+(20H*19H+0BH)*2
		INC	A
		STA	!PAUSE_SCR+(20H*19H+0CH)*2
;
		LDA	>TIMER_HI		; ^C}[ \̈
		ASL	A
		TAX
		LDA	>GMPS_TIM_DT_UP,X
		STA	!PAUSE_SCR+(20H*18H+0DH)*2
		INC	A
		STA	!PAUSE_SCR+(20H*18H+0EH)*2
		LDA	>GMPS_TIM_DT_DWN,X
		STA	!PAUSE_SCR+(20H*19H+0DH)*2
		INC	A
		STA	!PAUSE_SCR+(20H*19H+0EH)*2
;
		LDA	>TIMER_MID		; ^C}[ ̈
		ASL	A
		TAX
		LDA	>GMPS_TIM_DT_UP,X
		STA	!PAUSE_SCR+(20H*18H+0FH)*2
		INC	A
		STA	!PAUSE_SCR+(20H*18H+10H)*2
		LDA	>GMPS_TIM_DT_DWN,X
		STA	!PAUSE_SCR+(20H*19H+0FH)*2
		INC	A
		STA	!PAUSE_SCR+(20H*19H+10H)*2
;
		JSR	ITEM_WAKU
;
		M8			; memory 8bit mode
		PHB
		PHK
		PLB
		JSR	LTRTARWST
		PLB
		M16			; memory 16bit mode
;
		RTS
;
;++++++++++++++++++++++++++++++++++++++++
;+		_Zbg		+
;+		in			+
;+		X <- read data index	+
;+		Y <-	"       "	+
;+		wk10,11 : buffer address+
;+		  12,13 :	"       +
;+		  14,15 :	"       +
;+		  16,17 :	"       +
;+		  18,19 : Agr[g+
;++++++++++++++++++++++++++++++++++++++++
GMPS_COL_IN_SB	EQU	$
		PHY
		LDY	#002
		LDA	>GMGOAL_KAZ_DT0,X
		ORA	<WORK18
		STA	(<WORK10),Y
		STA	(<WORK12),Y
		LDA	>GMGOAL_KAZ_DT1,X
		ORA	<WORK18
		STA	(<WORK14),Y
		STA	(<WORK16),Y
		PLY
		BEQ	GMPS_COL_IN_PS
		TYA
		ASL	A
		TAX
		LDA	>GMGOAL_KAZ_DT0,X
		ORA	<WORK18
		STA	(<WORK10)
		STA	(<WORK12)
		LDA	>GMGOAL_KAZ_DT1,X
		ORA	<WORK18
		STA	(<WORK14)
		STA	(<WORK16)
GMPS_COL_IN_PS	EQU	$
		RTS
;
;++++++++++++++++++++++++++++++++
;+	ACeg Zbg	+
;++++++++++++++++++++++++++++++++
ITEM_WAKU	EQU	$
		LDA	#01DACH
		STA	!PAUSE_SCR+(20H*17H+14H)*2
		LDA	#01D9CH
		STA	!PAUSE_SCR+(20H*18H+14H)*2
		STA	!PAUSE_SCR+(20H*19H+14H)*2
		LDA	#09DACH
		STA	!PAUSE_SCR+(20H*1AH+14H)*2
		LDA	#01DADH
		STA	!PAUSE_SCR+(20H*17H+15H)*2
		STA	!PAUSE_SCR+(20H*17H+18H)*2
		STA	!PAUSE_SCR+(20H*17H+1BH)*2
		LDA	#05DADH
		STA	!PAUSE_SCR+(20H*17H+16H)*2
		STA	!PAUSE_SCR+(20H*17H+19H)*2
		STA	!PAUSE_SCR+(20H*17H+1CH)*2
		LDA	#09DADH
		STA	!PAUSE_SCR+(20H*1AH+15H)*2
		STA	!PAUSE_SCR+(20H*1AH+18H)*2
		STA	!PAUSE_SCR+(20H*1AH+1BH)*2
		LDA	#0DDADH
		STA	!PAUSE_SCR+(20H*1AH+16H)*2
		STA	!PAUSE_SCR+(20H*1AH+19H)*2
		STA	!PAUSE_SCR+(20H*1AH+1CH)*2
		LDA	#01DAEH
		STA	!PAUSE_SCR+(20H*17H+17H)*2
		STA	!PAUSE_SCR+(20H*17H+1AH)*2
		LDA	#09DAEH
		STA	!PAUSE_SCR+(20H*1AH+17H)*2
		STA	!PAUSE_SCR+(20H*1AH+1AH)*2
		LDA	#01D9EH
		STA	!PAUSE_SCR+(20H*18H+17H)*2
		STA	!PAUSE_SCR+(20H*18H+1AH)*2
		STA	!PAUSE_SCR+(20H*19H+17H)*2
		STA	!PAUSE_SCR+(20H*19H+1AH)*2
		LDA	#05DACH
		STA	!PAUSE_SCR+(20H*17H+1DH)*2
		LDA	#05D9CH
		STA	!PAUSE_SCR+(20H*18H+1DH)*2
		STA	!PAUSE_SCR+(20H*19H+1DH)*2
		LDA	#0DDACH
		STA	!PAUSE_SCR+(20H*1AH+1DH)*2
		LDA	#0117FH
		STA	!PAUSE_SCR+(20H*18H+15H)*2
		STA	!PAUSE_SCR+(20H*19H+15H)*2
		STA	!PAUSE_SCR+(20H*18H+16H)*2
		STA	!PAUSE_SCR+(20H*19H+16H)*2
		STA	!PAUSE_SCR+(20H*18H+18H)*2
		STA	!PAUSE_SCR+(20H*19H+18H)*2
		STA	!PAUSE_SCR+(20H*18H+19H)*2
		STA	!PAUSE_SCR+(20H*19H+19H)*2
		STA	!PAUSE_SCR+(20H*18H+1BH)*2
		STA	!PAUSE_SCR+(20H*19H+1BH)*2
		STA	!PAUSE_SCR+(20H*18H+1CH)*2
		STA	!PAUSE_SCR+(20H*19H+1CH)*2
		RTS
;
;
;************************************************************************
;*		VRAMDX set sub						*
;*			in  : (A) <-- VRAM address( <0:VRAM read )	*
;*			      (Y) <-- number of byte			*
;************************************************************************
;
		MEM16
		IDX16
;
VRMDXST		EQU	$
		PHB			;(DBR) save
		PEA	VRAMDX/100H
		PLB
		PLB			;(DBR) <-- VRAMDX(B)
;
		LDX	VRAMDX
		STA	0,X		;VRAM address set
		ASL	A		;(C) <-- VRAM read ?
		LDA	#10000000B
		STA	2,X		;inc mode set
		LDA	#BANK WORKBF
		STA	7,X		;A bus address(H,B) set
		TYA
		STA	8,X		;number of byte set
		LDA	#10000001B+(39H*100H)
		LDY	#WORKBF
		BCS	VRXS010		;VRAM read ? ( yes:VRXS010 )
;
		LDA	#00000001B+(18H*100H)
		INY
		INY
VRXS010		EQU	$
		STA	3,X		;inc mode & DMA parameter set
		TYA
		STA	5,X		;B bus address & A bus addres(L) set
;
		TXA
		CLC
		ADC	#12
		STA	10,X		;next data address set
		STA	VRAMDX		;end address set
;
		MI8
;
		PLB		;(DBR) load
		RTS
;
;************************************************************************
;*		initial H-DAM set					*
;************************************************************************
GRADATION_ADRS	EQU	$-(10H*4)			     ;[NUKINO]
		WORD	BANK COL_ADDRESS+GRADATION_COL_0 ;[10]
		WORD	     COL_ADDRESS+GRADATION_COL_0
		WORD	BANK COL_ADDRESS+GRADATION_COL_1 ;[11]
		WORD	     COL_ADDRESS+GRADATION_COL_1
		WORD	BANK COL_ADDRESS+GRADATION_COL_2 ;[12]
		WORD	     COL_ADDRESS+GRADATION_COL_2
		WORD	BANK COL_ADDRESS+GRADATION_COL_3 ;[13]
		WORD	     COL_ADDRESS+GRADATION_COL_3
		WORD	BANK COL_ADDRESS+GRADATION_COL_4 ;[14]
		WORD	     COL_ADDRESS+GRADATION_COL_4
		WORD	BANK COL_ADDRESS+GRADATION_COL_5 ;[15]
		WORD	     COL_ADDRESS+GRADATION_COL_5
		WORD	BANK COL_ADDRESS+GRADATION_COL_6 ;[16]
		WORD	     COL_ADDRESS+GRADATION_COL_6
		WORD	BANK COL_ADDRESS+GRADATION_COL_7 ;[17]
		WORD	     COL_ADDRESS+GRADATION_COL_7
		WORD	BANK COL_ADDRESS+GRADATION_COL_8 ;[18]
		WORD	     COL_ADDRESS+GRADATION_COL_8
		WORD	BANK COL_ADDRESS+GRADATION_COL_9 ;[19]
		WORD	     COL_ADDRESS+GRADATION_COL_9
		WORD	BANK COL_ADDRESS+GRADATION_COL_A ;[1A]
		WORD	     COL_ADDRESS+GRADATION_COL_A
		WORD	BANK COL_ADDRESS+GRADATION_COL_B ;[1B]
		WORD	     COL_ADDRESS+GRADATION_COL_B
		WORD	BANK COL_ADDRESS+GRADATION_COL_C ;[1C]
		WORD	     COL_ADDRESS+GRADATION_COL_C
		WORD	BANK COL_ADDRESS+GRADATION_COL_D ;[1D]
		WORD	     COL_ADDRESS+GRADATION_COL_D
		WORD	BANK COL_ADDRESS+GRADATION_COL_E ;[1E]
		WORD	     COL_ADDRESS+GRADATION_COL_E
		WORD	BANK COL_ADDRESS+GRADATION_COL_F ;[1F]
		WORD	     COL_ADDRESS+GRADATION_COL_F
;
INHDMA		EQU	$
		PHB			;(DBR) save
		PHK			;(DBR) <-- (PBR)
		PLB
;
		LDX	#04
IHD010		EQU	$
		LDA	!HDMAP0,X
		STA	4360H,X
		LDA	!HDMAP1,X
		STA	4370H,X
		LDA	!HDMAP2,X	;spacial window
		STA	4350H,X
		LDA	!HDMAP3,X	;H-DMA test
		STA	4340H,X
		LDA	!HDMAP4,X	;obake test
		STA	4330H,X
		LDA	!HDMAP5,X	;Of[VJ[
		STA	4320H,X
		LDA	!HDMAP6,X	;	  h
		STA	4310H,X
		DEX
		BPL	IHD010
		LDA	#BANK HDMABUF
		STA	4367H
		STA	4377H
		STA	4357H
		STA	4347H
		STA	4337H
		LDA	#BANK NUKCOL_BF_RG
		STA	4327H
		STA	4317H
;
		LDX	#HDMAPD2E-HDMAPD2-1
IHD020		EQU	$
		LDA	!HDMAPD2,X
		STA	>HDMAPR0,X
		LDA	!HDMAPD3,X
		STA	>HDMAPR1,X
		LDA	!HDMAPD4,X
		STA	>HDMAPR2,X
		LDA	!HDMAPD5,X
		STA	>HDMAPR3,X
		LDA	!HDMAPD6,X
		STA	>HDMAPR4,X
		DEX
		BPL	IHD020
;
;-------------- Of[VJ[Zbg ------------------------------
		LDX	#00		;(X) <-- H-DMA "ON" flag set data
		LDA	NUKINO
		CMP	#10H
		BCC	IHD030		;Of[VJ[ZbgH ( no:IHD030 )
;
		ASL	A
		ASL	A
		TAY
;
		M16
;
		LDA	!GRADATION_ADRS,Y
		STA	R0		;(R0) <-- J[p^[AhX(B)
		LDA	!GRADATION_ADRS+2,Y
		STA	R1		;(R1) <--	    h		(L,H)
		M_CHIP	GRADATION_SET
;
		LDA	#NUKCOL_BF_B	;to memory address set
		STA	<WORK20
		LDY	#BANK NUKCOL_BF_B
		STY	<WORK22
		LDA	#WOB7CHR	;from memory address set
		STA	<WORK23
		LDY	#BANK WOB7CHR
		STY	<WORK25
		LDA	#NUKCOL_BF_NO*3 ;(A) <-- number of byte set
		JSL	>DMA_M_M	;DMA "ON"
;
		M8
;
		LDX	#00000110B	;Of[Vg|cl`hnmh
IHD030		EQU	$
		STX	HD420C
;
		PLB
		RTL
;
;-------------- H-DMA parameter data ( water ) ------------------
HDMAP0		EQU	$
		BYTE	00000001B	;DMA control parameter
		BYTE	2CH		;    B bus address
		BYTE	LOW  HDMABUF2	;    A	    "     (L)
		BYTE	HIGH HDMABUF2	;	    "     (H)
		BYTE	BANK HDMABUF2	;	    "     (B)
;
;-------------- afRXN[ ----------------------------
HDMAP1		EQU	$
		BYTE	00000011B	;DMA control parameter
		BYTE	11H		;    B bus address
		BYTE	LOW  HDMABUF0	;    A	    "     (L)
		BYTE	HIGH HDMABUF0	;	    "     (H)
		BYTE	BANK HDMABUF0	;	    "     (B)
;
;-------------- spacial window H-DMA parameter data -------------
HDMAP2		EQU	$
		BYTE	01000100B	;DMA control parameter
		BYTE	26H		;    B bus address
		BYTE	LOW  HDMAPR0	;    A	    "     (L)
		BYTE	HIGH HDMAPR0	;	    "     (H)
		BYTE	BANK HDMAPR0	;	    "     (B)
;
HDMAPD2		EQU	$
		BYTE	69H+80H		;line no.
		WORD	WINDBUF
		BYTE	69H+80H		;line no.
		WORD	WINDBUF+(69H*4)
		HEX	00		;end code
HDMAPD2E	EQU	$
;
;-------------- H-DMA test H-DMA parameter data -----------------
HDMAP3		EQU	$
		BYTE	01000010B	;DMA control parameter
		BYTE	12H		;    B bus address
		BYTE	LOW  HDMAPR1	;    A	    "     (L)
		BYTE	HIGH HDMAPR1	;	    "     (H)
		BYTE	BANK HDMAPR1	;	    "     (B)
;
HDMAPD3		EQU	$
		BYTE	69H+80H		;line no.
		WORD	HDMABUF
		BYTE	69H+80H		;line no.
		WORD	HDMABUF+(69H*2)
		HEX	00		;end code
;
;-------------- H-DMA test H-DMA parameter data -----------------
HDMAP4		EQU	$
		BYTE	01000010B	;DMA control parameter
		BYTE	11H		;    B bus address
		BYTE	LOW  HDMAPR2	;    A	    "     (L)
		BYTE	HIGH HDMAPR2	;	    "     (H)
		BYTE	BANK HDMAPR2	;	    "     (B)
;
HDMAPD4		EQU	$
		BYTE	69H+80H		;line no.
		WORD	HDMABUF2
		BYTE	69H+80H		;line no.
		WORD	HDMABUF2+(69H*2)
		HEX	00		;end code
;
;-------------- Of[VJ[ H-DMA parameter data -------
HDMAP5		EQU	$
		BYTE	01000010B	;DMA control parameter
		BYTE	32H		;    B bus address
		BYTE	LOW  HDMAPR3	;    A	    "     (L)
		BYTE	HIGH HDMAPR3	;	    "     (H)
		BYTE	BANK HDMAPR3	;	    "     (B)
;
HDMAPD5		EQU	$
		BYTE	69H+80H		;line no.
		WORD	NUKCOL_BF_RG
		BYTE	69H+80H		;line no.
		WORD	NUKCOL_BF_RG+(69H*2)
		HEX	00		;end code
HDMAPD5_E	EQU	$
HDMAPD5_NO	EQU	HDMAPD5_E-HDMAPD5
;
HDMAP6		EQU	$
		BYTE	01000000B	;DMA control parameter
		BYTE	32H		;    B bus address
		BYTE	LOW  HDMAPR4	;    A	    "     (L)
		BYTE	HIGH HDMAPR4	;	    "     (H)
		BYTE	BANK HDMAPR4	;	    "     (B)
;
HDMAPD6		EQU	$
		BYTE	69H+80H		;line no.
		WORD	NUKCOL_BF_B
		BYTE	69H+80H		;line no.
		WORD	NUKCOL_BF_B+69H
		HEX	00		;end code
;
;************************************************************************
;*		water H-DMA data set					*
;************************************************************************
;
SPACIAL		EQU	$
		LDA	!BG2SPFV
		BEQ	SPL_100
		JSR	BG2_SCCV_SET
		BRA	SPL_200
;
SPL_100		EQU	$
		LDA	!BG3SPFH
		BEQ	SPL_200
		JSR	BG3_SCCH_SET
;
SPL_200		EQU	$
		LDX	!DSPCNTRLFG
		BEQ	SPL_300
		JSR	DISP_SET
		BRA	SPL_500
;
SPL_300		EQU	$
		LDA	!BG2SPF
		BEQ	SPL_400
		JSR	BG2_SCCH_SET
		BRA	SPL_500
;
SPL_400		EQU	$
		LDA	!BG3SPFV
		BEQ	SPL_500
		JSR	BG3_SCCV_SET
;
;-------------- BG3 spacial screen set --------------------------
SPL_500		EQU	$
		LDX	BG3SPF
		BNE	BGP0FD		;afRXN[H ( yes:BGP0FD )
		RTS
;
BGP0FD		EQU	$
		M16
;
		LDA	ESCCV1-2,X
		STA	R2		;(R2) <-- XN[JE^[u
		LDX	#BANK BG3SCSP
		LDA	#BG3SCSP
		JSL	>CHIPON
;
		LDA	R1		;(A) <-- ]oCg
		SEC
		SBC	#HDMABF0
		JSL	>M_DMA_BFST_N
		LWORD	HDMABUF0	;]AhX
		LWORD	HDMABF0		;]AhX
;
		LDA	BG3TYP
		CMP	#01H
		BEQ	BGP0FD2		;H ( yes:BGP0FD2 )
;
		M8
;
		LDA	#10000000B	;H-DMA "ON"
		BRA	BGP040
;
;-------------- H-DMA data set ----------------------------------
;
		MEM16
;
BGP0FD2		EQU	$
		LDA	#0707H-8
		SEC
		SBC	<SCCV1
		BCS	BGP0FE		;all add ? ( no:BGP0FE )
;
		SEP	#00100000B	;memory 8 bit mode
		LDA	MANSEL
		BRA	BGP0FF
;
BGP0FE		EQU	$
		CMP	#00D2H
;
		M8
;
		BCC	BGP000		;add "ON" area nothing ? ( no:BGP000 )
		LDA	#00010111B	;[ main select BG3 "ON" ]
BGP0FF		EQU	$
		STA	>HDMABUF2+1	;not add set
		EOR	#00000100B
		AND	#00000100B
		STA	>HDMABUF2+2	;not add set
		LDA	#01H
		STA	>HDMABUF2	;line no.
		LDA	#00
		STA	>HDMABUF2+3	;end code
		BRA	BGP030
;
BGP000		EQU	$
		LDX	#00
		CMP	#80H
		BCC	BGP010		;data size over ? ( no:BGP010 )
;;;;		SEC
		SBC	#7FH
		PHA
		LDA	#7FH
		STA	>HDMABUF2,X	;line no.
		LDA	#00010111B	;[ main select BG3 "ON" ]
		STA	>HDMABUF2+1,X	;not add set
		LDA	#00
		STA	>HDMABUF2+2,X
		PLA
		INX
		INX
		INX
BGP010		EQU	$
		STA	>HDMABUF2,X	;line no.
		LDA	#01
		STA	>HDMABUF2+3,X	;add area set
		LDA	MANSEL
		STA	>HDMABUF2+4,X	;add set
		LDA	#00000100B
		STA	>HDMABUF2+5,X	;add set
		LDA	#00010111B	;[ main select BG3 "ON" ]
		STA	>HDMABUF2+1,X	;not add set
		LDA	#00
		STA	>HDMABUF2+2,X
		LDA	#00
		STA	>HDMABUF2+6,X	;end code
;
BGP030		EQU	$
		LDA	#11000000B	;H-DMA "ON"
BGP040		EQU	$
		TSB	HD420C
		RTS
;
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+		ʎw̐ (gcl`obt@Zbg)		+
;+				in				+
;+				X : XN[l read index	+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
DISP_SET	EQU	$
		M16			; memory 16bit mode
		DEX
		LDA	<SCCV1,X
		STA	R2		; XN[l
		LDA	#BANK DP_INT_DAT
		STA	R0		; oN
		LDA	!DISP_ADR
		STA	R9		; f[^AhX
		LDA	#HDMABF
		STA	R10		; obt@ AhX
		LDX	#BANK DISP_CNTRL
		LDA	#DISP_CNTRL
		JSL	>CHIPON
;
		LDA	#000D2H*2	;(A) <-- ]oCg
		JSL	>M_DMA_BFST_N
		LWORD	HDMABUF		;]AhX
		LWORD	HDMABF		;]AhX
;
		M8			; memory 8bit mode
		LDA	#00010000B
		TSB	HD420C
		RTS
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+		afQcXN[Zbg		+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
BG2_SCCV_SET	EQU	$
		M16			; memory 16bit mode
		LDA	!BG2SPFV
		AND	#00002
		STA	R1
		LDA	!ESCCV2
		STA	R2
		LDA	!BG2SPV_CT
		STA	R3		;  Zbg
		LDA	!BG2SPFV_ADR
		STA	R7
		LDA	#BANK BG2_SCR_DATA
		STA	R8
		LDA	#HDMABF2
		STA	R10
		LDA	!ENSTFG
		AND	#000FFH
		STA	R11		; R11 <- Aj[V Xgbv tO
		LDX	#BANK BG2VSCSP
		LDA	#BG2VSCSP
		JSL	>CHIPON
;
		LDA	#000D2H*2	;(A) <-- ]oCg
		JSL	>M_DMA_BFST_N
		LWORD	HDMABUF2	;]AhX
		LWORD	HDMABF2		;]AhX
;
		M8			; memory 8bit mode
		LDA	#00001000B
		TSB	HD420C
		RTS
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+		afQXN[Zbg		+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
BG2_SCCH_SET	EQU	$
		M16			; memory 16bit mode
		LDA	!BG2SPF
		AND	#00002
		STA	R1
		LDA	!BG2SPH_CT
		STA	CCWORK0		; Zbg
		LDA	!ESCCV2
		STA	R2		;(R2) <-- XN[JE^[u
		LDA	!BG2SPF_ADR
		STA	R3
		LDA	#BANK BG2_SCR_DATA
		STA	R4
		LDA	#HDMABF
		STA	R10
		LDA	!ENSTFG
		AND	#000FFH
		STA	R11		; R11 <- Aj[V Xgbv tO
		LDX	#BANK BG2SCSP
		LDA	#BG2SCSP
		JSL	>CHIPON
;
		LDA	#000D2H*2	;(A) <-- ]oCg
		JSL	>M_DMA_BFST_N
		LWORD	HDMABUF		;]AhX
		LWORD	HDMABF		;]AhX
;
		M8			; memory 8bit mode
		LDA	#00010000B	;H-DMA "ON"
		TSB	!HD420C
		RTS
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+		afRXN[Zbg		+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
BG3_SCCH_SET	EQU	$
		M16			; memory 16bit mode
		LDA	!BG3SPFH
		AND	#00002
		STA	R1
		LDA	!BG3SPH_CT
		STA	CCWORK0		;  Zbg
		LDA	!ESCCV3
		STA	R2		;(R2) <-- XN[JE^[u
		LDA	!BG3SPFH_ADR
		STA	R3
		LDA	#BANK BG3_SCR_DAT_ADR
		STA	R4
		LDA	#HDMABF2
		STA	R10
		LDA	!ENSTFG
		AND	#000FFH
		STA	R11		; R11 <- Aj[V Xgbv tO
		LDX	#BANK BG2SCSP
		LDA	#BG2SCSP
		JSL	>CHIPON
;
		LDA	#000D2H*2	;(A) <-- ]oCg
		JSL	>M_DMA_BFST_N
		LWORD	HDMABUF2	;]AhX
		LWORD	HDMABF2		;]AhX
;
		LDA	>HDMABF2
		STA	!ESCCH3
		STA	<SCCH3
;
		M8			; memory 8bit mode
		LDA	#00001000B
		TSB	HD420C
		RTS
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+		afRcXN[Zbg		+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
BG3_SCCV_SET	EQU	$
		M16			; memory 16bit mode
		LDA	!BG3SPFV
		AND	#00002H
		STA	R1
		LDA	!ESCCV3
		STA	R2
		LDA	!BG3SPV_CT
		STA	R3		;  Zbg
		LDA	!BG3SPFV_ADR
		STA	R7
		LDA	#BANK BG3_SCR_DAT_ADR
		STA	R8
		LDA	#HDMABF
		STA	R10
		LDA	!ENSTFG
		AND	#000FFH
		STA	R11		; R11 <- Aj[V Xgbv tO
		LDX	#BANK BG2VSCSP
		LDA	#BG2VSCSP
		JSL	>CHIPON
;
		LDA	#000D2H*2	;(A) <-- ]oCg
		JSL	>M_DMA_BFST_N
		LWORD	HDMABUF		;]AhX
		LWORD	HDMABF		;]AhX
;
		M8			; memory 8bit mode
		LDA	#00010000B
		TSB	HD420C
		RTS
;
;
;************************************************************************
;*		ItZbg[h^Cve[u				*
;************************************************************************
BG2OFST_TBL	EQU	$-1
		WORD	BGOFST		;[1] n̔g
		WORD	BGOFST_FURA	;[3] htth
		WORD	KUPPA_NAMI	;[5] Nbp hX EF[u
;
;************************************************************************
;*		ItZbg[hihtthj			*
;************************************************************************
FURA_COLOR	EQU	$
		WORD	1402H,2000H,00E0H,00C3H,00A5H,0008H,0804H,1004H
;
BGOFST_FURA	EQU	$
		STZ	MANSEL
		LDA	#00010011B
		STA	SUBSEL
;
		M16
;
		LDA	ENSTFG
		ORA	BIRIBIRI
		ORA	ITEMNO
		BNE	BGOFST_FURA_FFF ;rsnoH ( yes:BGOFST_FURA_FFF )
		LDA	FURA_FG
		BNE	BGOFST_FURA_000 ;htthH ( yes:BGOFST_FURA_000 )
BGOFST_FURA_FFF EQU	$
		LDA	!BG2SPH_CT
		ORA	!BG2SPV_CT
		BNE	FURA_PASS
		STZ	!BG2SPF
		STZ	!BG2SPFV
		LDA	!HD420C
		AND	#0FFE7H
		STA	!HD420C
FURA_PASS	EQU	$
		JMP	BGOFST_FURA_110
;
BGOFST_FURA_000 EQU	$
		DEC	A		;[ CMP #01H ]
		BNE	BGOFST_FURA_050 ;htthIH ( no:BGOFST_FURA_050 )
;
;-------------- htthIZbg ----------------------------------
		LDA	MD2_FURA_CNT
		BEQ	BGOFST_FURA_010 ;~܂H ( yes:BGOFST_FURA_010 )
;
		SEC
		SBC	#0100H
		STA	MD2_FURA_CNT
		BPL	BGOFST_FURA_010
		STZ	MD2_FURA_CNT
BGOFST_FURA_010 EQU	$
		LDA	MD2_FURA_COL
		AND	#00FFH		;̃J[ZbgH
		BEQ	BGOFST_FURA_013 ;	YES -> BGOFST_FURA_013
		JMP	BGOFST_FURA_090 ;	NO --> BGOFST_FURA_090
;
BGOFST_FURA_013 EQU	$
		LDA	>CHNGCOL
		BNE	BGOFST_FURA_020 ;J[ɖ߂H ( no:BGOFST_FURA_020 )
;
		LDA	MD2_FURA_CNT	;htthIH
		BNE	BGOFST_FURA_015 ;	NO -> BGOFST_FURA_019
;
		LDA	#022H		;[]
		JSL	>SOUND_3_ON
;
		STZ	FURA_FG
		STZ	!BG2SPH_CT
		STZ	!BG2SPV_CT
		BRA	BGOFST_FURA_019
;
BGOFST_FURA_015 EQU	$
		AND	#00100H
		BNE	BGOFST_FURA_019
		DEC	!BG2SPH_CT
		BPL	BGOFST_FURA_018
		STZ	!BG2SPH_CT
BGOFST_FURA_018 EQU	$
		DEC	!BG2SPV_CT
		BPL	BGOFST_FURA_019
		STZ	!BG2SPV_CT
BGOFST_FURA_019 EQU	$
		JMP	BGOFST_FURA_100
;
BGOFST_FURA_020 EQU	$
		LDA	#00		;J[ɖ߂
		STA	>CHNGCOL
		BRA	BGOFST_FURA_080
;
;-------------- htth ------------------------------------------
BGOFST_FURA_050 EQU	$
		DEC	FURA_FG
;
		LDA	MD2_FURA_CNT
		CLC
		ADC	#080H
		CMP	#06000H
		BCC	BGOFST_FURA_060
;
		LDA	#06000H
BGOFST_FURA_060 EQU	$
		STA	MD2_FURA_CNT
;
		AND	#00380H
		BNE	BGOFST_FURA_065
		LDA	!BG2SPH_CT
		INC	A
		CMP	#00018H
		BCS	BGOFST_FURA_063
		STA	!BG2SPH_CT
BGOFST_FURA_063 EQU	$
		LDA	!BG2SPV_CT
		INC	A
		CMP	#0000CH
		BCS	BGOFST_FURA_065
		STA	!BG2SPV_CT
BGOFST_FURA_065 EQU	$
		LDA	#00003
		STA	!BG2SPF
		LDA	#00001
		STA	!BG2SPFV
;
;-------------- htthJ[Zbg --------------------------------
BGOFST_FURA_070 EQU	$
		LDA	MD2_FURA_COL
		AND	#00FFH
		BNE	BGOFST_FURA_090 ;̃J[ZbgH ( no:BGOFST_FURA_090 )
;
		LDA	RANDM0
		AND	#07H*2
		TAX
		LDA	!FURA_COLOR,X
		STA	>CHNGCOL
BGOFST_FURA_080 EQU	$
		STZ	MD2_FURA_COL
		LDA	>DATACOL
		STA	>MOTOCOL
;
BGOFST_FURA_090 EQU	$
		LDA	MD2_FURA_COL
		CLC
		ADC	#08H
		STA	MD2_FURA_COL
		STA	R6		;(R6) <-- [tBOJ[{
		LDA	>MOTOCOL
		STA	R1		;(R1) <-- J[
		LDA	>CHNGCOL
		STA	R2		;(R2) <-- J[
		M_CHIP	COL_MORF
;
		LDA	R3
		STA	>DATACOL	;[tBOJ[Zbg
;
;-------------- ItZbgf[^Zbg ----------------------------------
BGOFST_FURA_100 EQU	$
		LDA	MD2_FURA_WAV
		CLC
		ADC	#020H
		STA	MD2_FURA_WAV
;
BGOFST_FURA_110 EQU	$
		LDA	MD2_FURA_CNT
		STA	R1		;(R1) <-- U̕
		LDA	MD2_FURA_WAV
		STA	R2		;(R2) <-- gJE^[
		M_CHIP	BG2OFST_FURA
;
BGOFST_FURA_150 EQU	$
;
		M8
;
		RTS
;
;************************************************************************
;*		BG mode 2 offset set					*
;************************************************************************
BGOFST		EQU	$
;
;-------------- n̔g ------------------------------------------------
;
		M16			; memory 16bit mode
;
		LDA	ENSTFG
		ORA	ITEMNO
		BNE	BGOFST_010	;rsnoH ( yes:BGOFST_010 )
;
		DEC	BG2SPD		;wave speed set
		DEC	BG2SPD
;
BGOFST_010	EQU	$
		LDA	!BG2SPD
		STA	R7
		LDA	<SCCH1
		STA	BG2OFH
		STA	R8
		LDA	<SCCV1
		STA	R9
;
		M_CHIP	YGNSUING
;
		M8			; memory 8bit mode
;
		RTS
;
;************************************************************************
;*		Nbp hX EF[u					*
;************************************************************************
KUPPA_NAMI	EQU	$
		M16			; memory 16bit mode
		INC	!BG2SPD
		LDA	!BG2SPD
		CMP	#00012*8
		BCC	KP_NM_050
		LDA	#00000
		STA	!BG2SPD
KP_NM_050	EQU	$
		LSR	A
		LSR	A
		LSR	A
		STA	R7
		LDA	!PLDSXL
		STA	R9
;
		M_CHIP	KUPPA_DOSUN
;
		M8			; memory 8bit mode
		RTS
;
;
		MEM16
;
;****************************************************************
;*								*
;*	^C}[ PO CjV p[^ Zcg		*
;*								*
;****************************************************************
TIME10_PRMT	EQU	$
		LDA	#100
TIME10_PRMT_050 EQU	$
		LDY	ITEM_WK
		BNE	TIME10_PRMT_100 ;ZbgH ( no:TIME10_PRMT_050 )
;
		CLC
		ADC	!TIMCNT_UP
		STA	!TIMCNT_UP
		CLC
		ADC	#60*2		;nai^C}[\II
		STA	OBJ_TIMER_DISP
		INC	ITEM_WK
		RTS
;
TIME10_PRMT_100 EQU	$
		LDA	TIMCNT_UP
		BNE	TIME10_PRMT_150 ;^C}[IH ( no:TIME10_PRMT_150 )
;
		STZ	ITEMNO
TIME10_PRMT_150 EQU	$
		RTS
;
;****************************************************************
;*								*
;*	^C}[ QO CjV p[^ Zcg		*
;*								*
;****************************************************************
TIME20_PRMT	EQU	$
		LDA	#200
		BRA	TIME10_PRMT_050
;
;****************************************************************
;*								*
;*		ǂłonv p[^ Zcg		*
;*								*
;****************************************************************
POW_PRMT	EQU	$
		JSL	>TO_COIN_CHANGE
;
		LDA	#047H		;[]
		JSL	>SOUND_3_ON
;
		LDA	#0020H
		STA	TILTCT
;
		STZ	ITEMNO
		RTS
;
;****************************************************************
;*								*
;*	߂ CjV p[^ Zcg			*
;*								*
;****************************************************************
GARASU_PRMT	EQU	$
		INC	GRASS_ON
;
		LDA	#04H		;[]
		JSL	>SOUND_3_ON
;
		STZ	ITEMNO
		RTS
;
;****************************************************************
;*								*
;*		ł^}S p[^ Zcg		*
;*								*
;****************************************************************
EGG_PRMT	EQU	$
		LDY	ITEM_WK
		BNE	EGG_PRMT_050	;ZbgH ( no:EGG_PRMT_050 )
;
		LDA	#ITEGG		;(A) <-- GmD
		JSL	>ENINSR		;GGAm
		BCC	EGG_PRMT_050	;      h    H ( no:EGG_PRMT_050 )
;
;-------------- ł^}Sfp^}SZbg ----------------
		TYX
		JSL	>ITEGG_INIT
;
		INC	ITEM_WK
;
EGG_PRMT_050	EQU	$
		RTS
;
;****************************************************************
;*								*
;*		G݂ȃnei_ p[^ Zcg		*
;*								*
;****************************************************************
ALLHTN_PRMT	EQU	$
		LDX	#(ENNO-1)*4
ALLHTN_PRMT_050 EQU	$
		LDA	ENMODE,X
		CMP	#EFAIL
		BCC	ALLHTN_PRMT_100 ;G[hnjH ( no:ALLHTN_PRMT_100 )
		LDA	ENMOD1,X
		AND	#0110000000000000B
		BNE	ALLHTN_PRMT_100 ;GH ( no:ALLHTN_PRMT_100 )
;
		CPX	PONLFFG
		BNE	ALLHTN_PRMT_080

		STZ	PONLFFG

ALLHTN_PRMT_080 EQU	$
		LDA	#ECHNG		;ς郂[hZbg
		STA	ENMODE,X
		LDA	#QKM16		;ςGmDZbg
		STA	EN_SP_WRK0,X
ALLHTN_PRMT_100 EQU	$
		DEX
		DEX
		DEX
		DEX
		BPL	ALLHTN_PRMT_050
;
		LDA	#03BH		;[]
		JSL	>SOUND_3_ON
;
		STZ	ITEMNO
		RTS
;
;****************************************************************
;*								*
;*		XCJ̎ p[^ Zcg			*
;*								*
;****************************************************************
SUIKA_PRMT	EQU	$
		LDA	#3
SUIKA_PRMT_0050 EQU	$
		STA	EATSPF		;XyVVbgtOZbg
		INC	EATFLG
		INC	EATSTP
		LDA	#30*3		;XCJ̎퐔Zbg
		STA	SUIKA_NO
;
		LDA	#014H		;[]
		JSL	>SOUND_3_ON
;
		STZ	ITEMNO
		RTS
;
;****************************************************************
;*								*
;*		X p[^ Zcg				*
;*								*
;****************************************************************
COLD0_PRMT	EQU	$
		LDA	#4
		BRA	SUIKA_PRMT_0050
;
;****************************************************************
;*								*
;*		 p[^ Zcg				*
;*								*
;****************************************************************
FIRE0_PRMT	EQU	$
		LDA	#1
		BRA	SUIKA_PRMT_0050
;
		MEM8
;
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+	ACe obt@ ߂			+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
ITMBF_SFT	EQU	$
		LDA	!ITEMPNT
		CLC
		ADC	!ITMBFPOS
		TAX
		BEQ	ITMBF_SFT_END
		STZ	!ITEMBUF-1,X
		TXY
		DEY
ITMBF_SFT_LOP	EQU	$
		CPX	#027
		BCS	ITMBF_SFT_500
		LDA	!ITEMBUF,X
		AND	#00FH		; ACe 邩 ?
		BEQ	ITMBF_SFT_PAS	;	NO -> ITMBF_SFT_PAS
		STA	!ITEMBUF,Y
		STZ	!ITEMBUF,X
		INY
ITMBF_SFT_PAS	EQU	$
		INX
		BRA	ITMBF_SFT_LOP
;
ITMBF_SFT_500	EQU	$
		LDA	!ITMBFPOS
		BEQ	ITMBF_SFT_PAS_5
		DEC	!ITMBFPOS
		BRA	ITMBF_SFT_END
ITMBF_SFT_PAS_5 EQU	$
		DEC	!ITEMPNT
		BNE	ITMBF_SFT_END
		INC	!ITEMPNT
ITMBF_SFT_END	EQU	$
		RTS
;
;
;****************************************************************
;*								*
;*		ACe ZNg				*
;*								*
;****************************************************************
ITM_INT_SET	EQU	$-2
		WORD	TIME10_INT	; 1 ^C}[ PO
		WORD	TIME20_INT	; 2 ^C}[ QO
		WORD	POW_INT		; 3 ǂłonv
		WORD	EGG_INT		; 4 ł^}S
		WORD	GARASU_INT	; 5 ߂
		WORD	ALLHTN_INT	; 6 G݂ȃnei_
		WORD	SUIKA_INT	; 7 XCJ̎ACe
		WORD	COLD0_INT	; 8 XACe
		WORD	FIRE0_INT	; 9 ΃ACe
;
ITMPTADD	EQU	$-1
		HEX	01,FF,FF
;
ITMPTCMP	EQU	$-1
		HEX	03,FF,FF
;
ITMBFCMP	EQU	$-1
		HEX	1B,FF,FF
;
;
ITMSEL		EQU	$
		LDA	<KEYC2
		AND	#00000011B	; E L[ nm ?
		BEQ	ITMSEL_500	;	NO -> ITMSEL_500
;
;------------------------------- J[\ ړ
		TAX
		LDA	!ITEMPNT
		BNE	ITMSEL_000
		JMP	ITMSEL_900
ITMSEL_000	EQU	$
		DEC	A
		STA	<WORK0		;wrk0 <- J[\ |C^[
		CLC
		ADC	ITMPTADD,X	; J[\ Eǂ炩
		CMP	ITMPTCMP,X	;  ς Ă邩 ?
		BEQ	ITMSEL_005	;	YES -> ITMSEL_005
		INC	A
		STA	!ITEMPNT
		LDA	#05CH
		STA	<SOUND_3	; sound set !!
		BRA	ITMSEL_020
;
ITMSEL_005	EQU	$
		LDA	<WORK0
		CLC
		ADC	!ITMBFPOS
		CLC
		ADC	ITMPTADD,X
		CMP	ITMBFCMP,X	; obt@̃TCYz ?
		BNE	ITMSEL_010	;	YES -> ITMSEL_010
		LDA	!ITMBFPOS
		BRA	ITMSEL_020
;
ITMSEL_010	EQU	$
		LDA	#05CH
		STA	<SOUND_3	; sound set !!
		LDA	!ITMBFPOS
		CLC
		ADC	ITMPTADD,X
		STA	!ITMBFPOS
ITMSEL_020	EQU	$
		LDA	!ITEMPNT
		CLC
		ADC	!ITMBFPOS
		TAX
		CPX	#027
		BCS	ITMSEL_200
		DEX
		LDA	!ITEMBUF,X
		BNE	ITMSEL_200
		DEC	!ITMBFPOS
		BPL	ITMSEL_040
		STZ	!ITMBFPOS
		DEC	!ITEMPNT
		BPL	ITMSEL_040
		STZ	!ITEMPNT
		BRA	ITMSEL_200
ITMSEL_040	EQU	$
		STZ	<SOUND_3
;
ITMSEL_200	EQU	$
		JSR	ITMSEL_SUB	; ITEMDSP Zbg
;
		JSR	ITEM_CORSL
;
		JSR	LTRTARWST	;  Zbg
;
ITMSEL_500	EQU	$
		LDA	!ITEMNO
		BNE	ITMSEL_900
		LDA	<KEYC2L
		AND	#10000000B	; "`" L[ nm ?
		BEQ	ITMSEL_900	;	NO -> ITMSEL_900
		LDA	!ITEM_STOP	; {Xΐ풆 ?
		BNE	ITMSEL_550	;	YES -> ITMSEL_550
		LDA	!ITMBFPOS
		CLC
		ADC	!ITEMPNT
		TAX
		LDA	!ITEMBUF-1,X
		STA	!ITEMNO		;ACem. Zbg!!
		BEQ	ITMSEL_550
		ASL	A
		TAX
;
		M16
;
		JSR	(ITM_INT_SET,X)
;
		M8
;
ITMSEL_550	EQU	$
		LDA	!ITEMNO
		BEQ	ITMSEL_600	;ACeG[H ( yes:ITMSEL_600 )
;
		LDA	#043H		;[]
		STA	<SOUND_3
;
		STZ	!ITEM_WK
		STZ	!ITEM_WK+1
		JMP	ITMBF_SFT
;
;-------------- ACeG[ ----------------------------------
ITMSEL_600	EQU	$
		LDA	#090H		;[]
		STA	<SOUND_3
;
ITMSEL_900	EQU	$
		RTS
;
;
		MEM16
;
;****************************************************************
;*								*
;*	^C}[ PO `FbN					*
;*								*
;****************************************************************
TIME10_INT	EQU	$
;
;****************************************************************
;*								*
;*	^C}[ QO `FbN					*
;*								*
;****************************************************************
TIME20_INT	EQU	$
		LDA	TIMER
		CMP	#300
		BCC	TIME20_INT_0050 ;^C}[l`wH ( no:TIME20_INT_0050 )
;
		STZ	ITEMNO
TIME20_INT_0050 EQU	$
		RTS
;
;****************************************************************
;*								*
;*	߂ `FbN					*
;*								*
;****************************************************************
GARASU_INT	EQU	$
		LDA	GRASS_ON
		BEQ	GARASU_INT_0050 ;ዾgpH ( no:GARASU_INT_0050 )
;
		STZ	ITEMNO
GARASU_INT_0050 EQU	$
		RTS
;
;****************************************************************
;*								*
;*	ǂłonv `FbN					*
;*								*
;****************************************************************
POW_INT		EQU	$
;****************************************************************
;*								*
;*	G݂ȃnei_ `FbN				*
;*								*
;****************************************************************
ALLHTN_INT	EQU	$
		RTS
;
;****************************************************************
;*								*
;*	ł^}S `FbN					*
;*								*
;****************************************************************
EGG_INT		EQU	$
		LDA	PLTYPE
		BNE	EGG_INT_0010	;ϐgH ( yes:EGG_INT_0010 )
		LDA	EGGPNT
		CMP	#6*2
		BCC	EGG_INT_0050	;^}SςH ( no:EGG_INT_0050 )
;
EGG_INT_0010	EQU	$
		STZ	ITEMNO
EGG_INT_0050	EQU	$
		RTS
;
;****************************************************************
;*								*
;*	XCJ̎ `FbN					*
;*								*
;****************************************************************
SUIKA_INT	EQU	$
;****************************************************************
;*								*
;*	X `FbN						*
;*								*
;****************************************************************
COLD0_INT	EQU	$
;****************************************************************
;*								*
;*	 `FbN						*
;*								*
;****************************************************************
FIRE0_INT	EQU	$
		LDA	PLTYPE
		ORA	EATFLG
		ORA	EATSTP
		BEQ	FIRE0_INT_0050	;njH ( no:FIRE0_INT_0050 )
;
		STZ	ITEMNO
		RTS
;
FIRE0_INT_0050	EQU	$
		JSL	>BERO_CANCEL
		RTS
;
		MEM8
;
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+							+
;+		hsdlcro Zbg			+
;+							+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
ITMSEL_SUB	EQU	$
		LDX	#000H
		LDY	!ITMBFPOS
ITMSEL_SUB_LOP	EQU	$
		LDA	!ITEMBUF,Y
		STA	!ITEMDSP,X
		INY
		INX
		CPX	#003
		BCC	ITMSEL_SUB_LOP
		RTS
;
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+							+
;+		E Zbg			+
;+							+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
LT_ARW_DAT	EQU	$
		WORD	009AFH,0499DH
;
RT_ARW_DAT	EQU	$
		WORD	009AFH,0099DH
;
;
LTRTARWST	EQU	$
;
;-------------------------------  `FbN  Zbg
		LDX	#000
		LDA	!ITMBFPOS
		BEQ	LTRTARWST_100
		INX
		INX
LTRTARWST_100	EQU	$
		M16			; memory 16bit mode
		LDA	LT_ARW_DAT,X
		STA	>PAUSE_SCR+(20H*18H+13H)*2
		ORA	#08000H
		STA	>PAUSE_SCR+(20H*19H+13H)*2
		M8			; memory 8bit mode
;
;------------------------------- E `FbN  Zbg
		LDX	#000
		LDA	!ITMBFPOS
		CLC
		ADC	#003
		CMP	#027
		BCS	LTRTARWST_200
		TAY
		LDA	ITEMBUF,Y
		BEQ	LTRTARWST_200
		INX
		INX
LTRTARWST_200	EQU	$
		M16			; memory 16bit mode
		LDA	RT_ARW_DAT,X
		STA	>PAUSE_SCR+(20H*18H+1EH)*2
		ORA	#08000H
		STA	>PAUSE_SCR+(20H*19H+1EH)*2
		M8			; memory 8bit mode
;
		RTS
;
;----------------------------------------------------------------
;-		item screen write set				-
;-			   <WORK0 <-- cursol index		-
;-			      (Y) <-- cursol clear		-
;----------------------------------------------------------------
CRSL_DAT_00	EQU	$
		WORD	01DBBH,01DBCH,01DBCH,01DBEH
		WORD	01DD1H,0417FH,0417FH,01DBFH
		WORD	01DD1H,0417FH,0417FH,01DBFH
		WORD	09DBBH,09DBCH,09DBCH,09DBEH
;
CRSL_DAT_01	EQU	$
		WORD	05DBEH,01DBCH,01DBCH,01DBEH
		WORD	05DBFH,0417FH,0417FH,01DBFH
		WORD	05DBFH,0417FH,0417FH,01DBFH
		WORD	0DDBEH,09DBCH,09DBCH,09DBEH
;
CRSL_DAT_02	EQU	$
		WORD	05DBEH,01DBCH,01DBCH,05DBBH
		WORD	05DBFH,0417FH,0417FH,05DD1H
		WORD	05DBFH,0417FH,0417FH,05DD1H
		WORD	0DDBEH,09DBCH,09DBCH,0DDBBH
;
CRSL_DAT	EQU	$-2
		WORD	CRSL_DAT_00,CRSL_DAT_01,CRSL_DAT_02
;
CRSL_POS	EQU	$-1
		HEX	000,006,00C
;
;
ITEM_CORSL	EQU	$
		M16			; memory 16bit mode
		PHB
		LDX	#BANK PAUSE_SCR
		PHX
		PLB
		JSR	ITEM_WAKU
		PLB
;
		JSR	ITEM_CORSL_SUB
;
		I16			; index 16bit mode
		LDY	#BANK PAUSE_SCR
		STY	<WORK1
		LDY	#03400H+00020H*17H
		LDX	#PAUSE_SCR+(00020H*17H)*2
		LDA	#(00020H*04H)*2
		JSL	>VRAMDX_ST
;
		MI8			; memory ,index 8bit mode
		RTS
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+		J[\ N Zbg		+
;++++++++++++++++++++++++++++++++++++++++++++++++
		MEM16
ITEM_CORSL_SUB	EQU	$
		LDA	!ITEMPNT
		AND	#000FFH
		TAY
		ASL	A
		TAX
		LDA	CRSL_POS,Y
		TAY
		LDA	CRSL_DAT,X
		STA	<WORK0
		CLC
		ADC	#00004*2
		STA	<WORK2
		CLC
		ADC	#00004*2
		STA	<WORK4
		CLC
		ADC	#00004*2
		STA	<WORK6
;
		TYX
		LDY	#000
ITEM_CRSL_050	EQU	$
		LDA	(<WORK0),Y
		STA	>PAUSE_SCR+(20H*17H+14H)*2,X
		LDA	(<WORK2),Y
		STA	>PAUSE_SCR+(20H*18H+14H)*2,X
		LDA	(<WORK4),Y
		STA	>PAUSE_SCR+(20H*19H+14H)*2,X
		LDA	(<WORK6),Y
		STA	>PAUSE_SCR+(20H*1AH+14H)*2,X
		INX
		INX
		INY
		INY
		CPY	#(CRSL_DAT_02-CRSL_DAT_01)/4
		BCC	ITEM_CRSL_050
		RTS
		MEM8
;
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+							+
;+		ACe IuWF Zbg		+
;+							+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
ITMOAM_DAT	EQU	$-2
		WORD	03540H,03542H,03144H,03146H,03148H
		WORD	0314AH,0314CH,0314EH,0334CH
;
;
ITEMOBJST	EQU	$
		M16			; memory 16bit mode
		LDA	#0BFA8H
		STA	<WORK0		; ACe AhX
		LDX	#000H
		TXY
;
ITMEGGOAM_200	EQU	$
		LDA	!ITEMDSP,Y
		AND	#000FFH
		BEQ	ITMEGGOAM_800
		PHY
		ASL	A
		TAY
		LDA	ITMOAM_DAT,Y
		STA	>OAM+82H,X	;ACemn. Zbg
		PLY
		LDA	<WORK0
		STA	>OAM+80H,X	;ACe AhXZbg
		CLC
		ADC	#00018H
		STA	<WORK0		; ̃ACe AhX
		INX
		INX
		INX
		INX
		INY
		CPY	#003
		BCC	ITMEGGOAM_200
;
ITMEGGOAM_800	EQU	$
		LDA	#0AAAAH
		STA	>OAMSUB+8
		M8			; memory 8bit mode
		RTS
;
;
;************************************************************************
;*		massage display						*
;************************************************************************
MSGDSP_WD24	EQU	$
; MSGMOD ->		   [1]	     [3]       [5]	 [7]	   [9]	     [B]       [D]
		BYTE	00000000B,00000010B,00000010B,00001011B,00001011B,00001011B,00000010B
MSGDSP_WD23_25	EQU	$
		BYTE	00000000B,00100010B,00100010B,10001000B,10001000B,10001000B,00100010B
;
MSGDSP_X	EQU	$
		LDA	#01H		;(WK10) <-- ʃEBhEZbg
		STA	<WORK10
		BRA	MSGDSP_000
;
MSGDSP		EQU	$
		STZ	<WORK10		;(WK10) <-- m[}EBhEZbg
;
MSGDSP_000	EQU	$
		PHB			;(DBR) save
		PHK			;(DBR) <-- (PBR)
		PLB
;
		LDX	MSGMOD
;
		LDA	<WORK10
		BNE	MSGDSP_010	;{[iXXe[WH ( yes:MSGDSP_010 )
;
		TXA
		LSR	A
		TAY
		LDA	!MSGDSP_WD24,Y
		STA	WIND24
		LDA	!MSGDSP_WD23_25,Y
		STA	WIND23
		STA	WIND25
;
		LDA	#01H
		STA	PLSTFG		;player stop !!
		STA	ENSTFG		;enemy stop !!
;
MSGDSP_010	EQU	$
		JSR	(!MSGSUB,X)
;
		PLB
		RTL
;
;------------------------------------------------------------------------
;-		massage display mode table				-
;------------------------------------------------------------------------
MSGSUB		EQU	$-1		;[MSGMOD]
		WORD	MSG_INT		;[1] massage display initial set
		WORD	MSG_WON		;[3]	"   window open
		WORD	MSG_SET		;[5]	"   set
		WORD	MSG_WON		;[7]	"   window open
		WORD	MSG_MOV		;[9]	"   move
		WORD	MSG_WOF		;[B]	"   window close
		WORD	MSG_WOF		;[D]	"   window close
;
;------------------------------------------------------------------------
;-		massage display initial set				-
;------------------------------------------------------------------------
MSG_INT		EQU	$
		LDA	#050H
		JSL	>SOUND_3_ON	; sound set !!
		STZ	MSGWK0		;massage work RAM clear
		STZ	MSGWK1
		STZ	MSGWK2
;
;-------------- go to next mode !! --------------------------------------
MSMDINC		EQU	$
		INC	MSGMOD
		INC	MSGMOD
		RTS
;
;------------------------------------------------------------------------
;-		massage window open					-
;------------------------------------------------------------------------
MSG_WON		EQU	$
		LDY	#00		;(Y) <-- window muki [ open ]
		CPX	#03H
		BNE	MSG_WIN		;{[iXXe[W`FbNH ( no:MSG_WIN )
;
		LDA	<WORK10
		BNE	MSG_WOF_010	;{[iXXe[WH ( yes:MSG_WOF_010 )
;
MSG_WIN		EQU	$
		LDX	MSGTYP
		JMP	(MSWSUB,X)
;
;------------------------------------------------------------------------
;-		massage window close					-
;------------------------------------------------------------------------
MSG_WOF		EQU	$
;;;;		    LDY	    #01		    ;(Y) <-- window muki [ close ]
		LDY	#02		;(Y) <-- window muki [ close ]
		CPX	#0DH
		BNE	MSG_WIN		;{[iXXe[W`FbNH ( no:MSG_WIN )
;
		LDA	<WORK10
		BEQ	MSG_WIN		;{[iXXe[WH ( no:MSG_WIN )
;
MSG_WOF_010	EQU	$
;
		M16
;
		LDA	MSGWK0
		STA	R4		;(R4) <-- zoom size
;
		M8
;
		JMP	MSW_POLY_0050
;
;------------------------------------------------------------------------
;-		massage set						-
;------------------------------------------------------------------------
MSG_SET		EQU	$
;
		M16
;
		LDA	#00
		STA	>MSG_RAM	;message mode initial set
;
		M8
;
		JSR	MSG_CALL
		BRA	MSMDINC
;
;------------------------------------------------------------------------
;-		massage move						-
;------------------------------------------------------------------------
MSG_MOV		EQU	$
		JSR	MSG_CALL
;
		LDA	>MSG_RAM
		CMP	#002
		BCC	MSM_010
;
		LDA	#056H
		JSL	>SOUND_3_ON	; sound set !!
;
		JSR	MSMDINC		;go to next mode !!
;
;-------------- message process -----------------------------------------
MSM_010		EQU	$
		RTS
;
;----------------------------------------------------------------
;-		message window type table			-
;----------------------------------------------------------------
MSWSUB		EQU	$
		WORD	MSW_POLY	;polygon window
;;;;		    WORD    MSW_CHNG	    ;change window
;
;----------------------------------------------------------------
;-		polygon window open & close			-
;-			(MSGWK0) : rotation angle		-
;----------------------------------------------------------------
MSWZOMCP	EQU	$
; window muki ->	  0	 2
		WORD	00100H,00000H
MSWZOMAD	EQU	$
		WORD	00010H,0FFF0H
;
MSW_POLY	EQU	$
;
		M16
;
		LDA	MSGWK0
		CLC
		ADC	!MSWZOMAD,Y
		STA	MSGWK0
		STA	R4		;(R4) <-- zoom size
		CMP	!MSWZOMCP,Y
;
		M8
;
		BEQ	MSW_POLY_0050	;window open & close end ? ( yes:MSW_POLY_0050 )
;
;;;;		    LDA	    #00000010B	    ;(A) <-- BG3 window mask
		JMP	MSW_POLY_0350
;
MSW_POLY_0050	EQU	$
;;;;		    TYA
;;;;		    BEQ	    MSW_POLY_0200   ;return to game play ? ( no:MSW_POLY_0200 )
		JSR	MSMDINC		;go to next mode !!
;
		LDA	MSGMOD
		CMP	#0DH+2
		BNE	MSW_POLY_0200	;return to game play ? ( no:MSW_POLY_0200 )
;
;-------------- return to game play !! --------------------------
		STZ	MSGMOD
;
		LDA	<WORK10
		BNE	MSW_POLY_0150	;{[iXXe[WH ( yes:MSW_POLY_0150 )
;
		STZ	WIND23		;window disable
		STZ	WIND24
		STZ	WIND25
		STZ	ENSTFG		;enemy stop cancel !!
;
		LDA	NEXTGOTO
		BEQ	MSW_POLY_0100	;door in ? ( no:MSW_POLY_0100 )
;
		BIT	<KEYC1L
		BVS	MSW_POLY_0150	;"YES" ? ( yes:MSW_POLY_0150 )
;
		STZ	NEXTGOTO
MSW_POLY_0100	EQU	$
		STZ	PLSTFG		;player stop cancel !!
MSW_POLY_0150	EQU	$
		RTS
;
MSW_POLY_0200	EQU	$
		CMP	#0BH+2
		BNE	MSW_POLY_0220	;screen data load ? ( no:MSW_POLY_0220 )
;
;-------------- BG3 screen data load ------------------------------------
;
		MI16
;
		LDA	#0100H		;next window again close set
		STA	MSGWK0
;
		LDY	#(20H*6)*2	;(Y) <-- number of byte
		LDA	MSGSAV
		CLC
		ADC	#20H*6
		CMP	#03800H
		BEQ	MSW_POLY_0205
		BCC	MSW_POLY_0205
		LDA	#03800H
		SBC	!MSGSAV
		ASL	A
		TAY
MSW_POLY_0205	EQU	$
		LDA	!MSGSAV		;(A) <-- VRAM address
		JSR	VRMDXST
;
		MI16			; memory , index 16bit mode
		LDA	!MSGSAV
		CLC
		ADC	#20H*6
		SEC
		SBC	#03800H
		BEQ	MSW_POLY_0208
		BMI	MSW_POLY_0208
		ASL	A
		TAY
		LDA	#03400H
		JSR	VRMDXST
;
MSW_POLY_0208	EQU	$
		MI8			; memory , index 8bit mode
;
MSW_POLY_0210	EQU	$
		JMP	MSW_POLY_0350
;
MSW_POLY_0220	EQU	$
		CMP	#03H+2
		BNE	MSW_POLY_0210	;message screen set ? ( no:MSW_POLY_0210 )

;-------------- massage screen set ------------------------------
;
		MI16
;
		STZ	MSGWK0		;next window again open set
;
;-------------- BG3 screen data save --------------------
		LDY	#(20H*6)*2+2	;(Y) <-- number of byte
		LDA	<SCCV3
		CLC
		ADC	#010H+8		;[ +8:hosei ]
		AND	#01F0H
		ASL	A
		ORA	#3400H		;[ BG3 screen base add ]
		STA	!MSGSAV		;(A) <-- VRAM address
		CLC
		ADC	#20H*6
		CMP	#03800H
		BEQ	MSW_POLY_0230
		BCC	MSW_POLY_0230
		LDA	#03800H
		SBC	!MSGSAV
		ASL	A
		INC	A
		INC	A
		TAY
MSW_POLY_0230	EQU	$
		LDA	!MSGSAV
		ORA	#8000H		;VRAM read set
		JSR	VRMDXST
;
		MI16			; memory , index 16bit mode
		LDA	!MSGSAV
		CLC
		ADC	#20H*6
		SEC
		SBC	#03800H
		BEQ	MSW_POLY_0240
		BMI	MSW_POLY_0240
		ASL	A
		INC	A
		INC	A
		TAY
		LDA	#03400H+08000H
		JSR	VRMDXST
;
MSW_POLY_0240	EQU	$
		MI8			; memory , index 8bit mode
;
;-------------- BG3 massage sccreen write ---------------
		PHB			;(DBR) save
		LDA	#BANK VRAMD
		PHA
		PLB			;(DBR) <-- VRAMD(B)
;
		MI16			; memory , index 16bit mode
		LDA	<SCCH3
		CLC
		ADC	#030H+8		;[ +8:hosei ]
		AND	#01F0H
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		STA	<WORK2
;
		EOR	#0001FH		; Zbg LN^[̌
		INC	A		;
		CMP	#0000AH		;
		BCC	MSW_POLY_0250	;
		LDA	#0000AH		;
MSW_POLY_0250	EQU	$
		STA	<WORK4		;
;
		STZ	<WORK8
		LDA	#2000H|(02H*400H)|200H
		STA	<WORK6		; set chara NO. [ 200H-27FH ]
		LDA	>MSGSAV
		CLC
		ADC	<WORK2
		STA	<WORK2		; VRAM address
		JSR	MSW_NOML
		INC	<WORK8
;
		LDA	<WORK4
		CMP	#0000AH
		BCS	MSW_POLY_0300
		DEC	A
		ASL	A
		CLC
		ADC	#2000H|(02H*400H)|200H
		STA	<WORK6		; set chara NO. [ 200H-27FH ]
		LDA	#0000AH
		SEC
		SBC	<WORK4
		STA	<WORK4
		LDA	<WORK2
		AND	#0FFE0H
		STA	<WORK2		; VRAM address
		JSR	MSW_NOML
;
MSW_POLY_0300	EQU	$
		LDA	#0FFFFH
		STA	VRAMD+2,X	;end code set
;
		MI8
;
		PLB
;
;-------------- window data set ---------------------------------
MSW_POLY_0350	EQU	$
;
		M16
;
		STZ	R1		;(R1) <-- X rotation angle
		STZ	R2		;(R2) <-- Y rotation angle
		STZ	R3		;(R3) <-- Z rotation angle
		LDA	<SCCH3
		AND	#0FH
		CMP	#08H
		BCS	MSW_POLY_0400
		ORA	#010H		;[ +10H ]
MSW_POLY_0400	EQU	$
		EOR	#0FFFFH
		INC	A
		CLC
		ADC	#090H
		STA	R5		;(R5) <-- center X pos
		LDA	<SCCV3
		AND	#0FH
		CMP	#08H
		BCS	MSW_POLY_0450
		ORA	#010H		;[ +10H ]
MSW_POLY_0450	EQU	$
		EOR	#0FFFFH
		INC	A
		CLC
		ADC	#050H-1-8
		STA	R6		;(R6) <-- center Y pos
;
		LDA	#MSWINPOLY
		LDX	<WORK10
		BEQ	MSW_POLY_0455	;{[iXXe[WH ( no:MSW_POLY_0455 )
;
		LDA	#WINDPOLY
MSW_POLY_0455	EQU	$
		LDX	#BANK MSWINPOLY
		JSL	>CHIPON
;
		M8
;
		LDA	<WORK10
		BNE	MSW_POLY_0460	;{[iXXe[WH ( yes:MSW_POLY_0460 )
;
		JSL	>M_DMA_BFST
		LWORD	WINDBUF		;]AhX
		LWORD	WINDBF		;]AhX
		WORD	(0D2H*4)	;]oCg
;
;-------------- window PPU set ----------------------------------
		LDA	MANSEL
		STA	WMANSL
		LDA	SUBSEL
		STA	WSUBSL
		LDA	#00110000B	;window logic set
		STA	WLOGIC
		STZ	212BH
		LDA	#00100000B
		TSB	HD420C		;H-DMA "ON" !!
;
MSW_POLY_0460	EQU	$
		RTS
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+		bZ[WZbg			+
;+			in				+
;+			wrk0,1 <- VRAMDZbg count	+
;+			   2,3 <- VRAM address		+
;+			   4,5 <- 			+
;+			   6,7 <- set chara NO.		+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
		MEM16
		IDX16
MSW_NOML	EQU	$
		LDA	#006
		STA	<WORK		;(WK0,1) <-- V loop no.
		LDX	!VRAMD		;(X) <-- VRAMD set pointer
		LDA	<WORK2
MSW_NOML_000	EQU	$
		STA	!VRAMD+2,X	;VRAM address set
		PHA			;(A) save
		LDA	<WORK4
		ASL	A
		DEC	A
		STA	!VRAMD+4,X	;number of byte set
;
		LDA	<WORK0
		DEC	A
		BEQ	MSW_NOML_025
		CMP	#00005H
		BCS	MSW_NOML_025
MSW_NOML_020	EQU	$
		JSR	MSW_NOML_100	;Zbg
		LDA	<WORK6
		CLC
		ADC	#20H
		STA	<WORK6
		BRA	MSW_NOML_040
MSW_NOML_025	EQU	$
		JSR	MSW_NOML_200	;㉺NZbg
;
MSW_NOML_040	EQU	$
;
		TXA
		CLC
		ADC	#4
		TAX
;
		PLA			;(A) load
		CLC
		ADC	#20H		;VRAM address up !
		AND	#0F7FFH
		ORA	#00400H
		DEC	<WORK
		BNE	MSW_NOML_000
		STX	!VRAMD		;next pointer set
		RTS
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+		Zbg			+
;++++++++++++++++++++++++++++++++++++++++++++++++
MSW_NOML_100	EQU	$
		LDY	<WORK4		; Zbg
		LDA	<WORK8
		BNE	MSW_NOML_110
		LDA	#02DC3H		;N
		STA	!VRAMD+6,X
		INX
		INX
		DEY
		BEQ	MSW_NOML_150
;
MSW_NOML_110	EQU	$
		LDA	<WORK6
MSW_NOML_115	EQU	$
		STA	!VRAMD+6,X
		INC	A		;set chara no. up !
		INC	A		;
		INX
		INX
		DEY
		BNE	MSW_NOML_115
;
		LDA	<WORK8
		BNE	MSW_NOML_125
		LDA	<WORK4
		CMP	#0000AH
		BCC	MSW_NOML_150
MSW_NOML_125	EQU	$
		LDA	#06DC3H		;EN
		STA	!VRAMD+4,X
MSW_NOML_150	EQU	$
		RTS
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+		㉺NZbg			+
;++++++++++++++++++++++++++++++++++++++++++++++++
MSW_NOML_200	EQU	$
		LDY	<WORK4		; Zbg
		LDA	<WORK8
		BNE	MSW_NOML_210
		LDA	<WORK0
		DEC	A		; ̃N ?
		BNE	MSW_NOML_205	;	YES -> MSW_NOML_205
		LDA	#0ADC0H
		BRA	MSW_NOML_208
MSW_NOML_205	EQU	$
		LDA	#02DC0H
MSW_NOML_208	EQU	$
		STA	!VRAMD+6,X
		INX
		INX
		DEY
		BEQ	MSW_NOML_250
;
MSW_NOML_210	EQU	$
		LDA	<WORK0
		DEC	A		; ̃N ?
		BNE	MSW_NOML_215	;	YES -> MSW_NOML_215
		LDA	#0ADC1H
		BRA	MSW_NOML_218
MSW_NOML_215	EQU	$
		LDA	#02DC1H
MSW_NOML_218	EQU	$
		STA	!VRAMD+6,X
		INX
		INX
		DEY
		BNE	MSW_NOML_218
;
		LDA	<WORK8
		BNE	MSW_NOML_225
		LDA	<WORK4
		CMP	#0000AH
		BCC	MSW_NOML_250
MSW_NOML_225	EQU	$
		LDA	#06DC0H
		LDY	<WORK0
		DEY
		BNE	MSW_NOML_228
		LDA	#0EDC0H
MSW_NOML_228	EQU	$
		STA	!VRAMD+4,X
MSW_NOML_250	EQU	$
		RTS
		MEM8
		IDX8
;
;;;;;----------------------------------------------------------------
;;;;;-		    change window open & close			    -
;;;;;-			    (MSGWK0) : change size		    -
;;;;;----------------------------------------------------------------
;;;;MSW_CHNG_DT_0   EQU	    $
;;;;		    HEX	    01
;;;;		    HEX	    3F,00, 00,C0
;;;;;
;;;;MSW_CHNG_DT_1   EQU	    $
;;;;		    HEX	    40
;;;;		    HEX	    3F,00, 00,C0, 3F,00, 00,C0, 3F,00, 00,C0, 3F,00, 00,C0
;;;;		    HEX	    3F,00, 00,C0, 3F,00, 00,C0, 3F,00, 00,C0, 3F,00, 00,C0
;;;;		    HEX	    3F,00, 00,C0, 3F,00, 00,C0, 3F,00, 00,C0, 3F,00, 00,C0
;;;;		    HEX	    3F,00, 00,C0, 3F,00, 00,C0, 3F,00, 00,C0, 3F,00, 00,C0
;;;;		    HEX	    3F,00, 00,C0, 3F,00, 00,C0, 3F,00, 00,C0, 3F,00, 00,C0
;;;;		    HEX	    3F,00, 00,C0, 3F,00, 00,C0, 3F,00, 00,C0, 3F,00, 00,C0
;;;;		    HEX	    3F,00, 00,C0, 3F,00, 00,C0, 3F,00, 00,C0, 3F,00, 00,C0
;;;;		    HEX	    3F,00, 00,C0, 3F,00, 00,C0, 3F,00, 00,C0, 3F,00, 00,C0
;;;;		    HEX	    3F,00, 00,C0, 3F,00, 00,C0, 3F,00, 00,C0, 3F,00, 00,C0
;;;;		    HEX	    3F,00, 00,C0, 3F,00, 00,C0, 3F,00, 00,C0, 3F,00, 00,C0
;;;;		    HEX	    3F,00, 00,C0, 3F,00, 00,C0, 3F,00, 00,C0, 3F,00, 00,C0
;;;;		    HEX	    3F,00, 00,C0, 3F,00, 00,C0, 3F,00, 00,C0, 3F,00, 00,C0
;;;;		    HEX	    3F,00, 00,C0, 3F,00, 00,C0, 3F,00, 00,C0, 3F,00, 00,C0
;;;;		    HEX	    3F,00, 00,C0, 3F,00, 00,C0, 3F,00, 00,C0, 3F,00, 00,C0
;;;;		    HEX	    3F,00, 00,C0, 3F,00, 00,C0, 3F,00, 00,C0, 3F,00, 00,C0
;;;;		    HEX	    3F,00, 00,C0, 3F,00, 00,C0, 3F,00, 00,C0, 3F,00, 00,C0
;;;;;
;;;;MSWCHGCP	    EQU	    $
;;;;; window muki ->	       0     2
;;;;		    WORD    00100H,00000H
;;;;MSWCHGAD	    EQU	    $
;;;;		    WORD    00008H,0FFF8H
;;;;;
;;;;MSW_CHNG	    EQU	    $
;;;;;
;;;;		    M16
;;;;;
;;;;		    LDA	    MSGWK0
;;;;		    CLC
;;;;		    ADC	    !MSWCHGAD,Y
;;;;		    STA	    MSGWK0
;;;;		    CMP	    !MSWCHGCP,Y
;;;;;
;;;;		    M8
;;;;;
;;;;		    BEQ	    MSW_CHNG_0050   ;window open & close end ? ( yes:MSW_CHNG_0050 )
;;;;;
;;;;		    LDA	    #00001010B	    ;(A) <-- BG3 window mask
;;;;		    JMP	    MSW_CHNG_0350
;;;;;
;;;;MSW_CHNG_0050   EQU	    $
;;;;		    TYA
;;;;		    BEQ	    MSW_CHNG_0200   ;return to game play ? ( no:MSW_CHNG_0200 )
;;;;;
;;;;;-------------- return to game play !! --------------------------
;;;;		    STZ	    MSGMOD
;;;;		    STZ	    WIND23	    ;window disable
;;;;		    STZ	    WIND24
;;;;		    STZ	    WIND25
;;;;		    STZ	    ENSTFG	    ;enemy stop cancel !!
;;;;;
;;;;		    LDA	    NEXTGOTO
;;;;		    BEQ	    MSW_CHNG_0100   ;door in ? ( no:MSW_CHNG_0100 )
;;;;;
;;;;		    BIT	    <KEYC1L
;;;;		    BVS	    MSW_CHNG_0150   ;"YES" ? ( yes:MSW_CHNG_0150 )
;;;;;
;;;;		    STZ	    NEXTGOTO
;;;;MSW_CHNG_0100   EQU	    $
;;;;		    STZ	    PLSTFG	    ;player stop cancel !!
;;;;MSW_CHNG_0150   EQU	    $
;;;;		    RTS
;;;;;
;;;;;-------------- massage set -------------------------------------
;;;;MSW_CHNG_0200   EQU	    $
;;;;		    JSR	    MSMDINC	    ;go to next mode !!
;;;;;
;;;;;-------------- BG3 screen data save --------------------
;;;;;
;;;;		    MI16
;;;;;
;;;;		    LDA	    <SCCV3
;;;;		    CLC
;;;;		    ADC	    #030H+8	    ;[ +8:hosei ]
;;;;		    AND	    #01F0H
;;;;		    ASL	    A
;;;;		    ORA	    #03400H	    ;[ BG3 screen base add ]
;;;;		    STA	    MSGSAV	    ;(A) <-- VRAM address
;;;;		    ORA	    #8000H	    ;VRAM read set
;;;;		    LDY	    #(20H*4)*2+2    ;(Y) <-- number of byte
;;;;		    JSR	    VRMDXST
;;;;;
;;;;		    MEM8
;;;;		    IDX8
;;;;;
;;;;;-------------- BG3 massage sccreen write ---------------
;;;;		    PHB			    ;(DBR) save
;;;;		    LDA	    #BANK VRAMD
;;;;		    PHA
;;;;		    PLB			    ;(DBR) <-- VRAMD(B)
;;;;;
;;;;		    MI16
;;;;		    LDA	    <SCCH3
;;;;		    CLC
;;;;		    ADC	    #040H+8	    ;[ +8:hosei ]
;;;;		    AND	    #01F0H
;;;;		    LSR	    A
;;;;		    LSR	    A
;;;;		    LSR	    A
;;;;		    LSR	    A
;;;;		    STA	    <WORK2
;;;;;
;;;;		    EOR	    #0001FH	    ; Zbg LN^[̌
;;;;		    INC	    A		    ;
;;;;		    CMP	    #00008H	    ;
;;;;		    BCC	    MSW_CHNG_0250   ;
;;;;		    LDA	    #00008H	    ;
;;;;MSW_CHNG_0250   EQU	    $
;;;;		    STA	    <WORK4	    ;
;;;;;
;;;;		    LDA	    #2000H|(06H*400H)|200H
;;;;		    STA	    <WORK6	    ; set chara NO. [ 200H-27FH ]
;;;;		    LDA	    MSGSAV
;;;;		    CLC
;;;;		    ADC	    <WORK2
;;;;		    STA	    <WORK2	    ; VRAM address
;;;;		    JSR	    MSW_NOML
;;;;;
;;;;		    LDA	    <WORK4
;;;;		    CMP	    #00008H
;;;;		    BCS	    MSW_CHNG_0300
;;;;		    PHA
;;;;		    ASL	    A
;;;;		    CLC
;;;;		    ADC	    #2000H|(06H*400H)|200H
;;;;		    STA	    <WORK6	    ; set chara NO. [ 200H-27FH ]
;;;;		    PLA
;;;;		    EOR	    #00007H
;;;;		    INC	    A
;;;;		    STA	    <WORK4
;;;;		    LDA	    <WORK2
;;;;		    AND	    #0FFE0H
;;;;		    STA	    <WORK2	    ; VRAM address
;;;;		    JSR	    MSW_NOML
;;;;;
;;;;MSW_CHNG_0300   EQU	    $
;;;;		    LDA	    #0FFFFH
;;;;		    STA	    VRAMD+2,X	    ;end code set
;;;;;
;;;;		    MI8
;;;;;
;;;;		    PLB
;;;;;
;;;;;-------------- message display initial set ---------------------
;;;;;
;;;;		    M16
;;;;;
;;;;		    LDA	    #00
;;;;		    STA	    >MSG_RAM	    ;message mode initial set
;;;;;
;;;;		    M8
;;;;;
;;;;		    JSR	    MSG_CALL
;;;;;
;;;;		    LDA	    #00000000B	    ;(A) <-- BG3 window mask
;;;;;-------------- window data set ---------------------------------
;;;;MSW_CHNG_0350   EQU	    $
;;;;		    STA	    WIND24
;;;;		    LDA	    #10101010B	    ;window mask set
;;;;		    STA	    WIND23
;;;;		    STA	    WIND25
;;;;;
;;;;		    M16
;;;;;
;;;;		    LDA	    #BANK MSW_CHNG_DT_0
;;;;		    STA	    R0		    ;(R0) <-- chnage data bank
;;;;		    LDA	    #MSW_CHNG_DT_0
;;;;		    STA	    R1		    ;(R1) <-- from change data
;;;;		    LDA	    #MSW_CHNG_DT_1
;;;;		    STA	    R2		    ;(R2) <-- to	"
;;;;		    LDA	    MSGWK0
;;;;		    STA	    R3		    ;(R3) <-- change size
;;;;		    LDA	    <SCCH3
;;;;		    AND	    #0FH
;;;;		    CMP	    #08H
;;;;		    BCS	    MSW_CHNG_0400
;;;;		    ORA	    #010H	    [ +10H ]
;;;;MSW_CHNG_0400   EQU	    $
;;;;		    EOR	    #0FFFFH
;;;;		    INC	    A
;;;;		    CLC
;;;;		    ADC	    #090H
;;;;		    STA	    R8		    ;(R8) <-- center X pos
;;;;		    LDA	    <SCCV3
;;;;		    AND	    #0FH
;;;;		    CMP	    #08H
;;;;		    BCS	    MSW_CHNG_0450
;;;;		    ORA	    #010H	    [ +10H ]
;;;;MSW_CHNG_0450   EQU	    $
;;;;		    EOR	    #0FFFFH
;;;;		    INC	    A
;;;;		    CLC
;;;;;;;;		ADC	#(060H-1)
;;;;		    ADC	    #077H
;;;;		    STA	    R9		    ;(R9) <-- center Y pos
;;;;		    M_CHIP  CHANGE
;;;;;
;;;;		    JSL	    >M_DMA_BFST
;;;;		    LWORD   WINDBUF	    ;]AhX
;;;;		    LWORD   WINDBF	    ;]AhX
;;;;		    WORD    (0D2H*4)	    ;]oCg
;;;;;
;;;;		    M8
;;;;;
;;;;;-------------- window PPU set ----------------------------------
;;;;		    LDA	    MANSEL
;;;;		    STA	    WMANSL
;;;;		    LDA	    SUBSEL
;;;;		    STA	    WSUBSL
;;;;		    LDA	    #00100000B	    ;window logic set
;;;;		    STA	    212AH
;;;;		    STZ	    212BH
;;;;		    LDA	    #00100000B
;;;;		    TSB	    HD420C	    ;H-DMA "ON" !!
;;;;		    RTS
;;;;;
;;;;;
;;;;;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;;;;;+		bZ[WZbg			+
;;;;;+			in				+
;;;;;+			wrk0,1 <- VRAMDZbg count	+
;;;;;+			   2,3 <- VRAM address		+
;;;;;+			   4,5 <- 			+
;;;;;+			   6,7 <- set chara NO.		+
;;;;;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;;;;		MEM16
;;;;		IDX16
;;;;MSW_NOML	EQU	$
;;;;		LDA	#4
;;;;		STA	<WORK		;(WK0,1) <-- V loop no.
;;;;		STZ	<WORK8
;;;;		LDX	!VRAMD		;(X) <-- VRAMD set pointer
;;;;		LDA	<WORK2
;;;;MSW_NOML_000	EQU	$
;;;;		STA	VRAMD+2,X	;VRAM address set
;;;;		PHA			;(A) save
;;;;		LDA	<WORK4
;;;;		ASL	A
;;;;		DEC	A
;;;;		STA	VRAMD+4,X	;number of byte set
;;;;;
;;;;		LDA	<WORK6
;;;;		LDY	<WORK4		; Zbg
;;;;MSW_NOML_010	EQU	$
;;;;		STA	VRAMD+6,X
;;;;		INC	A		;set chara no. up !
;;;;		INC	A		;
;;;;		INX
;;;;		INX
;;;;		DEY
;;;;		BNE	MSW_NOML_010
;;;;;
;;;;		LDA	<WORK6
;;;;		CLC
;;;;		ADC	#20H
;;;;		STA	<WORK6
;;;;;
;;;;		INC	<WORK8
;;;;		TXA
;;;;		CLC
;;;;		ADC	#4
;;;;		TAX
;;;;;
;;;;		PLA			;(A) load
;;;;		CLC
;;;;		ADC	#20H		;VRAM address up !
;;;;		DEC	<WORK
;;;;		BNE	MSW_NOML_000
;;;;		STX	!VRAMD		;next pointer set
;;;;		RTS
;;;;		MEM8
;;;;		IDX8
;
;
;------------------------------------------------------------------------
;-		message program call					-
;------------------------------------------------------------------------
;
		MEM8
		IDX8
;
MSG_CALL	EQU	$
		LDA	CIPSCB		;M-chip screen base address save
		PHA
		LDA	CIPSCR		;M-chip status data save
		PHA
;
		LDA	#(MSGBITMP&0FC00H)/400H
		STA	CIPSCB		;message screen base addrees set
		LDA	#00111100B
		STA	CIPSCR		;message status data save
;
		MI16			; memory , index 16bit mode
		LDA	>MSG_NO
		ASL	A
		TAX
		LDA	>MSG_DOCA,X
		STA	>MSG_ADR
		LDA	#BANK MSG_DOCA
		STA	>MSG_BNK
		LDA	!PLCONT
		STA	>MSG_PLCT
		I8			; index 8bit mode
;
;;;;K;;;;		LDA	KEYA1L		;key data set
;;;;K;;;;		ORA	KEYB1L
;;;;K;;;;		STA	>MSG_RAM+6
;;;;K;;;;		LDA	KEYA2L
;;;;K;;;;		ORA	KEYB2L
;;;;K;;;;		STA	>MSG_RAM+8
;
		LDA	#0000
		STA	>MSG_RAM+6
		STA	>MSG_RAM+8
		LDA	!MSG_LOCK
		BNE	MSG_CALL_050
;
		LDA	KEYA1L		;key data set
		AND	#00F80H		;
		STA	>MSG_RAM+6	; "`" or "{"L[nm ?
		LDA	KEYA2L		;
		AND	#00F80H		;
		STA	>MSG_RAM+8	;
;
MSG_CALL_050	EQU	$
		M_CHIP	MSG_CORE
;
		M8
;
		PLA
		STA	CIPSCR
		PLA
		STA	CIPSCB
;
		LDA	!MSOUND3
		BEQ	MSG_CALL_060
		JSL	>SOUND_3_ON
;
MSG_CALL_060	EQU	$
		INC	MSGTRF		;massage bitmap transfer "ON"
;
		JSR	NXTMARK
;
		RTS
;
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+							+
;+		L[͑҂ J[\_		+
;+							+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
NXTMARK		EQU	$
		PHB
		LDA	#BANK VRAMD
		PHA
		PLB
		MI16			; memory , index 16bit mode
;
		LDX	!VRAMD
;
		LDA	<SCCV3
		CLC
		ADC	#00060H+8
		AND	#001F0H
		ASL	A
		ORA	#03400H
		STA	<WORK0
;
		LDA	<SCCH3
		CLC
		ADC	#000B0H+8	;[ +8:hosei ]
		AND	#001F0H
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		ADC	<WORK0
		STA	!VRAMD+2,X	; AhX
;
		LDA	#00001H
		STA	!VRAMD+4,X	; 
;
		LDA	>MSG_RAM+5
		AND	#000FFH
		CMP	#0000FH		; f[^Ił̃L[͑҂ ?
		BEQ	NXTMARK_050	;	YES -> NXTMARK_050
		CMP	#00051H		; J[\㉺I
		BEQ	NXTMARK_050	;	YES -> NXTMARK_050
		CMP	#000FFH		; f[^I ?
		BEQ	NXTMARK_050	;	YES -> NXTMARK_050
		LDA	>MSG_RAM
		CMP	#002
		BCS	NXTMARK_050
		LDA	<FRCNT
		AND	#00010H
		BEQ	NXTMARK_060
NXTMARK_050	EQU	$
		LDA	#0ADC1H
		BRA	NXTMARK_070
NXTMARK_060	EQU	$
		LDA	#02DC5H
NXTMARK_070	EQU	$
		STA	!VRAMD+6,X	; LN^[
;
		LDA	#0FFFFH
		STA	!VRAMD+8,X
		TXA
		CLC
		ADC	#00006
		STA	!VRAMD
;
		MI8			; memory , index 8bit mode
		PLB
		RTS
;
;
;****************************************************************
;*								*
;*		{XNÃXRAZ			*
;*								*
;****************************************************************
BOSCLR_SCORE	EQU	$
		LDX	!GOAL_IN
		JSR	(BOSCLR_SCRE_ADR,X)
;
		LDA	!GOAL_IN
		CMP	#BS_SRE_CHK+2
		BCC	BOSCLR_SCRE_50
		LDA	#SCRE_STT
		STA	!GOAL_IN
		LDA	#GMPL+1
		STA	!MODENO
BOSCLR_SCRE_50	EQU	$
;
;-------------- Q[ʃZbg --------------------------------
		LDA	!GOAL_IN
		CMP	#BS_SRE_GM
		BCS	BOSCLR_SCRE_90
		JSL	>GMPLAY2	;game play ( display )
;
BOSCLR_SCRE_90	EQU	$
		PLB
		RTL
;
;
BOSCLR_SCRE_ADR EQU	$
		WORD	BSCR_SCRE_000	;v`hs^C}[ CjVZbg
		WORD	BSCR_SCRE_100	;v`hs^C}[
		WORD	BSCR_SCRE_200	;EBhDX^[g!!
		WORD	BSCR_SCRE_300	;EBhD bkntrd
BOSCLR_SCRE_GM	WORD	GMGOAL_B1CLS	;ʃNA[ BG1
		WORD	GMGOAL_B3CLS	;ʃNA[ BG3
		WORD	GMGOAL_CLI0	;ZʏZbg|P
		WORD	GMGOAL_CLI1	;	h	   |Q
		WORD	GMGOAL_CLI2	;	h	   |R
		WORD	BSCR_SCRE_100	;v`hs^C}[
BOSCLR_SCRE_CHK WORD	BSCR_SCRE_400	;EBhDX^[g!!
;
BS_SRE_CHK	EQU	(BOSCLR_SCRE_CHK-BOSCLR_SCRE_ADR)
BS_SRE_GM	EQU	(BOSCLR_SCRE_GM-BOSCLR_SCRE_ADR)
;
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+								+
;+		v`hs^C}[ CjVZbg		+
;+								+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
BSCR_SCRE_000	EQU	$
		MI16			; memory , index 16bit mode
		LDA	!DSPMOD
		CMP	#00009		; [hV ?
		BEQ	BSCR_SCRE_010	;	YES -> BSCR_SCRE_010
;
		LDA	>DATACOL	;kLJ[ւ
		STA	NUKCOL
		LDA	#00
		STA	>DATACOL
;
GMGOAL_000	EQU	$		; S[f R[p
		MI16			; memory , index 16bit mode
BSCR_SCRE_010	EQU	$
		LDX	#00000H
		LDA	#0FF00H
BSCR_SCRE_050	EQU	$
		STA	>WINDBF,X
		INX
		INX
		INX
		INX
		CPX	#000D2H*4
		BCC	BSCR_SCRE_050
		MI8			; memory , index 8bit mode
;
;;;;		    JSL	    >M_DMA_BFST
;;;;		    LWORD   WINDBUF	    ;]AhX
;;;;		    LWORD   WINDBF	    ;]AhX
;;;;		    WORD    (0D2H*4)	    ;]oCg
;
		INC	!GOAL_IN
		INC	!GOAL_IN
		STZ	!BSCLR_WITIM
		RTS
;
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+								+
;+		v`hs^C}[				+
;+								+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
BSCR_SCRE_1_DT0 EQU	$
		WORD	01F1FH,00104H
;
BSCR_SCRE_1_DT1 EQU	$
		WORD	00000H,0018CH
;
BSCR_SCRE_1_DT2 EQU	$
		WORD	00350H,0018CH
;
BSCR_SCRE_1_DT3 EQU	$
		WORD	0FF00H,09F60H
;
;
BSCR_SCRE_100	EQU	$
		INC	!BSCLR_WITIM
		LDA	!BSCLR_WITIM
		CMP	#010
		BCC	BSCR_SCRE_150
;
		INC	!GOAL_IN
		INC	!GOAL_IN
		M16			; memory 16bit mode
		STZ	!BSCLR_WITIM
		LDX	!GMFADE_MK
		LDA	BSCR_SCRE_1_DT0,X
		STA	!WMANSL
		LDA	BSCR_SCRE_1_DT1,X
		STA	!BSCLR_WDYSTT
		LDA	BSCR_SCRE_1_DT2,X
		STA	!BSCLR_WDYEND
		LDA	BSCR_SCRE_1_DT3,X
		STA	!BSCLR_WDSIZE
		M8			; memory 8bit mode
		LDA	#033H
		STA	!WIND23
		STA	!WIND24
		STA	!WIND25
		LDA	#022H
		STA	!WIND30
		LDA	#020H
		STA	!HD420C
		RTS
;
BSCR_SCRE_150	EQU	$
		DEC	A
		BNE	BSCR_SCRE_160
;
		JSL	>M_DMA_BFST
		LWORD	WINDBUF		;]AhX
		LWORD	WINDBF		;]AhX
		WORD	0D2H		;]oCg
		RTS
;
BSCR_SCRE_160	EQU	$
		DEC	A
		BNE	BSCR_SCRE_170
;
		JSL	>M_DMA_BFST
		LWORD	WINDBUF+0D2H	;]AhX
		LWORD	WINDBF+0D2H	;]AhX
		WORD	0D2H		;]oCg
		RTS
;
BSCR_SCRE_170	EQU	$
		DEC	A
		BNE	BSCR_SCRE_180
;
		JSL	>M_DMA_BFST
		LWORD	WINDBUF+0D2H*2	;]AhX
		LWORD	WINDBF+0D2H*2	;]AhX
		WORD	0D2H		;]oCg
		RTS
;
BSCR_SCRE_180	EQU	$
		DEC	A
		BNE	BSCR_SCRE_190
;
		JSL	>M_DMA_BFST
		LWORD	WINDBUF+0D2H*3	;]AhX
		LWORD	WINDBF+0D2H*3	;]AhX
		WORD	0D2H		;]oCg
;
BSCR_SCRE_190	EQU	$
		RTS
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+								+
;+		EBhDX^[g!!				+
;+					(ʏ)		+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
BSCR_SCRE_200	EQU	$
		JSR	BSCR_WND_ST
		M16			; memory 16bit mode
		LDA	!BSCLR_WDYEND
		SEC
		SBC	!BSCLR_WDYSTT
		CMP	#00008H
		BCS	BSCR_SCRE_290
		INC	!GMFADE_MK
		INC	!GMFADE_MK
		INC	!GOAL_IN
		INC	!GOAL_IN
		JSL	>ENRAMCLR
		JSL	>OAMDXCLR
		M8			; memory 8bit mode
		LDA	#020H
		STA	!HD420C
BSCR_SCRE_290	EQU	$
		M8			; memory 8bit mode
		RTS
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+							+
;+		EBhD f[^ Zbg		+
;+							+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
BSCR_WND_DAT0	EQU	$
		WORD	00002H*4,0FFFEH*4
;
BSCR_WND_DAT1	EQU	$
		WORD	00002H,0FFFEH
;
;
BSCR_WND_ST	EQU	$
		MI16			; memory , index 16bit mode
		LDA	!GMFADE_MK
		AND	#00002
		TAY
		LDX	#000H
		LDA	#000FFH
BSCR_WND_ST_10	EQU	$
		CPX	!BSCLR_WDYSTT
		BCS	BSCR_WND_ST_20
		STA	>WINDBF,X
		INX
		INX
		INX
		INX
		BRA	BSCR_WND_ST_10
;
BSCR_WND_ST_20	EQU	$
		LDA	!BSCLR_WDSIZE
BSCR_WND_ST_25	EQU	$
		CPX	!BSCLR_WDYEND
		BCS	BSCR_WND_ST_30
		STA	>WINDBF,X
		INX
		INX
		INX
		INX
		BRA	BSCR_WND_ST_25
;
BSCR_WND_ST_30	EQU	$
		LDA	#000FFH
BSCR_WND_ST_35	EQU	$
		CPX	#000D2H*4
		BCS	BSCR_WND_ST_40
		STA	>WINDBF,X
		INX
		INX
		INX
		INX
		BRA	BSCR_WND_ST_35
;
BSCR_WND_ST_40	EQU	$
		LDA	#0FF00H
BSCR_WND_ST_45	EQU	$
		CPX	#000D2H*4
		BCS	BSCR_WND_ST_50
		STA	>WINDBF,X
		INX
		INX
		INX
		INX
		BRA	BSCR_WND_ST_45
;
BSCR_WND_ST_50	EQU	$
		LDA	!BSCLR_WDYSTT
		CLC
		ADC	BSCR_WND_DAT0,Y
		STA	!BSCLR_WDYSTT
		LDA	!BSCLR_WDYEND
		SEC
		SBC	BSCR_WND_DAT0,Y
		STA	!BSCLR_WDYEND
;
		MI8			; memory , index 8bit mode
		LDA	!BSCLR_WDSIZE
		CLC
		ADC	BSCR_WND_DAT1,Y
		STA	!BSCLR_WDSIZE
		LDA	!BSCLR_WDSIZE+1
		SEC
		SBC	BSCR_WND_DAT1,Y
		STA	!BSCLR_WDSIZE+1
;
		JSL	>M_DMA_BFST
		LWORD	WINDBUF		;]AhX
		LWORD	WINDBF		;]AhX
		WORD	(0D2H*4)	;]oCg
;
		LDA	!HD420C
		ORA	#020H
		STA	!HD420C
;
		RTS
;
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+								+
;+		EBhD bkntrd				+
;+								+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
BSCR_SCRE_300	EQU	$
		MI16			; memory , index 16bit mode
		LDX	#00000H
		LDA	#000FFH
BSCR_SCRE_350	EQU	$
		STA	>WINDBF,X
		INX
		INX
		INX
		INX
		CPX	#000D2H*4
		BCC	BSCR_SCRE_350
		MI8			; memory , index 8bit mode
;
		JSL	>M_DMA_BFST
		LWORD	WINDBUF		;]AhX
		LWORD	WINDBF		;]AhX
		WORD	(0D2H*4)	;]oCg
;
		LDA	#009
		STA	!BGMODE
		LDA	#069H
		STA	!BG1SCF
		LDA	#034H
		STA	!BG3SCF
		LDA	#002H
		STA	!NMITYP
		LDA	#020H
		STA	!SUBADF
		M16			; memory 16bit mode
		STZ	!BG2SPFV
		STZ	!BG2SPF
		STZ	!BG2OF_FG
		LDA	#00277H
		STA	!BG12CH
		STZ	<SCCH1
		STZ	<SCCV1
		STZ	<SCCH3
		STZ	<SCCV3
		M8			; memory 8bit mode
;
		INC	!GOAL_IN
		INC	!GOAL_IN
		RTS
;
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+								+
;+		EBhDX^[g!!				+
;+					(ʕ\)		+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
BSCR_SCRE_400	EQU	$
		JSR	BSCR_WND_ST
		M16			; memory 16bit mode
		LDA	!BSCLR_WDYSTT
		BPL	BSCR_SCRE_450
		INC	!GOAL_IN
		INC	!GOAL_IN
		STZ	!TIMCNT
		STZ	!GOAL_TIM_PT
		STZ	!GOAL_CON_PT
		STZ	!GOAL_SPL_PT
		STZ	!GOAL_TTL_PT
		STZ	!WMANSL
		STZ	!WIND23
		STZ	!WIND24
		M8			; memory 8bit mode
		LDA	#030H
		STA	!GLWAITTIM
		M16			; memory 16bit mode
BSCR_SCRE_450	EQU	$
		M8			; memory 8bit mode
		LDA	#020H
		STA	!HD420C
		RTS
;
;
;****************************************************************
;*								*
;*		afRC Zbg `FbN			*
;*				in				*
;*				X : data set index		*
;****************************************************************
BGCIN_STCHK_ADR EQU	$
		WORD	SV_COIN_BF0,SV_COIN_BF1
		WORD	SV_COIN_BF2,SV_COIN_BF3
;
BGCIN_STCHK_DAT EQU	$
		WORD	1000000000000000B
		WORD	0100000000000000B
		WORD	0010000000000000B
		WORD	0001000000000000B
		WORD	0000100000000000B
		WORD	0000010000000000B
		WORD	0000001000000000B
		WORD	0000000100000000B
		WORD	0000000010000000B
		WORD	0000000001000000B
		WORD	0000000000100000B
		WORD	0000000000010000B
		WORD	0000000000001000B
		WORD	0000000000000100B
		WORD	0000000000000010B
		WORD	0000000000000001B
;
		MEM16
		IDX16
BGCOIN_SETCHK	EQU	$
		PHX
		TXA
		AND	#0000FH*2
		TAX
		LDA	>BGCIN_STCHK_DAT,X
		STA	<WORK2
		LDA	!CORSNO
		ASL	A
		TAX
		LDA	>BGCIN_STCHK_ADR,X
		STA	<WORK0
		PLX
;
		LDA	<XYPOINT
		XBA
		AND	#000FFH
		TAY
		LDA	!UNBUFAD,Y
		AND	#0003FH
		ASL	A
		TAY
		LDA	(<WORK0),Y
		AND	<WORK2
		RTL
		MEM8
		IDX8
;
;----------------------------------------------------------------------
;
;****************************************************************
;*								*
;*	ԃ|Cg ăX^[gZNg CjV Zbg	*
;*								*
;****************************************************************
HALF_INIT	EQU	$
		JSL	>VRAMCL
		JSL	>URAMCLR
		LDA	#HF_MSG
		STA	>MSG_NO
		JSR	AGAIN_INIT
;
		JMP	>MODINC
;
HALF_MSG_DAT	EQU	$
		WORD	3400H,4000H+(800H-1)
		WORD		02A2EH
		WORD	03485H,00008H*2-1
		WORD		02A00H,02A02H,02A04H,02A06H
		WORD		02A08H,02A0AH,02A0CH,02A0EH
		WORD	034A5H,00008H*2-1
		WORD		02A20H,02A22H,02A24H,02A26H
		WORD		02A28H,02A2AH,02A2CH,02A2EH
		WORD	034C5H,00008H*2-1
		WORD		02A40H,02A42H,02A44H,02A46H
		WORD		02A48H,02A4AH,02A4CH,02A4EH
		WORD	034E5H,00008H*2-1
		WORD		02A60H,02A62H,02A64H,02A66H
		WORD		02A68H,02A6AH,02A6CH,02A6EH
		WORD	0FFFFH
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+	ăX^[gZNg CjV Zbg		+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
AGAIN_INIT	EQU	$
		JSL	>ENRAMCLR	; enemy RAM clear
		JSL	>OAMDXCLR	; OAM clear
;
;--------------- ootWX^ Zbg --------------------------
		LDX	GMMDNOD
		JSL	>GMMDST
;
;--------------- J[ Zbg ----------------------------------
		LDX	#BANK DATACOL
		PHX
		PLB
		M16			; memory 16bit mode
;
		LDX	#080H-2
HALF_INIT_100	EQU	$
		STZ	!DATACOL+000H,X
		STZ	!DATACOL+080H,X
		STZ	!DATACOL+100H,X
		STZ	!DATACOL+180H,X
		DEX
		DEX
		BPL	HALF_INIT_100
;
		LDA	#07FFFH
		STA	!DATACOL+016H
;
		M8			; memory 8bit mode
		PHK
		PLB
		LDA	#HF_DT
		STA	!VRFLG
		JSL	>VMADSPL
;
		JSR	HALF_SET
;
;-------------- NMI-IRQ "ON" ------------------------------------
		LDA	#002H		;IRQ counter set
		STA	IRQFLG
		LDA	#050H		;H counter set
		STA	4207H
		LDA	#0D8H		;V counter set
		LDA	#10110001B	;timer IRQ "ON"
		STA	4200H
		RTS
;
;
;****************************************************************
;*								*
;*		ԃ|Cg ăX^[gZNg			*
;*								*
;****************************************************************
HALF_SLCT	EQU	$
		LDA	#HF_MSG
		STA	>MSG_NO
		JSR	HALF_SET
;
		LDA	!KEYC2L
		AND	#080H
		ORA	!KEYC2
		AND	#090H
		BNE	HALF_SLCT_240
		JMP	HALF_SLCT_900
HALF_SLCT_240	EQU	$
		LDA	!KEYC2L
		AND	#080H
		BNE	HALF_SLCT_250
		LDA	>MSG_ANS
		TAX
		LDA	AGAIN_SOUND,X
		STA	<SOUND_3
HALF_SLCT_250	EQU	$
		LDA	#010H
		STA	<AGAIN_WAIT
		INC	!MODENO
		STZ	!NEXTGOTO
		TXA
HALF_SLCT_290	EQU	$
		BNE	HALF_SLCT_900
;
		LDA	#001
		STA	!NEXTGOTO
		JSR	MID_POINT_LD
;
		M16			; memory 16bit mode
		STZ	!GRASS_ON
		STZ	!TIMER_HI
		STZ	!TIMER_MID
		STZ	!TIMER_LOW
		LDA	!TIMER
HALF_SLCT_310	EQU	$
		CMP	#00100
		BCC	HALF_SLCT_320
		SBC	#00100
		INC	!TIMER_HI
		BRA	HALF_SLCT_310
;
HALF_SLCT_320	EQU	$
		CMP	#00010
		BCC	HALF_SLCT_340
		SBC	#00010
		INC	!TIMER_MID
		BRA	HALF_SLCT_320
;
HALF_SLCT_340	EQU	$
		STA	!TIMER_LOW
;
		PHB
		LDY	#BANK HFSTTUS
		PHY
		PLB
		MI16			; memory , index 16bit mode
		STZ	!NEXTGOTO_POS
		LDA	!MAPOINT
		ASL	A
		TAY
		LDA	!CORSNOBUF
		ASL	A
		ASL	A
;;;;K;;;;		CLC
		ADC	HFSTATBL,Y
		TAY
		LDA	HFSTTUS+1,Y
		STA	>NXGOTOBF+1	;v[[ oʒu
		M8			; memory 8bit mode
		LDA	HFSTTUS+0,Y
		STA	>NXGOTOBF+0	;R[Xf[^ e[um.
		LDA	HFSTTUS+3,Y
		STA	>NXGOTOBF+3	;v[[̏
		I8			; index 8bit mode
		PLB
;
HALF_SLCT_900	EQU	$
		PLB
		RTL
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+							+
;+		ԃ|Cg bZ[W Zbg		+
;+							+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
HALF_SET	EQU	$
		JSR	MSG_CALL
		LDA	>MSG_ANS
		TAX
;
		MI16			; memory , index 16bit mode
		LDA	#00000H
		STA	>VRAMD
		DEC	A
		STA	>VRAMD+2
		MI8			; memory , index 8bit mode
		RTS
;
;
;****************************************************************
;*								*
;*	̃R[X ăX^[gZNg CjV Zbg	*
;*								*
;****************************************************************
COS_AGAIN_INT	EQU	$
		JSL	>VRAMCL
		JSL	>URAMCLR
		LDA	#AGN_MSG
		STA	>MSG_NO
		JSR	AGAIN_INIT
;
		JMP	>MODINC
;
;
;****************************************************************
;*								*
;*		̃R[X ăX^[gZNg Zbg		*
;*								*
;****************************************************************
AGAIN_SOUND	EQU	$
		HEX	043H,02EH
;
;
CORS_AGAIN	EQU	$
		LDA	#AGN_MSG
		STA	>MSG_NO
		JSR	HALF_SET
;
AGAIN_200	EQU	$
		LDA	!KEYC2L
		AND	#080H
		ORA	!KEYC2
		AND	#090H
		BEQ	AGAIN_900
		LDA	!KEYC2L
		AND	#080H
		BNE	AGAIN_250
		LDA	>MSG_ANS
		TAX
		LDA	AGAIN_SOUND,X
		STA	<SOUND_3
AGAIN_250	EQU	$
		INC	!MODENO
		LDA	#010H
		STA	<AGAIN_WAIT
		TXA
		BNE	AGAIN_900
;
		STZ	!NEXTGOTO
;
AGAIN_900	EQU	$
		PLB
		RTL
;
;
;****************************************************************
;*								*
;*		ZNg EFCg ăX^[g Zbg		*
;*								*
;****************************************************************
HALF_SLCT_DAT	EQU	$
		BYTE	GMIN,HMPIN
;
;
AGAIN_WAIT_SET	EQU	$
		DEC	<AGAIN_WAIT
		BNE	AGN_WT_ST_900
;
		LDA	>MSG_ANS
		TAX
		LDA	HALF_SLCT_DAT,X
		STA	!MODENO
		DEX			; }bvɂǂ̂ ?
		BMI	AGN_WT_ST_500	;	NO -> AGN_WT_ST_500
		LDA	!MAPOINT
		CMP	#INT_STAT	; CjV X^[g f ?
		BNE	AGN_WT_ST_500	;	NO -> AGN_WT_ST_500
		STZ	!MAPOINT
;
AGN_WT_ST_500	EQU	$
;
;-------------- Q[TEhtOLZ ------------------
		STZ	GM_BGM_NO	;[]
AGN_WT_ST_900	EQU	$
		PLB
		RTL
;
;
;************************************************************************
;*									*
;*		afQXN[Zbg				*
;*									*
;************************************************************************
;
;------------------------------------------------------------------------
;-		afQXN[f[^e[u				-
;------------------------------------------------------------------------
BG2_SCR_TBL	EQU	$			;[BG2TYP]
		WORD	BG2_SCR_00-BG2_SCR_DATA ;[ 0]
		WORD	BG2_SCR_01-BG2_SCR_DATA ;[ 1]
		WORD	BG2_SCR_02-BG2_SCR_DATA ;[ 2]
		WORD	BG2_SCR_03-BG2_SCR_DATA ;[ 3]
		WORD	BG2_SCR_04-BG2_SCR_DATA ;[ 4]
		WORD	BG2_SCR_05-BG2_SCR_DATA ;[ 5]
		WORD	BG2_SCR_06-BG2_SCR_DATA ;[ 6]
		WORD	BG2_SCR_07-BG2_SCR_DATA ;[ 7]
		WORD	BG2_SCR_08-BG2_SCR_DATA ;[ 8]
		WORD	BG2_SCR_09-BG2_SCR_DATA ;[ 9]
		WORD	BG2_SCR_0A-BG2_SCR_DATA ;[ A]
		WORD	BG2_SCR_0B-BG2_SCR_DATA ;[ B]
		WORD	BG2_SCR_0C-BG2_SCR_DATA ;[ C]
		WORD	BG2_SCR_0D-BG2_SCR_DATA ;[ D]
		WORD	BG2_SCR_0E-BG2_SCR_DATA ;[ E]
		WORD	BG2_SCR_0F-BG2_SCR_DATA ;[ F]
		WORD	BG2_SCR_10-BG2_SCR_DATA ;[10]
		WORD	BG2_SCR_11-BG2_SCR_DATA ;[11]
		WORD	BG2_SCR_12-BG2_SCR_DATA ;[12]
		WORD	BG2_SCR_13-BG2_SCR_DATA ;[13]
		WORD	BG2_SCR_14-BG2_SCR_DATA ;[14]
		WORD	BG2_SCR_15-BG2_SCR_DATA ;[15]
		WORD	BG2_SCR_16-BG2_SCR_DATA ;[16]
		WORD	BG2_SCR_17-BG2_SCR_DATA ;[17]
		WORD	BG2_SCR_18-BG2_SCR_DATA ;[18]
		WORD	BG2_SCR_19-BG2_SCR_DATA ;[19]
		WORD	BG2_SCR_1A-BG2_SCR_DATA ;[1A]
		WORD	BG2_SCR_1B-BG2_SCR_DATA ;[1B]
		WORD	BG2_SCR_1C-BG2_SCR_DATA ;[1C]
		WORD	BG2_SCR_1D-BG2_SCR_DATA ;[1D]
		WORD	BG2_SCR_1E-BG2_SCR_DATA ;[1E]
		WORD	BG2_SCR_1F-BG2_SCR_DATA ;[1F]
;
;------------------------------------------------------------------------
;-		afQwiXN[f[^				-
;------------------------------------------------------------------------
BG2_SCR_DATA	EQU	$
;
;----------------------------------------------------------------
;-		n						-
;----------------------------------------------------------------
BG2_SCR_00	EQU	$
		HEX	0		;afQ[vwiXN[^Cv
		BYTE	B2CHIKA
;
;----------------------------------------------------------------
;-								-
;----------------------------------------------------------------
BG2_SCR_01	EQU	$
		HEX	0		;afQ[vwiXN[^Cv
		BYTE	B2HATITUKI
;
;;;;K;;;;		HEX	001H		; XN[
;;;;K;;;;		HEX	000H
;;;;K;;;;;
;;;;K;;;;		WORD	BG2_SCR_01_0
;;;;K;;;;;
;;;;K;;;;BG2_SCR_01_0	EQU	$
;;;;K;;;;		BYTE	000H
;;;;K;;;;		WORD	00080H
;;;;K;;;;		WORD	00100H*2+(10H*1CH)+7
;;;;K;;;;		BYTE	000H
;;;;K;;;;		WORD	00140H
;;;;K;;;;		WORD	00100H*8	;end line
;
;----------------------------------------------------------------
;-								-
;----------------------------------------------------------------
BG2_SCR_02	EQU	$
		HEX	0		;afQ[vwiXN[^Cv
		BYTE	B2MIZU
;
;----------------------------------------------------------------
;-		n						-
;----------------------------------------------------------------
BG2_SCR_03	EQU	$
		HEX	0		;afQ[vwiXN[^Cv
		BYTE	B2NAMI
;
;----------------------------------------------------------------
;-								-
;----------------------------------------------------------------
BG2_SCR_04	EQU	$
		HEX	0		;afQ[vwiXN[^Cv
		BYTE	B2YAMA
;
;----------------------------------------------------------------
;-		qdc vnncr				-
;----------------------------------------------------------------
BG2_SCR_05	EQU	$
		HEX	4		;afQ[vwiXN[^Cv
		BYTE	B2RDWOD
;
		HEX	001H		; XN[
		HEX	000H
;
		WORD	BG2_SCR_05_0
;
BG2_SCR_05_0	EQU	$
		BYTE	000H
		WORD	000B0H
		WORD	00100H*2+(10H*0FH)+7
		BYTE	000H
		WORD	000A0H
		WORD	00100H*2+(10H*10H)+7
		BYTE	000H
		WORD	00090H
		WORD	00100H*2+(10H*11H)+7
		BYTE	000H
		WORD	00080H
		WORD	00100H*2+(10H*12H)+7
		BYTE	000H
		WORD	00070H
		WORD	00100H*2+(10H*13H)+7
		BYTE	000H
		WORD	00060H
		WORD	00100H*2+(10H*14H)+7
		BYTE	000H
		WORD	00050H
		WORD	00100H*2+(10H*15H)+7
		BYTE	000H
		WORD	00040H
		WORD	00100H*2+(10H*16H)+7
		BYTE	000H
		WORD	000C0H
		WORD	00100H*8	;end line
;
;----------------------------------------------------------------
;-		Jx						-
;----------------------------------------------------------------
BG2_SCR_06	EQU	$
		HEX	0		;afQ[vwiXN[^Cv
		BYTE	B2KABE
;
;----------------------------------------------------------------
;-		pXei_j				-
;----------------------------------------------------------------
BG2_SCR_07	EQU	$
		HEX	0		;afQ[vwiXN[^Cv
		BYTE	B2PAST2
;
;----------------------------------------------------------------
;-		X						-
;----------------------------------------------------------------
BG2_SCR_08	EQU	$
		HEX	0		;afQ[vwiXN[^Cv
		BYTE	B2MORI
;
;----------------------------------------------------------------
;-		pXei_tj				-
;----------------------------------------------------------------
BG2_SCR_09	EQU	$
		HEX	0		;afQ[vwiXN[^Cv
		BYTE	B2ENKIN2
;
;----------------------------------------------------------------
;-		n`						-
;----------------------------------------------------------------
BG2_SCR_0A	EQU	$
		HEX	0		;afQ[vwiXN[^Cv
		BYTE	B2HTTAKI
;
;----------------------------------------------------------------
;-		hX					-
;----------------------------------------------------------------
BG2_SCR_0B	EQU	$
		HEX	0		;afQ[vwiXN[^Cv
		BYTE	B2YUKA
;
;----------------------------------------------------------------
;-		WO					-
;----------------------------------------------------------------
BG2_SCR_0C	EQU	$
		HEX	0		;afQ[vwiXN[^Cv
		BYTE	B2JUNGLE
;
;----------------------------------------------------------------
;-		X^[						-
;----------------------------------------------------------------
BG2_SCR_0D	EQU	$
		HEX	0		;afQ[vwiXN[^Cv
		BYTE	B2STAR
;
;----------------------------------------------------------------
;-		OO					-
;----------------------------------------------------------------
BG2_SCR_0E	EQU	$
		HEX	0		;afQ[vwiXN[^Cv
		BYTE	B2GULGUL
;
;----------------------------------------------------------------
;-		tWR						-
;----------------------------------------------------------------
BG2_SCR_0F	EQU	$
		HEX	4		;afQ[vwiXN[^Cv
		BYTE	B2FUJI
;
		HEX	001H		; XN[
		HEX	000H
;
		WORD	BG2_SCR_0F_0
;
BG2_SCR_0F_0	EQU	$
		BYTE	000H
		WORD	00028H
		WORD	00100H*0+(10H*19H)+7
		BYTE	000H
		WORD	00016H
		WORD	00100H*0+(10H*1BH)+7
		BYTE	000H
		WORD	00028H
		WORD	00100H*0+(10H*1DH)+7
		BYTE	000H
		WORD	00016H
		WORD	00100H*0+(10H*1FH)+7
		BYTE	000H
		WORD	00028H
		WORD	00100H*2+(10H*01H)+7
		BYTE	000H
		WORD	00016H
		WORD	00100H*2+(10H*03H)+7
		BYTE	000H
		WORD	00028H
		WORD	00100H*2+(10H*05H)+7
		BYTE	000H
		WORD	00028H
		WORD	00100H*2+(10H*07H)+7
		BYTE	000H
		WORD	00040H
		WORD	00100H*2+(10H*0BH)+7
		BYTE	000H
		WORD	00080H
		WORD	00100H*4	;end line
;
;----------------------------------------------------------------
;-		ߗp̉i					-
;----------------------------------------------------------------
BG2_SCR_10	EQU	$
		HEX	0		;afQ[vwiXN[^Cv
		BYTE	B2ENKIN2
;
;----------------------------------------------------------------
;-								-
;----------------------------------------------------------------
BG2_SCR_11	EQU	$
		HEX	0		;afQ[vwiXN[^Cv
		BYTE	B2FUJI
;
;----------------------------------------------------------------
;-								-
;----------------------------------------------------------------
BG2_SCR_12	EQU	$
		HEX	0		;afQ[vwiXN[^Cv
		BYTE	B2SORA
;
;----------------------------------------------------------------
;-		n					-
;----------------------------------------------------------------
BG2_SCR_13	EQU	$
;;;;K;;;;		HEX	4		;afQ[vwiXN[^Cv
		HEX	0		;afQ[vwiXN[^Cv
		BYTE	B2IWA
;
		BYTE	001H		; XN[
		BYTE	001H*2+000H
		WORD	00100H*2+(10H*0CH)+7
		BYTE	002H*2+000H
		WORD	00100H*3+(10H*05H)+7
		BYTE	001H*2+000H
		WORD	00100H*4	;end line
;
;----------------------------------------------------------------
;-		Y						-
;----------------------------------------------------------------
BG2_SCR_14	EQU	$
		HEX	0		;afQ[vwiXN[^Cv
		BYTE	B2WODKB
;
;----------------------------------------------------------------
;-		R						-
;----------------------------------------------------------------
BG2_SCR_15	EQU	$
		HEX	0		;afQ[vwiXN[^Cv
		BYTE	B2IWAYAM
;
;----------------------------------------------------------------
;-		afQG					-
;----------------------------------------------------------------
BG2_SCR_16	EQU	$
		HEX	0		;afQ[vwiXN[^Cv
		BYTE	B2TEKI
;
;----------------------------------------------------------------
;-								-
;----------------------------------------------------------------
BG2_SCR_17	EQU	$
;
;----------------------------------------------------------------
;-		mhfgs					-
;----------------------------------------------------------------
BG2_SCR_18	EQU	$
		HEX	0		;afQ[vwiXN[^Cv
		BYTE	B2NIGHT
;
;----------------------------------------------------------------
;-		n`						-
;----------------------------------------------------------------
BG2_SCR_19	EQU	$
		HEX	0		;afQ[vwiXN[^Cv
		BYTE	B2SHIRO
;
;----------------------------------------------------------------
;-		RQ						-
;----------------------------------------------------------------
BG2_SCR_1A	EQU	$
		HEX	0		;afQ[vwiXN[^Cv
		BYTE	B2IWA2
;
;----------------------------------------------------------------
;-		x^						-
;----------------------------------------------------------------
BG2_SCR_1B	EQU	$
		HEX	0		;afQ[vwiXN[^Cv
		BYTE	B2BETA
;
;----------------------------------------------------------------
;-		n`pXe					-
;----------------------------------------------------------------
BG2_SCR_1C	EQU	$
		HEX	4		;afQ[vwiXN[^Cv
		BYTE	B2HCHPSTL
;
		BYTE	000H		;X^[XN[ tO
		BYTE	000H		;cX^[XN[ tO
;
;;;;K;;;;		WORD	BG2_SCR_1C_0	;X^[XN[ f[^AhX
;;;;K;;;;		WORD	BG2_SCR_1C_1
;
;;;;K;;;;BG2_SCR_1C_0	EQU	$		;XN[ f[^
;;;;K;;;;		BYTE	000H		;X^[XN[ ؂芷tO
;;;;K;;;;		WORD	00080H
;;;;K;;;;		WORD	00100H*6+(10H*01H)+7
;;;;K;;;;		BYTE	000H
;;;;K;;;;		WORD	00033H
;;;;K;;;;		WORD	00100H*6+(10H*05H)+7
;;;;K;;;;		BYTE	000H
;;;;K;;;;		WORD	00099H
;;;;K;;;;		WORD	00100H*6+(10H*07H)+7
;;;;K;;;;		BYTE	000H
;;;;K;;;;		WORD	0004CH
;;;;K;;;;		WORD	00100H*6+(10H*0BH)+7
;;;;K;;;;		BYTE	000H
;;;;K;;;;		WORD	000B3H
;;;;K;;;;		WORD	00100H*6+(10H*0DH)+7
;;;;K;;;;		BYTE	000H
;;;;K;;;;		WORD	00066H
;;;;K;;;;		WORD	00100H*6+(10H*10H)+7
;;;;K;;;;		BYTE	000H
;;;;K;;;;		WORD	000CCH
;;;;K;;;;		WORD	00100H*6+(10H*11H)+7
;;;;K;;;;		BYTE	000H
;;;;K;;;;		WORD	00080H
;;;;K;;;;		WORD	00100H*6+(10H*14H)+7
;;;;K;;;;		BYTE	000H
;;;;K;;;;		WORD	000E6H
;;;;K;;;;		WORD	00100H*6+(10H*15H)+7
;;;;K;;;;		BYTE	000H
;;;;K;;;;		WORD	00099H
;;;;K;;;;		WORD	00100H*6+(10H*18H)+7
;;;;K;;;;		BYTE	000H
;;;;K;;;;		WORD	00180H
;;;;K;;;;		WORD	00100H*8	;end line
;
;;;;K;;;;BG2_SCR_1C_1	EQU	$		; cX^[XN[
;;;;K;;;;		HEX	008H		; Xs[h
;;;;K;;;;		HEX	080H		; ŏl
;;;;K;;;;		WORD	00716H		; X^[g C
;;;;K;;;;		WORD	00780H		; Gh C
;;;;K;;;;		WORD	0FFFFH		; end code
;
;----------------------------------------------------------------
;-		₫R					-
;----------------------------------------------------------------
BG2_SCR_1D	EQU	$
		HEX	0			;afQ[vwiXN[^Cv
		BYTE	B2TAKOYAKI
;
;----------------------------------------------------------------
;-								-
;----------------------------------------------------------------
BG2_SCR_1E	EQU	$
		HEX	0			;afQ[vwiXN[^Cv
		BYTE	B2SUGI
;
;----------------------------------------------------------------
;-		Nbp̕					-
;----------------------------------------------------------------
BG2_SCR_1F	EQU	$
		HEX	0			;afQ[vwiXN[^Cv
		BYTE	B2KOPROM
;------------------------------------------------------------------------
;-		afQwiXN[obt@|C^[		-
;------------------------------------------------------------------------
BG2_SCR_BFP	EQU	$
		WORD	BG2_SCRBUF+1800H
		WORD	BG2_SCRBUF+1000H
		WORD	BG2_SCRBUF+0800H
		WORD	BG2_SCRBUF
;
BG2_SCR_INIT	EQU	$
		LDA	!DSPMOD
		CMP	#00AH
		BNE	BG2_SCR_INT_PAS
		JMP	DBL_TELE_SCR
;
BG2_SCR_INT_PAS EQU	$
		STZ	!BG2SPF
		STZ	!BG2SPFV
		STZ	!BG2SPH_CT
		STZ	!BG2SPV_CT
;
		MI16			; memory , index 16bit mode
;
		LDA	BG2TYP
		ASL	A
		TAX
		LDY	!BG2_SCR_TBL,X
		LDA	!BG2_SCR_DATA,Y
		AND	#00FFH
		TAX
		JMP	(!BG2_SCR_TYPE,X)
;
		MEM8
		IDX8
;
;------------------------------------------------------------------------
;-		afQXN[^Cve[u				-
;------------------------------------------------------------------------
BG2_SCR_TYPE	EQU	$
		WORD	BG2_SCR_TYPE_0	;[0] afQ[vwiXN[
		WORD	00000H		; _~[
		WORD	BG2_SCR_TYPE_2	;[2] afQ[vwiXN[
;
;------------------------------------------------------------------------
;-		afQ[vwiXN[			-
;------------------------------------------------------------------------
		MEM16
		IDX16
BG2_SCR_TYPE_2	EQU	$
		M8			; memory 8bit mode
		LDA	#0FH		;gcl`
		STA	4341H		;	aoXAhXύX
;
		LDA	BG2_SCR_DATA+2,Y
		STA	!BG2SPF
		M16			; memory 16bit mode
		LDA	BG2_SCR_DATA+4,Y
		STA	!BG2SPF_ADR
;
;------------------------------------------------------------------------
;-		afQ[vwiXN[Zbg			-
;------------------------------------------------------------------------
;
		MEM16
		IDX16
;
BG2_SCR_TYPE_0	EQU	$
		LDA	!BG2_SCR_DATA+1,Y	;(A) <-- kf[^mD
		AND	#00FFH
		LDX	#WOB7CHR		;(X) <-- 𓀐AhX
		JSL	>UNCOMPRES
;
		STA	4305H			;number of byte set
;
		I8
;
		LDX	#10000000B		;inc mode set
		STX	2115H
		LDA	#3800H			;VRAM address set
		STA	2116H
		LDA	#00000001B+(18H*100H)	;parameter & A bus address set
		STA	4300H
		LDA	#WOB7CHR		;(A) bus address(L,H)
		STA	4302H
		LDX	#BANK WOB7CHR		;	"       (B)
		STX	4304H
		LDX	#00000001B
		STX	420BH			;DMA "ON"
;
;;;;K;;;;		LDA	!BG2TYP
;;;;K;;;;		CMP	#0001FH		; Nbp̕ ?
;;;;K;;;;		BNE	NO_KUPPA	;	NO -> NO_KUPPA
;;;;K;;;;		LDX	#000
;;;;K;;;;SET_KUPPA	EQU	$
;;;;K;;;;		LDA	>COL_ADDRESS+KOPPA_OBJ_COL,X
;;;;K;;;;		STA	>DATACOL+(10H*2*8)+(10H*2*6)+2,X
;;;;K;;;;		INX
;;;;K;;;;		INX
;;;;K;;;;		CPX	#020H-2
;;;;K;;;;		BCC	SET_KUPPA
;;;;K;;;;NO_KUPPA	EQU	$
		M8
;
		LDA	!DSPMOD
		CMP	#003		; [hQ ?
		BNE	PPPAAASSS	;	NO -> PPPAAASSS
		JSR	FRHDMA_SET
PPPAAASSS	EQU	$
		RTS
;
;------------------------------------------------------------------------
;-		_ueTpXN[Zbg				-
;------------------------------------------------------------------------
DBL_TELE_SCR	EQU	$
		MI16			; memory , index 16bit mode
		LDA	#B3SHIRO	;(A) <-- kf[^mD
		AND	#000FFH
		LDX	#WOB7CHR	;(X) <-- 𓀐AhX
		JSL	>UNCOMPRES
;
		STA	4305H		;number of byte set
;
		I8			; index 8bit mode
;
		LDX	#10000000B
		STX	2115H		;inc mode set
		LDA	#3800H
		STA	2116H		;VRAM address set
		LDA	#00000001B+(18H*100H)
		STA	4300H		;parameter & A bus address set
		LDA	#WOB7CHR
		STA	4302H		;(A) bus address(L,H)
		LDX	#BANK WOB7CHR
		STX	4304H		;	"       (B)
		LDX	#00000001B
		STX	420BH		;DMA "ON"
;
		M8			; memory 8bit mode
		RTS
;
;
;------------------------------------------------------------------------
;-		ς炢 gcl` Zbg				-
;------------------------------------------------------------------------
FRHDMA_prmtr0	EQU	$		;X^[XN[
		BYTE	000H
		WORD	00080H
		WORD	00100H*8
		BYTE	002H		;
;
FRHDMA_prmtr1	EQU	$		;cX^[XN[
		HEX	001H		; X^[ nm
		WORD	00100H*8	;end line
		HEX	0FFH		; end code
;
;
FRHDMA_SET	EQU	$
		LDA	#0FH		;aoXAhXύX
		STA	4341H		;
		LDA	#010H		;
		STA	4331H		;
;
;;;;K;;;;		INC	!BG2SPF
;;;;K;;;;		INC	!BG2SPF
;;;;K;;;;		INC	!BG2SPFV
		STZ	!BG2SPF
		STZ	!BG2SPFV
;
		M16			; memory 16bit mode
		LDA	#FRHDMA_prmtr0
		STA	!BG2SPF_ADR
		LDA	#FRHDMA_prmtr1
		STA	!BG2SPFV_ADR
		M8			; memory 8bit mode
		RTS
;
;************************************************************************
;*									*
;*		afRXN[Zbg				*
;*									*
;************************************************************************
;
;------------------------------------------------------------------------
;-		afRXN[NA[f[^				-
;------------------------------------------------------------------------
BG3SCRCLR	EQU	$
		WORD	3400H,4000H+(800H-1)
		WORD		01CEH
		WORD	0FFFFH
;
;------------------------------------------------------------------------
;-		afRXN[NA[f[^iafRj	-
;------------------------------------------------------------------------
BG3WANCLR	EQU	$
		WORD	3400H,4000H+(800H-1)
		WORD		0111H
		WORD	0FFFFH
;
;------------------------------------------------------------------------
;-		afRXN[NA[f[^iafRAX`bNj-
;------------------------------------------------------------------------
BG3WTRCLR	EQU	$
		WORD	3400H,4000H+(800H-1)
		WORD		01CEH
		WORD	0FFFFH
;
;------------------------------------------------------------------------
;-		afRXN[f[^e[u				-
;------------------------------------------------------------------------
BG3_SCR_TBL	EQU	$-3				;[BG3TYP]
		WORD	B3MIZU
		BYTE	BG3_SP_SCR_00-BG3_SP_SCR_DATA	;[ 1:iXN[j]
		WORD	B3TEKI0
		BYTE	0FFH				;[ 2:afRGiJxAIoPj]
		WORD	B3PAST1
		BYTE	0				;[ 3:pXe]
		WORD	B3PAST1
		BYTE	0				;[ 4:	h   Q]
		WORD	B3TEKI1
		BYTE	0FFH				;[ 5:afRGi]|Sj]
		WORD	B3TEKI2
		BYTE	0FFH				;[ 6:	h   i{gj]
		WORD	B3TEKI3
		BYTE	0FFH				;[ 7:]
		WORD	B3TEKI7
		BYTE	0FFH				;[ 8:]
		WORD	00
		BYTE	0				;[ 9:ou]
		WORD	00
		BYTE	0				;[ A:O]
		WORD	B3TEKI4
		BYTE	0FFH				;[ B:eleveter test]
		WORD	B3MORI
		BYTE	0				;[ C:X]
		WORD	B3KUMO
		BYTE	0				;[ D:R]
		WORD	B3JUNGLE
		BYTE	BG3_SP_SCR_01-BG3_SP_SCR_DATA	;[ E:WO]
		WORD	B3FUJI
		BYTE	BG3_SP_SCR_02-BG3_SP_SCR_DATA	;[ F:tWR]
		WORD	B3KUMO2
		BYTE	0				;[10:_̂Q]
		WORD	B3KMBOSS
		BYTE	0FFH				;[11:J{X]
		WORD	B3NIGHT
		BYTE	0				;[12:mhfgs]
		WORD	B3KSMZ
		BYTE	080H+B3_SPL_NO_00		;[13:AX`bN]
		WORD	B3KNH
		BYTE	BG3_SP_SCR_03-BG3_SP_SCR_DATA	;[14:؂̗t]
		WORD	B3CHIKA
		BYTE	0				;[15:n]
		WORD	B3WANWAN
		BYTE	0				;[16:afR]
		WORD	B3KABE2
		BYTE	0				;[17:ỸJx]
		WORD	B3SHIRO
		BYTE	0				;[18:n`]
		WORD	B3YUKI
		BYTE	0				;[19:]
		WORD	B3AHODR
		BYTE	0				;[1A:𒹂̌Q]
		WORD	B3FLWR
		BYTE	0				;[1B:eknvdq]
		WORD	bg3mask
		BYTE	0				;[1C:}XNEBhD]
		WORD	B3KSMZ
		BYTE	BG3_SP_SCR_04-BG3_SP_SCR_DATA	;[1D:AX`bN]
		WORD	B3HATITUKI
		BYTE	080H+B3_SPL_NO_01		;[1E:]
		WORD	B3MAGIC
		BYTE	0				;[1F:JbN̖@]
		WORD	B3HCHPSTL
		BYTE	080H+B3_SPL_NO_02		;[20:n`pXe]
		WORD	B3STOMACH
		BYTE	0				;[21:ݕ]
		WORD	B3HTTAKI
		BYTE	080H+B3_SPL_NO_03		;[22:n`]
		WORD	B3HTYUHI
		BYTE	080H+B3_SPL_NO_04		;[23:n`[]
		WORD	B3GOGH
		BYTE	080H+B3_SPL_NO_05		;[24:Sbz]
		WORD	B3BOSROM
		BYTE	0				;[25:{X]
		WORD	B3BOSFLSH
		BYTE	0				;[26:{XtbV]
		WORD	B3MORI2
		BYTE	0				;[27:X̂Q]
		WORD	B3STAR
		BYTE	0				;[28:X^[]
		WORD	B3NOGKUMO
		BYTE	0				;[29:Ỷ_]
		WORD	B3HTTK_K
		BYTE	080H+B3_SPL_NO_06		;[2A:Œ茎]
		WORD	B3NOGKUMO2
		BYTE	0				;[2B:Ỷ_̂Q]
		WORD	B3KIRI
		BYTE	080H+B3_SPL_NO_07		;[2C:]
		WORD	B3KIRI
		BYTE	0				;[2D:X^[Ȃ]
		WORD	B3NOGKUMO3
		BYTE	0				;[2E:Ỷ_̂R]
		WORD	B3FUJI2
		BYTE	0				;[2F:n`tW]
		WORD	00
		BYTE	0				;[30]
		WORD	00
		BYTE	0				;[31]
		WORD	00
		BYTE	0				;[32]
		WORD	00
		BYTE	0				;[33]
		WORD	00
		BYTE	0				;[34]
		WORD	00
		BYTE	0				;[35]
		WORD	00
		BYTE	0				;[36]
		WORD	00
		BYTE	0				;[37]
		WORD	00
		BYTE	0				;[38]
		WORD	00
		BYTE	0				;[39]
		WORD	00
		BYTE	0				;[3A]
		WORD	00
		BYTE	0				;[3B]
		WORD	00
		BYTE	0				;[3C]
		WORD	00
		BYTE	0				;[3D]
		WORD	00
		BYTE	0				;[3E]
		WORD	00
		BYTE	0				;[3F]
;
;------------------------------------------------------------------------
;-		afRXN[f[^				-
;------------------------------------------------------------------------
BG3_SP_SCR_DATA EQU	$-1
;			 +---------------- number of block [ 01-40 ( 00:end code,+80H:constant mode ) ]
;			 |	 +-------- start V pos [ 00-1F ]
;			 |	 |    +---- scrooll type [ 0:SCCH1 2:SCCH2 4:SCCH3 6:SCCH4 ]
;			 V	 V    V
BG3_SP_SCR_00	EQU	$		;
		BYTE	(ESCCV1-ESCCV1)+2	;V scroll flag( BG1 )
		BYTE	10H+00H,000H,004H
		BYTE	10H+00H,000H,004H
		BYTE	10H+00H,000H,004H
		BYTE	10H+00H,000H,004H
		BYTE	10H+00H,000H,004H
		BYTE	10H+00H,000H,004H
		BYTE	10H+00H,000H,004H
		BYTE	12H+00H,010H,000H
		HEX	00		;end code
;
BG3_SP_SCR_01	EQU	$		;WO
		BYTE	(ESCCV3-ESCCV1)+2	;V scroll flag( BG3 )
		BYTE	0AH+80H,000H,004H
		BYTE	0AH+00H,000H,004H
		BYTE	16H+00H,00AH,006H
		HEX	00		;end code
;
BG3_SP_SCR_02	EQU	$		;tWR
		BYTE	(ESCCV3-ESCCV1)+2	;V scroll flag( BG3 )
		BYTE	0AH+80H,000H,004H
		BYTE	09H+00H,000H,004H
		BYTE	17H+00H,009H,006H
		HEX	00		;end code
;
BG3_SP_SCR_03	EQU	$		;؂̗t
		BYTE	(ESCCV3-ESCCV1)+2	;V scroll flag( BG3 )
		BYTE	10H+80H,000H,004H
		BYTE	06H+00H,00DH,004H
		BYTE	0CH+00H,013H,006H
		HEX	00		;end code
;
BG3_SP_SCR_04	EQU	$		;AX`bN
		BYTE	(ESCCV3-ESCCV1)+2	;V scroll flag( BG3 )
		BYTE	75H+80H,000H,004H
		BYTE	01H+80H,001H,004H
		BYTE	09H+80H,002H,004H
		HEX	00		;end code
;
;
		MEM8
		IDX8
;
BG3_SCR_INIT	EQU	$
		LDY	#B3CL		;(Y) <-- afRXN[NA[f[^mD
		LDA	BG3TYP
		BEQ	BG3_SCR_INIT_11 ;afRXN[H ( yes:BG3_SCR_INIT_11 )
;
;-------------- afRXN[f[^Zbg ----------------------------
		ASL	A
		ADC	!BG3TYP
		TAY
		M16			; memory 16bit mode
		LDA	!BG3_SCR_TBL,Y
		BEQ	BG3_SCR_INIT_12 ;XN[f[^ZbgH ( no:BG3_SCR_INIT_12 )
;
;;;;K;;;;		MI16
		I16			; index 16bit mode
;
;;;;K;;;;		AND	#00FFH			;(A) <-- kf[^mD
		LDX	#WOB7CHR		;(X) <-- 𓀐AhX
		PHY				;(Y) save
		JSL	>UNCOMPRES
		PLY				;(Y) load
;
		LDX	BG3TYP
		CPX	#16H
		BNE	BG3_SCR_INIT_13 ;afRH ( no:BG3_SCR_INIT_13 )
;
;-------------- afRXN[r`ud ----------------
		LDX	#CHRSVBF	;to memory address set
		STX	<WORK20
		LDX	#BANK CHRSVBF
		STX	<WORK22
		LDX	#WOB7CHR	;from memory address set
		STX	<WORK23
		LDX	#BANK WOB7CHR
		STX	<WORK25
;
		I8
;
		JSL	>DMA_M_M	;DMA "ON"
;
		M8
;
		LDY	#WNCL		;(Y) <-- afRXN[NA[f[^mD
;
;-------------- afRXN[NA[ --------------------------------
BG3_SCR_INIT_11 EQU	$
		STY	VRFLG
		JSL	>VMADSPL
BG3_SCR_INIT_12 EQU	$
		M8			; memory 8bit mode
		RTS
;
		MEM16
;
BG3_SCR_INIT_13 EQU	$
;
		I8
;
		STA	4305H			;number of byte set
		STA	<WORK0
		LDX	#10000000B		;inc mode set
		STX	2115H
		LDA	#3400H			;VRAM address set
		STA	2116H
		LDA	#00000001B+(18H*100H)	;DMA parameter & B bus address set
		STA	4300H
		LDA	#WOB7CHR		;A bus address(L,H) set
		STA	4302H
		LDX	#BANK WOB7CHR		;      "      (B) set
		STX	4304H
		LDX	#00000001B
		STX	420BH			;DMA "ON" !!
;
		LDA	!DSPMOD
		CMP	#0000AH		;_ueTp XN[Zbg ?
		BNE	DBL_TELE_PASS	;	NO -> DBL_TELE_PASS
;
		LDA	<WORK0
		STA	4305H			;number of byte set
		LDA	#0000H			;VRAM address set
		STA	2116H
		LDA	#WOB7CHR		;A bus address(L,H) set
		STA	4302H
		STX	420BH			;DMA "ON" !!
;
DBL_TELE_PASS	EQU	$
		M8
;
;-------------- BG3 spacial screen data set ---------------------
		LDX	!BG3_SCR_TBL+2,Y
		BEQ	BG3_SCR_INIT_12 ;XN[f[^ZbgH ( no:BG3_SCR_INIT_12 )
;
		CPX	#0FFH		; afRGH
		BEQ	BG3_SCR_INIT_14 ;	YES -> BG3_SCR_INIT_14
		TXA
		BPL	BG3_SCR_INIT_16
		ASL	A
		CMP	#BG3_SPECIAL
		BCS	BG3_SCR_INIT_14
		TAX
		JSR	(BG3_SPL_ADR,X)
		BRA	BG3_SCR_INIT_12
;
BG3_SCR_INIT_14 EQU	$
		LDA	#00000100B	;afR\hneeh
		TRB	MANSEL
		TRB	SUBSEL
		RTS
;
BG3_SCR_INIT_16 EQU	$
		LDA	>BG3_SP_SCR_DATA,X
		STA	BG3SPF		;BG3 spacial screen flag set !!
;
		PHB			;(DBR) save
		LDA	#BANK BG3SCBF	;(DBR) set
		PHA
		PLB
;
		I16
;
		LDY	#00		;(Y)	 <-- BG3 spacial screen buffer index
		STZ	<WORK8		;(WK8,9) <--	      "         counter
BG3_SCR_INIT_20 EQU	$
		LDA	>BG3_SP_SCR_DATA+1,X
		BEQ	BG3_SCR_INIT_50 ;data end ? ( yes:BG3_SCR_INIT_50 )
;
		STA	<WORK1		;(WK1) <-- number mode [ +80H:constant ]
;
		M16
;
		AND	#007FH
		ASL	A
		ASL	A
		ASL	A
		ASL	A
		STA	<WORK2		;(WK2,3) <-- number of block
		LDA	>BG3_SP_SCR_DATA+2,X
		AND	#00FFH
		ASL	A
		ASL	A
		ASL	A
		ASL	A
		STA	<WORK4		;(WK4,5) <-- start V pos
		LDA	>BG3_SP_SCR_DATA+3,X
		AND	#00FFH
		STA	<WORK6		;(WK6,7) <-- scrooll type
BG3_SCR_INIT_30 EQU	$
		LDA	<WORK4		;V pos data set
		SEC
		SBC	<WORK8
		STA	BG3SCBF+2,Y
		LDA	#010H		;(A) <-- number of V counter
		BIT	<WORK1-1
		BMI	BG3_SCR_INIT_40 ;constant number mode ? ( yes:BG3_SCR_INIT_40 )
		LDA	<WORK4
		CLC
		ADC	#0010H
		STA	<WORK4
		LDA	<WORK2		;(A) <-- number of V counter
BG3_SCR_INIT_40 EQU	$
		STA	BG3SCBF,Y
		LDA	<WORK8
		CLC
		ADC	#0010H
		STA	<WORK8
		LDA	<WORK6		;scroll type set
		STA	BG3SCBF+4,Y
		TYA
		CLC
		ADC	#6
		TAY
		LDA	<WORK2		;number of V counter
		SEC
		SBC	#0010H
		STA	<WORK2
		BNE	BG3_SCR_INIT_30 ;V counter end ? ( no:BG3_SCR_INIT_30 )
;
		M8
;
		INX
		INX
		INX
		BRA	BG3_SCR_INIT_20
;
BG3_SCR_INIT_50 EQU	$
		PLB			;(DBR) load
;
		I8
;
BG3_SCR_INIT_60 EQU	$
		RTS
;
;
BG3_SPL_ADR	EQU	$
		WORD	B3_WTRASLE,POINT_SCRL00,POINT_SCRL10
		WORD	DISP_COL_SET,POINT_SCRL20,DISP_COL_00
		WORD	POINT_SCRL00,POINT_SCRL30
;
BG3_SPECIAL	EQU	$-BG3_SPL_ADR
;
B3_SPL_NO_00	EQU	000
B3_SPL_NO_01	EQU	B3_SPL_NO_00+1
B3_SPL_NO_02	EQU	B3_SPL_NO_01+1
B3_SPL_NO_03	EQU	B3_SPL_NO_02+1
B3_SPL_NO_04	EQU	B3_SPL_NO_03+1
B3_SPL_NO_05	EQU	B3_SPL_NO_04+1
B3_SPL_NO_06	EQU	B3_SPL_NO_05+1
B3_SPL_NO_07	EQU	B3_SPL_NO_06+1
;
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+								+
;+		v`sdq AX`bNp			+
;+					in			+
;+					X <- CfbNX	+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
B3_WTRASL_ADR	EQU	$
		WORD	03740H
;
B3_WTRASL_SUB	EQU	$
		WORD	00680H
;
;
B3_WTRASLE	EQU	$
		PHX
		LDY	#B3WRCL		; afRXN[
		STY	!VRFLG		;		NA[
		JSL	>VMADSPL
;
		PLA
		M16			; memory 16bit mode
		AND	#000FFH
		ASL	A
		TAX
;
		LDA	B3_WTRASL_ADR,X
		STA	2116H		;VRAM address set
		LDA	#00800H
		SEC
		SBC	B3_WTRASL_SUB,X
		STA	4305H		;number of byte set
		LDX	#10000000B
		STX	2115H		;inc mode set
		LDA	#00000001B+(18H*100H)
		STA	4300H		;DMA parameter & B bus address set
		LDX	#BANK WOB7CHR
		STX	4304H		;	"       (B) set
		LDA	#WOB7CHR
		STA	4302H		;A bus address(L,H) set
		LDX	#00000001B
		STX	420BH		;DMA "ON" !!
;
		M8			; memory 8bit mode
		RTS
;
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+								+
;+		afRXN[				+
;+								+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
BG3_SCR_DAT00	EQU	$			; 
		BYTE	000H
		WORD	00020H
		WORD	00100H*0+(10H*00H)+7
		BYTE	000H
		WORD	00030H
		WORD	00100H*0+(10H*02H)+7
		BYTE	000H
		WORD	00020H
		WORD	00100H*0+(10H*03H)+7
		BYTE	000H
		WORD	0002EH
		WORD	00100H*0+(10H*05H)+7
		BYTE	000H
		WORD	00020H
		WORD	00100H*0+(10H*06H)+7
		BYTE	000H
		WORD	0002CH
		WORD	00100H*0+(10H*08H)+7
		BYTE	000H
		WORD	00020H
		WORD	00100H*0+(10H*09H)+7
		BYTE	000H
		WORD	0002AH
		WORD	00100H*0+(10H*0BH)+7
		BYTE	000H
		WORD	00010H
		WORD	00100H*0+(10H*13H)+7
		BYTE	000H
		WORD	00028H
		WORD	00100H*0+(10H*15H)+7
		BYTE	000H
		WORD	00020H
		WORD	00100H*0+(10H*16H)+7
		BYTE	000H
		WORD	00040H
		WORD	00100H*8	;end line
;
BG3_SCR_DAT01	EQU	$		;XN[ f[^
		BYTE	000H
		WORD	0001AH
		WORD	00100H*6+(10H*01H)+7
		BYTE	000H
		WORD	0002EH
		WORD	00100H*6+(10H*05H)+7
		BYTE	000H
		WORD	00019H
		WORD	00100H*6+(10H*07H)+7
		BYTE	000H
		WORD	0002CH
		WORD	00100H*6+(10H*0CH)+7
		BYTE	000H
		WORD	00018H
		WORD	00100H*6+(10H*0DH)+7
		BYTE	000H
		WORD	0002AH
		WORD	00100H*6+(10H*10H)+7
		BYTE	000H
		WORD	00017H
		WORD	00100H*6+(10H*11H)+7
		BYTE	000H
		WORD	00028H
		WORD	00100H*6+(10H*15H)+7
		BYTE	000H
		WORD	00016H
		WORD	00100H*6+(10H*16H)+7
		BYTE	000H
		WORD	000C0H
		WORD	00100H*6+(10H*1BH)+7
		BYTE	000H
		WORD	00140H
		WORD	00100H*8	;end line
;
BG3_SCR_DAT02	EQU	$
		BYTE	000H
		WORD	00016H
		WORD	00100H*6+(10H*17H)+7
;
		BYTE	002H+080H	; X^[XN[
		BYTE	000H
		WORD	00090H
		WORD	00100H*8
		BYTE	0A0H		; 
;
BG3_SCR_DAT03	EQU	$
		BYTE	000H
		WORD	0002AH
		WORD	00100H*0+(10H*02H)+7
		BYTE	000H
		WORD	0001AH
		WORD	00100H*0+(10H*05H)+7
		BYTE	000H
		WORD	00028H
		WORD	00100H*0+(10H*08H)+7
		BYTE	000H
		WORD	00018H
		WORD	00100H*0+(10H*0BH)+7
		BYTE	000
		WORD	00026H
		WORD	00100H*0+(10H*0EH)+7
		BYTE	000H
		WORD	00016H
		WORD	00100H*0+(10H*10H)+7
		BYTE	000H
		WORD	00012H
		WORD	00100H*0+(10H*12H)+7
;
		BYTE	002H+080H	; X^[XN[
		BYTE	000H
		WORD	00010H
		WORD	00100H*0+(10H*16H)+7
		BYTE	010H		; 
;
		BYTE	080H
		BYTE	000H
		WORD	00020H
		WORD	00100H*0+(10H*18H)+7
		BYTE	000H
		WORD	00030H
		WORD	00100H*8	;end line
;
BG3_SCR_DAT06	EQU	$			; Œ茎
		BYTE	000H
		WORD	00000H
		WORD	00100H*0+(10H*01H)+7
		BYTE	000H
		WORD	00020H
		WORD	00100H*0+(10H*03H)+7
		BYTE	000H
		WORD	00000H
		WORD	00100H*0+(10H*04H)+7
		BYTE	000H
		WORD	00000H
		WORD	00100H*0+(10H*06H)+7
		BYTE	000H
		WORD	0001CH
		WORD	00100H*0+(10H*09H)+7
		BYTE	000H
		WORD	0001AH
		WORD	00100H*0+(10H*0CH)+7
		BYTE	000H
		WORD	00000H
		WORD	00100H*0+(10H*0CH)+7
		BYTE	000H
		WORD	00018H
		WORD	00100H*0+(10H*0EH)+7
		BYTE	000H
		WORD	00000H
		WORD	00100H*0+(10H*16H)+7
		BYTE	000H
		WORD	00040H
		WORD	00100H*8	;end line
;
BG3_SCR_DAT07	EQU	$		; 
		BYTE	002H+080H	; X^[XN[
		BYTE	000H
		WORD	00100H
		WORD	00100H*8
		BYTE	008H		; 
;
BG3_SCR_DAT_ADR EQU	$-2
		WORD	BG3_SCR_DAT00,BG3_SCR_DAT01
		WORD	BG3_SCR_DAT02,BG3_SCR_DAT03
		WORD	00000H				;dumy
		WORD	BG3_SCR_DAT06,BG3_SCR_DAT07
;
;
		MEM8
		IDX8
POINT_SCRL30	EQU	$
		LDA	#004
		STA	!BG3SPH_CT
		BRA	POINT_SCRL00
;
POINT_SCRL10	EQU	$
		PHX
		LDX	#DP_DT_00
		JSR	DISP_INIT_SET
		PLX
;
POINT_SCRL00	EQU	$
		LDA	#001H
		STA	!BG3SPFH
		M16			; memory 16bit mode
		LDA	BG3_SCR_DAT_ADR,X
		STA	!BG3SPFH_ADR
;
		MI8			; memory , index 8bit mode
		RTS
;
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+								+
;+		ʎw̐	(CjV Zbg)		+
;+				in				+
;+				X : data read index		+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
DP_DATA_00	EQU	$
		HEX	011H,006H	; main , sub
		WORD	00100H*6+(10H*1BH)+7
		HEX	015H,002H
		WORD	00100H*8	; GhC
;
DP_DATA_01	EQU	$
		HEX	022H,020H
		WORD	00100H*6+(10H*18H)+7
		HEX	022H,062H
		WORD	00100H*8	; GhC
;
DP_DATA_02	EQU	$
;
DP_INT_SCRL	EQU	$
		BYTE	SCCV3-SCCV1
		BYTE	SCCV3-SCCV1
;
DP_DT_00	EQU	00000
DP_DT_01	EQU	DP_DT_00+1
DP_DT_02	EQU	DP_DT_01+1
;
DP_INT_DAT	EQU	$
		WORD	DP_DATA_00,DP_DATA_01
;
HDMA_4341H_DAT	EQU	$
		HEX	02CH,030H
;
;
DISP_INIT_SET	EQU	$
		LDA	DP_INT_SCRL,X
		INC	A
		STA	!DSPCNTRLFG
		M16			; memory 16bit mode
		TXA
		AND	#000FFH
		TAY
		ASL	A
		TAX
		LDA	DP_INT_DAT,X
		STA	!DISP_ADR
		M8			; memory 8bit mode
;
		LDA	#01000001B
		STA	4340H
		LDA	HDMA_4341H_DAT,Y
		STA	4341H
		RTS
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+								+
;+	afRc X^[XN[ CjV Zbg		+
;+								+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
BG3_V_rster_00	EQU	$		; cX^[XN[
		HEX	000H		; X^[ nm
		WORD	00100H*6+(10H*12H)+7+2
		HEX	001H		; X^[ nm
		WORD	00100H*6+(10H*16H)+7-2
		HEX	000H
		WORD	00100H*8	;end line
		HEX	0FFH		; end code
;
NUKI_GRDTN_DT00 EQU	$
		WORD	0000CH		; J[
		WORD	0000CH		; J[
		WORD	000E0H
		WORD	00019H
		WORD	0121FH
		WORD	00040H
		WORD	0121FH
		WORD	00019H
		WORD	00040H
		WORD	0000CH
		WORD	0000CH
		WORD	00050H
		WORD	0FFFFH	; end code
;
NUKI_GRDTN_DT01 EQU	$
		WORD	05E2CH		; J[
		WORD	05E2CH		; J[
		WORD	000E0H
		WORD	06EEEH
		WORD	06EF8H
		WORD	00040H
		WORD	06EF8H
		WORD	06EEEH
		WORD	00040H
		WORD	05E2CH
		WORD	05E2CH
		WORD	00050H
		WORD	0FFFFH	; end code
;
NUKI_GRDTN_DAT	EQU	$
		WORD	NUKI_GRDTN_DT00,NUKI_GRDTN_DT01
;
NK_GRDTN_00	EQU	000
NK_GRDTN_01	EQU	NK_GRDTN_00+2
;
;
POINT_SCRL20	EQU	$
		JSR	POINT_SCRL00
;
		LDY	#NK_GRDTN_00
		LDA	!BG3COL
		AND	#001		; [Of[V ?
		BEQ	POINT_SCRL20_05 ;	YES -> POINT_SCRL20_05
		LDY	#NK_GRDTN_01
POINT_SCRL20_05 EQU	$
		M16			; memory 16bit mode
		LDA	#BANK NUKI_GRDTN_DAT
		STA	R0
		LDA	NUKI_GRDTN_DAT,Y
		STA	R9
		M_CHIP	SPL_GRDTN
;
		LDA	#NUKCOL_BF_B	;to memory address set
		STA	<WORK20
		LDY	#BANK NUKCOL_BF_B
		STY	<WORK22
		LDA	#WOB7CHR	;from memory address set
		STA	<WORK23
		LDY	#BANK WOB7CHR
		STY	<WORK25
		LDA	#NUKCOL_BF_NO*3 ;(A) <-- number of byte set
		JSL	>DMA_M_M	;DMA "ON"
;
		LDA	#BG3_V_rster_00
		STA	!BG3SPFV_ADR
		STZ	!BG3SPV_CT
		STZ	!BG2SPF
		STZ	!BG2SPFV
;
		M8			; memory 8bit mode
		LDA	#012H
		STA	4341H
;
		INC	!GRDTN_FLG
		LDA	!HD420C
		ORA	#00000110B
		STA	!HD420C
;
		INC	!BG3SPFV
;
		RTS
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+								+
;+		ʂ̉Z̐ (CjV Zbg)		+
;+								+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
DISP_COL_SET	EQU	$
		LDA	#017H
		STA	!MANSEL
		LDA	#004H
		STA	!SUBSEL
		LDX	#DP_DT_01
		JSR	DISP_INIT_SET
;
		LDX	#006H
		JSR	POINT_SCRL00
		RTS
;
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+								+
;+		ʂ̉Z					+
;+								+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
DISP_COL_00	EQU	$
		LDA	#0A0H
		STA	!WIND30
		LDA	#064H
		STA	!SUBADF
		RTS
;
;
;--------------------------------------------------------
;-	vC[_E bZ[Wf[^AhX	-
;--------------------------------------------------------
DWNMOJI_DAT	EQU	$
		WORD	DWNMOJI_TMUP,DWNMOJI_PLDW
;
;--------------------------------------------------------
;-	^C Abv bZ[W f[^			-
;--------------------------------------------------------
DWNMOJI_TMUP	EQU	$
		BYTE	0FFH,020H
		BYTE	0BDH,0B2H,0B6H,0AEH,0D0H
		BYTE	0BEH,0B9H
		BYTE	0FDH				; end code
;
;--------------------------------------------------------
;-	vC[_E bZ[W f[^		-
;--------------------------------------------------------
DWNMOJI_PLDW	EQU	$
		BYTE	0FFH,020H
		BYTE	0C2H,0B8H,0BEH,0D0H
		BYTE	0B5H,0B8H,0BCH,0BDH
		BYTE	0FDH				; end code
;
;
;
;
;
;
;
		END
